/* SPDX-License-Identifier: BSD-3-Clause
 * Copyright(c) 2024 Realtek Corporation. All rights reserved
 */

#include "../r8169_compat.h"
#include "../r8169_hw.h"
#include "../r8169_phy.h"
#include "rtl8168h.h"

/* For RTL8168H, CFG_METHOD_29,30,35,36 */

/* ------------------------------------MAC 8168H------------------------------------- */

static void
rtl8168_set_mac_mcu_8168h_1(struct rtl_hw *hw)
{
	rtl_hw_disable_mac_mcu_bps(hw);
}

static void
rtl8168_set_mac_mcu_8168h_2(struct rtl_hw *hw)
{
	u16 i;
	static const u16 mcu_patch_code_8168h_1[] = {
		0xE008, 0xE00F, 0xE011, 0xE047, 0xE049, 0xE073, 0xE075, 0xE07A, 0xC707,
		0x1D00, 0x8DE2, 0x48C1, 0xC502, 0xBD00, 0x00E4, 0xE0C0, 0xC502, 0xBD00,
		0x0216, 0xC634, 0x75C0, 0x49D3, 0xF027, 0xC631, 0x75C0, 0x49D3, 0xF123,
		0xC627, 0x75C0, 0xB405, 0xC525, 0x9DC0, 0xC621, 0x75C8, 0x49D5, 0xF00A,
		0x49D6, 0xF008, 0x49D7, 0xF006, 0x49D8, 0xF004, 0x75D2, 0x49D9, 0xF111,
		0xC517, 0x9DC8, 0xC516, 0x9DD2, 0xC618, 0x75C0, 0x49D4, 0xF003, 0x49D0,
		0xF104, 0xC60A, 0xC50E, 0x9DC0, 0xB005, 0xC607, 0x9DC0, 0xB007, 0xC602,
		0xBE00, 0x1A06, 0xB400, 0xE86C, 0xA000, 0x01E1, 0x0200, 0x9200, 0xE84C,
		0xE004, 0xE908, 0xC502, 0xBD00, 0x0B58, 0xB407, 0xB404, 0x2195, 0x25BD,
		0x9BE0, 0x1C1C, 0x484F, 0x9CE2, 0x72E2, 0x49AE, 0xF1FE, 0x0B00, 0xF116,
		0xC71C, 0xC419, 0x9CE0, 0x1C13, 0x484F, 0x9CE2, 0x74E2, 0x49CE, 0xF1FE,
		0xC412, 0x9CE0, 0x1C13, 0x484F, 0x9CE2, 0x74E2, 0x49CE, 0xF1FE, 0xC70C,
		0x74F8, 0x48C3, 0x8CF8, 0xB004, 0xB007, 0xC502, 0xBD00, 0x0F24, 0x0481,
		0x0C81, 0xDE24, 0xE000, 0xC602, 0xBE00, 0x0CA4, 0x48C1, 0x48C2, 0x9C46,
		0xC402, 0xBC00, 0x0578, 0xC602, 0xBE00, 0x0000
	};

	rtl_hw_disable_mac_mcu_bps(hw);

	for (i = 0; i < ARRAY_SIZE(mcu_patch_code_8168h_1); i++)
		rtl_mac_ocp_write(hw, 0xF800 + i * 2, mcu_patch_code_8168h_1[i]);

	rtl_mac_ocp_write(hw, 0xFC26, 0x8000);

	rtl_mac_ocp_write(hw, 0xFC28, 0x00E2);
	rtl_mac_ocp_write(hw, 0xFC2A, 0x0210);
	rtl_mac_ocp_write(hw, 0xFC2C, 0x1A04);
	rtl_mac_ocp_write(hw, 0xFC2E, 0x0B26);
	rtl_mac_ocp_write(hw, 0xFC30, 0x0F02);
	rtl_mac_ocp_write(hw, 0xFC32, 0x0CA0);

	rtl_mac_ocp_write(hw, 0xFC38, 0x003F);
}

static void
rtl8168_set_mac_mcu_8168h_3(struct rtl_hw *hw)
{
	u16 i;
	static const u16 mcu_patch_code_8168h_3[] = {
		0xE008, 0xE00A, 0xE00C, 0xE00E, 0xE010, 0xE03E, 0xE040, 0xE069, 0xC602,
		0xBE00, 0x0000, 0xC602, 0xBE00, 0x0000, 0xC002, 0xB800, 0x0000, 0xC602,
		0xBE00, 0x0000, 0xC72B, 0x76E2, 0x49EE, 0xF1FD, 0x1E00, 0x9EE0, 0x1E1C,
		0x9EE2, 0x76E2, 0x49EE, 0xF1FE, 0xC621, 0x9EE0, 0x1E1D, 0x486F, 0x9EE2,
		0x76E2, 0x49EE, 0xF1FE, 0xC71A, 0x76E0, 0x48E8, 0x48E9, 0x48EA, 0x48EB,
		0x48EC, 0x9EE0, 0xC70D, 0xC60D, 0x9EF4, 0xC60C, 0x9EF6, 0xC70E, 0x76E0,
		0x4863, 0x9EE0, 0xB007, 0xC602, 0xBE00, 0x0ACC, 0xE000, 0x03BF, 0x07FF,
		0xDE24, 0x3200, 0xE096, 0xD438, 0xC602, 0xBE00, 0x0000, 0x8EE6, 0xC726,
		0x76E2, 0x49EE, 0xF1FD, 0x1E00, 0x8EE0, 0x1E1C, 0x8EE2, 0x76E2, 0x49EE,
		0xF1FE, 0xC61C, 0x8EE0, 0x1E1D, 0x486F, 0x8EE2, 0x76E2, 0x49EE, 0xF1FE,
		0xC715, 0x76E0, 0x48E8, 0x48E9, 0x48EA, 0x48EB, 0x48EC, 0x9EE0, 0xC708,
		0xC608, 0x9EF4, 0xC607, 0x9EF6, 0xC602, 0xBE00, 0x0ABE, 0xE000, 0x03BF,
		0x07FF, 0xDE24, 0x3200, 0xE096, 0xC602, 0xBE00, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x6838, 0x0A17, 0x0613, 0x0D26
	};

	rtl_hw_disable_mac_mcu_bps(hw);

	for (i = 0; i < ARRAY_SIZE(mcu_patch_code_8168h_3); i++)
		rtl_mac_ocp_write(hw, 0xF800 + i * 2, mcu_patch_code_8168h_3[i]);

	rtl_mac_ocp_write(hw, 0xFC26, 0x8000);

	rtl_mac_ocp_write(hw, 0xFC30, 0x0ACA);

	rtl8168_clear_mcu_ocp_bit(hw, 0xD438, BIT_3);

	rtl_mac_ocp_write(hw, 0xFC38, 0x0010);
}

static void
rtl8168_set_mac_mcu_8168h_4(struct rtl_hw *hw)
{
	rtl_hw_disable_mac_mcu_bps(hw);
}

/* ------------------------------------PHY 8168H------------------------------------- */

static void
rtl8168_set_phy_mcu_8168h_1(struct rtl_hw *hw)
{
	unsigned int gphy_val;

	rtl_set_phy_mcu_patch_request(hw);

	rtl_mdio_write(hw, 0x1f, 0x0A43);
	rtl_mdio_write(hw, 0x13, 0x8028);
	rtl_mdio_write(hw, 0x14, 0x6200);
	rtl_mdio_write(hw, 0x13, 0xB82E);
	rtl_mdio_write(hw, 0x14, 0x0001);

	rtl_mdio_write(hw, 0x1F, 0x0A43);
	rtl_mdio_write(hw, 0x13, 0xB820);
	rtl_mdio_write(hw, 0x14, 0x0290);
	rtl_mdio_write(hw, 0x13, 0xA012);
	rtl_mdio_write(hw, 0x14, 0x0000);
	rtl_mdio_write(hw, 0x13, 0xA014);
	rtl_mdio_write(hw, 0x14, 0x2c04);
	rtl_mdio_write(hw, 0x14, 0x2c10);
	rtl_mdio_write(hw, 0x14, 0x2c10);
	rtl_mdio_write(hw, 0x14, 0x2c10);
	rtl_mdio_write(hw, 0x14, 0xa210);
	rtl_mdio_write(hw, 0x14, 0xa101);
	rtl_mdio_write(hw, 0x14, 0xce10);
	rtl_mdio_write(hw, 0x14, 0xe070);
	rtl_mdio_write(hw, 0x14, 0x0f40);
	rtl_mdio_write(hw, 0x14, 0xaf01);
	rtl_mdio_write(hw, 0x14, 0x8f01);
	rtl_mdio_write(hw, 0x14, 0x183e);
	rtl_mdio_write(hw, 0x14, 0x8e10);
	rtl_mdio_write(hw, 0x14, 0x8101);
	rtl_mdio_write(hw, 0x14, 0x8210);
	rtl_mdio_write(hw, 0x14, 0x28da);
	rtl_mdio_write(hw, 0x13, 0xA01A);
	rtl_mdio_write(hw, 0x14, 0x0000);
	rtl_mdio_write(hw, 0x13, 0xA006);
	rtl_mdio_write(hw, 0x14, 0x0017);
	rtl_mdio_write(hw, 0x13, 0xA004);
	rtl_mdio_write(hw, 0x14, 0x0015);
	rtl_mdio_write(hw, 0x13, 0xA002);
	rtl_mdio_write(hw, 0x14, 0x0013);
	rtl_mdio_write(hw, 0x13, 0xA000);
	rtl_mdio_write(hw, 0x14, 0x18d1);
	rtl_mdio_write(hw, 0x13, 0xB820);
	rtl_mdio_write(hw, 0x14, 0x0210);

	rtl_mdio_write(hw, 0x1F, 0x0A43);
	rtl_mdio_write(hw, 0x13, 0x0000);
	rtl_mdio_write(hw, 0x14, 0x0000);
	rtl_mdio_write(hw, 0x1f, 0x0B82);
	gphy_val = rtl_mdio_read(hw, 0x17);
	gphy_val &= ~BIT_0;
	rtl_mdio_write(hw, 0x17, gphy_val);
	rtl_mdio_write(hw, 0x1f, 0x0A43);
	rtl_mdio_write(hw, 0x13, 0x8028);
	rtl_mdio_write(hw, 0x14, 0x0000);

	rtl_clear_phy_mcu_patch_request(hw);
}

static void
rtl8168_set_phy_mcu_8168h_2(struct rtl_hw *hw)
{
	unsigned int gphy_val;

	rtl_set_phy_mcu_patch_request(hw);

	rtl_mdio_write(hw, 0x1f, 0x0A43);
	rtl_mdio_write(hw, 0x13, 0x8028);
	rtl_mdio_write(hw, 0x14, 0x6201);
	rtl_mdio_write(hw, 0x13, 0xB82E);
	rtl_mdio_write(hw, 0x14, 0x0001);

	rtl_mdio_write(hw, 0x1F, 0x0A43);
	rtl_mdio_write(hw, 0x13, 0xB820);
	rtl_mdio_write(hw, 0x14, 0x0290);
	rtl_mdio_write(hw, 0x13, 0xA012);
	rtl_mdio_write(hw, 0x14, 0x0000);
	rtl_mdio_write(hw, 0x13, 0xA014);
	rtl_mdio_write(hw, 0x14, 0x2c04);
	rtl_mdio_write(hw, 0x14, 0x2c09);
	rtl_mdio_write(hw, 0x14, 0x2c0d);
	rtl_mdio_write(hw, 0x14, 0x2c12);
	rtl_mdio_write(hw, 0x14, 0xad01);
	rtl_mdio_write(hw, 0x14, 0xad01);
	rtl_mdio_write(hw, 0x14, 0xad01);
	rtl_mdio_write(hw, 0x14, 0xad01);
	rtl_mdio_write(hw, 0x14, 0x236c);
	rtl_mdio_write(hw, 0x14, 0xd03c);
	rtl_mdio_write(hw, 0x14, 0xd1aa);
	rtl_mdio_write(hw, 0x14, 0xc010);
	rtl_mdio_write(hw, 0x14, 0x2745);
	rtl_mdio_write(hw, 0x14, 0x33de);
	rtl_mdio_write(hw, 0x14, 0x16ba);
	rtl_mdio_write(hw, 0x14, 0x31ee);
	rtl_mdio_write(hw, 0x14, 0x2712);
	rtl_mdio_write(hw, 0x14, 0x274e);
	rtl_mdio_write(hw, 0x14, 0xc2bb);
	rtl_mdio_write(hw, 0x14, 0xd500);
	rtl_mdio_write(hw, 0x14, 0xc426);
	rtl_mdio_write(hw, 0x14, 0xd01d);
	rtl_mdio_write(hw, 0x14, 0xd1c3);
	rtl_mdio_write(hw, 0x14, 0x401c);
	rtl_mdio_write(hw, 0x14, 0xd501);
	rtl_mdio_write(hw, 0x14, 0xc2b3);
	rtl_mdio_write(hw, 0x14, 0xd500);
	rtl_mdio_write(hw, 0x14, 0xd00b);
	rtl_mdio_write(hw, 0x14, 0xd1c3);
	rtl_mdio_write(hw, 0x14, 0x401c);
	rtl_mdio_write(hw, 0x14, 0x241a);
	rtl_mdio_write(hw, 0x13, 0xA01A);
	rtl_mdio_write(hw, 0x14, 0x0000);
	rtl_mdio_write(hw, 0x13, 0xA006);
	rtl_mdio_write(hw, 0x14, 0x0414);
	rtl_mdio_write(hw, 0x13, 0xA004);
	rtl_mdio_write(hw, 0x14, 0x074c);
	rtl_mdio_write(hw, 0x13, 0xA002);
	rtl_mdio_write(hw, 0x14, 0x0744);
	rtl_mdio_write(hw, 0x13, 0xA000);
	rtl_mdio_write(hw, 0x14, 0xf36b);
	rtl_mdio_write(hw, 0x13, 0xB820);
	rtl_mdio_write(hw, 0x14, 0x0210);

	rtl_mdio_write(hw, 0x1F, 0x0A43);
	rtl_mdio_write(hw, 0x13, 0x8323);
	rtl_mdio_write(hw, 0x14, 0xaf83);
	rtl_mdio_write(hw, 0x14, 0x2faf);
	rtl_mdio_write(hw, 0x14, 0x853d);
	rtl_mdio_write(hw, 0x14, 0xaf85);
	rtl_mdio_write(hw, 0x14, 0x3daf);
	rtl_mdio_write(hw, 0x14, 0x853d);
	rtl_mdio_write(hw, 0x14, 0xe082);
	rtl_mdio_write(hw, 0x14, 0x45ad);
	rtl_mdio_write(hw, 0x14, 0x2052);
	rtl_mdio_write(hw, 0x14, 0xe082);
	rtl_mdio_write(hw, 0x14, 0x7ae3);
	rtl_mdio_write(hw, 0x14, 0x85fe);
	rtl_mdio_write(hw, 0x14, 0x1a03);
	rtl_mdio_write(hw, 0x14, 0x10e4);
	rtl_mdio_write(hw, 0x14, 0x85f6);
	rtl_mdio_write(hw, 0x14, 0xe082);
	rtl_mdio_write(hw, 0x14, 0x7a1b);
	rtl_mdio_write(hw, 0x14, 0x03e4);
	rtl_mdio_write(hw, 0x14, 0x85fa);
	rtl_mdio_write(hw, 0x14, 0xe082);
	rtl_mdio_write(hw, 0x14, 0x7be3);
	rtl_mdio_write(hw, 0x14, 0x85fe);
	rtl_mdio_write(hw, 0x14, 0x1a03);
	rtl_mdio_write(hw, 0x14, 0x10e4);
	rtl_mdio_write(hw, 0x14, 0x85f7);
	rtl_mdio_write(hw, 0x14, 0xe082);
	rtl_mdio_write(hw, 0x14, 0x7b1b);
	rtl_mdio_write(hw, 0x14, 0x03e4);
	rtl_mdio_write(hw, 0x14, 0x85fb);
	rtl_mdio_write(hw, 0x14, 0xe082);
	rtl_mdio_write(hw, 0x14, 0x7ce3);
	rtl_mdio_write(hw, 0x14, 0x85fe);
	rtl_mdio_write(hw, 0x14, 0x1a03);
	rtl_mdio_write(hw, 0x14, 0x10e4);
	rtl_mdio_write(hw, 0x14, 0x85f8);
	rtl_mdio_write(hw, 0x14, 0xe082);
	rtl_mdio_write(hw, 0x14, 0x7c1b);
	rtl_mdio_write(hw, 0x14, 0x03e4);
	rtl_mdio_write(hw, 0x14, 0x85fc);
	rtl_mdio_write(hw, 0x14, 0xe082);
	rtl_mdio_write(hw, 0x14, 0x7de3);
	rtl_mdio_write(hw, 0x14, 0x85fe);
	rtl_mdio_write(hw, 0x14, 0x1a03);
	rtl_mdio_write(hw, 0x14, 0x10e4);
	rtl_mdio_write(hw, 0x14, 0x85f9);
	rtl_mdio_write(hw, 0x14, 0xe082);
	rtl_mdio_write(hw, 0x14, 0x7d1b);
	rtl_mdio_write(hw, 0x14, 0x03e4);
	rtl_mdio_write(hw, 0x14, 0x85fd);
	rtl_mdio_write(hw, 0x14, 0xae50);
	rtl_mdio_write(hw, 0x14, 0xe082);
	rtl_mdio_write(hw, 0x14, 0x7ee3);
	rtl_mdio_write(hw, 0x14, 0x85ff);
	rtl_mdio_write(hw, 0x14, 0x1a03);
	rtl_mdio_write(hw, 0x14, 0x10e4);
	rtl_mdio_write(hw, 0x14, 0x85f6);
	rtl_mdio_write(hw, 0x14, 0xe082);
	rtl_mdio_write(hw, 0x14, 0x7e1b);
	rtl_mdio_write(hw, 0x14, 0x03e4);
	rtl_mdio_write(hw, 0x14, 0x85fa);
	rtl_mdio_write(hw, 0x14, 0xe082);
	rtl_mdio_write(hw, 0x14, 0x7fe3);
	rtl_mdio_write(hw, 0x14, 0x85ff);
	rtl_mdio_write(hw, 0x14, 0x1a03);
	rtl_mdio_write(hw, 0x14, 0x10e4);
	rtl_mdio_write(hw, 0x14, 0x85f7);
	rtl_mdio_write(hw, 0x14, 0xe082);
	rtl_mdio_write(hw, 0x14, 0x7f1b);
	rtl_mdio_write(hw, 0x14, 0x03e4);
	rtl_mdio_write(hw, 0x14, 0x85fb);
	rtl_mdio_write(hw, 0x14, 0xe082);
	rtl_mdio_write(hw, 0x14, 0x80e3);
	rtl_mdio_write(hw, 0x14, 0x85ff);
	rtl_mdio_write(hw, 0x14, 0x1a03);
	rtl_mdio_write(hw, 0x14, 0x10e4);
	rtl_mdio_write(hw, 0x14, 0x85f8);
	rtl_mdio_write(hw, 0x14, 0xe082);
	rtl_mdio_write(hw, 0x14, 0x801b);
	rtl_mdio_write(hw, 0x14, 0x03e4);
	rtl_mdio_write(hw, 0x14, 0x85fc);
	rtl_mdio_write(hw, 0x14, 0xe082);
	rtl_mdio_write(hw, 0x14, 0x81e3);
	rtl_mdio_write(hw, 0x14, 0x85ff);
	rtl_mdio_write(hw, 0x14, 0x1a03);
	rtl_mdio_write(hw, 0x14, 0x10e4);
	rtl_mdio_write(hw, 0x14, 0x85f9);
	rtl_mdio_write(hw, 0x14, 0xe082);
	rtl_mdio_write(hw, 0x14, 0x811b);
	rtl_mdio_write(hw, 0x14, 0x03e4);
	rtl_mdio_write(hw, 0x14, 0x85fd);
	rtl_mdio_write(hw, 0x14, 0xe085);
	rtl_mdio_write(hw, 0x14, 0xf6ad);
	rtl_mdio_write(hw, 0x14, 0x2404);
	rtl_mdio_write(hw, 0x14, 0xee85);
	rtl_mdio_write(hw, 0x14, 0xf610);
	rtl_mdio_write(hw, 0x14, 0xe085);
	rtl_mdio_write(hw, 0x14, 0xf7ad);
	rtl_mdio_write(hw, 0x14, 0x2404);
	rtl_mdio_write(hw, 0x14, 0xee85);
	rtl_mdio_write(hw, 0x14, 0xf710);
	rtl_mdio_write(hw, 0x14, 0xe085);
	rtl_mdio_write(hw, 0x14, 0xf8ad);
	rtl_mdio_write(hw, 0x14, 0x2404);
	rtl_mdio_write(hw, 0x14, 0xee85);
	rtl_mdio_write(hw, 0x14, 0xf810);
	rtl_mdio_write(hw, 0x14, 0xe085);
	rtl_mdio_write(hw, 0x14, 0xf9ad);
	rtl_mdio_write(hw, 0x14, 0x2404);
	rtl_mdio_write(hw, 0x14, 0xee85);
	rtl_mdio_write(hw, 0x14, 0xf910);
	rtl_mdio_write(hw, 0x14, 0xe085);
	rtl_mdio_write(hw, 0x14, 0xfaad);
	rtl_mdio_write(hw, 0x14, 0x2704);
	rtl_mdio_write(hw, 0x14, 0xee85);
	rtl_mdio_write(hw, 0x14, 0xfa00);
	rtl_mdio_write(hw, 0x14, 0xe085);
	rtl_mdio_write(hw, 0x14, 0xfbad);
	rtl_mdio_write(hw, 0x14, 0x2704);
	rtl_mdio_write(hw, 0x14, 0xee85);
	rtl_mdio_write(hw, 0x14, 0xfb00);
	rtl_mdio_write(hw, 0x14, 0xe085);
	rtl_mdio_write(hw, 0x14, 0xfcad);
	rtl_mdio_write(hw, 0x14, 0x2704);
	rtl_mdio_write(hw, 0x14, 0xee85);
	rtl_mdio_write(hw, 0x14, 0xfc00);
	rtl_mdio_write(hw, 0x14, 0xe085);
	rtl_mdio_write(hw, 0x14, 0xfdad);
	rtl_mdio_write(hw, 0x14, 0x2704);
	rtl_mdio_write(hw, 0x14, 0xee85);
	rtl_mdio_write(hw, 0x14, 0xfd00);
	rtl_mdio_write(hw, 0x14, 0xe082);
	rtl_mdio_write(hw, 0x14, 0x44ad);
	rtl_mdio_write(hw, 0x14, 0x203f);
	rtl_mdio_write(hw, 0x14, 0xe085);
	rtl_mdio_write(hw, 0x14, 0xf6e4);
	rtl_mdio_write(hw, 0x14, 0x8288);
	rtl_mdio_write(hw, 0x14, 0xe085);
	rtl_mdio_write(hw, 0x14, 0xfae4);
	rtl_mdio_write(hw, 0x14, 0x8289);
	rtl_mdio_write(hw, 0x14, 0xe082);
	rtl_mdio_write(hw, 0x14, 0x440d);
	rtl_mdio_write(hw, 0x14, 0x0458);
	rtl_mdio_write(hw, 0x14, 0x01bf);
	rtl_mdio_write(hw, 0x14, 0x8264);
	rtl_mdio_write(hw, 0x14, 0x0215);
	rtl_mdio_write(hw, 0x14, 0x38bf);
	rtl_mdio_write(hw, 0x14, 0x824e);
	rtl_mdio_write(hw, 0x14, 0x0213);
	rtl_mdio_write(hw, 0x14, 0x06a0);
	rtl_mdio_write(hw, 0x14, 0x010f);
	rtl_mdio_write(hw, 0x14, 0xe082);
	rtl_mdio_write(hw, 0x14, 0x44f6);
	rtl_mdio_write(hw, 0x14, 0x20e4);
	rtl_mdio_write(hw, 0x14, 0x8244);
	rtl_mdio_write(hw, 0x14, 0x580f);
	rtl_mdio_write(hw, 0x14, 0xe582);
	rtl_mdio_write(hw, 0x14, 0x5aae);
	rtl_mdio_write(hw, 0x14, 0x0ebf);
	rtl_mdio_write(hw, 0x14, 0x825e);
	rtl_mdio_write(hw, 0x14, 0xe382);
	rtl_mdio_write(hw, 0x14, 0x44f7);
	rtl_mdio_write(hw, 0x14, 0x3ce7);
	rtl_mdio_write(hw, 0x14, 0x8244);
	rtl_mdio_write(hw, 0x14, 0x0212);
	rtl_mdio_write(hw, 0x14, 0xf0ad);
	rtl_mdio_write(hw, 0x14, 0x213f);
	rtl_mdio_write(hw, 0x14, 0xe085);
	rtl_mdio_write(hw, 0x14, 0xf7e4);
	rtl_mdio_write(hw, 0x14, 0x8288);
	rtl_mdio_write(hw, 0x14, 0xe085);
	rtl_mdio_write(hw, 0x14, 0xfbe4);
	rtl_mdio_write(hw, 0x14, 0x8289);
	rtl_mdio_write(hw, 0x14, 0xe082);
	rtl_mdio_write(hw, 0x14, 0x440d);
	rtl_mdio_write(hw, 0x14, 0x0558);
	rtl_mdio_write(hw, 0x14, 0x01bf);
	rtl_mdio_write(hw, 0x14, 0x826b);
	rtl_mdio_write(hw, 0x14, 0x0215);
	rtl_mdio_write(hw, 0x14, 0x38bf);
	rtl_mdio_write(hw, 0x14, 0x824f);
	rtl_mdio_write(hw, 0x14, 0x0213);
	rtl_mdio_write(hw, 0x14, 0x06a0);
	rtl_mdio_write(hw, 0x14, 0x010f);
	rtl_mdio_write(hw, 0x14, 0xe082);
	rtl_mdio_write(hw, 0x14, 0x44f6);
	rtl_mdio_write(hw, 0x14, 0x21e4);
	rtl_mdio_write(hw, 0x14, 0x8244);
	rtl_mdio_write(hw, 0x14, 0x580f);
	rtl_mdio_write(hw, 0x14, 0xe582);
	rtl_mdio_write(hw, 0x14, 0x5bae);
	rtl_mdio_write(hw, 0x14, 0x0ebf);
	rtl_mdio_write(hw, 0x14, 0x8265);
	rtl_mdio_write(hw, 0x14, 0xe382);
	rtl_mdio_write(hw, 0x14, 0x44f7);
	rtl_mdio_write(hw, 0x14, 0x3de7);
	rtl_mdio_write(hw, 0x14, 0x8244);
	rtl_mdio_write(hw, 0x14, 0x0212);
	rtl_mdio_write(hw, 0x14, 0xf0ad);
	rtl_mdio_write(hw, 0x14, 0x223f);
	rtl_mdio_write(hw, 0x14, 0xe085);
	rtl_mdio_write(hw, 0x14, 0xf8e4);
	rtl_mdio_write(hw, 0x14, 0x8288);
	rtl_mdio_write(hw, 0x14, 0xe085);
	rtl_mdio_write(hw, 0x14, 0xfce4);
	rtl_mdio_write(hw, 0x14, 0x8289);
	rtl_mdio_write(hw, 0x14, 0xe082);
	rtl_mdio_write(hw, 0x14, 0x440d);
	rtl_mdio_write(hw, 0x14, 0x0658);
	rtl_mdio_write(hw, 0x14, 0x01bf);
	rtl_mdio_write(hw, 0x14, 0x8272);
	rtl_mdio_write(hw, 0x14, 0x0215);
	rtl_mdio_write(hw, 0x14, 0x38bf);
	rtl_mdio_write(hw, 0x14, 0x8250);
	rtl_mdio_write(hw, 0x14, 0x0213);
	rtl_mdio_write(hw, 0x14, 0x06a0);
	rtl_mdio_write(hw, 0x14, 0x010f);
	rtl_mdio_write(hw, 0x14, 0xe082);
	rtl_mdio_write(hw, 0x14, 0x44f6);
	rtl_mdio_write(hw, 0x14, 0x22e4);
	rtl_mdio_write(hw, 0x14, 0x8244);
	rtl_mdio_write(hw, 0x14, 0x580f);
	rtl_mdio_write(hw, 0x14, 0xe582);
	rtl_mdio_write(hw, 0x14, 0x5cae);
	rtl_mdio_write(hw, 0x14, 0x0ebf);
	rtl_mdio_write(hw, 0x14, 0x826c);
	rtl_mdio_write(hw, 0x14, 0xe382);
	rtl_mdio_write(hw, 0x14, 0x44f7);
	rtl_mdio_write(hw, 0x14, 0x3ee7);
	rtl_mdio_write(hw, 0x14, 0x8244);
	rtl_mdio_write(hw, 0x14, 0x0212);
	rtl_mdio_write(hw, 0x14, 0xf0ad);
	rtl_mdio_write(hw, 0x14, 0x233f);
	rtl_mdio_write(hw, 0x14, 0xe085);
	rtl_mdio_write(hw, 0x14, 0xf9e4);
	rtl_mdio_write(hw, 0x14, 0x8288);
	rtl_mdio_write(hw, 0x14, 0xe085);
	rtl_mdio_write(hw, 0x14, 0xfde4);
	rtl_mdio_write(hw, 0x14, 0x8289);
	rtl_mdio_write(hw, 0x14, 0xe082);
	rtl_mdio_write(hw, 0x14, 0x440d);
	rtl_mdio_write(hw, 0x14, 0x0758);
	rtl_mdio_write(hw, 0x14, 0x01bf);
	rtl_mdio_write(hw, 0x14, 0x8279);
	rtl_mdio_write(hw, 0x14, 0x0215);
	rtl_mdio_write(hw, 0x14, 0x38bf);
	rtl_mdio_write(hw, 0x14, 0x8251);
	rtl_mdio_write(hw, 0x14, 0x0213);
	rtl_mdio_write(hw, 0x14, 0x06a0);
	rtl_mdio_write(hw, 0x14, 0x010f);
	rtl_mdio_write(hw, 0x14, 0xe082);
	rtl_mdio_write(hw, 0x14, 0x44f6);
	rtl_mdio_write(hw, 0x14, 0x23e4);
	rtl_mdio_write(hw, 0x14, 0x8244);
	rtl_mdio_write(hw, 0x14, 0x580f);
	rtl_mdio_write(hw, 0x14, 0xe582);
	rtl_mdio_write(hw, 0x14, 0x5dae);
	rtl_mdio_write(hw, 0x14, 0x0ebf);
	rtl_mdio_write(hw, 0x14, 0x8273);
	rtl_mdio_write(hw, 0x14, 0xe382);
	rtl_mdio_write(hw, 0x14, 0x44f7);
	rtl_mdio_write(hw, 0x14, 0x3fe7);
	rtl_mdio_write(hw, 0x14, 0x8244);
	rtl_mdio_write(hw, 0x14, 0x0212);
	rtl_mdio_write(hw, 0x14, 0xf0ee);
	rtl_mdio_write(hw, 0x14, 0x8288);
	rtl_mdio_write(hw, 0x14, 0x10ee);
	rtl_mdio_write(hw, 0x14, 0x8289);
	rtl_mdio_write(hw, 0x14, 0x00af);
	rtl_mdio_write(hw, 0x14, 0x14aa);
	rtl_mdio_write(hw, 0x13, 0xb818);
	rtl_mdio_write(hw, 0x14, 0x13cf);
	rtl_mdio_write(hw, 0x13, 0xb81a);
	rtl_mdio_write(hw, 0x14, 0xfffd);
	rtl_mdio_write(hw, 0x13, 0xb81c);
	rtl_mdio_write(hw, 0x14, 0xfffd);
	rtl_mdio_write(hw, 0x13, 0xb81e);
	rtl_mdio_write(hw, 0x14, 0xfffd);
	rtl_mdio_write(hw, 0x13, 0xb832);
	rtl_mdio_write(hw, 0x14, 0x0001);

	rtl_mdio_write(hw, 0x1F, 0x0A43);
	rtl_mdio_write(hw, 0x13, 0x0000);
	rtl_mdio_write(hw, 0x14, 0x0000);
	rtl_mdio_write(hw, 0x1f, 0x0B82);
	gphy_val = rtl_mdio_read(hw, 0x17);
	gphy_val &= ~BIT_0;
	rtl_mdio_write(hw, 0x17, gphy_val);
	rtl_mdio_write(hw, 0x1f, 0x0A43);
	rtl_mdio_write(hw, 0x13, 0x8028);
	rtl_mdio_write(hw, 0x14, 0x0000);

	rtl_clear_phy_mcu_patch_request(hw);
}

static void
rtl8168_set_phy_mcu_8168h_3(struct rtl_hw *hw)
{
	unsigned int gphy_val;

	rtl_set_phy_mcu_patch_request(hw);

	rtl_mdio_write(hw, 0x1f, 0x0A43);
	rtl_mdio_write(hw, 0x13, 0x8042);
	rtl_mdio_write(hw, 0x14, 0x3800);
	rtl_mdio_write(hw, 0x13, 0xB82E);
	rtl_mdio_write(hw, 0x14, 0x0001);

	rtl_mdio_write(hw, 0x1F, 0x0A43);
	rtl_mdio_write(hw, 0x13, 0xB820);
	rtl_mdio_write(hw, 0x14, 0x0090);
	rtl_mdio_write(hw, 0x13, 0xA016);
	rtl_mdio_write(hw, 0x14, 0x0000);
	rtl_mdio_write(hw, 0x13, 0xA012);
	rtl_mdio_write(hw, 0x14, 0x0000);
	rtl_mdio_write(hw, 0x13, 0xA014);
	rtl_mdio_write(hw, 0x14, 0x1800);
	rtl_mdio_write(hw, 0x14, 0x8010);
	rtl_mdio_write(hw, 0x14, 0x1800);
	rtl_mdio_write(hw, 0x14, 0x8014);
	rtl_mdio_write(hw, 0x14, 0x1800);
	rtl_mdio_write(hw, 0x14, 0x8022);
	rtl_mdio_write(hw, 0x14, 0x1800);
	rtl_mdio_write(hw, 0x14, 0x8022);
	rtl_mdio_write(hw, 0x14, 0x1800);
	rtl_mdio_write(hw, 0x14, 0x8022);
	rtl_mdio_write(hw, 0x14, 0x1800);
	rtl_mdio_write(hw, 0x14, 0x8022);
	rtl_mdio_write(hw, 0x14, 0x1800);
	rtl_mdio_write(hw, 0x14, 0x8022);
	rtl_mdio_write(hw, 0x14, 0x1800);
	rtl_mdio_write(hw, 0x14, 0x8022);
	rtl_mdio_write(hw, 0x14, 0x2b5d);
	rtl_mdio_write(hw, 0x14, 0x0c68);
	rtl_mdio_write(hw, 0x14, 0x1800);
	rtl_mdio_write(hw, 0x14, 0x0b3c);
	rtl_mdio_write(hw, 0x14, 0xc2bb);
	rtl_mdio_write(hw, 0x14, 0xd500);
	rtl_mdio_write(hw, 0x14, 0xc426);
	rtl_mdio_write(hw, 0x14, 0xd01d);
	rtl_mdio_write(hw, 0x14, 0xd1c3);
	rtl_mdio_write(hw, 0x14, 0x401c);
	rtl_mdio_write(hw, 0x14, 0xd501);
	rtl_mdio_write(hw, 0x14, 0xc2b3);
	rtl_mdio_write(hw, 0x14, 0xd500);
	rtl_mdio_write(hw, 0x14, 0xd00b);
	rtl_mdio_write(hw, 0x14, 0xd1c3);
	rtl_mdio_write(hw, 0x14, 0x401c);
	rtl_mdio_write(hw, 0x14, 0x1800);
	rtl_mdio_write(hw, 0x14, 0x0478);
	rtl_mdio_write(hw, 0x13, 0xA026);
	rtl_mdio_write(hw, 0x14, 0x0fff);
	rtl_mdio_write(hw, 0x13, 0xA024);
	rtl_mdio_write(hw, 0x14, 0x0fff);
	rtl_mdio_write(hw, 0x13, 0xA022);
	rtl_mdio_write(hw, 0x14, 0x0fff);
	rtl_mdio_write(hw, 0x13, 0xA020);
	rtl_mdio_write(hw, 0x14, 0x0fff);
	rtl_mdio_write(hw, 0x13, 0xA006);
	rtl_mdio_write(hw, 0x14, 0x0fff);
	rtl_mdio_write(hw, 0x13, 0xA004);
	rtl_mdio_write(hw, 0x14, 0x0fff);
	rtl_mdio_write(hw, 0x13, 0xA002);
	rtl_mdio_write(hw, 0x14, 0x0472);
	rtl_mdio_write(hw, 0x13, 0xA000);
	rtl_mdio_write(hw, 0x14, 0x0b3a);
	rtl_mdio_write(hw, 0x13, 0xA008);
	rtl_mdio_write(hw, 0x14, 0x0300);
	rtl_mdio_write(hw, 0x13, 0xB820);
	rtl_mdio_write(hw, 0x14, 0x0010);

	rtl_mdio_write(hw, 0x13, 0x83f3);
	rtl_mdio_write(hw, 0x14, 0xaf84);
	rtl_mdio_write(hw, 0x14, 0x0baf);
	rtl_mdio_write(hw, 0x14, 0x8466);
	rtl_mdio_write(hw, 0x14, 0xaf84);
	rtl_mdio_write(hw, 0x14, 0xcdaf);
	rtl_mdio_write(hw, 0x14, 0x873c);
	rtl_mdio_write(hw, 0x14, 0xaf87);
	rtl_mdio_write(hw, 0x14, 0x3faf);
	rtl_mdio_write(hw, 0x14, 0x8760);
	rtl_mdio_write(hw, 0x14, 0xaf87);
	rtl_mdio_write(hw, 0x14, 0x60af);
	rtl_mdio_write(hw, 0x14, 0x8760);
	rtl_mdio_write(hw, 0x14, 0xef79);
	rtl_mdio_write(hw, 0x14, 0xfb89);
	rtl_mdio_write(hw, 0x14, 0xe987);
	rtl_mdio_write(hw, 0x14, 0xffd7);
	rtl_mdio_write(hw, 0x14, 0x0017);
	rtl_mdio_write(hw, 0x14, 0xd400);
	rtl_mdio_write(hw, 0x14, 0x051c);
	rtl_mdio_write(hw, 0x14, 0x421a);
	rtl_mdio_write(hw, 0x14, 0x741b);
	rtl_mdio_write(hw, 0x14, 0x97e9);
	rtl_mdio_write(hw, 0x14, 0x87fe);
	rtl_mdio_write(hw, 0x14, 0xffef);
	rtl_mdio_write(hw, 0x14, 0x97e0);
	rtl_mdio_write(hw, 0x14, 0x82aa);
	rtl_mdio_write(hw, 0x14, 0xa000);
	rtl_mdio_write(hw, 0x14, 0x08ef);
	rtl_mdio_write(hw, 0x14, 0x46dc);
	rtl_mdio_write(hw, 0x14, 0x19dd);
	rtl_mdio_write(hw, 0x14, 0xaf1a);
	rtl_mdio_write(hw, 0x14, 0x37a0);
	rtl_mdio_write(hw, 0x14, 0x012d);
	rtl_mdio_write(hw, 0x14, 0xe082);
	rtl_mdio_write(hw, 0x14, 0xa7ac);
	rtl_mdio_write(hw, 0x14, 0x2013);
	rtl_mdio_write(hw, 0x14, 0xe087);
	rtl_mdio_write(hw, 0x14, 0xffe1);
	rtl_mdio_write(hw, 0x14, 0x87fe);
	rtl_mdio_write(hw, 0x14, 0xac27);
	rtl_mdio_write(hw, 0x14, 0x05a1);
	rtl_mdio_write(hw, 0x14, 0x0807);
	rtl_mdio_write(hw, 0x14, 0xae0f);
	rtl_mdio_write(hw, 0x14, 0xa107);
	rtl_mdio_write(hw, 0x14, 0x02ae);
	rtl_mdio_write(hw, 0x14, 0x0aef);
	rtl_mdio_write(hw, 0x14, 0x4619);
	rtl_mdio_write(hw, 0x14, 0x19dc);
	rtl_mdio_write(hw, 0x14, 0x19dd);
	rtl_mdio_write(hw, 0x14, 0xaf1a);
	rtl_mdio_write(hw, 0x14, 0x37d8);
	rtl_mdio_write(hw, 0x14, 0x19d9);
	rtl_mdio_write(hw, 0x14, 0x19dc);
	rtl_mdio_write(hw, 0x14, 0x19dd);
	rtl_mdio_write(hw, 0x14, 0xaf1a);
	rtl_mdio_write(hw, 0x14, 0x3719);
	rtl_mdio_write(hw, 0x14, 0x19ae);
	rtl_mdio_write(hw, 0x14, 0xcfbf);
	rtl_mdio_write(hw, 0x14, 0x878a);
	rtl_mdio_write(hw, 0x14, 0x0244);
	rtl_mdio_write(hw, 0x14, 0xdc3c);
	rtl_mdio_write(hw, 0x14, 0x0005);
	rtl_mdio_write(hw, 0x14, 0xaaf5);
	rtl_mdio_write(hw, 0x14, 0x0249);
	rtl_mdio_write(hw, 0x14, 0xcaef);
	rtl_mdio_write(hw, 0x14, 0x67d7);
	rtl_mdio_write(hw, 0x14, 0x0014);
	rtl_mdio_write(hw, 0x14, 0x0249);
	rtl_mdio_write(hw, 0x14, 0xe5ad);
	rtl_mdio_write(hw, 0x14, 0x50f7);
	rtl_mdio_write(hw, 0x14, 0xd400);
	rtl_mdio_write(hw, 0x14, 0x01bf);
	rtl_mdio_write(hw, 0x14, 0x46a7);
	rtl_mdio_write(hw, 0x14, 0x0244);
	rtl_mdio_write(hw, 0x14, 0x98bf);
	rtl_mdio_write(hw, 0x14, 0x465c);
	rtl_mdio_write(hw, 0x14, 0x024a);
	rtl_mdio_write(hw, 0x14, 0x5fd4);
	rtl_mdio_write(hw, 0x14, 0x0003);
	rtl_mdio_write(hw, 0x14, 0xbf87);
	rtl_mdio_write(hw, 0x14, 0x9c02);
	rtl_mdio_write(hw, 0x14, 0x4498);
	rtl_mdio_write(hw, 0x14, 0xbf87);
	rtl_mdio_write(hw, 0x14, 0x9902);
	rtl_mdio_write(hw, 0x14, 0x4a5f);
	rtl_mdio_write(hw, 0x14, 0xbf87);
	rtl_mdio_write(hw, 0x14, 0x8d02);
	rtl_mdio_write(hw, 0x14, 0x4a5f);
	rtl_mdio_write(hw, 0x14, 0xbf87);
	rtl_mdio_write(hw, 0x14, 0x9002);
	rtl_mdio_write(hw, 0x14, 0x44dc);
	rtl_mdio_write(hw, 0x14, 0xad28);
	rtl_mdio_write(hw, 0x14, 0xf7bf);
	rtl_mdio_write(hw, 0x14, 0x8796);
	rtl_mdio_write(hw, 0x14, 0x0244);
	rtl_mdio_write(hw, 0x14, 0xdcad);
	rtl_mdio_write(hw, 0x14, 0x28f7);
	rtl_mdio_write(hw, 0x14, 0xbf87);
	rtl_mdio_write(hw, 0x14, 0x9302);
	rtl_mdio_write(hw, 0x14, 0x4a5f);
	rtl_mdio_write(hw, 0x14, 0xbf87);
	rtl_mdio_write(hw, 0x14, 0x9302);
	rtl_mdio_write(hw, 0x14, 0x4a56);
	rtl_mdio_write(hw, 0x14, 0xbf46);
	rtl_mdio_write(hw, 0x14, 0x5c02);
	rtl_mdio_write(hw, 0x14, 0x4a56);
	rtl_mdio_write(hw, 0x14, 0xbf45);
	rtl_mdio_write(hw, 0x14, 0x21af);
	rtl_mdio_write(hw, 0x14, 0x020e);
	rtl_mdio_write(hw, 0x14, 0xee82);
	rtl_mdio_write(hw, 0x14, 0x5000);
	rtl_mdio_write(hw, 0x14, 0x0284);
	rtl_mdio_write(hw, 0x14, 0xdd02);
	rtl_mdio_write(hw, 0x14, 0x8521);
	rtl_mdio_write(hw, 0x14, 0x0285);
	rtl_mdio_write(hw, 0x14, 0x36af);
	rtl_mdio_write(hw, 0x14, 0x03d2);
	rtl_mdio_write(hw, 0x14, 0xf8f9);
	rtl_mdio_write(hw, 0x14, 0xfafb);
	rtl_mdio_write(hw, 0x14, 0xef59);
	rtl_mdio_write(hw, 0x14, 0xbf45);
	rtl_mdio_write(hw, 0x14, 0x3002);
	rtl_mdio_write(hw, 0x14, 0x44dc);
	rtl_mdio_write(hw, 0x14, 0x3c00);
	rtl_mdio_write(hw, 0x14, 0x03aa);
	rtl_mdio_write(hw, 0x14, 0x2cbf);
	rtl_mdio_write(hw, 0x14, 0x8790);
	rtl_mdio_write(hw, 0x14, 0x0244);
	rtl_mdio_write(hw, 0x14, 0xdcad);
	rtl_mdio_write(hw, 0x14, 0x2823);
	rtl_mdio_write(hw, 0x14, 0xbf87);
	rtl_mdio_write(hw, 0x14, 0x9602);
	rtl_mdio_write(hw, 0x14, 0x44dc);
	rtl_mdio_write(hw, 0x14, 0xad28);
	rtl_mdio_write(hw, 0x14, 0x1a02);
	rtl_mdio_write(hw, 0x14, 0x49ca);
	rtl_mdio_write(hw, 0x14, 0xef67);
	rtl_mdio_write(hw, 0x14, 0xd700);
	rtl_mdio_write(hw, 0x14, 0x0202);
	rtl_mdio_write(hw, 0x14, 0x49e5);
	rtl_mdio_write(hw, 0x14, 0xad50);
	rtl_mdio_write(hw, 0x14, 0xf7bf);
	rtl_mdio_write(hw, 0x14, 0x8793);
	rtl_mdio_write(hw, 0x14, 0x024a);
	rtl_mdio_write(hw, 0x14, 0x5fbf);
	rtl_mdio_write(hw, 0x14, 0x8793);
	rtl_mdio_write(hw, 0x14, 0x024a);
	rtl_mdio_write(hw, 0x14, 0x56ef);
	rtl_mdio_write(hw, 0x14, 0x95ff);
	rtl_mdio_write(hw, 0x14, 0xfefd);
	rtl_mdio_write(hw, 0x14, 0xfc04);
	rtl_mdio_write(hw, 0x14, 0xf8fa);
	rtl_mdio_write(hw, 0x14, 0xef69);
	rtl_mdio_write(hw, 0x14, 0xe080);
	rtl_mdio_write(hw, 0x14, 0x15ad);
	rtl_mdio_write(hw, 0x14, 0x2406);
	rtl_mdio_write(hw, 0x14, 0xbf87);
	rtl_mdio_write(hw, 0x14, 0x8702);
	rtl_mdio_write(hw, 0x14, 0x4a56);
	rtl_mdio_write(hw, 0x14, 0xef96);
	rtl_mdio_write(hw, 0x14, 0xfefc);
	rtl_mdio_write(hw, 0x14, 0x04f8);
	rtl_mdio_write(hw, 0x14, 0xe087);
	rtl_mdio_write(hw, 0x14, 0xf9e1);
	rtl_mdio_write(hw, 0x14, 0x87fa);
	rtl_mdio_write(hw, 0x14, 0x1b10);
	rtl_mdio_write(hw, 0x14, 0x9f1e);
	rtl_mdio_write(hw, 0x14, 0xee87);
	rtl_mdio_write(hw, 0x14, 0xf900);
	rtl_mdio_write(hw, 0x14, 0xe080);
	rtl_mdio_write(hw, 0x14, 0x15ac);
	rtl_mdio_write(hw, 0x14, 0x2606);
	rtl_mdio_write(hw, 0x14, 0xee87);
	rtl_mdio_write(hw, 0x14, 0xf700);
	rtl_mdio_write(hw, 0x14, 0xae12);
	rtl_mdio_write(hw, 0x14, 0x0286);
	rtl_mdio_write(hw, 0x14, 0x9d02);
	rtl_mdio_write(hw, 0x14, 0x8565);
	rtl_mdio_write(hw, 0x14, 0x0285);
	rtl_mdio_write(hw, 0x14, 0x9d02);
	rtl_mdio_write(hw, 0x14, 0x8660);
	rtl_mdio_write(hw, 0x14, 0xae04);
	rtl_mdio_write(hw, 0x14, 0x10e4);
	rtl_mdio_write(hw, 0x14, 0x87f9);
	rtl_mdio_write(hw, 0x14, 0xfc04);
	rtl_mdio_write(hw, 0x14, 0xf8f9);
	rtl_mdio_write(hw, 0x14, 0xfaef);
	rtl_mdio_write(hw, 0x14, 0x69fa);
	rtl_mdio_write(hw, 0x14, 0xbf45);
	rtl_mdio_write(hw, 0x14, 0x3002);
	rtl_mdio_write(hw, 0x14, 0x44dc);
	rtl_mdio_write(hw, 0x14, 0xa103);
	rtl_mdio_write(hw, 0x14, 0x22e0);
	rtl_mdio_write(hw, 0x14, 0x87eb);
	rtl_mdio_write(hw, 0x14, 0xe187);
	rtl_mdio_write(hw, 0x14, 0xecef);
	rtl_mdio_write(hw, 0x14, 0x64bf);
	rtl_mdio_write(hw, 0x14, 0x876f);
	rtl_mdio_write(hw, 0x14, 0x0244);
	rtl_mdio_write(hw, 0x14, 0xdc1b);
	rtl_mdio_write(hw, 0x14, 0x46aa);
	rtl_mdio_write(hw, 0x14, 0x0abf);
	rtl_mdio_write(hw, 0x14, 0x8772);
	rtl_mdio_write(hw, 0x14, 0x0244);
	rtl_mdio_write(hw, 0x14, 0xdc1b);
	rtl_mdio_write(hw, 0x14, 0x46ab);
	rtl_mdio_write(hw, 0x14, 0x06bf);
	rtl_mdio_write(hw, 0x14, 0x876c);
	rtl_mdio_write(hw, 0x14, 0x024a);
	rtl_mdio_write(hw, 0x14, 0x5ffe);
	rtl_mdio_write(hw, 0x14, 0xef96);
	rtl_mdio_write(hw, 0x14, 0xfefd);
	rtl_mdio_write(hw, 0x14, 0xfc04);
	rtl_mdio_write(hw, 0x14, 0xf8f9);
	rtl_mdio_write(hw, 0x14, 0xef59);
	rtl_mdio_write(hw, 0x14, 0xf9bf);
	rtl_mdio_write(hw, 0x14, 0x4530);
	rtl_mdio_write(hw, 0x14, 0x0244);
	rtl_mdio_write(hw, 0x14, 0xdca1);
	rtl_mdio_write(hw, 0x14, 0x0310);
	rtl_mdio_write(hw, 0x14, 0xe087);
	rtl_mdio_write(hw, 0x14, 0xf7ac);
	rtl_mdio_write(hw, 0x14, 0x2605);
	rtl_mdio_write(hw, 0x14, 0x0285);
	rtl_mdio_write(hw, 0x14, 0xc9ae);
	rtl_mdio_write(hw, 0x14, 0x0d02);
	rtl_mdio_write(hw, 0x14, 0x8613);
	rtl_mdio_write(hw, 0x14, 0xae08);
	rtl_mdio_write(hw, 0x14, 0xe287);
	rtl_mdio_write(hw, 0x14, 0xf7f6);
	rtl_mdio_write(hw, 0x14, 0x36e6);
	rtl_mdio_write(hw, 0x14, 0x87f7);
	rtl_mdio_write(hw, 0x14, 0xfdef);
	rtl_mdio_write(hw, 0x14, 0x95fd);
	rtl_mdio_write(hw, 0x14, 0xfc04);
	rtl_mdio_write(hw, 0x14, 0xf8f9);
	rtl_mdio_write(hw, 0x14, 0xfafb);
	rtl_mdio_write(hw, 0x14, 0xef79);
	rtl_mdio_write(hw, 0x14, 0xfbbf);
	rtl_mdio_write(hw, 0x14, 0x876f);
	rtl_mdio_write(hw, 0x14, 0x0244);
	rtl_mdio_write(hw, 0x14, 0xdcef);
	rtl_mdio_write(hw, 0x14, 0x64e2);
	rtl_mdio_write(hw, 0x14, 0x87e9);
	rtl_mdio_write(hw, 0x14, 0xe387);
	rtl_mdio_write(hw, 0x14, 0xea1b);
	rtl_mdio_write(hw, 0x14, 0x659e);
	rtl_mdio_write(hw, 0x14, 0x10e4);
	rtl_mdio_write(hw, 0x14, 0x87e9);
	rtl_mdio_write(hw, 0x14, 0xe587);
	rtl_mdio_write(hw, 0x14, 0xeae2);
	rtl_mdio_write(hw, 0x14, 0x87f7);
	rtl_mdio_write(hw, 0x14, 0xf636);
	rtl_mdio_write(hw, 0x14, 0xe687);
	rtl_mdio_write(hw, 0x14, 0xf7ae);
	rtl_mdio_write(hw, 0x14, 0x19e2);
	rtl_mdio_write(hw, 0x14, 0x87f7);
	rtl_mdio_write(hw, 0x14, 0xf736);
	rtl_mdio_write(hw, 0x14, 0xe687);
	rtl_mdio_write(hw, 0x14, 0xf700);
	rtl_mdio_write(hw, 0x14, 0x00ae);
	rtl_mdio_write(hw, 0x14, 0x0200);
	rtl_mdio_write(hw, 0x14, 0x0002);
	rtl_mdio_write(hw, 0x14, 0x49ca);
	rtl_mdio_write(hw, 0x14, 0xef57);
	rtl_mdio_write(hw, 0x14, 0xe687);
	rtl_mdio_write(hw, 0x14, 0xe7e7);
	rtl_mdio_write(hw, 0x14, 0x87e8);
	rtl_mdio_write(hw, 0x14, 0xffef);
	rtl_mdio_write(hw, 0x14, 0x97ff);
	rtl_mdio_write(hw, 0x14, 0xfefd);
	rtl_mdio_write(hw, 0x14, 0xfc04);
	rtl_mdio_write(hw, 0x14, 0xf8f9);
	rtl_mdio_write(hw, 0x14, 0xfafb);
	rtl_mdio_write(hw, 0x14, 0xef79);
	rtl_mdio_write(hw, 0x14, 0xfbe2);
	rtl_mdio_write(hw, 0x14, 0x87e7);
	rtl_mdio_write(hw, 0x14, 0xe387);
	rtl_mdio_write(hw, 0x14, 0xe8ef);
	rtl_mdio_write(hw, 0x14, 0x65e2);
	rtl_mdio_write(hw, 0x14, 0x87fb);
	rtl_mdio_write(hw, 0x14, 0xe387);
	rtl_mdio_write(hw, 0x14, 0xfcef);
	rtl_mdio_write(hw, 0x14, 0x7502);
	rtl_mdio_write(hw, 0x14, 0x49e5);
	rtl_mdio_write(hw, 0x14, 0xac50);
	rtl_mdio_write(hw, 0x14, 0x1abf);
	rtl_mdio_write(hw, 0x14, 0x876f);
	rtl_mdio_write(hw, 0x14, 0x0244);
	rtl_mdio_write(hw, 0x14, 0xdcef);
	rtl_mdio_write(hw, 0x14, 0x64e2);
	rtl_mdio_write(hw, 0x14, 0x87e9);
	rtl_mdio_write(hw, 0x14, 0xe387);
	rtl_mdio_write(hw, 0x14, 0xea1b);
	rtl_mdio_write(hw, 0x14, 0x659e);
	rtl_mdio_write(hw, 0x14, 0x16e4);
	rtl_mdio_write(hw, 0x14, 0x87e9);
	rtl_mdio_write(hw, 0x14, 0xe587);
	rtl_mdio_write(hw, 0x14, 0xeaae);
	rtl_mdio_write(hw, 0x14, 0x06bf);
	rtl_mdio_write(hw, 0x14, 0x876c);
	rtl_mdio_write(hw, 0x14, 0x024a);
	rtl_mdio_write(hw, 0x14, 0x5fe2);
	rtl_mdio_write(hw, 0x14, 0x87f7);
	rtl_mdio_write(hw, 0x14, 0xf636);
	rtl_mdio_write(hw, 0x14, 0xe687);
	rtl_mdio_write(hw, 0x14, 0xf7ff);
	rtl_mdio_write(hw, 0x14, 0xef97);
	rtl_mdio_write(hw, 0x14, 0xfffe);
	rtl_mdio_write(hw, 0x14, 0xfdfc);
	rtl_mdio_write(hw, 0x14, 0x04f8);
	rtl_mdio_write(hw, 0x14, 0xf9fa);
	rtl_mdio_write(hw, 0x14, 0xef69);
	rtl_mdio_write(hw, 0x14, 0xbf87);
	rtl_mdio_write(hw, 0x14, 0x6602);
	rtl_mdio_write(hw, 0x14, 0x44dc);
	rtl_mdio_write(hw, 0x14, 0xad28);
	rtl_mdio_write(hw, 0x14, 0x29bf);
	rtl_mdio_write(hw, 0x14, 0x8763);
	rtl_mdio_write(hw, 0x14, 0x0244);
	rtl_mdio_write(hw, 0x14, 0xdcef);
	rtl_mdio_write(hw, 0x14, 0x54bf);
	rtl_mdio_write(hw, 0x14, 0x8760);
	rtl_mdio_write(hw, 0x14, 0x0244);
	rtl_mdio_write(hw, 0x14, 0xdcac);
	rtl_mdio_write(hw, 0x14, 0x290d);
	rtl_mdio_write(hw, 0x14, 0xac28);
	rtl_mdio_write(hw, 0x14, 0x05a3);
	rtl_mdio_write(hw, 0x14, 0x020c);
	rtl_mdio_write(hw, 0x14, 0xae10);
	rtl_mdio_write(hw, 0x14, 0xa303);
	rtl_mdio_write(hw, 0x14, 0x07ae);
	rtl_mdio_write(hw, 0x14, 0x0ba3);
	rtl_mdio_write(hw, 0x14, 0x0402);
	rtl_mdio_write(hw, 0x14, 0xae06);
	rtl_mdio_write(hw, 0x14, 0xbf87);
	rtl_mdio_write(hw, 0x14, 0x6c02);
	rtl_mdio_write(hw, 0x14, 0x4a5f);
	rtl_mdio_write(hw, 0x14, 0xef96);
	rtl_mdio_write(hw, 0x14, 0xfefd);
	rtl_mdio_write(hw, 0x14, 0xfc04);
	rtl_mdio_write(hw, 0x14, 0xf8f9);
	rtl_mdio_write(hw, 0x14, 0xfafb);
	rtl_mdio_write(hw, 0x14, 0xef69);
	rtl_mdio_write(hw, 0x14, 0xfae0);
	rtl_mdio_write(hw, 0x14, 0x8015);
	rtl_mdio_write(hw, 0x14, 0xad25);
	rtl_mdio_write(hw, 0x14, 0x41d2);
	rtl_mdio_write(hw, 0x14, 0x0002);
	rtl_mdio_write(hw, 0x14, 0x86f3);
	rtl_mdio_write(hw, 0x14, 0xe087);
	rtl_mdio_write(hw, 0x14, 0xebe1);
	rtl_mdio_write(hw, 0x14, 0x87ec);
	rtl_mdio_write(hw, 0x14, 0x1b46);
	rtl_mdio_write(hw, 0x14, 0xab26);
	rtl_mdio_write(hw, 0x14, 0xd40b);
	rtl_mdio_write(hw, 0x14, 0xff1b);
	rtl_mdio_write(hw, 0x14, 0x46aa);
	rtl_mdio_write(hw, 0x14, 0x1fac);
	rtl_mdio_write(hw, 0x14, 0x3204);
	rtl_mdio_write(hw, 0x14, 0xef32);
	rtl_mdio_write(hw, 0x14, 0xae02);
	rtl_mdio_write(hw, 0x14, 0xd304);
	rtl_mdio_write(hw, 0x14, 0x0c31);
	rtl_mdio_write(hw, 0x14, 0xbf87);
	rtl_mdio_write(hw, 0x14, 0xeb1a);
	rtl_mdio_write(hw, 0x14, 0x93d8);
	rtl_mdio_write(hw, 0x14, 0x19d9);
	rtl_mdio_write(hw, 0x14, 0x1b46);
	rtl_mdio_write(hw, 0x14, 0xab0e);
	rtl_mdio_write(hw, 0x14, 0x19d8);
	rtl_mdio_write(hw, 0x14, 0x19d9);
	rtl_mdio_write(hw, 0x14, 0x1b46);
	rtl_mdio_write(hw, 0x14, 0xaa06);
	rtl_mdio_write(hw, 0x14, 0x12a2);
	rtl_mdio_write(hw, 0x14, 0x08c9);
	rtl_mdio_write(hw, 0x14, 0xae06);
	rtl_mdio_write(hw, 0x14, 0xbf87);
	rtl_mdio_write(hw, 0x14, 0x6902);
	rtl_mdio_write(hw, 0x14, 0x4a5f);
	rtl_mdio_write(hw, 0x14, 0xfeef);
	rtl_mdio_write(hw, 0x14, 0x96ff);
	rtl_mdio_write(hw, 0x14, 0xfefd);
	rtl_mdio_write(hw, 0x14, 0xfc04);
	rtl_mdio_write(hw, 0x14, 0xf8fb);
	rtl_mdio_write(hw, 0x14, 0xef79);
	rtl_mdio_write(hw, 0x14, 0xa200);
	rtl_mdio_write(hw, 0x14, 0x05bf);
	rtl_mdio_write(hw, 0x14, 0x876f);
	rtl_mdio_write(hw, 0x14, 0xae33);
	rtl_mdio_write(hw, 0x14, 0xa201);
	rtl_mdio_write(hw, 0x14, 0x05bf);
	rtl_mdio_write(hw, 0x14, 0x8772);
	rtl_mdio_write(hw, 0x14, 0xae2b);
	rtl_mdio_write(hw, 0x14, 0xa202);
	rtl_mdio_write(hw, 0x14, 0x05bf);
	rtl_mdio_write(hw, 0x14, 0x8775);
	rtl_mdio_write(hw, 0x14, 0xae23);
	rtl_mdio_write(hw, 0x14, 0xa203);
	rtl_mdio_write(hw, 0x14, 0x05bf);
	rtl_mdio_write(hw, 0x14, 0x8778);
	rtl_mdio_write(hw, 0x14, 0xae1b);
	rtl_mdio_write(hw, 0x14, 0xa204);
	rtl_mdio_write(hw, 0x14, 0x05bf);
	rtl_mdio_write(hw, 0x14, 0x877b);
	rtl_mdio_write(hw, 0x14, 0xae13);
	rtl_mdio_write(hw, 0x14, 0xa205);
	rtl_mdio_write(hw, 0x14, 0x05bf);
	rtl_mdio_write(hw, 0x14, 0x877e);
	rtl_mdio_write(hw, 0x14, 0xae0b);
	rtl_mdio_write(hw, 0x14, 0xa206);
	rtl_mdio_write(hw, 0x14, 0x05bf);
	rtl_mdio_write(hw, 0x14, 0x8781);
	rtl_mdio_write(hw, 0x14, 0xae03);
	rtl_mdio_write(hw, 0x14, 0xbf87);
	rtl_mdio_write(hw, 0x14, 0x8402);
	rtl_mdio_write(hw, 0x14, 0x44dc);
	rtl_mdio_write(hw, 0x14, 0xef64);
	rtl_mdio_write(hw, 0x14, 0xef97);
	rtl_mdio_write(hw, 0x14, 0xfffc);
	rtl_mdio_write(hw, 0x14, 0x04af);
	rtl_mdio_write(hw, 0x14, 0x00ed);
	rtl_mdio_write(hw, 0x14, 0x0220);
	rtl_mdio_write(hw, 0x14, 0xa5f8);
	rtl_mdio_write(hw, 0x14, 0xfaef);
	rtl_mdio_write(hw, 0x14, 0x69bf);
	rtl_mdio_write(hw, 0x14, 0x4554);
	rtl_mdio_write(hw, 0x14, 0x0244);
	rtl_mdio_write(hw, 0x14, 0xdce0);
	rtl_mdio_write(hw, 0x14, 0x87ff);
	rtl_mdio_write(hw, 0x14, 0x1f01);
	rtl_mdio_write(hw, 0x14, 0x9e06);
	rtl_mdio_write(hw, 0x14, 0xe587);
	rtl_mdio_write(hw, 0x14, 0xff02);
	rtl_mdio_write(hw, 0x14, 0x4b05);
	rtl_mdio_write(hw, 0x14, 0xef96);
	rtl_mdio_write(hw, 0x14, 0xfefc);
	rtl_mdio_write(hw, 0x14, 0xaf03);
	rtl_mdio_write(hw, 0x14, 0x8c54);
	rtl_mdio_write(hw, 0x14, 0xa434);
	rtl_mdio_write(hw, 0x14, 0x74a6);
	rtl_mdio_write(hw, 0x14, 0x0022);
	rtl_mdio_write(hw, 0x14, 0xa434);
	rtl_mdio_write(hw, 0x14, 0x11b8);
	rtl_mdio_write(hw, 0x14, 0x4222);
	rtl_mdio_write(hw, 0x14, 0xb842);
	rtl_mdio_write(hw, 0x14, 0xf0a2);
	rtl_mdio_write(hw, 0x14, 0x00f0);
	rtl_mdio_write(hw, 0x14, 0xa202);
	rtl_mdio_write(hw, 0x14, 0xf0a2);
	rtl_mdio_write(hw, 0x14, 0x04f0);
	rtl_mdio_write(hw, 0x14, 0xa206);
	rtl_mdio_write(hw, 0x14, 0xf0a2);
	rtl_mdio_write(hw, 0x14, 0x08f0);
	rtl_mdio_write(hw, 0x14, 0xa20a);
	rtl_mdio_write(hw, 0x14, 0xf0a2);
	rtl_mdio_write(hw, 0x14, 0x0cf0);
	rtl_mdio_write(hw, 0x14, 0xa20e);
	rtl_mdio_write(hw, 0x14, 0x55b8);
	rtl_mdio_write(hw, 0x14, 0x20d9);
	rtl_mdio_write(hw, 0x14, 0xc608);
	rtl_mdio_write(hw, 0x14, 0xaac4);
	rtl_mdio_write(hw, 0x14, 0x3000);
	rtl_mdio_write(hw, 0x14, 0xc614);
	rtl_mdio_write(hw, 0x14, 0x33c4);
	rtl_mdio_write(hw, 0x14, 0x1a88);
	rtl_mdio_write(hw, 0x14, 0xc42e);
	rtl_mdio_write(hw, 0x14, 0x22c4);
	rtl_mdio_write(hw, 0x14, 0x2e54);
	rtl_mdio_write(hw, 0x14, 0xc41a);
	rtl_mdio_write(hw, 0x13, 0xb818);
	rtl_mdio_write(hw, 0x14, 0x1a01);
	rtl_mdio_write(hw, 0x13, 0xb81a);
	rtl_mdio_write(hw, 0x14, 0x020b);
	rtl_mdio_write(hw, 0x13, 0xb81c);
	rtl_mdio_write(hw, 0x14, 0x03ce);
	rtl_mdio_write(hw, 0x13, 0xb81e);
	rtl_mdio_write(hw, 0x14, 0x00e7);
	rtl_mdio_write(hw, 0x13, 0xb846);
	rtl_mdio_write(hw, 0x14, 0x0389);
	rtl_mdio_write(hw, 0x13, 0xb848);
	rtl_mdio_write(hw, 0x14, 0xffff);
	rtl_mdio_write(hw, 0x13, 0xb84a);
	rtl_mdio_write(hw, 0x14, 0xffff);
	rtl_mdio_write(hw, 0x13, 0xb84c);
	rtl_mdio_write(hw, 0x14, 0xffff);
	rtl_mdio_write(hw, 0x13, 0xb832);
	rtl_mdio_write(hw, 0x14, 0x001f);

	rtl_mdio_write(hw, 0x1F, 0x0A43);
	rtl_mdio_write(hw, 0x13, 0x0000);
	rtl_mdio_write(hw, 0x14, 0x0000);
	rtl_mdio_write(hw, 0x1f, 0x0B82);
	gphy_val = rtl_mdio_read(hw, 0x17);
	gphy_val &= ~BIT_0;
	rtl_mdio_write(hw, 0x17, gphy_val);
	rtl_mdio_write(hw, 0x1f, 0x0A43);
	rtl_mdio_write(hw, 0x13, 0x8042);
	rtl_mdio_write(hw, 0x14, 0x0000);

	rtl_clear_phy_mcu_patch_request(hw);
}

void
hw_mac_mcu_config_8168h(struct rtl_hw *hw)
{
	if (hw->NotWrMcuPatchCode)
		return;

	switch (hw->mcfg) {
	case CFG_METHOD_29:
		rtl8168_set_mac_mcu_8168h_1(hw);
		break;
	case CFG_METHOD_30:
	case CFG_METHOD_37:
		rtl8168_set_mac_mcu_8168h_2(hw);
		break;
	case CFG_METHOD_35:
		rtl8168_set_mac_mcu_8168h_3(hw);
		break;
	case CFG_METHOD_36:
		rtl8168_set_mac_mcu_8168h_4(hw);
		break;
	}
}

void
hw_phy_mcu_config_8168h(struct rtl_hw *hw)
{
	switch (hw->mcfg) {
	case CFG_METHOD_29:
		rtl8168_set_phy_mcu_8168h_1(hw);
		break;
	case CFG_METHOD_30:
	case CFG_METHOD_37:
		rtl8168_set_phy_mcu_8168h_2(hw);
		break;
	case CFG_METHOD_35:
		rtl8168_set_phy_mcu_8168h_3(hw);
		break;
	case CFG_METHOD_36:
		break;
	}
}
