/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import org.fest.swing.core.Settings;
import org.fest.swing.input.InputState;
import org.fest.swing.monitor.WindowMonitor;
import org.fest.swing.timing.Pause;

class AWTEventPoster {
    private final Toolkit toolkit;
    private final InputState inputState;
    private final WindowMonitor windowMonitor;
    private final Settings settings;

    AWTEventPoster(Toolkit toolkit, InputState inputState, WindowMonitor windowMonitor, Settings settings) {
        this.toolkit = toolkit;
        this.inputState = inputState;
        this.windowMonitor = windowMonitor;
        this.settings = settings;
    }

    void postEvent(Component c, AWTEvent event) {
        this.inputState.update(event);
        this.eventQueueFor(c).postEvent(event);
        Pause.pause(this.settings.delayBetweenEvents());
    }

    private EventQueue eventQueueFor(Component c) {
        return c != null ? this.windowMonitor.eventQueueFor(c) : this.toolkit.getSystemEventQueue();
    }
}

