/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.tools.walkers.na12878kb.core;

import com.mongodb.ReflectionDBObject;
import htsjdk.variant.vcf.VCFHeaderLine;
import java.util.Date;
import java.util.LinkedList;
import org.broadinstitute.gatk.utils.Utils;

public class CallSet
extends ReflectionDBObject {
    private static final String CALLSET_VCF_HEADERLINE_KEY = "CallSet";
    private String name;
    private Date date;
    private boolean isReviewer;

    public CallSet() {
    }

    public CallSet(String name, Date date, boolean isReviewer) {
        this.name = name;
        this.date = date;
        this.isReviewer = isReviewer;
    }

    public static boolean isVCFHeaderLine(VCFHeaderLine line) {
        return line.getKey().equals(CALLSET_VCF_HEADERLINE_KEY);
    }

    public CallSet(VCFHeaderLine headerLine) {
        if (!CallSet.isVCFHeaderLine(headerLine)) {
            throw new IllegalArgumentException("VCFHeaderLine key must be CallSet but saw " + headerLine.getKey());
        }
        for (String keyValue : Utils.split(headerLine.getValue(), ";")) {
            String[] parts = keyValue.split("=");
            if (parts[0].equals("Name")) {
                this.setName(parts[1]);
                continue;
            }
            if (parts[0].equals("Date")) {
                this.setDate(new Date(Long.valueOf(parts[1])));
                continue;
            }
            if (parts[0].equals("IsReviewer")) {
                this.setReviewer(Boolean.valueOf(parts[1]));
                continue;
            }
            throw new IllegalArgumentException("Unexpected key/value " + keyValue + " in " + headerLine);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public boolean isReviewer() {
        return this.isReviewer;
    }

    public void setReviewer(boolean reviewer) {
        this.isReviewer = reviewer;
    }

    public VCFHeaderLine asVCFHeaderLine() {
        LinkedList<String> values = new LinkedList<String>();
        values.add("Name=" + this.getName());
        values.add("Date=" + this.getDate().getTime());
        values.add("IsReviewer=" + this.isReviewer());
        return new VCFHeaderLine(CALLSET_VCF_HEADERLINE_KEY, Utils.join(";", values));
    }

    public String toString() {
        return "CallSet{name='" + this.name + '\'' + ", date=" + this.date + ", isReviewer=" + this.isReviewer + '}';
    }
}

