/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.StringUtil;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import picard.PicardException;
import picard.analysis.BaseDistributionByCycleMetrics;
import picard.analysis.SinglePassSamProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Metrics;
import picard.util.RExecutor;

@CommandLineProgramProperties(usage="Program to chart the nucleotide distribution per cycle in a SAM or BAM file.", usageShort="Program to chart the nucleotide distribution per cycle in a SAM or BAM file.", programGroup=Metrics.class)
public class CollectBaseDistributionByCycle
extends SinglePassSamProgram {
    @Option(shortName="CHART", doc="A file (with .pdf extension) to write the chart to.")
    public File CHART_OUTPUT;
    @Option(doc="If set to true, calculate the base distribution over aligned reads only.")
    public boolean ALIGNED_READS_ONLY = false;
    @Option(doc="If set to true calculate the base distribution over PF reads only.")
    public boolean PF_READS_ONLY = false;
    private HistogramGenerator hist;
    private String plotSubtitle = "";
    private final Log log = Log.getInstance(CollectBaseDistributionByCycle.class);

    public static void main(String[] args) {
        System.exit(new CollectBaseDistributionByCycle().instanceMain(args));
    }

    @Override
    protected void setup(SAMFileHeader header, File samFile) {
        IOUtil.assertFileIsWritable((File)this.CHART_OUTPUT);
        List readGroups = header.getReadGroups();
        if (readGroups.size() == 1) {
            this.plotSubtitle = StringUtil.asEmptyIfNull((Object)((SAMReadGroupRecord)readGroups.get(0)).getLibrary());
        }
        this.hist = new HistogramGenerator();
    }

    @Override
    protected void acceptRead(SAMRecord rec, ReferenceSequence ref) {
        if (this.PF_READS_ONLY && rec.getReadFailsVendorQualityCheckFlag()) {
            return;
        }
        if (this.ALIGNED_READS_ONLY && rec.getReadUnmappedFlag()) {
            return;
        }
        if (rec.isSecondaryOrSupplementary()) {
            return;
        }
        this.hist.addRecord(rec);
    }

    @Override
    protected void finish() {
        MetricsFile metrics = this.getMetricsFile();
        this.hist.addToMetricsFile(metrics);
        metrics.write(this.OUTPUT);
        if (this.hist.isEmpty()) {
            this.log.warn(new Object[]{"No valid bases found in input file. No plot will be produced."});
        } else {
            int rResult = RExecutor.executeFromClasspath("picard/analysis/baseDistributionByCycle.R", this.OUTPUT.getAbsolutePath(), this.CHART_OUTPUT.getAbsolutePath(), this.INPUT.getName(), this.plotSubtitle);
            if (rResult != 0) {
                throw new PicardException("R script nucleotideDistributionByCycle.R failed with return code " + rResult);
            }
        }
    }

    private class HistogramGenerator {
        private int maxLengthSoFar = 0;
        private final long[][] firstReadTotalsByCycle = new long[5][this.maxLengthSoFar];
        private long[] firstReadCountsByCycle = new long[this.maxLengthSoFar];
        private final long[][] secondReadTotalsByCycle = new long[5][this.maxLengthSoFar];
        private long[] secondReadCountsByCycle = new long[this.maxLengthSoFar];
        private boolean seenSecondEnd = false;

        private HistogramGenerator() {
        }

        private int baseToInt(byte base) {
            switch (base) {
                case 65: 
                case 97: {
                    return 0;
                }
                case 67: 
                case 99: {
                    return 1;
                }
                case 71: 
                case 103: {
                    return 2;
                }
                case 84: 
                case 116: {
                    return 3;
                }
            }
            return 4;
        }

        void addRecord(SAMRecord rec) {
            byte[] bases = rec.getReadBases();
            if (bases == null) {
                return;
            }
            int length = bases.length;
            boolean rc = rec.getReadNegativeStrandFlag();
            this.ensureArraysBigEnough(length + 1);
            if (rec.getReadPairedFlag() && rec.getSecondOfPairFlag()) {
                this.seenSecondEnd = true;
                for (int i = 0; i < length; ++i) {
                    int cycle = rc ? length - i : i + 1;
                    long[] lArray = this.secondReadTotalsByCycle[this.baseToInt(bases[i])];
                    int n = cycle;
                    lArray[n] = lArray[n] + 1L;
                    int n2 = cycle;
                    this.secondReadCountsByCycle[n2] = this.secondReadCountsByCycle[n2] + 1L;
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    int cycle = rc ? length - i : i + 1;
                    long[] lArray = this.firstReadTotalsByCycle[this.baseToInt(bases[i])];
                    int n = cycle;
                    lArray[n] = lArray[n] + 1L;
                    int n3 = cycle;
                    this.firstReadCountsByCycle[n3] = this.firstReadCountsByCycle[n3] + 1L;
                }
            }
        }

        private void ensureArraysBigEnough(int length) {
            if (length > this.maxLengthSoFar) {
                for (int i = 0; i < 5; ++i) {
                    this.firstReadTotalsByCycle[i] = Arrays.copyOf(this.firstReadTotalsByCycle[i], length);
                    this.secondReadTotalsByCycle[i] = Arrays.copyOf(this.secondReadTotalsByCycle[i], length);
                }
                this.firstReadCountsByCycle = Arrays.copyOf(this.firstReadCountsByCycle, length);
                this.secondReadCountsByCycle = Arrays.copyOf(this.secondReadCountsByCycle, length);
                this.maxLengthSoFar = length;
            }
        }

        boolean isEmpty() {
            return this.maxLengthSoFar == 0;
        }

        public void addToMetricsFile(MetricsFile<BaseDistributionByCycleMetrics, ?> metrics) {
            BaseDistributionByCycleMetrics metric;
            int i;
            int firstReadLength = 0;
            for (i = 0; i < this.maxLengthSoFar; ++i) {
                if (0L == this.firstReadCountsByCycle[i]) continue;
                metric = new BaseDistributionByCycleMetrics();
                metric.READ_END = 1;
                metric.CYCLE = i;
                metric.PCT_A = 100.0 * (double)this.firstReadTotalsByCycle[0][i] / (double)this.firstReadCountsByCycle[i];
                metric.PCT_C = 100.0 * (double)this.firstReadTotalsByCycle[1][i] / (double)this.firstReadCountsByCycle[i];
                metric.PCT_G = 100.0 * (double)this.firstReadTotalsByCycle[2][i] / (double)this.firstReadCountsByCycle[i];
                metric.PCT_T = 100.0 * (double)this.firstReadTotalsByCycle[3][i] / (double)this.firstReadCountsByCycle[i];
                metric.PCT_N = 100.0 * (double)this.firstReadTotalsByCycle[4][i] / (double)this.firstReadCountsByCycle[i];
                metrics.addMetric((MetricBase)metric);
                firstReadLength = i;
            }
            if (this.seenSecondEnd) {
                for (i = 0; i < this.maxLengthSoFar; ++i) {
                    if (0L == this.secondReadCountsByCycle[i]) continue;
                    metric = new BaseDistributionByCycleMetrics();
                    metric.READ_END = 2;
                    metric.CYCLE = i + firstReadLength;
                    metric.PCT_A = 100.0 * (double)this.secondReadTotalsByCycle[0][i] / (double)this.secondReadCountsByCycle[i];
                    metric.PCT_C = 100.0 * (double)this.secondReadTotalsByCycle[1][i] / (double)this.secondReadCountsByCycle[i];
                    metric.PCT_G = 100.0 * (double)this.secondReadTotalsByCycle[2][i] / (double)this.secondReadCountsByCycle[i];
                    metric.PCT_T = 100.0 * (double)this.secondReadTotalsByCycle[3][i] / (double)this.secondReadCountsByCycle[i];
                    metric.PCT_N = 100.0 * (double)this.secondReadTotalsByCycle[4][i] / (double)this.secondReadCountsByCycle[i];
                    metrics.addMetric((MetricBase)metric);
                }
            }
        }
    }
}

