#!/usr/bin/env bash
# TODO rewrite this script in python for better maintainability

set -e

CAMITK_SOURCE_DIR="../../../.."
PYTHON_MODULE_SOURCE_DIR="$CAMITK_SOURCE_DIR/sdk/libraries/python"
CAMITKCORE_INCLUDE_DIR="$CAMITK_SOURCE_DIR/build/include/camitk-6.0/libraries/camitkcore"

LIBCLANG_PATH="/usr/lib/x86_64-linux-gnu/libclang-20.so"
export LIBCLANG_PATH

# 4. Generate docstrings.h
echo "Generating docstrings.h ..."

raw_docstrings=$(mktemp)

# TODO get CMake to generate the include paths
.venv/bin/pybind11-mkdoc -o "$raw_docstrings" \
    -I /usr/include/x86_64-linux-gnu/qt5 \
    -I /usr/include/x86_64-linux-gnu/qt5/QtCore \
    -I /usr/include/x86_64-linux-gnu/qt5/QtGui \
    -I /usr/include/x86_64-linux-gnu/qt5/QtWidgets \
    -I /usr/include/vtk-9.1 \
    ${CAMITKCORE_INCLUDE_DIR}/*.h

# Clean up: remove all empy docstrings (docstrings that were not retrieved properly)
sed -i 's+static const char \*mkd_doc_.* = R"doc()doc";$++g' "$raw_docstrings"

.venv/bin/python ./cleanup-docstrings.py "$raw_docstrings" "$PYTHON_MODULE_SOURCE_DIR/docstrings.h"

echo "Docstring generated."