"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ptr16MathGlyphConstruction = exports.MathGlyphConstruction = void 0;
const bin_composite_types_1 = require("@ot-builder/bin-composite-types");
const ot_layout_1 = require("@ot-builder/ot-layout");
const variance_1 = require("@ot-builder/variance");
const math_value_record_1 = require("../shared/math-value-record");
const MathGlyphVariantRecord = {
    read(bv, gOrd) {
        const gid = bv.uint16();
        const measurement = bv.uint16();
        return new ot_layout_1.Math.GlyphVariantRecord(gOrd.at(gid), measurement);
    },
    write(fr, gvr, gOrd) {
        fr.uint16(gOrd.reverse(gvr.variantGlyph));
        fr.uint16(variance_1.OtVar.Ops.originOf(gvr.advanceMeasurement));
    }
};
const MathGlyphPartRecord = {
    read(bv, gOrd) {
        const gid = bv.uint16();
        const startConnectorLength = bv.uint16();
        const endConnectorLength = bv.uint16();
        const fullAdvance = bv.uint16();
        const partFlags = bv.uint16();
        return new ot_layout_1.Math.GlyphPart(gOrd.at(gid), startConnectorLength, endConnectorLength, fullAdvance, partFlags);
    },
    write(fr, gp, gOrd) {
        fr.uint16(gOrd.reverse(gp.partGlyph));
        fr.uint16(variance_1.OtVar.Ops.originOf(gp.startConnectorLength));
        fr.uint16(variance_1.OtVar.Ops.originOf(gp.endConnectorLength));
        fr.uint16(variance_1.OtVar.Ops.originOf(gp.fullAdvance));
        fr.uint16(gp.flags);
    }
};
const MathGlyphAssembly = {
    read(bv, gOrd) {
        const italicCorrection = bv.next(math_value_record_1.MathValueRecord);
        const partCount = bv.uint16();
        const parts = bv.array(partCount, MathGlyphPartRecord, gOrd);
        return new ot_layout_1.Math.GlyphAssembly(italicCorrection, parts);
    },
    write(fr, ga, gOrd) {
        fr.push(math_value_record_1.MathValueRecord, ga.italicCorrection);
        fr.uint16(ga.parts.length);
        fr.array(MathGlyphPartRecord, ga.parts, gOrd);
    }
};
const Ptr16MathGlyphAssemblyNullable = (0, bin_composite_types_1.NullablePtr16)(MathGlyphAssembly);
exports.MathGlyphConstruction = {
    read(bv, gOrd) {
        const glyphAssembly = bv.next(Ptr16MathGlyphAssemblyNullable, gOrd);
        const variantCount = bv.uint16();
        const mathGlyphVariantRecords = bv.array(variantCount, MathGlyphVariantRecord, gOrd);
        return new ot_layout_1.Math.GlyphConstruction(glyphAssembly, mathGlyphVariantRecords);
    },
    write(fr, gc, gOrd) {
        fr.push(Ptr16MathGlyphAssemblyNullable, gc.assembly, gOrd);
        fr.uint16(gc.variants.length);
        fr.array(MathGlyphVariantRecord, gc.variants, gOrd);
    }
};
exports.Ptr16MathGlyphConstruction = (0, bin_composite_types_1.NonNullablePtr16)(exports.MathGlyphConstruction);
//# sourceMappingURL=glyph-construction.js.map