"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ZeroAdjustmentPair = exports.ZeroAdjustment = exports.Chaining = exports.MarkToMark = exports.MarkToLigature = exports.MarkToBase = exports.Cursive = exports.Pair = exports.Single = exports.Table = exports.Tag = exports.LookupType = exports.FeatureParams = void 0;
const prelude_1 = require("@ot-builder/prelude");
const dicing_store_1 = require("../dicing-store");
const lookup_type_1 = require("./general/lookup-type");
exports.FeatureParams = require("./feature-params");
var lookup_type_2 = require("./general/lookup-type");
Object.defineProperty(exports, "LookupType", { enumerable: true, get: function () { return lookup_type_2.Gpos; } });
// GPOS Table
exports.Tag = "GPOS";
class Table {
    constructor(scripts = new Map(), features = [], lookups = [], featureVariations = undefined) {
        this.scripts = scripts;
        this.features = features;
        this.lookups = lookups;
        this.featureVariations = featureVariations;
    }
}
exports.Table = Table;
exports.Single = (0, prelude_1.CaseCreator)(lookup_type_1.Gpos.Single, (0, prelude_1.FallbackPropCreator)(() => ({ adjustments: new Map() })));
exports.Pair = (0, prelude_1.CaseCreator)(lookup_type_1.Gpos.Pair, (0, prelude_1.FallbackPropCreator)(() => ({ adjustments: dicing_store_1.DicingStore.create() })));
exports.Cursive = (0, prelude_1.CaseCreator)(lookup_type_1.Gpos.Cursive, (0, prelude_1.FallbackPropCreator)(() => ({ attachments: new Map() })));
exports.MarkToBase = (0, prelude_1.CaseCreator)(lookup_type_1.Gpos.MarkToBase, (0, prelude_1.FallbackPropCreator)(() => ({ marks: new Map(), bases: new Map() })));
exports.MarkToLigature = (0, prelude_1.CaseCreator)(lookup_type_1.Gpos.MarkToLigature, (0, prelude_1.FallbackPropCreator)(() => ({ marks: new Map(), bases: new Map() })));
exports.MarkToMark = (0, prelude_1.CaseCreator)(lookup_type_1.Gpos.MarkToMark, (0, prelude_1.FallbackPropCreator)(() => ({ marks: new Map(), baseMarks: new Map() })));
exports.Chaining = (0, prelude_1.CaseCreator)(lookup_type_1.Gpos.Chaining, (0, prelude_1.FallbackPropCreator)(() => ({ rules: [] })));
// Zeroes
exports.ZeroAdjustment = { dX: 0, dY: 0, dWidth: 0, dHeight: 0 };
exports.ZeroAdjustmentPair = [exports.ZeroAdjustment, exports.ZeroAdjustment];
//# sourceMappingURL=table-gpos.js.map