import { Data } from "@ot-builder/prelude";
import { VarianceDim as Dim } from "../interface/dimension";
import { VarianceInstance } from "../interface/instance";
import { OtVarMaster, OtVarMasterDim } from "./master";
import { OtVarMasterSet } from "./master-set";
import { OtVarValueFactory } from "./ops";
export type DesignSpace = Data.Order<Dim>;
export type Instance = VarianceInstance<Dim>;
export { VarianceDim as Dim } from "../interface/dimension";
export { OtVarMaster as Master, OtVarMasterDim as MasterDim } from "./master";
export { OtVarMasterSet as MasterSet } from "./master-set";
export { OtVarOps as Ops, OtVarValueFactory as ValueFactory } from "./ops";
export { OtVarValue as Value } from "./value";
export declare namespace Create {
    function Master(init: Iterable<null | undefined | OtVarMasterDim>): OtVarMaster;
    function MasterSet(): OtVarMasterSet;
    function ValueFactory(ms?: OtVarMasterSet): OtVarValueFactory;
}
//# sourceMappingURL=index.d.ts.map