/* AES-CFB,  */
#include "cipher_test.h"
const struct cipher_test aes_cfb_test_json[] = {
        /* Vectors from Auto generated */
        { 128, 128, 1, "\xe7\x2c\xcf\x7c\xf4\xe7\x61\x6e\xce\xe9\xc1\x25\xd3\x29\xcf\xd6",
          "\x8c\x65\x4a\x31\x71\xa2\x07\xb1\x3e\xf3\x5a\x83\x07\xb5\x04\x22",
          "\x9e\x0f\x5f\xd1\x66\x40\x08\x74\x3b\xe7\x7b\xf1\x41\x27\xf2\x21",
          "\xa9\xde\xe4\x24\x88\x3e\xf4\x2b\x89\x63\x60\x10\xe6\x93\xc9\xe3", 1, 128 },
        { 128, 128, 2, "\x91\xee\xcf\x96\x62\x3c\x52\x1f\x3d\xeb\x28\xea\x4b\x16\x30\x82",
          "\x4e\xd8\x2d\x68\xd3\xce\x84\x88\xad\xa9\x6a\xdd\xda\x28\x54\x4c",
          "\x81\xea\x94\xe3\xfd\x33\x59\x2e\x68\x37\x36\xff\xf3\x06\x52\x07\x06\x41\xd2\x0f\x16\x7e"
          "\x7f\x25\x08\x03\xbd\x7f\xff\x53\xbd\x76",
          "\x19\x09\x83\x1a\x0e\xd6\xbe\xa7\xd9\xbf\x1d\xfc\x79\x76\x0e\xfb\x33\x93\xc8\x95\xcb\x5a"
          "\x99\xdd\x43\xb5\x81\xaf\x3e\xcf\x5c\x8f",
          1, 256 },
        { 128, 128, 3, "\xed\x4d\x58\x8a\x7b\xf6\x94\x36\x88\x35\xa9\xca\xcd\x68\x3a\xb4",
          "\x5d\x0e\x25\xfb\xf4\x2f\x03\xcc\xdf\x5d\xd8\x96\xa3\x42\xa0\x0a",
          "\xe4\xaf\xf4\x41\xed\xc0\xaf\x31\xe5\xca\xae\x4f\xfc\xb5\xc5\x54\x5a\x71\xca\xb0\x2c\xf4"
          "\x2a\x6c\xe6\x38\xfa\x3e\x65\xfa\x03\xdd\xe3\xd7\xaa\x11\xf1\xc0\x71\x51\x4d\x37\x3d\xe2"
          "\x20\x42\x89\x3f",
          "\x50\x61\x0e\x7f\xb2\xbe\xce\xe5\x3d\x7e\xd8\x24\x74\xfb\xc5\xe5\x1b\x4b\xb5\xe0\x3e\xbd"
          "\xf7\x4e\xb0\x0e\xb8\x20\x58\x31\x74\x67\x86\x65\xe8\xb7\xa7\x33\x06\x98\x38\x9b\xb2\x8d"
          "\xef\x5b\xc9\xfb",
          1, 384 },
        { 128, 128, 4, "\xeb\x7e\x26\x83\xf1\x30\xe9\x73\x73\xce\x3d\x6e\x58\xcc\xf1\xf4",
          "\x6e\x29\xfc\x1b\x3b\x15\x29\x9b\xa1\x92\xa7\x40\xb6\xa5\x16\x8a",
          "\xbb\xe5\xbd\xd4\x9a\x39\x57\x59\xb8\x11\xbc\xa7\x8f\x06\x66\xd5\x7a\x02\x8d\x7e\x20\x5f"
          "\x08\x72\x47\x45\xe4\x26\x4b\xc0\x2d\x40\x7a\x8b\xc4\x17\x5b\xa9\x02\xb4\x71\x25\xfd\x3b"
          "\xcd\x3a\x1e\xf0\xd8\x82\xcf\x8f\x01\xfa\xa0\x05\xc6\xb0\x99\x57\x14\x00\xec\xe9",
          "\x2c\xf2\xac\x57\x95\xfa\x65\x84\xa1\x4d\xee\xde\xcf\xec\x39\x9d\xc2\x04\x1d\xaa\xfb\x4c"
          "\x92\x13\xee\xe7\x5c\x3b\x1c\xec\x0b\x5b\x9f\x41\x06\x9c\x1b\xb1\xfd\xcb\xba\x99\x06\xdb"
          "\x37\x53\xc1\x48\xde\x8e\xa5\x13\x8b\xb0\xf6\x65\xb2\xc3\xd2\xf4\xa5\xad\x29\xb8",
          1, 512 },
        { 128, 128, 5, "\x44\x58\xf9\xc2\xa1\x7b\xc8\x87\x08\xa5\x00\xe4\xba\xd8\xbc\x3e",
          "\xe1\x84\x61\x4d\x8b\x3a\x2b\x3f\xba\x2f\x1a\xd9\x43\xd3\x87\x19",
          "\xcd\x1b\xe6\x4f\x24\x9a\xe4\xe2\x61\xde\xee\x7f\x71\xef\xa2\x61\x8a\x16\x9f\x4b\xae\x6f"
          "\x89\x96\x5b\xfd\xcf\x28\x24\x60\x2e\x14\x37\x73\x94\xad\x86\x91\xc7\xd4\x48\xba\xe0\x5e"
          "\x0a\x98\x4a\xb7\x7e\x83\xdd\x64\x0f\xf2\x76\x91\xc3\x34\x7c\x61\x0d\x7c\xfc\x17\xe0\xe5"
          "\xdf\x0e\x19\xd7\x2e\x59\x10\x2f\xba\xef\x1c\xa7\xc5\xc4",
          "\xe3\xb3\xc5\x7a\xc9\x9a\x96\x1c\x60\x68\x35\x23\x62\x74\xe4\x30\x4f\x9e\xca\x36\x11\x52"
          "\xb6\x45\xe3\xce\x1d\x04\xba\xcc\xce\x89\x4a\xc0\x0d\x5d\xaf\x0b\x66\x6e\xee\x8d\xbe\xe2"
          "\x50\x3c\x53\xc1\x8c\x7e\x40\x7f\x4b\x3e\xba\xbc\xa1\xe3\xfe\x1d\xc8\x66\x63\x4c\x64\xb9"
          "\xe1\x9e\x1e\x30\x6e\x75\xd6\xed\x47\x02\x36\x58\x1b\xec",
          1, 640 },
        { 128, 128, 6, "\xce\x0b\xb4\x56\x2b\x93\x7e\x2e\x83\x2a\xec\x89\x5b\xac\x4a\x3e",
          "\xff\x1f\xa6\xc3\xd0\x2c\x5e\x57\xe0\xca\xc6\x76\xde\x6a\x4d\xc6",
          "\x67\xb3\xa4\x21\x94\x38\x8a\x51\x78\x35\xce\x27\x45\xad\xb3\x76\x5f\x28\x10\x88\xd6\x51"
          "\x44\x25\x38\xd7\x96\x8b\x1b\xd0\x57\x57\x8d\x5b\xce\x34\xa0\x62\x46\xe5\x70\x09\x32\x5a"
          "\xb8\x27\xc7\x0f\x42\x45\xdc\x4c\x87\xc4\x9a\x2c\x2e\xda\x49\xe1\x82\xfa\x32\xc2\x23\x69"
          "\x0c\xf1\xc4\xac\x6c\x2c\x30\x13\x5f\xc0\x71\xd6\x20\xd7\xf8\xc4\x0c\xa8\x4b\x12\xea\x61"
          "\x4a\x37\x86\x79\x35\x9e\xfe\x36",
          "\xad\x64\x87\x34\x60\x22\x80\x9d\xd3\x48\xbe\xc9\xfc\x94\x4f\x9b\xc4\xdd\x52\x9c\xd1\x15"
          "\xd9\x3d\x59\x2d\xe4\x2d\x6d\x40\x47\xda\xa4\x42\xe6\xa0\x63\x71\xfc\xc8\x49\x71\x69\xb8"
          "\x0c\xb5\x01\xa7\x2c\x80\xe5\xa6\x74\x6d\x57\x30\xc7\x90\xaf\xe0\x88\x76\x85\xd8\x3f\x83"
          "\x0f\x79\xca\x46\x9c\x61\x65\xcb\xb6\x5a\x00\x8e\x34\xac\x21\xa9\x50\x02\x1a\x83\x3e\x52"
          "\x7c\x05\xee\x03\xe8\xe9\xa8\x87",
          1, 768 },
        { 128, 128, 7, "\x61\xa5\x86\x67\x12\x8a\xbf\xad\x14\xe7\x91\xc2\xbe\xca\xf0\x37",
          "\x7d\x5b\xbb\x97\xa0\xcc\xce\x20\xe4\x97\x8d\xfe\xa4\xef\x03\xb9",
          "\xf1\xdc\x5d\x5d\xa0\x0c\x6a\x1c\x9f\x99\x48\x1f\x42\x76\x9f\x69\x06\x3e\x3d\x33\x4c\x99"
          "\xe2\x2c\x55\x58\x28\x9a\x64\xfb\x1e\x73\x0b\xf3\xbe\xa8\x48\x70\xb9\xe1\xae\xaf\xc1\x2e"
          "\x18\x24\xa7\x3f\x96\x65\xa1\xfc\x39\x97\x93\x4a\x79\x6c\x2b\xd0\x6a\x74\x85\x2b\x72\xdc"
          "\x56\x55\xf5\xa1\xad\x83\xf2\xcd\xf1\x27\xa6\xab\x7c\xa1\xa5\x26\xdd\x6b\x9b\x8f\x2d\x50"
          "\x8a\xe9\x6a\xaf\x29\xb3\x6b\xfa\x14\x36\x60\x54\xc4\x0d\xe5\x1a\xeb\x87\xc0\xc5\x6a\x44"
          "\x36\xe6",
          "\x0c\xb7\x6d\x81\x0f\x2e\x5f\x11\xb6\x61\xd5\x27\xea\x8e\x0a\x0d\x22\x1a\x3b\x4f\x03\xaf"
          "\x1e\xf6\x29\x92\xe6\x40\x80\x96\x35\x83\x6d\x13\x4f\x54\x2a\xcd\xb5\x56\x44\xd8\xa0\xca"
          "\x9b\x07\xca\x63\x68\xe8\x04\x28\x21\xe6\xc9\x94\xeb\xa2\x06\x63\x01\x05\x73\xc1\x20\x87"
          "\x76\x53\xf7\x27\xc5\x9e\x9f\xd0\x65\x48\xea\xa8\x1d\xdd\x1e\xc8\x27\x15\xc5\x02\x29\x2e"
          "\xaa\xca\x4e\x3f\x53\x30\x70\xd3\x37\xb9\xa0\x9d\x79\xda\xd9\x33\xa5\xb6\xad\x5b\x20\x20"
          "\x54\x5d",
          1, 896 },
        { 128, 128, 8, "\x0e\xb9\x8a\xc1\xe8\xbe\xf6\x8d\x6f\x4f\xec\x4f\xfc\xe3\x42\x26",
          "\x9e\x40\x09\xe5\x1a\x5b\x5c\xab\x5e\x25\x40\x12\xa9\xae\xa4\xfb",
          "\x24\x03\xdf\xb1\x94\xf1\x0c\x95\xbe\xa1\x59\xd6\xab\xcb\x57\xcc\x81\x7b\xe5\x93\xad\xce"
          "\x34\xa6\xc3\xda\xdf\xec\x6a\x1a\x33\x0f\xda\xd6\x46\x1c\xe2\x78\xb3\xf2\xc9\xb4\xc4\x5c"
          "\x70\xf4\xf6\x65\x86\x97\xdd\x32\x76\x35\x5e\x6b\x7c\x4d\x6f\x9a\x2a\x17\x84\x98\x9b\x29"
          "\x69\x4f\x2a\x44\x1f\x4a\x07\xad\x63\x30\xbb\x87\xc9\x9a\xd5\x0e\xf8\x8f\x63\xae\xa4\x2f"
          "\x33\x49\x62\x13\x2e\xac\x9c\xba\xa8\x74\x06\x4b\xf7\x81\x30\x16\xef\xbb\x32\x88\x6a\x16"
          "\x1c\xfc\xab\x21\x73\xfb\x95\x80\x43\xc7\x21\x12\xb1\xaa\xfc\x91\x31\x64",
          "\x24\xcc\x7a\xff\x84\x60\x23\x45\x14\xa6\x0f\x3f\xf5\xd3\xae\xfd\xfa\x9b\x28\xa7\x36\x7c"
          "\xfc\x53\x10\x97\x44\xae\x92\xae\x49\x93\x4d\x05\x64\x88\xb6\x9a\x4f\xdb\x0b\x19\x21\xc4"
          "\x30\x83\x0e\x03\x90\xe0\x13\xa8\x04\xe7\x8e\xb2\x3f\xa5\x28\x5e\xc9\x55\xe5\xef\x87\x4a"
          "\xc2\x3d\x7b\x19\x75\x2d\x85\x8d\xfe\x13\xcd\xd4\xee\x18\xe0\xc9\x41\x74\xf5\x1f\xf8\x4f"
          "\x85\x17\x5e\xa2\x28\xec\x80\x54\x91\x7b\x2c\x33\xe8\x65\x89\xaa\xbd\xfd\x73\xb0\xb1\x36"
          "\x11\x2b\x7f\x53\x95\x93\xca\x6f\xc7\x5f\xad\xf6\x3f\xe1\xc7\x19\xc9\x0c",
          1, 1024 },
        { 128, 128, 9, "\xf6\x8c\xd8\xa4\x5f\x10\xa6\xa7\x68\xaf\xcb\x41\x44\x98\xf4\xf2",
          "\x68\x23\x18\x5c\x3f\x77\x8e\xde\x42\x34\xce\xa9\x2a\x58\x2d\xd3",
          "\xda\xab\xd1\x52\xa6\xea\x55\x85\xc9\xe3\x18\xc0\x5d\x46\x27\x5d\xe7\x4b\xa8\x88\xdb\xaa"
          "\x42\x8a\xf7\x0d\x92\xc8\xea\xac\x86\x43\xaa\x5d\xd3\x10\x8c\xe1\xe6\xa3\x12\xd0\x41\x88"
          "\xe6\xf0\xd5\x17\xc1\xa9\xa4\xbf\xc5\x1f\xaa\xa7\x2d\xc9\xbe\x6e\xc1\x69\xab\xce\xc4\x45"
          "\x09\x7f\xd3\xf7\xc2\x20\x3e\x42\x37\x15\x92\x49\x22\x99\x04\xa3\xbb\x53\xc3\x6e\x6e\xf3"
          "\xd9\xdd\x06\xbd\x1b\x5f\x2a\xc2\x0d\xda\xa7\x2b\x2c\x31\x07\x15\x19\xd7\xfe\x49\xd4\xc8"
          "\x53\xbf\x47\x7f\x7d\xee\x48\x3e\xf7\x85\xcf\x0b\x66\xf0\x38\xb7\x52\x40\x61\x78\x3d\x68"
          "\xf4\x29\x55\x6a\x88\x21\x79\xc1\xb7\x9b\x67\x39",
          "\x5b\x2f\x80\x1c\x7d\xda\x4d\x61\x13\x17\xbd\x2e\xb7\x51\xc5\xdc\xa7\xb1\xdb\xa9\x9d\x0b"
          "\x3e\x96\xcd\x79\xb9\xd8\xa1\xb1\xb3\x9c\x86\x34\xca\xab\xd9\x9e\x7b\x35\x42\x25\x56\x30"
          "\xa1\x98\x2f\x8f\x56\x3b\xfd\x2e\xfa\xcd\xc0\xdd\x46\x8b\x96\x22\xa3\xfd\x08\x22\x22\xd3"
          "\x8b\x3f\x0a\xd7\xbc\x54\xb2\xce\x4e\x8a\xea\xc4\x9e\x28\x6c\x3e\xa3\xb6\xf3\xc2\x22\xb2"
          "\x45\x71\x69\xaa\x56\xd1\x26\x19\x6c\xdf\x46\x2f\x2a\xde\xf6\x15\x13\xd5\x01\x1c\x24\x12"
          "\x71\xfd\xfa\xc9\x7c\x08\xc4\x8c\x5e\x13\xe0\xef\xe3\x65\x76\x5b\x6a\xab\x67\xc5\x4f\x25"
          "\xa4\x77\x0c\x51\x5f\xef\xa3\x7a\x30\xc2\x26\xba",
          1, 1152 },
        { 128, 128, 10, "\x52\xe1\xfd\x9b\x56\x43\x46\xa4\x47\xb9\xb0\x18\xb9\xaa\x84\x7a",
          "\x2a\x75\x9c\xbc\xf8\x7e\x87\x26\xb2\x0b\x26\xea\x29\x0d\xf7\x47",
          "\xbf\x52\x37\x2a\x87\x6e\x6f\x2f\x22\x0a\xb7\x44\x71\xb4\x08\x3d\x4d\xa3\x6a\xee\x46\x97"
          "\xe8\xe2\x4b\x2c\x9a\x44\x4a\x2a\x3e\xe1\xfc\xe7\x56\x17\xd5\x8c\xb8\x68\x35\x83\x85\xe8"
          "\x63\x95\x46\xdd\xca\x78\x32\x09\x81\x33\x77\x57\x85\x75\xca\x5c\x7c\xb5\x89\x08\xfe\xbf"
          "\x0a\xdc\xe1\xe1\xb9\xa6\x11\xc4\x19\xd1\xd7\x58\xec\x40\x06\x45\x8c\xa2\x07\x74\xc0\xe7"
          "\xee\x0d\x04\x46\x97\x11\xa9\x0c\xb9\xcc\xc9\xed\x95\x08\x6d\x06\x56\x7b\x6f\x61\xde\x0a"
          "\x31\x01\xe7\x07\xc6\x45\xc0\xef\x44\xd0\xeb\x7a\xcd\xda\x79\x17\x19\x0f\x38\xab\x3f\x3d"
          "\x8b\x0f\xd4\xac\x66\xff\xd5\xdb\xc7\x05\x35\x23\x37\x1d\xb0\x3f\x27\x42\x92\x63\xae\x42"
          "\x08\xee\x27\xfd\x42\xab",
          "\x8c\xe2\x9c\x63\xdc\x17\x3e\xcd\x5c\x6c\x1d\xc4\x96\xec\x2e\x1d\x69\x0b\xe2\xe1\x7a\xc6"
          "\x2d\xee\x2b\x63\xa6\x40\x3b\x54\xda\xa4\x55\x65\x27\x3a\x89\x2f\x5b\x04\x33\x06\x1d\x3f"
          "\xe5\x87\x0b\x03\xab\x25\x0d\xba\x5e\x28\x6d\x01\xed\x71\x06\x6c\xc3\x12\x09\x94\x46\x7d"
          "\xde\x2f\x5f\x47\xce\x26\x28\x53\x1b\x46\x21\x46\x71\xad\x18\x53\x50\x0b\x89\x6f\xdc\x4d"
          "\x58\x48\x3c\x97\x23\xc4\x8e\xcb\x77\x8e\xc7\xa7\x57\x26\x78\x1d\x59\xc9\xeb\xa4\x29\x2e"
          "\x84\x80\x8f\x14\xdc\x6f\x74\x72\xf8\x32\x96\xb3\x4b\xb2\x0a\x2c\x3a\xbb\x24\xa1\x49\x61"
          "\x52\x20\xaa\x0c\xcb\x0c\x19\xaf\xde\xd6\x1d\xa4\x38\x6e\x33\x94\x18\xbf\x32\x38\x65\xb2"
          "\x24\x54\x7a\x44\xb0\x47",
          1, 1280 },
        { 128, 128, 11, "\xe2\xdf\x2c\x42\x33\xaa\x78\x5e\x5e\xf1\x9d\x17\xcb\x42\xe9\xee",
          "\x2f\x2c\x30\x43\x67\x97\x7f\x03\x69\xa9\x8d\x44\x13\xb9\xba\xa4",
          "\x3d\x88\x9d\xd9\x2e\xdd\xa9\x98\x67\x85\x48\xa2\x98\x6d\xb3\xcd\x87\xd2\x4a\x62\xb6\x73"
          "\xad\x7c\xff\xe9\x0b\x70\xa9\x14\xfd\x1d\xd6\x2c\xea\x50\x1b\xc7\xe9\x76\x91\xd4\x05\xa6"
          "\xf4\x00\x17\x43\x17\x28\x45\x75\xd5\x2b\xf4\xd0\xc6\x9d\xee\x26\x55\x1d\xf4\x23\x9f\x9b"
          "\x6e\x2c\xf1\xa2\x51\x56\x34\x5c\x3a\x03\x91\x7b\x4e\x23\x0d\xd9\x4f\x33\xb8\x02\xc6\x48"
          "\x73\x57\xa5\x0f\xaf\x25\x4c\xc8\xc0\x74\x3b\x84\x34\xc0\x9c\x27\x64\x66\x79\xdc\x21\x40"
          "\x18\x04\x73\xd5\x95\xb8\xce\xf9\x34\x7c\xaa\xc7\xa7\xca\xca\x25\x68\x31\x21\x62\x63\x3c"
          "\x0f\xe4\x86\xe5\xbb\x27\x25\x51\x1c\x7f\x75\xa2\x02\x2d\x01\xf4\xb6\x53\xbb\x56\x7b\x31"
          "\xcf\xb4\xb6\x0f\x49\x1a\x4c\x20\xe8\xb4\x5d\x97\xf2\x6a\xb9\xe8\x44\xbe\xa4\x5b\x4f"
          "\x00",
          "\x66\xed\xb4\x05\x63\xd9\xfe\x4d\xf6\x74\x6e\x4f\xe7\x6a\xe5\x4b\x4a\x41\x32\xa0\xb9\xc9"
          "\xdd\xb6\xd8\x59\x2d\x23\x29\xcc\x8a\xe7\x1e\xc2\x84\x2e\x5a\x40\x5e\x95\x6e\x55\xfa\xd6"
          "\xc5\x7e\x10\xc6\xc1\x27\xb6\xf5\x91\x84\x8b\x64\xf4\x13\x04\xbd\xc1\xa2\xe3\x94\x4e\x99"
          "\x6c\xa5\xeb\x8c\xd2\xae\x66\x29\x46\x3e\x7a\xda\x5e\xf7\xd8\xa1\xf9\xd1\xf1\xa7\xa7\xde"
          "\x27\xb8\x41\xa8\x53\xf5\xd6\x44\xd2\x85\x35\x85\xc0\x11\x6b\xa4\x08\x2c\x57\x43\xcb\x9e"
          "\x3a\x60\x93\xe3\xce\x2f\xe7\x2c\x3e\xc8\xe9\xa8\xdd\x42\x49\xb7\x95\x22\xa9\xc6\x0a\x04"
          "\xd0\x7f\x3b\xad\x36\x0f\x57\x3a\xb4\x72\x23\xd6\x71\x4b\x70\x51\xa1\x1d\xf5\x0a\xd9\x7e"
          "\x72\x02\xc6\x8b\x18\x73\x1e\x4d\x1a\x0f\xe1\x3c\x89\x60\x56\xb6\x14\xd4\xc1\x97\xb5"
          "\x9d",
          1, 1408 },
        { 128, 128, 12, "\xc0\x7d\xca\x33\xbc\x63\x9a\x43\x2a\x5b\x7f\x1c\x3e\xfe\x61\xd0",
          "\xd1\x5d\x17\xe2\x8f\x52\x42\xec\x10\x1f\xf3\x13\x79\x17\x2b\xfa",
          "\xfb\x32\x62\x80\x13\x2f\x6c\x87\xb4\xfd\x0a\xe3\x7d\xe1\x72\x42\xdf\x7f\xe4\x90\x61\x76"
          "\x13\xe7\xa3\x6f\x1f\xc6\x9b\xc3\x28\xe7\x03\xba\x0a\x7d\x86\x41\x18\x44\x0e\xe6\x86\x91"
          "\xa0\x06\x29\x53\x20\x1f\x79\xf1\x78\xe2\xd9\x83\x0d\x94\x28\x05\xfc\xd9\x6c\x79\x8e\x2b"
          "\xda\xc3\x1d\x83\xc5\xa5\x23\x0d\x5c\x24\x26\x7a\xa8\x24\x99\x41\x32\xb3\x83\x0b\x0e\x5d"
          "\xec\x8f\xb9\x11\xe5\x9a\xbe\xaf\x0c\x79\x80\x6d\xed\xae\xea\x24\xa1\xf5\x9c\x66\x77\xb1"
          "\x06\x12\xd9\x58\xf1\xdb\xa2\xea\xd0\x21\xa9\x67\x99\x3e\xd1\x76\x08\xe8\xa7\x04\x34\x2d"
          "\x86\xa7\x1e\x6e\x9d\x07\xd1\x63\x0d\x5c\x77\x13\xe6\x91\x7a\x50\x68\xc9\xd2\x85\x65\x61"
          "\xb7\xfe\xb7\x46\xf1\x59\x20\x17\x6c\xb5\x1e\x2c\xa7\x50\x08\x80\x3c\xdb\x64\xf1\xe3\x99"
          "\x84\x29\x3c\xd6\xdb\x51\x7d\x3c\xb1\xab\x5f\xfc\x3e\x40\x46\x75",
          "\xa0\xb9\x46\xc7\xe3\x41\x45\xe6\x86\xb1\xa8\x8a\x8c\x91\xbb\x47\xda\xec\xdc\x67\xf7\x78"
          "\x2d\x0b\xe8\x9b\xbb\x5f\xcc\xea\xc9\x9a\x4d\x4a\x46\xab\x24\x3e\xbc\xe5\xa0\xa2\xd7\xbe"
          "\x54\x0a\x76\xd2\x81\xa2\x09\xd5\xc1\xbd\x51\x05\x99\x6f\x7d\x90\xad\x6b\x9d\x83\xac\x7f"
          "\xe7\xe0\x73\x1e\xc9\x98\xd4\x88\x44\x15\x0b\xbb\x7a\xa1\xa0\xa9\x0d\x2a\x1e\xa0\xac\x6c"
          "\x7c\xfe\x7a\x2a\xdc\x32\xef\x0b\xe9\xec\x51\x04\x76\x3b\xc7\x2a\xc0\xdb\xb5\x48\x86\xca"
          "\x05\x0f\x36\x35\xa1\xee\x90\xa8\xb3\xcd\x37\x24\x04\xe2\x82\xb9\x9a\x44\x93\x3a\xe5\x19"
          "\xd5\x1e\x8a\xe2\x94\x00\xca\xf4\x3f\x9c\x19\x48\xd3\xa8\x37\x31\x3f\x87\x7d\x93\xc4\x7d"
          "\xb6\xaa\x7e\x63\x2b\x2b\x50\xed\xd5\x08\xc9\xe3\x5d\x4b\x14\x81\x37\xff\x1b\xae\xcf\x93"
          "\x88\xaa\xc4\x58\x04\xfd\xe6\x65\x9e\xed\xba\x48\x5e\x69\xc5\xa6",
          1, 1536 },
        { 128, 128, 13, "\xb9\x70\x4b\x43\x06\x2f\x8c\xde\x17\x79\xca\x42\x05\xa0\x80\x44",
          "\x0a\x6a\x0d\x78\xd2\xc3\xb6\x78\x6a\x67\x1a\x77\xae\x17\x3c\x62",
          "\x57\xc8\x27\x26\x92\x59\x9a\xfd\x4f\x68\xc3\xa4\xde\x17\x13\x3c\x04\xa2\x50\x9e\x5b\x96"
          "\xb2\xf5\x32\x5a\xdc\x7a\x17\x77\x92\x76\x31\x23\xd5\xcb\x5b\x63\x00\xb7\x8a\xbd\x7e\xc3"
          "\xbb\x8f\x64\xf4\x16\x44\xfd\x06\x48\x7a\x07\xa7\xa8\x7e\xa3\xd1\x7f\xad\xcc\x26\xe4\x25"
          "\x5e\xb3\x90\x4e\x6a\xfa\xfe\xd8\x35\x45\xd0\xb2\xb8\xd8\x65\xa5\x43\x4e\xa0\x70\x32\xdc"
          "\xf9\xd5\x80\x70\xc3\xc8\xe3\x1f\x7e\x05\x56\x9e\x04\x11\x0c\x6a\x46\xb3\xbe\xb3\x33\x8a"
          "\x79\x24\x59\x72\x4d\x97\xab\x24\x57\x5a\xac\x6e\xf3\x72\x1b\x18\x59\x5f\x27\x9c\x30\xb9"
          "\xbd\x40\xb9\x0f\x64\xe9\x48\x3a\xde\xc6\xe4\xe7\xe1\xa4\xa7\x00\x47\xab\x21\x51\xf9\xcb"
          "\xcf\x29\xa9\x16\x6b\x82\x45\xba\x19\xd0\x2a\x9c\x17\x27\x42\x2e\x89\xee\x2f\x6b\xfc\x9a"
          "\x9b\x1c\xab\xa5\xef\xd8\x67\xf0\xe1\x5e\xbd\x3b\x08\x0d\xb9\x92\x05\xa4\xd0\xbf\x22\x10"
          "\xf1\x2d\x01\x59\x58\x85\xbf\x9c\xdb\x99",
          "\x4c\xff\x67\x9d\xc9\x22\x90\x97\x59\x82\xc8\xe7\x3e\xfb\x3b\x7b\xe7\x54\x75\x76\xb9\x27"
          "\xa3\x3a\xf4\xe5\x81\x6c\x9c\xae\x4f\x01\x33\xa3\xf9\x2f\x1a\x71\xf4\x37\xdb\x62\xf7\xd6"
          "\x84\x4a\x8f\x85\x39\xeb\x28\x39\xcc\xb8\x43\x7b\x51\x48\xfa\xe1\x47\x8e\xe7\xc6\xfc\xdc"
          "\x6b\xd1\xda\x05\x02\x9a\x2e\xb3\x87\x48\x6c\xa4\x22\xcf\x19\x55\x93\xe8\x68\x6f\x70\x8d"
          "\x47\x3f\xd9\xc1\x92\xdc\x38\x0e\x50\x9d\xad\x87\xc7\xce\x70\x57\x6d\xb2\x53\xc4\x15\x8e"
          "\xcb\x14\xca\x5b\x10\xd9\x04\x37\x51\xc9\x79\x91\x27\x92\x81\x22\x1d\xdb\x9e\x05\x1e\x56"
          "\x69\x57\x44\x93\x70\x9e\x28\x1a\x1a\x16\x4e\xf0\xa2\xbb\xc1\x67\x24\x6b\x1f\x95\x8a\x90"
          "\x03\x0d\xd5\x26\x8c\xb0\x00\x5e\x26\xed\x35\xb9\x4a\xcd\x4a\xae\x0a\x90\x68\x98\xb3\x4f"
          "\xc3\x5f\x1a\x82\x04\x77\x59\xc4\x0c\xfc\x20\xf1\xb4\x88\x98\x67\x37\x23\xdf\xe6\x29\x73"
          "\x89\x4a\x3c\x7c\xd9\x76\x67\x34\x7b\xb0",
          1, 1664 },
        { 128, 128, 14, "\x78\x0a\x7e\x16\xea\xf4\x06\x3d\x66\x8a\x17\x9d\xa2\xc4\xd4\x88",
          "\x88\xd7\x08\x7e\x84\xbd\x37\x8d\x5c\x6f\xdb\xac\x8a\x12\x73\xe6",
          "\xc3\xa6\x23\xb9\x3a\x0c\xb8\x4b\xe4\xf3\x2c\x77\xaa\x95\xb2\x38\x36\x12\xc6\x7e\x0e\x8c"
          "\x33\x4f\x5d\x51\x31\x0b\x60\x5a\xdf\xdd\xa9\x24\x97\x06\xbf\x50\x4c\xba\xe3\xe4\xf6\xb5"
          "\x89\xc6\xd1\xa2\xf0\xe2\xe9\xf1\xf2\xb9\xdc\x91\xe4\xdc\xcf\x72\x06\x61\xf1\x40\x71\x81"
          "\x29\x9e\x56\xf8\x0b\x36\x41\x88\xe8\xde\x1d\x1d\x51\x50\x64\xd2\x9d\xa6\x44\x75\x74\xa1"
          "\x12\x6f\x76\xc9\x0e\x64\xa7\x3d\xd3\x00\x5b\x7c\xec\xd9\x11\x1f\xa8\x50\x0c\xee\x45\xbd"
          "\xc7\x8f\xad\xac\x06\x7a\x44\xad\x50\x3e\x38\x74\xe5\x74\x2a\xac\xd8\x6e\x86\xa2\x24\xc7"
          "\x5e\xd0\xdf\x31\x50\xdb\xa0\xf2\xcf\x08\xac\xbb\x16\xda\x43\xbb\x39\x0b\xf6\x40\xb0\x34"
          "\x11\xcf\x18\x4d\xc2\x00\x23\x31\xd9\x04\x37\x19\x0f\xb5\x75\x69\x41\xc9\xc2\x54\x5c\x30"
          "\x47\x27\xb0\x66\x7c\xd8\x1e\x1d\xbd\xad\x26\x71\xed\x69\xfe\xf6\xf0\x15\x15\x7a\xc2\x4e"
          "\x09\xb3\x54\x0e\x2c\x1c\x21\x27\x57\x32\x5a\xb9\xcd\x77\xe5\xd7\x07\xae\x4d\xb8\x0c\xc7"
          "\xc7\xb6\xfc\x64",
          "\x5d\xe5\xb7\x6a\x43\xc6\xd2\xbd\x66\xcf\x28\x9d\xf6\x64\x71\x47\xa6\x16\xa5\x37\x31\xdc"
          "\xf9\x15\x78\xeb\x2c\xd9\x31\x0c\x4d\xe5\xf3\xa1\xa7\x26\xe5\x0c\x17\xfe\x7f\x8b\x22\x4c"
          "\xa6\xa1\xd3\xe9\xa6\x26\x18\x02\xa4\x7f\x82\x91\x30\x83\xcc\x59\x50\xa3\x1d\xa4\x28\x65"
          "\xc1\x5c\xfa\x52\xde\x8d\x69\xfd\xc2\x94\x97\x39\x6a\x82\x89\x01\x5c\x81\x67\xdb\x1c\x68"
          "\x7d\x6c\x95\x95\x9c\xb5\xc6\x08\x2d\x75\x32\x45\x24\xa3\x1b\xf2\x4c\x65\x8d\x34\x1a\x5d"
          "\x08\x82\x5b\x91\x5c\x3a\x77\xb8\x71\xad\x15\x99\x48\xaf\x64\x7d\x35\x46\x0c\x6e\xf2\xf0"
          "\xaa\x42\x48\x7b\x64\x53\xef\x84\xad\x22\xb9\x20\xbf\xa3\x29\xdf\x0e\x0c\xc4\x92\x9e\xb2"
          "\x25\x2a\x39\x6d\xf1\x5e\x52\xe8\x18\x0d\xe9\x9b\xb3\xb4\xc0\xc1\xdc\x46\xa9\x12\x4f\x59"
          "\x1a\x47\x74\x2c\x82\xab\x1b\x10\x3a\x27\x8c\x88\x1e\x2b\xc8\x2c\xc6\x89\x28\x1e\x64\x13"
          "\x92\x74\x45\xfe\x70\xce\x52\x7f\x0e\x31\x07\xb9\xbb\xf7\x48\xe7\x7e\x4b\xf2\x81\x37\x69"
          "\x0e\xc5\xe7\x5d",
          1, 1792 },
        { 128, 128, 15, "\xff\xff\x07\xba\x57\xcf\x76\x62\x52\x46\x8a\x4e\xb4\xf0\x6e\xb9",
          "\xa8\xe9\x1f\x10\x38\x39\x37\x67\x8e\x12\xc4\xca\xdc\xcb\xa4\x37",
          "\x47\x11\x8b\x2d\xf5\x9e\xd1\x4b\x1c\x66\x7e\x6e\xdb\xfd\x2e\xa0\x11\x82\x1f\xcc\x47\x20"
          "\x1c\xb3\x87\xc3\x51\xd1\x56\x58\xb5\x4f\x56\x94\x7d\xc6\x25\x97\x0b\x73\xb9\x2b\xf3\x24"
          "\xb1\xae\x69\xc1\x23\x50\x7b\xd1\x1e\xd6\x99\x1e\x38\x4d\xf7\x98\xe5\xea\x90\xa3\x53\x10"
          "\xb0\x93\x7a\x82\x99\x9c\xe4\xa8\x75\xb6\xbc\xb4\x80\x71\x17\xa1\x44\x28\xc0\xb3\x8f\xc2"
          "\x74\x6b\xf7\x43\xd6\x67\xc0\xec\x57\xdf\x32\x05\x90\x05\xae\xb6\x04\xd3\xe4\x2c\x66\x8a"
          "\x38\xc8\xb6\x62\xb8\xf9\x55\x04\x8a\xcb\x2e\xcd\x63\x9a\x69\x9f\x5a\x50\x5f\xe4\xb9\x64"
          "\xe8\x62\xce\x1c\x7a\xdf\xeb\x5a\x4e\x67\x1c\x30\x26\xf6\xb8\xa1\x84\x95\x18\x47\x11\xfd"
          "\x6c\xc2\x3a\x21\x19\xdd\x9c\x95\xdb\xbd\x57\x27\x09\x62\x45\x0f\xcc\xe8\xa5\x7e\x6b\xf0"
          "\x9b\xd8\x83\x6b\xc6\x64\x62\xe6\x6a\x18\x63\x9a\x11\xbf\xc6\xc5\xb7\xcd\x95\x8e\x99\xc7"
          "\xef\xf5\x23\xa9\xd6\x0a\xce\x04\x5c\xce\x1e\x15\x7b\x18\x8b\x18\xb2\xd5\x09\x7c\x16\x78"
          "\xac\x64\x82\x7a\x43\xf8\x01\x27\x26\xe4\x8e\xa9\x16\x39\x1e\x76\x58\x34\xeb\x91",
          "\xa4\x92\xee\x56\x20\x48\x30\x23\xef\x85\x16\x0d\x12\xb4\x0c\xf2\x34\x15\xb1\x20\xc3\xe2"
          "\x07\x0a\x85\x1b\x6d\xf1\x3d\x13\xbf\xf5\x0f\x76\x90\x3f\x86\x97\xe0\x95\x1f\x5d\xf4\x33"
          "\xb7\xc2\x0f\x3d\x8a\x5f\x04\xc7\xad\x53\x4c\x89\x3d\xb6\x95\x7b\x8f\xbb\x06\x96\x2e\xc1"
          "\xa7\x74\xab\x3a\x55\x72\x9b\x7f\xb1\xae\xc5\xea\xb6\x87\x88\x30\x15\xad\x2d\x0a\xe9\x6a"
          "\xb3\x2a\x3e\xcf\x56\x7f\x72\x41\x54\xbb\xbf\xb5\x53\xe3\xf2\x36\xfc\x41\x79\x54\xd6\x51"
          "\xcc\x33\xbf\x4d\xc0\xd0\x10\x23\x27\xd9\xb2\x83\xd8\x69\x2d\x57\xfb\xb6\x60\x50\xcf\x28"
          "\x87\x5d\x73\x69\x14\xdc\xf7\x31\xbb\x7c\xd8\x3c\xf3\x8f\x99\x43\x71\xb5\xcc\xe6\x14\xef"
          "\x8f\x34\xf4\xc8\xce\xa5\xa9\x76\x54\x40\x11\x61\x2d\x02\xa9\x69\x8c\xde\x00\x4b\x9f\xa2"
          "\x1c\x52\xf3\x94\x70\x6a\x62\x43\xc9\xab\x51\xd9\x7f\xc6\x2c\x64\x9f\x5a\x10\xf4\xfd\x19"
          "\x0c\xcf\x98\x76\x5d\x29\xff\xe0\x58\xaf\x2a\x2d\xb6\xd0\xe5\xf1\x58\x84\xac\x31\x49\x41"
          "\x6c\x12\xc4\x67\xfd\xbe\x24\x78\x31\xb8\x72\xc8\xb0\xd8\xba\x35\xcf\x56\x0e\xb2",
          1, 1920 },
        { 128, 128, 16, "\x31\x5a\x25\x06\x99\xa0\x4c\xaa\x90\x41\x6b\x75\xbf\x13\xd0\xab",
          "\xe9\x28\x10\x7a\xe8\x89\xbd\x8d\x80\x2d\x35\x08\x09\xc3\x5a\x2a",
          "\xf7\x98\x46\x35\xcb\x3f\x10\xac\xec\xc9\x4c\x3c\x81\xe3\xa9\xb9\x5e\xf6\xa3\x07\xb0\x79"
          "\x90\xc3\x8e\x42\x3a\xeb\x83\xe9\x20\x02\xaa\x0f\x70\x8b\xdb\xe6\xff\xd5\x98\x3d\x2b\xc9"
          "\x67\x06\x03\x1f\xf9\x16\xc4\x44\xfe\x28\x5f\x45\x7e\xb8\x4b\xe8\x4d\x62\x0f\x18\x38\xfc"
          "\x9a\x52\x38\xd6\x2a\x3d\x9f\xac\x3b\x23\x34\x67\x63\xb4\x31\xa6\x0e\x83\x2e\xf2\x0d\x9b"
          "\x83\x91\xd7\x53\xc5\xb3\x1e\xf9\x71\x65\xa1\x2b\x8d\x4e\x8b\xc3\xca\x56\x0f\xa8\xa7\xaf"
          "\xd3\x47\xc2\xed\x2d\x14\xfc\x7d\xe0\x3e\xb1\xb2\xc1\xb1\x28\xa3\x3a\x63\x86\xa4\xc7\x31"
          "\x7e\xb6\x93\x1a\xb0\x40\xd7\xe9\xec\xed\x67\x77\xd3\xc2\x37\x58\x18\x7c\x27\xb3\x4c\x3e"
          "\x0a\xb1\xb9\x09\x26\x53\x8b\xca\xa6\xfc\x60\x13\x30\x1c\x26\x82\x46\xa8\x17\x7d\x1a\xcc"
          "\xab\xd6\x5b\x60\x25\xe5\x08\x23\x8f\xd3\xcc\xf7\x94\x60\xb5\xc4\x90\x72\x88\xd0\x83\x1c"
          "\xae\xf0\x6d\x65\x8b\x7f\xfb\xac\x71\xf4\xc5\x29\xef\x1b\x82\x50\x36\x37\xda\x32\xb2\x8d"
          "\xf4\xe9\x35\xc3\x09\x2a\x63\xb9\x79\xe5\x93\x38\x70\x56\x8a\xef\xd2\x71\xb2\xbc\xb1\x41"
          "\x0b\xdb\x87\x16\x35\x75\x7c\x2c\x10\x6f\xaa\xbd\x48\xe4",
          "\x76\x0e\xc1\x26\xa6\x0a\xa5\x34\x4e\x40\xb1\xe9\x27\x13\x79\xd4\x80\x91\x87\xf5\x86\xb6"
          "\xf6\xc5\x3a\xf0\xe9\x6d\xeb\x70\x29\x17\x1c\x07\x2b\xbb\xa9\x2e\xce\x49\xe6\xe2\x20\x7c"
          "\x61\x33\x71\xac\x64\x91\x87\xbf\x6e\x67\xeb\xe3\x51\x20\x0b\xc7\xf4\x5a\x07\xce\xf4\xf2"
          "\x4b\x1b\x39\x67\x60\x58\xfd\x79\x12\x1f\x28\x01\x20\xbd\x24\x1e\x93\x25\x05\x5a\x58\x8d"
          "\x04\xbc\xd0\x76\x0b\x82\xbc\x63\xee\x47\xc1\x09\xe6\x12\x48\xe8\x92\x84\x07\x73\xd6\xde"
          "\xde\x03\x87\x01\x48\x3c\x38\x1d\xc2\x77\xc8\xa6\x6c\xc8\x4a\xec\x9d\x5a\x84\x86\xd6\x6b"
          "\x28\xd8\x14\x22\x53\xae\x80\x95\x71\x4d\xb9\x37\x86\xfa\x29\xf9\x8e\xfd\x78\x1a\x32\xb5"
          "\x1a\x5b\xd3\x06\x1b\xd1\x4e\x7e\x81\xc6\x05\xc1\xa5\xac\xfd\x61\x70\x3d\x42\x30\x86\x16"
          "\x46\xe3\x28\x1d\x76\x3b\xae\x9e\xe5\x07\x04\x9a\x3e\xc2\xf9\x66\x66\x08\x35\x28\x19\x07"
          "\x6c\x0e\x80\x5a\x4b\xaa\x57\x01\xfa\x81\x04\xba\xdb\xa8\x25\x2e\x5b\x35\x05\x54\x3b\xf2"
          "\x07\x6a\x8f\xad\x13\x67\x42\x6f\x48\x9a\xfd\x32\xaa\xc4\x56\x7f\x43\x29\xb8\x10\xa1\x01"
          "\xde\xf4\x19\x63\x8c\x31\x7f\xac\x50\xa3\x7f\x5e\x0a\x91",
          1, 2048 },
        { 128, 128, 17, "\x74\x26\xfb\xc5\xac\xf0\xc5\x52\xd0\xdb\x76\x89\x06\xcf\xfb\x69",
          "\xf3\xe3\x4a\x06\xcd\xdf\xa2\x62\x64\xef\x0b\xb8\x31\x33\xca\x86",
          "\xca\xc1\x74\x3b\x93\xb5\x5f\x15\x76\x37\xd7\x8c\xe2\x41\x98\xb0\x9c\x1e\xb7\x95\x8b\xb4"
          "\xe4\x3d\x30\x1d\x1a\x21\xda\x28\xda\xdd\x7f\x72\x88\xbc\x20\x36\x26\x4a\x56\x60\x3f\x67"
          "\x9e\x50\x58\x6d\xc4\xe2\x76\x04\x5d\xd1\xb0\x8d\xfa\x5c\xb4\xe5\x6c\x49\x1f\xdb\x52\x49"
          "\x1a\xd3\x96\xea\xb8\x74\xc0\x01\xfc\xe4\xa6\xaf\x4c\x6b\xd8\x53\xa3\x2e\xcf\x1e\xa2\x8b"
          "\x25\x6e\xf0\xbb\x88\xa0\x06\xca\x53\x74\xe2\xe0\xbf\x60\x36\x58\xcc\xc5\xcc\xd1\x72\xfc"
          "\x8f\x30\x3f\x5c\x10\x49\x55\xe1\xeb\xd7\xba\x97\xdc\x90\x26\xc8\xec\x0a\x53\xf2\xff\x96"
          "\x9d\xbf\xe3\x71\x2f\xa4\xe5\xfa\x0d\x4c\x6f\x71\x79\x23\xdb\xac\xbd\x4a\x03\x06\xa0\x3e"
          "\x52\xd9\xf6\xbf\x0b\xe6\x86\xa3\x51\x77\x07\xa6\x44\x6b\xb6\xb7\x8e\x60\x93\x34\xdd\x16"
          "\x87\x74\x14\x62\x55\x62\xad\x32\x69\x0c\x5e\xa4\x63\x9a\xc3\xd3\x5d\x17\xf5\xf3\xd3\x40"
          "\x4a\xe1\xb7\x45\x72\x92\x7c\xac\x50\x70\xa0\x00\x5e\x46\x7e\x0b\x8d\x80\xbd\x38\x7c\x0e"
          "\x03\x28\x11\x25\xae\x09\x68\xb1\x38\xe1\xbe\xb8\x56\x28\x08\xe8\x1c\x3a\xa5\x90\xe3\x3e"
          "\x09\xf5\x73\x6e\xf0\x0b\xb9\xfa\xa7\xbe\xc7\x53\xc1\x81\x67\xe5\x28\xb1\xec\x41\x23\xd9"
          "\x9b\x73\x5f\x98\xe5\xf7\x2d\x47",
          "\x4b\xf3\x37\x7a\x8c\xd3\xe6\x13\x22\xbb\x2d\x57\xff\x9b\xec\xe2\x57\xe0\xdb\xfd\x32\x56"
          "\xe1\x68\x9c\x96\x35\x02\x15\xa1\x16\x9a\x03\x21\x66\x46\x42\x1a\x1a\x23\x8c\xbe\xbf\xa5"
          "\x7e\x02\x67\xa8\x01\x28\xf5\x60\x53\x8d\xd0\xf1\x7a\x1b\xf4\xe4\x86\x36\x0f\xa4\xc7\xd2"
          "\xe1\xa9\xb5\x28\x43\x48\xc5\x7f\x0c\x2b\xe0\x6d\x16\x54\xc8\xae\xba\xa2\xe9\x61\x84\x8a"
          "\x00\xb6\xde\x4f\x58\xa6\xf3\x22\xe3\x44\xa2\xbc\x75\x0e\x4d\x9a\x3e\x26\x02\x79\x84\x62"
          "\xc2\x71\xa8\x46\x3d\xb9\xeb\xf9\x56\xf9\x55\xa6\x19\xe6\x22\x8c\x51\x99\x8d\x51\x4c\x40"
          "\xa3\xb7\xc3\xb4\x5f\x40\x12\x40\xfc\xe6\xbd\x44\xba\x23\x82\x92\x67\xf3\xdf\x66\x08\x51"
          "\xce\x19\xb1\x0b\x7d\x1f\xc9\x81\x1b\x3e\x2f\xb8\xd2\xaf\x19\x5e\x67\x0f\xcf\xa8\xb2\x29"
          "\x05\xdb\xae\x8a\x12\x66\x63\x55\x76\x83\xc0\x2d\x5d\x17\x95\x84\xb5\x8a\x71\xe5\xb8\x60"
          "\x2e\x9f\x17\xba\xbf\x9e\x31\x22\x3b\xf2\x26\x0a\x06\xf4\x44\x2d\x77\x49\x9b\xa8\x65\xed"
          "\x7a\x03\x93\x10\x97\xcd\x76\x54\xb7\xde\xf6\x2c\x87\x9b\x1c\x0a\x37\x1a\xdb\x94\x96\x19"
          "\x31\xb2\xef\xc8\x8b\xcc\x52\xe0\xa8\xca\xc8\xd0\x05\xd8\x73\xa4\xcc\x4e\x72\xf7\x92\x04"
          "\xa8\xcc\x24\xc8\x5a\xb9\x13\x85",
          1, 2176 },
        { 128, 128, 18, "\x4e\x6d\x7b\x91\xaf\x62\xf4\x85\x33\x9d\xb3\xe2\xde\x43\x0f\xf0",
          "\xae\xfc\x2a\xbc\xc3\xc6\xb8\xac\x4c\xac\x64\x93\xc7\x30\x48\x4c",
          "\x8d\xca\x93\xe8\x02\xaa\xfc\xac\x4d\xd6\xa5\xf3\xd1\x7d\x7e\x25\x2e\xc5\x92\x23\x9a\xce"
          "\xd8\x42\x0a\x3f\x13\x42\x82\xa2\xd2\x98\x69\x14\xdb\xb0\xa7\x9f\x6f\x46\xcf\x7b\x3c\xf2"
          "\x25\xaa\xb9\x49\xa3\x1a\x8f\x22\x37\x68\x4d\x14\x99\x0f\x33\x8c\xbb\xe7\x72\xdf\xf6\x5a"
          "\xce\x7b\x96\x1c\x96\x36\x1b\xce\xee\xad\xee\x36\xd0\x31\x72\x49\x49\x4f\x11\xd4\x46\x1e"
          "\x42\x0c\x54\x16\x54\xea\xf7\x19\xd5\x67\x2a\x19\xb1\x01\xcb\xeb\xd0\xb4\x84\x09\x60\x81"
          "\xd8\x4f\x2f\x57\x68\xd6\x30\xd8\x8e\x3e\x88\x06\xea\x42\x48\x42\xb4\x94\x4f\x85\x33\x5e"
          "\x96\xca\x90\xe1\x4d\xd4\xdb\x36\xc0\xff\xc6\x26\x60\x91\x39\x0f\x88\xdf\x3e\x77\xfe\x49"
          "\xd7\x76\xc2\x90\x66\xec\xcd\x12\xcb\xa2\xc6\x3d\xfe\x49\x0c\x1b\xa7\xa8\xb1\x0f\x4b\x47"
          "\x6c\x92\xab\x6d\xcf\x8e\x5d\x54\x02\x5b\x5b\x57\x09\x43\x5a\x07\xf0\xc0\xe3\x81\x67\xc6"
          "\x5a\xfe\x24\xf7\x67\xee\x4d\xe8\x42\xd6\xe7\xf6\xa1\xa0\x05\x8e\xb5\x46\xac\x88\x6b\x84"
          "\x7e\x8a\x5d\x06\xf0\x66\x8a\x76\x0c\x93\x60\x6c\xe3\x52\xa3\x94\xa8\xd5\x65\xce\x9c\x9f"
          "\xda\xb9\x4a\xdf\xab\x59\x8a\x08\x2f\x25\x0f\x88\xee\x0e\x95\xf8\x8a\xae\x19\xb1\x3e\xb3"
          "\xa9\x62\xe3\xbf\xd7\x54\x55\xc8\x4b\x66\xc6\xce\x22\xa1\x78\x5b\x52\xba\xfd\xca\x7a\x8c"
          "\x5d\x09",
          "\xdb\xf3\x20\x25\x06\xa5\x07\xf9\x64\xfb\x32\xca\x40\x84\x76\xff\x28\xf0\x86\x33\x01\x62"
          "\xfe\xe4\xfb\xc3\x77\x86\xc2\xcd\x8b\xf2\xcd\x80\xff\x6d\x76\x2a\xa3\xf6\x66\xef\x38\x2c"
          "\x49\x03\x56\x8c\x07\x34\x15\x17\xe0\x19\x33\x3c\x14\x3b\x14\x4e\x35\xa9\x0b\xb5\xde\x44"
          "\x72\xe5\x49\x5e\xde\x72\xc2\x22\xed\xa6\x4a\xb2\x0b\x38\x9d\xab\x50\xf1\x2e\x5a\xb9\x55"
          "\xab\x28\x8b\x73\x38\x6c\x4c\xc4\xc5\xbe\x90\xf0\x4b\x18\xcc\xbc\xb2\xbf\xe3\xab\xa8\xab"
          "\xfd\x8a\xe8\xc7\xfe\x04\x5b\x10\x17\x19\xa4\x19\xa7\x29\x24\x56\x25\xc5\x8f\x47\xeb\xff"
          "\xe3\xdc\xd0\xec\x79\x99\x26\x14\xb6\x52\x0f\x79\x1e\x8d\x96\x46\x95\x62\xa2\x45\xc3\xc7"
          "\xfe\xe8\x81\x6a\x4d\x3f\x9d\x72\x10\x30\x39\x5a\xb2\x47\xbd\x06\x5d\x14\x3f\x59\x17\x98"
          "\xc6\xaa\xc6\xa2\x92\x3d\x0c\xeb\xac\xd6\x4b\x63\x23\xf7\x98\x5c\x35\x53\xe0\x48\x81\x1b"
          "\xc7\x4d\x1d\x7f\x85\x75\x48\x61\x8f\x24\xe4\x59\x82\xe6\xa3\x93\xfe\x39\x15\xf2\x53\x6f"
          "\xd0\x33\x9f\xa9\xe5\xa9\x10\x44\x27\xbd\x93\x80\x8a\x82\x63\x5c\x98\xe5\xa2\x27\x37\x32"
          "\x52\xb1\x36\xdd\x9c\x98\x16\x43\x03\x94\xd0\xc1\xa5\x91\xce\x79\x4e\xaf\xc6\xf5\x5b\x2d"
          "\xd0\x9b\x0d\x4c\x6d\xd3\x1a\x90\x56\xbe\x3f\xd0\xa1\x1b\x6f\xba\x7b\xf3\xf8\xcd\x3d\x2d"
          "\x8c\xd3",
          1, 2304 },
        { 128, 128, 19, "\xb9\xfd\xa2\x14\xb2\x96\xe0\x88\xbe\xd2\xe5\x21\x33\xa9\x61\x6e",
          "\xb6\xfe\x22\x78\xa7\x3b\xb7\xbe\xed\x49\x06\xb1\xda\x62\xbb\x34",
          "\x5b\x10\x90\xc4\xf8\x23\xdf\x82\x67\x83\x1b\x2d\x4b\x7c\x2b\x12\x20\x0b\x2b\x23\xc9\x34"
          "\x2b\x4d\x77\x24\x2f\x09\x92\x6a\x82\x00\xaf\xbf\xaf\xb7\xf8\x99\x68\x66\xc4\xf1\xa2\xaa"
          "\xed\xf3\x6f\xf2\xe8\x81\x33\x2b\x97\x3b\x48\x52\xa0\x37\xea\x05\x57\x03\xc2\x71\x38\x0e"
          "\x84\x43\x43\xf6\x3a\x85\x78\x61\xd5\x39\x69\xd9\xec\xc6\x93\xaa\xf7\x37\x26\x18\x7b\x8c"
          "\x32\x17\xd2\x17\xa7\xf1\xdb\x08\xe1\x6b\x4d\x3c\xd3\x8e\x6c\x1e\xce\x47\x52\x47\x22\xc3"
          "\xc5\x80\x36\x8b\xe1\x48\x02\x60\x00\xdf\x52\x95\x90\xec\xd4\x12\x9a\x97\x93\x52\x28\x9b"
          "\x0b\x16\xc6\x25\x5f\x9d\xe4\xf8\x0d\x3e\x44\xcd\x3d\x6d\xf2\x6d\x01\x23\xe7\x8f\x2c\x63"
          "\x65\x1e\x9c\x8e\x76\x0b\x69\x1a\x2c\xa5\x30\x33\x58\xc7\x43\x38\xed\xdf\xa5\x46\x73\xc9"
          "\x4a\xef\x44\x84\xef\xd9\x60\x6d\x31\x0d\xf3\xb0\xa2\xaa\x69\x84\xc5\xc7\x13\xa8\xed\x1b"
          "\xe7\xc4\x84\x61\xb5\x44\x9f\x60\x74\xa1\xc4\x3d\x44\x9d\x78\xab\x1f\x93\xe7\xe2\x2a\x87"
          "\xf6\x00\x6f\x8a\x0d\x09\xbf\x94\x6b\x71\x8a\xb4\xc7\xc8\x17\xbc\xe7\x4d\x7e\x35\x7b\xcf"
          "\xe8\x2c\x47\x22\xda\x6a\x53\x1a\x38\xbd\x6a\x39\x7b\xb6\x74\x66\xb5\x49\x96\x8f\xb4\xe3"
          "\x76\x18\xcc\x29\x4d\x6b\x71\x42\x31\x39\x93\xc1\xf9\x4c\xd5\xf2\xac\x74\xdf\x25\xe4\xeb"
          "\x87\x2d\xbb\xd4\xcd\x33\xd1\xe1\xec\xc0\xb0\x2b\x6d\xad\x33\x4a\xec\xbb",
          "\xa6\x74\xb9\xcc\xa2\x1b\x41\xe9\x3a\x21\x4c\x93\x1b\x77\x91\x7d\x5f\x21\x25\x0d\xd2\xdd"
          "\xca\xdc\x50\x50\x33\x5b\x7a\xbc\x2a\x4f\xaf\x35\xc6\x83\x49\x30\xe1\xcf\x68\x66\x8b\x54"
          "\x56\x2d\xfe\x66\x0b\x64\xa8\x8e\xb6\x5a\x58\x5c\x5f\xa9\x96\x30\xd6\x22\x3b\xe2\x72\x2f"
          "\x1f\xf2\xdc\x37\x83\x11\x23\x8c\x82\xd9\x05\x2f\x57\xe0\xc3\x23\x32\x0d\x3a\xcb\x96\x03"
          "\x2a\x41\xf2\xc8\x91\xba\x08\x6e\x67\x73\x99\x10\xd0\xce\xbc\x46\x8e\x6d\xd1\x59\xaa\xc0"
          "\x82\xde\xf2\xb2\x02\xa1\x75\x54\xa0\x1a\xec\xe3\x89\xfc\x5c\x2a\x84\x18\xae\xcb\x9f\x1e"
          "\x04\xe4\xee\x6a\x0b\xc5\x2e\x62\x66\xed\x35\x9b\xa3\x71\xfd\xe0\x86\xf2\x38\x0d\x49\xb9"
          "\x03\x35\x54\x43\x1e\xbe\x67\x66\xe1\x03\x32\x77\xf4\x72\xae\x5f\xff\x8e\xe9\x04\x6c\x8f"
          "\xfd\x24\xf5\x39\x71\x3b\x45\x85\xfc\xcc\x9d\x45\x49\x87\x2d\xe5\xd5\x73\x92\x30\x0b\x4a"
          "\x37\x33\xad\x84\x34\xf3\x4e\xac\x43\xbb\x00\x51\xea\xab\x41\x67\x73\x6c\xd1\x93\xc8\x63"
          "\x1b\x96\xed\x10\x9c\xd7\x20\x38\x48\xe9\x5c\x3a\xf3\x9a\x1b\xae\x52\x73\x5c\xa3\xf5\x08"
          "\x58\xfa\x69\x23\x98\x8d\x83\x70\x39\x6d\xbd\x21\xe9\xe8\x62\x7f\x7a\x17\xfe\xef\x8a\x18"
          "\x90\x3d\xae\xa1\x95\x92\xc2\x55\x9f\x87\xae\x32\xea\x42\xbf\x62\x8e\x28\x6e\xc9\xd6\xaf"
          "\x56\x7a\xd4\x03\x18\x8f\x05\x12\xad\xec\xf0\x43\xf8\x73\xd5\x78\x55\x02",
          1, 2432 },
        { 128, 128, 20, "\x08\x47\xa3\xc2\x06\xdc\x6e\x25\x0e\x25\xcf\x21\xcd\xc2\xd3\xa5",
          "\x00\x0e\x4b\xf0\x88\x88\x40\xea\xd3\x6f\xbb\xfa\xe8\x79\xaa\x00",
          "\x9c\x96\x76\x9b\x1e\xd7\xc6\x2c\xc3\xbc\x48\xcd\xb4\x21\x45\xd9\x51\xf5\xa5\xed\x3d\x65"
          "\xfb\x74\xa9\xec\x7a\x0e\x4d\x7c\x35\x62\x7d\x36\x69\xac\x36\xc8\xe9\x73\xc2\xe3\x4c\xca"
          "\x85\xdb\x3e\x65\x78\x37\x8a\x02\x37\x4d\x22\x2a\x0f\xbc\x7b\xa1\x9a\x1d\xc6\xe1\x5e\x97"
          "\x29\xbd\x19\x47\x0d\x6b\x43\x62\xde\x77\x73\x52\x8c\x40\x82\x1a\xfc\xa0\xb2\x73\x88\x23"
          "\x43\x17\x3c\xb8\x7d\xe9\x90\x50\x81\x91\xfa\xa1\x85\x49\x22\x44\xdc\xaa\xb4\x05\x04\x2a"
          "\xc6\x23\xc5\x22\x2e\x03\x9a\x8f\x33\x33\x9e\x1d\x19\x27\x06\x91\xad\x47\x72\x9e\xcf\x5c"
          "\xc5\xad\x48\x6f\x51\x06\x8c\x05\x83\x71\x9b\x43\xa5\x0a\x73\x5a\xc8\x03\x58\xa3\x2c\x1f"
          "\xfd\xfa\x07\x97\xf1\x5e\xb7\xf6\x80\x86\x37\x66\xd7\xfd\xec\x73\x08\x84\x1f\xb5\x40\xca"
          "\x52\x02\x2c\x77\x6f\x23\xcc\xd9\xf9\x3a\x1e\x6f\x87\x84\xa5\x25\x18\xad\x24\x40\x14\x60"
          "\xb2\xa9\x11\x7d\x30\x94\x11\xd8\x0f\xfd\x40\xc6\x4b\xdd\xc1\x12\x4f\x75\x58\xed\x1b\xf5"
          "\xec\x95\xa6\x24\xc0\xf4\x54\xd9\x64\xd8\x9e\xee\x92\xf7\x32\x64\x45\x89\x1e\xbd\xa1\x59"
          "\x25\x23\xe8\xf7\xd7\xef\x6c\xb3\xcc\x99\x26\x9a\xc7\xcc\x21\x0c\x88\x06\x0e\xbc\x63\xae"
          "\x2f\x13\x08\x48\x83\xf7\x52\x1b\xb3\x5b\xb6\xcf\xc7\x7e\xe7\x30\x2a\x74\x57\x62\x86\x14"
          "\x2d\x1f\xb1\xb0\x9d\x92\x61\x92\xb3\xca\xa4\x6b\x66\xf8\x18\x5b\x21\x67\x17\x40\xce\xca"
          "\x8b\xc1\xb0\x00\xdd\x8c\x6a\x52\xdd\xe6\x4a\x5a",
          "\xb2\x68\xed\xbb\x58\xc0\x17\x2d\xd2\xf8\x71\xe7\x06\x39\xf8\x62\x88\x31\x58\x04\xb6\xed"
          "\x2e\x27\xbe\xef\x30\x6f\x1e\x00\x5f\xf1\x71\x98\xe5\xc1\x9a\x8d\xf9\xad\xff\x38\x35\x65"
          "\x8c\x84\xa5\xea\xf0\x7a\x03\x3b\xda\xaf\x52\xcd\x69\x34\x38\xb0\x99\xd8\xff\xa4\xaa\x5b"
          "\x01\x7e\x33\x7e\xc7\xcc\x6d\x2e\x1b\x19\x6b\x07\xde\x42\x08\xe4\x49\xe8\x66\x99\x06\xee"
          "\x27\x04\x2d\x2c\x5f\x17\xe2\x6b\x59\x8e\x68\x51\x74\xa7\x1e\xe1\x64\x7c\x64\x07\x22\x8a"
          "\xb3\xe7\x12\xbc\x05\x06\x8d\x71\x69\xc6\xc2\xe9\xea\x54\x37\x38\x60\x9b\xe8\xd3\xf9\x53"
          "\x29\x09\x74\x3b\x61\x68\xbc\x94\x04\xdb\xc5\xee\x94\xfc\x09\xf7\xd8\xda\xf6\x29\xb6\x8c"
          "\x34\xf6\xe3\x71\x61\xdc\x1c\xdc\x44\xb0\xf9\x69\x62\x44\xa4\x14\xf0\x1a\xae\x6b\x52\xbf"
          "\x33\x5a\xd4\x40\x5c\xf6\x66\x76\xa4\x9f\x1a\xdd\x61\x5d\xa7\xa6\xf4\x37\x01\x2b\xf8\xf1"
          "\x70\x22\x73\xda\xe3\x91\xac\xcf\x96\x0d\xbb\x27\x36\x6e\x85\x00\x2f\xa6\x62\x2b\x10\x77"
          "\x3b\xe4\x12\xff\x44\x8a\xde\x15\x30\xe3\x22\x9b\x06\x9c\x10\x82\xc6\x26\xc5\xbd\x34\x8b"
          "\xbd\xab\xb2\xa4\x73\xb7\x49\xd7\x4e\x93\xca\x30\x8e\xc7\x6e\x92\x5c\x23\xb1\xee\xeb\xc4"
          "\x8b\xcf\xc0\x59\xaa\x7c\x3d\x1f\xff\xec\x42\x24\xb6\xab\x95\x68\xab\xd6\xcd\x24\xf2\x1d"
          "\xd3\xe2\x55\xa3\x2e\xb6\x49\x33\xb4\x72\x32\x34\x80\x19\xbb\x5b\x9f\xdc\xa3\xe1\x60\xa2"
          "\x2a\x98\x1e\xe2\x21\xbc\x6c\x28\xa7\x2a\xeb\xd7",
          1, 2560 },
        { 128, 128, 21, "\x8f\xac\xab\x40\x3d\x1a\x0e\x36\x80\x71\xc8\x6d\x34\x21\xa5\x7c",
          "\xe4\x58\x9b\xf3\x3f\x4a\x93\x09\x14\xca\xa0\x9d\xf8\xfa\x7a\xd8",
          "\x43\x53\x58\x6c\xac\x1e\x25\xb4\x48\xd2\xfc\x0a\x14\x3f\x31\xa5\x68\xcf\xd7\x56\x1e\x1e"
          "\xe2\x07\xde\xcc\x60\x02\x61\x4e\x5a\x5a\xa3\xe4\x2c\xaf\x48\xdd\xd7\xa9\x5b\x11\x34\x5b"
          "\xe7\x1a\x7d\xf7\x6e\x45\xdc\xbc\x28\xb2\x85\x78\xf8\x2c\x66\x7c\x96\x69\xe9\xcf\x79\xf6"
          "\xc7\xe3\x14\x8f\xa7\x67\x87\x12\x8f\xb0\x82\x1a\xe8\x90\xfc\xad\x26\x49\xd7\xa8\x2e\xb6"
          "\x58\xd9\x15\xbe\x30\x3a\xd3\x3d\x04\x89\x5a\xca\xf7\x91\x1f\x6d\x43\x3d\xc2\x09\xbd\x85"
          "\xdc\x89\xb4\xf1\x53\x7f\x3c\xbf\x73\x09\x00\xbd\x27\x32\x2b\xae\xfc\x6e\x16\x1d\xc2\xc2"
          "\x80\x7b\xd4\x72\xec\xbf\x9a\x9d\x9b\x66\xa4\x15\xe2\x4a\xe9\x90\x50\x2a\x93\x64\x78\x9b"
          "\x76\xbd\x92\xdf\x1e\x5c\xa8\x0f\x11\x5a\x1e\xe7\xb7\xf4\xbf\xb2\xbf\xdd\x85\x9b\x05\x59"
          "\x8b\x38\xae\x17\xf2\x67\x36\x14\x15\x28\x6c\x68\xbd\xe2\xee\xab\xa5\x35\xd5\xaf\xf6\x1a"
          "\x52\x40\x74\xed\xbc\x28\x86\xdd\x8c\xd1\x70\x54\x27\x8c\x8f\x4e\xd9\xed\x46\xb6\x0b\xc9"
          "\xe8\x7c\x6c\xcb\x2c\x50\x37\xb7\xd9\x44\x97\x9a\x7a\x11\xf2\x82\xea\xc1\xa4\x60\xb4\xc1"
          "\x14\xad\x0c\xfa\xf6\x11\x95\x9a\xb2\xa2\xaa\xf7\x7c\x77\xb2\x2f\x16\xf9\xac\x01\xd0\x64"
          "\x5f\x0a\x29\xde\xe3\x2c\x0e\x46\xac\xeb\xfa\x3c\xe1\x29\xcc\x35\x4a\x42\x9b\x60\x06\x98"
          "\x16\x38\x3f\x30\xad\xfc\xef\xec\x0a\xe2\x7f\xed\xf9\xef\x20\x1e\x78\x1a\x51\xb5\x9a\x42"
          "\xfa\xad\x4a\xa9\xc0\x6d\x0f\xff\x92\xec\x33\xa6\xcd\xee\x68\x22\x56\xcd\xe2\x02\x68\x73"
          "\x33\x6d\xf3\xf8\xaa\xa6",
          "\x87\x24\x4b\x50\x28\x3d\x83\xb4\xac\x5c\x4d\x3c\x63\x0f\x23\x00\x88\x10\x9c\x5e\x32\xfd"
          "\x22\xf2\xe2\xef\x4e\xe3\x50\xe0\x7e\x19\xf7\x01\x0f\x76\x80\x30\x4b\x54\xb1\x98\x00\x9b"
          "\x52\x78\x94\xb3\x32\xe7\xa0\xcd\x97\x63\x9f\x9f\x73\x2c\xd0\x83\xb0\x15\x80\xb7\x02\x22"
          "\xa3\xc4\x3d\xf7\xa8\x8a\xf7\x1d\x51\xb6\xa1\xfb\x19\xcd\xd6\x8a\xf7\x68\x79\x61\x7e\xdc"
          "\x4b\x24\x9f\xbb\x4e\x56\x5d\xe6\xfe\x3f\x96\x35\xae\xef\x85\x12\x0f\xa3\x6a\x61\xcd\x7c"
          "\x9c\x8c\x6a\x82\xbb\x1d\x4d\xdf\xbb\xd2\x0f\xc4\xf3\xdd\x1e\xc5\x80\x23\x0e\xc2\x05\xf2"
          "\x03\xa5\x93\x4b\xf3\x99\xe3\xea\xc1\x85\xbf\x27\x0e\x99\x56\xc7\x01\x74\xff\x9c\xc9\x13"
          "\x36\x2e\x2a\xda\x75\xfc\xc4\xa0\x3c\x25\xc1\xbd\x07\xfd\x33\xb4\xa3\xdb\x1d\x7b\x11\x8c"
          "\x39\x03\x63\x97\xb6\xa3\x95\x0f\xd4\xbb\x9f\x4e\xf0\x8f\xa7\x17\x56\xe0\x85\x14\x89\x54"
          "\xd3\x74\xea\xc7\xbe\x3a\xd7\x92\xc0\x18\x9b\x6c\x92\x50\xf6\x7e\x63\xb1\x8b\x53\xa9\x3d"
          "\xab\x77\x4b\x3f\xd0\xec\x0e\xcb\xcc\xd0\xc1\xeb\x62\xa1\xb7\x8c\xa8\xc3\xf1\x90\xf9\x78"
          "\x72\x8b\x9f\x64\xe0\x5b\x41\x07\xc8\x1f\x37\x45\x1e\xb6\x65\x05\xb1\x5b\x9b\xb5\x70\x93"
          "\x94\x25\x05\x19\x15\x06\xa1\xfd\xd2\x72\x9d\xe9\xc3\x84\x97\x8a\x0a\x6f\xd4\x6a\x46\xc3"
          "\x6d\xb1\xff\xfa\xc2\xbc\x2e\x96\xb3\xd1\x3e\xe7\xc2\x7c\x58\xb2\x63\x14\x2e\x22\x88\xd1"
          "\x15\x92\x66\x8f\xfe\x96\xe8\xb1\x9b\x21\x8d\xc0\xfa\xe9\xe1\xeb\x62\x5b\xd2\xc3\xd2\x7e"
          "\x64\xb4\x83\x02\xdf\x4e",
          1, 2688 },
        { 128, 128, 22, "\x5a\xe4\xf5\xb4\x41\xf7\x18\x6b\xc8\x1c\xf6\xef\xd9\x7e\xb6\x5d",
          "\x14\x14\xe1\xd3\xd5\x1f\xd4\x4c\x18\x75\x50\x5c\x71\xf5\xcd\x24",
          "\xc3\x0e\x0f\xec\xe2\xb7\x5d\x11\xeb\xf9\xf1\xa2\x7b\xb2\x94\x6a\x10\x2f\x68\x8f\xd1\x4e"
          "\xd6\xe8\x2f\xc5\x8f\x3c\x02\xf8\x53\xc3\x3f\x5d\x76\xcd\x02\xdb\xe0\x1a\x59\x17\xf5\x8b"
          "\xe4\xf1\xa1\x30\x23\x50\x1f\xc3\xb4\x80\x42\xfb\x03\xe5\x2f\x43\x46\x3b\xcb\x30\x7e\xd4"
          "\xc4\xd3\xf8\x56\x34\xb6\x1d\xb7\x39\x35\xc5\x10\x04\x4e\xdb\x56\xc0\x32\x95\x16\xa1\xd5"
          "\x32\x3e\x33\x9c\xdf\x91\x11\xad\x27\x87\xdc\x45\x4e\x22\xe3\x61\x65\x05\x0f\xd8\xd3\xfb"
          "\xdc\xe9\xba\x2e\x2c\x5c\xd3\xcb\x9b\xe1\x46\xa9\x2c\x4c\x5f\xe6\x60\xd9\x62\xc7\x93\x3e"
          "\xfd\xef\xd3\x2d\xd2\x1b\x21\x05\xad\xc2\x9e\xf7\xa6\x89\x12\x94\x64\x87\xcb\x46\x60\x21"
          "\x7e\xc7\xa0\x79\xd3\xc0\x6c\x84\x80\x6e\x85\x1f\x01\xe7\x61\x5d\x3b\x59\x55\x88\x5e\xa7"
          "\x91\xca\x51\xbe\x00\x83\x63\xa6\x6a\x30\xde\x37\xcd\x95\xb3\x92\xa1\x95\x89\x8d\xaa\x3a"
          "\x9e\xb8\x29\xf2\x11\xfb\xcb\x48\x61\x41\xac\x28\x49\x45\x14\xbe\x40\xc7\xd3\x2b\xf2\x14"
          "\x83\x58\x6a\xf6\x1e\x49\xda\x5a\x6e\x18\xc5\x00\x68\x70\x24\x41\x11\xad\xb8\x00\xfa\xb2"
          "\x6c\x1b\x56\x49\x6e\x51\xfe\xf7\x42\xa2\x61\xb8\x02\xdb\x0f\x4c\xac\x40\xaa\x19\x0e\xf8"
          "\x3d\x8d\x40\x19\xd0\x95\x14\x66\x22\x6b\xcd\xd6\xdb\x46\xe7\x4a\x5d\xf0\x4c\xbe\xd8\x77"
          "\x86\xee\x6e\xbb\x2f\x93\xa1\x6c\x10\x90\xfc\xc9\x0f\x7f\x27\x85\xc2\xbe\x9d\xd2\xd5\x56"
          "\xeb\xd1\x4f\x09\x4d\x54\x7b\x47\xd7\x9a\xa4\xeb\xd3\xaf\x10\xae\x4a\x0f\xf7\xb3\x14\xbb"
          "\x95\x5e\x5e\x45\x9d\xc1\x62\x6b\x8c\x65\x40\xb8\x81\xfd\x76\x2e\x71\xe1\x06\x02\xfd"
          "\x5b",
          "\x4d\xb6\x10\x3d\xc7\xd8\x58\x8e\x1d\x59\xbf\xc9\x2f\xbd\x1b\x4c\x07\x1a\xf3\x50\xf3\x2b"
          "\x32\x66\x86\x33\x2e\x9b\x3d\xf9\xa2\x10\xc9\x74\xc2\x76\x16\x55\xb1\xcd\xf3\xfb\x41\x10"
          "\xe5\x0f\x2c\x80\xed\xdd\x03\xd9\x77\xb6\x5f\xc4\x1b\x7a\xd1\x51\xdc\x97\x2e\xfd\xf5\x34"
          "\x07\xbf\x13\xf9\x0d\xb8\x0e\x68\x06\x2b\xef\xeb\x9c\xa0\x8e\x24\x65\xeb\x3c\xcb\x8c\x94"
          "\xd4\x4f\x31\xe3\x5f\x26\xce\xbd\x6c\xf2\x24\xd9\xca\xa4\x3f\x8f\xb1\xa1\x9e\xad\x87\x25"
          "\xd1\xa7\x25\xc6\x43\xcf\xd2\xd6\x5a\xc3\xbb\x62\x39\x5b\xee\x6c\xda\xfd\xc1\x8b\x0d\x86"
          "\x68\x43\x65\x35\x4b\x48\xfd\x4a\x54\xdb\x3e\xe0\x72\x88\x4a\xb3\xf2\x3a\xcc\xce\x8a\x69"
          "\xec\x54\x10\x2d\x61\xe5\x8f\x3d\x77\x80\x77\x21\x48\x4b\xef\x8e\x28\x78\x98\x06\xd6\x7e"
          "\x82\x3f\xcf\x83\xed\x0d\xba\x58\x52\x88\x10\x1d\xad\x74\x24\x78\x50\x0b\xfa\x7c\xb2\xee"
          "\xb5\xbd\x3a\x10\xe8\x41\xcb\x73\xf7\x9f\x9b\x07\x9d\xfc\x3a\xf5\x86\xc7\xd6\xd9\x34\x9b"
          "\x4f\x3d\x51\x5e\x5a\x6e\xd2\x17\xbc\x98\x6e\x27\x59\xef\x6c\xcb\x2e\x74\x64\x98\x50\x6a"
          "\x91\xc7\x1f\xa0\x33\xaa\x02\x70\x2a\x3f\x18\x13\x15\x84\x33\x11\x1d\x99\xf7\x9a\x80\xa9"
          "\x77\xba\x05\x24\xa6\x0b\xfd\x12\x0f\x7e\x6c\x3e\x88\x19\x94\x02\xc4\x37\x33\x76\x31\xbe"
          "\xf9\x62\x93\x7f\x27\x6d\x48\xb1\x36\x77\x77\x30\x70\xce\xef\x8e\x50\xdf\xc3\xbf\x48\x61"
          "\xe1\x84\xb7\x81\x0f\x60\x65\x63\x4c\x2a\x72\xc9\x1e\x04\x6c\x5d\xa4\x59\x09\x77\xa1\xed"
          "\xcb\xea\x43\x0f\x85\x29\xcd\x6b\x83\x1f\x2d\xf7\xe4\x7f\xec\xe0\xfb\x0a\xee\xab\xd7"
          "\xfd",
          1, 2816 },
        { 128, 128, 23, "\x10\xfe\x63\x77\x55\x56\x1d\xcb\x62\x84\xaf\xa9\x83\xd5\xa2\xdc",
          "\x1f\x50\x5e\x90\x22\xac\xef\x23\x6d\x49\x45\x63\xe2\x97\xc5\x2d",
          "\xe1\x66\x72\xa0\xac\x1f\x94\x0f\x4e\x33\xca\x76\x9e\xda\x71\x67\x31\x12\xb6\x67\x44\x6b"
          "\x9d\x58\x28\x4f\xac\xda\xdb\x9e\x65\xdf\xeb\xe4\x1e\x32\xea\x40\x72\xbf\xe0\x9b\x4f\x26"
          "\xa9\x56\x84\x00\x04\x1b\x9b\x2f\xb3\x8c\x4c\x86\xb3\xcf\x0c\xad\xfe\xb5\xe0\x94\x9a\x03"
          "\xe0\x90\x2f\xe1\x75\x23\xc6\xb4\xfb\x6a\x94\xc6\x22\xb5\x1e\x89\x7e\x92\xf6\x41\xc1\x1e"
          "\xad\xcd\x83\xd4\x02\x67\xec\x1a\xc1\x62\x1b\x20\xdb\x99\x88\x40\x0c\x4f\x3c\x0a\x10\x27"
          "\xc9\xb3\x91\xac\x05\x9d\xfe\x98\x6f\xef\xa8\xf5\xa6\xc4\xc2\x7a\xc6\x05\xf3\x6d\xca\x59"
          "\x5a\xbc\xba\x13\xa8\x11\x94\x25\x46\x46\x9d\x40\x60\x5b\x10\x9b\xfe\x2a\x46\x4f\x33\x00"
          "\xf9\xdb\x5e\xde\xdc\x4f\xc1\xb5\x5a\x9d\x4d\x0d\x03\x5c\x2c\x1d\x50\xc5\x66\xa1\xeb\x66"
          "\xac\x8f\x19\x71\xa8\x07\x7f\x46\x01\x72\xa2\x86\x93\x53\xac\x39\xe6\xbe\xb6\x8e\x6f\x87"
          "\x2c\x81\x6c\x9a\x8f\x3e\x1a\x84\x58\x2d\x76\x7f\x95\x9e\x4b\x59\x5f\x69\xe6\x28\xa8\x53"
          "\x7b\xe5\x1a\x23\xd5\xf0\xf1\xce\x59\xe4\xb0\xf6\x78\xd2\x95\x52\x7c\xdd\xf1\xb8\xd3\x16"
          "\x7c\xd2\x89\x6d\x0b\xce\xf6\x13\xdc\xdc\xa3\x58\x0a\x5b\xa0\xff\xf5\x25\x54\xe0\xa4\xd5"
          "\x64\x86\x47\x53\x7f\x87\xdb\xa6\xc5\x42\x7b\xcb\x05\x4c\x13\x64\x3d\x06\x91\xfd\x8d\x8a"
          "\xcf\x40\xd1\x6c\xba\x2d\x81\x3f\xb8\xb1\x26\x43\xa2\xe2\x53\x4d\x0e\xe3\x18\xbd\x79\x55"
          "\x61\x3e\x7e\x95\xd7\xe6\x79\x56\x66\x1e\x6b\x2d\xe5\x21\xa9\x70\x93\x70\x4a\x58\xae\x9f"
          "\x81\x86\x35\x6c\x22\x68\xba\x03\x76\x4d\xd8\xfe\xe9\x53\x11\xcb\xa1\x13\xdc\xae\xa0\x21"
          "\x48\xb4\x52\xfe\x09\x31\xf2\x7e\xb8\x5d\x26\x55\x4d\x57\x4e\x30",
          "\x82\x0d\xaa\x75\x0b\x9a\xfb\x54\x69\x22\x7a\x63\xb5\x79\xac\x6a\xf0\xb9\xfb\x4f\xda\x57"
          "\x90\xd7\xa9\x91\x21\x26\xf4\xa2\x5e\xb4\xa4\x84\x45\xbc\x69\x96\x9b\x8b\x61\xda\x00\xbb"
          "\xba\xaa\x88\x9d\xe7\x73\x7d\x99\x86\x74\xf6\x63\xfd\x5d\xd5\xe4\x1b\xa3\x43\xa6\x0e\xd9"
          "\x4a\xa3\xdf\xa5\x9b\x74\xe5\xbd\x96\x4b\x88\xc3\x7d\x8f\xbc\xa9\xd9\x8e\x6e\xbd\x33\xd4"
          "\x81\xca\x9a\x9d\x31\xba\xb3\x0e\xbe\xcb\xf2\x1f\xc0\xf7\xcc\x08\xff\x8b\xba\x35\xad\x34"
          "\x07\x76\x0f\xf4\x2d\xf6\xd2\xda\xd8\x24\x96\x14\x6a\xc4\x81\x29\x27\x3c\xb6\xcf\xd6\xf6"
          "\x16\x06\x21\x74\xc5\x88\xfe\x47\x5e\xd8\xae\x0b\x3e\x0b\x7f\xca\xd8\xea\x67\x9a\xca\x46"
          "\x83\x90\xc9\xd1\x18\xf2\xf1\x43\x0a\xbf\xa7\x0e\xee\x40\xdf\xd8\x53\xc8\xec\xb1\xd9\xaf"
          "\x81\xbc\x09\xb3\xa1\xed\xe5\x48\xfa\x0c\x64\xe0\xdb\x7d\x09\x64\x9b\xdb\x69\xce\x28\xd2"
          "\xf5\xb5\x05\x56\x0c\xe1\x04\x52\xbf\x00\x62\xf6\x1a\x8c\x3d\x21\x06\xa0\x19\x99\xc3\x1a"
          "\x40\x77\x9a\xd9\x95\x50\x76\x15\x72\xe9\xa0\x0e\x44\x5d\xde\xf4\x16\x3c\x6e\xb0\x84\xa2"
          "\xe0\x5a\x02\x3c\xeb\x02\x40\x24\xbb\xd6\x1e\xef\x9a\x5c\x97\x05\x4c\xea\x80\xe7\x8b\xc2"
          "\xbb\xa0\x8d\xa1\x77\xab\x89\xb3\x5f\xb5\xca\x72\xa9\xc4\x47\xfa\xa0\x6e\x2d\x2f\x3d\x54"
          "\xb3\xf7\x98\x88\xa9\x9a\xad\xd7\x1b\xe0\x44\x38\xe9\x6d\x00\xc9\x42\x97\xc2\xc5\x7b\xb1"
          "\x34\x3b\x77\xb8\x76\xb9\x1c\x99\x3c\x3b\x7e\x41\xb2\x64\x69\x8c\xe5\x77\xe8\x6d\xcc\x05"
          "\x24\x29\xb3\x1d\x2f\x2a\xec\xa6\x25\x04\x55\x44\x4c\xef\x99\x28\x8c\x7a\xdd\x8c\x9e\x6c"
          "\x56\x85\x24\x23\x27\xf8\x61\x44\xb4\x7c\x81\xef\xa2\xa1\xbd\x05",
          1, 2944 },
        { 128, 128, 24, "\x84\x6b\xc9\x0b\x33\x94\x98\xf5\x66\xcf\x7c\x87\x7c\x3d\x3d\xbc",
          "\xd7\xee\xae\x93\x6e\x07\x6c\xc0\x8f\xb7\x8f\x55\x35\x0d\xef\x81",
          "\x32\x85\xd1\xd5\x86\x0f\x6f\x68\x76\x09\x9d\x55\x2b\xf5\x86\x3e\x34\x3c\xea\xee\xaf\x5b"
          "\xdf\xa0\xf5\xe3\xce\x8d\x29\xc3\x0a\xa5\x3e\x41\x6d\xfe\x06\x91\xc5\xe0\x2e\xcb\x43\x5d"
          "\xf4\x62\xd0\x60\xce\x7b\x1a\x05\x8c\x9d\x9e\xee\x71\xdd\x63\xda\x69\x29\x20\x4d\x4b\xbf"
          "\xef\x9d\x68\x89\x16\x42\xd5\x1c\x7b\x50\xa0\x52\x72\xcc\xbb\xb6\x79\x8c\x1f\x45\x04\xd1"
          "\xaa\x7f\x88\xe5\x05\x81\x00\x9b\xdc\x0a\xba\xac\x86\xd1\x39\xdc\x1a\x73\x30\x8b\x72\xb5"
          "\x85\xb9\x33\x3b\x1c\xb6\x91\xa6\x80\xdf\x80\x76\x43\x16\xfc\x74\xf1\x7c\xba\x4e\x07\x0f"
          "\x23\x32\x6e\xd3\x5f\x63\x93\xab\x8f\x30\x44\x28\x16\x36\xfe\x8b\x32\x1b\x3c\x18\xcb\x78"
          "\xa3\x33\xd1\xf4\x96\x10\x2f\xd0\x06\xe8\xae\x1e\xd7\x40\x25\x37\x34\x95\x23\x2f\x96\x08"
          "\xfc\x2a\xe0\xf1\x81\xf4\xb3\x6f\xdd\x5b\x5f\x44\x75\x07\x14\x3a\x7b\xd7\x73\x48\x28\xfd"
          "\x81\x04\x93\xcf\xea\xaf\xc4\xb0\x00\x72\x4f\xe5\xc6\x7a\xd2\xd1\xeb\xa3\x31\xf3\x9e\x0e"
          "\x04\xe0\x3a\xe3\x59\x6e\xb9\xc7\xff\x28\x55\x34\xc5\x25\xd7\x53\x06\x4b\x99\x09\x5b\x15"
          "\xe2\xb8\xa0\xc7\x11\x61\x58\x14\x10\xde\x99\xf4\xca\xb1\x14\x59\x04\xa9\xb3\x10\x0c\x77"
          "\x81\x11\xf8\x2a\x2d\x3d\x95\x53\x38\x98\x4a\x1a\x52\x7d\x95\xa6\xe1\x2b\xff\x2b\x4b\x0e"
          "\xf0\x9a\xf3\x31\xc7\xd5\x01\x0a\x62\x59\x93\xfb\xe3\xcc\x6a\x56\x8d\x0b\x6e\xc2\x7e\x2d"
          "\x37\x18\xd8\xb3\x4c\x7e\x0e\xdf\x60\x05\xcc\xc8\xc8\x19\xd1\x89\xba\xbf\x7e\xe4\x5b\x7b"
          "\x44\x61\x52\xe9\xd7\x8c\x00\x16\x89\x5e\x51\x28\xce\x8a\x10\xb8\x17\x5e\x12\x06\xb1\x54"
          "\x48\xc9\x8d\xb3\xb8\xf3\x3b\xf3\x55\x8a\x3d\x31\xdc\xcb\xa6\x4e\x4a\x25\x62\x32\x11\x86"
          "\x5d\xab\xde\x1a\x29\x3b\xc1\x6d\x38\x68",
          "\x7b\xed\x1e\x2f\xe8\x41\x54\xf5\xc1\xc1\x95\x9f\x01\xf4\x49\x0f\xa9\xf4\x8d\x00\xed\xa4"
          "\x36\x7f\x46\x3c\xdb\x79\x41\x29\x27\xc0\x85\x94\x7d\x7a\x99\x95\xd6\x0b\x01\x15\x2a\x07"
          "\xa6\x67\x04\x5a\x33\x68\x93\xc8\x78\x04\x58\x49\x70\xe1\x6a\xcc\x15\xdd\x9e\x1d\x50\xb4"
          "\x1c\x4e\xdc\xc4\x96\x4c\x88\x3f\x35\xbf\xe2\x85\xa2\xb1\x56\x9c\xae\x05\x80\x9e\x63\x10"
          "\xdd\xb4\xb3\xc0\x09\x54\x58\xad\x32\x7e\x2c\xe6\xe9\xac\x54\xae\x4e\xfb\xfc\xdd\x1e\x9e"
          "\x1d\x00\x4c\x39\xc6\x91\xd5\x7e\x0d\x37\x4b\x0d\xe3\x58\xdc\x4b\x0e\x30\xb4\xa3\x74\xca"
          "\xa1\xec\xee\xaf\xcd\x82\xa1\x5b\x74\x12\x5a\xec\xfe\xc2\xfc\x80\x38\x4d\xcf\xe7\xb4\xa9"
          "\x9b\xba\x5f\x90\x50\xa1\x0a\x21\xca\xe3\x77\xf5\xcb\x54\x5d\x63\x95\x22\x75\x8d\xb8\x29"
          "\xa7\xd5\x6d\x81\x62\x22\xd3\x21\x35\x06\x52\x3a\x3c\x1e\x29\x5c\x05\x3c\xa2\x17\x70\x0b"
          "\x24\xe2\x54\x46\xfd\x1f\x38\x3e\x27\xc7\x27\x89\x7d\xe9\xf2\xbe\x4a\x3b\xdd\x55\x8f\x7f"
          "\x72\xe2\x68\x67\x5f\x86\x30\xe4\xd1\x1c\x72\x26\x29\xe4\x3e\x24\x45\xde\x51\x2b\x9d\x30"
          "\xc1\x63\xe4\xbf\xa8\x73\x46\x62\xde\x36\xf3\x07\x8c\x66\x87\x28\x57\x39\xcf\x27\x4c\xe2"
          "\xfc\xfa\x0a\x80\x29\xcd\x20\x61\xab\x61\x65\xed\x66\x59\x0b\x71\x59\xf6\x6b\x47\xf4\x84"
          "\x7b\x0d\x9a\x7b\x3c\xb7\xcc\xf9\xc6\xf2\x54\x24\xa5\x30\x92\xfb\xee\x6a\x85\x51\x3d\xf6"
          "\x23\x97\x14\x3c\x4a\xab\xb7\xc6\x39\x08\x34\x85\x4f\x1b\x49\x99\x00\x23\xd2\xdb\xa2\x1e"
          "\xcf\xc5\x2e\xbc\x2a\x18\x03\x01\x23\x20\xd8\x07\xd7\xf2\x4f\x30\x29\x57\x8c\x41\x0d\x96"
          "\x1b\x16\x53\xa5\x47\xf5\xe1\x83\x44\x78\x16\xe2\x45\xc6\x5a\xdd\x4d\xb9\x59\x75\x9b\xf7"
          "\x15\xdd\x7f\xc2\xd7\x60\x5d\x79\xfb\xf8",
          1, 3072 },
        { 128, 128, 25, "\x42\x0e\x78\x96\xeb\xf6\x42\x7a\xc7\x10\xde\x98\x5c\xf3\x7e\x64",
          "\x2f\x49\xf2\x72\x70\x63\xf6\x26\xb3\x21\x55\x04\x3f\x76\x5f\xf0",
          "\x65\x5d\x50\x66\xa8\xca\x5f\x39\xcb\xa1\xee\x10\x19\x5e\x7a\x13\x68\x19\x7d\x16\x38\xe4"
          "\x74\xb8\xe1\xa0\x7e\x43\xb3\x77\x9e\xb2\x7f\xf5\x2f\x7b\xa0\xd0\x85\x93\x5a\x0b\x41\x29"
          "\x4e\x00\x5a\xe9\xf4\xa3\x99\x85\x8b\x7c\x53\x4c\xcd\xdf\xad\xff\x4d\x77\x95\xc3\x66\xc6"
          "\xba\xd6\xc4\x88\xcc\xa0\xd5\x45\x55\x71\x20\x3d\xc2\x51\xaa\x1e\x8f\xd3\x31\x88\xef\x04"
          "\xe8\x25\x46\xb1\x39\x32\x2c\xb9\xd0\x19\x25\x8d\x10\x18\x55\x10\x4d\x56\x0e\x1b\xc7\x46"
          "\x40\xee\xec\xa1\x35\x7a\x44\x12\x63\x7e\x8a\xe0\xef\x5f\x19\x27\x85\x84\x82\xed\xc8\x13"
          "\x34\xfe\xd9\x50\x2f\x3b\x01\x3e\x4a\x0b\x25\xcf\x09\x91\x73\x6a\x1e\xd4\x8f\xd7\xcf\x30"
          "\x6b\x66\x9a\xcc\x5e\x79\x23\xe0\x44\x56\x75\xd6\xb9\x86\x59\x2f\x14\xe3\x08\x37\x0b\xfe"
          "\xb0\x67\x9e\x56\x7f\x7a\xe3\x4c\x4c\xe4\xf5\x0b\x43\xee\x4f\x61\x99\xf3\x80\xc1\x29\xce"
          "\xab\xa4\xb2\xd9\x37\x91\xc9\xb4\x16\xdc\x5c\x67\x6a\xe3\x8c\xe1\x14\xa3\xdc\xb5\x46\x22"
          "\x80\xb8\x67\x34\x96\x6f\xbc\xa1\x0c\xfb\xb0\xf2\x53\x48\x27\x3c\x75\x7d\x78\xbb\x75\xff"
          "\xa2\xd7\xc7\x36\xb1\x0c\x25\xe3\x7e\x45\x63\x80\x8f\x68\x3b\x36\xdb\xf4\x97\x02\x40\x07"
          "\x61\x7a\x63\x42\x26\x8f\xc2\x2d\xaf\xf8\x1c\x13\x86\x85\x53\x8b\x9a\x5c\xe0\x0e\xb5\xf0"
          "\xaf\x17\x3e\x3b\xc1\x55\x1c\x8d\x98\x50\xfe\xe9\x74\x9d\x1d\x2e\x5e\x1b\x5c\xe1\x46\xe3"
          "\x2e\x7f\x3e\x08\x24\xcc\x7c\x75\xc0\x9c\x32\x87\x9d\x4d\x84\x48\x25\x43\x77\xc2\xbc\x66"
          "\x09\x66\x1c\x0b\x42\x42\xf7\xa5\x62\xa7\x22\x89\x1a\x91\xfe\x5a\xc4\x0a\x7b\x49\xcd\xb5"
          "\x41\xea\xa1\xd8\x33\x6d\x25\xac\x5c\x1b\x63\xde\x0e\x8e\xa9\xf0\xa5\xee\x88\x84\x34\x3b"
          "\xc9\x39\x95\x74\x2a\x23\x25\x80\x17\x0e\x57\x00\xc1\x6e\xac\x26\x1f\x86\x63\xaa\x37\x76"
          "\x47\x68\x9d\xc9",
          "\xd6\x3c\xce\x37\x8e\xb0\x6c\x06\xb7\x7b\x7e\x9a\x07\xb3\xae\xc9\x9b\x4e\x53\x01\xc6\xf9"
          "\x47\x39\xd7\xc6\xbd\x86\xf1\x29\xab\x5e\x0f\xc0\xee\xd7\xba\x62\x78\x04\xd5\xc7\x12\x47"
          "\xb6\xa8\x77\x1f\x41\xe2\x06\x98\xce\xe3\xdc\x95\xc0\x4c\x14\x42\x67\x86\xd5\xc6\x3e\x39"
          "\x25\x0e\xbc\xf2\x03\xeb\x08\xc3\x55\xf3\x00\x4e\x98\xfe\x85\xb4\x0d\x1f\x93\x8a\x83\x4b"
          "\xad\xbb\x44\xd5\x6e\xdb\x7a\xb0\xe5\x15\xef\xa0\x6f\x6d\xbc\x1d\x45\x8b\xc5\xa2\xd7\x67"
          "\x3b\xe2\xaf\x2d\x04\xd5\xd1\x80\x36\x0d\xd0\xe5\xca\x1f\x22\xd3\x38\x25\x69\x64\x72\x75"
          "\x1c\x73\x01\x98\xa6\xe2\x55\xda\x3b\x43\x24\x1a\xfb\xb4\x31\xab\xa8\xbf\x59\xd5\xb3\x9d"
          "\x7f\xf2\x8d\xd0\x8c\x93\x67\x56\x9a\x9e\xa5\x9c\xf9\x78\x06\x0d\x7d\x28\xc7\x86\x37\x1d"
          "\xa6\x4d\x9a\x9b\xf0\x8a\x63\x87\xac\xc4\xd8\xa7\x49\x09\x57\x5f\xef\xe3\x00\x09\x4e\x75"
          "\xa7\x90\x5a\xfe\xf0\x5e\xf0\xc3\x1e\xc6\x76\x7f\xfc\x5b\x39\x9a\x81\x62\xcc\xa6\xe2\x6c"
          "\x6c\x63\xd6\x3c\x9a\x7a\x4f\x7b\x1e\x86\x98\x66\xa6\xa4\xd1\xf1\xae\x67\x53\x2b\x74\x2e"
          "\x6d\x97\x65\x42\x2d\x34\x03\xfa\xef\x59\x35\x79\x3b\xaf\xc6\xb1\x24\x84\x44\x97\x97\x11"
          "\x84\x67\xd4\xe8\x65\x71\x7d\x19\x49\x0d\xde\x79\x7f\x38\x7f\x76\x05\xf8\xb5\xe8\x1a\x8e"
          "\xfb\xc5\x61\x2c\x90\x82\x8b\x63\x30\x1e\x1c\x22\xbe\x4f\xce\x6b\xb1\x93\xfb\x42\xf1\xca"
          "\x6d\x12\x3a\x91\x62\xce\xf5\x18\x05\xb6\xd6\xa2\xb9\xb5\x0b\x02\x1c\x49\x52\xaa\x5d\x8f"
          "\x34\x82\x4e\xd3\xfd\x45\x6f\x32\xeb\x04\xc3\xa5\x1e\xfc\xd2\xb7\x40\xe5\x33\x93\x64\x5d"
          "\xd4\x7c\xb7\xae\xd9\x0d\x6e\xc2\x11\xed\x07\x22\x65\xb6\x58\xd6\xca\xca\xef\x9e\xba\x35"
          "\x92\xce\xb2\xa2\xbc\xaa\x4e\x18\x18\xe9\x22\x67\x96\x8b\xc0\xbc\xaf\xf7\x56\x2b\xc0\x83"
          "\x3b\x5a\xec\x09",
          1, 3200 },
        { 128, 128, 26, "\x53\x56\xa6\x48\x0b\x17\xc6\x14\x1c\xb8\x44\x31\x53\x4c\x45\x9f",
          "\xdb\x84\x61\x33\x37\x6b\x6c\x66\x94\x94\xb8\x98\xaf\xfa\xbe\x53",
          "\xe6\x6f\x07\x4e\x7e\x3c\x43\x6f\x7e\x11\x10\x7c\x82\xd1\x90\xb5\xec\x15\x3f\xce\xd2\x21"
          "\x53\x56\x75\xf8\x69\xaa\x02\xb7\x11\x97\x90\x15\x73\x48\xa7\xde\x66\x5f\xc2\xea\x36\x0c"
          "\xf5\x00\xd8\x29\x2a\xc4\xdf\x7c\xce\xfa\x4d\xb4\x17\x3b\x17\x8c\x5f\x4c\x48\xb7\xcc\xa3"
          "\xec\x4e\x90\x41\xd6\xdb\xc6\xb5\x12\x44\x0b\x47\x83\x96\xdc\x28\xb5\xe6\x26\xa0\x2c\xed"
          "\xf1\xf4\xb0\x00\x1c\xc1\xec\x50\x91\x8b\x72\x0c\xc4\xca\xe4\xeb\x36\x5e\x03\x50\xc9\xf9"
          "\x50\x33\x82\x27\xb3\xf0\x42\xac\x14\x99\xad\x1b\x7f\xca\x14\xfd\x69\x1e\xd7\xf8\x88\x89"
          "\x6f\xa9\xc2\x04\xd3\xb4\x92\xab\x2b\xa5\xda\x28\x43\x63\x28\x30\x0e\xbb\xa0\xe9\xdf\x57"
          "\x66\x16\xeb\x1a\x0d\x38\x1b\x81\x4a\x9e\x9c\x88\xcb\x20\x37\xfa\xd5\x1d\x2a\x5d\xe6\xe5"
          "\x10\xc8\x9b\xac\x3c\xbe\xd1\xde\x4d\xa1\xfb\x93\x0e\xbb\xdb\xb9\xa0\xd4\x14\x88\x8c\x4a"
          "\xa2\x3d\x43\x02\x2d\x1e\x15\xe9\x45\xfa\x77\x63\x2f\xbf\x3e\x35\x5f\xdb\x86\x0e\xdd\xda"
          "\x44\xb3\x22\x78\x09\xee\x6e\x44\xe1\xd5\x05\xcf\x30\xe9\x8b\x77\x6b\x5c\xb1\x86\x7d\x41"
          "\xa3\x81\x6d\x82\xaf\x6a\x5c\x6f\xaa\x75\x34\x63\xc0\x41\x35\xb7\x00\xcc\x5a\xe7\xcc\xad"
          "\xca\xfe\xa5\xdc\x4d\x33\x96\xa6\x92\xf0\x30\x3a\x1b\x56\x35\x6b\x57\xb4\xc6\xe9\xdd\xb0"
          "\xec\x9d\xd5\x30\x1b\x1a\xb7\x02\xe5\xf3\xb0\x5f\x33\x0a\x93\x8d\x16\x56\xa4\x1e\x3d\xf3"
          "\x69\xb6\xd0\x36\x3a\x66\x91\x55\xfe\xd0\xbc\xe2\x52\x9b\xec\xd5\x4e\xcb\xa0\xaa\x40\xfc"
          "\x9c\x39\x47\xbf\xc5\x95\x58\x2a\xf0\xbb\xd1\x56\x92\xc2\xf1\xd2\xde\x9e\x58\x3f\xa4\xf9"
          "\x20\x7d\x8b\xeb\x0f\x4a\xbe\xd3\x45\x96\x25\x23\xad\xe2\x94\x4d\x2f\x82\x51\xf0\x3c\xc4"
          "\xe8\x10\x65\x2b\x18\xe8\x83\x09\xcf\x53\x2b\x35\x5f\xbc\x03\x26\x76\x9e\x66\x4b\x9f\x1f"
          "\xd7\xfe\x27\xcc\x9b\x2f\xb4\x60\x1d\xe1\x8b\x21\x1e\x8c\x6f\x96\xfc\x81\x5c\x82",
          "\xa9\x33\x68\x54\xb2\x02\x9c\x0a\x63\x15\x46\x47\x48\x0f\xa5\xcf\x24\xe7\xbd\x98\xc9\xe5"
          "\xf5\xe4\xca\x13\xe9\x7e\x54\xc2\xdc\x3b\x06\x5d\x34\x64\xa2\xb4\x66\xb1\xb2\xe7\x0c\xf5"
          "\xf3\xe9\x51\xad\xa7\x23\x8b\x62\xdb\x1c\xf0\xb2\x9b\xca\x0a\x6c\xf5\x32\xc6\xf3\xfe\xa7"
          "\xfc\x8e\x86\x2a\x7f\x9d\x78\x5f\x0b\x7e\x70\x11\xdd\x7d\x11\x3c\x14\x93\x41\xda\xa2\x97"
          "\x59\x65\x9b\x73\x5c\xc0\x5f\xa3\x40\xa6\xd7\x18\xa7\x17\xc4\x0b\xc9\x9a\x26\xbb\xdb\x37"
          "\xc7\x77\xcc\x1e\x84\xa3\xc9\x79\xe4\xa6\x14\x3a\xf9\x04\x78\xcd\x40\x0a\xd6\x9d\x07\xf0"
          "\xc2\xdf\xe2\xb8\x18\x3c\xa8\xfa\xd8\x39\xba\xab\xe8\xbd\x7a\x2d\x76\xcd\xd1\xe0\x44\x8b"
          "\xaa\x47\x53\x4a\x4e\x5e\x72\x91\x28\xba\x84\x6f\xc6\x8b\x8e\xd9\x2a\x7e\x8a\x06\xfe\xae"
          "\x68\x3b\x74\x0b\x68\x34\xaf\x82\xb3\x4c\x06\x7c\x18\xd7\x66\xe4\x0a\xa0\x5a\xbc\x6f\xf8"
          "\xd5\xa7\x6e\xae\xaf\x99\x4a\x3d\xc7\xb3\x7a\xea\x6d\x39\x0c\x0b\xac\x8a\x0e\x01\x29\xdc"
          "\x63\x39\x85\x0e\x13\xf0\xc7\x3f\x62\x3b\xea\x1f\xf1\xab\xc5\xc8\x45\xa3\xa0\x6c\x0f\x8f"
          "\x1a\xda\xe2\x3f\xf4\xf0\x44\xd1\xd6\x37\x67\x58\xf1\x1f\xd2\x98\xee\x8f\x07\x4f\x0b\x6e"
          "\x01\x4f\x4d\x65\x6f\xd2\x7e\x9e\x05\xdc\x7a\x02\x42\xda\x7c\x95\xa3\xde\x3f\x6a\xb4\x20"
          "\x6c\x92\x1b\xf2\x26\xbb\xcd\x2f\x07\x65\x38\xbf\x04\x44\x72\x1c\x7c\x3e\xac\x58\x7b\x1a"
          "\x83\x67\xe7\x52\xc8\x8e\xdf\x54\x37\x34\x3b\x70\x7a\x7e\x17\xd3\x00\x41\x16\x2e\xe1\x39"
          "\xc9\xdf\x29\x55\xb7\x48\xf0\x8e\x8e\x3c\x17\x94\x89\x5d\x67\x1c\x30\xbc\x73\xc8\xd6\xd8"
          "\xe3\xcb\x87\xbe\x19\xac\x63\xe8\x9a\x17\x0f\xcf\x45\x04\x11\x42\xa5\x93\x16\x5d\xdb\x68"
          "\xf3\x55\xa1\xe4\xc4\xda\xce\xdf\x83\x67\x9f\x6c\xbc\x0e\x12\x65\x84\x57\x28\xbe\x69\xf2"
          "\xad\xfd\x85\x44\x45\x9d\xb9\xf7\xdd\xc1\x05\x6b\xc7\x32\xc9\xf3\xc3\x41\x5e\x53",
          1, 3328 },
        { 128, 128, 27, "\x0f\x95\xaf\x47\xd2\xdf\x2a\x89\x31\x4d\xca\x4c\x01\xe9\x3b\x1e",
          "\x94\x24\xd6\xc4\x53\xcf\x49\x8b\x08\x29\xda\xc3\x9b\xdd\x6f\xb2",
          "\xed\xff\x83\x0f\xe3\x32\x73\x0b\xf6\xda\x54\x94\xdb\xfb\x11\xfa\x24\x16\xca\xa5\x24\xa3"
          "\xf3\x43\xad\x87\x0b\x4d\xfc\x93\xb7\x51\x17\xe3\xac\x64\x13\xf6\xad\xa7\x10\xd9\xf5\x29"
          "\xe1\x8a\x72\xf8\x2b\xa0\x5f\xf2\x3f\x3b\xf6\x76\x35\x02\xa2\x03\x61\x41\xfc\x47\xa3\x0f"
          "\xc9\xc1\x00\x95\xe9\xf9\x9a\x90\x1c\xaf\x75\x88\xcf\x93\xd2\x1a\xff\x9c\xda\x36\x51\x3b"
          "\x65\xa3\x7d\x41\xda\xc8\xde\x85\x22\xac\xf1\x4f\x41\x1a\x8b\x1b\x55\x79\x83\xab\xa9\x0f"
          "\x26\xf6\xbb\xc2\x59\xec\x1b\x02\xd4\x94\x49\xf4\xa0\x25\x32\x51\x5e\x00\x73\x42\x2b\xdf"
          "\x2c\x6e\xe2\xcb\xcb\xba\x6b\x66\x60\x67\xf3\x2d\x67\xf0\x2d\xe8\x65\xf7\xbd\x87\xfc\x34"
          "\x26\x6b\x59\x78\x43\x5e\x5a\x99\x3a\xd1\x44\x45\x07\x17\x0b\xc5\xc4\xd8\xcb\xf3\x13\xd3"
          "\x50\x71\x67\xed\xba\xd7\xdb\x51\x02\x61\xca\x75\x3b\xf0\x81\xde\xc2\xc4\x1f\x4d\x32\xb9"
          "\x57\x5b\xa8\x32\x91\xec\xb8\xfd\x50\xdc\x87\x31\x80\xc8\xef\xf6\xaf\xeb\x11\x2b\xda\xb7"
          "\x7b\x4f\xde\xcd\xb7\x37\x00\x41\x31\x6a\x12\x05\xb4\x6b\x1a\xd0\xda\x11\xac\x32\x6f\xcf"
          "\x9f\x77\xa7\x27\x50\x90\x9b\xd8\xe0\x54\x26\xe9\xca\xce\xd4\x85\x2d\x9a\x6a\x32\x96\x39"
          "\x5d\x5a\x02\x0e\x70\x35\xa6\x6a\x0d\x9c\xd6\x83\x34\xba\x2c\x52\x74\xf8\xba\x78\xc4\xb0"
          "\xd5\x7f\x77\x11\xb1\x8e\xc8\x7c\x25\x4a\xf1\x11\xb0\x60\xb6\x2a\x89\x06\xd2\xb5\xf6\x18"
          "\xff\xaf\x3a\xc0\x33\xd3\x48\x98\xff\x51\x85\xd5\x69\x23\x02\xee\x15\x5e\xda\x06\xfa\x25"
          "\x52\xad\x4e\x4e\xd8\x5d\x52\xa5\xea\xef\x64\x11\x1b\x52\xaf\x63\x45\x27\xf6\x06\xe5\x5e"
          "\x8f\x5c\x38\xb7\x2e\x43\x54\xe5\x57\x63\x86\x2e\xa0\x89\x6f\x41\xb1\xe5\xe8\xe4\xd6\x08"
          "\x18\xd8\x9c\xd6\x81\xd3\xee\x4c\x09\x5c\xfd\xc7\xab\x7a\x07\x66\x79\x07\x11\xd5\xe4\xd7"
          "\x00\x38\x55\x0b\x5a\xae\x82\x7e\x8a\x9e\xe8\xaf\xeb\x90\xcb\xa5\xcb\xaf\x50\x07\xbb\xee"
          "\x7c\x5a\x56\x5a\x6d\x91\xb0\xfc\xc9\xea\x27\xdc\x8d\x1b",
          "\x86\xa3\x23\x2c\xd6\x49\xb2\x3e\x95\x4e\xbd\x3e\xee\x5e\x48\x72\xbe\x33\xc3\x09\x9c\xe6"
          "\x9e\x2b\x18\x16\xc3\xa5\xdb\x49\x79\x07\xc7\x2b\x9f\xdd\x09\xdb\xa2\x27\x02\x49\xd1\x2c"
          "\x2f\xa2\x84\xc0\x15\x74\x91\x0c\x6c\x91\x8f\x73\xa9\xa2\x01\xdd\x28\xa9\x8a\x22\xe1\x25"
          "\x62\xdc\x0c\xd1\x16\xeb\x18\x2b\x47\x51\xb3\x3c\xf1\xd7\x25\x3f\x25\x0b\xc7\x5c\x3a\x62"
          "\x61\x94\x6e\xd1\x83\xad\x08\xd3\xa5\xf0\xae\x0c\xc5\x26\x8d\xc0\xf7\x35\x90\xa9\x78\xdb"
          "\x37\xc1\x82\xca\x65\xe0\xd2\x1d\x67\x85\x18\x12\x39\x17\x26\x3d\xda\xaa\xac\x51\x30\x29"
          "\xe6\xaf\x1c\x36\xf2\x1e\x3a\x40\x63\xf9\x45\x3b\xde\xcc\xf0\x7a\x10\x8b\x43\x1a\x9a\x2e"
          "\x4e\xb9\xd5\xe9\x7b\x67\x5e\xda\x4b\x0e\x1f\x02\x89\x08\x4c\x49\x3c\x84\x0a\xad\x24\xb0"
          "\xfd\x60\x37\xdd\x4e\x36\x09\x3a\xc5\xc5\xb8\xbb\xb4\xc3\xf0\x1c\x9d\xe7\x67\xcd\x95\x93"
          "\x97\x43\x01\x7e\x8b\x35\x47\x94\x4c\x34\xd3\xc1\xf1\xc1\x53\xaa\x18\x2d\x3e\x2c\x27\x35"
          "\x2e\xa6\x50\x6c\xd8\x8c\x22\xc9\x96\x19\x9f\x70\x8b\x5c\x73\xf9\x5e\x85\xd8\x91\xfe\xbd"
          "\x52\xef\x2f\x84\xeb\xb8\xeb\x78\x79\xa6\xd4\x3b\x04\x9d\x4c\x13\x41\x22\xd0\xe9\xcf\x55"
          "\x75\x6b\xe1\xe6\x3d\xd4\x38\x64\x0e\x44\x7d\x3f\xd8\xb8\x87\xd2\xd6\x37\x5b\x29\x8e\x2d"
          "\x86\xd3\xd5\xd4\xd6\x3d\x1a\x2d\x9f\x2f\xda\x07\x71\x29\x40\xc9\xd2\x16\x55\x6e\xd0\xbb"
          "\x2a\x48\x5a\x9a\xe3\x08\xa8\x54\xef\xbe\xcc\xe7\x66\x1e\xb5\x31\xb9\x32\x13\x1f\x1d\x1f"
          "\x57\x89\x1f\xd4\x91\x19\xe5\x88\x2b\x8f\x0d\xf4\x87\x3a\xea\x81\x16\x67\x90\x3b\x9e\x08"
          "\xba\x1b\xec\xc4\x0d\x42\xfd\x15\xc7\xbc\x38\xe8\x3c\xb3\xa0\xc9\xa6\xf4\x2a\xc1\x45\xeb"
          "\x7a\xf1\x38\xf5\x6a\xce\x4c\x06\x50\xa9\x98\xa9\x17\xd8\xb9\xf5\xf7\x8c\xac\xd3\xb0\xb7"
          "\x8a\x06\xe7\xb6\x7b\xb1\xfa\x8a\x76\x6a\xf8\x06\x3a\xbf\x33\xe2\xdc\xb5\x27\xbd\x68\xa6"
          "\x67\x9d\x57\x27\x40\x84\xe6\x28\xae\x7a\xcb\x98\xe3\x67",
          1, 3456 },
        { 128, 128, 28, "\xaa\x92\xbe\xcf\x00\xa2\x53\x42\xfe\xcb\x96\x3f\xfc\x41\x7e\x69",
          "\x77\xbe\xfe\x07\xa0\x1a\xf2\x0a\x10\xb2\x49\xea\xa8\x1a\xc7\x74",
          "\x87\xc6\x60\x52\xe8\x0d\xc7\xdc\x42\x8d\xa5\xe0\x46\x96\x6a\xe8\x37\x4f\x9e\xd4\xa7\x09"
          "\xba\xd2\x98\xec\xc6\x31\xd1\xa4\x15\x28\xb2\xec\xd6\x2f\x94\xb6\x41\x43\x63\x74\xb5\xc2"
          "\x58\xde\x90\xf6\x7b\x79\x2f\xc7\xaf\x8a\x19\x5d\x18\xcd\xb3\x49\x49\xf8\x49\x3d\x85\xcf"
          "\xf4\xd5\xe1\xa9\xab\x3b\xc9\xda\xbe\xd5\x99\x1f\xdd\xa1\xaf\x7f\x60\xa6\x03\xe1\xbd\x5a"
          "\x09\x3e\x4a\xf3\x2b\x66\xb2\x6b\x55\xf3\x41\x1d\xe3\x8d\xd3\x2c\xca\xa5\x34\xfb\x80\xd9"
          "\x97\x7e\x7b\xf0\x9d\x00\x2f\xf0\x1b\xb2\x08\x50\x62\x5d\x36\xce\x1a\xae\x4c\x1f\x64\x8b"
          "\x94\xd0\x63\x9c\xf2\xfe\x68\xed\x20\xc7\x89\xcb\xc8\x31\xc5\x89\x88\x73\xc7\x32\xa5\xc5"
          "\x27\xd4\xf4\xd8\xd9\x14\xfc\xff\x37\xdd\x11\x4c\x2e\x66\x63\x4d\x69\xe9\xf6\xc8\x9d\x9b"
          "\x07\xdc\x85\xc8\xf3\x9b\xfc\x03\x92\x5f\x5e\x86\x2d\x82\x0f\x8d\x4b\x41\xe8\x28\xbe\x74"
          "\x0d\xa8\x9e\x29\x7d\xec\xa1\xe9\xde\x8d\xcd\x87\x1f\xcc\x47\xd9\xba\x5b\x82\x7f\xf3\xff"
          "\xfc\x63\x89\x86\xc3\x73\xb2\xce\x26\x31\x82\xcb\x6f\xca\x29\xdc\xf0\xc3\x7a\xa7\x85\xae"
          "\x17\xc6\xbb\xbe\x4a\x13\x5c\xbc\x27\x4d\x24\xa8\x7a\x7f\x5e\x3e\x20\x59\xc9\x14\x4a\xd1"
          "\xcb\x51\x69\x6e\xa0\xce\x48\x0d\x13\xa8\x09\x62\xe9\xe9\x02\xac\xd3\x8a\x63\x43\x81\x8a"
          "\x57\x0d\x76\xdc\x1e\xa4\xb5\x2b\x25\xb9\x8f\xda\xfc\x58\xbf\x9f\x1a\x23\x51\xd7\xcc\xb9"
          "\x0f\xc1\x2b\x11\x3a\xf6\x50\x1a\x27\xcc\xdf\xb9\xa6\xd8\x53\xac\x6c\x7c\x7e\xaf\x21\x3d"
          "\xc5\x76\x80\x13\x51\x84\x2c\x0a\xe4\x0c\x7c\x5b\x76\x5f\x74\x4e\x80\xd3\x49\x74\xc1\x92"
          "\xd7\x97\x0e\xf3\x69\x51\x37\x89\x92\xab\x18\x0f\x9a\x33\xa9\x2c\x83\x01\xd9\xaa\xd5\x93"
          "\x98\x78\x67\x19\xf1\x92\x2b\x62\x17\x15\x97\x93\x71\xe7\x9b\xd1\x81\x9b\xd5\x14\x65\x65"
          "\xa9\xbd\x10\x2f\xf2\x86\x56\xc7\x44\x62\x58\x01\xae\x85\x43\x3f\x7e\x24\x30\x5f\x50\x84"
          "\x8e\x18\xef\x26\x08\x57\xe4\xce\xb6\x20\xc9\x4e\x3c\xf6\x82\x9e\x23\x64\x1b\x70\xf6\x60"
          "\x48\x35\x92\xf1\xf5\xf9\xfc\x2d",
          "\xcf\x2a\x13\x5c\x6e\x04\xc6\x3e\xf4\x40\x1a\xc5\xff\xf1\x8c\xdb\xd4\xfa\xaf\x2f\x49\x78"
          "\x3e\x91\xf8\x00\xbd\xb7\x16\xaf\x5d\xd9\x14\x23\xbc\xed\x32\x4d\x6e\x48\x74\x2f\xde\x01"
          "\xae\xee\xd6\xd2\x87\x02\x76\x1d\xe1\x02\x75\x75\xc2\x9c\xc8\x8f\xfb\x36\x67\x1a\x46\x59"
          "\xf0\x64\x82\xa7\x71\x4a\x5a\xf5\xdb\x27\x17\x3d\xce\xe3\x96\x38\xeb\x13\x8c\x32\x49\x18"
          "\xa7\x88\xb2\x67\x4d\xeb\xda\x22\xa1\x00\xe8\x4d\x91\xb7\xa6\xfa\x60\x6c\x20\x3e\x60\x4b"
          "\xb5\xe0\x36\x6d\xe7\x54\xe0\x41\xfc\xd6\xcf\x4e\x2f\x59\x2a\xb0\x11\x92\xb5\xb2\xea\x20"
          "\x1a\xbd\x4d\x0d\xe0\xdd\x21\xb3\x81\x14\xc0\xea\xcb\x48\xbb\xf3\x37\xc2\x2a\xfe\xeb\xe1"
          "\xdf\x65\xec\x12\x53\xfd\x4c\x8a\xae\xf3\x64\x52\x41\xe8\xf0\x19\xbb\x5e\x05\x76\xf5\x36"
          "\x9c\x52\x87\xd8\xa6\x2b\xa1\xaa\x92\xa8\x22\xb6\xf4\xf3\x7a\xf5\x54\x72\xf5\x38\x37\xf5"
          "\x8f\x8a\xe2\x97\x25\xe2\xbc\x6f\xdb\xfc\x51\x7a\x1c\xbe\x6d\xe1\x69\x3a\xe3\x97\x50\xa8"
          "\x10\xbf\x20\xf9\x83\xc5\x66\x22\x19\x21\x62\x78\x9f\xbd\x0d\xa9\xc9\x19\xd1\x29\x92\xb9"
          "\xd1\x18\x35\x6d\x19\xa4\x8b\xba\x2d\x8c\xd8\x59\xfe\xc0\xe1\x58\x04\x4c\x84\x04\x22\x2d"
          "\xdf\x0b\x6d\x88\x8b\x1d\x35\xb0\x0e\x32\x0a\x71\xa2\x77\x34\xd2\xd5\xa1\xcb\xd1\x98\x69"
          "\x3b\x29\xae\x23\x4a\x26\x45\x07\xf7\x82\xea\x10\xa6\x34\x9a\xea\x8c\xcd\x87\xef\x46\xdd"
          "\xf3\xd3\x99\x72\x43\x34\xbf\xfb\xa7\x7c\xc5\x42\x63\x77\x55\x35\x9d\x13\x6b\x95\xad\xaa"
          "\x07\x1b\x85\x31\x3a\x5a\xd8\x09\xf9\xbc\x6d\x1b\x28\x9c\x01\x49\x40\x02\xd6\x8e\xd8\x72"
          "\x22\x27\xa2\x18\x38\x10\x72\xc9\x24\xaf\x8e\x8a\xfc\x89\x21\xcb\xd8\xeb\x26\xcf\x5e\xae"
          "\x36\xee\xec\x25\x02\x3f\x82\x6a\x3d\x63\x03\x37\x8a\x60\x5a\x3f\xfb\xa2\x5d\x9b\xc6\x81"
          "\x53\x6b\x89\x34\x73\xb9\x34\x2b\x7d\xd9\x6b\xea\x2f\xe7\xb1\xe8\x2f\x38\xf8\xb5\x9f\x22"
          "\xa1\x97\xeb\x71\x42\xa6\xb0\xe0\x2b\x54\x35\x4b\x0a\x6d\x2f\x2f\x6f\xf5\xe5\x1e\x7a\x19"
          "\x4b\xe8\xb3\x75\xde\xf5\xec\x6e",
          1, 3584 },
        { 128, 128, 29, "\x17\x7e\x57\xe9\x13\x61\x2d\x30\xed\x21\xc8\xbb\xc9\xa8\xb0\x18",
          "\x30\x4c\x8e\x65\x98\xe4\x9b\x70\xe7\xb6\xf6\x04\x25\x36\x9d\x92",
          "\x0d\xee\x26\x45\xfc\xd0\x43\x79\x24\x27\xe2\xd7\x47\xb5\x2e\x77\x1a\x13\xf0\x5c\xc2\xca"
          "\xc8\xef\x86\xef\xad\x13\x08\x65\x70\xcb\x76\xec\x91\xc7\x3e\x11\x83\x01\x65\x57\x1b\x2f"
          "\x74\xab\xc5\x13\xbd\xcb\x2f\x1a\x74\x2a\x56\x2f\xeb\x24\x2c\x08\xc9\xa3\x03\xfa\x04\x02"
          "\xf2\xe9\xa8\xcf\x80\x74\x43\xdf\x93\x98\x00\xb4\x7e\xa2\x3c\x95\xba\x0e\x37\xc8\xd6\x04"
          "\xa1\x47\xce\xa3\x8f\xeb\x23\x28\x13\xb5\x93\xdf\x5c\xba\x91\xac\x8c\xfc\x26\xb9\xe2\x7b"
          "\x87\x38\x2e\x3e\xd1\x30\xae\x1e\xe7\x51\x18\xe5\x3f\x05\x64\x9c\xcc\x34\x70\xb7\xd6\x75"
          "\x51\x44\x57\x94\x1d\xa3\x2c\x07\x2a\x8a\x9b\x00\x8b\x92\x0a\x31\x59\x47\x6d\x4c\x21\x3e"
          "\x22\x55\x23\x7c\x1d\x20\x2b\x5e\x9b\xb2\x8d\x59\xea\xdf\x24\x84\xcf\x1c\x75\x29\xde\x07"
          "\x91\x81\x27\x7f\x7e\xa4\xe7\x35\x12\x0d\xd8\xb9\xe2\xef\xaa\x0a\xdb\x0e\x24\xa0\x9c\x24"
          "\xa4\x9b\x8f\x4f\x96\x66\x4a\x8f\x9c\x7c\xec\x18\xad\xa2\x07\x43\x48\x66\xe0\x3e\x5a\x78"
          "\xb1\x01\x63\x37\x87\xb1\xea\x28\xca\xe1\xa8\x22\xd3\x8e\xd6\x63\x14\xa7\xd8\x84\x1c\x29"
          "\xcf\x71\xfd\x74\x75\x90\x3b\xe5\xb1\xd0\x0f\xb6\x59\x7d\x10\xbe\x61\x6c\x53\xbf\x4e\xc2"
          "\x0f\x66\x8e\x8d\x04\x02\xac\x8d\xa1\xa6\x33\x16\x4c\x3c\x65\xe7\x22\x02\x44\x08\x1d\xf6"
          "\x22\x00\x43\xcc\x67\xce\x33\x88\xc4\x3a\x83\x32\xe2\xa8\xc3\xd6\x57\xd9\x96\x65\x3c\xf3"
          "\xf4\x72\x5e\x90\xa0\xa9\xfa\xde\x4a\x4e\x75\xdb\xc9\x33\x93\xfa\x98\x48\x1b\x78\x71\xc6"
          "\x9a\x4a\x87\xf7\xe9\x36\xa9\xdc\x66\x91\xdd\xab\xab\x32\x86\x2d\xf6\x24\xf3\xde\xb5\x34"
          "\xed\x6d\x55\x55\x76\x2d\x09\xf3\x94\xaf\xff\x53\x6c\x65\x4d\x01\xf6\x54\x33\xdd\xf6\x43"
          "\x24\xe4\x0d\xee\x7d\x0e\xaa\xe1\x99\x84\x16\xf4\xed\x94\x5b\xad\x8b\x4b\x35\x67\x6a\xe3"
          "\x20\x56\xaf\x35\xa0\x30\x2f\x77\x72\x59\x6b\xa8\x7a\x5d\x64\x47\x95\x07\x96\xdf\x7c\x80"
          "\xda\x51\x5a\xd7\x80\x7c\x7b\x1e\x4f\x98\x94\x06\xd3\x1a\x27\xa3\x93\xbd\x22\x00\xe3\xcd"
          "\x40\x4b\xfe\xf8\xad\x37\xc3\xa7\x60\x2d\x24\x82\x2e\xd5\xae\xb7\x94\xbd\xb6\xee\x9d\xcd"
          "\xdb\x7d",
          "\x8b\x59\xe7\x25\xb5\xcd\xfb\x74\xaa\x3f\x48\x7c\xa7\xde\x51\xdc\xbd\x4d\xa4\x53\x3e\xca"
          "\x05\xbf\xa6\x66\x41\xc4\x44\x8d\x35\x04\x56\x34\x7e\x51\x27\x7f\x29\xc1\xf8\x78\xb6\x37"
          "\x4e\xfe\x43\x36\x12\x06\xd7\x77\x66\x4d\xde\x2e\xd4\x2d\x59\x87\xd1\xb0\xac\xab\x2a\xfe"
          "\xfa\x9c\x30\xdd\x5f\x68\x5d\x46\x96\xbc\x8e\x3e\x2d\x4c\xe8\x93\x03\x4d\x7a\x2a\x8b\x63"
          "\xcf\x3d\x0a\x6d\x80\x47\x56\xd5\x66\xca\x68\x64\xfa\x51\x69\xe8\x4a\x76\x08\x11\x94\x5a"
          "\x01\x9f\xad\xd8\xf7\x53\x1b\x51\x5d\x03\xa8\xf5\xea\x9f\x31\x2c\xab\x7b\x8e\x3f\x68\x3e"
          "\x8b\x53\xea\x8b\x68\xd2\x75\x15\x0b\xa9\xc0\xa1\x85\x87\x40\x48\xde\x1d\xba\xae\x92\xb3"
          "\xee\x94\x9f\x2d\xaf\x06\xae\xc4\x10\x70\xf3\xa1\x52\xa2\xc2\x19\xe6\xce\x88\x3b\x3a\x5e"
          "\x59\x2c\x2b\x7e\x19\xf5\x95\xf3\x21\xaf\x61\x49\xa9\x0a\x58\x37\x3b\x9d\x4b\x7a\x32\x1f"
          "\x2e\x41\x1b\xc9\xad\x0e\xdf\x05\x6e\xc5\x3d\xe1\x98\x26\xae\x5f\x37\x25\xac\xc0\x7b\xbf"
          "\xd0\xa6\x56\x3d\x95\xcf\xf0\xa5\x03\x14\x51\x84\xf0\xa2\xa4\x30\x91\xd2\xfd\x11\xb1\x6c"
          "\x55\x3f\x76\x5a\x3b\xda\x88\x3d\x61\xe7\x4e\x5a\x55\xd8\x66\x26\xd4\x82\xf1\x01\x63\x87"
          "\x14\x8b\x3d\xbf\xdc\xaa\x4b\xca\x2a\x8e\xd1\x7b\x9b\x96\xda\x85\xeb\xb3\xe0\x3e\xb3\x9e"
          "\xc5\x09\x80\x84\xd2\x29\xd4\xad\xb4\xb2\x53\x1d\x71\x9b\x6b\xa3\x75\x7a\x6b\x5f\x9d\x54"
          "\x8e\xa4\x28\x2b\x9f\xb7\xdd\x80\xbb\x78\xa2\xc9\xe2\xaa\xbb\x19\x40\xce\xb4\x3b\x92\xb5"
          "\x4b\x28\x8c\x59\x54\xc7\xd5\x9c\x88\x20\x30\x33\x07\xaa\xdd\x2a\xca\xbe\x03\x89\xce\xdc"
          "\xcc\x4b\xa3\x5a\x7d\x41\xc2\x45\x07\x8c\xb8\x7a\xbc\x31\x9c\x47\xdd\x8f\xc4\xd3\x43\x15"
          "\x33\x6a\x30\x7a\x8a\x17\xdf\xcb\x5f\x16\xb3\x5b\x21\xf7\x3c\x96\x6c\xaf\xd4\xf1\xcf\x47"
          "\xad\x00\xac\xa3\x8b\x66\x83\x6a\xd9\xe1\xe8\x5b\xbc\x03\x08\x27\xdb\x58\x18\x94\x8b\x94"
          "\x62\x95\x44\x05\x31\xc8\xac\x12\xec\x8e\x16\x78\x6b\x32\xef\x72\x13\x8c\x34\xa1\xb4\x9b"
          "\xbe\xc8\x19\x73\xaf\x39\xfc\x9b\x31\x7f\x9a\x35\x26\x8a\x1e\x54\x03\x34\x00\xe0\xa5\x55"
          "\x7b\x30",
          1, 3712 },
        { 128, 128, 30, "\xdd\x1f\xa1\x9d\x62\x56\xf7\x16\xf3\x18\x89\x55\xce\x5b\xc6\x70",
          "\xc8\x0b\x82\xd5\x32\xce\x2a\x88\x3d\x4d\x08\x66\xd6\xc3\x26\x9c",
          "\x28\x62\xa1\x02\xbd\x54\xe0\x2b\x88\x00\x38\x35\xe3\x3d\x1d\x38\x5c\x61\xf1\xd9\x7b\x09"
          "\x9d\x53\xef\x02\x88\xb4\x85\x35\x4f\x21\xe4\x1c\x5f\xba\x05\x48\x92\x1a\xb6\x9e\x95\x1d"
          "\x08\x60\x55\x8a\x53\x34\xc3\x88\x9b\xb4\xe3\x63\xbf\xdd\xd6\x44\x73\x4f\x8b\xc7\xfb\x5e"
          "\x1b\x75\x0e\xba\x3a\xd8\x61\xaa\x59\x96\x16\x02\x34\x5b\xea\x78\xda\x9c\xe4\x50\x45\x98"
          "\x1e\x4e\xdb\x79\xeb\x52\x39\x89\x94\xcf\xfa\x4e\xfc\x2d\x75\xff\x27\xb8\x24\x53\xd2\x25"
          "\xb0\xd0\xff\x60\x5a\x8d\xd4\x0d\xb1\x30\xf6\x82\xa4\xf4\xb6\x60\xc1\x9c\x24\xa4\x4f\x65"
          "\xc8\x35\x48\x84\xb7\x5a\xe1\x5e\x2d\xa9\xc6\x02\x13\x41\x49\xe3\x94\x83\x76\xa4\xd5\x91"
          "\x57\xfb\xe1\xb9\x5b\xca\xb5\xbf\x88\xa1\xd0\x67\x32\x2a\xca\xd1\xc2\xc6\xd3\xf8\xc0\xd3"
          "\x69\x9b\x65\xc7\xa5\x35\xf5\xcb\xd8\xf3\x3a\x0b\xae\x9b\xd1\x5f\x6e\xee\xda\xfc\x78\xa7"
          "\x6c\xac\x01\xbd\x58\xd9\x6e\x05\x04\xc9\x8e\x47\x39\x38\x92\x63\x8e\x00\xed\xb5\x21\x61"
          "\xc1\xf0\xee\x5f\xfd\x27\xd4\x4d\x3a\xc5\xcc\x70\x21\x08\x00\x6a\x78\x10\x64\xa9\x10\x5a"
          "\x77\x4c\xf2\x2f\xe0\x60\xa3\xf4\xbd\x43\xde\xf0\xf4\x9e\xa7\x1d\x5d\x96\x36\xda\x35\x05"
          "\x84\x3a\x37\x09\xf0\x7b\x16\x01\xf1\x71\xfd\x9c\x89\x79\x7e\x17\xc5\xfc\xeb\x08\xe1\xaa"
          "\x18\x44\xc9\x9e\xf5\x74\x5f\x1f\x7b\xa1\x36\x86\x34\x13\xd3\x4b\x1c\x7a\x69\xb4\x5b\x1a"
          "\x9d\xda\x1e\x6f\x79\xcd\xab\x77\x1c\x32\x2e\x30\x1b\x3a\xa4\xf8\xb6\x7f\xaa\x8c\x7e\xdf"
          "\xda\xf8\xc9\xaf\x2a\x96\x91\xb1\xff\x62\x9c\x4c\x77\x4d\x8b\xdc\x2c\xf7\x3f\xfd\xea\x36"
          "\x3d\x18\xaa\xb2\xa1\x38\x34\x28\x60\xdb\x52\x50\x79\xaa\x34\x23\x44\x15\x31\x58\xb1\x4e"
          "\x5c\x25\x76\x98\xd6\x52\x1c\x14\xed\x13\xdb\x0d\x6b\x10\x3d\x07\xdc\x5f\xbc\xf8\x7c\x20"
          "\xc8\x0f\x1b\x3b\x06\x58\x88\x91\x3e\x61\xa0\x24\x0c\x18\x60\x9e\x44\x37\x4d\x61\x55\xdc"
          "\x0f\x18\xbc\x1c\xd3\xa4\x68\x41\x6b\x69\x9c\x79\xf2\xd3\xbb\xbf\x83\x52\xb2\xd4\xec\xec"
          "\xa3\x31\xd5\xb1\x21\xaa\x2b\x61\xaa\x96\xa5\xa9\x87\x86\x8e\xcb\x46\xc0\x96\xff\x3e\x50"
          "\x62\x74\x90\xb4\x21\xb4\xcd\x06\x6e\xac\x65\x58\x77\xcc\x90\x54\x32\xb8",
          "\x63\x44\xd7\x3b\xd5\xe7\x51\xc0\x58\x40\x0e\x86\x9a\x96\x78\xfe\xe6\xc3\x2f\xb0\xf4\x70"
          "\x2f\x83\x06\xd3\x76\x8f\xe2\xa5\x0c\xbb\xeb\x43\x29\xb8\x13\xac\x09\xc8\x94\x3c\x6c\x48"
          "\x14\x36\xb0\x4a\x9d\xce\x20\x90\x6e\x47\x00\x2d\x3b\xae\x36\x46\x4a\x90\xd0\x65\xaf\x33"
          "\x98\xbb\xde\xda\x94\x87\x43\x2d\x67\xfd\x89\xee\x5c\xf1\x51\x1e\x8c\x6f\x0b\x60\xe9\x30"
          "\x2d\x2c\x16\x5c\xc0\x8e\x1b\xc7\xfa\xeb\x1e\xba\xf6\x6d\xed\x35\x51\xb3\x8a\x33\x1b\xff"
          "\x82\xce\x7c\xe6\x89\x5b\x2a\x14\x3d\x07\xeb\x60\x65\x7b\x73\x80\xba\x26\xbb\xde\xf2\x6c"
          "\x29\xb5\x96\xae\x7b\x42\x73\xd9\x63\x55\xc2\x06\x30\x83\xf8\xf4\x62\x78\xcf\x29\x6a\x3a"
          "\xdf\xb3\x2d\x38\xe9\xf8\xdc\x8c\xbd\xd9\xca\xe3\xda\x6c\xb0\x4b\x54\xba\x70\xa0\x65\xf8"
          "\xf4\x11\x87\xeb\x4d\x38\xda\x08\x6f\x7b\xd7\xce\x9c\xcd\xf3\x12\x7e\xa3\x9b\xb4\x79\x52"
          "\x17\x01\x4c\x57\x1c\x19\x02\x32\x1b\x1b\xde\x33\xd4\x2e\x0c\xc1\xa3\xa5\x0f\xea\xc2\x03"
          "\x96\x60\xa4\xd6\x95\x74\x0a\x60\x06\x4d\x2e\x98\x5e\x87\x26\x4c\x22\x06\x5d\xd5\x63\xef"
          "\x02\xbc\x81\x74\xe5\xd6\x62\x73\x19\x65\x6b\x93\x0b\x5a\x0e\x57\xa7\x91\x3c\x20\x08\xda"
          "\x13\xd8\x2b\x22\xe3\x09\xcb\x02\xc3\xce\x15\xdd\x83\xf7\xaf\x1c\xc2\xb7\x85\x7e\x25\xd3"
          "\x78\x87\x70\x9f\xfd\xf9\x26\xd4\x38\xf0\xc2\x21\xc2\x1d\x7a\x69\x29\xc4\x71\x23\xcf\x11"
          "\xd1\xa4\x5f\xdf\x73\xc4\x18\x10\xc9\x50\x86\x23\x04\xf4\xdf\x4a\x2a\x57\x4d\xcc\x64\x4c"
          "\x2c\x04\x82\x47\x4e\x17\x50\x49\xb4\x1e\x1d\x1e\xc9\x7a\xf1\x81\x2f\x9c\x71\xe8\xf9\x20"
          "\x3b\xc4\xa4\x33\x95\xd5\xa4\x1b\xa9\xc1\x2f\xd2\x91\xa7\x8e\xf1\x03\xfe\xe2\x68\x41\xe5"
          "\x52\xef\xba\xcc\x65\x76\x3a\x8a\x4e\xe6\x98\x6f\xa7\x11\xdf\x2d\x32\x91\x76\xe7\x5d\x40"
          "\x33\x50\xe6\x8f\x8f\x32\x98\x52\x8b\xd5\xda\xa4\x99\xf2\x47\x40\xe9\xb0\xb4\xc1\xb8\x70"
          "\x08\x77\xd6\xc3\xd4\x34\x84\x10\xf5\x07\xc3\x28\x1c\xe7\x63\x78\x27\xb1\x1f\xb3\xed\xd2"
          "\x61\xd3\x19\x8c\x72\xf6\x85\xa6\xa8\xf3\xbc\x17\x6f\xcf\xbb\xeb\xfb\x7f\x6e\xa9\x7f\xb6"
          "\xf2\xcf\x92\x2e\xb6\x66\x84\xf9\xec\xdf\x62\x12\x5f\xb3\xc6\xab\x1a\xbd",
          1, 3840 },
        { 128, 128, 31, "\xc2\x82\xb6\x06\x31\x85\xa6\x16\x80\x72\x46\x1a\x35\xa6\x3d\x61",
          "\xf1\x16\x0f\x53\x26\xa1\x25\x1b\x6b\x2f\xf0\x85\x21\x55\xd3\x35",
          "\xc7\x44\x23\x87\x35\x67\xc2\x2f\x09\xed\xc2\x43\x94\x29\x79\x7e\xaf\x90\xc6\xc1\x8a\xc4"
          "\xa4\x19\x66\xbb\x2c\x8f\x2b\x98\x47\xa5\x73\x00\x9f\x11\x44\x38\xe5\x8e\x17\xb3\xc6\xca"
          "\x6f\x14\xf3\x1d\x5d\xcc\xb4\x0c\xde\x8a\xf9\x65\x57\x3b\xe9\x7b\x72\x4b\x28\x5b\x99\xf0"
          "\xb4\x14\xa7\x04\x0b\xf2\x8a\x58\x3b\x17\x99\x92\x0f\x1c\x57\x0a\xd5\x92\x47\xa0\xa6\xc6"
          "\x6e\x68\xad\x92\x34\x94\x75\x1c\x73\xa9\x8a\x21\xa1\x7c\xca\x9c\xfa\xfe\x8d\x6f\x8e\x0d"
          "\xb2\x65\x5d\xd5\xc8\xb3\x37\x6a\xa9\xde\x4e\xfe\xaf\x20\x45\x92\xa0\x34\x53\x62\x6e\x8a"
          "\x92\x7a\x70\x9d\xe7\xe3\x30\x9f\xca\xe3\xf4\x0e\xf9\x52\xb2\xf8\x75\x13\x85\x6a\xad\x6b"
          "\x70\xcf\xc6\xc8\xc9\xab\x5f\x3d\x8f\xa4\xa2\x48\x5b\xe8\xd2\x4f\x1e\x67\xbd\x46\x10\xdf"
          "\xa4\x19\x38\xf4\xe6\x86\x2a\xd7\x07\xfe\x63\x8d\xfe\x52\x42\x3a\xd5\x7f\x84\x8d\xef\x62"
          "\x68\xc2\xee\x80\x2c\x4c\xd3\x76\xfd\xde\x06\x68\xb3\xbf\x09\x3a\x79\xf3\x56\xcb\xe9\x50"
          "\xc6\x0a\x65\x96\xf4\xec\xc9\x48\xec\x1b\x66\x1c\x25\x9b\xd5\x61\x51\x28\x96\xfb\x28\x73"
          "\xf2\x1f\xb8\xd8\xef\x50\x07\xd2\x25\x28\xc2\x6a\x3a\xd7\xc7\x4a\x8b\xfd\xfb\xbe\xdf\x74"
          "\xb6\x1a\x1a\x1c\x45\x48\x12\xbf\xd1\xdb\x41\x25\x18\xda\xf9\x01\x17\x20\x36\x0c\x74\x11"
          "\x08\x99\x37\x97\x8c\x00\x1a\x73\x75\xca\x62\x64\x80\xfd\xac\xb3\x06\xbe\x8a\xbb\x20\x81"
          "\xa9\x2a\xe9\xac\x9c\xfa\x97\x67\x60\x10\x83\xbd\x19\xcc\x62\x7f\xbd\x8f\x42\x18\xc5\xdd"
          "\x31\x27\x20\x6e\xf4\x5b\x89\xd2\x9d\x19\x17\x3b\x2f\x90\x03\xc3\xa2\xcf\x01\x3c\x69\x9b"
          "\xa6\xd8\x81\x52\x3f\x71\x38\x59\x3b\xab\x8f\xa0\xef\x74\xe4\x45\x82\xaa\x9b\xc6\x88\x20"
          "\xe9\xc2\x13\xbd\x95\x80\xb5\xd6\x85\x13\x75\x95\x62\x2c\x4f\xe1\xb7\x2e\x3d\xe6\x72\x71"
          "\x5e\x2f\x83\x85\xae\xb5\x8a\x38\xb7\x9f\x77\x01\x38\xf2\x80\x4b\x1d\xb1\x86\x02\x82\xc4"
          "\x04\x9a\xfa\x44\x58\xe6\x9c\x88\xd2\x79\xec\x12\x0e\x87\x0f\x31\x84\x4c\x3c\x5a\x0b\xed"
          "\x8d\xd7\x1a\xbc\x8b\x7f\x22\x57\xc2\x72\x78\xf6\x41\x2b\x46\x74\xde\x00\x37\xea\x2c\xc9"
          "\x53\x95\x0e\xbd\x2b\x93\xd9\x57\xc3\x70\xa6\x80\xaa\xeb\x48\xd0\x26\x8e\x6a\xdc\xcf\x80"
          "\x08\xb5\xb7\x35\x72\x70\xa1\xa4\x4d\x45\xf3\x24",
          "\xa9\xbc\x39\xb1\x42\x8d\xc4\x82\x8e\x1d\x0d\xd3\xc1\xaa\xcb\xbd\x70\xaf\xf1\x70\x05\x21"
          "\x0d\xcc\xa3\x26\xc0\xc3\x26\x5d\xad\x4e\xa8\xe3\xfd\xf0\x20\x86\xf8\xd7\x05\xf8\xa3\xe6"
          "\xcf\xa8\xf4\x13\x29\x43\x02\x2c\x65\x91\xb6\x6b\x2f\xd5\x67\x6f\x3b\xb8\x22\x19\x2d\x9a"
          "\xe7\xe4\xaf\x97\x50\x20\x6c\x8f\xc3\xb4\xe8\xb5\xa4\x9d\x5d\x74\x6e\x65\x54\xaa\xd9\x49"
          "\xc8\x8b\x8f\x8f\xa7\xea\x2d\x03\x40\x96\x50\xe6\x9b\x89\x76\xc4\x0f\xcf\x81\x38\xa7\x79"
          "\xcd\x4d\xbe\x5a\x95\x11\xdd\x31\xad\x4e\x51\x36\xe9\x55\xd0\x02\xf0\x50\x25\xff\x45\x68"
          "\xd1\xb4\x77\x56\x92\xa4\xa3\x0e\x97\x64\xef\x30\xe9\x4b\x19\xe8\x59\x36\x22\x27\xdb\x87"
          "\x47\x14\xa3\x50\x91\xf1\x2e\x56\x7b\x91\x73\xc3\x42\x0f\x66\x84\x5f\x98\x48\xbb\xae\x89"
          "\xc0\x05\x92\x12\x43\xca\xc6\x94\xe0\xc5\xf4\xb9\x26\xfd\x5b\xd6\x2b\x33\x60\xa1\xba\x8c"
          "\x0b\x4a\x45\xd4\x87\xf7\xd1\xcd\x32\x38\x59\x6a\x76\x26\x6f\xba\x3c\x3d\xa9\x29\x13\x6d"
          "\xe6\xc8\x44\xed\x9f\xe4\x76\x16\xf4\xb4\xbe\xff\x2c\x46\x55\xf0\x86\x87\x91\x2a\xf4\x2f"
          "\x48\xe9\xba\xc8\x71\x13\x68\x5e\x89\x10\x40\xec\x93\x38\xcf\xb2\xe2\x51\x15\x3a\x08\xaf"
          "\xde\x55\x3c\x7a\xf4\xed\x2b\x7b\xc8\x0c\x28\xe2\xf7\xa7\x96\x89\xd7\x28\x8c\x76\xef\xbe"
          "\x6c\x2b\x21\xb3\x15\x1f\x80\x77\xba\x94\x30\xca\xca\x8c\xec\xce\x79\x93\x98\x93\x19\x24"
          "\xf3\x57\x6c\xfc\x86\x32\x8f\x9b\x68\xc6\x2a\xb0\x6a\xa6\x02\x9a\xfe\x2b\xdc\x2c\xa4\x82"
          "\xba\x35\xf5\xcd\xa8\x2c\xb4\xf0\xad\x7d\x59\x5c\xd2\x5c\x2a\x08\xf4\x02\x12\x80\xb9\xfc"
          "\xe5\x35\xfc\x33\x6b\x8e\x22\xcd\xca\x76\x04\x9e\x4c\x4e\x52\x30\xfc\x43\xd8\x7b\xdf\xdc"
          "\x28\xf7\xb0\xa8\x9f\x54\x85\x01\x96\xbe\x74\x06\x7f\xe5\x50\xec\x13\x39\x2a\xe4\x28\xc0"
          "\x4c\xf4\x53\x18\x80\x08\xeb\x45\x3c\x82\xa0\xf8\xf2\x7c\x8e\x31\x04\xc4\x30\xca\x6a\x54"
          "\xbf\xeb\x2e\xd6\xb4\x31\x64\x9a\xc7\x62\xf7\xed\xba\xf7\xff\x8f\xe2\xef\xa7\xf5\x4b\x8b"
          "\xd3\xa4\x2d\x6c\x22\x17\x80\x29\x49\x2c\xff\x6b\x39\x80\x04\xf6\xd6\xbc\x6c\x86\xb3\x1c"
          "\x31\x3c\x22\xe5\xe3\xa7\xdb\x17\x1a\x90\x23\xdd\x37\xd3\x3b\x6b\x6d\xe9\xb3\xc6\xf5\x92"
          "\x7e\x43\xdc\xdc\x23\x55\x25\xcb\x04\x81\x40\x2c",
          1, 3968 },
        { 128, 192, 32,
          "\x71\xb8\x95\x3a\x00\xba\x68\x83\x03\xdb\x74\xf5\xef\xea\x6d\x95\xea\x0e\x75\x1a\xa9\x2b"
          "\x1d\xe6",
          "\x37\xdc\xbd\x37\x25\x2c\xe8\x28\x19\xc9\xb0\x51\x1b\x6e\x18\x86",
          "\x12\x58\x67\x1d\x6f\x88\x4a\xcc\x78\x54\x93\x95\x48\x06\xca\xd6",
          "\xde\x3d\x1f\x00\x14\x59\xbb\xb3\x97\x68\x33\xe8\x56\x94\xc8\x8c", 1, 128 },
        { 128, 192, 33,
          "\x5a\x63\xad\x1b\x55\xe4\x5d\xc9\x0e\x6a\x4b\xda\xa4\xb2\x16\x2d\xd2\xb3\x5b\x68\x1a\xb9"
          "\x27\x4f",
          "\xdb\xf5\xc0\xd7\xd8\x4d\x78\xc4\xa4\x5b\x25\x76\x7c\x96\x7d\x56",
          "\xf4\xe3\x02\x38\x01\x5e\xa2\x2b\xe6\xe0\x1d\x9f\x01\x09\xf3\xc5\x78\xac\xd5\x06\x08\x46"
          "\xb2\x95\x2c\x7a\xf6\xde\xe1\x85\x15\xb7",
          "\x16\x4f\x99\x76\xda\x02\x0f\xee\x7a\xce\xb6\x54\x08\xb7\x3f\x3b\x22\x64\x88\x63\xcb\x3c"
          "\x1a\x55\xc7\x31\x50\x76\x82\xff\xcf\x62",
          1, 256 },
        { 128, 192, 34,
          "\xb2\x96\xb7\xcd\x8c\x3d\x0a\x41\x66\x67\x13\xce\x36\x0c\xfd\x99\x0e\x6e\x9b\xfb\x65\x67"
          "\x62\xce",
          "\xb4\xc0\xb8\x1f\xcc\x97\x14\xc8\x57\xf6\x38\x4e\x67\x37\xb7\xbc",
          "\x2b\x91\x1a\x3a\xbe\xc3\x96\xaa\x98\xe5\xb7\x01\x6a\x79\xc1\xc3\xe4\x30\x50\x55\xaf\x93"
          "\xf9\x4f\x63\x84\x14\x8e\xc4\x89\x73\xcf\x94\x16\x9c\x42\xe2\x08\xce\x31\xb7\xf3\xb8\x78"
          "\x45\x5a\x65\x25",
          "\x19\xd5\x09\x38\x5e\xd8\x5c\x56\x0a\x63\x97\xde\xb4\x62\x41\xd9\xb5\xb7\xf0\xf7\x16\xa2"
          "\x83\xc9\x9b\x0e\xbb\x73\x1a\xe5\x1e\x3d\x27\xc1\x74\x13\x68\x65\x8d\x9b\xd2\xae\xce\x9a"
          "\x40\xd5\x78\x7a",
          1, 384 },
        { 128, 192, 35,
          "\x54\xec\xfa\x33\x42\x5e\x0d\x91\xe9\x9b\x11\x15\x97\x1b\x5c\x0f\x05\x7c\x29\x82\x55\x45"
          "\x9b\x08",
          "\xc8\x30\xd0\x2a\xa2\x6c\x34\x61\x1d\x66\x41\xb0\xb7\xe9\xd9\x84",
          "\xc1\x4e\x56\xef\x62\x68\x92\x32\xc8\x2a\xfa\x86\x4a\xeb\xc2\x49\xc8\xba\xcd\x50\x45\x65"
          "\x31\x85\x85\xc0\x2d\x3c\xae\x05\x4b\x4b\x36\xd1\x62\xb3\xc6\x3b\x39\xc3\x1c\x29\x24\xe2"
          "\x94\xd1\xd1\xe3\x48\x8c\x0c\xd2\xc8\x1f\x8c\x24\xf1\xad\xe0\xa9\x42\x8c\xa1\x29",
          "\x5f\x41\xf8\x33\x06\x8c\x8a\x0c\x58\x9f\x97\xc1\x59\xf7\x38\x78\x9c\x1e\xe1\x78\xa2\xfc"
          "\x96\x5e\x5e\x1e\xc6\xec\x09\x5e\xd6\xd7\xe0\x3b\xd3\xb6\xc1\x67\x32\xd5\x35\xac\x3a\x1d"
          "\x5c\xe6\xb6\xc9\xd8\x3e\x9f\x88\xba\xae\x5a\x4d\xad\xd1\xe7\xd8\x33\x7d\xce\x9b",
          1, 512 },
        { 128, 192, 36,
          "\xc7\x90\xa2\x2f\x82\x42\xb9\xec\x5f\x37\xb6\x10\x11\x44\x48\xea\xe3\x42\xcd\xd8\x45\x81"
          "\x0f\x64",
          "\x5e\xaf\xb2\x3a\x9b\x60\x63\x00\x22\x9c\x0f\xe4\xcd\x66\xa7\xaa",
          "\xbc\xfb\x1a\x49\x0e\x58\xb8\xac\x3b\xa6\x2b\x2d\x09\x0b\x98\x1b\x33\x80\x3b\x5e\xa2\x74"
          "\x28\x4b\xd1\x8b\x93\xb7\xba\x5f\x14\x67\xa4\x1b\x4f\x12\x3e\x7b\x6d\x00\xd8\x3f\x52\x9e"
          "\x64\xde\xe3\xb9\x56\xcf\x6c\xc7\x1b\x37\xa8\x25\xb7\x6e\xda\x4b\x54\x26\x0c\x4f\x9f\x8a"
          "\x5c\x46\x92\x82\x69\xa6\xee\x3d\xc4\x34\x61\x4b\x33\x43",
          "\xfd\x08\x14\x97\xef\xb8\x40\xac\x9d\x0f\x86\xac\xfe\x69\x7d\x9c\xcc\x4d\xd1\x9e\x71\xde"
          "\x5f\x31\x3d\x2c\xd0\x3b\x86\x38\xdf\x5f\x53\x72\x4d\x39\xf8\xdd\x13\x81\x9c\x77\x64\x39"
          "\x98\x65\x47\x81\x58\x2c\x02\x36\xf8\x77\x91\xae\x95\x9a\x16\xf7\x51\x68\xe8\x7c\x96\xa9"
          "\xba\x4d\xa1\xc1\xe2\xc9\xbb\xe6\xf1\xa1\x81\x4d\x66\xef",
          1, 640 },
        { 128, 192, 37,
          "\xde\x93\x03\xcd\x52\xa1\x01\xd8\xc3\x7e\x1b\x63\x19\xf9\x32\x4d\x1b\x74\xa5\x3b\xea\x44"
          "\xda\x74",
          "\xc8\xc7\xf2\xcd\xf3\x20\x33\xa5\xfb\xa5\x3e\xa1\x34\x93\xff\x26",
          "\xe9\xa2\xba\x41\x3c\x59\x8d\x39\xab\x7f\x1b\x62\xb3\xdf\x7d\xe9\x01\x51\xa2\x54\x63\x8e"
          "\x08\x66\x26\x11\xb4\x77\xed\xde\xe1\x47\xb9\xd9\x4c\xba\xaf\xbb\x4c\x81\x55\xd2\xb3\x00"
          "\x4b\x32\x3c\xa4\x5d\x54\xe6\xdd\x7f\x76\x4a\xe2\x4c\xb7\x13\x4a\x46\xbe\x98\x9c\x33\xee"
          "\xa4\xa1\x8e\x6b\x84\x80\x84\xcb\xa0\xf7\x9f\x5c\xfd\x2d\x82\xe4\xc4\x51\xc4\x4b\x02\x86"
          "\x1b\xed\xf7\xca\xa9\x68\x6d\xe2",
          "\xe7\xe4\x36\x05\xa5\xcb\x66\x97\xef\x81\x92\x56\xf8\xdd\x1e\x8b\x21\x49\x9f\x18\x5b\xf6"
          "\x2d\x3d\xe5\xe6\xca\x0e\xae\x63\x44\xc4\xb0\x9b\xf7\xcb\x3d\xf9\x01\xf6\xcc\x94\x3b\x2d"
          "\xd5\x0e\xd0\x2e\xc3\x27\xb8\xec\x8b\x14\x0d\xfc\xa2\xbe\xdd\x22\x9f\x2b\xc5\x02\xa3\x7a"
          "\xb1\xcd\x61\x53\x3a\xde\xae\x86\xa0\xe3\xea\xbc\xe7\xf1\xd3\x55\x7a\x8a\x57\xd3\x5b\xee"
          "\x89\x4e\x35\x1b\xed\x6f\x51\x60",
          1, 768 },
        { 128, 192, 38,
          "\xed\xaf\xd4\x87\x06\x5f\x4f\x9a\x0a\xaa\xc3\xeb\x69\xd3\x1b\x46\x98\xe5\x81\x2c\x15\x4d"
          "\xa2\xff",
          "\x73\x3c\xb8\xbb\x47\xb3\x2b\x83\x3c\xf6\xc4\xd6\x5c\xca\xc5\x06",
          "\xaa\x51\x24\xf8\x4d\x09\xb0\x86\x0a\x87\x8b\x8c\xc7\x96\x26\xb8\xc9\xb0\x62\xcc\xa4\x1d"
          "\x20\x00\xa1\x97\x4a\x92\x3f\x9a\xe7\x10\x66\x27\xa5\x4b\xcb\x02\xa0\x77\xe5\x07\x18\xf9"
          "\xee\xe6\x84\x2e\x58\xb3\x03\xa3\xa6\x41\xb4\xda\xc7\x34\xbd\x5b\x88\x6b\xd5\xd8\x56\x83"
          "\x21\x46\x4a\xb5\xa0\xad\x7f\x7c\x72\x74\xbb\x9a\x3f\xef\xa0\x49\x85\x13\x48\xe9\x5e\xe4"
          "\x91\xc8\x85\x9d\xb4\x90\x94\x3c\x20\x27\x10\x1d\x61\xf6\x7a\xd6\x7c\x4b\x7d\xe9\xce\x46"
          "\x40\x5c",
          "\xc6\xd4\x23\x0b\x66\xdb\x53\xb5\x4b\xf4\xf9\x4c\x19\x56\x97\x91\x0e\x14\x11\x65\x48\x92"
          "\x2d\xc3\x07\x56\xbf\x43\x0b\xa8\x67\x0e\xb3\x2b\xf6\x14\xee\x8f\xc5\xaa\x70\x58\x24\xce"
          "\x6f\x43\x93\xce\xbd\x87\x2a\x94\x73\x9c\xcd\xb8\x21\xd6\x90\xf7\x7f\x57\x7d\x47\x3d\x3b"
          "\x1a\x37\xad\x62\x53\xd2\x7d\x1f\x83\x86\x90\x9d\x33\x8e\xd4\xa1\x47\x12\xc6\x44\x31\x2c"
          "\x1c\x8d\xb2\x14\x4b\xe4\x4b\x26\x59\xbb\x75\x14\x72\xe9\x92\x44\x92\xee\x21\x49\x41\x9b"
          "\xa8\x49",
          1, 896 },
        { 128, 192, 39,
          "\xec\xde\x8d\x56\x45\xec\xff\xe1\xff\x4f\xe4\x3a\x0b\x78\x91\x92\x23\x08\xdc\x9e\x5e\xbe"
          "\x79\xd9",
          "\x92\x00\x4a\x49\x7f\x6c\x14\x7e\xa9\x0f\xab\x83\xf4\x20\xbd\x08",
          "\x6a\xbb\xf4\xa7\x43\x9c\x6b\x57\x05\xd4\xc8\x45\xf1\xa6\xb3\x0d\x92\x0d\xb3\x1b\x10\x83"
          "\xce\x58\xce\xe6\x7e\xf1\x7b\xb5\x2f\xe2\x32\x80\xb3\x09\x79\x2d\x75\x57\x3d\x98\x65\x42"
          "\x8d\x15\x8d\xd3\x55\x2a\xfb\x97\xcb\x70\x2b\x39\xb4\x68\x6a\xac\x67\x3b\xd6\x11\xda\xe8"
          "\x8a\xc0\x22\x54\x55\x7d\xc8\x23\xf6\x4c\x3d\xa8\x23\x23\xf0\x23\xb0\x95\xee\x3f\x06\x4d"
          "\x86\x8e\x1f\x9d\x11\xcf\xb2\x0d\x5b\x4c\x5f\xc4\x29\x9b\x97\xad\xe7\xc6\xf0\xf5\x82\xf1"
          "\x35\x31\x63\x2e\xb5\xfa\x1e\xdd\x42\xd1\x03\x83\xdd\x60\xb4\x6b\xb5\x83",
          "\xd7\x5a\x24\xb9\xf6\x36\x28\xac\xc4\xe6\xb3\xa7\xa6\xfa\x77\x5c\x98\xcc\x9f\x59\xb0\x01"
          "\x84\x9f\x7e\xc8\x7c\x27\x3c\xb1\xef\xfe\xd0\x3e\x20\x4d\x60\xab\x35\xdb\xa2\x44\x65\x44"
          "\x00\xf3\x4d\xc7\x07\x82\xb8\xd7\xd5\xd2\xd3\xb7\x72\xc5\x17\xb6\x45\xab\x8a\x85\xcb\xd4"
          "\x22\xd4\xdd\xc5\xd4\x7a\xbc\x74\x3e\x3e\xe7\x2e\x95\x84\x12\xc9\x17\x4f\x2b\x81\x19\xae"
          "\xc8\x1f\x54\x39\x8c\x8e\xa6\x5b\x73\xe2\x21\x72\xab\x2f\xd9\xc8\xab\x00\xc4\x0a\x48\xb6"
          "\xa4\xcc\x08\xe0\x92\xca\x86\x04\xb2\xf9\xcc\x72\xad\xf6\xe1\x81\xfd\x1b",
          1, 1024 },
        { 128, 192, 40,
          "\xdc\x89\x73\xb5\x4a\xf2\x3a\xa6\xcc\x38\x0b\xa6\xb6\x3e\x83\xec\x26\xae\x2e\xa2\xcb\x1c"
          "\x70\x70",
          "\x24\x27\xbf\x76\x39\xaa\x3d\x45\x39\x54\xc1\x29\xd9\xdd\xe9\xa9",
          "\xd1\x90\x01\xc0\xa1\x32\x57\x7b\x83\x89\xc8\xe5\xc2\x04\xe3\xbc\xad\x82\x87\xca\x5d\xb0"
          "\x06\xdb\x7b\x0a\x75\x24\x1f\xfd\x13\x9e\x28\x7b\x5c\x19\xea\x48\x9e\xe7\x43\xc5\x3f\x7d"
          "\xcd\x3e\x84\x69\xad\x26\x03\xb1\x38\x8e\xd2\x6e\x64\x2a\xee\x6b\xf6\xdc\xec\x26\x9d\x1f"
          "\x5b\x36\x7b\xd1\xa8\x79\x31\x10\x66\xda\x40\x8a\x39\x42\x26\xb9\x17\x4a\xfc\x01\x55\x9e"
          "\xe5\x47\x9e\x43\xd0\x02\xea\x37\xdd\xde\xa0\xaa\x65\xf5\xca\xc2\x52\x6b\x33\xc0\x3f\xe0"
          "\xd5\xe7\xbe\x07\xc4\xd1\x98\xdc\xf8\xe4\x86\x46\x0e\xd9\x86\xfd\xd3\x17\x98\xc6\xb2\x00"
          "\x1f\x48\x9c\x87\x93\x09\x85\xf9\x97\xbe\x6a\x6d",
          "\x50\xe9\x29\x38\x01\x59\x8e\xf1\x9e\x49\xcd\xdd\xca\xb1\x42\x59\xb3\x12\xc0\xbb\x0d\xb0"
          "\x24\xcf\x70\x6a\x0b\x1e\x0d\x2f\xd1\x48\x4b\xab\xcd\x60\xff\xc0\xc5\x60\xe6\x77\x24\x14"
          "\x7e\xc0\xa0\xdc\xdf\x94\x74\x7b\xf2\xb1\x2c\x99\xbe\x55\x7b\x14\xf5\x4f\xf0\x7e\xef\x6e"
          "\x5b\xcb\xc2\xae\x67\xf6\x2b\xbc\x35\xbc\xa8\x01\xc2\xa4\x62\xaf\x8e\x7f\xf4\xf2\xd3\xfb"
          "\xc6\xa5\x7c\xe1\xc5\xb3\x69\x86\xfd\xf0\x74\xa5\x92\xb5\x59\xf6\xb1\x4f\x37\x6d\x30\x30"
          "\x81\xc9\xad\x28\x3b\xe4\x6a\x40\xd8\xf3\xbd\x03\x19\xbc\xc8\xe1\xea\x51\xd2\xd0\x34\x1a"
          "\xb7\x8d\x2d\x94\xb7\xb9\x4b\x6d\x72\x34\xd2\x31",
          1, 1152 },
        { 128, 192, 41,
          "\x63\x9a\x60\x1e\xbc\xd1\x67\xb2\x6b\x81\x10\x8c\x4f\x9e\x7f\x60\x2f\x0c\x57\x2a\xca\x88"
          "\x78\x00",
          "\x63\x55\xd7\x3d\x88\xe2\x90\x4f\xc5\xc0\x5e\x69\xbb\xf1\x8e\xa9",
          "\xe4\xdf\x2d\x7f\x48\xd2\xda\x5b\xeb\x2f\x01\x8b\x14\xf0\x03\xa2\x25\xb5\xe5\x97\x8d\xd3"
          "\x27\x4e\x71\xf6\xef\xe5\x8e\x6e\x7b\x88\x4a\x8f\x13\xb7\x74\xd6\xef\xf4\xb2\xdc\x8f\x05"
          "\x2f\xa7\xb7\xd6\x4a\xfc\xa0\x62\x59\x9e\xf4\xd2\x33\x3f\xf4\xb8\x9c\x50\x37\x65\xa9\x6a"
          "\xce\x8f\x16\xe5\x98\x5a\x02\x18\x29\x12\x00\xc0\x9b\x54\x10\x59\xe0\x8a\x0f\xcd\x7f\x5e"
          "\xc6\x2e\xfb\x09\x63\x2d\x4b\x5c\x8a\x70\x00\x76\x99\x2f\x3e\xfe\x32\x79\xdd\x43\x3c\x46"
          "\x85\x0d\x93\x4e\xc5\x35\x6b\xe8\xf7\xe7\x39\x7a\x86\x6c\xa1\x86\xd1\xe7\x64\xa7\xe7\x9e"
          "\x90\x50\xbe\x4f\xb1\x1d\xb3\xe4\x80\xb4\x42\x68\xcc\x62\x85\x37\x26\x71\xfe\x21\x7b\x46"
          "\x91\xe3\xd9\x83\xec\x04",
          "\x8a\xcb\x83\x36\xbf\x75\x14\x2e\xd3\xd0\x33\x57\x9d\x4c\xcb\x24\xc6\xe7\xba\xff\x39\xdb"
          "\x42\x05\xef\xa0\x56\x5a\x80\x09\xd3\xd5\xbe\xde\xa4\xcc\x07\x2b\xfb\x67\xa1\x41\xd4\x5f"
          "\xc7\x58\x3a\x71\x99\xda\x7e\x82\xac\x97\xf7\x89\x58\xa9\x9e\xc6\x1b\xa4\x6d\xbd\x46\x2a"
          "\x25\xd5\x3c\x91\x0c\x3c\x3e\xb1\x93\xc0\xf7\xb6\x7a\x1f\x16\x03\x17\x61\x07\x69\x02\x73"
          "\xb6\x30\xad\x18\xe9\x43\x26\xb0\x95\xfb\xd2\xfc\xc4\x94\xed\xed\xe6\xa6\x78\x2d\xe9\xf7"
          "\x38\x25\xdc\x3d\x48\x21\x0b\x99\x06\xb9\x99\x0a\xf4\xd0\x8b\xf8\xef\x8c\x33\xd0\x28\x2f"
          "\xbb\x5b\xf1\xb3\x65\x77\x8e\xf0\xe7\xa1\x51\xd0\xc8\xd7\x65\xa2\x52\x38\x0d\x0b\x74\xac"
          "\x53\x9d\x99\xe3\x74\xe3",
          1, 1280 },
        { 128, 192, 42,
          "\xa1\x9e\xed\x56\x61\xb4\x2a\x42\xa6\x0e\x40\x38\x60\xe5\x6a\xdc\x27\x06\xbe\x4e\xd3\x23"
          "\xd9\xf0",
          "\xf6\xb0\x0b\x6b\xdf\xf4\xd6\xf8\x8f\xd4\xf4\x34\x02\xb8\x13\x9d",
          "\xef\x6d\xd8\xb7\x26\xa8\x23\xbe\xaf\x93\x30\xac\xcf\x74\x59\x09\xb2\x0f\xf1\x03\xdb\x82"
          "\xf6\x8f\xa2\xc2\x40\x13\x15\x95\x02\x5c\x09\x3e\x4f\x73\x64\xb4\x2e\x88\x2f\x2a\x0b\xd5"
          "\x8c\x0d\xc1\xa0\xb5\x1f\xb1\x65\x27\xc0\xb5\xa1\x56\x6f\xa7\xd4\x61\x2e\xd2\xde\x6e\x20"
          "\xc3\x5e\xec\xee\x60\x62\x76\x22\x86\xf0\x23\x16\xe8\x6b\x60\x98\x7f\x60\xfd\x31\xf3\xf4"
          "\xd0\xca\xa2\x1a\xa8\x5e\xd5\xdf\xe6\xf1\x23\x28\xf8\x7c\xee\x9a\x51\x63\x62\x4a\x87\xb9"
          "\x3c\x08\x2a\xde\xa4\xa1\x6e\x39\x7b\xd1\x55\x52\x44\x95\x86\xf7\x7d\x8f\x89\x4b\x0f\xc7"
          "\x35\x81\x2b\xa4\xd3\x5e\xce\xe4\x82\x45\xb6\xda\xa5\xf0\x54\x62\x90\xa4\xa4\x88\x15\x98"
          "\xed\xb7\xc8\xdb\xc6\x6c\x32\xbe\x4d\xf6\x6e\xfa\x08\x65\x8d\x70\x86\x61\xf9\x81\x75"
          "\xc2",
          "\x7e\xc5\x86\xb4\xb4\x25\x5c\x1e\xf1\x28\x39\x25\x72\xad\x62\x27\x81\xab\xf4\x3e\xd0\x49"
          "\x6f\xe4\xb9\xff\xaa\x32\x5a\xa0\x4a\xcc\x1b\x92\x59\x20\x23\xa8\x52\x6d\xd8\xbe\x77\x31"
          "\xca\x75\xd9\x89\xf1\xce\x15\x85\xab\xf9\xe7\x9b\x39\x27\x41\xd4\xef\x68\xcd\xbd\x87\x72"
          "\x36\x50\x30\x29\xfb\x6d\x29\xf5\xc9\x7f\x3a\x36\xb6\x9c\x0e\xac\xbf\xcc\x9a\x8b\xa9\x34"
          "\x4f\xe1\x32\xd3\x68\x26\x73\xd5\xbb\xfa\xd2\xa3\x47\x4e\xa1\xce\xcf\xba\xb7\xd2\xba\xfd"
          "\x9d\x1e\xba\x7c\x80\x2e\x33\xed\xa4\x33\x7f\x41\x45\x19\x3f\xec\x97\xa9\xa1\xf5\xf7\xaf"
          "\xa5\xae\x53\x93\x88\xa2\xed\x0a\xe1\x20\xc3\xc7\xd5\x3b\x9c\x5b\x64\x4b\x25\x07\x70\x18"
          "\xc8\xd6\xeb\x26\x68\x76\x52\x01\x65\x72\x79\x7c\xcc\x37\xca\x66\x0b\x0b\xf7\x97\x84"
          "\x50",
          1, 1408 },
        { 128, 192, 43,
          "\x94\x75\xae\x60\x0c\xd7\x25\x48\x19\xd6\xed\xc3\x34\xf1\x68\x1b\x6c\xf0\xa7\x8b\xd9\x4d"
          "\x4a\x73",
          "\xdb\xba\x57\x1f\x7f\x19\xf0\xf6\x74\x25\x97\x9a\x1e\x64\xb0\x0b",
          "\x75\xfa\x12\xcb\x43\x84\xbb\x23\xdd\xa8\xf6\xf0\x78\x9b\x7b\x39\x03\x44\xa6\x36\x63\x1f"
          "\xae\x5a\xf7\xee\xc5\xb6\xe7\x7e\x60\x3b\xb4\xd0\x73\x94\x33\x20\x24\x4b\x23\xc1\x54\x01"
          "\xe8\x3f\x35\x8f\x75\xa0\xff\x0b\x52\x89\xc0\x8f\xdc\x3b\x64\x7c\x0f\xf6\x40\x24\x56\x2e"
          "\x6a\x3a\x52\xff\xb5\x98\xda\x5e\xf4\x4d\x89\xda\xbf\xac\xc7\x10\x97\xbf\x8d\x6b\x17\x28"
          "\xd2\xaa\xd7\x71\xaa\x65\x5d\xbb\x73\xe5\x57\xdb\x19\x63\x88\x75\x54\xe7\x75\x89\x5b\xbe"
          "\xbc\xfc\x41\x5d\xdb\xaa\x98\x21\xf8\x4c\x85\xdd\xec\xe5\x78\xa7\xd2\xcc\x28\xef\x68\x7e"
          "\xf1\x4c\x05\x11\xc0\x0c\x2a\x56\xa1\xd4\x12\x9a\x88\x37\x13\x48\xc4\x8a\x04\xf2\xfd\x75"
          "\xc5\x4a\xd8\x4b\xf2\xfe\x07\x0d\xdc\x54\xee\xcb\xd6\x9c\xfa\x85\x4d\xd7\xab\x63\x66\x67"
          "\x66\x2a\xf6\x8c\x82\xe4\x45\xaa\x7d\x2a\xc8\xbd\xfc\xe0\x69\xfb",
          "\x10\x14\x12\x1d\x07\x86\x6c\x4b\x48\xc7\xd9\x58\x66\x6f\x7d\xdd\x43\xe5\x24\x89\xf7\xbe"
          "\x3a\xac\x50\xc8\x48\x0d\x44\x6d\x3d\x05\xf2\xff\x0d\xbc\xd0\x3a\x0d\x34\xad\xfe\xac\x6c"
          "\x6e\x59\x5c\xb5\x45\xe5\x58\x93\x1f\x93\xcf\x4b\x89\x22\xf3\x58\x58\x46\xba\x74\xe3\xcf"
          "\x2c\x4d\x00\xfa\x3f\x41\xa0\xfe\x38\x97\x09\x99\xe7\x94\x13\xa9\xf9\x55\xac\xb4\x3d\xe5"
          "\x7d\x65\x40\xf1\x03\xc2\xe8\x7e\xf1\xcd\x80\x36\x3e\x60\x91\xf7\xd4\x91\x79\x40\x11\xb3"
          "\xd4\x82\x8c\x3e\xee\x98\xf2\xce\xa4\x72\x2d\x96\x4b\xa8\x99\x6b\xa8\xa0\x8a\xef\x20\x9a"
          "\x1c\x2c\xf0\x25\x56\x79\x2c\x89\x32\x6b\x4e\x20\xa8\x5a\xd0\xe3\xca\x8b\xa7\x56\xd3\x38"
          "\xe1\xdd\xf7\x96\x13\xd4\x27\x03\x2b\xa8\x6f\x53\x36\xaa\x5d\x08\xf7\x5d\x51\x1f\x6c\x4f"
          "\xfb\x60\xe3\xcc\x70\x9f\x33\xb5\x3b\x3e\x18\xf2\x34\xc4\x96\xdf",
          1, 1536 },
        { 128, 192, 44,
          "\x31\x85\x9d\xdf\x0b\x15\xcb\x16\xab\x6b\x7d\xb2\x5f\x54\x08\xd5\x28\xc3\x42\x06\x80\x49"
          "\xd6\x1c",
          "\x31\xa3\x4d\x3a\x9f\x97\x71\xee\xad\x75\xce\x3d\xba\xf0\xdb\xbf",
          "\x93\xe0\x74\xb6\x03\x5d\xbd\x70\x2a\x65\x21\x11\xfc\x15\x74\xb9\xd9\x0e\xed\x19\x6c\xcc"
          "\x7b\x5d\x67\xc8\x38\x0f\x92\xe9\x0f\x8c\x26\x28\xc5\xd3\x95\x1d\x33\xa1\xfd\x9d\x2f\xc7"
          "\x26\xb3\x8e\x10\x02\x88\x9e\x7a\xb1\x33\x9f\x96\x68\xdd\x7a\xb4\x92\xa0\xfe\x2f\xb4\x1f"
          "\x5f\xa4\xb2\xe6\x48\x0c\xe4\x0c\xc7\xef\x44\xa0\x3e\x8d\xaa\xef\xb8\xa1\x98\x05\x14\x14"
          "\xf7\x69\x24\x6a\x7c\x19\xbb\xe0\xf1\xdc\x92\x86\xa3\x58\x84\x31\x68\xed\x5c\x92\xd5\x22"
          "\x94\xd7\x5f\x44\xc6\x5c\x01\x73\xd3\x87\x48\xa5\xb2\xec\xfb\x70\x53\x04\x05\xb5\x39\xed"
          "\xdc\x4b\x6b\xfd\xae\xdb\x48\x5e\xda\xbf\x24\x62\xe0\x51\xd3\xe9\x3a\xa7\xa7\xd8\x93\x9b"
          "\xd7\xf7\x5e\xfa\x78\xd8\x69\x1a\x84\x91\x31\x91\xae\x16\x23\x59\xc9\x79\x33\x30\xd3\x35"
          "\xe1\x41\x10\xb6\xa0\x34\xc3\xe4\xa1\x7f\x68\xf8\x95\x34\xcc\x47\xbd\xc7\xd1\x7c\x52\x70"
          "\x48\xb7\x48\x57\x9b\x18\xf2\x31\x02\xfe",
          "\xd7\x16\xc7\x96\x51\x64\x72\x45\xb7\x1f\x20\x7b\xef\x03\xcb\x67\x60\x20\x36\x2b\xe4\xf8"
          "\x9b\x42\xb3\x4e\x43\x93\x64\x61\x10\x48\x68\xda\x09\x38\x7b\x5d\xfb\xdc\x57\x9c\xa2\x46"
          "\x40\x4b\x41\x59\x0e\x4e\x61\xfc\xd6\x30\xa8\x25\x9f\x5d\xcc\x9b\x13\xc7\x59\xea\x96\x7a"
          "\xf1\xe4\x16\xc7\x0f\xc4\xe3\x28\xbf\x67\x0e\x61\x05\x98\x98\xf2\x2f\x2f\xed\x73\x60\x46"
          "\xa1\x9e\x12\x62\xa3\x29\x94\x00\xe8\x4d\x28\x22\x02\xca\xc0\xeb\x07\xc7\x1f\xd0\x8d\xe4"
          "\xbb\xc1\xef\x7d\xd5\x67\xcd\x8d\x6a\xbd\x98\xd7\x35\x34\x0a\xaf\x66\x1f\x77\x0d\x87\xc7"
          "\xed\xaa\xb5\xcf\x3a\xc2\x88\xdb\xd9\x24\xde\xa6\xe8\x1e\x2f\x57\x82\x41\xe7\x37\x58\xd2"
          "\xb3\x46\x41\x03\x73\xc0\xbd\x74\xc0\x80\x47\xe1\xcb\x32\x84\x4c\x26\xd3\x68\x05\x8f\x2c"
          "\x7d\x3f\x1a\x67\xb0\x69\x62\x0a\xaf\x3c\x0c\xb6\x7d\x14\x9f\x32\x56\x81\x07\x8d\x76\x0b"
          "\xa5\x94\xc5\xaf\x7f\x05\xb3\x75\xf9\xea",
          1, 1664 },
        { 128, 192, 45,
          "\xbc\xd5\xf4\x66\x84\xb4\x55\xbb\x9a\x26\x4a\x52\x11\xc4\xcb\xce\xc9\xe2\x27\x0d\x31\x77"
          "\xec\x9a",
          "\xf7\x67\x4e\xe1\x76\x51\x76\xf8\x8b\xc5\x3b\x71\x10\x70\x31\xec",
          "\x3b\xf9\x29\x28\x93\x16\x2b\xfc\x8c\x9b\xe5\x7b\x6d\x7c\x1a\xde\x97\xf7\x50\x98\x06\xf6"
          "\xd3\x0f\xf0\xdc\x53\xec\x87\xd0\xc0\xbe\xeb\xaa\x4b\x0e\x06\x90\x5e\xfa\x62\x39\x86\x40"
          "\x51\x17\x35\x32\x08\x43\x85\x88\x3d\x16\x77\x61\xb4\x43\x31\xaa\x13\x47\xd9\xde\x39\xf1"
          "\xc2\x9f\xe0\xc8\x95\xa9\xdd\x5e\x5d\x4d\x7f\x33\x1f\xeb\xfb\xab\x33\x1f\x92\x9b\xd9\x6d"
          "\xd4\x67\x86\x32\x5a\x3c\x0d\x06\x60\xa9\xab\xde\x7c\xc9\x3d\xca\xa5\xbd\x15\x5f\x6a\x56"
          "\x33\x1d\xf4\x0a\x38\x16\x34\x5a\x8d\xfd\x5e\xed\xc7\xeb\x8b\xd8\xc4\x86\xe1\x65\x44\xd6"
          "\x61\x38\x82\x56\x20\x3b\xbf\x24\xae\x71\x74\x94\xf2\x09\xfb\xe6\xb5\x69\xa0\x02\x38\x96"
          "\x8f\xa7\x6d\x43\xf0\x58\xc4\x29\xb5\xed\xd4\xf9\x0f\xfc\x23\x01\xbf\xdc\xf0\x65\xc2\xa2"
          "\x4a\xd0\x20\xc6\x81\xe6\x12\x6a\xd7\x5f\x0f\xc8\xda\xfe\x95\xa9\x35\xf4\xc9\xa7\x68\x2a"
          "\xb4\x90\xe7\x66\x6b\xf7\x89\x88\xe1\x07\x1c\x89\x4e\x94\x60\x80\x4a\x73\xd6\xb6\x30\x5f"
          "\xe9\x5f\xf2\x70",
          "\xd4\x23\x1f\xf6\xd4\x5e\xed\x70\x0c\x50\x92\x8a\x4c\x40\x6e\x18\x0a\xe0\x61\x52\x45\x3c"
          "\x2b\x22\x6b\x1c\x68\xf7\xa0\xd7\x3a\x8e\xd2\xdd\x37\x11\x86\xac\x39\x93\xb1\xa0\x8a\x42"
          "\x92\xcc\xd1\x24\x8b\xa6\x11\x1c\x4c\xd4\x06\x3b\xc7\x80\xb7\x50\x7e\x11\x7e\x12\x58\x01"
          "\x5c\x13\xc3\xc6\x15\xa3\xff\xda\xc2\x73\xe4\x02\xab\x2d\x42\x5d\xa2\x54\x89\x7e\x11\xe5"
          "\x1e\xb1\x7e\xaa\x96\xe3\x98\x06\xc9\xd4\x2b\xd7\x0d\x3e\x2a\xf4\x41\x14\x54\x63\xae\x1f"
          "\x1d\x35\xa1\x67\xdf\xc9\xd1\x0a\x0c\x17\x9b\xe9\x51\xa1\x08\x63\x85\x7f\xf3\xe9\xe2\xbd"
          "\x40\xef\x7b\x1e\xb1\x8a\x6c\x9a\xd4\xaa\xe0\xb0\xa8\x48\xa4\xb1\x7d\xf3\xe9\x6b\x0b\x86"
          "\xa5\xc4\x77\xae\xe2\x46\x7c\xe3\x7c\xe1\x0b\xcf\xff\xc7\x0c\x0d\x19\x5f\x4c\xe6\x76\x22"
          "\xe5\xb1\xbc\xec\x38\xac\x47\x66\x06\xcf\x7f\x22\xd7\x01\x1c\x6c\x15\x0f\x18\x9a\x45\x2b"
          "\xeb\x9c\x79\x66\x74\x71\xc4\xe0\x6d\x36\x48\xbd\xb7\xeb\x9c\xff\xdd\x97\xe9\x4d\xb3\xfa"
          "\x67\x3a\xfe\x76",
          1, 1792 },
        { 128, 192, 46,
          "\xaa\xf0\x3c\x89\x11\x4a\xbc\xf9\x8f\x28\x01\x05\x05\xa1\x3d\xd3\xab\x17\xcf\x06\x19\xa6"
          "\xfc\x7a",
          "\xf1\xee\xb3\x56\xa9\x3e\x3a\xf1\xdc\xd8\x24\xdb\x9a\x61\x61\x0f",
          "\xe0\xb1\x53\xd8\x4c\xda\x61\x3e\xa4\x1a\x0d\x18\x5e\x98\x92\x29\x61\x17\x39\x03\x40\x74"
          "\xc3\xaa\x53\x98\x94\x32\x70\x6a\x14\x0a\x2d\x1e\x58\xe4\x51\x9e\xf1\xa2\xdb\x39\x99\x76"
          "\x60\x57\xe2\x1b\xc4\x4d\x8a\x5c\x79\x01\x78\x9e\xbb\xe8\xed\x4c\xdb\x02\x71\xd5\x76\x60"
          "\x38\xe7\xe1\xb9\xc3\xe6\x26\xe1\xfc\x91\x6e\x25\x0b\x1d\x9d\xe6\x99\x11\x20\x9b\x5b\x9a"
          "\x22\xf1\xf3\x1f\x45\x90\x98\xd5\x33\x6c\xa3\x01\xd1\x37\x29\xde\xae\x5c\x4b\x65\xf3\x85"
          "\x05\x23\x92\x6f\xd9\xff\xcf\xf9\x0b\x37\x9b\xd9\xb8\x0a\xf1\x70\x0a\xfc\x4d\xbc\x1d\x81"
          "\x5c\x39\x81\xa4\x20\x01\x4e\x24\x8e\x72\x10\xb0\xd3\xf8\x3f\x6f\x25\x59\x6d\xc3\xa9\x41"
          "\x17\x34\x5d\x9f\x3f\x42\xf9\xb1\x12\x14\xf1\xb2\x1a\x51\xa7\x3d\x85\x40\x77\x65\x47\x1c"
          "\x32\xfb\x4b\x2e\x8e\xcc\x0f\x90\xe2\x09\xd3\xaf\x27\x2d\xef\x80\x6c\xd1\x50\x94\xf0\x77"
          "\x7a\x6b\x25\xbf\x91\xec\x6a\x7e\x74\x47\x51\x03\x69\x96\x2f\x92\xbd\x19\x54\x86\x7d\xe0"
          "\x65\x85\xc8\xcc\x74\x7f\xd1\xf1\x37\xd3\xd3\xb0\xb8\x8c\xeb\xab\x13\x62\x46\xa1",
          "\x6a\xf9\x41\x07\x85\x25\x26\x94\x96\x8b\xd7\x95\x22\xd7\xe5\x62\x72\x77\xdc\xa4\xb6\xfc"
          "\x2c\x31\x8a\x89\x53\x6a\x89\xb2\x9f\x21\x89\x2f\x3f\x43\x60\x1c\x81\xe9\x76\x8f\x86\x9c"
          "\xc8\x45\xe1\x13\x67\x32\x6a\x1e\xb5\x3f\xc4\xfd\xec\x88\xd7\x31\x0e\xd5\x11\x91\x00\x13"
          "\x9d\x39\x06\x3e\x23\xe9\xaf\x7e\xec\xef\x3b\x2f\x74\xf7\x75\x33\x9d\xfa\x80\xdf\xbf\xba"
          "\x69\xf6\x41\x54\xc7\xf6\x51\xc2\xfd\xfd\x12\x6e\xc7\x14\x8d\xa5\x19\xc9\x85\xd0\xd9\x69"
          "\x4d\x08\xcf\x6a\xef\xf8\x25\x8e\xfd\xf1\xb1\x1c\xda\x7c\xc2\x28\x9f\xa0\xc5\x27\xf6\xe5"
          "\x75\x21\x51\x47\xa1\xb7\xaf\xf5\x60\xf8\x7b\xa2\x44\xc0\x89\xd3\xd1\x62\x47\x93\x83\x88"
          "\xc4\x06\x60\xc7\xfa\xb5\xb7\x4c\xe7\x43\x78\x84\xc9\x49\x4f\x21\x5b\x1e\x81\xb0\x1b\xfe"
          "\xa4\x6f\x99\xe7\x2d\xce\x44\x15\x47\x26\x23\x62\xac\xbe\xf0\xba\x2a\x40\xf1\x18\x20\x22"
          "\x35\x39\xab\x76\x59\x59\x6e\x64\x68\x3a\x49\xfa\x9f\x00\x8b\x00\x31\x95\x2b\x83\x4a\x17"
          "\x85\xca\xfa\x3b\xac\xc3\xd5\xf2\xd8\x18\xa3\x81\xcb\xc9\x61\x8e\x10\x26\xb3\xd6",
          1, 1920 },
        { 128, 192, 47,
          "\x42\xa5\xa5\xe3\x87\xcc\x88\xaf\xe4\xd7\xc5\xec\xbf\xc6\xa6\x0b\x07\x00\xe2\xaa\x73\x86"
          "\x6f\x6c",
          "\xe1\x4d\x37\xe4\xdc\x49\x83\xd8\x37\xca\xfc\xa0\x17\x01\xfb\x1d",
          "\xfd\xe5\x7d\xe9\x1a\x06\xe6\x33\x4f\x11\x84\x7c\x88\x71\xf5\x40\x1f\x33\x14\x29\xdd\x54"
          "\xd9\x93\xdc\x96\x36\xad\xef\x37\x82\x1a\xce\xad\xca\xe0\x60\x51\x5d\xb7\x3c\xac\x1b\xd2"
          "\x9e\xf7\xca\x8d\xe5\xd1\xd0\x4d\x0a\x5a\x64\x22\xd5\x8d\xaf\x6a\xf1\x29\xda\x2b\xbb\xc2"
          "\x9f\x13\xc5\xc2\x71\xcf\x0e\x55\xdb\xee\x67\x44\xa8\x35\x89\x8a\x60\x6b\x19\xe5\x35\x95"
          "\x41\x30\x6f\x44\x7e\x69\xe4\xef\xf4\xe3\xe3\xc7\x7a\xcc\x8b\x2c\x39\x7c\x29\xad\x13\x6b"
          "\x44\x9a\xc3\xb3\x43\x08\x61\xb6\x09\x1f\x74\xb8\xb9\x83\xfd\xd1\x81\x95\x04\x61\xbc\xa6"
          "\xf6\xc6\x8b\x4b\x59\x4c\x90\x17\xf7\x42\x71\x42\x06\x49\x99\x3b\x09\x45\x23\x00\x38\x05"
          "\xbf\x6a\x0b\x60\xaf\x79\x3c\x8e\x9b\xf5\x52\x71\x61\x1a\x25\xe9\xb4\xed\x6a\x0b\x3b\x34"
          "\x59\x0e\xb7\x72\x39\x5d\x35\xc2\x3a\x47\xda\x93\xd5\x5a\x32\x2e\x85\xe7\x8c\xd6\x42\xbf"
          "\x69\xc8\x8b\x8a\x0d\x08\x5a\xc7\xd5\x2f\x0f\xa3\xe2\x0f\x3d\xa5\x5d\x1f\x78\x92\x4f\xe5"
          "\xfe\xe9\xb8\xe2\xee\x8a\xd7\x49\xaf\x56\xa1\xd6\xcb\xe0\x3b\xed\x0a\xaf\xa2\x08\xe7\x41"
          "\x95\x2e\x39\x42\xb5\x02\xe4\x86\x70\x59\x53\x7b\x4c\xc5",
          "\x9b\xfe\x52\xe4\xe8\xc7\x73\x13\x86\x72\x92\x26\x64\x1b\x69\xd7\x4f\xb0\x43\xde\x9e\xa6"
          "\xc6\xda\x68\x33\xe0\x45\x8d\x95\xeb\xce\x41\xac\x9c\xbd\x8b\x38\x1d\x12\x7c\x7f\x20\x5c"
          "\x06\x56\x78\x08\x8d\x25\x94\x80\x70\x21\x3a\xf1\x97\x24\xe6\x22\xfe\x92\x6f\xd2\x9d\xae"
          "\x5e\x70\x50\xc2\xb7\xbf\x5d\x19\x13\x24\xae\xa2\x9a\xdb\x3b\x9a\x05\x8c\xb7\x39\x2c\x3e"
          "\xed\xa0\xa8\x00\x51\x29\x81\x88\xe9\xc7\x15\x29\xf9\x6b\xef\x67\xc5\x4e\xdc\xc6\x97\xcf"
          "\x36\xbf\x97\x9e\x56\xeb\x5a\x52\xfe\xe8\x44\x82\x73\x19\xf4\xdd\x4a\x8a\x3e\x53\x80\xa7"
          "\x96\x59\x8c\xe9\xcd\x80\x1c\xc5\x57\x29\xfa\xfb\x34\x87\x05\x05\xb7\xe3\x2c\x6f\x29\xa8"
          "\xd2\x53\x3d\x87\x12\xac\xd9\x8e\x24\x93\xec\x56\xc8\xdd\x32\x51\x51\xa3\x76\x92\x9b\x94"
          "\xff\xf1\x6c\x71\xff\x95\x0c\xd4\x12\x7c\x6a\x65\xd9\x5c\x7d\x86\x75\xe6\xa6\xa6\x7f\x8b"
          "\x1e\x9a\x83\x38\x00\x20\x27\x90\x15\xf7\x85\x60\x79\x2a\xba\x89\xea\x9c\x84\x0f\xe5\x5c"
          "\x2a\xb4\x36\x4e\x58\x1f\x24\x03\x66\xf1\xdc\x10\x45\xd6\x25\x26\x38\xe2\x0b\x48\xee\x62"
          "\xf4\x19\xd3\xd1\x65\x23\x21\x13\xec\xbe\x13\x48\x25\x41",
          1, 2048 },
        { 128, 192, 48,
          "\x9b\x0d\x1f\x04\x79\x3d\x47\x8c\x55\xd4\xa7\xc1\x99\x12\x83\x90\xab\xf0\x6d\xdb\x84\xcd"
          "\x88\x28",
          "\xa9\xfe\xc0\xcc\x2f\xe3\x04\xe8\x21\x31\x4c\x92\x4c\xc5\x70\xfe",
          "\x8a\x07\x3d\xf6\x1e\xdf\x34\x2f\x97\x44\x28\x47\xf8\xec\x37\x2b\x6d\x9d\xf9\xd6\x1a\xdf"
          "\x45\x07\x82\x9c\x7f\x26\xbd\x91\x38\xd8\xbd\xa7\xae\xcc\xe0\x05\x53\x86\x14\x13\x0e\xb3"
          "\x4d\x6e\x72\x2f\x74\x60\x06\x5a\xf3\xb5\x7e\x84\xe7\x97\x85\xb9\xf6\x5d\x8d\x7f\x19\xc6"
          "\x13\x6d\x93\xe2\x97\x04\x1f\x91\x24\x2b\x86\xbe\x96\x12\x9c\xaf\x0c\xd1\x3b\x64\x65\x99"
          "\x9c\x07\x6f\x91\x3f\xc7\x8a\x83\xa8\xd9\xb5\xe3\x5a\x36\x5d\xae\x96\x5c\x19\x9a\xb5\xc7"
          "\x49\x3a\x38\x46\xd3\x56\xf7\x26\xe6\x59\xaf\xd0\x5c\xa5\xfa\x10\xb9\x4d\xb5\x27\xe2\x55"
          "\xea\xed\xff\xd2\x41\x3c\x7f\xf3\x93\x53\xea\x47\x98\x69\xe0\x12\x87\xd3\x02\x30\x57\xfd"
          "\xa4\x98\x9c\x0b\x83\xf8\xf3\x7a\x58\x21\x53\xd6\x88\xc2\x4d\x1e\x33\xa1\xed\x7c\xe6\xa0"
          "\xd3\xa4\x8b\xcd\x7e\x78\xc8\x1e\x54\x5c\xfc\xef\x7c\x0f\xb9\x78\xff\xd4\x36\xed\x78\x1e"
          "\xfc\x8e\x12\x1d\xdd\xbd\xe7\x56\xce\x2c\x15\xac\xaa\x0c\xf1\x57\x7a\x23\xa0\xbf\xe8\xc7"
          "\xe9\xcd\x2d\x67\xe8\x1b\x87\xe4\x65\xf3\xf8\x1e\xdd\x8c\xbc\xac\x0d\x60\xfd\x66\x15\x7a"
          "\x7a\xde\x58\x10\xa7\xf0\xd9\x5c\x64\x84\x8a\x5e\x16\xd7\x46\x5a\xd2\x40\x39\x60\x81\xd0"
          "\xea\xc9\xe8\x96\xc7\x17\x76\x6c",
          "\x16\x6c\xd8\x67\x53\x44\x14\x8a\x26\xbb\xdd\x69\xc1\xee\x10\x53\x18\xb8\xf2\x34\xa4\x40"
          "\xbe\x3b\x27\x0b\x4f\x2c\x48\x40\x70\xb5\x8a\x9a\xa0\x16\x17\x14\xc8\x58\x8e\xe6\x9c\xe2"
          "\x1f\x85\x0a\x7f\x45\xbc\x89\x7f\xbe\x1c\x2a\xd6\x35\x31\x68\x5e\xff\x59\xa2\x8f\xe2\x14"
          "\xf3\x98\xb8\x9b\xac\x25\x61\xd2\xf7\xc5\x46\x41\x69\xa2\xb4\xb0\xaf\x11\x67\x5f\xa3\xf7"
          "\x07\x4f\x18\xa1\x8f\xd8\xcc\x2d\x27\x01\xa9\x2e\xc6\x70\x88\x8c\x85\xfb\x65\x88\xdb\xf7"
          "\xfe\x03\xb9\x14\xa8\xdc\x7d\x9f\x00\xe7\x7b\x6b\xd3\x9d\x12\xf7\x0c\x3c\x13\xbc\x03\x0e"
          "\x98\xfc\x87\x10\xd0\xe1\x19\xff\xb2\x5a\xca\xd6\xef\xd6\x9c\xf7\x10\x48\xdc\xa2\xbd\x8e"
          "\xad\x3b\x3a\x39\x4e\xd7\x77\xfd\x93\x92\xf6\x08\x1d\x5c\x25\xe7\x91\xca\x62\x76\x0b\xc6"
          "\xe3\x5a\x04\x6b\x77\x5f\x20\xe4\xc5\x61\xc4\x6d\x6c\x9b\x13\x7b\x1e\x0d\xd9\xa5\xba\xb8"
          "\xbc\xd6\x96\x93\x5a\x51\xbb\x8b\x74\x9f\xf2\xe6\x66\xda\x6a\x13\x57\x16\x3f\x39\xfd\x01"
          "\x2e\xf5\x80\x6f\xf5\x69\xf9\xe8\xa9\x66\x2b\x2f\x4b\x93\x76\x97\x99\x1e\x53\x9e\x46\xde"
          "\xbc\x98\x41\x2c\xe3\xc0\x2f\x96\x08\xba\x35\x54\x5f\x9c\x07\x4e\x9c\x65\xcb\xd7\x85\x29"
          "\x88\xc7\xe7\xac\xdd\xe0\xe7\x32",
          1, 2176 },
        { 128, 192, 49,
          "\xc2\xac\xc9\x22\x9a\x73\xa4\x03\x2d\x4b\x22\x1f\x97\x80\xb8\xa9\x4c\x36\x9e\x35\x4f\xf2"
          "\x74\xf0",
          "\x94\x0e\x36\xf9\x03\x87\xbf\x86\xba\xc8\x1e\xde\x54\x91\xfb\x9a",
          "\x48\x51\x2e\x2a\x58\x59\x47\x87\xc8\x34\x5b\xf2\xd0\xf7\x70\xaa\x8f\xa5\xf2\xf1\xb7\x70"
          "\xa1\x0b\xb0\x9b\x91\x74\x53\x14\x8d\x5c\x53\x47\x2a\x4b\xf1\x92\x7d\xd3\x24\xa8\xcc\xa5"
          "\x44\xc8\x53\x04\x41\x53\x45\x67\x53\xad\x21\x8b\xb6\x68\xe8\x65\xe3\xa7\x14\x64\xd6\x89"
          "\x2f\x95\x30\xc6\x74\xcd\xa9\xbf\x81\xb9\xa2\x91\xbb\x73\x51\xe6\xb9\x5c\x7e\x6d\xa6\xa8"
          "\xf5\x6a\x56\x3a\xbc\x89\x7c\xf9\x08\xad\xd5\xad\xf9\x34\x09\xb9\x11\x33\x31\x1f\xa0\xa6"
          "\x7f\x1a\x78\x46\xbf\x66\x32\x64\x40\x5d\x0d\x0b\xdf\x41\x5f\x3d\xf6\x4e\x34\xea\x77\xcf"
          "\x93\x4e\x06\x9c\x21\x1a\xb2\x39\x2a\xc7\x04\xf7\x57\x3f\x0b\x62\xcb\xd0\xba\x4f\x32\x9d"
          "\xd4\x66\xf9\xab\xf7\x52\x7a\xac\x9b\xf7\x97\x7f\xf7\xf9\x18\xe2\x7e\x78\x04\xa0\x2f\x3b"
          "\x3d\x9f\x75\x3d\x36\x68\x0a\x26\x05\x3f\x07\x10\x5b\xf2\xb4\x44\x2d\x09\xe5\x73\x5d\x86"
          "\xf4\xd4\x94\x6f\xdb\x29\xd7\x5a\x4f\x73\x5e\x83\x8a\xd0\x31\x55\x69\x8e\xdd\x1e\x82\x03"
          "\xed\xb3\xb5\x65\xca\xc5\x6d\x97\x52\xf0\x3a\xf5\x0c\xc1\xd7\x3e\x9a\x28\xc5\x6a\x41\x90"
          "\xd3\x32\xf6\x76\xf8\x8a\x94\x44\x5f\x1b\xee\x18\x22\x71\xc3\x86\x0b\xe6\xa9\xb2\x43\x5f"
          "\x8f\x68\x28\x58\x52\xa6\x89\x70\xc1\x1d\x1f\xb0\xbb\x6d\x1e\xce\x4b\xc4\x3d\x0a\x67\x65"
          "\x09\x8d",
          "\xe7\xd5\x7d\xf5\x4a\x97\x53\xb9\x5b\x64\xeb\xac\x46\x44\x17\x53\x23\x0c\x1d\xd7\x48\x92"
          "\xe2\xc7\x3b\x89\x48\x82\x59\x66\x01\x30\x53\x4b\x81\x0f\xc3\xe4\x70\x26\xf6\x6f\x43\xb4"
          "\x33\x82\x51\x74\x78\xb6\x96\x95\x1b\x87\x4e\xa0\x5f\x1a\x2b\x18\x92\xae\xd3\xdf\x25\xc7"
          "\x1c\x97\x62\x55\xf2\xd9\x51\x80\x45\x8f\xc6\x10\xc2\x47\x63\x88\xe7\x5f\x04\x81\xc9\xd8"
          "\xd4\xc2\x90\x84\x67\x7d\x42\xa2\xc1\x64\xcb\x2c\xf9\x44\x47\x94\xaa\x6a\x6e\x1c\x8b\x12"
          "\x08\x49\x43\x12\x9e\x44\xfc\x39\xcd\x6f\xe3\x35\xfc\x61\xa3\xd9\x03\x74\x2b\x5b\x1c\x20"
          "\x76\x52\xda\x08\x50\x32\x92\xc6\xf9\x43\x79\x15\xf7\x5f\xa5\xe8\x04\xcb\xe8\x79\x92\xa6"
          "\x2f\x93\xea\x63\x32\x60\x6a\x44\x3b\x20\x25\x7a\x93\xd1\x11\xe3\xe2\xbf\x2c\x65\x75\xf3"
          "\x65\x82\xc9\x97\x75\xce\xd6\xa3\x44\x64\xbe\xd6\x45\xa3\xe5\xc3\x93\xcf\x13\x84\xf0\xac"
          "\x0b\x45\x22\x3f\x9f\x26\x2b\xa5\x8a\x24\x6e\xf4\x44\xeb\x2b\x62\x93\xd8\x05\x73\xe7\xac"
          "\xbf\x2b\x8b\x81\xb1\x8f\x1f\x75\x28\xd9\x22\x02\x3e\x05\x3c\xf7\x13\x56\xc1\x15\xe2\xad"
          "\x84\x57\x94\x2d\x6f\x76\xbb\x4d\x92\x5f\x01\x26\x72\x44\x2d\xd1\x9e\x8f\x95\x78\x07\xd8"
          "\x21\x3b\xfd\x56\x56\x73\xca\x84\x1a\xb5\xac\x7f\xa0\xf1\x10\x00\x3a\x1f\x32\x10\x0e\xec"
          "\x12\x38",
          1, 2304 },
        { 128, 192, 50,
          "\x57\x51\xdb\xc6\x9f\x32\xd8\xfa\xf6\x67\xe7\xdc\x5c\x2c\xe0\x54\x33\x77\x89\x44\xaf\xfd"
          "\x26\xb5",
          "\x27\x4c\xa3\x4a\xa7\x58\x45\x8d\x3e\x50\xc3\x89\xce\xe8\x1d\x78",
          "\x42\xa5\x0b\xfd\x64\x11\x66\xf8\x6d\x84\xfa\x1f\x18\x00\x1d\xac\x19\xfd\xd0\xf5\xa4\x71"
          "\x09\xb7\xdd\x4e\xb5\x0a\x7a\xb9\x83\xe7\x57\x02\xda\xd7\x4e\xcf\x04\xed\xd5\x44\xa7\x54"
          "\xe0\x5e\x03\xb8\xfe\xb3\x9a\xa5\xc6\xda\x99\x30\x38\xa2\x7a\xf4\x24\x1d\x30\x54\xe8\xa2"
          "\x0f\xbb\xb1\x32\xf2\x7f\x2b\xaa\x8a\xb8\x24\x01\xd2\xf7\x39\x54\x92\xfd\xc6\x69\x67\xd9"
          "\x9c\x45\xc4\x35\x21\x84\xa9\xe7\xfa\x64\x46\x6e\xe0\xad\x48\x69\x52\x74\xb9\xf8\xdb\x84"
          "\x18\xe4\xf8\x8c\xcc\x96\x19\x71\x57\x64\xcc\x14\x32\x3e\x23\x99\xc8\x2a\xa8\xf5\x18\xda"
          "\x0d\x3b\xf1\xa0\xf8\xa5\x98\x46\x07\xac\xb9\x7b\xa6\x8e\xaf\x9b\x85\x0e\xb1\xa1\x5d\x4c"
          "\xbb\xf4\x8b\x91\x47\x3f\xf7\x2c\xa2\x83\x15\x63\x28\x08\x15\xa5\x2b\x37\x0b\x23\xae\xe0"
          "\x28\x7e\xfc\x57\xb4\x31\x01\xe7\x9c\x8e\x46\x18\xe9\xca\x7a\x20\xe8\x25\x8e\x65\x05\x25"
          "\x9f\x5a\x14\xef\xf4\xfc\x2a\x50\x10\xa1\x89\x71\x84\x2b\x21\x6a\xba\x4a\x6c\xaf\x38\x48"
          "\x41\x11\x2e\x60\x6f\xb6\x16\x27\x92\x63\x33\x68\xa0\x3e\xd7\xf5\x22\x29\x49\x9f\xfb\xc1"
          "\x9a\xe1\x29\xfa\xc9\x3c\xf2\xb6\x58\x00\xc1\x60\xdd\x1a\x69\xb3\x93\x89\xee\xbb\x65\x6f"
          "\x76\x43\x75\x92\xf7\xa1\xb3\xc8\x8b\xc9\x49\x86\x0c\xaf\x04\xbd\xdf\x23\xab\x30\xb1\x81"
          "\x1b\x3e\x4f\x40\xb8\x67\x22\x93\xdb\x1d\xb2\x97\xa4\xb2\x3c\x6d\xf3\x3f",
          "\xa4\x11\x10\x83\xc9\x4f\x4e\xc7\x59\xab\xc5\xfb\xd5\x40\x43\x6f\xed\x82\xb3\xe3\xbf\x89"
          "\xb3\x28\x97\x1c\x0e\x96\xd7\xa6\x43\x7e\x9e\x06\x77\xe5\xe0\xe3\xfe\x45\x36\xc4\xc1\xd0"
          "\x5a\x2a\x32\x84\xc2\x40\xd3\x15\x5c\xac\x5f\xcc\x3d\xc9\x30\xf4\x2d\xb0\xa2\x1e\x20\xce"
          "\xc6\x12\xbc\xdf\x41\x85\xfa\x63\xde\x48\x56\xfc\xb9\x28\xef\x2b\x3a\xb1\xc4\x32\xaf\x3f"
          "\x88\x7f\xdc\xac\xdc\x5c\xe2\xaf\x73\x3b\x5c\x26\x38\x8e\xe4\x04\x9f\x91\xc1\xf3\x8e\x7e"
          "\xed\xd3\x1b\x89\xf5\xc6\xed\xcc\x4f\xf3\x4c\x55\x4a\x90\xa0\x7d\x75\x4a\x3b\xed\xa8\x42"
          "\x3a\x60\x66\xc9\xe4\xa5\x90\x09\xc1\x6b\xb7\x65\x4f\x0d\x38\x29\x83\x79\xa1\x88\x29\x64"
          "\x7a\x0f\x73\x34\x59\x96\xb4\x04\x10\x30\x11\x80\x06\x41\xed\xbe\x40\x87\xc6\x0a\x27\xda"
          "\xf4\xe9\x9c\x11\xda\x90\xab\x24\x74\x01\x68\xef\x0e\x84\xad\x4c\xbc\x1d\xae\xdf\x62\x29"
          "\x39\x78\xdd\xa7\x76\xff\x94\xf8\x57\xf3\x4b\x03\xaa\xd1\xdf\xdc\x63\xf6\x5a\xc2\x14\xba"
          "\x40\xcd\x42\x4d\x25\x05\xcb\xbc\x0a\x05\x21\xb1\x21\xdc\x50\xb4\x50\x78\x4e\xc2\x61\xfa"
          "\xad\xb4\x03\x6f\xce\x8b\x6c\x60\x74\x90\x31\x48\xf4\x74\xaa\x30\x4f\x9d\xf9\x65\xa6\x06"
          "\x51\x8e\xd1\x5a\x92\xd8\x2b\x2e\xe0\xb2\xfd\xc3\x33\x2e\xa0\xbe\x9f\xbb\x5f\xde\xdb\xf1"
          "\x77\x9c\xc3\xcb\xa0\x8c\x04\x85\x5a\x7f\x8b\x4b\x20\xfa\x1c\x3c\x99\x0a",
          1, 2432 },
        { 128, 192, 51,
          "\x4c\x0d\xd5\x77\x4b\xe9\xa6\x9d\x1d\x5f\x42\x2f\xff\x26\x4d\x40\x5d\x74\xe2\xf7\x02\xae"
          "\x0b\xa0",
          "\xf8\x75\x32\x35\x5c\x29\xf7\x65\x77\x2b\xb3\x62\x08\x4a\xaa\x51",
          "\x10\x8a\xde\x62\x63\xb5\x23\x4c\xa5\xd3\xf5\xfc\xa8\xf5\xca\x94\x7d\x1f\x7e\x6a\x16\xae"
          "\xe0\x39\xba\x16\x53\x3c\x44\x48\xe0\x31\x5c\xd5\xd2\x8d\xde\x30\x19\xcb\xd6\xeb\xcb\xb2"
          "\x27\x93\xef\xb6\xcf\x31\x5b\xf2\x1c\x3f\x84\xb6\x44\x0e\x53\x5b\xc3\x57\x6c\x57\x5a\xf9"
          "\xa1\x1c\x96\xe3\x8a\x2d\xf7\x89\x41\xd6\xe5\xdd\x2e\xe6\xf2\xe4\x28\x5a\x30\xeb\xda\x22"
          "\x85\x85\x95\xd0\x2d\x7b\x42\x02\xf9\x69\x86\xe3\x80\x43\x67\x95\x22\xa3\xee\x7c\x5b\xc3"
          "\x40\x7f\x98\x54\x28\x5e\x1d\x89\xa3\x0f\xaa\xfb\xd5\xec\x18\x47\x2f\x5d\x00\x40\xdd\x60"
          "\x7e\x75\x18\xa8\xbe\x3f\x37\x5d\xef\xf0\x37\xa4\x01\x40\xf3\xf0\x1b\x60\x82\xc8\xfb\x8d"
          "\xcc\xc1\x3b\xc1\x22\x01\xff\xd1\x21\x08\x3d\x59\x1e\xe6\x22\xde\x06\x16\xdd\x70\x51\xe1"
          "\x53\x71\x93\xf6\x60\x43\xac\xa1\x79\x57\x7b\x9e\xe4\x4b\xa2\xce\xdf\x55\x08\x97\x55\x02"
          "\x0a\x1e\xd6\xf7\xb8\x95\xd5\x38\xa0\x63\x70\x1f\x25\xd5\xb4\xd0\x95\x22\x70\x91\x60\xc7"
          "\x4e\x2b\x9f\x87\xa2\x77\xdc\x9f\x6d\x92\xcf\x8e\x3f\x58\xde\xde\x46\x11\x95\x28\x90\x48"
          "\x73\x27\x00\xf8\xb3\x9a\x9f\xcd\x2c\xa4\xf3\x3a\x91\xf1\x50\x73\x1b\x29\xc0\x6e\xc9\xfa"
          "\x4c\x69\x07\x24\x14\xb1\xbe\x27\xd4\x6b\xaa\x95\xc9\x07\xe9\xe6\x24\xac\x5a\xa2\xfa\xf2"
          "\x08\xc8\xcb\x10\xfe\x55\x67\x98\x94\xe9\x68\xd1\x65\x52\x3a\xa6\x62\x07\xca\x16\x92\x2e"
          "\xcb\x82\x5f\x88\x67\x5d\x44\x49\x85\x73\x53\x4b",
          "\xbc\x50\x8b\xe0\x0a\xe5\x32\xa9\x59\xc9\x9b\x1e\x75\x32\xf6\xad\x52\xfd\xaf\xf2\xc6\x54"
          "\xfd\xf8\x65\x43\xad\x6b\x93\x7f\x44\x02\x90\x41\x46\x1e\x64\xc2\xe2\xbf\x40\x48\xcc\x4f"
          "\x39\xb0\xf9\x0d\xb8\xdb\xd6\x3b\xea\xe4\x98\x2b\x4a\xdd\x7e\xf7\xaa\x75\xa4\x9f\x71\x77"
          "\xe4\x64\xc8\x69\x32\xc9\x44\xc3\x2c\x23\x94\x07\xa7\xd8\xd5\x0c\x4d\x01\x27\xf1\xa6\xfa"
          "\x7c\x7c\x75\x3d\x90\xab\xb9\xc7\x1f\xd1\x18\x27\xd7\x3c\x8b\x4e\xb3\x29\x74\xeb\x49\xe8"
          "\xa0\x9f\x8d\x21\xd4\xea\xc7\xc5\x52\xdf\x82\xf9\xc9\x4e\x89\xdf\x0e\xa8\x20\x9f\xab\x88"
          "\x4f\x4e\x7b\x3b\xf0\x7b\x8d\x0e\x7d\x3c\x5e\x64\x3f\x08\x19\xba\x32\xfc\x85\x77\xf1\x99"
          "\xcc\x9e\x97\xbc\xe3\x3f\x61\xa1\xc9\x3d\x0b\xeb\x65\x5d\x14\xb2\x90\xd5\x38\xcc\x6b\xdd"
          "\x2b\x3a\xa0\xe7\x17\x9c\xf8\xd7\xaa\xe5\x1a\xa6\x36\x87\xc2\xb8\xb5\xe2\x11\xc2\x9b\xd2"
          "\x71\x17\xb5\xf5\x4b\xb2\x77\x5d\xc8\x73\x5b\xc0\xeb\x11\x1b\x0f\x2c\xfc\x74\xa0\x1a\xb8"
          "\xd4\xe1\xe9\x4a\xcd\x9f\x46\xf5\x7b\x22\x78\xb9\xe0\x6e\xa7\xd8\x8a\xc4\x3e\x58\x9a\x7a"
          "\x13\xf1\xc6\x72\x0b\xfd\x82\x04\x8d\x5f\x85\x6d\x23\xbc\xf9\xfa\x60\x4a\x77\x44\xdd\xf2"
          "\x13\xb6\xe3\xf2\x51\xe2\xfa\x91\x09\x98\x78\xfe\x0a\xa9\x54\xf2\x42\xa0\x40\x7f\xab\x0c"
          "\xe2\xe2\x73\xaf\x46\xb9\xdf\xd6\xa9\xb2\x22\xe5\x29\x43\x7e\xa7\xa3\x6b\xc2\x40\x43\x1f"
          "\xee\x4c\x50\x71\xf9\x86\x10\xc9\xb3\x2d\x83\xf9",
          1, 2560 },
        { 128, 192, 52,
          "\x22\x62\x6b\xe7\x14\xf7\x79\x6a\x12\xbe\x5c\xbd\xf9\xcb\xcc\xbc\x3b\x6e\xe2\xc9\x91\x13"
          "\x5c\xf7",
          "\x97\x28\x62\xa0\xc6\xf0\x4c\x60\x96\x35\xe5\xb5\x1a\x2b\x1e\x3c",
          "\x63\xe0\xc7\x1d\x65\x83\x1a\xf6\xf2\x43\xdd\xc0\x31\xa5\xa4\x09\x3b\x51\x86\x26\xc4\x15"
          "\x2e\x59\xcb\xfe\xb4\x76\xb6\xea\x28\x54\x49\xcc\x56\xca\xc6\x64\xe8\x17\x56\x7a\xbd\xcf"
          "\x78\xa7\x4d\x5c\x14\x52\x5e\x50\x6f\x0c\x30\xf4\xcb\xc3\x6a\x80\xf5\x80\x6b\x01\xd1\xeb"
          "\x5a\xa1\x47\xf7\x59\x02\xc2\x17\x64\xd4\xf0\x29\x78\x2a\x1a\x4d\x23\x0f\x44\x5d\x74\x96"
          "\xa6\x1b\x8b\xb9\x9c\x1d\xd7\xf2\x81\x9a\x76\x5d\xc4\xf3\x08\x24\xe7\xc7\x59\xdd\x4c\x42"
          "\xfa\xf1\x6d\xd2\x57\xbd\x14\x12\xd5\xdf\x75\x41\xb6\xcd\x63\x16\xf5\x1a\xcc\xf1\x76\xd2"
          "\x05\xf1\xa3\x17\xb9\xde\x7b\x43\x8b\xcd\x54\xe9\xb7\x7d\x48\xba\x7b\xa8\xff\xa7\xe5\xf3"
          "\xd2\xe0\x09\x56\x1e\x89\x47\x4a\xb2\x21\xb2\xd6\xea\xb5\xdf\x1d\x1f\x78\x56\x80\x57\xc3"
          "\x49\x05\x56\xdf\x2b\x10\x9f\xf4\xd7\x0d\x19\x30\x7a\xfe\x0e\x85\x46\x71\x0a\xee\xe8\x7b"
          "\x3b\x0c\xa3\xc2\x06\xde\x75\x8a\xea\x0c\x00\x64\xd9\x88\xe0\x9f\x55\x16\x79\x2d\xf4\x85"
          "\x8c\xa5\x3e\x9b\x5d\x03\x4c\x13\xa3\xbd\x62\xf2\xff\x03\xde\xf4\x48\xeb\x74\x53\xf9\xdf"
          "\xa0\x7e\xa0\xf3\xfb\x50\x2f\x0e\x60\xe9\xee\x37\xea\x72\xb3\x1a\x74\xb9\xde\xb5\x57\xc2"
          "\x2b\x6c\x8a\x9c\xe3\xa2\x9f\xe1\x39\xf5\x6f\x79\x5a\x52\x4f\x7f\x1a\x8b\x3f\x40\xaa\x8d"
          "\x9f\x14\x10\x02\x77\x8d\x04\x91\xb0\x90\x8d\xcb\x6c\x8d\xfa\x59\x89\x71\xa3\x77\xd1\xc1"
          "\x58\x2d\xff\xef\xcc\x73\x8b\x4a\xca\x65\x66\xae\x5a\x48\xbb\x48\x87\x92\x28\x21\x82\xbc"
          "\xeb\x91\x42\xd0\x0a\x12",
          "\x1d\xea\x15\x24\xb0\xce\xa2\xad\xfd\x0b\x3b\x01\x09\x51\x8b\xfb\x44\x08\xe5\x06\x70\x72"
          "\x5c\x8f\x55\x18\x85\xc0\x62\xb7\x55\x20\x39\x98\x9f\xc7\x5e\xdf\x96\xaa\x6b\xfd\x99\xb3"
          "\xb7\x03\x9f\x46\xf8\x60\x86\xc1\xea\xaf\xef\x15\xd8\xcd\x11\x7a\xed\xed\x93\xe8\xdc\x88"
          "\x7b\x1f\x00\x40\xf5\xff\x27\x5f\x75\x4c\x6e\x62\x37\x1e\x7a\xdb\x6a\xec\x9e\x81\xbb\x9e"
          "\x3d\x08\xc5\xd0\xe7\x23\x14\x18\x88\xd3\x38\xa2\x49\x0e\xd2\xfb\x24\x0c\x7e\xd9\xa9\xdc"
          "\x6d\x8d\xaf\x9d\x48\x47\x17\xe4\x37\x4e\x7b\x55\xc7\xc5\x5b\x3c\x03\x99\x9f\x1a\xcd\xca"
          "\x43\x70\x47\x41\x75\x89\xf4\x38\x27\x5b\xfd\x3d\x46\xb7\xb9\x0c\xce\x57\x4c\xe5\x40\x09"
          "\xfb\x39\x2b\x5d\x66\xbc\xec\x6d\x3b\x52\xf5\x3f\x8e\x45\x46\x91\x5c\xc4\x30\x30\x0e\xdb"
          "\x83\xcd\x24\x20\xcd\xb3\x3a\x30\x14\x24\xc0\x43\x31\x11\x4f\xc4\x0a\x5d\xe0\x83\x32\xf2"
          "\xe4\xd7\x7f\xdf\x9a\x1c\x28\x41\x4b\xc0\xa6\xc9\xe0\x17\x4e\x5c\x4e\x8c\x2c\x48\x5c\x3b"
          "\x73\x8c\x66\x58\xd5\x0e\xf5\x23\xab\xe8\x36\x47\xce\xcb\x12\x5e\xab\x2b\xe5\x70\xac\x03"
          "\x0d\x06\x32\x6e\x4e\x6d\xdd\xb1\xfd\xf2\x61\x40\xc1\xa1\x58\x8b\x44\x01\x7d\x91\xae\xe3"
          "\x13\xcf\xa0\xcb\x7d\x8d\x91\x05\xea\xcd\xd9\x4b\xe2\xd2\xba\xa2\x72\x72\xa3\x5d\x2c\xd7"
          "\xba\x2e\x3e\xba\x89\x23\xfc\x28\x30\x32\xbf\x7c\x1d\x77\x91\xdc\x51\xd8\xe5\x02\x2c\x42"
          "\x07\x69\xe5\xac\x69\x0f\x04\xe4\xd9\x0c\xd7\xbf\xdb\x58\x59\x0c\x41\x9f\xf2\xd7\x2f\xa2"
          "\x46\xcf\xbd\xbe\x13\x08",
          1, 2688 },
        { 128, 192, 53,
          "\xbc\x1a\x18\xe8\x20\x9e\x98\x0a\x04\x99\xb5\xae\x7a\x10\x51\x20\xe6\xc5\x46\x87\xa5\x66"
          "\x76\xbf",
          "\xfb\x93\x85\xe6\x0f\x69\x9c\x20\xda\xb9\x33\x87\xf7\xed\x3f\xeb",
          "\x64\x8f\x04\xec\xa9\x6a\x6c\xeb\xf6\x31\x64\x4d\x3d\xf2\x0b\x7a\xd9\x23\x05\xf9\x3f\x93"
          "\x1d\xe1\xf2\xe9\xc1\x6b\x09\x5a\xab\x45\x7a\xa6\xf4\x30\x2c\x1d\xab\x1a\x94\xc3\xa2\xd1"
          "\x46\xf2\x4a\x80\xa7\x98\x84\xa6\x9d\x4c\xb2\x03\x55\x2d\x8f\xca\x1e\x2d\xcb\x2b\x65\x36"
          "\xee\x23\x11\xb4\xfa\x0d\x92\x8c\x21\xe7\x36\xd0\x2e\x22\x01\xf0\x67\x66\x94\x35\xd3\xc1"
          "\x48\x1b\x7a\xce\x96\x81\x33\x60\xa7\xb2\x46\xd8\x99\x6f\xed\xb8\xbb\x99\x8b\xee\x64\x18"
          "\x0a\xc8\xb8\x43\xe8\xdd\x68\xf1\x0c\xc1\x9a\x68\x09\x5e\x85\x07\xfe\x14\x50\xfd\xe9\x0a"
          "\xc0\x05\x5e\xe7\x5f\xd4\x6d\xc4\x7d\xc7\x46\x46\xea\xa8\xf2\xfc\xcb\xc1\x29\xec\x23\xad"
          "\x98\x98\x83\x69\x7f\x69\x27\x95\x89\xfd\xd7\x59\xac\xf4\x21\x8e\x03\xf3\xeb\xce\x2b\x4d"
          "\x70\xd3\xa4\xa1\x13\x3e\x59\xb2\x9e\xe5\x61\xfd\xa4\x34\x92\xea\x79\x1d\x04\x6f\xaa\xd0"
          "\x02\xcd\x77\x27\x89\x23\x97\x18\xfc\xa4\xf7\x25\x5f\x5f\x59\x0d\x50\x28\xbb\x42\x66\x43"
          "\xcb\xb5\x4a\x94\x38\x16\x84\x95\x00\x6f\x75\xde\x19\x80\xb2\xaa\xf4\xba\x15\x43\x53\xb8"
          "\x0c\x77\xfa\xfb\x1b\x2b\xc6\x3e\x4c\x9d\xf1\x4a\x84\xd1\xda\x18\x7b\xd6\x52\xe6\x78\x0d"
          "\x7c\x7c\x36\xbd\x59\xc2\x82\xf4\x85\x0d\xf5\x5f\xc4\x47\x4b\x3e\x37\x15\x4f\xfa\x7a\x61"
          "\x9a\x5e\x93\x99\x62\x18\x15\x7c\xf4\xbe\x19\x51\x70\xdf\x59\x13\xcd\xbd\x64\x6f\xee\xd5"
          "\x46\xc5\xb5\x1f\x08\xfe\x2e\x45\xa0\xb1\x79\xba\x19\xe2\xcc\x4b\x39\xbd\x1c\x8d\x53\xa1"
          "\xa6\xa8\xc7\x79\x50\x7e\x68\x53\xa4\xa8\x4d\x29\xa8\xc3\x81\x0b\x72\x22\xff\xf1\xf8"
          "\x13",
          "\x56\x17\x38\xa3\x7d\x5a\x3d\x9d\x69\xe4\xa8\x79\x47\xd9\x67\x77\xe1\x70\x20\xfd\xe2\x65"
          "\x02\xc3\x84\x81\x5f\x6f\xcf\x8b\x59\xf5\x7f\xd8\xe1\x8a\x09\xd7\x6d\x15\x12\xe4\x38\x3c"
          "\x86\x7a\xf8\x31\xc4\x6c\xcf\x34\x56\x15\xf7\xc7\xfe\x42\x5b\x48\xd3\x89\xa2\x07\xe3\x1a"
          "\x71\x3d\x2e\xc6\xbf\xa2\xea\xde\x12\x30\x9f\x71\xd6\x4f\xc8\x38\x92\xd1\x08\x16\x4c\x94"
          "\x5c\xd0\x07\xd2\x5f\x3b\x30\x52\x4f\xf9\x78\x29\x26\x47\x77\xb0\xa9\xb5\xaf\xee\xa6\x9e"
          "\x25\x56\xee\xa9\xe4\x97\xb4\xfb\x4b\xe1\xd2\x0c\xaa\xed\x16\x05\x9a\xed\x1a\xc6\x9a\x41"
          "\x0f\xf5\xf5\x70\x7d\xde\x90\x87\x9a\x37\x67\x81\x6a\xa3\x32\x9c\xce\x12\x1f\xa6\xac\x5d"
          "\xcb\xf7\x1c\x97\x08\x6a\x00\xe4\x73\x6c\x26\x95\x35\xf3\x1b\x03\x09\xf1\x94\xa7\x28\xc0"
          "\x8c\xf4\x79\xb7\x5c\xcc\x5f\xbb\xfc\x43\x94\xe4\x1e\x02\x9e\xfb\xc2\x04\xd1\xda\xe5\x7d"
          "\x66\xfd\xfd\x30\x32\xa4\x20\x08\xe3\x34\xd0\x57\xd6\x29\xfc\x84\xd5\xb1\x70\xdf\x39\xa2"
          "\xf2\xd4\x4a\x00\x64\x62\xab\xdb\xcc\x8c\xc7\x2a\x43\xa7\x77\xba\xfe\x11\xcb\xc2\xbf\x2a"
          "\xde\xdb\x05\x23\x48\x16\x73\x3f\xf7\x04\x14\x1b\xeb\xa4\xd0\xc7\x09\x7c\xfb\x02\xc0\xac"
          "\x76\x78\x04\x31\x02\xc1\x04\x76\xdd\x11\x97\x24\xbc\x17\x55\xd1\x27\x15\x56\x1b\xb4\x46"
          "\x17\x79\x6a\xd9\xcf\x6d\xb2\x5a\xff\x8e\xa9\x9e\x56\x4c\x48\xfc\xd6\x2c\xd4\xbb\x81\x51"
          "\xe5\xe6\x51\xef\xca\x20\x9e\xb5\xdd\xff\xc3\xf6\xa1\xd8\x7a\xeb\xf4\x78\xae\x01\x3a\x80"
          "\xb1\x64\xed\x73\x00\x39\xf9\xf3\x0a\xee\x42\x8d\xab\xe2\xe6\xc5\xea\x58\x3f\x1e\xd8"
          "\x90",
          1, 2816 },
        { 128, 192, 54,
          "\x06\x68\x96\x96\x6f\xd1\x8c\x90\x19\x26\x1d\x28\xd3\x53\xa8\xf4\x2b\x8f\xd9\x1e\x20\x49"
          "\x91\x5e",
          "\x63\x75\xa0\x91\x0f\x52\xbf\x65\xde\x11\xac\xcd\x85\xad\x10\x9c",
          "\x3d\x42\xd9\xd6\x6e\xe8\xdd\x56\x66\xdb\xc8\xc3\x56\xb4\x54\x1c\xab\xbc\x2a\x04\x78\x09"
          "\x72\xd9\x96\x8b\xff\x4f\x90\x00\xf4\x7c\x35\x95\xf2\xef\x1d\x7e\x10\xaf\xac\x3a\xa1\xa4"
          "\x12\xc3\x3f\x9e\xc9\x20\xbd\x3e\x63\x2e\x0e\xb5\x8f\x1d\xb9\xa5\x4d\x29\xb7\x90\x6a\x47"
          "\x67\xaa\x8f\x7f\x71\x7d\x88\xd5\x0d\x9d\x37\x5c\x6c\xb1\x65\x76\x17\x3d\x2d\x85\xfd\x57"
          "\xbe\x58\x30\xbd\x60\x74\xe3\x4b\xf8\x01\x31\xb8\x32\xb7\xd0\x88\xf6\x24\x71\x4a\x10\xff"
          "\x3a\xfc\x64\x6e\xe4\x5f\x7d\x1e\xee\xd9\x47\x31\x0e\x62\x5b\xa5\x05\x62\x2d\x57\xb7\x7a"
          "\x06\x15\xf0\xf5\x19\x49\xb0\x57\x14\xe9\x7b\xab\x35\x20\x88\x8e\x90\x47\x27\x78\x25\x57"
          "\xae\x0a\xfd\x9c\xd9\x36\x1e\x1d\xc7\x73\xb0\xe5\xca\x56\x4c\x82\x9d\x4b\xdb\xa5\xcb\x1f"
          "\x99\x3b\x77\x11\xd6\xef\x33\x0a\x2a\x23\xa5\xac\xf6\xce\xd8\xee\x6d\x00\x77\xe4\x9a\xcc"
          "\x44\xa4\x69\x4a\xdb\xa4\xb1\xdf\x7d\xb0\x3c\xe4\x83\x84\x7a\x0c\x8c\x91\x28\x24\x89\x39"
          "\x2f\x84\x5f\xc8\x91\x4c\xfb\x86\x49\x4a\x71\x0f\x83\x8f\x44\xc3\x96\x23\x22\x13\x8d\xc5"
          "\x3f\x89\x9a\xf4\x98\x69\xf7\x26\xcb\x4b\x50\x57\xea\x91\x42\xe0\xd2\xb9\xb1\x0c\x6d\x6a"
          "\x5a\x31\xc5\x16\x5d\xea\xf3\x8c\xca\xf2\x00\x34\x90\x99\x55\x5b\x7d\x19\xa2\x6b\x0a\xc4"
          "\x98\x03\xac\x5b\x3e\x12\xc1\xc4\xc8\x37\x01\x92\xc2\x05\xdb\xb0\xd5\x0e\x58\x5f\x6c\xc5"
          "\xc2\x16\xce\x2a\x05\xba\xa0\xe8\x7f\x6a\xd5\xc5\x8c\x0a\xf9\x72\x91\x79\xae\xfc\xd6\x3d"
          "\x85\x40\x81\x39\x80\x63\x0e\xe6\xaf\x2b\xa6\xcb\x94\xa5\x8c\x25\xc5\xca\x79\xa2\xaa\xa8"
          "\xd9\x58\xe0\x46\x74\xfa\xc8\x9e\xa2\x25\x42\x77\xaa\xeb\x29\xdf",
          "\xe9\x59\x53\xcb\xd6\x3c\xce\x46\x32\xaf\x32\x0c\x58\x58\x91\xd0\x48\x70\xc4\xff\x23\x5b"
          "\x4a\x6f\x5d\x1a\x80\xa2\xf4\xc8\x99\xa6\x6f\xbf\x65\x63\x97\x27\x2a\x45\x60\x70\xaf\xf8"
          "\x48\xfb\x7d\xd7\x85\x8b\x09\xa1\xd1\xe4\x9b\x07\x06\xd0\xa0\x18\x0b\x30\x4e\xf2\x42\x27"
          "\x88\xe8\x3c\x6a\x91\xbf\xcd\xda\xc6\x98\xa6\x28\x33\xc4\x93\xe3\x4e\xdc\xea\x26\xa0\x4c"
          "\x74\xfd\xea\x74\x78\x46\xfe\xb7\xd1\x69\x44\x87\x6a\xfa\x52\xa0\x4f\x35\x07\x97\x1d\x11"
          "\xb7\x31\x0b\x2c\x33\xa2\x93\x28\xfa\x97\xa6\xde\x06\x5b\xe0\xcf\x11\xb1\x64\x0b\x41\x49"
          "\x5d\xb9\x81\x0e\x3c\xbd\xf7\xd8\xfd\x1b\xd3\x82\xd3\x56\x51\x53\x21\x76\xeb\x5d\xfb\xfa"
          "\xc5\x58\xb2\x27\x0e\x52\x35\xc6\xfe\x0c\x62\x92\xd2\x8e\x75\x84\x7e\x0c\xd9\x89\xef\x78"
          "\x2f\x4b\xd4\x69\xdd\x79\x1c\x18\x15\xfa\x76\x5c\x5b\x03\x9b\x2c\x3f\x15\xd2\xd4\xc2\x9a"
          "\x3e\x68\xda\xcc\x12\x2e\xff\x4e\x7f\x49\x12\x17\x42\x6b\x8c\x51\xe0\x4c\xc9\xa9\xae\x98"
          "\xe1\x31\x9a\xc9\xb9\xe5\x8c\xb0\x5e\x77\x17\x45\x25\x39\x1a\xdc\x6e\x5f\x3f\x7a\xdd\xcb"
          "\x50\x32\xbf\xa0\xc1\x0c\xc9\x33\x34\x02\xe2\xd7\x38\x60\x10\x39\x0c\xb3\x2a\x66\x5e\x0c"
          "\x16\x33\xb3\x25\x99\xaa\x3e\x93\xdc\x60\x2f\xc3\x40\x80\xa4\xd2\xc9\x20\x77\x05\x27\x61"
          "\xe4\xbc\x30\xf2\x5d\x14\xa2\x9c\xda\x4b\x6c\xd1\xc4\x5c\x31\xc9\x0f\xa7\xe0\x4f\x72\x9b"
          "\x28\x02\x86\x27\xc7\xce\xa4\x50\xc1\xd9\x41\xcd\xd7\x60\xa8\x65\xa2\x17\xa6\xf2\x0f\x49"
          "\x75\x86\x83\xd2\x03\xaf\x2d\x0a\x21\xff\x0d\x1a\x3a\x72\xc8\xf4\x4d\x0c\xfb\x3a\x89\x6f"
          "\x3e\xb1\xbd\x73\x1c\xd0\x46\xcb\xcd\xa1\x51\x01\x3d\x63\x13\x6c",
          1, 2944 },
        { 128, 192, 55,
          "\xeb\x9d\x9a\x6d\x9a\xc6\x90\x10\x93\x2b\xdb\xa3\x56\xb0\x9e\x26\xe9\xbd\xaa\xd1\xe6\x51"
          "\x5f\x76",
          "\xc9\xbb\xda\xee\xbf\x00\x81\x48\x36\x0e\x2b\x6a\x36\xe3\xb7\x56",
          "\x56\xb5\x4b\x67\xcc\x52\x8f\x56\x97\x6b\xef\x8c\x4a\xda\x89\xe7\x26\x9f\x2b\x75\x99\xc2"
          "\x0e\xb5\x8d\x2e\xdb\xcc\x70\xb7\xb2\x87\x16\x7b\xf1\x14\x3d\x7a\x2f\x80\xab\x0c\xce\x13"
          "\x21\xee\x19\x71\x96\x84\x26\x4d\x8a\x40\xeb\x8e\xdc\xd3\x5e\x99\x5e\xac\x50\x1f\xcd\x33"
          "\xee\x09\x21\xb0\xbc\x79\x22\xd6\x4b\xf0\x39\xfc\x2e\x04\xad\x2b\xbb\x1c\x8b\xeb\xbd\x90"
          "\x91\xf2\x00\x14\x65\x0a\x59\xef\x7b\xe6\x47\x24\xfa\xf2\xff\xb0\xb3\x41\xb2\x25\x7b\x8f"
          "\x1a\x01\x88\xb0\xac\xa5\xfa\x67\x3c\xdb\x44\xa3\x10\x39\xd6\xd8\xd5\x06\xd7\x9b\x1e\x27"
          "\x44\x9c\x39\xe2\x98\x8a\x05\x4d\x90\x96\x9e\xcd\xee\x66\xbe\x2c\x2f\x54\x37\x47\x4c\x1f"
          "\x26\x4a\x20\x52\x41\xc6\x8a\x79\xc7\x2b\xc8\x5b\x90\x46\x2d\x91\x1d\x66\xab\x64\xde\x59"
          "\xd7\xa4\xac\x20\x1f\x69\x57\xd8\xed\x5b\xef\x11\x79\x06\x6a\xc2\x04\x87\xd9\x98\x0d\xf6"
          "\xc9\x06\x7d\x79\x85\x05\x35\xe4\xd5\x81\xd0\x05\x94\x39\xed\x38\xbd\x97\x2a\xae\xed\xd4"
          "\xe0\xf8\xa7\xc8\xa0\xb3\x96\x75\xe8\xca\x4d\xb4\x5e\x5d\xf8\x49\x77\x95\xab\x35\xbb\x68"
          "\x32\x1d\x75\x40\x3d\x6c\x63\x96\x88\xe2\x1b\xf6\x7e\x97\x98\x64\x4e\x71\x5b\xbf\xe7\xbb"
          "\x49\x21\xba\x65\x96\xb8\x00\x09\xe2\xaf\x65\xb0\xd8\x99\x2b\x92\x5c\x8f\x89\x76\xa3\xae"
          "\xde\x9e\xbd\x73\xd7\x08\x3e\xe5\xcd\xb5\xb7\xb1\x6a\x0f\x86\x61\x83\x7c\x78\x40\x5a\x4c"
          "\xb6\x8f\x3d\x0b\x9e\xf2\x6c\x30\x5c\x86\x0b\x1f\x6e\xb7\x13\xfb\x55\xfc\x29\x9a\xb3\xc1"
          "\xbe\x24\xb7\xbd\xe5\x91\x36\x8a\x63\xfa\xcd\x19\xc0\x9b\x89\x42\xd5\x4b\x63\x69\x72\x10"
          "\x89\x85\x90\x1d\x34\x32\xa8\x60\x81\xd3\x68\xc2\x17\x85\xf8\xd4\x41\x92\x46\x2b\xe4\xd9"
          "\xa0\x28\xbd\x4f\x0b\xad\x5c\x6b\xf3\x48",
          "\x10\xbb\xc2\xca\xfb\xaf\x74\x50\xcf\x4a\x48\xe2\x69\x97\x43\xef\xc0\x59\x61\xe2\xc1\xb4"
          "\x75\x07\xa9\xd9\x09\x94\x98\x90\x2d\x70\x12\xbc\xa4\x31\x4e\xce\xa5\xae\x6f\x3d\xb7\xdc"
          "\x5f\xb1\xdf\x90\x98\xe0\x0a\x42\x28\x1e\x22\x15\x83\xe2\xe0\xe9\xc9\x13\x5c\x68\xed\x21"
          "\xbb\x83\x1a\xc8\xd5\xee\x55\x87\x6e\x2c\x62\x40\x3a\x09\xe4\xf8\xca\xc7\x1a\x68\x3e\x87"
          "\x38\x50\x96\xd2\x85\x9f\xce\xa2\xe2\x2e\xb0\xf1\x0e\xc9\x7a\xbd\x5b\x55\x4c\x0c\xa1\x58"
          "\x11\x5c\x18\x8b\xc3\x9b\x92\x08\x8a\x57\x88\x38\xe8\xfa\x0b\x23\xe3\x7e\x85\xc8\xff\xd3"
          "\x13\x71\x30\x3b\x9a\x59\x2d\x54\x3a\xae\x4e\x29\xb5\x1f\x5a\x30\x87\x44\x54\xf3\xfc\x91"
          "\x46\xef\x83\x8b\x94\xf4\x0b\x1b\x5e\x43\xbd\x15\x71\x60\xad\x71\x3d\x01\x1f\x7e\xe3\x5c"
          "\x6c\xd4\x4d\xd7\x3b\x07\xea\x3b\x38\x9d\x11\x72\x27\xd4\xe0\x27\xf5\xbd\x3f\xac\x17\x4b"
          "\xd4\xf2\xee\xaa\xfd\x7d\xdf\x09\xc6\x48\x93\x0c\xaa\xa0\x79\xc8\xb5\x9e\x1c\x2c\x8b\x27"
          "\xff\xb7\x77\xbf\xe2\xf1\x5c\x31\x18\x11\x72\xd8\x5e\xa0\x75\xce\xc5\x02\x67\x3d\x89\x7d"
          "\x78\x35\xe1\xf2\x9b\x3a\x97\xab\x26\xc9\xdc\xe8\x94\x0c\x96\xe8\x43\xdf\xd1\x5a\xce\x1b"
          "\x17\xe2\xfa\x44\x01\x81\x56\x72\xec\x9e\x30\x90\x97\x54\x1a\x6b\xae\x0f\x41\xa1\x5d\x76"
          "\xa6\xca\x95\x17\xcb\xe8\x1c\x44\x51\xb8\x7d\x3a\xb5\x47\x3a\xd2\x85\x72\x7f\x80\x49\xd9"
          "\xac\xe3\x77\xef\x31\xb0\x77\xb6\x46\x58\xff\x87\xc6\x0f\x7b\x5b\xad\x99\xf3\x63\xb0\x49"
          "\xfd\xf0\x4b\x54\x27\x59\xe7\xae\xac\x4e\x14\x6f\x22\x3b\xf0\x16\x41\x57\x0a\x2c\x4c\x5c"
          "\xe7\xad\x08\x5c\xb4\xa1\x32\x29\xd3\xea\x55\xb1\xf6\x04\x52\xb8\x5a\xd5\x86\x98\x91\xef"
          "\xc4\x33\x9c\xe3\xa0\x9e\x06\x06\x2b\x6d",
          1, 3072 },
        { 128, 192, 56,
          "\x77\x76\x32\xdf\xcf\xb2\xbd\xa8\xd3\xc0\x81\xfe\x12\xba\x48\x39\x72\x02\x90\x91\xb3\xb6"
          "\xcb\x9c",
          "\x3c\xc1\x69\x56\x41\xb8\x1b\x3c\x22\xec\xa1\x63\xa7\x01\x77\x22",
          "\x45\xcf\xce\x57\xe2\x6d\x96\x56\x46\x28\xaf\x55\xea\x83\x5a\x79\xac\xf8\xb9\xa6\xdf\x14"
          "\x3e\xe4\x5e\x4c\x74\xe4\x34\x1c\x9b\xbb\x97\x0e\x40\x8a\x0e\xfa\x58\x24\x96\x4e\xc6\x1b"
          "\x7e\xec\x3f\x2e\xb9\xbc\xad\x71\x2d\xe2\x4b\xdc\x55\x7f\x6c\xc2\x90\xc1\x37\x60\x36\x4b"
          "\xd5\x7c\xc8\x4d\x05\xba\x00\x29\x33\x3c\xb4\x33\x65\x44\x6a\x01\x02\x56\xc7\x47\x33\x93"
          "\x34\xf0\xa7\xb0\x13\x5d\x3b\xc6\x16\x4f\x9a\xe2\x05\x1b\x47\xb6\x12\xa3\xec\x08\xa4\x66"
          "\xf2\x2c\x45\x3c\x02\x0d\x0e\xd8\x2d\xb9\x84\x6b\x4f\x34\x65\x92\xab\x37\x48\xb1\xac\x81"
          "\x17\x12\x22\xfe\x75\x62\xec\x11\x1b\xfa\xaa\xa7\x2d\x40\xfe\x8e\x4a\xdc\x88\x5b\x9a\x56"
          "\xa0\xea\x5a\xa0\xec\x48\x30\x15\x7b\xe3\x89\x29\xe6\x0c\x7a\x74\xe6\xe6\x5a\xdf\x21\x06"
          "\xe9\xe9\x74\x0a\xf7\xbf\x0a\x80\x40\x7f\x40\x40\x36\x80\x9b\xfc\xaf\xae\xe2\x5f\xc7\x2a"
          "\x35\x29\xe8\x21\x21\x40\x2c\x9a\x1c\x6f\x44\x52\x18\x82\x4a\x84\x70\x94\xd0\x3c\xd3\x55"
          "\xea\xc3\x3d\x55\x7b\xed\x20\xd2\xfc\x29\xe4\x4f\xa4\xfa\x49\x85\xe7\xb0\xb4\x6e\x6f\x3e"
          "\xbf\x99\x55\x79\xdf\x8f\x31\x33\x53\xc5\x3f\xfd\x5e\x01\x7f\x37\xc5\xee\x27\xad\xcf\x4f"
          "\x83\x07\xac\xac\xb2\x5c\x21\x9d\xaf\x95\xb2\x51\x49\x3e\x97\x5f\xf3\x6a\x6b\xbd\xc8\xf7"
          "\xec\x76\xd9\x0d\xfb\x75\x3b\xeb\x81\x6f\xb8\x65\x6a\xdc\xce\x40\x13\x0a\x37\x7c\x7b\xaf"
          "\xc7\xa6\x0d\x8f\xe6\x1d\xae\x68\xcc\x36\xf9\x28\x5b\xb0\xc1\xbe\x9f\x93\x3c\x8d\x22\x6c"
          "\x0b\x4a\xf2\x66\xd3\x2b\xce\x3a\x54\x8e\x67\x3d\x43\x91\x15\xae\x68\x6b\x9b\x11\xcd\x46"
          "\xcb\x28\xce\xdd\x30\x17\x48\x13\x78\x6e\xd3\xed\x29\x59\x3a\xe2\x96\xec\xa1\x21\xa5\x5e"
          "\xbe\x57\xbd\x7c\x9b\xd9\x96\xe9\x36\x31\xa0\xe5\x1a\xdb\xe6\x9b\xa4\x88\x00\xf2\x3f\x8c"
          "\xfc\x05\x86\xc7",
          "\x40\x4a\x14\xfd\x40\x3c\xd4\x0a\xaa\xf0\xfc\x7b\x52\xf7\x68\x48\x23\xca\x4d\x70\xf4\xee"
          "\x42\x3b\xe0\xc3\x28\x5b\x7d\x8b\xe7\x6b\x42\xda\xe3\x2f\x56\x81\xf6\x23\x59\x2e\x13\x75"
          "\x7a\x1b\x4a\xfe\xa4\x1b\x78\x1a\xb8\x89\xc1\xc8\xf1\xc3\x55\xa8\x0c\x76\x68\x10\xcb\x49"
          "\x96\x7e\x72\x6c\x8a\xc2\x11\xa2\xc2\x1d\x7c\x2d\x84\x61\x9e\x14\x91\xd7\x70\x59\xc9\xce"
          "\xfb\x04\xa4\xb0\x6a\xff\x9a\x01\x69\xdf\x4a\x66\xfb\x01\x4e\xaa\x42\xa0\xa9\x4b\xe0\xa2"
          "\x17\x7d\x7e\x64\xdb\x97\xf3\x65\x00\x6f\xa5\xac\xad\x33\x41\x04\xd6\x36\x99\xb5\xa5\x5f"
          "\xb3\x19\xb0\x6a\x25\x45\x1d\xa3\x9e\x45\x55\xd7\x3d\xd3\x7b\x7d\xfa\x64\xb5\xb4\x3d\xc7"
          "\xf7\x70\x46\x2c\x03\xf0\x06\x31\x92\xbf\x44\x62\x8a\x10\xb0\xa4\x3d\x32\x17\xab\x1e\x3b"
          "\x3d\x32\x70\x55\xfc\xc6\x3d\x85\xf1\xaa\x76\x83\xf4\xa3\x3e\x1c\x4b\x27\x15\x47\x30\x51"
          "\x4e\x8c\x22\x76\x45\xfc\xe6\x79\x60\x86\x82\x4f\x23\xd9\x1f\x92\x80\xf0\x48\x3c\x67\x23"
          "\x18\xcf\x4c\x62\x4a\xb3\x75\xc8\x1c\x56\x4a\xcf\x8f\x15\x07\xd1\xa3\x1f\x4b\xa3\xee\x2a"
          "\x30\x2d\x37\xf9\x66\xb5\x9a\x0a\x0f\xaf\x20\xa2\x00\xa8\xc4\x2e\x1f\x43\x86\xe2\x55\xfc"
          "\xc3\xfe\xde\x8d\x42\xc2\x6f\x5a\x3e\x9d\xc6\xb0\xbd\x3a\xaa\xe8\x25\x9e\x3a\x35\x45\x5d"
          "\x6c\x8d\xae\x6f\x48\xcb\x37\x18\xce\xb3\x00\x0a\x07\x16\xa4\xae\xbb\x74\xd0\xc6\x1d\xa0"
          "\x33\xc9\xea\x60\xb9\x67\x57\xb1\x95\xbc\x44\x4b\xc4\x81\x56\xf9\x27\x4e\xca\xdb\x67\x77"
          "\xa3\x93\xe1\x3c\xf0\xf9\x3f\xa1\x37\x17\x32\xbc\xf9\xe8\x47\x58\xe8\x3d\x6c\x8b\x8a\x56"
          "\x50\xa8\xc4\x41\xa8\x21\xaf\xf6\xb6\x26\xef\xb4\xd6\xd1\xca\x07\x71\x8d\xc0\xe8\x61\x65"
          "\x8c\x2a\x3c\xb6\x99\xe8\xd6\x81\x40\x4f\xde\x76\xe9\xc1\x19\xb8\x65\x3f\xec\xb8\x77\x04"
          "\xe7\x23\x84\xe3",
          1, 3200 },
        { 128, 192, 57,
          "\x7f\xf8\x25\xdc\xd0\x8e\x5a\xa7\x55\xdc\x90\x66\xcc\x11\x46\x3b\xbd\x71\xaa\x1a\x01\x91"
          "\xd8\x67",
          "\xec\x6f\x70\x6f\x00\xa5\x2e\xb7\x9f\x2c\x8d\xd4\x30\x2c\x0c\x36",
          "\x68\x5f\xe4\x03\x0d\xf7\x89\xc6\xae\xad\x03\xb7\x33\xd2\xef\x7e\xc4\x42\xb2\xe7\xee\xe2"
          "\xc3\xad\x65\x7e\xfa\x81\xe7\x2e\x7a\xce\x69\xaa\x1b\x31\x0c\xea\x8e\x0a\x20\x0b\xe7\xff"
          "\x3f\x1c\x99\x6e\x9f\x99\x87\xfb\x0c\x6b\xb2\x89\xdd\x23\x0e\xc1\x98\x45\x50\x78\x34\x22"
          "\x76\xfb\xaa\x07\x09\x86\xef\x1d\x36\x27\x89\xbe\x60\x54\x0e\x5f\x59\xfb\xf1\x63\xa2\x7d"
          "\x1f\xa4\xfc\xa0\x6a\x87\x52\x4c\x41\xad\xe5\x27\xb8\x0a\x70\x97\xf0\x68\x09\x93\xad\xe0"
          "\x39\x4a\x52\x57\x8b\xeb\xf8\x7c\xf7\x72\xf5\xfe\x2b\x85\x2a\x01\x82\xc6\xe9\x36\x45\x03"
          "\x05\x78\xb6\x53\xa5\x7b\xfb\x16\x0d\xfe\x8e\xdb\x0d\xac\x58\x95\xf2\xd9\xc8\xd3\x2d\x50"
          "\x3a\x45\xcf\x2f\xd4\x58\xb7\xa2\x53\x50\xdc\xe4\xc9\xc7\x65\xf1\xad\xa6\x78\x96\xc5\x72"
          "\xf0\x1c\xa3\xd3\xa0\xc0\xae\xd5\xc9\xc4\xfb\x5b\x8f\xbd\x8e\xd8\x97\xc9\x90\xad\x8d\xe5"
          "\x4c\x60\xd5\xe1\x3c\xc7\xb6\x77\x44\x76\x17\xca\x6c\x9b\x6a\x42\x4c\xa0\x2f\xc5\x25\xfc"
          "\x1d\xf8\x9b\x58\x52\x33\x45\x1a\x9b\x34\x15\xc2\xf4\xd6\x9a\xb5\x27\x95\x64\x2f\x55\x70"
          "\x53\x29\xb0\x4d\x02\xa1\xb1\xd2\xed\xf2\xc4\x0f\xbc\x0c\x81\xda\x3e\x8e\xc1\x96\x52\xed"
          "\x4e\x34\x2a\x89\xd1\x69\xf8\xd9\x87\x84\x6a\xd1\x73\x8d\x6a\xb0\xc4\x2a\x82\x5c\x81\xdf"
          "\x0e\x10\x53\x02\x65\x57\xa0\x49\xdb\x0f\x63\x38\x2f\x21\xcb\xc9\x9f\x4d\x4e\x3e\x10\x66"
          "\x11\x7c\x54\x9c\x78\x30\x99\x14\x89\x97\xae\xb7\xfd\xc9\x6b\xc7\xac\x22\x14\x5c\x64\x64"
          "\x3d\x60\xee\xd2\x5a\xa8\xfd\xf8\xa7\x1c\xa1\x5b\x79\xa3\xba\xc3\x6c\x8e\x8a\xdc\x63\x2a"
          "\xb1\x61\x0a\x4b\x04\x3a\x04\x84\xc8\x65\x7d\x22\x4a\x8d\x3b\xbe\x0c\x44\x25\xbd\xe1\xca"
          "\xad\x01\xf3\x69\xe4\xbd\x06\xa7\x51\x25\x26\x6a\x75\xb1\xf4\x73\xdf\x7c\x3e\xb7\x26\x2d"
          "\x01\x40\x19\x7a\x70\x66\x8b\x5f\x92\x1c\x9f\x38\x7b\x85\xd3\xba\x55\x34\xa4\x46",
          "\xfe\x4d\xae\x25\xb2\xaf\xcf\xd6\x01\x4a\xc2\x4f\x68\xc4\xd3\xec\xb3\x56\xab\xc7\x51\x9d"
          "\xc9\x5b\x20\x70\x92\x16\x67\x59\x47\xbf\xcd\xe2\x3a\x23\x7a\x10\xba\xd6\x02\x21\xcc\x98"
          "\x3f\xf3\x30\x51\xa4\x21\xfc\x75\xb9\x3b\x45\x37\xb1\x35\x43\xe4\xc9\x13\xba\x23\x6c\xaf"
          "\x12\xf8\x9d\xa8\xf4\x2d\x0a\x7e\x75\x78\x1d\x0e\xb0\x57\x5b\xc4\x81\xf9\xd0\x76\x79\xb2"
          "\x55\x1a\x11\x26\xb5\xb4\x86\xd1\x86\x18\x0d\x2b\x4d\xd0\xa1\x79\x8c\xb0\x9a\x8c\xa9\xeb"
          "\x83\xe5\xa3\x49\x37\x3b\x5d\x20\x0f\x3d\x58\xb8\xaf\xe9\xd9\x56\xa4\x2f\xe5\x44\x00\xb0"
          "\x65\x6e\xa6\x0e\x2e\x04\x56\x0c\x79\x74\xa1\xe5\xa4\x40\xba\xe9\x73\xaa\x50\x7e\x00\x30"
          "\xed\x77\x52\x42\xd5\xb7\x36\x35\x26\xca\x28\xe3\x97\x7c\x86\xaa\xf2\x87\xc0\x56\xd6\x9d"
          "\x28\xa8\x95\x5d\x84\x2c\xca\x56\x10\x18\xc5\x3c\xed\xad\x7f\xee\x21\x55\x96\x64\xc9\x0e"
          "\x9f\x6b\x2f\x41\xf9\x4a\x23\x6f\xd8\xac\x73\xd2\xd1\xb9\x42\x5c\x9e\x69\xff\x1b\xbf\xe3"
          "\x13\xdf\xc7\x3d\xe2\x41\xf9\xce\xb9\x96\x74\x6a\x7f\x1f\x42\x3f\xaa\xf7\x80\x1d\x3a\x52"
          "\xde\x70\x27\x02\xa5\x0f\x48\x4b\x8e\x74\x2f\xb7\xb2\x21\x18\x5a\x13\xc8\xa3\x34\xeb\xd1"
          "\xb9\xaa\xc3\x48\x24\xb9\x4f\x86\xef\xb3\x51\xb7\x6c\xb9\x41\xc5\xbc\x53\x1a\x01\xcc\x9e"
          "\x82\xba\x8a\x92\xd0\x5b\x76\xb0\xee\x1b\xa2\xa7\x27\xdf\xab\x30\x60\x23\x74\xe1\xc6\xc3"
          "\x97\xa0\x67\x71\xcd\x80\x98\x06\x46\x0b\xc3\x16\x73\x37\xb2\xf7\x60\xfc\xf4\x39\xd2\x98"
          "\xad\x1b\xad\x07\x62\x72\x5c\x2c\x83\x08\x46\x86\x9f\x95\x09\x13\x8d\xa5\x9f\x50\xd8\xbb"
          "\x63\x28\x82\xec\xff\xaf\x8a\x89\x70\xec\x77\xb8\x0a\x92\xbc\x42\x71\x51\x87\xc3\x76\xa3"
          "\x03\x37\xfc\x32\x1c\xf4\x7e\x20\x2e\x10\xc7\xa3\xc4\xe2\x9e\xfb\x1a\xce\x5b\xb0\x46\x19"
          "\xe9\x0c\x79\xd2\xe5\x13\x6b\xfa\xd5\x4a\xc9\x7a\x9e\x5e\xa7\xd1\x7e\x0d\xae\x72",
          1, 3328 },
        { 128, 192, 58,
          "\xff\x4c\xe5\x9a\x28\x7a\x83\x76\xd4\xcf\x7f\xff\x93\xb4\xd4\xa3\x16\x68\xa8\x9b\x0f\x48"
          "\x67\x66",
          "\xf0\x2f\x79\xa0\x9e\xe3\x17\x1f\x59\x57\x63\xf9\xd3\x5e\x50\x94",
          "\x4c\x83\x68\x9d\xfe\x8f\xe4\x61\x2e\x32\x23\xee\xb0\xfc\x2a\x49\x1a\x85\x1a\x07\x16\x7e"
          "\xd0\x06\xac\xc7\x9d\xfe\x71\xa8\x3e\x25\x17\xba\x01\x8f\x07\x00\x5a\x78\x04\x88\xd0\xd3"
          "\x1e\x65\x43\xf9\xd4\x15\xeb\x74\x09\x1b\xd6\x3f\x70\xc4\x28\xd5\xa4\x82\xb1\x9d\x13\x2c"
          "\xba\xf9\x22\x9a\x67\xa4\xb5\x00\xcc\x3f\xa1\x83\x1d\x82\xe4\xe2\x74\xca\xd7\x5d\x10\xf9"
          "\xa5\x61\xd6\x16\x95\x60\x64\xe7\xc9\xdb\x1f\xee\xa6\xe2\x07\xdc\x39\xe4\x3d\x39\x95\xf2"
          "\xfe\x11\xb3\x32\x0a\xa4\x38\x26\xbc\xc8\xb0\x81\x65\x37\x0f\x43\x7d\x3d\xd2\xe2\x94\xfa"
          "\x0d\x71\xeb\x4b\xa4\x36\xdf\x0c\x44\x77\xca\x12\x9c\xdb\x94\xd6\x29\x0b\xc8\x4d\x0a\xc3"
          "\x5d\xd1\x5b\x1d\x57\xb6\x03\xad\x6a\x8b\x51\x43\x42\x23\xf0\xd8\x1f\x65\x98\x46\xeb\x4f"
          "\xb6\xa4\x7d\x59\x91\x06\xa4\x69\xee\xa8\xd8\x25\x18\x13\xd7\xe9\x95\xc4\xf7\xfa\x46\x7f"
          "\x8d\x7b\x6d\x48\xf4\xb1\x03\x92\x3c\xe4\xa3\x33\x92\x20\xc5\xfd\xce\xef\x40\xff\x68\x71"
          "\x7c\x86\x94\xe7\x80\x59\xc1\x39\x5d\x4b\xc5\xb3\x1b\x0c\x8d\x03\x97\xd1\x70\x7d\x5b\xee"
          "\x7b\xda\x85\x5a\xd4\x8d\x0c\x43\x0c\xfa\x56\x13\x30\xb8\xd4\x3b\x56\xab\xd4\xc0\x49\x16"
          "\x37\x3d\x71\x57\xfb\x4d\x2d\x8c\x34\x6a\x90\x5c\xa7\x47\xa1\x74\x54\x01\xd5\x3c\x40\x78"
          "\xc3\x83\x61\x78\xc4\x80\x37\xe3\x45\x75\x33\x50\x98\x84\xf8\x48\x77\xe2\x45\xcb\xed\x0e"
          "\xad\x21\xce\xf6\x71\x22\x49\x05\x47\xb8\x91\xcc\x3e\x64\xcd\x5a\xa4\x33\x86\x15\xc7\x7f"
          "\x8d\xf7\x65\x21\x33\x3d\xed\xcb\x7a\x23\x88\x7a\xcf\x41\x5c\xcc\x69\xa5\xf2\xae\x97\x26"
          "\x2b\xa8\x50\x67\x0f\x78\x75\x21\xe4\xb1\x3f\xcc\x1b\x69\x1a\x39\xb9\xe7\x23\x76\x80\x5c"
          "\xf8\xcb\x25\xc4\x39\x52\x46\xd9\x38\x31\x81\x52\x87\xfb\xb1\x5c\xd0\x4b\xa7\x9c\xde\x74"
          "\x45\x6e\x5f\xe2\xf7\x13\x79\x35\x5c\xe9\x9c\x56\x2e\x86\x1b\x7d\x33\x2c\xfa\xd0\x1a\x7a"
          "\x38\x83\x3a\x56\x11\x31\xbf\xf5\x01\x9e\xfa\xb8\xe5\x11",
          "\x62\xe4\xac\x36\x47\x12\xd4\x39\x9b\xde\x6f\x6b\x20\xae\xb8\x75\xfd\x9b\x8f\x17\x4d\x01"
          "\x18\xc5\x85\x99\x2c\x64\xb8\x1a\x24\x25\x6e\xfc\x99\xe5\xed\x81\xe9\x13\x02\x4d\x85\x15"
          "\x17\x8c\xcd\x60\x00\x2a\x5e\xdd\xf6\x6e\x09\xe2\xf1\x90\xfc\xe4\x04\x16\x3f\xc4\xcd\x80"
          "\xc5\x12\x24\xea\xd4\x2f\x05\xc8\xc7\x2c\x61\xa6\x9a\x76\xa3\x44\x57\xef\x8a\x84\x43\xad"
          "\x62\xe9\x4c\x79\x36\x8c\x38\x17\x2a\x34\xb8\x81\x50\x3c\xbf\x7b\xa6\xbe\xa7\xae\x09\x3a"
          "\x0b\x4f\xd6\x90\xf7\x9a\x2f\xb4\x1d\x18\x2b\xbc\xdc\x3c\xb1\xbd\xc4\xda\x5a\xc6\xc2\xf0"
          "\x68\x49\xc8\x2b\x69\x5d\x5a\xee\xe8\xec\xcb\x77\x98\x85\xe9\x89\xc9\xab\xfd\x91\x81\x3c"
          "\xc4\x54\xf6\xf0\xa7\xf3\x4d\xda\x62\x16\x84\xfd\x6f\xc7\xb3\x83\x7b\x87\xd4\x3d\x23\xe8"
          "\x12\xbc\xb4\xb9\x12\xa7\x4a\x24\x3f\x49\x5a\xf5\x17\xde\xaf\x36\x5a\x20\xcb\x6a\xfe\x38"
          "\xee\x99\xfa\x60\x83\xcf\x68\x24\x5e\x72\x04\x5e\xc3\xca\x22\x66\x1c\x9d\x2b\xe0\x60\xd7"
          "\x65\x63\x08\x70\xe8\x3e\x50\x74\xfc\xd6\x5c\x1e\x82\x73\x63\x3d\x75\xf1\xc6\x86\x19\x92"
          "\x3c\xb1\x8e\x78\x76\x1b\xec\x00\x28\xa9\x42\x74\x85\x3a\x8c\x16\xa8\x5e\x31\x10\xc0\xd1"
          "\x27\x95\x13\x86\x2d\xac\x49\xd3\x06\x2a\xd1\xb1\x78\x1a\xf1\x35\x0a\x9d\x21\x44\x16\xab"
          "\xf2\xa7\x8e\x84\x7b\x3c\x60\xfc\x63\x08\xe5\x5e\x74\x1b\xe8\xa7\xc6\x39\x46\xfe\x5b\x30"
          "\x19\xd3\x0a\xb5\x0a\x5a\xd9\x9b\xb7\x64\xd2\xcf\xa4\xe2\xa0\x13\x36\xc8\x29\x08\xcc\x9f"
          "\x77\xd0\xb0\x16\xcd\x63\x7c\xb1\x56\x9c\x96\xb3\xff\x1b\x85\xe3\x4c\x81\xa8\x0b\xaf\x5f"
          "\x66\xbe\xae\xe1\x93\xe3\x2c\xdb\xbe\x45\xef\x1b\x0e\x58\xee\x0d\xc6\x95\xd0\x3d\x98\x00"
          "\x3b\x8a\xc7\x00\xc5\x77\x5b\x00\xe3\xec\x7b\xfc\xc7\x0b\x16\xf0\x3b\x0f\x52\x25\x7e\x2d"
          "\xee\x28\x6f\x81\xa1\xa9\xa3\xdf\x69\x90\xc9\x19\x14\xbc\x18\x7e\x41\x59\x84\xc6\xc5\x56"
          "\xcb\x70\xd7\x8f\xe9\x8c\xe9\x2d\x25\xbb\xa3\x03\xd9\xa2",
          1, 3456 },
        { 128, 192, 59,
          "\x5a\xac\x5f\xfc\x8a\xb0\x79\x0f\x18\xc2\x99\x97\x64\xe6\x14\x9e\xec\xa5\xe1\x58\x41\x0f"
          "\x65\x40",
          "\xc9\x4c\x98\xaf\x0c\x95\xac\xac\xa3\x18\x8e\x8b\x67\xb9\xa5\xa6",
          "\xc4\x34\x63\x20\xce\xc3\x10\x4b\x03\xe5\x0c\x5b\xde\xde\x46\x69\x05\x8d\x6b\x13\x43\x73"
          "\x00\xd3\x8c\xd1\xe4\x04\x08\xbb\x5f\x39\xa7\x74\xf8\x7a\x1b\x10\x0d\x5d\x84\x2e\x5f\x3f"
          "\x18\x29\xc2\x0c\xd3\x80\x71\x7e\x1e\x9c\xa1\xb7\xf5\xcf\xf8\x33\xc0\x6c\x21\x43\x70\x04"
          "\xef\x3c\xd4\xf5\x01\x1c\x97\x49\x69\x57\x39\x4d\xf3\x46\x05\xb7\x2f\xcb\x49\x54\x9f\x37"
          "\x39\xed\x5f\x73\x24\x55\xba\x48\xa9\x53\x1f\x23\x5d\x02\x53\x57\x09\xa6\x26\x7c\xbc\x0f"
          "\xb2\xfb\x6f\x34\x55\x3c\x4b\x7d\xa0\x8b\xdd\x3d\x38\x57\x98\x2f\x8c\x6b\x5b\xbb\x3a\xd7"
          "\xcd\x1d\x8a\x8a\x65\xb5\x38\x61\x0f\xab\x42\xe2\x62\x72\x52\xa1\x51\xd8\x69\xc5\x11\xee"
          "\xa2\x1c\x18\xdc\x7b\xf6\x3c\x9d\x7b\x21\xe4\x8c\x99\xc0\xec\x19\xa2\x2a\xa2\x9d\x89\x63"
          "\x86\x60\x1d\xc1\xc8\xfd\x62\x7c\x9f\x53\xde\x0b\x3c\x4e\x2f\x40\x1d\x39\x09\xd0\x3c\x97"
          "\x5e\xb5\x0e\x4f\x0d\xa7\x47\xe5\x09\x01\xff\x80\x0e\xb9\x25\x9f\xa2\x47\xfb\x23\xbd\x3d"
          "\x2f\x9b\x15\x94\x3b\x52\x30\x83\x38\x46\x35\x80\x80\x64\x86\xfb\x17\xba\x82\x3d\x0e\x5b"
          "\xce\x3f\x59\xb8\x70\xd8\x82\xf8\x84\x46\x11\xe2\x15\x8e\xf9\x6b\x99\xe1\x91\xa8\x6f\x34"
          "\x08\x35\xe6\x44\x8d\x82\x5e\xcf\x2c\xed\xe3\x56\x07\x00\xf2\x12\x2d\xb0\x27\x4c\x56\x79"
          "\x36\x7a\xc8\x72\x31\xff\xc5\xa1\xd8\xce\x00\x28\x93\x89\xc3\x3e\x63\xcd\xf5\xed\x1d\x5a"
          "\xfa\xfd\x07\x28\x04\x5c\x20\xe8\x1a\xa4\x8c\x06\x2b\x4d\x5c\xba\x3d\x42\x02\xf3\x15\xe4"
          "\xfd\xd9\x9b\x59\x51\x91\x27\x6c\x33\xae\xc5\xbe\xe4\x1a\xf1\xa6\x07\xfa\x41\x0d\x06\x1c"
          "\xbf\x0b\x61\x64\xdb\xd8\xf1\x13\x8d\xb2\xf7\xbe\xdc\x49\xd1\xc2\x5c\x8d\xfe\xae\xcc\x2f"
          "\xbe\xb4\x9c\x32\x4b\xa6\x18\x98\x45\x34\xf6\x14\x8d\xe3\x38\xe3\xc6\x07\x9e\xba\x8b\x6e"
          "\xa7\x1f\x4c\x45\x84\xbd\x81\xca\x7f\x09\x78\x53\x4a\x6b\x59\xac\x86\x32\x4e\x3e\xbc\x51"
          "\x86\x75\xc6\xd1\x76\x50\xae\xd3\x80\x2c\xd2\x66\x53\x52\x78\x61\x63\xe2\x67\x0f\xb8\xad"
          "\x5f\x34\xf7\x6e\x1d\xe9\x81\xba",
          "\x4d\xae\x0c\x71\xba\x66\xb9\x6b\x6b\x3b\x98\x4b\xdf\x62\x12\xe5\xf8\x04\xac\xa0\x79\xb9"
          "\xd7\x75\x4b\xaf\x46\xbb\xce\x5d\x49\x39\x6f\x03\x90\x80\x4c\x3d\x5a\x4c\xa2\xf1\x67\x29"
          "\x95\xcc\xeb\x25\x03\x4f\xfb\x05\xa8\x43\xff\x5d\x3e\x46\xd1\xf2\xfe\x80\xf6\xa7\x5a\xa2"
          "\x80\x5c\xd3\x81\x2d\xc9\x8c\x35\xf0\x6b\x81\xa9\xf6\x6c\x42\x68\x71\xc7\x5a\x99\xa7\x91"
          "\x44\x37\x68\x05\xea\x7d\x5b\x13\xe3\x73\xd7\x05\x95\x8a\x08\x09\x39\x9d\xa9\x08\xcf\xe8"
          "\xde\x9d\x6f\x33\x9d\x55\x68\xec\x53\xbd\x87\x15\x5b\xaf\x7a\x00\x8d\x1a\x9b\x7d\x72\x15"
          "\x2a\x82\xe4\x19\x8b\xf8\xcf\x43\x10\xde\xea\xee\xad\xc4\x1c\xef\xff\x88\x85\x05\x25\xfd"
          "\xcd\x70\x1d\xdc\xd7\x8e\x20\x08\xbe\x88\x2d\x01\xda\xde\xbe\x0b\x45\x1e\xf7\xd0\x64\xf6"
          "\xa1\xc9\x62\x1b\x55\x26\x11\x21\x25\xe4\xfc\xe7\x25\x7d\xa8\x83\xc5\x5f\x7c\x9a\xa7\x29"
          "\x3e\xc8\x44\xa2\x08\xd1\x89\x61\x4a\x62\xe3\xcd\x8d\xc3\x94\xb5\x69\x1f\x18\x86\x12\xb8"
          "\xa3\xc7\x93\xa5\x49\xa3\x0d\xb5\xb6\x6c\x6b\xbd\x2b\x2d\xe4\xa1\xa5\x6e\xca\x32\xaa\xe0"
          "\xba\x6a\x2b\xe8\xe9\xff\xc3\xbc\x46\x75\xa1\x9f\x47\x05\x54\xf9\x05\x74\xb5\x8b\xea\x39"
          "\x05\x35\xb9\x5c\x96\x37\x27\xc5\x2b\xb6\x7d\xcf\x1e\x4b\x99\x11\x7e\x0e\x2a\xa0\x52\x36"
          "\xed\x6f\xf3\x7f\x78\x7b\xac\x46\xb2\x9c\xf7\x2d\x35\x21\x88\x1c\x7f\x72\xdd\xc6\xc4\x0f"
          "\x18\x71\xa7\x2f\x21\xa7\x35\xeb\x20\xc4\x88\x99\x9a\x5b\x18\x8d\x6b\x58\x88\x1e\x39\x15"
          "\x7b\xac\x96\xbe\x15\xec\x05\xb2\xc2\x06\x10\x9f\xa6\x30\xd7\x27\xec\xfe\x4e\x75\x8c\xba"
          "\x9f\x6e\x84\x80\xfd\x7a\xf1\xfc\x68\x9f\x9e\xf0\xbc\xd3\xb8\xa3\xec\x4e\x00\xa6\xed\x87"
          "\x70\x3d\xe4\x15\x2c\x8d\x3b\x79\x83\x2b\x1f\x4f\x4e\x63\xfa\x4f\x59\xe1\x19\xb7\xa4\xdd"
          "\xb7\x4b\x6e\xad\xdf\x11\x85\xf6\xd5\xcb\x38\xe7\xaa\xf7\x92\xa3\x55\xd1\x89\xdc\x85\xc9"
          "\x22\x58\x58\xa1\x9c\x51\x4f\x45\x22\xad\x6b\x10\xee\x4b\x16\xcd\xf2\x1e\x14\x1b\x73\x96"
          "\xf0\x12\x63\x86\x05\x75\x0a\xc9",
          1, 3584 },
        { 128, 192, 60,
          "\x02\x30\x2c\x26\x9c\xd9\x05\x1d\xa2\x87\xa4\x76\xe4\xe0\xa4\x79\x52\x7f\x2d\x45\x62\x4d"
          "\xa8\x9f",
          "\xab\x7d\xe5\x19\x98\xc9\xb6\x11\xee\x70\x42\xec\x0a\x95\xbc\x35",
          "\x35\xf3\xba\x86\xd9\x68\xc0\x52\x5b\xe3\x1c\x3e\x10\x70\x77\xae\x67\x92\xb1\x80\xd6\xd2"
          "\xa0\x83\xc7\x3e\xd3\x24\x79\xdf\x09\x5e\x29\x11\xbb\x4b\x8f\xb4\x48\xcf\x13\x53\xd8\x54"
          "\x9e\x68\xab\xdc\xeb\x98\x77\x89\xa3\x13\x86\x8b\xe4\x25\x67\xcb\x80\x06\xcf\x1d\x1d\xf0"
          "\x02\xa0\x0e\x92\x65\xcc\x6c\xdf\x6e\x4c\x36\x4e\x7c\x8e\xe0\xd0\x0b\xac\xd1\xae\x94\xe0"
          "\x19\x3b\x3a\xbe\x7e\xd5\xdc\xbb\x78\x78\x42\x2b\x7a\x73\x55\x1c\xc2\x3f\xdf\x37\x3c\x18"
          "\xa6\x6a\x6c\x9a\xf1\x3e\x5f\x1f\xaf\x2c\x4b\x29\x6d\xc7\x0b\xa8\xff\x2f\x84\x0f\xc8\xc9"
          "\x3a\xb6\x2d\x8a\xfa\x26\xb1\xe3\xf2\x55\xc2\x3c\xf9\xf1\x45\x1b\xb3\xd4\x68\xad\x98\x77"
          "\xda\x2c\xaa\x06\x22\xd4\x04\x5f\x01\xba\x91\x4a\x92\x91\xd6\x7c\xf8\xc3\x2c\xc3\x16\x19"
          "\x22\x08\x3c\x20\x88\x96\x9e\x32\xb5\xf9\xd5\xcc\x3e\xe7\x78\x1b\xfd\x2f\xe3\x14\xe6\xcf"
          "\xe3\xb1\x82\x18\xbe\xb1\x81\xc5\x9f\x03\xce\xda\xe1\xf5\xbb\xa7\x91\xe6\x50\x38\xac\xb5"
          "\x62\xd1\x2a\x8b\xbd\xcf\xff\xca\x77\x42\xf2\xa2\xd8\xee\x67\xee\x0b\x54\x92\x1a\xdb\x16"
          "\xfe\xbb\xdf\xff\xf2\x60\x85\x15\x44\xd6\x96\x41\xcb\xe5\x54\x69\x8a\x5c\x77\x96\xf0\xf1"
          "\x66\xbd\x5c\xbc\xa2\x2a\x14\xca\x69\x45\x8c\x47\x31\xcd\xab\x08\xfe\x7c\x65\x6b\x90\x12"
          "\x7f\x59\xeb\x95\x9b\x43\x2f\x53\xfb\xfb\x2b\x80\xaf\x06\x9b\x3f\xcb\x7b\xf2\xe8\xdb\xe4"
          "\x4d\xef\xea\xe1\x1f\xa6\xa2\xec\x24\x45\xa3\xae\x44\xec\x31\x8c\xea\x6e\xc8\xff\xe6\x51"
          "\xbb\xb7\x8a\x84\x40\x9e\xa3\xb9\xd9\xc5\x23\x5b\xa4\x01\xe9\x92\x50\xfd\x00\x46\x7c\x71"
          "\xf2\x12\x1c\x7f\x54\x18\x8f\x54\xb7\x18\x24\xb2\x45\xce\xfb\xd2\xc4\x10\x5e\xe3\x49\x49"
          "\xd1\xbc\x7e\x5c\xa1\x81\xe4\xb9\x1f\x62\x2c\x05\x6a\xda\xcd\xfd\x24\xdf\xa0\xd9\x0a\xda"
          "\xfc\xd5\x89\x90\x0b\x25\x0d\x4a\xe8\xe0\xd7\x59\x4a\xee\x75\xa4\x54\x9c\x4f\x58\xbe\x9b"
          "\xcc\xd6\x9c\x04\x44\xce\x78\x44\x57\xf6\x08\x51\x86\xc0\x23\xe4\x18\x7c\xf7\xfe\x81\x58"
          "\xbd\xc3\xa0\x7b\x44\xe7\xb1\xb6\x4e\x14\x9d\x47\x07\x7b\x04\xe2\xde\x47\x25\xba\x0d\x77"
          "\x4c\x8b",
          "\x36\x6a\xc8\x0e\xe1\xae\xff\x06\xb9\x29\xc7\xcf\x10\xde\xd1\x5e\x63\x48\x70\x11\x3a\xa7"
          "\xcc\x9d\xf4\xc7\xde\xd1\xe2\x29\xec\xea\x16\xf4\xa6\x97\x0c\x0d\xa6\x89\x9e\x71\x73\xbc"
          "\x0c\xe2\x3a\x9a\xdb\xd0\x72\x44\xef\xb7\x8f\x47\x4c\xc0\x71\x38\x7a\xfa\x65\xfc\x7d\x5c"
          "\xff\x84\xaf\xa0\x63\x31\xea\xe2\xb4\x83\x8d\xe4\x5e\x32\x68\xf1\x6f\x42\xf7\x32\x3c\x1a"
          "\x5b\x88\x47\xc5\xc2\xce\xce\x1a\x45\x69\x35\xe0\xf2\x9b\x3e\xec\x46\x1f\xed\x02\x5c\x5c"
          "\x58\x74\xfb\x3f\xa4\xf8\x2d\xa1\x35\xcc\xf4\x05\x53\xcf\x9c\x69\x2c\x5a\xd3\x9b\x0a\xd6"
          "\x46\xb8\x23\x0e\x76\x9f\xc4\x54\xd5\x02\x0c\x49\x2a\x4a\x6a\x21\x29\xf6\x04\x35\x60\x01"
          "\xd2\x9b\xbb\x90\x96\x70\xda\x50\xc6\xa8\x4d\x5c\x3c\xaa\xb4\xa3\xe9\xb8\x57\xf4\x9c\x7d"
          "\xce\x50\x99\x98\x27\x41\x25\x36\x5c\x7e\x98\x98\xbf\x21\x22\xfb\xf9\x4e\x12\x4f\xa8\xdb"
          "\xe6\xcd\xdf\x98\xc2\x1a\x0e\xfa\x3a\x25\x4f\xcb\x50\x9b\x9c\x22\x8d\x38\x68\xab\xb2\xd1"
          "\x37\x00\xc8\x42\x09\xe5\x55\xa9\x04\xde\xfe\x99\x20\x2c\xe6\xde\x0e\x43\xa7\x3f\xb3\xac"
          "\xc6\xa0\x66\x84\xcc\xfe\xb6\x89\x8f\x7f\x9c\xfc\xc2\xd6\x32\xa1\xf7\x6d\xaf\xb8\x34\x90"
          "\x92\x77\xe0\x61\xcd\x4c\x74\xe6\x01\xa8\x23\x07\x67\xd1\xfb\x32\x72\x7b\x6a\x53\xa9\x4f"
          "\xc7\x15\x41\x9d\x14\x6f\x03\x36\x05\x55\xcf\x94\xd8\x83\xf9\x13\x17\x91\xa7\x7b\x5f\x3b"
          "\xd1\xea\xf5\xf6\x16\x4d\x15\x4a\x49\xe0\x91\x39\x1f\x68\xf7\x28\xb9\x8c\xa4\xa2\x5b\x80"
          "\x85\xab\xaa\xfb\x07\x69\x52\xc1\xf8\x3d\x75\x4d\x53\xbf\x71\xe5\x5c\x47\x44\x72\xe6\x26"
          "\xdf\x97\xe2\x29\xad\xcd\x3a\x79\x16\x6a\xe3\xba\xbb\x98\x42\x7e\xb4\x81\xaa\xdb\xf9\x3d"
          "\x60\x06\xc0\xa0\xb5\x5c\x74\xdb\xbb\xa1\x03\xca\xd9\x69\xc0\xb5\x47\xb7\xc5\xf8\xc0\x67"
          "\xc5\x58\x24\xb7\x3e\x31\xc9\x48\x49\x9b\xb2\xe0\x63\xf7\x5a\x4e\xc9\xb5\xa6\xe0\x25\x87"
          "\xc4\xd6\x2d\xb2\xd0\xca\x3d\x63\xc4\x46\x2a\x00\x1d\xf7\x56\xcf\xe1\x0c\xfd\x7d\x5b\xb4"
          "\x97\x29\x40\x82\xaf\x9c\x4c\x2b\x5c\xa1\xf8\x3a\xe7\x06\x52\x29\xcf\xf1\xf0\xdc\x2d\x3e"
          "\x7c\xfc",
          1, 3712 },
        { 128, 192, 61,
          "\xf1\x4a\x65\xe4\x87\x80\xd9\xaa\xc6\x4d\x6e\x79\x0f\xf3\xac\x2e\x28\x7d\xec\x10\xd4\xb6"
          "\x50\xf9",
          "\x72\xb3\xc4\xe0\xe7\x7a\x74\x69\xdd\x80\xc1\xe2\xbf\x73\x6a\xd3",
          "\xc9\xa5\x2c\x9b\xb5\xd1\xf6\x16\x32\x26\xb2\xcd\x70\x54\x13\x28\x9c\x79\xcc\xa2\xe6\xb7"
          "\x8a\xa9\x6c\x88\x20\x30\x96\xe4\x7f\x22\x1c\xf8\x20\x19\x50\xb8\xfc\xc6\xc5\x76\x9b\x08"
          "\x2e\xea\x7d\x8e\x45\x40\xe7\xc6\xfb\x18\x6d\x9d\x8e\xe4\x56\xa5\x45\xca\xc6\x91\x20\xd3"
          "\xee\x86\x50\xa9\xb8\x96\x01\xd5\xf7\x03\x0f\x88\xaa\x41\xae\xd8\xdb\x22\x3a\x01\xa0\x29"
          "\x04\x6d\x0a\x76\x7d\x41\x59\x68\x5e\x5a\xed\x0a\x4d\x14\xf2\x1d\x8c\xbc\x6b\xf8\x6b\x59"
          "\xd7\x9d\x1f\xea\x81\x5a\xc4\xff\xf6\xa6\xf4\x9f\x1c\x0d\xf8\x07\x89\x9b\x39\x47\x48\xb1"
          "\x6b\x7f\xed\x40\xd1\x16\x7a\x64\x79\x89\xd0\x88\xf7\xce\x7a\x55\x03\xf9\xd9\xb4\xda\x5a"
          "\x93\xa2\x7b\x67\xd4\xef\xde\xf1\x3a\xa9\x0f\xea\x61\x49\xfb\xcb\x97\x19\x6d\xbc\xbc\x32"
          "\x07\x5b\x8c\x6c\x03\x12\x1a\x2d\x92\x77\x36\xfd\xe1\x3b\x33\x60\x4e\xef\x1f\x86\xc5\x03"
          "\x25\x2b\x2e\xc7\x53\xac\x52\x94\x80\x7c\x48\x1d\xbe\x41\xa7\x63\xe3\xd9\x73\x66\x1e\xcb"
          "\x68\x7b\x9f\xd1\xfd\x3c\xa4\x3f\x7c\x48\x03\x90\xda\x73\x8e\x64\x3d\x53\x7e\x1e\xa4\x5d"
          "\x01\xfd\xa0\x2f\x62\x59\x65\x49\x94\x52\x85\x80\xf2\x1d\xd6\x24\xa6\x7b\xaf\x3d\xf3\xc5"
          "\x61\x60\x29\xb9\x40\x4a\x89\x5c\x3b\x87\x86\xd4\x3a\x18\xfa\x61\xdf\xe6\x59\x0a\x75\x94"
          "\xf7\xc9\x34\xc3\xc1\x12\x48\xba\x8d\xbe\x68\x37\xdf\x0f\x61\xa8\xba\x7e\xf3\x98\xbb\x3e"
          "\x25\x56\xc9\xf9\xa4\x06\xcd\xcb\x01\x65\x68\xa0\xde\x75\xf1\xac\xa8\x67\x60\x83\x71\x1c"
          "\xab\x2b\xaa\x21\x08\x8c\x84\xa2\x6d\x04\xae\x0a\xb3\x44\xf0\x17\xaa\xf7\x2b\x3b\x78\x6c"
          "\x14\x28\xf5\x9d\x81\xf4\xe6\xe0\x3c\x8d\x58\x2b\xd3\xf9\xb5\x8a\x2f\x9e\x9c\x48\x46\x54"
          "\x31\xda\x0e\xaa\x6d\xb1\x52\x21\xc0\x57\xec\xca\xcd\x6c\x4c\xd5\x64\xbd\x32\xc3\xb1\xc3"
          "\xef\xf2\xe7\x77\xf2\x3d\xf3\xca\x70\x5e\x6f\x54\xc8\xeb\xde\xbe\xb4\xfb\x16\x77\xa0\xb7"
          "\x84\xfa\x63\x10\xe2\x20\xe1\xb5\x24\x15\xee\x41\x89\x4e\x00\x0c\x17\xe0\xe4\xa1\xc2\xfe"
          "\x1a\x15\x2a\x29\x45\x36\x14\x7b\xa9\xb5\xc6\xb9\xfe\x5e\x9a\x00\x67\xc4\x66\x87\x09\x4c"
          "\x69\x22\x0b\xaf\x38\x49\xa3\x7b\xbb\xd3\x60\xcf\x48\xe3\x2c\x54\x00\xba",
          "\x4e\x49\x87\x91\xe2\x3b\x79\x08\x79\x59\xbc\xb9\x0d\xd9\x86\x7b\xff\x28\x17\xfe\x08\x3b"
          "\x84\x33\xbd\x3e\xa7\x2d\xd9\x78\xec\x59\xb3\x80\x0d\x06\x7f\x72\x54\x53\xec\x22\x76\x13"
          "\xd8\x53\x80\xab\xfc\xf9\xec\xad\x9d\x91\x73\x22\xe6\xb5\xe8\xcd\xab\xd2\xf8\xb6\xa1\xa2"
          "\x14\x9e\x00\xbd\x3e\x97\x99\x41\x3a\x03\xb3\xbc\xe2\xdc\x29\x6a\x70\xb0\x6d\x6d\xd7\x97"
          "\xf0\x74\x75\xbe\x3b\xa1\x8a\xdd\x88\x93\x88\x8c\xf8\x7d\x97\x9c\x95\xb3\xed\x2e\x17\xd6"
          "\xd5\x69\xc0\x11\x82\xcc\xaa\xb7\xf8\xde\x22\xfa\x15\xf0\xf5\x56\xb1\xda\x85\x4b\x29\x9b"
          "\xfa\xbf\xad\x4e\xa3\x71\x79\xab\xae\xe2\xf9\xae\x18\x12\x0d\xfd\x8f\xd3\x2f\x2d\xfa\x03"
          "\x4c\xdf\x5b\xfd\x78\xaf\x6c\x57\x0c\x8c\x2c\x9a\xb5\x91\x23\xaa\x76\x5e\x3f\x01\x02\x33"
          "\xed\x39\xae\xff\x93\x39\x24\x4d\x71\x1f\xa7\x1f\x1d\xc3\xc8\xe2\xd9\xb8\x2a\xf2\x38\xc8"
          "\x5e\x00\x01\x70\x21\x5b\xc3\x55\x93\x63\x78\xee\x8e\x6b\x81\x0d\x8b\xe9\xe3\xf8\xf4\x0d"
          "\x73\x64\x54\x15\x63\xc4\x12\xd3\xc6\x10\x95\x6b\x91\x45\x14\x7b\x0f\x29\x0f\x6f\xcb\xe9"
          "\x13\x32\x3d\x63\x94\x83\xe0\x54\x76\x5c\x6c\x54\x72\x6d\xbd\x9b\x48\x24\x12\x38\x98\xeb"
          "\xdd\x5b\x3c\x9f\xe7\x60\xa2\x08\x0d\xdd\x60\x41\x27\xf5\x53\xa0\xca\xe6\x31\xdf\x8c\x66"
          "\xbf\xb9\x38\xb5\xc7\xf6\x44\x60\x47\x15\x23\x00\x02\xd4\x78\x69\xb5\x01\x32\xaf\xd7\x13"
          "\xd7\xa9\x15\x45\x1e\x8a\x7e\x28\x52\x8e\x9a\xf9\x49\x79\x91\x54\x2b\x25\x33\x60\x7f\x65"
          "\xd3\x7e\xbb\x0a\x7a\xd2\x9d\xb2\x91\xc7\x03\x4a\x8c\xc9\x0a\x89\xeb\x6e\x38\xb2\x9b\x58"
          "\xd0\xdc\xcd\x32\xd5\x3e\xac\x84\xda\x44\xf2\x79\x3b\x97\xc7\x11\x3b\x88\x03\x27\xbd\x13"
          "\xc7\x45\x06\x97\x31\x64\x98\x65\x47\x51\x3d\x8f\x20\xd9\x5f\x31\xba\x54\x9c\xd1\x38\x9b"
          "\x55\x10\x22\x5f\xa4\xa8\xf3\x84\xf9\x28\xe4\xec\xc3\x3f\xda\x18\xbb\x3f\x4c\x88\x92\x61"
          "\x23\x6c\x6a\xec\x09\xed\xf5\xb7\x92\xbd\xfd\x3c\x13\x38\x79\x12\x98\x38\x50\x29\x81\x2f"
          "\x7c\xc4\x73\xee\x81\x7f\x8c\x21\xea\xde\xe1\xc0\x92\xcb\xb2\x67\xf9\xfd\x46\x17\x1a\x60"
          "\xbe\x57\x0b\x96\x6e\xa7\x78\xb7\xec\x1b\x91\xd5\x0e\x55\x44\x16\xfe\x44",
          1, 3840 },
        { 128, 192, 62,
          "\xe8\x3c\xfb\x36\xe7\x17\xb3\xea\x26\x68\x3a\x51\x24\x2d\xa6\xb9\x8c\xdc\x10\x8c\x6d\x7f"
          "\xfc\x3f",
          "\x7c\x7e\xa1\xad\xf5\xc3\x99\x7b\x17\x6f\x17\x99\x59\x22\x6f\xbd",
          "\x22\xc8\xd0\xea\xae\x1c\x50\x0d\xb4\xc5\xef\xac\x37\x10\xdd\x52\xef\x0f\x4e\x5d\xaa\x8d"
          "\xd1\xba\xbc\x58\x3f\x5c\x0c\xad\x36\x64\xf7\x6b\x87\x04\x28\x25\xa2\xca\x90\xd2\x0e\x38"
          "\x14\xcc\x60\x96\x27\x51\x7f\x33\xa7\xcf\x31\xe4\x94\xc8\x02\x67\x27\x92\xbf\x23\xd1\x7a"
          "\xc5\x10\x12\x18\x57\xdd\x4c\xb8\x55\x0c\x11\xd3\xc8\xa7\xec\x30\xd7\xdb\x09\x60\x74\xe3"
          "\xc5\x6e\xd9\x5e\x0c\xdf\x8d\xe5\xe1\x36\x8e\x4a\x2f\x7b\xa5\xfe\x40\xd8\xc3\x0d\x63\xc1"
          "\x63\x00\x8b\x5c\x81\xef\x16\x80\x71\x34\x4e\xf2\xc5\x53\x56\xd7\x92\xb9\xb9\xf4\xf3\x15"
          "\x8d\x0c\x20\x59\x1e\xcb\x4a\x23\x04\xb3\xaa\xc9\x0d\xc7\x7b\xc2\x03\xf8\x80\xf9\x3f\x94"
          "\xf9\x07\x62\x34\xa9\x25\x6b\xf5\x53\x89\x02\x08\x84\x8b\xca\x29\x5d\x26\x2c\x8f\xb9\xb7"
          "\xc6\x9a\xe5\xfd\x47\xa5\xdc\x2e\x45\xf7\xcd\x56\xc2\x24\xff\x55\x5d\xca\x0c\x82\x5c\x34"
          "\xb4\x8f\xe7\xbf\x8f\xcb\xa6\x3c\x4d\xa7\x64\xf8\x79\x59\x1e\x60\x2e\x51\xe7\x33\xe4\xff"
          "\x94\x46\xff\x05\x25\x25\x7e\xd1\x6a\x4f\xe0\x14\xb9\x67\x62\xe7\xc8\xc3\x97\x7d\x33\xf7"
          "\x3d\xa2\x48\x16\x2d\x3f\x27\xe4\x05\xea\xf1\x5c\xcb\xed\xa1\x44\x2c\x33\x7b\x61\xc7\x00"
          "\x69\xb7\x64\xe3\x2d\x94\x6a\x12\x27\x6f\x9a\x8e\xac\x27\xc3\x80\xfb\x42\xba\xb0\x08\xea"
          "\x6b\x65\xe0\xa9\x02\x8e\x4a\x77\xe1\x31\x08\x32\xa0\xd5\x91\x34\x64\xad\x3a\x13\x5c\x71"
          "\x04\xa7\x0d\xaf\xff\xe1\xf2\x81\x53\x08\xa4\x95\x93\xc2\xa5\x17\xa0\xf5\x5e\xa8\x43\x3d"
          "\x37\xc7\xea\x4e\x9b\x95\x91\xbe\xbe\x25\x66\x1b\xc2\x55\xb8\xd2\x06\xdf\x16\x5e\xe9\xf3"
          "\xc8\xcc\x12\xa2\x2c\xfc\xf7\x00\xdd\xcc\x28\xbb\x35\xae\xe1\x61\xb0\x5e\x3e\xdb\x9f\xe4"
          "\x8e\x96\xbc\x8e\x70\x96\x5e\x0a\xf1\x9e\x84\x2e\x06\xc8\xe0\xfd\xee\x55\x93\xa6\x10\xb8"
          "\xc9\x06\x6d\x84\x9e\x58\xff\x9a\x98\x21\xb9\xf4\x08\xf3\xb3\x27\x01\xdd\x86\xf8\xa0\x3c"
          "\x28\x36\x4a\xac\x70\x7d\x45\x2f\xf2\x25\xc3\x39\xa5\x50\x5e\xcc\x89\xb8\xe9\x39\x09\x85"
          "\x91\x26\x39\x6a\x89\x26\xf8\x55\x6c\x32\x72\xd8\xbc\x17\x3d\xfe\x57\x05\x7b\xaa\xdc\xd7"
          "\xc5\x31\xb4\xa8\x04\xfe\x2c\xfa\xe5\xc7\x58\x5b\x12\xb0\x58\xee\xf6\x50\x9c\x6c\x9f\x95"
          "\x63\xe5\x4f\x40\xd1\x66\x5e\xa8\xe2\x56\xcd\xea",
          "\xfe\x3c\xdb\x89\xc6\x6f\x2e\x2d\x03\xed\x0e\x6c\xa2\x60\x9f\xd1\x43\xfb\xf1\xa2\x43\x3f"
          "\xea\x5f\x9d\x39\x2b\xcd\xdc\x6b\x65\x2a\xc3\x62\xc3\x9d\x83\x4e\x9b\x8b\x2d\x61\xc5\xb5"
          "\x9f\xb9\xed\x4c\x20\x44\xf3\x72\xd7\x37\xe3\xc8\x4d\x48\x74\x0d\x6e\x01\xe8\x21\x2f\x70"
          "\x16\x88\xee\xe9\x3f\x4f\xf8\x9d\xbd\xb5\x80\xf9\x58\xc9\xdc\x93\x45\x0f\xe3\x78\x5e\x2e"
          "\xaa\x21\x1e\x80\xfd\x8b\xf9\xc6\xcf\xe6\xed\xcd\x1b\x35\xdf\x0f\x9d\xd8\x1d\xe2\xaa\xd7"
          "\x0c\x6a\x1e\x3e\xe2\x18\xb0\xc0\x64\x0d\x8e\x6c\xe5\xf1\x41\x17\x7e\x22\x22\xd8\x66\xe2"
          "\xf9\x0e\x17\xb3\xea\x2c\xce\x91\x9d\x49\x07\xaa\x82\x13\x20\x8d\x0b\xe4\x06\xa9\x44\x99"
          "\xf2\xa0\xa3\x2f\x93\x84\x39\xe1\x57\x21\xfa\xff\xba\x1e\xd4\xb9\x8a\x7f\x0a\x25\xc6\x0e"
          "\x73\xc7\x93\x70\x0a\x57\xa1\xb6\x4e\x7b\x67\x33\x70\x4d\xcd\xad\xf0\x7a\x3b\x72\xca\x2d"
          "\x86\x55\x9e\xe0\xbb\xbc\x7c\xe8\x68\x5e\x84\xa6\x54\x5a\x46\xcd\x19\xf3\x9c\x42\x68\x13"
          "\x2c\x14\xe6\x38\x65\xed\x99\xe2\xd9\x4e\xa3\xaf\x9e\xe6\x55\x6d\xeb\x3c\xa9\x92\x2b\xd0"
          "\x14\x47\x53\x4c\x6a\x0b\x88\x6f\x0f\x06\x10\xc3\x1f\x08\x99\x40\x16\x59\x7c\x2f\xd7\x86"
          "\x10\x9b\x7b\x4f\x0c\x56\xe4\x01\x0f\xc2\x0f\x64\x9e\x61\x00\xf1\x87\xd6\x1e\x75\x4c\x75"
          "\x3b\x30\x1b\xe3\x46\xed\x51\x94\x1b\x70\x50\x9c\xd3\x19\x91\x78\xda\xed\x3c\x0d\xdd\x3f"
          "\x4a\x27\x9d\x05\xec\xac\xca\xa1\x78\xaf\x91\x27\xcf\x21\x7c\x27\xd3\xf4\xa4\x72\x44\x91"
          "\x5f\x3e\x4f\x60\xc7\x86\x76\x4a\xb6\xd3\x57\xb1\x89\xdb\x3d\x26\x0b\xd0\x21\x8b\x95\x2a"
          "\xd9\x34\x4d\xd3\xd7\xd5\x02\x8c\x1a\x0c\x88\x3d\xa9\x2d\x48\x2e\x53\x7c\x71\x5a\x1a\x6d"
          "\x8b\xf4\xe4\xda\x0b\xd4\x28\xd3\x66\x06\x09\xdb\x50\xcd\xe8\xcf\x8c\x48\xd6\x7f\xf8\x57"
          "\x9e\x40\x6c\x16\x27\xce\xde\xbd\xb3\xb7\x27\x2d\x1b\xec\x0a\x6f\x34\xca\x68\xdf\xfa\xa4"
          "\x84\x33\xf5\xc5\xc5\x77\x1d\x72\x92\x6d\x68\x93\xbf\x49\x26\x3c\xd4\xe3\x50\x34\xcf\x85"
          "\xf9\xd7\x64\x05\xec\x88\xbb\xe8\xf2\xdb\xbf\x05\x95\x51\x76\x49\x95\xd5\x6b\x83\xcf\x76"
          "\x8d\x31\x52\xf5\xc4\x7b\x8e\xbd\xcd\x1a\xf3\x6c\x95\xc9\xc1\xe2\x4b\x14\x51\xca\x4b\x0b"
          "\x7e\x31\xfa\xdb\x3d\x37\x51\xbb\xb7\x3a\xaa\xc7",
          1, 3968 },
        { 128, 256, 63,
          "\x59\xc2\x0f\x2a\x22\x34\xaa\x96\x4e\x64\x1a\xb8\x7f\x88\xe8\xee\x40\x1e\x3e\x34\xf8\x2a"
          "\x89\x03\x29\x59\x1f\xf9\xb5\xf1\x06\xe8",
          "\x1e\x07\x48\xe9\xf1\x19\x7b\xf1\x02\x5b\x35\xbe\x74\x96\x8a\x99",
          "\x52\xf4\x07\x4a\xa6\xe7\xd0\x81\x99\x6e\x47\xdd\xc2\x29\x39\xde",
          "\x24\x16\x23\x0e\x57\x6a\x79\xbe\xfe\xb6\x20\x72\x0d\xb5\x6e\x2a", 1, 128 },
        { 128, 256, 64,
          "\x83\xbc\x79\x24\xb7\x28\x6c\x92\xca\xdd\x01\x71\xa7\x0a\xa5\x76\xe7\x31\x19\x05\x42\x27"
          "\x00\x98\x85\xd5\xb0\x46\x3c\x29\x54\xcc",
          "\xc6\x00\x0d\x3d\x5a\x57\x80\xe4\x86\xf8\xc9\xba\xc9\x19\x75\x78",
          "\xfc\x11\x04\x58\x99\xda\x80\x33\x47\x93\x13\x27\x19\xb4\x2f\x85\xfd\x27\x5f\xf8\x2a\x31"
          "\x4f\x6a\x58\xb2\x66\x5c\xfb\x09\xdb\xcb",
          "\x9e\x65\xcc\xbe\xa5\x31\x19\x46\xfb\x8d\xd7\x96\x44\x27\xe9\xc6\x24\x13\xb3\x64\x33\xca"
          "\x8c\x0e\xe7\x2d\x11\x98\x0c\x91\x08\x42",
          1, 256 },
        { 128, 256, 65,
          "\xa5\x7a\xac\x01\x43\xe7\xa6\x5e\xe5\x67\x4f\x76\x52\xba\x89\x48\x6f\x34\x8e\x6c\xba\xb9"
          "\x47\x7f\x1f\xab\x3b\x3c\x14\x14\xaf\x52",
          "\x1b\x24\xd7\x08\x12\x62\x9b\x6d\xaa\xc0\xf8\xc7\xa6\x5d\xa0\x71",
          "\x1b\xe6\x86\x92\xd6\x6a\xdf\x9b\x45\x69\xfc\x73\x33\x17\x30\xa6\x75\xc5\xf3\x3e\x2d\x6d"
          "\x33\xae\x8d\xad\x7e\x15\xc0\x29\x12\x78\xe2\x5a\x64\xaf\xd1\x1f\x93\xc1\x05\x96\xc4\x12"
          "\xd0\xdb\xde\xc4",
          "\x00\xa6\x91\x4c\x9c\xbb\x37\xc6\x9e\x46\x15\x74\x50\xdd\x00\x68\x39\xc8\x74\x22\xa8\x1c"
          "\xaa\x86\x80\xb6\xac\x33\x36\x5c\x01\x76\xb6\x12\x8c\x27\x6d\x73\x4f\xa3\xca\x6a\x7d\xee"
          "\x23\xe4\x17\x21",
          1, 384 },
        { 128, 256, 66,
          "\xc4\xbe\xf6\xb3\x9c\xd7\xe1\xf1\x2f\x7f\xe7\x85\xc3\x26\x01\xbd\x1d\x2c\x06\x28\xac\xb2"
          "\x6e\xb7\xa3\xed\x23\xa9\xde\x4c\x2b\x04",
          "\x60\x3e\xe3\x70\xbb\x16\x52\x5d\xf1\xaa\x07\xef\xd3\x12\x54\x1b",
          "\x92\x1e\x70\x2e\x89\x9d\x99\xa9\x8c\x7d\x0a\x48\x5b\x67\xb7\xb8\xe5\x79\x06\x4a\xee\x47"
          "\x0c\x4c\xac\x0a\xde\x6f\x0d\xe2\xe3\x8c\x36\x8a\xde\xc3\xd3\xff\x5c\x44\xef\xe6\xce\x4b"
          "\xad\x28\x7d\xcc\xf6\x7b\x81\xb3\xbc\xa4\xdd\x04\x52\x14\xb3\x9d\x2b\x3e\x79\xdb",
          "\x86\x31\xab\x41\x11\x3a\xe4\x1f\x2b\x21\xb6\xd9\x64\xd0\x7e\xce\x6c\x45\xd7\xed\xc9\x4c"
          "\x4b\x28\xc2\x66\xbf\xaa\xbe\xfe\x17\x2c\x20\xf3\x74\xf5\x77\xfc\x09\x24\xdf\xcc\xc1\xbe"
          "\xd0\x35\x13\x9f\x1c\xaf\x3c\x67\x86\xe8\x45\xc8\x14\xe0\x59\xb3\x20\xbb\xed\x56",
          1, 512 },
        { 128, 256, 67,
          "\xbf\x7d\x06\x4f\x38\x32\xa8\x23\x92\xbb\x2b\x16\x40\xfe\x68\x97\xce\x48\xa2\x24\x1d\xc0"
          "\x0e\x0b\xfe\x36\xee\xc9\xca\xc6\x7f\x6c",
          "\x4a\x02\x9f\xb3\x04\x23\x4c\xe0\x14\x4f\x80\x24\x59\x30\xaa\xc5",
          "\x03\x5e\x31\xfd\x99\x35\xb3\x43\x61\xb9\xde\xc6\xa3\x61\x00\x23\xa3\xbc\x53\xb3\x99\x9c"
          "\xab\x85\x45\x5e\xfc\x09\x02\xc1\x0c\xb3\x3f\x77\x7c\x45\xf6\x1f\xe0\xd9\xa5\x4a\x02\xcb"
          "\x01\x55\x1f\x08\x64\xd9\xb5\x4a\xbb\x5b\x5b\xc9\xa3\x44\x28\x00\x0b\x69\x35\xaf\x42\xdc"
          "\x1c\xdc\xb7\xd8\xef\xcc\x41\xc6\x3a\x07\x45\x66\x9b\x97",
          "\xd9\xa5\x96\xb0\x2f\xd6\x71\x03\x65\x35\xe3\xb2\x20\x5d\x0c\x4a\x36\x43\xea\x3b\x07\x89"
          "\xbd\x84\xbc\x64\x19\xa4\xe4\x09\x61\xfa\x2a\xc9\xd5\x09\x7a\x62\xa8\x13\xf9\x59\x11\x8d"
          "\x6a\x24\xd1\x47\xa9\x87\x64\x35\xd7\xc0\x4e\x5f\xd9\x76\x5d\x55\xa6\x67\x12\x47\x84\xfb"
          "\x9b\x0e\xca\x91\x08\xf2\x14\xae\x17\x2b\x4e\x44\xf7\x82",
          1, 640 },
        { 128, 256, 68,
          "\x74\x64\x2c\x33\x19\xf1\xf4\x8a\xa4\x07\xd5\x25\x13\x33\x9e\x98\xf8\x60\xbf\x90\xdc\xac"
          "\x0b\x1b\x1f\xfb\xb7\xaa\xbe\x75\x8d\x4f",
          "\x1c\xbb\x9a\x4a\x0a\x2e\x16\xa7\xe8\x0f\x15\x99\x86\x01\xee\xbb",
          "\xea\xf9\x50\xcc\x57\x9c\x24\x4a\xec\x7f\x35\xee\x92\x7c\xf7\x73\xa9\x42\xec\xb5\x02\xd7"
          "\x38\xff\x32\xe5\x7e\x5d\xed\x68\x36\xfd\x34\xb1\x10\x1f\x19\x5b\xaf\x8d\xc1\x2c\x7e\xb6"
          "\x21\x34\x19\xa7\x9c\x3b\x3b\xb5\x83\x18\x68\xe2\x39\x19\xbc\x74\x8c\x37\x1d\x49\x14\xec"
          "\x9c\x0d\xa7\xa7\x77\x92\x97\xa7\xd5\x75\x2c\x99\x7f\x8a\xdd\x1c\x99\x20\x2b\xd9\x9c\x71"
          "\x0d\xba\x12\xfa\x02\xc4\xcf\x69",
          "\x81\x91\x8d\xb7\x42\x6f\x53\xdc\x6d\x49\x79\x01\xa8\x8e\x88\x4f\xa5\x7c\x10\x6c\xea\x93"
          "\xcf\xf0\x43\x01\x2d\x48\x2c\xd2\x64\x11\x01\x64\xac\x63\x3d\xa7\x69\xfd\xdf\x00\xe2\xf5"
          "\xb6\x9a\xd3\x93\x79\x54\xde\x30\x35\xb5\xa7\x8b\xc2\x30\x2e\x9c\xef\x20\x6e\x1d\x03\x27"
          "\x62\x47\xc3\x6f\x29\x38\x16\x3e\x24\x59\x45\xcf\xc3\xf1\xf1\x23\x86\x5d\x54\x8d\xc4\xf7"
          "\x63\x9a\xf0\x43\xce\x18\xd1\xd6",
          1, 768 },
        { 128, 256, 69,
          "\x5d\x59\xa1\x0f\xa7\x93\x40\x83\x0e\xdb\x20\xa9\x11\x8f\x76\xdd\x22\xc5\x9c\xa1\x45\xdb"
          "\x1a\x8e\xc7\x4d\xc4\xc6\x24\xfa\xbe\xa5",
          "\x6e\xf9\xdf\xf9\x00\x55\x06\x61\x84\xdb\xb6\x87\xd0\x39\x94\xcc",
          "\x31\x58\x61\xec\x1d\xd4\xf1\x67\x63\xbd\xfb\xbb\x63\x7f\x30\xb3\xdf\x38\xc3\x62\xd6\x25"
          "\x3c\x4e\x4b\x02\x3b\x89\xd4\x83\xd5\x7b\x89\xfb\x82\x9e\x94\xc2\xe8\x53\x2d\xf7\xa0\x68"
          "\x97\x3a\x7b\x8f\x55\xf6\xbd\x8f\x25\xbc\x6c\xe1\xc2\xd6\xb7\xb0\x9c\xde\xa0\x7d\x78\xa8"
          "\xfb\x58\x15\x5e\x4c\xd1\x12\xb1\x39\x0c\xa7\x9a\x22\x70\xa9\x71\x14\xbc\x50\x84\x67\x86"
          "\x08\x60\x13\x9e\x63\x45\x01\x35\x0c\x4b\x8c\xee\x10\x81\x02\xca\xc2\xdf\x30\x9c\x1d\x5a"
          "\x21\x24",
          "\x03\xa6\x80\xa3\xd7\x3f\x24\x96\x76\xe9\x84\x65\xb5\xd1\x14\x18\x95\x85\x02\x2a\xf6\x40"
          "\x28\x25\x31\xb0\xa5\xb9\x4f\xd0\xd5\xbe\x17\xe7\xdc\xbb\x7d\x92\xb1\xc3\x03\x36\x3a\x4b"
          "\x2d\x89\x0b\x08\x71\x4b\xb8\x65\x2f\xb8\xf3\x30\x4b\xe2\xd3\x90\x68\x11\x98\x46\x4b\xea"
          "\xde\x5a\xa1\xe9\xb2\xed\x6d\xbd\xb0\xb6\xfa\xbb\x61\x35\xad\xf7\xeb\xb6\xa5\xf6\x83\x17"
          "\x8c\xb9\xef\x94\x2c\x9d\xbf\x55\xa9\x49\x42\xf2\xef\x1a\xc3\x05\x27\x12\xf1\xf7\x80\x8b"
          "\x6c\xab",
          1, 896 },
        { 128, 256, 70,
          "\xf5\x27\xd0\x92\x7f\xe5\x90\x1f\xfe\xe9\x8f\x91\x74\x77\xb5\x85\xb4\x26\x44\x50\x3e\xd6"
          "\xab\x6d\x6f\x8e\xf9\xb6\x88\x77\x12\xf0",
          "\x05\xaa\xc1\x45\x89\x46\x49\x07\xf6\x19\x9b\x53\x75\x34\x63\x8d",
          "\xd8\x9c\x8f\x2b\xd1\xd4\x8c\xd4\x25\x5b\xe2\x4e\x3f\x1b\xcc\xfc\xbe\xfa\x59\x43\xa4\xb8"
          "\x3d\x08\x5b\x0d\x84\x98\xdb\x77\x7e\x8e\xf9\xaf\xdc\xb6\x22\x9b\x47\x6c\xdb\x1f\x78\x60"
          "\x7e\x03\xbd\x09\x19\x86\xb6\xa0\x68\xb1\x2c\xeb\x76\x29\x59\xd9\x8f\x10\xb1\x09\xb0\xe0"
          "\x34\xa2\x88\x6a\xa0\x56\x0e\xc7\x61\xf6\x1c\xa3\xda\x1f\xc8\x88\x13\x04\xe8\x6a\xd1\x81"
          "\xe3\xae\xef\x1e\xbb\xce\xff\x16\x6f\xd1\x4d\x60\x08\xe8\x9b\xbc\xb9\x52\x86\xa2\x17\x03"
          "\xc9\x43\xb0\x0f\xd3\xb6\xee\xcc\x9a\xea\x13\x00\x1a\x91\xdd\xe9\x39\xae",
          "\x7a\x3e\xc7\x74\x89\xb4\x1d\x49\x07\x91\x76\xce\x33\x7d\xb9\x3e\xc1\xe7\x2d\x55\x6d\x7f"
          "\x6e\x29\x0c\x3d\xaf\xa0\x9a\x4e\x3d\x55\x9c\x78\x60\xd7\x24\xbd\xa5\xdb\x0f\x83\x18\xe4"
          "\xa3\x31\xf5\x93\x53\x2e\x21\xbc\xa4\x07\xc9\xbd\x27\xc1\xf8\x78\x1c\x4a\x5f\x64\x4b\xb9"
          "\x7f\x8d\xfa\x7a\x3a\x87\x6f\x01\xd6\xf6\xc7\xb7\xae\xe2\x49\x96\xbc\x82\x4f\xcf\x6f\x16"
          "\x6d\x9b\x7e\x4c\xbc\x5f\x15\xd9\x40\x87\xb3\x93\x12\xf5\x92\x2f\xf8\xa0\x3d\xf7\x11\x42"
          "\xaa\x0a\xf2\xf5\x10\x79\x17\xdc\x22\x5d\xad\x02\x68\xc3\x95\xbf\xcb\x22",
          1, 1024 },
        { 128, 256, 71,
          "\x19\xbe\x69\x4a\x1d\xff\x91\x20\x2d\xef\x66\xb5\x3a\x3f\x63\x62\xfc\x20\x0d\x93\xb6\xb2"
          "\x7d\x3e\x8a\x37\x13\xb2\xab\xaf\x7a\x27",
          "\xca\x83\x33\xf2\xf6\xda\x1a\x7e\x66\xf2\x99\x7a\xb9\x97\x62\x31",
          "\xce\x54\x48\x15\x02\xe0\x7e\xe9\xf5\x7a\x4c\x85\x63\xf7\x06\xb2\x50\xb9\x65\x49\xed\x38"
          "\x33\x8a\xb2\x00\xcc\xea\xda\x29\xa3\x26\xc8\x38\xa5\x07\x47\x02\xa4\x28\x76\x87\x73\xb1"
          "\x11\xbd\x84\x04\x80\xb9\x09\x77\xc2\xe8\xe8\x42\x5a\xe6\xa6\xf8\xee\x15\xdf\x3c\x56\xe4"
          "\xde\x67\x09\xa0\xd7\x50\x49\x55\x2e\x1d\x35\x31\x85\xf0\x7e\xef\x0b\x78\x42\x70\x6a\xde"
          "\x77\x7a\x8f\xe9\xf5\xa3\x48\x76\xfd\xe7\x87\x6f\x29\x44\x99\x7b\x50\x26\xb5\x17\x8c\xf4"
          "\x33\xb6\x34\x79\xff\x4f\xf4\x95\x0b\xdb\x9d\x38\x72\x57\x75\x4b\xc0\x9a\x15\x72\x80\x72"
          "\x98\x5e\x14\x4c\xbf\x24\x9f\x14\xee\x1f\xd2\xe4",
          "\x9a\x69\xaa\x44\x69\xfb\x88\xf5\xa4\xc3\x44\xa1\xef\x02\xa6\xcd\x60\xee\x1b\x16\x8c\x7e"
          "\x4f\x7b\x77\x0f\x4a\x8f\xf7\x94\xb8\xd5\xe3\xa4\x8b\xce\x3e\xc9\x96\x9b\xa2\x88\x46\xe4"
          "\x7f\x83\x19\xfe\x87\xdd\x28\x01\xd6\x27\x76\x67\xe6\x12\x66\x12\xb9\x2d\x22\x04\xd9\x1a"
          "\x49\x61\x4e\x0f\x0d\x34\x72\xcf\xf6\x0a\x58\x53\xc3\x8c\x94\x42\xfa\xcd\x03\xfa\xf8\x0d"
          "\x84\xc8\x81\x00\xb4\x68\x87\x9c\xf4\xc0\x70\xd4\x06\x04\xa3\x6f\x41\xfb\x5a\xc1\x32\x00"
          "\xa7\x7e\x34\x68\x08\x41\x30\x5c\xe4\x6f\xd1\xcd\x96\xcd\x41\xcd\x99\xe5\xfc\x23\xc2\xa9"
          "\xcb\xc2\xa5\xc8\xb6\xb1\x4c\x55\x7d\xb9\xbe\x18",
          1, 1152 },
        { 128, 256, 72,
          "\xdf\xbc\x9c\xd5\xff\x26\x91\x02\xdc\x1e\x45\xce\x44\x74\xa0\x5b\x33\xb0\x0f\x23\xf1\x1f"
          "\x81\x66\x28\x36\xda\x21\x18\x02\x96\x92",
          "\x47\xe9\xc1\x0a\xee\xfc\xb1\x00\xcd\x9f\x6d\xbf\x73\xb1\x92\xdf",
          "\xf0\xde\x60\xb1\x26\x54\xd8\x75\x17\x93\xad\xf4\x22\xe6\xf5\x33\xb7\x51\x22\x00\xee\x40"
          "\x0c\x30\xfb\xe3\x93\x18\xb7\x28\x89\x5e\x89\xb3\x04\xe5\x9f\x43\xf5\x7d\xa9\x88\x12\xb3"
          "\xe0\x0b\x96\x11\x49\x73\x35\x88\x4c\x58\x22\x15\x9f\x26\xac\x45\xd2\x86\x1e\x1e\x7a\x73"
          "\x9d\x26\x38\xbc\xce\xa2\x43\x43\xe7\x7e\x93\x6e\x94\xde\x35\xdc\xa2\xeb\x9f\x25\x15\x04"
          "\x30\xd6\x7a\x33\x16\x0e\xe9\x49\x12\xf8\x63\xe2\x6b\x3b\x4b\xf7\x2b\x06\x62\x5e\x6d\x05"
          "\xe9\xf9\x6c\xfa\x57\xde\x65\x0a\x44\x8d\x5c\xc3\xa3\xd4\x87\x8f\x8d\x6f\x7b\xca\x40\x41"
          "\xb8\x47\x78\xa4\xb9\xc2\xf2\x14\x9f\x0a\xe3\x25\x73\x77\x61\x62\x1b\x26\x12\x07\x4d\xd8"
          "\x6d\xb5\x58\xf7\x1d\xd3",
          "\xac\x4a\xad\x36\x21\x66\x12\xc6\x4b\x97\xbd\xe3\x4a\x78\x6b\xc5\x99\x29\x46\x68\x47\x45"
          "\xac\x1a\x22\x39\x5f\xaf\x1f\xa3\x4f\xe2\x1f\x53\x74\x20\xd5\xf1\xc5\x5b\xbc\xfe\x6c\x27"
          "\x04\x21\xe0\xf0\xa2\x36\x7c\xf0\xd7\x18\x55\x68\x51\x9f\xce\x27\xb5\x52\xc7\x1f\xd5\x80"
          "\x83\x51\x13\xe3\x5e\x4e\x27\x21\x91\x09\x52\xa6\x6b\xd6\x37\xe2\xe9\xdc\xa0\x99\x8d\x8a"
          "\x95\x3e\xa8\xd5\x2a\x19\x6e\xc5\xb0\x3b\x58\xa4\x42\x33\xd9\x6a\xea\x60\xa3\xf6\xc8\x59"
          "\x92\xd4\xf1\x1f\x94\x98\xc0\x88\xba\x03\x29\xdb\x68\xa3\x8c\x10\x5e\xb3\x02\x4e\x05\xa4"
          "\xba\x5d\xaf\xba\x02\x48\xaf\x1e\x1a\xcf\x24\x39\x9e\x5b\x94\x64\x08\xb2\x58\x61\x73\xb5"
          "\x34\xfc\xaa\x5a\x99\x16",
          1, 1280 },
        { 128, 256, 73,
          "\x46\x70\x5e\x92\x2d\x30\x48\x27\xbc\xfc\xef\xdf\xe6\x36\xc3\x8f\xca\x0b\x63\x95\x69\x4d"
          "\x97\xb8\x27\xfa\x2e\xf3\x5d\x44\x04\xb7",
          "\x85\xcf\x36\x3b\x52\xfd\x0b\x92\x9f\x80\x13\x85\x8b\xf9\x3d\xee",
          "\xfd\x1f\xe6\x9a\x57\xb4\x33\x6f\xd6\x6c\xfa\x73\xbc\x0f\x77\xa9\x27\x22\xa8\x76\xb7\x59"
          "\x8a\x1e\x80\x16\x9b\x92\xa5\x6e\xd7\x74\x07\x43\xa3\x29\x80\x6b\xb7\x70\xa8\x2f\x52\x49"
          "\x1a\xb8\xf1\x8f\x8c\x00\x6d\x3d\x51\x97\x2d\x26\x84\x83\x98\xe6\x7a\x46\xaf\x36\x11\x2a"
          "\x98\xbd\xbb\x9f\x2b\x68\xaa\xa2\xd0\xa0\xa3\x50\x38\x0b\x31\x57\x9d\x43\x6f\x9c\xb3\x05"
          "\xf9\x57\x3f\x48\x2a\xef\xd8\x2e\xd4\x75\x68\xe0\x89\x59\x7d\xc7\x9d\x04\x8f\xb4\xad\x37"
          "\xf9\xc7\xd1\x63\xf1\x54\x4f\x86\xb4\x02\xf0\x9b\xdb\x88\x66\xbc\xef\xd1\x5f\x44\x88\xd4"
          "\x69\x4a\x89\x11\xbc\x41\xb5\xd8\x34\x97\xbb\xcc\x19\xdf\x67\xe2\x10\x97\xe8\xbc\x72\x77"
          "\x04\x2c\x1e\xba\x1a\xe2\x40\xa4\x8b\xfb\x98\x3a\x66\x2b\x36\x45\x48\x6a\xd3\xdd\x57"
          "\x41",
          "\xa4\xe7\x6e\xd2\x44\x46\x8a\x1a\x34\x39\x5e\x05\xf5\x40\xee\xc1\xe9\xea\xae\xcf\x6d\x1f"
          "\x78\x9a\x24\xe5\xf7\x70\xbe\x37\xe8\x70\x85\xee\xe1\xf0\x8f\x92\xd6\x71\x20\x00\xf9\x90"
          "\x57\x65\x14\xec\xd9\x37\x46\x08\x0e\xc1\xca\xb0\xa2\xea\x2c\x7f\xbb\x10\x07\x69\xab\x3a"
          "\xaa\x7f\xf7\xa0\x5c\xe7\xcb\xc1\x24\x84\x7b\xac\x39\x27\xfa\x27\x78\x29\x1e\x04\x95\x26"
          "\x42\xe2\x4e\x09\x3b\xf1\x5b\x23\xff\x1d\x90\xf0\xb5\xc3\x7a\x93\x63\x85\x0d\x37\xf7\x1d"
          "\x5c\xb0\x92\xa2\xce\xc3\x73\x5c\x1b\xba\x63\x27\xd7\x3b\x2e\x81\x17\x50\xab\x78\x8c\x4a"
          "\x86\xa9\x34\xcd\xee\x0a\xbe\x3e\xcf\x59\x80\x44\x6b\x59\x72\x45\x0d\xb2\xb4\xfb\xb6\x2f"
          "\x10\x8a\xe1\xaf\xb8\x8f\x27\x13\x6c\x36\xe7\xce\xac\xc2\x77\x4c\x4b\xe0\x23\x20\x92"
          "\xf2",
          1, 1408 },
        { 128, 256, 74,
          "\xda\x4a\xb6\x84\x31\x97\x11\xc8\x4c\xcc\x75\xd0\x89\x82\x68\x2e\x61\x3f\x3a\x18\xfe\xa4"
          "\x46\x04\x97\x66\x01\x55\xa1\x1e\x69\xb0",
          "\xcd\x54\x79\xed\xd3\xa9\x00\xe1\xc1\x6a\xac\x57\x55\xe5\x1a\x83",
          "\xce\x85\x4e\xdd\x13\x88\xfe\x70\xc5\x37\xbb\xaf\xdb\x3e\xb8\x4f\x36\x54\x77\xc3\xd2\x18"
          "\x1a\x9f\x6b\xfc\x70\x63\x13\xe0\xea\x8a\xb4\xd7\x03\xa5\x93\x64\x7a\xeb\x0f\xde\x28\x11"
          "\x49\x82\x81\xec\x55\x0f\xdd\xf8\xe5\xae\x11\xe8\xdd\x26\xc9\x73\x95\x29\xd1\xbb\x26\x4d"
          "\x9b\x3c\x6c\xf5\xf6\x62\x02\x48\xb1\xc2\x87\xe0\xef\x69\xbc\x82\x67\x9a\x86\xde\x21\x01"
          "\x05\x9c\xfc\x9b\x51\xeb\xb6\xfe\xd7\xd7\xa8\x5b\xf4\x9a\xf2\xc3\x91\xc5\x29\xf6\xcf\x5d"
          "\x96\x48\x52\xfd\xa7\xb6\x0c\x1c\x77\x27\x3d\xa0\x3d\x5c\x29\x4a\x6a\xbe\x3c\x3c\xa5\xb3"
          "\xac\x24\xaf\xe9\x82\x89\xb5\x03\x9c\xb8\xef\xc3\xd2\xb6\x40\x97\x82\xab\x3a\x97\xc1\xee"
          "\x12\x74\x4a\xe1\x99\xf0\x2c\x7a\xbf\x4f\x37\xb4\x4f\xa8\x94\xe0\xa1\x0d\xc1\xab\x0c\xd3"
          "\x86\xbe\xd7\xd2\x3b\xe0\x69\x52\x58\xf6\x27\x37\xd8\x79\xb3\xad",
          "\xee\xa7\x79\xb7\xc8\x44\xfc\xf6\x22\xa1\x25\x3f\x3b\x37\xbb\xc1\x40\xd1\x4e\xa1\x2c\x85"
          "\x34\x2c\x00\x3d\x6c\xd4\x8c\x53\x50\xc4\x58\x2d\x26\xf1\x31\xf4\xa7\x4f\x72\x9e\x4c\x50"
          "\xf3\xa0\xd4\xe7\xe0\x6c\xeb\x57\xde\x5e\xb7\xe0\x25\xa3\x7c\xff\x08\x8f\xd4\x24\xcb\x2c"
          "\x3b\xe2\x07\xee\x6f\x76\x30\xd2\xf2\x3d\x6f\x33\x9b\x48\x5f\x59\x19\x83\x20\xdf\xbd\x78"
          "\x17\x58\x3c\x26\x80\x09\xdd\x55\xc9\xbb\x3e\x76\x8b\x8b\x87\xe0\x95\xdb\x54\xa0\xa1\xa9"
          "\x30\x1c\xf0\x47\x5d\x75\xef\xe7\x3d\xf5\xc2\xee\x85\xd8\x14\x93\x51\x47\xb8\x57\xff\xb6"
          "\x5b\x20\x71\x36\xa3\xb5\x7f\xd2\x69\x28\xa4\xc0\x0a\x54\x9b\xaa\x04\xcb\xb8\xb8\x7b\xc5"
          "\xfd\x1e\x84\xe2\x0e\x2d\x2b\xdb\x5d\x02\xed\x10\x40\x07\x52\x78\xc5\xa8\xb0\x66\x24\xc1"
          "\xc9\xf2\xb0\x3d\x8e\xb2\xa6\x56\x0b\xbb\x20\x93\x4f\xff\x18\x8c",
          1, 1536 },
        { 128, 256, 75,
          "\x18\x6e\x2b\x09\xfc\x5b\xc5\x65\x82\x75\xac\xbe\x69\xed\xf7\xbb\xcb\x90\xcc\x4e\xe4\x3b"
          "\xea\x66\xe5\xcf\xb8\xe2\xc1\x7a\xa4\x85",
          "\x5d\x1c\x2b\x9e\x73\x18\xd6\xaa\x6d\x9e\x79\xa7\x3c\x27\x32\xeb",
          "\xa4\x9b\x95\x69\xae\x46\xb1\x3d\xde\xe4\x1d\x2d\x4e\xbc\x98\x1c\xaa\x53\xb3\x7d\xa2\x15"
          "\x35\x54\xed\x5b\xf8\x40\xe0\xcc\x08\x02\xe7\x10\xb2\x36\x6c\x71\xe5\x8e\x72\x75\x39\x12"
          "\x19\x6b\x87\xda\x9e\xc2\xd9\x20\x60\xe4\x24\xe3\xeb\x95\xc7\xf8\x4b\x75\xd4\x43\xac\xe4"
          "\x99\x87\x78\xbc\x1e\x4e\x95\x2e\xfa\xcc\x43\x93\x88\xca\xae\x57\xa4\x37\x4c\xfb\x56\x68"
          "\x73\xd0\x0a\x8b\xba\x80\x86\xfa\x1e\x14\x36\xd5\xd8\x34\x20\xf2\x1c\xc8\x0b\x50\x69\x2d"
          "\x5a\xbb\x86\xca\xc6\x0f\x07\x43\x0a\x3f\x1a\xd6\x20\xae\xb1\x01\x16\x35\x7f\x5e\xb0\xcb"
          "\x7e\xd5\xa0\x73\x6c\x67\xb5\x65\x7a\xad\xc7\xf2\xef\x4f\xcf\x96\x27\x57\xf6\xa8\xf0\x00"
          "\x42\x2f\x31\xb7\x09\x93\x4b\x60\x18\xe8\x7f\x47\x81\x35\xf5\x11\xde\x36\xe3\xe9\x34\xe8"
          "\xd7\x96\xad\x5d\xbd\x8a\x1d\x60\x09\xae\x76\xd3\x23\xe1\xcb\xa1\x34\x66\x6c\xd9\xb9\x47"
          "\x1a\x42\xc7\x43\x9f\x55\x2e\x3c\xc0\x65",
          "\x46\x31\x9f\x0c\x4c\xba\xb0\x2d\xd7\x98\x72\x6a\x0d\x96\xcb\xf3\x56\x42\x7f\xba\x7f\x5d"
          "\xf6\x52\x33\x8b\x7d\xd3\x40\x67\xc0\xcb\x13\x96\x30\x82\x1d\xbf\x5d\x9a\xaf\x09\x76\x94"
          "\x6c\xa5\xd5\xe0\xdb\xcf\x61\x7d\xe7\xc3\x76\xc6\x36\x75\xdc\xf6\x87\xd6\x74\x58\x50\x83"
          "\x58\x11\x4f\x1b\x10\x0c\x9a\x8d\x61\x51\xa0\x05\x16\x5a\x65\x53\x53\xe6\x5e\x14\x72\xab"
          "\xba\x4e\xa8\x0b\x71\x68\x29\xeb\xa4\xa1\x2d\xdc\x0a\x16\x84\x97\x1c\x5a\xce\xf1\xd9\x0a"
          "\x24\xab\xa7\xa2\x88\xe8\x34\xc4\xe5\xa4\x6d\xac\x4f\x28\xa4\xa6\x4f\xd3\x99\x1c\x1d\xb4"
          "\x8e\x6f\x87\xbb\x58\x2a\xc1\x15\xd5\x1c\x4a\x99\x48\x07\x74\xeb\x8d\x5a\x3e\x6e\xa6\xdc"
          "\xbe\x20\xb1\x35\x1a\xe9\xd5\x49\x41\x6f\x65\xd6\xe2\xd7\x8d\x69\x58\x50\xaa\xae\x11\x93"
          "\x43\x95\xb3\xf7\xa0\x77\x7e\x25\x8b\x20\xc5\x56\xd5\xdf\x60\xe7\x75\x3c\x73\x09\xbd\x34"
          "\xa1\xea\x17\x36\x0a\xec\x83\x6d\xf1\x0c",
          1, 1664 },
        { 128, 256, 76,
          "\x90\xcd\x3c\xba\x11\x54\x66\xa7\xea\xdb\xca\x9a\x05\x5b\xd0\x4c\x44\x76\xa2\x6e\xa1\x97"
          "\x55\xe8\xa6\x07\xe3\x39\x60\x54\x32\x44",
          "\xa4\xf0\x24\xb9\x91\x7d\x7c\xff\xf1\x00\x77\x60\x98\x11\x46\x24",
          "\x27\x1a\xde\xec\xfd\xca\xc8\x5f\x27\x0a\x00\xc6\x2f\x92\xea\xef\xe2\x19\x92\xc7\x89\x9b"
          "\x67\x62\x2b\x77\x63\xfb\x34\x73\xc3\x43\xa6\xcb\x28\x6e\x9e\x67\xe4\xf5\x24\xe9\x91\x6b"
          "\xf0\x5b\xc6\x7f\x9e\x6c\x4d\xa0\xe7\xc2\x40\xd8\xb0\x20\xb8\xd7\x6e\x23\x60\xb2\xeb\x6e"
          "\xcf\x39\xf7\xcf\xbc\x65\xbf\x83\xfa\xcb\x28\x17\xd0\xac\xb1\xf6\x40\x6c\xc3\x15\x32\xd5"
          "\xf3\x8c\x4e\xe5\xfe\xb5\x7a\xd2\x93\xbc\x5f\x31\x08\x62\xfa\x4c\x6e\xaa\x3b\x57\x8a\x96"
          "\x40\xbd\xc8\x01\xdb\x31\x72\x8b\xa4\xec\x86\x5b\x6b\x09\x01\x8a\x84\x59\x81\x15\xaf\x1b"
          "\x10\xed\xac\x96\x96\x75\x80\xb8\x70\x49\x23\xcc\x0b\x34\xb8\xa4\xed\xe6\xfd\xef\xc1\x91"
          "\x3d\xd0\xd4\xf7\x76\xa9\x01\xce\x17\xb5\x9c\x95\xc7\x0c\x4a\x4b\x98\xfd\x69\x61\xa0\x24"
          "\xe5\xd6\xbe\xfc\x19\x6e\xb2\x83\x1f\x6a\x92\xa9\x10\xa4\xe4\x5a\xcf\x41\xad\x08\xf6\x79"
          "\x7d\xcb\x2e\x96\x39\x58\xcf\x1e\x46\x62\x22\x09\x22\x98\x06\x81\xf5\xbe\x47\xfd\xe4\x86"
          "\xed\x54\xdf\x57",
          "\xcc\x25\x92\xaf\x64\xea\x74\x4b\xb2\xa7\x62\x5b\x09\x50\x53\x02\x99\x01\x81\xc6\x2a\xc3"
          "\x5d\x65\x3b\x2b\xd2\xcc\x76\x02\x98\x9a\xb6\x75\x44\xd0\x93\xcc\x59\xd3\x52\x19\x26\x9e"
          "\x4b\x8a\x63\x44\xaf\x4b\x66\x25\x94\xc0\x85\x73\x1b\xde\x53\x50\x7b\xae\xf1\xeb\x80\xd1"
          "\x2b\x33\xd2\x40\xf8\xd5\xea\xf7\x10\xea\x6f\xc5\xa0\x28\xd0\x31\x91\x9a\x61\x9e\x73\x2a"
          "\x6e\x83\xb8\x94\x5c\x48\x02\x5f\xab\xc9\x00\x8e\x38\x18\x8c\x34\x39\x0c\x03\x70\x03\x5d"
          "\x02\x45\xfa\x04\x59\x61\xd5\xd7\xc8\x97\x7c\x0f\x40\x83\x4c\x1d\xeb\x28\x05\xe0\xf6\x2e"
          "\x90\x21\x4b\x52\xa1\xcb\x05\xa3\x80\xf2\x95\x94\xb5\x0f\x61\x22\x7a\x18\xab\x9e\x70\xae"
          "\x6c\xd9\x46\x82\x94\xc7\x5c\xe3\xa2\x29\xab\x85\x51\x4a\xbb\x7f\x92\x1c\x7e\x23\xf9\x89"
          "\xfb\x3c\xc8\x4f\x52\x10\xed\x88\x21\xf0\xf9\x04\x78\xfb\x23\x93\xb8\xbf\x2f\xa5\x23\xee"
          "\x91\xf3\xd6\x2d\xb3\x9f\x06\x12\x8a\xa2\x5c\xdb\x53\x8c\x23\xf4\xd5\xf4\x81\xe5\xa6\xd7"
          "\x55\x08\x6e\x61",
          1, 1792 },
        { 128, 256, 77,
          "\xc2\xf8\x2a\x50\x70\x76\x27\xde\xce\x75\xaa\x6e\x46\x5f\x48\xa4\xc7\xfa\x94\x35\x5a\x3a"
          "\xde\x10\x5c\xc6\x6e\x86\x30\x02\x55\xa5",
          "\x48\xb6\x9d\x11\x52\xbf\x1a\x43\x13\x39\xdb\x35\x91\x69\xaf\x62",
          "\xa2\x94\x56\x42\xb3\x4f\xac\x9a\x6e\xc6\xb6\x36\xae\xe4\xb7\x9f\xf0\xb5\xf5\x46\xa1\xd2"
          "\x27\x65\x4d\xfa\x69\x64\xc7\x65\x27\xd5\xd1\x71\x13\x3d\x72\x3a\x9c\xcf\xf6\xd5\x57\x4e"
          "\xc6\xb3\xa3\xd0\xea\xf9\x01\xc4\x02\x99\x2c\xb1\xe3\x52\x82\x6d\xea\x51\xa1\x02\xc8\x14"
          "\x83\xcb\x46\xa3\x9e\x20\x9c\x8e\x8b\xeb\x59\xba\x84\x05\xca\xf3\x2b\x86\x3a\x3e\x79\x80"
          "\x43\x25\xc7\xff\x2b\xa0\x6a\xa1\x6a\xf5\x9b\xed\x49\xb9\xa3\xb6\x31\xe4\xe1\x91\x77\x68"
          "\x65\x57\x3e\x40\xa4\x73\xbe\xd5\xb9\x2e\x9d\x40\x88\xec\xf4\x3f\x61\x83\x0a\x7e\x43\xc4"
          "\x1e\x9e\xd6\xe4\xc4\xdd\xc2\x25\xbc\xa8\x70\x0b\xe3\x20\x76\x6b\xcb\xff\xda\x65\xf6\xe6"
          "\x83\xb9\x35\x91\xc8\x8a\x12\x67\xc5\xff\xda\xd1\x5a\xe6\x2f\xc1\x92\x16\xc3\xe3\xb6\xc9"
          "\x1b\xa9\xe9\x2d\x53\xa9\xa2\x15\x4d\xab\x2a\xdb\xd5\x61\x3a\xe0\x65\x1f\x92\xe4\xb2\x71"
          "\x04\x4b\x50\x97\x67\xc5\x37\x58\x48\x7e\x76\x99\x24\x25\xe3\x26\x8f\xaf\xec\xa8\xcc\x0c"
          "\x61\x72\x54\xb6\xc6\x0b\xc3\x89\xa3\xd4\x39\xe8\x9f\xb2\xa9\xae\xb8\xaa\x80\xbd",
          "\x76\x0c\x39\xa5\xf4\xc5\x3f\x4e\xa0\x8c\x8e\x33\xf2\xd0\x5e\x78\x69\x78\xdf\x4f\xb8\x88"
          "\x73\x5e\xd5\x70\x49\xb5\xff\xd1\x32\x73\xb9\x78\x21\xd0\xb0\xd7\x76\xa5\x28\x62\xf0\x84"
          "\xfb\x0f\x2b\x87\x07\xb6\xde\xd7\xcb\xdc\x78\xa5\xa7\xde\x03\x4b\xeb\x09\x1e\x0d\x95\x04"
          "\xeb\xeb\xb2\x8c\xa9\xfa\x56\xa2\x5d\x39\xb4\x65\x87\x45\x4b\x86\xfa\x08\xa0\x3d\x6a\x5c"
          "\x47\x06\x8f\xef\xdb\x8d\xce\xa5\xa1\x7f\x91\x76\xd7\xe1\xf2\x19\x33\xfb\x9b\xee\x20\x8f"
          "\x7e\xe7\x06\x3a\xd4\x0f\x85\x33\x0c\xf1\xe9\x89\xd7\xdf\x55\xac\xe7\xb2\xe5\x28\xa2\x98"
          "\x83\x28\x98\xaf\xf0\xfa\x64\x9c\x97\x5c\x22\xf5\x33\xaa\xaa\xb9\x6c\x25\x25\x37\x89\xe2"
          "\x60\x72\xa0\xf6\x0f\x1c\x17\x85\xb6\xb8\x75\x3f\x02\xca\x19\x92\xa4\xd1\x63\xdf\x49\xda"
          "\x5b\x0b\x14\x6c\xb3\xb3\x38\xa6\xb0\x83\x28\xac\x74\x71\x90\x41\x4c\x57\xfa\x56\x55\x72"
          "\x52\x04\x56\xc4\x73\xa5\xa4\xd3\x03\x67\xc7\x83\xfb\xdc\xe9\x1c\x8f\x34\xbd\x5d\x94\x40"
          "\x54\x49\x28\xa3\x63\xfa\x0f\x54\xd4\x17\xd2\xb2\x80\x2d\xce\x74\xe4\x39\x06\x1f",
          1, 1920 },
        { 128, 256, 78,
          "\x54\x60\xed\x05\x6b\xa3\x06\x5d\x88\xe6\xb4\xef\xa6\x10\xf4\x8f\x31\x1a\xb4\xca\x3b\x46"
          "\x38\xc4\x98\xe5\xe6\xda\xb1\x25\x2a\xe9",
          "\x84\x30\x74\xca\xe3\xe2\xa1\xec\x22\x67\x3f\x01\x1a\x4e\x15\xa5",
          "\xb3\xc6\xde\xf9\xf9\xd5\x1d\x29\xde\x8b\x65\x1e\x51\x9e\xb8\xf6\xcc\x5f\xda\x2e\x8c\xaf"
          "\x5a\xab\x0a\xd4\xdd\x9b\xf1\x3f\x22\xa9\xb2\x3a\x52\x5a\x28\xf4\x6e\x23\x2a\xfc\xf7\x3d"
          "\x47\xfc\x0f\x3b\x2b\x7f\x03\x2b\x5b\xe4\x27\xd6\x0c\x11\x0f\xb7\xe7\x29\xbc\x63\xc3\x59"
          "\x55\x89\xbe\x8f\x1b\x99\x90\xa9\xfd\xa7\xc8\x9f\xf6\x91\x73\x17\x63\x0a\xa6\x07\x2b\xa5"
          "\x4b\x78\xcb\x15\x85\xd7\x5e\x20\xd7\xec\xe7\x29\x24\xf8\xdf\x6f\x92\xc2\x77\xaa\xb8\xf6"
          "\x64\x30\x2b\xbc\xa7\xe1\x42\xd3\xc0\x0e\x96\x5e\xa0\x94\xea\x2a\x0f\x47\xf5\x9d\x7c\x0f"
          "\x0c\xe4\x5f\x38\x8f\x83\xa9\x7f\x85\x99\x43\x87\xcb\x83\x2e\x33\xeb\x7f\x79\x00\x85\xab"
          "\x90\x66\xc0\x6d\x89\x12\xc4\x36\x86\x6d\x2b\xd6\x78\xed\xb5\x1f\x0b\xf6\x9a\x6f\xee\x6d"
          "\xd0\x07\x53\xc1\x35\x0a\xba\x3b\xa7\x32\x33\xbb\xb2\xb6\xd8\x99\xdb\x04\x4b\xfc\x67\xad"
          "\x39\x2c\xfc\x51\x73\x58\xcb\x4c\xbd\xb4\x29\x6b\x2b\x46\x99\x8e\x23\xea\xc9\x88\x48\xf9"
          "\xb1\x36\xed\x32\x02\x67\x28\xe8\xf7\x42\x54\x28\x04\x89\xae\x01\xaa\xe2\x66\x52\x71\xb0"
          "\x7f\xa7\xff\xeb\xc6\x7f\xfa\xad\x07\x93\x4a\x6f\xf3\x4f",
          "\x9e\x63\x30\x3a\x5a\x27\xba\xe4\xbc\xad\x33\x1c\x37\x6a\x0f\xaa\x3c\xad\x81\xca\x3e\xac"
          "\x63\x56\x4d\x58\x79\x21\xd3\xe7\xd7\x19\x31\x40\x8c\x21\xe7\xb6\x56\xc3\x34\x42\xaa\x49"
          "\xbb\x01\xbd\x45\x07\x32\xab\x8d\x32\x30\x3f\xa5\x3d\x9d\xa7\xc2\x7b\x5a\xee\x88\xe9\x3f"
          "\x5a\x29\x90\xe3\xe6\xbd\x6f\x3a\x74\x82\x5a\xb5\x52\xed\x1e\x1d\x72\x15\x90\x01\x95\xff"
          "\x16\x15\xd8\xc2\x8d\xfb\xd3\xa2\x7f\x06\x2e\x17\xe0\x93\xb7\xdb\xae\x9d\x62\xc9\xc6\xcd"
          "\x4b\xdc\xa0\xfc\xe2\x9b\x48\xad\xfe\x6c\xc8\x93\x6c\x92\x6a\x7f\x6c\xc4\xe4\x16\xde\x94"
          "\x70\xed\x15\xf7\xa3\x2e\x0f\x41\xbf\x6c\xc1\x0b\xd4\x6e\x08\xdc\xe6\xe1\x5b\xb6\xe0\xfe"
          "\xfb\x48\xc9\x6b\x10\x8a\x33\xcc\xdc\x6b\x81\x47\x58\xdf\x74\x6f\xdd\xd4\x5f\xe3\xad\xea"
          "\x48\x05\xef\x61\xb6\x8c\xfa\x70\x32\x36\x9c\xb0\xb7\x00\xdc\x9d\x68\x2a\x81\xf9\x25\x39"
          "\xa6\x05\x16\xef\xc7\xc4\x4f\xa0\x54\xbd\x05\xb4\x78\xc2\x04\xc1\x36\x44\x2d\x8c\x64\xb7"
          "\x30\xf5\x75\xb8\x3b\x29\x22\xf5\xc4\x48\xef\xb7\xa5\x30\xf5\x9f\xd8\x5b\xe9\x0f\x14\xd9"
          "\x67\x86\xaf\xf4\xb7\xa1\xed\x63\x1e\xed\x87\xf8\x03\xec",
          1, 2048 },
        { 128, 256, 79,
          "\x62\xac\x39\x1d\x2a\x14\x09\x4d\x23\x98\x46\xa1\x22\x50\x67\x72\x86\x75\x3a\xc3\x18\x2b"
          "\x3a\x6d\xd8\x96\xe1\x68\xe6\xe4\x57\xab",
          "\x78\x71\x85\x23\x19\x60\xe4\xb1\x71\x77\x89\x8e\x4b\xb8\xad\x81",
          "\xc0\x68\x97\x7d\x39\x18\x5f\x73\x54\x24\xe2\x4e\x66\x19\x74\x66\x2c\xa0\xfb\x87\x22\x7c"
          "\x4a\xae\x16\x87\x8b\x9d\xbd\xac\x23\xce\xa6\x6c\xf8\xa4\xf6\x79\x81\xf2\x58\x47\x53\x73"
          "\x70\x3b\xa6\x9d\x3e\x4b\x33\x97\x50\x4c\x50\x11\x61\x19\xf1\x64\x84\x42\x43\x1f\xc8\x11"
          "\x29\x75\xc4\x7b\xb6\xc5\x36\xfc\xfc\x3a\x59\xc2\xaa\x18\x8f\x19\xd9\xd4\xa7\xd3\x2a\x52"
          "\xae\xba\x47\x02\xc6\x33\xeb\x5f\x58\x43\x89\x9f\x88\xdd\x1b\x12\x0b\xf4\xf9\xbf\x67\x5b"
          "\xca\x66\xf9\xf8\xd7\x3b\x30\xec\x60\x56\xa8\x3e\x56\xba\xf2\x7c\x54\x5b\x7f\x23\x96\x90"
          "\xdc\x35\x98\x97\x48\x2a\x7d\xf6\xf1\xba\x81\x28\xec\x2f\xe1\x3c\xfd\x1e\x2c\x97\xf8\x01"
          "\xa9\x00\xfd\x00\xa9\xcc\xa3\xc8\x7b\x90\x71\x61\xa4\xe5\x8a\x3c\x4e\x03\x46\x10\x1b\x99"
          "\x3a\xb6\xfb\xc2\x58\xd8\x73\xe6\xf1\x05\x08\xb4\x8a\x54\x58\x91\x82\xd9\x65\xf9\x2b\x2d"
          "\xc3\xc7\x5c\x71\xaf\x12\x3e\x76\xe8\xf9\xb5\x19\x03\x88\xdc\x18\x1c\x07\x8a\x94\x45\x46"
          "\x7e\x3c\xe2\xf1\x4a\xa6\xb0\xb4\x77\xe9\x4f\xd0\x1c\x2a\xd2\xac\xe7\x61\xe3\x9b\xb8\xd4"
          "\xd5\x72\x9c\x91\x20\x6f\xd4\xe0\x11\xbf\x3f\xa7\x2c\x91\x61\xe8\x7e\xf7\x82\x87\xfb\x8a"
          "\x8d\x44\x5f\xa7\x5e\x2c\x7d\xc6",
          "\xaa\x4f\x08\x63\x77\x74\xfe\x48\xe2\x37\x65\x7f\x61\x28\x82\x58\x87\x19\xc6\xa0\x8a\x08"
          "\x47\x3f\x2f\x85\x20\x71\x5e\xc9\x6c\x30\x7e\x0e\xa4\xef\xc8\x35\x88\xdd\xc7\xc3\x81\xfb"
          "\xd7\xcd\xea\x9f\x27\xb2\x2f\x33\x24\x2e\x52\xcf\x93\x73\x78\x68\x81\x2d\x54\x8f\xa1\x7c"
          "\x7e\xa8\x68\xc4\x8d\x8d\x5c\x66\xa4\x05\xfe\xff\xc1\x46\x31\x07\xe7\xf8\xad\x60\x58\xef"
          "\xd3\x9f\x29\xb4\xc7\x8d\x7a\x34\x62\xe7\x70\x8e\x32\x61\x36\xc4\x06\xca\x54\x9d\x66\x47"
          "\x51\x8c\x52\x1c\x54\x78\xe5\xd3\xac\x7e\xe2\x16\xcd\x19\x31\x74\xd3\x68\xfb\x17\x58\xbd"
          "\xbe\xac\x87\xc5\x1d\xde\xc3\xda\x3e\x2b\xea\x55\xaa\xcc\x03\x95\x81\xde\x77\x1b\x23\x25"
          "\xd3\xef\x68\x53\xe4\xf4\x03\x11\x8b\xb4\x47\x22\xd7\x9a\x8a\x07\x31\x74\xf0\xd3\xb8\xcb"
          "\x62\x7f\x3b\x6a\x53\x71\xc4\xfe\x8b\x94\xfe\xdf\x06\x48\x70\x70\x3f\x43\x08\x6b\x24\x28"
          "\xa1\x1f\xa1\xe2\x71\xf0\xab\xad\x2c\x3d\x6f\xdb\xe3\x48\xfe\x0e\x9a\x6b\x7f\xfe\x7e\x37"
          "\xe3\x28\x07\x98\x68\x13\x37\x63\xa8\xd7\x6e\x70\x82\xb5\x22\xfb\xc6\x1d\x41\xbf\x83\xa5"
          "\x3d\x14\x65\x3a\xce\x28\x40\xdc\x61\x29\xba\x43\x78\x7a\xdd\x03\xf3\x18\xd6\x9a\x29\xe8"
          "\xf2\x73\x1f\xf6\xd9\x3f\xbf\xf4",
          1, 2176 },
        { 128, 256, 80,
          "\x21\x81\xa2\xb1\x66\xed\x25\xf0\x1a\xed\x5a\x21\xca\xf1\xf5\x2a\x8a\x78\x18\xeb\x0a\x0b"
          "\x9f\xc4\xd3\x6d\x3a\xe3\xe1\xef\x67\x02",
          "\xec\xa5\xf8\x61\x0e\xf4\xaa\x28\x27\x67\xd2\x71\xfe\x5e\xfc\x68",
          "\xf0\x56\xf0\x7d\x6c\xfc\x74\xef\x51\x5a\x9f\x8f\x29\xfa\xbd\xe5\xea\x7f\x4f\xbb\x68\x52"
          "\xc5\xdc\xc7\x9a\x2c\xb9\x7d\xdd\x08\xa0\x8c\xd8\x93\x5b\x8b\xf2\xc8\xdf\xfc\x50\xda\x2b"
          "\xb7\x86\x30\x8d\xb3\x0e\x8a\x69\xc0\x80\x97\x4c\x6d\x1a\x4f\x53\x28\x30\xb2\x84\x50\x61"
          "\x55\xf2\xa8\xa5\x2e\x2a\x33\x72\x70\x7b\x4a\xfd\xf3\x20\x3b\xd5\x53\x54\xd2\xbe\xcd\x90"
          "\xac\xc9\x86\x9e\xb9\x4a\x09\x87\xc5\x56\x2f\x58\x43\x5a\xb7\x32\x20\xed\x44\x07\x08\x53"
          "\x7e\x87\x52\xe1\x80\x4e\x6f\xce\xdd\x59\x69\x95\xfe\xd7\x7c\x82\x43\x3d\x56\x88\xa2\xcc"
          "\x27\x66\x50\x0f\xa3\xc1\x39\x93\x1b\xd8\x40\xe3\x95\xa5\x11\x5f\x11\x07\x4d\xde\x6d\x59"
          "\xfe\x9e\xcb\xf7\x6e\x99\x1f\x11\xd2\x54\xca\x17\x6a\x11\xee\xc0\xae\xb8\x80\x2d\xa7\x13"
          "\x6d\xd5\x02\x59\x32\x3c\xa9\xfa\xe1\x39\x3e\x68\x17\x3e\x8d\x07\xde\x29\xb9\xaf\x38\x63"
          "\x08\x9b\xed\xce\x59\x4a\x6f\x29\xe6\x6a\x6d\x10\x86\x8c\xf0\xfe\x00\xdd\x3b\xd2\xe7\xc9"
          "\xad\x63\x32\x5d\x3e\x5d\x0a\xfd\xd7\xac\x83\x3f\x9f\x42\xa0\x22\x55\xe1\x1a\x73\x89\x80"
          "\xc9\x23\xc6\xda\x34\x5f\xed\xc9\xeb\xaf\xf3\x7e\xf3\x8d\x43\x9c\x66\x87\x3c\x96\x51\x75"
          "\x60\x74\x8b\x97\xa8\x36\xe6\x43\xfc\x2e\x14\xc2\x7f\x1e\x3e\x2f\x04\x64\x5b\x77\x07\xcc"
          "\xdd\x60",
          "\x42\x41\xa5\x7f\xe5\x4a\x13\x1b\xb9\x33\x13\x19\xa4\x44\x30\xc5\x1e\x3e\xbc\xf5\x12\x6c"
          "\xe5\xf9\xca\x22\x8f\x36\x6a\x0f\xf5\x1a\xb9\x81\x67\x17\xf6\xd9\x80\xfe\xf7\x47\xcc\x98"
          "\xbd\xd6\x99\x49\xf9\xbd\x73\x96\xf5\xdd\xd4\x6f\xfa\xf0\x9b\xa9\xcd\xce\x42\x60\xbe\x8e"
          "\xe6\x03\x87\x75\x94\x24\xda\x59\x4c\x1e\x0d\x7c\x20\x07\x6c\x97\x79\x02\x64\x58\x33\x80"
          "\x8d\x22\x80\xc4\x2d\x70\x7d\xec\xac\xaf\x9b\xc0\x49\xb8\x6c\x43\x83\x1d\x40\x27\x34\x98"
          "\x68\x73\x60\x70\x66\x93\x54\x03\x22\x45\x82\x65\xbb\x5d\x4e\x79\xc5\x81\x63\xfc\x7c\x92"
          "\x64\x4d\x15\x6a\x59\xda\x62\xb8\xc5\xd5\xc8\xd2\xbf\xb6\x7d\xc3\x67\x43\xd8\x37\x65\x65"
          "\x44\xba\x1e\x35\x6f\x49\xc3\x89\xf2\xb5\x3b\xdf\x4a\x95\xcb\xcb\x43\x0e\x55\xbb\x7f\x68"
          "\xfb\x64\xdd\x1d\xe5\x97\xf1\xef\x77\xae\x37\x95\x0e\x6e\x35\xb9\xdd\x31\x17\xd7\x00\x73"
          "\x71\xe3\x75\x35\x73\xe4\xdf\x0b\x91\x57\x02\x6b\x7a\xf7\x4b\xe8\x85\x32\x14\xf3\x3f\xf3"
          "\xb2\x93\x99\xa5\x55\x67\x05\xc5\x7a\xa3\x10\x2c\x2e\x6b\xbd\x17\x88\xa5\x3f\x26\xb6\xd5"
          "\x8f\x7f\x8b\xe9\x4a\x80\xdf\x3a\x7e\x49\x0d\xa5\x3c\xc7\x4c\xe8\xb8\x8b\x84\x7b\x01\x90"
          "\x0b\x1b\xbd\xa8\x16\xe0\xfc\x3a\xc5\xd6\x72\xdf\x8b\xa2\x3e\x5b\x8b\x6a\x3e\x14\xd1\xfd"
          "\xb9\x30",
          1, 2304 },
        { 128, 256, 81,
          "\xf6\x29\x7e\xcd\xd3\xdc\x82\x06\x98\xbf\x04\xab\x78\x6b\x3a\x67\x54\xba\xee\xc6\xc2\x8e"
          "\x68\xa2\x0c\x13\x23\x34\xa5\x8f\x01\x9e",
          "\xa4\x42\xeb\xeb\xe9\x67\x97\x74\xbb\x4c\x27\xf2\xbb\x33\xff\xf7",
          "\x9d\x17\xbc\x84\x69\xa0\x43\xfe\xbb\xbc\x45\xa4\xf6\x8f\xc0\x28\xad\xaa\x32\x1d\x33\x11"
          "\xd7\x40\x21\xd3\x28\x7a\xab\x7d\x8e\x40\xa2\xe6\x81\x2e\x39\xec\x51\x9f\x24\x8c\x0e\x13"
          "\x54\x85\x42\xa3\x0c\xa7\xb5\x3f\x3f\xc8\x8e\x4c\x93\xdb\xf5\x7d\x0f\x0e\xaf\x37\x26\xe0"
          "\xf1\x57\x2e\x4f\x3f\xda\x7f\x65\x91\x80\x66\x51\xa6\x66\x89\xd4\x23\x14\x15\xab\xed\xc1"
          "\x6d\x73\x9b\x99\xdc\x47\x96\xe4\x93\x67\x9b\xf9\xe1\xd5\x10\xf7\x13\xf7\x37\x51\x20\x7b"
          "\x5f\xe3\x45\xb0\x76\xf1\xc6\x5f\xff\x0d\x97\xb7\x2f\xbd\x6a\x20\xbe\x1f\xcc\x21\x8f\xed"
          "\xeb\x43\xd7\x00\x0c\x53\x52\x55\xd3\x81\x14\x03\x7a\x0f\xf3\x8e\xe9\x73\xd5\x42\x01\x98"
          "\x49\x08\xb6\x19\x05\xf3\xe9\x1a\x72\x39\xdb\xb4\xfe\xef\x60\xc0\x4d\x0c\xc8\xc9\x79\xe8"
          "\x1c\x99\xba\xd2\xfe\x71\xa7\xd4\xbb\xbc\xa4\xed\x66\x5d\x2f\x96\x09\x12\x3b\xf4\xc5\x12"
          "\x50\x71\xda\x76\xf1\x59\xb2\x29\x9b\x56\x7e\xef\x55\xa3\xbe\xf4\x49\x8a\x66\x32\x63\x58"
          "\x3c\xa6\x69\x58\xf2\x76\xfe\x16\x1d\x8e\x65\x92\x3d\xed\x20\x29\x1e\xd1\xfa\x19\x86\xcd"
          "\x38\xe1\xc9\xcf\xdd\xbf\x06\x82\xac\xd1\x32\x3d\x92\x22\x39\x7a\x9e\x69\xcb\xb3\x51\xa5"
          "\xb7\x0b\x3c\x3e\x4a\xbf\x45\xfd\xa6\xac\x87\x3e\x24\x5b\x30\x04\xe5\x08\x70\xd4\xf8\xb1"
          "\x36\x75\x30\x8d\xc2\xe8\xfc\x78\x5f\xae\x82\x87\xd9\xe6\xad\x08\x47\x18",
          "\xa8\x61\x0b\x64\xa3\xa4\xbe\x13\x9a\x3f\x30\xff\x40\x0e\x88\x87\x98\xac\x06\x17\xc1\xe7"
          "\xbb\xbf\x8a\x85\x1c\xa5\xc0\x5b\x35\xa2\x70\x30\x00\x86\x64\xb8\x83\xd4\x41\xa0\x25\x77"
          "\x15\x85\xde\xcf\x8e\xb2\x53\x3d\x46\xe2\x24\x8c\x8f\x10\xb6\x78\x81\x3b\x29\xfb\xfc\xce"
          "\x97\xb3\x4a\x9e\x7f\x6f\xb9\x61\xc0\x44\xa0\x81\x9b\xed\x64\xff\xef\x58\x05\x8c\x59\x89"
          "\x08\x15\xc6\x86\x9a\xed\x93\xfa\xd5\x4f\x4e\x1a\xf8\xd0\x0c\xd3\x40\xb3\xd1\x93\x6d\x19"
          "\x05\xae\x7d\x57\x5e\x90\x5e\xe5\xa3\x45\x21\xb4\xac\x35\x74\x15\x4e\xd9\x52\x93\x68\x4b"
          "\xf5\x51\x69\x3c\xca\x5c\x67\xda\x7b\xc1\xa2\xc2\xff\xca\x3e\xb3\x97\x1d\x3d\x92\xb1\x14"
          "\x50\x6d\x97\xa7\x3f\x6f\x2a\x53\x9f\x18\xe2\x76\x72\xa5\xb1\x6a\xa1\x38\x91\xc7\x5a\x62"
          "\xaa\x67\x54\xb6\x08\xce\xe1\x57\xb9\x78\x3a\xdd\x51\x46\x78\xf7\xbe\x1c\xd3\x2b\xc5\xbc"
          "\x05\x10\xcd\x75\xb5\x26\x1f\x4d\x7d\x1f\x7a\x6b\x55\xba\xd5\xb2\x74\xc8\x8c\x8c\xbe\xbe"
          "\x28\xfd\x32\xe4\x38\x50\xe3\x3e\x0a\xb5\x07\x5e\x7e\x37\x96\x26\x31\x5d\x67\x73\x97\x43"
          "\x89\xc9\x0f\xfa\x65\x00\x05\xc9\xa8\xdd\xa6\x78\xdf\x5c\x7d\x80\xe2\xc4\xb9\xa0\xe7\x21"
          "\x61\x59\xf6\x0d\xc1\x57\x78\x5e\x79\x87\x68\x6e\x3a\x13\xb1\xab\xba\xa5\x36\x7e\xca\x36"
          "\xea\xeb\xa5\x4f\x0a\xbc\x7f\xea\xe3\xda\x56\x21\x35\x09\xd8\x23\xbe\x7c",
          1, 2432 },
        { 128, 256, 82,
          "\xb2\xe4\x5e\xe9\x58\x4e\x53\x41\x9d\xe0\x6d\x33\xe3\x49\x53\x22\x22\xa8\x6e\x5c\xe6\x08"
          "\x51\x0c\xde\xc2\x32\x1a\xe2\x33\x0d\xec",
          "\xe1\x84\x63\x01\x18\xbe\xee\x0c\x8b\x14\x04\xd6\x67\xc0\x46\x37",
          "\x6c\x4c\xee\xe0\xf4\xeb\x85\xe8\xfe\xe1\x60\xf2\x15\x8f\x9a\xab\xd0\x24\xae\xe9\x76\x65"
          "\xa8\xfa\x95\xe4\x2a\xd7\xed\x9c\x17\x5d\xa1\xed\x5a\xc7\xd4\x17\x56\x6e\xdc\x40\xa2\x5d"
          "\xc2\xc1\x0e\x78\xf8\x2e\xcc\x8f\xda\x46\xe0\x06\x94\x78\xe1\x3f\x66\x3b\x6f\x87\x7d\xf6"
          "\x36\x17\xec\x64\x58\xa7\x97\x14\x2d\xb3\x69\xe3\x50\x13\xbc\xd8\x80\x70\x22\x81\x2b\xb4"
          "\xff\x8c\x33\xd0\x67\xad\x40\x7b\x25\xa0\x25\xb9\xcc\xd6\xda\x14\x70\x29\x15\x18\x19\xf6"
          "\x54\xad\x7a\xcc\xe3\x9a\xb3\xea\xb4\x88\xf7\x0a\x0c\x1a\xf3\x45\x66\x8c\x27\x54\x6f\x45"
          "\x43\x7c\x73\xdf\x6b\xb6\x89\xb3\xaf\xd2\x7e\x29\x9a\x3c\xe0\xe2\x33\xe7\x9d\x03\xbc\xda"
          "\xde\x5d\x6a\x02\xdd\x00\xff\x43\xc7\x94\x68\x21\x84\xcf\xda\x38\xb1\x94\x08\xc2\xe3\x56"
          "\x3f\x40\x44\x20\x4f\x09\x51\xca\x90\xe9\xc3\x03\x34\x6b\xc5\x34\x00\xdc\xe1\xf4\xfa\xbb"
          "\x0c\x46\x30\xb6\x7b\xb0\x10\x5f\x1b\x0e\xf2\xb8\x95\x29\x4b\x7a\x6f\xa8\x57\x3c\x1e\x28"
          "\x75\x82\xb4\x95\x8a\xbc\x36\x0f\xa6\x4e\xcb\x83\x7e\x37\x82\x1e\xc2\xd6\x2e\xdf\x05\xe0"
          "\xab\xd8\xf7\xc4\xce\x99\x44\xe8\xce\x97\xa7\x5f\x18\x28\xfe\xbe\x68\xca\xad\x2b\x2a\x19"
          "\x48\x58\xdd\x9f\x2a\x65\xbb\x6e\x95\xbf\xce\x35\xc7\x99\xa0\xcb\x19\x7f\xef\xb9\x32\x70"
          "\x1a\x88\x7c\x59\x64\xc9\xbe\x28\xff\xe3\x33\x07\xf3\x70\x89\x9b\x18\x05\xd7\x75\x67\x0b"
          "\x88\x0d\xf7\x93\x5e\x4f\x6c\x29\x3b\x40\xca\x11",
          "\x34\x6a\x04\x40\xb0\xd1\x35\xb3\x59\x93\xed\xe4\xd3\x0b\x40\x84\xbf\x8e\xdd\x9b\x63\xfc"
          "\xe0\x43\x72\x2a\x25\x73\x48\x8b\x7a\x5b\xee\xc8\x09\xf8\xdd\x5a\x05\x82\xd6\x14\xa1\x9c"
          "\x18\x3d\x36\x34\x23\xba\x05\xe8\xd8\x16\xaf\xcc\x60\x06\xff\xd2\xc2\x9c\x60\xa3\xad\x45"
          "\xbf\xa8\x7f\x93\xb3\xae\x7a\x67\x6a\x72\xe1\xb8\x9d\xaa\x6c\x65\x97\x68\x0a\x2d\x9b\x51"
          "\x6b\x53\x9a\x27\x2d\xd8\x85\xad\x05\x99\xed\x84\x87\xdd\xba\x38\xa9\x55\x51\x50\x57\x86"
          "\x25\x2c\xf8\xbf\x18\xf9\xc8\x4f\x2f\x3b\x30\xf9\x3f\x85\x16\xfb\xb0\x6e\x44\x1b\x52\x1d"
          "\x1f\x31\xfc\xb7\x75\xba\x18\x18\x7c\x28\x73\x9b\x8d\xf1\x75\xac\xba\x12\x45\x4d\x59\xac"
          "\x20\xea\x19\xdb\xc8\xaa\x94\x40\x90\xa3\x08\x71\x69\x29\x7b\x86\x54\x51\xd3\x63\x4f\xdc"
          "\x61\xaf\xfc\xed\x18\x17\x2d\xe6\x59\x98\x32\x11\xac\xb4\xf5\xf3\xe2\x00\xaf\xc9\x43\x33"
          "\x9d\xfe\xfa\x53\x03\x2f\xde\x0a\x65\x81\xd7\x32\xae\x72\x8a\x52\x86\x57\x53\xed\xd5\x45"
          "\x37\xc9\x9a\x1e\xd1\x9a\x2e\x0a\x39\x87\x04\x33\x61\x9b\x5c\x07\xb0\x69\xef\xd0\x49\x80"
          "\xc5\x32\xf5\xa6\x64\xf5\xd7\x86\xbc\x48\xdd\xea\xf0\x90\xb7\x46\x01\xe2\x67\x53\xb4\xe5"
          "\x48\x5d\x69\xae\xd0\xf4\x49\x79\xd8\xb4\x93\x37\x81\x46\x28\x32\xf2\xa5\xad\x47\xed\xc1"
          "\x26\xca\x2b\xa8\x40\x21\x97\xf0\x94\x67\x3c\xa7\xa9\x3d\x0a\xd5\x97\x67\xba\xc5\xe8\x19"
          "\x2d\x40\xf6\xed\x7d\x06\xed\xaf\xad\x8a\x76\xb9",
          1, 2560 },
        { 128, 256, 83,
          "\x71\xff\x8d\xe4\xd1\x07\x10\x7c\xac\x7a\xde\x20\xdb\x81\xc7\x2e\x6e\x2f\x80\xfc\xeb\x7d"
          "\x90\xb4\x68\x06\x28\x09\xb5\x9b\xdf\xda",
          "\x19\xfb\x5b\xb5\x6f\x01\x34\x32\xc3\xd1\x97\x44\x73\x47\x1b\xbf",
          "\x16\xdd\x12\xe4\x2d\xb2\x26\x67\x7a\x8a\x90\x6b\x71\x37\xa2\xab\x95\x1f\xaa\x57\xb5\x8f"
          "\xea\xf4\x50\x84\x81\x74\xbc\xfd\x8c\x83\x84\xc2\xd7\x0f\xe5\xee\xd6\x06\xcb\x39\x3d\x97"
          "\x69\x37\xeb\xf0\x51\x80\x3a\x0c\xab\xc6\x4e\xcc\x8d\xcd\xd0\x2e\xe3\xdc\x46\x1d\x34\x90"
          "\x18\xc7\xd5\xab\xb3\x25\xc7\xb3\xac\x92\x7a\x3f\xb7\x21\x1b\x9c\x5c\x82\x85\xfa\xe7\x49"
          "\x52\xe7\x52\x0a\x49\x7a\x6b\x06\x1c\xdc\x7f\xeb\x09\x8b\xc0\x5c\xce\xe7\x44\x40\x1e\xd4"
          "\x2d\xd1\x36\xdc\x09\x4c\x8b\x26\xdb\x89\xe9\xf6\xb2\xdb\x8c\xf4\x3b\x6a\x29\x57\x89\xe8"
          "\xe2\x3b\x19\xa2\xd4\x57\xe4\xba\x19\x5d\x1a\x13\x82\x87\x90\xab\x91\x06\x73\xbd\x99\x4f"
          "\x80\x27\xcb\xa0\x98\x02\x93\x24\xd3\x6e\xab\x57\xb9\x7d\x77\x0c\x2f\x08\x71\x21\x46\x9c"
          "\x64\xd4\x7e\x63\xe6\x08\x8d\xf6\x45\x90\x73\x86\x1f\x88\x92\x14\x52\x18\x8d\x30\x6c\x71"
          "\xa3\xab\xe7\x2d\xbb\x22\x01\x81\x70\xf3\x32\x47\xab\xd4\xa1\x19\x27\x7a\x18\x6d\xfb\xb1"
          "\x21\x27\x23\xe9\x18\x6c\x84\x28\x66\xd6\xe5\x70\xbd\x85\xd3\xfd\x6f\x76\xe0\x53\x32\xa3"
          "\x58\xf5\x35\x69\x40\x27\x29\xca\x71\x29\xbe\xa5\x4c\x71\xf3\xa7\x24\x1b\x12\x69\x57\xfe"
          "\x8f\x0b\x5c\xeb\x94\xe6\x93\xa0\xcc\x8d\x4a\x50\x0d\xdb\x95\xb5\x18\x2d\xa8\x83\x8c\x8a"
          "\x98\x59\xa3\xf3\x25\x1f\x31\xe8\x1b\x6f\xca\xf5\xb6\x62\x2a\x11\xeb\x81\x28\xe1\xf4\x22"
          "\x6a\xb4\xee\x07\xf9\xc3\xe1\x5b\xdb\x71\x11\x7b\xc6\x56\xf8\x64\xf9\x1b\xc9\xc8\x62\x19"
          "\xff\x99\x8d\xe3\xe4\x19",
          "\x52\x99\x63\xcc\x71\x43\xfe\xee\x1f\x72\x1f\x8b\x0f\x51\xa9\xb9\x2d\xb8\xee\x5e\x7a\x1b"
          "\x80\xe6\xf1\xf9\x69\x2a\x65\xb4\x5b\xce\x42\xf5\xf6\xae\xcc\xd7\x01\xfe\x19\xa2\x07\xef"
          "\xd4\xe2\x65\x5c\x4f\xc2\x13\x38\x1e\x61\x24\x14\x75\xed\x28\xad\xc3\x0c\xb7\xd7\xac\x57"
          "\x1a\x23\xf1\x1c\x9e\x93\xd7\x01\x42\x43\x89\x50\x61\x4c\x6c\x16\xad\xc6\xec\xc3\x93\x37"
          "\xf8\xbe\x0c\xdd\x56\xeb\x6f\x6c\xa7\xd1\x9f\xd0\xb8\x3e\x3b\x3a\x7e\xdc\x6b\x73\x84\x91"
          "\xbc\x3b\x95\x70\x0d\xc7\x5a\x60\x00\x4c\x4c\x30\x5a\x56\xbd\x0e\x6c\x8a\xaa\x67\xd6\x9a"
          "\x87\xd1\x28\x94\xa7\xad\xe1\x76\x50\x1f\xe1\x57\x2b\x03\xae\xad\xe1\xe9\x6d\x6c\xda\x06"
          "\x93\x7a\xdb\x20\x83\x5f\x3d\xd6\x3e\x6b\x9e\xdd\xa6\xfb\x65\xa4\x14\xed\xcd\xa2\xac\x71"
          "\xd5\xda\xf3\x82\xea\x08\x46\x66\x78\x24\x74\x30\x16\x99\xd5\x86\x55\xdb\x6a\x17\xf4\x5d"
          "\x53\x54\xd1\xca\x1b\xec\x85\x27\x6e\x38\x7b\x08\xa6\x41\x3c\xa2\xd0\x26\x9b\xa4\xa9\x75"
          "\x77\x6b\x8e\x72\x54\x43\xb2\x6a\xa0\x51\xc1\x6c\xdd\x16\x85\x12\xf4\x2f\x77\x2c\x95\x08"
          "\x44\x5f\x8a\x8c\x53\x61\x6d\xb0\xbd\x96\xf0\xab\x1b\x72\xf3\x8e\x60\x1a\xc8\xe5\xb7\xdf"
          "\xf4\xab\x35\x3e\xee\x37\x1d\x3d\xde\x6b\x28\xa6\x6f\xf5\x2a\xf9\x81\x63\x46\x8b\x2c\x46"
          "\xe8\x43\x90\xd1\x6b\x5e\x1c\x89\x8c\xd3\x5f\x31\x9e\x76\xb5\xe6\x1e\x30\xc0\xe1\x5b\x2a"
          "\x9d\xc7\x4e\x35\xf9\x5d\xfb\xd7\xf9\x2b\xe8\x4d\x12\x42\xda\xae\x34\x7d\xfe\x12\x1d\x76"
          "\x85\x8b\x28\xf1\xf7\x6f",
          1, 2688 },
        { 128, 256, 84,
          "\xe0\x80\xd1\x6b\x4a\x0e\xcd\xa8\x8f\xc1\x3a\xb5\x6f\x81\x05\xf1\x9a\xe7\x33\xfa\x3d\xf4"
          "\x6e\x21\x2a\x0a\x24\x71\x1b\x29\x0e\x9f",
          "\x94\x95\x7a\x5e\xc6\x72\x49\xb6\x8f\x5b\x41\x0d\xef\x10\x46\xec",
          "\xf8\x69\x3b\x08\xbd\xfc\xa2\x1f\xce\x46\xf5\xb8\xc5\xa2\x0b\x8b\x03\x2e\x81\x28\x5f\x06"
          "\x10\x91\xfb\xf4\x1c\xcc\x83\xfd\x80\x88\xc0\xea\x8a\xb8\xd3\x8f\x30\x89\xbf\xea\x16\xf9"
          "\x83\xed\xc1\x85\x15\x78\x40\x84\x2c\xff\x80\xd2\x90\x40\xe9\x16\x02\x06\x41\xa3\x0e\x24"
          "\x1e\x8a\x34\x1d\xad\x25\x17\xe4\x4e\xb4\x65\xd1\xb5\x54\x77\xd8\x3f\xe9\x0a\xd2\xa6\x02"
          "\xee\xcb\x5c\x00\x8b\x14\xc6\xb5\xca\x36\x14\x3e\xe7\x47\x79\x1c\x2e\x76\x24\xa5\xcd\xba"
          "\xc6\xbd\x2f\x88\x52\x58\xc9\x9d\x62\x1f\x31\x6a\xfa\xb6\xa5\x31\xa9\xe1\x6c\x41\x64\xd1"
          "\xe2\xe3\x03\xa7\x87\x15\x82\x3f\x8c\x7c\x8c\xac\xdb\x28\x68\x65\x85\xa7\xb9\x59\x7f\x08"
          "\x48\x50\x38\x9b\xe2\x11\x02\x61\x28\x19\x00\x8b\x23\xa5\xa4\x7f\x78\xdd\x40\x73\xfb\x14"
          "\xe7\x17\x49\x72\xab\xc4\x71\x6f\xdc\x77\xe0\xbe\x52\x6a\x5d\x33\xeb\x8c\x35\x9e\x64\x30"
          "\xd7\x7b\xcc\x90\xf3\xc7\xc3\xe0\xbb\x31\xc0\x3e\x66\xf6\x81\x7a\x24\x9b\x33\xd7\xeb\x1d"
          "\x6d\xb2\x81\x31\x2a\x7b\x96\xf3\x1d\xfe\x70\x93\xdf\x48\x62\x2a\x4c\x58\x17\x79\xbe\x49"
          "\x7e\x2b\x4c\xd8\xad\x8e\x68\x4f\x69\x4a\xa9\x31\x88\x5b\x6a\x2c\x13\x21\x49\xd7\x28\x17"
          "\xe2\x5d\xf1\xc5\x6b\x4a\xaa\x17\x3f\xc3\x6e\x63\x10\xd0\x48\xc3\xcb\xb8\x8e\x88\xdf\xec"
          "\xcd\xd8\x7a\xcc\x4e\x97\xb2\x7f\x6f\x67\x60\xdd\xf4\x76\x20\x06\xf4\xab\x0f\x1e\xbf\x0e"
          "\x1c\x07\x33\x7a\x35\x3c\x4d\x92\x3a\x38\xdf\x78\x91\x09\xbf\xe4\x4b\xab\x11\xfa\xcb\x91"
          "\x7f\x04\x3d\xcd\xd8\xaa\xb3\x49\xbd\x7a\x7b\x8d\x66\xc2\x03\x5b\xad\x5c\x77\x60\x16"
          "\xf7",
          "\xcb\x1a\xf1\xd5\x36\x6e\xe7\xcb\x1c\x23\xc8\x55\x7b\xa5\x3b\x77\x4b\x0f\x85\xa9\x6e\x26"
          "\x11\x0d\xf7\xbc\xe6\x35\x52\x00\x5e\xe2\x59\x69\x0d\x1c\x2f\x16\x14\x53\x51\x52\x66\x4f"
          "\xb8\x2c\x5a\xff\x40\x50\x00\xea\x99\x38\x55\x34\x3e\x3e\xca\xf1\x59\xec\x6b\xdc\x6f\x11"
          "\x21\x65\xd8\x4d\xf8\x34\xbd\xf5\x2c\x25\x4d\xa9\xe1\x76\xb0\xf7\x72\x29\x20\xf2\x7f\x6e"
          "\x53\x0d\x45\x45\xa1\xe3\x4a\x18\xe8\x97\x22\x68\xfd\x41\x4e\x3c\xb3\x6b\xb5\x47\x2a\xee"
          "\xfb\x2f\xdb\x4b\x8b\xd9\x06\xd4\xc0\x9c\xe9\x23\x75\x19\x0f\xbf\x54\x44\x01\xec\x4f\xc3"
          "\xb2\xd1\x23\x73\x92\x43\xca\xfe\x11\x7f\x06\xdf\xc5\x01\x5c\x4f\xf9\xcd\x00\xc9\x2e\xf7"
          "\xa2\xce\x36\xa7\x7a\xcd\x49\xd7\x09\xc4\x39\xd6\x3f\xac\xee\xe6\x61\xb5\x5c\xa7\x55\x50"
          "\x8a\x5b\x05\x61\x58\x07\x27\xca\x0b\x9b\x89\xf6\xfd\x6d\x27\x07\x98\xc2\x69\x4f\x72\x3d"
          "\xaa\x8d\x25\x73\xad\x07\x90\x0e\x09\x44\xea\x4b\x8f\x10\x50\x06\x9d\xf2\x31\x87\xbe\xa5"
          "\xc1\x4b\x92\x2f\x84\xdc\x38\x99\xee\x60\x58\x55\xac\x80\x28\xce\x6f\x04\xf2\x8f\xdf\x84"
          "\x21\x24\x44\x98\x7b\xd7\x07\x70\x4c\x5a\xf4\xa0\x21\x86\x8a\xd2\x01\x7c\xe2\x0e\xa2\xb5"
          "\x76\x37\x1e\xe3\xc6\x57\x94\x42\xd2\xa7\xa9\x9d\xe8\x5c\xb6\xa9\xde\x8a\x23\x27\xe7\xf8"
          "\x87\x74\xfd\xdd\x92\xd4\xb6\x6d\x40\x00\xe8\x1c\x90\x9a\xb5\xdb\xbd\x5a\x8a\x1d\x35\x74"
          "\x09\x7b\x1f\x01\xa6\xcb\x62\x05\xc8\xcd\x53\x59\x1c\x67\x28\x06\x43\xf0\x71\x37\xbd\x73"
          "\xcd\x10\x97\xe1\x44\xb7\xd9\x41\x89\xd1\xd9\x46\x45\x19\x72\x67\xa4\x62\xfd\xa6\x21"
          "\xc6",
          1, 2816 },
        { 128, 256, 85,
          "\x65\xc9\x98\x63\x78\x6f\xad\x1f\xd0\xbd\xc7\xa0\xa1\x89\xde\x2d\x4e\xc9\x4c\x6a\x0a\xe5"
          "\xf9\xdb\x83\xc1\x92\x1b\x04\xa4\x91\x80",
          "\x26\x06\xc4\x3e\xfb\xad\xc3\xe0\x37\xfc\x19\x0d\x3d\x96\x21\xbf",
          "\x0b\x37\x73\x3d\x1c\x4a\xa6\xe4\x14\x0c\xe1\x11\x12\x69\xb5\xa9\x21\x83\xef\xb8\xe7\x8e"
          "\xda\x57\xbb\x8f\x52\xf6\x03\xa4\x5e\xfd\xb0\xe9\x30\x0b\xff\xb9\x32\x79\x26\x65\x21\x3f"
          "\x6d\xd8\x35\x15\x1f\x28\x8a\xdc\xda\x07\x0a\x8c\x0d\xe7\x02\xd6\x50\xe1\xcc\xa7\xaa\xca"
          "\x8e\x1d\x97\x3a\xaf\x2f\xaf\x69\x86\x38\xda\xb9\x29\x9d\x40\x14\x34\xc8\xcd\x10\xf8\x5f"
          "\x96\x78\x80\x0d\x55\xef\x26\x8e\x95\x56\x37\xe2\x25\x0e\xdd\x60\x86\x84\x45\xd6\x47\x34"
          "\xb5\x33\xe7\xed\xff\x9b\x6c\xfd\xb6\x10\x45\xa1\xfc\x92\x8f\xc6\x15\x53\x70\x75\xdc\x96"
          "\x1d\xf3\xa9\xfc\x33\x75\x81\x4f\xd0\x7c\x97\x53\x2d\xea\x7a\x60\xb6\x4a\xbe\xa0\xa6\xe2"
          "\xf2\x58\x3b\x12\x0d\x50\xe7\xb0\x40\xa6\x17\x40\x26\x4c\x86\xeb\xfa\xcc\x16\xed\x46\xb7"
          "\xcc\x1d\x9a\x3d\x3c\x3f\x2b\x95\xd5\x83\xfc\xcb\xca\x07\x24\x4d\x6f\xe5\x71\x8d\xe3\xd1"
          "\xf7\x59\x47\x45\xc2\x19\x36\x22\xab\x16\x6e\xad\xb1\x08\x6a\x37\x1c\x23\x10\x53\x2b\xb7"
          "\xd2\x52\xfe\x79\x9d\x85\xa9\xf6\xc4\xe6\xb7\x28\x8e\xce\xf5\x5b\x0d\x6d\x7d\xc2\x6e\x70"
          "\xb5\x70\xa6\x37\x71\x5d\xbb\x5e\x2e\xb1\xca\x3f\x8b\x84\x4a\xa7\x41\xdc\x41\xd0\x74\x8d"
          "\xd9\xe0\x81\x9f\x41\xae\x6a\xdb\xa5\xaf\x35\x81\xf0\x25\x09\x21\xc6\xb7\xd8\x80\xac\xf1"
          "\x99\xb0\x85\x71\xff\x06\xbb\xeb\xdb\xce\x8a\x8c\xd8\xf5\x2a\xc4\xb9\x3f\xcf\x66\x64\x27"
          "\x3f\x16\xe8\x14\x83\xf5\x08\x2b\x7a\xda\xae\x49\x98\x98\xc1\xa0\xfc\x45\x2c\x88\x16\x71"
          "\xdb\x75\xb6\x87\xbd\x39\x56\x7b\xae\xbc\x83\x4d\x0d\x80\xea\xa2\x52\x49\x0b\x2d\xa0\x9e"
          "\x5c\xa1\xe8\xbd\xa8\x66\xe2\xcd\x76\xb5\x33\x32\x5e\x68\x8f\xd5",
          "\x35\xb9\x5b\x12\xe9\x2c\xc0\x1e\x88\x06\xfa\x0f\xed\xc1\xde\xe7\x4e\xff\xce\x87\xda\x6f"
          "\xab\x75\x13\xf7\x9d\x37\x84\x15\x4b\xaa\x17\xd6\x41\x8b\x35\x8e\x07\xaf\xc2\xaa\x1e\xac"
          "\x18\xc8\x22\x12\x71\xf2\xd3\xdf\xf7\x94\x1b\xdd\x55\xf6\x9e\xaf\x5b\x7c\x36\xfd\x8a\xae"
          "\x31\xbf\x1c\x26\xbf\x7c\x17\x20\xdf\xf2\x19\xb9\x3a\x3d\x7b\xbe\xf0\xa3\x94\x07\xbc\x0c"
          "\x01\x4f\x32\xb4\xb3\x36\x24\x65\x38\xe3\xb2\x4f\x07\x2c\x0a\xf8\x12\x7c\x38\x72\x06\xec"
          "\xe2\x4e\x3c\xf8\x1e\x65\x8a\x9f\x34\xb4\xe0\x5a\x63\x2d\x4f\x97\x54\x2f\x2a\x5e\x15\x5e"
          "\xcf\xb8\xfe\x14\xac\xb8\x69\x94\x7b\x9f\x67\x3a\x45\x14\x94\xdc\xc2\xaf\x44\x73\x80\xec"
          "\x1e\xe3\xb3\x64\xa7\x25\x1e\xb2\x81\xa3\x8e\x9f\x11\xb8\xd6\x8b\x74\x15\x62\xac\x38\x5d"
          "\x19\xdd\xe5\xe9\x5b\xc2\x4a\xed\x2b\xbc\xac\xb5\x39\xe1\xb6\x34\x2e\x39\x7a\x99\x66\xe9"
          "\x44\x18\x5e\x42\xf5\x67\x63\x4d\x94\x03\x73\xc5\xf9\x8e\xeb\x63\x43\x9c\x52\x55\xaf\xd1"
          "\xce\xea\x78\x93\x08\xdf\xfa\x4a\x1a\x98\x7e\xea\x39\xc2\x7c\xa7\xda\x50\x44\x30\xed\x99"
          "\x34\xce\x40\x95\x25\x00\x1f\x7a\x93\xdc\x0f\x19\xb8\xa6\xe3\x38\x7d\x25\x29\xe1\x12\x64"
          "\x5b\xc7\x0c\x1c\x66\x6a\x3f\x58\x7d\xfe\x72\x82\x4f\xab\xb4\x1d\x54\xbf\x39\x67\x50\x8f"
          "\x70\x2e\x10\xdf\xc1\x41\xfd\x97\x05\x6b\xd5\xb7\xa7\x34\xfc\x55\x3b\x98\x4c\x16\xac\xc7"
          "\x0d\x9c\x0b\x9d\x1d\x53\x38\xb5\x27\x1d\x0a\x85\x0f\xba\x73\x8b\x42\x6e\xf2\xba\xbb\xf8"
          "\xc3\x48\xfc\xdb\xdc\x0a\x19\x47\x72\xc4\x30\xcd\x13\x6a\x7b\xdb\xb1\xb3\x15\x17\xd1\xc4"
          "\x1d\x30\xce\x1c\x77\xf5\x29\x3f\xc0\x62\x1e\x13\xc0\x3a\xd4\x6a",
          1, 2944 },
        { 128, 256, 86,
          "\xde\x2a\x2d\x74\x63\xc7\x55\x88\x74\xa0\x52\x97\xb8\xfb\x1c\xad\x2d\x2b\xe1\x7a\xdd\x5d"
          "\x70\xba\x39\x3c\x09\x80\x3d\xf0\x32\x0b",
          "\xc7\x3d\x98\xcf\x48\x89\x68\xce\x5a\x32\x3b\x2e\xac\x95\xa2\x0a",
          "\x8b\xe7\x65\x91\x4b\xbb\x98\x76\xa1\xfe\xbc\x1b\x96\x48\xec\x3b\x08\xb1\x19\x3e\xe6\xc3"
          "\x40\x2e\xab\x76\x07\x21\x54\x1c\xad\x78\x2b\x26\x69\x35\x49\xdf\xf1\x52\xe7\xf3\x83\x82"
          "\x5e\xa3\xb2\x03\xdd\xb7\xb6\xda\x81\xa7\x97\x81\x6f\xd3\x1d\x44\x89\x01\xc9\xf0\xb9\xa7"
          "\x38\x14\xe4\xd3\x78\x11\x66\xf9\xd1\x19\x88\xc4\x4d\x5c\x57\xc9\x82\xca\x42\xd9\x41\x65"
          "\xc3\xfb\x13\xed\x98\x75\x4e\xf6\x5c\xae\xc9\x10\x33\xc3\x21\x10\x70\xd1\xb0\x4e\xb7\x19"
          "\x54\x63\xd1\x3a\xec\x6f\xd1\xc1\x67\xf7\x17\x86\xb0\x1e\x8e\x1d\xdd\x61\x61\x15\xf3\x02"
          "\x9c\xae\xb8\xbb\x91\x90\x57\xae\x07\xf9\xf5\xaa\x92\x50\xc5\xd4\xf0\xee\x1f\xd4\x20\x4d"
          "\xb0\xab\xdc\x3f\x9b\x87\xae\x15\x97\xaf\x9a\xc7\x12\xce\x0e\x53\xd0\xd5\x51\xcf\x57\x68"
          "\x14\x8c\x9a\x76\x80\x3c\xa9\x99\x83\x1e\x39\x8c\x00\x32\xbc\xfa\xd4\x15\xa4\x9b\x7a\x69"
          "\x3d\x43\x1f\xc9\xad\x03\x41\xb9\x06\x16\x7d\x6c\x61\x6e\xe4\xca\x29\x36\x82\xe2\x61\x17"
          "\x3f\xc3\xac\xc1\x2f\x86\x2b\x99\x09\x97\x57\x1e\x5b\x60\x92\x16\x99\xb1\xe5\x55\x7d\x42"
          "\xef\x3a\xb3\x3f\xfa\x0d\x49\xe6\xd1\xca\x86\x5d\x08\x12\x75\xd8\xdc\x47\xde\x1f\x5d\xd9"
          "\xba\xcd\x6f\xc7\x13\x69\xa5\xf1\x05\x86\x90\x8c\x91\x2c\x99\x23\xca\x9d\xa2\xd5\x1c\xa5"
          "\xb5\xf5\xe3\x38\x1f\x01\x93\x11\xf7\x08\x6f\xeb\x14\x93\x64\x51\x93\x85\x70\x66\x9e\xaf"
          "\x50\xbf\x55\x1f\x72\xed\xe2\xb9\xce\x45\x20\xfc\x4a\x0b\x33\x67\x85\x8f\xff\xf1\x7e\x39"
          "\x06\xa8\xee\xb4\x43\x5b\x96\x32\x0d\x5a\x70\x25\xcb\x81\x12\x16\x81\x2f\xa0\xa2\x2d\x61"
          "\xe6\x39\x38\x67\x94\x3c\x0e\x67\x47\x38\x07\x47\xde\xb1\xb5\xbf\x9d\xe2\xa4\x8a\x53\xe7"
          "\x34\xf8\x79\xae\xb7\xfe\xe0\x9e\xb0\x44",
          "\x64\x9c\xeb\xda\xfa\xd3\x55\x3d\xe7\x8e\xfb\x6d\x57\xd9\x43\x81\x78\x62\xf2\x80\x3f\xc1"
          "\xde\x90\x08\x66\xff\xca\xb8\xdc\x1e\x77\xc3\x1c\x47\x74\x74\xc8\x39\x98\x79\x76\x2b\x25"
          "\xcd\xbf\x12\xb9\x2b\x90\xa9\xf0\xaf\x4d\xac\x33\x8c\xaa\x14\x62\x4f\x42\xc1\xc5\x1c\xa9"
          "\xff\x26\x91\x4f\x68\xab\xf9\x99\x62\x00\xae\x1c\x48\x0e\xcc\xbb\x9a\xbc\xaa\x00\x5e\xbc"
          "\xa7\xcc\xdd\x0c\xea\xac\xf7\x95\x6f\x6b\x7c\x36\xfc\xb3\x42\xae\x6e\x57\xe1\x90\x02\x24"
          "\xe7\xf8\x38\x0b\x5b\x86\x07\x7c\xc3\x9d\x98\xc4\xba\xfa\x19\xfe\xd0\x40\xe0\x36\x1b\x2d"
          "\xfc\xed\xef\x04\xbb\x8a\xc0\x44\x1a\x49\x49\x56\xb6\x7e\x0a\x70\x26\x31\x24\x67\xb8\x96"
          "\x38\xb8\xca\x1e\xf8\x53\x2e\x43\xcf\x61\x2d\x1a\xff\x31\x45\x2f\x28\x0a\x79\x70\xc0\xed"
          "\x87\x8f\xfe\xce\x49\x8e\x00\xe2\xd8\x4b\x62\xcb\xb1\xb7\x6c\xac\x44\xff\x88\xe5\xe2\xe0"
          "\xc9\x6a\x6f\x30\x8d\x4b\x69\x7d\x4c\x3e\x34\xd9\xb0\x46\x5d\x88\xa2\xc2\xe9\x1a\x50\x44"
          "\x76\x9b\x1a\x39\xd1\x42\xf1\x49\xba\xcb\xf3\x1c\x90\x1c\x3e\x5d\x0b\x9e\xfb\xc3\xd6\xc2"
          "\x6b\x82\xbf\x2f\xa5\xd1\x12\x7d\x37\x90\xc8\x2b\x38\x74\x08\x43\x69\xe5\x85\x2c\x21\x62"
          "\x3f\xab\x06\x66\x16\xa2\xc2\x80\xd9\x23\x2b\x52\x53\x3a\x23\xd4\x0c\x0f\x83\x57\x3f\xb5"
          "\x3e\x59\x9b\xe0\x6c\xf9\x34\xde\xbe\x3d\x10\x31\xf4\xaf\xf5\x06\xaa\x56\x7d\xcd\x42\xd5"
          "\x63\xe2\xaf\xbf\x55\x46\xbc\xa9\x0d\xb5\xfa\x7e\x7e\x5e\x03\xcf\xb7\xf1\xb7\xcf\x1f\x06"
          "\x97\xf4\xed\x29\x33\x4f\x9b\x48\x91\x00\xda\x75\x57\xd7\x38\x95\x1d\x70\x2e\x6c\x55\x4c"
          "\xdc\x90\xf1\x3b\x0b\x48\xe5\xe1\xf0\x26\xc4\x98\xcc\x21\x43\x45\x16\x7c\x31\x0f\xdd\x5e"
          "\x5d\xb6\x31\x17\xa2\xc5\xe0\x51\x04\x11",
          1, 3072 },
        { 128, 256, 87,
          "\x2c\xa6\xf0\xcc\x30\x35\x0c\x86\x66\xc1\x34\x84\xa3\xbb\x88\x32\x75\x05\xae\xb4\xda\x3f"
          "\xc0\x5c\x7b\xcc\x7e\xfc\x0a\xc5\x31\x3c",
          "\x5a\x76\xbc\xa5\x40\x5f\x07\x26\xdb\x5a\x84\xff\x6d\x55\xec\xdb",
          "\x34\x11\x4d\x18\x7f\x57\xdd\x6f\xc7\x08\x11\x0a\xe4\xc7\x6c\xdb\x3c\xc0\x4a\x29\x1c\x0b"
          "\xef\xa3\x59\xb0\x80\x05\x93\xfc\x03\x75\xfa\x00\x90\x2f\xd5\x38\xe9\x11\xab\xaa\x89\xd7"
          "\x2f\xc6\xa2\x78\x2b\x88\x4d\x22\xf5\x0d\x8e\x1e\x0b\x17\xa8\x56\x77\x32\x48\x89\x02\xf8"
          "\x10\xbc\x98\xbb\x42\x17\x6d\x78\xd9\xf9\x79\x4e\x3e\x45\xa8\x69\xd9\x6f\x6e\x69\xcf\x81"
          "\x54\x45\xef\x9f\xed\x00\x0e\x5a\x30\x6e\xb2\x08\x32\xd1\x5b\xf9\xc3\xb5\x2c\x62\x35\x75"
          "\x28\xb1\x88\x67\x28\x2f\x07\xa0\x69\x0d\xb1\x7d\x0e\xa5\x0f\x00\x6a\xf7\x9d\x8f\x20\xd3"
          "\x9c\xe3\xfd\x88\xb6\x52\xd2\x2c\xe3\xc8\x73\x4c\x7c\xdb\xe7\x7a\x77\x2a\xc4\x28\xdc\xac"
          "\x9b\x22\xc1\x39\xeb\x07\x9a\x91\x4b\xcf\x51\x04\xdf\x39\x31\xe6\xdd\x0f\xf1\xfb\xe7\xdc"
          "\x87\x62\x5d\x77\xf9\xd1\x20\x1b\xa3\x4c\x03\x45\xfa\xe3\xd2\x32\x21\x21\x75\x33\x64\xa5"
          "\x4f\x97\xa9\x15\xff\xfb\x68\x31\xe6\x1c\x7d\xe7\x72\xbf\x26\x38\xc2\xb9\x4c\xf1\x5f\x41"
          "\xe3\xf9\x18\x2f\x54\xb4\x53\x0f\x3b\x61\xda\xee\xec\x3b\x87\xfe\x4e\x0b\xe5\x2e\x37\xe0"
          "\xc7\x24\xcc\x24\x0d\x0f\xd4\x3d\x1c\x7f\x35\x1f\x69\x09\x90\xb4\x61\x45\x8b\x13\x4d\x3a"
          "\x92\x96\xc0\x1b\x12\x2a\xae\x41\x11\xa1\x5e\x90\x32\x3f\x4f\x10\xe3\xad\xa4\x96\x27\x7a"
          "\x7e\x8c\xe9\xef\x0c\xcf\x36\x2c\x1f\x3e\x6a\x3c\x43\x7c\x2c\xc9\x5e\xc7\x11\x69\x92\x77"
          "\x25\xea\xcc\x6c\xbb\x8a\x95\x10\x2a\x89\x73\xef\xce\x83\x5b\xb1\xf8\x90\xe7\x6a\x58\x5a"
          "\x14\x6f\x7f\xaf\x4a\x1b\xf5\x74\xae\x70\x05\xc0\x3f\x7d\x32\xf6\xfc\x0f\x9c\x1e\x5a\x83"
          "\x27\xc7\xf6\x26\xdf\x40\x70\x07\x0d\x67\xd6\xc4\xd1\x56\xf7\x13\x25\x8b\x6b\x37\xc9\xbf"
          "\xff\x59\x52\x69\x02\x4e\x2a\x40\x13\xf0\xb8\x9d\x46\x34\xd5\xb9\xd6\xec\x69\x4c\x86\x6c"
          "\x0a\xae\xae\x1d",
          "\xe3\x1b\xf4\x6a\x30\xc8\x0e\xe3\x0e\xaf\x81\x4c\x59\x1a\x5b\x6b\xe5\xa7\x50\xc7\x5e\x51"
          "\xf6\xde\x38\x0f\x2b\x3f\xd7\x37\x22\x66\x66\xba\x86\x17\xd3\x59\x05\xd7\xfd\x75\xea\xf5"
          "\x64\x79\x86\xf2\xa3\xfa\x4f\xf8\x64\xf8\x73\x33\x55\x50\x33\xcf\xb5\x83\xfb\xdb\xfc\xa2"
          "\xa4\xb3\xff\xb7\xab\x4d\x47\x6c\x02\xca\x00\xc1\x66\xee\x8c\xfa\x1a\x36\x6f\x0f\xf7\x8f"
          "\x12\xb7\x10\x6e\x50\x74\x69\xf0\x77\xc0\xfa\x74\x27\x52\x63\x39\x04\x6a\x81\xbf\x37\x63"
          "\xfc\x0e\x64\xed\xde\x0c\x98\x84\xca\xb7\xad\x67\x22\xb2\xf3\x5a\x50\x01\x92\xbc\x65\x82"
          "\x1f\xcb\x86\x24\xe5\x30\xe0\xfd\x37\x94\x03\x9f\xcf\x0d\x76\x24\x78\x41\x1c\xa1\x79\xe1"
          "\x90\xaa\x28\xcc\x8f\x8b\x15\x25\x6b\x60\x9b\x6a\x56\x04\x8c\xe0\xba\xec\x3c\xd8\xff\x3c"
          "\x1c\x1e\x99\x1a\xa1\x6c\xa7\x92\x93\xc0\x41\x00\xac\x4b\x56\xe5\x19\xd4\xb0\x9d\x96\x25"
          "\x7c\xde\x3c\x61\x68\x68\xae\x37\x63\x58\x74\x3e\xa6\x22\x97\x61\x32\x6b\x3b\x64\xb8\x5a"
          "\x94\x27\x57\xfb\xa1\xe9\xdb\x89\x92\x2a\x59\xb9\x48\xb1\xdb\x8a\xa5\xed\xc6\x10\x9c\x7d"
          "\x20\x2f\x64\x4b\x02\x36\x83\x08\x2f\xf7\x4d\xc0\x5e\xb4\x75\x61\xe1\xfb\xa1\x61\x85\xfc"
          "\x25\x0e\x5c\xab\xba\x3a\x98\x89\x83\xe3\x4e\xa4\x1a\xb6\xff\x49\xba\x27\x27\x5b\x54\x7b"
          "\xea\xd2\xfe\xed\x48\x02\xd1\x06\xc5\xec\x1b\x32\x02\x5f\x18\x0e\xf2\x83\x7e\x01\x61\xb8"
          "\xf1\x3b\x9d\xb9\xc0\xbd\xa9\xd2\x37\xf2\xe8\x27\xbe\xd1\x13\x03\x03\xbe\x06\x7c\x1e\x71"
          "\x03\x31\xca\xe9\x4f\x20\x6b\x7a\x5e\x72\x6e\xa5\x2a\x30\x6f\xed\x9e\x38\x17\xe2\x3e\x96"
          "\x33\xc9\xbd\x1c\xeb\x3c\x67\xd2\x0b\xf5\x47\x6c\xd4\x99\x64\x0d\xd7\x0d\x02\x20\x51\x23"
          "\x09\x95\xf7\x0b\xcb\x5a\x26\x1c\x21\xd0\xa1\x5b\xda\x02\x24\x88\x78\x23\xeb\x0d\xa4\xee"
          "\xea\x98\x72\xaa",
          1, 3200 },
        { 128, 256, 88,
          "\x3f\x23\xc2\x6c\x02\x24\xe1\xfa\xe0\x4a\xf2\xf7\x92\x34\x39\x2e\x81\xb5\x1d\xa4\x32\x96"
          "\xde\x2d\xb2\x86\x24\x42\x4f\xca\x57\x3b",
          "\xac\x1d\xa6\xcc\x7d\x2e\x68\x7a\x22\x68\x1c\xbc\x4f\x92\x3c\xa0",
          "\x15\xa1\xa3\xef\x39\xa0\xe9\xf9\x9b\x0e\xf0\x8a\x11\xbf\x72\x8b\x1a\xd3\xb1\x3e\x2a\x40"
          "\xe9\xe3\x5d\xa7\xcd\x97\x57\x5b\xf8\x86\x6c\x01\xbf\xce\x42\x88\xa8\xec\x70\xb0\xea\xce"
          "\x2b\x6a\xda\xf1\x8f\x3a\x44\xd5\xe4\x52\x4b\xd3\xc6\x9b\xbb\xee\x3e\xf9\xf6\x2b\xfa\x54"
          "\x6a\xc1\xc9\xaf\x51\x66\xae\x91\xc8\xf0\xb5\xef\x5e\xc2\x8b\xdb\x82\x4f\x9f\x1a\x24\xa0"
          "\x60\x8d\x55\xcc\x92\xe2\x3c\x4d\x01\xb0\x12\xaa\x97\xa7\x76\xd9\xb5\xaa\xbb\x48\xbe\xcd"
          "\xc9\x99\xa7\x13\x1e\x6c\x1c\x03\x93\x14\x1b\x9e\x09\x3f\xea\xd4\x43\xb8\xce\xb1\x85\xf6"
          "\x0c\x12\xee\x60\xe3\xeb\x73\xe0\xa8\x00\x73\x13\x92\x01\x18\x1c\xe9\x31\x0c\x6d\xc2\xb0"
          "\xda\xda\xc7\x88\x9c\x1a\x4d\x68\xa2\xba\x06\xc6\x7e\x06\xde\xd4\x53\x73\xb8\xfd\x44\xdb"
          "\xdb\xf5\x38\xc1\x1c\x0a\x8f\x1f\xf4\x0d\x10\x5c\x1e\x20\x02\xec\x94\xf1\x33\x2d\xfb\xbd"
          "\x20\x4e\x09\x46\x95\xf5\xa6\x4c\x83\x17\x6e\xa7\xdb\x58\xc1\x76\xa3\x4a\x71\x06\x07\xaf"
          "\x8e\x9a\x65\x04\xe3\xcc\x67\xb8\x37\x9f\xa1\x2e\xbd\x03\xdb\x3f\xfc\x38\x24\x1c\xc3\x7f"
          "\x1e\x71\xb0\xe3\x29\x3a\x63\x45\xba\x2e\xb9\x00\x93\x7d\x07\x7b\x16\xde\xcd\x50\x32\x2f"
          "\x9e\x7d\x2e\xfa\x13\xa7\xcc\xe7\xa2\xb0\x55\x74\xa9\x7f\x4c\xab\x71\x28\x01\x63\xbf\xdf"
          "\xe0\xc5\xa4\x04\x8c\x68\x54\x4d\x9a\xc5\xf6\x54\x1a\xa4\x3f\x84\x26\x1e\x69\x8c\x80\x84"
          "\x8e\x2f\x26\x86\x14\x61\x65\x08\xe0\xdb\xe1\xb0\x06\xa5\x42\xb6\x4b\xb5\x47\x6c\x3f\xe5"
          "\xa5\xf4\xf8\xda\x7f\x2a\xdd\x16\x94\xf0\x1a\x61\xc6\x61\x0a\x8e\x50\x16\x5f\x94\xf4\x9e"
          "\x23\xb5\xa8\x55\x90\xee\xb9\x39\xc9\xa1\x42\x81\xab\x66\x38\x44\x65\x96\x3c\x1f\xac\x80"
          "\x00\x26\x62\x70\x52\x02\x2e\x8d\x1b\xaf\x74\x74\xc4\x6a\xdd\xcc\xff\xe6\x69\xd8\x75\x0c"
          "\xde\x8d\x46\x5a\xd2\x36\xb5\x29\xe9\x1e\xbe\xa2\x49\xaa\xad\x2e\x5e\x30\x78\x1b",
          "\x9b\x4c\x79\x07\xc9\x88\x05\x41\x05\x54\xff\x78\x80\x34\xe6\xac\xd2\xac\x0c\x91\x6f\xe4"
          "\x6c\x1a\x78\x35\x92\x80\xc3\xec\xef\x2b\x24\xee\x0d\xcf\xd2\x7b\x77\x04\x35\xbf\x42\x6a"
          "\x8a\x62\x1a\xa7\x56\x7b\x16\xe3\x46\x50\xaf\x9b\x7f\xe1\xb7\x8e\xfc\x6c\xc5\x08\x66\xab"
          "\xa4\xf9\xa8\x2b\x54\x3f\xac\x0b\x01\xc4\xbd\x22\xb8\x0f\x35\x34\x33\xe4\xfa\x72\xcb\xbc"
          "\x86\x3c\xad\x98\xf6\x48\x3a\x78\x49\x46\x93\x7c\x5d\x0a\x67\xd9\x89\xca\xb0\x58\x34\xd2"
          "\x31\x93\xc1\x36\xdd\xfa\x8a\x80\x75\x1c\x50\x87\x2a\xcc\x47\x35\x6d\xef\x6d\x59\x2c\x34"
          "\x53\x95\x5c\x4e\x06\xbd\xeb\xea\x51\x19\x31\x88\x78\xa4\xee\xc8\xac\x7b\xda\x21\x2e\xc9"
          "\x97\x5f\xea\x48\x74\xc2\x04\xd3\x9a\x3b\x3e\xd5\xd0\x10\xca\xd4\x46\xf8\xf7\xb7\x09\xde"
          "\x10\xf6\x13\x37\xf3\xf6\x3c\x21\x41\xb6\x2f\x8d\xde\x94\x66\x70\x03\x7a\x6a\x70\x9f\xd5"
          "\x6a\x23\x39\xca\x7b\x37\x53\x73\x18\x4b\x8d\x0e\x3b\x05\x38\x01\x58\x01\x6f\x2d\xd6\x0e"
          "\x60\xe6\x74\xd1\x11\x2e\xb0\x9b\x1a\xb6\xd7\x23\xa0\x38\x7a\x2b\x4c\x81\x23\x40\x03\xde"
          "\xa5\x60\xa0\x7e\x93\x8c\xba\x45\xd6\x16\xfd\x73\x25\xd8\xc9\x96\xfa\x11\xfa\x24\x42\xa4"
          "\xbf\x6c\x61\xbc\x7c\x76\x8f\x85\x91\x2f\xa8\xdb\xa7\x7e\x62\x16\x22\x38\xa3\xfc\x9f\x89"
          "\x08\x89\x96\xaa\x48\xd9\x1a\xca\x7c\x4f\xca\x2c\x86\x53\xb9\x8a\x66\x97\x68\x03\xb2\x26"
          "\x53\xfd\xf9\x27\xf8\x32\x36\xb7\xf5\xb2\x3d\x36\x66\x77\x8c\xcd\xfe\xc4\x55\x7e\x06\x5f"
          "\x11\x1d\x7a\xe4\x3a\xc5\x69\xff\x84\x3e\x4d\x7d\xbf\x2e\xfb\xaa\xed\x9c\x8e\x7b\x20\x1e"
          "\x04\xcc\x47\x9c\x58\x93\x4c\xbb\x51\x98\x8e\x39\x9e\xb0\xe1\x1a\x95\x5c\x05\x36\xca\xf1"
          "\xae\x48\xa6\xc7\x5a\x40\x76\xe3\x41\xd0\x2e\x49\x77\x46\xc8\xa7\x9f\xf1\x03\xe2\x52\xe3"
          "\x80\x17\xdf\x4f\xa4\x20\x63\x04\xcb\x11\xc5\x4b\x6c\x65\xea\x30\x58\xa9\x6f\xff",
          1, 3328 },
        { 128, 256, 89,
          "\xa4\xeb\x20\xad\x63\x27\xbb\x52\x51\x48\xd2\x41\x1f\x22\xee\x70\x61\x45\x4c\x31\x0a\xf9"
          "\x99\x53\x54\xba\xa4\x0a\x4d\xf1\x6c\xb9",
          "\xe7\x7f\x3c\x77\x5c\xd7\xf9\x7e\xa9\x47\x24\xaf\x86\xbb\xc5\x20",
          "\x49\x2f\xc4\x47\xac\xc2\xbc\x80\xc0\x14\xb5\x3f\xfb\x91\xa3\xf9\xa8\x00\x16\xb7\xae\x8f"
          "\xb9\x16\x8f\x20\xee\xa0\x67\xec\xeb\x0e\x15\xce\xb6\x66\xf4\xf9\x89\x79\x5c\xc4\x08\x77"
          "\x8b\xdb\x11\x17\xfd\x06\x3c\x7e\x54\x52\xcb\x60\xaa\x43\xb1\x85\x8f\x13\x80\x83\x1c\x32"
          "\xe0\xb4\x01\xdf\x0a\x8b\xd4\x61\x2c\xcf\xa1\x40\x55\x9d\x75\xa3\xde\x04\xd1\x34\xd3\x59"
          "\x52\xc9\x33\xbf\x5e\xf7\xde\x22\xc4\x46\xdd\x4a\x36\xf7\xe3\x9a\xde\x4d\xb8\xd3\x64\x84"
          "\x64\x5e\x80\xbb\x0f\x46\xcc\xc5\x99\x00\x34\xe0\xb3\x34\x15\x1a\x1d\x9e\x5d\x1e\x7e\x73"
          "\xeb\x8e\x34\x8b\x2c\x82\x64\xd1\x7d\x3e\x1a\xc4\x9c\xa2\x03\xd3\xf8\x5d\xcb\x48\x39\xa3"
          "\x10\xc8\xac\x25\x8b\x9e\xa3\x40\xa7\x14\x0d\x39\x52\x3f\x23\xf9\x74\x45\x4d\xba\x06\x75"
          "\x13\xab\xf3\x8a\xb5\x5f\x83\xc4\x18\xed\x00\x6e\x91\x26\x7b\xac\xdf\x37\x59\x1a\x4e\xc5"
          "\xa5\xa5\x0c\x62\xd7\x3e\x95\x2d\x78\xd3\x2d\xe0\x02\x66\x21\x4a\x26\xcc\xa2\x6a\x11\x5b"
          "\x50\xe5\x79\xd9\x7a\x27\x4f\x54\x72\xec\x75\xb2\xa0\xbd\x30\x4a\xaf\x0d\x84\xad\xaa\x1a"
          "\xbe\x3a\x5e\x31\xa6\x6d\x71\x00\x3b\xe8\x63\xa9\x66\x62\xfa\x98\x12\x45\xfb\x21\xb3\x1e"
          "\xf6\xd7\x10\x6a\x20\x84\x0c\x4b\x6a\xb9\x00\xa0\xbd\x51\xbc\x5f\x10\xb0\xe3\xbc\x30\x58"
          "\x51\x38\x21\xb2\xf3\x00\x9b\x1f\xbb\x2a\xd7\xaa\xd9\xa3\xf3\x03\xc3\x0d\xa5\xa8\xee\x54"
          "\xf1\x62\x54\xb3\x47\x0c\xf3\x88\x48\x43\x87\xc8\xd6\xcd\xda\x8b\x06\x4f\x84\x45\x81\x05"
          "\x75\xce\xb0\x0b\xa9\x49\x25\xc7\xbe\xb6\x09\x3a\xb5\x38\xdc\x9d\x23\xaa\x54\x1c\x77\xc1"
          "\x62\x35\xdd\x49\xe2\x11\xf2\x77\x30\x8c\xca\xba\x51\xb9\x55\x0b\xd5\x8e\x9d\x43\xea\x3e"
          "\xc4\x7b\x24\x30\x58\x23\x65\x3b\x32\xb2\xaa\xf1\x9e\x36\xd9\x84\x83\x91\x15\x64\x4c\x39"
          "\x05\xdb\x48\xcf\xd6\xb7\xe6\x4e\x06\xa6\xd3\x05\x10\x0d\xec\xce\xeb\x66\xfb\xd9\xd2\x20"
          "\xa7\xad\xea\x95\x92\xcf\x65\x03\xf4\x2a\xfa\x48\x55\xe9",
          "\xce\xd4\x1c\x03\xfe\x5a\x5f\x8a\xf6\xc3\x90\x56\xb5\x9b\xf5\x48\x6d\xac\xa9\x38\x1e\x37"
          "\xcc\xdb\x62\xde\x46\x1e\x88\xcd\x4f\x8d\x72\x0c\x12\x2b\x00\x37\xfd\xc7\x59\x57\xb0\x75"
          "\xf5\x1f\x78\xb7\x6c\x89\x54\xfe\x8e\x2d\xb1\xe5\x5f\xe9\x56\xa7\xf6\x07\x25\xca\x5d\x2e"
          "\x6d\x3a\xae\xdd\x50\x9a\x29\xde\x98\x9b\x5b\x04\xc5\x67\x3a\x29\xb9\x35\x60\xda\x0c\xa7"
          "\x10\xc4\x32\x09\xc5\xf7\x20\xd6\x78\x8c\xdd\x22\x70\x4b\xde\x60\x06\x41\x73\xcd\xd8\xd2"
          "\x4d\xc5\xfd\x18\x31\x16\xef\xda\x6a\x5c\x2f\x70\xfe\x57\x8d\x34\x7f\x4c\xeb\x25\x04\x99"
          "\x96\xba\xd6\xf5\xf2\x06\xd2\x28\xb3\x12\xdc\x91\x57\xf9\xd9\xbe\x44\x90\x52\xa2\xa8\x7d"
          "\xf4\x94\xcd\x1c\x58\xbc\x06\x3c\x9a\xb6\x8c\x81\x10\x63\x56\xb0\x27\x9d\x66\xcc\xf8\x45"
          "\x79\x52\xcf\x43\x58\xa5\xda\x78\x43\xd2\x19\x75\x90\x45\xc9\x60\xab\xb1\x63\x9d\x23\xa3"
          "\x0e\x0b\x06\x3c\x3f\x1a\x1b\x80\x24\x95\xa3\x49\xf7\x7b\x8b\xad\xea\x8a\xc1\x05\x4f\x9b"
          "\x99\xba\xbc\xeb\x0f\xdf\xf4\xc9\x80\x36\x0f\x44\x51\x8f\xfe\xef\x9f\x78\xe8\x0f\x50\x98"
          "\xe2\x6e\x2f\xf3\x40\x45\x60\x9c\x0c\x92\x9b\x2f\x62\xfb\x7e\x7e\xd1\x02\x2f\x09\x56\x3a"
          "\x81\x02\xae\x8e\x02\x70\x2e\xf7\x5f\x77\x31\x3a\x6c\x65\xdc\xcd\x7f\x66\x9b\xa8\x2e\x01"
          "\x5e\xbb\x33\xb3\xf8\x40\xda\xfc\xb8\xb5\x36\x5c\x64\x5a\xd0\x0a\x8e\xff\xf9\xec\xcf\x79"
          "\x17\xb0\x23\x96\xe4\x12\x64\x1a\x87\xb9\x9c\x78\x56\x64\x6b\x44\xd6\x98\x7b\x08\x66\x40"
          "\xd3\xc8\x16\x5a\x87\xa6\xc4\x86\x8c\x1b\x98\x5a\xf3\xae\x0f\xbb\x34\x59\xb7\x8a\xc8\x7e"
          "\x9c\x5a\x8c\xa8\x76\x3c\xa2\x8c\x41\x49\xda\x04\xba\x59\x7c\x82\x9d\x15\xc8\x7e\x21\x74"
          "\x28\xba\xf4\xf6\x9c\xd1\x6f\x1a\xc2\x10\x11\x29\x13\x8b\x83\x11\x9b\xa8\xe5\x2a\xe8\xcc"
          "\x44\xe8\x46\x43\x1b\x0c\xb6\xa2\xa6\x6c\xcc\x2d\x7f\x31\x91\x5f\x83\xbc\xd6\x43\x60\xb4"
          "\x33\x82\xee\x4f\x17\x00\xdb\xbb\x82\x0d\xb2\xeb\xcf\x25",
          1, 3456 },
        { 128, 256, 90,
          "\x05\xb3\xff\x7f\xad\x47\x36\x9f\x48\xd2\x77\x94\xc1\x08\xb9\x9b\x54\x70\xed\x26\xed\xaa"
          "\x51\xe5\x66\x3b\xbf\xec\xbe\x8f\x77\x55",
          "\x9f\xaa\x55\x5e\x47\x7b\x8c\x32\x53\xca\xc8\x0f\xe5\x43\x1f\x7f",
          "\x78\x9e\xea\xe8\x65\xd7\xc7\x04\x52\xe1\xdf\x56\x13\x8f\x90\xd5\x7f\x65\x1b\x8d\x9b\xf8"
          "\x03\x0f\xfa\xd5\xe7\x12\xbb\xca\xa3\x30\xb5\xc1\xa1\xb2\x2a\xa8\xcf\xd6\xdb\x51\xa8\x39"
          "\x83\x81\x35\x14\x61\x86\x79\xf4\x63\xa7\x32\xe2\x43\x51\xa5\x14\x6b\x61\x41\x4f\x96\x4a"
          "\xda\x57\x1e\x1d\x1a\x3f\x66\x15\x66\x7c\xa1\xff\x32\xcc\x59\x52\xdc\xf5\x7a\x9a\xa8\x9f"
          "\x65\x0b\x01\x44\xef\x81\x36\x64\xff\x2a\xc3\xc2\x21\x24\x1a\x72\x96\x92\x4f\x7e\xac\x40"
          "\x40\x24\xf6\x0b\x15\xef\x01\xfc\x9c\xc9\x2b\x8d\x1a\xf7\x2b\x3d\x3d\x65\x45\xca\xd0\xa0"
          "\xa3\x02\x2a\xeb\x71\xb0\x58\xc9\x13\x83\x93\x16\xb7\xd0\xce\xbb\x13\x49\x63\x61\x3b\x83"
          "\x15\x43\x73\xaf\xa6\x30\x67\xa2\x38\x18\x15\x67\x82\x8e\x1c\xc0\x63\x20\x79\xd6\x71\x2e"
          "\x40\xf9\xc7\x37\x5e\xcb\x4f\xd9\xac\x20\x3b\x3f\x45\x3c\x59\x51\x63\x04\xc9\x62\x3f\xb5"
          "\x6a\xca\x67\xf9\xc0\x0f\x4f\x25\x28\x37\x19\x0d\xfc\x8d\x96\x23\x1d\x71\x7b\xd4\x2f\x81"
          "\x04\xdc\xc3\xea\xf1\x5e\x3a\xe7\xbf\xc3\x64\x71\x44\xb6\xde\x7d\xe6\xa0\x83\x9e\xf8\x76"
          "\xe5\x93\xe9\x12\x27\x38\xfa\xde\xa8\x1a\x51\x86\x72\x6a\x57\x8c\xc0\x7f\xec\xae\x35\x0b"
          "\x3f\xba\x46\xe7\xad\xa8\x81\x96\xb4\xc7\x6a\x4e\x3d\x97\x67\x1c\x60\x79\x11\xbc\xad\xb6"
          "\x99\x8b\x53\x8e\x2a\x37\x54\x1c\x1c\x21\x4c\x63\x23\x67\xd0\x58\xe7\x6a\xce\xe3\x40\xbb"
          "\xa2\x37\x68\x62\xa7\x85\xf4\x72\xbb\x2b\x0d\x9a\x10\xca\x67\x1f\x21\xc2\x2b\xbf\xc4\xe4"
          "\x4f\x99\x57\xf4\xc3\xc1\x47\x19\xb7\xf0\x5a\x47\x74\xd0\xb8\xf2\x2c\xa7\x9f\x95\x61\x50"
          "\xfb\xde\xdf\xec\x57\xa6\xf0\xdd\x28\x9f\x31\xcd\x79\x68\x7b\x1d\xfa\x1d\xde\x6e\xe8\x9e"
          "\x4f\x60\xbd\x1e\x07\x4c\x1d\x20\x1f\x6c\x48\xab\xd0\xb5\x53\xd5\xa4\x34\x71\x57\x5c\x85"
          "\x98\x9a\x16\x2b\x7b\x78\x84\x19\x11\x04\x33\xf4\x24\xc5\x19\xcb\xa1\x51\xa2\x80\xd7\x17"
          "\x63\x3a\xdb\xcb\x23\xd1\x4a\xfc\x12\xbb\x28\xd5\x0c\x84\xb2\xe9\x52\xb3\xff\x47\x60\x55"
          "\xc7\xf7\x40\x00\x0a\x68\x30\xb5",
          "\xd2\xe2\x7c\x06\xd9\x66\xb7\xe5\x33\xd8\x4e\x30\x0e\x7f\x52\xe8\xa6\xf8\x5a\xc6\xf4\xb3"
          "\x1e\xef\xcd\xdc\xc5\xb2\x1b\x1a\x05\xbf\x8c\xcc\xa2\x2c\x01\xc2\xfd\x7b\xdd\xdd\x41\x30"
          "\x15\x5e\x44\x66\x32\xf6\x6e\xf3\x3f\x0f\xcb\x90\x57\x0f\xd3\x32\xb0\xb4\x74\x1b\x4b\x99"
          "\x12\xdb\xaa\x0d\x7c\x07\xad\xbd\x44\xf4\xdc\x88\x46\xd6\x86\x46\x2e\xe9\x59\xe9\x2c\xee"
          "\x33\x33\xbf\x73\x53\x3a\x47\x35\x9e\x9e\xf9\x3e\xc2\xc8\x58\xe1\x30\x15\x38\x62\x9f\x42"
          "\x70\xd5\x12\x16\xc4\xdc\x77\xd7\xed\xf2\xec\x1e\x7e\x23\xbb\x6d\xc7\x4c\xaa\xe1\x2d\x7c"
          "\x97\xe1\x7d\xa0\x02\xd4\xdd\xc1\x10\x12\x37\xb3\x5e\x51\x30\x65\x82\x51\x49\xa0\xf0\x62"
          "\x20\x8a\x7a\xcb\xda\x33\x54\xd0\x80\xf3\x99\xdf\x8e\x5d\x4e\xb7\x5a\x1a\x3b\x44\xe1\x91"
          "\x09\x9e\x64\x22\x1e\x6d\x2a\xc5\x26\x56\xc9\x61\xb0\x6f\xb8\xc3\x72\x7c\x59\x50\xb4\x2f"
          "\x7c\xc7\xc1\x73\x5d\x65\x67\x40\x50\x6b\xcd\xc1\xbd\xc8\x73\x3f\xc1\x93\x0b\x49\x0b\xbf"
          "\xc7\xa0\xc9\x2c\x83\x61\xf5\xfa\x4e\xac\x58\x05\x8c\x1a\x88\x70\xe6\x07\x23\xd7\xf1\x56"
          "\x61\xc1\xae\xee\xbc\xa6\xa5\x72\x06\xe0\x92\x10\xe3\x50\x69\xe7\x13\xb7\xcf\x18\x96\x24"
          "\x8e\xd2\x31\x77\xbb\x00\x10\x0d\xbf\x62\xa7\xa0\xb5\x46\x28\x93\xa1\xe4\x69\x88\xb9\x6c"
          "\xc3\xd3\xdf\x62\xbc\xbe\x72\xf2\xed\x9d\x90\x99\xdc\x88\x80\x47\x35\x91\x2a\x31\x4f\x1b"
          "\x22\xe4\x04\xc7\x0c\xbf\xd7\x19\x9e\x87\xb1\xc6\x4d\x10\x7c\x36\x50\x4b\xd5\xfa\xf3\x5c"
          "\x25\x64\x87\x61\x80\x97\x3f\xac\xa4\xb0\x45\x20\x42\x46\x63\x23\xed\x45\x99\xd8\x17\xa1"
          "\xe7\x96\x7f\x6c\xf0\xc0\xf4\xe2\x88\xf9\x95\x98\x9e\x0f\x3c\x20\xf5\x90\x20\xa2\x77\xa1"
          "\x56\x8a\x61\x65\x75\x0a\x22\x5d\x58\x7e\x4e\xdd\x5c\x17\x7a\xad\xbf\xec\xed\xad\xf8\x9d"
          "\x0b\x78\xf9\x1c\x2d\xd4\x2a\xd0\x27\x3a\x08\xdd\xce\xb5\x0d\x5c\xa7\xdf\x23\xbc\xdc\xda"
          "\x21\xe8\xee\xc5\x25\xac\x10\xcb\xdd\x55\x95\x17\x29\xee\x54\x09\x0a\x37\x4d\xd4\x35\x12"
          "\x4c\x8b\x88\x25\xd5\x58\xbb\xaa",
          1, 3584 },
        { 128, 256, 91,
          "\x10\xe6\xf8\xa6\xd6\xcc\xb6\x6d\xbc\x76\x93\x88\x9f\x39\xe2\x56\x80\xde\xa3\xac\xa8\xfc"
          "\xba\x75\x36\x5a\x94\x37\x2c\x7e\xbe\x86",
          "\x0b\x04\xde\x61\xe0\xc0\x54\x30\xd9\x72\xa5\xd5\xdb\xc2\xa2\x42",
          "\xc3\xda\xac\x4e\x04\xc1\xd8\x2a\x51\xc8\x18\x7e\xcc\xcb\xe9\x75\x6f\x79\xb1\xd1\x28\x28"
          "\x18\xa5\xbf\xcd\x07\x9a\x73\xfa\x1b\xc5\xe9\x90\xfa\x26\x36\x00\xf7\xea\x83\x86\x54\xad"
          "\x52\xc0\xf9\x61\x75\x3e\x15\x03\xb4\xf0\xdd\x7d\xfa\xd6\x4d\x80\x4a\xe8\x39\x51\xf7\x36"
          "\x2f\x07\x00\x1c\x0a\x4c\x7c\x91\x1b\x40\x38\xc9\x51\xc1\xd7\x01\x19\x35\x41\x34\x7e\xc7"
          "\xfe\xb8\x85\x08\x78\xef\xd3\x7a\x9e\x3f\x3b\xb1\x69\xef\xb4\x71\xca\x45\xb5\xc4\x48\xfe"
          "\x5e\x3d\x56\x49\x1f\xb3\x24\x2e\xf2\xaf\x32\xfc\x42\x41\xc3\x3f\x41\xf9\x04\xb1\x4e\x01"
          "\x42\x89\xaf\x8b\x74\x69\xaa\x69\xf8\x25\x52\xa8\x0c\xb0\x68\x58\xfc\xc0\x89\xf3\x3a\x9a"
          "\xde\x7a\x85\xf3\x42\x39\xa6\x16\x5f\x40\x40\xfa\xfb\x5e\x41\x98\x6f\x7c\x5c\x8d\x26\x07"
          "\x11\x84\xc1\xf9\x4f\xe9\xc1\x20\x80\x1f\x14\xee\xfe\xeb\xcc\x0e\x7a\x27\xee\x31\x02\xbb"
          "\xae\xd2\xae\xe1\x88\x30\xeb\xbd\x9f\x12\x51\xa2\xa8\x1f\xb9\x55\x6d\xe6\x13\x0e\x42\x6a"
          "\x45\xec\x50\xf6\x0a\x21\xea\xa6\xcc\xb2\x93\xaa\xaf\x87\xee\x40\x8a\x4a\x5d\x39\x08\x03"
          "\x06\x70\x00\x4c\x05\x03\x98\xd0\x8d\xe6\x7c\xe7\xfe\x85\x6b\x73\x1d\xe6\x6d\x7c\x4c\x2f"
          "\xdc\xba\xfe\xa2\x55\x4d\x62\xec\x5a\x09\x33\x19\xf5\x86\xf7\x78\x85\x34\x3f\x9e\xe6\x2a"
          "\xfb\x1c\x2d\x9b\x28\x72\x53\x7c\x84\x5e\x4a\x79\x3a\xcf\x5a\xe8\xf4\x65\x9c\x10\x59\x71"
          "\x6f\x30\xb6\x1a\x9a\x43\x45\xc5\x26\x65\x88\x5f\xeb\xd7\x48\xbb\xd9\xf2\x69\x04\x93\xe4"
          "\xe8\xc1\x9a\x82\x2a\x39\xfd\x57\xd0\x2f\x32\xb2\x89\xa1\x76\xc9\x81\x28\xa6\x72\x78\xbd"
          "\x92\xe9\xee\x6b\x33\x4a\x72\x94\xd9\xfc\x72\x3a\xf1\x9f\x8a\xf2\x4b\xde\xe9\xde\x59\x4c"
          "\x7b\x4c\x8d\x7d\xa6\x16\xb3\x6e\xa3\xd1\x6d\x79\xbc\xc8\x71\xd6\x31\x5b\xfd\x87\x1d\xca"
          "\x49\x2f\xe2\x5c\x4f\x2c\x05\x89\x47\x9b\x58\x06\x5d\xe2\xf7\xea\x8b\x75\xbb\xae\x40\x49"
          "\x66\x93\xa6\xee\xc5\xa5\x52\xa1\x90\x33\x1c\xe2\x91\xf7\x41\xc6\x84\xc9\xd2\x16\x52\x90"
          "\xf2\xca\x1c\x5c\xb4\x05\xe3\x3e\x1d\x4c\xdf\x23\xe2\x64\xd3\x24\x57\x83\xb5\x0d\xf6\x12"
          "\x71\x60",
          "\xf1\x5f\xdf\x24\xf6\x28\x28\x4a\x9a\x0a\xf9\x4c\x91\xee\xcf\x4b\xbd\x33\xcc\x5c\xf5\xd5"
          "\xc1\x60\x66\xbe\x0e\x95\xec\x06\xee\xe4\x2a\x7d\xee\x76\x36\x83\xf9\xc9\x3f\x64\x82\xc9"
          "\x59\x0e\x4a\x82\x0c\xe2\x9d\x7e\xfe\xdb\x69\xb3\xb2\x99\xd2\xf0\xef\x73\xdc\xea\xfb\xd8"
          "\xdb\x82\x93\xd7\xf5\xfe\xd1\x44\x95\xe1\x8d\x37\x2a\x53\x6a\x95\x83\x88\x14\x81\x6d\xe8"
          "\xb9\x8b\x7f\xf5\xce\x01\x95\x44\xdb\x97\x94\x73\x12\xdb\x6c\x98\x00\x85\x6a\xe7\x52\x78"
          "\x98\xd8\xeb\xa6\xd3\x37\x8c\x8a\x3b\x40\x0c\xf4\x55\x3e\x7b\xca\x9f\x51\x01\xa8\x48\x90"
          "\x4b\x5c\xbe\x24\xa6\xfc\x8a\xee\xd1\x78\x9d\x20\xa0\x11\x0a\xf1\x45\xdc\xf7\xd7\x0b\x5f"
          "\x33\x6e\x41\x12\x56\xc0\xba\x60\x42\xe6\x9b\x97\x6d\x1b\x18\x17\x68\x11\x65\xd8\xf8\x85"
          "\x0e\x0a\x2a\x34\xe6\xb1\x93\xf9\x05\x08\x76\xb5\x32\x47\x16\x56\xd4\xa7\xd0\x80\x99\x84"
          "\xd2\x6f\xa6\x81\xd1\xb1\xe1\x45\xf8\x22\x0c\xde\x6f\x1d\x98\xe2\x61\x14\xd5\x78\x08\x8e"
          "\xbf\xa8\xd7\x5b\xb4\x1a\x53\xa5\x7c\xc3\xe6\x05\x27\x09\x76\x70\x14\x3e\x51\x56\xf5\x00"
          "\x54\x3a\x2c\x00\xbd\x95\x56\x04\x96\xe1\x94\xe7\xde\x1a\x1f\xb7\x60\xe2\x1a\x97\x09\x84"
          "\x3d\xf9\xb9\xa3\x39\xdc\x98\x80\xf2\x89\x32\x1b\x61\x0a\x8d\xaf\x04\x89\x8e\x4c\xe5\x91"
          "\x63\xee\xda\x65\x8f\xd2\x65\x43\x93\xe8\xbe\xc1\x7c\xba\xa5\xd7\x87\x86\x19\xaa\xd1\xc6"
          "\x73\x87\xfe\x2a\xac\x5b\xcd\xfe\xf8\x8c\x19\x06\xbc\xcc\x21\x3d\x76\x0b\xff\xea\x03\x68"
          "\x02\xb7\x92\x48\x38\xd6\xd4\xcf\x32\x68\xf9\xb1\x80\x46\x34\xa6\x7b\x53\xfe\x49\x36\x03"
          "\x03\x2f\x73\x70\xe0\xdf\x12\xf5\x30\x15\x77\xbd\xb3\x8e\x17\x79\xaf\x61\x59\xfd\x95\xf6"
          "\xa6\x78\xb7\x37\x9c\xe2\x3a\x49\x8b\xab\xe4\x67\x45\x81\x21\xf1\x8c\xea\x26\xe1\xd8\xb5"
          "\x84\x75\x55\x0c\x74\xc4\x09\x34\xc7\x1b\x27\x7f\x65\x76\x7f\x66\x48\xec\x97\xdf\xcd\x31"
          "\x1c\xec\x11\x7f\x24\x85\xdf\x1d\xb0\x97\xc1\xd0\x1c\xa0\x72\x29\xaf\xd5\x4a\xc8\x90\x69"
          "\x52\x9e\xf2\x37\x57\x57\xcf\xaa\xec\xac\x70\xaa\xd2\x57\x2a\xf9\xb4\xf4\xa6\x7f\xbc\x28"
          "\x15\x78",
          1, 3712 },
        { 128, 256, 92,
          "\x9c\xad\x46\x2d\x5f\x66\x59\xb2\xdd\x89\xa6\x8d\xaa\x5b\x7f\x14\x64\x4b\xa2\x48\x82\xc3"
          "\x7e\x97\x32\x23\xac\x4a\x87\x5e\x51\xb3",
          "\x92\x69\xb2\x44\x71\x08\x02\xc3\x7e\xc0\x1a\x38\xfc\xae\x78\x2b",
          "\xf9\xe5\x63\x06\xd0\x1d\xd5\x5d\x4c\xde\x17\x40\xe6\xf0\xbd\x2a\x2a\xa9\x89\xf8\x52\xf0"
          "\x89\x20\x37\x60\x1f\xd7\x1d\x15\x0e\x40\xb5\x1c\xa0\xb0\xc5\x32\xc1\x64\x84\xca\xb4\x8b"
          "\xb7\x7b\xad\x85\xe7\x65\x21\xbd\x6a\x65\x53\xe9\x3f\x50\x22\xd4\xee\xb0\xa6\x98\x6b\xf0"
          "\x14\x01\xa9\x5d\x76\xdd\xd6\x34\x10\xfd\x5c\x75\xbe\x7e\x69\xde\x08\x9e\x27\xfc\xd5\xcb"
          "\xb1\x1a\x6b\x4c\x1b\xec\x80\xc8\xd9\xc0\xfb\xa9\x51\x4f\x62\xdb\x57\x3b\xf0\x7b\x16\x10"
          "\xcd\xd9\xbf\xcf\xff\x71\xd7\x9c\xf7\x4c\x8e\xc2\x5d\x2e\x39\x03\x6e\xb7\x03\x93\xc5\x04"
          "\x02\x40\x19\x79\x35\x88\xc7\x62\xf3\x85\x81\x4b\x4b\x31\x1b\x1e\x04\x67\xcb\x38\x34\xd3"
          "\xc4\x30\x73\x44\x25\x04\x8e\x6a\xfe\x40\xee\x83\x80\xf5\xb0\x8c\x8a\xe1\x58\x17\x2d\xea"
          "\x9c\xa5\x31\x51\xc3\x50\x93\x3c\xed\x0f\x42\xde\x8b\x01\xc5\x16\x7c\xd8\x6b\xe0\xa6\xc5"
          "\xc4\x5e\x3a\x66\x1b\x7a\xb6\xf5\x1c\x73\xee\xb8\x70\x7c\xa4\x58\xc8\x26\x1f\xc8\x83\x19"
          "\x02\x80\xfa\xde\x3d\x92\x05\xff\x40\x4a\x69\x3d\xf7\xe2\xe4\x09\x24\x15\x7e\x2e\x20\x1e"
          "\xc0\x94\x44\x49\x43\xcb\x24\x92\x5f\xed\xd4\x94\xaf\xa7\x8a\x7d\x85\xd9\x07\x34\x51\x63"
          "\x5a\xe8\xf0\x9e\xc9\x59\x85\x8d\x58\x7d\x3b\x89\x4e\x9a\x46\xb3\x1d\x7a\x64\xf7\x5c\x7c"
          "\xa9\xcc\xe7\x69\xa1\xf2\x7c\x2f\xdc\xad\x5d\xf8\x62\xeb\x34\xdb\x48\x5f\x58\x91\xb4\x99"
          "\x38\x3e\x49\x4e\x26\x67\xb9\x9c\x5b\x91\x3b\xaf\x6d\xd0\x50\xdb\xa9\x87\xdb\x14\x99\xd9"
          "\xa8\x5e\x21\x4e\x85\x7b\xa9\x81\x4e\x5c\x7e\x39\x4f\x6b\xfd\x61\xa4\xc3\x37\x6d\x46\x68"
          "\xbb\x11\x09\x73\x0d\x81\x54\xf3\xd3\x7c\x01\x0c\xa3\xbf\x59\xd5\x4e\x82\xfd\x26\xbc\x76"
          "\x64\x5a\x57\x11\x4c\xb0\x25\x98\x29\x5d\x0e\x06\x1e\x51\x20\xaf\x9c\x7e\x4e\xc1\x99\xe6"
          "\xed\x59\x0c\x0e\x58\x99\x11\x8d\x43\x2d\x67\x4b\x1b\x6d\x61\x17\x80\xc9\x96\xc6\x85\xb0"
          "\xdb\x4a\x20\x3a\x1a\x8b\xb8\x14\x08\xdc\x6e\x94\x79\xfd\x43\x60\x75\x96\xdf\x1f\x6a\x39"
          "\xd7\x7c\x94\x7c\x92\x44\x7f\x79\x00\x15\x0f\xc1\x8b\x43\x5d\xbd\x14\xdb\x2a\xff\x4e\x7f"
          "\xd3\x88\xfc\x8d\x88\xe0\x4c\xb8\x2c\xaf\x17\x09\xff\x51\x5d\xe4\xd5\x5d",
          "\x21\x7e\x55\x06\x98\x60\x00\x34\xd3\x31\xf4\x9e\xd6\xb4\x85\xbb\x7f\xd4\x75\xf6\xda\x9b"
          "\x03\xed\x78\xc4\x84\x70\x05\x41\x14\x53\x98\x13\xbe\x0d\x46\xeb\xe8\x36\x25\x50\x6d\xe4"
          "\x37\x37\x59\xf7\xb8\xac\xf6\xaa\x2e\xc1\xfe\x8f\x60\x24\xc8\xb8\xdf\x63\x45\x83\x05\xb0"
          "\xb6\xb2\x5e\x90\xef\x7c\x41\x1d\xf5\x98\x1d\xe5\xd4\xb8\x9d\x95\xa5\xb2\x5d\xf9\x4c\x8a"
          "\x81\xf4\xf4\x93\xb1\x6e\x87\x55\x15\xfb\x02\xf9\x43\x17\xf1\xea\xd6\x9b\x53\x0f\x2c\xbc"
          "\xfd\xb0\x79\x06\xcc\xee\x6e\x1f\xe4\x67\x12\xe0\x72\x45\xe2\xb1\x50\x05\x47\x46\x8d\x3a"
          "\x5e\x14\x9d\x14\xd4\x00\x22\x9a\xf1\xf0\xaa\x1c\x39\x9c\xa7\xed\x0b\x7b\x40\x43\xb3\x77"
          "\x66\x96\xf1\xc0\x26\x84\xb8\x66\xcf\xe8\x5e\x9c\x93\x78\x70\x7b\x3e\x24\xfe\x6e\x25\xde"
          "\x24\xc6\x07\xca\x40\x7a\xca\x43\x2c\x33\x1d\xa2\x4d\x22\x87\xf0\x47\xba\xe3\xd3\x88\x98"
          "\x34\x02\x65\x8b\x92\xbe\xa6\x72\xc4\x1b\xcc\x67\x93\x5a\x68\x7f\x53\x41\x39\x77\x64\xe4"
          "\x58\xf0\xd8\x8a\x5d\x05\x09\x66\x3b\x91\xd4\x81\x3a\x6f\xaa\xd2\x4b\xdb\x60\x8a\x28\x06"
          "\x1d\xd0\x94\xa5\x0e\x75\x4d\x78\xdd\x74\xdd\x15\x6d\xa3\x15\xa3\xea\xf3\x64\xea\x33\x33"
          "\xed\xfa\x80\x8b\x9a\xd6\x26\xad\x89\xb6\x52\x1a\x1a\x52\x85\xb7\xcc\xf6\x08\x46\xf4\xe6"
          "\x80\x7f\x2c\xc4\xd0\xe1\xa4\x90\x11\x71\x2c\xad\xcf\x89\x7e\x14\x7a\x98\x1a\xd5\x5b\xbb"
          "\x2b\xdd\x35\xf3\xbf\xc4\xac\xe8\x1f\x5f\xf7\xcd\x8a\xc9\xd3\x8b\x7d\x46\xf6\x63\x9c\x07"
          "\x4a\xc8\xee\x6a\x9b\x16\xf0\xfa\x6a\xf8\xc1\xd1\xa3\x53\x07\x84\x06\x75\xcf\x71\xde\x9c"
          "\x81\xee\x03\x11\x10\xb5\x36\x00\xba\x57\x2a\x57\xb6\x4c\x67\xa1\xdd\x5b\x1e\xd5\xbe\x9c"
          "\x94\x9a\xf6\xea\xc4\xdf\x89\x76\xd7\xaa\x1d\xc8\x18\xca\xed\x95\x37\xad\x37\x2f\x33\x2a"
          "\xcc\x6f\x2d\xb2\x90\x4c\x3a\x55\x0c\x31\x8f\x39\xd3\xc9\xc6\x9c\x71\x09\x6f\xd4\x5b\x0c"
          "\x85\xb4\xfd\x52\xd4\x72\xca\xc9\x14\xbb\x5b\xcb\xa3\xba\xad\x93\x91\xcc\x00\x1d\xfe\x34"
          "\xab\xa3\x76\x16\x6d\x63\x8f\xaa\xb1\x01\xf6\x2e\x00\x62\x32\x08\xa1\x08\x08\x90\x00\x52"
          "\xef\xcb\xc6\x71\xe2\x36\x8a\xf8\xe3\x44\x6d\xec\x7c\x60\x48\x8f\xbb\xc3",
          1, 3840 },
        { 128, 256, 93,
          "\x61\x64\x7d\x8f\xf7\xa1\xa3\x11\x5f\x78\xb4\x8a\x99\xc1\xc1\x5b\xc7\x3e\x92\xe0\xb9\x92"
          "\xb8\xe2\x70\xcc\xde\xbf\xa2\xfe\x2d\x03",
          "\x31\xdb\x2d\x86\x31\x22\xce\xbe\xdc\x1f\x84\x08\x80\x17\x3a\x33",
          "\x09\x2b\x86\xb9\xb9\x3c\x35\x52\xf4\xc9\x6f\x89\xe9\xf5\x18\x75\x40\x65\xac\x16\x59\xd5"
          "\x48\xc9\x9d\x23\x31\x8c\x33\x2b\x50\x46\x15\x8c\xa1\xd0\x20\x8b\x80\x5b\x09\xc4\xac\xc1"
          "\x72\xd3\x07\x4a\x03\x26\x25\x65\x8c\xdf\xc2\xfc\xc5\x66\xbf\xd1\x41\x22\xff\x69\x2c\x56"
          "\x8e\x20\x11\xf9\xb3\xb3\x69\xd3\x70\x02\xf8\xc4\x11\xbf\xe3\xa5\x34\x3a\xa6\xa4\x9d\x28"
          "\x7a\x0f\x6c\x97\x35\xcf\xf2\x45\x80\x64\x42\xa6\x21\x4b\x89\x3f\xd3\x00\x93\xaf\x51\x86"
          "\x78\x4a\x4f\xb1\x91\x1d\x4b\xc2\x4c\x54\x3e\x87\x9e\x4b\x4e\x0a\x80\x66\xbf\xa1\x02\xd0"
          "\x5a\x4e\x00\x6f\x76\x05\x9b\xd0\x9d\x0b\x3f\x7d\x83\xed\xc5\xb6\x70\x20\x96\xc6\x0f\xb8"
          "\xcb\x97\xd1\xf0\x87\xa3\xea\xa8\x9e\x09\xe7\xe4\x48\xeb\x7c\x8e\x23\xa1\x09\xf5\x4d\xe0"
          "\x21\x42\xfc\xcb\x3f\xdf\x83\x65\xa6\x8c\xf4\x06\x0f\xbc\x58\x6a\xd7\x04\xba\x75\x8b\xac"
          "\x2d\x04\x3d\x2d\x0f\xda\x92\xa5\xb1\xe8\x37\x86\xa8\x79\xa0\x09\x9b\x00\xf6\xef\xab\xe3"
          "\x34\x6e\xc3\xdc\x1b\x3a\x07\xd9\xb7\x9a\x1f\xdc\x39\x88\x76\x32\xc2\x92\x37\x23\x4a\x03"
          "\x14\x48\x2b\xf4\xac\x16\x0b\x8e\x0d\x27\xe5\xe1\x60\xb1\x99\xfe\xb0\x8c\x40\x5b\xa3\x60"
          "\xfc\x84\xc3\x72\x2f\x7f\xae\x58\xab\x5c\xc7\xde\x68\x86\xec\x38\x31\x68\xdb\xb5\x73\x84"
          "\x26\x68\xfe\x05\x90\x2f\xa2\x82\xed\xa1\x34\x5b\xa1\x52\x47\x9a\xb4\x23\x1b\xe8\xf6\x1b"
          "\xda\x6b\x36\x70\x6e\xee\xba\x30\xf5\xea\xf4\x50\xb3\x44\x7c\x4a\xab\xbc\x42\xe3\x1f\x0e"
          "\x90\xde\xc8\x2a\x65\xab\x3e\x32\x0e\x66\x24\xfa\x86\x4a\xc8\xf3\x6e\x9c\x5e\x99\x45\x9b"
          "\x47\xf2\x49\x51\x70\x8a\x13\x27\xba\x55\xe7\xcb\xa8\xd7\xf6\x65\x7b\x8f\x27\x68\x01\xb8"
          "\x3d\xe3\x66\x4c\x6c\xaf\xa9\xbd\x0d\x87\xbe\xdd\x36\x30\x81\xa9\xd9\x42\x8a\x58\x68\x90"
          "\x53\xd1\xf0\x5a\x29\x25\xc5\x25\x5b\x05\x0e\x2b\x6e\xff\x37\xda\x1c\x2a\x88\xc2\x19\xd6"
          "\x3f\xfd\x58\x22\x38\x27\x11\xe1\x5d\x09\xfd\x52\x56\xec\x3a\xc4\xa0\x49\x08\x06\x69\xa7"
          "\xb0\x12\x67\x57\x58\xfc\xdd\x6a\xf5\x65\x76\xc9\x07\x51\xe6\xf2\xe9\x85\xcb\xea\xd8\xcb"
          "\x75\x5e\xd5\x9a\x33\x05\xf8\x05\xbc\xef\xc6\x3e\xc7\x6b\xe1\xaa\x80\xd4\x5c\x95\x31\xa1"
          "\x9f\x4a\x0c\x80\x88\x41\x9a\xb0\xa1\xf1\x95\x10",
          "\xe3\x25\xfd\x1b\x32\x97\x8b\x74\xa9\x9e\xf1\xb7\x2e\xb3\x3c\xf2\xc7\x1a\x79\x78\x9c\xd3"
          "\xbe\xa0\x8c\x78\x9e\x6d\x14\xce\x27\xdb\xa4\xc3\x4c\x47\x71\xdd\x49\x04\x20\xf8\xd4\x9b"
          "\x34\x02\xab\xde\xa9\xe5\xa7\xc7\xc0\x77\x2e\x31\xce\x0e\x30\x8b\x2d\x1e\xa9\x60\x17\xc2"
          "\x95\x08\x29\xe9\xb8\xe6\x13\x1d\x2c\xa8\x64\xb5\xd4\x97\xdf\xf7\x5b\x26\x1e\xd9\x78\x38"
          "\x3c\x09\xd6\xbb\x5e\x8b\x1b\x7f\xe9\x34\x4a\x88\xb3\x45\xc6\xb4\xa2\xe5\xcb\x88\x4e\xd0"
          "\xd0\xf5\x39\x3e\xec\xec\x3f\x3a\x32\xa4\xc5\xee\xe0\xc5\x3e\x95\xb2\x1e\xcb\xa2\xe3\x4c"
          "\x74\x61\x62\xb4\x9b\x78\xca\x18\x75\x09\x72\x7d\xdf\xa1\x7d\xaf\x44\x3a\x9b\x45\x26\x54"
          "\xb5\x73\x4f\xc3\xbc\xc7\xa2\x5c\xe8\x95\x67\x6d\x1f\x39\xec\x9a\xa3\xc0\xd4\x15\xe9\xd9"
          "\xc3\xdc\x17\x3b\x16\x79\x9c\x01\x6e\x8e\x21\x62\x59\x36\x99\x87\xa2\xc3\x66\x72\xb4\xad"
          "\x99\xf7\xb7\x1b\xd3\xce\xeb\x86\x3a\xeb\x4d\xb7\xae\xe2\x31\xce\x63\x47\x87\xc5\xab\xff"
          "\x5a\x87\xe7\x8d\xe7\x29\x7b\xa0\x80\x38\x37\xb5\x80\x3d\x79\x01\x26\x85\xa2\x4d\xbd\xd0"
          "\xd7\x2c\xfb\x2b\x33\xb3\x46\x49\x64\x26\x6a\xcc\xd8\xde\xdb\x84\x7f\x4c\xff\x61\xc2\xf9"
          "\xd5\xe1\x7b\x2e\xaf\x22\x3e\xe5\x2f\xd1\x81\xec\x83\x44\x54\x3a\x05\x3b\xc0\xdb\x86\x15"
          "\x55\xd5\x0e\x2b\xfc\xe3\x05\x60\x14\xcb\x5a\x6a\x96\x4b\xd0\x32\xc6\xe1\x21\x0b\x18\xd3"
          "\x40\x2e\xff\x42\x91\x02\x41\x9d\x3b\x00\x0c\x51\xd5\x72\xb0\xed\x6e\x89\x98\xb0\xdb\xd1"
          "\x8c\xc4\x4a\x27\xab\xbf\xdb\x14\xbd\xbc\x12\x80\x56\x8b\xaf\x63\xad\x74\x30\x13\x44\x90"
          "\xb0\x70\x5d\x5a\x24\x2e\x05\x42\xee\x8a\xfd\xb1\x23\x9d\x46\x29\x58\x29\xe9\xd7\xc0\xe9"
          "\x78\x0d\xca\x58\x9b\x1f\xb5\xa2\x24\x9a\xbc\x44\xa3\x06\xd1\x60\x4c\x29\x72\xd5\x77\x32"
          "\x3d\xf3\xb0\x9e\xe8\x40\x65\xa1\x39\xaa\xc0\x42\x07\xc6\xe5\x1f\x43\x58\x0b\x55\x8f\x54"
          "\xfd\x5a\x6d\x37\x77\x94\xc9\x9d\x70\x33\x04\xb9\xb1\x61\x15\xd8\x3f\x6d\xc5\x1a\x81\x31"
          "\x89\xd4\x63\x0b\xfb\xdb\xcc\x56\xc7\xee\xc9\x35\xf9\xcd\xaf\x5c\x1a\x52\x05\x45\xf7\xef"
          "\x04\x65\x9b\x4a\x7a\x53\xcf\x93\x28\x75\x4d\xfe\x08\x75\x3c\x85\x15\x94\x4e\xfb\x43\xe0"
          "\x5e\x50\xe9\x2f\x95\x31\xbe\xb3\x94\x11\x8b\x49",
          1, 3968 },
        /* Vectors from Auto generated */
        { 128, 128, 1, "\xe7\x2c\xcf\x7c\xf4\xe7\x61\x6e\xce\xe9\xc1\x25\xd3\x29\xcf\xd6",
          "\x8c\x65\x4a\x31\x71\xa2\x07\xb1\x3e\xf3\x5a\x83\x07\xb5\x04\x22",
          "\x9e\x0f\x5f\xd1\x66\x40\x08\x74\x3b\xe7\x7b\xf1\x41\x27\xf2\x21",
          "\xa9\xde\xe4\x24\x88\x3e\xf4\x2b\x89\x63\x60\x10\xe6\x93\xc9\xe3", 1, 128 },
        { 128, 128, 2, "\x91\xee\xcf\x96\x62\x3c\x52\x1f\x3d\xeb\x28\xea\x4b\x16\x30\x82",
          "\x4e\xd8\x2d\x68\xd3\xce\x84\x88\xad\xa9\x6a\xdd\xda\x28\x54\x4c",
          "\x81\xea\x94\xe3\xfd\x33\x59\x2e\x68\x37\x36\xff\xf3\x06\x52\x07\x06\x41\xd2\x0f\x16\x7e"
          "\x7f\x25\x08\x03\xbd\x7f\xff\x53\xbd\x76",
          "\x19\x09\x83\x1a\x0e\xd6\xbe\xa7\xd9\xbf\x1d\xfc\x79\x76\x0e\xfb\x33\x93\xc8\x95\xcb\x5a"
          "\x99\xdd\x43\xb5\x81\xaf\x3e\xcf\x5c\x8f",
          1, 256 },
        { 128, 128, 3, "\xed\x4d\x58\x8a\x7b\xf6\x94\x36\x88\x35\xa9\xca\xcd\x68\x3a\xb4",
          "\x5d\x0e\x25\xfb\xf4\x2f\x03\xcc\xdf\x5d\xd8\x96\xa3\x42\xa0\x0a",
          "\xe4\xaf\xf4\x41\xed\xc0\xaf\x31\xe5\xca\xae\x4f\xfc\xb5\xc5\x54\x5a\x71\xca\xb0\x2c\xf4"
          "\x2a\x6c\xe6\x38\xfa\x3e\x65\xfa\x03\xdd\xe3\xd7\xaa\x11\xf1\xc0\x71\x51\x4d\x37\x3d\xe2"
          "\x20\x42\x89\x3f",
          "\x50\x61\x0e\x7f\xb2\xbe\xce\xe5\x3d\x7e\xd8\x24\x74\xfb\xc5\xe5\x1b\x4b\xb5\xe0\x3e\xbd"
          "\xf7\x4e\xb0\x0e\xb8\x20\x58\x31\x74\x67\x86\x65\xe8\xb7\xa7\x33\x06\x98\x38\x9b\xb2\x8d"
          "\xef\x5b\xc9\xfb",
          1, 384 },
        { 128, 128, 4, "\xeb\x7e\x26\x83\xf1\x30\xe9\x73\x73\xce\x3d\x6e\x58\xcc\xf1\xf4",
          "\x6e\x29\xfc\x1b\x3b\x15\x29\x9b\xa1\x92\xa7\x40\xb6\xa5\x16\x8a",
          "\xbb\xe5\xbd\xd4\x9a\x39\x57\x59\xb8\x11\xbc\xa7\x8f\x06\x66\xd5\x7a\x02\x8d\x7e\x20\x5f"
          "\x08\x72\x47\x45\xe4\x26\x4b\xc0\x2d\x40\x7a\x8b\xc4\x17\x5b\xa9\x02\xb4\x71\x25\xfd\x3b"
          "\xcd\x3a\x1e\xf0\xd8\x82\xcf\x8f\x01\xfa\xa0\x05\xc6\xb0\x99\x57\x14\x00\xec\xe9",
          "\x2c\xf2\xac\x57\x95\xfa\x65\x84\xa1\x4d\xee\xde\xcf\xec\x39\x9d\xc2\x04\x1d\xaa\xfb\x4c"
          "\x92\x13\xee\xe7\x5c\x3b\x1c\xec\x0b\x5b\x9f\x41\x06\x9c\x1b\xb1\xfd\xcb\xba\x99\x06\xdb"
          "\x37\x53\xc1\x48\xde\x8e\xa5\x13\x8b\xb0\xf6\x65\xb2\xc3\xd2\xf4\xa5\xad\x29\xb8",
          1, 512 },
        { 128, 128, 5, "\x44\x58\xf9\xc2\xa1\x7b\xc8\x87\x08\xa5\x00\xe4\xba\xd8\xbc\x3e",
          "\xe1\x84\x61\x4d\x8b\x3a\x2b\x3f\xba\x2f\x1a\xd9\x43\xd3\x87\x19",
          "\xcd\x1b\xe6\x4f\x24\x9a\xe4\xe2\x61\xde\xee\x7f\x71\xef\xa2\x61\x8a\x16\x9f\x4b\xae\x6f"
          "\x89\x96\x5b\xfd\xcf\x28\x24\x60\x2e\x14\x37\x73\x94\xad\x86\x91\xc7\xd4\x48\xba\xe0\x5e"
          "\x0a\x98\x4a\xb7\x7e\x83\xdd\x64\x0f\xf2\x76\x91\xc3\x34\x7c\x61\x0d\x7c\xfc\x17\xe0\xe5"
          "\xdf\x0e\x19\xd7\x2e\x59\x10\x2f\xba\xef\x1c\xa7\xc5\xc4",
          "\xe3\xb3\xc5\x7a\xc9\x9a\x96\x1c\x60\x68\x35\x23\x62\x74\xe4\x30\x4f\x9e\xca\x36\x11\x52"
          "\xb6\x45\xe3\xce\x1d\x04\xba\xcc\xce\x89\x4a\xc0\x0d\x5d\xaf\x0b\x66\x6e\xee\x8d\xbe\xe2"
          "\x50\x3c\x53\xc1\x8c\x7e\x40\x7f\x4b\x3e\xba\xbc\xa1\xe3\xfe\x1d\xc8\x66\x63\x4c\x64\xb9"
          "\xe1\x9e\x1e\x30\x6e\x75\xd6\xed\x47\x02\x36\x58\x1b\xec",
          1, 640 },
        { 128, 128, 6, "\xce\x0b\xb4\x56\x2b\x93\x7e\x2e\x83\x2a\xec\x89\x5b\xac\x4a\x3e",
          "\xff\x1f\xa6\xc3\xd0\x2c\x5e\x57\xe0\xca\xc6\x76\xde\x6a\x4d\xc6",
          "\x67\xb3\xa4\x21\x94\x38\x8a\x51\x78\x35\xce\x27\x45\xad\xb3\x76\x5f\x28\x10\x88\xd6\x51"
          "\x44\x25\x38\xd7\x96\x8b\x1b\xd0\x57\x57\x8d\x5b\xce\x34\xa0\x62\x46\xe5\x70\x09\x32\x5a"
          "\xb8\x27\xc7\x0f\x42\x45\xdc\x4c\x87\xc4\x9a\x2c\x2e\xda\x49\xe1\x82\xfa\x32\xc2\x23\x69"
          "\x0c\xf1\xc4\xac\x6c\x2c\x30\x13\x5f\xc0\x71\xd6\x20\xd7\xf8\xc4\x0c\xa8\x4b\x12\xea\x61"
          "\x4a\x37\x86\x79\x35\x9e\xfe\x36",
          "\xad\x64\x87\x34\x60\x22\x80\x9d\xd3\x48\xbe\xc9\xfc\x94\x4f\x9b\xc4\xdd\x52\x9c\xd1\x15"
          "\xd9\x3d\x59\x2d\xe4\x2d\x6d\x40\x47\xda\xa4\x42\xe6\xa0\x63\x71\xfc\xc8\x49\x71\x69\xb8"
          "\x0c\xb5\x01\xa7\x2c\x80\xe5\xa6\x74\x6d\x57\x30\xc7\x90\xaf\xe0\x88\x76\x85\xd8\x3f\x83"
          "\x0f\x79\xca\x46\x9c\x61\x65\xcb\xb6\x5a\x00\x8e\x34\xac\x21\xa9\x50\x02\x1a\x83\x3e\x52"
          "\x7c\x05\xee\x03\xe8\xe9\xa8\x87",
          1, 768 },
        { 128, 128, 7, "\x61\xa5\x86\x67\x12\x8a\xbf\xad\x14\xe7\x91\xc2\xbe\xca\xf0\x37",
          "\x7d\x5b\xbb\x97\xa0\xcc\xce\x20\xe4\x97\x8d\xfe\xa4\xef\x03\xb9",
          "\xf1\xdc\x5d\x5d\xa0\x0c\x6a\x1c\x9f\x99\x48\x1f\x42\x76\x9f\x69\x06\x3e\x3d\x33\x4c\x99"
          "\xe2\x2c\x55\x58\x28\x9a\x64\xfb\x1e\x73\x0b\xf3\xbe\xa8\x48\x70\xb9\xe1\xae\xaf\xc1\x2e"
          "\x18\x24\xa7\x3f\x96\x65\xa1\xfc\x39\x97\x93\x4a\x79\x6c\x2b\xd0\x6a\x74\x85\x2b\x72\xdc"
          "\x56\x55\xf5\xa1\xad\x83\xf2\xcd\xf1\x27\xa6\xab\x7c\xa1\xa5\x26\xdd\x6b\x9b\x8f\x2d\x50"
          "\x8a\xe9\x6a\xaf\x29\xb3\x6b\xfa\x14\x36\x60\x54\xc4\x0d\xe5\x1a\xeb\x87\xc0\xc5\x6a\x44"
          "\x36\xe6",
          "\x0c\xb7\x6d\x81\x0f\x2e\x5f\x11\xb6\x61\xd5\x27\xea\x8e\x0a\x0d\x22\x1a\x3b\x4f\x03\xaf"
          "\x1e\xf6\x29\x92\xe6\x40\x80\x96\x35\x83\x6d\x13\x4f\x54\x2a\xcd\xb5\x56\x44\xd8\xa0\xca"
          "\x9b\x07\xca\x63\x68\xe8\x04\x28\x21\xe6\xc9\x94\xeb\xa2\x06\x63\x01\x05\x73\xc1\x20\x87"
          "\x76\x53\xf7\x27\xc5\x9e\x9f\xd0\x65\x48\xea\xa8\x1d\xdd\x1e\xc8\x27\x15\xc5\x02\x29\x2e"
          "\xaa\xca\x4e\x3f\x53\x30\x70\xd3\x37\xb9\xa0\x9d\x79\xda\xd9\x33\xa5\xb6\xad\x5b\x20\x20"
          "\x54\x5d",
          1, 896 },
        { 128, 128, 8, "\x0e\xb9\x8a\xc1\xe8\xbe\xf6\x8d\x6f\x4f\xec\x4f\xfc\xe3\x42\x26",
          "\x9e\x40\x09\xe5\x1a\x5b\x5c\xab\x5e\x25\x40\x12\xa9\xae\xa4\xfb",
          "\x24\x03\xdf\xb1\x94\xf1\x0c\x95\xbe\xa1\x59\xd6\xab\xcb\x57\xcc\x81\x7b\xe5\x93\xad\xce"
          "\x34\xa6\xc3\xda\xdf\xec\x6a\x1a\x33\x0f\xda\xd6\x46\x1c\xe2\x78\xb3\xf2\xc9\xb4\xc4\x5c"
          "\x70\xf4\xf6\x65\x86\x97\xdd\x32\x76\x35\x5e\x6b\x7c\x4d\x6f\x9a\x2a\x17\x84\x98\x9b\x29"
          "\x69\x4f\x2a\x44\x1f\x4a\x07\xad\x63\x30\xbb\x87\xc9\x9a\xd5\x0e\xf8\x8f\x63\xae\xa4\x2f"
          "\x33\x49\x62\x13\x2e\xac\x9c\xba\xa8\x74\x06\x4b\xf7\x81\x30\x16\xef\xbb\x32\x88\x6a\x16"
          "\x1c\xfc\xab\x21\x73\xfb\x95\x80\x43\xc7\x21\x12\xb1\xaa\xfc\x91\x31\x64",
          "\x24\xcc\x7a\xff\x84\x60\x23\x45\x14\xa6\x0f\x3f\xf5\xd3\xae\xfd\xfa\x9b\x28\xa7\x36\x7c"
          "\xfc\x53\x10\x97\x44\xae\x92\xae\x49\x93\x4d\x05\x64\x88\xb6\x9a\x4f\xdb\x0b\x19\x21\xc4"
          "\x30\x83\x0e\x03\x90\xe0\x13\xa8\x04\xe7\x8e\xb2\x3f\xa5\x28\x5e\xc9\x55\xe5\xef\x87\x4a"
          "\xc2\x3d\x7b\x19\x75\x2d\x85\x8d\xfe\x13\xcd\xd4\xee\x18\xe0\xc9\x41\x74\xf5\x1f\xf8\x4f"
          "\x85\x17\x5e\xa2\x28\xec\x80\x54\x91\x7b\x2c\x33\xe8\x65\x89\xaa\xbd\xfd\x73\xb0\xb1\x36"
          "\x11\x2b\x7f\x53\x95\x93\xca\x6f\xc7\x5f\xad\xf6\x3f\xe1\xc7\x19\xc9\x0c",
          1, 1024 },
        { 128, 128, 9, "\xf6\x8c\xd8\xa4\x5f\x10\xa6\xa7\x68\xaf\xcb\x41\x44\x98\xf4\xf2",
          "\x68\x23\x18\x5c\x3f\x77\x8e\xde\x42\x34\xce\xa9\x2a\x58\x2d\xd3",
          "\xda\xab\xd1\x52\xa6\xea\x55\x85\xc9\xe3\x18\xc0\x5d\x46\x27\x5d\xe7\x4b\xa8\x88\xdb\xaa"
          "\x42\x8a\xf7\x0d\x92\xc8\xea\xac\x86\x43\xaa\x5d\xd3\x10\x8c\xe1\xe6\xa3\x12\xd0\x41\x88"
          "\xe6\xf0\xd5\x17\xc1\xa9\xa4\xbf\xc5\x1f\xaa\xa7\x2d\xc9\xbe\x6e\xc1\x69\xab\xce\xc4\x45"
          "\x09\x7f\xd3\xf7\xc2\x20\x3e\x42\x37\x15\x92\x49\x22\x99\x04\xa3\xbb\x53\xc3\x6e\x6e\xf3"
          "\xd9\xdd\x06\xbd\x1b\x5f\x2a\xc2\x0d\xda\xa7\x2b\x2c\x31\x07\x15\x19\xd7\xfe\x49\xd4\xc8"
          "\x53\xbf\x47\x7f\x7d\xee\x48\x3e\xf7\x85\xcf\x0b\x66\xf0\x38\xb7\x52\x40\x61\x78\x3d\x68"
          "\xf4\x29\x55\x6a\x88\x21\x79\xc1\xb7\x9b\x67\x39",
          "\x5b\x2f\x80\x1c\x7d\xda\x4d\x61\x13\x17\xbd\x2e\xb7\x51\xc5\xdc\xa7\xb1\xdb\xa9\x9d\x0b"
          "\x3e\x96\xcd\x79\xb9\xd8\xa1\xb1\xb3\x9c\x86\x34\xca\xab\xd9\x9e\x7b\x35\x42\x25\x56\x30"
          "\xa1\x98\x2f\x8f\x56\x3b\xfd\x2e\xfa\xcd\xc0\xdd\x46\x8b\x96\x22\xa3\xfd\x08\x22\x22\xd3"
          "\x8b\x3f\x0a\xd7\xbc\x54\xb2\xce\x4e\x8a\xea\xc4\x9e\x28\x6c\x3e\xa3\xb6\xf3\xc2\x22\xb2"
          "\x45\x71\x69\xaa\x56\xd1\x26\x19\x6c\xdf\x46\x2f\x2a\xde\xf6\x15\x13\xd5\x01\x1c\x24\x12"
          "\x71\xfd\xfa\xc9\x7c\x08\xc4\x8c\x5e\x13\xe0\xef\xe3\x65\x76\x5b\x6a\xab\x67\xc5\x4f\x25"
          "\xa4\x77\x0c\x51\x5f\xef\xa3\x7a\x30\xc2\x26\xba",
          1, 1152 },
        { 128, 128, 10, "\x52\xe1\xfd\x9b\x56\x43\x46\xa4\x47\xb9\xb0\x18\xb9\xaa\x84\x7a",
          "\x2a\x75\x9c\xbc\xf8\x7e\x87\x26\xb2\x0b\x26\xea\x29\x0d\xf7\x47",
          "\xbf\x52\x37\x2a\x87\x6e\x6f\x2f\x22\x0a\xb7\x44\x71\xb4\x08\x3d\x4d\xa3\x6a\xee\x46\x97"
          "\xe8\xe2\x4b\x2c\x9a\x44\x4a\x2a\x3e\xe1\xfc\xe7\x56\x17\xd5\x8c\xb8\x68\x35\x83\x85\xe8"
          "\x63\x95\x46\xdd\xca\x78\x32\x09\x81\x33\x77\x57\x85\x75\xca\x5c\x7c\xb5\x89\x08\xfe\xbf"
          "\x0a\xdc\xe1\xe1\xb9\xa6\x11\xc4\x19\xd1\xd7\x58\xec\x40\x06\x45\x8c\xa2\x07\x74\xc0\xe7"
          "\xee\x0d\x04\x46\x97\x11\xa9\x0c\xb9\xcc\xc9\xed\x95\x08\x6d\x06\x56\x7b\x6f\x61\xde\x0a"
          "\x31\x01\xe7\x07\xc6\x45\xc0\xef\x44\xd0\xeb\x7a\xcd\xda\x79\x17\x19\x0f\x38\xab\x3f\x3d"
          "\x8b\x0f\xd4\xac\x66\xff\xd5\xdb\xc7\x05\x35\x23\x37\x1d\xb0\x3f\x27\x42\x92\x63\xae\x42"
          "\x08\xee\x27\xfd\x42\xab",
          "\x8c\xe2\x9c\x63\xdc\x17\x3e\xcd\x5c\x6c\x1d\xc4\x96\xec\x2e\x1d\x69\x0b\xe2\xe1\x7a\xc6"
          "\x2d\xee\x2b\x63\xa6\x40\x3b\x54\xda\xa4\x55\x65\x27\x3a\x89\x2f\x5b\x04\x33\x06\x1d\x3f"
          "\xe5\x87\x0b\x03\xab\x25\x0d\xba\x5e\x28\x6d\x01\xed\x71\x06\x6c\xc3\x12\x09\x94\x46\x7d"
          "\xde\x2f\x5f\x47\xce\x26\x28\x53\x1b\x46\x21\x46\x71\xad\x18\x53\x50\x0b\x89\x6f\xdc\x4d"
          "\x58\x48\x3c\x97\x23\xc4\x8e\xcb\x77\x8e\xc7\xa7\x57\x26\x78\x1d\x59\xc9\xeb\xa4\x29\x2e"
          "\x84\x80\x8f\x14\xdc\x6f\x74\x72\xf8\x32\x96\xb3\x4b\xb2\x0a\x2c\x3a\xbb\x24\xa1\x49\x61"
          "\x52\x20\xaa\x0c\xcb\x0c\x19\xaf\xde\xd6\x1d\xa4\x38\x6e\x33\x94\x18\xbf\x32\x38\x65\xb2"
          "\x24\x54\x7a\x44\xb0\x47",
          1, 1280 },
        { 128, 128, 11, "\xe2\xdf\x2c\x42\x33\xaa\x78\x5e\x5e\xf1\x9d\x17\xcb\x42\xe9\xee",
          "\x2f\x2c\x30\x43\x67\x97\x7f\x03\x69\xa9\x8d\x44\x13\xb9\xba\xa4",
          "\x3d\x88\x9d\xd9\x2e\xdd\xa9\x98\x67\x85\x48\xa2\x98\x6d\xb3\xcd\x87\xd2\x4a\x62\xb6\x73"
          "\xad\x7c\xff\xe9\x0b\x70\xa9\x14\xfd\x1d\xd6\x2c\xea\x50\x1b\xc7\xe9\x76\x91\xd4\x05\xa6"
          "\xf4\x00\x17\x43\x17\x28\x45\x75\xd5\x2b\xf4\xd0\xc6\x9d\xee\x26\x55\x1d\xf4\x23\x9f\x9b"
          "\x6e\x2c\xf1\xa2\x51\x56\x34\x5c\x3a\x03\x91\x7b\x4e\x23\x0d\xd9\x4f\x33\xb8\x02\xc6\x48"
          "\x73\x57\xa5\x0f\xaf\x25\x4c\xc8\xc0\x74\x3b\x84\x34\xc0\x9c\x27\x64\x66\x79\xdc\x21\x40"
          "\x18\x04\x73\xd5\x95\xb8\xce\xf9\x34\x7c\xaa\xc7\xa7\xca\xca\x25\x68\x31\x21\x62\x63\x3c"
          "\x0f\xe4\x86\xe5\xbb\x27\x25\x51\x1c\x7f\x75\xa2\x02\x2d\x01\xf4\xb6\x53\xbb\x56\x7b\x31"
          "\xcf\xb4\xb6\x0f\x49\x1a\x4c\x20\xe8\xb4\x5d\x97\xf2\x6a\xb9\xe8\x44\xbe\xa4\x5b\x4f"
          "\x00",
          "\x66\xed\xb4\x05\x63\xd9\xfe\x4d\xf6\x74\x6e\x4f\xe7\x6a\xe5\x4b\x4a\x41\x32\xa0\xb9\xc9"
          "\xdd\xb6\xd8\x59\x2d\x23\x29\xcc\x8a\xe7\x1e\xc2\x84\x2e\x5a\x40\x5e\x95\x6e\x55\xfa\xd6"
          "\xc5\x7e\x10\xc6\xc1\x27\xb6\xf5\x91\x84\x8b\x64\xf4\x13\x04\xbd\xc1\xa2\xe3\x94\x4e\x99"
          "\x6c\xa5\xeb\x8c\xd2\xae\x66\x29\x46\x3e\x7a\xda\x5e\xf7\xd8\xa1\xf9\xd1\xf1\xa7\xa7\xde"
          "\x27\xb8\x41\xa8\x53\xf5\xd6\x44\xd2\x85\x35\x85\xc0\x11\x6b\xa4\x08\x2c\x57\x43\xcb\x9e"
          "\x3a\x60\x93\xe3\xce\x2f\xe7\x2c\x3e\xc8\xe9\xa8\xdd\x42\x49\xb7\x95\x22\xa9\xc6\x0a\x04"
          "\xd0\x7f\x3b\xad\x36\x0f\x57\x3a\xb4\x72\x23\xd6\x71\x4b\x70\x51\xa1\x1d\xf5\x0a\xd9\x7e"
          "\x72\x02\xc6\x8b\x18\x73\x1e\x4d\x1a\x0f\xe1\x3c\x89\x60\x56\xb6\x14\xd4\xc1\x97\xb5"
          "\x9d",
          1, 1408 },
        { 128, 128, 12, "\xc0\x7d\xca\x33\xbc\x63\x9a\x43\x2a\x5b\x7f\x1c\x3e\xfe\x61\xd0",
          "\xd1\x5d\x17\xe2\x8f\x52\x42\xec\x10\x1f\xf3\x13\x79\x17\x2b\xfa",
          "\xfb\x32\x62\x80\x13\x2f\x6c\x87\xb4\xfd\x0a\xe3\x7d\xe1\x72\x42\xdf\x7f\xe4\x90\x61\x76"
          "\x13\xe7\xa3\x6f\x1f\xc6\x9b\xc3\x28\xe7\x03\xba\x0a\x7d\x86\x41\x18\x44\x0e\xe6\x86\x91"
          "\xa0\x06\x29\x53\x20\x1f\x79\xf1\x78\xe2\xd9\x83\x0d\x94\x28\x05\xfc\xd9\x6c\x79\x8e\x2b"
          "\xda\xc3\x1d\x83\xc5\xa5\x23\x0d\x5c\x24\x26\x7a\xa8\x24\x99\x41\x32\xb3\x83\x0b\x0e\x5d"
          "\xec\x8f\xb9\x11\xe5\x9a\xbe\xaf\x0c\x79\x80\x6d\xed\xae\xea\x24\xa1\xf5\x9c\x66\x77\xb1"
          "\x06\x12\xd9\x58\xf1\xdb\xa2\xea\xd0\x21\xa9\x67\x99\x3e\xd1\x76\x08\xe8\xa7\x04\x34\x2d"
          "\x86\xa7\x1e\x6e\x9d\x07\xd1\x63\x0d\x5c\x77\x13\xe6\x91\x7a\x50\x68\xc9\xd2\x85\x65\x61"
          "\xb7\xfe\xb7\x46\xf1\x59\x20\x17\x6c\xb5\x1e\x2c\xa7\x50\x08\x80\x3c\xdb\x64\xf1\xe3\x99"
          "\x84\x29\x3c\xd6\xdb\x51\x7d\x3c\xb1\xab\x5f\xfc\x3e\x40\x46\x75",
          "\xa0\xb9\x46\xc7\xe3\x41\x45\xe6\x86\xb1\xa8\x8a\x8c\x91\xbb\x47\xda\xec\xdc\x67\xf7\x78"
          "\x2d\x0b\xe8\x9b\xbb\x5f\xcc\xea\xc9\x9a\x4d\x4a\x46\xab\x24\x3e\xbc\xe5\xa0\xa2\xd7\xbe"
          "\x54\x0a\x76\xd2\x81\xa2\x09\xd5\xc1\xbd\x51\x05\x99\x6f\x7d\x90\xad\x6b\x9d\x83\xac\x7f"
          "\xe7\xe0\x73\x1e\xc9\x98\xd4\x88\x44\x15\x0b\xbb\x7a\xa1\xa0\xa9\x0d\x2a\x1e\xa0\xac\x6c"
          "\x7c\xfe\x7a\x2a\xdc\x32\xef\x0b\xe9\xec\x51\x04\x76\x3b\xc7\x2a\xc0\xdb\xb5\x48\x86\xca"
          "\x05\x0f\x36\x35\xa1\xee\x90\xa8\xb3\xcd\x37\x24\x04\xe2\x82\xb9\x9a\x44\x93\x3a\xe5\x19"
          "\xd5\x1e\x8a\xe2\x94\x00\xca\xf4\x3f\x9c\x19\x48\xd3\xa8\x37\x31\x3f\x87\x7d\x93\xc4\x7d"
          "\xb6\xaa\x7e\x63\x2b\x2b\x50\xed\xd5\x08\xc9\xe3\x5d\x4b\x14\x81\x37\xff\x1b\xae\xcf\x93"
          "\x88\xaa\xc4\x58\x04\xfd\xe6\x65\x9e\xed\xba\x48\x5e\x69\xc5\xa6",
          1, 1536 },
        { 128, 128, 13, "\xb9\x70\x4b\x43\x06\x2f\x8c\xde\x17\x79\xca\x42\x05\xa0\x80\x44",
          "\x0a\x6a\x0d\x78\xd2\xc3\xb6\x78\x6a\x67\x1a\x77\xae\x17\x3c\x62",
          "\x57\xc8\x27\x26\x92\x59\x9a\xfd\x4f\x68\xc3\xa4\xde\x17\x13\x3c\x04\xa2\x50\x9e\x5b\x96"
          "\xb2\xf5\x32\x5a\xdc\x7a\x17\x77\x92\x76\x31\x23\xd5\xcb\x5b\x63\x00\xb7\x8a\xbd\x7e\xc3"
          "\xbb\x8f\x64\xf4\x16\x44\xfd\x06\x48\x7a\x07\xa7\xa8\x7e\xa3\xd1\x7f\xad\xcc\x26\xe4\x25"
          "\x5e\xb3\x90\x4e\x6a\xfa\xfe\xd8\x35\x45\xd0\xb2\xb8\xd8\x65\xa5\x43\x4e\xa0\x70\x32\xdc"
          "\xf9\xd5\x80\x70\xc3\xc8\xe3\x1f\x7e\x05\x56\x9e\x04\x11\x0c\x6a\x46\xb3\xbe\xb3\x33\x8a"
          "\x79\x24\x59\x72\x4d\x97\xab\x24\x57\x5a\xac\x6e\xf3\x72\x1b\x18\x59\x5f\x27\x9c\x30\xb9"
          "\xbd\x40\xb9\x0f\x64\xe9\x48\x3a\xde\xc6\xe4\xe7\xe1\xa4\xa7\x00\x47\xab\x21\x51\xf9\xcb"
          "\xcf\x29\xa9\x16\x6b\x82\x45\xba\x19\xd0\x2a\x9c\x17\x27\x42\x2e\x89\xee\x2f\x6b\xfc\x9a"
          "\x9b\x1c\xab\xa5\xef\xd8\x67\xf0\xe1\x5e\xbd\x3b\x08\x0d\xb9\x92\x05\xa4\xd0\xbf\x22\x10"
          "\xf1\x2d\x01\x59\x58\x85\xbf\x9c\xdb\x99",
          "\x4c\xff\x67\x9d\xc9\x22\x90\x97\x59\x82\xc8\xe7\x3e\xfb\x3b\x7b\xe7\x54\x75\x76\xb9\x27"
          "\xa3\x3a\xf4\xe5\x81\x6c\x9c\xae\x4f\x01\x33\xa3\xf9\x2f\x1a\x71\xf4\x37\xdb\x62\xf7\xd6"
          "\x84\x4a\x8f\x85\x39\xeb\x28\x39\xcc\xb8\x43\x7b\x51\x48\xfa\xe1\x47\x8e\xe7\xc6\xfc\xdc"
          "\x6b\xd1\xda\x05\x02\x9a\x2e\xb3\x87\x48\x6c\xa4\x22\xcf\x19\x55\x93\xe8\x68\x6f\x70\x8d"
          "\x47\x3f\xd9\xc1\x92\xdc\x38\x0e\x50\x9d\xad\x87\xc7\xce\x70\x57\x6d\xb2\x53\xc4\x15\x8e"
          "\xcb\x14\xca\x5b\x10\xd9\x04\x37\x51\xc9\x79\x91\x27\x92\x81\x22\x1d\xdb\x9e\x05\x1e\x56"
          "\x69\x57\x44\x93\x70\x9e\x28\x1a\x1a\x16\x4e\xf0\xa2\xbb\xc1\x67\x24\x6b\x1f\x95\x8a\x90"
          "\x03\x0d\xd5\x26\x8c\xb0\x00\x5e\x26\xed\x35\xb9\x4a\xcd\x4a\xae\x0a\x90\x68\x98\xb3\x4f"
          "\xc3\x5f\x1a\x82\x04\x77\x59\xc4\x0c\xfc\x20\xf1\xb4\x88\x98\x67\x37\x23\xdf\xe6\x29\x73"
          "\x89\x4a\x3c\x7c\xd9\x76\x67\x34\x7b\xb0",
          1, 1664 },
        { 128, 128, 14, "\x78\x0a\x7e\x16\xea\xf4\x06\x3d\x66\x8a\x17\x9d\xa2\xc4\xd4\x88",
          "\x88\xd7\x08\x7e\x84\xbd\x37\x8d\x5c\x6f\xdb\xac\x8a\x12\x73\xe6",
          "\xc3\xa6\x23\xb9\x3a\x0c\xb8\x4b\xe4\xf3\x2c\x77\xaa\x95\xb2\x38\x36\x12\xc6\x7e\x0e\x8c"
          "\x33\x4f\x5d\x51\x31\x0b\x60\x5a\xdf\xdd\xa9\x24\x97\x06\xbf\x50\x4c\xba\xe3\xe4\xf6\xb5"
          "\x89\xc6\xd1\xa2\xf0\xe2\xe9\xf1\xf2\xb9\xdc\x91\xe4\xdc\xcf\x72\x06\x61\xf1\x40\x71\x81"
          "\x29\x9e\x56\xf8\x0b\x36\x41\x88\xe8\xde\x1d\x1d\x51\x50\x64\xd2\x9d\xa6\x44\x75\x74\xa1"
          "\x12\x6f\x76\xc9\x0e\x64\xa7\x3d\xd3\x00\x5b\x7c\xec\xd9\x11\x1f\xa8\x50\x0c\xee\x45\xbd"
          "\xc7\x8f\xad\xac\x06\x7a\x44\xad\x50\x3e\x38\x74\xe5\x74\x2a\xac\xd8\x6e\x86\xa2\x24\xc7"
          "\x5e\xd0\xdf\x31\x50\xdb\xa0\xf2\xcf\x08\xac\xbb\x16\xda\x43\xbb\x39\x0b\xf6\x40\xb0\x34"
          "\x11\xcf\x18\x4d\xc2\x00\x23\x31\xd9\x04\x37\x19\x0f\xb5\x75\x69\x41\xc9\xc2\x54\x5c\x30"
          "\x47\x27\xb0\x66\x7c\xd8\x1e\x1d\xbd\xad\x26\x71\xed\x69\xfe\xf6\xf0\x15\x15\x7a\xc2\x4e"
          "\x09\xb3\x54\x0e\x2c\x1c\x21\x27\x57\x32\x5a\xb9\xcd\x77\xe5\xd7\x07\xae\x4d\xb8\x0c\xc7"
          "\xc7\xb6\xfc\x64",
          "\x5d\xe5\xb7\x6a\x43\xc6\xd2\xbd\x66\xcf\x28\x9d\xf6\x64\x71\x47\xa6\x16\xa5\x37\x31\xdc"
          "\xf9\x15\x78\xeb\x2c\xd9\x31\x0c\x4d\xe5\xf3\xa1\xa7\x26\xe5\x0c\x17\xfe\x7f\x8b\x22\x4c"
          "\xa6\xa1\xd3\xe9\xa6\x26\x18\x02\xa4\x7f\x82\x91\x30\x83\xcc\x59\x50\xa3\x1d\xa4\x28\x65"
          "\xc1\x5c\xfa\x52\xde\x8d\x69\xfd\xc2\x94\x97\x39\x6a\x82\x89\x01\x5c\x81\x67\xdb\x1c\x68"
          "\x7d\x6c\x95\x95\x9c\xb5\xc6\x08\x2d\x75\x32\x45\x24\xa3\x1b\xf2\x4c\x65\x8d\x34\x1a\x5d"
          "\x08\x82\x5b\x91\x5c\x3a\x77\xb8\x71\xad\x15\x99\x48\xaf\x64\x7d\x35\x46\x0c\x6e\xf2\xf0"
          "\xaa\x42\x48\x7b\x64\x53\xef\x84\xad\x22\xb9\x20\xbf\xa3\x29\xdf\x0e\x0c\xc4\x92\x9e\xb2"
          "\x25\x2a\x39\x6d\xf1\x5e\x52\xe8\x18\x0d\xe9\x9b\xb3\xb4\xc0\xc1\xdc\x46\xa9\x12\x4f\x59"
          "\x1a\x47\x74\x2c\x82\xab\x1b\x10\x3a\x27\x8c\x88\x1e\x2b\xc8\x2c\xc6\x89\x28\x1e\x64\x13"
          "\x92\x74\x45\xfe\x70\xce\x52\x7f\x0e\x31\x07\xb9\xbb\xf7\x48\xe7\x7e\x4b\xf2\x81\x37\x69"
          "\x0e\xc5\xe7\x5d",
          1, 1792 },
        { 128, 128, 15, "\xff\xff\x07\xba\x57\xcf\x76\x62\x52\x46\x8a\x4e\xb4\xf0\x6e\xb9",
          "\xa8\xe9\x1f\x10\x38\x39\x37\x67\x8e\x12\xc4\xca\xdc\xcb\xa4\x37",
          "\x47\x11\x8b\x2d\xf5\x9e\xd1\x4b\x1c\x66\x7e\x6e\xdb\xfd\x2e\xa0\x11\x82\x1f\xcc\x47\x20"
          "\x1c\xb3\x87\xc3\x51\xd1\x56\x58\xb5\x4f\x56\x94\x7d\xc6\x25\x97\x0b\x73\xb9\x2b\xf3\x24"
          "\xb1\xae\x69\xc1\x23\x50\x7b\xd1\x1e\xd6\x99\x1e\x38\x4d\xf7\x98\xe5\xea\x90\xa3\x53\x10"
          "\xb0\x93\x7a\x82\x99\x9c\xe4\xa8\x75\xb6\xbc\xb4\x80\x71\x17\xa1\x44\x28\xc0\xb3\x8f\xc2"
          "\x74\x6b\xf7\x43\xd6\x67\xc0\xec\x57\xdf\x32\x05\x90\x05\xae\xb6\x04\xd3\xe4\x2c\x66\x8a"
          "\x38\xc8\xb6\x62\xb8\xf9\x55\x04\x8a\xcb\x2e\xcd\x63\x9a\x69\x9f\x5a\x50\x5f\xe4\xb9\x64"
          "\xe8\x62\xce\x1c\x7a\xdf\xeb\x5a\x4e\x67\x1c\x30\x26\xf6\xb8\xa1\x84\x95\x18\x47\x11\xfd"
          "\x6c\xc2\x3a\x21\x19\xdd\x9c\x95\xdb\xbd\x57\x27\x09\x62\x45\x0f\xcc\xe8\xa5\x7e\x6b\xf0"
          "\x9b\xd8\x83\x6b\xc6\x64\x62\xe6\x6a\x18\x63\x9a\x11\xbf\xc6\xc5\xb7\xcd\x95\x8e\x99\xc7"
          "\xef\xf5\x23\xa9\xd6\x0a\xce\x04\x5c\xce\x1e\x15\x7b\x18\x8b\x18\xb2\xd5\x09\x7c\x16\x78"
          "\xac\x64\x82\x7a\x43\xf8\x01\x27\x26\xe4\x8e\xa9\x16\x39\x1e\x76\x58\x34\xeb\x91",
          "\xa4\x92\xee\x56\x20\x48\x30\x23\xef\x85\x16\x0d\x12\xb4\x0c\xf2\x34\x15\xb1\x20\xc3\xe2"
          "\x07\x0a\x85\x1b\x6d\xf1\x3d\x13\xbf\xf5\x0f\x76\x90\x3f\x86\x97\xe0\x95\x1f\x5d\xf4\x33"
          "\xb7\xc2\x0f\x3d\x8a\x5f\x04\xc7\xad\x53\x4c\x89\x3d\xb6\x95\x7b\x8f\xbb\x06\x96\x2e\xc1"
          "\xa7\x74\xab\x3a\x55\x72\x9b\x7f\xb1\xae\xc5\xea\xb6\x87\x88\x30\x15\xad\x2d\x0a\xe9\x6a"
          "\xb3\x2a\x3e\xcf\x56\x7f\x72\x41\x54\xbb\xbf\xb5\x53\xe3\xf2\x36\xfc\x41\x79\x54\xd6\x51"
          "\xcc\x33\xbf\x4d\xc0\xd0\x10\x23\x27\xd9\xb2\x83\xd8\x69\x2d\x57\xfb\xb6\x60\x50\xcf\x28"
          "\x87\x5d\x73\x69\x14\xdc\xf7\x31\xbb\x7c\xd8\x3c\xf3\x8f\x99\x43\x71\xb5\xcc\xe6\x14\xef"
          "\x8f\x34\xf4\xc8\xce\xa5\xa9\x76\x54\x40\x11\x61\x2d\x02\xa9\x69\x8c\xde\x00\x4b\x9f\xa2"
          "\x1c\x52\xf3\x94\x70\x6a\x62\x43\xc9\xab\x51\xd9\x7f\xc6\x2c\x64\x9f\x5a\x10\xf4\xfd\x19"
          "\x0c\xcf\x98\x76\x5d\x29\xff\xe0\x58\xaf\x2a\x2d\xb6\xd0\xe5\xf1\x58\x84\xac\x31\x49\x41"
          "\x6c\x12\xc4\x67\xfd\xbe\x24\x78\x31\xb8\x72\xc8\xb0\xd8\xba\x35\xcf\x56\x0e\xb2",
          1, 1920 },
        { 128, 128, 16, "\x31\x5a\x25\x06\x99\xa0\x4c\xaa\x90\x41\x6b\x75\xbf\x13\xd0\xab",
          "\xe9\x28\x10\x7a\xe8\x89\xbd\x8d\x80\x2d\x35\x08\x09\xc3\x5a\x2a",
          "\xf7\x98\x46\x35\xcb\x3f\x10\xac\xec\xc9\x4c\x3c\x81\xe3\xa9\xb9\x5e\xf6\xa3\x07\xb0\x79"
          "\x90\xc3\x8e\x42\x3a\xeb\x83\xe9\x20\x02\xaa\x0f\x70\x8b\xdb\xe6\xff\xd5\x98\x3d\x2b\xc9"
          "\x67\x06\x03\x1f\xf9\x16\xc4\x44\xfe\x28\x5f\x45\x7e\xb8\x4b\xe8\x4d\x62\x0f\x18\x38\xfc"
          "\x9a\x52\x38\xd6\x2a\x3d\x9f\xac\x3b\x23\x34\x67\x63\xb4\x31\xa6\x0e\x83\x2e\xf2\x0d\x9b"
          "\x83\x91\xd7\x53\xc5\xb3\x1e\xf9\x71\x65\xa1\x2b\x8d\x4e\x8b\xc3\xca\x56\x0f\xa8\xa7\xaf"
          "\xd3\x47\xc2\xed\x2d\x14\xfc\x7d\xe0\x3e\xb1\xb2\xc1\xb1\x28\xa3\x3a\x63\x86\xa4\xc7\x31"
          "\x7e\xb6\x93\x1a\xb0\x40\xd7\xe9\xec\xed\x67\x77\xd3\xc2\x37\x58\x18\x7c\x27\xb3\x4c\x3e"
          "\x0a\xb1\xb9\x09\x26\x53\x8b\xca\xa6\xfc\x60\x13\x30\x1c\x26\x82\x46\xa8\x17\x7d\x1a\xcc"
          "\xab\xd6\x5b\x60\x25\xe5\x08\x23\x8f\xd3\xcc\xf7\x94\x60\xb5\xc4\x90\x72\x88\xd0\x83\x1c"
          "\xae\xf0\x6d\x65\x8b\x7f\xfb\xac\x71\xf4\xc5\x29\xef\x1b\x82\x50\x36\x37\xda\x32\xb2\x8d"
          "\xf4\xe9\x35\xc3\x09\x2a\x63\xb9\x79\xe5\x93\x38\x70\x56\x8a\xef\xd2\x71\xb2\xbc\xb1\x41"
          "\x0b\xdb\x87\x16\x35\x75\x7c\x2c\x10\x6f\xaa\xbd\x48\xe4",
          "\x76\x0e\xc1\x26\xa6\x0a\xa5\x34\x4e\x40\xb1\xe9\x27\x13\x79\xd4\x80\x91\x87\xf5\x86\xb6"
          "\xf6\xc5\x3a\xf0\xe9\x6d\xeb\x70\x29\x17\x1c\x07\x2b\xbb\xa9\x2e\xce\x49\xe6\xe2\x20\x7c"
          "\x61\x33\x71\xac\x64\x91\x87\xbf\x6e\x67\xeb\xe3\x51\x20\x0b\xc7\xf4\x5a\x07\xce\xf4\xf2"
          "\x4b\x1b\x39\x67\x60\x58\xfd\x79\x12\x1f\x28\x01\x20\xbd\x24\x1e\x93\x25\x05\x5a\x58\x8d"
          "\x04\xbc\xd0\x76\x0b\x82\xbc\x63\xee\x47\xc1\x09\xe6\x12\x48\xe8\x92\x84\x07\x73\xd6\xde"
          "\xde\x03\x87\x01\x48\x3c\x38\x1d\xc2\x77\xc8\xa6\x6c\xc8\x4a\xec\x9d\x5a\x84\x86\xd6\x6b"
          "\x28\xd8\x14\x22\x53\xae\x80\x95\x71\x4d\xb9\x37\x86\xfa\x29\xf9\x8e\xfd\x78\x1a\x32\xb5"
          "\x1a\x5b\xd3\x06\x1b\xd1\x4e\x7e\x81\xc6\x05\xc1\xa5\xac\xfd\x61\x70\x3d\x42\x30\x86\x16"
          "\x46\xe3\x28\x1d\x76\x3b\xae\x9e\xe5\x07\x04\x9a\x3e\xc2\xf9\x66\x66\x08\x35\x28\x19\x07"
          "\x6c\x0e\x80\x5a\x4b\xaa\x57\x01\xfa\x81\x04\xba\xdb\xa8\x25\x2e\x5b\x35\x05\x54\x3b\xf2"
          "\x07\x6a\x8f\xad\x13\x67\x42\x6f\x48\x9a\xfd\x32\xaa\xc4\x56\x7f\x43\x29\xb8\x10\xa1\x01"
          "\xde\xf4\x19\x63\x8c\x31\x7f\xac\x50\xa3\x7f\x5e\x0a\x91",
          1, 2048 },
        { 128, 128, 17, "\x74\x26\xfb\xc5\xac\xf0\xc5\x52\xd0\xdb\x76\x89\x06\xcf\xfb\x69",
          "\xf3\xe3\x4a\x06\xcd\xdf\xa2\x62\x64\xef\x0b\xb8\x31\x33\xca\x86",
          "\xca\xc1\x74\x3b\x93\xb5\x5f\x15\x76\x37\xd7\x8c\xe2\x41\x98\xb0\x9c\x1e\xb7\x95\x8b\xb4"
          "\xe4\x3d\x30\x1d\x1a\x21\xda\x28\xda\xdd\x7f\x72\x88\xbc\x20\x36\x26\x4a\x56\x60\x3f\x67"
          "\x9e\x50\x58\x6d\xc4\xe2\x76\x04\x5d\xd1\xb0\x8d\xfa\x5c\xb4\xe5\x6c\x49\x1f\xdb\x52\x49"
          "\x1a\xd3\x96\xea\xb8\x74\xc0\x01\xfc\xe4\xa6\xaf\x4c\x6b\xd8\x53\xa3\x2e\xcf\x1e\xa2\x8b"
          "\x25\x6e\xf0\xbb\x88\xa0\x06\xca\x53\x74\xe2\xe0\xbf\x60\x36\x58\xcc\xc5\xcc\xd1\x72\xfc"
          "\x8f\x30\x3f\x5c\x10\x49\x55\xe1\xeb\xd7\xba\x97\xdc\x90\x26\xc8\xec\x0a\x53\xf2\xff\x96"
          "\x9d\xbf\xe3\x71\x2f\xa4\xe5\xfa\x0d\x4c\x6f\x71\x79\x23\xdb\xac\xbd\x4a\x03\x06\xa0\x3e"
          "\x52\xd9\xf6\xbf\x0b\xe6\x86\xa3\x51\x77\x07\xa6\x44\x6b\xb6\xb7\x8e\x60\x93\x34\xdd\x16"
          "\x87\x74\x14\x62\x55\x62\xad\x32\x69\x0c\x5e\xa4\x63\x9a\xc3\xd3\x5d\x17\xf5\xf3\xd3\x40"
          "\x4a\xe1\xb7\x45\x72\x92\x7c\xac\x50\x70\xa0\x00\x5e\x46\x7e\x0b\x8d\x80\xbd\x38\x7c\x0e"
          "\x03\x28\x11\x25\xae\x09\x68\xb1\x38\xe1\xbe\xb8\x56\x28\x08\xe8\x1c\x3a\xa5\x90\xe3\x3e"
          "\x09\xf5\x73\x6e\xf0\x0b\xb9\xfa\xa7\xbe\xc7\x53\xc1\x81\x67\xe5\x28\xb1\xec\x41\x23\xd9"
          "\x9b\x73\x5f\x98\xe5\xf7\x2d\x47",
          "\x4b\xf3\x37\x7a\x8c\xd3\xe6\x13\x22\xbb\x2d\x57\xff\x9b\xec\xe2\x57\xe0\xdb\xfd\x32\x56"
          "\xe1\x68\x9c\x96\x35\x02\x15\xa1\x16\x9a\x03\x21\x66\x46\x42\x1a\x1a\x23\x8c\xbe\xbf\xa5"
          "\x7e\x02\x67\xa8\x01\x28\xf5\x60\x53\x8d\xd0\xf1\x7a\x1b\xf4\xe4\x86\x36\x0f\xa4\xc7\xd2"
          "\xe1\xa9\xb5\x28\x43\x48\xc5\x7f\x0c\x2b\xe0\x6d\x16\x54\xc8\xae\xba\xa2\xe9\x61\x84\x8a"
          "\x00\xb6\xde\x4f\x58\xa6\xf3\x22\xe3\x44\xa2\xbc\x75\x0e\x4d\x9a\x3e\x26\x02\x79\x84\x62"
          "\xc2\x71\xa8\x46\x3d\xb9\xeb\xf9\x56\xf9\x55\xa6\x19\xe6\x22\x8c\x51\x99\x8d\x51\x4c\x40"
          "\xa3\xb7\xc3\xb4\x5f\x40\x12\x40\xfc\xe6\xbd\x44\xba\x23\x82\x92\x67\xf3\xdf\x66\x08\x51"
          "\xce\x19\xb1\x0b\x7d\x1f\xc9\x81\x1b\x3e\x2f\xb8\xd2\xaf\x19\x5e\x67\x0f\xcf\xa8\xb2\x29"
          "\x05\xdb\xae\x8a\x12\x66\x63\x55\x76\x83\xc0\x2d\x5d\x17\x95\x84\xb5\x8a\x71\xe5\xb8\x60"
          "\x2e\x9f\x17\xba\xbf\x9e\x31\x22\x3b\xf2\x26\x0a\x06\xf4\x44\x2d\x77\x49\x9b\xa8\x65\xed"
          "\x7a\x03\x93\x10\x97\xcd\x76\x54\xb7\xde\xf6\x2c\x87\x9b\x1c\x0a\x37\x1a\xdb\x94\x96\x19"
          "\x31\xb2\xef\xc8\x8b\xcc\x52\xe0\xa8\xca\xc8\xd0\x05\xd8\x73\xa4\xcc\x4e\x72\xf7\x92\x04"
          "\xa8\xcc\x24\xc8\x5a\xb9\x13\x85",
          1, 2176 },
        { 128, 128, 18, "\x4e\x6d\x7b\x91\xaf\x62\xf4\x85\x33\x9d\xb3\xe2\xde\x43\x0f\xf0",
          "\xae\xfc\x2a\xbc\xc3\xc6\xb8\xac\x4c\xac\x64\x93\xc7\x30\x48\x4c",
          "\x8d\xca\x93\xe8\x02\xaa\xfc\xac\x4d\xd6\xa5\xf3\xd1\x7d\x7e\x25\x2e\xc5\x92\x23\x9a\xce"
          "\xd8\x42\x0a\x3f\x13\x42\x82\xa2\xd2\x98\x69\x14\xdb\xb0\xa7\x9f\x6f\x46\xcf\x7b\x3c\xf2"
          "\x25\xaa\xb9\x49\xa3\x1a\x8f\x22\x37\x68\x4d\x14\x99\x0f\x33\x8c\xbb\xe7\x72\xdf\xf6\x5a"
          "\xce\x7b\x96\x1c\x96\x36\x1b\xce\xee\xad\xee\x36\xd0\x31\x72\x49\x49\x4f\x11\xd4\x46\x1e"
          "\x42\x0c\x54\x16\x54\xea\xf7\x19\xd5\x67\x2a\x19\xb1\x01\xcb\xeb\xd0\xb4\x84\x09\x60\x81"
          "\xd8\x4f\x2f\x57\x68\xd6\x30\xd8\x8e\x3e\x88\x06\xea\x42\x48\x42\xb4\x94\x4f\x85\x33\x5e"
          "\x96\xca\x90\xe1\x4d\xd4\xdb\x36\xc0\xff\xc6\x26\x60\x91\x39\x0f\x88\xdf\x3e\x77\xfe\x49"
          "\xd7\x76\xc2\x90\x66\xec\xcd\x12\xcb\xa2\xc6\x3d\xfe\x49\x0c\x1b\xa7\xa8\xb1\x0f\x4b\x47"
          "\x6c\x92\xab\x6d\xcf\x8e\x5d\x54\x02\x5b\x5b\x57\x09\x43\x5a\x07\xf0\xc0\xe3\x81\x67\xc6"
          "\x5a\xfe\x24\xf7\x67\xee\x4d\xe8\x42\xd6\xe7\xf6\xa1\xa0\x05\x8e\xb5\x46\xac\x88\x6b\x84"
          "\x7e\x8a\x5d\x06\xf0\x66\x8a\x76\x0c\x93\x60\x6c\xe3\x52\xa3\x94\xa8\xd5\x65\xce\x9c\x9f"
          "\xda\xb9\x4a\xdf\xab\x59\x8a\x08\x2f\x25\x0f\x88\xee\x0e\x95\xf8\x8a\xae\x19\xb1\x3e\xb3"
          "\xa9\x62\xe3\xbf\xd7\x54\x55\xc8\x4b\x66\xc6\xce\x22\xa1\x78\x5b\x52\xba\xfd\xca\x7a\x8c"
          "\x5d\x09",
          "\xdb\xf3\x20\x25\x06\xa5\x07\xf9\x64\xfb\x32\xca\x40\x84\x76\xff\x28\xf0\x86\x33\x01\x62"
          "\xfe\xe4\xfb\xc3\x77\x86\xc2\xcd\x8b\xf2\xcd\x80\xff\x6d\x76\x2a\xa3\xf6\x66\xef\x38\x2c"
          "\x49\x03\x56\x8c\x07\x34\x15\x17\xe0\x19\x33\x3c\x14\x3b\x14\x4e\x35\xa9\x0b\xb5\xde\x44"
          "\x72\xe5\x49\x5e\xde\x72\xc2\x22\xed\xa6\x4a\xb2\x0b\x38\x9d\xab\x50\xf1\x2e\x5a\xb9\x55"
          "\xab\x28\x8b\x73\x38\x6c\x4c\xc4\xc5\xbe\x90\xf0\x4b\x18\xcc\xbc\xb2\xbf\xe3\xab\xa8\xab"
          "\xfd\x8a\xe8\xc7\xfe\x04\x5b\x10\x17\x19\xa4\x19\xa7\x29\x24\x56\x25\xc5\x8f\x47\xeb\xff"
          "\xe3\xdc\xd0\xec\x79\x99\x26\x14\xb6\x52\x0f\x79\x1e\x8d\x96\x46\x95\x62\xa2\x45\xc3\xc7"
          "\xfe\xe8\x81\x6a\x4d\x3f\x9d\x72\x10\x30\x39\x5a\xb2\x47\xbd\x06\x5d\x14\x3f\x59\x17\x98"
          "\xc6\xaa\xc6\xa2\x92\x3d\x0c\xeb\xac\xd6\x4b\x63\x23\xf7\x98\x5c\x35\x53\xe0\x48\x81\x1b"
          "\xc7\x4d\x1d\x7f\x85\x75\x48\x61\x8f\x24\xe4\x59\x82\xe6\xa3\x93\xfe\x39\x15\xf2\x53\x6f"
          "\xd0\x33\x9f\xa9\xe5\xa9\x10\x44\x27\xbd\x93\x80\x8a\x82\x63\x5c\x98\xe5\xa2\x27\x37\x32"
          "\x52\xb1\x36\xdd\x9c\x98\x16\x43\x03\x94\xd0\xc1\xa5\x91\xce\x79\x4e\xaf\xc6\xf5\x5b\x2d"
          "\xd0\x9b\x0d\x4c\x6d\xd3\x1a\x90\x56\xbe\x3f\xd0\xa1\x1b\x6f\xba\x7b\xf3\xf8\xcd\x3d\x2d"
          "\x8c\xd3",
          1, 2304 },
        { 128, 128, 19, "\xb9\xfd\xa2\x14\xb2\x96\xe0\x88\xbe\xd2\xe5\x21\x33\xa9\x61\x6e",
          "\xb6\xfe\x22\x78\xa7\x3b\xb7\xbe\xed\x49\x06\xb1\xda\x62\xbb\x34",
          "\x5b\x10\x90\xc4\xf8\x23\xdf\x82\x67\x83\x1b\x2d\x4b\x7c\x2b\x12\x20\x0b\x2b\x23\xc9\x34"
          "\x2b\x4d\x77\x24\x2f\x09\x92\x6a\x82\x00\xaf\xbf\xaf\xb7\xf8\x99\x68\x66\xc4\xf1\xa2\xaa"
          "\xed\xf3\x6f\xf2\xe8\x81\x33\x2b\x97\x3b\x48\x52\xa0\x37\xea\x05\x57\x03\xc2\x71\x38\x0e"
          "\x84\x43\x43\xf6\x3a\x85\x78\x61\xd5\x39\x69\xd9\xec\xc6\x93\xaa\xf7\x37\x26\x18\x7b\x8c"
          "\x32\x17\xd2\x17\xa7\xf1\xdb\x08\xe1\x6b\x4d\x3c\xd3\x8e\x6c\x1e\xce\x47\x52\x47\x22\xc3"
          "\xc5\x80\x36\x8b\xe1\x48\x02\x60\x00\xdf\x52\x95\x90\xec\xd4\x12\x9a\x97\x93\x52\x28\x9b"
          "\x0b\x16\xc6\x25\x5f\x9d\xe4\xf8\x0d\x3e\x44\xcd\x3d\x6d\xf2\x6d\x01\x23\xe7\x8f\x2c\x63"
          "\x65\x1e\x9c\x8e\x76\x0b\x69\x1a\x2c\xa5\x30\x33\x58\xc7\x43\x38\xed\xdf\xa5\x46\x73\xc9"
          "\x4a\xef\x44\x84\xef\xd9\x60\x6d\x31\x0d\xf3\xb0\xa2\xaa\x69\x84\xc5\xc7\x13\xa8\xed\x1b"
          "\xe7\xc4\x84\x61\xb5\x44\x9f\x60\x74\xa1\xc4\x3d\x44\x9d\x78\xab\x1f\x93\xe7\xe2\x2a\x87"
          "\xf6\x00\x6f\x8a\x0d\x09\xbf\x94\x6b\x71\x8a\xb4\xc7\xc8\x17\xbc\xe7\x4d\x7e\x35\x7b\xcf"
          "\xe8\x2c\x47\x22\xda\x6a\x53\x1a\x38\xbd\x6a\x39\x7b\xb6\x74\x66\xb5\x49\x96\x8f\xb4\xe3"
          "\x76\x18\xcc\x29\x4d\x6b\x71\x42\x31\x39\x93\xc1\xf9\x4c\xd5\xf2\xac\x74\xdf\x25\xe4\xeb"
          "\x87\x2d\xbb\xd4\xcd\x33\xd1\xe1\xec\xc0\xb0\x2b\x6d\xad\x33\x4a\xec\xbb",
          "\xa6\x74\xb9\xcc\xa2\x1b\x41\xe9\x3a\x21\x4c\x93\x1b\x77\x91\x7d\x5f\x21\x25\x0d\xd2\xdd"
          "\xca\xdc\x50\x50\x33\x5b\x7a\xbc\x2a\x4f\xaf\x35\xc6\x83\x49\x30\xe1\xcf\x68\x66\x8b\x54"
          "\x56\x2d\xfe\x66\x0b\x64\xa8\x8e\xb6\x5a\x58\x5c\x5f\xa9\x96\x30\xd6\x22\x3b\xe2\x72\x2f"
          "\x1f\xf2\xdc\x37\x83\x11\x23\x8c\x82\xd9\x05\x2f\x57\xe0\xc3\x23\x32\x0d\x3a\xcb\x96\x03"
          "\x2a\x41\xf2\xc8\x91\xba\x08\x6e\x67\x73\x99\x10\xd0\xce\xbc\x46\x8e\x6d\xd1\x59\xaa\xc0"
          "\x82\xde\xf2\xb2\x02\xa1\x75\x54\xa0\x1a\xec\xe3\x89\xfc\x5c\x2a\x84\x18\xae\xcb\x9f\x1e"
          "\x04\xe4\xee\x6a\x0b\xc5\x2e\x62\x66\xed\x35\x9b\xa3\x71\xfd\xe0\x86\xf2\x38\x0d\x49\xb9"
          "\x03\x35\x54\x43\x1e\xbe\x67\x66\xe1\x03\x32\x77\xf4\x72\xae\x5f\xff\x8e\xe9\x04\x6c\x8f"
          "\xfd\x24\xf5\x39\x71\x3b\x45\x85\xfc\xcc\x9d\x45\x49\x87\x2d\xe5\xd5\x73\x92\x30\x0b\x4a"
          "\x37\x33\xad\x84\x34\xf3\x4e\xac\x43\xbb\x00\x51\xea\xab\x41\x67\x73\x6c\xd1\x93\xc8\x63"
          "\x1b\x96\xed\x10\x9c\xd7\x20\x38\x48\xe9\x5c\x3a\xf3\x9a\x1b\xae\x52\x73\x5c\xa3\xf5\x08"
          "\x58\xfa\x69\x23\x98\x8d\x83\x70\x39\x6d\xbd\x21\xe9\xe8\x62\x7f\x7a\x17\xfe\xef\x8a\x18"
          "\x90\x3d\xae\xa1\x95\x92\xc2\x55\x9f\x87\xae\x32\xea\x42\xbf\x62\x8e\x28\x6e\xc9\xd6\xaf"
          "\x56\x7a\xd4\x03\x18\x8f\x05\x12\xad\xec\xf0\x43\xf8\x73\xd5\x78\x55\x02",
          1, 2432 },
        { 128, 128, 20, "\x08\x47\xa3\xc2\x06\xdc\x6e\x25\x0e\x25\xcf\x21\xcd\xc2\xd3\xa5",
          "\x00\x0e\x4b\xf0\x88\x88\x40\xea\xd3\x6f\xbb\xfa\xe8\x79\xaa\x00",
          "\x9c\x96\x76\x9b\x1e\xd7\xc6\x2c\xc3\xbc\x48\xcd\xb4\x21\x45\xd9\x51\xf5\xa5\xed\x3d\x65"
          "\xfb\x74\xa9\xec\x7a\x0e\x4d\x7c\x35\x62\x7d\x36\x69\xac\x36\xc8\xe9\x73\xc2\xe3\x4c\xca"
          "\x85\xdb\x3e\x65\x78\x37\x8a\x02\x37\x4d\x22\x2a\x0f\xbc\x7b\xa1\x9a\x1d\xc6\xe1\x5e\x97"
          "\x29\xbd\x19\x47\x0d\x6b\x43\x62\xde\x77\x73\x52\x8c\x40\x82\x1a\xfc\xa0\xb2\x73\x88\x23"
          "\x43\x17\x3c\xb8\x7d\xe9\x90\x50\x81\x91\xfa\xa1\x85\x49\x22\x44\xdc\xaa\xb4\x05\x04\x2a"
          "\xc6\x23\xc5\x22\x2e\x03\x9a\x8f\x33\x33\x9e\x1d\x19\x27\x06\x91\xad\x47\x72\x9e\xcf\x5c"
          "\xc5\xad\x48\x6f\x51\x06\x8c\x05\x83\x71\x9b\x43\xa5\x0a\x73\x5a\xc8\x03\x58\xa3\x2c\x1f"
          "\xfd\xfa\x07\x97\xf1\x5e\xb7\xf6\x80\x86\x37\x66\xd7\xfd\xec\x73\x08\x84\x1f\xb5\x40\xca"
          "\x52\x02\x2c\x77\x6f\x23\xcc\xd9\xf9\x3a\x1e\x6f\x87\x84\xa5\x25\x18\xad\x24\x40\x14\x60"
          "\xb2\xa9\x11\x7d\x30\x94\x11\xd8\x0f\xfd\x40\xc6\x4b\xdd\xc1\x12\x4f\x75\x58\xed\x1b\xf5"
          "\xec\x95\xa6\x24\xc0\xf4\x54\xd9\x64\xd8\x9e\xee\x92\xf7\x32\x64\x45\x89\x1e\xbd\xa1\x59"
          "\x25\x23\xe8\xf7\xd7\xef\x6c\xb3\xcc\x99\x26\x9a\xc7\xcc\x21\x0c\x88\x06\x0e\xbc\x63\xae"
          "\x2f\x13\x08\x48\x83\xf7\x52\x1b\xb3\x5b\xb6\xcf\xc7\x7e\xe7\x30\x2a\x74\x57\x62\x86\x14"
          "\x2d\x1f\xb1\xb0\x9d\x92\x61\x92\xb3\xca\xa4\x6b\x66\xf8\x18\x5b\x21\x67\x17\x40\xce\xca"
          "\x8b\xc1\xb0\x00\xdd\x8c\x6a\x52\xdd\xe6\x4a\x5a",
          "\xb2\x68\xed\xbb\x58\xc0\x17\x2d\xd2\xf8\x71\xe7\x06\x39\xf8\x62\x88\x31\x58\x04\xb6\xed"
          "\x2e\x27\xbe\xef\x30\x6f\x1e\x00\x5f\xf1\x71\x98\xe5\xc1\x9a\x8d\xf9\xad\xff\x38\x35\x65"
          "\x8c\x84\xa5\xea\xf0\x7a\x03\x3b\xda\xaf\x52\xcd\x69\x34\x38\xb0\x99\xd8\xff\xa4\xaa\x5b"
          "\x01\x7e\x33\x7e\xc7\xcc\x6d\x2e\x1b\x19\x6b\x07\xde\x42\x08\xe4\x49\xe8\x66\x99\x06\xee"
          "\x27\x04\x2d\x2c\x5f\x17\xe2\x6b\x59\x8e\x68\x51\x74\xa7\x1e\xe1\x64\x7c\x64\x07\x22\x8a"
          "\xb3\xe7\x12\xbc\x05\x06\x8d\x71\x69\xc6\xc2\xe9\xea\x54\x37\x38\x60\x9b\xe8\xd3\xf9\x53"
          "\x29\x09\x74\x3b\x61\x68\xbc\x94\x04\xdb\xc5\xee\x94\xfc\x09\xf7\xd8\xda\xf6\x29\xb6\x8c"
          "\x34\xf6\xe3\x71\x61\xdc\x1c\xdc\x44\xb0\xf9\x69\x62\x44\xa4\x14\xf0\x1a\xae\x6b\x52\xbf"
          "\x33\x5a\xd4\x40\x5c\xf6\x66\x76\xa4\x9f\x1a\xdd\x61\x5d\xa7\xa6\xf4\x37\x01\x2b\xf8\xf1"
          "\x70\x22\x73\xda\xe3\x91\xac\xcf\x96\x0d\xbb\x27\x36\x6e\x85\x00\x2f\xa6\x62\x2b\x10\x77"
          "\x3b\xe4\x12\xff\x44\x8a\xde\x15\x30\xe3\x22\x9b\x06\x9c\x10\x82\xc6\x26\xc5\xbd\x34\x8b"
          "\xbd\xab\xb2\xa4\x73\xb7\x49\xd7\x4e\x93\xca\x30\x8e\xc7\x6e\x92\x5c\x23\xb1\xee\xeb\xc4"
          "\x8b\xcf\xc0\x59\xaa\x7c\x3d\x1f\xff\xec\x42\x24\xb6\xab\x95\x68\xab\xd6\xcd\x24\xf2\x1d"
          "\xd3\xe2\x55\xa3\x2e\xb6\x49\x33\xb4\x72\x32\x34\x80\x19\xbb\x5b\x9f\xdc\xa3\xe1\x60\xa2"
          "\x2a\x98\x1e\xe2\x21\xbc\x6c\x28\xa7\x2a\xeb\xd7",
          1, 2560 },
        { 128, 128, 21, "\x8f\xac\xab\x40\x3d\x1a\x0e\x36\x80\x71\xc8\x6d\x34\x21\xa5\x7c",
          "\xe4\x58\x9b\xf3\x3f\x4a\x93\x09\x14\xca\xa0\x9d\xf8\xfa\x7a\xd8",
          "\x43\x53\x58\x6c\xac\x1e\x25\xb4\x48\xd2\xfc\x0a\x14\x3f\x31\xa5\x68\xcf\xd7\x56\x1e\x1e"
          "\xe2\x07\xde\xcc\x60\x02\x61\x4e\x5a\x5a\xa3\xe4\x2c\xaf\x48\xdd\xd7\xa9\x5b\x11\x34\x5b"
          "\xe7\x1a\x7d\xf7\x6e\x45\xdc\xbc\x28\xb2\x85\x78\xf8\x2c\x66\x7c\x96\x69\xe9\xcf\x79\xf6"
          "\xc7\xe3\x14\x8f\xa7\x67\x87\x12\x8f\xb0\x82\x1a\xe8\x90\xfc\xad\x26\x49\xd7\xa8\x2e\xb6"
          "\x58\xd9\x15\xbe\x30\x3a\xd3\x3d\x04\x89\x5a\xca\xf7\x91\x1f\x6d\x43\x3d\xc2\x09\xbd\x85"
          "\xdc\x89\xb4\xf1\x53\x7f\x3c\xbf\x73\x09\x00\xbd\x27\x32\x2b\xae\xfc\x6e\x16\x1d\xc2\xc2"
          "\x80\x7b\xd4\x72\xec\xbf\x9a\x9d\x9b\x66\xa4\x15\xe2\x4a\xe9\x90\x50\x2a\x93\x64\x78\x9b"
          "\x76\xbd\x92\xdf\x1e\x5c\xa8\x0f\x11\x5a\x1e\xe7\xb7\xf4\xbf\xb2\xbf\xdd\x85\x9b\x05\x59"
          "\x8b\x38\xae\x17\xf2\x67\x36\x14\x15\x28\x6c\x68\xbd\xe2\xee\xab\xa5\x35\xd5\xaf\xf6\x1a"
          "\x52\x40\x74\xed\xbc\x28\x86\xdd\x8c\xd1\x70\x54\x27\x8c\x8f\x4e\xd9\xed\x46\xb6\x0b\xc9"
          "\xe8\x7c\x6c\xcb\x2c\x50\x37\xb7\xd9\x44\x97\x9a\x7a\x11\xf2\x82\xea\xc1\xa4\x60\xb4\xc1"
          "\x14\xad\x0c\xfa\xf6\x11\x95\x9a\xb2\xa2\xaa\xf7\x7c\x77\xb2\x2f\x16\xf9\xac\x01\xd0\x64"
          "\x5f\x0a\x29\xde\xe3\x2c\x0e\x46\xac\xeb\xfa\x3c\xe1\x29\xcc\x35\x4a\x42\x9b\x60\x06\x98"
          "\x16\x38\x3f\x30\xad\xfc\xef\xec\x0a\xe2\x7f\xed\xf9\xef\x20\x1e\x78\x1a\x51\xb5\x9a\x42"
          "\xfa\xad\x4a\xa9\xc0\x6d\x0f\xff\x92\xec\x33\xa6\xcd\xee\x68\x22\x56\xcd\xe2\x02\x68\x73"
          "\x33\x6d\xf3\xf8\xaa\xa6",
          "\x87\x24\x4b\x50\x28\x3d\x83\xb4\xac\x5c\x4d\x3c\x63\x0f\x23\x00\x88\x10\x9c\x5e\x32\xfd"
          "\x22\xf2\xe2\xef\x4e\xe3\x50\xe0\x7e\x19\xf7\x01\x0f\x76\x80\x30\x4b\x54\xb1\x98\x00\x9b"
          "\x52\x78\x94\xb3\x32\xe7\xa0\xcd\x97\x63\x9f\x9f\x73\x2c\xd0\x83\xb0\x15\x80\xb7\x02\x22"
          "\xa3\xc4\x3d\xf7\xa8\x8a\xf7\x1d\x51\xb6\xa1\xfb\x19\xcd\xd6\x8a\xf7\x68\x79\x61\x7e\xdc"
          "\x4b\x24\x9f\xbb\x4e\x56\x5d\xe6\xfe\x3f\x96\x35\xae\xef\x85\x12\x0f\xa3\x6a\x61\xcd\x7c"
          "\x9c\x8c\x6a\x82\xbb\x1d\x4d\xdf\xbb\xd2\x0f\xc4\xf3\xdd\x1e\xc5\x80\x23\x0e\xc2\x05\xf2"
          "\x03\xa5\x93\x4b\xf3\x99\xe3\xea\xc1\x85\xbf\x27\x0e\x99\x56\xc7\x01\x74\xff\x9c\xc9\x13"
          "\x36\x2e\x2a\xda\x75\xfc\xc4\xa0\x3c\x25\xc1\xbd\x07\xfd\x33\xb4\xa3\xdb\x1d\x7b\x11\x8c"
          "\x39\x03\x63\x97\xb6\xa3\x95\x0f\xd4\xbb\x9f\x4e\xf0\x8f\xa7\x17\x56\xe0\x85\x14\x89\x54"
          "\xd3\x74\xea\xc7\xbe\x3a\xd7\x92\xc0\x18\x9b\x6c\x92\x50\xf6\x7e\x63\xb1\x8b\x53\xa9\x3d"
          "\xab\x77\x4b\x3f\xd0\xec\x0e\xcb\xcc\xd0\xc1\xeb\x62\xa1\xb7\x8c\xa8\xc3\xf1\x90\xf9\x78"
          "\x72\x8b\x9f\x64\xe0\x5b\x41\x07\xc8\x1f\x37\x45\x1e\xb6\x65\x05\xb1\x5b\x9b\xb5\x70\x93"
          "\x94\x25\x05\x19\x15\x06\xa1\xfd\xd2\x72\x9d\xe9\xc3\x84\x97\x8a\x0a\x6f\xd4\x6a\x46\xc3"
          "\x6d\xb1\xff\xfa\xc2\xbc\x2e\x96\xb3\xd1\x3e\xe7\xc2\x7c\x58\xb2\x63\x14\x2e\x22\x88\xd1"
          "\x15\x92\x66\x8f\xfe\x96\xe8\xb1\x9b\x21\x8d\xc0\xfa\xe9\xe1\xeb\x62\x5b\xd2\xc3\xd2\x7e"
          "\x64\xb4\x83\x02\xdf\x4e",
          1, 2688 },
        { 128, 128, 22, "\x5a\xe4\xf5\xb4\x41\xf7\x18\x6b\xc8\x1c\xf6\xef\xd9\x7e\xb6\x5d",
          "\x14\x14\xe1\xd3\xd5\x1f\xd4\x4c\x18\x75\x50\x5c\x71\xf5\xcd\x24",
          "\xc3\x0e\x0f\xec\xe2\xb7\x5d\x11\xeb\xf9\xf1\xa2\x7b\xb2\x94\x6a\x10\x2f\x68\x8f\xd1\x4e"
          "\xd6\xe8\x2f\xc5\x8f\x3c\x02\xf8\x53\xc3\x3f\x5d\x76\xcd\x02\xdb\xe0\x1a\x59\x17\xf5\x8b"
          "\xe4\xf1\xa1\x30\x23\x50\x1f\xc3\xb4\x80\x42\xfb\x03\xe5\x2f\x43\x46\x3b\xcb\x30\x7e\xd4"
          "\xc4\xd3\xf8\x56\x34\xb6\x1d\xb7\x39\x35\xc5\x10\x04\x4e\xdb\x56\xc0\x32\x95\x16\xa1\xd5"
          "\x32\x3e\x33\x9c\xdf\x91\x11\xad\x27\x87\xdc\x45\x4e\x22\xe3\x61\x65\x05\x0f\xd8\xd3\xfb"
          "\xdc\xe9\xba\x2e\x2c\x5c\xd3\xcb\x9b\xe1\x46\xa9\x2c\x4c\x5f\xe6\x60\xd9\x62\xc7\x93\x3e"
          "\xfd\xef\xd3\x2d\xd2\x1b\x21\x05\xad\xc2\x9e\xf7\xa6\x89\x12\x94\x64\x87\xcb\x46\x60\x21"
          "\x7e\xc7\xa0\x79\xd3\xc0\x6c\x84\x80\x6e\x85\x1f\x01\xe7\x61\x5d\x3b\x59\x55\x88\x5e\xa7"
          "\x91\xca\x51\xbe\x00\x83\x63\xa6\x6a\x30\xde\x37\xcd\x95\xb3\x92\xa1\x95\x89\x8d\xaa\x3a"
          "\x9e\xb8\x29\xf2\x11\xfb\xcb\x48\x61\x41\xac\x28\x49\x45\x14\xbe\x40\xc7\xd3\x2b\xf2\x14"
          "\x83\x58\x6a\xf6\x1e\x49\xda\x5a\x6e\x18\xc5\x00\x68\x70\x24\x41\x11\xad\xb8\x00\xfa\xb2"
          "\x6c\x1b\x56\x49\x6e\x51\xfe\xf7\x42\xa2\x61\xb8\x02\xdb\x0f\x4c\xac\x40\xaa\x19\x0e\xf8"
          "\x3d\x8d\x40\x19\xd0\x95\x14\x66\x22\x6b\xcd\xd6\xdb\x46\xe7\x4a\x5d\xf0\x4c\xbe\xd8\x77"
          "\x86\xee\x6e\xbb\x2f\x93\xa1\x6c\x10\x90\xfc\xc9\x0f\x7f\x27\x85\xc2\xbe\x9d\xd2\xd5\x56"
          "\xeb\xd1\x4f\x09\x4d\x54\x7b\x47\xd7\x9a\xa4\xeb\xd3\xaf\x10\xae\x4a\x0f\xf7\xb3\x14\xbb"
          "\x95\x5e\x5e\x45\x9d\xc1\x62\x6b\x8c\x65\x40\xb8\x81\xfd\x76\x2e\x71\xe1\x06\x02\xfd"
          "\x5b",
          "\x4d\xb6\x10\x3d\xc7\xd8\x58\x8e\x1d\x59\xbf\xc9\x2f\xbd\x1b\x4c\x07\x1a\xf3\x50\xf3\x2b"
          "\x32\x66\x86\x33\x2e\x9b\x3d\xf9\xa2\x10\xc9\x74\xc2\x76\x16\x55\xb1\xcd\xf3\xfb\x41\x10"
          "\xe5\x0f\x2c\x80\xed\xdd\x03\xd9\x77\xb6\x5f\xc4\x1b\x7a\xd1\x51\xdc\x97\x2e\xfd\xf5\x34"
          "\x07\xbf\x13\xf9\x0d\xb8\x0e\x68\x06\x2b\xef\xeb\x9c\xa0\x8e\x24\x65\xeb\x3c\xcb\x8c\x94"
          "\xd4\x4f\x31\xe3\x5f\x26\xce\xbd\x6c\xf2\x24\xd9\xca\xa4\x3f\x8f\xb1\xa1\x9e\xad\x87\x25"
          "\xd1\xa7\x25\xc6\x43\xcf\xd2\xd6\x5a\xc3\xbb\x62\x39\x5b\xee\x6c\xda\xfd\xc1\x8b\x0d\x86"
          "\x68\x43\x65\x35\x4b\x48\xfd\x4a\x54\xdb\x3e\xe0\x72\x88\x4a\xb3\xf2\x3a\xcc\xce\x8a\x69"
          "\xec\x54\x10\x2d\x61\xe5\x8f\x3d\x77\x80\x77\x21\x48\x4b\xef\x8e\x28\x78\x98\x06\xd6\x7e"
          "\x82\x3f\xcf\x83\xed\x0d\xba\x58\x52\x88\x10\x1d\xad\x74\x24\x78\x50\x0b\xfa\x7c\xb2\xee"
          "\xb5\xbd\x3a\x10\xe8\x41\xcb\x73\xf7\x9f\x9b\x07\x9d\xfc\x3a\xf5\x86\xc7\xd6\xd9\x34\x9b"
          "\x4f\x3d\x51\x5e\x5a\x6e\xd2\x17\xbc\x98\x6e\x27\x59\xef\x6c\xcb\x2e\x74\x64\x98\x50\x6a"
          "\x91\xc7\x1f\xa0\x33\xaa\x02\x70\x2a\x3f\x18\x13\x15\x84\x33\x11\x1d\x99\xf7\x9a\x80\xa9"
          "\x77\xba\x05\x24\xa6\x0b\xfd\x12\x0f\x7e\x6c\x3e\x88\x19\x94\x02\xc4\x37\x33\x76\x31\xbe"
          "\xf9\x62\x93\x7f\x27\x6d\x48\xb1\x36\x77\x77\x30\x70\xce\xef\x8e\x50\xdf\xc3\xbf\x48\x61"
          "\xe1\x84\xb7\x81\x0f\x60\x65\x63\x4c\x2a\x72\xc9\x1e\x04\x6c\x5d\xa4\x59\x09\x77\xa1\xed"
          "\xcb\xea\x43\x0f\x85\x29\xcd\x6b\x83\x1f\x2d\xf7\xe4\x7f\xec\xe0\xfb\x0a\xee\xab\xd7"
          "\xfd",
          1, 2816 },
        { 128, 128, 23, "\x10\xfe\x63\x77\x55\x56\x1d\xcb\x62\x84\xaf\xa9\x83\xd5\xa2\xdc",
          "\x1f\x50\x5e\x90\x22\xac\xef\x23\x6d\x49\x45\x63\xe2\x97\xc5\x2d",
          "\xe1\x66\x72\xa0\xac\x1f\x94\x0f\x4e\x33\xca\x76\x9e\xda\x71\x67\x31\x12\xb6\x67\x44\x6b"
          "\x9d\x58\x28\x4f\xac\xda\xdb\x9e\x65\xdf\xeb\xe4\x1e\x32\xea\x40\x72\xbf\xe0\x9b\x4f\x26"
          "\xa9\x56\x84\x00\x04\x1b\x9b\x2f\xb3\x8c\x4c\x86\xb3\xcf\x0c\xad\xfe\xb5\xe0\x94\x9a\x03"
          "\xe0\x90\x2f\xe1\x75\x23\xc6\xb4\xfb\x6a\x94\xc6\x22\xb5\x1e\x89\x7e\x92\xf6\x41\xc1\x1e"
          "\xad\xcd\x83\xd4\x02\x67\xec\x1a\xc1\x62\x1b\x20\xdb\x99\x88\x40\x0c\x4f\x3c\x0a\x10\x27"
          "\xc9\xb3\x91\xac\x05\x9d\xfe\x98\x6f\xef\xa8\xf5\xa6\xc4\xc2\x7a\xc6\x05\xf3\x6d\xca\x59"
          "\x5a\xbc\xba\x13\xa8\x11\x94\x25\x46\x46\x9d\x40\x60\x5b\x10\x9b\xfe\x2a\x46\x4f\x33\x00"
          "\xf9\xdb\x5e\xde\xdc\x4f\xc1\xb5\x5a\x9d\x4d\x0d\x03\x5c\x2c\x1d\x50\xc5\x66\xa1\xeb\x66"
          "\xac\x8f\x19\x71\xa8\x07\x7f\x46\x01\x72\xa2\x86\x93\x53\xac\x39\xe6\xbe\xb6\x8e\x6f\x87"
          "\x2c\x81\x6c\x9a\x8f\x3e\x1a\x84\x58\x2d\x76\x7f\x95\x9e\x4b\x59\x5f\x69\xe6\x28\xa8\x53"
          "\x7b\xe5\x1a\x23\xd5\xf0\xf1\xce\x59\xe4\xb0\xf6\x78\xd2\x95\x52\x7c\xdd\xf1\xb8\xd3\x16"
          "\x7c\xd2\x89\x6d\x0b\xce\xf6\x13\xdc\xdc\xa3\x58\x0a\x5b\xa0\xff\xf5\x25\x54\xe0\xa4\xd5"
          "\x64\x86\x47\x53\x7f\x87\xdb\xa6\xc5\x42\x7b\xcb\x05\x4c\x13\x64\x3d\x06\x91\xfd\x8d\x8a"
          "\xcf\x40\xd1\x6c\xba\x2d\x81\x3f\xb8\xb1\x26\x43\xa2\xe2\x53\x4d\x0e\xe3\x18\xbd\x79\x55"
          "\x61\x3e\x7e\x95\xd7\xe6\x79\x56\x66\x1e\x6b\x2d\xe5\x21\xa9\x70\x93\x70\x4a\x58\xae\x9f"
          "\x81\x86\x35\x6c\x22\x68\xba\x03\x76\x4d\xd8\xfe\xe9\x53\x11\xcb\xa1\x13\xdc\xae\xa0\x21"
          "\x48\xb4\x52\xfe\x09\x31\xf2\x7e\xb8\x5d\x26\x55\x4d\x57\x4e\x30",
          "\x82\x0d\xaa\x75\x0b\x9a\xfb\x54\x69\x22\x7a\x63\xb5\x79\xac\x6a\xf0\xb9\xfb\x4f\xda\x57"
          "\x90\xd7\xa9\x91\x21\x26\xf4\xa2\x5e\xb4\xa4\x84\x45\xbc\x69\x96\x9b\x8b\x61\xda\x00\xbb"
          "\xba\xaa\x88\x9d\xe7\x73\x7d\x99\x86\x74\xf6\x63\xfd\x5d\xd5\xe4\x1b\xa3\x43\xa6\x0e\xd9"
          "\x4a\xa3\xdf\xa5\x9b\x74\xe5\xbd\x96\x4b\x88\xc3\x7d\x8f\xbc\xa9\xd9\x8e\x6e\xbd\x33\xd4"
          "\x81\xca\x9a\x9d\x31\xba\xb3\x0e\xbe\xcb\xf2\x1f\xc0\xf7\xcc\x08\xff\x8b\xba\x35\xad\x34"
          "\x07\x76\x0f\xf4\x2d\xf6\xd2\xda\xd8\x24\x96\x14\x6a\xc4\x81\x29\x27\x3c\xb6\xcf\xd6\xf6"
          "\x16\x06\x21\x74\xc5\x88\xfe\x47\x5e\xd8\xae\x0b\x3e\x0b\x7f\xca\xd8\xea\x67\x9a\xca\x46"
          "\x83\x90\xc9\xd1\x18\xf2\xf1\x43\x0a\xbf\xa7\x0e\xee\x40\xdf\xd8\x53\xc8\xec\xb1\xd9\xaf"
          "\x81\xbc\x09\xb3\xa1\xed\xe5\x48\xfa\x0c\x64\xe0\xdb\x7d\x09\x64\x9b\xdb\x69\xce\x28\xd2"
          "\xf5\xb5\x05\x56\x0c\xe1\x04\x52\xbf\x00\x62\xf6\x1a\x8c\x3d\x21\x06\xa0\x19\x99\xc3\x1a"
          "\x40\x77\x9a\xd9\x95\x50\x76\x15\x72\xe9\xa0\x0e\x44\x5d\xde\xf4\x16\x3c\x6e\xb0\x84\xa2"
          "\xe0\x5a\x02\x3c\xeb\x02\x40\x24\xbb\xd6\x1e\xef\x9a\x5c\x97\x05\x4c\xea\x80\xe7\x8b\xc2"
          "\xbb\xa0\x8d\xa1\x77\xab\x89\xb3\x5f\xb5\xca\x72\xa9\xc4\x47\xfa\xa0\x6e\x2d\x2f\x3d\x54"
          "\xb3\xf7\x98\x88\xa9\x9a\xad\xd7\x1b\xe0\x44\x38\xe9\x6d\x00\xc9\x42\x97\xc2\xc5\x7b\xb1"
          "\x34\x3b\x77\xb8\x76\xb9\x1c\x99\x3c\x3b\x7e\x41\xb2\x64\x69\x8c\xe5\x77\xe8\x6d\xcc\x05"
          "\x24\x29\xb3\x1d\x2f\x2a\xec\xa6\x25\x04\x55\x44\x4c\xef\x99\x28\x8c\x7a\xdd\x8c\x9e\x6c"
          "\x56\x85\x24\x23\x27\xf8\x61\x44\xb4\x7c\x81\xef\xa2\xa1\xbd\x05",
          1, 2944 },
        { 128, 128, 24, "\x84\x6b\xc9\x0b\x33\x94\x98\xf5\x66\xcf\x7c\x87\x7c\x3d\x3d\xbc",
          "\xd7\xee\xae\x93\x6e\x07\x6c\xc0\x8f\xb7\x8f\x55\x35\x0d\xef\x81",
          "\x32\x85\xd1\xd5\x86\x0f\x6f\x68\x76\x09\x9d\x55\x2b\xf5\x86\x3e\x34\x3c\xea\xee\xaf\x5b"
          "\xdf\xa0\xf5\xe3\xce\x8d\x29\xc3\x0a\xa5\x3e\x41\x6d\xfe\x06\x91\xc5\xe0\x2e\xcb\x43\x5d"
          "\xf4\x62\xd0\x60\xce\x7b\x1a\x05\x8c\x9d\x9e\xee\x71\xdd\x63\xda\x69\x29\x20\x4d\x4b\xbf"
          "\xef\x9d\x68\x89\x16\x42\xd5\x1c\x7b\x50\xa0\x52\x72\xcc\xbb\xb6\x79\x8c\x1f\x45\x04\xd1"
          "\xaa\x7f\x88\xe5\x05\x81\x00\x9b\xdc\x0a\xba\xac\x86\xd1\x39\xdc\x1a\x73\x30\x8b\x72\xb5"
          "\x85\xb9\x33\x3b\x1c\xb6\x91\xa6\x80\xdf\x80\x76\x43\x16\xfc\x74\xf1\x7c\xba\x4e\x07\x0f"
          "\x23\x32\x6e\xd3\x5f\x63\x93\xab\x8f\x30\x44\x28\x16\x36\xfe\x8b\x32\x1b\x3c\x18\xcb\x78"
          "\xa3\x33\xd1\xf4\x96\x10\x2f\xd0\x06\xe8\xae\x1e\xd7\x40\x25\x37\x34\x95\x23\x2f\x96\x08"
          "\xfc\x2a\xe0\xf1\x81\xf4\xb3\x6f\xdd\x5b\x5f\x44\x75\x07\x14\x3a\x7b\xd7\x73\x48\x28\xfd"
          "\x81\x04\x93\xcf\xea\xaf\xc4\xb0\x00\x72\x4f\xe5\xc6\x7a\xd2\xd1\xeb\xa3\x31\xf3\x9e\x0e"
          "\x04\xe0\x3a\xe3\x59\x6e\xb9\xc7\xff\x28\x55\x34\xc5\x25\xd7\x53\x06\x4b\x99\x09\x5b\x15"
          "\xe2\xb8\xa0\xc7\x11\x61\x58\x14\x10\xde\x99\xf4\xca\xb1\x14\x59\x04\xa9\xb3\x10\x0c\x77"
          "\x81\x11\xf8\x2a\x2d\x3d\x95\x53\x38\x98\x4a\x1a\x52\x7d\x95\xa6\xe1\x2b\xff\x2b\x4b\x0e"
          "\xf0\x9a\xf3\x31\xc7\xd5\x01\x0a\x62\x59\x93\xfb\xe3\xcc\x6a\x56\x8d\x0b\x6e\xc2\x7e\x2d"
          "\x37\x18\xd8\xb3\x4c\x7e\x0e\xdf\x60\x05\xcc\xc8\xc8\x19\xd1\x89\xba\xbf\x7e\xe4\x5b\x7b"
          "\x44\x61\x52\xe9\xd7\x8c\x00\x16\x89\x5e\x51\x28\xce\x8a\x10\xb8\x17\x5e\x12\x06\xb1\x54"
          "\x48\xc9\x8d\xb3\xb8\xf3\x3b\xf3\x55\x8a\x3d\x31\xdc\xcb\xa6\x4e\x4a\x25\x62\x32\x11\x86"
          "\x5d\xab\xde\x1a\x29\x3b\xc1\x6d\x38\x68",
          "\x7b\xed\x1e\x2f\xe8\x41\x54\xf5\xc1\xc1\x95\x9f\x01\xf4\x49\x0f\xa9\xf4\x8d\x00\xed\xa4"
          "\x36\x7f\x46\x3c\xdb\x79\x41\x29\x27\xc0\x85\x94\x7d\x7a\x99\x95\xd6\x0b\x01\x15\x2a\x07"
          "\xa6\x67\x04\x5a\x33\x68\x93\xc8\x78\x04\x58\x49\x70\xe1\x6a\xcc\x15\xdd\x9e\x1d\x50\xb4"
          "\x1c\x4e\xdc\xc4\x96\x4c\x88\x3f\x35\xbf\xe2\x85\xa2\xb1\x56\x9c\xae\x05\x80\x9e\x63\x10"
          "\xdd\xb4\xb3\xc0\x09\x54\x58\xad\x32\x7e\x2c\xe6\xe9\xac\x54\xae\x4e\xfb\xfc\xdd\x1e\x9e"
          "\x1d\x00\x4c\x39\xc6\x91\xd5\x7e\x0d\x37\x4b\x0d\xe3\x58\xdc\x4b\x0e\x30\xb4\xa3\x74\xca"
          "\xa1\xec\xee\xaf\xcd\x82\xa1\x5b\x74\x12\x5a\xec\xfe\xc2\xfc\x80\x38\x4d\xcf\xe7\xb4\xa9"
          "\x9b\xba\x5f\x90\x50\xa1\x0a\x21\xca\xe3\x77\xf5\xcb\x54\x5d\x63\x95\x22\x75\x8d\xb8\x29"
          "\xa7\xd5\x6d\x81\x62\x22\xd3\x21\x35\x06\x52\x3a\x3c\x1e\x29\x5c\x05\x3c\xa2\x17\x70\x0b"
          "\x24\xe2\x54\x46\xfd\x1f\x38\x3e\x27\xc7\x27\x89\x7d\xe9\xf2\xbe\x4a\x3b\xdd\x55\x8f\x7f"
          "\x72\xe2\x68\x67\x5f\x86\x30\xe4\xd1\x1c\x72\x26\x29\xe4\x3e\x24\x45\xde\x51\x2b\x9d\x30"
          "\xc1\x63\xe4\xbf\xa8\x73\x46\x62\xde\x36\xf3\x07\x8c\x66\x87\x28\x57\x39\xcf\x27\x4c\xe2"
          "\xfc\xfa\x0a\x80\x29\xcd\x20\x61\xab\x61\x65\xed\x66\x59\x0b\x71\x59\xf6\x6b\x47\xf4\x84"
          "\x7b\x0d\x9a\x7b\x3c\xb7\xcc\xf9\xc6\xf2\x54\x24\xa5\x30\x92\xfb\xee\x6a\x85\x51\x3d\xf6"
          "\x23\x97\x14\x3c\x4a\xab\xb7\xc6\x39\x08\x34\x85\x4f\x1b\x49\x99\x00\x23\xd2\xdb\xa2\x1e"
          "\xcf\xc5\x2e\xbc\x2a\x18\x03\x01\x23\x20\xd8\x07\xd7\xf2\x4f\x30\x29\x57\x8c\x41\x0d\x96"
          "\x1b\x16\x53\xa5\x47\xf5\xe1\x83\x44\x78\x16\xe2\x45\xc6\x5a\xdd\x4d\xb9\x59\x75\x9b\xf7"
          "\x15\xdd\x7f\xc2\xd7\x60\x5d\x79\xfb\xf8",
          1, 3072 },
        { 128, 128, 25, "\x42\x0e\x78\x96\xeb\xf6\x42\x7a\xc7\x10\xde\x98\x5c\xf3\x7e\x64",
          "\x2f\x49\xf2\x72\x70\x63\xf6\x26\xb3\x21\x55\x04\x3f\x76\x5f\xf0",
          "\x65\x5d\x50\x66\xa8\xca\x5f\x39\xcb\xa1\xee\x10\x19\x5e\x7a\x13\x68\x19\x7d\x16\x38\xe4"
          "\x74\xb8\xe1\xa0\x7e\x43\xb3\x77\x9e\xb2\x7f\xf5\x2f\x7b\xa0\xd0\x85\x93\x5a\x0b\x41\x29"
          "\x4e\x00\x5a\xe9\xf4\xa3\x99\x85\x8b\x7c\x53\x4c\xcd\xdf\xad\xff\x4d\x77\x95\xc3\x66\xc6"
          "\xba\xd6\xc4\x88\xcc\xa0\xd5\x45\x55\x71\x20\x3d\xc2\x51\xaa\x1e\x8f\xd3\x31\x88\xef\x04"
          "\xe8\x25\x46\xb1\x39\x32\x2c\xb9\xd0\x19\x25\x8d\x10\x18\x55\x10\x4d\x56\x0e\x1b\xc7\x46"
          "\x40\xee\xec\xa1\x35\x7a\x44\x12\x63\x7e\x8a\xe0\xef\x5f\x19\x27\x85\x84\x82\xed\xc8\x13"
          "\x34\xfe\xd9\x50\x2f\x3b\x01\x3e\x4a\x0b\x25\xcf\x09\x91\x73\x6a\x1e\xd4\x8f\xd7\xcf\x30"
          "\x6b\x66\x9a\xcc\x5e\x79\x23\xe0\x44\x56\x75\xd6\xb9\x86\x59\x2f\x14\xe3\x08\x37\x0b\xfe"
          "\xb0\x67\x9e\x56\x7f\x7a\xe3\x4c\x4c\xe4\xf5\x0b\x43\xee\x4f\x61\x99\xf3\x80\xc1\x29\xce"
          "\xab\xa4\xb2\xd9\x37\x91\xc9\xb4\x16\xdc\x5c\x67\x6a\xe3\x8c\xe1\x14\xa3\xdc\xb5\x46\x22"
          "\x80\xb8\x67\x34\x96\x6f\xbc\xa1\x0c\xfb\xb0\xf2\x53\x48\x27\x3c\x75\x7d\x78\xbb\x75\xff"
          "\xa2\xd7\xc7\x36\xb1\x0c\x25\xe3\x7e\x45\x63\x80\x8f\x68\x3b\x36\xdb\xf4\x97\x02\x40\x07"
          "\x61\x7a\x63\x42\x26\x8f\xc2\x2d\xaf\xf8\x1c\x13\x86\x85\x53\x8b\x9a\x5c\xe0\x0e\xb5\xf0"
          "\xaf\x17\x3e\x3b\xc1\x55\x1c\x8d\x98\x50\xfe\xe9\x74\x9d\x1d\x2e\x5e\x1b\x5c\xe1\x46\xe3"
          "\x2e\x7f\x3e\x08\x24\xcc\x7c\x75\xc0\x9c\x32\x87\x9d\x4d\x84\x48\x25\x43\x77\xc2\xbc\x66"
          "\x09\x66\x1c\x0b\x42\x42\xf7\xa5\x62\xa7\x22\x89\x1a\x91\xfe\x5a\xc4\x0a\x7b\x49\xcd\xb5"
          "\x41\xea\xa1\xd8\x33\x6d\x25\xac\x5c\x1b\x63\xde\x0e\x8e\xa9\xf0\xa5\xee\x88\x84\x34\x3b"
          "\xc9\x39\x95\x74\x2a\x23\x25\x80\x17\x0e\x57\x00\xc1\x6e\xac\x26\x1f\x86\x63\xaa\x37\x76"
          "\x47\x68\x9d\xc9",
          "\xd6\x3c\xce\x37\x8e\xb0\x6c\x06\xb7\x7b\x7e\x9a\x07\xb3\xae\xc9\x9b\x4e\x53\x01\xc6\xf9"
          "\x47\x39\xd7\xc6\xbd\x86\xf1\x29\xab\x5e\x0f\xc0\xee\xd7\xba\x62\x78\x04\xd5\xc7\x12\x47"
          "\xb6\xa8\x77\x1f\x41\xe2\x06\x98\xce\xe3\xdc\x95\xc0\x4c\x14\x42\x67\x86\xd5\xc6\x3e\x39"
          "\x25\x0e\xbc\xf2\x03\xeb\x08\xc3\x55\xf3\x00\x4e\x98\xfe\x85\xb4\x0d\x1f\x93\x8a\x83\x4b"
          "\xad\xbb\x44\xd5\x6e\xdb\x7a\xb0\xe5\x15\xef\xa0\x6f\x6d\xbc\x1d\x45\x8b\xc5\xa2\xd7\x67"
          "\x3b\xe2\xaf\x2d\x04\xd5\xd1\x80\x36\x0d\xd0\xe5\xca\x1f\x22\xd3\x38\x25\x69\x64\x72\x75"
          "\x1c\x73\x01\x98\xa6\xe2\x55\xda\x3b\x43\x24\x1a\xfb\xb4\x31\xab\xa8\xbf\x59\xd5\xb3\x9d"
          "\x7f\xf2\x8d\xd0\x8c\x93\x67\x56\x9a\x9e\xa5\x9c\xf9\x78\x06\x0d\x7d\x28\xc7\x86\x37\x1d"
          "\xa6\x4d\x9a\x9b\xf0\x8a\x63\x87\xac\xc4\xd8\xa7\x49\x09\x57\x5f\xef\xe3\x00\x09\x4e\x75"
          "\xa7\x90\x5a\xfe\xf0\x5e\xf0\xc3\x1e\xc6\x76\x7f\xfc\x5b\x39\x9a\x81\x62\xcc\xa6\xe2\x6c"
          "\x6c\x63\xd6\x3c\x9a\x7a\x4f\x7b\x1e\x86\x98\x66\xa6\xa4\xd1\xf1\xae\x67\x53\x2b\x74\x2e"
          "\x6d\x97\x65\x42\x2d\x34\x03\xfa\xef\x59\x35\x79\x3b\xaf\xc6\xb1\x24\x84\x44\x97\x97\x11"
          "\x84\x67\xd4\xe8\x65\x71\x7d\x19\x49\x0d\xde\x79\x7f\x38\x7f\x76\x05\xf8\xb5\xe8\x1a\x8e"
          "\xfb\xc5\x61\x2c\x90\x82\x8b\x63\x30\x1e\x1c\x22\xbe\x4f\xce\x6b\xb1\x93\xfb\x42\xf1\xca"
          "\x6d\x12\x3a\x91\x62\xce\xf5\x18\x05\xb6\xd6\xa2\xb9\xb5\x0b\x02\x1c\x49\x52\xaa\x5d\x8f"
          "\x34\x82\x4e\xd3\xfd\x45\x6f\x32\xeb\x04\xc3\xa5\x1e\xfc\xd2\xb7\x40\xe5\x33\x93\x64\x5d"
          "\xd4\x7c\xb7\xae\xd9\x0d\x6e\xc2\x11\xed\x07\x22\x65\xb6\x58\xd6\xca\xca\xef\x9e\xba\x35"
          "\x92\xce\xb2\xa2\xbc\xaa\x4e\x18\x18\xe9\x22\x67\x96\x8b\xc0\xbc\xaf\xf7\x56\x2b\xc0\x83"
          "\x3b\x5a\xec\x09",
          1, 3200 },
        { 128, 128, 26, "\x53\x56\xa6\x48\x0b\x17\xc6\x14\x1c\xb8\x44\x31\x53\x4c\x45\x9f",
          "\xdb\x84\x61\x33\x37\x6b\x6c\x66\x94\x94\xb8\x98\xaf\xfa\xbe\x53",
          "\xe6\x6f\x07\x4e\x7e\x3c\x43\x6f\x7e\x11\x10\x7c\x82\xd1\x90\xb5\xec\x15\x3f\xce\xd2\x21"
          "\x53\x56\x75\xf8\x69\xaa\x02\xb7\x11\x97\x90\x15\x73\x48\xa7\xde\x66\x5f\xc2\xea\x36\x0c"
          "\xf5\x00\xd8\x29\x2a\xc4\xdf\x7c\xce\xfa\x4d\xb4\x17\x3b\x17\x8c\x5f\x4c\x48\xb7\xcc\xa3"
          "\xec\x4e\x90\x41\xd6\xdb\xc6\xb5\x12\x44\x0b\x47\x83\x96\xdc\x28\xb5\xe6\x26\xa0\x2c\xed"
          "\xf1\xf4\xb0\x00\x1c\xc1\xec\x50\x91\x8b\x72\x0c\xc4\xca\xe4\xeb\x36\x5e\x03\x50\xc9\xf9"
          "\x50\x33\x82\x27\xb3\xf0\x42\xac\x14\x99\xad\x1b\x7f\xca\x14\xfd\x69\x1e\xd7\xf8\x88\x89"
          "\x6f\xa9\xc2\x04\xd3\xb4\x92\xab\x2b\xa5\xda\x28\x43\x63\x28\x30\x0e\xbb\xa0\xe9\xdf\x57"
          "\x66\x16\xeb\x1a\x0d\x38\x1b\x81\x4a\x9e\x9c\x88\xcb\x20\x37\xfa\xd5\x1d\x2a\x5d\xe6\xe5"
          "\x10\xc8\x9b\xac\x3c\xbe\xd1\xde\x4d\xa1\xfb\x93\x0e\xbb\xdb\xb9\xa0\xd4\x14\x88\x8c\x4a"
          "\xa2\x3d\x43\x02\x2d\x1e\x15\xe9\x45\xfa\x77\x63\x2f\xbf\x3e\x35\x5f\xdb\x86\x0e\xdd\xda"
          "\x44\xb3\x22\x78\x09\xee\x6e\x44\xe1\xd5\x05\xcf\x30\xe9\x8b\x77\x6b\x5c\xb1\x86\x7d\x41"
          "\xa3\x81\x6d\x82\xaf\x6a\x5c\x6f\xaa\x75\x34\x63\xc0\x41\x35\xb7\x00\xcc\x5a\xe7\xcc\xad"
          "\xca\xfe\xa5\xdc\x4d\x33\x96\xa6\x92\xf0\x30\x3a\x1b\x56\x35\x6b\x57\xb4\xc6\xe9\xdd\xb0"
          "\xec\x9d\xd5\x30\x1b\x1a\xb7\x02\xe5\xf3\xb0\x5f\x33\x0a\x93\x8d\x16\x56\xa4\x1e\x3d\xf3"
          "\x69\xb6\xd0\x36\x3a\x66\x91\x55\xfe\xd0\xbc\xe2\x52\x9b\xec\xd5\x4e\xcb\xa0\xaa\x40\xfc"
          "\x9c\x39\x47\xbf\xc5\x95\x58\x2a\xf0\xbb\xd1\x56\x92\xc2\xf1\xd2\xde\x9e\x58\x3f\xa4\xf9"
          "\x20\x7d\x8b\xeb\x0f\x4a\xbe\xd3\x45\x96\x25\x23\xad\xe2\x94\x4d\x2f\x82\x51\xf0\x3c\xc4"
          "\xe8\x10\x65\x2b\x18\xe8\x83\x09\xcf\x53\x2b\x35\x5f\xbc\x03\x26\x76\x9e\x66\x4b\x9f\x1f"
          "\xd7\xfe\x27\xcc\x9b\x2f\xb4\x60\x1d\xe1\x8b\x21\x1e\x8c\x6f\x96\xfc\x81\x5c\x82",
          "\xa9\x33\x68\x54\xb2\x02\x9c\x0a\x63\x15\x46\x47\x48\x0f\xa5\xcf\x24\xe7\xbd\x98\xc9\xe5"
          "\xf5\xe4\xca\x13\xe9\x7e\x54\xc2\xdc\x3b\x06\x5d\x34\x64\xa2\xb4\x66\xb1\xb2\xe7\x0c\xf5"
          "\xf3\xe9\x51\xad\xa7\x23\x8b\x62\xdb\x1c\xf0\xb2\x9b\xca\x0a\x6c\xf5\x32\xc6\xf3\xfe\xa7"
          "\xfc\x8e\x86\x2a\x7f\x9d\x78\x5f\x0b\x7e\x70\x11\xdd\x7d\x11\x3c\x14\x93\x41\xda\xa2\x97"
          "\x59\x65\x9b\x73\x5c\xc0\x5f\xa3\x40\xa6\xd7\x18\xa7\x17\xc4\x0b\xc9\x9a\x26\xbb\xdb\x37"
          "\xc7\x77\xcc\x1e\x84\xa3\xc9\x79\xe4\xa6\x14\x3a\xf9\x04\x78\xcd\x40\x0a\xd6\x9d\x07\xf0"
          "\xc2\xdf\xe2\xb8\x18\x3c\xa8\xfa\xd8\x39\xba\xab\xe8\xbd\x7a\x2d\x76\xcd\xd1\xe0\x44\x8b"
          "\xaa\x47\x53\x4a\x4e\x5e\x72\x91\x28\xba\x84\x6f\xc6\x8b\x8e\xd9\x2a\x7e\x8a\x06\xfe\xae"
          "\x68\x3b\x74\x0b\x68\x34\xaf\x82\xb3\x4c\x06\x7c\x18\xd7\x66\xe4\x0a\xa0\x5a\xbc\x6f\xf8"
          "\xd5\xa7\x6e\xae\xaf\x99\x4a\x3d\xc7\xb3\x7a\xea\x6d\x39\x0c\x0b\xac\x8a\x0e\x01\x29\xdc"
          "\x63\x39\x85\x0e\x13\xf0\xc7\x3f\x62\x3b\xea\x1f\xf1\xab\xc5\xc8\x45\xa3\xa0\x6c\x0f\x8f"
          "\x1a\xda\xe2\x3f\xf4\xf0\x44\xd1\xd6\x37\x67\x58\xf1\x1f\xd2\x98\xee\x8f\x07\x4f\x0b\x6e"
          "\x01\x4f\x4d\x65\x6f\xd2\x7e\x9e\x05\xdc\x7a\x02\x42\xda\x7c\x95\xa3\xde\x3f\x6a\xb4\x20"
          "\x6c\x92\x1b\xf2\x26\xbb\xcd\x2f\x07\x65\x38\xbf\x04\x44\x72\x1c\x7c\x3e\xac\x58\x7b\x1a"
          "\x83\x67\xe7\x52\xc8\x8e\xdf\x54\x37\x34\x3b\x70\x7a\x7e\x17\xd3\x00\x41\x16\x2e\xe1\x39"
          "\xc9\xdf\x29\x55\xb7\x48\xf0\x8e\x8e\x3c\x17\x94\x89\x5d\x67\x1c\x30\xbc\x73\xc8\xd6\xd8"
          "\xe3\xcb\x87\xbe\x19\xac\x63\xe8\x9a\x17\x0f\xcf\x45\x04\x11\x42\xa5\x93\x16\x5d\xdb\x68"
          "\xf3\x55\xa1\xe4\xc4\xda\xce\xdf\x83\x67\x9f\x6c\xbc\x0e\x12\x65\x84\x57\x28\xbe\x69\xf2"
          "\xad\xfd\x85\x44\x45\x9d\xb9\xf7\xdd\xc1\x05\x6b\xc7\x32\xc9\xf3\xc3\x41\x5e\x53",
          1, 3328 },
        { 128, 128, 27, "\x0f\x95\xaf\x47\xd2\xdf\x2a\x89\x31\x4d\xca\x4c\x01\xe9\x3b\x1e",
          "\x94\x24\xd6\xc4\x53\xcf\x49\x8b\x08\x29\xda\xc3\x9b\xdd\x6f\xb2",
          "\xed\xff\x83\x0f\xe3\x32\x73\x0b\xf6\xda\x54\x94\xdb\xfb\x11\xfa\x24\x16\xca\xa5\x24\xa3"
          "\xf3\x43\xad\x87\x0b\x4d\xfc\x93\xb7\x51\x17\xe3\xac\x64\x13\xf6\xad\xa7\x10\xd9\xf5\x29"
          "\xe1\x8a\x72\xf8\x2b\xa0\x5f\xf2\x3f\x3b\xf6\x76\x35\x02\xa2\x03\x61\x41\xfc\x47\xa3\x0f"
          "\xc9\xc1\x00\x95\xe9\xf9\x9a\x90\x1c\xaf\x75\x88\xcf\x93\xd2\x1a\xff\x9c\xda\x36\x51\x3b"
          "\x65\xa3\x7d\x41\xda\xc8\xde\x85\x22\xac\xf1\x4f\x41\x1a\x8b\x1b\x55\x79\x83\xab\xa9\x0f"
          "\x26\xf6\xbb\xc2\x59\xec\x1b\x02\xd4\x94\x49\xf4\xa0\x25\x32\x51\x5e\x00\x73\x42\x2b\xdf"
          "\x2c\x6e\xe2\xcb\xcb\xba\x6b\x66\x60\x67\xf3\x2d\x67\xf0\x2d\xe8\x65\xf7\xbd\x87\xfc\x34"
          "\x26\x6b\x59\x78\x43\x5e\x5a\x99\x3a\xd1\x44\x45\x07\x17\x0b\xc5\xc4\xd8\xcb\xf3\x13\xd3"
          "\x50\x71\x67\xed\xba\xd7\xdb\x51\x02\x61\xca\x75\x3b\xf0\x81\xde\xc2\xc4\x1f\x4d\x32\xb9"
          "\x57\x5b\xa8\x32\x91\xec\xb8\xfd\x50\xdc\x87\x31\x80\xc8\xef\xf6\xaf\xeb\x11\x2b\xda\xb7"
          "\x7b\x4f\xde\xcd\xb7\x37\x00\x41\x31\x6a\x12\x05\xb4\x6b\x1a\xd0\xda\x11\xac\x32\x6f\xcf"
          "\x9f\x77\xa7\x27\x50\x90\x9b\xd8\xe0\x54\x26\xe9\xca\xce\xd4\x85\x2d\x9a\x6a\x32\x96\x39"
          "\x5d\x5a\x02\x0e\x70\x35\xa6\x6a\x0d\x9c\xd6\x83\x34\xba\x2c\x52\x74\xf8\xba\x78\xc4\xb0"
          "\xd5\x7f\x77\x11\xb1\x8e\xc8\x7c\x25\x4a\xf1\x11\xb0\x60\xb6\x2a\x89\x06\xd2\xb5\xf6\x18"
          "\xff\xaf\x3a\xc0\x33\xd3\x48\x98\xff\x51\x85\xd5\x69\x23\x02\xee\x15\x5e\xda\x06\xfa\x25"
          "\x52\xad\x4e\x4e\xd8\x5d\x52\xa5\xea\xef\x64\x11\x1b\x52\xaf\x63\x45\x27\xf6\x06\xe5\x5e"
          "\x8f\x5c\x38\xb7\x2e\x43\x54\xe5\x57\x63\x86\x2e\xa0\x89\x6f\x41\xb1\xe5\xe8\xe4\xd6\x08"
          "\x18\xd8\x9c\xd6\x81\xd3\xee\x4c\x09\x5c\xfd\xc7\xab\x7a\x07\x66\x79\x07\x11\xd5\xe4\xd7"
          "\x00\x38\x55\x0b\x5a\xae\x82\x7e\x8a\x9e\xe8\xaf\xeb\x90\xcb\xa5\xcb\xaf\x50\x07\xbb\xee"
          "\x7c\x5a\x56\x5a\x6d\x91\xb0\xfc\xc9\xea\x27\xdc\x8d\x1b",
          "\x86\xa3\x23\x2c\xd6\x49\xb2\x3e\x95\x4e\xbd\x3e\xee\x5e\x48\x72\xbe\x33\xc3\x09\x9c\xe6"
          "\x9e\x2b\x18\x16\xc3\xa5\xdb\x49\x79\x07\xc7\x2b\x9f\xdd\x09\xdb\xa2\x27\x02\x49\xd1\x2c"
          "\x2f\xa2\x84\xc0\x15\x74\x91\x0c\x6c\x91\x8f\x73\xa9\xa2\x01\xdd\x28\xa9\x8a\x22\xe1\x25"
          "\x62\xdc\x0c\xd1\x16\xeb\x18\x2b\x47\x51\xb3\x3c\xf1\xd7\x25\x3f\x25\x0b\xc7\x5c\x3a\x62"
          "\x61\x94\x6e\xd1\x83\xad\x08\xd3\xa5\xf0\xae\x0c\xc5\x26\x8d\xc0\xf7\x35\x90\xa9\x78\xdb"
          "\x37\xc1\x82\xca\x65\xe0\xd2\x1d\x67\x85\x18\x12\x39\x17\x26\x3d\xda\xaa\xac\x51\x30\x29"
          "\xe6\xaf\x1c\x36\xf2\x1e\x3a\x40\x63\xf9\x45\x3b\xde\xcc\xf0\x7a\x10\x8b\x43\x1a\x9a\x2e"
          "\x4e\xb9\xd5\xe9\x7b\x67\x5e\xda\x4b\x0e\x1f\x02\x89\x08\x4c\x49\x3c\x84\x0a\xad\x24\xb0"
          "\xfd\x60\x37\xdd\x4e\x36\x09\x3a\xc5\xc5\xb8\xbb\xb4\xc3\xf0\x1c\x9d\xe7\x67\xcd\x95\x93"
          "\x97\x43\x01\x7e\x8b\x35\x47\x94\x4c\x34\xd3\xc1\xf1\xc1\x53\xaa\x18\x2d\x3e\x2c\x27\x35"
          "\x2e\xa6\x50\x6c\xd8\x8c\x22\xc9\x96\x19\x9f\x70\x8b\x5c\x73\xf9\x5e\x85\xd8\x91\xfe\xbd"
          "\x52\xef\x2f\x84\xeb\xb8\xeb\x78\x79\xa6\xd4\x3b\x04\x9d\x4c\x13\x41\x22\xd0\xe9\xcf\x55"
          "\x75\x6b\xe1\xe6\x3d\xd4\x38\x64\x0e\x44\x7d\x3f\xd8\xb8\x87\xd2\xd6\x37\x5b\x29\x8e\x2d"
          "\x86\xd3\xd5\xd4\xd6\x3d\x1a\x2d\x9f\x2f\xda\x07\x71\x29\x40\xc9\xd2\x16\x55\x6e\xd0\xbb"
          "\x2a\x48\x5a\x9a\xe3\x08\xa8\x54\xef\xbe\xcc\xe7\x66\x1e\xb5\x31\xb9\x32\x13\x1f\x1d\x1f"
          "\x57\x89\x1f\xd4\x91\x19\xe5\x88\x2b\x8f\x0d\xf4\x87\x3a\xea\x81\x16\x67\x90\x3b\x9e\x08"
          "\xba\x1b\xec\xc4\x0d\x42\xfd\x15\xc7\xbc\x38\xe8\x3c\xb3\xa0\xc9\xa6\xf4\x2a\xc1\x45\xeb"
          "\x7a\xf1\x38\xf5\x6a\xce\x4c\x06\x50\xa9\x98\xa9\x17\xd8\xb9\xf5\xf7\x8c\xac\xd3\xb0\xb7"
          "\x8a\x06\xe7\xb6\x7b\xb1\xfa\x8a\x76\x6a\xf8\x06\x3a\xbf\x33\xe2\xdc\xb5\x27\xbd\x68\xa6"
          "\x67\x9d\x57\x27\x40\x84\xe6\x28\xae\x7a\xcb\x98\xe3\x67",
          1, 3456 },
        { 128, 128, 28, "\xaa\x92\xbe\xcf\x00\xa2\x53\x42\xfe\xcb\x96\x3f\xfc\x41\x7e\x69",
          "\x77\xbe\xfe\x07\xa0\x1a\xf2\x0a\x10\xb2\x49\xea\xa8\x1a\xc7\x74",
          "\x87\xc6\x60\x52\xe8\x0d\xc7\xdc\x42\x8d\xa5\xe0\x46\x96\x6a\xe8\x37\x4f\x9e\xd4\xa7\x09"
          "\xba\xd2\x98\xec\xc6\x31\xd1\xa4\x15\x28\xb2\xec\xd6\x2f\x94\xb6\x41\x43\x63\x74\xb5\xc2"
          "\x58\xde\x90\xf6\x7b\x79\x2f\xc7\xaf\x8a\x19\x5d\x18\xcd\xb3\x49\x49\xf8\x49\x3d\x85\xcf"
          "\xf4\xd5\xe1\xa9\xab\x3b\xc9\xda\xbe\xd5\x99\x1f\xdd\xa1\xaf\x7f\x60\xa6\x03\xe1\xbd\x5a"
          "\x09\x3e\x4a\xf3\x2b\x66\xb2\x6b\x55\xf3\x41\x1d\xe3\x8d\xd3\x2c\xca\xa5\x34\xfb\x80\xd9"
          "\x97\x7e\x7b\xf0\x9d\x00\x2f\xf0\x1b\xb2\x08\x50\x62\x5d\x36\xce\x1a\xae\x4c\x1f\x64\x8b"
          "\x94\xd0\x63\x9c\xf2\xfe\x68\xed\x20\xc7\x89\xcb\xc8\x31\xc5\x89\x88\x73\xc7\x32\xa5\xc5"
          "\x27\xd4\xf4\xd8\xd9\x14\xfc\xff\x37\xdd\x11\x4c\x2e\x66\x63\x4d\x69\xe9\xf6\xc8\x9d\x9b"
          "\x07\xdc\x85\xc8\xf3\x9b\xfc\x03\x92\x5f\x5e\x86\x2d\x82\x0f\x8d\x4b\x41\xe8\x28\xbe\x74"
          "\x0d\xa8\x9e\x29\x7d\xec\xa1\xe9\xde\x8d\xcd\x87\x1f\xcc\x47\xd9\xba\x5b\x82\x7f\xf3\xff"
          "\xfc\x63\x89\x86\xc3\x73\xb2\xce\x26\x31\x82\xcb\x6f\xca\x29\xdc\xf0\xc3\x7a\xa7\x85\xae"
          "\x17\xc6\xbb\xbe\x4a\x13\x5c\xbc\x27\x4d\x24\xa8\x7a\x7f\x5e\x3e\x20\x59\xc9\x14\x4a\xd1"
          "\xcb\x51\x69\x6e\xa0\xce\x48\x0d\x13\xa8\x09\x62\xe9\xe9\x02\xac\xd3\x8a\x63\x43\x81\x8a"
          "\x57\x0d\x76\xdc\x1e\xa4\xb5\x2b\x25\xb9\x8f\xda\xfc\x58\xbf\x9f\x1a\x23\x51\xd7\xcc\xb9"
          "\x0f\xc1\x2b\x11\x3a\xf6\x50\x1a\x27\xcc\xdf\xb9\xa6\xd8\x53\xac\x6c\x7c\x7e\xaf\x21\x3d"
          "\xc5\x76\x80\x13\x51\x84\x2c\x0a\xe4\x0c\x7c\x5b\x76\x5f\x74\x4e\x80\xd3\x49\x74\xc1\x92"
          "\xd7\x97\x0e\xf3\x69\x51\x37\x89\x92\xab\x18\x0f\x9a\x33\xa9\x2c\x83\x01\xd9\xaa\xd5\x93"
          "\x98\x78\x67\x19\xf1\x92\x2b\x62\x17\x15\x97\x93\x71\xe7\x9b\xd1\x81\x9b\xd5\x14\x65\x65"
          "\xa9\xbd\x10\x2f\xf2\x86\x56\xc7\x44\x62\x58\x01\xae\x85\x43\x3f\x7e\x24\x30\x5f\x50\x84"
          "\x8e\x18\xef\x26\x08\x57\xe4\xce\xb6\x20\xc9\x4e\x3c\xf6\x82\x9e\x23\x64\x1b\x70\xf6\x60"
          "\x48\x35\x92\xf1\xf5\xf9\xfc\x2d",
          "\xcf\x2a\x13\x5c\x6e\x04\xc6\x3e\xf4\x40\x1a\xc5\xff\xf1\x8c\xdb\xd4\xfa\xaf\x2f\x49\x78"
          "\x3e\x91\xf8\x00\xbd\xb7\x16\xaf\x5d\xd9\x14\x23\xbc\xed\x32\x4d\x6e\x48\x74\x2f\xde\x01"
          "\xae\xee\xd6\xd2\x87\x02\x76\x1d\xe1\x02\x75\x75\xc2\x9c\xc8\x8f\xfb\x36\x67\x1a\x46\x59"
          "\xf0\x64\x82\xa7\x71\x4a\x5a\xf5\xdb\x27\x17\x3d\xce\xe3\x96\x38\xeb\x13\x8c\x32\x49\x18"
          "\xa7\x88\xb2\x67\x4d\xeb\xda\x22\xa1\x00\xe8\x4d\x91\xb7\xa6\xfa\x60\x6c\x20\x3e\x60\x4b"
          "\xb5\xe0\x36\x6d\xe7\x54\xe0\x41\xfc\xd6\xcf\x4e\x2f\x59\x2a\xb0\x11\x92\xb5\xb2\xea\x20"
          "\x1a\xbd\x4d\x0d\xe0\xdd\x21\xb3\x81\x14\xc0\xea\xcb\x48\xbb\xf3\x37\xc2\x2a\xfe\xeb\xe1"
          "\xdf\x65\xec\x12\x53\xfd\x4c\x8a\xae\xf3\x64\x52\x41\xe8\xf0\x19\xbb\x5e\x05\x76\xf5\x36"
          "\x9c\x52\x87\xd8\xa6\x2b\xa1\xaa\x92\xa8\x22\xb6\xf4\xf3\x7a\xf5\x54\x72\xf5\x38\x37\xf5"
          "\x8f\x8a\xe2\x97\x25\xe2\xbc\x6f\xdb\xfc\x51\x7a\x1c\xbe\x6d\xe1\x69\x3a\xe3\x97\x50\xa8"
          "\x10\xbf\x20\xf9\x83\xc5\x66\x22\x19\x21\x62\x78\x9f\xbd\x0d\xa9\xc9\x19\xd1\x29\x92\xb9"
          "\xd1\x18\x35\x6d\x19\xa4\x8b\xba\x2d\x8c\xd8\x59\xfe\xc0\xe1\x58\x04\x4c\x84\x04\x22\x2d"
          "\xdf\x0b\x6d\x88\x8b\x1d\x35\xb0\x0e\x32\x0a\x71\xa2\x77\x34\xd2\xd5\xa1\xcb\xd1\x98\x69"
          "\x3b\x29\xae\x23\x4a\x26\x45\x07\xf7\x82\xea\x10\xa6\x34\x9a\xea\x8c\xcd\x87\xef\x46\xdd"
          "\xf3\xd3\x99\x72\x43\x34\xbf\xfb\xa7\x7c\xc5\x42\x63\x77\x55\x35\x9d\x13\x6b\x95\xad\xaa"
          "\x07\x1b\x85\x31\x3a\x5a\xd8\x09\xf9\xbc\x6d\x1b\x28\x9c\x01\x49\x40\x02\xd6\x8e\xd8\x72"
          "\x22\x27\xa2\x18\x38\x10\x72\xc9\x24\xaf\x8e\x8a\xfc\x89\x21\xcb\xd8\xeb\x26\xcf\x5e\xae"
          "\x36\xee\xec\x25\x02\x3f\x82\x6a\x3d\x63\x03\x37\x8a\x60\x5a\x3f\xfb\xa2\x5d\x9b\xc6\x81"
          "\x53\x6b\x89\x34\x73\xb9\x34\x2b\x7d\xd9\x6b\xea\x2f\xe7\xb1\xe8\x2f\x38\xf8\xb5\x9f\x22"
          "\xa1\x97\xeb\x71\x42\xa6\xb0\xe0\x2b\x54\x35\x4b\x0a\x6d\x2f\x2f\x6f\xf5\xe5\x1e\x7a\x19"
          "\x4b\xe8\xb3\x75\xde\xf5\xec\x6e",
          1, 3584 },
        { 128, 128, 29, "\x17\x7e\x57\xe9\x13\x61\x2d\x30\xed\x21\xc8\xbb\xc9\xa8\xb0\x18",
          "\x30\x4c\x8e\x65\x98\xe4\x9b\x70\xe7\xb6\xf6\x04\x25\x36\x9d\x92",
          "\x0d\xee\x26\x45\xfc\xd0\x43\x79\x24\x27\xe2\xd7\x47\xb5\x2e\x77\x1a\x13\xf0\x5c\xc2\xca"
          "\xc8\xef\x86\xef\xad\x13\x08\x65\x70\xcb\x76\xec\x91\xc7\x3e\x11\x83\x01\x65\x57\x1b\x2f"
          "\x74\xab\xc5\x13\xbd\xcb\x2f\x1a\x74\x2a\x56\x2f\xeb\x24\x2c\x08\xc9\xa3\x03\xfa\x04\x02"
          "\xf2\xe9\xa8\xcf\x80\x74\x43\xdf\x93\x98\x00\xb4\x7e\xa2\x3c\x95\xba\x0e\x37\xc8\xd6\x04"
          "\xa1\x47\xce\xa3\x8f\xeb\x23\x28\x13\xb5\x93\xdf\x5c\xba\x91\xac\x8c\xfc\x26\xb9\xe2\x7b"
          "\x87\x38\x2e\x3e\xd1\x30\xae\x1e\xe7\x51\x18\xe5\x3f\x05\x64\x9c\xcc\x34\x70\xb7\xd6\x75"
          "\x51\x44\x57\x94\x1d\xa3\x2c\x07\x2a\x8a\x9b\x00\x8b\x92\x0a\x31\x59\x47\x6d\x4c\x21\x3e"
          "\x22\x55\x23\x7c\x1d\x20\x2b\x5e\x9b\xb2\x8d\x59\xea\xdf\x24\x84\xcf\x1c\x75\x29\xde\x07"
          "\x91\x81\x27\x7f\x7e\xa4\xe7\x35\x12\x0d\xd8\xb9\xe2\xef\xaa\x0a\xdb\x0e\x24\xa0\x9c\x24"
          "\xa4\x9b\x8f\x4f\x96\x66\x4a\x8f\x9c\x7c\xec\x18\xad\xa2\x07\x43\x48\x66\xe0\x3e\x5a\x78"
          "\xb1\x01\x63\x37\x87\xb1\xea\x28\xca\xe1\xa8\x22\xd3\x8e\xd6\x63\x14\xa7\xd8\x84\x1c\x29"
          "\xcf\x71\xfd\x74\x75\x90\x3b\xe5\xb1\xd0\x0f\xb6\x59\x7d\x10\xbe\x61\x6c\x53\xbf\x4e\xc2"
          "\x0f\x66\x8e\x8d\x04\x02\xac\x8d\xa1\xa6\x33\x16\x4c\x3c\x65\xe7\x22\x02\x44\x08\x1d\xf6"
          "\x22\x00\x43\xcc\x67\xce\x33\x88\xc4\x3a\x83\x32\xe2\xa8\xc3\xd6\x57\xd9\x96\x65\x3c\xf3"
          "\xf4\x72\x5e\x90\xa0\xa9\xfa\xde\x4a\x4e\x75\xdb\xc9\x33\x93\xfa\x98\x48\x1b\x78\x71\xc6"
          "\x9a\x4a\x87\xf7\xe9\x36\xa9\xdc\x66\x91\xdd\xab\xab\x32\x86\x2d\xf6\x24\xf3\xde\xb5\x34"
          "\xed\x6d\x55\x55\x76\x2d\x09\xf3\x94\xaf\xff\x53\x6c\x65\x4d\x01\xf6\x54\x33\xdd\xf6\x43"
          "\x24\xe4\x0d\xee\x7d\x0e\xaa\xe1\x99\x84\x16\xf4\xed\x94\x5b\xad\x8b\x4b\x35\x67\x6a\xe3"
          "\x20\x56\xaf\x35\xa0\x30\x2f\x77\x72\x59\x6b\xa8\x7a\x5d\x64\x47\x95\x07\x96\xdf\x7c\x80"
          "\xda\x51\x5a\xd7\x80\x7c\x7b\x1e\x4f\x98\x94\x06\xd3\x1a\x27\xa3\x93\xbd\x22\x00\xe3\xcd"
          "\x40\x4b\xfe\xf8\xad\x37\xc3\xa7\x60\x2d\x24\x82\x2e\xd5\xae\xb7\x94\xbd\xb6\xee\x9d\xcd"
          "\xdb\x7d",
          "\x8b\x59\xe7\x25\xb5\xcd\xfb\x74\xaa\x3f\x48\x7c\xa7\xde\x51\xdc\xbd\x4d\xa4\x53\x3e\xca"
          "\x05\xbf\xa6\x66\x41\xc4\x44\x8d\x35\x04\x56\x34\x7e\x51\x27\x7f\x29\xc1\xf8\x78\xb6\x37"
          "\x4e\xfe\x43\x36\x12\x06\xd7\x77\x66\x4d\xde\x2e\xd4\x2d\x59\x87\xd1\xb0\xac\xab\x2a\xfe"
          "\xfa\x9c\x30\xdd\x5f\x68\x5d\x46\x96\xbc\x8e\x3e\x2d\x4c\xe8\x93\x03\x4d\x7a\x2a\x8b\x63"
          "\xcf\x3d\x0a\x6d\x80\x47\x56\xd5\x66\xca\x68\x64\xfa\x51\x69\xe8\x4a\x76\x08\x11\x94\x5a"
          "\x01\x9f\xad\xd8\xf7\x53\x1b\x51\x5d\x03\xa8\xf5\xea\x9f\x31\x2c\xab\x7b\x8e\x3f\x68\x3e"
          "\x8b\x53\xea\x8b\x68\xd2\x75\x15\x0b\xa9\xc0\xa1\x85\x87\x40\x48\xde\x1d\xba\xae\x92\xb3"
          "\xee\x94\x9f\x2d\xaf\x06\xae\xc4\x10\x70\xf3\xa1\x52\xa2\xc2\x19\xe6\xce\x88\x3b\x3a\x5e"
          "\x59\x2c\x2b\x7e\x19\xf5\x95\xf3\x21\xaf\x61\x49\xa9\x0a\x58\x37\x3b\x9d\x4b\x7a\x32\x1f"
          "\x2e\x41\x1b\xc9\xad\x0e\xdf\x05\x6e\xc5\x3d\xe1\x98\x26\xae\x5f\x37\x25\xac\xc0\x7b\xbf"
          "\xd0\xa6\x56\x3d\x95\xcf\xf0\xa5\x03\x14\x51\x84\xf0\xa2\xa4\x30\x91\xd2\xfd\x11\xb1\x6c"
          "\x55\x3f\x76\x5a\x3b\xda\x88\x3d\x61\xe7\x4e\x5a\x55\xd8\x66\x26\xd4\x82\xf1\x01\x63\x87"
          "\x14\x8b\x3d\xbf\xdc\xaa\x4b\xca\x2a\x8e\xd1\x7b\x9b\x96\xda\x85\xeb\xb3\xe0\x3e\xb3\x9e"
          "\xc5\x09\x80\x84\xd2\x29\xd4\xad\xb4\xb2\x53\x1d\x71\x9b\x6b\xa3\x75\x7a\x6b\x5f\x9d\x54"
          "\x8e\xa4\x28\x2b\x9f\xb7\xdd\x80\xbb\x78\xa2\xc9\xe2\xaa\xbb\x19\x40\xce\xb4\x3b\x92\xb5"
          "\x4b\x28\x8c\x59\x54\xc7\xd5\x9c\x88\x20\x30\x33\x07\xaa\xdd\x2a\xca\xbe\x03\x89\xce\xdc"
          "\xcc\x4b\xa3\x5a\x7d\x41\xc2\x45\x07\x8c\xb8\x7a\xbc\x31\x9c\x47\xdd\x8f\xc4\xd3\x43\x15"
          "\x33\x6a\x30\x7a\x8a\x17\xdf\xcb\x5f\x16\xb3\x5b\x21\xf7\x3c\x96\x6c\xaf\xd4\xf1\xcf\x47"
          "\xad\x00\xac\xa3\x8b\x66\x83\x6a\xd9\xe1\xe8\x5b\xbc\x03\x08\x27\xdb\x58\x18\x94\x8b\x94"
          "\x62\x95\x44\x05\x31\xc8\xac\x12\xec\x8e\x16\x78\x6b\x32\xef\x72\x13\x8c\x34\xa1\xb4\x9b"
          "\xbe\xc8\x19\x73\xaf\x39\xfc\x9b\x31\x7f\x9a\x35\x26\x8a\x1e\x54\x03\x34\x00\xe0\xa5\x55"
          "\x7b\x30",
          1, 3712 },
        { 128, 128, 30, "\xdd\x1f\xa1\x9d\x62\x56\xf7\x16\xf3\x18\x89\x55\xce\x5b\xc6\x70",
          "\xc8\x0b\x82\xd5\x32\xce\x2a\x88\x3d\x4d\x08\x66\xd6\xc3\x26\x9c",
          "\x28\x62\xa1\x02\xbd\x54\xe0\x2b\x88\x00\x38\x35\xe3\x3d\x1d\x38\x5c\x61\xf1\xd9\x7b\x09"
          "\x9d\x53\xef\x02\x88\xb4\x85\x35\x4f\x21\xe4\x1c\x5f\xba\x05\x48\x92\x1a\xb6\x9e\x95\x1d"
          "\x08\x60\x55\x8a\x53\x34\xc3\x88\x9b\xb4\xe3\x63\xbf\xdd\xd6\x44\x73\x4f\x8b\xc7\xfb\x5e"
          "\x1b\x75\x0e\xba\x3a\xd8\x61\xaa\x59\x96\x16\x02\x34\x5b\xea\x78\xda\x9c\xe4\x50\x45\x98"
          "\x1e\x4e\xdb\x79\xeb\x52\x39\x89\x94\xcf\xfa\x4e\xfc\x2d\x75\xff\x27\xb8\x24\x53\xd2\x25"
          "\xb0\xd0\xff\x60\x5a\x8d\xd4\x0d\xb1\x30\xf6\x82\xa4\xf4\xb6\x60\xc1\x9c\x24\xa4\x4f\x65"
          "\xc8\x35\x48\x84\xb7\x5a\xe1\x5e\x2d\xa9\xc6\x02\x13\x41\x49\xe3\x94\x83\x76\xa4\xd5\x91"
          "\x57\xfb\xe1\xb9\x5b\xca\xb5\xbf\x88\xa1\xd0\x67\x32\x2a\xca\xd1\xc2\xc6\xd3\xf8\xc0\xd3"
          "\x69\x9b\x65\xc7\xa5\x35\xf5\xcb\xd8\xf3\x3a\x0b\xae\x9b\xd1\x5f\x6e\xee\xda\xfc\x78\xa7"
          "\x6c\xac\x01\xbd\x58\xd9\x6e\x05\x04\xc9\x8e\x47\x39\x38\x92\x63\x8e\x00\xed\xb5\x21\x61"
          "\xc1\xf0\xee\x5f\xfd\x27\xd4\x4d\x3a\xc5\xcc\x70\x21\x08\x00\x6a\x78\x10\x64\xa9\x10\x5a"
          "\x77\x4c\xf2\x2f\xe0\x60\xa3\xf4\xbd\x43\xde\xf0\xf4\x9e\xa7\x1d\x5d\x96\x36\xda\x35\x05"
          "\x84\x3a\x37\x09\xf0\x7b\x16\x01\xf1\x71\xfd\x9c\x89\x79\x7e\x17\xc5\xfc\xeb\x08\xe1\xaa"
          "\x18\x44\xc9\x9e\xf5\x74\x5f\x1f\x7b\xa1\x36\x86\x34\x13\xd3\x4b\x1c\x7a\x69\xb4\x5b\x1a"
          "\x9d\xda\x1e\x6f\x79\xcd\xab\x77\x1c\x32\x2e\x30\x1b\x3a\xa4\xf8\xb6\x7f\xaa\x8c\x7e\xdf"
          "\xda\xf8\xc9\xaf\x2a\x96\x91\xb1\xff\x62\x9c\x4c\x77\x4d\x8b\xdc\x2c\xf7\x3f\xfd\xea\x36"
          "\x3d\x18\xaa\xb2\xa1\x38\x34\x28\x60\xdb\x52\x50\x79\xaa\x34\x23\x44\x15\x31\x58\xb1\x4e"
          "\x5c\x25\x76\x98\xd6\x52\x1c\x14\xed\x13\xdb\x0d\x6b\x10\x3d\x07\xdc\x5f\xbc\xf8\x7c\x20"
          "\xc8\x0f\x1b\x3b\x06\x58\x88\x91\x3e\x61\xa0\x24\x0c\x18\x60\x9e\x44\x37\x4d\x61\x55\xdc"
          "\x0f\x18\xbc\x1c\xd3\xa4\x68\x41\x6b\x69\x9c\x79\xf2\xd3\xbb\xbf\x83\x52\xb2\xd4\xec\xec"
          "\xa3\x31\xd5\xb1\x21\xaa\x2b\x61\xaa\x96\xa5\xa9\x87\x86\x8e\xcb\x46\xc0\x96\xff\x3e\x50"
          "\x62\x74\x90\xb4\x21\xb4\xcd\x06\x6e\xac\x65\x58\x77\xcc\x90\x54\x32\xb8",
          "\x63\x44\xd7\x3b\xd5\xe7\x51\xc0\x58\x40\x0e\x86\x9a\x96\x78\xfe\xe6\xc3\x2f\xb0\xf4\x70"
          "\x2f\x83\x06\xd3\x76\x8f\xe2\xa5\x0c\xbb\xeb\x43\x29\xb8\x13\xac\x09\xc8\x94\x3c\x6c\x48"
          "\x14\x36\xb0\x4a\x9d\xce\x20\x90\x6e\x47\x00\x2d\x3b\xae\x36\x46\x4a\x90\xd0\x65\xaf\x33"
          "\x98\xbb\xde\xda\x94\x87\x43\x2d\x67\xfd\x89\xee\x5c\xf1\x51\x1e\x8c\x6f\x0b\x60\xe9\x30"
          "\x2d\x2c\x16\x5c\xc0\x8e\x1b\xc7\xfa\xeb\x1e\xba\xf6\x6d\xed\x35\x51\xb3\x8a\x33\x1b\xff"
          "\x82\xce\x7c\xe6\x89\x5b\x2a\x14\x3d\x07\xeb\x60\x65\x7b\x73\x80\xba\x26\xbb\xde\xf2\x6c"
          "\x29\xb5\x96\xae\x7b\x42\x73\xd9\x63\x55\xc2\x06\x30\x83\xf8\xf4\x62\x78\xcf\x29\x6a\x3a"
          "\xdf\xb3\x2d\x38\xe9\xf8\xdc\x8c\xbd\xd9\xca\xe3\xda\x6c\xb0\x4b\x54\xba\x70\xa0\x65\xf8"
          "\xf4\x11\x87\xeb\x4d\x38\xda\x08\x6f\x7b\xd7\xce\x9c\xcd\xf3\x12\x7e\xa3\x9b\xb4\x79\x52"
          "\x17\x01\x4c\x57\x1c\x19\x02\x32\x1b\x1b\xde\x33\xd4\x2e\x0c\xc1\xa3\xa5\x0f\xea\xc2\x03"
          "\x96\x60\xa4\xd6\x95\x74\x0a\x60\x06\x4d\x2e\x98\x5e\x87\x26\x4c\x22\x06\x5d\xd5\x63\xef"
          "\x02\xbc\x81\x74\xe5\xd6\x62\x73\x19\x65\x6b\x93\x0b\x5a\x0e\x57\xa7\x91\x3c\x20\x08\xda"
          "\x13\xd8\x2b\x22\xe3\x09\xcb\x02\xc3\xce\x15\xdd\x83\xf7\xaf\x1c\xc2\xb7\x85\x7e\x25\xd3"
          "\x78\x87\x70\x9f\xfd\xf9\x26\xd4\x38\xf0\xc2\x21\xc2\x1d\x7a\x69\x29\xc4\x71\x23\xcf\x11"
          "\xd1\xa4\x5f\xdf\x73\xc4\x18\x10\xc9\x50\x86\x23\x04\xf4\xdf\x4a\x2a\x57\x4d\xcc\x64\x4c"
          "\x2c\x04\x82\x47\x4e\x17\x50\x49\xb4\x1e\x1d\x1e\xc9\x7a\xf1\x81\x2f\x9c\x71\xe8\xf9\x20"
          "\x3b\xc4\xa4\x33\x95\xd5\xa4\x1b\xa9\xc1\x2f\xd2\x91\xa7\x8e\xf1\x03\xfe\xe2\x68\x41\xe5"
          "\x52\xef\xba\xcc\x65\x76\x3a\x8a\x4e\xe6\x98\x6f\xa7\x11\xdf\x2d\x32\x91\x76\xe7\x5d\x40"
          "\x33\x50\xe6\x8f\x8f\x32\x98\x52\x8b\xd5\xda\xa4\x99\xf2\x47\x40\xe9\xb0\xb4\xc1\xb8\x70"
          "\x08\x77\xd6\xc3\xd4\x34\x84\x10\xf5\x07\xc3\x28\x1c\xe7\x63\x78\x27\xb1\x1f\xb3\xed\xd2"
          "\x61\xd3\x19\x8c\x72\xf6\x85\xa6\xa8\xf3\xbc\x17\x6f\xcf\xbb\xeb\xfb\x7f\x6e\xa9\x7f\xb6"
          "\xf2\xcf\x92\x2e\xb6\x66\x84\xf9\xec\xdf\x62\x12\x5f\xb3\xc6\xab\x1a\xbd",
          1, 3840 },
        { 128, 128, 31, "\xc2\x82\xb6\x06\x31\x85\xa6\x16\x80\x72\x46\x1a\x35\xa6\x3d\x61",
          "\xf1\x16\x0f\x53\x26\xa1\x25\x1b\x6b\x2f\xf0\x85\x21\x55\xd3\x35",
          "\xc7\x44\x23\x87\x35\x67\xc2\x2f\x09\xed\xc2\x43\x94\x29\x79\x7e\xaf\x90\xc6\xc1\x8a\xc4"
          "\xa4\x19\x66\xbb\x2c\x8f\x2b\x98\x47\xa5\x73\x00\x9f\x11\x44\x38\xe5\x8e\x17\xb3\xc6\xca"
          "\x6f\x14\xf3\x1d\x5d\xcc\xb4\x0c\xde\x8a\xf9\x65\x57\x3b\xe9\x7b\x72\x4b\x28\x5b\x99\xf0"
          "\xb4\x14\xa7\x04\x0b\xf2\x8a\x58\x3b\x17\x99\x92\x0f\x1c\x57\x0a\xd5\x92\x47\xa0\xa6\xc6"
          "\x6e\x68\xad\x92\x34\x94\x75\x1c\x73\xa9\x8a\x21\xa1\x7c\xca\x9c\xfa\xfe\x8d\x6f\x8e\x0d"
          "\xb2\x65\x5d\xd5\xc8\xb3\x37\x6a\xa9\xde\x4e\xfe\xaf\x20\x45\x92\xa0\x34\x53\x62\x6e\x8a"
          "\x92\x7a\x70\x9d\xe7\xe3\x30\x9f\xca\xe3\xf4\x0e\xf9\x52\xb2\xf8\x75\x13\x85\x6a\xad\x6b"
          "\x70\xcf\xc6\xc8\xc9\xab\x5f\x3d\x8f\xa4\xa2\x48\x5b\xe8\xd2\x4f\x1e\x67\xbd\x46\x10\xdf"
          "\xa4\x19\x38\xf4\xe6\x86\x2a\xd7\x07\xfe\x63\x8d\xfe\x52\x42\x3a\xd5\x7f\x84\x8d\xef\x62"
          "\x68\xc2\xee\x80\x2c\x4c\xd3\x76\xfd\xde\x06\x68\xb3\xbf\x09\x3a\x79\xf3\x56\xcb\xe9\x50"
          "\xc6\x0a\x65\x96\xf4\xec\xc9\x48\xec\x1b\x66\x1c\x25\x9b\xd5\x61\x51\x28\x96\xfb\x28\x73"
          "\xf2\x1f\xb8\xd8\xef\x50\x07\xd2\x25\x28\xc2\x6a\x3a\xd7\xc7\x4a\x8b\xfd\xfb\xbe\xdf\x74"
          "\xb6\x1a\x1a\x1c\x45\x48\x12\xbf\xd1\xdb\x41\x25\x18\xda\xf9\x01\x17\x20\x36\x0c\x74\x11"
          "\x08\x99\x37\x97\x8c\x00\x1a\x73\x75\xca\x62\x64\x80\xfd\xac\xb3\x06\xbe\x8a\xbb\x20\x81"
          "\xa9\x2a\xe9\xac\x9c\xfa\x97\x67\x60\x10\x83\xbd\x19\xcc\x62\x7f\xbd\x8f\x42\x18\xc5\xdd"
          "\x31\x27\x20\x6e\xf4\x5b\x89\xd2\x9d\x19\x17\x3b\x2f\x90\x03\xc3\xa2\xcf\x01\x3c\x69\x9b"
          "\xa6\xd8\x81\x52\x3f\x71\x38\x59\x3b\xab\x8f\xa0\xef\x74\xe4\x45\x82\xaa\x9b\xc6\x88\x20"
          "\xe9\xc2\x13\xbd\x95\x80\xb5\xd6\x85\x13\x75\x95\x62\x2c\x4f\xe1\xb7\x2e\x3d\xe6\x72\x71"
          "\x5e\x2f\x83\x85\xae\xb5\x8a\x38\xb7\x9f\x77\x01\x38\xf2\x80\x4b\x1d\xb1\x86\x02\x82\xc4"
          "\x04\x9a\xfa\x44\x58\xe6\x9c\x88\xd2\x79\xec\x12\x0e\x87\x0f\x31\x84\x4c\x3c\x5a\x0b\xed"
          "\x8d\xd7\x1a\xbc\x8b\x7f\x22\x57\xc2\x72\x78\xf6\x41\x2b\x46\x74\xde\x00\x37\xea\x2c\xc9"
          "\x53\x95\x0e\xbd\x2b\x93\xd9\x57\xc3\x70\xa6\x80\xaa\xeb\x48\xd0\x26\x8e\x6a\xdc\xcf\x80"
          "\x08\xb5\xb7\x35\x72\x70\xa1\xa4\x4d\x45\xf3\x24",
          "\xa9\xbc\x39\xb1\x42\x8d\xc4\x82\x8e\x1d\x0d\xd3\xc1\xaa\xcb\xbd\x70\xaf\xf1\x70\x05\x21"
          "\x0d\xcc\xa3\x26\xc0\xc3\x26\x5d\xad\x4e\xa8\xe3\xfd\xf0\x20\x86\xf8\xd7\x05\xf8\xa3\xe6"
          "\xcf\xa8\xf4\x13\x29\x43\x02\x2c\x65\x91\xb6\x6b\x2f\xd5\x67\x6f\x3b\xb8\x22\x19\x2d\x9a"
          "\xe7\xe4\xaf\x97\x50\x20\x6c\x8f\xc3\xb4\xe8\xb5\xa4\x9d\x5d\x74\x6e\x65\x54\xaa\xd9\x49"
          "\xc8\x8b\x8f\x8f\xa7\xea\x2d\x03\x40\x96\x50\xe6\x9b\x89\x76\xc4\x0f\xcf\x81\x38\xa7\x79"
          "\xcd\x4d\xbe\x5a\x95\x11\xdd\x31\xad\x4e\x51\x36\xe9\x55\xd0\x02\xf0\x50\x25\xff\x45\x68"
          "\xd1\xb4\x77\x56\x92\xa4\xa3\x0e\x97\x64\xef\x30\xe9\x4b\x19\xe8\x59\x36\x22\x27\xdb\x87"
          "\x47\x14\xa3\x50\x91\xf1\x2e\x56\x7b\x91\x73\xc3\x42\x0f\x66\x84\x5f\x98\x48\xbb\xae\x89"
          "\xc0\x05\x92\x12\x43\xca\xc6\x94\xe0\xc5\xf4\xb9\x26\xfd\x5b\xd6\x2b\x33\x60\xa1\xba\x8c"
          "\x0b\x4a\x45\xd4\x87\xf7\xd1\xcd\x32\x38\x59\x6a\x76\x26\x6f\xba\x3c\x3d\xa9\x29\x13\x6d"
          "\xe6\xc8\x44\xed\x9f\xe4\x76\x16\xf4\xb4\xbe\xff\x2c\x46\x55\xf0\x86\x87\x91\x2a\xf4\x2f"
          "\x48\xe9\xba\xc8\x71\x13\x68\x5e\x89\x10\x40\xec\x93\x38\xcf\xb2\xe2\x51\x15\x3a\x08\xaf"
          "\xde\x55\x3c\x7a\xf4\xed\x2b\x7b\xc8\x0c\x28\xe2\xf7\xa7\x96\x89\xd7\x28\x8c\x76\xef\xbe"
          "\x6c\x2b\x21\xb3\x15\x1f\x80\x77\xba\x94\x30\xca\xca\x8c\xec\xce\x79\x93\x98\x93\x19\x24"
          "\xf3\x57\x6c\xfc\x86\x32\x8f\x9b\x68\xc6\x2a\xb0\x6a\xa6\x02\x9a\xfe\x2b\xdc\x2c\xa4\x82"
          "\xba\x35\xf5\xcd\xa8\x2c\xb4\xf0\xad\x7d\x59\x5c\xd2\x5c\x2a\x08\xf4\x02\x12\x80\xb9\xfc"
          "\xe5\x35\xfc\x33\x6b\x8e\x22\xcd\xca\x76\x04\x9e\x4c\x4e\x52\x30\xfc\x43\xd8\x7b\xdf\xdc"
          "\x28\xf7\xb0\xa8\x9f\x54\x85\x01\x96\xbe\x74\x06\x7f\xe5\x50\xec\x13\x39\x2a\xe4\x28\xc0"
          "\x4c\xf4\x53\x18\x80\x08\xeb\x45\x3c\x82\xa0\xf8\xf2\x7c\x8e\x31\x04\xc4\x30\xca\x6a\x54"
          "\xbf\xeb\x2e\xd6\xb4\x31\x64\x9a\xc7\x62\xf7\xed\xba\xf7\xff\x8f\xe2\xef\xa7\xf5\x4b\x8b"
          "\xd3\xa4\x2d\x6c\x22\x17\x80\x29\x49\x2c\xff\x6b\x39\x80\x04\xf6\xd6\xbc\x6c\x86\xb3\x1c"
          "\x31\x3c\x22\xe5\xe3\xa7\xdb\x17\x1a\x90\x23\xdd\x37\xd3\x3b\x6b\x6d\xe9\xb3\xc6\xf5\x92"
          "\x7e\x43\xdc\xdc\x23\x55\x25\xcb\x04\x81\x40\x2c",
          1, 3968 },
        { 128, 192, 32,
          "\x71\xb8\x95\x3a\x00\xba\x68\x83\x03\xdb\x74\xf5\xef\xea\x6d\x95\xea\x0e\x75\x1a\xa9\x2b"
          "\x1d\xe6",
          "\x37\xdc\xbd\x37\x25\x2c\xe8\x28\x19\xc9\xb0\x51\x1b\x6e\x18\x86",
          "\x12\x58\x67\x1d\x6f\x88\x4a\xcc\x78\x54\x93\x95\x48\x06\xca\xd6",
          "\xde\x3d\x1f\x00\x14\x59\xbb\xb3\x97\x68\x33\xe8\x56\x94\xc8\x8c", 1, 128 },
        { 128, 192, 33,
          "\x5a\x63\xad\x1b\x55\xe4\x5d\xc9\x0e\x6a\x4b\xda\xa4\xb2\x16\x2d\xd2\xb3\x5b\x68\x1a\xb9"
          "\x27\x4f",
          "\xdb\xf5\xc0\xd7\xd8\x4d\x78\xc4\xa4\x5b\x25\x76\x7c\x96\x7d\x56",
          "\xf4\xe3\x02\x38\x01\x5e\xa2\x2b\xe6\xe0\x1d\x9f\x01\x09\xf3\xc5\x78\xac\xd5\x06\x08\x46"
          "\xb2\x95\x2c\x7a\xf6\xde\xe1\x85\x15\xb7",
          "\x16\x4f\x99\x76\xda\x02\x0f\xee\x7a\xce\xb6\x54\x08\xb7\x3f\x3b\x22\x64\x88\x63\xcb\x3c"
          "\x1a\x55\xc7\x31\x50\x76\x82\xff\xcf\x62",
          1, 256 },
        { 128, 192, 34,
          "\xb2\x96\xb7\xcd\x8c\x3d\x0a\x41\x66\x67\x13\xce\x36\x0c\xfd\x99\x0e\x6e\x9b\xfb\x65\x67"
          "\x62\xce",
          "\xb4\xc0\xb8\x1f\xcc\x97\x14\xc8\x57\xf6\x38\x4e\x67\x37\xb7\xbc",
          "\x2b\x91\x1a\x3a\xbe\xc3\x96\xaa\x98\xe5\xb7\x01\x6a\x79\xc1\xc3\xe4\x30\x50\x55\xaf\x93"
          "\xf9\x4f\x63\x84\x14\x8e\xc4\x89\x73\xcf\x94\x16\x9c\x42\xe2\x08\xce\x31\xb7\xf3\xb8\x78"
          "\x45\x5a\x65\x25",
          "\x19\xd5\x09\x38\x5e\xd8\x5c\x56\x0a\x63\x97\xde\xb4\x62\x41\xd9\xb5\xb7\xf0\xf7\x16\xa2"
          "\x83\xc9\x9b\x0e\xbb\x73\x1a\xe5\x1e\x3d\x27\xc1\x74\x13\x68\x65\x8d\x9b\xd2\xae\xce\x9a"
          "\x40\xd5\x78\x7a",
          1, 384 },
        { 128, 192, 35,
          "\x54\xec\xfa\x33\x42\x5e\x0d\x91\xe9\x9b\x11\x15\x97\x1b\x5c\x0f\x05\x7c\x29\x82\x55\x45"
          "\x9b\x08",
          "\xc8\x30\xd0\x2a\xa2\x6c\x34\x61\x1d\x66\x41\xb0\xb7\xe9\xd9\x84",
          "\xc1\x4e\x56\xef\x62\x68\x92\x32\xc8\x2a\xfa\x86\x4a\xeb\xc2\x49\xc8\xba\xcd\x50\x45\x65"
          "\x31\x85\x85\xc0\x2d\x3c\xae\x05\x4b\x4b\x36\xd1\x62\xb3\xc6\x3b\x39\xc3\x1c\x29\x24\xe2"
          "\x94\xd1\xd1\xe3\x48\x8c\x0c\xd2\xc8\x1f\x8c\x24\xf1\xad\xe0\xa9\x42\x8c\xa1\x29",
          "\x5f\x41\xf8\x33\x06\x8c\x8a\x0c\x58\x9f\x97\xc1\x59\xf7\x38\x78\x9c\x1e\xe1\x78\xa2\xfc"
          "\x96\x5e\x5e\x1e\xc6\xec\x09\x5e\xd6\xd7\xe0\x3b\xd3\xb6\xc1\x67\x32\xd5\x35\xac\x3a\x1d"
          "\x5c\xe6\xb6\xc9\xd8\x3e\x9f\x88\xba\xae\x5a\x4d\xad\xd1\xe7\xd8\x33\x7d\xce\x9b",
          1, 512 },
        { 128, 192, 36,
          "\xc7\x90\xa2\x2f\x82\x42\xb9\xec\x5f\x37\xb6\x10\x11\x44\x48\xea\xe3\x42\xcd\xd8\x45\x81"
          "\x0f\x64",
          "\x5e\xaf\xb2\x3a\x9b\x60\x63\x00\x22\x9c\x0f\xe4\xcd\x66\xa7\xaa",
          "\xbc\xfb\x1a\x49\x0e\x58\xb8\xac\x3b\xa6\x2b\x2d\x09\x0b\x98\x1b\x33\x80\x3b\x5e\xa2\x74"
          "\x28\x4b\xd1\x8b\x93\xb7\xba\x5f\x14\x67\xa4\x1b\x4f\x12\x3e\x7b\x6d\x00\xd8\x3f\x52\x9e"
          "\x64\xde\xe3\xb9\x56\xcf\x6c\xc7\x1b\x37\xa8\x25\xb7\x6e\xda\x4b\x54\x26\x0c\x4f\x9f\x8a"
          "\x5c\x46\x92\x82\x69\xa6\xee\x3d\xc4\x34\x61\x4b\x33\x43",
          "\xfd\x08\x14\x97\xef\xb8\x40\xac\x9d\x0f\x86\xac\xfe\x69\x7d\x9c\xcc\x4d\xd1\x9e\x71\xde"
          "\x5f\x31\x3d\x2c\xd0\x3b\x86\x38\xdf\x5f\x53\x72\x4d\x39\xf8\xdd\x13\x81\x9c\x77\x64\x39"
          "\x98\x65\x47\x81\x58\x2c\x02\x36\xf8\x77\x91\xae\x95\x9a\x16\xf7\x51\x68\xe8\x7c\x96\xa9"
          "\xba\x4d\xa1\xc1\xe2\xc9\xbb\xe6\xf1\xa1\x81\x4d\x66\xef",
          1, 640 },
        { 128, 192, 37,
          "\xde\x93\x03\xcd\x52\xa1\x01\xd8\xc3\x7e\x1b\x63\x19\xf9\x32\x4d\x1b\x74\xa5\x3b\xea\x44"
          "\xda\x74",
          "\xc8\xc7\xf2\xcd\xf3\x20\x33\xa5\xfb\xa5\x3e\xa1\x34\x93\xff\x26",
          "\xe9\xa2\xba\x41\x3c\x59\x8d\x39\xab\x7f\x1b\x62\xb3\xdf\x7d\xe9\x01\x51\xa2\x54\x63\x8e"
          "\x08\x66\x26\x11\xb4\x77\xed\xde\xe1\x47\xb9\xd9\x4c\xba\xaf\xbb\x4c\x81\x55\xd2\xb3\x00"
          "\x4b\x32\x3c\xa4\x5d\x54\xe6\xdd\x7f\x76\x4a\xe2\x4c\xb7\x13\x4a\x46\xbe\x98\x9c\x33\xee"
          "\xa4\xa1\x8e\x6b\x84\x80\x84\xcb\xa0\xf7\x9f\x5c\xfd\x2d\x82\xe4\xc4\x51\xc4\x4b\x02\x86"
          "\x1b\xed\xf7\xca\xa9\x68\x6d\xe2",
          "\xe7\xe4\x36\x05\xa5\xcb\x66\x97\xef\x81\x92\x56\xf8\xdd\x1e\x8b\x21\x49\x9f\x18\x5b\xf6"
          "\x2d\x3d\xe5\xe6\xca\x0e\xae\x63\x44\xc4\xb0\x9b\xf7\xcb\x3d\xf9\x01\xf6\xcc\x94\x3b\x2d"
          "\xd5\x0e\xd0\x2e\xc3\x27\xb8\xec\x8b\x14\x0d\xfc\xa2\xbe\xdd\x22\x9f\x2b\xc5\x02\xa3\x7a"
          "\xb1\xcd\x61\x53\x3a\xde\xae\x86\xa0\xe3\xea\xbc\xe7\xf1\xd3\x55\x7a\x8a\x57\xd3\x5b\xee"
          "\x89\x4e\x35\x1b\xed\x6f\x51\x60",
          1, 768 },
        { 128, 192, 38,
          "\xed\xaf\xd4\x87\x06\x5f\x4f\x9a\x0a\xaa\xc3\xeb\x69\xd3\x1b\x46\x98\xe5\x81\x2c\x15\x4d"
          "\xa2\xff",
          "\x73\x3c\xb8\xbb\x47\xb3\x2b\x83\x3c\xf6\xc4\xd6\x5c\xca\xc5\x06",
          "\xaa\x51\x24\xf8\x4d\x09\xb0\x86\x0a\x87\x8b\x8c\xc7\x96\x26\xb8\xc9\xb0\x62\xcc\xa4\x1d"
          "\x20\x00\xa1\x97\x4a\x92\x3f\x9a\xe7\x10\x66\x27\xa5\x4b\xcb\x02\xa0\x77\xe5\x07\x18\xf9"
          "\xee\xe6\x84\x2e\x58\xb3\x03\xa3\xa6\x41\xb4\xda\xc7\x34\xbd\x5b\x88\x6b\xd5\xd8\x56\x83"
          "\x21\x46\x4a\xb5\xa0\xad\x7f\x7c\x72\x74\xbb\x9a\x3f\xef\xa0\x49\x85\x13\x48\xe9\x5e\xe4"
          "\x91\xc8\x85\x9d\xb4\x90\x94\x3c\x20\x27\x10\x1d\x61\xf6\x7a\xd6\x7c\x4b\x7d\xe9\xce\x46"
          "\x40\x5c",
          "\xc6\xd4\x23\x0b\x66\xdb\x53\xb5\x4b\xf4\xf9\x4c\x19\x56\x97\x91\x0e\x14\x11\x65\x48\x92"
          "\x2d\xc3\x07\x56\xbf\x43\x0b\xa8\x67\x0e\xb3\x2b\xf6\x14\xee\x8f\xc5\xaa\x70\x58\x24\xce"
          "\x6f\x43\x93\xce\xbd\x87\x2a\x94\x73\x9c\xcd\xb8\x21\xd6\x90\xf7\x7f\x57\x7d\x47\x3d\x3b"
          "\x1a\x37\xad\x62\x53\xd2\x7d\x1f\x83\x86\x90\x9d\x33\x8e\xd4\xa1\x47\x12\xc6\x44\x31\x2c"
          "\x1c\x8d\xb2\x14\x4b\xe4\x4b\x26\x59\xbb\x75\x14\x72\xe9\x92\x44\x92\xee\x21\x49\x41\x9b"
          "\xa8\x49",
          1, 896 },
        { 128, 192, 39,
          "\xec\xde\x8d\x56\x45\xec\xff\xe1\xff\x4f\xe4\x3a\x0b\x78\x91\x92\x23\x08\xdc\x9e\x5e\xbe"
          "\x79\xd9",
          "\x92\x00\x4a\x49\x7f\x6c\x14\x7e\xa9\x0f\xab\x83\xf4\x20\xbd\x08",
          "\x6a\xbb\xf4\xa7\x43\x9c\x6b\x57\x05\xd4\xc8\x45\xf1\xa6\xb3\x0d\x92\x0d\xb3\x1b\x10\x83"
          "\xce\x58\xce\xe6\x7e\xf1\x7b\xb5\x2f\xe2\x32\x80\xb3\x09\x79\x2d\x75\x57\x3d\x98\x65\x42"
          "\x8d\x15\x8d\xd3\x55\x2a\xfb\x97\xcb\x70\x2b\x39\xb4\x68\x6a\xac\x67\x3b\xd6\x11\xda\xe8"
          "\x8a\xc0\x22\x54\x55\x7d\xc8\x23\xf6\x4c\x3d\xa8\x23\x23\xf0\x23\xb0\x95\xee\x3f\x06\x4d"
          "\x86\x8e\x1f\x9d\x11\xcf\xb2\x0d\x5b\x4c\x5f\xc4\x29\x9b\x97\xad\xe7\xc6\xf0\xf5\x82\xf1"
          "\x35\x31\x63\x2e\xb5\xfa\x1e\xdd\x42\xd1\x03\x83\xdd\x60\xb4\x6b\xb5\x83",
          "\xd7\x5a\x24\xb9\xf6\x36\x28\xac\xc4\xe6\xb3\xa7\xa6\xfa\x77\x5c\x98\xcc\x9f\x59\xb0\x01"
          "\x84\x9f\x7e\xc8\x7c\x27\x3c\xb1\xef\xfe\xd0\x3e\x20\x4d\x60\xab\x35\xdb\xa2\x44\x65\x44"
          "\x00\xf3\x4d\xc7\x07\x82\xb8\xd7\xd5\xd2\xd3\xb7\x72\xc5\x17\xb6\x45\xab\x8a\x85\xcb\xd4"
          "\x22\xd4\xdd\xc5\xd4\x7a\xbc\x74\x3e\x3e\xe7\x2e\x95\x84\x12\xc9\x17\x4f\x2b\x81\x19\xae"
          "\xc8\x1f\x54\x39\x8c\x8e\xa6\x5b\x73\xe2\x21\x72\xab\x2f\xd9\xc8\xab\x00\xc4\x0a\x48\xb6"
          "\xa4\xcc\x08\xe0\x92\xca\x86\x04\xb2\xf9\xcc\x72\xad\xf6\xe1\x81\xfd\x1b",
          1, 1024 },
        { 128, 192, 40,
          "\xdc\x89\x73\xb5\x4a\xf2\x3a\xa6\xcc\x38\x0b\xa6\xb6\x3e\x83\xec\x26\xae\x2e\xa2\xcb\x1c"
          "\x70\x70",
          "\x24\x27\xbf\x76\x39\xaa\x3d\x45\x39\x54\xc1\x29\xd9\xdd\xe9\xa9",
          "\xd1\x90\x01\xc0\xa1\x32\x57\x7b\x83\x89\xc8\xe5\xc2\x04\xe3\xbc\xad\x82\x87\xca\x5d\xb0"
          "\x06\xdb\x7b\x0a\x75\x24\x1f\xfd\x13\x9e\x28\x7b\x5c\x19\xea\x48\x9e\xe7\x43\xc5\x3f\x7d"
          "\xcd\x3e\x84\x69\xad\x26\x03\xb1\x38\x8e\xd2\x6e\x64\x2a\xee\x6b\xf6\xdc\xec\x26\x9d\x1f"
          "\x5b\x36\x7b\xd1\xa8\x79\x31\x10\x66\xda\x40\x8a\x39\x42\x26\xb9\x17\x4a\xfc\x01\x55\x9e"
          "\xe5\x47\x9e\x43\xd0\x02\xea\x37\xdd\xde\xa0\xaa\x65\xf5\xca\xc2\x52\x6b\x33\xc0\x3f\xe0"
          "\xd5\xe7\xbe\x07\xc4\xd1\x98\xdc\xf8\xe4\x86\x46\x0e\xd9\x86\xfd\xd3\x17\x98\xc6\xb2\x00"
          "\x1f\x48\x9c\x87\x93\x09\x85\xf9\x97\xbe\x6a\x6d",
          "\x50\xe9\x29\x38\x01\x59\x8e\xf1\x9e\x49\xcd\xdd\xca\xb1\x42\x59\xb3\x12\xc0\xbb\x0d\xb0"
          "\x24\xcf\x70\x6a\x0b\x1e\x0d\x2f\xd1\x48\x4b\xab\xcd\x60\xff\xc0\xc5\x60\xe6\x77\x24\x14"
          "\x7e\xc0\xa0\xdc\xdf\x94\x74\x7b\xf2\xb1\x2c\x99\xbe\x55\x7b\x14\xf5\x4f\xf0\x7e\xef\x6e"
          "\x5b\xcb\xc2\xae\x67\xf6\x2b\xbc\x35\xbc\xa8\x01\xc2\xa4\x62\xaf\x8e\x7f\xf4\xf2\xd3\xfb"
          "\xc6\xa5\x7c\xe1\xc5\xb3\x69\x86\xfd\xf0\x74\xa5\x92\xb5\x59\xf6\xb1\x4f\x37\x6d\x30\x30"
          "\x81\xc9\xad\x28\x3b\xe4\x6a\x40\xd8\xf3\xbd\x03\x19\xbc\xc8\xe1\xea\x51\xd2\xd0\x34\x1a"
          "\xb7\x8d\x2d\x94\xb7\xb9\x4b\x6d\x72\x34\xd2\x31",
          1, 1152 },
        { 128, 192, 41,
          "\x63\x9a\x60\x1e\xbc\xd1\x67\xb2\x6b\x81\x10\x8c\x4f\x9e\x7f\x60\x2f\x0c\x57\x2a\xca\x88"
          "\x78\x00",
          "\x63\x55\xd7\x3d\x88\xe2\x90\x4f\xc5\xc0\x5e\x69\xbb\xf1\x8e\xa9",
          "\xe4\xdf\x2d\x7f\x48\xd2\xda\x5b\xeb\x2f\x01\x8b\x14\xf0\x03\xa2\x25\xb5\xe5\x97\x8d\xd3"
          "\x27\x4e\x71\xf6\xef\xe5\x8e\x6e\x7b\x88\x4a\x8f\x13\xb7\x74\xd6\xef\xf4\xb2\xdc\x8f\x05"
          "\x2f\xa7\xb7\xd6\x4a\xfc\xa0\x62\x59\x9e\xf4\xd2\x33\x3f\xf4\xb8\x9c\x50\x37\x65\xa9\x6a"
          "\xce\x8f\x16\xe5\x98\x5a\x02\x18\x29\x12\x00\xc0\x9b\x54\x10\x59\xe0\x8a\x0f\xcd\x7f\x5e"
          "\xc6\x2e\xfb\x09\x63\x2d\x4b\x5c\x8a\x70\x00\x76\x99\x2f\x3e\xfe\x32\x79\xdd\x43\x3c\x46"
          "\x85\x0d\x93\x4e\xc5\x35\x6b\xe8\xf7\xe7\x39\x7a\x86\x6c\xa1\x86\xd1\xe7\x64\xa7\xe7\x9e"
          "\x90\x50\xbe\x4f\xb1\x1d\xb3\xe4\x80\xb4\x42\x68\xcc\x62\x85\x37\x26\x71\xfe\x21\x7b\x46"
          "\x91\xe3\xd9\x83\xec\x04",
          "\x8a\xcb\x83\x36\xbf\x75\x14\x2e\xd3\xd0\x33\x57\x9d\x4c\xcb\x24\xc6\xe7\xba\xff\x39\xdb"
          "\x42\x05\xef\xa0\x56\x5a\x80\x09\xd3\xd5\xbe\xde\xa4\xcc\x07\x2b\xfb\x67\xa1\x41\xd4\x5f"
          "\xc7\x58\x3a\x71\x99\xda\x7e\x82\xac\x97\xf7\x89\x58\xa9\x9e\xc6\x1b\xa4\x6d\xbd\x46\x2a"
          "\x25\xd5\x3c\x91\x0c\x3c\x3e\xb1\x93\xc0\xf7\xb6\x7a\x1f\x16\x03\x17\x61\x07\x69\x02\x73"
          "\xb6\x30\xad\x18\xe9\x43\x26\xb0\x95\xfb\xd2\xfc\xc4\x94\xed\xed\xe6\xa6\x78\x2d\xe9\xf7"
          "\x38\x25\xdc\x3d\x48\x21\x0b\x99\x06\xb9\x99\x0a\xf4\xd0\x8b\xf8\xef\x8c\x33\xd0\x28\x2f"
          "\xbb\x5b\xf1\xb3\x65\x77\x8e\xf0\xe7\xa1\x51\xd0\xc8\xd7\x65\xa2\x52\x38\x0d\x0b\x74\xac"
          "\x53\x9d\x99\xe3\x74\xe3",
          1, 1280 },
        { 128, 192, 42,
          "\xa1\x9e\xed\x56\x61\xb4\x2a\x42\xa6\x0e\x40\x38\x60\xe5\x6a\xdc\x27\x06\xbe\x4e\xd3\x23"
          "\xd9\xf0",
          "\xf6\xb0\x0b\x6b\xdf\xf4\xd6\xf8\x8f\xd4\xf4\x34\x02\xb8\x13\x9d",
          "\xef\x6d\xd8\xb7\x26\xa8\x23\xbe\xaf\x93\x30\xac\xcf\x74\x59\x09\xb2\x0f\xf1\x03\xdb\x82"
          "\xf6\x8f\xa2\xc2\x40\x13\x15\x95\x02\x5c\x09\x3e\x4f\x73\x64\xb4\x2e\x88\x2f\x2a\x0b\xd5"
          "\x8c\x0d\xc1\xa0\xb5\x1f\xb1\x65\x27\xc0\xb5\xa1\x56\x6f\xa7\xd4\x61\x2e\xd2\xde\x6e\x20"
          "\xc3\x5e\xec\xee\x60\x62\x76\x22\x86\xf0\x23\x16\xe8\x6b\x60\x98\x7f\x60\xfd\x31\xf3\xf4"
          "\xd0\xca\xa2\x1a\xa8\x5e\xd5\xdf\xe6\xf1\x23\x28\xf8\x7c\xee\x9a\x51\x63\x62\x4a\x87\xb9"
          "\x3c\x08\x2a\xde\xa4\xa1\x6e\x39\x7b\xd1\x55\x52\x44\x95\x86\xf7\x7d\x8f\x89\x4b\x0f\xc7"
          "\x35\x81\x2b\xa4\xd3\x5e\xce\xe4\x82\x45\xb6\xda\xa5\xf0\x54\x62\x90\xa4\xa4\x88\x15\x98"
          "\xed\xb7\xc8\xdb\xc6\x6c\x32\xbe\x4d\xf6\x6e\xfa\x08\x65\x8d\x70\x86\x61\xf9\x81\x75"
          "\xc2",
          "\x7e\xc5\x86\xb4\xb4\x25\x5c\x1e\xf1\x28\x39\x25\x72\xad\x62\x27\x81\xab\xf4\x3e\xd0\x49"
          "\x6f\xe4\xb9\xff\xaa\x32\x5a\xa0\x4a\xcc\x1b\x92\x59\x20\x23\xa8\x52\x6d\xd8\xbe\x77\x31"
          "\xca\x75\xd9\x89\xf1\xce\x15\x85\xab\xf9\xe7\x9b\x39\x27\x41\xd4\xef\x68\xcd\xbd\x87\x72"
          "\x36\x50\x30\x29\xfb\x6d\x29\xf5\xc9\x7f\x3a\x36\xb6\x9c\x0e\xac\xbf\xcc\x9a\x8b\xa9\x34"
          "\x4f\xe1\x32\xd3\x68\x26\x73\xd5\xbb\xfa\xd2\xa3\x47\x4e\xa1\xce\xcf\xba\xb7\xd2\xba\xfd"
          "\x9d\x1e\xba\x7c\x80\x2e\x33\xed\xa4\x33\x7f\x41\x45\x19\x3f\xec\x97\xa9\xa1\xf5\xf7\xaf"
          "\xa5\xae\x53\x93\x88\xa2\xed\x0a\xe1\x20\xc3\xc7\xd5\x3b\x9c\x5b\x64\x4b\x25\x07\x70\x18"
          "\xc8\xd6\xeb\x26\x68\x76\x52\x01\x65\x72\x79\x7c\xcc\x37\xca\x66\x0b\x0b\xf7\x97\x84"
          "\x50",
          1, 1408 },
        { 128, 192, 43,
          "\x94\x75\xae\x60\x0c\xd7\x25\x48\x19\xd6\xed\xc3\x34\xf1\x68\x1b\x6c\xf0\xa7\x8b\xd9\x4d"
          "\x4a\x73",
          "\xdb\xba\x57\x1f\x7f\x19\xf0\xf6\x74\x25\x97\x9a\x1e\x64\xb0\x0b",
          "\x75\xfa\x12\xcb\x43\x84\xbb\x23\xdd\xa8\xf6\xf0\x78\x9b\x7b\x39\x03\x44\xa6\x36\x63\x1f"
          "\xae\x5a\xf7\xee\xc5\xb6\xe7\x7e\x60\x3b\xb4\xd0\x73\x94\x33\x20\x24\x4b\x23\xc1\x54\x01"
          "\xe8\x3f\x35\x8f\x75\xa0\xff\x0b\x52\x89\xc0\x8f\xdc\x3b\x64\x7c\x0f\xf6\x40\x24\x56\x2e"
          "\x6a\x3a\x52\xff\xb5\x98\xda\x5e\xf4\x4d\x89\xda\xbf\xac\xc7\x10\x97\xbf\x8d\x6b\x17\x28"
          "\xd2\xaa\xd7\x71\xaa\x65\x5d\xbb\x73\xe5\x57\xdb\x19\x63\x88\x75\x54\xe7\x75\x89\x5b\xbe"
          "\xbc\xfc\x41\x5d\xdb\xaa\x98\x21\xf8\x4c\x85\xdd\xec\xe5\x78\xa7\xd2\xcc\x28\xef\x68\x7e"
          "\xf1\x4c\x05\x11\xc0\x0c\x2a\x56\xa1\xd4\x12\x9a\x88\x37\x13\x48\xc4\x8a\x04\xf2\xfd\x75"
          "\xc5\x4a\xd8\x4b\xf2\xfe\x07\x0d\xdc\x54\xee\xcb\xd6\x9c\xfa\x85\x4d\xd7\xab\x63\x66\x67"
          "\x66\x2a\xf6\x8c\x82\xe4\x45\xaa\x7d\x2a\xc8\xbd\xfc\xe0\x69\xfb",
          "\x10\x14\x12\x1d\x07\x86\x6c\x4b\x48\xc7\xd9\x58\x66\x6f\x7d\xdd\x43\xe5\x24\x89\xf7\xbe"
          "\x3a\xac\x50\xc8\x48\x0d\x44\x6d\x3d\x05\xf2\xff\x0d\xbc\xd0\x3a\x0d\x34\xad\xfe\xac\x6c"
          "\x6e\x59\x5c\xb5\x45\xe5\x58\x93\x1f\x93\xcf\x4b\x89\x22\xf3\x58\x58\x46\xba\x74\xe3\xcf"
          "\x2c\x4d\x00\xfa\x3f\x41\xa0\xfe\x38\x97\x09\x99\xe7\x94\x13\xa9\xf9\x55\xac\xb4\x3d\xe5"
          "\x7d\x65\x40\xf1\x03\xc2\xe8\x7e\xf1\xcd\x80\x36\x3e\x60\x91\xf7\xd4\x91\x79\x40\x11\xb3"
          "\xd4\x82\x8c\x3e\xee\x98\xf2\xce\xa4\x72\x2d\x96\x4b\xa8\x99\x6b\xa8\xa0\x8a\xef\x20\x9a"
          "\x1c\x2c\xf0\x25\x56\x79\x2c\x89\x32\x6b\x4e\x20\xa8\x5a\xd0\xe3\xca\x8b\xa7\x56\xd3\x38"
          "\xe1\xdd\xf7\x96\x13\xd4\x27\x03\x2b\xa8\x6f\x53\x36\xaa\x5d\x08\xf7\x5d\x51\x1f\x6c\x4f"
          "\xfb\x60\xe3\xcc\x70\x9f\x33\xb5\x3b\x3e\x18\xf2\x34\xc4\x96\xdf",
          1, 1536 },
        { 128, 192, 44,
          "\x31\x85\x9d\xdf\x0b\x15\xcb\x16\xab\x6b\x7d\xb2\x5f\x54\x08\xd5\x28\xc3\x42\x06\x80\x49"
          "\xd6\x1c",
          "\x31\xa3\x4d\x3a\x9f\x97\x71\xee\xad\x75\xce\x3d\xba\xf0\xdb\xbf",
          "\x93\xe0\x74\xb6\x03\x5d\xbd\x70\x2a\x65\x21\x11\xfc\x15\x74\xb9\xd9\x0e\xed\x19\x6c\xcc"
          "\x7b\x5d\x67\xc8\x38\x0f\x92\xe9\x0f\x8c\x26\x28\xc5\xd3\x95\x1d\x33\xa1\xfd\x9d\x2f\xc7"
          "\x26\xb3\x8e\x10\x02\x88\x9e\x7a\xb1\x33\x9f\x96\x68\xdd\x7a\xb4\x92\xa0\xfe\x2f\xb4\x1f"
          "\x5f\xa4\xb2\xe6\x48\x0c\xe4\x0c\xc7\xef\x44\xa0\x3e\x8d\xaa\xef\xb8\xa1\x98\x05\x14\x14"
          "\xf7\x69\x24\x6a\x7c\x19\xbb\xe0\xf1\xdc\x92\x86\xa3\x58\x84\x31\x68\xed\x5c\x92\xd5\x22"
          "\x94\xd7\x5f\x44\xc6\x5c\x01\x73\xd3\x87\x48\xa5\xb2\xec\xfb\x70\x53\x04\x05\xb5\x39\xed"
          "\xdc\x4b\x6b\xfd\xae\xdb\x48\x5e\xda\xbf\x24\x62\xe0\x51\xd3\xe9\x3a\xa7\xa7\xd8\x93\x9b"
          "\xd7\xf7\x5e\xfa\x78\xd8\x69\x1a\x84\x91\x31\x91\xae\x16\x23\x59\xc9\x79\x33\x30\xd3\x35"
          "\xe1\x41\x10\xb6\xa0\x34\xc3\xe4\xa1\x7f\x68\xf8\x95\x34\xcc\x47\xbd\xc7\xd1\x7c\x52\x70"
          "\x48\xb7\x48\x57\x9b\x18\xf2\x31\x02\xfe",
          "\xd7\x16\xc7\x96\x51\x64\x72\x45\xb7\x1f\x20\x7b\xef\x03\xcb\x67\x60\x20\x36\x2b\xe4\xf8"
          "\x9b\x42\xb3\x4e\x43\x93\x64\x61\x10\x48\x68\xda\x09\x38\x7b\x5d\xfb\xdc\x57\x9c\xa2\x46"
          "\x40\x4b\x41\x59\x0e\x4e\x61\xfc\xd6\x30\xa8\x25\x9f\x5d\xcc\x9b\x13\xc7\x59\xea\x96\x7a"
          "\xf1\xe4\x16\xc7\x0f\xc4\xe3\x28\xbf\x67\x0e\x61\x05\x98\x98\xf2\x2f\x2f\xed\x73\x60\x46"
          "\xa1\x9e\x12\x62\xa3\x29\x94\x00\xe8\x4d\x28\x22\x02\xca\xc0\xeb\x07\xc7\x1f\xd0\x8d\xe4"
          "\xbb\xc1\xef\x7d\xd5\x67\xcd\x8d\x6a\xbd\x98\xd7\x35\x34\x0a\xaf\x66\x1f\x77\x0d\x87\xc7"
          "\xed\xaa\xb5\xcf\x3a\xc2\x88\xdb\xd9\x24\xde\xa6\xe8\x1e\x2f\x57\x82\x41\xe7\x37\x58\xd2"
          "\xb3\x46\x41\x03\x73\xc0\xbd\x74\xc0\x80\x47\xe1\xcb\x32\x84\x4c\x26\xd3\x68\x05\x8f\x2c"
          "\x7d\x3f\x1a\x67\xb0\x69\x62\x0a\xaf\x3c\x0c\xb6\x7d\x14\x9f\x32\x56\x81\x07\x8d\x76\x0b"
          "\xa5\x94\xc5\xaf\x7f\x05\xb3\x75\xf9\xea",
          1, 1664 },
        { 128, 192, 45,
          "\xbc\xd5\xf4\x66\x84\xb4\x55\xbb\x9a\x26\x4a\x52\x11\xc4\xcb\xce\xc9\xe2\x27\x0d\x31\x77"
          "\xec\x9a",
          "\xf7\x67\x4e\xe1\x76\x51\x76\xf8\x8b\xc5\x3b\x71\x10\x70\x31\xec",
          "\x3b\xf9\x29\x28\x93\x16\x2b\xfc\x8c\x9b\xe5\x7b\x6d\x7c\x1a\xde\x97\xf7\x50\x98\x06\xf6"
          "\xd3\x0f\xf0\xdc\x53\xec\x87\xd0\xc0\xbe\xeb\xaa\x4b\x0e\x06\x90\x5e\xfa\x62\x39\x86\x40"
          "\x51\x17\x35\x32\x08\x43\x85\x88\x3d\x16\x77\x61\xb4\x43\x31\xaa\x13\x47\xd9\xde\x39\xf1"
          "\xc2\x9f\xe0\xc8\x95\xa9\xdd\x5e\x5d\x4d\x7f\x33\x1f\xeb\xfb\xab\x33\x1f\x92\x9b\xd9\x6d"
          "\xd4\x67\x86\x32\x5a\x3c\x0d\x06\x60\xa9\xab\xde\x7c\xc9\x3d\xca\xa5\xbd\x15\x5f\x6a\x56"
          "\x33\x1d\xf4\x0a\x38\x16\x34\x5a\x8d\xfd\x5e\xed\xc7\xeb\x8b\xd8\xc4\x86\xe1\x65\x44\xd6"
          "\x61\x38\x82\x56\x20\x3b\xbf\x24\xae\x71\x74\x94\xf2\x09\xfb\xe6\xb5\x69\xa0\x02\x38\x96"
          "\x8f\xa7\x6d\x43\xf0\x58\xc4\x29\xb5\xed\xd4\xf9\x0f\xfc\x23\x01\xbf\xdc\xf0\x65\xc2\xa2"
          "\x4a\xd0\x20\xc6\x81\xe6\x12\x6a\xd7\x5f\x0f\xc8\xda\xfe\x95\xa9\x35\xf4\xc9\xa7\x68\x2a"
          "\xb4\x90\xe7\x66\x6b\xf7\x89\x88\xe1\x07\x1c\x89\x4e\x94\x60\x80\x4a\x73\xd6\xb6\x30\x5f"
          "\xe9\x5f\xf2\x70",
          "\xd4\x23\x1f\xf6\xd4\x5e\xed\x70\x0c\x50\x92\x8a\x4c\x40\x6e\x18\x0a\xe0\x61\x52\x45\x3c"
          "\x2b\x22\x6b\x1c\x68\xf7\xa0\xd7\x3a\x8e\xd2\xdd\x37\x11\x86\xac\x39\x93\xb1\xa0\x8a\x42"
          "\x92\xcc\xd1\x24\x8b\xa6\x11\x1c\x4c\xd4\x06\x3b\xc7\x80\xb7\x50\x7e\x11\x7e\x12\x58\x01"
          "\x5c\x13\xc3\xc6\x15\xa3\xff\xda\xc2\x73\xe4\x02\xab\x2d\x42\x5d\xa2\x54\x89\x7e\x11\xe5"
          "\x1e\xb1\x7e\xaa\x96\xe3\x98\x06\xc9\xd4\x2b\xd7\x0d\x3e\x2a\xf4\x41\x14\x54\x63\xae\x1f"
          "\x1d\x35\xa1\x67\xdf\xc9\xd1\x0a\x0c\x17\x9b\xe9\x51\xa1\x08\x63\x85\x7f\xf3\xe9\xe2\xbd"
          "\x40\xef\x7b\x1e\xb1\x8a\x6c\x9a\xd4\xaa\xe0\xb0\xa8\x48\xa4\xb1\x7d\xf3\xe9\x6b\x0b\x86"
          "\xa5\xc4\x77\xae\xe2\x46\x7c\xe3\x7c\xe1\x0b\xcf\xff\xc7\x0c\x0d\x19\x5f\x4c\xe6\x76\x22"
          "\xe5\xb1\xbc\xec\x38\xac\x47\x66\x06\xcf\x7f\x22\xd7\x01\x1c\x6c\x15\x0f\x18\x9a\x45\x2b"
          "\xeb\x9c\x79\x66\x74\x71\xc4\xe0\x6d\x36\x48\xbd\xb7\xeb\x9c\xff\xdd\x97\xe9\x4d\xb3\xfa"
          "\x67\x3a\xfe\x76",
          1, 1792 },
        { 128, 192, 46,
          "\xaa\xf0\x3c\x89\x11\x4a\xbc\xf9\x8f\x28\x01\x05\x05\xa1\x3d\xd3\xab\x17\xcf\x06\x19\xa6"
          "\xfc\x7a",
          "\xf1\xee\xb3\x56\xa9\x3e\x3a\xf1\xdc\xd8\x24\xdb\x9a\x61\x61\x0f",
          "\xe0\xb1\x53\xd8\x4c\xda\x61\x3e\xa4\x1a\x0d\x18\x5e\x98\x92\x29\x61\x17\x39\x03\x40\x74"
          "\xc3\xaa\x53\x98\x94\x32\x70\x6a\x14\x0a\x2d\x1e\x58\xe4\x51\x9e\xf1\xa2\xdb\x39\x99\x76"
          "\x60\x57\xe2\x1b\xc4\x4d\x8a\x5c\x79\x01\x78\x9e\xbb\xe8\xed\x4c\xdb\x02\x71\xd5\x76\x60"
          "\x38\xe7\xe1\xb9\xc3\xe6\x26\xe1\xfc\x91\x6e\x25\x0b\x1d\x9d\xe6\x99\x11\x20\x9b\x5b\x9a"
          "\x22\xf1\xf3\x1f\x45\x90\x98\xd5\x33\x6c\xa3\x01\xd1\x37\x29\xde\xae\x5c\x4b\x65\xf3\x85"
          "\x05\x23\x92\x6f\xd9\xff\xcf\xf9\x0b\x37\x9b\xd9\xb8\x0a\xf1\x70\x0a\xfc\x4d\xbc\x1d\x81"
          "\x5c\x39\x81\xa4\x20\x01\x4e\x24\x8e\x72\x10\xb0\xd3\xf8\x3f\x6f\x25\x59\x6d\xc3\xa9\x41"
          "\x17\x34\x5d\x9f\x3f\x42\xf9\xb1\x12\x14\xf1\xb2\x1a\x51\xa7\x3d\x85\x40\x77\x65\x47\x1c"
          "\x32\xfb\x4b\x2e\x8e\xcc\x0f\x90\xe2\x09\xd3\xaf\x27\x2d\xef\x80\x6c\xd1\x50\x94\xf0\x77"
          "\x7a\x6b\x25\xbf\x91\xec\x6a\x7e\x74\x47\x51\x03\x69\x96\x2f\x92\xbd\x19\x54\x86\x7d\xe0"
          "\x65\x85\xc8\xcc\x74\x7f\xd1\xf1\x37\xd3\xd3\xb0\xb8\x8c\xeb\xab\x13\x62\x46\xa1",
          "\x6a\xf9\x41\x07\x85\x25\x26\x94\x96\x8b\xd7\x95\x22\xd7\xe5\x62\x72\x77\xdc\xa4\xb6\xfc"
          "\x2c\x31\x8a\x89\x53\x6a\x89\xb2\x9f\x21\x89\x2f\x3f\x43\x60\x1c\x81\xe9\x76\x8f\x86\x9c"
          "\xc8\x45\xe1\x13\x67\x32\x6a\x1e\xb5\x3f\xc4\xfd\xec\x88\xd7\x31\x0e\xd5\x11\x91\x00\x13"
          "\x9d\x39\x06\x3e\x23\xe9\xaf\x7e\xec\xef\x3b\x2f\x74\xf7\x75\x33\x9d\xfa\x80\xdf\xbf\xba"
          "\x69\xf6\x41\x54\xc7\xf6\x51\xc2\xfd\xfd\x12\x6e\xc7\x14\x8d\xa5\x19\xc9\x85\xd0\xd9\x69"
          "\x4d\x08\xcf\x6a\xef\xf8\x25\x8e\xfd\xf1\xb1\x1c\xda\x7c\xc2\x28\x9f\xa0\xc5\x27\xf6\xe5"
          "\x75\x21\x51\x47\xa1\xb7\xaf\xf5\x60\xf8\x7b\xa2\x44\xc0\x89\xd3\xd1\x62\x47\x93\x83\x88"
          "\xc4\x06\x60\xc7\xfa\xb5\xb7\x4c\xe7\x43\x78\x84\xc9\x49\x4f\x21\x5b\x1e\x81\xb0\x1b\xfe"
          "\xa4\x6f\x99\xe7\x2d\xce\x44\x15\x47\x26\x23\x62\xac\xbe\xf0\xba\x2a\x40\xf1\x18\x20\x22"
          "\x35\x39\xab\x76\x59\x59\x6e\x64\x68\x3a\x49\xfa\x9f\x00\x8b\x00\x31\x95\x2b\x83\x4a\x17"
          "\x85\xca\xfa\x3b\xac\xc3\xd5\xf2\xd8\x18\xa3\x81\xcb\xc9\x61\x8e\x10\x26\xb3\xd6",
          1, 1920 },
        { 128, 192, 47,
          "\x42\xa5\xa5\xe3\x87\xcc\x88\xaf\xe4\xd7\xc5\xec\xbf\xc6\xa6\x0b\x07\x00\xe2\xaa\x73\x86"
          "\x6f\x6c",
          "\xe1\x4d\x37\xe4\xdc\x49\x83\xd8\x37\xca\xfc\xa0\x17\x01\xfb\x1d",
          "\xfd\xe5\x7d\xe9\x1a\x06\xe6\x33\x4f\x11\x84\x7c\x88\x71\xf5\x40\x1f\x33\x14\x29\xdd\x54"
          "\xd9\x93\xdc\x96\x36\xad\xef\x37\x82\x1a\xce\xad\xca\xe0\x60\x51\x5d\xb7\x3c\xac\x1b\xd2"
          "\x9e\xf7\xca\x8d\xe5\xd1\xd0\x4d\x0a\x5a\x64\x22\xd5\x8d\xaf\x6a\xf1\x29\xda\x2b\xbb\xc2"
          "\x9f\x13\xc5\xc2\x71\xcf\x0e\x55\xdb\xee\x67\x44\xa8\x35\x89\x8a\x60\x6b\x19\xe5\x35\x95"
          "\x41\x30\x6f\x44\x7e\x69\xe4\xef\xf4\xe3\xe3\xc7\x7a\xcc\x8b\x2c\x39\x7c\x29\xad\x13\x6b"
          "\x44\x9a\xc3\xb3\x43\x08\x61\xb6\x09\x1f\x74\xb8\xb9\x83\xfd\xd1\x81\x95\x04\x61\xbc\xa6"
          "\xf6\xc6\x8b\x4b\x59\x4c\x90\x17\xf7\x42\x71\x42\x06\x49\x99\x3b\x09\x45\x23\x00\x38\x05"
          "\xbf\x6a\x0b\x60\xaf\x79\x3c\x8e\x9b\xf5\x52\x71\x61\x1a\x25\xe9\xb4\xed\x6a\x0b\x3b\x34"
          "\x59\x0e\xb7\x72\x39\x5d\x35\xc2\x3a\x47\xda\x93\xd5\x5a\x32\x2e\x85\xe7\x8c\xd6\x42\xbf"
          "\x69\xc8\x8b\x8a\x0d\x08\x5a\xc7\xd5\x2f\x0f\xa3\xe2\x0f\x3d\xa5\x5d\x1f\x78\x92\x4f\xe5"
          "\xfe\xe9\xb8\xe2\xee\x8a\xd7\x49\xaf\x56\xa1\xd6\xcb\xe0\x3b\xed\x0a\xaf\xa2\x08\xe7\x41"
          "\x95\x2e\x39\x42\xb5\x02\xe4\x86\x70\x59\x53\x7b\x4c\xc5",
          "\x9b\xfe\x52\xe4\xe8\xc7\x73\x13\x86\x72\x92\x26\x64\x1b\x69\xd7\x4f\xb0\x43\xde\x9e\xa6"
          "\xc6\xda\x68\x33\xe0\x45\x8d\x95\xeb\xce\x41\xac\x9c\xbd\x8b\x38\x1d\x12\x7c\x7f\x20\x5c"
          "\x06\x56\x78\x08\x8d\x25\x94\x80\x70\x21\x3a\xf1\x97\x24\xe6\x22\xfe\x92\x6f\xd2\x9d\xae"
          "\x5e\x70\x50\xc2\xb7\xbf\x5d\x19\x13\x24\xae\xa2\x9a\xdb\x3b\x9a\x05\x8c\xb7\x39\x2c\x3e"
          "\xed\xa0\xa8\x00\x51\x29\x81\x88\xe9\xc7\x15\x29\xf9\x6b\xef\x67\xc5\x4e\xdc\xc6\x97\xcf"
          "\x36\xbf\x97\x9e\x56\xeb\x5a\x52\xfe\xe8\x44\x82\x73\x19\xf4\xdd\x4a\x8a\x3e\x53\x80\xa7"
          "\x96\x59\x8c\xe9\xcd\x80\x1c\xc5\x57\x29\xfa\xfb\x34\x87\x05\x05\xb7\xe3\x2c\x6f\x29\xa8"
          "\xd2\x53\x3d\x87\x12\xac\xd9\x8e\x24\x93\xec\x56\xc8\xdd\x32\x51\x51\xa3\x76\x92\x9b\x94"
          "\xff\xf1\x6c\x71\xff\x95\x0c\xd4\x12\x7c\x6a\x65\xd9\x5c\x7d\x86\x75\xe6\xa6\xa6\x7f\x8b"
          "\x1e\x9a\x83\x38\x00\x20\x27\x90\x15\xf7\x85\x60\x79\x2a\xba\x89\xea\x9c\x84\x0f\xe5\x5c"
          "\x2a\xb4\x36\x4e\x58\x1f\x24\x03\x66\xf1\xdc\x10\x45\xd6\x25\x26\x38\xe2\x0b\x48\xee\x62"
          "\xf4\x19\xd3\xd1\x65\x23\x21\x13\xec\xbe\x13\x48\x25\x41",
          1, 2048 },
        { 128, 192, 48,
          "\x9b\x0d\x1f\x04\x79\x3d\x47\x8c\x55\xd4\xa7\xc1\x99\x12\x83\x90\xab\xf0\x6d\xdb\x84\xcd"
          "\x88\x28",
          "\xa9\xfe\xc0\xcc\x2f\xe3\x04\xe8\x21\x31\x4c\x92\x4c\xc5\x70\xfe",
          "\x8a\x07\x3d\xf6\x1e\xdf\x34\x2f\x97\x44\x28\x47\xf8\xec\x37\x2b\x6d\x9d\xf9\xd6\x1a\xdf"
          "\x45\x07\x82\x9c\x7f\x26\xbd\x91\x38\xd8\xbd\xa7\xae\xcc\xe0\x05\x53\x86\x14\x13\x0e\xb3"
          "\x4d\x6e\x72\x2f\x74\x60\x06\x5a\xf3\xb5\x7e\x84\xe7\x97\x85\xb9\xf6\x5d\x8d\x7f\x19\xc6"
          "\x13\x6d\x93\xe2\x97\x04\x1f\x91\x24\x2b\x86\xbe\x96\x12\x9c\xaf\x0c\xd1\x3b\x64\x65\x99"
          "\x9c\x07\x6f\x91\x3f\xc7\x8a\x83\xa8\xd9\xb5\xe3\x5a\x36\x5d\xae\x96\x5c\x19\x9a\xb5\xc7"
          "\x49\x3a\x38\x46\xd3\x56\xf7\x26\xe6\x59\xaf\xd0\x5c\xa5\xfa\x10\xb9\x4d\xb5\x27\xe2\x55"
          "\xea\xed\xff\xd2\x41\x3c\x7f\xf3\x93\x53\xea\x47\x98\x69\xe0\x12\x87\xd3\x02\x30\x57\xfd"
          "\xa4\x98\x9c\x0b\x83\xf8\xf3\x7a\x58\x21\x53\xd6\x88\xc2\x4d\x1e\x33\xa1\xed\x7c\xe6\xa0"
          "\xd3\xa4\x8b\xcd\x7e\x78\xc8\x1e\x54\x5c\xfc\xef\x7c\x0f\xb9\x78\xff\xd4\x36\xed\x78\x1e"
          "\xfc\x8e\x12\x1d\xdd\xbd\xe7\x56\xce\x2c\x15\xac\xaa\x0c\xf1\x57\x7a\x23\xa0\xbf\xe8\xc7"
          "\xe9\xcd\x2d\x67\xe8\x1b\x87\xe4\x65\xf3\xf8\x1e\xdd\x8c\xbc\xac\x0d\x60\xfd\x66\x15\x7a"
          "\x7a\xde\x58\x10\xa7\xf0\xd9\x5c\x64\x84\x8a\x5e\x16\xd7\x46\x5a\xd2\x40\x39\x60\x81\xd0"
          "\xea\xc9\xe8\x96\xc7\x17\x76\x6c",
          "\x16\x6c\xd8\x67\x53\x44\x14\x8a\x26\xbb\xdd\x69\xc1\xee\x10\x53\x18\xb8\xf2\x34\xa4\x40"
          "\xbe\x3b\x27\x0b\x4f\x2c\x48\x40\x70\xb5\x8a\x9a\xa0\x16\x17\x14\xc8\x58\x8e\xe6\x9c\xe2"
          "\x1f\x85\x0a\x7f\x45\xbc\x89\x7f\xbe\x1c\x2a\xd6\x35\x31\x68\x5e\xff\x59\xa2\x8f\xe2\x14"
          "\xf3\x98\xb8\x9b\xac\x25\x61\xd2\xf7\xc5\x46\x41\x69\xa2\xb4\xb0\xaf\x11\x67\x5f\xa3\xf7"
          "\x07\x4f\x18\xa1\x8f\xd8\xcc\x2d\x27\x01\xa9\x2e\xc6\x70\x88\x8c\x85\xfb\x65\x88\xdb\xf7"
          "\xfe\x03\xb9\x14\xa8\xdc\x7d\x9f\x00\xe7\x7b\x6b\xd3\x9d\x12\xf7\x0c\x3c\x13\xbc\x03\x0e"
          "\x98\xfc\x87\x10\xd0\xe1\x19\xff\xb2\x5a\xca\xd6\xef\xd6\x9c\xf7\x10\x48\xdc\xa2\xbd\x8e"
          "\xad\x3b\x3a\x39\x4e\xd7\x77\xfd\x93\x92\xf6\x08\x1d\x5c\x25\xe7\x91\xca\x62\x76\x0b\xc6"
          "\xe3\x5a\x04\x6b\x77\x5f\x20\xe4\xc5\x61\xc4\x6d\x6c\x9b\x13\x7b\x1e\x0d\xd9\xa5\xba\xb8"
          "\xbc\xd6\x96\x93\x5a\x51\xbb\x8b\x74\x9f\xf2\xe6\x66\xda\x6a\x13\x57\x16\x3f\x39\xfd\x01"
          "\x2e\xf5\x80\x6f\xf5\x69\xf9\xe8\xa9\x66\x2b\x2f\x4b\x93\x76\x97\x99\x1e\x53\x9e\x46\xde"
          "\xbc\x98\x41\x2c\xe3\xc0\x2f\x96\x08\xba\x35\x54\x5f\x9c\x07\x4e\x9c\x65\xcb\xd7\x85\x29"
          "\x88\xc7\xe7\xac\xdd\xe0\xe7\x32",
          1, 2176 },
        { 128, 192, 49,
          "\xc2\xac\xc9\x22\x9a\x73\xa4\x03\x2d\x4b\x22\x1f\x97\x80\xb8\xa9\x4c\x36\x9e\x35\x4f\xf2"
          "\x74\xf0",
          "\x94\x0e\x36\xf9\x03\x87\xbf\x86\xba\xc8\x1e\xde\x54\x91\xfb\x9a",
          "\x48\x51\x2e\x2a\x58\x59\x47\x87\xc8\x34\x5b\xf2\xd0\xf7\x70\xaa\x8f\xa5\xf2\xf1\xb7\x70"
          "\xa1\x0b\xb0\x9b\x91\x74\x53\x14\x8d\x5c\x53\x47\x2a\x4b\xf1\x92\x7d\xd3\x24\xa8\xcc\xa5"
          "\x44\xc8\x53\x04\x41\x53\x45\x67\x53\xad\x21\x8b\xb6\x68\xe8\x65\xe3\xa7\x14\x64\xd6\x89"
          "\x2f\x95\x30\xc6\x74\xcd\xa9\xbf\x81\xb9\xa2\x91\xbb\x73\x51\xe6\xb9\x5c\x7e\x6d\xa6\xa8"
          "\xf5\x6a\x56\x3a\xbc\x89\x7c\xf9\x08\xad\xd5\xad\xf9\x34\x09\xb9\x11\x33\x31\x1f\xa0\xa6"
          "\x7f\x1a\x78\x46\xbf\x66\x32\x64\x40\x5d\x0d\x0b\xdf\x41\x5f\x3d\xf6\x4e\x34\xea\x77\xcf"
          "\x93\x4e\x06\x9c\x21\x1a\xb2\x39\x2a\xc7\x04\xf7\x57\x3f\x0b\x62\xcb\xd0\xba\x4f\x32\x9d"
          "\xd4\x66\xf9\xab\xf7\x52\x7a\xac\x9b\xf7\x97\x7f\xf7\xf9\x18\xe2\x7e\x78\x04\xa0\x2f\x3b"
          "\x3d\x9f\x75\x3d\x36\x68\x0a\x26\x05\x3f\x07\x10\x5b\xf2\xb4\x44\x2d\x09\xe5\x73\x5d\x86"
          "\xf4\xd4\x94\x6f\xdb\x29\xd7\x5a\x4f\x73\x5e\x83\x8a\xd0\x31\x55\x69\x8e\xdd\x1e\x82\x03"
          "\xed\xb3\xb5\x65\xca\xc5\x6d\x97\x52\xf0\x3a\xf5\x0c\xc1\xd7\x3e\x9a\x28\xc5\x6a\x41\x90"
          "\xd3\x32\xf6\x76\xf8\x8a\x94\x44\x5f\x1b\xee\x18\x22\x71\xc3\x86\x0b\xe6\xa9\xb2\x43\x5f"
          "\x8f\x68\x28\x58\x52\xa6\x89\x70\xc1\x1d\x1f\xb0\xbb\x6d\x1e\xce\x4b\xc4\x3d\x0a\x67\x65"
          "\x09\x8d",
          "\xe7\xd5\x7d\xf5\x4a\x97\x53\xb9\x5b\x64\xeb\xac\x46\x44\x17\x53\x23\x0c\x1d\xd7\x48\x92"
          "\xe2\xc7\x3b\x89\x48\x82\x59\x66\x01\x30\x53\x4b\x81\x0f\xc3\xe4\x70\x26\xf6\x6f\x43\xb4"
          "\x33\x82\x51\x74\x78\xb6\x96\x95\x1b\x87\x4e\xa0\x5f\x1a\x2b\x18\x92\xae\xd3\xdf\x25\xc7"
          "\x1c\x97\x62\x55\xf2\xd9\x51\x80\x45\x8f\xc6\x10\xc2\x47\x63\x88\xe7\x5f\x04\x81\xc9\xd8"
          "\xd4\xc2\x90\x84\x67\x7d\x42\xa2\xc1\x64\xcb\x2c\xf9\x44\x47\x94\xaa\x6a\x6e\x1c\x8b\x12"
          "\x08\x49\x43\x12\x9e\x44\xfc\x39\xcd\x6f\xe3\x35\xfc\x61\xa3\xd9\x03\x74\x2b\x5b\x1c\x20"
          "\x76\x52\xda\x08\x50\x32\x92\xc6\xf9\x43\x79\x15\xf7\x5f\xa5\xe8\x04\xcb\xe8\x79\x92\xa6"
          "\x2f\x93\xea\x63\x32\x60\x6a\x44\x3b\x20\x25\x7a\x93\xd1\x11\xe3\xe2\xbf\x2c\x65\x75\xf3"
          "\x65\x82\xc9\x97\x75\xce\xd6\xa3\x44\x64\xbe\xd6\x45\xa3\xe5\xc3\x93\xcf\x13\x84\xf0\xac"
          "\x0b\x45\x22\x3f\x9f\x26\x2b\xa5\x8a\x24\x6e\xf4\x44\xeb\x2b\x62\x93\xd8\x05\x73\xe7\xac"
          "\xbf\x2b\x8b\x81\xb1\x8f\x1f\x75\x28\xd9\x22\x02\x3e\x05\x3c\xf7\x13\x56\xc1\x15\xe2\xad"
          "\x84\x57\x94\x2d\x6f\x76\xbb\x4d\x92\x5f\x01\x26\x72\x44\x2d\xd1\x9e\x8f\x95\x78\x07\xd8"
          "\x21\x3b\xfd\x56\x56\x73\xca\x84\x1a\xb5\xac\x7f\xa0\xf1\x10\x00\x3a\x1f\x32\x10\x0e\xec"
          "\x12\x38",
          1, 2304 },
        { 128, 192, 50,
          "\x57\x51\xdb\xc6\x9f\x32\xd8\xfa\xf6\x67\xe7\xdc\x5c\x2c\xe0\x54\x33\x77\x89\x44\xaf\xfd"
          "\x26\xb5",
          "\x27\x4c\xa3\x4a\xa7\x58\x45\x8d\x3e\x50\xc3\x89\xce\xe8\x1d\x78",
          "\x42\xa5\x0b\xfd\x64\x11\x66\xf8\x6d\x84\xfa\x1f\x18\x00\x1d\xac\x19\xfd\xd0\xf5\xa4\x71"
          "\x09\xb7\xdd\x4e\xb5\x0a\x7a\xb9\x83\xe7\x57\x02\xda\xd7\x4e\xcf\x04\xed\xd5\x44\xa7\x54"
          "\xe0\x5e\x03\xb8\xfe\xb3\x9a\xa5\xc6\xda\x99\x30\x38\xa2\x7a\xf4\x24\x1d\x30\x54\xe8\xa2"
          "\x0f\xbb\xb1\x32\xf2\x7f\x2b\xaa\x8a\xb8\x24\x01\xd2\xf7\x39\x54\x92\xfd\xc6\x69\x67\xd9"
          "\x9c\x45\xc4\x35\x21\x84\xa9\xe7\xfa\x64\x46\x6e\xe0\xad\x48\x69\x52\x74\xb9\xf8\xdb\x84"
          "\x18\xe4\xf8\x8c\xcc\x96\x19\x71\x57\x64\xcc\x14\x32\x3e\x23\x99\xc8\x2a\xa8\xf5\x18\xda"
          "\x0d\x3b\xf1\xa0\xf8\xa5\x98\x46\x07\xac\xb9\x7b\xa6\x8e\xaf\x9b\x85\x0e\xb1\xa1\x5d\x4c"
          "\xbb\xf4\x8b\x91\x47\x3f\xf7\x2c\xa2\x83\x15\x63\x28\x08\x15\xa5\x2b\x37\x0b\x23\xae\xe0"
          "\x28\x7e\xfc\x57\xb4\x31\x01\xe7\x9c\x8e\x46\x18\xe9\xca\x7a\x20\xe8\x25\x8e\x65\x05\x25"
          "\x9f\x5a\x14\xef\xf4\xfc\x2a\x50\x10\xa1\x89\x71\x84\x2b\x21\x6a\xba\x4a\x6c\xaf\x38\x48"
          "\x41\x11\x2e\x60\x6f\xb6\x16\x27\x92\x63\x33\x68\xa0\x3e\xd7\xf5\x22\x29\x49\x9f\xfb\xc1"
          "\x9a\xe1\x29\xfa\xc9\x3c\xf2\xb6\x58\x00\xc1\x60\xdd\x1a\x69\xb3\x93\x89\xee\xbb\x65\x6f"
          "\x76\x43\x75\x92\xf7\xa1\xb3\xc8\x8b\xc9\x49\x86\x0c\xaf\x04\xbd\xdf\x23\xab\x30\xb1\x81"
          "\x1b\x3e\x4f\x40\xb8\x67\x22\x93\xdb\x1d\xb2\x97\xa4\xb2\x3c\x6d\xf3\x3f",
          "\xa4\x11\x10\x83\xc9\x4f\x4e\xc7\x59\xab\xc5\xfb\xd5\x40\x43\x6f\xed\x82\xb3\xe3\xbf\x89"
          "\xb3\x28\x97\x1c\x0e\x96\xd7\xa6\x43\x7e\x9e\x06\x77\xe5\xe0\xe3\xfe\x45\x36\xc4\xc1\xd0"
          "\x5a\x2a\x32\x84\xc2\x40\xd3\x15\x5c\xac\x5f\xcc\x3d\xc9\x30\xf4\x2d\xb0\xa2\x1e\x20\xce"
          "\xc6\x12\xbc\xdf\x41\x85\xfa\x63\xde\x48\x56\xfc\xb9\x28\xef\x2b\x3a\xb1\xc4\x32\xaf\x3f"
          "\x88\x7f\xdc\xac\xdc\x5c\xe2\xaf\x73\x3b\x5c\x26\x38\x8e\xe4\x04\x9f\x91\xc1\xf3\x8e\x7e"
          "\xed\xd3\x1b\x89\xf5\xc6\xed\xcc\x4f\xf3\x4c\x55\x4a\x90\xa0\x7d\x75\x4a\x3b\xed\xa8\x42"
          "\x3a\x60\x66\xc9\xe4\xa5\x90\x09\xc1\x6b\xb7\x65\x4f\x0d\x38\x29\x83\x79\xa1\x88\x29\x64"
          "\x7a\x0f\x73\x34\x59\x96\xb4\x04\x10\x30\x11\x80\x06\x41\xed\xbe\x40\x87\xc6\x0a\x27\xda"
          "\xf4\xe9\x9c\x11\xda\x90\xab\x24\x74\x01\x68\xef\x0e\x84\xad\x4c\xbc\x1d\xae\xdf\x62\x29"
          "\x39\x78\xdd\xa7\x76\xff\x94\xf8\x57\xf3\x4b\x03\xaa\xd1\xdf\xdc\x63\xf6\x5a\xc2\x14\xba"
          "\x40\xcd\x42\x4d\x25\x05\xcb\xbc\x0a\x05\x21\xb1\x21\xdc\x50\xb4\x50\x78\x4e\xc2\x61\xfa"
          "\xad\xb4\x03\x6f\xce\x8b\x6c\x60\x74\x90\x31\x48\xf4\x74\xaa\x30\x4f\x9d\xf9\x65\xa6\x06"
          "\x51\x8e\xd1\x5a\x92\xd8\x2b\x2e\xe0\xb2\xfd\xc3\x33\x2e\xa0\xbe\x9f\xbb\x5f\xde\xdb\xf1"
          "\x77\x9c\xc3\xcb\xa0\x8c\x04\x85\x5a\x7f\x8b\x4b\x20\xfa\x1c\x3c\x99\x0a",
          1, 2432 },
        { 128, 192, 51,
          "\x4c\x0d\xd5\x77\x4b\xe9\xa6\x9d\x1d\x5f\x42\x2f\xff\x26\x4d\x40\x5d\x74\xe2\xf7\x02\xae"
          "\x0b\xa0",
          "\xf8\x75\x32\x35\x5c\x29\xf7\x65\x77\x2b\xb3\x62\x08\x4a\xaa\x51",
          "\x10\x8a\xde\x62\x63\xb5\x23\x4c\xa5\xd3\xf5\xfc\xa8\xf5\xca\x94\x7d\x1f\x7e\x6a\x16\xae"
          "\xe0\x39\xba\x16\x53\x3c\x44\x48\xe0\x31\x5c\xd5\xd2\x8d\xde\x30\x19\xcb\xd6\xeb\xcb\xb2"
          "\x27\x93\xef\xb6\xcf\x31\x5b\xf2\x1c\x3f\x84\xb6\x44\x0e\x53\x5b\xc3\x57\x6c\x57\x5a\xf9"
          "\xa1\x1c\x96\xe3\x8a\x2d\xf7\x89\x41\xd6\xe5\xdd\x2e\xe6\xf2\xe4\x28\x5a\x30\xeb\xda\x22"
          "\x85\x85\x95\xd0\x2d\x7b\x42\x02\xf9\x69\x86\xe3\x80\x43\x67\x95\x22\xa3\xee\x7c\x5b\xc3"
          "\x40\x7f\x98\x54\x28\x5e\x1d\x89\xa3\x0f\xaa\xfb\xd5\xec\x18\x47\x2f\x5d\x00\x40\xdd\x60"
          "\x7e\x75\x18\xa8\xbe\x3f\x37\x5d\xef\xf0\x37\xa4\x01\x40\xf3\xf0\x1b\x60\x82\xc8\xfb\x8d"
          "\xcc\xc1\x3b\xc1\x22\x01\xff\xd1\x21\x08\x3d\x59\x1e\xe6\x22\xde\x06\x16\xdd\x70\x51\xe1"
          "\x53\x71\x93\xf6\x60\x43\xac\xa1\x79\x57\x7b\x9e\xe4\x4b\xa2\xce\xdf\x55\x08\x97\x55\x02"
          "\x0a\x1e\xd6\xf7\xb8\x95\xd5\x38\xa0\x63\x70\x1f\x25\xd5\xb4\xd0\x95\x22\x70\x91\x60\xc7"
          "\x4e\x2b\x9f\x87\xa2\x77\xdc\x9f\x6d\x92\xcf\x8e\x3f\x58\xde\xde\x46\x11\x95\x28\x90\x48"
          "\x73\x27\x00\xf8\xb3\x9a\x9f\xcd\x2c\xa4\xf3\x3a\x91\xf1\x50\x73\x1b\x29\xc0\x6e\xc9\xfa"
          "\x4c\x69\x07\x24\x14\xb1\xbe\x27\xd4\x6b\xaa\x95\xc9\x07\xe9\xe6\x24\xac\x5a\xa2\xfa\xf2"
          "\x08\xc8\xcb\x10\xfe\x55\x67\x98\x94\xe9\x68\xd1\x65\x52\x3a\xa6\x62\x07\xca\x16\x92\x2e"
          "\xcb\x82\x5f\x88\x67\x5d\x44\x49\x85\x73\x53\x4b",
          "\xbc\x50\x8b\xe0\x0a\xe5\x32\xa9\x59\xc9\x9b\x1e\x75\x32\xf6\xad\x52\xfd\xaf\xf2\xc6\x54"
          "\xfd\xf8\x65\x43\xad\x6b\x93\x7f\x44\x02\x90\x41\x46\x1e\x64\xc2\xe2\xbf\x40\x48\xcc\x4f"
          "\x39\xb0\xf9\x0d\xb8\xdb\xd6\x3b\xea\xe4\x98\x2b\x4a\xdd\x7e\xf7\xaa\x75\xa4\x9f\x71\x77"
          "\xe4\x64\xc8\x69\x32\xc9\x44\xc3\x2c\x23\x94\x07\xa7\xd8\xd5\x0c\x4d\x01\x27\xf1\xa6\xfa"
          "\x7c\x7c\x75\x3d\x90\xab\xb9\xc7\x1f\xd1\x18\x27\xd7\x3c\x8b\x4e\xb3\x29\x74\xeb\x49\xe8"
          "\xa0\x9f\x8d\x21\xd4\xea\xc7\xc5\x52\xdf\x82\xf9\xc9\x4e\x89\xdf\x0e\xa8\x20\x9f\xab\x88"
          "\x4f\x4e\x7b\x3b\xf0\x7b\x8d\x0e\x7d\x3c\x5e\x64\x3f\x08\x19\xba\x32\xfc\x85\x77\xf1\x99"
          "\xcc\x9e\x97\xbc\xe3\x3f\x61\xa1\xc9\x3d\x0b\xeb\x65\x5d\x14\xb2\x90\xd5\x38\xcc\x6b\xdd"
          "\x2b\x3a\xa0\xe7\x17\x9c\xf8\xd7\xaa\xe5\x1a\xa6\x36\x87\xc2\xb8\xb5\xe2\x11\xc2\x9b\xd2"
          "\x71\x17\xb5\xf5\x4b\xb2\x77\x5d\xc8\x73\x5b\xc0\xeb\x11\x1b\x0f\x2c\xfc\x74\xa0\x1a\xb8"
          "\xd4\xe1\xe9\x4a\xcd\x9f\x46\xf5\x7b\x22\x78\xb9\xe0\x6e\xa7\xd8\x8a\xc4\x3e\x58\x9a\x7a"
          "\x13\xf1\xc6\x72\x0b\xfd\x82\x04\x8d\x5f\x85\x6d\x23\xbc\xf9\xfa\x60\x4a\x77\x44\xdd\xf2"
          "\x13\xb6\xe3\xf2\x51\xe2\xfa\x91\x09\x98\x78\xfe\x0a\xa9\x54\xf2\x42\xa0\x40\x7f\xab\x0c"
          "\xe2\xe2\x73\xaf\x46\xb9\xdf\xd6\xa9\xb2\x22\xe5\x29\x43\x7e\xa7\xa3\x6b\xc2\x40\x43\x1f"
          "\xee\x4c\x50\x71\xf9\x86\x10\xc9\xb3\x2d\x83\xf9",
          1, 2560 },
        { 128, 192, 52,
          "\x22\x62\x6b\xe7\x14\xf7\x79\x6a\x12\xbe\x5c\xbd\xf9\xcb\xcc\xbc\x3b\x6e\xe2\xc9\x91\x13"
          "\x5c\xf7",
          "\x97\x28\x62\xa0\xc6\xf0\x4c\x60\x96\x35\xe5\xb5\x1a\x2b\x1e\x3c",
          "\x63\xe0\xc7\x1d\x65\x83\x1a\xf6\xf2\x43\xdd\xc0\x31\xa5\xa4\x09\x3b\x51\x86\x26\xc4\x15"
          "\x2e\x59\xcb\xfe\xb4\x76\xb6\xea\x28\x54\x49\xcc\x56\xca\xc6\x64\xe8\x17\x56\x7a\xbd\xcf"
          "\x78\xa7\x4d\x5c\x14\x52\x5e\x50\x6f\x0c\x30\xf4\xcb\xc3\x6a\x80\xf5\x80\x6b\x01\xd1\xeb"
          "\x5a\xa1\x47\xf7\x59\x02\xc2\x17\x64\xd4\xf0\x29\x78\x2a\x1a\x4d\x23\x0f\x44\x5d\x74\x96"
          "\xa6\x1b\x8b\xb9\x9c\x1d\xd7\xf2\x81\x9a\x76\x5d\xc4\xf3\x08\x24\xe7\xc7\x59\xdd\x4c\x42"
          "\xfa\xf1\x6d\xd2\x57\xbd\x14\x12\xd5\xdf\x75\x41\xb6\xcd\x63\x16\xf5\x1a\xcc\xf1\x76\xd2"
          "\x05\xf1\xa3\x17\xb9\xde\x7b\x43\x8b\xcd\x54\xe9\xb7\x7d\x48\xba\x7b\xa8\xff\xa7\xe5\xf3"
          "\xd2\xe0\x09\x56\x1e\x89\x47\x4a\xb2\x21\xb2\xd6\xea\xb5\xdf\x1d\x1f\x78\x56\x80\x57\xc3"
          "\x49\x05\x56\xdf\x2b\x10\x9f\xf4\xd7\x0d\x19\x30\x7a\xfe\x0e\x85\x46\x71\x0a\xee\xe8\x7b"
          "\x3b\x0c\xa3\xc2\x06\xde\x75\x8a\xea\x0c\x00\x64\xd9\x88\xe0\x9f\x55\x16\x79\x2d\xf4\x85"
          "\x8c\xa5\x3e\x9b\x5d\x03\x4c\x13\xa3\xbd\x62\xf2\xff\x03\xde\xf4\x48\xeb\x74\x53\xf9\xdf"
          "\xa0\x7e\xa0\xf3\xfb\x50\x2f\x0e\x60\xe9\xee\x37\xea\x72\xb3\x1a\x74\xb9\xde\xb5\x57\xc2"
          "\x2b\x6c\x8a\x9c\xe3\xa2\x9f\xe1\x39\xf5\x6f\x79\x5a\x52\x4f\x7f\x1a\x8b\x3f\x40\xaa\x8d"
          "\x9f\x14\x10\x02\x77\x8d\x04\x91\xb0\x90\x8d\xcb\x6c\x8d\xfa\x59\x89\x71\xa3\x77\xd1\xc1"
          "\x58\x2d\xff\xef\xcc\x73\x8b\x4a\xca\x65\x66\xae\x5a\x48\xbb\x48\x87\x92\x28\x21\x82\xbc"
          "\xeb\x91\x42\xd0\x0a\x12",
          "\x1d\xea\x15\x24\xb0\xce\xa2\xad\xfd\x0b\x3b\x01\x09\x51\x8b\xfb\x44\x08\xe5\x06\x70\x72"
          "\x5c\x8f\x55\x18\x85\xc0\x62\xb7\x55\x20\x39\x98\x9f\xc7\x5e\xdf\x96\xaa\x6b\xfd\x99\xb3"
          "\xb7\x03\x9f\x46\xf8\x60\x86\xc1\xea\xaf\xef\x15\xd8\xcd\x11\x7a\xed\xed\x93\xe8\xdc\x88"
          "\x7b\x1f\x00\x40\xf5\xff\x27\x5f\x75\x4c\x6e\x62\x37\x1e\x7a\xdb\x6a\xec\x9e\x81\xbb\x9e"
          "\x3d\x08\xc5\xd0\xe7\x23\x14\x18\x88\xd3\x38\xa2\x49\x0e\xd2\xfb\x24\x0c\x7e\xd9\xa9\xdc"
          "\x6d\x8d\xaf\x9d\x48\x47\x17\xe4\x37\x4e\x7b\x55\xc7\xc5\x5b\x3c\x03\x99\x9f\x1a\xcd\xca"
          "\x43\x70\x47\x41\x75\x89\xf4\x38\x27\x5b\xfd\x3d\x46\xb7\xb9\x0c\xce\x57\x4c\xe5\x40\x09"
          "\xfb\x39\x2b\x5d\x66\xbc\xec\x6d\x3b\x52\xf5\x3f\x8e\x45\x46\x91\x5c\xc4\x30\x30\x0e\xdb"
          "\x83\xcd\x24\x20\xcd\xb3\x3a\x30\x14\x24\xc0\x43\x31\x11\x4f\xc4\x0a\x5d\xe0\x83\x32\xf2"
          "\xe4\xd7\x7f\xdf\x9a\x1c\x28\x41\x4b\xc0\xa6\xc9\xe0\x17\x4e\x5c\x4e\x8c\x2c\x48\x5c\x3b"
          "\x73\x8c\x66\x58\xd5\x0e\xf5\x23\xab\xe8\x36\x47\xce\xcb\x12\x5e\xab\x2b\xe5\x70\xac\x03"
          "\x0d\x06\x32\x6e\x4e\x6d\xdd\xb1\xfd\xf2\x61\x40\xc1\xa1\x58\x8b\x44\x01\x7d\x91\xae\xe3"
          "\x13\xcf\xa0\xcb\x7d\x8d\x91\x05\xea\xcd\xd9\x4b\xe2\xd2\xba\xa2\x72\x72\xa3\x5d\x2c\xd7"
          "\xba\x2e\x3e\xba\x89\x23\xfc\x28\x30\x32\xbf\x7c\x1d\x77\x91\xdc\x51\xd8\xe5\x02\x2c\x42"
          "\x07\x69\xe5\xac\x69\x0f\x04\xe4\xd9\x0c\xd7\xbf\xdb\x58\x59\x0c\x41\x9f\xf2\xd7\x2f\xa2"
          "\x46\xcf\xbd\xbe\x13\x08",
          1, 2688 },
        { 128, 192, 53,
          "\xbc\x1a\x18\xe8\x20\x9e\x98\x0a\x04\x99\xb5\xae\x7a\x10\x51\x20\xe6\xc5\x46\x87\xa5\x66"
          "\x76\xbf",
          "\xfb\x93\x85\xe6\x0f\x69\x9c\x20\xda\xb9\x33\x87\xf7\xed\x3f\xeb",
          "\x64\x8f\x04\xec\xa9\x6a\x6c\xeb\xf6\x31\x64\x4d\x3d\xf2\x0b\x7a\xd9\x23\x05\xf9\x3f\x93"
          "\x1d\xe1\xf2\xe9\xc1\x6b\x09\x5a\xab\x45\x7a\xa6\xf4\x30\x2c\x1d\xab\x1a\x94\xc3\xa2\xd1"
          "\x46\xf2\x4a\x80\xa7\x98\x84\xa6\x9d\x4c\xb2\x03\x55\x2d\x8f\xca\x1e\x2d\xcb\x2b\x65\x36"
          "\xee\x23\x11\xb4\xfa\x0d\x92\x8c\x21\xe7\x36\xd0\x2e\x22\x01\xf0\x67\x66\x94\x35\xd3\xc1"
          "\x48\x1b\x7a\xce\x96\x81\x33\x60\xa7\xb2\x46\xd8\x99\x6f\xed\xb8\xbb\x99\x8b\xee\x64\x18"
          "\x0a\xc8\xb8\x43\xe8\xdd\x68\xf1\x0c\xc1\x9a\x68\x09\x5e\x85\x07\xfe\x14\x50\xfd\xe9\x0a"
          "\xc0\x05\x5e\xe7\x5f\xd4\x6d\xc4\x7d\xc7\x46\x46\xea\xa8\xf2\xfc\xcb\xc1\x29\xec\x23\xad"
          "\x98\x98\x83\x69\x7f\x69\x27\x95\x89\xfd\xd7\x59\xac\xf4\x21\x8e\x03\xf3\xeb\xce\x2b\x4d"
          "\x70\xd3\xa4\xa1\x13\x3e\x59\xb2\x9e\xe5\x61\xfd\xa4\x34\x92\xea\x79\x1d\x04\x6f\xaa\xd0"
          "\x02\xcd\x77\x27\x89\x23\x97\x18\xfc\xa4\xf7\x25\x5f\x5f\x59\x0d\x50\x28\xbb\x42\x66\x43"
          "\xcb\xb5\x4a\x94\x38\x16\x84\x95\x00\x6f\x75\xde\x19\x80\xb2\xaa\xf4\xba\x15\x43\x53\xb8"
          "\x0c\x77\xfa\xfb\x1b\x2b\xc6\x3e\x4c\x9d\xf1\x4a\x84\xd1\xda\x18\x7b\xd6\x52\xe6\x78\x0d"
          "\x7c\x7c\x36\xbd\x59\xc2\x82\xf4\x85\x0d\xf5\x5f\xc4\x47\x4b\x3e\x37\x15\x4f\xfa\x7a\x61"
          "\x9a\x5e\x93\x99\x62\x18\x15\x7c\xf4\xbe\x19\x51\x70\xdf\x59\x13\xcd\xbd\x64\x6f\xee\xd5"
          "\x46\xc5\xb5\x1f\x08\xfe\x2e\x45\xa0\xb1\x79\xba\x19\xe2\xcc\x4b\x39\xbd\x1c\x8d\x53\xa1"
          "\xa6\xa8\xc7\x79\x50\x7e\x68\x53\xa4\xa8\x4d\x29\xa8\xc3\x81\x0b\x72\x22\xff\xf1\xf8"
          "\x13",
          "\x56\x17\x38\xa3\x7d\x5a\x3d\x9d\x69\xe4\xa8\x79\x47\xd9\x67\x77\xe1\x70\x20\xfd\xe2\x65"
          "\x02\xc3\x84\x81\x5f\x6f\xcf\x8b\x59\xf5\x7f\xd8\xe1\x8a\x09\xd7\x6d\x15\x12\xe4\x38\x3c"
          "\x86\x7a\xf8\x31\xc4\x6c\xcf\x34\x56\x15\xf7\xc7\xfe\x42\x5b\x48\xd3\x89\xa2\x07\xe3\x1a"
          "\x71\x3d\x2e\xc6\xbf\xa2\xea\xde\x12\x30\x9f\x71\xd6\x4f\xc8\x38\x92\xd1\x08\x16\x4c\x94"
          "\x5c\xd0\x07\xd2\x5f\x3b\x30\x52\x4f\xf9\x78\x29\x26\x47\x77\xb0\xa9\xb5\xaf\xee\xa6\x9e"
          "\x25\x56\xee\xa9\xe4\x97\xb4\xfb\x4b\xe1\xd2\x0c\xaa\xed\x16\x05\x9a\xed\x1a\xc6\x9a\x41"
          "\x0f\xf5\xf5\x70\x7d\xde\x90\x87\x9a\x37\x67\x81\x6a\xa3\x32\x9c\xce\x12\x1f\xa6\xac\x5d"
          "\xcb\xf7\x1c\x97\x08\x6a\x00\xe4\x73\x6c\x26\x95\x35\xf3\x1b\x03\x09\xf1\x94\xa7\x28\xc0"
          "\x8c\xf4\x79\xb7\x5c\xcc\x5f\xbb\xfc\x43\x94\xe4\x1e\x02\x9e\xfb\xc2\x04\xd1\xda\xe5\x7d"
          "\x66\xfd\xfd\x30\x32\xa4\x20\x08\xe3\x34\xd0\x57\xd6\x29\xfc\x84\xd5\xb1\x70\xdf\x39\xa2"
          "\xf2\xd4\x4a\x00\x64\x62\xab\xdb\xcc\x8c\xc7\x2a\x43\xa7\x77\xba\xfe\x11\xcb\xc2\xbf\x2a"
          "\xde\xdb\x05\x23\x48\x16\x73\x3f\xf7\x04\x14\x1b\xeb\xa4\xd0\xc7\x09\x7c\xfb\x02\xc0\xac"
          "\x76\x78\x04\x31\x02\xc1\x04\x76\xdd\x11\x97\x24\xbc\x17\x55\xd1\x27\x15\x56\x1b\xb4\x46"
          "\x17\x79\x6a\xd9\xcf\x6d\xb2\x5a\xff\x8e\xa9\x9e\x56\x4c\x48\xfc\xd6\x2c\xd4\xbb\x81\x51"
          "\xe5\xe6\x51\xef\xca\x20\x9e\xb5\xdd\xff\xc3\xf6\xa1\xd8\x7a\xeb\xf4\x78\xae\x01\x3a\x80"
          "\xb1\x64\xed\x73\x00\x39\xf9\xf3\x0a\xee\x42\x8d\xab\xe2\xe6\xc5\xea\x58\x3f\x1e\xd8"
          "\x90",
          1, 2816 },
        { 128, 192, 54,
          "\x06\x68\x96\x96\x6f\xd1\x8c\x90\x19\x26\x1d\x28\xd3\x53\xa8\xf4\x2b\x8f\xd9\x1e\x20\x49"
          "\x91\x5e",
          "\x63\x75\xa0\x91\x0f\x52\xbf\x65\xde\x11\xac\xcd\x85\xad\x10\x9c",
          "\x3d\x42\xd9\xd6\x6e\xe8\xdd\x56\x66\xdb\xc8\xc3\x56\xb4\x54\x1c\xab\xbc\x2a\x04\x78\x09"
          "\x72\xd9\x96\x8b\xff\x4f\x90\x00\xf4\x7c\x35\x95\xf2\xef\x1d\x7e\x10\xaf\xac\x3a\xa1\xa4"
          "\x12\xc3\x3f\x9e\xc9\x20\xbd\x3e\x63\x2e\x0e\xb5\x8f\x1d\xb9\xa5\x4d\x29\xb7\x90\x6a\x47"
          "\x67\xaa\x8f\x7f\x71\x7d\x88\xd5\x0d\x9d\x37\x5c\x6c\xb1\x65\x76\x17\x3d\x2d\x85\xfd\x57"
          "\xbe\x58\x30\xbd\x60\x74\xe3\x4b\xf8\x01\x31\xb8\x32\xb7\xd0\x88\xf6\x24\x71\x4a\x10\xff"
          "\x3a\xfc\x64\x6e\xe4\x5f\x7d\x1e\xee\xd9\x47\x31\x0e\x62\x5b\xa5\x05\x62\x2d\x57\xb7\x7a"
          "\x06\x15\xf0\xf5\x19\x49\xb0\x57\x14\xe9\x7b\xab\x35\x20\x88\x8e\x90\x47\x27\x78\x25\x57"
          "\xae\x0a\xfd\x9c\xd9\x36\x1e\x1d\xc7\x73\xb0\xe5\xca\x56\x4c\x82\x9d\x4b\xdb\xa5\xcb\x1f"
          "\x99\x3b\x77\x11\xd6\xef\x33\x0a\x2a\x23\xa5\xac\xf6\xce\xd8\xee\x6d\x00\x77\xe4\x9a\xcc"
          "\x44\xa4\x69\x4a\xdb\xa4\xb1\xdf\x7d\xb0\x3c\xe4\x83\x84\x7a\x0c\x8c\x91\x28\x24\x89\x39"
          "\x2f\x84\x5f\xc8\x91\x4c\xfb\x86\x49\x4a\x71\x0f\x83\x8f\x44\xc3\x96\x23\x22\x13\x8d\xc5"
          "\x3f\x89\x9a\xf4\x98\x69\xf7\x26\xcb\x4b\x50\x57\xea\x91\x42\xe0\xd2\xb9\xb1\x0c\x6d\x6a"
          "\x5a\x31\xc5\x16\x5d\xea\xf3\x8c\xca\xf2\x00\x34\x90\x99\x55\x5b\x7d\x19\xa2\x6b\x0a\xc4"
          "\x98\x03\xac\x5b\x3e\x12\xc1\xc4\xc8\x37\x01\x92\xc2\x05\xdb\xb0\xd5\x0e\x58\x5f\x6c\xc5"
          "\xc2\x16\xce\x2a\x05\xba\xa0\xe8\x7f\x6a\xd5\xc5\x8c\x0a\xf9\x72\x91\x79\xae\xfc\xd6\x3d"
          "\x85\x40\x81\x39\x80\x63\x0e\xe6\xaf\x2b\xa6\xcb\x94\xa5\x8c\x25\xc5\xca\x79\xa2\xaa\xa8"
          "\xd9\x58\xe0\x46\x74\xfa\xc8\x9e\xa2\x25\x42\x77\xaa\xeb\x29\xdf",
          "\xe9\x59\x53\xcb\xd6\x3c\xce\x46\x32\xaf\x32\x0c\x58\x58\x91\xd0\x48\x70\xc4\xff\x23\x5b"
          "\x4a\x6f\x5d\x1a\x80\xa2\xf4\xc8\x99\xa6\x6f\xbf\x65\x63\x97\x27\x2a\x45\x60\x70\xaf\xf8"
          "\x48\xfb\x7d\xd7\x85\x8b\x09\xa1\xd1\xe4\x9b\x07\x06\xd0\xa0\x18\x0b\x30\x4e\xf2\x42\x27"
          "\x88\xe8\x3c\x6a\x91\xbf\xcd\xda\xc6\x98\xa6\x28\x33\xc4\x93\xe3\x4e\xdc\xea\x26\xa0\x4c"
          "\x74\xfd\xea\x74\x78\x46\xfe\xb7\xd1\x69\x44\x87\x6a\xfa\x52\xa0\x4f\x35\x07\x97\x1d\x11"
          "\xb7\x31\x0b\x2c\x33\xa2\x93\x28\xfa\x97\xa6\xde\x06\x5b\xe0\xcf\x11\xb1\x64\x0b\x41\x49"
          "\x5d\xb9\x81\x0e\x3c\xbd\xf7\xd8\xfd\x1b\xd3\x82\xd3\x56\x51\x53\x21\x76\xeb\x5d\xfb\xfa"
          "\xc5\x58\xb2\x27\x0e\x52\x35\xc6\xfe\x0c\x62\x92\xd2\x8e\x75\x84\x7e\x0c\xd9\x89\xef\x78"
          "\x2f\x4b\xd4\x69\xdd\x79\x1c\x18\x15\xfa\x76\x5c\x5b\x03\x9b\x2c\x3f\x15\xd2\xd4\xc2\x9a"
          "\x3e\x68\xda\xcc\x12\x2e\xff\x4e\x7f\x49\x12\x17\x42\x6b\x8c\x51\xe0\x4c\xc9\xa9\xae\x98"
          "\xe1\x31\x9a\xc9\xb9\xe5\x8c\xb0\x5e\x77\x17\x45\x25\x39\x1a\xdc\x6e\x5f\x3f\x7a\xdd\xcb"
          "\x50\x32\xbf\xa0\xc1\x0c\xc9\x33\x34\x02\xe2\xd7\x38\x60\x10\x39\x0c\xb3\x2a\x66\x5e\x0c"
          "\x16\x33\xb3\x25\x99\xaa\x3e\x93\xdc\x60\x2f\xc3\x40\x80\xa4\xd2\xc9\x20\x77\x05\x27\x61"
          "\xe4\xbc\x30\xf2\x5d\x14\xa2\x9c\xda\x4b\x6c\xd1\xc4\x5c\x31\xc9\x0f\xa7\xe0\x4f\x72\x9b"
          "\x28\x02\x86\x27\xc7\xce\xa4\x50\xc1\xd9\x41\xcd\xd7\x60\xa8\x65\xa2\x17\xa6\xf2\x0f\x49"
          "\x75\x86\x83\xd2\x03\xaf\x2d\x0a\x21\xff\x0d\x1a\x3a\x72\xc8\xf4\x4d\x0c\xfb\x3a\x89\x6f"
          "\x3e\xb1\xbd\x73\x1c\xd0\x46\xcb\xcd\xa1\x51\x01\x3d\x63\x13\x6c",
          1, 2944 },
        { 128, 192, 55,
          "\xeb\x9d\x9a\x6d\x9a\xc6\x90\x10\x93\x2b\xdb\xa3\x56\xb0\x9e\x26\xe9\xbd\xaa\xd1\xe6\x51"
          "\x5f\x76",
          "\xc9\xbb\xda\xee\xbf\x00\x81\x48\x36\x0e\x2b\x6a\x36\xe3\xb7\x56",
          "\x56\xb5\x4b\x67\xcc\x52\x8f\x56\x97\x6b\xef\x8c\x4a\xda\x89\xe7\x26\x9f\x2b\x75\x99\xc2"
          "\x0e\xb5\x8d\x2e\xdb\xcc\x70\xb7\xb2\x87\x16\x7b\xf1\x14\x3d\x7a\x2f\x80\xab\x0c\xce\x13"
          "\x21\xee\x19\x71\x96\x84\x26\x4d\x8a\x40\xeb\x8e\xdc\xd3\x5e\x99\x5e\xac\x50\x1f\xcd\x33"
          "\xee\x09\x21\xb0\xbc\x79\x22\xd6\x4b\xf0\x39\xfc\x2e\x04\xad\x2b\xbb\x1c\x8b\xeb\xbd\x90"
          "\x91\xf2\x00\x14\x65\x0a\x59\xef\x7b\xe6\x47\x24\xfa\xf2\xff\xb0\xb3\x41\xb2\x25\x7b\x8f"
          "\x1a\x01\x88\xb0\xac\xa5\xfa\x67\x3c\xdb\x44\xa3\x10\x39\xd6\xd8\xd5\x06\xd7\x9b\x1e\x27"
          "\x44\x9c\x39\xe2\x98\x8a\x05\x4d\x90\x96\x9e\xcd\xee\x66\xbe\x2c\x2f\x54\x37\x47\x4c\x1f"
          "\x26\x4a\x20\x52\x41\xc6\x8a\x79\xc7\x2b\xc8\x5b\x90\x46\x2d\x91\x1d\x66\xab\x64\xde\x59"
          "\xd7\xa4\xac\x20\x1f\x69\x57\xd8\xed\x5b\xef\x11\x79\x06\x6a\xc2\x04\x87\xd9\x98\x0d\xf6"
          "\xc9\x06\x7d\x79\x85\x05\x35\xe4\xd5\x81\xd0\x05\x94\x39\xed\x38\xbd\x97\x2a\xae\xed\xd4"
          "\xe0\xf8\xa7\xc8\xa0\xb3\x96\x75\xe8\xca\x4d\xb4\x5e\x5d\xf8\x49\x77\x95\xab\x35\xbb\x68"
          "\x32\x1d\x75\x40\x3d\x6c\x63\x96\x88\xe2\x1b\xf6\x7e\x97\x98\x64\x4e\x71\x5b\xbf\xe7\xbb"
          "\x49\x21\xba\x65\x96\xb8\x00\x09\xe2\xaf\x65\xb0\xd8\x99\x2b\x92\x5c\x8f\x89\x76\xa3\xae"
          "\xde\x9e\xbd\x73\xd7\x08\x3e\xe5\xcd\xb5\xb7\xb1\x6a\x0f\x86\x61\x83\x7c\x78\x40\x5a\x4c"
          "\xb6\x8f\x3d\x0b\x9e\xf2\x6c\x30\x5c\x86\x0b\x1f\x6e\xb7\x13\xfb\x55\xfc\x29\x9a\xb3\xc1"
          "\xbe\x24\xb7\xbd\xe5\x91\x36\x8a\x63\xfa\xcd\x19\xc0\x9b\x89\x42\xd5\x4b\x63\x69\x72\x10"
          "\x89\x85\x90\x1d\x34\x32\xa8\x60\x81\xd3\x68\xc2\x17\x85\xf8\xd4\x41\x92\x46\x2b\xe4\xd9"
          "\xa0\x28\xbd\x4f\x0b\xad\x5c\x6b\xf3\x48",
          "\x10\xbb\xc2\xca\xfb\xaf\x74\x50\xcf\x4a\x48\xe2\x69\x97\x43\xef\xc0\x59\x61\xe2\xc1\xb4"
          "\x75\x07\xa9\xd9\x09\x94\x98\x90\x2d\x70\x12\xbc\xa4\x31\x4e\xce\xa5\xae\x6f\x3d\xb7\xdc"
          "\x5f\xb1\xdf\x90\x98\xe0\x0a\x42\x28\x1e\x22\x15\x83\xe2\xe0\xe9\xc9\x13\x5c\x68\xed\x21"
          "\xbb\x83\x1a\xc8\xd5\xee\x55\x87\x6e\x2c\x62\x40\x3a\x09\xe4\xf8\xca\xc7\x1a\x68\x3e\x87"
          "\x38\x50\x96\xd2\x85\x9f\xce\xa2\xe2\x2e\xb0\xf1\x0e\xc9\x7a\xbd\x5b\x55\x4c\x0c\xa1\x58"
          "\x11\x5c\x18\x8b\xc3\x9b\x92\x08\x8a\x57\x88\x38\xe8\xfa\x0b\x23\xe3\x7e\x85\xc8\xff\xd3"
          "\x13\x71\x30\x3b\x9a\x59\x2d\x54\x3a\xae\x4e\x29\xb5\x1f\x5a\x30\x87\x44\x54\xf3\xfc\x91"
          "\x46\xef\x83\x8b\x94\xf4\x0b\x1b\x5e\x43\xbd\x15\x71\x60\xad\x71\x3d\x01\x1f\x7e\xe3\x5c"
          "\x6c\xd4\x4d\xd7\x3b\x07\xea\x3b\x38\x9d\x11\x72\x27\xd4\xe0\x27\xf5\xbd\x3f\xac\x17\x4b"
          "\xd4\xf2\xee\xaa\xfd\x7d\xdf\x09\xc6\x48\x93\x0c\xaa\xa0\x79\xc8\xb5\x9e\x1c\x2c\x8b\x27"
          "\xff\xb7\x77\xbf\xe2\xf1\x5c\x31\x18\x11\x72\xd8\x5e\xa0\x75\xce\xc5\x02\x67\x3d\x89\x7d"
          "\x78\x35\xe1\xf2\x9b\x3a\x97\xab\x26\xc9\xdc\xe8\x94\x0c\x96\xe8\x43\xdf\xd1\x5a\xce\x1b"
          "\x17\xe2\xfa\x44\x01\x81\x56\x72\xec\x9e\x30\x90\x97\x54\x1a\x6b\xae\x0f\x41\xa1\x5d\x76"
          "\xa6\xca\x95\x17\xcb\xe8\x1c\x44\x51\xb8\x7d\x3a\xb5\x47\x3a\xd2\x85\x72\x7f\x80\x49\xd9"
          "\xac\xe3\x77\xef\x31\xb0\x77\xb6\x46\x58\xff\x87\xc6\x0f\x7b\x5b\xad\x99\xf3\x63\xb0\x49"
          "\xfd\xf0\x4b\x54\x27\x59\xe7\xae\xac\x4e\x14\x6f\x22\x3b\xf0\x16\x41\x57\x0a\x2c\x4c\x5c"
          "\xe7\xad\x08\x5c\xb4\xa1\x32\x29\xd3\xea\x55\xb1\xf6\x04\x52\xb8\x5a\xd5\x86\x98\x91\xef"
          "\xc4\x33\x9c\xe3\xa0\x9e\x06\x06\x2b\x6d",
          1, 3072 },
        { 128, 192, 56,
          "\x77\x76\x32\xdf\xcf\xb2\xbd\xa8\xd3\xc0\x81\xfe\x12\xba\x48\x39\x72\x02\x90\x91\xb3\xb6"
          "\xcb\x9c",
          "\x3c\xc1\x69\x56\x41\xb8\x1b\x3c\x22\xec\xa1\x63\xa7\x01\x77\x22",
          "\x45\xcf\xce\x57\xe2\x6d\x96\x56\x46\x28\xaf\x55\xea\x83\x5a\x79\xac\xf8\xb9\xa6\xdf\x14"
          "\x3e\xe4\x5e\x4c\x74\xe4\x34\x1c\x9b\xbb\x97\x0e\x40\x8a\x0e\xfa\x58\x24\x96\x4e\xc6\x1b"
          "\x7e\xec\x3f\x2e\xb9\xbc\xad\x71\x2d\xe2\x4b\xdc\x55\x7f\x6c\xc2\x90\xc1\x37\x60\x36\x4b"
          "\xd5\x7c\xc8\x4d\x05\xba\x00\x29\x33\x3c\xb4\x33\x65\x44\x6a\x01\x02\x56\xc7\x47\x33\x93"
          "\x34\xf0\xa7\xb0\x13\x5d\x3b\xc6\x16\x4f\x9a\xe2\x05\x1b\x47\xb6\x12\xa3\xec\x08\xa4\x66"
          "\xf2\x2c\x45\x3c\x02\x0d\x0e\xd8\x2d\xb9\x84\x6b\x4f\x34\x65\x92\xab\x37\x48\xb1\xac\x81"
          "\x17\x12\x22\xfe\x75\x62\xec\x11\x1b\xfa\xaa\xa7\x2d\x40\xfe\x8e\x4a\xdc\x88\x5b\x9a\x56"
          "\xa0\xea\x5a\xa0\xec\x48\x30\x15\x7b\xe3\x89\x29\xe6\x0c\x7a\x74\xe6\xe6\x5a\xdf\x21\x06"
          "\xe9\xe9\x74\x0a\xf7\xbf\x0a\x80\x40\x7f\x40\x40\x36\x80\x9b\xfc\xaf\xae\xe2\x5f\xc7\x2a"
          "\x35\x29\xe8\x21\x21\x40\x2c\x9a\x1c\x6f\x44\x52\x18\x82\x4a\x84\x70\x94\xd0\x3c\xd3\x55"
          "\xea\xc3\x3d\x55\x7b\xed\x20\xd2\xfc\x29\xe4\x4f\xa4\xfa\x49\x85\xe7\xb0\xb4\x6e\x6f\x3e"
          "\xbf\x99\x55\x79\xdf\x8f\x31\x33\x53\xc5\x3f\xfd\x5e\x01\x7f\x37\xc5\xee\x27\xad\xcf\x4f"
          "\x83\x07\xac\xac\xb2\x5c\x21\x9d\xaf\x95\xb2\x51\x49\x3e\x97\x5f\xf3\x6a\x6b\xbd\xc8\xf7"
          "\xec\x76\xd9\x0d\xfb\x75\x3b\xeb\x81\x6f\xb8\x65\x6a\xdc\xce\x40\x13\x0a\x37\x7c\x7b\xaf"
          "\xc7\xa6\x0d\x8f\xe6\x1d\xae\x68\xcc\x36\xf9\x28\x5b\xb0\xc1\xbe\x9f\x93\x3c\x8d\x22\x6c"
          "\x0b\x4a\xf2\x66\xd3\x2b\xce\x3a\x54\x8e\x67\x3d\x43\x91\x15\xae\x68\x6b\x9b\x11\xcd\x46"
          "\xcb\x28\xce\xdd\x30\x17\x48\x13\x78\x6e\xd3\xed\x29\x59\x3a\xe2\x96\xec\xa1\x21\xa5\x5e"
          "\xbe\x57\xbd\x7c\x9b\xd9\x96\xe9\x36\x31\xa0\xe5\x1a\xdb\xe6\x9b\xa4\x88\x00\xf2\x3f\x8c"
          "\xfc\x05\x86\xc7",
          "\x40\x4a\x14\xfd\x40\x3c\xd4\x0a\xaa\xf0\xfc\x7b\x52\xf7\x68\x48\x23\xca\x4d\x70\xf4\xee"
          "\x42\x3b\xe0\xc3\x28\x5b\x7d\x8b\xe7\x6b\x42\xda\xe3\x2f\x56\x81\xf6\x23\x59\x2e\x13\x75"
          "\x7a\x1b\x4a\xfe\xa4\x1b\x78\x1a\xb8\x89\xc1\xc8\xf1\xc3\x55\xa8\x0c\x76\x68\x10\xcb\x49"
          "\x96\x7e\x72\x6c\x8a\xc2\x11\xa2\xc2\x1d\x7c\x2d\x84\x61\x9e\x14\x91\xd7\x70\x59\xc9\xce"
          "\xfb\x04\xa4\xb0\x6a\xff\x9a\x01\x69\xdf\x4a\x66\xfb\x01\x4e\xaa\x42\xa0\xa9\x4b\xe0\xa2"
          "\x17\x7d\x7e\x64\xdb\x97\xf3\x65\x00\x6f\xa5\xac\xad\x33\x41\x04\xd6\x36\x99\xb5\xa5\x5f"
          "\xb3\x19\xb0\x6a\x25\x45\x1d\xa3\x9e\x45\x55\xd7\x3d\xd3\x7b\x7d\xfa\x64\xb5\xb4\x3d\xc7"
          "\xf7\x70\x46\x2c\x03\xf0\x06\x31\x92\xbf\x44\x62\x8a\x10\xb0\xa4\x3d\x32\x17\xab\x1e\x3b"
          "\x3d\x32\x70\x55\xfc\xc6\x3d\x85\xf1\xaa\x76\x83\xf4\xa3\x3e\x1c\x4b\x27\x15\x47\x30\x51"
          "\x4e\x8c\x22\x76\x45\xfc\xe6\x79\x60\x86\x82\x4f\x23\xd9\x1f\x92\x80\xf0\x48\x3c\x67\x23"
          "\x18\xcf\x4c\x62\x4a\xb3\x75\xc8\x1c\x56\x4a\xcf\x8f\x15\x07\xd1\xa3\x1f\x4b\xa3\xee\x2a"
          "\x30\x2d\x37\xf9\x66\xb5\x9a\x0a\x0f\xaf\x20\xa2\x00\xa8\xc4\x2e\x1f\x43\x86\xe2\x55\xfc"
          "\xc3\xfe\xde\x8d\x42\xc2\x6f\x5a\x3e\x9d\xc6\xb0\xbd\x3a\xaa\xe8\x25\x9e\x3a\x35\x45\x5d"
          "\x6c\x8d\xae\x6f\x48\xcb\x37\x18\xce\xb3\x00\x0a\x07\x16\xa4\xae\xbb\x74\xd0\xc6\x1d\xa0"
          "\x33\xc9\xea\x60\xb9\x67\x57\xb1\x95\xbc\x44\x4b\xc4\x81\x56\xf9\x27\x4e\xca\xdb\x67\x77"
          "\xa3\x93\xe1\x3c\xf0\xf9\x3f\xa1\x37\x17\x32\xbc\xf9\xe8\x47\x58\xe8\x3d\x6c\x8b\x8a\x56"
          "\x50\xa8\xc4\x41\xa8\x21\xaf\xf6\xb6\x26\xef\xb4\xd6\xd1\xca\x07\x71\x8d\xc0\xe8\x61\x65"
          "\x8c\x2a\x3c\xb6\x99\xe8\xd6\x81\x40\x4f\xde\x76\xe9\xc1\x19\xb8\x65\x3f\xec\xb8\x77\x04"
          "\xe7\x23\x84\xe3",
          1, 3200 },
        { 128, 192, 57,
          "\x7f\xf8\x25\xdc\xd0\x8e\x5a\xa7\x55\xdc\x90\x66\xcc\x11\x46\x3b\xbd\x71\xaa\x1a\x01\x91"
          "\xd8\x67",
          "\xec\x6f\x70\x6f\x00\xa5\x2e\xb7\x9f\x2c\x8d\xd4\x30\x2c\x0c\x36",
          "\x68\x5f\xe4\x03\x0d\xf7\x89\xc6\xae\xad\x03\xb7\x33\xd2\xef\x7e\xc4\x42\xb2\xe7\xee\xe2"
          "\xc3\xad\x65\x7e\xfa\x81\xe7\x2e\x7a\xce\x69\xaa\x1b\x31\x0c\xea\x8e\x0a\x20\x0b\xe7\xff"
          "\x3f\x1c\x99\x6e\x9f\x99\x87\xfb\x0c\x6b\xb2\x89\xdd\x23\x0e\xc1\x98\x45\x50\x78\x34\x22"
          "\x76\xfb\xaa\x07\x09\x86\xef\x1d\x36\x27\x89\xbe\x60\x54\x0e\x5f\x59\xfb\xf1\x63\xa2\x7d"
          "\x1f\xa4\xfc\xa0\x6a\x87\x52\x4c\x41\xad\xe5\x27\xb8\x0a\x70\x97\xf0\x68\x09\x93\xad\xe0"
          "\x39\x4a\x52\x57\x8b\xeb\xf8\x7c\xf7\x72\xf5\xfe\x2b\x85\x2a\x01\x82\xc6\xe9\x36\x45\x03"
          "\x05\x78\xb6\x53\xa5\x7b\xfb\x16\x0d\xfe\x8e\xdb\x0d\xac\x58\x95\xf2\xd9\xc8\xd3\x2d\x50"
          "\x3a\x45\xcf\x2f\xd4\x58\xb7\xa2\x53\x50\xdc\xe4\xc9\xc7\x65\xf1\xad\xa6\x78\x96\xc5\x72"
          "\xf0\x1c\xa3\xd3\xa0\xc0\xae\xd5\xc9\xc4\xfb\x5b\x8f\xbd\x8e\xd8\x97\xc9\x90\xad\x8d\xe5"
          "\x4c\x60\xd5\xe1\x3c\xc7\xb6\x77\x44\x76\x17\xca\x6c\x9b\x6a\x42\x4c\xa0\x2f\xc5\x25\xfc"
          "\x1d\xf8\x9b\x58\x52\x33\x45\x1a\x9b\x34\x15\xc2\xf4\xd6\x9a\xb5\x27\x95\x64\x2f\x55\x70"
          "\x53\x29\xb0\x4d\x02\xa1\xb1\xd2\xed\xf2\xc4\x0f\xbc\x0c\x81\xda\x3e\x8e\xc1\x96\x52\xed"
          "\x4e\x34\x2a\x89\xd1\x69\xf8\xd9\x87\x84\x6a\xd1\x73\x8d\x6a\xb0\xc4\x2a\x82\x5c\x81\xdf"
          "\x0e\x10\x53\x02\x65\x57\xa0\x49\xdb\x0f\x63\x38\x2f\x21\xcb\xc9\x9f\x4d\x4e\x3e\x10\x66"
          "\x11\x7c\x54\x9c\x78\x30\x99\x14\x89\x97\xae\xb7\xfd\xc9\x6b\xc7\xac\x22\x14\x5c\x64\x64"
          "\x3d\x60\xee\xd2\x5a\xa8\xfd\xf8\xa7\x1c\xa1\x5b\x79\xa3\xba\xc3\x6c\x8e\x8a\xdc\x63\x2a"
          "\xb1\x61\x0a\x4b\x04\x3a\x04\x84\xc8\x65\x7d\x22\x4a\x8d\x3b\xbe\x0c\x44\x25\xbd\xe1\xca"
          "\xad\x01\xf3\x69\xe4\xbd\x06\xa7\x51\x25\x26\x6a\x75\xb1\xf4\x73\xdf\x7c\x3e\xb7\x26\x2d"
          "\x01\x40\x19\x7a\x70\x66\x8b\x5f\x92\x1c\x9f\x38\x7b\x85\xd3\xba\x55\x34\xa4\x46",
          "\xfe\x4d\xae\x25\xb2\xaf\xcf\xd6\x01\x4a\xc2\x4f\x68\xc4\xd3\xec\xb3\x56\xab\xc7\x51\x9d"
          "\xc9\x5b\x20\x70\x92\x16\x67\x59\x47\xbf\xcd\xe2\x3a\x23\x7a\x10\xba\xd6\x02\x21\xcc\x98"
          "\x3f\xf3\x30\x51\xa4\x21\xfc\x75\xb9\x3b\x45\x37\xb1\x35\x43\xe4\xc9\x13\xba\x23\x6c\xaf"
          "\x12\xf8\x9d\xa8\xf4\x2d\x0a\x7e\x75\x78\x1d\x0e\xb0\x57\x5b\xc4\x81\xf9\xd0\x76\x79\xb2"
          "\x55\x1a\x11\x26\xb5\xb4\x86\xd1\x86\x18\x0d\x2b\x4d\xd0\xa1\x79\x8c\xb0\x9a\x8c\xa9\xeb"
          "\x83\xe5\xa3\x49\x37\x3b\x5d\x20\x0f\x3d\x58\xb8\xaf\xe9\xd9\x56\xa4\x2f\xe5\x44\x00\xb0"
          "\x65\x6e\xa6\x0e\x2e\x04\x56\x0c\x79\x74\xa1\xe5\xa4\x40\xba\xe9\x73\xaa\x50\x7e\x00\x30"
          "\xed\x77\x52\x42\xd5\xb7\x36\x35\x26\xca\x28\xe3\x97\x7c\x86\xaa\xf2\x87\xc0\x56\xd6\x9d"
          "\x28\xa8\x95\x5d\x84\x2c\xca\x56\x10\x18\xc5\x3c\xed\xad\x7f\xee\x21\x55\x96\x64\xc9\x0e"
          "\x9f\x6b\x2f\x41\xf9\x4a\x23\x6f\xd8\xac\x73\xd2\xd1\xb9\x42\x5c\x9e\x69\xff\x1b\xbf\xe3"
          "\x13\xdf\xc7\x3d\xe2\x41\xf9\xce\xb9\x96\x74\x6a\x7f\x1f\x42\x3f\xaa\xf7\x80\x1d\x3a\x52"
          "\xde\x70\x27\x02\xa5\x0f\x48\x4b\x8e\x74\x2f\xb7\xb2\x21\x18\x5a\x13\xc8\xa3\x34\xeb\xd1"
          "\xb9\xaa\xc3\x48\x24\xb9\x4f\x86\xef\xb3\x51\xb7\x6c\xb9\x41\xc5\xbc\x53\x1a\x01\xcc\x9e"
          "\x82\xba\x8a\x92\xd0\x5b\x76\xb0\xee\x1b\xa2\xa7\x27\xdf\xab\x30\x60\x23\x74\xe1\xc6\xc3"
          "\x97\xa0\x67\x71\xcd\x80\x98\x06\x46\x0b\xc3\x16\x73\x37\xb2\xf7\x60\xfc\xf4\x39\xd2\x98"
          "\xad\x1b\xad\x07\x62\x72\x5c\x2c\x83\x08\x46\x86\x9f\x95\x09\x13\x8d\xa5\x9f\x50\xd8\xbb"
          "\x63\x28\x82\xec\xff\xaf\x8a\x89\x70\xec\x77\xb8\x0a\x92\xbc\x42\x71\x51\x87\xc3\x76\xa3"
          "\x03\x37\xfc\x32\x1c\xf4\x7e\x20\x2e\x10\xc7\xa3\xc4\xe2\x9e\xfb\x1a\xce\x5b\xb0\x46\x19"
          "\xe9\x0c\x79\xd2\xe5\x13\x6b\xfa\xd5\x4a\xc9\x7a\x9e\x5e\xa7\xd1\x7e\x0d\xae\x72",
          1, 3328 },
        { 128, 192, 58,
          "\xff\x4c\xe5\x9a\x28\x7a\x83\x76\xd4\xcf\x7f\xff\x93\xb4\xd4\xa3\x16\x68\xa8\x9b\x0f\x48"
          "\x67\x66",
          "\xf0\x2f\x79\xa0\x9e\xe3\x17\x1f\x59\x57\x63\xf9\xd3\x5e\x50\x94",
          "\x4c\x83\x68\x9d\xfe\x8f\xe4\x61\x2e\x32\x23\xee\xb0\xfc\x2a\x49\x1a\x85\x1a\x07\x16\x7e"
          "\xd0\x06\xac\xc7\x9d\xfe\x71\xa8\x3e\x25\x17\xba\x01\x8f\x07\x00\x5a\x78\x04\x88\xd0\xd3"
          "\x1e\x65\x43\xf9\xd4\x15\xeb\x74\x09\x1b\xd6\x3f\x70\xc4\x28\xd5\xa4\x82\xb1\x9d\x13\x2c"
          "\xba\xf9\x22\x9a\x67\xa4\xb5\x00\xcc\x3f\xa1\x83\x1d\x82\xe4\xe2\x74\xca\xd7\x5d\x10\xf9"
          "\xa5\x61\xd6\x16\x95\x60\x64\xe7\xc9\xdb\x1f\xee\xa6\xe2\x07\xdc\x39\xe4\x3d\x39\x95\xf2"
          "\xfe\x11\xb3\x32\x0a\xa4\x38\x26\xbc\xc8\xb0\x81\x65\x37\x0f\x43\x7d\x3d\xd2\xe2\x94\xfa"
          "\x0d\x71\xeb\x4b\xa4\x36\xdf\x0c\x44\x77\xca\x12\x9c\xdb\x94\xd6\x29\x0b\xc8\x4d\x0a\xc3"
          "\x5d\xd1\x5b\x1d\x57\xb6\x03\xad\x6a\x8b\x51\x43\x42\x23\xf0\xd8\x1f\x65\x98\x46\xeb\x4f"
          "\xb6\xa4\x7d\x59\x91\x06\xa4\x69\xee\xa8\xd8\x25\x18\x13\xd7\xe9\x95\xc4\xf7\xfa\x46\x7f"
          "\x8d\x7b\x6d\x48\xf4\xb1\x03\x92\x3c\xe4\xa3\x33\x92\x20\xc5\xfd\xce\xef\x40\xff\x68\x71"
          "\x7c\x86\x94\xe7\x80\x59\xc1\x39\x5d\x4b\xc5\xb3\x1b\x0c\x8d\x03\x97\xd1\x70\x7d\x5b\xee"
          "\x7b\xda\x85\x5a\xd4\x8d\x0c\x43\x0c\xfa\x56\x13\x30\xb8\xd4\x3b\x56\xab\xd4\xc0\x49\x16"
          "\x37\x3d\x71\x57\xfb\x4d\x2d\x8c\x34\x6a\x90\x5c\xa7\x47\xa1\x74\x54\x01\xd5\x3c\x40\x78"
          "\xc3\x83\x61\x78\xc4\x80\x37\xe3\x45\x75\x33\x50\x98\x84\xf8\x48\x77\xe2\x45\xcb\xed\x0e"
          "\xad\x21\xce\xf6\x71\x22\x49\x05\x47\xb8\x91\xcc\x3e\x64\xcd\x5a\xa4\x33\x86\x15\xc7\x7f"
          "\x8d\xf7\x65\x21\x33\x3d\xed\xcb\x7a\x23\x88\x7a\xcf\x41\x5c\xcc\x69\xa5\xf2\xae\x97\x26"
          "\x2b\xa8\x50\x67\x0f\x78\x75\x21\xe4\xb1\x3f\xcc\x1b\x69\x1a\x39\xb9\xe7\x23\x76\x80\x5c"
          "\xf8\xcb\x25\xc4\x39\x52\x46\xd9\x38\x31\x81\x52\x87\xfb\xb1\x5c\xd0\x4b\xa7\x9c\xde\x74"
          "\x45\x6e\x5f\xe2\xf7\x13\x79\x35\x5c\xe9\x9c\x56\x2e\x86\x1b\x7d\x33\x2c\xfa\xd0\x1a\x7a"
          "\x38\x83\x3a\x56\x11\x31\xbf\xf5\x01\x9e\xfa\xb8\xe5\x11",
          "\x62\xe4\xac\x36\x47\x12\xd4\x39\x9b\xde\x6f\x6b\x20\xae\xb8\x75\xfd\x9b\x8f\x17\x4d\x01"
          "\x18\xc5\x85\x99\x2c\x64\xb8\x1a\x24\x25\x6e\xfc\x99\xe5\xed\x81\xe9\x13\x02\x4d\x85\x15"
          "\x17\x8c\xcd\x60\x00\x2a\x5e\xdd\xf6\x6e\x09\xe2\xf1\x90\xfc\xe4\x04\x16\x3f\xc4\xcd\x80"
          "\xc5\x12\x24\xea\xd4\x2f\x05\xc8\xc7\x2c\x61\xa6\x9a\x76\xa3\x44\x57\xef\x8a\x84\x43\xad"
          "\x62\xe9\x4c\x79\x36\x8c\x38\x17\x2a\x34\xb8\x81\x50\x3c\xbf\x7b\xa6\xbe\xa7\xae\x09\x3a"
          "\x0b\x4f\xd6\x90\xf7\x9a\x2f\xb4\x1d\x18\x2b\xbc\xdc\x3c\xb1\xbd\xc4\xda\x5a\xc6\xc2\xf0"
          "\x68\x49\xc8\x2b\x69\x5d\x5a\xee\xe8\xec\xcb\x77\x98\x85\xe9\x89\xc9\xab\xfd\x91\x81\x3c"
          "\xc4\x54\xf6\xf0\xa7\xf3\x4d\xda\x62\x16\x84\xfd\x6f\xc7\xb3\x83\x7b\x87\xd4\x3d\x23\xe8"
          "\x12\xbc\xb4\xb9\x12\xa7\x4a\x24\x3f\x49\x5a\xf5\x17\xde\xaf\x36\x5a\x20\xcb\x6a\xfe\x38"
          "\xee\x99\xfa\x60\x83\xcf\x68\x24\x5e\x72\x04\x5e\xc3\xca\x22\x66\x1c\x9d\x2b\xe0\x60\xd7"
          "\x65\x63\x08\x70\xe8\x3e\x50\x74\xfc\xd6\x5c\x1e\x82\x73\x63\x3d\x75\xf1\xc6\x86\x19\x92"
          "\x3c\xb1\x8e\x78\x76\x1b\xec\x00\x28\xa9\x42\x74\x85\x3a\x8c\x16\xa8\x5e\x31\x10\xc0\xd1"
          "\x27\x95\x13\x86\x2d\xac\x49\xd3\x06\x2a\xd1\xb1\x78\x1a\xf1\x35\x0a\x9d\x21\x44\x16\xab"
          "\xf2\xa7\x8e\x84\x7b\x3c\x60\xfc\x63\x08\xe5\x5e\x74\x1b\xe8\xa7\xc6\x39\x46\xfe\x5b\x30"
          "\x19\xd3\x0a\xb5\x0a\x5a\xd9\x9b\xb7\x64\xd2\xcf\xa4\xe2\xa0\x13\x36\xc8\x29\x08\xcc\x9f"
          "\x77\xd0\xb0\x16\xcd\x63\x7c\xb1\x56\x9c\x96\xb3\xff\x1b\x85\xe3\x4c\x81\xa8\x0b\xaf\x5f"
          "\x66\xbe\xae\xe1\x93\xe3\x2c\xdb\xbe\x45\xef\x1b\x0e\x58\xee\x0d\xc6\x95\xd0\x3d\x98\x00"
          "\x3b\x8a\xc7\x00\xc5\x77\x5b\x00\xe3\xec\x7b\xfc\xc7\x0b\x16\xf0\x3b\x0f\x52\x25\x7e\x2d"
          "\xee\x28\x6f\x81\xa1\xa9\xa3\xdf\x69\x90\xc9\x19\x14\xbc\x18\x7e\x41\x59\x84\xc6\xc5\x56"
          "\xcb\x70\xd7\x8f\xe9\x8c\xe9\x2d\x25\xbb\xa3\x03\xd9\xa2",
          1, 3456 },
        { 128, 192, 59,
          "\x5a\xac\x5f\xfc\x8a\xb0\x79\x0f\x18\xc2\x99\x97\x64\xe6\x14\x9e\xec\xa5\xe1\x58\x41\x0f"
          "\x65\x40",
          "\xc9\x4c\x98\xaf\x0c\x95\xac\xac\xa3\x18\x8e\x8b\x67\xb9\xa5\xa6",
          "\xc4\x34\x63\x20\xce\xc3\x10\x4b\x03\xe5\x0c\x5b\xde\xde\x46\x69\x05\x8d\x6b\x13\x43\x73"
          "\x00\xd3\x8c\xd1\xe4\x04\x08\xbb\x5f\x39\xa7\x74\xf8\x7a\x1b\x10\x0d\x5d\x84\x2e\x5f\x3f"
          "\x18\x29\xc2\x0c\xd3\x80\x71\x7e\x1e\x9c\xa1\xb7\xf5\xcf\xf8\x33\xc0\x6c\x21\x43\x70\x04"
          "\xef\x3c\xd4\xf5\x01\x1c\x97\x49\x69\x57\x39\x4d\xf3\x46\x05\xb7\x2f\xcb\x49\x54\x9f\x37"
          "\x39\xed\x5f\x73\x24\x55\xba\x48\xa9\x53\x1f\x23\x5d\x02\x53\x57\x09\xa6\x26\x7c\xbc\x0f"
          "\xb2\xfb\x6f\x34\x55\x3c\x4b\x7d\xa0\x8b\xdd\x3d\x38\x57\x98\x2f\x8c\x6b\x5b\xbb\x3a\xd7"
          "\xcd\x1d\x8a\x8a\x65\xb5\x38\x61\x0f\xab\x42\xe2\x62\x72\x52\xa1\x51\xd8\x69\xc5\x11\xee"
          "\xa2\x1c\x18\xdc\x7b\xf6\x3c\x9d\x7b\x21\xe4\x8c\x99\xc0\xec\x19\xa2\x2a\xa2\x9d\x89\x63"
          "\x86\x60\x1d\xc1\xc8\xfd\x62\x7c\x9f\x53\xde\x0b\x3c\x4e\x2f\x40\x1d\x39\x09\xd0\x3c\x97"
          "\x5e\xb5\x0e\x4f\x0d\xa7\x47\xe5\x09\x01\xff\x80\x0e\xb9\x25\x9f\xa2\x47\xfb\x23\xbd\x3d"
          "\x2f\x9b\x15\x94\x3b\x52\x30\x83\x38\x46\x35\x80\x80\x64\x86\xfb\x17\xba\x82\x3d\x0e\x5b"
          "\xce\x3f\x59\xb8\x70\xd8\x82\xf8\x84\x46\x11\xe2\x15\x8e\xf9\x6b\x99\xe1\x91\xa8\x6f\x34"
          "\x08\x35\xe6\x44\x8d\x82\x5e\xcf\x2c\xed\xe3\x56\x07\x00\xf2\x12\x2d\xb0\x27\x4c\x56\x79"
          "\x36\x7a\xc8\x72\x31\xff\xc5\xa1\xd8\xce\x00\x28\x93\x89\xc3\x3e\x63\xcd\xf5\xed\x1d\x5a"
          "\xfa\xfd\x07\x28\x04\x5c\x20\xe8\x1a\xa4\x8c\x06\x2b\x4d\x5c\xba\x3d\x42\x02\xf3\x15\xe4"
          "\xfd\xd9\x9b\x59\x51\x91\x27\x6c\x33\xae\xc5\xbe\xe4\x1a\xf1\xa6\x07\xfa\x41\x0d\x06\x1c"
          "\xbf\x0b\x61\x64\xdb\xd8\xf1\x13\x8d\xb2\xf7\xbe\xdc\x49\xd1\xc2\x5c\x8d\xfe\xae\xcc\x2f"
          "\xbe\xb4\x9c\x32\x4b\xa6\x18\x98\x45\x34\xf6\x14\x8d\xe3\x38\xe3\xc6\x07\x9e\xba\x8b\x6e"
          "\xa7\x1f\x4c\x45\x84\xbd\x81\xca\x7f\x09\x78\x53\x4a\x6b\x59\xac\x86\x32\x4e\x3e\xbc\x51"
          "\x86\x75\xc6\xd1\x76\x50\xae\xd3\x80\x2c\xd2\x66\x53\x52\x78\x61\x63\xe2\x67\x0f\xb8\xad"
          "\x5f\x34\xf7\x6e\x1d\xe9\x81\xba",
          "\x4d\xae\x0c\x71\xba\x66\xb9\x6b\x6b\x3b\x98\x4b\xdf\x62\x12\xe5\xf8\x04\xac\xa0\x79\xb9"
          "\xd7\x75\x4b\xaf\x46\xbb\xce\x5d\x49\x39\x6f\x03\x90\x80\x4c\x3d\x5a\x4c\xa2\xf1\x67\x29"
          "\x95\xcc\xeb\x25\x03\x4f\xfb\x05\xa8\x43\xff\x5d\x3e\x46\xd1\xf2\xfe\x80\xf6\xa7\x5a\xa2"
          "\x80\x5c\xd3\x81\x2d\xc9\x8c\x35\xf0\x6b\x81\xa9\xf6\x6c\x42\x68\x71\xc7\x5a\x99\xa7\x91"
          "\x44\x37\x68\x05\xea\x7d\x5b\x13\xe3\x73\xd7\x05\x95\x8a\x08\x09\x39\x9d\xa9\x08\xcf\xe8"
          "\xde\x9d\x6f\x33\x9d\x55\x68\xec\x53\xbd\x87\x15\x5b\xaf\x7a\x00\x8d\x1a\x9b\x7d\x72\x15"
          "\x2a\x82\xe4\x19\x8b\xf8\xcf\x43\x10\xde\xea\xee\xad\xc4\x1c\xef\xff\x88\x85\x05\x25\xfd"
          "\xcd\x70\x1d\xdc\xd7\x8e\x20\x08\xbe\x88\x2d\x01\xda\xde\xbe\x0b\x45\x1e\xf7\xd0\x64\xf6"
          "\xa1\xc9\x62\x1b\x55\x26\x11\x21\x25\xe4\xfc\xe7\x25\x7d\xa8\x83\xc5\x5f\x7c\x9a\xa7\x29"
          "\x3e\xc8\x44\xa2\x08\xd1\x89\x61\x4a\x62\xe3\xcd\x8d\xc3\x94\xb5\x69\x1f\x18\x86\x12\xb8"
          "\xa3\xc7\x93\xa5\x49\xa3\x0d\xb5\xb6\x6c\x6b\xbd\x2b\x2d\xe4\xa1\xa5\x6e\xca\x32\xaa\xe0"
          "\xba\x6a\x2b\xe8\xe9\xff\xc3\xbc\x46\x75\xa1\x9f\x47\x05\x54\xf9\x05\x74\xb5\x8b\xea\x39"
          "\x05\x35\xb9\x5c\x96\x37\x27\xc5\x2b\xb6\x7d\xcf\x1e\x4b\x99\x11\x7e\x0e\x2a\xa0\x52\x36"
          "\xed\x6f\xf3\x7f\x78\x7b\xac\x46\xb2\x9c\xf7\x2d\x35\x21\x88\x1c\x7f\x72\xdd\xc6\xc4\x0f"
          "\x18\x71\xa7\x2f\x21\xa7\x35\xeb\x20\xc4\x88\x99\x9a\x5b\x18\x8d\x6b\x58\x88\x1e\x39\x15"
          "\x7b\xac\x96\xbe\x15\xec\x05\xb2\xc2\x06\x10\x9f\xa6\x30\xd7\x27\xec\xfe\x4e\x75\x8c\xba"
          "\x9f\x6e\x84\x80\xfd\x7a\xf1\xfc\x68\x9f\x9e\xf0\xbc\xd3\xb8\xa3\xec\x4e\x00\xa6\xed\x87"
          "\x70\x3d\xe4\x15\x2c\x8d\x3b\x79\x83\x2b\x1f\x4f\x4e\x63\xfa\x4f\x59\xe1\x19\xb7\xa4\xdd"
          "\xb7\x4b\x6e\xad\xdf\x11\x85\xf6\xd5\xcb\x38\xe7\xaa\xf7\x92\xa3\x55\xd1\x89\xdc\x85\xc9"
          "\x22\x58\x58\xa1\x9c\x51\x4f\x45\x22\xad\x6b\x10\xee\x4b\x16\xcd\xf2\x1e\x14\x1b\x73\x96"
          "\xf0\x12\x63\x86\x05\x75\x0a\xc9",
          1, 3584 },
        { 128, 192, 60,
          "\x02\x30\x2c\x26\x9c\xd9\x05\x1d\xa2\x87\xa4\x76\xe4\xe0\xa4\x79\x52\x7f\x2d\x45\x62\x4d"
          "\xa8\x9f",
          "\xab\x7d\xe5\x19\x98\xc9\xb6\x11\xee\x70\x42\xec\x0a\x95\xbc\x35",
          "\x35\xf3\xba\x86\xd9\x68\xc0\x52\x5b\xe3\x1c\x3e\x10\x70\x77\xae\x67\x92\xb1\x80\xd6\xd2"
          "\xa0\x83\xc7\x3e\xd3\x24\x79\xdf\x09\x5e\x29\x11\xbb\x4b\x8f\xb4\x48\xcf\x13\x53\xd8\x54"
          "\x9e\x68\xab\xdc\xeb\x98\x77\x89\xa3\x13\x86\x8b\xe4\x25\x67\xcb\x80\x06\xcf\x1d\x1d\xf0"
          "\x02\xa0\x0e\x92\x65\xcc\x6c\xdf\x6e\x4c\x36\x4e\x7c\x8e\xe0\xd0\x0b\xac\xd1\xae\x94\xe0"
          "\x19\x3b\x3a\xbe\x7e\xd5\xdc\xbb\x78\x78\x42\x2b\x7a\x73\x55\x1c\xc2\x3f\xdf\x37\x3c\x18"
          "\xa6\x6a\x6c\x9a\xf1\x3e\x5f\x1f\xaf\x2c\x4b\x29\x6d\xc7\x0b\xa8\xff\x2f\x84\x0f\xc8\xc9"
          "\x3a\xb6\x2d\x8a\xfa\x26\xb1\xe3\xf2\x55\xc2\x3c\xf9\xf1\x45\x1b\xb3\xd4\x68\xad\x98\x77"
          "\xda\x2c\xaa\x06\x22\xd4\x04\x5f\x01\xba\x91\x4a\x92\x91\xd6\x7c\xf8\xc3\x2c\xc3\x16\x19"
          "\x22\x08\x3c\x20\x88\x96\x9e\x32\xb5\xf9\xd5\xcc\x3e\xe7\x78\x1b\xfd\x2f\xe3\x14\xe6\xcf"
          "\xe3\xb1\x82\x18\xbe\xb1\x81\xc5\x9f\x03\xce\xda\xe1\xf5\xbb\xa7\x91\xe6\x50\x38\xac\xb5"
          "\x62\xd1\x2a\x8b\xbd\xcf\xff\xca\x77\x42\xf2\xa2\xd8\xee\x67\xee\x0b\x54\x92\x1a\xdb\x16"
          "\xfe\xbb\xdf\xff\xf2\x60\x85\x15\x44\xd6\x96\x41\xcb\xe5\x54\x69\x8a\x5c\x77\x96\xf0\xf1"
          "\x66\xbd\x5c\xbc\xa2\x2a\x14\xca\x69\x45\x8c\x47\x31\xcd\xab\x08\xfe\x7c\x65\x6b\x90\x12"
          "\x7f\x59\xeb\x95\x9b\x43\x2f\x53\xfb\xfb\x2b\x80\xaf\x06\x9b\x3f\xcb\x7b\xf2\xe8\xdb\xe4"
          "\x4d\xef\xea\xe1\x1f\xa6\xa2\xec\x24\x45\xa3\xae\x44\xec\x31\x8c\xea\x6e\xc8\xff\xe6\x51"
          "\xbb\xb7\x8a\x84\x40\x9e\xa3\xb9\xd9\xc5\x23\x5b\xa4\x01\xe9\x92\x50\xfd\x00\x46\x7c\x71"
          "\xf2\x12\x1c\x7f\x54\x18\x8f\x54\xb7\x18\x24\xb2\x45\xce\xfb\xd2\xc4\x10\x5e\xe3\x49\x49"
          "\xd1\xbc\x7e\x5c\xa1\x81\xe4\xb9\x1f\x62\x2c\x05\x6a\xda\xcd\xfd\x24\xdf\xa0\xd9\x0a\xda"
          "\xfc\xd5\x89\x90\x0b\x25\x0d\x4a\xe8\xe0\xd7\x59\x4a\xee\x75\xa4\x54\x9c\x4f\x58\xbe\x9b"
          "\xcc\xd6\x9c\x04\x44\xce\x78\x44\x57\xf6\x08\x51\x86\xc0\x23\xe4\x18\x7c\xf7\xfe\x81\x58"
          "\xbd\xc3\xa0\x7b\x44\xe7\xb1\xb6\x4e\x14\x9d\x47\x07\x7b\x04\xe2\xde\x47\x25\xba\x0d\x77"
          "\x4c\x8b",
          "\x36\x6a\xc8\x0e\xe1\xae\xff\x06\xb9\x29\xc7\xcf\x10\xde\xd1\x5e\x63\x48\x70\x11\x3a\xa7"
          "\xcc\x9d\xf4\xc7\xde\xd1\xe2\x29\xec\xea\x16\xf4\xa6\x97\x0c\x0d\xa6\x89\x9e\x71\x73\xbc"
          "\x0c\xe2\x3a\x9a\xdb\xd0\x72\x44\xef\xb7\x8f\x47\x4c\xc0\x71\x38\x7a\xfa\x65\xfc\x7d\x5c"
          "\xff\x84\xaf\xa0\x63\x31\xea\xe2\xb4\x83\x8d\xe4\x5e\x32\x68\xf1\x6f\x42\xf7\x32\x3c\x1a"
          "\x5b\x88\x47\xc5\xc2\xce\xce\x1a\x45\x69\x35\xe0\xf2\x9b\x3e\xec\x46\x1f\xed\x02\x5c\x5c"
          "\x58\x74\xfb\x3f\xa4\xf8\x2d\xa1\x35\xcc\xf4\x05\x53\xcf\x9c\x69\x2c\x5a\xd3\x9b\x0a\xd6"
          "\x46\xb8\x23\x0e\x76\x9f\xc4\x54\xd5\x02\x0c\x49\x2a\x4a\x6a\x21\x29\xf6\x04\x35\x60\x01"
          "\xd2\x9b\xbb\x90\x96\x70\xda\x50\xc6\xa8\x4d\x5c\x3c\xaa\xb4\xa3\xe9\xb8\x57\xf4\x9c\x7d"
          "\xce\x50\x99\x98\x27\x41\x25\x36\x5c\x7e\x98\x98\xbf\x21\x22\xfb\xf9\x4e\x12\x4f\xa8\xdb"
          "\xe6\xcd\xdf\x98\xc2\x1a\x0e\xfa\x3a\x25\x4f\xcb\x50\x9b\x9c\x22\x8d\x38\x68\xab\xb2\xd1"
          "\x37\x00\xc8\x42\x09\xe5\x55\xa9\x04\xde\xfe\x99\x20\x2c\xe6\xde\x0e\x43\xa7\x3f\xb3\xac"
          "\xc6\xa0\x66\x84\xcc\xfe\xb6\x89\x8f\x7f\x9c\xfc\xc2\xd6\x32\xa1\xf7\x6d\xaf\xb8\x34\x90"
          "\x92\x77\xe0\x61\xcd\x4c\x74\xe6\x01\xa8\x23\x07\x67\xd1\xfb\x32\x72\x7b\x6a\x53\xa9\x4f"
          "\xc7\x15\x41\x9d\x14\x6f\x03\x36\x05\x55\xcf\x94\xd8\x83\xf9\x13\x17\x91\xa7\x7b\x5f\x3b"
          "\xd1\xea\xf5\xf6\x16\x4d\x15\x4a\x49\xe0\x91\x39\x1f\x68\xf7\x28\xb9\x8c\xa4\xa2\x5b\x80"
          "\x85\xab\xaa\xfb\x07\x69\x52\xc1\xf8\x3d\x75\x4d\x53\xbf\x71\xe5\x5c\x47\x44\x72\xe6\x26"
          "\xdf\x97\xe2\x29\xad\xcd\x3a\x79\x16\x6a\xe3\xba\xbb\x98\x42\x7e\xb4\x81\xaa\xdb\xf9\x3d"
          "\x60\x06\xc0\xa0\xb5\x5c\x74\xdb\xbb\xa1\x03\xca\xd9\x69\xc0\xb5\x47\xb7\xc5\xf8\xc0\x67"
          "\xc5\x58\x24\xb7\x3e\x31\xc9\x48\x49\x9b\xb2\xe0\x63\xf7\x5a\x4e\xc9\xb5\xa6\xe0\x25\x87"
          "\xc4\xd6\x2d\xb2\xd0\xca\x3d\x63\xc4\x46\x2a\x00\x1d\xf7\x56\xcf\xe1\x0c\xfd\x7d\x5b\xb4"
          "\x97\x29\x40\x82\xaf\x9c\x4c\x2b\x5c\xa1\xf8\x3a\xe7\x06\x52\x29\xcf\xf1\xf0\xdc\x2d\x3e"
          "\x7c\xfc",
          1, 3712 },
        { 128, 192, 61,
          "\xf1\x4a\x65\xe4\x87\x80\xd9\xaa\xc6\x4d\x6e\x79\x0f\xf3\xac\x2e\x28\x7d\xec\x10\xd4\xb6"
          "\x50\xf9",
          "\x72\xb3\xc4\xe0\xe7\x7a\x74\x69\xdd\x80\xc1\xe2\xbf\x73\x6a\xd3",
          "\xc9\xa5\x2c\x9b\xb5\xd1\xf6\x16\x32\x26\xb2\xcd\x70\x54\x13\x28\x9c\x79\xcc\xa2\xe6\xb7"
          "\x8a\xa9\x6c\x88\x20\x30\x96\xe4\x7f\x22\x1c\xf8\x20\x19\x50\xb8\xfc\xc6\xc5\x76\x9b\x08"
          "\x2e\xea\x7d\x8e\x45\x40\xe7\xc6\xfb\x18\x6d\x9d\x8e\xe4\x56\xa5\x45\xca\xc6\x91\x20\xd3"
          "\xee\x86\x50\xa9\xb8\x96\x01\xd5\xf7\x03\x0f\x88\xaa\x41\xae\xd8\xdb\x22\x3a\x01\xa0\x29"
          "\x04\x6d\x0a\x76\x7d\x41\x59\x68\x5e\x5a\xed\x0a\x4d\x14\xf2\x1d\x8c\xbc\x6b\xf8\x6b\x59"
          "\xd7\x9d\x1f\xea\x81\x5a\xc4\xff\xf6\xa6\xf4\x9f\x1c\x0d\xf8\x07\x89\x9b\x39\x47\x48\xb1"
          "\x6b\x7f\xed\x40\xd1\x16\x7a\x64\x79\x89\xd0\x88\xf7\xce\x7a\x55\x03\xf9\xd9\xb4\xda\x5a"
          "\x93\xa2\x7b\x67\xd4\xef\xde\xf1\x3a\xa9\x0f\xea\x61\x49\xfb\xcb\x97\x19\x6d\xbc\xbc\x32"
          "\x07\x5b\x8c\x6c\x03\x12\x1a\x2d\x92\x77\x36\xfd\xe1\x3b\x33\x60\x4e\xef\x1f\x86\xc5\x03"
          "\x25\x2b\x2e\xc7\x53\xac\x52\x94\x80\x7c\x48\x1d\xbe\x41\xa7\x63\xe3\xd9\x73\x66\x1e\xcb"
          "\x68\x7b\x9f\xd1\xfd\x3c\xa4\x3f\x7c\x48\x03\x90\xda\x73\x8e\x64\x3d\x53\x7e\x1e\xa4\x5d"
          "\x01\xfd\xa0\x2f\x62\x59\x65\x49\x94\x52\x85\x80\xf2\x1d\xd6\x24\xa6\x7b\xaf\x3d\xf3\xc5"
          "\x61\x60\x29\xb9\x40\x4a\x89\x5c\x3b\x87\x86\xd4\x3a\x18\xfa\x61\xdf\xe6\x59\x0a\x75\x94"
          "\xf7\xc9\x34\xc3\xc1\x12\x48\xba\x8d\xbe\x68\x37\xdf\x0f\x61\xa8\xba\x7e\xf3\x98\xbb\x3e"
          "\x25\x56\xc9\xf9\xa4\x06\xcd\xcb\x01\x65\x68\xa0\xde\x75\xf1\xac\xa8\x67\x60\x83\x71\x1c"
          "\xab\x2b\xaa\x21\x08\x8c\x84\xa2\x6d\x04\xae\x0a\xb3\x44\xf0\x17\xaa\xf7\x2b\x3b\x78\x6c"
          "\x14\x28\xf5\x9d\x81\xf4\xe6\xe0\x3c\x8d\x58\x2b\xd3\xf9\xb5\x8a\x2f\x9e\x9c\x48\x46\x54"
          "\x31\xda\x0e\xaa\x6d\xb1\x52\x21\xc0\x57\xec\xca\xcd\x6c\x4c\xd5\x64\xbd\x32\xc3\xb1\xc3"
          "\xef\xf2\xe7\x77\xf2\x3d\xf3\xca\x70\x5e\x6f\x54\xc8\xeb\xde\xbe\xb4\xfb\x16\x77\xa0\xb7"
          "\x84\xfa\x63\x10\xe2\x20\xe1\xb5\x24\x15\xee\x41\x89\x4e\x00\x0c\x17\xe0\xe4\xa1\xc2\xfe"
          "\x1a\x15\x2a\x29\x45\x36\x14\x7b\xa9\xb5\xc6\xb9\xfe\x5e\x9a\x00\x67\xc4\x66\x87\x09\x4c"
          "\x69\x22\x0b\xaf\x38\x49\xa3\x7b\xbb\xd3\x60\xcf\x48\xe3\x2c\x54\x00\xba",
          "\x4e\x49\x87\x91\xe2\x3b\x79\x08\x79\x59\xbc\xb9\x0d\xd9\x86\x7b\xff\x28\x17\xfe\x08\x3b"
          "\x84\x33\xbd\x3e\xa7\x2d\xd9\x78\xec\x59\xb3\x80\x0d\x06\x7f\x72\x54\x53\xec\x22\x76\x13"
          "\xd8\x53\x80\xab\xfc\xf9\xec\xad\x9d\x91\x73\x22\xe6\xb5\xe8\xcd\xab\xd2\xf8\xb6\xa1\xa2"
          "\x14\x9e\x00\xbd\x3e\x97\x99\x41\x3a\x03\xb3\xbc\xe2\xdc\x29\x6a\x70\xb0\x6d\x6d\xd7\x97"
          "\xf0\x74\x75\xbe\x3b\xa1\x8a\xdd\x88\x93\x88\x8c\xf8\x7d\x97\x9c\x95\xb3\xed\x2e\x17\xd6"
          "\xd5\x69\xc0\x11\x82\xcc\xaa\xb7\xf8\xde\x22\xfa\x15\xf0\xf5\x56\xb1\xda\x85\x4b\x29\x9b"
          "\xfa\xbf\xad\x4e\xa3\x71\x79\xab\xae\xe2\xf9\xae\x18\x12\x0d\xfd\x8f\xd3\x2f\x2d\xfa\x03"
          "\x4c\xdf\x5b\xfd\x78\xaf\x6c\x57\x0c\x8c\x2c\x9a\xb5\x91\x23\xaa\x76\x5e\x3f\x01\x02\x33"
          "\xed\x39\xae\xff\x93\x39\x24\x4d\x71\x1f\xa7\x1f\x1d\xc3\xc8\xe2\xd9\xb8\x2a\xf2\x38\xc8"
          "\x5e\x00\x01\x70\x21\x5b\xc3\x55\x93\x63\x78\xee\x8e\x6b\x81\x0d\x8b\xe9\xe3\xf8\xf4\x0d"
          "\x73\x64\x54\x15\x63\xc4\x12\xd3\xc6\x10\x95\x6b\x91\x45\x14\x7b\x0f\x29\x0f\x6f\xcb\xe9"
          "\x13\x32\x3d\x63\x94\x83\xe0\x54\x76\x5c\x6c\x54\x72\x6d\xbd\x9b\x48\x24\x12\x38\x98\xeb"
          "\xdd\x5b\x3c\x9f\xe7\x60\xa2\x08\x0d\xdd\x60\x41\x27\xf5\x53\xa0\xca\xe6\x31\xdf\x8c\x66"
          "\xbf\xb9\x38\xb5\xc7\xf6\x44\x60\x47\x15\x23\x00\x02\xd4\x78\x69\xb5\x01\x32\xaf\xd7\x13"
          "\xd7\xa9\x15\x45\x1e\x8a\x7e\x28\x52\x8e\x9a\xf9\x49\x79\x91\x54\x2b\x25\x33\x60\x7f\x65"
          "\xd3\x7e\xbb\x0a\x7a\xd2\x9d\xb2\x91\xc7\x03\x4a\x8c\xc9\x0a\x89\xeb\x6e\x38\xb2\x9b\x58"
          "\xd0\xdc\xcd\x32\xd5\x3e\xac\x84\xda\x44\xf2\x79\x3b\x97\xc7\x11\x3b\x88\x03\x27\xbd\x13"
          "\xc7\x45\x06\x97\x31\x64\x98\x65\x47\x51\x3d\x8f\x20\xd9\x5f\x31\xba\x54\x9c\xd1\x38\x9b"
          "\x55\x10\x22\x5f\xa4\xa8\xf3\x84\xf9\x28\xe4\xec\xc3\x3f\xda\x18\xbb\x3f\x4c\x88\x92\x61"
          "\x23\x6c\x6a\xec\x09\xed\xf5\xb7\x92\xbd\xfd\x3c\x13\x38\x79\x12\x98\x38\x50\x29\x81\x2f"
          "\x7c\xc4\x73\xee\x81\x7f\x8c\x21\xea\xde\xe1\xc0\x92\xcb\xb2\x67\xf9\xfd\x46\x17\x1a\x60"
          "\xbe\x57\x0b\x96\x6e\xa7\x78\xb7\xec\x1b\x91\xd5\x0e\x55\x44\x16\xfe\x44",
          1, 3840 },
        { 128, 192, 62,
          "\xe8\x3c\xfb\x36\xe7\x17\xb3\xea\x26\x68\x3a\x51\x24\x2d\xa6\xb9\x8c\xdc\x10\x8c\x6d\x7f"
          "\xfc\x3f",
          "\x7c\x7e\xa1\xad\xf5\xc3\x99\x7b\x17\x6f\x17\x99\x59\x22\x6f\xbd",
          "\x22\xc8\xd0\xea\xae\x1c\x50\x0d\xb4\xc5\xef\xac\x37\x10\xdd\x52\xef\x0f\x4e\x5d\xaa\x8d"
          "\xd1\xba\xbc\x58\x3f\x5c\x0c\xad\x36\x64\xf7\x6b\x87\x04\x28\x25\xa2\xca\x90\xd2\x0e\x38"
          "\x14\xcc\x60\x96\x27\x51\x7f\x33\xa7\xcf\x31\xe4\x94\xc8\x02\x67\x27\x92\xbf\x23\xd1\x7a"
          "\xc5\x10\x12\x18\x57\xdd\x4c\xb8\x55\x0c\x11\xd3\xc8\xa7\xec\x30\xd7\xdb\x09\x60\x74\xe3"
          "\xc5\x6e\xd9\x5e\x0c\xdf\x8d\xe5\xe1\x36\x8e\x4a\x2f\x7b\xa5\xfe\x40\xd8\xc3\x0d\x63\xc1"
          "\x63\x00\x8b\x5c\x81\xef\x16\x80\x71\x34\x4e\xf2\xc5\x53\x56\xd7\x92\xb9\xb9\xf4\xf3\x15"
          "\x8d\x0c\x20\x59\x1e\xcb\x4a\x23\x04\xb3\xaa\xc9\x0d\xc7\x7b\xc2\x03\xf8\x80\xf9\x3f\x94"
          "\xf9\x07\x62\x34\xa9\x25\x6b\xf5\x53\x89\x02\x08\x84\x8b\xca\x29\x5d\x26\x2c\x8f\xb9\xb7"
          "\xc6\x9a\xe5\xfd\x47\xa5\xdc\x2e\x45\xf7\xcd\x56\xc2\x24\xff\x55\x5d\xca\x0c\x82\x5c\x34"
          "\xb4\x8f\xe7\xbf\x8f\xcb\xa6\x3c\x4d\xa7\x64\xf8\x79\x59\x1e\x60\x2e\x51\xe7\x33\xe4\xff"
          "\x94\x46\xff\x05\x25\x25\x7e\xd1\x6a\x4f\xe0\x14\xb9\x67\x62\xe7\xc8\xc3\x97\x7d\x33\xf7"
          "\x3d\xa2\x48\x16\x2d\x3f\x27\xe4\x05\xea\xf1\x5c\xcb\xed\xa1\x44\x2c\x33\x7b\x61\xc7\x00"
          "\x69\xb7\x64\xe3\x2d\x94\x6a\x12\x27\x6f\x9a\x8e\xac\x27\xc3\x80\xfb\x42\xba\xb0\x08\xea"
          "\x6b\x65\xe0\xa9\x02\x8e\x4a\x77\xe1\x31\x08\x32\xa0\xd5\x91\x34\x64\xad\x3a\x13\x5c\x71"
          "\x04\xa7\x0d\xaf\xff\xe1\xf2\x81\x53\x08\xa4\x95\x93\xc2\xa5\x17\xa0\xf5\x5e\xa8\x43\x3d"
          "\x37\xc7\xea\x4e\x9b\x95\x91\xbe\xbe\x25\x66\x1b\xc2\x55\xb8\xd2\x06\xdf\x16\x5e\xe9\xf3"
          "\xc8\xcc\x12\xa2\x2c\xfc\xf7\x00\xdd\xcc\x28\xbb\x35\xae\xe1\x61\xb0\x5e\x3e\xdb\x9f\xe4"
          "\x8e\x96\xbc\x8e\x70\x96\x5e\x0a\xf1\x9e\x84\x2e\x06\xc8\xe0\xfd\xee\x55\x93\xa6\x10\xb8"
          "\xc9\x06\x6d\x84\x9e\x58\xff\x9a\x98\x21\xb9\xf4\x08\xf3\xb3\x27\x01\xdd\x86\xf8\xa0\x3c"
          "\x28\x36\x4a\xac\x70\x7d\x45\x2f\xf2\x25\xc3\x39\xa5\x50\x5e\xcc\x89\xb8\xe9\x39\x09\x85"
          "\x91\x26\x39\x6a\x89\x26\xf8\x55\x6c\x32\x72\xd8\xbc\x17\x3d\xfe\x57\x05\x7b\xaa\xdc\xd7"
          "\xc5\x31\xb4\xa8\x04\xfe\x2c\xfa\xe5\xc7\x58\x5b\x12\xb0\x58\xee\xf6\x50\x9c\x6c\x9f\x95"
          "\x63\xe5\x4f\x40\xd1\x66\x5e\xa8\xe2\x56\xcd\xea",
          "\xfe\x3c\xdb\x89\xc6\x6f\x2e\x2d\x03\xed\x0e\x6c\xa2\x60\x9f\xd1\x43\xfb\xf1\xa2\x43\x3f"
          "\xea\x5f\x9d\x39\x2b\xcd\xdc\x6b\x65\x2a\xc3\x62\xc3\x9d\x83\x4e\x9b\x8b\x2d\x61\xc5\xb5"
          "\x9f\xb9\xed\x4c\x20\x44\xf3\x72\xd7\x37\xe3\xc8\x4d\x48\x74\x0d\x6e\x01\xe8\x21\x2f\x70"
          "\x16\x88\xee\xe9\x3f\x4f\xf8\x9d\xbd\xb5\x80\xf9\x58\xc9\xdc\x93\x45\x0f\xe3\x78\x5e\x2e"
          "\xaa\x21\x1e\x80\xfd\x8b\xf9\xc6\xcf\xe6\xed\xcd\x1b\x35\xdf\x0f\x9d\xd8\x1d\xe2\xaa\xd7"
          "\x0c\x6a\x1e\x3e\xe2\x18\xb0\xc0\x64\x0d\x8e\x6c\xe5\xf1\x41\x17\x7e\x22\x22\xd8\x66\xe2"
          "\xf9\x0e\x17\xb3\xea\x2c\xce\x91\x9d\x49\x07\xaa\x82\x13\x20\x8d\x0b\xe4\x06\xa9\x44\x99"
          "\xf2\xa0\xa3\x2f\x93\x84\x39\xe1\x57\x21\xfa\xff\xba\x1e\xd4\xb9\x8a\x7f\x0a\x25\xc6\x0e"
          "\x73\xc7\x93\x70\x0a\x57\xa1\xb6\x4e\x7b\x67\x33\x70\x4d\xcd\xad\xf0\x7a\x3b\x72\xca\x2d"
          "\x86\x55\x9e\xe0\xbb\xbc\x7c\xe8\x68\x5e\x84\xa6\x54\x5a\x46\xcd\x19\xf3\x9c\x42\x68\x13"
          "\x2c\x14\xe6\x38\x65\xed\x99\xe2\xd9\x4e\xa3\xaf\x9e\xe6\x55\x6d\xeb\x3c\xa9\x92\x2b\xd0"
          "\x14\x47\x53\x4c\x6a\x0b\x88\x6f\x0f\x06\x10\xc3\x1f\x08\x99\x40\x16\x59\x7c\x2f\xd7\x86"
          "\x10\x9b\x7b\x4f\x0c\x56\xe4\x01\x0f\xc2\x0f\x64\x9e\x61\x00\xf1\x87\xd6\x1e\x75\x4c\x75"
          "\x3b\x30\x1b\xe3\x46\xed\x51\x94\x1b\x70\x50\x9c\xd3\x19\x91\x78\xda\xed\x3c\x0d\xdd\x3f"
          "\x4a\x27\x9d\x05\xec\xac\xca\xa1\x78\xaf\x91\x27\xcf\x21\x7c\x27\xd3\xf4\xa4\x72\x44\x91"
          "\x5f\x3e\x4f\x60\xc7\x86\x76\x4a\xb6\xd3\x57\xb1\x89\xdb\x3d\x26\x0b\xd0\x21\x8b\x95\x2a"
          "\xd9\x34\x4d\xd3\xd7\xd5\x02\x8c\x1a\x0c\x88\x3d\xa9\x2d\x48\x2e\x53\x7c\x71\x5a\x1a\x6d"
          "\x8b\xf4\xe4\xda\x0b\xd4\x28\xd3\x66\x06\x09\xdb\x50\xcd\xe8\xcf\x8c\x48\xd6\x7f\xf8\x57"
          "\x9e\x40\x6c\x16\x27\xce\xde\xbd\xb3\xb7\x27\x2d\x1b\xec\x0a\x6f\x34\xca\x68\xdf\xfa\xa4"
          "\x84\x33\xf5\xc5\xc5\x77\x1d\x72\x92\x6d\x68\x93\xbf\x49\x26\x3c\xd4\xe3\x50\x34\xcf\x85"
          "\xf9\xd7\x64\x05\xec\x88\xbb\xe8\xf2\xdb\xbf\x05\x95\x51\x76\x49\x95\xd5\x6b\x83\xcf\x76"
          "\x8d\x31\x52\xf5\xc4\x7b\x8e\xbd\xcd\x1a\xf3\x6c\x95\xc9\xc1\xe2\x4b\x14\x51\xca\x4b\x0b"
          "\x7e\x31\xfa\xdb\x3d\x37\x51\xbb\xb7\x3a\xaa\xc7",
          1, 3968 },
        { 128, 256, 63,
          "\x59\xc2\x0f\x2a\x22\x34\xaa\x96\x4e\x64\x1a\xb8\x7f\x88\xe8\xee\x40\x1e\x3e\x34\xf8\x2a"
          "\x89\x03\x29\x59\x1f\xf9\xb5\xf1\x06\xe8",
          "\x1e\x07\x48\xe9\xf1\x19\x7b\xf1\x02\x5b\x35\xbe\x74\x96\x8a\x99",
          "\x52\xf4\x07\x4a\xa6\xe7\xd0\x81\x99\x6e\x47\xdd\xc2\x29\x39\xde",
          "\x24\x16\x23\x0e\x57\x6a\x79\xbe\xfe\xb6\x20\x72\x0d\xb5\x6e\x2a", 1, 128 },
        { 128, 256, 64,
          "\x83\xbc\x79\x24\xb7\x28\x6c\x92\xca\xdd\x01\x71\xa7\x0a\xa5\x76\xe7\x31\x19\x05\x42\x27"
          "\x00\x98\x85\xd5\xb0\x46\x3c\x29\x54\xcc",
          "\xc6\x00\x0d\x3d\x5a\x57\x80\xe4\x86\xf8\xc9\xba\xc9\x19\x75\x78",
          "\xfc\x11\x04\x58\x99\xda\x80\x33\x47\x93\x13\x27\x19\xb4\x2f\x85\xfd\x27\x5f\xf8\x2a\x31"
          "\x4f\x6a\x58\xb2\x66\x5c\xfb\x09\xdb\xcb",
          "\x9e\x65\xcc\xbe\xa5\x31\x19\x46\xfb\x8d\xd7\x96\x44\x27\xe9\xc6\x24\x13\xb3\x64\x33\xca"
          "\x8c\x0e\xe7\x2d\x11\x98\x0c\x91\x08\x42",
          1, 256 },
        { 128, 256, 65,
          "\xa5\x7a\xac\x01\x43\xe7\xa6\x5e\xe5\x67\x4f\x76\x52\xba\x89\x48\x6f\x34\x8e\x6c\xba\xb9"
          "\x47\x7f\x1f\xab\x3b\x3c\x14\x14\xaf\x52",
          "\x1b\x24\xd7\x08\x12\x62\x9b\x6d\xaa\xc0\xf8\xc7\xa6\x5d\xa0\x71",
          "\x1b\xe6\x86\x92\xd6\x6a\xdf\x9b\x45\x69\xfc\x73\x33\x17\x30\xa6\x75\xc5\xf3\x3e\x2d\x6d"
          "\x33\xae\x8d\xad\x7e\x15\xc0\x29\x12\x78\xe2\x5a\x64\xaf\xd1\x1f\x93\xc1\x05\x96\xc4\x12"
          "\xd0\xdb\xde\xc4",
          "\x00\xa6\x91\x4c\x9c\xbb\x37\xc6\x9e\x46\x15\x74\x50\xdd\x00\x68\x39\xc8\x74\x22\xa8\x1c"
          "\xaa\x86\x80\xb6\xac\x33\x36\x5c\x01\x76\xb6\x12\x8c\x27\x6d\x73\x4f\xa3\xca\x6a\x7d\xee"
          "\x23\xe4\x17\x21",
          1, 384 },
        { 128, 256, 66,
          "\xc4\xbe\xf6\xb3\x9c\xd7\xe1\xf1\x2f\x7f\xe7\x85\xc3\x26\x01\xbd\x1d\x2c\x06\x28\xac\xb2"
          "\x6e\xb7\xa3\xed\x23\xa9\xde\x4c\x2b\x04",
          "\x60\x3e\xe3\x70\xbb\x16\x52\x5d\xf1\xaa\x07\xef\xd3\x12\x54\x1b",
          "\x92\x1e\x70\x2e\x89\x9d\x99\xa9\x8c\x7d\x0a\x48\x5b\x67\xb7\xb8\xe5\x79\x06\x4a\xee\x47"
          "\x0c\x4c\xac\x0a\xde\x6f\x0d\xe2\xe3\x8c\x36\x8a\xde\xc3\xd3\xff\x5c\x44\xef\xe6\xce\x4b"
          "\xad\x28\x7d\xcc\xf6\x7b\x81\xb3\xbc\xa4\xdd\x04\x52\x14\xb3\x9d\x2b\x3e\x79\xdb",
          "\x86\x31\xab\x41\x11\x3a\xe4\x1f\x2b\x21\xb6\xd9\x64\xd0\x7e\xce\x6c\x45\xd7\xed\xc9\x4c"
          "\x4b\x28\xc2\x66\xbf\xaa\xbe\xfe\x17\x2c\x20\xf3\x74\xf5\x77\xfc\x09\x24\xdf\xcc\xc1\xbe"
          "\xd0\x35\x13\x9f\x1c\xaf\x3c\x67\x86\xe8\x45\xc8\x14\xe0\x59\xb3\x20\xbb\xed\x56",
          1, 512 },
        { 128, 256, 67,
          "\xbf\x7d\x06\x4f\x38\x32\xa8\x23\x92\xbb\x2b\x16\x40\xfe\x68\x97\xce\x48\xa2\x24\x1d\xc0"
          "\x0e\x0b\xfe\x36\xee\xc9\xca\xc6\x7f\x6c",
          "\x4a\x02\x9f\xb3\x04\x23\x4c\xe0\x14\x4f\x80\x24\x59\x30\xaa\xc5",
          "\x03\x5e\x31\xfd\x99\x35\xb3\x43\x61\xb9\xde\xc6\xa3\x61\x00\x23\xa3\xbc\x53\xb3\x99\x9c"
          "\xab\x85\x45\x5e\xfc\x09\x02\xc1\x0c\xb3\x3f\x77\x7c\x45\xf6\x1f\xe0\xd9\xa5\x4a\x02\xcb"
          "\x01\x55\x1f\x08\x64\xd9\xb5\x4a\xbb\x5b\x5b\xc9\xa3\x44\x28\x00\x0b\x69\x35\xaf\x42\xdc"
          "\x1c\xdc\xb7\xd8\xef\xcc\x41\xc6\x3a\x07\x45\x66\x9b\x97",
          "\xd9\xa5\x96\xb0\x2f\xd6\x71\x03\x65\x35\xe3\xb2\x20\x5d\x0c\x4a\x36\x43\xea\x3b\x07\x89"
          "\xbd\x84\xbc\x64\x19\xa4\xe4\x09\x61\xfa\x2a\xc9\xd5\x09\x7a\x62\xa8\x13\xf9\x59\x11\x8d"
          "\x6a\x24\xd1\x47\xa9\x87\x64\x35\xd7\xc0\x4e\x5f\xd9\x76\x5d\x55\xa6\x67\x12\x47\x84\xfb"
          "\x9b\x0e\xca\x91\x08\xf2\x14\xae\x17\x2b\x4e\x44\xf7\x82",
          1, 640 },
        { 128, 256, 68,
          "\x74\x64\x2c\x33\x19\xf1\xf4\x8a\xa4\x07\xd5\x25\x13\x33\x9e\x98\xf8\x60\xbf\x90\xdc\xac"
          "\x0b\x1b\x1f\xfb\xb7\xaa\xbe\x75\x8d\x4f",
          "\x1c\xbb\x9a\x4a\x0a\x2e\x16\xa7\xe8\x0f\x15\x99\x86\x01\xee\xbb",
          "\xea\xf9\x50\xcc\x57\x9c\x24\x4a\xec\x7f\x35\xee\x92\x7c\xf7\x73\xa9\x42\xec\xb5\x02\xd7"
          "\x38\xff\x32\xe5\x7e\x5d\xed\x68\x36\xfd\x34\xb1\x10\x1f\x19\x5b\xaf\x8d\xc1\x2c\x7e\xb6"
          "\x21\x34\x19\xa7\x9c\x3b\x3b\xb5\x83\x18\x68\xe2\x39\x19\xbc\x74\x8c\x37\x1d\x49\x14\xec"
          "\x9c\x0d\xa7\xa7\x77\x92\x97\xa7\xd5\x75\x2c\x99\x7f\x8a\xdd\x1c\x99\x20\x2b\xd9\x9c\x71"
          "\x0d\xba\x12\xfa\x02\xc4\xcf\x69",
          "\x81\x91\x8d\xb7\x42\x6f\x53\xdc\x6d\x49\x79\x01\xa8\x8e\x88\x4f\xa5\x7c\x10\x6c\xea\x93"
          "\xcf\xf0\x43\x01\x2d\x48\x2c\xd2\x64\x11\x01\x64\xac\x63\x3d\xa7\x69\xfd\xdf\x00\xe2\xf5"
          "\xb6\x9a\xd3\x93\x79\x54\xde\x30\x35\xb5\xa7\x8b\xc2\x30\x2e\x9c\xef\x20\x6e\x1d\x03\x27"
          "\x62\x47\xc3\x6f\x29\x38\x16\x3e\x24\x59\x45\xcf\xc3\xf1\xf1\x23\x86\x5d\x54\x8d\xc4\xf7"
          "\x63\x9a\xf0\x43\xce\x18\xd1\xd6",
          1, 768 },
        { 128, 256, 69,
          "\x5d\x59\xa1\x0f\xa7\x93\x40\x83\x0e\xdb\x20\xa9\x11\x8f\x76\xdd\x22\xc5\x9c\xa1\x45\xdb"
          "\x1a\x8e\xc7\x4d\xc4\xc6\x24\xfa\xbe\xa5",
          "\x6e\xf9\xdf\xf9\x00\x55\x06\x61\x84\xdb\xb6\x87\xd0\x39\x94\xcc",
          "\x31\x58\x61\xec\x1d\xd4\xf1\x67\x63\xbd\xfb\xbb\x63\x7f\x30\xb3\xdf\x38\xc3\x62\xd6\x25"
          "\x3c\x4e\x4b\x02\x3b\x89\xd4\x83\xd5\x7b\x89\xfb\x82\x9e\x94\xc2\xe8\x53\x2d\xf7\xa0\x68"
          "\x97\x3a\x7b\x8f\x55\xf6\xbd\x8f\x25\xbc\x6c\xe1\xc2\xd6\xb7\xb0\x9c\xde\xa0\x7d\x78\xa8"
          "\xfb\x58\x15\x5e\x4c\xd1\x12\xb1\x39\x0c\xa7\x9a\x22\x70\xa9\x71\x14\xbc\x50\x84\x67\x86"
          "\x08\x60\x13\x9e\x63\x45\x01\x35\x0c\x4b\x8c\xee\x10\x81\x02\xca\xc2\xdf\x30\x9c\x1d\x5a"
          "\x21\x24",
          "\x03\xa6\x80\xa3\xd7\x3f\x24\x96\x76\xe9\x84\x65\xb5\xd1\x14\x18\x95\x85\x02\x2a\xf6\x40"
          "\x28\x25\x31\xb0\xa5\xb9\x4f\xd0\xd5\xbe\x17\xe7\xdc\xbb\x7d\x92\xb1\xc3\x03\x36\x3a\x4b"
          "\x2d\x89\x0b\x08\x71\x4b\xb8\x65\x2f\xb8\xf3\x30\x4b\xe2\xd3\x90\x68\x11\x98\x46\x4b\xea"
          "\xde\x5a\xa1\xe9\xb2\xed\x6d\xbd\xb0\xb6\xfa\xbb\x61\x35\xad\xf7\xeb\xb6\xa5\xf6\x83\x17"
          "\x8c\xb9\xef\x94\x2c\x9d\xbf\x55\xa9\x49\x42\xf2\xef\x1a\xc3\x05\x27\x12\xf1\xf7\x80\x8b"
          "\x6c\xab",
          1, 896 },
        { 128, 256, 70,
          "\xf5\x27\xd0\x92\x7f\xe5\x90\x1f\xfe\xe9\x8f\x91\x74\x77\xb5\x85\xb4\x26\x44\x50\x3e\xd6"
          "\xab\x6d\x6f\x8e\xf9\xb6\x88\x77\x12\xf0",
          "\x05\xaa\xc1\x45\x89\x46\x49\x07\xf6\x19\x9b\x53\x75\x34\x63\x8d",
          "\xd8\x9c\x8f\x2b\xd1\xd4\x8c\xd4\x25\x5b\xe2\x4e\x3f\x1b\xcc\xfc\xbe\xfa\x59\x43\xa4\xb8"
          "\x3d\x08\x5b\x0d\x84\x98\xdb\x77\x7e\x8e\xf9\xaf\xdc\xb6\x22\x9b\x47\x6c\xdb\x1f\x78\x60"
          "\x7e\x03\xbd\x09\x19\x86\xb6\xa0\x68\xb1\x2c\xeb\x76\x29\x59\xd9\x8f\x10\xb1\x09\xb0\xe0"
          "\x34\xa2\x88\x6a\xa0\x56\x0e\xc7\x61\xf6\x1c\xa3\xda\x1f\xc8\x88\x13\x04\xe8\x6a\xd1\x81"
          "\xe3\xae\xef\x1e\xbb\xce\xff\x16\x6f\xd1\x4d\x60\x08\xe8\x9b\xbc\xb9\x52\x86\xa2\x17\x03"
          "\xc9\x43\xb0\x0f\xd3\xb6\xee\xcc\x9a\xea\x13\x00\x1a\x91\xdd\xe9\x39\xae",
          "\x7a\x3e\xc7\x74\x89\xb4\x1d\x49\x07\x91\x76\xce\x33\x7d\xb9\x3e\xc1\xe7\x2d\x55\x6d\x7f"
          "\x6e\x29\x0c\x3d\xaf\xa0\x9a\x4e\x3d\x55\x9c\x78\x60\xd7\x24\xbd\xa5\xdb\x0f\x83\x18\xe4"
          "\xa3\x31\xf5\x93\x53\x2e\x21\xbc\xa4\x07\xc9\xbd\x27\xc1\xf8\x78\x1c\x4a\x5f\x64\x4b\xb9"
          "\x7f\x8d\xfa\x7a\x3a\x87\x6f\x01\xd6\xf6\xc7\xb7\xae\xe2\x49\x96\xbc\x82\x4f\xcf\x6f\x16"
          "\x6d\x9b\x7e\x4c\xbc\x5f\x15\xd9\x40\x87\xb3\x93\x12\xf5\x92\x2f\xf8\xa0\x3d\xf7\x11\x42"
          "\xaa\x0a\xf2\xf5\x10\x79\x17\xdc\x22\x5d\xad\x02\x68\xc3\x95\xbf\xcb\x22",
          1, 1024 },
        { 128, 256, 71,
          "\x19\xbe\x69\x4a\x1d\xff\x91\x20\x2d\xef\x66\xb5\x3a\x3f\x63\x62\xfc\x20\x0d\x93\xb6\xb2"
          "\x7d\x3e\x8a\x37\x13\xb2\xab\xaf\x7a\x27",
          "\xca\x83\x33\xf2\xf6\xda\x1a\x7e\x66\xf2\x99\x7a\xb9\x97\x62\x31",
          "\xce\x54\x48\x15\x02\xe0\x7e\xe9\xf5\x7a\x4c\x85\x63\xf7\x06\xb2\x50\xb9\x65\x49\xed\x38"
          "\x33\x8a\xb2\x00\xcc\xea\xda\x29\xa3\x26\xc8\x38\xa5\x07\x47\x02\xa4\x28\x76\x87\x73\xb1"
          "\x11\xbd\x84\x04\x80\xb9\x09\x77\xc2\xe8\xe8\x42\x5a\xe6\xa6\xf8\xee\x15\xdf\x3c\x56\xe4"
          "\xde\x67\x09\xa0\xd7\x50\x49\x55\x2e\x1d\x35\x31\x85\xf0\x7e\xef\x0b\x78\x42\x70\x6a\xde"
          "\x77\x7a\x8f\xe9\xf5\xa3\x48\x76\xfd\xe7\x87\x6f\x29\x44\x99\x7b\x50\x26\xb5\x17\x8c\xf4"
          "\x33\xb6\x34\x79\xff\x4f\xf4\x95\x0b\xdb\x9d\x38\x72\x57\x75\x4b\xc0\x9a\x15\x72\x80\x72"
          "\x98\x5e\x14\x4c\xbf\x24\x9f\x14\xee\x1f\xd2\xe4",
          "\x9a\x69\xaa\x44\x69\xfb\x88\xf5\xa4\xc3\x44\xa1\xef\x02\xa6\xcd\x60\xee\x1b\x16\x8c\x7e"
          "\x4f\x7b\x77\x0f\x4a\x8f\xf7\x94\xb8\xd5\xe3\xa4\x8b\xce\x3e\xc9\x96\x9b\xa2\x88\x46\xe4"
          "\x7f\x83\x19\xfe\x87\xdd\x28\x01\xd6\x27\x76\x67\xe6\x12\x66\x12\xb9\x2d\x22\x04\xd9\x1a"
          "\x49\x61\x4e\x0f\x0d\x34\x72\xcf\xf6\x0a\x58\x53\xc3\x8c\x94\x42\xfa\xcd\x03\xfa\xf8\x0d"
          "\x84\xc8\x81\x00\xb4\x68\x87\x9c\xf4\xc0\x70\xd4\x06\x04\xa3\x6f\x41\xfb\x5a\xc1\x32\x00"
          "\xa7\x7e\x34\x68\x08\x41\x30\x5c\xe4\x6f\xd1\xcd\x96\xcd\x41\xcd\x99\xe5\xfc\x23\xc2\xa9"
          "\xcb\xc2\xa5\xc8\xb6\xb1\x4c\x55\x7d\xb9\xbe\x18",
          1, 1152 },
        { 128, 256, 72,
          "\xdf\xbc\x9c\xd5\xff\x26\x91\x02\xdc\x1e\x45\xce\x44\x74\xa0\x5b\x33\xb0\x0f\x23\xf1\x1f"
          "\x81\x66\x28\x36\xda\x21\x18\x02\x96\x92",
          "\x47\xe9\xc1\x0a\xee\xfc\xb1\x00\xcd\x9f\x6d\xbf\x73\xb1\x92\xdf",
          "\xf0\xde\x60\xb1\x26\x54\xd8\x75\x17\x93\xad\xf4\x22\xe6\xf5\x33\xb7\x51\x22\x00\xee\x40"
          "\x0c\x30\xfb\xe3\x93\x18\xb7\x28\x89\x5e\x89\xb3\x04\xe5\x9f\x43\xf5\x7d\xa9\x88\x12\xb3"
          "\xe0\x0b\x96\x11\x49\x73\x35\x88\x4c\x58\x22\x15\x9f\x26\xac\x45\xd2\x86\x1e\x1e\x7a\x73"
          "\x9d\x26\x38\xbc\xce\xa2\x43\x43\xe7\x7e\x93\x6e\x94\xde\x35\xdc\xa2\xeb\x9f\x25\x15\x04"
          "\x30\xd6\x7a\x33\x16\x0e\xe9\x49\x12\xf8\x63\xe2\x6b\x3b\x4b\xf7\x2b\x06\x62\x5e\x6d\x05"
          "\xe9\xf9\x6c\xfa\x57\xde\x65\x0a\x44\x8d\x5c\xc3\xa3\xd4\x87\x8f\x8d\x6f\x7b\xca\x40\x41"
          "\xb8\x47\x78\xa4\xb9\xc2\xf2\x14\x9f\x0a\xe3\x25\x73\x77\x61\x62\x1b\x26\x12\x07\x4d\xd8"
          "\x6d\xb5\x58\xf7\x1d\xd3",
          "\xac\x4a\xad\x36\x21\x66\x12\xc6\x4b\x97\xbd\xe3\x4a\x78\x6b\xc5\x99\x29\x46\x68\x47\x45"
          "\xac\x1a\x22\x39\x5f\xaf\x1f\xa3\x4f\xe2\x1f\x53\x74\x20\xd5\xf1\xc5\x5b\xbc\xfe\x6c\x27"
          "\x04\x21\xe0\xf0\xa2\x36\x7c\xf0\xd7\x18\x55\x68\x51\x9f\xce\x27\xb5\x52\xc7\x1f\xd5\x80"
          "\x83\x51\x13\xe3\x5e\x4e\x27\x21\x91\x09\x52\xa6\x6b\xd6\x37\xe2\xe9\xdc\xa0\x99\x8d\x8a"
          "\x95\x3e\xa8\xd5\x2a\x19\x6e\xc5\xb0\x3b\x58\xa4\x42\x33\xd9\x6a\xea\x60\xa3\xf6\xc8\x59"
          "\x92\xd4\xf1\x1f\x94\x98\xc0\x88\xba\x03\x29\xdb\x68\xa3\x8c\x10\x5e\xb3\x02\x4e\x05\xa4"
          "\xba\x5d\xaf\xba\x02\x48\xaf\x1e\x1a\xcf\x24\x39\x9e\x5b\x94\x64\x08\xb2\x58\x61\x73\xb5"
          "\x34\xfc\xaa\x5a\x99\x16",
          1, 1280 },
        { 128, 256, 73,
          "\x46\x70\x5e\x92\x2d\x30\x48\x27\xbc\xfc\xef\xdf\xe6\x36\xc3\x8f\xca\x0b\x63\x95\x69\x4d"
          "\x97\xb8\x27\xfa\x2e\xf3\x5d\x44\x04\xb7",
          "\x85\xcf\x36\x3b\x52\xfd\x0b\x92\x9f\x80\x13\x85\x8b\xf9\x3d\xee",
          "\xfd\x1f\xe6\x9a\x57\xb4\x33\x6f\xd6\x6c\xfa\x73\xbc\x0f\x77\xa9\x27\x22\xa8\x76\xb7\x59"
          "\x8a\x1e\x80\x16\x9b\x92\xa5\x6e\xd7\x74\x07\x43\xa3\x29\x80\x6b\xb7\x70\xa8\x2f\x52\x49"
          "\x1a\xb8\xf1\x8f\x8c\x00\x6d\x3d\x51\x97\x2d\x26\x84\x83\x98\xe6\x7a\x46\xaf\x36\x11\x2a"
          "\x98\xbd\xbb\x9f\x2b\x68\xaa\xa2\xd0\xa0\xa3\x50\x38\x0b\x31\x57\x9d\x43\x6f\x9c\xb3\x05"
          "\xf9\x57\x3f\x48\x2a\xef\xd8\x2e\xd4\x75\x68\xe0\x89\x59\x7d\xc7\x9d\x04\x8f\xb4\xad\x37"
          "\xf9\xc7\xd1\x63\xf1\x54\x4f\x86\xb4\x02\xf0\x9b\xdb\x88\x66\xbc\xef\xd1\x5f\x44\x88\xd4"
          "\x69\x4a\x89\x11\xbc\x41\xb5\xd8\x34\x97\xbb\xcc\x19\xdf\x67\xe2\x10\x97\xe8\xbc\x72\x77"
          "\x04\x2c\x1e\xba\x1a\xe2\x40\xa4\x8b\xfb\x98\x3a\x66\x2b\x36\x45\x48\x6a\xd3\xdd\x57"
          "\x41",
          "\xa4\xe7\x6e\xd2\x44\x46\x8a\x1a\x34\x39\x5e\x05\xf5\x40\xee\xc1\xe9\xea\xae\xcf\x6d\x1f"
          "\x78\x9a\x24\xe5\xf7\x70\xbe\x37\xe8\x70\x85\xee\xe1\xf0\x8f\x92\xd6\x71\x20\x00\xf9\x90"
          "\x57\x65\x14\xec\xd9\x37\x46\x08\x0e\xc1\xca\xb0\xa2\xea\x2c\x7f\xbb\x10\x07\x69\xab\x3a"
          "\xaa\x7f\xf7\xa0\x5c\xe7\xcb\xc1\x24\x84\x7b\xac\x39\x27\xfa\x27\x78\x29\x1e\x04\x95\x26"
          "\x42\xe2\x4e\x09\x3b\xf1\x5b\x23\xff\x1d\x90\xf0\xb5\xc3\x7a\x93\x63\x85\x0d\x37\xf7\x1d"
          "\x5c\xb0\x92\xa2\xce\xc3\x73\x5c\x1b\xba\x63\x27\xd7\x3b\x2e\x81\x17\x50\xab\x78\x8c\x4a"
          "\x86\xa9\x34\xcd\xee\x0a\xbe\x3e\xcf\x59\x80\x44\x6b\x59\x72\x45\x0d\xb2\xb4\xfb\xb6\x2f"
          "\x10\x8a\xe1\xaf\xb8\x8f\x27\x13\x6c\x36\xe7\xce\xac\xc2\x77\x4c\x4b\xe0\x23\x20\x92"
          "\xf2",
          1, 1408 },
        { 128, 256, 74,
          "\xda\x4a\xb6\x84\x31\x97\x11\xc8\x4c\xcc\x75\xd0\x89\x82\x68\x2e\x61\x3f\x3a\x18\xfe\xa4"
          "\x46\x04\x97\x66\x01\x55\xa1\x1e\x69\xb0",
          "\xcd\x54\x79\xed\xd3\xa9\x00\xe1\xc1\x6a\xac\x57\x55\xe5\x1a\x83",
          "\xce\x85\x4e\xdd\x13\x88\xfe\x70\xc5\x37\xbb\xaf\xdb\x3e\xb8\x4f\x36\x54\x77\xc3\xd2\x18"
          "\x1a\x9f\x6b\xfc\x70\x63\x13\xe0\xea\x8a\xb4\xd7\x03\xa5\x93\x64\x7a\xeb\x0f\xde\x28\x11"
          "\x49\x82\x81\xec\x55\x0f\xdd\xf8\xe5\xae\x11\xe8\xdd\x26\xc9\x73\x95\x29\xd1\xbb\x26\x4d"
          "\x9b\x3c\x6c\xf5\xf6\x62\x02\x48\xb1\xc2\x87\xe0\xef\x69\xbc\x82\x67\x9a\x86\xde\x21\x01"
          "\x05\x9c\xfc\x9b\x51\xeb\xb6\xfe\xd7\xd7\xa8\x5b\xf4\x9a\xf2\xc3\x91\xc5\x29\xf6\xcf\x5d"
          "\x96\x48\x52\xfd\xa7\xb6\x0c\x1c\x77\x27\x3d\xa0\x3d\x5c\x29\x4a\x6a\xbe\x3c\x3c\xa5\xb3"
          "\xac\x24\xaf\xe9\x82\x89\xb5\x03\x9c\xb8\xef\xc3\xd2\xb6\x40\x97\x82\xab\x3a\x97\xc1\xee"
          "\x12\x74\x4a\xe1\x99\xf0\x2c\x7a\xbf\x4f\x37\xb4\x4f\xa8\x94\xe0\xa1\x0d\xc1\xab\x0c\xd3"
          "\x86\xbe\xd7\xd2\x3b\xe0\x69\x52\x58\xf6\x27\x37\xd8\x79\xb3\xad",
          "\xee\xa7\x79\xb7\xc8\x44\xfc\xf6\x22\xa1\x25\x3f\x3b\x37\xbb\xc1\x40\xd1\x4e\xa1\x2c\x85"
          "\x34\x2c\x00\x3d\x6c\xd4\x8c\x53\x50\xc4\x58\x2d\x26\xf1\x31\xf4\xa7\x4f\x72\x9e\x4c\x50"
          "\xf3\xa0\xd4\xe7\xe0\x6c\xeb\x57\xde\x5e\xb7\xe0\x25\xa3\x7c\xff\x08\x8f\xd4\x24\xcb\x2c"
          "\x3b\xe2\x07\xee\x6f\x76\x30\xd2\xf2\x3d\x6f\x33\x9b\x48\x5f\x59\x19\x83\x20\xdf\xbd\x78"
          "\x17\x58\x3c\x26\x80\x09\xdd\x55\xc9\xbb\x3e\x76\x8b\x8b\x87\xe0\x95\xdb\x54\xa0\xa1\xa9"
          "\x30\x1c\xf0\x47\x5d\x75\xef\xe7\x3d\xf5\xc2\xee\x85\xd8\x14\x93\x51\x47\xb8\x57\xff\xb6"
          "\x5b\x20\x71\x36\xa3\xb5\x7f\xd2\x69\x28\xa4\xc0\x0a\x54\x9b\xaa\x04\xcb\xb8\xb8\x7b\xc5"
          "\xfd\x1e\x84\xe2\x0e\x2d\x2b\xdb\x5d\x02\xed\x10\x40\x07\x52\x78\xc5\xa8\xb0\x66\x24\xc1"
          "\xc9\xf2\xb0\x3d\x8e\xb2\xa6\x56\x0b\xbb\x20\x93\x4f\xff\x18\x8c",
          1, 1536 },
        { 128, 256, 75,
          "\x18\x6e\x2b\x09\xfc\x5b\xc5\x65\x82\x75\xac\xbe\x69\xed\xf7\xbb\xcb\x90\xcc\x4e\xe4\x3b"
          "\xea\x66\xe5\xcf\xb8\xe2\xc1\x7a\xa4\x85",
          "\x5d\x1c\x2b\x9e\x73\x18\xd6\xaa\x6d\x9e\x79\xa7\x3c\x27\x32\xeb",
          "\xa4\x9b\x95\x69\xae\x46\xb1\x3d\xde\xe4\x1d\x2d\x4e\xbc\x98\x1c\xaa\x53\xb3\x7d\xa2\x15"
          "\x35\x54\xed\x5b\xf8\x40\xe0\xcc\x08\x02\xe7\x10\xb2\x36\x6c\x71\xe5\x8e\x72\x75\x39\x12"
          "\x19\x6b\x87\xda\x9e\xc2\xd9\x20\x60\xe4\x24\xe3\xeb\x95\xc7\xf8\x4b\x75\xd4\x43\xac\xe4"
          "\x99\x87\x78\xbc\x1e\x4e\x95\x2e\xfa\xcc\x43\x93\x88\xca\xae\x57\xa4\x37\x4c\xfb\x56\x68"
          "\x73\xd0\x0a\x8b\xba\x80\x86\xfa\x1e\x14\x36\xd5\xd8\x34\x20\xf2\x1c\xc8\x0b\x50\x69\x2d"
          "\x5a\xbb\x86\xca\xc6\x0f\x07\x43\x0a\x3f\x1a\xd6\x20\xae\xb1\x01\x16\x35\x7f\x5e\xb0\xcb"
          "\x7e\xd5\xa0\x73\x6c\x67\xb5\x65\x7a\xad\xc7\xf2\xef\x4f\xcf\x96\x27\x57\xf6\xa8\xf0\x00"
          "\x42\x2f\x31\xb7\x09\x93\x4b\x60\x18\xe8\x7f\x47\x81\x35\xf5\x11\xde\x36\xe3\xe9\x34\xe8"
          "\xd7\x96\xad\x5d\xbd\x8a\x1d\x60\x09\xae\x76\xd3\x23\xe1\xcb\xa1\x34\x66\x6c\xd9\xb9\x47"
          "\x1a\x42\xc7\x43\x9f\x55\x2e\x3c\xc0\x65",
          "\x46\x31\x9f\x0c\x4c\xba\xb0\x2d\xd7\x98\x72\x6a\x0d\x96\xcb\xf3\x56\x42\x7f\xba\x7f\x5d"
          "\xf6\x52\x33\x8b\x7d\xd3\x40\x67\xc0\xcb\x13\x96\x30\x82\x1d\xbf\x5d\x9a\xaf\x09\x76\x94"
          "\x6c\xa5\xd5\xe0\xdb\xcf\x61\x7d\xe7\xc3\x76\xc6\x36\x75\xdc\xf6\x87\xd6\x74\x58\x50\x83"
          "\x58\x11\x4f\x1b\x10\x0c\x9a\x8d\x61\x51\xa0\x05\x16\x5a\x65\x53\x53\xe6\x5e\x14\x72\xab"
          "\xba\x4e\xa8\x0b\x71\x68\x29\xeb\xa4\xa1\x2d\xdc\x0a\x16\x84\x97\x1c\x5a\xce\xf1\xd9\x0a"
          "\x24\xab\xa7\xa2\x88\xe8\x34\xc4\xe5\xa4\x6d\xac\x4f\x28\xa4\xa6\x4f\xd3\x99\x1c\x1d\xb4"
          "\x8e\x6f\x87\xbb\x58\x2a\xc1\x15\xd5\x1c\x4a\x99\x48\x07\x74\xeb\x8d\x5a\x3e\x6e\xa6\xdc"
          "\xbe\x20\xb1\x35\x1a\xe9\xd5\x49\x41\x6f\x65\xd6\xe2\xd7\x8d\x69\x58\x50\xaa\xae\x11\x93"
          "\x43\x95\xb3\xf7\xa0\x77\x7e\x25\x8b\x20\xc5\x56\xd5\xdf\x60\xe7\x75\x3c\x73\x09\xbd\x34"
          "\xa1\xea\x17\x36\x0a\xec\x83\x6d\xf1\x0c",
          1, 1664 },
        { 128, 256, 76,
          "\x90\xcd\x3c\xba\x11\x54\x66\xa7\xea\xdb\xca\x9a\x05\x5b\xd0\x4c\x44\x76\xa2\x6e\xa1\x97"
          "\x55\xe8\xa6\x07\xe3\x39\x60\x54\x32\x44",
          "\xa4\xf0\x24\xb9\x91\x7d\x7c\xff\xf1\x00\x77\x60\x98\x11\x46\x24",
          "\x27\x1a\xde\xec\xfd\xca\xc8\x5f\x27\x0a\x00\xc6\x2f\x92\xea\xef\xe2\x19\x92\xc7\x89\x9b"
          "\x67\x62\x2b\x77\x63\xfb\x34\x73\xc3\x43\xa6\xcb\x28\x6e\x9e\x67\xe4\xf5\x24\xe9\x91\x6b"
          "\xf0\x5b\xc6\x7f\x9e\x6c\x4d\xa0\xe7\xc2\x40\xd8\xb0\x20\xb8\xd7\x6e\x23\x60\xb2\xeb\x6e"
          "\xcf\x39\xf7\xcf\xbc\x65\xbf\x83\xfa\xcb\x28\x17\xd0\xac\xb1\xf6\x40\x6c\xc3\x15\x32\xd5"
          "\xf3\x8c\x4e\xe5\xfe\xb5\x7a\xd2\x93\xbc\x5f\x31\x08\x62\xfa\x4c\x6e\xaa\x3b\x57\x8a\x96"
          "\x40\xbd\xc8\x01\xdb\x31\x72\x8b\xa4\xec\x86\x5b\x6b\x09\x01\x8a\x84\x59\x81\x15\xaf\x1b"
          "\x10\xed\xac\x96\x96\x75\x80\xb8\x70\x49\x23\xcc\x0b\x34\xb8\xa4\xed\xe6\xfd\xef\xc1\x91"
          "\x3d\xd0\xd4\xf7\x76\xa9\x01\xce\x17\xb5\x9c\x95\xc7\x0c\x4a\x4b\x98\xfd\x69\x61\xa0\x24"
          "\xe5\xd6\xbe\xfc\x19\x6e\xb2\x83\x1f\x6a\x92\xa9\x10\xa4\xe4\x5a\xcf\x41\xad\x08\xf6\x79"
          "\x7d\xcb\x2e\x96\x39\x58\xcf\x1e\x46\x62\x22\x09\x22\x98\x06\x81\xf5\xbe\x47\xfd\xe4\x86"
          "\xed\x54\xdf\x57",
          "\xcc\x25\x92\xaf\x64\xea\x74\x4b\xb2\xa7\x62\x5b\x09\x50\x53\x02\x99\x01\x81\xc6\x2a\xc3"
          "\x5d\x65\x3b\x2b\xd2\xcc\x76\x02\x98\x9a\xb6\x75\x44\xd0\x93\xcc\x59\xd3\x52\x19\x26\x9e"
          "\x4b\x8a\x63\x44\xaf\x4b\x66\x25\x94\xc0\x85\x73\x1b\xde\x53\x50\x7b\xae\xf1\xeb\x80\xd1"
          "\x2b\x33\xd2\x40\xf8\xd5\xea\xf7\x10\xea\x6f\xc5\xa0\x28\xd0\x31\x91\x9a\x61\x9e\x73\x2a"
          "\x6e\x83\xb8\x94\x5c\x48\x02\x5f\xab\xc9\x00\x8e\x38\x18\x8c\x34\x39\x0c\x03\x70\x03\x5d"
          "\x02\x45\xfa\x04\x59\x61\xd5\xd7\xc8\x97\x7c\x0f\x40\x83\x4c\x1d\xeb\x28\x05\xe0\xf6\x2e"
          "\x90\x21\x4b\x52\xa1\xcb\x05\xa3\x80\xf2\x95\x94\xb5\x0f\x61\x22\x7a\x18\xab\x9e\x70\xae"
          "\x6c\xd9\x46\x82\x94\xc7\x5c\xe3\xa2\x29\xab\x85\x51\x4a\xbb\x7f\x92\x1c\x7e\x23\xf9\x89"
          "\xfb\x3c\xc8\x4f\x52\x10\xed\x88\x21\xf0\xf9\x04\x78\xfb\x23\x93\xb8\xbf\x2f\xa5\x23\xee"
          "\x91\xf3\xd6\x2d\xb3\x9f\x06\x12\x8a\xa2\x5c\xdb\x53\x8c\x23\xf4\xd5\xf4\x81\xe5\xa6\xd7"
          "\x55\x08\x6e\x61",
          1, 1792 },
        { 128, 256, 77,
          "\xc2\xf8\x2a\x50\x70\x76\x27\xde\xce\x75\xaa\x6e\x46\x5f\x48\xa4\xc7\xfa\x94\x35\x5a\x3a"
          "\xde\x10\x5c\xc6\x6e\x86\x30\x02\x55\xa5",
          "\x48\xb6\x9d\x11\x52\xbf\x1a\x43\x13\x39\xdb\x35\x91\x69\xaf\x62",
          "\xa2\x94\x56\x42\xb3\x4f\xac\x9a\x6e\xc6\xb6\x36\xae\xe4\xb7\x9f\xf0\xb5\xf5\x46\xa1\xd2"
          "\x27\x65\x4d\xfa\x69\x64\xc7\x65\x27\xd5\xd1\x71\x13\x3d\x72\x3a\x9c\xcf\xf6\xd5\x57\x4e"
          "\xc6\xb3\xa3\xd0\xea\xf9\x01\xc4\x02\x99\x2c\xb1\xe3\x52\x82\x6d\xea\x51\xa1\x02\xc8\x14"
          "\x83\xcb\x46\xa3\x9e\x20\x9c\x8e\x8b\xeb\x59\xba\x84\x05\xca\xf3\x2b\x86\x3a\x3e\x79\x80"
          "\x43\x25\xc7\xff\x2b\xa0\x6a\xa1\x6a\xf5\x9b\xed\x49\xb9\xa3\xb6\x31\xe4\xe1\x91\x77\x68"
          "\x65\x57\x3e\x40\xa4\x73\xbe\xd5\xb9\x2e\x9d\x40\x88\xec\xf4\x3f\x61\x83\x0a\x7e\x43\xc4"
          "\x1e\x9e\xd6\xe4\xc4\xdd\xc2\x25\xbc\xa8\x70\x0b\xe3\x20\x76\x6b\xcb\xff\xda\x65\xf6\xe6"
          "\x83\xb9\x35\x91\xc8\x8a\x12\x67\xc5\xff\xda\xd1\x5a\xe6\x2f\xc1\x92\x16\xc3\xe3\xb6\xc9"
          "\x1b\xa9\xe9\x2d\x53\xa9\xa2\x15\x4d\xab\x2a\xdb\xd5\x61\x3a\xe0\x65\x1f\x92\xe4\xb2\x71"
          "\x04\x4b\x50\x97\x67\xc5\x37\x58\x48\x7e\x76\x99\x24\x25\xe3\x26\x8f\xaf\xec\xa8\xcc\x0c"
          "\x61\x72\x54\xb6\xc6\x0b\xc3\x89\xa3\xd4\x39\xe8\x9f\xb2\xa9\xae\xb8\xaa\x80\xbd",
          "\x76\x0c\x39\xa5\xf4\xc5\x3f\x4e\xa0\x8c\x8e\x33\xf2\xd0\x5e\x78\x69\x78\xdf\x4f\xb8\x88"
          "\x73\x5e\xd5\x70\x49\xb5\xff\xd1\x32\x73\xb9\x78\x21\xd0\xb0\xd7\x76\xa5\x28\x62\xf0\x84"
          "\xfb\x0f\x2b\x87\x07\xb6\xde\xd7\xcb\xdc\x78\xa5\xa7\xde\x03\x4b\xeb\x09\x1e\x0d\x95\x04"
          "\xeb\xeb\xb2\x8c\xa9\xfa\x56\xa2\x5d\x39\xb4\x65\x87\x45\x4b\x86\xfa\x08\xa0\x3d\x6a\x5c"
          "\x47\x06\x8f\xef\xdb\x8d\xce\xa5\xa1\x7f\x91\x76\xd7\xe1\xf2\x19\x33\xfb\x9b\xee\x20\x8f"
          "\x7e\xe7\x06\x3a\xd4\x0f\x85\x33\x0c\xf1\xe9\x89\xd7\xdf\x55\xac\xe7\xb2\xe5\x28\xa2\x98"
          "\x83\x28\x98\xaf\xf0\xfa\x64\x9c\x97\x5c\x22\xf5\x33\xaa\xaa\xb9\x6c\x25\x25\x37\x89\xe2"
          "\x60\x72\xa0\xf6\x0f\x1c\x17\x85\xb6\xb8\x75\x3f\x02\xca\x19\x92\xa4\xd1\x63\xdf\x49\xda"
          "\x5b\x0b\x14\x6c\xb3\xb3\x38\xa6\xb0\x83\x28\xac\x74\x71\x90\x41\x4c\x57\xfa\x56\x55\x72"
          "\x52\x04\x56\xc4\x73\xa5\xa4\xd3\x03\x67\xc7\x83\xfb\xdc\xe9\x1c\x8f\x34\xbd\x5d\x94\x40"
          "\x54\x49\x28\xa3\x63\xfa\x0f\x54\xd4\x17\xd2\xb2\x80\x2d\xce\x74\xe4\x39\x06\x1f",
          1, 1920 },
        { 128, 256, 78,
          "\x54\x60\xed\x05\x6b\xa3\x06\x5d\x88\xe6\xb4\xef\xa6\x10\xf4\x8f\x31\x1a\xb4\xca\x3b\x46"
          "\x38\xc4\x98\xe5\xe6\xda\xb1\x25\x2a\xe9",
          "\x84\x30\x74\xca\xe3\xe2\xa1\xec\x22\x67\x3f\x01\x1a\x4e\x15\xa5",
          "\xb3\xc6\xde\xf9\xf9\xd5\x1d\x29\xde\x8b\x65\x1e\x51\x9e\xb8\xf6\xcc\x5f\xda\x2e\x8c\xaf"
          "\x5a\xab\x0a\xd4\xdd\x9b\xf1\x3f\x22\xa9\xb2\x3a\x52\x5a\x28\xf4\x6e\x23\x2a\xfc\xf7\x3d"
          "\x47\xfc\x0f\x3b\x2b\x7f\x03\x2b\x5b\xe4\x27\xd6\x0c\x11\x0f\xb7\xe7\x29\xbc\x63\xc3\x59"
          "\x55\x89\xbe\x8f\x1b\x99\x90\xa9\xfd\xa7\xc8\x9f\xf6\x91\x73\x17\x63\x0a\xa6\x07\x2b\xa5"
          "\x4b\x78\xcb\x15\x85\xd7\x5e\x20\xd7\xec\xe7\x29\x24\xf8\xdf\x6f\x92\xc2\x77\xaa\xb8\xf6"
          "\x64\x30\x2b\xbc\xa7\xe1\x42\xd3\xc0\x0e\x96\x5e\xa0\x94\xea\x2a\x0f\x47\xf5\x9d\x7c\x0f"
          "\x0c\xe4\x5f\x38\x8f\x83\xa9\x7f\x85\x99\x43\x87\xcb\x83\x2e\x33\xeb\x7f\x79\x00\x85\xab"
          "\x90\x66\xc0\x6d\x89\x12\xc4\x36\x86\x6d\x2b\xd6\x78\xed\xb5\x1f\x0b\xf6\x9a\x6f\xee\x6d"
          "\xd0\x07\x53\xc1\x35\x0a\xba\x3b\xa7\x32\x33\xbb\xb2\xb6\xd8\x99\xdb\x04\x4b\xfc\x67\xad"
          "\x39\x2c\xfc\x51\x73\x58\xcb\x4c\xbd\xb4\x29\x6b\x2b\x46\x99\x8e\x23\xea\xc9\x88\x48\xf9"
          "\xb1\x36\xed\x32\x02\x67\x28\xe8\xf7\x42\x54\x28\x04\x89\xae\x01\xaa\xe2\x66\x52\x71\xb0"
          "\x7f\xa7\xff\xeb\xc6\x7f\xfa\xad\x07\x93\x4a\x6f\xf3\x4f",
          "\x9e\x63\x30\x3a\x5a\x27\xba\xe4\xbc\xad\x33\x1c\x37\x6a\x0f\xaa\x3c\xad\x81\xca\x3e\xac"
          "\x63\x56\x4d\x58\x79\x21\xd3\xe7\xd7\x19\x31\x40\x8c\x21\xe7\xb6\x56\xc3\x34\x42\xaa\x49"
          "\xbb\x01\xbd\x45\x07\x32\xab\x8d\x32\x30\x3f\xa5\x3d\x9d\xa7\xc2\x7b\x5a\xee\x88\xe9\x3f"
          "\x5a\x29\x90\xe3\xe6\xbd\x6f\x3a\x74\x82\x5a\xb5\x52\xed\x1e\x1d\x72\x15\x90\x01\x95\xff"
          "\x16\x15\xd8\xc2\x8d\xfb\xd3\xa2\x7f\x06\x2e\x17\xe0\x93\xb7\xdb\xae\x9d\x62\xc9\xc6\xcd"
          "\x4b\xdc\xa0\xfc\xe2\x9b\x48\xad\xfe\x6c\xc8\x93\x6c\x92\x6a\x7f\x6c\xc4\xe4\x16\xde\x94"
          "\x70\xed\x15\xf7\xa3\x2e\x0f\x41\xbf\x6c\xc1\x0b\xd4\x6e\x08\xdc\xe6\xe1\x5b\xb6\xe0\xfe"
          "\xfb\x48\xc9\x6b\x10\x8a\x33\xcc\xdc\x6b\x81\x47\x58\xdf\x74\x6f\xdd\xd4\x5f\xe3\xad\xea"
          "\x48\x05\xef\x61\xb6\x8c\xfa\x70\x32\x36\x9c\xb0\xb7\x00\xdc\x9d\x68\x2a\x81\xf9\x25\x39"
          "\xa6\x05\x16\xef\xc7\xc4\x4f\xa0\x54\xbd\x05\xb4\x78\xc2\x04\xc1\x36\x44\x2d\x8c\x64\xb7"
          "\x30\xf5\x75\xb8\x3b\x29\x22\xf5\xc4\x48\xef\xb7\xa5\x30\xf5\x9f\xd8\x5b\xe9\x0f\x14\xd9"
          "\x67\x86\xaf\xf4\xb7\xa1\xed\x63\x1e\xed\x87\xf8\x03\xec",
          1, 2048 },
        { 128, 256, 79,
          "\x62\xac\x39\x1d\x2a\x14\x09\x4d\x23\x98\x46\xa1\x22\x50\x67\x72\x86\x75\x3a\xc3\x18\x2b"
          "\x3a\x6d\xd8\x96\xe1\x68\xe6\xe4\x57\xab",
          "\x78\x71\x85\x23\x19\x60\xe4\xb1\x71\x77\x89\x8e\x4b\xb8\xad\x81",
          "\xc0\x68\x97\x7d\x39\x18\x5f\x73\x54\x24\xe2\x4e\x66\x19\x74\x66\x2c\xa0\xfb\x87\x22\x7c"
          "\x4a\xae\x16\x87\x8b\x9d\xbd\xac\x23\xce\xa6\x6c\xf8\xa4\xf6\x79\x81\xf2\x58\x47\x53\x73"
          "\x70\x3b\xa6\x9d\x3e\x4b\x33\x97\x50\x4c\x50\x11\x61\x19\xf1\x64\x84\x42\x43\x1f\xc8\x11"
          "\x29\x75\xc4\x7b\xb6\xc5\x36\xfc\xfc\x3a\x59\xc2\xaa\x18\x8f\x19\xd9\xd4\xa7\xd3\x2a\x52"
          "\xae\xba\x47\x02\xc6\x33\xeb\x5f\x58\x43\x89\x9f\x88\xdd\x1b\x12\x0b\xf4\xf9\xbf\x67\x5b"
          "\xca\x66\xf9\xf8\xd7\x3b\x30\xec\x60\x56\xa8\x3e\x56\xba\xf2\x7c\x54\x5b\x7f\x23\x96\x90"
          "\xdc\x35\x98\x97\x48\x2a\x7d\xf6\xf1\xba\x81\x28\xec\x2f\xe1\x3c\xfd\x1e\x2c\x97\xf8\x01"
          "\xa9\x00\xfd\x00\xa9\xcc\xa3\xc8\x7b\x90\x71\x61\xa4\xe5\x8a\x3c\x4e\x03\x46\x10\x1b\x99"
          "\x3a\xb6\xfb\xc2\x58\xd8\x73\xe6\xf1\x05\x08\xb4\x8a\x54\x58\x91\x82\xd9\x65\xf9\x2b\x2d"
          "\xc3\xc7\x5c\x71\xaf\x12\x3e\x76\xe8\xf9\xb5\x19\x03\x88\xdc\x18\x1c\x07\x8a\x94\x45\x46"
          "\x7e\x3c\xe2\xf1\x4a\xa6\xb0\xb4\x77\xe9\x4f\xd0\x1c\x2a\xd2\xac\xe7\x61\xe3\x9b\xb8\xd4"
          "\xd5\x72\x9c\x91\x20\x6f\xd4\xe0\x11\xbf\x3f\xa7\x2c\x91\x61\xe8\x7e\xf7\x82\x87\xfb\x8a"
          "\x8d\x44\x5f\xa7\x5e\x2c\x7d\xc6",
          "\xaa\x4f\x08\x63\x77\x74\xfe\x48\xe2\x37\x65\x7f\x61\x28\x82\x58\x87\x19\xc6\xa0\x8a\x08"
          "\x47\x3f\x2f\x85\x20\x71\x5e\xc9\x6c\x30\x7e\x0e\xa4\xef\xc8\x35\x88\xdd\xc7\xc3\x81\xfb"
          "\xd7\xcd\xea\x9f\x27\xb2\x2f\x33\x24\x2e\x52\xcf\x93\x73\x78\x68\x81\x2d\x54\x8f\xa1\x7c"
          "\x7e\xa8\x68\xc4\x8d\x8d\x5c\x66\xa4\x05\xfe\xff\xc1\x46\x31\x07\xe7\xf8\xad\x60\x58\xef"
          "\xd3\x9f\x29\xb4\xc7\x8d\x7a\x34\x62\xe7\x70\x8e\x32\x61\x36\xc4\x06\xca\x54\x9d\x66\x47"
          "\x51\x8c\x52\x1c\x54\x78\xe5\xd3\xac\x7e\xe2\x16\xcd\x19\x31\x74\xd3\x68\xfb\x17\x58\xbd"
          "\xbe\xac\x87\xc5\x1d\xde\xc3\xda\x3e\x2b\xea\x55\xaa\xcc\x03\x95\x81\xde\x77\x1b\x23\x25"
          "\xd3\xef\x68\x53\xe4\xf4\x03\x11\x8b\xb4\x47\x22\xd7\x9a\x8a\x07\x31\x74\xf0\xd3\xb8\xcb"
          "\x62\x7f\x3b\x6a\x53\x71\xc4\xfe\x8b\x94\xfe\xdf\x06\x48\x70\x70\x3f\x43\x08\x6b\x24\x28"
          "\xa1\x1f\xa1\xe2\x71\xf0\xab\xad\x2c\x3d\x6f\xdb\xe3\x48\xfe\x0e\x9a\x6b\x7f\xfe\x7e\x37"
          "\xe3\x28\x07\x98\x68\x13\x37\x63\xa8\xd7\x6e\x70\x82\xb5\x22\xfb\xc6\x1d\x41\xbf\x83\xa5"
          "\x3d\x14\x65\x3a\xce\x28\x40\xdc\x61\x29\xba\x43\x78\x7a\xdd\x03\xf3\x18\xd6\x9a\x29\xe8"
          "\xf2\x73\x1f\xf6\xd9\x3f\xbf\xf4",
          1, 2176 },
        { 128, 256, 80,
          "\x21\x81\xa2\xb1\x66\xed\x25\xf0\x1a\xed\x5a\x21\xca\xf1\xf5\x2a\x8a\x78\x18\xeb\x0a\x0b"
          "\x9f\xc4\xd3\x6d\x3a\xe3\xe1\xef\x67\x02",
          "\xec\xa5\xf8\x61\x0e\xf4\xaa\x28\x27\x67\xd2\x71\xfe\x5e\xfc\x68",
          "\xf0\x56\xf0\x7d\x6c\xfc\x74\xef\x51\x5a\x9f\x8f\x29\xfa\xbd\xe5\xea\x7f\x4f\xbb\x68\x52"
          "\xc5\xdc\xc7\x9a\x2c\xb9\x7d\xdd\x08\xa0\x8c\xd8\x93\x5b\x8b\xf2\xc8\xdf\xfc\x50\xda\x2b"
          "\xb7\x86\x30\x8d\xb3\x0e\x8a\x69\xc0\x80\x97\x4c\x6d\x1a\x4f\x53\x28\x30\xb2\x84\x50\x61"
          "\x55\xf2\xa8\xa5\x2e\x2a\x33\x72\x70\x7b\x4a\xfd\xf3\x20\x3b\xd5\x53\x54\xd2\xbe\xcd\x90"
          "\xac\xc9\x86\x9e\xb9\x4a\x09\x87\xc5\x56\x2f\x58\x43\x5a\xb7\x32\x20\xed\x44\x07\x08\x53"
          "\x7e\x87\x52\xe1\x80\x4e\x6f\xce\xdd\x59\x69\x95\xfe\xd7\x7c\x82\x43\x3d\x56\x88\xa2\xcc"
          "\x27\x66\x50\x0f\xa3\xc1\x39\x93\x1b\xd8\x40\xe3\x95\xa5\x11\x5f\x11\x07\x4d\xde\x6d\x59"
          "\xfe\x9e\xcb\xf7\x6e\x99\x1f\x11\xd2\x54\xca\x17\x6a\x11\xee\xc0\xae\xb8\x80\x2d\xa7\x13"
          "\x6d\xd5\x02\x59\x32\x3c\xa9\xfa\xe1\x39\x3e\x68\x17\x3e\x8d\x07\xde\x29\xb9\xaf\x38\x63"
          "\x08\x9b\xed\xce\x59\x4a\x6f\x29\xe6\x6a\x6d\x10\x86\x8c\xf0\xfe\x00\xdd\x3b\xd2\xe7\xc9"
          "\xad\x63\x32\x5d\x3e\x5d\x0a\xfd\xd7\xac\x83\x3f\x9f\x42\xa0\x22\x55\xe1\x1a\x73\x89\x80"
          "\xc9\x23\xc6\xda\x34\x5f\xed\xc9\xeb\xaf\xf3\x7e\xf3\x8d\x43\x9c\x66\x87\x3c\x96\x51\x75"
          "\x60\x74\x8b\x97\xa8\x36\xe6\x43\xfc\x2e\x14\xc2\x7f\x1e\x3e\x2f\x04\x64\x5b\x77\x07\xcc"
          "\xdd\x60",
          "\x42\x41\xa5\x7f\xe5\x4a\x13\x1b\xb9\x33\x13\x19\xa4\x44\x30\xc5\x1e\x3e\xbc\xf5\x12\x6c"
          "\xe5\xf9\xca\x22\x8f\x36\x6a\x0f\xf5\x1a\xb9\x81\x67\x17\xf6\xd9\x80\xfe\xf7\x47\xcc\x98"
          "\xbd\xd6\x99\x49\xf9\xbd\x73\x96\xf5\xdd\xd4\x6f\xfa\xf0\x9b\xa9\xcd\xce\x42\x60\xbe\x8e"
          "\xe6\x03\x87\x75\x94\x24\xda\x59\x4c\x1e\x0d\x7c\x20\x07\x6c\x97\x79\x02\x64\x58\x33\x80"
          "\x8d\x22\x80\xc4\x2d\x70\x7d\xec\xac\xaf\x9b\xc0\x49\xb8\x6c\x43\x83\x1d\x40\x27\x34\x98"
          "\x68\x73\x60\x70\x66\x93\x54\x03\x22\x45\x82\x65\xbb\x5d\x4e\x79\xc5\x81\x63\xfc\x7c\x92"
          "\x64\x4d\x15\x6a\x59\xda\x62\xb8\xc5\xd5\xc8\xd2\xbf\xb6\x7d\xc3\x67\x43\xd8\x37\x65\x65"
          "\x44\xba\x1e\x35\x6f\x49\xc3\x89\xf2\xb5\x3b\xdf\x4a\x95\xcb\xcb\x43\x0e\x55\xbb\x7f\x68"
          "\xfb\x64\xdd\x1d\xe5\x97\xf1\xef\x77\xae\x37\x95\x0e\x6e\x35\xb9\xdd\x31\x17\xd7\x00\x73"
          "\x71\xe3\x75\x35\x73\xe4\xdf\x0b\x91\x57\x02\x6b\x7a\xf7\x4b\xe8\x85\x32\x14\xf3\x3f\xf3"
          "\xb2\x93\x99\xa5\x55\x67\x05\xc5\x7a\xa3\x10\x2c\x2e\x6b\xbd\x17\x88\xa5\x3f\x26\xb6\xd5"
          "\x8f\x7f\x8b\xe9\x4a\x80\xdf\x3a\x7e\x49\x0d\xa5\x3c\xc7\x4c\xe8\xb8\x8b\x84\x7b\x01\x90"
          "\x0b\x1b\xbd\xa8\x16\xe0\xfc\x3a\xc5\xd6\x72\xdf\x8b\xa2\x3e\x5b\x8b\x6a\x3e\x14\xd1\xfd"
          "\xb9\x30",
          1, 2304 },
        { 128, 256, 81,
          "\xf6\x29\x7e\xcd\xd3\xdc\x82\x06\x98\xbf\x04\xab\x78\x6b\x3a\x67\x54\xba\xee\xc6\xc2\x8e"
          "\x68\xa2\x0c\x13\x23\x34\xa5\x8f\x01\x9e",
          "\xa4\x42\xeb\xeb\xe9\x67\x97\x74\xbb\x4c\x27\xf2\xbb\x33\xff\xf7",
          "\x9d\x17\xbc\x84\x69\xa0\x43\xfe\xbb\xbc\x45\xa4\xf6\x8f\xc0\x28\xad\xaa\x32\x1d\x33\x11"
          "\xd7\x40\x21\xd3\x28\x7a\xab\x7d\x8e\x40\xa2\xe6\x81\x2e\x39\xec\x51\x9f\x24\x8c\x0e\x13"
          "\x54\x85\x42\xa3\x0c\xa7\xb5\x3f\x3f\xc8\x8e\x4c\x93\xdb\xf5\x7d\x0f\x0e\xaf\x37\x26\xe0"
          "\xf1\x57\x2e\x4f\x3f\xda\x7f\x65\x91\x80\x66\x51\xa6\x66\x89\xd4\x23\x14\x15\xab\xed\xc1"
          "\x6d\x73\x9b\x99\xdc\x47\x96\xe4\x93\x67\x9b\xf9\xe1\xd5\x10\xf7\x13\xf7\x37\x51\x20\x7b"
          "\x5f\xe3\x45\xb0\x76\xf1\xc6\x5f\xff\x0d\x97\xb7\x2f\xbd\x6a\x20\xbe\x1f\xcc\x21\x8f\xed"
          "\xeb\x43\xd7\x00\x0c\x53\x52\x55\xd3\x81\x14\x03\x7a\x0f\xf3\x8e\xe9\x73\xd5\x42\x01\x98"
          "\x49\x08\xb6\x19\x05\xf3\xe9\x1a\x72\x39\xdb\xb4\xfe\xef\x60\xc0\x4d\x0c\xc8\xc9\x79\xe8"
          "\x1c\x99\xba\xd2\xfe\x71\xa7\xd4\xbb\xbc\xa4\xed\x66\x5d\x2f\x96\x09\x12\x3b\xf4\xc5\x12"
          "\x50\x71\xda\x76\xf1\x59\xb2\x29\x9b\x56\x7e\xef\x55\xa3\xbe\xf4\x49\x8a\x66\x32\x63\x58"
          "\x3c\xa6\x69\x58\xf2\x76\xfe\x16\x1d\x8e\x65\x92\x3d\xed\x20\x29\x1e\xd1\xfa\x19\x86\xcd"
          "\x38\xe1\xc9\xcf\xdd\xbf\x06\x82\xac\xd1\x32\x3d\x92\x22\x39\x7a\x9e\x69\xcb\xb3\x51\xa5"
          "\xb7\x0b\x3c\x3e\x4a\xbf\x45\xfd\xa6\xac\x87\x3e\x24\x5b\x30\x04\xe5\x08\x70\xd4\xf8\xb1"
          "\x36\x75\x30\x8d\xc2\xe8\xfc\x78\x5f\xae\x82\x87\xd9\xe6\xad\x08\x47\x18",
          "\xa8\x61\x0b\x64\xa3\xa4\xbe\x13\x9a\x3f\x30\xff\x40\x0e\x88\x87\x98\xac\x06\x17\xc1\xe7"
          "\xbb\xbf\x8a\x85\x1c\xa5\xc0\x5b\x35\xa2\x70\x30\x00\x86\x64\xb8\x83\xd4\x41\xa0\x25\x77"
          "\x15\x85\xde\xcf\x8e\xb2\x53\x3d\x46\xe2\x24\x8c\x8f\x10\xb6\x78\x81\x3b\x29\xfb\xfc\xce"
          "\x97\xb3\x4a\x9e\x7f\x6f\xb9\x61\xc0\x44\xa0\x81\x9b\xed\x64\xff\xef\x58\x05\x8c\x59\x89"
          "\x08\x15\xc6\x86\x9a\xed\x93\xfa\xd5\x4f\x4e\x1a\xf8\xd0\x0c\xd3\x40\xb3\xd1\x93\x6d\x19"
          "\x05\xae\x7d\x57\x5e\x90\x5e\xe5\xa3\x45\x21\xb4\xac\x35\x74\x15\x4e\xd9\x52\x93\x68\x4b"
          "\xf5\x51\x69\x3c\xca\x5c\x67\xda\x7b\xc1\xa2\xc2\xff\xca\x3e\xb3\x97\x1d\x3d\x92\xb1\x14"
          "\x50\x6d\x97\xa7\x3f\x6f\x2a\x53\x9f\x18\xe2\x76\x72\xa5\xb1\x6a\xa1\x38\x91\xc7\x5a\x62"
          "\xaa\x67\x54\xb6\x08\xce\xe1\x57\xb9\x78\x3a\xdd\x51\x46\x78\xf7\xbe\x1c\xd3\x2b\xc5\xbc"
          "\x05\x10\xcd\x75\xb5\x26\x1f\x4d\x7d\x1f\x7a\x6b\x55\xba\xd5\xb2\x74\xc8\x8c\x8c\xbe\xbe"
          "\x28\xfd\x32\xe4\x38\x50\xe3\x3e\x0a\xb5\x07\x5e\x7e\x37\x96\x26\x31\x5d\x67\x73\x97\x43"
          "\x89\xc9\x0f\xfa\x65\x00\x05\xc9\xa8\xdd\xa6\x78\xdf\x5c\x7d\x80\xe2\xc4\xb9\xa0\xe7\x21"
          "\x61\x59\xf6\x0d\xc1\x57\x78\x5e\x79\x87\x68\x6e\x3a\x13\xb1\xab\xba\xa5\x36\x7e\xca\x36"
          "\xea\xeb\xa5\x4f\x0a\xbc\x7f\xea\xe3\xda\x56\x21\x35\x09\xd8\x23\xbe\x7c",
          1, 2432 },
        { 128, 256, 82,
          "\xb2\xe4\x5e\xe9\x58\x4e\x53\x41\x9d\xe0\x6d\x33\xe3\x49\x53\x22\x22\xa8\x6e\x5c\xe6\x08"
          "\x51\x0c\xde\xc2\x32\x1a\xe2\x33\x0d\xec",
          "\xe1\x84\x63\x01\x18\xbe\xee\x0c\x8b\x14\x04\xd6\x67\xc0\x46\x37",
          "\x6c\x4c\xee\xe0\xf4\xeb\x85\xe8\xfe\xe1\x60\xf2\x15\x8f\x9a\xab\xd0\x24\xae\xe9\x76\x65"
          "\xa8\xfa\x95\xe4\x2a\xd7\xed\x9c\x17\x5d\xa1\xed\x5a\xc7\xd4\x17\x56\x6e\xdc\x40\xa2\x5d"
          "\xc2\xc1\x0e\x78\xf8\x2e\xcc\x8f\xda\x46\xe0\x06\x94\x78\xe1\x3f\x66\x3b\x6f\x87\x7d\xf6"
          "\x36\x17\xec\x64\x58\xa7\x97\x14\x2d\xb3\x69\xe3\x50\x13\xbc\xd8\x80\x70\x22\x81\x2b\xb4"
          "\xff\x8c\x33\xd0\x67\xad\x40\x7b\x25\xa0\x25\xb9\xcc\xd6\xda\x14\x70\x29\x15\x18\x19\xf6"
          "\x54\xad\x7a\xcc\xe3\x9a\xb3\xea\xb4\x88\xf7\x0a\x0c\x1a\xf3\x45\x66\x8c\x27\x54\x6f\x45"
          "\x43\x7c\x73\xdf\x6b\xb6\x89\xb3\xaf\xd2\x7e\x29\x9a\x3c\xe0\xe2\x33\xe7\x9d\x03\xbc\xda"
          "\xde\x5d\x6a\x02\xdd\x00\xff\x43\xc7\x94\x68\x21\x84\xcf\xda\x38\xb1\x94\x08\xc2\xe3\x56"
          "\x3f\x40\x44\x20\x4f\x09\x51\xca\x90\xe9\xc3\x03\x34\x6b\xc5\x34\x00\xdc\xe1\xf4\xfa\xbb"
          "\x0c\x46\x30\xb6\x7b\xb0\x10\x5f\x1b\x0e\xf2\xb8\x95\x29\x4b\x7a\x6f\xa8\x57\x3c\x1e\x28"
          "\x75\x82\xb4\x95\x8a\xbc\x36\x0f\xa6\x4e\xcb\x83\x7e\x37\x82\x1e\xc2\xd6\x2e\xdf\x05\xe0"
          "\xab\xd8\xf7\xc4\xce\x99\x44\xe8\xce\x97\xa7\x5f\x18\x28\xfe\xbe\x68\xca\xad\x2b\x2a\x19"
          "\x48\x58\xdd\x9f\x2a\x65\xbb\x6e\x95\xbf\xce\x35\xc7\x99\xa0\xcb\x19\x7f\xef\xb9\x32\x70"
          "\x1a\x88\x7c\x59\x64\xc9\xbe\x28\xff\xe3\x33\x07\xf3\x70\x89\x9b\x18\x05\xd7\x75\x67\x0b"
          "\x88\x0d\xf7\x93\x5e\x4f\x6c\x29\x3b\x40\xca\x11",
          "\x34\x6a\x04\x40\xb0\xd1\x35\xb3\x59\x93\xed\xe4\xd3\x0b\x40\x84\xbf\x8e\xdd\x9b\x63\xfc"
          "\xe0\x43\x72\x2a\x25\x73\x48\x8b\x7a\x5b\xee\xc8\x09\xf8\xdd\x5a\x05\x82\xd6\x14\xa1\x9c"
          "\x18\x3d\x36\x34\x23\xba\x05\xe8\xd8\x16\xaf\xcc\x60\x06\xff\xd2\xc2\x9c\x60\xa3\xad\x45"
          "\xbf\xa8\x7f\x93\xb3\xae\x7a\x67\x6a\x72\xe1\xb8\x9d\xaa\x6c\x65\x97\x68\x0a\x2d\x9b\x51"
          "\x6b\x53\x9a\x27\x2d\xd8\x85\xad\x05\x99\xed\x84\x87\xdd\xba\x38\xa9\x55\x51\x50\x57\x86"
          "\x25\x2c\xf8\xbf\x18\xf9\xc8\x4f\x2f\x3b\x30\xf9\x3f\x85\x16\xfb\xb0\x6e\x44\x1b\x52\x1d"
          "\x1f\x31\xfc\xb7\x75\xba\x18\x18\x7c\x28\x73\x9b\x8d\xf1\x75\xac\xba\x12\x45\x4d\x59\xac"
          "\x20\xea\x19\xdb\xc8\xaa\x94\x40\x90\xa3\x08\x71\x69\x29\x7b\x86\x54\x51\xd3\x63\x4f\xdc"
          "\x61\xaf\xfc\xed\x18\x17\x2d\xe6\x59\x98\x32\x11\xac\xb4\xf5\xf3\xe2\x00\xaf\xc9\x43\x33"
          "\x9d\xfe\xfa\x53\x03\x2f\xde\x0a\x65\x81\xd7\x32\xae\x72\x8a\x52\x86\x57\x53\xed\xd5\x45"
          "\x37\xc9\x9a\x1e\xd1\x9a\x2e\x0a\x39\x87\x04\x33\x61\x9b\x5c\x07\xb0\x69\xef\xd0\x49\x80"
          "\xc5\x32\xf5\xa6\x64\xf5\xd7\x86\xbc\x48\xdd\xea\xf0\x90\xb7\x46\x01\xe2\x67\x53\xb4\xe5"
          "\x48\x5d\x69\xae\xd0\xf4\x49\x79\xd8\xb4\x93\x37\x81\x46\x28\x32\xf2\xa5\xad\x47\xed\xc1"
          "\x26\xca\x2b\xa8\x40\x21\x97\xf0\x94\x67\x3c\xa7\xa9\x3d\x0a\xd5\x97\x67\xba\xc5\xe8\x19"
          "\x2d\x40\xf6\xed\x7d\x06\xed\xaf\xad\x8a\x76\xb9",
          1, 2560 },
        { 128, 256, 83,
          "\x71\xff\x8d\xe4\xd1\x07\x10\x7c\xac\x7a\xde\x20\xdb\x81\xc7\x2e\x6e\x2f\x80\xfc\xeb\x7d"
          "\x90\xb4\x68\x06\x28\x09\xb5\x9b\xdf\xda",
          "\x19\xfb\x5b\xb5\x6f\x01\x34\x32\xc3\xd1\x97\x44\x73\x47\x1b\xbf",
          "\x16\xdd\x12\xe4\x2d\xb2\x26\x67\x7a\x8a\x90\x6b\x71\x37\xa2\xab\x95\x1f\xaa\x57\xb5\x8f"
          "\xea\xf4\x50\x84\x81\x74\xbc\xfd\x8c\x83\x84\xc2\xd7\x0f\xe5\xee\xd6\x06\xcb\x39\x3d\x97"
          "\x69\x37\xeb\xf0\x51\x80\x3a\x0c\xab\xc6\x4e\xcc\x8d\xcd\xd0\x2e\xe3\xdc\x46\x1d\x34\x90"
          "\x18\xc7\xd5\xab\xb3\x25\xc7\xb3\xac\x92\x7a\x3f\xb7\x21\x1b\x9c\x5c\x82\x85\xfa\xe7\x49"
          "\x52\xe7\x52\x0a\x49\x7a\x6b\x06\x1c\xdc\x7f\xeb\x09\x8b\xc0\x5c\xce\xe7\x44\x40\x1e\xd4"
          "\x2d\xd1\x36\xdc\x09\x4c\x8b\x26\xdb\x89\xe9\xf6\xb2\xdb\x8c\xf4\x3b\x6a\x29\x57\x89\xe8"
          "\xe2\x3b\x19\xa2\xd4\x57\xe4\xba\x19\x5d\x1a\x13\x82\x87\x90\xab\x91\x06\x73\xbd\x99\x4f"
          "\x80\x27\xcb\xa0\x98\x02\x93\x24\xd3\x6e\xab\x57\xb9\x7d\x77\x0c\x2f\x08\x71\x21\x46\x9c"
          "\x64\xd4\x7e\x63\xe6\x08\x8d\xf6\x45\x90\x73\x86\x1f\x88\x92\x14\x52\x18\x8d\x30\x6c\x71"
          "\xa3\xab\xe7\x2d\xbb\x22\x01\x81\x70\xf3\x32\x47\xab\xd4\xa1\x19\x27\x7a\x18\x6d\xfb\xb1"
          "\x21\x27\x23\xe9\x18\x6c\x84\x28\x66\xd6\xe5\x70\xbd\x85\xd3\xfd\x6f\x76\xe0\x53\x32\xa3"
          "\x58\xf5\x35\x69\x40\x27\x29\xca\x71\x29\xbe\xa5\x4c\x71\xf3\xa7\x24\x1b\x12\x69\x57\xfe"
          "\x8f\x0b\x5c\xeb\x94\xe6\x93\xa0\xcc\x8d\x4a\x50\x0d\xdb\x95\xb5\x18\x2d\xa8\x83\x8c\x8a"
          "\x98\x59\xa3\xf3\x25\x1f\x31\xe8\x1b\x6f\xca\xf5\xb6\x62\x2a\x11\xeb\x81\x28\xe1\xf4\x22"
          "\x6a\xb4\xee\x07\xf9\xc3\xe1\x5b\xdb\x71\x11\x7b\xc6\x56\xf8\x64\xf9\x1b\xc9\xc8\x62\x19"
          "\xff\x99\x8d\xe3\xe4\x19",
          "\x52\x99\x63\xcc\x71\x43\xfe\xee\x1f\x72\x1f\x8b\x0f\x51\xa9\xb9\x2d\xb8\xee\x5e\x7a\x1b"
          "\x80\xe6\xf1\xf9\x69\x2a\x65\xb4\x5b\xce\x42\xf5\xf6\xae\xcc\xd7\x01\xfe\x19\xa2\x07\xef"
          "\xd4\xe2\x65\x5c\x4f\xc2\x13\x38\x1e\x61\x24\x14\x75\xed\x28\xad\xc3\x0c\xb7\xd7\xac\x57"
          "\x1a\x23\xf1\x1c\x9e\x93\xd7\x01\x42\x43\x89\x50\x61\x4c\x6c\x16\xad\xc6\xec\xc3\x93\x37"
          "\xf8\xbe\x0c\xdd\x56\xeb\x6f\x6c\xa7\xd1\x9f\xd0\xb8\x3e\x3b\x3a\x7e\xdc\x6b\x73\x84\x91"
          "\xbc\x3b\x95\x70\x0d\xc7\x5a\x60\x00\x4c\x4c\x30\x5a\x56\xbd\x0e\x6c\x8a\xaa\x67\xd6\x9a"
          "\x87\xd1\x28\x94\xa7\xad\xe1\x76\x50\x1f\xe1\x57\x2b\x03\xae\xad\xe1\xe9\x6d\x6c\xda\x06"
          "\x93\x7a\xdb\x20\x83\x5f\x3d\xd6\x3e\x6b\x9e\xdd\xa6\xfb\x65\xa4\x14\xed\xcd\xa2\xac\x71"
          "\xd5\xda\xf3\x82\xea\x08\x46\x66\x78\x24\x74\x30\x16\x99\xd5\x86\x55\xdb\x6a\x17\xf4\x5d"
          "\x53\x54\xd1\xca\x1b\xec\x85\x27\x6e\x38\x7b\x08\xa6\x41\x3c\xa2\xd0\x26\x9b\xa4\xa9\x75"
          "\x77\x6b\x8e\x72\x54\x43\xb2\x6a\xa0\x51\xc1\x6c\xdd\x16\x85\x12\xf4\x2f\x77\x2c\x95\x08"
          "\x44\x5f\x8a\x8c\x53\x61\x6d\xb0\xbd\x96\xf0\xab\x1b\x72\xf3\x8e\x60\x1a\xc8\xe5\xb7\xdf"
          "\xf4\xab\x35\x3e\xee\x37\x1d\x3d\xde\x6b\x28\xa6\x6f\xf5\x2a\xf9\x81\x63\x46\x8b\x2c\x46"
          "\xe8\x43\x90\xd1\x6b\x5e\x1c\x89\x8c\xd3\x5f\x31\x9e\x76\xb5\xe6\x1e\x30\xc0\xe1\x5b\x2a"
          "\x9d\xc7\x4e\x35\xf9\x5d\xfb\xd7\xf9\x2b\xe8\x4d\x12\x42\xda\xae\x34\x7d\xfe\x12\x1d\x76"
          "\x85\x8b\x28\xf1\xf7\x6f",
          1, 2688 },
        { 128, 256, 84,
          "\xe0\x80\xd1\x6b\x4a\x0e\xcd\xa8\x8f\xc1\x3a\xb5\x6f\x81\x05\xf1\x9a\xe7\x33\xfa\x3d\xf4"
          "\x6e\x21\x2a\x0a\x24\x71\x1b\x29\x0e\x9f",
          "\x94\x95\x7a\x5e\xc6\x72\x49\xb6\x8f\x5b\x41\x0d\xef\x10\x46\xec",
          "\xf8\x69\x3b\x08\xbd\xfc\xa2\x1f\xce\x46\xf5\xb8\xc5\xa2\x0b\x8b\x03\x2e\x81\x28\x5f\x06"
          "\x10\x91\xfb\xf4\x1c\xcc\x83\xfd\x80\x88\xc0\xea\x8a\xb8\xd3\x8f\x30\x89\xbf\xea\x16\xf9"
          "\x83\xed\xc1\x85\x15\x78\x40\x84\x2c\xff\x80\xd2\x90\x40\xe9\x16\x02\x06\x41\xa3\x0e\x24"
          "\x1e\x8a\x34\x1d\xad\x25\x17\xe4\x4e\xb4\x65\xd1\xb5\x54\x77\xd8\x3f\xe9\x0a\xd2\xa6\x02"
          "\xee\xcb\x5c\x00\x8b\x14\xc6\xb5\xca\x36\x14\x3e\xe7\x47\x79\x1c\x2e\x76\x24\xa5\xcd\xba"
          "\xc6\xbd\x2f\x88\x52\x58\xc9\x9d\x62\x1f\x31\x6a\xfa\xb6\xa5\x31\xa9\xe1\x6c\x41\x64\xd1"
          "\xe2\xe3\x03\xa7\x87\x15\x82\x3f\x8c\x7c\x8c\xac\xdb\x28\x68\x65\x85\xa7\xb9\x59\x7f\x08"
          "\x48\x50\x38\x9b\xe2\x11\x02\x61\x28\x19\x00\x8b\x23\xa5\xa4\x7f\x78\xdd\x40\x73\xfb\x14"
          "\xe7\x17\x49\x72\xab\xc4\x71\x6f\xdc\x77\xe0\xbe\x52\x6a\x5d\x33\xeb\x8c\x35\x9e\x64\x30"
          "\xd7\x7b\xcc\x90\xf3\xc7\xc3\xe0\xbb\x31\xc0\x3e\x66\xf6\x81\x7a\x24\x9b\x33\xd7\xeb\x1d"
          "\x6d\xb2\x81\x31\x2a\x7b\x96\xf3\x1d\xfe\x70\x93\xdf\x48\x62\x2a\x4c\x58\x17\x79\xbe\x49"
          "\x7e\x2b\x4c\xd8\xad\x8e\x68\x4f\x69\x4a\xa9\x31\x88\x5b\x6a\x2c\x13\x21\x49\xd7\x28\x17"
          "\xe2\x5d\xf1\xc5\x6b\x4a\xaa\x17\x3f\xc3\x6e\x63\x10\xd0\x48\xc3\xcb\xb8\x8e\x88\xdf\xec"
          "\xcd\xd8\x7a\xcc\x4e\x97\xb2\x7f\x6f\x67\x60\xdd\xf4\x76\x20\x06\xf4\xab\x0f\x1e\xbf\x0e"
          "\x1c\x07\x33\x7a\x35\x3c\x4d\x92\x3a\x38\xdf\x78\x91\x09\xbf\xe4\x4b\xab\x11\xfa\xcb\x91"
          "\x7f\x04\x3d\xcd\xd8\xaa\xb3\x49\xbd\x7a\x7b\x8d\x66\xc2\x03\x5b\xad\x5c\x77\x60\x16"
          "\xf7",
          "\xcb\x1a\xf1\xd5\x36\x6e\xe7\xcb\x1c\x23\xc8\x55\x7b\xa5\x3b\x77\x4b\x0f\x85\xa9\x6e\x26"
          "\x11\x0d\xf7\xbc\xe6\x35\x52\x00\x5e\xe2\x59\x69\x0d\x1c\x2f\x16\x14\x53\x51\x52\x66\x4f"
          "\xb8\x2c\x5a\xff\x40\x50\x00\xea\x99\x38\x55\x34\x3e\x3e\xca\xf1\x59\xec\x6b\xdc\x6f\x11"
          "\x21\x65\xd8\x4d\xf8\x34\xbd\xf5\x2c\x25\x4d\xa9\xe1\x76\xb0\xf7\x72\x29\x20\xf2\x7f\x6e"
          "\x53\x0d\x45\x45\xa1\xe3\x4a\x18\xe8\x97\x22\x68\xfd\x41\x4e\x3c\xb3\x6b\xb5\x47\x2a\xee"
          "\xfb\x2f\xdb\x4b\x8b\xd9\x06\xd4\xc0\x9c\xe9\x23\x75\x19\x0f\xbf\x54\x44\x01\xec\x4f\xc3"
          "\xb2\xd1\x23\x73\x92\x43\xca\xfe\x11\x7f\x06\xdf\xc5\x01\x5c\x4f\xf9\xcd\x00\xc9\x2e\xf7"
          "\xa2\xce\x36\xa7\x7a\xcd\x49\xd7\x09\xc4\x39\xd6\x3f\xac\xee\xe6\x61\xb5\x5c\xa7\x55\x50"
          "\x8a\x5b\x05\x61\x58\x07\x27\xca\x0b\x9b\x89\xf6\xfd\x6d\x27\x07\x98\xc2\x69\x4f\x72\x3d"
          "\xaa\x8d\x25\x73\xad\x07\x90\x0e\x09\x44\xea\x4b\x8f\x10\x50\x06\x9d\xf2\x31\x87\xbe\xa5"
          "\xc1\x4b\x92\x2f\x84\xdc\x38\x99\xee\x60\x58\x55\xac\x80\x28\xce\x6f\x04\xf2\x8f\xdf\x84"
          "\x21\x24\x44\x98\x7b\xd7\x07\x70\x4c\x5a\xf4\xa0\x21\x86\x8a\xd2\x01\x7c\xe2\x0e\xa2\xb5"
          "\x76\x37\x1e\xe3\xc6\x57\x94\x42\xd2\xa7\xa9\x9d\xe8\x5c\xb6\xa9\xde\x8a\x23\x27\xe7\xf8"
          "\x87\x74\xfd\xdd\x92\xd4\xb6\x6d\x40\x00\xe8\x1c\x90\x9a\xb5\xdb\xbd\x5a\x8a\x1d\x35\x74"
          "\x09\x7b\x1f\x01\xa6\xcb\x62\x05\xc8\xcd\x53\x59\x1c\x67\x28\x06\x43\xf0\x71\x37\xbd\x73"
          "\xcd\x10\x97\xe1\x44\xb7\xd9\x41\x89\xd1\xd9\x46\x45\x19\x72\x67\xa4\x62\xfd\xa6\x21"
          "\xc6",
          1, 2816 },
        { 128, 256, 85,
          "\x65\xc9\x98\x63\x78\x6f\xad\x1f\xd0\xbd\xc7\xa0\xa1\x89\xde\x2d\x4e\xc9\x4c\x6a\x0a\xe5"
          "\xf9\xdb\x83\xc1\x92\x1b\x04\xa4\x91\x80",
          "\x26\x06\xc4\x3e\xfb\xad\xc3\xe0\x37\xfc\x19\x0d\x3d\x96\x21\xbf",
          "\x0b\x37\x73\x3d\x1c\x4a\xa6\xe4\x14\x0c\xe1\x11\x12\x69\xb5\xa9\x21\x83\xef\xb8\xe7\x8e"
          "\xda\x57\xbb\x8f\x52\xf6\x03\xa4\x5e\xfd\xb0\xe9\x30\x0b\xff\xb9\x32\x79\x26\x65\x21\x3f"
          "\x6d\xd8\x35\x15\x1f\x28\x8a\xdc\xda\x07\x0a\x8c\x0d\xe7\x02\xd6\x50\xe1\xcc\xa7\xaa\xca"
          "\x8e\x1d\x97\x3a\xaf\x2f\xaf\x69\x86\x38\xda\xb9\x29\x9d\x40\x14\x34\xc8\xcd\x10\xf8\x5f"
          "\x96\x78\x80\x0d\x55\xef\x26\x8e\x95\x56\x37\xe2\x25\x0e\xdd\x60\x86\x84\x45\xd6\x47\x34"
          "\xb5\x33\xe7\xed\xff\x9b\x6c\xfd\xb6\x10\x45\xa1\xfc\x92\x8f\xc6\x15\x53\x70\x75\xdc\x96"
          "\x1d\xf3\xa9\xfc\x33\x75\x81\x4f\xd0\x7c\x97\x53\x2d\xea\x7a\x60\xb6\x4a\xbe\xa0\xa6\xe2"
          "\xf2\x58\x3b\x12\x0d\x50\xe7\xb0\x40\xa6\x17\x40\x26\x4c\x86\xeb\xfa\xcc\x16\xed\x46\xb7"
          "\xcc\x1d\x9a\x3d\x3c\x3f\x2b\x95\xd5\x83\xfc\xcb\xca\x07\x24\x4d\x6f\xe5\x71\x8d\xe3\xd1"
          "\xf7\x59\x47\x45\xc2\x19\x36\x22\xab\x16\x6e\xad\xb1\x08\x6a\x37\x1c\x23\x10\x53\x2b\xb7"
          "\xd2\x52\xfe\x79\x9d\x85\xa9\xf6\xc4\xe6\xb7\x28\x8e\xce\xf5\x5b\x0d\x6d\x7d\xc2\x6e\x70"
          "\xb5\x70\xa6\x37\x71\x5d\xbb\x5e\x2e\xb1\xca\x3f\x8b\x84\x4a\xa7\x41\xdc\x41\xd0\x74\x8d"
          "\xd9\xe0\x81\x9f\x41\xae\x6a\xdb\xa5\xaf\x35\x81\xf0\x25\x09\x21\xc6\xb7\xd8\x80\xac\xf1"
          "\x99\xb0\x85\x71\xff\x06\xbb\xeb\xdb\xce\x8a\x8c\xd8\xf5\x2a\xc4\xb9\x3f\xcf\x66\x64\x27"
          "\x3f\x16\xe8\x14\x83\xf5\x08\x2b\x7a\xda\xae\x49\x98\x98\xc1\xa0\xfc\x45\x2c\x88\x16\x71"
          "\xdb\x75\xb6\x87\xbd\x39\x56\x7b\xae\xbc\x83\x4d\x0d\x80\xea\xa2\x52\x49\x0b\x2d\xa0\x9e"
          "\x5c\xa1\xe8\xbd\xa8\x66\xe2\xcd\x76\xb5\x33\x32\x5e\x68\x8f\xd5",
          "\x35\xb9\x5b\x12\xe9\x2c\xc0\x1e\x88\x06\xfa\x0f\xed\xc1\xde\xe7\x4e\xff\xce\x87\xda\x6f"
          "\xab\x75\x13\xf7\x9d\x37\x84\x15\x4b\xaa\x17\xd6\x41\x8b\x35\x8e\x07\xaf\xc2\xaa\x1e\xac"
          "\x18\xc8\x22\x12\x71\xf2\xd3\xdf\xf7\x94\x1b\xdd\x55\xf6\x9e\xaf\x5b\x7c\x36\xfd\x8a\xae"
          "\x31\xbf\x1c\x26\xbf\x7c\x17\x20\xdf\xf2\x19\xb9\x3a\x3d\x7b\xbe\xf0\xa3\x94\x07\xbc\x0c"
          "\x01\x4f\x32\xb4\xb3\x36\x24\x65\x38\xe3\xb2\x4f\x07\x2c\x0a\xf8\x12\x7c\x38\x72\x06\xec"
          "\xe2\x4e\x3c\xf8\x1e\x65\x8a\x9f\x34\xb4\xe0\x5a\x63\x2d\x4f\x97\x54\x2f\x2a\x5e\x15\x5e"
          "\xcf\xb8\xfe\x14\xac\xb8\x69\x94\x7b\x9f\x67\x3a\x45\x14\x94\xdc\xc2\xaf\x44\x73\x80\xec"
          "\x1e\xe3\xb3\x64\xa7\x25\x1e\xb2\x81\xa3\x8e\x9f\x11\xb8\xd6\x8b\x74\x15\x62\xac\x38\x5d"
          "\x19\xdd\xe5\xe9\x5b\xc2\x4a\xed\x2b\xbc\xac\xb5\x39\xe1\xb6\x34\x2e\x39\x7a\x99\x66\xe9"
          "\x44\x18\x5e\x42\xf5\x67\x63\x4d\x94\x03\x73\xc5\xf9\x8e\xeb\x63\x43\x9c\x52\x55\xaf\xd1"
          "\xce\xea\x78\x93\x08\xdf\xfa\x4a\x1a\x98\x7e\xea\x39\xc2\x7c\xa7\xda\x50\x44\x30\xed\x99"
          "\x34\xce\x40\x95\x25\x00\x1f\x7a\x93\xdc\x0f\x19\xb8\xa6\xe3\x38\x7d\x25\x29\xe1\x12\x64"
          "\x5b\xc7\x0c\x1c\x66\x6a\x3f\x58\x7d\xfe\x72\x82\x4f\xab\xb4\x1d\x54\xbf\x39\x67\x50\x8f"
          "\x70\x2e\x10\xdf\xc1\x41\xfd\x97\x05\x6b\xd5\xb7\xa7\x34\xfc\x55\x3b\x98\x4c\x16\xac\xc7"
          "\x0d\x9c\x0b\x9d\x1d\x53\x38\xb5\x27\x1d\x0a\x85\x0f\xba\x73\x8b\x42\x6e\xf2\xba\xbb\xf8"
          "\xc3\x48\xfc\xdb\xdc\x0a\x19\x47\x72\xc4\x30\xcd\x13\x6a\x7b\xdb\xb1\xb3\x15\x17\xd1\xc4"
          "\x1d\x30\xce\x1c\x77\xf5\x29\x3f\xc0\x62\x1e\x13\xc0\x3a\xd4\x6a",
          1, 2944 },
        { 128, 256, 86,
          "\xde\x2a\x2d\x74\x63\xc7\x55\x88\x74\xa0\x52\x97\xb8\xfb\x1c\xad\x2d\x2b\xe1\x7a\xdd\x5d"
          "\x70\xba\x39\x3c\x09\x80\x3d\xf0\x32\x0b",
          "\xc7\x3d\x98\xcf\x48\x89\x68\xce\x5a\x32\x3b\x2e\xac\x95\xa2\x0a",
          "\x8b\xe7\x65\x91\x4b\xbb\x98\x76\xa1\xfe\xbc\x1b\x96\x48\xec\x3b\x08\xb1\x19\x3e\xe6\xc3"
          "\x40\x2e\xab\x76\x07\x21\x54\x1c\xad\x78\x2b\x26\x69\x35\x49\xdf\xf1\x52\xe7\xf3\x83\x82"
          "\x5e\xa3\xb2\x03\xdd\xb7\xb6\xda\x81\xa7\x97\x81\x6f\xd3\x1d\x44\x89\x01\xc9\xf0\xb9\xa7"
          "\x38\x14\xe4\xd3\x78\x11\x66\xf9\xd1\x19\x88\xc4\x4d\x5c\x57\xc9\x82\xca\x42\xd9\x41\x65"
          "\xc3\xfb\x13\xed\x98\x75\x4e\xf6\x5c\xae\xc9\x10\x33\xc3\x21\x10\x70\xd1\xb0\x4e\xb7\x19"
          "\x54\x63\xd1\x3a\xec\x6f\xd1\xc1\x67\xf7\x17\x86\xb0\x1e\x8e\x1d\xdd\x61\x61\x15\xf3\x02"
          "\x9c\xae\xb8\xbb\x91\x90\x57\xae\x07\xf9\xf5\xaa\x92\x50\xc5\xd4\xf0\xee\x1f\xd4\x20\x4d"
          "\xb0\xab\xdc\x3f\x9b\x87\xae\x15\x97\xaf\x9a\xc7\x12\xce\x0e\x53\xd0\xd5\x51\xcf\x57\x68"
          "\x14\x8c\x9a\x76\x80\x3c\xa9\x99\x83\x1e\x39\x8c\x00\x32\xbc\xfa\xd4\x15\xa4\x9b\x7a\x69"
          "\x3d\x43\x1f\xc9\xad\x03\x41\xb9\x06\x16\x7d\x6c\x61\x6e\xe4\xca\x29\x36\x82\xe2\x61\x17"
          "\x3f\xc3\xac\xc1\x2f\x86\x2b\x99\x09\x97\x57\x1e\x5b\x60\x92\x16\x99\xb1\xe5\x55\x7d\x42"
          "\xef\x3a\xb3\x3f\xfa\x0d\x49\xe6\xd1\xca\x86\x5d\x08\x12\x75\xd8\xdc\x47\xde\x1f\x5d\xd9"
          "\xba\xcd\x6f\xc7\x13\x69\xa5\xf1\x05\x86\x90\x8c\x91\x2c\x99\x23\xca\x9d\xa2\xd5\x1c\xa5"
          "\xb5\xf5\xe3\x38\x1f\x01\x93\x11\xf7\x08\x6f\xeb\x14\x93\x64\x51\x93\x85\x70\x66\x9e\xaf"
          "\x50\xbf\x55\x1f\x72\xed\xe2\xb9\xce\x45\x20\xfc\x4a\x0b\x33\x67\x85\x8f\xff\xf1\x7e\x39"
          "\x06\xa8\xee\xb4\x43\x5b\x96\x32\x0d\x5a\x70\x25\xcb\x81\x12\x16\x81\x2f\xa0\xa2\x2d\x61"
          "\xe6\x39\x38\x67\x94\x3c\x0e\x67\x47\x38\x07\x47\xde\xb1\xb5\xbf\x9d\xe2\xa4\x8a\x53\xe7"
          "\x34\xf8\x79\xae\xb7\xfe\xe0\x9e\xb0\x44",
          "\x64\x9c\xeb\xda\xfa\xd3\x55\x3d\xe7\x8e\xfb\x6d\x57\xd9\x43\x81\x78\x62\xf2\x80\x3f\xc1"
          "\xde\x90\x08\x66\xff\xca\xb8\xdc\x1e\x77\xc3\x1c\x47\x74\x74\xc8\x39\x98\x79\x76\x2b\x25"
          "\xcd\xbf\x12\xb9\x2b\x90\xa9\xf0\xaf\x4d\xac\x33\x8c\xaa\x14\x62\x4f\x42\xc1\xc5\x1c\xa9"
          "\xff\x26\x91\x4f\x68\xab\xf9\x99\x62\x00\xae\x1c\x48\x0e\xcc\xbb\x9a\xbc\xaa\x00\x5e\xbc"
          "\xa7\xcc\xdd\x0c\xea\xac\xf7\x95\x6f\x6b\x7c\x36\xfc\xb3\x42\xae\x6e\x57\xe1\x90\x02\x24"
          "\xe7\xf8\x38\x0b\x5b\x86\x07\x7c\xc3\x9d\x98\xc4\xba\xfa\x19\xfe\xd0\x40\xe0\x36\x1b\x2d"
          "\xfc\xed\xef\x04\xbb\x8a\xc0\x44\x1a\x49\x49\x56\xb6\x7e\x0a\x70\x26\x31\x24\x67\xb8\x96"
          "\x38\xb8\xca\x1e\xf8\x53\x2e\x43\xcf\x61\x2d\x1a\xff\x31\x45\x2f\x28\x0a\x79\x70\xc0\xed"
          "\x87\x8f\xfe\xce\x49\x8e\x00\xe2\xd8\x4b\x62\xcb\xb1\xb7\x6c\xac\x44\xff\x88\xe5\xe2\xe0"
          "\xc9\x6a\x6f\x30\x8d\x4b\x69\x7d\x4c\x3e\x34\xd9\xb0\x46\x5d\x88\xa2\xc2\xe9\x1a\x50\x44"
          "\x76\x9b\x1a\x39\xd1\x42\xf1\x49\xba\xcb\xf3\x1c\x90\x1c\x3e\x5d\x0b\x9e\xfb\xc3\xd6\xc2"
          "\x6b\x82\xbf\x2f\xa5\xd1\x12\x7d\x37\x90\xc8\x2b\x38\x74\x08\x43\x69\xe5\x85\x2c\x21\x62"
          "\x3f\xab\x06\x66\x16\xa2\xc2\x80\xd9\x23\x2b\x52\x53\x3a\x23\xd4\x0c\x0f\x83\x57\x3f\xb5"
          "\x3e\x59\x9b\xe0\x6c\xf9\x34\xde\xbe\x3d\x10\x31\xf4\xaf\xf5\x06\xaa\x56\x7d\xcd\x42\xd5"
          "\x63\xe2\xaf\xbf\x55\x46\xbc\xa9\x0d\xb5\xfa\x7e\x7e\x5e\x03\xcf\xb7\xf1\xb7\xcf\x1f\x06"
          "\x97\xf4\xed\x29\x33\x4f\x9b\x48\x91\x00\xda\x75\x57\xd7\x38\x95\x1d\x70\x2e\x6c\x55\x4c"
          "\xdc\x90\xf1\x3b\x0b\x48\xe5\xe1\xf0\x26\xc4\x98\xcc\x21\x43\x45\x16\x7c\x31\x0f\xdd\x5e"
          "\x5d\xb6\x31\x17\xa2\xc5\xe0\x51\x04\x11",
          1, 3072 },
        { 128, 256, 87,
          "\x2c\xa6\xf0\xcc\x30\x35\x0c\x86\x66\xc1\x34\x84\xa3\xbb\x88\x32\x75\x05\xae\xb4\xda\x3f"
          "\xc0\x5c\x7b\xcc\x7e\xfc\x0a\xc5\x31\x3c",
          "\x5a\x76\xbc\xa5\x40\x5f\x07\x26\xdb\x5a\x84\xff\x6d\x55\xec\xdb",
          "\x34\x11\x4d\x18\x7f\x57\xdd\x6f\xc7\x08\x11\x0a\xe4\xc7\x6c\xdb\x3c\xc0\x4a\x29\x1c\x0b"
          "\xef\xa3\x59\xb0\x80\x05\x93\xfc\x03\x75\xfa\x00\x90\x2f\xd5\x38\xe9\x11\xab\xaa\x89\xd7"
          "\x2f\xc6\xa2\x78\x2b\x88\x4d\x22\xf5\x0d\x8e\x1e\x0b\x17\xa8\x56\x77\x32\x48\x89\x02\xf8"
          "\x10\xbc\x98\xbb\x42\x17\x6d\x78\xd9\xf9\x79\x4e\x3e\x45\xa8\x69\xd9\x6f\x6e\x69\xcf\x81"
          "\x54\x45\xef\x9f\xed\x00\x0e\x5a\x30\x6e\xb2\x08\x32\xd1\x5b\xf9\xc3\xb5\x2c\x62\x35\x75"
          "\x28\xb1\x88\x67\x28\x2f\x07\xa0\x69\x0d\xb1\x7d\x0e\xa5\x0f\x00\x6a\xf7\x9d\x8f\x20\xd3"
          "\x9c\xe3\xfd\x88\xb6\x52\xd2\x2c\xe3\xc8\x73\x4c\x7c\xdb\xe7\x7a\x77\x2a\xc4\x28\xdc\xac"
          "\x9b\x22\xc1\x39\xeb\x07\x9a\x91\x4b\xcf\x51\x04\xdf\x39\x31\xe6\xdd\x0f\xf1\xfb\xe7\xdc"
          "\x87\x62\x5d\x77\xf9\xd1\x20\x1b\xa3\x4c\x03\x45\xfa\xe3\xd2\x32\x21\x21\x75\x33\x64\xa5"
          "\x4f\x97\xa9\x15\xff\xfb\x68\x31\xe6\x1c\x7d\xe7\x72\xbf\x26\x38\xc2\xb9\x4c\xf1\x5f\x41"
          "\xe3\xf9\x18\x2f\x54\xb4\x53\x0f\x3b\x61\xda\xee\xec\x3b\x87\xfe\x4e\x0b\xe5\x2e\x37\xe0"
          "\xc7\x24\xcc\x24\x0d\x0f\xd4\x3d\x1c\x7f\x35\x1f\x69\x09\x90\xb4\x61\x45\x8b\x13\x4d\x3a"
          "\x92\x96\xc0\x1b\x12\x2a\xae\x41\x11\xa1\x5e\x90\x32\x3f\x4f\x10\xe3\xad\xa4\x96\x27\x7a"
          "\x7e\x8c\xe9\xef\x0c\xcf\x36\x2c\x1f\x3e\x6a\x3c\x43\x7c\x2c\xc9\x5e\xc7\x11\x69\x92\x77"
          "\x25\xea\xcc\x6c\xbb\x8a\x95\x10\x2a\x89\x73\xef\xce\x83\x5b\xb1\xf8\x90\xe7\x6a\x58\x5a"
          "\x14\x6f\x7f\xaf\x4a\x1b\xf5\x74\xae\x70\x05\xc0\x3f\x7d\x32\xf6\xfc\x0f\x9c\x1e\x5a\x83"
          "\x27\xc7\xf6\x26\xdf\x40\x70\x07\x0d\x67\xd6\xc4\xd1\x56\xf7\x13\x25\x8b\x6b\x37\xc9\xbf"
          "\xff\x59\x52\x69\x02\x4e\x2a\x40\x13\xf0\xb8\x9d\x46\x34\xd5\xb9\xd6\xec\x69\x4c\x86\x6c"
          "\x0a\xae\xae\x1d",
          "\xe3\x1b\xf4\x6a\x30\xc8\x0e\xe3\x0e\xaf\x81\x4c\x59\x1a\x5b\x6b\xe5\xa7\x50\xc7\x5e\x51"
          "\xf6\xde\x38\x0f\x2b\x3f\xd7\x37\x22\x66\x66\xba\x86\x17\xd3\x59\x05\xd7\xfd\x75\xea\xf5"
          "\x64\x79\x86\xf2\xa3\xfa\x4f\xf8\x64\xf8\x73\x33\x55\x50\x33\xcf\xb5\x83\xfb\xdb\xfc\xa2"
          "\xa4\xb3\xff\xb7\xab\x4d\x47\x6c\x02\xca\x00\xc1\x66\xee\x8c\xfa\x1a\x36\x6f\x0f\xf7\x8f"
          "\x12\xb7\x10\x6e\x50\x74\x69\xf0\x77\xc0\xfa\x74\x27\x52\x63\x39\x04\x6a\x81\xbf\x37\x63"
          "\xfc\x0e\x64\xed\xde\x0c\x98\x84\xca\xb7\xad\x67\x22\xb2\xf3\x5a\x50\x01\x92\xbc\x65\x82"
          "\x1f\xcb\x86\x24\xe5\x30\xe0\xfd\x37\x94\x03\x9f\xcf\x0d\x76\x24\x78\x41\x1c\xa1\x79\xe1"
          "\x90\xaa\x28\xcc\x8f\x8b\x15\x25\x6b\x60\x9b\x6a\x56\x04\x8c\xe0\xba\xec\x3c\xd8\xff\x3c"
          "\x1c\x1e\x99\x1a\xa1\x6c\xa7\x92\x93\xc0\x41\x00\xac\x4b\x56\xe5\x19\xd4\xb0\x9d\x96\x25"
          "\x7c\xde\x3c\x61\x68\x68\xae\x37\x63\x58\x74\x3e\xa6\x22\x97\x61\x32\x6b\x3b\x64\xb8\x5a"
          "\x94\x27\x57\xfb\xa1\xe9\xdb\x89\x92\x2a\x59\xb9\x48\xb1\xdb\x8a\xa5\xed\xc6\x10\x9c\x7d"
          "\x20\x2f\x64\x4b\x02\x36\x83\x08\x2f\xf7\x4d\xc0\x5e\xb4\x75\x61\xe1\xfb\xa1\x61\x85\xfc"
          "\x25\x0e\x5c\xab\xba\x3a\x98\x89\x83\xe3\x4e\xa4\x1a\xb6\xff\x49\xba\x27\x27\x5b\x54\x7b"
          "\xea\xd2\xfe\xed\x48\x02\xd1\x06\xc5\xec\x1b\x32\x02\x5f\x18\x0e\xf2\x83\x7e\x01\x61\xb8"
          "\xf1\x3b\x9d\xb9\xc0\xbd\xa9\xd2\x37\xf2\xe8\x27\xbe\xd1\x13\x03\x03\xbe\x06\x7c\x1e\x71"
          "\x03\x31\xca\xe9\x4f\x20\x6b\x7a\x5e\x72\x6e\xa5\x2a\x30\x6f\xed\x9e\x38\x17\xe2\x3e\x96"
          "\x33\xc9\xbd\x1c\xeb\x3c\x67\xd2\x0b\xf5\x47\x6c\xd4\x99\x64\x0d\xd7\x0d\x02\x20\x51\x23"
          "\x09\x95\xf7\x0b\xcb\x5a\x26\x1c\x21\xd0\xa1\x5b\xda\x02\x24\x88\x78\x23\xeb\x0d\xa4\xee"
          "\xea\x98\x72\xaa",
          1, 3200 },
        { 128, 256, 88,
          "\x3f\x23\xc2\x6c\x02\x24\xe1\xfa\xe0\x4a\xf2\xf7\x92\x34\x39\x2e\x81\xb5\x1d\xa4\x32\x96"
          "\xde\x2d\xb2\x86\x24\x42\x4f\xca\x57\x3b",
          "\xac\x1d\xa6\xcc\x7d\x2e\x68\x7a\x22\x68\x1c\xbc\x4f\x92\x3c\xa0",
          "\x15\xa1\xa3\xef\x39\xa0\xe9\xf9\x9b\x0e\xf0\x8a\x11\xbf\x72\x8b\x1a\xd3\xb1\x3e\x2a\x40"
          "\xe9\xe3\x5d\xa7\xcd\x97\x57\x5b\xf8\x86\x6c\x01\xbf\xce\x42\x88\xa8\xec\x70\xb0\xea\xce"
          "\x2b\x6a\xda\xf1\x8f\x3a\x44\xd5\xe4\x52\x4b\xd3\xc6\x9b\xbb\xee\x3e\xf9\xf6\x2b\xfa\x54"
          "\x6a\xc1\xc9\xaf\x51\x66\xae\x91\xc8\xf0\xb5\xef\x5e\xc2\x8b\xdb\x82\x4f\x9f\x1a\x24\xa0"
          "\x60\x8d\x55\xcc\x92\xe2\x3c\x4d\x01\xb0\x12\xaa\x97\xa7\x76\xd9\xb5\xaa\xbb\x48\xbe\xcd"
          "\xc9\x99\xa7\x13\x1e\x6c\x1c\x03\x93\x14\x1b\x9e\x09\x3f\xea\xd4\x43\xb8\xce\xb1\x85\xf6"
          "\x0c\x12\xee\x60\xe3\xeb\x73\xe0\xa8\x00\x73\x13\x92\x01\x18\x1c\xe9\x31\x0c\x6d\xc2\xb0"
          "\xda\xda\xc7\x88\x9c\x1a\x4d\x68\xa2\xba\x06\xc6\x7e\x06\xde\xd4\x53\x73\xb8\xfd\x44\xdb"
          "\xdb\xf5\x38\xc1\x1c\x0a\x8f\x1f\xf4\x0d\x10\x5c\x1e\x20\x02\xec\x94\xf1\x33\x2d\xfb\xbd"
          "\x20\x4e\x09\x46\x95\xf5\xa6\x4c\x83\x17\x6e\xa7\xdb\x58\xc1\x76\xa3\x4a\x71\x06\x07\xaf"
          "\x8e\x9a\x65\x04\xe3\xcc\x67\xb8\x37\x9f\xa1\x2e\xbd\x03\xdb\x3f\xfc\x38\x24\x1c\xc3\x7f"
          "\x1e\x71\xb0\xe3\x29\x3a\x63\x45\xba\x2e\xb9\x00\x93\x7d\x07\x7b\x16\xde\xcd\x50\x32\x2f"
          "\x9e\x7d\x2e\xfa\x13\xa7\xcc\xe7\xa2\xb0\x55\x74\xa9\x7f\x4c\xab\x71\x28\x01\x63\xbf\xdf"
          "\xe0\xc5\xa4\x04\x8c\x68\x54\x4d\x9a\xc5\xf6\x54\x1a\xa4\x3f\x84\x26\x1e\x69\x8c\x80\x84"
          "\x8e\x2f\x26\x86\x14\x61\x65\x08\xe0\xdb\xe1\xb0\x06\xa5\x42\xb6\x4b\xb5\x47\x6c\x3f\xe5"
          "\xa5\xf4\xf8\xda\x7f\x2a\xdd\x16\x94\xf0\x1a\x61\xc6\x61\x0a\x8e\x50\x16\x5f\x94\xf4\x9e"
          "\x23\xb5\xa8\x55\x90\xee\xb9\x39\xc9\xa1\x42\x81\xab\x66\x38\x44\x65\x96\x3c\x1f\xac\x80"
          "\x00\x26\x62\x70\x52\x02\x2e\x8d\x1b\xaf\x74\x74\xc4\x6a\xdd\xcc\xff\xe6\x69\xd8\x75\x0c"
          "\xde\x8d\x46\x5a\xd2\x36\xb5\x29\xe9\x1e\xbe\xa2\x49\xaa\xad\x2e\x5e\x30\x78\x1b",
          "\x9b\x4c\x79\x07\xc9\x88\x05\x41\x05\x54\xff\x78\x80\x34\xe6\xac\xd2\xac\x0c\x91\x6f\xe4"
          "\x6c\x1a\x78\x35\x92\x80\xc3\xec\xef\x2b\x24\xee\x0d\xcf\xd2\x7b\x77\x04\x35\xbf\x42\x6a"
          "\x8a\x62\x1a\xa7\x56\x7b\x16\xe3\x46\x50\xaf\x9b\x7f\xe1\xb7\x8e\xfc\x6c\xc5\x08\x66\xab"
          "\xa4\xf9\xa8\x2b\x54\x3f\xac\x0b\x01\xc4\xbd\x22\xb8\x0f\x35\x34\x33\xe4\xfa\x72\xcb\xbc"
          "\x86\x3c\xad\x98\xf6\x48\x3a\x78\x49\x46\x93\x7c\x5d\x0a\x67\xd9\x89\xca\xb0\x58\x34\xd2"
          "\x31\x93\xc1\x36\xdd\xfa\x8a\x80\x75\x1c\x50\x87\x2a\xcc\x47\x35\x6d\xef\x6d\x59\x2c\x34"
          "\x53\x95\x5c\x4e\x06\xbd\xeb\xea\x51\x19\x31\x88\x78\xa4\xee\xc8\xac\x7b\xda\x21\x2e\xc9"
          "\x97\x5f\xea\x48\x74\xc2\x04\xd3\x9a\x3b\x3e\xd5\xd0\x10\xca\xd4\x46\xf8\xf7\xb7\x09\xde"
          "\x10\xf6\x13\x37\xf3\xf6\x3c\x21\x41\xb6\x2f\x8d\xde\x94\x66\x70\x03\x7a\x6a\x70\x9f\xd5"
          "\x6a\x23\x39\xca\x7b\x37\x53\x73\x18\x4b\x8d\x0e\x3b\x05\x38\x01\x58\x01\x6f\x2d\xd6\x0e"
          "\x60\xe6\x74\xd1\x11\x2e\xb0\x9b\x1a\xb6\xd7\x23\xa0\x38\x7a\x2b\x4c\x81\x23\x40\x03\xde"
          "\xa5\x60\xa0\x7e\x93\x8c\xba\x45\xd6\x16\xfd\x73\x25\xd8\xc9\x96\xfa\x11\xfa\x24\x42\xa4"
          "\xbf\x6c\x61\xbc\x7c\x76\x8f\x85\x91\x2f\xa8\xdb\xa7\x7e\x62\x16\x22\x38\xa3\xfc\x9f\x89"
          "\x08\x89\x96\xaa\x48\xd9\x1a\xca\x7c\x4f\xca\x2c\x86\x53\xb9\x8a\x66\x97\x68\x03\xb2\x26"
          "\x53\xfd\xf9\x27\xf8\x32\x36\xb7\xf5\xb2\x3d\x36\x66\x77\x8c\xcd\xfe\xc4\x55\x7e\x06\x5f"
          "\x11\x1d\x7a\xe4\x3a\xc5\x69\xff\x84\x3e\x4d\x7d\xbf\x2e\xfb\xaa\xed\x9c\x8e\x7b\x20\x1e"
          "\x04\xcc\x47\x9c\x58\x93\x4c\xbb\x51\x98\x8e\x39\x9e\xb0\xe1\x1a\x95\x5c\x05\x36\xca\xf1"
          "\xae\x48\xa6\xc7\x5a\x40\x76\xe3\x41\xd0\x2e\x49\x77\x46\xc8\xa7\x9f\xf1\x03\xe2\x52\xe3"
          "\x80\x17\xdf\x4f\xa4\x20\x63\x04\xcb\x11\xc5\x4b\x6c\x65\xea\x30\x58\xa9\x6f\xff",
          1, 3328 },
        { 128, 256, 89,
          "\xa4\xeb\x20\xad\x63\x27\xbb\x52\x51\x48\xd2\x41\x1f\x22\xee\x70\x61\x45\x4c\x31\x0a\xf9"
          "\x99\x53\x54\xba\xa4\x0a\x4d\xf1\x6c\xb9",
          "\xe7\x7f\x3c\x77\x5c\xd7\xf9\x7e\xa9\x47\x24\xaf\x86\xbb\xc5\x20",
          "\x49\x2f\xc4\x47\xac\xc2\xbc\x80\xc0\x14\xb5\x3f\xfb\x91\xa3\xf9\xa8\x00\x16\xb7\xae\x8f"
          "\xb9\x16\x8f\x20\xee\xa0\x67\xec\xeb\x0e\x15\xce\xb6\x66\xf4\xf9\x89\x79\x5c\xc4\x08\x77"
          "\x8b\xdb\x11\x17\xfd\x06\x3c\x7e\x54\x52\xcb\x60\xaa\x43\xb1\x85\x8f\x13\x80\x83\x1c\x32"
          "\xe0\xb4\x01\xdf\x0a\x8b\xd4\x61\x2c\xcf\xa1\x40\x55\x9d\x75\xa3\xde\x04\xd1\x34\xd3\x59"
          "\x52\xc9\x33\xbf\x5e\xf7\xde\x22\xc4\x46\xdd\x4a\x36\xf7\xe3\x9a\xde\x4d\xb8\xd3\x64\x84"
          "\x64\x5e\x80\xbb\x0f\x46\xcc\xc5\x99\x00\x34\xe0\xb3\x34\x15\x1a\x1d\x9e\x5d\x1e\x7e\x73"
          "\xeb\x8e\x34\x8b\x2c\x82\x64\xd1\x7d\x3e\x1a\xc4\x9c\xa2\x03\xd3\xf8\x5d\xcb\x48\x39\xa3"
          "\x10\xc8\xac\x25\x8b\x9e\xa3\x40\xa7\x14\x0d\x39\x52\x3f\x23\xf9\x74\x45\x4d\xba\x06\x75"
          "\x13\xab\xf3\x8a\xb5\x5f\x83\xc4\x18\xed\x00\x6e\x91\x26\x7b\xac\xdf\x37\x59\x1a\x4e\xc5"
          "\xa5\xa5\x0c\x62\xd7\x3e\x95\x2d\x78\xd3\x2d\xe0\x02\x66\x21\x4a\x26\xcc\xa2\x6a\x11\x5b"
          "\x50\xe5\x79\xd9\x7a\x27\x4f\x54\x72\xec\x75\xb2\xa0\xbd\x30\x4a\xaf\x0d\x84\xad\xaa\x1a"
          "\xbe\x3a\x5e\x31\xa6\x6d\x71\x00\x3b\xe8\x63\xa9\x66\x62\xfa\x98\x12\x45\xfb\x21\xb3\x1e"
          "\xf6\xd7\x10\x6a\x20\x84\x0c\x4b\x6a\xb9\x00\xa0\xbd\x51\xbc\x5f\x10\xb0\xe3\xbc\x30\x58"
          "\x51\x38\x21\xb2\xf3\x00\x9b\x1f\xbb\x2a\xd7\xaa\xd9\xa3\xf3\x03\xc3\x0d\xa5\xa8\xee\x54"
          "\xf1\x62\x54\xb3\x47\x0c\xf3\x88\x48\x43\x87\xc8\xd6\xcd\xda\x8b\x06\x4f\x84\x45\x81\x05"
          "\x75\xce\xb0\x0b\xa9\x49\x25\xc7\xbe\xb6\x09\x3a\xb5\x38\xdc\x9d\x23\xaa\x54\x1c\x77\xc1"
          "\x62\x35\xdd\x49\xe2\x11\xf2\x77\x30\x8c\xca\xba\x51\xb9\x55\x0b\xd5\x8e\x9d\x43\xea\x3e"
          "\xc4\x7b\x24\x30\x58\x23\x65\x3b\x32\xb2\xaa\xf1\x9e\x36\xd9\x84\x83\x91\x15\x64\x4c\x39"
          "\x05\xdb\x48\xcf\xd6\xb7\xe6\x4e\x06\xa6\xd3\x05\x10\x0d\xec\xce\xeb\x66\xfb\xd9\xd2\x20"
          "\xa7\xad\xea\x95\x92\xcf\x65\x03\xf4\x2a\xfa\x48\x55\xe9",
          "\xce\xd4\x1c\x03\xfe\x5a\x5f\x8a\xf6\xc3\x90\x56\xb5\x9b\xf5\x48\x6d\xac\xa9\x38\x1e\x37"
          "\xcc\xdb\x62\xde\x46\x1e\x88\xcd\x4f\x8d\x72\x0c\x12\x2b\x00\x37\xfd\xc7\x59\x57\xb0\x75"
          "\xf5\x1f\x78\xb7\x6c\x89\x54\xfe\x8e\x2d\xb1\xe5\x5f\xe9\x56\xa7\xf6\x07\x25\xca\x5d\x2e"
          "\x6d\x3a\xae\xdd\x50\x9a\x29\xde\x98\x9b\x5b\x04\xc5\x67\x3a\x29\xb9\x35\x60\xda\x0c\xa7"
          "\x10\xc4\x32\x09\xc5\xf7\x20\xd6\x78\x8c\xdd\x22\x70\x4b\xde\x60\x06\x41\x73\xcd\xd8\xd2"
          "\x4d\xc5\xfd\x18\x31\x16\xef\xda\x6a\x5c\x2f\x70\xfe\x57\x8d\x34\x7f\x4c\xeb\x25\x04\x99"
          "\x96\xba\xd6\xf5\xf2\x06\xd2\x28\xb3\x12\xdc\x91\x57\xf9\xd9\xbe\x44\x90\x52\xa2\xa8\x7d"
          "\xf4\x94\xcd\x1c\x58\xbc\x06\x3c\x9a\xb6\x8c\x81\x10\x63\x56\xb0\x27\x9d\x66\xcc\xf8\x45"
          "\x79\x52\xcf\x43\x58\xa5\xda\x78\x43\xd2\x19\x75\x90\x45\xc9\x60\xab\xb1\x63\x9d\x23\xa3"
          "\x0e\x0b\x06\x3c\x3f\x1a\x1b\x80\x24\x95\xa3\x49\xf7\x7b\x8b\xad\xea\x8a\xc1\x05\x4f\x9b"
          "\x99\xba\xbc\xeb\x0f\xdf\xf4\xc9\x80\x36\x0f\x44\x51\x8f\xfe\xef\x9f\x78\xe8\x0f\x50\x98"
          "\xe2\x6e\x2f\xf3\x40\x45\x60\x9c\x0c\x92\x9b\x2f\x62\xfb\x7e\x7e\xd1\x02\x2f\x09\x56\x3a"
          "\x81\x02\xae\x8e\x02\x70\x2e\xf7\x5f\x77\x31\x3a\x6c\x65\xdc\xcd\x7f\x66\x9b\xa8\x2e\x01"
          "\x5e\xbb\x33\xb3\xf8\x40\xda\xfc\xb8\xb5\x36\x5c\x64\x5a\xd0\x0a\x8e\xff\xf9\xec\xcf\x79"
          "\x17\xb0\x23\x96\xe4\x12\x64\x1a\x87\xb9\x9c\x78\x56\x64\x6b\x44\xd6\x98\x7b\x08\x66\x40"
          "\xd3\xc8\x16\x5a\x87\xa6\xc4\x86\x8c\x1b\x98\x5a\xf3\xae\x0f\xbb\x34\x59\xb7\x8a\xc8\x7e"
          "\x9c\x5a\x8c\xa8\x76\x3c\xa2\x8c\x41\x49\xda\x04\xba\x59\x7c\x82\x9d\x15\xc8\x7e\x21\x74"
          "\x28\xba\xf4\xf6\x9c\xd1\x6f\x1a\xc2\x10\x11\x29\x13\x8b\x83\x11\x9b\xa8\xe5\x2a\xe8\xcc"
          "\x44\xe8\x46\x43\x1b\x0c\xb6\xa2\xa6\x6c\xcc\x2d\x7f\x31\x91\x5f\x83\xbc\xd6\x43\x60\xb4"
          "\x33\x82\xee\x4f\x17\x00\xdb\xbb\x82\x0d\xb2\xeb\xcf\x25",
          1, 3456 },
        { 128, 256, 90,
          "\x05\xb3\xff\x7f\xad\x47\x36\x9f\x48\xd2\x77\x94\xc1\x08\xb9\x9b\x54\x70\xed\x26\xed\xaa"
          "\x51\xe5\x66\x3b\xbf\xec\xbe\x8f\x77\x55",
          "\x9f\xaa\x55\x5e\x47\x7b\x8c\x32\x53\xca\xc8\x0f\xe5\x43\x1f\x7f",
          "\x78\x9e\xea\xe8\x65\xd7\xc7\x04\x52\xe1\xdf\x56\x13\x8f\x90\xd5\x7f\x65\x1b\x8d\x9b\xf8"
          "\x03\x0f\xfa\xd5\xe7\x12\xbb\xca\xa3\x30\xb5\xc1\xa1\xb2\x2a\xa8\xcf\xd6\xdb\x51\xa8\x39"
          "\x83\x81\x35\x14\x61\x86\x79\xf4\x63\xa7\x32\xe2\x43\x51\xa5\x14\x6b\x61\x41\x4f\x96\x4a"
          "\xda\x57\x1e\x1d\x1a\x3f\x66\x15\x66\x7c\xa1\xff\x32\xcc\x59\x52\xdc\xf5\x7a\x9a\xa8\x9f"
          "\x65\x0b\x01\x44\xef\x81\x36\x64\xff\x2a\xc3\xc2\x21\x24\x1a\x72\x96\x92\x4f\x7e\xac\x40"
          "\x40\x24\xf6\x0b\x15\xef\x01\xfc\x9c\xc9\x2b\x8d\x1a\xf7\x2b\x3d\x3d\x65\x45\xca\xd0\xa0"
          "\xa3\x02\x2a\xeb\x71\xb0\x58\xc9\x13\x83\x93\x16\xb7\xd0\xce\xbb\x13\x49\x63\x61\x3b\x83"
          "\x15\x43\x73\xaf\xa6\x30\x67\xa2\x38\x18\x15\x67\x82\x8e\x1c\xc0\x63\x20\x79\xd6\x71\x2e"
          "\x40\xf9\xc7\x37\x5e\xcb\x4f\xd9\xac\x20\x3b\x3f\x45\x3c\x59\x51\x63\x04\xc9\x62\x3f\xb5"
          "\x6a\xca\x67\xf9\xc0\x0f\x4f\x25\x28\x37\x19\x0d\xfc\x8d\x96\x23\x1d\x71\x7b\xd4\x2f\x81"
          "\x04\xdc\xc3\xea\xf1\x5e\x3a\xe7\xbf\xc3\x64\x71\x44\xb6\xde\x7d\xe6\xa0\x83\x9e\xf8\x76"
          "\xe5\x93\xe9\x12\x27\x38\xfa\xde\xa8\x1a\x51\x86\x72\x6a\x57\x8c\xc0\x7f\xec\xae\x35\x0b"
          "\x3f\xba\x46\xe7\xad\xa8\x81\x96\xb4\xc7\x6a\x4e\x3d\x97\x67\x1c\x60\x79\x11\xbc\xad\xb6"
          "\x99\x8b\x53\x8e\x2a\x37\x54\x1c\x1c\x21\x4c\x63\x23\x67\xd0\x58\xe7\x6a\xce\xe3\x40\xbb"
          "\xa2\x37\x68\x62\xa7\x85\xf4\x72\xbb\x2b\x0d\x9a\x10\xca\x67\x1f\x21\xc2\x2b\xbf\xc4\xe4"
          "\x4f\x99\x57\xf4\xc3\xc1\x47\x19\xb7\xf0\x5a\x47\x74\xd0\xb8\xf2\x2c\xa7\x9f\x95\x61\x50"
          "\xfb\xde\xdf\xec\x57\xa6\xf0\xdd\x28\x9f\x31\xcd\x79\x68\x7b\x1d\xfa\x1d\xde\x6e\xe8\x9e"
          "\x4f\x60\xbd\x1e\x07\x4c\x1d\x20\x1f\x6c\x48\xab\xd0\xb5\x53\xd5\xa4\x34\x71\x57\x5c\x85"
          "\x98\x9a\x16\x2b\x7b\x78\x84\x19\x11\x04\x33\xf4\x24\xc5\x19\xcb\xa1\x51\xa2\x80\xd7\x17"
          "\x63\x3a\xdb\xcb\x23\xd1\x4a\xfc\x12\xbb\x28\xd5\x0c\x84\xb2\xe9\x52\xb3\xff\x47\x60\x55"
          "\xc7\xf7\x40\x00\x0a\x68\x30\xb5",
          "\xd2\xe2\x7c\x06\xd9\x66\xb7\xe5\x33\xd8\x4e\x30\x0e\x7f\x52\xe8\xa6\xf8\x5a\xc6\xf4\xb3"
          "\x1e\xef\xcd\xdc\xc5\xb2\x1b\x1a\x05\xbf\x8c\xcc\xa2\x2c\x01\xc2\xfd\x7b\xdd\xdd\x41\x30"
          "\x15\x5e\x44\x66\x32\xf6\x6e\xf3\x3f\x0f\xcb\x90\x57\x0f\xd3\x32\xb0\xb4\x74\x1b\x4b\x99"
          "\x12\xdb\xaa\x0d\x7c\x07\xad\xbd\x44\xf4\xdc\x88\x46\xd6\x86\x46\x2e\xe9\x59\xe9\x2c\xee"
          "\x33\x33\xbf\x73\x53\x3a\x47\x35\x9e\x9e\xf9\x3e\xc2\xc8\x58\xe1\x30\x15\x38\x62\x9f\x42"
          "\x70\xd5\x12\x16\xc4\xdc\x77\xd7\xed\xf2\xec\x1e\x7e\x23\xbb\x6d\xc7\x4c\xaa\xe1\x2d\x7c"
          "\x97\xe1\x7d\xa0\x02\xd4\xdd\xc1\x10\x12\x37\xb3\x5e\x51\x30\x65\x82\x51\x49\xa0\xf0\x62"
          "\x20\x8a\x7a\xcb\xda\x33\x54\xd0\x80\xf3\x99\xdf\x8e\x5d\x4e\xb7\x5a\x1a\x3b\x44\xe1\x91"
          "\x09\x9e\x64\x22\x1e\x6d\x2a\xc5\x26\x56\xc9\x61\xb0\x6f\xb8\xc3\x72\x7c\x59\x50\xb4\x2f"
          "\x7c\xc7\xc1\x73\x5d\x65\x67\x40\x50\x6b\xcd\xc1\xbd\xc8\x73\x3f\xc1\x93\x0b\x49\x0b\xbf"
          "\xc7\xa0\xc9\x2c\x83\x61\xf5\xfa\x4e\xac\x58\x05\x8c\x1a\x88\x70\xe6\x07\x23\xd7\xf1\x56"
          "\x61\xc1\xae\xee\xbc\xa6\xa5\x72\x06\xe0\x92\x10\xe3\x50\x69\xe7\x13\xb7\xcf\x18\x96\x24"
          "\x8e\xd2\x31\x77\xbb\x00\x10\x0d\xbf\x62\xa7\xa0\xb5\x46\x28\x93\xa1\xe4\x69\x88\xb9\x6c"
          "\xc3\xd3\xdf\x62\xbc\xbe\x72\xf2\xed\x9d\x90\x99\xdc\x88\x80\x47\x35\x91\x2a\x31\x4f\x1b"
          "\x22\xe4\x04\xc7\x0c\xbf\xd7\x19\x9e\x87\xb1\xc6\x4d\x10\x7c\x36\x50\x4b\xd5\xfa\xf3\x5c"
          "\x25\x64\x87\x61\x80\x97\x3f\xac\xa4\xb0\x45\x20\x42\x46\x63\x23\xed\x45\x99\xd8\x17\xa1"
          "\xe7\x96\x7f\x6c\xf0\xc0\xf4\xe2\x88\xf9\x95\x98\x9e\x0f\x3c\x20\xf5\x90\x20\xa2\x77\xa1"
          "\x56\x8a\x61\x65\x75\x0a\x22\x5d\x58\x7e\x4e\xdd\x5c\x17\x7a\xad\xbf\xec\xed\xad\xf8\x9d"
          "\x0b\x78\xf9\x1c\x2d\xd4\x2a\xd0\x27\x3a\x08\xdd\xce\xb5\x0d\x5c\xa7\xdf\x23\xbc\xdc\xda"
          "\x21\xe8\xee\xc5\x25\xac\x10\xcb\xdd\x55\x95\x17\x29\xee\x54\x09\x0a\x37\x4d\xd4\x35\x12"
          "\x4c\x8b\x88\x25\xd5\x58\xbb\xaa",
          1, 3584 },
        { 128, 256, 91,
          "\x10\xe6\xf8\xa6\xd6\xcc\xb6\x6d\xbc\x76\x93\x88\x9f\x39\xe2\x56\x80\xde\xa3\xac\xa8\xfc"
          "\xba\x75\x36\x5a\x94\x37\x2c\x7e\xbe\x86",
          "\x0b\x04\xde\x61\xe0\xc0\x54\x30\xd9\x72\xa5\xd5\xdb\xc2\xa2\x42",
          "\xc3\xda\xac\x4e\x04\xc1\xd8\x2a\x51\xc8\x18\x7e\xcc\xcb\xe9\x75\x6f\x79\xb1\xd1\x28\x28"
          "\x18\xa5\xbf\xcd\x07\x9a\x73\xfa\x1b\xc5\xe9\x90\xfa\x26\x36\x00\xf7\xea\x83\x86\x54\xad"
          "\x52\xc0\xf9\x61\x75\x3e\x15\x03\xb4\xf0\xdd\x7d\xfa\xd6\x4d\x80\x4a\xe8\x39\x51\xf7\x36"
          "\x2f\x07\x00\x1c\x0a\x4c\x7c\x91\x1b\x40\x38\xc9\x51\xc1\xd7\x01\x19\x35\x41\x34\x7e\xc7"
          "\xfe\xb8\x85\x08\x78\xef\xd3\x7a\x9e\x3f\x3b\xb1\x69\xef\xb4\x71\xca\x45\xb5\xc4\x48\xfe"
          "\x5e\x3d\x56\x49\x1f\xb3\x24\x2e\xf2\xaf\x32\xfc\x42\x41\xc3\x3f\x41\xf9\x04\xb1\x4e\x01"
          "\x42\x89\xaf\x8b\x74\x69\xaa\x69\xf8\x25\x52\xa8\x0c\xb0\x68\x58\xfc\xc0\x89\xf3\x3a\x9a"
          "\xde\x7a\x85\xf3\x42\x39\xa6\x16\x5f\x40\x40\xfa\xfb\x5e\x41\x98\x6f\x7c\x5c\x8d\x26\x07"
          "\x11\x84\xc1\xf9\x4f\xe9\xc1\x20\x80\x1f\x14\xee\xfe\xeb\xcc\x0e\x7a\x27\xee\x31\x02\xbb"
          "\xae\xd2\xae\xe1\x88\x30\xeb\xbd\x9f\x12\x51\xa2\xa8\x1f\xb9\x55\x6d\xe6\x13\x0e\x42\x6a"
          "\x45\xec\x50\xf6\x0a\x21\xea\xa6\xcc\xb2\x93\xaa\xaf\x87\xee\x40\x8a\x4a\x5d\x39\x08\x03"
          "\x06\x70\x00\x4c\x05\x03\x98\xd0\x8d\xe6\x7c\xe7\xfe\x85\x6b\x73\x1d\xe6\x6d\x7c\x4c\x2f"
          "\xdc\xba\xfe\xa2\x55\x4d\x62\xec\x5a\x09\x33\x19\xf5\x86\xf7\x78\x85\x34\x3f\x9e\xe6\x2a"
          "\xfb\x1c\x2d\x9b\x28\x72\x53\x7c\x84\x5e\x4a\x79\x3a\xcf\x5a\xe8\xf4\x65\x9c\x10\x59\x71"
          "\x6f\x30\xb6\x1a\x9a\x43\x45\xc5\x26\x65\x88\x5f\xeb\xd7\x48\xbb\xd9\xf2\x69\x04\x93\xe4"
          "\xe8\xc1\x9a\x82\x2a\x39\xfd\x57\xd0\x2f\x32\xb2\x89\xa1\x76\xc9\x81\x28\xa6\x72\x78\xbd"
          "\x92\xe9\xee\x6b\x33\x4a\x72\x94\xd9\xfc\x72\x3a\xf1\x9f\x8a\xf2\x4b\xde\xe9\xde\x59\x4c"
          "\x7b\x4c\x8d\x7d\xa6\x16\xb3\x6e\xa3\xd1\x6d\x79\xbc\xc8\x71\xd6\x31\x5b\xfd\x87\x1d\xca"
          "\x49\x2f\xe2\x5c\x4f\x2c\x05\x89\x47\x9b\x58\x06\x5d\xe2\xf7\xea\x8b\x75\xbb\xae\x40\x49"
          "\x66\x93\xa6\xee\xc5\xa5\x52\xa1\x90\x33\x1c\xe2\x91\xf7\x41\xc6\x84\xc9\xd2\x16\x52\x90"
          "\xf2\xca\x1c\x5c\xb4\x05\xe3\x3e\x1d\x4c\xdf\x23\xe2\x64\xd3\x24\x57\x83\xb5\x0d\xf6\x12"
          "\x71\x60",
          "\xf1\x5f\xdf\x24\xf6\x28\x28\x4a\x9a\x0a\xf9\x4c\x91\xee\xcf\x4b\xbd\x33\xcc\x5c\xf5\xd5"
          "\xc1\x60\x66\xbe\x0e\x95\xec\x06\xee\xe4\x2a\x7d\xee\x76\x36\x83\xf9\xc9\x3f\x64\x82\xc9"
          "\x59\x0e\x4a\x82\x0c\xe2\x9d\x7e\xfe\xdb\x69\xb3\xb2\x99\xd2\xf0\xef\x73\xdc\xea\xfb\xd8"
          "\xdb\x82\x93\xd7\xf5\xfe\xd1\x44\x95\xe1\x8d\x37\x2a\x53\x6a\x95\x83\x88\x14\x81\x6d\xe8"
          "\xb9\x8b\x7f\xf5\xce\x01\x95\x44\xdb\x97\x94\x73\x12\xdb\x6c\x98\x00\x85\x6a\xe7\x52\x78"
          "\x98\xd8\xeb\xa6\xd3\x37\x8c\x8a\x3b\x40\x0c\xf4\x55\x3e\x7b\xca\x9f\x51\x01\xa8\x48\x90"
          "\x4b\x5c\xbe\x24\xa6\xfc\x8a\xee\xd1\x78\x9d\x20\xa0\x11\x0a\xf1\x45\xdc\xf7\xd7\x0b\x5f"
          "\x33\x6e\x41\x12\x56\xc0\xba\x60\x42\xe6\x9b\x97\x6d\x1b\x18\x17\x68\x11\x65\xd8\xf8\x85"
          "\x0e\x0a\x2a\x34\xe6\xb1\x93\xf9\x05\x08\x76\xb5\x32\x47\x16\x56\xd4\xa7\xd0\x80\x99\x84"
          "\xd2\x6f\xa6\x81\xd1\xb1\xe1\x45\xf8\x22\x0c\xde\x6f\x1d\x98\xe2\x61\x14\xd5\x78\x08\x8e"
          "\xbf\xa8\xd7\x5b\xb4\x1a\x53\xa5\x7c\xc3\xe6\x05\x27\x09\x76\x70\x14\x3e\x51\x56\xf5\x00"
          "\x54\x3a\x2c\x00\xbd\x95\x56\x04\x96\xe1\x94\xe7\xde\x1a\x1f\xb7\x60\xe2\x1a\x97\x09\x84"
          "\x3d\xf9\xb9\xa3\x39\xdc\x98\x80\xf2\x89\x32\x1b\x61\x0a\x8d\xaf\x04\x89\x8e\x4c\xe5\x91"
          "\x63\xee\xda\x65\x8f\xd2\x65\x43\x93\xe8\xbe\xc1\x7c\xba\xa5\xd7\x87\x86\x19\xaa\xd1\xc6"
          "\x73\x87\xfe\x2a\xac\x5b\xcd\xfe\xf8\x8c\x19\x06\xbc\xcc\x21\x3d\x76\x0b\xff\xea\x03\x68"
          "\x02\xb7\x92\x48\x38\xd6\xd4\xcf\x32\x68\xf9\xb1\x80\x46\x34\xa6\x7b\x53\xfe\x49\x36\x03"
          "\x03\x2f\x73\x70\xe0\xdf\x12\xf5\x30\x15\x77\xbd\xb3\x8e\x17\x79\xaf\x61\x59\xfd\x95\xf6"
          "\xa6\x78\xb7\x37\x9c\xe2\x3a\x49\x8b\xab\xe4\x67\x45\x81\x21\xf1\x8c\xea\x26\xe1\xd8\xb5"
          "\x84\x75\x55\x0c\x74\xc4\x09\x34\xc7\x1b\x27\x7f\x65\x76\x7f\x66\x48\xec\x97\xdf\xcd\x31"
          "\x1c\xec\x11\x7f\x24\x85\xdf\x1d\xb0\x97\xc1\xd0\x1c\xa0\x72\x29\xaf\xd5\x4a\xc8\x90\x69"
          "\x52\x9e\xf2\x37\x57\x57\xcf\xaa\xec\xac\x70\xaa\xd2\x57\x2a\xf9\xb4\xf4\xa6\x7f\xbc\x28"
          "\x15\x78",
          1, 3712 },
        { 128, 256, 92,
          "\x9c\xad\x46\x2d\x5f\x66\x59\xb2\xdd\x89\xa6\x8d\xaa\x5b\x7f\x14\x64\x4b\xa2\x48\x82\xc3"
          "\x7e\x97\x32\x23\xac\x4a\x87\x5e\x51\xb3",
          "\x92\x69\xb2\x44\x71\x08\x02\xc3\x7e\xc0\x1a\x38\xfc\xae\x78\x2b",
          "\xf9\xe5\x63\x06\xd0\x1d\xd5\x5d\x4c\xde\x17\x40\xe6\xf0\xbd\x2a\x2a\xa9\x89\xf8\x52\xf0"
          "\x89\x20\x37\x60\x1f\xd7\x1d\x15\x0e\x40\xb5\x1c\xa0\xb0\xc5\x32\xc1\x64\x84\xca\xb4\x8b"
          "\xb7\x7b\xad\x85\xe7\x65\x21\xbd\x6a\x65\x53\xe9\x3f\x50\x22\xd4\xee\xb0\xa6\x98\x6b\xf0"
          "\x14\x01\xa9\x5d\x76\xdd\xd6\x34\x10\xfd\x5c\x75\xbe\x7e\x69\xde\x08\x9e\x27\xfc\xd5\xcb"
          "\xb1\x1a\x6b\x4c\x1b\xec\x80\xc8\xd9\xc0\xfb\xa9\x51\x4f\x62\xdb\x57\x3b\xf0\x7b\x16\x10"
          "\xcd\xd9\xbf\xcf\xff\x71\xd7\x9c\xf7\x4c\x8e\xc2\x5d\x2e\x39\x03\x6e\xb7\x03\x93\xc5\x04"
          "\x02\x40\x19\x79\x35\x88\xc7\x62\xf3\x85\x81\x4b\x4b\x31\x1b\x1e\x04\x67\xcb\x38\x34\xd3"
          "\xc4\x30\x73\x44\x25\x04\x8e\x6a\xfe\x40\xee\x83\x80\xf5\xb0\x8c\x8a\xe1\x58\x17\x2d\xea"
          "\x9c\xa5\x31\x51\xc3\x50\x93\x3c\xed\x0f\x42\xde\x8b\x01\xc5\x16\x7c\xd8\x6b\xe0\xa6\xc5"
          "\xc4\x5e\x3a\x66\x1b\x7a\xb6\xf5\x1c\x73\xee\xb8\x70\x7c\xa4\x58\xc8\x26\x1f\xc8\x83\x19"
          "\x02\x80\xfa\xde\x3d\x92\x05\xff\x40\x4a\x69\x3d\xf7\xe2\xe4\x09\x24\x15\x7e\x2e\x20\x1e"
          "\xc0\x94\x44\x49\x43\xcb\x24\x92\x5f\xed\xd4\x94\xaf\xa7\x8a\x7d\x85\xd9\x07\x34\x51\x63"
          "\x5a\xe8\xf0\x9e\xc9\x59\x85\x8d\x58\x7d\x3b\x89\x4e\x9a\x46\xb3\x1d\x7a\x64\xf7\x5c\x7c"
          "\xa9\xcc\xe7\x69\xa1\xf2\x7c\x2f\xdc\xad\x5d\xf8\x62\xeb\x34\xdb\x48\x5f\x58\x91\xb4\x99"
          "\x38\x3e\x49\x4e\x26\x67\xb9\x9c\x5b\x91\x3b\xaf\x6d\xd0\x50\xdb\xa9\x87\xdb\x14\x99\xd9"
          "\xa8\x5e\x21\x4e\x85\x7b\xa9\x81\x4e\x5c\x7e\x39\x4f\x6b\xfd\x61\xa4\xc3\x37\x6d\x46\x68"
          "\xbb\x11\x09\x73\x0d\x81\x54\xf3\xd3\x7c\x01\x0c\xa3\xbf\x59\xd5\x4e\x82\xfd\x26\xbc\x76"
          "\x64\x5a\x57\x11\x4c\xb0\x25\x98\x29\x5d\x0e\x06\x1e\x51\x20\xaf\x9c\x7e\x4e\xc1\x99\xe6"
          "\xed\x59\x0c\x0e\x58\x99\x11\x8d\x43\x2d\x67\x4b\x1b\x6d\x61\x17\x80\xc9\x96\xc6\x85\xb0"
          "\xdb\x4a\x20\x3a\x1a\x8b\xb8\x14\x08\xdc\x6e\x94\x79\xfd\x43\x60\x75\x96\xdf\x1f\x6a\x39"
          "\xd7\x7c\x94\x7c\x92\x44\x7f\x79\x00\x15\x0f\xc1\x8b\x43\x5d\xbd\x14\xdb\x2a\xff\x4e\x7f"
          "\xd3\x88\xfc\x8d\x88\xe0\x4c\xb8\x2c\xaf\x17\x09\xff\x51\x5d\xe4\xd5\x5d",
          "\x21\x7e\x55\x06\x98\x60\x00\x34\xd3\x31\xf4\x9e\xd6\xb4\x85\xbb\x7f\xd4\x75\xf6\xda\x9b"
          "\x03\xed\x78\xc4\x84\x70\x05\x41\x14\x53\x98\x13\xbe\x0d\x46\xeb\xe8\x36\x25\x50\x6d\xe4"
          "\x37\x37\x59\xf7\xb8\xac\xf6\xaa\x2e\xc1\xfe\x8f\x60\x24\xc8\xb8\xdf\x63\x45\x83\x05\xb0"
          "\xb6\xb2\x5e\x90\xef\x7c\x41\x1d\xf5\x98\x1d\xe5\xd4\xb8\x9d\x95\xa5\xb2\x5d\xf9\x4c\x8a"
          "\x81\xf4\xf4\x93\xb1\x6e\x87\x55\x15\xfb\x02\xf9\x43\x17\xf1\xea\xd6\x9b\x53\x0f\x2c\xbc"
          "\xfd\xb0\x79\x06\xcc\xee\x6e\x1f\xe4\x67\x12\xe0\x72\x45\xe2\xb1\x50\x05\x47\x46\x8d\x3a"
          "\x5e\x14\x9d\x14\xd4\x00\x22\x9a\xf1\xf0\xaa\x1c\x39\x9c\xa7\xed\x0b\x7b\x40\x43\xb3\x77"
          "\x66\x96\xf1\xc0\x26\x84\xb8\x66\xcf\xe8\x5e\x9c\x93\x78\x70\x7b\x3e\x24\xfe\x6e\x25\xde"
          "\x24\xc6\x07\xca\x40\x7a\xca\x43\x2c\x33\x1d\xa2\x4d\x22\x87\xf0\x47\xba\xe3\xd3\x88\x98"
          "\x34\x02\x65\x8b\x92\xbe\xa6\x72\xc4\x1b\xcc\x67\x93\x5a\x68\x7f\x53\x41\x39\x77\x64\xe4"
          "\x58\xf0\xd8\x8a\x5d\x05\x09\x66\x3b\x91\xd4\x81\x3a\x6f\xaa\xd2\x4b\xdb\x60\x8a\x28\x06"
          "\x1d\xd0\x94\xa5\x0e\x75\x4d\x78\xdd\x74\xdd\x15\x6d\xa3\x15\xa3\xea\xf3\x64\xea\x33\x33"
          "\xed\xfa\x80\x8b\x9a\xd6\x26\xad\x89\xb6\x52\x1a\x1a\x52\x85\xb7\xcc\xf6\x08\x46\xf4\xe6"
          "\x80\x7f\x2c\xc4\xd0\xe1\xa4\x90\x11\x71\x2c\xad\xcf\x89\x7e\x14\x7a\x98\x1a\xd5\x5b\xbb"
          "\x2b\xdd\x35\xf3\xbf\xc4\xac\xe8\x1f\x5f\xf7\xcd\x8a\xc9\xd3\x8b\x7d\x46\xf6\x63\x9c\x07"
          "\x4a\xc8\xee\x6a\x9b\x16\xf0\xfa\x6a\xf8\xc1\xd1\xa3\x53\x07\x84\x06\x75\xcf\x71\xde\x9c"
          "\x81\xee\x03\x11\x10\xb5\x36\x00\xba\x57\x2a\x57\xb6\x4c\x67\xa1\xdd\x5b\x1e\xd5\xbe\x9c"
          "\x94\x9a\xf6\xea\xc4\xdf\x89\x76\xd7\xaa\x1d\xc8\x18\xca\xed\x95\x37\xad\x37\x2f\x33\x2a"
          "\xcc\x6f\x2d\xb2\x90\x4c\x3a\x55\x0c\x31\x8f\x39\xd3\xc9\xc6\x9c\x71\x09\x6f\xd4\x5b\x0c"
          "\x85\xb4\xfd\x52\xd4\x72\xca\xc9\x14\xbb\x5b\xcb\xa3\xba\xad\x93\x91\xcc\x00\x1d\xfe\x34"
          "\xab\xa3\x76\x16\x6d\x63\x8f\xaa\xb1\x01\xf6\x2e\x00\x62\x32\x08\xa1\x08\x08\x90\x00\x52"
          "\xef\xcb\xc6\x71\xe2\x36\x8a\xf8\xe3\x44\x6d\xec\x7c\x60\x48\x8f\xbb\xc3",
          1, 3840 },
        { 128, 256, 93,
          "\x61\x64\x7d\x8f\xf7\xa1\xa3\x11\x5f\x78\xb4\x8a\x99\xc1\xc1\x5b\xc7\x3e\x92\xe0\xb9\x92"
          "\xb8\xe2\x70\xcc\xde\xbf\xa2\xfe\x2d\x03",
          "\x31\xdb\x2d\x86\x31\x22\xce\xbe\xdc\x1f\x84\x08\x80\x17\x3a\x33",
          "\x09\x2b\x86\xb9\xb9\x3c\x35\x52\xf4\xc9\x6f\x89\xe9\xf5\x18\x75\x40\x65\xac\x16\x59\xd5"
          "\x48\xc9\x9d\x23\x31\x8c\x33\x2b\x50\x46\x15\x8c\xa1\xd0\x20\x8b\x80\x5b\x09\xc4\xac\xc1"
          "\x72\xd3\x07\x4a\x03\x26\x25\x65\x8c\xdf\xc2\xfc\xc5\x66\xbf\xd1\x41\x22\xff\x69\x2c\x56"
          "\x8e\x20\x11\xf9\xb3\xb3\x69\xd3\x70\x02\xf8\xc4\x11\xbf\xe3\xa5\x34\x3a\xa6\xa4\x9d\x28"
          "\x7a\x0f\x6c\x97\x35\xcf\xf2\x45\x80\x64\x42\xa6\x21\x4b\x89\x3f\xd3\x00\x93\xaf\x51\x86"
          "\x78\x4a\x4f\xb1\x91\x1d\x4b\xc2\x4c\x54\x3e\x87\x9e\x4b\x4e\x0a\x80\x66\xbf\xa1\x02\xd0"
          "\x5a\x4e\x00\x6f\x76\x05\x9b\xd0\x9d\x0b\x3f\x7d\x83\xed\xc5\xb6\x70\x20\x96\xc6\x0f\xb8"
          "\xcb\x97\xd1\xf0\x87\xa3\xea\xa8\x9e\x09\xe7\xe4\x48\xeb\x7c\x8e\x23\xa1\x09\xf5\x4d\xe0"
          "\x21\x42\xfc\xcb\x3f\xdf\x83\x65\xa6\x8c\xf4\x06\x0f\xbc\x58\x6a\xd7\x04\xba\x75\x8b\xac"
          "\x2d\x04\x3d\x2d\x0f\xda\x92\xa5\xb1\xe8\x37\x86\xa8\x79\xa0\x09\x9b\x00\xf6\xef\xab\xe3"
          "\x34\x6e\xc3\xdc\x1b\x3a\x07\xd9\xb7\x9a\x1f\xdc\x39\x88\x76\x32\xc2\x92\x37\x23\x4a\x03"
          "\x14\x48\x2b\xf4\xac\x16\x0b\x8e\x0d\x27\xe5\xe1\x60\xb1\x99\xfe\xb0\x8c\x40\x5b\xa3\x60"
          "\xfc\x84\xc3\x72\x2f\x7f\xae\x58\xab\x5c\xc7\xde\x68\x86\xec\x38\x31\x68\xdb\xb5\x73\x84"
          "\x26\x68\xfe\x05\x90\x2f\xa2\x82\xed\xa1\x34\x5b\xa1\x52\x47\x9a\xb4\x23\x1b\xe8\xf6\x1b"
          "\xda\x6b\x36\x70\x6e\xee\xba\x30\xf5\xea\xf4\x50\xb3\x44\x7c\x4a\xab\xbc\x42\xe3\x1f\x0e"
          "\x90\xde\xc8\x2a\x65\xab\x3e\x32\x0e\x66\x24\xfa\x86\x4a\xc8\xf3\x6e\x9c\x5e\x99\x45\x9b"
          "\x47\xf2\x49\x51\x70\x8a\x13\x27\xba\x55\xe7\xcb\xa8\xd7\xf6\x65\x7b\x8f\x27\x68\x01\xb8"
          "\x3d\xe3\x66\x4c\x6c\xaf\xa9\xbd\x0d\x87\xbe\xdd\x36\x30\x81\xa9\xd9\x42\x8a\x58\x68\x90"
          "\x53\xd1\xf0\x5a\x29\x25\xc5\x25\x5b\x05\x0e\x2b\x6e\xff\x37\xda\x1c\x2a\x88\xc2\x19\xd6"
          "\x3f\xfd\x58\x22\x38\x27\x11\xe1\x5d\x09\xfd\x52\x56\xec\x3a\xc4\xa0\x49\x08\x06\x69\xa7"
          "\xb0\x12\x67\x57\x58\xfc\xdd\x6a\xf5\x65\x76\xc9\x07\x51\xe6\xf2\xe9\x85\xcb\xea\xd8\xcb"
          "\x75\x5e\xd5\x9a\x33\x05\xf8\x05\xbc\xef\xc6\x3e\xc7\x6b\xe1\xaa\x80\xd4\x5c\x95\x31\xa1"
          "\x9f\x4a\x0c\x80\x88\x41\x9a\xb0\xa1\xf1\x95\x10",
          "\xe3\x25\xfd\x1b\x32\x97\x8b\x74\xa9\x9e\xf1\xb7\x2e\xb3\x3c\xf2\xc7\x1a\x79\x78\x9c\xd3"
          "\xbe\xa0\x8c\x78\x9e\x6d\x14\xce\x27\xdb\xa4\xc3\x4c\x47\x71\xdd\x49\x04\x20\xf8\xd4\x9b"
          "\x34\x02\xab\xde\xa9\xe5\xa7\xc7\xc0\x77\x2e\x31\xce\x0e\x30\x8b\x2d\x1e\xa9\x60\x17\xc2"
          "\x95\x08\x29\xe9\xb8\xe6\x13\x1d\x2c\xa8\x64\xb5\xd4\x97\xdf\xf7\x5b\x26\x1e\xd9\x78\x38"
          "\x3c\x09\xd6\xbb\x5e\x8b\x1b\x7f\xe9\x34\x4a\x88\xb3\x45\xc6\xb4\xa2\xe5\xcb\x88\x4e\xd0"
          "\xd0\xf5\x39\x3e\xec\xec\x3f\x3a\x32\xa4\xc5\xee\xe0\xc5\x3e\x95\xb2\x1e\xcb\xa2\xe3\x4c"
          "\x74\x61\x62\xb4\x9b\x78\xca\x18\x75\x09\x72\x7d\xdf\xa1\x7d\xaf\x44\x3a\x9b\x45\x26\x54"
          "\xb5\x73\x4f\xc3\xbc\xc7\xa2\x5c\xe8\x95\x67\x6d\x1f\x39\xec\x9a\xa3\xc0\xd4\x15\xe9\xd9"
          "\xc3\xdc\x17\x3b\x16\x79\x9c\x01\x6e\x8e\x21\x62\x59\x36\x99\x87\xa2\xc3\x66\x72\xb4\xad"
          "\x99\xf7\xb7\x1b\xd3\xce\xeb\x86\x3a\xeb\x4d\xb7\xae\xe2\x31\xce\x63\x47\x87\xc5\xab\xff"
          "\x5a\x87\xe7\x8d\xe7\x29\x7b\xa0\x80\x38\x37\xb5\x80\x3d\x79\x01\x26\x85\xa2\x4d\xbd\xd0"
          "\xd7\x2c\xfb\x2b\x33\xb3\x46\x49\x64\x26\x6a\xcc\xd8\xde\xdb\x84\x7f\x4c\xff\x61\xc2\xf9"
          "\xd5\xe1\x7b\x2e\xaf\x22\x3e\xe5\x2f\xd1\x81\xec\x83\x44\x54\x3a\x05\x3b\xc0\xdb\x86\x15"
          "\x55\xd5\x0e\x2b\xfc\xe3\x05\x60\x14\xcb\x5a\x6a\x96\x4b\xd0\x32\xc6\xe1\x21\x0b\x18\xd3"
          "\x40\x2e\xff\x42\x91\x02\x41\x9d\x3b\x00\x0c\x51\xd5\x72\xb0\xed\x6e\x89\x98\xb0\xdb\xd1"
          "\x8c\xc4\x4a\x27\xab\xbf\xdb\x14\xbd\xbc\x12\x80\x56\x8b\xaf\x63\xad\x74\x30\x13\x44\x90"
          "\xb0\x70\x5d\x5a\x24\x2e\x05\x42\xee\x8a\xfd\xb1\x23\x9d\x46\x29\x58\x29\xe9\xd7\xc0\xe9"
          "\x78\x0d\xca\x58\x9b\x1f\xb5\xa2\x24\x9a\xbc\x44\xa3\x06\xd1\x60\x4c\x29\x72\xd5\x77\x32"
          "\x3d\xf3\xb0\x9e\xe8\x40\x65\xa1\x39\xaa\xc0\x42\x07\xc6\xe5\x1f\x43\x58\x0b\x55\x8f\x54"
          "\xfd\x5a\x6d\x37\x77\x94\xc9\x9d\x70\x33\x04\xb9\xb1\x61\x15\xd8\x3f\x6d\xc5\x1a\x81\x31"
          "\x89\xd4\x63\x0b\xfb\xdb\xcc\x56\xc7\xee\xc9\x35\xf9\xcd\xaf\x5c\x1a\x52\x05\x45\xf7\xef"
          "\x04\x65\x9b\x4a\x7a\x53\xcf\x93\x28\x75\x4d\xfe\x08\x75\x3c\x85\x15\x94\x4e\xfb\x43\xe0"
          "\x5e\x50\xe9\x2f\x95\x31\xbe\xb3\x94\x11\x8b\x49",
          1, 3968 },
        /* Vectors from Auto generated */
        { 128, 128, 1, "\xe7\x2c\xcf\x7c\xf4\xe7\x61\x6e\xce\xe9\xc1\x25\xd3\x29\xcf\xd6",
          "\x8c\x65\x4a\x31\x71\xa2\x07\xb1\x3e\xf3\x5a\x83\x07\xb5\x04\x22",
          "\x9e\x0f\x5f\xd1\x66\x40\x08\x74\x3b\xe7\x7b\xf1\x41\x27\xf2\x21",
          "\xa9\xde\xe4\x24\x88\x3e\xf4\x2b\x89\x63\x60\x10\xe6\x93\xc9\xe3", 1, 128 },
        { 128, 128, 2, "\x91\xee\xcf\x96\x62\x3c\x52\x1f\x3d\xeb\x28\xea\x4b\x16\x30\x82",
          "\x4e\xd8\x2d\x68\xd3\xce\x84\x88\xad\xa9\x6a\xdd\xda\x28\x54\x4c",
          "\x81\xea\x94\xe3\xfd\x33\x59\x2e\x68\x37\x36\xff\xf3\x06\x52\x07\x06\x41\xd2\x0f\x16\x7e"
          "\x7f\x25\x08\x03\xbd\x7f\xff\x53\xbd\x76",
          "\x19\x09\x83\x1a\x0e\xd6\xbe\xa7\xd9\xbf\x1d\xfc\x79\x76\x0e\xfb\x33\x93\xc8\x95\xcb\x5a"
          "\x99\xdd\x43\xb5\x81\xaf\x3e\xcf\x5c\x8f",
          1, 256 },
        { 128, 128, 3, "\xed\x4d\x58\x8a\x7b\xf6\x94\x36\x88\x35\xa9\xca\xcd\x68\x3a\xb4",
          "\x5d\x0e\x25\xfb\xf4\x2f\x03\xcc\xdf\x5d\xd8\x96\xa3\x42\xa0\x0a",
          "\xe4\xaf\xf4\x41\xed\xc0\xaf\x31\xe5\xca\xae\x4f\xfc\xb5\xc5\x54\x5a\x71\xca\xb0\x2c\xf4"
          "\x2a\x6c\xe6\x38\xfa\x3e\x65\xfa\x03\xdd\xe3\xd7\xaa\x11\xf1\xc0\x71\x51\x4d\x37\x3d\xe2"
          "\x20\x42\x89\x3f",
          "\x50\x61\x0e\x7f\xb2\xbe\xce\xe5\x3d\x7e\xd8\x24\x74\xfb\xc5\xe5\x1b\x4b\xb5\xe0\x3e\xbd"
          "\xf7\x4e\xb0\x0e\xb8\x20\x58\x31\x74\x67\x86\x65\xe8\xb7\xa7\x33\x06\x98\x38\x9b\xb2\x8d"
          "\xef\x5b\xc9\xfb",
          1, 384 },
        { 128, 128, 4, "\xeb\x7e\x26\x83\xf1\x30\xe9\x73\x73\xce\x3d\x6e\x58\xcc\xf1\xf4",
          "\x6e\x29\xfc\x1b\x3b\x15\x29\x9b\xa1\x92\xa7\x40\xb6\xa5\x16\x8a",
          "\xbb\xe5\xbd\xd4\x9a\x39\x57\x59\xb8\x11\xbc\xa7\x8f\x06\x66\xd5\x7a\x02\x8d\x7e\x20\x5f"
          "\x08\x72\x47\x45\xe4\x26\x4b\xc0\x2d\x40\x7a\x8b\xc4\x17\x5b\xa9\x02\xb4\x71\x25\xfd\x3b"
          "\xcd\x3a\x1e\xf0\xd8\x82\xcf\x8f\x01\xfa\xa0\x05\xc6\xb0\x99\x57\x14\x00\xec\xe9",
          "\x2c\xf2\xac\x57\x95\xfa\x65\x84\xa1\x4d\xee\xde\xcf\xec\x39\x9d\xc2\x04\x1d\xaa\xfb\x4c"
          "\x92\x13\xee\xe7\x5c\x3b\x1c\xec\x0b\x5b\x9f\x41\x06\x9c\x1b\xb1\xfd\xcb\xba\x99\x06\xdb"
          "\x37\x53\xc1\x48\xde\x8e\xa5\x13\x8b\xb0\xf6\x65\xb2\xc3\xd2\xf4\xa5\xad\x29\xb8",
          1, 512 },
        { 128, 128, 5, "\x44\x58\xf9\xc2\xa1\x7b\xc8\x87\x08\xa5\x00\xe4\xba\xd8\xbc\x3e",
          "\xe1\x84\x61\x4d\x8b\x3a\x2b\x3f\xba\x2f\x1a\xd9\x43\xd3\x87\x19",
          "\xcd\x1b\xe6\x4f\x24\x9a\xe4\xe2\x61\xde\xee\x7f\x71\xef\xa2\x61\x8a\x16\x9f\x4b\xae\x6f"
          "\x89\x96\x5b\xfd\xcf\x28\x24\x60\x2e\x14\x37\x73\x94\xad\x86\x91\xc7\xd4\x48\xba\xe0\x5e"
          "\x0a\x98\x4a\xb7\x7e\x83\xdd\x64\x0f\xf2\x76\x91\xc3\x34\x7c\x61\x0d\x7c\xfc\x17\xe0\xe5"
          "\xdf\x0e\x19\xd7\x2e\x59\x10\x2f\xba\xef\x1c\xa7\xc5\xc4",
          "\xe3\xb3\xc5\x7a\xc9\x9a\x96\x1c\x60\x68\x35\x23\x62\x74\xe4\x30\x4f\x9e\xca\x36\x11\x52"
          "\xb6\x45\xe3\xce\x1d\x04\xba\xcc\xce\x89\x4a\xc0\x0d\x5d\xaf\x0b\x66\x6e\xee\x8d\xbe\xe2"
          "\x50\x3c\x53\xc1\x8c\x7e\x40\x7f\x4b\x3e\xba\xbc\xa1\xe3\xfe\x1d\xc8\x66\x63\x4c\x64\xb9"
          "\xe1\x9e\x1e\x30\x6e\x75\xd6\xed\x47\x02\x36\x58\x1b\xec",
          1, 640 },
        { 128, 128, 6, "\xce\x0b\xb4\x56\x2b\x93\x7e\x2e\x83\x2a\xec\x89\x5b\xac\x4a\x3e",
          "\xff\x1f\xa6\xc3\xd0\x2c\x5e\x57\xe0\xca\xc6\x76\xde\x6a\x4d\xc6",
          "\x67\xb3\xa4\x21\x94\x38\x8a\x51\x78\x35\xce\x27\x45\xad\xb3\x76\x5f\x28\x10\x88\xd6\x51"
          "\x44\x25\x38\xd7\x96\x8b\x1b\xd0\x57\x57\x8d\x5b\xce\x34\xa0\x62\x46\xe5\x70\x09\x32\x5a"
          "\xb8\x27\xc7\x0f\x42\x45\xdc\x4c\x87\xc4\x9a\x2c\x2e\xda\x49\xe1\x82\xfa\x32\xc2\x23\x69"
          "\x0c\xf1\xc4\xac\x6c\x2c\x30\x13\x5f\xc0\x71\xd6\x20\xd7\xf8\xc4\x0c\xa8\x4b\x12\xea\x61"
          "\x4a\x37\x86\x79\x35\x9e\xfe\x36",
          "\xad\x64\x87\x34\x60\x22\x80\x9d\xd3\x48\xbe\xc9\xfc\x94\x4f\x9b\xc4\xdd\x52\x9c\xd1\x15"
          "\xd9\x3d\x59\x2d\xe4\x2d\x6d\x40\x47\xda\xa4\x42\xe6\xa0\x63\x71\xfc\xc8\x49\x71\x69\xb8"
          "\x0c\xb5\x01\xa7\x2c\x80\xe5\xa6\x74\x6d\x57\x30\xc7\x90\xaf\xe0\x88\x76\x85\xd8\x3f\x83"
          "\x0f\x79\xca\x46\x9c\x61\x65\xcb\xb6\x5a\x00\x8e\x34\xac\x21\xa9\x50\x02\x1a\x83\x3e\x52"
          "\x7c\x05\xee\x03\xe8\xe9\xa8\x87",
          1, 768 },
        { 128, 128, 7, "\x61\xa5\x86\x67\x12\x8a\xbf\xad\x14\xe7\x91\xc2\xbe\xca\xf0\x37",
          "\x7d\x5b\xbb\x97\xa0\xcc\xce\x20\xe4\x97\x8d\xfe\xa4\xef\x03\xb9",
          "\xf1\xdc\x5d\x5d\xa0\x0c\x6a\x1c\x9f\x99\x48\x1f\x42\x76\x9f\x69\x06\x3e\x3d\x33\x4c\x99"
          "\xe2\x2c\x55\x58\x28\x9a\x64\xfb\x1e\x73\x0b\xf3\xbe\xa8\x48\x70\xb9\xe1\xae\xaf\xc1\x2e"
          "\x18\x24\xa7\x3f\x96\x65\xa1\xfc\x39\x97\x93\x4a\x79\x6c\x2b\xd0\x6a\x74\x85\x2b\x72\xdc"
          "\x56\x55\xf5\xa1\xad\x83\xf2\xcd\xf1\x27\xa6\xab\x7c\xa1\xa5\x26\xdd\x6b\x9b\x8f\x2d\x50"
          "\x8a\xe9\x6a\xaf\x29\xb3\x6b\xfa\x14\x36\x60\x54\xc4\x0d\xe5\x1a\xeb\x87\xc0\xc5\x6a\x44"
          "\x36\xe6",
          "\x0c\xb7\x6d\x81\x0f\x2e\x5f\x11\xb6\x61\xd5\x27\xea\x8e\x0a\x0d\x22\x1a\x3b\x4f\x03\xaf"
          "\x1e\xf6\x29\x92\xe6\x40\x80\x96\x35\x83\x6d\x13\x4f\x54\x2a\xcd\xb5\x56\x44\xd8\xa0\xca"
          "\x9b\x07\xca\x63\x68\xe8\x04\x28\x21\xe6\xc9\x94\xeb\xa2\x06\x63\x01\x05\x73\xc1\x20\x87"
          "\x76\x53\xf7\x27\xc5\x9e\x9f\xd0\x65\x48\xea\xa8\x1d\xdd\x1e\xc8\x27\x15\xc5\x02\x29\x2e"
          "\xaa\xca\x4e\x3f\x53\x30\x70\xd3\x37\xb9\xa0\x9d\x79\xda\xd9\x33\xa5\xb6\xad\x5b\x20\x20"
          "\x54\x5d",
          1, 896 },
        { 128, 128, 8, "\x0e\xb9\x8a\xc1\xe8\xbe\xf6\x8d\x6f\x4f\xec\x4f\xfc\xe3\x42\x26",
          "\x9e\x40\x09\xe5\x1a\x5b\x5c\xab\x5e\x25\x40\x12\xa9\xae\xa4\xfb",
          "\x24\x03\xdf\xb1\x94\xf1\x0c\x95\xbe\xa1\x59\xd6\xab\xcb\x57\xcc\x81\x7b\xe5\x93\xad\xce"
          "\x34\xa6\xc3\xda\xdf\xec\x6a\x1a\x33\x0f\xda\xd6\x46\x1c\xe2\x78\xb3\xf2\xc9\xb4\xc4\x5c"
          "\x70\xf4\xf6\x65\x86\x97\xdd\x32\x76\x35\x5e\x6b\x7c\x4d\x6f\x9a\x2a\x17\x84\x98\x9b\x29"
          "\x69\x4f\x2a\x44\x1f\x4a\x07\xad\x63\x30\xbb\x87\xc9\x9a\xd5\x0e\xf8\x8f\x63\xae\xa4\x2f"
          "\x33\x49\x62\x13\x2e\xac\x9c\xba\xa8\x74\x06\x4b\xf7\x81\x30\x16\xef\xbb\x32\x88\x6a\x16"
          "\x1c\xfc\xab\x21\x73\xfb\x95\x80\x43\xc7\x21\x12\xb1\xaa\xfc\x91\x31\x64",
          "\x24\xcc\x7a\xff\x84\x60\x23\x45\x14\xa6\x0f\x3f\xf5\xd3\xae\xfd\xfa\x9b\x28\xa7\x36\x7c"
          "\xfc\x53\x10\x97\x44\xae\x92\xae\x49\x93\x4d\x05\x64\x88\xb6\x9a\x4f\xdb\x0b\x19\x21\xc4"
          "\x30\x83\x0e\x03\x90\xe0\x13\xa8\x04\xe7\x8e\xb2\x3f\xa5\x28\x5e\xc9\x55\xe5\xef\x87\x4a"
          "\xc2\x3d\x7b\x19\x75\x2d\x85\x8d\xfe\x13\xcd\xd4\xee\x18\xe0\xc9\x41\x74\xf5\x1f\xf8\x4f"
          "\x85\x17\x5e\xa2\x28\xec\x80\x54\x91\x7b\x2c\x33\xe8\x65\x89\xaa\xbd\xfd\x73\xb0\xb1\x36"
          "\x11\x2b\x7f\x53\x95\x93\xca\x6f\xc7\x5f\xad\xf6\x3f\xe1\xc7\x19\xc9\x0c",
          1, 1024 },
        { 128, 128, 9, "\xf6\x8c\xd8\xa4\x5f\x10\xa6\xa7\x68\xaf\xcb\x41\x44\x98\xf4\xf2",
          "\x68\x23\x18\x5c\x3f\x77\x8e\xde\x42\x34\xce\xa9\x2a\x58\x2d\xd3",
          "\xda\xab\xd1\x52\xa6\xea\x55\x85\xc9\xe3\x18\xc0\x5d\x46\x27\x5d\xe7\x4b\xa8\x88\xdb\xaa"
          "\x42\x8a\xf7\x0d\x92\xc8\xea\xac\x86\x43\xaa\x5d\xd3\x10\x8c\xe1\xe6\xa3\x12\xd0\x41\x88"
          "\xe6\xf0\xd5\x17\xc1\xa9\xa4\xbf\xc5\x1f\xaa\xa7\x2d\xc9\xbe\x6e\xc1\x69\xab\xce\xc4\x45"
          "\x09\x7f\xd3\xf7\xc2\x20\x3e\x42\x37\x15\x92\x49\x22\x99\x04\xa3\xbb\x53\xc3\x6e\x6e\xf3"
          "\xd9\xdd\x06\xbd\x1b\x5f\x2a\xc2\x0d\xda\xa7\x2b\x2c\x31\x07\x15\x19\xd7\xfe\x49\xd4\xc8"
          "\x53\xbf\x47\x7f\x7d\xee\x48\x3e\xf7\x85\xcf\x0b\x66\xf0\x38\xb7\x52\x40\x61\x78\x3d\x68"
          "\xf4\x29\x55\x6a\x88\x21\x79\xc1\xb7\x9b\x67\x39",
          "\x5b\x2f\x80\x1c\x7d\xda\x4d\x61\x13\x17\xbd\x2e\xb7\x51\xc5\xdc\xa7\xb1\xdb\xa9\x9d\x0b"
          "\x3e\x96\xcd\x79\xb9\xd8\xa1\xb1\xb3\x9c\x86\x34\xca\xab\xd9\x9e\x7b\x35\x42\x25\x56\x30"
          "\xa1\x98\x2f\x8f\x56\x3b\xfd\x2e\xfa\xcd\xc0\xdd\x46\x8b\x96\x22\xa3\xfd\x08\x22\x22\xd3"
          "\x8b\x3f\x0a\xd7\xbc\x54\xb2\xce\x4e\x8a\xea\xc4\x9e\x28\x6c\x3e\xa3\xb6\xf3\xc2\x22\xb2"
          "\x45\x71\x69\xaa\x56\xd1\x26\x19\x6c\xdf\x46\x2f\x2a\xde\xf6\x15\x13\xd5\x01\x1c\x24\x12"
          "\x71\xfd\xfa\xc9\x7c\x08\xc4\x8c\x5e\x13\xe0\xef\xe3\x65\x76\x5b\x6a\xab\x67\xc5\x4f\x25"
          "\xa4\x77\x0c\x51\x5f\xef\xa3\x7a\x30\xc2\x26\xba",
          1, 1152 },
        { 128, 128, 10, "\x52\xe1\xfd\x9b\x56\x43\x46\xa4\x47\xb9\xb0\x18\xb9\xaa\x84\x7a",
          "\x2a\x75\x9c\xbc\xf8\x7e\x87\x26\xb2\x0b\x26\xea\x29\x0d\xf7\x47",
          "\xbf\x52\x37\x2a\x87\x6e\x6f\x2f\x22\x0a\xb7\x44\x71\xb4\x08\x3d\x4d\xa3\x6a\xee\x46\x97"
          "\xe8\xe2\x4b\x2c\x9a\x44\x4a\x2a\x3e\xe1\xfc\xe7\x56\x17\xd5\x8c\xb8\x68\x35\x83\x85\xe8"
          "\x63\x95\x46\xdd\xca\x78\x32\x09\x81\x33\x77\x57\x85\x75\xca\x5c\x7c\xb5\x89\x08\xfe\xbf"
          "\x0a\xdc\xe1\xe1\xb9\xa6\x11\xc4\x19\xd1\xd7\x58\xec\x40\x06\x45\x8c\xa2\x07\x74\xc0\xe7"
          "\xee\x0d\x04\x46\x97\x11\xa9\x0c\xb9\xcc\xc9\xed\x95\x08\x6d\x06\x56\x7b\x6f\x61\xde\x0a"
          "\x31\x01\xe7\x07\xc6\x45\xc0\xef\x44\xd0\xeb\x7a\xcd\xda\x79\x17\x19\x0f\x38\xab\x3f\x3d"
          "\x8b\x0f\xd4\xac\x66\xff\xd5\xdb\xc7\x05\x35\x23\x37\x1d\xb0\x3f\x27\x42\x92\x63\xae\x42"
          "\x08\xee\x27\xfd\x42\xab",
          "\x8c\xe2\x9c\x63\xdc\x17\x3e\xcd\x5c\x6c\x1d\xc4\x96\xec\x2e\x1d\x69\x0b\xe2\xe1\x7a\xc6"
          "\x2d\xee\x2b\x63\xa6\x40\x3b\x54\xda\xa4\x55\x65\x27\x3a\x89\x2f\x5b\x04\x33\x06\x1d\x3f"
          "\xe5\x87\x0b\x03\xab\x25\x0d\xba\x5e\x28\x6d\x01\xed\x71\x06\x6c\xc3\x12\x09\x94\x46\x7d"
          "\xde\x2f\x5f\x47\xce\x26\x28\x53\x1b\x46\x21\x46\x71\xad\x18\x53\x50\x0b\x89\x6f\xdc\x4d"
          "\x58\x48\x3c\x97\x23\xc4\x8e\xcb\x77\x8e\xc7\xa7\x57\x26\x78\x1d\x59\xc9\xeb\xa4\x29\x2e"
          "\x84\x80\x8f\x14\xdc\x6f\x74\x72\xf8\x32\x96\xb3\x4b\xb2\x0a\x2c\x3a\xbb\x24\xa1\x49\x61"
          "\x52\x20\xaa\x0c\xcb\x0c\x19\xaf\xde\xd6\x1d\xa4\x38\x6e\x33\x94\x18\xbf\x32\x38\x65\xb2"
          "\x24\x54\x7a\x44\xb0\x47",
          1, 1280 },
        { 128, 128, 11, "\xe2\xdf\x2c\x42\x33\xaa\x78\x5e\x5e\xf1\x9d\x17\xcb\x42\xe9\xee",
          "\x2f\x2c\x30\x43\x67\x97\x7f\x03\x69\xa9\x8d\x44\x13\xb9\xba\xa4",
          "\x3d\x88\x9d\xd9\x2e\xdd\xa9\x98\x67\x85\x48\xa2\x98\x6d\xb3\xcd\x87\xd2\x4a\x62\xb6\x73"
          "\xad\x7c\xff\xe9\x0b\x70\xa9\x14\xfd\x1d\xd6\x2c\xea\x50\x1b\xc7\xe9\x76\x91\xd4\x05\xa6"
          "\xf4\x00\x17\x43\x17\x28\x45\x75\xd5\x2b\xf4\xd0\xc6\x9d\xee\x26\x55\x1d\xf4\x23\x9f\x9b"
          "\x6e\x2c\xf1\xa2\x51\x56\x34\x5c\x3a\x03\x91\x7b\x4e\x23\x0d\xd9\x4f\x33\xb8\x02\xc6\x48"
          "\x73\x57\xa5\x0f\xaf\x25\x4c\xc8\xc0\x74\x3b\x84\x34\xc0\x9c\x27\x64\x66\x79\xdc\x21\x40"
          "\x18\x04\x73\xd5\x95\xb8\xce\xf9\x34\x7c\xaa\xc7\xa7\xca\xca\x25\x68\x31\x21\x62\x63\x3c"
          "\x0f\xe4\x86\xe5\xbb\x27\x25\x51\x1c\x7f\x75\xa2\x02\x2d\x01\xf4\xb6\x53\xbb\x56\x7b\x31"
          "\xcf\xb4\xb6\x0f\x49\x1a\x4c\x20\xe8\xb4\x5d\x97\xf2\x6a\xb9\xe8\x44\xbe\xa4\x5b\x4f"
          "\x00",
          "\x66\xed\xb4\x05\x63\xd9\xfe\x4d\xf6\x74\x6e\x4f\xe7\x6a\xe5\x4b\x4a\x41\x32\xa0\xb9\xc9"
          "\xdd\xb6\xd8\x59\x2d\x23\x29\xcc\x8a\xe7\x1e\xc2\x84\x2e\x5a\x40\x5e\x95\x6e\x55\xfa\xd6"
          "\xc5\x7e\x10\xc6\xc1\x27\xb6\xf5\x91\x84\x8b\x64\xf4\x13\x04\xbd\xc1\xa2\xe3\x94\x4e\x99"
          "\x6c\xa5\xeb\x8c\xd2\xae\x66\x29\x46\x3e\x7a\xda\x5e\xf7\xd8\xa1\xf9\xd1\xf1\xa7\xa7\xde"
          "\x27\xb8\x41\xa8\x53\xf5\xd6\x44\xd2\x85\x35\x85\xc0\x11\x6b\xa4\x08\x2c\x57\x43\xcb\x9e"
          "\x3a\x60\x93\xe3\xce\x2f\xe7\x2c\x3e\xc8\xe9\xa8\xdd\x42\x49\xb7\x95\x22\xa9\xc6\x0a\x04"
          "\xd0\x7f\x3b\xad\x36\x0f\x57\x3a\xb4\x72\x23\xd6\x71\x4b\x70\x51\xa1\x1d\xf5\x0a\xd9\x7e"
          "\x72\x02\xc6\x8b\x18\x73\x1e\x4d\x1a\x0f\xe1\x3c\x89\x60\x56\xb6\x14\xd4\xc1\x97\xb5"
          "\x9d",
          1, 1408 },
        { 128, 128, 12, "\xc0\x7d\xca\x33\xbc\x63\x9a\x43\x2a\x5b\x7f\x1c\x3e\xfe\x61\xd0",
          "\xd1\x5d\x17\xe2\x8f\x52\x42\xec\x10\x1f\xf3\x13\x79\x17\x2b\xfa",
          "\xfb\x32\x62\x80\x13\x2f\x6c\x87\xb4\xfd\x0a\xe3\x7d\xe1\x72\x42\xdf\x7f\xe4\x90\x61\x76"
          "\x13\xe7\xa3\x6f\x1f\xc6\x9b\xc3\x28\xe7\x03\xba\x0a\x7d\x86\x41\x18\x44\x0e\xe6\x86\x91"
          "\xa0\x06\x29\x53\x20\x1f\x79\xf1\x78\xe2\xd9\x83\x0d\x94\x28\x05\xfc\xd9\x6c\x79\x8e\x2b"
          "\xda\xc3\x1d\x83\xc5\xa5\x23\x0d\x5c\x24\x26\x7a\xa8\x24\x99\x41\x32\xb3\x83\x0b\x0e\x5d"
          "\xec\x8f\xb9\x11\xe5\x9a\xbe\xaf\x0c\x79\x80\x6d\xed\xae\xea\x24\xa1\xf5\x9c\x66\x77\xb1"
          "\x06\x12\xd9\x58\xf1\xdb\xa2\xea\xd0\x21\xa9\x67\x99\x3e\xd1\x76\x08\xe8\xa7\x04\x34\x2d"
          "\x86\xa7\x1e\x6e\x9d\x07\xd1\x63\x0d\x5c\x77\x13\xe6\x91\x7a\x50\x68\xc9\xd2\x85\x65\x61"
          "\xb7\xfe\xb7\x46\xf1\x59\x20\x17\x6c\xb5\x1e\x2c\xa7\x50\x08\x80\x3c\xdb\x64\xf1\xe3\x99"
          "\x84\x29\x3c\xd6\xdb\x51\x7d\x3c\xb1\xab\x5f\xfc\x3e\x40\x46\x75",
          "\xa0\xb9\x46\xc7\xe3\x41\x45\xe6\x86\xb1\xa8\x8a\x8c\x91\xbb\x47\xda\xec\xdc\x67\xf7\x78"
          "\x2d\x0b\xe8\x9b\xbb\x5f\xcc\xea\xc9\x9a\x4d\x4a\x46\xab\x24\x3e\xbc\xe5\xa0\xa2\xd7\xbe"
          "\x54\x0a\x76\xd2\x81\xa2\x09\xd5\xc1\xbd\x51\x05\x99\x6f\x7d\x90\xad\x6b\x9d\x83\xac\x7f"
          "\xe7\xe0\x73\x1e\xc9\x98\xd4\x88\x44\x15\x0b\xbb\x7a\xa1\xa0\xa9\x0d\x2a\x1e\xa0\xac\x6c"
          "\x7c\xfe\x7a\x2a\xdc\x32\xef\x0b\xe9\xec\x51\x04\x76\x3b\xc7\x2a\xc0\xdb\xb5\x48\x86\xca"
          "\x05\x0f\x36\x35\xa1\xee\x90\xa8\xb3\xcd\x37\x24\x04\xe2\x82\xb9\x9a\x44\x93\x3a\xe5\x19"
          "\xd5\x1e\x8a\xe2\x94\x00\xca\xf4\x3f\x9c\x19\x48\xd3\xa8\x37\x31\x3f\x87\x7d\x93\xc4\x7d"
          "\xb6\xaa\x7e\x63\x2b\x2b\x50\xed\xd5\x08\xc9\xe3\x5d\x4b\x14\x81\x37\xff\x1b\xae\xcf\x93"
          "\x88\xaa\xc4\x58\x04\xfd\xe6\x65\x9e\xed\xba\x48\x5e\x69\xc5\xa6",
          1, 1536 },
        { 128, 128, 13, "\xb9\x70\x4b\x43\x06\x2f\x8c\xde\x17\x79\xca\x42\x05\xa0\x80\x44",
          "\x0a\x6a\x0d\x78\xd2\xc3\xb6\x78\x6a\x67\x1a\x77\xae\x17\x3c\x62",
          "\x57\xc8\x27\x26\x92\x59\x9a\xfd\x4f\x68\xc3\xa4\xde\x17\x13\x3c\x04\xa2\x50\x9e\x5b\x96"
          "\xb2\xf5\x32\x5a\xdc\x7a\x17\x77\x92\x76\x31\x23\xd5\xcb\x5b\x63\x00\xb7\x8a\xbd\x7e\xc3"
          "\xbb\x8f\x64\xf4\x16\x44\xfd\x06\x48\x7a\x07\xa7\xa8\x7e\xa3\xd1\x7f\xad\xcc\x26\xe4\x25"
          "\x5e\xb3\x90\x4e\x6a\xfa\xfe\xd8\x35\x45\xd0\xb2\xb8\xd8\x65\xa5\x43\x4e\xa0\x70\x32\xdc"
          "\xf9\xd5\x80\x70\xc3\xc8\xe3\x1f\x7e\x05\x56\x9e\x04\x11\x0c\x6a\x46\xb3\xbe\xb3\x33\x8a"
          "\x79\x24\x59\x72\x4d\x97\xab\x24\x57\x5a\xac\x6e\xf3\x72\x1b\x18\x59\x5f\x27\x9c\x30\xb9"
          "\xbd\x40\xb9\x0f\x64\xe9\x48\x3a\xde\xc6\xe4\xe7\xe1\xa4\xa7\x00\x47\xab\x21\x51\xf9\xcb"
          "\xcf\x29\xa9\x16\x6b\x82\x45\xba\x19\xd0\x2a\x9c\x17\x27\x42\x2e\x89\xee\x2f\x6b\xfc\x9a"
          "\x9b\x1c\xab\xa5\xef\xd8\x67\xf0\xe1\x5e\xbd\x3b\x08\x0d\xb9\x92\x05\xa4\xd0\xbf\x22\x10"
          "\xf1\x2d\x01\x59\x58\x85\xbf\x9c\xdb\x99",
          "\x4c\xff\x67\x9d\xc9\x22\x90\x97\x59\x82\xc8\xe7\x3e\xfb\x3b\x7b\xe7\x54\x75\x76\xb9\x27"
          "\xa3\x3a\xf4\xe5\x81\x6c\x9c\xae\x4f\x01\x33\xa3\xf9\x2f\x1a\x71\xf4\x37\xdb\x62\xf7\xd6"
          "\x84\x4a\x8f\x85\x39\xeb\x28\x39\xcc\xb8\x43\x7b\x51\x48\xfa\xe1\x47\x8e\xe7\xc6\xfc\xdc"
          "\x6b\xd1\xda\x05\x02\x9a\x2e\xb3\x87\x48\x6c\xa4\x22\xcf\x19\x55\x93\xe8\x68\x6f\x70\x8d"
          "\x47\x3f\xd9\xc1\x92\xdc\x38\x0e\x50\x9d\xad\x87\xc7\xce\x70\x57\x6d\xb2\x53\xc4\x15\x8e"
          "\xcb\x14\xca\x5b\x10\xd9\x04\x37\x51\xc9\x79\x91\x27\x92\x81\x22\x1d\xdb\x9e\x05\x1e\x56"
          "\x69\x57\x44\x93\x70\x9e\x28\x1a\x1a\x16\x4e\xf0\xa2\xbb\xc1\x67\x24\x6b\x1f\x95\x8a\x90"
          "\x03\x0d\xd5\x26\x8c\xb0\x00\x5e\x26\xed\x35\xb9\x4a\xcd\x4a\xae\x0a\x90\x68\x98\xb3\x4f"
          "\xc3\x5f\x1a\x82\x04\x77\x59\xc4\x0c\xfc\x20\xf1\xb4\x88\x98\x67\x37\x23\xdf\xe6\x29\x73"
          "\x89\x4a\x3c\x7c\xd9\x76\x67\x34\x7b\xb0",
          1, 1664 },
        { 128, 128, 14, "\x78\x0a\x7e\x16\xea\xf4\x06\x3d\x66\x8a\x17\x9d\xa2\xc4\xd4\x88",
          "\x88\xd7\x08\x7e\x84\xbd\x37\x8d\x5c\x6f\xdb\xac\x8a\x12\x73\xe6",
          "\xc3\xa6\x23\xb9\x3a\x0c\xb8\x4b\xe4\xf3\x2c\x77\xaa\x95\xb2\x38\x36\x12\xc6\x7e\x0e\x8c"
          "\x33\x4f\x5d\x51\x31\x0b\x60\x5a\xdf\xdd\xa9\x24\x97\x06\xbf\x50\x4c\xba\xe3\xe4\xf6\xb5"
          "\x89\xc6\xd1\xa2\xf0\xe2\xe9\xf1\xf2\xb9\xdc\x91\xe4\xdc\xcf\x72\x06\x61\xf1\x40\x71\x81"
          "\x29\x9e\x56\xf8\x0b\x36\x41\x88\xe8\xde\x1d\x1d\x51\x50\x64\xd2\x9d\xa6\x44\x75\x74\xa1"
          "\x12\x6f\x76\xc9\x0e\x64\xa7\x3d\xd3\x00\x5b\x7c\xec\xd9\x11\x1f\xa8\x50\x0c\xee\x45\xbd"
          "\xc7\x8f\xad\xac\x06\x7a\x44\xad\x50\x3e\x38\x74\xe5\x74\x2a\xac\xd8\x6e\x86\xa2\x24\xc7"
          "\x5e\xd0\xdf\x31\x50\xdb\xa0\xf2\xcf\x08\xac\xbb\x16\xda\x43\xbb\x39\x0b\xf6\x40\xb0\x34"
          "\x11\xcf\x18\x4d\xc2\x00\x23\x31\xd9\x04\x37\x19\x0f\xb5\x75\x69\x41\xc9\xc2\x54\x5c\x30"
          "\x47\x27\xb0\x66\x7c\xd8\x1e\x1d\xbd\xad\x26\x71\xed\x69\xfe\xf6\xf0\x15\x15\x7a\xc2\x4e"
          "\x09\xb3\x54\x0e\x2c\x1c\x21\x27\x57\x32\x5a\xb9\xcd\x77\xe5\xd7\x07\xae\x4d\xb8\x0c\xc7"
          "\xc7\xb6\xfc\x64",
          "\x5d\xe5\xb7\x6a\x43\xc6\xd2\xbd\x66\xcf\x28\x9d\xf6\x64\x71\x47\xa6\x16\xa5\x37\x31\xdc"
          "\xf9\x15\x78\xeb\x2c\xd9\x31\x0c\x4d\xe5\xf3\xa1\xa7\x26\xe5\x0c\x17\xfe\x7f\x8b\x22\x4c"
          "\xa6\xa1\xd3\xe9\xa6\x26\x18\x02\xa4\x7f\x82\x91\x30\x83\xcc\x59\x50\xa3\x1d\xa4\x28\x65"
          "\xc1\x5c\xfa\x52\xde\x8d\x69\xfd\xc2\x94\x97\x39\x6a\x82\x89\x01\x5c\x81\x67\xdb\x1c\x68"
          "\x7d\x6c\x95\x95\x9c\xb5\xc6\x08\x2d\x75\x32\x45\x24\xa3\x1b\xf2\x4c\x65\x8d\x34\x1a\x5d"
          "\x08\x82\x5b\x91\x5c\x3a\x77\xb8\x71\xad\x15\x99\x48\xaf\x64\x7d\x35\x46\x0c\x6e\xf2\xf0"
          "\xaa\x42\x48\x7b\x64\x53\xef\x84\xad\x22\xb9\x20\xbf\xa3\x29\xdf\x0e\x0c\xc4\x92\x9e\xb2"
          "\x25\x2a\x39\x6d\xf1\x5e\x52\xe8\x18\x0d\xe9\x9b\xb3\xb4\xc0\xc1\xdc\x46\xa9\x12\x4f\x59"
          "\x1a\x47\x74\x2c\x82\xab\x1b\x10\x3a\x27\x8c\x88\x1e\x2b\xc8\x2c\xc6\x89\x28\x1e\x64\x13"
          "\x92\x74\x45\xfe\x70\xce\x52\x7f\x0e\x31\x07\xb9\xbb\xf7\x48\xe7\x7e\x4b\xf2\x81\x37\x69"
          "\x0e\xc5\xe7\x5d",
          1, 1792 },
        { 128, 128, 15, "\xff\xff\x07\xba\x57\xcf\x76\x62\x52\x46\x8a\x4e\xb4\xf0\x6e\xb9",
          "\xa8\xe9\x1f\x10\x38\x39\x37\x67\x8e\x12\xc4\xca\xdc\xcb\xa4\x37",
          "\x47\x11\x8b\x2d\xf5\x9e\xd1\x4b\x1c\x66\x7e\x6e\xdb\xfd\x2e\xa0\x11\x82\x1f\xcc\x47\x20"
          "\x1c\xb3\x87\xc3\x51\xd1\x56\x58\xb5\x4f\x56\x94\x7d\xc6\x25\x97\x0b\x73\xb9\x2b\xf3\x24"
          "\xb1\xae\x69\xc1\x23\x50\x7b\xd1\x1e\xd6\x99\x1e\x38\x4d\xf7\x98\xe5\xea\x90\xa3\x53\x10"
          "\xb0\x93\x7a\x82\x99\x9c\xe4\xa8\x75\xb6\xbc\xb4\x80\x71\x17\xa1\x44\x28\xc0\xb3\x8f\xc2"
          "\x74\x6b\xf7\x43\xd6\x67\xc0\xec\x57\xdf\x32\x05\x90\x05\xae\xb6\x04\xd3\xe4\x2c\x66\x8a"
          "\x38\xc8\xb6\x62\xb8\xf9\x55\x04\x8a\xcb\x2e\xcd\x63\x9a\x69\x9f\x5a\x50\x5f\xe4\xb9\x64"
          "\xe8\x62\xce\x1c\x7a\xdf\xeb\x5a\x4e\x67\x1c\x30\x26\xf6\xb8\xa1\x84\x95\x18\x47\x11\xfd"
          "\x6c\xc2\x3a\x21\x19\xdd\x9c\x95\xdb\xbd\x57\x27\x09\x62\x45\x0f\xcc\xe8\xa5\x7e\x6b\xf0"
          "\x9b\xd8\x83\x6b\xc6\x64\x62\xe6\x6a\x18\x63\x9a\x11\xbf\xc6\xc5\xb7\xcd\x95\x8e\x99\xc7"
          "\xef\xf5\x23\xa9\xd6\x0a\xce\x04\x5c\xce\x1e\x15\x7b\x18\x8b\x18\xb2\xd5\x09\x7c\x16\x78"
          "\xac\x64\x82\x7a\x43\xf8\x01\x27\x26\xe4\x8e\xa9\x16\x39\x1e\x76\x58\x34\xeb\x91",
          "\xa4\x92\xee\x56\x20\x48\x30\x23\xef\x85\x16\x0d\x12\xb4\x0c\xf2\x34\x15\xb1\x20\xc3\xe2"
          "\x07\x0a\x85\x1b\x6d\xf1\x3d\x13\xbf\xf5\x0f\x76\x90\x3f\x86\x97\xe0\x95\x1f\x5d\xf4\x33"
          "\xb7\xc2\x0f\x3d\x8a\x5f\x04\xc7\xad\x53\x4c\x89\x3d\xb6\x95\x7b\x8f\xbb\x06\x96\x2e\xc1"
          "\xa7\x74\xab\x3a\x55\x72\x9b\x7f\xb1\xae\xc5\xea\xb6\x87\x88\x30\x15\xad\x2d\x0a\xe9\x6a"
          "\xb3\x2a\x3e\xcf\x56\x7f\x72\x41\x54\xbb\xbf\xb5\x53\xe3\xf2\x36\xfc\x41\x79\x54\xd6\x51"
          "\xcc\x33\xbf\x4d\xc0\xd0\x10\x23\x27\xd9\xb2\x83\xd8\x69\x2d\x57\xfb\xb6\x60\x50\xcf\x28"
          "\x87\x5d\x73\x69\x14\xdc\xf7\x31\xbb\x7c\xd8\x3c\xf3\x8f\x99\x43\x71\xb5\xcc\xe6\x14\xef"
          "\x8f\x34\xf4\xc8\xce\xa5\xa9\x76\x54\x40\x11\x61\x2d\x02\xa9\x69\x8c\xde\x00\x4b\x9f\xa2"
          "\x1c\x52\xf3\x94\x70\x6a\x62\x43\xc9\xab\x51\xd9\x7f\xc6\x2c\x64\x9f\x5a\x10\xf4\xfd\x19"
          "\x0c\xcf\x98\x76\x5d\x29\xff\xe0\x58\xaf\x2a\x2d\xb6\xd0\xe5\xf1\x58\x84\xac\x31\x49\x41"
          "\x6c\x12\xc4\x67\xfd\xbe\x24\x78\x31\xb8\x72\xc8\xb0\xd8\xba\x35\xcf\x56\x0e\xb2",
          1, 1920 },
        { 128, 128, 16, "\x31\x5a\x25\x06\x99\xa0\x4c\xaa\x90\x41\x6b\x75\xbf\x13\xd0\xab",
          "\xe9\x28\x10\x7a\xe8\x89\xbd\x8d\x80\x2d\x35\x08\x09\xc3\x5a\x2a",
          "\xf7\x98\x46\x35\xcb\x3f\x10\xac\xec\xc9\x4c\x3c\x81\xe3\xa9\xb9\x5e\xf6\xa3\x07\xb0\x79"
          "\x90\xc3\x8e\x42\x3a\xeb\x83\xe9\x20\x02\xaa\x0f\x70\x8b\xdb\xe6\xff\xd5\x98\x3d\x2b\xc9"
          "\x67\x06\x03\x1f\xf9\x16\xc4\x44\xfe\x28\x5f\x45\x7e\xb8\x4b\xe8\x4d\x62\x0f\x18\x38\xfc"
          "\x9a\x52\x38\xd6\x2a\x3d\x9f\xac\x3b\x23\x34\x67\x63\xb4\x31\xa6\x0e\x83\x2e\xf2\x0d\x9b"
          "\x83\x91\xd7\x53\xc5\xb3\x1e\xf9\x71\x65\xa1\x2b\x8d\x4e\x8b\xc3\xca\x56\x0f\xa8\xa7\xaf"
          "\xd3\x47\xc2\xed\x2d\x14\xfc\x7d\xe0\x3e\xb1\xb2\xc1\xb1\x28\xa3\x3a\x63\x86\xa4\xc7\x31"
          "\x7e\xb6\x93\x1a\xb0\x40\xd7\xe9\xec\xed\x67\x77\xd3\xc2\x37\x58\x18\x7c\x27\xb3\x4c\x3e"
          "\x0a\xb1\xb9\x09\x26\x53\x8b\xca\xa6\xfc\x60\x13\x30\x1c\x26\x82\x46\xa8\x17\x7d\x1a\xcc"
          "\xab\xd6\x5b\x60\x25\xe5\x08\x23\x8f\xd3\xcc\xf7\x94\x60\xb5\xc4\x90\x72\x88\xd0\x83\x1c"
          "\xae\xf0\x6d\x65\x8b\x7f\xfb\xac\x71\xf4\xc5\x29\xef\x1b\x82\x50\x36\x37\xda\x32\xb2\x8d"
          "\xf4\xe9\x35\xc3\x09\x2a\x63\xb9\x79\xe5\x93\x38\x70\x56\x8a\xef\xd2\x71\xb2\xbc\xb1\x41"
          "\x0b\xdb\x87\x16\x35\x75\x7c\x2c\x10\x6f\xaa\xbd\x48\xe4",
          "\x76\x0e\xc1\x26\xa6\x0a\xa5\x34\x4e\x40\xb1\xe9\x27\x13\x79\xd4\x80\x91\x87\xf5\x86\xb6"
          "\xf6\xc5\x3a\xf0\xe9\x6d\xeb\x70\x29\x17\x1c\x07\x2b\xbb\xa9\x2e\xce\x49\xe6\xe2\x20\x7c"
          "\x61\x33\x71\xac\x64\x91\x87\xbf\x6e\x67\xeb\xe3\x51\x20\x0b\xc7\xf4\x5a\x07\xce\xf4\xf2"
          "\x4b\x1b\x39\x67\x60\x58\xfd\x79\x12\x1f\x28\x01\x20\xbd\x24\x1e\x93\x25\x05\x5a\x58\x8d"
          "\x04\xbc\xd0\x76\x0b\x82\xbc\x63\xee\x47\xc1\x09\xe6\x12\x48\xe8\x92\x84\x07\x73\xd6\xde"
          "\xde\x03\x87\x01\x48\x3c\x38\x1d\xc2\x77\xc8\xa6\x6c\xc8\x4a\xec\x9d\x5a\x84\x86\xd6\x6b"
          "\x28\xd8\x14\x22\x53\xae\x80\x95\x71\x4d\xb9\x37\x86\xfa\x29\xf9\x8e\xfd\x78\x1a\x32\xb5"
          "\x1a\x5b\xd3\x06\x1b\xd1\x4e\x7e\x81\xc6\x05\xc1\xa5\xac\xfd\x61\x70\x3d\x42\x30\x86\x16"
          "\x46\xe3\x28\x1d\x76\x3b\xae\x9e\xe5\x07\x04\x9a\x3e\xc2\xf9\x66\x66\x08\x35\x28\x19\x07"
          "\x6c\x0e\x80\x5a\x4b\xaa\x57\x01\xfa\x81\x04\xba\xdb\xa8\x25\x2e\x5b\x35\x05\x54\x3b\xf2"
          "\x07\x6a\x8f\xad\x13\x67\x42\x6f\x48\x9a\xfd\x32\xaa\xc4\x56\x7f\x43\x29\xb8\x10\xa1\x01"
          "\xde\xf4\x19\x63\x8c\x31\x7f\xac\x50\xa3\x7f\x5e\x0a\x91",
          1, 2048 },
        { 128, 128, 17, "\x74\x26\xfb\xc5\xac\xf0\xc5\x52\xd0\xdb\x76\x89\x06\xcf\xfb\x69",
          "\xf3\xe3\x4a\x06\xcd\xdf\xa2\x62\x64\xef\x0b\xb8\x31\x33\xca\x86",
          "\xca\xc1\x74\x3b\x93\xb5\x5f\x15\x76\x37\xd7\x8c\xe2\x41\x98\xb0\x9c\x1e\xb7\x95\x8b\xb4"
          "\xe4\x3d\x30\x1d\x1a\x21\xda\x28\xda\xdd\x7f\x72\x88\xbc\x20\x36\x26\x4a\x56\x60\x3f\x67"
          "\x9e\x50\x58\x6d\xc4\xe2\x76\x04\x5d\xd1\xb0\x8d\xfa\x5c\xb4\xe5\x6c\x49\x1f\xdb\x52\x49"
          "\x1a\xd3\x96\xea\xb8\x74\xc0\x01\xfc\xe4\xa6\xaf\x4c\x6b\xd8\x53\xa3\x2e\xcf\x1e\xa2\x8b"
          "\x25\x6e\xf0\xbb\x88\xa0\x06\xca\x53\x74\xe2\xe0\xbf\x60\x36\x58\xcc\xc5\xcc\xd1\x72\xfc"
          "\x8f\x30\x3f\x5c\x10\x49\x55\xe1\xeb\xd7\xba\x97\xdc\x90\x26\xc8\xec\x0a\x53\xf2\xff\x96"
          "\x9d\xbf\xe3\x71\x2f\xa4\xe5\xfa\x0d\x4c\x6f\x71\x79\x23\xdb\xac\xbd\x4a\x03\x06\xa0\x3e"
          "\x52\xd9\xf6\xbf\x0b\xe6\x86\xa3\x51\x77\x07\xa6\x44\x6b\xb6\xb7\x8e\x60\x93\x34\xdd\x16"
          "\x87\x74\x14\x62\x55\x62\xad\x32\x69\x0c\x5e\xa4\x63\x9a\xc3\xd3\x5d\x17\xf5\xf3\xd3\x40"
          "\x4a\xe1\xb7\x45\x72\x92\x7c\xac\x50\x70\xa0\x00\x5e\x46\x7e\x0b\x8d\x80\xbd\x38\x7c\x0e"
          "\x03\x28\x11\x25\xae\x09\x68\xb1\x38\xe1\xbe\xb8\x56\x28\x08\xe8\x1c\x3a\xa5\x90\xe3\x3e"
          "\x09\xf5\x73\x6e\xf0\x0b\xb9\xfa\xa7\xbe\xc7\x53\xc1\x81\x67\xe5\x28\xb1\xec\x41\x23\xd9"
          "\x9b\x73\x5f\x98\xe5\xf7\x2d\x47",
          "\x4b\xf3\x37\x7a\x8c\xd3\xe6\x13\x22\xbb\x2d\x57\xff\x9b\xec\xe2\x57\xe0\xdb\xfd\x32\x56"
          "\xe1\x68\x9c\x96\x35\x02\x15\xa1\x16\x9a\x03\x21\x66\x46\x42\x1a\x1a\x23\x8c\xbe\xbf\xa5"
          "\x7e\x02\x67\xa8\x01\x28\xf5\x60\x53\x8d\xd0\xf1\x7a\x1b\xf4\xe4\x86\x36\x0f\xa4\xc7\xd2"
          "\xe1\xa9\xb5\x28\x43\x48\xc5\x7f\x0c\x2b\xe0\x6d\x16\x54\xc8\xae\xba\xa2\xe9\x61\x84\x8a"
          "\x00\xb6\xde\x4f\x58\xa6\xf3\x22\xe3\x44\xa2\xbc\x75\x0e\x4d\x9a\x3e\x26\x02\x79\x84\x62"
          "\xc2\x71\xa8\x46\x3d\xb9\xeb\xf9\x56\xf9\x55\xa6\x19\xe6\x22\x8c\x51\x99\x8d\x51\x4c\x40"
          "\xa3\xb7\xc3\xb4\x5f\x40\x12\x40\xfc\xe6\xbd\x44\xba\x23\x82\x92\x67\xf3\xdf\x66\x08\x51"
          "\xce\x19\xb1\x0b\x7d\x1f\xc9\x81\x1b\x3e\x2f\xb8\xd2\xaf\x19\x5e\x67\x0f\xcf\xa8\xb2\x29"
          "\x05\xdb\xae\x8a\x12\x66\x63\x55\x76\x83\xc0\x2d\x5d\x17\x95\x84\xb5\x8a\x71\xe5\xb8\x60"
          "\x2e\x9f\x17\xba\xbf\x9e\x31\x22\x3b\xf2\x26\x0a\x06\xf4\x44\x2d\x77\x49\x9b\xa8\x65\xed"
          "\x7a\x03\x93\x10\x97\xcd\x76\x54\xb7\xde\xf6\x2c\x87\x9b\x1c\x0a\x37\x1a\xdb\x94\x96\x19"
          "\x31\xb2\xef\xc8\x8b\xcc\x52\xe0\xa8\xca\xc8\xd0\x05\xd8\x73\xa4\xcc\x4e\x72\xf7\x92\x04"
          "\xa8\xcc\x24\xc8\x5a\xb9\x13\x85",
          1, 2176 },
        { 128, 128, 18, "\x4e\x6d\x7b\x91\xaf\x62\xf4\x85\x33\x9d\xb3\xe2\xde\x43\x0f\xf0",
          "\xae\xfc\x2a\xbc\xc3\xc6\xb8\xac\x4c\xac\x64\x93\xc7\x30\x48\x4c",
          "\x8d\xca\x93\xe8\x02\xaa\xfc\xac\x4d\xd6\xa5\xf3\xd1\x7d\x7e\x25\x2e\xc5\x92\x23\x9a\xce"
          "\xd8\x42\x0a\x3f\x13\x42\x82\xa2\xd2\x98\x69\x14\xdb\xb0\xa7\x9f\x6f\x46\xcf\x7b\x3c\xf2"
          "\x25\xaa\xb9\x49\xa3\x1a\x8f\x22\x37\x68\x4d\x14\x99\x0f\x33\x8c\xbb\xe7\x72\xdf\xf6\x5a"
          "\xce\x7b\x96\x1c\x96\x36\x1b\xce\xee\xad\xee\x36\xd0\x31\x72\x49\x49\x4f\x11\xd4\x46\x1e"
          "\x42\x0c\x54\x16\x54\xea\xf7\x19\xd5\x67\x2a\x19\xb1\x01\xcb\xeb\xd0\xb4\x84\x09\x60\x81"
          "\xd8\x4f\x2f\x57\x68\xd6\x30\xd8\x8e\x3e\x88\x06\xea\x42\x48\x42\xb4\x94\x4f\x85\x33\x5e"
          "\x96\xca\x90\xe1\x4d\xd4\xdb\x36\xc0\xff\xc6\x26\x60\x91\x39\x0f\x88\xdf\x3e\x77\xfe\x49"
          "\xd7\x76\xc2\x90\x66\xec\xcd\x12\xcb\xa2\xc6\x3d\xfe\x49\x0c\x1b\xa7\xa8\xb1\x0f\x4b\x47"
          "\x6c\x92\xab\x6d\xcf\x8e\x5d\x54\x02\x5b\x5b\x57\x09\x43\x5a\x07\xf0\xc0\xe3\x81\x67\xc6"
          "\x5a\xfe\x24\xf7\x67\xee\x4d\xe8\x42\xd6\xe7\xf6\xa1\xa0\x05\x8e\xb5\x46\xac\x88\x6b\x84"
          "\x7e\x8a\x5d\x06\xf0\x66\x8a\x76\x0c\x93\x60\x6c\xe3\x52\xa3\x94\xa8\xd5\x65\xce\x9c\x9f"
          "\xda\xb9\x4a\xdf\xab\x59\x8a\x08\x2f\x25\x0f\x88\xee\x0e\x95\xf8\x8a\xae\x19\xb1\x3e\xb3"
          "\xa9\x62\xe3\xbf\xd7\x54\x55\xc8\x4b\x66\xc6\xce\x22\xa1\x78\x5b\x52\xba\xfd\xca\x7a\x8c"
          "\x5d\x09",
          "\xdb\xf3\x20\x25\x06\xa5\x07\xf9\x64\xfb\x32\xca\x40\x84\x76\xff\x28\xf0\x86\x33\x01\x62"
          "\xfe\xe4\xfb\xc3\x77\x86\xc2\xcd\x8b\xf2\xcd\x80\xff\x6d\x76\x2a\xa3\xf6\x66\xef\x38\x2c"
          "\x49\x03\x56\x8c\x07\x34\x15\x17\xe0\x19\x33\x3c\x14\x3b\x14\x4e\x35\xa9\x0b\xb5\xde\x44"
          "\x72\xe5\x49\x5e\xde\x72\xc2\x22\xed\xa6\x4a\xb2\x0b\x38\x9d\xab\x50\xf1\x2e\x5a\xb9\x55"
          "\xab\x28\x8b\x73\x38\x6c\x4c\xc4\xc5\xbe\x90\xf0\x4b\x18\xcc\xbc\xb2\xbf\xe3\xab\xa8\xab"
          "\xfd\x8a\xe8\xc7\xfe\x04\x5b\x10\x17\x19\xa4\x19\xa7\x29\x24\x56\x25\xc5\x8f\x47\xeb\xff"
          "\xe3\xdc\xd0\xec\x79\x99\x26\x14\xb6\x52\x0f\x79\x1e\x8d\x96\x46\x95\x62\xa2\x45\xc3\xc7"
          "\xfe\xe8\x81\x6a\x4d\x3f\x9d\x72\x10\x30\x39\x5a\xb2\x47\xbd\x06\x5d\x14\x3f\x59\x17\x98"
          "\xc6\xaa\xc6\xa2\x92\x3d\x0c\xeb\xac\xd6\x4b\x63\x23\xf7\x98\x5c\x35\x53\xe0\x48\x81\x1b"
          "\xc7\x4d\x1d\x7f\x85\x75\x48\x61\x8f\x24\xe4\x59\x82\xe6\xa3\x93\xfe\x39\x15\xf2\x53\x6f"
          "\xd0\x33\x9f\xa9\xe5\xa9\x10\x44\x27\xbd\x93\x80\x8a\x82\x63\x5c\x98\xe5\xa2\x27\x37\x32"
          "\x52\xb1\x36\xdd\x9c\x98\x16\x43\x03\x94\xd0\xc1\xa5\x91\xce\x79\x4e\xaf\xc6\xf5\x5b\x2d"
          "\xd0\x9b\x0d\x4c\x6d\xd3\x1a\x90\x56\xbe\x3f\xd0\xa1\x1b\x6f\xba\x7b\xf3\xf8\xcd\x3d\x2d"
          "\x8c\xd3",
          1, 2304 },
        { 128, 128, 19, "\xb9\xfd\xa2\x14\xb2\x96\xe0\x88\xbe\xd2\xe5\x21\x33\xa9\x61\x6e",
          "\xb6\xfe\x22\x78\xa7\x3b\xb7\xbe\xed\x49\x06\xb1\xda\x62\xbb\x34",
          "\x5b\x10\x90\xc4\xf8\x23\xdf\x82\x67\x83\x1b\x2d\x4b\x7c\x2b\x12\x20\x0b\x2b\x23\xc9\x34"
          "\x2b\x4d\x77\x24\x2f\x09\x92\x6a\x82\x00\xaf\xbf\xaf\xb7\xf8\x99\x68\x66\xc4\xf1\xa2\xaa"
          "\xed\xf3\x6f\xf2\xe8\x81\x33\x2b\x97\x3b\x48\x52\xa0\x37\xea\x05\x57\x03\xc2\x71\x38\x0e"
          "\x84\x43\x43\xf6\x3a\x85\x78\x61\xd5\x39\x69\xd9\xec\xc6\x93\xaa\xf7\x37\x26\x18\x7b\x8c"
          "\x32\x17\xd2\x17\xa7\xf1\xdb\x08\xe1\x6b\x4d\x3c\xd3\x8e\x6c\x1e\xce\x47\x52\x47\x22\xc3"
          "\xc5\x80\x36\x8b\xe1\x48\x02\x60\x00\xdf\x52\x95\x90\xec\xd4\x12\x9a\x97\x93\x52\x28\x9b"
          "\x0b\x16\xc6\x25\x5f\x9d\xe4\xf8\x0d\x3e\x44\xcd\x3d\x6d\xf2\x6d\x01\x23\xe7\x8f\x2c\x63"
          "\x65\x1e\x9c\x8e\x76\x0b\x69\x1a\x2c\xa5\x30\x33\x58\xc7\x43\x38\xed\xdf\xa5\x46\x73\xc9"
          "\x4a\xef\x44\x84\xef\xd9\x60\x6d\x31\x0d\xf3\xb0\xa2\xaa\x69\x84\xc5\xc7\x13\xa8\xed\x1b"
          "\xe7\xc4\x84\x61\xb5\x44\x9f\x60\x74\xa1\xc4\x3d\x44\x9d\x78\xab\x1f\x93\xe7\xe2\x2a\x87"
          "\xf6\x00\x6f\x8a\x0d\x09\xbf\x94\x6b\x71\x8a\xb4\xc7\xc8\x17\xbc\xe7\x4d\x7e\x35\x7b\xcf"
          "\xe8\x2c\x47\x22\xda\x6a\x53\x1a\x38\xbd\x6a\x39\x7b\xb6\x74\x66\xb5\x49\x96\x8f\xb4\xe3"
          "\x76\x18\xcc\x29\x4d\x6b\x71\x42\x31\x39\x93\xc1\xf9\x4c\xd5\xf2\xac\x74\xdf\x25\xe4\xeb"
          "\x87\x2d\xbb\xd4\xcd\x33\xd1\xe1\xec\xc0\xb0\x2b\x6d\xad\x33\x4a\xec\xbb",
          "\xa6\x74\xb9\xcc\xa2\x1b\x41\xe9\x3a\x21\x4c\x93\x1b\x77\x91\x7d\x5f\x21\x25\x0d\xd2\xdd"
          "\xca\xdc\x50\x50\x33\x5b\x7a\xbc\x2a\x4f\xaf\x35\xc6\x83\x49\x30\xe1\xcf\x68\x66\x8b\x54"
          "\x56\x2d\xfe\x66\x0b\x64\xa8\x8e\xb6\x5a\x58\x5c\x5f\xa9\x96\x30\xd6\x22\x3b\xe2\x72\x2f"
          "\x1f\xf2\xdc\x37\x83\x11\x23\x8c\x82\xd9\x05\x2f\x57\xe0\xc3\x23\x32\x0d\x3a\xcb\x96\x03"
          "\x2a\x41\xf2\xc8\x91\xba\x08\x6e\x67\x73\x99\x10\xd0\xce\xbc\x46\x8e\x6d\xd1\x59\xaa\xc0"
          "\x82\xde\xf2\xb2\x02\xa1\x75\x54\xa0\x1a\xec\xe3\x89\xfc\x5c\x2a\x84\x18\xae\xcb\x9f\x1e"
          "\x04\xe4\xee\x6a\x0b\xc5\x2e\x62\x66\xed\x35\x9b\xa3\x71\xfd\xe0\x86\xf2\x38\x0d\x49\xb9"
          "\x03\x35\x54\x43\x1e\xbe\x67\x66\xe1\x03\x32\x77\xf4\x72\xae\x5f\xff\x8e\xe9\x04\x6c\x8f"
          "\xfd\x24\xf5\x39\x71\x3b\x45\x85\xfc\xcc\x9d\x45\x49\x87\x2d\xe5\xd5\x73\x92\x30\x0b\x4a"
          "\x37\x33\xad\x84\x34\xf3\x4e\xac\x43\xbb\x00\x51\xea\xab\x41\x67\x73\x6c\xd1\x93\xc8\x63"
          "\x1b\x96\xed\x10\x9c\xd7\x20\x38\x48\xe9\x5c\x3a\xf3\x9a\x1b\xae\x52\x73\x5c\xa3\xf5\x08"
          "\x58\xfa\x69\x23\x98\x8d\x83\x70\x39\x6d\xbd\x21\xe9\xe8\x62\x7f\x7a\x17\xfe\xef\x8a\x18"
          "\x90\x3d\xae\xa1\x95\x92\xc2\x55\x9f\x87\xae\x32\xea\x42\xbf\x62\x8e\x28\x6e\xc9\xd6\xaf"
          "\x56\x7a\xd4\x03\x18\x8f\x05\x12\xad\xec\xf0\x43\xf8\x73\xd5\x78\x55\x02",
          1, 2432 },
        { 128, 128, 20, "\x08\x47\xa3\xc2\x06\xdc\x6e\x25\x0e\x25\xcf\x21\xcd\xc2\xd3\xa5",
          "\x00\x0e\x4b\xf0\x88\x88\x40\xea\xd3\x6f\xbb\xfa\xe8\x79\xaa\x00",
          "\x9c\x96\x76\x9b\x1e\xd7\xc6\x2c\xc3\xbc\x48\xcd\xb4\x21\x45\xd9\x51\xf5\xa5\xed\x3d\x65"
          "\xfb\x74\xa9\xec\x7a\x0e\x4d\x7c\x35\x62\x7d\x36\x69\xac\x36\xc8\xe9\x73\xc2\xe3\x4c\xca"
          "\x85\xdb\x3e\x65\x78\x37\x8a\x02\x37\x4d\x22\x2a\x0f\xbc\x7b\xa1\x9a\x1d\xc6\xe1\x5e\x97"
          "\x29\xbd\x19\x47\x0d\x6b\x43\x62\xde\x77\x73\x52\x8c\x40\x82\x1a\xfc\xa0\xb2\x73\x88\x23"
          "\x43\x17\x3c\xb8\x7d\xe9\x90\x50\x81\x91\xfa\xa1\x85\x49\x22\x44\xdc\xaa\xb4\x05\x04\x2a"
          "\xc6\x23\xc5\x22\x2e\x03\x9a\x8f\x33\x33\x9e\x1d\x19\x27\x06\x91\xad\x47\x72\x9e\xcf\x5c"
          "\xc5\xad\x48\x6f\x51\x06\x8c\x05\x83\x71\x9b\x43\xa5\x0a\x73\x5a\xc8\x03\x58\xa3\x2c\x1f"
          "\xfd\xfa\x07\x97\xf1\x5e\xb7\xf6\x80\x86\x37\x66\xd7\xfd\xec\x73\x08\x84\x1f\xb5\x40\xca"
          "\x52\x02\x2c\x77\x6f\x23\xcc\xd9\xf9\x3a\x1e\x6f\x87\x84\xa5\x25\x18\xad\x24\x40\x14\x60"
          "\xb2\xa9\x11\x7d\x30\x94\x11\xd8\x0f\xfd\x40\xc6\x4b\xdd\xc1\x12\x4f\x75\x58\xed\x1b\xf5"
          "\xec\x95\xa6\x24\xc0\xf4\x54\xd9\x64\xd8\x9e\xee\x92\xf7\x32\x64\x45\x89\x1e\xbd\xa1\x59"
          "\x25\x23\xe8\xf7\xd7\xef\x6c\xb3\xcc\x99\x26\x9a\xc7\xcc\x21\x0c\x88\x06\x0e\xbc\x63\xae"
          "\x2f\x13\x08\x48\x83\xf7\x52\x1b\xb3\x5b\xb6\xcf\xc7\x7e\xe7\x30\x2a\x74\x57\x62\x86\x14"
          "\x2d\x1f\xb1\xb0\x9d\x92\x61\x92\xb3\xca\xa4\x6b\x66\xf8\x18\x5b\x21\x67\x17\x40\xce\xca"
          "\x8b\xc1\xb0\x00\xdd\x8c\x6a\x52\xdd\xe6\x4a\x5a",
          "\xb2\x68\xed\xbb\x58\xc0\x17\x2d\xd2\xf8\x71\xe7\x06\x39\xf8\x62\x88\x31\x58\x04\xb6\xed"
          "\x2e\x27\xbe\xef\x30\x6f\x1e\x00\x5f\xf1\x71\x98\xe5\xc1\x9a\x8d\xf9\xad\xff\x38\x35\x65"
          "\x8c\x84\xa5\xea\xf0\x7a\x03\x3b\xda\xaf\x52\xcd\x69\x34\x38\xb0\x99\xd8\xff\xa4\xaa\x5b"
          "\x01\x7e\x33\x7e\xc7\xcc\x6d\x2e\x1b\x19\x6b\x07\xde\x42\x08\xe4\x49\xe8\x66\x99\x06\xee"
          "\x27\x04\x2d\x2c\x5f\x17\xe2\x6b\x59\x8e\x68\x51\x74\xa7\x1e\xe1\x64\x7c\x64\x07\x22\x8a"
          "\xb3\xe7\x12\xbc\x05\x06\x8d\x71\x69\xc6\xc2\xe9\xea\x54\x37\x38\x60\x9b\xe8\xd3\xf9\x53"
          "\x29\x09\x74\x3b\x61\x68\xbc\x94\x04\xdb\xc5\xee\x94\xfc\x09\xf7\xd8\xda\xf6\x29\xb6\x8c"
          "\x34\xf6\xe3\x71\x61\xdc\x1c\xdc\x44\xb0\xf9\x69\x62\x44\xa4\x14\xf0\x1a\xae\x6b\x52\xbf"
          "\x33\x5a\xd4\x40\x5c\xf6\x66\x76\xa4\x9f\x1a\xdd\x61\x5d\xa7\xa6\xf4\x37\x01\x2b\xf8\xf1"
          "\x70\x22\x73\xda\xe3\x91\xac\xcf\x96\x0d\xbb\x27\x36\x6e\x85\x00\x2f\xa6\x62\x2b\x10\x77"
          "\x3b\xe4\x12\xff\x44\x8a\xde\x15\x30\xe3\x22\x9b\x06\x9c\x10\x82\xc6\x26\xc5\xbd\x34\x8b"
          "\xbd\xab\xb2\xa4\x73\xb7\x49\xd7\x4e\x93\xca\x30\x8e\xc7\x6e\x92\x5c\x23\xb1\xee\xeb\xc4"
          "\x8b\xcf\xc0\x59\xaa\x7c\x3d\x1f\xff\xec\x42\x24\xb6\xab\x95\x68\xab\xd6\xcd\x24\xf2\x1d"
          "\xd3\xe2\x55\xa3\x2e\xb6\x49\x33\xb4\x72\x32\x34\x80\x19\xbb\x5b\x9f\xdc\xa3\xe1\x60\xa2"
          "\x2a\x98\x1e\xe2\x21\xbc\x6c\x28\xa7\x2a\xeb\xd7",
          1, 2560 },
        { 128, 128, 21, "\x8f\xac\xab\x40\x3d\x1a\x0e\x36\x80\x71\xc8\x6d\x34\x21\xa5\x7c",
          "\xe4\x58\x9b\xf3\x3f\x4a\x93\x09\x14\xca\xa0\x9d\xf8\xfa\x7a\xd8",
          "\x43\x53\x58\x6c\xac\x1e\x25\xb4\x48\xd2\xfc\x0a\x14\x3f\x31\xa5\x68\xcf\xd7\x56\x1e\x1e"
          "\xe2\x07\xde\xcc\x60\x02\x61\x4e\x5a\x5a\xa3\xe4\x2c\xaf\x48\xdd\xd7\xa9\x5b\x11\x34\x5b"
          "\xe7\x1a\x7d\xf7\x6e\x45\xdc\xbc\x28\xb2\x85\x78\xf8\x2c\x66\x7c\x96\x69\xe9\xcf\x79\xf6"
          "\xc7\xe3\x14\x8f\xa7\x67\x87\x12\x8f\xb0\x82\x1a\xe8\x90\xfc\xad\x26\x49\xd7\xa8\x2e\xb6"
          "\x58\xd9\x15\xbe\x30\x3a\xd3\x3d\x04\x89\x5a\xca\xf7\x91\x1f\x6d\x43\x3d\xc2\x09\xbd\x85"
          "\xdc\x89\xb4\xf1\x53\x7f\x3c\xbf\x73\x09\x00\xbd\x27\x32\x2b\xae\xfc\x6e\x16\x1d\xc2\xc2"
          "\x80\x7b\xd4\x72\xec\xbf\x9a\x9d\x9b\x66\xa4\x15\xe2\x4a\xe9\x90\x50\x2a\x93\x64\x78\x9b"
          "\x76\xbd\x92\xdf\x1e\x5c\xa8\x0f\x11\x5a\x1e\xe7\xb7\xf4\xbf\xb2\xbf\xdd\x85\x9b\x05\x59"
          "\x8b\x38\xae\x17\xf2\x67\x36\x14\x15\x28\x6c\x68\xbd\xe2\xee\xab\xa5\x35\xd5\xaf\xf6\x1a"
          "\x52\x40\x74\xed\xbc\x28\x86\xdd\x8c\xd1\x70\x54\x27\x8c\x8f\x4e\xd9\xed\x46\xb6\x0b\xc9"
          "\xe8\x7c\x6c\xcb\x2c\x50\x37\xb7\xd9\x44\x97\x9a\x7a\x11\xf2\x82\xea\xc1\xa4\x60\xb4\xc1"
          "\x14\xad\x0c\xfa\xf6\x11\x95\x9a\xb2\xa2\xaa\xf7\x7c\x77\xb2\x2f\x16\xf9\xac\x01\xd0\x64"
          "\x5f\x0a\x29\xde\xe3\x2c\x0e\x46\xac\xeb\xfa\x3c\xe1\x29\xcc\x35\x4a\x42\x9b\x60\x06\x98"
          "\x16\x38\x3f\x30\xad\xfc\xef\xec\x0a\xe2\x7f\xed\xf9\xef\x20\x1e\x78\x1a\x51\xb5\x9a\x42"
          "\xfa\xad\x4a\xa9\xc0\x6d\x0f\xff\x92\xec\x33\xa6\xcd\xee\x68\x22\x56\xcd\xe2\x02\x68\x73"
          "\x33\x6d\xf3\xf8\xaa\xa6",
          "\x87\x24\x4b\x50\x28\x3d\x83\xb4\xac\x5c\x4d\x3c\x63\x0f\x23\x00\x88\x10\x9c\x5e\x32\xfd"
          "\x22\xf2\xe2\xef\x4e\xe3\x50\xe0\x7e\x19\xf7\x01\x0f\x76\x80\x30\x4b\x54\xb1\x98\x00\x9b"
          "\x52\x78\x94\xb3\x32\xe7\xa0\xcd\x97\x63\x9f\x9f\x73\x2c\xd0\x83\xb0\x15\x80\xb7\x02\x22"
          "\xa3\xc4\x3d\xf7\xa8\x8a\xf7\x1d\x51\xb6\xa1\xfb\x19\xcd\xd6\x8a\xf7\x68\x79\x61\x7e\xdc"
          "\x4b\x24\x9f\xbb\x4e\x56\x5d\xe6\xfe\x3f\x96\x35\xae\xef\x85\x12\x0f\xa3\x6a\x61\xcd\x7c"
          "\x9c\x8c\x6a\x82\xbb\x1d\x4d\xdf\xbb\xd2\x0f\xc4\xf3\xdd\x1e\xc5\x80\x23\x0e\xc2\x05\xf2"
          "\x03\xa5\x93\x4b\xf3\x99\xe3\xea\xc1\x85\xbf\x27\x0e\x99\x56\xc7\x01\x74\xff\x9c\xc9\x13"
          "\x36\x2e\x2a\xda\x75\xfc\xc4\xa0\x3c\x25\xc1\xbd\x07\xfd\x33\xb4\xa3\xdb\x1d\x7b\x11\x8c"
          "\x39\x03\x63\x97\xb6\xa3\x95\x0f\xd4\xbb\x9f\x4e\xf0\x8f\xa7\x17\x56\xe0\x85\x14\x89\x54"
          "\xd3\x74\xea\xc7\xbe\x3a\xd7\x92\xc0\x18\x9b\x6c\x92\x50\xf6\x7e\x63\xb1\x8b\x53\xa9\x3d"
          "\xab\x77\x4b\x3f\xd0\xec\x0e\xcb\xcc\xd0\xc1\xeb\x62\xa1\xb7\x8c\xa8\xc3\xf1\x90\xf9\x78"
          "\x72\x8b\x9f\x64\xe0\x5b\x41\x07\xc8\x1f\x37\x45\x1e\xb6\x65\x05\xb1\x5b\x9b\xb5\x70\x93"
          "\x94\x25\x05\x19\x15\x06\xa1\xfd\xd2\x72\x9d\xe9\xc3\x84\x97\x8a\x0a\x6f\xd4\x6a\x46\xc3"
          "\x6d\xb1\xff\xfa\xc2\xbc\x2e\x96\xb3\xd1\x3e\xe7\xc2\x7c\x58\xb2\x63\x14\x2e\x22\x88\xd1"
          "\x15\x92\x66\x8f\xfe\x96\xe8\xb1\x9b\x21\x8d\xc0\xfa\xe9\xe1\xeb\x62\x5b\xd2\xc3\xd2\x7e"
          "\x64\xb4\x83\x02\xdf\x4e",
          1, 2688 },
        { 128, 128, 22, "\x5a\xe4\xf5\xb4\x41\xf7\x18\x6b\xc8\x1c\xf6\xef\xd9\x7e\xb6\x5d",
          "\x14\x14\xe1\xd3\xd5\x1f\xd4\x4c\x18\x75\x50\x5c\x71\xf5\xcd\x24",
          "\xc3\x0e\x0f\xec\xe2\xb7\x5d\x11\xeb\xf9\xf1\xa2\x7b\xb2\x94\x6a\x10\x2f\x68\x8f\xd1\x4e"
          "\xd6\xe8\x2f\xc5\x8f\x3c\x02\xf8\x53\xc3\x3f\x5d\x76\xcd\x02\xdb\xe0\x1a\x59\x17\xf5\x8b"
          "\xe4\xf1\xa1\x30\x23\x50\x1f\xc3\xb4\x80\x42\xfb\x03\xe5\x2f\x43\x46\x3b\xcb\x30\x7e\xd4"
          "\xc4\xd3\xf8\x56\x34\xb6\x1d\xb7\x39\x35\xc5\x10\x04\x4e\xdb\x56\xc0\x32\x95\x16\xa1\xd5"
          "\x32\x3e\x33\x9c\xdf\x91\x11\xad\x27\x87\xdc\x45\x4e\x22\xe3\x61\x65\x05\x0f\xd8\xd3\xfb"
          "\xdc\xe9\xba\x2e\x2c\x5c\xd3\xcb\x9b\xe1\x46\xa9\x2c\x4c\x5f\xe6\x60\xd9\x62\xc7\x93\x3e"
          "\xfd\xef\xd3\x2d\xd2\x1b\x21\x05\xad\xc2\x9e\xf7\xa6\x89\x12\x94\x64\x87\xcb\x46\x60\x21"
          "\x7e\xc7\xa0\x79\xd3\xc0\x6c\x84\x80\x6e\x85\x1f\x01\xe7\x61\x5d\x3b\x59\x55\x88\x5e\xa7"
          "\x91\xca\x51\xbe\x00\x83\x63\xa6\x6a\x30\xde\x37\xcd\x95\xb3\x92\xa1\x95\x89\x8d\xaa\x3a"
          "\x9e\xb8\x29\xf2\x11\xfb\xcb\x48\x61\x41\xac\x28\x49\x45\x14\xbe\x40\xc7\xd3\x2b\xf2\x14"
          "\x83\x58\x6a\xf6\x1e\x49\xda\x5a\x6e\x18\xc5\x00\x68\x70\x24\x41\x11\xad\xb8\x00\xfa\xb2"
          "\x6c\x1b\x56\x49\x6e\x51\xfe\xf7\x42\xa2\x61\xb8\x02\xdb\x0f\x4c\xac\x40\xaa\x19\x0e\xf8"
          "\x3d\x8d\x40\x19\xd0\x95\x14\x66\x22\x6b\xcd\xd6\xdb\x46\xe7\x4a\x5d\xf0\x4c\xbe\xd8\x77"
          "\x86\xee\x6e\xbb\x2f\x93\xa1\x6c\x10\x90\xfc\xc9\x0f\x7f\x27\x85\xc2\xbe\x9d\xd2\xd5\x56"
          "\xeb\xd1\x4f\x09\x4d\x54\x7b\x47\xd7\x9a\xa4\xeb\xd3\xaf\x10\xae\x4a\x0f\xf7\xb3\x14\xbb"
          "\x95\x5e\x5e\x45\x9d\xc1\x62\x6b\x8c\x65\x40\xb8\x81\xfd\x76\x2e\x71\xe1\x06\x02\xfd"
          "\x5b",
          "\x4d\xb6\x10\x3d\xc7\xd8\x58\x8e\x1d\x59\xbf\xc9\x2f\xbd\x1b\x4c\x07\x1a\xf3\x50\xf3\x2b"
          "\x32\x66\x86\x33\x2e\x9b\x3d\xf9\xa2\x10\xc9\x74\xc2\x76\x16\x55\xb1\xcd\xf3\xfb\x41\x10"
          "\xe5\x0f\x2c\x80\xed\xdd\x03\xd9\x77\xb6\x5f\xc4\x1b\x7a\xd1\x51\xdc\x97\x2e\xfd\xf5\x34"
          "\x07\xbf\x13\xf9\x0d\xb8\x0e\x68\x06\x2b\xef\xeb\x9c\xa0\x8e\x24\x65\xeb\x3c\xcb\x8c\x94"
          "\xd4\x4f\x31\xe3\x5f\x26\xce\xbd\x6c\xf2\x24\xd9\xca\xa4\x3f\x8f\xb1\xa1\x9e\xad\x87\x25"
          "\xd1\xa7\x25\xc6\x43\xcf\xd2\xd6\x5a\xc3\xbb\x62\x39\x5b\xee\x6c\xda\xfd\xc1\x8b\x0d\x86"
          "\x68\x43\x65\x35\x4b\x48\xfd\x4a\x54\xdb\x3e\xe0\x72\x88\x4a\xb3\xf2\x3a\xcc\xce\x8a\x69"
          "\xec\x54\x10\x2d\x61\xe5\x8f\x3d\x77\x80\x77\x21\x48\x4b\xef\x8e\x28\x78\x98\x06\xd6\x7e"
          "\x82\x3f\xcf\x83\xed\x0d\xba\x58\x52\x88\x10\x1d\xad\x74\x24\x78\x50\x0b\xfa\x7c\xb2\xee"
          "\xb5\xbd\x3a\x10\xe8\x41\xcb\x73\xf7\x9f\x9b\x07\x9d\xfc\x3a\xf5\x86\xc7\xd6\xd9\x34\x9b"
          "\x4f\x3d\x51\x5e\x5a\x6e\xd2\x17\xbc\x98\x6e\x27\x59\xef\x6c\xcb\x2e\x74\x64\x98\x50\x6a"
          "\x91\xc7\x1f\xa0\x33\xaa\x02\x70\x2a\x3f\x18\x13\x15\x84\x33\x11\x1d\x99\xf7\x9a\x80\xa9"
          "\x77\xba\x05\x24\xa6\x0b\xfd\x12\x0f\x7e\x6c\x3e\x88\x19\x94\x02\xc4\x37\x33\x76\x31\xbe"
          "\xf9\x62\x93\x7f\x27\x6d\x48\xb1\x36\x77\x77\x30\x70\xce\xef\x8e\x50\xdf\xc3\xbf\x48\x61"
          "\xe1\x84\xb7\x81\x0f\x60\x65\x63\x4c\x2a\x72\xc9\x1e\x04\x6c\x5d\xa4\x59\x09\x77\xa1\xed"
          "\xcb\xea\x43\x0f\x85\x29\xcd\x6b\x83\x1f\x2d\xf7\xe4\x7f\xec\xe0\xfb\x0a\xee\xab\xd7"
          "\xfd",
          1, 2816 },
        { 128, 128, 23, "\x10\xfe\x63\x77\x55\x56\x1d\xcb\x62\x84\xaf\xa9\x83\xd5\xa2\xdc",
          "\x1f\x50\x5e\x90\x22\xac\xef\x23\x6d\x49\x45\x63\xe2\x97\xc5\x2d",
          "\xe1\x66\x72\xa0\xac\x1f\x94\x0f\x4e\x33\xca\x76\x9e\xda\x71\x67\x31\x12\xb6\x67\x44\x6b"
          "\x9d\x58\x28\x4f\xac\xda\xdb\x9e\x65\xdf\xeb\xe4\x1e\x32\xea\x40\x72\xbf\xe0\x9b\x4f\x26"
          "\xa9\x56\x84\x00\x04\x1b\x9b\x2f\xb3\x8c\x4c\x86\xb3\xcf\x0c\xad\xfe\xb5\xe0\x94\x9a\x03"
          "\xe0\x90\x2f\xe1\x75\x23\xc6\xb4\xfb\x6a\x94\xc6\x22\xb5\x1e\x89\x7e\x92\xf6\x41\xc1\x1e"
          "\xad\xcd\x83\xd4\x02\x67\xec\x1a\xc1\x62\x1b\x20\xdb\x99\x88\x40\x0c\x4f\x3c\x0a\x10\x27"
          "\xc9\xb3\x91\xac\x05\x9d\xfe\x98\x6f\xef\xa8\xf5\xa6\xc4\xc2\x7a\xc6\x05\xf3\x6d\xca\x59"
          "\x5a\xbc\xba\x13\xa8\x11\x94\x25\x46\x46\x9d\x40\x60\x5b\x10\x9b\xfe\x2a\x46\x4f\x33\x00"
          "\xf9\xdb\x5e\xde\xdc\x4f\xc1\xb5\x5a\x9d\x4d\x0d\x03\x5c\x2c\x1d\x50\xc5\x66\xa1\xeb\x66"
          "\xac\x8f\x19\x71\xa8\x07\x7f\x46\x01\x72\xa2\x86\x93\x53\xac\x39\xe6\xbe\xb6\x8e\x6f\x87"
          "\x2c\x81\x6c\x9a\x8f\x3e\x1a\x84\x58\x2d\x76\x7f\x95\x9e\x4b\x59\x5f\x69\xe6\x28\xa8\x53"
          "\x7b\xe5\x1a\x23\xd5\xf0\xf1\xce\x59\xe4\xb0\xf6\x78\xd2\x95\x52\x7c\xdd\xf1\xb8\xd3\x16"
          "\x7c\xd2\x89\x6d\x0b\xce\xf6\x13\xdc\xdc\xa3\x58\x0a\x5b\xa0\xff\xf5\x25\x54\xe0\xa4\xd5"
          "\x64\x86\x47\x53\x7f\x87\xdb\xa6\xc5\x42\x7b\xcb\x05\x4c\x13\x64\x3d\x06\x91\xfd\x8d\x8a"
          "\xcf\x40\xd1\x6c\xba\x2d\x81\x3f\xb8\xb1\x26\x43\xa2\xe2\x53\x4d\x0e\xe3\x18\xbd\x79\x55"
          "\x61\x3e\x7e\x95\xd7\xe6\x79\x56\x66\x1e\x6b\x2d\xe5\x21\xa9\x70\x93\x70\x4a\x58\xae\x9f"
          "\x81\x86\x35\x6c\x22\x68\xba\x03\x76\x4d\xd8\xfe\xe9\x53\x11\xcb\xa1\x13\xdc\xae\xa0\x21"
          "\x48\xb4\x52\xfe\x09\x31\xf2\x7e\xb8\x5d\x26\x55\x4d\x57\x4e\x30",
          "\x82\x0d\xaa\x75\x0b\x9a\xfb\x54\x69\x22\x7a\x63\xb5\x79\xac\x6a\xf0\xb9\xfb\x4f\xda\x57"
          "\x90\xd7\xa9\x91\x21\x26\xf4\xa2\x5e\xb4\xa4\x84\x45\xbc\x69\x96\x9b\x8b\x61\xda\x00\xbb"
          "\xba\xaa\x88\x9d\xe7\x73\x7d\x99\x86\x74\xf6\x63\xfd\x5d\xd5\xe4\x1b\xa3\x43\xa6\x0e\xd9"
          "\x4a\xa3\xdf\xa5\x9b\x74\xe5\xbd\x96\x4b\x88\xc3\x7d\x8f\xbc\xa9\xd9\x8e\x6e\xbd\x33\xd4"
          "\x81\xca\x9a\x9d\x31\xba\xb3\x0e\xbe\xcb\xf2\x1f\xc0\xf7\xcc\x08\xff\x8b\xba\x35\xad\x34"
          "\x07\x76\x0f\xf4\x2d\xf6\xd2\xda\xd8\x24\x96\x14\x6a\xc4\x81\x29\x27\x3c\xb6\xcf\xd6\xf6"
          "\x16\x06\x21\x74\xc5\x88\xfe\x47\x5e\xd8\xae\x0b\x3e\x0b\x7f\xca\xd8\xea\x67\x9a\xca\x46"
          "\x83\x90\xc9\xd1\x18\xf2\xf1\x43\x0a\xbf\xa7\x0e\xee\x40\xdf\xd8\x53\xc8\xec\xb1\xd9\xaf"
          "\x81\xbc\x09\xb3\xa1\xed\xe5\x48\xfa\x0c\x64\xe0\xdb\x7d\x09\x64\x9b\xdb\x69\xce\x28\xd2"
          "\xf5\xb5\x05\x56\x0c\xe1\x04\x52\xbf\x00\x62\xf6\x1a\x8c\x3d\x21\x06\xa0\x19\x99\xc3\x1a"
          "\x40\x77\x9a\xd9\x95\x50\x76\x15\x72\xe9\xa0\x0e\x44\x5d\xde\xf4\x16\x3c\x6e\xb0\x84\xa2"
          "\xe0\x5a\x02\x3c\xeb\x02\x40\x24\xbb\xd6\x1e\xef\x9a\x5c\x97\x05\x4c\xea\x80\xe7\x8b\xc2"
          "\xbb\xa0\x8d\xa1\x77\xab\x89\xb3\x5f\xb5\xca\x72\xa9\xc4\x47\xfa\xa0\x6e\x2d\x2f\x3d\x54"
          "\xb3\xf7\x98\x88\xa9\x9a\xad\xd7\x1b\xe0\x44\x38\xe9\x6d\x00\xc9\x42\x97\xc2\xc5\x7b\xb1"
          "\x34\x3b\x77\xb8\x76\xb9\x1c\x99\x3c\x3b\x7e\x41\xb2\x64\x69\x8c\xe5\x77\xe8\x6d\xcc\x05"
          "\x24\x29\xb3\x1d\x2f\x2a\xec\xa6\x25\x04\x55\x44\x4c\xef\x99\x28\x8c\x7a\xdd\x8c\x9e\x6c"
          "\x56\x85\x24\x23\x27\xf8\x61\x44\xb4\x7c\x81\xef\xa2\xa1\xbd\x05",
          1, 2944 },
        { 128, 128, 24, "\x84\x6b\xc9\x0b\x33\x94\x98\xf5\x66\xcf\x7c\x87\x7c\x3d\x3d\xbc",
          "\xd7\xee\xae\x93\x6e\x07\x6c\xc0\x8f\xb7\x8f\x55\x35\x0d\xef\x81",
          "\x32\x85\xd1\xd5\x86\x0f\x6f\x68\x76\x09\x9d\x55\x2b\xf5\x86\x3e\x34\x3c\xea\xee\xaf\x5b"
          "\xdf\xa0\xf5\xe3\xce\x8d\x29\xc3\x0a\xa5\x3e\x41\x6d\xfe\x06\x91\xc5\xe0\x2e\xcb\x43\x5d"
          "\xf4\x62\xd0\x60\xce\x7b\x1a\x05\x8c\x9d\x9e\xee\x71\xdd\x63\xda\x69\x29\x20\x4d\x4b\xbf"
          "\xef\x9d\x68\x89\x16\x42\xd5\x1c\x7b\x50\xa0\x52\x72\xcc\xbb\xb6\x79\x8c\x1f\x45\x04\xd1"
          "\xaa\x7f\x88\xe5\x05\x81\x00\x9b\xdc\x0a\xba\xac\x86\xd1\x39\xdc\x1a\x73\x30\x8b\x72\xb5"
          "\x85\xb9\x33\x3b\x1c\xb6\x91\xa6\x80\xdf\x80\x76\x43\x16\xfc\x74\xf1\x7c\xba\x4e\x07\x0f"
          "\x23\x32\x6e\xd3\x5f\x63\x93\xab\x8f\x30\x44\x28\x16\x36\xfe\x8b\x32\x1b\x3c\x18\xcb\x78"
          "\xa3\x33\xd1\xf4\x96\x10\x2f\xd0\x06\xe8\xae\x1e\xd7\x40\x25\x37\x34\x95\x23\x2f\x96\x08"
          "\xfc\x2a\xe0\xf1\x81\xf4\xb3\x6f\xdd\x5b\x5f\x44\x75\x07\x14\x3a\x7b\xd7\x73\x48\x28\xfd"
          "\x81\x04\x93\xcf\xea\xaf\xc4\xb0\x00\x72\x4f\xe5\xc6\x7a\xd2\xd1\xeb\xa3\x31\xf3\x9e\x0e"
          "\x04\xe0\x3a\xe3\x59\x6e\xb9\xc7\xff\x28\x55\x34\xc5\x25\xd7\x53\x06\x4b\x99\x09\x5b\x15"
          "\xe2\xb8\xa0\xc7\x11\x61\x58\x14\x10\xde\x99\xf4\xca\xb1\x14\x59\x04\xa9\xb3\x10\x0c\x77"
          "\x81\x11\xf8\x2a\x2d\x3d\x95\x53\x38\x98\x4a\x1a\x52\x7d\x95\xa6\xe1\x2b\xff\x2b\x4b\x0e"
          "\xf0\x9a\xf3\x31\xc7\xd5\x01\x0a\x62\x59\x93\xfb\xe3\xcc\x6a\x56\x8d\x0b\x6e\xc2\x7e\x2d"
          "\x37\x18\xd8\xb3\x4c\x7e\x0e\xdf\x60\x05\xcc\xc8\xc8\x19\xd1\x89\xba\xbf\x7e\xe4\x5b\x7b"
          "\x44\x61\x52\xe9\xd7\x8c\x00\x16\x89\x5e\x51\x28\xce\x8a\x10\xb8\x17\x5e\x12\x06\xb1\x54"
          "\x48\xc9\x8d\xb3\xb8\xf3\x3b\xf3\x55\x8a\x3d\x31\xdc\xcb\xa6\x4e\x4a\x25\x62\x32\x11\x86"
          "\x5d\xab\xde\x1a\x29\x3b\xc1\x6d\x38\x68",
          "\x7b\xed\x1e\x2f\xe8\x41\x54\xf5\xc1\xc1\x95\x9f\x01\xf4\x49\x0f\xa9\xf4\x8d\x00\xed\xa4"
          "\x36\x7f\x46\x3c\xdb\x79\x41\x29\x27\xc0\x85\x94\x7d\x7a\x99\x95\xd6\x0b\x01\x15\x2a\x07"
          "\xa6\x67\x04\x5a\x33\x68\x93\xc8\x78\x04\x58\x49\x70\xe1\x6a\xcc\x15\xdd\x9e\x1d\x50\xb4"
          "\x1c\x4e\xdc\xc4\x96\x4c\x88\x3f\x35\xbf\xe2\x85\xa2\xb1\x56\x9c\xae\x05\x80\x9e\x63\x10"
          "\xdd\xb4\xb3\xc0\x09\x54\x58\xad\x32\x7e\x2c\xe6\xe9\xac\x54\xae\x4e\xfb\xfc\xdd\x1e\x9e"
          "\x1d\x00\x4c\x39\xc6\x91\xd5\x7e\x0d\x37\x4b\x0d\xe3\x58\xdc\x4b\x0e\x30\xb4\xa3\x74\xca"
          "\xa1\xec\xee\xaf\xcd\x82\xa1\x5b\x74\x12\x5a\xec\xfe\xc2\xfc\x80\x38\x4d\xcf\xe7\xb4\xa9"
          "\x9b\xba\x5f\x90\x50\xa1\x0a\x21\xca\xe3\x77\xf5\xcb\x54\x5d\x63\x95\x22\x75\x8d\xb8\x29"
          "\xa7\xd5\x6d\x81\x62\x22\xd3\x21\x35\x06\x52\x3a\x3c\x1e\x29\x5c\x05\x3c\xa2\x17\x70\x0b"
          "\x24\xe2\x54\x46\xfd\x1f\x38\x3e\x27\xc7\x27\x89\x7d\xe9\xf2\xbe\x4a\x3b\xdd\x55\x8f\x7f"
          "\x72\xe2\x68\x67\x5f\x86\x30\xe4\xd1\x1c\x72\x26\x29\xe4\x3e\x24\x45\xde\x51\x2b\x9d\x30"
          "\xc1\x63\xe4\xbf\xa8\x73\x46\x62\xde\x36\xf3\x07\x8c\x66\x87\x28\x57\x39\xcf\x27\x4c\xe2"
          "\xfc\xfa\x0a\x80\x29\xcd\x20\x61\xab\x61\x65\xed\x66\x59\x0b\x71\x59\xf6\x6b\x47\xf4\x84"
          "\x7b\x0d\x9a\x7b\x3c\xb7\xcc\xf9\xc6\xf2\x54\x24\xa5\x30\x92\xfb\xee\x6a\x85\x51\x3d\xf6"
          "\x23\x97\x14\x3c\x4a\xab\xb7\xc6\x39\x08\x34\x85\x4f\x1b\x49\x99\x00\x23\xd2\xdb\xa2\x1e"
          "\xcf\xc5\x2e\xbc\x2a\x18\x03\x01\x23\x20\xd8\x07\xd7\xf2\x4f\x30\x29\x57\x8c\x41\x0d\x96"
          "\x1b\x16\x53\xa5\x47\xf5\xe1\x83\x44\x78\x16\xe2\x45\xc6\x5a\xdd\x4d\xb9\x59\x75\x9b\xf7"
          "\x15\xdd\x7f\xc2\xd7\x60\x5d\x79\xfb\xf8",
          1, 3072 },
        { 128, 128, 25, "\x42\x0e\x78\x96\xeb\xf6\x42\x7a\xc7\x10\xde\x98\x5c\xf3\x7e\x64",
          "\x2f\x49\xf2\x72\x70\x63\xf6\x26\xb3\x21\x55\x04\x3f\x76\x5f\xf0",
          "\x65\x5d\x50\x66\xa8\xca\x5f\x39\xcb\xa1\xee\x10\x19\x5e\x7a\x13\x68\x19\x7d\x16\x38\xe4"
          "\x74\xb8\xe1\xa0\x7e\x43\xb3\x77\x9e\xb2\x7f\xf5\x2f\x7b\xa0\xd0\x85\x93\x5a\x0b\x41\x29"
          "\x4e\x00\x5a\xe9\xf4\xa3\x99\x85\x8b\x7c\x53\x4c\xcd\xdf\xad\xff\x4d\x77\x95\xc3\x66\xc6"
          "\xba\xd6\xc4\x88\xcc\xa0\xd5\x45\x55\x71\x20\x3d\xc2\x51\xaa\x1e\x8f\xd3\x31\x88\xef\x04"
          "\xe8\x25\x46\xb1\x39\x32\x2c\xb9\xd0\x19\x25\x8d\x10\x18\x55\x10\x4d\x56\x0e\x1b\xc7\x46"
          "\x40\xee\xec\xa1\x35\x7a\x44\x12\x63\x7e\x8a\xe0\xef\x5f\x19\x27\x85\x84\x82\xed\xc8\x13"
          "\x34\xfe\xd9\x50\x2f\x3b\x01\x3e\x4a\x0b\x25\xcf\x09\x91\x73\x6a\x1e\xd4\x8f\xd7\xcf\x30"
          "\x6b\x66\x9a\xcc\x5e\x79\x23\xe0\x44\x56\x75\xd6\xb9\x86\x59\x2f\x14\xe3\x08\x37\x0b\xfe"
          "\xb0\x67\x9e\x56\x7f\x7a\xe3\x4c\x4c\xe4\xf5\x0b\x43\xee\x4f\x61\x99\xf3\x80\xc1\x29\xce"
          "\xab\xa4\xb2\xd9\x37\x91\xc9\xb4\x16\xdc\x5c\x67\x6a\xe3\x8c\xe1\x14\xa3\xdc\xb5\x46\x22"
          "\x80\xb8\x67\x34\x96\x6f\xbc\xa1\x0c\xfb\xb0\xf2\x53\x48\x27\x3c\x75\x7d\x78\xbb\x75\xff"
          "\xa2\xd7\xc7\x36\xb1\x0c\x25\xe3\x7e\x45\x63\x80\x8f\x68\x3b\x36\xdb\xf4\x97\x02\x40\x07"
          "\x61\x7a\x63\x42\x26\x8f\xc2\x2d\xaf\xf8\x1c\x13\x86\x85\x53\x8b\x9a\x5c\xe0\x0e\xb5\xf0"
          "\xaf\x17\x3e\x3b\xc1\x55\x1c\x8d\x98\x50\xfe\xe9\x74\x9d\x1d\x2e\x5e\x1b\x5c\xe1\x46\xe3"
          "\x2e\x7f\x3e\x08\x24\xcc\x7c\x75\xc0\x9c\x32\x87\x9d\x4d\x84\x48\x25\x43\x77\xc2\xbc\x66"
          "\x09\x66\x1c\x0b\x42\x42\xf7\xa5\x62\xa7\x22\x89\x1a\x91\xfe\x5a\xc4\x0a\x7b\x49\xcd\xb5"
          "\x41\xea\xa1\xd8\x33\x6d\x25\xac\x5c\x1b\x63\xde\x0e\x8e\xa9\xf0\xa5\xee\x88\x84\x34\x3b"
          "\xc9\x39\x95\x74\x2a\x23\x25\x80\x17\x0e\x57\x00\xc1\x6e\xac\x26\x1f\x86\x63\xaa\x37\x76"
          "\x47\x68\x9d\xc9",
          "\xd6\x3c\xce\x37\x8e\xb0\x6c\x06\xb7\x7b\x7e\x9a\x07\xb3\xae\xc9\x9b\x4e\x53\x01\xc6\xf9"
          "\x47\x39\xd7\xc6\xbd\x86\xf1\x29\xab\x5e\x0f\xc0\xee\xd7\xba\x62\x78\x04\xd5\xc7\x12\x47"
          "\xb6\xa8\x77\x1f\x41\xe2\x06\x98\xce\xe3\xdc\x95\xc0\x4c\x14\x42\x67\x86\xd5\xc6\x3e\x39"
          "\x25\x0e\xbc\xf2\x03\xeb\x08\xc3\x55\xf3\x00\x4e\x98\xfe\x85\xb4\x0d\x1f\x93\x8a\x83\x4b"
          "\xad\xbb\x44\xd5\x6e\xdb\x7a\xb0\xe5\x15\xef\xa0\x6f\x6d\xbc\x1d\x45\x8b\xc5\xa2\xd7\x67"
          "\x3b\xe2\xaf\x2d\x04\xd5\xd1\x80\x36\x0d\xd0\xe5\xca\x1f\x22\xd3\x38\x25\x69\x64\x72\x75"
          "\x1c\x73\x01\x98\xa6\xe2\x55\xda\x3b\x43\x24\x1a\xfb\xb4\x31\xab\xa8\xbf\x59\xd5\xb3\x9d"
          "\x7f\xf2\x8d\xd0\x8c\x93\x67\x56\x9a\x9e\xa5\x9c\xf9\x78\x06\x0d\x7d\x28\xc7\x86\x37\x1d"
          "\xa6\x4d\x9a\x9b\xf0\x8a\x63\x87\xac\xc4\xd8\xa7\x49\x09\x57\x5f\xef\xe3\x00\x09\x4e\x75"
          "\xa7\x90\x5a\xfe\xf0\x5e\xf0\xc3\x1e\xc6\x76\x7f\xfc\x5b\x39\x9a\x81\x62\xcc\xa6\xe2\x6c"
          "\x6c\x63\xd6\x3c\x9a\x7a\x4f\x7b\x1e\x86\x98\x66\xa6\xa4\xd1\xf1\xae\x67\x53\x2b\x74\x2e"
          "\x6d\x97\x65\x42\x2d\x34\x03\xfa\xef\x59\x35\x79\x3b\xaf\xc6\xb1\x24\x84\x44\x97\x97\x11"
          "\x84\x67\xd4\xe8\x65\x71\x7d\x19\x49\x0d\xde\x79\x7f\x38\x7f\x76\x05\xf8\xb5\xe8\x1a\x8e"
          "\xfb\xc5\x61\x2c\x90\x82\x8b\x63\x30\x1e\x1c\x22\xbe\x4f\xce\x6b\xb1\x93\xfb\x42\xf1\xca"
          "\x6d\x12\x3a\x91\x62\xce\xf5\x18\x05\xb6\xd6\xa2\xb9\xb5\x0b\x02\x1c\x49\x52\xaa\x5d\x8f"
          "\x34\x82\x4e\xd3\xfd\x45\x6f\x32\xeb\x04\xc3\xa5\x1e\xfc\xd2\xb7\x40\xe5\x33\x93\x64\x5d"
          "\xd4\x7c\xb7\xae\xd9\x0d\x6e\xc2\x11\xed\x07\x22\x65\xb6\x58\xd6\xca\xca\xef\x9e\xba\x35"
          "\x92\xce\xb2\xa2\xbc\xaa\x4e\x18\x18\xe9\x22\x67\x96\x8b\xc0\xbc\xaf\xf7\x56\x2b\xc0\x83"
          "\x3b\x5a\xec\x09",
          1, 3200 },
        { 128, 128, 26, "\x53\x56\xa6\x48\x0b\x17\xc6\x14\x1c\xb8\x44\x31\x53\x4c\x45\x9f",
          "\xdb\x84\x61\x33\x37\x6b\x6c\x66\x94\x94\xb8\x98\xaf\xfa\xbe\x53",
          "\xe6\x6f\x07\x4e\x7e\x3c\x43\x6f\x7e\x11\x10\x7c\x82\xd1\x90\xb5\xec\x15\x3f\xce\xd2\x21"
          "\x53\x56\x75\xf8\x69\xaa\x02\xb7\x11\x97\x90\x15\x73\x48\xa7\xde\x66\x5f\xc2\xea\x36\x0c"
          "\xf5\x00\xd8\x29\x2a\xc4\xdf\x7c\xce\xfa\x4d\xb4\x17\x3b\x17\x8c\x5f\x4c\x48\xb7\xcc\xa3"
          "\xec\x4e\x90\x41\xd6\xdb\xc6\xb5\x12\x44\x0b\x47\x83\x96\xdc\x28\xb5\xe6\x26\xa0\x2c\xed"
          "\xf1\xf4\xb0\x00\x1c\xc1\xec\x50\x91\x8b\x72\x0c\xc4\xca\xe4\xeb\x36\x5e\x03\x50\xc9\xf9"
          "\x50\x33\x82\x27\xb3\xf0\x42\xac\x14\x99\xad\x1b\x7f\xca\x14\xfd\x69\x1e\xd7\xf8\x88\x89"
          "\x6f\xa9\xc2\x04\xd3\xb4\x92\xab\x2b\xa5\xda\x28\x43\x63\x28\x30\x0e\xbb\xa0\xe9\xdf\x57"
          "\x66\x16\xeb\x1a\x0d\x38\x1b\x81\x4a\x9e\x9c\x88\xcb\x20\x37\xfa\xd5\x1d\x2a\x5d\xe6\xe5"
          "\x10\xc8\x9b\xac\x3c\xbe\xd1\xde\x4d\xa1\xfb\x93\x0e\xbb\xdb\xb9\xa0\xd4\x14\x88\x8c\x4a"
          "\xa2\x3d\x43\x02\x2d\x1e\x15\xe9\x45\xfa\x77\x63\x2f\xbf\x3e\x35\x5f\xdb\x86\x0e\xdd\xda"
          "\x44\xb3\x22\x78\x09\xee\x6e\x44\xe1\xd5\x05\xcf\x30\xe9\x8b\x77\x6b\x5c\xb1\x86\x7d\x41"
          "\xa3\x81\x6d\x82\xaf\x6a\x5c\x6f\xaa\x75\x34\x63\xc0\x41\x35\xb7\x00\xcc\x5a\xe7\xcc\xad"
          "\xca\xfe\xa5\xdc\x4d\x33\x96\xa6\x92\xf0\x30\x3a\x1b\x56\x35\x6b\x57\xb4\xc6\xe9\xdd\xb0"
          "\xec\x9d\xd5\x30\x1b\x1a\xb7\x02\xe5\xf3\xb0\x5f\x33\x0a\x93\x8d\x16\x56\xa4\x1e\x3d\xf3"
          "\x69\xb6\xd0\x36\x3a\x66\x91\x55\xfe\xd0\xbc\xe2\x52\x9b\xec\xd5\x4e\xcb\xa0\xaa\x40\xfc"
          "\x9c\x39\x47\xbf\xc5\x95\x58\x2a\xf0\xbb\xd1\x56\x92\xc2\xf1\xd2\xde\x9e\x58\x3f\xa4\xf9"
          "\x20\x7d\x8b\xeb\x0f\x4a\xbe\xd3\x45\x96\x25\x23\xad\xe2\x94\x4d\x2f\x82\x51\xf0\x3c\xc4"
          "\xe8\x10\x65\x2b\x18\xe8\x83\x09\xcf\x53\x2b\x35\x5f\xbc\x03\x26\x76\x9e\x66\x4b\x9f\x1f"
          "\xd7\xfe\x27\xcc\x9b\x2f\xb4\x60\x1d\xe1\x8b\x21\x1e\x8c\x6f\x96\xfc\x81\x5c\x82",
          "\xa9\x33\x68\x54\xb2\x02\x9c\x0a\x63\x15\x46\x47\x48\x0f\xa5\xcf\x24\xe7\xbd\x98\xc9\xe5"
          "\xf5\xe4\xca\x13\xe9\x7e\x54\xc2\xdc\x3b\x06\x5d\x34\x64\xa2\xb4\x66\xb1\xb2\xe7\x0c\xf5"
          "\xf3\xe9\x51\xad\xa7\x23\x8b\x62\xdb\x1c\xf0\xb2\x9b\xca\x0a\x6c\xf5\x32\xc6\xf3\xfe\xa7"
          "\xfc\x8e\x86\x2a\x7f\x9d\x78\x5f\x0b\x7e\x70\x11\xdd\x7d\x11\x3c\x14\x93\x41\xda\xa2\x97"
          "\x59\x65\x9b\x73\x5c\xc0\x5f\xa3\x40\xa6\xd7\x18\xa7\x17\xc4\x0b\xc9\x9a\x26\xbb\xdb\x37"
          "\xc7\x77\xcc\x1e\x84\xa3\xc9\x79\xe4\xa6\x14\x3a\xf9\x04\x78\xcd\x40\x0a\xd6\x9d\x07\xf0"
          "\xc2\xdf\xe2\xb8\x18\x3c\xa8\xfa\xd8\x39\xba\xab\xe8\xbd\x7a\x2d\x76\xcd\xd1\xe0\x44\x8b"
          "\xaa\x47\x53\x4a\x4e\x5e\x72\x91\x28\xba\x84\x6f\xc6\x8b\x8e\xd9\x2a\x7e\x8a\x06\xfe\xae"
          "\x68\x3b\x74\x0b\x68\x34\xaf\x82\xb3\x4c\x06\x7c\x18\xd7\x66\xe4\x0a\xa0\x5a\xbc\x6f\xf8"
          "\xd5\xa7\x6e\xae\xaf\x99\x4a\x3d\xc7\xb3\x7a\xea\x6d\x39\x0c\x0b\xac\x8a\x0e\x01\x29\xdc"
          "\x63\x39\x85\x0e\x13\xf0\xc7\x3f\x62\x3b\xea\x1f\xf1\xab\xc5\xc8\x45\xa3\xa0\x6c\x0f\x8f"
          "\x1a\xda\xe2\x3f\xf4\xf0\x44\xd1\xd6\x37\x67\x58\xf1\x1f\xd2\x98\xee\x8f\x07\x4f\x0b\x6e"
          "\x01\x4f\x4d\x65\x6f\xd2\x7e\x9e\x05\xdc\x7a\x02\x42\xda\x7c\x95\xa3\xde\x3f\x6a\xb4\x20"
          "\x6c\x92\x1b\xf2\x26\xbb\xcd\x2f\x07\x65\x38\xbf\x04\x44\x72\x1c\x7c\x3e\xac\x58\x7b\x1a"
          "\x83\x67\xe7\x52\xc8\x8e\xdf\x54\x37\x34\x3b\x70\x7a\x7e\x17\xd3\x00\x41\x16\x2e\xe1\x39"
          "\xc9\xdf\x29\x55\xb7\x48\xf0\x8e\x8e\x3c\x17\x94\x89\x5d\x67\x1c\x30\xbc\x73\xc8\xd6\xd8"
          "\xe3\xcb\x87\xbe\x19\xac\x63\xe8\x9a\x17\x0f\xcf\x45\x04\x11\x42\xa5\x93\x16\x5d\xdb\x68"
          "\xf3\x55\xa1\xe4\xc4\xda\xce\xdf\x83\x67\x9f\x6c\xbc\x0e\x12\x65\x84\x57\x28\xbe\x69\xf2"
          "\xad\xfd\x85\x44\x45\x9d\xb9\xf7\xdd\xc1\x05\x6b\xc7\x32\xc9\xf3\xc3\x41\x5e\x53",
          1, 3328 },
        { 128, 128, 27, "\x0f\x95\xaf\x47\xd2\xdf\x2a\x89\x31\x4d\xca\x4c\x01\xe9\x3b\x1e",
          "\x94\x24\xd6\xc4\x53\xcf\x49\x8b\x08\x29\xda\xc3\x9b\xdd\x6f\xb2",
          "\xed\xff\x83\x0f\xe3\x32\x73\x0b\xf6\xda\x54\x94\xdb\xfb\x11\xfa\x24\x16\xca\xa5\x24\xa3"
          "\xf3\x43\xad\x87\x0b\x4d\xfc\x93\xb7\x51\x17\xe3\xac\x64\x13\xf6\xad\xa7\x10\xd9\xf5\x29"
          "\xe1\x8a\x72\xf8\x2b\xa0\x5f\xf2\x3f\x3b\xf6\x76\x35\x02\xa2\x03\x61\x41\xfc\x47\xa3\x0f"
          "\xc9\xc1\x00\x95\xe9\xf9\x9a\x90\x1c\xaf\x75\x88\xcf\x93\xd2\x1a\xff\x9c\xda\x36\x51\x3b"
          "\x65\xa3\x7d\x41\xda\xc8\xde\x85\x22\xac\xf1\x4f\x41\x1a\x8b\x1b\x55\x79\x83\xab\xa9\x0f"
          "\x26\xf6\xbb\xc2\x59\xec\x1b\x02\xd4\x94\x49\xf4\xa0\x25\x32\x51\x5e\x00\x73\x42\x2b\xdf"
          "\x2c\x6e\xe2\xcb\xcb\xba\x6b\x66\x60\x67\xf3\x2d\x67\xf0\x2d\xe8\x65\xf7\xbd\x87\xfc\x34"
          "\x26\x6b\x59\x78\x43\x5e\x5a\x99\x3a\xd1\x44\x45\x07\x17\x0b\xc5\xc4\xd8\xcb\xf3\x13\xd3"
          "\x50\x71\x67\xed\xba\xd7\xdb\x51\x02\x61\xca\x75\x3b\xf0\x81\xde\xc2\xc4\x1f\x4d\x32\xb9"
          "\x57\x5b\xa8\x32\x91\xec\xb8\xfd\x50\xdc\x87\x31\x80\xc8\xef\xf6\xaf\xeb\x11\x2b\xda\xb7"
          "\x7b\x4f\xde\xcd\xb7\x37\x00\x41\x31\x6a\x12\x05\xb4\x6b\x1a\xd0\xda\x11\xac\x32\x6f\xcf"
          "\x9f\x77\xa7\x27\x50\x90\x9b\xd8\xe0\x54\x26\xe9\xca\xce\xd4\x85\x2d\x9a\x6a\x32\x96\x39"
          "\x5d\x5a\x02\x0e\x70\x35\xa6\x6a\x0d\x9c\xd6\x83\x34\xba\x2c\x52\x74\xf8\xba\x78\xc4\xb0"
          "\xd5\x7f\x77\x11\xb1\x8e\xc8\x7c\x25\x4a\xf1\x11\xb0\x60\xb6\x2a\x89\x06\xd2\xb5\xf6\x18"
          "\xff\xaf\x3a\xc0\x33\xd3\x48\x98\xff\x51\x85\xd5\x69\x23\x02\xee\x15\x5e\xda\x06\xfa\x25"
          "\x52\xad\x4e\x4e\xd8\x5d\x52\xa5\xea\xef\x64\x11\x1b\x52\xaf\x63\x45\x27\xf6\x06\xe5\x5e"
          "\x8f\x5c\x38\xb7\x2e\x43\x54\xe5\x57\x63\x86\x2e\xa0\x89\x6f\x41\xb1\xe5\xe8\xe4\xd6\x08"
          "\x18\xd8\x9c\xd6\x81\xd3\xee\x4c\x09\x5c\xfd\xc7\xab\x7a\x07\x66\x79\x07\x11\xd5\xe4\xd7"
          "\x00\x38\x55\x0b\x5a\xae\x82\x7e\x8a\x9e\xe8\xaf\xeb\x90\xcb\xa5\xcb\xaf\x50\x07\xbb\xee"
          "\x7c\x5a\x56\x5a\x6d\x91\xb0\xfc\xc9\xea\x27\xdc\x8d\x1b",
          "\x86\xa3\x23\x2c\xd6\x49\xb2\x3e\x95\x4e\xbd\x3e\xee\x5e\x48\x72\xbe\x33\xc3\x09\x9c\xe6"
          "\x9e\x2b\x18\x16\xc3\xa5\xdb\x49\x79\x07\xc7\x2b\x9f\xdd\x09\xdb\xa2\x27\x02\x49\xd1\x2c"
          "\x2f\xa2\x84\xc0\x15\x74\x91\x0c\x6c\x91\x8f\x73\xa9\xa2\x01\xdd\x28\xa9\x8a\x22\xe1\x25"
          "\x62\xdc\x0c\xd1\x16\xeb\x18\x2b\x47\x51\xb3\x3c\xf1\xd7\x25\x3f\x25\x0b\xc7\x5c\x3a\x62"
          "\x61\x94\x6e\xd1\x83\xad\x08\xd3\xa5\xf0\xae\x0c\xc5\x26\x8d\xc0\xf7\x35\x90\xa9\x78\xdb"
          "\x37\xc1\x82\xca\x65\xe0\xd2\x1d\x67\x85\x18\x12\x39\x17\x26\x3d\xda\xaa\xac\x51\x30\x29"
          "\xe6\xaf\x1c\x36\xf2\x1e\x3a\x40\x63\xf9\x45\x3b\xde\xcc\xf0\x7a\x10\x8b\x43\x1a\x9a\x2e"
          "\x4e\xb9\xd5\xe9\x7b\x67\x5e\xda\x4b\x0e\x1f\x02\x89\x08\x4c\x49\x3c\x84\x0a\xad\x24\xb0"
          "\xfd\x60\x37\xdd\x4e\x36\x09\x3a\xc5\xc5\xb8\xbb\xb4\xc3\xf0\x1c\x9d\xe7\x67\xcd\x95\x93"
          "\x97\x43\x01\x7e\x8b\x35\x47\x94\x4c\x34\xd3\xc1\xf1\xc1\x53\xaa\x18\x2d\x3e\x2c\x27\x35"
          "\x2e\xa6\x50\x6c\xd8\x8c\x22\xc9\x96\x19\x9f\x70\x8b\x5c\x73\xf9\x5e\x85\xd8\x91\xfe\xbd"
          "\x52\xef\x2f\x84\xeb\xb8\xeb\x78\x79\xa6\xd4\x3b\x04\x9d\x4c\x13\x41\x22\xd0\xe9\xcf\x55"
          "\x75\x6b\xe1\xe6\x3d\xd4\x38\x64\x0e\x44\x7d\x3f\xd8\xb8\x87\xd2\xd6\x37\x5b\x29\x8e\x2d"
          "\x86\xd3\xd5\xd4\xd6\x3d\x1a\x2d\x9f\x2f\xda\x07\x71\x29\x40\xc9\xd2\x16\x55\x6e\xd0\xbb"
          "\x2a\x48\x5a\x9a\xe3\x08\xa8\x54\xef\xbe\xcc\xe7\x66\x1e\xb5\x31\xb9\x32\x13\x1f\x1d\x1f"
          "\x57\x89\x1f\xd4\x91\x19\xe5\x88\x2b\x8f\x0d\xf4\x87\x3a\xea\x81\x16\x67\x90\x3b\x9e\x08"
          "\xba\x1b\xec\xc4\x0d\x42\xfd\x15\xc7\xbc\x38\xe8\x3c\xb3\xa0\xc9\xa6\xf4\x2a\xc1\x45\xeb"
          "\x7a\xf1\x38\xf5\x6a\xce\x4c\x06\x50\xa9\x98\xa9\x17\xd8\xb9\xf5\xf7\x8c\xac\xd3\xb0\xb7"
          "\x8a\x06\xe7\xb6\x7b\xb1\xfa\x8a\x76\x6a\xf8\x06\x3a\xbf\x33\xe2\xdc\xb5\x27\xbd\x68\xa6"
          "\x67\x9d\x57\x27\x40\x84\xe6\x28\xae\x7a\xcb\x98\xe3\x67",
          1, 3456 },
        { 128, 128, 28, "\xaa\x92\xbe\xcf\x00\xa2\x53\x42\xfe\xcb\x96\x3f\xfc\x41\x7e\x69",
          "\x77\xbe\xfe\x07\xa0\x1a\xf2\x0a\x10\xb2\x49\xea\xa8\x1a\xc7\x74",
          "\x87\xc6\x60\x52\xe8\x0d\xc7\xdc\x42\x8d\xa5\xe0\x46\x96\x6a\xe8\x37\x4f\x9e\xd4\xa7\x09"
          "\xba\xd2\x98\xec\xc6\x31\xd1\xa4\x15\x28\xb2\xec\xd6\x2f\x94\xb6\x41\x43\x63\x74\xb5\xc2"
          "\x58\xde\x90\xf6\x7b\x79\x2f\xc7\xaf\x8a\x19\x5d\x18\xcd\xb3\x49\x49\xf8\x49\x3d\x85\xcf"
          "\xf4\xd5\xe1\xa9\xab\x3b\xc9\xda\xbe\xd5\x99\x1f\xdd\xa1\xaf\x7f\x60\xa6\x03\xe1\xbd\x5a"
          "\x09\x3e\x4a\xf3\x2b\x66\xb2\x6b\x55\xf3\x41\x1d\xe3\x8d\xd3\x2c\xca\xa5\x34\xfb\x80\xd9"
          "\x97\x7e\x7b\xf0\x9d\x00\x2f\xf0\x1b\xb2\x08\x50\x62\x5d\x36\xce\x1a\xae\x4c\x1f\x64\x8b"
          "\x94\xd0\x63\x9c\xf2\xfe\x68\xed\x20\xc7\x89\xcb\xc8\x31\xc5\x89\x88\x73\xc7\x32\xa5\xc5"
          "\x27\xd4\xf4\xd8\xd9\x14\xfc\xff\x37\xdd\x11\x4c\x2e\x66\x63\x4d\x69\xe9\xf6\xc8\x9d\x9b"
          "\x07\xdc\x85\xc8\xf3\x9b\xfc\x03\x92\x5f\x5e\x86\x2d\x82\x0f\x8d\x4b\x41\xe8\x28\xbe\x74"
          "\x0d\xa8\x9e\x29\x7d\xec\xa1\xe9\xde\x8d\xcd\x87\x1f\xcc\x47\xd9\xba\x5b\x82\x7f\xf3\xff"
          "\xfc\x63\x89\x86\xc3\x73\xb2\xce\x26\x31\x82\xcb\x6f\xca\x29\xdc\xf0\xc3\x7a\xa7\x85\xae"
          "\x17\xc6\xbb\xbe\x4a\x13\x5c\xbc\x27\x4d\x24\xa8\x7a\x7f\x5e\x3e\x20\x59\xc9\x14\x4a\xd1"
          "\xcb\x51\x69\x6e\xa0\xce\x48\x0d\x13\xa8\x09\x62\xe9\xe9\x02\xac\xd3\x8a\x63\x43\x81\x8a"
          "\x57\x0d\x76\xdc\x1e\xa4\xb5\x2b\x25\xb9\x8f\xda\xfc\x58\xbf\x9f\x1a\x23\x51\xd7\xcc\xb9"
          "\x0f\xc1\x2b\x11\x3a\xf6\x50\x1a\x27\xcc\xdf\xb9\xa6\xd8\x53\xac\x6c\x7c\x7e\xaf\x21\x3d"
          "\xc5\x76\x80\x13\x51\x84\x2c\x0a\xe4\x0c\x7c\x5b\x76\x5f\x74\x4e\x80\xd3\x49\x74\xc1\x92"
          "\xd7\x97\x0e\xf3\x69\x51\x37\x89\x92\xab\x18\x0f\x9a\x33\xa9\x2c\x83\x01\xd9\xaa\xd5\x93"
          "\x98\x78\x67\x19\xf1\x92\x2b\x62\x17\x15\x97\x93\x71\xe7\x9b\xd1\x81\x9b\xd5\x14\x65\x65"
          "\xa9\xbd\x10\x2f\xf2\x86\x56\xc7\x44\x62\x58\x01\xae\x85\x43\x3f\x7e\x24\x30\x5f\x50\x84"
          "\x8e\x18\xef\x26\x08\x57\xe4\xce\xb6\x20\xc9\x4e\x3c\xf6\x82\x9e\x23\x64\x1b\x70\xf6\x60"
          "\x48\x35\x92\xf1\xf5\xf9\xfc\x2d",
          "\xcf\x2a\x13\x5c\x6e\x04\xc6\x3e\xf4\x40\x1a\xc5\xff\xf1\x8c\xdb\xd4\xfa\xaf\x2f\x49\x78"
          "\x3e\x91\xf8\x00\xbd\xb7\x16\xaf\x5d\xd9\x14\x23\xbc\xed\x32\x4d\x6e\x48\x74\x2f\xde\x01"
          "\xae\xee\xd6\xd2\x87\x02\x76\x1d\xe1\x02\x75\x75\xc2\x9c\xc8\x8f\xfb\x36\x67\x1a\x46\x59"
          "\xf0\x64\x82\xa7\x71\x4a\x5a\xf5\xdb\x27\x17\x3d\xce\xe3\x96\x38\xeb\x13\x8c\x32\x49\x18"
          "\xa7\x88\xb2\x67\x4d\xeb\xda\x22\xa1\x00\xe8\x4d\x91\xb7\xa6\xfa\x60\x6c\x20\x3e\x60\x4b"
          "\xb5\xe0\x36\x6d\xe7\x54\xe0\x41\xfc\xd6\xcf\x4e\x2f\x59\x2a\xb0\x11\x92\xb5\xb2\xea\x20"
          "\x1a\xbd\x4d\x0d\xe0\xdd\x21\xb3\x81\x14\xc0\xea\xcb\x48\xbb\xf3\x37\xc2\x2a\xfe\xeb\xe1"
          "\xdf\x65\xec\x12\x53\xfd\x4c\x8a\xae\xf3\x64\x52\x41\xe8\xf0\x19\xbb\x5e\x05\x76\xf5\x36"
          "\x9c\x52\x87\xd8\xa6\x2b\xa1\xaa\x92\xa8\x22\xb6\xf4\xf3\x7a\xf5\x54\x72\xf5\x38\x37\xf5"
          "\x8f\x8a\xe2\x97\x25\xe2\xbc\x6f\xdb\xfc\x51\x7a\x1c\xbe\x6d\xe1\x69\x3a\xe3\x97\x50\xa8"
          "\x10\xbf\x20\xf9\x83\xc5\x66\x22\x19\x21\x62\x78\x9f\xbd\x0d\xa9\xc9\x19\xd1\x29\x92\xb9"
          "\xd1\x18\x35\x6d\x19\xa4\x8b\xba\x2d\x8c\xd8\x59\xfe\xc0\xe1\x58\x04\x4c\x84\x04\x22\x2d"
          "\xdf\x0b\x6d\x88\x8b\x1d\x35\xb0\x0e\x32\x0a\x71\xa2\x77\x34\xd2\xd5\xa1\xcb\xd1\x98\x69"
          "\x3b\x29\xae\x23\x4a\x26\x45\x07\xf7\x82\xea\x10\xa6\x34\x9a\xea\x8c\xcd\x87\xef\x46\xdd"
          "\xf3\xd3\x99\x72\x43\x34\xbf\xfb\xa7\x7c\xc5\x42\x63\x77\x55\x35\x9d\x13\x6b\x95\xad\xaa"
          "\x07\x1b\x85\x31\x3a\x5a\xd8\x09\xf9\xbc\x6d\x1b\x28\x9c\x01\x49\x40\x02\xd6\x8e\xd8\x72"
          "\x22\x27\xa2\x18\x38\x10\x72\xc9\x24\xaf\x8e\x8a\xfc\x89\x21\xcb\xd8\xeb\x26\xcf\x5e\xae"
          "\x36\xee\xec\x25\x02\x3f\x82\x6a\x3d\x63\x03\x37\x8a\x60\x5a\x3f\xfb\xa2\x5d\x9b\xc6\x81"
          "\x53\x6b\x89\x34\x73\xb9\x34\x2b\x7d\xd9\x6b\xea\x2f\xe7\xb1\xe8\x2f\x38\xf8\xb5\x9f\x22"
          "\xa1\x97\xeb\x71\x42\xa6\xb0\xe0\x2b\x54\x35\x4b\x0a\x6d\x2f\x2f\x6f\xf5\xe5\x1e\x7a\x19"
          "\x4b\xe8\xb3\x75\xde\xf5\xec\x6e",
          1, 3584 },
        { 128, 128, 29, "\x17\x7e\x57\xe9\x13\x61\x2d\x30\xed\x21\xc8\xbb\xc9\xa8\xb0\x18",
          "\x30\x4c\x8e\x65\x98\xe4\x9b\x70\xe7\xb6\xf6\x04\x25\x36\x9d\x92",
          "\x0d\xee\x26\x45\xfc\xd0\x43\x79\x24\x27\xe2\xd7\x47\xb5\x2e\x77\x1a\x13\xf0\x5c\xc2\xca"
          "\xc8\xef\x86\xef\xad\x13\x08\x65\x70\xcb\x76\xec\x91\xc7\x3e\x11\x83\x01\x65\x57\x1b\x2f"
          "\x74\xab\xc5\x13\xbd\xcb\x2f\x1a\x74\x2a\x56\x2f\xeb\x24\x2c\x08\xc9\xa3\x03\xfa\x04\x02"
          "\xf2\xe9\xa8\xcf\x80\x74\x43\xdf\x93\x98\x00\xb4\x7e\xa2\x3c\x95\xba\x0e\x37\xc8\xd6\x04"
          "\xa1\x47\xce\xa3\x8f\xeb\x23\x28\x13\xb5\x93\xdf\x5c\xba\x91\xac\x8c\xfc\x26\xb9\xe2\x7b"
          "\x87\x38\x2e\x3e\xd1\x30\xae\x1e\xe7\x51\x18\xe5\x3f\x05\x64\x9c\xcc\x34\x70\xb7\xd6\x75"
          "\x51\x44\x57\x94\x1d\xa3\x2c\x07\x2a\x8a\x9b\x00\x8b\x92\x0a\x31\x59\x47\x6d\x4c\x21\x3e"
          "\x22\x55\x23\x7c\x1d\x20\x2b\x5e\x9b\xb2\x8d\x59\xea\xdf\x24\x84\xcf\x1c\x75\x29\xde\x07"
          "\x91\x81\x27\x7f\x7e\xa4\xe7\x35\x12\x0d\xd8\xb9\xe2\xef\xaa\x0a\xdb\x0e\x24\xa0\x9c\x24"
          "\xa4\x9b\x8f\x4f\x96\x66\x4a\x8f\x9c\x7c\xec\x18\xad\xa2\x07\x43\x48\x66\xe0\x3e\x5a\x78"
          "\xb1\x01\x63\x37\x87\xb1\xea\x28\xca\xe1\xa8\x22\xd3\x8e\xd6\x63\x14\xa7\xd8\x84\x1c\x29"
          "\xcf\x71\xfd\x74\x75\x90\x3b\xe5\xb1\xd0\x0f\xb6\x59\x7d\x10\xbe\x61\x6c\x53\xbf\x4e\xc2"
          "\x0f\x66\x8e\x8d\x04\x02\xac\x8d\xa1\xa6\x33\x16\x4c\x3c\x65\xe7\x22\x02\x44\x08\x1d\xf6"
          "\x22\x00\x43\xcc\x67\xce\x33\x88\xc4\x3a\x83\x32\xe2\xa8\xc3\xd6\x57\xd9\x96\x65\x3c\xf3"
          "\xf4\x72\x5e\x90\xa0\xa9\xfa\xde\x4a\x4e\x75\xdb\xc9\x33\x93\xfa\x98\x48\x1b\x78\x71\xc6"
          "\x9a\x4a\x87\xf7\xe9\x36\xa9\xdc\x66\x91\xdd\xab\xab\x32\x86\x2d\xf6\x24\xf3\xde\xb5\x34"
          "\xed\x6d\x55\x55\x76\x2d\x09\xf3\x94\xaf\xff\x53\x6c\x65\x4d\x01\xf6\x54\x33\xdd\xf6\x43"
          "\x24\xe4\x0d\xee\x7d\x0e\xaa\xe1\x99\x84\x16\xf4\xed\x94\x5b\xad\x8b\x4b\x35\x67\x6a\xe3"
          "\x20\x56\xaf\x35\xa0\x30\x2f\x77\x72\x59\x6b\xa8\x7a\x5d\x64\x47\x95\x07\x96\xdf\x7c\x80"
          "\xda\x51\x5a\xd7\x80\x7c\x7b\x1e\x4f\x98\x94\x06\xd3\x1a\x27\xa3\x93\xbd\x22\x00\xe3\xcd"
          "\x40\x4b\xfe\xf8\xad\x37\xc3\xa7\x60\x2d\x24\x82\x2e\xd5\xae\xb7\x94\xbd\xb6\xee\x9d\xcd"
          "\xdb\x7d",
          "\x8b\x59\xe7\x25\xb5\xcd\xfb\x74\xaa\x3f\x48\x7c\xa7\xde\x51\xdc\xbd\x4d\xa4\x53\x3e\xca"
          "\x05\xbf\xa6\x66\x41\xc4\x44\x8d\x35\x04\x56\x34\x7e\x51\x27\x7f\x29\xc1\xf8\x78\xb6\x37"
          "\x4e\xfe\x43\x36\x12\x06\xd7\x77\x66\x4d\xde\x2e\xd4\x2d\x59\x87\xd1\xb0\xac\xab\x2a\xfe"
          "\xfa\x9c\x30\xdd\x5f\x68\x5d\x46\x96\xbc\x8e\x3e\x2d\x4c\xe8\x93\x03\x4d\x7a\x2a\x8b\x63"
          "\xcf\x3d\x0a\x6d\x80\x47\x56\xd5\x66\xca\x68\x64\xfa\x51\x69\xe8\x4a\x76\x08\x11\x94\x5a"
          "\x01\x9f\xad\xd8\xf7\x53\x1b\x51\x5d\x03\xa8\xf5\xea\x9f\x31\x2c\xab\x7b\x8e\x3f\x68\x3e"
          "\x8b\x53\xea\x8b\x68\xd2\x75\x15\x0b\xa9\xc0\xa1\x85\x87\x40\x48\xde\x1d\xba\xae\x92\xb3"
          "\xee\x94\x9f\x2d\xaf\x06\xae\xc4\x10\x70\xf3\xa1\x52\xa2\xc2\x19\xe6\xce\x88\x3b\x3a\x5e"
          "\x59\x2c\x2b\x7e\x19\xf5\x95\xf3\x21\xaf\x61\x49\xa9\x0a\x58\x37\x3b\x9d\x4b\x7a\x32\x1f"
          "\x2e\x41\x1b\xc9\xad\x0e\xdf\x05\x6e\xc5\x3d\xe1\x98\x26\xae\x5f\x37\x25\xac\xc0\x7b\xbf"
          "\xd0\xa6\x56\x3d\x95\xcf\xf0\xa5\x03\x14\x51\x84\xf0\xa2\xa4\x30\x91\xd2\xfd\x11\xb1\x6c"
          "\x55\x3f\x76\x5a\x3b\xda\x88\x3d\x61\xe7\x4e\x5a\x55\xd8\x66\x26\xd4\x82\xf1\x01\x63\x87"
          "\x14\x8b\x3d\xbf\xdc\xaa\x4b\xca\x2a\x8e\xd1\x7b\x9b\x96\xda\x85\xeb\xb3\xe0\x3e\xb3\x9e"
          "\xc5\x09\x80\x84\xd2\x29\xd4\xad\xb4\xb2\x53\x1d\x71\x9b\x6b\xa3\x75\x7a\x6b\x5f\x9d\x54"
          "\x8e\xa4\x28\x2b\x9f\xb7\xdd\x80\xbb\x78\xa2\xc9\xe2\xaa\xbb\x19\x40\xce\xb4\x3b\x92\xb5"
          "\x4b\x28\x8c\x59\x54\xc7\xd5\x9c\x88\x20\x30\x33\x07\xaa\xdd\x2a\xca\xbe\x03\x89\xce\xdc"
          "\xcc\x4b\xa3\x5a\x7d\x41\xc2\x45\x07\x8c\xb8\x7a\xbc\x31\x9c\x47\xdd\x8f\xc4\xd3\x43\x15"
          "\x33\x6a\x30\x7a\x8a\x17\xdf\xcb\x5f\x16\xb3\x5b\x21\xf7\x3c\x96\x6c\xaf\xd4\xf1\xcf\x47"
          "\xad\x00\xac\xa3\x8b\x66\x83\x6a\xd9\xe1\xe8\x5b\xbc\x03\x08\x27\xdb\x58\x18\x94\x8b\x94"
          "\x62\x95\x44\x05\x31\xc8\xac\x12\xec\x8e\x16\x78\x6b\x32\xef\x72\x13\x8c\x34\xa1\xb4\x9b"
          "\xbe\xc8\x19\x73\xaf\x39\xfc\x9b\x31\x7f\x9a\x35\x26\x8a\x1e\x54\x03\x34\x00\xe0\xa5\x55"
          "\x7b\x30",
          1, 3712 },
        { 128, 128, 30, "\xdd\x1f\xa1\x9d\x62\x56\xf7\x16\xf3\x18\x89\x55\xce\x5b\xc6\x70",
          "\xc8\x0b\x82\xd5\x32\xce\x2a\x88\x3d\x4d\x08\x66\xd6\xc3\x26\x9c",
          "\x28\x62\xa1\x02\xbd\x54\xe0\x2b\x88\x00\x38\x35\xe3\x3d\x1d\x38\x5c\x61\xf1\xd9\x7b\x09"
          "\x9d\x53\xef\x02\x88\xb4\x85\x35\x4f\x21\xe4\x1c\x5f\xba\x05\x48\x92\x1a\xb6\x9e\x95\x1d"
          "\x08\x60\x55\x8a\x53\x34\xc3\x88\x9b\xb4\xe3\x63\xbf\xdd\xd6\x44\x73\x4f\x8b\xc7\xfb\x5e"
          "\x1b\x75\x0e\xba\x3a\xd8\x61\xaa\x59\x96\x16\x02\x34\x5b\xea\x78\xda\x9c\xe4\x50\x45\x98"
          "\x1e\x4e\xdb\x79\xeb\x52\x39\x89\x94\xcf\xfa\x4e\xfc\x2d\x75\xff\x27\xb8\x24\x53\xd2\x25"
          "\xb0\xd0\xff\x60\x5a\x8d\xd4\x0d\xb1\x30\xf6\x82\xa4\xf4\xb6\x60\xc1\x9c\x24\xa4\x4f\x65"
          "\xc8\x35\x48\x84\xb7\x5a\xe1\x5e\x2d\xa9\xc6\x02\x13\x41\x49\xe3\x94\x83\x76\xa4\xd5\x91"
          "\x57\xfb\xe1\xb9\x5b\xca\xb5\xbf\x88\xa1\xd0\x67\x32\x2a\xca\xd1\xc2\xc6\xd3\xf8\xc0\xd3"
          "\x69\x9b\x65\xc7\xa5\x35\xf5\xcb\xd8\xf3\x3a\x0b\xae\x9b\xd1\x5f\x6e\xee\xda\xfc\x78\xa7"
          "\x6c\xac\x01\xbd\x58\xd9\x6e\x05\x04\xc9\x8e\x47\x39\x38\x92\x63\x8e\x00\xed\xb5\x21\x61"
          "\xc1\xf0\xee\x5f\xfd\x27\xd4\x4d\x3a\xc5\xcc\x70\x21\x08\x00\x6a\x78\x10\x64\xa9\x10\x5a"
          "\x77\x4c\xf2\x2f\xe0\x60\xa3\xf4\xbd\x43\xde\xf0\xf4\x9e\xa7\x1d\x5d\x96\x36\xda\x35\x05"
          "\x84\x3a\x37\x09\xf0\x7b\x16\x01\xf1\x71\xfd\x9c\x89\x79\x7e\x17\xc5\xfc\xeb\x08\xe1\xaa"
          "\x18\x44\xc9\x9e\xf5\x74\x5f\x1f\x7b\xa1\x36\x86\x34\x13\xd3\x4b\x1c\x7a\x69\xb4\x5b\x1a"
          "\x9d\xda\x1e\x6f\x79\xcd\xab\x77\x1c\x32\x2e\x30\x1b\x3a\xa4\xf8\xb6\x7f\xaa\x8c\x7e\xdf"
          "\xda\xf8\xc9\xaf\x2a\x96\x91\xb1\xff\x62\x9c\x4c\x77\x4d\x8b\xdc\x2c\xf7\x3f\xfd\xea\x36"
          "\x3d\x18\xaa\xb2\xa1\x38\x34\x28\x60\xdb\x52\x50\x79\xaa\x34\x23\x44\x15\x31\x58\xb1\x4e"
          "\x5c\x25\x76\x98\xd6\x52\x1c\x14\xed\x13\xdb\x0d\x6b\x10\x3d\x07\xdc\x5f\xbc\xf8\x7c\x20"
          "\xc8\x0f\x1b\x3b\x06\x58\x88\x91\x3e\x61\xa0\x24\x0c\x18\x60\x9e\x44\x37\x4d\x61\x55\xdc"
          "\x0f\x18\xbc\x1c\xd3\xa4\x68\x41\x6b\x69\x9c\x79\xf2\xd3\xbb\xbf\x83\x52\xb2\xd4\xec\xec"
          "\xa3\x31\xd5\xb1\x21\xaa\x2b\x61\xaa\x96\xa5\xa9\x87\x86\x8e\xcb\x46\xc0\x96\xff\x3e\x50"
          "\x62\x74\x90\xb4\x21\xb4\xcd\x06\x6e\xac\x65\x58\x77\xcc\x90\x54\x32\xb8",
          "\x63\x44\xd7\x3b\xd5\xe7\x51\xc0\x58\x40\x0e\x86\x9a\x96\x78\xfe\xe6\xc3\x2f\xb0\xf4\x70"
          "\x2f\x83\x06\xd3\x76\x8f\xe2\xa5\x0c\xbb\xeb\x43\x29\xb8\x13\xac\x09\xc8\x94\x3c\x6c\x48"
          "\x14\x36\xb0\x4a\x9d\xce\x20\x90\x6e\x47\x00\x2d\x3b\xae\x36\x46\x4a\x90\xd0\x65\xaf\x33"
          "\x98\xbb\xde\xda\x94\x87\x43\x2d\x67\xfd\x89\xee\x5c\xf1\x51\x1e\x8c\x6f\x0b\x60\xe9\x30"
          "\x2d\x2c\x16\x5c\xc0\x8e\x1b\xc7\xfa\xeb\x1e\xba\xf6\x6d\xed\x35\x51\xb3\x8a\x33\x1b\xff"
          "\x82\xce\x7c\xe6\x89\x5b\x2a\x14\x3d\x07\xeb\x60\x65\x7b\x73\x80\xba\x26\xbb\xde\xf2\x6c"
          "\x29\xb5\x96\xae\x7b\x42\x73\xd9\x63\x55\xc2\x06\x30\x83\xf8\xf4\x62\x78\xcf\x29\x6a\x3a"
          "\xdf\xb3\x2d\x38\xe9\xf8\xdc\x8c\xbd\xd9\xca\xe3\xda\x6c\xb0\x4b\x54\xba\x70\xa0\x65\xf8"
          "\xf4\x11\x87\xeb\x4d\x38\xda\x08\x6f\x7b\xd7\xce\x9c\xcd\xf3\x12\x7e\xa3\x9b\xb4\x79\x52"
          "\x17\x01\x4c\x57\x1c\x19\x02\x32\x1b\x1b\xde\x33\xd4\x2e\x0c\xc1\xa3\xa5\x0f\xea\xc2\x03"
          "\x96\x60\xa4\xd6\x95\x74\x0a\x60\x06\x4d\x2e\x98\x5e\x87\x26\x4c\x22\x06\x5d\xd5\x63\xef"
          "\x02\xbc\x81\x74\xe5\xd6\x62\x73\x19\x65\x6b\x93\x0b\x5a\x0e\x57\xa7\x91\x3c\x20\x08\xda"
          "\x13\xd8\x2b\x22\xe3\x09\xcb\x02\xc3\xce\x15\xdd\x83\xf7\xaf\x1c\xc2\xb7\x85\x7e\x25\xd3"
          "\x78\x87\x70\x9f\xfd\xf9\x26\xd4\x38\xf0\xc2\x21\xc2\x1d\x7a\x69\x29\xc4\x71\x23\xcf\x11"
          "\xd1\xa4\x5f\xdf\x73\xc4\x18\x10\xc9\x50\x86\x23\x04\xf4\xdf\x4a\x2a\x57\x4d\xcc\x64\x4c"
          "\x2c\x04\x82\x47\x4e\x17\x50\x49\xb4\x1e\x1d\x1e\xc9\x7a\xf1\x81\x2f\x9c\x71\xe8\xf9\x20"
          "\x3b\xc4\xa4\x33\x95\xd5\xa4\x1b\xa9\xc1\x2f\xd2\x91\xa7\x8e\xf1\x03\xfe\xe2\x68\x41\xe5"
          "\x52\xef\xba\xcc\x65\x76\x3a\x8a\x4e\xe6\x98\x6f\xa7\x11\xdf\x2d\x32\x91\x76\xe7\x5d\x40"
          "\x33\x50\xe6\x8f\x8f\x32\x98\x52\x8b\xd5\xda\xa4\x99\xf2\x47\x40\xe9\xb0\xb4\xc1\xb8\x70"
          "\x08\x77\xd6\xc3\xd4\x34\x84\x10\xf5\x07\xc3\x28\x1c\xe7\x63\x78\x27\xb1\x1f\xb3\xed\xd2"
          "\x61\xd3\x19\x8c\x72\xf6\x85\xa6\xa8\xf3\xbc\x17\x6f\xcf\xbb\xeb\xfb\x7f\x6e\xa9\x7f\xb6"
          "\xf2\xcf\x92\x2e\xb6\x66\x84\xf9\xec\xdf\x62\x12\x5f\xb3\xc6\xab\x1a\xbd",
          1, 3840 },
        { 128, 128, 31, "\xc2\x82\xb6\x06\x31\x85\xa6\x16\x80\x72\x46\x1a\x35\xa6\x3d\x61",
          "\xf1\x16\x0f\x53\x26\xa1\x25\x1b\x6b\x2f\xf0\x85\x21\x55\xd3\x35",
          "\xc7\x44\x23\x87\x35\x67\xc2\x2f\x09\xed\xc2\x43\x94\x29\x79\x7e\xaf\x90\xc6\xc1\x8a\xc4"
          "\xa4\x19\x66\xbb\x2c\x8f\x2b\x98\x47\xa5\x73\x00\x9f\x11\x44\x38\xe5\x8e\x17\xb3\xc6\xca"
          "\x6f\x14\xf3\x1d\x5d\xcc\xb4\x0c\xde\x8a\xf9\x65\x57\x3b\xe9\x7b\x72\x4b\x28\x5b\x99\xf0"
          "\xb4\x14\xa7\x04\x0b\xf2\x8a\x58\x3b\x17\x99\x92\x0f\x1c\x57\x0a\xd5\x92\x47\xa0\xa6\xc6"
          "\x6e\x68\xad\x92\x34\x94\x75\x1c\x73\xa9\x8a\x21\xa1\x7c\xca\x9c\xfa\xfe\x8d\x6f\x8e\x0d"
          "\xb2\x65\x5d\xd5\xc8\xb3\x37\x6a\xa9\xde\x4e\xfe\xaf\x20\x45\x92\xa0\x34\x53\x62\x6e\x8a"
          "\x92\x7a\x70\x9d\xe7\xe3\x30\x9f\xca\xe3\xf4\x0e\xf9\x52\xb2\xf8\x75\x13\x85\x6a\xad\x6b"
          "\x70\xcf\xc6\xc8\xc9\xab\x5f\x3d\x8f\xa4\xa2\x48\x5b\xe8\xd2\x4f\x1e\x67\xbd\x46\x10\xdf"
          "\xa4\x19\x38\xf4\xe6\x86\x2a\xd7\x07\xfe\x63\x8d\xfe\x52\x42\x3a\xd5\x7f\x84\x8d\xef\x62"
          "\x68\xc2\xee\x80\x2c\x4c\xd3\x76\xfd\xde\x06\x68\xb3\xbf\x09\x3a\x79\xf3\x56\xcb\xe9\x50"
          "\xc6\x0a\x65\x96\xf4\xec\xc9\x48\xec\x1b\x66\x1c\x25\x9b\xd5\x61\x51\x28\x96\xfb\x28\x73"
          "\xf2\x1f\xb8\xd8\xef\x50\x07\xd2\x25\x28\xc2\x6a\x3a\xd7\xc7\x4a\x8b\xfd\xfb\xbe\xdf\x74"
          "\xb6\x1a\x1a\x1c\x45\x48\x12\xbf\xd1\xdb\x41\x25\x18\xda\xf9\x01\x17\x20\x36\x0c\x74\x11"
          "\x08\x99\x37\x97\x8c\x00\x1a\x73\x75\xca\x62\x64\x80\xfd\xac\xb3\x06\xbe\x8a\xbb\x20\x81"
          "\xa9\x2a\xe9\xac\x9c\xfa\x97\x67\x60\x10\x83\xbd\x19\xcc\x62\x7f\xbd\x8f\x42\x18\xc5\xdd"
          "\x31\x27\x20\x6e\xf4\x5b\x89\xd2\x9d\x19\x17\x3b\x2f\x90\x03\xc3\xa2\xcf\x01\x3c\x69\x9b"
          "\xa6\xd8\x81\x52\x3f\x71\x38\x59\x3b\xab\x8f\xa0\xef\x74\xe4\x45\x82\xaa\x9b\xc6\x88\x20"
          "\xe9\xc2\x13\xbd\x95\x80\xb5\xd6\x85\x13\x75\x95\x62\x2c\x4f\xe1\xb7\x2e\x3d\xe6\x72\x71"
          "\x5e\x2f\x83\x85\xae\xb5\x8a\x38\xb7\x9f\x77\x01\x38\xf2\x80\x4b\x1d\xb1\x86\x02\x82\xc4"
          "\x04\x9a\xfa\x44\x58\xe6\x9c\x88\xd2\x79\xec\x12\x0e\x87\x0f\x31\x84\x4c\x3c\x5a\x0b\xed"
          "\x8d\xd7\x1a\xbc\x8b\x7f\x22\x57\xc2\x72\x78\xf6\x41\x2b\x46\x74\xde\x00\x37\xea\x2c\xc9"
          "\x53\x95\x0e\xbd\x2b\x93\xd9\x57\xc3\x70\xa6\x80\xaa\xeb\x48\xd0\x26\x8e\x6a\xdc\xcf\x80"
          "\x08\xb5\xb7\x35\x72\x70\xa1\xa4\x4d\x45\xf3\x24",
          "\xa9\xbc\x39\xb1\x42\x8d\xc4\x82\x8e\x1d\x0d\xd3\xc1\xaa\xcb\xbd\x70\xaf\xf1\x70\x05\x21"
          "\x0d\xcc\xa3\x26\xc0\xc3\x26\x5d\xad\x4e\xa8\xe3\xfd\xf0\x20\x86\xf8\xd7\x05\xf8\xa3\xe6"
          "\xcf\xa8\xf4\x13\x29\x43\x02\x2c\x65\x91\xb6\x6b\x2f\xd5\x67\x6f\x3b\xb8\x22\x19\x2d\x9a"
          "\xe7\xe4\xaf\x97\x50\x20\x6c\x8f\xc3\xb4\xe8\xb5\xa4\x9d\x5d\x74\x6e\x65\x54\xaa\xd9\x49"
          "\xc8\x8b\x8f\x8f\xa7\xea\x2d\x03\x40\x96\x50\xe6\x9b\x89\x76\xc4\x0f\xcf\x81\x38\xa7\x79"
          "\xcd\x4d\xbe\x5a\x95\x11\xdd\x31\xad\x4e\x51\x36\xe9\x55\xd0\x02\xf0\x50\x25\xff\x45\x68"
          "\xd1\xb4\x77\x56\x92\xa4\xa3\x0e\x97\x64\xef\x30\xe9\x4b\x19\xe8\x59\x36\x22\x27\xdb\x87"
          "\x47\x14\xa3\x50\x91\xf1\x2e\x56\x7b\x91\x73\xc3\x42\x0f\x66\x84\x5f\x98\x48\xbb\xae\x89"
          "\xc0\x05\x92\x12\x43\xca\xc6\x94\xe0\xc5\xf4\xb9\x26\xfd\x5b\xd6\x2b\x33\x60\xa1\xba\x8c"
          "\x0b\x4a\x45\xd4\x87\xf7\xd1\xcd\x32\x38\x59\x6a\x76\x26\x6f\xba\x3c\x3d\xa9\x29\x13\x6d"
          "\xe6\xc8\x44\xed\x9f\xe4\x76\x16\xf4\xb4\xbe\xff\x2c\x46\x55\xf0\x86\x87\x91\x2a\xf4\x2f"
          "\x48\xe9\xba\xc8\x71\x13\x68\x5e\x89\x10\x40\xec\x93\x38\xcf\xb2\xe2\x51\x15\x3a\x08\xaf"
          "\xde\x55\x3c\x7a\xf4\xed\x2b\x7b\xc8\x0c\x28\xe2\xf7\xa7\x96\x89\xd7\x28\x8c\x76\xef\xbe"
          "\x6c\x2b\x21\xb3\x15\x1f\x80\x77\xba\x94\x30\xca\xca\x8c\xec\xce\x79\x93\x98\x93\x19\x24"
          "\xf3\x57\x6c\xfc\x86\x32\x8f\x9b\x68\xc6\x2a\xb0\x6a\xa6\x02\x9a\xfe\x2b\xdc\x2c\xa4\x82"
          "\xba\x35\xf5\xcd\xa8\x2c\xb4\xf0\xad\x7d\x59\x5c\xd2\x5c\x2a\x08\xf4\x02\x12\x80\xb9\xfc"
          "\xe5\x35\xfc\x33\x6b\x8e\x22\xcd\xca\x76\x04\x9e\x4c\x4e\x52\x30\xfc\x43\xd8\x7b\xdf\xdc"
          "\x28\xf7\xb0\xa8\x9f\x54\x85\x01\x96\xbe\x74\x06\x7f\xe5\x50\xec\x13\x39\x2a\xe4\x28\xc0"
          "\x4c\xf4\x53\x18\x80\x08\xeb\x45\x3c\x82\xa0\xf8\xf2\x7c\x8e\x31\x04\xc4\x30\xca\x6a\x54"
          "\xbf\xeb\x2e\xd6\xb4\x31\x64\x9a\xc7\x62\xf7\xed\xba\xf7\xff\x8f\xe2\xef\xa7\xf5\x4b\x8b"
          "\xd3\xa4\x2d\x6c\x22\x17\x80\x29\x49\x2c\xff\x6b\x39\x80\x04\xf6\xd6\xbc\x6c\x86\xb3\x1c"
          "\x31\x3c\x22\xe5\xe3\xa7\xdb\x17\x1a\x90\x23\xdd\x37\xd3\x3b\x6b\x6d\xe9\xb3\xc6\xf5\x92"
          "\x7e\x43\xdc\xdc\x23\x55\x25\xcb\x04\x81\x40\x2c",
          1, 3968 },
        { 128, 192, 32,
          "\x71\xb8\x95\x3a\x00\xba\x68\x83\x03\xdb\x74\xf5\xef\xea\x6d\x95\xea\x0e\x75\x1a\xa9\x2b"
          "\x1d\xe6",
          "\x37\xdc\xbd\x37\x25\x2c\xe8\x28\x19\xc9\xb0\x51\x1b\x6e\x18\x86",
          "\x12\x58\x67\x1d\x6f\x88\x4a\xcc\x78\x54\x93\x95\x48\x06\xca\xd6",
          "\xde\x3d\x1f\x00\x14\x59\xbb\xb3\x97\x68\x33\xe8\x56\x94\xc8\x8c", 1, 128 },
        { 128, 192, 33,
          "\x5a\x63\xad\x1b\x55\xe4\x5d\xc9\x0e\x6a\x4b\xda\xa4\xb2\x16\x2d\xd2\xb3\x5b\x68\x1a\xb9"
          "\x27\x4f",
          "\xdb\xf5\xc0\xd7\xd8\x4d\x78\xc4\xa4\x5b\x25\x76\x7c\x96\x7d\x56",
          "\xf4\xe3\x02\x38\x01\x5e\xa2\x2b\xe6\xe0\x1d\x9f\x01\x09\xf3\xc5\x78\xac\xd5\x06\x08\x46"
          "\xb2\x95\x2c\x7a\xf6\xde\xe1\x85\x15\xb7",
          "\x16\x4f\x99\x76\xda\x02\x0f\xee\x7a\xce\xb6\x54\x08\xb7\x3f\x3b\x22\x64\x88\x63\xcb\x3c"
          "\x1a\x55\xc7\x31\x50\x76\x82\xff\xcf\x62",
          1, 256 },
        { 128, 192, 34,
          "\xb2\x96\xb7\xcd\x8c\x3d\x0a\x41\x66\x67\x13\xce\x36\x0c\xfd\x99\x0e\x6e\x9b\xfb\x65\x67"
          "\x62\xce",
          "\xb4\xc0\xb8\x1f\xcc\x97\x14\xc8\x57\xf6\x38\x4e\x67\x37\xb7\xbc",
          "\x2b\x91\x1a\x3a\xbe\xc3\x96\xaa\x98\xe5\xb7\x01\x6a\x79\xc1\xc3\xe4\x30\x50\x55\xaf\x93"
          "\xf9\x4f\x63\x84\x14\x8e\xc4\x89\x73\xcf\x94\x16\x9c\x42\xe2\x08\xce\x31\xb7\xf3\xb8\x78"
          "\x45\x5a\x65\x25",
          "\x19\xd5\x09\x38\x5e\xd8\x5c\x56\x0a\x63\x97\xde\xb4\x62\x41\xd9\xb5\xb7\xf0\xf7\x16\xa2"
          "\x83\xc9\x9b\x0e\xbb\x73\x1a\xe5\x1e\x3d\x27\xc1\x74\x13\x68\x65\x8d\x9b\xd2\xae\xce\x9a"
          "\x40\xd5\x78\x7a",
          1, 384 },
        { 128, 192, 35,
          "\x54\xec\xfa\x33\x42\x5e\x0d\x91\xe9\x9b\x11\x15\x97\x1b\x5c\x0f\x05\x7c\x29\x82\x55\x45"
          "\x9b\x08",
          "\xc8\x30\xd0\x2a\xa2\x6c\x34\x61\x1d\x66\x41\xb0\xb7\xe9\xd9\x84",
          "\xc1\x4e\x56\xef\x62\x68\x92\x32\xc8\x2a\xfa\x86\x4a\xeb\xc2\x49\xc8\xba\xcd\x50\x45\x65"
          "\x31\x85\x85\xc0\x2d\x3c\xae\x05\x4b\x4b\x36\xd1\x62\xb3\xc6\x3b\x39\xc3\x1c\x29\x24\xe2"
          "\x94\xd1\xd1\xe3\x48\x8c\x0c\xd2\xc8\x1f\x8c\x24\xf1\xad\xe0\xa9\x42\x8c\xa1\x29",
          "\x5f\x41\xf8\x33\x06\x8c\x8a\x0c\x58\x9f\x97\xc1\x59\xf7\x38\x78\x9c\x1e\xe1\x78\xa2\xfc"
          "\x96\x5e\x5e\x1e\xc6\xec\x09\x5e\xd6\xd7\xe0\x3b\xd3\xb6\xc1\x67\x32\xd5\x35\xac\x3a\x1d"
          "\x5c\xe6\xb6\xc9\xd8\x3e\x9f\x88\xba\xae\x5a\x4d\xad\xd1\xe7\xd8\x33\x7d\xce\x9b",
          1, 512 },
        { 128, 192, 36,
          "\xc7\x90\xa2\x2f\x82\x42\xb9\xec\x5f\x37\xb6\x10\x11\x44\x48\xea\xe3\x42\xcd\xd8\x45\x81"
          "\x0f\x64",
          "\x5e\xaf\xb2\x3a\x9b\x60\x63\x00\x22\x9c\x0f\xe4\xcd\x66\xa7\xaa",
          "\xbc\xfb\x1a\x49\x0e\x58\xb8\xac\x3b\xa6\x2b\x2d\x09\x0b\x98\x1b\x33\x80\x3b\x5e\xa2\x74"
          "\x28\x4b\xd1\x8b\x93\xb7\xba\x5f\x14\x67\xa4\x1b\x4f\x12\x3e\x7b\x6d\x00\xd8\x3f\x52\x9e"
          "\x64\xde\xe3\xb9\x56\xcf\x6c\xc7\x1b\x37\xa8\x25\xb7\x6e\xda\x4b\x54\x26\x0c\x4f\x9f\x8a"
          "\x5c\x46\x92\x82\x69\xa6\xee\x3d\xc4\x34\x61\x4b\x33\x43",
          "\xfd\x08\x14\x97\xef\xb8\x40\xac\x9d\x0f\x86\xac\xfe\x69\x7d\x9c\xcc\x4d\xd1\x9e\x71\xde"
          "\x5f\x31\x3d\x2c\xd0\x3b\x86\x38\xdf\x5f\x53\x72\x4d\x39\xf8\xdd\x13\x81\x9c\x77\x64\x39"
          "\x98\x65\x47\x81\x58\x2c\x02\x36\xf8\x77\x91\xae\x95\x9a\x16\xf7\x51\x68\xe8\x7c\x96\xa9"
          "\xba\x4d\xa1\xc1\xe2\xc9\xbb\xe6\xf1\xa1\x81\x4d\x66\xef",
          1, 640 },
        { 128, 192, 37,
          "\xde\x93\x03\xcd\x52\xa1\x01\xd8\xc3\x7e\x1b\x63\x19\xf9\x32\x4d\x1b\x74\xa5\x3b\xea\x44"
          "\xda\x74",
          "\xc8\xc7\xf2\xcd\xf3\x20\x33\xa5\xfb\xa5\x3e\xa1\x34\x93\xff\x26",
          "\xe9\xa2\xba\x41\x3c\x59\x8d\x39\xab\x7f\x1b\x62\xb3\xdf\x7d\xe9\x01\x51\xa2\x54\x63\x8e"
          "\x08\x66\x26\x11\xb4\x77\xed\xde\xe1\x47\xb9\xd9\x4c\xba\xaf\xbb\x4c\x81\x55\xd2\xb3\x00"
          "\x4b\x32\x3c\xa4\x5d\x54\xe6\xdd\x7f\x76\x4a\xe2\x4c\xb7\x13\x4a\x46\xbe\x98\x9c\x33\xee"
          "\xa4\xa1\x8e\x6b\x84\x80\x84\xcb\xa0\xf7\x9f\x5c\xfd\x2d\x82\xe4\xc4\x51\xc4\x4b\x02\x86"
          "\x1b\xed\xf7\xca\xa9\x68\x6d\xe2",
          "\xe7\xe4\x36\x05\xa5\xcb\x66\x97\xef\x81\x92\x56\xf8\xdd\x1e\x8b\x21\x49\x9f\x18\x5b\xf6"
          "\x2d\x3d\xe5\xe6\xca\x0e\xae\x63\x44\xc4\xb0\x9b\xf7\xcb\x3d\xf9\x01\xf6\xcc\x94\x3b\x2d"
          "\xd5\x0e\xd0\x2e\xc3\x27\xb8\xec\x8b\x14\x0d\xfc\xa2\xbe\xdd\x22\x9f\x2b\xc5\x02\xa3\x7a"
          "\xb1\xcd\x61\x53\x3a\xde\xae\x86\xa0\xe3\xea\xbc\xe7\xf1\xd3\x55\x7a\x8a\x57\xd3\x5b\xee"
          "\x89\x4e\x35\x1b\xed\x6f\x51\x60",
          1, 768 },
        { 128, 192, 38,
          "\xed\xaf\xd4\x87\x06\x5f\x4f\x9a\x0a\xaa\xc3\xeb\x69\xd3\x1b\x46\x98\xe5\x81\x2c\x15\x4d"
          "\xa2\xff",
          "\x73\x3c\xb8\xbb\x47\xb3\x2b\x83\x3c\xf6\xc4\xd6\x5c\xca\xc5\x06",
          "\xaa\x51\x24\xf8\x4d\x09\xb0\x86\x0a\x87\x8b\x8c\xc7\x96\x26\xb8\xc9\xb0\x62\xcc\xa4\x1d"
          "\x20\x00\xa1\x97\x4a\x92\x3f\x9a\xe7\x10\x66\x27\xa5\x4b\xcb\x02\xa0\x77\xe5\x07\x18\xf9"
          "\xee\xe6\x84\x2e\x58\xb3\x03\xa3\xa6\x41\xb4\xda\xc7\x34\xbd\x5b\x88\x6b\xd5\xd8\x56\x83"
          "\x21\x46\x4a\xb5\xa0\xad\x7f\x7c\x72\x74\xbb\x9a\x3f\xef\xa0\x49\x85\x13\x48\xe9\x5e\xe4"
          "\x91\xc8\x85\x9d\xb4\x90\x94\x3c\x20\x27\x10\x1d\x61\xf6\x7a\xd6\x7c\x4b\x7d\xe9\xce\x46"
          "\x40\x5c",
          "\xc6\xd4\x23\x0b\x66\xdb\x53\xb5\x4b\xf4\xf9\x4c\x19\x56\x97\x91\x0e\x14\x11\x65\x48\x92"
          "\x2d\xc3\x07\x56\xbf\x43\x0b\xa8\x67\x0e\xb3\x2b\xf6\x14\xee\x8f\xc5\xaa\x70\x58\x24\xce"
          "\x6f\x43\x93\xce\xbd\x87\x2a\x94\x73\x9c\xcd\xb8\x21\xd6\x90\xf7\x7f\x57\x7d\x47\x3d\x3b"
          "\x1a\x37\xad\x62\x53\xd2\x7d\x1f\x83\x86\x90\x9d\x33\x8e\xd4\xa1\x47\x12\xc6\x44\x31\x2c"
          "\x1c\x8d\xb2\x14\x4b\xe4\x4b\x26\x59\xbb\x75\x14\x72\xe9\x92\x44\x92\xee\x21\x49\x41\x9b"
          "\xa8\x49",
          1, 896 },
        { 128, 192, 39,
          "\xec\xde\x8d\x56\x45\xec\xff\xe1\xff\x4f\xe4\x3a\x0b\x78\x91\x92\x23\x08\xdc\x9e\x5e\xbe"
          "\x79\xd9",
          "\x92\x00\x4a\x49\x7f\x6c\x14\x7e\xa9\x0f\xab\x83\xf4\x20\xbd\x08",
          "\x6a\xbb\xf4\xa7\x43\x9c\x6b\x57\x05\xd4\xc8\x45\xf1\xa6\xb3\x0d\x92\x0d\xb3\x1b\x10\x83"
          "\xce\x58\xce\xe6\x7e\xf1\x7b\xb5\x2f\xe2\x32\x80\xb3\x09\x79\x2d\x75\x57\x3d\x98\x65\x42"
          "\x8d\x15\x8d\xd3\x55\x2a\xfb\x97\xcb\x70\x2b\x39\xb4\x68\x6a\xac\x67\x3b\xd6\x11\xda\xe8"
          "\x8a\xc0\x22\x54\x55\x7d\xc8\x23\xf6\x4c\x3d\xa8\x23\x23\xf0\x23\xb0\x95\xee\x3f\x06\x4d"
          "\x86\x8e\x1f\x9d\x11\xcf\xb2\x0d\x5b\x4c\x5f\xc4\x29\x9b\x97\xad\xe7\xc6\xf0\xf5\x82\xf1"
          "\x35\x31\x63\x2e\xb5\xfa\x1e\xdd\x42\xd1\x03\x83\xdd\x60\xb4\x6b\xb5\x83",
          "\xd7\x5a\x24\xb9\xf6\x36\x28\xac\xc4\xe6\xb3\xa7\xa6\xfa\x77\x5c\x98\xcc\x9f\x59\xb0\x01"
          "\x84\x9f\x7e\xc8\x7c\x27\x3c\xb1\xef\xfe\xd0\x3e\x20\x4d\x60\xab\x35\xdb\xa2\x44\x65\x44"
          "\x00\xf3\x4d\xc7\x07\x82\xb8\xd7\xd5\xd2\xd3\xb7\x72\xc5\x17\xb6\x45\xab\x8a\x85\xcb\xd4"
          "\x22\xd4\xdd\xc5\xd4\x7a\xbc\x74\x3e\x3e\xe7\x2e\x95\x84\x12\xc9\x17\x4f\x2b\x81\x19\xae"
          "\xc8\x1f\x54\x39\x8c\x8e\xa6\x5b\x73\xe2\x21\x72\xab\x2f\xd9\xc8\xab\x00\xc4\x0a\x48\xb6"
          "\xa4\xcc\x08\xe0\x92\xca\x86\x04\xb2\xf9\xcc\x72\xad\xf6\xe1\x81\xfd\x1b",
          1, 1024 },
        { 128, 192, 40,
          "\xdc\x89\x73\xb5\x4a\xf2\x3a\xa6\xcc\x38\x0b\xa6\xb6\x3e\x83\xec\x26\xae\x2e\xa2\xcb\x1c"
          "\x70\x70",
          "\x24\x27\xbf\x76\x39\xaa\x3d\x45\x39\x54\xc1\x29\xd9\xdd\xe9\xa9",
          "\xd1\x90\x01\xc0\xa1\x32\x57\x7b\x83\x89\xc8\xe5\xc2\x04\xe3\xbc\xad\x82\x87\xca\x5d\xb0"
          "\x06\xdb\x7b\x0a\x75\x24\x1f\xfd\x13\x9e\x28\x7b\x5c\x19\xea\x48\x9e\xe7\x43\xc5\x3f\x7d"
          "\xcd\x3e\x84\x69\xad\x26\x03\xb1\x38\x8e\xd2\x6e\x64\x2a\xee\x6b\xf6\xdc\xec\x26\x9d\x1f"
          "\x5b\x36\x7b\xd1\xa8\x79\x31\x10\x66\xda\x40\x8a\x39\x42\x26\xb9\x17\x4a\xfc\x01\x55\x9e"
          "\xe5\x47\x9e\x43\xd0\x02\xea\x37\xdd\xde\xa0\xaa\x65\xf5\xca\xc2\x52\x6b\x33\xc0\x3f\xe0"
          "\xd5\xe7\xbe\x07\xc4\xd1\x98\xdc\xf8\xe4\x86\x46\x0e\xd9\x86\xfd\xd3\x17\x98\xc6\xb2\x00"
          "\x1f\x48\x9c\x87\x93\x09\x85\xf9\x97\xbe\x6a\x6d",
          "\x50\xe9\x29\x38\x01\x59\x8e\xf1\x9e\x49\xcd\xdd\xca\xb1\x42\x59\xb3\x12\xc0\xbb\x0d\xb0"
          "\x24\xcf\x70\x6a\x0b\x1e\x0d\x2f\xd1\x48\x4b\xab\xcd\x60\xff\xc0\xc5\x60\xe6\x77\x24\x14"
          "\x7e\xc0\xa0\xdc\xdf\x94\x74\x7b\xf2\xb1\x2c\x99\xbe\x55\x7b\x14\xf5\x4f\xf0\x7e\xef\x6e"
          "\x5b\xcb\xc2\xae\x67\xf6\x2b\xbc\x35\xbc\xa8\x01\xc2\xa4\x62\xaf\x8e\x7f\xf4\xf2\xd3\xfb"
          "\xc6\xa5\x7c\xe1\xc5\xb3\x69\x86\xfd\xf0\x74\xa5\x92\xb5\x59\xf6\xb1\x4f\x37\x6d\x30\x30"
          "\x81\xc9\xad\x28\x3b\xe4\x6a\x40\xd8\xf3\xbd\x03\x19\xbc\xc8\xe1\xea\x51\xd2\xd0\x34\x1a"
          "\xb7\x8d\x2d\x94\xb7\xb9\x4b\x6d\x72\x34\xd2\x31",
          1, 1152 },
        { 128, 192, 41,
          "\x63\x9a\x60\x1e\xbc\xd1\x67\xb2\x6b\x81\x10\x8c\x4f\x9e\x7f\x60\x2f\x0c\x57\x2a\xca\x88"
          "\x78\x00",
          "\x63\x55\xd7\x3d\x88\xe2\x90\x4f\xc5\xc0\x5e\x69\xbb\xf1\x8e\xa9",
          "\xe4\xdf\x2d\x7f\x48\xd2\xda\x5b\xeb\x2f\x01\x8b\x14\xf0\x03\xa2\x25\xb5\xe5\x97\x8d\xd3"
          "\x27\x4e\x71\xf6\xef\xe5\x8e\x6e\x7b\x88\x4a\x8f\x13\xb7\x74\xd6\xef\xf4\xb2\xdc\x8f\x05"
          "\x2f\xa7\xb7\xd6\x4a\xfc\xa0\x62\x59\x9e\xf4\xd2\x33\x3f\xf4\xb8\x9c\x50\x37\x65\xa9\x6a"
          "\xce\x8f\x16\xe5\x98\x5a\x02\x18\x29\x12\x00\xc0\x9b\x54\x10\x59\xe0\x8a\x0f\xcd\x7f\x5e"
          "\xc6\x2e\xfb\x09\x63\x2d\x4b\x5c\x8a\x70\x00\x76\x99\x2f\x3e\xfe\x32\x79\xdd\x43\x3c\x46"
          "\x85\x0d\x93\x4e\xc5\x35\x6b\xe8\xf7\xe7\x39\x7a\x86\x6c\xa1\x86\xd1\xe7\x64\xa7\xe7\x9e"
          "\x90\x50\xbe\x4f\xb1\x1d\xb3\xe4\x80\xb4\x42\x68\xcc\x62\x85\x37\x26\x71\xfe\x21\x7b\x46"
          "\x91\xe3\xd9\x83\xec\x04",
          "\x8a\xcb\x83\x36\xbf\x75\x14\x2e\xd3\xd0\x33\x57\x9d\x4c\xcb\x24\xc6\xe7\xba\xff\x39\xdb"
          "\x42\x05\xef\xa0\x56\x5a\x80\x09\xd3\xd5\xbe\xde\xa4\xcc\x07\x2b\xfb\x67\xa1\x41\xd4\x5f"
          "\xc7\x58\x3a\x71\x99\xda\x7e\x82\xac\x97\xf7\x89\x58\xa9\x9e\xc6\x1b\xa4\x6d\xbd\x46\x2a"
          "\x25\xd5\x3c\x91\x0c\x3c\x3e\xb1\x93\xc0\xf7\xb6\x7a\x1f\x16\x03\x17\x61\x07\x69\x02\x73"
          "\xb6\x30\xad\x18\xe9\x43\x26\xb0\x95\xfb\xd2\xfc\xc4\x94\xed\xed\xe6\xa6\x78\x2d\xe9\xf7"
          "\x38\x25\xdc\x3d\x48\x21\x0b\x99\x06\xb9\x99\x0a\xf4\xd0\x8b\xf8\xef\x8c\x33\xd0\x28\x2f"
          "\xbb\x5b\xf1\xb3\x65\x77\x8e\xf0\xe7\xa1\x51\xd0\xc8\xd7\x65\xa2\x52\x38\x0d\x0b\x74\xac"
          "\x53\x9d\x99\xe3\x74\xe3",
          1, 1280 },
        { 128, 192, 42,
          "\xa1\x9e\xed\x56\x61\xb4\x2a\x42\xa6\x0e\x40\x38\x60\xe5\x6a\xdc\x27\x06\xbe\x4e\xd3\x23"
          "\xd9\xf0",
          "\xf6\xb0\x0b\x6b\xdf\xf4\xd6\xf8\x8f\xd4\xf4\x34\x02\xb8\x13\x9d",
          "\xef\x6d\xd8\xb7\x26\xa8\x23\xbe\xaf\x93\x30\xac\xcf\x74\x59\x09\xb2\x0f\xf1\x03\xdb\x82"
          "\xf6\x8f\xa2\xc2\x40\x13\x15\x95\x02\x5c\x09\x3e\x4f\x73\x64\xb4\x2e\x88\x2f\x2a\x0b\xd5"
          "\x8c\x0d\xc1\xa0\xb5\x1f\xb1\x65\x27\xc0\xb5\xa1\x56\x6f\xa7\xd4\x61\x2e\xd2\xde\x6e\x20"
          "\xc3\x5e\xec\xee\x60\x62\x76\x22\x86\xf0\x23\x16\xe8\x6b\x60\x98\x7f\x60\xfd\x31\xf3\xf4"
          "\xd0\xca\xa2\x1a\xa8\x5e\xd5\xdf\xe6\xf1\x23\x28\xf8\x7c\xee\x9a\x51\x63\x62\x4a\x87\xb9"
          "\x3c\x08\x2a\xde\xa4\xa1\x6e\x39\x7b\xd1\x55\x52\x44\x95\x86\xf7\x7d\x8f\x89\x4b\x0f\xc7"
          "\x35\x81\x2b\xa4\xd3\x5e\xce\xe4\x82\x45\xb6\xda\xa5\xf0\x54\x62\x90\xa4\xa4\x88\x15\x98"
          "\xed\xb7\xc8\xdb\xc6\x6c\x32\xbe\x4d\xf6\x6e\xfa\x08\x65\x8d\x70\x86\x61\xf9\x81\x75"
          "\xc2",
          "\x7e\xc5\x86\xb4\xb4\x25\x5c\x1e\xf1\x28\x39\x25\x72\xad\x62\x27\x81\xab\xf4\x3e\xd0\x49"
          "\x6f\xe4\xb9\xff\xaa\x32\x5a\xa0\x4a\xcc\x1b\x92\x59\x20\x23\xa8\x52\x6d\xd8\xbe\x77\x31"
          "\xca\x75\xd9\x89\xf1\xce\x15\x85\xab\xf9\xe7\x9b\x39\x27\x41\xd4\xef\x68\xcd\xbd\x87\x72"
          "\x36\x50\x30\x29\xfb\x6d\x29\xf5\xc9\x7f\x3a\x36\xb6\x9c\x0e\xac\xbf\xcc\x9a\x8b\xa9\x34"
          "\x4f\xe1\x32\xd3\x68\x26\x73\xd5\xbb\xfa\xd2\xa3\x47\x4e\xa1\xce\xcf\xba\xb7\xd2\xba\xfd"
          "\x9d\x1e\xba\x7c\x80\x2e\x33\xed\xa4\x33\x7f\x41\x45\x19\x3f\xec\x97\xa9\xa1\xf5\xf7\xaf"
          "\xa5\xae\x53\x93\x88\xa2\xed\x0a\xe1\x20\xc3\xc7\xd5\x3b\x9c\x5b\x64\x4b\x25\x07\x70\x18"
          "\xc8\xd6\xeb\x26\x68\x76\x52\x01\x65\x72\x79\x7c\xcc\x37\xca\x66\x0b\x0b\xf7\x97\x84"
          "\x50",
          1, 1408 },
        { 128, 192, 43,
          "\x94\x75\xae\x60\x0c\xd7\x25\x48\x19\xd6\xed\xc3\x34\xf1\x68\x1b\x6c\xf0\xa7\x8b\xd9\x4d"
          "\x4a\x73",
          "\xdb\xba\x57\x1f\x7f\x19\xf0\xf6\x74\x25\x97\x9a\x1e\x64\xb0\x0b",
          "\x75\xfa\x12\xcb\x43\x84\xbb\x23\xdd\xa8\xf6\xf0\x78\x9b\x7b\x39\x03\x44\xa6\x36\x63\x1f"
          "\xae\x5a\xf7\xee\xc5\xb6\xe7\x7e\x60\x3b\xb4\xd0\x73\x94\x33\x20\x24\x4b\x23\xc1\x54\x01"
          "\xe8\x3f\x35\x8f\x75\xa0\xff\x0b\x52\x89\xc0\x8f\xdc\x3b\x64\x7c\x0f\xf6\x40\x24\x56\x2e"
          "\x6a\x3a\x52\xff\xb5\x98\xda\x5e\xf4\x4d\x89\xda\xbf\xac\xc7\x10\x97\xbf\x8d\x6b\x17\x28"
          "\xd2\xaa\xd7\x71\xaa\x65\x5d\xbb\x73\xe5\x57\xdb\x19\x63\x88\x75\x54\xe7\x75\x89\x5b\xbe"
          "\xbc\xfc\x41\x5d\xdb\xaa\x98\x21\xf8\x4c\x85\xdd\xec\xe5\x78\xa7\xd2\xcc\x28\xef\x68\x7e"
          "\xf1\x4c\x05\x11\xc0\x0c\x2a\x56\xa1\xd4\x12\x9a\x88\x37\x13\x48\xc4\x8a\x04\xf2\xfd\x75"
          "\xc5\x4a\xd8\x4b\xf2\xfe\x07\x0d\xdc\x54\xee\xcb\xd6\x9c\xfa\x85\x4d\xd7\xab\x63\x66\x67"
          "\x66\x2a\xf6\x8c\x82\xe4\x45\xaa\x7d\x2a\xc8\xbd\xfc\xe0\x69\xfb",
          "\x10\x14\x12\x1d\x07\x86\x6c\x4b\x48\xc7\xd9\x58\x66\x6f\x7d\xdd\x43\xe5\x24\x89\xf7\xbe"
          "\x3a\xac\x50\xc8\x48\x0d\x44\x6d\x3d\x05\xf2\xff\x0d\xbc\xd0\x3a\x0d\x34\xad\xfe\xac\x6c"
          "\x6e\x59\x5c\xb5\x45\xe5\x58\x93\x1f\x93\xcf\x4b\x89\x22\xf3\x58\x58\x46\xba\x74\xe3\xcf"
          "\x2c\x4d\x00\xfa\x3f\x41\xa0\xfe\x38\x97\x09\x99\xe7\x94\x13\xa9\xf9\x55\xac\xb4\x3d\xe5"
          "\x7d\x65\x40\xf1\x03\xc2\xe8\x7e\xf1\xcd\x80\x36\x3e\x60\x91\xf7\xd4\x91\x79\x40\x11\xb3"
          "\xd4\x82\x8c\x3e\xee\x98\xf2\xce\xa4\x72\x2d\x96\x4b\xa8\x99\x6b\xa8\xa0\x8a\xef\x20\x9a"
          "\x1c\x2c\xf0\x25\x56\x79\x2c\x89\x32\x6b\x4e\x20\xa8\x5a\xd0\xe3\xca\x8b\xa7\x56\xd3\x38"
          "\xe1\xdd\xf7\x96\x13\xd4\x27\x03\x2b\xa8\x6f\x53\x36\xaa\x5d\x08\xf7\x5d\x51\x1f\x6c\x4f"
          "\xfb\x60\xe3\xcc\x70\x9f\x33\xb5\x3b\x3e\x18\xf2\x34\xc4\x96\xdf",
          1, 1536 },
        { 128, 192, 44,
          "\x31\x85\x9d\xdf\x0b\x15\xcb\x16\xab\x6b\x7d\xb2\x5f\x54\x08\xd5\x28\xc3\x42\x06\x80\x49"
          "\xd6\x1c",
          "\x31\xa3\x4d\x3a\x9f\x97\x71\xee\xad\x75\xce\x3d\xba\xf0\xdb\xbf",
          "\x93\xe0\x74\xb6\x03\x5d\xbd\x70\x2a\x65\x21\x11\xfc\x15\x74\xb9\xd9\x0e\xed\x19\x6c\xcc"
          "\x7b\x5d\x67\xc8\x38\x0f\x92\xe9\x0f\x8c\x26\x28\xc5\xd3\x95\x1d\x33\xa1\xfd\x9d\x2f\xc7"
          "\x26\xb3\x8e\x10\x02\x88\x9e\x7a\xb1\x33\x9f\x96\x68\xdd\x7a\xb4\x92\xa0\xfe\x2f\xb4\x1f"
          "\x5f\xa4\xb2\xe6\x48\x0c\xe4\x0c\xc7\xef\x44\xa0\x3e\x8d\xaa\xef\xb8\xa1\x98\x05\x14\x14"
          "\xf7\x69\x24\x6a\x7c\x19\xbb\xe0\xf1\xdc\x92\x86\xa3\x58\x84\x31\x68\xed\x5c\x92\xd5\x22"
          "\x94\xd7\x5f\x44\xc6\x5c\x01\x73\xd3\x87\x48\xa5\xb2\xec\xfb\x70\x53\x04\x05\xb5\x39\xed"
          "\xdc\x4b\x6b\xfd\xae\xdb\x48\x5e\xda\xbf\x24\x62\xe0\x51\xd3\xe9\x3a\xa7\xa7\xd8\x93\x9b"
          "\xd7\xf7\x5e\xfa\x78\xd8\x69\x1a\x84\x91\x31\x91\xae\x16\x23\x59\xc9\x79\x33\x30\xd3\x35"
          "\xe1\x41\x10\xb6\xa0\x34\xc3\xe4\xa1\x7f\x68\xf8\x95\x34\xcc\x47\xbd\xc7\xd1\x7c\x52\x70"
          "\x48\xb7\x48\x57\x9b\x18\xf2\x31\x02\xfe",
          "\xd7\x16\xc7\x96\x51\x64\x72\x45\xb7\x1f\x20\x7b\xef\x03\xcb\x67\x60\x20\x36\x2b\xe4\xf8"
          "\x9b\x42\xb3\x4e\x43\x93\x64\x61\x10\x48\x68\xda\x09\x38\x7b\x5d\xfb\xdc\x57\x9c\xa2\x46"
          "\x40\x4b\x41\x59\x0e\x4e\x61\xfc\xd6\x30\xa8\x25\x9f\x5d\xcc\x9b\x13\xc7\x59\xea\x96\x7a"
          "\xf1\xe4\x16\xc7\x0f\xc4\xe3\x28\xbf\x67\x0e\x61\x05\x98\x98\xf2\x2f\x2f\xed\x73\x60\x46"
          "\xa1\x9e\x12\x62\xa3\x29\x94\x00\xe8\x4d\x28\x22\x02\xca\xc0\xeb\x07\xc7\x1f\xd0\x8d\xe4"
          "\xbb\xc1\xef\x7d\xd5\x67\xcd\x8d\x6a\xbd\x98\xd7\x35\x34\x0a\xaf\x66\x1f\x77\x0d\x87\xc7"
          "\xed\xaa\xb5\xcf\x3a\xc2\x88\xdb\xd9\x24\xde\xa6\xe8\x1e\x2f\x57\x82\x41\xe7\x37\x58\xd2"
          "\xb3\x46\x41\x03\x73\xc0\xbd\x74\xc0\x80\x47\xe1\xcb\x32\x84\x4c\x26\xd3\x68\x05\x8f\x2c"
          "\x7d\x3f\x1a\x67\xb0\x69\x62\x0a\xaf\x3c\x0c\xb6\x7d\x14\x9f\x32\x56\x81\x07\x8d\x76\x0b"
          "\xa5\x94\xc5\xaf\x7f\x05\xb3\x75\xf9\xea",
          1, 1664 },
        { 128, 192, 45,
          "\xbc\xd5\xf4\x66\x84\xb4\x55\xbb\x9a\x26\x4a\x52\x11\xc4\xcb\xce\xc9\xe2\x27\x0d\x31\x77"
          "\xec\x9a",
          "\xf7\x67\x4e\xe1\x76\x51\x76\xf8\x8b\xc5\x3b\x71\x10\x70\x31\xec",
          "\x3b\xf9\x29\x28\x93\x16\x2b\xfc\x8c\x9b\xe5\x7b\x6d\x7c\x1a\xde\x97\xf7\x50\x98\x06\xf6"
          "\xd3\x0f\xf0\xdc\x53\xec\x87\xd0\xc0\xbe\xeb\xaa\x4b\x0e\x06\x90\x5e\xfa\x62\x39\x86\x40"
          "\x51\x17\x35\x32\x08\x43\x85\x88\x3d\x16\x77\x61\xb4\x43\x31\xaa\x13\x47\xd9\xde\x39\xf1"
          "\xc2\x9f\xe0\xc8\x95\xa9\xdd\x5e\x5d\x4d\x7f\x33\x1f\xeb\xfb\xab\x33\x1f\x92\x9b\xd9\x6d"
          "\xd4\x67\x86\x32\x5a\x3c\x0d\x06\x60\xa9\xab\xde\x7c\xc9\x3d\xca\xa5\xbd\x15\x5f\x6a\x56"
          "\x33\x1d\xf4\x0a\x38\x16\x34\x5a\x8d\xfd\x5e\xed\xc7\xeb\x8b\xd8\xc4\x86\xe1\x65\x44\xd6"
          "\x61\x38\x82\x56\x20\x3b\xbf\x24\xae\x71\x74\x94\xf2\x09\xfb\xe6\xb5\x69\xa0\x02\x38\x96"
          "\x8f\xa7\x6d\x43\xf0\x58\xc4\x29\xb5\xed\xd4\xf9\x0f\xfc\x23\x01\xbf\xdc\xf0\x65\xc2\xa2"
          "\x4a\xd0\x20\xc6\x81\xe6\x12\x6a\xd7\x5f\x0f\xc8\xda\xfe\x95\xa9\x35\xf4\xc9\xa7\x68\x2a"
          "\xb4\x90\xe7\x66\x6b\xf7\x89\x88\xe1\x07\x1c\x89\x4e\x94\x60\x80\x4a\x73\xd6\xb6\x30\x5f"
          "\xe9\x5f\xf2\x70",
          "\xd4\x23\x1f\xf6\xd4\x5e\xed\x70\x0c\x50\x92\x8a\x4c\x40\x6e\x18\x0a\xe0\x61\x52\x45\x3c"
          "\x2b\x22\x6b\x1c\x68\xf7\xa0\xd7\x3a\x8e\xd2\xdd\x37\x11\x86\xac\x39\x93\xb1\xa0\x8a\x42"
          "\x92\xcc\xd1\x24\x8b\xa6\x11\x1c\x4c\xd4\x06\x3b\xc7\x80\xb7\x50\x7e\x11\x7e\x12\x58\x01"
          "\x5c\x13\xc3\xc6\x15\xa3\xff\xda\xc2\x73\xe4\x02\xab\x2d\x42\x5d\xa2\x54\x89\x7e\x11\xe5"
          "\x1e\xb1\x7e\xaa\x96\xe3\x98\x06\xc9\xd4\x2b\xd7\x0d\x3e\x2a\xf4\x41\x14\x54\x63\xae\x1f"
          "\x1d\x35\xa1\x67\xdf\xc9\xd1\x0a\x0c\x17\x9b\xe9\x51\xa1\x08\x63\x85\x7f\xf3\xe9\xe2\xbd"
          "\x40\xef\x7b\x1e\xb1\x8a\x6c\x9a\xd4\xaa\xe0\xb0\xa8\x48\xa4\xb1\x7d\xf3\xe9\x6b\x0b\x86"
          "\xa5\xc4\x77\xae\xe2\x46\x7c\xe3\x7c\xe1\x0b\xcf\xff\xc7\x0c\x0d\x19\x5f\x4c\xe6\x76\x22"
          "\xe5\xb1\xbc\xec\x38\xac\x47\x66\x06\xcf\x7f\x22\xd7\x01\x1c\x6c\x15\x0f\x18\x9a\x45\x2b"
          "\xeb\x9c\x79\x66\x74\x71\xc4\xe0\x6d\x36\x48\xbd\xb7\xeb\x9c\xff\xdd\x97\xe9\x4d\xb3\xfa"
          "\x67\x3a\xfe\x76",
          1, 1792 },
        { 128, 192, 46,
          "\xaa\xf0\x3c\x89\x11\x4a\xbc\xf9\x8f\x28\x01\x05\x05\xa1\x3d\xd3\xab\x17\xcf\x06\x19\xa6"
          "\xfc\x7a",
          "\xf1\xee\xb3\x56\xa9\x3e\x3a\xf1\xdc\xd8\x24\xdb\x9a\x61\x61\x0f",
          "\xe0\xb1\x53\xd8\x4c\xda\x61\x3e\xa4\x1a\x0d\x18\x5e\x98\x92\x29\x61\x17\x39\x03\x40\x74"
          "\xc3\xaa\x53\x98\x94\x32\x70\x6a\x14\x0a\x2d\x1e\x58\xe4\x51\x9e\xf1\xa2\xdb\x39\x99\x76"
          "\x60\x57\xe2\x1b\xc4\x4d\x8a\x5c\x79\x01\x78\x9e\xbb\xe8\xed\x4c\xdb\x02\x71\xd5\x76\x60"
          "\x38\xe7\xe1\xb9\xc3\xe6\x26\xe1\xfc\x91\x6e\x25\x0b\x1d\x9d\xe6\x99\x11\x20\x9b\x5b\x9a"
          "\x22\xf1\xf3\x1f\x45\x90\x98\xd5\x33\x6c\xa3\x01\xd1\x37\x29\xde\xae\x5c\x4b\x65\xf3\x85"
          "\x05\x23\x92\x6f\xd9\xff\xcf\xf9\x0b\x37\x9b\xd9\xb8\x0a\xf1\x70\x0a\xfc\x4d\xbc\x1d\x81"
          "\x5c\x39\x81\xa4\x20\x01\x4e\x24\x8e\x72\x10\xb0\xd3\xf8\x3f\x6f\x25\x59\x6d\xc3\xa9\x41"
          "\x17\x34\x5d\x9f\x3f\x42\xf9\xb1\x12\x14\xf1\xb2\x1a\x51\xa7\x3d\x85\x40\x77\x65\x47\x1c"
          "\x32\xfb\x4b\x2e\x8e\xcc\x0f\x90\xe2\x09\xd3\xaf\x27\x2d\xef\x80\x6c\xd1\x50\x94\xf0\x77"
          "\x7a\x6b\x25\xbf\x91\xec\x6a\x7e\x74\x47\x51\x03\x69\x96\x2f\x92\xbd\x19\x54\x86\x7d\xe0"
          "\x65\x85\xc8\xcc\x74\x7f\xd1\xf1\x37\xd3\xd3\xb0\xb8\x8c\xeb\xab\x13\x62\x46\xa1",
          "\x6a\xf9\x41\x07\x85\x25\x26\x94\x96\x8b\xd7\x95\x22\xd7\xe5\x62\x72\x77\xdc\xa4\xb6\xfc"
          "\x2c\x31\x8a\x89\x53\x6a\x89\xb2\x9f\x21\x89\x2f\x3f\x43\x60\x1c\x81\xe9\x76\x8f\x86\x9c"
          "\xc8\x45\xe1\x13\x67\x32\x6a\x1e\xb5\x3f\xc4\xfd\xec\x88\xd7\x31\x0e\xd5\x11\x91\x00\x13"
          "\x9d\x39\x06\x3e\x23\xe9\xaf\x7e\xec\xef\x3b\x2f\x74\xf7\x75\x33\x9d\xfa\x80\xdf\xbf\xba"
          "\x69\xf6\x41\x54\xc7\xf6\x51\xc2\xfd\xfd\x12\x6e\xc7\x14\x8d\xa5\x19\xc9\x85\xd0\xd9\x69"
          "\x4d\x08\xcf\x6a\xef\xf8\x25\x8e\xfd\xf1\xb1\x1c\xda\x7c\xc2\x28\x9f\xa0\xc5\x27\xf6\xe5"
          "\x75\x21\x51\x47\xa1\xb7\xaf\xf5\x60\xf8\x7b\xa2\x44\xc0\x89\xd3\xd1\x62\x47\x93\x83\x88"
          "\xc4\x06\x60\xc7\xfa\xb5\xb7\x4c\xe7\x43\x78\x84\xc9\x49\x4f\x21\x5b\x1e\x81\xb0\x1b\xfe"
          "\xa4\x6f\x99\xe7\x2d\xce\x44\x15\x47\x26\x23\x62\xac\xbe\xf0\xba\x2a\x40\xf1\x18\x20\x22"
          "\x35\x39\xab\x76\x59\x59\x6e\x64\x68\x3a\x49\xfa\x9f\x00\x8b\x00\x31\x95\x2b\x83\x4a\x17"
          "\x85\xca\xfa\x3b\xac\xc3\xd5\xf2\xd8\x18\xa3\x81\xcb\xc9\x61\x8e\x10\x26\xb3\xd6",
          1, 1920 },
        { 128, 192, 47,
          "\x42\xa5\xa5\xe3\x87\xcc\x88\xaf\xe4\xd7\xc5\xec\xbf\xc6\xa6\x0b\x07\x00\xe2\xaa\x73\x86"
          "\x6f\x6c",
          "\xe1\x4d\x37\xe4\xdc\x49\x83\xd8\x37\xca\xfc\xa0\x17\x01\xfb\x1d",
          "\xfd\xe5\x7d\xe9\x1a\x06\xe6\x33\x4f\x11\x84\x7c\x88\x71\xf5\x40\x1f\x33\x14\x29\xdd\x54"
          "\xd9\x93\xdc\x96\x36\xad\xef\x37\x82\x1a\xce\xad\xca\xe0\x60\x51\x5d\xb7\x3c\xac\x1b\xd2"
          "\x9e\xf7\xca\x8d\xe5\xd1\xd0\x4d\x0a\x5a\x64\x22\xd5\x8d\xaf\x6a\xf1\x29\xda\x2b\xbb\xc2"
          "\x9f\x13\xc5\xc2\x71\xcf\x0e\x55\xdb\xee\x67\x44\xa8\x35\x89\x8a\x60\x6b\x19\xe5\x35\x95"
          "\x41\x30\x6f\x44\x7e\x69\xe4\xef\xf4\xe3\xe3\xc7\x7a\xcc\x8b\x2c\x39\x7c\x29\xad\x13\x6b"
          "\x44\x9a\xc3\xb3\x43\x08\x61\xb6\x09\x1f\x74\xb8\xb9\x83\xfd\xd1\x81\x95\x04\x61\xbc\xa6"
          "\xf6\xc6\x8b\x4b\x59\x4c\x90\x17\xf7\x42\x71\x42\x06\x49\x99\x3b\x09\x45\x23\x00\x38\x05"
          "\xbf\x6a\x0b\x60\xaf\x79\x3c\x8e\x9b\xf5\x52\x71\x61\x1a\x25\xe9\xb4\xed\x6a\x0b\x3b\x34"
          "\x59\x0e\xb7\x72\x39\x5d\x35\xc2\x3a\x47\xda\x93\xd5\x5a\x32\x2e\x85\xe7\x8c\xd6\x42\xbf"
          "\x69\xc8\x8b\x8a\x0d\x08\x5a\xc7\xd5\x2f\x0f\xa3\xe2\x0f\x3d\xa5\x5d\x1f\x78\x92\x4f\xe5"
          "\xfe\xe9\xb8\xe2\xee\x8a\xd7\x49\xaf\x56\xa1\xd6\xcb\xe0\x3b\xed\x0a\xaf\xa2\x08\xe7\x41"
          "\x95\x2e\x39\x42\xb5\x02\xe4\x86\x70\x59\x53\x7b\x4c\xc5",
          "\x9b\xfe\x52\xe4\xe8\xc7\x73\x13\x86\x72\x92\x26\x64\x1b\x69\xd7\x4f\xb0\x43\xde\x9e\xa6"
          "\xc6\xda\x68\x33\xe0\x45\x8d\x95\xeb\xce\x41\xac\x9c\xbd\x8b\x38\x1d\x12\x7c\x7f\x20\x5c"
          "\x06\x56\x78\x08\x8d\x25\x94\x80\x70\x21\x3a\xf1\x97\x24\xe6\x22\xfe\x92\x6f\xd2\x9d\xae"
          "\x5e\x70\x50\xc2\xb7\xbf\x5d\x19\x13\x24\xae\xa2\x9a\xdb\x3b\x9a\x05\x8c\xb7\x39\x2c\x3e"
          "\xed\xa0\xa8\x00\x51\x29\x81\x88\xe9\xc7\x15\x29\xf9\x6b\xef\x67\xc5\x4e\xdc\xc6\x97\xcf"
          "\x36\xbf\x97\x9e\x56\xeb\x5a\x52\xfe\xe8\x44\x82\x73\x19\xf4\xdd\x4a\x8a\x3e\x53\x80\xa7"
          "\x96\x59\x8c\xe9\xcd\x80\x1c\xc5\x57\x29\xfa\xfb\x34\x87\x05\x05\xb7\xe3\x2c\x6f\x29\xa8"
          "\xd2\x53\x3d\x87\x12\xac\xd9\x8e\x24\x93\xec\x56\xc8\xdd\x32\x51\x51\xa3\x76\x92\x9b\x94"
          "\xff\xf1\x6c\x71\xff\x95\x0c\xd4\x12\x7c\x6a\x65\xd9\x5c\x7d\x86\x75\xe6\xa6\xa6\x7f\x8b"
          "\x1e\x9a\x83\x38\x00\x20\x27\x90\x15\xf7\x85\x60\x79\x2a\xba\x89\xea\x9c\x84\x0f\xe5\x5c"
          "\x2a\xb4\x36\x4e\x58\x1f\x24\x03\x66\xf1\xdc\x10\x45\xd6\x25\x26\x38\xe2\x0b\x48\xee\x62"
          "\xf4\x19\xd3\xd1\x65\x23\x21\x13\xec\xbe\x13\x48\x25\x41",
          1, 2048 },
        { 128, 192, 48,
          "\x9b\x0d\x1f\x04\x79\x3d\x47\x8c\x55\xd4\xa7\xc1\x99\x12\x83\x90\xab\xf0\x6d\xdb\x84\xcd"
          "\x88\x28",
          "\xa9\xfe\xc0\xcc\x2f\xe3\x04\xe8\x21\x31\x4c\x92\x4c\xc5\x70\xfe",
          "\x8a\x07\x3d\xf6\x1e\xdf\x34\x2f\x97\x44\x28\x47\xf8\xec\x37\x2b\x6d\x9d\xf9\xd6\x1a\xdf"
          "\x45\x07\x82\x9c\x7f\x26\xbd\x91\x38\xd8\xbd\xa7\xae\xcc\xe0\x05\x53\x86\x14\x13\x0e\xb3"
          "\x4d\x6e\x72\x2f\x74\x60\x06\x5a\xf3\xb5\x7e\x84\xe7\x97\x85\xb9\xf6\x5d\x8d\x7f\x19\xc6"
          "\x13\x6d\x93\xe2\x97\x04\x1f\x91\x24\x2b\x86\xbe\x96\x12\x9c\xaf\x0c\xd1\x3b\x64\x65\x99"
          "\x9c\x07\x6f\x91\x3f\xc7\x8a\x83\xa8\xd9\xb5\xe3\x5a\x36\x5d\xae\x96\x5c\x19\x9a\xb5\xc7"
          "\x49\x3a\x38\x46\xd3\x56\xf7\x26\xe6\x59\xaf\xd0\x5c\xa5\xfa\x10\xb9\x4d\xb5\x27\xe2\x55"
          "\xea\xed\xff\xd2\x41\x3c\x7f\xf3\x93\x53\xea\x47\x98\x69\xe0\x12\x87\xd3\x02\x30\x57\xfd"
          "\xa4\x98\x9c\x0b\x83\xf8\xf3\x7a\x58\x21\x53\xd6\x88\xc2\x4d\x1e\x33\xa1\xed\x7c\xe6\xa0"
          "\xd3\xa4\x8b\xcd\x7e\x78\xc8\x1e\x54\x5c\xfc\xef\x7c\x0f\xb9\x78\xff\xd4\x36\xed\x78\x1e"
          "\xfc\x8e\x12\x1d\xdd\xbd\xe7\x56\xce\x2c\x15\xac\xaa\x0c\xf1\x57\x7a\x23\xa0\xbf\xe8\xc7"
          "\xe9\xcd\x2d\x67\xe8\x1b\x87\xe4\x65\xf3\xf8\x1e\xdd\x8c\xbc\xac\x0d\x60\xfd\x66\x15\x7a"
          "\x7a\xde\x58\x10\xa7\xf0\xd9\x5c\x64\x84\x8a\x5e\x16\xd7\x46\x5a\xd2\x40\x39\x60\x81\xd0"
          "\xea\xc9\xe8\x96\xc7\x17\x76\x6c",
          "\x16\x6c\xd8\x67\x53\x44\x14\x8a\x26\xbb\xdd\x69\xc1\xee\x10\x53\x18\xb8\xf2\x34\xa4\x40"
          "\xbe\x3b\x27\x0b\x4f\x2c\x48\x40\x70\xb5\x8a\x9a\xa0\x16\x17\x14\xc8\x58\x8e\xe6\x9c\xe2"
          "\x1f\x85\x0a\x7f\x45\xbc\x89\x7f\xbe\x1c\x2a\xd6\x35\x31\x68\x5e\xff\x59\xa2\x8f\xe2\x14"
          "\xf3\x98\xb8\x9b\xac\x25\x61\xd2\xf7\xc5\x46\x41\x69\xa2\xb4\xb0\xaf\x11\x67\x5f\xa3\xf7"
          "\x07\x4f\x18\xa1\x8f\xd8\xcc\x2d\x27\x01\xa9\x2e\xc6\x70\x88\x8c\x85\xfb\x65\x88\xdb\xf7"
          "\xfe\x03\xb9\x14\xa8\xdc\x7d\x9f\x00\xe7\x7b\x6b\xd3\x9d\x12\xf7\x0c\x3c\x13\xbc\x03\x0e"
          "\x98\xfc\x87\x10\xd0\xe1\x19\xff\xb2\x5a\xca\xd6\xef\xd6\x9c\xf7\x10\x48\xdc\xa2\xbd\x8e"
          "\xad\x3b\x3a\x39\x4e\xd7\x77\xfd\x93\x92\xf6\x08\x1d\x5c\x25\xe7\x91\xca\x62\x76\x0b\xc6"
          "\xe3\x5a\x04\x6b\x77\x5f\x20\xe4\xc5\x61\xc4\x6d\x6c\x9b\x13\x7b\x1e\x0d\xd9\xa5\xba\xb8"
          "\xbc\xd6\x96\x93\x5a\x51\xbb\x8b\x74\x9f\xf2\xe6\x66\xda\x6a\x13\x57\x16\x3f\x39\xfd\x01"
          "\x2e\xf5\x80\x6f\xf5\x69\xf9\xe8\xa9\x66\x2b\x2f\x4b\x93\x76\x97\x99\x1e\x53\x9e\x46\xde"
          "\xbc\x98\x41\x2c\xe3\xc0\x2f\x96\x08\xba\x35\x54\x5f\x9c\x07\x4e\x9c\x65\xcb\xd7\x85\x29"
          "\x88\xc7\xe7\xac\xdd\xe0\xe7\x32",
          1, 2176 },
        { 128, 192, 49,
          "\xc2\xac\xc9\x22\x9a\x73\xa4\x03\x2d\x4b\x22\x1f\x97\x80\xb8\xa9\x4c\x36\x9e\x35\x4f\xf2"
          "\x74\xf0",
          "\x94\x0e\x36\xf9\x03\x87\xbf\x86\xba\xc8\x1e\xde\x54\x91\xfb\x9a",
          "\x48\x51\x2e\x2a\x58\x59\x47\x87\xc8\x34\x5b\xf2\xd0\xf7\x70\xaa\x8f\xa5\xf2\xf1\xb7\x70"
          "\xa1\x0b\xb0\x9b\x91\x74\x53\x14\x8d\x5c\x53\x47\x2a\x4b\xf1\x92\x7d\xd3\x24\xa8\xcc\xa5"
          "\x44\xc8\x53\x04\x41\x53\x45\x67\x53\xad\x21\x8b\xb6\x68\xe8\x65\xe3\xa7\x14\x64\xd6\x89"
          "\x2f\x95\x30\xc6\x74\xcd\xa9\xbf\x81\xb9\xa2\x91\xbb\x73\x51\xe6\xb9\x5c\x7e\x6d\xa6\xa8"
          "\xf5\x6a\x56\x3a\xbc\x89\x7c\xf9\x08\xad\xd5\xad\xf9\x34\x09\xb9\x11\x33\x31\x1f\xa0\xa6"
          "\x7f\x1a\x78\x46\xbf\x66\x32\x64\x40\x5d\x0d\x0b\xdf\x41\x5f\x3d\xf6\x4e\x34\xea\x77\xcf"
          "\x93\x4e\x06\x9c\x21\x1a\xb2\x39\x2a\xc7\x04\xf7\x57\x3f\x0b\x62\xcb\xd0\xba\x4f\x32\x9d"
          "\xd4\x66\xf9\xab\xf7\x52\x7a\xac\x9b\xf7\x97\x7f\xf7\xf9\x18\xe2\x7e\x78\x04\xa0\x2f\x3b"
          "\x3d\x9f\x75\x3d\x36\x68\x0a\x26\x05\x3f\x07\x10\x5b\xf2\xb4\x44\x2d\x09\xe5\x73\x5d\x86"
          "\xf4\xd4\x94\x6f\xdb\x29\xd7\x5a\x4f\x73\x5e\x83\x8a\xd0\x31\x55\x69\x8e\xdd\x1e\x82\x03"
          "\xed\xb3\xb5\x65\xca\xc5\x6d\x97\x52\xf0\x3a\xf5\x0c\xc1\xd7\x3e\x9a\x28\xc5\x6a\x41\x90"
          "\xd3\x32\xf6\x76\xf8\x8a\x94\x44\x5f\x1b\xee\x18\x22\x71\xc3\x86\x0b\xe6\xa9\xb2\x43\x5f"
          "\x8f\x68\x28\x58\x52\xa6\x89\x70\xc1\x1d\x1f\xb0\xbb\x6d\x1e\xce\x4b\xc4\x3d\x0a\x67\x65"
          "\x09\x8d",
          "\xe7\xd5\x7d\xf5\x4a\x97\x53\xb9\x5b\x64\xeb\xac\x46\x44\x17\x53\x23\x0c\x1d\xd7\x48\x92"
          "\xe2\xc7\x3b\x89\x48\x82\x59\x66\x01\x30\x53\x4b\x81\x0f\xc3\xe4\x70\x26\xf6\x6f\x43\xb4"
          "\x33\x82\x51\x74\x78\xb6\x96\x95\x1b\x87\x4e\xa0\x5f\x1a\x2b\x18\x92\xae\xd3\xdf\x25\xc7"
          "\x1c\x97\x62\x55\xf2\xd9\x51\x80\x45\x8f\xc6\x10\xc2\x47\x63\x88\xe7\x5f\x04\x81\xc9\xd8"
          "\xd4\xc2\x90\x84\x67\x7d\x42\xa2\xc1\x64\xcb\x2c\xf9\x44\x47\x94\xaa\x6a\x6e\x1c\x8b\x12"
          "\x08\x49\x43\x12\x9e\x44\xfc\x39\xcd\x6f\xe3\x35\xfc\x61\xa3\xd9\x03\x74\x2b\x5b\x1c\x20"
          "\x76\x52\xda\x08\x50\x32\x92\xc6\xf9\x43\x79\x15\xf7\x5f\xa5\xe8\x04\xcb\xe8\x79\x92\xa6"
          "\x2f\x93\xea\x63\x32\x60\x6a\x44\x3b\x20\x25\x7a\x93\xd1\x11\xe3\xe2\xbf\x2c\x65\x75\xf3"
          "\x65\x82\xc9\x97\x75\xce\xd6\xa3\x44\x64\xbe\xd6\x45\xa3\xe5\xc3\x93\xcf\x13\x84\xf0\xac"
          "\x0b\x45\x22\x3f\x9f\x26\x2b\xa5\x8a\x24\x6e\xf4\x44\xeb\x2b\x62\x93\xd8\x05\x73\xe7\xac"
          "\xbf\x2b\x8b\x81\xb1\x8f\x1f\x75\x28\xd9\x22\x02\x3e\x05\x3c\xf7\x13\x56\xc1\x15\xe2\xad"
          "\x84\x57\x94\x2d\x6f\x76\xbb\x4d\x92\x5f\x01\x26\x72\x44\x2d\xd1\x9e\x8f\x95\x78\x07\xd8"
          "\x21\x3b\xfd\x56\x56\x73\xca\x84\x1a\xb5\xac\x7f\xa0\xf1\x10\x00\x3a\x1f\x32\x10\x0e\xec"
          "\x12\x38",
          1, 2304 },
        { 128, 192, 50,
          "\x57\x51\xdb\xc6\x9f\x32\xd8\xfa\xf6\x67\xe7\xdc\x5c\x2c\xe0\x54\x33\x77\x89\x44\xaf\xfd"
          "\x26\xb5",
          "\x27\x4c\xa3\x4a\xa7\x58\x45\x8d\x3e\x50\xc3\x89\xce\xe8\x1d\x78",
          "\x42\xa5\x0b\xfd\x64\x11\x66\xf8\x6d\x84\xfa\x1f\x18\x00\x1d\xac\x19\xfd\xd0\xf5\xa4\x71"
          "\x09\xb7\xdd\x4e\xb5\x0a\x7a\xb9\x83\xe7\x57\x02\xda\xd7\x4e\xcf\x04\xed\xd5\x44\xa7\x54"
          "\xe0\x5e\x03\xb8\xfe\xb3\x9a\xa5\xc6\xda\x99\x30\x38\xa2\x7a\xf4\x24\x1d\x30\x54\xe8\xa2"
          "\x0f\xbb\xb1\x32\xf2\x7f\x2b\xaa\x8a\xb8\x24\x01\xd2\xf7\x39\x54\x92\xfd\xc6\x69\x67\xd9"
          "\x9c\x45\xc4\x35\x21\x84\xa9\xe7\xfa\x64\x46\x6e\xe0\xad\x48\x69\x52\x74\xb9\xf8\xdb\x84"
          "\x18\xe4\xf8\x8c\xcc\x96\x19\x71\x57\x64\xcc\x14\x32\x3e\x23\x99\xc8\x2a\xa8\xf5\x18\xda"
          "\x0d\x3b\xf1\xa0\xf8\xa5\x98\x46\x07\xac\xb9\x7b\xa6\x8e\xaf\x9b\x85\x0e\xb1\xa1\x5d\x4c"
          "\xbb\xf4\x8b\x91\x47\x3f\xf7\x2c\xa2\x83\x15\x63\x28\x08\x15\xa5\x2b\x37\x0b\x23\xae\xe0"
          "\x28\x7e\xfc\x57\xb4\x31\x01\xe7\x9c\x8e\x46\x18\xe9\xca\x7a\x20\xe8\x25\x8e\x65\x05\x25"
          "\x9f\x5a\x14\xef\xf4\xfc\x2a\x50\x10\xa1\x89\x71\x84\x2b\x21\x6a\xba\x4a\x6c\xaf\x38\x48"
          "\x41\x11\x2e\x60\x6f\xb6\x16\x27\x92\x63\x33\x68\xa0\x3e\xd7\xf5\x22\x29\x49\x9f\xfb\xc1"
          "\x9a\xe1\x29\xfa\xc9\x3c\xf2\xb6\x58\x00\xc1\x60\xdd\x1a\x69\xb3\x93\x89\xee\xbb\x65\x6f"
          "\x76\x43\x75\x92\xf7\xa1\xb3\xc8\x8b\xc9\x49\x86\x0c\xaf\x04\xbd\xdf\x23\xab\x30\xb1\x81"
          "\x1b\x3e\x4f\x40\xb8\x67\x22\x93\xdb\x1d\xb2\x97\xa4\xb2\x3c\x6d\xf3\x3f",
          "\xa4\x11\x10\x83\xc9\x4f\x4e\xc7\x59\xab\xc5\xfb\xd5\x40\x43\x6f\xed\x82\xb3\xe3\xbf\x89"
          "\xb3\x28\x97\x1c\x0e\x96\xd7\xa6\x43\x7e\x9e\x06\x77\xe5\xe0\xe3\xfe\x45\x36\xc4\xc1\xd0"
          "\x5a\x2a\x32\x84\xc2\x40\xd3\x15\x5c\xac\x5f\xcc\x3d\xc9\x30\xf4\x2d\xb0\xa2\x1e\x20\xce"
          "\xc6\x12\xbc\xdf\x41\x85\xfa\x63\xde\x48\x56\xfc\xb9\x28\xef\x2b\x3a\xb1\xc4\x32\xaf\x3f"
          "\x88\x7f\xdc\xac\xdc\x5c\xe2\xaf\x73\x3b\x5c\x26\x38\x8e\xe4\x04\x9f\x91\xc1\xf3\x8e\x7e"
          "\xed\xd3\x1b\x89\xf5\xc6\xed\xcc\x4f\xf3\x4c\x55\x4a\x90\xa0\x7d\x75\x4a\x3b\xed\xa8\x42"
          "\x3a\x60\x66\xc9\xe4\xa5\x90\x09\xc1\x6b\xb7\x65\x4f\x0d\x38\x29\x83\x79\xa1\x88\x29\x64"
          "\x7a\x0f\x73\x34\x59\x96\xb4\x04\x10\x30\x11\x80\x06\x41\xed\xbe\x40\x87\xc6\x0a\x27\xda"
          "\xf4\xe9\x9c\x11\xda\x90\xab\x24\x74\x01\x68\xef\x0e\x84\xad\x4c\xbc\x1d\xae\xdf\x62\x29"
          "\x39\x78\xdd\xa7\x76\xff\x94\xf8\x57\xf3\x4b\x03\xaa\xd1\xdf\xdc\x63\xf6\x5a\xc2\x14\xba"
          "\x40\xcd\x42\x4d\x25\x05\xcb\xbc\x0a\x05\x21\xb1\x21\xdc\x50\xb4\x50\x78\x4e\xc2\x61\xfa"
          "\xad\xb4\x03\x6f\xce\x8b\x6c\x60\x74\x90\x31\x48\xf4\x74\xaa\x30\x4f\x9d\xf9\x65\xa6\x06"
          "\x51\x8e\xd1\x5a\x92\xd8\x2b\x2e\xe0\xb2\xfd\xc3\x33\x2e\xa0\xbe\x9f\xbb\x5f\xde\xdb\xf1"
          "\x77\x9c\xc3\xcb\xa0\x8c\x04\x85\x5a\x7f\x8b\x4b\x20\xfa\x1c\x3c\x99\x0a",
          1, 2432 },
        { 128, 192, 51,
          "\x4c\x0d\xd5\x77\x4b\xe9\xa6\x9d\x1d\x5f\x42\x2f\xff\x26\x4d\x40\x5d\x74\xe2\xf7\x02\xae"
          "\x0b\xa0",
          "\xf8\x75\x32\x35\x5c\x29\xf7\x65\x77\x2b\xb3\x62\x08\x4a\xaa\x51",
          "\x10\x8a\xde\x62\x63\xb5\x23\x4c\xa5\xd3\xf5\xfc\xa8\xf5\xca\x94\x7d\x1f\x7e\x6a\x16\xae"
          "\xe0\x39\xba\x16\x53\x3c\x44\x48\xe0\x31\x5c\xd5\xd2\x8d\xde\x30\x19\xcb\xd6\xeb\xcb\xb2"
          "\x27\x93\xef\xb6\xcf\x31\x5b\xf2\x1c\x3f\x84\xb6\x44\x0e\x53\x5b\xc3\x57\x6c\x57\x5a\xf9"
          "\xa1\x1c\x96\xe3\x8a\x2d\xf7\x89\x41\xd6\xe5\xdd\x2e\xe6\xf2\xe4\x28\x5a\x30\xeb\xda\x22"
          "\x85\x85\x95\xd0\x2d\x7b\x42\x02\xf9\x69\x86\xe3\x80\x43\x67\x95\x22\xa3\xee\x7c\x5b\xc3"
          "\x40\x7f\x98\x54\x28\x5e\x1d\x89\xa3\x0f\xaa\xfb\xd5\xec\x18\x47\x2f\x5d\x00\x40\xdd\x60"
          "\x7e\x75\x18\xa8\xbe\x3f\x37\x5d\xef\xf0\x37\xa4\x01\x40\xf3\xf0\x1b\x60\x82\xc8\xfb\x8d"
          "\xcc\xc1\x3b\xc1\x22\x01\xff\xd1\x21\x08\x3d\x59\x1e\xe6\x22\xde\x06\x16\xdd\x70\x51\xe1"
          "\x53\x71\x93\xf6\x60\x43\xac\xa1\x79\x57\x7b\x9e\xe4\x4b\xa2\xce\xdf\x55\x08\x97\x55\x02"
          "\x0a\x1e\xd6\xf7\xb8\x95\xd5\x38\xa0\x63\x70\x1f\x25\xd5\xb4\xd0\x95\x22\x70\x91\x60\xc7"
          "\x4e\x2b\x9f\x87\xa2\x77\xdc\x9f\x6d\x92\xcf\x8e\x3f\x58\xde\xde\x46\x11\x95\x28\x90\x48"
          "\x73\x27\x00\xf8\xb3\x9a\x9f\xcd\x2c\xa4\xf3\x3a\x91\xf1\x50\x73\x1b\x29\xc0\x6e\xc9\xfa"
          "\x4c\x69\x07\x24\x14\xb1\xbe\x27\xd4\x6b\xaa\x95\xc9\x07\xe9\xe6\x24\xac\x5a\xa2\xfa\xf2"
          "\x08\xc8\xcb\x10\xfe\x55\x67\x98\x94\xe9\x68\xd1\x65\x52\x3a\xa6\x62\x07\xca\x16\x92\x2e"
          "\xcb\x82\x5f\x88\x67\x5d\x44\x49\x85\x73\x53\x4b",
          "\xbc\x50\x8b\xe0\x0a\xe5\x32\xa9\x59\xc9\x9b\x1e\x75\x32\xf6\xad\x52\xfd\xaf\xf2\xc6\x54"
          "\xfd\xf8\x65\x43\xad\x6b\x93\x7f\x44\x02\x90\x41\x46\x1e\x64\xc2\xe2\xbf\x40\x48\xcc\x4f"
          "\x39\xb0\xf9\x0d\xb8\xdb\xd6\x3b\xea\xe4\x98\x2b\x4a\xdd\x7e\xf7\xaa\x75\xa4\x9f\x71\x77"
          "\xe4\x64\xc8\x69\x32\xc9\x44\xc3\x2c\x23\x94\x07\xa7\xd8\xd5\x0c\x4d\x01\x27\xf1\xa6\xfa"
          "\x7c\x7c\x75\x3d\x90\xab\xb9\xc7\x1f\xd1\x18\x27\xd7\x3c\x8b\x4e\xb3\x29\x74\xeb\x49\xe8"
          "\xa0\x9f\x8d\x21\xd4\xea\xc7\xc5\x52\xdf\x82\xf9\xc9\x4e\x89\xdf\x0e\xa8\x20\x9f\xab\x88"
          "\x4f\x4e\x7b\x3b\xf0\x7b\x8d\x0e\x7d\x3c\x5e\x64\x3f\x08\x19\xba\x32\xfc\x85\x77\xf1\x99"
          "\xcc\x9e\x97\xbc\xe3\x3f\x61\xa1\xc9\x3d\x0b\xeb\x65\x5d\x14\xb2\x90\xd5\x38\xcc\x6b\xdd"
          "\x2b\x3a\xa0\xe7\x17\x9c\xf8\xd7\xaa\xe5\x1a\xa6\x36\x87\xc2\xb8\xb5\xe2\x11\xc2\x9b\xd2"
          "\x71\x17\xb5\xf5\x4b\xb2\x77\x5d\xc8\x73\x5b\xc0\xeb\x11\x1b\x0f\x2c\xfc\x74\xa0\x1a\xb8"
          "\xd4\xe1\xe9\x4a\xcd\x9f\x46\xf5\x7b\x22\x78\xb9\xe0\x6e\xa7\xd8\x8a\xc4\x3e\x58\x9a\x7a"
          "\x13\xf1\xc6\x72\x0b\xfd\x82\x04\x8d\x5f\x85\x6d\x23\xbc\xf9\xfa\x60\x4a\x77\x44\xdd\xf2"
          "\x13\xb6\xe3\xf2\x51\xe2\xfa\x91\x09\x98\x78\xfe\x0a\xa9\x54\xf2\x42\xa0\x40\x7f\xab\x0c"
          "\xe2\xe2\x73\xaf\x46\xb9\xdf\xd6\xa9\xb2\x22\xe5\x29\x43\x7e\xa7\xa3\x6b\xc2\x40\x43\x1f"
          "\xee\x4c\x50\x71\xf9\x86\x10\xc9\xb3\x2d\x83\xf9",
          1, 2560 },
        { 128, 192, 52,
          "\x22\x62\x6b\xe7\x14\xf7\x79\x6a\x12\xbe\x5c\xbd\xf9\xcb\xcc\xbc\x3b\x6e\xe2\xc9\x91\x13"
          "\x5c\xf7",
          "\x97\x28\x62\xa0\xc6\xf0\x4c\x60\x96\x35\xe5\xb5\x1a\x2b\x1e\x3c",
          "\x63\xe0\xc7\x1d\x65\x83\x1a\xf6\xf2\x43\xdd\xc0\x31\xa5\xa4\x09\x3b\x51\x86\x26\xc4\x15"
          "\x2e\x59\xcb\xfe\xb4\x76\xb6\xea\x28\x54\x49\xcc\x56\xca\xc6\x64\xe8\x17\x56\x7a\xbd\xcf"
          "\x78\xa7\x4d\x5c\x14\x52\x5e\x50\x6f\x0c\x30\xf4\xcb\xc3\x6a\x80\xf5\x80\x6b\x01\xd1\xeb"
          "\x5a\xa1\x47\xf7\x59\x02\xc2\x17\x64\xd4\xf0\x29\x78\x2a\x1a\x4d\x23\x0f\x44\x5d\x74\x96"
          "\xa6\x1b\x8b\xb9\x9c\x1d\xd7\xf2\x81\x9a\x76\x5d\xc4\xf3\x08\x24\xe7\xc7\x59\xdd\x4c\x42"
          "\xfa\xf1\x6d\xd2\x57\xbd\x14\x12\xd5\xdf\x75\x41\xb6\xcd\x63\x16\xf5\x1a\xcc\xf1\x76\xd2"
          "\x05\xf1\xa3\x17\xb9\xde\x7b\x43\x8b\xcd\x54\xe9\xb7\x7d\x48\xba\x7b\xa8\xff\xa7\xe5\xf3"
          "\xd2\xe0\x09\x56\x1e\x89\x47\x4a\xb2\x21\xb2\xd6\xea\xb5\xdf\x1d\x1f\x78\x56\x80\x57\xc3"
          "\x49\x05\x56\xdf\x2b\x10\x9f\xf4\xd7\x0d\x19\x30\x7a\xfe\x0e\x85\x46\x71\x0a\xee\xe8\x7b"
          "\x3b\x0c\xa3\xc2\x06\xde\x75\x8a\xea\x0c\x00\x64\xd9\x88\xe0\x9f\x55\x16\x79\x2d\xf4\x85"
          "\x8c\xa5\x3e\x9b\x5d\x03\x4c\x13\xa3\xbd\x62\xf2\xff\x03\xde\xf4\x48\xeb\x74\x53\xf9\xdf"
          "\xa0\x7e\xa0\xf3\xfb\x50\x2f\x0e\x60\xe9\xee\x37\xea\x72\xb3\x1a\x74\xb9\xde\xb5\x57\xc2"
          "\x2b\x6c\x8a\x9c\xe3\xa2\x9f\xe1\x39\xf5\x6f\x79\x5a\x52\x4f\x7f\x1a\x8b\x3f\x40\xaa\x8d"
          "\x9f\x14\x10\x02\x77\x8d\x04\x91\xb0\x90\x8d\xcb\x6c\x8d\xfa\x59\x89\x71\xa3\x77\xd1\xc1"
          "\x58\x2d\xff\xef\xcc\x73\x8b\x4a\xca\x65\x66\xae\x5a\x48\xbb\x48\x87\x92\x28\x21\x82\xbc"
          "\xeb\x91\x42\xd0\x0a\x12",
          "\x1d\xea\x15\x24\xb0\xce\xa2\xad\xfd\x0b\x3b\x01\x09\x51\x8b\xfb\x44\x08\xe5\x06\x70\x72"
          "\x5c\x8f\x55\x18\x85\xc0\x62\xb7\x55\x20\x39\x98\x9f\xc7\x5e\xdf\x96\xaa\x6b\xfd\x99\xb3"
          "\xb7\x03\x9f\x46\xf8\x60\x86\xc1\xea\xaf\xef\x15\xd8\xcd\x11\x7a\xed\xed\x93\xe8\xdc\x88"
          "\x7b\x1f\x00\x40\xf5\xff\x27\x5f\x75\x4c\x6e\x62\x37\x1e\x7a\xdb\x6a\xec\x9e\x81\xbb\x9e"
          "\x3d\x08\xc5\xd0\xe7\x23\x14\x18\x88\xd3\x38\xa2\x49\x0e\xd2\xfb\x24\x0c\x7e\xd9\xa9\xdc"
          "\x6d\x8d\xaf\x9d\x48\x47\x17\xe4\x37\x4e\x7b\x55\xc7\xc5\x5b\x3c\x03\x99\x9f\x1a\xcd\xca"
          "\x43\x70\x47\x41\x75\x89\xf4\x38\x27\x5b\xfd\x3d\x46\xb7\xb9\x0c\xce\x57\x4c\xe5\x40\x09"
          "\xfb\x39\x2b\x5d\x66\xbc\xec\x6d\x3b\x52\xf5\x3f\x8e\x45\x46\x91\x5c\xc4\x30\x30\x0e\xdb"
          "\x83\xcd\x24\x20\xcd\xb3\x3a\x30\x14\x24\xc0\x43\x31\x11\x4f\xc4\x0a\x5d\xe0\x83\x32\xf2"
          "\xe4\xd7\x7f\xdf\x9a\x1c\x28\x41\x4b\xc0\xa6\xc9\xe0\x17\x4e\x5c\x4e\x8c\x2c\x48\x5c\x3b"
          "\x73\x8c\x66\x58\xd5\x0e\xf5\x23\xab\xe8\x36\x47\xce\xcb\x12\x5e\xab\x2b\xe5\x70\xac\x03"
          "\x0d\x06\x32\x6e\x4e\x6d\xdd\xb1\xfd\xf2\x61\x40\xc1\xa1\x58\x8b\x44\x01\x7d\x91\xae\xe3"
          "\x13\xcf\xa0\xcb\x7d\x8d\x91\x05\xea\xcd\xd9\x4b\xe2\xd2\xba\xa2\x72\x72\xa3\x5d\x2c\xd7"
          "\xba\x2e\x3e\xba\x89\x23\xfc\x28\x30\x32\xbf\x7c\x1d\x77\x91\xdc\x51\xd8\xe5\x02\x2c\x42"
          "\x07\x69\xe5\xac\x69\x0f\x04\xe4\xd9\x0c\xd7\xbf\xdb\x58\x59\x0c\x41\x9f\xf2\xd7\x2f\xa2"
          "\x46\xcf\xbd\xbe\x13\x08",
          1, 2688 },
        { 128, 192, 53,
          "\xbc\x1a\x18\xe8\x20\x9e\x98\x0a\x04\x99\xb5\xae\x7a\x10\x51\x20\xe6\xc5\x46\x87\xa5\x66"
          "\x76\xbf",
          "\xfb\x93\x85\xe6\x0f\x69\x9c\x20\xda\xb9\x33\x87\xf7\xed\x3f\xeb",
          "\x64\x8f\x04\xec\xa9\x6a\x6c\xeb\xf6\x31\x64\x4d\x3d\xf2\x0b\x7a\xd9\x23\x05\xf9\x3f\x93"
          "\x1d\xe1\xf2\xe9\xc1\x6b\x09\x5a\xab\x45\x7a\xa6\xf4\x30\x2c\x1d\xab\x1a\x94\xc3\xa2\xd1"
          "\x46\xf2\x4a\x80\xa7\x98\x84\xa6\x9d\x4c\xb2\x03\x55\x2d\x8f\xca\x1e\x2d\xcb\x2b\x65\x36"
          "\xee\x23\x11\xb4\xfa\x0d\x92\x8c\x21\xe7\x36\xd0\x2e\x22\x01\xf0\x67\x66\x94\x35\xd3\xc1"
          "\x48\x1b\x7a\xce\x96\x81\x33\x60\xa7\xb2\x46\xd8\x99\x6f\xed\xb8\xbb\x99\x8b\xee\x64\x18"
          "\x0a\xc8\xb8\x43\xe8\xdd\x68\xf1\x0c\xc1\x9a\x68\x09\x5e\x85\x07\xfe\x14\x50\xfd\xe9\x0a"
          "\xc0\x05\x5e\xe7\x5f\xd4\x6d\xc4\x7d\xc7\x46\x46\xea\xa8\xf2\xfc\xcb\xc1\x29\xec\x23\xad"
          "\x98\x98\x83\x69\x7f\x69\x27\x95\x89\xfd\xd7\x59\xac\xf4\x21\x8e\x03\xf3\xeb\xce\x2b\x4d"
          "\x70\xd3\xa4\xa1\x13\x3e\x59\xb2\x9e\xe5\x61\xfd\xa4\x34\x92\xea\x79\x1d\x04\x6f\xaa\xd0"
          "\x02\xcd\x77\x27\x89\x23\x97\x18\xfc\xa4\xf7\x25\x5f\x5f\x59\x0d\x50\x28\xbb\x42\x66\x43"
          "\xcb\xb5\x4a\x94\x38\x16\x84\x95\x00\x6f\x75\xde\x19\x80\xb2\xaa\xf4\xba\x15\x43\x53\xb8"
          "\x0c\x77\xfa\xfb\x1b\x2b\xc6\x3e\x4c\x9d\xf1\x4a\x84\xd1\xda\x18\x7b\xd6\x52\xe6\x78\x0d"
          "\x7c\x7c\x36\xbd\x59\xc2\x82\xf4\x85\x0d\xf5\x5f\xc4\x47\x4b\x3e\x37\x15\x4f\xfa\x7a\x61"
          "\x9a\x5e\x93\x99\x62\x18\x15\x7c\xf4\xbe\x19\x51\x70\xdf\x59\x13\xcd\xbd\x64\x6f\xee\xd5"
          "\x46\xc5\xb5\x1f\x08\xfe\x2e\x45\xa0\xb1\x79\xba\x19\xe2\xcc\x4b\x39\xbd\x1c\x8d\x53\xa1"
          "\xa6\xa8\xc7\x79\x50\x7e\x68\x53\xa4\xa8\x4d\x29\xa8\xc3\x81\x0b\x72\x22\xff\xf1\xf8"
          "\x13",
          "\x56\x17\x38\xa3\x7d\x5a\x3d\x9d\x69\xe4\xa8\x79\x47\xd9\x67\x77\xe1\x70\x20\xfd\xe2\x65"
          "\x02\xc3\x84\x81\x5f\x6f\xcf\x8b\x59\xf5\x7f\xd8\xe1\x8a\x09\xd7\x6d\x15\x12\xe4\x38\x3c"
          "\x86\x7a\xf8\x31\xc4\x6c\xcf\x34\x56\x15\xf7\xc7\xfe\x42\x5b\x48\xd3\x89\xa2\x07\xe3\x1a"
          "\x71\x3d\x2e\xc6\xbf\xa2\xea\xde\x12\x30\x9f\x71\xd6\x4f\xc8\x38\x92\xd1\x08\x16\x4c\x94"
          "\x5c\xd0\x07\xd2\x5f\x3b\x30\x52\x4f\xf9\x78\x29\x26\x47\x77\xb0\xa9\xb5\xaf\xee\xa6\x9e"
          "\x25\x56\xee\xa9\xe4\x97\xb4\xfb\x4b\xe1\xd2\x0c\xaa\xed\x16\x05\x9a\xed\x1a\xc6\x9a\x41"
          "\x0f\xf5\xf5\x70\x7d\xde\x90\x87\x9a\x37\x67\x81\x6a\xa3\x32\x9c\xce\x12\x1f\xa6\xac\x5d"
          "\xcb\xf7\x1c\x97\x08\x6a\x00\xe4\x73\x6c\x26\x95\x35\xf3\x1b\x03\x09\xf1\x94\xa7\x28\xc0"
          "\x8c\xf4\x79\xb7\x5c\xcc\x5f\xbb\xfc\x43\x94\xe4\x1e\x02\x9e\xfb\xc2\x04\xd1\xda\xe5\x7d"
          "\x66\xfd\xfd\x30\x32\xa4\x20\x08\xe3\x34\xd0\x57\xd6\x29\xfc\x84\xd5\xb1\x70\xdf\x39\xa2"
          "\xf2\xd4\x4a\x00\x64\x62\xab\xdb\xcc\x8c\xc7\x2a\x43\xa7\x77\xba\xfe\x11\xcb\xc2\xbf\x2a"
          "\xde\xdb\x05\x23\x48\x16\x73\x3f\xf7\x04\x14\x1b\xeb\xa4\xd0\xc7\x09\x7c\xfb\x02\xc0\xac"
          "\x76\x78\x04\x31\x02\xc1\x04\x76\xdd\x11\x97\x24\xbc\x17\x55\xd1\x27\x15\x56\x1b\xb4\x46"
          "\x17\x79\x6a\xd9\xcf\x6d\xb2\x5a\xff\x8e\xa9\x9e\x56\x4c\x48\xfc\xd6\x2c\xd4\xbb\x81\x51"
          "\xe5\xe6\x51\xef\xca\x20\x9e\xb5\xdd\xff\xc3\xf6\xa1\xd8\x7a\xeb\xf4\x78\xae\x01\x3a\x80"
          "\xb1\x64\xed\x73\x00\x39\xf9\xf3\x0a\xee\x42\x8d\xab\xe2\xe6\xc5\xea\x58\x3f\x1e\xd8"
          "\x90",
          1, 2816 },
        { 128, 192, 54,
          "\x06\x68\x96\x96\x6f\xd1\x8c\x90\x19\x26\x1d\x28\xd3\x53\xa8\xf4\x2b\x8f\xd9\x1e\x20\x49"
          "\x91\x5e",
          "\x63\x75\xa0\x91\x0f\x52\xbf\x65\xde\x11\xac\xcd\x85\xad\x10\x9c",
          "\x3d\x42\xd9\xd6\x6e\xe8\xdd\x56\x66\xdb\xc8\xc3\x56\xb4\x54\x1c\xab\xbc\x2a\x04\x78\x09"
          "\x72\xd9\x96\x8b\xff\x4f\x90\x00\xf4\x7c\x35\x95\xf2\xef\x1d\x7e\x10\xaf\xac\x3a\xa1\xa4"
          "\x12\xc3\x3f\x9e\xc9\x20\xbd\x3e\x63\x2e\x0e\xb5\x8f\x1d\xb9\xa5\x4d\x29\xb7\x90\x6a\x47"
          "\x67\xaa\x8f\x7f\x71\x7d\x88\xd5\x0d\x9d\x37\x5c\x6c\xb1\x65\x76\x17\x3d\x2d\x85\xfd\x57"
          "\xbe\x58\x30\xbd\x60\x74\xe3\x4b\xf8\x01\x31\xb8\x32\xb7\xd0\x88\xf6\x24\x71\x4a\x10\xff"
          "\x3a\xfc\x64\x6e\xe4\x5f\x7d\x1e\xee\xd9\x47\x31\x0e\x62\x5b\xa5\x05\x62\x2d\x57\xb7\x7a"
          "\x06\x15\xf0\xf5\x19\x49\xb0\x57\x14\xe9\x7b\xab\x35\x20\x88\x8e\x90\x47\x27\x78\x25\x57"
          "\xae\x0a\xfd\x9c\xd9\x36\x1e\x1d\xc7\x73\xb0\xe5\xca\x56\x4c\x82\x9d\x4b\xdb\xa5\xcb\x1f"
          "\x99\x3b\x77\x11\xd6\xef\x33\x0a\x2a\x23\xa5\xac\xf6\xce\xd8\xee\x6d\x00\x77\xe4\x9a\xcc"
          "\x44\xa4\x69\x4a\xdb\xa4\xb1\xdf\x7d\xb0\x3c\xe4\x83\x84\x7a\x0c\x8c\x91\x28\x24\x89\x39"
          "\x2f\x84\x5f\xc8\x91\x4c\xfb\x86\x49\x4a\x71\x0f\x83\x8f\x44\xc3\x96\x23\x22\x13\x8d\xc5"
          "\x3f\x89\x9a\xf4\x98\x69\xf7\x26\xcb\x4b\x50\x57\xea\x91\x42\xe0\xd2\xb9\xb1\x0c\x6d\x6a"
          "\x5a\x31\xc5\x16\x5d\xea\xf3\x8c\xca\xf2\x00\x34\x90\x99\x55\x5b\x7d\x19\xa2\x6b\x0a\xc4"
          "\x98\x03\xac\x5b\x3e\x12\xc1\xc4\xc8\x37\x01\x92\xc2\x05\xdb\xb0\xd5\x0e\x58\x5f\x6c\xc5"
          "\xc2\x16\xce\x2a\x05\xba\xa0\xe8\x7f\x6a\xd5\xc5\x8c\x0a\xf9\x72\x91\x79\xae\xfc\xd6\x3d"
          "\x85\x40\x81\x39\x80\x63\x0e\xe6\xaf\x2b\xa6\xcb\x94\xa5\x8c\x25\xc5\xca\x79\xa2\xaa\xa8"
          "\xd9\x58\xe0\x46\x74\xfa\xc8\x9e\xa2\x25\x42\x77\xaa\xeb\x29\xdf",
          "\xe9\x59\x53\xcb\xd6\x3c\xce\x46\x32\xaf\x32\x0c\x58\x58\x91\xd0\x48\x70\xc4\xff\x23\x5b"
          "\x4a\x6f\x5d\x1a\x80\xa2\xf4\xc8\x99\xa6\x6f\xbf\x65\x63\x97\x27\x2a\x45\x60\x70\xaf\xf8"
          "\x48\xfb\x7d\xd7\x85\x8b\x09\xa1\xd1\xe4\x9b\x07\x06\xd0\xa0\x18\x0b\x30\x4e\xf2\x42\x27"
          "\x88\xe8\x3c\x6a\x91\xbf\xcd\xda\xc6\x98\xa6\x28\x33\xc4\x93\xe3\x4e\xdc\xea\x26\xa0\x4c"
          "\x74\xfd\xea\x74\x78\x46\xfe\xb7\xd1\x69\x44\x87\x6a\xfa\x52\xa0\x4f\x35\x07\x97\x1d\x11"
          "\xb7\x31\x0b\x2c\x33\xa2\x93\x28\xfa\x97\xa6\xde\x06\x5b\xe0\xcf\x11\xb1\x64\x0b\x41\x49"
          "\x5d\xb9\x81\x0e\x3c\xbd\xf7\xd8\xfd\x1b\xd3\x82\xd3\x56\x51\x53\x21\x76\xeb\x5d\xfb\xfa"
          "\xc5\x58\xb2\x27\x0e\x52\x35\xc6\xfe\x0c\x62\x92\xd2\x8e\x75\x84\x7e\x0c\xd9\x89\xef\x78"
          "\x2f\x4b\xd4\x69\xdd\x79\x1c\x18\x15\xfa\x76\x5c\x5b\x03\x9b\x2c\x3f\x15\xd2\xd4\xc2\x9a"
          "\x3e\x68\xda\xcc\x12\x2e\xff\x4e\x7f\x49\x12\x17\x42\x6b\x8c\x51\xe0\x4c\xc9\xa9\xae\x98"
          "\xe1\x31\x9a\xc9\xb9\xe5\x8c\xb0\x5e\x77\x17\x45\x25\x39\x1a\xdc\x6e\x5f\x3f\x7a\xdd\xcb"
          "\x50\x32\xbf\xa0\xc1\x0c\xc9\x33\x34\x02\xe2\xd7\x38\x60\x10\x39\x0c\xb3\x2a\x66\x5e\x0c"
          "\x16\x33\xb3\x25\x99\xaa\x3e\x93\xdc\x60\x2f\xc3\x40\x80\xa4\xd2\xc9\x20\x77\x05\x27\x61"
          "\xe4\xbc\x30\xf2\x5d\x14\xa2\x9c\xda\x4b\x6c\xd1\xc4\x5c\x31\xc9\x0f\xa7\xe0\x4f\x72\x9b"
          "\x28\x02\x86\x27\xc7\xce\xa4\x50\xc1\xd9\x41\xcd\xd7\x60\xa8\x65\xa2\x17\xa6\xf2\x0f\x49"
          "\x75\x86\x83\xd2\x03\xaf\x2d\x0a\x21\xff\x0d\x1a\x3a\x72\xc8\xf4\x4d\x0c\xfb\x3a\x89\x6f"
          "\x3e\xb1\xbd\x73\x1c\xd0\x46\xcb\xcd\xa1\x51\x01\x3d\x63\x13\x6c",
          1, 2944 },
        { 128, 192, 55,
          "\xeb\x9d\x9a\x6d\x9a\xc6\x90\x10\x93\x2b\xdb\xa3\x56\xb0\x9e\x26\xe9\xbd\xaa\xd1\xe6\x51"
          "\x5f\x76",
          "\xc9\xbb\xda\xee\xbf\x00\x81\x48\x36\x0e\x2b\x6a\x36\xe3\xb7\x56",
          "\x56\xb5\x4b\x67\xcc\x52\x8f\x56\x97\x6b\xef\x8c\x4a\xda\x89\xe7\x26\x9f\x2b\x75\x99\xc2"
          "\x0e\xb5\x8d\x2e\xdb\xcc\x70\xb7\xb2\x87\x16\x7b\xf1\x14\x3d\x7a\x2f\x80\xab\x0c\xce\x13"
          "\x21\xee\x19\x71\x96\x84\x26\x4d\x8a\x40\xeb\x8e\xdc\xd3\x5e\x99\x5e\xac\x50\x1f\xcd\x33"
          "\xee\x09\x21\xb0\xbc\x79\x22\xd6\x4b\xf0\x39\xfc\x2e\x04\xad\x2b\xbb\x1c\x8b\xeb\xbd\x90"
          "\x91\xf2\x00\x14\x65\x0a\x59\xef\x7b\xe6\x47\x24\xfa\xf2\xff\xb0\xb3\x41\xb2\x25\x7b\x8f"
          "\x1a\x01\x88\xb0\xac\xa5\xfa\x67\x3c\xdb\x44\xa3\x10\x39\xd6\xd8\xd5\x06\xd7\x9b\x1e\x27"
          "\x44\x9c\x39\xe2\x98\x8a\x05\x4d\x90\x96\x9e\xcd\xee\x66\xbe\x2c\x2f\x54\x37\x47\x4c\x1f"
          "\x26\x4a\x20\x52\x41\xc6\x8a\x79\xc7\x2b\xc8\x5b\x90\x46\x2d\x91\x1d\x66\xab\x64\xde\x59"
          "\xd7\xa4\xac\x20\x1f\x69\x57\xd8\xed\x5b\xef\x11\x79\x06\x6a\xc2\x04\x87\xd9\x98\x0d\xf6"
          "\xc9\x06\x7d\x79\x85\x05\x35\xe4\xd5\x81\xd0\x05\x94\x39\xed\x38\xbd\x97\x2a\xae\xed\xd4"
          "\xe0\xf8\xa7\xc8\xa0\xb3\x96\x75\xe8\xca\x4d\xb4\x5e\x5d\xf8\x49\x77\x95\xab\x35\xbb\x68"
          "\x32\x1d\x75\x40\x3d\x6c\x63\x96\x88\xe2\x1b\xf6\x7e\x97\x98\x64\x4e\x71\x5b\xbf\xe7\xbb"
          "\x49\x21\xba\x65\x96\xb8\x00\x09\xe2\xaf\x65\xb0\xd8\x99\x2b\x92\x5c\x8f\x89\x76\xa3\xae"
          "\xde\x9e\xbd\x73\xd7\x08\x3e\xe5\xcd\xb5\xb7\xb1\x6a\x0f\x86\x61\x83\x7c\x78\x40\x5a\x4c"
          "\xb6\x8f\x3d\x0b\x9e\xf2\x6c\x30\x5c\x86\x0b\x1f\x6e\xb7\x13\xfb\x55\xfc\x29\x9a\xb3\xc1"
          "\xbe\x24\xb7\xbd\xe5\x91\x36\x8a\x63\xfa\xcd\x19\xc0\x9b\x89\x42\xd5\x4b\x63\x69\x72\x10"
          "\x89\x85\x90\x1d\x34\x32\xa8\x60\x81\xd3\x68\xc2\x17\x85\xf8\xd4\x41\x92\x46\x2b\xe4\xd9"
          "\xa0\x28\xbd\x4f\x0b\xad\x5c\x6b\xf3\x48",
          "\x10\xbb\xc2\xca\xfb\xaf\x74\x50\xcf\x4a\x48\xe2\x69\x97\x43\xef\xc0\x59\x61\xe2\xc1\xb4"
          "\x75\x07\xa9\xd9\x09\x94\x98\x90\x2d\x70\x12\xbc\xa4\x31\x4e\xce\xa5\xae\x6f\x3d\xb7\xdc"
          "\x5f\xb1\xdf\x90\x98\xe0\x0a\x42\x28\x1e\x22\x15\x83\xe2\xe0\xe9\xc9\x13\x5c\x68\xed\x21"
          "\xbb\x83\x1a\xc8\xd5\xee\x55\x87\x6e\x2c\x62\x40\x3a\x09\xe4\xf8\xca\xc7\x1a\x68\x3e\x87"
          "\x38\x50\x96\xd2\x85\x9f\xce\xa2\xe2\x2e\xb0\xf1\x0e\xc9\x7a\xbd\x5b\x55\x4c\x0c\xa1\x58"
          "\x11\x5c\x18\x8b\xc3\x9b\x92\x08\x8a\x57\x88\x38\xe8\xfa\x0b\x23\xe3\x7e\x85\xc8\xff\xd3"
          "\x13\x71\x30\x3b\x9a\x59\x2d\x54\x3a\xae\x4e\x29\xb5\x1f\x5a\x30\x87\x44\x54\xf3\xfc\x91"
          "\x46\xef\x83\x8b\x94\xf4\x0b\x1b\x5e\x43\xbd\x15\x71\x60\xad\x71\x3d\x01\x1f\x7e\xe3\x5c"
          "\x6c\xd4\x4d\xd7\x3b\x07\xea\x3b\x38\x9d\x11\x72\x27\xd4\xe0\x27\xf5\xbd\x3f\xac\x17\x4b"
          "\xd4\xf2\xee\xaa\xfd\x7d\xdf\x09\xc6\x48\x93\x0c\xaa\xa0\x79\xc8\xb5\x9e\x1c\x2c\x8b\x27"
          "\xff\xb7\x77\xbf\xe2\xf1\x5c\x31\x18\x11\x72\xd8\x5e\xa0\x75\xce\xc5\x02\x67\x3d\x89\x7d"
          "\x78\x35\xe1\xf2\x9b\x3a\x97\xab\x26\xc9\xdc\xe8\x94\x0c\x96\xe8\x43\xdf\xd1\x5a\xce\x1b"
          "\x17\xe2\xfa\x44\x01\x81\x56\x72\xec\x9e\x30\x90\x97\x54\x1a\x6b\xae\x0f\x41\xa1\x5d\x76"
          "\xa6\xca\x95\x17\xcb\xe8\x1c\x44\x51\xb8\x7d\x3a\xb5\x47\x3a\xd2\x85\x72\x7f\x80\x49\xd9"
          "\xac\xe3\x77\xef\x31\xb0\x77\xb6\x46\x58\xff\x87\xc6\x0f\x7b\x5b\xad\x99\xf3\x63\xb0\x49"
          "\xfd\xf0\x4b\x54\x27\x59\xe7\xae\xac\x4e\x14\x6f\x22\x3b\xf0\x16\x41\x57\x0a\x2c\x4c\x5c"
          "\xe7\xad\x08\x5c\xb4\xa1\x32\x29\xd3\xea\x55\xb1\xf6\x04\x52\xb8\x5a\xd5\x86\x98\x91\xef"
          "\xc4\x33\x9c\xe3\xa0\x9e\x06\x06\x2b\x6d",
          1, 3072 },
        { 128, 192, 56,
          "\x77\x76\x32\xdf\xcf\xb2\xbd\xa8\xd3\xc0\x81\xfe\x12\xba\x48\x39\x72\x02\x90\x91\xb3\xb6"
          "\xcb\x9c",
          "\x3c\xc1\x69\x56\x41\xb8\x1b\x3c\x22\xec\xa1\x63\xa7\x01\x77\x22",
          "\x45\xcf\xce\x57\xe2\x6d\x96\x56\x46\x28\xaf\x55\xea\x83\x5a\x79\xac\xf8\xb9\xa6\xdf\x14"
          "\x3e\xe4\x5e\x4c\x74\xe4\x34\x1c\x9b\xbb\x97\x0e\x40\x8a\x0e\xfa\x58\x24\x96\x4e\xc6\x1b"
          "\x7e\xec\x3f\x2e\xb9\xbc\xad\x71\x2d\xe2\x4b\xdc\x55\x7f\x6c\xc2\x90\xc1\x37\x60\x36\x4b"
          "\xd5\x7c\xc8\x4d\x05\xba\x00\x29\x33\x3c\xb4\x33\x65\x44\x6a\x01\x02\x56\xc7\x47\x33\x93"
          "\x34\xf0\xa7\xb0\x13\x5d\x3b\xc6\x16\x4f\x9a\xe2\x05\x1b\x47\xb6\x12\xa3\xec\x08\xa4\x66"
          "\xf2\x2c\x45\x3c\x02\x0d\x0e\xd8\x2d\xb9\x84\x6b\x4f\x34\x65\x92\xab\x37\x48\xb1\xac\x81"
          "\x17\x12\x22\xfe\x75\x62\xec\x11\x1b\xfa\xaa\xa7\x2d\x40\xfe\x8e\x4a\xdc\x88\x5b\x9a\x56"
          "\xa0\xea\x5a\xa0\xec\x48\x30\x15\x7b\xe3\x89\x29\xe6\x0c\x7a\x74\xe6\xe6\x5a\xdf\x21\x06"
          "\xe9\xe9\x74\x0a\xf7\xbf\x0a\x80\x40\x7f\x40\x40\x36\x80\x9b\xfc\xaf\xae\xe2\x5f\xc7\x2a"
          "\x35\x29\xe8\x21\x21\x40\x2c\x9a\x1c\x6f\x44\x52\x18\x82\x4a\x84\x70\x94\xd0\x3c\xd3\x55"
          "\xea\xc3\x3d\x55\x7b\xed\x20\xd2\xfc\x29\xe4\x4f\xa4\xfa\x49\x85\xe7\xb0\xb4\x6e\x6f\x3e"
          "\xbf\x99\x55\x79\xdf\x8f\x31\x33\x53\xc5\x3f\xfd\x5e\x01\x7f\x37\xc5\xee\x27\xad\xcf\x4f"
          "\x83\x07\xac\xac\xb2\x5c\x21\x9d\xaf\x95\xb2\x51\x49\x3e\x97\x5f\xf3\x6a\x6b\xbd\xc8\xf7"
          "\xec\x76\xd9\x0d\xfb\x75\x3b\xeb\x81\x6f\xb8\x65\x6a\xdc\xce\x40\x13\x0a\x37\x7c\x7b\xaf"
          "\xc7\xa6\x0d\x8f\xe6\x1d\xae\x68\xcc\x36\xf9\x28\x5b\xb0\xc1\xbe\x9f\x93\x3c\x8d\x22\x6c"
          "\x0b\x4a\xf2\x66\xd3\x2b\xce\x3a\x54\x8e\x67\x3d\x43\x91\x15\xae\x68\x6b\x9b\x11\xcd\x46"
          "\xcb\x28\xce\xdd\x30\x17\x48\x13\x78\x6e\xd3\xed\x29\x59\x3a\xe2\x96\xec\xa1\x21\xa5\x5e"
          "\xbe\x57\xbd\x7c\x9b\xd9\x96\xe9\x36\x31\xa0\xe5\x1a\xdb\xe6\x9b\xa4\x88\x00\xf2\x3f\x8c"
          "\xfc\x05\x86\xc7",
          "\x40\x4a\x14\xfd\x40\x3c\xd4\x0a\xaa\xf0\xfc\x7b\x52\xf7\x68\x48\x23\xca\x4d\x70\xf4\xee"
          "\x42\x3b\xe0\xc3\x28\x5b\x7d\x8b\xe7\x6b\x42\xda\xe3\x2f\x56\x81\xf6\x23\x59\x2e\x13\x75"
          "\x7a\x1b\x4a\xfe\xa4\x1b\x78\x1a\xb8\x89\xc1\xc8\xf1\xc3\x55\xa8\x0c\x76\x68\x10\xcb\x49"
          "\x96\x7e\x72\x6c\x8a\xc2\x11\xa2\xc2\x1d\x7c\x2d\x84\x61\x9e\x14\x91\xd7\x70\x59\xc9\xce"
          "\xfb\x04\xa4\xb0\x6a\xff\x9a\x01\x69\xdf\x4a\x66\xfb\x01\x4e\xaa\x42\xa0\xa9\x4b\xe0\xa2"
          "\x17\x7d\x7e\x64\xdb\x97\xf3\x65\x00\x6f\xa5\xac\xad\x33\x41\x04\xd6\x36\x99\xb5\xa5\x5f"
          "\xb3\x19\xb0\x6a\x25\x45\x1d\xa3\x9e\x45\x55\xd7\x3d\xd3\x7b\x7d\xfa\x64\xb5\xb4\x3d\xc7"
          "\xf7\x70\x46\x2c\x03\xf0\x06\x31\x92\xbf\x44\x62\x8a\x10\xb0\xa4\x3d\x32\x17\xab\x1e\x3b"
          "\x3d\x32\x70\x55\xfc\xc6\x3d\x85\xf1\xaa\x76\x83\xf4\xa3\x3e\x1c\x4b\x27\x15\x47\x30\x51"
          "\x4e\x8c\x22\x76\x45\xfc\xe6\x79\x60\x86\x82\x4f\x23\xd9\x1f\x92\x80\xf0\x48\x3c\x67\x23"
          "\x18\xcf\x4c\x62\x4a\xb3\x75\xc8\x1c\x56\x4a\xcf\x8f\x15\x07\xd1\xa3\x1f\x4b\xa3\xee\x2a"
          "\x30\x2d\x37\xf9\x66\xb5\x9a\x0a\x0f\xaf\x20\xa2\x00\xa8\xc4\x2e\x1f\x43\x86\xe2\x55\xfc"
          "\xc3\xfe\xde\x8d\x42\xc2\x6f\x5a\x3e\x9d\xc6\xb0\xbd\x3a\xaa\xe8\x25\x9e\x3a\x35\x45\x5d"
          "\x6c\x8d\xae\x6f\x48\xcb\x37\x18\xce\xb3\x00\x0a\x07\x16\xa4\xae\xbb\x74\xd0\xc6\x1d\xa0"
          "\x33\xc9\xea\x60\xb9\x67\x57\xb1\x95\xbc\x44\x4b\xc4\x81\x56\xf9\x27\x4e\xca\xdb\x67\x77"
          "\xa3\x93\xe1\x3c\xf0\xf9\x3f\xa1\x37\x17\x32\xbc\xf9\xe8\x47\x58\xe8\x3d\x6c\x8b\x8a\x56"
          "\x50\xa8\xc4\x41\xa8\x21\xaf\xf6\xb6\x26\xef\xb4\xd6\xd1\xca\x07\x71\x8d\xc0\xe8\x61\x65"
          "\x8c\x2a\x3c\xb6\x99\xe8\xd6\x81\x40\x4f\xde\x76\xe9\xc1\x19\xb8\x65\x3f\xec\xb8\x77\x04"
          "\xe7\x23\x84\xe3",
          1, 3200 },
        { 128, 192, 57,
          "\x7f\xf8\x25\xdc\xd0\x8e\x5a\xa7\x55\xdc\x90\x66\xcc\x11\x46\x3b\xbd\x71\xaa\x1a\x01\x91"
          "\xd8\x67",
          "\xec\x6f\x70\x6f\x00\xa5\x2e\xb7\x9f\x2c\x8d\xd4\x30\x2c\x0c\x36",
          "\x68\x5f\xe4\x03\x0d\xf7\x89\xc6\xae\xad\x03\xb7\x33\xd2\xef\x7e\xc4\x42\xb2\xe7\xee\xe2"
          "\xc3\xad\x65\x7e\xfa\x81\xe7\x2e\x7a\xce\x69\xaa\x1b\x31\x0c\xea\x8e\x0a\x20\x0b\xe7\xff"
          "\x3f\x1c\x99\x6e\x9f\x99\x87\xfb\x0c\x6b\xb2\x89\xdd\x23\x0e\xc1\x98\x45\x50\x78\x34\x22"
          "\x76\xfb\xaa\x07\x09\x86\xef\x1d\x36\x27\x89\xbe\x60\x54\x0e\x5f\x59\xfb\xf1\x63\xa2\x7d"
          "\x1f\xa4\xfc\xa0\x6a\x87\x52\x4c\x41\xad\xe5\x27\xb8\x0a\x70\x97\xf0\x68\x09\x93\xad\xe0"
          "\x39\x4a\x52\x57\x8b\xeb\xf8\x7c\xf7\x72\xf5\xfe\x2b\x85\x2a\x01\x82\xc6\xe9\x36\x45\x03"
          "\x05\x78\xb6\x53\xa5\x7b\xfb\x16\x0d\xfe\x8e\xdb\x0d\xac\x58\x95\xf2\xd9\xc8\xd3\x2d\x50"
          "\x3a\x45\xcf\x2f\xd4\x58\xb7\xa2\x53\x50\xdc\xe4\xc9\xc7\x65\xf1\xad\xa6\x78\x96\xc5\x72"
          "\xf0\x1c\xa3\xd3\xa0\xc0\xae\xd5\xc9\xc4\xfb\x5b\x8f\xbd\x8e\xd8\x97\xc9\x90\xad\x8d\xe5"
          "\x4c\x60\xd5\xe1\x3c\xc7\xb6\x77\x44\x76\x17\xca\x6c\x9b\x6a\x42\x4c\xa0\x2f\xc5\x25\xfc"
          "\x1d\xf8\x9b\x58\x52\x33\x45\x1a\x9b\x34\x15\xc2\xf4\xd6\x9a\xb5\x27\x95\x64\x2f\x55\x70"
          "\x53\x29\xb0\x4d\x02\xa1\xb1\xd2\xed\xf2\xc4\x0f\xbc\x0c\x81\xda\x3e\x8e\xc1\x96\x52\xed"
          "\x4e\x34\x2a\x89\xd1\x69\xf8\xd9\x87\x84\x6a\xd1\x73\x8d\x6a\xb0\xc4\x2a\x82\x5c\x81\xdf"
          "\x0e\x10\x53\x02\x65\x57\xa0\x49\xdb\x0f\x63\x38\x2f\x21\xcb\xc9\x9f\x4d\x4e\x3e\x10\x66"
          "\x11\x7c\x54\x9c\x78\x30\x99\x14\x89\x97\xae\xb7\xfd\xc9\x6b\xc7\xac\x22\x14\x5c\x64\x64"
          "\x3d\x60\xee\xd2\x5a\xa8\xfd\xf8\xa7\x1c\xa1\x5b\x79\xa3\xba\xc3\x6c\x8e\x8a\xdc\x63\x2a"
          "\xb1\x61\x0a\x4b\x04\x3a\x04\x84\xc8\x65\x7d\x22\x4a\x8d\x3b\xbe\x0c\x44\x25\xbd\xe1\xca"
          "\xad\x01\xf3\x69\xe4\xbd\x06\xa7\x51\x25\x26\x6a\x75\xb1\xf4\x73\xdf\x7c\x3e\xb7\x26\x2d"
          "\x01\x40\x19\x7a\x70\x66\x8b\x5f\x92\x1c\x9f\x38\x7b\x85\xd3\xba\x55\x34\xa4\x46",
          "\xfe\x4d\xae\x25\xb2\xaf\xcf\xd6\x01\x4a\xc2\x4f\x68\xc4\xd3\xec\xb3\x56\xab\xc7\x51\x9d"
          "\xc9\x5b\x20\x70\x92\x16\x67\x59\x47\xbf\xcd\xe2\x3a\x23\x7a\x10\xba\xd6\x02\x21\xcc\x98"
          "\x3f\xf3\x30\x51\xa4\x21\xfc\x75\xb9\x3b\x45\x37\xb1\x35\x43\xe4\xc9\x13\xba\x23\x6c\xaf"
          "\x12\xf8\x9d\xa8\xf4\x2d\x0a\x7e\x75\x78\x1d\x0e\xb0\x57\x5b\xc4\x81\xf9\xd0\x76\x79\xb2"
          "\x55\x1a\x11\x26\xb5\xb4\x86\xd1\x86\x18\x0d\x2b\x4d\xd0\xa1\x79\x8c\xb0\x9a\x8c\xa9\xeb"
          "\x83\xe5\xa3\x49\x37\x3b\x5d\x20\x0f\x3d\x58\xb8\xaf\xe9\xd9\x56\xa4\x2f\xe5\x44\x00\xb0"
          "\x65\x6e\xa6\x0e\x2e\x04\x56\x0c\x79\x74\xa1\xe5\xa4\x40\xba\xe9\x73\xaa\x50\x7e\x00\x30"
          "\xed\x77\x52\x42\xd5\xb7\x36\x35\x26\xca\x28\xe3\x97\x7c\x86\xaa\xf2\x87\xc0\x56\xd6\x9d"
          "\x28\xa8\x95\x5d\x84\x2c\xca\x56\x10\x18\xc5\x3c\xed\xad\x7f\xee\x21\x55\x96\x64\xc9\x0e"
          "\x9f\x6b\x2f\x41\xf9\x4a\x23\x6f\xd8\xac\x73\xd2\xd1\xb9\x42\x5c\x9e\x69\xff\x1b\xbf\xe3"
          "\x13\xdf\xc7\x3d\xe2\x41\xf9\xce\xb9\x96\x74\x6a\x7f\x1f\x42\x3f\xaa\xf7\x80\x1d\x3a\x52"
          "\xde\x70\x27\x02\xa5\x0f\x48\x4b\x8e\x74\x2f\xb7\xb2\x21\x18\x5a\x13\xc8\xa3\x34\xeb\xd1"
          "\xb9\xaa\xc3\x48\x24\xb9\x4f\x86\xef\xb3\x51\xb7\x6c\xb9\x41\xc5\xbc\x53\x1a\x01\xcc\x9e"
          "\x82\xba\x8a\x92\xd0\x5b\x76\xb0\xee\x1b\xa2\xa7\x27\xdf\xab\x30\x60\x23\x74\xe1\xc6\xc3"
          "\x97\xa0\x67\x71\xcd\x80\x98\x06\x46\x0b\xc3\x16\x73\x37\xb2\xf7\x60\xfc\xf4\x39\xd2\x98"
          "\xad\x1b\xad\x07\x62\x72\x5c\x2c\x83\x08\x46\x86\x9f\x95\x09\x13\x8d\xa5\x9f\x50\xd8\xbb"
          "\x63\x28\x82\xec\xff\xaf\x8a\x89\x70\xec\x77\xb8\x0a\x92\xbc\x42\x71\x51\x87\xc3\x76\xa3"
          "\x03\x37\xfc\x32\x1c\xf4\x7e\x20\x2e\x10\xc7\xa3\xc4\xe2\x9e\xfb\x1a\xce\x5b\xb0\x46\x19"
          "\xe9\x0c\x79\xd2\xe5\x13\x6b\xfa\xd5\x4a\xc9\x7a\x9e\x5e\xa7\xd1\x7e\x0d\xae\x72",
          1, 3328 },
        { 128, 192, 58,
          "\xff\x4c\xe5\x9a\x28\x7a\x83\x76\xd4\xcf\x7f\xff\x93\xb4\xd4\xa3\x16\x68\xa8\x9b\x0f\x48"
          "\x67\x66",
          "\xf0\x2f\x79\xa0\x9e\xe3\x17\x1f\x59\x57\x63\xf9\xd3\x5e\x50\x94",
          "\x4c\x83\x68\x9d\xfe\x8f\xe4\x61\x2e\x32\x23\xee\xb0\xfc\x2a\x49\x1a\x85\x1a\x07\x16\x7e"
          "\xd0\x06\xac\xc7\x9d\xfe\x71\xa8\x3e\x25\x17\xba\x01\x8f\x07\x00\x5a\x78\x04\x88\xd0\xd3"
          "\x1e\x65\x43\xf9\xd4\x15\xeb\x74\x09\x1b\xd6\x3f\x70\xc4\x28\xd5\xa4\x82\xb1\x9d\x13\x2c"
          "\xba\xf9\x22\x9a\x67\xa4\xb5\x00\xcc\x3f\xa1\x83\x1d\x82\xe4\xe2\x74\xca\xd7\x5d\x10\xf9"
          "\xa5\x61\xd6\x16\x95\x60\x64\xe7\xc9\xdb\x1f\xee\xa6\xe2\x07\xdc\x39\xe4\x3d\x39\x95\xf2"
          "\xfe\x11\xb3\x32\x0a\xa4\x38\x26\xbc\xc8\xb0\x81\x65\x37\x0f\x43\x7d\x3d\xd2\xe2\x94\xfa"
          "\x0d\x71\xeb\x4b\xa4\x36\xdf\x0c\x44\x77\xca\x12\x9c\xdb\x94\xd6\x29\x0b\xc8\x4d\x0a\xc3"
          "\x5d\xd1\x5b\x1d\x57\xb6\x03\xad\x6a\x8b\x51\x43\x42\x23\xf0\xd8\x1f\x65\x98\x46\xeb\x4f"
          "\xb6\xa4\x7d\x59\x91\x06\xa4\x69\xee\xa8\xd8\x25\x18\x13\xd7\xe9\x95\xc4\xf7\xfa\x46\x7f"
          "\x8d\x7b\x6d\x48\xf4\xb1\x03\x92\x3c\xe4\xa3\x33\x92\x20\xc5\xfd\xce\xef\x40\xff\x68\x71"
          "\x7c\x86\x94\xe7\x80\x59\xc1\x39\x5d\x4b\xc5\xb3\x1b\x0c\x8d\x03\x97\xd1\x70\x7d\x5b\xee"
          "\x7b\xda\x85\x5a\xd4\x8d\x0c\x43\x0c\xfa\x56\x13\x30\xb8\xd4\x3b\x56\xab\xd4\xc0\x49\x16"
          "\x37\x3d\x71\x57\xfb\x4d\x2d\x8c\x34\x6a\x90\x5c\xa7\x47\xa1\x74\x54\x01\xd5\x3c\x40\x78"
          "\xc3\x83\x61\x78\xc4\x80\x37\xe3\x45\x75\x33\x50\x98\x84\xf8\x48\x77\xe2\x45\xcb\xed\x0e"
          "\xad\x21\xce\xf6\x71\x22\x49\x05\x47\xb8\x91\xcc\x3e\x64\xcd\x5a\xa4\x33\x86\x15\xc7\x7f"
          "\x8d\xf7\x65\x21\x33\x3d\xed\xcb\x7a\x23\x88\x7a\xcf\x41\x5c\xcc\x69\xa5\xf2\xae\x97\x26"
          "\x2b\xa8\x50\x67\x0f\x78\x75\x21\xe4\xb1\x3f\xcc\x1b\x69\x1a\x39\xb9\xe7\x23\x76\x80\x5c"
          "\xf8\xcb\x25\xc4\x39\x52\x46\xd9\x38\x31\x81\x52\x87\xfb\xb1\x5c\xd0\x4b\xa7\x9c\xde\x74"
          "\x45\x6e\x5f\xe2\xf7\x13\x79\x35\x5c\xe9\x9c\x56\x2e\x86\x1b\x7d\x33\x2c\xfa\xd0\x1a\x7a"
          "\x38\x83\x3a\x56\x11\x31\xbf\xf5\x01\x9e\xfa\xb8\xe5\x11",
          "\x62\xe4\xac\x36\x47\x12\xd4\x39\x9b\xde\x6f\x6b\x20\xae\xb8\x75\xfd\x9b\x8f\x17\x4d\x01"
          "\x18\xc5\x85\x99\x2c\x64\xb8\x1a\x24\x25\x6e\xfc\x99\xe5\xed\x81\xe9\x13\x02\x4d\x85\x15"
          "\x17\x8c\xcd\x60\x00\x2a\x5e\xdd\xf6\x6e\x09\xe2\xf1\x90\xfc\xe4\x04\x16\x3f\xc4\xcd\x80"
          "\xc5\x12\x24\xea\xd4\x2f\x05\xc8\xc7\x2c\x61\xa6\x9a\x76\xa3\x44\x57\xef\x8a\x84\x43\xad"
          "\x62\xe9\x4c\x79\x36\x8c\x38\x17\x2a\x34\xb8\x81\x50\x3c\xbf\x7b\xa6\xbe\xa7\xae\x09\x3a"
          "\x0b\x4f\xd6\x90\xf7\x9a\x2f\xb4\x1d\x18\x2b\xbc\xdc\x3c\xb1\xbd\xc4\xda\x5a\xc6\xc2\xf0"
          "\x68\x49\xc8\x2b\x69\x5d\x5a\xee\xe8\xec\xcb\x77\x98\x85\xe9\x89\xc9\xab\xfd\x91\x81\x3c"
          "\xc4\x54\xf6\xf0\xa7\xf3\x4d\xda\x62\x16\x84\xfd\x6f\xc7\xb3\x83\x7b\x87\xd4\x3d\x23\xe8"
          "\x12\xbc\xb4\xb9\x12\xa7\x4a\x24\x3f\x49\x5a\xf5\x17\xde\xaf\x36\x5a\x20\xcb\x6a\xfe\x38"
          "\xee\x99\xfa\x60\x83\xcf\x68\x24\x5e\x72\x04\x5e\xc3\xca\x22\x66\x1c\x9d\x2b\xe0\x60\xd7"
          "\x65\x63\x08\x70\xe8\x3e\x50\x74\xfc\xd6\x5c\x1e\x82\x73\x63\x3d\x75\xf1\xc6\x86\x19\x92"
          "\x3c\xb1\x8e\x78\x76\x1b\xec\x00\x28\xa9\x42\x74\x85\x3a\x8c\x16\xa8\x5e\x31\x10\xc0\xd1"
          "\x27\x95\x13\x86\x2d\xac\x49\xd3\x06\x2a\xd1\xb1\x78\x1a\xf1\x35\x0a\x9d\x21\x44\x16\xab"
          "\xf2\xa7\x8e\x84\x7b\x3c\x60\xfc\x63\x08\xe5\x5e\x74\x1b\xe8\xa7\xc6\x39\x46\xfe\x5b\x30"
          "\x19\xd3\x0a\xb5\x0a\x5a\xd9\x9b\xb7\x64\xd2\xcf\xa4\xe2\xa0\x13\x36\xc8\x29\x08\xcc\x9f"
          "\x77\xd0\xb0\x16\xcd\x63\x7c\xb1\x56\x9c\x96\xb3\xff\x1b\x85\xe3\x4c\x81\xa8\x0b\xaf\x5f"
          "\x66\xbe\xae\xe1\x93\xe3\x2c\xdb\xbe\x45\xef\x1b\x0e\x58\xee\x0d\xc6\x95\xd0\x3d\x98\x00"
          "\x3b\x8a\xc7\x00\xc5\x77\x5b\x00\xe3\xec\x7b\xfc\xc7\x0b\x16\xf0\x3b\x0f\x52\x25\x7e\x2d"
          "\xee\x28\x6f\x81\xa1\xa9\xa3\xdf\x69\x90\xc9\x19\x14\xbc\x18\x7e\x41\x59\x84\xc6\xc5\x56"
          "\xcb\x70\xd7\x8f\xe9\x8c\xe9\x2d\x25\xbb\xa3\x03\xd9\xa2",
          1, 3456 },
        { 128, 192, 59,
          "\x5a\xac\x5f\xfc\x8a\xb0\x79\x0f\x18\xc2\x99\x97\x64\xe6\x14\x9e\xec\xa5\xe1\x58\x41\x0f"
          "\x65\x40",
          "\xc9\x4c\x98\xaf\x0c\x95\xac\xac\xa3\x18\x8e\x8b\x67\xb9\xa5\xa6",
          "\xc4\x34\x63\x20\xce\xc3\x10\x4b\x03\xe5\x0c\x5b\xde\xde\x46\x69\x05\x8d\x6b\x13\x43\x73"
          "\x00\xd3\x8c\xd1\xe4\x04\x08\xbb\x5f\x39\xa7\x74\xf8\x7a\x1b\x10\x0d\x5d\x84\x2e\x5f\x3f"
          "\x18\x29\xc2\x0c\xd3\x80\x71\x7e\x1e\x9c\xa1\xb7\xf5\xcf\xf8\x33\xc0\x6c\x21\x43\x70\x04"
          "\xef\x3c\xd4\xf5\x01\x1c\x97\x49\x69\x57\x39\x4d\xf3\x46\x05\xb7\x2f\xcb\x49\x54\x9f\x37"
          "\x39\xed\x5f\x73\x24\x55\xba\x48\xa9\x53\x1f\x23\x5d\x02\x53\x57\x09\xa6\x26\x7c\xbc\x0f"
          "\xb2\xfb\x6f\x34\x55\x3c\x4b\x7d\xa0\x8b\xdd\x3d\x38\x57\x98\x2f\x8c\x6b\x5b\xbb\x3a\xd7"
          "\xcd\x1d\x8a\x8a\x65\xb5\x38\x61\x0f\xab\x42\xe2\x62\x72\x52\xa1\x51\xd8\x69\xc5\x11\xee"
          "\xa2\x1c\x18\xdc\x7b\xf6\x3c\x9d\x7b\x21\xe4\x8c\x99\xc0\xec\x19\xa2\x2a\xa2\x9d\x89\x63"
          "\x86\x60\x1d\xc1\xc8\xfd\x62\x7c\x9f\x53\xde\x0b\x3c\x4e\x2f\x40\x1d\x39\x09\xd0\x3c\x97"
          "\x5e\xb5\x0e\x4f\x0d\xa7\x47\xe5\x09\x01\xff\x80\x0e\xb9\x25\x9f\xa2\x47\xfb\x23\xbd\x3d"
          "\x2f\x9b\x15\x94\x3b\x52\x30\x83\x38\x46\x35\x80\x80\x64\x86\xfb\x17\xba\x82\x3d\x0e\x5b"
          "\xce\x3f\x59\xb8\x70\xd8\x82\xf8\x84\x46\x11\xe2\x15\x8e\xf9\x6b\x99\xe1\x91\xa8\x6f\x34"
          "\x08\x35\xe6\x44\x8d\x82\x5e\xcf\x2c\xed\xe3\x56\x07\x00\xf2\x12\x2d\xb0\x27\x4c\x56\x79"
          "\x36\x7a\xc8\x72\x31\xff\xc5\xa1\xd8\xce\x00\x28\x93\x89\xc3\x3e\x63\xcd\xf5\xed\x1d\x5a"
          "\xfa\xfd\x07\x28\x04\x5c\x20\xe8\x1a\xa4\x8c\x06\x2b\x4d\x5c\xba\x3d\x42\x02\xf3\x15\xe4"
          "\xfd\xd9\x9b\x59\x51\x91\x27\x6c\x33\xae\xc5\xbe\xe4\x1a\xf1\xa6\x07\xfa\x41\x0d\x06\x1c"
          "\xbf\x0b\x61\x64\xdb\xd8\xf1\x13\x8d\xb2\xf7\xbe\xdc\x49\xd1\xc2\x5c\x8d\xfe\xae\xcc\x2f"
          "\xbe\xb4\x9c\x32\x4b\xa6\x18\x98\x45\x34\xf6\x14\x8d\xe3\x38\xe3\xc6\x07\x9e\xba\x8b\x6e"
          "\xa7\x1f\x4c\x45\x84\xbd\x81\xca\x7f\x09\x78\x53\x4a\x6b\x59\xac\x86\x32\x4e\x3e\xbc\x51"
          "\x86\x75\xc6\xd1\x76\x50\xae\xd3\x80\x2c\xd2\x66\x53\x52\x78\x61\x63\xe2\x67\x0f\xb8\xad"
          "\x5f\x34\xf7\x6e\x1d\xe9\x81\xba",
          "\x4d\xae\x0c\x71\xba\x66\xb9\x6b\x6b\x3b\x98\x4b\xdf\x62\x12\xe5\xf8\x04\xac\xa0\x79\xb9"
          "\xd7\x75\x4b\xaf\x46\xbb\xce\x5d\x49\x39\x6f\x03\x90\x80\x4c\x3d\x5a\x4c\xa2\xf1\x67\x29"
          "\x95\xcc\xeb\x25\x03\x4f\xfb\x05\xa8\x43\xff\x5d\x3e\x46\xd1\xf2\xfe\x80\xf6\xa7\x5a\xa2"
          "\x80\x5c\xd3\x81\x2d\xc9\x8c\x35\xf0\x6b\x81\xa9\xf6\x6c\x42\x68\x71\xc7\x5a\x99\xa7\x91"
          "\x44\x37\x68\x05\xea\x7d\x5b\x13\xe3\x73\xd7\x05\x95\x8a\x08\x09\x39\x9d\xa9\x08\xcf\xe8"
          "\xde\x9d\x6f\x33\x9d\x55\x68\xec\x53\xbd\x87\x15\x5b\xaf\x7a\x00\x8d\x1a\x9b\x7d\x72\x15"
          "\x2a\x82\xe4\x19\x8b\xf8\xcf\x43\x10\xde\xea\xee\xad\xc4\x1c\xef\xff\x88\x85\x05\x25\xfd"
          "\xcd\x70\x1d\xdc\xd7\x8e\x20\x08\xbe\x88\x2d\x01\xda\xde\xbe\x0b\x45\x1e\xf7\xd0\x64\xf6"
          "\xa1\xc9\x62\x1b\x55\x26\x11\x21\x25\xe4\xfc\xe7\x25\x7d\xa8\x83\xc5\x5f\x7c\x9a\xa7\x29"
          "\x3e\xc8\x44\xa2\x08\xd1\x89\x61\x4a\x62\xe3\xcd\x8d\xc3\x94\xb5\x69\x1f\x18\x86\x12\xb8"
          "\xa3\xc7\x93\xa5\x49\xa3\x0d\xb5\xb6\x6c\x6b\xbd\x2b\x2d\xe4\xa1\xa5\x6e\xca\x32\xaa\xe0"
          "\xba\x6a\x2b\xe8\xe9\xff\xc3\xbc\x46\x75\xa1\x9f\x47\x05\x54\xf9\x05\x74\xb5\x8b\xea\x39"
          "\x05\x35\xb9\x5c\x96\x37\x27\xc5\x2b\xb6\x7d\xcf\x1e\x4b\x99\x11\x7e\x0e\x2a\xa0\x52\x36"
          "\xed\x6f\xf3\x7f\x78\x7b\xac\x46\xb2\x9c\xf7\x2d\x35\x21\x88\x1c\x7f\x72\xdd\xc6\xc4\x0f"
          "\x18\x71\xa7\x2f\x21\xa7\x35\xeb\x20\xc4\x88\x99\x9a\x5b\x18\x8d\x6b\x58\x88\x1e\x39\x15"
          "\x7b\xac\x96\xbe\x15\xec\x05\xb2\xc2\x06\x10\x9f\xa6\x30\xd7\x27\xec\xfe\x4e\x75\x8c\xba"
          "\x9f\x6e\x84\x80\xfd\x7a\xf1\xfc\x68\x9f\x9e\xf0\xbc\xd3\xb8\xa3\xec\x4e\x00\xa6\xed\x87"
          "\x70\x3d\xe4\x15\x2c\x8d\x3b\x79\x83\x2b\x1f\x4f\x4e\x63\xfa\x4f\x59\xe1\x19\xb7\xa4\xdd"
          "\xb7\x4b\x6e\xad\xdf\x11\x85\xf6\xd5\xcb\x38\xe7\xaa\xf7\x92\xa3\x55\xd1\x89\xdc\x85\xc9"
          "\x22\x58\x58\xa1\x9c\x51\x4f\x45\x22\xad\x6b\x10\xee\x4b\x16\xcd\xf2\x1e\x14\x1b\x73\x96"
          "\xf0\x12\x63\x86\x05\x75\x0a\xc9",
          1, 3584 },
        { 128, 192, 60,
          "\x02\x30\x2c\x26\x9c\xd9\x05\x1d\xa2\x87\xa4\x76\xe4\xe0\xa4\x79\x52\x7f\x2d\x45\x62\x4d"
          "\xa8\x9f",
          "\xab\x7d\xe5\x19\x98\xc9\xb6\x11\xee\x70\x42\xec\x0a\x95\xbc\x35",
          "\x35\xf3\xba\x86\xd9\x68\xc0\x52\x5b\xe3\x1c\x3e\x10\x70\x77\xae\x67\x92\xb1\x80\xd6\xd2"
          "\xa0\x83\xc7\x3e\xd3\x24\x79\xdf\x09\x5e\x29\x11\xbb\x4b\x8f\xb4\x48\xcf\x13\x53\xd8\x54"
          "\x9e\x68\xab\xdc\xeb\x98\x77\x89\xa3\x13\x86\x8b\xe4\x25\x67\xcb\x80\x06\xcf\x1d\x1d\xf0"
          "\x02\xa0\x0e\x92\x65\xcc\x6c\xdf\x6e\x4c\x36\x4e\x7c\x8e\xe0\xd0\x0b\xac\xd1\xae\x94\xe0"
          "\x19\x3b\x3a\xbe\x7e\xd5\xdc\xbb\x78\x78\x42\x2b\x7a\x73\x55\x1c\xc2\x3f\xdf\x37\x3c\x18"
          "\xa6\x6a\x6c\x9a\xf1\x3e\x5f\x1f\xaf\x2c\x4b\x29\x6d\xc7\x0b\xa8\xff\x2f\x84\x0f\xc8\xc9"
          "\x3a\xb6\x2d\x8a\xfa\x26\xb1\xe3\xf2\x55\xc2\x3c\xf9\xf1\x45\x1b\xb3\xd4\x68\xad\x98\x77"
          "\xda\x2c\xaa\x06\x22\xd4\x04\x5f\x01\xba\x91\x4a\x92\x91\xd6\x7c\xf8\xc3\x2c\xc3\x16\x19"
          "\x22\x08\x3c\x20\x88\x96\x9e\x32\xb5\xf9\xd5\xcc\x3e\xe7\x78\x1b\xfd\x2f\xe3\x14\xe6\xcf"
          "\xe3\xb1\x82\x18\xbe\xb1\x81\xc5\x9f\x03\xce\xda\xe1\xf5\xbb\xa7\x91\xe6\x50\x38\xac\xb5"
          "\x62\xd1\x2a\x8b\xbd\xcf\xff\xca\x77\x42\xf2\xa2\xd8\xee\x67\xee\x0b\x54\x92\x1a\xdb\x16"
          "\xfe\xbb\xdf\xff\xf2\x60\x85\x15\x44\xd6\x96\x41\xcb\xe5\x54\x69\x8a\x5c\x77\x96\xf0\xf1"
          "\x66\xbd\x5c\xbc\xa2\x2a\x14\xca\x69\x45\x8c\x47\x31\xcd\xab\x08\xfe\x7c\x65\x6b\x90\x12"
          "\x7f\x59\xeb\x95\x9b\x43\x2f\x53\xfb\xfb\x2b\x80\xaf\x06\x9b\x3f\xcb\x7b\xf2\xe8\xdb\xe4"
          "\x4d\xef\xea\xe1\x1f\xa6\xa2\xec\x24\x45\xa3\xae\x44\xec\x31\x8c\xea\x6e\xc8\xff\xe6\x51"
          "\xbb\xb7\x8a\x84\x40\x9e\xa3\xb9\xd9\xc5\x23\x5b\xa4\x01\xe9\x92\x50\xfd\x00\x46\x7c\x71"
          "\xf2\x12\x1c\x7f\x54\x18\x8f\x54\xb7\x18\x24\xb2\x45\xce\xfb\xd2\xc4\x10\x5e\xe3\x49\x49"
          "\xd1\xbc\x7e\x5c\xa1\x81\xe4\xb9\x1f\x62\x2c\x05\x6a\xda\xcd\xfd\x24\xdf\xa0\xd9\x0a\xda"
          "\xfc\xd5\x89\x90\x0b\x25\x0d\x4a\xe8\xe0\xd7\x59\x4a\xee\x75\xa4\x54\x9c\x4f\x58\xbe\x9b"
          "\xcc\xd6\x9c\x04\x44\xce\x78\x44\x57\xf6\x08\x51\x86\xc0\x23\xe4\x18\x7c\xf7\xfe\x81\x58"
          "\xbd\xc3\xa0\x7b\x44\xe7\xb1\xb6\x4e\x14\x9d\x47\x07\x7b\x04\xe2\xde\x47\x25\xba\x0d\x77"
          "\x4c\x8b",
          "\x36\x6a\xc8\x0e\xe1\xae\xff\x06\xb9\x29\xc7\xcf\x10\xde\xd1\x5e\x63\x48\x70\x11\x3a\xa7"
          "\xcc\x9d\xf4\xc7\xde\xd1\xe2\x29\xec\xea\x16\xf4\xa6\x97\x0c\x0d\xa6\x89\x9e\x71\x73\xbc"
          "\x0c\xe2\x3a\x9a\xdb\xd0\x72\x44\xef\xb7\x8f\x47\x4c\xc0\x71\x38\x7a\xfa\x65\xfc\x7d\x5c"
          "\xff\x84\xaf\xa0\x63\x31\xea\xe2\xb4\x83\x8d\xe4\x5e\x32\x68\xf1\x6f\x42\xf7\x32\x3c\x1a"
          "\x5b\x88\x47\xc5\xc2\xce\xce\x1a\x45\x69\x35\xe0\xf2\x9b\x3e\xec\x46\x1f\xed\x02\x5c\x5c"
          "\x58\x74\xfb\x3f\xa4\xf8\x2d\xa1\x35\xcc\xf4\x05\x53\xcf\x9c\x69\x2c\x5a\xd3\x9b\x0a\xd6"
          "\x46\xb8\x23\x0e\x76\x9f\xc4\x54\xd5\x02\x0c\x49\x2a\x4a\x6a\x21\x29\xf6\x04\x35\x60\x01"
          "\xd2\x9b\xbb\x90\x96\x70\xda\x50\xc6\xa8\x4d\x5c\x3c\xaa\xb4\xa3\xe9\xb8\x57\xf4\x9c\x7d"
          "\xce\x50\x99\x98\x27\x41\x25\x36\x5c\x7e\x98\x98\xbf\x21\x22\xfb\xf9\x4e\x12\x4f\xa8\xdb"
          "\xe6\xcd\xdf\x98\xc2\x1a\x0e\xfa\x3a\x25\x4f\xcb\x50\x9b\x9c\x22\x8d\x38\x68\xab\xb2\xd1"
          "\x37\x00\xc8\x42\x09\xe5\x55\xa9\x04\xde\xfe\x99\x20\x2c\xe6\xde\x0e\x43\xa7\x3f\xb3\xac"
          "\xc6\xa0\x66\x84\xcc\xfe\xb6\x89\x8f\x7f\x9c\xfc\xc2\xd6\x32\xa1\xf7\x6d\xaf\xb8\x34\x90"
          "\x92\x77\xe0\x61\xcd\x4c\x74\xe6\x01\xa8\x23\x07\x67\xd1\xfb\x32\x72\x7b\x6a\x53\xa9\x4f"
          "\xc7\x15\x41\x9d\x14\x6f\x03\x36\x05\x55\xcf\x94\xd8\x83\xf9\x13\x17\x91\xa7\x7b\x5f\x3b"
          "\xd1\xea\xf5\xf6\x16\x4d\x15\x4a\x49\xe0\x91\x39\x1f\x68\xf7\x28\xb9\x8c\xa4\xa2\x5b\x80"
          "\x85\xab\xaa\xfb\x07\x69\x52\xc1\xf8\x3d\x75\x4d\x53\xbf\x71\xe5\x5c\x47\x44\x72\xe6\x26"
          "\xdf\x97\xe2\x29\xad\xcd\x3a\x79\x16\x6a\xe3\xba\xbb\x98\x42\x7e\xb4\x81\xaa\xdb\xf9\x3d"
          "\x60\x06\xc0\xa0\xb5\x5c\x74\xdb\xbb\xa1\x03\xca\xd9\x69\xc0\xb5\x47\xb7\xc5\xf8\xc0\x67"
          "\xc5\x58\x24\xb7\x3e\x31\xc9\x48\x49\x9b\xb2\xe0\x63\xf7\x5a\x4e\xc9\xb5\xa6\xe0\x25\x87"
          "\xc4\xd6\x2d\xb2\xd0\xca\x3d\x63\xc4\x46\x2a\x00\x1d\xf7\x56\xcf\xe1\x0c\xfd\x7d\x5b\xb4"
          "\x97\x29\x40\x82\xaf\x9c\x4c\x2b\x5c\xa1\xf8\x3a\xe7\x06\x52\x29\xcf\xf1\xf0\xdc\x2d\x3e"
          "\x7c\xfc",
          1, 3712 },
        { 128, 192, 61,
          "\xf1\x4a\x65\xe4\x87\x80\xd9\xaa\xc6\x4d\x6e\x79\x0f\xf3\xac\x2e\x28\x7d\xec\x10\xd4\xb6"
          "\x50\xf9",
          "\x72\xb3\xc4\xe0\xe7\x7a\x74\x69\xdd\x80\xc1\xe2\xbf\x73\x6a\xd3",
          "\xc9\xa5\x2c\x9b\xb5\xd1\xf6\x16\x32\x26\xb2\xcd\x70\x54\x13\x28\x9c\x79\xcc\xa2\xe6\xb7"
          "\x8a\xa9\x6c\x88\x20\x30\x96\xe4\x7f\x22\x1c\xf8\x20\x19\x50\xb8\xfc\xc6\xc5\x76\x9b\x08"
          "\x2e\xea\x7d\x8e\x45\x40\xe7\xc6\xfb\x18\x6d\x9d\x8e\xe4\x56\xa5\x45\xca\xc6\x91\x20\xd3"
          "\xee\x86\x50\xa9\xb8\x96\x01\xd5\xf7\x03\x0f\x88\xaa\x41\xae\xd8\xdb\x22\x3a\x01\xa0\x29"
          "\x04\x6d\x0a\x76\x7d\x41\x59\x68\x5e\x5a\xed\x0a\x4d\x14\xf2\x1d\x8c\xbc\x6b\xf8\x6b\x59"
          "\xd7\x9d\x1f\xea\x81\x5a\xc4\xff\xf6\xa6\xf4\x9f\x1c\x0d\xf8\x07\x89\x9b\x39\x47\x48\xb1"
          "\x6b\x7f\xed\x40\xd1\x16\x7a\x64\x79\x89\xd0\x88\xf7\xce\x7a\x55\x03\xf9\xd9\xb4\xda\x5a"
          "\x93\xa2\x7b\x67\xd4\xef\xde\xf1\x3a\xa9\x0f\xea\x61\x49\xfb\xcb\x97\x19\x6d\xbc\xbc\x32"
          "\x07\x5b\x8c\x6c\x03\x12\x1a\x2d\x92\x77\x36\xfd\xe1\x3b\x33\x60\x4e\xef\x1f\x86\xc5\x03"
          "\x25\x2b\x2e\xc7\x53\xac\x52\x94\x80\x7c\x48\x1d\xbe\x41\xa7\x63\xe3\xd9\x73\x66\x1e\xcb"
          "\x68\x7b\x9f\xd1\xfd\x3c\xa4\x3f\x7c\x48\x03\x90\xda\x73\x8e\x64\x3d\x53\x7e\x1e\xa4\x5d"
          "\x01\xfd\xa0\x2f\x62\x59\x65\x49\x94\x52\x85\x80\xf2\x1d\xd6\x24\xa6\x7b\xaf\x3d\xf3\xc5"
          "\x61\x60\x29\xb9\x40\x4a\x89\x5c\x3b\x87\x86\xd4\x3a\x18\xfa\x61\xdf\xe6\x59\x0a\x75\x94"
          "\xf7\xc9\x34\xc3\xc1\x12\x48\xba\x8d\xbe\x68\x37\xdf\x0f\x61\xa8\xba\x7e\xf3\x98\xbb\x3e"
          "\x25\x56\xc9\xf9\xa4\x06\xcd\xcb\x01\x65\x68\xa0\xde\x75\xf1\xac\xa8\x67\x60\x83\x71\x1c"
          "\xab\x2b\xaa\x21\x08\x8c\x84\xa2\x6d\x04\xae\x0a\xb3\x44\xf0\x17\xaa\xf7\x2b\x3b\x78\x6c"
          "\x14\x28\xf5\x9d\x81\xf4\xe6\xe0\x3c\x8d\x58\x2b\xd3\xf9\xb5\x8a\x2f\x9e\x9c\x48\x46\x54"
          "\x31\xda\x0e\xaa\x6d\xb1\x52\x21\xc0\x57\xec\xca\xcd\x6c\x4c\xd5\x64\xbd\x32\xc3\xb1\xc3"
          "\xef\xf2\xe7\x77\xf2\x3d\xf3\xca\x70\x5e\x6f\x54\xc8\xeb\xde\xbe\xb4\xfb\x16\x77\xa0\xb7"
          "\x84\xfa\x63\x10\xe2\x20\xe1\xb5\x24\x15\xee\x41\x89\x4e\x00\x0c\x17\xe0\xe4\xa1\xc2\xfe"
          "\x1a\x15\x2a\x29\x45\x36\x14\x7b\xa9\xb5\xc6\xb9\xfe\x5e\x9a\x00\x67\xc4\x66\x87\x09\x4c"
          "\x69\x22\x0b\xaf\x38\x49\xa3\x7b\xbb\xd3\x60\xcf\x48\xe3\x2c\x54\x00\xba",
          "\x4e\x49\x87\x91\xe2\x3b\x79\x08\x79\x59\xbc\xb9\x0d\xd9\x86\x7b\xff\x28\x17\xfe\x08\x3b"
          "\x84\x33\xbd\x3e\xa7\x2d\xd9\x78\xec\x59\xb3\x80\x0d\x06\x7f\x72\x54\x53\xec\x22\x76\x13"
          "\xd8\x53\x80\xab\xfc\xf9\xec\xad\x9d\x91\x73\x22\xe6\xb5\xe8\xcd\xab\xd2\xf8\xb6\xa1\xa2"
          "\x14\x9e\x00\xbd\x3e\x97\x99\x41\x3a\x03\xb3\xbc\xe2\xdc\x29\x6a\x70\xb0\x6d\x6d\xd7\x97"
          "\xf0\x74\x75\xbe\x3b\xa1\x8a\xdd\x88\x93\x88\x8c\xf8\x7d\x97\x9c\x95\xb3\xed\x2e\x17\xd6"
          "\xd5\x69\xc0\x11\x82\xcc\xaa\xb7\xf8\xde\x22\xfa\x15\xf0\xf5\x56\xb1\xda\x85\x4b\x29\x9b"
          "\xfa\xbf\xad\x4e\xa3\x71\x79\xab\xae\xe2\xf9\xae\x18\x12\x0d\xfd\x8f\xd3\x2f\x2d\xfa\x03"
          "\x4c\xdf\x5b\xfd\x78\xaf\x6c\x57\x0c\x8c\x2c\x9a\xb5\x91\x23\xaa\x76\x5e\x3f\x01\x02\x33"
          "\xed\x39\xae\xff\x93\x39\x24\x4d\x71\x1f\xa7\x1f\x1d\xc3\xc8\xe2\xd9\xb8\x2a\xf2\x38\xc8"
          "\x5e\x00\x01\x70\x21\x5b\xc3\x55\x93\x63\x78\xee\x8e\x6b\x81\x0d\x8b\xe9\xe3\xf8\xf4\x0d"
          "\x73\x64\x54\x15\x63\xc4\x12\xd3\xc6\x10\x95\x6b\x91\x45\x14\x7b\x0f\x29\x0f\x6f\xcb\xe9"
          "\x13\x32\x3d\x63\x94\x83\xe0\x54\x76\x5c\x6c\x54\x72\x6d\xbd\x9b\x48\x24\x12\x38\x98\xeb"
          "\xdd\x5b\x3c\x9f\xe7\x60\xa2\x08\x0d\xdd\x60\x41\x27\xf5\x53\xa0\xca\xe6\x31\xdf\x8c\x66"
          "\xbf\xb9\x38\xb5\xc7\xf6\x44\x60\x47\x15\x23\x00\x02\xd4\x78\x69\xb5\x01\x32\xaf\xd7\x13"
          "\xd7\xa9\x15\x45\x1e\x8a\x7e\x28\x52\x8e\x9a\xf9\x49\x79\x91\x54\x2b\x25\x33\x60\x7f\x65"
          "\xd3\x7e\xbb\x0a\x7a\xd2\x9d\xb2\x91\xc7\x03\x4a\x8c\xc9\x0a\x89\xeb\x6e\x38\xb2\x9b\x58"
          "\xd0\xdc\xcd\x32\xd5\x3e\xac\x84\xda\x44\xf2\x79\x3b\x97\xc7\x11\x3b\x88\x03\x27\xbd\x13"
          "\xc7\x45\x06\x97\x31\x64\x98\x65\x47\x51\x3d\x8f\x20\xd9\x5f\x31\xba\x54\x9c\xd1\x38\x9b"
          "\x55\x10\x22\x5f\xa4\xa8\xf3\x84\xf9\x28\xe4\xec\xc3\x3f\xda\x18\xbb\x3f\x4c\x88\x92\x61"
          "\x23\x6c\x6a\xec\x09\xed\xf5\xb7\x92\xbd\xfd\x3c\x13\x38\x79\x12\x98\x38\x50\x29\x81\x2f"
          "\x7c\xc4\x73\xee\x81\x7f\x8c\x21\xea\xde\xe1\xc0\x92\xcb\xb2\x67\xf9\xfd\x46\x17\x1a\x60"
          "\xbe\x57\x0b\x96\x6e\xa7\x78\xb7\xec\x1b\x91\xd5\x0e\x55\x44\x16\xfe\x44",
          1, 3840 },
        { 128, 192, 62,
          "\xe8\x3c\xfb\x36\xe7\x17\xb3\xea\x26\x68\x3a\x51\x24\x2d\xa6\xb9\x8c\xdc\x10\x8c\x6d\x7f"
          "\xfc\x3f",
          "\x7c\x7e\xa1\xad\xf5\xc3\x99\x7b\x17\x6f\x17\x99\x59\x22\x6f\xbd",
          "\x22\xc8\xd0\xea\xae\x1c\x50\x0d\xb4\xc5\xef\xac\x37\x10\xdd\x52\xef\x0f\x4e\x5d\xaa\x8d"
          "\xd1\xba\xbc\x58\x3f\x5c\x0c\xad\x36\x64\xf7\x6b\x87\x04\x28\x25\xa2\xca\x90\xd2\x0e\x38"
          "\x14\xcc\x60\x96\x27\x51\x7f\x33\xa7\xcf\x31\xe4\x94\xc8\x02\x67\x27\x92\xbf\x23\xd1\x7a"
          "\xc5\x10\x12\x18\x57\xdd\x4c\xb8\x55\x0c\x11\xd3\xc8\xa7\xec\x30\xd7\xdb\x09\x60\x74\xe3"
          "\xc5\x6e\xd9\x5e\x0c\xdf\x8d\xe5\xe1\x36\x8e\x4a\x2f\x7b\xa5\xfe\x40\xd8\xc3\x0d\x63\xc1"
          "\x63\x00\x8b\x5c\x81\xef\x16\x80\x71\x34\x4e\xf2\xc5\x53\x56\xd7\x92\xb9\xb9\xf4\xf3\x15"
          "\x8d\x0c\x20\x59\x1e\xcb\x4a\x23\x04\xb3\xaa\xc9\x0d\xc7\x7b\xc2\x03\xf8\x80\xf9\x3f\x94"
          "\xf9\x07\x62\x34\xa9\x25\x6b\xf5\x53\x89\x02\x08\x84\x8b\xca\x29\x5d\x26\x2c\x8f\xb9\xb7"
          "\xc6\x9a\xe5\xfd\x47\xa5\xdc\x2e\x45\xf7\xcd\x56\xc2\x24\xff\x55\x5d\xca\x0c\x82\x5c\x34"
          "\xb4\x8f\xe7\xbf\x8f\xcb\xa6\x3c\x4d\xa7\x64\xf8\x79\x59\x1e\x60\x2e\x51\xe7\x33\xe4\xff"
          "\x94\x46\xff\x05\x25\x25\x7e\xd1\x6a\x4f\xe0\x14\xb9\x67\x62\xe7\xc8\xc3\x97\x7d\x33\xf7"
          "\x3d\xa2\x48\x16\x2d\x3f\x27\xe4\x05\xea\xf1\x5c\xcb\xed\xa1\x44\x2c\x33\x7b\x61\xc7\x00"
          "\x69\xb7\x64\xe3\x2d\x94\x6a\x12\x27\x6f\x9a\x8e\xac\x27\xc3\x80\xfb\x42\xba\xb0\x08\xea"
          "\x6b\x65\xe0\xa9\x02\x8e\x4a\x77\xe1\x31\x08\x32\xa0\xd5\x91\x34\x64\xad\x3a\x13\x5c\x71"
          "\x04\xa7\x0d\xaf\xff\xe1\xf2\x81\x53\x08\xa4\x95\x93\xc2\xa5\x17\xa0\xf5\x5e\xa8\x43\x3d"
          "\x37\xc7\xea\x4e\x9b\x95\x91\xbe\xbe\x25\x66\x1b\xc2\x55\xb8\xd2\x06\xdf\x16\x5e\xe9\xf3"
          "\xc8\xcc\x12\xa2\x2c\xfc\xf7\x00\xdd\xcc\x28\xbb\x35\xae\xe1\x61\xb0\x5e\x3e\xdb\x9f\xe4"
          "\x8e\x96\xbc\x8e\x70\x96\x5e\x0a\xf1\x9e\x84\x2e\x06\xc8\xe0\xfd\xee\x55\x93\xa6\x10\xb8"
          "\xc9\x06\x6d\x84\x9e\x58\xff\x9a\x98\x21\xb9\xf4\x08\xf3\xb3\x27\x01\xdd\x86\xf8\xa0\x3c"
          "\x28\x36\x4a\xac\x70\x7d\x45\x2f\xf2\x25\xc3\x39\xa5\x50\x5e\xcc\x89\xb8\xe9\x39\x09\x85"
          "\x91\x26\x39\x6a\x89\x26\xf8\x55\x6c\x32\x72\xd8\xbc\x17\x3d\xfe\x57\x05\x7b\xaa\xdc\xd7"
          "\xc5\x31\xb4\xa8\x04\xfe\x2c\xfa\xe5\xc7\x58\x5b\x12\xb0\x58\xee\xf6\x50\x9c\x6c\x9f\x95"
          "\x63\xe5\x4f\x40\xd1\x66\x5e\xa8\xe2\x56\xcd\xea",
          "\xfe\x3c\xdb\x89\xc6\x6f\x2e\x2d\x03\xed\x0e\x6c\xa2\x60\x9f\xd1\x43\xfb\xf1\xa2\x43\x3f"
          "\xea\x5f\x9d\x39\x2b\xcd\xdc\x6b\x65\x2a\xc3\x62\xc3\x9d\x83\x4e\x9b\x8b\x2d\x61\xc5\xb5"
          "\x9f\xb9\xed\x4c\x20\x44\xf3\x72\xd7\x37\xe3\xc8\x4d\x48\x74\x0d\x6e\x01\xe8\x21\x2f\x70"
          "\x16\x88\xee\xe9\x3f\x4f\xf8\x9d\xbd\xb5\x80\xf9\x58\xc9\xdc\x93\x45\x0f\xe3\x78\x5e\x2e"
          "\xaa\x21\x1e\x80\xfd\x8b\xf9\xc6\xcf\xe6\xed\xcd\x1b\x35\xdf\x0f\x9d\xd8\x1d\xe2\xaa\xd7"
          "\x0c\x6a\x1e\x3e\xe2\x18\xb0\xc0\x64\x0d\x8e\x6c\xe5\xf1\x41\x17\x7e\x22\x22\xd8\x66\xe2"
          "\xf9\x0e\x17\xb3\xea\x2c\xce\x91\x9d\x49\x07\xaa\x82\x13\x20\x8d\x0b\xe4\x06\xa9\x44\x99"
          "\xf2\xa0\xa3\x2f\x93\x84\x39\xe1\x57\x21\xfa\xff\xba\x1e\xd4\xb9\x8a\x7f\x0a\x25\xc6\x0e"
          "\x73\xc7\x93\x70\x0a\x57\xa1\xb6\x4e\x7b\x67\x33\x70\x4d\xcd\xad\xf0\x7a\x3b\x72\xca\x2d"
          "\x86\x55\x9e\xe0\xbb\xbc\x7c\xe8\x68\x5e\x84\xa6\x54\x5a\x46\xcd\x19\xf3\x9c\x42\x68\x13"
          "\x2c\x14\xe6\x38\x65\xed\x99\xe2\xd9\x4e\xa3\xaf\x9e\xe6\x55\x6d\xeb\x3c\xa9\x92\x2b\xd0"
          "\x14\x47\x53\x4c\x6a\x0b\x88\x6f\x0f\x06\x10\xc3\x1f\x08\x99\x40\x16\x59\x7c\x2f\xd7\x86"
          "\x10\x9b\x7b\x4f\x0c\x56\xe4\x01\x0f\xc2\x0f\x64\x9e\x61\x00\xf1\x87\xd6\x1e\x75\x4c\x75"
          "\x3b\x30\x1b\xe3\x46\xed\x51\x94\x1b\x70\x50\x9c\xd3\x19\x91\x78\xda\xed\x3c\x0d\xdd\x3f"
          "\x4a\x27\x9d\x05\xec\xac\xca\xa1\x78\xaf\x91\x27\xcf\x21\x7c\x27\xd3\xf4\xa4\x72\x44\x91"
          "\x5f\x3e\x4f\x60\xc7\x86\x76\x4a\xb6\xd3\x57\xb1\x89\xdb\x3d\x26\x0b\xd0\x21\x8b\x95\x2a"
          "\xd9\x34\x4d\xd3\xd7\xd5\x02\x8c\x1a\x0c\x88\x3d\xa9\x2d\x48\x2e\x53\x7c\x71\x5a\x1a\x6d"
          "\x8b\xf4\xe4\xda\x0b\xd4\x28\xd3\x66\x06\x09\xdb\x50\xcd\xe8\xcf\x8c\x48\xd6\x7f\xf8\x57"
          "\x9e\x40\x6c\x16\x27\xce\xde\xbd\xb3\xb7\x27\x2d\x1b\xec\x0a\x6f\x34\xca\x68\xdf\xfa\xa4"
          "\x84\x33\xf5\xc5\xc5\x77\x1d\x72\x92\x6d\x68\x93\xbf\x49\x26\x3c\xd4\xe3\x50\x34\xcf\x85"
          "\xf9\xd7\x64\x05\xec\x88\xbb\xe8\xf2\xdb\xbf\x05\x95\x51\x76\x49\x95\xd5\x6b\x83\xcf\x76"
          "\x8d\x31\x52\xf5\xc4\x7b\x8e\xbd\xcd\x1a\xf3\x6c\x95\xc9\xc1\xe2\x4b\x14\x51\xca\x4b\x0b"
          "\x7e\x31\xfa\xdb\x3d\x37\x51\xbb\xb7\x3a\xaa\xc7",
          1, 3968 },
        { 128, 256, 63,
          "\x59\xc2\x0f\x2a\x22\x34\xaa\x96\x4e\x64\x1a\xb8\x7f\x88\xe8\xee\x40\x1e\x3e\x34\xf8\x2a"
          "\x89\x03\x29\x59\x1f\xf9\xb5\xf1\x06\xe8",
          "\x1e\x07\x48\xe9\xf1\x19\x7b\xf1\x02\x5b\x35\xbe\x74\x96\x8a\x99",
          "\x52\xf4\x07\x4a\xa6\xe7\xd0\x81\x99\x6e\x47\xdd\xc2\x29\x39\xde",
          "\x24\x16\x23\x0e\x57\x6a\x79\xbe\xfe\xb6\x20\x72\x0d\xb5\x6e\x2a", 1, 128 },
        { 128, 256, 64,
          "\x83\xbc\x79\x24\xb7\x28\x6c\x92\xca\xdd\x01\x71\xa7\x0a\xa5\x76\xe7\x31\x19\x05\x42\x27"
          "\x00\x98\x85\xd5\xb0\x46\x3c\x29\x54\xcc",
          "\xc6\x00\x0d\x3d\x5a\x57\x80\xe4\x86\xf8\xc9\xba\xc9\x19\x75\x78",
          "\xfc\x11\x04\x58\x99\xda\x80\x33\x47\x93\x13\x27\x19\xb4\x2f\x85\xfd\x27\x5f\xf8\x2a\x31"
          "\x4f\x6a\x58\xb2\x66\x5c\xfb\x09\xdb\xcb",
          "\x9e\x65\xcc\xbe\xa5\x31\x19\x46\xfb\x8d\xd7\x96\x44\x27\xe9\xc6\x24\x13\xb3\x64\x33\xca"
          "\x8c\x0e\xe7\x2d\x11\x98\x0c\x91\x08\x42",
          1, 256 },
        { 128, 256, 65,
          "\xa5\x7a\xac\x01\x43\xe7\xa6\x5e\xe5\x67\x4f\x76\x52\xba\x89\x48\x6f\x34\x8e\x6c\xba\xb9"
          "\x47\x7f\x1f\xab\x3b\x3c\x14\x14\xaf\x52",
          "\x1b\x24\xd7\x08\x12\x62\x9b\x6d\xaa\xc0\xf8\xc7\xa6\x5d\xa0\x71",
          "\x1b\xe6\x86\x92\xd6\x6a\xdf\x9b\x45\x69\xfc\x73\x33\x17\x30\xa6\x75\xc5\xf3\x3e\x2d\x6d"
          "\x33\xae\x8d\xad\x7e\x15\xc0\x29\x12\x78\xe2\x5a\x64\xaf\xd1\x1f\x93\xc1\x05\x96\xc4\x12"
          "\xd0\xdb\xde\xc4",
          "\x00\xa6\x91\x4c\x9c\xbb\x37\xc6\x9e\x46\x15\x74\x50\xdd\x00\x68\x39\xc8\x74\x22\xa8\x1c"
          "\xaa\x86\x80\xb6\xac\x33\x36\x5c\x01\x76\xb6\x12\x8c\x27\x6d\x73\x4f\xa3\xca\x6a\x7d\xee"
          "\x23\xe4\x17\x21",
          1, 384 },
        { 128, 256, 66,
          "\xc4\xbe\xf6\xb3\x9c\xd7\xe1\xf1\x2f\x7f\xe7\x85\xc3\x26\x01\xbd\x1d\x2c\x06\x28\xac\xb2"
          "\x6e\xb7\xa3\xed\x23\xa9\xde\x4c\x2b\x04",
          "\x60\x3e\xe3\x70\xbb\x16\x52\x5d\xf1\xaa\x07\xef\xd3\x12\x54\x1b",
          "\x92\x1e\x70\x2e\x89\x9d\x99\xa9\x8c\x7d\x0a\x48\x5b\x67\xb7\xb8\xe5\x79\x06\x4a\xee\x47"
          "\x0c\x4c\xac\x0a\xde\x6f\x0d\xe2\xe3\x8c\x36\x8a\xde\xc3\xd3\xff\x5c\x44\xef\xe6\xce\x4b"
          "\xad\x28\x7d\xcc\xf6\x7b\x81\xb3\xbc\xa4\xdd\x04\x52\x14\xb3\x9d\x2b\x3e\x79\xdb",
          "\x86\x31\xab\x41\x11\x3a\xe4\x1f\x2b\x21\xb6\xd9\x64\xd0\x7e\xce\x6c\x45\xd7\xed\xc9\x4c"
          "\x4b\x28\xc2\x66\xbf\xaa\xbe\xfe\x17\x2c\x20\xf3\x74\xf5\x77\xfc\x09\x24\xdf\xcc\xc1\xbe"
          "\xd0\x35\x13\x9f\x1c\xaf\x3c\x67\x86\xe8\x45\xc8\x14\xe0\x59\xb3\x20\xbb\xed\x56",
          1, 512 },
        { 128, 256, 67,
          "\xbf\x7d\x06\x4f\x38\x32\xa8\x23\x92\xbb\x2b\x16\x40\xfe\x68\x97\xce\x48\xa2\x24\x1d\xc0"
          "\x0e\x0b\xfe\x36\xee\xc9\xca\xc6\x7f\x6c",
          "\x4a\x02\x9f\xb3\x04\x23\x4c\xe0\x14\x4f\x80\x24\x59\x30\xaa\xc5",
          "\x03\x5e\x31\xfd\x99\x35\xb3\x43\x61\xb9\xde\xc6\xa3\x61\x00\x23\xa3\xbc\x53\xb3\x99\x9c"
          "\xab\x85\x45\x5e\xfc\x09\x02\xc1\x0c\xb3\x3f\x77\x7c\x45\xf6\x1f\xe0\xd9\xa5\x4a\x02\xcb"
          "\x01\x55\x1f\x08\x64\xd9\xb5\x4a\xbb\x5b\x5b\xc9\xa3\x44\x28\x00\x0b\x69\x35\xaf\x42\xdc"
          "\x1c\xdc\xb7\xd8\xef\xcc\x41\xc6\x3a\x07\x45\x66\x9b\x97",
          "\xd9\xa5\x96\xb0\x2f\xd6\x71\x03\x65\x35\xe3\xb2\x20\x5d\x0c\x4a\x36\x43\xea\x3b\x07\x89"
          "\xbd\x84\xbc\x64\x19\xa4\xe4\x09\x61\xfa\x2a\xc9\xd5\x09\x7a\x62\xa8\x13\xf9\x59\x11\x8d"
          "\x6a\x24\xd1\x47\xa9\x87\x64\x35\xd7\xc0\x4e\x5f\xd9\x76\x5d\x55\xa6\x67\x12\x47\x84\xfb"
          "\x9b\x0e\xca\x91\x08\xf2\x14\xae\x17\x2b\x4e\x44\xf7\x82",
          1, 640 },
        { 128, 256, 68,
          "\x74\x64\x2c\x33\x19\xf1\xf4\x8a\xa4\x07\xd5\x25\x13\x33\x9e\x98\xf8\x60\xbf\x90\xdc\xac"
          "\x0b\x1b\x1f\xfb\xb7\xaa\xbe\x75\x8d\x4f",
          "\x1c\xbb\x9a\x4a\x0a\x2e\x16\xa7\xe8\x0f\x15\x99\x86\x01\xee\xbb",
          "\xea\xf9\x50\xcc\x57\x9c\x24\x4a\xec\x7f\x35\xee\x92\x7c\xf7\x73\xa9\x42\xec\xb5\x02\xd7"
          "\x38\xff\x32\xe5\x7e\x5d\xed\x68\x36\xfd\x34\xb1\x10\x1f\x19\x5b\xaf\x8d\xc1\x2c\x7e\xb6"
          "\x21\x34\x19\xa7\x9c\x3b\x3b\xb5\x83\x18\x68\xe2\x39\x19\xbc\x74\x8c\x37\x1d\x49\x14\xec"
          "\x9c\x0d\xa7\xa7\x77\x92\x97\xa7\xd5\x75\x2c\x99\x7f\x8a\xdd\x1c\x99\x20\x2b\xd9\x9c\x71"
          "\x0d\xba\x12\xfa\x02\xc4\xcf\x69",
          "\x81\x91\x8d\xb7\x42\x6f\x53\xdc\x6d\x49\x79\x01\xa8\x8e\x88\x4f\xa5\x7c\x10\x6c\xea\x93"
          "\xcf\xf0\x43\x01\x2d\x48\x2c\xd2\x64\x11\x01\x64\xac\x63\x3d\xa7\x69\xfd\xdf\x00\xe2\xf5"
          "\xb6\x9a\xd3\x93\x79\x54\xde\x30\x35\xb5\xa7\x8b\xc2\x30\x2e\x9c\xef\x20\x6e\x1d\x03\x27"
          "\x62\x47\xc3\x6f\x29\x38\x16\x3e\x24\x59\x45\xcf\xc3\xf1\xf1\x23\x86\x5d\x54\x8d\xc4\xf7"
          "\x63\x9a\xf0\x43\xce\x18\xd1\xd6",
          1, 768 },
        { 128, 256, 69,
          "\x5d\x59\xa1\x0f\xa7\x93\x40\x83\x0e\xdb\x20\xa9\x11\x8f\x76\xdd\x22\xc5\x9c\xa1\x45\xdb"
          "\x1a\x8e\xc7\x4d\xc4\xc6\x24\xfa\xbe\xa5",
          "\x6e\xf9\xdf\xf9\x00\x55\x06\x61\x84\xdb\xb6\x87\xd0\x39\x94\xcc",
          "\x31\x58\x61\xec\x1d\xd4\xf1\x67\x63\xbd\xfb\xbb\x63\x7f\x30\xb3\xdf\x38\xc3\x62\xd6\x25"
          "\x3c\x4e\x4b\x02\x3b\x89\xd4\x83\xd5\x7b\x89\xfb\x82\x9e\x94\xc2\xe8\x53\x2d\xf7\xa0\x68"
          "\x97\x3a\x7b\x8f\x55\xf6\xbd\x8f\x25\xbc\x6c\xe1\xc2\xd6\xb7\xb0\x9c\xde\xa0\x7d\x78\xa8"
          "\xfb\x58\x15\x5e\x4c\xd1\x12\xb1\x39\x0c\xa7\x9a\x22\x70\xa9\x71\x14\xbc\x50\x84\x67\x86"
          "\x08\x60\x13\x9e\x63\x45\x01\x35\x0c\x4b\x8c\xee\x10\x81\x02\xca\xc2\xdf\x30\x9c\x1d\x5a"
          "\x21\x24",
          "\x03\xa6\x80\xa3\xd7\x3f\x24\x96\x76\xe9\x84\x65\xb5\xd1\x14\x18\x95\x85\x02\x2a\xf6\x40"
          "\x28\x25\x31\xb0\xa5\xb9\x4f\xd0\xd5\xbe\x17\xe7\xdc\xbb\x7d\x92\xb1\xc3\x03\x36\x3a\x4b"
          "\x2d\x89\x0b\x08\x71\x4b\xb8\x65\x2f\xb8\xf3\x30\x4b\xe2\xd3\x90\x68\x11\x98\x46\x4b\xea"
          "\xde\x5a\xa1\xe9\xb2\xed\x6d\xbd\xb0\xb6\xfa\xbb\x61\x35\xad\xf7\xeb\xb6\xa5\xf6\x83\x17"
          "\x8c\xb9\xef\x94\x2c\x9d\xbf\x55\xa9\x49\x42\xf2\xef\x1a\xc3\x05\x27\x12\xf1\xf7\x80\x8b"
          "\x6c\xab",
          1, 896 },
        { 128, 256, 70,
          "\xf5\x27\xd0\x92\x7f\xe5\x90\x1f\xfe\xe9\x8f\x91\x74\x77\xb5\x85\xb4\x26\x44\x50\x3e\xd6"
          "\xab\x6d\x6f\x8e\xf9\xb6\x88\x77\x12\xf0",
          "\x05\xaa\xc1\x45\x89\x46\x49\x07\xf6\x19\x9b\x53\x75\x34\x63\x8d",
          "\xd8\x9c\x8f\x2b\xd1\xd4\x8c\xd4\x25\x5b\xe2\x4e\x3f\x1b\xcc\xfc\xbe\xfa\x59\x43\xa4\xb8"
          "\x3d\x08\x5b\x0d\x84\x98\xdb\x77\x7e\x8e\xf9\xaf\xdc\xb6\x22\x9b\x47\x6c\xdb\x1f\x78\x60"
          "\x7e\x03\xbd\x09\x19\x86\xb6\xa0\x68\xb1\x2c\xeb\x76\x29\x59\xd9\x8f\x10\xb1\x09\xb0\xe0"
          "\x34\xa2\x88\x6a\xa0\x56\x0e\xc7\x61\xf6\x1c\xa3\xda\x1f\xc8\x88\x13\x04\xe8\x6a\xd1\x81"
          "\xe3\xae\xef\x1e\xbb\xce\xff\x16\x6f\xd1\x4d\x60\x08\xe8\x9b\xbc\xb9\x52\x86\xa2\x17\x03"
          "\xc9\x43\xb0\x0f\xd3\xb6\xee\xcc\x9a\xea\x13\x00\x1a\x91\xdd\xe9\x39\xae",
          "\x7a\x3e\xc7\x74\x89\xb4\x1d\x49\x07\x91\x76\xce\x33\x7d\xb9\x3e\xc1\xe7\x2d\x55\x6d\x7f"
          "\x6e\x29\x0c\x3d\xaf\xa0\x9a\x4e\x3d\x55\x9c\x78\x60\xd7\x24\xbd\xa5\xdb\x0f\x83\x18\xe4"
          "\xa3\x31\xf5\x93\x53\x2e\x21\xbc\xa4\x07\xc9\xbd\x27\xc1\xf8\x78\x1c\x4a\x5f\x64\x4b\xb9"
          "\x7f\x8d\xfa\x7a\x3a\x87\x6f\x01\xd6\xf6\xc7\xb7\xae\xe2\x49\x96\xbc\x82\x4f\xcf\x6f\x16"
          "\x6d\x9b\x7e\x4c\xbc\x5f\x15\xd9\x40\x87\xb3\x93\x12\xf5\x92\x2f\xf8\xa0\x3d\xf7\x11\x42"
          "\xaa\x0a\xf2\xf5\x10\x79\x17\xdc\x22\x5d\xad\x02\x68\xc3\x95\xbf\xcb\x22",
          1, 1024 },
        { 128, 256, 71,
          "\x19\xbe\x69\x4a\x1d\xff\x91\x20\x2d\xef\x66\xb5\x3a\x3f\x63\x62\xfc\x20\x0d\x93\xb6\xb2"
          "\x7d\x3e\x8a\x37\x13\xb2\xab\xaf\x7a\x27",
          "\xca\x83\x33\xf2\xf6\xda\x1a\x7e\x66\xf2\x99\x7a\xb9\x97\x62\x31",
          "\xce\x54\x48\x15\x02\xe0\x7e\xe9\xf5\x7a\x4c\x85\x63\xf7\x06\xb2\x50\xb9\x65\x49\xed\x38"
          "\x33\x8a\xb2\x00\xcc\xea\xda\x29\xa3\x26\xc8\x38\xa5\x07\x47\x02\xa4\x28\x76\x87\x73\xb1"
          "\x11\xbd\x84\x04\x80\xb9\x09\x77\xc2\xe8\xe8\x42\x5a\xe6\xa6\xf8\xee\x15\xdf\x3c\x56\xe4"
          "\xde\x67\x09\xa0\xd7\x50\x49\x55\x2e\x1d\x35\x31\x85\xf0\x7e\xef\x0b\x78\x42\x70\x6a\xde"
          "\x77\x7a\x8f\xe9\xf5\xa3\x48\x76\xfd\xe7\x87\x6f\x29\x44\x99\x7b\x50\x26\xb5\x17\x8c\xf4"
          "\x33\xb6\x34\x79\xff\x4f\xf4\x95\x0b\xdb\x9d\x38\x72\x57\x75\x4b\xc0\x9a\x15\x72\x80\x72"
          "\x98\x5e\x14\x4c\xbf\x24\x9f\x14\xee\x1f\xd2\xe4",
          "\x9a\x69\xaa\x44\x69\xfb\x88\xf5\xa4\xc3\x44\xa1\xef\x02\xa6\xcd\x60\xee\x1b\x16\x8c\x7e"
          "\x4f\x7b\x77\x0f\x4a\x8f\xf7\x94\xb8\xd5\xe3\xa4\x8b\xce\x3e\xc9\x96\x9b\xa2\x88\x46\xe4"
          "\x7f\x83\x19\xfe\x87\xdd\x28\x01\xd6\x27\x76\x67\xe6\x12\x66\x12\xb9\x2d\x22\x04\xd9\x1a"
          "\x49\x61\x4e\x0f\x0d\x34\x72\xcf\xf6\x0a\x58\x53\xc3\x8c\x94\x42\xfa\xcd\x03\xfa\xf8\x0d"
          "\x84\xc8\x81\x00\xb4\x68\x87\x9c\xf4\xc0\x70\xd4\x06\x04\xa3\x6f\x41\xfb\x5a\xc1\x32\x00"
          "\xa7\x7e\x34\x68\x08\x41\x30\x5c\xe4\x6f\xd1\xcd\x96\xcd\x41\xcd\x99\xe5\xfc\x23\xc2\xa9"
          "\xcb\xc2\xa5\xc8\xb6\xb1\x4c\x55\x7d\xb9\xbe\x18",
          1, 1152 },
        { 128, 256, 72,
          "\xdf\xbc\x9c\xd5\xff\x26\x91\x02\xdc\x1e\x45\xce\x44\x74\xa0\x5b\x33\xb0\x0f\x23\xf1\x1f"
          "\x81\x66\x28\x36\xda\x21\x18\x02\x96\x92",
          "\x47\xe9\xc1\x0a\xee\xfc\xb1\x00\xcd\x9f\x6d\xbf\x73\xb1\x92\xdf",
          "\xf0\xde\x60\xb1\x26\x54\xd8\x75\x17\x93\xad\xf4\x22\xe6\xf5\x33\xb7\x51\x22\x00\xee\x40"
          "\x0c\x30\xfb\xe3\x93\x18\xb7\x28\x89\x5e\x89\xb3\x04\xe5\x9f\x43\xf5\x7d\xa9\x88\x12\xb3"
          "\xe0\x0b\x96\x11\x49\x73\x35\x88\x4c\x58\x22\x15\x9f\x26\xac\x45\xd2\x86\x1e\x1e\x7a\x73"
          "\x9d\x26\x38\xbc\xce\xa2\x43\x43\xe7\x7e\x93\x6e\x94\xde\x35\xdc\xa2\xeb\x9f\x25\x15\x04"
          "\x30\xd6\x7a\x33\x16\x0e\xe9\x49\x12\xf8\x63\xe2\x6b\x3b\x4b\xf7\x2b\x06\x62\x5e\x6d\x05"
          "\xe9\xf9\x6c\xfa\x57\xde\x65\x0a\x44\x8d\x5c\xc3\xa3\xd4\x87\x8f\x8d\x6f\x7b\xca\x40\x41"
          "\xb8\x47\x78\xa4\xb9\xc2\xf2\x14\x9f\x0a\xe3\x25\x73\x77\x61\x62\x1b\x26\x12\x07\x4d\xd8"
          "\x6d\xb5\x58\xf7\x1d\xd3",
          "\xac\x4a\xad\x36\x21\x66\x12\xc6\x4b\x97\xbd\xe3\x4a\x78\x6b\xc5\x99\x29\x46\x68\x47\x45"
          "\xac\x1a\x22\x39\x5f\xaf\x1f\xa3\x4f\xe2\x1f\x53\x74\x20\xd5\xf1\xc5\x5b\xbc\xfe\x6c\x27"
          "\x04\x21\xe0\xf0\xa2\x36\x7c\xf0\xd7\x18\x55\x68\x51\x9f\xce\x27\xb5\x52\xc7\x1f\xd5\x80"
          "\x83\x51\x13\xe3\x5e\x4e\x27\x21\x91\x09\x52\xa6\x6b\xd6\x37\xe2\xe9\xdc\xa0\x99\x8d\x8a"
          "\x95\x3e\xa8\xd5\x2a\x19\x6e\xc5\xb0\x3b\x58\xa4\x42\x33\xd9\x6a\xea\x60\xa3\xf6\xc8\x59"
          "\x92\xd4\xf1\x1f\x94\x98\xc0\x88\xba\x03\x29\xdb\x68\xa3\x8c\x10\x5e\xb3\x02\x4e\x05\xa4"
          "\xba\x5d\xaf\xba\x02\x48\xaf\x1e\x1a\xcf\x24\x39\x9e\x5b\x94\x64\x08\xb2\x58\x61\x73\xb5"
          "\x34\xfc\xaa\x5a\x99\x16",
          1, 1280 },
        { 128, 256, 73,
          "\x46\x70\x5e\x92\x2d\x30\x48\x27\xbc\xfc\xef\xdf\xe6\x36\xc3\x8f\xca\x0b\x63\x95\x69\x4d"
          "\x97\xb8\x27\xfa\x2e\xf3\x5d\x44\x04\xb7",
          "\x85\xcf\x36\x3b\x52\xfd\x0b\x92\x9f\x80\x13\x85\x8b\xf9\x3d\xee",
          "\xfd\x1f\xe6\x9a\x57\xb4\x33\x6f\xd6\x6c\xfa\x73\xbc\x0f\x77\xa9\x27\x22\xa8\x76\xb7\x59"
          "\x8a\x1e\x80\x16\x9b\x92\xa5\x6e\xd7\x74\x07\x43\xa3\x29\x80\x6b\xb7\x70\xa8\x2f\x52\x49"
          "\x1a\xb8\xf1\x8f\x8c\x00\x6d\x3d\x51\x97\x2d\x26\x84\x83\x98\xe6\x7a\x46\xaf\x36\x11\x2a"
          "\x98\xbd\xbb\x9f\x2b\x68\xaa\xa2\xd0\xa0\xa3\x50\x38\x0b\x31\x57\x9d\x43\x6f\x9c\xb3\x05"
          "\xf9\x57\x3f\x48\x2a\xef\xd8\x2e\xd4\x75\x68\xe0\x89\x59\x7d\xc7\x9d\x04\x8f\xb4\xad\x37"
          "\xf9\xc7\xd1\x63\xf1\x54\x4f\x86\xb4\x02\xf0\x9b\xdb\x88\x66\xbc\xef\xd1\x5f\x44\x88\xd4"
          "\x69\x4a\x89\x11\xbc\x41\xb5\xd8\x34\x97\xbb\xcc\x19\xdf\x67\xe2\x10\x97\xe8\xbc\x72\x77"
          "\x04\x2c\x1e\xba\x1a\xe2\x40\xa4\x8b\xfb\x98\x3a\x66\x2b\x36\x45\x48\x6a\xd3\xdd\x57"
          "\x41",
          "\xa4\xe7\x6e\xd2\x44\x46\x8a\x1a\x34\x39\x5e\x05\xf5\x40\xee\xc1\xe9\xea\xae\xcf\x6d\x1f"
          "\x78\x9a\x24\xe5\xf7\x70\xbe\x37\xe8\x70\x85\xee\xe1\xf0\x8f\x92\xd6\x71\x20\x00\xf9\x90"
          "\x57\x65\x14\xec\xd9\x37\x46\x08\x0e\xc1\xca\xb0\xa2\xea\x2c\x7f\xbb\x10\x07\x69\xab\x3a"
          "\xaa\x7f\xf7\xa0\x5c\xe7\xcb\xc1\x24\x84\x7b\xac\x39\x27\xfa\x27\x78\x29\x1e\x04\x95\x26"
          "\x42\xe2\x4e\x09\x3b\xf1\x5b\x23\xff\x1d\x90\xf0\xb5\xc3\x7a\x93\x63\x85\x0d\x37\xf7\x1d"
          "\x5c\xb0\x92\xa2\xce\xc3\x73\x5c\x1b\xba\x63\x27\xd7\x3b\x2e\x81\x17\x50\xab\x78\x8c\x4a"
          "\x86\xa9\x34\xcd\xee\x0a\xbe\x3e\xcf\x59\x80\x44\x6b\x59\x72\x45\x0d\xb2\xb4\xfb\xb6\x2f"
          "\x10\x8a\xe1\xaf\xb8\x8f\x27\x13\x6c\x36\xe7\xce\xac\xc2\x77\x4c\x4b\xe0\x23\x20\x92"
          "\xf2",
          1, 1408 },
        { 128, 256, 74,
          "\xda\x4a\xb6\x84\x31\x97\x11\xc8\x4c\xcc\x75\xd0\x89\x82\x68\x2e\x61\x3f\x3a\x18\xfe\xa4"
          "\x46\x04\x97\x66\x01\x55\xa1\x1e\x69\xb0",
          "\xcd\x54\x79\xed\xd3\xa9\x00\xe1\xc1\x6a\xac\x57\x55\xe5\x1a\x83",
          "\xce\x85\x4e\xdd\x13\x88\xfe\x70\xc5\x37\xbb\xaf\xdb\x3e\xb8\x4f\x36\x54\x77\xc3\xd2\x18"
          "\x1a\x9f\x6b\xfc\x70\x63\x13\xe0\xea\x8a\xb4\xd7\x03\xa5\x93\x64\x7a\xeb\x0f\xde\x28\x11"
          "\x49\x82\x81\xec\x55\x0f\xdd\xf8\xe5\xae\x11\xe8\xdd\x26\xc9\x73\x95\x29\xd1\xbb\x26\x4d"
          "\x9b\x3c\x6c\xf5\xf6\x62\x02\x48\xb1\xc2\x87\xe0\xef\x69\xbc\x82\x67\x9a\x86\xde\x21\x01"
          "\x05\x9c\xfc\x9b\x51\xeb\xb6\xfe\xd7\xd7\xa8\x5b\xf4\x9a\xf2\xc3\x91\xc5\x29\xf6\xcf\x5d"
          "\x96\x48\x52\xfd\xa7\xb6\x0c\x1c\x77\x27\x3d\xa0\x3d\x5c\x29\x4a\x6a\xbe\x3c\x3c\xa5\xb3"
          "\xac\x24\xaf\xe9\x82\x89\xb5\x03\x9c\xb8\xef\xc3\xd2\xb6\x40\x97\x82\xab\x3a\x97\xc1\xee"
          "\x12\x74\x4a\xe1\x99\xf0\x2c\x7a\xbf\x4f\x37\xb4\x4f\xa8\x94\xe0\xa1\x0d\xc1\xab\x0c\xd3"
          "\x86\xbe\xd7\xd2\x3b\xe0\x69\x52\x58\xf6\x27\x37\xd8\x79\xb3\xad",
          "\xee\xa7\x79\xb7\xc8\x44\xfc\xf6\x22\xa1\x25\x3f\x3b\x37\xbb\xc1\x40\xd1\x4e\xa1\x2c\x85"
          "\x34\x2c\x00\x3d\x6c\xd4\x8c\x53\x50\xc4\x58\x2d\x26\xf1\x31\xf4\xa7\x4f\x72\x9e\x4c\x50"
          "\xf3\xa0\xd4\xe7\xe0\x6c\xeb\x57\xde\x5e\xb7\xe0\x25\xa3\x7c\xff\x08\x8f\xd4\x24\xcb\x2c"
          "\x3b\xe2\x07\xee\x6f\x76\x30\xd2\xf2\x3d\x6f\x33\x9b\x48\x5f\x59\x19\x83\x20\xdf\xbd\x78"
          "\x17\x58\x3c\x26\x80\x09\xdd\x55\xc9\xbb\x3e\x76\x8b\x8b\x87\xe0\x95\xdb\x54\xa0\xa1\xa9"
          "\x30\x1c\xf0\x47\x5d\x75\xef\xe7\x3d\xf5\xc2\xee\x85\xd8\x14\x93\x51\x47\xb8\x57\xff\xb6"
          "\x5b\x20\x71\x36\xa3\xb5\x7f\xd2\x69\x28\xa4\xc0\x0a\x54\x9b\xaa\x04\xcb\xb8\xb8\x7b\xc5"
          "\xfd\x1e\x84\xe2\x0e\x2d\x2b\xdb\x5d\x02\xed\x10\x40\x07\x52\x78\xc5\xa8\xb0\x66\x24\xc1"
          "\xc9\xf2\xb0\x3d\x8e\xb2\xa6\x56\x0b\xbb\x20\x93\x4f\xff\x18\x8c",
          1, 1536 },
        { 128, 256, 75,
          "\x18\x6e\x2b\x09\xfc\x5b\xc5\x65\x82\x75\xac\xbe\x69\xed\xf7\xbb\xcb\x90\xcc\x4e\xe4\x3b"
          "\xea\x66\xe5\xcf\xb8\xe2\xc1\x7a\xa4\x85",
          "\x5d\x1c\x2b\x9e\x73\x18\xd6\xaa\x6d\x9e\x79\xa7\x3c\x27\x32\xeb",
          "\xa4\x9b\x95\x69\xae\x46\xb1\x3d\xde\xe4\x1d\x2d\x4e\xbc\x98\x1c\xaa\x53\xb3\x7d\xa2\x15"
          "\x35\x54\xed\x5b\xf8\x40\xe0\xcc\x08\x02\xe7\x10\xb2\x36\x6c\x71\xe5\x8e\x72\x75\x39\x12"
          "\x19\x6b\x87\xda\x9e\xc2\xd9\x20\x60\xe4\x24\xe3\xeb\x95\xc7\xf8\x4b\x75\xd4\x43\xac\xe4"
          "\x99\x87\x78\xbc\x1e\x4e\x95\x2e\xfa\xcc\x43\x93\x88\xca\xae\x57\xa4\x37\x4c\xfb\x56\x68"
          "\x73\xd0\x0a\x8b\xba\x80\x86\xfa\x1e\x14\x36\xd5\xd8\x34\x20\xf2\x1c\xc8\x0b\x50\x69\x2d"
          "\x5a\xbb\x86\xca\xc6\x0f\x07\x43\x0a\x3f\x1a\xd6\x20\xae\xb1\x01\x16\x35\x7f\x5e\xb0\xcb"
          "\x7e\xd5\xa0\x73\x6c\x67\xb5\x65\x7a\xad\xc7\xf2\xef\x4f\xcf\x96\x27\x57\xf6\xa8\xf0\x00"
          "\x42\x2f\x31\xb7\x09\x93\x4b\x60\x18\xe8\x7f\x47\x81\x35\xf5\x11\xde\x36\xe3\xe9\x34\xe8"
          "\xd7\x96\xad\x5d\xbd\x8a\x1d\x60\x09\xae\x76\xd3\x23\xe1\xcb\xa1\x34\x66\x6c\xd9\xb9\x47"
          "\x1a\x42\xc7\x43\x9f\x55\x2e\x3c\xc0\x65",
          "\x46\x31\x9f\x0c\x4c\xba\xb0\x2d\xd7\x98\x72\x6a\x0d\x96\xcb\xf3\x56\x42\x7f\xba\x7f\x5d"
          "\xf6\x52\x33\x8b\x7d\xd3\x40\x67\xc0\xcb\x13\x96\x30\x82\x1d\xbf\x5d\x9a\xaf\x09\x76\x94"
          "\x6c\xa5\xd5\xe0\xdb\xcf\x61\x7d\xe7\xc3\x76\xc6\x36\x75\xdc\xf6\x87\xd6\x74\x58\x50\x83"
          "\x58\x11\x4f\x1b\x10\x0c\x9a\x8d\x61\x51\xa0\x05\x16\x5a\x65\x53\x53\xe6\x5e\x14\x72\xab"
          "\xba\x4e\xa8\x0b\x71\x68\x29\xeb\xa4\xa1\x2d\xdc\x0a\x16\x84\x97\x1c\x5a\xce\xf1\xd9\x0a"
          "\x24\xab\xa7\xa2\x88\xe8\x34\xc4\xe5\xa4\x6d\xac\x4f\x28\xa4\xa6\x4f\xd3\x99\x1c\x1d\xb4"
          "\x8e\x6f\x87\xbb\x58\x2a\xc1\x15\xd5\x1c\x4a\x99\x48\x07\x74\xeb\x8d\x5a\x3e\x6e\xa6\xdc"
          "\xbe\x20\xb1\x35\x1a\xe9\xd5\x49\x41\x6f\x65\xd6\xe2\xd7\x8d\x69\x58\x50\xaa\xae\x11\x93"
          "\x43\x95\xb3\xf7\xa0\x77\x7e\x25\x8b\x20\xc5\x56\xd5\xdf\x60\xe7\x75\x3c\x73\x09\xbd\x34"
          "\xa1\xea\x17\x36\x0a\xec\x83\x6d\xf1\x0c",
          1, 1664 },
        { 128, 256, 76,
          "\x90\xcd\x3c\xba\x11\x54\x66\xa7\xea\xdb\xca\x9a\x05\x5b\xd0\x4c\x44\x76\xa2\x6e\xa1\x97"
          "\x55\xe8\xa6\x07\xe3\x39\x60\x54\x32\x44",
          "\xa4\xf0\x24\xb9\x91\x7d\x7c\xff\xf1\x00\x77\x60\x98\x11\x46\x24",
          "\x27\x1a\xde\xec\xfd\xca\xc8\x5f\x27\x0a\x00\xc6\x2f\x92\xea\xef\xe2\x19\x92\xc7\x89\x9b"
          "\x67\x62\x2b\x77\x63\xfb\x34\x73\xc3\x43\xa6\xcb\x28\x6e\x9e\x67\xe4\xf5\x24\xe9\x91\x6b"
          "\xf0\x5b\xc6\x7f\x9e\x6c\x4d\xa0\xe7\xc2\x40\xd8\xb0\x20\xb8\xd7\x6e\x23\x60\xb2\xeb\x6e"
          "\xcf\x39\xf7\xcf\xbc\x65\xbf\x83\xfa\xcb\x28\x17\xd0\xac\xb1\xf6\x40\x6c\xc3\x15\x32\xd5"
          "\xf3\x8c\x4e\xe5\xfe\xb5\x7a\xd2\x93\xbc\x5f\x31\x08\x62\xfa\x4c\x6e\xaa\x3b\x57\x8a\x96"
          "\x40\xbd\xc8\x01\xdb\x31\x72\x8b\xa4\xec\x86\x5b\x6b\x09\x01\x8a\x84\x59\x81\x15\xaf\x1b"
          "\x10\xed\xac\x96\x96\x75\x80\xb8\x70\x49\x23\xcc\x0b\x34\xb8\xa4\xed\xe6\xfd\xef\xc1\x91"
          "\x3d\xd0\xd4\xf7\x76\xa9\x01\xce\x17\xb5\x9c\x95\xc7\x0c\x4a\x4b\x98\xfd\x69\x61\xa0\x24"
          "\xe5\xd6\xbe\xfc\x19\x6e\xb2\x83\x1f\x6a\x92\xa9\x10\xa4\xe4\x5a\xcf\x41\xad\x08\xf6\x79"
          "\x7d\xcb\x2e\x96\x39\x58\xcf\x1e\x46\x62\x22\x09\x22\x98\x06\x81\xf5\xbe\x47\xfd\xe4\x86"
          "\xed\x54\xdf\x57",
          "\xcc\x25\x92\xaf\x64\xea\x74\x4b\xb2\xa7\x62\x5b\x09\x50\x53\x02\x99\x01\x81\xc6\x2a\xc3"
          "\x5d\x65\x3b\x2b\xd2\xcc\x76\x02\x98\x9a\xb6\x75\x44\xd0\x93\xcc\x59\xd3\x52\x19\x26\x9e"
          "\x4b\x8a\x63\x44\xaf\x4b\x66\x25\x94\xc0\x85\x73\x1b\xde\x53\x50\x7b\xae\xf1\xeb\x80\xd1"
          "\x2b\x33\xd2\x40\xf8\xd5\xea\xf7\x10\xea\x6f\xc5\xa0\x28\xd0\x31\x91\x9a\x61\x9e\x73\x2a"
          "\x6e\x83\xb8\x94\x5c\x48\x02\x5f\xab\xc9\x00\x8e\x38\x18\x8c\x34\x39\x0c\x03\x70\x03\x5d"
          "\x02\x45\xfa\x04\x59\x61\xd5\xd7\xc8\x97\x7c\x0f\x40\x83\x4c\x1d\xeb\x28\x05\xe0\xf6\x2e"
          "\x90\x21\x4b\x52\xa1\xcb\x05\xa3\x80\xf2\x95\x94\xb5\x0f\x61\x22\x7a\x18\xab\x9e\x70\xae"
          "\x6c\xd9\x46\x82\x94\xc7\x5c\xe3\xa2\x29\xab\x85\x51\x4a\xbb\x7f\x92\x1c\x7e\x23\xf9\x89"
          "\xfb\x3c\xc8\x4f\x52\x10\xed\x88\x21\xf0\xf9\x04\x78\xfb\x23\x93\xb8\xbf\x2f\xa5\x23\xee"
          "\x91\xf3\xd6\x2d\xb3\x9f\x06\x12\x8a\xa2\x5c\xdb\x53\x8c\x23\xf4\xd5\xf4\x81\xe5\xa6\xd7"
          "\x55\x08\x6e\x61",
          1, 1792 },
        { 128, 256, 77,
          "\xc2\xf8\x2a\x50\x70\x76\x27\xde\xce\x75\xaa\x6e\x46\x5f\x48\xa4\xc7\xfa\x94\x35\x5a\x3a"
          "\xde\x10\x5c\xc6\x6e\x86\x30\x02\x55\xa5",
          "\x48\xb6\x9d\x11\x52\xbf\x1a\x43\x13\x39\xdb\x35\x91\x69\xaf\x62",
          "\xa2\x94\x56\x42\xb3\x4f\xac\x9a\x6e\xc6\xb6\x36\xae\xe4\xb7\x9f\xf0\xb5\xf5\x46\xa1\xd2"
          "\x27\x65\x4d\xfa\x69\x64\xc7\x65\x27\xd5\xd1\x71\x13\x3d\x72\x3a\x9c\xcf\xf6\xd5\x57\x4e"
          "\xc6\xb3\xa3\xd0\xea\xf9\x01\xc4\x02\x99\x2c\xb1\xe3\x52\x82\x6d\xea\x51\xa1\x02\xc8\x14"
          "\x83\xcb\x46\xa3\x9e\x20\x9c\x8e\x8b\xeb\x59\xba\x84\x05\xca\xf3\x2b\x86\x3a\x3e\x79\x80"
          "\x43\x25\xc7\xff\x2b\xa0\x6a\xa1\x6a\xf5\x9b\xed\x49\xb9\xa3\xb6\x31\xe4\xe1\x91\x77\x68"
          "\x65\x57\x3e\x40\xa4\x73\xbe\xd5\xb9\x2e\x9d\x40\x88\xec\xf4\x3f\x61\x83\x0a\x7e\x43\xc4"
          "\x1e\x9e\xd6\xe4\xc4\xdd\xc2\x25\xbc\xa8\x70\x0b\xe3\x20\x76\x6b\xcb\xff\xda\x65\xf6\xe6"
          "\x83\xb9\x35\x91\xc8\x8a\x12\x67\xc5\xff\xda\xd1\x5a\xe6\x2f\xc1\x92\x16\xc3\xe3\xb6\xc9"
          "\x1b\xa9\xe9\x2d\x53\xa9\xa2\x15\x4d\xab\x2a\xdb\xd5\x61\x3a\xe0\x65\x1f\x92\xe4\xb2\x71"
          "\x04\x4b\x50\x97\x67\xc5\x37\x58\x48\x7e\x76\x99\x24\x25\xe3\x26\x8f\xaf\xec\xa8\xcc\x0c"
          "\x61\x72\x54\xb6\xc6\x0b\xc3\x89\xa3\xd4\x39\xe8\x9f\xb2\xa9\xae\xb8\xaa\x80\xbd",
          "\x76\x0c\x39\xa5\xf4\xc5\x3f\x4e\xa0\x8c\x8e\x33\xf2\xd0\x5e\x78\x69\x78\xdf\x4f\xb8\x88"
          "\x73\x5e\xd5\x70\x49\xb5\xff\xd1\x32\x73\xb9\x78\x21\xd0\xb0\xd7\x76\xa5\x28\x62\xf0\x84"
          "\xfb\x0f\x2b\x87\x07\xb6\xde\xd7\xcb\xdc\x78\xa5\xa7\xde\x03\x4b\xeb\x09\x1e\x0d\x95\x04"
          "\xeb\xeb\xb2\x8c\xa9\xfa\x56\xa2\x5d\x39\xb4\x65\x87\x45\x4b\x86\xfa\x08\xa0\x3d\x6a\x5c"
          "\x47\x06\x8f\xef\xdb\x8d\xce\xa5\xa1\x7f\x91\x76\xd7\xe1\xf2\x19\x33\xfb\x9b\xee\x20\x8f"
          "\x7e\xe7\x06\x3a\xd4\x0f\x85\x33\x0c\xf1\xe9\x89\xd7\xdf\x55\xac\xe7\xb2\xe5\x28\xa2\x98"
          "\x83\x28\x98\xaf\xf0\xfa\x64\x9c\x97\x5c\x22\xf5\x33\xaa\xaa\xb9\x6c\x25\x25\x37\x89\xe2"
          "\x60\x72\xa0\xf6\x0f\x1c\x17\x85\xb6\xb8\x75\x3f\x02\xca\x19\x92\xa4\xd1\x63\xdf\x49\xda"
          "\x5b\x0b\x14\x6c\xb3\xb3\x38\xa6\xb0\x83\x28\xac\x74\x71\x90\x41\x4c\x57\xfa\x56\x55\x72"
          "\x52\x04\x56\xc4\x73\xa5\xa4\xd3\x03\x67\xc7\x83\xfb\xdc\xe9\x1c\x8f\x34\xbd\x5d\x94\x40"
          "\x54\x49\x28\xa3\x63\xfa\x0f\x54\xd4\x17\xd2\xb2\x80\x2d\xce\x74\xe4\x39\x06\x1f",
          1, 1920 },
        { 128, 256, 78,
          "\x54\x60\xed\x05\x6b\xa3\x06\x5d\x88\xe6\xb4\xef\xa6\x10\xf4\x8f\x31\x1a\xb4\xca\x3b\x46"
          "\x38\xc4\x98\xe5\xe6\xda\xb1\x25\x2a\xe9",
          "\x84\x30\x74\xca\xe3\xe2\xa1\xec\x22\x67\x3f\x01\x1a\x4e\x15\xa5",
          "\xb3\xc6\xde\xf9\xf9\xd5\x1d\x29\xde\x8b\x65\x1e\x51\x9e\xb8\xf6\xcc\x5f\xda\x2e\x8c\xaf"
          "\x5a\xab\x0a\xd4\xdd\x9b\xf1\x3f\x22\xa9\xb2\x3a\x52\x5a\x28\xf4\x6e\x23\x2a\xfc\xf7\x3d"
          "\x47\xfc\x0f\x3b\x2b\x7f\x03\x2b\x5b\xe4\x27\xd6\x0c\x11\x0f\xb7\xe7\x29\xbc\x63\xc3\x59"
          "\x55\x89\xbe\x8f\x1b\x99\x90\xa9\xfd\xa7\xc8\x9f\xf6\x91\x73\x17\x63\x0a\xa6\x07\x2b\xa5"
          "\x4b\x78\xcb\x15\x85\xd7\x5e\x20\xd7\xec\xe7\x29\x24\xf8\xdf\x6f\x92\xc2\x77\xaa\xb8\xf6"
          "\x64\x30\x2b\xbc\xa7\xe1\x42\xd3\xc0\x0e\x96\x5e\xa0\x94\xea\x2a\x0f\x47\xf5\x9d\x7c\x0f"
          "\x0c\xe4\x5f\x38\x8f\x83\xa9\x7f\x85\x99\x43\x87\xcb\x83\x2e\x33\xeb\x7f\x79\x00\x85\xab"
          "\x90\x66\xc0\x6d\x89\x12\xc4\x36\x86\x6d\x2b\xd6\x78\xed\xb5\x1f\x0b\xf6\x9a\x6f\xee\x6d"
          "\xd0\x07\x53\xc1\x35\x0a\xba\x3b\xa7\x32\x33\xbb\xb2\xb6\xd8\x99\xdb\x04\x4b\xfc\x67\xad"
          "\x39\x2c\xfc\x51\x73\x58\xcb\x4c\xbd\xb4\x29\x6b\x2b\x46\x99\x8e\x23\xea\xc9\x88\x48\xf9"
          "\xb1\x36\xed\x32\x02\x67\x28\xe8\xf7\x42\x54\x28\x04\x89\xae\x01\xaa\xe2\x66\x52\x71\xb0"
          "\x7f\xa7\xff\xeb\xc6\x7f\xfa\xad\x07\x93\x4a\x6f\xf3\x4f",
          "\x9e\x63\x30\x3a\x5a\x27\xba\xe4\xbc\xad\x33\x1c\x37\x6a\x0f\xaa\x3c\xad\x81\xca\x3e\xac"
          "\x63\x56\x4d\x58\x79\x21\xd3\xe7\xd7\x19\x31\x40\x8c\x21\xe7\xb6\x56\xc3\x34\x42\xaa\x49"
          "\xbb\x01\xbd\x45\x07\x32\xab\x8d\x32\x30\x3f\xa5\x3d\x9d\xa7\xc2\x7b\x5a\xee\x88\xe9\x3f"
          "\x5a\x29\x90\xe3\xe6\xbd\x6f\x3a\x74\x82\x5a\xb5\x52\xed\x1e\x1d\x72\x15\x90\x01\x95\xff"
          "\x16\x15\xd8\xc2\x8d\xfb\xd3\xa2\x7f\x06\x2e\x17\xe0\x93\xb7\xdb\xae\x9d\x62\xc9\xc6\xcd"
          "\x4b\xdc\xa0\xfc\xe2\x9b\x48\xad\xfe\x6c\xc8\x93\x6c\x92\x6a\x7f\x6c\xc4\xe4\x16\xde\x94"
          "\x70\xed\x15\xf7\xa3\x2e\x0f\x41\xbf\x6c\xc1\x0b\xd4\x6e\x08\xdc\xe6\xe1\x5b\xb6\xe0\xfe"
          "\xfb\x48\xc9\x6b\x10\x8a\x33\xcc\xdc\x6b\x81\x47\x58\xdf\x74\x6f\xdd\xd4\x5f\xe3\xad\xea"
          "\x48\x05\xef\x61\xb6\x8c\xfa\x70\x32\x36\x9c\xb0\xb7\x00\xdc\x9d\x68\x2a\x81\xf9\x25\x39"
          "\xa6\x05\x16\xef\xc7\xc4\x4f\xa0\x54\xbd\x05\xb4\x78\xc2\x04\xc1\x36\x44\x2d\x8c\x64\xb7"
          "\x30\xf5\x75\xb8\x3b\x29\x22\xf5\xc4\x48\xef\xb7\xa5\x30\xf5\x9f\xd8\x5b\xe9\x0f\x14\xd9"
          "\x67\x86\xaf\xf4\xb7\xa1\xed\x63\x1e\xed\x87\xf8\x03\xec",
          1, 2048 },
        { 128, 256, 79,
          "\x62\xac\x39\x1d\x2a\x14\x09\x4d\x23\x98\x46\xa1\x22\x50\x67\x72\x86\x75\x3a\xc3\x18\x2b"
          "\x3a\x6d\xd8\x96\xe1\x68\xe6\xe4\x57\xab",
          "\x78\x71\x85\x23\x19\x60\xe4\xb1\x71\x77\x89\x8e\x4b\xb8\xad\x81",
          "\xc0\x68\x97\x7d\x39\x18\x5f\x73\x54\x24\xe2\x4e\x66\x19\x74\x66\x2c\xa0\xfb\x87\x22\x7c"
          "\x4a\xae\x16\x87\x8b\x9d\xbd\xac\x23\xce\xa6\x6c\xf8\xa4\xf6\x79\x81\xf2\x58\x47\x53\x73"
          "\x70\x3b\xa6\x9d\x3e\x4b\x33\x97\x50\x4c\x50\x11\x61\x19\xf1\x64\x84\x42\x43\x1f\xc8\x11"
          "\x29\x75\xc4\x7b\xb6\xc5\x36\xfc\xfc\x3a\x59\xc2\xaa\x18\x8f\x19\xd9\xd4\xa7\xd3\x2a\x52"
          "\xae\xba\x47\x02\xc6\x33\xeb\x5f\x58\x43\x89\x9f\x88\xdd\x1b\x12\x0b\xf4\xf9\xbf\x67\x5b"
          "\xca\x66\xf9\xf8\xd7\x3b\x30\xec\x60\x56\xa8\x3e\x56\xba\xf2\x7c\x54\x5b\x7f\x23\x96\x90"
          "\xdc\x35\x98\x97\x48\x2a\x7d\xf6\xf1\xba\x81\x28\xec\x2f\xe1\x3c\xfd\x1e\x2c\x97\xf8\x01"
          "\xa9\x00\xfd\x00\xa9\xcc\xa3\xc8\x7b\x90\x71\x61\xa4\xe5\x8a\x3c\x4e\x03\x46\x10\x1b\x99"
          "\x3a\xb6\xfb\xc2\x58\xd8\x73\xe6\xf1\x05\x08\xb4\x8a\x54\x58\x91\x82\xd9\x65\xf9\x2b\x2d"
          "\xc3\xc7\x5c\x71\xaf\x12\x3e\x76\xe8\xf9\xb5\x19\x03\x88\xdc\x18\x1c\x07\x8a\x94\x45\x46"
          "\x7e\x3c\xe2\xf1\x4a\xa6\xb0\xb4\x77\xe9\x4f\xd0\x1c\x2a\xd2\xac\xe7\x61\xe3\x9b\xb8\xd4"
          "\xd5\x72\x9c\x91\x20\x6f\xd4\xe0\x11\xbf\x3f\xa7\x2c\x91\x61\xe8\x7e\xf7\x82\x87\xfb\x8a"
          "\x8d\x44\x5f\xa7\x5e\x2c\x7d\xc6",
          "\xaa\x4f\x08\x63\x77\x74\xfe\x48\xe2\x37\x65\x7f\x61\x28\x82\x58\x87\x19\xc6\xa0\x8a\x08"
          "\x47\x3f\x2f\x85\x20\x71\x5e\xc9\x6c\x30\x7e\x0e\xa4\xef\xc8\x35\x88\xdd\xc7\xc3\x81\xfb"
          "\xd7\xcd\xea\x9f\x27\xb2\x2f\x33\x24\x2e\x52\xcf\x93\x73\x78\x68\x81\x2d\x54\x8f\xa1\x7c"
          "\x7e\xa8\x68\xc4\x8d\x8d\x5c\x66\xa4\x05\xfe\xff\xc1\x46\x31\x07\xe7\xf8\xad\x60\x58\xef"
          "\xd3\x9f\x29\xb4\xc7\x8d\x7a\x34\x62\xe7\x70\x8e\x32\x61\x36\xc4\x06\xca\x54\x9d\x66\x47"
          "\x51\x8c\x52\x1c\x54\x78\xe5\xd3\xac\x7e\xe2\x16\xcd\x19\x31\x74\xd3\x68\xfb\x17\x58\xbd"
          "\xbe\xac\x87\xc5\x1d\xde\xc3\xda\x3e\x2b\xea\x55\xaa\xcc\x03\x95\x81\xde\x77\x1b\x23\x25"
          "\xd3\xef\x68\x53\xe4\xf4\x03\x11\x8b\xb4\x47\x22\xd7\x9a\x8a\x07\x31\x74\xf0\xd3\xb8\xcb"
          "\x62\x7f\x3b\x6a\x53\x71\xc4\xfe\x8b\x94\xfe\xdf\x06\x48\x70\x70\x3f\x43\x08\x6b\x24\x28"
          "\xa1\x1f\xa1\xe2\x71\xf0\xab\xad\x2c\x3d\x6f\xdb\xe3\x48\xfe\x0e\x9a\x6b\x7f\xfe\x7e\x37"
          "\xe3\x28\x07\x98\x68\x13\x37\x63\xa8\xd7\x6e\x70\x82\xb5\x22\xfb\xc6\x1d\x41\xbf\x83\xa5"
          "\x3d\x14\x65\x3a\xce\x28\x40\xdc\x61\x29\xba\x43\x78\x7a\xdd\x03\xf3\x18\xd6\x9a\x29\xe8"
          "\xf2\x73\x1f\xf6\xd9\x3f\xbf\xf4",
          1, 2176 },
        { 128, 256, 80,
          "\x21\x81\xa2\xb1\x66\xed\x25\xf0\x1a\xed\x5a\x21\xca\xf1\xf5\x2a\x8a\x78\x18\xeb\x0a\x0b"
          "\x9f\xc4\xd3\x6d\x3a\xe3\xe1\xef\x67\x02",
          "\xec\xa5\xf8\x61\x0e\xf4\xaa\x28\x27\x67\xd2\x71\xfe\x5e\xfc\x68",
          "\xf0\x56\xf0\x7d\x6c\xfc\x74\xef\x51\x5a\x9f\x8f\x29\xfa\xbd\xe5\xea\x7f\x4f\xbb\x68\x52"
          "\xc5\xdc\xc7\x9a\x2c\xb9\x7d\xdd\x08\xa0\x8c\xd8\x93\x5b\x8b\xf2\xc8\xdf\xfc\x50\xda\x2b"
          "\xb7\x86\x30\x8d\xb3\x0e\x8a\x69\xc0\x80\x97\x4c\x6d\x1a\x4f\x53\x28\x30\xb2\x84\x50\x61"
          "\x55\xf2\xa8\xa5\x2e\x2a\x33\x72\x70\x7b\x4a\xfd\xf3\x20\x3b\xd5\x53\x54\xd2\xbe\xcd\x90"
          "\xac\xc9\x86\x9e\xb9\x4a\x09\x87\xc5\x56\x2f\x58\x43\x5a\xb7\x32\x20\xed\x44\x07\x08\x53"
          "\x7e\x87\x52\xe1\x80\x4e\x6f\xce\xdd\x59\x69\x95\xfe\xd7\x7c\x82\x43\x3d\x56\x88\xa2\xcc"
          "\x27\x66\x50\x0f\xa3\xc1\x39\x93\x1b\xd8\x40\xe3\x95\xa5\x11\x5f\x11\x07\x4d\xde\x6d\x59"
          "\xfe\x9e\xcb\xf7\x6e\x99\x1f\x11\xd2\x54\xca\x17\x6a\x11\xee\xc0\xae\xb8\x80\x2d\xa7\x13"
          "\x6d\xd5\x02\x59\x32\x3c\xa9\xfa\xe1\x39\x3e\x68\x17\x3e\x8d\x07\xde\x29\xb9\xaf\x38\x63"
          "\x08\x9b\xed\xce\x59\x4a\x6f\x29\xe6\x6a\x6d\x10\x86\x8c\xf0\xfe\x00\xdd\x3b\xd2\xe7\xc9"
          "\xad\x63\x32\x5d\x3e\x5d\x0a\xfd\xd7\xac\x83\x3f\x9f\x42\xa0\x22\x55\xe1\x1a\x73\x89\x80"
          "\xc9\x23\xc6\xda\x34\x5f\xed\xc9\xeb\xaf\xf3\x7e\xf3\x8d\x43\x9c\x66\x87\x3c\x96\x51\x75"
          "\x60\x74\x8b\x97\xa8\x36\xe6\x43\xfc\x2e\x14\xc2\x7f\x1e\x3e\x2f\x04\x64\x5b\x77\x07\xcc"
          "\xdd\x60",
          "\x42\x41\xa5\x7f\xe5\x4a\x13\x1b\xb9\x33\x13\x19\xa4\x44\x30\xc5\x1e\x3e\xbc\xf5\x12\x6c"
          "\xe5\xf9\xca\x22\x8f\x36\x6a\x0f\xf5\x1a\xb9\x81\x67\x17\xf6\xd9\x80\xfe\xf7\x47\xcc\x98"
          "\xbd\xd6\x99\x49\xf9\xbd\x73\x96\xf5\xdd\xd4\x6f\xfa\xf0\x9b\xa9\xcd\xce\x42\x60\xbe\x8e"
          "\xe6\x03\x87\x75\x94\x24\xda\x59\x4c\x1e\x0d\x7c\x20\x07\x6c\x97\x79\x02\x64\x58\x33\x80"
          "\x8d\x22\x80\xc4\x2d\x70\x7d\xec\xac\xaf\x9b\xc0\x49\xb8\x6c\x43\x83\x1d\x40\x27\x34\x98"
          "\x68\x73\x60\x70\x66\x93\x54\x03\x22\x45\x82\x65\xbb\x5d\x4e\x79\xc5\x81\x63\xfc\x7c\x92"
          "\x64\x4d\x15\x6a\x59\xda\x62\xb8\xc5\xd5\xc8\xd2\xbf\xb6\x7d\xc3\x67\x43\xd8\x37\x65\x65"
          "\x44\xba\x1e\x35\x6f\x49\xc3\x89\xf2\xb5\x3b\xdf\x4a\x95\xcb\xcb\x43\x0e\x55\xbb\x7f\x68"
          "\xfb\x64\xdd\x1d\xe5\x97\xf1\xef\x77\xae\x37\x95\x0e\x6e\x35\xb9\xdd\x31\x17\xd7\x00\x73"
          "\x71\xe3\x75\x35\x73\xe4\xdf\x0b\x91\x57\x02\x6b\x7a\xf7\x4b\xe8\x85\x32\x14\xf3\x3f\xf3"
          "\xb2\x93\x99\xa5\x55\x67\x05\xc5\x7a\xa3\x10\x2c\x2e\x6b\xbd\x17\x88\xa5\x3f\x26\xb6\xd5"
          "\x8f\x7f\x8b\xe9\x4a\x80\xdf\x3a\x7e\x49\x0d\xa5\x3c\xc7\x4c\xe8\xb8\x8b\x84\x7b\x01\x90"
          "\x0b\x1b\xbd\xa8\x16\xe0\xfc\x3a\xc5\xd6\x72\xdf\x8b\xa2\x3e\x5b\x8b\x6a\x3e\x14\xd1\xfd"
          "\xb9\x30",
          1, 2304 },
        { 128, 256, 81,
          "\xf6\x29\x7e\xcd\xd3\xdc\x82\x06\x98\xbf\x04\xab\x78\x6b\x3a\x67\x54\xba\xee\xc6\xc2\x8e"
          "\x68\xa2\x0c\x13\x23\x34\xa5\x8f\x01\x9e",
          "\xa4\x42\xeb\xeb\xe9\x67\x97\x74\xbb\x4c\x27\xf2\xbb\x33\xff\xf7",
          "\x9d\x17\xbc\x84\x69\xa0\x43\xfe\xbb\xbc\x45\xa4\xf6\x8f\xc0\x28\xad\xaa\x32\x1d\x33\x11"
          "\xd7\x40\x21\xd3\x28\x7a\xab\x7d\x8e\x40\xa2\xe6\x81\x2e\x39\xec\x51\x9f\x24\x8c\x0e\x13"
          "\x54\x85\x42\xa3\x0c\xa7\xb5\x3f\x3f\xc8\x8e\x4c\x93\xdb\xf5\x7d\x0f\x0e\xaf\x37\x26\xe0"
          "\xf1\x57\x2e\x4f\x3f\xda\x7f\x65\x91\x80\x66\x51\xa6\x66\x89\xd4\x23\x14\x15\xab\xed\xc1"
          "\x6d\x73\x9b\x99\xdc\x47\x96\xe4\x93\x67\x9b\xf9\xe1\xd5\x10\xf7\x13\xf7\x37\x51\x20\x7b"
          "\x5f\xe3\x45\xb0\x76\xf1\xc6\x5f\xff\x0d\x97\xb7\x2f\xbd\x6a\x20\xbe\x1f\xcc\x21\x8f\xed"
          "\xeb\x43\xd7\x00\x0c\x53\x52\x55\xd3\x81\x14\x03\x7a\x0f\xf3\x8e\xe9\x73\xd5\x42\x01\x98"
          "\x49\x08\xb6\x19\x05\xf3\xe9\x1a\x72\x39\xdb\xb4\xfe\xef\x60\xc0\x4d\x0c\xc8\xc9\x79\xe8"
          "\x1c\x99\xba\xd2\xfe\x71\xa7\xd4\xbb\xbc\xa4\xed\x66\x5d\x2f\x96\x09\x12\x3b\xf4\xc5\x12"
          "\x50\x71\xda\x76\xf1\x59\xb2\x29\x9b\x56\x7e\xef\x55\xa3\xbe\xf4\x49\x8a\x66\x32\x63\x58"
          "\x3c\xa6\x69\x58\xf2\x76\xfe\x16\x1d\x8e\x65\x92\x3d\xed\x20\x29\x1e\xd1\xfa\x19\x86\xcd"
          "\x38\xe1\xc9\xcf\xdd\xbf\x06\x82\xac\xd1\x32\x3d\x92\x22\x39\x7a\x9e\x69\xcb\xb3\x51\xa5"
          "\xb7\x0b\x3c\x3e\x4a\xbf\x45\xfd\xa6\xac\x87\x3e\x24\x5b\x30\x04\xe5\x08\x70\xd4\xf8\xb1"
          "\x36\x75\x30\x8d\xc2\xe8\xfc\x78\x5f\xae\x82\x87\xd9\xe6\xad\x08\x47\x18",
          "\xa8\x61\x0b\x64\xa3\xa4\xbe\x13\x9a\x3f\x30\xff\x40\x0e\x88\x87\x98\xac\x06\x17\xc1\xe7"
          "\xbb\xbf\x8a\x85\x1c\xa5\xc0\x5b\x35\xa2\x70\x30\x00\x86\x64\xb8\x83\xd4\x41\xa0\x25\x77"
          "\x15\x85\xde\xcf\x8e\xb2\x53\x3d\x46\xe2\x24\x8c\x8f\x10\xb6\x78\x81\x3b\x29\xfb\xfc\xce"
          "\x97\xb3\x4a\x9e\x7f\x6f\xb9\x61\xc0\x44\xa0\x81\x9b\xed\x64\xff\xef\x58\x05\x8c\x59\x89"
          "\x08\x15\xc6\x86\x9a\xed\x93\xfa\xd5\x4f\x4e\x1a\xf8\xd0\x0c\xd3\x40\xb3\xd1\x93\x6d\x19"
          "\x05\xae\x7d\x57\x5e\x90\x5e\xe5\xa3\x45\x21\xb4\xac\x35\x74\x15\x4e\xd9\x52\x93\x68\x4b"
          "\xf5\x51\x69\x3c\xca\x5c\x67\xda\x7b\xc1\xa2\xc2\xff\xca\x3e\xb3\x97\x1d\x3d\x92\xb1\x14"
          "\x50\x6d\x97\xa7\x3f\x6f\x2a\x53\x9f\x18\xe2\x76\x72\xa5\xb1\x6a\xa1\x38\x91\xc7\x5a\x62"
          "\xaa\x67\x54\xb6\x08\xce\xe1\x57\xb9\x78\x3a\xdd\x51\x46\x78\xf7\xbe\x1c\xd3\x2b\xc5\xbc"
          "\x05\x10\xcd\x75\xb5\x26\x1f\x4d\x7d\x1f\x7a\x6b\x55\xba\xd5\xb2\x74\xc8\x8c\x8c\xbe\xbe"
          "\x28\xfd\x32\xe4\x38\x50\xe3\x3e\x0a\xb5\x07\x5e\x7e\x37\x96\x26\x31\x5d\x67\x73\x97\x43"
          "\x89\xc9\x0f\xfa\x65\x00\x05\xc9\xa8\xdd\xa6\x78\xdf\x5c\x7d\x80\xe2\xc4\xb9\xa0\xe7\x21"
          "\x61\x59\xf6\x0d\xc1\x57\x78\x5e\x79\x87\x68\x6e\x3a\x13\xb1\xab\xba\xa5\x36\x7e\xca\x36"
          "\xea\xeb\xa5\x4f\x0a\xbc\x7f\xea\xe3\xda\x56\x21\x35\x09\xd8\x23\xbe\x7c",
          1, 2432 },
        { 128, 256, 82,
          "\xb2\xe4\x5e\xe9\x58\x4e\x53\x41\x9d\xe0\x6d\x33\xe3\x49\x53\x22\x22\xa8\x6e\x5c\xe6\x08"
          "\x51\x0c\xde\xc2\x32\x1a\xe2\x33\x0d\xec",
          "\xe1\x84\x63\x01\x18\xbe\xee\x0c\x8b\x14\x04\xd6\x67\xc0\x46\x37",
          "\x6c\x4c\xee\xe0\xf4\xeb\x85\xe8\xfe\xe1\x60\xf2\x15\x8f\x9a\xab\xd0\x24\xae\xe9\x76\x65"
          "\xa8\xfa\x95\xe4\x2a\xd7\xed\x9c\x17\x5d\xa1\xed\x5a\xc7\xd4\x17\x56\x6e\xdc\x40\xa2\x5d"
          "\xc2\xc1\x0e\x78\xf8\x2e\xcc\x8f\xda\x46\xe0\x06\x94\x78\xe1\x3f\x66\x3b\x6f\x87\x7d\xf6"
          "\x36\x17\xec\x64\x58\xa7\x97\x14\x2d\xb3\x69\xe3\x50\x13\xbc\xd8\x80\x70\x22\x81\x2b\xb4"
          "\xff\x8c\x33\xd0\x67\xad\x40\x7b\x25\xa0\x25\xb9\xcc\xd6\xda\x14\x70\x29\x15\x18\x19\xf6"
          "\x54\xad\x7a\xcc\xe3\x9a\xb3\xea\xb4\x88\xf7\x0a\x0c\x1a\xf3\x45\x66\x8c\x27\x54\x6f\x45"
          "\x43\x7c\x73\xdf\x6b\xb6\x89\xb3\xaf\xd2\x7e\x29\x9a\x3c\xe0\xe2\x33\xe7\x9d\x03\xbc\xda"
          "\xde\x5d\x6a\x02\xdd\x00\xff\x43\xc7\x94\x68\x21\x84\xcf\xda\x38\xb1\x94\x08\xc2\xe3\x56"
          "\x3f\x40\x44\x20\x4f\x09\x51\xca\x90\xe9\xc3\x03\x34\x6b\xc5\x34\x00\xdc\xe1\xf4\xfa\xbb"
          "\x0c\x46\x30\xb6\x7b\xb0\x10\x5f\x1b\x0e\xf2\xb8\x95\x29\x4b\x7a\x6f\xa8\x57\x3c\x1e\x28"
          "\x75\x82\xb4\x95\x8a\xbc\x36\x0f\xa6\x4e\xcb\x83\x7e\x37\x82\x1e\xc2\xd6\x2e\xdf\x05\xe0"
          "\xab\xd8\xf7\xc4\xce\x99\x44\xe8\xce\x97\xa7\x5f\x18\x28\xfe\xbe\x68\xca\xad\x2b\x2a\x19"
          "\x48\x58\xdd\x9f\x2a\x65\xbb\x6e\x95\xbf\xce\x35\xc7\x99\xa0\xcb\x19\x7f\xef\xb9\x32\x70"
          "\x1a\x88\x7c\x59\x64\xc9\xbe\x28\xff\xe3\x33\x07\xf3\x70\x89\x9b\x18\x05\xd7\x75\x67\x0b"
          "\x88\x0d\xf7\x93\x5e\x4f\x6c\x29\x3b\x40\xca\x11",
          "\x34\x6a\x04\x40\xb0\xd1\x35\xb3\x59\x93\xed\xe4\xd3\x0b\x40\x84\xbf\x8e\xdd\x9b\x63\xfc"
          "\xe0\x43\x72\x2a\x25\x73\x48\x8b\x7a\x5b\xee\xc8\x09\xf8\xdd\x5a\x05\x82\xd6\x14\xa1\x9c"
          "\x18\x3d\x36\x34\x23\xba\x05\xe8\xd8\x16\xaf\xcc\x60\x06\xff\xd2\xc2\x9c\x60\xa3\xad\x45"
          "\xbf\xa8\x7f\x93\xb3\xae\x7a\x67\x6a\x72\xe1\xb8\x9d\xaa\x6c\x65\x97\x68\x0a\x2d\x9b\x51"
          "\x6b\x53\x9a\x27\x2d\xd8\x85\xad\x05\x99\xed\x84\x87\xdd\xba\x38\xa9\x55\x51\x50\x57\x86"
          "\x25\x2c\xf8\xbf\x18\xf9\xc8\x4f\x2f\x3b\x30\xf9\x3f\x85\x16\xfb\xb0\x6e\x44\x1b\x52\x1d"
          "\x1f\x31\xfc\xb7\x75\xba\x18\x18\x7c\x28\x73\x9b\x8d\xf1\x75\xac\xba\x12\x45\x4d\x59\xac"
          "\x20\xea\x19\xdb\xc8\xaa\x94\x40\x90\xa3\x08\x71\x69\x29\x7b\x86\x54\x51\xd3\x63\x4f\xdc"
          "\x61\xaf\xfc\xed\x18\x17\x2d\xe6\x59\x98\x32\x11\xac\xb4\xf5\xf3\xe2\x00\xaf\xc9\x43\x33"
          "\x9d\xfe\xfa\x53\x03\x2f\xde\x0a\x65\x81\xd7\x32\xae\x72\x8a\x52\x86\x57\x53\xed\xd5\x45"
          "\x37\xc9\x9a\x1e\xd1\x9a\x2e\x0a\x39\x87\x04\x33\x61\x9b\x5c\x07\xb0\x69\xef\xd0\x49\x80"
          "\xc5\x32\xf5\xa6\x64\xf5\xd7\x86\xbc\x48\xdd\xea\xf0\x90\xb7\x46\x01\xe2\x67\x53\xb4\xe5"
          "\x48\x5d\x69\xae\xd0\xf4\x49\x79\xd8\xb4\x93\x37\x81\x46\x28\x32\xf2\xa5\xad\x47\xed\xc1"
          "\x26\xca\x2b\xa8\x40\x21\x97\xf0\x94\x67\x3c\xa7\xa9\x3d\x0a\xd5\x97\x67\xba\xc5\xe8\x19"
          "\x2d\x40\xf6\xed\x7d\x06\xed\xaf\xad\x8a\x76\xb9",
          1, 2560 },
        { 128, 256, 83,
          "\x71\xff\x8d\xe4\xd1\x07\x10\x7c\xac\x7a\xde\x20\xdb\x81\xc7\x2e\x6e\x2f\x80\xfc\xeb\x7d"
          "\x90\xb4\x68\x06\x28\x09\xb5\x9b\xdf\xda",
          "\x19\xfb\x5b\xb5\x6f\x01\x34\x32\xc3\xd1\x97\x44\x73\x47\x1b\xbf",
          "\x16\xdd\x12\xe4\x2d\xb2\x26\x67\x7a\x8a\x90\x6b\x71\x37\xa2\xab\x95\x1f\xaa\x57\xb5\x8f"
          "\xea\xf4\x50\x84\x81\x74\xbc\xfd\x8c\x83\x84\xc2\xd7\x0f\xe5\xee\xd6\x06\xcb\x39\x3d\x97"
          "\x69\x37\xeb\xf0\x51\x80\x3a\x0c\xab\xc6\x4e\xcc\x8d\xcd\xd0\x2e\xe3\xdc\x46\x1d\x34\x90"
          "\x18\xc7\xd5\xab\xb3\x25\xc7\xb3\xac\x92\x7a\x3f\xb7\x21\x1b\x9c\x5c\x82\x85\xfa\xe7\x49"
          "\x52\xe7\x52\x0a\x49\x7a\x6b\x06\x1c\xdc\x7f\xeb\x09\x8b\xc0\x5c\xce\xe7\x44\x40\x1e\xd4"
          "\x2d\xd1\x36\xdc\x09\x4c\x8b\x26\xdb\x89\xe9\xf6\xb2\xdb\x8c\xf4\x3b\x6a\x29\x57\x89\xe8"
          "\xe2\x3b\x19\xa2\xd4\x57\xe4\xba\x19\x5d\x1a\x13\x82\x87\x90\xab\x91\x06\x73\xbd\x99\x4f"
          "\x80\x27\xcb\xa0\x98\x02\x93\x24\xd3\x6e\xab\x57\xb9\x7d\x77\x0c\x2f\x08\x71\x21\x46\x9c"
          "\x64\xd4\x7e\x63\xe6\x08\x8d\xf6\x45\x90\x73\x86\x1f\x88\x92\x14\x52\x18\x8d\x30\x6c\x71"
          "\xa3\xab\xe7\x2d\xbb\x22\x01\x81\x70\xf3\x32\x47\xab\xd4\xa1\x19\x27\x7a\x18\x6d\xfb\xb1"
          "\x21\x27\x23\xe9\x18\x6c\x84\x28\x66\xd6\xe5\x70\xbd\x85\xd3\xfd\x6f\x76\xe0\x53\x32\xa3"
          "\x58\xf5\x35\x69\x40\x27\x29\xca\x71\x29\xbe\xa5\x4c\x71\xf3\xa7\x24\x1b\x12\x69\x57\xfe"
          "\x8f\x0b\x5c\xeb\x94\xe6\x93\xa0\xcc\x8d\x4a\x50\x0d\xdb\x95\xb5\x18\x2d\xa8\x83\x8c\x8a"
          "\x98\x59\xa3\xf3\x25\x1f\x31\xe8\x1b\x6f\xca\xf5\xb6\x62\x2a\x11\xeb\x81\x28\xe1\xf4\x22"
          "\x6a\xb4\xee\x07\xf9\xc3\xe1\x5b\xdb\x71\x11\x7b\xc6\x56\xf8\x64\xf9\x1b\xc9\xc8\x62\x19"
          "\xff\x99\x8d\xe3\xe4\x19",
          "\x52\x99\x63\xcc\x71\x43\xfe\xee\x1f\x72\x1f\x8b\x0f\x51\xa9\xb9\x2d\xb8\xee\x5e\x7a\x1b"
          "\x80\xe6\xf1\xf9\x69\x2a\x65\xb4\x5b\xce\x42\xf5\xf6\xae\xcc\xd7\x01\xfe\x19\xa2\x07\xef"
          "\xd4\xe2\x65\x5c\x4f\xc2\x13\x38\x1e\x61\x24\x14\x75\xed\x28\xad\xc3\x0c\xb7\xd7\xac\x57"
          "\x1a\x23\xf1\x1c\x9e\x93\xd7\x01\x42\x43\x89\x50\x61\x4c\x6c\x16\xad\xc6\xec\xc3\x93\x37"
          "\xf8\xbe\x0c\xdd\x56\xeb\x6f\x6c\xa7\xd1\x9f\xd0\xb8\x3e\x3b\x3a\x7e\xdc\x6b\x73\x84\x91"
          "\xbc\x3b\x95\x70\x0d\xc7\x5a\x60\x00\x4c\x4c\x30\x5a\x56\xbd\x0e\x6c\x8a\xaa\x67\xd6\x9a"
          "\x87\xd1\x28\x94\xa7\xad\xe1\x76\x50\x1f\xe1\x57\x2b\x03\xae\xad\xe1\xe9\x6d\x6c\xda\x06"
          "\x93\x7a\xdb\x20\x83\x5f\x3d\xd6\x3e\x6b\x9e\xdd\xa6\xfb\x65\xa4\x14\xed\xcd\xa2\xac\x71"
          "\xd5\xda\xf3\x82\xea\x08\x46\x66\x78\x24\x74\x30\x16\x99\xd5\x86\x55\xdb\x6a\x17\xf4\x5d"
          "\x53\x54\xd1\xca\x1b\xec\x85\x27\x6e\x38\x7b\x08\xa6\x41\x3c\xa2\xd0\x26\x9b\xa4\xa9\x75"
          "\x77\x6b\x8e\x72\x54\x43\xb2\x6a\xa0\x51\xc1\x6c\xdd\x16\x85\x12\xf4\x2f\x77\x2c\x95\x08"
          "\x44\x5f\x8a\x8c\x53\x61\x6d\xb0\xbd\x96\xf0\xab\x1b\x72\xf3\x8e\x60\x1a\xc8\xe5\xb7\xdf"
          "\xf4\xab\x35\x3e\xee\x37\x1d\x3d\xde\x6b\x28\xa6\x6f\xf5\x2a\xf9\x81\x63\x46\x8b\x2c\x46"
          "\xe8\x43\x90\xd1\x6b\x5e\x1c\x89\x8c\xd3\x5f\x31\x9e\x76\xb5\xe6\x1e\x30\xc0\xe1\x5b\x2a"
          "\x9d\xc7\x4e\x35\xf9\x5d\xfb\xd7\xf9\x2b\xe8\x4d\x12\x42\xda\xae\x34\x7d\xfe\x12\x1d\x76"
          "\x85\x8b\x28\xf1\xf7\x6f",
          1, 2688 },
        { 128, 256, 84,
          "\xe0\x80\xd1\x6b\x4a\x0e\xcd\xa8\x8f\xc1\x3a\xb5\x6f\x81\x05\xf1\x9a\xe7\x33\xfa\x3d\xf4"
          "\x6e\x21\x2a\x0a\x24\x71\x1b\x29\x0e\x9f",
          "\x94\x95\x7a\x5e\xc6\x72\x49\xb6\x8f\x5b\x41\x0d\xef\x10\x46\xec",
          "\xf8\x69\x3b\x08\xbd\xfc\xa2\x1f\xce\x46\xf5\xb8\xc5\xa2\x0b\x8b\x03\x2e\x81\x28\x5f\x06"
          "\x10\x91\xfb\xf4\x1c\xcc\x83\xfd\x80\x88\xc0\xea\x8a\xb8\xd3\x8f\x30\x89\xbf\xea\x16\xf9"
          "\x83\xed\xc1\x85\x15\x78\x40\x84\x2c\xff\x80\xd2\x90\x40\xe9\x16\x02\x06\x41\xa3\x0e\x24"
          "\x1e\x8a\x34\x1d\xad\x25\x17\xe4\x4e\xb4\x65\xd1\xb5\x54\x77\xd8\x3f\xe9\x0a\xd2\xa6\x02"
          "\xee\xcb\x5c\x00\x8b\x14\xc6\xb5\xca\x36\x14\x3e\xe7\x47\x79\x1c\x2e\x76\x24\xa5\xcd\xba"
          "\xc6\xbd\x2f\x88\x52\x58\xc9\x9d\x62\x1f\x31\x6a\xfa\xb6\xa5\x31\xa9\xe1\x6c\x41\x64\xd1"
          "\xe2\xe3\x03\xa7\x87\x15\x82\x3f\x8c\x7c\x8c\xac\xdb\x28\x68\x65\x85\xa7\xb9\x59\x7f\x08"
          "\x48\x50\x38\x9b\xe2\x11\x02\x61\x28\x19\x00\x8b\x23\xa5\xa4\x7f\x78\xdd\x40\x73\xfb\x14"
          "\xe7\x17\x49\x72\xab\xc4\x71\x6f\xdc\x77\xe0\xbe\x52\x6a\x5d\x33\xeb\x8c\x35\x9e\x64\x30"
          "\xd7\x7b\xcc\x90\xf3\xc7\xc3\xe0\xbb\x31\xc0\x3e\x66\xf6\x81\x7a\x24\x9b\x33\xd7\xeb\x1d"
          "\x6d\xb2\x81\x31\x2a\x7b\x96\xf3\x1d\xfe\x70\x93\xdf\x48\x62\x2a\x4c\x58\x17\x79\xbe\x49"
          "\x7e\x2b\x4c\xd8\xad\x8e\x68\x4f\x69\x4a\xa9\x31\x88\x5b\x6a\x2c\x13\x21\x49\xd7\x28\x17"
          "\xe2\x5d\xf1\xc5\x6b\x4a\xaa\x17\x3f\xc3\x6e\x63\x10\xd0\x48\xc3\xcb\xb8\x8e\x88\xdf\xec"
          "\xcd\xd8\x7a\xcc\x4e\x97\xb2\x7f\x6f\x67\x60\xdd\xf4\x76\x20\x06\xf4\xab\x0f\x1e\xbf\x0e"
          "\x1c\x07\x33\x7a\x35\x3c\x4d\x92\x3a\x38\xdf\x78\x91\x09\xbf\xe4\x4b\xab\x11\xfa\xcb\x91"
          "\x7f\x04\x3d\xcd\xd8\xaa\xb3\x49\xbd\x7a\x7b\x8d\x66\xc2\x03\x5b\xad\x5c\x77\x60\x16"
          "\xf7",
          "\xcb\x1a\xf1\xd5\x36\x6e\xe7\xcb\x1c\x23\xc8\x55\x7b\xa5\x3b\x77\x4b\x0f\x85\xa9\x6e\x26"
          "\x11\x0d\xf7\xbc\xe6\x35\x52\x00\x5e\xe2\x59\x69\x0d\x1c\x2f\x16\x14\x53\x51\x52\x66\x4f"
          "\xb8\x2c\x5a\xff\x40\x50\x00\xea\x99\x38\x55\x34\x3e\x3e\xca\xf1\x59\xec\x6b\xdc\x6f\x11"
          "\x21\x65\xd8\x4d\xf8\x34\xbd\xf5\x2c\x25\x4d\xa9\xe1\x76\xb0\xf7\x72\x29\x20\xf2\x7f\x6e"
          "\x53\x0d\x45\x45\xa1\xe3\x4a\x18\xe8\x97\x22\x68\xfd\x41\x4e\x3c\xb3\x6b\xb5\x47\x2a\xee"
          "\xfb\x2f\xdb\x4b\x8b\xd9\x06\xd4\xc0\x9c\xe9\x23\x75\x19\x0f\xbf\x54\x44\x01\xec\x4f\xc3"
          "\xb2\xd1\x23\x73\x92\x43\xca\xfe\x11\x7f\x06\xdf\xc5\x01\x5c\x4f\xf9\xcd\x00\xc9\x2e\xf7"
          "\xa2\xce\x36\xa7\x7a\xcd\x49\xd7\x09\xc4\x39\xd6\x3f\xac\xee\xe6\x61\xb5\x5c\xa7\x55\x50"
          "\x8a\x5b\x05\x61\x58\x07\x27\xca\x0b\x9b\x89\xf6\xfd\x6d\x27\x07\x98\xc2\x69\x4f\x72\x3d"
          "\xaa\x8d\x25\x73\xad\x07\x90\x0e\x09\x44\xea\x4b\x8f\x10\x50\x06\x9d\xf2\x31\x87\xbe\xa5"
          "\xc1\x4b\x92\x2f\x84\xdc\x38\x99\xee\x60\x58\x55\xac\x80\x28\xce\x6f\x04\xf2\x8f\xdf\x84"
          "\x21\x24\x44\x98\x7b\xd7\x07\x70\x4c\x5a\xf4\xa0\x21\x86\x8a\xd2\x01\x7c\xe2\x0e\xa2\xb5"
          "\x76\x37\x1e\xe3\xc6\x57\x94\x42\xd2\xa7\xa9\x9d\xe8\x5c\xb6\xa9\xde\x8a\x23\x27\xe7\xf8"
          "\x87\x74\xfd\xdd\x92\xd4\xb6\x6d\x40\x00\xe8\x1c\x90\x9a\xb5\xdb\xbd\x5a\x8a\x1d\x35\x74"
          "\x09\x7b\x1f\x01\xa6\xcb\x62\x05\xc8\xcd\x53\x59\x1c\x67\x28\x06\x43\xf0\x71\x37\xbd\x73"
          "\xcd\x10\x97\xe1\x44\xb7\xd9\x41\x89\xd1\xd9\x46\x45\x19\x72\x67\xa4\x62\xfd\xa6\x21"
          "\xc6",
          1, 2816 },
        { 128, 256, 85,
          "\x65\xc9\x98\x63\x78\x6f\xad\x1f\xd0\xbd\xc7\xa0\xa1\x89\xde\x2d\x4e\xc9\x4c\x6a\x0a\xe5"
          "\xf9\xdb\x83\xc1\x92\x1b\x04\xa4\x91\x80",
          "\x26\x06\xc4\x3e\xfb\xad\xc3\xe0\x37\xfc\x19\x0d\x3d\x96\x21\xbf",
          "\x0b\x37\x73\x3d\x1c\x4a\xa6\xe4\x14\x0c\xe1\x11\x12\x69\xb5\xa9\x21\x83\xef\xb8\xe7\x8e"
          "\xda\x57\xbb\x8f\x52\xf6\x03\xa4\x5e\xfd\xb0\xe9\x30\x0b\xff\xb9\x32\x79\x26\x65\x21\x3f"
          "\x6d\xd8\x35\x15\x1f\x28\x8a\xdc\xda\x07\x0a\x8c\x0d\xe7\x02\xd6\x50\xe1\xcc\xa7\xaa\xca"
          "\x8e\x1d\x97\x3a\xaf\x2f\xaf\x69\x86\x38\xda\xb9\x29\x9d\x40\x14\x34\xc8\xcd\x10\xf8\x5f"
          "\x96\x78\x80\x0d\x55\xef\x26\x8e\x95\x56\x37\xe2\x25\x0e\xdd\x60\x86\x84\x45\xd6\x47\x34"
          "\xb5\x33\xe7\xed\xff\x9b\x6c\xfd\xb6\x10\x45\xa1\xfc\x92\x8f\xc6\x15\x53\x70\x75\xdc\x96"
          "\x1d\xf3\xa9\xfc\x33\x75\x81\x4f\xd0\x7c\x97\x53\x2d\xea\x7a\x60\xb6\x4a\xbe\xa0\xa6\xe2"
          "\xf2\x58\x3b\x12\x0d\x50\xe7\xb0\x40\xa6\x17\x40\x26\x4c\x86\xeb\xfa\xcc\x16\xed\x46\xb7"
          "\xcc\x1d\x9a\x3d\x3c\x3f\x2b\x95\xd5\x83\xfc\xcb\xca\x07\x24\x4d\x6f\xe5\x71\x8d\xe3\xd1"
          "\xf7\x59\x47\x45\xc2\x19\x36\x22\xab\x16\x6e\xad\xb1\x08\x6a\x37\x1c\x23\x10\x53\x2b\xb7"
          "\xd2\x52\xfe\x79\x9d\x85\xa9\xf6\xc4\xe6\xb7\x28\x8e\xce\xf5\x5b\x0d\x6d\x7d\xc2\x6e\x70"
          "\xb5\x70\xa6\x37\x71\x5d\xbb\x5e\x2e\xb1\xca\x3f\x8b\x84\x4a\xa7\x41\xdc\x41\xd0\x74\x8d"
          "\xd9\xe0\x81\x9f\x41\xae\x6a\xdb\xa5\xaf\x35\x81\xf0\x25\x09\x21\xc6\xb7\xd8\x80\xac\xf1"
          "\x99\xb0\x85\x71\xff\x06\xbb\xeb\xdb\xce\x8a\x8c\xd8\xf5\x2a\xc4\xb9\x3f\xcf\x66\x64\x27"
          "\x3f\x16\xe8\x14\x83\xf5\x08\x2b\x7a\xda\xae\x49\x98\x98\xc1\xa0\xfc\x45\x2c\x88\x16\x71"
          "\xdb\x75\xb6\x87\xbd\x39\x56\x7b\xae\xbc\x83\x4d\x0d\x80\xea\xa2\x52\x49\x0b\x2d\xa0\x9e"
          "\x5c\xa1\xe8\xbd\xa8\x66\xe2\xcd\x76\xb5\x33\x32\x5e\x68\x8f\xd5",
          "\x35\xb9\x5b\x12\xe9\x2c\xc0\x1e\x88\x06\xfa\x0f\xed\xc1\xde\xe7\x4e\xff\xce\x87\xda\x6f"
          "\xab\x75\x13\xf7\x9d\x37\x84\x15\x4b\xaa\x17\xd6\x41\x8b\x35\x8e\x07\xaf\xc2\xaa\x1e\xac"
          "\x18\xc8\x22\x12\x71\xf2\xd3\xdf\xf7\x94\x1b\xdd\x55\xf6\x9e\xaf\x5b\x7c\x36\xfd\x8a\xae"
          "\x31\xbf\x1c\x26\xbf\x7c\x17\x20\xdf\xf2\x19\xb9\x3a\x3d\x7b\xbe\xf0\xa3\x94\x07\xbc\x0c"
          "\x01\x4f\x32\xb4\xb3\x36\x24\x65\x38\xe3\xb2\x4f\x07\x2c\x0a\xf8\x12\x7c\x38\x72\x06\xec"
          "\xe2\x4e\x3c\xf8\x1e\x65\x8a\x9f\x34\xb4\xe0\x5a\x63\x2d\x4f\x97\x54\x2f\x2a\x5e\x15\x5e"
          "\xcf\xb8\xfe\x14\xac\xb8\x69\x94\x7b\x9f\x67\x3a\x45\x14\x94\xdc\xc2\xaf\x44\x73\x80\xec"
          "\x1e\xe3\xb3\x64\xa7\x25\x1e\xb2\x81\xa3\x8e\x9f\x11\xb8\xd6\x8b\x74\x15\x62\xac\x38\x5d"
          "\x19\xdd\xe5\xe9\x5b\xc2\x4a\xed\x2b\xbc\xac\xb5\x39\xe1\xb6\x34\x2e\x39\x7a\x99\x66\xe9"
          "\x44\x18\x5e\x42\xf5\x67\x63\x4d\x94\x03\x73\xc5\xf9\x8e\xeb\x63\x43\x9c\x52\x55\xaf\xd1"
          "\xce\xea\x78\x93\x08\xdf\xfa\x4a\x1a\x98\x7e\xea\x39\xc2\x7c\xa7\xda\x50\x44\x30\xed\x99"
          "\x34\xce\x40\x95\x25\x00\x1f\x7a\x93\xdc\x0f\x19\xb8\xa6\xe3\x38\x7d\x25\x29\xe1\x12\x64"
          "\x5b\xc7\x0c\x1c\x66\x6a\x3f\x58\x7d\xfe\x72\x82\x4f\xab\xb4\x1d\x54\xbf\x39\x67\x50\x8f"
          "\x70\x2e\x10\xdf\xc1\x41\xfd\x97\x05\x6b\xd5\xb7\xa7\x34\xfc\x55\x3b\x98\x4c\x16\xac\xc7"
          "\x0d\x9c\x0b\x9d\x1d\x53\x38\xb5\x27\x1d\x0a\x85\x0f\xba\x73\x8b\x42\x6e\xf2\xba\xbb\xf8"
          "\xc3\x48\xfc\xdb\xdc\x0a\x19\x47\x72\xc4\x30\xcd\x13\x6a\x7b\xdb\xb1\xb3\x15\x17\xd1\xc4"
          "\x1d\x30\xce\x1c\x77\xf5\x29\x3f\xc0\x62\x1e\x13\xc0\x3a\xd4\x6a",
          1, 2944 },
        { 128, 256, 86,
          "\xde\x2a\x2d\x74\x63\xc7\x55\x88\x74\xa0\x52\x97\xb8\xfb\x1c\xad\x2d\x2b\xe1\x7a\xdd\x5d"
          "\x70\xba\x39\x3c\x09\x80\x3d\xf0\x32\x0b",
          "\xc7\x3d\x98\xcf\x48\x89\x68\xce\x5a\x32\x3b\x2e\xac\x95\xa2\x0a",
          "\x8b\xe7\x65\x91\x4b\xbb\x98\x76\xa1\xfe\xbc\x1b\x96\x48\xec\x3b\x08\xb1\x19\x3e\xe6\xc3"
          "\x40\x2e\xab\x76\x07\x21\x54\x1c\xad\x78\x2b\x26\x69\x35\x49\xdf\xf1\x52\xe7\xf3\x83\x82"
          "\x5e\xa3\xb2\x03\xdd\xb7\xb6\xda\x81\xa7\x97\x81\x6f\xd3\x1d\x44\x89\x01\xc9\xf0\xb9\xa7"
          "\x38\x14\xe4\xd3\x78\x11\x66\xf9\xd1\x19\x88\xc4\x4d\x5c\x57\xc9\x82\xca\x42\xd9\x41\x65"
          "\xc3\xfb\x13\xed\x98\x75\x4e\xf6\x5c\xae\xc9\x10\x33\xc3\x21\x10\x70\xd1\xb0\x4e\xb7\x19"
          "\x54\x63\xd1\x3a\xec\x6f\xd1\xc1\x67\xf7\x17\x86\xb0\x1e\x8e\x1d\xdd\x61\x61\x15\xf3\x02"
          "\x9c\xae\xb8\xbb\x91\x90\x57\xae\x07\xf9\xf5\xaa\x92\x50\xc5\xd4\xf0\xee\x1f\xd4\x20\x4d"
          "\xb0\xab\xdc\x3f\x9b\x87\xae\x15\x97\xaf\x9a\xc7\x12\xce\x0e\x53\xd0\xd5\x51\xcf\x57\x68"
          "\x14\x8c\x9a\x76\x80\x3c\xa9\x99\x83\x1e\x39\x8c\x00\x32\xbc\xfa\xd4\x15\xa4\x9b\x7a\x69"
          "\x3d\x43\x1f\xc9\xad\x03\x41\xb9\x06\x16\x7d\x6c\x61\x6e\xe4\xca\x29\x36\x82\xe2\x61\x17"
          "\x3f\xc3\xac\xc1\x2f\x86\x2b\x99\x09\x97\x57\x1e\x5b\x60\x92\x16\x99\xb1\xe5\x55\x7d\x42"
          "\xef\x3a\xb3\x3f\xfa\x0d\x49\xe6\xd1\xca\x86\x5d\x08\x12\x75\xd8\xdc\x47\xde\x1f\x5d\xd9"
          "\xba\xcd\x6f\xc7\x13\x69\xa5\xf1\x05\x86\x90\x8c\x91\x2c\x99\x23\xca\x9d\xa2\xd5\x1c\xa5"
          "\xb5\xf5\xe3\x38\x1f\x01\x93\x11\xf7\x08\x6f\xeb\x14\x93\x64\x51\x93\x85\x70\x66\x9e\xaf"
          "\x50\xbf\x55\x1f\x72\xed\xe2\xb9\xce\x45\x20\xfc\x4a\x0b\x33\x67\x85\x8f\xff\xf1\x7e\x39"
          "\x06\xa8\xee\xb4\x43\x5b\x96\x32\x0d\x5a\x70\x25\xcb\x81\x12\x16\x81\x2f\xa0\xa2\x2d\x61"
          "\xe6\x39\x38\x67\x94\x3c\x0e\x67\x47\x38\x07\x47\xde\xb1\xb5\xbf\x9d\xe2\xa4\x8a\x53\xe7"
          "\x34\xf8\x79\xae\xb7\xfe\xe0\x9e\xb0\x44",
          "\x64\x9c\xeb\xda\xfa\xd3\x55\x3d\xe7\x8e\xfb\x6d\x57\xd9\x43\x81\x78\x62\xf2\x80\x3f\xc1"
          "\xde\x90\x08\x66\xff\xca\xb8\xdc\x1e\x77\xc3\x1c\x47\x74\x74\xc8\x39\x98\x79\x76\x2b\x25"
          "\xcd\xbf\x12\xb9\x2b\x90\xa9\xf0\xaf\x4d\xac\x33\x8c\xaa\x14\x62\x4f\x42\xc1\xc5\x1c\xa9"
          "\xff\x26\x91\x4f\x68\xab\xf9\x99\x62\x00\xae\x1c\x48\x0e\xcc\xbb\x9a\xbc\xaa\x00\x5e\xbc"
          "\xa7\xcc\xdd\x0c\xea\xac\xf7\x95\x6f\x6b\x7c\x36\xfc\xb3\x42\xae\x6e\x57\xe1\x90\x02\x24"
          "\xe7\xf8\x38\x0b\x5b\x86\x07\x7c\xc3\x9d\x98\xc4\xba\xfa\x19\xfe\xd0\x40\xe0\x36\x1b\x2d"
          "\xfc\xed\xef\x04\xbb\x8a\xc0\x44\x1a\x49\x49\x56\xb6\x7e\x0a\x70\x26\x31\x24\x67\xb8\x96"
          "\x38\xb8\xca\x1e\xf8\x53\x2e\x43\xcf\x61\x2d\x1a\xff\x31\x45\x2f\x28\x0a\x79\x70\xc0\xed"
          "\x87\x8f\xfe\xce\x49\x8e\x00\xe2\xd8\x4b\x62\xcb\xb1\xb7\x6c\xac\x44\xff\x88\xe5\xe2\xe0"
          "\xc9\x6a\x6f\x30\x8d\x4b\x69\x7d\x4c\x3e\x34\xd9\xb0\x46\x5d\x88\xa2\xc2\xe9\x1a\x50\x44"
          "\x76\x9b\x1a\x39\xd1\x42\xf1\x49\xba\xcb\xf3\x1c\x90\x1c\x3e\x5d\x0b\x9e\xfb\xc3\xd6\xc2"
          "\x6b\x82\xbf\x2f\xa5\xd1\x12\x7d\x37\x90\xc8\x2b\x38\x74\x08\x43\x69\xe5\x85\x2c\x21\x62"
          "\x3f\xab\x06\x66\x16\xa2\xc2\x80\xd9\x23\x2b\x52\x53\x3a\x23\xd4\x0c\x0f\x83\x57\x3f\xb5"
          "\x3e\x59\x9b\xe0\x6c\xf9\x34\xde\xbe\x3d\x10\x31\xf4\xaf\xf5\x06\xaa\x56\x7d\xcd\x42\xd5"
          "\x63\xe2\xaf\xbf\x55\x46\xbc\xa9\x0d\xb5\xfa\x7e\x7e\x5e\x03\xcf\xb7\xf1\xb7\xcf\x1f\x06"
          "\x97\xf4\xed\x29\x33\x4f\x9b\x48\x91\x00\xda\x75\x57\xd7\x38\x95\x1d\x70\x2e\x6c\x55\x4c"
          "\xdc\x90\xf1\x3b\x0b\x48\xe5\xe1\xf0\x26\xc4\x98\xcc\x21\x43\x45\x16\x7c\x31\x0f\xdd\x5e"
          "\x5d\xb6\x31\x17\xa2\xc5\xe0\x51\x04\x11",
          1, 3072 },
        { 128, 256, 87,
          "\x2c\xa6\xf0\xcc\x30\x35\x0c\x86\x66\xc1\x34\x84\xa3\xbb\x88\x32\x75\x05\xae\xb4\xda\x3f"
          "\xc0\x5c\x7b\xcc\x7e\xfc\x0a\xc5\x31\x3c",
          "\x5a\x76\xbc\xa5\x40\x5f\x07\x26\xdb\x5a\x84\xff\x6d\x55\xec\xdb",
          "\x34\x11\x4d\x18\x7f\x57\xdd\x6f\xc7\x08\x11\x0a\xe4\xc7\x6c\xdb\x3c\xc0\x4a\x29\x1c\x0b"
          "\xef\xa3\x59\xb0\x80\x05\x93\xfc\x03\x75\xfa\x00\x90\x2f\xd5\x38\xe9\x11\xab\xaa\x89\xd7"
          "\x2f\xc6\xa2\x78\x2b\x88\x4d\x22\xf5\x0d\x8e\x1e\x0b\x17\xa8\x56\x77\x32\x48\x89\x02\xf8"
          "\x10\xbc\x98\xbb\x42\x17\x6d\x78\xd9\xf9\x79\x4e\x3e\x45\xa8\x69\xd9\x6f\x6e\x69\xcf\x81"
          "\x54\x45\xef\x9f\xed\x00\x0e\x5a\x30\x6e\xb2\x08\x32\xd1\x5b\xf9\xc3\xb5\x2c\x62\x35\x75"
          "\x28\xb1\x88\x67\x28\x2f\x07\xa0\x69\x0d\xb1\x7d\x0e\xa5\x0f\x00\x6a\xf7\x9d\x8f\x20\xd3"
          "\x9c\xe3\xfd\x88\xb6\x52\xd2\x2c\xe3\xc8\x73\x4c\x7c\xdb\xe7\x7a\x77\x2a\xc4\x28\xdc\xac"
          "\x9b\x22\xc1\x39\xeb\x07\x9a\x91\x4b\xcf\x51\x04\xdf\x39\x31\xe6\xdd\x0f\xf1\xfb\xe7\xdc"
          "\x87\x62\x5d\x77\xf9\xd1\x20\x1b\xa3\x4c\x03\x45\xfa\xe3\xd2\x32\x21\x21\x75\x33\x64\xa5"
          "\x4f\x97\xa9\x15\xff\xfb\x68\x31\xe6\x1c\x7d\xe7\x72\xbf\x26\x38\xc2\xb9\x4c\xf1\x5f\x41"
          "\xe3\xf9\x18\x2f\x54\xb4\x53\x0f\x3b\x61\xda\xee\xec\x3b\x87\xfe\x4e\x0b\xe5\x2e\x37\xe0"
          "\xc7\x24\xcc\x24\x0d\x0f\xd4\x3d\x1c\x7f\x35\x1f\x69\x09\x90\xb4\x61\x45\x8b\x13\x4d\x3a"
          "\x92\x96\xc0\x1b\x12\x2a\xae\x41\x11\xa1\x5e\x90\x32\x3f\x4f\x10\xe3\xad\xa4\x96\x27\x7a"
          "\x7e\x8c\xe9\xef\x0c\xcf\x36\x2c\x1f\x3e\x6a\x3c\x43\x7c\x2c\xc9\x5e\xc7\x11\x69\x92\x77"
          "\x25\xea\xcc\x6c\xbb\x8a\x95\x10\x2a\x89\x73\xef\xce\x83\x5b\xb1\xf8\x90\xe7\x6a\x58\x5a"
          "\x14\x6f\x7f\xaf\x4a\x1b\xf5\x74\xae\x70\x05\xc0\x3f\x7d\x32\xf6\xfc\x0f\x9c\x1e\x5a\x83"
          "\x27\xc7\xf6\x26\xdf\x40\x70\x07\x0d\x67\xd6\xc4\xd1\x56\xf7\x13\x25\x8b\x6b\x37\xc9\xbf"
          "\xff\x59\x52\x69\x02\x4e\x2a\x40\x13\xf0\xb8\x9d\x46\x34\xd5\xb9\xd6\xec\x69\x4c\x86\x6c"
          "\x0a\xae\xae\x1d",
          "\xe3\x1b\xf4\x6a\x30\xc8\x0e\xe3\x0e\xaf\x81\x4c\x59\x1a\x5b\x6b\xe5\xa7\x50\xc7\x5e\x51"
          "\xf6\xde\x38\x0f\x2b\x3f\xd7\x37\x22\x66\x66\xba\x86\x17\xd3\x59\x05\xd7\xfd\x75\xea\xf5"
          "\x64\x79\x86\xf2\xa3\xfa\x4f\xf8\x64\xf8\x73\x33\x55\x50\x33\xcf\xb5\x83\xfb\xdb\xfc\xa2"
          "\xa4\xb3\xff\xb7\xab\x4d\x47\x6c\x02\xca\x00\xc1\x66\xee\x8c\xfa\x1a\x36\x6f\x0f\xf7\x8f"
          "\x12\xb7\x10\x6e\x50\x74\x69\xf0\x77\xc0\xfa\x74\x27\x52\x63\x39\x04\x6a\x81\xbf\x37\x63"
          "\xfc\x0e\x64\xed\xde\x0c\x98\x84\xca\xb7\xad\x67\x22\xb2\xf3\x5a\x50\x01\x92\xbc\x65\x82"
          "\x1f\xcb\x86\x24\xe5\x30\xe0\xfd\x37\x94\x03\x9f\xcf\x0d\x76\x24\x78\x41\x1c\xa1\x79\xe1"
          "\x90\xaa\x28\xcc\x8f\x8b\x15\x25\x6b\x60\x9b\x6a\x56\x04\x8c\xe0\xba\xec\x3c\xd8\xff\x3c"
          "\x1c\x1e\x99\x1a\xa1\x6c\xa7\x92\x93\xc0\x41\x00\xac\x4b\x56\xe5\x19\xd4\xb0\x9d\x96\x25"
          "\x7c\xde\x3c\x61\x68\x68\xae\x37\x63\x58\x74\x3e\xa6\x22\x97\x61\x32\x6b\x3b\x64\xb8\x5a"
          "\x94\x27\x57\xfb\xa1\xe9\xdb\x89\x92\x2a\x59\xb9\x48\xb1\xdb\x8a\xa5\xed\xc6\x10\x9c\x7d"
          "\x20\x2f\x64\x4b\x02\x36\x83\x08\x2f\xf7\x4d\xc0\x5e\xb4\x75\x61\xe1\xfb\xa1\x61\x85\xfc"
          "\x25\x0e\x5c\xab\xba\x3a\x98\x89\x83\xe3\x4e\xa4\x1a\xb6\xff\x49\xba\x27\x27\x5b\x54\x7b"
          "\xea\xd2\xfe\xed\x48\x02\xd1\x06\xc5\xec\x1b\x32\x02\x5f\x18\x0e\xf2\x83\x7e\x01\x61\xb8"
          "\xf1\x3b\x9d\xb9\xc0\xbd\xa9\xd2\x37\xf2\xe8\x27\xbe\xd1\x13\x03\x03\xbe\x06\x7c\x1e\x71"
          "\x03\x31\xca\xe9\x4f\x20\x6b\x7a\x5e\x72\x6e\xa5\x2a\x30\x6f\xed\x9e\x38\x17\xe2\x3e\x96"
          "\x33\xc9\xbd\x1c\xeb\x3c\x67\xd2\x0b\xf5\x47\x6c\xd4\x99\x64\x0d\xd7\x0d\x02\x20\x51\x23"
          "\x09\x95\xf7\x0b\xcb\x5a\x26\x1c\x21\xd0\xa1\x5b\xda\x02\x24\x88\x78\x23\xeb\x0d\xa4\xee"
          "\xea\x98\x72\xaa",
          1, 3200 },
        { 128, 256, 88,
          "\x3f\x23\xc2\x6c\x02\x24\xe1\xfa\xe0\x4a\xf2\xf7\x92\x34\x39\x2e\x81\xb5\x1d\xa4\x32\x96"
          "\xde\x2d\xb2\x86\x24\x42\x4f\xca\x57\x3b",
          "\xac\x1d\xa6\xcc\x7d\x2e\x68\x7a\x22\x68\x1c\xbc\x4f\x92\x3c\xa0",
          "\x15\xa1\xa3\xef\x39\xa0\xe9\xf9\x9b\x0e\xf0\x8a\x11\xbf\x72\x8b\x1a\xd3\xb1\x3e\x2a\x40"
          "\xe9\xe3\x5d\xa7\xcd\x97\x57\x5b\xf8\x86\x6c\x01\xbf\xce\x42\x88\xa8\xec\x70\xb0\xea\xce"
          "\x2b\x6a\xda\xf1\x8f\x3a\x44\xd5\xe4\x52\x4b\xd3\xc6\x9b\xbb\xee\x3e\xf9\xf6\x2b\xfa\x54"
          "\x6a\xc1\xc9\xaf\x51\x66\xae\x91\xc8\xf0\xb5\xef\x5e\xc2\x8b\xdb\x82\x4f\x9f\x1a\x24\xa0"
          "\x60\x8d\x55\xcc\x92\xe2\x3c\x4d\x01\xb0\x12\xaa\x97\xa7\x76\xd9\xb5\xaa\xbb\x48\xbe\xcd"
          "\xc9\x99\xa7\x13\x1e\x6c\x1c\x03\x93\x14\x1b\x9e\x09\x3f\xea\xd4\x43\xb8\xce\xb1\x85\xf6"
          "\x0c\x12\xee\x60\xe3\xeb\x73\xe0\xa8\x00\x73\x13\x92\x01\x18\x1c\xe9\x31\x0c\x6d\xc2\xb0"
          "\xda\xda\xc7\x88\x9c\x1a\x4d\x68\xa2\xba\x06\xc6\x7e\x06\xde\xd4\x53\x73\xb8\xfd\x44\xdb"
          "\xdb\xf5\x38\xc1\x1c\x0a\x8f\x1f\xf4\x0d\x10\x5c\x1e\x20\x02\xec\x94\xf1\x33\x2d\xfb\xbd"
          "\x20\x4e\x09\x46\x95\xf5\xa6\x4c\x83\x17\x6e\xa7\xdb\x58\xc1\x76\xa3\x4a\x71\x06\x07\xaf"
          "\x8e\x9a\x65\x04\xe3\xcc\x67\xb8\x37\x9f\xa1\x2e\xbd\x03\xdb\x3f\xfc\x38\x24\x1c\xc3\x7f"
          "\x1e\x71\xb0\xe3\x29\x3a\x63\x45\xba\x2e\xb9\x00\x93\x7d\x07\x7b\x16\xde\xcd\x50\x32\x2f"
          "\x9e\x7d\x2e\xfa\x13\xa7\xcc\xe7\xa2\xb0\x55\x74\xa9\x7f\x4c\xab\x71\x28\x01\x63\xbf\xdf"
          "\xe0\xc5\xa4\x04\x8c\x68\x54\x4d\x9a\xc5\xf6\x54\x1a\xa4\x3f\x84\x26\x1e\x69\x8c\x80\x84"
          "\x8e\x2f\x26\x86\x14\x61\x65\x08\xe0\xdb\xe1\xb0\x06\xa5\x42\xb6\x4b\xb5\x47\x6c\x3f\xe5"
          "\xa5\xf4\xf8\xda\x7f\x2a\xdd\x16\x94\xf0\x1a\x61\xc6\x61\x0a\x8e\x50\x16\x5f\x94\xf4\x9e"
          "\x23\xb5\xa8\x55\x90\xee\xb9\x39\xc9\xa1\x42\x81\xab\x66\x38\x44\x65\x96\x3c\x1f\xac\x80"
          "\x00\x26\x62\x70\x52\x02\x2e\x8d\x1b\xaf\x74\x74\xc4\x6a\xdd\xcc\xff\xe6\x69\xd8\x75\x0c"
          "\xde\x8d\x46\x5a\xd2\x36\xb5\x29\xe9\x1e\xbe\xa2\x49\xaa\xad\x2e\x5e\x30\x78\x1b",
          "\x9b\x4c\x79\x07\xc9\x88\x05\x41\x05\x54\xff\x78\x80\x34\xe6\xac\xd2\xac\x0c\x91\x6f\xe4"
          "\x6c\x1a\x78\x35\x92\x80\xc3\xec\xef\x2b\x24\xee\x0d\xcf\xd2\x7b\x77\x04\x35\xbf\x42\x6a"
          "\x8a\x62\x1a\xa7\x56\x7b\x16\xe3\x46\x50\xaf\x9b\x7f\xe1\xb7\x8e\xfc\x6c\xc5\x08\x66\xab"
          "\xa4\xf9\xa8\x2b\x54\x3f\xac\x0b\x01\xc4\xbd\x22\xb8\x0f\x35\x34\x33\xe4\xfa\x72\xcb\xbc"
          "\x86\x3c\xad\x98\xf6\x48\x3a\x78\x49\x46\x93\x7c\x5d\x0a\x67\xd9\x89\xca\xb0\x58\x34\xd2"
          "\x31\x93\xc1\x36\xdd\xfa\x8a\x80\x75\x1c\x50\x87\x2a\xcc\x47\x35\x6d\xef\x6d\x59\x2c\x34"
          "\x53\x95\x5c\x4e\x06\xbd\xeb\xea\x51\x19\x31\x88\x78\xa4\xee\xc8\xac\x7b\xda\x21\x2e\xc9"
          "\x97\x5f\xea\x48\x74\xc2\x04\xd3\x9a\x3b\x3e\xd5\xd0\x10\xca\xd4\x46\xf8\xf7\xb7\x09\xde"
          "\x10\xf6\x13\x37\xf3\xf6\x3c\x21\x41\xb6\x2f\x8d\xde\x94\x66\x70\x03\x7a\x6a\x70\x9f\xd5"
          "\x6a\x23\x39\xca\x7b\x37\x53\x73\x18\x4b\x8d\x0e\x3b\x05\x38\x01\x58\x01\x6f\x2d\xd6\x0e"
          "\x60\xe6\x74\xd1\x11\x2e\xb0\x9b\x1a\xb6\xd7\x23\xa0\x38\x7a\x2b\x4c\x81\x23\x40\x03\xde"
          "\xa5\x60\xa0\x7e\x93\x8c\xba\x45\xd6\x16\xfd\x73\x25\xd8\xc9\x96\xfa\x11\xfa\x24\x42\xa4"
          "\xbf\x6c\x61\xbc\x7c\x76\x8f\x85\x91\x2f\xa8\xdb\xa7\x7e\x62\x16\x22\x38\xa3\xfc\x9f\x89"
          "\x08\x89\x96\xaa\x48\xd9\x1a\xca\x7c\x4f\xca\x2c\x86\x53\xb9\x8a\x66\x97\x68\x03\xb2\x26"
          "\x53\xfd\xf9\x27\xf8\x32\x36\xb7\xf5\xb2\x3d\x36\x66\x77\x8c\xcd\xfe\xc4\x55\x7e\x06\x5f"
          "\x11\x1d\x7a\xe4\x3a\xc5\x69\xff\x84\x3e\x4d\x7d\xbf\x2e\xfb\xaa\xed\x9c\x8e\x7b\x20\x1e"
          "\x04\xcc\x47\x9c\x58\x93\x4c\xbb\x51\x98\x8e\x39\x9e\xb0\xe1\x1a\x95\x5c\x05\x36\xca\xf1"
          "\xae\x48\xa6\xc7\x5a\x40\x76\xe3\x41\xd0\x2e\x49\x77\x46\xc8\xa7\x9f\xf1\x03\xe2\x52\xe3"
          "\x80\x17\xdf\x4f\xa4\x20\x63\x04\xcb\x11\xc5\x4b\x6c\x65\xea\x30\x58\xa9\x6f\xff",
          1, 3328 },
        { 128, 256, 89,
          "\xa4\xeb\x20\xad\x63\x27\xbb\x52\x51\x48\xd2\x41\x1f\x22\xee\x70\x61\x45\x4c\x31\x0a\xf9"
          "\x99\x53\x54\xba\xa4\x0a\x4d\xf1\x6c\xb9",
          "\xe7\x7f\x3c\x77\x5c\xd7\xf9\x7e\xa9\x47\x24\xaf\x86\xbb\xc5\x20",
          "\x49\x2f\xc4\x47\xac\xc2\xbc\x80\xc0\x14\xb5\x3f\xfb\x91\xa3\xf9\xa8\x00\x16\xb7\xae\x8f"
          "\xb9\x16\x8f\x20\xee\xa0\x67\xec\xeb\x0e\x15\xce\xb6\x66\xf4\xf9\x89\x79\x5c\xc4\x08\x77"
          "\x8b\xdb\x11\x17\xfd\x06\x3c\x7e\x54\x52\xcb\x60\xaa\x43\xb1\x85\x8f\x13\x80\x83\x1c\x32"
          "\xe0\xb4\x01\xdf\x0a\x8b\xd4\x61\x2c\xcf\xa1\x40\x55\x9d\x75\xa3\xde\x04\xd1\x34\xd3\x59"
          "\x52\xc9\x33\xbf\x5e\xf7\xde\x22\xc4\x46\xdd\x4a\x36\xf7\xe3\x9a\xde\x4d\xb8\xd3\x64\x84"
          "\x64\x5e\x80\xbb\x0f\x46\xcc\xc5\x99\x00\x34\xe0\xb3\x34\x15\x1a\x1d\x9e\x5d\x1e\x7e\x73"
          "\xeb\x8e\x34\x8b\x2c\x82\x64\xd1\x7d\x3e\x1a\xc4\x9c\xa2\x03\xd3\xf8\x5d\xcb\x48\x39\xa3"
          "\x10\xc8\xac\x25\x8b\x9e\xa3\x40\xa7\x14\x0d\x39\x52\x3f\x23\xf9\x74\x45\x4d\xba\x06\x75"
          "\x13\xab\xf3\x8a\xb5\x5f\x83\xc4\x18\xed\x00\x6e\x91\x26\x7b\xac\xdf\x37\x59\x1a\x4e\xc5"
          "\xa5\xa5\x0c\x62\xd7\x3e\x95\x2d\x78\xd3\x2d\xe0\x02\x66\x21\x4a\x26\xcc\xa2\x6a\x11\x5b"
          "\x50\xe5\x79\xd9\x7a\x27\x4f\x54\x72\xec\x75\xb2\xa0\xbd\x30\x4a\xaf\x0d\x84\xad\xaa\x1a"
          "\xbe\x3a\x5e\x31\xa6\x6d\x71\x00\x3b\xe8\x63\xa9\x66\x62\xfa\x98\x12\x45\xfb\x21\xb3\x1e"
          "\xf6\xd7\x10\x6a\x20\x84\x0c\x4b\x6a\xb9\x00\xa0\xbd\x51\xbc\x5f\x10\xb0\xe3\xbc\x30\x58"
          "\x51\x38\x21\xb2\xf3\x00\x9b\x1f\xbb\x2a\xd7\xaa\xd9\xa3\xf3\x03\xc3\x0d\xa5\xa8\xee\x54"
          "\xf1\x62\x54\xb3\x47\x0c\xf3\x88\x48\x43\x87\xc8\xd6\xcd\xda\x8b\x06\x4f\x84\x45\x81\x05"
          "\x75\xce\xb0\x0b\xa9\x49\x25\xc7\xbe\xb6\x09\x3a\xb5\x38\xdc\x9d\x23\xaa\x54\x1c\x77\xc1"
          "\x62\x35\xdd\x49\xe2\x11\xf2\x77\x30\x8c\xca\xba\x51\xb9\x55\x0b\xd5\x8e\x9d\x43\xea\x3e"
          "\xc4\x7b\x24\x30\x58\x23\x65\x3b\x32\xb2\xaa\xf1\x9e\x36\xd9\x84\x83\x91\x15\x64\x4c\x39"
          "\x05\xdb\x48\xcf\xd6\xb7\xe6\x4e\x06\xa6\xd3\x05\x10\x0d\xec\xce\xeb\x66\xfb\xd9\xd2\x20"
          "\xa7\xad\xea\x95\x92\xcf\x65\x03\xf4\x2a\xfa\x48\x55\xe9",
          "\xce\xd4\x1c\x03\xfe\x5a\x5f\x8a\xf6\xc3\x90\x56\xb5\x9b\xf5\x48\x6d\xac\xa9\x38\x1e\x37"
          "\xcc\xdb\x62\xde\x46\x1e\x88\xcd\x4f\x8d\x72\x0c\x12\x2b\x00\x37\xfd\xc7\x59\x57\xb0\x75"
          "\xf5\x1f\x78\xb7\x6c\x89\x54\xfe\x8e\x2d\xb1\xe5\x5f\xe9\x56\xa7\xf6\x07\x25\xca\x5d\x2e"
          "\x6d\x3a\xae\xdd\x50\x9a\x29\xde\x98\x9b\x5b\x04\xc5\x67\x3a\x29\xb9\x35\x60\xda\x0c\xa7"
          "\x10\xc4\x32\x09\xc5\xf7\x20\xd6\x78\x8c\xdd\x22\x70\x4b\xde\x60\x06\x41\x73\xcd\xd8\xd2"
          "\x4d\xc5\xfd\x18\x31\x16\xef\xda\x6a\x5c\x2f\x70\xfe\x57\x8d\x34\x7f\x4c\xeb\x25\x04\x99"
          "\x96\xba\xd6\xf5\xf2\x06\xd2\x28\xb3\x12\xdc\x91\x57\xf9\xd9\xbe\x44\x90\x52\xa2\xa8\x7d"
          "\xf4\x94\xcd\x1c\x58\xbc\x06\x3c\x9a\xb6\x8c\x81\x10\x63\x56\xb0\x27\x9d\x66\xcc\xf8\x45"
          "\x79\x52\xcf\x43\x58\xa5\xda\x78\x43\xd2\x19\x75\x90\x45\xc9\x60\xab\xb1\x63\x9d\x23\xa3"
          "\x0e\x0b\x06\x3c\x3f\x1a\x1b\x80\x24\x95\xa3\x49\xf7\x7b\x8b\xad\xea\x8a\xc1\x05\x4f\x9b"
          "\x99\xba\xbc\xeb\x0f\xdf\xf4\xc9\x80\x36\x0f\x44\x51\x8f\xfe\xef\x9f\x78\xe8\x0f\x50\x98"
          "\xe2\x6e\x2f\xf3\x40\x45\x60\x9c\x0c\x92\x9b\x2f\x62\xfb\x7e\x7e\xd1\x02\x2f\x09\x56\x3a"
          "\x81\x02\xae\x8e\x02\x70\x2e\xf7\x5f\x77\x31\x3a\x6c\x65\xdc\xcd\x7f\x66\x9b\xa8\x2e\x01"
          "\x5e\xbb\x33\xb3\xf8\x40\xda\xfc\xb8\xb5\x36\x5c\x64\x5a\xd0\x0a\x8e\xff\xf9\xec\xcf\x79"
          "\x17\xb0\x23\x96\xe4\x12\x64\x1a\x87\xb9\x9c\x78\x56\x64\x6b\x44\xd6\x98\x7b\x08\x66\x40"
          "\xd3\xc8\x16\x5a\x87\xa6\xc4\x86\x8c\x1b\x98\x5a\xf3\xae\x0f\xbb\x34\x59\xb7\x8a\xc8\x7e"
          "\x9c\x5a\x8c\xa8\x76\x3c\xa2\x8c\x41\x49\xda\x04\xba\x59\x7c\x82\x9d\x15\xc8\x7e\x21\x74"
          "\x28\xba\xf4\xf6\x9c\xd1\x6f\x1a\xc2\x10\x11\x29\x13\x8b\x83\x11\x9b\xa8\xe5\x2a\xe8\xcc"
          "\x44\xe8\x46\x43\x1b\x0c\xb6\xa2\xa6\x6c\xcc\x2d\x7f\x31\x91\x5f\x83\xbc\xd6\x43\x60\xb4"
          "\x33\x82\xee\x4f\x17\x00\xdb\xbb\x82\x0d\xb2\xeb\xcf\x25",
          1, 3456 },
        { 128, 256, 90,
          "\x05\xb3\xff\x7f\xad\x47\x36\x9f\x48\xd2\x77\x94\xc1\x08\xb9\x9b\x54\x70\xed\x26\xed\xaa"
          "\x51\xe5\x66\x3b\xbf\xec\xbe\x8f\x77\x55",
          "\x9f\xaa\x55\x5e\x47\x7b\x8c\x32\x53\xca\xc8\x0f\xe5\x43\x1f\x7f",
          "\x78\x9e\xea\xe8\x65\xd7\xc7\x04\x52\xe1\xdf\x56\x13\x8f\x90\xd5\x7f\x65\x1b\x8d\x9b\xf8"
          "\x03\x0f\xfa\xd5\xe7\x12\xbb\xca\xa3\x30\xb5\xc1\xa1\xb2\x2a\xa8\xcf\xd6\xdb\x51\xa8\x39"
          "\x83\x81\x35\x14\x61\x86\x79\xf4\x63\xa7\x32\xe2\x43\x51\xa5\x14\x6b\x61\x41\x4f\x96\x4a"
          "\xda\x57\x1e\x1d\x1a\x3f\x66\x15\x66\x7c\xa1\xff\x32\xcc\x59\x52\xdc\xf5\x7a\x9a\xa8\x9f"
          "\x65\x0b\x01\x44\xef\x81\x36\x64\xff\x2a\xc3\xc2\x21\x24\x1a\x72\x96\x92\x4f\x7e\xac\x40"
          "\x40\x24\xf6\x0b\x15\xef\x01\xfc\x9c\xc9\x2b\x8d\x1a\xf7\x2b\x3d\x3d\x65\x45\xca\xd0\xa0"
          "\xa3\x02\x2a\xeb\x71\xb0\x58\xc9\x13\x83\x93\x16\xb7\xd0\xce\xbb\x13\x49\x63\x61\x3b\x83"
          "\x15\x43\x73\xaf\xa6\x30\x67\xa2\x38\x18\x15\x67\x82\x8e\x1c\xc0\x63\x20\x79\xd6\x71\x2e"
          "\x40\xf9\xc7\x37\x5e\xcb\x4f\xd9\xac\x20\x3b\x3f\x45\x3c\x59\x51\x63\x04\xc9\x62\x3f\xb5"
          "\x6a\xca\x67\xf9\xc0\x0f\x4f\x25\x28\x37\x19\x0d\xfc\x8d\x96\x23\x1d\x71\x7b\xd4\x2f\x81"
          "\x04\xdc\xc3\xea\xf1\x5e\x3a\xe7\xbf\xc3\x64\x71\x44\xb6\xde\x7d\xe6\xa0\x83\x9e\xf8\x76"
          "\xe5\x93\xe9\x12\x27\x38\xfa\xde\xa8\x1a\x51\x86\x72\x6a\x57\x8c\xc0\x7f\xec\xae\x35\x0b"
          "\x3f\xba\x46\xe7\xad\xa8\x81\x96\xb4\xc7\x6a\x4e\x3d\x97\x67\x1c\x60\x79\x11\xbc\xad\xb6"
          "\x99\x8b\x53\x8e\x2a\x37\x54\x1c\x1c\x21\x4c\x63\x23\x67\xd0\x58\xe7\x6a\xce\xe3\x40\xbb"
          "\xa2\x37\x68\x62\xa7\x85\xf4\x72\xbb\x2b\x0d\x9a\x10\xca\x67\x1f\x21\xc2\x2b\xbf\xc4\xe4"
          "\x4f\x99\x57\xf4\xc3\xc1\x47\x19\xb7\xf0\x5a\x47\x74\xd0\xb8\xf2\x2c\xa7\x9f\x95\x61\x50"
          "\xfb\xde\xdf\xec\x57\xa6\xf0\xdd\x28\x9f\x31\xcd\x79\x68\x7b\x1d\xfa\x1d\xde\x6e\xe8\x9e"
          "\x4f\x60\xbd\x1e\x07\x4c\x1d\x20\x1f\x6c\x48\xab\xd0\xb5\x53\xd5\xa4\x34\x71\x57\x5c\x85"
          "\x98\x9a\x16\x2b\x7b\x78\x84\x19\x11\x04\x33\xf4\x24\xc5\x19\xcb\xa1\x51\xa2\x80\xd7\x17"
          "\x63\x3a\xdb\xcb\x23\xd1\x4a\xfc\x12\xbb\x28\xd5\x0c\x84\xb2\xe9\x52\xb3\xff\x47\x60\x55"
          "\xc7\xf7\x40\x00\x0a\x68\x30\xb5",
          "\xd2\xe2\x7c\x06\xd9\x66\xb7\xe5\x33\xd8\x4e\x30\x0e\x7f\x52\xe8\xa6\xf8\x5a\xc6\xf4\xb3"
          "\x1e\xef\xcd\xdc\xc5\xb2\x1b\x1a\x05\xbf\x8c\xcc\xa2\x2c\x01\xc2\xfd\x7b\xdd\xdd\x41\x30"
          "\x15\x5e\x44\x66\x32\xf6\x6e\xf3\x3f\x0f\xcb\x90\x57\x0f\xd3\x32\xb0\xb4\x74\x1b\x4b\x99"
          "\x12\xdb\xaa\x0d\x7c\x07\xad\xbd\x44\xf4\xdc\x88\x46\xd6\x86\x46\x2e\xe9\x59\xe9\x2c\xee"
          "\x33\x33\xbf\x73\x53\x3a\x47\x35\x9e\x9e\xf9\x3e\xc2\xc8\x58\xe1\x30\x15\x38\x62\x9f\x42"
          "\x70\xd5\x12\x16\xc4\xdc\x77\xd7\xed\xf2\xec\x1e\x7e\x23\xbb\x6d\xc7\x4c\xaa\xe1\x2d\x7c"
          "\x97\xe1\x7d\xa0\x02\xd4\xdd\xc1\x10\x12\x37\xb3\x5e\x51\x30\x65\x82\x51\x49\xa0\xf0\x62"
          "\x20\x8a\x7a\xcb\xda\x33\x54\xd0\x80\xf3\x99\xdf\x8e\x5d\x4e\xb7\x5a\x1a\x3b\x44\xe1\x91"
          "\x09\x9e\x64\x22\x1e\x6d\x2a\xc5\x26\x56\xc9\x61\xb0\x6f\xb8\xc3\x72\x7c\x59\x50\xb4\x2f"
          "\x7c\xc7\xc1\x73\x5d\x65\x67\x40\x50\x6b\xcd\xc1\xbd\xc8\x73\x3f\xc1\x93\x0b\x49\x0b\xbf"
          "\xc7\xa0\xc9\x2c\x83\x61\xf5\xfa\x4e\xac\x58\x05\x8c\x1a\x88\x70\xe6\x07\x23\xd7\xf1\x56"
          "\x61\xc1\xae\xee\xbc\xa6\xa5\x72\x06\xe0\x92\x10\xe3\x50\x69\xe7\x13\xb7\xcf\x18\x96\x24"
          "\x8e\xd2\x31\x77\xbb\x00\x10\x0d\xbf\x62\xa7\xa0\xb5\x46\x28\x93\xa1\xe4\x69\x88\xb9\x6c"
          "\xc3\xd3\xdf\x62\xbc\xbe\x72\xf2\xed\x9d\x90\x99\xdc\x88\x80\x47\x35\x91\x2a\x31\x4f\x1b"
          "\x22\xe4\x04\xc7\x0c\xbf\xd7\x19\x9e\x87\xb1\xc6\x4d\x10\x7c\x36\x50\x4b\xd5\xfa\xf3\x5c"
          "\x25\x64\x87\x61\x80\x97\x3f\xac\xa4\xb0\x45\x20\x42\x46\x63\x23\xed\x45\x99\xd8\x17\xa1"
          "\xe7\x96\x7f\x6c\xf0\xc0\xf4\xe2\x88\xf9\x95\x98\x9e\x0f\x3c\x20\xf5\x90\x20\xa2\x77\xa1"
          "\x56\x8a\x61\x65\x75\x0a\x22\x5d\x58\x7e\x4e\xdd\x5c\x17\x7a\xad\xbf\xec\xed\xad\xf8\x9d"
          "\x0b\x78\xf9\x1c\x2d\xd4\x2a\xd0\x27\x3a\x08\xdd\xce\xb5\x0d\x5c\xa7\xdf\x23\xbc\xdc\xda"
          "\x21\xe8\xee\xc5\x25\xac\x10\xcb\xdd\x55\x95\x17\x29\xee\x54\x09\x0a\x37\x4d\xd4\x35\x12"
          "\x4c\x8b\x88\x25\xd5\x58\xbb\xaa",
          1, 3584 },
        { 128, 256, 91,
          "\x10\xe6\xf8\xa6\xd6\xcc\xb6\x6d\xbc\x76\x93\x88\x9f\x39\xe2\x56\x80\xde\xa3\xac\xa8\xfc"
          "\xba\x75\x36\x5a\x94\x37\x2c\x7e\xbe\x86",
          "\x0b\x04\xde\x61\xe0\xc0\x54\x30\xd9\x72\xa5\xd5\xdb\xc2\xa2\x42",
          "\xc3\xda\xac\x4e\x04\xc1\xd8\x2a\x51\xc8\x18\x7e\xcc\xcb\xe9\x75\x6f\x79\xb1\xd1\x28\x28"
          "\x18\xa5\xbf\xcd\x07\x9a\x73\xfa\x1b\xc5\xe9\x90\xfa\x26\x36\x00\xf7\xea\x83\x86\x54\xad"
          "\x52\xc0\xf9\x61\x75\x3e\x15\x03\xb4\xf0\xdd\x7d\xfa\xd6\x4d\x80\x4a\xe8\x39\x51\xf7\x36"
          "\x2f\x07\x00\x1c\x0a\x4c\x7c\x91\x1b\x40\x38\xc9\x51\xc1\xd7\x01\x19\x35\x41\x34\x7e\xc7"
          "\xfe\xb8\x85\x08\x78\xef\xd3\x7a\x9e\x3f\x3b\xb1\x69\xef\xb4\x71\xca\x45\xb5\xc4\x48\xfe"
          "\x5e\x3d\x56\x49\x1f\xb3\x24\x2e\xf2\xaf\x32\xfc\x42\x41\xc3\x3f\x41\xf9\x04\xb1\x4e\x01"
          "\x42\x89\xaf\x8b\x74\x69\xaa\x69\xf8\x25\x52\xa8\x0c\xb0\x68\x58\xfc\xc0\x89\xf3\x3a\x9a"
          "\xde\x7a\x85\xf3\x42\x39\xa6\x16\x5f\x40\x40\xfa\xfb\x5e\x41\x98\x6f\x7c\x5c\x8d\x26\x07"
          "\x11\x84\xc1\xf9\x4f\xe9\xc1\x20\x80\x1f\x14\xee\xfe\xeb\xcc\x0e\x7a\x27\xee\x31\x02\xbb"
          "\xae\xd2\xae\xe1\x88\x30\xeb\xbd\x9f\x12\x51\xa2\xa8\x1f\xb9\x55\x6d\xe6\x13\x0e\x42\x6a"
          "\x45\xec\x50\xf6\x0a\x21\xea\xa6\xcc\xb2\x93\xaa\xaf\x87\xee\x40\x8a\x4a\x5d\x39\x08\x03"
          "\x06\x70\x00\x4c\x05\x03\x98\xd0\x8d\xe6\x7c\xe7\xfe\x85\x6b\x73\x1d\xe6\x6d\x7c\x4c\x2f"
          "\xdc\xba\xfe\xa2\x55\x4d\x62\xec\x5a\x09\x33\x19\xf5\x86\xf7\x78\x85\x34\x3f\x9e\xe6\x2a"
          "\xfb\x1c\x2d\x9b\x28\x72\x53\x7c\x84\x5e\x4a\x79\x3a\xcf\x5a\xe8\xf4\x65\x9c\x10\x59\x71"
          "\x6f\x30\xb6\x1a\x9a\x43\x45\xc5\x26\x65\x88\x5f\xeb\xd7\x48\xbb\xd9\xf2\x69\x04\x93\xe4"
          "\xe8\xc1\x9a\x82\x2a\x39\xfd\x57\xd0\x2f\x32\xb2\x89\xa1\x76\xc9\x81\x28\xa6\x72\x78\xbd"
          "\x92\xe9\xee\x6b\x33\x4a\x72\x94\xd9\xfc\x72\x3a\xf1\x9f\x8a\xf2\x4b\xde\xe9\xde\x59\x4c"
          "\x7b\x4c\x8d\x7d\xa6\x16\xb3\x6e\xa3\xd1\x6d\x79\xbc\xc8\x71\xd6\x31\x5b\xfd\x87\x1d\xca"
          "\x49\x2f\xe2\x5c\x4f\x2c\x05\x89\x47\x9b\x58\x06\x5d\xe2\xf7\xea\x8b\x75\xbb\xae\x40\x49"
          "\x66\x93\xa6\xee\xc5\xa5\x52\xa1\x90\x33\x1c\xe2\x91\xf7\x41\xc6\x84\xc9\xd2\x16\x52\x90"
          "\xf2\xca\x1c\x5c\xb4\x05\xe3\x3e\x1d\x4c\xdf\x23\xe2\x64\xd3\x24\x57\x83\xb5\x0d\xf6\x12"
          "\x71\x60",
          "\xf1\x5f\xdf\x24\xf6\x28\x28\x4a\x9a\x0a\xf9\x4c\x91\xee\xcf\x4b\xbd\x33\xcc\x5c\xf5\xd5"
          "\xc1\x60\x66\xbe\x0e\x95\xec\x06\xee\xe4\x2a\x7d\xee\x76\x36\x83\xf9\xc9\x3f\x64\x82\xc9"
          "\x59\x0e\x4a\x82\x0c\xe2\x9d\x7e\xfe\xdb\x69\xb3\xb2\x99\xd2\xf0\xef\x73\xdc\xea\xfb\xd8"
          "\xdb\x82\x93\xd7\xf5\xfe\xd1\x44\x95\xe1\x8d\x37\x2a\x53\x6a\x95\x83\x88\x14\x81\x6d\xe8"
          "\xb9\x8b\x7f\xf5\xce\x01\x95\x44\xdb\x97\x94\x73\x12\xdb\x6c\x98\x00\x85\x6a\xe7\x52\x78"
          "\x98\xd8\xeb\xa6\xd3\x37\x8c\x8a\x3b\x40\x0c\xf4\x55\x3e\x7b\xca\x9f\x51\x01\xa8\x48\x90"
          "\x4b\x5c\xbe\x24\xa6\xfc\x8a\xee\xd1\x78\x9d\x20\xa0\x11\x0a\xf1\x45\xdc\xf7\xd7\x0b\x5f"
          "\x33\x6e\x41\x12\x56\xc0\xba\x60\x42\xe6\x9b\x97\x6d\x1b\x18\x17\x68\x11\x65\xd8\xf8\x85"
          "\x0e\x0a\x2a\x34\xe6\xb1\x93\xf9\x05\x08\x76\xb5\x32\x47\x16\x56\xd4\xa7\xd0\x80\x99\x84"
          "\xd2\x6f\xa6\x81\xd1\xb1\xe1\x45\xf8\x22\x0c\xde\x6f\x1d\x98\xe2\x61\x14\xd5\x78\x08\x8e"
          "\xbf\xa8\xd7\x5b\xb4\x1a\x53\xa5\x7c\xc3\xe6\x05\x27\x09\x76\x70\x14\x3e\x51\x56\xf5\x00"
          "\x54\x3a\x2c\x00\xbd\x95\x56\x04\x96\xe1\x94\xe7\xde\x1a\x1f\xb7\x60\xe2\x1a\x97\x09\x84"
          "\x3d\xf9\xb9\xa3\x39\xdc\x98\x80\xf2\x89\x32\x1b\x61\x0a\x8d\xaf\x04\x89\x8e\x4c\xe5\x91"
          "\x63\xee\xda\x65\x8f\xd2\x65\x43\x93\xe8\xbe\xc1\x7c\xba\xa5\xd7\x87\x86\x19\xaa\xd1\xc6"
          "\x73\x87\xfe\x2a\xac\x5b\xcd\xfe\xf8\x8c\x19\x06\xbc\xcc\x21\x3d\x76\x0b\xff\xea\x03\x68"
          "\x02\xb7\x92\x48\x38\xd6\xd4\xcf\x32\x68\xf9\xb1\x80\x46\x34\xa6\x7b\x53\xfe\x49\x36\x03"
          "\x03\x2f\x73\x70\xe0\xdf\x12\xf5\x30\x15\x77\xbd\xb3\x8e\x17\x79\xaf\x61\x59\xfd\x95\xf6"
          "\xa6\x78\xb7\x37\x9c\xe2\x3a\x49\x8b\xab\xe4\x67\x45\x81\x21\xf1\x8c\xea\x26\xe1\xd8\xb5"
          "\x84\x75\x55\x0c\x74\xc4\x09\x34\xc7\x1b\x27\x7f\x65\x76\x7f\x66\x48\xec\x97\xdf\xcd\x31"
          "\x1c\xec\x11\x7f\x24\x85\xdf\x1d\xb0\x97\xc1\xd0\x1c\xa0\x72\x29\xaf\xd5\x4a\xc8\x90\x69"
          "\x52\x9e\xf2\x37\x57\x57\xcf\xaa\xec\xac\x70\xaa\xd2\x57\x2a\xf9\xb4\xf4\xa6\x7f\xbc\x28"
          "\x15\x78",
          1, 3712 },
        { 128, 256, 92,
          "\x9c\xad\x46\x2d\x5f\x66\x59\xb2\xdd\x89\xa6\x8d\xaa\x5b\x7f\x14\x64\x4b\xa2\x48\x82\xc3"
          "\x7e\x97\x32\x23\xac\x4a\x87\x5e\x51\xb3",
          "\x92\x69\xb2\x44\x71\x08\x02\xc3\x7e\xc0\x1a\x38\xfc\xae\x78\x2b",
          "\xf9\xe5\x63\x06\xd0\x1d\xd5\x5d\x4c\xde\x17\x40\xe6\xf0\xbd\x2a\x2a\xa9\x89\xf8\x52\xf0"
          "\x89\x20\x37\x60\x1f\xd7\x1d\x15\x0e\x40\xb5\x1c\xa0\xb0\xc5\x32\xc1\x64\x84\xca\xb4\x8b"
          "\xb7\x7b\xad\x85\xe7\x65\x21\xbd\x6a\x65\x53\xe9\x3f\x50\x22\xd4\xee\xb0\xa6\x98\x6b\xf0"
          "\x14\x01\xa9\x5d\x76\xdd\xd6\x34\x10\xfd\x5c\x75\xbe\x7e\x69\xde\x08\x9e\x27\xfc\xd5\xcb"
          "\xb1\x1a\x6b\x4c\x1b\xec\x80\xc8\xd9\xc0\xfb\xa9\x51\x4f\x62\xdb\x57\x3b\xf0\x7b\x16\x10"
          "\xcd\xd9\xbf\xcf\xff\x71\xd7\x9c\xf7\x4c\x8e\xc2\x5d\x2e\x39\x03\x6e\xb7\x03\x93\xc5\x04"
          "\x02\x40\x19\x79\x35\x88\xc7\x62\xf3\x85\x81\x4b\x4b\x31\x1b\x1e\x04\x67\xcb\x38\x34\xd3"
          "\xc4\x30\x73\x44\x25\x04\x8e\x6a\xfe\x40\xee\x83\x80\xf5\xb0\x8c\x8a\xe1\x58\x17\x2d\xea"
          "\x9c\xa5\x31\x51\xc3\x50\x93\x3c\xed\x0f\x42\xde\x8b\x01\xc5\x16\x7c\xd8\x6b\xe0\xa6\xc5"
          "\xc4\x5e\x3a\x66\x1b\x7a\xb6\xf5\x1c\x73\xee\xb8\x70\x7c\xa4\x58\xc8\x26\x1f\xc8\x83\x19"
          "\x02\x80\xfa\xde\x3d\x92\x05\xff\x40\x4a\x69\x3d\xf7\xe2\xe4\x09\x24\x15\x7e\x2e\x20\x1e"
          "\xc0\x94\x44\x49\x43\xcb\x24\x92\x5f\xed\xd4\x94\xaf\xa7\x8a\x7d\x85\xd9\x07\x34\x51\x63"
          "\x5a\xe8\xf0\x9e\xc9\x59\x85\x8d\x58\x7d\x3b\x89\x4e\x9a\x46\xb3\x1d\x7a\x64\xf7\x5c\x7c"
          "\xa9\xcc\xe7\x69\xa1\xf2\x7c\x2f\xdc\xad\x5d\xf8\x62\xeb\x34\xdb\x48\x5f\x58\x91\xb4\x99"
          "\x38\x3e\x49\x4e\x26\x67\xb9\x9c\x5b\x91\x3b\xaf\x6d\xd0\x50\xdb\xa9\x87\xdb\x14\x99\xd9"
          "\xa8\x5e\x21\x4e\x85\x7b\xa9\x81\x4e\x5c\x7e\x39\x4f\x6b\xfd\x61\xa4\xc3\x37\x6d\x46\x68"
          "\xbb\x11\x09\x73\x0d\x81\x54\xf3\xd3\x7c\x01\x0c\xa3\xbf\x59\xd5\x4e\x82\xfd\x26\xbc\x76"
          "\x64\x5a\x57\x11\x4c\xb0\x25\x98\x29\x5d\x0e\x06\x1e\x51\x20\xaf\x9c\x7e\x4e\xc1\x99\xe6"
          "\xed\x59\x0c\x0e\x58\x99\x11\x8d\x43\x2d\x67\x4b\x1b\x6d\x61\x17\x80\xc9\x96\xc6\x85\xb0"
          "\xdb\x4a\x20\x3a\x1a\x8b\xb8\x14\x08\xdc\x6e\x94\x79\xfd\x43\x60\x75\x96\xdf\x1f\x6a\x39"
          "\xd7\x7c\x94\x7c\x92\x44\x7f\x79\x00\x15\x0f\xc1\x8b\x43\x5d\xbd\x14\xdb\x2a\xff\x4e\x7f"
          "\xd3\x88\xfc\x8d\x88\xe0\x4c\xb8\x2c\xaf\x17\x09\xff\x51\x5d\xe4\xd5\x5d",
          "\x21\x7e\x55\x06\x98\x60\x00\x34\xd3\x31\xf4\x9e\xd6\xb4\x85\xbb\x7f\xd4\x75\xf6\xda\x9b"
          "\x03\xed\x78\xc4\x84\x70\x05\x41\x14\x53\x98\x13\xbe\x0d\x46\xeb\xe8\x36\x25\x50\x6d\xe4"
          "\x37\x37\x59\xf7\xb8\xac\xf6\xaa\x2e\xc1\xfe\x8f\x60\x24\xc8\xb8\xdf\x63\x45\x83\x05\xb0"
          "\xb6\xb2\x5e\x90\xef\x7c\x41\x1d\xf5\x98\x1d\xe5\xd4\xb8\x9d\x95\xa5\xb2\x5d\xf9\x4c\x8a"
          "\x81\xf4\xf4\x93\xb1\x6e\x87\x55\x15\xfb\x02\xf9\x43\x17\xf1\xea\xd6\x9b\x53\x0f\x2c\xbc"
          "\xfd\xb0\x79\x06\xcc\xee\x6e\x1f\xe4\x67\x12\xe0\x72\x45\xe2\xb1\x50\x05\x47\x46\x8d\x3a"
          "\x5e\x14\x9d\x14\xd4\x00\x22\x9a\xf1\xf0\xaa\x1c\x39\x9c\xa7\xed\x0b\x7b\x40\x43\xb3\x77"
          "\x66\x96\xf1\xc0\x26\x84\xb8\x66\xcf\xe8\x5e\x9c\x93\x78\x70\x7b\x3e\x24\xfe\x6e\x25\xde"
          "\x24\xc6\x07\xca\x40\x7a\xca\x43\x2c\x33\x1d\xa2\x4d\x22\x87\xf0\x47\xba\xe3\xd3\x88\x98"
          "\x34\x02\x65\x8b\x92\xbe\xa6\x72\xc4\x1b\xcc\x67\x93\x5a\x68\x7f\x53\x41\x39\x77\x64\xe4"
          "\x58\xf0\xd8\x8a\x5d\x05\x09\x66\x3b\x91\xd4\x81\x3a\x6f\xaa\xd2\x4b\xdb\x60\x8a\x28\x06"
          "\x1d\xd0\x94\xa5\x0e\x75\x4d\x78\xdd\x74\xdd\x15\x6d\xa3\x15\xa3\xea\xf3\x64\xea\x33\x33"
          "\xed\xfa\x80\x8b\x9a\xd6\x26\xad\x89\xb6\x52\x1a\x1a\x52\x85\xb7\xcc\xf6\x08\x46\xf4\xe6"
          "\x80\x7f\x2c\xc4\xd0\xe1\xa4\x90\x11\x71\x2c\xad\xcf\x89\x7e\x14\x7a\x98\x1a\xd5\x5b\xbb"
          "\x2b\xdd\x35\xf3\xbf\xc4\xac\xe8\x1f\x5f\xf7\xcd\x8a\xc9\xd3\x8b\x7d\x46\xf6\x63\x9c\x07"
          "\x4a\xc8\xee\x6a\x9b\x16\xf0\xfa\x6a\xf8\xc1\xd1\xa3\x53\x07\x84\x06\x75\xcf\x71\xde\x9c"
          "\x81\xee\x03\x11\x10\xb5\x36\x00\xba\x57\x2a\x57\xb6\x4c\x67\xa1\xdd\x5b\x1e\xd5\xbe\x9c"
          "\x94\x9a\xf6\xea\xc4\xdf\x89\x76\xd7\xaa\x1d\xc8\x18\xca\xed\x95\x37\xad\x37\x2f\x33\x2a"
          "\xcc\x6f\x2d\xb2\x90\x4c\x3a\x55\x0c\x31\x8f\x39\xd3\xc9\xc6\x9c\x71\x09\x6f\xd4\x5b\x0c"
          "\x85\xb4\xfd\x52\xd4\x72\xca\xc9\x14\xbb\x5b\xcb\xa3\xba\xad\x93\x91\xcc\x00\x1d\xfe\x34"
          "\xab\xa3\x76\x16\x6d\x63\x8f\xaa\xb1\x01\xf6\x2e\x00\x62\x32\x08\xa1\x08\x08\x90\x00\x52"
          "\xef\xcb\xc6\x71\xe2\x36\x8a\xf8\xe3\x44\x6d\xec\x7c\x60\x48\x8f\xbb\xc3",
          1, 3840 },
        { 128, 256, 93,
          "\x61\x64\x7d\x8f\xf7\xa1\xa3\x11\x5f\x78\xb4\x8a\x99\xc1\xc1\x5b\xc7\x3e\x92\xe0\xb9\x92"
          "\xb8\xe2\x70\xcc\xde\xbf\xa2\xfe\x2d\x03",
          "\x31\xdb\x2d\x86\x31\x22\xce\xbe\xdc\x1f\x84\x08\x80\x17\x3a\x33",
          "\x09\x2b\x86\xb9\xb9\x3c\x35\x52\xf4\xc9\x6f\x89\xe9\xf5\x18\x75\x40\x65\xac\x16\x59\xd5"
          "\x48\xc9\x9d\x23\x31\x8c\x33\x2b\x50\x46\x15\x8c\xa1\xd0\x20\x8b\x80\x5b\x09\xc4\xac\xc1"
          "\x72\xd3\x07\x4a\x03\x26\x25\x65\x8c\xdf\xc2\xfc\xc5\x66\xbf\xd1\x41\x22\xff\x69\x2c\x56"
          "\x8e\x20\x11\xf9\xb3\xb3\x69\xd3\x70\x02\xf8\xc4\x11\xbf\xe3\xa5\x34\x3a\xa6\xa4\x9d\x28"
          "\x7a\x0f\x6c\x97\x35\xcf\xf2\x45\x80\x64\x42\xa6\x21\x4b\x89\x3f\xd3\x00\x93\xaf\x51\x86"
          "\x78\x4a\x4f\xb1\x91\x1d\x4b\xc2\x4c\x54\x3e\x87\x9e\x4b\x4e\x0a\x80\x66\xbf\xa1\x02\xd0"
          "\x5a\x4e\x00\x6f\x76\x05\x9b\xd0\x9d\x0b\x3f\x7d\x83\xed\xc5\xb6\x70\x20\x96\xc6\x0f\xb8"
          "\xcb\x97\xd1\xf0\x87\xa3\xea\xa8\x9e\x09\xe7\xe4\x48\xeb\x7c\x8e\x23\xa1\x09\xf5\x4d\xe0"
          "\x21\x42\xfc\xcb\x3f\xdf\x83\x65\xa6\x8c\xf4\x06\x0f\xbc\x58\x6a\xd7\x04\xba\x75\x8b\xac"
          "\x2d\x04\x3d\x2d\x0f\xda\x92\xa5\xb1\xe8\x37\x86\xa8\x79\xa0\x09\x9b\x00\xf6\xef\xab\xe3"
          "\x34\x6e\xc3\xdc\x1b\x3a\x07\xd9\xb7\x9a\x1f\xdc\x39\x88\x76\x32\xc2\x92\x37\x23\x4a\x03"
          "\x14\x48\x2b\xf4\xac\x16\x0b\x8e\x0d\x27\xe5\xe1\x60\xb1\x99\xfe\xb0\x8c\x40\x5b\xa3\x60"
          "\xfc\x84\xc3\x72\x2f\x7f\xae\x58\xab\x5c\xc7\xde\x68\x86\xec\x38\x31\x68\xdb\xb5\x73\x84"
          "\x26\x68\xfe\x05\x90\x2f\xa2\x82\xed\xa1\x34\x5b\xa1\x52\x47\x9a\xb4\x23\x1b\xe8\xf6\x1b"
          "\xda\x6b\x36\x70\x6e\xee\xba\x30\xf5\xea\xf4\x50\xb3\x44\x7c\x4a\xab\xbc\x42\xe3\x1f\x0e"
          "\x90\xde\xc8\x2a\x65\xab\x3e\x32\x0e\x66\x24\xfa\x86\x4a\xc8\xf3\x6e\x9c\x5e\x99\x45\x9b"
          "\x47\xf2\x49\x51\x70\x8a\x13\x27\xba\x55\xe7\xcb\xa8\xd7\xf6\x65\x7b\x8f\x27\x68\x01\xb8"
          "\x3d\xe3\x66\x4c\x6c\xaf\xa9\xbd\x0d\x87\xbe\xdd\x36\x30\x81\xa9\xd9\x42\x8a\x58\x68\x90"
          "\x53\xd1\xf0\x5a\x29\x25\xc5\x25\x5b\x05\x0e\x2b\x6e\xff\x37\xda\x1c\x2a\x88\xc2\x19\xd6"
          "\x3f\xfd\x58\x22\x38\x27\x11\xe1\x5d\x09\xfd\x52\x56\xec\x3a\xc4\xa0\x49\x08\x06\x69\xa7"
          "\xb0\x12\x67\x57\x58\xfc\xdd\x6a\xf5\x65\x76\xc9\x07\x51\xe6\xf2\xe9\x85\xcb\xea\xd8\xcb"
          "\x75\x5e\xd5\x9a\x33\x05\xf8\x05\xbc\xef\xc6\x3e\xc7\x6b\xe1\xaa\x80\xd4\x5c\x95\x31\xa1"
          "\x9f\x4a\x0c\x80\x88\x41\x9a\xb0\xa1\xf1\x95\x10",
          "\xe3\x25\xfd\x1b\x32\x97\x8b\x74\xa9\x9e\xf1\xb7\x2e\xb3\x3c\xf2\xc7\x1a\x79\x78\x9c\xd3"
          "\xbe\xa0\x8c\x78\x9e\x6d\x14\xce\x27\xdb\xa4\xc3\x4c\x47\x71\xdd\x49\x04\x20\xf8\xd4\x9b"
          "\x34\x02\xab\xde\xa9\xe5\xa7\xc7\xc0\x77\x2e\x31\xce\x0e\x30\x8b\x2d\x1e\xa9\x60\x17\xc2"
          "\x95\x08\x29\xe9\xb8\xe6\x13\x1d\x2c\xa8\x64\xb5\xd4\x97\xdf\xf7\x5b\x26\x1e\xd9\x78\x38"
          "\x3c\x09\xd6\xbb\x5e\x8b\x1b\x7f\xe9\x34\x4a\x88\xb3\x45\xc6\xb4\xa2\xe5\xcb\x88\x4e\xd0"
          "\xd0\xf5\x39\x3e\xec\xec\x3f\x3a\x32\xa4\xc5\xee\xe0\xc5\x3e\x95\xb2\x1e\xcb\xa2\xe3\x4c"
          "\x74\x61\x62\xb4\x9b\x78\xca\x18\x75\x09\x72\x7d\xdf\xa1\x7d\xaf\x44\x3a\x9b\x45\x26\x54"
          "\xb5\x73\x4f\xc3\xbc\xc7\xa2\x5c\xe8\x95\x67\x6d\x1f\x39\xec\x9a\xa3\xc0\xd4\x15\xe9\xd9"
          "\xc3\xdc\x17\x3b\x16\x79\x9c\x01\x6e\x8e\x21\x62\x59\x36\x99\x87\xa2\xc3\x66\x72\xb4\xad"
          "\x99\xf7\xb7\x1b\xd3\xce\xeb\x86\x3a\xeb\x4d\xb7\xae\xe2\x31\xce\x63\x47\x87\xc5\xab\xff"
          "\x5a\x87\xe7\x8d\xe7\x29\x7b\xa0\x80\x38\x37\xb5\x80\x3d\x79\x01\x26\x85\xa2\x4d\xbd\xd0"
          "\xd7\x2c\xfb\x2b\x33\xb3\x46\x49\x64\x26\x6a\xcc\xd8\xde\xdb\x84\x7f\x4c\xff\x61\xc2\xf9"
          "\xd5\xe1\x7b\x2e\xaf\x22\x3e\xe5\x2f\xd1\x81\xec\x83\x44\x54\x3a\x05\x3b\xc0\xdb\x86\x15"
          "\x55\xd5\x0e\x2b\xfc\xe3\x05\x60\x14\xcb\x5a\x6a\x96\x4b\xd0\x32\xc6\xe1\x21\x0b\x18\xd3"
          "\x40\x2e\xff\x42\x91\x02\x41\x9d\x3b\x00\x0c\x51\xd5\x72\xb0\xed\x6e\x89\x98\xb0\xdb\xd1"
          "\x8c\xc4\x4a\x27\xab\xbf\xdb\x14\xbd\xbc\x12\x80\x56\x8b\xaf\x63\xad\x74\x30\x13\x44\x90"
          "\xb0\x70\x5d\x5a\x24\x2e\x05\x42\xee\x8a\xfd\xb1\x23\x9d\x46\x29\x58\x29\xe9\xd7\xc0\xe9"
          "\x78\x0d\xca\x58\x9b\x1f\xb5\xa2\x24\x9a\xbc\x44\xa3\x06\xd1\x60\x4c\x29\x72\xd5\x77\x32"
          "\x3d\xf3\xb0\x9e\xe8\x40\x65\xa1\x39\xaa\xc0\x42\x07\xc6\xe5\x1f\x43\x58\x0b\x55\x8f\x54"
          "\xfd\x5a\x6d\x37\x77\x94\xc9\x9d\x70\x33\x04\xb9\xb1\x61\x15\xd8\x3f\x6d\xc5\x1a\x81\x31"
          "\x89\xd4\x63\x0b\xfb\xdb\xcc\x56\xc7\xee\xc9\x35\xf9\xcd\xaf\x5c\x1a\x52\x05\x45\xf7\xef"
          "\x04\x65\x9b\x4a\x7a\x53\xcf\x93\x28\x75\x4d\xfe\x08\x75\x3c\x85\x15\x94\x4e\xfb\x43\xe0"
          "\x5e\x50\xe9\x2f\x95\x31\xbe\xb3\x94\x11\x8b\x49",
          1, 3968 },
        { 0, 0, 0, NULL, NULL, NULL, NULL, 0, 0 }
};
