; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 4
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

declare double @erf(double)
declare double @cos(double)
declare double @fabs(double)

declare void @use(double) nounwind

; Check odd parity: -erf(-x) == erf(x)
define double @test_erf(double %x) {
; CHECK-LABEL: define double @test_erf(
; CHECK-SAME: double [[X:%.*]]) {
; CHECK-NEXT:    [[RES:%.*]] = tail call reassoc double @erf(double [[X]])
; CHECK-NEXT:    ret double [[RES]]
;
  %neg_x = fneg double %x
  %res = tail call reassoc double @erf(double %neg_x)
  %neg_res = fneg double %res
  ret double %neg_res
}

; Check even parity: cos(fabs(x)) == cos(x)
define double @test_cos_fabs(double %x) {
; CHECK-LABEL: define double @test_cos_fabs(
; CHECK-SAME: double [[X:%.*]]) {
; CHECK-NEXT:    [[RES:%.*]] = tail call reassoc double @cos(double [[X]])
; CHECK-NEXT:    ret double [[RES]]
;
  %fabs_res = call double @fabs(double %x)
  %res = tail call reassoc double @cos(double %fabs_res)
  ret double %res
}

; Do nothing in case of multi-use
define double @test_erf_multi_use(double %x) {
; CHECK-LABEL: define double @test_erf_multi_use(
; CHECK-SAME: double [[X:%.*]]) {
; CHECK-NEXT:    [[NEG_X:%.*]] = fneg double [[X]]
; CHECK-NEXT:    call void @use(double [[NEG_X]])
; CHECK-NEXT:    [[RES:%.*]] = call double @erf(double [[NEG_X]])
; CHECK-NEXT:    [[NEG_RES:%.*]] = fneg double [[RES]]
; CHECK-NEXT:    ret double [[NEG_RES]]
;
  %neg_x = fneg double %x
  call void @use(double %neg_x)
  %res = call double @erf(double %neg_x)
  %neg_res = fneg double %res
  ret double %neg_res
}
