% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themes.R
\name{theme_minimal_grid}
\alias{theme_minimal_grid}
\alias{theme_minimal_vgrid}
\alias{theme_minimal_hgrid}
\title{Minimalistic themes with grids}
\usage{
theme_minimal_grid(
  font_size = 14,
  font_family = "",
  line_size = 0.5,
  rel_small = 12/14,
  rel_tiny = 11/14,
  rel_large = 16/14,
  color = "grey85",
  colour
)

theme_minimal_vgrid(
  font_size = 14,
  font_family = "",
  line_size = 0.5,
  rel_small = 12/14,
  rel_tiny = 11/14,
  rel_large = 16/14,
  color = "grey85",
  colour
)

theme_minimal_hgrid(
  font_size = 14,
  font_family = "",
  line_size = 0.5,
  rel_small = 12/14,
  rel_tiny = 11/14,
  rel_large = 16/14,
  color = "grey85",
  colour
)
}
\arguments{
\item{font_size}{Overall font size.}

\item{font_family}{Font family for plot title, axis titles and labels, legend texts, etc.}

\item{line_size}{Line size for grid lines.}

\item{rel_small}{Relative size of small text (e.g., axis tick labels)}

\item{rel_tiny}{Relative size of tiny text (e.g., caption)}

\item{rel_large}{Relative size of large text (e.g., title)}

\item{color, colour}{Color of grid lines.}
}
\description{
Three minimalistic themes that provide either a full grid,
a horizontal grid, or a vertical grid. Similar to \code{\link[ggplot2:ggtheme]{ggplot2::theme_minimal()}}, but with some
stylistic differences. Most importantly, these themes do not draw minor grid lines.
Also, font sizes are coordinated with \code{\link[=theme_half_open]{theme_half_open()}} and with the defaults
in the \code{\link[=save_plot]{save_plot()}} function.
}
\details{
\code{theme_minimal_grid()} provides a minimal grid theme. \code{theme_minimal_hgrid()} strips down
this theme even further and draws only horizontal lines, and \code{theme_minimal_vgrid()}
does the same for vertical lines.
}
\examples{
library(ggplot2)

# theme_minimal_grid()
ggplot(iris, aes(x = Sepal.Length, y = Sepal.Width, color = Species)) +
  geom_point() + theme_minimal_grid()

# theme_minimal_hgrid()
ggplot(mtcars, aes(x = carb)) +
  geom_bar(fill = "lightblue") +
  scale_y_continuous(limits = c(0, 11.5), expand = c(0, 0)) +
  theme_minimal_hgrid()

# theme_minimal_vgrid()
ggplot(mtcars, aes(x = carb)) +
  geom_bar(fill = "lightblue") +
  scale_y_continuous(limits = c(0, 11.5), expand = c(0, 0)) +
  coord_flip() +
  theme_minimal_vgrid()
}
