# The Rust Language Reference

This document is the primary reference for the Rust programming language.

## Contributor docs

There are several pages for those working on the reference:

* [Authoring guide](https://github.com/rust-lang/reference/blob/master/docs/authoring.md): Guidelines for writing content.
* [Review policy](https://github.com/rust-lang/reference/blob/master/docs/review-policy.md): Guidelines for reviewers.
* [Grammar](https://github.com/rust-lang/reference/blob/master/docs/grammar.md): How the grammar syntax works.
* [Attribute template](https://github.com/rust-lang/reference/blob/master/docs/attribute-template.md): The standard template for documenting an attribute.

## Building

To build the Reference, first clone the project:

```sh
git clone https://github.com/rust-lang/reference.git
cd reference
```

(Alternatively, if you don't want to use `git`, [download][] a ZIP file
of the project, extract it using your preferred tool, and rename the
top-level directory to `reference`.)

[download]: https://github.com/rust-lang/reference/archive/refs/heads/master.zip

### Installing mdbook

The Reference is built using [mdbook].

First, ensure that you have a recent copy of the nightly Rust compiler installed, as this is needed in order to run the tests:

```sh
rustup toolchain install nightly
rustup override set nightly
```

Now, ensure you have `mdbook` installed, as this is needed in order to build the Reference:

```sh
cargo install --locked mdbook
```

[mdbook]: https://rust-lang.github.io/mdBook/

### Running mdbook

`mdbook` provides a variety of different commands and options to help you work on the book:

* `mdbook build --open`: Build the book and open it in a web browser.
* `mdbook serve --open`: Launches a web server on localhost. It also automatically rebuilds the book whenever any file changes and automatically reloads your web browser.

The book contents are driven by a `SUMMARY.md` file, and every file must be linked there. See <https://rust-lang.github.io/mdBook/> for its usage.

### `SPEC_RELATIVE`

The `SPEC_RELATIVE=0` environment variable makes links to the standard library go to <https://doc.rust-lang.org/> instead of being relative, which is useful when viewing locally since you normally don't have a copy of the standard library.

```sh
SPEC_RELATIVE=0 mdbook serve --open
```

The published site at <https://doc.rust-lang.org/reference/> (or local docs using `rustup doc`) does not set this, which means it will use relative links which supports offline viewing and links to the correct version (for example, links in <https://doc.rust-lang.org/1.81.0/reference/> will stay within the 1.81.0 directory).

### `SPEC_DENY_WARNINGS`

The `SPEC_DENY_WARNINGS=1` environment variable will turn all warnings generated by `mdbook-spec` to errors. This is used in CI to ensure that there aren't any problems with the book content.

### `SPEC_RUST_ROOT`

The `SPEC_RUST_ROOT` can be used to point to the directory of a checkout of <https://github.com/rust-lang/rust>. This is used by the test-linking feature so that it can find tests linked to reference rules. If this is not set, then the tests won't be linked.

## Running tests

There are several different kinds of tests you can run (these are enforced on CI):

* `mdbook test`: This will run the inline Rust codeblocks (internally it uses `rustdoc` to do this).
* `cargo xtask style-check`: This will validate some style checks (see [authoring guide](docs/authoring.md)).
* `cargo xtask linkcheck`: This will validate that markdown links aren't broken.
* `cargo xtask test-all`: Runs all tests.

## How is this published?

The process for getting the reference content into a [Rust release](https://doc.rust-lang.org/reference/#rust-releases) and on the website is:

1. Changes are merged to this repository.
2. [Triagebot](https://forge.rust-lang.org/triagebot/doc-updates.html) will automatically synchronize this repository to [rust-lang/rust]. This happens every other week. The reference is tracked in [rust-lang/rust] as a [submodule](https://github.com/rust-lang/rust/tree/master/src/doc).
  - This will open a PR on [rust-lang/rust] which needs to be merged, and that can take up to several days.
3. At midnight UTC, whatever is on the default branch of [rust-lang/rust] will be a part of that nightly release, and will be published after a few hours to <https://doc.rust-lang.org/nightly/reference/>.
4. Following Rust's [release process](https://doc.rust-lang.org/book/appendix-07-nightly-rust.html), every 6 weeks, nightly will be promoted to beta (<https://doc.rust-lang.org/beta/reference/>), and then 6 weeks after that it will be promoted to stable (<https://doc.rust-lang.org/stable/reference/>).

[rust-lang/rust]: https://github.com/rust-lang/rust/
