package app.tuxguitar.ui.swt.widget;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Scale;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.swt.event.SWTSelectionListenerManager;
import app.tuxguitar.ui.widget.UIScale;

public class SWTScale extends SWTControl<Scale> implements UIScale {

	private SWTSelectionListenerManager selectionListener;

	public SWTScale(SWTContainer<? extends Composite> parent, int orientation) {
		super(new Scale(parent.getControl(), SWT.BORDER | orientation), parent);

		this.selectionListener = new SWTSelectionListenerManager(this);
	}

	public void setValue(int value) {
		this.getControl().setSelection(this.parseValue(value));
	}

	public int getValue() {
		return this.parseValue(this.getControl().getSelection());
	}

	public void setMaximum(int maximum) {
		this.getControl().setMaximum(maximum);
	}

	public int getMaximum() {
		return this.getControl().getMaximum();
	}

	public void setMinimum(int minimum) {
		this.getControl().setMinimum(minimum);
	}

	public int getMinimum() {
		return this.getControl().getMinimum();
	}

	public void setIncrement(int increment) {
		this.getControl().setIncrement(increment);
		this.getControl().setPageIncrement(increment);
	}

	public int getIncrement() {
		return this.getControl().getIncrement();
	}

	public int parseValue(int value) {
		if((this.getControl().getStyle() & SWT.VERTICAL) != 0 ) {
			return ((this.getMaximum() - this.getMinimum()) - value);
		}
		return value;
	}

	public void addSelectionListener(UISelectionListener listener) {
		if( this.selectionListener.isEmpty() ) {
			this.getControl().addSelectionListener(this.selectionListener);
		}
		this.selectionListener.addListener(listener);
	}

	public void removeSelectionListener(UISelectionListener listener) {
		this.selectionListener.removeListener(listener);
		if( this.selectionListener.isEmpty() ) {
			this.getControl().removeSelectionListener(this.selectionListener);
		}
	}
}
