// Code generated by protoc-gen-go. DO NOT EDIT.
// source: ref.proto

package gitaly

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import google_protobuf "github.com/golang/protobuf/ptypes/timestamp"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

type FindLocalBranchesRequest_SortBy int32

const (
	FindLocalBranchesRequest_NAME         FindLocalBranchesRequest_SortBy = 0
	FindLocalBranchesRequest_UPDATED_ASC  FindLocalBranchesRequest_SortBy = 1
	FindLocalBranchesRequest_UPDATED_DESC FindLocalBranchesRequest_SortBy = 2
)

var FindLocalBranchesRequest_SortBy_name = map[int32]string{
	0: "NAME",
	1: "UPDATED_ASC",
	2: "UPDATED_DESC",
}
var FindLocalBranchesRequest_SortBy_value = map[string]int32{
	"NAME":         0,
	"UPDATED_ASC":  1,
	"UPDATED_DESC": 2,
}

func (x FindLocalBranchesRequest_SortBy) String() string {
	return proto.EnumName(FindLocalBranchesRequest_SortBy_name, int32(x))
}
func (FindLocalBranchesRequest_SortBy) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor8, []int{8, 0}
}

type CreateBranchResponse_Status int32

const (
	CreateBranchResponse_OK                      CreateBranchResponse_Status = 0
	CreateBranchResponse_ERR_EXISTS              CreateBranchResponse_Status = 1
	CreateBranchResponse_ERR_INVALID             CreateBranchResponse_Status = 2
	CreateBranchResponse_ERR_INVALID_START_POINT CreateBranchResponse_Status = 3
)

var CreateBranchResponse_Status_name = map[int32]string{
	0: "OK",
	1: "ERR_EXISTS",
	2: "ERR_INVALID",
	3: "ERR_INVALID_START_POINT",
}
var CreateBranchResponse_Status_value = map[string]int32{
	"OK":                      0,
	"ERR_EXISTS":              1,
	"ERR_INVALID":             2,
	"ERR_INVALID_START_POINT": 3,
}

func (x CreateBranchResponse_Status) String() string {
	return proto.EnumName(CreateBranchResponse_Status_name, int32(x))
}
func (CreateBranchResponse_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor8, []int{19, 0}
}

type FindDefaultBranchNameRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
}

func (m *FindDefaultBranchNameRequest) Reset()                    { *m = FindDefaultBranchNameRequest{} }
func (m *FindDefaultBranchNameRequest) String() string            { return proto.CompactTextString(m) }
func (*FindDefaultBranchNameRequest) ProtoMessage()               {}
func (*FindDefaultBranchNameRequest) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{0} }

func (m *FindDefaultBranchNameRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

type FindDefaultBranchNameResponse struct {
	Name []byte `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (m *FindDefaultBranchNameResponse) Reset()                    { *m = FindDefaultBranchNameResponse{} }
func (m *FindDefaultBranchNameResponse) String() string            { return proto.CompactTextString(m) }
func (*FindDefaultBranchNameResponse) ProtoMessage()               {}
func (*FindDefaultBranchNameResponse) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{1} }

func (m *FindDefaultBranchNameResponse) GetName() []byte {
	if m != nil {
		return m.Name
	}
	return nil
}

type FindAllBranchNamesRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
}

func (m *FindAllBranchNamesRequest) Reset()                    { *m = FindAllBranchNamesRequest{} }
func (m *FindAllBranchNamesRequest) String() string            { return proto.CompactTextString(m) }
func (*FindAllBranchNamesRequest) ProtoMessage()               {}
func (*FindAllBranchNamesRequest) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{2} }

func (m *FindAllBranchNamesRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

type FindAllBranchNamesResponse struct {
	Names [][]byte `protobuf:"bytes,1,rep,name=names,proto3" json:"names,omitempty"`
}

func (m *FindAllBranchNamesResponse) Reset()                    { *m = FindAllBranchNamesResponse{} }
func (m *FindAllBranchNamesResponse) String() string            { return proto.CompactTextString(m) }
func (*FindAllBranchNamesResponse) ProtoMessage()               {}
func (*FindAllBranchNamesResponse) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{3} }

func (m *FindAllBranchNamesResponse) GetNames() [][]byte {
	if m != nil {
		return m.Names
	}
	return nil
}

type FindAllTagNamesRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
}

func (m *FindAllTagNamesRequest) Reset()                    { *m = FindAllTagNamesRequest{} }
func (m *FindAllTagNamesRequest) String() string            { return proto.CompactTextString(m) }
func (*FindAllTagNamesRequest) ProtoMessage()               {}
func (*FindAllTagNamesRequest) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{4} }

func (m *FindAllTagNamesRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

type FindAllTagNamesResponse struct {
	Names [][]byte `protobuf:"bytes,1,rep,name=names,proto3" json:"names,omitempty"`
}

func (m *FindAllTagNamesResponse) Reset()                    { *m = FindAllTagNamesResponse{} }
func (m *FindAllTagNamesResponse) String() string            { return proto.CompactTextString(m) }
func (*FindAllTagNamesResponse) ProtoMessage()               {}
func (*FindAllTagNamesResponse) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{5} }

func (m *FindAllTagNamesResponse) GetNames() [][]byte {
	if m != nil {
		return m.Names
	}
	return nil
}

type FindRefNameRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	// Require that the resulting ref contains this commit as an ancestor
	CommitId string `protobuf:"bytes,2,opt,name=commit_id,json=commitId" json:"commit_id,omitempty"`
	// Example prefix: "refs/heads/". Type bytes because that is the type of ref names.
	Prefix []byte `protobuf:"bytes,3,opt,name=prefix,proto3" json:"prefix,omitempty"`
}

func (m *FindRefNameRequest) Reset()                    { *m = FindRefNameRequest{} }
func (m *FindRefNameRequest) String() string            { return proto.CompactTextString(m) }
func (*FindRefNameRequest) ProtoMessage()               {}
func (*FindRefNameRequest) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{6} }

func (m *FindRefNameRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *FindRefNameRequest) GetCommitId() string {
	if m != nil {
		return m.CommitId
	}
	return ""
}

func (m *FindRefNameRequest) GetPrefix() []byte {
	if m != nil {
		return m.Prefix
	}
	return nil
}

type FindRefNameResponse struct {
	// Example name: "refs/heads/master". Cannot assume UTF8, so the type is bytes.
	Name []byte `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (m *FindRefNameResponse) Reset()                    { *m = FindRefNameResponse{} }
func (m *FindRefNameResponse) String() string            { return proto.CompactTextString(m) }
func (*FindRefNameResponse) ProtoMessage()               {}
func (*FindRefNameResponse) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{7} }

func (m *FindRefNameResponse) GetName() []byte {
	if m != nil {
		return m.Name
	}
	return nil
}

type FindLocalBranchesRequest struct {
	Repository *Repository                     `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	SortBy     FindLocalBranchesRequest_SortBy `protobuf:"varint,2,opt,name=sort_by,json=sortBy,enum=gitaly.FindLocalBranchesRequest_SortBy" json:"sort_by,omitempty"`
}

func (m *FindLocalBranchesRequest) Reset()                    { *m = FindLocalBranchesRequest{} }
func (m *FindLocalBranchesRequest) String() string            { return proto.CompactTextString(m) }
func (*FindLocalBranchesRequest) ProtoMessage()               {}
func (*FindLocalBranchesRequest) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{8} }

func (m *FindLocalBranchesRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *FindLocalBranchesRequest) GetSortBy() FindLocalBranchesRequest_SortBy {
	if m != nil {
		return m.SortBy
	}
	return FindLocalBranchesRequest_NAME
}

type FindLocalBranchesResponse struct {
	Branches []*FindLocalBranchResponse `protobuf:"bytes,1,rep,name=branches" json:"branches,omitempty"`
}

func (m *FindLocalBranchesResponse) Reset()                    { *m = FindLocalBranchesResponse{} }
func (m *FindLocalBranchesResponse) String() string            { return proto.CompactTextString(m) }
func (*FindLocalBranchesResponse) ProtoMessage()               {}
func (*FindLocalBranchesResponse) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{9} }

func (m *FindLocalBranchesResponse) GetBranches() []*FindLocalBranchResponse {
	if m != nil {
		return m.Branches
	}
	return nil
}

type FindLocalBranchResponse struct {
	Name            []byte                       `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	CommitId        string                       `protobuf:"bytes,2,opt,name=commit_id,json=commitId" json:"commit_id,omitempty"`
	CommitSubject   []byte                       `protobuf:"bytes,3,opt,name=commit_subject,json=commitSubject,proto3" json:"commit_subject,omitempty"`
	CommitAuthor    *FindLocalBranchCommitAuthor `protobuf:"bytes,4,opt,name=commit_author,json=commitAuthor" json:"commit_author,omitempty"`
	CommitCommitter *FindLocalBranchCommitAuthor `protobuf:"bytes,5,opt,name=commit_committer,json=commitCommitter" json:"commit_committer,omitempty"`
}

func (m *FindLocalBranchResponse) Reset()                    { *m = FindLocalBranchResponse{} }
func (m *FindLocalBranchResponse) String() string            { return proto.CompactTextString(m) }
func (*FindLocalBranchResponse) ProtoMessage()               {}
func (*FindLocalBranchResponse) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{10} }

func (m *FindLocalBranchResponse) GetName() []byte {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *FindLocalBranchResponse) GetCommitId() string {
	if m != nil {
		return m.CommitId
	}
	return ""
}

func (m *FindLocalBranchResponse) GetCommitSubject() []byte {
	if m != nil {
		return m.CommitSubject
	}
	return nil
}

func (m *FindLocalBranchResponse) GetCommitAuthor() *FindLocalBranchCommitAuthor {
	if m != nil {
		return m.CommitAuthor
	}
	return nil
}

func (m *FindLocalBranchResponse) GetCommitCommitter() *FindLocalBranchCommitAuthor {
	if m != nil {
		return m.CommitCommitter
	}
	return nil
}

type FindLocalBranchCommitAuthor struct {
	Name  []byte                     `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Email []byte                     `protobuf:"bytes,2,opt,name=email,proto3" json:"email,omitempty"`
	Date  *google_protobuf.Timestamp `protobuf:"bytes,3,opt,name=date" json:"date,omitempty"`
}

func (m *FindLocalBranchCommitAuthor) Reset()                    { *m = FindLocalBranchCommitAuthor{} }
func (m *FindLocalBranchCommitAuthor) String() string            { return proto.CompactTextString(m) }
func (*FindLocalBranchCommitAuthor) ProtoMessage()               {}
func (*FindLocalBranchCommitAuthor) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{11} }

func (m *FindLocalBranchCommitAuthor) GetName() []byte {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *FindLocalBranchCommitAuthor) GetEmail() []byte {
	if m != nil {
		return m.Email
	}
	return nil
}

func (m *FindLocalBranchCommitAuthor) GetDate() *google_protobuf.Timestamp {
	if m != nil {
		return m.Date
	}
	return nil
}

type FindAllBranchesRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	// Only return branches that are merged into root ref
	MergedOnly bool `protobuf:"varint,2,opt,name=merged_only,json=mergedOnly" json:"merged_only,omitempty"`
	// If merged_only is true, this is a list of branches from which we
	// return those merged into the root ref
	MergedBranches [][]byte `protobuf:"bytes,3,rep,name=merged_branches,json=mergedBranches,proto3" json:"merged_branches,omitempty"`
}

func (m *FindAllBranchesRequest) Reset()                    { *m = FindAllBranchesRequest{} }
func (m *FindAllBranchesRequest) String() string            { return proto.CompactTextString(m) }
func (*FindAllBranchesRequest) ProtoMessage()               {}
func (*FindAllBranchesRequest) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{12} }

func (m *FindAllBranchesRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *FindAllBranchesRequest) GetMergedOnly() bool {
	if m != nil {
		return m.MergedOnly
	}
	return false
}

func (m *FindAllBranchesRequest) GetMergedBranches() [][]byte {
	if m != nil {
		return m.MergedBranches
	}
	return nil
}

type FindAllBranchesResponse struct {
	Branches []*FindAllBranchesResponse_Branch `protobuf:"bytes,1,rep,name=branches" json:"branches,omitempty"`
}

func (m *FindAllBranchesResponse) Reset()                    { *m = FindAllBranchesResponse{} }
func (m *FindAllBranchesResponse) String() string            { return proto.CompactTextString(m) }
func (*FindAllBranchesResponse) ProtoMessage()               {}
func (*FindAllBranchesResponse) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{13} }

func (m *FindAllBranchesResponse) GetBranches() []*FindAllBranchesResponse_Branch {
	if m != nil {
		return m.Branches
	}
	return nil
}

type FindAllBranchesResponse_Branch struct {
	Name   []byte     `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Target *GitCommit `protobuf:"bytes,2,opt,name=target" json:"target,omitempty"`
}

func (m *FindAllBranchesResponse_Branch) Reset()         { *m = FindAllBranchesResponse_Branch{} }
func (m *FindAllBranchesResponse_Branch) String() string { return proto.CompactTextString(m) }
func (*FindAllBranchesResponse_Branch) ProtoMessage()    {}
func (*FindAllBranchesResponse_Branch) Descriptor() ([]byte, []int) {
	return fileDescriptor8, []int{13, 0}
}

func (m *FindAllBranchesResponse_Branch) GetName() []byte {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *FindAllBranchesResponse_Branch) GetTarget() *GitCommit {
	if m != nil {
		return m.Target
	}
	return nil
}

type FindAllTagsRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
}

func (m *FindAllTagsRequest) Reset()                    { *m = FindAllTagsRequest{} }
func (m *FindAllTagsRequest) String() string            { return proto.CompactTextString(m) }
func (*FindAllTagsRequest) ProtoMessage()               {}
func (*FindAllTagsRequest) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{14} }

func (m *FindAllTagsRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

type FindAllTagsResponse struct {
	Tags []*Tag `protobuf:"bytes,1,rep,name=tags" json:"tags,omitempty"`
}

func (m *FindAllTagsResponse) Reset()                    { *m = FindAllTagsResponse{} }
func (m *FindAllTagsResponse) String() string            { return proto.CompactTextString(m) }
func (*FindAllTagsResponse) ProtoMessage()               {}
func (*FindAllTagsResponse) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{15} }

func (m *FindAllTagsResponse) GetTags() []*Tag {
	if m != nil {
		return m.Tags
	}
	return nil
}

type RefExistsRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	// Any ref, e.g. 'refs/heads/master' or 'refs/tags/v1.0.1'. Must start with 'refs/'.
	Ref []byte `protobuf:"bytes,2,opt,name=ref,proto3" json:"ref,omitempty"`
}

func (m *RefExistsRequest) Reset()                    { *m = RefExistsRequest{} }
func (m *RefExistsRequest) String() string            { return proto.CompactTextString(m) }
func (*RefExistsRequest) ProtoMessage()               {}
func (*RefExistsRequest) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{16} }

func (m *RefExistsRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *RefExistsRequest) GetRef() []byte {
	if m != nil {
		return m.Ref
	}
	return nil
}

type RefExistsResponse struct {
	Value bool `protobuf:"varint,1,opt,name=value" json:"value,omitempty"`
}

func (m *RefExistsResponse) Reset()                    { *m = RefExistsResponse{} }
func (m *RefExistsResponse) String() string            { return proto.CompactTextString(m) }
func (*RefExistsResponse) ProtoMessage()               {}
func (*RefExistsResponse) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{17} }

func (m *RefExistsResponse) GetValue() bool {
	if m != nil {
		return m.Value
	}
	return false
}

type CreateBranchRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	Name       []byte      `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	StartPoint []byte      `protobuf:"bytes,3,opt,name=start_point,json=startPoint,proto3" json:"start_point,omitempty"`
}

func (m *CreateBranchRequest) Reset()                    { *m = CreateBranchRequest{} }
func (m *CreateBranchRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateBranchRequest) ProtoMessage()               {}
func (*CreateBranchRequest) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{18} }

func (m *CreateBranchRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *CreateBranchRequest) GetName() []byte {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *CreateBranchRequest) GetStartPoint() []byte {
	if m != nil {
		return m.StartPoint
	}
	return nil
}

type CreateBranchResponse struct {
	Status CreateBranchResponse_Status `protobuf:"varint,1,opt,name=status,enum=gitaly.CreateBranchResponse_Status" json:"status,omitempty"`
	Branch *Branch                     `protobuf:"bytes,2,opt,name=branch" json:"branch,omitempty"`
}

func (m *CreateBranchResponse) Reset()                    { *m = CreateBranchResponse{} }
func (m *CreateBranchResponse) String() string            { return proto.CompactTextString(m) }
func (*CreateBranchResponse) ProtoMessage()               {}
func (*CreateBranchResponse) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{19} }

func (m *CreateBranchResponse) GetStatus() CreateBranchResponse_Status {
	if m != nil {
		return m.Status
	}
	return CreateBranchResponse_OK
}

func (m *CreateBranchResponse) GetBranch() *Branch {
	if m != nil {
		return m.Branch
	}
	return nil
}

type DeleteBranchRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	Name       []byte      `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
}

func (m *DeleteBranchRequest) Reset()                    { *m = DeleteBranchRequest{} }
func (m *DeleteBranchRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteBranchRequest) ProtoMessage()               {}
func (*DeleteBranchRequest) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{20} }

func (m *DeleteBranchRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *DeleteBranchRequest) GetName() []byte {
	if m != nil {
		return m.Name
	}
	return nil
}

// Not clear if we need to do status signaling; we can add fields later.
type DeleteBranchResponse struct {
}

func (m *DeleteBranchResponse) Reset()                    { *m = DeleteBranchResponse{} }
func (m *DeleteBranchResponse) String() string            { return proto.CompactTextString(m) }
func (*DeleteBranchResponse) ProtoMessage()               {}
func (*DeleteBranchResponse) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{21} }

type FindBranchRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	// Name can be 'master' but also 'refs/heads/master'
	Name []byte `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
}

func (m *FindBranchRequest) Reset()                    { *m = FindBranchRequest{} }
func (m *FindBranchRequest) String() string            { return proto.CompactTextString(m) }
func (*FindBranchRequest) ProtoMessage()               {}
func (*FindBranchRequest) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{22} }

func (m *FindBranchRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *FindBranchRequest) GetName() []byte {
	if m != nil {
		return m.Name
	}
	return nil
}

type FindBranchResponse struct {
	Branch *Branch `protobuf:"bytes,1,opt,name=branch" json:"branch,omitempty"`
}

func (m *FindBranchResponse) Reset()                    { *m = FindBranchResponse{} }
func (m *FindBranchResponse) String() string            { return proto.CompactTextString(m) }
func (*FindBranchResponse) ProtoMessage()               {}
func (*FindBranchResponse) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{23} }

func (m *FindBranchResponse) GetBranch() *Branch {
	if m != nil {
		return m.Branch
	}
	return nil
}

type DeleteRefsRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	// The following two fields are mutually exclusive
	ExceptWithPrefix [][]byte `protobuf:"bytes,2,rep,name=except_with_prefix,json=exceptWithPrefix,proto3" json:"except_with_prefix,omitempty"`
	Refs             [][]byte `protobuf:"bytes,3,rep,name=refs,proto3" json:"refs,omitempty"`
}

func (m *DeleteRefsRequest) Reset()                    { *m = DeleteRefsRequest{} }
func (m *DeleteRefsRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteRefsRequest) ProtoMessage()               {}
func (*DeleteRefsRequest) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{24} }

func (m *DeleteRefsRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *DeleteRefsRequest) GetExceptWithPrefix() [][]byte {
	if m != nil {
		return m.ExceptWithPrefix
	}
	return nil
}

func (m *DeleteRefsRequest) GetRefs() [][]byte {
	if m != nil {
		return m.Refs
	}
	return nil
}

type DeleteRefsResponse struct {
	GitError string `protobuf:"bytes,1,opt,name=git_error,json=gitError" json:"git_error,omitempty"`
}

func (m *DeleteRefsResponse) Reset()                    { *m = DeleteRefsResponse{} }
func (m *DeleteRefsResponse) String() string            { return proto.CompactTextString(m) }
func (*DeleteRefsResponse) ProtoMessage()               {}
func (*DeleteRefsResponse) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{25} }

func (m *DeleteRefsResponse) GetGitError() string {
	if m != nil {
		return m.GitError
	}
	return ""
}

type ListBranchNamesContainingCommitRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	CommitId   string      `protobuf:"bytes,2,opt,name=commit_id,json=commitId" json:"commit_id,omitempty"`
	// Limit the number of tag names to be returned
	// If the limit is set to zero, all items will be returned
	Limit uint32 `protobuf:"varint,3,opt,name=limit" json:"limit,omitempty"`
}

func (m *ListBranchNamesContainingCommitRequest) Reset() {
	*m = ListBranchNamesContainingCommitRequest{}
}
func (m *ListBranchNamesContainingCommitRequest) String() string { return proto.CompactTextString(m) }
func (*ListBranchNamesContainingCommitRequest) ProtoMessage()    {}
func (*ListBranchNamesContainingCommitRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor8, []int{26}
}

func (m *ListBranchNamesContainingCommitRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *ListBranchNamesContainingCommitRequest) GetCommitId() string {
	if m != nil {
		return m.CommitId
	}
	return ""
}

func (m *ListBranchNamesContainingCommitRequest) GetLimit() uint32 {
	if m != nil {
		return m.Limit
	}
	return 0
}

type ListBranchNamesContainingCommitResponse struct {
	BranchNames [][]byte `protobuf:"bytes,2,rep,name=branch_names,json=branchNames,proto3" json:"branch_names,omitempty"`
}

func (m *ListBranchNamesContainingCommitResponse) Reset() {
	*m = ListBranchNamesContainingCommitResponse{}
}
func (m *ListBranchNamesContainingCommitResponse) String() string { return proto.CompactTextString(m) }
func (*ListBranchNamesContainingCommitResponse) ProtoMessage()    {}
func (*ListBranchNamesContainingCommitResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor8, []int{27}
}

func (m *ListBranchNamesContainingCommitResponse) GetBranchNames() [][]byte {
	if m != nil {
		return m.BranchNames
	}
	return nil
}

type ListTagNamesContainingCommitRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	CommitId   string      `protobuf:"bytes,2,opt,name=commit_id,json=commitId" json:"commit_id,omitempty"`
	// Limit the number of tag names to be returned
	// If the limit is set to zero, all items will be returned
	Limit uint32 `protobuf:"varint,3,opt,name=limit" json:"limit,omitempty"`
}

func (m *ListTagNamesContainingCommitRequest) Reset()         { *m = ListTagNamesContainingCommitRequest{} }
func (m *ListTagNamesContainingCommitRequest) String() string { return proto.CompactTextString(m) }
func (*ListTagNamesContainingCommitRequest) ProtoMessage()    {}
func (*ListTagNamesContainingCommitRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor8, []int{28}
}

func (m *ListTagNamesContainingCommitRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *ListTagNamesContainingCommitRequest) GetCommitId() string {
	if m != nil {
		return m.CommitId
	}
	return ""
}

func (m *ListTagNamesContainingCommitRequest) GetLimit() uint32 {
	if m != nil {
		return m.Limit
	}
	return 0
}

type ListTagNamesContainingCommitResponse struct {
	TagNames [][]byte `protobuf:"bytes,2,rep,name=tag_names,json=tagNames,proto3" json:"tag_names,omitempty"`
}

func (m *ListTagNamesContainingCommitResponse) Reset()         { *m = ListTagNamesContainingCommitResponse{} }
func (m *ListTagNamesContainingCommitResponse) String() string { return proto.CompactTextString(m) }
func (*ListTagNamesContainingCommitResponse) ProtoMessage()    {}
func (*ListTagNamesContainingCommitResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor8, []int{29}
}

func (m *ListTagNamesContainingCommitResponse) GetTagNames() [][]byte {
	if m != nil {
		return m.TagNames
	}
	return nil
}

type GetTagMessagesRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	TagIds     []string    `protobuf:"bytes,3,rep,name=tag_ids,json=tagIds" json:"tag_ids,omitempty"`
}

func (m *GetTagMessagesRequest) Reset()                    { *m = GetTagMessagesRequest{} }
func (m *GetTagMessagesRequest) String() string            { return proto.CompactTextString(m) }
func (*GetTagMessagesRequest) ProtoMessage()               {}
func (*GetTagMessagesRequest) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{30} }

func (m *GetTagMessagesRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *GetTagMessagesRequest) GetTagIds() []string {
	if m != nil {
		return m.TagIds
	}
	return nil
}

type GetTagMessagesResponse struct {
	Message []byte `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	// Only present for a new tag message
	TagId string `protobuf:"bytes,3,opt,name=tag_id,json=tagId" json:"tag_id,omitempty"`
}

func (m *GetTagMessagesResponse) Reset()                    { *m = GetTagMessagesResponse{} }
func (m *GetTagMessagesResponse) String() string            { return proto.CompactTextString(m) }
func (*GetTagMessagesResponse) ProtoMessage()               {}
func (*GetTagMessagesResponse) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{31} }

func (m *GetTagMessagesResponse) GetMessage() []byte {
	if m != nil {
		return m.Message
	}
	return nil
}

func (m *GetTagMessagesResponse) GetTagId() string {
	if m != nil {
		return m.TagId
	}
	return ""
}

type ListNewCommitsRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	CommitId   string      `protobuf:"bytes,2,opt,name=commit_id,json=commitId" json:"commit_id,omitempty"`
}

func (m *ListNewCommitsRequest) Reset()                    { *m = ListNewCommitsRequest{} }
func (m *ListNewCommitsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListNewCommitsRequest) ProtoMessage()               {}
func (*ListNewCommitsRequest) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{32} }

func (m *ListNewCommitsRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *ListNewCommitsRequest) GetCommitId() string {
	if m != nil {
		return m.CommitId
	}
	return ""
}

type ListNewCommitsResponse struct {
	Commits []*GitCommit `protobuf:"bytes,1,rep,name=commits" json:"commits,omitempty"`
}

func (m *ListNewCommitsResponse) Reset()                    { *m = ListNewCommitsResponse{} }
func (m *ListNewCommitsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListNewCommitsResponse) ProtoMessage()               {}
func (*ListNewCommitsResponse) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{33} }

func (m *ListNewCommitsResponse) GetCommits() []*GitCommit {
	if m != nil {
		return m.Commits
	}
	return nil
}

type FindAllRemoteBranchesRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	RemoteName string      `protobuf:"bytes,2,opt,name=remote_name,json=remoteName" json:"remote_name,omitempty"`
}

func (m *FindAllRemoteBranchesRequest) Reset()                    { *m = FindAllRemoteBranchesRequest{} }
func (m *FindAllRemoteBranchesRequest) String() string            { return proto.CompactTextString(m) }
func (*FindAllRemoteBranchesRequest) ProtoMessage()               {}
func (*FindAllRemoteBranchesRequest) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{34} }

func (m *FindAllRemoteBranchesRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *FindAllRemoteBranchesRequest) GetRemoteName() string {
	if m != nil {
		return m.RemoteName
	}
	return ""
}

type FindAllRemoteBranchesResponse struct {
	Branches []*Branch `protobuf:"bytes,1,rep,name=branches" json:"branches,omitempty"`
}

func (m *FindAllRemoteBranchesResponse) Reset()                    { *m = FindAllRemoteBranchesResponse{} }
func (m *FindAllRemoteBranchesResponse) String() string            { return proto.CompactTextString(m) }
func (*FindAllRemoteBranchesResponse) ProtoMessage()               {}
func (*FindAllRemoteBranchesResponse) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{35} }

func (m *FindAllRemoteBranchesResponse) GetBranches() []*Branch {
	if m != nil {
		return m.Branches
	}
	return nil
}

func init() {
	proto.RegisterType((*FindDefaultBranchNameRequest)(nil), "gitaly.FindDefaultBranchNameRequest")
	proto.RegisterType((*FindDefaultBranchNameResponse)(nil), "gitaly.FindDefaultBranchNameResponse")
	proto.RegisterType((*FindAllBranchNamesRequest)(nil), "gitaly.FindAllBranchNamesRequest")
	proto.RegisterType((*FindAllBranchNamesResponse)(nil), "gitaly.FindAllBranchNamesResponse")
	proto.RegisterType((*FindAllTagNamesRequest)(nil), "gitaly.FindAllTagNamesRequest")
	proto.RegisterType((*FindAllTagNamesResponse)(nil), "gitaly.FindAllTagNamesResponse")
	proto.RegisterType((*FindRefNameRequest)(nil), "gitaly.FindRefNameRequest")
	proto.RegisterType((*FindRefNameResponse)(nil), "gitaly.FindRefNameResponse")
	proto.RegisterType((*FindLocalBranchesRequest)(nil), "gitaly.FindLocalBranchesRequest")
	proto.RegisterType((*FindLocalBranchesResponse)(nil), "gitaly.FindLocalBranchesResponse")
	proto.RegisterType((*FindLocalBranchResponse)(nil), "gitaly.FindLocalBranchResponse")
	proto.RegisterType((*FindLocalBranchCommitAuthor)(nil), "gitaly.FindLocalBranchCommitAuthor")
	proto.RegisterType((*FindAllBranchesRequest)(nil), "gitaly.FindAllBranchesRequest")
	proto.RegisterType((*FindAllBranchesResponse)(nil), "gitaly.FindAllBranchesResponse")
	proto.RegisterType((*FindAllBranchesResponse_Branch)(nil), "gitaly.FindAllBranchesResponse.Branch")
	proto.RegisterType((*FindAllTagsRequest)(nil), "gitaly.FindAllTagsRequest")
	proto.RegisterType((*FindAllTagsResponse)(nil), "gitaly.FindAllTagsResponse")
	proto.RegisterType((*RefExistsRequest)(nil), "gitaly.RefExistsRequest")
	proto.RegisterType((*RefExistsResponse)(nil), "gitaly.RefExistsResponse")
	proto.RegisterType((*CreateBranchRequest)(nil), "gitaly.CreateBranchRequest")
	proto.RegisterType((*CreateBranchResponse)(nil), "gitaly.CreateBranchResponse")
	proto.RegisterType((*DeleteBranchRequest)(nil), "gitaly.DeleteBranchRequest")
	proto.RegisterType((*DeleteBranchResponse)(nil), "gitaly.DeleteBranchResponse")
	proto.RegisterType((*FindBranchRequest)(nil), "gitaly.FindBranchRequest")
	proto.RegisterType((*FindBranchResponse)(nil), "gitaly.FindBranchResponse")
	proto.RegisterType((*DeleteRefsRequest)(nil), "gitaly.DeleteRefsRequest")
	proto.RegisterType((*DeleteRefsResponse)(nil), "gitaly.DeleteRefsResponse")
	proto.RegisterType((*ListBranchNamesContainingCommitRequest)(nil), "gitaly.ListBranchNamesContainingCommitRequest")
	proto.RegisterType((*ListBranchNamesContainingCommitResponse)(nil), "gitaly.ListBranchNamesContainingCommitResponse")
	proto.RegisterType((*ListTagNamesContainingCommitRequest)(nil), "gitaly.ListTagNamesContainingCommitRequest")
	proto.RegisterType((*ListTagNamesContainingCommitResponse)(nil), "gitaly.ListTagNamesContainingCommitResponse")
	proto.RegisterType((*GetTagMessagesRequest)(nil), "gitaly.GetTagMessagesRequest")
	proto.RegisterType((*GetTagMessagesResponse)(nil), "gitaly.GetTagMessagesResponse")
	proto.RegisterType((*ListNewCommitsRequest)(nil), "gitaly.ListNewCommitsRequest")
	proto.RegisterType((*ListNewCommitsResponse)(nil), "gitaly.ListNewCommitsResponse")
	proto.RegisterType((*FindAllRemoteBranchesRequest)(nil), "gitaly.FindAllRemoteBranchesRequest")
	proto.RegisterType((*FindAllRemoteBranchesResponse)(nil), "gitaly.FindAllRemoteBranchesResponse")
	proto.RegisterEnum("gitaly.FindLocalBranchesRequest_SortBy", FindLocalBranchesRequest_SortBy_name, FindLocalBranchesRequest_SortBy_value)
	proto.RegisterEnum("gitaly.CreateBranchResponse_Status", CreateBranchResponse_Status_name, CreateBranchResponse_Status_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for RefService service

type RefServiceClient interface {
	FindDefaultBranchName(ctx context.Context, in *FindDefaultBranchNameRequest, opts ...grpc.CallOption) (*FindDefaultBranchNameResponse, error)
	FindAllBranchNames(ctx context.Context, in *FindAllBranchNamesRequest, opts ...grpc.CallOption) (RefService_FindAllBranchNamesClient, error)
	FindAllTagNames(ctx context.Context, in *FindAllTagNamesRequest, opts ...grpc.CallOption) (RefService_FindAllTagNamesClient, error)
	// Find a Ref matching the given constraints. Response may be empty.
	FindRefName(ctx context.Context, in *FindRefNameRequest, opts ...grpc.CallOption) (*FindRefNameResponse, error)
	// Return a stream so we can divide the response in chunks of branches
	FindLocalBranches(ctx context.Context, in *FindLocalBranchesRequest, opts ...grpc.CallOption) (RefService_FindLocalBranchesClient, error)
	FindAllBranches(ctx context.Context, in *FindAllBranchesRequest, opts ...grpc.CallOption) (RefService_FindAllBranchesClient, error)
	FindAllTags(ctx context.Context, in *FindAllTagsRequest, opts ...grpc.CallOption) (RefService_FindAllTagsClient, error)
	FindAllRemoteBranches(ctx context.Context, in *FindAllRemoteBranchesRequest, opts ...grpc.CallOption) (RefService_FindAllRemoteBranchesClient, error)
	RefExists(ctx context.Context, in *RefExistsRequest, opts ...grpc.CallOption) (*RefExistsResponse, error)
	CreateBranch(ctx context.Context, in *CreateBranchRequest, opts ...grpc.CallOption) (*CreateBranchResponse, error)
	DeleteBranch(ctx context.Context, in *DeleteBranchRequest, opts ...grpc.CallOption) (*DeleteBranchResponse, error)
	FindBranch(ctx context.Context, in *FindBranchRequest, opts ...grpc.CallOption) (*FindBranchResponse, error)
	DeleteRefs(ctx context.Context, in *DeleteRefsRequest, opts ...grpc.CallOption) (*DeleteRefsResponse, error)
	ListBranchNamesContainingCommit(ctx context.Context, in *ListBranchNamesContainingCommitRequest, opts ...grpc.CallOption) (RefService_ListBranchNamesContainingCommitClient, error)
	ListTagNamesContainingCommit(ctx context.Context, in *ListTagNamesContainingCommitRequest, opts ...grpc.CallOption) (RefService_ListTagNamesContainingCommitClient, error)
	GetTagMessages(ctx context.Context, in *GetTagMessagesRequest, opts ...grpc.CallOption) (RefService_GetTagMessagesClient, error)
	// Returns commits that are only reachable from the ref passed
	ListNewCommits(ctx context.Context, in *ListNewCommitsRequest, opts ...grpc.CallOption) (RefService_ListNewCommitsClient, error)
}

type refServiceClient struct {
	cc *grpc.ClientConn
}

func NewRefServiceClient(cc *grpc.ClientConn) RefServiceClient {
	return &refServiceClient{cc}
}

func (c *refServiceClient) FindDefaultBranchName(ctx context.Context, in *FindDefaultBranchNameRequest, opts ...grpc.CallOption) (*FindDefaultBranchNameResponse, error) {
	out := new(FindDefaultBranchNameResponse)
	err := grpc.Invoke(ctx, "/gitaly.RefService/FindDefaultBranchName", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *refServiceClient) FindAllBranchNames(ctx context.Context, in *FindAllBranchNamesRequest, opts ...grpc.CallOption) (RefService_FindAllBranchNamesClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_RefService_serviceDesc.Streams[0], c.cc, "/gitaly.RefService/FindAllBranchNames", opts...)
	if err != nil {
		return nil, err
	}
	x := &refServiceFindAllBranchNamesClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type RefService_FindAllBranchNamesClient interface {
	Recv() (*FindAllBranchNamesResponse, error)
	grpc.ClientStream
}

type refServiceFindAllBranchNamesClient struct {
	grpc.ClientStream
}

func (x *refServiceFindAllBranchNamesClient) Recv() (*FindAllBranchNamesResponse, error) {
	m := new(FindAllBranchNamesResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *refServiceClient) FindAllTagNames(ctx context.Context, in *FindAllTagNamesRequest, opts ...grpc.CallOption) (RefService_FindAllTagNamesClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_RefService_serviceDesc.Streams[1], c.cc, "/gitaly.RefService/FindAllTagNames", opts...)
	if err != nil {
		return nil, err
	}
	x := &refServiceFindAllTagNamesClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type RefService_FindAllTagNamesClient interface {
	Recv() (*FindAllTagNamesResponse, error)
	grpc.ClientStream
}

type refServiceFindAllTagNamesClient struct {
	grpc.ClientStream
}

func (x *refServiceFindAllTagNamesClient) Recv() (*FindAllTagNamesResponse, error) {
	m := new(FindAllTagNamesResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *refServiceClient) FindRefName(ctx context.Context, in *FindRefNameRequest, opts ...grpc.CallOption) (*FindRefNameResponse, error) {
	out := new(FindRefNameResponse)
	err := grpc.Invoke(ctx, "/gitaly.RefService/FindRefName", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *refServiceClient) FindLocalBranches(ctx context.Context, in *FindLocalBranchesRequest, opts ...grpc.CallOption) (RefService_FindLocalBranchesClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_RefService_serviceDesc.Streams[2], c.cc, "/gitaly.RefService/FindLocalBranches", opts...)
	if err != nil {
		return nil, err
	}
	x := &refServiceFindLocalBranchesClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type RefService_FindLocalBranchesClient interface {
	Recv() (*FindLocalBranchesResponse, error)
	grpc.ClientStream
}

type refServiceFindLocalBranchesClient struct {
	grpc.ClientStream
}

func (x *refServiceFindLocalBranchesClient) Recv() (*FindLocalBranchesResponse, error) {
	m := new(FindLocalBranchesResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *refServiceClient) FindAllBranches(ctx context.Context, in *FindAllBranchesRequest, opts ...grpc.CallOption) (RefService_FindAllBranchesClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_RefService_serviceDesc.Streams[3], c.cc, "/gitaly.RefService/FindAllBranches", opts...)
	if err != nil {
		return nil, err
	}
	x := &refServiceFindAllBranchesClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type RefService_FindAllBranchesClient interface {
	Recv() (*FindAllBranchesResponse, error)
	grpc.ClientStream
}

type refServiceFindAllBranchesClient struct {
	grpc.ClientStream
}

func (x *refServiceFindAllBranchesClient) Recv() (*FindAllBranchesResponse, error) {
	m := new(FindAllBranchesResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *refServiceClient) FindAllTags(ctx context.Context, in *FindAllTagsRequest, opts ...grpc.CallOption) (RefService_FindAllTagsClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_RefService_serviceDesc.Streams[4], c.cc, "/gitaly.RefService/FindAllTags", opts...)
	if err != nil {
		return nil, err
	}
	x := &refServiceFindAllTagsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type RefService_FindAllTagsClient interface {
	Recv() (*FindAllTagsResponse, error)
	grpc.ClientStream
}

type refServiceFindAllTagsClient struct {
	grpc.ClientStream
}

func (x *refServiceFindAllTagsClient) Recv() (*FindAllTagsResponse, error) {
	m := new(FindAllTagsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *refServiceClient) FindAllRemoteBranches(ctx context.Context, in *FindAllRemoteBranchesRequest, opts ...grpc.CallOption) (RefService_FindAllRemoteBranchesClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_RefService_serviceDesc.Streams[5], c.cc, "/gitaly.RefService/FindAllRemoteBranches", opts...)
	if err != nil {
		return nil, err
	}
	x := &refServiceFindAllRemoteBranchesClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type RefService_FindAllRemoteBranchesClient interface {
	Recv() (*FindAllRemoteBranchesResponse, error)
	grpc.ClientStream
}

type refServiceFindAllRemoteBranchesClient struct {
	grpc.ClientStream
}

func (x *refServiceFindAllRemoteBranchesClient) Recv() (*FindAllRemoteBranchesResponse, error) {
	m := new(FindAllRemoteBranchesResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *refServiceClient) RefExists(ctx context.Context, in *RefExistsRequest, opts ...grpc.CallOption) (*RefExistsResponse, error) {
	out := new(RefExistsResponse)
	err := grpc.Invoke(ctx, "/gitaly.RefService/RefExists", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *refServiceClient) CreateBranch(ctx context.Context, in *CreateBranchRequest, opts ...grpc.CallOption) (*CreateBranchResponse, error) {
	out := new(CreateBranchResponse)
	err := grpc.Invoke(ctx, "/gitaly.RefService/CreateBranch", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *refServiceClient) DeleteBranch(ctx context.Context, in *DeleteBranchRequest, opts ...grpc.CallOption) (*DeleteBranchResponse, error) {
	out := new(DeleteBranchResponse)
	err := grpc.Invoke(ctx, "/gitaly.RefService/DeleteBranch", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *refServiceClient) FindBranch(ctx context.Context, in *FindBranchRequest, opts ...grpc.CallOption) (*FindBranchResponse, error) {
	out := new(FindBranchResponse)
	err := grpc.Invoke(ctx, "/gitaly.RefService/FindBranch", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *refServiceClient) DeleteRefs(ctx context.Context, in *DeleteRefsRequest, opts ...grpc.CallOption) (*DeleteRefsResponse, error) {
	out := new(DeleteRefsResponse)
	err := grpc.Invoke(ctx, "/gitaly.RefService/DeleteRefs", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *refServiceClient) ListBranchNamesContainingCommit(ctx context.Context, in *ListBranchNamesContainingCommitRequest, opts ...grpc.CallOption) (RefService_ListBranchNamesContainingCommitClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_RefService_serviceDesc.Streams[6], c.cc, "/gitaly.RefService/ListBranchNamesContainingCommit", opts...)
	if err != nil {
		return nil, err
	}
	x := &refServiceListBranchNamesContainingCommitClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type RefService_ListBranchNamesContainingCommitClient interface {
	Recv() (*ListBranchNamesContainingCommitResponse, error)
	grpc.ClientStream
}

type refServiceListBranchNamesContainingCommitClient struct {
	grpc.ClientStream
}

func (x *refServiceListBranchNamesContainingCommitClient) Recv() (*ListBranchNamesContainingCommitResponse, error) {
	m := new(ListBranchNamesContainingCommitResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *refServiceClient) ListTagNamesContainingCommit(ctx context.Context, in *ListTagNamesContainingCommitRequest, opts ...grpc.CallOption) (RefService_ListTagNamesContainingCommitClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_RefService_serviceDesc.Streams[7], c.cc, "/gitaly.RefService/ListTagNamesContainingCommit", opts...)
	if err != nil {
		return nil, err
	}
	x := &refServiceListTagNamesContainingCommitClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type RefService_ListTagNamesContainingCommitClient interface {
	Recv() (*ListTagNamesContainingCommitResponse, error)
	grpc.ClientStream
}

type refServiceListTagNamesContainingCommitClient struct {
	grpc.ClientStream
}

func (x *refServiceListTagNamesContainingCommitClient) Recv() (*ListTagNamesContainingCommitResponse, error) {
	m := new(ListTagNamesContainingCommitResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *refServiceClient) GetTagMessages(ctx context.Context, in *GetTagMessagesRequest, opts ...grpc.CallOption) (RefService_GetTagMessagesClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_RefService_serviceDesc.Streams[8], c.cc, "/gitaly.RefService/GetTagMessages", opts...)
	if err != nil {
		return nil, err
	}
	x := &refServiceGetTagMessagesClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type RefService_GetTagMessagesClient interface {
	Recv() (*GetTagMessagesResponse, error)
	grpc.ClientStream
}

type refServiceGetTagMessagesClient struct {
	grpc.ClientStream
}

func (x *refServiceGetTagMessagesClient) Recv() (*GetTagMessagesResponse, error) {
	m := new(GetTagMessagesResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *refServiceClient) ListNewCommits(ctx context.Context, in *ListNewCommitsRequest, opts ...grpc.CallOption) (RefService_ListNewCommitsClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_RefService_serviceDesc.Streams[9], c.cc, "/gitaly.RefService/ListNewCommits", opts...)
	if err != nil {
		return nil, err
	}
	x := &refServiceListNewCommitsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type RefService_ListNewCommitsClient interface {
	Recv() (*ListNewCommitsResponse, error)
	grpc.ClientStream
}

type refServiceListNewCommitsClient struct {
	grpc.ClientStream
}

func (x *refServiceListNewCommitsClient) Recv() (*ListNewCommitsResponse, error) {
	m := new(ListNewCommitsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// Server API for RefService service

type RefServiceServer interface {
	FindDefaultBranchName(context.Context, *FindDefaultBranchNameRequest) (*FindDefaultBranchNameResponse, error)
	FindAllBranchNames(*FindAllBranchNamesRequest, RefService_FindAllBranchNamesServer) error
	FindAllTagNames(*FindAllTagNamesRequest, RefService_FindAllTagNamesServer) error
	// Find a Ref matching the given constraints. Response may be empty.
	FindRefName(context.Context, *FindRefNameRequest) (*FindRefNameResponse, error)
	// Return a stream so we can divide the response in chunks of branches
	FindLocalBranches(*FindLocalBranchesRequest, RefService_FindLocalBranchesServer) error
	FindAllBranches(*FindAllBranchesRequest, RefService_FindAllBranchesServer) error
	FindAllTags(*FindAllTagsRequest, RefService_FindAllTagsServer) error
	FindAllRemoteBranches(*FindAllRemoteBranchesRequest, RefService_FindAllRemoteBranchesServer) error
	RefExists(context.Context, *RefExistsRequest) (*RefExistsResponse, error)
	CreateBranch(context.Context, *CreateBranchRequest) (*CreateBranchResponse, error)
	DeleteBranch(context.Context, *DeleteBranchRequest) (*DeleteBranchResponse, error)
	FindBranch(context.Context, *FindBranchRequest) (*FindBranchResponse, error)
	DeleteRefs(context.Context, *DeleteRefsRequest) (*DeleteRefsResponse, error)
	ListBranchNamesContainingCommit(*ListBranchNamesContainingCommitRequest, RefService_ListBranchNamesContainingCommitServer) error
	ListTagNamesContainingCommit(*ListTagNamesContainingCommitRequest, RefService_ListTagNamesContainingCommitServer) error
	GetTagMessages(*GetTagMessagesRequest, RefService_GetTagMessagesServer) error
	// Returns commits that are only reachable from the ref passed
	ListNewCommits(*ListNewCommitsRequest, RefService_ListNewCommitsServer) error
}

func RegisterRefServiceServer(s *grpc.Server, srv RefServiceServer) {
	s.RegisterService(&_RefService_serviceDesc, srv)
}

func _RefService_FindDefaultBranchName_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FindDefaultBranchNameRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RefServiceServer).FindDefaultBranchName(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RefService/FindDefaultBranchName",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RefServiceServer).FindDefaultBranchName(ctx, req.(*FindDefaultBranchNameRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RefService_FindAllBranchNames_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(FindAllBranchNamesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RefServiceServer).FindAllBranchNames(m, &refServiceFindAllBranchNamesServer{stream})
}

type RefService_FindAllBranchNamesServer interface {
	Send(*FindAllBranchNamesResponse) error
	grpc.ServerStream
}

type refServiceFindAllBranchNamesServer struct {
	grpc.ServerStream
}

func (x *refServiceFindAllBranchNamesServer) Send(m *FindAllBranchNamesResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _RefService_FindAllTagNames_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(FindAllTagNamesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RefServiceServer).FindAllTagNames(m, &refServiceFindAllTagNamesServer{stream})
}

type RefService_FindAllTagNamesServer interface {
	Send(*FindAllTagNamesResponse) error
	grpc.ServerStream
}

type refServiceFindAllTagNamesServer struct {
	grpc.ServerStream
}

func (x *refServiceFindAllTagNamesServer) Send(m *FindAllTagNamesResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _RefService_FindRefName_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FindRefNameRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RefServiceServer).FindRefName(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RefService/FindRefName",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RefServiceServer).FindRefName(ctx, req.(*FindRefNameRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RefService_FindLocalBranches_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(FindLocalBranchesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RefServiceServer).FindLocalBranches(m, &refServiceFindLocalBranchesServer{stream})
}

type RefService_FindLocalBranchesServer interface {
	Send(*FindLocalBranchesResponse) error
	grpc.ServerStream
}

type refServiceFindLocalBranchesServer struct {
	grpc.ServerStream
}

func (x *refServiceFindLocalBranchesServer) Send(m *FindLocalBranchesResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _RefService_FindAllBranches_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(FindAllBranchesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RefServiceServer).FindAllBranches(m, &refServiceFindAllBranchesServer{stream})
}

type RefService_FindAllBranchesServer interface {
	Send(*FindAllBranchesResponse) error
	grpc.ServerStream
}

type refServiceFindAllBranchesServer struct {
	grpc.ServerStream
}

func (x *refServiceFindAllBranchesServer) Send(m *FindAllBranchesResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _RefService_FindAllTags_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(FindAllTagsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RefServiceServer).FindAllTags(m, &refServiceFindAllTagsServer{stream})
}

type RefService_FindAllTagsServer interface {
	Send(*FindAllTagsResponse) error
	grpc.ServerStream
}

type refServiceFindAllTagsServer struct {
	grpc.ServerStream
}

func (x *refServiceFindAllTagsServer) Send(m *FindAllTagsResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _RefService_FindAllRemoteBranches_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(FindAllRemoteBranchesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RefServiceServer).FindAllRemoteBranches(m, &refServiceFindAllRemoteBranchesServer{stream})
}

type RefService_FindAllRemoteBranchesServer interface {
	Send(*FindAllRemoteBranchesResponse) error
	grpc.ServerStream
}

type refServiceFindAllRemoteBranchesServer struct {
	grpc.ServerStream
}

func (x *refServiceFindAllRemoteBranchesServer) Send(m *FindAllRemoteBranchesResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _RefService_RefExists_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RefExistsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RefServiceServer).RefExists(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RefService/RefExists",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RefServiceServer).RefExists(ctx, req.(*RefExistsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RefService_CreateBranch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateBranchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RefServiceServer).CreateBranch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RefService/CreateBranch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RefServiceServer).CreateBranch(ctx, req.(*CreateBranchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RefService_DeleteBranch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBranchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RefServiceServer).DeleteBranch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RefService/DeleteBranch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RefServiceServer).DeleteBranch(ctx, req.(*DeleteBranchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RefService_FindBranch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FindBranchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RefServiceServer).FindBranch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RefService/FindBranch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RefServiceServer).FindBranch(ctx, req.(*FindBranchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RefService_DeleteRefs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRefsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RefServiceServer).DeleteRefs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RefService/DeleteRefs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RefServiceServer).DeleteRefs(ctx, req.(*DeleteRefsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RefService_ListBranchNamesContainingCommit_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ListBranchNamesContainingCommitRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RefServiceServer).ListBranchNamesContainingCommit(m, &refServiceListBranchNamesContainingCommitServer{stream})
}

type RefService_ListBranchNamesContainingCommitServer interface {
	Send(*ListBranchNamesContainingCommitResponse) error
	grpc.ServerStream
}

type refServiceListBranchNamesContainingCommitServer struct {
	grpc.ServerStream
}

func (x *refServiceListBranchNamesContainingCommitServer) Send(m *ListBranchNamesContainingCommitResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _RefService_ListTagNamesContainingCommit_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ListTagNamesContainingCommitRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RefServiceServer).ListTagNamesContainingCommit(m, &refServiceListTagNamesContainingCommitServer{stream})
}

type RefService_ListTagNamesContainingCommitServer interface {
	Send(*ListTagNamesContainingCommitResponse) error
	grpc.ServerStream
}

type refServiceListTagNamesContainingCommitServer struct {
	grpc.ServerStream
}

func (x *refServiceListTagNamesContainingCommitServer) Send(m *ListTagNamesContainingCommitResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _RefService_GetTagMessages_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetTagMessagesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RefServiceServer).GetTagMessages(m, &refServiceGetTagMessagesServer{stream})
}

type RefService_GetTagMessagesServer interface {
	Send(*GetTagMessagesResponse) error
	grpc.ServerStream
}

type refServiceGetTagMessagesServer struct {
	grpc.ServerStream
}

func (x *refServiceGetTagMessagesServer) Send(m *GetTagMessagesResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _RefService_ListNewCommits_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ListNewCommitsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RefServiceServer).ListNewCommits(m, &refServiceListNewCommitsServer{stream})
}

type RefService_ListNewCommitsServer interface {
	Send(*ListNewCommitsResponse) error
	grpc.ServerStream
}

type refServiceListNewCommitsServer struct {
	grpc.ServerStream
}

func (x *refServiceListNewCommitsServer) Send(m *ListNewCommitsResponse) error {
	return x.ServerStream.SendMsg(m)
}

var _RefService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "gitaly.RefService",
	HandlerType: (*RefServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "FindDefaultBranchName",
			Handler:    _RefService_FindDefaultBranchName_Handler,
		},
		{
			MethodName: "FindRefName",
			Handler:    _RefService_FindRefName_Handler,
		},
		{
			MethodName: "RefExists",
			Handler:    _RefService_RefExists_Handler,
		},
		{
			MethodName: "CreateBranch",
			Handler:    _RefService_CreateBranch_Handler,
		},
		{
			MethodName: "DeleteBranch",
			Handler:    _RefService_DeleteBranch_Handler,
		},
		{
			MethodName: "FindBranch",
			Handler:    _RefService_FindBranch_Handler,
		},
		{
			MethodName: "DeleteRefs",
			Handler:    _RefService_DeleteRefs_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "FindAllBranchNames",
			Handler:       _RefService_FindAllBranchNames_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "FindAllTagNames",
			Handler:       _RefService_FindAllTagNames_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "FindLocalBranches",
			Handler:       _RefService_FindLocalBranches_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "FindAllBranches",
			Handler:       _RefService_FindAllBranches_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "FindAllTags",
			Handler:       _RefService_FindAllTags_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "FindAllRemoteBranches",
			Handler:       _RefService_FindAllRemoteBranches_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "ListBranchNamesContainingCommit",
			Handler:       _RefService_ListBranchNamesContainingCommit_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "ListTagNamesContainingCommit",
			Handler:       _RefService_ListTagNamesContainingCommit_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GetTagMessages",
			Handler:       _RefService_GetTagMessages_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "ListNewCommits",
			Handler:       _RefService_ListNewCommits_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "ref.proto",
}

func init() { proto.RegisterFile("ref.proto", fileDescriptor8) }

var fileDescriptor8 = []byte{
	// 1461 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x57, 0x5f, 0x6f, 0x1a, 0xc7,
	0x16, 0xf7, 0x62, 0x1b, 0xc3, 0x81, 0xe0, 0xf5, 0xc4, 0x76, 0xc8, 0x3a, 0x09, 0xce, 0xe4, 0xff,
	0x4d, 0x84, 0xef, 0x25, 0xba, 0x7d, 0x69, 0x1f, 0x8a, 0x6d, 0x9a, 0x90, 0x38, 0xd8, 0x1a, 0x68,
	0x9a, 0xaa, 0xad, 0x56, 0x6b, 0x18, 0x96, 0xad, 0x80, 0xa5, 0xbb, 0x43, 0x12, 0x3f, 0xa4, 0x52,
	0x5f, 0x2a, 0x55, 0xad, 0xd4, 0xb7, 0x7e, 0x84, 0x7e, 0x95, 0x3e, 0xf4, 0x4b, 0x55, 0x3b, 0x33,
	0xfb, 0x0f, 0x16, 0x6c, 0x95, 0x5a, 0x7d, 0x82, 0x3d, 0x73, 0xce, 0xef, 0xfc, 0x9d, 0x73, 0xce,
	0x40, 0xd6, 0xa1, 0xdd, 0xf2, 0xc8, 0xb1, 0x99, 0x8d, 0xd2, 0xa6, 0xc5, 0x8c, 0xfe, 0x99, 0x96,
	0x77, 0x7b, 0x86, 0x43, 0x3b, 0x82, 0xaa, 0x95, 0x4c, 0xdb, 0x36, 0xfb, 0x74, 0x8f, 0x7f, 0x9d,
	0x8e, 0xbb, 0x7b, 0xcc, 0x1a, 0x50, 0x97, 0x19, 0x83, 0x91, 0x60, 0xc0, 0x04, 0x6e, 0x7c, 0x66,
	0x0d, 0x3b, 0x87, 0xb4, 0x6b, 0x8c, 0xfb, 0x6c, 0xdf, 0x31, 0x86, 0xed, 0x5e, 0xc3, 0x18, 0x50,
	0x42, 0xbf, 0x1b, 0x53, 0x97, 0xa1, 0x0a, 0x80, 0x43, 0x47, 0xb6, 0x6b, 0x31, 0xdb, 0x39, 0x2b,
	0x2a, 0xbb, 0xca, 0xc3, 0x5c, 0x05, 0x95, 0x85, 0xae, 0x32, 0x09, 0x4e, 0x48, 0x84, 0x0b, 0x3f,
	0x85, 0x9b, 0x33, 0x30, 0xdd, 0x91, 0x3d, 0x74, 0x29, 0x42, 0xb0, 0x32, 0x34, 0x06, 0x94, 0xc3,
	0xe5, 0x09, 0xff, 0x8f, 0x8f, 0xe1, 0xba, 0x27, 0x54, 0xed, 0xf7, 0x43, 0x01, 0x77, 0x11, 0x2b,
	0x2a, 0xa0, 0x25, 0x01, 0x4a, 0x13, 0x36, 0x61, 0xd5, 0x53, 0xeb, 0x16, 0x95, 0xdd, 0xe5, 0x87,
	0x79, 0x22, 0x3e, 0xf0, 0x11, 0x6c, 0x4b, 0x99, 0x96, 0x61, 0x2e, 0x6c, 0xc1, 0x1e, 0x5c, 0x9b,
	0x42, 0x9b, 0xab, 0xfe, 0x03, 0x20, 0x4f, 0x80, 0xd0, 0xee, 0x82, 0x29, 0x40, 0x3b, 0x90, 0x6d,
	0xdb, 0x83, 0x81, 0xc5, 0x74, 0xab, 0x53, 0x4c, 0xed, 0x2a, 0x0f, 0xb3, 0x24, 0x23, 0x08, 0xf5,
	0x0e, 0xda, 0x86, 0xf4, 0xc8, 0xa1, 0x5d, 0xeb, 0x7d, 0x71, 0x99, 0x27, 0x40, 0x7e, 0xe1, 0x47,
	0x70, 0x35, 0xa6, 0x7e, 0x4e, 0xb6, 0xfe, 0x50, 0xa0, 0xe8, 0xf1, 0x1e, 0xd9, 0x6d, 0x43, 0xc6,
	0x77, 0xa1, 0x58, 0xa1, 0x4f, 0x61, 0xcd, 0xb5, 0x1d, 0xa6, 0x9f, 0x9e, 0x71, 0x73, 0x0b, 0x95,
	0x07, 0xbe, 0xc0, 0x2c, 0x35, 0xe5, 0xa6, 0xed, 0xb0, 0xfd, 0x33, 0x92, 0x76, 0xf9, 0x2f, 0xfe,
	0x3f, 0xa4, 0x05, 0x05, 0x65, 0x60, 0xa5, 0x51, 0x7d, 0x55, 0x53, 0x97, 0xd0, 0x3a, 0xe4, 0x3e,
	0x3f, 0x39, 0xac, 0xb6, 0x6a, 0x87, 0x7a, 0xb5, 0x79, 0xa0, 0x2a, 0x48, 0x85, 0xbc, 0x4f, 0x38,
	0xac, 0x35, 0x0f, 0xd4, 0x14, 0x7e, 0x23, 0xea, 0x6e, 0x42, 0x83, 0x74, 0xfd, 0x63, 0xc8, 0x9c,
	0x4a, 0x1a, 0xcf, 0x54, 0xae, 0x52, 0x9a, 0x61, 0x96, 0x2f, 0x42, 0x02, 0x01, 0xfc, 0x73, 0x4a,
	0xe4, 0x3f, 0x81, 0x2b, 0x29, 0xa6, 0xf3, 0x73, 0x76, 0x0f, 0x0a, 0xf2, 0xd0, 0x1d, 0x9f, 0x7e,
	0x4b, 0xdb, 0x4c, 0xe6, 0xee, 0x8a, 0xa0, 0x36, 0x05, 0x11, 0x3d, 0x07, 0x49, 0xd0, 0x8d, 0x31,
	0xeb, 0xd9, 0x4e, 0x71, 0x85, 0x47, 0xff, 0xce, 0x0c, 0xab, 0x0f, 0x38, 0x6f, 0x95, 0xb3, 0x92,
	0x7c, 0x3b, 0xf2, 0x85, 0x1a, 0xa0, 0x4a, 0x24, 0xf1, 0xc3, 0xa8, 0x53, 0x5c, 0xbd, 0x38, 0xd8,
	0xba, 0x90, 0x3a, 0xf0, 0x65, 0xf1, 0x3b, 0xd8, 0x99, 0xc3, 0x9f, 0x18, 0x90, 0x4d, 0x58, 0xa5,
	0x03, 0xc3, 0xea, 0xf3, 0x60, 0xe4, 0x89, 0xf8, 0x40, 0x65, 0x58, 0xe9, 0x18, 0x8c, 0x72, 0xff,
	0x73, 0x15, 0xad, 0x2c, 0x3a, 0x5c, 0xd9, 0xef, 0x70, 0xe5, 0x96, 0xdf, 0xe1, 0x08, 0xe7, 0xc3,
	0xbf, 0x29, 0xc1, 0xa5, 0xfe, 0x27, 0x0a, 0xb5, 0x04, 0xb9, 0x01, 0x75, 0x4c, 0xda, 0xd1, 0xed,
	0x61, 0x5f, 0x14, 0x6b, 0x86, 0x80, 0x20, 0x1d, 0x0f, 0xfb, 0x67, 0xe8, 0x01, 0xac, 0x4b, 0x86,
	0xa0, 0x74, 0x96, 0xf9, 0x25, 0x2f, 0x08, 0xb2, 0x6f, 0x04, 0xfe, 0x5d, 0x09, 0xfa, 0xc3, 0x54,
	0xe1, 0xed, 0x4f, 0x15, 0xde, 0xfd, 0x68, 0xd4, 0x13, 0x44, 0xca, 0xb2, 0xc2, 0x02, 0x39, 0xed,
	0x19, 0xa4, 0x05, 0x2d, 0x31, 0xb8, 0x8f, 0x20, 0xcd, 0x0c, 0xc7, 0xa4, 0x8c, 0xbb, 0x90, 0xab,
	0x6c, 0xf8, 0xf8, 0xcf, 0xfc, 0xac, 0x11, 0xc9, 0x80, 0x9f, 0x8b, 0xb6, 0x24, 0xfa, 0xd8, 0x42,
	0x1d, 0xf1, 0x23, 0xd1, 0x61, 0x02, 0x24, 0xe9, 0x6d, 0x09, 0x56, 0x98, 0x61, 0xfa, 0x9e, 0xe6,
	0x7c, 0x90, 0x96, 0x61, 0x12, 0x7e, 0x80, 0xdf, 0x80, 0x4a, 0x68, 0xb7, 0xf6, 0xde, 0x72, 0xd9,
	0x42, 0xc9, 0x53, 0x61, 0xd9, 0xa1, 0x5d, 0x59, 0x4f, 0xde, 0x5f, 0xfc, 0x08, 0x36, 0x22, 0xc8,
	0x61, 0x77, 0x7e, 0x6b, 0xf4, 0xc7, 0x22, 0x60, 0x19, 0x22, 0x3e, 0xf0, 0xf7, 0x70, 0xf5, 0xc0,
	0xa1, 0x06, 0xa3, 0xfe, 0x5d, 0xfe, 0xfb, 0x76, 0xf8, 0x09, 0x49, 0x45, 0x12, 0x52, 0x82, 0x9c,
	0xcb, 0x0c, 0x87, 0xe9, 0x23, 0xdb, 0x1a, 0xfa, 0xd7, 0x1b, 0x38, 0xe9, 0xc4, 0xa3, 0xe0, 0x3f,
	0x15, 0xd8, 0x8c, 0x1b, 0x10, 0x74, 0xa9, 0xb4, 0xcb, 0x0c, 0x36, 0x76, 0xb9, 0xf6, 0x42, 0x78,
	0x41, 0x93, 0xb8, 0xcb, 0x4d, 0xce, 0x4a, 0xa4, 0x08, 0xba, 0x0f, 0x69, 0x51, 0x31, 0xb2, 0x0e,
	0x0a, 0xbe, 0xb0, 0x14, 0x93, 0xa7, 0xb8, 0x01, 0x69, 0x21, 0x89, 0xd2, 0x90, 0x3a, 0x7e, 0xa9,
	0x2e, 0xa1, 0x02, 0x40, 0x8d, 0x10, 0xbd, 0xf6, 0xa6, 0xde, 0x6c, 0x35, 0x55, 0xc5, 0x6b, 0xb6,
	0xde, 0x77, 0xbd, 0xf1, 0xba, 0x7a, 0x54, 0x3f, 0x54, 0x53, 0x68, 0x07, 0xae, 0x45, 0x08, 0x7a,
	0xb3, 0x55, 0x25, 0x2d, 0xfd, 0xe4, 0xb8, 0xde, 0x68, 0xa9, 0xcb, 0xf8, 0x1b, 0xb8, 0x7a, 0x48,
	0xfb, 0xf4, 0x92, 0xa2, 0x89, 0xb7, 0x61, 0x33, 0x0e, 0x2f, 0xbc, 0xc7, 0x5f, 0xc1, 0x86, 0x57,
	0x81, 0x97, 0xa3, 0xf4, 0x13, 0x71, 0x51, 0x26, 0xd2, 0x13, 0x46, 0x58, 0x99, 0x1b, 0xe1, 0x9f,
	0x14, 0xd8, 0x10, 0x36, 0x13, 0xda, 0x5d, 0xa8, 0xcc, 0x9f, 0x00, 0xa2, 0xef, 0xdb, 0x74, 0xc4,
	0xf4, 0x77, 0x16, 0xeb, 0xe9, 0x72, 0xd8, 0xa7, 0x78, 0x17, 0x52, 0xc5, 0xc9, 0x17, 0x16, 0xeb,
	0x9d, 0x70, 0xba, 0xe7, 0x89, 0x43, 0xbb, 0x7e, 0x97, 0xe2, 0xff, 0xf1, 0xff, 0x00, 0x45, 0x4d,
	0x91, 0x9e, 0xec, 0x40, 0xd6, 0xb4, 0x98, 0x4e, 0x1d, 0xc7, 0x76, 0xb8, 0x29, 0x59, 0x92, 0x31,
	0x2d, 0x56, 0xf3, 0xbe, 0xf1, 0xaf, 0x0a, 0xdc, 0x3f, 0xb2, 0xdc, 0xc8, 0xbe, 0xe7, 0x1e, 0xd8,
	0x43, 0x66, 0x58, 0x43, 0x6b, 0x68, 0xca, 0x8e, 0x72, 0x59, 0x1b, 0xcd, 0x26, 0xac, 0xf6, 0xad,
	0x81, 0x25, 0x6e, 0xcd, 0x15, 0x22, 0x3e, 0x30, 0x81, 0x07, 0xe7, 0x1a, 0x24, 0x3d, 0xbb, 0x0d,
	0x79, 0x91, 0x05, 0x5d, 0xac, 0x65, 0x22, 0x56, 0xb9, 0xd3, 0x50, 0xf4, 0xc5, 0x4a, 0x46, 0x51,
	0x53, 0xf8, 0x17, 0x05, 0xee, 0x78, 0xa0, 0xfe, 0x46, 0xf7, 0x2f, 0xbb, 0x58, 0x87, 0xbb, 0xf3,
	0xad, 0x09, 0x33, 0xc7, 0x0c, 0x33, 0xe6, 0x5c, 0x86, 0x49, 0x21, 0xe9, 0xd9, 0x18, 0xb6, 0x9e,
	0x51, 0x0f, 0xe9, 0x15, 0x75, 0x5d, 0xc3, 0x5c, 0x6c, 0x4a, 0x5e, 0x83, 0x35, 0x4f, 0x9f, 0xd5,
	0x11, 0x65, 0x95, 0xf5, 0x66, 0x89, 0x59, 0xef, 0x78, 0xba, 0x52, 0xea, 0x32, 0x09, 0x8d, 0xc1,
	0x5f, 0xc2, 0xf6, 0xa4, 0x5a, 0x69, 0x73, 0x11, 0xd6, 0x06, 0x82, 0x26, 0x2f, 0x99, 0xff, 0x89,
	0xb6, 0xbc, 0xd9, 0xe5, 0xa1, 0xf3, 0x60, 0x64, 0xc9, 0x2a, 0x07, 0x17, 0x7e, 0x70, 0xbf, 0x38,
	0x36, 0xee, 0xc1, 0x96, 0x17, 0x9c, 0x06, 0x7d, 0x27, 0xa2, 0xe1, 0x5e, 0x56, 0x72, 0x70, 0x0d,
	0xb6, 0x27, 0x35, 0x49, 0x27, 0x1e, 0xc3, 0x9a, 0xe0, 0xf2, 0xa7, 0x5b, 0xc2, 0x9c, 0xf5, 0x39,
	0xb0, 0x2b, 0x1e, 0x63, 0xd5, 0x7e, 0x9f, 0xd0, 0x81, 0xed, 0xf7, 0xae, 0x85, 0xf7, 0x15, 0x87,
	0x83, 0xe9, 0x41, 0xbb, 0xca, 0x7a, 0x0c, 0x1e, 0xc9, 0x4b, 0x3f, 0x7e, 0x29, 0x5e, 0x6b, 0x09,
	0x4a, 0xa5, 0x0b, 0xff, 0x99, 0xda, 0x45, 0x26, 0x3b, 0x58, 0x70, 0x5e, 0xf9, 0x21, 0x0f, 0x40,
	0x68, 0xb7, 0x49, 0x9d, 0xb7, 0x56, 0x9b, 0xa2, 0x2e, 0x6c, 0x25, 0xbe, 0x04, 0xd1, 0xdd, 0xe8,
	0x36, 0x33, 0xeb, 0xf1, 0xa9, 0xdd, 0x3b, 0x87, 0x4b, 0xf6, 0xf4, 0x25, 0xa4, 0x07, 0x1b, 0x4a,
	0xe4, 0xb2, 0xa3, 0xdb, 0x89, 0x2b, 0x53, 0xf4, 0x59, 0xa7, 0xe1, 0x79, 0x2c, 0x3e, 0xfc, 0x7f,
	0x15, 0xf4, 0x1a, 0xd6, 0x27, 0x9e, 0x72, 0xe8, 0xd6, 0x84, 0xe8, 0xc4, 0x8b, 0x51, 0x2b, 0xcd,
	0x3c, 0x8f, 0xe0, 0x3e, 0x87, 0x5c, 0xe4, 0xc9, 0x85, 0xb4, 0xa8, 0x4c, 0xfc, 0x19, 0xa8, 0xed,
	0x24, 0x9e, 0x05, 0x21, 0xf8, 0x5a, 0x0c, 0xb6, 0xd8, 0x3b, 0x06, 0xed, 0x9e, 0xf7, 0x88, 0xd2,
	0x6e, 0xcf, 0xe1, 0x48, 0xf4, 0x3f, 0xc0, 0xbe, 0x35, 0x73, 0x21, 0x4d, 0xf6, 0x3f, 0x11, 0xf7,
	0x85, 0xf0, 0x5f, 0x2e, 0x84, 0x71, 0xff, 0xe3, 0xfb, 0x66, 0xdc, 0xff, 0x89, 0x0d, 0x92, 0x63,
	0xf5, 0x44, 0xb1, 0x4d, 0x15, 0x72, 0xbc, 0xd8, 0x66, 0x5d, 0xae, 0x78, 0xb1, 0xcd, 0xbc, 0x0d,
	0x5c, 0xd3, 0x3e, 0x64, 0x83, 0xa5, 0x11, 0x15, 0xc3, 0x0b, 0x18, 0xdf, 0x50, 0xb5, 0xeb, 0x09,
	0x27, 0x41, 0xbe, 0x5e, 0x42, 0x3e, 0xba, 0x9e, 0xa1, 0x9d, 0xe4, 0xa5, 0x4d, 0x20, 0xdd, 0x98,
	0xb7, 0xd1, 0x09, 0xb0, 0xe8, 0xb6, 0x13, 0x82, 0x25, 0xac, 0x58, 0x21, 0x58, 0xe2, 0x82, 0xb4,
	0x84, 0x6a, 0x00, 0xe1, 0x16, 0x83, 0xae, 0x47, 0xc3, 0x12, 0x07, 0xd2, 0x92, 0x8e, 0xa2, 0x30,
	0xe1, 0x0a, 0x11, 0xc2, 0x4c, 0x6d, 0x38, 0x21, 0xcc, 0xf4, 0xc6, 0x81, 0x97, 0xd0, 0x8f, 0x0a,
	0x94, 0xce, 0x99, 0xe2, 0xa8, 0xec, 0x23, 0x5c, 0x6c, 0xff, 0xd0, 0xf6, 0x2e, 0xcc, 0x1f, 0x49,
	0xfa, 0x07, 0xb8, 0x31, 0x6f, 0xd4, 0xa2, 0xc7, 0x51, 0xd0, 0x73, 0xd6, 0x03, 0xed, 0xc9, 0xc5,
	0x98, 0x23, 0xea, 0x9b, 0x50, 0x88, 0xcf, 0x49, 0x74, 0x33, 0x98, 0x24, 0x49, 0x63, 0x5b, 0xbb,
	0x35, 0xeb, 0x38, 0x0e, 0x1a, 0x9f, 0x5b, 0x21, 0x68, 0xe2, 0xe4, 0x0c, 0x41, 0x93, 0xc7, 0x9d,
	0x07, 0x7a, 0x9a, 0xe6, 0x4f, 0xf1, 0xa7, 0x7f, 0x05, 0x00, 0x00, 0xff, 0xff, 0x22, 0x9c, 0xc4,
	0x71, 0x9d, 0x14, 0x00, 0x00,
}
