//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/security/armsecurity"
	"net/http"
	"net/url"
	"regexp"
)

// AdaptiveNetworkHardeningsServer is a fake server for instances of the armsecurity.AdaptiveNetworkHardeningsClient type.
type AdaptiveNetworkHardeningsServer struct {
	// BeginEnforce is the fake for method AdaptiveNetworkHardeningsClient.BeginEnforce
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginEnforce func(ctx context.Context, resourceGroupName string, resourceNamespace string, resourceType string, resourceName string, adaptiveNetworkHardeningResourceName string, body armsecurity.AdaptiveNetworkHardeningEnforceRequest, options *armsecurity.AdaptiveNetworkHardeningsClientBeginEnforceOptions) (resp azfake.PollerResponder[armsecurity.AdaptiveNetworkHardeningsClientEnforceResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method AdaptiveNetworkHardeningsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, resourceNamespace string, resourceType string, resourceName string, adaptiveNetworkHardeningResourceName string, options *armsecurity.AdaptiveNetworkHardeningsClientGetOptions) (resp azfake.Responder[armsecurity.AdaptiveNetworkHardeningsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByExtendedResourcePager is the fake for method AdaptiveNetworkHardeningsClient.NewListByExtendedResourcePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByExtendedResourcePager func(resourceGroupName string, resourceNamespace string, resourceType string, resourceName string, options *armsecurity.AdaptiveNetworkHardeningsClientListByExtendedResourceOptions) (resp azfake.PagerResponder[armsecurity.AdaptiveNetworkHardeningsClientListByExtendedResourceResponse])
}

// NewAdaptiveNetworkHardeningsServerTransport creates a new instance of AdaptiveNetworkHardeningsServerTransport with the provided implementation.
// The returned AdaptiveNetworkHardeningsServerTransport instance is connected to an instance of armsecurity.AdaptiveNetworkHardeningsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAdaptiveNetworkHardeningsServerTransport(srv *AdaptiveNetworkHardeningsServer) *AdaptiveNetworkHardeningsServerTransport {
	return &AdaptiveNetworkHardeningsServerTransport{
		srv:                            srv,
		beginEnforce:                   newTracker[azfake.PollerResponder[armsecurity.AdaptiveNetworkHardeningsClientEnforceResponse]](),
		newListByExtendedResourcePager: newTracker[azfake.PagerResponder[armsecurity.AdaptiveNetworkHardeningsClientListByExtendedResourceResponse]](),
	}
}

// AdaptiveNetworkHardeningsServerTransport connects instances of armsecurity.AdaptiveNetworkHardeningsClient to instances of AdaptiveNetworkHardeningsServer.
// Don't use this type directly, use NewAdaptiveNetworkHardeningsServerTransport instead.
type AdaptiveNetworkHardeningsServerTransport struct {
	srv                            *AdaptiveNetworkHardeningsServer
	beginEnforce                   *tracker[azfake.PollerResponder[armsecurity.AdaptiveNetworkHardeningsClientEnforceResponse]]
	newListByExtendedResourcePager *tracker[azfake.PagerResponder[armsecurity.AdaptiveNetworkHardeningsClientListByExtendedResourceResponse]]
}

// Do implements the policy.Transporter interface for AdaptiveNetworkHardeningsServerTransport.
func (a *AdaptiveNetworkHardeningsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "AdaptiveNetworkHardeningsClient.BeginEnforce":
		resp, err = a.dispatchBeginEnforce(req)
	case "AdaptiveNetworkHardeningsClient.Get":
		resp, err = a.dispatchGet(req)
	case "AdaptiveNetworkHardeningsClient.NewListByExtendedResourcePager":
		resp, err = a.dispatchNewListByExtendedResourcePager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *AdaptiveNetworkHardeningsServerTransport) dispatchBeginEnforce(req *http.Request) (*http.Response, error) {
	if a.srv.BeginEnforce == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginEnforce not implemented")}
	}
	beginEnforce := a.beginEnforce.get(req)
	if beginEnforce == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/(?P<resourceNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<resourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/adaptiveNetworkHardenings/(?P<adaptiveNetworkHardeningResourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<adaptiveNetworkHardeningEnforceAction>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsecurity.AdaptiveNetworkHardeningEnforceRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceNamespace")])
		if err != nil {
			return nil, err
		}
		resourceTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceType")])
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		adaptiveNetworkHardeningResourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("adaptiveNetworkHardeningResourceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := a.srv.BeginEnforce(req.Context(), resourceGroupNameParam, resourceNamespaceParam, resourceTypeParam, resourceNameParam, adaptiveNetworkHardeningResourceNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginEnforce = &respr
		a.beginEnforce.add(req, beginEnforce)
	}

	resp, err := server.PollerResponderNext(beginEnforce, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		a.beginEnforce.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginEnforce) {
		a.beginEnforce.remove(req)
	}

	return resp, nil
}

func (a *AdaptiveNetworkHardeningsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if a.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/(?P<resourceNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<resourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/adaptiveNetworkHardenings/(?P<adaptiveNetworkHardeningResourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceNamespace")])
	if err != nil {
		return nil, err
	}
	resourceTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceType")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	adaptiveNetworkHardeningResourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("adaptiveNetworkHardeningResourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Get(req.Context(), resourceGroupNameParam, resourceNamespaceParam, resourceTypeParam, resourceNameParam, adaptiveNetworkHardeningResourceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AdaptiveNetworkHardening, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AdaptiveNetworkHardeningsServerTransport) dispatchNewListByExtendedResourcePager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListByExtendedResourcePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByExtendedResourcePager not implemented")}
	}
	newListByExtendedResourcePager := a.newListByExtendedResourcePager.get(req)
	if newListByExtendedResourcePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/(?P<resourceNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<resourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/adaptiveNetworkHardenings`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceNamespace")])
		if err != nil {
			return nil, err
		}
		resourceTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceType")])
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resp := a.srv.NewListByExtendedResourcePager(resourceGroupNameParam, resourceNamespaceParam, resourceTypeParam, resourceNameParam, nil)
		newListByExtendedResourcePager = &resp
		a.newListByExtendedResourcePager.add(req, newListByExtendedResourcePager)
		server.PagerResponderInjectNextLinks(newListByExtendedResourcePager, req, func(page *armsecurity.AdaptiveNetworkHardeningsClientListByExtendedResourceResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByExtendedResourcePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListByExtendedResourcePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByExtendedResourcePager) {
		a.newListByExtendedResourcePager.remove(req)
	}
	return resp, nil
}
