//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/storagepool/armstoragepool"
	"net/http"
	"net/url"
	"regexp"
)

// IscsiTargetsServer is a fake server for instances of the armstoragepool.IscsiTargetsClient type.
type IscsiTargetsServer struct {
	// BeginCreateOrUpdate is the fake for method IscsiTargetsClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, diskPoolName string, iscsiTargetName string, iscsiTargetCreatePayload armstoragepool.IscsiTargetCreate, options *armstoragepool.IscsiTargetsClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armstoragepool.IscsiTargetsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method IscsiTargetsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, diskPoolName string, iscsiTargetName string, options *armstoragepool.IscsiTargetsClientBeginDeleteOptions) (resp azfake.PollerResponder[armstoragepool.IscsiTargetsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method IscsiTargetsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, diskPoolName string, iscsiTargetName string, options *armstoragepool.IscsiTargetsClientGetOptions) (resp azfake.Responder[armstoragepool.IscsiTargetsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByDiskPoolPager is the fake for method IscsiTargetsClient.NewListByDiskPoolPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByDiskPoolPager func(resourceGroupName string, diskPoolName string, options *armstoragepool.IscsiTargetsClientListByDiskPoolOptions) (resp azfake.PagerResponder[armstoragepool.IscsiTargetsClientListByDiskPoolResponse])

	// BeginUpdate is the fake for method IscsiTargetsClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, diskPoolName string, iscsiTargetName string, iscsiTargetUpdatePayload armstoragepool.IscsiTargetUpdate, options *armstoragepool.IscsiTargetsClientBeginUpdateOptions) (resp azfake.PollerResponder[armstoragepool.IscsiTargetsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewIscsiTargetsServerTransport creates a new instance of IscsiTargetsServerTransport with the provided implementation.
// The returned IscsiTargetsServerTransport instance is connected to an instance of armstoragepool.IscsiTargetsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewIscsiTargetsServerTransport(srv *IscsiTargetsServer) *IscsiTargetsServerTransport {
	return &IscsiTargetsServerTransport{
		srv:                    srv,
		beginCreateOrUpdate:    newTracker[azfake.PollerResponder[armstoragepool.IscsiTargetsClientCreateOrUpdateResponse]](),
		beginDelete:            newTracker[azfake.PollerResponder[armstoragepool.IscsiTargetsClientDeleteResponse]](),
		newListByDiskPoolPager: newTracker[azfake.PagerResponder[armstoragepool.IscsiTargetsClientListByDiskPoolResponse]](),
		beginUpdate:            newTracker[azfake.PollerResponder[armstoragepool.IscsiTargetsClientUpdateResponse]](),
	}
}

// IscsiTargetsServerTransport connects instances of armstoragepool.IscsiTargetsClient to instances of IscsiTargetsServer.
// Don't use this type directly, use NewIscsiTargetsServerTransport instead.
type IscsiTargetsServerTransport struct {
	srv                    *IscsiTargetsServer
	beginCreateOrUpdate    *tracker[azfake.PollerResponder[armstoragepool.IscsiTargetsClientCreateOrUpdateResponse]]
	beginDelete            *tracker[azfake.PollerResponder[armstoragepool.IscsiTargetsClientDeleteResponse]]
	newListByDiskPoolPager *tracker[azfake.PagerResponder[armstoragepool.IscsiTargetsClientListByDiskPoolResponse]]
	beginUpdate            *tracker[azfake.PollerResponder[armstoragepool.IscsiTargetsClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for IscsiTargetsServerTransport.
func (i *IscsiTargetsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "IscsiTargetsClient.BeginCreateOrUpdate":
		resp, err = i.dispatchBeginCreateOrUpdate(req)
	case "IscsiTargetsClient.BeginDelete":
		resp, err = i.dispatchBeginDelete(req)
	case "IscsiTargetsClient.Get":
		resp, err = i.dispatchGet(req)
	case "IscsiTargetsClient.NewListByDiskPoolPager":
		resp, err = i.dispatchNewListByDiskPoolPager(req)
	case "IscsiTargetsClient.BeginUpdate":
		resp, err = i.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (i *IscsiTargetsServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if i.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := i.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StoragePool/diskPools/(?P<diskPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/iscsiTargets/(?P<iscsiTargetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armstoragepool.IscsiTargetCreate](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		diskPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("diskPoolName")])
		if err != nil {
			return nil, err
		}
		iscsiTargetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("iscsiTargetName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := i.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, diskPoolNameParam, iscsiTargetNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		i.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		i.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		i.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (i *IscsiTargetsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if i.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := i.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StoragePool/diskPools/(?P<diskPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/iscsiTargets/(?P<iscsiTargetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		diskPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("diskPoolName")])
		if err != nil {
			return nil, err
		}
		iscsiTargetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("iscsiTargetName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := i.srv.BeginDelete(req.Context(), resourceGroupNameParam, diskPoolNameParam, iscsiTargetNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		i.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		i.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		i.beginDelete.remove(req)
	}

	return resp, nil
}

func (i *IscsiTargetsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if i.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StoragePool/diskPools/(?P<diskPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/iscsiTargets/(?P<iscsiTargetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	diskPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("diskPoolName")])
	if err != nil {
		return nil, err
	}
	iscsiTargetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("iscsiTargetName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.Get(req.Context(), resourceGroupNameParam, diskPoolNameParam, iscsiTargetNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).IscsiTarget, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (i *IscsiTargetsServerTransport) dispatchNewListByDiskPoolPager(req *http.Request) (*http.Response, error) {
	if i.srv.NewListByDiskPoolPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByDiskPoolPager not implemented")}
	}
	newListByDiskPoolPager := i.newListByDiskPoolPager.get(req)
	if newListByDiskPoolPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StoragePool/diskPools/(?P<diskPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/iscsiTargets`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		diskPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("diskPoolName")])
		if err != nil {
			return nil, err
		}
		resp := i.srv.NewListByDiskPoolPager(resourceGroupNameParam, diskPoolNameParam, nil)
		newListByDiskPoolPager = &resp
		i.newListByDiskPoolPager.add(req, newListByDiskPoolPager)
		server.PagerResponderInjectNextLinks(newListByDiskPoolPager, req, func(page *armstoragepool.IscsiTargetsClientListByDiskPoolResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByDiskPoolPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		i.newListByDiskPoolPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByDiskPoolPager) {
		i.newListByDiskPoolPager.remove(req)
	}
	return resp, nil
}

func (i *IscsiTargetsServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if i.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := i.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StoragePool/diskPools/(?P<diskPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/iscsiTargets/(?P<iscsiTargetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armstoragepool.IscsiTargetUpdate](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		diskPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("diskPoolName")])
		if err != nil {
			return nil, err
		}
		iscsiTargetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("iscsiTargetName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := i.srv.BeginUpdate(req.Context(), resourceGroupNameParam, diskPoolNameParam, iscsiTargetNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		i.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		i.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		i.beginUpdate.remove(req)
	}

	return resp, nil
}
