//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/storsimple8000series/armstorsimple8000series"
	"net/http"
	"net/url"
	"regexp"
)

// DevicesServer is a fake server for instances of the armstorsimple8000series.DevicesClient type.
type DevicesServer struct {
	// AuthorizeForServiceEncryptionKeyRollover is the fake for method DevicesClient.AuthorizeForServiceEncryptionKeyRollover
	// HTTP status codes to indicate success: http.StatusNoContent
	AuthorizeForServiceEncryptionKeyRollover func(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *armstorsimple8000series.DevicesClientAuthorizeForServiceEncryptionKeyRolloverOptions) (resp azfake.Responder[armstorsimple8000series.DevicesClientAuthorizeForServiceEncryptionKeyRolloverResponse], errResp azfake.ErrorResponder)

	// BeginConfigure is the fake for method DevicesClient.BeginConfigure
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginConfigure func(ctx context.Context, resourceGroupName string, managerName string, parameters armstorsimple8000series.ConfigureDeviceRequest, options *armstorsimple8000series.DevicesClientBeginConfigureOptions) (resp azfake.PollerResponder[armstorsimple8000series.DevicesClientConfigureResponse], errResp azfake.ErrorResponder)

	// BeginDeactivate is the fake for method DevicesClient.BeginDeactivate
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDeactivate func(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *armstorsimple8000series.DevicesClientBeginDeactivateOptions) (resp azfake.PollerResponder[armstorsimple8000series.DevicesClientDeactivateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method DevicesClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *armstorsimple8000series.DevicesClientBeginDeleteOptions) (resp azfake.PollerResponder[armstorsimple8000series.DevicesClientDeleteResponse], errResp azfake.ErrorResponder)

	// BeginFailover is the fake for method DevicesClient.BeginFailover
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginFailover func(ctx context.Context, sourceDeviceName string, resourceGroupName string, managerName string, parameters armstorsimple8000series.FailoverRequest, options *armstorsimple8000series.DevicesClientBeginFailoverOptions) (resp azfake.PollerResponder[armstorsimple8000series.DevicesClientFailoverResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method DevicesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *armstorsimple8000series.DevicesClientGetOptions) (resp azfake.Responder[armstorsimple8000series.DevicesClientGetResponse], errResp azfake.ErrorResponder)

	// GetUpdateSummary is the fake for method DevicesClient.GetUpdateSummary
	// HTTP status codes to indicate success: http.StatusOK
	GetUpdateSummary func(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *armstorsimple8000series.DevicesClientGetUpdateSummaryOptions) (resp azfake.Responder[armstorsimple8000series.DevicesClientGetUpdateSummaryResponse], errResp azfake.ErrorResponder)

	// BeginInstallUpdates is the fake for method DevicesClient.BeginInstallUpdates
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginInstallUpdates func(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *armstorsimple8000series.DevicesClientBeginInstallUpdatesOptions) (resp azfake.PollerResponder[armstorsimple8000series.DevicesClientInstallUpdatesResponse], errResp azfake.ErrorResponder)

	// NewListByManagerPager is the fake for method DevicesClient.NewListByManagerPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByManagerPager func(resourceGroupName string, managerName string, options *armstorsimple8000series.DevicesClientListByManagerOptions) (resp azfake.PagerResponder[armstorsimple8000series.DevicesClientListByManagerResponse])

	// NewListFailoverSetsPager is the fake for method DevicesClient.NewListFailoverSetsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListFailoverSetsPager func(deviceName string, resourceGroupName string, managerName string, options *armstorsimple8000series.DevicesClientListFailoverSetsOptions) (resp azfake.PagerResponder[armstorsimple8000series.DevicesClientListFailoverSetsResponse])

	// NewListFailoverTargetsPager is the fake for method DevicesClient.NewListFailoverTargetsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListFailoverTargetsPager func(sourceDeviceName string, resourceGroupName string, managerName string, parameters armstorsimple8000series.ListFailoverTargetsRequest, options *armstorsimple8000series.DevicesClientListFailoverTargetsOptions) (resp azfake.PagerResponder[armstorsimple8000series.DevicesClientListFailoverTargetsResponse])

	// NewListMetricDefinitionPager is the fake for method DevicesClient.NewListMetricDefinitionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListMetricDefinitionPager func(deviceName string, resourceGroupName string, managerName string, options *armstorsimple8000series.DevicesClientListMetricDefinitionOptions) (resp azfake.PagerResponder[armstorsimple8000series.DevicesClientListMetricDefinitionResponse])

	// NewListMetricsPager is the fake for method DevicesClient.NewListMetricsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListMetricsPager func(deviceName string, resourceGroupName string, managerName string, filter string, options *armstorsimple8000series.DevicesClientListMetricsOptions) (resp azfake.PagerResponder[armstorsimple8000series.DevicesClientListMetricsResponse])

	// BeginScanForUpdates is the fake for method DevicesClient.BeginScanForUpdates
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginScanForUpdates func(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *armstorsimple8000series.DevicesClientBeginScanForUpdatesOptions) (resp azfake.PollerResponder[armstorsimple8000series.DevicesClientScanForUpdatesResponse], errResp azfake.ErrorResponder)

	// Update is the fake for method DevicesClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, deviceName string, resourceGroupName string, managerName string, parameters armstorsimple8000series.DevicePatch, options *armstorsimple8000series.DevicesClientUpdateOptions) (resp azfake.Responder[armstorsimple8000series.DevicesClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewDevicesServerTransport creates a new instance of DevicesServerTransport with the provided implementation.
// The returned DevicesServerTransport instance is connected to an instance of armstorsimple8000series.DevicesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDevicesServerTransport(srv *DevicesServer) *DevicesServerTransport {
	return &DevicesServerTransport{
		srv:                          srv,
		beginConfigure:               newTracker[azfake.PollerResponder[armstorsimple8000series.DevicesClientConfigureResponse]](),
		beginDeactivate:              newTracker[azfake.PollerResponder[armstorsimple8000series.DevicesClientDeactivateResponse]](),
		beginDelete:                  newTracker[azfake.PollerResponder[armstorsimple8000series.DevicesClientDeleteResponse]](),
		beginFailover:                newTracker[azfake.PollerResponder[armstorsimple8000series.DevicesClientFailoverResponse]](),
		beginInstallUpdates:          newTracker[azfake.PollerResponder[armstorsimple8000series.DevicesClientInstallUpdatesResponse]](),
		newListByManagerPager:        newTracker[azfake.PagerResponder[armstorsimple8000series.DevicesClientListByManagerResponse]](),
		newListFailoverSetsPager:     newTracker[azfake.PagerResponder[armstorsimple8000series.DevicesClientListFailoverSetsResponse]](),
		newListFailoverTargetsPager:  newTracker[azfake.PagerResponder[armstorsimple8000series.DevicesClientListFailoverTargetsResponse]](),
		newListMetricDefinitionPager: newTracker[azfake.PagerResponder[armstorsimple8000series.DevicesClientListMetricDefinitionResponse]](),
		newListMetricsPager:          newTracker[azfake.PagerResponder[armstorsimple8000series.DevicesClientListMetricsResponse]](),
		beginScanForUpdates:          newTracker[azfake.PollerResponder[armstorsimple8000series.DevicesClientScanForUpdatesResponse]](),
	}
}

// DevicesServerTransport connects instances of armstorsimple8000series.DevicesClient to instances of DevicesServer.
// Don't use this type directly, use NewDevicesServerTransport instead.
type DevicesServerTransport struct {
	srv                          *DevicesServer
	beginConfigure               *tracker[azfake.PollerResponder[armstorsimple8000series.DevicesClientConfigureResponse]]
	beginDeactivate              *tracker[azfake.PollerResponder[armstorsimple8000series.DevicesClientDeactivateResponse]]
	beginDelete                  *tracker[azfake.PollerResponder[armstorsimple8000series.DevicesClientDeleteResponse]]
	beginFailover                *tracker[azfake.PollerResponder[armstorsimple8000series.DevicesClientFailoverResponse]]
	beginInstallUpdates          *tracker[azfake.PollerResponder[armstorsimple8000series.DevicesClientInstallUpdatesResponse]]
	newListByManagerPager        *tracker[azfake.PagerResponder[armstorsimple8000series.DevicesClientListByManagerResponse]]
	newListFailoverSetsPager     *tracker[azfake.PagerResponder[armstorsimple8000series.DevicesClientListFailoverSetsResponse]]
	newListFailoverTargetsPager  *tracker[azfake.PagerResponder[armstorsimple8000series.DevicesClientListFailoverTargetsResponse]]
	newListMetricDefinitionPager *tracker[azfake.PagerResponder[armstorsimple8000series.DevicesClientListMetricDefinitionResponse]]
	newListMetricsPager          *tracker[azfake.PagerResponder[armstorsimple8000series.DevicesClientListMetricsResponse]]
	beginScanForUpdates          *tracker[azfake.PollerResponder[armstorsimple8000series.DevicesClientScanForUpdatesResponse]]
}

// Do implements the policy.Transporter interface for DevicesServerTransport.
func (d *DevicesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DevicesClient.AuthorizeForServiceEncryptionKeyRollover":
		resp, err = d.dispatchAuthorizeForServiceEncryptionKeyRollover(req)
	case "DevicesClient.BeginConfigure":
		resp, err = d.dispatchBeginConfigure(req)
	case "DevicesClient.BeginDeactivate":
		resp, err = d.dispatchBeginDeactivate(req)
	case "DevicesClient.BeginDelete":
		resp, err = d.dispatchBeginDelete(req)
	case "DevicesClient.BeginFailover":
		resp, err = d.dispatchBeginFailover(req)
	case "DevicesClient.Get":
		resp, err = d.dispatchGet(req)
	case "DevicesClient.GetUpdateSummary":
		resp, err = d.dispatchGetUpdateSummary(req)
	case "DevicesClient.BeginInstallUpdates":
		resp, err = d.dispatchBeginInstallUpdates(req)
	case "DevicesClient.NewListByManagerPager":
		resp, err = d.dispatchNewListByManagerPager(req)
	case "DevicesClient.NewListFailoverSetsPager":
		resp, err = d.dispatchNewListFailoverSetsPager(req)
	case "DevicesClient.NewListFailoverTargetsPager":
		resp, err = d.dispatchNewListFailoverTargetsPager(req)
	case "DevicesClient.NewListMetricDefinitionPager":
		resp, err = d.dispatchNewListMetricDefinitionPager(req)
	case "DevicesClient.NewListMetricsPager":
		resp, err = d.dispatchNewListMetricsPager(req)
	case "DevicesClient.BeginScanForUpdates":
		resp, err = d.dispatchBeginScanForUpdates(req)
	case "DevicesClient.Update":
		resp, err = d.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DevicesServerTransport) dispatchAuthorizeForServiceEncryptionKeyRollover(req *http.Request) (*http.Response, error) {
	if d.srv.AuthorizeForServiceEncryptionKeyRollover == nil {
		return nil, &nonRetriableError{errors.New("fake for method AuthorizeForServiceEncryptionKeyRollover not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<deviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/authorizeForServiceEncryptionKeyRollover`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	deviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.AuthorizeForServiceEncryptionKeyRollover(req.Context(), deviceNameParam, resourceGroupNameParam, managerNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DevicesServerTransport) dispatchBeginConfigure(req *http.Request) (*http.Response, error) {
	if d.srv.BeginConfigure == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginConfigure not implemented")}
	}
	beginConfigure := d.beginConfigure.get(req)
	if beginConfigure == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/configureDevice`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armstorsimple8000series.ConfigureDeviceRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginConfigure(req.Context(), resourceGroupNameParam, managerNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginConfigure = &respr
		d.beginConfigure.add(req, beginConfigure)
	}

	resp, err := server.PollerResponderNext(beginConfigure, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		d.beginConfigure.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginConfigure) {
		d.beginConfigure.remove(req)
	}

	return resp, nil
}

func (d *DevicesServerTransport) dispatchBeginDeactivate(req *http.Request) (*http.Response, error) {
	if d.srv.BeginDeactivate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeactivate not implemented")}
	}
	beginDeactivate := d.beginDeactivate.get(req)
	if beginDeactivate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<deviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deactivate`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		deviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginDeactivate(req.Context(), deviceNameParam, resourceGroupNameParam, managerNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeactivate = &respr
		d.beginDeactivate.add(req, beginDeactivate)
	}

	resp, err := server.PollerResponderNext(beginDeactivate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		d.beginDeactivate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeactivate) {
		d.beginDeactivate.remove(req)
	}

	return resp, nil
}

func (d *DevicesServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if d.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := d.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<deviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		deviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginDelete(req.Context(), deviceNameParam, resourceGroupNameParam, managerNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		d.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		d.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		d.beginDelete.remove(req)
	}

	return resp, nil
}

func (d *DevicesServerTransport) dispatchBeginFailover(req *http.Request) (*http.Response, error) {
	if d.srv.BeginFailover == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginFailover not implemented")}
	}
	beginFailover := d.beginFailover.get(req)
	if beginFailover == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<sourceDeviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/failover`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armstorsimple8000series.FailoverRequest](req)
		if err != nil {
			return nil, err
		}
		sourceDeviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sourceDeviceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginFailover(req.Context(), sourceDeviceNameParam, resourceGroupNameParam, managerNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginFailover = &respr
		d.beginFailover.add(req, beginFailover)
	}

	resp, err := server.PollerResponderNext(beginFailover, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		d.beginFailover.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginFailover) {
		d.beginFailover.remove(req)
	}

	return resp, nil
}

func (d *DevicesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if d.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<deviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	deviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
	if err != nil {
		return nil, err
	}
	expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
	if err != nil {
		return nil, err
	}
	expandParam := getOptional(expandUnescaped)
	var options *armstorsimple8000series.DevicesClientGetOptions
	if expandParam != nil {
		options = &armstorsimple8000series.DevicesClientGetOptions{
			Expand: expandParam,
		}
	}
	respr, errRespr := d.srv.Get(req.Context(), deviceNameParam, resourceGroupNameParam, managerNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Device, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DevicesServerTransport) dispatchGetUpdateSummary(req *http.Request) (*http.Response, error) {
	if d.srv.GetUpdateSummary == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetUpdateSummary not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<deviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/updateSummary/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	deviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.GetUpdateSummary(req.Context(), deviceNameParam, resourceGroupNameParam, managerNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Updates, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DevicesServerTransport) dispatchBeginInstallUpdates(req *http.Request) (*http.Response, error) {
	if d.srv.BeginInstallUpdates == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginInstallUpdates not implemented")}
	}
	beginInstallUpdates := d.beginInstallUpdates.get(req)
	if beginInstallUpdates == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<deviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/installUpdates`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		deviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginInstallUpdates(req.Context(), deviceNameParam, resourceGroupNameParam, managerNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginInstallUpdates = &respr
		d.beginInstallUpdates.add(req, beginInstallUpdates)
	}

	resp, err := server.PollerResponderNext(beginInstallUpdates, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		d.beginInstallUpdates.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginInstallUpdates) {
		d.beginInstallUpdates.remove(req)
	}

	return resp, nil
}

func (d *DevicesServerTransport) dispatchNewListByManagerPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListByManagerPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByManagerPager not implemented")}
	}
	newListByManagerPager := d.newListByManagerPager.get(req)
	if newListByManagerPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
		if err != nil {
			return nil, err
		}
		expandParam := getOptional(expandUnescaped)
		var options *armstorsimple8000series.DevicesClientListByManagerOptions
		if expandParam != nil {
			options = &armstorsimple8000series.DevicesClientListByManagerOptions{
				Expand: expandParam,
			}
		}
		resp := d.srv.NewListByManagerPager(resourceGroupNameParam, managerNameParam, options)
		newListByManagerPager = &resp
		d.newListByManagerPager.add(req, newListByManagerPager)
	}
	resp, err := server.PagerResponderNext(newListByManagerPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListByManagerPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByManagerPager) {
		d.newListByManagerPager.remove(req)
	}
	return resp, nil
}

func (d *DevicesServerTransport) dispatchNewListFailoverSetsPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListFailoverSetsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListFailoverSetsPager not implemented")}
	}
	newListFailoverSetsPager := d.newListFailoverSetsPager.get(req)
	if newListFailoverSetsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<deviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listFailoverSets`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		deviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		resp := d.srv.NewListFailoverSetsPager(deviceNameParam, resourceGroupNameParam, managerNameParam, nil)
		newListFailoverSetsPager = &resp
		d.newListFailoverSetsPager.add(req, newListFailoverSetsPager)
	}
	resp, err := server.PagerResponderNext(newListFailoverSetsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListFailoverSetsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListFailoverSetsPager) {
		d.newListFailoverSetsPager.remove(req)
	}
	return resp, nil
}

func (d *DevicesServerTransport) dispatchNewListFailoverTargetsPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListFailoverTargetsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListFailoverTargetsPager not implemented")}
	}
	newListFailoverTargetsPager := d.newListFailoverTargetsPager.get(req)
	if newListFailoverTargetsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<sourceDeviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listFailoverTargets`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armstorsimple8000series.ListFailoverTargetsRequest](req)
		if err != nil {
			return nil, err
		}
		sourceDeviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sourceDeviceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		resp := d.srv.NewListFailoverTargetsPager(sourceDeviceNameParam, resourceGroupNameParam, managerNameParam, body, nil)
		newListFailoverTargetsPager = &resp
		d.newListFailoverTargetsPager.add(req, newListFailoverTargetsPager)
	}
	resp, err := server.PagerResponderNext(newListFailoverTargetsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListFailoverTargetsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListFailoverTargetsPager) {
		d.newListFailoverTargetsPager.remove(req)
	}
	return resp, nil
}

func (d *DevicesServerTransport) dispatchNewListMetricDefinitionPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListMetricDefinitionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListMetricDefinitionPager not implemented")}
	}
	newListMetricDefinitionPager := d.newListMetricDefinitionPager.get(req)
	if newListMetricDefinitionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<deviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/metricsDefinitions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		deviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		resp := d.srv.NewListMetricDefinitionPager(deviceNameParam, resourceGroupNameParam, managerNameParam, nil)
		newListMetricDefinitionPager = &resp
		d.newListMetricDefinitionPager.add(req, newListMetricDefinitionPager)
	}
	resp, err := server.PagerResponderNext(newListMetricDefinitionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListMetricDefinitionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListMetricDefinitionPager) {
		d.newListMetricDefinitionPager.remove(req)
	}
	return resp, nil
}

func (d *DevicesServerTransport) dispatchNewListMetricsPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListMetricsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListMetricsPager not implemented")}
	}
	newListMetricsPager := d.newListMetricsPager.get(req)
	if newListMetricsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<deviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/metrics`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		deviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		filterParam, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		resp := d.srv.NewListMetricsPager(deviceNameParam, resourceGroupNameParam, managerNameParam, filterParam, nil)
		newListMetricsPager = &resp
		d.newListMetricsPager.add(req, newListMetricsPager)
	}
	resp, err := server.PagerResponderNext(newListMetricsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListMetricsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListMetricsPager) {
		d.newListMetricsPager.remove(req)
	}
	return resp, nil
}

func (d *DevicesServerTransport) dispatchBeginScanForUpdates(req *http.Request) (*http.Response, error) {
	if d.srv.BeginScanForUpdates == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginScanForUpdates not implemented")}
	}
	beginScanForUpdates := d.beginScanForUpdates.get(req)
	if beginScanForUpdates == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<deviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/scanForUpdates`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		deviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginScanForUpdates(req.Context(), deviceNameParam, resourceGroupNameParam, managerNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginScanForUpdates = &respr
		d.beginScanForUpdates.add(req, beginScanForUpdates)
	}

	resp, err := server.PollerResponderNext(beginScanForUpdates, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		d.beginScanForUpdates.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginScanForUpdates) {
		d.beginScanForUpdates.remove(req)
	}

	return resp, nil
}

func (d *DevicesServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if d.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<deviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armstorsimple8000series.DevicePatch](req)
	if err != nil {
		return nil, err
	}
	deviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.Update(req.Context(), deviceNameParam, resourceGroupNameParam, managerNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Device, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
