//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsynapse_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/synapse/armsynapse"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/preview/2021-06-01-preview/examples/SparkConfigurations_ListByWorkspace.json
func ExampleSparkConfigurationsClient_NewListByWorkspacePager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewSparkConfigurationsClient().NewListByWorkspacePager("exampleResourceGroup", "exampleWorkspace", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SparkConfigurationListResponse = armsynapse.SparkConfigurationListResponse{
		// 	Value: []*armsynapse.SparkConfigurationResource{
		// 		{
		// 			Name: to.Ptr("exampleSparkConfigurationName1"),
		// 			Type: to.Ptr("Microsoft.Synapse/workspaces/sparkconfigurations"),
		// 			ID: to.Ptr("/subscriptions/12345678-1234-1234-1234-12345678abc/resourceGroups/exampleResourceGroup/providers/Microsoft.Synapse/workspaces/exampleWorkspace/sparkconfigurations/exampleSparkConfigurationName"),
		// 			Etag: to.Ptr("1500474f-0000-0200-0000-5cbe090d0000"),
		// 			Properties: &armsynapse.SparkConfigurationInfo{
		// 				Description: to.Ptr("test sparkconfiguration description1"),
		// 				Annotations: []*string{
		// 					to.Ptr("testAnnotation1"),
		// 					to.Ptr("testAnnotation2")},
		// 					ConfigMergeRule: map[string]*string{
		// 						"allowedNextOperations.spark.key1": to.Ptr("replace,delete"),
		// 						"allowedNextOperations.spark.key2": to.Ptr("replace,delete,append"),
		// 						"currentOperation.append.separator.spark.key1": to.Ptr("space"),
		// 						"currentOperation.append.separator.spark.key2": to.Ptr("comma"),
		// 						"currentOperation.spark.key1": to.Ptr("append"),
		// 						"currentOperation.spark.key2": to.Ptr("append"),
		// 					},
		// 					Configs: map[string]*string{
		// 						"prop1": to.Ptr("true"),
		// 						"prop2": to.Ptr("true"),
		// 						"prop3": to.Ptr("123"),
		// 					},
		// 					Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1970-01-01T00:00:00.000Z"); return t}()),
		// 					CreatedBy: to.Ptr("test@microsoft.com"),
		// 					Notes: to.Ptr("testNotes"),
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("exampleSparkConfigurationName2"),
		// 				Type: to.Ptr("Microsoft.Synapse/workspaces/sparkconfigurations"),
		// 				ID: to.Ptr("/subscriptions/12345678-1234-1234-1234-12345678abc/resourceGroups/exampleResourceGroup/providers/Microsoft.Synapse/workspaces/exampleWorkspace/sparkconfigurations/exampleSparkConfigurationName2"),
		// 				Etag: to.Ptr("1500474f-0000-0200-0000-5cbe090d0000"),
		// 				Properties: &armsynapse.SparkConfigurationInfo{
		// 					Description: to.Ptr("test sparkconfiguration description2"),
		// 					Annotations: []*string{
		// 						to.Ptr("testAnnotation1"),
		// 						to.Ptr("testAnnotation2")},
		// 						ConfigMergeRule: map[string]*string{
		// 							"allowedNextOperations.spark.key1": to.Ptr("replace,delete"),
		// 							"allowedNextOperations.spark.key2": to.Ptr("replace,delete,append"),
		// 							"currentOperation.append.separator.spark.key1": to.Ptr("space"),
		// 							"currentOperation.append.separator.spark.key2": to.Ptr("comma"),
		// 							"currentOperation.spark.key1": to.Ptr("append"),
		// 							"currentOperation.spark.key2": to.Ptr("append"),
		// 						},
		// 						Configs: map[string]*string{
		// 							"prop1": to.Ptr("true"),
		// 							"prop2": to.Ptr("true"),
		// 							"prop3": to.Ptr("123"),
		// 						},
		// 						Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1970-01-01T00:00:00.000Z"); return t}()),
		// 						CreatedBy: to.Ptr("test@microsoft.com"),
		// 						Notes: to.Ptr("testNotes"),
		// 					},
		// 			}},
		// 		}
	}
}
