//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armworkloads_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/workloads/armworkloads"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/workloads/resource-manager/Microsoft.Workloads/stable/2023-04-01/examples/workloadmonitor/ProviderInstances_List.json
func ExampleProviderInstancesClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armworkloads.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewProviderInstancesClient().NewListPager("myResourceGroup", "mySapMonitor", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ProviderInstanceListResult = armworkloads.ProviderInstanceListResult{
		// 	Value: []*armworkloads.ProviderInstance{
		// 		{
		// 			Name: to.Ptr("myProviderInstance1"),
		// 			Type: to.Ptr("Microsoft.Workloads/monitors/providerInstances"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Workloads/monitors/mySapMonitor/providerInstances/myProviderInstance1"),
		// 			Properties: &armworkloads.ProviderInstanceProperties{
		// 				ProviderSettings: &armworkloads.HanaDbProviderInstanceProperties{
		// 					ProviderType: to.Ptr("SapHana"),
		// 					DbName: to.Ptr("db"),
		// 					DbPasswordURI: to.Ptr(""),
		// 					DbUsername: to.Ptr("user"),
		// 					Hostname: to.Ptr("name"),
		// 					InstanceNumber: to.Ptr("00"),
		// 					SapSid: to.Ptr("SID"),
		// 					SQLPort: to.Ptr("0000"),
		// 					SSLCertificateURI: to.Ptr("https://storageaccount.blob.core.windows.net/containername/filename"),
		// 					SSLHostNameInCertificate: to.Ptr("xyz.domain.com"),
		// 					SSLPreference: to.Ptr(armworkloads.SSLPreferenceServerCertificate),
		// 				},
		// 				ProvisioningState: to.Ptr(armworkloads.WorkloadMonitorProvisioningStateSucceeded),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myProviderInstance2"),
		// 			Type: to.Ptr("Microsoft.Workloads/monitors/providerInstances"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Workloads/monitors/mySapMonitor/providerInstances/myProviderInstance1"),
		// 			Properties: &armworkloads.ProviderInstanceProperties{
		// 				ProviderSettings: &armworkloads.SapNetWeaverProviderInstanceProperties{
		// 					ProviderType: to.Ptr("SapNetWeaver"),
		// 					SapClientID: to.Ptr("111"),
		// 					SapHostFileEntries: []*string{
		// 						to.Ptr("127.0.0.1 name fqdn")},
		// 						SapHostname: to.Ptr("name"),
		// 						SapInstanceNr: to.Ptr("00"),
		// 						SapPasswordURI: to.Ptr(""),
		// 						SapPortNumber: to.Ptr("1234"),
		// 						SapSid: to.Ptr("SID"),
		// 						SapUsername: to.Ptr("username"),
		// 						SSLCertificateURI: to.Ptr("https://storageaccount.blob.core.windows.net/containername/filename"),
		// 						SSLPreference: to.Ptr(armworkloads.SSLPreferenceServerCertificate),
		// 					},
		// 					ProvisioningState: to.Ptr(armworkloads.WorkloadMonitorProvisioningStateSucceeded),
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("myProviderInstance4"),
		// 				Type: to.Ptr("Microsoft.Workloads/monitors/providerInstances"),
		// 				ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Workloads/monitors/mySapMonitor/providerInstances/myProviderInstance1"),
		// 				Properties: &armworkloads.ProviderInstanceProperties{
		// 					ProviderSettings: &armworkloads.MsSQLServerProviderInstanceProperties{
		// 						ProviderType: to.Ptr("MsSqlServer"),
		// 						DbPort: to.Ptr("5912"),
		// 						DbUsername: to.Ptr("user"),
		// 						Hostname: to.Ptr("hostname"),
		// 						SapSid: to.Ptr("sid"),
		// 						SSLCertificateURI: to.Ptr("https://storageaccount.blob.core.windows.net/containername/filename"),
		// 						SSLPreference: to.Ptr(armworkloads.SSLPreferenceServerCertificate),
		// 					},
		// 					ProvisioningState: to.Ptr(armworkloads.WorkloadMonitorProvisioningStateSucceeded),
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("myProviderInstance3"),
		// 				Type: to.Ptr("Microsoft.Workloads/monitors/providerInstances"),
		// 				ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Workloads/monitors/mySapMonitor/providerInstances/myProviderInstance1"),
		// 				Properties: &armworkloads.ProviderInstanceProperties{
		// 					ProviderSettings: &armworkloads.PrometheusOSProviderInstanceProperties{
		// 						ProviderType: to.Ptr("PrometheusOS"),
		// 						PrometheusURL: to.Ptr("http://192.168.0.0:9090/metrics"),
		// 						SapSid: to.Ptr("SID"),
		// 						SSLCertificateURI: to.Ptr("https://storageaccount.blob.core.windows.net/containername/filename"),
		// 						SSLPreference: to.Ptr(armworkloads.SSLPreferenceServerCertificate),
		// 					},
		// 					ProvisioningState: to.Ptr(armworkloads.WorkloadMonitorProvisioningStateSucceeded),
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("myProviderInstance3"),
		// 				Type: to.Ptr("Microsoft.Workloads/monitors/providerInstances"),
		// 				ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Workloads/monitors/mySapMonitor/providerInstances/myProviderInstance1"),
		// 				Properties: &armworkloads.ProviderInstanceProperties{
		// 					ProviderSettings: &armworkloads.PrometheusHaClusterProviderInstanceProperties{
		// 						ProviderType: to.Ptr("PrometheusHaCluster"),
		// 						ClusterName: to.Ptr("clusterName"),
		// 						Hostname: to.Ptr("hostname"),
		// 						PrometheusURL: to.Ptr("http://192.168.0.0:9090/metrics"),
		// 						Sid: to.Ptr("sid"),
		// 						SSLCertificateURI: to.Ptr("https://storageaccount.blob.core.windows.net/containername/filename"),
		// 						SSLPreference: to.Ptr(armworkloads.SSLPreferenceServerCertificate),
		// 					},
		// 					ProvisioningState: to.Ptr(armworkloads.WorkloadMonitorProvisioningStateSucceeded),
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("myProviderInstance3"),
		// 				Type: to.Ptr("Microsoft.Workloads/monitors/providerInstances"),
		// 				ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Workloads/monitors/mySapMonitor/providerInstances/myProviderInstance1"),
		// 				Properties: &armworkloads.ProviderInstanceProperties{
		// 					ProviderSettings: &armworkloads.DB2ProviderInstanceProperties{
		// 						ProviderType: to.Ptr("Db2"),
		// 						DbName: to.Ptr("OPA"),
		// 						DbPasswordURI: to.Ptr(""),
		// 						DbPort: to.Ptr("5912"),
		// 						DbUsername: to.Ptr("Db2OPA"),
		// 						Hostname: to.Ptr("vmname.azure.com"),
		// 						SapSid: to.Ptr("SID"),
		// 						SSLCertificateURI: to.Ptr("https://storageaccount.blob.core.windows.net/containername/filename"),
		// 						SSLPreference: to.Ptr(armworkloads.SSLPreferenceServerCertificate),
		// 					},
		// 					ProvisioningState: to.Ptr(armworkloads.WorkloadMonitorProvisioningStateSucceeded),
		// 				},
		// 		}},
		// 	}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/workloads/resource-manager/Microsoft.Workloads/stable/2023-04-01/examples/workloadmonitor/Db2ProviderInstances_Get.json
func ExampleProviderInstancesClient_Get_getPropertiesOfADb2Provider() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armworkloads.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewProviderInstancesClient().Get(ctx, "myResourceGroup", "mySapMonitor", "myProviderInstance", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ProviderInstance = armworkloads.ProviderInstance{
	// 	Name: to.Ptr("myProviderInstance"),
	// 	Type: to.Ptr("Microsoft.Workloads/monitors/providerInstances"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Workloads/monitors/mySapMonitor/providerInstances/myProviderInstance"),
	// 	SystemData: &armworkloads.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T15:10:46.196Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@xyz.com"),
	// 		CreatedByType: to.Ptr(armworkloads.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T15:10:46.196Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user@xyz.com"),
	// 		LastModifiedByType: to.Ptr(armworkloads.CreatedByTypeUser),
	// 	},
	// 	Properties: &armworkloads.ProviderInstanceProperties{
	// 		ProviderSettings: &armworkloads.DB2ProviderInstanceProperties{
	// 			ProviderType: to.Ptr("Db2"),
	// 			DbName: to.Ptr("OPA"),
	// 			DbPasswordURI: to.Ptr(""),
	// 			DbPort: to.Ptr("5912"),
	// 			DbUsername: to.Ptr("Db2OPA"),
	// 			Hostname: to.Ptr("vmname.azure.com"),
	// 			SapSid: to.Ptr("SID"),
	// 			SSLCertificateURI: to.Ptr("https://storageaccount.blob.core.windows.net/containername/filename"),
	// 			SSLPreference: to.Ptr(armworkloads.SSLPreferenceServerCertificate),
	// 		},
	// 		ProvisioningState: to.Ptr(armworkloads.WorkloadMonitorProvisioningStateSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/workloads/resource-manager/Microsoft.Workloads/stable/2023-04-01/examples/workloadmonitor/MsSqlServerProviderInstance_Get.json
func ExampleProviderInstancesClient_Get_getPropertiesOfAMsSqlServerProvider() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armworkloads.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewProviderInstancesClient().Get(ctx, "myResourceGroup", "mySapMonitor", "myProviderInstance", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ProviderInstance = armworkloads.ProviderInstance{
	// 	Name: to.Ptr("myProviderInstance"),
	// 	Type: to.Ptr("Microsoft.Workloads/monitors/providerInstances"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Workloads/monitors/mySapMonitor/providerInstances/myProviderInstance"),
	// 	SystemData: &armworkloads.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T15:10:46.196Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@xyz.com"),
	// 		CreatedByType: to.Ptr(armworkloads.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T15:10:46.196Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user@xyz.com"),
	// 		LastModifiedByType: to.Ptr(armworkloads.CreatedByTypeUser),
	// 	},
	// 	Properties: &armworkloads.ProviderInstanceProperties{
	// 		ProviderSettings: &armworkloads.MsSQLServerProviderInstanceProperties{
	// 			ProviderType: to.Ptr("MsSqlServer"),
	// 			DbPasswordURI: to.Ptr(""),
	// 			DbPort: to.Ptr("5912"),
	// 			DbUsername: to.Ptr("user"),
	// 			Hostname: to.Ptr("hostname"),
	// 			SapSid: to.Ptr("sid"),
	// 			SSLCertificateURI: to.Ptr("https://storageaccount.blob.core.windows.net/containername/filename"),
	// 			SSLPreference: to.Ptr(armworkloads.SSLPreferenceServerCertificate),
	// 		},
	// 		ProvisioningState: to.Ptr(armworkloads.WorkloadMonitorProvisioningStateSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/workloads/resource-manager/Microsoft.Workloads/stable/2023-04-01/examples/workloadmonitor/PrometheusOSProviderInstances_Get.json
func ExampleProviderInstancesClient_Get_getPropertiesOfAOsProvider() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armworkloads.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewProviderInstancesClient().Get(ctx, "myResourceGroup", "mySapMonitor", "myProviderInstance", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ProviderInstance = armworkloads.ProviderInstance{
	// 	Name: to.Ptr("myProviderInstance"),
	// 	Type: to.Ptr("Microsoft.Workloads/monitors/providerInstances"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Workloads/monitors/mySapMonitor/providerInstances/myProviderInstance"),
	// 	SystemData: &armworkloads.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T15:10:46.196Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@xyz.com"),
	// 		CreatedByType: to.Ptr(armworkloads.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T15:10:46.196Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user@xyz.com"),
	// 		LastModifiedByType: to.Ptr(armworkloads.CreatedByTypeUser),
	// 	},
	// 	Properties: &armworkloads.ProviderInstanceProperties{
	// 		ProviderSettings: &armworkloads.PrometheusOSProviderInstanceProperties{
	// 			ProviderType: to.Ptr("PrometheusOS"),
	// 			PrometheusURL: to.Ptr("http://192.168.0.0:9090/metrics"),
	// 			SapSid: to.Ptr("SID"),
	// 			SSLCertificateURI: to.Ptr("https://storageaccount.blob.core.windows.net/containername/filename"),
	// 			SSLPreference: to.Ptr(armworkloads.SSLPreferenceServerCertificate),
	// 		},
	// 		ProvisioningState: to.Ptr(armworkloads.WorkloadMonitorProvisioningStateSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/workloads/resource-manager/Microsoft.Workloads/stable/2023-04-01/examples/workloadmonitor/PrometheusHaClusterProviderInstances_Get.json
func ExampleProviderInstancesClient_Get_getPropertiesOfAPrometheusHaClusterProvider() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armworkloads.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewProviderInstancesClient().Get(ctx, "myResourceGroup", "mySapMonitor", "myProviderInstance", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ProviderInstance = armworkloads.ProviderInstance{
	// 	Name: to.Ptr("myProviderInstance"),
	// 	Type: to.Ptr("Microsoft.Workloads/monitors/providerInstances"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Workloads/monitors/mySapMonitor/providerInstances/myProviderInstance"),
	// 	SystemData: &armworkloads.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T15:10:46.196Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@xyz.com"),
	// 		CreatedByType: to.Ptr(armworkloads.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T15:10:46.196Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user@xyz.com"),
	// 		LastModifiedByType: to.Ptr(armworkloads.CreatedByTypeUser),
	// 	},
	// 	Properties: &armworkloads.ProviderInstanceProperties{
	// 		ProviderSettings: &armworkloads.PrometheusHaClusterProviderInstanceProperties{
	// 			ProviderType: to.Ptr("PrometheusHaCluster"),
	// 			ClusterName: to.Ptr("clusterName"),
	// 			Hostname: to.Ptr("hostname"),
	// 			PrometheusURL: to.Ptr("http://192.168.0.0:9090/metrics"),
	// 			Sid: to.Ptr("sid"),
	// 			SSLCertificateURI: to.Ptr("https://storageaccount.blob.core.windows.net/containername/filename"),
	// 			SSLPreference: to.Ptr(armworkloads.SSLPreferenceServerCertificate),
	// 		},
	// 		ProvisioningState: to.Ptr(armworkloads.WorkloadMonitorProvisioningStateSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/workloads/resource-manager/Microsoft.Workloads/stable/2023-04-01/examples/workloadmonitor/ProviderInstances_Get.json
func ExampleProviderInstancesClient_Get_getPropertiesOfASapMonitorHanaProvider() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armworkloads.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewProviderInstancesClient().Get(ctx, "myResourceGroup", "mySapMonitor", "myProviderInstance", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ProviderInstance = armworkloads.ProviderInstance{
	// 	Name: to.Ptr("myProviderInstance"),
	// 	Type: to.Ptr("Microsoft.Workloads/monitors/providerInstances"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Workloads/monitors/mySapMonitor/providerInstances/myProviderInstance"),
	// 	SystemData: &armworkloads.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T15:10:46.196Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@xyz.com"),
	// 		CreatedByType: to.Ptr(armworkloads.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T15:10:46.196Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user@xyz.com"),
	// 		LastModifiedByType: to.Ptr(armworkloads.CreatedByTypeUser),
	// 	},
	// 	Properties: &armworkloads.ProviderInstanceProperties{
	// 		ProviderSettings: &armworkloads.HanaDbProviderInstanceProperties{
	// 			ProviderType: to.Ptr("SapHana"),
	// 			DbName: to.Ptr("db"),
	// 			DbPasswordURI: to.Ptr(""),
	// 			DbUsername: to.Ptr("user"),
	// 			Hostname: to.Ptr("name"),
	// 			InstanceNumber: to.Ptr("00"),
	// 			SapSid: to.Ptr("SID"),
	// 			SQLPort: to.Ptr("0000"),
	// 			SSLCertificateURI: to.Ptr("https://storageaccount.blob.core.windows.net/containername/filename"),
	// 			SSLHostNameInCertificate: to.Ptr("xyz.domain.com"),
	// 			SSLPreference: to.Ptr(armworkloads.SSLPreferenceServerCertificate),
	// 		},
	// 		ProvisioningState: to.Ptr(armworkloads.WorkloadMonitorProvisioningStateSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/workloads/resource-manager/Microsoft.Workloads/stable/2023-04-01/examples/workloadmonitor/NetWeaverProviderInstances_Get.json
func ExampleProviderInstancesClient_Get_getPropertiesOfASapMonitorNetWeaverProvider() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armworkloads.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewProviderInstancesClient().Get(ctx, "myResourceGroup", "mySapMonitor", "myProviderInstance", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ProviderInstance = armworkloads.ProviderInstance{
	// 	Name: to.Ptr("myProviderInstance"),
	// 	Type: to.Ptr("Microsoft.Workloads/monitors/providerInstances"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Workloads/monitors/mySapMonitor/providerInstances/myProviderInstance"),
	// 	SystemData: &armworkloads.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T15:10:46.196Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@xyz.com"),
	// 		CreatedByType: to.Ptr(armworkloads.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T15:10:46.196Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user@xyz.com"),
	// 		LastModifiedByType: to.Ptr(armworkloads.CreatedByTypeUser),
	// 	},
	// 	Properties: &armworkloads.ProviderInstanceProperties{
	// 		ProviderSettings: &armworkloads.SapNetWeaverProviderInstanceProperties{
	// 			ProviderType: to.Ptr("SapNetWeaver"),
	// 			SapClientID: to.Ptr("111"),
	// 			SapHostFileEntries: []*string{
	// 				to.Ptr("127.0.0.1 name fqdn")},
	// 				SapHostname: to.Ptr("name"),
	// 				SapInstanceNr: to.Ptr("00"),
	// 				SapPasswordURI: to.Ptr(""),
	// 				SapPortNumber: to.Ptr("1234"),
	// 				SapSid: to.Ptr("SID"),
	// 				SapUsername: to.Ptr("username"),
	// 				SSLCertificateURI: to.Ptr("https://storageaccount.blob.core.windows.net/containername/filename"),
	// 				SSLPreference: to.Ptr(armworkloads.SSLPreferenceServerCertificate),
	// 			},
	// 			ProvisioningState: to.Ptr(armworkloads.WorkloadMonitorProvisioningStateSucceeded),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/workloads/resource-manager/Microsoft.Workloads/stable/2023-04-01/examples/workloadmonitor/Db2ProviderInstances_Create.json
func ExampleProviderInstancesClient_BeginCreate_createADb2Provider() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armworkloads.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewProviderInstancesClient().BeginCreate(ctx, "myResourceGroup", "mySapMonitor", "myProviderInstance", armworkloads.ProviderInstance{
		Properties: &armworkloads.ProviderInstanceProperties{
			ProviderSettings: &armworkloads.DB2ProviderInstanceProperties{
				ProviderType:      to.Ptr("Db2"),
				DbName:            to.Ptr("dbName"),
				DbPassword:        to.Ptr("password"),
				DbPasswordURI:     to.Ptr(""),
				DbPort:            to.Ptr("dbPort"),
				DbUsername:        to.Ptr("username"),
				Hostname:          to.Ptr("hostname"),
				SapSid:            to.Ptr("SID"),
				SSLCertificateURI: to.Ptr("https://storageaccount.blob.core.windows.net/containername/filename"),
				SSLPreference:     to.Ptr(armworkloads.SSLPreferenceServerCertificate),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ProviderInstance = armworkloads.ProviderInstance{
	// 	Name: to.Ptr("myProviderInstance"),
	// 	Type: to.Ptr("Microsoft.Workloads/monitors/providerInstances"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Workloads/monitors/mySapMonitor/providerInstances/myProviderInstance"),
	// 	SystemData: &armworkloads.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T15:10:46.196Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@xyz.com"),
	// 		CreatedByType: to.Ptr(armworkloads.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T15:10:46.196Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user@xyz.com"),
	// 		LastModifiedByType: to.Ptr(armworkloads.CreatedByTypeUser),
	// 	},
	// 	Properties: &armworkloads.ProviderInstanceProperties{
	// 		ProviderSettings: &armworkloads.DB2ProviderInstanceProperties{
	// 			ProviderType: to.Ptr("Db2"),
	// 			DbName: to.Ptr("OPA"),
	// 			DbPasswordURI: to.Ptr(""),
	// 			DbPort: to.Ptr("5912"),
	// 			DbUsername: to.Ptr("Db2OPA"),
	// 			Hostname: to.Ptr("vmname.azure.com"),
	// 			SapSid: to.Ptr("SID"),
	// 			SSLCertificateURI: to.Ptr("https://storageaccount.blob.core.windows.net/containername/filename"),
	// 			SSLPreference: to.Ptr(armworkloads.SSLPreferenceServerCertificate),
	// 		},
	// 		ProvisioningState: to.Ptr(armworkloads.WorkloadMonitorProvisioningStateSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/workloads/resource-manager/Microsoft.Workloads/stable/2023-04-01/examples/workloadmonitor/Db2ProviderInstances_Create_Root_Certificate.json
func ExampleProviderInstancesClient_BeginCreate_createADb2ProviderWithRootCertificate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armworkloads.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewProviderInstancesClient().BeginCreate(ctx, "myResourceGroup", "mySapMonitor", "myProviderInstance", armworkloads.ProviderInstance{
		Properties: &armworkloads.ProviderInstanceProperties{
			ProviderSettings: &armworkloads.DB2ProviderInstanceProperties{
				ProviderType:  to.Ptr("Db2"),
				DbName:        to.Ptr("dbName"),
				DbPassword:    to.Ptr("password"),
				DbPasswordURI: to.Ptr(""),
				DbPort:        to.Ptr("dbPort"),
				DbUsername:    to.Ptr("username"),
				Hostname:      to.Ptr("hostname"),
				SapSid:        to.Ptr("SID"),
				SSLPreference: to.Ptr(armworkloads.SSLPreferenceRootCertificate),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ProviderInstance = armworkloads.ProviderInstance{
	// 	Name: to.Ptr("myProviderInstance"),
	// 	Type: to.Ptr("Microsoft.Workloads/monitors/providerInstances"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Workloads/monitors/mySapMonitor/providerInstances/myProviderInstance"),
	// 	SystemData: &armworkloads.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T15:10:46.196Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@xyz.com"),
	// 		CreatedByType: to.Ptr(armworkloads.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T15:10:46.196Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user@xyz.com"),
	// 		LastModifiedByType: to.Ptr(armworkloads.CreatedByTypeUser),
	// 	},
	// 	Properties: &armworkloads.ProviderInstanceProperties{
	// 		ProviderSettings: &armworkloads.DB2ProviderInstanceProperties{
	// 			ProviderType: to.Ptr("Db2"),
	// 			DbName: to.Ptr("OPA"),
	// 			DbPasswordURI: to.Ptr(""),
	// 			DbPort: to.Ptr("5912"),
	// 			DbUsername: to.Ptr("Db2OPA"),
	// 			Hostname: to.Ptr("vmname.azure.com"),
	// 			SapSid: to.Ptr("SID"),
	// 			SSLPreference: to.Ptr(armworkloads.SSLPreferenceRootCertificate),
	// 		},
	// 		ProvisioningState: to.Ptr(armworkloads.WorkloadMonitorProvisioningStateSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/workloads/resource-manager/Microsoft.Workloads/stable/2023-04-01/examples/workloadmonitor/MsSqlServerProviderInstance_Create.json
func ExampleProviderInstancesClient_BeginCreate_createAMsSqlServerProvider() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armworkloads.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewProviderInstancesClient().BeginCreate(ctx, "myResourceGroup", "mySapMonitor", "myProviderInstance", armworkloads.ProviderInstance{
		Properties: &armworkloads.ProviderInstanceProperties{
			ProviderSettings: &armworkloads.MsSQLServerProviderInstanceProperties{
				ProviderType:      to.Ptr("MsSqlServer"),
				DbPassword:        to.Ptr("****"),
				DbPasswordURI:     to.Ptr(""),
				DbPort:            to.Ptr("5912"),
				DbUsername:        to.Ptr("user"),
				Hostname:          to.Ptr("hostname"),
				SapSid:            to.Ptr("sid"),
				SSLCertificateURI: to.Ptr("https://storageaccount.blob.core.windows.net/containername/filename"),
				SSLPreference:     to.Ptr(armworkloads.SSLPreferenceServerCertificate),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ProviderInstance = armworkloads.ProviderInstance{
	// 	Name: to.Ptr("myProviderInstance"),
	// 	Type: to.Ptr("Microsoft.Workloads/monitors/providerInstances"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Workloads/monitors/mySapMonitor/providerInstances/myProviderInstance"),
	// 	SystemData: &armworkloads.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T15:10:46.196Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@xyz.com"),
	// 		CreatedByType: to.Ptr(armworkloads.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T15:10:46.196Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user@xyz.com"),
	// 		LastModifiedByType: to.Ptr(armworkloads.CreatedByTypeUser),
	// 	},
	// 	Properties: &armworkloads.ProviderInstanceProperties{
	// 		ProviderSettings: &armworkloads.MsSQLServerProviderInstanceProperties{
	// 			ProviderType: to.Ptr("MsSqlServer"),
	// 			DbPort: to.Ptr("5912"),
	// 			DbUsername: to.Ptr("user"),
	// 			Hostname: to.Ptr("hostname"),
	// 			SapSid: to.Ptr("sid"),
	// 			SSLCertificateURI: to.Ptr("https://storageaccount.blob.core.windows.net/containername/filename"),
	// 			SSLPreference: to.Ptr(armworkloads.SSLPreferenceServerCertificate),
	// 		},
	// 		ProvisioningState: to.Ptr(armworkloads.WorkloadMonitorProvisioningStateSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/workloads/resource-manager/Microsoft.Workloads/stable/2023-04-01/examples/workloadmonitor/MsSqlServerProviderInstance_Create_Root_Certificate.json
func ExampleProviderInstancesClient_BeginCreate_createAMsSqlServerProviderWithRootCertificate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armworkloads.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewProviderInstancesClient().BeginCreate(ctx, "myResourceGroup", "mySapMonitor", "myProviderInstance", armworkloads.ProviderInstance{
		Properties: &armworkloads.ProviderInstanceProperties{
			ProviderSettings: &armworkloads.MsSQLServerProviderInstanceProperties{
				ProviderType:  to.Ptr("MsSqlServer"),
				DbPassword:    to.Ptr("****"),
				DbPasswordURI: to.Ptr(""),
				DbPort:        to.Ptr("5912"),
				DbUsername:    to.Ptr("user"),
				Hostname:      to.Ptr("hostname"),
				SapSid:        to.Ptr("sid"),
				SSLPreference: to.Ptr(armworkloads.SSLPreferenceRootCertificate),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ProviderInstance = armworkloads.ProviderInstance{
	// 	Name: to.Ptr("myProviderInstance"),
	// 	Type: to.Ptr("Microsoft.Workloads/monitors/providerInstances"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Workloads/monitors/mySapMonitor/providerInstances/myProviderInstance"),
	// 	SystemData: &armworkloads.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T15:10:46.196Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@xyz.com"),
	// 		CreatedByType: to.Ptr(armworkloads.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T15:10:46.196Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user@xyz.com"),
	// 		LastModifiedByType: to.Ptr(armworkloads.CreatedByTypeUser),
	// 	},
	// 	Properties: &armworkloads.ProviderInstanceProperties{
	// 		ProviderSettings: &armworkloads.MsSQLServerProviderInstanceProperties{
	// 			ProviderType: to.Ptr("MsSqlServer"),
	// 			DbPort: to.Ptr("5912"),
	// 			DbUsername: to.Ptr("user"),
	// 			Hostname: to.Ptr("hostname"),
	// 			SapSid: to.Ptr("sid"),
	// 			SSLPreference: to.Ptr(armworkloads.SSLPreferenceRootCertificate),
	// 		},
	// 		ProvisioningState: to.Ptr(armworkloads.WorkloadMonitorProvisioningStateSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/workloads/resource-manager/Microsoft.Workloads/stable/2023-04-01/examples/workloadmonitor/PrometheusOSProviderInstances_Create.json
func ExampleProviderInstancesClient_BeginCreate_createAOsProvider() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armworkloads.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewProviderInstancesClient().BeginCreate(ctx, "myResourceGroup", "mySapMonitor", "myProviderInstance", armworkloads.ProviderInstance{
		Properties: &armworkloads.ProviderInstanceProperties{
			ProviderSettings: &armworkloads.PrometheusOSProviderInstanceProperties{
				ProviderType:      to.Ptr("PrometheusOS"),
				PrometheusURL:     to.Ptr("http://192.168.0.0:9090/metrics"),
				SapSid:            to.Ptr("SID"),
				SSLCertificateURI: to.Ptr("https://storageaccount.blob.core.windows.net/containername/filename"),
				SSLPreference:     to.Ptr(armworkloads.SSLPreferenceServerCertificate),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ProviderInstance = armworkloads.ProviderInstance{
	// 	Name: to.Ptr("myProviderInstance"),
	// 	Type: to.Ptr("Microsoft.Workloads/monitors/providerInstances"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Workloads/monitors/mySapMonitor/providerInstances/myProviderInstance"),
	// 	SystemData: &armworkloads.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T15:10:46.196Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@xyz.com"),
	// 		CreatedByType: to.Ptr(armworkloads.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T15:10:46.196Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user@xyz.com"),
	// 		LastModifiedByType: to.Ptr(armworkloads.CreatedByTypeUser),
	// 	},
	// 	Properties: &armworkloads.ProviderInstanceProperties{
	// 		ProviderSettings: &armworkloads.PrometheusOSProviderInstanceProperties{
	// 			ProviderType: to.Ptr("PrometheusOS"),
	// 			PrometheusURL: to.Ptr("http://192.168.0.0:9090/metrics"),
	// 			SapSid: to.Ptr("SID"),
	// 			SSLCertificateURI: to.Ptr("https://storageaccount.blob.core.windows.net/containername/filename"),
	// 			SSLPreference: to.Ptr(armworkloads.SSLPreferenceServerCertificate),
	// 		},
	// 		ProvisioningState: to.Ptr(armworkloads.WorkloadMonitorProvisioningStateSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/workloads/resource-manager/Microsoft.Workloads/stable/2023-04-01/examples/workloadmonitor/PrometheusOSProviderInstances_Create_Root_Certificate.json
func ExampleProviderInstancesClient_BeginCreate_createAOsProviderWithRootCertificate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armworkloads.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewProviderInstancesClient().BeginCreate(ctx, "myResourceGroup", "mySapMonitor", "myProviderInstance", armworkloads.ProviderInstance{
		Properties: &armworkloads.ProviderInstanceProperties{
			ProviderSettings: &armworkloads.PrometheusOSProviderInstanceProperties{
				ProviderType:  to.Ptr("PrometheusOS"),
				PrometheusURL: to.Ptr("http://192.168.0.0:9090/metrics"),
				SapSid:        to.Ptr("SID"),
				SSLPreference: to.Ptr(armworkloads.SSLPreferenceRootCertificate),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ProviderInstance = armworkloads.ProviderInstance{
	// 	Name: to.Ptr("myProviderInstance"),
	// 	Type: to.Ptr("Microsoft.Workloads/monitors/providerInstances"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Workloads/monitors/mySapMonitor/providerInstances/myProviderInstance"),
	// 	SystemData: &armworkloads.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T15:10:46.196Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@xyz.com"),
	// 		CreatedByType: to.Ptr(armworkloads.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T15:10:46.196Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user@xyz.com"),
	// 		LastModifiedByType: to.Ptr(armworkloads.CreatedByTypeUser),
	// 	},
	// 	Properties: &armworkloads.ProviderInstanceProperties{
	// 		ProviderSettings: &armworkloads.PrometheusOSProviderInstanceProperties{
	// 			ProviderType: to.Ptr("PrometheusOS"),
	// 			PrometheusURL: to.Ptr("http://192.168.0.0:9090/metrics"),
	// 			SapSid: to.Ptr("SID"),
	// 			SSLPreference: to.Ptr(armworkloads.SSLPreferenceRootCertificate),
	// 		},
	// 		ProvisioningState: to.Ptr(armworkloads.WorkloadMonitorProvisioningStateSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/workloads/resource-manager/Microsoft.Workloads/stable/2023-04-01/examples/workloadmonitor/PrometheusHaClusterProviderInstances_Create.json
func ExampleProviderInstancesClient_BeginCreate_createAPrometheusHaClusterProvider() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armworkloads.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewProviderInstancesClient().BeginCreate(ctx, "myResourceGroup", "mySapMonitor", "myProviderInstance", armworkloads.ProviderInstance{
		Properties: &armworkloads.ProviderInstanceProperties{
			ProviderSettings: &armworkloads.PrometheusHaClusterProviderInstanceProperties{
				ProviderType:      to.Ptr("PrometheusHaCluster"),
				ClusterName:       to.Ptr("clusterName"),
				Hostname:          to.Ptr("hostname"),
				PrometheusURL:     to.Ptr("http://192.168.0.0:9090/metrics"),
				Sid:               to.Ptr("sid"),
				SSLCertificateURI: to.Ptr("https://storageaccount.blob.core.windows.net/containername/filename"),
				SSLPreference:     to.Ptr(armworkloads.SSLPreferenceServerCertificate),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ProviderInstance = armworkloads.ProviderInstance{
	// 	Name: to.Ptr("myProviderInstance"),
	// 	Type: to.Ptr("Microsoft.Workloads/monitors/providerInstances"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Workloads/monitors/mySapMonitor/providerInstances/myProviderInstance"),
	// 	SystemData: &armworkloads.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T15:10:46.196Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@xyz.com"),
	// 		CreatedByType: to.Ptr(armworkloads.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T15:10:46.196Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user@xyz.com"),
	// 		LastModifiedByType: to.Ptr(armworkloads.CreatedByTypeUser),
	// 	},
	// 	Properties: &armworkloads.ProviderInstanceProperties{
	// 		ProviderSettings: &armworkloads.PrometheusHaClusterProviderInstanceProperties{
	// 			ProviderType: to.Ptr("PrometheusHaCluster"),
	// 			ClusterName: to.Ptr("clusterName"),
	// 			Hostname: to.Ptr("hostname"),
	// 			PrometheusURL: to.Ptr("http://192.168.0.0:9090/metrics"),
	// 			Sid: to.Ptr("sid"),
	// 			SSLCertificateURI: to.Ptr("https://storageaccount.blob.core.windows.net/containername/filename"),
	// 			SSLPreference: to.Ptr(armworkloads.SSLPreferenceServerCertificate),
	// 		},
	// 		ProvisioningState: to.Ptr(armworkloads.WorkloadMonitorProvisioningStateSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/workloads/resource-manager/Microsoft.Workloads/stable/2023-04-01/examples/workloadmonitor/PrometheusHaClusterProviderInstances_Create_Root_Certificate.json
func ExampleProviderInstancesClient_BeginCreate_createAPrometheusHaClusterProviderWithRootCertificate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armworkloads.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewProviderInstancesClient().BeginCreate(ctx, "myResourceGroup", "mySapMonitor", "myProviderInstance", armworkloads.ProviderInstance{
		Properties: &armworkloads.ProviderInstanceProperties{
			ProviderSettings: &armworkloads.PrometheusHaClusterProviderInstanceProperties{
				ProviderType:  to.Ptr("PrometheusHaCluster"),
				ClusterName:   to.Ptr("clusterName"),
				Hostname:      to.Ptr("hostname"),
				PrometheusURL: to.Ptr("http://192.168.0.0:9090/metrics"),
				Sid:           to.Ptr("sid"),
				SSLPreference: to.Ptr(armworkloads.SSLPreferenceRootCertificate),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ProviderInstance = armworkloads.ProviderInstance{
	// 	Name: to.Ptr("myProviderInstance"),
	// 	Type: to.Ptr("Microsoft.Workloads/monitors/providerInstances"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Workloads/monitors/mySapMonitor/providerInstances/myProviderInstance"),
	// 	SystemData: &armworkloads.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T15:10:46.196Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@xyz.com"),
	// 		CreatedByType: to.Ptr(armworkloads.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T15:10:46.196Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user@xyz.com"),
	// 		LastModifiedByType: to.Ptr(armworkloads.CreatedByTypeUser),
	// 	},
	// 	Properties: &armworkloads.ProviderInstanceProperties{
	// 		ProviderSettings: &armworkloads.PrometheusHaClusterProviderInstanceProperties{
	// 			ProviderType: to.Ptr("PrometheusHaCluster"),
	// 			ClusterName: to.Ptr("clusterName"),
	// 			Hostname: to.Ptr("hostname"),
	// 			PrometheusURL: to.Ptr("http://192.168.0.0:9090/metrics"),
	// 			Sid: to.Ptr("sid"),
	// 			SSLPreference: to.Ptr(armworkloads.SSLPreferenceRootCertificate),
	// 		},
	// 		ProvisioningState: to.Ptr(armworkloads.WorkloadMonitorProvisioningStateSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/workloads/resource-manager/Microsoft.Workloads/stable/2023-04-01/examples/workloadmonitor/ProviderInstances_Create.json
func ExampleProviderInstancesClient_BeginCreate_createASapMonitorHanaProvider() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armworkloads.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewProviderInstancesClient().BeginCreate(ctx, "myResourceGroup", "mySapMonitor", "myProviderInstance", armworkloads.ProviderInstance{
		Properties: &armworkloads.ProviderInstanceProperties{
			ProviderSettings: &armworkloads.HanaDbProviderInstanceProperties{
				ProviderType:             to.Ptr("SapHana"),
				DbName:                   to.Ptr("db"),
				DbPassword:               to.Ptr("****"),
				DbPasswordURI:            to.Ptr(""),
				DbUsername:               to.Ptr("user"),
				Hostname:                 to.Ptr("name"),
				InstanceNumber:           to.Ptr("00"),
				SapSid:                   to.Ptr("SID"),
				SQLPort:                  to.Ptr("0000"),
				SSLCertificateURI:        to.Ptr("https://storageaccount.blob.core.windows.net/containername/filename"),
				SSLHostNameInCertificate: to.Ptr("xyz.domain.com"),
				SSLPreference:            to.Ptr(armworkloads.SSLPreferenceServerCertificate),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ProviderInstance = armworkloads.ProviderInstance{
	// 	Name: to.Ptr("myProviderInstance"),
	// 	Type: to.Ptr("Microsoft.Workloads/monitors/providerInstances"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Workloads/monitors/mySapMonitor/providerInstances/myProviderInstance"),
	// 	SystemData: &armworkloads.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T15:10:46.196Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@xyz.com"),
	// 		CreatedByType: to.Ptr(armworkloads.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T15:10:46.196Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user@xyz.com"),
	// 		LastModifiedByType: to.Ptr(armworkloads.CreatedByTypeUser),
	// 	},
	// 	Properties: &armworkloads.ProviderInstanceProperties{
	// 		ProviderSettings: &armworkloads.HanaDbProviderInstanceProperties{
	// 			ProviderType: to.Ptr("SapHana"),
	// 			DbName: to.Ptr("db"),
	// 			DbPasswordURI: to.Ptr(""),
	// 			DbUsername: to.Ptr("user"),
	// 			Hostname: to.Ptr("name"),
	// 			InstanceNumber: to.Ptr("00"),
	// 			SapSid: to.Ptr("SID"),
	// 			SQLPort: to.Ptr("0000"),
	// 			SSLCertificateURI: to.Ptr("https://storageaccount.blob.core.windows.net/containername/filename"),
	// 			SSLHostNameInCertificate: to.Ptr("xyz.domain.com"),
	// 			SSLPreference: to.Ptr(armworkloads.SSLPreferenceServerCertificate),
	// 		},
	// 		ProvisioningState: to.Ptr(armworkloads.WorkloadMonitorProvisioningStateSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/workloads/resource-manager/Microsoft.Workloads/stable/2023-04-01/examples/workloadmonitor/ProviderInstances_Create_Root_Certificate.json
func ExampleProviderInstancesClient_BeginCreate_createASapMonitorHanaProviderWithRootCertificate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armworkloads.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewProviderInstancesClient().BeginCreate(ctx, "myResourceGroup", "mySapMonitor", "myProviderInstance", armworkloads.ProviderInstance{
		Properties: &armworkloads.ProviderInstanceProperties{
			ProviderSettings: &armworkloads.HanaDbProviderInstanceProperties{
				ProviderType:             to.Ptr("SapHana"),
				DbName:                   to.Ptr("db"),
				DbPassword:               to.Ptr("****"),
				DbPasswordURI:            to.Ptr(""),
				DbUsername:               to.Ptr("user"),
				Hostname:                 to.Ptr("name"),
				InstanceNumber:           to.Ptr("00"),
				SapSid:                   to.Ptr("SID"),
				SQLPort:                  to.Ptr("0000"),
				SSLHostNameInCertificate: to.Ptr("xyz.domain.com"),
				SSLPreference:            to.Ptr(armworkloads.SSLPreferenceRootCertificate),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ProviderInstance = armworkloads.ProviderInstance{
	// 	Name: to.Ptr("myProviderInstance"),
	// 	Type: to.Ptr("Microsoft.Workloads/monitors/providerInstances"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Workloads/monitors/mySapMonitor/providerInstances/myProviderInstance"),
	// 	SystemData: &armworkloads.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T15:10:46.196Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@xyz.com"),
	// 		CreatedByType: to.Ptr(armworkloads.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T15:10:46.196Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user@xyz.com"),
	// 		LastModifiedByType: to.Ptr(armworkloads.CreatedByTypeUser),
	// 	},
	// 	Properties: &armworkloads.ProviderInstanceProperties{
	// 		ProviderSettings: &armworkloads.HanaDbProviderInstanceProperties{
	// 			ProviderType: to.Ptr("SapHana"),
	// 			DbName: to.Ptr("db"),
	// 			DbPasswordURI: to.Ptr(""),
	// 			DbUsername: to.Ptr("user"),
	// 			Hostname: to.Ptr("name"),
	// 			InstanceNumber: to.Ptr("00"),
	// 			SapSid: to.Ptr("SID"),
	// 			SQLPort: to.Ptr("0000"),
	// 			SSLHostNameInCertificate: to.Ptr("xyz.domain.com"),
	// 			SSLPreference: to.Ptr(armworkloads.SSLPreferenceRootCertificate),
	// 		},
	// 		ProvisioningState: to.Ptr(armworkloads.WorkloadMonitorProvisioningStateSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/workloads/resource-manager/Microsoft.Workloads/stable/2023-04-01/examples/workloadmonitor/NetWeaverProviderInstances_Create.json
func ExampleProviderInstancesClient_BeginCreate_createASapMonitorNetWeaverProvider() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armworkloads.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewProviderInstancesClient().BeginCreate(ctx, "myResourceGroup", "mySapMonitor", "myProviderInstance", armworkloads.ProviderInstance{
		Properties: &armworkloads.ProviderInstanceProperties{
			ProviderSettings: &armworkloads.SapNetWeaverProviderInstanceProperties{
				ProviderType: to.Ptr("SapNetWeaver"),
				SapClientID:  to.Ptr("111"),
				SapHostFileEntries: []*string{
					to.Ptr("127.0.0.1 name fqdn")},
				SapHostname:       to.Ptr("name"),
				SapInstanceNr:     to.Ptr("00"),
				SapPassword:       to.Ptr("****"),
				SapPasswordURI:    to.Ptr(""),
				SapPortNumber:     to.Ptr("1234"),
				SapSid:            to.Ptr("SID"),
				SapUsername:       to.Ptr("username"),
				SSLCertificateURI: to.Ptr("https://storageaccount.blob.core.windows.net/containername/filename"),
				SSLPreference:     to.Ptr(armworkloads.SSLPreferenceServerCertificate),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ProviderInstance = armworkloads.ProviderInstance{
	// 	Name: to.Ptr("myProviderInstance"),
	// 	Type: to.Ptr("Microsoft.Workloads/monitors/providerInstances"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Workloads/monitors/mySapMonitor/providerInstances/myProviderInstance"),
	// 	SystemData: &armworkloads.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T15:10:46.196Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@xyz.com"),
	// 		CreatedByType: to.Ptr(armworkloads.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T15:10:46.196Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user@xyz.com"),
	// 		LastModifiedByType: to.Ptr(armworkloads.CreatedByTypeUser),
	// 	},
	// 	Properties: &armworkloads.ProviderInstanceProperties{
	// 		ProviderSettings: &armworkloads.SapNetWeaverProviderInstanceProperties{
	// 			ProviderType: to.Ptr("SapNetWeaver"),
	// 			SapClientID: to.Ptr("111"),
	// 			SapHostFileEntries: []*string{
	// 				to.Ptr("127.0.0.1 name fqdn")},
	// 				SapHostname: to.Ptr("name"),
	// 				SapInstanceNr: to.Ptr("00"),
	// 				SapPasswordURI: to.Ptr(""),
	// 				SapPortNumber: to.Ptr("1234"),
	// 				SapSid: to.Ptr("SID"),
	// 				SapUsername: to.Ptr("username"),
	// 				SSLCertificateURI: to.Ptr("https://storageaccount.blob.core.windows.net/containername/filename"),
	// 				SSLPreference: to.Ptr(armworkloads.SSLPreferenceServerCertificate),
	// 			},
	// 			ProvisioningState: to.Ptr(armworkloads.WorkloadMonitorProvisioningStateSucceeded),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/workloads/resource-manager/Microsoft.Workloads/stable/2023-04-01/examples/workloadmonitor/NetWeaverProviderInstances_Create_Root_Certificate.json
func ExampleProviderInstancesClient_BeginCreate_createASapMonitorNetWeaverProviderWithRootCertificate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armworkloads.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewProviderInstancesClient().BeginCreate(ctx, "myResourceGroup", "mySapMonitor", "myProviderInstance", armworkloads.ProviderInstance{
		Properties: &armworkloads.ProviderInstanceProperties{
			ProviderSettings: &armworkloads.SapNetWeaverProviderInstanceProperties{
				ProviderType: to.Ptr("SapNetWeaver"),
				SapClientID:  to.Ptr("111"),
				SapHostFileEntries: []*string{
					to.Ptr("127.0.0.1 name fqdn")},
				SapHostname:    to.Ptr("name"),
				SapInstanceNr:  to.Ptr("00"),
				SapPassword:    to.Ptr("****"),
				SapPasswordURI: to.Ptr(""),
				SapPortNumber:  to.Ptr("1234"),
				SapSid:         to.Ptr("SID"),
				SapUsername:    to.Ptr("username"),
				SSLPreference:  to.Ptr(armworkloads.SSLPreferenceRootCertificate),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ProviderInstance = armworkloads.ProviderInstance{
	// 	Name: to.Ptr("myProviderInstance"),
	// 	Type: to.Ptr("Microsoft.Workloads/monitors/providerInstances"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Workloads/monitors/mySapMonitor/providerInstances/myProviderInstance"),
	// 	SystemData: &armworkloads.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T15:10:46.196Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@xyz.com"),
	// 		CreatedByType: to.Ptr(armworkloads.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T15:10:46.196Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user@xyz.com"),
	// 		LastModifiedByType: to.Ptr(armworkloads.CreatedByTypeUser),
	// 	},
	// 	Properties: &armworkloads.ProviderInstanceProperties{
	// 		ProviderSettings: &armworkloads.SapNetWeaverProviderInstanceProperties{
	// 			ProviderType: to.Ptr("SapNetWeaver"),
	// 			SapClientID: to.Ptr("111"),
	// 			SapHostFileEntries: []*string{
	// 				to.Ptr("127.0.0.1 name fqdn")},
	// 				SapHostname: to.Ptr("name"),
	// 				SapInstanceNr: to.Ptr("00"),
	// 				SapPasswordURI: to.Ptr(""),
	// 				SapPortNumber: to.Ptr("1234"),
	// 				SapSid: to.Ptr("SID"),
	// 				SapUsername: to.Ptr("username"),
	// 				SSLPreference: to.Ptr(armworkloads.SSLPreferenceRootCertificate),
	// 			},
	// 			ProvisioningState: to.Ptr(armworkloads.WorkloadMonitorProvisioningStateSucceeded),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/workloads/resource-manager/Microsoft.Workloads/stable/2023-04-01/examples/workloadmonitor/ProviderInstances_Delete.json
func ExampleProviderInstancesClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armworkloads.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewProviderInstancesClient().BeginDelete(ctx, "myResourceGroup", "mySapMonitor", "myProviderInstance", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.OperationStatusResult = armworkloads.OperationStatusResult{
	// 	Name: to.Ptr("1e4193c3-206e-4916-b124-1da16175eb0f"),
	// 	EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T03:38:07.000Z"); return t}()),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Workloads/operations/locations/westus/1e4193c3-206e-4916-b124-1da16175eb0f"),
	// 	StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T03:36:07.000Z"); return t}()),
	// 	Status: to.Ptr("Succeeded"),
	// }
}
