/**
 * This file is part of JS8Call.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * (C) 2018 Jordan Sherer <kn4crd@gmail.com> - All Rights Reserved
 *
 **/
#include "jsc.h"

const Tuple JSC::map[262144] = {
    // str, len, index
	{"E", 1, 0},
	{"T", 1, 1},
	{"A", 1, 2},
	{"O", 1, 3},
	{"I", 1, 4},
	{"N", 1, 5},
	{"S", 1, 6},
	{"H", 1, 7},
	{"R", 1, 8},
	{"D", 1, 9},
	{"L", 1, 10},
	{"C", 1, 11},
	{"U", 1, 12},
	{"M", 1, 13},
	{"W", 1, 14},
	{"F", 1, 15},
	{"G", 1, 16},
	{"Y", 1, 17},
	{"P", 1, 18},
	{"B", 1, 19},
	{",", 1, 20},
	{".", 1, 21},
	{"V", 1, 22},
	{"K", 1, 23},
	{"-", 1, 24},
	{"+", 1, 25},
	{"\"", 1, 26},
	{"?", 1, 27},
	{"!", 1, 28},
	{"'", 1, 29},
	{"X", 1, 30},
	{")", 1, 31},
	{"(", 1, 32},
	{"0", 1, 33},
	{"J", 1, 34},
	{"1", 1, 35},
	{"Q", 1, 36},
	{"=", 1, 37},
	{"2", 1, 38},
	{":", 1, 39},
	{"Z", 1, 40},
	{"3", 1, 41},
	{"5", 1, 42},
	{"4", 1, 43},
	{"9", 1, 44},
	{"8", 1, 45},
	{"6", 1, 46},
	{"7", 1, 47},
	{"_", 1, 48},
	{"/", 1, 49},
	{"&", 1, 50},
	{"$", 1, 51},
	{"%", 1, 52},
	{"#", 1, 53},
	{"@", 1, 54},
	{"*", 1, 55},
	{">", 1, 56},
	{"<", 1, 57},
	{"[", 1, 58},
	{"]", 1, 59},
	{"{", 1, 60},
	{"}", 1, 61},
	{"|", 1, 62},
	{";", 1, 63},
	{"^", 1, 64},
	{"`", 1, 65},
	{"~", 1, 66},
    {" ", 1, 67},
    {"\\", 1, 68}, // FYI: this used to be FT8 in JS8 1.0
    {"\n", 1, 69}, // FYI: this used to be "\" in JS8 1.0
	{"JS8", 3, 70},
	{"JS8CALL", 7, 71},
    {"\x1A", 1, 72}, // FYI: this used to be JSQSO in JS8 1.0, it is now a substitute flag
    {"JSQCALL", 7, 73},
	{"JORDAN", 6, 74},
	{"KN4CRD", 6, 75},
	{"599", 3, 76},
	{"559", 3, 77},
	{"589", 3, 78},
	{"579", 3, 79},
	{"569", 3, 80},
    {"@ALLCALL", 7, 81},
	{"BEACON", 6, 82},
	{"CQCQCQ", 6, 83},
	{"CPY?", 4, 84},
	{"QSL?", 4, 85},
	{"AGN?", 4, 86},
	{"AGN", 3, 87},
	{"ACK", 3, 88},
	{"ABT", 3, 89},
	{"ARES", 4, 90},
	{"APRS", 4, 91},
	{"ARL", 3, 92},
	{"ARRL", 4, 93},
	{"ANS", 3, 94},
	{"ANT", 3, 95},
	{"B4", 2, 96},
	{"BC", 2, 97},
	{"BCN", 3, 98},
	{"BCNU", 4, 99},
	{"BD", 2, 100},
	{"BK", 2, 101},
	{"BN", 2, 102},
	{"BEAM", 4, 103},
	{"BEN", 3, 104},
	{"BTU", 3, 105},
	{"BURO", 4, 106},
	{"CALLSIGN", 8, 107},
	{"CB", 2, 108},
	{"CBA", 3, 109},
	{"CFM", 3, 110},
	{"CL", 2, 111},
	{"CLDY", 4, 112},
	{"CLG", 3, 113},
	{"CLR", 3, 114},
	{"CONDX", 5, 115},
	{"CONGRATS", 8, 116},
	{"CONTEST", 7, 117},
	{"CPI", 3, 118},
	{"CPY", 3, 119},
	{"CP?", 3, 120},
	{"CQ", 2, 121},
	{"CQCQ", 4, 122},
	{"CUAGN", 5, 123},
	{"CUD", 3, 124},
	{"DE", 2, 125},
	{"DB", 2, 126},
	{"DOUBLET", 7, 127},
	{"DUBLET", 6, 128},
	{"DIPOLE", 6, 129},
	{"DIT", 3, 130},
	{"DITDIT", 6, 131},
	{"DR", 2, 132},
	{"DSW", 3, 133},
	{"DWN", 3, 134},
	{"DX", 2, 135},
	{"EFHW", 4, 136},
	{"ENDFED", 6, 137},
	{"EL", 2, 138},
	{"ENUF", 4, 139},
	{"FB", 2, 140},
	{"FD", 2, 141},
	{"FER", 3, 142},
	{"FEET", 4, 143},
	{"FIELDDAY", 8, 144},
	{"FIN", 3, 145},
	{"FIST", 4, 146},
	{"FONE", 4, 147},
	{"FM", 2, 148},
	{"FQ", 2, 149},
	{"FREQ", 4, 150},
	{"GA", 2, 151},
	{"GB", 2, 152},
	{"GD", 2, 153},
	{"GE", 2, 154},
	{"GL", 2, 155},
	{"GG", 2, 156},
	{"GM", 2, 157},
	{"GMT", 3, 158},
	{"GN", 2, 159},
	{"GND", 3, 160},
	{"GP", 2, 161},
	{"GRATS", 5, 162},
	{"GRID", 4, 163},
	{"GUD", 3, 164},
	{"HAM", 3, 165},
	{"HC", 2, 166},
	{"HIHI", 4, 167},
	{"HNY", 3, 168},
	{"HPE", 3, 169},
	{"HR", 2, 170},
	{"HV", 2, 171},
	{"HVNT", 4, 172},
	{"HVY", 3, 173},
	{"HW?", 3, 174},
	{"HWCPY?", 6, 175},
	{"HXA", 3, 176},
	{"HXB", 3, 177},
	{"HXC", 3, 178},
	{"HXD", 3, 179},
	{"HXE", 3, 180},
	{"HXF", 3, 181},
	{"HXG", 3, 182},
	{"INV", 3, 183},
	{"JA", 2, 184},
	{"JMP", 3, 185},
	{"KN", 2, 186},
	{"KW", 2, 187},
	{"KNW", 3, 188},
	{"LID", 3, 189},
	{"LOOP", 4, 190},
	{"LP", 2, 191},
	{"LSB", 3, 192},
	{"LW", 2, 193},
	{"MIL", 3, 194},
	{"METER", 5, 195},
	{"MODE", 4, 196},
	{"MHZ", 3, 197},
	{"MGR", 3, 198},
	{"MNI", 3, 199},
	{"MSG", 3, 200},
	{"MW", 2, 201},
	{"MULT", 4, 202},
	{"NIL", 3, 203},
	{"NR", 2, 204},
	{"NW", 2, 205},
	{"OB", 2, 206},
	{"OC", 2, 207},
	{"OM", 2, 208},
	{"OP", 2, 209},
	{"OPR", 3, 210},
	{"PSE", 3, 211},
	{"PWR", 3, 212},
	{"PO", 2, 213},
	{"PFX", 3, 214},
	{"QSLL", 4, 215},
	{"RR", 2, 216},
	{"RR73", 4, 217},
	{"RRR", 3, 218},
	{"RACES", 5, 219},
	{"RECV", 4, 220},
	{"RCV", 3, 221},
	{"RCVD", 4, 222},
	{"RCVR", 4, 223},
	{"RIG", 3, 224},
	{"RX", 2, 225},
	{"SDR", 3, 226},
	{"SHUD", 4, 227},
	{"SIG", 3, 228},
	{"SK", 2, 229},
	{"SKED", 4, 230},
	{"SNR", 3, 231},
	{"SNW", 3, 232},
	{"SP", 2, 233},
	{"SPCL", 4, 234},
	{"SRI", 3, 235},
	{"STD", 3, 236},
	{"STN", 3, 237},
	{"SWL", 3, 238},
	{"TEMP", 4, 239},
	{"TEST", 4, 240},
	{"TFC", 3, 241},
	{"TIL", 3, 242},
	{"TCVR", 4, 243},
	{"TRANSCEIVER", 11, 244},
	{"TU", 2, 245},
	{"TX", 2, 246},
	{"TKS", 3, 247},
	{"THX", 3, 248},
	{"TNX", 3, 249},
	{"UFB", 3, 250},
	{"UR", 2, 251},
	{"URS", 3, 252},
	{"USB", 3, 253},
	{"UTC", 3, 254},
	{"VEE", 3, 255},
	{"VERT", 4, 256},
	{"VERTICAL", 8, 257},
	{"VFO", 3, 258},
	{"VY", 2, 259},
	{"VVV", 3, 260},
	{"W1AW", 4, 261},
	{"WATTS", 5, 262},
	{"WTTS", 4, 263},
	{"WID", 3, 264},
	{"WIRE", 4, 265},
	{"WK", 2, 266},
	{"WKD", 3, 267},
	{"WKG", 3, 268},
	{"WL", 2, 269},
	{"WPM", 3, 270},
	{"WRK", 3, 271},
	{"WUD", 3, 272},
	{"WX", 2, 273},
	{"XCVR", 4, 274},
	{"XMTR", 4, 275},
	{"XTAL", 4, 276},
	{"XYL", 3, 277},
	{"YF", 2, 278},
	{"YL", 2, 279},
	{"YR", 2, 280},
	{"YRS", 3, 281},
	{"ZZ", 2, 282},
	{"TGZ", 3, 283},
	{"ZIP", 3, 284},
	{"DOC", 3, 285},
	{"TXT", 3, 286},
	{"ALINCO", 6, 287},
	{"ICOM", 4, 288},
	{"KENWOOD", 7, 289},
	{"YAESU", 5, 290},
	{"ELECRAFT", 8, 291},
	{"FLEX", 4, 292},
	{"QSO", 3, 293},
	{"QSL", 3, 294},
	{"QRM", 3, 295},
	{"QRN", 3, 296},
	{"QTH", 3, 297},
	{"QRP", 3, 298},
	{"QRPP", 4, 299},
	{"QRO", 3, 300},
	{"QSB", 3, 301},
	{"QRZ", 3, 302},
	{"QRL", 3, 303},
	{"QRQ", 3, 304},
	{"QRV", 3, 305},
	{"..", 2, 306},
	{"...", 3, 307},
	{"'T", 2, 308},
	{"'D", 2, 309},
	{"'RE", 3, 310},
	{"'VE", 3, 311},
	{"'LL", 3, 312},
	{"'M", 2, 313},
	{"'S", 2, 314},
	{"-10", 3, 315},
	{"-11", 3, 316},
	{"-12", 3, 317},
	{"-13", 3, 318},
	{"-14", 3, 319},
	{"-15", 3, 320},
	{"-16", 3, 321},
	{"-17", 3, 322},
	{"-18", 3, 323},
	{"-19", 3, 324},
	{"-20", 3, 325},
	{"-21", 3, 326},
	{"-22", 3, 327},
	{"-23", 3, 328},
	{"-24", 3, 329},
	{"10", 2, 330},
	{"20", 2, 331},
	{"30", 2, 332},
	{"32", 2, 333},
	{"40", 2, 334},
	{"50", 2, 335},
	{"60", 2, 336},
	{"64", 2, 337},
	{"70", 2, 338},
	{"80", 2, 339},
	{"90", 2, 340},
	{"100", 3, 341},
	{"128", 3, 342},
	{"500", 3, 343},
	{"817", 3, 344},
	{"1000", 4, 345},
	{"232", 3, 346},
	{"33", 2, 347},
	{"42", 2, 348},
	{"55", 2, 349},
	{"72", 2, 350},
	{"73", 2, 351},
	{"88", 2, 352},
	{"59", 2, 353},
	{"100MW", 5, 354},
	{"500MW", 5, 355},
	{"5W", 2, 356},
	{"10W", 3, 357},
	{"30W", 3, 358},
	{"50W", 3, 359},
	{"100W", 4, 360},
	{"ONE", 3, 361},
	{"TWO", 3, 362},
	{"THREE", 5, 363},
	{"FOUR", 4, 364},
	{"FIVE", 4, 365},
	{"SIX", 3, 366},
	{"SEVEN", 5, 367},
	{"EIGHT", 5, 368},
	{"NINE", 4, 369},
	{"TEN", 3, 370},
	{"QRS", 3, 371},
	{"QRT", 3, 372},
	{"QRU", 3, 373},
	{"QRX", 3, 374},
	{"QSK", 3, 375},
	{"QST", 3, 376},
	{"QSX", 3, 377},
	{"QSY", 3, 378},
	{"QRA", 3, 379},
	{"QRB", 3, 380},
	{"QRG", 3, 381},
	{"QRH", 3, 382},
	{"QRI", 3, 383},
	{"QRK", 3, 384},
	{"QRW", 3, 385},
	{"QSA", 3, 386},
	{"QSD", 3, 387},
	{"QSG", 3, 388},
	{"QSM", 3, 389},
	{"QSN", 3, 390},
	{"QSP", 3, 391},
	{"QSU", 3, 392},
	{"QSV", 3, 393},
	{"QSW", 3, 394},
	{"QSZ", 3, 395},
	{"QTA", 3, 396},
	{"QTB", 3, 397},
	{"QTC", 3, 398},
	{"QTR", 3, 399},
	{"VERED", 5, 400},
	{"ABOUT", 5, 401},
	{"ACCESSIBILITY", 13, 402},
	{"ACCURATE", 8, 403},
	{"ACHIEVEMENT", 11, 404},
	{"ADDITIONAL", 10, 405},
	{"ADDRESS", 7, 406},
	{"ADDRESSED", 9, 407},
	{"ADVISE", 6, 408},
	{"AGAIN", 5, 409},
	{"ALSO", 4, 410},
	{"ALWAYS", 6, 411},
	{"AM", 2, 412},
	{"AND", 3, 413},
	{"ANXIOUS", 7, 414},
	{"APPRECIATED", 11, 415},
	{"ARE", 3, 416},
	{"AREA", 4, 417},
	{"ARRANGE", 7, 418},
	{"ARRIVAL", 7, 419},
	{"ARRIVED", 7, 420},
	{"ARRIVING", 8, 421},
	{"ASSIST", 6, 422},
	{"ASSISTANCE", 10, 423},
	{"AUTHORITIES", 11, 424},
	{"AVAILABILITY", 12, 425},
	{"AVAILABLE", 9, 426},
	{"BE", 2, 427},
	{"BECAUSE", 7, 428},
	{"BECOMING", 8, 429},
	{"BEING", 5, 430},
	{"BEST", 4, 431},
	{"BIRTHDAY", 8, 432},
	{"BUREAU", 6, 433},
	{"BY", 2, 434},
	{"CARE", 4, 435},
	{"CHANNEL", 7, 436},
	{"CHILD", 5, 437},
	{"CHRISTMAS", 9, 438},
	{"COME", 4, 439},
	{"COMING", 6, 440},
	{"COMMUNICATION", 13, 441},
	{"COMMUNICATIONS", 14, 442},
	{"CONCERNED", 9, 443},
	{"CONDITION", 9, 444},
	{"CONDITIONS", 10, 445},
	{"CONGRATULATIONS", 15, 446},
	{"CONTACT", 7, 447},
	{"COULD", 5, 448},
	{"CRITICAL", 8, 449},
	{"DAMAGE", 6, 450},
	{"DEFEAT", 6, 451},
	{"DELAY", 5, 452},
	{"DELIGHTED", 9, 453},
	{"DELIVERED", 9, 454},
	{"DELIVERING", 10, 455},
	{"DESERVED", 8, 456},
	{"DISASTER", 8, 457},
	{"DO", 2, 458},
	{"DON'T", 5, 459},
	{"EIGHTEEN", 8, 460},
	{"ELEVEN", 6, 461},
	{"EMERGENCY", 9, 462},
	{"ENJOY", 5, 463},
	{"ENJOYED", 7, 464},
	{"ENVELOPES", 9, 465},
	{"EQUIPMENT", 9, 466},
	{"ESTABLISH", 9, 467},
	{"EVACUATION", 10, 468},
	{"EVERYONE", 8, 469},
	{"EVERYTHING", 10, 470},
	{"EXCELLENT", 9, 471},
	{"EXISTING", 8, 472},
	{"EXITS", 5, 473},
	{"EXTENT", 6, 474},
	{"FELLOWSHIP", 10, 475},
	{"FIFTEEN", 7, 476},
	{"FIFTY", 5, 477},
	{"FINE", 4, 478},
	{"FOR", 3, 479},
	{"FORTY", 5, 480},
	{"FORWARD", 7, 481},
	{"FOURTEEN", 8, 482},
	{"FREE", 4, 483},
	{"FROM", 4, 484},
	{"FUN", 3, 485},
	{"FURNISH", 7, 486},
	{"FURTHER", 7, 487},
	{"GETTING", 7, 488},
	{"GLAD", 4, 489},
	{"GOOD", 4, 490},
	{"GREETINGS", 9, 491},
	{"HAND", 4, 492},
	{"HAPPY", 5, 493},
	{"HAVE", 4, 494},
	{"HAVING", 6, 495},
	{"HEALTH", 6, 496},
	{"HEAR", 4, 497},
	{"HELP", 4, 498},
	{"HERE", 4, 499},
	{"HOLIDAY", 7, 500},
	{"HOME", 4, 501},
	{"HOPE", 4, 502},
	{"HOSPITAL", 8, 503},
	{"ILL", 3, 504},
	{"IMMEDIATE", 9, 505},
	{"INCREASING", 10, 506},
	{"INFORM", 6, 507},
	{"INFORMATION", 11, 508},
	{"INJURED", 7, 509},
	{"INSTRUCTIONS", 12, 510},
	{"IT'S", 4, 511},
	{"KNOW", 4, 512},
	{"LET", 3, 513},
	{"LOCAL", 5, 514},
	{"LOCATION", 8, 515},
	{"LOOKING", 7, 516},
	{"LOSSES", 6, 517},
	{"MAIL", 4, 518},
	{"MANY", 4, 519},
	{"ME", 2, 520},
	{"MEDICAL", 7, 521},
	{"MEET", 4, 522},
	{"MERRY", 5, 523},
	{"MESSAGE", 7, 524},
	{"MOBILE", 6, 525},
	{"MORE", 4, 526},
	{"MOST", 4, 527},
	{"MOTHER", 6, 528},
	{"MOVING", 6, 529},
	{"NAME", 4, 530},
	{"NEED", 4, 531},
	{"NEEDED", 6, 532},
	{"NEW", 3, 533},
	{"NEWS", 4, 534},
	{"NINETEEN", 8, 535},
	{"NOT", 3, 536},
	{"NOW", 3, 537},
	{"NUMBER", 6, 538},
	{"OF", 2, 539},
	{"ONCE", 4, 540},
	{"ONLY", 4, 541},
	{"OPERATORS", 9, 542},
	{"OR", 2, 543},
	{"ORGANIZATION", 12, 544},
	{"OUR", 3, 545},
	{"PLANS", 5, 546},
	{"PLEASANT", 8, 547},
	{"PLEASE", 6, 548},
	{"PORTABLE", 8, 549},
	{"POSSIBLE", 8, 550},
	{"PROPERTY", 8, 551},
	{"PROVIDE", 7, 552},
	{"PUBLIC", 6, 553},
	{"QSLS", 4, 554},
	{"RADIO", 5, 555},
	{"REACH", 5, 556},
	{"REACT", 5, 557},
	{"REALLY", 6, 558},
	{"RECEIVED", 8, 559},
	{"RECEIVING", 9, 560},
	{"RECOVERING", 10, 561},
	{"RECOVERY", 8, 562},
	{"REFERENCE", 9, 563},
	{"RELOCATED", 9, 564},
	{"REPLY", 5, 565},
	{"REPORT", 6, 566},
	{"REPORTS", 7, 567},
	{"REQUEST", 7, 568},
	{"RESCUE", 6, 569},
	{"RESIDENTS", 9, 570},
	{"RETURN", 6, 571},
	{"SAFE", 4, 572},
	{"SAFELY", 6, 573},
	{"SEARCH", 6, 574},
	{"SEASON", 6, 575},
	{"SELF", 4, 576},
	{"SEND", 4, 577},
	{"SENT", 4, 578},
	{"SERVICE", 7, 579},
	{"SERVICES", 8, 580},
	{"SEVENTEEN", 9, 581},
	{"SEVERE", 6, 582},
	{"SICK", 4, 583},
	{"SITUATION", 9, 584},
	{"SIXTEEN", 7, 585},
	{"SIXTY", 5, 586},
	{"SLIGHT", 6, 587},
	{"SOME", 4, 588},
	{"SOON", 4, 589},
	{"SORRY", 5, 590},
	{"SPEEDY", 6, 591},
	{"STANDBY", 7, 592},
	{"STATE", 5, 593},
	{"STRANDED", 8, 594},
	{"TELEPHONE", 9, 595},
	{"TEMPORARILY", 11, 596},
	{"THANKS", 6, 597},
	{"THERE", 5, 598},
	{"THIRTEEN", 8, 599},
	{"THIS", 4, 600},
	{"THROUGH", 7, 601},
	{"TIME", 4, 602},
	{"TOGETHER", 8, 603},
	{"TWELVE", 6, 604},
	{"TWENTY", 6, 605},
	{"TYPE", 4, 606},
	{"UNDELIVERABLE", 13, 607},
	{"URGENTLY", 8, 608},
	{"USE", 3, 609},
	{"VERY", 4, 610},
	{"VICTORY", 7, 611},
	{"WAY", 3, 612},
	{"WEATHER", 7, 613},
	{"WELCOME", 7, 614},
	{"WELFARE", 7, 615},
	{"WELL", 4, 616},
	{"WHAT", 4, 617},
	{"WHEN", 4, 618},
	{"WILL", 4, 619},
	{"WIN", 3, 620},
	{"WISH", 4, 621},
	{"WISHES", 6, 622},
	{"WISHING", 7, 623},
	{"WITH", 4, 624},
	{"WITHOUT", 7, 625},
	{"WONDERFUL", 9, 626},
	{"WORD", 4, 627},
	{"WORRY", 5, 628},
	{"WORTHY", 6, 629},
	{"YEAR", 4, 630},
	{"YOU", 3, 631},
	{"YOUR", 4, 632},
	{"YOURS", 5, 633},
	{":)", 2, 634},
	{":P", 2, 635},
	{":-)", 3, 636},
	{":-P", 3, 637},
	{":D", 2, 638},
	{":(", 2, 639},
	{":-(", 3, 640},
	{"=)", 2, 641},
	{"=D", 2, 642},
	{"<3", 2, 643},
	{"YCO", 3, 644},
	{"AREN'T", 6, 645},
	{"CAN'T", 5, 646},
	{"COULDN'T", 8, 647},
	{"DIDN'T", 6, 648},
	{"DOESN'T", 7, 649},
	{"HADN'T", 6, 650},
	{"HASN'T", 6, 651},
	{"HAVEN'T", 7, 652},
	{"HE'D", 4, 653},
	{"HE'LL", 5, 654},
	{"HE'S", 4, 655},
	{"I'D", 3, 656},
	{"I'LL", 4, 657},
	{"I'M", 3, 658},
	{"I'VE", 4, 659},
	{"ISN'T", 5, 660},
	{"LET'S", 5, 661},
	{"MIGHTN'T", 8, 662},
	{"MUSTN'T", 7, 663},
	{"SHAN'T", 6, 664},
	{"SHE'D", 5, 665},
	{"SHE'LL", 6, 666},
	{"SHE'S", 5, 667},
	{"SHOULDN'T", 9, 668},
	{"THAT'S", 6, 669},
	{"THERE'S", 7, 670},
	{"THEY'D", 6, 671},
	{"THEY'LL", 7, 672},
	{"THEY'RE", 7, 673},
	{"THEY'VE", 7, 674},
	{"WE'D", 4, 675},
	{"WE'RE", 5, 676},
	{"WE'VE", 5, 677},
	{"WEREN'T", 7, 678},
	{"WHAT'LL", 7, 679},
	{"WHAT'RE", 7, 680},
	{"WHAT'S", 6, 681},
	{"WHAT'VE", 7, 682},
	{"WHERE'S", 7, 683},
	{"WHO'S", 5, 684},
	{"WHO'LL", 6, 685},
	{"WHO'RE", 6, 686},
	{"WHO'VE", 6, 687},
	{"WON'T", 5, 688},
	{"WOULDN'T", 8, 689},
	{"Y'ALL", 5, 690},
	{"YOU'D", 5, 691},
	{"YOU'LL", 6, 692},
	{"YOU'RE", 6, 693},
	{"YOU'VE", 6, 694},
	{"THAT", 4, 695},
	{"LYI", 3, 696},
	{"YFO", 3, 697},
	{"YWI", 3, 698},
	{"YWA", 3, 699},
	{"RYI", 3, 700},
	{"LYW", 3, 701},
	{"LYB", 3, 702},
	{"YWE", 3, 703},
	{"YWH", 3, 704},
	{"SAY", 3, 705},
	{"ONV", 3, 706},
	{"THEY", 4, 707},
	{"NJU", 3, 708},
	{"YSH", 3, 709},
	{"BUT", 3, 710},
	{"N'T", 3, 711},
	{"LBU", 3, 712},
	{"TYI", 3, 713},
	{"YWO", 3, 714},
	{"YFR", 3, 715},
	{"FYO", 3, 716},
	{"OUB", 3, 717},
	{"WAS", 3, 718},
	{"WNE", 3, 719},
	{"RBU", 3, 720},
	{"YLO", 3, 721},
	{"YDO", 3, 722},
	{"AYW", 3, 723},
	{"YBU", 3, 724},
	{"OJE", 3, 725},
	{"YBO", 3, 726},
	{"THEIR", 5, 727},
	{"LYL", 3, 728},
	{"EYR", 3, 729},
	{"YLA", 3, 730},
	{"RYB", 3, 731},
	{"TBY", 3, 732},
	{"YHI", 3, 733},
	{"CAN", 3, 734},
	{"TYW", 3, 735},
	{"WHO", 3, 736},
	{"GET", 3, 737},
	{"EYD", 3, 738},
	{"EYT", 3, 739},
	{"HER", 3, 740},
	{"YFI", 3, 741},
	{"RYF", 3, 742},
	{"RYP", 3, 743},
	{"EOV", 3, 744},
	{"DJU", 3, 745},
	{"AYH", 3, 746},
	{"WOULD", 5, 747},
	{"YHO", 3, 748},
	{"MY", 2, 749},
	{"ALL", 3, 750},
	{"IQU", 3, 751},
	{"DQU", 3, 752},
	{"YFA", 3, 753},
	{"MAKE", 4, 754},
	{"LYG", 3, 755},
	{"OUW", 3, 756},
	{"LKI", 3, 757},
	{"UP", 2, 758},
	{"NGY", 3, 759},
	{"OFTH", 4, 760},
	{"THINK", 5, 761},
	{"BYH", 3, 762},
	{"NYW", 3, 763},
	{"TJU", 3, 764},
	{"RYH", 3, 765},
	{"YEX", 3, 766},
	{"OUH", 3, 767},
	{"HEQ", 3, 768},
	{"INTH", 4, 769},
	{"PEOPLE", 6, 770},
	{"WHICH", 5, 771},
	{"AYL", 3, 772},
	{"YBR", 3, 773},
	{"OUT", 3, 774},
	{"THEM", 4, 775},
	{"JUST", 4, 776},
	{"HIM", 3, 777},
	{"TAKE", 4, 778},
	{"INTO", 4, 779},
	{"YPI", 3, 780},
	{"EYM", 3, 781},
	{"NQU", 3, 782},
	{"YRI", 3, 783},
	{"EYF", 3, 784},
	{"OMW", 3, 785},
	{"INGT", 4, 786},
	{"YGR", 3, 787},
	{"YGE", 3, 788},
	{"YSW", 3, 789},
	{"TYB", 3, 790},
	{"YBY", 3, 791},
	{"TYH", 3, 792},
	{"EYI", 3, 793},
	{"YDR", 3, 794},
	{"THAN", 4, 795},
	{"FHO", 3, 796},
	{"FNE", 3, 797},
	{"LIKE", 4, 798},
	{"EYL", 3, 799},
	{"IXT", 3, 800},
	{"YNI", 3, 801},
	{"OTHER", 5, 802},
	{"YFE", 3, 803},
	{"THEN", 4, 804},
	{"HOW", 3, 805},
	{"BEEN", 4, 806},
	{"WERE", 4, 807},
	{"NMY", 3, 808},
	{"TJO", 3, 809},
	{"WANT", 4, 810},
	{"THESE", 5, 811},
	{"YMU", 3, 812},
	{"YCR", 3, 813},
	{"YYE", 3, 814},
	{"LOOK", 4, 815},
	{"BYF", 3, 816},
	{"TQU", 3, 817},
	{"ISJ", 3, 818},
	{"NIQ", 3, 819},
	{"BYI", 3, 820},
	{"UEO", 3, 821},
	{"DYT", 3, 822},
	{"RQU", 3, 823},
	{"URH", 3, 824},
	{"FIRST", 5, 825},
	{"FGO", 3, 826},
	{"EEY", 3, 827},
	{"HAD", 3, 828},
	{"YGA", 3, 829},
	{"ORJ", 3, 830},
	{"VEU", 3, 831},
	{"YYO", 3, 832},
	{"DAY", 3, 833},
	{"IXE", 3, 834},
	{"RYG", 3, 835},
	{"AYD", 3, 836},
	{"OGU", 3, 837},
	{"YJU", 3, 838},
	{"EMAIL", 5, 839},
	{"MAN", 3, 840},
	{"WNB", 3, 841},
	{"UBJ", 3, 842},
	{"OEV", 3, 843},
	{"EYG", 3, 844},
	{"THING", 5, 845},
	{"NGTH", 4, 846},
	{"FIND", 4, 847},
	{"YVI", 3, 848},
	{"YCE", 3, 849},
	{"YSF", 3, 850},
	{"OOU", 3, 851},
	{"TELL", 4, 852},
	{"YKN", 3, 853},
	{"GIVE", 4, 854},
	{"PRODUCTS", 8, 855},
	{"THOSE", 5, 856},
	{"IZI", 3, 857},
	{"DGU", 3, 858},
	{"OQU", 3, 859},
	{"EDTO", 4, 860},
	{"RJU", 3, 861},
	{"BACK", 4, 862},
	{"EYN", 3, 863},
	{"YJO", 3, 864},
	{"YDU", 3, 865},
	{"LLK", 3, 866},
	{"EVEN", 4, 867},
	{"YOV", 3, 868},
	{"TGU", 3, 869},
	{"EDTH", 4, 870},
	{"ANY", 3, 871},
	{"NDTH", 4, 872},
	{"COPYRIGHT", 9, 873},
	{"DYW", 3, 874},
	{"BYN", 3, 875},
	{"NYF", 3, 876},
	{"OUV", 3, 877},
	{"WOMAN", 5, 878},
	{"JAN", 3, 879},
	{"LIFE", 4, 880},
	{"ATTH", 4, 881},
	{"WNH", 3, 882},
	{"DOWN", 4, 883},
	{"YTW", 3, 884},
	{"YBI", 3, 885},
	{"INFO", 4, 886},
	{"RIGHTS", 6, 887},
	{"KEU", 3, 888},
	{"MAY", 3, 889},
	{"FVI", 3, 890},
	{"YKI", 3, 891},
	{"OZE", 3, 892},
	{"OYM", 3, 893},
	{"UEW", 3, 894},
	{"BOOKS", 5, 895},
	{"EXU", 3, 896},
	{"WORK", 4, 897},
	{"THJ", 3, 898},
	{"YRU", 3, 899},
	{"LINKS", 5, 900},
	{"YEARS", 5, 901},
	{"AFTER", 5, 902},
	{"SHOULD", 6, 903},
	{"CALL", 4, 904},
	{"ITEMS", 5, 905},
	{"SCHOOL", 6, 906},
	{"WORLD", 5, 907},
	{"OVER", 4, 908},
	{"UNW", 3, 909},
	{"YGI", 3, 910},
	{"HQU", 3, 911},
	{"STILL", 5, 912},
	{"OJU", 3, 913},
	{"TRY", 3, 914},
	{"SAID", 4, 915},
	{"DOES", 4, 916},
	{"LAST", 4, 917},
	{"OLW", 3, 918},
	{"JANUARY", 7, 919},
	{"IJU", 3, 920},
	{"ASK", 3, 921},
	{"REVIEWS", 7, 922},
	{"LSY", 3, 923},
	{"MYH", 3, 924},
	{"GAMES", 5, 925},
	{"DAYS", 4, 926},
	{"NKW", 3, 927},
	{"MYW", 3, 928},
	{"YBL", 3, 929},
	{"NTJ", 3, 930},
	{"FEEL", 4, 931},
	{"EBAY", 4, 932},
	{"LYV", 3, 933},
	{"YQU", 3, 934},
	{"DYB", 3, 935},
	{"COMMENTS", 8, 936},
	{"MADE", 4, 937},
	{"YCU", 3, 938},
	{"FJU", 3, 939},
	{"XHI", 3, 940},
	{"BETWEEN", 7, 941},
	{"NEVER", 5, 942},
	{"DETAILS", 7, 943},
	{"BECOME", 6, 944},
	{"AJU", 3, 945},
	{"OYI", 3, 946},
	{"HIGH", 4, 947},
	{"STUDENT", 7, 948},
	{"SOMETHING", 9, 949},
	{"HOTELS", 6, 950},
	{"DID", 3, 951},
	{"YSD", 3, 952},
	{"USING", 5, 953},
	{"UYI", 3, 954},
	{"RESULTS", 7, 955},
	{"YJA", 3, 956},
	{"AYG", 3, 957},
	{"MUCH", 4, 958},
	{"POSTED", 6, 959},
	{"DYH", 3, 960},
	{"FAMILY", 6, 961},
	{"OKP", 3, 962},
	{"MEAN", 4, 963},
	{"IDY", 3, 964},
	{"STATES", 6, 965},
	{"ANOTHER", 7, 966},
	{"LEAVE", 5, 967},
	{"OWN", 3, 968},
	{"XTY", 3, 969},
	{"DNU", 3, 970},
	{"PUT", 3, 971},
	{"DVD", 3, 972},
	{"SHIPPING", 8, 973},
	{"RESERVED", 8, 974},
	{"OLD", 3, 975},
	{"RNU", 3, 976},
	{"NKH", 3, 977},
	{"WHY", 3, 978},
	{"OWY", 3, 979},
	{"WHILE", 5, 980},
	{"NZA", 3, 981},
	{"BASED", 5, 982},
	{"CYI", 3, 983},
	{"KEEP", 4, 984},
	{"WNM", 3, 985},
	{"GROUP", 5, 986},
	{"TALK", 4, 987},
	{"BIG", 3, 988},
	{"PRICES", 6, 989},
	{"GREAT", 5, 990},
	{"NGTO", 4, 991},
	{"WEBSITE", 7, 992},
	{"WOMEN", 5, 993},
	{"UOU", 3, 994},
	{"COUNTRY", 7, 995},
	{"SAME", 4, 996},
	{"YAV", 3, 997},
	{"OTJ", 3, 998},
	{"TURN", 4, 999},
	{"TNU", 3, 1000},
	{"YVA", 3, 1001},
	{"SEEM", 4, 1002},
	{"EIW", 3, 1003},
	{"YPH", 3, 1004},
	{"BEGIN", 5, 1005},
	{"DKN", 3, 1006},
	{"PROBLEM", 7, 1007},
	{"PAGES", 5, 1008},
	{"UK", 2, 1009},
	{"AMERICAN", 8, 1010},
	{"SPORTS", 6, 1011},
	{"START", 5, 1012},
	{"WHERE", 5, 1013},
	{"YGU", 3, 1014},
	{"EWAS", 4, 1015},
	{"EVERY", 5, 1016},
	{"MEMBERS", 7, 1017},
	{"MIGHT", 5, 1018},
	{"SHOW", 4, 1019},
	{"YMB", 3, 1020},
	{"PART", 4, 1021},
	{"YTU", 3, 1022},
	{"HFU", 3, 1023},
	{"SUCH", 4, 1024},
	{"SYSTEMS", 7, 1025},
	{"STHA", 4, 1026},
	{"EOFT", 4, 1027},
	{"FJO", 3, 1028},
	{"RIGHT", 5, 1029},
	{"AGAINST", 7, 1030},
	{"DOWNLOAD", 8, 1031},
	{"COMPANY", 7, 1032},
	{"PLACE", 5, 1033},
	{"RESOURCES", 9, 1034},
	{"CASE", 4, 1035},
	{"POSTS", 5, 1036},
	{"LYY", 3, 1037},
	{"EDBY", 4, 1038},
	{"SYSTEM", 6, 1039},
	{"WEEK", 4, 1040},
	{"PICTURES", 8, 1041},
	{"FEW", 3, 1042},
	{"YCI", 3, 1043},
	{"DIRECTORY", 9, 1044},
	{"EACH", 4, 1045},
	{"PROGRAM", 7, 1046},
	{"UEH", 3, 1047},
	{"YWR", 3, 1048},
	{"YSY", 3, 1049},
	{"QUESTION", 8, 1050},
	{"OYT", 3, 1051},
	{"GOVERNMENT", 10, 1052},
	{"CHILDREN", 8, 1053},
	{"OHU", 3, 1054},
	{"LYJ", 3, 1055},
	{"USA", 3, 1056},
	{"DURING", 6, 1057},
	{"RYV", 3, 1058},
	{"LJO", 3, 1059},
	{"STUDENTS", 8, 1060},
	{"MR", 2, 1061},
	{"PLAY", 4, 1062},
	{"OKH", 3, 1063},
	{"INGI", 4, 1064},
	{"IRY", 3, 1065},
	{"MBY", 3, 1066},
	{"TIMES", 5, 1067},
	{"LKO", 3, 1068},
	{"SITES", 5, 1069},
	{"RUN", 3, 1070},
	{"UZZ", 3, 1071},
	{"UYA", 3, 1072},
	{"EVENTS", 6, 1073},
	{"YLV", 3, 1074},
	{"SMALL", 5, 1075},
	{"GJU", 3, 1076},
	{"JOHN", 4, 1077},
	{"NIGHT", 5, 1078},
	{"OFF", 3, 1079},
	{"XFO", 3, 1080},
	{"TODAY", 5, 1081},
	{"ERQ", 3, 1082},
	{"HOURS", 5, 1083},
	{"HEWA", 4, 1084},
	{"ASTH", 4, 1085},
	{"HYW", 3, 1086},
	{"HBY", 3, 1087},
	{"HAPPEN", 6, 1088},
	{"RCY", 3, 1089},
	{"IXM", 3, 1090},
	{"MOVE", 4, 1091},
	{"LQU", 3, 1092},
	{"BELIEVE", 7, 1093},
	{"POINT", 5, 1094},
	{"HOLD", 4, 1095},
	{"MILLION", 7, 1096},
	{"CD", 2, 1097},
	{"RYY", 3, 1098},
	{"NEXT", 4, 1099},
	{"LIVE", 4, 1100},
	{"LARGE", 5, 1101},
	{"NDIN", 4, 1102},
	{"LISTING", 7, 1103},
	{"ETHA", 4, 1104},
	{"OMJ", 3, 1105},
	{"BRING", 5, 1106},
	{"STUDY", 5, 1107},
	{"GJO", 3, 1108},
	{"OYD", 3, 1109},
	{"BEFORE", 6, 1110},
	{"ITHT", 4, 1111},
	{"ROOM", 4, 1112},
	{"EYU", 3, 1113},
	{"NGQ", 3, 1114},
	{"ESTH", 4, 1115},
	{"TOOLS", 5, 1116},
	{"MUST", 4, 1117},
	{"GQU", 3, 1118},
	{"LOT", 3, 1119},
	{"DECEMBER", 8, 1120},
	{"HJO", 3, 1121},
	{"EYE", 3, 1122},
	{"MOVIES", 6, 1123},
	{"HJU", 3, 1124},
	{"YORK", 4, 1125},
	{"WATER", 5, 1126},
	{"JOBS", 4, 1127},
	{"ONOF", 4, 1128},
	{"NATIONAL", 8, 1129},
	{"XHA", 3, 1130},
	{"OXE", 3, 1131},
	{"MONEY", 5, 1132},
	{"UNDER", 5, 1133},
	{"FACT", 4, 1134},
	{"AYY", 3, 1135},
	{"CANADA", 6, 1136},
	{"STORY", 5, 1137},
	{"MONTH", 5, 1138},
	{"DIFFERENT", 9, 1139},
	{"WRITE", 5, 1140},
	{"XCO", 3, 1141},
	{"KBY", 3, 1142},
	{"MEN", 3, 1143},
	{"ITHA", 4, 1144},
	{"CATEGORIES", 10, 1145},
	{"TEDT", 4, 1146},
	{"HEAD", 4, 1147},
	{"YOUNG", 5, 1148},
	{"HEFI", 4, 1149},
	{"AYJ", 3, 1150},
	{"EKW", 3, 1151},
	{"XTU", 3, 1152},
	{"YES", 3, 1153},
	{"UYE", 3, 1154},
	{"EINT", 4, 1155},
	{"ISSUE", 5, 1156},
	{"NGIN", 4, 1157},
	{"WINDOWS", 7, 1158},
	{"UTTH", 4, 1159},
	{"PHOTOS", 6, 1160},
	{"KIND", 4, 1161},
	{"JOB", 3, 1162},
	{"ROMT", 4, 1163},
	{"BUSINESS", 8, 1164},
	{"LJA", 3, 1165},
	{"BOOK", 4, 1166},
	{"UTJ", 3, 1167},
	{"BYV", 3, 1168},
	{"GMY", 3, 1169},
	{"UGHT", 4, 1170},
	{"YSK", 3, 1171},
	{"SIDE", 4, 1172},
	{"WZE", 3, 1173},
	{"THOUGH", 6, 1174},
	{"CYW", 3, 1175},
	{"JUNE", 4, 1176},
	{"FYT", 3, 1177},
	{"OCTOBER", 7, 1178},
	{"NOVEMBER", 8, 1179},
	{"BLACK", 5, 1180},
	{"ZZL", 3, 1181},
	{"XMO", 3, 1182},
	{"ULW", 3, 1183},
	{"LITTLE", 6, 1184},
	{"HOUSE", 5, 1185},
	{"LONG", 4, 1186},
	{"FEATURES", 8, 1187},
	{"FAR", 3, 1188},
	{"ACCESSORIES", 11, 1189},
	{"NTIN", 4, 1190},
	{"FORUMS", 6, 1191},
	{"BOTH", 4, 1192},
	{"GAME", 4, 1193},
	{"EHY", 3, 1194},
	{"YND", 3, 1195},
	{"SEPTEMBER", 9, 1196},
	{"FATHER", 6, 1197},
	{"WJE", 3, 1198},
	{"QUESTIONS", 9, 1199},
	{"JULY", 4, 1200},
	{"AWAY", 4, 1201},
	{"POLITICAL", 9, 1202},
	{"GEU", 3, 1203},
	{"IMPORTANT", 9, 1204},
	{"YAHOO", 5, 1205},
	{"EREA", 4, 1206},
	{"AROUND", 6, 1207},
	{"GOING", 5, 1208},
	{"ERSI", 4, 1209},
	{"DEC", 3, 1210},
	{"FRIEND", 6, 1211},
	{"NDZ", 3, 1212},
	{"HOWEVER", 7, 1213},
	{"SERVER", 6, 1214},
	{"POWER", 5, 1215},
	{"SINCE", 5, 1216},
	{"CIZ", 3, 1217},
	{"STAND", 5, 1218},
	{"UNTIL", 5, 1219},
	{"OFTEN", 5, 1220},
	{"AZY", 3, 1221},
	{"ERSO", 4, 1222},
	{"ARTICLES", 8, 1223},
	{"HOUR", 4, 1224},
	{"ISSUES", 6, 1225},
	{"APRIL", 5, 1226},
	{"AMONG", 5, 1227},
	{"USERS", 5, 1228},
	{"THINGS", 6, 1229},
	{"LINE", 4, 1230},
	{"EVER", 4, 1231},
	{"YET", 3, 1232},
	{"EYJ", 3, 1233},
	{"BAD", 3, 1234},
	{"MEMBER", 6, 1235},
	{"PRESIDENT", 9, 1236},
	{"GOT", 3, 1237},
	{"BLOG", 4, 1238},
	{"END", 3, 1239},
	{"LOSE", 4, 1240},
	{"YNT", 3, 1241},
	{"UEZ", 3, 1242},
	{"OMTH", 4, 1243},
	{"LAW", 3, 1244},
	{"CAR", 3, 1245},
	{"INCLUDE", 7, 1246},
	{"LOGIN", 5, 1247},
	{"PAY", 3, 1248},
	{"COMMUNITY", 9, 1249},
	{"FJE", 3, 1250},
	{"EDQ", 3, 1251},
	{"ITJ", 3, 1252},
	{"SOCIAL", 6, 1253},
	{"RYJ", 3, 1254},
	{"FQU", 3, 1255},
	{"CITY", 4, 1256},
	{"HEPR", 4, 1257},
	{"PROGRAMS", 8, 1258},
	{"TEAM", 4, 1259},
	{"OFFERS", 6, 1260},
	{"FGU", 3, 1261},
	{"UIV", 3, 1262},
	{"XRE", 3, 1263},
	{"DTHA", 4, 1264},
	{"STORES", 6, 1265},
	{"NZI", 3, 1266},
	{"FKE", 3, 1267},
	{"OMK", 3, 1268},
	{"OUO", 3, 1269},
	{"AUGUST", 6, 1270},
	{"TYU", 3, 1271},
	{"XTW", 3, 1272},
	{"ALMOST", 6, 1273},
	{"NKM", 3, 1274},
	{"OPTIONS", 7, 1275},
	{"FACE", 4, 1276},
	{"RATES", 5, 1277},
	{"WHITE", 5, 1278},
	{"NOTHING", 7, 1279},
	{"MINUTE", 6, 1280},
	{"LATER", 5, 1281},
	{"KID", 3, 1282},
	{"EROF", 4, 1283},
	{"TIQ", 3, 1284},
	{"OYC", 3, 1285},
	{"CONTINUE", 8, 1286},
	{"AMERICA", 7, 1287},
	{"AGO", 3, 1288},
	{"BODY", 4, 1289},
	{"DOOR", 4, 1290},
	{"WATCH", 5, 1291},
	{"LEARN", 5, 1292},
	{"REAL", 4, 1293},
	{"SEVERAL", 7, 1294},
	{"INGF", 4, 1295},
	{"LEAST", 5, 1296},
	{"EOPL", 4, 1297},
	{"HYH", 3, 1298},
	{"DWIT", 4, 1299},
	{"CHANGE", 6, 1300},
	{"EMBE", 4, 1301},
	{"ACTIVITIES", 10, 1302},
	{"LEAD", 4, 1303},
	{"GIRLS", 5, 1304},
	{"PASSWORD", 8, 1305},
	{"IDEA", 4, 1306},
	{"LATEST", 6, 1307},
	{"WHETHER", 7, 1308},
	{"EIZ", 3, 1309},
	{"LEVEL", 5, 1310},
	{"STOP", 4, 1311},
	{"UNDERSTAND", 10, 1312},
	{"ORQ", 3, 1313},
	{"CHANGES", 7, 1314},
	{"YEF", 3, 1315},
	{"ANYTHING", 8, 1316},
	{"UAK", 3, 1317},
	{"ESOF", 4, 1318},
	{"TEXAS", 5, 1319},
	{"PARENT", 6, 1320},
	{"OCT", 3, 1321},
	{"FOLLOW", 6, 1322},
	{"CREATE", 6, 1323},
	{"INGH", 4, 1324},
	{"POKER", 5, 1325},
	{"BROWSE", 6, 1326},
	{"ROUG", 4, 1327},
	{"EASO", 4, 1328},
	{"FEBRUARY", 8, 1329},
	{"ART", 3, 1330},
	{"ADD", 3, 1331},
	{"WAR", 3, 1332},
	{"IONT", 4, 1333},
	{"DYG", 3, 1334},
	{"AUDIO", 5, 1335},
	{"SPEAK", 5, 1336},
	{"UYT", 3, 1337},
	{"NOV", 3, 1338},
	{"GROUPS", 6, 1339},
	{"RESULT", 6, 1340},
	{"SURE", 4, 1341},
	{"FILES", 5, 1342},
	{"TEACHER", 7, 1343},
	{"OSQ", 3, 1344},
	{"OTHERS", 6, 1345},
	{"ALREADY", 7, 1346},
	{"FAX", 3, 1347},
	{"CHINA", 5, 1348},
	{"HISTORY", 7, 1349},
	{"ALLOW", 5, 1350},
	{"MAKING", 6, 1351},
	{"RESEARCH", 8, 1352},
	{"OFFICE", 6, 1353},
	{"WITHIN", 6, 1354},
	{"SPEND", 5, 1355},
	{"NEEDS", 5, 1356},
	{"READ", 4, 1357},
	{"MORNING", 7, 1358},
	{"WALK", 4, 1359},
	{"EDUCATION", 9, 1360},
	{"PERSON", 6, 1361},
	{"PARTY", 5, 1362},
	{"IRJ", 3, 1363},
	{"AREAS", 5, 1364},
	{"AXC", 3, 1365},
	{"OKY", 3, 1366},
	{"CARDS", 5, 1367},
	{"PROBLEMS", 8, 1368},
	{"LONDON", 6, 1369},
	{"WASHINGTON", 10, 1370},
	{"OPEN", 4, 1371},
	{"RSS", 3, 1372},
	{"IONI", 4, 1373},
	{"RKU", 3, 1374},
	{"CALIFORNIA", 10, 1375},
	{"GIRL", 4, 1376},
	{"GUY", 3, 1377},
	{"SCHOOLS", 7, 1378},
	{"GROW", 4, 1379},
	{"HKE", 3, 1380},
	{"MOMENT", 6, 1381},
	{"HIMSELF", 7, 1382},
	{"COMPANIES", 9, 1383},
	{"LISTED", 6, 1384},
	{"LOW", 3, 1385},
	{"KIW", 3, 1386},
	{"MAYBE", 5, 1387},
	{"YKA", 3, 1388},
	{"UEV", 3, 1389},
	{"EPLA", 4, 1390},
	{"EARLY", 5, 1391},
	{"FORCE", 5, 1392},
	{"ALTHOUGH", 8, 1393},
	{"FOOD", 4, 1394},
	{"UWH", 3, 1395},
	{"POLICY", 6, 1396},
	{"BOY", 3, 1397},
	{"PROCESS", 7, 1398},
	{"FOOT", 4, 1399},
	{"REMEMBER", 8, 1400},
	{"REASON", 6, 1401},
	{"STORIES", 7, 1402},
	{"INGW", 4, 1403},
	{"COMPUTERS", 9, 1404},
	{"NZO", 3, 1405},
	{"OFFER", 5, 1406},
	{"ONSI", 4, 1407},
	{"TOWARD", 6, 1408},
	{"AIR", 3, 1409},
	{"ENOUGH", 6, 1410},
	{"ACROSS", 6, 1411},
	{"YJE", 3, 1412},
	{"IMAGES", 6, 1413},
	{"ACTUALLY", 8, 1414},
	{"TYV", 3, 1415},
	{"HHU", 3, 1416},
	{"YMY", 3, 1417},
	{"INCLUDES", 8, 1418},
	{"ITWA", 4, 1419},
	{"YNU", 3, 1420},
	{"INGC", 4, 1421},
	{"AUSTRALIA", 9, 1422},
	{"LOVE", 4, 1423},
	{"INCLUDING", 9, 1424},
	{"SSIO", 4, 1425},
	{"SECOND", 6, 1426},
	{"ARCHIVE", 7, 1427},
	{"AGE", 3, 1428},
	{"YEAH", 4, 1429},
	{"OYF", 3, 1430},
	{"ABLE", 4, 1431},
	{"XWI", 3, 1432},
	{"VOK", 3, 1433},
	{"FSY", 3, 1434},
	{"ANQ", 3, 1435},
	{"MONTHS", 6, 1436},
	{"EDWI", 4, 1437},
	{"NSJ", 3, 1438},
	{"MUSIC", 5, 1439},
	{"NTOF", 4, 1440},
	{"WAIT", 4, 1441},
	{"FRIENDS", 7, 1442},
	{"OUTT", 4, 1443},
	{"FAQ", 3, 1444},
	{"CONSIDER", 8, 1445},
	{"EFIR", 4, 1446},
	{"GVO", 3, 1447},
	{"CARS", 4, 1448},
	{"MESSAGES", 8, 1449},
	{"EWIT", 4, 1450},
	{"UPDATED", 7, 1451},
	{"HUMAN", 5, 1452},
	{"EPRE", 4, 1453},
	{"BUY", 3, 1454},
	{"PROVIDES", 8, 1455},
	{"DAVID", 5, 1456},
	{"OYW", 3, 1457},
	{"NSQ", 3, 1458},
	{"APPEAR", 6, 1459},
	{"MARKET", 6, 1460},
	{"STUDIES", 7, 1461},
	{"ECAU", 4, 1462},
	{"PROBABLY", 8, 1463},
	{"SERVE", 5, 1464},
	{"FEB", 3, 1465},
	{"ATUR", 4, 1466},
	{"SEP", 3, 1467},
	{"CALLED", 6, 1468},
	{"NTHA", 4, 1469},
	{"GYW", 3, 1470},
	{"RTHA", 4, 1471},
	{"ARTS", 4, 1472},
	{"DIE", 3, 1473},
	{"CKJ", 3, 1474},
	{"POWERED", 7, 1475},
	{"GJA", 3, 1476},
	{"SOLUTIONS", 9, 1477},
	{"EXPERIENCE", 10, 1478},
	{"MEANS", 5, 1479},
	{"IXW", 3, 1480},
	{"EWOR", 4, 1481},
	{"ORET", 4, 1482},
	{"NATION", 6, 1483},
	{"NCLU", 4, 1484},
	{"COLLEGE", 7, 1485},
	{"STAY", 4, 1486},
	{"FALL", 4, 1487},
	{"UBLI", 4, 1488},
	{"LMY", 3, 1489},
	{"BUILD", 5, 1490},
	{"INTEREST", 8, 1491},
	{"ERTO", 4, 1492},
	{"ONTR", 4, 1493},
	{"COURSE", 6, 1494},
	{"KFU", 3, 1495},
	{"RKY", 3, 1496},
	{"CUT", 3, 1497},
	{"RDQ", 3, 1498},
	{"SAYS", 4, 1499},
	{"SENSE", 5, 1500},
	{"PLAN", 4, 1501},
	{"OMET", 4, 1502},
	{"SOMEONE", 7, 1503},
	{"EXPECT", 6, 1504},
	{"MAR", 3, 1505},
	{"HEHA", 4, 1506},
	{"EFFECT", 6, 1507},
	{"DONE", 4, 1508},
	{"BEHIND", 6, 1509},
	{"FRANCE", 6, 1510},
	{"HOUG", 4, 1511},
	{"MICROSOFT", 9, 1512},
	{"HEWO", 4, 1513},
	{"EDFO", 4, 1514},
	{"RECORDS", 7, 1515},
	{"ECOU", 4, 1516},
	{"INGP", 4, 1517},
	{"COSTS", 5, 1518},
	{"ESTR", 4, 1519},
	{"URL", 3, 1520},
	{"DEATH", 5, 1521},
	{"PARTS", 5, 1522},
	{"AUG", 3, 1523},
	{"HGU", 3, 1524},
	{"LYZ", 3, 1525},
	{"XYE", 3, 1526},
	{"DOWNLOADS", 9, 1527},
	{"KILL", 4, 1528},
	{"SUGGEST", 7, 1529},
	{"MILES", 5, 1530},
	{"DEVELOPMENT", 11, 1531},
	{"APPLICATIONS", 12, 1532},
	{"UPY", 3, 1533},
	{"CLASS", 5, 1534},
	{"REMAIN", 6, 1535},
	{"ONIN", 4, 1536},
	{"YZE", 3, 1537},
	{"OUJ", 3, 1538},
	{"ONEO", 4, 1539},
	{"APR", 3, 1540},
	{"HROU", 4, 1541},
	{"HOSTING", 7, 1542},
	{"ECONOMIC", 8, 1543},
	{"RULES", 5, 1544},
	{"CONTROL", 7, 1545},
	{"TICKETS", 7, 1546},
	{"AYV", 3, 1547},
	{"CENTRE", 6, 1548},
	{"REQUIREMENTS", 12, 1549},
	{"ESID", 4, 1550},
	{"NUDE", 4, 1551},
	{"VOICE", 5, 1552},
	{"WKI", 3, 1553},
	{"KIDS", 4, 1554},
	{"REQUIRE", 7, 1555},
	{"PYW", 3, 1556},
	{"EWV", 3, 1557},
	{"OWIN", 4, 1558},
	{"MINUTES", 7, 1559},
	{"FORMER", 6, 1560},
	{"OBW", 3, 1561},
	{"OWJ", 3, 1562},
	{"ZZI", 3, 1563},
	{"ROLE", 4, 1564},
	{"HATW", 4, 1565},
	{"UXU", 3, 1566},
	{"THANK", 5, 1567},
	{"TTHA", 4, 1568},
	{"KYT", 3, 1569},
	{"ISHE", 4, 1570},
	{"FBY", 3, 1571},
	{"GIFTS", 5, 1572},
	{"EUROPE", 6, 1573},
	{"DITI", 4, 1574},
	{"OEU", 3, 1575},
	{"IAK", 3, 1576},
	{"TOPICS", 6, 1577},
	{"ELSE", 4, 1578},
	{"SELL", 4, 1579},
	{"UYO", 3, 1580},
	{"TIPS", 4, 1581},
	{"MAJOR", 5, 1582},
	{"LIGHT", 5, 1583},
	{"SFRO", 4, 1584},
	{"FIELD", 5, 1585},
	{"PULL", 4, 1586},
	{"RODU", 4, 1587},
	{"RATE", 4, 1588},
	{"UJU", 3, 1589},
	{"UYW", 3, 1590},
	{"PERHAPS", 7, 1591},
	{"RAISE", 5, 1592},
	{"VIDEOS", 6, 1593},
	{"PERCENT", 7, 1594},
	{"HARD", 4, 1595},
	{"ENTT", 4, 1596},
	{"ERVI", 4, 1597},
	{"NEOF", 4, 1598},
	{"EFFORT", 6, 1599},
	{"LATE", 4, 1600},
	{"TECH", 4, 1601},
	{"DRUG", 4, 1602},
	{"PASS", 4, 1603},
	{"OKR", 3, 1604},
	{"POLICE", 6, 1605},
	{"PROJECTS", 8, 1606},
	{"LYRICS", 6, 1607},
	{"SUBSCRIBE", 9, 1608},
	{"LEADER", 6, 1609},
	{"NMEN", 4, 1610},
	{"THEMSELVES", 10, 1611},
	{"GERMANY", 7, 1612},
	{"MILITARY", 8, 1613},
	{"NDRE", 4, 1614},
	{"INCLUDED", 8, 1615},
	{"NYV", 3, 1616},
	{"INGB", 4, 1617},
	{"ALONG", 5, 1618},
	{"ARM", 3, 1619},
	{"ANIN", 4, 1620},
	{"SOMETIMES", 9, 1621},
	{"DEVELOP", 7, 1622},
	{"XUR", 3, 1623},
	{"RELATIONSHIP", 12, 1624},
	{"HEART", 5, 1625},
	{"ERFO", 4, 1626},
	{"PRICE", 5, 1627},
	{"WEJ", 3, 1628},
	{"DEALS", 5, 1629},
	{"RZE", 3, 1630},
	{"WORDS", 5, 1631},
	{"LINUX", 5, 1632},
	{"DECIDE", 6, 1633},
	{"JUL", 3, 1634},
	{"BETTER", 6, 1635},
	{"ACCORDING", 9, 1636},
	{"WHOLE", 5, 1637},
	{"JAMES", 5, 1638},
	{"DKO", 3, 1639},
	{"STRONG", 6, 1640},
	{"WIFE", 4, 1641},
	{"NEWSLETTER", 10, 1642},
	{"ARCHIVES", 8, 1643},
	{"POINTS", 6, 1644},
	{"YYA", 3, 1645},
	{"MODEL", 5, 1646},
	{"VALUE", 5, 1647},
	{"XWE", 3, 1648},
	{"LESS", 4, 1649},
	{"DIFFERENCE", 10, 1650},
	{"MIND", 4, 1651},
	{"NTQ", 3, 1652},
	{"JUN", 3, 1653},
	{"DECISION", 8, 1654},
	{"TOYS", 4, 1655},
	{"FINALLY", 7, 1656},
	{"REGISTERED", 10, 1657},
	{"FEDERAL", 7, 1658},
	{"INTERNATIONAL", 13, 1659},
	{"ENIN", 4, 1660},
	{"PLAYER", 6, 1661},
	{"VIEW", 4, 1662},
	{"METHODS", 7, 1663},
	{"KEJ", 3, 1664},
	{"MAKES", 5, 1665},
	{"POLICIES", 8, 1666},
	{"SOCIETY", 7, 1667},
	{"RKG", 3, 1668},
	{"ROAD", 4, 1669},
	{"INDIA", 5, 1670},
	{"LLBE", 4, 1671},
	{"EXPLAIN", 7, 1672},
	{"TAX", 3, 1673},
	{"JOIN", 4, 1674},
	{"TAKEN", 5, 1675},
	{"DRIVE", 5, 1676},
	{"LISTINGS", 8, 1677},
	{"NNIN", 4, 1678},
	{"RECEIVE", 7, 1679},
	{"ULDB", 4, 1680},
	{"MODELS", 6, 1681},
	{"MICHAEL", 7, 1682},
	{"ACTION", 6, 1683},
	{"LLTH", 4, 1684},
	{"LYQ", 3, 1685},
	{"RDIN", 4, 1686},
	{"CTIV", 4, 1687},
	{"TOWN", 4, 1688},
	{"DIRECTOR", 8, 1689},
	{"CASES", 5, 1690},
	{"YIW", 3, 1691},
	{"CARRY", 5, 1692},
	{"FLORIDA", 7, 1693},
	{"BREAK", 5, 1694},
	{"TRUE", 4, 1695},
	{"AHY", 3, 1696},
	{"LDBE", 4, 1697},
	{"HYF", 3, 1698},
	{"OFFICIAL", 8, 1699},
	{"XTB", 3, 1700},
	{"EZW", 3, 1701},
	{"INAT", 4, 1702},
	{"WIRELESS", 8, 1703},
	{"NTTO", 4, 1704},
	{"PAUL", 4, 1705},
	{"FRIDAY", 6, 1706},
	{"ITHI", 4, 1707},
	{"ENTL", 4, 1708},
	{"PUBLISHED", 9, 1709},
	{"TYJ", 3, 1710},
	{"FORM", 4, 1711},
	{"BUILDING", 8, 1712},
	{"SONY", 4, 1713},
	{"SHOWS", 5, 1714},
	{"AINT", 4, 1715},
	{"GOOGLE", 6, 1716},
	{"WJO", 3, 1717},
	{"XWA", 3, 1718},
	{"CUSTOMERS", 9, 1719},
	{"ACTIVITY", 8, 1720},
	{"IONW", 4, 1721},
	{"OMIN", 4, 1722},
	{"WEAR", 4, 1723},
	{"INGM", 4, 1724},
	{"ETIM", 4, 1725},
	{"MATERIALS", 9, 1726},
	{"ERET", 4, 1727},
	{"FULL", 4, 1728},
	{"RECORD", 6, 1729},
	{"SHAV", 4, 1730},
	{"CHAT", 4, 1731},
	{"YMN", 3, 1732},
	{"DESIGNED", 8, 1733},
	{"HJE", 3, 1734},
	{"PICK", 4, 1735},
	{"NDAN", 4, 1736},
	{"POSITION", 8, 1737},
	{"SYI", 3, 1738},
	{"VETH", 4, 1739},
	{"VYW", 3, 1740},
	{"HTML", 4, 1741},
	{"HNU", 3, 1742},
	{"COUNTRIES", 9, 1743},
	{"EEJ", 3, 1744},
	{"AGREE", 5, 1745},
	{"DATA", 4, 1746},
	{"SUPPORT", 7, 1747},
	{"AVET", 4, 1748},
	{"HIGHER", 6, 1749},
	{"ESPECIALLY", 10, 1750},
	{"EFFECTS", 7, 1751},
	{"CREATED", 7, 1752},
	{"OGRA", 4, 1753},
	{"STANDARDS", 9, 1754},
	{"SITE", 4, 1755},
	{"UKO", 3, 1756},
	{"RSAN", 4, 1757},
	{"BASE", 4, 1758},
	{"EREI", 4, 1759},
	{"ADVERTISE", 9, 1760},
	{"ILLB", 4, 1761},
	{"EVENT", 5, 1762},
	{"HEPO", 4, 1763},
	{"PROJECT", 7, 1764},
	{"SPACE", 5, 1765},
	{"PAPER", 5, 1766},
	{"CKV", 3, 1767},
	{"SPECIAL", 7, 1768},
	{"TABLE", 5, 1769},
	{"ILJ", 3, 1770},
	{"JAPAN", 5, 1771},
	{"WHOSE", 5, 1772},
	{"COUPLE", 6, 1773},
	{"FIGURE", 6, 1774},
	{"DTOT", 4, 1775},
	{"OWEV", 4, 1776},
	{"DOING", 5, 1777},
	{"LOANS", 5, 1778},
	{"GROUND", 6, 1779},
	{"SHOES", 5, 1780},
	{"CENTER", 6, 1781},
	{"ORDERS", 6, 1782},
	{"ZWA", 3, 1783},
	{"AFRICA", 6, 1784},
	{"ODJ", 3, 1785},
	{"OIL", 3, 1786},
	{"PRODUCE", 7, 1787},
	{"ECTE", 4, 1788},
	{"COURT", 5, 1789},
	{"NTLY", 4, 1790},
	{"NOTES", 5, 1791},
	{"MPAN", 4, 1792},
	{"MATTER", 6, 1793},
	{"PRACTICE", 8, 1794},
	{"MONDAY", 6, 1795},
	{"STAR", 4, 1796},
	{"SEOF", 4, 1797},
	{"COST", 4, 1798},
	{"PICS", 4, 1799},
	{"ECHA", 4, 1800},
	{"VYA", 3, 1801},
	{"ASBE", 4, 1802},
	{"INDUSTRY", 8, 1803},
	{"AKY", 3, 1804},
	{"NGZ", 3, 1805},
	{"TYOF", 4, 1806},
	{"ONSO", 4, 1807},
	{"ITIE", 4, 1808},
	{"TEACH", 5, 1809},
	{"NOFT", 4, 1810},
	{"UALL", 4, 1811},
	{"CONTENTS", 8, 1812},
	{"SEEN", 4, 1813},
	{"PLAYERS", 7, 1814},
	{"PATIENT", 7, 1815},
	{"IMAGE", 5, 1816},
	{"YGL", 3, 1817},
	{"NDOF", 4, 1818},
	{"EOK", 3, 1819},
	{"REDT", 4, 1820},
	{"AYK", 3, 1821},
	{"SUPPLIES", 8, 1822},
	{"STARTED", 7, 1823},
	{"STREET", 6, 1824},
	{"UEU", 3, 1825},
	{"REPUBLICAN", 10, 1826},
	{"EASY", 4, 1827},
	{"PHONE", 5, 1828},
	{"WKE", 3, 1829},
	{"INSTITUTE", 9, 1830},
	{"VIEWS", 5, 1831},
	{"GYB", 3, 1832},
	{"PECI", 4, 1833},
	{"WALL", 4, 1834},
	{"DESCRIBE", 8, 1835},
	{"TYPES", 5, 1836},
	{"ITSELF", 6, 1837},
	{"SPONSORED", 9, 1838},
	{"LINES", 5, 1839},
	{"SEDT", 4, 1840},
	{"XWH", 3, 1841},
	{"HALF", 4, 1842},
	{"PRODUCT", 7, 1843},
	{"MHU", 3, 1844},
	{"BENEFITS", 8, 1845},
	{"ERSH", 4, 1846},
	{"EHAS", 4, 1847},
	{"RECENT", 6, 1848},
	{"HELD", 4, 1849},
	{"PRINTER", 7, 1850},
	{"NEDT", 4, 1851},
	{"LLIO", 4, 1852},
	{"HECH", 4, 1853},
	{"QUITE", 5, 1854},
	{"WORKER", 6, 1855},
	{"ASKED", 5, 1856},
	{"EDAT", 4, 1857},
	{"EUR", 3, 1858},
	{"LAND", 4, 1859},
	{"GHTH", 4, 1860},
	{"HYR", 3, 1861},
	{"SUNDAY", 6, 1862},
	{"TECHNOLOGY", 10, 1863},
	{"HAIR", 4, 1864},
	{"EITHER", 6, 1865},
	{"DOCTOR", 6, 1866},
	{"COVER", 5, 1867},
	{"MOVIE", 5, 1868},
	{"PICTURE", 7, 1869},
	{"PDF", 3, 1870},
	{"RANC", 4, 1871},
	{"OXW", 3, 1872},
	{"PIECE", 5, 1873},
	{"YSV", 3, 1874},
	{"DHY", 3, 1875},
	{"ERCE", 4, 1876},
	{"CLEAR", 5, 1877},
	{"HEFO", 4, 1878},
	{"ZAA", 3, 1879},
	{"MATURE", 6, 1880},
	{"WINDOW", 6, 1881},
	{"OGH", 3, 1882},
	{"NTZ", 3, 1883},
	{"CATCH", 5, 1884},
	{"RJI", 3, 1885},
	{"TSOF", 4, 1886},
	{"WEEKS", 5, 1887},
	{"NORTH", 5, 1888},
	{"PERSONAL", 8, 1889},
	{"BABY", 4, 1890},
	{"NCET", 4, 1891},
	{"CAME", 4, 1892},
	{"RENC", 4, 1893},
	{"USR", 3, 1894},
	{"OYH", 3, 1895},
	{"COMPUTER", 8, 1896},
	{"TSTH", 4, 1897},
	{"OUTO", 4, 1898},
	{"RSTO", 4, 1899},
	{"ERVE", 4, 1900},
	{"NDCO", 4, 1901},
	{"CERTAIN", 7, 1902},
	{"EFRO", 4, 1903},
	{"CULTURE", 7, 1904},
	{"DC", 2, 1905},
	{"TTIN", 4, 1906},
	{"THIRD", 5, 1907},
	{"ESHO", 4, 1908},
	{"MON", 3, 1909},
	{"IXF", 3, 1910},
	{"TSTO", 4, 1911},
	{"SOURCE", 6, 1912},
	{"COM", 3, 1913},
	{"EENT", 4, 1914},
	{"FILM", 4, 1915},
	{"SIMPLY", 6, 1916},
	{"DBYT", 4, 1917},
	{"HOUL", 4, 1918},
	{"TREE", 4, 1919},
	{"NGOF", 4, 1920},
	{"OMPL", 4, 1921},
	{"UOI", 3, 1922},
	{"NAMES", 5, 1923},
	{"ROBERT", 6, 1924},
	{"HOMEPAGE", 8, 1925},
	{"STEP", 4, 1926},
	{"RED", 3, 1927},
	{"INGD", 4, 1928},
	{"OWV", 3, 1929},
	{"SKILLS", 6, 1930},
	{"YSTE", 4, 1931},
	{"OIW", 3, 1932},
	{"HETO", 4, 1933},
	{"ISLANDS", 7, 1934},
	{"ISIO", 4, 1935},
	{"OWTH", 4, 1936},
	{"CETH", 4, 1937},
	{"UNJ", 3, 1938},
	{"NTRO", 4, 1939},
	{"TEDB", 4, 1940},
	{"EDHI", 4, 1941},
	{"CENTURY", 7, 1942},
	{"TEENS", 5, 1943},
	{"EFIN", 4, 1944},
	{"PRE", 3, 1945},
	{"EVIDENCE", 8, 1946},
	{"FACILITIES", 10, 1947},
	{"ATTENTION", 9, 1948},
	{"BILLION", 7, 1949},
	{"DRAW", 4, 1950},
	{"RTOF", 4, 1951},
	{"SELLERS", 7, 1952},
	{"LISTEN", 6, 1953},
	{"ITHO", 4, 1954},
	{"ENTU", 4, 1955},
	{"XME", 3, 1956},
	{"HASB", 4, 1957},
	{"DYU", 3, 1958},
	{"NEARLY", 6, 1959},
	{"NDIT", 4, 1960},
	{"OPPORTUNITIES", 13, 1961},
	{"TAKING", 6, 1962},
	{"DNOT", 4, 1963},
	{"OGET", 4, 1964},
	{"VALUES", 6, 1965},
	{"HISF", 4, 1966},
	{"NDSO", 4, 1967},
	{"TUESDAY", 7, 1968},
	{"OKD", 3, 1969},
	{"OYB", 3, 1970},
	{"FIW", 3, 1971},
	{"PERIOD", 6, 1972},
	{"CAUSE", 5, 1973},
	{"EUNI", 4, 1974},
	{"IESA", 4, 1975},
	{"NTTH", 4, 1976},
	{"CHOOSE", 6, 1977},
	{"RSIN", 4, 1978},
	{"LOGO", 4, 1979},
	{"SBEE", 4, 1980},
	{"CAMPAIGN", 8, 1981},
	{"ENERGY", 6, 1982},
	{"PPOR", 4, 1983},
	{"DIFFICULT", 9, 1984},
	{"RETURNS", 7, 1985},
	{"NWAS", 4, 1986},
	{"ROFT", 4, 1987},
	{"SHOWN", 5, 1988},
	{"OLIC", 4, 1989},
	{"TMEN", 4, 1990},
	{"SATURDAY", 8, 1991},
	{"ECAM", 4, 1992},
	{"PLANT", 5, 1993},
	{"ROVI", 4, 1994},
	{"ENGLAND", 7, 1995},
	{"ETWE", 4, 1996},
	{"HESO", 4, 1997},
	{"BROTHER", 7, 1998},
	{"AXW", 3, 1999},
	{"NGFO", 4, 2000},
	{"KFE", 3, 2001},
	{"GEORGE", 6, 2002},
	{"GKE", 3, 2003},
	{"WENT", 4, 2004},
	{"LIKELY", 6, 2005},
	{"POPULATION", 10, 2006},
	{"TERM", 4, 2007},
	{"REGISTRATION", 12, 2008},
	{"EYOU", 4, 2009},
	{"ASTO", 4, 2010},
	{"LDIN", 4, 2011},
	{"CONGRESS", 8, 2012},
	{"FRI", 3, 2013},
	{"ERSW", 4, 2014},
	{"UAY", 3, 2015},
	{"HISW", 4, 2016},
	{"CHANCE", 6, 2017},
	{"THURSDAY", 8, 2018},
	{"COURSES", 7, 2019},
	{"BEHAVIOR", 8, 2020},
	{"SUMMER", 6, 2021},
	{"YSJ", 3, 2022},
	{"NTHI", 4, 2023},
	{"IXD", 3, 2024},
	{"FLOOR", 5, 2025},
	{"MATERIAL", 8, 2026},
	{"OPPORTUNITY", 11, 2027},
	{"EVU", 3, 2028},
	{"ONTI", 4, 2029},
	{"ITYO", 4, 2030},
	{"LJE", 3, 2031},
	{"LEVELS", 6, 2032},
	{"PHONES", 6, 2033},
	{"IDEAS", 5, 2034},
	{"WEDNESDAY", 9, 2035},
	{"ARKE", 4, 2036},
	{"OEY", 3, 2037},
	{"ADMINISTRATION", 14, 2038},
	{"EATT", 4, 2039},
	{"IEJ", 3, 2040},
	{"NSAN", 4, 2041},
	{"DEDT", 4, 2042},
	{"RELEASES", 8, 2043},
	{"WED", 3, 2044},
	{"HOMES", 5, 2045},
	{"XTG", 3, 2046},
	{"REALIZE", 7, 2047},
	{"VIRGINIA", 8, 2048},
	{"EAQ", 3, 2049},
	{"SUBJECT", 7, 2050},
	{"IXH", 3, 2051},
	{"TOOK", 4, 2052},
	{"LOCATED", 7, 2053},
	{"HUNDRED", 7, 2054},
	{"CURRENT", 7, 2055},
	{"IVED", 4, 2056},
	{"VEBE", 4, 2057},
	{"ULAT", 4, 2058},
	{"RULE", 4, 2059},
	{"ENAT", 4, 2060},
	{"ECONOMY", 7, 2061},
	{"CLOSE", 5, 2062},
	{"CNET", 4, 2063},
	{"LTD", 3, 2064},
	{"LOS", 3, 2065},
	{"UMBE", 4, 2066},
	{"RNIN", 4, 2067},
	{"SOUTH", 5, 2068},
	{"FEATURED", 8, 2069},
	{"YZA", 3, 2070},
	{"ROOMS", 5, 2071},
	{"NDON", 4, 2072},
	{"STOT", 4, 2073},
	{"CHOICE", 6, 2074},
	{"OUU", 3, 2075},
	{"SHORT", 5, 2076},
	{"INCREASE", 8, 2077},
	{"RISK", 4, 2078},
	{"DAUGHTER", 8, 2079},
	{"INC", 3, 2080},
	{"LETTER", 6, 2081},
	{"ERNM", 4, 2082},
	{"RNED", 4, 2083},
	{"BED", 3, 2084},
	{"THOMAS", 6, 2085},
	{"NUMBERS", 7, 2086},
	{"NDST", 4, 2087},
	{"HUSBAND", 7, 2088},
	{"OSIT", 4, 2089},
	{"OLLO", 4, 2090},
	{"SINGLE", 6, 2091},
	{"UCHA", 4, 2092},
	{"EALS", 4, 2093},
	{"BROWSER", 7, 2094},
	{"PERFORMANCE", 11, 2095},
	{"ALRE", 4, 2096},
	{"TTHI", 4, 2097},
	{"RSOF", 4, 2098},
	{"ROGR", 4, 2099},
	{"CERTAINLY", 9, 2100},
	{"MYSELF", 6, 2101},
	{"OFHI", 4, 2102},
	{"DEFENSE", 7, 2103},
	{"INVOLVE", 7, 2104},
	{"NTAN", 4, 2105},
	{"CHURCH", 6, 2106},
	{"COMES", 5, 2107},
	{"PER", 3, 2108},
	{"FIRE", 4, 2109},
	{"YKO", 3, 2110},
	{"CAMERAS", 7, 2111},
	{"HEFA", 4, 2112},
	{"OGW", 3, 2113},
	{"MAPS", 4, 2114},
	{"NGWI", 4, 2115},
	{"SPORT", 5, 2116},
	{"UXI", 3, 2117},
	{"BANK", 4, 2118},
	{"RATINGS", 7, 2119},
	{"WRONG", 5, 2120},
	{"CHICAGO", 7, 2121},
	{"SIGNIFICANT", 11, 2122},
	{"SECURITY", 8, 2123},
	{"FORMS", 5, 2124},
	{"REPRESENT", 9, 2125},
	{"GOAL", 4, 2126},
	{"EWHO", 4, 2127},
	{"TUE", 3, 2128},
	{"SMITH", 5, 2129},
	{"WANTED", 6, 2130},
	{"DEVELOPED", 9, 2131},
	{"SEEK", 4, 2132},
	{"DFRO", 4, 2133},
	{"ZHO", 3, 2134},
	{"BOARD", 5, 2135},
	{"THOUSAND", 8, 2136},
	{"QAN", 3, 2137},
	{"AUTHOR", 6, 2138},
	{"ANYONE", 6, 2139},
	{"URRE", 4, 2140},
	{"YEQ", 3, 2141},
	{"WEST", 4, 2142},
	{"UQU", 3, 2143},
	{"NWIT", 4, 2144},
	{"FUTURE", 6, 2145},
	{"NATURE", 6, 2146},
	{"ZZO", 3, 2147},
	{"EBEE", 4, 2148},
	{"SOURCES", 7, 2149},
	{"MEXICO", 6, 2150},
	{"EALT", 4, 2151},
	{"THROW", 5, 2152},
	{"TOP", 3, 2153},
	{"UEJ", 3, 2154},
	{"ETUR", 4, 2155},
	{"OFFICER", 7, 2156},
	{"FACTOR", 6, 2157},
	{"SWHO", 4, 2158},
	{"FOREIGN", 7, 2159},
	{"NAVIGATION", 10, 2160},
	{"RNME", 4, 2161},
	{"UPPO", 4, 2162},
	{"OPERATIONS", 10, 2163},
	{"DEAL", 4, 2164},
	{"NTEN", 4, 2165},
	{"UCTI", 4, 2166},
	{"AVEB", 4, 2167},
	{"YMR", 3, 2168},
	{"PRIVATE", 7, 2169},
	{"MQU", 3, 2170},
	{"PAYPAL", 6, 2171},
	{"FOCUS", 5, 2172},
	{"HESU", 4, 2173},
	{"THUS", 4, 2174},
	{"UPON", 4, 2175},
	{"REDUCE", 6, 2176},
	{"NOTE", 4, 2177},
	{"UTIO", 4, 2178},
	{"THU", 3, 2179},
	{"HETR", 4, 2180},
	{"YIC", 3, 2181},
	{"COLOR", 5, 2182},
	{"AGENCY", 6, 2183},
	{"UHO", 3, 2184},
	{"RENTALS", 7, 2185},
	{"FILL", 4, 2186},
	{"BUILT", 5, 2187},
	{"PUBLICATIONS", 12, 2188},
	{"FIGHT", 5, 2189},
	{"SOUND", 5, 2190},
	{"PPEA", 4, 2191},
	{"ORAT", 4, 2192},
	{"REST", 4, 2193},
	{"LARGER", 6, 2194},
	{"NDAR", 4, 2195},
	{"ANTI", 4, 2196},
	{"PAST", 4, 2197},
	{"HEGR", 4, 2198},
	{"NETWORKS", 8, 2199},
	{"ORDER", 5, 2200},
	{"PARENTS", 7, 2201},
	{"NOKIA", 5, 2202},
	{"QUICKLY", 7, 2203},
	{"DROP", 4, 2204},
	{"EYEA", 4, 2205},
	{"OEW", 3, 2206},
	{"PLET", 4, 2207},
	{"RTIC", 4, 2208},
	{"BLOOD", 5, 2209},
	{"ENOT", 4, 2210},
	{"LEDT", 4, 2211},
	{"RESPONSE", 8, 2212},
	{"YINT", 4, 2213},
	{"TETH", 4, 2214},
	{"TEL", 3, 2215},
	{"IENC", 4, 2216},
	{"CAROLINA", 8, 2217},
	{"MOVEMENT", 8, 2218},
	{"PROPERTIES", 10, 2219},
	{"STORE", 5, 2220},
	{"OVERVIEW", 8, 2221},
	{"KETH", 4, 2222},
	{"PUSH", 4, 2223},
	{"FKO", 3, 2224},
	{"ACCOMMODATION", 13, 2225},
	{"OWNERS", 6, 2226},
	{"RECENTLY", 8, 2227},
	{"RNJ", 3, 2228},
	{"RVIC", 4, 2229},
	{"COMMON", 6, 2230},
	{"PAGE", 4, 2231},
	{"SIMILAR", 7, 2232},
	{"OTHI", 4, 2233},
	{"LANGUAGE", 8, 2234},
	{"PAID", 4, 2235},
	{"ITALY", 5, 2236},
	{"UNTR", 4, 2237},
	{"MMUN", 4, 2238},
	{"OFCO", 4, 2239},
	{"GJE", 3, 2240},
	{"NATURAL", 7, 2241},
	{"CITIES", 6, 2242},
	{"WILLIAM", 7, 2243},
	{"ANAL", 4, 2244},
	{"OLOG", 4, 2245},
	{"CONCERN", 7, 2246},
	{"DEAD", 4, 2247},
	{"PETER", 5, 2248},
	{"HESI", 4, 2249},
	{"HLU", 3, 2250},
	{"OACH", 4, 2251},
	{"NSIN", 4, 2252},
	{"UTOF", 4, 2253},
	{"ARTICLE", 7, 2254},
	{"NEAR", 4, 2255},
	{"INTERFACE", 9, 2256},
	{"RACE", 4, 2257},
	{"ECAN", 4, 2258},
	{"OMMU", 4, 2259},
	{"IFFE", 4, 2260},
	{"PM", 2, 2261},
	{"ESON", 4, 2262},
	{"INDIVIDUAL", 10, 2263},
	{"NGRE", 4, 2264},
	{"PARTNERS", 8, 2265},
	{"YSQ", 3, 2266},
	{"EREW", 4, 2267},
	{"RATED", 5, 2268},
	{"GUIDES", 6, 2269},
	{"NSID", 4, 2270},
	{"SERIES", 6, 2271},
	{"EENA", 4, 2272},
	{"ENTER", 5, 2273},
	{"FICI", 4, 2274},
	{"NTST", 4, 2275},
	{"ARTIST", 6, 2276},
	{"IEVE", 4, 2277},
	{"STOCK", 5, 2278},
	{"TTEN", 4, 2279},
	{"AMAZON", 6, 2280},
	{"PATIENTS", 8, 2281},
	{"RESTAURANTS", 11, 2282},
	{"LOCATIONS", 9, 2283},
	{"HEHO", 4, 2284},
	{"NSOF", 4, 2285},
	{"SHARE", 5, 2286},
	{"ETWO", 4, 2287},
	{"FLOWERS", 7, 2288},
	{"APPROACH", 8, 2289},
	{"STARS", 5, 2290},
	{"IFTH", 4, 2291},
	{"LISTS", 5, 2292},
	{"FUND", 4, 2293},
	{"TECHNOLOGIES", 12, 2294},
	{"ANALYSIS", 8, 2295},
	{"POOR", 4, 2296},
	{"ANIMALS", 7, 2297},
	{"WAYS", 4, 2298},
	{"DECADE", 6, 2299},
	{"YOFT", 4, 2300},
	{"CUP", 3, 2301},
	{"PROVIDING", 9, 2302},
	{"ANAG", 4, 2303},
	{"YTHI", 4, 2304},
	{"ESIG", 4, 2305},
	{"RISE", 4, 2306},
	{"MAC", 3, 2307},
	{"IDENTIFY", 8, 2308},
	{"USUALLY", 7, 2309},
	{"TAKES", 5, 2310},
	{"RZO", 3, 2311},
	{"RESOURCE", 8, 2312},
	{"NDHE", 4, 2313},
	{"TREATMENT", 9, 2314},
	{"HEDA", 4, 2315},
	{"ONSH", 4, 2316},
	{"RCEN", 4, 2317},
	{"INDICATE", 8, 2318},
	{"XBU", 3, 2319},
	{"SEARCHES", 8, 2320},
	{"MAX", 3, 2321},
	{"TRYING", 6, 2322},
	{"KSY", 3, 2323},
	{"ANIMAL", 6, 2324},
	{"CONSIDERED", 10, 2325},
	{"SHOOT", 5, 2326},
	{"EAST", 4, 2327},
	{"RSIT", 4, 2328},
	{"TOLD", 4, 2329},
	{"XML", 3, 2330},
	{"PROGRAMME", 9, 2331},
	{"HERSELF", 7, 2332},
	{"JOINED", 6, 2333},
	{"EWIL", 4, 2334},
	{"OHY", 3, 2335},
	{"LDRE", 4, 2336},
	{"BIN", 3, 2337},
	{"DOFT", 4, 2338},
	{"OCCUR", 5, 2339},
	{"ESHE", 4, 2340},
	{"EXACTLY", 7, 2341},
	{"ETIN", 4, 2342},
	{"IRELAND", 7, 2343},
	{"FHIS", 4, 2344},
	{"CENTRAL", 7, 2345},
	{"DOG", 3, 2346},
	{"UNITS", 5, 2347},
	{"QUALITY", 7, 2348},
	{"WROTE", 5, 2349},
	{"IDTH", 4, 2350},
	{"SHIPS", 5, 2351},
	{"DETERMINE", 9, 2352},
	{"NSTO", 4, 2353},
	{"CAREER", 6, 2354},
	{"RSTH", 4, 2355},
	{"SAVE", 4, 2356},
	{"MD", 2, 2357},
	{"SWHI", 4, 2358},
	{"FL", 2, 2359},
	{"DERT", 4, 2360},
	{"SIZE", 4, 2361},
	{"ERIO", 4, 2362},
	{"MB", 2, 2363},
	{"LPY", 3, 2364},
	{"MEDIA", 5, 2365},
	{"ASIA", 4, 2366},
	{"HEYW", 4, 2367},
	{"NGLE", 4, 2368},
	{"GWIT", 4, 2369},
	{"OXB", 3, 2370},
	{"LIE", 3, 2371},
	{"USES", 4, 2372},
	{"ERTA", 4, 2373},
	{"YMM", 3, 2374},
	{"FUNDS", 5, 2375},
	{"DESPITE", 7, 2376},
	{"THOUGHT", 7, 2377},
	{"IONF", 4, 2378},
	{"GREATER", 7, 2379},
	{"OYN", 3, 2380},
	{"ABILITY", 7, 2381},
	{"PHYSICAL", 8, 2382},
	{"NDTO", 4, 2383},
	{"EMPLOYEES", 9, 2384},
	{"ARTISTS", 7, 2385},
	{"ELECTION", 8, 2386},
	{"XNE", 3, 2387},
	{"RREN", 4, 2388},
	{"SCENE", 5, 2389},
	{"DISEASE", 7, 2390},
	{"JAVA", 4, 2391},
	{"ENVIRONMENTAL", 13, 2392},
	{"EVERYBODY", 9, 2393},
	{"SEEMS", 5, 2394},
	{"EMAR", 4, 2395},
	{"RELATIONS", 9, 2396},
	{"ZLI", 3, 2397},
	{"ARGUE", 5, 2398},
	{"IVIN", 4, 2399},
	{"CONTAINS", 8, 2400},
	{"XYG", 3, 2401},
	{"DTOB", 4, 2402},
	{"MULTI", 5, 2403},
	{"DWAS", 4, 2404},
	{"REGION", 6, 2405},
	{"GROWTH", 6, 2406},
	{"ATTACK", 6, 2407},
	{"WONDER", 6, 2408},
	{"NCON", 4, 2409},
	{"FEES", 4, 2410},
	{"COMPONENTS", 10, 2411},
	{"READY", 5, 2412},
	{"AIDT", 4, 2413},
	{"PRESSURE", 8, 2414},
	{"OFIN", 4, 2415},
	{"BEYOND", 6, 2416},
	{"COMPLETED", 9, 2417},
	{"LIST", 4, 2418},
	{"RCHA", 4, 2419},
	{"GRAPHICS", 8, 2420},
	{"PROTECT", 7, 2421},
	{"EONE", 4, 2422},
	{"DEGREE", 6, 2423},
	{"SIMPLE", 6, 2424},
	{"SUCCESS", 7, 2425},
	{"EQUE", 4, 2426},
	{"PREV", 4, 2427},
	{"LEFT", 4, 2428},
	{"EDFR", 4, 2429},
	{"SKILL", 5, 2430},
	{"ADS", 3, 2431},
	{"PRETTY", 6, 2432},
	{"IBY", 3, 2433},
	{"KNOWLEDGE", 9, 2434},
	{"MARY", 4, 2435},
	{"PARTICULARLY", 12, 2436},
	{"FYF", 3, 2437},
	{"SERIOUS", 7, 2438},
	{"RYIN", 4, 2439},
	{"EBUT", 4, 2440},
	{"DATING", 6, 2441},
	{"WHATEVER", 8, 2442},
	{"HEGA", 4, 2443},
	{"PACIFIC", 7, 2444},
	{"ONTA", 4, 2445},
	{"UIZ", 3, 2446},
	{"STAFF", 5, 2447},
	{"NDHA", 4, 2448},
	{"ORGANIZATIONS", 13, 2449},
	{"PQU", 3, 2450},
	{"SIGN", 4, 2451},
	{"RECOGNIZE", 9, 2452},
	{"MAILING", 7, 2453},
	{"LONGER", 6, 2454},
	{"TRAINING", 8, 2455},
	{"ANSWER", 6, 2456},
	{"OURC", 4, 2457},
	{"ACCEPT", 6, 2458},
	{"AMOUNT", 6, 2459},
	{"INGU", 4, 2460},
	{"MEETING", 7, 2461},
	{"QWH", 3, 2462},
	{"ONTE", 4, 2463},
	{"STANDARD", 8, 2464},
	{"EOX", 3, 2465},
	{"MEOF", 4, 2466},
	{"OTQ", 3, 2467},
	{"HENO", 4, 2468},
	{"HETI", 4, 2469},
	{"SECTION", 7, 2470},
	{"LOSS", 4, 2471},
	{"TRADE", 5, 2472},
	{"GLASS", 5, 2473},
	{"TELEVISION", 10, 2474},
	{"NSTH", 4, 2475},
	{"BOX", 3, 2476},
	{"PRESENT", 7, 2477},
	{"GENERAL", 7, 2478},
	{"LEOF", 4, 2479},
	{"CHARACTER", 9, 2480},
	{"NHY", 3, 2481},
	{"BUYING", 6, 2482},
	{"DEFAULT", 7, 2483},
	{"IRAQ", 4, 2484},
	{"RKIN", 4, 2485},
	{"ICUL", 4, 2486},
	{"BOYS", 4, 2487},
	{"URNE", 4, 2488},
	{"ESWI", 4, 2489},
	{"IXB", 3, 2490},
	{"LAY", 3, 2491},
	{"ALLOWS", 6, 2492},
	{"TWOR", 4, 2493},
	{"VEQ", 3, 2494},
	{"GYH", 3, 2495},
	{"PREPARE", 7, 2496},
	{"REPORTED", 8, 2497},
	{"SBUT", 4, 2498},
	{"MYJ", 3, 2499},
	{"CTUR", 4, 2500},
	{"STRATEGY", 8, 2501},
	{"THAV", 4, 2502},
	{"MM", 2, 2503},
	{"XHO", 3, 2504},
	{"MINI", 4, 2505},
	{"EEND", 4, 2506},
	{"BILL", 4, 2507},
	{"EREP", 4, 2508},
	{"DISCLAIMER", 10, 2509},
	{"AUTHORS", 7, 2510},
	{"BOARDS", 6, 2511},
	{"REOF", 4, 2512},
	{"RIY", 3, 2513},
	{"PARTIES", 7, 2514},
	{"EGAM", 4, 2515},
	{"OPUL", 4, 2516},
	{"RTAN", 4, 2517},
	{"MODIFIED", 8, 2518},
	{"DESIGN", 6, 2519},
	{"RELEASED", 8, 2520},
	{"RUCT", 4, 2521},
	{"BENEFIT", 7, 2522},
	{"KVE", 3, 2523},
	{"ERMI", 4, 2524},
	{"GOODS", 5, 2525},
	{"LAUGH", 5, 2526},
	{"RECOMMENDED", 11, 2527},
	{"HISM", 4, 2528},
	{"ANBE", 4, 2529},
	{"HEPL", 4, 2530},
	{"RICHARD", 7, 2531},
	{"NCRE", 4, 2532},
	{"ASRE", 4, 2533},
	{"RYQ", 3, 2534},
	{"APPROVED", 8, 2535},
	{"ITHH", 4, 2536},
	{"HATC", 4, 2537},
	{"DCY", 3, 2538},
	{"SISTER", 6, 2539},
	{"NTIL", 4, 2540},
	{"RMAT", 4, 2541},
	{"COMPARE", 7, 2542},
	{"GUESS", 5, 2543},
	{"CRIME", 5, 2544},
	{"FUNCTIONS", 9, 2545},
	{"NTON", 4, 2546},
	{"IALL", 4, 2547},
	{"LAWYER", 6, 2548},
	{"PTIO", 4, 2549},
	{"BRANDS", 6, 2550},
	{"PLACES", 6, 2551},
	{"ENVIRONMENT", 11, 2552},
	{"FINANCIAL", 9, 2553},
	{"KMY", 3, 2554},
	{"PHP", 3, 2555},
	{"NDWA", 4, 2556},
	{"EWHE", 4, 2557},
	{"ERWA", 4, 2558},
	{"TRADEMARKS", 10, 2559},
	{"ZZE", 3, 2560},
	{"PHENTERMINE", 11, 2561},
	{"SPAIN", 5, 2562},
	{"ASWE", 4, 2563},
	{"BLUE", 4, 2564},
	{"EARC", 4, 2565},
	{"DARK", 4, 2566},
	{"HTJ", 3, 2567},
	{"TONIGHT", 7, 2568},
	{"SUBMITTED", 9, 2569},
	{"BOSTON", 6, 2570},
	{"FAIL", 4, 2571},
	{"TYEA", 4, 2572},
	{"KEYWORDS", 8, 2573},
	{"LEG", 3, 2574},
	{"YEB", 3, 2575},
	{"ARRIVE", 6, 2576},
	{"ONOM", 4, 2577},
	{"ATET", 4, 2578},
	{"PURPOSES", 8, 2579},
	{"FEELING", 7, 2580},
	{"EXECUTIVE", 9, 2581},
	{"SETS", 4, 2582},
	{"AUTHORITY", 9, 2583},
	{"GUN", 3, 2584},
	{"DEMOCRATIC", 10, 2585},
	{"EGRE", 4, 2586},
	{"OPERATION", 9, 2587},
	{"MSN", 3, 2588},
	{"ERWH", 4, 2589},
	{"TOFI", 4, 2590},
	{"DEFINED", 7, 2591},
	{"STHI", 4, 2592},
	{"PAPERS", 6, 2593},
	{"PLAYING", 7, 2594},
	{"AWARDS", 6, 2595},
	{"INHI", 4, 2596},
	{"EXAMPLE", 7, 2597},
	{"SORT", 4, 2598},
	{"KYH", 3, 2599},
	{"ESTABLISHED", 11, 2600},
	{"ANSWERS", 7, 2601},
	{"NDEN", 4, 2602},
	{"ONFO", 4, 2603},
	{"DEMOCRAT", 8, 2604},
	{"LAS", 3, 2605},
	{"NDSA", 4, 2606},
	{"DISCUSS", 7, 2607},
	{"ICHA", 4, 2608},
	{"OHAV", 4, 2609},
	{"GTHA", 4, 2610},
	{"VARIOUS", 7, 2611},
	{"SIBL", 4, 2612},
	{"AXY", 3, 2613},
	{"HANG", 4, 2614},
	{"ESFO", 4, 2615},
	{"OUTSIDE", 7, 2616},
	{"YUT", 3, 2617},
	{"MIN", 3, 2618},
	{"EHAV", 4, 2619},
	{"NSHI", 4, 2620},
	{"PROFESSOR", 9, 2621},
	{"OFFERED", 7, 2622},
	{"MISS", 4, 2623},
	{"YTHA", 4, 2624},
	{"SWEL", 4, 2625},
	{"RELIGIOUS", 9, 2626},
	{"OUNC", 4, 2627},
	{"GHTE", 4, 2628},
	{"STAGE", 5, 2629},
	{"STATION", 7, 2630},
	{"ANCI", 4, 2631},
	{"UDIN", 4, 2632},
	{"WQU", 3, 2633},
	{"MANAGER", 7, 2634},
	{"INDEED", 6, 2635},
	{"ESOU", 4, 2636},
	{"TEACHERS", 8, 2637},
	{"ENTW", 4, 2638},
	{"ISBN", 4, 2639},
	{"MARTIN", 6, 2640},
	{"TOHA", 4, 2641},
	{"NGCO", 4, 2642},
	{"CLEARLY", 7, 2643},
	{"EREM", 4, 2644},
	{"DCON", 4, 2645},
	{"SUBJECTS", 8, 2646},
	{"AGENTS", 6, 2647},
	{"HEGO", 4, 2648},
	{"CHECK", 5, 2649},
	{"SCIENCE", 7, 2650},
	{"ZUE", 3, 2651},
	{"URQ", 3, 2652},
	{"ISAL", 4, 2653},
	{"CULTURAL", 8, 2654},
	{"ACT", 3, 2655},
	{"ISRE", 4, 2656},
	{"RNAT", 4, 2657},
	{"SONGS", 5, 2658},
	{"FORGET", 6, 2659},
	{"THEORY", 6, 2660},
	{"IAZ", 3, 2661},
	{"TOPR", 4, 2662},
	{"HANDS", 5, 2663},
	{"VYI", 3, 2664},
	{"SONG", 4, 2665},
	{"ASSOCIATES", 10, 2666},
	{"TOFA", 4, 2667},
	{"REFO", 4, 2668},
	{"OMMI", 4, 2669},
	{"URSE", 4, 2670},
	{"CANB", 4, 2671},
	{"ROCK", 4, 2672},
	{"UPDATES", 7, 2673},
	{"DESKTOP", 7, 2674},
	{"CLASSES", 7, 2675},
	{"PARIS", 5, 2676},
	{"SHAKE", 5, 2677},
	{"TRUTH", 5, 2678},
	{"OHIO", 4, 2679},
	{"GETS", 4, 2680},
	{"NETWORK", 7, 2681},
	{"MANAGEMENT", 10, 2682},
	{"TYOU", 4, 2683},
	{"REQUIRES", 8, 2684},
	{"EALI", 4, 2685},
	{"JERSEY", 6, 2686},
	{"AYED", 4, 2687},
	{"RATHER", 6, 2688},
	{"SWOR", 4, 2689},
	{"SAW", 3, 2690},
	{"INSTRUMENTS", 11, 2691},
	{"QUOTES", 6, 2692},
	{"CELL", 4, 2693},
	{"LEGAL", 5, 2694},
	{"ULDN", 4, 2695},
	{"SSTH", 4, 2696},
	{"OMME", 4, 2697},
	{"NTRE", 4, 2698},
	{"NICE", 4, 2699},
	{"BUSINESSES", 10, 2700},
	{"FIRM", 4, 2701},
	{"NDHI", 4, 2702},
	{"RNV", 3, 2703},
	{"REMOVE", 6, 2704},
	{"GREEN", 5, 2705},
	{"SPECIFIED", 9, 2706},
	{"SDAY", 4, 2707},
	{"COLD", 4, 2708},
	{"MIKE", 4, 2709},
	{"EARA", 4, 2710},
	{"OWNA", 4, 2711},
	{"PST", 3, 2712},
	{"TRIAL", 5, 2713},
	{"EKY", 3, 2714},
	{"PROCEDURES", 10, 2715},
	{"SEAT", 4, 2716},
	{"EYES", 4, 2717},
	{"WORKERS", 7, 2718},
	{"GEORGIA", 7, 2719},
	{"PROVE", 5, 2720},
	{"UOV", 3, 2721},
	{"CLAIM", 5, 2722},
	{"TOM", 3, 2723},
	{"EHIS", 4, 2724},
	{"RMER", 4, 2725},
	{"SHOWING", 7, 2726},
	{"ABOVE", 5, 2727},
	{"SPRING", 6, 2728},
	{"DEVICES", 7, 2729},
	{"LORD", 4, 2730},
	{"ITHS", 4, 2731},
	{"SUB", 3, 2732},
	{"ENTIRE", 6, 2733},
	{"RGAN", 4, 2734},
	{"CEIV", 4, 2735},
	{"MEASURE", 7, 2736},
	{"EWHI", 4, 2737},
	{"EXPERT", 6, 2738},
	{"NFRO", 4, 2739},
	{"WATCHES", 7, 2740},
	{"CAREERS", 7, 2741},
	{"MPOR", 4, 2742},
	{"IMPACT", 6, 2743},
	{"DHAV", 4, 2744},
	{"GOES", 4, 2745},
	{"MAIN", 4, 2746},
	{"FAMILIES", 8, 2747},
	{"EFEN", 4, 2748},
	{"TRADITIONAL", 11, 2749},
	{"EADI", 4, 2750},
	{"LED", 3, 2751},
	{"STRUCTURE", 9, 2752},
	{"HEPE", 4, 2753},
	{"CARD", 4, 2754},
	{"FINAL", 5, 2755},
	{"GYL", 3, 2756},
	{"OWNT", 4, 2757},
	{"ONTO", 4, 2758},
	{"MEMORY", 6, 2759},
	{"BALL", 4, 2760},
	{"MAINTAIN", 8, 2761},
	{"IMAGINE", 7, 2762},
	{"ZCO", 3, 2763},
	{"ASNO", 4, 2764},
	{"BLOGS", 5, 2765},
	{"ACCEPTED", 8, 2766},
	{"YOURSELF", 8, 2767},
	{"MMER", 4, 2768},
	{"HITS", 4, 2769},
	{"SUDDENLY", 8, 2770},
	{"ECUR", 4, 2771},
	{"GALLERIES", 9, 2772},
	{"NTAI", 4, 2773},
	{"OCAT", 4, 2774},
	{"NTIO", 4, 2775},
	{"CHAIR", 5, 2776},
	{"CANDIDATE", 9, 2777},
	{"REFERENCES", 10, 2778},
	{"PRESENTED", 9, 2779},
	{"JACK", 4, 2780},
	{"NDAL", 4, 2781},
	{"WEAPON", 6, 2782},
	{"CEIN", 4, 2783},
	{"FINISH", 6, 2784},
	{"AGENCIES", 8, 2785},
	{"EHEA", 4, 2786},
	{"KGE", 3, 2787},
	{"RESPECTIVE", 10, 2788},
	{"SWHE", 4, 2789},
	{"VYT", 3, 2790},
	{"OCY", 3, 2791},
	{"MICHIGAN", 8, 2792},
	{"TLEA", 4, 2793},
	{"VISIT", 5, 2794},
	{"STATEMENT", 9, 2795},
	{"HEUS", 4, 2796},
	{"AVOID", 5, 2797},
	{"COLUMBIA", 8, 2798},
	{"SHOULDER", 8, 2799},
	{"HEWE", 4, 2800},
	{"EMPLOYEE", 8, 2801},
	{"HEWI", 4, 2802},
	{"HIGHEST", 7, 2803},
	{"FYOU", 4, 2804},
	{"METHOD", 6, 2805},
	{"HATM", 4, 2806},
	{"REVEAL", 6, 2807},
	{"HUGE", 4, 2808},
	{"NDSE", 4, 2809},
	{"AMEA", 4, 2810},
	{"CONTAIN", 7, 2811},
	{"ANGELES", 7, 2812},
	{"NETWORKING", 10, 2813},
	{"ECEI", 4, 2814},
	{"POPULAR", 7, 2815},
	{"OOZ", 3, 2816},
	{"SPECIFIC", 8, 2817},
	{"APPLY", 5, 2818},
	{"NTUR", 4, 2819},
	{"EINC", 4, 2820},
	{"ONGT", 4, 2821},
	{"CHARGE", 6, 2822},
	{"STIT", 4, 2823},
	{"AUSTRALIAN", 10, 2824},
	{"PARTICULAR", 10, 2825},
	{"ERWI", 4, 2826},
	{"NTRI", 4, 2827},
	{"PEACE", 5, 2828},
	{"GIVES", 5, 2829},
	{"LTHO", 4, 2830},
	{"KB", 2, 2831},
	{"NTOA", 4, 2832},
	{"MAGAZINES", 9, 2833},
	{"INSTITUTION", 11, 2834},
	{"RESPOND", 7, 2835},
	{"PACKAGES", 8, 2836},
	{"ZBE", 3, 2837},
	{"IONC", 4, 2838},
	{"FRANCISCO", 9, 2839},
	{"EEVE", 4, 2840},
	{"PRODUCTION", 10, 2841},
	{"LAWS", 4, 2842},
	{"CHANGED", 7, 2843},
	{"HEARD", 5, 2844},
	{"INDIVIDUALS", 11, 2845},
	{"EYAR", 4, 2846},
	{"COLORADO", 8, 2847},
	{"WEIGHT", 6, 2848},
	{"BIT", 3, 2849},
	{"LARGEST", 7, 2850},
	{"OESN", 4, 2851},
	{"EATI", 4, 2852},
	{"PJO", 3, 2853},
	{"TITLES", 6, 2854},
	{"DHER", 4, 2855},
	{"GUIDELINES", 10, 2856},
	{"UXE", 3, 2857},
	{"SCOU", 4, 2858},
	{"POLITICS", 8, 2859},
	{"GHTT", 4, 2860},
	{"DEV", 3, 2861},
	{"PERFORM", 7, 2862},
	{"ITTL", 4, 2863},
	{"SOMEBODY", 8, 2864},
	{"INTERVIEW", 9, 2865},
	{"APPLIED", 7, 2866},
	{"VOL", 3, 2867},
	{"DESCRIBED", 9, 2868},
	{"NSTE", 4, 2869},
	{"AFFECT", 6, 2870},
	{"PP", 2, 2871},
	{"FISH", 4, 2872},
	{"SMILE", 5, 2873},
	{"PARTICIPANT", 11, 2874},
	{"HECI", 4, 2875},
	{"VEGAS", 5, 2876},
	{"EOFA", 4, 2877},
	{"CHRIS", 5, 2878},
	{"FLY", 3, 2879},
	{"UCY", 3, 2880},
	{"PAIN", 4, 2881},
	{"RANGE", 5, 2882},
	{"EOTH", 4, 2883},
	{"DIRECTION", 9, 2884},
	{"DPRO", 4, 2885},
	{"OXH", 3, 2886},
	{"OREC", 4, 2887},
	{"WIDE", 4, 2888},
	{"CAMERA", 6, 2889},
	{"LEE", 3, 2890},
	{"ALLOWED", 7, 2891},
	{"EOUT", 4, 2892},
	{"CHARLES", 7, 2893},
	{"TZW", 3, 2894},
	{"UNIT", 4, 2895},
	{"SELLING", 7, 2896},
	{"XPER", 4, 2897},
	{"ECIT", 4, 2898},
	{"EDGE", 4, 2899},
	{"ORKI", 4, 2900},
	{"OLDER", 5, 2901},
	{"ILLINOIS", 8, 2902},
	{"STYLE", 5, 2903},
	{"REGULATIONS", 11, 2904},
	{"EVENING", 7, 2905},
	{"ELEMENTS", 8, 2906},
	{"INSIDE", 6, 2907},
	{"FINGER", 6, 2908},
	{"UTIN", 4, 2909},
	{"CELLS", 5, 2910},
	{"MODULE", 6, 2911},
	{"TICI", 4, 2912},
	{"NECESSARY", 9, 2913},
	{"EKK", 3, 2914},
	{"PRICING", 7, 2915},
	{"COACH", 5, 2916},
	{"ADULT", 5, 2917},
	{"DVDS", 4, 2918},
	{"REFLECT", 7, 2919},
	{"CERTIFICATE", 11, 2920},
	{"CONFERENCE", 10, 2921},
	{"ERTI", 4, 2922},
	{"COMMERCIAL", 10, 2923},
	{"LOOKS", 5, 2924},
	{"DIRECTIONS", 10, 2925},
	{"VISITORS", 8, 2926},
	{"MRS", 3, 2927},
	{"MANAGE", 6, 2928},
	{"OURN", 4, 2929},
	{"DISCOVER", 8, 2930},
	{"TZG", 3, 2931},
	{"TRIP", 4, 2932},
	{"ONWI", 4, 2933},
	{"NZY", 3, 2934},
	{"MIDDLE", 6, 2935},
	{"PATTERN", 7, 2936},
	{"CALLS", 5, 2937},
	{"CHALLENGE", 9, 2938},
	{"HEAT", 4, 2939},
	{"ITEM", 4, 2940},
	{"ITYA", 4, 2941},
	{"EIVE", 4, 2942},
	{"HERW", 4, 2943},
	{"NGAS", 4, 2944},
	{"TREAT", 5, 2945},
	{"GIVING", 6, 2946},
	{"IMPROVE", 7, 2947},
	{"ORRE", 4, 2948},
	{"MOUTH", 5, 2949},
	{"STUFF", 5, 2950},
	{"THROUGHOUT", 10, 2951},
	{"PPED", 4, 2952},
	{"TERW", 4, 2953},
	{"RTHI", 4, 2954},
	{"DEEP", 4, 2955},
	{"OREI", 4, 2956},
	{"PURPOSE", 7, 2957},
	{"ENDING", 6, 2958},
	{"ETIT", 4, 2959},
	{"BEAUTIFUL", 9, 2960},
	{"CLIENTS", 7, 2961},
	{"ACTIONS", 7, 2962},
	{"BAG", 3, 2963},
	{"YWIT", 4, 2964},
	{"SKIN", 4, 2965},
	{"AUTOMOTIVE", 10, 2966},
	{"NAKED", 5, 2967},
	{"ECZ", 3, 2968},
	{"BAR", 3, 2969},
	{"KKN", 3, 2970},
	{"MENTION", 7, 2971},
	{"WYA", 3, 2972},
	{"HEOR", 4, 2973},
	{"SOLD", 4, 2974},
	{"COMMUNITIES", 11, 2975},
	{"TTOT", 4, 2976},
	{"FEQ", 3, 2977},
	{"YWAS", 4, 2978},
	{"RYTH", 4, 2979},
	{"AHEAD", 5, 2980},
	{"WKW", 3, 2981},
	{"ETTI", 4, 2982},
	{"WRITER", 6, 2983},
	{"TROUBLE", 7, 2984},
	{"SCIENCES", 8, 2985},
	{"MARKETS", 7, 2986},
	{"LOWEST", 6, 2987},
	{"HOTEL", 5, 2988},
	{"SHIS", 4, 2989},
	{"DISCUSSION", 10, 2990},
	{"DREAM", 5, 2991},
	{"TOUGH", 5, 2992},
	{"PUBLISHING", 10, 2993},
	{"ORKE", 4, 2994},
	{"OMPE", 4, 2995},
	{"IONB", 4, 2996},
	{"SOLDIER", 7, 2997},
	{"LIVES", 5, 2998},
	{"RWAS", 4, 2999},
	{"XWO", 3, 3000},
	{"QUIR", 4, 3001},
	{"ITYT", 4, 3002},
	{"ESWE", 4, 3003},
	{"OWNER", 5, 3004},
	{"ERAG", 4, 3005},
	{"TFRO", 4, 3006},
	{"VOTE", 4, 3007},
	{"MILF", 4, 3008},
	{"CANCER", 6, 3009},
	{"LWAY", 4, 3010},
	{"ANNOUNCEMENTS", 13, 3011},
	{"SURFACE", 7, 3012},
	{"EXIST", 5, 3013},
	{"ETEA", 4, 3014},
	{"KITCHEN", 7, 3015},
	{"NCEI", 4, 3016},
	{"POSITIVE", 8, 3017},
	{"ORNI", 4, 3018},
	{"BOB", 3, 3019},
	{"SCORE", 5, 3020},
	{"COMMERCE", 8, 3021},
	{"RINGTONES", 9, 3022},
	{"STARE", 5, 3023},
	{"PAINTING", 8, 3024},
	{"WASR", 4, 3025},
	{"YARD", 4, 3026},
	{"PERSONS", 7, 3027},
	{"TASK", 4, 3028},
	{"KQU", 3, 3029},
	{"MAGAZINE", 8, 3030},
	{"BUDGET", 6, 3031},
	{"ONWA", 4, 3032},
	{"ERHE", 4, 3033},
	{"HEAVY", 5, 3034},
	{"TESTS", 5, 3035},
	{"ACCOUNTS", 8, 3036},
	{"UTHO", 4, 3037},
	{"RELATE", 6, 3038},
	{"TWIL", 4, 3039},
	{"XSO", 3, 3040},
	{"MET", 3, 3041},
	{"INSTEAD", 7, 3042},
	{"NVES", 4, 3043},
	{"XBOX", 4, 3044},
	{"ETTH", 4, 3045},
	{"FACTORS", 7, 3046},
	{"ONAT", 4, 3047},
	{"WWW", 3, 3048},
	{"NOTICE", 6, 3049},
	{"SETTINGS", 8, 3050},
	{"KCU", 3, 3051},
	{"FEAR", 4, 3052},
	{"EREF", 4, 3053},
	{"IVEA", 4, 3054},
	{"STEVE", 5, 3055},
	{"OXN", 3, 3056},
	{"SSHO", 4, 3057},
	{"INVESTMENT", 10, 3058},
	{"NDFO", 4, 3059},
	{"GARDEN", 6, 3060},
	{"TOTAL", 5, 3061},
	{"FORD", 4, 3062},
	{"DETAIL", 6, 3063},
	{"TOHI", 4, 3064},
	{"ILDR", 4, 3065},
	{"ORMO", 4, 3066},
	{"NSON", 4, 3067},
	{"TEDF", 4, 3068},
	{"WNJ", 3, 3069},
	{"INHE", 4, 3070},
	{"RCHI", 4, 3071},
	{"HOLIDAYS", 8, 3072},
	{"UNDT", 4, 3073},
	{"IKET", 4, 3074},
	{"SING", 4, 3075},
	{"ZEALAND", 7, 3076},
	{"IAJ", 3, 3077},
	{"MONITORING", 10, 3078},
	{"MARRIAGE", 8, 3079},
	{"REPLIES", 7, 3080},
	{"TONT", 4, 3081},
	{"VIOLENCE", 8, 3082},
	{"NDAT", 4, 3083},
	{"CETO", 4, 3084},
	{"LLAS", 4, 3085},
	{"COLLECTION", 10, 3086},
	{"LKF", 3, 3087},
	{"MACHINE", 7, 3088},
	{"INEA", 4, 3089},
	{"REALITY", 7, 3090},
	{"MODERN", 6, 3091},
	{"DTOA", 4, 3092},
	{"HADT", 4, 3093},
	{"GENERATION", 10, 3094},
	{"ESIT", 4, 3095},
	{"UNTY", 4, 3096},
	{"TEND", 4, 3097},
	{"FFEC", 4, 3098},
	{"SFIR", 4, 3099},
	{"INUE", 4, 3100},
	{"ORTI", 4, 3101},
	{"BEAT", 4, 3102},
	{"AGENT", 5, 3103},
	{"SCOTT", 5, 3104},
	{"ESUL", 4, 3105},
	{"GAS", 3, 3106},
	{"UTQ", 3, 3107},
	{"LLC", 3, 3108},
	{"TEDO", 4, 3109},
	{"NTSO", 4, 3110},
	{"REHE", 4, 3111},
	{"RKJ", 3, 3112},
	{"AGREEMENT", 9, 3113},
	{"SEC", 3, 3114},
	{"RRIE", 4, 3115},
	{"LLOF", 4, 3116},
	{"CONSUMER", 8, 3117},
	{"ONWH", 4, 3118},
	{"CANON", 5, 3119},
	{"RKV", 3, 3120},
	{"DSAN", 4, 3121},
	{"ZGE", 3, 3122},
	{"FTEN", 4, 3123},
	{"OPRO", 4, 3124},
	{"SSUC", 4, 3125},
	{"RWIT", 4, 3126},
	{"ATIT", 4, 3127},
	{"OAY", 3, 3128},
	{"FHY", 3, 3129},
	{"ATTORNEY", 8, 3130},
	{"WHOM", 4, 3131},
	{"NCOU", 4, 3132},
	{"TANC", 4, 3133},
	{"AGEO", 4, 3134},
	{"LZA", 3, 3135},
	{"NPRO", 4, 3136},
	{"KYF", 3, 3137},
	{"OPTIONAL", 8, 3138},
	{"DICTIONARY", 10, 3139},
	{"EONT", 4, 3140},
	{"ETHR", 4, 3141},
	{"CIVIL", 5, 3142},
	{"ESWH", 4, 3143},
	{"SECTIONS", 8, 3144},
	{"SCIENTIST", 9, 3145},
	{"ULDH", 4, 3146},
	{"FIELDS", 6, 3147},
	{"ERPR", 4, 3148},
	{"ESNO", 4, 3149},
	{"LETTERS", 7, 3150},
	{"NGAT", 4, 3151},
	{"DSOF", 4, 3152},
	{"PARTNER", 7, 3153},
	{"NEWSPAPER", 9, 3154},
	{"SHOT", 4, 3155},
	{"RICT", 4, 3156},
	{"INTERESTING", 11, 3157},
	{"AYBE", 4, 3158},
	{"LKY", 3, 3159},
	{"APPAREL", 7, 3160},
	{"CAPITAL", 7, 3161},
	{"WESTERN", 7, 3162},
	{"WMY", 3, 3163},
	{"FRONT", 5, 3164},
	{"YHAV", 4, 3165},
	{"TECHNIQUES", 10, 3166},
	{"IBM", 3, 3167},
	{"NOR", 3, 3168},
	{"DEBATE", 6, 3169},
	{"RD", 2, 3170},
	{"EFER", 4, 3171},
	{"EARO", 4, 3172},
	{"JOHNSON", 7, 3173},
	{"DINNER", 6, 3174},
	{"DOLLARS", 7, 3175},
	{"WEBSITES", 8, 3176},
	{"EARI", 4, 3177},
	{"RESPONSIBILITY", 14, 3178},
	{"HISB", 4, 3179},
	{"EONL", 4, 3180},
	{"THREAT", 6, 3181},
	{"IATI", 4, 3182},
	{"ONSU", 4, 3183},
	{"NOQ", 3, 3184},
	{"RELATION", 8, 3185},
	{"MEASURES", 8, 3186},
	{"KANSAS", 6, 3187},
	{"EFOU", 4, 3188},
	{"SZO", 3, 3189},
	{"UZE", 3, 3190},
	{"HEBU", 4, 3191},
	{"VICTIM", 6, 3192},
	{"RSHI", 4, 3193},
	{"SENATE", 6, 3194},
	{"BROUGHT", 7, 3195},
	{"NDPR", 4, 3196},
	{"DTHI", 4, 3197},
	{"ACCOUNT", 7, 3198},
	{"ZCA", 3, 3199},
	{"MAJORITY", 8, 3200},
	{"ABSOLUTELY", 10, 3201},
	{"NDLE", 4, 3202},
	{"SANTA", 5, 3203},
	{"ILDI", 4, 3204},
	{"EUSE", 4, 3205},
	{"MID", 3, 3206},
	{"ROBL", 4, 3207},
	{"SENIOR", 6, 3208},
	{"GHTO", 4, 3209},
	{"RSAR", 4, 3210},
	{"TSHE", 4, 3211},
	{"OCOM", 4, 3212},
	{"ISRAEL", 6, 3213},
	{"NGIT", 4, 3214},
	{"RSHA", 4, 3215},
	{"PROCESSES", 9, 3216},
	{"IVET", 4, 3217},
	{"WIND", 4, 3218},
	{"PREVENT", 7, 3219},
	{"OSTE", 4, 3220},
	{"CITIZEN", 7, 3221},
	{"HISO", 4, 3222},
	{"NDAY", 4, 3223},
	{"VYR", 3, 3224},
	{"GLOBAL", 6, 3225},
	{"SERVERS", 7, 3226},
	{"EWOU", 4, 3227},
	{"MEETINGS", 8, 3228},
	{"EDOU", 4, 3229},
	{"SECONDS", 7, 3230},
	{"JONES", 5, 3231},
	{"ARIZONA", 7, 3232},
	{"PROFESSIONAL", 12, 3233},
	{"KEYWORD", 7, 3234},
	{"TOHE", 4, 3235},
	{"INTERESTS", 9, 3236},
	{"AUDIENCE", 8, 3237},
	{"CHTH", 4, 3238},
	{"ATHI", 4, 3239},
	{"OOKI", 4, 3240},
	{"EGRO", 4, 3241},
	{"USERNAME", 8, 3242},
	{"SOVIET", 6, 3243},
	{"UMV", 3, 3244},
	{"EDAL", 4, 3245},
	{"REFORM", 6, 3246},
	{"PRODUCED", 8, 3247},
	{"HENH", 4, 3248},
	{"PAPERBACK", 9, 3249},
	{"CLASSIFIEDS", 11, 3250},
	{"XDO", 3, 3251},
	{"SUPPORTED", 9, 3252},
	{"DENC", 4, 3253},
	{"KEY", 3, 3254},
	{"LDHA", 4, 3255},
	{"SAINT", 5, 3256},
	{"TROOP", 5, 3257},
	{"CUSTOMER", 8, 3258},
	{"UNTE", 4, 3259},
	{"FRESH", 5, 3260},
	{"ASSUME", 6, 3261},
	{"CREATING", 8, 3262},
	{"CONCEPT", 7, 3263},
	{"RICH", 4, 3264},
	{"JIM", 3, 3265},
	{"DRUGS", 5, 3266},
	{"RESTAURANT", 10, 3267},
	{"SSIB", 4, 3268},
	{"PROVIDERS", 9, 3269},
	{"CHARACTERS", 10, 3270},
	{"UPGRADE", 7, 3271},
	{"HJI", 3, 3272},
	{"EFFECTIVE", 9, 3273},
	{"THEREFORE", 9, 3274},
	{"EXAMINE", 7, 3275},
	{"SPECIES", 7, 3276},
	{"TRAVEL", 6, 3277},
	{"THOUSANDS", 9, 3278},
	{"KM", 2, 3279},
	{"UTIT", 4, 3280},
	{"APARTMENTS", 10, 3281},
	{"IGNE", 4, 3282},
	{"AUCTIONS", 8, 3283},
	{"ETOW", 4, 3284},
	{"LYTO", 4, 3285},
	{"TWOU", 4, 3286},
	{"SYOU", 4, 3287},
	{"ENTRIES", 7, 3288},
	{"DATES", 5, 3289},
	{"GENERATED", 9, 3290},
	{"CCOR", 4, 3291},
	{"ENHE", 4, 3292},
	{"UETO", 4, 3293},
	{"EINA", 4, 3294},
	{"YCON", 4, 3295},
	{"SPEECH", 6, 3296},
	{"CORNER", 6, 3297},
	{"SIGNED", 6, 3298},
	{"YAJ", 3, 3299},
	{"NDWH", 4, 3300},
	{"FAST", 4, 3301},
	{"OVEM", 4, 3302},
	{"JUDGE", 5, 3303},
	{"SUCCESSFUL", 10, 3304},
	{"NDWI", 4, 3305},
	{"ONAS", 4, 3306},
	{"TERF", 4, 3307},
	{"ATTITUDE", 8, 3308},
	{"OPTION", 6, 3309},
	{"FOREST", 6, 3310},
	{"SAMSUNG", 7, 3311},
	{"TEDW", 4, 3312},
	{"BEGAN", 5, 3313},
	{"SSAI", 4, 3314},
	{"LOUIS", 5, 3315},
	{"ONDI", 4, 3316},
	{"STEPS", 5, 3317},
	{"ERRORS", 6, 3318},
	{"SHOPS", 5, 3319},
	{"NONE", 4, 3320},
	{"DEL", 3, 3321},
	{"EFFORTS", 7, 3322},
	{"BORN", 4, 3323},
	{"INFORMED", 8, 3324},
	{"SOUTHERN", 8, 3325},
	{"ACCESS", 6, 3326},
	{"RHIS", 4, 3327},
	{"THOUGHTS", 8, 3328},
	{"LLYA", 4, 3329},
	{"PYF", 3, 3330},
	{"IOX", 3, 3331},
	{"CREEK", 5, 3332},
	{"WORKED", 6, 3333},
	{"VIDEO", 5, 3334},
	{"MISSION", 7, 3335},
	{"ACHIEVE", 7, 3336},
	{"PRACTICES", 9, 3337},
	{"SORTED", 6, 3338},
	{"ADMIT", 5, 3339},
	{"SKY", 3, 3340},
	{"ORTU", 4, 3341},
	{"NGLI", 4, 3342},
	{"TOURS", 5, 3343},
	{"EAMS", 4, 3344},
	{"NTAT", 4, 3345},
	{"PUBLISH", 7, 3346},
	{"GHTI", 4, 3347},
	{"UYB", 3, 3348},
	{"OBJECT", 6, 3349},
	{"AFFILIATE", 9, 3350},
	{"ADMIN", 5, 3351},
	{"NGSA", 4, 3352},
	{"NURSING", 7, 3353},
	{"ALONE", 5, 3354},
	{"MACHINES", 8, 3355},
	{"DESIGNATED", 10, 3356},
	{"INCOME", 6, 3357},
	{"CONDUCT", 7, 3358},
	{"TAGS", 4, 3359},
	{"IGIN", 4, 3360},
	{"COVERED", 7, 3361},
	{"BIRD", 4, 3362},
	{"TBAL", 4, 3363},
	{"JOE", 3, 3364},
	{"MIY", 3, 3365},
	{"SLEEP", 5, 3366},
	{"BASIC", 5, 3367},
	{"GUYS", 4, 3368},
	{"CONFIGURATION", 13, 3369},
	{"COCK", 4, 3370},
	{"RESEARCHER", 10, 3371},
	{"TOUCH", 5, 3372},
	{"OYP", 3, 3373},
	{"ENOU", 4, 3374},
	{"CONFLICT", 8, 3375},
	{"NEIGHBORHOOD", 12, 3376},
	{"TERB", 4, 3377},
	{"AIZ", 3, 3378},
	{"SUFFER", 6, 3379},
	{"ACKT", 4, 3380},
	{"EATU", 4, 3381},
	{"CDS", 3, 3382},
	{"CREDIT", 6, 3383},
	{"LANGUAGES", 9, 3384},
	{"AFRICAN", 7, 3385},
	{"GHTA", 4, 3386},
	{"EVENTUALLY", 10, 3387},
	{"BECAME", 6, 3388},
	{"OPINION", 7, 3389},
	{"ONEA", 4, 3390},
	{"JEO", 3, 3391},
	{"VEHICLES", 8, 3392},
	{"VERSION", 7, 3393},
	{"HURT", 4, 3394},
	{"RECALL", 6, 3395},
	{"EUF", 3, 3396},
	{"LABOR", 5, 3397},
	{"VYD", 3, 3398},
	{"XRO", 3, 3399},
	{"SCALE", 5, 3400},
	{"ORIGINAL", 8, 3401},
	{"REFER", 5, 3402},
	{"AREP", 4, 3403},
	{"ESOM", 4, 3404},
	{"RELEASE", 7, 3405},
	{"EZZ", 3, 3406},
	{"EAGU", 4, 3407},
	{"NOBODY", 6, 3408},
	{"HISR", 4, 3409},
	{"NUCLEAR", 7, 3410},
	{"PENNSYLVANIA", 12, 3411},
	{"GHER", 4, 3412},
	{"EXAMPLES", 8, 3413},
	{"VARIETY", 7, 3414},
	{"OMMO", 4, 3415},
	{"EDOF", 4, 3416},
	{"UIRE", 4, 3417},
	{"YIV", 3, 3418},
	{"ZYA", 3, 3419},
	{"IPOD", 4, 3420},
	{"SAYING", 6, 3421},
	{"SAFETY", 6, 3422},
	{"FREEDOM", 7, 3423},
	{"CLAIMS", 6, 3424},
	{"INGG", 4, 3425},
	{"MOTOROLA", 8, 3426},
	{"VEDT", 4, 3427},
	{"UOD", 3, 3428},
	{"STRATEGIES", 10, 3429},
	{"DIRECTLY", 8, 3430},
	{"KKO", 3, 3431},
	{"EMOV", 4, 3432},
	{"TTIM", 4, 3433},
	{"ETHO", 4, 3434},
	{"ZRE", 3, 3435},
	{"AFFAIRS", 7, 3436},
	{"INTENDED", 8, 3437},
	{"OROF", 4, 3438},
	{"YOUC", 4, 3439},
	{"CLIENT", 6, 3440},
	{"EXG", 3, 3441},
	{"NDDE", 4, 3442},
	{"GOALS", 5, 3443},
	{"ANYT", 4, 3444},
	{"ICTI", 4, 3445},
	{"DEFINE", 6, 3446},
	{"CHARGES", 7, 3447},
	{"AFFILIATES", 10, 3448},
	{"REASONS", 7, 3449},
	{"EREH", 4, 3450},
	{"UYH", 3, 3451},
	{"PLANE", 5, 3452},
	{"INAR", 4, 3453},
	{"TALKING", 7, 3454},
	{"INVESTIGATION", 13, 3455},
	{"GAVE", 4, 3456},
	{"OBEA", 4, 3457},
	{"RINC", 4, 3458},
	{"ONES", 4, 3459},
	{"ZYM", 3, 3460},
	{"UXA", 3, 3461},
	{"TRACK", 5, 3462},
	{"HEEX", 4, 3463},
	{"MULTIMEDIA", 10, 3464},
	{"XP", 2, 3465},
	{"TITS", 4, 3466},
	{"NDSH", 4, 3467},
	{"CERTIFIED", 9, 3468},
	{"ECUT", 4, 3469},
	{"NDMO", 4, 3470},
	{"ERYO", 4, 3471},
	{"ENTC", 4, 3472},
	{"COMPUTING", 9, 3473},
	{"ERGE", 4, 3474},
	{"OREGON", 6, 3475},
	{"UZU", 3, 3476},
	{"FTHI", 4, 3477},
	{"EEXP", 4, 3478},
	{"EADO", 4, 3479},
	{"INTERACTIVE", 11, 3480},
	{"REQUESTS", 8, 3481},
	{"HEEA", 4, 3482},
	{"STATUS", 6, 3483},
	{"PERFECT", 7, 3484},
	{"INVOLVED", 8, 3485},
	{"PRESS", 5, 3486},
	{"SLOWLY", 6, 3487},
	{"VYM", 3, 3488},
	{"ARGUMENT", 8, 3489},
	{"UGW", 3, 3490},
	{"TABLES", 6, 3491},
	{"ATTEND", 6, 3492},
	{"RACING", 6, 3493},
	{"ENCOURAGE", 9, 3494},
	{"FEATURE", 7, 3495},
	{"OFRE", 4, 3496},
	{"FACTS", 5, 3497},
	{"HEBI", 4, 3498},
	{"ANNOUNCE", 8, 3499},
	{"KONG", 4, 3500},
	{"ATHO", 4, 3501},
	{"PLANTS", 6, 3502},
	{"WEEKEND", 7, 3503},
	{"STRIKE", 6, 3504},
	{"ITST", 4, 3505},
	{"STIO", 4, 3506},
	{"AFTERNOON", 9, 3507},
	{"DHIM", 4, 3508},
	{"TERH", 4, 3509},
	{"GENERALLY", 9, 3510},
	{"HECL", 4, 3511},
	{"AVENUE", 6, 3512},
	{"OTIN", 4, 3513},
	{"POWERFUL", 8, 3514},
	{"GHIS", 4, 3515},
	{"DIED", 4, 3516},
	{"HISL", 4, 3517},
	{"YLY", 3, 3518},
	{"WASB", 4, 3519},
	{"LYBE", 4, 3520},
	{"IMMEDIATELY", 11, 3521},
	{"ELEMENT", 7, 3522},
	{"CONVERSATION", 12, 3523},
	{"SITEMAP", 7, 3524},
	{"RECOMMENDATIONS", 15, 3525},
	{"ECHN", 4, 3526},
	{"MOVED", 5, 3527},
	{"HOUSTON", 7, 3528},
	{"PMEN", 4, 3529},
	{"IONP", 4, 3530},
	{"UNIVERSITY", 10, 3531},
	{"VIEWED", 6, 3532},
	{"THOF", 4, 3533},
	{"NDBE", 4, 3534},
	{"INCH", 4, 3535},
	{"OUX", 3, 3536},
	{"SPIRIT", 6, 3537},
	{"BRITISH", 7, 3538},
	{"INSURANCE", 9, 3539},
	{"RRES", 4, 3540},
	{"CRISIS", 6, 3541},
	{"CENTERS", 7, 3542},
	{"FAN", 3, 3543},
	{"INWH", 4, 3544},
	{"BRAIN", 5, 3545},
	{"OEQ", 3, 3546},
	{"COMPLETE", 8, 3547},
	{"RECIPES", 7, 3548},
	{"VYL", 3, 3549},
	{"SURVEY", 6, 3550},
	{"CVS", 3, 3551},
	{"GAMMA", 5, 3552},
	{"RIBU", 4, 3553},
	{"PLACED", 6, 3554},
	{"XPEC", 4, 3555},
	{"REPLACE", 7, 3556},
	{"FOLLOWS", 7, 3557},
	{"ORHI", 4, 3558},
	{"CAMP", 4, 3559},
	{"ZBO", 3, 3560},
	{"SUN", 3, 3561},
	{"DOLLAR", 6, 3562},
	{"ERAC", 4, 3563},
	{"ARAT", 4, 3564},
	{"ONTARIO", 7, 3565},
	{"SHIP", 4, 3566},
	{"DES", 3, 3567},
	{"NDWE", 4, 3568},
	{"MINNESOTA", 9, 3569},
	{"FILMS", 5, 3570},
	{"COMPLETELY", 10, 3571},
	{"STONE", 5, 3572},
	{"EWAR", 4, 3573},
	{"TZH", 3, 3574},
	{"RYOF", 4, 3575},
	{"OCKE", 4, 3576},
	{"NHER", 4, 3577},
	{"WILLIAMS", 8, 3578},
	{"IDNT", 4, 3579},
	{"ORST", 4, 3580},
	{"POSSIBILITY", 11, 3581},
	{"GTOT", 4, 3582},
	{"PRINTING", 8, 3583},
	{"SAMPLE", 6, 3584},
	{"DOZEN", 5, 3585},
	{"OWNED", 5, 3586},
	{"LYAN", 4, 3587},
	{"VISION", 6, 3588},
	{"OUSL", 4, 3589},
	{"PLAYED", 6, 3590},
	{"CONTACTS", 8, 3591},
	{"CHINESE", 7, 3592},
	{"CC", 2, 3593},
	{"PARK", 4, 3594},
	{"EEDT", 4, 3595},
	{"TEXT", 4, 3596},
	{"JESUS", 5, 3597},
	{"HOLE", 4, 3598},
	{"NZH", 3, 3599},
	{"YZI", 3, 3600},
	{"READERS", 7, 3601},
	{"HECR", 4, 3602},
	{"CLUBS", 5, 3603},
	{"LCD", 3, 3604},
	{"STICK", 5, 3605},
	{"DEPARTMENT", 10, 3606},
	{"JACKSON", 7, 3607},
	{"CTER", 4, 3608},
	{"ICTO", 4, 3609},
	{"MATCHING", 8, 3610},
	{"INGN", 4, 3611},
	{"LACK", 4, 3612},
	{"SHIRTS", 6, 3613},
	{"SALES", 5, 3614},
	{"LEADERS", 7, 3615},
	{"MMON", 4, 3616},
	{"HATP", 4, 3617},
	{"POSTERS", 7, 3618},
	{"INSTITUTIONS", 12, 3619},
	{"TRADITION", 9, 3620},
	{"AVE", 3, 3621},
	{"YRN", 3, 3622},
	{"DJ", 2, 3623},
	{"BOAT", 4, 3624},
	{"DRINK", 5, 3625},
	{"ITHM", 4, 3626},
	{"EDSO", 4, 3627},
	{"WASF", 4, 3628},
	{"SOLUTION", 8, 3629},
	{"HEADLINES", 9, 3630},
	{"COMPARED", 8, 3631},
	{"ACKE", 4, 3632},
	{"AROL", 4, 3633},
	{"ESHI", 4, 3634},
	{"DETERMINED", 10, 3635},
	{"WHOLESALE", 9, 3636},
	{"BATTLE", 6, 3637},
	{"CTTH", 4, 3638},
	{"UALI", 4, 3639},
	{"ATTEMPT", 7, 3640},
	{"RUSSIA", 6, 3641},
	{"VATI", 4, 3642},
	{"ITAN", 4, 3643},
	{"GONE", 4, 3644},
	{"CODES", 5, 3645},
	{"KINDS", 5, 3646},
	{"BEGINNING", 9, 3647},
	{"SEATTLE", 7, 3648},
	{"ARDT", 4, 3649},
	{"LCON", 4, 3650},
	{"RESIDENT", 8, 3651},
	{"STATEMENTS", 10, 3652},
	{"OXL", 3, 3653},
	{"TEAMS", 5, 3654},
	{"WOOD", 4, 3655},
	{"RPRO", 4, 3656},
	{"FORT", 4, 3657},
	{"EASILY", 6, 3658},
	{"INRE", 4, 3659},
	{"CM", 2, 3660},
	{"FORCES", 6, 3661},
	{"LLYT", 4, 3662},
	{"DYJ", 3, 3663},
	{"ICE", 3, 3664},
	{"TURNED", 6, 3665},
	{"EORG", 4, 3666},
	{"TRIED", 5, 3667},
	{"DRIVER", 6, 3668},
	{"SPOT", 4, 3669},
	{"APPLICABLE", 10, 3670},
	{"ROLL", 4, 3671},
	{"OLDI", 4, 3672},
	{"RETURNED", 8, 3673},
	{"VWH", 3, 3674},
	{"EDUP", 4, 3675},
	{"NEAN", 4, 3676},
	{"YJI", 3, 3677},
	{"NAMED", 5, 3678},
	{"THEATRE", 7, 3679},
	{"TRUCK", 5, 3680},
	{"EARLIER", 7, 3681},
	{"MANUFACTURERS", 13, 3682},
	{"NSIV", 4, 3683},
	{"ONMA", 4, 3684},
	{"DATE", 4, 3685},
	{"EUROPEAN", 8, 3686},
	{"READER", 6, 3687},
	{"ONFI", 4, 3688},
	{"LAYI", 4, 3689},
	{"DDIT", 4, 3690},
	{"DISTANCE", 8, 3691},
	{"GJI", 3, 3692},
	{"WARRANTY", 8, 3693},
	{"DEDICATED", 9, 3694},
	{"INDIANA", 7, 3695},
	{"EBAL", 4, 3696},
	{"EYHA", 4, 3697},
	{"INTRODUCE", 9, 3698},
	{"NTHO", 4, 3699},
	{"HEHI", 4, 3700},
	{"DISTRICT", 8, 3701},
	{"HARRY", 5, 3702},
	{"MOUNTAIN", 8, 3703},
	{"UNDERSTANDING", 13, 3704},
	{"ARTM", 4, 3705},
	{"OBJECTS", 7, 3706},
	{"OBVIOUSLY", 9, 3707},
	{"POTENTIAL", 9, 3708},
	{"ATTL", 4, 3709},
	{"NORMAL", 6, 3710},
	{"ENDS", 4, 3711},
	{"VEME", 4, 3712},
	{"OXP", 3, 3713},
	{"NGES", 4, 3714},
	{"DELETE", 6, 3715},
	{"WINTER", 6, 3716},
	{"LREA", 4, 3717},
	{"EHOU", 4, 3718},
	{"ERIA", 4, 3719},
	{"OYR", 3, 3720},
	{"IDENTITY", 8, 3721},
	{"HERH", 4, 3722},
	{"TAXES", 5, 3723},
	{"RDAY", 4, 3724},
	{"HYY", 3, 3725},
	{"ISSUED", 6, 3726},
	{"YWER", 4, 3727},
	{"VYB", 3, 3728},
	{"HIDE", 4, 3729},
	{"TSHO", 4, 3730},
	{"WISCONSIN", 9, 3731},
	{"NYQ", 3, 3732},
	{"INDEPENDENT", 11, 3733},
	{"ERCA", 4, 3734},
	{"LLAR", 4, 3735},
	{"APARTMENT", 9, 3736},
	{"SUPPOSED", 8, 3737},
	{"TERMS", 5, 3738},
	{"HORSE", 5, 3739},
	{"WHOH", 4, 3740},
	{"OBTAINED", 8, 3741},
	{"EXPRESS", 7, 3742},
	{"CKET", 4, 3743},
	{"CONTRACT", 8, 3744},
	{"TOIN", 4, 3745},
	{"ATWA", 4, 3746},
	{"FELT", 4, 3747},
	{"IFYO", 4, 3748},
	{"CLUB", 4, 3749},
	{"RIQ", 3, 3750},
	{"WAYT", 4, 3751},
	{"SCREEN", 6, 3752},
	{"PASSED", 6, 3753},
	{"DYOU", 4, 3754},
	{"SUPPLIED", 8, 3755},
	{"ROJE", 4, 3756},
	{"VILLAGE", 7, 3757},
	{"TZK", 3, 3758},
	{"OBSERVE", 7, 3759},
	{"GOLD", 4, 3760},
	{"IDENTIFIED", 10, 3761},
	{"CHRISTIAN", 9, 3762},
	{"FALLS", 5, 3763},
	{"EAPP", 4, 3764},
	{"PIC", 3, 3765},
	{"GAIN", 4, 3766},
	{"VIOU", 4, 3767},
	{"OSEE", 4, 3768},
	{"OPINIONS", 8, 3769},
	{"YCOM", 4, 3770},
	{"HANDLE", 6, 3771},
	{"PRESENCE", 8, 3772},
	{"STATED", 6, 3773},
	{"STATS", 5, 3774},
	{"HAWAII", 6, 3775},
	{"NSWE", 4, 3776},
	{"PROFESSIONALS", 13, 3777},
	{"ENEX", 4, 3778},
	{"APPEARS", 7, 3779},
	{"EGRA", 4, 3780},
	{"NEDI", 4, 3781},
	{"DECIDED", 7, 3782},
	{"CROWD", 5, 3783},
	{"DEMAND", 6, 3784},
	{"CTUA", 4, 3785},
	{"UJO", 3, 3786},
	{"COVERS", 6, 3787},
	{"EYY", 3, 3788},
	{"ONVE", 4, 3789},
	{"PREVIOUS", 8, 3790},
	{"DESIGNS", 7, 3791},
	{"RIDE", 4, 3792},
	{"CHOF", 4, 3793},
	{"ENTB", 4, 3794},
	{"ORYO", 4, 3795},
	{"REPORTER", 8, 3796},
	{"HTER", 4, 3797},
	{"ASSOCIATE", 9, 3798},
	{"NKIN", 4, 3799},
	{"NEWSLETTERS", 11, 3800},
	{"SHAPE", 5, 3801},
	{"ONOR", 4, 3802},
	{"HISH", 4, 3803},
	{"ADULTS", 6, 3804},
	{"CLIPS", 5, 3805},
	{"BASIS", 5, 3806},
	{"OFMA", 4, 3807},
	{"BUTW", 4, 3808},
	{"REWE", 4, 3809},
	{"SAVINGS", 7, 3810},
	{"ALOF", 4, 3811},
	{"IESI", 4, 3812},
	{"GRAPHIC", 7, 3813},
	{"ATOM", 4, 3814},
	{"SSOC", 4, 3815},
	{"LLST", 4, 3816},
	{"PAYMENTS", 8, 3817},
	{"PYL", 3, 3818},
	{"FARM", 4, 3819},
	{"TOOL", 4, 3820},
	{"RW", 2, 3821},
	{"OAQ", 3, 3822},
	{"PRISON", 6, 3823},
	{"ECHI", 4, 3824},
	{"HEYH", 4, 3825},
	{"NGAR", 4, 3826},
	{"ISFA", 4, 3827},
	{"CKTO", 4, 3828},
	{"LKU", 3, 3829},
	{"EBEC", 4, 3830},
	{"EPEO", 4, 3831},
	{"REFUSE", 6, 3832},
	{"EINF", 4, 3833},
	{"HEOT", 4, 3834},
	{"AKEA", 4, 3835},
	{"GUARD", 5, 3836},
	{"BINDING", 7, 3837},
	{"ENDED", 5, 3838},
	{"MPLO", 4, 3839},
	{"ISHO", 4, 3840},
	{"WINNING", 7, 3841},
	{"FACILITY", 8, 3842},
	{"SERVED", 6, 3843},
	{"TOMORROW", 8, 3844},
	{"WANTS", 5, 3845},
	{"CONTRIBUTE", 10, 3846},
	{"MISCELLANEOUS", 13, 3847},
	{"PREPARED", 8, 3848},
	{"VOID", 4, 3849},
	{"IFIE", 4, 3850},
	{"LEADERSHIP", 10, 3851},
	{"ALERT", 5, 3852},
	{"NOTB", 4, 3853},
	{"PRINCIPLE", 9, 3854},
	{"ATLANTA", 7, 3855},
	{"DAKOTA", 6, 3856},
	{"ESSU", 4, 3857},
	{"ERMO", 4, 3858},
	{"OWAS", 4, 3859},
	{"POUND", 5, 3860},
	{"INSTALLED", 9, 3861},
	{"VHS", 3, 3862},
	{"CREDITS", 7, 3863},
	{"ONON", 4, 3864},
	{"OUY", 3, 3865},
	{"IUL", 3, 3866},
	{"PUBMED", 6, 3867},
	{"TARGET", 6, 3868},
	{"DAVE", 4, 3869},
	{"NWHO", 4, 3870},
	{"ITUT", 4, 3871},
	{"MASSACHUSETTS", 13, 3872},
	{"DBEE", 4, 3873},
	{"NTSI", 4, 3874},
	{"TECHNIQUE", 9, 3875},
	{"DIEGO", 5, 3876},
	{"ADTO", 4, 3877},
	{"HONG", 4, 3878},
	{"THHI", 4, 3879},
	{"UBG", 3, 3880},
	{"VICE", 4, 3881},
	{"BRIGHT", 6, 3882},
	{"AMOU", 4, 3883},
	{"STRENGTH", 8, 3884},
	{"BAND", 4, 3885},
	{"AYST", 4, 3886},
	{"ERUN", 4, 3887},
	{"TINY", 4, 3888},
	{"YFRO", 4, 3889},
	{"UEY", 3, 3890},
	{"ESTU", 4, 3891},
	{"AVERAGE", 7, 3892},
	{"ENLARGE", 7, 3893},
	{"NGAL", 4, 3894},
	{"RAY", 3, 3895},
	{"CRY", 3, 3896},
	{"ADTH", 4, 3897},
	{"PROMOTE", 7, 3898},
	{"KGU", 3, 3899},
	{"VOTES", 5, 3900},
	{"OPLA", 4, 3901},
	{"WILLING", 7, 3902},
	{"ACKA", 4, 3903},
	{"DU", 2, 3904},
	{"AXH", 3, 3905},
	{"NDNO", 4, 3906},
	{"OVIN", 4, 3907},
	{"ATWE", 4, 3908},
	{"EAR", 3, 3909},
	{"FEJ", 3, 3910},
	{"LOOKED", 6, 3911},
	{"DISCUSSIONS", 11, 3912},
	{"ERSF", 4, 3913},
	{"EDED", 4, 3914},
	{"UYL", 3, 3915},
	{"EROU", 4, 3916},
	{"EARN", 4, 3917},
	{"ONSW", 4, 3918},
	{"HIGHLY", 6, 3919},
	{"ITYI", 4, 3920},
	{"FLIGHT", 6, 3921},
	{"FLIGHTS", 7, 3922},
	{"EXPERTS", 7, 3923},
	{"SSOM", 4, 3924},
	{"SIGNS", 5, 3925},
	{"REDB", 4, 3926},
	{"EMERGE", 6, 3927},
	{"IOWA", 4, 3928},
	{"LOGGED", 6, 3929},
	{"WILD", 4, 3930},
	{"HATD", 4, 3931},
	{"LAPTOP", 6, 3932},
	{"ASPECT", 6, 3933},
	{"VINTAGE", 7, 3934},
	{"EGUL", 4, 3935},
	{"VEHICLE", 7, 3936},
	{"ONFE", 4, 3937},
	{"EFAC", 4, 3938},
	{"LIFT", 4, 3939},
	{"OPERATE", 7, 3940},
	{"ADVANTAGE", 9, 3941},
	{"PROTECTION", 10, 3942},
	{"DBYA", 4, 3943},
	{"MARYLAND", 8, 3944},
	{"SPA", 3, 3945},
	{"GUEST", 5, 3946},
	{"DWHE", 4, 3947},
	{"CHECKOUT", 8, 3948},
	{"PYB", 3, 3949},
	{"TEOF", 4, 3950},
	{"FORGOT", 6, 3951},
	{"LSAN", 4, 3952},
	{"HANDLING", 8, 3953},
	{"PPEN", 4, 3954},
	{"KNEW", 4, 3955},
	{"VYF", 3, 3956},
	{"GAMING", 6, 3957},
	{"FEEDS", 5, 3958},
	{"TITLE", 5, 3959},
	{"RMOR", 4, 3960},
	{"SCOTLAND", 8, 3961},
	{"DEMONSTRATE", 11, 3962},
	{"DELIVER", 7, 3963},
	{"DALLAS", 6, 3964},
	{"RSQU", 4, 3965},
	{"INTERESTED", 10, 3966},
	{"STHR", 4, 3967},
	{"BOUGHT", 6, 3968},
	{"CONTEXT", 7, 3969},
	{"LPRO", 4, 3970},
	{"QUICK", 5, 3971},
	{"AKET", 4, 3972},
	{"TEAD", 4, 3973},
	{"CON", 3, 3974},
	{"UPS", 3, 3975},
	{"NATIONS", 7, 3976},
	{"FOLLOWED", 8, 3977},
	{"SPECIFICATIONS", 14, 3978},
	{"OREP", 4, 3979},
	{"PROCEDURE", 9, 3980},
	{"TRIPADVISOR", 11, 3981},
	{"FRANK", 5, 3982},
	{"RTME", 4, 3983},
	{"ALASKA", 6, 3984},
	{"ZOOM", 4, 3985},
	{"EETI", 4, 3986},
	{"ANIME", 5, 3987},
	{"DECISIONS", 9, 3988},
	{"INDUSTRIES", 10, 3989},
	{"ALFO", 4, 3990},
	{"NGAB", 4, 3991},
	{"COLLECT", 7, 3992},
	{"QUERY", 5, 3993},
	{"OCES", 4, 3994},
	{"ORX", 3, 3995},
	{"LIMIT", 5, 3996},
	{"STCO", 4, 3997},
	{"EDITORIAL", 9, 3998},
	{"ONAR", 4, 3999},
	{"LEARNING", 8, 4000},
	{"RIVER", 5, 4001},
	{"BELIEF", 6, 4002},
	{"IESW", 4, 4003},
	{"COUNT", 5, 4004},
	{"SETTLE", 6, 4005},
	{"BLOCK", 5, 4006},
	{"TCAN", 4, 4007},
	{"VOLV", 4, 4008},
	{"EETH", 4, 4009},
	{"PROVISIONS", 10, 4010},
	{"HURC", 4, 4011},
	{"COMPETITION", 11, 4012},
	{"ONGR", 4, 4013},
	{"TCHA", 4, 4014},
	{"PYH", 3, 4015},
	{"LIVING", 6, 4016},
	{"MMIT", 4, 4017},
	{"MARRY", 5, 4018},
	{"PRINCIPLES", 10, 4019},
	{"OTOF", 4, 4020},
	{"FAITH", 5, 4021},
	{"ANYBODY", 7, 4022},
	{"SUGGESTIONS", 11, 4023},
	{"FOLK", 4, 4024},
	{"EDAR", 4, 4025},
	{"SOUNDS", 6, 4026},
	{"SONW", 4, 4027},
	{"LAIM", 4, 4028},
	{"TCHI", 4, 4029},
	{"BORDER", 6, 4030},
	{"GNED", 4, 4031},
	{"LESSON", 6, 4032},
	{"IGNI", 4, 4033},
	{"TWHE", 4, 4034},
	{"WARM", 4, 4035},
	{"SHOP", 4, 4036},
	{"YKR", 3, 4037},
	{"TPLA", 4, 4038},
	{"SPAM", 4, 4039},
	{"ATEO", 4, 4040},
	{"CHAIRMAN", 8, 4041},
	{"BASEBALL", 8, 4042},
	{"ONGS", 4, 4043},
	{"IZAT", 4, 4044},
	{"UMEN", 4, 4045},
	{"BYTES", 5, 4046},
	{"ASTY", 4, 4047},
	{"CENT", 4, 4048},
	{"FORCED", 6, 4049},
	{"WNK", 3, 4050},
	{"JUMP", 4, 4051},
	{"COMPATIBLE", 10, 4052},
	{"FEED", 4, 4053},
	{"INKI", 4, 4054},
	{"ZATI", 4, 4055},
	{"ANNUAL", 6, 4056},
	{"RYEA", 4, 4057},
	{"NULL", 4, 4058},
	{"EANI", 4, 4059},
	{"ZERO", 4, 4060},
	{"FILED", 5, 4061},
	{"ARSO", 4, 4062},
	{"EEAR", 4, 4063},
	{"INFLUENCE", 9, 4064},
	{"NETHERLANDS", 11, 4065},
	{"CONSULTING", 10, 4066},
	{"RECREATION", 10, 4067},
	{"OFFICES", 7, 4068},
	{"PATH", 4, 4069},
	{"MURDER", 6, 4070},
	{"COFFEE", 6, 4071},
	{"PERSPECTIVE", 11, 4072},
	{"SQUO", 4, 4073},
	{"HEYC", 4, 4074},
	{"MANAGED", 7, 4075},
	{"PR", 2, 4076},
	{"EEDE", 4, 4077},
	{"FAILED", 6, 4078},
	{"GYG", 3, 4079},
	{"RTUN", 4, 4080},
	{"KOREA", 5, 4081},
	{"BANKS", 5, 4082},
	{"NGPR", 4, 4083},
	{"FR", 2, 4084},
	{"HARG", 4, 4085},
	{"PARTICIPANTS", 12, 4086},
	{"YSTA", 4, 4087},
	{"FINDING", 7, 4088},
	{"CRITIC", 6, 4089},
	{"FAILURE", 7, 4090},
	{"KELLY", 5, 4091},
	{"RELIGION", 8, 4092},
	{"LEADS", 5, 4093},
	{"ACADEMIC", 8, 4094},
	{"RKED", 4, 4095},
	{"ENGAGE", 6, 4096},
	{"UTTO", 4, 4097},
	{"AUSTIN", 6, 4098},
	{"DTHR", 4, 4099},
	{"ILLH", 4, 4100},
	{"FAVORITES", 9, 4101},
	{"MOSTLY", 6, 4102},
	{"TORONTO", 7, 4103},
	{"ANYWAY", 6, 4104},
	{"SPRINGS", 7, 4105},
	{"REVIEW", 6, 4106},
	{"MISSOURI", 8, 4107},
	{"ACKI", 4, 4108},
	{"YPRO", 4, 4109},
	{"ANDREW", 6, 4110},
	{"TZT", 3, 4111},
	{"NGFR", 4, 4112},
	{"VAR", 3, 4113},
	{"HEFR", 4, 4114},
	{"SYU", 3, 4115},
	{"USLY", 4, 4116},
	{"DSOM", 4, 4117},
	{"SSOF", 4, 4118},
	{"ESTIMATES", 9, 4119},
	{"FONT", 4, 4120},
	{"ASSETS", 6, 4121},
	{"NATIVE", 6, 4122},
	{"DGY", 3, 4123},
	{"JOSEPH", 6, 4124},
	{"FUNCTION", 8, 4125},
	{"RSTT", 4, 4126},
	{"DRIVERS", 7, 4127},
	{"EOFH", 4, 4128},
	{"SOFT", 4, 4129},
	{"FIGURES", 7, 4130},
	{"FEMALE", 6, 4131},
	{"MMEN", 4, 4132},
	{"PROTECTED", 9, 4133},
	{"EGG", 3, 4134},
	{"SHARING", 7, 4135},
	{"PHILADELPHIA", 12, 4136},
	{"UNLESS", 6, 4137},
	{"PORTAL", 6, 4138},
	{"WAITING", 7, 4139},
	{"BETA", 4, 4140},
	{"TCOU", 4, 4141},
	{"GRATIS", 6, 4142},
	{"FIT", 3, 4143},
	{"UDGE", 4, 4144},
	{"ULJ", 3, 4145},
	{"RGES", 4, 4146},
	{"HOWT", 4, 4147},
	{"OWAR", 4, 4148},
	{"OFFICIALS", 9, 4149},
	{"BRIAN", 5, 4150},
	{"EVIS", 4, 4151},
	{"YCY", 3, 4152},
	{"DPLA", 4, 4153},
	{"VOTER", 5, 4154},
	{"UILT", 4, 4155},
	{"EGIO", 4, 4156},
	{"YOUTH", 5, 4157},
	{"WON", 3, 4158},
	{"SPEED", 5, 4159},
	{"EDITOR", 6, 4160},
	{"AFRAID", 6, 4161},
	{"COOK", 4, 4162},
	{"ETOA", 4, 4163},
	{"EDRE", 4, 4164},
	{"COMMENT", 7, 4165},
	{"CONTAINED", 9, 4166},
	{"LINGERIE", 8, 4167},
	{"WORTH", 5, 4168},
	{"SURVIVE", 7, 4169},
	{"CALLING", 7, 4170},
	{"PARAMETERS", 10, 4171},
	{"BAGS", 4, 4172},
	{"PROFILES", 8, 4173},
	{"MIAMI", 5, 4174},
	{"GATHER", 6, 4175},
	{"HEY", 3, 4176},
	{"COMICS", 6, 4177},
	{"MATTERS", 7, 4178},
	{"HOUSES", 6, 4179},
	{"USSI", 4, 4180},
	{"OLJ", 3, 4181},
	{"DTOH", 4, 4182},
	{"POSTAL", 6, 4183},
	{"TSON", 4, 4184},
	{"OTBE", 4, 4185},
	{"RELATIONSHIPS", 13, 4186},
	{"TENNESSEE", 9, 4187},
	{"CONTROLS", 8, 4188},
	{"BREAKING", 8, 4189},
	{"SOFS", 4, 4190},
	{"OUBL", 4, 4191},
	{"FRENCH", 6, 4192},
	{"WALES", 5, 4193},
	{"NTHS", 4, 4194},
	{"OLUT", 4, 4195},
	{"NMAR", 4, 4196},
	{"RESPONSIBLE", 11, 4197},
	{"INTELLIGENCE", 12, 4198},
	{"INTRODUCED", 10, 4199},
	{"EREB", 4, 4200},
	{"DEPARTMENTS", 11, 4201},
	{"CLASSROOM", 9, 4202},
	{"DTOP", 4, 4203},
	{"CROSS", 5, 4204},
	{"DSTH", 4, 4205},
	{"NOTED", 5, 4206},
	{"DISPLAYED", 9, 4207},
	{"HOHA", 4, 4208},
	{"LLIA", 4, 4209},
	{"REDUCED", 7, 4210},
	{"SOVE", 4, 4211},
	{"SPENT", 5, 4212},
	{"PERFORMED", 9, 4213},
	{"RPRI", 4, 4214},
	{"DYV", 3, 4215},
	{"ATEI", 4, 4216},
	{"SAMPLES", 7, 4217},
	{"DAVIS", 5, 4218},
	{"DANIEL", 6, 4219},
	{"ZSC", 3, 4220},
	{"BARS", 4, 4221},
	{"NGED", 4, 4222},
	{"REVIEWED", 8, 4223},
	{"AFFAIR", 6, 4224},
	{"ESFR", 4, 4225},
	{"IGHE", 4, 4226},
	{"XAMP", 4, 4227},
	{"IEDT", 4, 4228},
	{"SYEA", 4, 4229},
	{"FORECAST", 8, 4230},
	{"ISFI", 4, 4231},
	{"NGLA", 4, 4232},
	{"REMOVED", 7, 4233},
	{"HELPS", 5, 4234},
	{"SINGLES", 7, 4235},
	{"EYWE", 4, 4236},
	{"AMOUNTS", 7, 4237},
	{"UBLE", 4, 4238},
	{"HEAS", 4, 4239},
	{"DUAL", 4, 4240},
	{"USD", 3, 4241},
	{"ESUP", 4, 4242},
	{"ALIZ", 4, 4243},
	{"NOD", 3, 4244},
	{"HELL", 4, 4245},
	{"ORWA", 4, 4246},
	{"IDIN", 4, 4247},
	{"EVW", 3, 4248},
	{"SONL", 4, 4249},
	{"NALT", 4, 4250},
	{"SPREAD", 6, 4251},
	{"HISTORICAL", 10, 4252},
	{"ETOF", 4, 4253},
	{"BLOW", 4, 4254},
	{"NOUG", 4, 4255},
	{"MG", 2, 4256},
	{"REGULAR", 7, 4257},
	{"XHE", 3, 4258},
	{"CATEGORY", 8, 4259},
	{"ONEI", 4, 4260},
	{"RPOR", 4, 4261},
	{"INSIST", 6, 4262},
	{"BROAD", 5, 4263},
	{"PHARMACY", 8, 4264},
	{"BRAZIL", 6, 4265},
	{"STATIC", 6, 4266},
	{"GRADE", 5, 4267},
	{"ADDRESSES", 9, 4268},
	{"ASHO", 4, 4269},
	{"QUARTER", 7, 4270},
	{"CONSTRUCTION", 12, 4271},
	{"INDIAN", 6, 4272},
	{"ITTH", 4, 4273},
	{"FANS", 4, 4274},
	{"OLZ", 3, 4275},
	{"OKLAHOMA", 8, 4276},
	{"SPEAKERS", 8, 4277},
	{"SUIT", 4, 4278},
	{"ACADEMY", 7, 4279},
	{"WEHA", 4, 4280},
	{"GIFT", 4, 4281},
	{"UATI", 4, 4282},
	{"XSU", 3, 4283},
	{"CLOTHES", 7, 4284},
	{"DELL", 4, 4285},
	{"IGNORE", 6, 4286},
	{"CLEANING", 8, 4287},
	{"INTERNET", 8, 4288},
	{"MORAL", 5, 4289},
	{"EDEV", 4, 4290},
	{"CONSTITUTES", 11, 4291},
	{"DTOC", 4, 4292},
	{"ZBU", 3, 4293},
	{"GRAB", 4, 4294},
	{"SHOE", 4, 4295},
	{"COMMIT", 6, 4296},
	{"COLLECTIBLES", 12, 4297},
	{"UYC", 3, 4298},
	{"ICHW", 4, 4299},
	{"TIFI", 4, 4300},
	{"IVAT", 4, 4301},
	{"EABO", 4, 4302},
	{"BACKGROUND", 10, 4303},
	{"LEAN", 4, 4304},
	{"ANIZ", 4, 4305},
	{"SLIGHTLY", 8, 4306},
	{"CONCERNS", 8, 4307},
	{"GGES", 4, 4308},
	{"COLOUR", 6, 4309},
	{"IONH", 4, 4310},
	{"PPIN", 4, 4311},
	{"GROWING", 7, 4312},
	{"ASTT", 4, 4313},
	{"NEGATIVE", 8, 4314},
	{"WAVE", 4, 4315},
	{"LEDI", 4, 4316},
	{"NGMA", 4, 4317},
	{"OPJ", 3, 4318},
	{"EOVE", 4, 4319},
	{"EMEM", 4, 4320},
	{"INTEL", 5, 4321},
	{"LVES", 4, 4322},
	{"PPLI", 4, 4323},
	{"ASFO", 4, 4324},
	{"UTILITIES", 9, 4325},
	{"OFFICERS", 8, 4326},
	{"NTCO", 4, 4327},
	{"LDTH", 4, 4328},
	{"TSWH", 4, 4329},
	{"REACTION", 8, 4330},
	{"BELOW", 5, 4331},
	{"BIDS", 4, 4332},
	{"OURI", 4, 4333},
	{"DSHE", 4, 4334},
	{"REFERRED", 8, 4335},
	{"SUPPORTS", 8, 4336},
	{"ESBE", 4, 4337},
	{"ONHI", 4, 4338},
	{"QUIET", 5, 4339},
	{"NUTRITION", 9, 4340},
	{"NTAR", 4, 4341},
	{"NTFO", 4, 4342},
	{"NWHE", 4, 4343},
	{"REGIONS", 7, 4344},
	{"COMMITTEE", 9, 4345},
	{"LES", 3, 4346},
	{"WINE", 4, 4347},
	{"CAPE", 4, 4348},
	{"INUT", 4, 4349},
	{"DENY", 4, 4350},
	{"TSHA", 4, 4351},
	{"TOFO", 4, 4352},
	{"DRESS", 5, 4353},
	{"RINGS", 5, 4354},
	{"BURN", 4, 4355},
	{"FOLLOWING", 9, 4356},
	{"IGHS", 4, 4357},
	{"LADIES", 6, 4358},
	{"NVOL", 4, 4359},
	{"ONHA", 4, 4360},
	{"HENRY", 5, 4361},
	{"EELE", 4, 4362},
	{"FKU", 3, 4363},
	{"HEAC", 4, 4364},
	{"EBRA", 4, 4365},
	{"ANNOUNCED", 9, 4366},
	{"THREATEN", 8, 4367},
	{"COMBINE", 7, 4368},
	{"AGREED", 6, 4369},
	{"CONNECTION", 10, 4370},
	{"STTO", 4, 4371},
	{"ZYS", 3, 4372},
	{"ERVA", 4, 4373},
	{"EPOL", 4, 4374},
	{"APPARENTLY", 10, 4375},
	{"ONGA", 4, 4376},
	{"ACTIVE", 6, 4377},
	{"AYOF", 4, 4378},
	{"PARTICIPATE", 11, 4379},
	{"EWYO", 4, 4380},
	{"UXT", 3, 4381},
	{"LTUR", 4, 4382},
	{"PLEW", 4, 4383},
	{"ILLT", 4, 4384},
	{"RELATIVELY", 10, 4385},
	{"LLYI", 4, 4386},
	{"POSTING", 7, 4387},
	{"ETOR", 4, 4388},
	{"RSWH", 4, 4389},
	{"CHIEF", 5, 4390},
	{"TRYI", 4, 4391},
	{"TWICE", 5, 4392},
	{"LEFO", 4, 4393},
	{"NSHE", 4, 4394},
	{"MENTIONED", 9, 4395},
	{"TYIN", 4, 4396},
	{"UNITED", 6, 4397},
	{"HEALTHCARE", 10, 4398},
	{"IVID", 4, 4399},
	{"VIEWING", 7, 4400},
	{"MAINTAINED", 10, 4401},
	{"HOFT", 4, 4402},
	{"SSUR", 4, 4403},
	{"ASSESSMENT", 10, 4404},
	{"NGIS", 4, 4405},
	{"CONNECTED", 9, 4406},
	{"ATSH", 4, 4407},
	{"BONE", 4, 4408},
	{"COOL", 4, 4409},
	{"CHRIST", 6, 4410},
	{"DAN", 3, 4411},
	{"DOGS", 4, 4412},
	{"YHY", 3, 4413},
	{"MPER", 4, 4414},
	{"DIRECTORS", 9, 4415},
	{"LITERATURE", 10, 4416},
	{"ASPECTS", 7, 4417},
	{"AUSTRIA", 7, 4418},
	{"APPROPRIATE", 11, 4419},
	{"UNCE", 4, 4420},
	{"YESTERDAY", 9, 4421},
	{"YDB", 3, 4422},
	{"RVED", 4, 4423},
	{"ERSU", 4, 4424},
	{"DESTROY", 7, 4425},
	{"PREVIEW", 7, 4426},
	{"NGOU", 4, 4427},
	{"SYH", 3, 4428},
	{"STSE", 4, 4429},
	{"MATRIX", 6, 4430},
	{"LZE", 3, 4431},
	{"NDCH", 4, 4432},
	{"CONTAINING", 10, 4433},
	{"NSFO", 4, 4434},
	{"ACKO", 4, 4435},
	{"MISTAKE", 7, 4436},
	{"OTTH", 4, 4437},
	{"PRIMARY", 7, 4438},
	{"DEVEL", 5, 4439},
	{"DEMOCRACY", 9, 4440},
	{"UREO", 4, 4441},
	{"ONRE", 4, 4442},
	{"GUARANTEED", 10, 4443},
	{"HEALTHY", 7, 4444},
	{"DIRECT", 6, 4445},
	{"LIBRARIES", 9, 4446},
	{"DISTRIBUTED", 11, 4447},
	{"DEGREES", 7, 4448},
	{"SINGAPORE", 9, 4449},
	{"ECTR", 4, 4450},
	{"ENTERPRISES", 11, 4451},
	{"EXTEND", 6, 4452},
	{"OSIN", 4, 4453},
	{"DELTA", 5, 4454},
	{"EHIG", 4, 4455},
	{"EXERCISE", 8, 4456},
	{"NPLA", 4, 4457},
	{"SEEKING", 7, 4458},
	{"INCHES", 6, 4459},
	{"PHOENIX", 7, 4460},
	{"KNEE", 4, 4461},
	{"OUCA", 4, 4462},
	{"SHARES", 6, 4463},
	{"STSA", 4, 4464},
	{"WYOR", 4, 4465},
	{"NTSW", 4, 4466},
	{"BUS", 3, 4467},
	{"ALPR", 4, 4468},
	{"COLORS", 6, 4469},
	{"FYH", 3, 4470},
	{"WARS", 4, 4471},
	{"CISCO", 5, 4472},
	{"LLHA", 4, 4473},
	{"YAQ", 3, 4474},
	{"TOUR", 4, 4475},
	{"LTIM", 4, 4476},
	{"ORDERING", 8, 4477},
	{"KEPT", 4, 4478},
	{"OBAM", 4, 4479},
	{"ALPHA", 5, 4480},
	{"NGSI", 4, 4481},
	{"APPLICATION", 11, 4482},
	{"TAPE", 4, 4483},
	{"PROMISE", 7, 4484},
	{"NECK", 4, 4485},
	{"ZRA", 3, 4486},
	{"EZF", 3, 4487},
	{"ONFR", 4, 4488},
	{"EBES", 4, 4489},
	{"EITS", 4, 4490},
	{"OYOU", 4, 4491},
	{"YKU", 3, 4492},
	{"FLOWER", 6, 4493},
	{"OWQ", 3, 4494},
	{"CERTIFICATION", 13, 4495},
	{"ESUR", 4, 4496},
	{"NVER", 4, 4497},
	{"HEPU", 4, 4498},
	{"HETW", 4, 4499},
	{"BOOKMARK", 8, 4500},
	{"ETOO", 4, 4501},
	{"ROPO", 4, 4502},
	{"AREI", 4, 4503},
	{"LLEC", 4, 4504},
	{"ELIV", 4, 4505},
	{"RTHO", 4, 4506},
	{"BUILDINGS", 9, 4507},
	{"LTHA", 4, 4508},
	{"SPECIALS", 8, 4509},
	{"ESSF", 4, 4510},
	{"OLON", 4, 4511},
	{"YWHE", 4, 4512},
	{"REMIND", 6, 4513},
	{"ATWO", 4, 4514},
	{"MEDICINE", 8, 4515},
	{"AWARE", 5, 4516},
	{"NEIGHBOR", 8, 4517},
	{"OXV", 3, 4518},
	{"PHOTO", 5, 4519},
	{"DISNEY", 6, 4520},
	{"RDAN", 4, 4521},
	{"TSCO", 4, 4522},
	{"DVAN", 4, 4523},
	{"AREM", 4, 4524},
	{"BATTERIES", 9, 4525},
	{"ADOBE", 5, 4526},
	{"USEI", 4, 4527},
	{"SMOKING", 7, 4528},
	{"TBUT", 4, 4529},
	{"ERYT", 4, 4530},
	{"IRAQI", 5, 4531},
	{"LADY", 4, 4532},
	{"IGNA", 4, 4533},
	{"BBC", 3, 4534},
	{"DEPEND", 6, 4535},
	{"TSFO", 4, 4536},
	{"BECOMES", 7, 4537},
	{"OFHE", 4, 4538},
	{"HEYR", 4, 4539},
	{"DRIVES", 6, 4540},
	{"RPLA", 4, 4541},
	{"JUSTICE", 7, 4542},
	{"ARMS", 4, 4543},
	{"ALABAMA", 7, 4544},
	{"HHIS", 4, 4545},
	{"UYM", 3, 4546},
	{"YNB", 3, 4547},
	{"TREES", 5, 4548},
	{"AVG", 3, 4549},
	{"TALL", 4, 4550},
	{"NSUR", 4, 4551},
	{"PAIR", 4, 4552},
	{"EDUCATIONAL", 11, 4553},
	{"POSITIONS", 9, 4554},
	{"FOOTBALL", 8, 4555},
	{"SUBSCRIPTION", 12, 4556},
	{"OFST", 4, 4557},
	{"LIP", 3, 4558},
	{"PGU", 3, 4559},
	{"UTAH", 4, 4560},
	{"HWAS", 4, 4561},
	{"GZH", 3, 4562},
	{"EUW", 3, 4563},
	{"ONSC", 4, 4564},
	{"RUW", 3, 4565},
	{"EPTI", 4, 4566},
	{"ROM", 3, 4567},
	{"INSTRUCTION", 11, 4568},
	{"ORPO", 4, 4569},
	{"EFUL", 4, 4570},
	{"CARRIED", 7, 4571},
	{"DAILY", 5, 4572},
	{"TICU", 4, 4573},
	{"DANGEROUS", 9, 4574},
	{"EDAB", 4, 4575},
	{"ERCH", 4, 4576},
	{"PANASONIC", 9, 4577},
	{"IALI", 4, 4578},
	{"WASE", 4, 4579},
	{"PERMALINK", 9, 4580},
	{"EASTERN", 7, 4581},
	{"GAMBLING", 8, 4582},
	{"EFRE", 4, 4583},
	{"HIRE", 4, 4584},
	{"FAIR", 4, 4585},
	{"MILLER", 6, 4586},
	{"RYTO", 4, 4587},
	{"OFWH", 4, 4588},
	{"OUTDOORS", 8, 4589},
	{"AYSA", 4, 4590},
	{"CAUSED", 6, 4591},
	{"DMOR", 4, 4592},
	{"WRITING", 7, 4593},
	{"LUXURY", 6, 4594},
	{"BABES", 5, 4595},
	{"FRAMES", 6, 4596},
	{"VIAGRA", 6, 4597},
	{"YOUA", 4, 4598},
	{"UPQ", 3, 4599},
	{"USTH", 4, 4600},
	{"IMPORTANCE", 10, 4601},
	{"ONGW", 4, 4602},
	{"SUPPLY", 6, 4603},
	{"DEVICE", 6, 4604},
	{"PLIC", 4, 4605},
	{"RGER", 4, 4606},
	{"TZP", 3, 4607},
	{"MALE", 4, 4608},
	{"ETOU", 4, 4609},
	{"PRINTED", 7, 4610},
	{"SEDB", 4, 4611},
	{"HIMT", 4, 4612},
	{"ECID", 4, 4613},
	{"ACTOR", 5, 4614},
	{"EASU", 4, 4615},
	{"ULTU", 4, 4616},
	{"EASIER", 6, 4617},
	{"FULLY", 5, 4618},
	{"SRC", 3, 4619},
	{"OFAR", 4, 4620},
	{"EXCHANGE", 8, 4621},
	{"TRADEMARK", 9, 4622},
	{"PRINTERS", 8, 4623},
	{"FAQS", 4, 4624},
	{"SWOU", 4, 4625},
	{"ADDING", 6, 4626},
	{"KENTUCKY", 8, 4627},
	{"SHUT", 4, 4628},
	{"STUDIO", 6, 4629},
	{"ERIC", 4, 4630},
	{"EXPRESSION", 10, 4631},
	{"CIRCLE", 6, 4632},
	{"TAYLOR", 6, 4633},
	{"TRACKBACK", 9, 4634},
	{"NDSI", 4, 4635},
	{"PRINTS", 6, 4636},
	{"SALT", 4, 4637},
	{"ADOF", 4, 4638},
	{"REVISED", 7, 4639},
	{"NTOR", 4, 4640},
	{"EDBE", 4, 4641},
	{"BREATH", 6, 4642},
	{"AMERICANS", 9, 4643},
	{"OPTICAL", 7, 4644},
	{"TSOM", 4, 4645},
	{"BOTTOM", 6, 4646},
	{"OWOR", 4, 4647},
	{"PROGRESS", 8, 4648},
	{"FAMOUS", 6, 4649},
	{"RSIO", 4, 4650},
	{"ZFO", 3, 4651},
	{"NYTH", 4, 4652},
	{"TWHI", 4, 4653},
	{"OPME", 4, 4654},
	{"PLATE", 5, 4655},
	{"SUITES", 6, 4656},
	{"NGHA", 4, 4657},
	{"PLASTIC", 7, 4658},
	{"TOAC", 4, 4659},
	{"OBTAIN", 6, 4660},
	{"ABUSE", 5, 4661},
	{"VICTORIA", 8, 4662},
	{"ONME", 4, 4663},
	{"FAMILIAR", 8, 4664},
	{"BIRTH", 5, 4665},
	{"HECE", 4, 4666},
	{"OFES", 4, 4667},
	{"SERIAL", 6, 4668},
	{"REVISION", 8, 4669},
	{"BROADBAND", 9, 4670},
	{"PDA", 3, 4671},
	{"CHICKEN", 7, 4672},
	{"SJUS", 4, 4673},
	{"THEATER", 7, 4674},
	{"DDLE", 4, 4675},
	{"DSL", 3, 4676},
	{"ILET", 4, 4677},
	{"HATR", 4, 4678},
	{"WEBMASTER", 9, 4679},
	{"UTHI", 4, 4680},
	{"COPIES", 6, 4681},
	{"TEACHING", 8, 4682},
	{"TUNI", 4, 4683},
	{"ZUM", 3, 4684},
	{"NCHI", 4, 4685},
	{"ZWE", 3, 4686},
	{"COLLEAGUE", 9, 4687},
	{"CLIMB", 5, 4688},
	{"SEEING", 6, 4689},
	{"ITHC", 4, 4690},
	{"CLEAN", 5, 4691},
	{"DOMESTIC", 8, 4692},
	{"DIFF", 4, 4693},
	{"ISLAND", 6, 4694},
	{"SUGAR", 5, 4695},
	{"LOPM", 4, 4696},
	{"BASS", 4, 4697},
	{"RWAR", 4, 4698},
	{"OKAY", 4, 4699},
	{"LIY", 3, 4700},
	{"STBE", 4, 4701},
	{"DKY", 3, 4702},
	{"ASDE", 4, 4703},
	{"ZPA", 3, 4704},
	{"OWIT", 4, 4705},
	{"PETS", 4, 4706},
	{"LICENSED", 8, 4707},
	{"ALIVE", 5, 4708},
	{"VWI", 3, 4709},
	{"ICHH", 4, 4710},
	{"TPER", 4, 4711},
	{"ORLANDO", 7, 4712},
	{"BEHI", 4, 4713},
	{"IDON", 4, 4714},
	{"RAIN", 4, 4715},
	{"ERPA", 4, 4716},
	{"ESRE", 4, 4717},
	{"LLCO", 4, 4718},
	{"DTOD", 4, 4719},
	{"MAINE", 5, 4720},
	{"SQL", 3, 4721},
	{"SPECS", 5, 4722},
	{"JURY", 4, 4723},
	{"RECORDED", 8, 4724},
	{"MEANING", 7, 4725},
	{"PRESIDENTIAL", 12, 4726},
	{"PIECES", 6, 4727},
	{"FINISHED", 8, 4728},
	{"LEAF", 4, 4729},
	{"PAINT", 5, 4730},
	{"TTRA", 4, 4731},
	{"PARKS", 5, 4732},
	{"LAWYERS", 7, 4733},
	{"SESSION", 7, 4734},
	{"POLL", 4, 4735},
	{"EXTRA", 5, 4736},
	{"SYDNEY", 6, 4737},
	{"DESIRE", 6, 4738},
	{"TRAIN", 5, 4739},
	{"UNCI", 4, 4740},
	{"NBUT", 4, 4741},
	{"DBEC", 4, 4742},
	{"SOFTWARE", 8, 4743},
	{"NGSE", 4, 4744},
	{"RUNS", 4, 4745},
	{"TRENDS", 6, 4746},
	{"YOUW", 4, 4747},
	{"INJURY", 6, 4748},
	{"UARE", 4, 4749},
	{"ONBE", 4, 4750},
	{"FUEL", 4, 4751},
	{"EEME", 4, 4752},
	{"ARMY", 4, 4753},
	{"NGUP", 4, 4754},
	{"TTEM", 4, 4755},
	{"READING", 7, 4756},
	{"NTAG", 4, 4757},
	{"TERD", 4, 4758},
	{"UZH", 3, 4759},
	{"SUPREME", 7, 4760},
	{"TICKET", 6, 4761},
	{"URBAN", 5, 4762},
	{"YNM", 3, 4763},
	{"PATTERNS", 8, 4764},
	{"NDID", 4, 4765},
	{"ATHLETE", 7, 4766},
	{"TTOB", 4, 4767},
	{"OOKA", 4, 4768},
	{"IETY", 4, 4769},
	{"BOXES", 5, 4770},
	{"ORMI", 4, 4771},
	{"LOUISIANA", 9, 4772},
	{"HEDU", 4, 4773},
	{"SWEET", 5, 4774},
	{"SREP", 4, 4775},
	{"HILLS", 5, 4776},
	{"ENRE", 4, 4777},
	{"JAVASCRIPT", 10, 4778},
	{"INSTRUMENT", 10, 4779},
	{"DRY", 3, 4780},
	{"OTHERWISE", 9, 4781},
	{"ADVISOR", 7, 4782},
	{"NORTHERN", 8, 4783},
	{"NDDI", 4, 4784},
	{"LESO", 4, 4785},
	{"UTHA", 4, 4786},
	{"HEDT", 4, 4787},
	{"WILSON", 6, 4788},
	{"COMPLEX", 7, 4789},
	{"LOTS", 4, 4790},
	{"STRANGE", 7, 4791},
	{"EXPLORE", 7, 4792},
	{"RUSSIAN", 7, 4793},
	{"KIY", 3, 4794},
	{"EIMP", 4, 4795},
	{"OPPE", 4, 4796},
	{"EFEA", 4, 4797},
	{"OMMA", 4, 4798},
	{"ANSF", 4, 4799},
	{"CERTIFICATES", 12, 4800},
	{"OBJECTIVES", 10, 4801},
	{"NTWA", 4, 4802},
	{"SCIENTIFIC", 10, 4803},
	{"STATIONS", 8, 4804},
	{"EOPE", 4, 4805},
	{"EMOC", 4, 4806},
	{"MAP", 3, 4807},
	{"ERIG", 4, 4808},
	{"SUGGESTED", 9, 4809},
	{"GPS", 3, 4810},
	{"OKV", 3, 4811},
	{"MENTAL", 6, 4812},
	{"REMAINS", 7, 4813},
	{"UENC", 4, 4814},
	{"ACC", 3, 4815},
	{"TBEC", 4, 4816},
	{"CORPORATE", 9, 4817},
	{"TZC", 3, 4818},
	{"OTED", 4, 4819},
	{"ENGINE", 6, 4820},
	{"TZM", 3, 4821},
	{"BJEC", 4, 4822},
	{"FIRMS", 5, 4823},
	{"POCKET", 6, 4824},
	{"IGAT", 4, 4825},
	{"IVEI", 4, 4826},
	{"PLANET", 6, 4827},
	{"EURO", 4, 4828},
	{"ISWA", 4, 4829},
	{"ONCA", 4, 4830},
	{"STRUCTURES", 10, 4831},
	{"INTEND", 6, 4832},
	{"GENERIC", 7, 4833},
	{"ENCYCLOPEDIA", 12, 4834},
	{"HISY", 4, 4835},
	{"IKW", 3, 4836},
	{"USAGE", 5, 4837},
	{"INCREASINGLY", 12, 4838},
	{"SOMEWHERE", 9, 4839},
	{"CHARTS", 6, 4840},
	{"ITYS", 4, 4841},
	{"NDFI", 4, 4842},
	{"CENSUS", 6, 4843},
	{"EVIC", 4, 4844},
	{"NTBE", 4, 4845},
	{"INTERRACIAL", 11, 4846},
	{"EGOT", 4, 4847},
	{"ATEG", 4, 4848},
	{"DESK", 4, 4849},
	{"DEOF", 4, 4850},
	{"MOM", 3, 4851},
	{"ITHP", 4, 4852},
	{"TEDH", 4, 4853},
	{"YNW", 3, 4854},
	{"DICK", 4, 4855},
	{"SUPPLIERS", 9, 4856},
	{"NNEC", 4, 4857},
	{"COMPACT", 7, 4858},
	{"EXPAND", 6, 4859},
	{"LIGHTS", 6, 4860},
	{"RCHE", 4, 4861},
	{"TRACKING", 8, 4862},
	{"DISAPPEAR", 9, 4863},
	{"OYG", 3, 4864},
	{"KEEPING", 7, 4865},
	{"PTED", 4, 4866},
	{"GFRO", 4, 4867},
	{"EMPTY", 5, 4868},
	{"DINC", 4, 4869},
	{"ISCU", 4, 4870},
	{"POOL", 4, 4871},
	{"ERAR", 4, 4872},
	{"SEQU", 4, 4873},
	{"METAL", 5, 4874},
	{"CONSEQUENCE", 11, 4875},
	{"MATCHES", 7, 4876},
	{"ACCORDANCE", 10, 4877},
	{"IOND", 4, 4878},
	{"UPTH", 4, 4879},
	{"EPTE", 4, 4880},
	{"WIDTH", 5, 4881},
	{"ENGINES", 7, 4882},
	{"TTOM", 4, 4883},
	{"RESPECT", 7, 4884},
	{"AIDH", 4, 4885},
	{"BASICALLY", 9, 4886},
	{"DISCUSSED", 9, 4887},
	{"STEPHEN", 7, 4888},
	{"DANGER", 6, 4889},
	{"ELIZABETH", 9, 4890},
	{"IANC", 4, 4891},
	{"NCEW", 4, 4892},
	{"FOURTH", 6, 4893},
	{"LUNCH", 5, 4894},
	{"RESERVATIONS", 12, 4895},
	{"BYQ", 3, 4896},
	{"YZO", 3, 4897},
	{"PLAYSTATION", 11, 4898},
	{"REGIONAL", 8, 4899},
	{"ANNOTATION", 10, 4900},
	{"MINORITY", 8, 4901},
	{"FAVORITE", 8, 4902},
	{"COMMITMENT", 10, 4903},
	{"TSWI", 4, 4904},
	{"MOCR", 4, 4905},
	{"DIFFERENCES", 11, 4906},
	{"PITE", 4, 4907},
	{"TEMPERATURE", 11, 4908},
	{"SMALLER", 7, 4909},
	{"HEDR", 4, 4910},
	{"NEWEST", 6, 4911},
	{"NGMO", 4, 4912},
	{"VYP", 3, 4913},
	{"EDWH", 4, 4914},
	{"GNU", 3, 4915},
	{"HAPPENED", 8, 4916},
	{"RSWI", 4, 4917},
	{"EXPRESSED", 9, 4918},
	{"OVET", 4, 4919},
	{"NGWH", 4, 4920},
	{"EDNE", 4, 4921},
	{"ERCI", 4, 4922},
	{"JEFF", 4, 4923},
	{"SSER", 4, 4924},
	{"UMME", 4, 4925},
	{"ITUA", 4, 4926},
	{"CONCLUSION", 10, 4927},
	{"TRAIL", 5, 4928},
	{"UENT", 4, 4929},
	{"NGCA", 4, 4930},
	{"FARMER", 6, 4931},
	{"CISI", 4, 4932},
	{"PARAGRAPH", 9, 4933},
	{"ONPR", 4, 4934},
	{"VYH", 3, 4935},
	{"EZP", 3, 4936},
	{"ANWH", 4, 4937},
	{"PREDICT", 7, 4938},
	{"STRAIGHT", 8, 4939},
	{"HSCH", 4, 4940},
	{"DBUT", 4, 4941},
	{"SREL", 4, 4942},
	{"MANAGERS", 8, 4943},
	{"MODULES", 7, 4944},
	{"ADOPT", 5, 4945},
	{"SIGHT", 5, 4946},
	{"ERHI", 4, 4947},
	{"VARIABLE", 8, 4948},
	{"SWEDEN", 6, 4949},
	{"CONDUCTED", 9, 4950},
	{"VERSIONS", 8, 4951},
	{"CAREFULLY", 9, 4952},
	{"PROPOSAL", 8, 4953},
	{"HECU", 4, 4954},
	{"NDPA", 4, 4955},
	{"OFFT", 4, 4956},
	{"YHAS", 4, 4957},
	{"SHADOW", 6, 4958},
	{"KNOWS", 5, 4959},
	{"GOFT", 4, 4960},
	{"MISSISSIPPI", 11, 4961},
	{"EMOTIONAL", 9, 4962},
	{"YCOU", 4, 4963},
	{"IKEL", 4, 4964},
	{"BACKUP", 6, 4965},
	{"REQUESTED", 9, 4966},
	{"CITIZENS", 8, 4967},
	{"WORKS", 5, 4968},
	{"OUTCOME", 7, 4969},
	{"CONNECTICUT", 11, 4970},
	{"DPER", 4, 4971},
	{"SOUL", 4, 4972},
	{"PERSONALS", 9, 4973},
	{"EKJ", 3, 4974},
	{"HOLDING", 7, 4975},
	{"HEMU", 4, 4976},
	{"COUNTY", 6, 4977},
	{"GREATEST", 8, 4978},
	{"KEVIN", 5, 4979},
	{"ANALYST", 7, 4980},
	{"ULLY", 4, 4981},
	{"YUC", 3, 4982},
	{"OMQ", 3, 4983},
	{"SUPPORTING", 10, 4984},
	{"UTUR", 4, 4985},
	{"ETHNIC", 6, 4986},
	{"DAYT", 4, 4987},
	{"LSOA", 4, 4988},
	{"REPEAT", 6, 4989},
	{"ENEMY", 5, 4990},
	{"TYQ", 3, 4991},
	{"HATB", 4, 4992},
	{"ASSIGNED", 8, 4993},
	{"COLLECTIONS", 11, 4994},
	{"YRH", 3, 4995},
	{"AGES", 4, 4996},
	{"ROMH", 4, 4997},
	{"PLUG", 4, 4998},
	{"VVY", 3, 4999},
	{"VIRGIN", 6, 5000},
	{"THCA", 4, 5001},
	{"RAISED", 6, 5002},
	{"STORM", 5, 5003},
	{"ANGU", 4, 5004},
	{"PANEL", 5, 5005},
	{"DIRECTED", 8, 5006},
	{"URIT", 4, 5007},
	{"DEALERS", 7, 5008},
	{"CHEST", 5, 5009},
	{"SEARCHING", 9, 5010},
	{"SPORTING", 8, 5011},
	{"HELPING", 7, 5012},
	{"THEME", 5, 5013},
	{"DHAS", 4, 5014},
	{"EJR", 3, 5015},
	{"PERL", 4, 5016},
	{"REGULATION", 10, 5017},
	{"ELOC", 4, 5018},
	{"AFFECTED", 8, 5019},
	{"RFRO", 4, 5020},
	{"OFPR", 4, 5021},
	{"LIB", 3, 5022},
	{"SSOR", 4, 5023},
	{"E-MAIL", 6, 5024},
	{"ISPL", 4, 5025},
	{"ESOR", 4, 5026},
	{"YELLOW", 6, 5027},
	{"REVENUE", 7, 5028},
	{"RSHE", 4, 5029},
	{"IYU", 3, 5030},
	{"YWIL", 4, 5031},
	{"EXPENSES", 8, 5032},
	{"TOPL", 4, 5033},
	{"BLEF", 4, 5034},
	{"ERLA", 4, 5035},
	{"BLONDE", 6, 5036},
	{"INVESTOR", 8, 5037},
	{"RTOT", 4, 5038},
	{"FRUIT", 5, 5039},
	{"KEDT", 4, 5040},
	{"PROCEEDINGS", 11, 5041},
	{"NOVEL", 5, 5042},
	{"ENDT", 4, 5043},
	{"SURROUND", 8, 5044},
	{"FAVOURITE", 9, 5045},
	{"ORGANIZE", 8, 5046},
	{"RTRA", 4, 5047},
	{"UNION", 5, 5048},
	{"ANDERSON", 8, 5049},
	{"BREAST", 6, 5050},
	{"CHARACTERISTICS", 15, 5051},
	{"MARRIED", 7, 5052},
	{"DER", 3, 5053},
	{"NDTR", 4, 5054},
	{"LOAN", 4, 5055},
	{"NTWO", 4, 5056},
	{"EXPERIENCES", 11, 5057},
	{"ALBUMS", 6, 5058},
	{"CHEATS", 6, 5059},
	{"VERZEICHNIS", 11, 5060},
	{"DIFFICULTY", 10, 5061},
	{"CONTRACTS", 9, 5062},
	{"REWI", 4, 5063},
	{"GUESTS", 6, 5064},
	{"NGBE", 4, 5065},
	{"SURPRISE", 8, 5066},
	{"LSON", 4, 5067},
	{"OBEC", 4, 5068},
	{"HOSTED", 6, 5069},
	{"SOMEHOW", 7, 5070},
	{"LSIN", 4, 5071},
	{"AYEA", 4, 5072},
	{"DISEASES", 8, 5073},
	{"DEVELOPERS", 10, 5074},
	{"CONCLUDE", 8, 5075},
	{"TONY", 4, 5076},
	{"BALANCE", 7, 5077},
	{"NEVADA", 6, 5078},
	{"IMPOSSIBLE", 10, 5079},
	{"AMEO", 4, 5080},
	{"KITS", 4, 5081},
	{"THAILAND", 8, 5082},
	{"FYU", 3, 5083},
	{"DTOM", 4, 5084},
	{"VARIABLES", 9, 5085},
	{"GENERATE", 8, 5086},
	{"FTHA", 4, 5087},
	{"CONTINUES", 9, 5088},
	{"TRACKS", 6, 5089},
	{"ERSB", 4, 5090},
	{"ADVISORY", 8, 5091},
	{"CAM", 3, 5092},
	{"BEAR", 4, 5093},
	{"GENDER", 6, 5094},
	{"UNTA", 4, 5095},
	{"ECTT", 4, 5096},
	{"TEMPLATE", 8, 5097},
	{"PRINCE", 6, 5098},
	{"INVITE", 6, 5099},
	{"GRANTS", 6, 5100},
	{"ELYT", 4, 5101},
	{"EIRC", 4, 5102},
	{"ABLI", 4, 5103},
	{"SEWH", 4, 5104},
	{"RESPONSES", 9, 5105},
	{"ATLANTIC", 8, 5106},
	{"IMEN", 4, 5107},
	{"ASTW", 4, 5108},
	{"EDWARD", 6, 5109},
	{"CONNECT", 7, 5110},
	{"LARGELY", 7, 5111},
	{"EAMO", 4, 5112},
	{"COMPONENT", 9, 5113},
	{"ROFI", 4, 5114},
	{"PRIME", 5, 5115},
	{"RAM", 3, 5116},
	{"LEAVING", 7, 5117},
	{"APPLIANCES", 10, 5118},
	{"MATT", 4, 5119},
	{"IONM", 4, 5120},
	{"DWOR", 4, 5121},
	{"SIGNIFICANTLY", 13, 5122},
	{"SPEAKING", 8, 5123},
	{"INTERNAL", 8, 5124},
	{"PHOTOGRAPH", 10, 5125},
	{"CODE", 4, 5126},
	{"SPONSORS", 8, 5127},
	{"FOX", 3, 5128},
	{"UNLIMITED", 9, 5129},
	{"NLYT", 4, 5130},
	{"SETTING", 7, 5131},
	{"NGDO", 4, 5132},
	{"OTBA", 4, 5133},
	{"NDLA", 4, 5134},
	{"NINC", 4, 5135},
	{"ACKNOWLEDGE", 11, 5136},
	{"ADVICE", 6, 5137},
	{"SIZES", 5, 5138},
	{"HATY", 4, 5139},
	{"ENTERED", 7, 5140},
	{"IRAN", 4, 5141},
	{"AMEI", 4, 5142},
	{"KEYS", 4, 5143},
	{"THICK", 5, 5144},
	{"MUSCLE", 6, 5145},
	{"CHECKING", 8, 5146},
	{"COSTA", 5, 5147},
	{"NCTI", 4, 5148},
	{"ERLI", 4, 5149},
	{"EHEL", 4, 5150},
	{"BELGIUM", 7, 5151},
	{"PRINTABLE", 9, 5152},
	{"ACTS", 4, 5153},
	{"SFUL", 4, 5154},
	{"AREG", 4, 5155},
	{"TREND", 5, 5156},
	{"NIND", 4, 5157},
	{"MESH", 4, 5158},
	{"YCAN", 4, 5159},
	{"RING", 4, 5160},
	{"RREC", 4, 5161},
	{"NOWI", 4, 5162},
	{"ERWO", 4, 5163},
	{"BELONG", 6, 5164},
	{"CRAFTS", 6, 5165},
	{"CKAN", 4, 5166},
	{"ASAB", 4, 5167},
	{"LOCATE", 6, 5168},
	{"LLYW", 4, 5169},
	{"NGAG", 4, 5170},
	{"HARDCOVER", 9, 5171},
	{"OBSERVED", 8, 5172},
	{"CONTENT", 7, 5173},
	{"DEAN", 4, 5174},
	{"STRESS", 6, 5175},
	{"RSWE", 4, 5176},
	{"NOTION", 6, 5177},
	{"JAPANESE", 8, 5178},
	{"DANCE", 5, 5179},
	{"RIDG", 4, 5180},
	{"ANYMORE", 7, 5181},
	{"SETUP", 5, 5182},
	{"BOOKING", 7, 5183},
	{"PROFIT", 6, 5184},
	{"EAUT", 4, 5185},
	{"GLOSSARY", 8, 5186},
	{"TTHR", 4, 5187},
	{"XYA", 3, 5188},
	{"STYLES", 6, 5189},
	{"HEAM", 4, 5190},
	{"MUSEUM", 6, 5191},
	{"PWIT", 4, 5192},
	{"RECOMMEND", 9, 5193},
	{"EXPENSIVE", 9, 5194},
	{"DENVER", 6, 5195},
	{"UNIX", 4, 5196},
	{"NDOW", 4, 5197},
	{"PROPOSE", 7, 5198},
	{"FILLED", 6, 5199},
	{"ETOC", 4, 5200},
	{"ANOF", 4, 5201},
	{"CHANNELS", 8, 5202},
	{"PACKAGE", 7, 5203},
	{"THINKING", 8, 5204},
	{"ERICSSON", 8, 5205},
	{"TLAN", 4, 5206},
	{"NDOU", 4, 5207},
	{"APPENDIX", 8, 5208},
	{"CURRENTLY", 9, 5209},
	{"NEDB", 4, 5210},
	{"NOTIFY", 6, 5211},
	{"BLUES", 5, 5212},
	{"PUB", 3, 5213},
	{"SELECT", 6, 5214},
	{"EOFC", 4, 5215},
	{"GEME", 4, 5216},
	{"HAMPSHIRE", 9, 5217},
	{"CONTRAST", 8, 5218},
	{"BOTTLE", 6, 5219},
	{"CABLES", 6, 5220},
	{"HEARING", 7, 5221},
	{"MEAL", 4, 5222},
	{"OUGHT", 5, 5223},
	{"ASOF", 4, 5224},
	{"BLUETOOTH", 9, 5225},
	{"OFCA", 4, 5226},
	{"CONTROLLED", 10, 5227},
	{"ESAY", 4, 5228},
	{"SOFP", 4, 5229},
	{"HEKI", 4, 5230},
	{"BRIDGE", 6, 5231},
	{"DENTAL", 6, 5232},
	{"KILLED", 6, 5233},
	{"VISITOR", 7, 5234},
	{"SHIRT", 5, 5235},
	{"ERFI", 4, 5236},
	{"ANGRY", 5, 5237},
	{"PLEO", 4, 5238},
	{"EVIO", 4, 5239},
	{"NTOW", 4, 5240},
	{"APIT", 4, 5241},
	{"NYOF", 4, 5242},
	{"UYN", 3, 5243},
	{"REPRESENTATIVES", 15, 5244},
	{"RWHE", 4, 5245},
	{"YSHO", 4, 5246},
	{"UNIQUE", 6, 5247},
	{"RDSA", 4, 5248},
	{"EDPR", 4, 5249},
	{"STARTS", 6, 5250},
	{"CAUSES", 6, 5251},
	{"RKER", 4, 5252},
	{"ARKANSAS", 8, 5253},
	{"NGBA", 4, 5254},
	{"YHAD", 4, 5255},
	{"ZMO", 3, 5256},
	{"LEISURE", 7, 5257},
	{"ATTRACTIONS", 11, 5258},
	{"EALO", 4, 5259},
	{"LEARNED", 7, 5260},
	{"TRANSACTIONS", 12, 5261},
	{"STRUGGLE", 8, 5262},
	{"XGO", 3, 5263},
	{"EXPLORER", 8, 5264},
	{"DSON", 4, 5265},
	{"RSEA", 4, 5266},
	{"EARTH", 5, 5267},
	{"ATTACHED", 8, 5268},
	{"GHTB", 4, 5269},
	{"OPENED", 6, 5270},
	{"CASH", 4, 5271},
	{"ENSURE", 6, 5272},
	{"OFPE", 4, 5273},
	{"LINK", 4, 5274},
	{"WAKE", 4, 5275},
	{"SHIFT", 5, 5276},
	{"ACTUAL", 6, 5277},
	{"AUTHORIZED", 10, 5278},
	{"EINV", 4, 5279},
	{"NIFI", 4, 5280},
	{"UPCOMING", 8, 5281},
	{"BRITAIN", 7, 5282},
	{"TRAFFIC", 7, 5283},
	{"SCORES", 6, 5284},
	{"CKOF", 4, 5285},
	{"FINANCING", 9, 5286},
	{"EHOL", 4, 5287},
	{"HEFU", 4, 5288},
	{"OMAT", 4, 5289},
	{"GTHI", 4, 5290},
	{"ADOPTED", 7, 5291},
	{"WEBLOG", 6, 5292},
	{"CREW", 4, 5293},
	{"MARK", 4, 5294},
	{"SLIP", 4, 5295},
	{"UZO", 3, 5296},
	{"LINEAR", 6, 5297},
	{"AGOO", 4, 5298},
	{"BEARS", 5, 5299},
	{"JEAN", 4, 5300},
	{"EDITED", 6, 5301},
	{"CHWA", 4, 5302},
	{"VISA", 4, 5303},
	{"NCEN", 4, 5304},
	{"BROWN", 5, 5305},
	{"SILENCE", 7, 5306},
	{"LYFO", 4, 5307},
	{"LINKED", 6, 5308},
	{"ERER", 4, 5309},
	{"MPAI", 4, 5310},
	{"APPEARANCE", 10, 5311},
	{"DUE", 3, 5312},
	{"ITWI", 4, 5313},
	{"ESTM", 4, 5314},
	{"EBET", 4, 5315},
	{"PORTLAND", 8, 5316},
	{"INTERVIEWS", 10, 5317},
	{"NDIV", 4, 5318},
	{"CONCEPTS", 8, 5319},
	{"LDNO", 4, 5320},
	{"MPAR", 4, 5321},
	{"CAPACITY", 8, 5322},
	{"COMFORTABLE", 11, 5323},
	{"REGIME", 6, 5324},
	{"ONSF", 4, 5325},
	{"OMPO", 4, 5326},
	{"ERFR", 4, 5327},
	{"TICL", 4, 5328},
	{"PERCEPTION", 10, 5329},
	{"AZD", 3, 5330},
	{"IVIT", 4, 5331},
	{"FZA", 3, 5332},
	{"LESSONS", 7, 5333},
	{"MTHA", 4, 5334},
	{"BEAUTY", 6, 5335},
	{"DWHI", 4, 5336},
	{"ITIV", 4, 5337},
	{"OBVIOUS", 7, 5338},
	{"BEGINS", 6, 5339},
	{"QUALIFIED", 9, 5340},
	{"ZPR", 3, 5341},
	{"INTERVENTION", 12, 5342},
	{"CAPTURE", 7, 5343},
	{"ALERTS", 6, 5344},
	{"NSWI", 4, 5345},
	{"TREATED", 7, 5346},
	{"SNOW", 4, 5347},
	{"MYSQL", 5, 5348},
	{"SFOU", 4, 5349},
	{"CLASSIFIED", 10, 5350},
	{"ICEO", 4, 5351},
	{"RELATING", 8, 5352},
	{"VERW", 4, 5353},
	{"OUZ", 3, 5354},
	{"HEVE", 4, 5355},
	{"GOLF", 4, 5356},
	{"OFCH", 4, 5357},
	{"NDHO", 4, 5358},
	{"ACCIDENT", 8, 5359},
	{"UDIE", 4, 5360},
	{"BASKETBALL", 10, 5361},
	{"POSSIBLY", 8, 5362},
	{"PREFER", 6, 5363},
	{"LEWIS", 5, 5364},
	{"EEPI", 4, 5365},
	{"HOWARD", 6, 5366},
	{"GHSC", 4, 5367},
	{"OFFLINE", 7, 5368},
	{"SOIL", 4, 5369},
	{"LEAVES", 6, 5370},
	{"CONTRIBUTION", 12, 5371},
	{"OMTO", 4, 5372},
	{"AIRPORT", 7, 5373},
	{"CLEARANCE", 9, 5374},
	{"ENTD", 4, 5375},
	{"EORI", 4, 5376},
	{"DPRE", 4, 5377},
	{"CONNECTIONS", 11, 5378},
	{"CATHOLIC", 8, 5379},
	{"YOUH", 4, 5380},
	{"CONVERTER", 9, 5381},
	{"EENC", 4, 5382},
	{"LONG-TERM", 9, 5383},
	{"FILE", 4, 5384},
	{"NDWO", 4, 5385},
	{"NDPO", 4, 5386},
	{"SSIV", 4, 5387},
	{"ORGANISATION", 12, 5388},
	{"NDLI", 4, 5389},
	{"TENC", 4, 5390},
	{"APPRECIATE", 10, 5391},
	{"OREX", 4, 5392},
	{"BABE", 4, 5393},
	{"GOVERNOR", 8, 5394},
	{"CHECKS", 6, 5395},
	{"REACHED", 7, 5396},
	{"SAFARI", 6, 5397},
	{"SHEET", 5, 5398},
	{"INDICATED", 9, 5399},
	{"RGIN", 4, 5400},
	{"LYHA", 4, 5401},
	{"WNTO", 4, 5402},
	{"ROOT", 4, 5403},
	{"PERCENTAGE", 10, 5404},
	{"TONL", 4, 5405},
	{"LAUNCH", 6, 5406},
	{"CIFI", 4, 5407},
	{"HARDLY", 6, 5408},
	{"LEDB", 4, 5409},
	{"OMBI", 4, 5410},
	{"LEGS", 4, 5411},
	{"RWOR", 4, 5412},
	{"ACOU", 4, 5413},
	{"CHNO", 4, 5414},
	{"OFSE", 4, 5415},
	{"SECURITIES", 10, 5416},
	{"INGY", 4, 5417},
	{"LDNT", 4, 5418},
	{"ALLEN", 5, 5419},
	{"PDT", 3, 5420},
	{"USER", 4, 5421},
	{"ESTATE", 6, 5422},
	{"ENABLED", 7, 5423},
	{"MONTANA", 7, 5424},
	{"BOWL", 4, 5425},
	{"USZ", 3, 5426},
	{"ARER", 4, 5427},
	{"TESTED", 6, 5428},
	{"IDDL", 4, 5429},
	{"GUIDE", 5, 5430},
	{"MIX", 3, 5431},
	{"TOPIC", 5, 5432},
	{"IHAV", 4, 5433},
	{"SWITZERLAND", 11, 5434},
	{"BOUND", 5, 5435},
	{"PARAMETER", 9, 5436},
	{"UEK", 3, 5437},
	{"ADAPTER", 7, 5438},
	{"NODE", 4, 5439},
	{"CORRECT", 7, 5440},
	{"LVED", 4, 5441},
	{"NTWI", 4, 5442},
	{"DIMENSIONS", 10, 5443},
	{"RPER", 4, 5444},
	{"UBN", 3, 5445},
	{"TRULY", 5, 5446},
	{"WNAS", 4, 5447},
	{"LWIT", 4, 5448},
	{"MICRO", 5, 5449},
	{"EOFM", 4, 5450},
	{"DECLARE", 7, 5451},
	{"COLLEGES", 8, 5452},
	{"LAPTOPS", 7, 5453},
	{"ISLI", 4, 5454},
	{"TOOTH", 5, 5455},
	{"MILE", 4, 5456},
	{"DEFEND", 6, 5457},
	{"EBIG", 4, 5458},
	{"FREQUENTLY", 10, 5459},
	{"SHOWED", 6, 5460},
	{"CHALLENGES", 10, 5461},
	{"ILIN", 4, 5462},
	{"FTHO", 4, 5463},
	{"TTOR", 4, 5464},
	{"ADET", 4, 5465},
	{"EPOI", 4, 5466},
	{"EDITORS", 7, 5467},
	{"MENS", 4, 5468},
	{"ESTIMATE", 8, 5469},
	{"ZONE", 4, 5470},
	{"UXS", 3, 5471},
	{"LLSA", 4, 5472},
	{"THREADS", 7, 5473},
	{"OMEW", 4, 5474},
	{"TERV", 4, 5475},
	{"BROTHERS", 8, 5476},
	{"GCY", 3, 5477},
	{"PRESENTS", 8, 5478},
	{"TSWE", 4, 5479},
	{"SGOI", 4, 5480},
	{"REF", 3, 5481},
	{"CTLY", 4, 5482},
	{"RATING", 6, 5483},
	{"SUBMISSION", 10, 5484},
	{"DOLLS", 5, 5485},
	{"SLOW", 4, 5486},
	{"FUNNY", 5, 5487},
	{"ERFE", 4, 5488},
	{"ULTIMATELY", 10, 5489},
	{"BEDROOM", 7, 5490},
	{"NTIM", 4, 5491},
	{"NAVY", 4, 5492},
	{"AREB", 4, 5493},
	{"DEDB", 4, 5494},
	{"EBUI", 4, 5495},
	{"POLITICIAN", 10, 5496},
	{"REQUIREMENT", 11, 5497},
	{"HEBL", 4, 5498},
	{"LEWH", 4, 5499},
	{"HISG", 4, 5500},
	{"CRAZY", 5, 5501},
	{"CONSUMERS", 9, 5502},
	{"FFEN", 4, 5503},
	{"LIMITS", 6, 5504},
	{"EXTREMELY", 9, 5505},
	{"NKV", 3, 5506},
	{"PAIG", 4, 5507},
	{"MANCHESTER", 10, 5508},
	{"STEAL", 5, 5509},
	{"DTOG", 4, 5510},
	{"WEAPONS", 7, 5511},
	{"STLE", 4, 5512},
	{"NNEL", 4, 5513},
	{"EMTO", 4, 5514},
	{"AIGN", 4, 5515},
	{"MEAT", 4, 5516},
	{"UGGE", 4, 5517},
	{"IDHE", 4, 5518},
	{"NDLO", 4, 5519},
	{"ETAR", 4, 5520},
	{"WNER", 4, 5521},
	{"IGUR", 4, 5522},
	{"CONTRIBUTIONS", 13, 5523},
	{"HALL", 4, 5524},
	{"ENGLISH", 7, 5525},
	{"STME", 4, 5526},
	{"EDEP", 4, 5527},
	{"ECLI", 4, 5528},
	{"NERG", 4, 5529},
	{"PEPPER", 6, 5530},
	{"NDRO", 4, 5531},
	{"CZECH", 5, 5532},
	{"ITCO", 4, 5533},
	{"SOFM", 4, 5534},
	{"RESULTING", 9, 5535},
	{"DUTY", 4, 5536},
	{"EEDI", 4, 5537},
	{"CAMBRIDGE", 9, 5538},
	{"JEWISH", 6, 5539},
	{"PILOT", 5, 5540},
	{"EADT", 4, 5541},
	{"OXD", 3, 5542},
	{"ERFA", 4, 5543},
	{"OREV", 4, 5544},
	{"STIR", 4, 5545},
	{"LANDSCAPE", 9, 5546},
	{"UGHO", 4, 5547},
	{"DAD", 3, 5548},
	{"INCREASES", 9, 5549},
	{"ULTRA", 5, 5550},
	{"IDAHO", 5, 5551},
	{"OWAN", 4, 5552},
	{"RLIE", 4, 5553},
	{"RHER", 4, 5554},
	{"PURSUE", 6, 5555},
	{"POTTER", 6, 5556},
	{"TOSU", 4, 5557},
	{"ILTH", 4, 5558},
	{"PLAYS", 5, 5559},
	{"ATYO", 4, 5560},
	{"SURGERY", 7, 5561},
	{"INVESTIGATE", 11, 5562},
	{"BULLETIN", 8, 5563},
	{"GEDT", 4, 5564},
	{"FACULTY", 7, 5565},
	{"NEITHER", 7, 5566},
	{"GERMAN", 6, 5567},
	{"SLEA", 4, 5568},
	{"EYQ", 3, 5569},
	{"KICK", 4, 5570},
	{"INDICATES", 9, 5571},
	{"ULDS", 4, 5572},
	{"MIRROR", 6, 5573},
	{"ZYN", 3, 5574},
	{"ZYT", 3, 5575},
	{"YJR", 3, 5576},
	{"OXFORD", 6, 5577},
	{"ADAM", 4, 5578},
	{"STFO", 4, 5579},
	{"ARIT", 4, 5580},
	{"AINL", 4, 5581},
	{"USTT", 4, 5582},
	{"EPINIONS", 8, 5583},
	{"COMMITTED", 9, 5584},
	{"ITWO", 4, 5585},
	{"COMBINATION", 11, 5586},
	{"AFFORDABLE", 10, 5587},
	{"FRAME", 5, 5588},
	{"TPAR", 4, 5589},
	{"MANNER", 6, 5590},
	{"MPLI", 4, 5591},
	{"WARN", 4, 5592},
	{"DATABASES", 9, 5593},
	{"IFFI", 4, 5594},
	{"OFDE", 4, 5595},
	{"YRY", 3, 5596},
	{"UVO", 3, 5597},
	{"OBAB", 4, 5598},
	{"RALA", 4, 5599},
	{"RSEL", 4, 5600},
	{"PSP", 3, 5601},
	{"EQUAL", 5, 5602},
	{"BESIDE", 6, 5603},
	{"ISFO", 4, 5604},
	{"PLANNED", 7, 5605},
	{"WATCHING", 8, 5606},
	{"OURSELVES", 9, 5607},
	{"LODGE", 5, 5608},
	{"MESSENGER", 9, 5609},
	{"HOWI", 4, 5610},
	{"SVER", 4, 5611},
	{"YBUT", 4, 5612},
	{"DISCOUNTS", 9, 5613},
	{"ITYC", 4, 5614},
	{"OVB", 3, 5615},
	{"STERLING", 8, 5616},
	{"SESSIONS", 8, 5617},
	{"RPRE", 4, 5618},
	{"NDME", 4, 5619},
	{"STWO", 4, 5620},
	{"KERNEL", 6, 5621},
	{"OMOT", 4, 5622},
	{"BOND", 4, 5623},
	{"GOLDEN", 6, 5624},
	{"BOOBS", 5, 5625},
	{"IONR", 4, 5626},
	{"OPPOSITION", 10, 5627},
	{"STOCKS", 6, 5628},
	{"BUYERS", 6, 5629},
	{"DMAR", 4, 5630},
	{"ETED", 4, 5631},
	{"JOURNALS", 8, 5632},
	{"TEAR", 4, 5633},
	{"ANCIENT", 7, 5634},
	{"CATALOGUE", 9, 5635},
	{"ANUA", 4, 5636},
	{"NGSH", 4, 5637},
	{"ICHT", 4, 5638},
	{"BLAME", 5, 5639},
	{"JENNIFER", 8, 5640},
	{"OFMO", 4, 5641},
	{"ORAR", 4, 5642},
	{"ERAB", 4, 5643},
	{"ANTONIO", 7, 5644},
	{"CONSERVATIVE", 12, 5645},
	{"CHARGED", 7, 5646},
	{"ELIMINATE", 9, 5647},
	{"DIVISION", 8, 5648},
	{"UGHA", 4, 5649},
	{"LEAGUE", 6, 5650},
	{"LWAS", 4, 5651},
	{"TEDP", 4, 5652},
	{"TAIWAN", 6, 5653},
	{"ORTT", 4, 5654},
	{"INPR", 4, 5655},
	{"UND", 3, 5656},
	{"NTEL", 4, 5657},
	{"CHOSEN", 6, 5658},
	{"ILLN", 4, 5659},
	{"DEMO", 4, 5660},
	{"TKNO", 4, 5661},
	{"GREECE", 6, 5662},
	{"SWISS", 5, 5663},
	{"TYPICAL", 7, 5664},
	{"SARAH", 5, 5665},
	{"ENFO", 4, 5666},
	{"EIRF", 4, 5667},
	{"HEQU", 4, 5668},
	{"CLARK", 5, 5669},
	{"IVEP", 4, 5670},
	{"LABOUR", 6, 5671},
	{"CHAIN", 5, 5672},
	{"URNI", 4, 5673},
	{"PRODUCER", 8, 5674},
	{"TERMINAL", 8, 5675},
	{"ANRE", 4, 5676},
	{"LLYC", 4, 5677},
	{"RZY", 3, 5678},
	{"YNY", 3, 5679},
	{"PUBLISHERS", 10, 5680},
	{"ORYA", 4, 5681},
	{"NIGHTS", 6, 5682},
	{"RDIS", 4, 5683},
	{"EFIL", 4, 5684},
	{"CARIBBEAN", 9, 5685},
	{"MBIN", 4, 5686},
	{"RSCO", 4, 5687},
	{"MOTION", 6, 5688},
	{"BRANCH", 6, 5689},
	{"AMEW", 4, 5690},
	{"EDAF", 4, 5691},
	{"USTB", 4, 5692},
	{"LENGTH", 6, 5693},
	{"CHARACTERISTIC", 14, 5694},
	{"RELY", 4, 5695},
	{"TOFH", 4, 5696},
	{"EXPECTATION", 11, 5697},
	{"TSEL", 4, 5698},
	{"EXCEPT", 6, 5699},
	{"EUND", 4, 5700},
	{"TUAT", 4, 5701},
	{"NEBRASKA", 8, 5702},
	{"FOODS", 5, 5703},
	{"GOURMET", 7, 5704},
	{"APPEAL", 6, 5705},
	{"ERBU", 4, 5706},
	{"LLRE", 4, 5707},
	{"RABL", 4, 5708},
	{"NGUA", 4, 5709},
	{"ORLEANS", 7, 5710},
	{"NTHR", 4, 5711},
	{"NFL", 3, 5712},
	{"FORTH", 5, 5713},
	{"ERHO", 4, 5714},
	{"COVERAGE", 8, 5715},
	{"ITHD", 4, 5716},
	{"ROW", 3, 5717},
	{"YIB", 3, 5718},
	{"MULTIPLE", 8, 5719},
	{"DEBT", 4, 5720},
	{"EMID", 4, 5721},
	{"MEANWHILE", 9, 5722},
	{"SOLVE", 5, 5723},
	{"DNY", 3, 5724},
	{"RELIEF", 6, 5725},
	{"AVATAR", 6, 5726},
	{"GARY", 4, 5727},
	{"HEPI", 4, 5728},
	{"TRUST", 5, 5729},
	{"IVEO", 4, 5730},
	{"AGEM", 4, 5731},
	{"RSAI", 4, 5732},
	{"OMOR", 4, 5733},
	{"LSTO", 4, 5734},
	{"NZU", 3, 5735},
	{"HUNDREDS", 8, 5736},
	{"ROME", 4, 5737},
	{"ZUC", 3, 5738},
	{"LLAG", 4, 5739},
	{"LINCOLN", 7, 5740},
	{"ZLO", 3, 5741},
	{"HELPED", 6, 5742},
	{"OCEAN", 5, 5743},
	{"PREMIER", 7, 5744},
	{"INDUSTRIAL", 10, 5745},
	{"GRAY", 4, 5746},
	{"DBEA", 4, 5747},
	{"NEXP", 4, 5748},
	{"EFFO", 4, 5749},
	{"RLEA", 4, 5750},
	{"OUSI", 4, 5751},
	{"PURCHASED", 9, 5752},
	{"AMEM", 4, 5753},
	{"NURSE", 5, 5754},
	{"AIDS", 4, 5755},
	{"NGRA", 4, 5756},
	{"SMART", 5, 5757},
	{"VEGETABLE", 9, 5758},
	{"ESLI", 4, 5759},
	{"FIX", 3, 5760},
	{"BEER", 4, 5761},
	{"VISITING", 8, 5762},
	{"YATT", 4, 5763},
	{"OUPL", 4, 5764},
	{"PERFORMING", 10, 5765},
	{"XHU", 3, 5766},
	{"CONFIRM", 7, 5767},
	{"ODZ", 3, 5768},
	{"KEYBOARD", 8, 5769},
	{"HEWH", 4, 5770},
	{"JUDGMENT", 8, 5771},
	{"UMY", 3, 5772},
	{"POUR", 4, 5773},
	{"CONTEMPORARY", 12, 5774},
	{"LSTH", 4, 5775},
	{"COLLECTED", 9, 5776},
	{"BANDS", 5, 5777},
	{"NSCO", 4, 5778},
	{"FFTH", 4, 5779},
	{"UTWH", 4, 5780},
	{"LKIN", 4, 5781},
	{"EBOO", 4, 5782},
	{"MILLIONS", 8, 5783},
	{"UYG", 3, 5784},
	{"NDNE", 4, 5785},
	{"ATEW", 4, 5786},
	{"AUDIT", 5, 5787},
	{"ASSESS", 6, 5788},
	{"WINNER", 6, 5789},
	{"CEFO", 4, 5790},
	{"IGGE", 4, 5791},
	{"CLOUD", 5, 5792},
	{"GUINEA", 6, 5793},
	{"FINDINGS", 8, 5794},
	{"ATTRACT", 7, 5795},
	{"KEQ", 3, 5796},
	{"ITHF", 4, 5797},
	{"CURRICULUM", 10, 5798},
	{"ICET", 4, 5799},
	{"ELOS", 4, 5800},
	{"FEATURING", 9, 5801},
	{"YSTH", 4, 5802},
	{"RRIV", 4, 5803},
	{"TZB", 3, 5804},
	{"CLICKING", 8, 5805},
	{"TANK", 4, 5806},
	{"LLIS", 4, 5807},
	{"MINISTER", 8, 5808},
	{"NWIL", 4, 5809},
	{"OMPU", 4, 5810},
	{"SCHEDULED", 9, 5811},
	{"INTERACTION", 11, 5812},
	{"ERSM", 4, 5813},
	{"POLLS", 5, 5814},
	{"USED", 4, 5815},
	{"SECRET", 6, 5816},
	{"MISC", 4, 5817},
	{"CALCULATOR", 10, 5818},
	{"NTOB", 4, 5819},
	{"SECTOR", 6, 5820},
	{"COMPLAIN", 8, 5821},
	{"PLEASURE", 8, 5822},
	{"OFFO", 4, 5823},
	{"NGLY", 4, 5824},
	{"ALAN", 4, 5825},
	{"SEED", 4, 5826},
	{"HATF", 4, 5827},
	{"SENDING", 7, 5828},
	{"ENTIRELY", 8, 5829},
	{"NGAC", 4, 5830},
	{"JASON", 5, 5831},
	{"WASTE", 5, 5832},
	{"TOPU", 4, 5833},
	{"SEPARATE", 8, 5834},
	{"ADUA", 4, 5835},
	{"GICA", 4, 5836},
	{"HOLDEM", 6, 5837},
	{"ASIDE", 5, 5838},
	{"HATL", 4, 5839},
	{"SCOV", 4, 5840},
	{"BENEATH", 7, 5841},
	{"STWE", 4, 5842},
	{"AFFORD", 6, 5843},
	{"OVERALL", 7, 5844},
	{"ETOG", 4, 5845},
	{"ESSENTIAL", 9, 5846},
	{"WING", 4, 5847},
	{"XSY", 3, 5848},
	{"INITIAL", 7, 5849},
	{"SACT", 4, 5850},
	{"STRETCH", 7, 5851},
	{"NDPE", 4, 5852},
	{"CITE", 4, 5853},
	{"ORSH", 4, 5854},
	{"KYG", 3, 5855},
	{"GONT", 4, 5856},
	{"VOLUME", 6, 5857},
	{"NSPO", 4, 5858},
	{"INCREASED", 9, 5859},
	{"NDOR", 4, 5860},
	{"RARE", 4, 5861},
	{"IMPROVEMENT", 11, 5862},
	{"OWNI", 4, 5863},
	{"ANYWHERE", 8, 5864},
	{"VANCOUVER", 9, 5865},
	{"CONFIDENCE", 10, 5866},
	{"NVEN", 4, 5867},
	{"EFAM", 4, 5868},
	{"SEEMED", 6, 5869},
	{"TZL", 3, 5870},
	{"EMPHASIZE", 9, 5871},
	{"ZVO", 3, 5872},
	{"ABORTION", 8, 5873},
	{"RESOLUTION", 10, 5874},
	{"WITNESS", 7, 5875},
	{"EREO", 4, 5876},
	{"TOWI", 4, 5877},
	{"GNY", 3, 5878},
	{"EMPLOY", 6, 5879},
	{"SPYWARE", 7, 5880},
	{"PACKAGING", 9, 5881},
	{"INDT", 4, 5882},
	{"JOSE", 4, 5883},
	{"DISH", 4, 5884},
	{"EKNO", 4, 5885},
	{"MASTER", 6, 5886},
	{"AZL", 3, 5887},
	{"SPECIFICALLY", 12, 5888},
	{"JANE", 4, 5889},
	{"HEFL", 4, 5890},
	{"TSAL", 4, 5891},
	{"SOFH", 4, 5892},
	{"PAKISTAN", 8, 5893},
	{"SURPRISED", 9, 5894},
	{"NKTH", 4, 5895},
	{"CONSULTATION", 12, 5896},
	{"NGPO", 4, 5897},
	{"ANUN", 4, 5898},
	{"ARYS", 4, 5899},
	{"DSHO", 4, 5900},
	{"SOMEWHAT", 8, 5901},
	{"LEDG", 4, 5902},
	{"FINDER", 6, 5903},
	{"YMOR", 4, 5904},
	{"LBUM", 4, 5905},
	{"PERIODS", 7, 5906},
	{"NJUR", 4, 5907},
	{"NDEC", 4, 5908},
	{"TASKS", 5, 5909},
	{"RDTO", 4, 5910},
	{"XBI", 3, 5911},
	{"YTOT", 4, 5912},
	{"ATTACKS", 7, 5913},
	{"KIM", 3, 5914},
	{"WALLPAPER", 9, 5915},
	{"MERCHANDISE", 11, 5916},
	{"ERBO", 4, 5917},
	{"TOTALLY", 7, 5918},
	{"CONST", 5, 5919},
	{"ANYW", 4, 5920},
	{"ESEV", 4, 5921},
	{"NDBA", 4, 5922},
	{"DOORS", 5, 5923},
	{"IEDA", 4, 5924},
	{"SYMPTOMS", 8, 5925},
	{"EHIM", 4, 5926},
	{"RESORTS", 7, 5927},
	{"TOTR", 4, 5928},
	{"LLYO", 4, 5929},
	{"BIGGEST", 7, 5930},
	{"TEMB", 4, 5931},
	{"CCUR", 4, 5932},
	{"SBAN", 4, 5933},
	{"RURAL", 5, 5934},
	{"THCE", 4, 5935},
	{"TERRIBLE", 8, 5936},
	{"ENAL", 4, 5937},
	{"MEMORIAL", 8, 5938},
	{"EABL", 4, 5939},
	{"DTWO", 4, 5940},
	{"BALTIMORE", 9, 5941},
	{"NCAN", 4, 5942},
	{"GATEWAY", 7, 5943},
	{"SFIN", 4, 5944},
	{"TERL", 4, 5945},
	{"GRANT", 5, 5946},
	{"TIRED", 5, 5947},
	{"CORE", 4, 5948},
	{"DONT", 4, 5949},
	{"ALUMNI", 6, 5950},
	{"OURP", 4, 5951},
	{"RUSH", 4, 5952},
	{"AYZ", 3, 5953},
	{"CANDIDATES", 10, 5954},
	{"CHARLOTTE", 9, 5955},
	{"ORDERED", 7, 5956},
	{"DOUBT", 5, 5957},
	{"BABL", 4, 5958},
	{"BARELY", 6, 5959},
	{"LIMITED", 7, 5960},
	{"HAPPENS", 7, 5961},
	{"ITYW", 4, 5962},
	{"PREFERENCES", 11, 5963},
	{"OFAS", 4, 5964},
	{"HCEN", 4, 5965},
	{"ONWE", 4, 5966},
	{"TOFS", 4, 5967},
	{"BUSY", 4, 5968},
	{"BRUCE", 5, 5969},
	{"TMOR", 4, 5970},
	{"OPPOSE", 6, 5971},
	{"FASHION", 7, 5972},
	{"OFOU", 4, 5973},
	{"OLDT", 4, 5974},
	{"UPLE", 4, 5975},
	{"THEMES", 6, 5976},
	{"POWERS", 6, 5977},
	{"GPRO", 4, 5978},
	{"WNTH", 4, 5979},
	{"STOG", 4, 5980},
	{"FLOW", 4, 5981},
	{"WTHA", 4, 5982},
	{"BEACH", 5, 5983},
	{"BITS", 4, 5984},
	{"HOUSEHOLD", 9, 5985},
	{"NDMI", 4, 5986},
	{"ATWI", 4, 5987},
	{"CREAM", 5, 5988},
	{"EXPERIMENT", 10, 5989},
	{"OUHA", 4, 5990},
	{"CLASSIFICATION", 14, 5991},
	{"FOCUSED", 7, 5992},
	{"EGYPT", 5, 5993},
	{"HOLLYWOOD", 9, 5994},
	{"CRIMINAL", 8, 5995},
	{"PITC", 4, 5996},
	{"SONC", 4, 5997},
	{"LICI", 4, 5998},
	{"BARGAIN", 7, 5999},
	{"WIKIPEDIA", 9, 6000},
	{"EARM", 4, 6001},
	{"OPEA", 4, 6002},
	{"OBET", 4, 6003},
	{"CELLULAR", 8, 6004},
	{"NORWAY", 6, 6005},
	{"CCOU", 4, 6006},
	{"OFSO", 4, 6007},
	{"VERMONT", 7, 6008},
	{"NDSP", 4, 6009},
	{"ROWI", 4, 6010},
	{"GHOU", 4, 6011},
	{"ANTR", 4, 6012},
	{"ASKING", 6, 6013},
	{"BLOCKS", 6, 6014},
	{"NEFI", 4, 6015},
	{"HEAU", 4, 6016},
	{"EANY", 4, 6017},
	{"ICKS", 4, 6018},
	{"CHEAP", 5, 6019},
	{"YPLA", 4, 6020},
	{"VESO", 4, 6021},
	{"SDON", 4, 6022},
	{"HERO", 4, 6023},
	{"DIVIDE", 6, 6024},
	{"NECESSARILY", 11, 6025},
	{"ONVI", 4, 6026},
	{"ORHE", 4, 6027},
	{"SERIOUSLY", 9, 6028},
	{"ENGT", 4, 6029},
	{"ROUTE", 5, 6030},
	{"BODIES", 6, 6031},
	{"TOWARDS", 7, 6032},
	{"PHOTOGRAPHS", 11, 6033},
	{"CUTTING", 7, 6034},
	{"WHEEL", 5, 6035},
	{"ERYS", 4, 6036},
	{"HNOL", 4, 6037},
	{"BOMB", 4, 6038},
	{"ARLE", 4, 6039},
	{"RWHI", 4, 6040},
	{"CABLE", 5, 6041},
	{"UTON", 4, 6042},
	{"SIMON", 5, 6043},
	{"RSHO", 4, 6044},
	{"WRITERS", 7, 6045},
	{"MARKS", 5, 6046},
	{"TYPICALLY", 9, 6047},
	{"YBEC", 4, 6048},
	{"TITW", 4, 6049},
	{"COPY", 4, 6050},
	{"LOVED", 5, 6051},
	{"ALLB", 4, 6052},
	{"NGRO", 4, 6053},
	{"FAVOURITES", 10, 6054},
	{"ERPO", 4, 6055},
	{"MAPPING", 7, 6056},
	{"LIBERAL", 7, 6057},
	{"FEWER", 5, 6058},
	{"OWHE", 4, 6059},
	{"BIRDS", 5, 6060},
	{"DEFINITELY", 10, 6061},
	{"REPRESENTS", 10, 6062},
	{"USEFUL", 6, 6063},
	{"CHAR", 4, 6064},
	{"USTE", 4, 6065},
	{"INDEXED", 7, 6066},
	{"UPPER", 5, 6067},
	{"REPRESENTATIVE", 14, 6068},
	{"ALLP", 4, 6069},
	{"TEDM", 4, 6070},
	{"PITTSBURGH", 10, 6071},
	{"PREFERRED", 9, 6072},
	{"ERPE", 4, 6073},
	{"SAVED", 5, 6074},
	{"NTIR", 4, 6075},
	{"THOL", 4, 6076},
	{"NTIF", 4, 6077},
	{"DVER", 4, 6078},
	{"PAYING", 6, 6079},
	{"LYAS", 4, 6080},
	{"SHOTS", 5, 6081},
	{"GRASS", 5, 6082},
	{"HILL", 4, 6083},
	{"EAMA", 4, 6084},
	{"EVERYWHERE", 10, 6085},
	{"TLIK", 4, 6086},
	{"MOORE", 5, 6087},
	{"NGDE", 4, 6088},
	{"LARL", 4, 6089},
	{"GAQ", 3, 6090},
	{"GRANTED", 7, 6091},
	{"MASS", 4, 6092},
	{"IMTO", 4, 6093},
	{"FISHING", 7, 6094},
	{"MERELY", 6, 6095},
	{"EDBA", 4, 6096},
	{"CHOICES", 7, 6097},
	{"INVEST", 6, 6098},
	{"OPENING", 7, 6099},
	{"DECLINE", 7, 6100},
	{"ACIN", 4, 6101},
	{"EVED", 4, 6102},
	{"LISTENING", 9, 6103},
	{"REGISTRY", 8, 6104},
	{"LSOS", 4, 6105},
	{"GTOB", 4, 6106},
	{"NOISE", 5, 6107},
	{"HENC", 4, 6108},
	{"ODQ", 3, 6109},
	{"GZO", 3, 6110},
	{"GATE", 4, 6111},
	{"OUTLOOK", 7, 6112},
	{"DENMARK", 7, 6113},
	{"ITSF", 4, 6114},
	{"ENGINEER", 8, 6115},
	{"EMPLOYED", 8, 6116},
	{"HEADER", 6, 6117},
	{"RTST", 4, 6118},
	{"LLEA", 4, 6119},
	{"YMEN", 4, 6120},
	{"LLEY", 4, 6121},
	{"FORMED", 6, 6122},
	{"OUQ", 3, 6123},
	{"ISRAELI", 7, 6124},
	{"RVAT", 4, 6125},
	{"NNED", 4, 6126},
	{"DTOW", 4, 6127},
	{"NDFR", 4, 6128},
	{"OMEI", 4, 6129},
	{"XGR", 3, 6130},
	{"APPO", 4, 6131},
	{"ZKI", 3, 6132},
	{"LEGISLATION", 11, 6133},
	{"EAVI", 4, 6134},
	{"QUE", 3, 6135},
	{"IPLE", 4, 6136},
	{"SHEETS", 6, 6137},
	{"PATRICK", 7, 6138},
	{"SECRETARY", 9, 6139},
	{"YDH", 3, 6140},
	{"AVEH", 4, 6141},
	{"AVOR", 4, 6142},
	{"PUERTO", 6, 6143},
	{"OREF", 4, 6144},
	{"JEW", 3, 6145},
	{"TYTH", 4, 6146},
	{"CONSOLIDATION", 13, 6147},
	{"CAREFUL", 7, 6148},
	{"ELAR", 4, 6149},
	{"DISPLAYS", 8, 6150},
	{"PLASMA", 6, 6151},
	{"INCIDENT", 8, 6152},
	{"APART", 5, 6153},
	{"DPAR", 4, 6154},
	{"ALLOWING", 8, 6155},
	{"EOFP", 4, 6156},
	{"USEH", 4, 6157},
	{"PROUD", 5, 6158},
	{"NARROW", 6, 6159},
	{"SSFU", 4, 6160},
	{"VOIP", 4, 6161},
	{"VAST", 4, 6162},
	{"AVED", 4, 6163},
	{"ECLO", 4, 6164},
	{"IXU", 3, 6165},
	{"OFMI", 4, 6166},
	{"MILK", 4, 6167},
	{"UGUS", 4, 6168},
	{"UARD", 4, 6169},
	{"MATCH", 5, 6170},
	{"ESBU", 4, 6171},
	{"DELAWARE", 8, 6172},
	{"BIDDING", 7, 6173},
	{"ACCUSE", 6, 6174},
	{"CONSULTANTS", 11, 6175},
	{"NPRE", 4, 6176},
	{"DWIL", 4, 6177},
	{"RISKS", 5, 6178},
	{"SBUR", 4, 6179},
	{"OWLE", 4, 6180},
	{"BANNER", 6, 6181},
	{"ASSOCIATION", 11, 6182},
	{"APPLICANT", 9, 6183},
	{"RCOU", 4, 6184},
	{"FIG", 3, 6185},
	{"BARBARA", 7, 6186},
	{"ZQU", 3, 6187},
	{"COUNTIES", 8, 6188},
	{"ORTR", 4, 6189},
	{"PORTS", 5, 6190},
	{"RIPT", 4, 6191},
	{"RTHR", 4, 6192},
	{"IMPLEMENTED", 11, 6193},
	{"ITHB", 4, 6194},
	{"LLYB", 4, 6195},
	{"DIRECTORIES", 11, 6196},
	{"EAFT", 4, 6197},
	{"EENG", 4, 6198},
	{"EXPLANATION", 11, 6199},
	{"PHYSICIAN", 9, 6200},
	{"RECOGNIZED", 10, 6201},
	{"RREL", 4, 6202},
	{"DREAMS", 6, 6203},
	{"BLOGGER", 7, 6204},
	{"CYU", 3, 6205},
	{"XECU", 4, 6206},
	{"LSOC", 4, 6207},
	{"IDUA", 4, 6208},
	{"NOTIFICATION", 12, 6209},
	{"AYQ", 3, 6210},
	{"LDIS", 4, 6211},
	{"SOLID", 5, 6212},
	{"LICENSING", 9, 6213},
	{"MEWH", 4, 6214},
	{"STANDS", 6, 6215},
	{"REJECT", 6, 6216},
	{"OOKE", 4, 6217},
	{"LLYD", 4, 6218},
	{"CHHA", 4, 6219},
	{"EPUT", 4, 6220},
	{"TLIN", 4, 6221},
	{"OCCURRED", 8, 6222},
	{"ADDITION", 8, 6223},
	{"TEXTBOOKS", 9, 6224},
	{"HAIRY", 5, 6225},
	{"TOFC", 4, 6226},
	{"IMMIGRANT", 9, 6227},
	{"CLEVELAND", 9, 6228},
	{"TOGR", 4, 6229},
	{"RTSA", 4, 6230},
	{"EPIN", 4, 6231},
	{"RRAN", 4, 6232},
	{"UCTU", 4, 6233},
	{"YWHI", 4, 6234},
	{"CREATIVE", 8, 6235},
	{"GUILTY", 6, 6236},
	{"TOWO", 4, 6237},
	{"TECHNICAL", 9, 6238},
	{"RONM", 4, 6239},
	{"PPOI", 4, 6240},
	{"RGED", 4, 6241},
	{"INVESTMENTS", 11, 6242},
	{"EAPO", 4, 6243},
	{"LATINA", 6, 6244},
	{"LEBR", 4, 6245},
	{"EXPOSE", 6, 6246},
	{"WHEELS", 6, 6247},
	{"HEEV", 4, 6248},
	{"ITHR", 4, 6249},
	{"NOMY", 4, 6250},
	{"UKK", 3, 6251},
	{"GHTW", 4, 6252},
	{"INWA", 4, 6253},
	{"DERW", 4, 6254},
	{"EELI", 4, 6255},
	{"TEMPLATES", 9, 6256},
	{"HEOF", 4, 6257},
	{"FORMATS", 7, 6258},
	{"NDAM", 4, 6259},
	{"MASSIVE", 7, 6260},
	{"ATFO", 4, 6261},
	{"DEPENDS", 7, 6262},
	{"BOOTS", 5, 6263},
	{"CAMPUS", 6, 6264},
	{"HOLDS", 5, 6265},
	{"ROUTER", 6, 6266},
	{"RDEN", 4, 6267},
	{"NDFA", 4, 6268},
	{"TSRE", 4, 6269},
	{"RBUT", 4, 6270},
	{"IREA", 4, 6271},
	{"ERSD", 4, 6272},
	{"EDITING", 7, 6273},
	{"POLAND", 6, 6274},
	{"SCUS", 4, 6275},
	{"FOLDER", 6, 6276},
	{"ISWE", 4, 6277},
	{"EARD", 4, 6278},
	{"WOMENS", 6, 6279},
	{"MEFO", 4, 6280},
	{"OBSERVATION", 11, 6281},
	{"DEFINITION", 10, 6282},
	{"ERWE", 4, 6283},
	{"NGBU", 4, 6284},
	{"COMPLETION", 10, 6285},
	{"UPLOAD", 6, 6286},
	{"ENORMOUS", 8, 6287},
	{"UNFORTUNATELY", 13, 6288},
	{"SCHOLAR", 7, 6289},
	{"TALENT", 6, 6290},
	{"UNIVERSITIES", 12, 6291},
	{"RZH", 3, 6292},
	{"HICA", 4, 6293},
	{"TSTR", 4, 6294},
	{"PLENTY", 6, 6295},
	{"ICHE", 4, 6296},
	{"NEIG", 4, 6297},
	{"VIDU", 4, 6298},
	{"ACQUIRE", 7, 6299},
	{"CKSO", 4, 6300},
	{"OTRE", 4, 6301},
	{"GAY", 3, 6302},
	{"REDW", 4, 6303},
	{"VIRTUALLY", 9, 6304},
	{"SUCCEED", 7, 6305},
	{"CELEBRATE", 9, 6306},
	{"SBEI", 4, 6307},
	{"CONTRACTORS", 11, 6308},
	{"CHEESE", 6, 6309},
	{"DBET", 4, 6310},
	{"TASTE", 5, 6311},
	{"MANW", 4, 6312},
	{"MILFHUNTER", 10, 6313},
	{"HEIGHT", 6, 6314},
	{"SHARP", 5, 6315},
	{"LDAN", 4, 6316},
	{"COURTS", 6, 6317},
	{"UNDR", 4, 6318},
	{"NWOR", 4, 6319},
	{"ARDW", 4, 6320},
	{"EDBU", 4, 6321},
	{"RDST", 4, 6322},
	{"NOTICES", 7, 6323},
	{"SUBSCRIPTIONS", 13, 6324},
	{"RTWO", 4, 6325},
	{"EPOP", 4, 6326},
	{"OFPO", 4, 6327},
	{"ANTL", 4, 6328},
	{"LLTO", 4, 6329},
	{"DETROIT", 7, 6330},
	{"ALEXANDER", 9, 6331},
	{"SCREAM", 6, 6332},
	{"CONVERTED", 9, 6333},
	{"METRO", 5, 6334},
	{"TOSHIBA", 7, 6335},
	{"ONDU", 4, 6336},
	{"ECOV", 4, 6337},
	{"APPROVE", 7, 6338},
	{"OSEW", 4, 6339},
	{"TEDC", 4, 6340},
	{"IMPROVEMENTS", 12, 6341},
	{"VISUAL", 6, 6342},
	{"URPR", 4, 6343},
	{"BIKE", 4, 6344},
	{"SPECIFICATION", 13, 6345},
	{"PEARL", 5, 6346},
	{"DIND", 4, 6347},
	{"NICK", 4, 6348},
	{"ACCESSORY", 9, 6349},
	{"DLEA", 4, 6350},
	{"ZDI", 3, 6351},
	{"QTY", 3, 6352},
	{"COMPETE", 7, 6353},
	{"EWAL", 4, 6354},
	{"HROW", 4, 6355},
	{"PROSECUTOR", 10, 6356},
	{"ILLEGAL", 7, 6357},
	{"ICIE", 4, 6358},
	{"IBIL", 4, 6359},
	{"ISOF", 4, 6360},
	{"MMED", 4, 6361},
	{"TSBE", 4, 6362},
	{"EXISTS", 6, 6363},
	{"SHOUT", 5, 6364},
	{"ORFO", 4, 6365},
	{"ARRANGEMENTS", 12, 6366},
	{"EZL", 3, 6367},
	{"CONFERENCES", 11, 6368},
	{"UNIPROTKB", 9, 6369},
	{"OFAM", 4, 6370},
	{"CLOSELY", 7, 6371},
	{"REGARDING", 9, 6372},
	{"INAM", 4, 6373},
	{"BIRMINGHAM", 10, 6374},
	{"RTTH", 4, 6375},
	{"DJUS", 4, 6376},
	{"NUAR", 4, 6377},
	{"ORRI", 4, 6378},
	{"LOWER", 5, 6379},
	{"PLUS", 4, 6380},
	{"FLASHING", 8, 6381},
	{"ALTERNATIVE", 11, 6382},
	{"ESCAPE", 6, 6383},
	{"CLIMATE", 7, 6384},
	{"TLET", 4, 6385},
	{"PARTICIPATION", 13, 6386},
	{"NSUM", 4, 6387},
	{"THCO", 4, 6388},
	{"HENU", 4, 6389},
	{"NNOU", 4, 6390},
	{"PERCEIVE", 8, 6391},
	{"ONSP", 4, 6392},
	{"SBET", 4, 6393},
	{"AIRLINE", 7, 6394},
	{"CAST", 4, 6395},
	{"RROW", 4, 6396},
	{"SENTENCE", 8, 6397},
	{"CIGARETTE", 9, 6398},
	{"SBEF", 4, 6399},
	{"TOEX", 4, 6400},
	{"KNOCK", 5, 6401},
	{"NGHO", 4, 6402},
	{"LYDI", 4, 6403},
	{"FHER", 4, 6404},
	{"SBRO", 4, 6405},
	{"SURVEYS", 7, 6406},
	{"SITTING", 7, 6407},
	{"RMAR", 4, 6408},
	{"PUTTING", 7, 6409},
	{"NDTE", 4, 6410},
	{"CONTROLLER", 10, 6411},
	{"NOTR", 4, 6412},
	{"COMMITTEES", 10, 6413},
	{"XBY", 3, 6414},
	{"REXA", 4, 6415},
	{"SNAM", 4, 6416},
	{"NGTE", 4, 6417},
	{"RESEARCHERS", 11, 6418},
	{"VIETNAM", 7, 6419},
	{"ECEM", 4, 6420},
	{"EWAT", 4, 6421},
	{"SPIRITUAL", 9, 6422},
	{"WRAP", 4, 6423},
	{"CASTLE", 6, 6424},
	{"GARDENS", 7, 6425},
	{"TIVA", 4, 6426},
	{"DREC", 4, 6427},
	{"MISSED", 6, 6428},
	{"OKJ", 3, 6429},
	{"MALAYSIA", 8, 6430},
	{"UNSUBSCRIBE", 11, 6431},
	{"HYSI", 4, 6432},
	{"CRITICISM", 9, 6433},
	{"ANTIQUE", 7, 6434},
	{"LABELS", 6, 6435},
	{"NGAP", 4, 6436},
	{"MOLECULAR", 9, 6437},
	{"ACTING", 6, 6438},
	{"PROPER", 6, 6439},
	{"OYED", 4, 6440},
	{"HEADS", 5, 6441},
	{"DLIN", 4, 6442},
	{"UTIV", 4, 6443},
	{"PRIMARILY", 9, 6444},
	{"STORED", 6, 6445},
	{"UNUSUAL", 7, 6446},
	{"OFLA", 4, 6447},
	{"VERC", 4, 6448},
	{"EAKI", 4, 6449},
	{"OMEB", 4, 6450},
	{"LOGOS", 5, 6451},
	{"TSPE", 4, 6452},
	{"ATTORNEYS", 9, 6453},
	{"YWOU", 4, 6454},
	{"MILFS", 5, 6455},
	{"ASSET", 5, 6456},
	{"DEPRESSION", 10, 6457},
	{"LHAV", 4, 6458},
	{"ANTIQUES", 8, 6459},
	{"CREATION", 8, 6460},
	{"RYAN", 4, 6461},
	{"RFAC", 4, 6462},
	{"NCEF", 4, 6463},
	{"CONVINCE", 8, 6464},
	{"NLYA", 4, 6465},
	{"EYCA", 4, 6466},
	{"PHILIPPINES", 11, 6467},
	{"ICKL", 4, 6468},
	{"PERSONALITY", 11, 6469},
	{"PASSENGER", 9, 6470},
	{"DIET", 4, 6471},
	{"WDY", 3, 6472},
	{"MUSICAL", 7, 6473},
	{"BEDS", 4, 6474},
	{"BREASTS", 7, 6475},
	{"ZKO", 3, 6476},
	{"ENEF", 4, 6477},
	{"NOWW", 4, 6478},
	{"PCS", 3, 6479},
	{"EMPLOYERS", 9, 6480},
	{"GREY", 4, 6481},
	{"PARALLEL", 8, 6482},
	{"ORWH", 4, 6483},
	{"HONDA", 5, 6484},
	{"FOREVER", 7, 6485},
	{"REGARD", 6, 6486},
	{"SSAY", 4, 6487},
	{"AMENDED", 7, 6488},
	{"BILLS", 5, 6489},
	{"ELLT", 4, 6490},
	{"HEPH", 4, 6491},
	{"ERGR", 4, 6492},
	{"JOURNALIST", 10, 6493},
	{"EMSE", 4, 6494},
	{"ONAB", 4, 6495},
	{"DEFINITIONS", 11, 6496},
	{"DOCTORS", 7, 6497},
	{"EFOL", 4, 6498},
	{"SIGNAL", 6, 6499},
	{"GKU", 3, 6500},
	{"XRU", 3, 6501},
	{"ESCE", 4, 6502},
	{"CINEMA", 6, 6503},
	{"COLUMN", 6, 6504},
	{"COMPARISON", 10, 6505},
	{"DISPLAY", 7, 6506},
	{"SLIDE", 5, 6507},
	{"ELECTIONS", 9, 6508},
	{"GRADUATE", 8, 6509},
	{"SILENT", 6, 6510},
	{"DZH", 3, 6511},
	{"YSAI", 4, 6512},
	{"RLDW", 4, 6513},
	{"OWNO", 4, 6514},
	{"UDES", 4, 6515},
	{"FICU", 4, 6516},
	{"INMO", 4, 6517},
	{"ENHANCED", 8, 6518},
	{"ENTITLED", 8, 6519},
	{"OMEP", 4, 6520},
	{"DONL", 4, 6521},
	{"STAINLESS", 9, 6522},
	{"NCIN", 4, 6523},
	{"ATME", 4, 6524},
	{"PERMIT", 6, 6525},
	{"NEWSPAPERS", 10, 6526},
	{"HOSPITALS", 9, 6527},
	{"ANYP", 4, 6528},
	{"NCEB", 4, 6529},
	{"ENBE", 4, 6530},
	{"AREW", 4, 6531},
	{"NSOR", 4, 6532},
	{"NSIB", 4, 6533},
	{"ARAB", 4, 6534},
	{"ZZS", 3, 6535},
	{"NABO", 4, 6536},
	{"DELUXE", 6, 6537},
	{"RLAN", 4, 6538},
	{"AYSI", 4, 6539},
	{"NVIR", 4, 6540},
	{"LTIN", 4, 6541},
	{"SWHA", 4, 6542},
	{"SELECTION", 9, 6543},
	{"PAYMENT", 7, 6544},
	{"AGED", 4, 6545},
	{"MONITORS", 8, 6546},
	{"LIVED", 5, 6547},
	{"DURATION", 8, 6548},
	{"HONOR", 5, 6549},
	{"BREAD", 5, 6550},
	{"DDIS", 4, 6551},
	{"WOQ", 3, 6552},
	{"DRAG", 4, 6553},
	{"INWI", 4, 6554},
	{"SSCO", 4, 6555},
	{"IALC", 4, 6556},
	{"ALLW", 4, 6557},
	{"INDONESIA", 9, 6558},
	{"SSAG", 4, 6559},
	{"PURSUANT", 8, 6560},
	{"CONSIST", 7, 6561},
	{"VISITS", 6, 6562},
	{"SINV", 4, 6563},
	{"DOMAINS", 7, 6564},
	{"WEAK", 4, 6565},
	{"CAPABILITIES", 12, 6566},
	{"EOFI", 4, 6567},
	{"PMID", 4, 6568},
	{"NGPE", 4, 6569},
	{"OFLI", 4, 6570},
	{"HELLO", 5, 6571},
	{"UNIVERSE", 8, 6572},
	{"RECRUITMENT", 11, 6573},
	{"GUAG", 4, 6574},
	{"BERLIN", 6, 6575},
	{"PRIORITY", 8, 6576},
	{"ULDA", 4, 6577},
	{"SUPPOSE", 7, 6578},
	{"OOPE", 4, 6579},
	{"RSPE", 4, 6580},
	{"LSOH", 4, 6581},
	{"LUCKY", 5, 6582},
	{"KEIT", 4, 6583},
	{"OFTW", 4, 6584},
	{"PTEM", 4, 6585},
	{"PLIE", 4, 6586},
	{"EDDE", 4, 6587},
	{"PARA", 4, 6588},
	{"SIEMENS", 7, 6589},
	{"ROOF", 4, 6590},
	{"OMEC", 4, 6591},
	{"IMPROVING", 9, 6592},
	{"KKU", 3, 6593},
	{"RTON", 4, 6594},
	{"TMAK", 4, 6595},
	{"CTOB", 4, 6596},
	{"NDDO", 4, 6597},
	{"WASW", 4, 6598},
	{"LAB", 3, 6599},
	{"ORRO", 4, 6600},
	{"ERLO", 4, 6601},
	{"MEANT", 5, 6602},
	{"POUNDS", 6, 6603},
	{"INAB", 4, 6604},
	{"EALW", 4, 6605},
	{"EZV", 3, 6606},
	{"BUFFALO", 7, 6607},
	{"ORGANISATIONS", 13, 6608},
	{"EXPLAINED", 9, 6609},
	{"RCED", 4, 6610},
	{"PROGRAMMES", 10, 6611},
	{"AGENDA", 6, 6612},
	{"INITIATIVE", 10, 6613},
	{"ETIR", 4, 6614},
	{"UPAN", 4, 6615},
	{"ATEV", 4, 6616},
	{"CAMPING", 7, 6617},
	{"PLANNING", 8, 6618},
	{"TDOE", 4, 6619},
	{"JEWELLERY", 9, 6620},
	{"MEETS", 5, 6621},
	{"ESUN", 4, 6622},
	{"CAUGHT", 6, 6623},
	{"CYY", 3, 6624},
	{"DESCRIPTION", 11, 6625},
	{"HOUSING", 7, 6626},
	{"URDE", 4, 6627},
	{"MARKED", 6, 6628},
	{"DRIVEN", 6, 6629},
	{"MEASURED", 8, 6630},
	{"MEDLINE", 7, 6631},
	{"ISLO", 4, 6632},
	{"AGREEMENTS", 10, 6633},
	{"CONSIDERING", 11, 6634},
	{"BUQ", 3, 6635},
	{"UGHI", 4, 6636},
	{"MARSHALL", 8, 6637},
	{"MASSAGE", 7, 6638},
	{"JIW", 3, 6639},
	{"NCEM", 4, 6640},
	{"ALLF", 4, 6641},
	{"THERAPY", 7, 6642},
	{"VESI", 4, 6643},
	{"CONSISTENT", 10, 6644},
	{"CLOSING", 7, 6645},
	{"TAMPA", 5, 6646},
	{"SSAR", 4, 6647},
	{"NDEA", 4, 6648},
	{"SUSAN", 5, 6649},
	{"LIBRARY", 7, 6650},
	{"WASH", 4, 6651},
	{"AREH", 4, 6652},
	{"ISWO", 4, 6653},
	{"ICIT", 4, 6654},
	{"ADAMS", 5, 6655},
	{"PRAYER", 6, 6656},
	{"OVES", 4, 6657},
	{"ENABLE", 6, 6658},
	{"PYTHON", 6, 6659},
	{"BEND", 4, 6660},
	{"YDD", 3, 6661},
	{"ALEX", 4, 6662},
	{"RVIE", 4, 6663},
	{"FUNDING", 7, 6664},
	{"NPER", 4, 6665},
	{"BANG", 4, 6666},
	{"EXPENSE", 7, 6667},
	{"EMAY", 4, 6668},
	{"NMOR", 4, 6669},
	{"CHILDHOOD", 9, 6670},
	{"VILLA", 5, 6671},
	{"TMAR", 4, 6672},
	{"EPAI", 4, 6673},
	{"COLUMNS", 7, 6674},
	{"DISORDERS", 9, 6675},
	{"MSOF", 4, 6676},
	{"RSFO", 4, 6677},
	{"BUGS", 4, 6678},
	{"LAYER", 5, 6679},
	{"MSAN", 4, 6680},
	{"HAMILTON", 8, 6681},
	{"DETECTION", 9, 6682},
	{"FTP", 3, 6683},
	{"MBLE", 4, 6684},
	{"FACTORY", 7, 6685},
	{"COOKIES", 7, 6686},
	{"DRAMATIC", 8, 6687},
	{"YSIC", 4, 6688},
	{"COP", 3, 6689},
	{"ARYT", 4, 6690},
	{"GAP", 3, 6691},
	{"TUTORIAL", 8, 6692},
	{"MED", 3, 6693},
	{"TLYA", 4, 6694},
	{"IZW", 3, 6695},
	{"EVALUATION", 10, 6696},
	{"ENGINEERS", 9, 6697},
	{"WARNING", 7, 6698},
	{"ARREST", 6, 6699},
	{"ISWH", 4, 6700},
	{"CRUISES", 7, 6701},
	{"HMAN", 4, 6702},
	{"SUSPECT", 7, 6703},
	{"EDRO", 4, 6704},
	{"TEFO", 4, 6705},
	{"LSOT", 4, 6706},
	{"HOLDER", 6, 6707},
	{"PROPOSALS", 9, 6708},
	{"MODERATOR", 9, 6709},
	{"SETTLEMENT", 10, 6710},
	{"TUTORIALS", 9, 6711},
	{"UYD", 3, 6712},
	{"MOREOVER", 8, 6713},
	{"CHIP", 4, 6714},
	{"YAFT", 4, 6715},
	{"PORTUGAL", 8, 6716},
	{"YSHE", 4, 6717},
	{"NDYO", 4, 6718},
	{"LAWRENCE", 8, 6719},
	{"TOFR", 4, 6720},
	{"OSTL", 4, 6721},
	{"TWAR", 4, 6722},
	{"RSOM", 4, 6723},
	{"EBEA", 4, 6724},
	{"OWTO", 4, 6725},
	{"KISS", 4, 6726},
	{"IMPLEMENT", 9, 6727},
	{"DUTIES", 6, 6728},
	{"MWIT", 4, 6729},
	{"EROTIC", 6, 6730},
	{"UHAV", 4, 6731},
	{"HEVA", 4, 6732},
	{"EBEG", 4, 6733},
	{"OMEF", 4, 6734},
	{"TWER", 4, 6735},
	{"COLLECTABLES", 12, 6736},
	{"FORMAL", 6, 6737},
	{"DRAGON", 6, 6738},
	{"UPPL", 4, 6739},
	{"PURCHASE", 8, 6740},
	{"RALO", 4, 6741},
	{"EMOTION", 7, 6742},
	{"BRINGS", 6, 6743},
	{"HEATING", 7, 6744},
	{"MSTO", 4, 6745},
	{"TRANSITION", 10, 6746},
	{"EDLI", 4, 6747},
	{"YSTO", 4, 6748},
	{"GOVERNMENTS", 11, 6749},
	{"PHASE", 5, 6750},
	{"PURCHASING", 10, 6751},
	{"SCRIPTS", 7, 6752},
	{"ABC", 3, 6753},
	{"STEREO", 6, 6754},
	{"APPOINTED", 9, 6755},
	{"COAT", 4, 6756},
	{"CHAMPIONSHIP", 12, 6757},
	{"GLANCE", 6, 6758},
	{"DEALING", 7, 6759},
	{"EEMS", 4, 6760},
	{"WIDELY", 6, 6761},
	{"SHALL", 5, 6762},
	{"BUTN", 4, 6763},
	{"OPERATIONAL", 11, 6764},
	{"AIRLINES", 8, 6765},
	{"DINF", 4, 6766},
	{"LIVECAM", 7, 6767},
	{"REMAINING", 9, 6768},
	{"JAY", 3, 6769},
	{"EERS", 4, 6770},
	{"SCHEDULE", 8, 6771},
	{"TEDL", 4, 6772},
	{"STEEL", 5, 6773},
	{"CKTH", 4, 6774},
	{"ERROR", 5, 6775},
	{"EXPOSURE", 8, 6776},
	{"ANYC", 4, 6777},
	{"TRIPS", 5, 6778},
	{"SIDES", 5, 6779},
	{"EDPO", 4, 6780},
	{"EXISTENCE", 9, 6781},
	{"TURNS", 5, 6782},
	{"CORRESPONDING", 13, 6783},
	{"ICEI", 4, 6784},
	{"DESCRIPTIONS", 12, 6785},
	{"CACHE", 5, 6786},
	{"NGPA", 4, 6787},
	{"TRYT", 4, 6788},
	{"CTOF", 4, 6789},
	{"ITHL", 4, 6790},
	{"TPRE", 4, 6791},
	{"ZZB", 3, 6792},
	{"EADD", 4, 6793},
	{"ANIMATION", 9, 6794},
	{"IECE", 4, 6795},
	{"ORACLE", 6, 6796},
	{"SAVING", 6, 6797},
	{"XPLO", 4, 6798},
	{"EFUN", 4, 6799},
	{"SUBSTANCE", 9, 6800},
	{"SAUCE", 5, 6801},
	{"MATTHEW", 7, 6802},
	{"UNABLE", 6, 6803},
	{"ERFU", 4, 6804},
	{"ERAI", 4, 6805},
	{"LEASE", 5, 6806},
	{"IGHB", 4, 6807},
	{"PRODUCTIONS", 11, 6808},
	{"AVIATION", 8, 6809},
	{"SYMPTOM", 7, 6810},
	{"HOBBIES", 7, 6811},
	{"RTNE", 4, 6812},
	{"ALCOHOL", 7, 6813},
	{"XQU", 3, 6814},
	{"BOTHER", 6, 6815},
	{"ALBUM", 5, 6816},
	{"ANWA", 4, 6817},
	{"ESUM", 4, 6818},
	{"REBU", 4, 6819},
	{"EXCESS", 6, 6820},
	{"REDUCTION", 9, 6821},
	{"DEEPLY", 6, 6822},
	{"ONLINE", 6, 6823},
	{"AGEI", 4, 6824},
	{"ROWT", 4, 6825},
	{"CONSOLE", 7, 6826},
	{"LAKE", 4, 6827},
	{"COMMANDS", 8, 6828},
	{"ONBU", 4, 6829},
	{"TERRITORY", 9, 6830},
	{"WEDDING", 7, 6831},
	{"CEMB", 4, 6832},
	{"VEMB", 4, 6833},
	{"TELECOMMUNICATIONS", 18, 6834},
	{"LCHA", 4, 6835},
	{"RDTH", 4, 6836},
	{"REAB", 4, 6837},
	{"TRANSFORM", 9, 6838},
	{"EYAN", 4, 6839},
	{"BREATHE", 7, 6840},
	{"ORUN", 4, 6841},
	{"ACHIEVED", 8, 6842},
	{"TABLESPOON", 10, 6843},
	{"OPPONENT", 8, 6844},
	{"RNOR", 4, 6845},
	{"INJURIES", 8, 6846},
	{"SHIPPED", 7, 6847},
	{"XPLA", 4, 6848},
	{"MINE", 4, 6849},
	{"YCHA", 4, 6850},
	{"KNIFE", 5, 6851},
	{"USPE", 4, 6852},
	{"SEATS", 5, 6853},
	{"NAPR", 4, 6854},
	{"APPROACHES", 10, 6855},
	{"BIZ", 3, 6856},
	{"RECOVER", 7, 6857},
	{"SSUP", 4, 6858},
	{"EVALUATE", 8, 6859},
	{"VOLTAGE", 7, 6860},
	{"ANTHONY", 7, 6861},
	{"CYCLE", 5, 6862},
	{"NINTENDO", 8, 6863},
	{"BRIEF", 5, 6864},
	{"TEASPOON", 8, 6865},
	{"LYWI", 4, 6866},
	{"OREH", 4, 6867},
	{"VIOLENT", 7, 6868},
	{"LOADING", 7, 6869},
	{"ORLE", 4, 6870},
	{"STAMPS", 6, 6871},
	{"APPEARED", 8, 6872},
	{"FRANKLIN", 8, 6873},
	{"TJUS", 4, 6874},
	{"NTSF", 4, 6875},
	{"DCOU", 4, 6876},
	{"PHILOSOPHY", 10, 6877},
	{"DTOL", 4, 6878},
	{"MANUFACTURER", 12, 6879},
	{"EAWA", 4, 6880},
	{"ROB", 3, 6881},
	{"DSPE", 4, 6882},
	{"VINYL", 5, 6883},
	{"TOFP", 4, 6884},
	{"HIGHLIGHTS", 10, 6885},
	{"OROU", 4, 6886},
	{"MINING", 6, 6887},
	{"COALITION", 9, 6888},
	{"DESIGNERS", 9, 6889},
	{"MELBOURNE", 9, 6890},
	{"YKH", 3, 6891},
	{"PASSAGE", 7, 6892},
	{"WORST", 5, 6893},
	{"FAIRLY", 6, 6894},
	{"GSAN", 4, 6895},
	{"CEWI", 4, 6896},
	{"POST", 4, 6897},
	{"ESSW", 4, 6898},
	{"JACKET", 6, 6899},
	{"AWV", 3, 6900},
	{"IMAGING", 7, 6901},
	{"RACIAL", 6, 6902},
	{"BETTING", 7, 6903},
	{"RESISTANCE", 10, 6904},
	{"RYZ", 3, 6905},
	{"DISCIPLINE", 10, 6906},
	{"SCIENTISTS", 10, 6907},
	{"RTSO", 4, 6908},
	{"NEGOTIATION", 11, 6909},
	{"PORTION", 7, 6910},
	{"WYOMING", 7, 6911},
	{"BLACKJACK", 9, 6912},
	{"ARGENTINA", 9, 6913},
	{"RDOF", 4, 6914},
	{"LEADING", 7, 6915},
	{"NOTC", 4, 6916},
	{"GRAND", 5, 6917},
	{"SAND", 4, 6918},
	{"DESERT", 6, 6919},
	{"ITCA", 4, 6920},
	{"LOWT", 4, 6921},
	{"INVOLVEMENT", 11, 6922},
	{"PRINT", 5, 6923},
	{"AYFO", 4, 6924},
	{"IVEM", 4, 6925},
	{"NSOU", 4, 6926},
	{"LOCK", 4, 6927},
	{"EHOM", 4, 6928},
	{"TENSION", 7, 6929},
	{"ZYB", 3, 6930},
	{"INTERPRETATION", 14, 6931},
	{"THONGS", 6, 6932},
	{"MEWI", 4, 6933},
	{"GCC", 3, 6934},
	{"IVEB", 4, 6935},
	{"DTOO", 4, 6936},
	{"OLID", 4, 6937},
	{"SEDF", 4, 6938},
	{"EALA", 4, 6939},
	{"ANALYZE", 7, 6940},
	{"VOLUNTEERS", 10, 6941},
	{"LPLA", 4, 6942},
	{"ATTACHMENT", 10, 6943},
	{"POTATO", 6, 6944},
	{"RINGTONE", 8, 6945},
	{"HEAG", 4, 6946},
	{"UZM", 3, 6947},
	{"OPPOSITE", 8, 6948},
	{"DDIN", 4, 6949},
	{"RLES", 4, 6950},
	{"FINLAND", 7, 6951},
	{"MORGAN", 6, 6952},
	{"DERIVED", 7, 6953},
	{"ONEM", 4, 6954},
	{"EENP", 4, 6955},
	{"EFIE", 4, 6956},
	{"YGH", 3, 6957},
	{"NSWH", 4, 6958},
	{"PRESERVE", 8, 6959},
	{"ORIENTED", 8, 6960},
	{"EAGLE", 5, 6961},
	{"DESKTOPS", 8, 6962},
	{"IGHL", 4, 6963},
	{"LSOB", 4, 6964},
	{"PANTS", 5, 6965},
	{"UTAL", 4, 6966},
	{"MEXICAN", 7, 6967},
	{"COLUMBUS", 8, 6968},
	{"SPANISH", 7, 6969},
	{"EGOI", 4, 6970},
	{"NBEC", 4, 6971},
	{"KSTO", 4, 6972},
	{"WORKSHOPS", 9, 6973},
	{"DTOF", 4, 6974},
	{"YMAN", 4, 6975},
	{"NDBR", 4, 6976},
	{"POSTAGE", 7, 6977},
	{"DUST", 4, 6978},
	{"EHAR", 4, 6979},
	{"REPRESENTED", 11, 6980},
	{"MORTGAGES", 9, 6981},
	{"DIAL", 4, 6982},
	{"RESPONSIBILITIES", 16, 6983},
	{"OYAL", 4, 6984},
	{"EDUCATOR", 8, 6985},
	{"JOINT", 5, 6986},
	{"GHBO", 4, 6987},
	{"COMIC", 5, 6988},
	{"ERPL", 4, 6989},
	{"ZYI", 3, 6990},
	{"EDOW", 4, 6991},
	{"NGCH", 4, 6992},
	{"IPPE", 4, 6993},
	{"YRG", 3, 6994},
	{"EDOE", 4, 6995},
	{"INVESTORS", 9, 6996},
	{"QUOTE", 5, 6997},
	{"NDUC", 4, 6998},
	{"NTOC", 4, 6999},
	{"USSE", 4, 7000},
	{"CROWN", 5, 7001},
	{"STREAM", 6, 7002},
	{"PAR", 3, 7003},
	{"ILLR", 4, 7004},
	{"AZIN", 4, 7005},
	{"UNDERGROUND", 11, 7006},
	{"ENHANCE", 7, 7007},
	{"RSZ", 3, 7008},
	{"EVEA", 4, 7009},
	{"EARB", 4, 7010},
	{"NUMEROUS", 8, 7011},
	{"JUICE", 5, 7012},
	{"ERSL", 4, 7013},
	{"NNOV", 4, 7014},
	{"WHISPER", 7, 7015},
	{"PICKS", 5, 7016},
	{"DUAT", 4, 7017},
	{"GENE", 4, 7018},
	{"VACATIONS", 9, 7019},
	{"YSIN", 4, 7020},
	{"AVEM", 4, 7021},
	{"YDM", 3, 7022},
	{"OFME", 4, 7023},
	{"SEMESTER", 8, 7024},
	{"CALCULATED", 10, 7025},
	{"ECIF", 4, 7026},
	{"WAJ", 3, 7027},
	{"DISCOVERY", 9, 7028},
	{"OWNF", 4, 7029},
	{"URVI", 4, 7030},
	{"FETISH", 6, 7031},
	{"SALE", 4, 7032},
	{"ELECT", 5, 7033},
	{"ENYO", 4, 7034},
	{"ALKE", 4, 7035},
	{"AKEI", 4, 7036},
	{"APPLIES", 7, 7037},
	{"EMPHASIS", 8, 7038},
	{"CASINOS", 7, 7039},
	{"YPEO", 4, 7040},
	{"ABANDON", 7, 7041},
	{"APACHE", 6, 7042},
	{"ATMOSPHERE", 10, 7043},
	{"STOU", 4, 7044},
	{"ERTR", 4, 7045},
	{"ITOF", 4, 7046},
	{"PRACTICAL", 9, 7047},
	{"NMAY", 4, 7048},
	{"FILTERS", 7, 7049},
	{"HEGU", 4, 7050},
	{"EWEL", 4, 7051},
	{"KSQ", 3, 7052},
	{"INCORPORATED", 12, 7053},
	{"IGIO", 4, 7054},
	{"JOKE", 4, 7055},
	{"OWST", 4, 7056},
	{"NOTEBOOKS", 9, 7057},
	{"FOUNDATION", 10, 7058},
	{"RESOLVE", 7, 7059},
	{"INDEPENDENCE", 12, 7060},
	{"MARKETING", 9, 7061},
	{"INVESTIGATOR", 12, 7062},
	{"ATRO", 4, 7063},
	{"ANMA", 4, 7064},
	{"ITHW", 4, 7065},
	{"PSYCHOLOGICAL", 13, 7066},
	{"DISTRIBUTION", 12, 7067},
	{"TSMA", 4, 7068},
	{"HATG", 4, 7069},
	{"ZZF", 3, 7070},
	{"HENW", 4, 7071},
	{"LTHI", 4, 7072},
	{"LOUNGE", 6, 7073},
	{"MWAS", 4, 7074},
	{"DOUBLE", 6, 7075},
	{"POSE", 4, 7076},
	{"ALGORITHM", 9, 7077},
	{"SEMI", 4, 7078},
	{"COINS", 5, 7079},
	{"RFUL", 4, 7080},
	{"SMELL", 5, 7081},
	{"ANDY", 4, 7082},
	{"RYCO", 4, 7083},
	{"CAFE", 4, 7084},
	{"FUNDAMENTAL", 11, 7085},
	{"ILLP", 4, 7086},
	{"VALENTINE", 9, 7087},
	{"HILTON", 6, 7088},
	{"LLIE", 4, 7089},
	{"ESWA", 4, 7090},
	{"NALY", 4, 7091},
	{"PROTEINS", 8, 7092},
	{"APPROXIMATELY", 13, 7093},
	{"PACK", 4, 7094},
	{"REYO", 4, 7095},
	{"SAGR", 4, 7096},
	{"EXP", 3, 7097},
	{"REEA", 4, 7098},
	{"TWOO", 4, 7099},
	{"DOUGLAS", 7, 7100},
	{"DEBIAN", 6, 7101},
	{"INVOLVING", 9, 7102},
	{"MISSILE", 7, 7103},
	{"SUICIDE", 7, 7104},
	{"TTOP", 4, 7105},
	{"INVESTING", 9, 7106},
	{"GWAS", 4, 7107},
	{"DLIK", 4, 7108},
	{"TOBR", 4, 7109},
	{"CHRISTOPHER", 11, 7110},
	{"LMAN", 4, 7111},
	{"AMAZING", 7, 7112},
	{"EPSON", 5, 7113},
	{"ULDE", 4, 7114},
	{"OBJECTIVE", 9, 7115},
	{"ELECTED", 7, 7116},
	{"CARRYING", 8, 7117},
	{"MADISON", 7, 7118},
	{"ESTW", 4, 7119},
	{"EOLD", 4, 7120},
	{"PREVIOUSLY", 10, 7121},
	{"ILLUSTRATE", 10, 7122},
	{"EDITIONS", 8, 7123},
	{"CPU", 3, 7124},
	{"NYEA", 4, 7125},
	{"NOWL", 4, 7126},
	{"TMON", 4, 7127},
	{"PARLIAMENT", 10, 7128},
	{"CHNI", 4, 7129},
	{"FINDS", 5, 7130},
	{"RESPONDENT", 10, 7131},
	{"ESTL", 4, 7132},
	{"ENFORCEMENT", 11, 7133},
	{"HENY", 4, 7134},
	{"SITUATIONS", 10, 7135},
	{"DIGITAL", 7, 7136},
	{"IRON", 4, 7137},
	{"RSDA", 4, 7138},
	{"ISDI", 4, 7139},
	{"ORTW", 4, 7140},
	{"ASGO", 4, 7141},
	{"BOOT", 4, 7142},
	{"ALLOCATED", 9, 7143},
	{"YINC", 4, 7144},
	{"EAMI", 4, 7145},
	{"HICL", 4, 7146},
	{"YNF", 3, 7147},
	{"ESSENTIALLY", 11, 7148},
	{"ZYO", 3, 7149},
	{"YYI", 3, 7150},
	{"CORRECTIONS", 11, 7151},
	{"DEFICIT", 7, 7152},
	{"GHIM", 4, 7153},
	{"TALE", 4, 7154},
	{"BEAN", 4, 7155},
	{"USHE", 4, 7156},
	{"DESCRIBES", 9, 7157},
	{"ZRI", 3, 7158},
	{"OCCURS", 6, 7159},
	{"DISABILITIES", 12, 7160},
	{"CONSISTS", 8, 7161},
	{"LLON", 4, 7162},
	{"RETIRE", 6, 7163},
	{"FCOU", 4, 7164},
	{"ANYTIME", 7, 7165},
	{"EATR", 4, 7166},
	{"TGET", 4, 7167},
	{"PROHIBITED", 10, 7168},
	{"PARKING", 7, 7169},
	{"LIES", 4, 7170},
	{"SPENDING", 8, 7171},
	{"DIMENSION", 9, 7172},
	{"SOLDIERS", 8, 7173},
	{"VOLUNTEER", 9, 7174},
	{"GUARDIAN", 8, 7175},
	{"VARY", 4, 7176},
	{"SIMULATION", 10, 7177},
	{"LAYOUT", 6, 7178},
	{"DESERVE", 7, 7179},
	{"COMPETITIVE", 11, 7180},
	{"CONGRESSIONAL", 13, 7181},
	{"INITIATIVES", 11, 7182},
	{"ERYE", 4, 7183},
	{"CLASSICS", 8, 7184},
	{"LBS", 3, 7185},
	{"RARELY", 6, 7186},
	{"NAFT", 4, 7187},
	{"OFLO", 4, 7188},
	{"HURS", 4, 7189},
	{"AWHI", 4, 7190},
	{"HORSES", 6, 7191},
	{"LOL", 3, 7192},
	{"URGE", 4, 7193},
	{"POVERTY", 7, 7194},
	{"PRIEST", 6, 7195},
	{"EWON", 4, 7196},
	{"ELSEWHERE", 9, 7197},
	{"EPAT", 4, 7198},
	{"WAYNE", 5, 7199},
	{"IMPOSE", 6, 7200},
	{"TAUGHT", 6, 7201},
	{"ASIAN", 5, 7202},
	{"EDCA", 4, 7203},
	{"TOMATO", 6, 7204},
	{"NGSU", 4, 7205},
	{"NTLE", 4, 7206},
	{"OPTIMIZATION", 12, 7207},
	{"GSTO", 4, 7208},
	{"MIXTURE", 7, 7209},
	{"NFAC", 4, 7210},
	{"ENGINEERING", 11, 7211},
	{"CREATURE", 8, 7212},
	{"ICEN", 4, 7213},
	{"EMPLOYER", 8, 7214},
	{"SUBSTANCES", 10, 7215},
	{"STLI", 4, 7216},
	{"WNIN", 4, 7217},
	{"DISCOVERED", 10, 7218},
	{"WINGS", 5, 7219},
	{"BREAKS", 6, 7220},
	{"RESTRICTIONS", 12, 7221},
	{"NDUN", 4, 7222},
	{"ESEP", 4, 7223},
	{"TTOD", 4, 7224},
	{"WAYF", 4, 7225},
	{"OFHO", 4, 7226},
	{"PARTICIPATING", 13, 7227},
	{"WATERS", 6, 7228},
	{"OKNO", 4, 7229},
	{"NDPL", 4, 7230},
	{"ESWO", 4, 7231},
	{"LYMA", 4, 7232},
	{"EROA", 4, 7233},
	{"XFU", 3, 7234},
	{"OCCASION", 8, 7235},
	{"IMPLICATION", 11, 7236},
	{"NANY", 4, 7237},
	{"OUTM", 4, 7238},
	{"MODEM", 5, 7239},
	{"ETRU", 4, 7240},
	{"ENMA", 4, 7241},
	{"DISORDER", 8, 7242},
	{"BUTTER", 6, 7243},
	{"HARRIS", 6, 7244},
	{"MPH", 3, 7245},
	{"ORDINARY", 8, 7246},
	{"OFRO", 4, 7247},
	{"BRINGING", 8, 7248},
	{"INSPIRE", 7, 7249},
	{"NDBU", 4, 7250},
	{"SCHI", 4, 7251},
	{"DOMINATE", 8, 7252},
	{"IESF", 4, 7253},
	{"TLYT", 4, 7254},
	{"DFIN", 4, 7255},
	{"NGME", 4, 7256},
	{"TIFFANY", 7, 7257},
	{"YHIS", 4, 7258},
	{"CEDB", 4, 7259},
	{"OSEL", 4, 7260},
	{"EBOT", 4, 7261},
	{"TOYOTA", 6, 7262},
	{"STREETS", 7, 7263},
	{"UTNO", 4, 7264},
	{"PEER", 4, 7265},
	{"VECTOR", 6, 7266},
	{"ILLNESS", 7, 7267},
	{"BATHROOM", 8, 7268},
	{"SHAVED", 6, 7269},
	{"TURNING", 7, 7270},
	{"BUFFER", 6, 7271},
	{"COMMENTARY", 10, 7272},
	{"LARRY", 5, 7273},
	{"LIMOUSINES", 10, 7274},
	{"ELAW", 4, 7275},
	{"DEVELOPMENTS", 12, 7276},
	{"CHCO", 4, 7277},
	{"DEF", 3, 7278},
	{"VISIBLE", 7, 7279},
	{"ARTN", 4, 7280},
	{"FZO", 3, 7281},
	{"DESTINATIONS", 12, 7282},
	{"TRANSFER", 8, 7283},
	{"LETS", 4, 7284},
	{"THROAT", 6, 7285},
	{"ZZT", 3, 7286},
	{"YMT", 3, 7287},
	{"PIPELINE", 8, 7288},
	{"CAP", 3, 7289},
	{"SEMB", 4, 7290},
	{"NESD", 4, 7291},
	{"LDWA", 4, 7292},
	{"KWIT", 4, 7293},
	{"MKU", 3, 7294},
	{"SYNTAX", 6, 7295},
	{"GENTLEMAN", 9, 7296},
	{"ADVANCE", 7, 7297},
	{"CHAIRS", 6, 7298},
	{"ENTRY", 5, 7299},
	{"LLYH", 4, 7300},
	{"IONL", 4, 7301},
	{"PASSION", 7, 7302},
	{"OURF", 4, 7303},
	{"TNER", 4, 7304},
	{"CTRI", 4, 7305},
	{"SDEA", 4, 7306},
	{"ONMO", 4, 7307},
	{"ZYW", 3, 7308},
	{"EBOA", 4, 7309},
	{"ENTERTAINMENT", 13, 7310},
	{"TWIN", 4, 7311},
	{"TOFM", 4, 7312},
	{"ZFE", 3, 7313},
	{"MOUNTAINS", 9, 7314},
	{"MOVES", 5, 7315},
	{"ELEF", 4, 7316},
	{"ETHERNET", 8, 7317},
	{"SYMBOL", 6, 7318},
	{"ERIV", 4, 7319},
	{"BOSS", 4, 7320},
	{"ELPE", 4, 7321},
	{"MAKER", 5, 7322},
	{"CHECKED", 7, 7323},
	{"NTOM", 4, 7324},
	{"INGV", 4, 7325},
	{"ABOV", 4, 7326},
	{"AINC", 4, 7327},
	{"INLO", 4, 7328},
	{"YDIS", 4, 7329},
	{"EDIR", 4, 7330},
	{"ADJUST", 6, 7331},
	{"NFIR", 4, 7332},
	{"SIERRA", 6, 7333},
	{"CATS", 4, 7334},
	{"ATTACH", 6, 7335},
	{"SHOCK", 5, 7336},
	{"COMPLAINT", 9, 7337},
	{"POSTPOSTED", 10, 7338},
	{"ONSB", 4, 7339},
	{"ROUND", 5, 7340},
	{"OLDEST", 6, 7341},
	{"RHODE", 5, 7342},
	{"TSFR", 4, 7343},
	{"XYO", 3, 7344},
	{"LBEA", 4, 7345},
	{"DSER", 4, 7346},
	{"SHEC", 4, 7347},
	{"LOFF", 4, 7348},
	{"ERBR", 4, 7349},
	{"IMMIGRATION", 11, 7350},
	{"PROSPECT", 8, 7351},
	{"MERCURY", 7, 7352},
	{"STEVEN", 6, 7353},
	{"LSOR", 4, 7354},
	{"NGLO", 4, 7355},
	{"TRANSPORTATION", 14, 7356},
	{"HANDBOOK", 8, 7357},
	{"OXG", 3, 7358},
	{"OFTR", 4, 7359},
	{"ARYO", 4, 7360},
	{"GREG", 4, 7361},
	{"NAVIGATE", 8, 7362},
	{"WORSE", 5, 7363},
	{"HABIT", 5, 7364},
	{"EXPA", 4, 7365},
	{"MONITOR", 7, 7366},
	{"CONVENTION", 10, 7367},
	{"VICTIMS", 7, 7368},
	{"TWOM", 4, 7369},
	{"REWO", 4, 7370},
	{"ENWI", 4, 7371},
	{"EDOR", 4, 7372},
	{"SPACES", 6, 7373},
	{"WHENEVER", 8, 7374},
	{"ONEP", 4, 7375},
	{"PEAK", 4, 7376},
	{"AYSH", 4, 7377},
	{"QWE", 3, 7378},
	{"ORPR", 4, 7379},
	{"HEJO", 4, 7380},
	{"MPLY", 4, 7381},
	{"STRONGLY", 8, 7382},
	{"ENWE", 4, 7383},
	{"COUPONS", 7, 7384},
	{"YTHR", 4, 7385},
	{"TWHA", 4, 7386},
	{"INTENSE", 7, 7387},
	{"KING", 4, 7388},
	{"CIALIS", 6, 7389},
	{"NCZ", 3, 7390},
	{"VIW", 3, 7391},
	{"NGOV", 4, 7392},
	{"BOATS", 5, 7393},
	{"DZU", 3, 7394},
	{"RSAG", 4, 7395},
	{"COMMANDER", 9, 7396},
	{"SBOR", 4, 7397},
	{"IZB", 3, 7398},
	{"ECHE", 4, 7399},
	{"NEDF", 4, 7400},
	{"VESE", 4, 7401},
	{"ARRANGEMENT", 11, 7402},
	{"SCOTTISH", 8, 7403},
	{"BREAKFAST", 9, 7404},
	{"SOFO", 4, 7405},
	{"EARR", 4, 7406},
	{"OINC", 4, 7407},
	{"EQUALLY", 7, 7408},
	{"RRIS", 4, 7409},
	{"OFNE", 4, 7410},
	{"ARCADE", 6, 7411},
	{"RICHMOND", 8, 7412},
	{"SACRAMENTO", 10, 7413},
	{"EYCO", 4, 7414},
	{"ONAP", 4, 7415},
	{"TONC", 4, 7416},
	{"COMMISSION", 10, 7417},
	{"RUSSELL", 7, 7418},
	{"TELLS", 5, 7419},
	{"VETERAN", 7, 7420},
	{"OOKT", 4, 7421},
	{"GHTL", 4, 7422},
	{"NHAD", 4, 7423},
	{"DALO", 4, 7424},
	{"GRAPH", 5, 7425},
	{"COVERING", 8, 7426},
	{"OFBE", 4, 7427},
	{"DDEN", 4, 7428},
	{"SPOK", 4, 7429},
	{"ALME", 4, 7430},
	{"ZAV", 3, 7431},
	{"EMPE", 4, 7432},
	{"PLATINUM", 8, 7433},
	{"UYR", 3, 7434},
	{"BEDROOMS", 8, 7435},
	{"SMOKE", 5, 7436},
	{"ACCOMPLISH", 10, 7437},
	{"TALKS", 5, 7438},
	{"ELEB", 4, 7439},
	{"YLEA", 4, 7440},
	{"FILING", 6, 7441},
	{"EAKE", 4, 7442},
	{"SWING", 5, 7443},
	{"STWI", 4, 7444},
	{"MODELING", 8, 7445},
	{"TOFE", 4, 7446},
	{"PEDT", 4, 7447},
	{"USUAL", 5, 7448},
	{"AWARDED", 7, 7449},
	{"TESTIMONIALS", 12, 7450},
	{"SDEC", 4, 7451},
	{"SOFE", 4, 7452},
	{"TRIALS", 6, 7453},
	{"RFIR", 4, 7454},
	{"MEMORABILIA", 11, 7455},
	{"TOSP", 4, 7456},
	{"CLINTON", 7, 7457},
	{"MASTERS", 7, 7458},
	{"RENG", 4, 7459},
	{"BONDS", 5, 7460},
	{"INBE", 4, 7461},
	{"NCIE", 4, 7462},
	{"ZMU", 3, 7463},
	{"INLY", 4, 7464},
	{"VEOF", 4, 7465},
	{"EBEI", 4, 7466},
	{"TOAP", 4, 7467},
	{"CARTRIDGE", 9, 7468},
	{"ALBERTA", 7, 7469},
	{"RTIM", 4, 7470},
	{"RECOGNITION", 11, 7471},
	{"UGHS", 4, 7472},
	{"ANGER", 5, 7473},
	{"HAEL", 4, 7474},
	{"ORG", 3, 7475},
	{"ORHO", 4, 7476},
	{"CRUCIAL", 7, 7477},
	{"CONSTRUCT", 9, 7478},
	{"NIQU", 4, 7479},
	{"COMMONS", 7, 7480},
	{"CINCINNATI", 10, 7481},
	{"EENR", 4, 7482},
	{"SUBSECTION", 10, 7483},
	{"RSEC", 4, 7484},
	{"MOOD", 4, 7485},
	{"LYOU", 4, 7486},
	{"LLAT", 4, 7487},
	{"PERMITTED", 9, 7488},
	{"RAIG", 4, 7489},
	{"RNEY", 4, 7490},
	{"NOWH", 4, 7491},
	{"MYSTERY", 7, 7492},
	{"DESIGNER", 8, 7493},
	{"POTTERY", 7, 7494},
	{"CKSA", 4, 7495},
	{"UTAT", 4, 7496},
	{"ENCI", 4, 7497},
	{"ROGER", 5, 7498},
	{"AWESOME", 7, 7499},
	{"DISABILITY", 10, 7500},
	{"MSTH", 4, 7501},
	{"EFOO", 4, 7502},
	{"LUCK", 4, 7503},
	{"CONFIRMED", 9, 7504},
	{"SKNO", 4, 7505},
	{"COUNTS", 6, 7506},
	{"PRICED", 6, 7507},
	{"NTWH", 4, 7508},
	{"WALLPAPERS", 10, 7509},
	{"YYU", 3, 7510},
	{"CRITERIA", 8, 7511},
	{"CONCENTRATE", 11, 7512},
	{"TZF", 3, 7513},
	{"SMOOTH", 6, 7514},
	{"IVEW", 4, 7515},
	{"WASU", 4, 7516},
	{"SOFD", 4, 7517},
	{"TBAC", 4, 7518},
	{"ISGO", 4, 7519},
	{"DESIRED", 7, 7520},
	{"EXCEPTION", 9, 7521},
	{"DYY", 3, 7522},
	{"IMEO", 4, 7523},
	{"WHOC", 4, 7524},
	{"INTER", 5, 7525},
	{"QCO", 3, 7526},
	{"ETBA", 4, 7527},
	{"NERVOUS", 7, 7528},
	{"TDOW", 4, 7529},
	{"PERSONNEL", 9, 7530},
	{"NCEL", 4, 7531},
	{"ASSUMES", 7, 7532},
	{"HOLY", 4, 7533},
	{"ANXIETY", 7, 7534},
	{"PHENOMENON", 10, 7535},
	{"NDGR", 4, 7536},
	{"HEIGHTS", 7, 7537},
	{"DSHA", 4, 7538},
	{"EPTH", 4, 7539},
	{"RIDING", 6, 7540},
	{"CONSTANT", 8, 7541},
	{"EZG", 3, 7542},
	{"OFSU", 4, 7543},
	{"SO-CALLED", 9, 7544},
	{"FIREFOX", 7, 7545},
	{"SAYT", 4, 7546},
	{"LISA", 4, 7547},
	{"ENWH", 4, 7548},
	{"ADMINISTRATOR", 13, 7549},
	{"ELECTRONIC", 10, 7550},
	{"GROVE", 5, 7551},
	{"ELIGIBILITY", 11, 7552},
	{"CONSIDERATION", 13, 7553},
	{"YWOR", 4, 7554},
	{"PUBLICATION", 11, 7555},
	{"PROTEIN", 7, 7556},
	{"NDTA", 4, 7557},
	{"HEALING", 7, 7558},
	{"PRINCESS", 8, 7559},
	{"SILVER", 6, 7560},
	{"ISOR", 4, 7561},
	{"HEJU", 4, 7562},
	{"ICHC", 4, 7563},
	{"BURY", 4, 7564},
	{"ENTERING", 8, 7565},
	{"LYWO", 4, 7566},
	{"ALLY", 4, 7567},
	{"PACKET", 6, 7568},
	{"COMMAND", 7, 7569},
	{"NGFI", 4, 7570},
	{"ULDT", 4, 7571},
	{"CLINIC", 6, 7572},
	{"NSLA", 4, 7573},
	{"ANYM", 4, 7574},
	{"PALESTINIAN", 11, 7575},
	{"STUDIOS", 7, 7576},
	{"ERSR", 4, 7577},
	{"LTRA", 4, 7578},
	{"PRAY", 4, 7579},
	{"RNIA", 4, 7580},
	{"OSTC", 4, 7581},
	{"ELOO", 4, 7582},
	{"BUTTONS", 7, 7583},
	{"WEDT", 4, 7584},
	{"EDAG", 4, 7585},
	{"EXHIBITION", 10, 7586},
	{"OBSERVATIONS", 12, 7587},
	{"ITYF", 4, 7588},
	{"DITW", 4, 7589},
	{"OFWA", 4, 7590},
	{"ROFA", 4, 7591},
	{"VBULLETIN", 9, 7592},
	{"SUPPORTER", 9, 7593},
	{"FUNDED", 6, 7594},
	{"THOMPSON", 8, 7595},
	{"WINNERS", 7, 7596},
	{"HEAVILY", 7, 7597},
	{"RETIREMENT", 10, 7598},
	{"ROADS", 5, 7599},
	{"STPR", 4, 7600},
	{"MOON", 4, 7601},
	{"DUBLIN", 6, 7602},
	{"FELL", 4, 7603},
	{"MOTORCYCLE", 10, 7604},
	{"TOWER", 5, 7605},
	{"DISCLOSURE", 10, 7606},
	{"EDPE", 4, 7607},
	{"YPIC", 4, 7608},
	{"CAPABLE", 7, 7609},
	{"MEMORIES", 8, 7610},
	{"RTIE", 4, 7611},
	{"NELSON", 6, 7612},
	{"PRISONER", 8, 7613},
	{"IGNS", 4, 7614},
	{"RVIV", 4, 7615},
	{"CREATES", 7, 7616},
	{"FACES", 5, 7617},
	{"STPA", 4, 7618},
	{"YREA", 4, 7619},
	{"NIMP", 4, 7620},
	{"STLY", 4, 7621},
	{"STWA", 4, 7622},
	{"SURELY", 6, 7623},
	{"MAYOR", 5, 7624},
	{"OVY", 3, 7625},
	{"NGDI", 4, 7626},
	{"ONEL", 4, 7627},
	{"TOURIST", 7, 7628},
	{"EMST", 4, 7629},
	{"PRESENTATIONS", 13, 7630},
	{"GRADES", 6, 7631},
	{"SALARY", 6, 7632},
	{"TILI", 4, 7633},
	{"CARTOONS", 8, 7634},
	{"EATL", 4, 7635},
	{"LUSI", 4, 7636},
	{"DIVERSITY", 9, 7637},
	{"DIGEST", 6, 7638},
	{"REG", 3, 7639},
	{"LODGING", 7, 7640},
	{"REUN", 4, 7641},
	{"ATOU", 4, 7642},
	{"WIKI", 4, 7643},
	{"CHHE", 4, 7644},
	{"REPLACED", 8, 7645},
	{"THOD", 4, 7646},
	{"DDOW", 4, 7647},
	{"NFIN", 4, 7648},
	{"ONJU", 4, 7649},
	{"PINK", 4, 7650},
	{"OLDA", 4, 7651},
	{"STOMACH", 7, 7652},
	{"EDNO", 4, 7653},
	{"EDUR", 4, 7654},
	{"YONT", 4, 7655},
	{"REDUCING", 8, 7656},
	{"RECIPE", 6, 7657},
	{"KEND", 4, 7658},
	{"STOPPED", 7, 7659},
	{"DHAD", 4, 7660},
	{"ELEMENTARY", 10, 7661},
	{"NALM", 4, 7662},
	{"BELT", 4, 7663},
	{"LAKES", 5, 7664},
	{"NEARBY", 6, 7665},
	{"ALWI", 4, 7666},
	{"DONATIONS", 9, 7667},
	{"ASSOCIATIONS", 12, 7668},
	{"CITYSEARCH", 10, 7669},
	{"OBSERVER", 8, 7670},
	{"TERRORISM", 9, 7671},
	{"EFLE", 4, 7672},
	{"ESSAY", 5, 7673},
	{"JUNIOR", 6, 7674},
	{"LATIN", 5, 7675},
	{"KINGS", 5, 7676},
	{"OMUC", 4, 7677},
	{"DAYI", 4, 7678},
	{"NTOU", 4, 7679},
	{"GISL", 4, 7680},
	{"VENS", 4, 7681},
	{"RLYS", 4, 7682},
	{"KENT", 4, 7683},
	{"NGWO", 4, 7684},
	{"ONION", 5, 7685},
	{"EDSI", 4, 7686},
	{"TTOC", 4, 7687},
	{"ADDS", 4, 7688},
	{"ZME", 3, 7689},
	{"CONFRONT", 8, 7690},
	{"MM-HMM", 6, 7691},
	{"FLAGS", 5, 7692},
	{"LRES", 4, 7693},
	{"OUDO", 4, 7694},
	{"PCI", 3, 7695},
	{"BAKER", 5, 7696},
	{"LAUNCHED", 8, 7697},
	{"STMO", 4, 7698},
	{"TBET", 4, 7699},
	{"CORN", 4, 7700},
	{"SFAT", 4, 7701},
	{"GUESTBOOK", 9, 7702},
	{"OYEA", 4, 7703},
	{"LZI", 3, 7704},
	{"CROP", 4, 7705},
	{"SOFB", 4, 7706},
	{"CKLE", 4, 7707},
	{"TESTING", 7, 7708},
	{"WALLS", 5, 7709},
	{"EBONY", 5, 7710},
	{"RWIL", 4, 7711},
	{"WARD", 4, 7712},
	{"EPEA", 4, 7713},
	{"DRAWN", 5, 7714},
	{"ARTHUR", 6, 7715},
	{"UKY", 3, 7716},
	{"WLX", 3, 7717},
	{"POEM", 4, 7718},
	{"VISITED", 7, 7719},
	{"WALKER", 6, 7720},
	{"PTUR", 4, 7721},
	{"ITSB", 4, 7722},
	{"BUCK", 4, 7723},
	{"SUGGESTS", 8, 7724},
	{"INMI", 4, 7725},
	{"REPUTATION", 10, 7726},
	{"AMEF", 4, 7727},
	{"OURM", 4, 7728},
	{"VBU", 3, 7729},
	{"UNNE", 4, 7730},
	{"EMPLOYMENT", 10, 7731},
	{"OPERATED", 8, 7732},
	{"TROO", 4, 7733},
	{"PURE", 4, 7734},
	{"PERFECTLY", 9, 7735},
	{"EEFF", 4, 7736},
	{"GRANDMOTHER", 11, 7737},
	{"ACCOMPANY", 9, 7738},
	{"TARGETS", 7, 7739},
	{"RALC", 4, 7740},
	{"ESSM", 4, 7741},
	{"OVERSEAS", 8, 7742},
	{"INBO", 4, 7743},
	{"PURCHASES", 9, 7744},
	{"DODGE", 5, 7745},
	{"OWHA", 4, 7746},
	{"FEDERATION", 10, 7747},
	{"FLAG", 4, 7748},
	{"ORIGIN", 6, 7749},
	{"INVITED", 7, 7750},
	{"CONSULTANT", 10, 7751},
	{"KTHA", 4, 7752},
	{"INJA", 4, 7753},
	{"DIG", 3, 7754},
	{"EDLA", 4, 7755},
	{"IEDI", 4, 7756},
	{"ESDE", 4, 7757},
	{"YARDS", 5, 7758},
	{"KUY", 3, 7759},
	{"SDUR", 4, 7760},
	{"TEENAGER", 8, 7761},
	{"FIBER", 5, 7762},
	{"CHEMICALS", 9, 7763},
	{"GTOA", 4, 7764},
	{"ASTF", 4, 7765},
	{"JOURNEY", 7, 7766},
	{"ABSENCE", 7, 7767},
	{"GORDON", 6, 7768},
	{"MOD", 3, 7769},
	{"FARMERS", 7, 7770},
	{"HASM", 4, 7771},
	{"CLINICAL", 8, 7772},
	{"TBEA", 4, 7773},
	{"EOFW", 4, 7774},
	{"QUERIES", 7, 7775},
	{"LLYF", 4, 7776},
	{"BMW", 3, 7777},
	{"FELLOW", 6, 7778},
	{"ICRO", 4, 7779},
	{"INSTALL", 7, 7780},
	{"CKQ", 3, 7781},
	{"UKRAINE", 7, 7782},
	{"OBIL", 4, 7783},
	{"TYIS", 4, 7784},
	{"DCAN", 4, 7785},
	{"NEAREST", 7, 7786},
	{"VENDORS", 7, 7787},
	{"MPEG", 4, 7788},
	{"YOGA", 4, 7789},
	{"RNOT", 4, 7790},
	{"SERVES", 6, 7791},
	{"SMUC", 4, 7792},
	{"AKEO", 4, 7793},
	{"PREPARATION", 11, 7794},
	{"GYOU", 4, 7795},
	{"WOODS", 5, 7796},
	{"RSFR", 4, 7797},
	{"INNER", 5, 7798},
	{"RICO", 4, 7799},
	{"DBAC", 4, 7800},
	{"SHOPPERS", 8, 7801},
	{"ENTERPRISE", 10, 7802},
	{"RVES", 4, 7803},
	{"YOTH", 4, 7804},
	{"RELATIVE", 8, 7805},
	{"ULDC", 4, 7806},
	{"PHIL", 4, 7807},
	{"HESW", 4, 7808},
	{"TNOW", 4, 7809},
	{"HMEN", 4, 7810},
	{"COUPLES", 7, 7811},
	{"NASHVILLE", 9, 7812},
	{"EACO", 4, 7813},
	{"EPOW", 4, 7814},
	{"RANKING", 7, 7815},
	{"JOKES", 5, 7816},
	{"WOODEN", 6, 7817},
	{"TDIS", 4, 7818},
	{"COAST", 5, 7819},
	{"HTTP", 4, 7820},
	{"SIMPSON", 7, 7821},
	{"DDRE", 4, 7822},
	{"HISTORIC", 8, 7823},
	{"TOCR", 4, 7824},
	{"TWIKI", 5, 7825},
	{"OMPR", 4, 7826},
	{"HHER", 4, 7827},
	{"QUIETLY", 7, 7828},
	{"UXC", 3, 7829},
	{"JIV", 3, 7830},
	{"SUBLIME", 7, 7831},
	{"NDAB", 4, 7832},
	{"SATISFIED", 9, 7833},
	{"CANP", 4, 7834},
	{"ANKI", 4, 7835},
	{"WINS", 4, 7836},
	{"XYS", 3, 7837},
	{"EHEW", 4, 7838},
	{"UPWI", 4, 7839},
	{"LLSE", 4, 7840},
	{"ULLE", 4, 7841},
	{"NDGE", 4, 7842},
	{"ONEB", 4, 7843},
	{"BEAB", 4, 7844},
	{"HYJ", 3, 7845},
	{"EXV", 3, 7846},
	{"VIEWER", 6, 7847},
	{"MEASUREMENTS", 12, 7848},
	{"VERIFY", 6, 7849},
	{"FTJ", 3, 7850},
	{"AKV", 3, 7851},
	{"TRUSTED", 7, 7852},
	{"COPPER", 6, 7853},
	{"OMEM", 4, 7854},
	{"MILWAUKEE", 9, 7855},
	{"RYST", 4, 7856},
	{"EMAK", 4, 7857},
	{"MSIN", 4, 7858},
	{"HISTORIAN", 9, 7859},
	{"SHAREWARE", 9, 7860},
	{"APPARENT", 8, 7861},
	{"ASSUMPTION", 10, 7862},
	{"NGYO", 4, 7863},
	{"GHTN", 4, 7864},
	{"URSD", 4, 7865},
	{"NTPR", 4, 7866},
	{"REP", 3, 7867},
	{"DICKE", 5, 7868},
	{"KERRY", 5, 7869},
	{"LITERALLY", 9, 7870},
	{"RECEIPT", 7, 7871},
	{"URNT", 4, 7872},
	{"OHER", 4, 7873},
	{"STUR", 4, 7874},
	{"ESTF", 4, 7875},
	{"CHEEK", 5, 7876},
	{"RUAR", 4, 7877},
	{"GHES", 4, 7878},
	{"LYSI", 4, 7879},
	{"GZE", 3, 7880},
	{"PERMANENT", 9, 7881},
	{"NDAF", 4, 7882},
	{"IALT", 4, 7883},
	{"INGREDIENT", 10, 7884},
	{"OFAP", 4, 7885},
	{"NGNE", 4, 7886},
	{"YPRE", 4, 7887},
	{"YNR", 3, 7888},
	{"DRAWING", 7, 7889},
	{"CONFIGURE", 9, 7890},
	{"SUBSTANTIAL", 11, 7891},
	{"EFIG", 4, 7892},
	{"SMEN", 4, 7893},
	{"TUBE", 4, 7894},
	{"SNAP", 4, 7895},
	{"SDEF", 4, 7896},
	{"BUTO", 4, 7897},
	{"APPLYING", 8, 7898},
	{"OVG", 3, 7899},
	{"RALT", 4, 7900},
	{"ARISE", 5, 7901},
	{"YPAR", 4, 7902},
	{"SSIG", 4, 7903},
	{"EXPECTATIONS", 12, 7904},
	{"ARKI", 4, 7905},
	{"OWWH", 4, 7906},
	{"CAKE", 4, 7907},
	{"RESIST", 6, 7908},
	{"KNOWING", 7, 7909},
	{"ZIZ", 3, 7910},
	{"OVEL", 4, 7911},
	{"NGSW", 4, 7912},
	{"LICY", 4, 7913},
	{"JAIL", 4, 7914},
	{"ISLAMIC", 7, 7915},
	{"ZYG", 3, 7916},
	{"NDGO", 4, 7917},
	{"RKAN", 4, 7918},
	{"OCCASIONALLY", 12, 7919},
	{"BRUA", 4, 7920},
	{"ISUS", 4, 7921},
	{"REDH", 4, 7922},
	{"METABOLISM", 10, 7923},
	{"KEITH", 5, 7924},
	{"INCORPORATE", 11, 7925},
	{"OODT", 4, 7926},
	{"ECRO", 4, 7927},
	{"CLOUDY", 6, 7928},
	{"LINDA", 5, 7929},
	{"LLFO", 4, 7930},
	{"HCON", 4, 7931},
	{"OURB", 4, 7932},
	{"ROSS", 4, 7933},
	{"CHILE", 5, 7934},
	{"TTOG", 4, 7935},
	{"SOLO", 4, 7936},
	{"REWH", 4, 7937},
	{"CYV", 3, 7938},
	{"EFFECTIVELY", 11, 7939},
	{"DARKNESS", 8, 7940},
	{"LENC", 4, 7941},
	{"MARIA", 5, 7942},
	{"CONCERT", 7, 7943},
	{"ASDI", 4, 7944},
	{"IMEW", 4, 7945},
	{"LLMA", 4, 7946},
	{"EXCELLENCE", 10, 7947},
	{"PROVISION", 9, 7948},
	{"NALR", 4, 7949},
	{"ADEI", 4, 7950},
	{"UNLIKE", 6, 7951},
	{"TUW", 3, 7952},
	{"AYFR", 4, 7953},
	{"TIZE", 4, 7954},
	{"URPO", 4, 7955},
	{"OUAR", 4, 7956},
	{"FAVOR", 5, 7957},
	{"SAPR", 4, 7958},
	{"BIOLOGICAL", 10, 7959},
	{"ECTL", 4, 7960},
	{"ATTRIBUTES", 10, 7961},
	{"BRASS", 5, 7962},
	{"SASW", 4, 7963},
	{"NGTI", 4, 7964},
	{"EWEE", 4, 7965},
	{"HEHU", 4, 7966},
	{"STPO", 4, 7967},
	{"SENC", 4, 7968},
	{"CONVENTIONAL", 12, 7969},
	{"ULZ", 3, 7970},
	{"INTENTION", 9, 7971},
	{"WRITES", 6, 7972},
	{"PLAZA", 5, 7973},
	{"KSIN", 4, 7974},
	{"ZIW", 3, 7975},
	{"YVS", 3, 7976},
	{"DTOE", 4, 7977},
	{"PDAS", 4, 7978},
	{"EKEN", 4, 7979},
	{"OUTCOMES", 8, 7980},
	{"ESLA", 4, 7981},
	{"INGJ", 4, 7982},
	{"IALP", 4, 7983},
	{"AGGRESSIVE", 10, 7984},
	{"NEVERTHELESS", 12, 7985},
	{"EMBRACE", 7, 7986},
	{"SECURE", 6, 7987},
	{"LLNO", 4, 7988},
	{"THUMBNAIL", 9, 7989},
	{"TRANS", 5, 7990},
	{"EARW", 4, 7991},
	{"EGOO", 4, 7992},
	{"DEVELOPING", 10, 7993},
	{"JONATHAN", 8, 7994},
	{"NOVA", 4, 7995},
	{"NDSW", 4, 7996},
	{"SSOU", 4, 7997},
	{"SGRE", 4, 7998},
	{"RSEN", 4, 7999},
	{"BOOTY", 5, 8000},
	{"TREP", 4, 8001},
	{"NALB", 4, 8002},
	{"FIFTH", 5, 8003},
	{"UTILITY", 7, 8004},
	{"FORGOTTEN", 9, 8005},
	{"ACROBAT", 7, 8006},
	{"MUSLIM", 6, 8007},
	{"IXV", 3, 8008},
	{"SUGGESTION", 10, 8009},
	{"PLATES", 6, 8010},
	{"ACRES", 5, 8011},
	{"LESW", 4, 8012},
	{"VENUE", 5, 8013},
	{"DCHI", 4, 8014},
	{"NREA", 4, 8015},
	{"DOFA", 4, 8016},
	{"YELL", 4, 8017},
	{"REASONABLE", 10, 8018},
	{"EDHO", 4, 8019},
	{"PURC", 4, 8020},
	{"POP", 3, 8021},
	{"THERMAL", 7, 8022},
	{"ESSAYS", 6, 8023},
	{"IVEF", 4, 8024},
	{"NGTR", 4, 8025},
	{"SENSITIVE", 9, 8026},
	{"BEHAVIOUR", 9, 8027},
	{"YTOS", 4, 8028},
	{"BIND", 4, 8029},
	{"RSER", 4, 8030},
	{"LGY", 3, 8031},
	{"OUSS", 4, 8032},
	{"LBER", 4, 8033},
	{"BRAND", 5, 8034},
	{"LYPR", 4, 8035},
	{"DFOU", 4, 8036},
	{"RTTO", 4, 8037},
	{"HIEV", 4, 8038},
	{"TELLING", 7, 8039},
	{"VGU", 3, 8040},
	{"SOFW", 4, 8041},
	{"NDEM", 4, 8042},
	{"CONFIG", 6, 8043},
	{"SABL", 4, 8044},
	{"YYEA", 4, 8045},
	{"EDINBURGH", 9, 8046},
	{"NCHO", 4, 8047},
	{"EXCEL", 5, 8048},
	{"OLYMPIC", 7, 8049},
	{"MODES", 5, 8050},
	{"RAPIDLY", 7, 8051},
	{"LLIT", 4, 8052},
	{"EXTREME", 7, 8053},
	{"CAMPBELL", 8, 8054},
	{"HARBOR", 6, 8055},
	{"SSUM", 4, 8056},
	{"HUNGARY", 7, 8057},
	{"BLEO", 4, 8058},
	{"WEIGH", 5, 8059},
	{"URW", 3, 8060},
	{"ONAC", 4, 8061},
	{"QUIT", 4, 8062},
	{"ALLM", 4, 8063},
	{"NEGOTIATE", 9, 8064},
	{"SMUS", 4, 8065},
	{"SPECIALIST", 10, 8066},
	{"CONSTANTLY", 10, 8067},
	{"WAGE", 4, 8068},
	{"RALD", 4, 8069},
	{"EMOD", 4, 8070},
	{"OSUR", 4, 8071},
	{"RISING", 6, 8072},
	{"EIRL", 4, 8073},
	{"WELLS", 5, 8074},
	{"ASFI", 4, 8075},
	{"NALF", 4, 8076},
	{"WISHLIST", 8, 8077},
	{"OPENS", 5, 8078},
	{"REFUGEE", 7, 8079},
	{"LLAL", 4, 8080},
	{"EBOU", 4, 8081},
	{"VEFO", 4, 8082},
	{"GSTA", 4, 8083},
	{"RESTRICTED", 10, 8084},
	{"SECRETS", 7, 8085},
	{"DEALER", 6, 8086},
	{"EDSH", 4, 8087},
	{"ORID", 4, 8088},
	{"UMJ", 3, 8089},
	{"ENMO", 4, 8090},
	{"MERCHANTS", 9, 8091},
	{"UTTI", 4, 8092},
	{"OFTO", 4, 8093},
	{"YSAN", 4, 8094},
	{"DBYS", 4, 8095},
	{"TRAILERS", 8, 8096},
	{"ASEB", 4, 8097},
	{"HYK", 3, 8098},
	{"DEPUTY", 6, 8099},
	{"PHILIPS", 7, 8100},
	{"ZZC", 3, 8101},
	{"SCLO", 4, 8102},
	{"ARMED", 5, 8103},
	{"GIANT", 5, 8104},
	{"NSCH", 4, 8105},
	{"TEXP", 4, 8106},
	{"GLASSES", 7, 8107},
	{"SHELL", 5, 8108},
	{"ENABLES", 7, 8109},
	{"RREA", 4, 8110},
	{"NNUA", 4, 8111},
	{"GSIN", 4, 8112},
	{"IGJ", 3, 8113},
	{"TMAY", 4, 8114},
	{"MECHANISM", 9, 8115},
	{"NCOR", 4, 8116},
	{"NTOD", 4, 8117},
	{"LYWA", 4, 8118},
	{"XCEP", 4, 8119},
	{"VISTA", 5, 8120},
	{"ORPE", 4, 8121},
	{"KOUT", 4, 8122},
	{"JESSICA", 7, 8123},
	{"CHIPS", 5, 8124},
	{"TERRY", 5, 8125},
	{"FOTO", 4, 8126},
	{"DEPTH", 5, 8127},
	{"ARGUMENTS", 9, 8128},
	{"EWEA", 4, 8129},
	{"AMSTERDAM", 9, 8130},
	{"TYFO", 4, 8131},
	{"RSMA", 4, 8132},
	{"ADVENTURES", 10, 8133},
	{"HONEST", 6, 8134},
	{"REEX", 4, 8135},
	{"FPRO", 4, 8136},
	{"CRITICIZE", 9, 8137},
	{"YUW", 3, 8138},
	{"PUPILS", 6, 8139},
	{"STEWART", 7, 8140},
	{"TABS", 4, 8141},
	{"MAD", 3, 8142},
	{"NDBO", 4, 8143},
	{"EEDO", 4, 8144},
	{"FLAT", 4, 8145},
	{"DSAI", 4, 8146},
	{"OFDI", 4, 8147},
	{"PACE", 4, 8148},
	{"NTME", 4, 8149},
	{"SPEAKER", 7, 8150},
	{"EXPANDED", 8, 8151},
	{"GROWN", 5, 8152},
	{"WEALTH", 6, 8153},
	{"SCUR", 4, 8154},
	{"EBRE", 4, 8155},
	{"ESYS", 4, 8156},
	{"POLISH", 6, 8157},
	{"EXTRAS", 6, 8158},
	{"PRECISELY", 9, 8159},
	{"AWARD", 5, 8160},
	{"ENAB", 4, 8161},
	{"GEAR", 4, 8162},
	{"ONEF", 4, 8163},
	{"FALSE", 5, 8164},
	{"HTOF", 4, 8165},
	{"HBOR", 4, 8166},
	{"NDAP", 4, 8167},
	{"CENTRES", 7, 8168},
	{"URAG", 4, 8169},
	{"JERRY", 5, 8170},
	{"EPHO", 4, 8171},
	{"CLAUSE", 6, 8172},
	{"TWHO", 4, 8173},
	{"SHIG", 4, 8174},
	{"LANDS", 5, 8175},
	{"IGNO", 4, 8176},
	{"TROOPS", 6, 8177},
	{"ASSIGN", 6, 8178},
	{"TESW", 4, 8179},
	{"COOPERATION", 11, 8180},
	{"TEWI", 4, 8181},
	{"INDOOR", 6, 8182},
	{"BULGARIA", 8, 8183},
	{"THMA", 4, 8184},
	{"FIFT", 4, 8185},
	{"SHOM", 4, 8186},
	{"CHARGER", 7, 8187},
	{"AREU", 4, 8188},
	{"CANADIAN", 8, 8189},
	{"RESTORE", 7, 8190},
	{"BELIEVED", 8, 8191},
	{"RHAP", 4, 8192},
	{"XPRE", 4, 8193},
	{"ICHO", 4, 8194},
	{"COOLING", 7, 8195},
	{"LITERARY", 8, 8196},
	{"LYWH", 4, 8197},
	{"APPROVAL", 8, 8198},
	{"LDCO", 4, 8199},
	{"GULF", 4, 8200},
	{"TTAK", 4, 8201},
	{"RICK", 4, 8202},
	{"NJUN", 4, 8203},
	{"CKLY", 4, 8204},
	{"SWIF", 4, 8205},
	{"TRUCKS", 6, 8206},
	{"DETO", 4, 8207},
	{"BARRIER", 7, 8208},
	{"MECHANISMS", 10, 8209},
	{"YDT", 3, 8210},
	{"SGRA", 4, 8211},
	{"LAURA", 5, 8212},
	{"SHOPPER", 7, 8213},
	{"TOKYO", 5, 8214},
	{"ATSW", 4, 8215},
	{"NIKON", 5, 8216},
	{"TELESCOPE", 9, 8217},
	{"INDEX", 5, 8218},
	{"EEXT", 4, 8219},
	{"CUSTOMIZE", 9, 8220},
	{"IMPRESSION", 10, 8221},
	{"LFIN", 4, 8222},
	{"EFLO", 4, 8223},
	{"NTEX", 4, 8224},
	{"ACTIVIST", 8, 8225},
	{"AYOR", 4, 8226},
	{"SGIV", 4, 8227},
	{"ATAB", 4, 8228},
	{"PILLS", 5, 8229},
	{"TIGER", 5, 8230},
	{"YVU", 3, 8231},
	{"ORYE", 4, 8232},
	{"DONALD", 6, 8233},
	{"FOLKS", 5, 8234},
	{"YDON", 4, 8235},
	{"NGSC", 4, 8236},
	{"EXPOSED", 7, 8237},
	{"TELECOM", 7, 8238},
	{"KTY", 3, 8239},
	{"ANGELS", 6, 8240},
	{"NDEL", 4, 8241},
	{"SINM", 4, 8242},
	{"LPED", 4, 8243},
	{"ANOP", 4, 8244},
	{"TRET", 4, 8245},
	{"INDICATORS", 10, 8246},
	{"INEM", 4, 8247},
	{"SEALED", 6, 8248},
	{"DUND", 4, 8249},
	{"EVET", 4, 8250},
	{"ETYO", 4, 8251},
	{"OEXP", 4, 8252},
	{"NWER", 4, 8253},
	{"ILWA", 4, 8254},
	{"ICKI", 4, 8255},
	{"OGIV", 4, 8256},
	{"SPOKESMAN", 9, 8257},
	{"EMISSIONS", 9, 8258},
	{"PHYSICIANS", 10, 8259},
	{"ZCH", 3, 8260},
	{"RALM", 4, 8261},
	{"UCHO", 4, 8262},
	{"TIND", 4, 8263},
	{"LOADED", 6, 8264},
	{"CYJ", 3, 8265},
	{"DRAFT", 5, 8266},
	{"TOURNAMENT", 10, 8267},
	{"CHOCOLATE", 9, 8268},
	{"KEDI", 4, 8269},
	{"SYV", 3, 8270},
	{"EYON", 4, 8271},
	{"TESTIMONY", 9, 8272},
	{"INBU", 4, 8273},
	{"FRED", 4, 8274},
	{"CHEMICAL", 8, 8275},
	{"SPIN", 4, 8276},
	{"IMTH", 4, 8277},
	{"CEILING", 7, 8278},
	{"WHEREAS", 7, 8279},
	{"SCENES", 6, 8280},
	{"EXPERIMENTS", 11, 8281},
	{"ASAG", 4, 8282},
	{"SFAM", 4, 8283},
	{"GANG", 4, 8284},
	{"OMEE", 4, 8285},
	{"BALLS", 5, 8286},
	{"LAWSUIT", 7, 8287},
	{"WLED", 4, 8288},
	{"AFGHANISTAN", 11, 8289},
	{"RCAN", 4, 8290},
	{"HIGHWAY", 7, 8291},
	{"WAYA", 4, 8292},
	{"SPANKING", 8, 8293},
	{"EDPA", 4, 8294},
	{"IWOU", 4, 8295},
	{"DIQ", 3, 8296},
	{"GOVERNANCE", 10, 8297},
	{"YIELD", 5, 8298},
	{"FOUNDED", 7, 8299},
	{"SUPPLEMENTS", 11, 8300},
	{"KILLER", 6, 8301},
	{"VALUABLE", 8, 8302},
	{"ICONS", 5, 8303},
	{"IPZ", 3, 8304},
	{"CATERING", 8, 8305},
	{"SOFR", 4, 8306},
	{"GYZ", 3, 8307},
	{"AUD", 3, 8308},
	{"CORPORATION", 11, 8309},
	{"YYOU", 4, 8310},
	{"ONPA", 4, 8311},
	{"CLASSIC", 7, 8312},
	{"ICST", 4, 8313},
	{"MEFR", 4, 8314},
	{"HLET", 4, 8315},
	{"OXX", 3, 8316},
	{"OMFO", 4, 8317},
	{"STAKE", 5, 8318},
	{"ILLW", 4, 8319},
	{"KEEPS", 5, 8320},
	{"ADVERTISING", 11, 8321},
	{"ATPR", 4, 8322},
	{"UNIVERSAL", 9, 8323},
	{"CAMCORDER", 9, 8324},
	{"TRAINED", 7, 8325},
	{"OOLI", 4, 8326},
	{"SUPER", 5, 8327},
	{"NLYO", 4, 8328},
	{"NBET", 4, 8329},
	{"PAUSE", 5, 8330},
	{"YSTR", 4, 8331},
	{"HOWM", 4, 8332},
	{"NGEO", 4, 8333},
	{"ROUTINE", 7, 8334},
	{"RUJ", 3, 8335},
	{"TPEO", 4, 8336},
	{"TKY", 3, 8337},
	{"IMPLEMENTING", 12, 8338},
	{"CONSTITUTIONAL", 14, 8339},
	{"ROSES", 5, 8340},
	{"ADVOCATE", 8, 8341},
	{"KSTH", 4, 8342},
	{"LABS", 4, 8343},
	{"ABIG", 4, 8344},
	{"UGGL", 4, 8345},
	{"EITW", 4, 8346},
	{"PHRASE", 6, 8347},
	{"LEHA", 4, 8348},
	{"KUF", 3, 8349},
	{"ONDT", 4, 8350},
	{"ZFI", 3, 8351},
	{"BUTTON", 6, 8352},
	{"TDAY", 4, 8353},
	{"YABO", 4, 8354},
	{"MOTORS", 6, 8355},
	{"HEYO", 4, 8356},
	{"ASSURE", 6, 8357},
	{"ULTIMATE", 8, 8358},
	{"DISTANT", 7, 8359},
	{"DTHO", 4, 8360},
	{"HPRO", 4, 8361},
	{"OWNW", 4, 8362},
	{"ROBERTS", 7, 8363},
	{"YWHO", 4, 8364},
	{"RDON", 4, 8365},
	{"YOFA", 4, 8366},
	{"LATTER", 6, 8367},
	{"GONNA", 5, 8368},
	{"DSHI", 4, 8369},
	{"CRM", 3, 8370},
	{"LSOP", 4, 8371},
	{"ANSL", 4, 8372},
	{"SWITCH", 6, 8373},
	{"UXD", 3, 8374},
	{"RSTI", 4, 8375},
	{"TLER", 4, 8376},
	{"BILLY", 5, 8377},
	{"ATWH", 4, 8378},
	{"LABEL", 5, 8379},
	{"CTST", 4, 8380},
	{"REVENUES", 8, 8381},
	{"SSIC", 4, 8382},
	{"ERDO", 4, 8383},
	{"WORSHIP", 7, 8384},
	{"YTRA", 4, 8385},
	{"HEAB", 4, 8386},
	{"QYO", 3, 8387},
	{"TOFL", 4, 8388},
	{"DQUA", 4, 8389},
	{"CRAIG", 5, 8390},
	{"STUPID", 6, 8391},
	{"NGEA", 4, 8392},
	{"POUN", 4, 8393},
	{"PRODUCING", 9, 8394},
	{"RSRE", 4, 8395},
	{"HEAVEN", 6, 8396},
	{"FURNITURE", 9, 8397},
	{"ZZM", 3, 8398},
	{"NDDA", 4, 8399},
	{"PANT", 4, 8400},
	{"CHURCHES", 8, 8401},
	{"PRECISION", 9, 8402},
	{"DAMAGES", 7, 8403},
	{"EEKE", 4, 8404},
	{"RESERVES", 8, 8405},
	{"UXF", 3, 8406},
	{"CONTRIBUTED", 11, 8407},
	{"ILLF", 4, 8408},
	{"LSOI", 4, 8409},
	{"SATELLITE", 9, 8410},
	{"WIPE", 4, 8411},
	{"REPRODUCTION", 12, 8412},
	{"SWEEP", 5, 8413},
	{"SRAE", 4, 8414},
	{"VACATION", 8, 8415},
	{"BELL", 4, 8416},
	{"LLYP", 4, 8417},
	{"AMP", 3, 8418},
	{"UTST", 4, 8419},
	{"OYK", 3, 8420},
	{"INGREDIENTS", 11, 8421},
	{"RSBE", 4, 8422},
	{"YALS", 4, 8423},
	{"ULDR", 4, 8424},
	{"YREC", 4, 8425},
	{"NORMALLY", 8, 8426},
	{"INFECTION", 9, 8427},
	{"EOFB", 4, 8428},
	{"JOHNNY", 6, 8429},
	{"NAUG", 4, 8430},
	{"GETI", 4, 8431},
	{"CLOCK", 5, 8432},
	{"HASR", 4, 8433},
	{"DRAMA", 5, 8434},
	{"EADV", 4, 8435},
	{"FENCE", 5, 8436},
	{"ILTO", 4, 8437},
	{"RECORDER", 8, 8438},
	{"ORUS", 4, 8439},
	{"YEVE", 4, 8440},
	{"ITALIAN", 7, 8441},
	{"COMPLAINTS", 10, 8442},
	{"EBLO", 4, 8443},
	{"ZYC", 3, 8444},
	{"ITBE", 4, 8445},
	{"FACING", 6, 8446},
	{"RESORT", 6, 8447},
	{"NANCY", 5, 8448},
	{"URST", 4, 8449},
	{"FOUND", 5, 8450},
	{"AYOU", 4, 8451},
	{"PROMOTIONS", 10, 8452},
	{"TRYA", 4, 8453},
	{"TONES", 5, 8454},
	{"EDFI", 4, 8455},
	{"HOIC", 4, 8456},
	{"ROUGH", 5, 8457},
	{"MAINTAINING", 11, 8458},
	{"AYHA", 4, 8459},
	{"YINS", 4, 8460},
	{"ECTU", 4, 8461},
	{"LAID", 4, 8462},
	{"EXTRAORDINARY", 13, 8463},
	{"DESTRUCTION", 11, 8464},
	{"DEFENCE", 7, 8465},
	{"PATCHES", 7, 8466},
	{"SEFO", 4, 8467},
	{"STRATEGIC", 9, 8468},
	{"MINOR", 5, 8469},
	{"NSUL", 4, 8470},
	{"TISSUE", 6, 8471},
	{"TERROR", 6, 8472},
	{"PORTRAIT", 8, 8473},
	{"REFUND", 6, 8474},
	{"USC", 3, 8475},
	{"TOWNS", 5, 8476},
	{"WSTH", 4, 8477},
	{"SURVIVAL", 8, 8478},
	{"ZFR", 3, 8479},
	{"HDY", 3, 8480},
	{"ENVIRONMENTS", 12, 8481},
	{"PREGNANT", 8, 8482},
	{"ELITE", 5, 8483},
	{"YINA", 4, 8484},
	{"TREMBL", 6, 8485},
	{"DIVIDED", 7, 8486},
	{"ERYD", 4, 8487},
	{"INTERPRET", 9, 8488},
	{"BLVD", 4, 8489},
	{"PERSONALLY", 10, 8490},
	{"AMD", 3, 8491},
	{"JPU", 3, 8492},
	{"PENALTY", 7, 8493},
	{"NGAF", 4, 8494},
	{"WEDN", 4, 8495},
	{"TMEA", 4, 8496},
	{"XVE", 3, 8497},
	{"NMON", 4, 8498},
	{"EOPP", 4, 8499},
	{"EMAILS", 6, 8500},
	{"OSAY", 4, 8501},
	{"CYPRUS", 6, 8502},
	{"ASTL", 4, 8503},
	{"DISAGREE", 8, 8504},
	{"INSIDER", 7, 8505},
	{"NLIK", 4, 8506},
	{"DAYW", 4, 8507},
	{"SEMINARS", 8, 8508},
	{"CONSEQUENCES", 12, 8509},
	{"MAKERS", 6, 8510},
	{"OFSA", 4, 8511},
	{"HEARTS", 6, 8512},
	{"GEOGRAPHY", 9, 8513},
	{"EMAJ", 4, 8514},
	{"STRANGER", 8, 8515},
	{"EXTERNAL", 8, 8516},
	{"APPEARING", 9, 8517},
	{"INAU", 4, 8518},
	{"DGES", 4, 8519},
	{"VOIC", 4, 8520},
	{"HADO", 4, 8521},
	{"THAF", 4, 8522},
	{"BAKE", 4, 8523},
	{"CHAMPION", 8, 8524},
	{"CARTER", 6, 8525},
	{"SATISFACTION", 12, 8526},
	{"RANK", 4, 8527},
	{"LWOR", 4, 8528},
	{"INOF", 4, 8529},
	{"GENTLY", 6, 8530},
	{"LUJ", 3, 8531},
	{"ANGO", 4, 8532},
	{"EROO", 4, 8533},
	{"ESLO", 4, 8534},
	{"IPPI", 4, 8535},
	{"LLSH", 4, 8536},
	{"MARC", 4, 8537},
	{"BUNCH", 5, 8538},
	{"UPOF", 4, 8539},
	{"ARDL", 4, 8540},
	{"CEWA", 4, 8541},
	{"YDG", 3, 8542},
	{"UTWI", 4, 8543},
	{"YDID", 4, 8544},
	{"TOWH", 4, 8545},
	{"RELEVANT", 8, 8546},
	{"NOFS", 4, 8547},
	{"CKST", 4, 8548},
	{"ETWI", 4, 8549},
	{"CESW", 4, 8550},
	{"DISPUTE", 7, 8551},
	{"PROCESSED", 9, 8552},
	{"RAISING", 7, 8553},
	{"ROUGHLY", 7, 8554},
	{"IMPLICATIONS", 12, 8555},
	{"FUNCTIONALITY", 13, 8556},
	{"PARADISE", 8, 8557},
	{"RRIN", 4, 8558},
	{"DMAK", 4, 8559},
	{"LLSO", 4, 8560},
	{"IDIT", 4, 8561},
	{"LDST", 4, 8562},
	{"DTOI", 4, 8563},
	{"HYBRID", 6, 8564},
	{"READS", 5, 8565},
	{"ROLES", 5, 8566},
	{"SIMILARLY", 9, 8567},
	{"COMMUNICATE", 11, 8568},
	{"ODAN", 4, 8569},
	{"INTERMEDIATE", 12, 8570},
	{"IHAD", 4, 8571},
	{"APPLE", 5, 8572},
	{"STAIR", 5, 8573},
	{"PLATFORMS", 9, 8574},
	{"COUNSELOR", 9, 8575},
	{"TERRORIST", 9, 8576},
	{"BIGGER", 6, 8577},
	{"BILLING", 7, 8578},
	{"EDUL", 4, 8579},
	{"DIESEL", 6, 8580},
	{"NGSP", 4, 8581},
	{"CESH", 4, 8582},
	{"COUSIN", 6, 8583},
	{"XOU", 3, 8584},
	{"GEOGRAPHIC", 10, 8585},
	{"RDSO", 4, 8586},
	{"UIK", 3, 8587},
	{"CONCENTRATION", 13, 8588},
	{"DPRI", 4, 8589},
	{"SAUDI", 5, 8590},
	{"EENB", 4, 8591},
	{"EYWO", 4, 8592},
	{"EVOT", 4, 8593},
	{"ECUL", 4, 8594},
	{"CUBA", 4, 8595},
	{"ULDL", 4, 8596},
	{"DISTRICTS", 9, 8597},
	{"SOLAR", 5, 8598},
	{"TOGI", 4, 8599},
	{"XPEN", 4, 8600},
	{"ADVISER", 7, 8601},
	{"DHEL", 4, 8602},
	{"MHY", 3, 8603},
	{"OYEE", 4, 8604},
	{"APHI", 4, 8605},
	{"EBSI", 4, 8606},
	{"UTFO", 4, 8607},
	{"VIRUS", 5, 8608},
	{"AINW", 4, 8609},
	{"INCENTIVE", 9, 8610},
	{"SALAD", 5, 8611},
	{"PROMOTIONAL", 11, 8612},
	{"HUNTING", 7, 8613},
	{"ARYC", 4, 8614},
	{"BROKEN", 6, 8615},
	{"LLNE", 4, 8616},
	{"KATE", 4, 8617},
	{"CHEVROLET", 9, 8618},
	{"OREE", 4, 8619},
	{"SENATOR", 7, 8620},
	{"BABIES", 6, 8621},
	{"PROFILE", 7, 8622},
	{"KAREN", 5, 8623},
	{"COMPILED", 8, 8624},
	{"STATISTICS", 10, 8625},
	{"EENM", 4, 8626},
	{"TINF", 4, 8627},
	{"BOUNDARY", 8, 8628},
	{"RROU", 4, 8629},
	{"OFYO", 4, 8630},
	{"CLOTHING", 8, 8631},
	{"LNOT", 4, 8632},
	{"UITA", 4, 8633},
	{"GENETIC", 7, 8634},
	{"RVIN", 4, 8635},
	{"REVEALED", 8, 8636},
	{"SPECIALISTS", 11, 8637},
	{"DIRT", 4, 8638},
	{"REPRESENTATION", 14, 8639},
	{"GENERATOR", 9, 8640},
	{"ALBERT", 6, 8641},
	{"IMPLY", 5, 8642},
	{"NJAN", 4, 8643},
	{"OURH", 4, 8644},
	{"BURDEN", 6, 8645},
	{"EXPANSION", 9, 8646},
	{"DSEV", 4, 8647},
	{"JIMMY", 5, 8648},
	{"LLET", 4, 8649},
	{"SEDW", 4, 8650},
	{"YKL", 3, 8651},
	{"GRAHAM", 6, 8652},
	{"SUSPENSION", 10, 8653},
	{"BRISTOL", 7, 8654},
	{"ANYI", 4, 8655},
	{"MARGARET", 8, 8656},
	{"YXI", 3, 8657},
	{"RETAIN", 6, 8658},
	{"CEWH", 4, 8659},
	{"COMPAQ", 6, 8660},
	{"ISCL", 4, 8661},
	{"ILLM", 4, 8662},
	{"CHAMBER", 7, 8663},
	{"CORRECTION", 10, 8664},
	{"GHLY", 4, 8665},
	{"OFGO", 4, 8666},
	{"YLIN", 4, 8667},
	{"ORKT", 4, 8668},
	{"AUTHENTICATION", 14, 8669},
	{"INITIALLY", 9, 8670},
	{"DREP", 4, 8671},
	{"SSCH", 4, 8672},
	{"RUGBY", 5, 8673},
	{"UCHD", 4, 8674},
	{"DIVERSE", 7, 8675},
	{"SUPPLEMENT", 10, 8676},
	{"AWARENESS", 9, 8677},
	{"RTIO", 4, 8678},
	{"CORRESPONDENT", 13, 8679},
	{"ELECTRIC", 8, 8680},
	{"BLIND", 5, 8681},
	{"SHOWTIMES", 9, 8682},
	{"YCK", 3, 8683},
	{"TWOY", 4, 8684},
	{"RLJ", 3, 8685},
	{"CAL", 3, 8686},
	{"LLAB", 4, 8687},
	{"PORTIONS", 8, 8688},
	{"TLEM", 4, 8689},
	{"DVU", 3, 8690},
	{"PROMOTING", 9, 8691},
	{"EIRH", 4, 8692},
	{"OLDM", 4, 8693},
	{"DWHA", 4, 8694},
	{"SECTORS", 7, 8695},
	{"SAMUEL", 6, 8696},
	{"FWHI", 4, 8697},
	{"STRING", 6, 8698},
	{"ENCOUNTER", 9, 8699},
	{"GROUNDS", 7, 8700},
	{"FITS", 4, 8701},
	{"REGARDS", 7, 8702},
	{"EIRD", 4, 8703},
	{"MACHINERY", 9, 8704},
	{"OMBA", 4, 8705},
	{"BANDWIDTH", 9, 8706},
	{"BASKETS", 7, 8707},
	{"OVJ", 3, 8708},
	{"AVEI", 4, 8709},
	{"PROBABILITY", 11, 8710},
	{"SHOPPING", 8, 8711},
	{"WRIGHT", 6, 8712},
	{"DVIS", 4, 8713},
	{"ELECTRICITY", 11, 8714},
	{"IMG", 3, 8715},
	{"ISHM", 4, 8716},
	{"BARRY", 5, 8717},
	{"PROVEN", 6, 8718},
	{"ATHR", 4, 8719},
	{"SCHEDULES", 9, 8720},
	{"CONSTITUTE", 10, 8721},
	{"RICE", 4, 8722},
	{"ATDO", 4, 8723},
	{"ZOV", 3, 8724},
	{"ADMISSIONS", 10, 8725},
	{"NDIF", 4, 8726},
	{"ITHG", 4, 8727},
	{"GTOD", 4, 8728},
	{"CEREMONY", 8, 8729},
	{"ASAW", 4, 8730},
	{"CACHED", 6, 8731},
	{"WARREN", 6, 8732},
	{"STUDIED", 7, 8733},
	{"REVIEWER", 8, 8734},
	{"INVOLVES", 8, 8735},
	{"QUARTERLY", 9, 8736},
	{"AINF", 4, 8737},
	{"RPM", 3, 8738},
	{"PROFITS", 7, 8739},
	{"UREW", 4, 8740},
	{"ICHM", 4, 8741},
	{"ESIM", 4, 8742},
	{"MARIE", 5, 8743},
	{"ITIZ", 4, 8744},
	{"FLORIST", 7, 8745},
	{"EFRA", 4, 8746},
	{"IRLI", 4, 8747},
	{"ILLUSTRATED", 11, 8748},
	{"PORT", 4, 8749},
	{"CHERRY", 6, 8750},
	{"CONTINENTAL", 11, 8751},
	{"LOST", 4, 8752},
	{"RDZ", 3, 8753},
	{"ALTERNATE", 9, 8754},
	{"DEUTSCH", 7, 8755},
	{"REFLECTION", 10, 8756},
	{"AFET", 4, 8757},
	{"LIMITATIONS", 11, 8758},
	{"NOTP", 4, 8759},
	{"ULTO", 4, 8760},
	{"KENYA", 5, 8761},
	{"RNTO", 4, 8762},
	{"GTOG", 4, 8763},
	{"EIRT", 4, 8764},
	{"CUTS", 4, 8765},
	{"UNLIKELY", 8, 8766},
	{"ALSH", 4, 8767},
	{"NUTTEN", 6, 8768},
	{"SLAVE", 5, 8769},
	{"DSUP", 4, 8770},
	{"YOFS", 4, 8771},
	{"CHART", 5, 8772},
	{"EARRINGS", 8, 8773},
	{"AUTOMATED", 9, 8774},
	{"CHAPTERS", 8, 8775},
	{"CHARLIE", 7, 8776},
	{"ODD", 3, 8777},
	{"JOURNAL", 7, 8778},
	{"DSOU", 4, 8779},
	{"QUEBEC", 6, 8780},
	{"ATDE", 4, 8781},
	{"CABINET", 7, 8782},
	{"OREW", 4, 8783},
	{"VYN", 3, 8784},
	{"TESTIFY", 7, 8785},
	{"INTELLECTUAL", 12, 8786},
	{"DINB", 4, 8787},
	{"CONVENIENT", 10, 8788},
	{"DENNIS", 6, 8789},
	{"ASWI", 4, 8790},
	{"INBA", 4, 8791},
	{"UBJE", 4, 8792},
	{"RXA", 3, 8793},
	{"MARS", 4, 8794},
	{"FRANCIS", 7, 8795},
	{"NLAN", 4, 8796},
	{"DECK", 4, 8797},
	{"NTFR", 4, 8798},
	{"ASSISTANT", 9, 8799},
	{"RECOMMENDATION", 14, 8800},
	{"XVA", 3, 8801},
	{"SIZED", 5, 8802},
	{"MANGA", 5, 8803},
	{"FORTUNE", 7, 8804},
	{"NOTICED", 7, 8805},
	{"SOCKET", 6, 8806},
	{"EWED", 4, 8807},
	{"EXK", 3, 8808},
	{"PROCEED", 7, 8809},
	{"TERG", 4, 8810},
	{"EECH", 4, 8811},
	{"URER", 4, 8812},
	{"SIGNALS", 7, 8813},
	{"OVERCOME", 8, 8814},
	{"CAPS", 4, 8815},
	{"REVOLUTION", 10, 8816},
	{"CHARACTERIZE", 12, 8817},
	{"REHO", 4, 8818},
	{"SPOI", 4, 8819},
	{"ELSO", 4, 8820},
	{"STPE", 4, 8821},
	{"HEYM", 4, 8822},
	{"EDHA", 4, 8823},
	{"THEFT", 5, 8824},
	{"SOFL", 4, 8825},
	{"CHMO", 4, 8826},
	{"ZDO", 3, 8827},
	{"OFNO", 4, 8828},
	{"NINV", 4, 8829},
	{"SYMBOLS", 7, 8830},
	{"DETECT", 6, 8831},
	{"META", 4, 8832},
	{"HUMANS", 6, 8833},
	{"ANALOG", 6, 8834},
	{"FACIAL", 6, 8835},
	{"LFJ", 3, 8836},
	{"LYAF", 4, 8837},
	{"CHOOSING", 8, 8838},
	{"LYHE", 4, 8839},
	{"OCCUPY", 6, 8840},
	{"DATED", 5, 8841},
	{"LOBA", 4, 8842},
	{"SCENARIO", 8, 8843},
	{"PRIOR", 5, 8844},
	{"URAT", 4, 8845},
	{"SEEKER", 6, 8846},
	{"MINT", 4, 8847},
	{"PACKARD", 7, 8848},
	{"OFFSET", 6, 8849},
	{"PAYDAY", 6, 8850},
	{"PHILIP", 6, 8851},
	{"TRANSLATE", 9, 8852},
	{"TLOO", 4, 8853},
	{"ONCL", 4, 8854},
	{"ONGI", 4, 8855},
	{"HOLDERS", 7, 8856},
	{"ETAB", 4, 8857},
	{"BELIEVES", 8, 8858},
	{"SWEDISH", 7, 8859},
	{"POEMS", 5, 8860},
	{"FRAMEWORK", 9, 8861},
	{"DTIM", 4, 8862},
	{"BULLET", 6, 8863},
	{"DIALOGUE", 8, 8864},
	{"EVJ", 3, 8865},
	{"TDID", 4, 8866},
	{"DISPLAYING", 10, 8867},
	{"FICTION", 7, 8868},
	{"YTIM", 4, 8869},
	{"SSIM", 4, 8870},
	{"RUB", 3, 8871},
	{"OURD", 4, 8872},
	{"COLLINS", 7, 8873},
	{"TREATY", 6, 8874},
	{"LLYE", 4, 8875},
	{"ELTH", 4, 8876},
	{"EMISSION", 8, 8877},
	{"EQUIPPED", 8, 8878},
	{"DINM", 4, 8879},
	{"STAGES", 6, 8880},
	{"ENCOURAGED", 10, 8881},
	{"SUR", 3, 8882},
	{"YRR", 3, 8883},
	{"REMARKABLE", 10, 8884},
	{"EYTO", 4, 8885},
	{"WINDS", 5, 8886},
	{"OFFENSE", 7, 8887},
	{"TREMENDOUS", 10, 8888},
	{"COUNTER", 7, 8889},
	{"HEEC", 4, 8890},
	{"TONGUE", 6, 8891},
	{"BROADWAY", 8, 8892},
	{"ACQUIRED", 8, 8893},
	{"BENCH", 5, 8894},
	{"LBUT", 4, 8895},
	{"CARTRIDGES", 10, 8896},
	{"STONES", 6, 8897},
	{"DEER", 4, 8898},
	{"GNOME", 5, 8899},
	{"ROOTS", 5, 8900},
	{"DECLARATION", 11, 8901},
	{"LOSING", 6, 8902},
	{"ATTEMPTS", 8, 8903},
	{"GADGETS", 7, 8904},
	{"NOBLE", 5, 8905},
	{"TFIR", 4, 8906},
	{"TSBU", 4, 8907},
	{"GLASGOW", 7, 8908},
	{"ACKL", 4, 8909},
	{"HWIT", 4, 8910},
	{"AUTOMATION", 10, 8911},
	{"IMPACTS", 7, 8912},
	{"TIGHT", 5, 8913},
	{"EYWI", 4, 8914},
	{"THIRTY", 6, 8915},
	{"ICEW", 4, 8916},
	{"SHOOTING", 8, 8917},
	{"REV", 3, 8918},
	{"SQUARE", 6, 8919},
	{"GOSPEL", 6, 8920},
	{"EHAL", 4, 8921},
	{"ADVANTAGES", 10, 8922},
	{"ADVANCED", 8, 8923},
	{"ORSW", 4, 8924},
	{"LOVES", 5, 8925},
	{"INDUCED", 7, 8926},
	{"EMPO", 4, 8927},
	{"KNIGHT", 6, 8928},
	{"PREPARING", 9, 8929},
	{"AIMS", 4, 8930},
	{"LINKING", 7, 8931},
	{"EXTENSIONS", 10, 8932},
	{"IDEAL", 5, 8933},
	{"APPEALS", 7, 8934},
	{"AVEP", 4, 8935},
	{"NGBO", 4, 8936},
	{"COMPREHENSIVE", 13, 8937},
	{"NGUN", 4, 8938},
	{"URBA", 4, 8939},
	{"OPRI", 4, 8940},
	{"IFEA", 4, 8941},
	{"EARNED", 6, 8942},
	{"WRON", 4, 8943},
	{"PALE", 4, 8944},
	{"ONTW", 4, 8945},
	{"FREEZE", 6, 8946},
	{"NINF", 4, 8947},
	{"ATHLETICS", 9, 8948},
	{"SINK", 4, 8949},
	{"LLPR", 4, 8950},
	{"AIRCRAFT", 8, 8951},
	{"INSIGHT", 7, 8952},
	{"ILLG", 4, 8953},
	{"ITFO", 4, 8954},
	{"DTAK", 4, 8955},
	{"XKI", 3, 8956},
	{"ERYA", 4, 8957},
	{"EXTENSIVE", 9, 8958},
	{"ATBE", 4, 8959},
	{"ESTB", 4, 8960},
	{"OADS", 4, 8961},
	{"ALTERNATIVES", 12, 8962},
	{"EIRM", 4, 8963},
	{"PENDING", 7, 8964},
	{"PARKER", 6, 8965},
	{"FOUNDER", 7, 8966},
	{"DETERMINING", 11, 8967},
	{"INLI", 4, 8968},
	{"NOTG", 4, 8969},
	{"MUTUAL", 6, 8970},
	{"LEBANON", 7, 8971},
	{"CORP", 4, 8972},
	{"CRAFT", 5, 8973},
	{"OFBA", 4, 8974},
	{"PERSONALIZED", 12, 8975},
	{"UXH", 3, 8976},
	{"KENNEDY", 7, 8977},
	{"OFHA", 4, 8978},
	{"CONDITIONING", 12, 8979},
	{"OTAB", 4, 8980},
	{"RTEA", 4, 8981},
	{"OUTR", 4, 8982},
	{"RLYA", 4, 8983},
	{"CONSIDERABLE", 12, 8984},
	{"STRIP", 5, 8985},
	{"TRIPLE", 6, 8986},
	{"COOPER", 6, 8987},
	{"YBET", 4, 8988},
	{"NYC", 3, 8989},
	{"BIBLE", 5, 8990},
	{"VINCENT", 7, 8991},
	{"JAM", 3, 8992},
	{"INNOCENT", 8, 8993},
	{"SECURED", 7, 8994},
	{"RZU", 3, 8995},
	{"ANSWERED", 8, 8996},
	{"SIGNIFICANCE", 12, 8997},
	{"PARTNERSHIPS", 12, 8998},
	{"SLOTS", 5, 8999},
	{"TSPO", 4, 9000},
	{"TOOLBAR", 7, 9001},
	{"OMHI", 4, 9002},
	{"FINANCE", 7, 9003},
	{"LOVER", 5, 9004},
	{"CHMA", 4, 9005},
	{"DMIL", 4, 9006},
	{"YUSE", 4, 9007},
	{"ROCKS", 5, 9008},
	{"TIRE", 4, 9009},
	{"UTIF", 4, 9010},
	{"EENW", 4, 9011},
	{"LDWI", 4, 9012},
	{"INTRODUCTION", 12, 9013},
	{"SQUI", 4, 9014},
	{"LDEN", 4, 9015},
	{"DWHO", 4, 9016},
	{"LEDW", 4, 9017},
	{"EDOV", 4, 9018},
	{"TITANS", 6, 9019},
	{"KTOT", 4, 9020},
	{"APPLICANTS", 10, 9021},
	{"AHIG", 4, 9022},
	{"POSSESS", 7, 9023},
	{"WEARING", 7, 9024},
	{"LTAN", 4, 9025},
	{"AXIS", 4, 9026},
	{"PROFESSION", 10, 9027},
	{"DWER", 4, 9028},
	{"SOUGHT", 6, 9029},
	{"GENES", 5, 9030},
	{"ELYS", 4, 9031},
	{"SBEL", 4, 9032},
	{"ZKY", 3, 9033},
	{"MOUNTED", 7, 9034},
	{"AYWI", 4, 9035},
	{"IRPO", 4, 9036},
	{"FIREWALL", 8, 9037},
	{"MEDIAN", 6, 9038},
	{"GUNS", 4, 9039},
	{"OVEN", 4, 9040},
	{"GARLIC", 6, 9041},
	{"SCANNER", 7, 9042},
	{"POLE", 4, 9043},
	{"OURL", 4, 9044},
	{"HEREIN", 6, 9045},
	{"AIGH", 4, 9046},
	{"EVOLVE", 6, 9047},
	{"DEFENSIVE", 9, 9048},
	{"ENBY", 4, 9049},
	{"OCCUPATIONAL", 12, 9050},
	{"ANIMATED", 8, 9051},
	{"LYMO", 4, 9052},
	{"HORNY", 5, 9053},
	{"DSCO", 4, 9054},
	{"GUARANTEE", 9, 9055},
	{"OOKO", 4, 9056},
	{"DMON", 4, 9057},
	{"NHOU", 4, 9058},
	{"ENOV", 4, 9059},
	{"OODI", 4, 9060},
	{"INTEGER", 7, 9061},
	{"TREATMENTS", 10, 9062},
	{"BACHELOR", 8, 9063},
	{"JUSTIFY", 7, 9064},
	{"UEDT", 4, 9065},
	{"VARIATION", 9, 9066},
	{"CAMCORDERS", 10, 9067},
	{"ENGAGED", 7, 9068},
	{"FALLING", 7, 9069},
	{"XTRE", 4, 9070},
	{"POLLUTION", 9, 9071},
	{"BASICS", 6, 9072},
	{"NEWLY", 5, 9073},
	{"POTENTIALLY", 11, 9074},
	{"MONTREAL", 8, 9075},
	{"LICT", 4, 9076},
	{"DISTINCTION", 11, 9077},
	{"LEDF", 4, 9078},
	{"ONBO", 4, 9079},
	{"FADE", 4, 9080},
	{"YEDA", 4, 9081},
	{"PRESENTATION", 12, 9082},
	{"SUDDEN", 6, 9083},
	{"STRUCT", 6, 9084},
	{"TMOS", 4, 9085},
	{"ONBY", 4, 9086},
	{"MAINLY", 6, 9087},
	{"LENSES", 6, 9088},
	{"BINARY", 6, 9089},
	{"RTFO", 4, 9090},
	{"GENETICS", 8, 9091},
	{"ATTENDED", 8, 9092},
	{"CTSO", 4, 9093},
	{"PUNK", 4, 9094},
	{"FRIENDLY", 8, 9095},
	{"NTYO", 4, 9096},
	{"ESTABLISHMENT", 13, 9097},
	{"IESC", 4, 9098},
	{"WITHDRAW", 8, 9099},
	{"REMOTE", 6, 9100},
	{"DROPPED", 7, 9101},
	{"ONAF", 4, 9102},
	{"SWIM", 4, 9103},
	{"NDCR", 4, 9104},
	{"NGAD", 4, 9105},
	{"RYFO", 4, 9106},
	{"ENROLLMENT", 10, 9107},
	{"DUKE", 4, 9108},
	{"AMQ", 3, 9109},
	{"PRETEND", 7, 9110},
	{"WALTER", 6, 9111},
	{"REGULARLY", 9, 9112},
	{"SURPRISING", 10, 9113},
	{"ILLD", 4, 9114},
	{"POLITICALLY", 11, 9115},
	{"EARNINGS", 8, 9116},
	{"PRODUCERS", 9, 9117},
	{"DELIVERY", 8, 9118},
	{"EEMP", 4, 9119},
	{"DERC", 4, 9120},
	{"EYSA", 4, 9121},
	{"PSYCHOLOGY", 10, 9122},
	{"ARC", 3, 9123},
	{"HOSTS", 5, 9124},
	{"RAW", 3, 9125},
	{"INTERFACES", 10, 9126},
	{"EIRB", 4, 9127},
	{"ADVERTISERS", 11, 9128},
	{"COMPLICATED", 11, 9129},
	{"GHTC", 4, 9130},
	{"LEHE", 4, 9131},
	{"MOMENTS", 7, 9132},
	{"ATLAS", 5, 9133},
	{"NATURALLY", 9, 9134},
	{"STRINGS", 7, 9135},
	{"REPRESENTING", 12, 9136},
	{"LOOSE", 5, 9137},
	{"FEELS", 5, 9138},
	{"PSAN", 4, 9139},
	{"TORTURE", 7, 9140},
	{"LIFETIME", 8, 9141},
	{"CARL", 4, 9142},
	{"DELETED", 7, 9143},
	{"MITCHELL", 8, 9144},
	{"RICA", 4, 9145},
	{"NEDH", 4, 9146},
	{"RESTORATION", 11, 9147},
	{"ARWI", 4, 9148},
	{"FREQUENCY", 9, 9149},
	{"IVEH", 4, 9150},
	{"RETURNING", 9, 9151},
	{"SQUEEZE", 7, 9152},
	{"DRUN", 4, 9153},
	{"ITDO", 4, 9154},
	{"SINGER", 6, 9155},
	{"RALPH", 5, 9156},
	{"IZC", 3, 9157},
	{"OUIS", 4, 9158},
	{"REHI", 4, 9159},
	{"UTCO", 4, 9160},
	{"TTOW", 4, 9161},
	{"WNAN", 4, 9162},
	{"RNAN", 4, 9163},
	{"WARNER", 6, 9164},
	{"TOUG", 4, 9165},
	{"EOFO", 4, 9166},
	{"CRASH", 5, 9167},
	{"CONFIRMATION", 12, 9168},
	{"APP", 3, 9169},
	{"EMBEDDED", 8, 9170},
	{"INKJET", 6, 9171},
	{"WOYE", 4, 9172},
	{"EFK", 3, 9173},
	{"WIZARD", 6, 9174},
	{"CORPS", 5, 9175},
	{"ACTORS", 6, 9176},
	{"OMBE", 4, 9177},
	{"PERIPHERALS", 11, 9178},
	{"EENF", 4, 9179},
	{"EDCH", 4, 9180},
	{"DIFFER", 6, 9181},
	{"YTOB", 4, 9182},
	{"LIABLE", 6, 9183},
	{"IGAN", 4, 9184},
	{"EINP", 4, 9185},
	{"YISA", 4, 9186},
	{"BROCHURE", 8, 9187},
	{"LDIE", 4, 9188},
	{"ONWO", 4, 9189},
	{"MORRIS", 6, 9190},
	{"BESTSELLERS", 11, 9191},
	{"PETITION", 8, 9192},
	{"EMINEM", 6, 9193},
	{"NDPU", 4, 9194},
	{"PLATFORM", 8, 9195},
	{"ANTENNA", 7, 9196},
	{"PICKED", 6, 9197},
	{"ASSUMED", 7, 9198},
	{"MINNEAPOLIS", 11, 9199},
	{"RELAX", 5, 9200},
	{"WORKING", 7, 9201},
	{"BIKINI", 6, 9202},
	{"MASK", 4, 9203},
	{"MEMPHIS", 7, 9204},
	{"DSWI", 4, 9205},
	{"DECOR", 5, 9206},
	{"DBEF", 4, 9207},
	{"DOYO", 4, 9208},
	{"LOOKUP", 6, 9209},
	{"TEXTS", 5, 9210},
	{"REEC", 4, 9211},
	{"ENOF", 4, 9212},
	{"ASMU", 4, 9213},
	{"ONCH", 4, 9214},
	{"ATSU", 4, 9215},
	{"NPOL", 4, 9216},
	{"HARVARD", 7, 9217},
	{"ECLU", 4, 9218},
	{"PROTEST", 7, 9219},
	{"HTBE", 4, 9220},
	{"TWOT", 4, 9221},
	{"EMOU", 4, 9222},
	{"NTOL", 4, 9223},
	{"JOY", 3, 9224},
	{"BROKERS", 7, 9225},
	{"ROY", 3, 9226},
	{"ULDP", 4, 9227},
	{"AGEW", 4, 9228},
	{"INEV", 4, 9229},
	{"LYUN", 4, 9230},
	{"ILLL", 4, 9231},
	{"LYEA", 4, 9232},
	{"DISMISS", 7, 9233},
	{"GALAXY", 6, 9234},
	{"LEATHER", 7, 9235},
	{"DIAMETER", 8, 9236},
	{"VIOLATION", 9, 9237},
	{"TEDR", 4, 9238},
	{"EXQ", 3, 9239},
	{"OTTAWA", 6, 9240},
	{"LSAR", 4, 9241},
	{"ZYD", 3, 9242},
	{"PODCAST", 7, 9243},
	{"HEADQUARTERS", 12, 9244},
	{"OWNP", 4, 9245},
	{"IRAT", 4, 9246},
	{"SEASONS", 7, 9247},
	{"PARTLY", 6, 9248},
	{"PERU", 4, 9249},
	{"OUSC", 4, 9250},
	{"INTERACTIONS", 12, 9251},
	{"SLIF", 4, 9252},
	{"DTOU", 4, 9253},
	{"REFINE", 6, 9254},
	{"ORTL", 4, 9255},
	{"BIDDER", 6, 9256},
	{"ENTRANCE", 8, 9257},
	{"OWNB", 4, 9258},
	{"NOTW", 4, 9259},
	{"MMIN", 4, 9260},
	{"ATTRACTIVE", 10, 9261},
	{"RSTC", 4, 9262},
	{"EVANS", 5, 9263},
	{"AVOI", 4, 9264},
	{"HERALD", 6, 9265},
	{"FAULT", 5, 9266},
	{"GPLA", 4, 9267},
	{"PARTNERSHIP", 11, 9268},
	{"LITERACY", 8, 9269},
	{"FAILS", 5, 9270},
	{"DSAR", 4, 9271},
	{"AGING", 5, 9272},
	{"ORWI", 4, 9273},
	{"DIRTY", 5, 9274},
	{"EDMI", 4, 9275},
	{"HENB", 4, 9276},
	{"OSOM", 4, 9277},
	{"NIKE", 4, 9278},
	{"PRIDE", 5, 9279},
	{"ALTER", 5, 9280},
	{"EOFR", 4, 9281},
	{"FED", 3, 9282},
	{"ACKW", 4, 9283},
	{"PLUGIN", 6, 9284},
	{"ANLE", 4, 9285},
	{"DIVING", 6, 9286},
	{"UNKNOWN", 7, 9287},
	{"MODIFICATION", 12, 9288},
	{"ALICE", 5, 9289},
	{"NDUR", 4, 9290},
	{"LATINAS", 7, 9291},
	{"GBAC", 4, 9292},
	{"ICAG", 4, 9293},
	{"FUNERAL", 7, 9294},
	{"AIDO", 4, 9295},
	{"IAME", 4, 9296},
	{"RFIN", 4, 9297},
	{"CUSTOMIZED", 10, 9298},
	{"EFUS", 4, 9299},
	{"REED", 4, 9300},
	{"AILI", 4, 9301},
	{"YOUNGER", 7, 9302},
	{"ONOU", 4, 9303},
	{"EINM", 4, 9304},
	{"EPISODE", 7, 9305},
	{"MICE", 4, 9306},
	{"EVOLUTION", 9, 9307},
	{"UNDERSTOOD", 10, 9308},
	{"AWHO", 4, 9309},
	{"RUIT", 4, 9310},
	{"EGIV", 4, 9311},
	{"DEALTIME", 8, 9312},
	{"CONTROVERSY", 11, 9313},
	{"OBRI", 4, 9314},
	{"IALE", 4, 9315},
	{"LTEA", 4, 9316},
	{"OFUS", 4, 9317},
	{"INTRO", 5, 9318},
	{"REGARDLESS", 10, 9319},
	{"FSTA", 4, 9320},
	{"MERCEDES", 8, 9321},
	{"ZUS", 3, 9322},
	{"ASSAULT", 7, 9323},
	{"TRAGEDY", 7, 9324},
	{"LIMITATION", 10, 9325},
	{"ISGR", 4, 9326},
	{"ASSURANCE", 9, 9327},
	{"ADVENTURE", 9, 9328},
	{"HAPPENING", 9, 9329},
	{"WYL", 3, 9330},
	{"EFED", 4, 9331},
	{"ITSR", 4, 9332},
	{"DBYH", 4, 9333},
	{"EOFD", 4, 9334},
	{"MILLS", 5, 9335},
	{"IRCO", 4, 9336},
	{"PALM", 4, 9337},
	{"HONEY", 5, 9338},
	{"AMENDMENTS", 10, 9339},
	{"TRAMADOL", 8, 9340},
	{"HOLLAND", 7, 9341},
	{"RECEIVES", 8, 9342},
	{"OFWO", 4, 9343},
	{"LDMA", 4, 9344},
	{"GRANDFATHER", 11, 9345},
	{"COMPILATION", 11, 9346},
	{"EEXC", 4, 9347},
	{"VERIFICATION", 12, 9348},
	{"EYWA", 4, 9349},
	{"SDOW", 4, 9350},
	{"SITW", 4, 9351},
	{"ORIGINALLY", 10, 9352},
	{"ACEW", 4, 9353},
	{"OMEL", 4, 9354},
	{"NMIN", 4, 9355},
	{"FONTS", 5, 9356},
	{"OFIL", 4, 9357},
	{"LLHE", 4, 9358},
	{"CONVERT", 7, 9359},
	{"HESM", 4, 9360},
	{"ADAPT", 5, 9361},
	{"REFERS", 6, 9362},
	{"VETERANS", 8, 9363},
	{"QUIZ", 4, 9364},
	{"ELDERLY", 7, 9365},
	{"CKON", 4, 9366},
	{"SIGMA", 5, 9367},
	{"CIOU", 4, 9368},
	{"EYDO", 4, 9369},
	{"ERIF", 4, 9370},
	{"CHRE", 4, 9371},
	{"XHTML", 5, 9372},
	{"LLYM", 4, 9373},
	{"RECORDINGS", 10, 9374},
	{"CHZ", 3, 9375},
	{"STABLE", 6, 9376},
	{"JEFFERSON", 9, 9377},
	{"COMPOSITION", 11, 9378},
	{"LLSI", 4, 9379},
	{"EMTH", 4, 9380},
	{"DEMANDS", 7, 9381},
	{"GSTH", 4, 9382},
	{"NARRATIVE", 9, 9383},
	{"ATPE", 4, 9384},
	{"BUYER", 5, 9385},
	{"GBUT", 4, 9386},
	{"SLEEPING", 8, 9387},
	{"PROMINENT", 9, 9388},
	{"ESAG", 4, 9389},
	{"LICENSE", 7, 9390},
	{"GIFTED", 6, 9391},
	{"IVEE", 4, 9392},
	{"GARDENING", 9, 9393},
	{"TONW", 4, 9394},
	{"OBLIGATIONS", 11, 9395},
	{"TBEE", 4, 9396},
	{"EWSP", 4, 9397},
	{"RADICAL", 7, 9398},
	{"ITSL", 4, 9399},
	{"ORCHESTRA", 9, 9400},
	{"VESSEL", 6, 9401},
	{"OWHI", 4, 9402},
	{"SUNSET", 6, 9403},
	{"TRACKED", 7, 9404},
	{"NDCL", 4, 9405},
	{"GTIM", 4, 9406},
	{"OFAT", 4, 9407},
	{"IMAGINATION", 11, 9408},
	{"DERIVE", 6, 9409},
	{"IGK", 3, 9410},
	{"CAPABILITY", 10, 9411},
	{"STABILITY", 9, 9412},
	{"LYNO", 4, 9413},
	{"RQA", 3, 9414},
	{"STTW", 4, 9415},
	{"MHIS", 4, 9416},
	{"POLYPHONIC", 10, 9417},
	{"PORCH", 5, 9418},
	{"STORAGE", 7, 9419},
	{"LOTTERY", 7, 9420},
	{"SHELTER", 7, 9421},
	{"TOPS", 4, 9422},
	{"FRAMED", 6, 9423},
	{"AMAJ", 4, 9424},
	{"GTOH", 4, 9425},
	{"CHOT", 4, 9426},
	{"INSTANCE", 8, 9427},
	{"OUTSOURCING", 11, 9428},
	{"YNIG", 4, 9429},
	{"KETB", 4, 9430},
	{"LICENCE", 7, 9431},
	{"ADJUSTABLE", 10, 9432},
	{"ALLOCATION", 10, 9433},
	{"HWES", 4, 9434},
	{"VJO", 3, 9435},
	{"MICHELLE", 8, 9436},
	{"STDE", 4, 9437},
	{"URRO", 4, 9438},
	{"ERYW", 4, 9439},
	{"VITAL", 5, 9440},
	{"UCHT", 4, 9441},
	{"SHORTLY", 7, 9442},
	{"DSEE", 4, 9443},
	{"EDWE", 4, 9444},
	{"AVEF", 4, 9445},
	{"ALSW", 4, 9446},
	{"OFAB", 4, 9447},
	{"IDTO", 4, 9448},
	{"TRIBE", 5, 9449},
	{"AMY", 3, 9450},
	{"GMOR", 4, 9451},
	{"SONM", 4, 9452},
	{"RYIS", 4, 9453},
	{"SEGMENT", 7, 9454},
	{"DINING", 6, 9455},
	{"URRI", 4, 9456},
	{"DEMONSTRATED", 12, 9457},
	{"POET", 4, 9458},
	{"XUP", 3, 9459},
	{"HUNTER", 6, 9460},
	{"IDENTIFYING", 11, 9461},
	{"ALPHABETICAL", 12, 9462},
	{"HEVO", 4, 9463},
	{"HASD", 4, 9464},
	{"NSAL", 4, 9465},
	{"DEDW", 4, 9466},
	{"CAMPS", 5, 9467},
	{"IRISH", 5, 9468},
	{"PREFERENCE", 10, 9469},
	{"MEHE", 4, 9470},
	{"CONFIDENT", 9, 9471},
	{"ICRE", 4, 9472},
	{"DECLARED", 8, 9473},
	{"TLEO", 4, 9474},
	{"EAMT", 4, 9475},
	{"RCHO", 4, 9476},
	{"DISPATCHED", 10, 9477},
	{"VIOLATE", 7, 9478},
	{"AARON", 5, 9479},
	{"HANDHELD", 8, 9480},
	{"ROFS", 4, 9481},
	{"IFHE", 4, 9482},
	{"DISPOSAL", 8, 9483},
	{"OBEI", 4, 9484},
	{"LAWN", 4, 9485},
	{"NGPL", 4, 9486},
	{"RMEN", 4, 9487},
	{"FLORISTS", 8, 9488},
	{"HMOR", 4, 9489},
	{"PACKS", 5, 9490},
	{"DTJ", 3, 9491},
	{"ATHLETIC", 8, 9492},
	{"OHOL", 4, 9493},
	{"INSTALLING", 10, 9494},
	{"CARBON", 6, 9495},
	{"SWITCHES", 8, 9496},
	{"ROMANIA", 7, 9497},
	{"NCAA", 4, 9498},
	{"SGEN", 4, 9499},
	{"THOU", 4, 9500},
	{"OLUN", 4, 9501},
	{"PHD", 3, 9502},
	{"MOFT", 4, 9503},
	{"ITYH", 4, 9504},
	{"VESH", 4, 9505},
	{"BLOGGING", 8, 9506},
	{"RHIM", 4, 9507},
	{"PROPERLY", 8, 9508},
	{"ATFI", 4, 9509},
	{"CYCLING", 7, 9510},
	{"MERE", 4, 9511},
	{"OADC", 4, 9512},
	{"DDUR", 4, 9513},
	{"PROOF", 5, 9514},
	{"NHOW", 4, 9515},
	{"REEO", 4, 9516},
	{"NKNO", 4, 9517},
	{"ZAU", 3, 9518},
	{"ITYB", 4, 9519},
	{"SSTU", 4, 9520},
	{"BEYO", 4, 9521},
	{"OUSP", 4, 9522},
	{"ZYK", 3, 9523},
	{"ERBY", 4, 9524},
	{"EDLE", 4, 9525},
	{"QWI", 3, 9526},
	{"NEFO", 4, 9527},
	{"CELEBRITY", 9, 9528},
	{"TURKISH", 7, 9529},
	{"SCARED", 6, 9530},
	{"MESSAGING", 9, 9531},
	{"DISTRIBUTE", 10, 9532},
	{"PENTIUM", 7, 9533},
	{"AMTH", 4, 9534},
	{"ISFR", 4, 9535},
	{"SHELF", 5, 9536},
	{"QUANTUM", 7, 9537},
	{"GESTURE", 7, 9538},
	{"NUND", 4, 9539},
	{"MURRAY", 6, 9540},
	{"LOAD", 4, 9541},
	{"YMAR", 4, 9542},
	{"OPPI", 4, 9543},
	{"UTCH", 4, 9544},
	{"OAPP", 4, 9545},
	{"TBEF", 4, 9546},
	{"EXAMINATION", 11, 9547},
	{"HEDB", 4, 9548},
	{"ONGOING", 7, 9549},
	{"ANTC", 4, 9550},
	{"URVE", 4, 9551},
	{"LTHC", 4, 9552},
	{"INEB", 4, 9553},
	{"URCO", 4, 9554},
	{"STEADY", 6, 9555},
	{"CONSTRUCTED", 11, 9556},
	{"CHFO", 4, 9557},
	{"ADDITIONS", 9, 9558},
	{"REQUIRING", 9, 9559},
	{"SPOKE", 5, 9560},
	{"DEDF", 4, 9561},
	{"CQUI", 4, 9562},
	{"YTHO", 4, 9563},
	{"PSYCHOLOGIST", 12, 9564},
	{"COUNCIL", 7, 9565},
	{"SAMPLING", 8, 9566},
	{"SHRUG", 5, 9567},
	{"ENTG", 4, 9568},
	{"NHAV", 4, 9569},
	{"ASLEEP", 6, 9570},
	{"THWA", 4, 9571},
	{"GMEN", 4, 9572},
	{"SHADE", 5, 9573},
	{"UTTE", 4, 9574},
	{"COMFORT", 7, 9575},
	{"ERYB", 4, 9576},
	{"UBST", 4, 9577},
	{"REFINANCE", 9, 9578},
	{"POETRY", 6, 9579},
	{"OPOF", 4, 9580},
	{"ELDI", 4, 9581},
	{"NBOT", 4, 9582},
	{"INSPIRED", 8, 9583},
	{"SCLE", 4, 9584},
	{"HOLES", 5, 9585},
	{"WEDDINGS", 8, 9586},
	{"TAIL", 4, 9587},
	{"ICEF", 4, 9588},
	{"REEW", 4, 9589},
	{"DBYM", 4, 9590},
	{"RTOR", 4, 9591},
	{"NOWHERE", 7, 9592},
	{"MEALS", 5, 9593},
	{"CANYON", 6, 9594},
	{"OURG", 4, 9595},
	{"TENDENCY", 8, 9596},
	{"CHOLESTEROL", 11, 9597},
	{"GOTO", 4, 9598},
	{"UYY", 3, 9599},
	{"METERS", 6, 9600},
	{"ARYI", 4, 9601},
	{"RUNI", 4, 9602},
	{"ASTU", 4, 9603},
	{"LMAR", 4, 9604},
	{"OWHO", 4, 9605},
	{"LLWA", 4, 9606},
	{"RVY", 3, 9607},
	{"CALENDARS", 9, 9608},
	{"NGNO", 4, 9609},
	{"ECONOMIST", 9, 9610},
	{"SEWI", 4, 9611},
	{"RTAT", 4, 9612},
	{"CONCLUSIONS", 11, 9613},
	{"PASSES", 6, 9614},
	{"BIBLIOGRAPHY", 12, 9615},
	{"GIVEN", 5, 9616},
	{"RRIC", 4, 9617},
	{"POINTER", 7, 9618},
	{"ORIENTATION", 11, 9619},
	{"ISDO", 4, 9620},
	{"TOAR", 4, 9621},
	{"VKA", 3, 9622},
	{"RFEC", 4, 9623},
	{"COMPATIBILITY", 13, 9624},
	{"NDDR", 4, 9625},
	{"ONBA", 4, 9626},
	{"EWTH", 4, 9627},
	{"DURHAM", 6, 9628},
	{"RGAM", 4, 9629},
	{"TOBACCO", 7, 9630},
	{"EXCITING", 8, 9631},
	{"PILE", 4, 9632},
	{"PERMITS", 7, 9633},
	{"SPLIT", 5, 9634},
	{"NEIL", 4, 9635},
	{"ZBR", 3, 9636},
	{"NETSCAPE", 8, 9637},
	{"CLEANER", 7, 9638},
	{"CRICKET", 7, 9639},
	{"FEEDING", 7, 9640},
	{"EFEE", 4, 9641},
	{"MUSICIAN", 8, 9642},
	{"CHAPTER", 7, 9643},
	{"EFFICIENCY", 10, 9644},
	{"TOWNSHIP", 8, 9645},
	{"RANKINGS", 8, 9646},
	{"MEASURING", 9, 9647},
	{"CAD", 3, 9648},
	{"OFBO", 4, 9649},
	{"OCKI", 4, 9650},
	{"ORGANIC", 7, 9651},
	{"SOUP", 4, 9652},
	{"ISBO", 4, 9653},
	{"ADOLESCENT", 10, 9654},
	{"ROBIN", 5, 9655},
	{"MOTIVATION", 10, 9656},
	{"ROBINSON", 8, 9657},
	{"HCOM", 4, 9658},
	{"JACKSONVILLE", 12, 9659},
	{"WISDOM", 6, 9660},
	{"DISCOURSE", 9, 9661},
	{"MURD", 4, 9662},
	{"STRAP", 5, 9663},
	{"SHARON", 6, 9664},
	{"GKH", 3, 9665},
	{"FORMATION", 9, 9666},
	{"TCP", 3, 9667},
	{"SUSTAIN", 7, 9668},
	{"HYOU", 4, 9669},
	{"TRANSFERS", 9, 9670},
	{"SURF", 4, 9671},
	{"VEHA", 4, 9672},
	{"LLUS", 4, 9673},
	{"ORSC", 4, 9674},
	{"KWAS", 4, 9675},
	{"OPOL", 4, 9676},
	{"OBLIGATION", 10, 9677},
	{"REMAINED", 8, 9678},
	{"ATTACHMENTS", 11, 9679},
	{"GRADUALLY", 9, 9680},
	{"BESIDES", 7, 9681},
	{"RSTU", 4, 9682},
	{"AGRICULTURAL", 12, 9683},
	{"IBIT", 4, 9684},
	{"EXIC", 4, 9685},
	{"OCRE", 4, 9686},
	{"ITEL", 4, 9687},
	{"DIR", 3, 9688},
	{"OSTU", 4, 9689},
	{"NONL", 4, 9690},
	{"FMAN", 4, 9691},
	{"NUET", 4, 9692},
	{"ENDU", 4, 9693},
	{"FATE", 4, 9694},
	{"PROPORTION", 10, 9695},
	{"ENTITIES", 8, 9696},
	{"CUSTOMS", 7, 9697},
	{"NGFA", 4, 9698},
	{"SNOR", 4, 9699},
	{"ADMINISTRATORS", 14, 9700},
	{"HOWO", 4, 9701},
	{"NTBU", 4, 9702},
	{"ENWA", 4, 9703},
	{"RAINBOW", 7, 9704},
	{"FLEE", 4, 9705},
	{"ROULETTE", 8, 9706},
	{"NUNI", 4, 9707},
	{"ANFR", 4, 9708},
	{"ENPR", 4, 9709},
	{"AROF", 4, 9710},
	{"NDGA", 4, 9711},
	{"RNQ", 3, 9712},
	{"GLOVES", 6, 9713},
	{"USIO", 4, 9714},
	{"OFTI", 4, 9715},
	{"YOVE", 4, 9716},
	{"MEDICARE", 8, 9717},
	{"IEWE", 4, 9718},
	{"SKIING", 6, 9719},
	{"CALCULATE", 9, 9720},
	{"PLOT", 4, 9721},
	{"EOFL", 4, 9722},
	{"RSEV", 4, 9723},
	{"INEU", 4, 9724},
	{"SUBSCRIBER", 10, 9725},
	{"VALVE", 5, 9726},
	{"ADEF", 4, 9727},
	{"VAL", 3, 9728},
	{"HEWLETT", 7, 9729},
	{"AREV", 4, 9730},
	{"TSOR", 4, 9731},
	{"EBIL", 4, 9732},
	{"EXPLAINS", 8, 9733},
	{"ADNO", 4, 9734},
	{"ZGR", 3, 9735},
	{"LOJ", 3, 9736},
	{"BOMBING", 7, 9737},
	{"DEPENDING", 9, 9738},
	{"ITYP", 4, 9739},
	{"VEDF", 4, 9740},
	{"FLICKR", 6, 9741},
	{"RATIO", 5, 9742},
	{"OKTH", 4, 9743},
	{"ANGLE", 5, 9744},
	{"WNQ", 3, 9745},
	{"SSOL", 4, 9746},
	{"OMEH", 4, 9747},
	{"RGEO", 4, 9748},
	{"EFFICIENT", 9, 9749},
	{"FEELINGS", 8, 9750},
	{"DPOL", 4, 9751},
	{"FANTASY", 7, 9752},
	{"UTDO", 4, 9753},
	{"JAMAICA", 7, 9754},
	{"ORHA", 4, 9755},
	{"ZYP", 3, 9756},
	{"LWY", 3, 9757},
	{"PRIORITIES", 10, 9758},
	{"SGOO", 4, 9759},
	{"BOOKSTORE", 9, 9760},
	{"CYK", 3, 9761},
	{"ELAY", 4, 9762},
	{"LIKED", 5, 9763},
	{"PARENTING", 9, 9764},
	{"PIPE", 4, 9765},
	{"MATH", 4, 9766},
	{"ENEM", 4, 9767},
	{"SCHEME", 6, 9768},
	{"RAPID", 5, 9769},
	{"XSW", 3, 9770},
	{"DENIED", 6, 9771},
	{"GGLE", 4, 9772},
	{"ELYI", 4, 9773},
	{"DCOL", 4, 9774},
	{"FOTOS", 5, 9775},
	{"GTOC", 4, 9776},
	{"EOFE", 4, 9777},
	{"BRITNEY", 7, 9778},
	{"EXAC", 4, 9779},
	{"TSUP", 4, 9780},
	{"FREEWARE", 8, 9781},
	{"NOTF", 4, 9782},
	{"CUSTOM", 6, 9783},
	{"NTPA", 4, 9784},
	{"SCANDAL", 7, 9785},
	{"LSOW", 4, 9786},
	{"DEATHS", 6, 9787},
	{"VULNERABLE", 10, 9788},
	{"INSTITUTIONAL", 13, 9789},
	{"HEWR", 4, 9790},
	{"RIVERS", 6, 9791},
	{"BLADE", 5, 9792},
	{"RTUR", 4, 9793},
	{"TUSE", 4, 9794},
	{"COMMONWEALTH", 12, 9795},
	{"LCOU", 4, 9796},
	{"PHARMACEUTICAL", 14, 9797},
	{"INAW", 4, 9798},
	{"MANHATTAN", 9, 9799},
	{"LYAT", 4, 9800},
	{"TALES", 5, 9801},
	{"RGRO", 4, 9802},
	{"FTWA", 4, 9803},
	{"KATRINA", 7, 9804},
	{"WORKFORCE", 9, 9805},
	{"YCB", 3, 9806},
	{"AZP", 3, 9807},
	{"NDAG", 4, 9808},
	{"NODES", 5, 9809},
	{"EREX", 4, 9810},
	{"ETHC", 4, 9811},
	{"THUMBS", 6, 9812},
	{"SEEDS", 5, 9813},
	{"ADMISSION", 9, 9814},
	{"CITED", 5, 9815},
	{"LITE", 4, 9816},
	{"NTDE", 4, 9817},
	{"NWHA", 4, 9818},
	{"DREL", 4, 9819},
	{"OYY", 3, 9820},
	{"GHZ", 3, 9821},
	{"HUB", 3, 9822},
	{"TARGETED", 8, 9823},
	{"HENF", 4, 9824},
	{"FURTHERMORE", 11, 9825},
	{"SKYPE", 5, 9826},
	{"YEXP", 4, 9827},
	{"REALIZED", 8, 9828},
	{"IBED", 4, 9829},
	{"SRET", 4, 9830},
	{"INCREDIBLE", 10, 9831},
	{"GAMECUBE", 8, 9832},
	{"THAC", 4, 9833},
	{"AIDE", 4, 9834},
	{"SINW", 4, 9835},
	{"CRACK", 5, 9836},
	{"RTHW", 4, 9837},
	{"DRAF", 4, 9838},
	{"IAGE", 4, 9839},
	{"NFOU", 4, 9840},
	{"LOUD", 4, 9841},
	{"TISF", 4, 9842},
	{"PORTUGUESE", 10, 9843},
	{"DIVORCE", 7, 9844},
	{"ANWI", 4, 9845},
	{"TITTEN", 6, 9846},
	{"ADVERSE", 7, 9847},
	{"FABRIC", 6, 9848},
	{"ESCU", 4, 9849},
	{"SURVIVOR", 8, 9850},
	{"EFAL", 4, 9851},
	{"DGRA", 4, 9852},
	{"EXCERPT", 7, 9853},
	{"ADJUSTMENT", 10, 9854},
	{"CONSUME", 7, 9855},
	{"DHES", 4, 9856},
	{"FIGHTER", 7, 9857},
	{"APTU", 4, 9858},
	{"OUPO", 4, 9859},
	{"ASEV", 4, 9860},
	{"SCHOLARSHIP", 11, 9861},
	{"DISCHARGE", 9, 9862},
	{"SMOT", 4, 9863},
	{"AUZ", 3, 9864},
	{"MOUNT", 5, 9865},
	{"GUIDELINE", 9, 9866},
	{"DRINKS", 6, 9867},
	{"VOICES", 6, 9868},
	{"ACUTE", 5, 9869},
	{"OKAT", 4, 9870},
	{"YTOP", 4, 9871},
	{"IEDO", 4, 9872},
	{"HALLOWEEN", 9, 9873},
	{"ORSU", 4, 9874},
	{"ERCL", 4, 9875},
	{"HEEL", 4, 9876},
	{"PROPOSED", 8, 9877},
	{"NSOL", 4, 9878},
	{"NOCT", 4, 9879},
	{"VYG", 3, 9880},
	{"CLIMBING", 8, 9881},
	{"NBEA", 4, 9882},
	{"BLEC", 4, 9883},
	{"STOOD", 5, 9884},
	{"PUBLISHER", 9, 9885},
	{"CHWI", 4, 9886},
	{"YIST", 4, 9887},
	{"PERFUME", 7, 9888},
	{"RANY", 4, 9889},
	{"CAROL", 5, 9890},
	{"SUFFICIENT", 10, 9891},
	{"ALBANY", 6, 9892},
	{"KZA", 3, 9893},
	{"MEMBERSHIP", 10, 9894},
	{"BUTM", 4, 9895},
	{"BYHI", 4, 9896},
	{"ERYC", 4, 9897},
	{"HAZARDOUS", 9, 9898},
	{"YWAY", 4, 9899},
	{"EADM", 4, 9900},
	{"METHODOLOGY", 11, 9901},
	{"TSLI", 4, 9902},
	{"NYMO", 4, 9903},
	{"FTIM", 4, 9904},
	{"HOUSEWARES", 10, 9905},
	{"CTTO", 4, 9906},
	{"RESISTANT", 9, 9907},
	{"DEMOCRATS", 9, 9908},
	{"RECYCLING", 9, 9909},
	{"GBP", 3, 9910},
	{"OURW", 4, 9911},
	{"NSFE", 4, 9912},
	{"CREATOR", 7, 9913},
	{"MENU", 4, 9914},
	{"ONLA", 4, 9915},
	{"AMBER", 5, 9916},
	{"QUALIFICATIONS", 14, 9917},
	{"AWOR", 4, 9918},
	{"ONYO", 4, 9919},
	{"ORGO", 4, 9920},
	{"MUSEUMS", 7, 9921},
	{"OFGR", 4, 9922},
	{"CODING", 6, 9923},
	{"IGQ", 3, 9924},
	{"SLIDESHOW", 9, 9925},
	{"UTSO", 4, 9926},
	{"HEJA", 4, 9927},
	{"EFRI", 4, 9928},
	{"TRACKER", 7, 9929},
	{"LYSU", 4, 9930},
	{"TLYI", 4, 9931},
	{"OFLE", 4, 9932},
	{"SFRE", 4, 9933},
	{"GLOVE", 5, 9934},
	{"RLYI", 4, 9935},
	{"RESERVATION", 11, 9936},
	{"NSUN", 4, 9937},
	{"CELEBRATION", 11, 9938},
	{"INFANT", 6, 9939},
	{"RIFLE", 5, 9940},
	{"RCOL", 4, 9941},
	{"TRANSFERRED", 11, 9942},
	{"PROVIDER", 8, 9943},
	{"SATISFY", 7, 9944},
	{"HIKING", 6, 9945},
	{"UNIFORM", 7, 9946},
	{"OPTE", 4, 9947},
	{"WEWE", 4, 9948},
	{"TSMO", 4, 9949},
	{"HIMI", 4, 9950},
	{"MALL", 4, 9951},
	{"PIERRE", 6, 9952},
	{"JELSOFT", 7, 9953},
	{"HEADSET", 7, 9954},
	{"MEASUREMENT", 11, 9955},
	{"ANSM", 4, 9956},
	{"OAKLAND", 7, 9957},
	{"COLOMBIA", 8, 9958},
	{"BSER", 4, 9959},
	{"WAVES", 5, 9960},
	{"CAMEL", 5, 9961},
	{"LSHA", 4, 9962},
	{"ESBY", 4, 9963},
	{"DISTRIBUTOR", 11, 9964},
	{"LAMPS", 5, 9965},
	{"WSQ", 3, 9966},
	{"HOOD", 4, 9967},
	{"DOWNTOWN", 8, 9968},
	{"SSEM", 4, 9969},
	{"WRESTLING", 9, 9970},
	{"EDUCATE", 7, 9971},
	{"PUBLICLY", 8, 9972},
	{"PPRE", 4, 9973},
	{"ARCHIVED", 8, 9974},
	{"TFIN", 4, 9975},
	{"MAINTENANCE", 11, 9976},
	{"PHOTOSHOP", 9, 9977},
	{"COGNITIVE", 9, 9978},
	{"RMSO", 4, 9979},
	{"SANCTION", 8, 9980},
	{"ORPA", 4, 9981},
	{"CONSUMPTION", 11, 9982},
	{"MYTH", 4, 9983},
	{"STRENGTHEN", 10, 9984},
	{"ZGA", 3, 9985},
	{"ARABIA", 6, 9986},
	{"YNX", 3, 9987},
	{"NDFE", 4, 9988},
	{"MATHEMATICAL", 12, 9989},
	{"EXPLOSION", 9, 9990},
	{"FLAVOR", 6, 9991},
	{"DOMINANT", 8, 9992},
	{"EXTRACT", 7, 9993},
	{"SPECIALIZED", 11, 9994},
	{"DIAGNOSTIC", 10, 9995},
	{"SQUE", 4, 9996},
	{"OFEA", 4, 9997},
	{"PANAMA", 6, 9998},
	{"OWNC", 4, 9999},
	{"CHEF", 4, 10000},
	{"TMIL", 4, 10001},
	{"FRIENDSHIP", 10, 10002},
	{"INDIANAPOLIS", 12, 10003},
	{"ORYT", 4, 10004},
	{"PAYABLE", 7, 10005},
	{"BRIEFLY", 7, 10006},
	{"ASSERT", 6, 10007},
	{"CORPORATIONS", 12, 10008},
	{"COURTESY", 8, 10009},
	{"PSIN", 4, 10010},
	{"ECHU", 4, 10011},
	{"USEU", 4, 10012},
	{"HELPFUL", 7, 10013},
	{"CONFIDENTIAL", 12, 10014},
	{"RFC", 3, 10015},
	{"SCOPE", 5, 10016},
	{"EAOF", 4, 10017},
	{"STATUTORY", 9, 10018},
	{"TAXPAYER", 8, 10019},
	{"ACCOMMODATIONS", 14, 10020},
	{"ATHENS", 6, 10021},
	{"YHEA", 4, 10022},
	{"FPEO", 4, 10023},
	{"WAYI", 4, 10024},
	{"RID", 3, 10025},
	{"CTRO", 4, 10026},
	{"ENBA", 4, 10027},
	{"DOWNLOADED", 10, 10028},
	{"NJUL", 4, 10029},
	{"CRUI", 4, 10030},
	{"SIGH", 4, 10031},
	{"RYAR", 4, 10032},
	{"JUDGES", 6, 10033},
	{"LEMON", 5, 10034},
	{"YBEA", 4, 10035},
	{"REMARKS", 7, 10036},
	{"DETECTED", 8, 10037},
	{"DECADES", 7, 10038},
	{"QUALIFY", 7, 10039},
	{"XYC", 3, 10040},
	{"AZW", 3, 10041},
	{"PAINTINGS", 9, 10042},
	{"WALKED", 6, 10043},
	{"NOFC", 4, 10044},
	{"ARISING", 7, 10045},
	{"CTIM", 4, 10046},
	{"MAYH", 4, 10047},
	{"MPTI", 4, 10048},
	{"TUND", 4, 10049},
	{"NISSAN", 6, 10050},
	{"BRACELET", 8, 10051},
	{"EGGS", 4, 10052},
	{"JUVENILE", 8, 10053},
	{"TSFI", 4, 10054},
	{"OORS", 4, 10055},
	{"GSOM", 4, 10056},
	{"INJECTION", 9, 10057},
	{"TOFW", 4, 10058},
	{"XGE", 3, 10059},
	{"YORKSHIRE", 9, 10060},
	{"POPULATIONS", 11, 10061},
	{"WEALTHY", 7, 10062},
	{"IZIN", 4, 10063},
	{"FETY", 4, 10064},
	{"UFAC", 4, 10065},
	{"CANR", 4, 10066},
	{"RESEMBLE", 8, 10067},
	{"ACOUSTIC", 8, 10068},
	{"TRICK", 5, 10069},
	{"SEQUENCE", 8, 10070},
	{"RAILWAY", 7, 10071},
	{"CASSETTE", 8, 10072},
	{"EEPE", 4, 10073},
	{"YMW", 3, 10074},
	{"TEGR", 4, 10075},
	{"ZYH", 3, 10076},
	{"TRACE", 5, 10077},
	{"COW", 3, 10078},
	{"POINTED", 7, 10079},
	{"SZK", 3, 10080},
	{"JPG", 3, 10081},
	{"DEPENDENT", 9, 10082},
	{"YGOO", 4, 10083},
	{"CAUSING", 7, 10084},
	{"NORTON", 6, 10085},
	{"NTKN", 4, 10086},
	{"LOCKED", 6, 10087},
	{"NOTM", 4, 10088},
	{"CEHE", 4, 10089},
	{"MORTGAGE", 8, 10090},
	{"FUSION", 6, 10091},
	{"EEKI", 4, 10092},
	{"IPAN", 4, 10093},
	{"SUNGLASSES", 10, 10094},
	{"RUBY", 4, 10095},
	{"EDDU", 4, 10096},
	{"SHME", 4, 10097},
	{"GEFO", 4, 10098},
	{"STEERING", 8, 10099},
	{"QUARTERBACK", 11, 10100},
	{"BEADS", 5, 10101},
	{"INBR", 4, 10102},
	{"OVEA", 4, 10103},
	{"VERSUS", 6, 10104},
	{"DETAILED", 8, 10105},
	{"AUTO", 4, 10106},
	{"NSMA", 4, 10107},
	{"YOFC", 4, 10108},
	{"LHIS", 4, 10109},
	{"RDFO", 4, 10110},
	{"MNOT", 4, 10111},
	{"RLYT", 4, 10112},
	{"DEDU", 4, 10113},
	{"VEHE", 4, 10114},
	{"CLAIMED", 7, 10115},
	{"APPOINTMENT", 11, 10116},
	{"RBEC", 4, 10117},
	{"SCREENS", 7, 10118},
	{"CROATIA", 7, 10119},
	{"FLOWS", 5, 10120},
	{"VENEZUELA", 9, 10121},
	{"HELICOPTER", 10, 10122},
	{"PUNISHMENT", 10, 10123},
	{"TENNIS", 6, 10124},
	{"MINS", 4, 10125},
	{"UNFO", 4, 10126},
	{"FLOAT", 5, 10127},
	{"BITE", 4, 10128},
	{"SEQUENCES", 9, 10129},
	{"EFUT", 4, 10130},
	{"COUPON", 6, 10131},
	{"MOTOR", 5, 10132},
	{"CLOSER", 6, 10133},
	{"XYT", 3, 10134},
	{"NURSES", 6, 10135},
	{"LYWE", 4, 10136},
	{"LABORATORY", 10, 10137},
	{"RTOO", 4, 10138},
	{"OODF", 4, 10139},
	{"SGET", 4, 10140},
	{"PROXY", 5, 10141},
	{"INTW", 4, 10142},
	{"ULDG", 4, 10143},
	{"AO00", 4, 10144},
	{"AO01", 4, 10145},
	{"AO02", 4, 10146},
	{"AO03", 4, 10147},
	{"AO04", 4, 10148},
	{"AO05", 4, 10149},
	{"AO06", 4, 10150},
	{"AO07", 4, 10151},
	{"AO08", 4, 10152},
	{"AO09", 4, 10153},
	{"AO10", 4, 10154},
	{"AO11", 4, 10155},
	{"AO12", 4, 10156},
	{"AO13", 4, 10157},
	{"AO14", 4, 10158},
	{"AO15", 4, 10159},
	{"AO16", 4, 10160},
	{"AO17", 4, 10161},
	{"AO18", 4, 10162},
	{"AO19", 4, 10163},
	{"AO20", 4, 10164},
	{"AO21", 4, 10165},
	{"AO22", 4, 10166},
	{"AO23", 4, 10167},
	{"AO24", 4, 10168},
	{"AO25", 4, 10169},
	{"AO26", 4, 10170},
	{"AO27", 4, 10171},
	{"AO28", 4, 10172},
	{"AO29", 4, 10173},
	{"AO30", 4, 10174},
	{"AO31", 4, 10175},
	{"AO32", 4, 10176},
	{"AO33", 4, 10177},
	{"AO34", 4, 10178},
	{"AO35", 4, 10179},
	{"AO36", 4, 10180},
	{"AO37", 4, 10181},
	{"AO38", 4, 10182},
	{"AO39", 4, 10183},
	{"AO40", 4, 10184},
	{"AO41", 4, 10185},
	{"AO42", 4, 10186},
	{"AO43", 4, 10187},
	{"AO44", 4, 10188},
	{"AO45", 4, 10189},
	{"AO46", 4, 10190},
	{"AO47", 4, 10191},
	{"AO48", 4, 10192},
	{"AO49", 4, 10193},
	{"AO50", 4, 10194},
	{"AO51", 4, 10195},
	{"AO52", 4, 10196},
	{"AO53", 4, 10197},
	{"AO54", 4, 10198},
	{"AO55", 4, 10199},
	{"AO56", 4, 10200},
	{"AO57", 4, 10201},
	{"AO58", 4, 10202},
	{"AO59", 4, 10203},
	{"AO60", 4, 10204},
	{"AO61", 4, 10205},
	{"AO62", 4, 10206},
	{"AO63", 4, 10207},
	{"AO64", 4, 10208},
	{"AO65", 4, 10209},
	{"AO66", 4, 10210},
	{"AO67", 4, 10211},
	{"AO68", 4, 10212},
	{"AO69", 4, 10213},
	{"AO70", 4, 10214},
	{"AO71", 4, 10215},
	{"AO72", 4, 10216},
	{"AO73", 4, 10217},
	{"AO74", 4, 10218},
	{"AO75", 4, 10219},
	{"AO76", 4, 10220},
	{"AO77", 4, 10221},
	{"AO78", 4, 10222},
	{"AO79", 4, 10223},
	{"AO80", 4, 10224},
	{"AO81", 4, 10225},
	{"AO82", 4, 10226},
	{"AO83", 4, 10227},
	{"AO84", 4, 10228},
	{"AO85", 4, 10229},
	{"AO86", 4, 10230},
	{"AO87", 4, 10231},
	{"AO88", 4, 10232},
	{"AO89", 4, 10233},
	{"AO90", 4, 10234},
	{"AO91", 4, 10235},
	{"AO92", 4, 10236},
	{"AO93", 4, 10237},
	{"AO94", 4, 10238},
	{"AO95", 4, 10239},
	{"AO96", 4, 10240},
	{"AO97", 4, 10241},
	{"AO98", 4, 10242},
	{"AO99", 4, 10243},
	{"AP00", 4, 10244},
	{"AP01", 4, 10245},
	{"AP02", 4, 10246},
	{"AP03", 4, 10247},
	{"AP04", 4, 10248},
	{"AP05", 4, 10249},
	{"AP06", 4, 10250},
	{"AP07", 4, 10251},
	{"AP08", 4, 10252},
	{"AP09", 4, 10253},
	{"AP10", 4, 10254},
	{"AP11", 4, 10255},
	{"AP12", 4, 10256},
	{"AP13", 4, 10257},
	{"AP14", 4, 10258},
	{"AP15", 4, 10259},
	{"AP16", 4, 10260},
	{"AP17", 4, 10261},
	{"AP18", 4, 10262},
	{"AP19", 4, 10263},
	{"AP20", 4, 10264},
	{"AP21", 4, 10265},
	{"AP22", 4, 10266},
	{"AP23", 4, 10267},
	{"AP24", 4, 10268},
	{"AP25", 4, 10269},
	{"AP26", 4, 10270},
	{"AP27", 4, 10271},
	{"AP28", 4, 10272},
	{"AP29", 4, 10273},
	{"AP30", 4, 10274},
	{"AP31", 4, 10275},
	{"AP32", 4, 10276},
	{"AP33", 4, 10277},
	{"AP34", 4, 10278},
	{"AP35", 4, 10279},
	{"AP36", 4, 10280},
	{"AP37", 4, 10281},
	{"AP38", 4, 10282},
	{"AP39", 4, 10283},
	{"AP40", 4, 10284},
	{"AP41", 4, 10285},
	{"AP42", 4, 10286},
	{"AP43", 4, 10287},
	{"AP44", 4, 10288},
	{"AP45", 4, 10289},
	{"AP46", 4, 10290},
	{"AP47", 4, 10291},
	{"AP48", 4, 10292},
	{"AP49", 4, 10293},
	{"AP50", 4, 10294},
	{"AP51", 4, 10295},
	{"AP52", 4, 10296},
	{"AP53", 4, 10297},
	{"AP54", 4, 10298},
	{"AP55", 4, 10299},
	{"AP56", 4, 10300},
	{"AP57", 4, 10301},
	{"AP58", 4, 10302},
	{"AP59", 4, 10303},
	{"AP60", 4, 10304},
	{"AP61", 4, 10305},
	{"AP62", 4, 10306},
	{"AP63", 4, 10307},
	{"AP64", 4, 10308},
	{"AP65", 4, 10309},
	{"AP66", 4, 10310},
	{"AP67", 4, 10311},
	{"AP68", 4, 10312},
	{"AP69", 4, 10313},
	{"AP70", 4, 10314},
	{"AP71", 4, 10315},
	{"AP72", 4, 10316},
	{"AP73", 4, 10317},
	{"AP74", 4, 10318},
	{"AP75", 4, 10319},
	{"AP76", 4, 10320},
	{"AP77", 4, 10321},
	{"AP78", 4, 10322},
	{"AP79", 4, 10323},
	{"AP80", 4, 10324},
	{"AP81", 4, 10325},
	{"AP82", 4, 10326},
	{"AP83", 4, 10327},
	{"AP84", 4, 10328},
	{"AP85", 4, 10329},
	{"AP86", 4, 10330},
	{"AP87", 4, 10331},
	{"AP88", 4, 10332},
	{"AP89", 4, 10333},
	{"AP90", 4, 10334},
	{"AP91", 4, 10335},
	{"AP92", 4, 10336},
	{"AP93", 4, 10337},
	{"AP94", 4, 10338},
	{"AP95", 4, 10339},
	{"AP96", 4, 10340},
	{"AP97", 4, 10341},
	{"AP98", 4, 10342},
	{"AP99", 4, 10343},
	{"BB00", 4, 10344},
	{"BB01", 4, 10345},
	{"BB02", 4, 10346},
	{"BB03", 4, 10347},
	{"BB04", 4, 10348},
	{"BB05", 4, 10349},
	{"BB06", 4, 10350},
	{"BB07", 4, 10351},
	{"BB08", 4, 10352},
	{"BB09", 4, 10353},
	{"BB10", 4, 10354},
	{"BB11", 4, 10355},
	{"BB12", 4, 10356},
	{"BB13", 4, 10357},
	{"BB14", 4, 10358},
	{"BB15", 4, 10359},
	{"BB16", 4, 10360},
	{"BB17", 4, 10361},
	{"BB18", 4, 10362},
	{"BB19", 4, 10363},
	{"BB20", 4, 10364},
	{"BB21", 4, 10365},
	{"BB22", 4, 10366},
	{"BB23", 4, 10367},
	{"BB24", 4, 10368},
	{"BB25", 4, 10369},
	{"BB26", 4, 10370},
	{"BB27", 4, 10371},
	{"BB28", 4, 10372},
	{"BB29", 4, 10373},
	{"BB30", 4, 10374},
	{"BB31", 4, 10375},
	{"BB32", 4, 10376},
	{"BB33", 4, 10377},
	{"BB34", 4, 10378},
	{"BB35", 4, 10379},
	{"BB36", 4, 10380},
	{"BB37", 4, 10381},
	{"BB38", 4, 10382},
	{"BB39", 4, 10383},
	{"BB40", 4, 10384},
	{"BB41", 4, 10385},
	{"BB42", 4, 10386},
	{"BB43", 4, 10387},
	{"BB44", 4, 10388},
	{"BB45", 4, 10389},
	{"BB46", 4, 10390},
	{"BB47", 4, 10391},
	{"BB48", 4, 10392},
	{"BB49", 4, 10393},
	{"BB50", 4, 10394},
	{"BB51", 4, 10395},
	{"BB52", 4, 10396},
	{"BB53", 4, 10397},
	{"BB54", 4, 10398},
	{"BB55", 4, 10399},
	{"BB56", 4, 10400},
	{"BB57", 4, 10401},
	{"BB58", 4, 10402},
	{"BB59", 4, 10403},
	{"BB60", 4, 10404},
	{"BB61", 4, 10405},
	{"BB62", 4, 10406},
	{"BB63", 4, 10407},
	{"BB64", 4, 10408},
	{"BB65", 4, 10409},
	{"BB66", 4, 10410},
	{"BB67", 4, 10411},
	{"BB68", 4, 10412},
	{"BB69", 4, 10413},
	{"BB70", 4, 10414},
	{"BB71", 4, 10415},
	{"BB72", 4, 10416},
	{"BB73", 4, 10417},
	{"BB74", 4, 10418},
	{"BB75", 4, 10419},
	{"BB76", 4, 10420},
	{"BB77", 4, 10421},
	{"BB78", 4, 10422},
	{"BB79", 4, 10423},
	{"BB80", 4, 10424},
	{"BB81", 4, 10425},
	{"BB82", 4, 10426},
	{"BB83", 4, 10427},
	{"BB84", 4, 10428},
	{"BB85", 4, 10429},
	{"BB86", 4, 10430},
	{"BB87", 4, 10431},
	{"BB88", 4, 10432},
	{"BB89", 4, 10433},
	{"BB90", 4, 10434},
	{"BB91", 4, 10435},
	{"BB92", 4, 10436},
	{"BB93", 4, 10437},
	{"BB94", 4, 10438},
	{"BB95", 4, 10439},
	{"BB96", 4, 10440},
	{"BB97", 4, 10441},
	{"BB98", 4, 10442},
	{"BB99", 4, 10443},
	{"BK00", 4, 10444},
	{"BK01", 4, 10445},
	{"BK02", 4, 10446},
	{"BK03", 4, 10447},
	{"BK04", 4, 10448},
	{"BK05", 4, 10449},
	{"BK06", 4, 10450},
	{"BK07", 4, 10451},
	{"BK08", 4, 10452},
	{"BK09", 4, 10453},
	{"BK10", 4, 10454},
	{"BK11", 4, 10455},
	{"BK12", 4, 10456},
	{"BK13", 4, 10457},
	{"BK14", 4, 10458},
	{"BK15", 4, 10459},
	{"BK16", 4, 10460},
	{"BK17", 4, 10461},
	{"BK18", 4, 10462},
	{"BK19", 4, 10463},
	{"BK20", 4, 10464},
	{"BK21", 4, 10465},
	{"BK22", 4, 10466},
	{"BK23", 4, 10467},
	{"BK24", 4, 10468},
	{"BK25", 4, 10469},
	{"BK26", 4, 10470},
	{"BK27", 4, 10471},
	{"BK28", 4, 10472},
	{"BK29", 4, 10473},
	{"BK30", 4, 10474},
	{"BK31", 4, 10475},
	{"BK32", 4, 10476},
	{"BK33", 4, 10477},
	{"BK34", 4, 10478},
	{"BK35", 4, 10479},
	{"BK36", 4, 10480},
	{"BK37", 4, 10481},
	{"BK38", 4, 10482},
	{"BK39", 4, 10483},
	{"BK40", 4, 10484},
	{"BK41", 4, 10485},
	{"BK42", 4, 10486},
	{"BK43", 4, 10487},
	{"BK44", 4, 10488},
	{"BK45", 4, 10489},
	{"BK46", 4, 10490},
	{"BK47", 4, 10491},
	{"BK48", 4, 10492},
	{"BK49", 4, 10493},
	{"BK50", 4, 10494},
	{"BK51", 4, 10495},
	{"BK52", 4, 10496},
	{"BK53", 4, 10497},
	{"BK54", 4, 10498},
	{"BK55", 4, 10499},
	{"BK56", 4, 10500},
	{"BK57", 4, 10501},
	{"BK58", 4, 10502},
	{"BK59", 4, 10503},
	{"BK60", 4, 10504},
	{"BK61", 4, 10505},
	{"BK62", 4, 10506},
	{"BK63", 4, 10507},
	{"BK64", 4, 10508},
	{"BK65", 4, 10509},
	{"BK66", 4, 10510},
	{"BK67", 4, 10511},
	{"BK68", 4, 10512},
	{"BK69", 4, 10513},
	{"BK70", 4, 10514},
	{"BK71", 4, 10515},
	{"BK72", 4, 10516},
	{"BK73", 4, 10517},
	{"BK74", 4, 10518},
	{"BK75", 4, 10519},
	{"BK76", 4, 10520},
	{"BK77", 4, 10521},
	{"BK78", 4, 10522},
	{"BK79", 4, 10523},
	{"BK80", 4, 10524},
	{"BK81", 4, 10525},
	{"BK82", 4, 10526},
	{"BK83", 4, 10527},
	{"BK84", 4, 10528},
	{"BK85", 4, 10529},
	{"BK86", 4, 10530},
	{"BK87", 4, 10531},
	{"BK88", 4, 10532},
	{"BK89", 4, 10533},
	{"BK90", 4, 10534},
	{"BK91", 4, 10535},
	{"BK92", 4, 10536},
	{"BK93", 4, 10537},
	{"BK94", 4, 10538},
	{"BK95", 4, 10539},
	{"BK96", 4, 10540},
	{"BK97", 4, 10541},
	{"BK98", 4, 10542},
	{"BK99", 4, 10543},
	{"BL00", 4, 10544},
	{"BL01", 4, 10545},
	{"BL02", 4, 10546},
	{"BL03", 4, 10547},
	{"BL04", 4, 10548},
	{"BL05", 4, 10549},
	{"BL06", 4, 10550},
	{"BL07", 4, 10551},
	{"BL08", 4, 10552},
	{"BL09", 4, 10553},
	{"BL10", 4, 10554},
	{"BL11", 4, 10555},
	{"BL12", 4, 10556},
	{"BL13", 4, 10557},
	{"BL14", 4, 10558},
	{"BL15", 4, 10559},
	{"BL16", 4, 10560},
	{"BL17", 4, 10561},
	{"BL18", 4, 10562},
	{"BL19", 4, 10563},
	{"BL20", 4, 10564},
	{"BL21", 4, 10565},
	{"BL22", 4, 10566},
	{"BL23", 4, 10567},
	{"BL24", 4, 10568},
	{"BL25", 4, 10569},
	{"BL26", 4, 10570},
	{"BL27", 4, 10571},
	{"BL28", 4, 10572},
	{"BL29", 4, 10573},
	{"BL30", 4, 10574},
	{"BL31", 4, 10575},
	{"BL32", 4, 10576},
	{"BL33", 4, 10577},
	{"BL34", 4, 10578},
	{"BL35", 4, 10579},
	{"BL36", 4, 10580},
	{"BL37", 4, 10581},
	{"BL38", 4, 10582},
	{"BL39", 4, 10583},
	{"BL40", 4, 10584},
	{"BL41", 4, 10585},
	{"BL42", 4, 10586},
	{"BL43", 4, 10587},
	{"BL44", 4, 10588},
	{"BL45", 4, 10589},
	{"BL46", 4, 10590},
	{"BL47", 4, 10591},
	{"BL48", 4, 10592},
	{"BL49", 4, 10593},
	{"BL50", 4, 10594},
	{"BL51", 4, 10595},
	{"BL52", 4, 10596},
	{"BL53", 4, 10597},
	{"BL54", 4, 10598},
	{"BL55", 4, 10599},
	{"BL56", 4, 10600},
	{"BL57", 4, 10601},
	{"BL58", 4, 10602},
	{"BL59", 4, 10603},
	{"BL60", 4, 10604},
	{"BL61", 4, 10605},
	{"BL62", 4, 10606},
	{"BL63", 4, 10607},
	{"BL64", 4, 10608},
	{"BL65", 4, 10609},
	{"BL66", 4, 10610},
	{"BL67", 4, 10611},
	{"BL68", 4, 10612},
	{"BL69", 4, 10613},
	{"BL70", 4, 10614},
	{"BL71", 4, 10615},
	{"BL72", 4, 10616},
	{"BL73", 4, 10617},
	{"BL74", 4, 10618},
	{"BL75", 4, 10619},
	{"BL76", 4, 10620},
	{"BL77", 4, 10621},
	{"BL78", 4, 10622},
	{"BL79", 4, 10623},
	{"BL80", 4, 10624},
	{"BL81", 4, 10625},
	{"BL82", 4, 10626},
	{"BL83", 4, 10627},
	{"BL84", 4, 10628},
	{"BL85", 4, 10629},
	{"BL86", 4, 10630},
	{"BL87", 4, 10631},
	{"BL88", 4, 10632},
	{"BL89", 4, 10633},
	{"BL90", 4, 10634},
	{"BL91", 4, 10635},
	{"BL92", 4, 10636},
	{"BL93", 4, 10637},
	{"BL94", 4, 10638},
	{"BL95", 4, 10639},
	{"BL96", 4, 10640},
	{"BL97", 4, 10641},
	{"BL98", 4, 10642},
	{"BL99", 4, 10643},
	{"BO00", 4, 10644},
	{"BO01", 4, 10645},
	{"BO02", 4, 10646},
	{"BO03", 4, 10647},
	{"BO04", 4, 10648},
	{"BO05", 4, 10649},
	{"BO06", 4, 10650},
	{"BO07", 4, 10651},
	{"BO08", 4, 10652},
	{"BO09", 4, 10653},
	{"BO10", 4, 10654},
	{"BO11", 4, 10655},
	{"BO12", 4, 10656},
	{"BO13", 4, 10657},
	{"BO14", 4, 10658},
	{"BO15", 4, 10659},
	{"BO16", 4, 10660},
	{"BO17", 4, 10661},
	{"BO18", 4, 10662},
	{"BO19", 4, 10663},
	{"BO20", 4, 10664},
	{"BO21", 4, 10665},
	{"BO22", 4, 10666},
	{"BO23", 4, 10667},
	{"BO24", 4, 10668},
	{"BO25", 4, 10669},
	{"BO26", 4, 10670},
	{"BO27", 4, 10671},
	{"BO28", 4, 10672},
	{"BO29", 4, 10673},
	{"BO30", 4, 10674},
	{"BO31", 4, 10675},
	{"BO32", 4, 10676},
	{"BO33", 4, 10677},
	{"BO34", 4, 10678},
	{"BO35", 4, 10679},
	{"BO36", 4, 10680},
	{"BO37", 4, 10681},
	{"BO38", 4, 10682},
	{"BO39", 4, 10683},
	{"BO40", 4, 10684},
	{"BO41", 4, 10685},
	{"BO42", 4, 10686},
	{"BO43", 4, 10687},
	{"BO44", 4, 10688},
	{"BO45", 4, 10689},
	{"BO46", 4, 10690},
	{"BO47", 4, 10691},
	{"BO48", 4, 10692},
	{"BO49", 4, 10693},
	{"BO50", 4, 10694},
	{"BO51", 4, 10695},
	{"BO52", 4, 10696},
	{"BO53", 4, 10697},
	{"BO54", 4, 10698},
	{"BO55", 4, 10699},
	{"BO56", 4, 10700},
	{"BO57", 4, 10701},
	{"BO58", 4, 10702},
	{"BO59", 4, 10703},
	{"\xa1" /* ¡ - "BO60" */, 1, 10704},
	{"\xbf" /* ¿ - "BO61" */, 1, 10705},
	{"\xc0" /* À - "BO62" */, 1, 10706},
	{"\xc1" /* Á - "BO63" */, 1, 10707},
	{"\xc2" /* Â - "BO64" */, 1, 10708},
	{"\xc3" /* Ã - "BO65" */, 1, 10709},
	{"\xc4" /* Ä - "BO66" */, 1, 10710},
	{"\xc5" /* Å - "BO67" */, 1, 10711},
	{"\xc6" /* Æ - "BO68" */, 1, 10712},
	{"\xc7" /* Ç - "BO69" */, 1, 10713},
	{"\xc8" /* È - "BO70" */, 1, 10714},
	{"\xc9" /* É - "BO71" */, 1, 10715},
	{"\xca" /* Ê - "BO72" */, 1, 10716},
	{"\xcb" /* Ë - "BO73" */, 1, 10717},
	{"\xcc" /* Ì - "BO74" */, 1, 10718},
	{"\xcd" /* Í - "BO75" */, 1, 10719},
	{"\xce" /* Î - "BO76" */, 1, 10720},
	{"\xcf" /* Ï - "BO77" */, 1, 10721},
	{"\xd0" /* Ð - "BO78" */, 1, 10722},
	{"\xd1" /* Ñ - "BO79" */, 1, 10723},
	{"\xd2" /* Ò - "BO80" */, 1, 10724},
	{"\xd3" /* Ó - "BO81" */, 1, 10725},
	{"\xd4" /* Ô - "BO82" */, 1, 10726},
	{"\xd5" /* Õ - "BO83" */, 1, 10727},
	{"\xd6" /* Ö - "BO84" */, 1, 10728},
	{"\xd8" /* Ø - "BO85" */, 1, 10729},
	{"\xd9" /* Ù - "BO86" */, 1, 10730},
	{"\xda" /* Ú - "BO87" */, 1, 10731},
	{"\xdb" /* Û - "BO88" */, 1, 10732},
	{"\xdc" /* Ü - "BO89" */, 1, 10733},
	{"\xdd" /* Ý - "BO90" */, 1, 10734},
	{"\xde" /* Þ - "BO91" */, 1, 10735},
	{"BO92", 4, 10736},
	{"BO93", 4, 10737},
	{"BO94", 4, 10738},
	{"BO95", 4, 10739},
	{"BO96", 4, 10740},
	{"BO97", 4, 10741},
	{"BO98", 4, 10742},
	{"BO99", 4, 10743},
	{"BP00", 4, 10744},
	{"BP01", 4, 10745},
	{"BP02", 4, 10746},
	{"BP03", 4, 10747},
	{"BP04", 4, 10748},
	{"BP05", 4, 10749},
	{"BP06", 4, 10750},
	{"BP07", 4, 10751},
	{"BP08", 4, 10752},
	{"BP09", 4, 10753},
	{"BP10", 4, 10754},
	{"BP11", 4, 10755},
	{"BP12", 4, 10756},
	{"BP13", 4, 10757},
	{"BP14", 4, 10758},
	{"BP15", 4, 10759},
	{"BP16", 4, 10760},
	{"BP17", 4, 10761},
	{"BP18", 4, 10762},
	{"BP19", 4, 10763},
	{"BP20", 4, 10764},
	{"BP21", 4, 10765},
	{"BP22", 4, 10766},
	{"BP23", 4, 10767},
	{"BP24", 4, 10768},
	{"BP25", 4, 10769},
	{"BP26", 4, 10770},
	{"BP27", 4, 10771},
	{"BP28", 4, 10772},
	{"BP29", 4, 10773},
	{"BP30", 4, 10774},
	{"BP31", 4, 10775},
	{"BP32", 4, 10776},
	{"BP33", 4, 10777},
	{"BP34", 4, 10778},
	{"BP35", 4, 10779},
	{"BP36", 4, 10780},
	{"BP37", 4, 10781},
	{"BP38", 4, 10782},
	{"BP39", 4, 10783},
	{"BP40", 4, 10784},
	{"BP41", 4, 10785},
	{"BP42", 4, 10786},
	{"BP43", 4, 10787},
	{"BP44", 4, 10788},
	{"BP45", 4, 10789},
	{"BP46", 4, 10790},
	{"BP47", 4, 10791},
	{"BP48", 4, 10792},
	{"BP49", 4, 10793},
	{"BP50", 4, 10794},
	{"BP51", 4, 10795},
	{"BP52", 4, 10796},
	{"BP53", 4, 10797},
	{"BP54", 4, 10798},
	{"BP55", 4, 10799},
	{"BP56", 4, 10800},
	{"BP57", 4, 10801},
	{"BP58", 4, 10802},
	{"BP59", 4, 10803},
	{"BP60", 4, 10804},
	{"BP61", 4, 10805},
	{"BP62", 4, 10806},
	{"BP63", 4, 10807},
	{"BP64", 4, 10808},
	{"BP65", 4, 10809},
	{"BP66", 4, 10810},
	{"BP67", 4, 10811},
	{"BP68", 4, 10812},
	{"BP69", 4, 10813},
	{"BP70", 4, 10814},
	{"BP71", 4, 10815},
	{"BP72", 4, 10816},
	{"BP73", 4, 10817},
	{"BP74", 4, 10818},
	{"BP75", 4, 10819},
	{"BP76", 4, 10820},
	{"BP77", 4, 10821},
	{"BP78", 4, 10822},
	{"BP79", 4, 10823},
	{"BP80", 4, 10824},
	{"BP81", 4, 10825},
	{"BP82", 4, 10826},
	{"BP83", 4, 10827},
	{"BP84", 4, 10828},
	{"BP85", 4, 10829},
	{"BP86", 4, 10830},
	{"BP87", 4, 10831},
	{"BP88", 4, 10832},
	{"BP89", 4, 10833},
	{"BP90", 4, 10834},
	{"BP91", 4, 10835},
	{"BP92", 4, 10836},
	{"BP93", 4, 10837},
	{"BP94", 4, 10838},
	{"BP95", 4, 10839},
	{"BP96", 4, 10840},
	{"BP97", 4, 10841},
	{"BP98", 4, 10842},
	{"BP99", 4, 10843},
	{"BQ00", 4, 10844},
	{"BQ01", 4, 10845},
	{"BQ02", 4, 10846},
	{"BQ03", 4, 10847},
	{"BQ04", 4, 10848},
	{"BQ05", 4, 10849},
	{"BQ06", 4, 10850},
	{"BQ07", 4, 10851},
	{"BQ08", 4, 10852},
	{"BQ09", 4, 10853},
	{"BQ10", 4, 10854},
	{"BQ11", 4, 10855},
	{"BQ12", 4, 10856},
	{"BQ13", 4, 10857},
	{"BQ14", 4, 10858},
	{"BQ15", 4, 10859},
	{"BQ16", 4, 10860},
	{"BQ17", 4, 10861},
	{"BQ18", 4, 10862},
	{"BQ19", 4, 10863},
	{"BQ20", 4, 10864},
	{"BQ21", 4, 10865},
	{"BQ22", 4, 10866},
	{"BQ23", 4, 10867},
	{"BQ24", 4, 10868},
	{"BQ25", 4, 10869},
	{"BQ26", 4, 10870},
	{"BQ27", 4, 10871},
	{"BQ28", 4, 10872},
	{"BQ29", 4, 10873},
	{"BQ30", 4, 10874},
	{"BQ31", 4, 10875},
	{"BQ32", 4, 10876},
	{"BQ33", 4, 10877},
	{"BQ34", 4, 10878},
	{"BQ35", 4, 10879},
	{"BQ36", 4, 10880},
	{"BQ37", 4, 10881},
	{"BQ38", 4, 10882},
	{"BQ39", 4, 10883},
	{"BQ40", 4, 10884},
	{"BQ41", 4, 10885},
	{"BQ42", 4, 10886},
	{"BQ43", 4, 10887},
	{"BQ44", 4, 10888},
	{"BQ45", 4, 10889},
	{"BQ46", 4, 10890},
	{"BQ47", 4, 10891},
	{"BQ48", 4, 10892},
	{"BQ49", 4, 10893},
	{"BQ50", 4, 10894},
	{"BQ51", 4, 10895},
	{"BQ52", 4, 10896},
	{"BQ53", 4, 10897},
	{"BQ54", 4, 10898},
	{"BQ55", 4, 10899},
	{"BQ56", 4, 10900},
	{"BQ57", 4, 10901},
	{"BQ58", 4, 10902},
	{"BQ59", 4, 10903},
	{"BQ60", 4, 10904},
	{"BQ61", 4, 10905},
	{"BQ62", 4, 10906},
	{"BQ63", 4, 10907},
	{"BQ64", 4, 10908},
	{"BQ65", 4, 10909},
	{"BQ66", 4, 10910},
	{"BQ67", 4, 10911},
	{"BQ68", 4, 10912},
	{"BQ69", 4, 10913},
	{"BQ70", 4, 10914},
	{"BQ71", 4, 10915},
	{"BQ72", 4, 10916},
	{"BQ73", 4, 10917},
	{"BQ74", 4, 10918},
	{"BQ75", 4, 10919},
	{"BQ76", 4, 10920},
	{"BQ77", 4, 10921},
	{"BQ78", 4, 10922},
	{"BQ79", 4, 10923},
	{"BQ80", 4, 10924},
	{"BQ81", 4, 10925},
	{"BQ82", 4, 10926},
	{"BQ83", 4, 10927},
	{"BQ84", 4, 10928},
	{"BQ85", 4, 10929},
	{"BQ86", 4, 10930},
	{"BQ87", 4, 10931},
	{"BQ88", 4, 10932},
	{"BQ89", 4, 10933},
	{"BQ90", 4, 10934},
	{"BQ91", 4, 10935},
	{"BQ92", 4, 10936},
	{"BQ93", 4, 10937},
	{"BQ94", 4, 10938},
	{"BQ95", 4, 10939},
	{"BQ96", 4, 10940},
	{"BQ97", 4, 10941},
	{"BQ98", 4, 10942},
	{"BQ99", 4, 10943},
	{"CB00", 4, 10944},
	{"CB01", 4, 10945},
	{"CB02", 4, 10946},
	{"CB03", 4, 10947},
	{"CB04", 4, 10948},
	{"CB05", 4, 10949},
	{"CB06", 4, 10950},
	{"CB07", 4, 10951},
	{"CB08", 4, 10952},
	{"CB09", 4, 10953},
	{"CB10", 4, 10954},
	{"CB11", 4, 10955},
	{"CB12", 4, 10956},
	{"CB13", 4, 10957},
	{"CB14", 4, 10958},
	{"CB15", 4, 10959},
	{"CB16", 4, 10960},
	{"CB17", 4, 10961},
	{"CB18", 4, 10962},
	{"CB19", 4, 10963},
	{"CB20", 4, 10964},
	{"CB21", 4, 10965},
	{"CB22", 4, 10966},
	{"CB23", 4, 10967},
	{"CB24", 4, 10968},
	{"CB25", 4, 10969},
	{"CB26", 4, 10970},
	{"CB27", 4, 10971},
	{"CB28", 4, 10972},
	{"CB29", 4, 10973},
	{"CB30", 4, 10974},
	{"CB31", 4, 10975},
	{"CB32", 4, 10976},
	{"CB33", 4, 10977},
	{"CB34", 4, 10978},
	{"CB35", 4, 10979},
	{"CB36", 4, 10980},
	{"CB37", 4, 10981},
	{"CB38", 4, 10982},
	{"CB39", 4, 10983},
	{"CB40", 4, 10984},
	{"CB41", 4, 10985},
	{"CB42", 4, 10986},
	{"CB43", 4, 10987},
	{"CB44", 4, 10988},
	{"CB45", 4, 10989},
	{"CB46", 4, 10990},
	{"CB47", 4, 10991},
	{"CB48", 4, 10992},
	{"CB49", 4, 10993},
	{"CB50", 4, 10994},
	{"CB51", 4, 10995},
	{"CB52", 4, 10996},
	{"CB53", 4, 10997},
	{"CB54", 4, 10998},
	{"CB55", 4, 10999},
	{"CB56", 4, 11000},
	{"CB57", 4, 11001},
	{"CB58", 4, 11002},
	{"CB59", 4, 11003},
	{"CB60", 4, 11004},
	{"CB61", 4, 11005},
	{"CB62", 4, 11006},
	{"CB63", 4, 11007},
	{"CB64", 4, 11008},
	{"CB65", 4, 11009},
	{"CB66", 4, 11010},
	{"CB67", 4, 11011},
	{"CB68", 4, 11012},
	{"CB69", 4, 11013},
	{"CB70", 4, 11014},
	{"CB71", 4, 11015},
	{"CB72", 4, 11016},
	{"CB73", 4, 11017},
	{"CB74", 4, 11018},
	{"CB75", 4, 11019},
	{"CB76", 4, 11020},
	{"CB77", 4, 11021},
	{"CB78", 4, 11022},
	{"CB79", 4, 11023},
	{"CB80", 4, 11024},
	{"CB81", 4, 11025},
	{"CB82", 4, 11026},
	{"CB83", 4, 11027},
	{"CB84", 4, 11028},
	{"CB85", 4, 11029},
	{"CB86", 4, 11030},
	{"CB87", 4, 11031},
	{"CB88", 4, 11032},
	{"CB89", 4, 11033},
	{"CB90", 4, 11034},
	{"CB91", 4, 11035},
	{"CB92", 4, 11036},
	{"CB93", 4, 11037},
	{"CB94", 4, 11038},
	{"CB95", 4, 11039},
	{"CB96", 4, 11040},
	{"CB97", 4, 11041},
	{"CB98", 4, 11042},
	{"CB99", 4, 11043},
	{"CM00", 4, 11044},
	{"CM01", 4, 11045},
	{"CM02", 4, 11046},
	{"CM03", 4, 11047},
	{"CM04", 4, 11048},
	{"CM05", 4, 11049},
	{"CM06", 4, 11050},
	{"CM07", 4, 11051},
	{"CM08", 4, 11052},
	{"CM09", 4, 11053},
	{"CM10", 4, 11054},
	{"CM11", 4, 11055},
	{"CM12", 4, 11056},
	{"CM13", 4, 11057},
	{"CM14", 4, 11058},
	{"CM15", 4, 11059},
	{"CM16", 4, 11060},
	{"CM17", 4, 11061},
	{"CM18", 4, 11062},
	{"CM19", 4, 11063},
	{"CM20", 4, 11064},
	{"CM21", 4, 11065},
	{"CM22", 4, 11066},
	{"CM23", 4, 11067},
	{"CM24", 4, 11068},
	{"CM25", 4, 11069},
	{"CM26", 4, 11070},
	{"CM27", 4, 11071},
	{"CM28", 4, 11072},
	{"CM29", 4, 11073},
	{"CM30", 4, 11074},
	{"CM31", 4, 11075},
	{"CM32", 4, 11076},
	{"CM33", 4, 11077},
	{"CM34", 4, 11078},
	{"CM35", 4, 11079},
	{"CM36", 4, 11080},
	{"CM37", 4, 11081},
	{"CM38", 4, 11082},
	{"CM39", 4, 11083},
	{"CM40", 4, 11084},
	{"CM41", 4, 11085},
	{"CM42", 4, 11086},
	{"CM43", 4, 11087},
	{"CM44", 4, 11088},
	{"CM45", 4, 11089},
	{"CM46", 4, 11090},
	{"CM47", 4, 11091},
	{"CM48", 4, 11092},
	{"CM49", 4, 11093},
	{"CM50", 4, 11094},
	{"CM51", 4, 11095},
	{"CM52", 4, 11096},
	{"CM53", 4, 11097},
	{"CM54", 4, 11098},
	{"CM55", 4, 11099},
	{"CM56", 4, 11100},
	{"CM57", 4, 11101},
	{"CM58", 4, 11102},
	{"CM59", 4, 11103},
	{"CM60", 4, 11104},
	{"CM61", 4, 11105},
	{"CM62", 4, 11106},
	{"CM63", 4, 11107},
	{"CM64", 4, 11108},
	{"CM65", 4, 11109},
	{"CM66", 4, 11110},
	{"CM67", 4, 11111},
	{"CM68", 4, 11112},
	{"CM69", 4, 11113},
	{"CM70", 4, 11114},
	{"CM71", 4, 11115},
	{"CM72", 4, 11116},
	{"CM73", 4, 11117},
	{"CM74", 4, 11118},
	{"CM75", 4, 11119},
	{"CM76", 4, 11120},
	{"CM77", 4, 11121},
	{"CM78", 4, 11122},
	{"CM79", 4, 11123},
	{"CM80", 4, 11124},
	{"CM81", 4, 11125},
	{"CM82", 4, 11126},
	{"CM83", 4, 11127},
	{"CM84", 4, 11128},
	{"CM85", 4, 11129},
	{"CM86", 4, 11130},
	{"CM87", 4, 11131},
	{"CM88", 4, 11132},
	{"CM89", 4, 11133},
	{"CM90", 4, 11134},
	{"CM91", 4, 11135},
	{"CM92", 4, 11136},
	{"CM93", 4, 11137},
	{"CM94", 4, 11138},
	{"CM95", 4, 11139},
	{"CM96", 4, 11140},
	{"CM97", 4, 11141},
	{"CM98", 4, 11142},
	{"CM99", 4, 11143},
	{"CN00", 4, 11144},
	{"CN01", 4, 11145},
	{"CN02", 4, 11146},
	{"CN03", 4, 11147},
	{"CN04", 4, 11148},
	{"CN05", 4, 11149},
	{"CN06", 4, 11150},
	{"CN07", 4, 11151},
	{"CN08", 4, 11152},
	{"CN09", 4, 11153},
	{"CN10", 4, 11154},
	{"CN11", 4, 11155},
	{"CN12", 4, 11156},
	{"CN13", 4, 11157},
	{"CN14", 4, 11158},
	{"CN15", 4, 11159},
	{"CN16", 4, 11160},
	{"CN17", 4, 11161},
	{"CN18", 4, 11162},
	{"CN19", 4, 11163},
	{"CN20", 4, 11164},
	{"CN21", 4, 11165},
	{"CN22", 4, 11166},
	{"CN23", 4, 11167},
	{"CN24", 4, 11168},
	{"CN25", 4, 11169},
	{"CN26", 4, 11170},
	{"CN27", 4, 11171},
	{"CN28", 4, 11172},
	{"CN29", 4, 11173},
	{"CN30", 4, 11174},
	{"CN31", 4, 11175},
	{"CN32", 4, 11176},
	{"CN33", 4, 11177},
	{"CN34", 4, 11178},
	{"CN35", 4, 11179},
	{"CN36", 4, 11180},
	{"CN37", 4, 11181},
	{"CN38", 4, 11182},
	{"CN39", 4, 11183},
	{"CN40", 4, 11184},
	{"CN41", 4, 11185},
	{"CN42", 4, 11186},
	{"CN43", 4, 11187},
	{"CN44", 4, 11188},
	{"CN45", 4, 11189},
	{"CN46", 4, 11190},
	{"CN47", 4, 11191},
	{"CN48", 4, 11192},
	{"CN49", 4, 11193},
	{"CN50", 4, 11194},
	{"CN51", 4, 11195},
	{"CN52", 4, 11196},
	{"CN53", 4, 11197},
	{"CN54", 4, 11198},
	{"CN55", 4, 11199},
	{"CN56", 4, 11200},
	{"CN57", 4, 11201},
	{"CN58", 4, 11202},
	{"CN59", 4, 11203},
	{"CN60", 4, 11204},
	{"CN61", 4, 11205},
	{"CN62", 4, 11206},
	{"CN63", 4, 11207},
	{"CN64", 4, 11208},
	{"CN65", 4, 11209},
	{"CN66", 4, 11210},
	{"CN67", 4, 11211},
	{"CN68", 4, 11212},
	{"CN69", 4, 11213},
	{"CN70", 4, 11214},
	{"CN71", 4, 11215},
	{"CN72", 4, 11216},
	{"CN73", 4, 11217},
	{"CN74", 4, 11218},
	{"CN75", 4, 11219},
	{"CN76", 4, 11220},
	{"CN77", 4, 11221},
	{"CN78", 4, 11222},
	{"CN79", 4, 11223},
	{"CN80", 4, 11224},
	{"CN81", 4, 11225},
	{"CN82", 4, 11226},
	{"CN83", 4, 11227},
	{"CN84", 4, 11228},
	{"CN85", 4, 11229},
	{"CN86", 4, 11230},
	{"CN87", 4, 11231},
	{"CN88", 4, 11232},
	{"CN89", 4, 11233},
	{"CN90", 4, 11234},
	{"CN91", 4, 11235},
	{"CN92", 4, 11236},
	{"CN93", 4, 11237},
	{"CN94", 4, 11238},
	{"CN95", 4, 11239},
	{"CN96", 4, 11240},
	{"CN97", 4, 11241},
	{"CN98", 4, 11242},
	{"CN99", 4, 11243},
	{"CO00", 4, 11244},
	{"CO01", 4, 11245},
	{"CO02", 4, 11246},
	{"CO03", 4, 11247},
	{"CO04", 4, 11248},
	{"CO05", 4, 11249},
	{"CO06", 4, 11250},
	{"CO07", 4, 11251},
	{"CO08", 4, 11252},
	{"CO09", 4, 11253},
	{"CO10", 4, 11254},
	{"CO11", 4, 11255},
	{"CO12", 4, 11256},
	{"CO13", 4, 11257},
	{"CO14", 4, 11258},
	{"CO15", 4, 11259},
	{"CO16", 4, 11260},
	{"CO17", 4, 11261},
	{"CO18", 4, 11262},
	{"CO19", 4, 11263},
	{"CO20", 4, 11264},
	{"CO21", 4, 11265},
	{"CO22", 4, 11266},
	{"CO23", 4, 11267},
	{"CO24", 4, 11268},
	{"CO25", 4, 11269},
	{"CO26", 4, 11270},
	{"CO27", 4, 11271},
	{"CO28", 4, 11272},
	{"CO29", 4, 11273},
	{"CO30", 4, 11274},
	{"CO31", 4, 11275},
	{"CO32", 4, 11276},
	{"CO33", 4, 11277},
	{"CO34", 4, 11278},
	{"CO35", 4, 11279},
	{"CO36", 4, 11280},
	{"CO37", 4, 11281},
	{"CO38", 4, 11282},
	{"CO39", 4, 11283},
	{"CO40", 4, 11284},
	{"CO41", 4, 11285},
	{"CO42", 4, 11286},
	{"CO43", 4, 11287},
	{"CO44", 4, 11288},
	{"CO45", 4, 11289},
	{"CO46", 4, 11290},
	{"CO47", 4, 11291},
	{"CO48", 4, 11292},
	{"CO49", 4, 11293},
	{"CO50", 4, 11294},
	{"CO51", 4, 11295},
	{"CO52", 4, 11296},
	{"CO53", 4, 11297},
	{"CO54", 4, 11298},
	{"CO55", 4, 11299},
	{"CO56", 4, 11300},
	{"CO57", 4, 11301},
	{"CO58", 4, 11302},
	{"CO59", 4, 11303},
	{"CO60", 4, 11304},
	{"CO61", 4, 11305},
	{"CO62", 4, 11306},
	{"CO63", 4, 11307},
	{"CO64", 4, 11308},
	{"CO65", 4, 11309},
	{"CO66", 4, 11310},
	{"CO67", 4, 11311},
	{"CO68", 4, 11312},
	{"CO69", 4, 11313},
	{"CO70", 4, 11314},
	{"CO71", 4, 11315},
	{"CO72", 4, 11316},
	{"CO73", 4, 11317},
	{"CO74", 4, 11318},
	{"CO75", 4, 11319},
	{"CO76", 4, 11320},
	{"CO77", 4, 11321},
	{"CO78", 4, 11322},
	{"CO79", 4, 11323},
	{"CO80", 4, 11324},
	{"CO81", 4, 11325},
	{"CO82", 4, 11326},
	{"CO83", 4, 11327},
	{"CO84", 4, 11328},
	{"CO85", 4, 11329},
	{"CO86", 4, 11330},
	{"CO87", 4, 11331},
	{"CO88", 4, 11332},
	{"CO89", 4, 11333},
	{"CO90", 4, 11334},
	{"CO91", 4, 11335},
	{"CO92", 4, 11336},
	{"CO93", 4, 11337},
	{"CO94", 4, 11338},
	{"CO95", 4, 11339},
	{"CO96", 4, 11340},
	{"CO97", 4, 11341},
	{"CO98", 4, 11342},
	{"CO99", 4, 11343},
	{"CP00", 4, 11344},
	{"CP01", 4, 11345},
	{"CP02", 4, 11346},
	{"CP03", 4, 11347},
	{"CP04", 4, 11348},
	{"CP05", 4, 11349},
	{"CP06", 4, 11350},
	{"CP07", 4, 11351},
	{"CP08", 4, 11352},
	{"CP09", 4, 11353},
	{"CP10", 4, 11354},
	{"CP11", 4, 11355},
	{"CP12", 4, 11356},
	{"CP13", 4, 11357},
	{"CP14", 4, 11358},
	{"CP15", 4, 11359},
	{"CP16", 4, 11360},
	{"CP17", 4, 11361},
	{"CP18", 4, 11362},
	{"CP19", 4, 11363},
	{"CP20", 4, 11364},
	{"CP21", 4, 11365},
	{"CP22", 4, 11366},
	{"CP23", 4, 11367},
	{"CP24", 4, 11368},
	{"CP25", 4, 11369},
	{"CP26", 4, 11370},
	{"CP27", 4, 11371},
	{"CP28", 4, 11372},
	{"CP29", 4, 11373},
	{"CP30", 4, 11374},
	{"CP31", 4, 11375},
	{"CP32", 4, 11376},
	{"CP33", 4, 11377},
	{"CP34", 4, 11378},
	{"CP35", 4, 11379},
	{"CP36", 4, 11380},
	{"CP37", 4, 11381},
	{"CP38", 4, 11382},
	{"CP39", 4, 11383},
	{"CP40", 4, 11384},
	{"CP41", 4, 11385},
	{"CP42", 4, 11386},
	{"CP43", 4, 11387},
	{"CP44", 4, 11388},
	{"CP45", 4, 11389},
	{"CP46", 4, 11390},
	{"CP47", 4, 11391},
	{"CP48", 4, 11392},
	{"CP49", 4, 11393},
	{"CP50", 4, 11394},
	{"CP51", 4, 11395},
	{"CP52", 4, 11396},
	{"CP53", 4, 11397},
	{"CP54", 4, 11398},
	{"CP55", 4, 11399},
	{"CP56", 4, 11400},
	{"CP57", 4, 11401},
	{"CP58", 4, 11402},
	{"CP59", 4, 11403},
	{"CP60", 4, 11404},
	{"CP61", 4, 11405},
	{"CP62", 4, 11406},
	{"CP63", 4, 11407},
	{"CP64", 4, 11408},
	{"CP65", 4, 11409},
	{"CP66", 4, 11410},
	{"CP67", 4, 11411},
	{"CP68", 4, 11412},
	{"CP69", 4, 11413},
	{"CP70", 4, 11414},
	{"CP71", 4, 11415},
	{"CP72", 4, 11416},
	{"CP73", 4, 11417},
	{"CP74", 4, 11418},
	{"CP75", 4, 11419},
	{"CP76", 4, 11420},
	{"CP77", 4, 11421},
	{"CP78", 4, 11422},
	{"CP79", 4, 11423},
	{"CP80", 4, 11424},
	{"CP81", 4, 11425},
	{"CP82", 4, 11426},
	{"CP83", 4, 11427},
	{"CP84", 4, 11428},
	{"CP85", 4, 11429},
	{"CP86", 4, 11430},
	{"CP87", 4, 11431},
	{"CP88", 4, 11432},
	{"CP89", 4, 11433},
	{"CP90", 4, 11434},
	{"CP91", 4, 11435},
	{"CP92", 4, 11436},
	{"CP93", 4, 11437},
	{"CP94", 4, 11438},
	{"CP95", 4, 11439},
	{"CP96", 4, 11440},
	{"CP97", 4, 11441},
	{"CP98", 4, 11442},
	{"CP99", 4, 11443},
	{"CQ00", 4, 11444},
	{"CQ01", 4, 11445},
	{"CQ02", 4, 11446},
	{"CQ03", 4, 11447},
	{"CQ04", 4, 11448},
	{"CQ05", 4, 11449},
	{"CQ06", 4, 11450},
	{"CQ07", 4, 11451},
	{"CQ08", 4, 11452},
	{"CQ09", 4, 11453},
	{"CQ10", 4, 11454},
	{"CQ11", 4, 11455},
	{"CQ12", 4, 11456},
	{"CQ13", 4, 11457},
	{"CQ14", 4, 11458},
	{"CQ15", 4, 11459},
	{"CQ16", 4, 11460},
	{"CQ17", 4, 11461},
	{"CQ18", 4, 11462},
	{"CQ19", 4, 11463},
	{"CQ20", 4, 11464},
	{"CQ21", 4, 11465},
	{"CQ22", 4, 11466},
	{"CQ23", 4, 11467},
	{"CQ24", 4, 11468},
	{"CQ25", 4, 11469},
	{"CQ26", 4, 11470},
	{"CQ27", 4, 11471},
	{"CQ28", 4, 11472},
	{"CQ29", 4, 11473},
	{"CQ30", 4, 11474},
	{"CQ31", 4, 11475},
	{"CQ32", 4, 11476},
	{"CQ33", 4, 11477},
	{"CQ34", 4, 11478},
	{"CQ35", 4, 11479},
	{"CQ36", 4, 11480},
	{"CQ37", 4, 11481},
	{"CQ38", 4, 11482},
	{"CQ39", 4, 11483},
	{"CQ40", 4, 11484},
	{"CQ41", 4, 11485},
	{"CQ42", 4, 11486},
	{"CQ43", 4, 11487},
	{"CQ44", 4, 11488},
	{"CQ45", 4, 11489},
	{"CQ46", 4, 11490},
	{"CQ47", 4, 11491},
	{"CQ48", 4, 11492},
	{"CQ49", 4, 11493},
	{"CQ50", 4, 11494},
	{"CQ51", 4, 11495},
	{"CQ52", 4, 11496},
	{"CQ53", 4, 11497},
	{"CQ54", 4, 11498},
	{"CQ55", 4, 11499},
	{"CQ56", 4, 11500},
	{"CQ57", 4, 11501},
	{"CQ58", 4, 11502},
	{"CQ59", 4, 11503},
	{"CQ60", 4, 11504},
	{"CQ61", 4, 11505},
	{"CQ62", 4, 11506},
	{"CQ63", 4, 11507},
	{"CQ64", 4, 11508},
	{"CQ65", 4, 11509},
	{"CQ66", 4, 11510},
	{"CQ67", 4, 11511},
	{"CQ68", 4, 11512},
	{"CQ69", 4, 11513},
	{"CQ70", 4, 11514},
	{"CQ71", 4, 11515},
	{"CQ72", 4, 11516},
	{"CQ73", 4, 11517},
	{"CQ74", 4, 11518},
	{"CQ75", 4, 11519},
	{"CQ76", 4, 11520},
	{"CQ77", 4, 11521},
	{"CQ78", 4, 11522},
	{"CQ79", 4, 11523},
	{"CQ80", 4, 11524},
	{"CQ81", 4, 11525},
	{"CQ82", 4, 11526},
	{"CQ83", 4, 11527},
	{"CQ84", 4, 11528},
	{"CQ85", 4, 11529},
	{"CQ86", 4, 11530},
	{"CQ87", 4, 11531},
	{"CQ88", 4, 11532},
	{"CQ89", 4, 11533},
	{"CQ90", 4, 11534},
	{"CQ91", 4, 11535},
	{"CQ92", 4, 11536},
	{"CQ93", 4, 11537},
	{"CQ94", 4, 11538},
	{"CQ95", 4, 11539},
	{"CQ96", 4, 11540},
	{"CQ97", 4, 11541},
	{"CQ98", 4, 11542},
	{"CQ99", 4, 11543},
	{"DB00", 4, 11544},
	{"DB01", 4, 11545},
	{"DB02", 4, 11546},
	{"DB03", 4, 11547},
	{"DB04", 4, 11548},
	{"DB05", 4, 11549},
	{"DB06", 4, 11550},
	{"DB07", 4, 11551},
	{"DB08", 4, 11552},
	{"DB09", 4, 11553},
	{"DB10", 4, 11554},
	{"DB11", 4, 11555},
	{"DB12", 4, 11556},
	{"DB13", 4, 11557},
	{"DB14", 4, 11558},
	{"DB15", 4, 11559},
	{"DB16", 4, 11560},
	{"DB17", 4, 11561},
	{"DB18", 4, 11562},
	{"DB19", 4, 11563},
	{"DB20", 4, 11564},
	{"DB21", 4, 11565},
	{"DB22", 4, 11566},
	{"DB23", 4, 11567},
	{"DB24", 4, 11568},
	{"DB25", 4, 11569},
	{"DB26", 4, 11570},
	{"DB27", 4, 11571},
	{"DB28", 4, 11572},
	{"DB29", 4, 11573},
	{"DB30", 4, 11574},
	{"DB31", 4, 11575},
	{"DB32", 4, 11576},
	{"DB33", 4, 11577},
	{"DB34", 4, 11578},
	{"DB35", 4, 11579},
	{"DB36", 4, 11580},
	{"DB37", 4, 11581},
	{"DB38", 4, 11582},
	{"DB39", 4, 11583},
	{"DB40", 4, 11584},
	{"DB41", 4, 11585},
	{"DB42", 4, 11586},
	{"DB43", 4, 11587},
	{"DB44", 4, 11588},
	{"DB45", 4, 11589},
	{"DB46", 4, 11590},
	{"DB47", 4, 11591},
	{"DB48", 4, 11592},
	{"DB49", 4, 11593},
	{"DB50", 4, 11594},
	{"DB51", 4, 11595},
	{"DB52", 4, 11596},
	{"DB53", 4, 11597},
	{"DB54", 4, 11598},
	{"DB55", 4, 11599},
	{"DB56", 4, 11600},
	{"DB57", 4, 11601},
	{"DB58", 4, 11602},
	{"DB59", 4, 11603},
	{"DB60", 4, 11604},
	{"DB61", 4, 11605},
	{"DB62", 4, 11606},
	{"DB63", 4, 11607},
	{"DB64", 4, 11608},
	{"DB65", 4, 11609},
	{"DB66", 4, 11610},
	{"DB67", 4, 11611},
	{"DB68", 4, 11612},
	{"DB69", 4, 11613},
	{"DB70", 4, 11614},
	{"DB71", 4, 11615},
	{"DB72", 4, 11616},
	{"DB73", 4, 11617},
	{"DB74", 4, 11618},
	{"DB75", 4, 11619},
	{"DB76", 4, 11620},
	{"DB77", 4, 11621},
	{"DB78", 4, 11622},
	{"DB79", 4, 11623},
	{"DB80", 4, 11624},
	{"DB81", 4, 11625},
	{"DB82", 4, 11626},
	{"DB83", 4, 11627},
	{"DB84", 4, 11628},
	{"DB85", 4, 11629},
	{"DB86", 4, 11630},
	{"DB87", 4, 11631},
	{"DB88", 4, 11632},
	{"DB89", 4, 11633},
	{"DB90", 4, 11634},
	{"DB91", 4, 11635},
	{"DB92", 4, 11636},
	{"DB93", 4, 11637},
	{"DB94", 4, 11638},
	{"DB95", 4, 11639},
	{"DB96", 4, 11640},
	{"DB97", 4, 11641},
	{"DB98", 4, 11642},
	{"DB99", 4, 11643},
	{"DK00", 4, 11644},
	{"DK01", 4, 11645},
	{"DK02", 4, 11646},
	{"DK03", 4, 11647},
	{"DK04", 4, 11648},
	{"DK05", 4, 11649},
	{"DK06", 4, 11650},
	{"DK07", 4, 11651},
	{"DK08", 4, 11652},
	{"DK09", 4, 11653},
	{"DK10", 4, 11654},
	{"DK11", 4, 11655},
	{"DK12", 4, 11656},
	{"DK13", 4, 11657},
	{"DK14", 4, 11658},
	{"DK15", 4, 11659},
	{"DK16", 4, 11660},
	{"DK17", 4, 11661},
	{"DK18", 4, 11662},
	{"DK19", 4, 11663},
	{"DK20", 4, 11664},
	{"DK21", 4, 11665},
	{"DK22", 4, 11666},
	{"DK23", 4, 11667},
	{"DK24", 4, 11668},
	{"DK25", 4, 11669},
	{"DK26", 4, 11670},
	{"DK27", 4, 11671},
	{"DK28", 4, 11672},
	{"DK29", 4, 11673},
	{"DK30", 4, 11674},
	{"DK31", 4, 11675},
	{"DK32", 4, 11676},
	{"DK33", 4, 11677},
	{"DK34", 4, 11678},
	{"DK35", 4, 11679},
	{"DK36", 4, 11680},
	{"DK37", 4, 11681},
	{"DK38", 4, 11682},
	{"DK39", 4, 11683},
	{"DK40", 4, 11684},
	{"DK41", 4, 11685},
	{"DK42", 4, 11686},
	{"DK43", 4, 11687},
	{"DK44", 4, 11688},
	{"DK45", 4, 11689},
	{"DK46", 4, 11690},
	{"DK47", 4, 11691},
	{"DK48", 4, 11692},
	{"DK49", 4, 11693},
	{"DK50", 4, 11694},
	{"DK51", 4, 11695},
	{"DK52", 4, 11696},
	{"DK53", 4, 11697},
	{"DK54", 4, 11698},
	{"DK55", 4, 11699},
	{"DK56", 4, 11700},
	{"DK57", 4, 11701},
	{"DK58", 4, 11702},
	{"DK59", 4, 11703},
	{"DK60", 4, 11704},
	{"DK61", 4, 11705},
	{"DK62", 4, 11706},
	{"DK63", 4, 11707},
	{"DK64", 4, 11708},
	{"DK65", 4, 11709},
	{"DK66", 4, 11710},
	{"DK67", 4, 11711},
	{"DK68", 4, 11712},
	{"DK69", 4, 11713},
	{"DK70", 4, 11714},
	{"DK71", 4, 11715},
	{"DK72", 4, 11716},
	{"DK73", 4, 11717},
	{"DK74", 4, 11718},
	{"DK75", 4, 11719},
	{"DK76", 4, 11720},
	{"DK77", 4, 11721},
	{"DK78", 4, 11722},
	{"DK79", 4, 11723},
	{"DK80", 4, 11724},
	{"DK81", 4, 11725},
	{"DK82", 4, 11726},
	{"DK83", 4, 11727},
	{"DK84", 4, 11728},
	{"DK85", 4, 11729},
	{"DK86", 4, 11730},
	{"DK87", 4, 11731},
	{"DK88", 4, 11732},
	{"DK89", 4, 11733},
	{"DK90", 4, 11734},
	{"DK91", 4, 11735},
	{"DK92", 4, 11736},
	{"DK93", 4, 11737},
	{"DK94", 4, 11738},
	{"DK95", 4, 11739},
	{"DK96", 4, 11740},
	{"DK97", 4, 11741},
	{"DK98", 4, 11742},
	{"DK99", 4, 11743},
	{"DL00", 4, 11744},
	{"DL01", 4, 11745},
	{"DL02", 4, 11746},
	{"DL03", 4, 11747},
	{"DL04", 4, 11748},
	{"DL05", 4, 11749},
	{"DL06", 4, 11750},
	{"DL07", 4, 11751},
	{"DL08", 4, 11752},
	{"DL09", 4, 11753},
	{"DL10", 4, 11754},
	{"DL11", 4, 11755},
	{"DL12", 4, 11756},
	{"DL13", 4, 11757},
	{"DL14", 4, 11758},
	{"DL15", 4, 11759},
	{"DL16", 4, 11760},
	{"DL17", 4, 11761},
	{"DL18", 4, 11762},
	{"DL19", 4, 11763},
	{"DL20", 4, 11764},
	{"DL21", 4, 11765},
	{"DL22", 4, 11766},
	{"DL23", 4, 11767},
	{"DL24", 4, 11768},
	{"DL25", 4, 11769},
	{"DL26", 4, 11770},
	{"DL27", 4, 11771},
	{"DL28", 4, 11772},
	{"DL29", 4, 11773},
	{"DL30", 4, 11774},
	{"DL31", 4, 11775},
	{"DL32", 4, 11776},
	{"DL33", 4, 11777},
	{"DL34", 4, 11778},
	{"DL35", 4, 11779},
	{"DL36", 4, 11780},
	{"DL37", 4, 11781},
	{"DL38", 4, 11782},
	{"DL39", 4, 11783},
	{"DL40", 4, 11784},
	{"DL41", 4, 11785},
	{"DL42", 4, 11786},
	{"DL43", 4, 11787},
	{"DL44", 4, 11788},
	{"DL45", 4, 11789},
	{"DL46", 4, 11790},
	{"DL47", 4, 11791},
	{"DL48", 4, 11792},
	{"DL49", 4, 11793},
	{"DL50", 4, 11794},
	{"DL51", 4, 11795},
	{"DL52", 4, 11796},
	{"DL53", 4, 11797},
	{"DL54", 4, 11798},
	{"DL55", 4, 11799},
	{"DL56", 4, 11800},
	{"DL57", 4, 11801},
	{"DL58", 4, 11802},
	{"DL59", 4, 11803},
	{"DL60", 4, 11804},
	{"DL61", 4, 11805},
	{"DL62", 4, 11806},
	{"DL63", 4, 11807},
	{"DL64", 4, 11808},
	{"DL65", 4, 11809},
	{"DL66", 4, 11810},
	{"DL67", 4, 11811},
	{"DL68", 4, 11812},
	{"DL69", 4, 11813},
	{"DL70", 4, 11814},
	{"DL71", 4, 11815},
	{"DL72", 4, 11816},
	{"DL73", 4, 11817},
	{"DL74", 4, 11818},
	{"DL75", 4, 11819},
	{"DL76", 4, 11820},
	{"DL77", 4, 11821},
	{"DL78", 4, 11822},
	{"DL79", 4, 11823},
	{"DL80", 4, 11824},
	{"DL81", 4, 11825},
	{"DL82", 4, 11826},
	{"DL83", 4, 11827},
	{"DL84", 4, 11828},
	{"DL85", 4, 11829},
	{"DL86", 4, 11830},
	{"DL87", 4, 11831},
	{"DL88", 4, 11832},
	{"DL89", 4, 11833},
	{"DL90", 4, 11834},
	{"DL91", 4, 11835},
	{"DL92", 4, 11836},
	{"DL93", 4, 11837},
	{"DL94", 4, 11838},
	{"DL95", 4, 11839},
	{"DL96", 4, 11840},
	{"DL97", 4, 11841},
	{"DL98", 4, 11842},
	{"DL99", 4, 11843},
	{"DM00", 4, 11844},
	{"DM01", 4, 11845},
	{"DM02", 4, 11846},
	{"DM03", 4, 11847},
	{"DM04", 4, 11848},
	{"DM05", 4, 11849},
	{"DM06", 4, 11850},
	{"DM07", 4, 11851},
	{"DM08", 4, 11852},
	{"DM09", 4, 11853},
	{"DM10", 4, 11854},
	{"DM11", 4, 11855},
	{"DM12", 4, 11856},
	{"DM13", 4, 11857},
	{"DM14", 4, 11858},
	{"DM15", 4, 11859},
	{"DM16", 4, 11860},
	{"DM17", 4, 11861},
	{"DM18", 4, 11862},
	{"DM19", 4, 11863},
	{"DM20", 4, 11864},
	{"DM21", 4, 11865},
	{"DM22", 4, 11866},
	{"DM23", 4, 11867},
	{"DM24", 4, 11868},
	{"DM25", 4, 11869},
	{"DM26", 4, 11870},
	{"DM27", 4, 11871},
	{"DM28", 4, 11872},
	{"DM29", 4, 11873},
	{"DM30", 4, 11874},
	{"DM31", 4, 11875},
	{"DM32", 4, 11876},
	{"DM33", 4, 11877},
	{"DM34", 4, 11878},
	{"DM35", 4, 11879},
	{"DM36", 4, 11880},
	{"DM37", 4, 11881},
	{"DM38", 4, 11882},
	{"DM39", 4, 11883},
	{"DM40", 4, 11884},
	{"DM41", 4, 11885},
	{"DM42", 4, 11886},
	{"DM43", 4, 11887},
	{"DM44", 4, 11888},
	{"DM45", 4, 11889},
	{"DM46", 4, 11890},
	{"DM47", 4, 11891},
	{"DM48", 4, 11892},
	{"DM49", 4, 11893},
	{"DM50", 4, 11894},
	{"DM51", 4, 11895},
	{"DM52", 4, 11896},
	{"DM53", 4, 11897},
	{"DM54", 4, 11898},
	{"DM55", 4, 11899},
	{"DM56", 4, 11900},
	{"DM57", 4, 11901},
	{"DM58", 4, 11902},
	{"DM59", 4, 11903},
	{"DM60", 4, 11904},
	{"DM61", 4, 11905},
	{"DM62", 4, 11906},
	{"DM63", 4, 11907},
	{"DM64", 4, 11908},
	{"DM65", 4, 11909},
	{"DM66", 4, 11910},
	{"DM67", 4, 11911},
	{"DM68", 4, 11912},
	{"DM69", 4, 11913},
	{"DM70", 4, 11914},
	{"DM71", 4, 11915},
	{"DM72", 4, 11916},
	{"DM73", 4, 11917},
	{"DM74", 4, 11918},
	{"DM75", 4, 11919},
	{"DM76", 4, 11920},
	{"DM77", 4, 11921},
	{"DM78", 4, 11922},
	{"DM79", 4, 11923},
	{"DM80", 4, 11924},
	{"DM81", 4, 11925},
	{"DM82", 4, 11926},
	{"DM83", 4, 11927},
	{"DM84", 4, 11928},
	{"DM85", 4, 11929},
	{"DM86", 4, 11930},
	{"DM87", 4, 11931},
	{"DM88", 4, 11932},
	{"DM89", 4, 11933},
	{"DM90", 4, 11934},
	{"DM91", 4, 11935},
	{"DM92", 4, 11936},
	{"DM93", 4, 11937},
	{"DM94", 4, 11938},
	{"DM95", 4, 11939},
	{"DM96", 4, 11940},
	{"DM97", 4, 11941},
	{"DM98", 4, 11942},
	{"DM99", 4, 11943},
	{"DN00", 4, 11944},
	{"DN01", 4, 11945},
	{"DN02", 4, 11946},
	{"DN03", 4, 11947},
	{"DN04", 4, 11948},
	{"DN05", 4, 11949},
	{"DN06", 4, 11950},
	{"DN07", 4, 11951},
	{"DN08", 4, 11952},
	{"DN09", 4, 11953},
	{"DN10", 4, 11954},
	{"DN11", 4, 11955},
	{"DN12", 4, 11956},
	{"DN13", 4, 11957},
	{"DN14", 4, 11958},
	{"DN15", 4, 11959},
	{"DN16", 4, 11960},
	{"DN17", 4, 11961},
	{"DN18", 4, 11962},
	{"DN19", 4, 11963},
	{"DN20", 4, 11964},
	{"DN21", 4, 11965},
	{"DN22", 4, 11966},
	{"DN23", 4, 11967},
	{"DN24", 4, 11968},
	{"DN25", 4, 11969},
	{"DN26", 4, 11970},
	{"DN27", 4, 11971},
	{"DN28", 4, 11972},
	{"DN29", 4, 11973},
	{"DN30", 4, 11974},
	{"DN31", 4, 11975},
	{"DN32", 4, 11976},
	{"DN33", 4, 11977},
	{"DN34", 4, 11978},
	{"DN35", 4, 11979},
	{"DN36", 4, 11980},
	{"DN37", 4, 11981},
	{"DN38", 4, 11982},
	{"DN39", 4, 11983},
	{"DN40", 4, 11984},
	{"DN41", 4, 11985},
	{"DN42", 4, 11986},
	{"DN43", 4, 11987},
	{"DN44", 4, 11988},
	{"DN45", 4, 11989},
	{"DN46", 4, 11990},
	{"DN47", 4, 11991},
	{"DN48", 4, 11992},
	{"DN49", 4, 11993},
	{"DN50", 4, 11994},
	{"DN51", 4, 11995},
	{"DN52", 4, 11996},
	{"DN53", 4, 11997},
	{"DN54", 4, 11998},
	{"DN55", 4, 11999},
	{"DN56", 4, 12000},
	{"DN57", 4, 12001},
	{"DN58", 4, 12002},
	{"DN59", 4, 12003},
	{"DN60", 4, 12004},
	{"DN61", 4, 12005},
	{"DN62", 4, 12006},
	{"DN63", 4, 12007},
	{"DN64", 4, 12008},
	{"DN65", 4, 12009},
	{"DN66", 4, 12010},
	{"DN67", 4, 12011},
	{"DN68", 4, 12012},
	{"DN69", 4, 12013},
	{"DN70", 4, 12014},
	{"DN71", 4, 12015},
	{"DN72", 4, 12016},
	{"DN73", 4, 12017},
	{"DN74", 4, 12018},
	{"DN75", 4, 12019},
	{"DN76", 4, 12020},
	{"DN77", 4, 12021},
	{"DN78", 4, 12022},
	{"DN79", 4, 12023},
	{"DN80", 4, 12024},
	{"DN81", 4, 12025},
	{"DN82", 4, 12026},
	{"DN83", 4, 12027},
	{"DN84", 4, 12028},
	{"DN85", 4, 12029},
	{"DN86", 4, 12030},
	{"DN87", 4, 12031},
	{"DN88", 4, 12032},
	{"DN89", 4, 12033},
	{"DN90", 4, 12034},
	{"DN91", 4, 12035},
	{"DN92", 4, 12036},
	{"DN93", 4, 12037},
	{"DN94", 4, 12038},
	{"DN95", 4, 12039},
	{"DN96", 4, 12040},
	{"DN97", 4, 12041},
	{"DN98", 4, 12042},
	{"DN99", 4, 12043},
	{"DO00", 4, 12044},
	{"DO01", 4, 12045},
	{"DO02", 4, 12046},
	{"DO03", 4, 12047},
	{"DO04", 4, 12048},
	{"DO05", 4, 12049},
	{"DO06", 4, 12050},
	{"DO07", 4, 12051},
	{"DO08", 4, 12052},
	{"DO09", 4, 12053},
	{"DO10", 4, 12054},
	{"DO11", 4, 12055},
	{"DO12", 4, 12056},
	{"DO13", 4, 12057},
	{"DO14", 4, 12058},
	{"DO15", 4, 12059},
	{"DO16", 4, 12060},
	{"DO17", 4, 12061},
	{"DO18", 4, 12062},
	{"DO19", 4, 12063},
	{"DO20", 4, 12064},
	{"DO21", 4, 12065},
	{"DO22", 4, 12066},
	{"DO23", 4, 12067},
	{"DO24", 4, 12068},
	{"DO25", 4, 12069},
	{"DO26", 4, 12070},
	{"DO27", 4, 12071},
	{"DO28", 4, 12072},
	{"DO29", 4, 12073},
	{"DO30", 4, 12074},
	{"DO31", 4, 12075},
	{"DO32", 4, 12076},
	{"DO33", 4, 12077},
	{"DO34", 4, 12078},
	{"DO35", 4, 12079},
	{"DO36", 4, 12080},
	{"DO37", 4, 12081},
	{"DO38", 4, 12082},
	{"DO39", 4, 12083},
	{"DO40", 4, 12084},
	{"DO41", 4, 12085},
	{"DO42", 4, 12086},
	{"DO43", 4, 12087},
	{"DO44", 4, 12088},
	{"DO45", 4, 12089},
	{"DO46", 4, 12090},
	{"DO47", 4, 12091},
	{"DO48", 4, 12092},
	{"DO49", 4, 12093},
	{"DO50", 4, 12094},
	{"DO51", 4, 12095},
	{"DO52", 4, 12096},
	{"DO53", 4, 12097},
	{"DO54", 4, 12098},
	{"DO55", 4, 12099},
	{"DO56", 4, 12100},
	{"DO57", 4, 12101},
	{"DO58", 4, 12102},
	{"DO59", 4, 12103},
	{"DO60", 4, 12104},
	{"DO61", 4, 12105},
	{"DO62", 4, 12106},
	{"DO63", 4, 12107},
	{"DO64", 4, 12108},
	{"DO65", 4, 12109},
	{"DO66", 4, 12110},
	{"DO67", 4, 12111},
	{"DO68", 4, 12112},
	{"DO69", 4, 12113},
	{"DO70", 4, 12114},
	{"DO71", 4, 12115},
	{"DO72", 4, 12116},
	{"DO73", 4, 12117},
	{"DO74", 4, 12118},
	{"DO75", 4, 12119},
	{"DO76", 4, 12120},
	{"DO77", 4, 12121},
	{"DO78", 4, 12122},
	{"DO79", 4, 12123},
	{"DO80", 4, 12124},
	{"DO81", 4, 12125},
	{"DO82", 4, 12126},
	{"DO83", 4, 12127},
	{"DO84", 4, 12128},
	{"DO85", 4, 12129},
	{"DO86", 4, 12130},
	{"DO87", 4, 12131},
	{"DO88", 4, 12132},
	{"DO89", 4, 12133},
	{"DO90", 4, 12134},
	{"DO91", 4, 12135},
	{"DO92", 4, 12136},
	{"DO93", 4, 12137},
	{"DO94", 4, 12138},
	{"DO95", 4, 12139},
	{"DO96", 4, 12140},
	{"DO97", 4, 12141},
	{"DO98", 4, 12142},
	{"DO99", 4, 12143},
	{"DP00", 4, 12144},
	{"DP01", 4, 12145},
	{"DP02", 4, 12146},
	{"DP03", 4, 12147},
	{"DP04", 4, 12148},
	{"DP05", 4, 12149},
	{"DP06", 4, 12150},
	{"DP07", 4, 12151},
	{"DP08", 4, 12152},
	{"DP09", 4, 12153},
	{"DP10", 4, 12154},
	{"DP11", 4, 12155},
	{"DP12", 4, 12156},
	{"DP13", 4, 12157},
	{"DP14", 4, 12158},
	{"DP15", 4, 12159},
	{"DP16", 4, 12160},
	{"DP17", 4, 12161},
	{"DP18", 4, 12162},
	{"DP19", 4, 12163},
	{"DP20", 4, 12164},
	{"DP21", 4, 12165},
	{"DP22", 4, 12166},
	{"DP23", 4, 12167},
	{"DP24", 4, 12168},
	{"DP25", 4, 12169},
	{"DP26", 4, 12170},
	{"DP27", 4, 12171},
	{"DP28", 4, 12172},
	{"DP29", 4, 12173},
	{"DP30", 4, 12174},
	{"DP31", 4, 12175},
	{"DP32", 4, 12176},
	{"DP33", 4, 12177},
	{"DP34", 4, 12178},
	{"DP35", 4, 12179},
	{"DP36", 4, 12180},
	{"DP37", 4, 12181},
	{"DP38", 4, 12182},
	{"DP39", 4, 12183},
	{"DP40", 4, 12184},
	{"DP41", 4, 12185},
	{"DP42", 4, 12186},
	{"DP43", 4, 12187},
	{"DP44", 4, 12188},
	{"DP45", 4, 12189},
	{"DP46", 4, 12190},
	{"DP47", 4, 12191},
	{"DP48", 4, 12192},
	{"DP49", 4, 12193},
	{"DP50", 4, 12194},
	{"DP51", 4, 12195},
	{"DP52", 4, 12196},
	{"DP53", 4, 12197},
	{"DP54", 4, 12198},
	{"DP55", 4, 12199},
	{"DP56", 4, 12200},
	{"DP57", 4, 12201},
	{"DP58", 4, 12202},
	{"DP59", 4, 12203},
	{"DP60", 4, 12204},
	{"DP61", 4, 12205},
	{"DP62", 4, 12206},
	{"DP63", 4, 12207},
	{"DP64", 4, 12208},
	{"DP65", 4, 12209},
	{"DP66", 4, 12210},
	{"DP67", 4, 12211},
	{"DP68", 4, 12212},
	{"DP69", 4, 12213},
	{"DP70", 4, 12214},
	{"DP71", 4, 12215},
	{"DP72", 4, 12216},
	{"DP73", 4, 12217},
	{"DP74", 4, 12218},
	{"DP75", 4, 12219},
	{"DP76", 4, 12220},
	{"DP77", 4, 12221},
	{"DP78", 4, 12222},
	{"DP79", 4, 12223},
	{"DP80", 4, 12224},
	{"DP81", 4, 12225},
	{"DP82", 4, 12226},
	{"DP83", 4, 12227},
	{"DP84", 4, 12228},
	{"DP85", 4, 12229},
	{"DP86", 4, 12230},
	{"DP87", 4, 12231},
	{"DP88", 4, 12232},
	{"DP89", 4, 12233},
	{"DP90", 4, 12234},
	{"DP91", 4, 12235},
	{"DP92", 4, 12236},
	{"DP93", 4, 12237},
	{"DP94", 4, 12238},
	{"DP95", 4, 12239},
	{"DP96", 4, 12240},
	{"DP97", 4, 12241},
	{"DP98", 4, 12242},
	{"DP99", 4, 12243},
	{"DQ00", 4, 12244},
	{"DQ01", 4, 12245},
	{"DQ02", 4, 12246},
	{"DQ03", 4, 12247},
	{"DQ04", 4, 12248},
	{"DQ05", 4, 12249},
	{"DQ06", 4, 12250},
	{"DQ07", 4, 12251},
	{"DQ08", 4, 12252},
	{"DQ09", 4, 12253},
	{"DQ10", 4, 12254},
	{"DQ11", 4, 12255},
	{"DQ12", 4, 12256},
	{"DQ13", 4, 12257},
	{"DQ14", 4, 12258},
	{"DQ15", 4, 12259},
	{"DQ16", 4, 12260},
	{"DQ17", 4, 12261},
	{"DQ18", 4, 12262},
	{"DQ19", 4, 12263},
	{"DQ20", 4, 12264},
	{"DQ21", 4, 12265},
	{"DQ22", 4, 12266},
	{"DQ23", 4, 12267},
	{"DQ24", 4, 12268},
	{"DQ25", 4, 12269},
	{"DQ26", 4, 12270},
	{"DQ27", 4, 12271},
	{"DQ28", 4, 12272},
	{"DQ29", 4, 12273},
	{"DQ30", 4, 12274},
	{"DQ31", 4, 12275},
	{"DQ32", 4, 12276},
	{"DQ33", 4, 12277},
	{"DQ34", 4, 12278},
	{"DQ35", 4, 12279},
	{"DQ36", 4, 12280},
	{"DQ37", 4, 12281},
	{"DQ38", 4, 12282},
	{"DQ39", 4, 12283},
	{"DQ40", 4, 12284},
	{"DQ41", 4, 12285},
	{"DQ42", 4, 12286},
	{"DQ43", 4, 12287},
	{"DQ44", 4, 12288},
	{"DQ45", 4, 12289},
	{"DQ46", 4, 12290},
	{"DQ47", 4, 12291},
	{"DQ48", 4, 12292},
	{"DQ49", 4, 12293},
	{"DQ50", 4, 12294},
	{"DQ51", 4, 12295},
	{"DQ52", 4, 12296},
	{"DQ53", 4, 12297},
	{"DQ54", 4, 12298},
	{"DQ55", 4, 12299},
	{"DQ56", 4, 12300},
	{"DQ57", 4, 12301},
	{"DQ58", 4, 12302},
	{"DQ59", 4, 12303},
	{"DQ60", 4, 12304},
	{"DQ61", 4, 12305},
	{"DQ62", 4, 12306},
	{"DQ63", 4, 12307},
	{"DQ64", 4, 12308},
	{"DQ65", 4, 12309},
	{"DQ66", 4, 12310},
	{"DQ67", 4, 12311},
	{"DQ68", 4, 12312},
	{"DQ69", 4, 12313},
	{"DQ70", 4, 12314},
	{"DQ71", 4, 12315},
	{"DQ72", 4, 12316},
	{"DQ73", 4, 12317},
	{"DQ74", 4, 12318},
	{"DQ75", 4, 12319},
	{"DQ76", 4, 12320},
	{"DQ77", 4, 12321},
	{"DQ78", 4, 12322},
	{"DQ79", 4, 12323},
	{"DQ80", 4, 12324},
	{"DQ81", 4, 12325},
	{"DQ82", 4, 12326},
	{"DQ83", 4, 12327},
	{"DQ84", 4, 12328},
	{"DQ85", 4, 12329},
	{"DQ86", 4, 12330},
	{"DQ87", 4, 12331},
	{"DQ88", 4, 12332},
	{"DQ89", 4, 12333},
	{"DQ90", 4, 12334},
	{"DQ91", 4, 12335},
	{"DQ92", 4, 12336},
	{"DQ93", 4, 12337},
	{"DQ94", 4, 12338},
	{"DQ95", 4, 12339},
	{"DQ96", 4, 12340},
	{"DQ97", 4, 12341},
	{"DQ98", 4, 12342},
	{"DQ99", 4, 12343},
	{"EB00", 4, 12344},
	{"EB01", 4, 12345},
	{"EB02", 4, 12346},
	{"EB03", 4, 12347},
	{"EB04", 4, 12348},
	{"EB05", 4, 12349},
	{"EB06", 4, 12350},
	{"EB07", 4, 12351},
	{"EB08", 4, 12352},
	{"EB09", 4, 12353},
	{"EB10", 4, 12354},
	{"EB11", 4, 12355},
	{"EB12", 4, 12356},
	{"EB13", 4, 12357},
	{"EB14", 4, 12358},
	{"EB15", 4, 12359},
	{"EB16", 4, 12360},
	{"EB17", 4, 12361},
	{"EB18", 4, 12362},
	{"EB19", 4, 12363},
	{"EB20", 4, 12364},
	{"EB21", 4, 12365},
	{"EB22", 4, 12366},
	{"EB23", 4, 12367},
	{"EB24", 4, 12368},
	{"EB25", 4, 12369},
	{"EB26", 4, 12370},
	{"EB27", 4, 12371},
	{"EB28", 4, 12372},
	{"EB29", 4, 12373},
	{"EB30", 4, 12374},
	{"EB31", 4, 12375},
	{"EB32", 4, 12376},
	{"EB33", 4, 12377},
	{"EB34", 4, 12378},
	{"EB35", 4, 12379},
	{"EB36", 4, 12380},
	{"EB37", 4, 12381},
	{"EB38", 4, 12382},
	{"EB39", 4, 12383},
	{"EB40", 4, 12384},
	{"EB41", 4, 12385},
	{"EB42", 4, 12386},
	{"EB43", 4, 12387},
	{"EB44", 4, 12388},
	{"EB45", 4, 12389},
	{"EB46", 4, 12390},
	{"EB47", 4, 12391},
	{"EB48", 4, 12392},
	{"EB49", 4, 12393},
	{"EB50", 4, 12394},
	{"EB51", 4, 12395},
	{"EB52", 4, 12396},
	{"EB53", 4, 12397},
	{"EB54", 4, 12398},
	{"EB55", 4, 12399},
	{"EB56", 4, 12400},
	{"EB57", 4, 12401},
	{"EB58", 4, 12402},
	{"EB59", 4, 12403},
	{"EB60", 4, 12404},
	{"EB61", 4, 12405},
	{"EB62", 4, 12406},
	{"EB63", 4, 12407},
	{"EB64", 4, 12408},
	{"EB65", 4, 12409},
	{"EB66", 4, 12410},
	{"EB67", 4, 12411},
	{"EB68", 4, 12412},
	{"EB69", 4, 12413},
	{"EB70", 4, 12414},
	{"EB71", 4, 12415},
	{"EB72", 4, 12416},
	{"EB73", 4, 12417},
	{"EB74", 4, 12418},
	{"EB75", 4, 12419},
	{"EB76", 4, 12420},
	{"EB77", 4, 12421},
	{"EB78", 4, 12422},
	{"EB79", 4, 12423},
	{"EB80", 4, 12424},
	{"EB81", 4, 12425},
	{"EB82", 4, 12426},
	{"EB83", 4, 12427},
	{"EB84", 4, 12428},
	{"EB85", 4, 12429},
	{"EB86", 4, 12430},
	{"EB87", 4, 12431},
	{"EB88", 4, 12432},
	{"EB89", 4, 12433},
	{"EB90", 4, 12434},
	{"EB91", 4, 12435},
	{"EB92", 4, 12436},
	{"EB93", 4, 12437},
	{"EB94", 4, 12438},
	{"EB95", 4, 12439},
	{"EB96", 4, 12440},
	{"EB97", 4, 12441},
	{"EB98", 4, 12442},
	{"EB99", 4, 12443},
	{"EJ00", 4, 12444},
	{"EJ01", 4, 12445},
	{"EJ02", 4, 12446},
	{"EJ03", 4, 12447},
	{"EJ04", 4, 12448},
	{"EJ05", 4, 12449},
	{"EJ06", 4, 12450},
	{"EJ07", 4, 12451},
	{"EJ08", 4, 12452},
	{"EJ09", 4, 12453},
	{"EJ10", 4, 12454},
	{"EJ11", 4, 12455},
	{"EJ12", 4, 12456},
	{"EJ13", 4, 12457},
	{"EJ14", 4, 12458},
	{"EJ15", 4, 12459},
	{"EJ16", 4, 12460},
	{"EJ17", 4, 12461},
	{"EJ18", 4, 12462},
	{"EJ19", 4, 12463},
	{"EJ20", 4, 12464},
	{"EJ21", 4, 12465},
	{"EJ22", 4, 12466},
	{"EJ23", 4, 12467},
	{"EJ24", 4, 12468},
	{"EJ25", 4, 12469},
	{"EJ26", 4, 12470},
	{"EJ27", 4, 12471},
	{"EJ28", 4, 12472},
	{"EJ29", 4, 12473},
	{"EJ30", 4, 12474},
	{"EJ31", 4, 12475},
	{"EJ32", 4, 12476},
	{"EJ33", 4, 12477},
	{"EJ34", 4, 12478},
	{"EJ35", 4, 12479},
	{"EJ36", 4, 12480},
	{"EJ37", 4, 12481},
	{"EJ38", 4, 12482},
	{"EJ39", 4, 12483},
	{"EJ40", 4, 12484},
	{"EJ41", 4, 12485},
	{"EJ42", 4, 12486},
	{"EJ43", 4, 12487},
	{"EJ44", 4, 12488},
	{"EJ45", 4, 12489},
	{"EJ46", 4, 12490},
	{"EJ47", 4, 12491},
	{"EJ48", 4, 12492},
	{"EJ49", 4, 12493},
	{"EJ50", 4, 12494},
	{"EJ51", 4, 12495},
	{"EJ52", 4, 12496},
	{"EJ53", 4, 12497},
	{"EJ54", 4, 12498},
	{"EJ55", 4, 12499},
	{"EJ56", 4, 12500},
	{"EJ57", 4, 12501},
	{"EJ58", 4, 12502},
	{"EJ59", 4, 12503},
	{"EJ60", 4, 12504},
	{"EJ61", 4, 12505},
	{"EJ62", 4, 12506},
	{"EJ63", 4, 12507},
	{"EJ64", 4, 12508},
	{"EJ65", 4, 12509},
	{"EJ66", 4, 12510},
	{"EJ67", 4, 12511},
	{"EJ68", 4, 12512},
	{"EJ69", 4, 12513},
	{"EJ70", 4, 12514},
	{"EJ71", 4, 12515},
	{"EJ72", 4, 12516},
	{"EJ73", 4, 12517},
	{"EJ74", 4, 12518},
	{"EJ75", 4, 12519},
	{"EJ76", 4, 12520},
	{"EJ77", 4, 12521},
	{"EJ78", 4, 12522},
	{"EJ79", 4, 12523},
	{"EJ80", 4, 12524},
	{"EJ81", 4, 12525},
	{"EJ82", 4, 12526},
	{"EJ83", 4, 12527},
	{"EJ84", 4, 12528},
	{"EJ85", 4, 12529},
	{"EJ86", 4, 12530},
	{"EJ87", 4, 12531},
	{"EJ88", 4, 12532},
	{"EJ89", 4, 12533},
	{"EJ90", 4, 12534},
	{"EJ91", 4, 12535},
	{"EJ92", 4, 12536},
	{"EJ93", 4, 12537},
	{"EJ94", 4, 12538},
	{"EJ95", 4, 12539},
	{"EJ96", 4, 12540},
	{"EJ97", 4, 12541},
	{"EJ98", 4, 12542},
	{"EJ99", 4, 12543},
	{"EK00", 4, 12544},
	{"EK01", 4, 12545},
	{"EK02", 4, 12546},
	{"EK03", 4, 12547},
	{"EK04", 4, 12548},
	{"EK05", 4, 12549},
	{"EK06", 4, 12550},
	{"EK07", 4, 12551},
	{"EK08", 4, 12552},
	{"EK09", 4, 12553},
	{"EK10", 4, 12554},
	{"EK11", 4, 12555},
	{"EK12", 4, 12556},
	{"EK13", 4, 12557},
	{"EK14", 4, 12558},
	{"EK15", 4, 12559},
	{"EK16", 4, 12560},
	{"EK17", 4, 12561},
	{"EK18", 4, 12562},
	{"EK19", 4, 12563},
	{"EK20", 4, 12564},
	{"EK21", 4, 12565},
	{"EK22", 4, 12566},
	{"EK23", 4, 12567},
	{"EK24", 4, 12568},
	{"EK25", 4, 12569},
	{"EK26", 4, 12570},
	{"EK27", 4, 12571},
	{"EK28", 4, 12572},
	{"EK29", 4, 12573},
	{"EK30", 4, 12574},
	{"EK31", 4, 12575},
	{"EK32", 4, 12576},
	{"EK33", 4, 12577},
	{"EK34", 4, 12578},
	{"EK35", 4, 12579},
	{"EK36", 4, 12580},
	{"EK37", 4, 12581},
	{"EK38", 4, 12582},
	{"EK39", 4, 12583},
	{"EK40", 4, 12584},
	{"EK41", 4, 12585},
	{"EK42", 4, 12586},
	{"EK43", 4, 12587},
	{"EK44", 4, 12588},
	{"EK45", 4, 12589},
	{"EK46", 4, 12590},
	{"EK47", 4, 12591},
	{"EK48", 4, 12592},
	{"EK49", 4, 12593},
	{"EK50", 4, 12594},
	{"EK51", 4, 12595},
	{"EK52", 4, 12596},
	{"EK53", 4, 12597},
	{"EK54", 4, 12598},
	{"EK55", 4, 12599},
	{"EK56", 4, 12600},
	{"EK57", 4, 12601},
	{"EK58", 4, 12602},
	{"EK59", 4, 12603},
	{"EK60", 4, 12604},
	{"EK61", 4, 12605},
	{"EK62", 4, 12606},
	{"EK63", 4, 12607},
	{"EK64", 4, 12608},
	{"EK65", 4, 12609},
	{"EK66", 4, 12610},
	{"EK67", 4, 12611},
	{"EK68", 4, 12612},
	{"EK69", 4, 12613},
	{"EK70", 4, 12614},
	{"EK71", 4, 12615},
	{"EK72", 4, 12616},
	{"EK73", 4, 12617},
	{"EK74", 4, 12618},
	{"EK75", 4, 12619},
	{"EK76", 4, 12620},
	{"EK77", 4, 12621},
	{"EK78", 4, 12622},
	{"EK79", 4, 12623},
	{"EK80", 4, 12624},
	{"EK81", 4, 12625},
	{"EK82", 4, 12626},
	{"EK83", 4, 12627},
	{"EK84", 4, 12628},
	{"EK85", 4, 12629},
	{"EK86", 4, 12630},
	{"EK87", 4, 12631},
	{"EK88", 4, 12632},
	{"EK89", 4, 12633},
	{"EK90", 4, 12634},
	{"EK91", 4, 12635},
	{"EK92", 4, 12636},
	{"EK93", 4, 12637},
	{"EK94", 4, 12638},
	{"EK95", 4, 12639},
	{"EK96", 4, 12640},
	{"EK97", 4, 12641},
	{"EK98", 4, 12642},
	{"EK99", 4, 12643},
	{"EL00", 4, 12644},
	{"EL01", 4, 12645},
	{"EL02", 4, 12646},
	{"EL03", 4, 12647},
	{"EL04", 4, 12648},
	{"EL05", 4, 12649},
	{"EL06", 4, 12650},
	{"EL07", 4, 12651},
	{"EL08", 4, 12652},
	{"EL09", 4, 12653},
	{"EL10", 4, 12654},
	{"EL11", 4, 12655},
	{"EL12", 4, 12656},
	{"EL13", 4, 12657},
	{"EL14", 4, 12658},
	{"EL15", 4, 12659},
	{"EL16", 4, 12660},
	{"EL17", 4, 12661},
	{"EL18", 4, 12662},
	{"EL19", 4, 12663},
	{"EL20", 4, 12664},
	{"EL21", 4, 12665},
	{"EL22", 4, 12666},
	{"EL23", 4, 12667},
	{"EL24", 4, 12668},
	{"EL25", 4, 12669},
	{"EL26", 4, 12670},
	{"EL27", 4, 12671},
	{"EL28", 4, 12672},
	{"EL29", 4, 12673},
	{"EL30", 4, 12674},
	{"EL31", 4, 12675},
	{"EL32", 4, 12676},
	{"EL33", 4, 12677},
	{"EL34", 4, 12678},
	{"EL35", 4, 12679},
	{"EL36", 4, 12680},
	{"EL37", 4, 12681},
	{"EL38", 4, 12682},
	{"EL39", 4, 12683},
	{"EL40", 4, 12684},
	{"EL41", 4, 12685},
	{"EL42", 4, 12686},
	{"EL43", 4, 12687},
	{"EL44", 4, 12688},
	{"EL45", 4, 12689},
	{"EL46", 4, 12690},
	{"EL47", 4, 12691},
	{"EL48", 4, 12692},
	{"EL49", 4, 12693},
	{"EL50", 4, 12694},
	{"EL51", 4, 12695},
	{"EL52", 4, 12696},
	{"EL53", 4, 12697},
	{"EL54", 4, 12698},
	{"EL55", 4, 12699},
	{"EL56", 4, 12700},
	{"EL57", 4, 12701},
	{"EL58", 4, 12702},
	{"EL59", 4, 12703},
	{"EL60", 4, 12704},
	{"EL61", 4, 12705},
	{"EL62", 4, 12706},
	{"EL63", 4, 12707},
	{"EL64", 4, 12708},
	{"EL65", 4, 12709},
	{"EL66", 4, 12710},
	{"EL67", 4, 12711},
	{"EL68", 4, 12712},
	{"EL69", 4, 12713},
	{"EL70", 4, 12714},
	{"EL71", 4, 12715},
	{"EL72", 4, 12716},
	{"EL73", 4, 12717},
	{"EL74", 4, 12718},
	{"EL75", 4, 12719},
	{"EL76", 4, 12720},
	{"EL77", 4, 12721},
	{"EL78", 4, 12722},
	{"EL79", 4, 12723},
	{"EL80", 4, 12724},
	{"EL81", 4, 12725},
	{"EL82", 4, 12726},
	{"EL83", 4, 12727},
	{"EL84", 4, 12728},
	{"EL85", 4, 12729},
	{"EL86", 4, 12730},
	{"EL87", 4, 12731},
	{"EL88", 4, 12732},
	{"EL89", 4, 12733},
	{"EL90", 4, 12734},
	{"EL91", 4, 12735},
	{"EL92", 4, 12736},
	{"EL93", 4, 12737},
	{"EL94", 4, 12738},
	{"EL95", 4, 12739},
	{"EL96", 4, 12740},
	{"EL97", 4, 12741},
	{"EL98", 4, 12742},
	{"EL99", 4, 12743},
	{"EM00", 4, 12744},
	{"EM01", 4, 12745},
	{"EM02", 4, 12746},
	{"EM03", 4, 12747},
	{"EM04", 4, 12748},
	{"EM05", 4, 12749},
	{"EM06", 4, 12750},
	{"EM07", 4, 12751},
	{"EM08", 4, 12752},
	{"EM09", 4, 12753},
	{"EM10", 4, 12754},
	{"EM11", 4, 12755},
	{"EM12", 4, 12756},
	{"EM13", 4, 12757},
	{"EM14", 4, 12758},
	{"EM15", 4, 12759},
	{"EM16", 4, 12760},
	{"EM17", 4, 12761},
	{"EM18", 4, 12762},
	{"EM19", 4, 12763},
	{"EM20", 4, 12764},
	{"EM21", 4, 12765},
	{"EM22", 4, 12766},
	{"EM23", 4, 12767},
	{"EM24", 4, 12768},
	{"EM25", 4, 12769},
	{"EM26", 4, 12770},
	{"EM27", 4, 12771},
	{"EM28", 4, 12772},
	{"EM29", 4, 12773},
	{"EM30", 4, 12774},
	{"EM31", 4, 12775},
	{"EM32", 4, 12776},
	{"EM33", 4, 12777},
	{"EM34", 4, 12778},
	{"EM35", 4, 12779},
	{"EM36", 4, 12780},
	{"EM37", 4, 12781},
	{"EM38", 4, 12782},
	{"EM39", 4, 12783},
	{"EM40", 4, 12784},
	{"EM41", 4, 12785},
	{"EM42", 4, 12786},
	{"EM43", 4, 12787},
	{"EM44", 4, 12788},
	{"EM45", 4, 12789},
	{"EM46", 4, 12790},
	{"EM47", 4, 12791},
	{"EM48", 4, 12792},
	{"EM49", 4, 12793},
	{"EM50", 4, 12794},
	{"EM51", 4, 12795},
	{"EM52", 4, 12796},
	{"EM53", 4, 12797},
	{"EM54", 4, 12798},
	{"EM55", 4, 12799},
	{"EM56", 4, 12800},
	{"EM57", 4, 12801},
	{"EM58", 4, 12802},
	{"EM59", 4, 12803},
	{"EM60", 4, 12804},
	{"EM61", 4, 12805},
	{"EM62", 4, 12806},
	{"EM63", 4, 12807},
	{"EM64", 4, 12808},
	{"EM65", 4, 12809},
	{"EM66", 4, 12810},
	{"EM67", 4, 12811},
	{"EM68", 4, 12812},
	{"EM69", 4, 12813},
	{"EM70", 4, 12814},
	{"EM71", 4, 12815},
	{"EM72", 4, 12816},
	{"EM73", 4, 12817},
	{"EM74", 4, 12818},
	{"EM75", 4, 12819},
	{"EM76", 4, 12820},
	{"EM77", 4, 12821},
	{"EM78", 4, 12822},
	{"EM79", 4, 12823},
	{"EM80", 4, 12824},
	{"EM81", 4, 12825},
	{"EM82", 4, 12826},
	{"EM83", 4, 12827},
	{"EM84", 4, 12828},
	{"EM85", 4, 12829},
	{"EM86", 4, 12830},
	{"EM87", 4, 12831},
	{"EM88", 4, 12832},
	{"EM89", 4, 12833},
	{"EM90", 4, 12834},
	{"EM91", 4, 12835},
	{"EM92", 4, 12836},
	{"EM93", 4, 12837},
	{"EM94", 4, 12838},
	{"EM95", 4, 12839},
	{"EM96", 4, 12840},
	{"EM97", 4, 12841},
	{"EM98", 4, 12842},
	{"EM99", 4, 12843},
	{"EN00", 4, 12844},
	{"EN01", 4, 12845},
	{"EN02", 4, 12846},
	{"EN03", 4, 12847},
	{"EN04", 4, 12848},
	{"EN05", 4, 12849},
	{"EN06", 4, 12850},
	{"EN07", 4, 12851},
	{"EN08", 4, 12852},
	{"EN09", 4, 12853},
	{"EN10", 4, 12854},
	{"EN11", 4, 12855},
	{"EN12", 4, 12856},
	{"EN13", 4, 12857},
	{"EN14", 4, 12858},
	{"EN15", 4, 12859},
	{"EN16", 4, 12860},
	{"EN17", 4, 12861},
	{"EN18", 4, 12862},
	{"EN19", 4, 12863},
	{"EN20", 4, 12864},
	{"EN21", 4, 12865},
	{"EN22", 4, 12866},
	{"EN23", 4, 12867},
	{"EN24", 4, 12868},
	{"EN25", 4, 12869},
	{"EN26", 4, 12870},
	{"EN27", 4, 12871},
	{"EN28", 4, 12872},
	{"EN29", 4, 12873},
	{"EN30", 4, 12874},
	{"EN31", 4, 12875},
	{"EN32", 4, 12876},
	{"EN33", 4, 12877},
	{"EN34", 4, 12878},
	{"EN35", 4, 12879},
	{"EN36", 4, 12880},
	{"EN37", 4, 12881},
	{"EN38", 4, 12882},
	{"EN39", 4, 12883},
	{"EN40", 4, 12884},
	{"EN41", 4, 12885},
	{"EN42", 4, 12886},
	{"EN43", 4, 12887},
	{"EN44", 4, 12888},
	{"EN45", 4, 12889},
	{"EN46", 4, 12890},
	{"EN47", 4, 12891},
	{"EN48", 4, 12892},
	{"EN49", 4, 12893},
	{"EN50", 4, 12894},
	{"EN51", 4, 12895},
	{"EN52", 4, 12896},
	{"EN53", 4, 12897},
	{"EN54", 4, 12898},
	{"EN55", 4, 12899},
	{"EN56", 4, 12900},
	{"EN57", 4, 12901},
	{"EN58", 4, 12902},
	{"EN59", 4, 12903},
	{"EN60", 4, 12904},
	{"EN61", 4, 12905},
	{"EN62", 4, 12906},
	{"EN63", 4, 12907},
	{"EN64", 4, 12908},
	{"EN65", 4, 12909},
	{"EN66", 4, 12910},
	{"EN67", 4, 12911},
	{"EN68", 4, 12912},
	{"EN69", 4, 12913},
	{"EN70", 4, 12914},
	{"EN71", 4, 12915},
	{"EN72", 4, 12916},
	{"EN73", 4, 12917},
	{"EN74", 4, 12918},
	{"EN75", 4, 12919},
	{"EN76", 4, 12920},
	{"EN77", 4, 12921},
	{"EN78", 4, 12922},
	{"EN79", 4, 12923},
	{"EN80", 4, 12924},
	{"EN81", 4, 12925},
	{"EN82", 4, 12926},
	{"EN83", 4, 12927},
	{"EN84", 4, 12928},
	{"EN85", 4, 12929},
	{"EN86", 4, 12930},
	{"EN87", 4, 12931},
	{"EN88", 4, 12932},
	{"EN89", 4, 12933},
	{"EN90", 4, 12934},
	{"EN91", 4, 12935},
	{"EN92", 4, 12936},
	{"EN93", 4, 12937},
	{"EN94", 4, 12938},
	{"EN95", 4, 12939},
	{"EN96", 4, 12940},
	{"EN97", 4, 12941},
	{"EN98", 4, 12942},
	{"EN99", 4, 12943},
	{"EO00", 4, 12944},
	{"EO01", 4, 12945},
	{"EO02", 4, 12946},
	{"EO03", 4, 12947},
	{"EO04", 4, 12948},
	{"EO05", 4, 12949},
	{"EO06", 4, 12950},
	{"EO07", 4, 12951},
	{"EO08", 4, 12952},
	{"EO09", 4, 12953},
	{"EO10", 4, 12954},
	{"EO11", 4, 12955},
	{"EO12", 4, 12956},
	{"EO13", 4, 12957},
	{"EO14", 4, 12958},
	{"EO15", 4, 12959},
	{"EO16", 4, 12960},
	{"EO17", 4, 12961},
	{"EO18", 4, 12962},
	{"EO19", 4, 12963},
	{"EO20", 4, 12964},
	{"EO21", 4, 12965},
	{"EO22", 4, 12966},
	{"EO23", 4, 12967},
	{"EO24", 4, 12968},
	{"EO25", 4, 12969},
	{"EO26", 4, 12970},
	{"EO27", 4, 12971},
	{"EO28", 4, 12972},
	{"EO29", 4, 12973},
	{"EO30", 4, 12974},
	{"EO31", 4, 12975},
	{"EO32", 4, 12976},
	{"EO33", 4, 12977},
	{"EO34", 4, 12978},
	{"EO35", 4, 12979},
	{"EO36", 4, 12980},
	{"EO37", 4, 12981},
	{"EO38", 4, 12982},
	{"EO39", 4, 12983},
	{"EO40", 4, 12984},
	{"EO41", 4, 12985},
	{"EO42", 4, 12986},
	{"EO43", 4, 12987},
	{"EO44", 4, 12988},
	{"EO45", 4, 12989},
	{"EO46", 4, 12990},
	{"EO47", 4, 12991},
	{"EO48", 4, 12992},
	{"EO49", 4, 12993},
	{"EO50", 4, 12994},
	{"EO51", 4, 12995},
	{"EO52", 4, 12996},
	{"EO53", 4, 12997},
	{"EO54", 4, 12998},
	{"EO55", 4, 12999},
	{"EO56", 4, 13000},
	{"EO57", 4, 13001},
	{"EO58", 4, 13002},
	{"EO59", 4, 13003},
	{"EO60", 4, 13004},
	{"EO61", 4, 13005},
	{"EO62", 4, 13006},
	{"EO63", 4, 13007},
	{"EO64", 4, 13008},
	{"EO65", 4, 13009},
	{"EO66", 4, 13010},
	{"EO67", 4, 13011},
	{"EO68", 4, 13012},
	{"EO69", 4, 13013},
	{"EO70", 4, 13014},
	{"EO71", 4, 13015},
	{"EO72", 4, 13016},
	{"EO73", 4, 13017},
	{"EO74", 4, 13018},
	{"EO75", 4, 13019},
	{"EO76", 4, 13020},
	{"EO77", 4, 13021},
	{"EO78", 4, 13022},
	{"EO79", 4, 13023},
	{"EO80", 4, 13024},
	{"EO81", 4, 13025},
	{"EO82", 4, 13026},
	{"EO83", 4, 13027},
	{"EO84", 4, 13028},
	{"EO85", 4, 13029},
	{"EO86", 4, 13030},
	{"EO87", 4, 13031},
	{"EO88", 4, 13032},
	{"EO89", 4, 13033},
	{"EO90", 4, 13034},
	{"EO91", 4, 13035},
	{"EO92", 4, 13036},
	{"EO93", 4, 13037},
	{"EO94", 4, 13038},
	{"EO95", 4, 13039},
	{"EO96", 4, 13040},
	{"EO97", 4, 13041},
	{"EO98", 4, 13042},
	{"EO99", 4, 13043},
	{"EP00", 4, 13044},
	{"EP01", 4, 13045},
	{"EP02", 4, 13046},
	{"EP03", 4, 13047},
	{"EP04", 4, 13048},
	{"EP05", 4, 13049},
	{"EP06", 4, 13050},
	{"EP07", 4, 13051},
	{"EP08", 4, 13052},
	{"EP09", 4, 13053},
	{"EP10", 4, 13054},
	{"EP11", 4, 13055},
	{"EP12", 4, 13056},
	{"EP13", 4, 13057},
	{"EP14", 4, 13058},
	{"EP15", 4, 13059},
	{"EP16", 4, 13060},
	{"EP17", 4, 13061},
	{"EP18", 4, 13062},
	{"EP19", 4, 13063},
	{"EP20", 4, 13064},
	{"EP21", 4, 13065},
	{"EP22", 4, 13066},
	{"EP23", 4, 13067},
	{"EP24", 4, 13068},
	{"EP25", 4, 13069},
	{"EP26", 4, 13070},
	{"EP27", 4, 13071},
	{"EP28", 4, 13072},
	{"EP29", 4, 13073},
	{"EP30", 4, 13074},
	{"EP31", 4, 13075},
	{"EP32", 4, 13076},
	{"EP33", 4, 13077},
	{"EP34", 4, 13078},
	{"EP35", 4, 13079},
	{"EP36", 4, 13080},
	{"EP37", 4, 13081},
	{"EP38", 4, 13082},
	{"EP39", 4, 13083},
	{"EP40", 4, 13084},
	{"EP41", 4, 13085},
	{"EP42", 4, 13086},
	{"EP43", 4, 13087},
	{"EP44", 4, 13088},
	{"EP45", 4, 13089},
	{"EP46", 4, 13090},
	{"EP47", 4, 13091},
	{"EP48", 4, 13092},
	{"EP49", 4, 13093},
	{"EP50", 4, 13094},
	{"EP51", 4, 13095},
	{"EP52", 4, 13096},
	{"EP53", 4, 13097},
	{"EP54", 4, 13098},
	{"EP55", 4, 13099},
	{"EP56", 4, 13100},
	{"EP57", 4, 13101},
	{"EP58", 4, 13102},
	{"EP59", 4, 13103},
	{"EP60", 4, 13104},
	{"EP61", 4, 13105},
	{"EP62", 4, 13106},
	{"EP63", 4, 13107},
	{"EP64", 4, 13108},
	{"EP65", 4, 13109},
	{"EP66", 4, 13110},
	{"EP67", 4, 13111},
	{"EP68", 4, 13112},
	{"EP69", 4, 13113},
	{"EP70", 4, 13114},
	{"EP71", 4, 13115},
	{"EP72", 4, 13116},
	{"EP73", 4, 13117},
	{"EP74", 4, 13118},
	{"EP75", 4, 13119},
	{"EP76", 4, 13120},
	{"EP77", 4, 13121},
	{"EP78", 4, 13122},
	{"EP79", 4, 13123},
	{"EP80", 4, 13124},
	{"EP81", 4, 13125},
	{"EP82", 4, 13126},
	{"EP83", 4, 13127},
	{"EP84", 4, 13128},
	{"EP85", 4, 13129},
	{"EP86", 4, 13130},
	{"EP87", 4, 13131},
	{"EP88", 4, 13132},
	{"EP89", 4, 13133},
	{"EP90", 4, 13134},
	{"EP91", 4, 13135},
	{"EP92", 4, 13136},
	{"EP93", 4, 13137},
	{"EP94", 4, 13138},
	{"EP95", 4, 13139},
	{"EP96", 4, 13140},
	{"EP97", 4, 13141},
	{"EP98", 4, 13142},
	{"EP99", 4, 13143},
	{"EQ00", 4, 13144},
	{"EQ01", 4, 13145},
	{"EQ02", 4, 13146},
	{"EQ03", 4, 13147},
	{"EQ04", 4, 13148},
	{"EQ05", 4, 13149},
	{"EQ06", 4, 13150},
	{"EQ07", 4, 13151},
	{"EQ08", 4, 13152},
	{"EQ09", 4, 13153},
	{"EQ10", 4, 13154},
	{"EQ11", 4, 13155},
	{"EQ12", 4, 13156},
	{"EQ13", 4, 13157},
	{"EQ14", 4, 13158},
	{"EQ15", 4, 13159},
	{"EQ16", 4, 13160},
	{"EQ17", 4, 13161},
	{"EQ18", 4, 13162},
	{"EQ19", 4, 13163},
	{"EQ20", 4, 13164},
	{"EQ21", 4, 13165},
	{"EQ22", 4, 13166},
	{"EQ23", 4, 13167},
	{"EQ24", 4, 13168},
	{"EQ25", 4, 13169},
	{"EQ26", 4, 13170},
	{"EQ27", 4, 13171},
	{"EQ28", 4, 13172},
	{"EQ29", 4, 13173},
	{"EQ30", 4, 13174},
	{"EQ31", 4, 13175},
	{"EQ32", 4, 13176},
	{"EQ33", 4, 13177},
	{"EQ34", 4, 13178},
	{"EQ35", 4, 13179},
	{"EQ36", 4, 13180},
	{"EQ37", 4, 13181},
	{"EQ38", 4, 13182},
	{"EQ39", 4, 13183},
	{"EQ40", 4, 13184},
	{"EQ41", 4, 13185},
	{"EQ42", 4, 13186},
	{"EQ43", 4, 13187},
	{"EQ44", 4, 13188},
	{"EQ45", 4, 13189},
	{"EQ46", 4, 13190},
	{"EQ47", 4, 13191},
	{"EQ48", 4, 13192},
	{"EQ49", 4, 13193},
	{"EQ50", 4, 13194},
	{"EQ51", 4, 13195},
	{"EQ52", 4, 13196},
	{"EQ53", 4, 13197},
	{"EQ54", 4, 13198},
	{"EQ55", 4, 13199},
	{"EQ56", 4, 13200},
	{"EQ57", 4, 13201},
	{"EQ58", 4, 13202},
	{"EQ59", 4, 13203},
	{"EQ60", 4, 13204},
	{"EQ61", 4, 13205},
	{"EQ62", 4, 13206},
	{"EQ63", 4, 13207},
	{"EQ64", 4, 13208},
	{"EQ65", 4, 13209},
	{"EQ66", 4, 13210},
	{"EQ67", 4, 13211},
	{"EQ68", 4, 13212},
	{"EQ69", 4, 13213},
	{"EQ70", 4, 13214},
	{"EQ71", 4, 13215},
	{"EQ72", 4, 13216},
	{"EQ73", 4, 13217},
	{"EQ74", 4, 13218},
	{"EQ75", 4, 13219},
	{"EQ76", 4, 13220},
	{"EQ77", 4, 13221},
	{"EQ78", 4, 13222},
	{"EQ79", 4, 13223},
	{"EQ80", 4, 13224},
	{"EQ81", 4, 13225},
	{"EQ82", 4, 13226},
	{"EQ83", 4, 13227},
	{"EQ84", 4, 13228},
	{"EQ85", 4, 13229},
	{"EQ86", 4, 13230},
	{"EQ87", 4, 13231},
	{"EQ88", 4, 13232},
	{"EQ89", 4, 13233},
	{"EQ90", 4, 13234},
	{"EQ91", 4, 13235},
	{"EQ92", 4, 13236},
	{"EQ93", 4, 13237},
	{"EQ94", 4, 13238},
	{"EQ95", 4, 13239},
	{"EQ96", 4, 13240},
	{"EQ97", 4, 13241},
	{"EQ98", 4, 13242},
	{"EQ99", 4, 13243},
	{"FB00", 4, 13244},
	{"FB01", 4, 13245},
	{"FB02", 4, 13246},
	{"FB03", 4, 13247},
	{"FB04", 4, 13248},
	{"FB05", 4, 13249},
	{"FB06", 4, 13250},
	{"FB07", 4, 13251},
	{"FB08", 4, 13252},
	{"FB09", 4, 13253},
	{"FB10", 4, 13254},
	{"FB11", 4, 13255},
	{"FB12", 4, 13256},
	{"FB13", 4, 13257},
	{"FB14", 4, 13258},
	{"FB15", 4, 13259},
	{"FB16", 4, 13260},
	{"FB17", 4, 13261},
	{"FB18", 4, 13262},
	{"FB19", 4, 13263},
	{"FB20", 4, 13264},
	{"FB21", 4, 13265},
	{"FB22", 4, 13266},
	{"FB23", 4, 13267},
	{"FB24", 4, 13268},
	{"FB25", 4, 13269},
	{"FB26", 4, 13270},
	{"FB27", 4, 13271},
	{"FB28", 4, 13272},
	{"FB29", 4, 13273},
	{"FB30", 4, 13274},
	{"FB31", 4, 13275},
	{"FB32", 4, 13276},
	{"FB33", 4, 13277},
	{"FB34", 4, 13278},
	{"FB35", 4, 13279},
	{"FB36", 4, 13280},
	{"FB37", 4, 13281},
	{"FB38", 4, 13282},
	{"FB39", 4, 13283},
	{"FB40", 4, 13284},
	{"FB41", 4, 13285},
	{"FB42", 4, 13286},
	{"FB43", 4, 13287},
	{"FB44", 4, 13288},
	{"FB45", 4, 13289},
	{"FB46", 4, 13290},
	{"FB47", 4, 13291},
	{"FB48", 4, 13292},
	{"FB49", 4, 13293},
	{"FB50", 4, 13294},
	{"FB51", 4, 13295},
	{"FB52", 4, 13296},
	{"FB53", 4, 13297},
	{"FB54", 4, 13298},
	{"FB55", 4, 13299},
	{"FB56", 4, 13300},
	{"FB57", 4, 13301},
	{"FB58", 4, 13302},
	{"FB59", 4, 13303},
	{"FB60", 4, 13304},
	{"FB61", 4, 13305},
	{"FB62", 4, 13306},
	{"FB63", 4, 13307},
	{"FB64", 4, 13308},
	{"FB65", 4, 13309},
	{"FB66", 4, 13310},
	{"FB67", 4, 13311},
	{"FB68", 4, 13312},
	{"FB69", 4, 13313},
	{"FB70", 4, 13314},
	{"FB71", 4, 13315},
	{"FB72", 4, 13316},
	{"FB73", 4, 13317},
	{"FB74", 4, 13318},
	{"FB75", 4, 13319},
	{"FB76", 4, 13320},
	{"FB77", 4, 13321},
	{"FB78", 4, 13322},
	{"FB79", 4, 13323},
	{"FB80", 4, 13324},
	{"FB81", 4, 13325},
	{"FB82", 4, 13326},
	{"FB83", 4, 13327},
	{"FB84", 4, 13328},
	{"FB85", 4, 13329},
	{"FB86", 4, 13330},
	{"FB87", 4, 13331},
	{"FB88", 4, 13332},
	{"FB89", 4, 13333},
	{"FB90", 4, 13334},
	{"FB91", 4, 13335},
	{"FB92", 4, 13336},
	{"FB93", 4, 13337},
	{"FB94", 4, 13338},
	{"FB95", 4, 13339},
	{"FB96", 4, 13340},
	{"FB97", 4, 13341},
	{"FB98", 4, 13342},
	{"FB99", 4, 13343},
	{"FC00", 4, 13344},
	{"FC01", 4, 13345},
	{"FC02", 4, 13346},
	{"FC03", 4, 13347},
	{"FC04", 4, 13348},
	{"FC05", 4, 13349},
	{"FC06", 4, 13350},
	{"FC07", 4, 13351},
	{"FC08", 4, 13352},
	{"FC09", 4, 13353},
	{"FC10", 4, 13354},
	{"FC11", 4, 13355},
	{"FC12", 4, 13356},
	{"FC13", 4, 13357},
	{"FC14", 4, 13358},
	{"FC15", 4, 13359},
	{"FC16", 4, 13360},
	{"FC17", 4, 13361},
	{"FC18", 4, 13362},
	{"FC19", 4, 13363},
	{"FC20", 4, 13364},
	{"FC21", 4, 13365},
	{"FC22", 4, 13366},
	{"FC23", 4, 13367},
	{"FC24", 4, 13368},
	{"FC25", 4, 13369},
	{"FC26", 4, 13370},
	{"FC27", 4, 13371},
	{"FC28", 4, 13372},
	{"FC29", 4, 13373},
	{"FC30", 4, 13374},
	{"FC31", 4, 13375},
	{"FC32", 4, 13376},
	{"FC33", 4, 13377},
	{"FC34", 4, 13378},
	{"FC35", 4, 13379},
	{"FC36", 4, 13380},
	{"FC37", 4, 13381},
	{"FC38", 4, 13382},
	{"FC39", 4, 13383},
	{"FC40", 4, 13384},
	{"FC41", 4, 13385},
	{"FC42", 4, 13386},
	{"FC43", 4, 13387},
	{"FC44", 4, 13388},
	{"FC45", 4, 13389},
	{"FC46", 4, 13390},
	{"FC47", 4, 13391},
	{"FC48", 4, 13392},
	{"FC49", 4, 13393},
	{"FC50", 4, 13394},
	{"FC51", 4, 13395},
	{"FC52", 4, 13396},
	{"FC53", 4, 13397},
	{"FC54", 4, 13398},
	{"FC55", 4, 13399},
	{"FC56", 4, 13400},
	{"FC57", 4, 13401},
	{"FC58", 4, 13402},
	{"FC59", 4, 13403},
	{"FC60", 4, 13404},
	{"FC61", 4, 13405},
	{"FC62", 4, 13406},
	{"FC63", 4, 13407},
	{"FC64", 4, 13408},
	{"FC65", 4, 13409},
	{"FC66", 4, 13410},
	{"FC67", 4, 13411},
	{"FC68", 4, 13412},
	{"FC69", 4, 13413},
	{"FC70", 4, 13414},
	{"FC71", 4, 13415},
	{"FC72", 4, 13416},
	{"FC73", 4, 13417},
	{"FC74", 4, 13418},
	{"FC75", 4, 13419},
	{"FC76", 4, 13420},
	{"FC77", 4, 13421},
	{"FC78", 4, 13422},
	{"FC79", 4, 13423},
	{"FC80", 4, 13424},
	{"FC81", 4, 13425},
	{"FC82", 4, 13426},
	{"FC83", 4, 13427},
	{"FC84", 4, 13428},
	{"FC85", 4, 13429},
	{"FC86", 4, 13430},
	{"FC87", 4, 13431},
	{"FC88", 4, 13432},
	{"FC89", 4, 13433},
	{"FC90", 4, 13434},
	{"FC91", 4, 13435},
	{"FC92", 4, 13436},
	{"FC93", 4, 13437},
	{"FC94", 4, 13438},
	{"FC95", 4, 13439},
	{"FC96", 4, 13440},
	{"FC97", 4, 13441},
	{"FC98", 4, 13442},
	{"FC99", 4, 13443},
	{"FD00", 4, 13444},
	{"FD01", 4, 13445},
	{"FD02", 4, 13446},
	{"FD03", 4, 13447},
	{"FD04", 4, 13448},
	{"FD05", 4, 13449},
	{"FD06", 4, 13450},
	{"FD07", 4, 13451},
	{"FD08", 4, 13452},
	{"FD09", 4, 13453},
	{"FD10", 4, 13454},
	{"FD11", 4, 13455},
	{"FD12", 4, 13456},
	{"FD13", 4, 13457},
	{"FD14", 4, 13458},
	{"FD15", 4, 13459},
	{"FD16", 4, 13460},
	{"FD17", 4, 13461},
	{"FD18", 4, 13462},
	{"FD19", 4, 13463},
	{"FD20", 4, 13464},
	{"FD21", 4, 13465},
	{"FD22", 4, 13466},
	{"FD23", 4, 13467},
	{"FD24", 4, 13468},
	{"FD25", 4, 13469},
	{"FD26", 4, 13470},
	{"FD27", 4, 13471},
	{"FD28", 4, 13472},
	{"FD29", 4, 13473},
	{"FD30", 4, 13474},
	{"FD31", 4, 13475},
	{"FD32", 4, 13476},
	{"FD33", 4, 13477},
	{"FD34", 4, 13478},
	{"FD35", 4, 13479},
	{"FD36", 4, 13480},
	{"FD37", 4, 13481},
	{"FD38", 4, 13482},
	{"FD39", 4, 13483},
	{"FD40", 4, 13484},
	{"FD41", 4, 13485},
	{"FD42", 4, 13486},
	{"FD43", 4, 13487},
	{"FD44", 4, 13488},
	{"FD45", 4, 13489},
	{"FD46", 4, 13490},
	{"FD47", 4, 13491},
	{"FD48", 4, 13492},
	{"FD49", 4, 13493},
	{"FD50", 4, 13494},
	{"FD51", 4, 13495},
	{"FD52", 4, 13496},
	{"FD53", 4, 13497},
	{"FD54", 4, 13498},
	{"FD55", 4, 13499},
	{"FD56", 4, 13500},
	{"FD57", 4, 13501},
	{"FD58", 4, 13502},
	{"FD59", 4, 13503},
	{"FD60", 4, 13504},
	{"FD61", 4, 13505},
	{"FD62", 4, 13506},
	{"FD63", 4, 13507},
	{"FD64", 4, 13508},
	{"FD65", 4, 13509},
	{"FD66", 4, 13510},
	{"FD67", 4, 13511},
	{"FD68", 4, 13512},
	{"FD69", 4, 13513},
	{"FD70", 4, 13514},
	{"FD71", 4, 13515},
	{"FD72", 4, 13516},
	{"FD73", 4, 13517},
	{"FD74", 4, 13518},
	{"FD75", 4, 13519},
	{"FD76", 4, 13520},
	{"FD77", 4, 13521},
	{"FD78", 4, 13522},
	{"FD79", 4, 13523},
	{"FD80", 4, 13524},
	{"FD81", 4, 13525},
	{"FD82", 4, 13526},
	{"FD83", 4, 13527},
	{"FD84", 4, 13528},
	{"FD85", 4, 13529},
	{"FD86", 4, 13530},
	{"FD87", 4, 13531},
	{"FD88", 4, 13532},
	{"FD89", 4, 13533},
	{"FD90", 4, 13534},
	{"FD91", 4, 13535},
	{"FD92", 4, 13536},
	{"FD93", 4, 13537},
	{"FD94", 4, 13538},
	{"FD95", 4, 13539},
	{"FD96", 4, 13540},
	{"FD97", 4, 13541},
	{"FD98", 4, 13542},
	{"FD99", 4, 13543},
	{"FE00", 4, 13544},
	{"FE01", 4, 13545},
	{"FE02", 4, 13546},
	{"FE03", 4, 13547},
	{"FE04", 4, 13548},
	{"FE05", 4, 13549},
	{"FE06", 4, 13550},
	{"FE07", 4, 13551},
	{"FE08", 4, 13552},
	{"FE09", 4, 13553},
	{"FE10", 4, 13554},
	{"FE11", 4, 13555},
	{"FE12", 4, 13556},
	{"FE13", 4, 13557},
	{"FE14", 4, 13558},
	{"FE15", 4, 13559},
	{"FE16", 4, 13560},
	{"FE17", 4, 13561},
	{"FE18", 4, 13562},
	{"FE19", 4, 13563},
	{"FE20", 4, 13564},
	{"FE21", 4, 13565},
	{"FE22", 4, 13566},
	{"FE23", 4, 13567},
	{"FE24", 4, 13568},
	{"FE25", 4, 13569},
	{"FE26", 4, 13570},
	{"FE27", 4, 13571},
	{"FE28", 4, 13572},
	{"FE29", 4, 13573},
	{"FE30", 4, 13574},
	{"FE31", 4, 13575},
	{"FE32", 4, 13576},
	{"FE33", 4, 13577},
	{"FE34", 4, 13578},
	{"FE35", 4, 13579},
	{"FE36", 4, 13580},
	{"FE37", 4, 13581},
	{"FE38", 4, 13582},
	{"FE39", 4, 13583},
	{"FE40", 4, 13584},
	{"FE41", 4, 13585},
	{"FE42", 4, 13586},
	{"FE43", 4, 13587},
	{"FE44", 4, 13588},
	{"FE45", 4, 13589},
	{"FE46", 4, 13590},
	{"FE47", 4, 13591},
	{"FE48", 4, 13592},
	{"FE49", 4, 13593},
	{"FE50", 4, 13594},
	{"FE51", 4, 13595},
	{"FE52", 4, 13596},
	{"FE53", 4, 13597},
	{"FE54", 4, 13598},
	{"FE55", 4, 13599},
	{"FE56", 4, 13600},
	{"FE57", 4, 13601},
	{"FE58", 4, 13602},
	{"FE59", 4, 13603},
	{"FE60", 4, 13604},
	{"FE61", 4, 13605},
	{"FE62", 4, 13606},
	{"FE63", 4, 13607},
	{"FE64", 4, 13608},
	{"FE65", 4, 13609},
	{"FE66", 4, 13610},
	{"FE67", 4, 13611},
	{"FE68", 4, 13612},
	{"FE69", 4, 13613},
	{"FE70", 4, 13614},
	{"FE71", 4, 13615},
	{"FE72", 4, 13616},
	{"FE73", 4, 13617},
	{"FE74", 4, 13618},
	{"FE75", 4, 13619},
	{"FE76", 4, 13620},
	{"FE77", 4, 13621},
	{"FE78", 4, 13622},
	{"FE79", 4, 13623},
	{"FE80", 4, 13624},
	{"FE81", 4, 13625},
	{"FE82", 4, 13626},
	{"FE83", 4, 13627},
	{"FE84", 4, 13628},
	{"FE85", 4, 13629},
	{"FE86", 4, 13630},
	{"FE87", 4, 13631},
	{"FE88", 4, 13632},
	{"FE89", 4, 13633},
	{"FE90", 4, 13634},
	{"FE91", 4, 13635},
	{"FE92", 4, 13636},
	{"FE93", 4, 13637},
	{"FE94", 4, 13638},
	{"FE95", 4, 13639},
	{"FE96", 4, 13640},
	{"FE97", 4, 13641},
	{"FE98", 4, 13642},
	{"FE99", 4, 13643},
	{"FF00", 4, 13644},
	{"FF01", 4, 13645},
	{"FF02", 4, 13646},
	{"FF03", 4, 13647},
	{"FF04", 4, 13648},
	{"FF05", 4, 13649},
	{"FF06", 4, 13650},
	{"FF07", 4, 13651},
	{"FF08", 4, 13652},
	{"FF09", 4, 13653},
	{"FF10", 4, 13654},
	{"FF11", 4, 13655},
	{"FF12", 4, 13656},
	{"FF13", 4, 13657},
	{"FF14", 4, 13658},
	{"FF15", 4, 13659},
	{"FF16", 4, 13660},
	{"FF17", 4, 13661},
	{"FF18", 4, 13662},
	{"FF19", 4, 13663},
	{"FF20", 4, 13664},
	{"FF21", 4, 13665},
	{"FF22", 4, 13666},
	{"FF23", 4, 13667},
	{"FF24", 4, 13668},
	{"FF25", 4, 13669},
	{"FF26", 4, 13670},
	{"FF27", 4, 13671},
	{"FF28", 4, 13672},
	{"FF29", 4, 13673},
	{"FF30", 4, 13674},
	{"FF31", 4, 13675},
	{"FF32", 4, 13676},
	{"FF33", 4, 13677},
	{"FF34", 4, 13678},
	{"FF35", 4, 13679},
	{"FF36", 4, 13680},
	{"FF37", 4, 13681},
	{"FF38", 4, 13682},
	{"FF39", 4, 13683},
	{"FF40", 4, 13684},
	{"FF41", 4, 13685},
	{"FF42", 4, 13686},
	{"FF43", 4, 13687},
	{"FF44", 4, 13688},
	{"FF45", 4, 13689},
	{"FF46", 4, 13690},
	{"FF47", 4, 13691},
	{"FF48", 4, 13692},
	{"FF49", 4, 13693},
	{"FF50", 4, 13694},
	{"FF51", 4, 13695},
	{"FF52", 4, 13696},
	{"FF53", 4, 13697},
	{"FF54", 4, 13698},
	{"FF55", 4, 13699},
	{"FF56", 4, 13700},
	{"FF57", 4, 13701},
	{"FF58", 4, 13702},
	{"FF59", 4, 13703},
	{"FF60", 4, 13704},
	{"FF61", 4, 13705},
	{"FF62", 4, 13706},
	{"FF63", 4, 13707},
	{"FF64", 4, 13708},
	{"FF65", 4, 13709},
	{"FF66", 4, 13710},
	{"FF67", 4, 13711},
	{"FF68", 4, 13712},
	{"FF69", 4, 13713},
	{"FF70", 4, 13714},
	{"FF71", 4, 13715},
	{"FF72", 4, 13716},
	{"FF73", 4, 13717},
	{"FF74", 4, 13718},
	{"FF75", 4, 13719},
	{"FF76", 4, 13720},
	{"FF77", 4, 13721},
	{"FF78", 4, 13722},
	{"FF79", 4, 13723},
	{"FF80", 4, 13724},
	{"FF81", 4, 13725},
	{"FF82", 4, 13726},
	{"FF83", 4, 13727},
	{"FF84", 4, 13728},
	{"FF85", 4, 13729},
	{"FF86", 4, 13730},
	{"FF87", 4, 13731},
	{"FF88", 4, 13732},
	{"FF89", 4, 13733},
	{"FF90", 4, 13734},
	{"FF91", 4, 13735},
	{"FF92", 4, 13736},
	{"FF93", 4, 13737},
	{"FF94", 4, 13738},
	{"FF95", 4, 13739},
	{"FF96", 4, 13740},
	{"FF97", 4, 13741},
	{"FF98", 4, 13742},
	{"FF99", 4, 13743},
	{"FG00", 4, 13744},
	{"FG01", 4, 13745},
	{"FG02", 4, 13746},
	{"FG03", 4, 13747},
	{"FG04", 4, 13748},
	{"FG05", 4, 13749},
	{"FG06", 4, 13750},
	{"FG07", 4, 13751},
	{"FG08", 4, 13752},
	{"FG09", 4, 13753},
	{"FG10", 4, 13754},
	{"FG11", 4, 13755},
	{"FG12", 4, 13756},
	{"FG13", 4, 13757},
	{"FG14", 4, 13758},
	{"FG15", 4, 13759},
	{"FG16", 4, 13760},
	{"FG17", 4, 13761},
	{"FG18", 4, 13762},
	{"FG19", 4, 13763},
	{"FG20", 4, 13764},
	{"FG21", 4, 13765},
	{"FG22", 4, 13766},
	{"FG23", 4, 13767},
	{"FG24", 4, 13768},
	{"FG25", 4, 13769},
	{"FG26", 4, 13770},
	{"FG27", 4, 13771},
	{"FG28", 4, 13772},
	{"FG29", 4, 13773},
	{"FG30", 4, 13774},
	{"FG31", 4, 13775},
	{"FG32", 4, 13776},
	{"FG33", 4, 13777},
	{"FG34", 4, 13778},
	{"FG35", 4, 13779},
	{"FG36", 4, 13780},
	{"FG37", 4, 13781},
	{"FG38", 4, 13782},
	{"FG39", 4, 13783},
	{"FG40", 4, 13784},
	{"FG41", 4, 13785},
	{"FG42", 4, 13786},
	{"FG43", 4, 13787},
	{"FG44", 4, 13788},
	{"FG45", 4, 13789},
	{"FG46", 4, 13790},
	{"FG47", 4, 13791},
	{"FG48", 4, 13792},
	{"FG49", 4, 13793},
	{"FG50", 4, 13794},
	{"FG51", 4, 13795},
	{"FG52", 4, 13796},
	{"FG53", 4, 13797},
	{"FG54", 4, 13798},
	{"FG55", 4, 13799},
	{"FG56", 4, 13800},
	{"FG57", 4, 13801},
	{"FG58", 4, 13802},
	{"FG59", 4, 13803},
	{"FG60", 4, 13804},
	{"FG61", 4, 13805},
	{"FG62", 4, 13806},
	{"FG63", 4, 13807},
	{"FG64", 4, 13808},
	{"FG65", 4, 13809},
	{"FG66", 4, 13810},
	{"FG67", 4, 13811},
	{"FG68", 4, 13812},
	{"FG69", 4, 13813},
	{"FG70", 4, 13814},
	{"FG71", 4, 13815},
	{"FG72", 4, 13816},
	{"FG73", 4, 13817},
	{"FG74", 4, 13818},
	{"FG75", 4, 13819},
	{"FG76", 4, 13820},
	{"FG77", 4, 13821},
	{"FG78", 4, 13822},
	{"FG79", 4, 13823},
	{"FG80", 4, 13824},
	{"FG81", 4, 13825},
	{"FG82", 4, 13826},
	{"FG83", 4, 13827},
	{"FG84", 4, 13828},
	{"FG85", 4, 13829},
	{"FG86", 4, 13830},
	{"FG87", 4, 13831},
	{"FG88", 4, 13832},
	{"FG89", 4, 13833},
	{"FG90", 4, 13834},
	{"FG91", 4, 13835},
	{"FG92", 4, 13836},
	{"FG93", 4, 13837},
	{"FG94", 4, 13838},
	{"FG95", 4, 13839},
	{"FG96", 4, 13840},
	{"FG97", 4, 13841},
	{"FG98", 4, 13842},
	{"FG99", 4, 13843},
	{"FH00", 4, 13844},
	{"FH01", 4, 13845},
	{"FH02", 4, 13846},
	{"FH03", 4, 13847},
	{"FH04", 4, 13848},
	{"FH05", 4, 13849},
	{"FH06", 4, 13850},
	{"FH07", 4, 13851},
	{"FH08", 4, 13852},
	{"FH09", 4, 13853},
	{"FH10", 4, 13854},
	{"FH11", 4, 13855},
	{"FH12", 4, 13856},
	{"FH13", 4, 13857},
	{"FH14", 4, 13858},
	{"FH15", 4, 13859},
	{"FH16", 4, 13860},
	{"FH17", 4, 13861},
	{"FH18", 4, 13862},
	{"FH19", 4, 13863},
	{"FH20", 4, 13864},
	{"FH21", 4, 13865},
	{"FH22", 4, 13866},
	{"FH23", 4, 13867},
	{"FH24", 4, 13868},
	{"FH25", 4, 13869},
	{"FH26", 4, 13870},
	{"FH27", 4, 13871},
	{"FH28", 4, 13872},
	{"FH29", 4, 13873},
	{"FH30", 4, 13874},
	{"FH31", 4, 13875},
	{"FH32", 4, 13876},
	{"FH33", 4, 13877},
	{"FH34", 4, 13878},
	{"FH35", 4, 13879},
	{"FH36", 4, 13880},
	{"FH37", 4, 13881},
	{"FH38", 4, 13882},
	{"FH39", 4, 13883},
	{"FH40", 4, 13884},
	{"FH41", 4, 13885},
	{"FH42", 4, 13886},
	{"FH43", 4, 13887},
	{"FH44", 4, 13888},
	{"FH45", 4, 13889},
	{"FH46", 4, 13890},
	{"FH47", 4, 13891},
	{"FH48", 4, 13892},
	{"FH49", 4, 13893},
	{"FH50", 4, 13894},
	{"FH51", 4, 13895},
	{"FH52", 4, 13896},
	{"FH53", 4, 13897},
	{"FH54", 4, 13898},
	{"FH55", 4, 13899},
	{"FH56", 4, 13900},
	{"FH57", 4, 13901},
	{"FH58", 4, 13902},
	{"FH59", 4, 13903},
	{"FH60", 4, 13904},
	{"FH61", 4, 13905},
	{"FH62", 4, 13906},
	{"FH63", 4, 13907},
	{"FH64", 4, 13908},
	{"FH65", 4, 13909},
	{"FH66", 4, 13910},
	{"FH67", 4, 13911},
	{"FH68", 4, 13912},
	{"FH69", 4, 13913},
	{"FH70", 4, 13914},
	{"FH71", 4, 13915},
	{"FH72", 4, 13916},
	{"FH73", 4, 13917},
	{"FH74", 4, 13918},
	{"FH75", 4, 13919},
	{"FH76", 4, 13920},
	{"FH77", 4, 13921},
	{"FH78", 4, 13922},
	{"FH79", 4, 13923},
	{"FH80", 4, 13924},
	{"FH81", 4, 13925},
	{"FH82", 4, 13926},
	{"FH83", 4, 13927},
	{"FH84", 4, 13928},
	{"FH85", 4, 13929},
	{"FH86", 4, 13930},
	{"FH87", 4, 13931},
	{"FH88", 4, 13932},
	{"FH89", 4, 13933},
	{"FH90", 4, 13934},
	{"FH91", 4, 13935},
	{"FH92", 4, 13936},
	{"FH93", 4, 13937},
	{"FH94", 4, 13938},
	{"FH95", 4, 13939},
	{"FH96", 4, 13940},
	{"FH97", 4, 13941},
	{"FH98", 4, 13942},
	{"FH99", 4, 13943},
	{"FI00", 4, 13944},
	{"FI01", 4, 13945},
	{"FI02", 4, 13946},
	{"FI03", 4, 13947},
	{"FI04", 4, 13948},
	{"FI05", 4, 13949},
	{"FI06", 4, 13950},
	{"FI07", 4, 13951},
	{"FI08", 4, 13952},
	{"FI09", 4, 13953},
	{"FI10", 4, 13954},
	{"FI11", 4, 13955},
	{"FI12", 4, 13956},
	{"FI13", 4, 13957},
	{"FI14", 4, 13958},
	{"FI15", 4, 13959},
	{"FI16", 4, 13960},
	{"FI17", 4, 13961},
	{"FI18", 4, 13962},
	{"FI19", 4, 13963},
	{"FI20", 4, 13964},
	{"FI21", 4, 13965},
	{"FI22", 4, 13966},
	{"FI23", 4, 13967},
	{"FI24", 4, 13968},
	{"FI25", 4, 13969},
	{"FI26", 4, 13970},
	{"FI27", 4, 13971},
	{"FI28", 4, 13972},
	{"FI29", 4, 13973},
	{"FI30", 4, 13974},
	{"FI31", 4, 13975},
	{"FI32", 4, 13976},
	{"FI33", 4, 13977},
	{"FI34", 4, 13978},
	{"FI35", 4, 13979},
	{"FI36", 4, 13980},
	{"FI37", 4, 13981},
	{"FI38", 4, 13982},
	{"FI39", 4, 13983},
	{"FI40", 4, 13984},
	{"FI41", 4, 13985},
	{"FI42", 4, 13986},
	{"FI43", 4, 13987},
	{"FI44", 4, 13988},
	{"FI45", 4, 13989},
	{"FI46", 4, 13990},
	{"FI47", 4, 13991},
	{"FI48", 4, 13992},
	{"FI49", 4, 13993},
	{"FI50", 4, 13994},
	{"FI51", 4, 13995},
	{"FI52", 4, 13996},
	{"FI53", 4, 13997},
	{"FI54", 4, 13998},
	{"FI55", 4, 13999},
	{"FI56", 4, 14000},
	{"FI57", 4, 14001},
	{"FI58", 4, 14002},
	{"FI59", 4, 14003},
	{"FI60", 4, 14004},
	{"FI61", 4, 14005},
	{"FI62", 4, 14006},
	{"FI63", 4, 14007},
	{"FI64", 4, 14008},
	{"FI65", 4, 14009},
	{"FI66", 4, 14010},
	{"FI67", 4, 14011},
	{"FI68", 4, 14012},
	{"FI69", 4, 14013},
	{"FI70", 4, 14014},
	{"FI71", 4, 14015},
	{"FI72", 4, 14016},
	{"FI73", 4, 14017},
	{"FI74", 4, 14018},
	{"FI75", 4, 14019},
	{"FI76", 4, 14020},
	{"FI77", 4, 14021},
	{"FI78", 4, 14022},
	{"FI79", 4, 14023},
	{"FI80", 4, 14024},
	{"FI81", 4, 14025},
	{"FI82", 4, 14026},
	{"FI83", 4, 14027},
	{"FI84", 4, 14028},
	{"FI85", 4, 14029},
	{"FI86", 4, 14030},
	{"FI87", 4, 14031},
	{"FI88", 4, 14032},
	{"FI89", 4, 14033},
	{"FI90", 4, 14034},
	{"FI91", 4, 14035},
	{"FI92", 4, 14036},
	{"FI93", 4, 14037},
	{"FI94", 4, 14038},
	{"FI95", 4, 14039},
	{"FI96", 4, 14040},
	{"FI97", 4, 14041},
	{"FI98", 4, 14042},
	{"FI99", 4, 14043},
	{"FJ00", 4, 14044},
	{"FJ01", 4, 14045},
	{"FJ02", 4, 14046},
	{"FJ03", 4, 14047},
	{"FJ04", 4, 14048},
	{"FJ05", 4, 14049},
	{"FJ06", 4, 14050},
	{"FJ07", 4, 14051},
	{"FJ08", 4, 14052},
	{"FJ09", 4, 14053},
	{"FJ10", 4, 14054},
	{"FJ11", 4, 14055},
	{"FJ12", 4, 14056},
	{"FJ13", 4, 14057},
	{"FJ14", 4, 14058},
	{"FJ15", 4, 14059},
	{"FJ16", 4, 14060},
	{"FJ17", 4, 14061},
	{"FJ18", 4, 14062},
	{"FJ19", 4, 14063},
	{"FJ20", 4, 14064},
	{"FJ21", 4, 14065},
	{"FJ22", 4, 14066},
	{"FJ23", 4, 14067},
	{"FJ24", 4, 14068},
	{"FJ25", 4, 14069},
	{"FJ26", 4, 14070},
	{"FJ27", 4, 14071},
	{"FJ28", 4, 14072},
	{"FJ29", 4, 14073},
	{"FJ30", 4, 14074},
	{"FJ31", 4, 14075},
	{"FJ32", 4, 14076},
	{"FJ33", 4, 14077},
	{"FJ34", 4, 14078},
	{"FJ35", 4, 14079},
	{"FJ36", 4, 14080},
	{"FJ37", 4, 14081},
	{"FJ38", 4, 14082},
	{"FJ39", 4, 14083},
	{"FJ40", 4, 14084},
	{"FJ41", 4, 14085},
	{"FJ42", 4, 14086},
	{"FJ43", 4, 14087},
	{"FJ44", 4, 14088},
	{"FJ45", 4, 14089},
	{"FJ46", 4, 14090},
	{"FJ47", 4, 14091},
	{"FJ48", 4, 14092},
	{"FJ49", 4, 14093},
	{"FJ50", 4, 14094},
	{"FJ51", 4, 14095},
	{"FJ52", 4, 14096},
	{"FJ53", 4, 14097},
	{"FJ54", 4, 14098},
	{"FJ55", 4, 14099},
	{"FJ56", 4, 14100},
	{"FJ57", 4, 14101},
	{"FJ58", 4, 14102},
	{"FJ59", 4, 14103},
	{"FJ60", 4, 14104},
	{"FJ61", 4, 14105},
	{"FJ62", 4, 14106},
	{"FJ63", 4, 14107},
	{"FJ64", 4, 14108},
	{"FJ65", 4, 14109},
	{"FJ66", 4, 14110},
	{"FJ67", 4, 14111},
	{"FJ68", 4, 14112},
	{"FJ69", 4, 14113},
	{"FJ70", 4, 14114},
	{"FJ71", 4, 14115},
	{"FJ72", 4, 14116},
	{"FJ73", 4, 14117},
	{"FJ74", 4, 14118},
	{"FJ75", 4, 14119},
	{"FJ76", 4, 14120},
	{"FJ77", 4, 14121},
	{"FJ78", 4, 14122},
	{"FJ79", 4, 14123},
	{"FJ80", 4, 14124},
	{"FJ81", 4, 14125},
	{"FJ82", 4, 14126},
	{"FJ83", 4, 14127},
	{"FJ84", 4, 14128},
	{"FJ85", 4, 14129},
	{"FJ86", 4, 14130},
	{"FJ87", 4, 14131},
	{"FJ88", 4, 14132},
	{"FJ89", 4, 14133},
	{"FJ90", 4, 14134},
	{"FJ91", 4, 14135},
	{"FJ92", 4, 14136},
	{"FJ93", 4, 14137},
	{"FJ94", 4, 14138},
	{"FJ95", 4, 14139},
	{"FJ96", 4, 14140},
	{"FJ97", 4, 14141},
	{"FJ98", 4, 14142},
	{"FJ99", 4, 14143},
	{"FK00", 4, 14144},
	{"FK01", 4, 14145},
	{"FK02", 4, 14146},
	{"FK03", 4, 14147},
	{"FK04", 4, 14148},
	{"FK05", 4, 14149},
	{"FK06", 4, 14150},
	{"FK07", 4, 14151},
	{"FK08", 4, 14152},
	{"FK09", 4, 14153},
	{"FK10", 4, 14154},
	{"FK11", 4, 14155},
	{"FK12", 4, 14156},
	{"FK13", 4, 14157},
	{"FK14", 4, 14158},
	{"FK15", 4, 14159},
	{"FK16", 4, 14160},
	{"FK17", 4, 14161},
	{"FK18", 4, 14162},
	{"FK19", 4, 14163},
	{"FK20", 4, 14164},
	{"FK21", 4, 14165},
	{"FK22", 4, 14166},
	{"FK23", 4, 14167},
	{"FK24", 4, 14168},
	{"FK25", 4, 14169},
	{"FK26", 4, 14170},
	{"FK27", 4, 14171},
	{"FK28", 4, 14172},
	{"FK29", 4, 14173},
	{"FK30", 4, 14174},
	{"FK31", 4, 14175},
	{"FK32", 4, 14176},
	{"FK33", 4, 14177},
	{"FK34", 4, 14178},
	{"FK35", 4, 14179},
	{"FK36", 4, 14180},
	{"FK37", 4, 14181},
	{"FK38", 4, 14182},
	{"FK39", 4, 14183},
	{"FK40", 4, 14184},
	{"FK41", 4, 14185},
	{"FK42", 4, 14186},
	{"FK43", 4, 14187},
	{"FK44", 4, 14188},
	{"FK45", 4, 14189},
	{"FK46", 4, 14190},
	{"FK47", 4, 14191},
	{"FK48", 4, 14192},
	{"FK49", 4, 14193},
	{"FK50", 4, 14194},
	{"FK51", 4, 14195},
	{"FK52", 4, 14196},
	{"FK53", 4, 14197},
	{"FK54", 4, 14198},
	{"FK55", 4, 14199},
	{"FK56", 4, 14200},
	{"FK57", 4, 14201},
	{"FK58", 4, 14202},
	{"FK59", 4, 14203},
	{"FK60", 4, 14204},
	{"FK61", 4, 14205},
	{"FK62", 4, 14206},
	{"FK63", 4, 14207},
	{"FK64", 4, 14208},
	{"FK65", 4, 14209},
	{"FK66", 4, 14210},
	{"FK67", 4, 14211},
	{"FK68", 4, 14212},
	{"FK69", 4, 14213},
	{"FK70", 4, 14214},
	{"FK71", 4, 14215},
	{"FK72", 4, 14216},
	{"FK73", 4, 14217},
	{"FK74", 4, 14218},
	{"FK75", 4, 14219},
	{"FK76", 4, 14220},
	{"FK77", 4, 14221},
	{"FK78", 4, 14222},
	{"FK79", 4, 14223},
	{"FK80", 4, 14224},
	{"FK81", 4, 14225},
	{"FK82", 4, 14226},
	{"FK83", 4, 14227},
	{"FK84", 4, 14228},
	{"FK85", 4, 14229},
	{"FK86", 4, 14230},
	{"FK87", 4, 14231},
	{"FK88", 4, 14232},
	{"FK89", 4, 14233},
	{"FK90", 4, 14234},
	{"FK91", 4, 14235},
	{"FK92", 4, 14236},
	{"FK93", 4, 14237},
	{"FK94", 4, 14238},
	{"FK95", 4, 14239},
	{"FK96", 4, 14240},
	{"FK97", 4, 14241},
	{"FK98", 4, 14242},
	{"FK99", 4, 14243},
	{"FL00", 4, 14244},
	{"FL01", 4, 14245},
	{"FL02", 4, 14246},
	{"FL03", 4, 14247},
	{"FL04", 4, 14248},
	{"FL05", 4, 14249},
	{"FL06", 4, 14250},
	{"FL07", 4, 14251},
	{"FL08", 4, 14252},
	{"FL09", 4, 14253},
	{"FL10", 4, 14254},
	{"FL11", 4, 14255},
	{"FL12", 4, 14256},
	{"FL13", 4, 14257},
	{"FL14", 4, 14258},
	{"FL15", 4, 14259},
	{"FL16", 4, 14260},
	{"FL17", 4, 14261},
	{"FL18", 4, 14262},
	{"FL19", 4, 14263},
	{"FL20", 4, 14264},
	{"FL21", 4, 14265},
	{"FL22", 4, 14266},
	{"FL23", 4, 14267},
	{"FL24", 4, 14268},
	{"FL25", 4, 14269},
	{"FL26", 4, 14270},
	{"FL27", 4, 14271},
	{"FL28", 4, 14272},
	{"FL29", 4, 14273},
	{"FL30", 4, 14274},
	{"FL31", 4, 14275},
	{"FL32", 4, 14276},
	{"FL33", 4, 14277},
	{"FL34", 4, 14278},
	{"FL35", 4, 14279},
	{"FL36", 4, 14280},
	{"FL37", 4, 14281},
	{"FL38", 4, 14282},
	{"FL39", 4, 14283},
	{"FL40", 4, 14284},
	{"FL41", 4, 14285},
	{"FL42", 4, 14286},
	{"FL43", 4, 14287},
	{"FL44", 4, 14288},
	{"FL45", 4, 14289},
	{"FL46", 4, 14290},
	{"FL47", 4, 14291},
	{"FL48", 4, 14292},
	{"FL49", 4, 14293},
	{"FL50", 4, 14294},
	{"FL51", 4, 14295},
	{"FL52", 4, 14296},
	{"FL53", 4, 14297},
	{"FL54", 4, 14298},
	{"FL55", 4, 14299},
	{"FL56", 4, 14300},
	{"FL57", 4, 14301},
	{"FL58", 4, 14302},
	{"FL59", 4, 14303},
	{"FL60", 4, 14304},
	{"FL61", 4, 14305},
	{"FL62", 4, 14306},
	{"FL63", 4, 14307},
	{"FL64", 4, 14308},
	{"FL65", 4, 14309},
	{"FL66", 4, 14310},
	{"FL67", 4, 14311},
	{"FL68", 4, 14312},
	{"FL69", 4, 14313},
	{"FL70", 4, 14314},
	{"FL71", 4, 14315},
	{"FL72", 4, 14316},
	{"FL73", 4, 14317},
	{"FL74", 4, 14318},
	{"FL75", 4, 14319},
	{"FL76", 4, 14320},
	{"FL77", 4, 14321},
	{"FL78", 4, 14322},
	{"FL79", 4, 14323},
	{"FL80", 4, 14324},
	{"FL81", 4, 14325},
	{"FL82", 4, 14326},
	{"FL83", 4, 14327},
	{"FL84", 4, 14328},
	{"FL85", 4, 14329},
	{"FL86", 4, 14330},
	{"FL87", 4, 14331},
	{"FL88", 4, 14332},
	{"FL89", 4, 14333},
	{"FL90", 4, 14334},
	{"FL91", 4, 14335},
	{"FL92", 4, 14336},
	{"FL93", 4, 14337},
	{"FL94", 4, 14338},
	{"FL95", 4, 14339},
	{"FL96", 4, 14340},
	{"FL97", 4, 14341},
	{"FL98", 4, 14342},
	{"FL99", 4, 14343},
	{"FM00", 4, 14344},
	{"FM01", 4, 14345},
	{"FM02", 4, 14346},
	{"FM03", 4, 14347},
	{"FM04", 4, 14348},
	{"FM05", 4, 14349},
	{"FM06", 4, 14350},
	{"FM07", 4, 14351},
	{"FM08", 4, 14352},
	{"FM09", 4, 14353},
	{"FM10", 4, 14354},
	{"FM11", 4, 14355},
	{"FM12", 4, 14356},
	{"FM13", 4, 14357},
	{"FM14", 4, 14358},
	{"FM15", 4, 14359},
	{"FM16", 4, 14360},
	{"FM17", 4, 14361},
	{"FM18", 4, 14362},
	{"FM19", 4, 14363},
	{"FM20", 4, 14364},
	{"FM21", 4, 14365},
	{"FM22", 4, 14366},
	{"FM23", 4, 14367},
	{"FM24", 4, 14368},
	{"FM25", 4, 14369},
	{"FM26", 4, 14370},
	{"FM27", 4, 14371},
	{"FM28", 4, 14372},
	{"FM29", 4, 14373},
	{"FM30", 4, 14374},
	{"FM31", 4, 14375},
	{"FM32", 4, 14376},
	{"FM33", 4, 14377},
	{"FM34", 4, 14378},
	{"FM35", 4, 14379},
	{"FM36", 4, 14380},
	{"FM37", 4, 14381},
	{"FM38", 4, 14382},
	{"FM39", 4, 14383},
	{"FM40", 4, 14384},
	{"FM41", 4, 14385},
	{"FM42", 4, 14386},
	{"FM43", 4, 14387},
	{"FM44", 4, 14388},
	{"FM45", 4, 14389},
	{"FM46", 4, 14390},
	{"FM47", 4, 14391},
	{"FM48", 4, 14392},
	{"FM49", 4, 14393},
	{"FM50", 4, 14394},
	{"FM51", 4, 14395},
	{"FM52", 4, 14396},
	{"FM53", 4, 14397},
	{"FM54", 4, 14398},
	{"FM55", 4, 14399},
	{"FM56", 4, 14400},
	{"FM57", 4, 14401},
	{"FM58", 4, 14402},
	{"FM59", 4, 14403},
	{"FM60", 4, 14404},
	{"FM61", 4, 14405},
	{"FM62", 4, 14406},
	{"FM63", 4, 14407},
	{"FM64", 4, 14408},
	{"FM65", 4, 14409},
	{"FM66", 4, 14410},
	{"FM67", 4, 14411},
	{"FM68", 4, 14412},
	{"FM69", 4, 14413},
	{"FM70", 4, 14414},
	{"FM71", 4, 14415},
	{"FM72", 4, 14416},
	{"FM73", 4, 14417},
	{"FM74", 4, 14418},
	{"FM75", 4, 14419},
	{"FM76", 4, 14420},
	{"FM77", 4, 14421},
	{"FM78", 4, 14422},
	{"FM79", 4, 14423},
	{"FM80", 4, 14424},
	{"FM81", 4, 14425},
	{"FM82", 4, 14426},
	{"FM83", 4, 14427},
	{"FM84", 4, 14428},
	{"FM85", 4, 14429},
	{"FM86", 4, 14430},
	{"FM87", 4, 14431},
	{"FM88", 4, 14432},
	{"FM89", 4, 14433},
	{"FM90", 4, 14434},
	{"FM91", 4, 14435},
	{"FM92", 4, 14436},
	{"FM93", 4, 14437},
	{"FM94", 4, 14438},
	{"FM95", 4, 14439},
	{"FM96", 4, 14440},
	{"FM97", 4, 14441},
	{"FM98", 4, 14442},
	{"FM99", 4, 14443},
	{"FN00", 4, 14444},
	{"FN01", 4, 14445},
	{"FN02", 4, 14446},
	{"FN03", 4, 14447},
	{"FN04", 4, 14448},
	{"FN05", 4, 14449},
	{"FN06", 4, 14450},
	{"FN07", 4, 14451},
	{"FN08", 4, 14452},
	{"FN09", 4, 14453},
	{"FN10", 4, 14454},
	{"FN11", 4, 14455},
	{"FN12", 4, 14456},
	{"FN13", 4, 14457},
	{"FN14", 4, 14458},
	{"FN15", 4, 14459},
	{"FN16", 4, 14460},
	{"FN17", 4, 14461},
	{"FN18", 4, 14462},
	{"FN19", 4, 14463},
	{"FN20", 4, 14464},
	{"FN21", 4, 14465},
	{"FN22", 4, 14466},
	{"FN23", 4, 14467},
	{"FN24", 4, 14468},
	{"FN25", 4, 14469},
	{"FN26", 4, 14470},
	{"FN27", 4, 14471},
	{"FN28", 4, 14472},
	{"FN29", 4, 14473},
	{"FN30", 4, 14474},
	{"FN31", 4, 14475},
	{"FN32", 4, 14476},
	{"FN33", 4, 14477},
	{"FN34", 4, 14478},
	{"FN35", 4, 14479},
	{"FN36", 4, 14480},
	{"FN37", 4, 14481},
	{"FN38", 4, 14482},
	{"FN39", 4, 14483},
	{"FN40", 4, 14484},
	{"FN41", 4, 14485},
	{"FN42", 4, 14486},
	{"FN43", 4, 14487},
	{"FN44", 4, 14488},
	{"FN45", 4, 14489},
	{"FN46", 4, 14490},
	{"FN47", 4, 14491},
	{"FN48", 4, 14492},
	{"FN49", 4, 14493},
	{"FN50", 4, 14494},
	{"FN51", 4, 14495},
	{"FN52", 4, 14496},
	{"FN53", 4, 14497},
	{"FN54", 4, 14498},
	{"FN55", 4, 14499},
	{"FN56", 4, 14500},
	{"FN57", 4, 14501},
	{"FN58", 4, 14502},
	{"FN59", 4, 14503},
	{"FN60", 4, 14504},
	{"FN61", 4, 14505},
	{"FN62", 4, 14506},
	{"FN63", 4, 14507},
	{"FN64", 4, 14508},
	{"FN65", 4, 14509},
	{"FN66", 4, 14510},
	{"FN67", 4, 14511},
	{"FN68", 4, 14512},
	{"FN69", 4, 14513},
	{"FN70", 4, 14514},
	{"FN71", 4, 14515},
	{"FN72", 4, 14516},
	{"FN73", 4, 14517},
	{"FN74", 4, 14518},
	{"FN75", 4, 14519},
	{"FN76", 4, 14520},
	{"FN77", 4, 14521},
	{"FN78", 4, 14522},
	{"FN79", 4, 14523},
	{"FN80", 4, 14524},
	{"FN81", 4, 14525},
	{"FN82", 4, 14526},
	{"FN83", 4, 14527},
	{"FN84", 4, 14528},
	{"FN85", 4, 14529},
	{"FN86", 4, 14530},
	{"FN87", 4, 14531},
	{"FN88", 4, 14532},
	{"FN89", 4, 14533},
	{"FN90", 4, 14534},
	{"FN91", 4, 14535},
	{"FN92", 4, 14536},
	{"FN93", 4, 14537},
	{"FN94", 4, 14538},
	{"FN95", 4, 14539},
	{"FN96", 4, 14540},
	{"FN97", 4, 14541},
	{"FN98", 4, 14542},
	{"FN99", 4, 14543},
	{"FO00", 4, 14544},
	{"FO01", 4, 14545},
	{"FO02", 4, 14546},
	{"FO03", 4, 14547},
	{"FO04", 4, 14548},
	{"FO05", 4, 14549},
	{"FO06", 4, 14550},
	{"FO07", 4, 14551},
	{"FO08", 4, 14552},
	{"FO09", 4, 14553},
	{"FO10", 4, 14554},
	{"FO11", 4, 14555},
	{"FO12", 4, 14556},
	{"FO13", 4, 14557},
	{"FO14", 4, 14558},
	{"FO15", 4, 14559},
	{"FO16", 4, 14560},
	{"FO17", 4, 14561},
	{"FO18", 4, 14562},
	{"FO19", 4, 14563},
	{"FO20", 4, 14564},
	{"FO21", 4, 14565},
	{"FO22", 4, 14566},
	{"FO23", 4, 14567},
	{"FO24", 4, 14568},
	{"FO25", 4, 14569},
	{"FO26", 4, 14570},
	{"FO27", 4, 14571},
	{"FO28", 4, 14572},
	{"FO29", 4, 14573},
	{"FO30", 4, 14574},
	{"FO31", 4, 14575},
	{"FO32", 4, 14576},
	{"FO33", 4, 14577},
	{"FO34", 4, 14578},
	{"FO35", 4, 14579},
	{"FO36", 4, 14580},
	{"FO37", 4, 14581},
	{"FO38", 4, 14582},
	{"FO39", 4, 14583},
	{"FO40", 4, 14584},
	{"FO41", 4, 14585},
	{"FO42", 4, 14586},
	{"FO43", 4, 14587},
	{"FO44", 4, 14588},
	{"FO45", 4, 14589},
	{"FO46", 4, 14590},
	{"FO47", 4, 14591},
	{"FO48", 4, 14592},
	{"FO49", 4, 14593},
	{"FO50", 4, 14594},
	{"FO51", 4, 14595},
	{"FO52", 4, 14596},
	{"FO53", 4, 14597},
	{"FO54", 4, 14598},
	{"FO55", 4, 14599},
	{"FO56", 4, 14600},
	{"FO57", 4, 14601},
	{"FO58", 4, 14602},
	{"FO59", 4, 14603},
	{"FO60", 4, 14604},
	{"FO61", 4, 14605},
	{"FO62", 4, 14606},
	{"FO63", 4, 14607},
	{"FO64", 4, 14608},
	{"FO65", 4, 14609},
	{"FO66", 4, 14610},
	{"FO67", 4, 14611},
	{"FO68", 4, 14612},
	{"FO69", 4, 14613},
	{"FO70", 4, 14614},
	{"FO71", 4, 14615},
	{"FO72", 4, 14616},
	{"FO73", 4, 14617},
	{"FO74", 4, 14618},
	{"FO75", 4, 14619},
	{"FO76", 4, 14620},
	{"FO77", 4, 14621},
	{"FO78", 4, 14622},
	{"FO79", 4, 14623},
	{"FO80", 4, 14624},
	{"FO81", 4, 14625},
	{"FO82", 4, 14626},
	{"FO83", 4, 14627},
	{"FO84", 4, 14628},
	{"FO85", 4, 14629},
	{"FO86", 4, 14630},
	{"FO87", 4, 14631},
	{"FO88", 4, 14632},
	{"FO89", 4, 14633},
	{"FO90", 4, 14634},
	{"FO91", 4, 14635},
	{"FO92", 4, 14636},
	{"FO93", 4, 14637},
	{"FO94", 4, 14638},
	{"FO95", 4, 14639},
	{"FO96", 4, 14640},
	{"FO97", 4, 14641},
	{"FO98", 4, 14642},
	{"FO99", 4, 14643},
	{"FP00", 4, 14644},
	{"FP01", 4, 14645},
	{"FP02", 4, 14646},
	{"FP03", 4, 14647},
	{"FP04", 4, 14648},
	{"FP05", 4, 14649},
	{"FP06", 4, 14650},
	{"FP07", 4, 14651},
	{"FP08", 4, 14652},
	{"FP09", 4, 14653},
	{"FP10", 4, 14654},
	{"FP11", 4, 14655},
	{"FP12", 4, 14656},
	{"FP13", 4, 14657},
	{"FP14", 4, 14658},
	{"FP15", 4, 14659},
	{"FP16", 4, 14660},
	{"FP17", 4, 14661},
	{"FP18", 4, 14662},
	{"FP19", 4, 14663},
	{"FP20", 4, 14664},
	{"FP21", 4, 14665},
	{"FP22", 4, 14666},
	{"FP23", 4, 14667},
	{"FP24", 4, 14668},
	{"FP25", 4, 14669},
	{"FP26", 4, 14670},
	{"FP27", 4, 14671},
	{"FP28", 4, 14672},
	{"FP29", 4, 14673},
	{"FP30", 4, 14674},
	{"FP31", 4, 14675},
	{"FP32", 4, 14676},
	{"FP33", 4, 14677},
	{"FP34", 4, 14678},
	{"FP35", 4, 14679},
	{"FP36", 4, 14680},
	{"FP37", 4, 14681},
	{"FP38", 4, 14682},
	{"FP39", 4, 14683},
	{"FP40", 4, 14684},
	{"FP41", 4, 14685},
	{"FP42", 4, 14686},
	{"FP43", 4, 14687},
	{"FP44", 4, 14688},
	{"FP45", 4, 14689},
	{"FP46", 4, 14690},
	{"FP47", 4, 14691},
	{"FP48", 4, 14692},
	{"FP49", 4, 14693},
	{"FP50", 4, 14694},
	{"FP51", 4, 14695},
	{"FP52", 4, 14696},
	{"FP53", 4, 14697},
	{"FP54", 4, 14698},
	{"FP55", 4, 14699},
	{"FP56", 4, 14700},
	{"FP57", 4, 14701},
	{"FP58", 4, 14702},
	{"FP59", 4, 14703},
	{"FP60", 4, 14704},
	{"FP61", 4, 14705},
	{"FP62", 4, 14706},
	{"FP63", 4, 14707},
	{"FP64", 4, 14708},
	{"FP65", 4, 14709},
	{"FP66", 4, 14710},
	{"FP67", 4, 14711},
	{"FP68", 4, 14712},
	{"FP69", 4, 14713},
	{"FP70", 4, 14714},
	{"FP71", 4, 14715},
	{"FP72", 4, 14716},
	{"FP73", 4, 14717},
	{"FP74", 4, 14718},
	{"FP75", 4, 14719},
	{"FP76", 4, 14720},
	{"FP77", 4, 14721},
	{"FP78", 4, 14722},
	{"FP79", 4, 14723},
	{"FP80", 4, 14724},
	{"FP81", 4, 14725},
	{"FP82", 4, 14726},
	{"FP83", 4, 14727},
	{"FP84", 4, 14728},
	{"FP85", 4, 14729},
	{"FP86", 4, 14730},
	{"FP87", 4, 14731},
	{"FP88", 4, 14732},
	{"FP89", 4, 14733},
	{"FP90", 4, 14734},
	{"FP91", 4, 14735},
	{"FP92", 4, 14736},
	{"FP93", 4, 14737},
	{"FP94", 4, 14738},
	{"FP95", 4, 14739},
	{"FP96", 4, 14740},
	{"FP97", 4, 14741},
	{"FP98", 4, 14742},
	{"FP99", 4, 14743},
	{"FQ00", 4, 14744},
	{"FQ01", 4, 14745},
	{"FQ02", 4, 14746},
	{"FQ03", 4, 14747},
	{"FQ04", 4, 14748},
	{"FQ05", 4, 14749},
	{"FQ06", 4, 14750},
	{"FQ07", 4, 14751},
	{"FQ08", 4, 14752},
	{"FQ09", 4, 14753},
	{"FQ10", 4, 14754},
	{"FQ11", 4, 14755},
	{"FQ12", 4, 14756},
	{"FQ13", 4, 14757},
	{"FQ14", 4, 14758},
	{"FQ15", 4, 14759},
	{"FQ16", 4, 14760},
	{"FQ17", 4, 14761},
	{"FQ18", 4, 14762},
	{"FQ19", 4, 14763},
	{"FQ20", 4, 14764},
	{"FQ21", 4, 14765},
	{"FQ22", 4, 14766},
	{"FQ23", 4, 14767},
	{"FQ24", 4, 14768},
	{"FQ25", 4, 14769},
	{"FQ26", 4, 14770},
	{"FQ27", 4, 14771},
	{"FQ28", 4, 14772},
	{"FQ29", 4, 14773},
	{"FQ30", 4, 14774},
	{"FQ31", 4, 14775},
	{"FQ32", 4, 14776},
	{"FQ33", 4, 14777},
	{"FQ34", 4, 14778},
	{"FQ35", 4, 14779},
	{"FQ36", 4, 14780},
	{"FQ37", 4, 14781},
	{"FQ38", 4, 14782},
	{"FQ39", 4, 14783},
	{"FQ40", 4, 14784},
	{"FQ41", 4, 14785},
	{"FQ42", 4, 14786},
	{"FQ43", 4, 14787},
	{"FQ44", 4, 14788},
	{"FQ45", 4, 14789},
	{"FQ46", 4, 14790},
	{"FQ47", 4, 14791},
	{"FQ48", 4, 14792},
	{"FQ49", 4, 14793},
	{"FQ50", 4, 14794},
	{"FQ51", 4, 14795},
	{"FQ52", 4, 14796},
	{"FQ53", 4, 14797},
	{"FQ54", 4, 14798},
	{"FQ55", 4, 14799},
	{"FQ56", 4, 14800},
	{"FQ57", 4, 14801},
	{"FQ58", 4, 14802},
	{"FQ59", 4, 14803},
	{"FQ60", 4, 14804},
	{"FQ61", 4, 14805},
	{"FQ62", 4, 14806},
	{"FQ63", 4, 14807},
	{"FQ64", 4, 14808},
	{"FQ65", 4, 14809},
	{"FQ66", 4, 14810},
	{"FQ67", 4, 14811},
	{"FQ68", 4, 14812},
	{"FQ69", 4, 14813},
	{"FQ70", 4, 14814},
	{"FQ71", 4, 14815},
	{"FQ72", 4, 14816},
	{"FQ73", 4, 14817},
	{"FQ74", 4, 14818},
	{"FQ75", 4, 14819},
	{"FQ76", 4, 14820},
	{"FQ77", 4, 14821},
	{"FQ78", 4, 14822},
	{"FQ79", 4, 14823},
	{"FQ80", 4, 14824},
	{"FQ81", 4, 14825},
	{"FQ82", 4, 14826},
	{"FQ83", 4, 14827},
	{"FQ84", 4, 14828},
	{"FQ85", 4, 14829},
	{"FQ86", 4, 14830},
	{"FQ87", 4, 14831},
	{"FQ88", 4, 14832},
	{"FQ89", 4, 14833},
	{"FQ90", 4, 14834},
	{"FQ91", 4, 14835},
	{"FQ92", 4, 14836},
	{"FQ93", 4, 14837},
	{"FQ94", 4, 14838},
	{"FQ95", 4, 14839},
	{"FQ96", 4, 14840},
	{"FQ97", 4, 14841},
	{"FQ98", 4, 14842},
	{"FQ99", 4, 14843},
	{"GF00", 4, 14844},
	{"GF01", 4, 14845},
	{"GF02", 4, 14846},
	{"GF03", 4, 14847},
	{"GF04", 4, 14848},
	{"GF05", 4, 14849},
	{"GF06", 4, 14850},
	{"GF07", 4, 14851},
	{"GF08", 4, 14852},
	{"GF09", 4, 14853},
	{"GF10", 4, 14854},
	{"GF11", 4, 14855},
	{"GF12", 4, 14856},
	{"GF13", 4, 14857},
	{"GF14", 4, 14858},
	{"GF15", 4, 14859},
	{"GF16", 4, 14860},
	{"GF17", 4, 14861},
	{"GF18", 4, 14862},
	{"GF19", 4, 14863},
	{"GF20", 4, 14864},
	{"GF21", 4, 14865},
	{"GF22", 4, 14866},
	{"GF23", 4, 14867},
	{"GF24", 4, 14868},
	{"GF25", 4, 14869},
	{"GF26", 4, 14870},
	{"GF27", 4, 14871},
	{"GF28", 4, 14872},
	{"GF29", 4, 14873},
	{"GF30", 4, 14874},
	{"GF31", 4, 14875},
	{"GF32", 4, 14876},
	{"GF33", 4, 14877},
	{"GF34", 4, 14878},
	{"GF35", 4, 14879},
	{"GF36", 4, 14880},
	{"GF37", 4, 14881},
	{"GF38", 4, 14882},
	{"GF39", 4, 14883},
	{"GF40", 4, 14884},
	{"GF41", 4, 14885},
	{"GF42", 4, 14886},
	{"GF43", 4, 14887},
	{"GF44", 4, 14888},
	{"GF45", 4, 14889},
	{"GF46", 4, 14890},
	{"GF47", 4, 14891},
	{"GF48", 4, 14892},
	{"GF49", 4, 14893},
	{"GF50", 4, 14894},
	{"GF51", 4, 14895},
	{"GF52", 4, 14896},
	{"GF53", 4, 14897},
	{"GF54", 4, 14898},
	{"GF55", 4, 14899},
	{"GF56", 4, 14900},
	{"GF57", 4, 14901},
	{"GF58", 4, 14902},
	{"GF59", 4, 14903},
	{"GF60", 4, 14904},
	{"GF61", 4, 14905},
	{"GF62", 4, 14906},
	{"GF63", 4, 14907},
	{"GF64", 4, 14908},
	{"GF65", 4, 14909},
	{"GF66", 4, 14910},
	{"GF67", 4, 14911},
	{"GF68", 4, 14912},
	{"GF69", 4, 14913},
	{"GF70", 4, 14914},
	{"GF71", 4, 14915},
	{"GF72", 4, 14916},
	{"GF73", 4, 14917},
	{"GF74", 4, 14918},
	{"GF75", 4, 14919},
	{"GF76", 4, 14920},
	{"GF77", 4, 14921},
	{"GF78", 4, 14922},
	{"GF79", 4, 14923},
	{"GF80", 4, 14924},
	{"GF81", 4, 14925},
	{"GF82", 4, 14926},
	{"GF83", 4, 14927},
	{"GF84", 4, 14928},
	{"GF85", 4, 14929},
	{"GF86", 4, 14930},
	{"GF87", 4, 14931},
	{"GF88", 4, 14932},
	{"GF89", 4, 14933},
	{"GF90", 4, 14934},
	{"GF91", 4, 14935},
	{"GF92", 4, 14936},
	{"GF93", 4, 14937},
	{"GF94", 4, 14938},
	{"GF95", 4, 14939},
	{"GF96", 4, 14940},
	{"GF97", 4, 14941},
	{"GF98", 4, 14942},
	{"GF99", 4, 14943},
	{"GG00", 4, 14944},
	{"GG01", 4, 14945},
	{"GG02", 4, 14946},
	{"GG03", 4, 14947},
	{"GG04", 4, 14948},
	{"GG05", 4, 14949},
	{"GG06", 4, 14950},
	{"GG07", 4, 14951},
	{"GG08", 4, 14952},
	{"GG09", 4, 14953},
	{"GG10", 4, 14954},
	{"GG11", 4, 14955},
	{"GG12", 4, 14956},
	{"GG13", 4, 14957},
	{"GG14", 4, 14958},
	{"GG15", 4, 14959},
	{"GG16", 4, 14960},
	{"GG17", 4, 14961},
	{"GG18", 4, 14962},
	{"GG19", 4, 14963},
	{"GG20", 4, 14964},
	{"GG21", 4, 14965},
	{"GG22", 4, 14966},
	{"GG23", 4, 14967},
	{"GG24", 4, 14968},
	{"GG25", 4, 14969},
	{"GG26", 4, 14970},
	{"GG27", 4, 14971},
	{"GG28", 4, 14972},
	{"GG29", 4, 14973},
	{"GG30", 4, 14974},
	{"GG31", 4, 14975},
	{"GG32", 4, 14976},
	{"GG33", 4, 14977},
	{"GG34", 4, 14978},
	{"GG35", 4, 14979},
	{"GG36", 4, 14980},
	{"GG37", 4, 14981},
	{"GG38", 4, 14982},
	{"GG39", 4, 14983},
	{"GG40", 4, 14984},
	{"GG41", 4, 14985},
	{"GG42", 4, 14986},
	{"GG43", 4, 14987},
	{"GG44", 4, 14988},
	{"GG45", 4, 14989},
	{"GG46", 4, 14990},
	{"GG47", 4, 14991},
	{"GG48", 4, 14992},
	{"GG49", 4, 14993},
	{"GG50", 4, 14994},
	{"GG51", 4, 14995},
	{"GG52", 4, 14996},
	{"GG53", 4, 14997},
	{"GG54", 4, 14998},
	{"GG55", 4, 14999},
	{"GG56", 4, 15000},
	{"GG57", 4, 15001},
	{"GG58", 4, 15002},
	{"GG59", 4, 15003},
	{"GG60", 4, 15004},
	{"GG61", 4, 15005},
	{"GG62", 4, 15006},
	{"GG63", 4, 15007},
	{"GG64", 4, 15008},
	{"GG65", 4, 15009},
	{"GG66", 4, 15010},
	{"GG67", 4, 15011},
	{"GG68", 4, 15012},
	{"GG69", 4, 15013},
	{"GG70", 4, 15014},
	{"GG71", 4, 15015},
	{"GG72", 4, 15016},
	{"GG73", 4, 15017},
	{"GG74", 4, 15018},
	{"GG75", 4, 15019},
	{"GG76", 4, 15020},
	{"GG77", 4, 15021},
	{"GG78", 4, 15022},
	{"GG79", 4, 15023},
	{"GG80", 4, 15024},
	{"GG81", 4, 15025},
	{"GG82", 4, 15026},
	{"GG83", 4, 15027},
	{"GG84", 4, 15028},
	{"GG85", 4, 15029},
	{"GG86", 4, 15030},
	{"GG87", 4, 15031},
	{"GG88", 4, 15032},
	{"GG89", 4, 15033},
	{"GG90", 4, 15034},
	{"GG91", 4, 15035},
	{"GG92", 4, 15036},
	{"GG93", 4, 15037},
	{"GG94", 4, 15038},
	{"GG95", 4, 15039},
	{"GG96", 4, 15040},
	{"GG97", 4, 15041},
	{"GG98", 4, 15042},
	{"GG99", 4, 15043},
	{"GH00", 4, 15044},
	{"GH01", 4, 15045},
	{"GH02", 4, 15046},
	{"GH03", 4, 15047},
	{"GH04", 4, 15048},
	{"GH05", 4, 15049},
	{"GH06", 4, 15050},
	{"GH07", 4, 15051},
	{"GH08", 4, 15052},
	{"GH09", 4, 15053},
	{"GH10", 4, 15054},
	{"GH11", 4, 15055},
	{"GH12", 4, 15056},
	{"GH13", 4, 15057},
	{"GH14", 4, 15058},
	{"GH15", 4, 15059},
	{"GH16", 4, 15060},
	{"GH17", 4, 15061},
	{"GH18", 4, 15062},
	{"GH19", 4, 15063},
	{"GH20", 4, 15064},
	{"GH21", 4, 15065},
	{"GH22", 4, 15066},
	{"GH23", 4, 15067},
	{"GH24", 4, 15068},
	{"GH25", 4, 15069},
	{"GH26", 4, 15070},
	{"GH27", 4, 15071},
	{"GH28", 4, 15072},
	{"GH29", 4, 15073},
	{"GH30", 4, 15074},
	{"GH31", 4, 15075},
	{"GH32", 4, 15076},
	{"GH33", 4, 15077},
	{"GH34", 4, 15078},
	{"GH35", 4, 15079},
	{"GH36", 4, 15080},
	{"GH37", 4, 15081},
	{"GH38", 4, 15082},
	{"GH39", 4, 15083},
	{"GH40", 4, 15084},
	{"GH41", 4, 15085},
	{"GH42", 4, 15086},
	{"GH43", 4, 15087},
	{"GH44", 4, 15088},
	{"GH45", 4, 15089},
	{"GH46", 4, 15090},
	{"GH47", 4, 15091},
	{"GH48", 4, 15092},
	{"GH49", 4, 15093},
	{"GH50", 4, 15094},
	{"GH51", 4, 15095},
	{"GH52", 4, 15096},
	{"GH53", 4, 15097},
	{"GH54", 4, 15098},
	{"GH55", 4, 15099},
	{"GH56", 4, 15100},
	{"GH57", 4, 15101},
	{"GH58", 4, 15102},
	{"GH59", 4, 15103},
	{"GH60", 4, 15104},
	{"GH61", 4, 15105},
	{"GH62", 4, 15106},
	{"GH63", 4, 15107},
	{"GH64", 4, 15108},
	{"GH65", 4, 15109},
	{"GH66", 4, 15110},
	{"GH67", 4, 15111},
	{"GH68", 4, 15112},
	{"GH69", 4, 15113},
	{"GH70", 4, 15114},
	{"GH71", 4, 15115},
	{"GH72", 4, 15116},
	{"GH73", 4, 15117},
	{"GH74", 4, 15118},
	{"GH75", 4, 15119},
	{"GH76", 4, 15120},
	{"GH77", 4, 15121},
	{"GH78", 4, 15122},
	{"GH79", 4, 15123},
	{"GH80", 4, 15124},
	{"GH81", 4, 15125},
	{"GH82", 4, 15126},
	{"GH83", 4, 15127},
	{"GH84", 4, 15128},
	{"GH85", 4, 15129},
	{"GH86", 4, 15130},
	{"GH87", 4, 15131},
	{"GH88", 4, 15132},
	{"GH89", 4, 15133},
	{"GH90", 4, 15134},
	{"GH91", 4, 15135},
	{"GH92", 4, 15136},
	{"GH93", 4, 15137},
	{"GH94", 4, 15138},
	{"GH95", 4, 15139},
	{"GH96", 4, 15140},
	{"GH97", 4, 15141},
	{"GH98", 4, 15142},
	{"GH99", 4, 15143},
	{"GI00", 4, 15144},
	{"GI01", 4, 15145},
	{"GI02", 4, 15146},
	{"GI03", 4, 15147},
	{"GI04", 4, 15148},
	{"GI05", 4, 15149},
	{"GI06", 4, 15150},
	{"GI07", 4, 15151},
	{"GI08", 4, 15152},
	{"GI09", 4, 15153},
	{"GI10", 4, 15154},
	{"GI11", 4, 15155},
	{"GI12", 4, 15156},
	{"GI13", 4, 15157},
	{"GI14", 4, 15158},
	{"GI15", 4, 15159},
	{"GI16", 4, 15160},
	{"GI17", 4, 15161},
	{"GI18", 4, 15162},
	{"GI19", 4, 15163},
	{"GI20", 4, 15164},
	{"GI21", 4, 15165},
	{"GI22", 4, 15166},
	{"GI23", 4, 15167},
	{"GI24", 4, 15168},
	{"GI25", 4, 15169},
	{"GI26", 4, 15170},
	{"GI27", 4, 15171},
	{"GI28", 4, 15172},
	{"GI29", 4, 15173},
	{"GI30", 4, 15174},
	{"GI31", 4, 15175},
	{"GI32", 4, 15176},
	{"GI33", 4, 15177},
	{"GI34", 4, 15178},
	{"GI35", 4, 15179},
	{"GI36", 4, 15180},
	{"GI37", 4, 15181},
	{"GI38", 4, 15182},
	{"GI39", 4, 15183},
	{"GI40", 4, 15184},
	{"GI41", 4, 15185},
	{"GI42", 4, 15186},
	{"GI43", 4, 15187},
	{"GI44", 4, 15188},
	{"GI45", 4, 15189},
	{"GI46", 4, 15190},
	{"GI47", 4, 15191},
	{"GI48", 4, 15192},
	{"GI49", 4, 15193},
	{"GI50", 4, 15194},
	{"GI51", 4, 15195},
	{"GI52", 4, 15196},
	{"GI53", 4, 15197},
	{"GI54", 4, 15198},
	{"GI55", 4, 15199},
	{"GI56", 4, 15200},
	{"GI57", 4, 15201},
	{"GI58", 4, 15202},
	{"GI59", 4, 15203},
	{"GI60", 4, 15204},
	{"GI61", 4, 15205},
	{"GI62", 4, 15206},
	{"GI63", 4, 15207},
	{"GI64", 4, 15208},
	{"GI65", 4, 15209},
	{"GI66", 4, 15210},
	{"GI67", 4, 15211},
	{"GI68", 4, 15212},
	{"GI69", 4, 15213},
	{"GI70", 4, 15214},
	{"GI71", 4, 15215},
	{"GI72", 4, 15216},
	{"GI73", 4, 15217},
	{"GI74", 4, 15218},
	{"GI75", 4, 15219},
	{"GI76", 4, 15220},
	{"GI77", 4, 15221},
	{"GI78", 4, 15222},
	{"GI79", 4, 15223},
	{"GI80", 4, 15224},
	{"GI81", 4, 15225},
	{"GI82", 4, 15226},
	{"GI83", 4, 15227},
	{"GI84", 4, 15228},
	{"GI85", 4, 15229},
	{"GI86", 4, 15230},
	{"GI87", 4, 15231},
	{"GI88", 4, 15232},
	{"GI89", 4, 15233},
	{"GI90", 4, 15234},
	{"GI91", 4, 15235},
	{"GI92", 4, 15236},
	{"GI93", 4, 15237},
	{"GI94", 4, 15238},
	{"GI95", 4, 15239},
	{"GI96", 4, 15240},
	{"GI97", 4, 15241},
	{"GI98", 4, 15242},
	{"GI99", 4, 15243},
	{"GJ00", 4, 15244},
	{"GJ01", 4, 15245},
	{"GJ02", 4, 15246},
	{"GJ03", 4, 15247},
	{"GJ04", 4, 15248},
	{"GJ05", 4, 15249},
	{"GJ06", 4, 15250},
	{"GJ07", 4, 15251},
	{"GJ08", 4, 15252},
	{"GJ09", 4, 15253},
	{"GJ10", 4, 15254},
	{"GJ11", 4, 15255},
	{"GJ12", 4, 15256},
	{"GJ13", 4, 15257},
	{"GJ14", 4, 15258},
	{"GJ15", 4, 15259},
	{"GJ16", 4, 15260},
	{"GJ17", 4, 15261},
	{"GJ18", 4, 15262},
	{"GJ19", 4, 15263},
	{"GJ20", 4, 15264},
	{"GJ21", 4, 15265},
	{"GJ22", 4, 15266},
	{"GJ23", 4, 15267},
	{"GJ24", 4, 15268},
	{"GJ25", 4, 15269},
	{"GJ26", 4, 15270},
	{"GJ27", 4, 15271},
	{"GJ28", 4, 15272},
	{"GJ29", 4, 15273},
	{"GJ30", 4, 15274},
	{"GJ31", 4, 15275},
	{"GJ32", 4, 15276},
	{"GJ33", 4, 15277},
	{"GJ34", 4, 15278},
	{"GJ35", 4, 15279},
	{"GJ36", 4, 15280},
	{"GJ37", 4, 15281},
	{"GJ38", 4, 15282},
	{"GJ39", 4, 15283},
	{"GJ40", 4, 15284},
	{"GJ41", 4, 15285},
	{"GJ42", 4, 15286},
	{"GJ43", 4, 15287},
	{"GJ44", 4, 15288},
	{"GJ45", 4, 15289},
	{"GJ46", 4, 15290},
	{"GJ47", 4, 15291},
	{"GJ48", 4, 15292},
	{"GJ49", 4, 15293},
	{"GJ50", 4, 15294},
	{"GJ51", 4, 15295},
	{"GJ52", 4, 15296},
	{"GJ53", 4, 15297},
	{"GJ54", 4, 15298},
	{"GJ55", 4, 15299},
	{"GJ56", 4, 15300},
	{"GJ57", 4, 15301},
	{"GJ58", 4, 15302},
	{"GJ59", 4, 15303},
	{"GJ60", 4, 15304},
	{"GJ61", 4, 15305},
	{"GJ62", 4, 15306},
	{"GJ63", 4, 15307},
	{"GJ64", 4, 15308},
	{"GJ65", 4, 15309},
	{"GJ66", 4, 15310},
	{"GJ67", 4, 15311},
	{"GJ68", 4, 15312},
	{"GJ69", 4, 15313},
	{"GJ70", 4, 15314},
	{"GJ71", 4, 15315},
	{"GJ72", 4, 15316},
	{"GJ73", 4, 15317},
	{"GJ74", 4, 15318},
	{"GJ75", 4, 15319},
	{"GJ76", 4, 15320},
	{"GJ77", 4, 15321},
	{"GJ78", 4, 15322},
	{"GJ79", 4, 15323},
	{"GJ80", 4, 15324},
	{"GJ81", 4, 15325},
	{"GJ82", 4, 15326},
	{"GJ83", 4, 15327},
	{"GJ84", 4, 15328},
	{"GJ85", 4, 15329},
	{"GJ86", 4, 15330},
	{"GJ87", 4, 15331},
	{"GJ88", 4, 15332},
	{"GJ89", 4, 15333},
	{"GJ90", 4, 15334},
	{"GJ91", 4, 15335},
	{"GJ92", 4, 15336},
	{"GJ93", 4, 15337},
	{"GJ94", 4, 15338},
	{"GJ95", 4, 15339},
	{"GJ96", 4, 15340},
	{"GJ97", 4, 15341},
	{"GJ98", 4, 15342},
	{"GJ99", 4, 15343},
	{"GN00", 4, 15344},
	{"GN01", 4, 15345},
	{"GN02", 4, 15346},
	{"GN03", 4, 15347},
	{"GN04", 4, 15348},
	{"GN05", 4, 15349},
	{"GN06", 4, 15350},
	{"GN07", 4, 15351},
	{"GN08", 4, 15352},
	{"GN09", 4, 15353},
	{"GN10", 4, 15354},
	{"GN11", 4, 15355},
	{"GN12", 4, 15356},
	{"GN13", 4, 15357},
	{"GN14", 4, 15358},
	{"GN15", 4, 15359},
	{"GN16", 4, 15360},
	{"GN17", 4, 15361},
	{"GN18", 4, 15362},
	{"GN19", 4, 15363},
	{"GN20", 4, 15364},
	{"GN21", 4, 15365},
	{"GN22", 4, 15366},
	{"GN23", 4, 15367},
	{"GN24", 4, 15368},
	{"GN25", 4, 15369},
	{"GN26", 4, 15370},
	{"GN27", 4, 15371},
	{"GN28", 4, 15372},
	{"GN29", 4, 15373},
	{"GN30", 4, 15374},
	{"GN31", 4, 15375},
	{"GN32", 4, 15376},
	{"GN33", 4, 15377},
	{"GN34", 4, 15378},
	{"GN35", 4, 15379},
	{"GN36", 4, 15380},
	{"GN37", 4, 15381},
	{"GN38", 4, 15382},
	{"GN39", 4, 15383},
	{"GN40", 4, 15384},
	{"GN41", 4, 15385},
	{"GN42", 4, 15386},
	{"GN43", 4, 15387},
	{"GN44", 4, 15388},
	{"GN45", 4, 15389},
	{"GN46", 4, 15390},
	{"GN47", 4, 15391},
	{"GN48", 4, 15392},
	{"GN49", 4, 15393},
	{"GN50", 4, 15394},
	{"GN51", 4, 15395},
	{"GN52", 4, 15396},
	{"GN53", 4, 15397},
	{"GN54", 4, 15398},
	{"GN55", 4, 15399},
	{"GN56", 4, 15400},
	{"GN57", 4, 15401},
	{"GN58", 4, 15402},
	{"GN59", 4, 15403},
	{"GN60", 4, 15404},
	{"GN61", 4, 15405},
	{"GN62", 4, 15406},
	{"GN63", 4, 15407},
	{"GN64", 4, 15408},
	{"GN65", 4, 15409},
	{"GN66", 4, 15410},
	{"GN67", 4, 15411},
	{"GN68", 4, 15412},
	{"GN69", 4, 15413},
	{"GN70", 4, 15414},
	{"GN71", 4, 15415},
	{"GN72", 4, 15416},
	{"GN73", 4, 15417},
	{"GN74", 4, 15418},
	{"GN75", 4, 15419},
	{"GN76", 4, 15420},
	{"GN77", 4, 15421},
	{"GN78", 4, 15422},
	{"GN79", 4, 15423},
	{"GN80", 4, 15424},
	{"GN81", 4, 15425},
	{"GN82", 4, 15426},
	{"GN83", 4, 15427},
	{"GN84", 4, 15428},
	{"GN85", 4, 15429},
	{"GN86", 4, 15430},
	{"GN87", 4, 15431},
	{"GN88", 4, 15432},
	{"GN89", 4, 15433},
	{"GN90", 4, 15434},
	{"GN91", 4, 15435},
	{"GN92", 4, 15436},
	{"GN93", 4, 15437},
	{"GN94", 4, 15438},
	{"GN95", 4, 15439},
	{"GN96", 4, 15440},
	{"GN97", 4, 15441},
	{"GN98", 4, 15442},
	{"GN99", 4, 15443},
	{"GO00", 4, 15444},
	{"GO01", 4, 15445},
	{"GO02", 4, 15446},
	{"GO03", 4, 15447},
	{"GO04", 4, 15448},
	{"GO05", 4, 15449},
	{"GO06", 4, 15450},
	{"GO07", 4, 15451},
	{"GO08", 4, 15452},
	{"GO09", 4, 15453},
	{"GO10", 4, 15454},
	{"GO11", 4, 15455},
	{"GO12", 4, 15456},
	{"GO13", 4, 15457},
	{"GO14", 4, 15458},
	{"GO15", 4, 15459},
	{"GO16", 4, 15460},
	{"GO17", 4, 15461},
	{"GO18", 4, 15462},
	{"GO19", 4, 15463},
	{"GO20", 4, 15464},
	{"GO21", 4, 15465},
	{"GO22", 4, 15466},
	{"GO23", 4, 15467},
	{"GO24", 4, 15468},
	{"GO25", 4, 15469},
	{"GO26", 4, 15470},
	{"GO27", 4, 15471},
	{"GO28", 4, 15472},
	{"GO29", 4, 15473},
	{"GO30", 4, 15474},
	{"GO31", 4, 15475},
	{"GO32", 4, 15476},
	{"GO33", 4, 15477},
	{"GO34", 4, 15478},
	{"GO35", 4, 15479},
	{"GO36", 4, 15480},
	{"GO37", 4, 15481},
	{"GO38", 4, 15482},
	{"GO39", 4, 15483},
	{"GO40", 4, 15484},
	{"GO41", 4, 15485},
	{"GO42", 4, 15486},
	{"GO43", 4, 15487},
	{"GO44", 4, 15488},
	{"GO45", 4, 15489},
	{"GO46", 4, 15490},
	{"GO47", 4, 15491},
	{"GO48", 4, 15492},
	{"GO49", 4, 15493},
	{"GO50", 4, 15494},
	{"GO51", 4, 15495},
	{"GO52", 4, 15496},
	{"GO53", 4, 15497},
	{"GO54", 4, 15498},
	{"GO55", 4, 15499},
	{"GO56", 4, 15500},
	{"GO57", 4, 15501},
	{"GO58", 4, 15502},
	{"GO59", 4, 15503},
	{"GO60", 4, 15504},
	{"GO61", 4, 15505},
	{"GO62", 4, 15506},
	{"GO63", 4, 15507},
	{"GO64", 4, 15508},
	{"GO65", 4, 15509},
	{"GO66", 4, 15510},
	{"GO67", 4, 15511},
	{"GO68", 4, 15512},
	{"GO69", 4, 15513},
	{"GO70", 4, 15514},
	{"GO71", 4, 15515},
	{"GO72", 4, 15516},
	{"GO73", 4, 15517},
	{"GO74", 4, 15518},
	{"GO75", 4, 15519},
	{"GO76", 4, 15520},
	{"GO77", 4, 15521},
	{"GO78", 4, 15522},
	{"GO79", 4, 15523},
	{"GO80", 4, 15524},
	{"GO81", 4, 15525},
	{"GO82", 4, 15526},
	{"GO83", 4, 15527},
	{"GO84", 4, 15528},
	{"GO85", 4, 15529},
	{"GO86", 4, 15530},
	{"GO87", 4, 15531},
	{"GO88", 4, 15532},
	{"GO89", 4, 15533},
	{"GO90", 4, 15534},
	{"GO91", 4, 15535},
	{"GO92", 4, 15536},
	{"GO93", 4, 15537},
	{"GO94", 4, 15538},
	{"GO95", 4, 15539},
	{"GO96", 4, 15540},
	{"GO97", 4, 15541},
	{"GO98", 4, 15542},
	{"GO99", 4, 15543},
	{"GP00", 4, 15544},
	{"GP01", 4, 15545},
	{"GP02", 4, 15546},
	{"GP03", 4, 15547},
	{"GP04", 4, 15548},
	{"GP05", 4, 15549},
	{"GP06", 4, 15550},
	{"GP07", 4, 15551},
	{"GP08", 4, 15552},
	{"GP09", 4, 15553},
	{"GP10", 4, 15554},
	{"GP11", 4, 15555},
	{"GP12", 4, 15556},
	{"GP13", 4, 15557},
	{"GP14", 4, 15558},
	{"GP15", 4, 15559},
	{"GP16", 4, 15560},
	{"GP17", 4, 15561},
	{"GP18", 4, 15562},
	{"GP19", 4, 15563},
	{"GP20", 4, 15564},
	{"GP21", 4, 15565},
	{"GP22", 4, 15566},
	{"GP23", 4, 15567},
	{"GP24", 4, 15568},
	{"GP25", 4, 15569},
	{"GP26", 4, 15570},
	{"GP27", 4, 15571},
	{"GP28", 4, 15572},
	{"GP29", 4, 15573},
	{"GP30", 4, 15574},
	{"GP31", 4, 15575},
	{"GP32", 4, 15576},
	{"GP33", 4, 15577},
	{"GP34", 4, 15578},
	{"GP35", 4, 15579},
	{"GP36", 4, 15580},
	{"GP37", 4, 15581},
	{"GP38", 4, 15582},
	{"GP39", 4, 15583},
	{"GP40", 4, 15584},
	{"GP41", 4, 15585},
	{"GP42", 4, 15586},
	{"GP43", 4, 15587},
	{"GP44", 4, 15588},
	{"GP45", 4, 15589},
	{"GP46", 4, 15590},
	{"GP47", 4, 15591},
	{"GP48", 4, 15592},
	{"GP49", 4, 15593},
	{"GP50", 4, 15594},
	{"GP51", 4, 15595},
	{"GP52", 4, 15596},
	{"GP53", 4, 15597},
	{"GP54", 4, 15598},
	{"GP55", 4, 15599},
	{"GP56", 4, 15600},
	{"GP57", 4, 15601},
	{"GP58", 4, 15602},
	{"GP59", 4, 15603},
	{"GP60", 4, 15604},
	{"GP61", 4, 15605},
	{"GP62", 4, 15606},
	{"GP63", 4, 15607},
	{"GP64", 4, 15608},
	{"GP65", 4, 15609},
	{"GP66", 4, 15610},
	{"GP67", 4, 15611},
	{"GP68", 4, 15612},
	{"GP69", 4, 15613},
	{"GP70", 4, 15614},
	{"GP71", 4, 15615},
	{"GP72", 4, 15616},
	{"GP73", 4, 15617},
	{"GP74", 4, 15618},
	{"GP75", 4, 15619},
	{"GP76", 4, 15620},
	{"GP77", 4, 15621},
	{"GP78", 4, 15622},
	{"GP79", 4, 15623},
	{"GP80", 4, 15624},
	{"GP81", 4, 15625},
	{"GP82", 4, 15626},
	{"GP83", 4, 15627},
	{"GP84", 4, 15628},
	{"GP85", 4, 15629},
	{"GP86", 4, 15630},
	{"GP87", 4, 15631},
	{"GP88", 4, 15632},
	{"GP89", 4, 15633},
	{"GP90", 4, 15634},
	{"GP91", 4, 15635},
	{"GP92", 4, 15636},
	{"GP93", 4, 15637},
	{"GP94", 4, 15638},
	{"GP95", 4, 15639},
	{"GP96", 4, 15640},
	{"GP97", 4, 15641},
	{"GP98", 4, 15642},
	{"GP99", 4, 15643},
	{"GQ00", 4, 15644},
	{"GQ01", 4, 15645},
	{"GQ02", 4, 15646},
	{"GQ03", 4, 15647},
	{"GQ04", 4, 15648},
	{"GQ05", 4, 15649},
	{"GQ06", 4, 15650},
	{"GQ07", 4, 15651},
	{"GQ08", 4, 15652},
	{"GQ09", 4, 15653},
	{"GQ10", 4, 15654},
	{"GQ11", 4, 15655},
	{"GQ12", 4, 15656},
	{"GQ13", 4, 15657},
	{"GQ14", 4, 15658},
	{"GQ15", 4, 15659},
	{"GQ16", 4, 15660},
	{"GQ17", 4, 15661},
	{"GQ18", 4, 15662},
	{"GQ19", 4, 15663},
	{"GQ20", 4, 15664},
	{"GQ21", 4, 15665},
	{"GQ22", 4, 15666},
	{"GQ23", 4, 15667},
	{"GQ24", 4, 15668},
	{"GQ25", 4, 15669},
	{"GQ26", 4, 15670},
	{"GQ27", 4, 15671},
	{"GQ28", 4, 15672},
	{"GQ29", 4, 15673},
	{"GQ30", 4, 15674},
	{"GQ31", 4, 15675},
	{"GQ32", 4, 15676},
	{"GQ33", 4, 15677},
	{"GQ34", 4, 15678},
	{"GQ35", 4, 15679},
	{"GQ36", 4, 15680},
	{"GQ37", 4, 15681},
	{"GQ38", 4, 15682},
	{"GQ39", 4, 15683},
	{"GQ40", 4, 15684},
	{"GQ41", 4, 15685},
	{"GQ42", 4, 15686},
	{"GQ43", 4, 15687},
	{"GQ44", 4, 15688},
	{"GQ45", 4, 15689},
	{"GQ46", 4, 15690},
	{"GQ47", 4, 15691},
	{"GQ48", 4, 15692},
	{"GQ49", 4, 15693},
	{"GQ50", 4, 15694},
	{"GQ51", 4, 15695},
	{"GQ52", 4, 15696},
	{"GQ53", 4, 15697},
	{"GQ54", 4, 15698},
	{"GQ55", 4, 15699},
	{"GQ56", 4, 15700},
	{"GQ57", 4, 15701},
	{"GQ58", 4, 15702},
	{"GQ59", 4, 15703},
	{"GQ60", 4, 15704},
	{"GQ61", 4, 15705},
	{"GQ62", 4, 15706},
	{"GQ63", 4, 15707},
	{"GQ64", 4, 15708},
	{"GQ65", 4, 15709},
	{"GQ66", 4, 15710},
	{"GQ67", 4, 15711},
	{"GQ68", 4, 15712},
	{"GQ69", 4, 15713},
	{"GQ70", 4, 15714},
	{"GQ71", 4, 15715},
	{"GQ72", 4, 15716},
	{"GQ73", 4, 15717},
	{"GQ74", 4, 15718},
	{"GQ75", 4, 15719},
	{"GQ76", 4, 15720},
	{"GQ77", 4, 15721},
	{"GQ78", 4, 15722},
	{"GQ79", 4, 15723},
	{"GQ80", 4, 15724},
	{"GQ81", 4, 15725},
	{"GQ82", 4, 15726},
	{"GQ83", 4, 15727},
	{"GQ84", 4, 15728},
	{"GQ85", 4, 15729},
	{"GQ86", 4, 15730},
	{"GQ87", 4, 15731},
	{"GQ88", 4, 15732},
	{"GQ89", 4, 15733},
	{"GQ90", 4, 15734},
	{"GQ91", 4, 15735},
	{"GQ92", 4, 15736},
	{"GQ93", 4, 15737},
	{"GQ94", 4, 15738},
	{"GQ95", 4, 15739},
	{"GQ96", 4, 15740},
	{"GQ97", 4, 15741},
	{"GQ98", 4, 15742},
	{"GQ99", 4, 15743},
	{"HB00", 4, 15744},
	{"HB01", 4, 15745},
	{"HB02", 4, 15746},
	{"HB03", 4, 15747},
	{"HB04", 4, 15748},
	{"HB05", 4, 15749},
	{"HB06", 4, 15750},
	{"HB07", 4, 15751},
	{"HB08", 4, 15752},
	{"HB09", 4, 15753},
	{"HB10", 4, 15754},
	{"HB11", 4, 15755},
	{"HB12", 4, 15756},
	{"HB13", 4, 15757},
	{"HB14", 4, 15758},
	{"HB15", 4, 15759},
	{"HB16", 4, 15760},
	{"HB17", 4, 15761},
	{"HB18", 4, 15762},
	{"HB19", 4, 15763},
	{"HB20", 4, 15764},
	{"HB21", 4, 15765},
	{"HB22", 4, 15766},
	{"HB23", 4, 15767},
	{"HB24", 4, 15768},
	{"HB25", 4, 15769},
	{"HB26", 4, 15770},
	{"HB27", 4, 15771},
	{"HB28", 4, 15772},
	{"HB29", 4, 15773},
	{"HB30", 4, 15774},
	{"HB31", 4, 15775},
	{"HB32", 4, 15776},
	{"HB33", 4, 15777},
	{"HB34", 4, 15778},
	{"HB35", 4, 15779},
	{"HB36", 4, 15780},
	{"HB37", 4, 15781},
	{"HB38", 4, 15782},
	{"HB39", 4, 15783},
	{"HB40", 4, 15784},
	{"HB41", 4, 15785},
	{"HB42", 4, 15786},
	{"HB43", 4, 15787},
	{"HB44", 4, 15788},
	{"HB45", 4, 15789},
	{"HB46", 4, 15790},
	{"HB47", 4, 15791},
	{"HB48", 4, 15792},
	{"HB49", 4, 15793},
	{"HB50", 4, 15794},
	{"HB51", 4, 15795},
	{"HB52", 4, 15796},
	{"HB53", 4, 15797},
	{"HB54", 4, 15798},
	{"HB55", 4, 15799},
	{"HB56", 4, 15800},
	{"HB57", 4, 15801},
	{"HB58", 4, 15802},
	{"HB59", 4, 15803},
	{"HB60", 4, 15804},
	{"HB61", 4, 15805},
	{"HB62", 4, 15806},
	{"HB63", 4, 15807},
	{"HB64", 4, 15808},
	{"HB65", 4, 15809},
	{"HB66", 4, 15810},
	{"HB67", 4, 15811},
	{"HB68", 4, 15812},
	{"HB69", 4, 15813},
	{"HB70", 4, 15814},
	{"HB71", 4, 15815},
	{"HB72", 4, 15816},
	{"HB73", 4, 15817},
	{"HB74", 4, 15818},
	{"HB75", 4, 15819},
	{"HB76", 4, 15820},
	{"HB77", 4, 15821},
	{"HB78", 4, 15822},
	{"HB79", 4, 15823},
	{"HB80", 4, 15824},
	{"HB81", 4, 15825},
	{"HB82", 4, 15826},
	{"HB83", 4, 15827},
	{"HB84", 4, 15828},
	{"HB85", 4, 15829},
	{"HB86", 4, 15830},
	{"HB87", 4, 15831},
	{"HB88", 4, 15832},
	{"HB89", 4, 15833},
	{"HB90", 4, 15834},
	{"HB91", 4, 15835},
	{"HB92", 4, 15836},
	{"HB93", 4, 15837},
	{"HB94", 4, 15838},
	{"HB95", 4, 15839},
	{"HB96", 4, 15840},
	{"HB97", 4, 15841},
	{"HB98", 4, 15842},
	{"HB99", 4, 15843},
	{"HD00", 4, 15844},
	{"HD01", 4, 15845},
	{"HD02", 4, 15846},
	{"HD03", 4, 15847},
	{"HD04", 4, 15848},
	{"HD05", 4, 15849},
	{"HD06", 4, 15850},
	{"HD07", 4, 15851},
	{"HD08", 4, 15852},
	{"HD09", 4, 15853},
	{"HD10", 4, 15854},
	{"HD11", 4, 15855},
	{"HD12", 4, 15856},
	{"HD13", 4, 15857},
	{"HD14", 4, 15858},
	{"HD15", 4, 15859},
	{"HD16", 4, 15860},
	{"HD17", 4, 15861},
	{"HD18", 4, 15862},
	{"HD19", 4, 15863},
	{"HD20", 4, 15864},
	{"HD21", 4, 15865},
	{"HD22", 4, 15866},
	{"HD23", 4, 15867},
	{"HD24", 4, 15868},
	{"HD25", 4, 15869},
	{"HD26", 4, 15870},
	{"HD27", 4, 15871},
	{"HD28", 4, 15872},
	{"HD29", 4, 15873},
	{"HD30", 4, 15874},
	{"HD31", 4, 15875},
	{"HD32", 4, 15876},
	{"HD33", 4, 15877},
	{"HD34", 4, 15878},
	{"HD35", 4, 15879},
	{"HD36", 4, 15880},
	{"HD37", 4, 15881},
	{"HD38", 4, 15882},
	{"HD39", 4, 15883},
	{"HD40", 4, 15884},
	{"HD41", 4, 15885},
	{"HD42", 4, 15886},
	{"HD43", 4, 15887},
	{"HD44", 4, 15888},
	{"HD45", 4, 15889},
	{"HD46", 4, 15890},
	{"HD47", 4, 15891},
	{"HD48", 4, 15892},
	{"HD49", 4, 15893},
	{"HD50", 4, 15894},
	{"HD51", 4, 15895},
	{"HD52", 4, 15896},
	{"HD53", 4, 15897},
	{"HD54", 4, 15898},
	{"HD55", 4, 15899},
	{"HD56", 4, 15900},
	{"HD57", 4, 15901},
	{"HD58", 4, 15902},
	{"HD59", 4, 15903},
	{"HD60", 4, 15904},
	{"HD61", 4, 15905},
	{"HD62", 4, 15906},
	{"HD63", 4, 15907},
	{"HD64", 4, 15908},
	{"HD65", 4, 15909},
	{"HD66", 4, 15910},
	{"HD67", 4, 15911},
	{"HD68", 4, 15912},
	{"HD69", 4, 15913},
	{"HD70", 4, 15914},
	{"HD71", 4, 15915},
	{"HD72", 4, 15916},
	{"HD73", 4, 15917},
	{"HD74", 4, 15918},
	{"HD75", 4, 15919},
	{"HD76", 4, 15920},
	{"HD77", 4, 15921},
	{"HD78", 4, 15922},
	{"HD79", 4, 15923},
	{"HD80", 4, 15924},
	{"HD81", 4, 15925},
	{"HD82", 4, 15926},
	{"HD83", 4, 15927},
	{"HD84", 4, 15928},
	{"HD85", 4, 15929},
	{"HD86", 4, 15930},
	{"HD87", 4, 15931},
	{"HD88", 4, 15932},
	{"HD89", 4, 15933},
	{"HD90", 4, 15934},
	{"HD91", 4, 15935},
	{"HD92", 4, 15936},
	{"HD93", 4, 15937},
	{"HD94", 4, 15938},
	{"HD95", 4, 15939},
	{"HD96", 4, 15940},
	{"HD97", 4, 15941},
	{"HD98", 4, 15942},
	{"HD99", 4, 15943},
	{"HH00", 4, 15944},
	{"HH01", 4, 15945},
	{"HH02", 4, 15946},
	{"HH03", 4, 15947},
	{"HH04", 4, 15948},
	{"HH05", 4, 15949},
	{"HH06", 4, 15950},
	{"HH07", 4, 15951},
	{"HH08", 4, 15952},
	{"HH09", 4, 15953},
	{"HH10", 4, 15954},
	{"HH11", 4, 15955},
	{"HH12", 4, 15956},
	{"HH13", 4, 15957},
	{"HH14", 4, 15958},
	{"HH15", 4, 15959},
	{"HH16", 4, 15960},
	{"HH17", 4, 15961},
	{"HH18", 4, 15962},
	{"HH19", 4, 15963},
	{"HH20", 4, 15964},
	{"HH21", 4, 15965},
	{"HH22", 4, 15966},
	{"HH23", 4, 15967},
	{"HH24", 4, 15968},
	{"HH25", 4, 15969},
	{"HH26", 4, 15970},
	{"HH27", 4, 15971},
	{"HH28", 4, 15972},
	{"HH29", 4, 15973},
	{"HH30", 4, 15974},
	{"HH31", 4, 15975},
	{"HH32", 4, 15976},
	{"HH33", 4, 15977},
	{"HH34", 4, 15978},
	{"HH35", 4, 15979},
	{"HH36", 4, 15980},
	{"HH37", 4, 15981},
	{"HH38", 4, 15982},
	{"HH39", 4, 15983},
	{"HH40", 4, 15984},
	{"HH41", 4, 15985},
	{"HH42", 4, 15986},
	{"HH43", 4, 15987},
	{"HH44", 4, 15988},
	{"HH45", 4, 15989},
	{"HH46", 4, 15990},
	{"HH47", 4, 15991},
	{"HH48", 4, 15992},
	{"HH49", 4, 15993},
	{"HH50", 4, 15994},
	{"HH51", 4, 15995},
	{"HH52", 4, 15996},
	{"HH53", 4, 15997},
	{"HH54", 4, 15998},
	{"HH55", 4, 15999},
	{"HH56", 4, 16000},
	{"HH57", 4, 16001},
	{"HH58", 4, 16002},
	{"HH59", 4, 16003},
	{"HH60", 4, 16004},
	{"HH61", 4, 16005},
	{"HH62", 4, 16006},
	{"HH63", 4, 16007},
	{"HH64", 4, 16008},
	{"HH65", 4, 16009},
	{"HH66", 4, 16010},
	{"HH67", 4, 16011},
	{"HH68", 4, 16012},
	{"HH69", 4, 16013},
	{"HH70", 4, 16014},
	{"HH71", 4, 16015},
	{"HH72", 4, 16016},
	{"HH73", 4, 16017},
	{"HH74", 4, 16018},
	{"HH75", 4, 16019},
	{"HH76", 4, 16020},
	{"HH77", 4, 16021},
	{"HH78", 4, 16022},
	{"HH79", 4, 16023},
	{"HH80", 4, 16024},
	{"HH81", 4, 16025},
	{"HH82", 4, 16026},
	{"HH83", 4, 16027},
	{"HH84", 4, 16028},
	{"HH85", 4, 16029},
	{"HH86", 4, 16030},
	{"HH87", 4, 16031},
	{"HH88", 4, 16032},
	{"HH89", 4, 16033},
	{"HH90", 4, 16034},
	{"HH91", 4, 16035},
	{"HH92", 4, 16036},
	{"HH93", 4, 16037},
	{"HH94", 4, 16038},
	{"HH95", 4, 16039},
	{"HH96", 4, 16040},
	{"HH97", 4, 16041},
	{"HH98", 4, 16042},
	{"HH99", 4, 16043},
	{"HI00", 4, 16044},
	{"HI01", 4, 16045},
	{"HI02", 4, 16046},
	{"HI03", 4, 16047},
	{"HI04", 4, 16048},
	{"HI05", 4, 16049},
	{"HI06", 4, 16050},
	{"HI07", 4, 16051},
	{"HI08", 4, 16052},
	{"HI09", 4, 16053},
	{"HI10", 4, 16054},
	{"HI11", 4, 16055},
	{"HI12", 4, 16056},
	{"HI13", 4, 16057},
	{"HI14", 4, 16058},
	{"HI15", 4, 16059},
	{"HI16", 4, 16060},
	{"HI17", 4, 16061},
	{"HI18", 4, 16062},
	{"HI19", 4, 16063},
	{"HI20", 4, 16064},
	{"HI21", 4, 16065},
	{"HI22", 4, 16066},
	{"HI23", 4, 16067},
	{"HI24", 4, 16068},
	{"HI25", 4, 16069},
	{"HI26", 4, 16070},
	{"HI27", 4, 16071},
	{"HI28", 4, 16072},
	{"HI29", 4, 16073},
	{"HI30", 4, 16074},
	{"HI31", 4, 16075},
	{"HI32", 4, 16076},
	{"HI33", 4, 16077},
	{"HI34", 4, 16078},
	{"HI35", 4, 16079},
	{"HI36", 4, 16080},
	{"HI37", 4, 16081},
	{"HI38", 4, 16082},
	{"HI39", 4, 16083},
	{"HI40", 4, 16084},
	{"HI41", 4, 16085},
	{"HI42", 4, 16086},
	{"HI43", 4, 16087},
	{"HI44", 4, 16088},
	{"HI45", 4, 16089},
	{"HI46", 4, 16090},
	{"HI47", 4, 16091},
	{"HI48", 4, 16092},
	{"HI49", 4, 16093},
	{"HI50", 4, 16094},
	{"HI51", 4, 16095},
	{"HI52", 4, 16096},
	{"HI53", 4, 16097},
	{"HI54", 4, 16098},
	{"HI55", 4, 16099},
	{"HI56", 4, 16100},
	{"HI57", 4, 16101},
	{"HI58", 4, 16102},
	{"HI59", 4, 16103},
	{"HI60", 4, 16104},
	{"HI61", 4, 16105},
	{"HI62", 4, 16106},
	{"HI63", 4, 16107},
	{"HI64", 4, 16108},
	{"HI65", 4, 16109},
	{"HI66", 4, 16110},
	{"HI67", 4, 16111},
	{"HI68", 4, 16112},
	{"HI69", 4, 16113},
	{"HI70", 4, 16114},
	{"HI71", 4, 16115},
	{"HI72", 4, 16116},
	{"HI73", 4, 16117},
	{"HI74", 4, 16118},
	{"HI75", 4, 16119},
	{"HI76", 4, 16120},
	{"HI77", 4, 16121},
	{"HI78", 4, 16122},
	{"HI79", 4, 16123},
	{"HI80", 4, 16124},
	{"HI81", 4, 16125},
	{"HI82", 4, 16126},
	{"HI83", 4, 16127},
	{"HI84", 4, 16128},
	{"HI85", 4, 16129},
	{"HI86", 4, 16130},
	{"HI87", 4, 16131},
	{"HI88", 4, 16132},
	{"HI89", 4, 16133},
	{"HI90", 4, 16134},
	{"HI91", 4, 16135},
	{"HI92", 4, 16136},
	{"HI93", 4, 16137},
	{"HI94", 4, 16138},
	{"HI95", 4, 16139},
	{"HI96", 4, 16140},
	{"HI97", 4, 16141},
	{"HI98", 4, 16142},
	{"HI99", 4, 16143},
	{"HP00", 4, 16144},
	{"HP01", 4, 16145},
	{"HP02", 4, 16146},
	{"HP03", 4, 16147},
	{"HP04", 4, 16148},
	{"HP05", 4, 16149},
	{"HP06", 4, 16150},
	{"HP07", 4, 16151},
	{"HP08", 4, 16152},
	{"HP09", 4, 16153},
	{"HP10", 4, 16154},
	{"HP11", 4, 16155},
	{"HP12", 4, 16156},
	{"HP13", 4, 16157},
	{"HP14", 4, 16158},
	{"HP15", 4, 16159},
	{"HP16", 4, 16160},
	{"HP17", 4, 16161},
	{"HP18", 4, 16162},
	{"HP19", 4, 16163},
	{"HP20", 4, 16164},
	{"HP21", 4, 16165},
	{"HP22", 4, 16166},
	{"HP23", 4, 16167},
	{"HP24", 4, 16168},
	{"HP25", 4, 16169},
	{"HP26", 4, 16170},
	{"HP27", 4, 16171},
	{"HP28", 4, 16172},
	{"HP29", 4, 16173},
	{"HP30", 4, 16174},
	{"HP31", 4, 16175},
	{"HP32", 4, 16176},
	{"HP33", 4, 16177},
	{"HP34", 4, 16178},
	{"HP35", 4, 16179},
	{"HP36", 4, 16180},
	{"HP37", 4, 16181},
	{"HP38", 4, 16182},
	{"HP39", 4, 16183},
	{"HP40", 4, 16184},
	{"HP41", 4, 16185},
	{"HP42", 4, 16186},
	{"HP43", 4, 16187},
	{"HP44", 4, 16188},
	{"HP45", 4, 16189},
	{"HP46", 4, 16190},
	{"HP47", 4, 16191},
	{"HP48", 4, 16192},
	{"HP49", 4, 16193},
	{"HP50", 4, 16194},
	{"HP51", 4, 16195},
	{"HP52", 4, 16196},
	{"HP53", 4, 16197},
	{"HP54", 4, 16198},
	{"HP55", 4, 16199},
	{"HP56", 4, 16200},
	{"HP57", 4, 16201},
	{"HP58", 4, 16202},
	{"HP59", 4, 16203},
	{"HP60", 4, 16204},
	{"HP61", 4, 16205},
	{"HP62", 4, 16206},
	{"HP63", 4, 16207},
	{"HP64", 4, 16208},
	{"HP65", 4, 16209},
	{"HP66", 4, 16210},
	{"HP67", 4, 16211},
	{"HP68", 4, 16212},
	{"HP69", 4, 16213},
	{"HP70", 4, 16214},
	{"HP71", 4, 16215},
	{"HP72", 4, 16216},
	{"HP73", 4, 16217},
	{"HP74", 4, 16218},
	{"HP75", 4, 16219},
	{"HP76", 4, 16220},
	{"HP77", 4, 16221},
	{"HP78", 4, 16222},
	{"HP79", 4, 16223},
	{"HP80", 4, 16224},
	{"HP81", 4, 16225},
	{"HP82", 4, 16226},
	{"HP83", 4, 16227},
	{"HP84", 4, 16228},
	{"HP85", 4, 16229},
	{"HP86", 4, 16230},
	{"HP87", 4, 16231},
	{"HP88", 4, 16232},
	{"HP89", 4, 16233},
	{"HP90", 4, 16234},
	{"HP91", 4, 16235},
	{"HP92", 4, 16236},
	{"HP93", 4, 16237},
	{"HP94", 4, 16238},
	{"HP95", 4, 16239},
	{"HP96", 4, 16240},
	{"HP97", 4, 16241},
	{"HP98", 4, 16242},
	{"HP99", 4, 16243},
	{"HQ00", 4, 16244},
	{"HQ01", 4, 16245},
	{"HQ02", 4, 16246},
	{"HQ03", 4, 16247},
	{"HQ04", 4, 16248},
	{"HQ05", 4, 16249},
	{"HQ06", 4, 16250},
	{"HQ07", 4, 16251},
	{"HQ08", 4, 16252},
	{"HQ09", 4, 16253},
	{"HQ10", 4, 16254},
	{"HQ11", 4, 16255},
	{"HQ12", 4, 16256},
	{"HQ13", 4, 16257},
	{"HQ14", 4, 16258},
	{"HQ15", 4, 16259},
	{"HQ16", 4, 16260},
	{"HQ17", 4, 16261},
	{"HQ18", 4, 16262},
	{"HQ19", 4, 16263},
	{"HQ20", 4, 16264},
	{"HQ21", 4, 16265},
	{"HQ22", 4, 16266},
	{"HQ23", 4, 16267},
	{"HQ24", 4, 16268},
	{"HQ25", 4, 16269},
	{"HQ26", 4, 16270},
	{"HQ27", 4, 16271},
	{"HQ28", 4, 16272},
	{"HQ29", 4, 16273},
	{"HQ30", 4, 16274},
	{"HQ31", 4, 16275},
	{"HQ32", 4, 16276},
	{"HQ33", 4, 16277},
	{"HQ34", 4, 16278},
	{"HQ35", 4, 16279},
	{"HQ36", 4, 16280},
	{"HQ37", 4, 16281},
	{"HQ38", 4, 16282},
	{"HQ39", 4, 16283},
	{"HQ40", 4, 16284},
	{"HQ41", 4, 16285},
	{"HQ42", 4, 16286},
	{"HQ43", 4, 16287},
	{"HQ44", 4, 16288},
	{"HQ45", 4, 16289},
	{"HQ46", 4, 16290},
	{"HQ47", 4, 16291},
	{"HQ48", 4, 16292},
	{"HQ49", 4, 16293},
	{"HQ50", 4, 16294},
	{"HQ51", 4, 16295},
	{"HQ52", 4, 16296},
	{"HQ53", 4, 16297},
	{"HQ54", 4, 16298},
	{"HQ55", 4, 16299},
	{"HQ56", 4, 16300},
	{"HQ57", 4, 16301},
	{"HQ58", 4, 16302},
	{"HQ59", 4, 16303},
	{"HQ60", 4, 16304},
	{"HQ61", 4, 16305},
	{"HQ62", 4, 16306},
	{"HQ63", 4, 16307},
	{"HQ64", 4, 16308},
	{"HQ65", 4, 16309},
	{"HQ66", 4, 16310},
	{"HQ67", 4, 16311},
	{"HQ68", 4, 16312},
	{"HQ69", 4, 16313},
	{"HQ70", 4, 16314},
	{"HQ71", 4, 16315},
	{"HQ72", 4, 16316},
	{"HQ73", 4, 16317},
	{"HQ74", 4, 16318},
	{"HQ75", 4, 16319},
	{"HQ76", 4, 16320},
	{"HQ77", 4, 16321},
	{"HQ78", 4, 16322},
	{"HQ79", 4, 16323},
	{"HQ80", 4, 16324},
	{"HQ81", 4, 16325},
	{"HQ82", 4, 16326},
	{"HQ83", 4, 16327},
	{"HQ84", 4, 16328},
	{"HQ85", 4, 16329},
	{"HQ86", 4, 16330},
	{"HQ87", 4, 16331},
	{"HQ88", 4, 16332},
	{"HQ89", 4, 16333},
	{"HQ90", 4, 16334},
	{"HQ91", 4, 16335},
	{"HQ92", 4, 16336},
	{"HQ93", 4, 16337},
	{"HQ94", 4, 16338},
	{"HQ95", 4, 16339},
	{"HQ96", 4, 16340},
	{"HQ97", 4, 16341},
	{"HQ98", 4, 16342},
	{"HQ99", 4, 16343},
	{"IB00", 4, 16344},
	{"IB01", 4, 16345},
	{"IB02", 4, 16346},
	{"IB03", 4, 16347},
	{"IB04", 4, 16348},
	{"IB05", 4, 16349},
	{"IB06", 4, 16350},
	{"IB07", 4, 16351},
	{"IB08", 4, 16352},
	{"IB09", 4, 16353},
	{"IB10", 4, 16354},
	{"IB11", 4, 16355},
	{"IB12", 4, 16356},
	{"IB13", 4, 16357},
	{"IB14", 4, 16358},
	{"IB15", 4, 16359},
	{"IB16", 4, 16360},
	{"IB17", 4, 16361},
	{"IB18", 4, 16362},
	{"IB19", 4, 16363},
	{"IB20", 4, 16364},
	{"IB21", 4, 16365},
	{"IB22", 4, 16366},
	{"IB23", 4, 16367},
	{"IB24", 4, 16368},
	{"IB25", 4, 16369},
	{"IB26", 4, 16370},
	{"IB27", 4, 16371},
	{"IB28", 4, 16372},
	{"IB29", 4, 16373},
	{"IB30", 4, 16374},
	{"IB31", 4, 16375},
	{"IB32", 4, 16376},
	{"IB33", 4, 16377},
	{"IB34", 4, 16378},
	{"IB35", 4, 16379},
	{"IB36", 4, 16380},
	{"IB37", 4, 16381},
	{"IB38", 4, 16382},
	{"IB39", 4, 16383},
	{"IB40", 4, 16384},
	{"IB41", 4, 16385},
	{"IB42", 4, 16386},
	{"IB43", 4, 16387},
	{"IB44", 4, 16388},
	{"IB45", 4, 16389},
	{"IB46", 4, 16390},
	{"IB47", 4, 16391},
	{"IB48", 4, 16392},
	{"IB49", 4, 16393},
	{"IB50", 4, 16394},
	{"IB51", 4, 16395},
	{"IB52", 4, 16396},
	{"IB53", 4, 16397},
	{"IB54", 4, 16398},
	{"IB55", 4, 16399},
	{"IB56", 4, 16400},
	{"IB57", 4, 16401},
	{"IB58", 4, 16402},
	{"IB59", 4, 16403},
	{"IB60", 4, 16404},
	{"IB61", 4, 16405},
	{"IB62", 4, 16406},
	{"IB63", 4, 16407},
	{"IB64", 4, 16408},
	{"IB65", 4, 16409},
	{"IB66", 4, 16410},
	{"IB67", 4, 16411},
	{"IB68", 4, 16412},
	{"IB69", 4, 16413},
	{"IB70", 4, 16414},
	{"IB71", 4, 16415},
	{"IB72", 4, 16416},
	{"IB73", 4, 16417},
	{"IB74", 4, 16418},
	{"IB75", 4, 16419},
	{"IB76", 4, 16420},
	{"IB77", 4, 16421},
	{"IB78", 4, 16422},
	{"IB79", 4, 16423},
	{"IB80", 4, 16424},
	{"IB81", 4, 16425},
	{"IB82", 4, 16426},
	{"IB83", 4, 16427},
	{"IB84", 4, 16428},
	{"IB85", 4, 16429},
	{"IB86", 4, 16430},
	{"IB87", 4, 16431},
	{"IB88", 4, 16432},
	{"IB89", 4, 16433},
	{"IB90", 4, 16434},
	{"IB91", 4, 16435},
	{"IB92", 4, 16436},
	{"IB93", 4, 16437},
	{"IB94", 4, 16438},
	{"IB95", 4, 16439},
	{"IB96", 4, 16440},
	{"IB97", 4, 16441},
	{"IB98", 4, 16442},
	{"IB99", 4, 16443},
	{"IJ00", 4, 16444},
	{"IJ01", 4, 16445},
	{"IJ02", 4, 16446},
	{"IJ03", 4, 16447},
	{"IJ04", 4, 16448},
	{"IJ05", 4, 16449},
	{"IJ06", 4, 16450},
	{"IJ07", 4, 16451},
	{"IJ08", 4, 16452},
	{"IJ09", 4, 16453},
	{"IJ10", 4, 16454},
	{"IJ11", 4, 16455},
	{"IJ12", 4, 16456},
	{"IJ13", 4, 16457},
	{"IJ14", 4, 16458},
	{"IJ15", 4, 16459},
	{"IJ16", 4, 16460},
	{"IJ17", 4, 16461},
	{"IJ18", 4, 16462},
	{"IJ19", 4, 16463},
	{"IJ20", 4, 16464},
	{"IJ21", 4, 16465},
	{"IJ22", 4, 16466},
	{"IJ23", 4, 16467},
	{"IJ24", 4, 16468},
	{"IJ25", 4, 16469},
	{"IJ26", 4, 16470},
	{"IJ27", 4, 16471},
	{"IJ28", 4, 16472},
	{"IJ29", 4, 16473},
	{"IJ30", 4, 16474},
	{"IJ31", 4, 16475},
	{"IJ32", 4, 16476},
	{"IJ33", 4, 16477},
	{"IJ34", 4, 16478},
	{"IJ35", 4, 16479},
	{"IJ36", 4, 16480},
	{"IJ37", 4, 16481},
	{"IJ38", 4, 16482},
	{"IJ39", 4, 16483},
	{"IJ40", 4, 16484},
	{"IJ41", 4, 16485},
	{"IJ42", 4, 16486},
	{"IJ43", 4, 16487},
	{"IJ44", 4, 16488},
	{"IJ45", 4, 16489},
	{"IJ46", 4, 16490},
	{"IJ47", 4, 16491},
	{"IJ48", 4, 16492},
	{"IJ49", 4, 16493},
	{"IJ50", 4, 16494},
	{"IJ51", 4, 16495},
	{"IJ52", 4, 16496},
	{"IJ53", 4, 16497},
	{"IJ54", 4, 16498},
	{"IJ55", 4, 16499},
	{"IJ56", 4, 16500},
	{"IJ57", 4, 16501},
	{"IJ58", 4, 16502},
	{"IJ59", 4, 16503},
	{"IJ60", 4, 16504},
	{"IJ61", 4, 16505},
	{"IJ62", 4, 16506},
	{"IJ63", 4, 16507},
	{"IJ64", 4, 16508},
	{"IJ65", 4, 16509},
	{"IJ66", 4, 16510},
	{"IJ67", 4, 16511},
	{"IJ68", 4, 16512},
	{"IJ69", 4, 16513},
	{"IJ70", 4, 16514},
	{"IJ71", 4, 16515},
	{"IJ72", 4, 16516},
	{"IJ73", 4, 16517},
	{"IJ74", 4, 16518},
	{"IJ75", 4, 16519},
	{"IJ76", 4, 16520},
	{"IJ77", 4, 16521},
	{"IJ78", 4, 16522},
	{"IJ79", 4, 16523},
	{"IJ80", 4, 16524},
	{"IJ81", 4, 16525},
	{"IJ82", 4, 16526},
	{"IJ83", 4, 16527},
	{"IJ84", 4, 16528},
	{"IJ85", 4, 16529},
	{"IJ86", 4, 16530},
	{"IJ87", 4, 16531},
	{"IJ88", 4, 16532},
	{"IJ89", 4, 16533},
	{"IJ90", 4, 16534},
	{"IJ91", 4, 16535},
	{"IJ92", 4, 16536},
	{"IJ93", 4, 16537},
	{"IJ94", 4, 16538},
	{"IJ95", 4, 16539},
	{"IJ96", 4, 16540},
	{"IJ97", 4, 16541},
	{"IJ98", 4, 16542},
	{"IJ99", 4, 16543},
	{"IK00", 4, 16544},
	{"IK01", 4, 16545},
	{"IK02", 4, 16546},
	{"IK03", 4, 16547},
	{"IK04", 4, 16548},
	{"IK05", 4, 16549},
	{"IK06", 4, 16550},
	{"IK07", 4, 16551},
	{"IK08", 4, 16552},
	{"IK09", 4, 16553},
	{"IK10", 4, 16554},
	{"IK11", 4, 16555},
	{"IK12", 4, 16556},
	{"IK13", 4, 16557},
	{"IK14", 4, 16558},
	{"IK15", 4, 16559},
	{"IK16", 4, 16560},
	{"IK17", 4, 16561},
	{"IK18", 4, 16562},
	{"IK19", 4, 16563},
	{"IK20", 4, 16564},
	{"IK21", 4, 16565},
	{"IK22", 4, 16566},
	{"IK23", 4, 16567},
	{"IK24", 4, 16568},
	{"IK25", 4, 16569},
	{"IK26", 4, 16570},
	{"IK27", 4, 16571},
	{"IK28", 4, 16572},
	{"IK29", 4, 16573},
	{"IK30", 4, 16574},
	{"IK31", 4, 16575},
	{"IK32", 4, 16576},
	{"IK33", 4, 16577},
	{"IK34", 4, 16578},
	{"IK35", 4, 16579},
	{"IK36", 4, 16580},
	{"IK37", 4, 16581},
	{"IK38", 4, 16582},
	{"IK39", 4, 16583},
	{"IK40", 4, 16584},
	{"IK41", 4, 16585},
	{"IK42", 4, 16586},
	{"IK43", 4, 16587},
	{"IK44", 4, 16588},
	{"IK45", 4, 16589},
	{"IK46", 4, 16590},
	{"IK47", 4, 16591},
	{"IK48", 4, 16592},
	{"IK49", 4, 16593},
	{"IK50", 4, 16594},
	{"IK51", 4, 16595},
	{"IK52", 4, 16596},
	{"IK53", 4, 16597},
	{"IK54", 4, 16598},
	{"IK55", 4, 16599},
	{"IK56", 4, 16600},
	{"IK57", 4, 16601},
	{"IK58", 4, 16602},
	{"IK59", 4, 16603},
	{"IK60", 4, 16604},
	{"IK61", 4, 16605},
	{"IK62", 4, 16606},
	{"IK63", 4, 16607},
	{"IK64", 4, 16608},
	{"IK65", 4, 16609},
	{"IK66", 4, 16610},
	{"IK67", 4, 16611},
	{"IK68", 4, 16612},
	{"IK69", 4, 16613},
	{"IK70", 4, 16614},
	{"IK71", 4, 16615},
	{"IK72", 4, 16616},
	{"IK73", 4, 16617},
	{"IK74", 4, 16618},
	{"IK75", 4, 16619},
	{"IK76", 4, 16620},
	{"IK77", 4, 16621},
	{"IK78", 4, 16622},
	{"IK79", 4, 16623},
	{"IK80", 4, 16624},
	{"IK81", 4, 16625},
	{"IK82", 4, 16626},
	{"IK83", 4, 16627},
	{"IK84", 4, 16628},
	{"IK85", 4, 16629},
	{"IK86", 4, 16630},
	{"IK87", 4, 16631},
	{"IK88", 4, 16632},
	{"IK89", 4, 16633},
	{"IK90", 4, 16634},
	{"IK91", 4, 16635},
	{"IK92", 4, 16636},
	{"IK93", 4, 16637},
	{"IK94", 4, 16638},
	{"IK95", 4, 16639},
	{"IK96", 4, 16640},
	{"IK97", 4, 16641},
	{"IK98", 4, 16642},
	{"IK99", 4, 16643},
	{"IL00", 4, 16644},
	{"IL01", 4, 16645},
	{"IL02", 4, 16646},
	{"IL03", 4, 16647},
	{"IL04", 4, 16648},
	{"IL05", 4, 16649},
	{"IL06", 4, 16650},
	{"IL07", 4, 16651},
	{"IL08", 4, 16652},
	{"IL09", 4, 16653},
	{"IL10", 4, 16654},
	{"IL11", 4, 16655},
	{"IL12", 4, 16656},
	{"IL13", 4, 16657},
	{"IL14", 4, 16658},
	{"IL15", 4, 16659},
	{"IL16", 4, 16660},
	{"IL17", 4, 16661},
	{"IL18", 4, 16662},
	{"IL19", 4, 16663},
	{"IL20", 4, 16664},
	{"IL21", 4, 16665},
	{"IL22", 4, 16666},
	{"IL23", 4, 16667},
	{"IL24", 4, 16668},
	{"IL25", 4, 16669},
	{"IL26", 4, 16670},
	{"IL27", 4, 16671},
	{"IL28", 4, 16672},
	{"IL29", 4, 16673},
	{"IL30", 4, 16674},
	{"IL31", 4, 16675},
	{"IL32", 4, 16676},
	{"IL33", 4, 16677},
	{"IL34", 4, 16678},
	{"IL35", 4, 16679},
	{"IL36", 4, 16680},
	{"IL37", 4, 16681},
	{"IL38", 4, 16682},
	{"IL39", 4, 16683},
	{"IL40", 4, 16684},
	{"IL41", 4, 16685},
	{"IL42", 4, 16686},
	{"IL43", 4, 16687},
	{"IL44", 4, 16688},
	{"IL45", 4, 16689},
	{"IL46", 4, 16690},
	{"IL47", 4, 16691},
	{"IL48", 4, 16692},
	{"IL49", 4, 16693},
	{"IL50", 4, 16694},
	{"IL51", 4, 16695},
	{"IL52", 4, 16696},
	{"IL53", 4, 16697},
	{"IL54", 4, 16698},
	{"IL55", 4, 16699},
	{"IL56", 4, 16700},
	{"IL57", 4, 16701},
	{"IL58", 4, 16702},
	{"IL59", 4, 16703},
	{"IL60", 4, 16704},
	{"IL61", 4, 16705},
	{"IL62", 4, 16706},
	{"IL63", 4, 16707},
	{"IL64", 4, 16708},
	{"IL65", 4, 16709},
	{"IL66", 4, 16710},
	{"IL67", 4, 16711},
	{"IL68", 4, 16712},
	{"IL69", 4, 16713},
	{"IL70", 4, 16714},
	{"IL71", 4, 16715},
	{"IL72", 4, 16716},
	{"IL73", 4, 16717},
	{"IL74", 4, 16718},
	{"IL75", 4, 16719},
	{"IL76", 4, 16720},
	{"IL77", 4, 16721},
	{"IL78", 4, 16722},
	{"IL79", 4, 16723},
	{"IL80", 4, 16724},
	{"IL81", 4, 16725},
	{"IL82", 4, 16726},
	{"IL83", 4, 16727},
	{"IL84", 4, 16728},
	{"IL85", 4, 16729},
	{"IL86", 4, 16730},
	{"IL87", 4, 16731},
	{"IL88", 4, 16732},
	{"IL89", 4, 16733},
	{"IL90", 4, 16734},
	{"IL91", 4, 16735},
	{"IL92", 4, 16736},
	{"IL93", 4, 16737},
	{"IL94", 4, 16738},
	{"IL95", 4, 16739},
	{"IL96", 4, 16740},
	{"IL97", 4, 16741},
	{"IL98", 4, 16742},
	{"IL99", 4, 16743},
	{"IM00", 4, 16744},
	{"IM01", 4, 16745},
	{"IM02", 4, 16746},
	{"IM03", 4, 16747},
	{"IM04", 4, 16748},
	{"IM05", 4, 16749},
	{"IM06", 4, 16750},
	{"IM07", 4, 16751},
	{"IM08", 4, 16752},
	{"IM09", 4, 16753},
	{"IM10", 4, 16754},
	{"IM11", 4, 16755},
	{"IM12", 4, 16756},
	{"IM13", 4, 16757},
	{"IM14", 4, 16758},
	{"IM15", 4, 16759},
	{"IM16", 4, 16760},
	{"IM17", 4, 16761},
	{"IM18", 4, 16762},
	{"IM19", 4, 16763},
	{"IM20", 4, 16764},
	{"IM21", 4, 16765},
	{"IM22", 4, 16766},
	{"IM23", 4, 16767},
	{"IM24", 4, 16768},
	{"IM25", 4, 16769},
	{"IM26", 4, 16770},
	{"IM27", 4, 16771},
	{"IM28", 4, 16772},
	{"IM29", 4, 16773},
	{"IM30", 4, 16774},
	{"IM31", 4, 16775},
	{"IM32", 4, 16776},
	{"IM33", 4, 16777},
	{"IM34", 4, 16778},
	{"IM35", 4, 16779},
	{"IM36", 4, 16780},
	{"IM37", 4, 16781},
	{"IM38", 4, 16782},
	{"IM39", 4, 16783},
	{"IM40", 4, 16784},
	{"IM41", 4, 16785},
	{"IM42", 4, 16786},
	{"IM43", 4, 16787},
	{"IM44", 4, 16788},
	{"IM45", 4, 16789},
	{"IM46", 4, 16790},
	{"IM47", 4, 16791},
	{"IM48", 4, 16792},
	{"IM49", 4, 16793},
	{"IM50", 4, 16794},
	{"IM51", 4, 16795},
	{"IM52", 4, 16796},
	{"IM53", 4, 16797},
	{"IM54", 4, 16798},
	{"IM55", 4, 16799},
	{"IM56", 4, 16800},
	{"IM57", 4, 16801},
	{"IM58", 4, 16802},
	{"IM59", 4, 16803},
	{"IM60", 4, 16804},
	{"IM61", 4, 16805},
	{"IM62", 4, 16806},
	{"IM63", 4, 16807},
	{"IM64", 4, 16808},
	{"IM65", 4, 16809},
	{"IM66", 4, 16810},
	{"IM67", 4, 16811},
	{"IM68", 4, 16812},
	{"IM69", 4, 16813},
	{"IM70", 4, 16814},
	{"IM71", 4, 16815},
	{"IM72", 4, 16816},
	{"IM73", 4, 16817},
	{"IM74", 4, 16818},
	{"IM75", 4, 16819},
	{"IM76", 4, 16820},
	{"IM77", 4, 16821},
	{"IM78", 4, 16822},
	{"IM79", 4, 16823},
	{"IM80", 4, 16824},
	{"IM81", 4, 16825},
	{"IM82", 4, 16826},
	{"IM83", 4, 16827},
	{"IM84", 4, 16828},
	{"IM85", 4, 16829},
	{"IM86", 4, 16830},
	{"IM87", 4, 16831},
	{"IM88", 4, 16832},
	{"IM89", 4, 16833},
	{"IM90", 4, 16834},
	{"IM91", 4, 16835},
	{"IM92", 4, 16836},
	{"IM93", 4, 16837},
	{"IM94", 4, 16838},
	{"IM95", 4, 16839},
	{"IM96", 4, 16840},
	{"IM97", 4, 16841},
	{"IM98", 4, 16842},
	{"IM99", 4, 16843},
	{"IN00", 4, 16844},
	{"IN01", 4, 16845},
	{"IN02", 4, 16846},
	{"IN03", 4, 16847},
	{"IN04", 4, 16848},
	{"IN05", 4, 16849},
	{"IN06", 4, 16850},
	{"IN07", 4, 16851},
	{"IN08", 4, 16852},
	{"IN09", 4, 16853},
	{"IN10", 4, 16854},
	{"IN11", 4, 16855},
	{"IN12", 4, 16856},
	{"IN13", 4, 16857},
	{"IN14", 4, 16858},
	{"IN15", 4, 16859},
	{"IN16", 4, 16860},
	{"IN17", 4, 16861},
	{"IN18", 4, 16862},
	{"IN19", 4, 16863},
	{"IN20", 4, 16864},
	{"IN21", 4, 16865},
	{"IN22", 4, 16866},
	{"IN23", 4, 16867},
	{"IN24", 4, 16868},
	{"IN25", 4, 16869},
	{"IN26", 4, 16870},
	{"IN27", 4, 16871},
	{"IN28", 4, 16872},
	{"IN29", 4, 16873},
	{"IN30", 4, 16874},
	{"IN31", 4, 16875},
	{"IN32", 4, 16876},
	{"IN33", 4, 16877},
	{"IN34", 4, 16878},
	{"IN35", 4, 16879},
	{"IN36", 4, 16880},
	{"IN37", 4, 16881},
	{"IN38", 4, 16882},
	{"IN39", 4, 16883},
	{"IN40", 4, 16884},
	{"IN41", 4, 16885},
	{"IN42", 4, 16886},
	{"IN43", 4, 16887},
	{"IN44", 4, 16888},
	{"IN45", 4, 16889},
	{"IN46", 4, 16890},
	{"IN47", 4, 16891},
	{"IN48", 4, 16892},
	{"IN49", 4, 16893},
	{"IN50", 4, 16894},
	{"IN51", 4, 16895},
	{"IN52", 4, 16896},
	{"IN53", 4, 16897},
	{"IN54", 4, 16898},
	{"IN55", 4, 16899},
	{"IN56", 4, 16900},
	{"IN57", 4, 16901},
	{"IN58", 4, 16902},
	{"IN59", 4, 16903},
	{"IN60", 4, 16904},
	{"IN61", 4, 16905},
	{"IN62", 4, 16906},
	{"IN63", 4, 16907},
	{"IN64", 4, 16908},
	{"IN65", 4, 16909},
	{"IN66", 4, 16910},
	{"IN67", 4, 16911},
	{"IN68", 4, 16912},
	{"IN69", 4, 16913},
	{"IN70", 4, 16914},
	{"IN71", 4, 16915},
	{"IN72", 4, 16916},
	{"IN73", 4, 16917},
	{"IN74", 4, 16918},
	{"IN75", 4, 16919},
	{"IN76", 4, 16920},
	{"IN77", 4, 16921},
	{"IN78", 4, 16922},
	{"IN79", 4, 16923},
	{"IN80", 4, 16924},
	{"IN81", 4, 16925},
	{"IN82", 4, 16926},
	{"IN83", 4, 16927},
	{"IN84", 4, 16928},
	{"IN85", 4, 16929},
	{"IN86", 4, 16930},
	{"IN87", 4, 16931},
	{"IN88", 4, 16932},
	{"IN89", 4, 16933},
	{"IN90", 4, 16934},
	{"IN91", 4, 16935},
	{"IN92", 4, 16936},
	{"IN93", 4, 16937},
	{"IN94", 4, 16938},
	{"IN95", 4, 16939},
	{"IN96", 4, 16940},
	{"IN97", 4, 16941},
	{"IN98", 4, 16942},
	{"IN99", 4, 16943},
	{"IO00", 4, 16944},
	{"IO01", 4, 16945},
	{"IO02", 4, 16946},
	{"IO03", 4, 16947},
	{"IO04", 4, 16948},
	{"IO05", 4, 16949},
	{"IO06", 4, 16950},
	{"IO07", 4, 16951},
	{"IO08", 4, 16952},
	{"IO09", 4, 16953},
	{"IO10", 4, 16954},
	{"IO11", 4, 16955},
	{"IO12", 4, 16956},
	{"IO13", 4, 16957},
	{"IO14", 4, 16958},
	{"IO15", 4, 16959},
	{"IO16", 4, 16960},
	{"IO17", 4, 16961},
	{"IO18", 4, 16962},
	{"IO19", 4, 16963},
	{"IO20", 4, 16964},
	{"IO21", 4, 16965},
	{"IO22", 4, 16966},
	{"IO23", 4, 16967},
	{"IO24", 4, 16968},
	{"IO25", 4, 16969},
	{"IO26", 4, 16970},
	{"IO27", 4, 16971},
	{"IO28", 4, 16972},
	{"IO29", 4, 16973},
	{"IO30", 4, 16974},
	{"IO31", 4, 16975},
	{"IO32", 4, 16976},
	{"IO33", 4, 16977},
	{"IO34", 4, 16978},
	{"IO35", 4, 16979},
	{"IO36", 4, 16980},
	{"IO37", 4, 16981},
	{"IO38", 4, 16982},
	{"IO39", 4, 16983},
	{"IO40", 4, 16984},
	{"IO41", 4, 16985},
	{"IO42", 4, 16986},
	{"IO43", 4, 16987},
	{"IO44", 4, 16988},
	{"IO45", 4, 16989},
	{"IO46", 4, 16990},
	{"IO47", 4, 16991},
	{"IO48", 4, 16992},
	{"IO49", 4, 16993},
	{"IO50", 4, 16994},
	{"IO51", 4, 16995},
	{"IO52", 4, 16996},
	{"IO53", 4, 16997},
	{"IO54", 4, 16998},
	{"IO55", 4, 16999},
	{"IO56", 4, 17000},
	{"IO57", 4, 17001},
	{"IO58", 4, 17002},
	{"IO59", 4, 17003},
	{"IO60", 4, 17004},
	{"IO61", 4, 17005},
	{"IO62", 4, 17006},
	{"IO63", 4, 17007},
	{"IO64", 4, 17008},
	{"IO65", 4, 17009},
	{"IO66", 4, 17010},
	{"IO67", 4, 17011},
	{"IO68", 4, 17012},
	{"IO69", 4, 17013},
	{"IO70", 4, 17014},
	{"IO71", 4, 17015},
	{"IO72", 4, 17016},
	{"IO73", 4, 17017},
	{"IO74", 4, 17018},
	{"IO75", 4, 17019},
	{"IO76", 4, 17020},
	{"IO77", 4, 17021},
	{"IO78", 4, 17022},
	{"IO79", 4, 17023},
	{"IO80", 4, 17024},
	{"IO81", 4, 17025},
	{"IO82", 4, 17026},
	{"IO83", 4, 17027},
	{"IO84", 4, 17028},
	{"IO85", 4, 17029},
	{"IO86", 4, 17030},
	{"IO87", 4, 17031},
	{"IO88", 4, 17032},
	{"IO89", 4, 17033},
	{"IO90", 4, 17034},
	{"IO91", 4, 17035},
	{"IO92", 4, 17036},
	{"IO93", 4, 17037},
	{"IO94", 4, 17038},
	{"IO95", 4, 17039},
	{"IO96", 4, 17040},
	{"IO97", 4, 17041},
	{"IO98", 4, 17042},
	{"IO99", 4, 17043},
	{"IP00", 4, 17044},
	{"IP01", 4, 17045},
	{"IP02", 4, 17046},
	{"IP03", 4, 17047},
	{"IP04", 4, 17048},
	{"IP05", 4, 17049},
	{"IP06", 4, 17050},
	{"IP07", 4, 17051},
	{"IP08", 4, 17052},
	{"IP09", 4, 17053},
	{"IP10", 4, 17054},
	{"IP11", 4, 17055},
	{"IP12", 4, 17056},
	{"IP13", 4, 17057},
	{"IP14", 4, 17058},
	{"IP15", 4, 17059},
	{"IP16", 4, 17060},
	{"IP17", 4, 17061},
	{"IP18", 4, 17062},
	{"IP19", 4, 17063},
	{"IP20", 4, 17064},
	{"IP21", 4, 17065},
	{"IP22", 4, 17066},
	{"IP23", 4, 17067},
	{"IP24", 4, 17068},
	{"IP25", 4, 17069},
	{"IP26", 4, 17070},
	{"IP27", 4, 17071},
	{"IP28", 4, 17072},
	{"IP29", 4, 17073},
	{"IP30", 4, 17074},
	{"IP31", 4, 17075},
	{"IP32", 4, 17076},
	{"IP33", 4, 17077},
	{"IP34", 4, 17078},
	{"IP35", 4, 17079},
	{"IP36", 4, 17080},
	{"IP37", 4, 17081},
	{"IP38", 4, 17082},
	{"IP39", 4, 17083},
	{"IP40", 4, 17084},
	{"IP41", 4, 17085},
	{"IP42", 4, 17086},
	{"IP43", 4, 17087},
	{"IP44", 4, 17088},
	{"IP45", 4, 17089},
	{"IP46", 4, 17090},
	{"IP47", 4, 17091},
	{"IP48", 4, 17092},
	{"IP49", 4, 17093},
	{"IP50", 4, 17094},
	{"IP51", 4, 17095},
	{"IP52", 4, 17096},
	{"IP53", 4, 17097},
	{"IP54", 4, 17098},
	{"IP55", 4, 17099},
	{"IP56", 4, 17100},
	{"IP57", 4, 17101},
	{"IP58", 4, 17102},
	{"IP59", 4, 17103},
	{"IP60", 4, 17104},
	{"IP61", 4, 17105},
	{"IP62", 4, 17106},
	{"IP63", 4, 17107},
	{"IP64", 4, 17108},
	{"IP65", 4, 17109},
	{"IP66", 4, 17110},
	{"IP67", 4, 17111},
	{"IP68", 4, 17112},
	{"IP69", 4, 17113},
	{"IP70", 4, 17114},
	{"IP71", 4, 17115},
	{"IP72", 4, 17116},
	{"IP73", 4, 17117},
	{"IP74", 4, 17118},
	{"IP75", 4, 17119},
	{"IP76", 4, 17120},
	{"IP77", 4, 17121},
	{"IP78", 4, 17122},
	{"IP79", 4, 17123},
	{"IP80", 4, 17124},
	{"IP81", 4, 17125},
	{"IP82", 4, 17126},
	{"IP83", 4, 17127},
	{"IP84", 4, 17128},
	{"IP85", 4, 17129},
	{"IP86", 4, 17130},
	{"IP87", 4, 17131},
	{"IP88", 4, 17132},
	{"IP89", 4, 17133},
	{"IP90", 4, 17134},
	{"IP91", 4, 17135},
	{"IP92", 4, 17136},
	{"IP93", 4, 17137},
	{"IP94", 4, 17138},
	{"IP95", 4, 17139},
	{"IP96", 4, 17140},
	{"IP97", 4, 17141},
	{"IP98", 4, 17142},
	{"IP99", 4, 17143},
	{"JB00", 4, 17144},
	{"JB01", 4, 17145},
	{"JB02", 4, 17146},
	{"JB03", 4, 17147},
	{"JB04", 4, 17148},
	{"JB05", 4, 17149},
	{"JB06", 4, 17150},
	{"JB07", 4, 17151},
	{"JB08", 4, 17152},
	{"JB09", 4, 17153},
	{"JB10", 4, 17154},
	{"JB11", 4, 17155},
	{"JB12", 4, 17156},
	{"JB13", 4, 17157},
	{"JB14", 4, 17158},
	{"JB15", 4, 17159},
	{"JB16", 4, 17160},
	{"JB17", 4, 17161},
	{"JB18", 4, 17162},
	{"JB19", 4, 17163},
	{"JB20", 4, 17164},
	{"JB21", 4, 17165},
	{"JB22", 4, 17166},
	{"JB23", 4, 17167},
	{"JB24", 4, 17168},
	{"JB25", 4, 17169},
	{"JB26", 4, 17170},
	{"JB27", 4, 17171},
	{"JB28", 4, 17172},
	{"JB29", 4, 17173},
	{"JB30", 4, 17174},
	{"JB31", 4, 17175},
	{"JB32", 4, 17176},
	{"JB33", 4, 17177},
	{"JB34", 4, 17178},
	{"JB35", 4, 17179},
	{"JB36", 4, 17180},
	{"JB37", 4, 17181},
	{"JB38", 4, 17182},
	{"JB39", 4, 17183},
	{"JB40", 4, 17184},
	{"JB41", 4, 17185},
	{"JB42", 4, 17186},
	{"JB43", 4, 17187},
	{"JB44", 4, 17188},
	{"JB45", 4, 17189},
	{"JB46", 4, 17190},
	{"JB47", 4, 17191},
	{"JB48", 4, 17192},
	{"JB49", 4, 17193},
	{"JB50", 4, 17194},
	{"JB51", 4, 17195},
	{"JB52", 4, 17196},
	{"JB53", 4, 17197},
	{"JB54", 4, 17198},
	{"JB55", 4, 17199},
	{"JB56", 4, 17200},
	{"JB57", 4, 17201},
	{"JB58", 4, 17202},
	{"JB59", 4, 17203},
	{"JB60", 4, 17204},
	{"JB61", 4, 17205},
	{"JB62", 4, 17206},
	{"JB63", 4, 17207},
	{"JB64", 4, 17208},
	{"JB65", 4, 17209},
	{"JB66", 4, 17210},
	{"JB67", 4, 17211},
	{"JB68", 4, 17212},
	{"JB69", 4, 17213},
	{"JB70", 4, 17214},
	{"JB71", 4, 17215},
	{"JB72", 4, 17216},
	{"JB73", 4, 17217},
	{"JB74", 4, 17218},
	{"JB75", 4, 17219},
	{"JB76", 4, 17220},
	{"JB77", 4, 17221},
	{"JB78", 4, 17222},
	{"JB79", 4, 17223},
	{"JB80", 4, 17224},
	{"JB81", 4, 17225},
	{"JB82", 4, 17226},
	{"JB83", 4, 17227},
	{"JB84", 4, 17228},
	{"JB85", 4, 17229},
	{"JB86", 4, 17230},
	{"JB87", 4, 17231},
	{"JB88", 4, 17232},
	{"JB89", 4, 17233},
	{"JB90", 4, 17234},
	{"JB91", 4, 17235},
	{"JB92", 4, 17236},
	{"JB93", 4, 17237},
	{"JB94", 4, 17238},
	{"JB95", 4, 17239},
	{"JB96", 4, 17240},
	{"JB97", 4, 17241},
	{"JB98", 4, 17242},
	{"JB99", 4, 17243},
	{"JF00", 4, 17244},
	{"JF01", 4, 17245},
	{"JF02", 4, 17246},
	{"JF03", 4, 17247},
	{"JF04", 4, 17248},
	{"JF05", 4, 17249},
	{"JF06", 4, 17250},
	{"JF07", 4, 17251},
	{"JF08", 4, 17252},
	{"JF09", 4, 17253},
	{"JF10", 4, 17254},
	{"JF11", 4, 17255},
	{"JF12", 4, 17256},
	{"JF13", 4, 17257},
	{"JF14", 4, 17258},
	{"JF15", 4, 17259},
	{"JF16", 4, 17260},
	{"JF17", 4, 17261},
	{"JF18", 4, 17262},
	{"JF19", 4, 17263},
	{"JF20", 4, 17264},
	{"JF21", 4, 17265},
	{"JF22", 4, 17266},
	{"JF23", 4, 17267},
	{"JF24", 4, 17268},
	{"JF25", 4, 17269},
	{"JF26", 4, 17270},
	{"JF27", 4, 17271},
	{"JF28", 4, 17272},
	{"JF29", 4, 17273},
	{"JF30", 4, 17274},
	{"JF31", 4, 17275},
	{"JF32", 4, 17276},
	{"JF33", 4, 17277},
	{"JF34", 4, 17278},
	{"JF35", 4, 17279},
	{"JF36", 4, 17280},
	{"JF37", 4, 17281},
	{"JF38", 4, 17282},
	{"JF39", 4, 17283},
	{"JF40", 4, 17284},
	{"JF41", 4, 17285},
	{"JF42", 4, 17286},
	{"JF43", 4, 17287},
	{"JF44", 4, 17288},
	{"JF45", 4, 17289},
	{"JF46", 4, 17290},
	{"JF47", 4, 17291},
	{"JF48", 4, 17292},
	{"JF49", 4, 17293},
	{"JF50", 4, 17294},
	{"JF51", 4, 17295},
	{"JF52", 4, 17296},
	{"JF53", 4, 17297},
	{"JF54", 4, 17298},
	{"JF55", 4, 17299},
	{"JF56", 4, 17300},
	{"JF57", 4, 17301},
	{"JF58", 4, 17302},
	{"JF59", 4, 17303},
	{"JF60", 4, 17304},
	{"JF61", 4, 17305},
	{"JF62", 4, 17306},
	{"JF63", 4, 17307},
	{"JF64", 4, 17308},
	{"JF65", 4, 17309},
	{"JF66", 4, 17310},
	{"JF67", 4, 17311},
	{"JF68", 4, 17312},
	{"JF69", 4, 17313},
	{"JF70", 4, 17314},
	{"JF71", 4, 17315},
	{"JF72", 4, 17316},
	{"JF73", 4, 17317},
	{"JF74", 4, 17318},
	{"JF75", 4, 17319},
	{"JF76", 4, 17320},
	{"JF77", 4, 17321},
	{"JF78", 4, 17322},
	{"JF79", 4, 17323},
	{"JF80", 4, 17324},
	{"JF81", 4, 17325},
	{"JF82", 4, 17326},
	{"JF83", 4, 17327},
	{"JF84", 4, 17328},
	{"JF85", 4, 17329},
	{"JF86", 4, 17330},
	{"JF87", 4, 17331},
	{"JF88", 4, 17332},
	{"JF89", 4, 17333},
	{"JF90", 4, 17334},
	{"JF91", 4, 17335},
	{"JF92", 4, 17336},
	{"JF93", 4, 17337},
	{"JF94", 4, 17338},
	{"JF95", 4, 17339},
	{"JF96", 4, 17340},
	{"JF97", 4, 17341},
	{"JF98", 4, 17342},
	{"JF99", 4, 17343},
	{"JG00", 4, 17344},
	{"JG01", 4, 17345},
	{"JG02", 4, 17346},
	{"JG03", 4, 17347},
	{"JG04", 4, 17348},
	{"JG05", 4, 17349},
	{"JG06", 4, 17350},
	{"JG07", 4, 17351},
	{"JG08", 4, 17352},
	{"JG09", 4, 17353},
	{"JG10", 4, 17354},
	{"JG11", 4, 17355},
	{"JG12", 4, 17356},
	{"JG13", 4, 17357},
	{"JG14", 4, 17358},
	{"JG15", 4, 17359},
	{"JG16", 4, 17360},
	{"JG17", 4, 17361},
	{"JG18", 4, 17362},
	{"JG19", 4, 17363},
	{"JG20", 4, 17364},
	{"JG21", 4, 17365},
	{"JG22", 4, 17366},
	{"JG23", 4, 17367},
	{"JG24", 4, 17368},
	{"JG25", 4, 17369},
	{"JG26", 4, 17370},
	{"JG27", 4, 17371},
	{"JG28", 4, 17372},
	{"JG29", 4, 17373},
	{"JG30", 4, 17374},
	{"JG31", 4, 17375},
	{"JG32", 4, 17376},
	{"JG33", 4, 17377},
	{"JG34", 4, 17378},
	{"JG35", 4, 17379},
	{"JG36", 4, 17380},
	{"JG37", 4, 17381},
	{"JG38", 4, 17382},
	{"JG39", 4, 17383},
	{"JG40", 4, 17384},
	{"JG41", 4, 17385},
	{"JG42", 4, 17386},
	{"JG43", 4, 17387},
	{"JG44", 4, 17388},
	{"JG45", 4, 17389},
	{"JG46", 4, 17390},
	{"JG47", 4, 17391},
	{"JG48", 4, 17392},
	{"JG49", 4, 17393},
	{"JG50", 4, 17394},
	{"JG51", 4, 17395},
	{"JG52", 4, 17396},
	{"JG53", 4, 17397},
	{"JG54", 4, 17398},
	{"JG55", 4, 17399},
	{"JG56", 4, 17400},
	{"JG57", 4, 17401},
	{"JG58", 4, 17402},
	{"JG59", 4, 17403},
	{"JG60", 4, 17404},
	{"JG61", 4, 17405},
	{"JG62", 4, 17406},
	{"JG63", 4, 17407},
	{"JG64", 4, 17408},
	{"JG65", 4, 17409},
	{"JG66", 4, 17410},
	{"JG67", 4, 17411},
	{"JG68", 4, 17412},
	{"JG69", 4, 17413},
	{"JG70", 4, 17414},
	{"JG71", 4, 17415},
	{"JG72", 4, 17416},
	{"JG73", 4, 17417},
	{"JG74", 4, 17418},
	{"JG75", 4, 17419},
	{"JG76", 4, 17420},
	{"JG77", 4, 17421},
	{"JG78", 4, 17422},
	{"JG79", 4, 17423},
	{"JG80", 4, 17424},
	{"JG81", 4, 17425},
	{"JG82", 4, 17426},
	{"JG83", 4, 17427},
	{"JG84", 4, 17428},
	{"JG85", 4, 17429},
	{"JG86", 4, 17430},
	{"JG87", 4, 17431},
	{"JG88", 4, 17432},
	{"JG89", 4, 17433},
	{"JG90", 4, 17434},
	{"JG91", 4, 17435},
	{"JG92", 4, 17436},
	{"JG93", 4, 17437},
	{"JG94", 4, 17438},
	{"JG95", 4, 17439},
	{"JG96", 4, 17440},
	{"JG97", 4, 17441},
	{"JG98", 4, 17442},
	{"JG99", 4, 17443},
	{"JH00", 4, 17444},
	{"JH01", 4, 17445},
	{"JH02", 4, 17446},
	{"JH03", 4, 17447},
	{"JH04", 4, 17448},
	{"JH05", 4, 17449},
	{"JH06", 4, 17450},
	{"JH07", 4, 17451},
	{"JH08", 4, 17452},
	{"JH09", 4, 17453},
	{"JH10", 4, 17454},
	{"JH11", 4, 17455},
	{"JH12", 4, 17456},
	{"JH13", 4, 17457},
	{"JH14", 4, 17458},
	{"JH15", 4, 17459},
	{"JH16", 4, 17460},
	{"JH17", 4, 17461},
	{"JH18", 4, 17462},
	{"JH19", 4, 17463},
	{"JH20", 4, 17464},
	{"JH21", 4, 17465},
	{"JH22", 4, 17466},
	{"JH23", 4, 17467},
	{"JH24", 4, 17468},
	{"JH25", 4, 17469},
	{"JH26", 4, 17470},
	{"JH27", 4, 17471},
	{"JH28", 4, 17472},
	{"JH29", 4, 17473},
	{"JH30", 4, 17474},
	{"JH31", 4, 17475},
	{"JH32", 4, 17476},
	{"JH33", 4, 17477},
	{"JH34", 4, 17478},
	{"JH35", 4, 17479},
	{"JH36", 4, 17480},
	{"JH37", 4, 17481},
	{"JH38", 4, 17482},
	{"JH39", 4, 17483},
	{"JH40", 4, 17484},
	{"JH41", 4, 17485},
	{"JH42", 4, 17486},
	{"JH43", 4, 17487},
	{"JH44", 4, 17488},
	{"JH45", 4, 17489},
	{"JH46", 4, 17490},
	{"JH47", 4, 17491},
	{"JH48", 4, 17492},
	{"JH49", 4, 17493},
	{"JH50", 4, 17494},
	{"JH51", 4, 17495},
	{"JH52", 4, 17496},
	{"JH53", 4, 17497},
	{"JH54", 4, 17498},
	{"JH55", 4, 17499},
	{"JH56", 4, 17500},
	{"JH57", 4, 17501},
	{"JH58", 4, 17502},
	{"JH59", 4, 17503},
	{"JH60", 4, 17504},
	{"JH61", 4, 17505},
	{"JH62", 4, 17506},
	{"JH63", 4, 17507},
	{"JH64", 4, 17508},
	{"JH65", 4, 17509},
	{"JH66", 4, 17510},
	{"JH67", 4, 17511},
	{"JH68", 4, 17512},
	{"JH69", 4, 17513},
	{"JH70", 4, 17514},
	{"JH71", 4, 17515},
	{"JH72", 4, 17516},
	{"JH73", 4, 17517},
	{"JH74", 4, 17518},
	{"JH75", 4, 17519},
	{"JH76", 4, 17520},
	{"JH77", 4, 17521},
	{"JH78", 4, 17522},
	{"JH79", 4, 17523},
	{"JH80", 4, 17524},
	{"JH81", 4, 17525},
	{"JH82", 4, 17526},
	{"JH83", 4, 17527},
	{"JH84", 4, 17528},
	{"JH85", 4, 17529},
	{"JH86", 4, 17530},
	{"JH87", 4, 17531},
	{"JH88", 4, 17532},
	{"JH89", 4, 17533},
	{"JH90", 4, 17534},
	{"JH91", 4, 17535},
	{"JH92", 4, 17536},
	{"JH93", 4, 17537},
	{"JH94", 4, 17538},
	{"JH95", 4, 17539},
	{"JH96", 4, 17540},
	{"JH97", 4, 17541},
	{"JH98", 4, 17542},
	{"JH99", 4, 17543},
	{"JI00", 4, 17544},
	{"JI01", 4, 17545},
	{"JI02", 4, 17546},
	{"JI03", 4, 17547},
	{"JI04", 4, 17548},
	{"JI05", 4, 17549},
	{"JI06", 4, 17550},
	{"JI07", 4, 17551},
	{"JI08", 4, 17552},
	{"JI09", 4, 17553},
	{"JI10", 4, 17554},
	{"JI11", 4, 17555},
	{"JI12", 4, 17556},
	{"JI13", 4, 17557},
	{"JI14", 4, 17558},
	{"JI15", 4, 17559},
	{"JI16", 4, 17560},
	{"JI17", 4, 17561},
	{"JI18", 4, 17562},
	{"JI19", 4, 17563},
	{"JI20", 4, 17564},
	{"JI21", 4, 17565},
	{"JI22", 4, 17566},
	{"JI23", 4, 17567},
	{"JI24", 4, 17568},
	{"JI25", 4, 17569},
	{"JI26", 4, 17570},
	{"JI27", 4, 17571},
	{"JI28", 4, 17572},
	{"JI29", 4, 17573},
	{"JI30", 4, 17574},
	{"JI31", 4, 17575},
	{"JI32", 4, 17576},
	{"JI33", 4, 17577},
	{"JI34", 4, 17578},
	{"JI35", 4, 17579},
	{"JI36", 4, 17580},
	{"JI37", 4, 17581},
	{"JI38", 4, 17582},
	{"JI39", 4, 17583},
	{"JI40", 4, 17584},
	{"JI41", 4, 17585},
	{"JI42", 4, 17586},
	{"JI43", 4, 17587},
	{"JI44", 4, 17588},
	{"JI45", 4, 17589},
	{"JI46", 4, 17590},
	{"JI47", 4, 17591},
	{"JI48", 4, 17592},
	{"JI49", 4, 17593},
	{"JI50", 4, 17594},
	{"JI51", 4, 17595},
	{"JI52", 4, 17596},
	{"JI53", 4, 17597},
	{"JI54", 4, 17598},
	{"JI55", 4, 17599},
	{"JI56", 4, 17600},
	{"JI57", 4, 17601},
	{"JI58", 4, 17602},
	{"JI59", 4, 17603},
	{"JI60", 4, 17604},
	{"JI61", 4, 17605},
	{"JI62", 4, 17606},
	{"JI63", 4, 17607},
	{"JI64", 4, 17608},
	{"JI65", 4, 17609},
	{"JI66", 4, 17610},
	{"JI67", 4, 17611},
	{"JI68", 4, 17612},
	{"JI69", 4, 17613},
	{"JI70", 4, 17614},
	{"JI71", 4, 17615},
	{"JI72", 4, 17616},
	{"JI73", 4, 17617},
	{"JI74", 4, 17618},
	{"JI75", 4, 17619},
	{"JI76", 4, 17620},
	{"JI77", 4, 17621},
	{"JI78", 4, 17622},
	{"JI79", 4, 17623},
	{"JI80", 4, 17624},
	{"JI81", 4, 17625},
	{"JI82", 4, 17626},
	{"JI83", 4, 17627},
	{"JI84", 4, 17628},
	{"JI85", 4, 17629},
	{"JI86", 4, 17630},
	{"JI87", 4, 17631},
	{"JI88", 4, 17632},
	{"JI89", 4, 17633},
	{"JI90", 4, 17634},
	{"JI91", 4, 17635},
	{"JI92", 4, 17636},
	{"JI93", 4, 17637},
	{"JI94", 4, 17638},
	{"JI95", 4, 17639},
	{"JI96", 4, 17640},
	{"JI97", 4, 17641},
	{"JI98", 4, 17642},
	{"JI99", 4, 17643},
	{"JJ00", 4, 17644},
	{"JJ01", 4, 17645},
	{"JJ02", 4, 17646},
	{"JJ03", 4, 17647},
	{"JJ04", 4, 17648},
	{"JJ05", 4, 17649},
	{"JJ06", 4, 17650},
	{"JJ07", 4, 17651},
	{"JJ08", 4, 17652},
	{"JJ09", 4, 17653},
	{"JJ10", 4, 17654},
	{"JJ11", 4, 17655},
	{"JJ12", 4, 17656},
	{"JJ13", 4, 17657},
	{"JJ14", 4, 17658},
	{"JJ15", 4, 17659},
	{"JJ16", 4, 17660},
	{"JJ17", 4, 17661},
	{"JJ18", 4, 17662},
	{"JJ19", 4, 17663},
	{"JJ20", 4, 17664},
	{"JJ21", 4, 17665},
	{"JJ22", 4, 17666},
	{"JJ23", 4, 17667},
	{"JJ24", 4, 17668},
	{"JJ25", 4, 17669},
	{"JJ26", 4, 17670},
	{"JJ27", 4, 17671},
	{"JJ28", 4, 17672},
	{"JJ29", 4, 17673},
	{"JJ30", 4, 17674},
	{"JJ31", 4, 17675},
	{"JJ32", 4, 17676},
	{"JJ33", 4, 17677},
	{"JJ34", 4, 17678},
	{"JJ35", 4, 17679},
	{"JJ36", 4, 17680},
	{"JJ37", 4, 17681},
	{"JJ38", 4, 17682},
	{"JJ39", 4, 17683},
	{"JJ40", 4, 17684},
	{"JJ41", 4, 17685},
	{"JJ42", 4, 17686},
	{"JJ43", 4, 17687},
	{"JJ44", 4, 17688},
	{"JJ45", 4, 17689},
	{"JJ46", 4, 17690},
	{"JJ47", 4, 17691},
	{"JJ48", 4, 17692},
	{"JJ49", 4, 17693},
	{"JJ50", 4, 17694},
	{"JJ51", 4, 17695},
	{"JJ52", 4, 17696},
	{"JJ53", 4, 17697},
	{"JJ54", 4, 17698},
	{"JJ55", 4, 17699},
	{"JJ56", 4, 17700},
	{"JJ57", 4, 17701},
	{"JJ58", 4, 17702},
	{"JJ59", 4, 17703},
	{"JJ60", 4, 17704},
	{"JJ61", 4, 17705},
	{"JJ62", 4, 17706},
	{"JJ63", 4, 17707},
	{"JJ64", 4, 17708},
	{"JJ65", 4, 17709},
	{"JJ66", 4, 17710},
	{"JJ67", 4, 17711},
	{"JJ68", 4, 17712},
	{"JJ69", 4, 17713},
	{"JJ70", 4, 17714},
	{"JJ71", 4, 17715},
	{"JJ72", 4, 17716},
	{"JJ73", 4, 17717},
	{"JJ74", 4, 17718},
	{"JJ75", 4, 17719},
	{"JJ76", 4, 17720},
	{"JJ77", 4, 17721},
	{"JJ78", 4, 17722},
	{"JJ79", 4, 17723},
	{"JJ80", 4, 17724},
	{"JJ81", 4, 17725},
	{"JJ82", 4, 17726},
	{"JJ83", 4, 17727},
	{"JJ84", 4, 17728},
	{"JJ85", 4, 17729},
	{"JJ86", 4, 17730},
	{"JJ87", 4, 17731},
	{"JJ88", 4, 17732},
	{"JJ89", 4, 17733},
	{"JJ90", 4, 17734},
	{"JJ91", 4, 17735},
	{"JJ92", 4, 17736},
	{"JJ93", 4, 17737},
	{"JJ94", 4, 17738},
	{"JJ95", 4, 17739},
	{"JJ96", 4, 17740},
	{"JJ97", 4, 17741},
	{"JJ98", 4, 17742},
	{"JJ99", 4, 17743},
	{"JK00", 4, 17744},
	{"JK01", 4, 17745},
	{"JK02", 4, 17746},
	{"JK03", 4, 17747},
	{"JK04", 4, 17748},
	{"JK05", 4, 17749},
	{"JK06", 4, 17750},
	{"JK07", 4, 17751},
	{"JK08", 4, 17752},
	{"JK09", 4, 17753},
	{"JK10", 4, 17754},
	{"JK11", 4, 17755},
	{"JK12", 4, 17756},
	{"JK13", 4, 17757},
	{"JK14", 4, 17758},
	{"JK15", 4, 17759},
	{"JK16", 4, 17760},
	{"JK17", 4, 17761},
	{"JK18", 4, 17762},
	{"JK19", 4, 17763},
	{"JK20", 4, 17764},
	{"JK21", 4, 17765},
	{"JK22", 4, 17766},
	{"JK23", 4, 17767},
	{"JK24", 4, 17768},
	{"JK25", 4, 17769},
	{"JK26", 4, 17770},
	{"JK27", 4, 17771},
	{"JK28", 4, 17772},
	{"JK29", 4, 17773},
	{"JK30", 4, 17774},
	{"JK31", 4, 17775},
	{"JK32", 4, 17776},
	{"JK33", 4, 17777},
	{"JK34", 4, 17778},
	{"JK35", 4, 17779},
	{"JK36", 4, 17780},
	{"JK37", 4, 17781},
	{"JK38", 4, 17782},
	{"JK39", 4, 17783},
	{"JK40", 4, 17784},
	{"JK41", 4, 17785},
	{"JK42", 4, 17786},
	{"JK43", 4, 17787},
	{"JK44", 4, 17788},
	{"JK45", 4, 17789},
	{"JK46", 4, 17790},
	{"JK47", 4, 17791},
	{"JK48", 4, 17792},
	{"JK49", 4, 17793},
	{"JK50", 4, 17794},
	{"JK51", 4, 17795},
	{"JK52", 4, 17796},
	{"JK53", 4, 17797},
	{"JK54", 4, 17798},
	{"JK55", 4, 17799},
	{"JK56", 4, 17800},
	{"JK57", 4, 17801},
	{"JK58", 4, 17802},
	{"JK59", 4, 17803},
	{"JK60", 4, 17804},
	{"JK61", 4, 17805},
	{"JK62", 4, 17806},
	{"JK63", 4, 17807},
	{"JK64", 4, 17808},
	{"JK65", 4, 17809},
	{"JK66", 4, 17810},
	{"JK67", 4, 17811},
	{"JK68", 4, 17812},
	{"JK69", 4, 17813},
	{"JK70", 4, 17814},
	{"JK71", 4, 17815},
	{"JK72", 4, 17816},
	{"JK73", 4, 17817},
	{"JK74", 4, 17818},
	{"JK75", 4, 17819},
	{"JK76", 4, 17820},
	{"JK77", 4, 17821},
	{"JK78", 4, 17822},
	{"JK79", 4, 17823},
	{"JK80", 4, 17824},
	{"JK81", 4, 17825},
	{"JK82", 4, 17826},
	{"JK83", 4, 17827},
	{"JK84", 4, 17828},
	{"JK85", 4, 17829},
	{"JK86", 4, 17830},
	{"JK87", 4, 17831},
	{"JK88", 4, 17832},
	{"JK89", 4, 17833},
	{"JK90", 4, 17834},
	{"JK91", 4, 17835},
	{"JK92", 4, 17836},
	{"JK93", 4, 17837},
	{"JK94", 4, 17838},
	{"JK95", 4, 17839},
	{"JK96", 4, 17840},
	{"JK97", 4, 17841},
	{"JK98", 4, 17842},
	{"JK99", 4, 17843},
	{"JL00", 4, 17844},
	{"JL01", 4, 17845},
	{"JL02", 4, 17846},
	{"JL03", 4, 17847},
	{"JL04", 4, 17848},
	{"JL05", 4, 17849},
	{"JL06", 4, 17850},
	{"JL07", 4, 17851},
	{"JL08", 4, 17852},
	{"JL09", 4, 17853},
	{"JL10", 4, 17854},
	{"JL11", 4, 17855},
	{"JL12", 4, 17856},
	{"JL13", 4, 17857},
	{"JL14", 4, 17858},
	{"JL15", 4, 17859},
	{"JL16", 4, 17860},
	{"JL17", 4, 17861},
	{"JL18", 4, 17862},
	{"JL19", 4, 17863},
	{"JL20", 4, 17864},
	{"JL21", 4, 17865},
	{"JL22", 4, 17866},
	{"JL23", 4, 17867},
	{"JL24", 4, 17868},
	{"JL25", 4, 17869},
	{"JL26", 4, 17870},
	{"JL27", 4, 17871},
	{"JL28", 4, 17872},
	{"JL29", 4, 17873},
	{"JL30", 4, 17874},
	{"JL31", 4, 17875},
	{"JL32", 4, 17876},
	{"JL33", 4, 17877},
	{"JL34", 4, 17878},
	{"JL35", 4, 17879},
	{"JL36", 4, 17880},
	{"JL37", 4, 17881},
	{"JL38", 4, 17882},
	{"JL39", 4, 17883},
	{"JL40", 4, 17884},
	{"JL41", 4, 17885},
	{"JL42", 4, 17886},
	{"JL43", 4, 17887},
	{"JL44", 4, 17888},
	{"JL45", 4, 17889},
	{"JL46", 4, 17890},
	{"JL47", 4, 17891},
	{"JL48", 4, 17892},
	{"JL49", 4, 17893},
	{"JL50", 4, 17894},
	{"JL51", 4, 17895},
	{"JL52", 4, 17896},
	{"JL53", 4, 17897},
	{"JL54", 4, 17898},
	{"JL55", 4, 17899},
	{"JL56", 4, 17900},
	{"JL57", 4, 17901},
	{"JL58", 4, 17902},
	{"JL59", 4, 17903},
	{"JL60", 4, 17904},
	{"JL61", 4, 17905},
	{"JL62", 4, 17906},
	{"JL63", 4, 17907},
	{"JL64", 4, 17908},
	{"JL65", 4, 17909},
	{"JL66", 4, 17910},
	{"JL67", 4, 17911},
	{"JL68", 4, 17912},
	{"JL69", 4, 17913},
	{"JL70", 4, 17914},
	{"JL71", 4, 17915},
	{"JL72", 4, 17916},
	{"JL73", 4, 17917},
	{"JL74", 4, 17918},
	{"JL75", 4, 17919},
	{"JL76", 4, 17920},
	{"JL77", 4, 17921},
	{"JL78", 4, 17922},
	{"JL79", 4, 17923},
	{"JL80", 4, 17924},
	{"JL81", 4, 17925},
	{"JL82", 4, 17926},
	{"JL83", 4, 17927},
	{"JL84", 4, 17928},
	{"JL85", 4, 17929},
	{"JL86", 4, 17930},
	{"JL87", 4, 17931},
	{"JL88", 4, 17932},
	{"JL89", 4, 17933},
	{"JL90", 4, 17934},
	{"JL91", 4, 17935},
	{"JL92", 4, 17936},
	{"JL93", 4, 17937},
	{"JL94", 4, 17938},
	{"JL95", 4, 17939},
	{"JL96", 4, 17940},
	{"JL97", 4, 17941},
	{"JL98", 4, 17942},
	{"JL99", 4, 17943},
	{"JM00", 4, 17944},
	{"JM01", 4, 17945},
	{"JM02", 4, 17946},
	{"JM03", 4, 17947},
	{"JM04", 4, 17948},
	{"JM05", 4, 17949},
	{"JM06", 4, 17950},
	{"JM07", 4, 17951},
	{"JM08", 4, 17952},
	{"JM09", 4, 17953},
	{"JM10", 4, 17954},
	{"JM11", 4, 17955},
	{"JM12", 4, 17956},
	{"JM13", 4, 17957},
	{"JM14", 4, 17958},
	{"JM15", 4, 17959},
	{"JM16", 4, 17960},
	{"JM17", 4, 17961},
	{"JM18", 4, 17962},
	{"JM19", 4, 17963},
	{"JM20", 4, 17964},
	{"JM21", 4, 17965},
	{"JM22", 4, 17966},
	{"JM23", 4, 17967},
	{"JM24", 4, 17968},
	{"JM25", 4, 17969},
	{"JM26", 4, 17970},
	{"JM27", 4, 17971},
	{"JM28", 4, 17972},
	{"JM29", 4, 17973},
	{"JM30", 4, 17974},
	{"JM31", 4, 17975},
	{"JM32", 4, 17976},
	{"JM33", 4, 17977},
	{"JM34", 4, 17978},
	{"JM35", 4, 17979},
	{"JM36", 4, 17980},
	{"JM37", 4, 17981},
	{"JM38", 4, 17982},
	{"JM39", 4, 17983},
	{"JM40", 4, 17984},
	{"JM41", 4, 17985},
	{"JM42", 4, 17986},
	{"JM43", 4, 17987},
	{"JM44", 4, 17988},
	{"JM45", 4, 17989},
	{"JM46", 4, 17990},
	{"JM47", 4, 17991},
	{"JM48", 4, 17992},
	{"JM49", 4, 17993},
	{"JM50", 4, 17994},
	{"JM51", 4, 17995},
	{"JM52", 4, 17996},
	{"JM53", 4, 17997},
	{"JM54", 4, 17998},
	{"JM55", 4, 17999},
	{"JM56", 4, 18000},
	{"JM57", 4, 18001},
	{"JM58", 4, 18002},
	{"JM59", 4, 18003},
	{"JM60", 4, 18004},
	{"JM61", 4, 18005},
	{"JM62", 4, 18006},
	{"JM63", 4, 18007},
	{"JM64", 4, 18008},
	{"JM65", 4, 18009},
	{"JM66", 4, 18010},
	{"JM67", 4, 18011},
	{"JM68", 4, 18012},
	{"JM69", 4, 18013},
	{"JM70", 4, 18014},
	{"JM71", 4, 18015},
	{"JM72", 4, 18016},
	{"JM73", 4, 18017},
	{"JM74", 4, 18018},
	{"JM75", 4, 18019},
	{"JM76", 4, 18020},
	{"JM77", 4, 18021},
	{"JM78", 4, 18022},
	{"JM79", 4, 18023},
	{"JM80", 4, 18024},
	{"JM81", 4, 18025},
	{"JM82", 4, 18026},
	{"JM83", 4, 18027},
	{"JM84", 4, 18028},
	{"JM85", 4, 18029},
	{"JM86", 4, 18030},
	{"JM87", 4, 18031},
	{"JM88", 4, 18032},
	{"JM89", 4, 18033},
	{"JM90", 4, 18034},
	{"JM91", 4, 18035},
	{"JM92", 4, 18036},
	{"JM93", 4, 18037},
	{"JM94", 4, 18038},
	{"JM95", 4, 18039},
	{"JM96", 4, 18040},
	{"JM97", 4, 18041},
	{"JM98", 4, 18042},
	{"JM99", 4, 18043},
	{"JN00", 4, 18044},
	{"JN01", 4, 18045},
	{"JN02", 4, 18046},
	{"JN03", 4, 18047},
	{"JN04", 4, 18048},
	{"JN05", 4, 18049},
	{"JN06", 4, 18050},
	{"JN07", 4, 18051},
	{"JN08", 4, 18052},
	{"JN09", 4, 18053},
	{"JN10", 4, 18054},
	{"JN11", 4, 18055},
	{"JN12", 4, 18056},
	{"JN13", 4, 18057},
	{"JN14", 4, 18058},
	{"JN15", 4, 18059},
	{"JN16", 4, 18060},
	{"JN17", 4, 18061},
	{"JN18", 4, 18062},
	{"JN19", 4, 18063},
	{"JN20", 4, 18064},
	{"JN21", 4, 18065},
	{"JN22", 4, 18066},
	{"JN23", 4, 18067},
	{"JN24", 4, 18068},
	{"JN25", 4, 18069},
	{"JN26", 4, 18070},
	{"JN27", 4, 18071},
	{"JN28", 4, 18072},
	{"JN29", 4, 18073},
	{"JN30", 4, 18074},
	{"JN31", 4, 18075},
	{"JN32", 4, 18076},
	{"JN33", 4, 18077},
	{"JN34", 4, 18078},
	{"JN35", 4, 18079},
	{"JN36", 4, 18080},
	{"JN37", 4, 18081},
	{"JN38", 4, 18082},
	{"JN39", 4, 18083},
	{"JN40", 4, 18084},
	{"JN41", 4, 18085},
	{"JN42", 4, 18086},
	{"JN43", 4, 18087},
	{"JN44", 4, 18088},
	{"JN45", 4, 18089},
	{"JN46", 4, 18090},
	{"JN47", 4, 18091},
	{"JN48", 4, 18092},
	{"JN49", 4, 18093},
	{"JN50", 4, 18094},
	{"JN51", 4, 18095},
	{"JN52", 4, 18096},
	{"JN53", 4, 18097},
	{"JN54", 4, 18098},
	{"JN55", 4, 18099},
	{"JN56", 4, 18100},
	{"JN57", 4, 18101},
	{"JN58", 4, 18102},
	{"JN59", 4, 18103},
	{"JN60", 4, 18104},
	{"JN61", 4, 18105},
	{"JN62", 4, 18106},
	{"JN63", 4, 18107},
	{"JN64", 4, 18108},
	{"JN65", 4, 18109},
	{"JN66", 4, 18110},
	{"JN67", 4, 18111},
	{"JN68", 4, 18112},
	{"JN69", 4, 18113},
	{"JN70", 4, 18114},
	{"JN71", 4, 18115},
	{"JN72", 4, 18116},
	{"JN73", 4, 18117},
	{"JN74", 4, 18118},
	{"JN75", 4, 18119},
	{"JN76", 4, 18120},
	{"JN77", 4, 18121},
	{"JN78", 4, 18122},
	{"JN79", 4, 18123},
	{"JN80", 4, 18124},
	{"JN81", 4, 18125},
	{"JN82", 4, 18126},
	{"JN83", 4, 18127},
	{"JN84", 4, 18128},
	{"JN85", 4, 18129},
	{"JN86", 4, 18130},
	{"JN87", 4, 18131},
	{"JN88", 4, 18132},
	{"JN89", 4, 18133},
	{"JN90", 4, 18134},
	{"JN91", 4, 18135},
	{"JN92", 4, 18136},
	{"JN93", 4, 18137},
	{"JN94", 4, 18138},
	{"JN95", 4, 18139},
	{"JN96", 4, 18140},
	{"JN97", 4, 18141},
	{"JN98", 4, 18142},
	{"JN99", 4, 18143},
	{"JO00", 4, 18144},
	{"JO01", 4, 18145},
	{"JO02", 4, 18146},
	{"JO03", 4, 18147},
	{"JO04", 4, 18148},
	{"JO05", 4, 18149},
	{"JO06", 4, 18150},
	{"JO07", 4, 18151},
	{"JO08", 4, 18152},
	{"JO09", 4, 18153},
	{"JO10", 4, 18154},
	{"JO11", 4, 18155},
	{"JO12", 4, 18156},
	{"JO13", 4, 18157},
	{"JO14", 4, 18158},
	{"JO15", 4, 18159},
	{"JO16", 4, 18160},
	{"JO17", 4, 18161},
	{"JO18", 4, 18162},
	{"JO19", 4, 18163},
	{"JO20", 4, 18164},
	{"JO21", 4, 18165},
	{"JO22", 4, 18166},
	{"JO23", 4, 18167},
	{"JO24", 4, 18168},
	{"JO25", 4, 18169},
	{"JO26", 4, 18170},
	{"JO27", 4, 18171},
	{"JO28", 4, 18172},
	{"JO29", 4, 18173},
	{"JO30", 4, 18174},
	{"JO31", 4, 18175},
	{"JO32", 4, 18176},
	{"JO33", 4, 18177},
	{"JO34", 4, 18178},
	{"JO35", 4, 18179},
	{"JO36", 4, 18180},
	{"JO37", 4, 18181},
	{"JO38", 4, 18182},
	{"JO39", 4, 18183},
	{"JO40", 4, 18184},
	{"JO41", 4, 18185},
	{"JO42", 4, 18186},
	{"JO43", 4, 18187},
	{"JO44", 4, 18188},
	{"JO45", 4, 18189},
	{"JO46", 4, 18190},
	{"JO47", 4, 18191},
	{"JO48", 4, 18192},
	{"JO49", 4, 18193},
	{"JO50", 4, 18194},
	{"JO51", 4, 18195},
	{"JO52", 4, 18196},
	{"JO53", 4, 18197},
	{"JO54", 4, 18198},
	{"JO55", 4, 18199},
	{"JO56", 4, 18200},
	{"JO57", 4, 18201},
	{"JO58", 4, 18202},
	{"JO59", 4, 18203},
	{"JO60", 4, 18204},
	{"JO61", 4, 18205},
	{"JO62", 4, 18206},
	{"JO63", 4, 18207},
	{"JO64", 4, 18208},
	{"JO65", 4, 18209},
	{"JO66", 4, 18210},
	{"JO67", 4, 18211},
	{"JO68", 4, 18212},
	{"JO69", 4, 18213},
	{"JO70", 4, 18214},
	{"JO71", 4, 18215},
	{"JO72", 4, 18216},
	{"JO73", 4, 18217},
	{"JO74", 4, 18218},
	{"JO75", 4, 18219},
	{"JO76", 4, 18220},
	{"JO77", 4, 18221},
	{"JO78", 4, 18222},
	{"JO79", 4, 18223},
	{"JO80", 4, 18224},
	{"JO81", 4, 18225},
	{"JO82", 4, 18226},
	{"JO83", 4, 18227},
	{"JO84", 4, 18228},
	{"JO85", 4, 18229},
	{"JO86", 4, 18230},
	{"JO87", 4, 18231},
	{"JO88", 4, 18232},
	{"JO89", 4, 18233},
	{"JO90", 4, 18234},
	{"JO91", 4, 18235},
	{"JO92", 4, 18236},
	{"JO93", 4, 18237},
	{"JO94", 4, 18238},
	{"JO95", 4, 18239},
	{"JO96", 4, 18240},
	{"JO97", 4, 18241},
	{"JO98", 4, 18242},
	{"JO99", 4, 18243},
	{"JP00", 4, 18244},
	{"JP01", 4, 18245},
	{"JP02", 4, 18246},
	{"JP03", 4, 18247},
	{"JP04", 4, 18248},
	{"JP05", 4, 18249},
	{"JP06", 4, 18250},
	{"JP07", 4, 18251},
	{"JP08", 4, 18252},
	{"JP09", 4, 18253},
	{"JP10", 4, 18254},
	{"JP11", 4, 18255},
	{"JP12", 4, 18256},
	{"JP13", 4, 18257},
	{"JP14", 4, 18258},
	{"JP15", 4, 18259},
	{"JP16", 4, 18260},
	{"JP17", 4, 18261},
	{"JP18", 4, 18262},
	{"JP19", 4, 18263},
	{"JP20", 4, 18264},
	{"JP21", 4, 18265},
	{"JP22", 4, 18266},
	{"JP23", 4, 18267},
	{"JP24", 4, 18268},
	{"JP25", 4, 18269},
	{"JP26", 4, 18270},
	{"JP27", 4, 18271},
	{"JP28", 4, 18272},
	{"JP29", 4, 18273},
	{"JP30", 4, 18274},
	{"JP31", 4, 18275},
	{"JP32", 4, 18276},
	{"JP33", 4, 18277},
	{"JP34", 4, 18278},
	{"JP35", 4, 18279},
	{"JP36", 4, 18280},
	{"JP37", 4, 18281},
	{"JP38", 4, 18282},
	{"JP39", 4, 18283},
	{"JP40", 4, 18284},
	{"JP41", 4, 18285},
	{"JP42", 4, 18286},
	{"JP43", 4, 18287},
	{"JP44", 4, 18288},
	{"JP45", 4, 18289},
	{"JP46", 4, 18290},
	{"JP47", 4, 18291},
	{"JP48", 4, 18292},
	{"JP49", 4, 18293},
	{"JP50", 4, 18294},
	{"JP51", 4, 18295},
	{"JP52", 4, 18296},
	{"JP53", 4, 18297},
	{"JP54", 4, 18298},
	{"JP55", 4, 18299},
	{"JP56", 4, 18300},
	{"JP57", 4, 18301},
	{"JP58", 4, 18302},
	{"JP59", 4, 18303},
	{"JP60", 4, 18304},
	{"JP61", 4, 18305},
	{"JP62", 4, 18306},
	{"JP63", 4, 18307},
	{"JP64", 4, 18308},
	{"JP65", 4, 18309},
	{"JP66", 4, 18310},
	{"JP67", 4, 18311},
	{"JP68", 4, 18312},
	{"JP69", 4, 18313},
	{"JP70", 4, 18314},
	{"JP71", 4, 18315},
	{"JP72", 4, 18316},
	{"JP73", 4, 18317},
	{"JP74", 4, 18318},
	{"JP75", 4, 18319},
	{"JP76", 4, 18320},
	{"JP77", 4, 18321},
	{"JP78", 4, 18322},
	{"JP79", 4, 18323},
	{"JP80", 4, 18324},
	{"JP81", 4, 18325},
	{"JP82", 4, 18326},
	{"JP83", 4, 18327},
	{"JP84", 4, 18328},
	{"JP85", 4, 18329},
	{"JP86", 4, 18330},
	{"JP87", 4, 18331},
	{"JP88", 4, 18332},
	{"JP89", 4, 18333},
	{"JP90", 4, 18334},
	{"JP91", 4, 18335},
	{"JP92", 4, 18336},
	{"JP93", 4, 18337},
	{"JP94", 4, 18338},
	{"JP95", 4, 18339},
	{"JP96", 4, 18340},
	{"JP97", 4, 18341},
	{"JP98", 4, 18342},
	{"JP99", 4, 18343},
	{"JQ00", 4, 18344},
	{"JQ01", 4, 18345},
	{"JQ02", 4, 18346},
	{"JQ03", 4, 18347},
	{"JQ04", 4, 18348},
	{"JQ05", 4, 18349},
	{"JQ06", 4, 18350},
	{"JQ07", 4, 18351},
	{"JQ08", 4, 18352},
	{"JQ09", 4, 18353},
	{"JQ10", 4, 18354},
	{"JQ11", 4, 18355},
	{"JQ12", 4, 18356},
	{"JQ13", 4, 18357},
	{"JQ14", 4, 18358},
	{"JQ15", 4, 18359},
	{"JQ16", 4, 18360},
	{"JQ17", 4, 18361},
	{"JQ18", 4, 18362},
	{"JQ19", 4, 18363},
	{"JQ20", 4, 18364},
	{"JQ21", 4, 18365},
	{"JQ22", 4, 18366},
	{"JQ23", 4, 18367},
	{"JQ24", 4, 18368},
	{"JQ25", 4, 18369},
	{"JQ26", 4, 18370},
	{"JQ27", 4, 18371},
	{"JQ28", 4, 18372},
	{"JQ29", 4, 18373},
	{"JQ30", 4, 18374},
	{"JQ31", 4, 18375},
	{"JQ32", 4, 18376},
	{"JQ33", 4, 18377},
	{"JQ34", 4, 18378},
	{"JQ35", 4, 18379},
	{"JQ36", 4, 18380},
	{"JQ37", 4, 18381},
	{"JQ38", 4, 18382},
	{"JQ39", 4, 18383},
	{"JQ40", 4, 18384},
	{"JQ41", 4, 18385},
	{"JQ42", 4, 18386},
	{"JQ43", 4, 18387},
	{"JQ44", 4, 18388},
	{"JQ45", 4, 18389},
	{"JQ46", 4, 18390},
	{"JQ47", 4, 18391},
	{"JQ48", 4, 18392},
	{"JQ49", 4, 18393},
	{"JQ50", 4, 18394},
	{"JQ51", 4, 18395},
	{"JQ52", 4, 18396},
	{"JQ53", 4, 18397},
	{"JQ54", 4, 18398},
	{"JQ55", 4, 18399},
	{"JQ56", 4, 18400},
	{"JQ57", 4, 18401},
	{"JQ58", 4, 18402},
	{"JQ59", 4, 18403},
	{"JQ60", 4, 18404},
	{"JQ61", 4, 18405},
	{"JQ62", 4, 18406},
	{"JQ63", 4, 18407},
	{"JQ64", 4, 18408},
	{"JQ65", 4, 18409},
	{"JQ66", 4, 18410},
	{"JQ67", 4, 18411},
	{"JQ68", 4, 18412},
	{"JQ69", 4, 18413},
	{"JQ70", 4, 18414},
	{"JQ71", 4, 18415},
	{"JQ72", 4, 18416},
	{"JQ73", 4, 18417},
	{"JQ74", 4, 18418},
	{"JQ75", 4, 18419},
	{"JQ76", 4, 18420},
	{"JQ77", 4, 18421},
	{"JQ78", 4, 18422},
	{"JQ79", 4, 18423},
	{"JQ80", 4, 18424},
	{"JQ81", 4, 18425},
	{"JQ82", 4, 18426},
	{"JQ83", 4, 18427},
	{"JQ84", 4, 18428},
	{"JQ85", 4, 18429},
	{"JQ86", 4, 18430},
	{"JQ87", 4, 18431},
	{"JQ88", 4, 18432},
	{"JQ89", 4, 18433},
	{"JQ90", 4, 18434},
	{"JQ91", 4, 18435},
	{"JQ92", 4, 18436},
	{"JQ93", 4, 18437},
	{"JQ94", 4, 18438},
	{"JQ95", 4, 18439},
	{"JQ96", 4, 18440},
	{"JQ97", 4, 18441},
	{"JQ98", 4, 18442},
	{"JQ99", 4, 18443},
	{"KB00", 4, 18444},
	{"KB01", 4, 18445},
	{"KB02", 4, 18446},
	{"KB03", 4, 18447},
	{"KB04", 4, 18448},
	{"KB05", 4, 18449},
	{"KB06", 4, 18450},
	{"KB07", 4, 18451},
	{"KB08", 4, 18452},
	{"KB09", 4, 18453},
	{"KB10", 4, 18454},
	{"KB11", 4, 18455},
	{"KB12", 4, 18456},
	{"KB13", 4, 18457},
	{"KB14", 4, 18458},
	{"KB15", 4, 18459},
	{"KB16", 4, 18460},
	{"KB17", 4, 18461},
	{"KB18", 4, 18462},
	{"KB19", 4, 18463},
	{"KB20", 4, 18464},
	{"KB21", 4, 18465},
	{"KB22", 4, 18466},
	{"KB23", 4, 18467},
	{"KB24", 4, 18468},
	{"KB25", 4, 18469},
	{"KB26", 4, 18470},
	{"KB27", 4, 18471},
	{"KB28", 4, 18472},
	{"KB29", 4, 18473},
	{"KB30", 4, 18474},
	{"KB31", 4, 18475},
	{"KB32", 4, 18476},
	{"KB33", 4, 18477},
	{"KB34", 4, 18478},
	{"KB35", 4, 18479},
	{"KB36", 4, 18480},
	{"KB37", 4, 18481},
	{"KB38", 4, 18482},
	{"KB39", 4, 18483},
	{"KB40", 4, 18484},
	{"KB41", 4, 18485},
	{"KB42", 4, 18486},
	{"KB43", 4, 18487},
	{"KB44", 4, 18488},
	{"KB45", 4, 18489},
	{"KB46", 4, 18490},
	{"KB47", 4, 18491},
	{"KB48", 4, 18492},
	{"KB49", 4, 18493},
	{"KB50", 4, 18494},
	{"KB51", 4, 18495},
	{"KB52", 4, 18496},
	{"KB53", 4, 18497},
	{"KB54", 4, 18498},
	{"KB55", 4, 18499},
	{"KB56", 4, 18500},
	{"KB57", 4, 18501},
	{"KB58", 4, 18502},
	{"KB59", 4, 18503},
	{"KB60", 4, 18504},
	{"KB61", 4, 18505},
	{"KB62", 4, 18506},
	{"KB63", 4, 18507},
	{"KB64", 4, 18508},
	{"KB65", 4, 18509},
	{"KB66", 4, 18510},
	{"KB67", 4, 18511},
	{"KB68", 4, 18512},
	{"KB69", 4, 18513},
	{"KB70", 4, 18514},
	{"KB71", 4, 18515},
	{"KB72", 4, 18516},
	{"KB73", 4, 18517},
	{"KB74", 4, 18518},
	{"KB75", 4, 18519},
	{"KB76", 4, 18520},
	{"KB77", 4, 18521},
	{"KB78", 4, 18522},
	{"KB79", 4, 18523},
	{"KB80", 4, 18524},
	{"KB81", 4, 18525},
	{"KB82", 4, 18526},
	{"KB83", 4, 18527},
	{"KB84", 4, 18528},
	{"KB85", 4, 18529},
	{"KB86", 4, 18530},
	{"KB87", 4, 18531},
	{"KB88", 4, 18532},
	{"KB89", 4, 18533},
	{"KB90", 4, 18534},
	{"KB91", 4, 18535},
	{"KB92", 4, 18536},
	{"KB93", 4, 18537},
	{"KB94", 4, 18538},
	{"KB95", 4, 18539},
	{"KB96", 4, 18540},
	{"KB97", 4, 18541},
	{"KB98", 4, 18542},
	{"KB99", 4, 18543},
	{"KC00", 4, 18544},
	{"KC01", 4, 18545},
	{"KC02", 4, 18546},
	{"KC03", 4, 18547},
	{"KC04", 4, 18548},
	{"KC05", 4, 18549},
	{"KC06", 4, 18550},
	{"KC07", 4, 18551},
	{"KC08", 4, 18552},
	{"KC09", 4, 18553},
	{"KC10", 4, 18554},
	{"KC11", 4, 18555},
	{"KC12", 4, 18556},
	{"KC13", 4, 18557},
	{"KC14", 4, 18558},
	{"KC15", 4, 18559},
	{"KC16", 4, 18560},
	{"KC17", 4, 18561},
	{"KC18", 4, 18562},
	{"KC19", 4, 18563},
	{"KC20", 4, 18564},
	{"KC21", 4, 18565},
	{"KC22", 4, 18566},
	{"KC23", 4, 18567},
	{"KC24", 4, 18568},
	{"KC25", 4, 18569},
	{"KC26", 4, 18570},
	{"KC27", 4, 18571},
	{"KC28", 4, 18572},
	{"KC29", 4, 18573},
	{"KC30", 4, 18574},
	{"KC31", 4, 18575},
	{"KC32", 4, 18576},
	{"KC33", 4, 18577},
	{"KC34", 4, 18578},
	{"KC35", 4, 18579},
	{"KC36", 4, 18580},
	{"KC37", 4, 18581},
	{"KC38", 4, 18582},
	{"KC39", 4, 18583},
	{"KC40", 4, 18584},
	{"KC41", 4, 18585},
	{"KC42", 4, 18586},
	{"KC43", 4, 18587},
	{"KC44", 4, 18588},
	{"KC45", 4, 18589},
	{"KC46", 4, 18590},
	{"KC47", 4, 18591},
	{"KC48", 4, 18592},
	{"KC49", 4, 18593},
	{"KC50", 4, 18594},
	{"KC51", 4, 18595},
	{"KC52", 4, 18596},
	{"KC53", 4, 18597},
	{"KC54", 4, 18598},
	{"KC55", 4, 18599},
	{"KC56", 4, 18600},
	{"KC57", 4, 18601},
	{"KC58", 4, 18602},
	{"KC59", 4, 18603},
	{"KC60", 4, 18604},
	{"KC61", 4, 18605},
	{"KC62", 4, 18606},
	{"KC63", 4, 18607},
	{"KC64", 4, 18608},
	{"KC65", 4, 18609},
	{"KC66", 4, 18610},
	{"KC67", 4, 18611},
	{"KC68", 4, 18612},
	{"KC69", 4, 18613},
	{"KC70", 4, 18614},
	{"KC71", 4, 18615},
	{"KC72", 4, 18616},
	{"KC73", 4, 18617},
	{"KC74", 4, 18618},
	{"KC75", 4, 18619},
	{"KC76", 4, 18620},
	{"KC77", 4, 18621},
	{"KC78", 4, 18622},
	{"KC79", 4, 18623},
	{"KC80", 4, 18624},
	{"KC81", 4, 18625},
	{"KC82", 4, 18626},
	{"KC83", 4, 18627},
	{"KC84", 4, 18628},
	{"KC85", 4, 18629},
	{"KC86", 4, 18630},
	{"KC87", 4, 18631},
	{"KC88", 4, 18632},
	{"KC89", 4, 18633},
	{"KC90", 4, 18634},
	{"KC91", 4, 18635},
	{"KC92", 4, 18636},
	{"KC93", 4, 18637},
	{"KC94", 4, 18638},
	{"KC95", 4, 18639},
	{"KC96", 4, 18640},
	{"KC97", 4, 18641},
	{"KC98", 4, 18642},
	{"KC99", 4, 18643},
	{"KF00", 4, 18644},
	{"KF01", 4, 18645},
	{"KF02", 4, 18646},
	{"KF03", 4, 18647},
	{"KF04", 4, 18648},
	{"KF05", 4, 18649},
	{"KF06", 4, 18650},
	{"KF07", 4, 18651},
	{"KF08", 4, 18652},
	{"KF09", 4, 18653},
	{"KF10", 4, 18654},
	{"KF11", 4, 18655},
	{"KF12", 4, 18656},
	{"KF13", 4, 18657},
	{"KF14", 4, 18658},
	{"KF15", 4, 18659},
	{"KF16", 4, 18660},
	{"KF17", 4, 18661},
	{"KF18", 4, 18662},
	{"KF19", 4, 18663},
	{"KF20", 4, 18664},
	{"KF21", 4, 18665},
	{"KF22", 4, 18666},
	{"KF23", 4, 18667},
	{"KF24", 4, 18668},
	{"KF25", 4, 18669},
	{"KF26", 4, 18670},
	{"KF27", 4, 18671},
	{"KF28", 4, 18672},
	{"KF29", 4, 18673},
	{"KF30", 4, 18674},
	{"KF31", 4, 18675},
	{"KF32", 4, 18676},
	{"KF33", 4, 18677},
	{"KF34", 4, 18678},
	{"KF35", 4, 18679},
	{"KF36", 4, 18680},
	{"KF37", 4, 18681},
	{"KF38", 4, 18682},
	{"KF39", 4, 18683},
	{"KF40", 4, 18684},
	{"KF41", 4, 18685},
	{"KF42", 4, 18686},
	{"KF43", 4, 18687},
	{"KF44", 4, 18688},
	{"KF45", 4, 18689},
	{"KF46", 4, 18690},
	{"KF47", 4, 18691},
	{"KF48", 4, 18692},
	{"KF49", 4, 18693},
	{"KF50", 4, 18694},
	{"KF51", 4, 18695},
	{"KF52", 4, 18696},
	{"KF53", 4, 18697},
	{"KF54", 4, 18698},
	{"KF55", 4, 18699},
	{"KF56", 4, 18700},
	{"KF57", 4, 18701},
	{"KF58", 4, 18702},
	{"KF59", 4, 18703},
	{"KF60", 4, 18704},
	{"KF61", 4, 18705},
	{"KF62", 4, 18706},
	{"KF63", 4, 18707},
	{"KF64", 4, 18708},
	{"KF65", 4, 18709},
	{"KF66", 4, 18710},
	{"KF67", 4, 18711},
	{"KF68", 4, 18712},
	{"KF69", 4, 18713},
	{"KF70", 4, 18714},
	{"KF71", 4, 18715},
	{"KF72", 4, 18716},
	{"KF73", 4, 18717},
	{"KF74", 4, 18718},
	{"KF75", 4, 18719},
	{"KF76", 4, 18720},
	{"KF77", 4, 18721},
	{"KF78", 4, 18722},
	{"KF79", 4, 18723},
	{"KF80", 4, 18724},
	{"KF81", 4, 18725},
	{"KF82", 4, 18726},
	{"KF83", 4, 18727},
	{"KF84", 4, 18728},
	{"KF85", 4, 18729},
	{"KF86", 4, 18730},
	{"KF87", 4, 18731},
	{"KF88", 4, 18732},
	{"KF89", 4, 18733},
	{"KF90", 4, 18734},
	{"KF91", 4, 18735},
	{"KF92", 4, 18736},
	{"KF93", 4, 18737},
	{"KF94", 4, 18738},
	{"KF95", 4, 18739},
	{"KF96", 4, 18740},
	{"KF97", 4, 18741},
	{"KF98", 4, 18742},
	{"KF99", 4, 18743},
	{"KG00", 4, 18744},
	{"KG01", 4, 18745},
	{"KG02", 4, 18746},
	{"KG03", 4, 18747},
	{"KG04", 4, 18748},
	{"KG05", 4, 18749},
	{"KG06", 4, 18750},
	{"KG07", 4, 18751},
	{"KG08", 4, 18752},
	{"KG09", 4, 18753},
	{"KG10", 4, 18754},
	{"KG11", 4, 18755},
	{"KG12", 4, 18756},
	{"KG13", 4, 18757},
	{"KG14", 4, 18758},
	{"KG15", 4, 18759},
	{"KG16", 4, 18760},
	{"KG17", 4, 18761},
	{"KG18", 4, 18762},
	{"KG19", 4, 18763},
	{"KG20", 4, 18764},
	{"KG21", 4, 18765},
	{"KG22", 4, 18766},
	{"KG23", 4, 18767},
	{"KG24", 4, 18768},
	{"KG25", 4, 18769},
	{"KG26", 4, 18770},
	{"KG27", 4, 18771},
	{"KG28", 4, 18772},
	{"KG29", 4, 18773},
	{"KG30", 4, 18774},
	{"KG31", 4, 18775},
	{"KG32", 4, 18776},
	{"KG33", 4, 18777},
	{"KG34", 4, 18778},
	{"KG35", 4, 18779},
	{"KG36", 4, 18780},
	{"KG37", 4, 18781},
	{"KG38", 4, 18782},
	{"KG39", 4, 18783},
	{"KG40", 4, 18784},
	{"KG41", 4, 18785},
	{"KG42", 4, 18786},
	{"KG43", 4, 18787},
	{"KG44", 4, 18788},
	{"KG45", 4, 18789},
	{"KG46", 4, 18790},
	{"KG47", 4, 18791},
	{"KG48", 4, 18792},
	{"KG49", 4, 18793},
	{"KG50", 4, 18794},
	{"KG51", 4, 18795},
	{"KG52", 4, 18796},
	{"KG53", 4, 18797},
	{"KG54", 4, 18798},
	{"KG55", 4, 18799},
	{"KG56", 4, 18800},
	{"KG57", 4, 18801},
	{"KG58", 4, 18802},
	{"KG59", 4, 18803},
	{"KG60", 4, 18804},
	{"KG61", 4, 18805},
	{"KG62", 4, 18806},
	{"KG63", 4, 18807},
	{"KG64", 4, 18808},
	{"KG65", 4, 18809},
	{"KG66", 4, 18810},
	{"KG67", 4, 18811},
	{"KG68", 4, 18812},
	{"KG69", 4, 18813},
	{"KG70", 4, 18814},
	{"KG71", 4, 18815},
	{"KG72", 4, 18816},
	{"KG73", 4, 18817},
	{"KG74", 4, 18818},
	{"KG75", 4, 18819},
	{"KG76", 4, 18820},
	{"KG77", 4, 18821},
	{"KG78", 4, 18822},
	{"KG79", 4, 18823},
	{"KG80", 4, 18824},
	{"KG81", 4, 18825},
	{"KG82", 4, 18826},
	{"KG83", 4, 18827},
	{"KG84", 4, 18828},
	{"KG85", 4, 18829},
	{"KG86", 4, 18830},
	{"KG87", 4, 18831},
	{"KG88", 4, 18832},
	{"KG89", 4, 18833},
	{"KG90", 4, 18834},
	{"KG91", 4, 18835},
	{"KG92", 4, 18836},
	{"KG93", 4, 18837},
	{"KG94", 4, 18838},
	{"KG95", 4, 18839},
	{"KG96", 4, 18840},
	{"KG97", 4, 18841},
	{"KG98", 4, 18842},
	{"KG99", 4, 18843},
	{"KH00", 4, 18844},
	{"KH01", 4, 18845},
	{"KH02", 4, 18846},
	{"KH03", 4, 18847},
	{"KH04", 4, 18848},
	{"KH05", 4, 18849},
	{"KH06", 4, 18850},
	{"KH07", 4, 18851},
	{"KH08", 4, 18852},
	{"KH09", 4, 18853},
	{"KH10", 4, 18854},
	{"KH11", 4, 18855},
	{"KH12", 4, 18856},
	{"KH13", 4, 18857},
	{"KH14", 4, 18858},
	{"KH15", 4, 18859},
	{"KH16", 4, 18860},
	{"KH17", 4, 18861},
	{"KH18", 4, 18862},
	{"KH19", 4, 18863},
	{"KH20", 4, 18864},
	{"KH21", 4, 18865},
	{"KH22", 4, 18866},
	{"KH23", 4, 18867},
	{"KH24", 4, 18868},
	{"KH25", 4, 18869},
	{"KH26", 4, 18870},
	{"KH27", 4, 18871},
	{"KH28", 4, 18872},
	{"KH29", 4, 18873},
	{"KH30", 4, 18874},
	{"KH31", 4, 18875},
	{"KH32", 4, 18876},
	{"KH33", 4, 18877},
	{"KH34", 4, 18878},
	{"KH35", 4, 18879},
	{"KH36", 4, 18880},
	{"KH37", 4, 18881},
	{"KH38", 4, 18882},
	{"KH39", 4, 18883},
	{"KH40", 4, 18884},
	{"KH41", 4, 18885},
	{"KH42", 4, 18886},
	{"KH43", 4, 18887},
	{"KH44", 4, 18888},
	{"KH45", 4, 18889},
	{"KH46", 4, 18890},
	{"KH47", 4, 18891},
	{"KH48", 4, 18892},
	{"KH49", 4, 18893},
	{"KH50", 4, 18894},
	{"KH51", 4, 18895},
	{"KH52", 4, 18896},
	{"KH53", 4, 18897},
	{"KH54", 4, 18898},
	{"KH55", 4, 18899},
	{"KH56", 4, 18900},
	{"KH57", 4, 18901},
	{"KH58", 4, 18902},
	{"KH59", 4, 18903},
	{"KH60", 4, 18904},
	{"KH61", 4, 18905},
	{"KH62", 4, 18906},
	{"KH63", 4, 18907},
	{"KH64", 4, 18908},
	{"KH65", 4, 18909},
	{"KH66", 4, 18910},
	{"KH67", 4, 18911},
	{"KH68", 4, 18912},
	{"KH69", 4, 18913},
	{"KH70", 4, 18914},
	{"KH71", 4, 18915},
	{"KH72", 4, 18916},
	{"KH73", 4, 18917},
	{"KH74", 4, 18918},
	{"KH75", 4, 18919},
	{"KH76", 4, 18920},
	{"KH77", 4, 18921},
	{"KH78", 4, 18922},
	{"KH79", 4, 18923},
	{"KH80", 4, 18924},
	{"KH81", 4, 18925},
	{"KH82", 4, 18926},
	{"KH83", 4, 18927},
	{"KH84", 4, 18928},
	{"KH85", 4, 18929},
	{"KH86", 4, 18930},
	{"KH87", 4, 18931},
	{"KH88", 4, 18932},
	{"KH89", 4, 18933},
	{"KH90", 4, 18934},
	{"KH91", 4, 18935},
	{"KH92", 4, 18936},
	{"KH93", 4, 18937},
	{"KH94", 4, 18938},
	{"KH95", 4, 18939},
	{"KH96", 4, 18940},
	{"KH97", 4, 18941},
	{"KH98", 4, 18942},
	{"KH99", 4, 18943},
	{"KI00", 4, 18944},
	{"KI01", 4, 18945},
	{"KI02", 4, 18946},
	{"KI03", 4, 18947},
	{"KI04", 4, 18948},
	{"KI05", 4, 18949},
	{"KI06", 4, 18950},
	{"KI07", 4, 18951},
	{"KI08", 4, 18952},
	{"KI09", 4, 18953},
	{"KI10", 4, 18954},
	{"KI11", 4, 18955},
	{"KI12", 4, 18956},
	{"KI13", 4, 18957},
	{"KI14", 4, 18958},
	{"KI15", 4, 18959},
	{"KI16", 4, 18960},
	{"KI17", 4, 18961},
	{"KI18", 4, 18962},
	{"KI19", 4, 18963},
	{"KI20", 4, 18964},
	{"KI21", 4, 18965},
	{"KI22", 4, 18966},
	{"KI23", 4, 18967},
	{"KI24", 4, 18968},
	{"KI25", 4, 18969},
	{"KI26", 4, 18970},
	{"KI27", 4, 18971},
	{"KI28", 4, 18972},
	{"KI29", 4, 18973},
	{"KI30", 4, 18974},
	{"KI31", 4, 18975},
	{"KI32", 4, 18976},
	{"KI33", 4, 18977},
	{"KI34", 4, 18978},
	{"KI35", 4, 18979},
	{"KI36", 4, 18980},
	{"KI37", 4, 18981},
	{"KI38", 4, 18982},
	{"KI39", 4, 18983},
	{"KI40", 4, 18984},
	{"KI41", 4, 18985},
	{"KI42", 4, 18986},
	{"KI43", 4, 18987},
	{"KI44", 4, 18988},
	{"KI45", 4, 18989},
	{"KI46", 4, 18990},
	{"KI47", 4, 18991},
	{"KI48", 4, 18992},
	{"KI49", 4, 18993},
	{"KI50", 4, 18994},
	{"KI51", 4, 18995},
	{"KI52", 4, 18996},
	{"KI53", 4, 18997},
	{"KI54", 4, 18998},
	{"KI55", 4, 18999},
	{"KI56", 4, 19000},
	{"KI57", 4, 19001},
	{"KI58", 4, 19002},
	{"KI59", 4, 19003},
	{"KI60", 4, 19004},
	{"KI61", 4, 19005},
	{"KI62", 4, 19006},
	{"KI63", 4, 19007},
	{"KI64", 4, 19008},
	{"KI65", 4, 19009},
	{"KI66", 4, 19010},
	{"KI67", 4, 19011},
	{"KI68", 4, 19012},
	{"KI69", 4, 19013},
	{"KI70", 4, 19014},
	{"KI71", 4, 19015},
	{"KI72", 4, 19016},
	{"KI73", 4, 19017},
	{"KI74", 4, 19018},
	{"KI75", 4, 19019},
	{"KI76", 4, 19020},
	{"KI77", 4, 19021},
	{"KI78", 4, 19022},
	{"KI79", 4, 19023},
	{"KI80", 4, 19024},
	{"KI81", 4, 19025},
	{"KI82", 4, 19026},
	{"KI83", 4, 19027},
	{"KI84", 4, 19028},
	{"KI85", 4, 19029},
	{"KI86", 4, 19030},
	{"KI87", 4, 19031},
	{"KI88", 4, 19032},
	{"KI89", 4, 19033},
	{"KI90", 4, 19034},
	{"KI91", 4, 19035},
	{"KI92", 4, 19036},
	{"KI93", 4, 19037},
	{"KI94", 4, 19038},
	{"KI95", 4, 19039},
	{"KI96", 4, 19040},
	{"KI97", 4, 19041},
	{"KI98", 4, 19042},
	{"KI99", 4, 19043},
	{"KJ00", 4, 19044},
	{"KJ01", 4, 19045},
	{"KJ02", 4, 19046},
	{"KJ03", 4, 19047},
	{"KJ04", 4, 19048},
	{"KJ05", 4, 19049},
	{"KJ06", 4, 19050},
	{"KJ07", 4, 19051},
	{"KJ08", 4, 19052},
	{"KJ09", 4, 19053},
	{"KJ10", 4, 19054},
	{"KJ11", 4, 19055},
	{"KJ12", 4, 19056},
	{"KJ13", 4, 19057},
	{"KJ14", 4, 19058},
	{"KJ15", 4, 19059},
	{"KJ16", 4, 19060},
	{"KJ17", 4, 19061},
	{"KJ18", 4, 19062},
	{"KJ19", 4, 19063},
	{"KJ20", 4, 19064},
	{"KJ21", 4, 19065},
	{"KJ22", 4, 19066},
	{"KJ23", 4, 19067},
	{"KJ24", 4, 19068},
	{"KJ25", 4, 19069},
	{"KJ26", 4, 19070},
	{"KJ27", 4, 19071},
	{"KJ28", 4, 19072},
	{"KJ29", 4, 19073},
	{"KJ30", 4, 19074},
	{"KJ31", 4, 19075},
	{"KJ32", 4, 19076},
	{"KJ33", 4, 19077},
	{"KJ34", 4, 19078},
	{"KJ35", 4, 19079},
	{"KJ36", 4, 19080},
	{"KJ37", 4, 19081},
	{"KJ38", 4, 19082},
	{"KJ39", 4, 19083},
	{"KJ40", 4, 19084},
	{"KJ41", 4, 19085},
	{"KJ42", 4, 19086},
	{"KJ43", 4, 19087},
	{"KJ44", 4, 19088},
	{"KJ45", 4, 19089},
	{"KJ46", 4, 19090},
	{"KJ47", 4, 19091},
	{"KJ48", 4, 19092},
	{"KJ49", 4, 19093},
	{"KJ50", 4, 19094},
	{"KJ51", 4, 19095},
	{"KJ52", 4, 19096},
	{"KJ53", 4, 19097},
	{"KJ54", 4, 19098},
	{"KJ55", 4, 19099},
	{"KJ56", 4, 19100},
	{"KJ57", 4, 19101},
	{"KJ58", 4, 19102},
	{"KJ59", 4, 19103},
	{"KJ60", 4, 19104},
	{"KJ61", 4, 19105},
	{"KJ62", 4, 19106},
	{"KJ63", 4, 19107},
	{"KJ64", 4, 19108},
	{"KJ65", 4, 19109},
	{"KJ66", 4, 19110},
	{"KJ67", 4, 19111},
	{"KJ68", 4, 19112},
	{"KJ69", 4, 19113},
	{"KJ70", 4, 19114},
	{"KJ71", 4, 19115},
	{"KJ72", 4, 19116},
	{"KJ73", 4, 19117},
	{"KJ74", 4, 19118},
	{"KJ75", 4, 19119},
	{"KJ76", 4, 19120},
	{"KJ77", 4, 19121},
	{"KJ78", 4, 19122},
	{"KJ79", 4, 19123},
	{"KJ80", 4, 19124},
	{"KJ81", 4, 19125},
	{"KJ82", 4, 19126},
	{"KJ83", 4, 19127},
	{"KJ84", 4, 19128},
	{"KJ85", 4, 19129},
	{"KJ86", 4, 19130},
	{"KJ87", 4, 19131},
	{"KJ88", 4, 19132},
	{"KJ89", 4, 19133},
	{"KJ90", 4, 19134},
	{"KJ91", 4, 19135},
	{"KJ92", 4, 19136},
	{"KJ93", 4, 19137},
	{"KJ94", 4, 19138},
	{"KJ95", 4, 19139},
	{"KJ96", 4, 19140},
	{"KJ97", 4, 19141},
	{"KJ98", 4, 19142},
	{"KJ99", 4, 19143},
	{"KK00", 4, 19144},
	{"KK01", 4, 19145},
	{"KK02", 4, 19146},
	{"KK03", 4, 19147},
	{"KK04", 4, 19148},
	{"KK05", 4, 19149},
	{"KK06", 4, 19150},
	{"KK07", 4, 19151},
	{"KK08", 4, 19152},
	{"KK09", 4, 19153},
	{"KK10", 4, 19154},
	{"KK11", 4, 19155},
	{"KK12", 4, 19156},
	{"KK13", 4, 19157},
	{"KK14", 4, 19158},
	{"KK15", 4, 19159},
	{"KK16", 4, 19160},
	{"KK17", 4, 19161},
	{"KK18", 4, 19162},
	{"KK19", 4, 19163},
	{"KK20", 4, 19164},
	{"KK21", 4, 19165},
	{"KK22", 4, 19166},
	{"KK23", 4, 19167},
	{"KK24", 4, 19168},
	{"KK25", 4, 19169},
	{"KK26", 4, 19170},
	{"KK27", 4, 19171},
	{"KK28", 4, 19172},
	{"KK29", 4, 19173},
	{"KK30", 4, 19174},
	{"KK31", 4, 19175},
	{"KK32", 4, 19176},
	{"KK33", 4, 19177},
	{"KK34", 4, 19178},
	{"KK35", 4, 19179},
	{"KK36", 4, 19180},
	{"KK37", 4, 19181},
	{"KK38", 4, 19182},
	{"KK39", 4, 19183},
	{"KK40", 4, 19184},
	{"KK41", 4, 19185},
	{"KK42", 4, 19186},
	{"KK43", 4, 19187},
	{"KK44", 4, 19188},
	{"KK45", 4, 19189},
	{"KK46", 4, 19190},
	{"KK47", 4, 19191},
	{"KK48", 4, 19192},
	{"KK49", 4, 19193},
	{"KK50", 4, 19194},
	{"KK51", 4, 19195},
	{"KK52", 4, 19196},
	{"KK53", 4, 19197},
	{"KK54", 4, 19198},
	{"KK55", 4, 19199},
	{"KK56", 4, 19200},
	{"KK57", 4, 19201},
	{"KK58", 4, 19202},
	{"KK59", 4, 19203},
	{"KK60", 4, 19204},
	{"KK61", 4, 19205},
	{"KK62", 4, 19206},
	{"KK63", 4, 19207},
	{"KK64", 4, 19208},
	{"KK65", 4, 19209},
	{"KK66", 4, 19210},
	{"KK67", 4, 19211},
	{"KK68", 4, 19212},
	{"KK69", 4, 19213},
	{"KK70", 4, 19214},
	{"KK71", 4, 19215},
	{"KK72", 4, 19216},
	{"KK73", 4, 19217},
	{"KK74", 4, 19218},
	{"KK75", 4, 19219},
	{"KK76", 4, 19220},
	{"KK77", 4, 19221},
	{"KK78", 4, 19222},
	{"KK79", 4, 19223},
	{"KK80", 4, 19224},
	{"KK81", 4, 19225},
	{"KK82", 4, 19226},
	{"KK83", 4, 19227},
	{"KK84", 4, 19228},
	{"KK85", 4, 19229},
	{"KK86", 4, 19230},
	{"KK87", 4, 19231},
	{"KK88", 4, 19232},
	{"KK89", 4, 19233},
	{"KK90", 4, 19234},
	{"KK91", 4, 19235},
	{"KK92", 4, 19236},
	{"KK93", 4, 19237},
	{"KK94", 4, 19238},
	{"KK95", 4, 19239},
	{"KK96", 4, 19240},
	{"KK97", 4, 19241},
	{"KK98", 4, 19242},
	{"KK99", 4, 19243},
	{"KL00", 4, 19244},
	{"KL01", 4, 19245},
	{"KL02", 4, 19246},
	{"KL03", 4, 19247},
	{"KL04", 4, 19248},
	{"KL05", 4, 19249},
	{"KL06", 4, 19250},
	{"KL07", 4, 19251},
	{"KL08", 4, 19252},
	{"KL09", 4, 19253},
	{"KL10", 4, 19254},
	{"KL11", 4, 19255},
	{"KL12", 4, 19256},
	{"KL13", 4, 19257},
	{"KL14", 4, 19258},
	{"KL15", 4, 19259},
	{"KL16", 4, 19260},
	{"KL17", 4, 19261},
	{"KL18", 4, 19262},
	{"KL19", 4, 19263},
	{"KL20", 4, 19264},
	{"KL21", 4, 19265},
	{"KL22", 4, 19266},
	{"KL23", 4, 19267},
	{"KL24", 4, 19268},
	{"KL25", 4, 19269},
	{"KL26", 4, 19270},
	{"KL27", 4, 19271},
	{"KL28", 4, 19272},
	{"KL29", 4, 19273},
	{"KL30", 4, 19274},
	{"KL31", 4, 19275},
	{"KL32", 4, 19276},
	{"KL33", 4, 19277},
	{"KL34", 4, 19278},
	{"KL35", 4, 19279},
	{"KL36", 4, 19280},
	{"KL37", 4, 19281},
	{"KL38", 4, 19282},
	{"KL39", 4, 19283},
	{"KL40", 4, 19284},
	{"KL41", 4, 19285},
	{"KL42", 4, 19286},
	{"KL43", 4, 19287},
	{"KL44", 4, 19288},
	{"KL45", 4, 19289},
	{"KL46", 4, 19290},
	{"KL47", 4, 19291},
	{"KL48", 4, 19292},
	{"KL49", 4, 19293},
	{"KL50", 4, 19294},
	{"KL51", 4, 19295},
	{"KL52", 4, 19296},
	{"KL53", 4, 19297},
	{"KL54", 4, 19298},
	{"KL55", 4, 19299},
	{"KL56", 4, 19300},
	{"KL57", 4, 19301},
	{"KL58", 4, 19302},
	{"KL59", 4, 19303},
	{"KL60", 4, 19304},
	{"KL61", 4, 19305},
	{"KL62", 4, 19306},
	{"KL63", 4, 19307},
	{"KL64", 4, 19308},
	{"KL65", 4, 19309},
	{"KL66", 4, 19310},
	{"KL67", 4, 19311},
	{"KL68", 4, 19312},
	{"KL69", 4, 19313},
	{"KL70", 4, 19314},
	{"KL71", 4, 19315},
	{"KL72", 4, 19316},
	{"KL73", 4, 19317},
	{"KL74", 4, 19318},
	{"KL75", 4, 19319},
	{"KL76", 4, 19320},
	{"KL77", 4, 19321},
	{"KL78", 4, 19322},
	{"KL79", 4, 19323},
	{"KL80", 4, 19324},
	{"KL81", 4, 19325},
	{"KL82", 4, 19326},
	{"KL83", 4, 19327},
	{"KL84", 4, 19328},
	{"KL85", 4, 19329},
	{"KL86", 4, 19330},
	{"KL87", 4, 19331},
	{"KL88", 4, 19332},
	{"KL89", 4, 19333},
	{"KL90", 4, 19334},
	{"KL91", 4, 19335},
	{"KL92", 4, 19336},
	{"KL93", 4, 19337},
	{"KL94", 4, 19338},
	{"KL95", 4, 19339},
	{"KL96", 4, 19340},
	{"KL97", 4, 19341},
	{"KL98", 4, 19342},
	{"KL99", 4, 19343},
	{"KM00", 4, 19344},
	{"KM01", 4, 19345},
	{"KM02", 4, 19346},
	{"KM03", 4, 19347},
	{"KM04", 4, 19348},
	{"KM05", 4, 19349},
	{"KM06", 4, 19350},
	{"KM07", 4, 19351},
	{"KM08", 4, 19352},
	{"KM09", 4, 19353},
	{"KM10", 4, 19354},
	{"KM11", 4, 19355},
	{"KM12", 4, 19356},
	{"KM13", 4, 19357},
	{"KM14", 4, 19358},
	{"KM15", 4, 19359},
	{"KM16", 4, 19360},
	{"KM17", 4, 19361},
	{"KM18", 4, 19362},
	{"KM19", 4, 19363},
	{"KM20", 4, 19364},
	{"KM21", 4, 19365},
	{"KM22", 4, 19366},
	{"KM23", 4, 19367},
	{"KM24", 4, 19368},
	{"KM25", 4, 19369},
	{"KM26", 4, 19370},
	{"KM27", 4, 19371},
	{"KM28", 4, 19372},
	{"KM29", 4, 19373},
	{"KM30", 4, 19374},
	{"KM31", 4, 19375},
	{"KM32", 4, 19376},
	{"KM33", 4, 19377},
	{"KM34", 4, 19378},
	{"KM35", 4, 19379},
	{"KM36", 4, 19380},
	{"KM37", 4, 19381},
	{"KM38", 4, 19382},
	{"KM39", 4, 19383},
	{"KM40", 4, 19384},
	{"KM41", 4, 19385},
	{"KM42", 4, 19386},
	{"KM43", 4, 19387},
	{"KM44", 4, 19388},
	{"KM45", 4, 19389},
	{"KM46", 4, 19390},
	{"KM47", 4, 19391},
	{"KM48", 4, 19392},
	{"KM49", 4, 19393},
	{"KM50", 4, 19394},
	{"KM51", 4, 19395},
	{"KM52", 4, 19396},
	{"KM53", 4, 19397},
	{"KM54", 4, 19398},
	{"KM55", 4, 19399},
	{"KM56", 4, 19400},
	{"KM57", 4, 19401},
	{"KM58", 4, 19402},
	{"KM59", 4, 19403},
	{"KM60", 4, 19404},
	{"KM61", 4, 19405},
	{"KM62", 4, 19406},
	{"KM63", 4, 19407},
	{"KM64", 4, 19408},
	{"KM65", 4, 19409},
	{"KM66", 4, 19410},
	{"KM67", 4, 19411},
	{"KM68", 4, 19412},
	{"KM69", 4, 19413},
	{"KM70", 4, 19414},
	{"KM71", 4, 19415},
	{"KM72", 4, 19416},
	{"KM73", 4, 19417},
	{"KM74", 4, 19418},
	{"KM75", 4, 19419},
	{"KM76", 4, 19420},
	{"KM77", 4, 19421},
	{"KM78", 4, 19422},
	{"KM79", 4, 19423},
	{"KM80", 4, 19424},
	{"KM81", 4, 19425},
	{"KM82", 4, 19426},
	{"KM83", 4, 19427},
	{"KM84", 4, 19428},
	{"KM85", 4, 19429},
	{"KM86", 4, 19430},
	{"KM87", 4, 19431},
	{"KM88", 4, 19432},
	{"KM89", 4, 19433},
	{"KM90", 4, 19434},
	{"KM91", 4, 19435},
	{"KM92", 4, 19436},
	{"KM93", 4, 19437},
	{"KM94", 4, 19438},
	{"KM95", 4, 19439},
	{"KM96", 4, 19440},
	{"KM97", 4, 19441},
	{"KM98", 4, 19442},
	{"KM99", 4, 19443},
	{"KN00", 4, 19444},
	{"KN01", 4, 19445},
	{"KN02", 4, 19446},
	{"KN03", 4, 19447},
	{"KN04", 4, 19448},
	{"KN05", 4, 19449},
	{"KN06", 4, 19450},
	{"KN07", 4, 19451},
	{"KN08", 4, 19452},
	{"KN09", 4, 19453},
	{"KN10", 4, 19454},
	{"KN11", 4, 19455},
	{"KN12", 4, 19456},
	{"KN13", 4, 19457},
	{"KN14", 4, 19458},
	{"KN15", 4, 19459},
	{"KN16", 4, 19460},
	{"KN17", 4, 19461},
	{"KN18", 4, 19462},
	{"KN19", 4, 19463},
	{"KN20", 4, 19464},
	{"KN21", 4, 19465},
	{"KN22", 4, 19466},
	{"KN23", 4, 19467},
	{"KN24", 4, 19468},
	{"KN25", 4, 19469},
	{"KN26", 4, 19470},
	{"KN27", 4, 19471},
	{"KN28", 4, 19472},
	{"KN29", 4, 19473},
	{"KN30", 4, 19474},
	{"KN31", 4, 19475},
	{"KN32", 4, 19476},
	{"KN33", 4, 19477},
	{"KN34", 4, 19478},
	{"KN35", 4, 19479},
	{"KN36", 4, 19480},
	{"KN37", 4, 19481},
	{"KN38", 4, 19482},
	{"KN39", 4, 19483},
	{"KN40", 4, 19484},
	{"KN41", 4, 19485},
	{"KN42", 4, 19486},
	{"KN43", 4, 19487},
	{"KN44", 4, 19488},
	{"KN45", 4, 19489},
	{"KN46", 4, 19490},
	{"KN47", 4, 19491},
	{"KN48", 4, 19492},
	{"KN49", 4, 19493},
	{"KN50", 4, 19494},
	{"KN51", 4, 19495},
	{"KN52", 4, 19496},
	{"KN53", 4, 19497},
	{"KN54", 4, 19498},
	{"KN55", 4, 19499},
	{"KN56", 4, 19500},
	{"KN57", 4, 19501},
	{"KN58", 4, 19502},
	{"KN59", 4, 19503},
	{"KN60", 4, 19504},
	{"KN61", 4, 19505},
	{"KN62", 4, 19506},
	{"KN63", 4, 19507},
	{"KN64", 4, 19508},
	{"KN65", 4, 19509},
	{"KN66", 4, 19510},
	{"KN67", 4, 19511},
	{"KN68", 4, 19512},
	{"KN69", 4, 19513},
	{"KN70", 4, 19514},
	{"KN71", 4, 19515},
	{"KN72", 4, 19516},
	{"KN73", 4, 19517},
	{"KN74", 4, 19518},
	{"KN75", 4, 19519},
	{"KN76", 4, 19520},
	{"KN77", 4, 19521},
	{"KN78", 4, 19522},
	{"KN79", 4, 19523},
	{"KN80", 4, 19524},
	{"KN81", 4, 19525},
	{"KN82", 4, 19526},
	{"KN83", 4, 19527},
	{"KN84", 4, 19528},
	{"KN85", 4, 19529},
	{"KN86", 4, 19530},
	{"KN87", 4, 19531},
	{"KN88", 4, 19532},
	{"KN89", 4, 19533},
	{"KN90", 4, 19534},
	{"KN91", 4, 19535},
	{"KN92", 4, 19536},
	{"KN93", 4, 19537},
	{"KN94", 4, 19538},
	{"KN95", 4, 19539},
	{"KN96", 4, 19540},
	{"KN97", 4, 19541},
	{"KN98", 4, 19542},
	{"KN99", 4, 19543},
	{"KO00", 4, 19544},
	{"KO01", 4, 19545},
	{"KO02", 4, 19546},
	{"KO03", 4, 19547},
	{"KO04", 4, 19548},
	{"KO05", 4, 19549},
	{"KO06", 4, 19550},
	{"KO07", 4, 19551},
	{"KO08", 4, 19552},
	{"KO09", 4, 19553},
	{"KO10", 4, 19554},
	{"KO11", 4, 19555},
	{"KO12", 4, 19556},
	{"KO13", 4, 19557},
	{"KO14", 4, 19558},
	{"KO15", 4, 19559},
	{"KO16", 4, 19560},
	{"KO17", 4, 19561},
	{"KO18", 4, 19562},
	{"KO19", 4, 19563},
	{"KO20", 4, 19564},
	{"KO21", 4, 19565},
	{"KO22", 4, 19566},
	{"KO23", 4, 19567},
	{"KO24", 4, 19568},
	{"KO25", 4, 19569},
	{"KO26", 4, 19570},
	{"KO27", 4, 19571},
	{"KO28", 4, 19572},
	{"KO29", 4, 19573},
	{"KO30", 4, 19574},
	{"KO31", 4, 19575},
	{"KO32", 4, 19576},
	{"KO33", 4, 19577},
	{"KO34", 4, 19578},
	{"KO35", 4, 19579},
	{"KO36", 4, 19580},
	{"KO37", 4, 19581},
	{"KO38", 4, 19582},
	{"KO39", 4, 19583},
	{"KO40", 4, 19584},
	{"KO41", 4, 19585},
	{"KO42", 4, 19586},
	{"KO43", 4, 19587},
	{"KO44", 4, 19588},
	{"KO45", 4, 19589},
	{"KO46", 4, 19590},
	{"KO47", 4, 19591},
	{"KO48", 4, 19592},
	{"KO49", 4, 19593},
	{"KO50", 4, 19594},
	{"KO51", 4, 19595},
	{"KO52", 4, 19596},
	{"KO53", 4, 19597},
	{"KO54", 4, 19598},
	{"KO55", 4, 19599},
	{"KO56", 4, 19600},
	{"KO57", 4, 19601},
	{"KO58", 4, 19602},
	{"KO59", 4, 19603},
	{"KO60", 4, 19604},
	{"KO61", 4, 19605},
	{"KO62", 4, 19606},
	{"KO63", 4, 19607},
	{"KO64", 4, 19608},
	{"KO65", 4, 19609},
	{"KO66", 4, 19610},
	{"KO67", 4, 19611},
	{"KO68", 4, 19612},
	{"KO69", 4, 19613},
	{"KO70", 4, 19614},
	{"KO71", 4, 19615},
	{"KO72", 4, 19616},
	{"KO73", 4, 19617},
	{"KO74", 4, 19618},
	{"KO75", 4, 19619},
	{"KO76", 4, 19620},
	{"KO77", 4, 19621},
	{"KO78", 4, 19622},
	{"KO79", 4, 19623},
	{"KO80", 4, 19624},
	{"KO81", 4, 19625},
	{"KO82", 4, 19626},
	{"KO83", 4, 19627},
	{"KO84", 4, 19628},
	{"KO85", 4, 19629},
	{"KO86", 4, 19630},
	{"KO87", 4, 19631},
	{"KO88", 4, 19632},
	{"KO89", 4, 19633},
	{"KO90", 4, 19634},
	{"KO91", 4, 19635},
	{"KO92", 4, 19636},
	{"KO93", 4, 19637},
	{"KO94", 4, 19638},
	{"KO95", 4, 19639},
	{"KO96", 4, 19640},
	{"KO97", 4, 19641},
	{"KO98", 4, 19642},
	{"KO99", 4, 19643},
	{"KP00", 4, 19644},
	{"KP01", 4, 19645},
	{"KP02", 4, 19646},
	{"KP03", 4, 19647},
	{"KP04", 4, 19648},
	{"KP05", 4, 19649},
	{"KP06", 4, 19650},
	{"KP07", 4, 19651},
	{"KP08", 4, 19652},
	{"KP09", 4, 19653},
	{"KP10", 4, 19654},
	{"KP11", 4, 19655},
	{"KP12", 4, 19656},
	{"KP13", 4, 19657},
	{"KP14", 4, 19658},
	{"KP15", 4, 19659},
	{"KP16", 4, 19660},
	{"KP17", 4, 19661},
	{"KP18", 4, 19662},
	{"KP19", 4, 19663},
	{"KP20", 4, 19664},
	{"KP21", 4, 19665},
	{"KP22", 4, 19666},
	{"KP23", 4, 19667},
	{"KP24", 4, 19668},
	{"KP25", 4, 19669},
	{"KP26", 4, 19670},
	{"KP27", 4, 19671},
	{"KP28", 4, 19672},
	{"KP29", 4, 19673},
	{"KP30", 4, 19674},
	{"KP31", 4, 19675},
	{"KP32", 4, 19676},
	{"KP33", 4, 19677},
	{"KP34", 4, 19678},
	{"KP35", 4, 19679},
	{"KP36", 4, 19680},
	{"KP37", 4, 19681},
	{"KP38", 4, 19682},
	{"KP39", 4, 19683},
	{"KP40", 4, 19684},
	{"KP41", 4, 19685},
	{"KP42", 4, 19686},
	{"KP43", 4, 19687},
	{"KP44", 4, 19688},
	{"KP45", 4, 19689},
	{"KP46", 4, 19690},
	{"KP47", 4, 19691},
	{"KP48", 4, 19692},
	{"KP49", 4, 19693},
	{"KP50", 4, 19694},
	{"KP51", 4, 19695},
	{"KP52", 4, 19696},
	{"KP53", 4, 19697},
	{"KP54", 4, 19698},
	{"KP55", 4, 19699},
	{"KP56", 4, 19700},
	{"KP57", 4, 19701},
	{"KP58", 4, 19702},
	{"KP59", 4, 19703},
	{"KP60", 4, 19704},
	{"KP61", 4, 19705},
	{"KP62", 4, 19706},
	{"KP63", 4, 19707},
	{"KP64", 4, 19708},
	{"KP65", 4, 19709},
	{"KP66", 4, 19710},
	{"KP67", 4, 19711},
	{"KP68", 4, 19712},
	{"KP69", 4, 19713},
	{"KP70", 4, 19714},
	{"KP71", 4, 19715},
	{"KP72", 4, 19716},
	{"KP73", 4, 19717},
	{"KP74", 4, 19718},
	{"KP75", 4, 19719},
	{"KP76", 4, 19720},
	{"KP77", 4, 19721},
	{"KP78", 4, 19722},
	{"KP79", 4, 19723},
	{"KP80", 4, 19724},
	{"KP81", 4, 19725},
	{"KP82", 4, 19726},
	{"KP83", 4, 19727},
	{"KP84", 4, 19728},
	{"KP85", 4, 19729},
	{"KP86", 4, 19730},
	{"KP87", 4, 19731},
	{"KP88", 4, 19732},
	{"KP89", 4, 19733},
	{"KP90", 4, 19734},
	{"KP91", 4, 19735},
	{"KP92", 4, 19736},
	{"KP93", 4, 19737},
	{"KP94", 4, 19738},
	{"KP95", 4, 19739},
	{"KP96", 4, 19740},
	{"KP97", 4, 19741},
	{"KP98", 4, 19742},
	{"KP99", 4, 19743},
	{"KQ00", 4, 19744},
	{"KQ01", 4, 19745},
	{"KQ02", 4, 19746},
	{"KQ03", 4, 19747},
	{"KQ04", 4, 19748},
	{"KQ05", 4, 19749},
	{"KQ06", 4, 19750},
	{"KQ07", 4, 19751},
	{"KQ08", 4, 19752},
	{"KQ09", 4, 19753},
	{"KQ10", 4, 19754},
	{"KQ11", 4, 19755},
	{"KQ12", 4, 19756},
	{"KQ13", 4, 19757},
	{"KQ14", 4, 19758},
	{"KQ15", 4, 19759},
	{"KQ16", 4, 19760},
	{"KQ17", 4, 19761},
	{"KQ18", 4, 19762},
	{"KQ19", 4, 19763},
	{"KQ20", 4, 19764},
	{"KQ21", 4, 19765},
	{"KQ22", 4, 19766},
	{"KQ23", 4, 19767},
	{"KQ24", 4, 19768},
	{"KQ25", 4, 19769},
	{"KQ26", 4, 19770},
	{"KQ27", 4, 19771},
	{"KQ28", 4, 19772},
	{"KQ29", 4, 19773},
	{"KQ30", 4, 19774},
	{"KQ31", 4, 19775},
	{"KQ32", 4, 19776},
	{"KQ33", 4, 19777},
	{"KQ34", 4, 19778},
	{"KQ35", 4, 19779},
	{"KQ36", 4, 19780},
	{"KQ37", 4, 19781},
	{"KQ38", 4, 19782},
	{"KQ39", 4, 19783},
	{"KQ40", 4, 19784},
	{"KQ41", 4, 19785},
	{"KQ42", 4, 19786},
	{"KQ43", 4, 19787},
	{"KQ44", 4, 19788},
	{"KQ45", 4, 19789},
	{"KQ46", 4, 19790},
	{"KQ47", 4, 19791},
	{"KQ48", 4, 19792},
	{"KQ49", 4, 19793},
	{"KQ50", 4, 19794},
	{"KQ51", 4, 19795},
	{"KQ52", 4, 19796},
	{"KQ53", 4, 19797},
	{"KQ54", 4, 19798},
	{"KQ55", 4, 19799},
	{"KQ56", 4, 19800},
	{"KQ57", 4, 19801},
	{"KQ58", 4, 19802},
	{"KQ59", 4, 19803},
	{"KQ60", 4, 19804},
	{"KQ61", 4, 19805},
	{"KQ62", 4, 19806},
	{"KQ63", 4, 19807},
	{"KQ64", 4, 19808},
	{"KQ65", 4, 19809},
	{"KQ66", 4, 19810},
	{"KQ67", 4, 19811},
	{"KQ68", 4, 19812},
	{"KQ69", 4, 19813},
	{"KQ70", 4, 19814},
	{"KQ71", 4, 19815},
	{"KQ72", 4, 19816},
	{"KQ73", 4, 19817},
	{"KQ74", 4, 19818},
	{"KQ75", 4, 19819},
	{"KQ76", 4, 19820},
	{"KQ77", 4, 19821},
	{"KQ78", 4, 19822},
	{"KQ79", 4, 19823},
	{"KQ80", 4, 19824},
	{"KQ81", 4, 19825},
	{"KQ82", 4, 19826},
	{"KQ83", 4, 19827},
	{"KQ84", 4, 19828},
	{"KQ85", 4, 19829},
	{"KQ86", 4, 19830},
	{"KQ87", 4, 19831},
	{"KQ88", 4, 19832},
	{"KQ89", 4, 19833},
	{"KQ90", 4, 19834},
	{"KQ91", 4, 19835},
	{"KQ92", 4, 19836},
	{"KQ93", 4, 19837},
	{"KQ94", 4, 19838},
	{"KQ95", 4, 19839},
	{"KQ96", 4, 19840},
	{"KQ97", 4, 19841},
	{"KQ98", 4, 19842},
	{"KQ99", 4, 19843},
	{"LB00", 4, 19844},
	{"LB01", 4, 19845},
	{"LB02", 4, 19846},
	{"LB03", 4, 19847},
	{"LB04", 4, 19848},
	{"LB05", 4, 19849},
	{"LB06", 4, 19850},
	{"LB07", 4, 19851},
	{"LB08", 4, 19852},
	{"LB09", 4, 19853},
	{"LB10", 4, 19854},
	{"LB11", 4, 19855},
	{"LB12", 4, 19856},
	{"LB13", 4, 19857},
	{"LB14", 4, 19858},
	{"LB15", 4, 19859},
	{"LB16", 4, 19860},
	{"LB17", 4, 19861},
	{"LB18", 4, 19862},
	{"LB19", 4, 19863},
	{"LB20", 4, 19864},
	{"LB21", 4, 19865},
	{"LB22", 4, 19866},
	{"LB23", 4, 19867},
	{"LB24", 4, 19868},
	{"LB25", 4, 19869},
	{"LB26", 4, 19870},
	{"LB27", 4, 19871},
	{"LB28", 4, 19872},
	{"LB29", 4, 19873},
	{"LB30", 4, 19874},
	{"LB31", 4, 19875},
	{"LB32", 4, 19876},
	{"LB33", 4, 19877},
	{"LB34", 4, 19878},
	{"LB35", 4, 19879},
	{"LB36", 4, 19880},
	{"LB37", 4, 19881},
	{"LB38", 4, 19882},
	{"LB39", 4, 19883},
	{"LB40", 4, 19884},
	{"LB41", 4, 19885},
	{"LB42", 4, 19886},
	{"LB43", 4, 19887},
	{"LB44", 4, 19888},
	{"LB45", 4, 19889},
	{"LB46", 4, 19890},
	{"LB47", 4, 19891},
	{"LB48", 4, 19892},
	{"LB49", 4, 19893},
	{"LB50", 4, 19894},
	{"LB51", 4, 19895},
	{"LB52", 4, 19896},
	{"LB53", 4, 19897},
	{"LB54", 4, 19898},
	{"LB55", 4, 19899},
	{"LB56", 4, 19900},
	{"LB57", 4, 19901},
	{"LB58", 4, 19902},
	{"LB59", 4, 19903},
	{"LB60", 4, 19904},
	{"LB61", 4, 19905},
	{"LB62", 4, 19906},
	{"LB63", 4, 19907},
	{"LB64", 4, 19908},
	{"LB65", 4, 19909},
	{"LB66", 4, 19910},
	{"LB67", 4, 19911},
	{"LB68", 4, 19912},
	{"LB69", 4, 19913},
	{"LB70", 4, 19914},
	{"LB71", 4, 19915},
	{"LB72", 4, 19916},
	{"LB73", 4, 19917},
	{"LB74", 4, 19918},
	{"LB75", 4, 19919},
	{"LB76", 4, 19920},
	{"LB77", 4, 19921},
	{"LB78", 4, 19922},
	{"LB79", 4, 19923},
	{"LB80", 4, 19924},
	{"LB81", 4, 19925},
	{"LB82", 4, 19926},
	{"LB83", 4, 19927},
	{"LB84", 4, 19928},
	{"LB85", 4, 19929},
	{"LB86", 4, 19930},
	{"LB87", 4, 19931},
	{"LB88", 4, 19932},
	{"LB89", 4, 19933},
	{"LB90", 4, 19934},
	{"LB91", 4, 19935},
	{"LB92", 4, 19936},
	{"LB93", 4, 19937},
	{"LB94", 4, 19938},
	{"LB95", 4, 19939},
	{"LB96", 4, 19940},
	{"LB97", 4, 19941},
	{"LB98", 4, 19942},
	{"LB99", 4, 19943},
	{"LC00", 4, 19944},
	{"LC01", 4, 19945},
	{"LC02", 4, 19946},
	{"LC03", 4, 19947},
	{"LC04", 4, 19948},
	{"LC05", 4, 19949},
	{"LC06", 4, 19950},
	{"LC07", 4, 19951},
	{"LC08", 4, 19952},
	{"LC09", 4, 19953},
	{"LC10", 4, 19954},
	{"LC11", 4, 19955},
	{"LC12", 4, 19956},
	{"LC13", 4, 19957},
	{"LC14", 4, 19958},
	{"LC15", 4, 19959},
	{"LC16", 4, 19960},
	{"LC17", 4, 19961},
	{"LC18", 4, 19962},
	{"LC19", 4, 19963},
	{"LC20", 4, 19964},
	{"LC21", 4, 19965},
	{"LC22", 4, 19966},
	{"LC23", 4, 19967},
	{"LC24", 4, 19968},
	{"LC25", 4, 19969},
	{"LC26", 4, 19970},
	{"LC27", 4, 19971},
	{"LC28", 4, 19972},
	{"LC29", 4, 19973},
	{"LC30", 4, 19974},
	{"LC31", 4, 19975},
	{"LC32", 4, 19976},
	{"LC33", 4, 19977},
	{"LC34", 4, 19978},
	{"LC35", 4, 19979},
	{"LC36", 4, 19980},
	{"LC37", 4, 19981},
	{"LC38", 4, 19982},
	{"LC39", 4, 19983},
	{"LC40", 4, 19984},
	{"LC41", 4, 19985},
	{"LC42", 4, 19986},
	{"LC43", 4, 19987},
	{"LC44", 4, 19988},
	{"LC45", 4, 19989},
	{"LC46", 4, 19990},
	{"LC47", 4, 19991},
	{"LC48", 4, 19992},
	{"LC49", 4, 19993},
	{"LC50", 4, 19994},
	{"LC51", 4, 19995},
	{"LC52", 4, 19996},
	{"LC53", 4, 19997},
	{"LC54", 4, 19998},
	{"LC55", 4, 19999},
	{"LC56", 4, 20000},
	{"LC57", 4, 20001},
	{"LC58", 4, 20002},
	{"LC59", 4, 20003},
	{"LC60", 4, 20004},
	{"LC61", 4, 20005},
	{"LC62", 4, 20006},
	{"LC63", 4, 20007},
	{"LC64", 4, 20008},
	{"LC65", 4, 20009},
	{"LC66", 4, 20010},
	{"LC67", 4, 20011},
	{"LC68", 4, 20012},
	{"LC69", 4, 20013},
	{"LC70", 4, 20014},
	{"LC71", 4, 20015},
	{"LC72", 4, 20016},
	{"LC73", 4, 20017},
	{"LC74", 4, 20018},
	{"LC75", 4, 20019},
	{"LC76", 4, 20020},
	{"LC77", 4, 20021},
	{"LC78", 4, 20022},
	{"LC79", 4, 20023},
	{"LC80", 4, 20024},
	{"LC81", 4, 20025},
	{"LC82", 4, 20026},
	{"LC83", 4, 20027},
	{"LC84", 4, 20028},
	{"LC85", 4, 20029},
	{"LC86", 4, 20030},
	{"LC87", 4, 20031},
	{"LC88", 4, 20032},
	{"LC89", 4, 20033},
	{"LC90", 4, 20034},
	{"LC91", 4, 20035},
	{"LC92", 4, 20036},
	{"LC93", 4, 20037},
	{"LC94", 4, 20038},
	{"LC95", 4, 20039},
	{"LC96", 4, 20040},
	{"LC97", 4, 20041},
	{"LC98", 4, 20042},
	{"LC99", 4, 20043},
	{"LG00", 4, 20044},
	{"LG01", 4, 20045},
	{"LG02", 4, 20046},
	{"LG03", 4, 20047},
	{"LG04", 4, 20048},
	{"LG05", 4, 20049},
	{"LG06", 4, 20050},
	{"LG07", 4, 20051},
	{"LG08", 4, 20052},
	{"LG09", 4, 20053},
	{"LG10", 4, 20054},
	{"LG11", 4, 20055},
	{"LG12", 4, 20056},
	{"LG13", 4, 20057},
	{"LG14", 4, 20058},
	{"LG15", 4, 20059},
	{"LG16", 4, 20060},
	{"LG17", 4, 20061},
	{"LG18", 4, 20062},
	{"LG19", 4, 20063},
	{"LG20", 4, 20064},
	{"LG21", 4, 20065},
	{"LG22", 4, 20066},
	{"LG23", 4, 20067},
	{"LG24", 4, 20068},
	{"LG25", 4, 20069},
	{"LG26", 4, 20070},
	{"LG27", 4, 20071},
	{"LG28", 4, 20072},
	{"LG29", 4, 20073},
	{"LG30", 4, 20074},
	{"LG31", 4, 20075},
	{"LG32", 4, 20076},
	{"LG33", 4, 20077},
	{"LG34", 4, 20078},
	{"LG35", 4, 20079},
	{"LG36", 4, 20080},
	{"LG37", 4, 20081},
	{"LG38", 4, 20082},
	{"LG39", 4, 20083},
	{"LG40", 4, 20084},
	{"LG41", 4, 20085},
	{"LG42", 4, 20086},
	{"LG43", 4, 20087},
	{"LG44", 4, 20088},
	{"LG45", 4, 20089},
	{"LG46", 4, 20090},
	{"LG47", 4, 20091},
	{"LG48", 4, 20092},
	{"LG49", 4, 20093},
	{"LG50", 4, 20094},
	{"LG51", 4, 20095},
	{"LG52", 4, 20096},
	{"LG53", 4, 20097},
	{"LG54", 4, 20098},
	{"LG55", 4, 20099},
	{"LG56", 4, 20100},
	{"LG57", 4, 20101},
	{"LG58", 4, 20102},
	{"LG59", 4, 20103},
	{"LG60", 4, 20104},
	{"LG61", 4, 20105},
	{"LG62", 4, 20106},
	{"LG63", 4, 20107},
	{"LG64", 4, 20108},
	{"LG65", 4, 20109},
	{"LG66", 4, 20110},
	{"LG67", 4, 20111},
	{"LG68", 4, 20112},
	{"LG69", 4, 20113},
	{"LG70", 4, 20114},
	{"LG71", 4, 20115},
	{"LG72", 4, 20116},
	{"LG73", 4, 20117},
	{"LG74", 4, 20118},
	{"LG75", 4, 20119},
	{"LG76", 4, 20120},
	{"LG77", 4, 20121},
	{"LG78", 4, 20122},
	{"LG79", 4, 20123},
	{"LG80", 4, 20124},
	{"LG81", 4, 20125},
	{"LG82", 4, 20126},
	{"LG83", 4, 20127},
	{"LG84", 4, 20128},
	{"LG85", 4, 20129},
	{"LG86", 4, 20130},
	{"LG87", 4, 20131},
	{"LG88", 4, 20132},
	{"LG89", 4, 20133},
	{"LG90", 4, 20134},
	{"LG91", 4, 20135},
	{"LG92", 4, 20136},
	{"LG93", 4, 20137},
	{"LG94", 4, 20138},
	{"LG95", 4, 20139},
	{"LG96", 4, 20140},
	{"LG97", 4, 20141},
	{"LG98", 4, 20142},
	{"LG99", 4, 20143},
	{"LH00", 4, 20144},
	{"LH01", 4, 20145},
	{"LH02", 4, 20146},
	{"LH03", 4, 20147},
	{"LH04", 4, 20148},
	{"LH05", 4, 20149},
	{"LH06", 4, 20150},
	{"LH07", 4, 20151},
	{"LH08", 4, 20152},
	{"LH09", 4, 20153},
	{"LH10", 4, 20154},
	{"LH11", 4, 20155},
	{"LH12", 4, 20156},
	{"LH13", 4, 20157},
	{"LH14", 4, 20158},
	{"LH15", 4, 20159},
	{"LH16", 4, 20160},
	{"LH17", 4, 20161},
	{"LH18", 4, 20162},
	{"LH19", 4, 20163},
	{"LH20", 4, 20164},
	{"LH21", 4, 20165},
	{"LH22", 4, 20166},
	{"LH23", 4, 20167},
	{"LH24", 4, 20168},
	{"LH25", 4, 20169},
	{"LH26", 4, 20170},
	{"LH27", 4, 20171},
	{"LH28", 4, 20172},
	{"LH29", 4, 20173},
	{"LH30", 4, 20174},
	{"LH31", 4, 20175},
	{"LH32", 4, 20176},
	{"LH33", 4, 20177},
	{"LH34", 4, 20178},
	{"LH35", 4, 20179},
	{"LH36", 4, 20180},
	{"LH37", 4, 20181},
	{"LH38", 4, 20182},
	{"LH39", 4, 20183},
	{"LH40", 4, 20184},
	{"LH41", 4, 20185},
	{"LH42", 4, 20186},
	{"LH43", 4, 20187},
	{"LH44", 4, 20188},
	{"LH45", 4, 20189},
	{"LH46", 4, 20190},
	{"LH47", 4, 20191},
	{"LH48", 4, 20192},
	{"LH49", 4, 20193},
	{"LH50", 4, 20194},
	{"LH51", 4, 20195},
	{"LH52", 4, 20196},
	{"LH53", 4, 20197},
	{"LH54", 4, 20198},
	{"LH55", 4, 20199},
	{"LH56", 4, 20200},
	{"LH57", 4, 20201},
	{"LH58", 4, 20202},
	{"LH59", 4, 20203},
	{"LH60", 4, 20204},
	{"LH61", 4, 20205},
	{"LH62", 4, 20206},
	{"LH63", 4, 20207},
	{"LH64", 4, 20208},
	{"LH65", 4, 20209},
	{"LH66", 4, 20210},
	{"LH67", 4, 20211},
	{"LH68", 4, 20212},
	{"LH69", 4, 20213},
	{"LH70", 4, 20214},
	{"LH71", 4, 20215},
	{"LH72", 4, 20216},
	{"LH73", 4, 20217},
	{"LH74", 4, 20218},
	{"LH75", 4, 20219},
	{"LH76", 4, 20220},
	{"LH77", 4, 20221},
	{"LH78", 4, 20222},
	{"LH79", 4, 20223},
	{"LH80", 4, 20224},
	{"LH81", 4, 20225},
	{"LH82", 4, 20226},
	{"LH83", 4, 20227},
	{"LH84", 4, 20228},
	{"LH85", 4, 20229},
	{"LH86", 4, 20230},
	{"LH87", 4, 20231},
	{"LH88", 4, 20232},
	{"LH89", 4, 20233},
	{"LH90", 4, 20234},
	{"LH91", 4, 20235},
	{"LH92", 4, 20236},
	{"LH93", 4, 20237},
	{"LH94", 4, 20238},
	{"LH95", 4, 20239},
	{"LH96", 4, 20240},
	{"LH97", 4, 20241},
	{"LH98", 4, 20242},
	{"LH99", 4, 20243},
	{"LI00", 4, 20244},
	{"LI01", 4, 20245},
	{"LI02", 4, 20246},
	{"LI03", 4, 20247},
	{"LI04", 4, 20248},
	{"LI05", 4, 20249},
	{"LI06", 4, 20250},
	{"LI07", 4, 20251},
	{"LI08", 4, 20252},
	{"LI09", 4, 20253},
	{"LI10", 4, 20254},
	{"LI11", 4, 20255},
	{"LI12", 4, 20256},
	{"LI13", 4, 20257},
	{"LI14", 4, 20258},
	{"LI15", 4, 20259},
	{"LI16", 4, 20260},
	{"LI17", 4, 20261},
	{"LI18", 4, 20262},
	{"LI19", 4, 20263},
	{"LI20", 4, 20264},
	{"LI21", 4, 20265},
	{"LI22", 4, 20266},
	{"LI23", 4, 20267},
	{"LI24", 4, 20268},
	{"LI25", 4, 20269},
	{"LI26", 4, 20270},
	{"LI27", 4, 20271},
	{"LI28", 4, 20272},
	{"LI29", 4, 20273},
	{"LI30", 4, 20274},
	{"LI31", 4, 20275},
	{"LI32", 4, 20276},
	{"LI33", 4, 20277},
	{"LI34", 4, 20278},
	{"LI35", 4, 20279},
	{"LI36", 4, 20280},
	{"LI37", 4, 20281},
	{"LI38", 4, 20282},
	{"LI39", 4, 20283},
	{"LI40", 4, 20284},
	{"LI41", 4, 20285},
	{"LI42", 4, 20286},
	{"LI43", 4, 20287},
	{"LI44", 4, 20288},
	{"LI45", 4, 20289},
	{"LI46", 4, 20290},
	{"LI47", 4, 20291},
	{"LI48", 4, 20292},
	{"LI49", 4, 20293},
	{"LI50", 4, 20294},
	{"LI51", 4, 20295},
	{"LI52", 4, 20296},
	{"LI53", 4, 20297},
	{"LI54", 4, 20298},
	{"LI55", 4, 20299},
	{"LI56", 4, 20300},
	{"LI57", 4, 20301},
	{"LI58", 4, 20302},
	{"LI59", 4, 20303},
	{"LI60", 4, 20304},
	{"LI61", 4, 20305},
	{"LI62", 4, 20306},
	{"LI63", 4, 20307},
	{"LI64", 4, 20308},
	{"LI65", 4, 20309},
	{"LI66", 4, 20310},
	{"LI67", 4, 20311},
	{"LI68", 4, 20312},
	{"LI69", 4, 20313},
	{"LI70", 4, 20314},
	{"LI71", 4, 20315},
	{"LI72", 4, 20316},
	{"LI73", 4, 20317},
	{"LI74", 4, 20318},
	{"LI75", 4, 20319},
	{"LI76", 4, 20320},
	{"LI77", 4, 20321},
	{"LI78", 4, 20322},
	{"LI79", 4, 20323},
	{"LI80", 4, 20324},
	{"LI81", 4, 20325},
	{"LI82", 4, 20326},
	{"LI83", 4, 20327},
	{"LI84", 4, 20328},
	{"LI85", 4, 20329},
	{"LI86", 4, 20330},
	{"LI87", 4, 20331},
	{"LI88", 4, 20332},
	{"LI89", 4, 20333},
	{"LI90", 4, 20334},
	{"LI91", 4, 20335},
	{"LI92", 4, 20336},
	{"LI93", 4, 20337},
	{"LI94", 4, 20338},
	{"LI95", 4, 20339},
	{"LI96", 4, 20340},
	{"LI97", 4, 20341},
	{"LI98", 4, 20342},
	{"LI99", 4, 20343},
	{"LJ00", 4, 20344},
	{"LJ01", 4, 20345},
	{"LJ02", 4, 20346},
	{"LJ03", 4, 20347},
	{"LJ04", 4, 20348},
	{"LJ05", 4, 20349},
	{"LJ06", 4, 20350},
	{"LJ07", 4, 20351},
	{"LJ08", 4, 20352},
	{"LJ09", 4, 20353},
	{"LJ10", 4, 20354},
	{"LJ11", 4, 20355},
	{"LJ12", 4, 20356},
	{"LJ13", 4, 20357},
	{"LJ14", 4, 20358},
	{"LJ15", 4, 20359},
	{"LJ16", 4, 20360},
	{"LJ17", 4, 20361},
	{"LJ18", 4, 20362},
	{"LJ19", 4, 20363},
	{"LJ20", 4, 20364},
	{"LJ21", 4, 20365},
	{"LJ22", 4, 20366},
	{"LJ23", 4, 20367},
	{"LJ24", 4, 20368},
	{"LJ25", 4, 20369},
	{"LJ26", 4, 20370},
	{"LJ27", 4, 20371},
	{"LJ28", 4, 20372},
	{"LJ29", 4, 20373},
	{"LJ30", 4, 20374},
	{"LJ31", 4, 20375},
	{"LJ32", 4, 20376},
	{"LJ33", 4, 20377},
	{"LJ34", 4, 20378},
	{"LJ35", 4, 20379},
	{"LJ36", 4, 20380},
	{"LJ37", 4, 20381},
	{"LJ38", 4, 20382},
	{"LJ39", 4, 20383},
	{"LJ40", 4, 20384},
	{"LJ41", 4, 20385},
	{"LJ42", 4, 20386},
	{"LJ43", 4, 20387},
	{"LJ44", 4, 20388},
	{"LJ45", 4, 20389},
	{"LJ46", 4, 20390},
	{"LJ47", 4, 20391},
	{"LJ48", 4, 20392},
	{"LJ49", 4, 20393},
	{"LJ50", 4, 20394},
	{"LJ51", 4, 20395},
	{"LJ52", 4, 20396},
	{"LJ53", 4, 20397},
	{"LJ54", 4, 20398},
	{"LJ55", 4, 20399},
	{"LJ56", 4, 20400},
	{"LJ57", 4, 20401},
	{"LJ58", 4, 20402},
	{"LJ59", 4, 20403},
	{"LJ60", 4, 20404},
	{"LJ61", 4, 20405},
	{"LJ62", 4, 20406},
	{"LJ63", 4, 20407},
	{"LJ64", 4, 20408},
	{"LJ65", 4, 20409},
	{"LJ66", 4, 20410},
	{"LJ67", 4, 20411},
	{"LJ68", 4, 20412},
	{"LJ69", 4, 20413},
	{"LJ70", 4, 20414},
	{"LJ71", 4, 20415},
	{"LJ72", 4, 20416},
	{"LJ73", 4, 20417},
	{"LJ74", 4, 20418},
	{"LJ75", 4, 20419},
	{"LJ76", 4, 20420},
	{"LJ77", 4, 20421},
	{"LJ78", 4, 20422},
	{"LJ79", 4, 20423},
	{"LJ80", 4, 20424},
	{"LJ81", 4, 20425},
	{"LJ82", 4, 20426},
	{"LJ83", 4, 20427},
	{"LJ84", 4, 20428},
	{"LJ85", 4, 20429},
	{"LJ86", 4, 20430},
	{"LJ87", 4, 20431},
	{"LJ88", 4, 20432},
	{"LJ89", 4, 20433},
	{"LJ90", 4, 20434},
	{"LJ91", 4, 20435},
	{"LJ92", 4, 20436},
	{"LJ93", 4, 20437},
	{"LJ94", 4, 20438},
	{"LJ95", 4, 20439},
	{"LJ96", 4, 20440},
	{"LJ97", 4, 20441},
	{"LJ98", 4, 20442},
	{"LJ99", 4, 20443},
	{"LK00", 4, 20444},
	{"LK01", 4, 20445},
	{"LK02", 4, 20446},
	{"LK03", 4, 20447},
	{"LK04", 4, 20448},
	{"LK05", 4, 20449},
	{"LK06", 4, 20450},
	{"LK07", 4, 20451},
	{"LK08", 4, 20452},
	{"LK09", 4, 20453},
	{"LK10", 4, 20454},
	{"LK11", 4, 20455},
	{"LK12", 4, 20456},
	{"LK13", 4, 20457},
	{"LK14", 4, 20458},
	{"LK15", 4, 20459},
	{"LK16", 4, 20460},
	{"LK17", 4, 20461},
	{"LK18", 4, 20462},
	{"LK19", 4, 20463},
	{"LK20", 4, 20464},
	{"LK21", 4, 20465},
	{"LK22", 4, 20466},
	{"LK23", 4, 20467},
	{"LK24", 4, 20468},
	{"LK25", 4, 20469},
	{"LK26", 4, 20470},
	{"LK27", 4, 20471},
	{"LK28", 4, 20472},
	{"LK29", 4, 20473},
	{"LK30", 4, 20474},
	{"LK31", 4, 20475},
	{"LK32", 4, 20476},
	{"LK33", 4, 20477},
	{"LK34", 4, 20478},
	{"LK35", 4, 20479},
	{"LK36", 4, 20480},
	{"LK37", 4, 20481},
	{"LK38", 4, 20482},
	{"LK39", 4, 20483},
	{"LK40", 4, 20484},
	{"LK41", 4, 20485},
	{"LK42", 4, 20486},
	{"LK43", 4, 20487},
	{"LK44", 4, 20488},
	{"LK45", 4, 20489},
	{"LK46", 4, 20490},
	{"LK47", 4, 20491},
	{"LK48", 4, 20492},
	{"LK49", 4, 20493},
	{"LK50", 4, 20494},
	{"LK51", 4, 20495},
	{"LK52", 4, 20496},
	{"LK53", 4, 20497},
	{"LK54", 4, 20498},
	{"LK55", 4, 20499},
	{"LK56", 4, 20500},
	{"LK57", 4, 20501},
	{"LK58", 4, 20502},
	{"LK59", 4, 20503},
	{"LK60", 4, 20504},
	{"LK61", 4, 20505},
	{"LK62", 4, 20506},
	{"LK63", 4, 20507},
	{"LK64", 4, 20508},
	{"LK65", 4, 20509},
	{"LK66", 4, 20510},
	{"LK67", 4, 20511},
	{"LK68", 4, 20512},
	{"LK69", 4, 20513},
	{"LK70", 4, 20514},
	{"LK71", 4, 20515},
	{"LK72", 4, 20516},
	{"LK73", 4, 20517},
	{"LK74", 4, 20518},
	{"LK75", 4, 20519},
	{"LK76", 4, 20520},
	{"LK77", 4, 20521},
	{"LK78", 4, 20522},
	{"LK79", 4, 20523},
	{"LK80", 4, 20524},
	{"LK81", 4, 20525},
	{"LK82", 4, 20526},
	{"LK83", 4, 20527},
	{"LK84", 4, 20528},
	{"LK85", 4, 20529},
	{"LK86", 4, 20530},
	{"LK87", 4, 20531},
	{"LK88", 4, 20532},
	{"LK89", 4, 20533},
	{"LK90", 4, 20534},
	{"LK91", 4, 20535},
	{"LK92", 4, 20536},
	{"LK93", 4, 20537},
	{"LK94", 4, 20538},
	{"LK95", 4, 20539},
	{"LK96", 4, 20540},
	{"LK97", 4, 20541},
	{"LK98", 4, 20542},
	{"LK99", 4, 20543},
	{"LL00", 4, 20544},
	{"LL01", 4, 20545},
	{"LL02", 4, 20546},
	{"LL03", 4, 20547},
	{"LL04", 4, 20548},
	{"LL05", 4, 20549},
	{"LL06", 4, 20550},
	{"LL07", 4, 20551},
	{"LL08", 4, 20552},
	{"LL09", 4, 20553},
	{"LL10", 4, 20554},
	{"LL11", 4, 20555},
	{"LL12", 4, 20556},
	{"LL13", 4, 20557},
	{"LL14", 4, 20558},
	{"LL15", 4, 20559},
	{"LL16", 4, 20560},
	{"LL17", 4, 20561},
	{"LL18", 4, 20562},
	{"LL19", 4, 20563},
	{"LL20", 4, 20564},
	{"LL21", 4, 20565},
	{"LL22", 4, 20566},
	{"LL23", 4, 20567},
	{"LL24", 4, 20568},
	{"LL25", 4, 20569},
	{"LL26", 4, 20570},
	{"LL27", 4, 20571},
	{"LL28", 4, 20572},
	{"LL29", 4, 20573},
	{"LL30", 4, 20574},
	{"LL31", 4, 20575},
	{"LL32", 4, 20576},
	{"LL33", 4, 20577},
	{"LL34", 4, 20578},
	{"LL35", 4, 20579},
	{"LL36", 4, 20580},
	{"LL37", 4, 20581},
	{"LL38", 4, 20582},
	{"LL39", 4, 20583},
	{"LL40", 4, 20584},
	{"LL41", 4, 20585},
	{"LL42", 4, 20586},
	{"LL43", 4, 20587},
	{"LL44", 4, 20588},
	{"LL45", 4, 20589},
	{"LL46", 4, 20590},
	{"LL47", 4, 20591},
	{"LL48", 4, 20592},
	{"LL49", 4, 20593},
	{"LL50", 4, 20594},
	{"LL51", 4, 20595},
	{"LL52", 4, 20596},
	{"LL53", 4, 20597},
	{"LL54", 4, 20598},
	{"LL55", 4, 20599},
	{"LL56", 4, 20600},
	{"LL57", 4, 20601},
	{"LL58", 4, 20602},
	{"LL59", 4, 20603},
	{"LL60", 4, 20604},
	{"LL61", 4, 20605},
	{"LL62", 4, 20606},
	{"LL63", 4, 20607},
	{"LL64", 4, 20608},
	{"LL65", 4, 20609},
	{"LL66", 4, 20610},
	{"LL67", 4, 20611},
	{"LL68", 4, 20612},
	{"LL69", 4, 20613},
	{"LL70", 4, 20614},
	{"LL71", 4, 20615},
	{"LL72", 4, 20616},
	{"LL73", 4, 20617},
	{"LL74", 4, 20618},
	{"LL75", 4, 20619},
	{"LL76", 4, 20620},
	{"LL77", 4, 20621},
	{"LL78", 4, 20622},
	{"LL79", 4, 20623},
	{"LL80", 4, 20624},
	{"LL81", 4, 20625},
	{"LL82", 4, 20626},
	{"LL83", 4, 20627},
	{"LL84", 4, 20628},
	{"LL85", 4, 20629},
	{"LL86", 4, 20630},
	{"LL87", 4, 20631},
	{"LL88", 4, 20632},
	{"LL89", 4, 20633},
	{"LL90", 4, 20634},
	{"LL91", 4, 20635},
	{"LL92", 4, 20636},
	{"LL93", 4, 20637},
	{"LL94", 4, 20638},
	{"LL95", 4, 20639},
	{"LL96", 4, 20640},
	{"LL97", 4, 20641},
	{"LL98", 4, 20642},
	{"LL99", 4, 20643},
	{"LM00", 4, 20644},
	{"LM01", 4, 20645},
	{"LM02", 4, 20646},
	{"LM03", 4, 20647},
	{"LM04", 4, 20648},
	{"LM05", 4, 20649},
	{"LM06", 4, 20650},
	{"LM07", 4, 20651},
	{"LM08", 4, 20652},
	{"LM09", 4, 20653},
	{"LM10", 4, 20654},
	{"LM11", 4, 20655},
	{"LM12", 4, 20656},
	{"LM13", 4, 20657},
	{"LM14", 4, 20658},
	{"LM15", 4, 20659},
	{"LM16", 4, 20660},
	{"LM17", 4, 20661},
	{"LM18", 4, 20662},
	{"LM19", 4, 20663},
	{"LM20", 4, 20664},
	{"LM21", 4, 20665},
	{"LM22", 4, 20666},
	{"LM23", 4, 20667},
	{"LM24", 4, 20668},
	{"LM25", 4, 20669},
	{"LM26", 4, 20670},
	{"LM27", 4, 20671},
	{"LM28", 4, 20672},
	{"LM29", 4, 20673},
	{"LM30", 4, 20674},
	{"LM31", 4, 20675},
	{"LM32", 4, 20676},
	{"LM33", 4, 20677},
	{"LM34", 4, 20678},
	{"LM35", 4, 20679},
	{"LM36", 4, 20680},
	{"LM37", 4, 20681},
	{"LM38", 4, 20682},
	{"LM39", 4, 20683},
	{"LM40", 4, 20684},
	{"LM41", 4, 20685},
	{"LM42", 4, 20686},
	{"LM43", 4, 20687},
	{"LM44", 4, 20688},
	{"LM45", 4, 20689},
	{"LM46", 4, 20690},
	{"LM47", 4, 20691},
	{"LM48", 4, 20692},
	{"LM49", 4, 20693},
	{"LM50", 4, 20694},
	{"LM51", 4, 20695},
	{"LM52", 4, 20696},
	{"LM53", 4, 20697},
	{"LM54", 4, 20698},
	{"LM55", 4, 20699},
	{"LM56", 4, 20700},
	{"LM57", 4, 20701},
	{"LM58", 4, 20702},
	{"LM59", 4, 20703},
	{"LM60", 4, 20704},
	{"LM61", 4, 20705},
	{"LM62", 4, 20706},
	{"LM63", 4, 20707},
	{"LM64", 4, 20708},
	{"LM65", 4, 20709},
	{"LM66", 4, 20710},
	{"LM67", 4, 20711},
	{"LM68", 4, 20712},
	{"LM69", 4, 20713},
	{"LM70", 4, 20714},
	{"LM71", 4, 20715},
	{"LM72", 4, 20716},
	{"LM73", 4, 20717},
	{"LM74", 4, 20718},
	{"LM75", 4, 20719},
	{"LM76", 4, 20720},
	{"LM77", 4, 20721},
	{"LM78", 4, 20722},
	{"LM79", 4, 20723},
	{"LM80", 4, 20724},
	{"LM81", 4, 20725},
	{"LM82", 4, 20726},
	{"LM83", 4, 20727},
	{"LM84", 4, 20728},
	{"LM85", 4, 20729},
	{"LM86", 4, 20730},
	{"LM87", 4, 20731},
	{"LM88", 4, 20732},
	{"LM89", 4, 20733},
	{"LM90", 4, 20734},
	{"LM91", 4, 20735},
	{"LM92", 4, 20736},
	{"LM93", 4, 20737},
	{"LM94", 4, 20738},
	{"LM95", 4, 20739},
	{"LM96", 4, 20740},
	{"LM97", 4, 20741},
	{"LM98", 4, 20742},
	{"LM99", 4, 20743},
	{"LN00", 4, 20744},
	{"LN01", 4, 20745},
	{"LN02", 4, 20746},
	{"LN03", 4, 20747},
	{"LN04", 4, 20748},
	{"LN05", 4, 20749},
	{"LN06", 4, 20750},
	{"LN07", 4, 20751},
	{"LN08", 4, 20752},
	{"LN09", 4, 20753},
	{"LN10", 4, 20754},
	{"LN11", 4, 20755},
	{"LN12", 4, 20756},
	{"LN13", 4, 20757},
	{"LN14", 4, 20758},
	{"LN15", 4, 20759},
	{"LN16", 4, 20760},
	{"LN17", 4, 20761},
	{"LN18", 4, 20762},
	{"LN19", 4, 20763},
	{"LN20", 4, 20764},
	{"LN21", 4, 20765},
	{"LN22", 4, 20766},
	{"LN23", 4, 20767},
	{"LN24", 4, 20768},
	{"LN25", 4, 20769},
	{"LN26", 4, 20770},
	{"LN27", 4, 20771},
	{"LN28", 4, 20772},
	{"LN29", 4, 20773},
	{"LN30", 4, 20774},
	{"LN31", 4, 20775},
	{"LN32", 4, 20776},
	{"LN33", 4, 20777},
	{"LN34", 4, 20778},
	{"LN35", 4, 20779},
	{"LN36", 4, 20780},
	{"LN37", 4, 20781},
	{"LN38", 4, 20782},
	{"LN39", 4, 20783},
	{"LN40", 4, 20784},
	{"LN41", 4, 20785},
	{"LN42", 4, 20786},
	{"LN43", 4, 20787},
	{"LN44", 4, 20788},
	{"LN45", 4, 20789},
	{"LN46", 4, 20790},
	{"LN47", 4, 20791},
	{"LN48", 4, 20792},
	{"LN49", 4, 20793},
	{"LN50", 4, 20794},
	{"LN51", 4, 20795},
	{"LN52", 4, 20796},
	{"LN53", 4, 20797},
	{"LN54", 4, 20798},
	{"LN55", 4, 20799},
	{"LN56", 4, 20800},
	{"LN57", 4, 20801},
	{"LN58", 4, 20802},
	{"LN59", 4, 20803},
	{"LN60", 4, 20804},
	{"LN61", 4, 20805},
	{"LN62", 4, 20806},
	{"LN63", 4, 20807},
	{"LN64", 4, 20808},
	{"LN65", 4, 20809},
	{"LN66", 4, 20810},
	{"LN67", 4, 20811},
	{"LN68", 4, 20812},
	{"LN69", 4, 20813},
	{"LN70", 4, 20814},
	{"LN71", 4, 20815},
	{"LN72", 4, 20816},
	{"LN73", 4, 20817},
	{"LN74", 4, 20818},
	{"LN75", 4, 20819},
	{"LN76", 4, 20820},
	{"LN77", 4, 20821},
	{"LN78", 4, 20822},
	{"LN79", 4, 20823},
	{"LN80", 4, 20824},
	{"LN81", 4, 20825},
	{"LN82", 4, 20826},
	{"LN83", 4, 20827},
	{"LN84", 4, 20828},
	{"LN85", 4, 20829},
	{"LN86", 4, 20830},
	{"LN87", 4, 20831},
	{"LN88", 4, 20832},
	{"LN89", 4, 20833},
	{"LN90", 4, 20834},
	{"LN91", 4, 20835},
	{"LN92", 4, 20836},
	{"LN93", 4, 20837},
	{"LN94", 4, 20838},
	{"LN95", 4, 20839},
	{"LN96", 4, 20840},
	{"LN97", 4, 20841},
	{"LN98", 4, 20842},
	{"LN99", 4, 20843},
	{"LO00", 4, 20844},
	{"LO01", 4, 20845},
	{"LO02", 4, 20846},
	{"LO03", 4, 20847},
	{"LO04", 4, 20848},
	{"LO05", 4, 20849},
	{"LO06", 4, 20850},
	{"LO07", 4, 20851},
	{"LO08", 4, 20852},
	{"LO09", 4, 20853},
	{"LO10", 4, 20854},
	{"LO11", 4, 20855},
	{"LO12", 4, 20856},
	{"LO13", 4, 20857},
	{"LO14", 4, 20858},
	{"LO15", 4, 20859},
	{"LO16", 4, 20860},
	{"LO17", 4, 20861},
	{"LO18", 4, 20862},
	{"LO19", 4, 20863},
	{"LO20", 4, 20864},
	{"LO21", 4, 20865},
	{"LO22", 4, 20866},
	{"LO23", 4, 20867},
	{"LO24", 4, 20868},
	{"LO25", 4, 20869},
	{"LO26", 4, 20870},
	{"LO27", 4, 20871},
	{"LO28", 4, 20872},
	{"LO29", 4, 20873},
	{"LO30", 4, 20874},
	{"LO31", 4, 20875},
	{"LO32", 4, 20876},
	{"LO33", 4, 20877},
	{"LO34", 4, 20878},
	{"LO35", 4, 20879},
	{"LO36", 4, 20880},
	{"LO37", 4, 20881},
	{"LO38", 4, 20882},
	{"LO39", 4, 20883},
	{"LO40", 4, 20884},
	{"LO41", 4, 20885},
	{"LO42", 4, 20886},
	{"LO43", 4, 20887},
	{"LO44", 4, 20888},
	{"LO45", 4, 20889},
	{"LO46", 4, 20890},
	{"LO47", 4, 20891},
	{"LO48", 4, 20892},
	{"LO49", 4, 20893},
	{"LO50", 4, 20894},
	{"LO51", 4, 20895},
	{"LO52", 4, 20896},
	{"LO53", 4, 20897},
	{"LO54", 4, 20898},
	{"LO55", 4, 20899},
	{"LO56", 4, 20900},
	{"LO57", 4, 20901},
	{"LO58", 4, 20902},
	{"LO59", 4, 20903},
	{"LO60", 4, 20904},
	{"LO61", 4, 20905},
	{"LO62", 4, 20906},
	{"LO63", 4, 20907},
	{"LO64", 4, 20908},
	{"LO65", 4, 20909},
	{"LO66", 4, 20910},
	{"LO67", 4, 20911},
	{"LO68", 4, 20912},
	{"LO69", 4, 20913},
	{"LO70", 4, 20914},
	{"LO71", 4, 20915},
	{"LO72", 4, 20916},
	{"LO73", 4, 20917},
	{"LO74", 4, 20918},
	{"LO75", 4, 20919},
	{"LO76", 4, 20920},
	{"LO77", 4, 20921},
	{"LO78", 4, 20922},
	{"LO79", 4, 20923},
	{"LO80", 4, 20924},
	{"LO81", 4, 20925},
	{"LO82", 4, 20926},
	{"LO83", 4, 20927},
	{"LO84", 4, 20928},
	{"LO85", 4, 20929},
	{"LO86", 4, 20930},
	{"LO87", 4, 20931},
	{"LO88", 4, 20932},
	{"LO89", 4, 20933},
	{"LO90", 4, 20934},
	{"LO91", 4, 20935},
	{"LO92", 4, 20936},
	{"LO93", 4, 20937},
	{"LO94", 4, 20938},
	{"LO95", 4, 20939},
	{"LO96", 4, 20940},
	{"LO97", 4, 20941},
	{"LO98", 4, 20942},
	{"LO99", 4, 20943},
	{"LP00", 4, 20944},
	{"LP01", 4, 20945},
	{"LP02", 4, 20946},
	{"LP03", 4, 20947},
	{"LP04", 4, 20948},
	{"LP05", 4, 20949},
	{"LP06", 4, 20950},
	{"LP07", 4, 20951},
	{"LP08", 4, 20952},
	{"LP09", 4, 20953},
	{"LP10", 4, 20954},
	{"LP11", 4, 20955},
	{"LP12", 4, 20956},
	{"LP13", 4, 20957},
	{"LP14", 4, 20958},
	{"LP15", 4, 20959},
	{"LP16", 4, 20960},
	{"LP17", 4, 20961},
	{"LP18", 4, 20962},
	{"LP19", 4, 20963},
	{"LP20", 4, 20964},
	{"LP21", 4, 20965},
	{"LP22", 4, 20966},
	{"LP23", 4, 20967},
	{"LP24", 4, 20968},
	{"LP25", 4, 20969},
	{"LP26", 4, 20970},
	{"LP27", 4, 20971},
	{"LP28", 4, 20972},
	{"LP29", 4, 20973},
	{"LP30", 4, 20974},
	{"LP31", 4, 20975},
	{"LP32", 4, 20976},
	{"LP33", 4, 20977},
	{"LP34", 4, 20978},
	{"LP35", 4, 20979},
	{"LP36", 4, 20980},
	{"LP37", 4, 20981},
	{"LP38", 4, 20982},
	{"LP39", 4, 20983},
	{"LP40", 4, 20984},
	{"LP41", 4, 20985},
	{"LP42", 4, 20986},
	{"LP43", 4, 20987},
	{"LP44", 4, 20988},
	{"LP45", 4, 20989},
	{"LP46", 4, 20990},
	{"LP47", 4, 20991},
	{"LP48", 4, 20992},
	{"LP49", 4, 20993},
	{"LP50", 4, 20994},
	{"LP51", 4, 20995},
	{"LP52", 4, 20996},
	{"LP53", 4, 20997},
	{"LP54", 4, 20998},
	{"LP55", 4, 20999},
	{"LP56", 4, 21000},
	{"LP57", 4, 21001},
	{"LP58", 4, 21002},
	{"LP59", 4, 21003},
	{"LP60", 4, 21004},
	{"LP61", 4, 21005},
	{"LP62", 4, 21006},
	{"LP63", 4, 21007},
	{"LP64", 4, 21008},
	{"LP65", 4, 21009},
	{"LP66", 4, 21010},
	{"LP67", 4, 21011},
	{"LP68", 4, 21012},
	{"LP69", 4, 21013},
	{"LP70", 4, 21014},
	{"LP71", 4, 21015},
	{"LP72", 4, 21016},
	{"LP73", 4, 21017},
	{"LP74", 4, 21018},
	{"LP75", 4, 21019},
	{"LP76", 4, 21020},
	{"LP77", 4, 21021},
	{"LP78", 4, 21022},
	{"LP79", 4, 21023},
	{"LP80", 4, 21024},
	{"LP81", 4, 21025},
	{"LP82", 4, 21026},
	{"LP83", 4, 21027},
	{"LP84", 4, 21028},
	{"LP85", 4, 21029},
	{"LP86", 4, 21030},
	{"LP87", 4, 21031},
	{"LP88", 4, 21032},
	{"LP89", 4, 21033},
	{"LP90", 4, 21034},
	{"LP91", 4, 21035},
	{"LP92", 4, 21036},
	{"LP93", 4, 21037},
	{"LP94", 4, 21038},
	{"LP95", 4, 21039},
	{"LP96", 4, 21040},
	{"LP97", 4, 21041},
	{"LP98", 4, 21042},
	{"LP99", 4, 21043},
	{"LQ00", 4, 21044},
	{"LQ01", 4, 21045},
	{"LQ02", 4, 21046},
	{"LQ03", 4, 21047},
	{"LQ04", 4, 21048},
	{"LQ05", 4, 21049},
	{"LQ06", 4, 21050},
	{"LQ07", 4, 21051},
	{"LQ08", 4, 21052},
	{"LQ09", 4, 21053},
	{"LQ10", 4, 21054},
	{"LQ11", 4, 21055},
	{"LQ12", 4, 21056},
	{"LQ13", 4, 21057},
	{"LQ14", 4, 21058},
	{"LQ15", 4, 21059},
	{"LQ16", 4, 21060},
	{"LQ17", 4, 21061},
	{"LQ18", 4, 21062},
	{"LQ19", 4, 21063},
	{"LQ20", 4, 21064},
	{"LQ21", 4, 21065},
	{"LQ22", 4, 21066},
	{"LQ23", 4, 21067},
	{"LQ24", 4, 21068},
	{"LQ25", 4, 21069},
	{"LQ26", 4, 21070},
	{"LQ27", 4, 21071},
	{"LQ28", 4, 21072},
	{"LQ29", 4, 21073},
	{"LQ30", 4, 21074},
	{"LQ31", 4, 21075},
	{"LQ32", 4, 21076},
	{"LQ33", 4, 21077},
	{"LQ34", 4, 21078},
	{"LQ35", 4, 21079},
	{"LQ36", 4, 21080},
	{"LQ37", 4, 21081},
	{"LQ38", 4, 21082},
	{"LQ39", 4, 21083},
	{"LQ40", 4, 21084},
	{"LQ41", 4, 21085},
	{"LQ42", 4, 21086},
	{"LQ43", 4, 21087},
	{"LQ44", 4, 21088},
	{"LQ45", 4, 21089},
	{"LQ46", 4, 21090},
	{"LQ47", 4, 21091},
	{"LQ48", 4, 21092},
	{"LQ49", 4, 21093},
	{"LQ50", 4, 21094},
	{"LQ51", 4, 21095},
	{"LQ52", 4, 21096},
	{"LQ53", 4, 21097},
	{"LQ54", 4, 21098},
	{"LQ55", 4, 21099},
	{"LQ56", 4, 21100},
	{"LQ57", 4, 21101},
	{"LQ58", 4, 21102},
	{"LQ59", 4, 21103},
	{"LQ60", 4, 21104},
	{"LQ61", 4, 21105},
	{"LQ62", 4, 21106},
	{"LQ63", 4, 21107},
	{"LQ64", 4, 21108},
	{"LQ65", 4, 21109},
	{"LQ66", 4, 21110},
	{"LQ67", 4, 21111},
	{"LQ68", 4, 21112},
	{"LQ69", 4, 21113},
	{"LQ70", 4, 21114},
	{"LQ71", 4, 21115},
	{"LQ72", 4, 21116},
	{"LQ73", 4, 21117},
	{"LQ74", 4, 21118},
	{"LQ75", 4, 21119},
	{"LQ76", 4, 21120},
	{"LQ77", 4, 21121},
	{"LQ78", 4, 21122},
	{"LQ79", 4, 21123},
	{"LQ80", 4, 21124},
	{"LQ81", 4, 21125},
	{"LQ82", 4, 21126},
	{"LQ83", 4, 21127},
	{"LQ84", 4, 21128},
	{"LQ85", 4, 21129},
	{"LQ86", 4, 21130},
	{"LQ87", 4, 21131},
	{"LQ88", 4, 21132},
	{"LQ89", 4, 21133},
	{"LQ90", 4, 21134},
	{"LQ91", 4, 21135},
	{"LQ92", 4, 21136},
	{"LQ93", 4, 21137},
	{"LQ94", 4, 21138},
	{"LQ95", 4, 21139},
	{"LQ96", 4, 21140},
	{"LQ97", 4, 21141},
	{"LQ98", 4, 21142},
	{"LQ99", 4, 21143},
	{"MB00", 4, 21144},
	{"MB01", 4, 21145},
	{"MB02", 4, 21146},
	{"MB03", 4, 21147},
	{"MB04", 4, 21148},
	{"MB05", 4, 21149},
	{"MB06", 4, 21150},
	{"MB07", 4, 21151},
	{"MB08", 4, 21152},
	{"MB09", 4, 21153},
	{"MB10", 4, 21154},
	{"MB11", 4, 21155},
	{"MB12", 4, 21156},
	{"MB13", 4, 21157},
	{"MB14", 4, 21158},
	{"MB15", 4, 21159},
	{"MB16", 4, 21160},
	{"MB17", 4, 21161},
	{"MB18", 4, 21162},
	{"MB19", 4, 21163},
	{"MB20", 4, 21164},
	{"MB21", 4, 21165},
	{"MB22", 4, 21166},
	{"MB23", 4, 21167},
	{"MB24", 4, 21168},
	{"MB25", 4, 21169},
	{"MB26", 4, 21170},
	{"MB27", 4, 21171},
	{"MB28", 4, 21172},
	{"MB29", 4, 21173},
	{"MB30", 4, 21174},
	{"MB31", 4, 21175},
	{"MB32", 4, 21176},
	{"MB33", 4, 21177},
	{"MB34", 4, 21178},
	{"MB35", 4, 21179},
	{"MB36", 4, 21180},
	{"MB37", 4, 21181},
	{"MB38", 4, 21182},
	{"MB39", 4, 21183},
	{"MB40", 4, 21184},
	{"MB41", 4, 21185},
	{"MB42", 4, 21186},
	{"MB43", 4, 21187},
	{"MB44", 4, 21188},
	{"MB45", 4, 21189},
	{"MB46", 4, 21190},
	{"MB47", 4, 21191},
	{"MB48", 4, 21192},
	{"MB49", 4, 21193},
	{"MB50", 4, 21194},
	{"MB51", 4, 21195},
	{"MB52", 4, 21196},
	{"MB53", 4, 21197},
	{"MB54", 4, 21198},
	{"MB55", 4, 21199},
	{"MB56", 4, 21200},
	{"MB57", 4, 21201},
	{"MB58", 4, 21202},
	{"MB59", 4, 21203},
	{"MB60", 4, 21204},
	{"MB61", 4, 21205},
	{"MB62", 4, 21206},
	{"MB63", 4, 21207},
	{"MB64", 4, 21208},
	{"MB65", 4, 21209},
	{"MB66", 4, 21210},
	{"MB67", 4, 21211},
	{"MB68", 4, 21212},
	{"MB69", 4, 21213},
	{"MB70", 4, 21214},
	{"MB71", 4, 21215},
	{"MB72", 4, 21216},
	{"MB73", 4, 21217},
	{"MB74", 4, 21218},
	{"MB75", 4, 21219},
	{"MB76", 4, 21220},
	{"MB77", 4, 21221},
	{"MB78", 4, 21222},
	{"MB79", 4, 21223},
	{"MB80", 4, 21224},
	{"MB81", 4, 21225},
	{"MB82", 4, 21226},
	{"MB83", 4, 21227},
	{"MB84", 4, 21228},
	{"MB85", 4, 21229},
	{"MB86", 4, 21230},
	{"MB87", 4, 21231},
	{"MB88", 4, 21232},
	{"MB89", 4, 21233},
	{"MB90", 4, 21234},
	{"MB91", 4, 21235},
	{"MB92", 4, 21236},
	{"MB93", 4, 21237},
	{"MB94", 4, 21238},
	{"MB95", 4, 21239},
	{"MB96", 4, 21240},
	{"MB97", 4, 21241},
	{"MB98", 4, 21242},
	{"MB99", 4, 21243},
	{"MC00", 4, 21244},
	{"MC01", 4, 21245},
	{"MC02", 4, 21246},
	{"MC03", 4, 21247},
	{"MC04", 4, 21248},
	{"MC05", 4, 21249},
	{"MC06", 4, 21250},
	{"MC07", 4, 21251},
	{"MC08", 4, 21252},
	{"MC09", 4, 21253},
	{"MC10", 4, 21254},
	{"MC11", 4, 21255},
	{"MC12", 4, 21256},
	{"MC13", 4, 21257},
	{"MC14", 4, 21258},
	{"MC15", 4, 21259},
	{"MC16", 4, 21260},
	{"MC17", 4, 21261},
	{"MC18", 4, 21262},
	{"MC19", 4, 21263},
	{"MC20", 4, 21264},
	{"MC21", 4, 21265},
	{"MC22", 4, 21266},
	{"MC23", 4, 21267},
	{"MC24", 4, 21268},
	{"MC25", 4, 21269},
	{"MC26", 4, 21270},
	{"MC27", 4, 21271},
	{"MC28", 4, 21272},
	{"MC29", 4, 21273},
	{"MC30", 4, 21274},
	{"MC31", 4, 21275},
	{"MC32", 4, 21276},
	{"MC33", 4, 21277},
	{"MC34", 4, 21278},
	{"MC35", 4, 21279},
	{"MC36", 4, 21280},
	{"MC37", 4, 21281},
	{"MC38", 4, 21282},
	{"MC39", 4, 21283},
	{"MC40", 4, 21284},
	{"MC41", 4, 21285},
	{"MC42", 4, 21286},
	{"MC43", 4, 21287},
	{"MC44", 4, 21288},
	{"MC45", 4, 21289},
	{"MC46", 4, 21290},
	{"MC47", 4, 21291},
	{"MC48", 4, 21292},
	{"MC49", 4, 21293},
	{"MC50", 4, 21294},
	{"MC51", 4, 21295},
	{"MC52", 4, 21296},
	{"MC53", 4, 21297},
	{"MC54", 4, 21298},
	{"MC55", 4, 21299},
	{"MC56", 4, 21300},
	{"MC57", 4, 21301},
	{"MC58", 4, 21302},
	{"MC59", 4, 21303},
	{"MC60", 4, 21304},
	{"MC61", 4, 21305},
	{"MC62", 4, 21306},
	{"MC63", 4, 21307},
	{"MC64", 4, 21308},
	{"MC65", 4, 21309},
	{"MC66", 4, 21310},
	{"MC67", 4, 21311},
	{"MC68", 4, 21312},
	{"MC69", 4, 21313},
	{"MC70", 4, 21314},
	{"MC71", 4, 21315},
	{"MC72", 4, 21316},
	{"MC73", 4, 21317},
	{"MC74", 4, 21318},
	{"MC75", 4, 21319},
	{"MC76", 4, 21320},
	{"MC77", 4, 21321},
	{"MC78", 4, 21322},
	{"MC79", 4, 21323},
	{"MC80", 4, 21324},
	{"MC81", 4, 21325},
	{"MC82", 4, 21326},
	{"MC83", 4, 21327},
	{"MC84", 4, 21328},
	{"MC85", 4, 21329},
	{"MC86", 4, 21330},
	{"MC87", 4, 21331},
	{"MC88", 4, 21332},
	{"MC89", 4, 21333},
	{"MC90", 4, 21334},
	{"MC91", 4, 21335},
	{"MC92", 4, 21336},
	{"MC93", 4, 21337},
	{"MC94", 4, 21338},
	{"MC95", 4, 21339},
	{"MC96", 4, 21340},
	{"MC97", 4, 21341},
	{"MC98", 4, 21342},
	{"MC99", 4, 21343},
	{"ME00", 4, 21344},
	{"ME01", 4, 21345},
	{"ME02", 4, 21346},
	{"ME03", 4, 21347},
	{"ME04", 4, 21348},
	{"ME05", 4, 21349},
	{"ME06", 4, 21350},
	{"ME07", 4, 21351},
	{"ME08", 4, 21352},
	{"ME09", 4, 21353},
	{"ME10", 4, 21354},
	{"ME11", 4, 21355},
	{"ME12", 4, 21356},
	{"ME13", 4, 21357},
	{"ME14", 4, 21358},
	{"ME15", 4, 21359},
	{"ME16", 4, 21360},
	{"ME17", 4, 21361},
	{"ME18", 4, 21362},
	{"ME19", 4, 21363},
	{"ME20", 4, 21364},
	{"ME21", 4, 21365},
	{"ME22", 4, 21366},
	{"ME23", 4, 21367},
	{"ME24", 4, 21368},
	{"ME25", 4, 21369},
	{"ME26", 4, 21370},
	{"ME27", 4, 21371},
	{"ME28", 4, 21372},
	{"ME29", 4, 21373},
	{"ME30", 4, 21374},
	{"ME31", 4, 21375},
	{"ME32", 4, 21376},
	{"ME33", 4, 21377},
	{"ME34", 4, 21378},
	{"ME35", 4, 21379},
	{"ME36", 4, 21380},
	{"ME37", 4, 21381},
	{"ME38", 4, 21382},
	{"ME39", 4, 21383},
	{"ME40", 4, 21384},
	{"ME41", 4, 21385},
	{"ME42", 4, 21386},
	{"ME43", 4, 21387},
	{"ME44", 4, 21388},
	{"ME45", 4, 21389},
	{"ME46", 4, 21390},
	{"ME47", 4, 21391},
	{"ME48", 4, 21392},
	{"ME49", 4, 21393},
	{"ME50", 4, 21394},
	{"ME51", 4, 21395},
	{"ME52", 4, 21396},
	{"ME53", 4, 21397},
	{"ME54", 4, 21398},
	{"ME55", 4, 21399},
	{"ME56", 4, 21400},
	{"ME57", 4, 21401},
	{"ME58", 4, 21402},
	{"ME59", 4, 21403},
	{"ME60", 4, 21404},
	{"ME61", 4, 21405},
	{"ME62", 4, 21406},
	{"ME63", 4, 21407},
	{"ME64", 4, 21408},
	{"ME65", 4, 21409},
	{"ME66", 4, 21410},
	{"ME67", 4, 21411},
	{"ME68", 4, 21412},
	{"ME69", 4, 21413},
	{"ME70", 4, 21414},
	{"ME71", 4, 21415},
	{"ME72", 4, 21416},
	{"ME73", 4, 21417},
	{"ME74", 4, 21418},
	{"ME75", 4, 21419},
	{"ME76", 4, 21420},
	{"ME77", 4, 21421},
	{"ME78", 4, 21422},
	{"ME79", 4, 21423},
	{"ME80", 4, 21424},
	{"ME81", 4, 21425},
	{"ME82", 4, 21426},
	{"ME83", 4, 21427},
	{"ME84", 4, 21428},
	{"ME85", 4, 21429},
	{"ME86", 4, 21430},
	{"ME87", 4, 21431},
	{"ME88", 4, 21432},
	{"ME89", 4, 21433},
	{"ME90", 4, 21434},
	{"ME91", 4, 21435},
	{"ME92", 4, 21436},
	{"ME93", 4, 21437},
	{"ME94", 4, 21438},
	{"ME95", 4, 21439},
	{"ME96", 4, 21440},
	{"ME97", 4, 21441},
	{"ME98", 4, 21442},
	{"ME99", 4, 21443},
	{"MJ00", 4, 21444},
	{"MJ01", 4, 21445},
	{"MJ02", 4, 21446},
	{"MJ03", 4, 21447},
	{"MJ04", 4, 21448},
	{"MJ05", 4, 21449},
	{"MJ06", 4, 21450},
	{"MJ07", 4, 21451},
	{"MJ08", 4, 21452},
	{"MJ09", 4, 21453},
	{"MJ10", 4, 21454},
	{"MJ11", 4, 21455},
	{"MJ12", 4, 21456},
	{"MJ13", 4, 21457},
	{"MJ14", 4, 21458},
	{"MJ15", 4, 21459},
	{"MJ16", 4, 21460},
	{"MJ17", 4, 21461},
	{"MJ18", 4, 21462},
	{"MJ19", 4, 21463},
	{"MJ20", 4, 21464},
	{"MJ21", 4, 21465},
	{"MJ22", 4, 21466},
	{"MJ23", 4, 21467},
	{"MJ24", 4, 21468},
	{"MJ25", 4, 21469},
	{"MJ26", 4, 21470},
	{"MJ27", 4, 21471},
	{"MJ28", 4, 21472},
	{"MJ29", 4, 21473},
	{"MJ30", 4, 21474},
	{"MJ31", 4, 21475},
	{"MJ32", 4, 21476},
	{"MJ33", 4, 21477},
	{"MJ34", 4, 21478},
	{"MJ35", 4, 21479},
	{"MJ36", 4, 21480},
	{"MJ37", 4, 21481},
	{"MJ38", 4, 21482},
	{"MJ39", 4, 21483},
	{"MJ40", 4, 21484},
	{"MJ41", 4, 21485},
	{"MJ42", 4, 21486},
	{"MJ43", 4, 21487},
	{"MJ44", 4, 21488},
	{"MJ45", 4, 21489},
	{"MJ46", 4, 21490},
	{"MJ47", 4, 21491},
	{"MJ48", 4, 21492},
	{"MJ49", 4, 21493},
	{"MJ50", 4, 21494},
	{"MJ51", 4, 21495},
	{"MJ52", 4, 21496},
	{"MJ53", 4, 21497},
	{"MJ54", 4, 21498},
	{"MJ55", 4, 21499},
	{"MJ56", 4, 21500},
	{"MJ57", 4, 21501},
	{"MJ58", 4, 21502},
	{"MJ59", 4, 21503},
	{"MJ60", 4, 21504},
	{"MJ61", 4, 21505},
	{"MJ62", 4, 21506},
	{"MJ63", 4, 21507},
	{"MJ64", 4, 21508},
	{"MJ65", 4, 21509},
	{"MJ66", 4, 21510},
	{"MJ67", 4, 21511},
	{"MJ68", 4, 21512},
	{"MJ69", 4, 21513},
	{"MJ70", 4, 21514},
	{"MJ71", 4, 21515},
	{"MJ72", 4, 21516},
	{"MJ73", 4, 21517},
	{"MJ74", 4, 21518},
	{"MJ75", 4, 21519},
	{"MJ76", 4, 21520},
	{"MJ77", 4, 21521},
	{"MJ78", 4, 21522},
	{"MJ79", 4, 21523},
	{"MJ80", 4, 21524},
	{"MJ81", 4, 21525},
	{"MJ82", 4, 21526},
	{"MJ83", 4, 21527},
	{"MJ84", 4, 21528},
	{"MJ85", 4, 21529},
	{"MJ86", 4, 21530},
	{"MJ87", 4, 21531},
	{"MJ88", 4, 21532},
	{"MJ89", 4, 21533},
	{"MJ90", 4, 21534},
	{"MJ91", 4, 21535},
	{"MJ92", 4, 21536},
	{"MJ93", 4, 21537},
	{"MJ94", 4, 21538},
	{"MJ95", 4, 21539},
	{"MJ96", 4, 21540},
	{"MJ97", 4, 21541},
	{"MJ98", 4, 21542},
	{"MJ99", 4, 21543},
	{"MK00", 4, 21544},
	{"MK01", 4, 21545},
	{"MK02", 4, 21546},
	{"MK03", 4, 21547},
	{"MK04", 4, 21548},
	{"MK05", 4, 21549},
	{"MK06", 4, 21550},
	{"MK07", 4, 21551},
	{"MK08", 4, 21552},
	{"MK09", 4, 21553},
	{"MK10", 4, 21554},
	{"MK11", 4, 21555},
	{"MK12", 4, 21556},
	{"MK13", 4, 21557},
	{"MK14", 4, 21558},
	{"MK15", 4, 21559},
	{"MK16", 4, 21560},
	{"MK17", 4, 21561},
	{"MK18", 4, 21562},
	{"MK19", 4, 21563},
	{"MK20", 4, 21564},
	{"MK21", 4, 21565},
	{"MK22", 4, 21566},
	{"MK23", 4, 21567},
	{"MK24", 4, 21568},
	{"MK25", 4, 21569},
	{"MK26", 4, 21570},
	{"MK27", 4, 21571},
	{"MK28", 4, 21572},
	{"MK29", 4, 21573},
	{"MK30", 4, 21574},
	{"MK31", 4, 21575},
	{"MK32", 4, 21576},
	{"MK33", 4, 21577},
	{"MK34", 4, 21578},
	{"MK35", 4, 21579},
	{"MK36", 4, 21580},
	{"MK37", 4, 21581},
	{"MK38", 4, 21582},
	{"MK39", 4, 21583},
	{"MK40", 4, 21584},
	{"MK41", 4, 21585},
	{"MK42", 4, 21586},
	{"MK43", 4, 21587},
	{"MK44", 4, 21588},
	{"MK45", 4, 21589},
	{"MK46", 4, 21590},
	{"MK47", 4, 21591},
	{"MK48", 4, 21592},
	{"MK49", 4, 21593},
	{"MK50", 4, 21594},
	{"MK51", 4, 21595},
	{"MK52", 4, 21596},
	{"MK53", 4, 21597},
	{"MK54", 4, 21598},
	{"MK55", 4, 21599},
	{"MK56", 4, 21600},
	{"MK57", 4, 21601},
	{"MK58", 4, 21602},
	{"MK59", 4, 21603},
	{"MK60", 4, 21604},
	{"MK61", 4, 21605},
	{"MK62", 4, 21606},
	{"MK63", 4, 21607},
	{"MK64", 4, 21608},
	{"MK65", 4, 21609},
	{"MK66", 4, 21610},
	{"MK67", 4, 21611},
	{"MK68", 4, 21612},
	{"MK69", 4, 21613},
	{"MK70", 4, 21614},
	{"MK71", 4, 21615},
	{"MK72", 4, 21616},
	{"MK73", 4, 21617},
	{"MK74", 4, 21618},
	{"MK75", 4, 21619},
	{"MK76", 4, 21620},
	{"MK77", 4, 21621},
	{"MK78", 4, 21622},
	{"MK79", 4, 21623},
	{"MK80", 4, 21624},
	{"MK81", 4, 21625},
	{"MK82", 4, 21626},
	{"MK83", 4, 21627},
	{"MK84", 4, 21628},
	{"MK85", 4, 21629},
	{"MK86", 4, 21630},
	{"MK87", 4, 21631},
	{"MK88", 4, 21632},
	{"MK89", 4, 21633},
	{"MK90", 4, 21634},
	{"MK91", 4, 21635},
	{"MK92", 4, 21636},
	{"MK93", 4, 21637},
	{"MK94", 4, 21638},
	{"MK95", 4, 21639},
	{"MK96", 4, 21640},
	{"MK97", 4, 21641},
	{"MK98", 4, 21642},
	{"MK99", 4, 21643},
	{"ML00", 4, 21644},
	{"ML01", 4, 21645},
	{"ML02", 4, 21646},
	{"ML03", 4, 21647},
	{"ML04", 4, 21648},
	{"ML05", 4, 21649},
	{"ML06", 4, 21650},
	{"ML07", 4, 21651},
	{"ML08", 4, 21652},
	{"ML09", 4, 21653},
	{"ML10", 4, 21654},
	{"ML11", 4, 21655},
	{"ML12", 4, 21656},
	{"ML13", 4, 21657},
	{"ML14", 4, 21658},
	{"ML15", 4, 21659},
	{"ML16", 4, 21660},
	{"ML17", 4, 21661},
	{"ML18", 4, 21662},
	{"ML19", 4, 21663},
	{"ML20", 4, 21664},
	{"ML21", 4, 21665},
	{"ML22", 4, 21666},
	{"ML23", 4, 21667},
	{"ML24", 4, 21668},
	{"ML25", 4, 21669},
	{"ML26", 4, 21670},
	{"ML27", 4, 21671},
	{"ML28", 4, 21672},
	{"ML29", 4, 21673},
	{"ML30", 4, 21674},
	{"ML31", 4, 21675},
	{"ML32", 4, 21676},
	{"ML33", 4, 21677},
	{"ML34", 4, 21678},
	{"ML35", 4, 21679},
	{"ML36", 4, 21680},
	{"ML37", 4, 21681},
	{"ML38", 4, 21682},
	{"ML39", 4, 21683},
	{"ML40", 4, 21684},
	{"ML41", 4, 21685},
	{"ML42", 4, 21686},
	{"ML43", 4, 21687},
	{"ML44", 4, 21688},
	{"ML45", 4, 21689},
	{"ML46", 4, 21690},
	{"ML47", 4, 21691},
	{"ML48", 4, 21692},
	{"ML49", 4, 21693},
	{"ML50", 4, 21694},
	{"ML51", 4, 21695},
	{"ML52", 4, 21696},
	{"ML53", 4, 21697},
	{"ML54", 4, 21698},
	{"ML55", 4, 21699},
	{"ML56", 4, 21700},
	{"ML57", 4, 21701},
	{"ML58", 4, 21702},
	{"ML59", 4, 21703},
	{"ML60", 4, 21704},
	{"ML61", 4, 21705},
	{"ML62", 4, 21706},
	{"ML63", 4, 21707},
	{"ML64", 4, 21708},
	{"ML65", 4, 21709},
	{"ML66", 4, 21710},
	{"ML67", 4, 21711},
	{"ML68", 4, 21712},
	{"ML69", 4, 21713},
	{"ML70", 4, 21714},
	{"ML71", 4, 21715},
	{"ML72", 4, 21716},
	{"ML73", 4, 21717},
	{"ML74", 4, 21718},
	{"ML75", 4, 21719},
	{"ML76", 4, 21720},
	{"ML77", 4, 21721},
	{"ML78", 4, 21722},
	{"ML79", 4, 21723},
	{"ML80", 4, 21724},
	{"ML81", 4, 21725},
	{"ML82", 4, 21726},
	{"ML83", 4, 21727},
	{"ML84", 4, 21728},
	{"ML85", 4, 21729},
	{"ML86", 4, 21730},
	{"ML87", 4, 21731},
	{"ML88", 4, 21732},
	{"ML89", 4, 21733},
	{"ML90", 4, 21734},
	{"ML91", 4, 21735},
	{"ML92", 4, 21736},
	{"ML93", 4, 21737},
	{"ML94", 4, 21738},
	{"ML95", 4, 21739},
	{"ML96", 4, 21740},
	{"ML97", 4, 21741},
	{"ML98", 4, 21742},
	{"ML99", 4, 21743},
	{"MM00", 4, 21744},
	{"MM01", 4, 21745},
	{"MM02", 4, 21746},
	{"MM03", 4, 21747},
	{"MM04", 4, 21748},
	{"MM05", 4, 21749},
	{"MM06", 4, 21750},
	{"MM07", 4, 21751},
	{"MM08", 4, 21752},
	{"MM09", 4, 21753},
	{"MM10", 4, 21754},
	{"MM11", 4, 21755},
	{"MM12", 4, 21756},
	{"MM13", 4, 21757},
	{"MM14", 4, 21758},
	{"MM15", 4, 21759},
	{"MM16", 4, 21760},
	{"MM17", 4, 21761},
	{"MM18", 4, 21762},
	{"MM19", 4, 21763},
	{"MM20", 4, 21764},
	{"MM21", 4, 21765},
	{"MM22", 4, 21766},
	{"MM23", 4, 21767},
	{"MM24", 4, 21768},
	{"MM25", 4, 21769},
	{"MM26", 4, 21770},
	{"MM27", 4, 21771},
	{"MM28", 4, 21772},
	{"MM29", 4, 21773},
	{"MM30", 4, 21774},
	{"MM31", 4, 21775},
	{"MM32", 4, 21776},
	{"MM33", 4, 21777},
	{"MM34", 4, 21778},
	{"MM35", 4, 21779},
	{"MM36", 4, 21780},
	{"MM37", 4, 21781},
	{"MM38", 4, 21782},
	{"MM39", 4, 21783},
	{"MM40", 4, 21784},
	{"MM41", 4, 21785},
	{"MM42", 4, 21786},
	{"MM43", 4, 21787},
	{"MM44", 4, 21788},
	{"MM45", 4, 21789},
	{"MM46", 4, 21790},
	{"MM47", 4, 21791},
	{"MM48", 4, 21792},
	{"MM49", 4, 21793},
	{"MM50", 4, 21794},
	{"MM51", 4, 21795},
	{"MM52", 4, 21796},
	{"MM53", 4, 21797},
	{"MM54", 4, 21798},
	{"MM55", 4, 21799},
	{"MM56", 4, 21800},
	{"MM57", 4, 21801},
	{"MM58", 4, 21802},
	{"MM59", 4, 21803},
	{"MM60", 4, 21804},
	{"MM61", 4, 21805},
	{"MM62", 4, 21806},
	{"MM63", 4, 21807},
	{"MM64", 4, 21808},
	{"MM65", 4, 21809},
	{"MM66", 4, 21810},
	{"MM67", 4, 21811},
	{"MM68", 4, 21812},
	{"MM69", 4, 21813},
	{"MM70", 4, 21814},
	{"MM71", 4, 21815},
	{"MM72", 4, 21816},
	{"MM73", 4, 21817},
	{"MM74", 4, 21818},
	{"MM75", 4, 21819},
	{"MM76", 4, 21820},
	{"MM77", 4, 21821},
	{"MM78", 4, 21822},
	{"MM79", 4, 21823},
	{"MM80", 4, 21824},
	{"MM81", 4, 21825},
	{"MM82", 4, 21826},
	{"MM83", 4, 21827},
	{"MM84", 4, 21828},
	{"MM85", 4, 21829},
	{"MM86", 4, 21830},
	{"MM87", 4, 21831},
	{"MM88", 4, 21832},
	{"MM89", 4, 21833},
	{"MM90", 4, 21834},
	{"MM91", 4, 21835},
	{"MM92", 4, 21836},
	{"MM93", 4, 21837},
	{"MM94", 4, 21838},
	{"MM95", 4, 21839},
	{"MM96", 4, 21840},
	{"MM97", 4, 21841},
	{"MM98", 4, 21842},
	{"MM99", 4, 21843},
	{"MN00", 4, 21844},
	{"MN01", 4, 21845},
	{"MN02", 4, 21846},
	{"MN03", 4, 21847},
	{"MN04", 4, 21848},
	{"MN05", 4, 21849},
	{"MN06", 4, 21850},
	{"MN07", 4, 21851},
	{"MN08", 4, 21852},
	{"MN09", 4, 21853},
	{"MN10", 4, 21854},
	{"MN11", 4, 21855},
	{"MN12", 4, 21856},
	{"MN13", 4, 21857},
	{"MN14", 4, 21858},
	{"MN15", 4, 21859},
	{"MN16", 4, 21860},
	{"MN17", 4, 21861},
	{"MN18", 4, 21862},
	{"MN19", 4, 21863},
	{"MN20", 4, 21864},
	{"MN21", 4, 21865},
	{"MN22", 4, 21866},
	{"MN23", 4, 21867},
	{"MN24", 4, 21868},
	{"MN25", 4, 21869},
	{"MN26", 4, 21870},
	{"MN27", 4, 21871},
	{"MN28", 4, 21872},
	{"MN29", 4, 21873},
	{"MN30", 4, 21874},
	{"MN31", 4, 21875},
	{"MN32", 4, 21876},
	{"MN33", 4, 21877},
	{"MN34", 4, 21878},
	{"MN35", 4, 21879},
	{"MN36", 4, 21880},
	{"MN37", 4, 21881},
	{"MN38", 4, 21882},
	{"MN39", 4, 21883},
	{"MN40", 4, 21884},
	{"MN41", 4, 21885},
	{"MN42", 4, 21886},
	{"MN43", 4, 21887},
	{"MN44", 4, 21888},
	{"MN45", 4, 21889},
	{"MN46", 4, 21890},
	{"MN47", 4, 21891},
	{"MN48", 4, 21892},
	{"MN49", 4, 21893},
	{"MN50", 4, 21894},
	{"MN51", 4, 21895},
	{"MN52", 4, 21896},
	{"MN53", 4, 21897},
	{"MN54", 4, 21898},
	{"MN55", 4, 21899},
	{"MN56", 4, 21900},
	{"MN57", 4, 21901},
	{"MN58", 4, 21902},
	{"MN59", 4, 21903},
	{"MN60", 4, 21904},
	{"MN61", 4, 21905},
	{"MN62", 4, 21906},
	{"MN63", 4, 21907},
	{"MN64", 4, 21908},
	{"MN65", 4, 21909},
	{"MN66", 4, 21910},
	{"MN67", 4, 21911},
	{"MN68", 4, 21912},
	{"MN69", 4, 21913},
	{"MN70", 4, 21914},
	{"MN71", 4, 21915},
	{"MN72", 4, 21916},
	{"MN73", 4, 21917},
	{"MN74", 4, 21918},
	{"MN75", 4, 21919},
	{"MN76", 4, 21920},
	{"MN77", 4, 21921},
	{"MN78", 4, 21922},
	{"MN79", 4, 21923},
	{"MN80", 4, 21924},
	{"MN81", 4, 21925},
	{"MN82", 4, 21926},
	{"MN83", 4, 21927},
	{"MN84", 4, 21928},
	{"MN85", 4, 21929},
	{"MN86", 4, 21930},
	{"MN87", 4, 21931},
	{"MN88", 4, 21932},
	{"MN89", 4, 21933},
	{"MN90", 4, 21934},
	{"MN91", 4, 21935},
	{"MN92", 4, 21936},
	{"MN93", 4, 21937},
	{"MN94", 4, 21938},
	{"MN95", 4, 21939},
	{"MN96", 4, 21940},
	{"MN97", 4, 21941},
	{"MN98", 4, 21942},
	{"MN99", 4, 21943},
	{"MO00", 4, 21944},
	{"MO01", 4, 21945},
	{"MO02", 4, 21946},
	{"MO03", 4, 21947},
	{"MO04", 4, 21948},
	{"MO05", 4, 21949},
	{"MO06", 4, 21950},
	{"MO07", 4, 21951},
	{"MO08", 4, 21952},
	{"MO09", 4, 21953},
	{"MO10", 4, 21954},
	{"MO11", 4, 21955},
	{"MO12", 4, 21956},
	{"MO13", 4, 21957},
	{"MO14", 4, 21958},
	{"MO15", 4, 21959},
	{"MO16", 4, 21960},
	{"MO17", 4, 21961},
	{"MO18", 4, 21962},
	{"MO19", 4, 21963},
	{"MO20", 4, 21964},
	{"MO21", 4, 21965},
	{"MO22", 4, 21966},
	{"MO23", 4, 21967},
	{"MO24", 4, 21968},
	{"MO25", 4, 21969},
	{"MO26", 4, 21970},
	{"MO27", 4, 21971},
	{"MO28", 4, 21972},
	{"MO29", 4, 21973},
	{"MO30", 4, 21974},
	{"MO31", 4, 21975},
	{"MO32", 4, 21976},
	{"MO33", 4, 21977},
	{"MO34", 4, 21978},
	{"MO35", 4, 21979},
	{"MO36", 4, 21980},
	{"MO37", 4, 21981},
	{"MO38", 4, 21982},
	{"MO39", 4, 21983},
	{"MO40", 4, 21984},
	{"MO41", 4, 21985},
	{"MO42", 4, 21986},
	{"MO43", 4, 21987},
	{"MO44", 4, 21988},
	{"MO45", 4, 21989},
	{"MO46", 4, 21990},
	{"MO47", 4, 21991},
	{"MO48", 4, 21992},
	{"MO49", 4, 21993},
	{"MO50", 4, 21994},
	{"MO51", 4, 21995},
	{"MO52", 4, 21996},
	{"MO53", 4, 21997},
	{"MO54", 4, 21998},
	{"MO55", 4, 21999},
	{"MO56", 4, 22000},
	{"MO57", 4, 22001},
	{"MO58", 4, 22002},
	{"MO59", 4, 22003},
	{"MO60", 4, 22004},
	{"MO61", 4, 22005},
	{"MO62", 4, 22006},
	{"MO63", 4, 22007},
	{"MO64", 4, 22008},
	{"MO65", 4, 22009},
	{"MO66", 4, 22010},
	{"MO67", 4, 22011},
	{"MO68", 4, 22012},
	{"MO69", 4, 22013},
	{"MO70", 4, 22014},
	{"MO71", 4, 22015},
	{"MO72", 4, 22016},
	{"MO73", 4, 22017},
	{"MO74", 4, 22018},
	{"MO75", 4, 22019},
	{"MO76", 4, 22020},
	{"MO77", 4, 22021},
	{"MO78", 4, 22022},
	{"MO79", 4, 22023},
	{"MO80", 4, 22024},
	{"MO81", 4, 22025},
	{"MO82", 4, 22026},
	{"MO83", 4, 22027},
	{"MO84", 4, 22028},
	{"MO85", 4, 22029},
	{"MO86", 4, 22030},
	{"MO87", 4, 22031},
	{"MO88", 4, 22032},
	{"MO89", 4, 22033},
	{"MO90", 4, 22034},
	{"MO91", 4, 22035},
	{"MO92", 4, 22036},
	{"MO93", 4, 22037},
	{"MO94", 4, 22038},
	{"MO95", 4, 22039},
	{"MO96", 4, 22040},
	{"MO97", 4, 22041},
	{"MO98", 4, 22042},
	{"MO99", 4, 22043},
	{"MP00", 4, 22044},
	{"MP01", 4, 22045},
	{"MP02", 4, 22046},
	{"MP03", 4, 22047},
	{"MP04", 4, 22048},
	{"MP05", 4, 22049},
	{"MP06", 4, 22050},
	{"MP07", 4, 22051},
	{"MP08", 4, 22052},
	{"MP09", 4, 22053},
	{"MP10", 4, 22054},
	{"MP11", 4, 22055},
	{"MP12", 4, 22056},
	{"MP13", 4, 22057},
	{"MP14", 4, 22058},
	{"MP15", 4, 22059},
	{"MP16", 4, 22060},
	{"MP17", 4, 22061},
	{"MP18", 4, 22062},
	{"MP19", 4, 22063},
	{"MP20", 4, 22064},
	{"MP21", 4, 22065},
	{"MP22", 4, 22066},
	{"MP23", 4, 22067},
	{"MP24", 4, 22068},
	{"MP25", 4, 22069},
	{"MP26", 4, 22070},
	{"MP27", 4, 22071},
	{"MP28", 4, 22072},
	{"MP29", 4, 22073},
	{"MP30", 4, 22074},
	{"MP31", 4, 22075},
	{"MP32", 4, 22076},
	{"MP33", 4, 22077},
	{"MP34", 4, 22078},
	{"MP35", 4, 22079},
	{"MP36", 4, 22080},
	{"MP37", 4, 22081},
	{"MP38", 4, 22082},
	{"MP39", 4, 22083},
	{"MP40", 4, 22084},
	{"MP41", 4, 22085},
	{"MP42", 4, 22086},
	{"MP43", 4, 22087},
	{"MP44", 4, 22088},
	{"MP45", 4, 22089},
	{"MP46", 4, 22090},
	{"MP47", 4, 22091},
	{"MP48", 4, 22092},
	{"MP49", 4, 22093},
	{"MP50", 4, 22094},
	{"MP51", 4, 22095},
	{"MP52", 4, 22096},
	{"MP53", 4, 22097},
	{"MP54", 4, 22098},
	{"MP55", 4, 22099},
	{"MP56", 4, 22100},
	{"MP57", 4, 22101},
	{"MP58", 4, 22102},
	{"MP59", 4, 22103},
	{"MP60", 4, 22104},
	{"MP61", 4, 22105},
	{"MP62", 4, 22106},
	{"MP63", 4, 22107},
	{"MP64", 4, 22108},
	{"MP65", 4, 22109},
	{"MP66", 4, 22110},
	{"MP67", 4, 22111},
	{"MP68", 4, 22112},
	{"MP69", 4, 22113},
	{"MP70", 4, 22114},
	{"MP71", 4, 22115},
	{"MP72", 4, 22116},
	{"MP73", 4, 22117},
	{"MP74", 4, 22118},
	{"MP75", 4, 22119},
	{"MP76", 4, 22120},
	{"MP77", 4, 22121},
	{"MP78", 4, 22122},
	{"MP79", 4, 22123},
	{"MP80", 4, 22124},
	{"MP81", 4, 22125},
	{"MP82", 4, 22126},
	{"MP83", 4, 22127},
	{"MP84", 4, 22128},
	{"MP85", 4, 22129},
	{"MP86", 4, 22130},
	{"MP87", 4, 22131},
	{"MP88", 4, 22132},
	{"MP89", 4, 22133},
	{"MP90", 4, 22134},
	{"MP91", 4, 22135},
	{"MP92", 4, 22136},
	{"MP93", 4, 22137},
	{"MP94", 4, 22138},
	{"MP95", 4, 22139},
	{"MP96", 4, 22140},
	{"MP97", 4, 22141},
	{"MP98", 4, 22142},
	{"MP99", 4, 22143},
	{"MQ00", 4, 22144},
	{"MQ01", 4, 22145},
	{"MQ02", 4, 22146},
	{"MQ03", 4, 22147},
	{"MQ04", 4, 22148},
	{"MQ05", 4, 22149},
	{"MQ06", 4, 22150},
	{"MQ07", 4, 22151},
	{"MQ08", 4, 22152},
	{"MQ09", 4, 22153},
	{"MQ10", 4, 22154},
	{"MQ11", 4, 22155},
	{"MQ12", 4, 22156},
	{"MQ13", 4, 22157},
	{"MQ14", 4, 22158},
	{"MQ15", 4, 22159},
	{"MQ16", 4, 22160},
	{"MQ17", 4, 22161},
	{"MQ18", 4, 22162},
	{"MQ19", 4, 22163},
	{"MQ20", 4, 22164},
	{"MQ21", 4, 22165},
	{"MQ22", 4, 22166},
	{"MQ23", 4, 22167},
	{"MQ24", 4, 22168},
	{"MQ25", 4, 22169},
	{"MQ26", 4, 22170},
	{"MQ27", 4, 22171},
	{"MQ28", 4, 22172},
	{"MQ29", 4, 22173},
	{"MQ30", 4, 22174},
	{"MQ31", 4, 22175},
	{"MQ32", 4, 22176},
	{"MQ33", 4, 22177},
	{"MQ34", 4, 22178},
	{"MQ35", 4, 22179},
	{"MQ36", 4, 22180},
	{"MQ37", 4, 22181},
	{"MQ38", 4, 22182},
	{"MQ39", 4, 22183},
	{"MQ40", 4, 22184},
	{"MQ41", 4, 22185},
	{"MQ42", 4, 22186},
	{"MQ43", 4, 22187},
	{"MQ44", 4, 22188},
	{"MQ45", 4, 22189},
	{"MQ46", 4, 22190},
	{"MQ47", 4, 22191},
	{"MQ48", 4, 22192},
	{"MQ49", 4, 22193},
	{"MQ50", 4, 22194},
	{"MQ51", 4, 22195},
	{"MQ52", 4, 22196},
	{"MQ53", 4, 22197},
	{"MQ54", 4, 22198},
	{"MQ55", 4, 22199},
	{"MQ56", 4, 22200},
	{"MQ57", 4, 22201},
	{"MQ58", 4, 22202},
	{"MQ59", 4, 22203},
	{"MQ60", 4, 22204},
	{"MQ61", 4, 22205},
	{"MQ62", 4, 22206},
	{"MQ63", 4, 22207},
	{"MQ64", 4, 22208},
	{"MQ65", 4, 22209},
	{"MQ66", 4, 22210},
	{"MQ67", 4, 22211},
	{"MQ68", 4, 22212},
	{"MQ69", 4, 22213},
	{"MQ70", 4, 22214},
	{"MQ71", 4, 22215},
	{"MQ72", 4, 22216},
	{"MQ73", 4, 22217},
	{"MQ74", 4, 22218},
	{"MQ75", 4, 22219},
	{"MQ76", 4, 22220},
	{"MQ77", 4, 22221},
	{"MQ78", 4, 22222},
	{"MQ79", 4, 22223},
	{"MQ80", 4, 22224},
	{"MQ81", 4, 22225},
	{"MQ82", 4, 22226},
	{"MQ83", 4, 22227},
	{"MQ84", 4, 22228},
	{"MQ85", 4, 22229},
	{"MQ86", 4, 22230},
	{"MQ87", 4, 22231},
	{"MQ88", 4, 22232},
	{"MQ89", 4, 22233},
	{"MQ90", 4, 22234},
	{"MQ91", 4, 22235},
	{"MQ92", 4, 22236},
	{"MQ93", 4, 22237},
	{"MQ94", 4, 22238},
	{"MQ95", 4, 22239},
	{"MQ96", 4, 22240},
	{"MQ97", 4, 22241},
	{"MQ98", 4, 22242},
	{"MQ99", 4, 22243},
	{"NB00", 4, 22244},
	{"NB01", 4, 22245},
	{"NB02", 4, 22246},
	{"NB03", 4, 22247},
	{"NB04", 4, 22248},
	{"NB05", 4, 22249},
	{"NB06", 4, 22250},
	{"NB07", 4, 22251},
	{"NB08", 4, 22252},
	{"NB09", 4, 22253},
	{"NB10", 4, 22254},
	{"NB11", 4, 22255},
	{"NB12", 4, 22256},
	{"NB13", 4, 22257},
	{"NB14", 4, 22258},
	{"NB15", 4, 22259},
	{"NB16", 4, 22260},
	{"NB17", 4, 22261},
	{"NB18", 4, 22262},
	{"NB19", 4, 22263},
	{"NB20", 4, 22264},
	{"NB21", 4, 22265},
	{"NB22", 4, 22266},
	{"NB23", 4, 22267},
	{"NB24", 4, 22268},
	{"NB25", 4, 22269},
	{"NB26", 4, 22270},
	{"NB27", 4, 22271},
	{"NB28", 4, 22272},
	{"NB29", 4, 22273},
	{"NB30", 4, 22274},
	{"NB31", 4, 22275},
	{"NB32", 4, 22276},
	{"NB33", 4, 22277},
	{"NB34", 4, 22278},
	{"NB35", 4, 22279},
	{"NB36", 4, 22280},
	{"NB37", 4, 22281},
	{"NB38", 4, 22282},
	{"NB39", 4, 22283},
	{"NB40", 4, 22284},
	{"NB41", 4, 22285},
	{"NB42", 4, 22286},
	{"NB43", 4, 22287},
	{"NB44", 4, 22288},
	{"NB45", 4, 22289},
	{"NB46", 4, 22290},
	{"NB47", 4, 22291},
	{"NB48", 4, 22292},
	{"NB49", 4, 22293},
	{"NB50", 4, 22294},
	{"NB51", 4, 22295},
	{"NB52", 4, 22296},
	{"NB53", 4, 22297},
	{"NB54", 4, 22298},
	{"NB55", 4, 22299},
	{"NB56", 4, 22300},
	{"NB57", 4, 22301},
	{"NB58", 4, 22302},
	{"NB59", 4, 22303},
	{"NB60", 4, 22304},
	{"NB61", 4, 22305},
	{"NB62", 4, 22306},
	{"NB63", 4, 22307},
	{"NB64", 4, 22308},
	{"NB65", 4, 22309},
	{"NB66", 4, 22310},
	{"NB67", 4, 22311},
	{"NB68", 4, 22312},
	{"NB69", 4, 22313},
	{"NB70", 4, 22314},
	{"NB71", 4, 22315},
	{"NB72", 4, 22316},
	{"NB73", 4, 22317},
	{"NB74", 4, 22318},
	{"NB75", 4, 22319},
	{"NB76", 4, 22320},
	{"NB77", 4, 22321},
	{"NB78", 4, 22322},
	{"NB79", 4, 22323},
	{"NB80", 4, 22324},
	{"NB81", 4, 22325},
	{"NB82", 4, 22326},
	{"NB83", 4, 22327},
	{"NB84", 4, 22328},
	{"NB85", 4, 22329},
	{"NB86", 4, 22330},
	{"NB87", 4, 22331},
	{"NB88", 4, 22332},
	{"NB89", 4, 22333},
	{"NB90", 4, 22334},
	{"NB91", 4, 22335},
	{"NB92", 4, 22336},
	{"NB93", 4, 22337},
	{"NB94", 4, 22338},
	{"NB95", 4, 22339},
	{"NB96", 4, 22340},
	{"NB97", 4, 22341},
	{"NB98", 4, 22342},
	{"NB99", 4, 22343},
	{"NC00", 4, 22344},
	{"NC01", 4, 22345},
	{"NC02", 4, 22346},
	{"NC03", 4, 22347},
	{"NC04", 4, 22348},
	{"NC05", 4, 22349},
	{"NC06", 4, 22350},
	{"NC07", 4, 22351},
	{"NC08", 4, 22352},
	{"NC09", 4, 22353},
	{"NC10", 4, 22354},
	{"NC11", 4, 22355},
	{"NC12", 4, 22356},
	{"NC13", 4, 22357},
	{"NC14", 4, 22358},
	{"NC15", 4, 22359},
	{"NC16", 4, 22360},
	{"NC17", 4, 22361},
	{"NC18", 4, 22362},
	{"NC19", 4, 22363},
	{"NC20", 4, 22364},
	{"NC21", 4, 22365},
	{"NC22", 4, 22366},
	{"NC23", 4, 22367},
	{"NC24", 4, 22368},
	{"NC25", 4, 22369},
	{"NC26", 4, 22370},
	{"NC27", 4, 22371},
	{"NC28", 4, 22372},
	{"NC29", 4, 22373},
	{"NC30", 4, 22374},
	{"NC31", 4, 22375},
	{"NC32", 4, 22376},
	{"NC33", 4, 22377},
	{"NC34", 4, 22378},
	{"NC35", 4, 22379},
	{"NC36", 4, 22380},
	{"NC37", 4, 22381},
	{"NC38", 4, 22382},
	{"NC39", 4, 22383},
	{"NC40", 4, 22384},
	{"NC41", 4, 22385},
	{"NC42", 4, 22386},
	{"NC43", 4, 22387},
	{"NC44", 4, 22388},
	{"NC45", 4, 22389},
	{"NC46", 4, 22390},
	{"NC47", 4, 22391},
	{"NC48", 4, 22392},
	{"NC49", 4, 22393},
	{"NC50", 4, 22394},
	{"NC51", 4, 22395},
	{"NC52", 4, 22396},
	{"NC53", 4, 22397},
	{"NC54", 4, 22398},
	{"NC55", 4, 22399},
	{"NC56", 4, 22400},
	{"NC57", 4, 22401},
	{"NC58", 4, 22402},
	{"NC59", 4, 22403},
	{"NC60", 4, 22404},
	{"NC61", 4, 22405},
	{"NC62", 4, 22406},
	{"NC63", 4, 22407},
	{"NC64", 4, 22408},
	{"NC65", 4, 22409},
	{"NC66", 4, 22410},
	{"NC67", 4, 22411},
	{"NC68", 4, 22412},
	{"NC69", 4, 22413},
	{"NC70", 4, 22414},
	{"NC71", 4, 22415},
	{"NC72", 4, 22416},
	{"NC73", 4, 22417},
	{"NC74", 4, 22418},
	{"NC75", 4, 22419},
	{"NC76", 4, 22420},
	{"NC77", 4, 22421},
	{"NC78", 4, 22422},
	{"NC79", 4, 22423},
	{"NC80", 4, 22424},
	{"NC81", 4, 22425},
	{"NC82", 4, 22426},
	{"NC83", 4, 22427},
	{"NC84", 4, 22428},
	{"NC85", 4, 22429},
	{"NC86", 4, 22430},
	{"NC87", 4, 22431},
	{"NC88", 4, 22432},
	{"NC89", 4, 22433},
	{"NC90", 4, 22434},
	{"NC91", 4, 22435},
	{"NC92", 4, 22436},
	{"NC93", 4, 22437},
	{"NC94", 4, 22438},
	{"NC95", 4, 22439},
	{"NC96", 4, 22440},
	{"NC97", 4, 22441},
	{"NC98", 4, 22442},
	{"NC99", 4, 22443},
	{"NJ00", 4, 22444},
	{"NJ01", 4, 22445},
	{"NJ02", 4, 22446},
	{"NJ03", 4, 22447},
	{"NJ04", 4, 22448},
	{"NJ05", 4, 22449},
	{"NJ06", 4, 22450},
	{"NJ07", 4, 22451},
	{"NJ08", 4, 22452},
	{"NJ09", 4, 22453},
	{"NJ10", 4, 22454},
	{"NJ11", 4, 22455},
	{"NJ12", 4, 22456},
	{"NJ13", 4, 22457},
	{"NJ14", 4, 22458},
	{"NJ15", 4, 22459},
	{"NJ16", 4, 22460},
	{"NJ17", 4, 22461},
	{"NJ18", 4, 22462},
	{"NJ19", 4, 22463},
	{"NJ20", 4, 22464},
	{"NJ21", 4, 22465},
	{"NJ22", 4, 22466},
	{"NJ23", 4, 22467},
	{"NJ24", 4, 22468},
	{"NJ25", 4, 22469},
	{"NJ26", 4, 22470},
	{"NJ27", 4, 22471},
	{"NJ28", 4, 22472},
	{"NJ29", 4, 22473},
	{"NJ30", 4, 22474},
	{"NJ31", 4, 22475},
	{"NJ32", 4, 22476},
	{"NJ33", 4, 22477},
	{"NJ34", 4, 22478},
	{"NJ35", 4, 22479},
	{"NJ36", 4, 22480},
	{"NJ37", 4, 22481},
	{"NJ38", 4, 22482},
	{"NJ39", 4, 22483},
	{"NJ40", 4, 22484},
	{"NJ41", 4, 22485},
	{"NJ42", 4, 22486},
	{"NJ43", 4, 22487},
	{"NJ44", 4, 22488},
	{"NJ45", 4, 22489},
	{"NJ46", 4, 22490},
	{"NJ47", 4, 22491},
	{"NJ48", 4, 22492},
	{"NJ49", 4, 22493},
	{"NJ50", 4, 22494},
	{"NJ51", 4, 22495},
	{"NJ52", 4, 22496},
	{"NJ53", 4, 22497},
	{"NJ54", 4, 22498},
	{"NJ55", 4, 22499},
	{"NJ56", 4, 22500},
	{"NJ57", 4, 22501},
	{"NJ58", 4, 22502},
	{"NJ59", 4, 22503},
	{"NJ60", 4, 22504},
	{"NJ61", 4, 22505},
	{"NJ62", 4, 22506},
	{"NJ63", 4, 22507},
	{"NJ64", 4, 22508},
	{"NJ65", 4, 22509},
	{"NJ66", 4, 22510},
	{"NJ67", 4, 22511},
	{"NJ68", 4, 22512},
	{"NJ69", 4, 22513},
	{"NJ70", 4, 22514},
	{"NJ71", 4, 22515},
	{"NJ72", 4, 22516},
	{"NJ73", 4, 22517},
	{"NJ74", 4, 22518},
	{"NJ75", 4, 22519},
	{"NJ76", 4, 22520},
	{"NJ77", 4, 22521},
	{"NJ78", 4, 22522},
	{"NJ79", 4, 22523},
	{"NJ80", 4, 22524},
	{"NJ81", 4, 22525},
	{"NJ82", 4, 22526},
	{"NJ83", 4, 22527},
	{"NJ84", 4, 22528},
	{"NJ85", 4, 22529},
	{"NJ86", 4, 22530},
	{"NJ87", 4, 22531},
	{"NJ88", 4, 22532},
	{"NJ89", 4, 22533},
	{"NJ90", 4, 22534},
	{"NJ91", 4, 22535},
	{"NJ92", 4, 22536},
	{"NJ93", 4, 22537},
	{"NJ94", 4, 22538},
	{"NJ95", 4, 22539},
	{"NJ96", 4, 22540},
	{"NJ97", 4, 22541},
	{"NJ98", 4, 22542},
	{"NJ99", 4, 22543},
	{"NK00", 4, 22544},
	{"NK01", 4, 22545},
	{"NK02", 4, 22546},
	{"NK03", 4, 22547},
	{"NK04", 4, 22548},
	{"NK05", 4, 22549},
	{"NK06", 4, 22550},
	{"NK07", 4, 22551},
	{"NK08", 4, 22552},
	{"NK09", 4, 22553},
	{"NK10", 4, 22554},
	{"NK11", 4, 22555},
	{"NK12", 4, 22556},
	{"NK13", 4, 22557},
	{"NK14", 4, 22558},
	{"NK15", 4, 22559},
	{"NK16", 4, 22560},
	{"NK17", 4, 22561},
	{"NK18", 4, 22562},
	{"NK19", 4, 22563},
	{"NK20", 4, 22564},
	{"NK21", 4, 22565},
	{"NK22", 4, 22566},
	{"NK23", 4, 22567},
	{"NK24", 4, 22568},
	{"NK25", 4, 22569},
	{"NK26", 4, 22570},
	{"NK27", 4, 22571},
	{"NK28", 4, 22572},
	{"NK29", 4, 22573},
	{"NK30", 4, 22574},
	{"NK31", 4, 22575},
	{"NK32", 4, 22576},
	{"NK33", 4, 22577},
	{"NK34", 4, 22578},
	{"NK35", 4, 22579},
	{"NK36", 4, 22580},
	{"NK37", 4, 22581},
	{"NK38", 4, 22582},
	{"NK39", 4, 22583},
	{"NK40", 4, 22584},
	{"NK41", 4, 22585},
	{"NK42", 4, 22586},
	{"NK43", 4, 22587},
	{"NK44", 4, 22588},
	{"NK45", 4, 22589},
	{"NK46", 4, 22590},
	{"NK47", 4, 22591},
	{"NK48", 4, 22592},
	{"NK49", 4, 22593},
	{"NK50", 4, 22594},
	{"NK51", 4, 22595},
	{"NK52", 4, 22596},
	{"NK53", 4, 22597},
	{"NK54", 4, 22598},
	{"NK55", 4, 22599},
	{"NK56", 4, 22600},
	{"NK57", 4, 22601},
	{"NK58", 4, 22602},
	{"NK59", 4, 22603},
	{"NK60", 4, 22604},
	{"NK61", 4, 22605},
	{"NK62", 4, 22606},
	{"NK63", 4, 22607},
	{"NK64", 4, 22608},
	{"NK65", 4, 22609},
	{"NK66", 4, 22610},
	{"NK67", 4, 22611},
	{"NK68", 4, 22612},
	{"NK69", 4, 22613},
	{"NK70", 4, 22614},
	{"NK71", 4, 22615},
	{"NK72", 4, 22616},
	{"NK73", 4, 22617},
	{"NK74", 4, 22618},
	{"NK75", 4, 22619},
	{"NK76", 4, 22620},
	{"NK77", 4, 22621},
	{"NK78", 4, 22622},
	{"NK79", 4, 22623},
	{"NK80", 4, 22624},
	{"NK81", 4, 22625},
	{"NK82", 4, 22626},
	{"NK83", 4, 22627},
	{"NK84", 4, 22628},
	{"NK85", 4, 22629},
	{"NK86", 4, 22630},
	{"NK87", 4, 22631},
	{"NK88", 4, 22632},
	{"NK89", 4, 22633},
	{"NK90", 4, 22634},
	{"NK91", 4, 22635},
	{"NK92", 4, 22636},
	{"NK93", 4, 22637},
	{"NK94", 4, 22638},
	{"NK95", 4, 22639},
	{"NK96", 4, 22640},
	{"NK97", 4, 22641},
	{"NK98", 4, 22642},
	{"NK99", 4, 22643},
	{"NL00", 4, 22644},
	{"NL01", 4, 22645},
	{"NL02", 4, 22646},
	{"NL03", 4, 22647},
	{"NL04", 4, 22648},
	{"NL05", 4, 22649},
	{"NL06", 4, 22650},
	{"NL07", 4, 22651},
	{"NL08", 4, 22652},
	{"NL09", 4, 22653},
	{"NL10", 4, 22654},
	{"NL11", 4, 22655},
	{"NL12", 4, 22656},
	{"NL13", 4, 22657},
	{"NL14", 4, 22658},
	{"NL15", 4, 22659},
	{"NL16", 4, 22660},
	{"NL17", 4, 22661},
	{"NL18", 4, 22662},
	{"NL19", 4, 22663},
	{"NL20", 4, 22664},
	{"NL21", 4, 22665},
	{"NL22", 4, 22666},
	{"NL23", 4, 22667},
	{"NL24", 4, 22668},
	{"NL25", 4, 22669},
	{"NL26", 4, 22670},
	{"NL27", 4, 22671},
	{"NL28", 4, 22672},
	{"NL29", 4, 22673},
	{"NL30", 4, 22674},
	{"NL31", 4, 22675},
	{"NL32", 4, 22676},
	{"NL33", 4, 22677},
	{"NL34", 4, 22678},
	{"NL35", 4, 22679},
	{"NL36", 4, 22680},
	{"NL37", 4, 22681},
	{"NL38", 4, 22682},
	{"NL39", 4, 22683},
	{"NL40", 4, 22684},
	{"NL41", 4, 22685},
	{"NL42", 4, 22686},
	{"NL43", 4, 22687},
	{"NL44", 4, 22688},
	{"NL45", 4, 22689},
	{"NL46", 4, 22690},
	{"NL47", 4, 22691},
	{"NL48", 4, 22692},
	{"NL49", 4, 22693},
	{"NL50", 4, 22694},
	{"NL51", 4, 22695},
	{"NL52", 4, 22696},
	{"NL53", 4, 22697},
	{"NL54", 4, 22698},
	{"NL55", 4, 22699},
	{"NL56", 4, 22700},
	{"NL57", 4, 22701},
	{"NL58", 4, 22702},
	{"NL59", 4, 22703},
	{"NL60", 4, 22704},
	{"NL61", 4, 22705},
	{"NL62", 4, 22706},
	{"NL63", 4, 22707},
	{"NL64", 4, 22708},
	{"NL65", 4, 22709},
	{"NL66", 4, 22710},
	{"NL67", 4, 22711},
	{"NL68", 4, 22712},
	{"NL69", 4, 22713},
	{"NL70", 4, 22714},
	{"NL71", 4, 22715},
	{"NL72", 4, 22716},
	{"NL73", 4, 22717},
	{"NL74", 4, 22718},
	{"NL75", 4, 22719},
	{"NL76", 4, 22720},
	{"NL77", 4, 22721},
	{"NL78", 4, 22722},
	{"NL79", 4, 22723},
	{"NL80", 4, 22724},
	{"NL81", 4, 22725},
	{"NL82", 4, 22726},
	{"NL83", 4, 22727},
	{"NL84", 4, 22728},
	{"NL85", 4, 22729},
	{"NL86", 4, 22730},
	{"NL87", 4, 22731},
	{"NL88", 4, 22732},
	{"NL89", 4, 22733},
	{"NL90", 4, 22734},
	{"NL91", 4, 22735},
	{"NL92", 4, 22736},
	{"NL93", 4, 22737},
	{"NL94", 4, 22738},
	{"NL95", 4, 22739},
	{"NL96", 4, 22740},
	{"NL97", 4, 22741},
	{"NL98", 4, 22742},
	{"NL99", 4, 22743},
	{"NM00", 4, 22744},
	{"NM01", 4, 22745},
	{"NM02", 4, 22746},
	{"NM03", 4, 22747},
	{"NM04", 4, 22748},
	{"NM05", 4, 22749},
	{"NM06", 4, 22750},
	{"NM07", 4, 22751},
	{"NM08", 4, 22752},
	{"NM09", 4, 22753},
	{"NM10", 4, 22754},
	{"NM11", 4, 22755},
	{"NM12", 4, 22756},
	{"NM13", 4, 22757},
	{"NM14", 4, 22758},
	{"NM15", 4, 22759},
	{"NM16", 4, 22760},
	{"NM17", 4, 22761},
	{"NM18", 4, 22762},
	{"NM19", 4, 22763},
	{"NM20", 4, 22764},
	{"NM21", 4, 22765},
	{"NM22", 4, 22766},
	{"NM23", 4, 22767},
	{"NM24", 4, 22768},
	{"NM25", 4, 22769},
	{"NM26", 4, 22770},
	{"NM27", 4, 22771},
	{"NM28", 4, 22772},
	{"NM29", 4, 22773},
	{"NM30", 4, 22774},
	{"NM31", 4, 22775},
	{"NM32", 4, 22776},
	{"NM33", 4, 22777},
	{"NM34", 4, 22778},
	{"NM35", 4, 22779},
	{"NM36", 4, 22780},
	{"NM37", 4, 22781},
	{"NM38", 4, 22782},
	{"NM39", 4, 22783},
	{"NM40", 4, 22784},
	{"NM41", 4, 22785},
	{"NM42", 4, 22786},
	{"NM43", 4, 22787},
	{"NM44", 4, 22788},
	{"NM45", 4, 22789},
	{"NM46", 4, 22790},
	{"NM47", 4, 22791},
	{"NM48", 4, 22792},
	{"NM49", 4, 22793},
	{"NM50", 4, 22794},
	{"NM51", 4, 22795},
	{"NM52", 4, 22796},
	{"NM53", 4, 22797},
	{"NM54", 4, 22798},
	{"NM55", 4, 22799},
	{"NM56", 4, 22800},
	{"NM57", 4, 22801},
	{"NM58", 4, 22802},
	{"NM59", 4, 22803},
	{"NM60", 4, 22804},
	{"NM61", 4, 22805},
	{"NM62", 4, 22806},
	{"NM63", 4, 22807},
	{"NM64", 4, 22808},
	{"NM65", 4, 22809},
	{"NM66", 4, 22810},
	{"NM67", 4, 22811},
	{"NM68", 4, 22812},
	{"NM69", 4, 22813},
	{"NM70", 4, 22814},
	{"NM71", 4, 22815},
	{"NM72", 4, 22816},
	{"NM73", 4, 22817},
	{"NM74", 4, 22818},
	{"NM75", 4, 22819},
	{"NM76", 4, 22820},
	{"NM77", 4, 22821},
	{"NM78", 4, 22822},
	{"NM79", 4, 22823},
	{"NM80", 4, 22824},
	{"NM81", 4, 22825},
	{"NM82", 4, 22826},
	{"NM83", 4, 22827},
	{"NM84", 4, 22828},
	{"NM85", 4, 22829},
	{"NM86", 4, 22830},
	{"NM87", 4, 22831},
	{"NM88", 4, 22832},
	{"NM89", 4, 22833},
	{"NM90", 4, 22834},
	{"NM91", 4, 22835},
	{"NM92", 4, 22836},
	{"NM93", 4, 22837},
	{"NM94", 4, 22838},
	{"NM95", 4, 22839},
	{"NM96", 4, 22840},
	{"NM97", 4, 22841},
	{"NM98", 4, 22842},
	{"NM99", 4, 22843},
	{"NN00", 4, 22844},
	{"NN01", 4, 22845},
	{"NN02", 4, 22846},
	{"NN03", 4, 22847},
	{"NN04", 4, 22848},
	{"NN05", 4, 22849},
	{"NN06", 4, 22850},
	{"NN07", 4, 22851},
	{"NN08", 4, 22852},
	{"NN09", 4, 22853},
	{"NN10", 4, 22854},
	{"NN11", 4, 22855},
	{"NN12", 4, 22856},
	{"NN13", 4, 22857},
	{"NN14", 4, 22858},
	{"NN15", 4, 22859},
	{"NN16", 4, 22860},
	{"NN17", 4, 22861},
	{"NN18", 4, 22862},
	{"NN19", 4, 22863},
	{"NN20", 4, 22864},
	{"NN21", 4, 22865},
	{"NN22", 4, 22866},
	{"NN23", 4, 22867},
	{"NN24", 4, 22868},
	{"NN25", 4, 22869},
	{"NN26", 4, 22870},
	{"NN27", 4, 22871},
	{"NN28", 4, 22872},
	{"NN29", 4, 22873},
	{"NN30", 4, 22874},
	{"NN31", 4, 22875},
	{"NN32", 4, 22876},
	{"NN33", 4, 22877},
	{"NN34", 4, 22878},
	{"NN35", 4, 22879},
	{"NN36", 4, 22880},
	{"NN37", 4, 22881},
	{"NN38", 4, 22882},
	{"NN39", 4, 22883},
	{"NN40", 4, 22884},
	{"NN41", 4, 22885},
	{"NN42", 4, 22886},
	{"NN43", 4, 22887},
	{"NN44", 4, 22888},
	{"NN45", 4, 22889},
	{"NN46", 4, 22890},
	{"NN47", 4, 22891},
	{"NN48", 4, 22892},
	{"NN49", 4, 22893},
	{"NN50", 4, 22894},
	{"NN51", 4, 22895},
	{"NN52", 4, 22896},
	{"NN53", 4, 22897},
	{"NN54", 4, 22898},
	{"NN55", 4, 22899},
	{"NN56", 4, 22900},
	{"NN57", 4, 22901},
	{"NN58", 4, 22902},
	{"NN59", 4, 22903},
	{"NN60", 4, 22904},
	{"NN61", 4, 22905},
	{"NN62", 4, 22906},
	{"NN63", 4, 22907},
	{"NN64", 4, 22908},
	{"NN65", 4, 22909},
	{"NN66", 4, 22910},
	{"NN67", 4, 22911},
	{"NN68", 4, 22912},
	{"NN69", 4, 22913},
	{"NN70", 4, 22914},
	{"NN71", 4, 22915},
	{"NN72", 4, 22916},
	{"NN73", 4, 22917},
	{"NN74", 4, 22918},
	{"NN75", 4, 22919},
	{"NN76", 4, 22920},
	{"NN77", 4, 22921},
	{"NN78", 4, 22922},
	{"NN79", 4, 22923},
	{"NN80", 4, 22924},
	{"NN81", 4, 22925},
	{"NN82", 4, 22926},
	{"NN83", 4, 22927},
	{"NN84", 4, 22928},
	{"NN85", 4, 22929},
	{"NN86", 4, 22930},
	{"NN87", 4, 22931},
	{"NN88", 4, 22932},
	{"NN89", 4, 22933},
	{"NN90", 4, 22934},
	{"NN91", 4, 22935},
	{"NN92", 4, 22936},
	{"NN93", 4, 22937},
	{"NN94", 4, 22938},
	{"NN95", 4, 22939},
	{"NN96", 4, 22940},
	{"NN97", 4, 22941},
	{"NN98", 4, 22942},
	{"NN99", 4, 22943},
	{"NO00", 4, 22944},
	{"NO01", 4, 22945},
	{"NO02", 4, 22946},
	{"NO03", 4, 22947},
	{"NO04", 4, 22948},
	{"NO05", 4, 22949},
	{"NO06", 4, 22950},
	{"NO07", 4, 22951},
	{"NO08", 4, 22952},
	{"NO09", 4, 22953},
	{"NO10", 4, 22954},
	{"NO11", 4, 22955},
	{"NO12", 4, 22956},
	{"NO13", 4, 22957},
	{"NO14", 4, 22958},
	{"NO15", 4, 22959},
	{"NO16", 4, 22960},
	{"NO17", 4, 22961},
	{"NO18", 4, 22962},
	{"NO19", 4, 22963},
	{"NO20", 4, 22964},
	{"NO21", 4, 22965},
	{"NO22", 4, 22966},
	{"NO23", 4, 22967},
	{"NO24", 4, 22968},
	{"NO25", 4, 22969},
	{"NO26", 4, 22970},
	{"NO27", 4, 22971},
	{"NO28", 4, 22972},
	{"NO29", 4, 22973},
	{"NO30", 4, 22974},
	{"NO31", 4, 22975},
	{"NO32", 4, 22976},
	{"NO33", 4, 22977},
	{"NO34", 4, 22978},
	{"NO35", 4, 22979},
	{"NO36", 4, 22980},
	{"NO37", 4, 22981},
	{"NO38", 4, 22982},
	{"NO39", 4, 22983},
	{"NO40", 4, 22984},
	{"NO41", 4, 22985},
	{"NO42", 4, 22986},
	{"NO43", 4, 22987},
	{"NO44", 4, 22988},
	{"NO45", 4, 22989},
	{"NO46", 4, 22990},
	{"NO47", 4, 22991},
	{"NO48", 4, 22992},
	{"NO49", 4, 22993},
	{"NO50", 4, 22994},
	{"NO51", 4, 22995},
	{"NO52", 4, 22996},
	{"NO53", 4, 22997},
	{"NO54", 4, 22998},
	{"NO55", 4, 22999},
	{"NO56", 4, 23000},
	{"NO57", 4, 23001},
	{"NO58", 4, 23002},
	{"NO59", 4, 23003},
	{"NO60", 4, 23004},
	{"NO61", 4, 23005},
	{"NO62", 4, 23006},
	{"NO63", 4, 23007},
	{"NO64", 4, 23008},
	{"NO65", 4, 23009},
	{"NO66", 4, 23010},
	{"NO67", 4, 23011},
	{"NO68", 4, 23012},
	{"NO69", 4, 23013},
	{"NO70", 4, 23014},
	{"NO71", 4, 23015},
	{"NO72", 4, 23016},
	{"NO73", 4, 23017},
	{"NO74", 4, 23018},
	{"NO75", 4, 23019},
	{"NO76", 4, 23020},
	{"NO77", 4, 23021},
	{"NO78", 4, 23022},
	{"NO79", 4, 23023},
	{"NO80", 4, 23024},
	{"NO81", 4, 23025},
	{"NO82", 4, 23026},
	{"NO83", 4, 23027},
	{"NO84", 4, 23028},
	{"NO85", 4, 23029},
	{"NO86", 4, 23030},
	{"NO87", 4, 23031},
	{"NO88", 4, 23032},
	{"NO89", 4, 23033},
	{"NO90", 4, 23034},
	{"NO91", 4, 23035},
	{"NO92", 4, 23036},
	{"NO93", 4, 23037},
	{"NO94", 4, 23038},
	{"NO95", 4, 23039},
	{"NO96", 4, 23040},
	{"NO97", 4, 23041},
	{"NO98", 4, 23042},
	{"NO99", 4, 23043},
	{"NP00", 4, 23044},
	{"NP01", 4, 23045},
	{"NP02", 4, 23046},
	{"NP03", 4, 23047},
	{"NP04", 4, 23048},
	{"NP05", 4, 23049},
	{"NP06", 4, 23050},
	{"NP07", 4, 23051},
	{"NP08", 4, 23052},
	{"NP09", 4, 23053},
	{"NP10", 4, 23054},
	{"NP11", 4, 23055},
	{"NP12", 4, 23056},
	{"NP13", 4, 23057},
	{"NP14", 4, 23058},
	{"NP15", 4, 23059},
	{"NP16", 4, 23060},
	{"NP17", 4, 23061},
	{"NP18", 4, 23062},
	{"NP19", 4, 23063},
	{"NP20", 4, 23064},
	{"NP21", 4, 23065},
	{"NP22", 4, 23066},
	{"NP23", 4, 23067},
	{"NP24", 4, 23068},
	{"NP25", 4, 23069},
	{"NP26", 4, 23070},
	{"NP27", 4, 23071},
	{"NP28", 4, 23072},
	{"NP29", 4, 23073},
	{"NP30", 4, 23074},
	{"NP31", 4, 23075},
	{"NP32", 4, 23076},
	{"NP33", 4, 23077},
	{"NP34", 4, 23078},
	{"NP35", 4, 23079},
	{"NP36", 4, 23080},
	{"NP37", 4, 23081},
	{"NP38", 4, 23082},
	{"NP39", 4, 23083},
	{"NP40", 4, 23084},
	{"NP41", 4, 23085},
	{"NP42", 4, 23086},
	{"NP43", 4, 23087},
	{"NP44", 4, 23088},
	{"NP45", 4, 23089},
	{"NP46", 4, 23090},
	{"NP47", 4, 23091},
	{"NP48", 4, 23092},
	{"NP49", 4, 23093},
	{"NP50", 4, 23094},
	{"NP51", 4, 23095},
	{"NP52", 4, 23096},
	{"NP53", 4, 23097},
	{"NP54", 4, 23098},
	{"NP55", 4, 23099},
	{"NP56", 4, 23100},
	{"NP57", 4, 23101},
	{"NP58", 4, 23102},
	{"NP59", 4, 23103},
	{"NP60", 4, 23104},
	{"NP61", 4, 23105},
	{"NP62", 4, 23106},
	{"NP63", 4, 23107},
	{"NP64", 4, 23108},
	{"NP65", 4, 23109},
	{"NP66", 4, 23110},
	{"NP67", 4, 23111},
	{"NP68", 4, 23112},
	{"NP69", 4, 23113},
	{"NP70", 4, 23114},
	{"NP71", 4, 23115},
	{"NP72", 4, 23116},
	{"NP73", 4, 23117},
	{"NP74", 4, 23118},
	{"NP75", 4, 23119},
	{"NP76", 4, 23120},
	{"NP77", 4, 23121},
	{"NP78", 4, 23122},
	{"NP79", 4, 23123},
	{"NP80", 4, 23124},
	{"NP81", 4, 23125},
	{"NP82", 4, 23126},
	{"NP83", 4, 23127},
	{"NP84", 4, 23128},
	{"NP85", 4, 23129},
	{"NP86", 4, 23130},
	{"NP87", 4, 23131},
	{"NP88", 4, 23132},
	{"NP89", 4, 23133},
	{"NP90", 4, 23134},
	{"NP91", 4, 23135},
	{"NP92", 4, 23136},
	{"NP93", 4, 23137},
	{"NP94", 4, 23138},
	{"NP95", 4, 23139},
	{"NP96", 4, 23140},
	{"NP97", 4, 23141},
	{"NP98", 4, 23142},
	{"NP99", 4, 23143},
	{"NQ00", 4, 23144},
	{"NQ01", 4, 23145},
	{"NQ02", 4, 23146},
	{"NQ03", 4, 23147},
	{"NQ04", 4, 23148},
	{"NQ05", 4, 23149},
	{"NQ06", 4, 23150},
	{"NQ07", 4, 23151},
	{"NQ08", 4, 23152},
	{"NQ09", 4, 23153},
	{"NQ10", 4, 23154},
	{"NQ11", 4, 23155},
	{"NQ12", 4, 23156},
	{"NQ13", 4, 23157},
	{"NQ14", 4, 23158},
	{"NQ15", 4, 23159},
	{"NQ16", 4, 23160},
	{"NQ17", 4, 23161},
	{"NQ18", 4, 23162},
	{"NQ19", 4, 23163},
	{"NQ20", 4, 23164},
	{"NQ21", 4, 23165},
	{"NQ22", 4, 23166},
	{"NQ23", 4, 23167},
	{"NQ24", 4, 23168},
	{"NQ25", 4, 23169},
	{"NQ26", 4, 23170},
	{"NQ27", 4, 23171},
	{"NQ28", 4, 23172},
	{"NQ29", 4, 23173},
	{"NQ30", 4, 23174},
	{"NQ31", 4, 23175},
	{"NQ32", 4, 23176},
	{"NQ33", 4, 23177},
	{"NQ34", 4, 23178},
	{"NQ35", 4, 23179},
	{"NQ36", 4, 23180},
	{"NQ37", 4, 23181},
	{"NQ38", 4, 23182},
	{"NQ39", 4, 23183},
	{"NQ40", 4, 23184},
	{"NQ41", 4, 23185},
	{"NQ42", 4, 23186},
	{"NQ43", 4, 23187},
	{"NQ44", 4, 23188},
	{"NQ45", 4, 23189},
	{"NQ46", 4, 23190},
	{"NQ47", 4, 23191},
	{"NQ48", 4, 23192},
	{"NQ49", 4, 23193},
	{"NQ50", 4, 23194},
	{"NQ51", 4, 23195},
	{"NQ52", 4, 23196},
	{"NQ53", 4, 23197},
	{"NQ54", 4, 23198},
	{"NQ55", 4, 23199},
	{"NQ56", 4, 23200},
	{"NQ57", 4, 23201},
	{"NQ58", 4, 23202},
	{"NQ59", 4, 23203},
	{"NQ60", 4, 23204},
	{"NQ61", 4, 23205},
	{"NQ62", 4, 23206},
	{"NQ63", 4, 23207},
	{"NQ64", 4, 23208},
	{"NQ65", 4, 23209},
	{"NQ66", 4, 23210},
	{"NQ67", 4, 23211},
	{"NQ68", 4, 23212},
	{"NQ69", 4, 23213},
	{"NQ70", 4, 23214},
	{"NQ71", 4, 23215},
	{"NQ72", 4, 23216},
	{"NQ73", 4, 23217},
	{"NQ74", 4, 23218},
	{"NQ75", 4, 23219},
	{"NQ76", 4, 23220},
	{"NQ77", 4, 23221},
	{"NQ78", 4, 23222},
	{"NQ79", 4, 23223},
	{"NQ80", 4, 23224},
	{"NQ81", 4, 23225},
	{"NQ82", 4, 23226},
	{"NQ83", 4, 23227},
	{"NQ84", 4, 23228},
	{"NQ85", 4, 23229},
	{"NQ86", 4, 23230},
	{"NQ87", 4, 23231},
	{"NQ88", 4, 23232},
	{"NQ89", 4, 23233},
	{"NQ90", 4, 23234},
	{"NQ91", 4, 23235},
	{"NQ92", 4, 23236},
	{"NQ93", 4, 23237},
	{"NQ94", 4, 23238},
	{"NQ95", 4, 23239},
	{"NQ96", 4, 23240},
	{"NQ97", 4, 23241},
	{"NQ98", 4, 23242},
	{"NQ99", 4, 23243},
	{"OB00", 4, 23244},
	{"OB01", 4, 23245},
	{"OB02", 4, 23246},
	{"OB03", 4, 23247},
	{"OB04", 4, 23248},
	{"OB05", 4, 23249},
	{"OB06", 4, 23250},
	{"OB07", 4, 23251},
	{"OB08", 4, 23252},
	{"OB09", 4, 23253},
	{"OB10", 4, 23254},
	{"OB11", 4, 23255},
	{"OB12", 4, 23256},
	{"OB13", 4, 23257},
	{"OB14", 4, 23258},
	{"OB15", 4, 23259},
	{"OB16", 4, 23260},
	{"OB17", 4, 23261},
	{"OB18", 4, 23262},
	{"OB19", 4, 23263},
	{"OB20", 4, 23264},
	{"OB21", 4, 23265},
	{"OB22", 4, 23266},
	{"OB23", 4, 23267},
	{"OB24", 4, 23268},
	{"OB25", 4, 23269},
	{"OB26", 4, 23270},
	{"OB27", 4, 23271},
	{"OB28", 4, 23272},
	{"OB29", 4, 23273},
	{"OB30", 4, 23274},
	{"OB31", 4, 23275},
	{"OB32", 4, 23276},
	{"OB33", 4, 23277},
	{"OB34", 4, 23278},
	{"OB35", 4, 23279},
	{"OB36", 4, 23280},
	{"OB37", 4, 23281},
	{"OB38", 4, 23282},
	{"OB39", 4, 23283},
	{"OB40", 4, 23284},
	{"OB41", 4, 23285},
	{"OB42", 4, 23286},
	{"OB43", 4, 23287},
	{"OB44", 4, 23288},
	{"OB45", 4, 23289},
	{"OB46", 4, 23290},
	{"OB47", 4, 23291},
	{"OB48", 4, 23292},
	{"OB49", 4, 23293},
	{"OB50", 4, 23294},
	{"OB51", 4, 23295},
	{"OB52", 4, 23296},
	{"OB53", 4, 23297},
	{"OB54", 4, 23298},
	{"OB55", 4, 23299},
	{"OB56", 4, 23300},
	{"OB57", 4, 23301},
	{"OB58", 4, 23302},
	{"OB59", 4, 23303},
	{"OB60", 4, 23304},
	{"OB61", 4, 23305},
	{"OB62", 4, 23306},
	{"OB63", 4, 23307},
	{"OB64", 4, 23308},
	{"OB65", 4, 23309},
	{"OB66", 4, 23310},
	{"OB67", 4, 23311},
	{"OB68", 4, 23312},
	{"OB69", 4, 23313},
	{"OB70", 4, 23314},
	{"OB71", 4, 23315},
	{"OB72", 4, 23316},
	{"OB73", 4, 23317},
	{"OB74", 4, 23318},
	{"OB75", 4, 23319},
	{"OB76", 4, 23320},
	{"OB77", 4, 23321},
	{"OB78", 4, 23322},
	{"OB79", 4, 23323},
	{"OB80", 4, 23324},
	{"OB81", 4, 23325},
	{"OB82", 4, 23326},
	{"OB83", 4, 23327},
	{"OB84", 4, 23328},
	{"OB85", 4, 23329},
	{"OB86", 4, 23330},
	{"OB87", 4, 23331},
	{"OB88", 4, 23332},
	{"OB89", 4, 23333},
	{"OB90", 4, 23334},
	{"OB91", 4, 23335},
	{"OB92", 4, 23336},
	{"OB93", 4, 23337},
	{"OB94", 4, 23338},
	{"OB95", 4, 23339},
	{"OB96", 4, 23340},
	{"OB97", 4, 23341},
	{"OB98", 4, 23342},
	{"OB99", 4, 23343},
	{"OC00", 4, 23344},
	{"OC01", 4, 23345},
	{"OC02", 4, 23346},
	{"OC03", 4, 23347},
	{"OC04", 4, 23348},
	{"OC05", 4, 23349},
	{"OC06", 4, 23350},
	{"OC07", 4, 23351},
	{"OC08", 4, 23352},
	{"OC09", 4, 23353},
	{"OC10", 4, 23354},
	{"OC11", 4, 23355},
	{"OC12", 4, 23356},
	{"OC13", 4, 23357},
	{"OC14", 4, 23358},
	{"OC15", 4, 23359},
	{"OC16", 4, 23360},
	{"OC17", 4, 23361},
	{"OC18", 4, 23362},
	{"OC19", 4, 23363},
	{"OC20", 4, 23364},
	{"OC21", 4, 23365},
	{"OC22", 4, 23366},
	{"OC23", 4, 23367},
	{"OC24", 4, 23368},
	{"OC25", 4, 23369},
	{"OC26", 4, 23370},
	{"OC27", 4, 23371},
	{"OC28", 4, 23372},
	{"OC29", 4, 23373},
	{"OC30", 4, 23374},
	{"OC31", 4, 23375},
	{"OC32", 4, 23376},
	{"OC33", 4, 23377},
	{"OC34", 4, 23378},
	{"OC35", 4, 23379},
	{"OC36", 4, 23380},
	{"OC37", 4, 23381},
	{"OC38", 4, 23382},
	{"OC39", 4, 23383},
	{"OC40", 4, 23384},
	{"OC41", 4, 23385},
	{"OC42", 4, 23386},
	{"OC43", 4, 23387},
	{"OC44", 4, 23388},
	{"OC45", 4, 23389},
	{"OC46", 4, 23390},
	{"OC47", 4, 23391},
	{"OC48", 4, 23392},
	{"OC49", 4, 23393},
	{"OC50", 4, 23394},
	{"OC51", 4, 23395},
	{"OC52", 4, 23396},
	{"OC53", 4, 23397},
	{"OC54", 4, 23398},
	{"OC55", 4, 23399},
	{"OC56", 4, 23400},
	{"OC57", 4, 23401},
	{"OC58", 4, 23402},
	{"OC59", 4, 23403},
	{"OC60", 4, 23404},
	{"OC61", 4, 23405},
	{"OC62", 4, 23406},
	{"OC63", 4, 23407},
	{"OC64", 4, 23408},
	{"OC65", 4, 23409},
	{"OC66", 4, 23410},
	{"OC67", 4, 23411},
	{"OC68", 4, 23412},
	{"OC69", 4, 23413},
	{"OC70", 4, 23414},
	{"OC71", 4, 23415},
	{"OC72", 4, 23416},
	{"OC73", 4, 23417},
	{"OC74", 4, 23418},
	{"OC75", 4, 23419},
	{"OC76", 4, 23420},
	{"OC77", 4, 23421},
	{"OC78", 4, 23422},
	{"OC79", 4, 23423},
	{"OC80", 4, 23424},
	{"OC81", 4, 23425},
	{"OC82", 4, 23426},
	{"OC83", 4, 23427},
	{"OC84", 4, 23428},
	{"OC85", 4, 23429},
	{"OC86", 4, 23430},
	{"OC87", 4, 23431},
	{"OC88", 4, 23432},
	{"OC89", 4, 23433},
	{"OC90", 4, 23434},
	{"OC91", 4, 23435},
	{"OC92", 4, 23436},
	{"OC93", 4, 23437},
	{"OC94", 4, 23438},
	{"OC95", 4, 23439},
	{"OC96", 4, 23440},
	{"OC97", 4, 23441},
	{"OC98", 4, 23442},
	{"OC99", 4, 23443},
	{"OF00", 4, 23444},
	{"OF01", 4, 23445},
	{"OF02", 4, 23446},
	{"OF03", 4, 23447},
	{"OF04", 4, 23448},
	{"OF05", 4, 23449},
	{"OF06", 4, 23450},
	{"OF07", 4, 23451},
	{"OF08", 4, 23452},
	{"OF09", 4, 23453},
	{"OF10", 4, 23454},
	{"OF11", 4, 23455},
	{"OF12", 4, 23456},
	{"OF13", 4, 23457},
	{"OF14", 4, 23458},
	{"OF15", 4, 23459},
	{"OF16", 4, 23460},
	{"OF17", 4, 23461},
	{"OF18", 4, 23462},
	{"OF19", 4, 23463},
	{"OF20", 4, 23464},
	{"OF21", 4, 23465},
	{"OF22", 4, 23466},
	{"OF23", 4, 23467},
	{"OF24", 4, 23468},
	{"OF25", 4, 23469},
	{"OF26", 4, 23470},
	{"OF27", 4, 23471},
	{"OF28", 4, 23472},
	{"OF29", 4, 23473},
	{"OF30", 4, 23474},
	{"OF31", 4, 23475},
	{"OF32", 4, 23476},
	{"OF33", 4, 23477},
	{"OF34", 4, 23478},
	{"OF35", 4, 23479},
	{"OF36", 4, 23480},
	{"OF37", 4, 23481},
	{"OF38", 4, 23482},
	{"OF39", 4, 23483},
	{"OF40", 4, 23484},
	{"OF41", 4, 23485},
	{"OF42", 4, 23486},
	{"OF43", 4, 23487},
	{"OF44", 4, 23488},
	{"OF45", 4, 23489},
	{"OF46", 4, 23490},
	{"OF47", 4, 23491},
	{"OF48", 4, 23492},
	{"OF49", 4, 23493},
	{"OF50", 4, 23494},
	{"OF51", 4, 23495},
	{"OF52", 4, 23496},
	{"OF53", 4, 23497},
	{"OF54", 4, 23498},
	{"OF55", 4, 23499},
	{"OF56", 4, 23500},
	{"OF57", 4, 23501},
	{"OF58", 4, 23502},
	{"OF59", 4, 23503},
	{"OF60", 4, 23504},
	{"OF61", 4, 23505},
	{"OF62", 4, 23506},
	{"OF63", 4, 23507},
	{"OF64", 4, 23508},
	{"OF65", 4, 23509},
	{"OF66", 4, 23510},
	{"OF67", 4, 23511},
	{"OF68", 4, 23512},
	{"OF69", 4, 23513},
	{"OF70", 4, 23514},
	{"OF71", 4, 23515},
	{"OF72", 4, 23516},
	{"OF73", 4, 23517},
	{"OF74", 4, 23518},
	{"OF75", 4, 23519},
	{"OF76", 4, 23520},
	{"OF77", 4, 23521},
	{"OF78", 4, 23522},
	{"OF79", 4, 23523},
	{"OF80", 4, 23524},
	{"OF81", 4, 23525},
	{"OF82", 4, 23526},
	{"OF83", 4, 23527},
	{"OF84", 4, 23528},
	{"OF85", 4, 23529},
	{"OF86", 4, 23530},
	{"OF87", 4, 23531},
	{"OF88", 4, 23532},
	{"OF89", 4, 23533},
	{"OF90", 4, 23534},
	{"OF91", 4, 23535},
	{"OF92", 4, 23536},
	{"OF93", 4, 23537},
	{"OF94", 4, 23538},
	{"OF95", 4, 23539},
	{"OF96", 4, 23540},
	{"OF97", 4, 23541},
	{"OF98", 4, 23542},
	{"OF99", 4, 23543},
	{"OG00", 4, 23544},
	{"OG01", 4, 23545},
	{"OG02", 4, 23546},
	{"OG03", 4, 23547},
	{"OG04", 4, 23548},
	{"OG05", 4, 23549},
	{"OG06", 4, 23550},
	{"OG07", 4, 23551},
	{"OG08", 4, 23552},
	{"OG09", 4, 23553},
	{"OG10", 4, 23554},
	{"OG11", 4, 23555},
	{"OG12", 4, 23556},
	{"OG13", 4, 23557},
	{"OG14", 4, 23558},
	{"OG15", 4, 23559},
	{"OG16", 4, 23560},
	{"OG17", 4, 23561},
	{"OG18", 4, 23562},
	{"OG19", 4, 23563},
	{"OG20", 4, 23564},
	{"OG21", 4, 23565},
	{"OG22", 4, 23566},
	{"OG23", 4, 23567},
	{"OG24", 4, 23568},
	{"OG25", 4, 23569},
	{"OG26", 4, 23570},
	{"OG27", 4, 23571},
	{"OG28", 4, 23572},
	{"OG29", 4, 23573},
	{"OG30", 4, 23574},
	{"OG31", 4, 23575},
	{"OG32", 4, 23576},
	{"OG33", 4, 23577},
	{"OG34", 4, 23578},
	{"OG35", 4, 23579},
	{"OG36", 4, 23580},
	{"OG37", 4, 23581},
	{"OG38", 4, 23582},
	{"OG39", 4, 23583},
	{"OG40", 4, 23584},
	{"OG41", 4, 23585},
	{"OG42", 4, 23586},
	{"OG43", 4, 23587},
	{"OG44", 4, 23588},
	{"OG45", 4, 23589},
	{"OG46", 4, 23590},
	{"OG47", 4, 23591},
	{"OG48", 4, 23592},
	{"OG49", 4, 23593},
	{"OG50", 4, 23594},
	{"OG51", 4, 23595},
	{"OG52", 4, 23596},
	{"OG53", 4, 23597},
	{"OG54", 4, 23598},
	{"OG55", 4, 23599},
	{"OG56", 4, 23600},
	{"OG57", 4, 23601},
	{"OG58", 4, 23602},
	{"OG59", 4, 23603},
	{"OG60", 4, 23604},
	{"OG61", 4, 23605},
	{"OG62", 4, 23606},
	{"OG63", 4, 23607},
	{"OG64", 4, 23608},
	{"OG65", 4, 23609},
	{"OG66", 4, 23610},
	{"OG67", 4, 23611},
	{"OG68", 4, 23612},
	{"OG69", 4, 23613},
	{"OG70", 4, 23614},
	{"OG71", 4, 23615},
	{"OG72", 4, 23616},
	{"OG73", 4, 23617},
	{"OG74", 4, 23618},
	{"OG75", 4, 23619},
	{"OG76", 4, 23620},
	{"OG77", 4, 23621},
	{"OG78", 4, 23622},
	{"OG79", 4, 23623},
	{"OG80", 4, 23624},
	{"OG81", 4, 23625},
	{"OG82", 4, 23626},
	{"OG83", 4, 23627},
	{"OG84", 4, 23628},
	{"OG85", 4, 23629},
	{"OG86", 4, 23630},
	{"OG87", 4, 23631},
	{"OG88", 4, 23632},
	{"OG89", 4, 23633},
	{"OG90", 4, 23634},
	{"OG91", 4, 23635},
	{"OG92", 4, 23636},
	{"OG93", 4, 23637},
	{"OG94", 4, 23638},
	{"OG95", 4, 23639},
	{"OG96", 4, 23640},
	{"OG97", 4, 23641},
	{"OG98", 4, 23642},
	{"OG99", 4, 23643},
	{"OI00", 4, 23644},
	{"OI01", 4, 23645},
	{"OI02", 4, 23646},
	{"OI03", 4, 23647},
	{"OI04", 4, 23648},
	{"OI05", 4, 23649},
	{"OI06", 4, 23650},
	{"OI07", 4, 23651},
	{"OI08", 4, 23652},
	{"OI09", 4, 23653},
	{"OI10", 4, 23654},
	{"OI11", 4, 23655},
	{"OI12", 4, 23656},
	{"OI13", 4, 23657},
	{"OI14", 4, 23658},
	{"OI15", 4, 23659},
	{"OI16", 4, 23660},
	{"OI17", 4, 23661},
	{"OI18", 4, 23662},
	{"OI19", 4, 23663},
	{"OI20", 4, 23664},
	{"OI21", 4, 23665},
	{"OI22", 4, 23666},
	{"OI23", 4, 23667},
	{"OI24", 4, 23668},
	{"OI25", 4, 23669},
	{"OI26", 4, 23670},
	{"OI27", 4, 23671},
	{"OI28", 4, 23672},
	{"OI29", 4, 23673},
	{"OI30", 4, 23674},
	{"OI31", 4, 23675},
	{"OI32", 4, 23676},
	{"OI33", 4, 23677},
	{"OI34", 4, 23678},
	{"OI35", 4, 23679},
	{"OI36", 4, 23680},
	{"OI37", 4, 23681},
	{"OI38", 4, 23682},
	{"OI39", 4, 23683},
	{"OI40", 4, 23684},
	{"OI41", 4, 23685},
	{"OI42", 4, 23686},
	{"OI43", 4, 23687},
	{"OI44", 4, 23688},
	{"OI45", 4, 23689},
	{"OI46", 4, 23690},
	{"OI47", 4, 23691},
	{"OI48", 4, 23692},
	{"OI49", 4, 23693},
	{"OI50", 4, 23694},
	{"OI51", 4, 23695},
	{"OI52", 4, 23696},
	{"OI53", 4, 23697},
	{"OI54", 4, 23698},
	{"OI55", 4, 23699},
	{"OI56", 4, 23700},
	{"OI57", 4, 23701},
	{"OI58", 4, 23702},
	{"OI59", 4, 23703},
	{"OI60", 4, 23704},
	{"OI61", 4, 23705},
	{"OI62", 4, 23706},
	{"OI63", 4, 23707},
	{"OI64", 4, 23708},
	{"OI65", 4, 23709},
	{"OI66", 4, 23710},
	{"OI67", 4, 23711},
	{"OI68", 4, 23712},
	{"OI69", 4, 23713},
	{"OI70", 4, 23714},
	{"OI71", 4, 23715},
	{"OI72", 4, 23716},
	{"OI73", 4, 23717},
	{"OI74", 4, 23718},
	{"OI75", 4, 23719},
	{"OI76", 4, 23720},
	{"OI77", 4, 23721},
	{"OI78", 4, 23722},
	{"OI79", 4, 23723},
	{"OI80", 4, 23724},
	{"OI81", 4, 23725},
	{"OI82", 4, 23726},
	{"OI83", 4, 23727},
	{"OI84", 4, 23728},
	{"OI85", 4, 23729},
	{"OI86", 4, 23730},
	{"OI87", 4, 23731},
	{"OI88", 4, 23732},
	{"OI89", 4, 23733},
	{"OI90", 4, 23734},
	{"OI91", 4, 23735},
	{"OI92", 4, 23736},
	{"OI93", 4, 23737},
	{"OI94", 4, 23738},
	{"OI95", 4, 23739},
	{"OI96", 4, 23740},
	{"OI97", 4, 23741},
	{"OI98", 4, 23742},
	{"OI99", 4, 23743},
	{"OJ00", 4, 23744},
	{"OJ01", 4, 23745},
	{"OJ02", 4, 23746},
	{"OJ03", 4, 23747},
	{"OJ04", 4, 23748},
	{"OJ05", 4, 23749},
	{"OJ06", 4, 23750},
	{"OJ07", 4, 23751},
	{"OJ08", 4, 23752},
	{"OJ09", 4, 23753},
	{"OJ10", 4, 23754},
	{"OJ11", 4, 23755},
	{"OJ12", 4, 23756},
	{"OJ13", 4, 23757},
	{"OJ14", 4, 23758},
	{"OJ15", 4, 23759},
	{"OJ16", 4, 23760},
	{"OJ17", 4, 23761},
	{"OJ18", 4, 23762},
	{"OJ19", 4, 23763},
	{"OJ20", 4, 23764},
	{"OJ21", 4, 23765},
	{"OJ22", 4, 23766},
	{"OJ23", 4, 23767},
	{"OJ24", 4, 23768},
	{"OJ25", 4, 23769},
	{"OJ26", 4, 23770},
	{"OJ27", 4, 23771},
	{"OJ28", 4, 23772},
	{"OJ29", 4, 23773},
	{"OJ30", 4, 23774},
	{"OJ31", 4, 23775},
	{"OJ32", 4, 23776},
	{"OJ33", 4, 23777},
	{"OJ34", 4, 23778},
	{"OJ35", 4, 23779},
	{"OJ36", 4, 23780},
	{"OJ37", 4, 23781},
	{"OJ38", 4, 23782},
	{"OJ39", 4, 23783},
	{"OJ40", 4, 23784},
	{"OJ41", 4, 23785},
	{"OJ42", 4, 23786},
	{"OJ43", 4, 23787},
	{"OJ44", 4, 23788},
	{"OJ45", 4, 23789},
	{"OJ46", 4, 23790},
	{"OJ47", 4, 23791},
	{"OJ48", 4, 23792},
	{"OJ49", 4, 23793},
	{"OJ50", 4, 23794},
	{"OJ51", 4, 23795},
	{"OJ52", 4, 23796},
	{"OJ53", 4, 23797},
	{"OJ54", 4, 23798},
	{"OJ55", 4, 23799},
	{"OJ56", 4, 23800},
	{"OJ57", 4, 23801},
	{"OJ58", 4, 23802},
	{"OJ59", 4, 23803},
	{"OJ60", 4, 23804},
	{"OJ61", 4, 23805},
	{"OJ62", 4, 23806},
	{"OJ63", 4, 23807},
	{"OJ64", 4, 23808},
	{"OJ65", 4, 23809},
	{"OJ66", 4, 23810},
	{"OJ67", 4, 23811},
	{"OJ68", 4, 23812},
	{"OJ69", 4, 23813},
	{"OJ70", 4, 23814},
	{"OJ71", 4, 23815},
	{"OJ72", 4, 23816},
	{"OJ73", 4, 23817},
	{"OJ74", 4, 23818},
	{"OJ75", 4, 23819},
	{"OJ76", 4, 23820},
	{"OJ77", 4, 23821},
	{"OJ78", 4, 23822},
	{"OJ79", 4, 23823},
	{"OJ80", 4, 23824},
	{"OJ81", 4, 23825},
	{"OJ82", 4, 23826},
	{"OJ83", 4, 23827},
	{"OJ84", 4, 23828},
	{"OJ85", 4, 23829},
	{"OJ86", 4, 23830},
	{"OJ87", 4, 23831},
	{"OJ88", 4, 23832},
	{"OJ89", 4, 23833},
	{"OJ90", 4, 23834},
	{"OJ91", 4, 23835},
	{"OJ92", 4, 23836},
	{"OJ93", 4, 23837},
	{"OJ94", 4, 23838},
	{"OJ95", 4, 23839},
	{"OJ96", 4, 23840},
	{"OJ97", 4, 23841},
	{"OJ98", 4, 23842},
	{"OJ99", 4, 23843},
	{"OK00", 4, 23844},
	{"OK01", 4, 23845},
	{"OK02", 4, 23846},
	{"OK03", 4, 23847},
	{"OK04", 4, 23848},
	{"OK05", 4, 23849},
	{"OK06", 4, 23850},
	{"OK07", 4, 23851},
	{"OK08", 4, 23852},
	{"OK09", 4, 23853},
	{"OK10", 4, 23854},
	{"OK11", 4, 23855},
	{"OK12", 4, 23856},
	{"OK13", 4, 23857},
	{"OK14", 4, 23858},
	{"OK15", 4, 23859},
	{"OK16", 4, 23860},
	{"OK17", 4, 23861},
	{"OK18", 4, 23862},
	{"OK19", 4, 23863},
	{"OK20", 4, 23864},
	{"OK21", 4, 23865},
	{"OK22", 4, 23866},
	{"OK23", 4, 23867},
	{"OK24", 4, 23868},
	{"OK25", 4, 23869},
	{"OK26", 4, 23870},
	{"OK27", 4, 23871},
	{"OK28", 4, 23872},
	{"OK29", 4, 23873},
	{"OK30", 4, 23874},
	{"OK31", 4, 23875},
	{"OK32", 4, 23876},
	{"OK33", 4, 23877},
	{"OK34", 4, 23878},
	{"OK35", 4, 23879},
	{"OK36", 4, 23880},
	{"OK37", 4, 23881},
	{"OK38", 4, 23882},
	{"OK39", 4, 23883},
	{"OK40", 4, 23884},
	{"OK41", 4, 23885},
	{"OK42", 4, 23886},
	{"OK43", 4, 23887},
	{"OK44", 4, 23888},
	{"OK45", 4, 23889},
	{"OK46", 4, 23890},
	{"OK47", 4, 23891},
	{"OK48", 4, 23892},
	{"OK49", 4, 23893},
	{"OK50", 4, 23894},
	{"OK51", 4, 23895},
	{"OK52", 4, 23896},
	{"OK53", 4, 23897},
	{"OK54", 4, 23898},
	{"OK55", 4, 23899},
	{"OK56", 4, 23900},
	{"OK57", 4, 23901},
	{"OK58", 4, 23902},
	{"OK59", 4, 23903},
	{"OK60", 4, 23904},
	{"OK61", 4, 23905},
	{"OK62", 4, 23906},
	{"OK63", 4, 23907},
	{"OK64", 4, 23908},
	{"OK65", 4, 23909},
	{"OK66", 4, 23910},
	{"OK67", 4, 23911},
	{"OK68", 4, 23912},
	{"OK69", 4, 23913},
	{"OK70", 4, 23914},
	{"OK71", 4, 23915},
	{"OK72", 4, 23916},
	{"OK73", 4, 23917},
	{"OK74", 4, 23918},
	{"OK75", 4, 23919},
	{"OK76", 4, 23920},
	{"OK77", 4, 23921},
	{"OK78", 4, 23922},
	{"OK79", 4, 23923},
	{"OK80", 4, 23924},
	{"OK81", 4, 23925},
	{"OK82", 4, 23926},
	{"OK83", 4, 23927},
	{"OK84", 4, 23928},
	{"OK85", 4, 23929},
	{"OK86", 4, 23930},
	{"OK87", 4, 23931},
	{"OK88", 4, 23932},
	{"OK89", 4, 23933},
	{"OK90", 4, 23934},
	{"OK91", 4, 23935},
	{"OK92", 4, 23936},
	{"OK93", 4, 23937},
	{"OK94", 4, 23938},
	{"OK95", 4, 23939},
	{"OK96", 4, 23940},
	{"OK97", 4, 23941},
	{"OK98", 4, 23942},
	{"OK99", 4, 23943},
	{"OL00", 4, 23944},
	{"OL01", 4, 23945},
	{"OL02", 4, 23946},
	{"OL03", 4, 23947},
	{"OL04", 4, 23948},
	{"OL05", 4, 23949},
	{"OL06", 4, 23950},
	{"OL07", 4, 23951},
	{"OL08", 4, 23952},
	{"OL09", 4, 23953},
	{"OL10", 4, 23954},
	{"OL11", 4, 23955},
	{"OL12", 4, 23956},
	{"OL13", 4, 23957},
	{"OL14", 4, 23958},
	{"OL15", 4, 23959},
	{"OL16", 4, 23960},
	{"OL17", 4, 23961},
	{"OL18", 4, 23962},
	{"OL19", 4, 23963},
	{"OL20", 4, 23964},
	{"OL21", 4, 23965},
	{"OL22", 4, 23966},
	{"OL23", 4, 23967},
	{"OL24", 4, 23968},
	{"OL25", 4, 23969},
	{"OL26", 4, 23970},
	{"OL27", 4, 23971},
	{"OL28", 4, 23972},
	{"OL29", 4, 23973},
	{"OL30", 4, 23974},
	{"OL31", 4, 23975},
	{"OL32", 4, 23976},
	{"OL33", 4, 23977},
	{"OL34", 4, 23978},
	{"OL35", 4, 23979},
	{"OL36", 4, 23980},
	{"OL37", 4, 23981},
	{"OL38", 4, 23982},
	{"OL39", 4, 23983},
	{"OL40", 4, 23984},
	{"OL41", 4, 23985},
	{"OL42", 4, 23986},
	{"OL43", 4, 23987},
	{"OL44", 4, 23988},
	{"OL45", 4, 23989},
	{"OL46", 4, 23990},
	{"OL47", 4, 23991},
	{"OL48", 4, 23992},
	{"OL49", 4, 23993},
	{"OL50", 4, 23994},
	{"OL51", 4, 23995},
	{"OL52", 4, 23996},
	{"OL53", 4, 23997},
	{"OL54", 4, 23998},
	{"OL55", 4, 23999},
	{"OL56", 4, 24000},
	{"OL57", 4, 24001},
	{"OL58", 4, 24002},
	{"OL59", 4, 24003},
	{"OL60", 4, 24004},
	{"OL61", 4, 24005},
	{"OL62", 4, 24006},
	{"OL63", 4, 24007},
	{"OL64", 4, 24008},
	{"OL65", 4, 24009},
	{"OL66", 4, 24010},
	{"OL67", 4, 24011},
	{"OL68", 4, 24012},
	{"OL69", 4, 24013},
	{"OL70", 4, 24014},
	{"OL71", 4, 24015},
	{"OL72", 4, 24016},
	{"OL73", 4, 24017},
	{"OL74", 4, 24018},
	{"OL75", 4, 24019},
	{"OL76", 4, 24020},
	{"OL77", 4, 24021},
	{"OL78", 4, 24022},
	{"OL79", 4, 24023},
	{"OL80", 4, 24024},
	{"OL81", 4, 24025},
	{"OL82", 4, 24026},
	{"OL83", 4, 24027},
	{"OL84", 4, 24028},
	{"OL85", 4, 24029},
	{"OL86", 4, 24030},
	{"OL87", 4, 24031},
	{"OL88", 4, 24032},
	{"OL89", 4, 24033},
	{"OL90", 4, 24034},
	{"OL91", 4, 24035},
	{"OL92", 4, 24036},
	{"OL93", 4, 24037},
	{"OL94", 4, 24038},
	{"OL95", 4, 24039},
	{"OL96", 4, 24040},
	{"OL97", 4, 24041},
	{"OL98", 4, 24042},
	{"OL99", 4, 24043},
	{"OM00", 4, 24044},
	{"OM01", 4, 24045},
	{"OM02", 4, 24046},
	{"OM03", 4, 24047},
	{"OM04", 4, 24048},
	{"OM05", 4, 24049},
	{"OM06", 4, 24050},
	{"OM07", 4, 24051},
	{"OM08", 4, 24052},
	{"OM09", 4, 24053},
	{"OM10", 4, 24054},
	{"OM11", 4, 24055},
	{"OM12", 4, 24056},
	{"OM13", 4, 24057},
	{"OM14", 4, 24058},
	{"OM15", 4, 24059},
	{"OM16", 4, 24060},
	{"OM17", 4, 24061},
	{"OM18", 4, 24062},
	{"OM19", 4, 24063},
	{"OM20", 4, 24064},
	{"OM21", 4, 24065},
	{"OM22", 4, 24066},
	{"OM23", 4, 24067},
	{"OM24", 4, 24068},
	{"OM25", 4, 24069},
	{"OM26", 4, 24070},
	{"OM27", 4, 24071},
	{"OM28", 4, 24072},
	{"OM29", 4, 24073},
	{"OM30", 4, 24074},
	{"OM31", 4, 24075},
	{"OM32", 4, 24076},
	{"OM33", 4, 24077},
	{"OM34", 4, 24078},
	{"OM35", 4, 24079},
	{"OM36", 4, 24080},
	{"OM37", 4, 24081},
	{"OM38", 4, 24082},
	{"OM39", 4, 24083},
	{"OM40", 4, 24084},
	{"OM41", 4, 24085},
	{"OM42", 4, 24086},
	{"OM43", 4, 24087},
	{"OM44", 4, 24088},
	{"OM45", 4, 24089},
	{"OM46", 4, 24090},
	{"OM47", 4, 24091},
	{"OM48", 4, 24092},
	{"OM49", 4, 24093},
	{"OM50", 4, 24094},
	{"OM51", 4, 24095},
	{"OM52", 4, 24096},
	{"OM53", 4, 24097},
	{"OM54", 4, 24098},
	{"OM55", 4, 24099},
	{"OM56", 4, 24100},
	{"OM57", 4, 24101},
	{"OM58", 4, 24102},
	{"OM59", 4, 24103},
	{"OM60", 4, 24104},
	{"OM61", 4, 24105},
	{"OM62", 4, 24106},
	{"OM63", 4, 24107},
	{"OM64", 4, 24108},
	{"OM65", 4, 24109},
	{"OM66", 4, 24110},
	{"OM67", 4, 24111},
	{"OM68", 4, 24112},
	{"OM69", 4, 24113},
	{"OM70", 4, 24114},
	{"OM71", 4, 24115},
	{"OM72", 4, 24116},
	{"OM73", 4, 24117},
	{"OM74", 4, 24118},
	{"OM75", 4, 24119},
	{"OM76", 4, 24120},
	{"OM77", 4, 24121},
	{"OM78", 4, 24122},
	{"OM79", 4, 24123},
	{"OM80", 4, 24124},
	{"OM81", 4, 24125},
	{"OM82", 4, 24126},
	{"OM83", 4, 24127},
	{"OM84", 4, 24128},
	{"OM85", 4, 24129},
	{"OM86", 4, 24130},
	{"OM87", 4, 24131},
	{"OM88", 4, 24132},
	{"OM89", 4, 24133},
	{"OM90", 4, 24134},
	{"OM91", 4, 24135},
	{"OM92", 4, 24136},
	{"OM93", 4, 24137},
	{"OM94", 4, 24138},
	{"OM95", 4, 24139},
	{"OM96", 4, 24140},
	{"OM97", 4, 24141},
	{"OM98", 4, 24142},
	{"OM99", 4, 24143},
	{"ON00", 4, 24144},
	{"ON01", 4, 24145},
	{"ON02", 4, 24146},
	{"ON03", 4, 24147},
	{"ON04", 4, 24148},
	{"ON05", 4, 24149},
	{"ON06", 4, 24150},
	{"ON07", 4, 24151},
	{"ON08", 4, 24152},
	{"ON09", 4, 24153},
	{"ON10", 4, 24154},
	{"ON11", 4, 24155},
	{"ON12", 4, 24156},
	{"ON13", 4, 24157},
	{"ON14", 4, 24158},
	{"ON15", 4, 24159},
	{"ON16", 4, 24160},
	{"ON17", 4, 24161},
	{"ON18", 4, 24162},
	{"ON19", 4, 24163},
	{"ON20", 4, 24164},
	{"ON21", 4, 24165},
	{"ON22", 4, 24166},
	{"ON23", 4, 24167},
	{"ON24", 4, 24168},
	{"ON25", 4, 24169},
	{"ON26", 4, 24170},
	{"ON27", 4, 24171},
	{"ON28", 4, 24172},
	{"ON29", 4, 24173},
	{"ON30", 4, 24174},
	{"ON31", 4, 24175},
	{"ON32", 4, 24176},
	{"ON33", 4, 24177},
	{"ON34", 4, 24178},
	{"ON35", 4, 24179},
	{"ON36", 4, 24180},
	{"ON37", 4, 24181},
	{"ON38", 4, 24182},
	{"ON39", 4, 24183},
	{"ON40", 4, 24184},
	{"ON41", 4, 24185},
	{"ON42", 4, 24186},
	{"ON43", 4, 24187},
	{"ON44", 4, 24188},
	{"ON45", 4, 24189},
	{"ON46", 4, 24190},
	{"ON47", 4, 24191},
	{"ON48", 4, 24192},
	{"ON49", 4, 24193},
	{"ON50", 4, 24194},
	{"ON51", 4, 24195},
	{"ON52", 4, 24196},
	{"ON53", 4, 24197},
	{"ON54", 4, 24198},
	{"ON55", 4, 24199},
	{"ON56", 4, 24200},
	{"ON57", 4, 24201},
	{"ON58", 4, 24202},
	{"ON59", 4, 24203},
	{"ON60", 4, 24204},
	{"ON61", 4, 24205},
	{"ON62", 4, 24206},
	{"ON63", 4, 24207},
	{"ON64", 4, 24208},
	{"ON65", 4, 24209},
	{"ON66", 4, 24210},
	{"ON67", 4, 24211},
	{"ON68", 4, 24212},
	{"ON69", 4, 24213},
	{"ON70", 4, 24214},
	{"ON71", 4, 24215},
	{"ON72", 4, 24216},
	{"ON73", 4, 24217},
	{"ON74", 4, 24218},
	{"ON75", 4, 24219},
	{"ON76", 4, 24220},
	{"ON77", 4, 24221},
	{"ON78", 4, 24222},
	{"ON79", 4, 24223},
	{"ON80", 4, 24224},
	{"ON81", 4, 24225},
	{"ON82", 4, 24226},
	{"ON83", 4, 24227},
	{"ON84", 4, 24228},
	{"ON85", 4, 24229},
	{"ON86", 4, 24230},
	{"ON87", 4, 24231},
	{"ON88", 4, 24232},
	{"ON89", 4, 24233},
	{"ON90", 4, 24234},
	{"ON91", 4, 24235},
	{"ON92", 4, 24236},
	{"ON93", 4, 24237},
	{"ON94", 4, 24238},
	{"ON95", 4, 24239},
	{"ON96", 4, 24240},
	{"ON97", 4, 24241},
	{"ON98", 4, 24242},
	{"ON99", 4, 24243},
	{"OO00", 4, 24244},
	{"OO01", 4, 24245},
	{"OO02", 4, 24246},
	{"OO03", 4, 24247},
	{"OO04", 4, 24248},
	{"OO05", 4, 24249},
	{"OO06", 4, 24250},
	{"OO07", 4, 24251},
	{"OO08", 4, 24252},
	{"OO09", 4, 24253},
	{"OO10", 4, 24254},
	{"OO11", 4, 24255},
	{"OO12", 4, 24256},
	{"OO13", 4, 24257},
	{"OO14", 4, 24258},
	{"OO15", 4, 24259},
	{"OO16", 4, 24260},
	{"OO17", 4, 24261},
	{"OO18", 4, 24262},
	{"OO19", 4, 24263},
	{"OO20", 4, 24264},
	{"OO21", 4, 24265},
	{"OO22", 4, 24266},
	{"OO23", 4, 24267},
	{"OO24", 4, 24268},
	{"OO25", 4, 24269},
	{"OO26", 4, 24270},
	{"OO27", 4, 24271},
	{"OO28", 4, 24272},
	{"OO29", 4, 24273},
	{"OO30", 4, 24274},
	{"OO31", 4, 24275},
	{"OO32", 4, 24276},
	{"OO33", 4, 24277},
	{"OO34", 4, 24278},
	{"OO35", 4, 24279},
	{"OO36", 4, 24280},
	{"OO37", 4, 24281},
	{"OO38", 4, 24282},
	{"OO39", 4, 24283},
	{"OO40", 4, 24284},
	{"OO41", 4, 24285},
	{"OO42", 4, 24286},
	{"OO43", 4, 24287},
	{"OO44", 4, 24288},
	{"OO45", 4, 24289},
	{"OO46", 4, 24290},
	{"OO47", 4, 24291},
	{"OO48", 4, 24292},
	{"OO49", 4, 24293},
	{"OO50", 4, 24294},
	{"OO51", 4, 24295},
	{"OO52", 4, 24296},
	{"OO53", 4, 24297},
	{"OO54", 4, 24298},
	{"OO55", 4, 24299},
	{"OO56", 4, 24300},
	{"OO57", 4, 24301},
	{"OO58", 4, 24302},
	{"OO59", 4, 24303},
	{"OO60", 4, 24304},
	{"OO61", 4, 24305},
	{"OO62", 4, 24306},
	{"OO63", 4, 24307},
	{"OO64", 4, 24308},
	{"OO65", 4, 24309},
	{"OO66", 4, 24310},
	{"OO67", 4, 24311},
	{"OO68", 4, 24312},
	{"OO69", 4, 24313},
	{"OO70", 4, 24314},
	{"OO71", 4, 24315},
	{"OO72", 4, 24316},
	{"OO73", 4, 24317},
	{"OO74", 4, 24318},
	{"OO75", 4, 24319},
	{"OO76", 4, 24320},
	{"OO77", 4, 24321},
	{"OO78", 4, 24322},
	{"OO79", 4, 24323},
	{"OO80", 4, 24324},
	{"OO81", 4, 24325},
	{"OO82", 4, 24326},
	{"OO83", 4, 24327},
	{"OO84", 4, 24328},
	{"OO85", 4, 24329},
	{"OO86", 4, 24330},
	{"OO87", 4, 24331},
	{"OO88", 4, 24332},
	{"OO89", 4, 24333},
	{"OO90", 4, 24334},
	{"OO91", 4, 24335},
	{"OO92", 4, 24336},
	{"OO93", 4, 24337},
	{"OO94", 4, 24338},
	{"OO95", 4, 24339},
	{"OO96", 4, 24340},
	{"OO97", 4, 24341},
	{"OO98", 4, 24342},
	{"OO99", 4, 24343},
	{"OP00", 4, 24344},
	{"OP01", 4, 24345},
	{"OP02", 4, 24346},
	{"OP03", 4, 24347},
	{"OP04", 4, 24348},
	{"OP05", 4, 24349},
	{"OP06", 4, 24350},
	{"OP07", 4, 24351},
	{"OP08", 4, 24352},
	{"OP09", 4, 24353},
	{"OP10", 4, 24354},
	{"OP11", 4, 24355},
	{"OP12", 4, 24356},
	{"OP13", 4, 24357},
	{"OP14", 4, 24358},
	{"OP15", 4, 24359},
	{"OP16", 4, 24360},
	{"OP17", 4, 24361},
	{"OP18", 4, 24362},
	{"OP19", 4, 24363},
	{"OP20", 4, 24364},
	{"OP21", 4, 24365},
	{"OP22", 4, 24366},
	{"OP23", 4, 24367},
	{"OP24", 4, 24368},
	{"OP25", 4, 24369},
	{"OP26", 4, 24370},
	{"OP27", 4, 24371},
	{"OP28", 4, 24372},
	{"OP29", 4, 24373},
	{"OP30", 4, 24374},
	{"OP31", 4, 24375},
	{"OP32", 4, 24376},
	{"OP33", 4, 24377},
	{"OP34", 4, 24378},
	{"OP35", 4, 24379},
	{"OP36", 4, 24380},
	{"OP37", 4, 24381},
	{"OP38", 4, 24382},
	{"OP39", 4, 24383},
	{"OP40", 4, 24384},
	{"OP41", 4, 24385},
	{"OP42", 4, 24386},
	{"OP43", 4, 24387},
	{"OP44", 4, 24388},
	{"OP45", 4, 24389},
	{"OP46", 4, 24390},
	{"OP47", 4, 24391},
	{"OP48", 4, 24392},
	{"OP49", 4, 24393},
	{"OP50", 4, 24394},
	{"OP51", 4, 24395},
	{"OP52", 4, 24396},
	{"OP53", 4, 24397},
	{"OP54", 4, 24398},
	{"OP55", 4, 24399},
	{"OP56", 4, 24400},
	{"OP57", 4, 24401},
	{"OP58", 4, 24402},
	{"OP59", 4, 24403},
	{"OP60", 4, 24404},
	{"OP61", 4, 24405},
	{"OP62", 4, 24406},
	{"OP63", 4, 24407},
	{"OP64", 4, 24408},
	{"OP65", 4, 24409},
	{"OP66", 4, 24410},
	{"OP67", 4, 24411},
	{"OP68", 4, 24412},
	{"OP69", 4, 24413},
	{"OP70", 4, 24414},
	{"OP71", 4, 24415},
	{"OP72", 4, 24416},
	{"OP73", 4, 24417},
	{"OP74", 4, 24418},
	{"OP75", 4, 24419},
	{"OP76", 4, 24420},
	{"OP77", 4, 24421},
	{"OP78", 4, 24422},
	{"OP79", 4, 24423},
	{"OP80", 4, 24424},
	{"OP81", 4, 24425},
	{"OP82", 4, 24426},
	{"OP83", 4, 24427},
	{"OP84", 4, 24428},
	{"OP85", 4, 24429},
	{"OP86", 4, 24430},
	{"OP87", 4, 24431},
	{"OP88", 4, 24432},
	{"OP89", 4, 24433},
	{"OP90", 4, 24434},
	{"OP91", 4, 24435},
	{"OP92", 4, 24436},
	{"OP93", 4, 24437},
	{"OP94", 4, 24438},
	{"OP95", 4, 24439},
	{"OP96", 4, 24440},
	{"OP97", 4, 24441},
	{"OP98", 4, 24442},
	{"OP99", 4, 24443},
	{"OQ00", 4, 24444},
	{"OQ01", 4, 24445},
	{"OQ02", 4, 24446},
	{"OQ03", 4, 24447},
	{"OQ04", 4, 24448},
	{"OQ05", 4, 24449},
	{"OQ06", 4, 24450},
	{"OQ07", 4, 24451},
	{"OQ08", 4, 24452},
	{"OQ09", 4, 24453},
	{"OQ10", 4, 24454},
	{"OQ11", 4, 24455},
	{"OQ12", 4, 24456},
	{"OQ13", 4, 24457},
	{"OQ14", 4, 24458},
	{"OQ15", 4, 24459},
	{"OQ16", 4, 24460},
	{"OQ17", 4, 24461},
	{"OQ18", 4, 24462},
	{"OQ19", 4, 24463},
	{"OQ20", 4, 24464},
	{"OQ21", 4, 24465},
	{"OQ22", 4, 24466},
	{"OQ23", 4, 24467},
	{"OQ24", 4, 24468},
	{"OQ25", 4, 24469},
	{"OQ26", 4, 24470},
	{"OQ27", 4, 24471},
	{"OQ28", 4, 24472},
	{"OQ29", 4, 24473},
	{"OQ30", 4, 24474},
	{"OQ31", 4, 24475},
	{"OQ32", 4, 24476},
	{"OQ33", 4, 24477},
	{"OQ34", 4, 24478},
	{"OQ35", 4, 24479},
	{"OQ36", 4, 24480},
	{"OQ37", 4, 24481},
	{"OQ38", 4, 24482},
	{"OQ39", 4, 24483},
	{"OQ40", 4, 24484},
	{"OQ41", 4, 24485},
	{"OQ42", 4, 24486},
	{"OQ43", 4, 24487},
	{"OQ44", 4, 24488},
	{"OQ45", 4, 24489},
	{"OQ46", 4, 24490},
	{"OQ47", 4, 24491},
	{"OQ48", 4, 24492},
	{"OQ49", 4, 24493},
	{"OQ50", 4, 24494},
	{"OQ51", 4, 24495},
	{"OQ52", 4, 24496},
	{"OQ53", 4, 24497},
	{"OQ54", 4, 24498},
	{"OQ55", 4, 24499},
	{"OQ56", 4, 24500},
	{"OQ57", 4, 24501},
	{"OQ58", 4, 24502},
	{"OQ59", 4, 24503},
	{"OQ60", 4, 24504},
	{"OQ61", 4, 24505},
	{"OQ62", 4, 24506},
	{"OQ63", 4, 24507},
	{"OQ64", 4, 24508},
	{"OQ65", 4, 24509},
	{"OQ66", 4, 24510},
	{"OQ67", 4, 24511},
	{"OQ68", 4, 24512},
	{"OQ69", 4, 24513},
	{"OQ70", 4, 24514},
	{"OQ71", 4, 24515},
	{"OQ72", 4, 24516},
	{"OQ73", 4, 24517},
	{"OQ74", 4, 24518},
	{"OQ75", 4, 24519},
	{"OQ76", 4, 24520},
	{"OQ77", 4, 24521},
	{"OQ78", 4, 24522},
	{"OQ79", 4, 24523},
	{"OQ80", 4, 24524},
	{"OQ81", 4, 24525},
	{"OQ82", 4, 24526},
	{"OQ83", 4, 24527},
	{"OQ84", 4, 24528},
	{"OQ85", 4, 24529},
	{"OQ86", 4, 24530},
	{"OQ87", 4, 24531},
	{"OQ88", 4, 24532},
	{"OQ89", 4, 24533},
	{"OQ90", 4, 24534},
	{"OQ91", 4, 24535},
	{"OQ92", 4, 24536},
	{"OQ93", 4, 24537},
	{"OQ94", 4, 24538},
	{"OQ95", 4, 24539},
	{"OQ96", 4, 24540},
	{"OQ97", 4, 24541},
	{"OQ98", 4, 24542},
	{"OQ99", 4, 24543},
	{"PB00", 4, 24544},
	{"PB01", 4, 24545},
	{"PB02", 4, 24546},
	{"PB03", 4, 24547},
	{"PB04", 4, 24548},
	{"PB05", 4, 24549},
	{"PB06", 4, 24550},
	{"PB07", 4, 24551},
	{"PB08", 4, 24552},
	{"PB09", 4, 24553},
	{"PB10", 4, 24554},
	{"PB11", 4, 24555},
	{"PB12", 4, 24556},
	{"PB13", 4, 24557},
	{"PB14", 4, 24558},
	{"PB15", 4, 24559},
	{"PB16", 4, 24560},
	{"PB17", 4, 24561},
	{"PB18", 4, 24562},
	{"PB19", 4, 24563},
	{"PB20", 4, 24564},
	{"PB21", 4, 24565},
	{"PB22", 4, 24566},
	{"PB23", 4, 24567},
	{"PB24", 4, 24568},
	{"PB25", 4, 24569},
	{"PB26", 4, 24570},
	{"PB27", 4, 24571},
	{"PB28", 4, 24572},
	{"PB29", 4, 24573},
	{"PB30", 4, 24574},
	{"PB31", 4, 24575},
	{"PB32", 4, 24576},
	{"PB33", 4, 24577},
	{"PB34", 4, 24578},
	{"PB35", 4, 24579},
	{"PB36", 4, 24580},
	{"PB37", 4, 24581},
	{"PB38", 4, 24582},
	{"PB39", 4, 24583},
	{"PB40", 4, 24584},
	{"PB41", 4, 24585},
	{"PB42", 4, 24586},
	{"PB43", 4, 24587},
	{"PB44", 4, 24588},
	{"PB45", 4, 24589},
	{"PB46", 4, 24590},
	{"PB47", 4, 24591},
	{"PB48", 4, 24592},
	{"PB49", 4, 24593},
	{"PB50", 4, 24594},
	{"PB51", 4, 24595},
	{"PB52", 4, 24596},
	{"PB53", 4, 24597},
	{"PB54", 4, 24598},
	{"PB55", 4, 24599},
	{"PB56", 4, 24600},
	{"PB57", 4, 24601},
	{"PB58", 4, 24602},
	{"PB59", 4, 24603},
	{"PB60", 4, 24604},
	{"PB61", 4, 24605},
	{"PB62", 4, 24606},
	{"PB63", 4, 24607},
	{"PB64", 4, 24608},
	{"PB65", 4, 24609},
	{"PB66", 4, 24610},
	{"PB67", 4, 24611},
	{"PB68", 4, 24612},
	{"PB69", 4, 24613},
	{"PB70", 4, 24614},
	{"PB71", 4, 24615},
	{"PB72", 4, 24616},
	{"PB73", 4, 24617},
	{"PB74", 4, 24618},
	{"PB75", 4, 24619},
	{"PB76", 4, 24620},
	{"PB77", 4, 24621},
	{"PB78", 4, 24622},
	{"PB79", 4, 24623},
	{"PB80", 4, 24624},
	{"PB81", 4, 24625},
	{"PB82", 4, 24626},
	{"PB83", 4, 24627},
	{"PB84", 4, 24628},
	{"PB85", 4, 24629},
	{"PB86", 4, 24630},
	{"PB87", 4, 24631},
	{"PB88", 4, 24632},
	{"PB89", 4, 24633},
	{"PB90", 4, 24634},
	{"PB91", 4, 24635},
	{"PB92", 4, 24636},
	{"PB93", 4, 24637},
	{"PB94", 4, 24638},
	{"PB95", 4, 24639},
	{"PB96", 4, 24640},
	{"PB97", 4, 24641},
	{"PB98", 4, 24642},
	{"PB99", 4, 24643},
	{"PC00", 4, 24644},
	{"PC01", 4, 24645},
	{"PC02", 4, 24646},
	{"PC03", 4, 24647},
	{"PC04", 4, 24648},
	{"PC05", 4, 24649},
	{"PC06", 4, 24650},
	{"PC07", 4, 24651},
	{"PC08", 4, 24652},
	{"PC09", 4, 24653},
	{"PC10", 4, 24654},
	{"PC11", 4, 24655},
	{"PC12", 4, 24656},
	{"PC13", 4, 24657},
	{"PC14", 4, 24658},
	{"PC15", 4, 24659},
	{"PC16", 4, 24660},
	{"PC17", 4, 24661},
	{"PC18", 4, 24662},
	{"PC19", 4, 24663},
	{"PC20", 4, 24664},
	{"PC21", 4, 24665},
	{"PC22", 4, 24666},
	{"PC23", 4, 24667},
	{"PC24", 4, 24668},
	{"PC25", 4, 24669},
	{"PC26", 4, 24670},
	{"PC27", 4, 24671},
	{"PC28", 4, 24672},
	{"PC29", 4, 24673},
	{"PC30", 4, 24674},
	{"PC31", 4, 24675},
	{"PC32", 4, 24676},
	{"PC33", 4, 24677},
	{"PC34", 4, 24678},
	{"PC35", 4, 24679},
	{"PC36", 4, 24680},
	{"PC37", 4, 24681},
	{"PC38", 4, 24682},
	{"PC39", 4, 24683},
	{"PC40", 4, 24684},
	{"PC41", 4, 24685},
	{"PC42", 4, 24686},
	{"PC43", 4, 24687},
	{"PC44", 4, 24688},
	{"PC45", 4, 24689},
	{"PC46", 4, 24690},
	{"PC47", 4, 24691},
	{"PC48", 4, 24692},
	{"PC49", 4, 24693},
	{"PC50", 4, 24694},
	{"PC51", 4, 24695},
	{"PC52", 4, 24696},
	{"PC53", 4, 24697},
	{"PC54", 4, 24698},
	{"PC55", 4, 24699},
	{"PC56", 4, 24700},
	{"PC57", 4, 24701},
	{"PC58", 4, 24702},
	{"PC59", 4, 24703},
	{"PC60", 4, 24704},
	{"PC61", 4, 24705},
	{"PC62", 4, 24706},
	{"PC63", 4, 24707},
	{"PC64", 4, 24708},
	{"PC65", 4, 24709},
	{"PC66", 4, 24710},
	{"PC67", 4, 24711},
	{"PC68", 4, 24712},
	{"PC69", 4, 24713},
	{"PC70", 4, 24714},
	{"PC71", 4, 24715},
	{"PC72", 4, 24716},
	{"PC73", 4, 24717},
	{"PC74", 4, 24718},
	{"PC75", 4, 24719},
	{"PC76", 4, 24720},
	{"PC77", 4, 24721},
	{"PC78", 4, 24722},
	{"PC79", 4, 24723},
	{"PC80", 4, 24724},
	{"PC81", 4, 24725},
	{"PC82", 4, 24726},
	{"PC83", 4, 24727},
	{"PC84", 4, 24728},
	{"PC85", 4, 24729},
	{"PC86", 4, 24730},
	{"PC87", 4, 24731},
	{"PC88", 4, 24732},
	{"PC89", 4, 24733},
	{"PC90", 4, 24734},
	{"PC91", 4, 24735},
	{"PC92", 4, 24736},
	{"PC93", 4, 24737},
	{"PC94", 4, 24738},
	{"PC95", 4, 24739},
	{"PC96", 4, 24740},
	{"PC97", 4, 24741},
	{"PC98", 4, 24742},
	{"PC99", 4, 24743},
	{"PF00", 4, 24744},
	{"PF01", 4, 24745},
	{"PF02", 4, 24746},
	{"PF03", 4, 24747},
	{"PF04", 4, 24748},
	{"PF05", 4, 24749},
	{"PF06", 4, 24750},
	{"PF07", 4, 24751},
	{"PF08", 4, 24752},
	{"PF09", 4, 24753},
	{"PF10", 4, 24754},
	{"PF11", 4, 24755},
	{"PF12", 4, 24756},
	{"PF13", 4, 24757},
	{"PF14", 4, 24758},
	{"PF15", 4, 24759},
	{"PF16", 4, 24760},
	{"PF17", 4, 24761},
	{"PF18", 4, 24762},
	{"PF19", 4, 24763},
	{"PF20", 4, 24764},
	{"PF21", 4, 24765},
	{"PF22", 4, 24766},
	{"PF23", 4, 24767},
	{"PF24", 4, 24768},
	{"PF25", 4, 24769},
	{"PF26", 4, 24770},
	{"PF27", 4, 24771},
	{"PF28", 4, 24772},
	{"PF29", 4, 24773},
	{"PF30", 4, 24774},
	{"PF31", 4, 24775},
	{"PF32", 4, 24776},
	{"PF33", 4, 24777},
	{"PF34", 4, 24778},
	{"PF35", 4, 24779},
	{"PF36", 4, 24780},
	{"PF37", 4, 24781},
	{"PF38", 4, 24782},
	{"PF39", 4, 24783},
	{"PF40", 4, 24784},
	{"PF41", 4, 24785},
	{"PF42", 4, 24786},
	{"PF43", 4, 24787},
	{"PF44", 4, 24788},
	{"PF45", 4, 24789},
	{"PF46", 4, 24790},
	{"PF47", 4, 24791},
	{"PF48", 4, 24792},
	{"PF49", 4, 24793},
	{"PF50", 4, 24794},
	{"PF51", 4, 24795},
	{"PF52", 4, 24796},
	{"PF53", 4, 24797},
	{"PF54", 4, 24798},
	{"PF55", 4, 24799},
	{"PF56", 4, 24800},
	{"PF57", 4, 24801},
	{"PF58", 4, 24802},
	{"PF59", 4, 24803},
	{"PF60", 4, 24804},
	{"PF61", 4, 24805},
	{"PF62", 4, 24806},
	{"PF63", 4, 24807},
	{"PF64", 4, 24808},
	{"PF65", 4, 24809},
	{"PF66", 4, 24810},
	{"PF67", 4, 24811},
	{"PF68", 4, 24812},
	{"PF69", 4, 24813},
	{"PF70", 4, 24814},
	{"PF71", 4, 24815},
	{"PF72", 4, 24816},
	{"PF73", 4, 24817},
	{"PF74", 4, 24818},
	{"PF75", 4, 24819},
	{"PF76", 4, 24820},
	{"PF77", 4, 24821},
	{"PF78", 4, 24822},
	{"PF79", 4, 24823},
	{"PF80", 4, 24824},
	{"PF81", 4, 24825},
	{"PF82", 4, 24826},
	{"PF83", 4, 24827},
	{"PF84", 4, 24828},
	{"PF85", 4, 24829},
	{"PF86", 4, 24830},
	{"PF87", 4, 24831},
	{"PF88", 4, 24832},
	{"PF89", 4, 24833},
	{"PF90", 4, 24834},
	{"PF91", 4, 24835},
	{"PF92", 4, 24836},
	{"PF93", 4, 24837},
	{"PF94", 4, 24838},
	{"PF95", 4, 24839},
	{"PF96", 4, 24840},
	{"PF97", 4, 24841},
	{"PF98", 4, 24842},
	{"PF99", 4, 24843},
	{"PG00", 4, 24844},
	{"PG01", 4, 24845},
	{"PG02", 4, 24846},
	{"PG03", 4, 24847},
	{"PG04", 4, 24848},
	{"PG05", 4, 24849},
	{"PG06", 4, 24850},
	{"PG07", 4, 24851},
	{"PG08", 4, 24852},
	{"PG09", 4, 24853},
	{"PG10", 4, 24854},
	{"PG11", 4, 24855},
	{"PG12", 4, 24856},
	{"PG13", 4, 24857},
	{"PG14", 4, 24858},
	{"PG15", 4, 24859},
	{"PG16", 4, 24860},
	{"PG17", 4, 24861},
	{"PG18", 4, 24862},
	{"PG19", 4, 24863},
	{"PG20", 4, 24864},
	{"PG21", 4, 24865},
	{"PG22", 4, 24866},
	{"PG23", 4, 24867},
	{"PG24", 4, 24868},
	{"PG25", 4, 24869},
	{"PG26", 4, 24870},
	{"PG27", 4, 24871},
	{"PG28", 4, 24872},
	{"PG29", 4, 24873},
	{"PG30", 4, 24874},
	{"PG31", 4, 24875},
	{"PG32", 4, 24876},
	{"PG33", 4, 24877},
	{"PG34", 4, 24878},
	{"PG35", 4, 24879},
	{"PG36", 4, 24880},
	{"PG37", 4, 24881},
	{"PG38", 4, 24882},
	{"PG39", 4, 24883},
	{"PG40", 4, 24884},
	{"PG41", 4, 24885},
	{"PG42", 4, 24886},
	{"PG43", 4, 24887},
	{"PG44", 4, 24888},
	{"PG45", 4, 24889},
	{"PG46", 4, 24890},
	{"PG47", 4, 24891},
	{"PG48", 4, 24892},
	{"PG49", 4, 24893},
	{"PG50", 4, 24894},
	{"PG51", 4, 24895},
	{"PG52", 4, 24896},
	{"PG53", 4, 24897},
	{"PG54", 4, 24898},
	{"PG55", 4, 24899},
	{"PG56", 4, 24900},
	{"PG57", 4, 24901},
	{"PG58", 4, 24902},
	{"PG59", 4, 24903},
	{"PG60", 4, 24904},
	{"PG61", 4, 24905},
	{"PG62", 4, 24906},
	{"PG63", 4, 24907},
	{"PG64", 4, 24908},
	{"PG65", 4, 24909},
	{"PG66", 4, 24910},
	{"PG67", 4, 24911},
	{"PG68", 4, 24912},
	{"PG69", 4, 24913},
	{"PG70", 4, 24914},
	{"PG71", 4, 24915},
	{"PG72", 4, 24916},
	{"PG73", 4, 24917},
	{"PG74", 4, 24918},
	{"PG75", 4, 24919},
	{"PG76", 4, 24920},
	{"PG77", 4, 24921},
	{"PG78", 4, 24922},
	{"PG79", 4, 24923},
	{"PG80", 4, 24924},
	{"PG81", 4, 24925},
	{"PG82", 4, 24926},
	{"PG83", 4, 24927},
	{"PG84", 4, 24928},
	{"PG85", 4, 24929},
	{"PG86", 4, 24930},
	{"PG87", 4, 24931},
	{"PG88", 4, 24932},
	{"PG89", 4, 24933},
	{"PG90", 4, 24934},
	{"PG91", 4, 24935},
	{"PG92", 4, 24936},
	{"PG93", 4, 24937},
	{"PG94", 4, 24938},
	{"PG95", 4, 24939},
	{"PG96", 4, 24940},
	{"PG97", 4, 24941},
	{"PG98", 4, 24942},
	{"PG99", 4, 24943},
	{"PH00", 4, 24944},
	{"PH01", 4, 24945},
	{"PH02", 4, 24946},
	{"PH03", 4, 24947},
	{"PH04", 4, 24948},
	{"PH05", 4, 24949},
	{"PH06", 4, 24950},
	{"PH07", 4, 24951},
	{"PH08", 4, 24952},
	{"PH09", 4, 24953},
	{"PH10", 4, 24954},
	{"PH11", 4, 24955},
	{"PH12", 4, 24956},
	{"PH13", 4, 24957},
	{"PH14", 4, 24958},
	{"PH15", 4, 24959},
	{"PH16", 4, 24960},
	{"PH17", 4, 24961},
	{"PH18", 4, 24962},
	{"PH19", 4, 24963},
	{"PH20", 4, 24964},
	{"PH21", 4, 24965},
	{"PH22", 4, 24966},
	{"PH23", 4, 24967},
	{"PH24", 4, 24968},
	{"PH25", 4, 24969},
	{"PH26", 4, 24970},
	{"PH27", 4, 24971},
	{"PH28", 4, 24972},
	{"PH29", 4, 24973},
	{"PH30", 4, 24974},
	{"PH31", 4, 24975},
	{"PH32", 4, 24976},
	{"PH33", 4, 24977},
	{"PH34", 4, 24978},
	{"PH35", 4, 24979},
	{"PH36", 4, 24980},
	{"PH37", 4, 24981},
	{"PH38", 4, 24982},
	{"PH39", 4, 24983},
	{"PH40", 4, 24984},
	{"PH41", 4, 24985},
	{"PH42", 4, 24986},
	{"PH43", 4, 24987},
	{"PH44", 4, 24988},
	{"PH45", 4, 24989},
	{"PH46", 4, 24990},
	{"PH47", 4, 24991},
	{"PH48", 4, 24992},
	{"PH49", 4, 24993},
	{"PH50", 4, 24994},
	{"PH51", 4, 24995},
	{"PH52", 4, 24996},
	{"PH53", 4, 24997},
	{"PH54", 4, 24998},
	{"PH55", 4, 24999},
	{"PH56", 4, 25000},
	{"PH57", 4, 25001},
	{"PH58", 4, 25002},
	{"PH59", 4, 25003},
	{"PH60", 4, 25004},
	{"PH61", 4, 25005},
	{"PH62", 4, 25006},
	{"PH63", 4, 25007},
	{"PH64", 4, 25008},
	{"PH65", 4, 25009},
	{"PH66", 4, 25010},
	{"PH67", 4, 25011},
	{"PH68", 4, 25012},
	{"PH69", 4, 25013},
	{"PH70", 4, 25014},
	{"PH71", 4, 25015},
	{"PH72", 4, 25016},
	{"PH73", 4, 25017},
	{"PH74", 4, 25018},
	{"PH75", 4, 25019},
	{"PH76", 4, 25020},
	{"PH77", 4, 25021},
	{"PH78", 4, 25022},
	{"PH79", 4, 25023},
	{"PH80", 4, 25024},
	{"PH81", 4, 25025},
	{"PH82", 4, 25026},
	{"PH83", 4, 25027},
	{"PH84", 4, 25028},
	{"PH85", 4, 25029},
	{"PH86", 4, 25030},
	{"PH87", 4, 25031},
	{"PH88", 4, 25032},
	{"PH89", 4, 25033},
	{"PH90", 4, 25034},
	{"PH91", 4, 25035},
	{"PH92", 4, 25036},
	{"PH93", 4, 25037},
	{"PH94", 4, 25038},
	{"PH95", 4, 25039},
	{"PH96", 4, 25040},
	{"PH97", 4, 25041},
	{"PH98", 4, 25042},
	{"PH99", 4, 25043},
	{"PI00", 4, 25044},
	{"PI01", 4, 25045},
	{"PI02", 4, 25046},
	{"PI03", 4, 25047},
	{"PI04", 4, 25048},
	{"PI05", 4, 25049},
	{"PI06", 4, 25050},
	{"PI07", 4, 25051},
	{"PI08", 4, 25052},
	{"PI09", 4, 25053},
	{"PI10", 4, 25054},
	{"PI11", 4, 25055},
	{"PI12", 4, 25056},
	{"PI13", 4, 25057},
	{"PI14", 4, 25058},
	{"PI15", 4, 25059},
	{"PI16", 4, 25060},
	{"PI17", 4, 25061},
	{"PI18", 4, 25062},
	{"PI19", 4, 25063},
	{"PI20", 4, 25064},
	{"PI21", 4, 25065},
	{"PI22", 4, 25066},
	{"PI23", 4, 25067},
	{"PI24", 4, 25068},
	{"PI25", 4, 25069},
	{"PI26", 4, 25070},
	{"PI27", 4, 25071},
	{"PI28", 4, 25072},
	{"PI29", 4, 25073},
	{"PI30", 4, 25074},
	{"PI31", 4, 25075},
	{"PI32", 4, 25076},
	{"PI33", 4, 25077},
	{"PI34", 4, 25078},
	{"PI35", 4, 25079},
	{"PI36", 4, 25080},
	{"PI37", 4, 25081},
	{"PI38", 4, 25082},
	{"PI39", 4, 25083},
	{"PI40", 4, 25084},
	{"PI41", 4, 25085},
	{"PI42", 4, 25086},
	{"PI43", 4, 25087},
	{"PI44", 4, 25088},
	{"PI45", 4, 25089},
	{"PI46", 4, 25090},
	{"PI47", 4, 25091},
	{"PI48", 4, 25092},
	{"PI49", 4, 25093},
	{"PI50", 4, 25094},
	{"PI51", 4, 25095},
	{"PI52", 4, 25096},
	{"PI53", 4, 25097},
	{"PI54", 4, 25098},
	{"PI55", 4, 25099},
	{"PI56", 4, 25100},
	{"PI57", 4, 25101},
	{"PI58", 4, 25102},
	{"PI59", 4, 25103},
	{"PI60", 4, 25104},
	{"PI61", 4, 25105},
	{"PI62", 4, 25106},
	{"PI63", 4, 25107},
	{"PI64", 4, 25108},
	{"PI65", 4, 25109},
	{"PI66", 4, 25110},
	{"PI67", 4, 25111},
	{"PI68", 4, 25112},
	{"PI69", 4, 25113},
	{"PI70", 4, 25114},
	{"PI71", 4, 25115},
	{"PI72", 4, 25116},
	{"PI73", 4, 25117},
	{"PI74", 4, 25118},
	{"PI75", 4, 25119},
	{"PI76", 4, 25120},
	{"PI77", 4, 25121},
	{"PI78", 4, 25122},
	{"PI79", 4, 25123},
	{"PI80", 4, 25124},
	{"PI81", 4, 25125},
	{"PI82", 4, 25126},
	{"PI83", 4, 25127},
	{"PI84", 4, 25128},
	{"PI85", 4, 25129},
	{"PI86", 4, 25130},
	{"PI87", 4, 25131},
	{"PI88", 4, 25132},
	{"PI89", 4, 25133},
	{"PI90", 4, 25134},
	{"PI91", 4, 25135},
	{"PI92", 4, 25136},
	{"PI93", 4, 25137},
	{"PI94", 4, 25138},
	{"PI95", 4, 25139},
	{"PI96", 4, 25140},
	{"PI97", 4, 25141},
	{"PI98", 4, 25142},
	{"PI99", 4, 25143},
	{"PJ00", 4, 25144},
	{"PJ01", 4, 25145},
	{"PJ02", 4, 25146},
	{"PJ03", 4, 25147},
	{"PJ04", 4, 25148},
	{"PJ05", 4, 25149},
	{"PJ06", 4, 25150},
	{"PJ07", 4, 25151},
	{"PJ08", 4, 25152},
	{"PJ09", 4, 25153},
	{"PJ10", 4, 25154},
	{"PJ11", 4, 25155},
	{"PJ12", 4, 25156},
	{"PJ13", 4, 25157},
	{"PJ14", 4, 25158},
	{"PJ15", 4, 25159},
	{"PJ16", 4, 25160},
	{"PJ17", 4, 25161},
	{"PJ18", 4, 25162},
	{"PJ19", 4, 25163},
	{"PJ20", 4, 25164},
	{"PJ21", 4, 25165},
	{"PJ22", 4, 25166},
	{"PJ23", 4, 25167},
	{"PJ24", 4, 25168},
	{"PJ25", 4, 25169},
	{"PJ26", 4, 25170},
	{"PJ27", 4, 25171},
	{"PJ28", 4, 25172},
	{"PJ29", 4, 25173},
	{"PJ30", 4, 25174},
	{"PJ31", 4, 25175},
	{"PJ32", 4, 25176},
	{"PJ33", 4, 25177},
	{"PJ34", 4, 25178},
	{"PJ35", 4, 25179},
	{"PJ36", 4, 25180},
	{"PJ37", 4, 25181},
	{"PJ38", 4, 25182},
	{"PJ39", 4, 25183},
	{"PJ40", 4, 25184},
	{"PJ41", 4, 25185},
	{"PJ42", 4, 25186},
	{"PJ43", 4, 25187},
	{"PJ44", 4, 25188},
	{"PJ45", 4, 25189},
	{"PJ46", 4, 25190},
	{"PJ47", 4, 25191},
	{"PJ48", 4, 25192},
	{"PJ49", 4, 25193},
	{"PJ50", 4, 25194},
	{"PJ51", 4, 25195},
	{"PJ52", 4, 25196},
	{"PJ53", 4, 25197},
	{"PJ54", 4, 25198},
	{"PJ55", 4, 25199},
	{"PJ56", 4, 25200},
	{"PJ57", 4, 25201},
	{"PJ58", 4, 25202},
	{"PJ59", 4, 25203},
	{"PJ60", 4, 25204},
	{"PJ61", 4, 25205},
	{"PJ62", 4, 25206},
	{"PJ63", 4, 25207},
	{"PJ64", 4, 25208},
	{"PJ65", 4, 25209},
	{"PJ66", 4, 25210},
	{"PJ67", 4, 25211},
	{"PJ68", 4, 25212},
	{"PJ69", 4, 25213},
	{"PJ70", 4, 25214},
	{"PJ71", 4, 25215},
	{"PJ72", 4, 25216},
	{"PJ73", 4, 25217},
	{"PJ74", 4, 25218},
	{"PJ75", 4, 25219},
	{"PJ76", 4, 25220},
	{"PJ77", 4, 25221},
	{"PJ78", 4, 25222},
	{"PJ79", 4, 25223},
	{"PJ80", 4, 25224},
	{"PJ81", 4, 25225},
	{"PJ82", 4, 25226},
	{"PJ83", 4, 25227},
	{"PJ84", 4, 25228},
	{"PJ85", 4, 25229},
	{"PJ86", 4, 25230},
	{"PJ87", 4, 25231},
	{"PJ88", 4, 25232},
	{"PJ89", 4, 25233},
	{"PJ90", 4, 25234},
	{"PJ91", 4, 25235},
	{"PJ92", 4, 25236},
	{"PJ93", 4, 25237},
	{"PJ94", 4, 25238},
	{"PJ95", 4, 25239},
	{"PJ96", 4, 25240},
	{"PJ97", 4, 25241},
	{"PJ98", 4, 25242},
	{"PJ99", 4, 25243},
	{"PK00", 4, 25244},
	{"PK01", 4, 25245},
	{"PK02", 4, 25246},
	{"PK03", 4, 25247},
	{"PK04", 4, 25248},
	{"PK05", 4, 25249},
	{"PK06", 4, 25250},
	{"PK07", 4, 25251},
	{"PK08", 4, 25252},
	{"PK09", 4, 25253},
	{"PK10", 4, 25254},
	{"PK11", 4, 25255},
	{"PK12", 4, 25256},
	{"PK13", 4, 25257},
	{"PK14", 4, 25258},
	{"PK15", 4, 25259},
	{"PK16", 4, 25260},
	{"PK17", 4, 25261},
	{"PK18", 4, 25262},
	{"PK19", 4, 25263},
	{"PK20", 4, 25264},
	{"PK21", 4, 25265},
	{"PK22", 4, 25266},
	{"PK23", 4, 25267},
	{"PK24", 4, 25268},
	{"PK25", 4, 25269},
	{"PK26", 4, 25270},
	{"PK27", 4, 25271},
	{"PK28", 4, 25272},
	{"PK29", 4, 25273},
	{"PK30", 4, 25274},
	{"PK31", 4, 25275},
	{"PK32", 4, 25276},
	{"PK33", 4, 25277},
	{"PK34", 4, 25278},
	{"PK35", 4, 25279},
	{"PK36", 4, 25280},
	{"PK37", 4, 25281},
	{"PK38", 4, 25282},
	{"PK39", 4, 25283},
	{"PK40", 4, 25284},
	{"PK41", 4, 25285},
	{"PK42", 4, 25286},
	{"PK43", 4, 25287},
	{"PK44", 4, 25288},
	{"PK45", 4, 25289},
	{"PK46", 4, 25290},
	{"PK47", 4, 25291},
	{"PK48", 4, 25292},
	{"PK49", 4, 25293},
	{"PK50", 4, 25294},
	{"PK51", 4, 25295},
	{"PK52", 4, 25296},
	{"PK53", 4, 25297},
	{"PK54", 4, 25298},
	{"PK55", 4, 25299},
	{"PK56", 4, 25300},
	{"PK57", 4, 25301},
	{"PK58", 4, 25302},
	{"PK59", 4, 25303},
	{"PK60", 4, 25304},
	{"PK61", 4, 25305},
	{"PK62", 4, 25306},
	{"PK63", 4, 25307},
	{"PK64", 4, 25308},
	{"PK65", 4, 25309},
	{"PK66", 4, 25310},
	{"PK67", 4, 25311},
	{"PK68", 4, 25312},
	{"PK69", 4, 25313},
	{"PK70", 4, 25314},
	{"PK71", 4, 25315},
	{"PK72", 4, 25316},
	{"PK73", 4, 25317},
	{"PK74", 4, 25318},
	{"PK75", 4, 25319},
	{"PK76", 4, 25320},
	{"PK77", 4, 25321},
	{"PK78", 4, 25322},
	{"PK79", 4, 25323},
	{"PK80", 4, 25324},
	{"PK81", 4, 25325},
	{"PK82", 4, 25326},
	{"PK83", 4, 25327},
	{"PK84", 4, 25328},
	{"PK85", 4, 25329},
	{"PK86", 4, 25330},
	{"PK87", 4, 25331},
	{"PK88", 4, 25332},
	{"PK89", 4, 25333},
	{"PK90", 4, 25334},
	{"PK91", 4, 25335},
	{"PK92", 4, 25336},
	{"PK93", 4, 25337},
	{"PK94", 4, 25338},
	{"PK95", 4, 25339},
	{"PK96", 4, 25340},
	{"PK97", 4, 25341},
	{"PK98", 4, 25342},
	{"PK99", 4, 25343},
	{"PL00", 4, 25344},
	{"PL01", 4, 25345},
	{"PL02", 4, 25346},
	{"PL03", 4, 25347},
	{"PL04", 4, 25348},
	{"PL05", 4, 25349},
	{"PL06", 4, 25350},
	{"PL07", 4, 25351},
	{"PL08", 4, 25352},
	{"PL09", 4, 25353},
	{"PL10", 4, 25354},
	{"PL11", 4, 25355},
	{"PL12", 4, 25356},
	{"PL13", 4, 25357},
	{"PL14", 4, 25358},
	{"PL15", 4, 25359},
	{"PL16", 4, 25360},
	{"PL17", 4, 25361},
	{"PL18", 4, 25362},
	{"PL19", 4, 25363},
	{"PL20", 4, 25364},
	{"PL21", 4, 25365},
	{"PL22", 4, 25366},
	{"PL23", 4, 25367},
	{"PL24", 4, 25368},
	{"PL25", 4, 25369},
	{"PL26", 4, 25370},
	{"PL27", 4, 25371},
	{"PL28", 4, 25372},
	{"PL29", 4, 25373},
	{"PL30", 4, 25374},
	{"PL31", 4, 25375},
	{"PL32", 4, 25376},
	{"PL33", 4, 25377},
	{"PL34", 4, 25378},
	{"PL35", 4, 25379},
	{"PL36", 4, 25380},
	{"PL37", 4, 25381},
	{"PL38", 4, 25382},
	{"PL39", 4, 25383},
	{"PL40", 4, 25384},
	{"PL41", 4, 25385},
	{"PL42", 4, 25386},
	{"PL43", 4, 25387},
	{"PL44", 4, 25388},
	{"PL45", 4, 25389},
	{"PL46", 4, 25390},
	{"PL47", 4, 25391},
	{"PL48", 4, 25392},
	{"PL49", 4, 25393},
	{"PL50", 4, 25394},
	{"PL51", 4, 25395},
	{"PL52", 4, 25396},
	{"PL53", 4, 25397},
	{"PL54", 4, 25398},
	{"PL55", 4, 25399},
	{"PL56", 4, 25400},
	{"PL57", 4, 25401},
	{"PL58", 4, 25402},
	{"PL59", 4, 25403},
	{"PL60", 4, 25404},
	{"PL61", 4, 25405},
	{"PL62", 4, 25406},
	{"PL63", 4, 25407},
	{"PL64", 4, 25408},
	{"PL65", 4, 25409},
	{"PL66", 4, 25410},
	{"PL67", 4, 25411},
	{"PL68", 4, 25412},
	{"PL69", 4, 25413},
	{"PL70", 4, 25414},
	{"PL71", 4, 25415},
	{"PL72", 4, 25416},
	{"PL73", 4, 25417},
	{"PL74", 4, 25418},
	{"PL75", 4, 25419},
	{"PL76", 4, 25420},
	{"PL77", 4, 25421},
	{"PL78", 4, 25422},
	{"PL79", 4, 25423},
	{"PL80", 4, 25424},
	{"PL81", 4, 25425},
	{"PL82", 4, 25426},
	{"PL83", 4, 25427},
	{"PL84", 4, 25428},
	{"PL85", 4, 25429},
	{"PL86", 4, 25430},
	{"PL87", 4, 25431},
	{"PL88", 4, 25432},
	{"PL89", 4, 25433},
	{"PL90", 4, 25434},
	{"PL91", 4, 25435},
	{"PL92", 4, 25436},
	{"PL93", 4, 25437},
	{"PL94", 4, 25438},
	{"PL95", 4, 25439},
	{"PL96", 4, 25440},
	{"PL97", 4, 25441},
	{"PL98", 4, 25442},
	{"PL99", 4, 25443},
	{"PM00", 4, 25444},
	{"PM01", 4, 25445},
	{"PM02", 4, 25446},
	{"PM03", 4, 25447},
	{"PM04", 4, 25448},
	{"PM05", 4, 25449},
	{"PM06", 4, 25450},
	{"PM07", 4, 25451},
	{"PM08", 4, 25452},
	{"PM09", 4, 25453},
	{"PM10", 4, 25454},
	{"PM11", 4, 25455},
	{"PM12", 4, 25456},
	{"PM13", 4, 25457},
	{"PM14", 4, 25458},
	{"PM15", 4, 25459},
	{"PM16", 4, 25460},
	{"PM17", 4, 25461},
	{"PM18", 4, 25462},
	{"PM19", 4, 25463},
	{"PM20", 4, 25464},
	{"PM21", 4, 25465},
	{"PM22", 4, 25466},
	{"PM23", 4, 25467},
	{"PM24", 4, 25468},
	{"PM25", 4, 25469},
	{"PM26", 4, 25470},
	{"PM27", 4, 25471},
	{"PM28", 4, 25472},
	{"PM29", 4, 25473},
	{"PM30", 4, 25474},
	{"PM31", 4, 25475},
	{"PM32", 4, 25476},
	{"PM33", 4, 25477},
	{"PM34", 4, 25478},
	{"PM35", 4, 25479},
	{"PM36", 4, 25480},
	{"PM37", 4, 25481},
	{"PM38", 4, 25482},
	{"PM39", 4, 25483},
	{"PM40", 4, 25484},
	{"PM41", 4, 25485},
	{"PM42", 4, 25486},
	{"PM43", 4, 25487},
	{"PM44", 4, 25488},
	{"PM45", 4, 25489},
	{"PM46", 4, 25490},
	{"PM47", 4, 25491},
	{"PM48", 4, 25492},
	{"PM49", 4, 25493},
	{"PM50", 4, 25494},
	{"PM51", 4, 25495},
	{"PM52", 4, 25496},
	{"PM53", 4, 25497},
	{"PM54", 4, 25498},
	{"PM55", 4, 25499},
	{"PM56", 4, 25500},
	{"PM57", 4, 25501},
	{"PM58", 4, 25502},
	{"PM59", 4, 25503},
	{"PM60", 4, 25504},
	{"PM61", 4, 25505},
	{"PM62", 4, 25506},
	{"PM63", 4, 25507},
	{"PM64", 4, 25508},
	{"PM65", 4, 25509},
	{"PM66", 4, 25510},
	{"PM67", 4, 25511},
	{"PM68", 4, 25512},
	{"PM69", 4, 25513},
	{"PM70", 4, 25514},
	{"PM71", 4, 25515},
	{"PM72", 4, 25516},
	{"PM73", 4, 25517},
	{"PM74", 4, 25518},
	{"PM75", 4, 25519},
	{"PM76", 4, 25520},
	{"PM77", 4, 25521},
	{"PM78", 4, 25522},
	{"PM79", 4, 25523},
	{"PM80", 4, 25524},
	{"PM81", 4, 25525},
	{"PM82", 4, 25526},
	{"PM83", 4, 25527},
	{"PM84", 4, 25528},
	{"PM85", 4, 25529},
	{"PM86", 4, 25530},
	{"PM87", 4, 25531},
	{"PM88", 4, 25532},
	{"PM89", 4, 25533},
	{"PM90", 4, 25534},
	{"PM91", 4, 25535},
	{"PM92", 4, 25536},
	{"PM93", 4, 25537},
	{"PM94", 4, 25538},
	{"PM95", 4, 25539},
	{"PM96", 4, 25540},
	{"PM97", 4, 25541},
	{"PM98", 4, 25542},
	{"PM99", 4, 25543},
	{"PN00", 4, 25544},
	{"PN01", 4, 25545},
	{"PN02", 4, 25546},
	{"PN03", 4, 25547},
	{"PN04", 4, 25548},
	{"PN05", 4, 25549},
	{"PN06", 4, 25550},
	{"PN07", 4, 25551},
	{"PN08", 4, 25552},
	{"PN09", 4, 25553},
	{"PN10", 4, 25554},
	{"PN11", 4, 25555},
	{"PN12", 4, 25556},
	{"PN13", 4, 25557},
	{"PN14", 4, 25558},
	{"PN15", 4, 25559},
	{"PN16", 4, 25560},
	{"PN17", 4, 25561},
	{"PN18", 4, 25562},
	{"PN19", 4, 25563},
	{"PN20", 4, 25564},
	{"PN21", 4, 25565},
	{"PN22", 4, 25566},
	{"PN23", 4, 25567},
	{"PN24", 4, 25568},
	{"PN25", 4, 25569},
	{"PN26", 4, 25570},
	{"PN27", 4, 25571},
	{"PN28", 4, 25572},
	{"PN29", 4, 25573},
	{"PN30", 4, 25574},
	{"PN31", 4, 25575},
	{"PN32", 4, 25576},
	{"PN33", 4, 25577},
	{"PN34", 4, 25578},
	{"PN35", 4, 25579},
	{"PN36", 4, 25580},
	{"PN37", 4, 25581},
	{"PN38", 4, 25582},
	{"PN39", 4, 25583},
	{"PN40", 4, 25584},
	{"PN41", 4, 25585},
	{"PN42", 4, 25586},
	{"PN43", 4, 25587},
	{"PN44", 4, 25588},
	{"PN45", 4, 25589},
	{"PN46", 4, 25590},
	{"PN47", 4, 25591},
	{"PN48", 4, 25592},
	{"PN49", 4, 25593},
	{"PN50", 4, 25594},
	{"PN51", 4, 25595},
	{"PN52", 4, 25596},
	{"PN53", 4, 25597},
	{"PN54", 4, 25598},
	{"PN55", 4, 25599},
	{"PN56", 4, 25600},
	{"PN57", 4, 25601},
	{"PN58", 4, 25602},
	{"PN59", 4, 25603},
	{"PN60", 4, 25604},
	{"PN61", 4, 25605},
	{"PN62", 4, 25606},
	{"PN63", 4, 25607},
	{"PN64", 4, 25608},
	{"PN65", 4, 25609},
	{"PN66", 4, 25610},
	{"PN67", 4, 25611},
	{"PN68", 4, 25612},
	{"PN69", 4, 25613},
	{"PN70", 4, 25614},
	{"PN71", 4, 25615},
	{"PN72", 4, 25616},
	{"PN73", 4, 25617},
	{"PN74", 4, 25618},
	{"PN75", 4, 25619},
	{"PN76", 4, 25620},
	{"PN77", 4, 25621},
	{"PN78", 4, 25622},
	{"PN79", 4, 25623},
	{"PN80", 4, 25624},
	{"PN81", 4, 25625},
	{"PN82", 4, 25626},
	{"PN83", 4, 25627},
	{"PN84", 4, 25628},
	{"PN85", 4, 25629},
	{"PN86", 4, 25630},
	{"PN87", 4, 25631},
	{"PN88", 4, 25632},
	{"PN89", 4, 25633},
	{"PN90", 4, 25634},
	{"PN91", 4, 25635},
	{"PN92", 4, 25636},
	{"PN93", 4, 25637},
	{"PN94", 4, 25638},
	{"PN95", 4, 25639},
	{"PN96", 4, 25640},
	{"PN97", 4, 25641},
	{"PN98", 4, 25642},
	{"PN99", 4, 25643},
	{"PO00", 4, 25644},
	{"PO01", 4, 25645},
	{"PO02", 4, 25646},
	{"PO03", 4, 25647},
	{"PO04", 4, 25648},
	{"PO05", 4, 25649},
	{"PO06", 4, 25650},
	{"PO07", 4, 25651},
	{"PO08", 4, 25652},
	{"PO09", 4, 25653},
	{"PO10", 4, 25654},
	{"PO11", 4, 25655},
	{"PO12", 4, 25656},
	{"PO13", 4, 25657},
	{"PO14", 4, 25658},
	{"PO15", 4, 25659},
	{"PO16", 4, 25660},
	{"PO17", 4, 25661},
	{"PO18", 4, 25662},
	{"PO19", 4, 25663},
	{"PO20", 4, 25664},
	{"PO21", 4, 25665},
	{"PO22", 4, 25666},
	{"PO23", 4, 25667},
	{"PO24", 4, 25668},
	{"PO25", 4, 25669},
	{"PO26", 4, 25670},
	{"PO27", 4, 25671},
	{"PO28", 4, 25672},
	{"PO29", 4, 25673},
	{"PO30", 4, 25674},
	{"PO31", 4, 25675},
	{"PO32", 4, 25676},
	{"PO33", 4, 25677},
	{"PO34", 4, 25678},
	{"PO35", 4, 25679},
	{"PO36", 4, 25680},
	{"PO37", 4, 25681},
	{"PO38", 4, 25682},
	{"PO39", 4, 25683},
	{"PO40", 4, 25684},
	{"PO41", 4, 25685},
	{"PO42", 4, 25686},
	{"PO43", 4, 25687},
	{"PO44", 4, 25688},
	{"PO45", 4, 25689},
	{"PO46", 4, 25690},
	{"PO47", 4, 25691},
	{"PO48", 4, 25692},
	{"PO49", 4, 25693},
	{"PO50", 4, 25694},
	{"PO51", 4, 25695},
	{"PO52", 4, 25696},
	{"PO53", 4, 25697},
	{"PO54", 4, 25698},
	{"PO55", 4, 25699},
	{"PO56", 4, 25700},
	{"PO57", 4, 25701},
	{"PO58", 4, 25702},
	{"PO59", 4, 25703},
	{"PO60", 4, 25704},
	{"PO61", 4, 25705},
	{"PO62", 4, 25706},
	{"PO63", 4, 25707},
	{"PO64", 4, 25708},
	{"PO65", 4, 25709},
	{"PO66", 4, 25710},
	{"PO67", 4, 25711},
	{"PO68", 4, 25712},
	{"PO69", 4, 25713},
	{"PO70", 4, 25714},
	{"PO71", 4, 25715},
	{"PO72", 4, 25716},
	{"PO73", 4, 25717},
	{"PO74", 4, 25718},
	{"PO75", 4, 25719},
	{"PO76", 4, 25720},
	{"PO77", 4, 25721},
	{"PO78", 4, 25722},
	{"PO79", 4, 25723},
	{"PO80", 4, 25724},
	{"PO81", 4, 25725},
	{"PO82", 4, 25726},
	{"PO83", 4, 25727},
	{"PO84", 4, 25728},
	{"PO85", 4, 25729},
	{"PO86", 4, 25730},
	{"PO87", 4, 25731},
	{"PO88", 4, 25732},
	{"PO89", 4, 25733},
	{"PO90", 4, 25734},
	{"PO91", 4, 25735},
	{"PO92", 4, 25736},
	{"PO93", 4, 25737},
	{"PO94", 4, 25738},
	{"PO95", 4, 25739},
	{"PO96", 4, 25740},
	{"PO97", 4, 25741},
	{"PO98", 4, 25742},
	{"PO99", 4, 25743},
	{"PP00", 4, 25744},
	{"PP01", 4, 25745},
	{"PP02", 4, 25746},
	{"PP03", 4, 25747},
	{"PP04", 4, 25748},
	{"PP05", 4, 25749},
	{"PP06", 4, 25750},
	{"PP07", 4, 25751},
	{"PP08", 4, 25752},
	{"PP09", 4, 25753},
	{"PP10", 4, 25754},
	{"PP11", 4, 25755},
	{"PP12", 4, 25756},
	{"PP13", 4, 25757},
	{"PP14", 4, 25758},
	{"PP15", 4, 25759},
	{"PP16", 4, 25760},
	{"PP17", 4, 25761},
	{"PP18", 4, 25762},
	{"PP19", 4, 25763},
	{"PP20", 4, 25764},
	{"PP21", 4, 25765},
	{"PP22", 4, 25766},
	{"PP23", 4, 25767},
	{"PP24", 4, 25768},
	{"PP25", 4, 25769},
	{"PP26", 4, 25770},
	{"PP27", 4, 25771},
	{"PP28", 4, 25772},
	{"PP29", 4, 25773},
	{"PP30", 4, 25774},
	{"PP31", 4, 25775},
	{"PP32", 4, 25776},
	{"PP33", 4, 25777},
	{"PP34", 4, 25778},
	{"PP35", 4, 25779},
	{"PP36", 4, 25780},
	{"PP37", 4, 25781},
	{"PP38", 4, 25782},
	{"PP39", 4, 25783},
	{"PP40", 4, 25784},
	{"PP41", 4, 25785},
	{"PP42", 4, 25786},
	{"PP43", 4, 25787},
	{"PP44", 4, 25788},
	{"PP45", 4, 25789},
	{"PP46", 4, 25790},
	{"PP47", 4, 25791},
	{"PP48", 4, 25792},
	{"PP49", 4, 25793},
	{"PP50", 4, 25794},
	{"PP51", 4, 25795},
	{"PP52", 4, 25796},
	{"PP53", 4, 25797},
	{"PP54", 4, 25798},
	{"PP55", 4, 25799},
	{"PP56", 4, 25800},
	{"PP57", 4, 25801},
	{"PP58", 4, 25802},
	{"PP59", 4, 25803},
	{"PP60", 4, 25804},
	{"PP61", 4, 25805},
	{"PP62", 4, 25806},
	{"PP63", 4, 25807},
	{"PP64", 4, 25808},
	{"PP65", 4, 25809},
	{"PP66", 4, 25810},
	{"PP67", 4, 25811},
	{"PP68", 4, 25812},
	{"PP69", 4, 25813},
	{"PP70", 4, 25814},
	{"PP71", 4, 25815},
	{"PP72", 4, 25816},
	{"PP73", 4, 25817},
	{"PP74", 4, 25818},
	{"PP75", 4, 25819},
	{"PP76", 4, 25820},
	{"PP77", 4, 25821},
	{"PP78", 4, 25822},
	{"PP79", 4, 25823},
	{"PP80", 4, 25824},
	{"PP81", 4, 25825},
	{"PP82", 4, 25826},
	{"PP83", 4, 25827},
	{"PP84", 4, 25828},
	{"PP85", 4, 25829},
	{"PP86", 4, 25830},
	{"PP87", 4, 25831},
	{"PP88", 4, 25832},
	{"PP89", 4, 25833},
	{"PP90", 4, 25834},
	{"PP91", 4, 25835},
	{"PP92", 4, 25836},
	{"PP93", 4, 25837},
	{"PP94", 4, 25838},
	{"PP95", 4, 25839},
	{"PP96", 4, 25840},
	{"PP97", 4, 25841},
	{"PP98", 4, 25842},
	{"PP99", 4, 25843},
	{"PQ00", 4, 25844},
	{"PQ01", 4, 25845},
	{"PQ02", 4, 25846},
	{"PQ03", 4, 25847},
	{"PQ04", 4, 25848},
	{"PQ05", 4, 25849},
	{"PQ06", 4, 25850},
	{"PQ07", 4, 25851},
	{"PQ08", 4, 25852},
	{"PQ09", 4, 25853},
	{"PQ10", 4, 25854},
	{"PQ11", 4, 25855},
	{"PQ12", 4, 25856},
	{"PQ13", 4, 25857},
	{"PQ14", 4, 25858},
	{"PQ15", 4, 25859},
	{"PQ16", 4, 25860},
	{"PQ17", 4, 25861},
	{"PQ18", 4, 25862},
	{"PQ19", 4, 25863},
	{"PQ20", 4, 25864},
	{"PQ21", 4, 25865},
	{"PQ22", 4, 25866},
	{"PQ23", 4, 25867},
	{"PQ24", 4, 25868},
	{"PQ25", 4, 25869},
	{"PQ26", 4, 25870},
	{"PQ27", 4, 25871},
	{"PQ28", 4, 25872},
	{"PQ29", 4, 25873},
	{"PQ30", 4, 25874},
	{"PQ31", 4, 25875},
	{"PQ32", 4, 25876},
	{"PQ33", 4, 25877},
	{"PQ34", 4, 25878},
	{"PQ35", 4, 25879},
	{"PQ36", 4, 25880},
	{"PQ37", 4, 25881},
	{"PQ38", 4, 25882},
	{"PQ39", 4, 25883},
	{"PQ40", 4, 25884},
	{"PQ41", 4, 25885},
	{"PQ42", 4, 25886},
	{"PQ43", 4, 25887},
	{"PQ44", 4, 25888},
	{"PQ45", 4, 25889},
	{"PQ46", 4, 25890},
	{"PQ47", 4, 25891},
	{"PQ48", 4, 25892},
	{"PQ49", 4, 25893},
	{"PQ50", 4, 25894},
	{"PQ51", 4, 25895},
	{"PQ52", 4, 25896},
	{"PQ53", 4, 25897},
	{"PQ54", 4, 25898},
	{"PQ55", 4, 25899},
	{"PQ56", 4, 25900},
	{"PQ57", 4, 25901},
	{"PQ58", 4, 25902},
	{"PQ59", 4, 25903},
	{"PQ60", 4, 25904},
	{"PQ61", 4, 25905},
	{"PQ62", 4, 25906},
	{"PQ63", 4, 25907},
	{"PQ64", 4, 25908},
	{"PQ65", 4, 25909},
	{"PQ66", 4, 25910},
	{"PQ67", 4, 25911},
	{"PQ68", 4, 25912},
	{"PQ69", 4, 25913},
	{"PQ70", 4, 25914},
	{"PQ71", 4, 25915},
	{"PQ72", 4, 25916},
	{"PQ73", 4, 25917},
	{"PQ74", 4, 25918},
	{"PQ75", 4, 25919},
	{"PQ76", 4, 25920},
	{"PQ77", 4, 25921},
	{"PQ78", 4, 25922},
	{"PQ79", 4, 25923},
	{"PQ80", 4, 25924},
	{"PQ81", 4, 25925},
	{"PQ82", 4, 25926},
	{"PQ83", 4, 25927},
	{"PQ84", 4, 25928},
	{"PQ85", 4, 25929},
	{"PQ86", 4, 25930},
	{"PQ87", 4, 25931},
	{"PQ88", 4, 25932},
	{"PQ89", 4, 25933},
	{"PQ90", 4, 25934},
	{"PQ91", 4, 25935},
	{"PQ92", 4, 25936},
	{"PQ93", 4, 25937},
	{"PQ94", 4, 25938},
	{"PQ95", 4, 25939},
	{"PQ96", 4, 25940},
	{"PQ97", 4, 25941},
	{"PQ98", 4, 25942},
	{"PQ99", 4, 25943},
	{"QB00", 4, 25944},
	{"QB01", 4, 25945},
	{"QB02", 4, 25946},
	{"QB03", 4, 25947},
	{"QB04", 4, 25948},
	{"QB05", 4, 25949},
	{"QB06", 4, 25950},
	{"QB07", 4, 25951},
	{"QB08", 4, 25952},
	{"QB09", 4, 25953},
	{"QB10", 4, 25954},
	{"QB11", 4, 25955},
	{"QB12", 4, 25956},
	{"QB13", 4, 25957},
	{"QB14", 4, 25958},
	{"QB15", 4, 25959},
	{"QB16", 4, 25960},
	{"QB17", 4, 25961},
	{"QB18", 4, 25962},
	{"QB19", 4, 25963},
	{"QB20", 4, 25964},
	{"QB21", 4, 25965},
	{"QB22", 4, 25966},
	{"QB23", 4, 25967},
	{"QB24", 4, 25968},
	{"QB25", 4, 25969},
	{"QB26", 4, 25970},
	{"QB27", 4, 25971},
	{"QB28", 4, 25972},
	{"QB29", 4, 25973},
	{"QB30", 4, 25974},
	{"QB31", 4, 25975},
	{"QB32", 4, 25976},
	{"QB33", 4, 25977},
	{"QB34", 4, 25978},
	{"QB35", 4, 25979},
	{"QB36", 4, 25980},
	{"QB37", 4, 25981},
	{"QB38", 4, 25982},
	{"QB39", 4, 25983},
	{"QB40", 4, 25984},
	{"QB41", 4, 25985},
	{"QB42", 4, 25986},
	{"QB43", 4, 25987},
	{"QB44", 4, 25988},
	{"QB45", 4, 25989},
	{"QB46", 4, 25990},
	{"QB47", 4, 25991},
	{"QB48", 4, 25992},
	{"QB49", 4, 25993},
	{"QB50", 4, 25994},
	{"QB51", 4, 25995},
	{"QB52", 4, 25996},
	{"QB53", 4, 25997},
	{"QB54", 4, 25998},
	{"QB55", 4, 25999},
	{"QB56", 4, 26000},
	{"QB57", 4, 26001},
	{"QB58", 4, 26002},
	{"QB59", 4, 26003},
	{"QB60", 4, 26004},
	{"QB61", 4, 26005},
	{"QB62", 4, 26006},
	{"QB63", 4, 26007},
	{"QB64", 4, 26008},
	{"QB65", 4, 26009},
	{"QB66", 4, 26010},
	{"QB67", 4, 26011},
	{"QB68", 4, 26012},
	{"QB69", 4, 26013},
	{"QB70", 4, 26014},
	{"QB71", 4, 26015},
	{"QB72", 4, 26016},
	{"QB73", 4, 26017},
	{"QB74", 4, 26018},
	{"QB75", 4, 26019},
	{"QB76", 4, 26020},
	{"QB77", 4, 26021},
	{"QB78", 4, 26022},
	{"QB79", 4, 26023},
	{"QB80", 4, 26024},
	{"QB81", 4, 26025},
	{"QB82", 4, 26026},
	{"QB83", 4, 26027},
	{"QB84", 4, 26028},
	{"QB85", 4, 26029},
	{"QB86", 4, 26030},
	{"QB87", 4, 26031},
	{"QB88", 4, 26032},
	{"QB89", 4, 26033},
	{"QB90", 4, 26034},
	{"QB91", 4, 26035},
	{"QB92", 4, 26036},
	{"QB93", 4, 26037},
	{"QB94", 4, 26038},
	{"QB95", 4, 26039},
	{"QB96", 4, 26040},
	{"QB97", 4, 26041},
	{"QB98", 4, 26042},
	{"QB99", 4, 26043},
	{"QC00", 4, 26044},
	{"QC01", 4, 26045},
	{"QC02", 4, 26046},
	{"QC03", 4, 26047},
	{"QC04", 4, 26048},
	{"QC05", 4, 26049},
	{"QC06", 4, 26050},
	{"QC07", 4, 26051},
	{"QC08", 4, 26052},
	{"QC09", 4, 26053},
	{"QC10", 4, 26054},
	{"QC11", 4, 26055},
	{"QC12", 4, 26056},
	{"QC13", 4, 26057},
	{"QC14", 4, 26058},
	{"QC15", 4, 26059},
	{"QC16", 4, 26060},
	{"QC17", 4, 26061},
	{"QC18", 4, 26062},
	{"QC19", 4, 26063},
	{"QC20", 4, 26064},
	{"QC21", 4, 26065},
	{"QC22", 4, 26066},
	{"QC23", 4, 26067},
	{"QC24", 4, 26068},
	{"QC25", 4, 26069},
	{"QC26", 4, 26070},
	{"QC27", 4, 26071},
	{"QC28", 4, 26072},
	{"QC29", 4, 26073},
	{"QC30", 4, 26074},
	{"QC31", 4, 26075},
	{"QC32", 4, 26076},
	{"QC33", 4, 26077},
	{"QC34", 4, 26078},
	{"QC35", 4, 26079},
	{"QC36", 4, 26080},
	{"QC37", 4, 26081},
	{"QC38", 4, 26082},
	{"QC39", 4, 26083},
	{"QC40", 4, 26084},
	{"QC41", 4, 26085},
	{"QC42", 4, 26086},
	{"QC43", 4, 26087},
	{"QC44", 4, 26088},
	{"QC45", 4, 26089},
	{"QC46", 4, 26090},
	{"QC47", 4, 26091},
	{"QC48", 4, 26092},
	{"QC49", 4, 26093},
	{"QC50", 4, 26094},
	{"QC51", 4, 26095},
	{"QC52", 4, 26096},
	{"QC53", 4, 26097},
	{"QC54", 4, 26098},
	{"QC55", 4, 26099},
	{"QC56", 4, 26100},
	{"QC57", 4, 26101},
	{"QC58", 4, 26102},
	{"QC59", 4, 26103},
	{"QC60", 4, 26104},
	{"QC61", 4, 26105},
	{"QC62", 4, 26106},
	{"QC63", 4, 26107},
	{"QC64", 4, 26108},
	{"QC65", 4, 26109},
	{"QC66", 4, 26110},
	{"QC67", 4, 26111},
	{"QC68", 4, 26112},
	{"QC69", 4, 26113},
	{"QC70", 4, 26114},
	{"QC71", 4, 26115},
	{"QC72", 4, 26116},
	{"QC73", 4, 26117},
	{"QC74", 4, 26118},
	{"QC75", 4, 26119},
	{"QC76", 4, 26120},
	{"QC77", 4, 26121},
	{"QC78", 4, 26122},
	{"QC79", 4, 26123},
	{"QC80", 4, 26124},
	{"QC81", 4, 26125},
	{"QC82", 4, 26126},
	{"QC83", 4, 26127},
	{"QC84", 4, 26128},
	{"QC85", 4, 26129},
	{"QC86", 4, 26130},
	{"QC87", 4, 26131},
	{"QC88", 4, 26132},
	{"QC89", 4, 26133},
	{"QC90", 4, 26134},
	{"QC91", 4, 26135},
	{"QC92", 4, 26136},
	{"QC93", 4, 26137},
	{"QC94", 4, 26138},
	{"QC95", 4, 26139},
	{"QC96", 4, 26140},
	{"QC97", 4, 26141},
	{"QC98", 4, 26142},
	{"QC99", 4, 26143},
	{"QE00", 4, 26144},
	{"QE01", 4, 26145},
	{"QE02", 4, 26146},
	{"QE03", 4, 26147},
	{"QE04", 4, 26148},
	{"QE05", 4, 26149},
	{"QE06", 4, 26150},
	{"QE07", 4, 26151},
	{"QE08", 4, 26152},
	{"QE09", 4, 26153},
	{"QE10", 4, 26154},
	{"QE11", 4, 26155},
	{"QE12", 4, 26156},
	{"QE13", 4, 26157},
	{"QE14", 4, 26158},
	{"QE15", 4, 26159},
	{"QE16", 4, 26160},
	{"QE17", 4, 26161},
	{"QE18", 4, 26162},
	{"QE19", 4, 26163},
	{"QE20", 4, 26164},
	{"QE21", 4, 26165},
	{"QE22", 4, 26166},
	{"QE23", 4, 26167},
	{"QE24", 4, 26168},
	{"QE25", 4, 26169},
	{"QE26", 4, 26170},
	{"QE27", 4, 26171},
	{"QE28", 4, 26172},
	{"QE29", 4, 26173},
	{"QE30", 4, 26174},
	{"QE31", 4, 26175},
	{"QE32", 4, 26176},
	{"QE33", 4, 26177},
	{"QE34", 4, 26178},
	{"QE35", 4, 26179},
	{"QE36", 4, 26180},
	{"QE37", 4, 26181},
	{"QE38", 4, 26182},
	{"QE39", 4, 26183},
	{"QE40", 4, 26184},
	{"QE41", 4, 26185},
	{"QE42", 4, 26186},
	{"QE43", 4, 26187},
	{"QE44", 4, 26188},
	{"QE45", 4, 26189},
	{"QE46", 4, 26190},
	{"QE47", 4, 26191},
	{"QE48", 4, 26192},
	{"QE49", 4, 26193},
	{"QE50", 4, 26194},
	{"QE51", 4, 26195},
	{"QE52", 4, 26196},
	{"QE53", 4, 26197},
	{"QE54", 4, 26198},
	{"QE55", 4, 26199},
	{"QE56", 4, 26200},
	{"QE57", 4, 26201},
	{"QE58", 4, 26202},
	{"QE59", 4, 26203},
	{"QE60", 4, 26204},
	{"QE61", 4, 26205},
	{"QE62", 4, 26206},
	{"QE63", 4, 26207},
	{"QE64", 4, 26208},
	{"QE65", 4, 26209},
	{"QE66", 4, 26210},
	{"QE67", 4, 26211},
	{"QE68", 4, 26212},
	{"QE69", 4, 26213},
	{"QE70", 4, 26214},
	{"QE71", 4, 26215},
	{"QE72", 4, 26216},
	{"QE73", 4, 26217},
	{"QE74", 4, 26218},
	{"QE75", 4, 26219},
	{"QE76", 4, 26220},
	{"QE77", 4, 26221},
	{"QE78", 4, 26222},
	{"QE79", 4, 26223},
	{"QE80", 4, 26224},
	{"QE81", 4, 26225},
	{"QE82", 4, 26226},
	{"QE83", 4, 26227},
	{"QE84", 4, 26228},
	{"QE85", 4, 26229},
	{"QE86", 4, 26230},
	{"QE87", 4, 26231},
	{"QE88", 4, 26232},
	{"QE89", 4, 26233},
	{"QE90", 4, 26234},
	{"QE91", 4, 26235},
	{"QE92", 4, 26236},
	{"QE93", 4, 26237},
	{"QE94", 4, 26238},
	{"QE95", 4, 26239},
	{"QE96", 4, 26240},
	{"QE97", 4, 26241},
	{"QE98", 4, 26242},
	{"QE99", 4, 26243},
	{"QF00", 4, 26244},
	{"QF01", 4, 26245},
	{"QF02", 4, 26246},
	{"QF03", 4, 26247},
	{"QF04", 4, 26248},
	{"QF05", 4, 26249},
	{"QF06", 4, 26250},
	{"QF07", 4, 26251},
	{"QF08", 4, 26252},
	{"QF09", 4, 26253},
	{"QF10", 4, 26254},
	{"QF11", 4, 26255},
	{"QF12", 4, 26256},
	{"QF13", 4, 26257},
	{"QF14", 4, 26258},
	{"QF15", 4, 26259},
	{"QF16", 4, 26260},
	{"QF17", 4, 26261},
	{"QF18", 4, 26262},
	{"QF19", 4, 26263},
	{"QF20", 4, 26264},
	{"QF21", 4, 26265},
	{"QF22", 4, 26266},
	{"QF23", 4, 26267},
	{"QF24", 4, 26268},
	{"QF25", 4, 26269},
	{"QF26", 4, 26270},
	{"QF27", 4, 26271},
	{"QF28", 4, 26272},
	{"QF29", 4, 26273},
	{"QF30", 4, 26274},
	{"QF31", 4, 26275},
	{"QF32", 4, 26276},
	{"QF33", 4, 26277},
	{"QF34", 4, 26278},
	{"QF35", 4, 26279},
	{"QF36", 4, 26280},
	{"QF37", 4, 26281},
	{"QF38", 4, 26282},
	{"QF39", 4, 26283},
	{"QF40", 4, 26284},
	{"QF41", 4, 26285},
	{"QF42", 4, 26286},
	{"QF43", 4, 26287},
	{"QF44", 4, 26288},
	{"QF45", 4, 26289},
	{"QF46", 4, 26290},
	{"QF47", 4, 26291},
	{"QF48", 4, 26292},
	{"QF49", 4, 26293},
	{"QF50", 4, 26294},
	{"QF51", 4, 26295},
	{"QF52", 4, 26296},
	{"QF53", 4, 26297},
	{"QF54", 4, 26298},
	{"QF55", 4, 26299},
	{"QF56", 4, 26300},
	{"QF57", 4, 26301},
	{"QF58", 4, 26302},
	{"QF59", 4, 26303},
	{"QF60", 4, 26304},
	{"QF61", 4, 26305},
	{"QF62", 4, 26306},
	{"QF63", 4, 26307},
	{"QF64", 4, 26308},
	{"QF65", 4, 26309},
	{"QF66", 4, 26310},
	{"QF67", 4, 26311},
	{"QF68", 4, 26312},
	{"QF69", 4, 26313},
	{"QF70", 4, 26314},
	{"QF71", 4, 26315},
	{"QF72", 4, 26316},
	{"QF73", 4, 26317},
	{"QF74", 4, 26318},
	{"QF75", 4, 26319},
	{"QF76", 4, 26320},
	{"QF77", 4, 26321},
	{"QF78", 4, 26322},
	{"QF79", 4, 26323},
	{"QF80", 4, 26324},
	{"QF81", 4, 26325},
	{"QF82", 4, 26326},
	{"QF83", 4, 26327},
	{"QF84", 4, 26328},
	{"QF85", 4, 26329},
	{"QF86", 4, 26330},
	{"QF87", 4, 26331},
	{"QF88", 4, 26332},
	{"QF89", 4, 26333},
	{"QF90", 4, 26334},
	{"QF91", 4, 26335},
	{"QF92", 4, 26336},
	{"QF93", 4, 26337},
	{"QF94", 4, 26338},
	{"QF95", 4, 26339},
	{"QF96", 4, 26340},
	{"QF97", 4, 26341},
	{"QF98", 4, 26342},
	{"QF99", 4, 26343},
	{"QG00", 4, 26344},
	{"QG01", 4, 26345},
	{"QG02", 4, 26346},
	{"QG03", 4, 26347},
	{"QG04", 4, 26348},
	{"QG05", 4, 26349},
	{"QG06", 4, 26350},
	{"QG07", 4, 26351},
	{"QG08", 4, 26352},
	{"QG09", 4, 26353},
	{"QG10", 4, 26354},
	{"QG11", 4, 26355},
	{"QG12", 4, 26356},
	{"QG13", 4, 26357},
	{"QG14", 4, 26358},
	{"QG15", 4, 26359},
	{"QG16", 4, 26360},
	{"QG17", 4, 26361},
	{"QG18", 4, 26362},
	{"QG19", 4, 26363},
	{"QG20", 4, 26364},
	{"QG21", 4, 26365},
	{"QG22", 4, 26366},
	{"QG23", 4, 26367},
	{"QG24", 4, 26368},
	{"QG25", 4, 26369},
	{"QG26", 4, 26370},
	{"QG27", 4, 26371},
	{"QG28", 4, 26372},
	{"QG29", 4, 26373},
	{"QG30", 4, 26374},
	{"QG31", 4, 26375},
	{"QG32", 4, 26376},
	{"QG33", 4, 26377},
	{"QG34", 4, 26378},
	{"QG35", 4, 26379},
	{"QG36", 4, 26380},
	{"QG37", 4, 26381},
	{"QG38", 4, 26382},
	{"QG39", 4, 26383},
	{"QG40", 4, 26384},
	{"QG41", 4, 26385},
	{"QG42", 4, 26386},
	{"QG43", 4, 26387},
	{"QG44", 4, 26388},
	{"QG45", 4, 26389},
	{"QG46", 4, 26390},
	{"QG47", 4, 26391},
	{"QG48", 4, 26392},
	{"QG49", 4, 26393},
	{"QG50", 4, 26394},
	{"QG51", 4, 26395},
	{"QG52", 4, 26396},
	{"QG53", 4, 26397},
	{"QG54", 4, 26398},
	{"QG55", 4, 26399},
	{"QG56", 4, 26400},
	{"QG57", 4, 26401},
	{"QG58", 4, 26402},
	{"QG59", 4, 26403},
	{"QG60", 4, 26404},
	{"QG61", 4, 26405},
	{"QG62", 4, 26406},
	{"QG63", 4, 26407},
	{"QG64", 4, 26408},
	{"QG65", 4, 26409},
	{"QG66", 4, 26410},
	{"QG67", 4, 26411},
	{"QG68", 4, 26412},
	{"QG69", 4, 26413},
	{"QG70", 4, 26414},
	{"QG71", 4, 26415},
	{"QG72", 4, 26416},
	{"QG73", 4, 26417},
	{"QG74", 4, 26418},
	{"QG75", 4, 26419},
	{"QG76", 4, 26420},
	{"QG77", 4, 26421},
	{"QG78", 4, 26422},
	{"QG79", 4, 26423},
	{"QG80", 4, 26424},
	{"QG81", 4, 26425},
	{"QG82", 4, 26426},
	{"QG83", 4, 26427},
	{"QG84", 4, 26428},
	{"QG85", 4, 26429},
	{"QG86", 4, 26430},
	{"QG87", 4, 26431},
	{"QG88", 4, 26432},
	{"QG89", 4, 26433},
	{"QG90", 4, 26434},
	{"QG91", 4, 26435},
	{"QG92", 4, 26436},
	{"QG93", 4, 26437},
	{"QG94", 4, 26438},
	{"QG95", 4, 26439},
	{"QG96", 4, 26440},
	{"QG97", 4, 26441},
	{"QG98", 4, 26442},
	{"QG99", 4, 26443},
	{"QH00", 4, 26444},
	{"QH01", 4, 26445},
	{"QH02", 4, 26446},
	{"QH03", 4, 26447},
	{"QH04", 4, 26448},
	{"QH05", 4, 26449},
	{"QH06", 4, 26450},
	{"QH07", 4, 26451},
	{"QH08", 4, 26452},
	{"QH09", 4, 26453},
	{"QH10", 4, 26454},
	{"QH11", 4, 26455},
	{"QH12", 4, 26456},
	{"QH13", 4, 26457},
	{"QH14", 4, 26458},
	{"QH15", 4, 26459},
	{"QH16", 4, 26460},
	{"QH17", 4, 26461},
	{"QH18", 4, 26462},
	{"QH19", 4, 26463},
	{"QH20", 4, 26464},
	{"QH21", 4, 26465},
	{"QH22", 4, 26466},
	{"QH23", 4, 26467},
	{"QH24", 4, 26468},
	{"QH25", 4, 26469},
	{"QH26", 4, 26470},
	{"QH27", 4, 26471},
	{"QH28", 4, 26472},
	{"QH29", 4, 26473},
	{"QH30", 4, 26474},
	{"QH31", 4, 26475},
	{"QH32", 4, 26476},
	{"QH33", 4, 26477},
	{"QH34", 4, 26478},
	{"QH35", 4, 26479},
	{"QH36", 4, 26480},
	{"QH37", 4, 26481},
	{"QH38", 4, 26482},
	{"QH39", 4, 26483},
	{"QH40", 4, 26484},
	{"QH41", 4, 26485},
	{"QH42", 4, 26486},
	{"QH43", 4, 26487},
	{"QH44", 4, 26488},
	{"QH45", 4, 26489},
	{"QH46", 4, 26490},
	{"QH47", 4, 26491},
	{"QH48", 4, 26492},
	{"QH49", 4, 26493},
	{"QH50", 4, 26494},
	{"QH51", 4, 26495},
	{"QH52", 4, 26496},
	{"QH53", 4, 26497},
	{"QH54", 4, 26498},
	{"QH55", 4, 26499},
	{"QH56", 4, 26500},
	{"QH57", 4, 26501},
	{"QH58", 4, 26502},
	{"QH59", 4, 26503},
	{"QH60", 4, 26504},
	{"QH61", 4, 26505},
	{"QH62", 4, 26506},
	{"QH63", 4, 26507},
	{"QH64", 4, 26508},
	{"QH65", 4, 26509},
	{"QH66", 4, 26510},
	{"QH67", 4, 26511},
	{"QH68", 4, 26512},
	{"QH69", 4, 26513},
	{"QH70", 4, 26514},
	{"QH71", 4, 26515},
	{"QH72", 4, 26516},
	{"QH73", 4, 26517},
	{"QH74", 4, 26518},
	{"QH75", 4, 26519},
	{"QH76", 4, 26520},
	{"QH77", 4, 26521},
	{"QH78", 4, 26522},
	{"QH79", 4, 26523},
	{"QH80", 4, 26524},
	{"QH81", 4, 26525},
	{"QH82", 4, 26526},
	{"QH83", 4, 26527},
	{"QH84", 4, 26528},
	{"QH85", 4, 26529},
	{"QH86", 4, 26530},
	{"QH87", 4, 26531},
	{"QH88", 4, 26532},
	{"QH89", 4, 26533},
	{"QH90", 4, 26534},
	{"QH91", 4, 26535},
	{"QH92", 4, 26536},
	{"QH93", 4, 26537},
	{"QH94", 4, 26538},
	{"QH95", 4, 26539},
	{"QH96", 4, 26540},
	{"QH97", 4, 26541},
	{"QH98", 4, 26542},
	{"QH99", 4, 26543},
	{"QI00", 4, 26544},
	{"QI01", 4, 26545},
	{"QI02", 4, 26546},
	{"QI03", 4, 26547},
	{"QI04", 4, 26548},
	{"QI05", 4, 26549},
	{"QI06", 4, 26550},
	{"QI07", 4, 26551},
	{"QI08", 4, 26552},
	{"QI09", 4, 26553},
	{"QI10", 4, 26554},
	{"QI11", 4, 26555},
	{"QI12", 4, 26556},
	{"QI13", 4, 26557},
	{"QI14", 4, 26558},
	{"QI15", 4, 26559},
	{"QI16", 4, 26560},
	{"QI17", 4, 26561},
	{"QI18", 4, 26562},
	{"QI19", 4, 26563},
	{"QI20", 4, 26564},
	{"QI21", 4, 26565},
	{"QI22", 4, 26566},
	{"QI23", 4, 26567},
	{"QI24", 4, 26568},
	{"QI25", 4, 26569},
	{"QI26", 4, 26570},
	{"QI27", 4, 26571},
	{"QI28", 4, 26572},
	{"QI29", 4, 26573},
	{"QI30", 4, 26574},
	{"QI31", 4, 26575},
	{"QI32", 4, 26576},
	{"QI33", 4, 26577},
	{"QI34", 4, 26578},
	{"QI35", 4, 26579},
	{"QI36", 4, 26580},
	{"QI37", 4, 26581},
	{"QI38", 4, 26582},
	{"QI39", 4, 26583},
	{"QI40", 4, 26584},
	{"QI41", 4, 26585},
	{"QI42", 4, 26586},
	{"QI43", 4, 26587},
	{"QI44", 4, 26588},
	{"QI45", 4, 26589},
	{"QI46", 4, 26590},
	{"QI47", 4, 26591},
	{"QI48", 4, 26592},
	{"QI49", 4, 26593},
	{"QI50", 4, 26594},
	{"QI51", 4, 26595},
	{"QI52", 4, 26596},
	{"QI53", 4, 26597},
	{"QI54", 4, 26598},
	{"QI55", 4, 26599},
	{"QI56", 4, 26600},
	{"QI57", 4, 26601},
	{"QI58", 4, 26602},
	{"QI59", 4, 26603},
	{"QI60", 4, 26604},
	{"QI61", 4, 26605},
	{"QI62", 4, 26606},
	{"QI63", 4, 26607},
	{"QI64", 4, 26608},
	{"QI65", 4, 26609},
	{"QI66", 4, 26610},
	{"QI67", 4, 26611},
	{"QI68", 4, 26612},
	{"QI69", 4, 26613},
	{"QI70", 4, 26614},
	{"QI71", 4, 26615},
	{"QI72", 4, 26616},
	{"QI73", 4, 26617},
	{"QI74", 4, 26618},
	{"QI75", 4, 26619},
	{"QI76", 4, 26620},
	{"QI77", 4, 26621},
	{"QI78", 4, 26622},
	{"QI79", 4, 26623},
	{"QI80", 4, 26624},
	{"QI81", 4, 26625},
	{"QI82", 4, 26626},
	{"QI83", 4, 26627},
	{"QI84", 4, 26628},
	{"QI85", 4, 26629},
	{"QI86", 4, 26630},
	{"QI87", 4, 26631},
	{"QI88", 4, 26632},
	{"QI89", 4, 26633},
	{"QI90", 4, 26634},
	{"QI91", 4, 26635},
	{"QI92", 4, 26636},
	{"QI93", 4, 26637},
	{"QI94", 4, 26638},
	{"QI95", 4, 26639},
	{"QI96", 4, 26640},
	{"QI97", 4, 26641},
	{"QI98", 4, 26642},
	{"QI99", 4, 26643},
	{"QM00", 4, 26644},
	{"QM01", 4, 26645},
	{"QM02", 4, 26646},
	{"QM03", 4, 26647},
	{"QM04", 4, 26648},
	{"QM05", 4, 26649},
	{"QM06", 4, 26650},
	{"QM07", 4, 26651},
	{"QM08", 4, 26652},
	{"QM09", 4, 26653},
	{"QM10", 4, 26654},
	{"QM11", 4, 26655},
	{"QM12", 4, 26656},
	{"QM13", 4, 26657},
	{"QM14", 4, 26658},
	{"QM15", 4, 26659},
	{"QM16", 4, 26660},
	{"QM17", 4, 26661},
	{"QM18", 4, 26662},
	{"QM19", 4, 26663},
	{"QM20", 4, 26664},
	{"QM21", 4, 26665},
	{"QM22", 4, 26666},
	{"QM23", 4, 26667},
	{"QM24", 4, 26668},
	{"QM25", 4, 26669},
	{"QM26", 4, 26670},
	{"QM27", 4, 26671},
	{"QM28", 4, 26672},
	{"QM29", 4, 26673},
	{"QM30", 4, 26674},
	{"QM31", 4, 26675},
	{"QM32", 4, 26676},
	{"QM33", 4, 26677},
	{"QM34", 4, 26678},
	{"QM35", 4, 26679},
	{"QM36", 4, 26680},
	{"QM37", 4, 26681},
	{"QM38", 4, 26682},
	{"QM39", 4, 26683},
	{"QM40", 4, 26684},
	{"QM41", 4, 26685},
	{"QM42", 4, 26686},
	{"QM43", 4, 26687},
	{"QM44", 4, 26688},
	{"QM45", 4, 26689},
	{"QM46", 4, 26690},
	{"QM47", 4, 26691},
	{"QM48", 4, 26692},
	{"QM49", 4, 26693},
	{"QM50", 4, 26694},
	{"QM51", 4, 26695},
	{"QM52", 4, 26696},
	{"QM53", 4, 26697},
	{"QM54", 4, 26698},
	{"QM55", 4, 26699},
	{"QM56", 4, 26700},
	{"QM57", 4, 26701},
	{"QM58", 4, 26702},
	{"QM59", 4, 26703},
	{"QM60", 4, 26704},
	{"QM61", 4, 26705},
	{"QM62", 4, 26706},
	{"QM63", 4, 26707},
	{"QM64", 4, 26708},
	{"QM65", 4, 26709},
	{"QM66", 4, 26710},
	{"QM67", 4, 26711},
	{"QM68", 4, 26712},
	{"QM69", 4, 26713},
	{"QM70", 4, 26714},
	{"QM71", 4, 26715},
	{"QM72", 4, 26716},
	{"QM73", 4, 26717},
	{"QM74", 4, 26718},
	{"QM75", 4, 26719},
	{"QM76", 4, 26720},
	{"QM77", 4, 26721},
	{"QM78", 4, 26722},
	{"QM79", 4, 26723},
	{"QM80", 4, 26724},
	{"QM81", 4, 26725},
	{"QM82", 4, 26726},
	{"QM83", 4, 26727},
	{"QM84", 4, 26728},
	{"QM85", 4, 26729},
	{"QM86", 4, 26730},
	{"QM87", 4, 26731},
	{"QM88", 4, 26732},
	{"QM89", 4, 26733},
	{"QM90", 4, 26734},
	{"QM91", 4, 26735},
	{"QM92", 4, 26736},
	{"QM93", 4, 26737},
	{"QM94", 4, 26738},
	{"QM95", 4, 26739},
	{"QM96", 4, 26740},
	{"QM97", 4, 26741},
	{"QM98", 4, 26742},
	{"QM99", 4, 26743},
	{"QN00", 4, 26744},
	{"QN01", 4, 26745},
	{"QN02", 4, 26746},
	{"QN03", 4, 26747},
	{"QN04", 4, 26748},
	{"QN05", 4, 26749},
	{"QN06", 4, 26750},
	{"QN07", 4, 26751},
	{"QN08", 4, 26752},
	{"QN09", 4, 26753},
	{"QN10", 4, 26754},
	{"QN11", 4, 26755},
	{"QN12", 4, 26756},
	{"QN13", 4, 26757},
	{"QN14", 4, 26758},
	{"QN15", 4, 26759},
	{"QN16", 4, 26760},
	{"QN17", 4, 26761},
	{"QN18", 4, 26762},
	{"QN19", 4, 26763},
	{"QN20", 4, 26764},
	{"QN21", 4, 26765},
	{"QN22", 4, 26766},
	{"QN23", 4, 26767},
	{"QN24", 4, 26768},
	{"QN25", 4, 26769},
	{"QN26", 4, 26770},
	{"QN27", 4, 26771},
	{"QN28", 4, 26772},
	{"QN29", 4, 26773},
	{"QN30", 4, 26774},
	{"QN31", 4, 26775},
	{"QN32", 4, 26776},
	{"QN33", 4, 26777},
	{"QN34", 4, 26778},
	{"QN35", 4, 26779},
	{"QN36", 4, 26780},
	{"QN37", 4, 26781},
	{"QN38", 4, 26782},
	{"QN39", 4, 26783},
	{"QN40", 4, 26784},
	{"QN41", 4, 26785},
	{"QN42", 4, 26786},
	{"QN43", 4, 26787},
	{"QN44", 4, 26788},
	{"QN45", 4, 26789},
	{"QN46", 4, 26790},
	{"QN47", 4, 26791},
	{"QN48", 4, 26792},
	{"QN49", 4, 26793},
	{"QN50", 4, 26794},
	{"QN51", 4, 26795},
	{"QN52", 4, 26796},
	{"QN53", 4, 26797},
	{"QN54", 4, 26798},
	{"QN55", 4, 26799},
	{"QN56", 4, 26800},
	{"QN57", 4, 26801},
	{"QN58", 4, 26802},
	{"QN59", 4, 26803},
	{"QN60", 4, 26804},
	{"QN61", 4, 26805},
	{"QN62", 4, 26806},
	{"QN63", 4, 26807},
	{"QN64", 4, 26808},
	{"QN65", 4, 26809},
	{"QN66", 4, 26810},
	{"QN67", 4, 26811},
	{"QN68", 4, 26812},
	{"QN69", 4, 26813},
	{"QN70", 4, 26814},
	{"QN71", 4, 26815},
	{"QN72", 4, 26816},
	{"QN73", 4, 26817},
	{"QN74", 4, 26818},
	{"QN75", 4, 26819},
	{"QN76", 4, 26820},
	{"QN77", 4, 26821},
	{"QN78", 4, 26822},
	{"QN79", 4, 26823},
	{"QN80", 4, 26824},
	{"QN81", 4, 26825},
	{"QN82", 4, 26826},
	{"QN83", 4, 26827},
	{"QN84", 4, 26828},
	{"QN85", 4, 26829},
	{"QN86", 4, 26830},
	{"QN87", 4, 26831},
	{"QN88", 4, 26832},
	{"QN89", 4, 26833},
	{"QN90", 4, 26834},
	{"QN91", 4, 26835},
	{"QN92", 4, 26836},
	{"QN93", 4, 26837},
	{"QN94", 4, 26838},
	{"QN95", 4, 26839},
	{"QN96", 4, 26840},
	{"QN97", 4, 26841},
	{"QN98", 4, 26842},
	{"QN99", 4, 26843},
	{"QO00", 4, 26844},
	{"QO01", 4, 26845},
	{"QO02", 4, 26846},
	{"QO03", 4, 26847},
	{"QO04", 4, 26848},
	{"QO05", 4, 26849},
	{"QO06", 4, 26850},
	{"QO07", 4, 26851},
	{"QO08", 4, 26852},
	{"QO09", 4, 26853},
	{"QO10", 4, 26854},
	{"QO11", 4, 26855},
	{"QO12", 4, 26856},
	{"QO13", 4, 26857},
	{"QO14", 4, 26858},
	{"QO15", 4, 26859},
	{"QO16", 4, 26860},
	{"QO17", 4, 26861},
	{"QO18", 4, 26862},
	{"QO19", 4, 26863},
	{"QO20", 4, 26864},
	{"QO21", 4, 26865},
	{"QO22", 4, 26866},
	{"QO23", 4, 26867},
	{"QO24", 4, 26868},
	{"QO25", 4, 26869},
	{"QO26", 4, 26870},
	{"QO27", 4, 26871},
	{"QO28", 4, 26872},
	{"QO29", 4, 26873},
	{"QO30", 4, 26874},
	{"QO31", 4, 26875},
	{"QO32", 4, 26876},
	{"QO33", 4, 26877},
	{"QO34", 4, 26878},
	{"QO35", 4, 26879},
	{"QO36", 4, 26880},
	{"QO37", 4, 26881},
	{"QO38", 4, 26882},
	{"QO39", 4, 26883},
	{"QO40", 4, 26884},
	{"QO41", 4, 26885},
	{"QO42", 4, 26886},
	{"QO43", 4, 26887},
	{"QO44", 4, 26888},
	{"QO45", 4, 26889},
	{"QO46", 4, 26890},
	{"QO47", 4, 26891},
	{"QO48", 4, 26892},
	{"QO49", 4, 26893},
	{"QO50", 4, 26894},
	{"QO51", 4, 26895},
	{"QO52", 4, 26896},
	{"QO53", 4, 26897},
	{"QO54", 4, 26898},
	{"QO55", 4, 26899},
	{"QO56", 4, 26900},
	{"QO57", 4, 26901},
	{"QO58", 4, 26902},
	{"QO59", 4, 26903},
	{"QO60", 4, 26904},
	{"QO61", 4, 26905},
	{"QO62", 4, 26906},
	{"QO63", 4, 26907},
	{"QO64", 4, 26908},
	{"QO65", 4, 26909},
	{"QO66", 4, 26910},
	{"QO67", 4, 26911},
	{"QO68", 4, 26912},
	{"QO69", 4, 26913},
	{"QO70", 4, 26914},
	{"QO71", 4, 26915},
	{"QO72", 4, 26916},
	{"QO73", 4, 26917},
	{"QO74", 4, 26918},
	{"QO75", 4, 26919},
	{"QO76", 4, 26920},
	{"QO77", 4, 26921},
	{"QO78", 4, 26922},
	{"QO79", 4, 26923},
	{"QO80", 4, 26924},
	{"QO81", 4, 26925},
	{"QO82", 4, 26926},
	{"QO83", 4, 26927},
	{"QO84", 4, 26928},
	{"QO85", 4, 26929},
	{"QO86", 4, 26930},
	{"QO87", 4, 26931},
	{"QO88", 4, 26932},
	{"QO89", 4, 26933},
	{"QO90", 4, 26934},
	{"QO91", 4, 26935},
	{"QO92", 4, 26936},
	{"QO93", 4, 26937},
	{"QO94", 4, 26938},
	{"QO95", 4, 26939},
	{"QO96", 4, 26940},
	{"QO97", 4, 26941},
	{"QO98", 4, 26942},
	{"QO99", 4, 26943},
	{"QP00", 4, 26944},
	{"QP01", 4, 26945},
	{"QP02", 4, 26946},
	{"QP03", 4, 26947},
	{"QP04", 4, 26948},
	{"QP05", 4, 26949},
	{"QP06", 4, 26950},
	{"QP07", 4, 26951},
	{"QP08", 4, 26952},
	{"QP09", 4, 26953},
	{"QP10", 4, 26954},
	{"QP11", 4, 26955},
	{"QP12", 4, 26956},
	{"QP13", 4, 26957},
	{"QP14", 4, 26958},
	{"QP15", 4, 26959},
	{"QP16", 4, 26960},
	{"QP17", 4, 26961},
	{"QP18", 4, 26962},
	{"QP19", 4, 26963},
	{"QP20", 4, 26964},
	{"QP21", 4, 26965},
	{"QP22", 4, 26966},
	{"QP23", 4, 26967},
	{"QP24", 4, 26968},
	{"QP25", 4, 26969},
	{"QP26", 4, 26970},
	{"QP27", 4, 26971},
	{"QP28", 4, 26972},
	{"QP29", 4, 26973},
	{"QP30", 4, 26974},
	{"QP31", 4, 26975},
	{"QP32", 4, 26976},
	{"QP33", 4, 26977},
	{"QP34", 4, 26978},
	{"QP35", 4, 26979},
	{"QP36", 4, 26980},
	{"QP37", 4, 26981},
	{"QP38", 4, 26982},
	{"QP39", 4, 26983},
	{"QP40", 4, 26984},
	{"QP41", 4, 26985},
	{"QP42", 4, 26986},
	{"QP43", 4, 26987},
	{"QP44", 4, 26988},
	{"QP45", 4, 26989},
	{"QP46", 4, 26990},
	{"QP47", 4, 26991},
	{"QP48", 4, 26992},
	{"QP49", 4, 26993},
	{"QP50", 4, 26994},
	{"QP51", 4, 26995},
	{"QP52", 4, 26996},
	{"QP53", 4, 26997},
	{"QP54", 4, 26998},
	{"QP55", 4, 26999},
	{"QP56", 4, 27000},
	{"QP57", 4, 27001},
	{"QP58", 4, 27002},
	{"QP59", 4, 27003},
	{"QP60", 4, 27004},
	{"QP61", 4, 27005},
	{"QP62", 4, 27006},
	{"QP63", 4, 27007},
	{"QP64", 4, 27008},
	{"QP65", 4, 27009},
	{"QP66", 4, 27010},
	{"QP67", 4, 27011},
	{"QP68", 4, 27012},
	{"QP69", 4, 27013},
	{"QP70", 4, 27014},
	{"QP71", 4, 27015},
	{"QP72", 4, 27016},
	{"QP73", 4, 27017},
	{"QP74", 4, 27018},
	{"QP75", 4, 27019},
	{"QP76", 4, 27020},
	{"QP77", 4, 27021},
	{"QP78", 4, 27022},
	{"QP79", 4, 27023},
	{"QP80", 4, 27024},
	{"QP81", 4, 27025},
	{"QP82", 4, 27026},
	{"QP83", 4, 27027},
	{"QP84", 4, 27028},
	{"QP85", 4, 27029},
	{"QP86", 4, 27030},
	{"QP87", 4, 27031},
	{"QP88", 4, 27032},
	{"QP89", 4, 27033},
	{"QP90", 4, 27034},
	{"QP91", 4, 27035},
	{"QP92", 4, 27036},
	{"QP93", 4, 27037},
	{"QP94", 4, 27038},
	{"QP95", 4, 27039},
	{"QP96", 4, 27040},
	{"QP97", 4, 27041},
	{"QP98", 4, 27042},
	{"QP99", 4, 27043},
	{"QQ00", 4, 27044},
	{"QQ01", 4, 27045},
	{"QQ02", 4, 27046},
	{"QQ03", 4, 27047},
	{"QQ04", 4, 27048},
	{"QQ05", 4, 27049},
	{"QQ06", 4, 27050},
	{"QQ07", 4, 27051},
	{"QQ08", 4, 27052},
	{"QQ09", 4, 27053},
	{"QQ10", 4, 27054},
	{"QQ11", 4, 27055},
	{"QQ12", 4, 27056},
	{"QQ13", 4, 27057},
	{"QQ14", 4, 27058},
	{"QQ15", 4, 27059},
	{"QQ16", 4, 27060},
	{"QQ17", 4, 27061},
	{"QQ18", 4, 27062},
	{"QQ19", 4, 27063},
	{"QQ20", 4, 27064},
	{"QQ21", 4, 27065},
	{"QQ22", 4, 27066},
	{"QQ23", 4, 27067},
	{"QQ24", 4, 27068},
	{"QQ25", 4, 27069},
	{"QQ26", 4, 27070},
	{"QQ27", 4, 27071},
	{"QQ28", 4, 27072},
	{"QQ29", 4, 27073},
	{"QQ30", 4, 27074},
	{"QQ31", 4, 27075},
	{"QQ32", 4, 27076},
	{"QQ33", 4, 27077},
	{"QQ34", 4, 27078},
	{"QQ35", 4, 27079},
	{"QQ36", 4, 27080},
	{"QQ37", 4, 27081},
	{"QQ38", 4, 27082},
	{"QQ39", 4, 27083},
	{"QQ40", 4, 27084},
	{"QQ41", 4, 27085},
	{"QQ42", 4, 27086},
	{"QQ43", 4, 27087},
	{"QQ44", 4, 27088},
	{"QQ45", 4, 27089},
	{"QQ46", 4, 27090},
	{"QQ47", 4, 27091},
	{"QQ48", 4, 27092},
	{"QQ49", 4, 27093},
	{"QQ50", 4, 27094},
	{"QQ51", 4, 27095},
	{"QQ52", 4, 27096},
	{"QQ53", 4, 27097},
	{"QQ54", 4, 27098},
	{"QQ55", 4, 27099},
	{"QQ56", 4, 27100},
	{"QQ57", 4, 27101},
	{"QQ58", 4, 27102},
	{"QQ59", 4, 27103},
	{"QQ60", 4, 27104},
	{"QQ61", 4, 27105},
	{"QQ62", 4, 27106},
	{"QQ63", 4, 27107},
	{"QQ64", 4, 27108},
	{"QQ65", 4, 27109},
	{"QQ66", 4, 27110},
	{"QQ67", 4, 27111},
	{"QQ68", 4, 27112},
	{"QQ69", 4, 27113},
	{"QQ70", 4, 27114},
	{"QQ71", 4, 27115},
	{"QQ72", 4, 27116},
	{"QQ73", 4, 27117},
	{"QQ74", 4, 27118},
	{"QQ75", 4, 27119},
	{"QQ76", 4, 27120},
	{"QQ77", 4, 27121},
	{"QQ78", 4, 27122},
	{"QQ79", 4, 27123},
	{"QQ80", 4, 27124},
	{"QQ81", 4, 27125},
	{"QQ82", 4, 27126},
	{"QQ83", 4, 27127},
	{"QQ84", 4, 27128},
	{"QQ85", 4, 27129},
	{"QQ86", 4, 27130},
	{"QQ87", 4, 27131},
	{"QQ88", 4, 27132},
	{"QQ89", 4, 27133},
	{"QQ90", 4, 27134},
	{"QQ91", 4, 27135},
	{"QQ92", 4, 27136},
	{"QQ93", 4, 27137},
	{"QQ94", 4, 27138},
	{"QQ95", 4, 27139},
	{"QQ96", 4, 27140},
	{"QQ97", 4, 27141},
	{"QQ98", 4, 27142},
	{"QQ99", 4, 27143},
	{"RB00", 4, 27144},
	{"RB01", 4, 27145},
	{"RB02", 4, 27146},
	{"RB03", 4, 27147},
	{"RB04", 4, 27148},
	{"RB05", 4, 27149},
	{"RB06", 4, 27150},
	{"RB07", 4, 27151},
	{"RB08", 4, 27152},
	{"RB09", 4, 27153},
	{"RB10", 4, 27154},
	{"RB11", 4, 27155},
	{"RB12", 4, 27156},
	{"RB13", 4, 27157},
	{"RB14", 4, 27158},
	{"RB15", 4, 27159},
	{"RB16", 4, 27160},
	{"RB17", 4, 27161},
	{"RB18", 4, 27162},
	{"RB19", 4, 27163},
	{"RB20", 4, 27164},
	{"RB21", 4, 27165},
	{"RB22", 4, 27166},
	{"RB23", 4, 27167},
	{"RB24", 4, 27168},
	{"RB25", 4, 27169},
	{"RB26", 4, 27170},
	{"RB27", 4, 27171},
	{"RB28", 4, 27172},
	{"RB29", 4, 27173},
	{"RB30", 4, 27174},
	{"RB31", 4, 27175},
	{"RB32", 4, 27176},
	{"RB33", 4, 27177},
	{"RB34", 4, 27178},
	{"RB35", 4, 27179},
	{"RB36", 4, 27180},
	{"RB37", 4, 27181},
	{"RB38", 4, 27182},
	{"RB39", 4, 27183},
	{"RB40", 4, 27184},
	{"RB41", 4, 27185},
	{"RB42", 4, 27186},
	{"RB43", 4, 27187},
	{"RB44", 4, 27188},
	{"RB45", 4, 27189},
	{"RB46", 4, 27190},
	{"RB47", 4, 27191},
	{"RB48", 4, 27192},
	{"RB49", 4, 27193},
	{"RB50", 4, 27194},
	{"RB51", 4, 27195},
	{"RB52", 4, 27196},
	{"RB53", 4, 27197},
	{"RB54", 4, 27198},
	{"RB55", 4, 27199},
	{"RB56", 4, 27200},
	{"RB57", 4, 27201},
	{"RB58", 4, 27202},
	{"RB59", 4, 27203},
	{"RB60", 4, 27204},
	{"RB61", 4, 27205},
	{"RB62", 4, 27206},
	{"RB63", 4, 27207},
	{"RB64", 4, 27208},
	{"RB65", 4, 27209},
	{"RB66", 4, 27210},
	{"RB67", 4, 27211},
	{"RB68", 4, 27212},
	{"RB69", 4, 27213},
	{"RB70", 4, 27214},
	{"RB71", 4, 27215},
	{"RB72", 4, 27216},
	{"RB73", 4, 27217},
	{"RB74", 4, 27218},
	{"RB75", 4, 27219},
	{"RB76", 4, 27220},
	{"RB77", 4, 27221},
	{"RB78", 4, 27222},
	{"RB79", 4, 27223},
	{"RB80", 4, 27224},
	{"RB81", 4, 27225},
	{"RB82", 4, 27226},
	{"RB83", 4, 27227},
	{"RB84", 4, 27228},
	{"RB85", 4, 27229},
	{"RB86", 4, 27230},
	{"RB87", 4, 27231},
	{"RB88", 4, 27232},
	{"RB89", 4, 27233},
	{"RB90", 4, 27234},
	{"RB91", 4, 27235},
	{"RB92", 4, 27236},
	{"RB93", 4, 27237},
	{"RB94", 4, 27238},
	{"RB95", 4, 27239},
	{"RB96", 4, 27240},
	{"RB97", 4, 27241},
	{"RB98", 4, 27242},
	{"RB99", 4, 27243},
	{"RE00", 4, 27244},
	{"RE01", 4, 27245},
	{"RE02", 4, 27246},
	{"RE03", 4, 27247},
	{"RE04", 4, 27248},
	{"RE05", 4, 27249},
	{"RE06", 4, 27250},
	{"RE07", 4, 27251},
	{"RE08", 4, 27252},
	{"RE09", 4, 27253},
	{"RE10", 4, 27254},
	{"RE11", 4, 27255},
	{"RE12", 4, 27256},
	{"RE13", 4, 27257},
	{"RE14", 4, 27258},
	{"RE15", 4, 27259},
	{"RE16", 4, 27260},
	{"RE17", 4, 27261},
	{"RE18", 4, 27262},
	{"RE19", 4, 27263},
	{"RE20", 4, 27264},
	{"RE21", 4, 27265},
	{"RE22", 4, 27266},
	{"RE23", 4, 27267},
	{"RE24", 4, 27268},
	{"RE25", 4, 27269},
	{"RE26", 4, 27270},
	{"RE27", 4, 27271},
	{"RE28", 4, 27272},
	{"RE29", 4, 27273},
	{"RE30", 4, 27274},
	{"RE31", 4, 27275},
	{"RE32", 4, 27276},
	{"RE33", 4, 27277},
	{"RE34", 4, 27278},
	{"RE35", 4, 27279},
	{"RE36", 4, 27280},
	{"RE37", 4, 27281},
	{"RE38", 4, 27282},
	{"RE39", 4, 27283},
	{"RE40", 4, 27284},
	{"RE41", 4, 27285},
	{"RE42", 4, 27286},
	{"RE43", 4, 27287},
	{"RE44", 4, 27288},
	{"RE45", 4, 27289},
	{"RE46", 4, 27290},
	{"RE47", 4, 27291},
	{"RE48", 4, 27292},
	{"RE49", 4, 27293},
	{"RE50", 4, 27294},
	{"RE51", 4, 27295},
	{"RE52", 4, 27296},
	{"RE53", 4, 27297},
	{"RE54", 4, 27298},
	{"RE55", 4, 27299},
	{"RE56", 4, 27300},
	{"RE57", 4, 27301},
	{"RE58", 4, 27302},
	{"RE59", 4, 27303},
	{"RE60", 4, 27304},
	{"RE61", 4, 27305},
	{"RE62", 4, 27306},
	{"RE63", 4, 27307},
	{"RE64", 4, 27308},
	{"RE65", 4, 27309},
	{"RE66", 4, 27310},
	{"RE67", 4, 27311},
	{"RE68", 4, 27312},
	{"RE69", 4, 27313},
	{"RE70", 4, 27314},
	{"RE71", 4, 27315},
	{"RE72", 4, 27316},
	{"RE73", 4, 27317},
	{"RE74", 4, 27318},
	{"RE75", 4, 27319},
	{"RE76", 4, 27320},
	{"RE77", 4, 27321},
	{"RE78", 4, 27322},
	{"RE79", 4, 27323},
	{"RE80", 4, 27324},
	{"RE81", 4, 27325},
	{"RE82", 4, 27326},
	{"RE83", 4, 27327},
	{"RE84", 4, 27328},
	{"RE85", 4, 27329},
	{"RE86", 4, 27330},
	{"RE87", 4, 27331},
	{"RE88", 4, 27332},
	{"RE89", 4, 27333},
	{"RE90", 4, 27334},
	{"RE91", 4, 27335},
	{"RE92", 4, 27336},
	{"RE93", 4, 27337},
	{"RE94", 4, 27338},
	{"RE95", 4, 27339},
	{"RE96", 4, 27340},
	{"RE97", 4, 27341},
	{"RE98", 4, 27342},
	{"RE99", 4, 27343},
	{"RF00", 4, 27344},
	{"RF01", 4, 27345},
	{"RF02", 4, 27346},
	{"RF03", 4, 27347},
	{"RF04", 4, 27348},
	{"RF05", 4, 27349},
	{"RF06", 4, 27350},
	{"RF07", 4, 27351},
	{"RF08", 4, 27352},
	{"RF09", 4, 27353},
	{"RF10", 4, 27354},
	{"RF11", 4, 27355},
	{"RF12", 4, 27356},
	{"RF13", 4, 27357},
	{"RF14", 4, 27358},
	{"RF15", 4, 27359},
	{"RF16", 4, 27360},
	{"RF17", 4, 27361},
	{"RF18", 4, 27362},
	{"RF19", 4, 27363},
	{"RF20", 4, 27364},
	{"RF21", 4, 27365},
	{"RF22", 4, 27366},
	{"RF23", 4, 27367},
	{"RF24", 4, 27368},
	{"RF25", 4, 27369},
	{"RF26", 4, 27370},
	{"RF27", 4, 27371},
	{"RF28", 4, 27372},
	{"RF29", 4, 27373},
	{"RF30", 4, 27374},
	{"RF31", 4, 27375},
	{"RF32", 4, 27376},
	{"RF33", 4, 27377},
	{"RF34", 4, 27378},
	{"RF35", 4, 27379},
	{"RF36", 4, 27380},
	{"RF37", 4, 27381},
	{"RF38", 4, 27382},
	{"RF39", 4, 27383},
	{"RF40", 4, 27384},
	{"RF41", 4, 27385},
	{"RF42", 4, 27386},
	{"RF43", 4, 27387},
	{"RF44", 4, 27388},
	{"RF45", 4, 27389},
	{"RF46", 4, 27390},
	{"RF47", 4, 27391},
	{"RF48", 4, 27392},
	{"RF49", 4, 27393},
	{"RF50", 4, 27394},
	{"RF51", 4, 27395},
	{"RF52", 4, 27396},
	{"RF53", 4, 27397},
	{"RF54", 4, 27398},
	{"RF55", 4, 27399},
	{"RF56", 4, 27400},
	{"RF57", 4, 27401},
	{"RF58", 4, 27402},
	{"RF59", 4, 27403},
	{"RF60", 4, 27404},
	{"RF61", 4, 27405},
	{"RF62", 4, 27406},
	{"RF63", 4, 27407},
	{"RF64", 4, 27408},
	{"RF65", 4, 27409},
	{"RF66", 4, 27410},
	{"RF67", 4, 27411},
	{"RF68", 4, 27412},
	{"RF69", 4, 27413},
	{"RF70", 4, 27414},
	{"RF71", 4, 27415},
	{"RF72", 4, 27416},
	{"RF73", 4, 27417},
	{"RF74", 4, 27418},
	{"RF75", 4, 27419},
	{"RF76", 4, 27420},
	{"RF77", 4, 27421},
	{"RF78", 4, 27422},
	{"RF79", 4, 27423},
	{"RF80", 4, 27424},
	{"RF81", 4, 27425},
	{"RF82", 4, 27426},
	{"RF83", 4, 27427},
	{"RF84", 4, 27428},
	{"RF85", 4, 27429},
	{"RF86", 4, 27430},
	{"RF87", 4, 27431},
	{"RF88", 4, 27432},
	{"RF89", 4, 27433},
	{"RF90", 4, 27434},
	{"RF91", 4, 27435},
	{"RF92", 4, 27436},
	{"RF93", 4, 27437},
	{"RF94", 4, 27438},
	{"RF95", 4, 27439},
	{"RF96", 4, 27440},
	{"RF97", 4, 27441},
	{"RF98", 4, 27442},
	{"RF99", 4, 27443},
	{"RG00", 4, 27444},
	{"RG01", 4, 27445},
	{"RG02", 4, 27446},
	{"RG03", 4, 27447},
	{"RG04", 4, 27448},
	{"RG05", 4, 27449},
	{"RG06", 4, 27450},
	{"RG07", 4, 27451},
	{"RG08", 4, 27452},
	{"RG09", 4, 27453},
	{"RG10", 4, 27454},
	{"RG11", 4, 27455},
	{"RG12", 4, 27456},
	{"RG13", 4, 27457},
	{"RG14", 4, 27458},
	{"RG15", 4, 27459},
	{"RG16", 4, 27460},
	{"RG17", 4, 27461},
	{"RG18", 4, 27462},
	{"RG19", 4, 27463},
	{"RG20", 4, 27464},
	{"RG21", 4, 27465},
	{"RG22", 4, 27466},
	{"RG23", 4, 27467},
	{"RG24", 4, 27468},
	{"RG25", 4, 27469},
	{"RG26", 4, 27470},
	{"RG27", 4, 27471},
	{"RG28", 4, 27472},
	{"RG29", 4, 27473},
	{"RG30", 4, 27474},
	{"RG31", 4, 27475},
	{"RG32", 4, 27476},
	{"RG33", 4, 27477},
	{"RG34", 4, 27478},
	{"RG35", 4, 27479},
	{"RG36", 4, 27480},
	{"RG37", 4, 27481},
	{"RG38", 4, 27482},
	{"RG39", 4, 27483},
	{"RG40", 4, 27484},
	{"RG41", 4, 27485},
	{"RG42", 4, 27486},
	{"RG43", 4, 27487},
	{"RG44", 4, 27488},
	{"RG45", 4, 27489},
	{"RG46", 4, 27490},
	{"RG47", 4, 27491},
	{"RG48", 4, 27492},
	{"RG49", 4, 27493},
	{"RG50", 4, 27494},
	{"RG51", 4, 27495},
	{"RG52", 4, 27496},
	{"RG53", 4, 27497},
	{"RG54", 4, 27498},
	{"RG55", 4, 27499},
	{"RG56", 4, 27500},
	{"RG57", 4, 27501},
	{"RG58", 4, 27502},
	{"RG59", 4, 27503},
	{"RG60", 4, 27504},
	{"RG61", 4, 27505},
	{"RG62", 4, 27506},
	{"RG63", 4, 27507},
	{"RG64", 4, 27508},
	{"RG65", 4, 27509},
	{"RG66", 4, 27510},
	{"RG67", 4, 27511},
	{"RG68", 4, 27512},
	{"RG69", 4, 27513},
	{"RG70", 4, 27514},
	{"RG71", 4, 27515},
	{"RG72", 4, 27516},
	{"RG73", 4, 27517},
	{"RG74", 4, 27518},
	{"RG75", 4, 27519},
	{"RG76", 4, 27520},
	{"RG77", 4, 27521},
	{"RG78", 4, 27522},
	{"RG79", 4, 27523},
	{"RG80", 4, 27524},
	{"RG81", 4, 27525},
	{"RG82", 4, 27526},
	{"RG83", 4, 27527},
	{"RG84", 4, 27528},
	{"RG85", 4, 27529},
	{"RG86", 4, 27530},
	{"RG87", 4, 27531},
	{"RG88", 4, 27532},
	{"RG89", 4, 27533},
	{"RG90", 4, 27534},
	{"RG91", 4, 27535},
	{"RG92", 4, 27536},
	{"RG93", 4, 27537},
	{"RG94", 4, 27538},
	{"RG95", 4, 27539},
	{"RG96", 4, 27540},
	{"RG97", 4, 27541},
	{"RG98", 4, 27542},
	{"RG99", 4, 27543},
	{"RH00", 4, 27544},
	{"RH01", 4, 27545},
	{"RH02", 4, 27546},
	{"RH03", 4, 27547},
	{"RH04", 4, 27548},
	{"RH05", 4, 27549},
	{"RH06", 4, 27550},
	{"RH07", 4, 27551},
	{"RH08", 4, 27552},
	{"RH09", 4, 27553},
	{"RH10", 4, 27554},
	{"RH11", 4, 27555},
	{"RH12", 4, 27556},
	{"RH13", 4, 27557},
	{"RH14", 4, 27558},
	{"RH15", 4, 27559},
	{"RH16", 4, 27560},
	{"RH17", 4, 27561},
	{"RH18", 4, 27562},
	{"RH19", 4, 27563},
	{"RH20", 4, 27564},
	{"RH21", 4, 27565},
	{"RH22", 4, 27566},
	{"RH23", 4, 27567},
	{"RH24", 4, 27568},
	{"RH25", 4, 27569},
	{"RH26", 4, 27570},
	{"RH27", 4, 27571},
	{"RH28", 4, 27572},
	{"RH29", 4, 27573},
	{"RH30", 4, 27574},
	{"RH31", 4, 27575},
	{"RH32", 4, 27576},
	{"RH33", 4, 27577},
	{"RH34", 4, 27578},
	{"RH35", 4, 27579},
	{"RH36", 4, 27580},
	{"RH37", 4, 27581},
	{"RH38", 4, 27582},
	{"RH39", 4, 27583},
	{"RH40", 4, 27584},
	{"RH41", 4, 27585},
	{"RH42", 4, 27586},
	{"RH43", 4, 27587},
	{"RH44", 4, 27588},
	{"RH45", 4, 27589},
	{"RH46", 4, 27590},
	{"RH47", 4, 27591},
	{"RH48", 4, 27592},
	{"RH49", 4, 27593},
	{"RH50", 4, 27594},
	{"RH51", 4, 27595},
	{"RH52", 4, 27596},
	{"RH53", 4, 27597},
	{"RH54", 4, 27598},
	{"RH55", 4, 27599},
	{"RH56", 4, 27600},
	{"RH57", 4, 27601},
	{"RH58", 4, 27602},
	{"RH59", 4, 27603},
	{"RH60", 4, 27604},
	{"RH61", 4, 27605},
	{"RH62", 4, 27606},
	{"RH63", 4, 27607},
	{"RH64", 4, 27608},
	{"RH65", 4, 27609},
	{"RH66", 4, 27610},
	{"RH67", 4, 27611},
	{"RH68", 4, 27612},
	{"RH69", 4, 27613},
	{"RH70", 4, 27614},
	{"RH71", 4, 27615},
	{"RH72", 4, 27616},
	{"RH73", 4, 27617},
	{"RH74", 4, 27618},
	{"RH75", 4, 27619},
	{"RH76", 4, 27620},
	{"RH77", 4, 27621},
	{"RH78", 4, 27622},
	{"RH79", 4, 27623},
	{"RH80", 4, 27624},
	{"RH81", 4, 27625},
	{"RH82", 4, 27626},
	{"RH83", 4, 27627},
	{"RH84", 4, 27628},
	{"RH85", 4, 27629},
	{"RH86", 4, 27630},
	{"RH87", 4, 27631},
	{"RH88", 4, 27632},
	{"RH89", 4, 27633},
	{"RH90", 4, 27634},
	{"RH91", 4, 27635},
	{"RH92", 4, 27636},
	{"RH93", 4, 27637},
	{"RH94", 4, 27638},
	{"RH95", 4, 27639},
	{"RH96", 4, 27640},
	{"RH97", 4, 27641},
	{"RH98", 4, 27642},
	{"RH99", 4, 27643},
	{"RJ00", 4, 27644},
	{"RJ01", 4, 27645},
	{"RJ02", 4, 27646},
	{"RJ03", 4, 27647},
	{"RJ04", 4, 27648},
	{"RJ05", 4, 27649},
	{"RJ06", 4, 27650},
	{"RJ07", 4, 27651},
	{"RJ08", 4, 27652},
	{"RJ09", 4, 27653},
	{"RJ10", 4, 27654},
	{"RJ11", 4, 27655},
	{"RJ12", 4, 27656},
	{"RJ13", 4, 27657},
	{"RJ14", 4, 27658},
	{"RJ15", 4, 27659},
	{"RJ16", 4, 27660},
	{"RJ17", 4, 27661},
	{"RJ18", 4, 27662},
	{"RJ19", 4, 27663},
	{"RJ20", 4, 27664},
	{"RJ21", 4, 27665},
	{"RJ22", 4, 27666},
	{"RJ23", 4, 27667},
	{"RJ24", 4, 27668},
	{"RJ25", 4, 27669},
	{"RJ26", 4, 27670},
	{"RJ27", 4, 27671},
	{"RJ28", 4, 27672},
	{"RJ29", 4, 27673},
	{"RJ30", 4, 27674},
	{"RJ31", 4, 27675},
	{"RJ32", 4, 27676},
	{"RJ33", 4, 27677},
	{"RJ34", 4, 27678},
	{"RJ35", 4, 27679},
	{"RJ36", 4, 27680},
	{"RJ37", 4, 27681},
	{"RJ38", 4, 27682},
	{"RJ39", 4, 27683},
	{"RJ40", 4, 27684},
	{"RJ41", 4, 27685},
	{"RJ42", 4, 27686},
	{"RJ43", 4, 27687},
	{"RJ44", 4, 27688},
	{"RJ45", 4, 27689},
	{"RJ46", 4, 27690},
	{"RJ47", 4, 27691},
	{"RJ48", 4, 27692},
	{"RJ49", 4, 27693},
	{"RJ50", 4, 27694},
	{"RJ51", 4, 27695},
	{"RJ52", 4, 27696},
	{"RJ53", 4, 27697},
	{"RJ54", 4, 27698},
	{"RJ55", 4, 27699},
	{"RJ56", 4, 27700},
	{"RJ57", 4, 27701},
	{"RJ58", 4, 27702},
	{"RJ59", 4, 27703},
	{"RJ60", 4, 27704},
	{"RJ61", 4, 27705},
	{"RJ62", 4, 27706},
	{"RJ63", 4, 27707},
	{"RJ64", 4, 27708},
	{"RJ65", 4, 27709},
	{"RJ66", 4, 27710},
	{"RJ67", 4, 27711},
	{"RJ68", 4, 27712},
	{"RJ69", 4, 27713},
	{"RJ70", 4, 27714},
	{"RJ71", 4, 27715},
	{"RJ72", 4, 27716},
	{"RJ73", 4, 27717},
	{"RJ74", 4, 27718},
	{"RJ75", 4, 27719},
	{"RJ76", 4, 27720},
	{"RJ77", 4, 27721},
	{"RJ78", 4, 27722},
	{"RJ79", 4, 27723},
	{"RJ80", 4, 27724},
	{"RJ81", 4, 27725},
	{"RJ82", 4, 27726},
	{"RJ83", 4, 27727},
	{"RJ84", 4, 27728},
	{"RJ85", 4, 27729},
	{"RJ86", 4, 27730},
	{"RJ87", 4, 27731},
	{"RJ88", 4, 27732},
	{"RJ89", 4, 27733},
	{"RJ90", 4, 27734},
	{"RJ91", 4, 27735},
	{"RJ92", 4, 27736},
	{"RJ93", 4, 27737},
	{"RJ94", 4, 27738},
	{"RJ95", 4, 27739},
	{"RJ96", 4, 27740},
	{"RJ97", 4, 27741},
	{"RJ98", 4, 27742},
	{"RJ99", 4, 27743},
	{"RK00", 4, 27744},
	{"RK01", 4, 27745},
	{"RK02", 4, 27746},
	{"RK03", 4, 27747},
	{"RK04", 4, 27748},
	{"RK05", 4, 27749},
	{"RK06", 4, 27750},
	{"RK07", 4, 27751},
	{"RK08", 4, 27752},
	{"RK09", 4, 27753},
	{"RK10", 4, 27754},
	{"RK11", 4, 27755},
	{"RK12", 4, 27756},
	{"RK13", 4, 27757},
	{"RK14", 4, 27758},
	{"RK15", 4, 27759},
	{"RK16", 4, 27760},
	{"RK17", 4, 27761},
	{"RK18", 4, 27762},
	{"RK19", 4, 27763},
	{"RK20", 4, 27764},
	{"RK21", 4, 27765},
	{"RK22", 4, 27766},
	{"RK23", 4, 27767},
	{"RK24", 4, 27768},
	{"RK25", 4, 27769},
	{"RK26", 4, 27770},
	{"RK27", 4, 27771},
	{"RK28", 4, 27772},
	{"RK29", 4, 27773},
	{"RK30", 4, 27774},
	{"RK31", 4, 27775},
	{"RK32", 4, 27776},
	{"RK33", 4, 27777},
	{"RK34", 4, 27778},
	{"RK35", 4, 27779},
	{"RK36", 4, 27780},
	{"RK37", 4, 27781},
	{"RK38", 4, 27782},
	{"RK39", 4, 27783},
	{"RK40", 4, 27784},
	{"RK41", 4, 27785},
	{"RK42", 4, 27786},
	{"RK43", 4, 27787},
	{"RK44", 4, 27788},
	{"RK45", 4, 27789},
	{"RK46", 4, 27790},
	{"RK47", 4, 27791},
	{"RK48", 4, 27792},
	{"RK49", 4, 27793},
	{"RK50", 4, 27794},
	{"RK51", 4, 27795},
	{"RK52", 4, 27796},
	{"RK53", 4, 27797},
	{"RK54", 4, 27798},
	{"RK55", 4, 27799},
	{"RK56", 4, 27800},
	{"RK57", 4, 27801},
	{"RK58", 4, 27802},
	{"RK59", 4, 27803},
	{"RK60", 4, 27804},
	{"RK61", 4, 27805},
	{"RK62", 4, 27806},
	{"RK63", 4, 27807},
	{"RK64", 4, 27808},
	{"RK65", 4, 27809},
	{"RK66", 4, 27810},
	{"RK67", 4, 27811},
	{"RK68", 4, 27812},
	{"RK69", 4, 27813},
	{"RK70", 4, 27814},
	{"RK71", 4, 27815},
	{"RK72", 4, 27816},
	{"RK73", 4, 27817},
	{"RK74", 4, 27818},
	{"RK75", 4, 27819},
	{"RK76", 4, 27820},
	{"RK77", 4, 27821},
	{"RK78", 4, 27822},
	{"RK79", 4, 27823},
	{"RK80", 4, 27824},
	{"RK81", 4, 27825},
	{"RK82", 4, 27826},
	{"RK83", 4, 27827},
	{"RK84", 4, 27828},
	{"RK85", 4, 27829},
	{"RK86", 4, 27830},
	{"RK87", 4, 27831},
	{"RK88", 4, 27832},
	{"RK89", 4, 27833},
	{"RK90", 4, 27834},
	{"RK91", 4, 27835},
	{"RK92", 4, 27836},
	{"RK93", 4, 27837},
	{"RK94", 4, 27838},
	{"RK95", 4, 27839},
	{"RK96", 4, 27840},
	{"RK97", 4, 27841},
	{"RK98", 4, 27842},
	{"RK99", 4, 27843},
	{"RO00", 4, 27844},
	{"RO01", 4, 27845},
	{"RO02", 4, 27846},
	{"RO03", 4, 27847},
	{"RO04", 4, 27848},
	{"RO05", 4, 27849},
	{"RO06", 4, 27850},
	{"RO07", 4, 27851},
	{"RO08", 4, 27852},
	{"RO09", 4, 27853},
	{"RO10", 4, 27854},
	{"RO11", 4, 27855},
	{"RO12", 4, 27856},
	{"RO13", 4, 27857},
	{"RO14", 4, 27858},
	{"RO15", 4, 27859},
	{"RO16", 4, 27860},
	{"RO17", 4, 27861},
	{"RO18", 4, 27862},
	{"RO19", 4, 27863},
	{"RO20", 4, 27864},
	{"RO21", 4, 27865},
	{"RO22", 4, 27866},
	{"RO23", 4, 27867},
	{"RO24", 4, 27868},
	{"RO25", 4, 27869},
	{"RO26", 4, 27870},
	{"RO27", 4, 27871},
	{"RO28", 4, 27872},
	{"RO29", 4, 27873},
	{"RO30", 4, 27874},
	{"RO31", 4, 27875},
	{"RO32", 4, 27876},
	{"RO33", 4, 27877},
	{"RO34", 4, 27878},
	{"RO35", 4, 27879},
	{"RO36", 4, 27880},
	{"RO37", 4, 27881},
	{"RO38", 4, 27882},
	{"RO39", 4, 27883},
	{"RO40", 4, 27884},
	{"RO41", 4, 27885},
	{"RO42", 4, 27886},
	{"RO43", 4, 27887},
	{"RO44", 4, 27888},
	{"RO45", 4, 27889},
	{"RO46", 4, 27890},
	{"RO47", 4, 27891},
	{"RO48", 4, 27892},
	{"RO49", 4, 27893},
	{"RO50", 4, 27894},
	{"RO51", 4, 27895},
	{"RO52", 4, 27896},
	{"RO53", 4, 27897},
	{"RO54", 4, 27898},
	{"RO55", 4, 27899},
	{"RO56", 4, 27900},
	{"RO57", 4, 27901},
	{"RO58", 4, 27902},
	{"RO59", 4, 27903},
	{"RO60", 4, 27904},
	{"RO61", 4, 27905},
	{"RO62", 4, 27906},
	{"RO63", 4, 27907},
	{"RO64", 4, 27908},
	{"RO65", 4, 27909},
	{"RO66", 4, 27910},
	{"RO67", 4, 27911},
	{"RO68", 4, 27912},
	{"RO69", 4, 27913},
	{"RO70", 4, 27914},
	{"RO71", 4, 27915},
	{"RO72", 4, 27916},
	{"RO73", 4, 27917},
	{"RO74", 4, 27918},
	{"RO75", 4, 27919},
	{"RO76", 4, 27920},
	{"RO77", 4, 27921},
	{"RO78", 4, 27922},
	{"RO79", 4, 27923},
	{"RO80", 4, 27924},
	{"RO81", 4, 27925},
	{"RO82", 4, 27926},
	{"RO83", 4, 27927},
	{"RO84", 4, 27928},
	{"RO85", 4, 27929},
	{"RO86", 4, 27930},
	{"RO87", 4, 27931},
	{"RO88", 4, 27932},
	{"RO89", 4, 27933},
	{"RO90", 4, 27934},
	{"RO91", 4, 27935},
	{"RO92", 4, 27936},
	{"RO93", 4, 27937},
	{"RO94", 4, 27938},
	{"RO95", 4, 27939},
	{"RO96", 4, 27940},
	{"RO97", 4, 27941},
	{"RO98", 4, 27942},
	{"RO99", 4, 27943},
	{"RP00", 4, 27944},
	{"RP01", 4, 27945},
	{"RP02", 4, 27946},
	{"RP03", 4, 27947},
	{"RP04", 4, 27948},
	{"RP05", 4, 27949},
	{"RP06", 4, 27950},
	{"RP07", 4, 27951},
	{"RP08", 4, 27952},
	{"RP09", 4, 27953},
	{"RP10", 4, 27954},
	{"RP11", 4, 27955},
	{"RP12", 4, 27956},
	{"RP13", 4, 27957},
	{"RP14", 4, 27958},
	{"RP15", 4, 27959},
	{"RP16", 4, 27960},
	{"RP17", 4, 27961},
	{"RP18", 4, 27962},
	{"RP19", 4, 27963},
	{"RP20", 4, 27964},
	{"RP21", 4, 27965},
	{"RP22", 4, 27966},
	{"RP23", 4, 27967},
	{"RP24", 4, 27968},
	{"RP25", 4, 27969},
	{"RP26", 4, 27970},
	{"RP27", 4, 27971},
	{"RP28", 4, 27972},
	{"RP29", 4, 27973},
	{"RP30", 4, 27974},
	{"RP31", 4, 27975},
	{"RP32", 4, 27976},
	{"RP33", 4, 27977},
	{"RP34", 4, 27978},
	{"RP35", 4, 27979},
	{"RP36", 4, 27980},
	{"RP37", 4, 27981},
	{"RP38", 4, 27982},
	{"RP39", 4, 27983},
	{"RP40", 4, 27984},
	{"RP41", 4, 27985},
	{"RP42", 4, 27986},
	{"RP43", 4, 27987},
	{"RP44", 4, 27988},
	{"RP45", 4, 27989},
	{"RP46", 4, 27990},
	{"RP47", 4, 27991},
	{"RP48", 4, 27992},
	{"RP49", 4, 27993},
	{"RP50", 4, 27994},
	{"RP51", 4, 27995},
	{"RP52", 4, 27996},
	{"RP53", 4, 27997},
	{"RP54", 4, 27998},
	{"RP55", 4, 27999},
	{"RP56", 4, 28000},
	{"RP57", 4, 28001},
	{"RP58", 4, 28002},
	{"RP59", 4, 28003},
	{"RP60", 4, 28004},
	{"RP61", 4, 28005},
	{"RP62", 4, 28006},
	{"RP63", 4, 28007},
	{"RP64", 4, 28008},
	{"RP65", 4, 28009},
	{"RP66", 4, 28010},
	{"RP67", 4, 28011},
	{"RP68", 4, 28012},
	{"RP69", 4, 28013},
	{"RP70", 4, 28014},
	{"RP71", 4, 28015},
	{"RP72", 4, 28016},
	{"RP73", 4, 28017},
	{"RP74", 4, 28018},
	{"RP75", 4, 28019},
	{"RP76", 4, 28020},
	{"RP77", 4, 28021},
	{"RP78", 4, 28022},
	{"RP79", 4, 28023},
	{"RP80", 4, 28024},
	{"RP81", 4, 28025},
	{"RP82", 4, 28026},
	{"RP83", 4, 28027},
	{"RP84", 4, 28028},
	{"RP85", 4, 28029},
	{"RP86", 4, 28030},
	{"RP87", 4, 28031},
	{"RP88", 4, 28032},
	{"RP89", 4, 28033},
	{"RP90", 4, 28034},
	{"RP91", 4, 28035},
	{"RP92", 4, 28036},
	{"RP93", 4, 28037},
	{"RP94", 4, 28038},
	{"RP95", 4, 28039},
	{"RP96", 4, 28040},
	{"RP97", 4, 28041},
	{"RP98", 4, 28042},
	{"RP99", 4, 28043},
	{"IALO", 4, 28044},
	{"ASTRONOMY", 9, 28045},
	{"LANKA", 5, 28046},
	{"RYWH", 4, 28047},
	{"ACEF", 4, 28048},
	{"PRIVACY", 7, 28049},
	{"CABIN", 5, 28050},
	{"NDRU", 4, 28051},
	{"EDWARDS", 7, 28052},
	{"DREW", 4, 28053},
	{"CONTESTS", 8, 28054},
	{"FLU", 3, 28055},
	{"COPE", 4, 28056},
	{"UPPE", 4, 28057},
	{"BARREL", 6, 28058},
	{"ANNOUNCES", 9, 28059},
	{"MLB", 3, 28060},
	{"HESL", 4, 28061},
	{"ARSW", 4, 28062},
	{"TAGGED", 6, 28063},
	{"LSER", 4, 28064},
	{"EAGR", 4, 28065},
	{"BERKELEY", 8, 28066},
	{"HDOW", 4, 28067},
	{"VOTED", 5, 28068},
	{"BIKES", 5, 28069},
	{"LYMP", 4, 28070},
	{"NERVE", 5, 28071},
	{"IMEM", 4, 28072},
	{"YWAN", 4, 28073},
	{"GATES", 5, 28074},
	{"RESTRICTION", 11, 28075},
	{"ADJUSTED", 8, 28076},
	{"WORKSHOP", 8, 28077},
	{"BUTC", 4, 28078},
	{"RAP", 3, 28079},
	{"LMIN", 4, 28080},
	{"PULLED", 6, 28081},
	{"PRINCIPAL", 9, 28082},
	{"CONTROVERSIAL", 13, 28083},
	{"LDES", 4, 28084},
	{"SHAPED", 6, 28085},
	{"ANUF", 4, 28086},
	{"INSTRUCTOR", 10, 28087},
	{"COMPRESSION", 11, 28088},
	{"SEASONAL", 8, 28089},
	{"KOFT", 4, 28090},
	{"ESTABLISHING", 12, 28091},
	{"VYU", 3, 28092},
	{"PTIN", 4, 28093},
	{"LIFESTYLE", 9, 28094},
	{"COUNTERS", 8, 28095},
	{"HESY", 4, 28096},
	{"OFFENSIVE", 9, 28097},
	{"PUTS", 4, 28098},
	{"NYIN", 4, 28099},
	{"GOTI", 4, 28100},
	{"PAINFUL", 7, 28101},
	{"IMPRESS", 7, 28102},
	{"GREW", 4, 28103},
	{"THWH", 4, 28104},
	{"VEMA", 4, 28105},
	{"STROKE", 6, 28106},
	{"HYPOTHESIS", 10, 28107},
	{"SKQ", 3, 28108},
	{"CULTURES", 8, 28109},
	{"NORFOLK", 7, 28110},
	{"NSRE", 4, 28111},
	{"COACHING", 8, 28112},
	{"EXAMINED", 8, 28113},
	{"TREK", 4, 28114},
	{"EREQ", 4, 28115},
	{"SOPHISTICATED", 13, 28116},
	{"EREU", 4, 28117},
	{"NUFA", 4, 28118},
	{"AYSB", 4, 28119},
	{"IRCR", 4, 28120},
	{"ENCODING", 8, 28121},
	{"DSTE", 4, 28122},
	{"ROUB", 4, 28123},
	{"LITIGATION", 10, 28124},
	{"GIOU", 4, 28125},
	{"UTOM", 4, 28126},
	{"DMIT", 4, 28127},
	{"UTWE", 4, 28128},
	{"ASSIGNMENT", 10, 28129},
	{"SUBMISSIONS", 11, 28130},
	{"DISCRIMINATION", 14, 28131},
	{"HEROES", 6, 28132},
	{"FLESH", 5, 28133},
	{"PAINTED", 7, 28134},
	{"LYCOS", 5, 28135},
	{"AVEE", 4, 28136},
	{"ZDNET", 5, 28137},
	{"ELLB", 4, 28138},
	{"BROADCASTING", 12, 28139},
	{"RBRO", 4, 28140},
	{"HORIZON", 7, 28141},
	{"HORIZONTAL", 10, 28142},
	{"ARTWORK", 7, 28143},
	{"UETH", 4, 28144},
	{"GAZE", 4, 28145},
	{"COSMETIC", 8, 28146},
	{"NEDU", 4, 28147},
	{"RESULTED", 8, 28148},
	{"INFORMATIONAL", 13, 28149},
	{"CARRIERS", 8, 28150},
	{"ECOMMERCE", 9, 28151},
	{"MOBILITY", 8, 28152},
	{"URNO", 4, 28153},
	{"FLORAL", 6, 28154},
	{"OACC", 4, 28155},
	{"BUILDERS", 8, 28156},
	{"SCHEMES", 7, 28157},
	{"LESP", 4, 28158},
	{"ERGI", 4, 28159},
	{"CONVICTION", 10, 28160},
	{"FISHER", 6, 28161},
	{"HETU", 4, 28162},
	{"GIRLFRIEND", 10, 28163},
	{"LLDO", 4, 28164},
	{"DLAT", 4, 28165},
	{"UNDERGO", 7, 28166},
	{"HEYT", 4, 28167},
	{"SPEARS", 6, 28168},
	{"OPAY", 4, 28169},
	{"TGAM", 4, 28170},
	{"PINE", 4, 28171},
	{"RRET", 4, 28172},
	{"MANUFACTURING", 13, 28173},
	{"WANDER", 6, 28174},
	{"PROSPECTIVE", 11, 28175},
	{"EXPLODE", 7, 28176},
	{"CLUSTER", 7, 28177},
	{"NMIL", 4, 28178},
	{"USTW", 4, 28179},
	{"HEOU", 4, 28180},
	{"SRIG", 4, 28181},
	{"ALSU", 4, 28182},
	{"BEDDING", 7, 28183},
	{"DESO", 4, 28184},
	{"JOINING", 7, 28185},
	{"HEADING", 7, 28186},
	{"BEARING", 7, 28187},
	{"ISHC", 4, 28188},
	{"EFTT", 4, 28189},
	{"BRUSH", 5, 28190},
	{"COORDINATION", 12, 28191},
	{"CONNECTOR", 9, 28192},
	{"LAYT", 4, 28193},
	{"BRAD", 4, 28194},
	{"WAYO", 4, 28195},
	{"ECIE", 4, 28196},
	{"COMBO", 5, 28197},
	{"SENIORS", 7, 28198},
	{"WORLDS", 6, 28199},
	{"SUBSEQUENT", 10, 28200},
	{"DESPERATE", 9, 28201},
	{"EUZ", 3, 28202},
	{"BATTERY", 7, 28203},
	{"IDENTIFICATION", 14, 28204},
	{"AFFILIATED", 10, 28205},
	{"MEDICATION", 10, 28206},
	{"INOU", 4, 28207},
	{"ASPL", 4, 28208},
	{"ACTIVATION", 10, 28209},
	{"TOCL", 4, 28210},
	{"DYQ", 3, 28211},
	{"YSPE", 4, 28212},
	{"IZON", 4, 28213},
	{"SPAP", 4, 28214},
	{"HAVEN", 5, 28215},
	{"TABLET", 6, 28216},
	{"DSEC", 4, 28217},
	{"TPRI", 4, 28218},
	{"RIFI", 4, 28219},
	{"ACID", 4, 28220},
	{"NTSU", 4, 28221},
	{"EISC", 4, 28222},
	{"IKY", 3, 28223},
	{"RSEE", 4, 28224},
	{"SUBSCRIBERS", 11, 28225},
	{"ISBR", 4, 28226},
	{"TSSU", 4, 28227},
	{"ONLE", 4, 28228},
	{"DSEN", 4, 28229},
	{"ABSORB", 6, 28230},
	{"EFAI", 4, 28231},
	{"MITSUBISHI", 10, 28232},
	{"ECONOMICS", 9, 28233},
	{"INFLATION", 9, 28234},
	{"CONSCIOUSNESS", 13, 28235},
	{"ENAG", 4, 28236},
	{"UNDERWEAR", 9, 28237},
	{"ORANGE", 6, 28238},
	{"TNAM", 4, 28239},
	{"CKUP", 4, 28240},
	{"BASIN", 5, 28241},
	{"ROFC", 4, 28242},
	{"OXU", 3, 28243},
	{"DGEO", 4, 28244},
	{"EAVA", 4, 28245},
	{"MODEST", 6, 28246},
	{"RDES", 4, 28247},
	{"ESDO", 4, 28248},
	{"ANYB", 4, 28249},
	{"RSLA", 4, 28250},
	{"PROMPT", 6, 28251},
	{"CONSTRAINTS", 11, 28252},
	{"PHOTOGRAPHER", 12, 28253},
	{"CROSSING", 8, 28254},
	{"CURIOUS", 7, 28255},
	{"CIPL", 4, 28256},
	{"HANDFUL", 7, 28257},
	{"INCLUSIVE", 9, 28258},
	{"COTTON", 6, 28259},
	{"DIMENSIONAL", 11, 28260},
	{"ONSM", 4, 28261},
	{"OWEL", 4, 28262},
	{"DEMONSTRATION", 13, 28263},
	{"SUCCESSFULLY", 12, 28264},
	{"CRIMES", 6, 28265},
	{"RESOLVED", 8, 28266},
	{"AGAZ", 4, 28267},
	{"MOZILLA", 7, 28268},
	{"CZO", 3, 28269},
	{"BYTE", 4, 28270},
	{"DEPICT", 6, 28271},
	{"TONER", 5, 28272},
	{"RTQ", 3, 28273},
	{"FLAME", 5, 28274},
	{"SNEV", 4, 28275},
	{"LATEX", 5, 28276},
	{"RYRE", 4, 28277},
	{"ECRA", 4, 28278},
	{"BRANCHES", 8, 28279},
	{"EMIE", 4, 28280},
	{"VALLEY", 6, 28281},
	{"TZV", 3, 28282},
	{"YREP", 4, 28283},
	{"OCLC", 4, 28284},
	{"DELHI", 5, 28285},
	{"HOLDINGS", 8, 28286},
	{"ECLE", 4, 28287},
	{"STFI", 4, 28288},
	{"NOMINATION", 10, 28289},
	{"DPOI", 4, 28290},
	{"GOD", 3, 28291},
	{"LOCATOR", 7, 28292},
	{"SELECTING", 9, 28293},
	{"STANDING", 8, 28294},
	{"NBRO", 4, 28295},
	{"ESOV", 4, 28296},
	{"AYNI", 4, 28297},
	{"RHOM", 4, 28298},
	{"CIVILIAN", 8, 28299},
	{"SINB", 4, 28300},
	{"PROCESSORS", 10, 28301},
	{"ASBU", 4, 28302},
	{"DISTINCT", 8, 28303},
	{"YZS", 3, 28304},
	{"PLC", 3, 28305},
	{"LDOF", 4, 28306},
	{"BROKE", 5, 28307},
	{"ISPU", 4, 28308},
	{"NEPAL", 5, 28309},
	{"YUZ", 3, 28310},
	{"ZIMBABWE", 8, 28311},
	{"RHOU", 4, 28312},
	{"TEDN", 4, 28313},
	{"EINW", 4, 28314},
	{"EXTENSION", 9, 28315},
	{"VEYE", 4, 28316},
	{"EDIV", 4, 28317},
	{"DIFFICULTIES", 12, 28318},
	{"TGRO", 4, 28319},
	{"HERITAGE", 8, 28320},
	{"SMOV", 4, 28321},
	{"HABITAT", 7, 28322},
	{"DISTINGUISH", 11, 28323},
	{"JUAN", 4, 28324},
	{"DBRI", 4, 28325},
	{"BROWSING", 8, 28326},
	{"IRGI", 4, 28327},
	{"HUMOR", 5, 28328},
	{"HUNGRY", 6, 28329},
	{"OSAL", 4, 28330},
	{"BADLY", 5, 28331},
	{"SBUI", 4, 28332},
	{"BARCELONA", 9, 28333},
	{"SEDH", 4, 28334},
	{"NBYT", 4, 28335},
	{"UEOF", 4, 28336},
	{"COD", 3, 28337},
	{"TERRITORIES", 11, 28338},
	{"MELISSA", 7, 28339},
	{"POWDER", 6, 28340},
	{"EDITION", 7, 28341},
	{"MOSCOW", 6, 28342},
	{"NKST", 4, 28343},
	{"TVV", 3, 28344},
	{"SLIG", 4, 28345},
	{"THESIS", 6, 28346},
	{"ORAG", 4, 28347},
	{"THRU", 4, 28348},
	{"STSU", 4, 28349},
	{"REDP", 4, 28350},
	{"JEWS", 4, 28351},
	{"NYLON", 5, 28352},
	{"PSTH", 4, 28353},
	{"PEOF", 4, 28354},
	{"SUMMIT", 6, 28355},
	{"COLONIAL", 8, 28356},
	{"EAGER", 5, 28357},
	{"EALB", 4, 28358},
	{"DISCS", 5, 28359},
	{"SHOWER", 6, 28360},
	{"ROCKY", 5, 28361},
	{"RTRE", 4, 28362},
	{"ZGO", 3, 28363},
	{"BARGAINS", 8, 28364},
	{"ABSOLUTE", 8, 28365},
	{"ETUP", 4, 28366},
	{"SDID", 4, 28367},
	{"AINB", 4, 28368},
	{"ODEA", 4, 28369},
	{"LFOF", 4, 28370},
	{"NIGERIA", 7, 28371},
	{"ORKW", 4, 28372},
	{"ONAG", 4, 28373},
	{"ELOF", 4, 28374},
	{"LSOM", 4, 28375},
	{"LYDO", 4, 28376},
	{"LLIG", 4, 28377},
	{"PIXELS", 6, 28378},
	{"ENSURING", 8, 28379},
	{"BUTD", 4, 28380},
	{"INAG", 4, 28381},
	{"OXJ", 3, 28382},
	{"YSER", 4, 28383},
	{"COMEDY", 6, 28384},
	{"HOSPITALITY", 11, 28385},
	{"FANY", 4, 28386},
	{"NDJO", 4, 28387},
	{"ONFL", 4, 28388},
	{"PROCUREMENT", 11, 28389},
	{"DIAMONDS", 8, 28390},
	{"ESPN", 4, 28391},
	{"AMPU", 4, 28392},
	{"PITCH", 5, 28393},
	{"RMOF", 4, 28394},
	{"UNTITLED", 8, 28395},
	{"AYSS", 4, 28396},
	{"CORRELATION", 11, 28397},
	{"LLYG", 4, 28398},
	{"SLOO", 4, 28399},
	{"ELET", 4, 28400},
	{"GZI", 3, 28401},
	{"TOTALS", 6, 28402},
	{"MARRIOTT", 8, 28403},
	{"TBEI", 4, 28404},
	{"GARAGE", 6, 28405},
	{"SINGING", 7, 28406},
	{"ONPO", 4, 28407},
	{"EXERCISES", 9, 28408},
	{"ZKA", 3, 28409},
	{"STARRING", 8, 28410},
	{"REFERRAL", 8, 28411},
	{"DIFFERENTLY", 11, 28412},
	{"GHOST", 5, 28413},
	{"HENP", 4, 28414},
	{"ROMANTIC", 8, 28415},
	{"ETHICS", 6, 28416},
	{"TRANSFORMATION", 14, 28417},
	{"GYV", 3, 28418},
	{"TLEB", 4, 28419},
	{"ILSO", 4, 28420},
	{"OPTIMAL", 7, 28421},
	{"OFAD", 4, 28422},
	{"OVERLOOK", 8, 28423},
	{"ASWO", 4, 28424},
	{"PROTOCOLS", 9, 28425},
	{"OWNH", 4, 28426},
	{"OIMP", 4, 28427},
	{"DATH", 4, 28428},
	{"LEGITIMATE", 10, 28429},
	{"LLWI", 4, 28430},
	{"APPOINT", 7, 28431},
	{"GSOF", 4, 28432},
	{"NDUP", 4, 28433},
	{"NTLI", 4, 28434},
	{"SUBSTITUTE", 10, 28435},
	{"NSEV", 4, 28436},
	{"FLEC", 4, 28437},
	{"INCLUSION", 9, 28438},
	{"RMIL", 4, 28439},
	{"AIRM", 4, 28440},
	{"TURNER", 6, 28441},
	{"NFID", 4, 28442},
	{"SUCKING", 7, 28443},
	{"CENTS", 5, 28444},
	{"REUTERS", 7, 28445},
	{"MEDIUM", 6, 28446},
	{"GEL", 3, 28447},
	{"GRAIN", 5, 28448},
	{"TODD", 4, 28449},
	{"IANP", 4, 28450},
	{"SPOKEN", 6, 28451},
	{"RTIF", 4, 28452},
	{"OMEGA", 5, 28453},
	{"GESI", 4, 28454},
	{"EVALUATED", 9, 28455},
	{"SSPO", 4, 28456},
	{"STAYED", 6, 28457},
	{"LPHI", 4, 28458},
	{"KSOF", 4, 28459},
	{"ASSIGNMENTS", 11, 28460},
	{"MZE", 3, 28461},
	{"LLME", 4, 28462},
	{"TWOC", 4, 28463},
	{"MANUALS", 7, 28464},
	{"SUBMIT", 6, 28465},
	{"DOUG", 4, 28466},
	{"AFRE", 4, 28467},
	{"TERMINATION", 11, 28468},
	{"VEAC", 4, 28469},
	{"ZPO", 3, 28470},
	{"LDSA", 4, 28471},
	{"WATCHED", 7, 28472},
	{"BRILLIANT", 9, 28473},
	{"PROVINCE", 8, 28474},
	{"DSFO", 4, 28475},
	{"SAVER", 5, 28476},
	{"THEREOF", 7, 28477},
	{"ALKS", 4, 28478},
	{"GRILL", 5, 28479},
	{"UXP", 3, 28480},
	{"HOUSEHOLDS", 10, 28481},
	{"OPERATING", 9, 28482},
	{"COOKIE", 6, 28483},
	{"RIAG", 4, 28484},
	{"REDEEM", 6, 28485},
	{"ROGERS", 6, 28486},
	{"ERTW", 4, 28487},
	{"LYFR", 4, 28488},
	{"OFUN", 4, 28489},
	{"HIPW", 4, 28490},
	{"BSTA", 4, 28491},
	{"ALLR", 4, 28492},
	{"AUTHENTIC", 9, 28493},
	{"ERID", 4, 28494},
	{"RCZ", 3, 28495},
	{"TEMPORARY", 9, 28496},
	{"WANNA", 5, 28497},
	{"RRIA", 4, 28498},
	{"MONTGOMERY", 10, 28499},
	{"LEGACY", 6, 28500},
	{"EXHIBIT", 7, 28501},
	{"ARCHITECTURAL", 13, 28502},
	{"LOUISVILLE", 10, 28503},
	{"ARBE", 4, 28504},
	{"BOOM", 4, 28505},
	{"ORYI", 4, 28506},
	{"MACINTOSH", 9, 28507},
	{"SERVING", 7, 28508},
	{"MOVEMENTS", 9, 28509},
	{"RYWA", 4, 28510},
	{"MOUSE", 5, 28511},
	{"EBOD", 4, 28512},
	{"ACTRESS", 7, 28513},
	{"BVIO", 4, 28514},
	{"RANGING", 7, 28515},
	{"SEWE", 4, 28516},
	{"MONICA", 6, 28517},
	{"REPAIRS", 7, 28518},
	{"WHOT", 4, 28519},
	{"APHY", 4, 28520},
	{"EBEF", 4, 28521},
	{"YKNO", 4, 28522},
	{"EWRI", 4, 28523},
	{"RWHA", 4, 28524},
	{"EWRO", 4, 28525},
	{"TBEL", 4, 28526},
	{"AMENITIES", 9, 28527},
	{"COLE", 4, 28528},
	{"SMEA", 4, 28529},
	{"IKEM", 4, 28530},
	{"OFBR", 4, 28531},
	{"MART", 4, 28532},
	{"CEDO", 4, 28533},
	{"HANGING", 7, 28534},
	{"COLORED", 7, 28535},
	{"NLYS", 4, 28536},
	{"NGEX", 4, 28537},
	{"NFLI", 4, 28538},
	{"ARTISTIC", 8, 28539},
	{"AUTHORIZATION", 13, 28540},
	{"VERIFIED", 8, 28541},
	{"LYNN", 4, 28542},
	{"PROJECTOR", 9, 28543},
	{"ERJO", 4, 28544},
	{"OCOL", 4, 28545},
	{"SITUATED", 8, 28546},
	{"COMPARATIVE", 11, 28547},
	{"LYAC", 4, 28548},
	{"INVASION", 8, 28549},
	{"MPIR", 4, 28550},
	{"SEEKS", 5, 28551},
	{"TYHA", 4, 28552},
	{"HERBAL", 6, 28553},
	{"LOVING", 6, 28554},
	{"ROUTING", 7, 28555},
	{"ADEQUATE", 8, 28556},
	{"IDID", 4, 28557},
	{"TOFB", 4, 28558},
	{"IONG", 4, 28559},
	{"DOCS", 4, 28560},
	{"WOUND", 5, 28561},
	{"NTDO", 4, 28562},
	{"COOKING", 7, 28563},
	{"CONTINUED", 9, 28564},
	{"WKO", 3, 28565},
	{"TTRI", 4, 28566},
	{"STANLEY", 7, 28567},
	{"RSBU", 4, 28568},
	{"IDEW", 4, 28569},
	{"LLBU", 4, 28570},
	{"NREP", 4, 28571},
	{"REGISTER", 8, 28572},
	{"COUNSEL", 7, 28573},
	{"BLANKET", 7, 28574},
	{"COLLECTIVE", 10, 28575},
	{"EORD", 4, 28576},
	{"AZQ", 3, 28577},
	{"ILMS", 4, 28578},
	{"VITAMINS", 8, 28579},
	{"LFRO", 4, 28580},
	{"COMPETITOR", 10, 28581},
	{"GAINS", 5, 28582},
	{"SONP", 4, 28583},
	{"RENEWAL", 7, 28584},
	{"OWAT", 4, 28585},
	{"VID", 3, 28586},
	{"GENEALOGY", 9, 28587},
	{"NBEF", 4, 28588},
	{"IKEI", 4, 28589},
	{"DEEMED", 6, 28590},
	{"SCORING", 7, 28591},
	{"NOFH", 4, 28592},
	{"YNL", 3, 28593},
	{"EXCEED", 6, 28594},
	{"EXPENDITURE", 11, 28595},
	{"ITUD", 4, 28596},
	{"BROOKLYN", 8, 28597},
	{"NORM", 4, 28598},
	{"STBA", 4, 28599},
	{"LIVERPOOL", 9, 28600},
	{"YLAN", 4, 28601},
	{"SISTERS", 7, 28602},
	{"CRITICS", 7, 28603},
	{"UNCLE", 5, 28604},
	{"CONNECTIVITY", 12, 28605},
	{"UGHE", 4, 28606},
	{"NELI", 4, 28607},
	{"SPOTS", 5, 28608},
	{"OPERATOR", 8, 28609},
	{"ALGORITHMS", 10, 28610},
	{"HACKER", 6, 28611},
	{"YKY", 3, 28612},
	{"VEWI", 4, 28613},
	{"MADRID", 6, 28614},
	{"ANTICIPATE", 10, 28615},
	{"REINFORCE", 9, 28616},
	{"EANC", 4, 28617},
	{"ACKB", 4, 28618},
	{"NBAS", 4, 28619},
	{"HPLA", 4, 28620},
	{"KYV", 3, 28621},
	{"SLICE", 5, 28622},
	{"REDC", 4, 28623},
	{"YIMP", 4, 28624},
	{"MESF", 4, 28625},
	{"FAKE", 4, 28626},
	{"EZK", 3, 28627},
	{"STWH", 4, 28628},
	{"LDSE", 4, 28629},
	{"CONCERNING", 10, 28630},
	{"EIRW", 4, 28631},
	{"LOVELY", 6, 28632},
	{"IERT", 4, 28633},
	{"DEVOTE", 6, 28634},
	{"ILEI", 4, 28635},
	{"SALON", 5, 28636},
	{"RSOL", 4, 28637},
	{"WIDESPREAD", 10, 28638},
	{"TCOL", 4, 28639},
	{"BASKET", 6, 28640},
	{"AYON", 4, 28641},
	{"VENM", 4, 28642},
	{"INSW", 4, 28643},
	{"COLLABORATIVE", 13, 28644},
	{"NORMAN", 6, 28645},
	{"FDA", 3, 28646},
	{"EXCLUDING", 9, 28647},
	{"YTOA", 4, 28648},
	{"XJU", 3, 28649},
	{"TURBO", 5, 28650},
	{"HEADED", 6, 28651},
	{"VOTERS", 6, 28652},
	{"COUNSELING", 10, 28653},
	{"AWFUL", 5, 28654},
	{"ROPE", 4, 28655},
	{"PERMISSION", 10, 28656},
	{"WEEKLY", 6, 28657},
	{"IMPLEMENTATION", 14, 28658},
	{"DECREASE", 8, 28659},
	{"MADONNA", 7, 28660},
	{"LESF", 4, 28661},
	{"MWHI", 4, 28662},
	{"ARCH", 4, 28663},
	{"OMAL", 4, 28664},
	{"DBYC", 4, 28665},
	{"MURPHY", 6, 28666},
	{"THINKS", 6, 28667},
	{"THATS", 5, 28668},
	{"HDTV", 4, 28669},
	{"PHILLIPS", 8, 28670},
	{"VENTURE", 7, 28671},
	{"AIMED", 5, 28672},
	{"JUSTIN", 6, 28673},
	{"TWOD", 4, 28674},
	{"FIGHTING", 8, 28675},
	{"MIRRORS", 7, 28676},
	{"ASDO", 4, 28677},
	{"HEADLINE", 8, 28678},
	{"RUNNING", 7, 28679},
	{"SPOTLIGHT", 9, 28680},
	{"TRICKS", 6, 28681},
	{"TFOU", 4, 28682},
	{"RESET", 5, 28683},
	{"UGLY", 4, 28684},
	{"FREQUENT", 8, 28685},
	{"IALR", 4, 28686},
	{"EXPANSYS", 8, 28687},
	{"PANELS", 6, 28688},
	{"REPEATED", 8, 28689},
	{"EXJ", 3, 28690},
	{"TMAT", 4, 28691},
	{"TCHT", 4, 28692},
	{"YMPI", 4, 28693},
	{"FITNESS", 7, 28694},
	{"LAP", 3, 28695},
	{"CONNECTING", 10, 28696},
	{"THMO", 4, 28697},
	{"BLEP", 4, 28698},
	{"LOGISTICS", 9, 28699},
	{"ANTP", 4, 28700},
	{"KODAK", 5, 28701},
	{"YTOC", 4, 28702},
	{"ATAP", 4, 28703},
	{"EADL", 4, 28704},
	{"CARRIER", 7, 28705},
	{"LSEA", 4, 28706},
	{"CONSENSUS", 9, 28707},
	{"BOWLING", 7, 28708},
	{"RLDC", 4, 28709},
	{"NSFR", 4, 28710},
	{"NGMI", 4, 28711},
	{"GQI", 3, 28712},
	{"DFRE", 4, 28713},
	{"IZET", 4, 28714},
	{"EDTW", 4, 28715},
	{"INTENSITY", 9, 28716},
	{"OFSC", 4, 28717},
	{"DANISH", 6, 28718},
	{"PAL", 3, 28719},
	{"ANTF", 4, 28720},
	{"GHIT", 4, 28721},
	{"SSPR", 4, 28722},
	{"HEKN", 4, 28723},
	{"HISV", 4, 28724},
	{"FILENAME", 8, 28725},
	{"FLORENCE", 8, 28726},
	{"AYLO", 4, 28727},
	{"DEFENDANT", 9, 28728},
	{"ATTRIBUTE", 9, 28729},
	{"ANALYSES", 8, 28730},
	{"RELATED", 7, 28731},
	{"DRAWINGS", 8, 28732},
	{"LEDH", 4, 28733},
	{"HSOM", 4, 28734},
	{"OUVE", 4, 28735},
	{"FTIN", 4, 28736},
	{"MODERATE", 8, 28737},
	{"YLB", 3, 28738},
	{"GHAS", 4, 28739},
	{"BALLOT", 6, 28740},
	{"WORRIED", 7, 28741},
	{"SOCCER", 6, 28742},
	{"LOVERS", 6, 28743},
	{"ATOMIC", 6, 28744},
	{"COUCH", 5, 28745},
	{"APPROX", 6, 28746},
	{"SYMPOSIUM", 9, 28747},
	{"ARABIC", 6, 28748},
	{"LUNG", 4, 28749},
	{"OWZ", 3, 28750},
	{"GAUGE", 5, 28751},
	{"ESSENTIALS", 10, 28752},
	{"PORTRAY", 7, 28753},
	{"JUNCTION", 8, 28754},
	{"NTAB", 4, 28755},
	{"PROTECTING", 10, 28756},
	{"GHTM", 4, 28757},
	{"FACED", 5, 28758},
	{"NWOU", 4, 28759},
	{"RACHEL", 6, 28760},
	{"SHORE", 5, 28761},
	{"RERA", 4, 28762},
	{"SOLVING", 7, 28763},
	{"TRANSMITTED", 11, 28764},
	{"OFSI", 4, 28765},
	{"NGUI", 4, 28766},
	{"ALWO", 4, 28767},
	{"PHYSICS", 7, 28768},
	{"WEEKENDS", 8, 28769},
	{"SCREENSHOTS", 11, 28770},
	{"SBEG", 4, 28771},
	{"PRODUCES", 8, 28772},
	{"LKED", 4, 28773},
	{"SWEAR", 5, 28774},
	{"XCHA", 4, 28775},
	{"INTENSIVE", 9, 28776},
	{"CHAINS", 6, 28777},
	{"KINGSTON", 8, 28778},
	{"ESPL", 4, 28779},
	{"NTGE", 4, 28780},
	{"DEVIANT", 7, 28781},
	{"CEHA", 4, 28782},
	{"SWITCHING", 9, 28783},
	{"QUOTED", 6, 28784},
	{"ADAPTERS", 8, 28785},
	{"PRESCRIPTION", 12, 28786},
	{"CORRESPONDENCE", 14, 28787},
	{"NONETHELESS", 11, 28788},
	{"THFO", 4, 28789},
	{"NEXC", 4, 28790},
	{"NDEE", 4, 28791},
	{"FARMS", 5, 28792},
	{"COLLAPSE", 8, 28793},
	{"EFAR", 4, 28794},
	{"AYSW", 4, 28795},
	{"IMPORTS", 7, 28796},
	{"DFIR", 4, 28797},
	{"SUPERVISION", 11, 28798},
	{"EXPENDITURES", 12, 28799},
	{"OALI", 4, 28800},
	{"UREL", 4, 28801},
	{"PATCH", 5, 28802},
	{"SANDY", 5, 28803},
	{"LKV", 3, 28804},
	{"PAINTER", 7, 28805},
	{"ALSP", 4, 28806},
	{"DEAR", 4, 28807},
	{"LLYL", 4, 28808},
	{"BORROW", 6, 28809},
	{"UTRE", 4, 28810},
	{"HOMELESS", 8, 28811},
	{"CELEBRITIES", 11, 28812},
	{"VEPR", 4, 28813},
	{"TWOW", 4, 28814},
	{"BUTF", 4, 28815},
	{"MACRO", 5, 28816},
	{"SENDER", 6, 28817},
	{"TODR", 4, 28818},
	{"AYNO", 4, 28819},
	{"MANDATORY", 9, 28820},
	{"BOUNDARIES", 10, 28821},
	{"IRFI", 4, 28822},
	{"AWIT", 4, 28823},
	{"INQUIRY", 7, 28824},
	{"HADP", 4, 28825},
	{"VEDB", 4, 28826},
	{"SYNDICATION", 11, 28827},
	{"ROSP", 4, 28828},
	{"KDE", 3, 28829},
	{"ADJACENT", 8, 28830},
	{"NEYA", 4, 28831},
	{"QUESTIONNAIRE", 13, 28832},
	{"FILTERING", 9, 28833},
	{"ANYE", 4, 28834},
	{"AFRICAN-AMERICAN", 16, 28835},
	{"SECONDARY", 9, 28836},
	{"TUITION", 7, 28837},
	{"HIGHLIGHT", 9, 28838},
	{"SIGNUP", 6, 28839},
	{"SZC", 3, 28840},
	{"NTEG", 4, 28841},
	{"OCCUPATION", 10, 28842},
	{"ELLW", 4, 28843},
	{"AGIC", 4, 28844},
	{"VIRTUE", 6, 28845},
	{"THREATS", 7, 28846},
	{"LUXEMBOURG", 10, 28847},
	{"KILLING", 7, 28848},
	{"PUZZLES", 7, 28849},
	{"PTAI", 4, 28850},
	{"TESF", 4, 28851},
	{"SEIZE", 5, 28852},
	{"ODOF", 4, 28853},
	{"NSUC", 4, 28854},
	{"EEPT", 4, 28855},
	{"FLOUR", 5, 28856},
	{"NYWA", 4, 28857},
	{"DERL", 4, 28858},
	{"YTOD", 4, 28859},
	{"YSHA", 4, 28860},
	{"WISE", 4, 28861},
	{"IMPRESSIVE", 10, 28862},
	{"LYLO", 4, 28863},
	{"EAKS", 4, 28864},
	{"REACHING", 8, 28865},
	{"ODDS", 4, 28866},
	{"NDTW", 4, 28867},
	{"YSEL", 4, 28868},
	{"DAMAGED", 7, 28869},
	{"REXP", 4, 28870},
	{"CAMS", 4, 28871},
	{"CAPTAIN", 7, 28872},
	{"EYTH", 4, 28873},
	{"RECEPTOR", 8, 28874},
	{"THAB", 4, 28875},
	{"PISS", 4, 28876},
	{"ZUZ", 3, 28877},
	{"TIPL", 4, 28878},
	{"NWAR", 4, 28879},
	{"UREC", 4, 28880},
	{"SOFG", 4, 28881},
	{"AHOM", 4, 28882},
	{"TSDE", 4, 28883},
	{"TSAB", 4, 28884},
	{"JOEL", 4, 28885},
	{"SLAM", 4, 28886},
	{"SURGICAL", 8, 28887},
	{"CITATION", 8, 28888},
	{"YOJ", 3, 28889},
	{"RALR", 4, 28890},
	{"YBOD", 4, 28891},
	{"BRICK", 5, 28892},
	{"XIW", 3, 28893},
	{"OOFT", 4, 28894},
	{"EVERYDAY", 8, 28895},
	{"REDM", 4, 28896},
	{"AUTOS", 5, 28897},
	{"EPHE", 4, 28898},
	{"INTEGRATE", 9, 28899},
	{"UTOR", 4, 28900},
	{"REPEATEDLY", 10, 28901},
	{"NSMI", 4, 28902},
	{"EXTT", 4, 28903},
	{"EPUR", 4, 28904},
	{"CHANGING", 8, 28905},
	{"USLI", 4, 28906},
	{"NYOT", 4, 28907},
	{"CHARITY", 7, 28908},
	{"PREMISES", 8, 28909},
	{"PERRY", 5, 28910},
	{"PROVED", 6, 28911},
	{"RTOA", 4, 28912},
	{"OFAG", 4, 28913},
	{"ZSU", 3, 28914},
	{"OSUP", 4, 28915},
	{"IMPERIAL", 8, 28916},
	{"EWOM", 4, 28917},
	{"RTOP", 4, 28918},
	{"BENJAMIN", 8, 28919},
	{"DEPLOYMENT", 10, 28920},
	{"ESBA", 4, 28921},
	{"PHYSICALLY", 10, 28922},
	{"TEETH", 5, 28923},
	{"KHY", 3, 28924},
	{"OROT", 4, 28925},
	{"ALHO", 4, 28926},
	{"DARE", 4, 28927},
	{"RRIT", 4, 28928},
	{"STUDYING", 8, 28929},
	{"COLLEAGUES", 10, 28930},
	{"STAMP", 5, 28931},
	{"RECRUIT", 7, 28932},
	{"LOTUS", 5, 28933},
	{"TUNNEL", 6, 28934},
	{"OLYMPUS", 7, 28935},
	{"SEPARATED", 9, 28936},
	{"OFVI", 4, 28937},
	{"EJOB", 4, 28938},
	{"LAUGHTER", 8, 28939},
	{"EXPERIMENTAL", 12, 28940},
	{"LBEC", 4, 28941},
	{"SACRED", 6, 28942},
	{"ETHICAL", 7, 28943},
	{"PROC", 4, 28944},
	{"GROCERY", 7, 28945},
	{"ELYO", 4, 28946},
	{"AYAR", 4, 28947},
	{"ADMIRE", 6, 28948},
	{"ZETH", 4, 28949},
	{"DIRECTIVE", 9, 28950},
	{"ISVE", 4, 28951},
	{"EYMA", 4, 28952},
	{"EXPORT", 6, 28953},
	{"EOWN", 4, 28954},
	{"RHYTHM", 6, 28955},
	{"NEYT", 4, 28956},
	{"YSEE", 4, 28957},
	{"TOAM", 4, 28958},
	{"SALEM", 5, 28959},
	{"FRUSTRATION", 11, 28960},
	{"YTOO", 4, 28961},
	{"UPGRADES", 8, 28962},
	{"PERSUADE", 8, 28963},
	{"LIKES", 5, 28964},
	{"INEP", 4, 28965},
	{"MODIFY", 6, 28966},
	{"CONTINUOUS", 10, 28967},
	{"TDES", 4, 28968},
	{"MARGIN", 6, 28969},
	{"LUGGAGE", 7, 28970},
	{"ORFI", 4, 28971},
	{"TACTIC", 6, 28972},
	{"MEDAL", 5, 28973},
	{"TAPES", 5, 28974},
	{"MFRO", 4, 28975},
	{"ZONES", 5, 28976},
	{"ROSE", 4, 28977},
	{"ZLY", 3, 28978},
	{"AXG", 3, 28979},
	{"EENL", 4, 28980},
	{"REEI", 4, 28981},
	{"ISLE", 4, 28982},
	{"SHINE", 5, 28983},
	{"YSOM", 4, 28984},
	{"MIRACLE", 7, 28985},
	{"TALT", 4, 28986},
	{"CHASE", 5, 28987},
	{"STYLISH", 7, 28988},
	{"SLIM", 4, 28989},
	{"MAPLE", 5, 28990},
	{"LUKE", 4, 28991},
	{"ARCHITECT", 9, 28992},
	{"GWHI", 4, 28993},
	{"LTOT", 4, 28994},
	{"SQB", 3, 28995},
	{"PIANO", 5, 28996},
	{"RSUP", 4, 28997},
	{"ULDD", 4, 28998},
	{"FORMULA", 7, 28999},
	{"GALLERY", 7, 29000},
	{"STEM", 4, 29001},
	{"OFFSHORE", 8, 29002},
	{"GOVERNING", 9, 29003},
	{"CEIT", 4, 29004},
	{"RETAILERS", 9, 29005},
	{"DEPOT", 5, 29006},
	{"ROML", 4, 29007},
	{"DEDS", 4, 29008},
	{"OOLO", 4, 29009},
	{"ODAT", 4, 29010},
	{"KENNETH", 7, 29011},
	{"CONTAINER", 9, 29012},
	{"YLP", 3, 29013},
	{"COMP", 4, 29014},
	{"HARRISON", 8, 29015},
	{"SAKE", 4, 29016},
	{"EDWO", 4, 29017},
	{"BEUS", 4, 29018},
	{"EYIN", 4, 29019},
	{"JULIE", 5, 29020},
	{"TSEV", 4, 29021},
	{"ALLIANCE", 8, 29022},
	{"CBS", 3, 29023},
	{"DINW", 4, 29024},
	{"ATTENDING", 9, 29025},
	{"FACILITATE", 10, 29026},
	{"PETE", 4, 29027},
	{"PREGNANCY", 9, 29028},
	{"SPEC", 4, 29029},
	{"BARE", 4, 29030},
	{"FINEST", 6, 29031},
	{"XUB", 3, 29032},
	{"REALTY", 6, 29033},
	{"PROSECUTION", 11, 29034},
	{"JANET", 5, 29035},
	{"IMEF", 4, 29036},
	{"YCOL", 4, 29037},
	{"ROMN", 4, 29038},
	{"YREL", 4, 29039},
	{"IBLY", 4, 29040},
	{"NMAK", 4, 29041},
	{"PENN", 4, 29042},
	{"RECRUITING", 10, 29043},
	{"LLAP", 4, 29044},
	{"RSDE", 4, 29045},
	{"RFAM", 4, 29046},
	{"FFAI", 4, 29047},
	{"LCAN", 4, 29048},
	{"ROFP", 4, 29049},
	{"NGEV", 4, 29050},
	{"COAL", 4, 29051},
	{"ODIF", 4, 29052},
	{"PHPBB", 5, 29053},
	{"AUTUMN", 6, 29054},
	{"LDTO", 4, 29055},
	{"SCRIPT", 6, 29056},
	{"ELTO", 4, 29057},
	{"TRAVELING", 9, 29058},
	{"FKY", 3, 29059},
	{"ZCL", 3, 29060},
	{"PROBE", 5, 29061},
	{"MIDI", 4, 29062},
	{"OCOU", 4, 29063},
	{"MAKEUP", 6, 29064},
	{"ONDR", 4, 29065},
	{"EANW", 4, 29066},
	{"PTOT", 4, 29067},
	{"PERMISSIONS", 11, 29068},
	{"UTWA", 4, 29069},
	{"OODE", 4, 29070},
	{"BIOTECHNOLOGY", 13, 29071},
	{"BYMA", 4, 29072},
	{"DSAY", 4, 29073},
	{"NDJU", 4, 29074},
	{"EDTR", 4, 29075},
	{"OCAN", 4, 29076},
	{"ERYI", 4, 29077},
	{"RANKED", 6, 29078},
	{"JACKETS", 7, 29079},
	{"ADMINISTRATIVE", 14, 29080},
	{"ROUTES", 6, 29081},
	{"LIGHTLY", 7, 29082},
	{"PACKED", 6, 29083},
	{"EFFECTIVENESS", 13, 29084},
	{"SELY", 4, 29085},
	{"SMAT", 4, 29086},
	{"TOIM", 4, 29087},
	{"LBET", 4, 29088},
	{"NKOF", 4, 29089},
	{"YGY", 3, 29090},
	{"RGUE", 4, 29091},
	{"RITUAL", 6, 29092},
	{"RECEIVER", 8, 29093},
	{"GNIN", 4, 29094},
	{"OUTREACH", 8, 29095},
	{"GHWA", 4, 29096},
	{"HELEN", 5, 29097},
	{"MOUNTING", 8, 29098},
	{"HORROR", 6, 29099},
	{"TIED", 4, 29100},
	{"LOPEZ", 5, 29101},
	{"NPEO", 4, 29102},
	{"PRESCRIBED", 10, 29103},
	{"CONCRETE", 8, 29104},
	{"ACCEPTANCE", 10, 29105},
	{"CATHERINE", 9, 29106},
	{"FYL", 3, 29107},
	{"GRAVE", 5, 29108},
	{"RESIGN", 6, 29109},
	{"RECORDING", 9, 29110},
	{"COMPOSE", 7, 29111},
	{"OMHE", 4, 29112},
	{"TIMELY", 6, 29113},
	{"LDLI", 4, 29114},
	{"TALKED", 6, 29115},
	{"DEBUG", 5, 29116},
	{"DELAYED", 7, 29117},
	{"SALMON", 6, 29118},
	{"GTOM", 4, 29119},
	{"RSSA", 4, 29120},
	{"NHEL", 4, 29121},
	{"AMTO", 4, 29122},
	{"REOR", 4, 29123},
	{"CHUCK", 5, 29124},
	{"ZEJ", 3, 29125},
	{"REGULATE", 8, 29126},
	{"CEAG", 4, 29127},
	{"YOFM", 4, 29128},
	{"OLEI", 4, 29129},
	{"REPRODUCED", 10, 29130},
	{"TOBO", 4, 29131},
	{"JEANS", 5, 29132},
	{"DALE", 4, 29133},
	{"LSHE", 4, 29134},
	{"OWSH", 4, 29135},
	{"ULTT", 4, 29136},
	{"BYCO", 4, 29137},
	{"OPHO", 4, 29138},
	{"INTEGRATION", 11, 29139},
	{"LWHI", 4, 29140},
	{"VILLAS", 6, 29141},
	{"CORRIDOR", 8, 29142},
	{"EBOOK", 5, 29143},
	{"CONSOLIDATED", 12, 29144},
	{"BOOB", 4, 29145},
	{"PEEING", 6, 29146},
	{"OFBU", 4, 29147},
	{"PITCHER", 7, 29148},
	{"OCCASIONS", 9, 29149},
	{"BROOKS", 6, 29150},
	{"ISBU", 4, 29151},
	{"EQUATIONS", 9, 29152},
	{"RAIL", 4, 29153},
	{"NEWTON", 6, 29154},
	{"OILS", 4, 29155},
	{"SEPT", 4, 29156},
	{"EXCEPTIONAL", 11, 29157},
	{"BINGO", 5, 29158},
	{"WHILST", 6, 29159},
	{"SPATIAL", 7, 29160},
	{"ORAF", 4, 29161},
	{"SELI", 4, 29162},
	{"ACKF", 4, 29163},
	{"RESPONDENTS", 11, 29164},
	{"UNTO", 4, 29165},
	{"NITW", 4, 29166},
	{"CERAMIC", 7, 29167},
	{"OURR", 4, 29168},
	{"FLASH", 5, 29169},
	{"MINDS", 5, 29170},
	{"INSECT", 6, 29171},
	{"PRESIDENCY", 10, 29172},
	{"INIM", 4, 29173},
	{"HUNT", 4, 29174},
	{"RECESSION", 9, 29175},
	{"CONSIDERATIONS", 14, 29176},
	{"LPER", 4, 29177},
	{"YITS", 4, 29178},
	{"SREV", 4, 29179},
	{"SCANNERS", 8, 29180},
	{"SEPR", 4, 29181},
	{"RESW", 4, 29182},
	{"PLAYOFF", 7, 29183},
	{"HASF", 4, 29184},
	{"LTOF", 4, 29185},
	{"NDNA", 4, 29186},
	{"INMY", 4, 29187},
	{"XANAX", 5, 29188},
	{"EAMW", 4, 29189},
	{"PAYS", 4, 29190},
	{"COX", 3, 29191},
	{"ABROAD", 6, 29192},
	{"IABL", 4, 29193},
	{"ALLD", 4, 29194},
	{"TRADING", 7, 29195},
	{"FINGERS", 7, 29196},
	{"ONAD", 4, 29197},
	{"INDIGENOUS", 10, 29198},
	{"ONUN", 4, 29199},
	{"EBOOKS", 6, 29200},
	{"DELIVERS", 8, 29201},
	{"SRUN", 4, 29202},
	{"QUEENSLAND", 10, 29203},
	{"NECKLACE", 8, 29204},
	{"EXCLUDE", 7, 29205},
	{"MUSICIANS", 9, 29206},
	{"NGOT", 4, 29207},
	{"LEEDS", 5, 29208},
	{"OEVE", 4, 29209},
	{"LDAL", 4, 29210},
	{"COMPOSITE", 9, 29211},
	{"WNFO", 4, 29212},
	{"AGEB", 4, 29213},
	{"NGCL", 4, 29214},
	{"UNAVAILABLE", 11, 29215},
	{"CEDAR", 5, 29216},
	{"ARRANGED", 8, 29217},
	{"LANG", 4, 29218},
	{"BUTL", 4, 29219},
	{"NGGR", 4, 29220},
	{"THEATERS", 8, 29221},
	{"EOFG", 4, 29222},
	{"ONGL", 4, 29223},
	{"ADVOCACY", 8, 29224},
	{"STFR", 4, 29225},
	{"RALEIGH", 7, 29226},
	{"STUD", 4, 29227},
	{"GENTLE", 6, 29228},
	{"IDSH", 4, 29229},
	{"IDOF", 4, 29230},
	{"IXK", 3, 29231},
	{"DESIGNING", 9, 29232},
	{"THREADED", 8, 29233},
	{"YNEE", 4, 29234},
	{"USON", 4, 29235},
	{"ETYP", 4, 29236},
	{"AIND", 4, 29237},
	{"YFOU", 4, 29238},
	{"INTERRUPT", 9, 29239},
	{"BOYFRIEND", 9, 29240},
	{"ISLAM", 5, 29241},
	{"LPRE", 4, 29242},
	{"UEEN", 4, 29243},
	{"RNST", 4, 29244},
	{"BLAIR", 5, 29245},
	{"EVIDENT", 7, 29246},
	{"HOPES", 5, 29247},
	{"ASSESSMENTS", 11, 29248},
	{"CMS", 3, 29249},
	{"MASON", 5, 29250},
	{"YDIF", 4, 29251},
	{"CONFUSION", 9, 29252},
	{"DIAGRAM", 7, 29253},
	{"BURNS", 5, 29254},
	{"TTOL", 4, 29255},
	{"PUMPS", 5, 29256},
	{"YEDI", 4, 29257},
	{"RRAT", 4, 29258},
	{"MESS", 4, 29259},
	{"FOOTWEAR", 8, 29260},
	{"STLO", 4, 29261},
	{"VIC", 3, 29262},
	{"MPUS", 4, 29263},
	{"BEIJING", 7, 29264},
	{"OFSH", 4, 29265},
	{"PEOPLES", 7, 29266},
	{"VICTOR", 6, 29267},
	{"OFWI", 4, 29268},
	{"TALW", 4, 29269},
	{"MARIO", 5, 29270},
	{"IZR", 3, 29271},
	{"LWHE", 4, 29272},
	{"CCUP", 4, 29273},
	{"LICENSES", 8, 29274},
	{"CLUE", 4, 29275},
	{"UTILS", 5, 29276},
	{"REMOVING", 8, 29277},
	{"ADVISED", 7, 29278},
	{"BRUNSWICK", 9, 29279},
	{"SPIDER", 6, 29280},
	{"UESA", 4, 29281},
	{"PHYS", 4, 29282},
	{"RANGES", 6, 29283},
	{"PAIRS", 5, 29284},
	{"ACCEPTABLE", 10, 29285},
	{"HURRY", 5, 29286},
	{"EXCUSE", 6, 29287},
	{"TRAILS", 6, 29288},
	{"PRESERVATION", 12, 29289},
	{"COURAGE", 7, 29290},
	{"HUDSON", 6, 29291},
	{"NTEM", 4, 29292},
	{"HALLWAY", 7, 29293},
	{"INDICATION", 10, 29294},
	{"DRAMATICALLY", 12, 29295},
	{"CALGARY", 7, 29296},
	{"TSUC", 4, 29297},
	{"INTERIM", 7, 29298},
	{"ASSISTED", 8, 29299},
	{"STREAMING", 9, 29300},
	{"IPME", 4, 29301},
	{"SURPRISINGLY", 12, 29302},
	{"EDBO", 4, 29303},
	{"CHOSE", 5, 29304},
	{"SYNDICATE", 9, 29305},
	{"ERYP", 4, 29306},
	{"EARH", 4, 29307},
	{"EINB", 4, 29308},
	{"DIALOG", 6, 29309},
	{"HADM", 4, 29310},
	{"UESS", 4, 29311},
	{"HISPANIC", 8, 29312},
	{"WERI", 4, 29313},
	{"NTGO", 4, 29314},
	{"OXIM", 4, 29315},
	{"OFDO", 4, 29316},
	{"VENUES", 6, 29317},
	{"UTYO", 4, 29318},
	{"NGGO", 4, 29319},
	{"IEDB", 4, 29320},
	{"RYHA", 4, 29321},
	{"EGOA", 4, 29322},
	{"ZKE", 3, 29323},
	{"WELLNESS", 8, 29324},
	{"CALCIUM", 7, 29325},
	{"NFEB", 4, 29326},
	{"ELDT", 4, 29327},
	{"NEWPORT", 7, 29328},
	{"VENB", 4, 29329},
	{"ANTIVIRUS", 9, 29330},
	{"ANNIVERSARY", 11, 29331},
	{"GTHO", 4, 29332},
	{"COMBAT", 6, 29333},
	{"ALLEGATION", 10, 29334},
	{"ADDRESSING", 10, 29335},
	{"DISCOUNTED", 10, 29336},
	{"RNTH", 4, 29337},
	{"INDIANS", 7, 29338},
	{"SHIELD", 6, 29339},
	{"RVIS", 4, 29340},
	{"DEVELOPER", 9, 29341},
	{"ALHE", 4, 29342},
	{"ODOW", 4, 29343},
	{"HENM", 4, 29344},
	{"MEMBRANE", 8, 29345},
	{"PRAGUE", 6, 29346},
	{"PREVIEWS", 8, 29347},
	{"BANGLADESH", 10, 29348},
	{"REWARD", 6, 29349},
	{"NOTL", 4, 29350},
	{"LEGEND", 6, 29351},
	{"RSWO", 4, 29352},
	{"SCULPTURE", 9, 29353},
	{"INIC", 4, 29354},
	{"RSPR", 4, 29355},
	{"ISTW", 4, 29356},
	{"LOCALLY", 7, 29357},
	{"CONCLUDED", 9, 29358},
	{"INSPECTOR", 9, 29359},
	{"AYHE", 4, 29360},
	{"REAF", 4, 29361},
	{"NORTHWEST", 9, 29362},
	{"ATPO", 4, 29363},
	{"INWE", 4, 29364},
	{"MOTHERS", 7, 29365},
	{"NASCAR", 6, 29366},
	{"GREATLY", 7, 29367},
	{"ICELAND", 7, 29368},
	{"LOGIC", 5, 29369},
	{"GOVERNMENTAL", 12, 29370},
	{"MANUFACTURED", 12, 29371},
	{"CANDLES", 7, 29372},
	{"ESMI", 4, 29373},
	{"MEGA", 4, 29374},
	{"RBEI", 4, 29375},
	{"EXACT", 5, 29376},
	{"DOMAIN", 6, 29377},
	{"SAILING", 7, 29378},
	{"DGRE", 4, 29379},
	{"BISHOP", 6, 29380},
	{"EJD", 3, 29381},
	{"LSHO", 4, 29382},
	{"TYZ", 3, 29383},
	{"TORW", 4, 29384},
	{"VARIATIONS", 10, 29385},
	{"CANDY", 5, 29386},
	{"AUNI", 4, 29387},
	{"MOMS", 4, 29388},
	{"SUPERIOR", 8, 29389},
	{"OLDH", 4, 29390},
	{"ADDICTION", 9, 29391},
	{"MOROCCO", 7, 29392},
	{"FOLD", 4, 29393},
	{"INITIATE", 8, 29394},
	{"HWAY", 4, 29395},
	{"CHROME", 6, 29396},
	{"TGOI", 4, 29397},
	{"OODW", 4, 29398},
	{"TOMMY", 5, 29399},
	{"MMAT", 4, 29400},
	{"EASW", 4, 29401},
	{"YIND", 4, 29402},
	{"SPRINGFIELD", 11, 29403},
	{"REFUSED", 7, 29404},
	{"LLAC", 4, 29405},
	{"TEDU", 4, 29406},
	{"RHOO", 4, 29407},
	{"EXTERIOR", 8, 29408},
	{"FRANKLY", 7, 29409},
	{"ACEB", 4, 29410},
	{"GREETING", 8, 29411},
	{"ACEM", 4, 29412},
	{"NBRI", 4, 29413},
	{"ASOL", 4, 29414},
	{"AYWH", 4, 29415},
	{"PUMP", 4, 29416},
	{"ECOLOGY", 7, 29417},
	{"ENIF", 4, 29418},
	{"TESP", 4, 29419},
	{"OLIVER", 6, 29420},
	{"EBUR", 4, 29421},
	{"LEDU", 4, 29422},
	{"LLOR", 4, 29423},
	{"CONGO", 5, 29424},
	{"GLEN", 4, 29425},
	{"OPUT", 4, 29426},
	{"BOTSWANA", 8, 29427},
	{"YEDT", 4, 29428},
	{"LOG", 3, 29429},
	{"HOSTAGE", 7, 29430},
	{"DELAYS", 6, 29431},
	{"SYNTHESIS", 9, 29432},
	{"NDTI", 4, 29433},
	{"OLIVE", 5, 29434},
	{"DITH", 4, 29435},
	{"RETAIL", 6, 29436},
	{"YCHO", 4, 29437},
	{"RICU", 4, 29438},
	{"NDMU", 4, 29439},
	{"UNDEFINED", 9, 29440},
	{"CLOSET", 6, 29441},
	{"ORGAN", 5, 29442},
	{"HASW", 4, 29443},
	{"EYDI", 4, 29444},
	{"HIPA", 4, 29445},
	{"CYBER", 5, 29446},
	{"NOFM", 4, 29447},
	{"VERIZON", 7, 29448},
	{"RTOB", 4, 29449},
	{"EAMM", 4, 29450},
	{"USTL", 4, 29451},
	{"SCORED", 6, 29452},
	{"ENHANCEMENT", 11, 29453},
	{"GNIZ", 4, 29454},
	{"EARF", 4, 29455},
	{"NEWCASTLE", 9, 29456},
	{"CLONE", 5, 29457},
	{"DWAY", 4, 29458},
	{"DDEC", 4, 29459},
	{"DICKS", 5, 29460},
	{"VELOCITY", 8, 29461},
	{"LAMBDA", 6, 29462},
	{"SWALLOW", 7, 29463},
	{"NHIG", 4, 29464},
	{"RELAY", 5, 29465},
	{"COMPOSED", 8, 29466},
	{"TEARS", 5, 29467},
	{"PLEH", 4, 29468},
	{"NVIT", 4, 29469},
	{"PERFORMANCES", 12, 29470},
	{"EPIT", 4, 29471},
	{"OASIS", 5, 29472},
	{"BASELINE", 8, 29473},
	{"IGHW", 4, 29474},
	{"COMPOUND", 8, 29475},
	{"SLOPE", 5, 29476},
	{"UPSET", 5, 29477},
	{"LLCA", 4, 29478},
	{"ENFR", 4, 29479},
	{"SOCIETIES", 9, 29480},
	{"SILICON", 7, 29481},
	{"ICTH", 4, 29482},
	{"BRAZILIAN", 9, 29483},
	{"LERO", 4, 29484},
	{"NOFP", 4, 29485},
	{"OMOV", 4, 29486},
	{"GNOR", 4, 29487},
	{"SWON", 4, 29488},
	{"PETROLEUM", 9, 29489},
	{"ZJO", 3, 29490},
	{"TYWI", 4, 29491},
	{"NORWEGIAN", 9, 29492},
	{"BEG", 3, 29493},
	{"SPONSOR", 7, 29494},
	{"HONOLULU", 8, 29495},
	{"YCAL", 4, 29496},
	{"BEATLES", 7, 29497},
	{"ODTH", 4, 29498},
	{"ONSL", 4, 29499},
	{"ICOU", 4, 29500},
	{"PILL", 4, 29501},
	{"ELBOW", 5, 29502},
	{"LIPS", 4, 29503},
	{"YDJ", 3, 29504},
	{"ALEL", 4, 29505},
	{"ESCORT", 6, 29506},
	{"RETENTION", 9, 29507},
	{"MELT", 4, 29508},
	{"YHER", 4, 29509},
	{"EXCHANGES", 9, 29510},
	{"OODO", 4, 29511},
	{"ROLLS", 5, 29512},
	{"THOMSON", 7, 29513},
	{"ADIU", 4, 29514},
	{"BARNES", 6, 29515},
	{"LYTR", 4, 29516},
	{"SOUNDTRACK", 10, 29517},
	{"WONDERING", 9, 29518},
	{"SNAKE", 5, 29519},
	{"TICC", 4, 29520},
	{"MALTA", 5, 29521},
	{"DADDY", 5, 29522},
	{"SFOL", 4, 29523},
	{"SURGEON", 7, 29524},
	{"ROPH", 4, 29525},
	{"LPIN", 4, 29526},
	{"FERRY", 5, 29527},
	{"SEATING", 7, 29528},
	{"ADEO", 4, 29529},
	{"UEAN", 4, 29530},
	{"IGIT", 4, 29531},
	{"MANR", 4, 29532},
	{"SEPARATELY", 10, 29533},
	{"NGDA", 4, 29534},
	{"PHYSIOLOGY", 10, 29535},
	{"LIL", 3, 29536},
	{"COLLECTING", 10, 29537},
	{"MAGIC", 5, 29538},
	{"EXPORTS", 7, 29539},
	{"OMAHA", 5, 29540},
	{"PLEASED", 7, 29541},
	{"SCHOLARSHIPS", 12, 29542},
	{"RYBO", 4, 29543},
	{"RDSI", 4, 29544},
	{"RECREATIONAL", 12, 29545},
	{"RHAV", 4, 29546},
	{"DOMINICAN", 9, 29547},
	{"EFAN", 4, 29548},
	{"EXCITED", 7, 29549},
	{"ANEV", 4, 29550},
	{"RSPO", 4, 29551},
	{"CHAD", 4, 29552},
	{"ASOU", 4, 29553},
	{"ELECTRON", 8, 29554},
	{"LOADS", 5, 29555},
	{"IDEOLOGY", 8, 29556},
	{"ONRO", 4, 29557},
	{"HEATHER", 7, 29558},
	{"PASSPORT", 8, 29559},
	{"MOTEL", 5, 29560},
	{"AND/OR", 6, 29561},
	{"NGEI", 4, 29562},
	{"UNIONS", 6, 29563},
	{"TREASURY", 8, 29564},
	{"WARRANT", 7, 29565},
	{"SOLARIS", 7, 29566},
	{"OCCUPIED", 8, 29567},
	{"ECHO", 4, 29568},
	{"JOSH", 4, 29569},
	{"ROYALTY", 7, 29570},
	{"CLASSICAL", 9, 29571},
	{"ERCR", 4, 29572},
	{"SCALES", 6, 29573},
	{"UNEMPLOYMENT", 12, 29574},
	{"HENCE", 5, 29575},
	{"LVY", 3, 29576},
	{"STSW", 4, 29577},
	{"SUNSHINE", 8, 29578},
	{"DTEA", 4, 29579},
	{"OYME", 4, 29580},
	{"ESTIMATED", 9, 29581},
	{"URTO", 4, 29582},
	{"VENW", 4, 29583},
	{"INTEGRITY", 9, 29584},
	{"SUBURBAN", 8, 29585},
	{"ONPE", 4, 29586},
	{"ARRESTED", 8, 29587},
	{"EXPANDING", 9, 29588},
	{"INVENT", 6, 29589},
	{"EFLA", 4, 29590},
	{"PROVINCIAL", 10, 29591},
	{"RDWA", 4, 29592},
	{"YMAK", 4, 29593},
	{"INVESTIGATIONS", 14, 29594},
	{"DIAGNOSIS", 9, 29595},
	{"ATEU", 4, 29596},
	{"REMARK", 6, 29597},
	{"ICQ", 3, 29598},
	{"NFLA", 4, 29599},
	{"TTOF", 4, 29600},
	{"RIPE", 4, 29601},
	{"UCHM", 4, 29602},
	{"ARCHITECTURE", 12, 29603},
	{"YAMAHA", 6, 29604},
	{"HYTH", 4, 29605},
	{"TBYT", 4, 29606},
	{"CIVILIZATION", 12, 29607},
	{"SYCH", 4, 29608},
	{"RENT", 4, 29609},
	{"DRINKING", 8, 29610},
	{"RINF", 4, 29611},
	{"INPL", 4, 29612},
	{"MEDICATIONS", 11, 29613},
	{"SUBTLE", 6, 29614},
	{"HEBREW", 6, 29615},
	{"KOREAN", 6, 29616},
	{"MIDNIGHT", 8, 29617},
	{"GAINED", 6, 29618},
	{"ROCHESTER", 9, 29619},
	{"LONGTIME", 8, 29620},
	{"STUCK", 5, 29621},
	{"ELPI", 4, 29622},
	{"TLYB", 4, 29623},
	{"SOLOMON", 7, 29624},
	{"PLACING", 7, 29625},
	{"STOPS", 5, 29626},
	{"SORD", 4, 29627},
	{"ASSESSED", 8, 29628},
	{"ROMF", 4, 29629},
	{"YWEL", 4, 29630},
	{"ADVERTISER", 10, 29631},
	{"THRI", 4, 29632},
	{"LYCH", 4, 29633},
	{"TSGO", 4, 29634},
	{"ENABLING", 8, 29635},
	{"ACUL", 4, 29636},
	{"ENCRYPTION", 10, 29637},
	{"BRAI", 4, 29638},
	{"ERNC", 4, 29639},
	{"FILLING", 7, 29640},
	{"ORMU", 4, 29641},
	{"DOWNLOADABLE", 12, 29642},
	{"EAPR", 4, 29643},
	{"BERW", 4, 29644},
	{"BEEF", 4, 29645},
	{"IMPOSED", 7, 29646},
	{"NGRI", 4, 29647},
	{"SCSI", 4, 29648},
	{"FOCUSES", 7, 29649},
	{"ULLS", 4, 29650},
	{"TOOF", 4, 29651},
	{"NQUE", 4, 29652},
	{"ARYW", 4, 29653},
	{"MZO", 3, 29654},
	{"HASG", 4, 29655},
	{"LABORATORIES", 12, 29656},
	{"OFON", 4, 29657},
	{"NDIE", 4, 29658},
	{"KNY", 3, 29659},
	{"YTOG", 4, 29660},
	{"TRUNK", 5, 29661},
	{"MEMI", 4, 29662},
	{"CURVE", 5, 29663},
	{"STRONGER", 8, 29664},
	{"VOLUMES", 7, 29665},
	{"RFOU", 4, 29666},
	{"NALW", 4, 29667},
	{"BURST", 5, 29668},
	{"UTLE", 4, 29669},
	{"RPEO", 4, 29670},
	{"EVIL", 4, 29671},
	{"RTHS", 4, 29672},
	{"YDES", 4, 29673},
	{"ESSENCE", 7, 29674},
	{"ADVANCES", 8, 29675},
	{"VEGETABLES", 10, 29676},
	{"T-SHIRT", 7, 29677},
	{"LEGISLATIVE", 11, 29678},
	{"THUMBNAILS", 10, 29679},
	{"TWEL", 4, 29680},
	{"ENTITLE", 7, 29681},
	{"PTY", 3, 29682},
	{"YSOF", 4, 29683},
	{"GCHA", 4, 29684},
	{"LEAP", 4, 29685},
	{"DBYP", 4, 29686},
	{"DEDH", 4, 29687},
	{"ODET", 4, 29688},
	{"NUTS", 4, 29689},
	{"OSOF", 4, 29690},
	{"LELI", 4, 29691},
	{"BIZRATE", 7, 29692},
	{"ERSN", 4, 29693},
	{"VIENNA", 6, 29694},
	{"PPON", 4, 29695},
	{"IMPLIED", 7, 29696},
	{"WRITTEN", 7, 29697},
	{"EKIL", 4, 29698},
	{"INTERIOR", 8, 29699},
	{"ESQU", 4, 29700},
	{"YNAM", 4, 29701},
	{"ICKA", 4, 29702},
	{"SPAN", 4, 29703},
	{"RCLA", 4, 29704},
	{"ELYB", 4, 29705},
	{"STANFORD", 8, 29706},
	{"GREET", 5, 29707},
	{"ENDR", 4, 29708},
	{"STOCKINGS", 9, 29709},
	{"ANMI", 4, 29710},
	{"ERCU", 4, 29711},
	{"PACKING", 7, 29712},
	{"EISR", 4, 29713},
	{"LSWI", 4, 29714},
	{"REJECTED", 8, 29715},
	{"DAYM", 4, 29716},
	{"AVEG", 4, 29717},
	{"BITTER", 6, 29718},
	{"OFMY", 4, 29719},
	{"OWNL", 4, 29720},
	{"DESTROYED", 9, 29721},
	{"KESO", 4, 29722},
	{"DRET", 4, 29723},
	{"HEYP", 4, 29724},
	{"CHAPEL", 6, 29725},
	{"TISL", 4, 29726},
	{"CTWI", 4, 29727},
	{"GAMESPOT", 8, 29728},
	{"UTSH", 4, 29729},
	{"MANUFACTURE", 11, 29730},
	{"CKZ", 3, 29731},
	{"TLEF", 4, 29732},
	{"LAYERS", 6, 29733},
	{"WORDPRESS", 9, 29734},
	{"RESTRICT", 8, 29735},
	{"GUIDED", 6, 29736},
	{"TINV", 4, 29737},
	{"VULNERABILITY", 13, 29738},
	{"RTAB", 4, 29739},
	{"EYST", 4, 29740},
	{"MONTHLY", 7, 29741},
	{"DUCK", 4, 29742},
	{"AUJ", 3, 29743},
	{"NLYB", 4, 29744},
	{"LAUG", 4, 29745},
	{"ACCREDITED", 10, 29746},
	{"YTOR", 4, 29747},
	{"APPLIANCE", 9, 29748},
	{"COMPRESSED", 10, 29749},
	{"TTAL", 4, 29750},
	{"BAHAMAS", 7, 29751},
	{"TCHO", 4, 29752},
	{"POWELL", 6, 29753},
	{"ATDI", 4, 29754},
	{"MOTIVATE", 8, 29755},
	{"REFA", 4, 29756},
	{"EDRU", 4, 29757},
	{"RLIA", 4, 29758},
	{"CESF", 4, 29759},
	{"BEHAVIORAL", 10, 29760},
	{"THEORETICAL", 11, 29761},
	{"EEOF", 4, 29762},
	{"OWIL", 4, 29763},
	{"UNIV", 4, 29764},
	{"TUB", 3, 29765},
	{"NTAK", 4, 29766},
	{"LEBU", 4, 29767},
	{"LENS", 4, 29768},
	{"EENV", 4, 29769},
	{"SCHEDULING", 10, 29770},
	{"LSFO", 4, 29771},
	{"DRIFT", 5, 29772},
	{"RADIUS", 6, 29773},
	{"PERSPECTIVES", 12, 29774},
	{"NDFU", 4, 29775},
	{"HANM", 4, 29776},
	{"ELYR", 4, 29777},
	{"PIG", 3, 29778},
	{"NOTD", 4, 29779},
	{"LOGGING", 7, 29780},
	{"RELIABLE", 8, 29781},
	{"HAMPTON", 7, 29782},
	{"CHRISTIANS", 10, 29783},
	{"BORDERS", 7, 29784},
	{"ROMAN", 5, 29785},
	{"SANDWICH", 8, 29786},
	{"PADS", 4, 29787},
	{"VEMO", 4, 29788},
	{"ASPU", 4, 29789},
	{"BUTTS", 5, 29790},
	{"EGK", 3, 29791},
	{"OWON", 4, 29792},
	{"BOBBY", 5, 29793},
	{"DOSE", 4, 29794},
	{"CKAG", 4, 29795},
	{"RENDER", 6, 29796},
	{"ACCORDINGLY", 11, 29797},
	{"CLOTH", 5, 29798},
	{"IMEH", 4, 29799},
	{"BUTB", 4, 29800},
	{"OOMA", 4, 29801},
	{"XIR", 3, 29802},
	{"FWHA", 4, 29803},
	{"ELYC", 4, 29804},
	{"LZB", 3, 29805},
	{"HERB", 4, 29806},
	{"THPO", 4, 29807},
	{"DINV", 4, 29808},
	{"RERS", 4, 29809},
	{"ALMI", 4, 29810},
	{"LECTURE", 7, 29811},
	{"ANYF", 4, 29812},
	{"OTOG", 4, 29813},
	{"NJUS", 4, 29814},
	{"LECTURES", 8, 29815},
	{"WEAKNESS", 8, 29816},
	{"ANTB", 4, 29817},
	{"DCOA", 4, 29818},
	{"CHALLENGING", 11, 29819},
	{"AWEE", 4, 29820},
	{"ETAX", 4, 29821},
	{"WINES", 5, 29822},
	{"NURSERY", 7, 29823},
	{"HARDER", 6, 29824},
	{"MARCH", 5, 29825},
	{"CUPS", 4, 29826},
	{"MICROWAVE", 9, 29827},
	{"CHEAPEST", 8, 29828},
	{"ICEB", 4, 29829},
	{"TOAB", 4, 29830},
	{"TYWA", 4, 29831},
	{"NHAR", 4, 29832},
	{"CAVE", 4, 29833},
	{"TOOD", 4, 29834},
	{"ACCIDENTS", 9, 29835},
	{"RYWI", 4, 29836},
	{"TRAVESTI", 8, 29837},
	{"RELOCATION", 10, 29838},
	{"ALUA", 4, 29839},
	{"HUMANITY", 8, 29840},
	{"STUART", 6, 29841},
	{"HIMO", 4, 29842},
	{"GTOW", 4, 29843},
	{"EEKA", 4, 29844},
	{"ODEC", 4, 29845},
	{"XOV", 3, 29846},
	{"BACTERIA", 8, 29847},
	{"CONTRIBUTORS", 12, 29848},
	{"NAIL", 4, 29849},
	{"SALVADOR", 8, 29850},
	{"AIRPLANE", 8, 29851},
	{"MONROE", 6, 29852},
	{"NTBA", 4, 29853},
	{"TSOW", 4, 29854},
	{"RTAL", 4, 29855},
	{"ONRA", 4, 29856},
	{"WRIST", 5, 29857},
	{"VIOLATIONS", 10, 29858},
	{"SUBURB", 6, 29859},
	{"CONTEND", 7, 29860},
	{"SPUB", 4, 29861},
	{"FOAM", 4, 29862},
	{"OODP", 4, 29863},
	{"VITAMIN", 7, 29864},
	{"TEMPERATURES", 12, 29865},
	{"PASTE", 5, 29866},
	{"CLOUDS", 6, 29867},
	{"KEDB", 4, 29868},
	{"COMPETITIONS", 12, 29869},
	{"ZEDT", 4, 29870},
	{"DISCRETION", 10, 29871},
	{"SSAL", 4, 29872},
	{"TANZANIA", 8, 29873},
	{"JVC", 3, 29874},
	{"PSON", 4, 29875},
	{"VJA", 3, 29876},
	{"TICP", 4, 29877},
	{"NGAW", 4, 29878},
	{"ENLI", 4, 29879},
	{"UGHL", 4, 29880},
	{"UNSIGNED", 8, 29881},
	{"LLTE", 4, 29882},
	{"STAYING", 7, 29883},
	{"COSMETICS", 9, 29884},
	{"MISSING", 7, 29885},
	{"EASTER", 6, 29886},
	{"GGRE", 4, 29887},
	{"THEORIES", 8, 29888},
	{"REPOSITORY", 10, 29889},
	{"JEREMY", 6, 29890},
	{"YNJ", 3, 29891},
	{"VENICE", 6, 29892},
	{"RESPECTIVELY", 12, 29893},
	{"DMEN", 4, 29894},
	{"CONCENTRATIONS", 14, 29895},
	{"ESTONIA", 7, 29896},
	{"UPFO", 4, 29897},
	{"ERUL", 4, 29898},
	{"SBYT", 4, 29899},
	{"STREAMS", 7, 29900},
	{"SIGNING", 7, 29901},
	{"EXECUTED", 8, 29902},
	{"KATIE", 5, 29903},
	{"NEGOTIATIONS", 12, 29904},
	{"BAY", 3, 29905},
	{"ITME", 4, 29906},
	{"CGI", 3, 29907},
	{"SUCK", 4, 29908},
	{"CURTAIN", 7, 29909},
	{"SHOWCASE", 8, 29910},
	{"WHOR", 4, 29911},
	{"OPHI", 4, 29912},
	{"INTEGRAL", 8, 29913},
	{"ASKS", 4, 29914},
	{"OWMA", 4, 29915},
	{"MZI", 3, 29916},
	{"UMPE", 4, 29917},
	{"DNOW", 4, 29918},
	{"ARPE", 4, 29919},
	{"DUPT", 4, 29920},
	{"DEADLY", 6, 29921},
	{"LLEV", 4, 29922},
	{"YDF", 3, 29923},
	{"ELYD", 4, 29924},
	{"SOUTHWEST", 9, 29925},
	{"NAMIBIA", 7, 29926},
	{"ZDU", 3, 29927},
	{"YDEC", 4, 29928},
	{"GENERATING", 10, 29929},
	{"CHRISTINA", 9, 29930},
	{"THPR", 4, 29931},
	{"SYNOPSIS", 8, 29932},
	{"ANPO", 4, 29933},
	{"ENWO", 4, 29934},
	{"UISI", 4, 29935},
	{"PRAIRIE", 7, 29936},
	{"REUNION", 7, 29937},
	{"OWNERSHIP", 9, 29938},
	{"COMPOSER", 8, 29939},
	{"FRAUD", 5, 29940},
	{"EXAN", 4, 29941},
	{"KYJ", 3, 29942},
	{"OODC", 4, 29943},
	{"SIXTH", 5, 29944},
	{"MAINSTREAM", 10, 29945},
	{"ABSENT", 6, 29946},
	{"PHOTOGRAPHIC", 12, 29947},
	{"IALF", 4, 29948},
	{"FWOR", 4, 29949},
	{"ARRAY", 5, 29950},
	{"SKIRT", 5, 29951},
	{"SELLS", 5, 29952},
	{"MONSTER", 7, 29953},
	{"RIP", 3, 29954},
	{"ECUADOR", 7, 29955},
	{"HOPING", 6, 29956},
	{"ACCESSED", 8, 29957},
	{"OFAF", 4, 29958},
	{"AVEW", 4, 29959},
	{"OCCASIONAL", 10, 29960},
	{"ENFORCE", 7, 29961},
	{"IPTI", 4, 29962},
	{"EXCITEMENT", 10, 29963},
	{"UBSE", 4, 29964},
	{"SPIRITS", 7, 29965},
	{"RONO", 4, 29966},
	{"CAUG", 4, 29967},
	{"MODIFICATIONS", 13, 29968},
	{"ASTRONOMER", 10, 29969},
	{"LDCA", 4, 29970},
	{"CORAL", 5, 29971},
	{"REVERSE", 7, 29972},
	{"PIXEL", 5, 29973},
	{"SHIF", 4, 29974},
	{"DERH", 4, 29975},
	{"LSAI", 4, 29976},
	{"DLAS", 4, 29977},
	{"COLIN", 5, 29978},
	{"IMPORTED", 8, 29979},
	{"IDDE", 4, 29980},
	{"PATHS", 5, 29981},
	{"DWAT", 4, 29982},
	{"POR", 3, 29983},
	{"CSAN", 4, 29984},
	{"ESED", 4, 29985},
	{"LTED", 4, 29986},
	{"PLEAD", 5, 29987},
	{"CONTRARY", 8, 29988},
	{"MENW", 4, 29989},
	{"SBOT", 4, 29990},
	{"MILLENNIUM", 10, 29991},
	{"TRIBUNE", 7, 29992},
	{"COMPANION", 9, 29993},
	{"DBRO", 4, 29994},
	{"ADMINISTER", 10, 29995},
	{"ANYD", 4, 29996},
	{"ACIDS", 5, 29997},
	{"AMENDMENT", 9, 29998},
	{"ALFR", 4, 29999},
	{"BROADCAST", 9, 30000},
	{"FOCUSING", 8, 30001},
	{"INSPECTION", 10, 30002},
	{"YTWO", 4, 30003},
	{"VIRUSES", 7, 30004},
	{"CHEAPER", 7, 30005},
	{"GWOR", 4, 30006},
	{"ADMITTED", 8, 30007},
	{"RSOR", 4, 30008},
	{"OFGE", 4, 30009},
	{"DRAIN", 5, 30010},
	{"FOREHEAD", 8, 30011},
	{"DAIRY", 5, 30012},
	{"DOFH", 4, 30013},
	{"DSEA", 4, 30014},
	{"MEM", 3, 30015},
	{"EWOF", 4, 30016},
	{"DLET", 4, 30017},
	{"FANCY", 5, 30018},
	{"ELOV", 4, 30019},
	{"SAMOA", 5, 30020},
	{"NSUP", 4, 30021},
	{"ACHIEVING", 9, 30022},
	{"ARTW", 4, 30023},
	{"ROPR", 4, 30024},
	{"ARYF", 4, 30025},
	{"DHIG", 4, 30026},
	{"SLAR", 4, 30027},
	{"STICKERS", 8, 30028},
	{"AGEF", 4, 30029},
	{"FISHERIES", 9, 30030},
	{"ESGO", 4, 30031},
	{"ELOR", 4, 30032},
	{"CONSISTENTLY", 12, 30033},
	{"EXCEPTIONS", 10, 30034},
	{"VYY", 3, 30035},
	{"OUTDOOR", 7, 30036},
	{"INGK", 4, 30037},
	{"REACTIONS", 9, 30038},
	{"INNOVATION", 10, 30039},
	{"FNY", 3, 30040},
	{"LEASING", 7, 30041},
	{"TNIG", 4, 30042},
	{"GPAR", 4, 30043},
	{"DATABASE", 8, 30044},
	{"LAUREN", 6, 30045},
	{"HARSH", 5, 30046},
	{"EDUS", 4, 30047},
	{"BELIEFS", 7, 30048},
	{"MACROMEDIA", 10, 30049},
	{"GLEA", 4, 30050},
	{"ASHLEY", 6, 30051},
	{"SCROLL", 6, 30052},
	{"DIVISIONS", 9, 30053},
	{"WAGES", 5, 30054},
	{"ADDITIONALLY", 12, 30055},
	{"DOCTRINE", 8, 30056},
	{"SINL", 4, 30057},
	{"OLDO", 4, 30058},
	{"ONAU", 4, 30059},
	{"OBSTACLE", 8, 30060},
	{"MAXIMUM", 7, 30061},
	{"FORESTS", 7, 30062},
	{"LOYM", 4, 30063},
	{"LVIN", 4, 30064},
	{"APAB", 4, 30065},
	{"YPY", 3, 30066},
	{"EAPA", 4, 30067},
	{"INVALID", 7, 30068},
	{"NGGA", 4, 30069},
	{"EDLO", 4, 30070},
	{"NGTA", 4, 30071},
	{"EEQU", 4, 30072},
	{"DGER", 4, 30073},
	{"CONCERTS", 8, 30074},
	{"CARBOHYDRATE", 12, 30075},
	{"MARTIAL", 7, 30076},
	{"ONFU", 4, 30077},
	{"RICI", 4, 30078},
	{"MALES", 5, 30079},
	{"LYEN", 4, 30080},
	{"RALB", 4, 30081},
	{"XIMA", 4, 30082},
	{"ESIR", 4, 30083},
	{"FEAN", 4, 30084},
	{"VICTORIAN", 9, 30085},
	{"FOFT", 4, 30086},
	{"SUPERVISOR", 10, 30087},
	{"COLOURS", 7, 30088},
	{"VYV", 3, 30089},
	{"NDOL", 4, 30090},
	{"IVEG", 4, 30091},
	{"CONFUSE", 7, 30092},
	{"AXU", 3, 30093},
	{"ANOV", 4, 30094},
	{"GENRES", 6, 30095},
	{"CAMBODIA", 8, 30096},
	{"PATENTS", 7, 30097},
	{"COPYRIGHTS", 10, 30098},
	{"OLYMPICS", 8, 30099},
	{"SRAN", 4, 30100},
	{"LITHUANIA", 9, 30101},
	{"CHRONIC", 7, 30102},
	{"SWEAT", 5, 30103},
	{"MASTERCARD", 10, 30104},
	{"ANYR", 4, 30105},
	{"CRYSTAL", 7, 30106},
	{"REEY", 4, 30107},
	{"CHRONICLES", 10, 30108},
	{"ICSO", 4, 30109},
	{"YTOM", 4, 30110},
	{"OBTAINING", 9, 30111},
	{"OSTF", 4, 30112},
	{"GHHE", 4, 30113},
	{"BEAVER", 6, 30114},
	{"ARYP", 4, 30115},
	{"TRAP", 4, 30116},
	{"MOTIVE", 6, 30117},
	{"ZZP", 3, 30118},
	{"QIG", 3, 30119},
	{"UPDATING", 8, 30120},
	{"READINGS", 8, 30121},
	{"HIFT", 4, 30122},
	{"MUD", 3, 30123},
	{"APOR", 4, 30124},
	{"DECORATIVE", 10, 30125},
	{"KIJIJI", 6, 30126},
	{"RUMOR", 5, 30127},
	{"CONFUSED", 8, 30128},
	{"UTHW", 4, 30129},
	{"MPED", 4, 30130},
	{"LIMB", 4, 30131},
	{"MESB", 4, 30132},
	{"COMPILER", 8, 30133},
	{"WOW", 3, 30134},
	{"GDOW", 4, 30135},
	{"NGEF", 4, 30136},
	{"PLAIN", 5, 30137},
	{"ENLARGEMENT", 11, 30138},
	{"EAGLES", 6, 30139},
	{"BASES", 5, 30140},
	{"STRICT", 6, 30141},
	{"MINIMUM", 7, 30142},
	{"NALG", 4, 30143},
	{"ACCUSED", 7, 30144},
	{"SEEMINGLY", 9, 30145},
	{"CAMPAIGNS", 9, 30146},
	{"ARENA", 5, 30147},
	{"YOX", 3, 30148},
	{"KEDW", 4, 30149},
	{"FISCAL", 6, 30150},
	{"CONJUNCTION", 11, 30151},
	{"FORGIVE", 7, 30152},
	{"AKEH", 4, 30153},
	{"OUBT", 4, 30154},
	{"RATS", 4, 30155},
	{"YSCO", 4, 30156},
	{"SODIUM", 6, 30157},
	{"DEFINES", 7, 30158},
	{"HEYB", 4, 30159},
	{"ASSEMBLE", 8, 30160},
	{"PREDICTION", 10, 30161},
	{"AIRPORTS", 8, 30162},
	{"TSWA", 4, 30163},
	{"YSAY", 4, 30164},
	{"ADOW", 4, 30165},
	{"ITHU", 4, 30166},
	{"INSTANCES", 9, 30167},
	{"BEGUN", 5, 30168},
	{"OWDO", 4, 30169},
	{"CFR", 3, 30170},
	{"BRUNETTE", 8, 30171},
	{"PACKETS", 7, 30172},
	{"WAYW", 4, 30173},
	{"FLOOD", 5, 30174},
	{"ADOPTION", 8, 30175},
	{"ANCHOR", 6, 30176},
	{"IGUE", 4, 30177},
	{"SOCKS", 5, 30178},
	{"VALIDATION", 10, 30179},
	{"GEVE", 4, 30180},
	{"TRAIT", 5, 30181},
	{"MTOT", 4, 30182},
	{"DSTU", 4, 30183},
	{"INCENTIVES", 10, 30184},
	{"TOWEL", 5, 30185},
	{"RSTB", 4, 30186},
	{"IALD", 4, 30187},
	{"YOFH", 4, 30188},
	{"WARRIOR", 7, 30189},
	{"HEYF", 4, 30190},
	{"GTOR", 4, 30191},
	{"GATHERED", 8, 30192},
	{"ILIP", 4, 30193},
	{"POND", 4, 30194},
	{"SLOVENIA", 8, 30195},
	{"NOTIFIED", 8, 30196},
	{"DIFFERENTIAL", 12, 30197},
	{"BEACHES", 7, 30198},
	{"ERSG", 4, 30199},
	{"LYEX", 4, 30200},
	{"FOLDERS", 7, 30201},
	{"MEPR", 4, 30202},
	{"SURFACES", 8, 30203},
	{"RVEY", 4, 30204},
	{"LEND", 4, 30205},
	{"INFRASTRUCTURE", 14, 30206},
	{"SIMULTANEOUSLY", 14, 30207},
	{"VORI", 4, 30208},
	{"UREM", 4, 30209},
	{"ROUTERS", 7, 30210},
	{"CRUZ", 4, 30211},
	{"PENDANT", 7, 30212},
	{"DRESSES", 7, 30213},
	{"BAPTIST", 7, 30214},
	{"STARSMERCHANT", 13, 30215},
	{"HIRING", 6, 30216},
	{"UNDW", 4, 30217},
	{"CLOCKS", 6, 30218},
	{"DYEA", 4, 30219},
	{"ARTHRITIS", 9, 30220},
	{"BIOS", 4, 30221},
	{"YBB", 3, 30222},
	{"NEYE", 4, 30223},
	{"FEMALES", 7, 30224},
	{"NFRI", 4, 30225},
	{"TEMPLE", 6, 30226},
	{"WALLACE", 7, 30227},
	{"OSEF", 4, 30228},
	{"TSWO", 4, 30229},
	{"REFLECTS", 8, 30230},
	{"TAXATION", 8, 30231},
	{"CONVICT", 7, 30232},
	{"ARDB", 4, 30233},
	{"LSOU", 4, 30234},
	{"PMC", 3, 30235},
	{"MANB", 4, 30236},
	{"HTLY", 4, 30237},
	{"ORBO", 4, 30238},
	{"MEOU", 4, 30239},
	{"TUNE", 4, 30240},
	{"FTRA", 4, 30241},
	{"CUISINE", 7, 30242},
	{"EXUA", 4, 30243},
	{"PRACTITIONERS", 13, 30244},
	{"RYX", 3, 30245},
	{"TRANSCRIPT", 10, 30246},
	{"MYSPACE", 7, 30247},
	{"YCHI", 4, 30248},
	{"UCIN", 4, 30249},
	{"THEOREM", 7, 30250},
	{"PARTICLE", 8, 30251},
	{"PRIVILEGE", 9, 30252},
	{"FPER", 4, 30253},
	{"LFAN", 4, 30254},
	{"RUTH", 4, 30255},
	{"STYLUS", 6, 30256},
	{"COMPOUNDS", 9, 30257},
	{"OMOF", 4, 30258},
	{"POPE", 4, 30259},
	{"DRUMS", 5, 30260},
	{"CONTRACTING", 11, 30261},
	{"SOFN", 4, 30262},
	{"ONSD", 4, 30263},
	{"WILDERNESS", 10, 30264},
	{"DOORWAY", 7, 30265},
	{"RHIG", 4, 30266},
	{"PSTO", 4, 30267},
	{"OXK", 3, 30268},
	{"ESFI", 4, 30269},
	{"RADIATION", 9, 30270},
	{"CHME", 4, 30271},
	{"DSWE", 4, 30272},
	{"LYUS", 4, 30273},
	{"EREY", 4, 30274},
	{"FORMAT", 6, 30275},
	{"ARNOLD", 6, 30276},
	{"STRUCTURED", 10, 30277},
	{"LEWO", 4, 30278},
	{"LYIS", 4, 30279},
	{"REASONABLY", 10, 30280},
	{"JEEP", 4, 30281},
	{"DWOU", 4, 30282},
	{"CHICKS", 6, 30283},
	{"WENE", 4, 30284},
	{"OBEE", 4, 30285},
	{"EOUR", 4, 30286},
	{"HUNG", 4, 30287},
	{"MBA", 3, 30288},
	{"RTEN", 4, 30289},
	{"NDBY", 4, 30290},
	{"FFAN", 4, 30291},
	{"GPER", 4, 30292},
	{"GRADUATES", 9, 30293},
	{"DISK", 4, 30294},
	{"ROVER", 5, 30295},
	{"RECOMMENDS", 10, 30296},
	{"CONTROLLING", 11, 30297},
	{"NIGHTMARE", 9, 30298},
	{"RELOAD", 6, 30299},
	{"DISTRIBUTORS", 12, 30300},
	{"DRUNK", 5, 30301},
	{"INEVITABLE", 10, 30302},
	{"IORT", 4, 30303},
	{"AYME", 4, 30304},
	{"HHIM", 4, 30305},
	{"LEVITRA", 7, 30306},
	{"TANKS", 5, 30307},
	{"NDSM", 4, 30308},
	{"GNAN", 4, 30309},
	{"ASSUMING", 8, 30310},
	{"HEGL", 4, 30311},
	{"ALIV", 4, 30312},
	{"SSWI", 4, 30313},
	{"VESW", 4, 30314},
	{"MONETARY", 8, 30315},
	{"OLST", 4, 30316},
	{"ARLINGTON", 9, 30317},
	{"MONO", 4, 30318},
	{"PARTICLES", 9, 30319},
	{"FLOATING", 8, 30320},
	{"OUWA", 4, 30321},
	{"RGEA", 4, 30322},
	{"TWIST", 5, 30323},
	{"URTI", 4, 30324},
	{"LDHE", 4, 30325},
	{"ELLP", 4, 30326},
	{"ADLI", 4, 30327},
	{"STRUCTURAL", 10, 30328},
	{"HILI", 4, 30329},
	{"RETIRED", 7, 30330},
	{"INDICATING", 10, 30331},
	{"BOLIVIA", 7, 30332},
	{"RMTH", 4, 30333},
	{"HOTTEST", 7, 30334},
	{"EANU", 4, 30335},
	{"IKEH", 4, 30336},
	{"STEVENS", 7, 30337},
	{"THEOLOGY", 8, 30338},
	{"LLOV", 4, 30339},
	{"YIJ", 3, 30340},
	{"ANNOUNCEMENT", 12, 30341},
	{"BOOST", 5, 30342},
	{"UCKS", 4, 30343},
	{"KUWAIT", 6, 30344},
	{"RLIF", 4, 30345},
	{"RKSA", 4, 30346},
	{"COMMONLY", 8, 30347},
	{"OCKA", 4, 30348},
	{"GGIN", 4, 30349},
	{"EMILY", 5, 30350},
	{"ISJU", 4, 30351},
	{"THWI", 4, 30352},
	{"WIDESCREEN", 10, 30353},
	{"COMPILE", 7, 30354},
	{"AINP", 4, 30355},
	{"NGUS", 4, 30356},
	{"SQUIRTING", 9, 30357},
	{"EGEO", 4, 30358},
	{"WEBSTER", 7, 30359},
	{"STRUCK", 6, 30360},
	{"FRESHMAN", 8, 30361},
	{"LLFI", 4, 30362},
	{"ILLUSTRATION", 12, 30363},
	{"WALKING", 7, 30364},
	{"PAD", 3, 30365},
	{"CONTINUING", 10, 30366},
	{"AWTH", 4, 30367},
	{"USOF", 4, 30368},
	{"OBAC", 4, 30369},
	{"PLYMOUTH", 8, 30370},
	{"TUNT", 4, 30371},
	{"NGEM", 4, 30372},
	{"OPTH", 4, 30373},
	{"WARNINGS", 8, 30374},
	{"ESYO", 4, 30375},
	{"ERYF", 4, 30376},
	{"AWHE", 4, 30377},
	{"MECHANICAL", 10, 30378},
	{"APPS", 4, 30379},
	{"TGY", 3, 30380},
	{"INQUIRIES", 9, 30381},
	{"BRIDAL", 6, 30382},
	{"OVERWHELMING", 12, 30383},
	{"ANNEX", 5, 30384},
	{"SEDM", 4, 30385},
	{"UNEXPECTED", 10, 30386},
	{"TRANSMISSION", 12, 30387},
	{"NTOG", 4, 30388},
	{"POSSESSION", 10, 30389},
	{"DNOR", 4, 30390},
	{"CATTLE", 6, 30391},
	{"MAG", 3, 30392},
	{"GSM", 3, 30393},
	{"ACTW", 4, 30394},
	{"AFFECTING", 9, 30395},
	{"IKNO", 4, 30396},
	{"COLONY", 6, 30397},
	{"RSLI", 4, 30398},
	{"CANM", 4, 30399},
	{"FREIGHT", 7, 30400},
	{"MEBE", 4, 30401},
	{"RANDOM", 6, 30402},
	{"REBATE", 6, 30403},
	{"ORFR", 4, 30404},
	{"MEETUP", 6, 30405},
	{"LYAR", 4, 30406},
	{"ECLIPSE", 7, 30407},
	{"HCOU", 4, 30408},
	{"SUDAN", 5, 30409},
	{"HORN", 4, 30410},
	{"COMPLEXITY", 10, 30411},
	{"DDR", 3, 30412},
	{"DOWNLOADING", 11, 30413},
	{"UNITY", 5, 30414},
	{"ONEV", 4, 30415},
	{"REC", 3, 30416},
	{"AGGREGATE", 9, 30417},
	{"FCHA", 4, 30418},
	{"SOMU", 4, 30419},
	{"TLYW", 4, 30420},
	{"STUNNING", 8, 30421},
	{"CYCLES", 6, 30422},
	{"AFFECTS", 7, 30423},
	{"FORECASTS", 9, 30424},
	{"HEEU", 4, 30425},
	{"WEDB", 4, 30426},
	{"SPILL", 5, 30427},
	{"CIAO", 4, 30428},
	{"AMPLAND", 7, 30429},
	{"RAILROAD", 8, 30430},
	{"CANVAS", 6, 30431},
	{"PREP", 4, 30432},
	{"ISAW", 4, 30433},
	{"ELER", 4, 30434},
	{"CCUS", 4, 30435},
	{"CHEM", 4, 30436},
	{"FASTEST", 7, 30437},
	{"BUTLER", 6, 30438},
	{"UPRE", 4, 30439},
	{"BELLY", 5, 30440},
	{"SHOPZILLA", 9, 30441},
	{"LYBU", 4, 30442},
	{"ISEM", 4, 30443},
	{"DECORATING", 10, 30444},
	{"OFWE", 4, 30445},
	{"TECHNOLOGICAL", 13, 30446},
	{"DVIC", 4, 30447},
	{"PAYROLL", 7, 30448},
	{"COOKBOOK", 8, 30449},
	{"CONSULT", 7, 30450},
	{"ULDM", 4, 30451},
	{"TINM", 4, 30452},
	{"EXPRESSIONS", 11, 30453},
	{"VIRTUAL", 7, 30454},
	{"FESTIVAL", 8, 30455},
	{"COURIER", 7, 30456},
	{"ALHA", 4, 30457},
	{"SROO", 4, 30458},
	{"ADEH", 4, 30459},
	{"IKD", 3, 30460},
	{"HERS", 4, 30461},
	{"UPLOADED", 8, 30462},
	{"TOKN", 4, 30463},
	{"SPEO", 4, 30464},
	{"UNSE", 4, 30465},
	{"RHETORIC", 8, 30466},
	{"SHAKESPEARE", 11, 30467},
	{"HINTS", 5, 30468},
	{"NDCU", 4, 30469},
	{"EATP", 4, 30470},
	{"CCAI", 4, 30471},
	{"UNDERMINE", 9, 30472},
	{"AMERICAS", 8, 30473},
	{"SEPARATION", 10, 30474},
	{"CONNECTORS", 10, 30475},
	{"TWINKS", 6, 30476},
	{"ULTE", 4, 30477},
	{"LYSO", 4, 30478},
	{"TURKEY", 6, 30479},
	{"ADFO", 4, 30480},
	{"YDV", 3, 30481},
	{"XYM", 3, 30482},
	{"GIF", 3, 30483},
	{"TDON", 4, 30484},
	{"ONGB", 4, 30485},
	{"CURRENCY", 8, 30486},
	{"OZL", 3, 30487},
	{"PROS", 4, 30488},
	{"DFRI", 4, 30489},
	{"YCM", 3, 30490},
	{"RCLE", 4, 30491},
	{"CONFLICTS", 9, 30492},
	{"TECHNO", 6, 30493},
	{"BEVERAGE", 8, 30494},
	{"GUILT", 5, 30495},
	{"RSTW", 4, 30496},
	{"TRIBUTE", 7, 30497},
	{"LTTH", 4, 30498},
	{"WIRED", 5, 30499},
	{"RNES", 4, 30500},
	{"OPHY", 4, 30501},
	{"FORK", 4, 30502},
	{"ELVIS", 5, 30503},
	{"NCIT", 4, 30504},
	{"AYNE", 4, 30505},
	{"SSEV", 4, 30506},
	{"TALB", 4, 30507},
	{"TWON", 4, 30508},
	{"GNIT", 4, 30509},
	{"LATVIA", 6, 30510},
	{"TRAVELERS", 9, 30511},
	{"DPEO", 4, 30512},
	{"FORESTRY", 8, 30513},
	{"BARRIERS", 8, 30514},
	{"CANT", 4, 30515},
	{"FEEDBACK", 8, 30516},
	{"EISM", 4, 30517},
	{"REPLACEMENT", 11, 30518},
	{"LLLE", 4, 30519},
	{"NWIN", 4, 30520},
	{"GPL", 3, 30521},
	{"INFECTED", 8, 30522},
	{"OFFERINGS", 9, 30523},
	{"MARTHA", 6, 30524},
	{"GENESIS", 7, 30525},
	{"INCORRECT", 9, 30526},
	{"DOFC", 4, 30527},
	{"WSAN", 4, 30528},
	{"GRIP", 4, 30529},
	{"TRAINS", 6, 30530},
	{"FMAR", 4, 30531},
	{"TZY", 3, 30532},
	{"METALS", 6, 30533},
	{"MEANINGFUL", 10, 30534},
	{"FURNISHINGS", 11, 30535},
	{"TRADITIONALLY", 13, 30536},
	{"LETTING", 7, 30537},
	{"STRAIN", 6, 30538},
	{"GUITAR", 6, 30539},
	{"GUATEMALA", 9, 30540},
	{"EJOI", 4, 30541},
	{"TPOI", 4, 30542},
	{"WEIRD", 5, 30543},
	{"CELTIC", 6, 30544},
	{"IRC", 3, 30545},
	{"UNDH", 4, 30546},
	{"JAMIE", 5, 30547},
	{"DUCI", 4, 30548},
	{"RPOL", 4, 30549},
	{"PEACEFUL", 8, 30550},
	{"MANDATE", 7, 30551},
	{"GWHE", 4, 30552},
	{"MINERALS", 8, 30553},
	{"USHO", 4, 30554},
	{"NLYI", 4, 30555},
	{"DWID", 4, 30556},
	{"KEDU", 4, 30557},
	{"EATW", 4, 30558},
	{"LLDE", 4, 30559},
	{"SBOO", 4, 30560},
	{"HUMIDITY", 8, 30561},
	{"BOTTLES", 7, 30562},
	{"ETFO", 4, 30563},
	{"BOXING", 6, 30564},
	{"INPU", 4, 30565},
	{"ONDH", 4, 30566},
	{"BANGKOK", 7, 30567},
	{"RENAISSANCE", 11, 30568},
	{"ENBU", 4, 30569},
	{"PATHOLOGY", 9, 30570},
	{"SARA", 4, 30571},
	{"DUMP", 4, 30572},
	{"DTRI", 4, 30573},
	{"OBEP", 4, 30574},
	{"BRA", 3, 30575},
	{"AYMO", 4, 30576},
	{"LEFR", 4, 30577},
	{"DMET", 4, 30578},
	{"RESN", 4, 30579},
	{"RSEY", 4, 30580},
	{"ORDINANCE", 9, 30581},
	{"HUGHES", 6, 30582},
	{"PHOTOGRAPHERS", 13, 30583},
	{"LLPA", 4, 30584},
	{"LMON", 4, 30585},
	{"OUSF", 4, 30586},
	{"ASUP", 4, 30587},
	{"ENGAGEMENT", 10, 30588},
	{"INFECTIONS", 10, 30589},
	{"DCLA", 4, 30590},
	{"ELYW", 4, 30591},
	{"JEFFREY", 7, 30592},
	{"CHESS", 5, 30593},
	{"EXECUTE", 7, 30594},
	{"UNCERTAINTY", 11, 30595},
	{"OPERATES", 8, 30596},
	{"BRISBANE", 8, 30597},
	{"UTET", 4, 30598},
	{"GOVERN", 6, 30599},
	{"SIDEWALK", 8, 30600},
	{"NTEV", 4, 30601},
	{"DDON", 4, 30602},
	{"CONFIGURED", 10, 30603},
	{"WASK", 4, 30604},
	{"UNCOMFORTABLE", 13, 30605},
	{"OUKN", 4, 30606},
	{"YBEE", 4, 30607},
	{"DANCER", 6, 30608},
	{"OSCAR", 5, 30609},
	{"PORTFOLIO", 9, 30610},
	{"LTHY", 4, 30611},
	{"FESTIVALS", 9, 30612},
	{"MENUS", 5, 30613},
	{"PENSION", 7, 30614},
	{"HWHI", 4, 30615},
	{"RYDA", 4, 30616},
	{"XYI", 3, 30617},
	{"THUMB", 5, 30618},
	{"JOAN", 4, 30619},
	{"POSSIBILITIES", 13, 30620},
	{"CANAL", 5, 30621},
	{"CTON", 4, 30622},
	{"SUJ", 3, 30623},
	{"AMINO", 5, 30624},
	{"CONTRIBUTING", 12, 30625},
	{"AYAS", 4, 30626},
	{"ISAV", 4, 30627},
	{"ESIX", 4, 30628},
	{"HERBS", 5, 30629},
	{"EWCO", 4, 30630},
	{"CLINICS", 7, 30631},
	{"MLS", 3, 30632},
	{"LUMN", 4, 30633},
	{"SLIV", 4, 30634},
	{"MANITOBA", 8, 30635},
	{"LANDING", 7, 30636},
	{"ANALYTICAL", 10, 30637},
	{"MISSIONS", 8, 30638},
	{"WATSON", 6, 30639},
	{"ATBA", 4, 30640},
	{"LYING", 5, 30641},
	{"THMI", 4, 30642},
	{"YCD", 3, 30643},
	{"COSTUMES", 8, 30644},
	{"DIVE", 4, 30645},
	{"AIDW", 4, 30646},
	{"SADDAM", 6, 30647},
	{"GRACE", 5, 30648},
	{"CONTRACTOR", 10, 30649},
	{"CIRCULATION", 11, 30650},
	{"ALARM", 5, 30651},
	{"LXL", 3, 30652},
	{"TRIGGER", 7, 30653},
	{"SILY", 4, 30654},
	{"AVIL", 4, 30655},
	{"BRYAN", 5, 30656},
	{"ILVE", 4, 30657},
	{"OLQ", 3, 30658},
	{"TYWH", 4, 30659},
	{"THGR", 4, 30660},
	{"ORDT", 4, 30661},
	{"GTRA", 4, 30662},
	{"RBOR", 4, 30663},
	{"ONJA", 4, 30664},
	{"EBYT", 4, 30665},
	{"JERUSALEM", 9, 30666},
	{"HOBBY", 5, 30667},
	{"HARM", 4, 30668},
	{"TRIES", 5, 30669},
	{"OUTER", 5, 30670},
	{"AKEP", 4, 30671},
	{"NSAY", 4, 30672},
	{"UJE", 3, 30673},
	{"EASP", 4, 30674},
	{"ILIZ", 4, 30675},
	{"NICKNAME", 8, 30676},
	{"OFPL", 4, 30677},
	{"XCIT", 4, 30678},
	{"ZVA", 3, 30679},
	{"RTHC", 4, 30680},
	{"FIJI", 4, 30681},
	{"INLINE", 6, 30682},
	{"YNK", 3, 30683},
	{"EXECUTIVES", 10, 30684},
	{"UCER", 4, 30685},
	{"ENQUIRIES", 9, 30686},
	{"GRATEFUL", 8, 30687},
	{"WASHING", 7, 30688},
	{"CRAWL", 5, 30689},
	{"AUDI", 4, 30690},
	{"STAFFING", 8, 30691},
	{"EXPLORING", 9, 30692},
	{"IALW", 4, 30693},
	{"TISB", 4, 30694},
	{"SHUTTLE", 7, 30695},
	{"YOFP", 4, 30696},
	{"ARDR", 4, 30697},
	{"UMBL", 4, 30698},
	{"ENQUIRY", 7, 30699},
	{"CLOSURE", 7, 30700},
	{"RAID", 4, 30701},
	{"CANF", 4, 30702},
	{"PPC", 3, 30703},
	{"VOLT", 4, 30704},
	{"SOUTHEAST", 9, 30705},
	{"YGET", 4, 30706},
	{"THEREBY", 7, 30707},
	{"TOAF", 4, 30708},
	{"ENDURE", 6, 30709},
	{"DIV", 3, 30710},
	{"PLAYLIST", 8, 30711},
	{"RESERVE", 7, 30712},
	{"CHIN", 4, 30713},
	{"RTLY", 4, 30714},
	{"REGISTRAR", 9, 30715},
	{"SHOWERS", 7, 30716},
	{"REEV", 4, 30717},
	{"SUPPORTERS", 10, 30718},
	{"NZF", 3, 30719},
	{"LBAN", 4, 30720},
	{"OBIN", 4, 30721},
	{"STATUTES", 8, 30722},
	{"UIPM", 4, 30723},
	{"RSOU", 4, 30724},
	{"MYERS", 5, 30725},
	{"INJURE", 6, 30726},
	{"INDICATOR", 9, 30727},
	{"DBEG", 4, 30728},
	{"DROPS", 5, 30729},
	{"PREDICTED", 9, 30730},
	{"WIDER", 5, 30731},
	{"SASKATCHEWAN", 12, 30732},
	{"ODEF", 4, 30733},
	{"ACCOMMODATE", 11, 30734},
	{"DISM", 4, 30735},
	{"CANCELLATION", 12, 30736},
	{"PLUGINS", 7, 30737},
	{"ENROLLED", 8, 30738},
	{"FSOM", 4, 30739},
	{"SENSORS", 7, 30740},
	{"NTMO", 4, 30741},
	{"MINISTERS", 9, 30742},
	{"EGUN", 4, 30743},
	{"EGUY", 4, 30744},
	{"EGOL", 4, 30745},
	{"YLG", 3, 30746},
	{"YSBE", 4, 30747},
	{"AILW", 4, 30748},
	{"HOURLY", 6, 30749},
	{"NDQU", 4, 30750},
	{"YLR", 3, 30751},
	{"GENEVA", 6, 30752},
	{"LOBBY", 5, 30753},
	{"RSWA", 4, 30754},
	{"SCOA", 4, 30755},
	{"HOCO", 4, 30756},
	{"AWAIT", 5, 30757},
	{"FREEBSD", 7, 30758},
	{"LEXP", 4, 30759},
	{"CLICK", 5, 30760},
	{"VETERINARY", 10, 30761},
	{"ACER", 4, 30762},
	{"PROSTORES", 9, 30763},
	{"RESELLER", 8, 30764},
	{"OLOO", 4, 30765},
	{"NUZ", 3, 30766},
	{"WINA", 4, 30767},
	{"BEHAVE", 6, 30768},
	{"DIST", 4, 30769},
	{"YRM", 3, 30770},
	{"ORWO", 4, 30771},
	{"ROMR", 4, 30772},
	{"EUPT", 4, 30773},
	{"EEPS", 4, 30774},
	{"ADEB", 4, 30775},
	{"HANDED", 6, 30776},
	{"SATR", 4, 30777},
	{"HORRIBLE", 8, 30778},
	{"SUFFERED", 8, 30779},
	{"ELEVATOR", 8, 30780},
	{"ONPL", 4, 30781},
	{"INTAKE", 6, 30782},
	{"YFIN", 4, 30783},
	{"RELEVANCE", 9, 30784},
	{"EASK", 4, 30785},
	{"TUCSON", 6, 30786},
	{"CONVEY", 6, 30787},
	{"MECHANICS", 9, 30788},
	{"HSTR", 4, 30789},
	{"DGIV", 4, 30790},
	{"REBEL", 5, 30791},
	{"MPIN", 4, 30792},
	{"DBEL", 4, 30793},
	{"HEADERS", 7, 30794},
	{"MISTAKES", 8, 30795},
	{"NUMERICAL", 9, 30796},
	{"DYTO", 4, 30797},
	{"ARSB", 4, 30798},
	{"TGIV", 4, 30799},
	{"GEEK", 4, 30800},
	{"PRIZE", 5, 30801},
	{"REPUBLIC", 8, 30802},
	{"CORRUPTION", 10, 30803},
	{"TEWH", 4, 30804},
	{"DEFINING", 8, 30805},
	{"XNXX", 4, 30806},
	{"ODRI", 4, 30807},
	{"SADV", 4, 30808},
	{"COUNTING", 8, 30809},
	{"UKNO", 4, 30810},
	{"COMPENSATION", 12, 30811},
	{"HANDSOME", 8, 30812},
	{"LLHI", 4, 30813},
	{"ACCOMPANIED", 11, 30814},
	{"SPOUSE", 6, 30815},
	{"HEMW", 4, 30816},
	{"EWSO", 4, 30817},
	{"DEVOTED", 7, 30818},
	{"PTTO", 4, 30819},
	{"PRINCETON", 9, 30820},
	{"JACOB", 5, 30821},
	{"SSUB", 4, 30822},
	{"CHBE", 4, 30823},
	{"EINJ", 4, 30824},
	{"RANDY", 5, 30825},
	{"SPIRITUALITY", 12, 30826},
	{"MESP", 4, 30827},
	{"CLOSED", 6, 30828},
	{"DSAL", 4, 30829},
	{"TOAV", 4, 30830},
	{"JUROR", 5, 30831},
	{"PROPRIETARY", 11, 30832},
	{"QFO", 3, 30833},
	{"TIMOTHY", 7, 30834},
	{"ERSY", 4, 30835},
	{"TISR", 4, 30836},
	{"CHILDRENS", 9, 30837},
	{"IRTU", 4, 30838},
	{"OBUI", 4, 30839},
	{"STARTER", 7, 30840},
	{"SOFTLY", 6, 30841},
	{"HUZ", 3, 30842},
	{"CHIG", 4, 30843},
	{"APOLOGIZE", 9, 30844},
	{"COUNTERPART", 11, 30845},
	{"AHAR", 4, 30846},
	{"NONPROFIT", 9, 30847},
	{"THUMBZILLA", 10, 30848},
	{"MEDIEVAL", 8, 30849},
	{"KJI", 3, 30850},
	{"PORCELAIN", 9, 30851},
	{"ALEV", 4, 30852},
	{"KESU", 4, 30853},
	{"HUG", 3, 30854},
	{"ANYH", 4, 30855},
	{"BRIDGES", 7, 30856},
	{"PROFOUND", 8, 30857},
	{"KUJ", 3, 30858},
	{"PICHUNTER", 9, 30859},
	{"CAPTURED", 8, 30860},
	{"FROZEN", 6, 30861},
	{"REBUILD", 7, 30862},
	{"ASJU", 4, 30863},
	{"ZCZ", 3, 30864},
	{"NRET", 4, 30865},
	{"WATT", 4, 30866},
	{"THEHUN", 6, 30867},
	{"TOFD", 4, 30868},
	{"ABIN", 4, 30869},
	{"MMIG", 4, 30870},
	{"COMPROMISE", 10, 30871},
	{"VEAT", 4, 30872},
	{"CASTING", 7, 30873},
	{"AKEC", 4, 30874},
	{"LSEC", 4, 30875},
	{"OPHE", 4, 30876},
	{"FLUID", 5, 30877},
	{"DAYTON", 6, 30878},
	{"TRANSLATED", 10, 30879},
	{"HESITATE", 8, 30880},
	{"ARWH", 4, 30881},
	{"SCATTER", 7, 30882},
	{"METAPHOR", 8, 30883},
	{"CAMERON", 7, 30884},
	{"COLUMNISTS", 10, 30885},
	{"ENDLESS", 7, 30886},
	{"TMUS", 4, 30887},
	{"PINS", 4, 30888},
	{"CARLOS", 6, 30889},
	{"EADC", 4, 30890},
	{"ELLH", 4, 30891},
	{"RENO", 4, 30892},
	{"DONNA", 5, 30893},
	{"ANDREAS", 7, 30894},
	{"CHOP", 4, 30895},
	{"BOUNCE", 6, 30896},
	{"RIDER", 5, 30897},
	{"SFRI", 4, 30898},
	{"DIPLOMA", 7, 30899},
	{"ORAL", 4, 30900},
	{"AMEH", 4, 30901},
	{"THPA", 4, 30902},
	{"EPTT", 4, 30903},
	{"SCANNING", 8, 30904},
	{"RSTF", 4, 30905},
	{"LIBERTY", 7, 30906},
	{"DETECTIVE", 9, 30907},
	{"POLO", 4, 30908},
	{"NADV", 4, 30909},
	{"VALIUM", 6, 30910},
	{"COPYING", 7, 30911},
	{"RPG", 3, 30912},
	{"CORDLESS", 8, 30913},
	{"PATRICIA", 8, 30914},
	{"TWEA", 4, 30915},
	{"LLWH", 4, 30916},
	{"DRIVING", 7, 30917},
	{"LSOO", 4, 30918},
	{"TENB", 4, 30919},
	{"EDDIE", 5, 30920},
	{"FDW", 3, 30921},
	{"UGANDA", 6, 30922},
	{"RSST", 4, 30923},
	{"PROVIDED", 8, 30924},
	{"SFIL", 4, 30925},
	{"GSHO", 4, 30926},
	{"FIRED", 5, 30927},
	{"RSTM", 4, 30928},
	{"YBEI", 4, 30929},
	{"HHAD", 4, 30930},
	{"ASVE", 4, 30931},
	{"ERYM", 4, 30932},
	{"HISTORICALLY", 12, 30933},
	{"CHPR", 4, 30934},
	{"HWIL", 4, 30935},
	{"PROT", 4, 30936},
	{"ADYT", 4, 30937},
	{"RYSE", 4, 30938},
	{"TRIVIA", 6, 30939},
	{"RTAK", 4, 30940},
	{"ADIDAS", 6, 30941},
	{"NVIN", 4, 30942},
	{"PERTH", 5, 30943},
	{"ZYE", 3, 30944},
	{"TRANSACTION", 11, 30945},
	{"FROG", 4, 30946},
	{"GRAMMAR", 7, 30947},
	{"USFO", 4, 30948},
	{"PROMOTION", 9, 30949},
	{"PICKUP", 6, 30950},
	{"RESIDENTIAL", 11, 30951},
	{"RDEA", 4, 30952},
	{"SYRIA", 5, 30953},
	{"NTFI", 4, 30954},
	{"ROFH", 4, 30955},
	{"HISU", 4, 30956},
	{"BOUG", 4, 30957},
	{"INQU", 4, 30958},
	{"THYO", 4, 30959},
	{"KLEIN", 5, 30960},
	{"SHOL", 4, 30961},
	{"NDSF", 4, 30962},
	{"YSON", 4, 30963},
	{"HARVEY", 6, 30964},
	{"TIRES", 5, 30965},
	{"EDPL", 4, 30966},
	{"LYPO", 4, 30967},
	{"LOGS", 4, 30968},
	{"TROV", 4, 30969},
	{"UNDERTAKEN", 10, 30970},
	{"EXCLUSIVE", 9, 30971},
	{"TGP", 3, 30972},
	{"RETRO", 5, 30973},
	{"WYM", 3, 30974},
	{"IPHO", 4, 30975},
	{"GUIDANCE", 8, 30976},
	{"ACHU", 4, 30977},
	{"STATEWIDE", 9, 30978},
	{"ANKLE", 5, 30979},
	{"SEMICONDUCTOR", 13, 30980},
	{"TYLI", 4, 30981},
	{"GREGORY", 7, 30982},
	{"EPISODES", 8, 30983},
	{"BOOLEAN", 7, 30984},
	{"CIRCULAR", 8, 30985},
	{"DGRO", 4, 30986},
	{"EGIR", 4, 30987},
	{"DIY", 3, 30988},
	{"RALG", 4, 30989},
	{"TPOL", 4, 30990},
	{"EATB", 4, 30991},
	{"CONVINCED", 9, 30992},
	{"MAINLAND", 8, 30993},
	{"NQUI", 4, 30994},
	{"BIAS", 4, 30995},
	{"ILLUSTRATIONS", 13, 30996},
	{"SUITS", 5, 30997},
	{"RARI", 4, 30998},
	{"IFET", 4, 30999},
	{"BUW", 3, 31000},
	{"WHEREVER", 8, 31001},
	{"HOOK", 4, 31002},
	{"CHANCES", 7, 31003},
	{"TFOL", 4, 31004},
	{"SWHY", 4, 31005},
	{"NHIM", 4, 31006},
	{"PRAISE", 6, 31007},
	{"NEEDLE", 6, 31008},
	{"ARG", 3, 31009},
	{"IRCL", 4, 31010},
	{"BEPR", 4, 31011},
	{"DAYB", 4, 31012},
	{"YBRI", 4, 31013},
	{"INTELLIGENT", 11, 31014},
	{"EQUATION", 8, 31015},
	{"RTSI", 4, 31016},
	{"RGEL", 4, 31017},
	{"ENTHUSIASM", 10, 31018},
	{"NREG", 4, 31019},
	{"BIZARRE", 7, 31020},
	{"OFMU", 4, 31021},
	{"SCARE", 5, 31022},
	{"GNAL", 4, 31023},
	{"GLENN", 5, 31024},
	{"REJU", 4, 31025},
	{"AUCKLAND", 8, 31026},
	{"WILDLIFE", 8, 31027},
	{"OVK", 3, 31028},
	{"FRUITS", 6, 31029},
	{"IDENTIFIER", 10, 31030},
	{"IKEW", 4, 31031},
	{"LDAT", 4, 31032},
	{"UTBE", 4, 31033},
	{"AYIT", 4, 31034},
	{"THME", 4, 31035},
	{"ASQU", 4, 31036},
	{"INVISIBLE", 9, 31037},
	{"CALCULATIONS", 12, 31038},
	{"USTF", 4, 31039},
	{"FFAM", 4, 31040},
	{"RELIEVE", 7, 31041},
	{"PREVENTION", 10, 31042},
	{"DOLL", 4, 31043},
	{"JPEG", 4, 31044},
	{"CONDUCTING", 10, 31045},
	{"NAGR", 4, 31046},
	{"STARTUP", 7, 31047},
	{"SIGNATURE", 9, 31048},
	{"SUNLIGHT", 8, 31049},
	{"FFRE", 4, 31050},
	{"SUZUKI", 6, 31051},
	{"NBEI", 4, 31052},
	{"SHAME", 5, 31053},
	{"ELECTRICAL", 10, 31054},
	{"OUSO", 4, 31055},
	{"ANAF", 4, 31056},
	{"TRINIDAD", 8, 31057},
	{"TIMING", 6, 31058},
	{"KISSING", 7, 31059},
	{"VESU", 4, 31060},
	{"OVEI", 4, 31061},
	{"WAL", 3, 31062},
	{"HANDY", 5, 31063},
	{"SWAP", 4, 31064},
	{"EXEMPT", 6, 31065},
	{"ACQUISITION", 11, 31066},
	{"NTSM", 4, 31067},
	{"CROPS", 5, 31068},
	{"MEHO", 4, 31069},
	{"GENUINE", 7, 31070},
	{"TRAVELER", 8, 31071},
	{"REDUCES", 7, 31072},
	{"IFEI", 4, 31073},
	{"ACCOMPLISHED", 12, 31074},
	{"CALCULATORS", 11, 31075},
	{"EXIT", 4, 31076},
	{"RESIDENCE", 9, 31077},
	{"DELICATE", 8, 31078},
	{"OPERA", 5, 31079},
	{"GEOMETRY", 8, 31080},
	{"SLOVAKIA", 8, 31081},
	{"GUILD", 5, 31082},
	{"DBEI", 4, 31083},
	{"LSZ", 3, 31084},
	{"STDI", 4, 31085},
	{"GORGEOUS", 8, 31086},
	{"CAPITOL", 7, 31087},
	{"DISHES", 6, 31088},
	{"ITHJ", 4, 31089},
	{"OUSH", 4, 31090},
	{"IEDF", 4, 31091},
	{"BARBADOS", 8, 31092},
	{"ACCOUNTING", 10, 31093},
	{"RDEC", 4, 31094},
	{"RDCO", 4, 31095},
	{"OTIV", 4, 31096},
	{"ITHY", 4, 31097},
	{"RYSC", 4, 31098},
	{"CHRYSLER", 8, 31099},
	{"YCLO", 4, 31100},
	{"ACKH", 4, 31101},
	{"EXTENDS", 7, 31102},
	{"FRAGRANCE", 9, 31103},
	{"MCDONALD", 8, 31104},
	{"REPLICA", 7, 31105},
	{"PLUMBING", 8, 31106},
	{"ILEH", 4, 31107},
	{"HATK", 4, 31108},
	{"ULDI", 4, 31109},
	{"DMAY", 4, 31110},
	{"ARSS", 4, 31111},
	{"DGEN", 4, 31112},
	{"EBUL", 4, 31113},
	{"CHAOS", 5, 31114},
	{"BRUSSELS", 8, 31115},
	{"AGEP", 4, 31116},
	{"NEIGHBORS", 9, 31117},
	{"MEPE", 4, 31118},
	{"RETC", 4, 31119},
	{"TRADES", 6, 31120},
	{"ORWE", 4, 31121},
	{"NTCH", 4, 31122},
	{"CKMA", 4, 31123},
	{"SUPERB", 6, 31124},
	{"CARVE", 5, 31125},
	{"EXPLORATION", 11, 31126},
	{"BUZZ", 4, 31127},
	{"TRANSPARENT", 11, 31128},
	{"SZY", 3, 31129},
	{"NUKE", 4, 31130},
	{"OLDW", 4, 31131},
	{"LAMP", 4, 31132},
	{"IRME", 4, 31133},
	{"ONSR", 4, 31134},
	{"RTOM", 4, 31135},
	{"NKER", 4, 31136},
	{"TRINITY", 7, 31137},
	{"ICOF", 4, 31138},
	{"TGRA", 4, 31139},
	{"CHARLESTON", 10, 31140},
	{"XJO", 3, 31141},
	{"ONLO", 4, 31142},
	{"NSTU", 4, 31143},
	{"NBUR", 4, 31144},
	{"HANDLED", 7, 31145},
	{"ATTRACTION", 10, 31146},
	{"LEGENDS", 7, 31147},
	{"EQUITY", 6, 31148},
	{"ONCR", 4, 31149},
	{"EIRN", 4, 31150},
	{"CHAMPIONS", 9, 31151},
	{"ONGH", 4, 31152},
	{"ENTITY", 6, 31153},
	{"YMAY", 4, 31154},
	{"ZZU", 3, 31155},
	{"UBK", 3, 31156},
	{"FLIP", 4, 31157},
	{"REGULATORY", 10, 31158},
	{"FLOORS", 6, 31159},
	{"SELECTIONS", 10, 31160},
	{"EORY", 4, 31161},
	{"PROJECTORS", 10, 31162},
	{"OADD", 4, 31163},
	{"ITYM", 4, 31164},
	{"CEFR", 4, 31165},
	{"ASGR", 4, 31166},
	{"INAPPROPRIATE", 13, 31167},
	{"LLOT", 4, 31168},
	{"AMID", 4, 31169},
	{"COMPARING", 9, 31170},
	{"SHANGHAI", 8, 31171},
	{"GHTR", 4, 31172},
	{"REALM", 5, 31173},
	{"SPEAKS", 6, 31174},
	{"BURTON", 6, 31175},
	{"PASTOR", 6, 31176},
	{"ARDH", 4, 31177},
	{"VOCATIONAL", 10, 31178},
	{"DAVIDSON", 8, 31179},
	{"NGBY", 4, 31180},
	{"COPIED", 6, 31181},
	{"ARHE", 4, 31182},
	{"SCOTIA", 6, 31183},
	{"SREQ", 4, 31184},
	{"FARMING", 7, 31185},
	{"GIBSON", 6, 31186},
	{"DIAGNOSE", 8, 31187},
	{"DERP", 4, 31188},
	{"ELFT", 4, 31189},
	{"IERA", 4, 31190},
	{"PHARMACIES", 10, 31191},
	{"TROY", 4, 31192},
	{"PARENTAL", 8, 31193},
	{"ORKC", 4, 31194},
	{"LYPA", 4, 31195},
	{"DNTH", 4, 31196},
	{"URYE", 4, 31197},
	{"XTJ", 3, 31198},
	{"EWSA", 4, 31199},
	{"ROLLER", 6, 31200},
	{"INTRODUCING", 11, 31201},
	{"BATCH", 5, 31202},
	{"IDENTICAL", 9, 31203},
	{"FPLA", 4, 31204},
	{"AHAL", 4, 31205},
	{"RESUME", 6, 31206},
	{"AYIS", 4, 31207},
	{"GRIN", 4, 31208},
	{"NLYP", 4, 31209},
	{"EEMA", 4, 31210},
	{"ENVELOPE", 8, 31211},
	{"NICOLE", 6, 31212},
	{"EISP", 4, 31213},
	{"LATINO", 6, 31214},
	{"GHANA", 5, 31215},
	{"EDGES", 5, 31216},
	{"BLEND", 5, 31217},
	{"MIXING", 6, 31218},
	{"HANDLES", 7, 31219},
	{"FEVE", 4, 31220},
	{"KEDF", 4, 31221},
	{"EGJ", 3, 31222},
	{"NSCR", 4, 31223},
	{"FITTED", 6, 31224},
	{"CLERK", 5, 31225},
	{"ALBUQUERQUE", 11, 31226},
	{"DISTINGUISHED", 13, 31227},
	{"ASTHMA", 6, 31228},
	{"PROJECTED", 9, 31229},
	{"DONOR", 5, 31230},
	{"ASSUMPTIONS", 11, 31231},
	{"SHAREHOLDERS", 12, 31232},
	{"GYM", 3, 31233},
	{"LSOD", 4, 31234},
	{"TWINS", 5, 31235},
	{"IMEB", 4, 31236},
	{"ARSL", 4, 31237},
	{"SUSPEND", 7, 31238},
	{"ENAP", 4, 31239},
	{"VERBAL", 6, 31240},
	{"DEDICATE", 8, 31241},
	{"ZOPE", 4, 31242},
	{"REGULATED", 9, 31243},
	{"CKWA", 4, 31244},
	{"NLYW", 4, 31245},
	{"AKEU", 4, 31246},
	{"TRIANGLE", 8, 31247},
	{"MBAT", 4, 31248},
	{"AMEND", 5, 31249},
	{"EKID", 4, 31250},
	{"FGHA", 4, 31251},
	{"JAZZ", 4, 31252},
	{"PROCESSING", 10, 31253},
	{"YLH", 3, 31254},
	{"HEIG", 4, 31255},
	{"ANTICIPATED", 11, 31256},
	{"EXPERTISE", 9, 31257},
	{"NHAL", 4, 31258},
	{"RTYA", 4, 31259},
	{"OLLS", 4, 31260},
	{"SUM", 3, 31261},
	{"EDGR", 4, 31262},
	{"SPECTRUM", 8, 31263},
	{"PURPLE", 6, 31264},
	{"ORIENTAL", 8, 31265},
	{"UALA", 4, 31266},
	{"YTOW", 4, 31267},
	{"OWIS", 4, 31268},
	{"ILDE", 4, 31269},
	{"JUDICIAL", 8, 31270},
	{"MEBU", 4, 31271},
	{"WINDSOR", 7, 31272},
	{"MILD", 4, 31273},
	{"PRECISE", 7, 31274},
	{"ZAMBIA", 6, 31275},
	{"FTED", 4, 31276},
	{"COMPLETING", 10, 31277},
	{"GMBH", 4, 31278},
	{"DDEV", 4, 31279},
	{"IONU", 4, 31280},
	{"YGEN", 4, 31281},
	{"BUF", 3, 31282},
	{"YLOR", 4, 31283},
	{"CANDLE", 6, 31284},
	{"EZJ", 3, 31285},
	{"LLOU", 4, 31286},
	{"MBUT", 4, 31287},
	{"DIMP", 4, 31288},
	{"MHAS", 4, 31289},
	{"HEYG", 4, 31290},
	{"HYDROGEN", 8, 31291},
	{"NKIT", 4, 31292},
	{"WEBSHOTS", 8, 31293},
	{"ASTB", 4, 31294},
	{"LASER", 5, 31295},
	{"EGIA", 4, 31296},
	{"ISVI", 4, 31297},
	{"ALOC", 4, 31298},
	{"GNJ", 3, 31299},
	{"SPRINT", 6, 31300},
	{"NGSF", 4, 31301},
	{"LKNO", 4, 31302},
	{"DIPLOMATIC", 10, 31303},
	{"NMAD", 4, 31304},
	{"ALSS", 4, 31305},
	{"SHOC", 4, 31306},
	{"OXYGEN", 6, 31307},
	{"BUSINESSMAN", 11, 31308},
	{"YUND", 4, 31309},
	{"EAUS", 4, 31310},
	{"ASYO", 4, 31311},
	{"FIRMLY", 6, 31312},
	{"CHICK", 5, 31313},
	{"DMOV", 4, 31314},
	{"YINF", 4, 31315},
	{"SUSPICION", 9, 31316},
	{"OTWO", 4, 31317},
	{"EOFN", 4, 31318},
	{"ONTB", 4, 31319},
	{"REPORTING", 9, 31320},
	{"SIMS", 4, 31321},
	{"PEEL", 4, 31322},
	{"OADA", 4, 31323},
	{"BUTR", 4, 31324},
	{"DYNAMIC", 7, 31325},
	{"ORAI", 4, 31326},
	{"OGOT", 4, 31327},
	{"IRFO", 4, 31328},
	{"COPYRIGHTED", 11, 31329},
	{"YCLI", 4, 31330},
	{"DETERMINATION", 13, 31331},
	{"ACHM", 4, 31332},
	{"INPUTS", 6, 31333},
	{"IMNO", 4, 31334},
	{"WARRANTIES", 10, 31335},
	{"LLTA", 4, 31336},
	{"GENOME", 6, 31337},
	{"ESCORTS", 7, 31338},
	{"ENDORSE", 7, 31339},
	{"THONG", 5, 31340},
	{"ERMU", 4, 31341},
	{"ABSTRACT", 8, 31342},
	{"PAPERBACKS", 10, 31343},
	{"TSTU", 4, 31344},
	{"COACHES", 7, 31345},
	{"VESSELS", 7, 31346},
	{"HARBOUR", 7, 31347},
	{"WALKS", 5, 31348},
	{"SUCKS", 5, 31349},
	{"LSOL", 4, 31350},
	{"KEYBOARDS", 9, 31351},
	{"AYMA", 4, 31352},
	{"DGED", 4, 31353},
	{"TONM", 4, 31354},
	{"ROPI", 4, 31355},
	{"IANM", 4, 31356},
	{"SAGE", 4, 31357},
	{"TFEE", 4, 31358},
	{"KNIVES", 6, 31359},
	{"TBRI", 4, 31360},
	{"FCHI", 4, 31361},
	{"VANISH", 6, 31362},
	{"UPAT", 4, 31363},
	{"SVIL", 4, 31364},
	{"CONSCIOUS", 9, 31365},
	{"MTHI", 4, 31366},
	{"BATH", 4, 31367},
	{"ALTOGETHER", 10, 31368},
	{"NTWE", 4, 31369},
	{"HONORS", 6, 31370},
	{"INDIE", 5, 31371},
	{"REFLECTED", 9, 31372},
	{"ASWH", 4, 31373},
	{"UNIFIED", 7, 31374},
	{"MINIMIZE", 8, 31375},
	{"BONES", 5, 31376},
	{"NOMINEE", 7, 31377},
	{"BREED", 5, 31378},
	{"MTOA", 4, 31379},
	{"DETECTOR", 8, 31380},
	{"IGNORED", 7, 31381},
	{"POLAR", 5, 31382},
	{"ATLO", 4, 31383},
	{"FALLEN", 6, 31384},
	{"DMAD", 4, 31385},
	{"LGAM", 4, 31386},
	{"ORKF", 4, 31387},
	{"NEME", 4, 31388},
	{"RESPIRATORY", 11, 31389},
	{"ALIEN", 5, 31390},
	{"HADH", 4, 31391},
	{"GDOM", 4, 31392},
	{"NOTIFICATIONS", 13, 31393},
	{"MSGID", 5, 31394},
	{"TFUL", 4, 31395},
	{"HOWC", 4, 31396},
	{"NMAT", 4, 31397},
	{"PIZZA", 5, 31398},
	{"UNLE", 4, 31399},
	{"SILK", 4, 31400},
	{"INVOICE", 7, 31401},
	{"RECIPIENT", 9, 31402},
	{"IALM", 4, 31403},
	{"EVALUATING", 10, 31404},
	{"ARGI", 4, 31405},
	{"HANP", 4, 31406},
	{"PILLOW", 6, 31407},
	{"ASIG", 4, 31408},
	{"LSCH", 4, 31409},
	{"USTM", 4, 31410},
	{"FZH", 3, 31411},
	{"BANKING", 7, 31412},
	{"STARTING", 8, 31413},
	{"SUBCOMMITTEE", 12, 31414},
	{"MAGNITUDE", 9, 31415},
	{"SUSE", 4, 31416},
	{"MATERNITY", 9, 31417},
	{"BACKED", 6, 31418},
	{"WWHA", 4, 31419},
	{"DEHI", 4, 31420},
	{"ENYE", 4, 31421},
	{"ALFRED", 6, 31422},
	{"ZYR", 3, 31423},
	{"HEOB", 4, 31424},
	{"CAREY", 5, 31425},
	{"DNEV", 4, 31426},
	{"OACT", 4, 31427},
	{"ICHR", 4, 31428},
	{"MOTELS", 6, 31429},
	{"FORMING", 7, 31430},
	{"ECOO", 4, 31431},
	{"LYHI", 4, 31432},
	{"EMBASSY", 7, 31433},
	{"LLPL", 4, 31434},
	{"UZT", 3, 31435},
	{"JOURNALISTS", 11, 31436},
	{"USST", 4, 31437},
	{"INVENTORY", 9, 31438},
	{"DANNY", 5, 31439},
	{"REBECCA", 7, 31440},
	{"ARDP", 4, 31441},
	{"UEIN", 4, 31442},
	{"REPAIR", 6, 31443},
	{"CIVIC", 5, 31444},
	{"PROCEEDS", 8, 31445},
	{"RYLI", 4, 31446},
	{"PHOTOGRAPHY", 11, 31447},
	{"INDIRECT", 8, 31448},
	{"DYNAMICS", 8, 31449},
	{"AMONGST", 7, 31450},
	{"WOOL", 4, 31451},
	{"FOUNDATIONS", 11, 31452},
	{"ENPA", 4, 31453},
	{"MSGSTR", 6, 31454},
	{"RRYI", 4, 31455},
	{"VOLLEYBALL", 10, 31456},
	{"LPRI", 4, 31457},
	{"ITDI", 4, 31458},
	{"CKWI", 4, 31459},
	{"ADIPEX", 6, 31460},
	{"STUMBLE", 7, 31461},
	{"RCIT", 4, 31462},
	{"KCY", 3, 31463},
	{"PROMISING", 9, 31464},
	{"HOWH", 4, 31465},
	{"DIABETES", 8, 31466},
	{"NECESSITY", 9, 31467},
	{"FULT", 4, 31468},
	{"RSTD", 4, 31469},
	{"PURSUIT", 7, 31470},
	{"AKEM", 4, 31471},
	{"POSTER", 6, 31472},
	{"SHARED", 6, 31473},
	{"RDSH", 4, 31474},
	{"EATING", 6, 31475},
	{"TOOLBOX", 7, 31476},
	{"PAYM", 4, 31477},
	{"SERVANT", 7, 31478},
	{"DSWH", 4, 31479},
	{"YISS", 4, 31480},
	{"TRUL", 4, 31481},
	{"ILAT", 4, 31482},
	{"MARINA", 6, 31483},
	{"LIABILITIES", 11, 31484},
	{"PRIZES", 6, 31485},
	{"UREH", 4, 31486},
	{"DIVINE", 6, 31487},
	{"BOSNIA", 6, 31488},
	{"STATUE", 6, 31489},
	{"UROF", 4, 31490},
	{"ELYF", 4, 31491},
	{"EROB", 4, 31492},
	{"BROWSERS", 8, 31493},
	{"AILO", 4, 31494},
	{"DECREASED", 9, 31495},
	{"NTUN", 4, 31496},
	{"PATIO", 5, 31497},
	{"LGOV", 4, 31498},
	{"SURFING", 7, 31499},
	{"OWOU", 4, 31500},
	{"ENROLL", 6, 31501},
	{"RELIABILITY", 11, 31502},
	{"NDJA", 4, 31503},
	{"LLOYD", 5, 31504},
	{"TCEN", 4, 31505},
	{"SPLI", 4, 31506},
	{"ANAB", 4, 31507},
	{"DESCRIBING", 10, 31508},
	{"HTWO", 4, 31509},
	{"OPTICS", 6, 31510},
	{"TLEI", 4, 31511},
	{"ONMI", 4, 31512},
	{"UNDERTAKE", 9, 31513},
	{"ACKG", 4, 31514},
	{"EYED", 4, 31515},
	{"TTOU", 4, 31516},
	{"QUOTATIONS", 10, 31517},
	{"OBOT", 4, 31518},
	{"OUTPUT", 6, 31519},
	{"RKZ", 3, 31520},
	{"KEUP", 4, 31521},
	{"DESTINATION", 11, 31522},
	{"TWOA", 4, 31523},
	{"BRIGHTON", 8, 31524},
	{"BEANS", 5, 31525},
	{"BOOKMARKS", 9, 31526},
	{"ELLIS", 5, 31527},
	{"HAPPINESS", 9, 31528},
	{"DISABLE", 7, 31529},
	{"BSEQ", 4, 31530},
	{"JKO", 3, 31531},
	{"FMIL", 4, 31532},
	{"LEONARD", 7, 31533},
	{"AFGH", 4, 31534},
	{"YFIR", 4, 31535},
	{"TEENAGE", 7, 31536},
	{"LENDING", 7, 31537},
	{"SWORD", 5, 31538},
	{"LYHO", 4, 31539},
	{"LWAR", 4, 31540},
	{"NKAN", 4, 31541},
	{"OOPS", 4, 31542},
	{"RFRE", 4, 31543},
	{"RACISM", 6, 31544},
	{"NIPPLE", 6, 31545},
	{"AILU", 4, 31546},
	{"LDGO", 4, 31547},
	{"NDOP", 4, 31548},
	{"ONTU", 4, 31549},
	{"RYPR", 4, 31550},
	{"OLSA", 4, 31551},
	{"SEARCHED", 8, 31552},
	{"TCHU", 4, 31553},
	{"EDOI", 4, 31554},
	{"RIVERSIDE", 9, 31555},
	{"BATHROOMS", 9, 31556},
	{"PLAINS", 6, 31557},
	{"SLAP", 4, 31558},
	{"SKU", 3, 31559},
	{"INSTRUCTIONAL", 13, 31560},
	{"IFUL", 4, 31561},
	{"TENDER", 6, 31562},
	{"RAYMOND", 7, 31563},
	{"ANWO", 4, 31564},
	{"XXA", 3, 31565},
	{"INSIGHTS", 8, 31566},
	{"PARADE", 6, 31567},
	{"ABILITIES", 9, 31568},
	{"NFRE", 4, 31569},
	{"INITIATED", 9, 31570},
	{"WOUN", 4, 31571},
	{"DSMA", 4, 31572},
	{"DEPARTURE", 9, 31573},
	{"SULLIVAN", 8, 31574},
	{"PRODUCTIVE", 10, 31575},
	{"EGES", 4, 31576},
	{"INPUT", 5, 31577},
	{"MIDWEST", 7, 31578},
	{"TKIN", 4, 31579},
	{"EGED", 4, 31580},
	{"KARAOKE", 7, 31581},
	{"OCKO", 4, 31582},
	{"GRAVITY", 7, 31583},
	{"QVI", 3, 31584},
	{"LYBY", 4, 31585},
	{"NGSY", 4, 31586},
	{"RUME", 4, 31587},
	{"UISE", 4, 31588},
	{"TRIBAL", 6, 31589},
	{"EYSH", 4, 31590},
	{"LANCASTER", 9, 31591},
	{"SUSPENDED", 9, 31592},
	{"LYIT", 4, 31593},
	{"FOOL", 4, 31594},
	{"HEREBY", 6, 31595},
	{"JULIA", 5, 31596},
	{"CONTAINERS", 10, 31597},
	{"OCLA", 4, 31598},
	{"ATTITUDES", 9, 31599},
	{"KARL", 4, 31600},
	{"HOPEFULLY", 9, 31601},
	{"BERRY", 5, 31602},
	{"EHOR", 4, 31603},
	{"XYF", 3, 31604},
	{"THCH", 4, 31605},
	{"STEX", 4, 31606},
	{"YEDB", 4, 31607},
	{"HERY", 4, 31608},
	{"BERMUDA", 7, 31609},
	{"RMSA", 4, 31610},
	{"ANGEL", 5, 31611},
	{"UGHM", 4, 31612},
	{"STADIUM", 7, 31613},
	{"RALH", 4, 31614},
	{"OWCO", 4, 31615},
	{"COLLECTOR", 9, 31616},
	{"AMANDA", 6, 31617},
	{"SOCIOLOGY", 9, 31618},
	{"MOBILES", 7, 31619},
	{"OANY", 4, 31620},
	{"ELEGANT", 7, 31621},
	{"RYMA", 4, 31622},
	{"SCREENSHOT", 10, 31623},
	{"EXHIBITIONS", 11, 31624},
	{"UNDB", 4, 31625},
	{"KELKOO", 6, 31626},
	{"STEEP", 5, 31627},
	{"O'CLOCK", 7, 31628},
	{"ADOU", 4, 31629},
	{"YPOL", 4, 31630},
	{"RETRIEVED", 9, 31631},
	{"EXHIBITS", 8, 31632},
	{"OLOS", 4, 31633},
	{"CONSORTIUM", 10, 31634},
	{"DIES", 4, 31635},
	{"UWAN", 4, 31636},
	{"TERRACE", 7, 31637},
	{"SHARPLY", 7, 31638},
	{"READILY", 7, 31639},
	{"LDME", 4, 31640},
	{"REPLIED", 7, 31641},
	{"PFRO", 4, 31642},
	{"TMAD", 4, 31643},
	{"SEAFOOD", 7, 31644},
	{"NOVELS", 6, 31645},
	{"RRP", 3, 31646},
	{"RECIPIENTS", 10, 31647},
	{"KEOF", 4, 31648},
	{"EEUR", 4, 31649},
	{"DELICIOUS", 9, 31650},
	{"TRADITIONS", 10, 31651},
	{"HQUA", 4, 31652},
	{"PUNISH", 6, 31653},
	{"SUFFERING", 9, 31654},
	{"OOKP", 4, 31655},
	{"DECENT", 6, 31656},
	{"BID", 3, 31657},
	{"TOUCHDOWN", 9, 31658},
	{"ORSS", 4, 31659},
	{"DOSO", 4, 31660},
	{"HARDWARE", 8, 31661},
	{"FINITE", 6, 31662},
	{"KIDNEY", 6, 31663},
	{"GOFA", 4, 31664},
	{"PERIODICALLY", 12, 31665},
	{"FIXES", 5, 31666},
	{"SENDS", 5, 31667},
	{"ELFO", 4, 31668},
	{"DURABLE", 7, 31669},
	{"RULING", 6, 31670},
	{"FCZ", 3, 31671},
	{"DBER", 4, 31672},
	{"GINC", 4, 31673},
	{"CASUAL", 6, 31674},
	{"MAZDA", 5, 31675},
	{"ALLIED", 6, 31676},
	{"SRAT", 4, 31677},
	{"RSID", 4, 31678},
	{"FULL-TIME", 9, 31679},
	{"IMPORT", 6, 31680},
	{"THROWS", 6, 31681},
	{"OMCO", 4, 31682},
	{"MOISTURE", 8, 31683},
	{"ACCURACY", 8, 31684},
	{"HUNGARIAN", 9, 31685},
	{"ECEL", 4, 31686},
	{"GELY", 4, 31687},
	{"ROSTER", 6, 31688},
	{"SFUN", 4, 31689},
	{"ALGR", 4, 31690},
	{"IESM", 4, 31691},
	{"ICHP", 4, 31692},
	{"TOILET", 6, 31693},
	{"RLOS", 4, 31694},
	{"SWAR", 4, 31695},
	{"BOLD", 4, 31696},
	{"HESK", 4, 31697},
	{"UTPE", 4, 31698},
	{"USRE", 4, 31699},
	{"REFERRING", 9, 31700},
	{"TBRO", 4, 31701},
	{"SYMANTEC", 8, 31702},
	{"IKED", 4, 31703},
	{"EONC", 4, 31704},
	{"SPENCER", 7, 31705},
	{"GARBAGE", 7, 31706},
	{"TOVI", 4, 31707},
	{"WICHITA", 7, 31708},
	{"CANCEL", 6, 31709},
	{"DEADLINE", 8, 31710},
	{"NASDAQ", 6, 31711},
	{"URUGUAY", 7, 31712},
	{"DAWN", 4, 31713},
	{"BROKER", 6, 31714},
	{"ANNUALLY", 8, 31715},
	{"WHALE", 5, 31716},
	{"ARFO", 4, 31717},
	{"TIMER", 5, 31718},
	{"ADEP", 4, 31719},
	{"EYFO", 4, 31720},
	{"TABLETS", 7, 31721},
	{"YSMA", 4, 31722},
	{"TYPR", 4, 31723},
	{"JAW", 3, 31724},
	{"HEUP", 4, 31725},
	{"ISOLATE", 7, 31726},
	{"TUNING", 6, 31727},
	{"GOTTEN", 6, 31728},
	{"YTAK", 4, 31729},
	{"NDBL", 4, 31730},
	{"LBEI", 4, 31731},
	{"EDUCATORS", 9, 31732},
	{"NMUS", 4, 31733},
	{"TYLER", 5, 31734},
	{"OSTM", 4, 31735},
	{"PRACTICALLY", 11, 31736},
	{"ASSEMBLY", 8, 31737},
	{"FUTURES", 7, 31738},
	{"URTA", 4, 31739},
	{"REAR", 4, 31740},
	{"DGAM", 4, 31741},
	{"VERSE", 5, 31742},
	{"FYIN", 4, 31743},
	{"SYJ", 3, 31744},
	{"LYPE", 4, 31745},
	{"HIGHS", 5, 31746},
	{"GENEROUS", 8, 31747},
	{"HUMANITIES", 10, 31748},
	{"INDEPENDENTLY", 13, 31749},
	{"WANTING", 7, 31750},
	{"HADF", 4, 31751},
	{"EPLE", 4, 31752},
	{"SESF", 4, 31753},
	{"RBAR", 4, 31754},
	{"UCLE", 4, 31755},
	{"LAUNCHES", 8, 31756},
	{"RECEPTION", 9, 31757},
	{"PERFORMER", 9, 31758},
	{"PROHIBIT", 8, 31759},
	{"DESCEND", 7, 31760},
	{"IPAQ", 4, 31761},
	{"ALIGNMENT", 9, 31762},
	{"MASTURBATING", 12, 31763},
	{"HENDERSON", 9, 31764},
	{"GGED", 4, 31765},
	{"BRITANNICA", 10, 31766},
	{"COMM", 4, 31767},
	{"FYY", 3, 31768},
	{"AGLE", 4, 31769},
	{"ELLEN", 5, 31770},
	{"COMPETITORS", 11, 31771},
	{"IFTE", 4, 31772},
	{"COLLABORATION", 13, 31773},
	{"DAGR", 4, 31774},
	{"AYCO", 4, 31775},
	{"ANOU", 4, 31776},
	{"REVOLUTIONARY", 13, 31777},
	{"FAINT", 5, 31778},
	{"IALB", 4, 31779},
	{"DMED", 4, 31780},
	{"CHWO", 4, 31781},
	{"NDLY", 4, 31782},
	{"RCEL", 4, 31783},
	{"TOWERS", 6, 31784},
	{"HEDF", 4, 31785},
	{"COASTAL", 7, 31786},
	{"RNOO", 4, 31787},
	{"RTOW", 4, 31788},
	{"ULQ", 3, 31789},
	{"PAYI", 4, 31790},
	{"INTENT", 6, 31791},
	{"SCAN", 4, 31792},
	{"HTIM", 4, 31793},
	{"RACKS", 5, 31794},
	{"LACE", 4, 31795},
	{"NKEE", 4, 31796},
	{"ETEM", 4, 31797},
	{"EROY", 4, 31798},
	{"RAGE", 4, 31799},
	{"OLDB", 4, 31800},
	{"VISIBILITY", 10, 31801},
	{"LATITUDE", 8, 31802},
	{"DIMINISH", 8, 31803},
	{"EHUM", 4, 31804},
	{"FYG", 3, 31805},
	{"DEPOSITS", 8, 31806},
	{"ENLY", 4, 31807},
	{"AFOU", 4, 31808},
	{"BEVERLY", 7, 31809},
	{"SCAU", 4, 31810},
	{"MISTRESS", 8, 31811},
	{"TRUSTEES", 8, 31812},
	{"ONBR", 4, 31813},
	{"MPTE", 4, 31814},
	{"LONELY", 6, 31815},
	{"PRO", 3, 31816},
	{"YREG", 4, 31817},
	{"DUNCAN", 6, 31818},
	{"ORTG", 4, 31819},
	{"SCARY", 5, 31820},
	{"EEPA", 4, 31821},
	{"RGIA", 4, 31822},
	{"REPRINTS", 8, 31823},
	{"OSOP", 4, 31824},
	{"HART", 4, 31825},
	{"IGZ", 3, 31826},
	{"BERNARD", 7, 31827},
	{"RESOLUTIONS", 11, 31828},
	{"MENT", 4, 31829},
	{"ACCESSING", 9, 31830},
	{"REAG", 4, 31831},
	{"TUBES", 5, 31832},
	{"SILLY", 5, 31833},
	{"LYFI", 4, 31834},
	{"LYAB", 4, 31835},
	{"ATTEMPTED", 9, 31836},
	{"OFFERING", 8, 31837},
	{"ANEC", 4, 31838},
	{"EDVE", 4, 31839},
	{"ERVO", 4, 31840},
	{"STBU", 4, 31841},
	{"NSBU", 4, 31842},
	{"URTS", 4, 31843},
	{"EFEL", 4, 31844},
	{"ERDR", 4, 31845},
	{"TUCK", 4, 31846},
	{"COL", 3, 31847},
	{"MIDLANDS", 8, 31848},
	{"FLOYD", 5, 31849},
	{"RONALD", 6, 31850},
	{"ANALYSTS", 8, 31851},
	{"YFRI", 4, 31852},
	{"XVO", 3, 31853},
	{"EROP", 4, 31854},
	{"QUEUE", 5, 31855},
	{"ORIZ", 4, 31856},
	{"RELUCTANT", 9, 31857},
	{"DONM", 4, 31858},
	{"OYV", 3, 31859},
	{"STATUTE", 7, 31860},
	{"EDMU", 4, 31861},
	{"TRANCE", 6, 31862},
	{"LOCALE", 6, 31863},
	{"ICKT", 4, 31864},
	{"RMOT", 4, 31865},
	{"NICHOLAS", 8, 31866},
	{"POPULARITY", 10, 31867},
	{"AYAF", 4, 31868},
	{"BIOL", 4, 31869},
	{"TISW", 4, 31870},
	{"QUANTITY", 8, 31871},
	{"YSUP", 4, 31872},
	{"NDFL", 4, 31873},
	{"YTOH", 4, 31874},
	{"YMON", 4, 31875},
	{"NALH", 4, 31876},
	{"HLAN", 4, 31877},
	{"AUTOMOBILE", 10, 31878},
	{"BUNDLE", 6, 31879},
	{"RKTH", 4, 31880},
	{"HAMMER", 6, 31881},
	{"MATHEMATICS", 11, 31882},
	{"WITNESSES", 9, 31883},
	{"UDDE", 4, 31884},
	{"ROWS", 4, 31885},
	{"ADMINISTERED", 12, 31886},
	{"YUJ", 3, 31887},
	{"YINV", 4, 31888},
	{"AUTOMATICALLY", 13, 31889},
	{"CART", 4, 31890},
	{"TISU", 4, 31891},
	{"KFRO", 4, 31892},
	{"ORRU", 4, 31893},
	{"SKINS", 5, 31894},
	{"MAILED", 6, 31895},
	{"IRPR", 4, 31896},
	{"FUJITSU", 7, 31897},
	{"SPELLING", 8, 31898},
	{"CONFESS", 7, 31899},
	{"ARCTIC", 6, 31900},
	{"EXAMS", 5, 31901},
	{"REAW", 4, 31902},
	{"REWARDS", 7, 31903},
	{"WYEA", 4, 31904},
	{"FREDERICK", 9, 31905},
	{"ELDER", 5, 31906},
	{"RRYA", 4, 31907},
	{"OBTA", 4, 31908},
	{"YBEL", 4, 31909},
	{"MEDICAID", 8, 31910},
	{"LSWE", 4, 31911},
	{"OUTSTANDING", 11, 31912},
	{"TREO", 4, 31913},
	{"INFRARED", 8, 31914},
	{"SOVI", 4, 31915},
	{"TESB", 4, 31916},
	{"BOW", 3, 31917},
	{"GODS", 4, 31918},
	{"CANL", 4, 31919},
	{"NZR", 3, 31920},
	{"WELSH", 5, 31921},
	{"WTHI", 4, 31922},
	{"UTFI", 4, 31923},
	{"IDEOLOGICAL", 11, 31924},
	{"QUARTERS", 8, 31925},
	{"BEON", 4, 31926},
	{"STOLEN", 6, 31927},
	{"HTRA", 4, 31928},
	{"YGN", 3, 31929},
	{"SUBLIMEDIRECTORY", 16, 31930},
	{"HIDDEN", 6, 31931},
	{"ANMO", 4, 31932},
	{"REALISTIC", 9, 31933},
	{"SCUL", 4, 31934},
	{"SOONEST", 7, 31935},
	{"BARN", 4, 31936},
	{"GTOO", 4, 31937},
	{"HAITI", 5, 31938},
	{"DISTURBED", 9, 31939},
	{"DETERMINES", 10, 31940},
	{"AXV", 3, 31941},
	{"AYWA", 4, 31942},
	{"TLOS", 4, 31943},
	{"POLY", 4, 31944},
	{"IMBE", 4, 31945},
	{"SHORTAGE", 8, 31946},
	{"LIABILITY", 9, 31947},
	{"EARS", 4, 31948},
	{"NDPI", 4, 31949},
	{"ENLA", 4, 31950},
	{"OYZ", 3, 31951},
	{"DOD", 3, 31952},
	{"OVERSEE", 7, 31953},
	{"NAUS", 4, 31954},
	{"COURTROOM", 9, 31955},
	{"NDYE", 4, 31956},
	{"NATURALS", 8, 31957},
	{"BEMO", 4, 31958},
	{"OFIG", 4, 31959},
	{"ADWA", 4, 31960},
	{"LENDERS", 7, 31961},
	{"YHIG", 4, 31962},
	{"PHARMACOLOGY", 12, 31963},
	{"FITTING", 7, 31964},
	{"FIXTURES", 8, 31965},
	{"BLOGGERS", 8, 31966},
	{"COOPERATE", 9, 31967},
	{"XTER", 4, 31968},
	{"AGREES", 6, 31969},
	{"PASSENGERS", 10, 31970},
	{"VACCINE", 7, 31971},
	{"QUANTITIES", 10, 31972},
	{"ONOC", 4, 31973},
	{"RANCH", 5, 31974},
	{"PETERSBURG", 10, 31975},
	{"OFBI", 4, 31976},
	{"RTOC", 4, 31977},
	{"TINP", 4, 31978},
	{"RKON", 4, 31979},
	{"POWERPOINT", 10, 31980},
	{"SYMBOLIC", 8, 31981},
	{"UCHS", 4, 31982},
	{"ASSOCIATED", 10, 31983},
	{"EROW", 4, 31984},
	{"STDA", 4, 31985},
	{"STFE", 4, 31986},
	{"MYSE", 4, 31987},
	{"CONS", 4, 31988},
	{"SURPLUS", 7, 31989},
	{"ENAD", 4, 31990},
	{"SONIC", 5, 31991},
	{"ERKI", 4, 31992},
	{"NTDI", 4, 31993},
	{"AIDM", 4, 31994},
	{"MPTO", 4, 31995},
	{"OBITUARIES", 10, 31996},
	{"CIRCUIT", 7, 31997},
	{"PEDB", 4, 31998},
	{"YPRI", 4, 31999},
	{"CHEERS", 6, 32000},
	{"TAXI", 4, 32001},
	{"NXR", 3, 32002},
	{"SUBSEQUENTLY", 12, 32003},
	{"DIAMOND", 7, 32004},
	{"CREDIBILITY", 11, 32005},
	{"TLYR", 4, 32006},
	{"BELARUS", 7, 32007},
	{"ZONING", 6, 32008},
	{"PROVIDENCE", 10, 32009},
	{"AYSC", 4, 32010},
	{"FUNCTIONAL", 10, 32011},
	{"IROF", 4, 32012},
	{"BACKGROUNDS", 11, 32013},
	{"TREASURER", 9, 32014},
	{"GUITARS", 7, 32015},
	{"AWIL", 4, 32016},
	{"ANKL", 4, 32017},
	{"AELI", 4, 32018},
	{"ARTIFICIAL", 10, 32019},
	{"CONTINENT", 9, 32020},
	{"DTON", 4, 32021},
	{"FLOORING", 8, 32022},
	{"NTPL", 4, 32023},
	{"LIGHTWEIGHT", 11, 32024},
	{"ETHIOPIA", 8, 32025},
	{"ITEW", 4, 32026},
	{"SELF-ESTEEM", 11, 32027},
	{"HOMELAND", 8, 32028},
	{"BTAI", 4, 32029},
	{"DISAPPOINTED", 12, 32030},
	{"MIGHTY", 6, 32031},
	{"ATHLETES", 8, 32032},
	{"ROCKET", 6, 32033},
	{"DBAN", 4, 32034},
	{"TRANSCRIPTION", 13, 32035},
	{"IMPROVED", 8, 32036},
	{"OSTW", 4, 32037},
	{"TIFU", 4, 32038},
	{"OBEF", 4, 32039},
	{"VEDW", 4, 32040},
	{"MUSL", 4, 32041},
	{"ELYP", 4, 32042},
	{"INMATE", 6, 32043},
	{"WOLF", 4, 32044},
	{"HOLMES", 6, 32045},
	{"COMPLICATIONS", 13, 32046},
	{"PRECIOUS", 8, 32047},
	{"SCHOLARS", 8, 32048},
	{"DPI", 3, 32049},
	{"SCRIPTING", 9, 32050},
	{"REMEMBERED", 10, 32051},
	{"ROFM", 4, 32052},
	{"OOKF", 4, 32053},
	{"THDR", 4, 32054},
	{"TRAILER", 7, 32055},
	{"DDRI", 4, 32056},
	{"CHESTER", 7, 32057},
	{"INOV", 4, 32058},
	{"ESSR", 4, 32059},
	{"TEDG", 4, 32060},
	{"SNAPSHOT", 8, 32061},
	{"UYV", 3, 32062},
	{"CARING", 6, 32063},
	{"LOC", 3, 32064},
	{"WORN", 4, 32065},
	{"SYNTHETIC", 9, 32066},
	{"AYWE", 4, 32067},
	{"MHER", 4, 32068},
	{"ETCO", 4, 32069},
	{"SHAW", 4, 32070},
	{"SEGMENTS", 8, 32071},
	{"KESM", 4, 32072},
	{"ROMANCE", 7, 32073},
	{"LTIE", 4, 32074},
	{"RKIS", 4, 32075},
	{"DILEMMA", 7, 32076},
	{"TESTAMENT", 9, 32077},
	{"EXPO", 4, 32078},
	{"TIDE", 4, 32079},
	{"OWCA", 4, 32080},
	{"STIFF", 5, 32081},
	{"XOB", 3, 32082},
	{"SPECIFICS", 9, 32083},
	{"ITUNES", 6, 32084},
	{"LATELY", 6, 32085},
	{"GASOLINE", 8, 32086},
	{"OWAL", 4, 32087},
	{"RIDICULOUS", 10, 32088},
	{"LLHO", 4, 32089},
	{"OWMU", 4, 32090},
	{"PYV", 3, 32091},
	{"MATE", 4, 32092},
	{"NESP", 4, 32093},
	{"DUTCH", 5, 32094},
	{"BANKRUPTCY", 10, 32095},
	{"RBUS", 4, 32096},
	{"NLYF", 4, 32097},
	{"YGRO", 4, 32098},
	{"LYAP", 4, 32099},
	{"TOFG", 4, 32100},
	{"BURIED", 6, 32101},
	{"EMEE", 4, 32102},
	{"WASJ", 4, 32103},
	{"PLIT", 4, 32104},
	{"NEWBIE", 6, 32105},
	{"XHIB", 4, 32106},
	{"OLDC", 4, 32107},
	{"SIFI", 4, 32108},
	{"OFJU", 4, 32109},
	{"DARWIN", 6, 32110},
	{"RANKS", 5, 32111},
	{"MONUMENT", 8, 32112},
	{"TMOV", 4, 32113},
	{"ITYR", 4, 32114},
	{"GENERATIONS", 11, 32115},
	{"RACK", 4, 32116},
	{"RDWI", 4, 32117},
	{"TOURNAMENTS", 11, 32118},
	{"EJUD", 4, 32119},
	{"IFWE", 4, 32120},
	{"BRADLEY", 7, 32121},
	{"DVEN", 4, 32122},
	{"TOXIC", 5, 32123},
	{"NBEL", 4, 32124},
	{"GATHERING", 9, 32125},
	{"COOPERATIVE", 11, 32126},
	{"EMUC", 4, 32127},
	{"PRACTITIONER", 12, 32128},
	{"TQUA", 4, 32129},
	{"ANATOMY", 7, 32130},
	{"EBOY", 4, 32131},
	{"NRSQ", 4, 32132},
	{"ULDF", 4, 32133},
	{"BALI", 4, 32134},
	{"JUDY", 4, 32135},
	{"SPONSORSHIP", 11, 32136},
	{"DAPR", 4, 32137},
	{"EADW", 4, 32138},
	{"BURNING", 7, 32139},
	{"DRAWER", 6, 32140},
	{"RMOU", 4, 32141},
	{"ASAV", 4, 32142},
	{"HEADPHONES", 10, 32143},
	{"ARYB", 4, 32144},
	{"TEPH", 4, 32145},
	{"DONH", 4, 32146},
	{"AUNT", 4, 32147},
	{"GUPT", 4, 32148},
	{"TRIO", 4, 32149},
	{"PROCEEDING", 10, 32150},
	{"CUBE", 4, 32151},
	{"IRWA", 4, 32152},
	{"SEAL", 4, 32153},
	{"CLIP", 4, 32154},
	{"SENTIMENT", 9, 32155},
	{"ALLEGED", 7, 32156},
	{"CARPET", 6, 32157},
	{"DEFECTS", 7, 32158},
	{"ILYS", 4, 32159},
	{"NSAB", 4, 32160},
	{"VOLKSWAGEN", 10, 32161},
	{"BREAKDOWN", 9, 32162},
	{"MILTON", 6, 32163},
	{"RECONSTRUCTION", 14, 32164},
	{"SUBSIDIARY", 10, 32165},
	{"STRENGTHS", 9, 32166},
	{"NTPO", 4, 32167},
	{"PRODUCTIVITY", 12, 32168},
	{"CLARITY", 7, 32169},
	{"NGCR", 4, 32170},
	{"RUGS", 4, 32171},
	{"OGUE", 4, 32172},
	{"YSTI", 4, 32173},
	{"UALT", 4, 32174},
	{"LTTO", 4, 32175},
	{"YHEL", 4, 32176},
	{"SANDRA", 6, 32177},
	{"ENLE", 4, 32178},
	{"NONC", 4, 32179},
	{"ADELAIDE", 8, 32180},
	{"UCKY", 4, 32181},
	{"TREASURE", 8, 32182},
	{"RYWE", 4, 32183},
	{"FTWO", 4, 32184},
	{"THDI", 4, 32185},
	{"KESI", 4, 32186},
	{"AESTHETIC", 9, 32187},
	{"FURNISHED", 9, 32188},
	{"RCHT", 4, 32189},
	{"MONACO", 6, 32190},
	{"SETTLED", 7, 32191},
	{"TACKLE", 6, 32192},
	{"FOLDING", 7, 32193},
	{"EMIRATES", 8, 32194},
	{"TIGHTLY", 7, 32195},
	{"GREEK", 5, 32196},
	{"RHOW", 4, 32197},
	{"EXTENDED", 8, 32198},
	{"TERRORISTS", 10, 32199},
	{"AIRFARE", 7, 32200},
	{"ALPL", 4, 32201},
	{"COMPARISONS", 11, 32202},
	{"BENEFICIAL", 10, 32203},
	{"DISTRIBUTIONS", 13, 32204},
	{"STATISTICAL", 11, 32205},
	{"RTHT", 4, 32206},
	{"IEWI", 4, 32207},
	{"BELIZE", 6, 32208},
	{"CRAP", 4, 32209},
	{"SHRIMP", 6, 32210},
	{"EWYE", 4, 32211},
	{"OLDF", 4, 32212},
	{"DROU", 4, 32213},
	{"BYX", 3, 32214},
	{"OTFO", 4, 32215},
	{"HIPI", 4, 32216},
	{"NDKI", 4, 32217},
	{"VIEWPICTURE", 11, 32218},
	{"PROMISED", 8, 32219},
	{"UCKE", 4, 32220},
	{"VOLVO", 5, 32221},
	{"PENNY", 5, 32222},
	{"ROBUST", 6, 32223},
	{"WITHDRAWAL", 10, 32224},
	{"BOOKINGS", 8, 32225},
	{"ONTK", 4, 32226},
	{"THREATENED", 10, 32227},
	{"MINOLTA", 7, 32228},
	{"RMUS", 4, 32229},
	{"HCAN", 4, 32230},
	{"REPUBLICANS", 11, 32231},
	{"CAGE", 4, 32232},
	{"AGRICULTURE", 11, 32233},
	{"VOTING", 6, 32234},
	{"LGRO", 4, 32235},
	{"KEDH", 4, 32236},
	{"YOUF", 4, 32237},
	{"DISCUSSES", 9, 32238},
	{"GUI", 3, 32239},
	{"ATRU", 4, 32240},
	{"YRB", 3, 32241},
	{"YRET", 4, 32242},
	{"PORTER", 6, 32243},
	{"NNAM", 4, 32244},
	{"EROM", 4, 32245},
	{"GRAS", 4, 32246},
	{"TALY", 4, 32247},
	{"VER", 3, 32248},
	{"AWYE", 4, 32249},
	{"ILUR", 4, 32250},
	{"QUEST", 5, 32251},
	{"RESPONDED", 9, 32252},
	{"MWHE", 4, 32253},
	{"ABSTRACTS", 9, 32254},
	{"BORH", 4, 32255},
	{"ORMT", 4, 32256},
	{"NOWB", 4, 32257},
	{"IVORY", 5, 32258},
	{"STDO", 4, 32259},
	{"RYCA", 4, 32260},
	{"DREM", 4, 32261},
	{"ALPINE", 6, 32262},
	{"UTILIZE", 7, 32263},
	{"DONATE", 6, 32264},
	{"QUEEN", 5, 32265},
	{"RRUP", 4, 32266},
	{"LOYALTY", 7, 32267},
	{"PHARMACEUTICALS", 15, 32268},
	{"OBEG", 4, 32269},
	{"OMAD", 4, 32270},
	{"NEOU", 4, 32271},
	{"WELC", 4, 32272},
	{"NDAW", 4, 32273},
	{"CUBAN", 5, 32274},
	{"ANDALE", 6, 32275},
	{"HODI", 4, 32276},
	{"ZDR", 3, 32277},
	{"FABULOUS", 8, 32278},
	{"IRDI", 4, 32279},
	{"TTUR", 4, 32280},
	{"EEMO", 4, 32281},
	{"REMIX", 5, 32282},
	{"ALIAS", 5, 32283},
	{"DTOK", 4, 32284},
	{"NDAH", 4, 32285},
	{"THESAURUS", 9, 32286},
	{"INDIVIDUALLY", 12, 32287},
	{"IFIN", 4, 32288},
	{"SACRIFICE", 9, 32289},
	{"GRIEF", 5, 32290},
	{"EDGO", 4, 32291},
	{"BATTLEFIELD", 11, 32292},
	{"NEWER", 5, 32293},
	{"KAY", 3, 32294},
	{"XGU", 3, 32295},
	{"UXK", 3, 32296},
	{"SPICE", 5, 32297},
	{"YMEM", 4, 32298},
	{"EEMI", 4, 32299},
	{"DIGNITY", 7, 32300},
	{"OVAL", 4, 32301},
	{"IMPLIES", 7, 32302},
	{"INSPIRATION", 11, 32303},
	{"TALENTED", 8, 32304},
	{"ICEH", 4, 32305},
	{"MPAT", 4, 32306},
	{"SOMA", 4, 32307},
	{"NDAV", 4, 32308},
	{"NLAW", 4, 32309},
	{"SMEM", 4, 32310},
	{"COOLER", 6, 32311},
	{"AUTOMATIC", 9, 32312},
	{"APPRAISAL", 9, 32313},
	{"IORA", 4, 32314},
	{"CONSISTING", 10, 32315},
	{"GHTY", 4, 32316},
	{"WAGON", 5, 32317},
	{"MARITIME", 8, 32318},
	{"EHOP", 4, 32319},
	{"HEDW", 4, 32320},
	{"THIGH", 5, 32321},
	{"SINJ", 4, 32322},
	{"PERIODIC", 8, 32323},
	{"SUBMITTING", 10, 32324},
	{"OVERHEAD", 8, 32325},
	{"HEDH", 4, 32326},
	{"ASCII", 5, 32327},
	{"YETT", 4, 32328},
	{"DGEA", 4, 32329},
	{"RKFO", 4, 32330},
	{"TEAMMATE", 8, 32331},
	{"DBEN", 4, 32332},
	{"BUBBLE", 6, 32333},
	{"SHIPMENT", 8, 32334},
	{"VESP", 4, 32335},
	{"WNSH", 4, 32336},
	{"NDOV", 4, 32337},
	{"FMON", 4, 32338},
	{"AIRI", 4, 32339},
	{"BREEDING", 8, 32340},
	{"CCON", 4, 32341},
	{"CITATIONS", 9, 32342},
	{"AINR", 4, 32343},
	{"KGRO", 4, 32344},
	{"ISKN", 4, 32345},
	{"XJE", 3, 32346},
	{"GEOGRAPHICAL", 12, 32347},
	{"MOZAMBIQUE", 10, 32348},
	{"RTOD", 4, 32349},
	{"SCUE", 4, 32350},
	{"HREF", 4, 32351},
	{"BENZ", 4, 32352},
	{"CAB", 3, 32353},
	{"SECULAR", 7, 32354},
	{"SHAPES", 6, 32355},
	{"WIFI", 4, 32356},
	{"MMAR", 4, 32357},
	{"EEXA", 4, 32358},
	{"TIER", 4, 32359},
	{"LYMI", 4, 32360},
	{"OFGA", 4, 32361},
	{"FWD", 3, 32362},
	{"OMWH", 4, 32363},
	{"BUDDY", 5, 32364},
	{"USTD", 4, 32365},
	{"EARL", 4, 32366},
	{"MANOR", 5, 32367},
	{"NWV", 3, 32368},
	{"TLYC", 4, 32369},
	{"DIANE", 5, 32370},
	{"YACT", 4, 32371},
	{"UREP", 4, 32372},
	{"ORBU", 4, 32373},
	{"WNOF", 4, 32374},
	{"OBZ", 3, 32375},
	{"DISCLAIMERS", 11, 32376},
	{"SEDP", 4, 32377},
	{"OWOF", 4, 32378},
	{"CHAMPIONSHIPS", 13, 32379},
	{"NSLI", 4, 32380},
	{"BUG", 3, 32381},
	{"TAUG", 4, 32382},
	{"EXCLUDED", 8, 32383},
	{"LANE", 4, 32384},
	{"ANDREA", 6, 32385},
	{"SSWA", 4, 32386},
	{"BREEDS", 6, 32387},
	{"RAPIDS", 6, 32388},
	{"SPECIALIZE", 10, 32389},
	{"REOU", 4, 32390},
	{"DABL", 4, 32391},
	{"DISCO", 5, 32392},
	{"SHEFFIELD", 9, 32393},
	{"BAILEY", 6, 32394},
	{"ICKO", 4, 32395},
	{"ENDIF", 5, 32396},
	{"SEYO", 4, 32397},
	{"PATIENCE", 8, 32398},
	{"RCUL", 4, 32399},
	{"FINISHING", 9, 32400},
	{"BONUS", 5, 32401},
	{"EMOTIONS", 8, 32402},
	{"WELLINGTON", 10, 32403},
	{"OOLT", 4, 32404},
	{"INCOMING", 8, 32405},
	{"ANCESTOR", 8, 32406},
	{"VERDICT", 7, 32407},
	{"PROSPECTS", 9, 32408},
	{"OTGO", 4, 32409},
	{"CKGR", 4, 32410},
	{"LEXMARK", 7, 32411},
	{"CLEANERS", 8, 32412},
	{"BULGARIAN", 9, 32413},
	{"DSLI", 4, 32414},
	{"IESP", 4, 32415},
	{"GHTD", 4, 32416},
	{"HOCA", 4, 32417},
	{"SAIL", 4, 32418},
	{"TEPA", 4, 32419},
	{"YBEF", 4, 32420},
	{"HWY", 3, 32421},
	{"ETERNAL", 7, 32422},
	{"CASHIERS", 8, 32423},
	{"OUSM", 4, 32424},
	{"RGRE", 4, 32425},
	{"GUAM", 4, 32426},
	{"ACHC", 4, 32427},
	{"EEWH", 4, 32428},
	{"SEVENTH", 7, 32429},
	{"IKG", 3, 32430},
	{"EDJU", 4, 32431},
	{"ABORIGINAL", 10, 32432},
	{"RZW", 3, 32433},
	{"NTLO", 4, 32434},
	{"ROTATION", 8, 32435},
	{"BLOODY", 6, 32436},
	{"SHALLOW", 7, 32437},
	{"KEVI", 4, 32438},
	{"GERW", 4, 32439},
	{"SASM", 4, 32440},
	{"TGRE", 4, 32441},
	{"GENIUS", 6, 32442},
	{"PREVENTING", 10, 32443},
	{"RIEV", 4, 32444},
	{"BOULEVARD", 9, 32445},
	{"EUGENE", 6, 32446},
	{"NZC", 3, 32447},
	{"GTER", 4, 32448},
	{"USAL", 4, 32449},
	{"GUW", 3, 32450},
	{"DSUC", 4, 32451},
	{"ALIB", 4, 32452},
	{"EORA", 4, 32453},
	{"GITI", 4, 32454},
	{"PROTECTIVE", 10, 32455},
	{"GDP", 3, 32456},
	{"EGIM", 4, 32457},
	{"UZW", 3, 32458},
	{"METRIC", 6, 32459},
	{"NORTHEAST", 9, 32460},
	{"ANSU", 4, 32461},
	{"UNTH", 4, 32462},
	{"COMPLIANT", 9, 32463},
	{"MINUS", 5, 32464},
	{"YWY", 3, 32465},
	{"UTMO", 4, 32466},
	{"REFRIGERATOR", 12, 32467},
	{"UTEA", 4, 32468},
	{"PENALTIES", 9, 32469},
	{"AFUL", 4, 32470},
	{"YMUS", 4, 32471},
	{"COMBINED", 8, 32472},
	{"SEFR", 4, 32473},
	{"BENNETT", 7, 32474},
	{"IANF", 4, 32475},
	{"ANAV", 4, 32476},
	{"EATC", 4, 32477},
	{"ORPH", 4, 32478},
	{"HOTMAIL", 7, 32479},
	{"IMMUNE", 6, 32480},
	{"LSPE", 4, 32481},
	{"REFURBISHED", 11, 32482},
	{"JOSHUA", 6, 32483},
	{"EDBR", 4, 32484},
	{"PYK", 3, 32485},
	{"ORBIT", 5, 32486},
	{"ITAG", 4, 32487},
	{"RDLE", 4, 32488},
	{"ARMENIA", 7, 32489},
	{"BQU", 3, 32490},
	{"VARIED", 6, 32491},
	{"ILYT", 4, 32492},
	{"EUNT", 4, 32493},
	{"GRANDE", 6, 32494},
	{"ACCENT", 6, 32495},
	{"CONCEIVE", 8, 32496},
	{"HESB", 4, 32497},
	{"PJI", 3, 32498},
	{"ACTIVATED", 9, 32499},
	{"MYSTERIOUS", 10, 32500},
	{"CALM", 4, 32501},
	{"VIAT", 4, 32502},
	{"CONFERENCING", 12, 32503},
	{"CKOU", 4, 32504},
	{"ARMSTRONG", 9, 32505},
	{"POLITICIANS", 11, 32506},
	{"RTWI", 4, 32507},
	{"TRACKBACKS", 10, 32508},
	{"COORDINATOR", 11, 32509},
	{"EPPE", 4, 32510},
	{"VEWA", 4, 32511},
	{"INSTANTLY", 9, 32512},
	{"TIGERS", 6, 32513},
	{"ESFA", 4, 32514},
	{"LINF", 4, 32515},
	{"AURORA", 6, 32516},
	{"ROSO", 4, 32517},
	{"HIPO", 4, 32518},
	{"SLIDES", 6, 32519},
	{"RWOU", 4, 32520},
	{"MILAN", 5, 32521},
	{"NRIG", 4, 32522},
	{"MERCHANT", 8, 32523},
	{"PREMIERE", 8, 32524},
	{"LENDER", 6, 32525},
	{"PTHA", 4, 32526},
	{"TROPICAL", 8, 32527},
	{"NFAN", 4, 32528},
	{"VILLAGES", 8, 32529},
	{"DAYF", 4, 32530},
	{"CHORUS", 6, 32531},
	{"DIFI", 4, 32532},
	{"CHRISTINE", 9, 32533},
	{"TMIG", 4, 32534},
	{"PLEF", 4, 32535},
	{"EFLY", 4, 32536},
	{"ALUMINUM", 8, 32537},
	{"DIGIT", 5, 32538},
	{"ARGUED", 6, 32539},
	{"DIETARY", 7, 32540},
	{"SYMPHONY", 8, 32541},
	{"NDGI", 4, 32542},
	{"IPWI", 4, 32543},
	{"CLARKE", 6, 32544},
	{"CONSEQUENTLY", 12, 32545},
	{"XCLU", 4, 32546},
	{"OFFICIALLY", 10, 32547},
	{"IEWO", 4, 32548},
	{"RBAS", 4, 32549},
	{"DBYB", 4, 32550},
	{"WILLINGNESS", 11, 32551},
	{"INVITATION", 10, 32552},
	{"MTOB", 4, 32553},
	{"ACCEPTING", 9, 32554},
	{"PRECIPITATION", 13, 32555},
	{"MARILYN", 7, 32556},
	{"LIONS", 5, 32557},
	{"OUCO", 4, 32558},
	{"FINDLAW", 7, 32559},
	{"ENPL", 4, 32560},
	{"POOLS", 5, 32561},
	{"MUSHROOM", 8, 32562},
	{"CREATIVITY", 10, 32563},
	{"TONP", 4, 32564},
	{"IFYI", 4, 32565},
	{"MEIT", 4, 32566},
	{"LYRIC", 5, 32567},
	{"ONFA", 4, 32568},
	{"ORGANIZATIONAL", 14, 32569},
	{"EPLO", 4, 32570},
	{"HTWI", 4, 32571},
	{"GLORY", 5, 32572},
	{"ECOLOGICAL", 10, 32573},
	{"CLAIRE", 6, 32574},
	{"INTM", 4, 32575},
	{"NDKE", 4, 32576},
	{"CHLE", 4, 32577},
	{"NLYC", 4, 32578},
	{"CASUALTY", 8, 32579},
	{"EARTHQUAKE", 10, 32580},
	{"HURRICANE", 9, 32581},
	{"ASCL", 4, 32582},
	{"SPEEDS", 6, 32583},
	{"HATU", 4, 32584},
	{"SUSTAINED", 9, 32585},
	{"XYW", 3, 32586},
	{"QAB", 3, 32587},
	{"SHCO", 4, 32588},
	{"EQUIP", 5, 32589},
	{"WASV", 4, 32590},
	{"MATCHED", 7, 32591},
	{"DEPU", 4, 32592},
	{"APPROXIMATE", 11, 32593},
	{"EINL", 4, 32594},
	{"YOUV", 4, 32595},
	{"ZSF", 3, 32596},
	{"TLEW", 4, 32597},
	{"ILEO", 4, 32598},
	{"TUMOR", 5, 32599},
	{"NDOM", 4, 32600},
	{"STEAM", 5, 32601},
	{"CARROLL", 7, 32602},
	{"PROGRAMMER", 10, 32603},
	{"DRUM", 4, 32604},
	{"BREEZE", 6, 32605},
	{"FIGHTERS", 8, 32606},
	{"CHAMBERS", 8, 32607},
	{"OURS", 4, 32608},
	{"SBEA", 4, 32609},
	{"ORYW", 4, 32610},
	{"EHUN", 4, 32611},
	{"EDAU", 4, 32612},
	{"CONDEMN", 7, 32613},
	{"OPPOSED", 7, 32614},
	{"INHERITED", 9, 32615},
	{"WARMING", 7, 32616},
	{"APIN", 4, 32617},
	{"INCOMPLETE", 10, 32618},
	{"RDSW", 4, 32619},
	{"VOCALS", 6, 32620},
	{"WORKOUT", 7, 32621},
	{"CHRONICLE", 9, 32622},
	{"OPTIMISTIC", 10, 32623},
	{"FOUNTAIN", 8, 32624},
	{"WEB", 3, 32625},
	{"CHUBBY", 6, 32626},
	{"IESL", 4, 32627},
	{"ISKI", 4, 32628},
	{"RTIA", 4, 32629},
	{"ATGO", 4, 32630},
	{"EORO", 4, 32631},
	{"BIOGRAPHIES", 11, 32632},
	{"ESSD", 4, 32633},
	{"DRIC", 4, 32634},
	{"IWIL", 4, 32635},
	{"BURNER", 6, 32636},
	{"VECA", 4, 32637},
	{"IGNT", 4, 32638},
	{"EFTH", 4, 32639},
	{"CARTOON", 7, 32640},
	{"GBA", 3, 32641},
	{"RTSC", 4, 32642},
	{"HAUL", 4, 32643},
	{"VALIDITY", 8, 32644},
	{"OOGL", 4, 32645},
	{"THAG", 4, 32646},
	{"MONL", 4, 32647},
	{"FINNISH", 7, 32648},
	{"OWNR", 4, 32649},
	{"DWEA", 4, 32650},
	{"INFU", 4, 32651},
	{"OGAM", 4, 32652},
	{"WAIST", 5, 32653},
	{"PRISONERS", 9, 32654},
	{"ONDC", 4, 32655},
	{"UMED", 4, 32656},
	{"DEEPER", 6, 32657},
	{"MUSLIMS", 7, 32658},
	{"UNITE", 5, 32659},
	{"ORFA", 4, 32660},
	{"MEDITERRANEAN", 13, 32661},
	{"DOFM", 4, 32662},
	{"NIGHTLIFE", 9, 32663},
	{"STFA", 4, 32664},
	{"EVEH", 4, 32665},
	{"FOOTAGE", 7, 32666},
	{"HOWTO", 5, 32667},
	{"RKST", 4, 32668},
	{"OORE", 4, 32669},
	{"RSSU", 4, 32670},
	{"LYPL", 4, 32671},
	{"REVEALS", 7, 32672},
	{"PROGRESSIVE", 11, 32673},
	{"ARCHITECTS", 10, 32674},
	{"SAINTS", 6, 32675},
	{"PERCEIVED", 9, 32676},
	{"LLIK", 4, 32677},
	{"ROMG", 4, 32678},
	{"CARRIES", 7, 32679},
	{"IPTO", 4, 32680},
	{"THOROUGHLY", 10, 32681},
	{"EARG", 4, 32682},
	{"IDEB", 4, 32683},
	{"FREELANCE", 9, 32684},
	{"GYJ", 3, 32685},
	{"PATROL", 6, 32686},
	{"DUO", 3, 32687},
	{"TERJ", 4, 32688},
	{"VEDH", 4, 32689},
	{"DEVON", 5, 32690},
	{"SCREENSAVER", 11, 32691},
	{"ALVE", 4, 32692},
	{"OUSB", 4, 32693},
	{"ANOL", 4, 32694},
	{"HELENA", 6, 32695},
	{"SAVES", 5, 32696},
	{"REGARDED", 8, 32697},
	{"VALUATION", 9, 32698},
	{"MSWI", 4, 32699},
	{"LWIL", 4, 32700},
	{"NDBI", 4, 32701},
	{"MARION", 6, 32702},
	{"HOFA", 4, 32703},
	{"EGYPTIAN", 8, 32704},
	{"QRE", 3, 32705},
	{"IZF", 3, 32706},
	{"ALWE", 4, 32707},
	{"OADI", 4, 32708},
	{"TUNISIA", 7, 32709},
	{"ERPI", 4, 32710},
	{"ISHP", 4, 32711},
	{"METALLICA", 9, 32712},
	{"OUTLINED", 8, 32713},
	{"MEWO", 4, 32714},
	{"HANW", 4, 32715},
	{"TREATING", 8, 32716},
	{"TINW", 4, 32717},
	{"UREB", 4, 32718},
	{"GRASP", 5, 32719},
	{"APPOINTMENTS", 12, 32720},
	{"TERRIFIC", 8, 32721},
	{"RTGA", 4, 32722},
	{"GOTTA", 5, 32723},
	{"DLOO", 4, 32724},
	{"LLWE", 4, 32725},
	{"COWBOY", 6, 32726},
	{"AFTERWARD", 9, 32727},
	{"IANW", 4, 32728},
	{"NWAL", 4, 32729},
	{"OFFL", 4, 32730},
	{"VOJ", 3, 32731},
	{"VOUR", 4, 32732},
	{"COSTUME", 7, 32733},
	{"BAHRAIN", 7, 32734},
	{"KARMA", 5, 32735},
	{"OBUY", 4, 32736},
	{"HMON", 4, 32737},
	{"BULL", 4, 32738},
	{"EKEY", 4, 32739},
	{"DOWI", 4, 32740},
	{"UDET", 4, 32741},
	{"FFRO", 4, 32742},
	{"BETTY", 5, 32743},
	{"QUEENS", 6, 32744},
	{"ACADEMICS", 9, 32745},
	{"EGLO", 4, 32746},
	{"LONT", 4, 32747},
	{"ANLI", 4, 32748},
	{"PUBS", 4, 32749},
	{"QUANTITATIVE", 12, 32750},
	{"LUCAS", 5, 32751},
	{"HBUT", 4, 32752},
	{"SCREENSAVERS", 12, 32753},
	{"DCHE", 4, 32754},
	{"UNDERLYING", 10, 32755},
	{"PERSIAN", 7, 32756},
	{"SUBDIVISION", 11, 32757},
	{"SPITE", 5, 32758},
	{"HIMW", 4, 32759},
	{"TRIBES", 6, 32760},
	{"JEWELRY", 7, 32761},
	{"VIP", 3, 32762},
	{"CLICKS", 6, 32763},
	{"ENFI", 4, 32764},
	{"WMUC", 4, 32765},
	{"OPEO", 4, 32766},
	{"EDOO", 4, 32767},
	{"TSLO", 4, 32768},
	{"BIOLOGY", 7, 32769},
	{"HONDURAS", 8, 32770},
	{"RUNNER", 6, 32771},
	{"SSIL", 4, 32772},
	{"NAUGHTY", 7, 32773},
	{"FRANCHISE", 9, 32774},
	{"HAZARDS", 7, 32775},
	{"NEUTRAL", 7, 32776},
	{"INSURED", 7, 32777},
	{"YBAS", 4, 32778},
	{"HARPER", 6, 32779},
	{"LIVESTOCK", 9, 32780},
	{"OFPU", 4, 32781},
	{"EDIM", 4, 32782},
	{"MARDI", 5, 32783},
	{"EXEMPTION", 9, 32784},
	{"USIV", 4, 32785},
	{"TENANT", 6, 32786},
	{"SUSTAINABILITY", 14, 32787},
	{"OWDE", 4, 32788},
	{"IRCH", 4, 32789},
	{"MIXED", 5, 32790},
	{"SHOVE", 5, 32791},
	{"HEJE", 4, 32792},
	{"CABINETS", 8, 32793},
	{"TATTOO", 6, 32794},
	{"EEAG", 4, 32795},
	{"ALGEBRA", 7, 32796},
	{"BSOL", 4, 32797},
	{"SDRA", 4, 32798},
	{"SHADOWS", 7, 32799},
	{"RXB", 3, 32800},
	{"HOLLY", 5, 32801},
	{"HIPT", 4, 32802},
	{"RLIV", 4, 32803},
	{"FORMATTING", 10, 32804},
	{"OFHU", 4, 32805},
	{"ODEV", 4, 32806},
	{"SHEEP", 5, 32807},
	{"NUTRITIONAL", 11, 32808},
	{"HOSTILE", 7, 32809},
	{"MERCY", 5, 32810},
	{"NMV", 3, 32811},
	{"LMED", 4, 32812},
	{"FISHERMAN", 9, 32813},
	{"HARTFORD", 8, 32814},
	{"LEPH", 4, 32815},
	{"GTOF", 4, 32816},
	{"MARCUS", 6, 32817},
	{"SUNRISE", 7, 32818},
	{"WRAPPING", 8, 32819},
	{"GPEO", 4, 32820},
	{"SKULL", 5, 32821},
	{"FLEXIBLE", 8, 32822},
	{"CHRISTIANITY", 12, 32823},
	{"LLSU", 4, 32824},
	{"NICARAGUA", 9, 32825},
	{"ZEDA", 4, 32826},
	{"DRIG", 4, 32827},
	{"IESD", 4, 32828},
	{"NGBR", 4, 32829},
	{"WEBLOGS", 7, 32830},
	{"TIMELINE", 8, 32831},
	{"BUSH", 4, 32832},
	{"YCAM", 4, 32833},
	{"VMW", 3, 32834},
	{"THPL", 4, 32835},
	{"EISB", 4, 32836},
	{"CONCEDE", 7, 32837},
	{"COMMISSIONER", 12, 32838},
	{"OOUT", 4, 32839},
	{"BELONGS", 7, 32840},
	{"NTYE", 4, 32841},
	{"OFRI", 4, 32842},
	{"REVELATION", 10, 32843},
	{"SDEM", 4, 32844},
	{"LDQU", 4, 32845},
	{"MPTS", 4, 32846},
	{"OWNM", 4, 32847},
	{"LSWH", 4, 32848},
	{"RCIS", 4, 32849},
	{"DOUGH", 5, 32850},
	{"LEDM", 4, 32851},
	{"BLESS", 5, 32852},
	{"OFCL", 4, 32853},
	{"LDFO", 4, 32854},
	{"TORF", 4, 32855},
	{"RGAR", 4, 32856},
	{"EMWI", 4, 32857},
	{"STSP", 4, 32858},
	{"AFFILIATION", 11, 32859},
	{"HAFR", 4, 32860},
	{"OWSO", 4, 32861},
	{"NUDIST", 6, 32862},
	{"DESSERT", 7, 32863},
	{"INFINITE", 8, 32864},
	{"DIANA", 5, 32865},
	{"NGFU", 4, 32866},
	{"ENSURES", 7, 32867},
	{"JAR", 3, 32868},
	{"ACKN", 4, 32869},
	{"MPHA", 4, 32870},
	{"RELATIVES", 9, 32871},
	{"RBON", 4, 32872},
	{"OUWI", 4, 32873},
	{"LINDSAY", 7, 32874},
	{"CLAN", 4, 32875},
	{"EXECUTION", 9, 32876},
	{"UGHW", 4, 32877},
	{"SATISFACTORY", 12, 32878},
	{"SPECTACULAR", 11, 32879},
	{"PLACEMENT", 9, 32880},
	{"BRACELETS", 9, 32881},
	{"LOWL", 4, 32882},
	{"SYNC", 4, 32883},
	{"LSTU", 4, 32884},
	{"SOCK", 4, 32885},
	{"TELEPHONY", 9, 32886},
	{"OFEV", 4, 32887},
	{"HWER", 4, 32888},
	{"MESA", 4, 32889},
	{"ECTF", 4, 32890},
	{"UPSTAIRS", 8, 32891},
	{"LESU", 4, 32892},
	{"REMEDY", 6, 32893},
	{"REALTORS", 8, 32894},
	{"NPUB", 4, 32895},
	{"DAMN", 4, 32896},
	{"THICKNESS", 9, 32897},
	{"EMPIRE", 6, 32898},
	{"BYIN", 4, 32899},
	{"RUIN", 4, 32900},
	{"MMOD", 4, 32901},
	{"ADJUSTMENTS", 11, 32902},
	{"TRANSLATION", 11, 32903},
	{"OTOU", 4, 32904},
	{"GRAPHICAL", 9, 32905},
	{"OZM", 3, 32906},
	{"LETR", 4, 32907},
	{"NGSS", 4, 32908},
	{"DISCUSSING", 10, 32909},
	{"AEROSPACE", 9, 32910},
	{"CONSPIRACY", 10, 32911},
	{"PORK", 4, 32912},
	{"YSTU", 4, 32913},
	{"OCQ", 3, 32914},
	{"ADAPTED", 7, 32915},
	{"LATF", 4, 32916},
	{"ATBR", 4, 32917},
	{"COMPRISE", 8, 32918},
	{"RBES", 4, 32919},
	{"THLO", 4, 32920},
	{"LLKN", 4, 32921},
	{"ESTATES", 7, 32922},
	{"WHIP", 4, 32923},
	{"DEVELOPMENTAL", 13, 32924},
	{"TLEG", 4, 32925},
	{"RUG", 3, 32926},
	{"YREF", 4, 32927},
	{"ISOLATION", 9, 32928},
	{"CALB", 4, 32929},
	{"BOROUGH", 7, 32930},
	{"MAINTAINS", 9, 32931},
	{"FAILING", 7, 32932},
	{"WHOEVER", 7, 32933},
	{"MINISTRY", 8, 32934},
	{"EELA", 4, 32935},
	{"TWOH", 4, 32936},
	{"SHORTCUTS", 9, 32937},
	{"INTERACT", 8, 32938},
	{"MSON", 4, 32939},
	{"RETAINED", 8, 32940},
	{"PAMELA", 6, 32941},
	{"ILEP", 4, 32942},
	{"FPY", 3, 32943},
	{"ANDREWS", 7, 32944},
	{"ANWE", 4, 32945},
	{"PYU", 3, 32946},
	{"NXW", 3, 32947},
	{"CONSENT", 7, 32948},
	{"EXTENDING", 9, 32949},
	{"JESSE", 5, 32950},
	{"ENTREPRENEUR", 12, 32951},
	{"SPECIFIES", 9, 32952},
	{"HULL", 4, 32953},
	{"LOGITECH", 8, 32954},
	{"SURREY", 6, 32955},
	{"FOSTER", 6, 32956},
	{"EIMA", 4, 32957},
	{"TEGY", 4, 32958},
	{"RYDI", 4, 32959},
	{"SUBSIDY", 7, 32960},
	{"ALLEY", 5, 32961},
	{"STGA", 4, 32962},
	{"ILST", 4, 32963},
	{"RSSE", 4, 32964},
	{"UTMI", 4, 32965},
	{"BRIEFING", 8, 32966},
	{"ACTIVELY", 8, 32967},
	{"FASCINATING", 11, 32968},
	{"BELKIN", 6, 32969},
	{"DEM", 3, 32970},
	{"TYST", 4, 32971},
	{"HORMONE", 7, 32972},
	{"ESEG", 4, 32973},
	{"NSEQ", 4, 32974},
	{"ZVE", 3, 32975},
	{"ACCREDITATION", 13, 32976},
	{"WAV", 3, 32977},
	{"RNEA", 4, 32978},
	{"BLACKBERRY", 10, 32979},
	{"ISGU", 4, 32980},
	{"HIGHLAND", 8, 32981},
	{"RCAL", 4, 32982},
	{"ERUP", 4, 32983},
	{"MEDITATION", 10, 32984},
	{"MODULAR", 7, 32985},
	{"MICROPHONE", 10, 32986},
	{"NTAM", 4, 32987},
	{"MACEDONIA", 9, 32988},
	{"ANGS", 4, 32989},
	{"ASEW", 4, 32990},
	{"RSED", 4, 32991},
	{"RKSH", 4, 32992},
	{"COMBINING", 9, 32993},
	{"BRANDON", 7, 32994},
	{"INSTRUMENTAL", 12, 32995},
	{"GIANTS", 6, 32996},
	{"THQU", 4, 32997},
	{"ORGANIZING", 10, 32998},
	{"EYBE", 4, 32999},
	{"ESBO", 4, 33000},
	{"AGGRESSION", 10, 33001},
	{"STIMULUS", 8, 33002},
	{"ECOSYSTEM", 9, 33003},
	{"ILEM", 4, 33004},
	{"EYEBROW", 7, 33005},
	{"IVEU", 4, 33006},
	{"MODERATORS", 10, 33007},
	{"LSTE", 4, 33008},
	{"FILTER", 6, 33009},
	{"ORGANISM", 8, 33010},
	{"SHEER", 5, 33011},
	{"WINSTON", 7, 33012},
	{"IAMI", 4, 33013},
	{"RREG", 4, 33014},
	{"COCAINE", 7, 33015},
	{"MEMO", 4, 33016},
	{"SOLVED", 6, 33017},
	{"CASINO", 6, 33018},
	{"RCEO", 4, 33019},
	{"HNIQ", 4, 33020},
	{"RIMP", 4, 33021},
	{"HELMET", 6, 33022},
	{"KAZAKHSTAN", 10, 33023},
	{"SGOV", 4, 33024},
	{"EJEC", 4, 33025},
	{"ZUH", 3, 33026},
	{"HAWAIIAN", 8, 33027},
	{"STANDINGS", 9, 33028},
	{"TBES", 4, 33029},
	{"PARTITION", 9, 33030},
	{"GRATUIT", 7, 33031},
	{"CONSOLES", 8, 33032},
	{"ODFO", 4, 33033},
	{"EEKT", 4, 33034},
	{"FUNK", 4, 33035},
	{"FBI", 3, 33036},
	{"RONL", 4, 33037},
	{"SPOON", 5, 33038},
	{"QATAR", 5, 33039},
	{"GSHE", 4, 33040},
	{"MAGNET", 6, 33041},
	{"GIND", 4, 33042},
	{"DINL", 4, 33043},
	{"OCKT", 4, 33044},
	{"TRANSLATIONS", 12, 33045},
	{"BOOTH", 5, 33046},
	{"PORSCHE", 7, 33047},
	{"EDEB", 4, 33048},
	{"ATKI", 4, 33049},
	{"CAYMAN", 6, 33050},
	{"TOND", 4, 33051},
	{"LYIM", 4, 33052},
	{"RTRI", 4, 33053},
	{"ARDD", 4, 33054},
	{"MEHA", 4, 33055},
	{"JAGUAR", 6, 33056},
	{"WORKPLACE", 9, 33057},
	{"YHAR", 4, 33058},
	{"REEL", 4, 33059},
	{"ILYO", 4, 33060},
	{"EXOTIC", 6, 33061},
	{"SSAU", 4, 33062},
	{"ETSW", 4, 33063},
	{"EOCC", 4, 33064},
	{"POSING", 6, 33065},
	{"WANG", 4, 33066},
	{"BOIL", 4, 33067},
	{"COUP", 4, 33068},
	{"RTOH", 4, 33069},
	{"DISCOURAGE", 10, 33070},
	{"KILOMETERS", 10, 33071},
	{"EXAM", 4, 33072},
	{"MINIMAL", 7, 33073},
	{"RAND", 4, 33074},
	{"HOPKINS", 7, 33075},
	{"URGENT", 6, 33076},
	{"PRIZ", 4, 33077},
	{"GUARANTEES", 10, 33078},
	{"INFANTS", 7, 33079},
	{"GOTHIC", 6, 33080},
	{"CYLINDER", 8, 33081},
	{"HOCKEY", 6, 33082},
	{"WITCH", 5, 33083},
	{"NLAS", 4, 33084},
	{"DGOA", 4, 33085},
	{"ALONGSIDE", 9, 33086},
	{"COHEN", 5, 33087},
	{"SHARK", 5, 33088},
	{"USGS", 4, 33089},
	{"LWHO", 4, 33090},
	{"PUPPY", 5, 33091},
	{"RSUN", 4, 33092},
	{"AMSO", 4, 33093},
	{"KATHY", 5, 33094},
	{"OBEH", 4, 33095},
	{"INFLUENTIAL", 11, 33096},
	{"PURSE", 5, 33097},
	{"LLGO", 4, 33098},
	{"VJE", 3, 33099},
	{"ACRE", 4, 33100},
	{"GRAPHS", 6, 33101},
	{"BLINK", 5, 33102},
	{"MANIPULATE", 10, 33103},
	{"CIGARETTES", 10, 33104},
	{"WEWI", 4, 33105},
	{"EDIT", 4, 33106},
	{"SYNDROME", 8, 33107},
	{"DISSOLVE", 8, 33108},
	{"RMAY", 4, 33109},
	{"HIMB", 4, 33110},
	{"REVENGE", 7, 33111},
	{"EXPIRES", 7, 33112},
	{"ENEMIES", 7, 33113},
	{"LOWS", 4, 33114},
	{"YKW", 3, 33115},
	{"EBLU", 4, 33116},
	{"HADL", 4, 33117},
	{"EFAT", 4, 33118},
	{"ESHM", 4, 33119},
	{"CONTROLLERS", 11, 33120},
	{"PUZZLE", 6, 33121},
	{"RYPO", 4, 33122},
	{"AQUA", 4, 33123},
	{"CHEN", 4, 33124},
	{"EMMA", 4, 33125},
	{"UITI", 4, 33126},
	{"CONSULTANCY", 11, 33127},
	{"FINANCES", 8, 33128},
	{"GRAC", 4, 33129},
	{"METROPOLITAN", 12, 33130},
	{"FLEXIBILITY", 11, 33131},
	{"ACCEPTS", 7, 33132},
	{"ENJOYING", 8, 33133},
	{"CONVENTIONS", 11, 33134},
	{"CKFO", 4, 33135},
	{"TWOB", 4, 33136},
	{"PABL", 4, 33137},
	{"ERDU", 4, 33138},
	{"EXPECTED", 8, 33139},
	{"ERSQ", 4, 33140},
	{"INTIMATE", 8, 33141},
	{"FPAR", 4, 33142},
	{"INCREDIBLY", 10, 33143},
	{"PEST", 4, 33144},
	{"LARO", 4, 33145},
	{"ITALIANO", 8, 33146},
	{"COORDINATES", 11, 33147},
	{"RCA", 3, 33148},
	{"OFOL", 4, 33149},
	{"MPTT", 4, 33150},
	{"UNEA", 4, 33151},
	{"CARNIVAL", 8, 33152},
	{"YMEA", 4, 33153},
	{"LAWY", 4, 33154},
	{"STICKER", 7, 33155},
	{"PROMISES", 8, 33156},
	{"SBEH", 4, 33157},
	{"EDCR", 4, 33158},
	{"RESPONDING", 10, 33159},
	{"REJE", 4, 33160},
	{"ALWH", 4, 33161},
	{"COSTLY", 6, 33162},
	{"REEF", 4, 33163},
	{"CONSERVATION", 12, 33164},
	{"EAGO", 4, 33165},
	{"STAKEHOLDERS", 12, 33166},
	{"LEFI", 4, 33167},
	{"LESL", 4, 33168},
	{"HYDROCODONE", 11, 33169},
	{"WYOU", 4, 33170},
	{"CORNELL", 7, 33171},
	{"SATIN", 5, 33172},
	{"EATF", 4, 33173},
	{"ATTEMPTING", 10, 33174},
	{"RKWI", 4, 33175},
	{"LEOR", 4, 33176},
	{"MAILTO", 6, 33177},
	{"PROMO", 5, 33178},
	{"KSHO", 4, 33179},
	{"XOC", 3, 33180},
	{"REPRESENTATIONS", 15, 33181},
	{"MESU", 4, 33182},
	{"INSTRUCT", 8, 33183},
	{"CLIFF", 5, 33184},
	{"DVOC", 4, 33185},
	{"AYSL", 4, 33186},
	{"CHAN", 4, 33187},
	{"UIJ", 3, 33188},
	{"EEMT", 4, 33189},
	{"TICT", 4, 33190},
	{"TUNES", 5, 33191},
	{"LPOL", 4, 33192},
	{"IKEO", 4, 33193},
	{"COMPETING", 9, 33194},
	{"TLYD", 4, 33195},
	{"HIKE", 4, 33196},
	{"CONSTITUTION", 12, 33197},
	{"COMBINES", 8, 33198},
	{"YBRO", 4, 33199},
	{"OKSA", 4, 33200},
	{"DRIED", 5, 33201},
	{"STOV", 4, 33202},
	{"LDHO", 4, 33203},
	{"BESU", 4, 33204},
	{"OOLW", 4, 33205},
	{"UGHF", 4, 33206},
	{"DEMOGRAPHIC", 11, 33207},
	{"RTOU", 4, 33208},
	{"BETH", 4, 33209},
	{"SIBLING", 7, 33210},
	{"BRADFORD", 8, 33211},
	{"PHRASES", 7, 33212},
	{"ALHI", 4, 33213},
	{"TEGI", 4, 33214},
	{"CKHA", 4, 33215},
	{"ATDA", 4, 33216},
	{"EWRE", 4, 33217},
	{"PENINSULA", 9, 33218},
	{"CHELSEA", 7, 33219},
	{"HEUK", 4, 33220},
	{"YMAD", 4, 33221},
	{"REYNOLDS", 8, 33222},
	{"REWS", 4, 33223},
	{"DOM", 3, 33224},
	{"JILL", 4, 33225},
	{"RABBIT", 6, 33226},
	{"SEAG", 4, 33227},
	{"SPEECHES", 8, 33228},
	{"MECHANIC", 8, 33229},
	{"ADLE", 4, 33230},
	{"REACHES", 7, 33231},
	{"URTE", 4, 33232},
	{"SCHEMA", 6, 33233},
	{"YZH", 3, 33234},
	{"IZL", 3, 33235},
	{"IPOF", 4, 33236},
	{"CONSIDERS", 9, 33237},
	{"CUTE", 4, 33238},
	{"SFEE", 4, 33239},
	{"CATALOGS", 8, 33240},
	{"PANIC", 5, 33241},
	{"UDZ", 3, 33242},
	{"DONATION", 8, 33243},
	{"MINISTRIES", 10, 33244},
	{"ILZ", 3, 33245},
	{"ERKE", 4, 33246},
	{"HTFO", 4, 33247},
	{"STOVE", 5, 33248},
	{"DHOM", 4, 33249},
	{"VACANCIES", 9, 33250},
	{"QUIZZES", 7, 33251},
	{"OTAC", 4, 33252},
	{"NOFB", 4, 33253},
	{"PARLIAMENTARY", 13, 33254},
	{"OBJ", 3, 33255},
	{"PREFIX", 6, 33256},
	{"LUCIA", 5, 33257},
	{"OWWE", 4, 33258},
	{"EYZ", 3, 33259},
	{"MBOL", 4, 33260},
	{"SAVANNAH", 8, 33261},
	{"INSTINCT", 8, 33262},
	{"TYPING", 6, 33263},
	{"LION", 4, 33264},
	{"DLOC", 4, 33265},
	{"DANS", 4, 33266},
	{"ANSB", 4, 33267},
	{"PLANETS", 7, 33268},
	{"ARTR", 4, 33269},
	{"ISGE", 4, 33270},
	{"TDEF", 4, 33271},
	{"TWOG", 4, 33272},
	{"CORD", 4, 33273},
	{"PUNCH", 5, 33274},
	{"ALSF", 4, 33275},
	{"BOULDER", 7, 33276},
	{"POINTING", 8, 33277},
	{"RENEW", 5, 33278},
	{"COUPLED", 7, 33279},
	{"ERPU", 4, 33280},
	{"GUT", 3, 33281},
	{"INSERT", 6, 33282},
	{"MIGRATION", 9, 33283},
	{"RDRE", 4, 33284},
	{"ROLLING", 7, 33285},
	{"VIII", 4, 33286},
	{"THPE", 4, 33287},
	{"IEDW", 4, 33288},
	{"HMAR", 4, 33289},
	{"MYANMAR", 7, 33290},
	{"METADATA", 8, 33291},
	{"ODST", 4, 33292},
	{"HAROLD", 6, 33293},
	{"HENL", 4, 33294},
	{"PASTA", 5, 33295},
	{"CIRCUITS", 8, 33296},
	{"SCRAMBLE", 8, 33297},
	{"NLYH", 4, 33298},
	{"FLOPPY", 6, 33299},
	{"HANDBAGS", 8, 33300},
	{"GSHA", 4, 33301},
	{"NSWA", 4, 33302},
	{"OFOT", 4, 33303},
	{"OIND", 4, 33304},
	{"SOMERSET", 8, 33305},
	{"INCURRED", 8, 33306},
	{"UDJ", 3, 33307},
	{"QBU", 3, 33308},
	{"APPRECIATION", 12, 33309},
	{"TOCU", 4, 33310},
	{"EEWI", 4, 33311},
	{"ANTIGUA", 7, 33312},
	{"NOTTINGHAM", 10, 33313},
	{"DTUR", 4, 33314},
	{"THUNDER", 7, 33315},
	{"CAUTION", 7, 33316},
	{"EDVI", 4, 33317},
	{"SCENT", 5, 33318},
	{"OOKL", 4, 33319},
	{"OALO", 4, 33320},
	{"IDENTIFIES", 10, 33321},
	{"NEOR", 4, 33322},
	{"TBRE", 4, 33323},
	{"IZK", 3, 33324},
	{"OTLI", 4, 33325},
	{"QUALIFICATION", 13, 33326},
	{"TSLE", 4, 33327},
	{"LOCKS", 5, 33328},
	{"MODELLING", 9, 33329},
	{"DBYR", 4, 33330},
	{"ILIS", 4, 33331},
	{"NAMELY", 6, 33332},
	{"SYMPATHY", 8, 33333},
	{"MINIATURE", 9, 33334},
	{"DEPT", 4, 33335},
	{"DWAL", 4, 33336},
	{"HACK", 4, 33337},
	{"EUROS", 5, 33338},
	{"LLGE", 4, 33339},
	{"STLA", 4, 33340},
	{"ERAW", 4, 33341},
	{"FIXED", 5, 33342},
	{"SWAL", 4, 33343},
	{"INTERSTATE", 10, 33344},
	{"PIRATES", 7, 33345},
	{"AERIAL", 6, 33346},
	{"AMBITIOUS", 9, 33347},
	{"DENSITY", 7, 33348},
	{"HAWK", 4, 33349},
	{"PRESUMABLY", 10, 33350},
	{"HEYV", 4, 33351},
	{"PTON", 4, 33352},
	{"TRAGIC", 6, 33353},
	{"SUPPLIER", 8, 33354},
	{"ELEPHANT", 8, 33355},
	{"SYSTEMATIC", 10, 33356},
	{"RQUE", 4, 33357},
	{"ORIGINS", 7, 33358},
	{"HIRED", 5, 33359},
	{"ORGR", 4, 33360},
	{"ILLUSION", 8, 33361},
	{"TEXTILE", 7, 33362},
	{"LAMB", 4, 33363},
	{"MADAGASCAR", 10, 33364},
	{"GEWI", 4, 33365},
	{"NATHAN", 6, 33366},
	{"LYAD", 4, 33367},
	{"TOBAGO", 6, 33368},
	{"GANY", 4, 33369},
	{"PRESENTING", 10, 33370},
	{"DSPA", 4, 33371},
	{"EXPERIENCED", 11, 33372},
	{"PROTOCOL", 8, 33373},
	{"TROUBLESHOOTING", 15, 33374},
	{"ICON", 4, 33375},
	{"BLYT", 4, 33376},
	{"UZBEKISTAN", 10, 33377},
	{"TSUS", 4, 33378},
	{"ROYAL", 5, 33379},
	{"INDEXES", 7, 33380},
	{"LEGISLATURE", 11, 33381},
	{"OROV", 4, 33382},
	{"PAC", 3, 33383},
	{"CKSI", 4, 33384},
	{"RQI", 3, 33385},
	{"EAUD", 4, 33386},
	{"VENH", 4, 33387},
	{"PATENT", 6, 33388},
	{"ILAD", 4, 33389},
	{"NDAU", 4, 33390},
	{"ROBOT", 5, 33391},
	{"NEPO", 4, 33392},
	{"ERP", 3, 33393},
	{"CENTURIES", 9, 33394},
	{"OVEO", 4, 33395},
	{"NTSL", 4, 33396},
	{"TRAY", 4, 33397},
	{"AVOU", 4, 33398},
	{"FITI", 4, 33399},
	{"RICHARDSON", 10, 33400},
	{"RYAT", 4, 33401},
	{"HINDU", 5, 33402},
	{"RLAT", 4, 33403},
	{"EKAN", 4, 33404},
	{"DSPO", 4, 33405},
	{"ACKP", 4, 33406},
	{"HEMB", 4, 33407},
	{"OSEB", 4, 33408},
	{"FRAGRANCES", 10, 33409},
	{"PERSIST", 7, 33410},
	{"VOCABULARY", 10, 33411},
	{"LICKING", 7, 33412},
	{"CHARTER", 7, 33413},
	{"VPN", 3, 33414},
	{"URMO", 4, 33415},
	{"FUNDRAISING", 11, 33416},
	{"USTP", 4, 33417},
	{"SDRI", 4, 33418},
	{"INBY", 4, 33419},
	{"FCC", 3, 33420},
	{"MARKERS", 7, 33421},
	{"WEIGHTS", 7, 33422},
	{"NOTU", 4, 33423},
	{"YJUS", 4, 33424},
	{"YMOU", 4, 33425},
	{"RIVAL", 5, 33426},
	{"SPRAY", 5, 33427},
	{"WELL-BEING", 10, 33428},
	{"ALBANIA", 7, 33429},
	{"IEFS", 4, 33430},
	{"TSAG", 4, 33431},
	{"GEOLOGICAL", 10, 33432},
	{"HISK", 4, 33433},
	{"ASSESSING", 9, 33434},
	{"QOR", 3, 33435},
	{"LASTING", 7, 33436},
	{"VEUP", 4, 33437},
	{"WICKED", 6, 33438},
	{"SHORT-TERM", 10, 33439},
	{"INTRODUCES", 10, 33440},
	{"KILLS", 5, 33441},
	{"ROOMMATE", 8, 33442},
	{"EXTY", 4, 33443},
	{"DECORATE", 8, 33444},
	{"COLUMNIST", 9, 33445},
	{"PUSHED", 6, 33446},
	{"UPTI", 4, 33447},
	{"OSTD", 4, 33448},
	{"RYAS", 4, 33449},
	{"WEBMASTERS", 10, 33450},
	{"OCEN", 4, 33451},
	{"YSEN", 4, 33452},
	{"NKSA", 4, 33453},
	{"TEXTURE", 7, 33454},
	{"YLK", 3, 33455},
	{"LFRE", 4, 33456},
	{"JEWI", 4, 33457},
	{"RUNO", 4, 33458},
	{"YBAC", 4, 33459},
	{"CESB", 4, 33460},
	{"PULSE", 5, 33461},
	{"SFEA", 4, 33462},
	{"COMPUTATIONAL", 13, 33463},
	{"ACDBENTITY", 10, 33464},
	{"PARTICIPATED", 12, 33465},
	{"JUNK", 4, 33466},
	{"HANDHELDS", 9, 33467},
	{"WAX", 3, 33468},
	{"LUCY", 4, 33469},
	{"ANSWERING", 9, 33470},
	{"IESR", 4, 33471},
	{"DEBUT", 5, 33472},
	{"CRUSH", 5, 33473},
	{"IMPRESSED", 9, 33474},
	{"NTSD", 4, 33475},
	{"OWRI", 4, 33476},
	{"INUN", 4, 33477},
	{"REGGAE", 6, 33478},
	{"FAILURES", 8, 33479},
	{"LYBA", 4, 33480},
	{"SENSITIVITY", 11, 33481},
	{"UCHL", 4, 33482},
	{"ACCOMPLISHMENT", 14, 33483},
	{"SURNAME", 7, 33484},
	{"NAILS", 5, 33485},
	{"EEPO", 4, 33486},
	{"YTEA", 4, 33487},
	{"ZZH", 3, 33488},
	{"RCRE", 4, 33489},
	{"ETUN", 4, 33490},
	{"WHATS", 5, 33491},
	{"RIDES", 5, 33492},
	{"HIMF", 4, 33493},
	{"DSOL", 4, 33494},
	{"REHAB", 5, 33495},
	{"OFEL", 4, 33496},
	{"TALM", 4, 33497},
	{"UHY", 3, 33498},
	{"FORTUNATELY", 11, 33499},
	{"EPIC", 4, 33500},
	{"EWID", 4, 33501},
	{"COMPLIANCE", 10, 33502},
	{"SISW", 4, 33503},
	{"SATURN", 6, 33504},
	{"ORGANIZER", 9, 33505},
	{"LEAC", 4, 33506},
	{"MBRA", 4, 33507},
	{"KESP", 4, 33508},
	{"ALLERGY", 7, 33509},
	{"DAM", 3, 33510},
	{"TEXTBOOK", 8, 33511},
	{"TWISTED", 7, 33512},
	{"COMBINATIONS", 12, 33513},
	{"SEBU", 4, 33514},
	{"PRECEDING", 9, 33515},
	{"RCUS", 4, 33516},
	{"ENZYME", 6, 33517},
	{"ESEW", 4, 33518},
	{"OULL", 4, 33519},
	{"TCOR", 4, 33520},
	{"ACCESSIBLE", 10, 33521},
	{"DLOS", 4, 33522},
	{"CLASSIFY", 8, 33523},
	{"UNDL", 4, 33524},
	{"ZSHOPS", 6, 33525},
	{"ORTC", 4, 33526},
	{"YOPE", 4, 33527},
	{"ATTENDANCE", 10, 33528},
	{"PLANES", 6, 33529},
	{"EDMONTON", 8, 33530},
	{"AMBITION", 8, 33531},
	{"DISKS", 5, 33532},
	{"SEFF", 4, 33533},
	{"CONDO", 5, 33534},
	{"POKEMON", 7, 33535},
	{"AMPLIFIER", 9, 33536},
	{"DEFR", 4, 33537},
	{"DBOT", 4, 33538},
	{"BICYCLE", 7, 33539},
	{"NSDE", 4, 33540},
	{"AMBIEN", 6, 33541},
	{"ARBITRARY", 9, 33542},
	{"EAPE", 4, 33543},
	{"RETRIEVE", 8, 33544},
	{"LEXINGTON", 9, 33545},
	{"CUSTODY", 7, 33546},
	{"VERNON", 6, 33547},
	{"NGMU", 4, 33548},
	{"WORLDCAT", 8, 33549},
	{"TITANIUM", 8, 33550},
	{"UTEL", 4, 33551},
	{"LLWO", 4, 33552},
	{"WONA", 4, 33553},
	{"REQUIRED", 8, 33554},
	{"CONCEPTION", 10, 33555},
	{"FAIRY", 5, 33556},
	{"WYR", 3, 33557},
	{"OODL", 4, 33558},
	{"SOAP", 4, 33559},
	{"DISABLED", 8, 33560},
	{"FNOT", 4, 33561},
	{"UNCERTAIN", 9, 33562},
	{"LYSP", 4, 33563},
	{"LSHI", 4, 33564},
	{"LESM", 4, 33565},
	{"BUILDS", 6, 33566},
	{"CONTACTED", 9, 33567},
	{"ANONYMOUS", 9, 33568},
	{"TMUC", 4, 33569},
	{"SHAFT", 5, 33570},
	{"LIQUID", 6, 33571},
	{"COIN", 4, 33572},
	{"NEYI", 4, 33573},
	{"NBES", 4, 33574},
	{"DIARY", 5, 33575},
	{"BYE", 3, 33576},
	{"CDT", 3, 33577},
	{"UCTO", 4, 33578},
	{"SSFO", 4, 33579},
	{"NYRE", 4, 33580},
	{"LLIF", 4, 33581},
	{"RECORDERS", 9, 33582},
	{"EMERGING", 8, 33583},
	{"CONSTRAINT", 10, 33584},
	{"LESLIE", 6, 33585},
	{"CASIO", 5, 33586},
	{"RATIONAL", 8, 33587},
	{"DEUTSCHE", 8, 33588},
	{"YSEA", 4, 33589},
	{"ISTU", 4, 33590},
	{"PYJ", 3, 33591},
	{"ILQ", 3, 33592},
	{"INSTALLATION", 12, 33593},
	{"POSTINGS", 8, 33594},
	{"UZN", 3, 33595},
	{"PENCIL", 6, 33596},
	{"EQUIVALENT", 10, 33597},
	{"INNOVATIONS", 11, 33598},
	{"NDCE", 4, 33599},
	{"FPRE", 4, 33600},
	{"KITTY", 5, 33601},
	{"BANKER", 6, 33602},
	{"POSTCARDS", 9, 33603},
	{"NTSR", 4, 33604},
	{"DUDE", 4, 33605},
	{"ILTI", 4, 33606},
	{"INFORMAL", 8, 33607},
	{"MONTE", 5, 33608},
	{"YTON", 4, 33609},
	{"KZO", 3, 33610},
	{"ASUB", 4, 33611},
	{"ITYL", 4, 33612},
	{"YOUP", 4, 33613},
	{"KAQ", 3, 33614},
	{"FIRES", 5, 33615},
	{"ALGERIA", 7, 33616},
	{"CATALOG", 7, 33617},
	{"BLESSED", 7, 33618},
	{"LUIS", 4, 33619},
	{"NTYS", 4, 33620},
	{"ERFL", 4, 33621},
	{"TBAN", 4, 33622},
	{"REVIEWING", 9, 33623},
	{"CARDIFF", 7, 33624},
	{"DEQU", 4, 33625},
	{"CORNWALL", 8, 33626},
	{"INNOVATIVE", 10, 33627},
	{"EATD", 4, 33628},
	{"FAVORS", 6, 33629},
	{"GENRE", 5, 33630},
	{"RBER", 4, 33631},
	{"ULDW", 4, 33632},
	{"OWSE", 4, 33633},
	{"RETAILER", 8, 33634},
	{"WERO", 4, 33635},
	{"TOJU", 4, 33636},
	{"EXPLICITLY", 10, 33637},
	{"STICKS", 6, 33638},
	{"ARYM", 4, 33639},
	{"LEONE", 5, 33640},
	{"YOWN", 4, 33641},
	{"ODSA", 4, 33642},
	{"EINR", 4, 33643},
	{"IGHP", 4, 33644},
	{"MOMENTUM", 8, 33645},
	{"REPORTEDLY", 10, 33646},
	{"NGVI", 4, 33647},
	{"ENAF", 4, 33648},
	{"AIRW", 4, 33649},
	{"REFORMS", 7, 33650},
	{"REBR", 4, 33651},
	{"XTYE", 4, 33652},
	{"EXPLOIT", 7, 33653},
	{"ACKC", 4, 33654},
	{"PRELIMINARY", 11, 33655},
	{"NGRU", 4, 33656},
	{"RERI", 4, 33657},
	{"ISOP", 4, 33658},
	{"HPAR", 4, 33659},
	{"RLON", 4, 33660},
	{"MPON", 4, 33661},
	{"STRAND", 6, 33662},
	{"JDU", 3, 33663},
	{"BITO", 4, 33664},
	{"PASSING", 7, 33665},
	{"FROWN", 5, 33666},
	{"CKNO", 4, 33667},
	{"ALCR", 4, 33668},
	{"GCOU", 4, 33669},
	{"ALTO", 4, 33670},
	{"INFORMATIVE", 11, 33671},
	{"BLOOMBERG", 9, 33672},
	{"TDUR", 4, 33673},
	{"OOLB", 4, 33674},
	{"CHEQUE", 6, 33675},
	{"YGRA", 4, 33676},
	{"HIERARCHY", 9, 33677},
	{"STIMULATE", 9, 33678},
	{"INFLUENCED", 10, 33679},
	{"BANNERS", 7, 33680},
	{"FRONTIER", 8, 33681},
	{"AHUG", 4, 33682},
	{"EBIR", 4, 33683},
	{"ENFL", 4, 33684},
	{"URLI", 4, 33685},
	{"YLIF", 4, 33686},
	{"ENSW", 4, 33687},
	{"CZI", 3, 33688},
	{"ABANDONED", 9, 33689},
	{"IERC", 4, 33690},
	{"KNOWN", 5, 33691},
	{"CIRCLES", 7, 33692},
	{"YALT", 4, 33693},
	{"ITALIC", 6, 33694},
	{"DHEH", 4, 33695},
	{"BEATS", 5, 33696},
	{"BACKYARD", 8, 33697},
	{"IRHO", 4, 33698},
	{"SCUBA", 5, 33699},
	{"OIDE", 4, 33700},
	{"ARBU", 4, 33701},
	{"FZU", 3, 33702},
	{"RDEF", 4, 33703},
	{"NYWH", 4, 33704},
	{"SPELL", 5, 33705},
	{"EYNE", 4, 33706},
	{"EDAV", 4, 33707},
	{"UMPT", 4, 33708},
	{"GORE", 4, 33709},
	{"CEBO", 4, 33710},
	{"CORRECTLY", 9, 33711},
	{"NOTEBOOK", 8, 33712},
	{"COMPLEMENT", 10, 33713},
	{"NGOI", 4, 33714},
	{"SENSATION", 9, 33715},
	{"PARTIALLY", 9, 33716},
	{"HARASSMENT", 10, 33717},
	{"PROCESSOR", 9, 33718},
	{"OBEM", 4, 33719},
	{"ORYS", 4, 33720},
	{"CULT", 4, 33721},
	{"DEPL", 4, 33722},
	{"SPHERE", 6, 33723},
	{"DASH", 4, 33724},
	{"PASSIVE", 7, 33725},
	{"OTRY", 4, 33726},
	{"MAURITIUS", 9, 33727},
	{"TISD", 4, 33728},
	{"GINF", 4, 33729},
	{"SACK", 4, 33730},
	{"TRAUMA", 6, 33731},
	{"TFRE", 4, 33732},
	{"VALUED", 6, 33733},
	{"DISCLOSE", 8, 33734},
	{"RTSW", 4, 33735},
	{"IUW", 3, 33736},
	{"EJL", 3, 33737},
	{"IJUS", 4, 33738},
	{"CHECKLIST", 9, 33739},
	{"RTFR", 4, 33740},
	{"BANGBUS", 7, 33741},
	{"EGRI", 4, 33742},
	{"REQUESTING", 10, 33743},
	{"VERDE", 5, 33744},
	{"LAUDERDALE", 10, 33745},
	{"HFRO", 4, 33746},
	{"FEVER", 5, 33747},
	{"ORVI", 4, 33748},
	{"EUSU", 4, 33749},
	{"SCENARIOS", 9, 33750},
	{"GAZETTE", 7, 33751},
	{"ANYL", 4, 33752},
	{"HITACHI", 7, 33753},
	{"DIVX", 4, 33754},
	{"TERRAIN", 7, 33755},
	{"EXTRACTION", 10, 33756},
	{"BATMAN", 6, 33757},
	{"TOLERATE", 8, 33758},
	{"EPTO", 4, 33759},
	{"ELEVATION", 9, 33760},
	{"AYSP", 4, 33761},
	{"ENCOURAGING", 11, 33762},
	{"ALLN", 4, 33763},
	{"HEARINGS", 8, 33764},
	{"COLEMAN", 7, 33765},
	{"ZBY", 3, 33766},
	{"MEVE", 4, 33767},
	{"HUGH", 4, 33768},
	{"MEDF", 4, 33769},
	{"UTILIZATION", 11, 33770},
	{"BEVERAGES", 9, 33771},
	{"TLYO", 4, 33772},
	{"CALIBRATION", 11, 33773},
	{"JAKE", 4, 33774},
	{"ENEG", 4, 33775},
	{"EVAL", 4, 33776},
	{"EFFICIENTLY", 11, 33777},
	{"ANAHEIM", 7, 33778},
	{"UYIN", 4, 33779},
	{"OUTLINE", 7, 33780},
	{"THANKSGIVING", 12, 33781},
	{"ECTW", 4, 33782},
	{"PING", 4, 33783},
	{"HYEA", 4, 33784},
	{"STACK", 5, 33785},
	{"DEXT", 4, 33786},
	{"TSDI", 4, 33787},
	{"RSNO", 4, 33788},
	{"GUME", 4, 33789},
	{"DASO", 4, 33790},
	{"ELTI", 4, 33791},
	{"ENTERTAINING", 12, 33792},
	{"SLEEVE", 6, 33793},
	{"PREREQUISITE", 12, 33794},
	{"AGGE", 4, 33795},
	{"TOEV", 4, 33796},
	{"LUTHER", 6, 33797},
	{"EXCLUSIVELY", 11, 33798},
	{"TOOU", 4, 33799},
	{"OOLD", 4, 33800},
	{"STOPPING", 8, 33801},
	{"REFUGEES", 8, 33802},
	{"OUTFIT", 6, 33803},
	{"KNIGHTS", 7, 33804},
	{"EPQ", 3, 33805},
	{"PALMER", 6, 33806},
	{"AUTONOMY", 8, 33807},
	{"THLA", 4, 33808},
	{"MEDICINES", 9, 33809},
	{"UISH", 4, 33810},
	{"FLUX", 4, 33811},
	{"AMBASSADOR", 10, 33812},
	{"STGO", 4, 33813},
	{"RZS", 3, 33814},
	{"TNOR", 4, 33815},
	{"OCEE", 4, 33816},
	{"DERBY", 5, 33817},
	{"RGUM", 4, 33818},
	{"TRAINER", 7, 33819},
	{"EWOO", 4, 33820},
	{"ALTERED", 7, 33821},
	{"THBA", 4, 33822},
	{"EQUALITY", 8, 33823},
	{"PONTIAC", 7, 33824},
	{"REGRESSION", 10, 33825},
	{"YXA", 3, 33826},
	{"RNAR", 4, 33827},
	{"URYA", 4, 33828},
	{"GTOL", 4, 33829},
	{"YREM", 4, 33830},
	{"SCENIC", 6, 33831},
	{"TRAINERS", 8, 33832},
	{"MUZE", 4, 33833},
	{"YLIK", 4, 33834},
	{"LLYU", 4, 33835},
	{"NSWO", 4, 33836},
	{"YWHA", 4, 33837},
	{"ENHANCEMENTS", 12, 33838},
	{"ELAK", 4, 33839},
	{"RENEWABLE", 9, 33840},
	{"DEDM", 4, 33841},
	{"INTERSECTION", 12, 33842},
	{"YTOL", 4, 33843},
	{"TCOA", 4, 33844},
	{"ESEF", 4, 33845},
	{"LCZ", 3, 33846},
	{"PASSWORDS", 9, 33847},
	{"SEWING", 6, 33848},
	{"SUDD", 4, 33849},
	{"CONSISTENCY", 11, 33850},
	{"AISLE", 5, 33851},
	{"COLLECTORS", 10, 33852},
	{"GRANDCHILD", 10, 33853},
	{"SURROUNDING", 11, 33854},
	{"STREAK", 6, 33855},
	{"FLYI", 4, 33856},
	{"RECOGNISED", 10, 33857},
	{"MUNICH", 6, 33858},
	{"OMAN", 4, 33859},
	{"DQUO", 4, 33860},
	{"ELYH", 4, 33861},
	{"CELEBS", 6, 33862},
	{"ENMI", 4, 33863},
	{"AMPE", 4, 33864},
	{"GMC", 3, 33865},
	{"LIKEWISE", 8, 33866},
	{"BBLE", 4, 33867},
	{"THRA", 4, 33868},
	{"CHEAT", 5, 33869},
	{"KSWI", 4, 33870},
	{"IRONY", 5, 33871},
	{"GESW", 4, 33872},
	{"AZERBAIJAN", 10, 33873},
	{"LIGHTER", 7, 33874},
	{"CPRO", 4, 33875},
	{"ADSL", 4, 33876},
	{"EIGHTH", 6, 33877},
	{"SOCIALLY", 8, 33878},
	{"STANCE", 6, 33879},
	{"MPSO", 4, 33880},
	{"ITYD", 4, 33881},
	{"QUH", 3, 33882},
	{"TRASH", 5, 33883},
	{"PRIX", 4, 33884},
	{"HEOV", 4, 33885},
	{"DISCOUNT", 8, 33886},
	{"VECH", 4, 33887},
	{"ASTROLOGY", 9, 33888},
	{"ADVISORS", 8, 33889},
	{"PAVILION", 8, 33890},
	{"EESP", 4, 33891},
	{"LREP", 4, 33892},
	{"TACTICS", 7, 33893},
	{"AWAKE", 5, 33894},
	{"TRUSTS", 6, 33895},
	{"ATBO", 4, 33896},
	{"OCCURRING", 9, 33897},
	{"GROSS", 5, 33898},
	{"RFIE", 4, 33899},
	{"SUPPLEMENTAL", 12, 33900},
	{"NOFW", 4, 33901},
	{"TRAVELLING", 10, 33902},
	{"DBYF", 4, 33903},
	{"NTPE", 4, 33904},
	{"UNPRECEDENTED", 13, 33905},
	{"BREATHING", 9, 33906},
	{"THLI", 4, 33907},
	{"ANNIE", 5, 33908},
	{"OPAN", 4, 33909},
	{"ALRO", 4, 33910},
	{"WOFT", 4, 33911},
	{"HEAL", 4, 33912},
	{"PLANNER", 7, 33913},
	{"INDUCTION", 9, 33914},
	{"DEREK", 5, 33915},
	{"LLBA", 4, 33916},
	{"SHORTER", 7, 33917},
	{"XIG", 3, 33918},
	{"HARLEY", 6, 33919},
	{"SPREADING", 9, 33920},
	{"PROVINCES", 9, 33921},
	{"MENTALLY", 8, 33922},
	{"RELYING", 7, 33923},
	{"OTJU", 4, 33924},
	{"NSSU", 4, 33925},
	{"NFIL", 4, 33926},
	{"DBYE", 4, 33927},
	{"UOJ", 3, 33928},
	{"TYAR", 4, 33929},
	{"COLLAR", 6, 33930},
	{"UMPI", 4, 33931},
	{"FINALS", 6, 33932},
	{"LIKELIHOOD", 10, 33933},
	{"DLEO", 4, 33934},
	{"PARAGUAY", 8, 33935},
	{"XAMI", 4, 33936},
	{"ROD", 3, 33937},
	{"OMEU", 4, 33938},
	{"PARCEL", 6, 33939},
	{"REFINED", 7, 33940},
	{"BYAL", 4, 33941},
	{"ARSF", 4, 33942},
	{"STGR", 4, 33943},
	{"MORTALITY", 9, 33944},
	{"OUSR", 4, 33945},
	{"WELL-KNOWN", 10, 33946},
	{"FLEET", 5, 33947},
	{"WORLDWIDE", 9, 33948},
	{"NGSL", 4, 33949},
	{"INCIDENCE", 9, 33950},
	{"LLSP", 4, 33951},
	{"XUD", 3, 33952},
	{"NGSB", 4, 33953},
	{"RYSI", 4, 33954},
	{"TSME", 4, 33955},
	{"DNEA", 4, 33956},
	{"SPRINKLE", 8, 33957},
	{"TLYF", 4, 33958},
	{"LTAK", 4, 33959},
	{"FEARS", 5, 33960},
	{"ISEV", 4, 33961},
	{"BOUTIQUE", 8, 33962},
	{"LBES", 4, 33963},
	{"ACRYLIC", 7, 33964},
	{"COLORFUL", 8, 33965},
	{"ARTIFACT", 8, 33966},
	{"ROLLED", 6, 33967},
	{"SANF", 4, 33968},
	{"YDEF", 4, 33969},
	{"TUNER", 5, 33970},
	{"ACKM", 4, 33971},
	{"AVON", 4, 33972},
	{"SHED", 4, 33973},
	{"OMSO", 4, 33974},
	{"WEDA", 4, 33975},
	{"INSTANT", 7, 33976},
	{"DINJ", 4, 33977},
	{"TBEG", 4, 33978},
	{"NONP", 4, 33979},
	{"INCIDENTS", 9, 33980},
	{"YMOV", 4, 33981},
	{"CONFRONTATION", 13, 33982},
	{"MILL", 4, 33983},
	{"MIDST", 5, 33984},
	{"PETERSON", 8, 33985},
	{"ENUN", 4, 33986},
	{"RAYS", 4, 33987},
	{"LEDR", 4, 33988},
	{"SHANNON", 7, 33989},
	{"MINERAL", 7, 33990},
	{"UBUR", 4, 33991},
	{"NTAF", 4, 33992},
	{"DBYD", 4, 33993},
	{"MENTOR", 6, 33994},
	{"UMQ", 3, 33995},
	{"RKQ", 3, 33996},
	{"TODDLER", 7, 33997},
	{"EEKL", 4, 33998},
	{"TBOT", 4, 33999},
	{"ENHANCING", 9, 34000},
	{"PIONEER", 7, 34001},
	{"LAWMAKER", 8, 34002},
	{"MUTTER", 6, 34003},
	{"WALT", 4, 34004},
	{"ARYR", 4, 34005},
	{"METALLIC", 8, 34006},
	{"NGCE", 4, 34007},
	{"ACNE", 4, 34008},
	{"BLOCKED", 7, 34009},
	{"TOFN", 4, 34010},
	{"OTMA", 4, 34011},
	{"HDAY", 4, 34012},
	{"EAKT", 4, 34013},
	{"ONIG", 4, 34014},
	{"SOMEDAY", 7, 34015},
	{"FEATHER", 7, 34016},
	{"INTERFERENCE", 12, 34017},
	{"XYB", 3, 34018},
	{"DINR", 4, 34019},
	{"WARRIORS", 8, 34020},
	{"GHLI", 4, 34021},
	{"NGOL", 4, 34022},
	{"PALESTINE", 9, 34023},
	{"SHAREHOLDER", 11, 34024},
	{"GMAR", 4, 34025},
	{"PROU", 4, 34026},
	{"YBH", 3, 34027},
	{"RSUR", 4, 34028},
	{"EDAI", 4, 34029},
	{"ALIKE", 5, 34030},
	{"KEYO", 4, 34031},
	{"LISTPRICE", 9, 34032},
	{"TFIE", 4, 34033},
	{"DBEH", 4, 34034},
	{"ZPU", 3, 34035},
	{"ASEF", 4, 34036},
	{"LIBS", 4, 34037},
	{"UNDO", 4, 34038},
	{"CADILLAC", 8, 34039},
	{"SWIMMING", 8, 34040},
	{"ATMOSPHERIC", 11, 34041},
	{"MALAWI", 6, 34042},
	{"ENPO", 4, 34043},
	{"OTLA", 4, 34044},
	{"CUTO", 4, 34045},
	{"BOAST", 5, 34046},
	{"PHILOSOPHICAL", 13, 34047},
	{"SAGEM", 5, 34048},
	{"FTHR", 4, 34049},
	{"KNOWLEDGESTORM", 14, 34050},
	{"DANA", 4, 34051},
	{"WHEAT", 5, 34052},
	{"RKOF", 4, 34053},
	{"LBEH", 4, 34054},
	{"IRDE", 4, 34055},
	{"HALO", 4, 34056},
	{"PPM", 3, 34057},
	{"ACHW", 4, 34058},
	{"COMPEL", 6, 34059},
	{"NEDP", 4, 34060},
	{"CURTIS", 6, 34061},
	{"BEHALF", 6, 34062},
	{"VOCAL", 5, 34063},
	{"OPSA", 4, 34064},
	{"DTEL", 4, 34065},
	{"REFERENCED", 10, 34066},
	{"NOTJ", 4, 34067},
	{"PARISH", 6, 34068},
	{"STRIKES", 7, 34069},
	{"LESSER", 6, 34070},
	{"XEG", 3, 34071},
	{"MARATHON", 8, 34072},
	{"YOUB", 4, 34073},
	{"SORR", 4, 34074},
	{"DISTRACT", 8, 34075},
	{"LADDER", 6, 34076},
	{"BUILDER", 7, 34077},
	{"NEMY", 4, 34078},
	{"FEMINIST", 8, 34079},
	{"PROPOSITION", 11, 34080},
	{"CARROT", 6, 34081},
	{"UZY", 3, 34082},
	{"ITOU", 4, 34083},
	{"GAYS", 4, 34084},
	{"PRESSING", 8, 34085},
	{"ERYH", 4, 34086},
	{"ELLM", 4, 34087},
	{"PROCLAIM", 8, 34088},
	{"PARTIAL", 7, 34089},
	{"FEWM", 4, 34090},
	{"SOPR", 4, 34091},
	{"OFAU", 4, 34092},
	{"EAFO", 4, 34093},
	{"DRESSED", 7, 34094},
	{"WERP", 4, 34095},
	{"LLPE", 4, 34096},
	{"SEDD", 4, 34097},
	{"YSIT", 4, 34098},
	{"SCOUT", 5, 34099},
	{"BELFAST", 7, 34100},
	{"EXEC", 4, 34101},
	{"SLAVERY", 7, 34102},
	{"DEALT", 5, 34103},
	{"ALCE", 4, 34104},
	{"SSRE", 4, 34105},
	{"NIAGARA", 7, 34106},
	{"GPRE", 4, 34107},
	{"INTERFERE", 9, 34108},
	{"SIMILARITY", 10, 34109},
	{"INTERVAL", 8, 34110},
	{"WARCRAFT", 8, 34111},
	{"CHARMS", 6, 34112},
	{"CATALYST", 8, 34113},
	{"ARTB", 4, 34114},
	{"TRADER", 6, 34115},
	{"BUCKS", 5, 34116},
	{"IREW", 4, 34117},
	{"IUY", 3, 34118},
	{"ALLOWANCE", 9, 34119},
	{"DESPERATELY", 11, 34120},
	{"OLTH", 4, 34121},
	{"VCR", 3, 34122},
	{"RKTO", 4, 34123},
	{"SPECULATION", 11, 34124},
	{"MONKEY", 6, 34125},
	{"UNCOVER", 7, 34126},
	{"EDCL", 4, 34127},
	{"RHEW", 4, 34128},
	{"URI", 3, 34129},
	{"PREMISE", 7, 34130},
	{"HALFWAY", 7, 34131},
	{"DESIGNATION", 11, 34132},
	{"RYBE", 4, 34133},
	{"ALFT", 4, 34134},
	{"JUNGLE", 6, 34135},
	{"THROWN", 6, 34136},
	{"JURISDICTION", 12, 34137},
	{"NOFE", 4, 34138},
	{"PREPAID", 7, 34139},
	{"OUTSIDER", 8, 34140},
	{"SNEAK", 5, 34141},
	{"KPLA", 4, 34142},
	{"RGOT", 4, 34143},
	{"RAISES", 6, 34144},
	{"UALC", 4, 34145},
	{"ILYI", 4, 34146},
	{"GEM", 3, 34147},
	{"RFRI", 4, 34148},
	{"DUPLICATE", 9, 34149},
	{"ELECTRO", 7, 34150},
	{"BYST", 4, 34151},
	{"VEPL", 4, 34152},
	{"CRITERION", 9, 34153},
	{"ACKD", 4, 34154},
	{"BADGE", 5, 34155},
	{"JOURNALISM", 10, 34156},
	{"THEOLOGICAL", 11, 34157},
	{"YSUC", 4, 34158},
	{"EOFY", 4, 34159},
	{"UNDERGRADUATE", 13, 34160},
	{"NASTY", 5, 34161},
	{"CHUNK", 5, 34162},
	{"PLEB", 4, 34163},
	{"REMINDER", 8, 34164},
	{"HIGH-TECH", 9, 34165},
	{"ORAW", 4, 34166},
	{"AGEH", 4, 34167},
	{"QBT", 3, 34168},
	{"CEASE", 5, 34169},
	{"ANALYZED", 8, 34170},
	{"VIETNAMESE", 10, 34171},
	{"HEATH", 5, 34172},
	{"LEPO", 4, 34173},
	{"CLING", 5, 34174},
	{"ISQU", 4, 34175},
	{"ULDO", 4, 34176},
	{"RIM", 3, 34177},
	{"DYOF", 4, 34178},
	{"CHILL", 5, 34179},
	{"ONGP", 4, 34180},
	{"ATGR", 4, 34181},
	{"LEXUS", 5, 34182},
	{"KINGDOM", 7, 34183},
	{"DEPLOY", 6, 34184},
	{"LIGHTNING", 9, 34185},
	{"OPEF", 4, 34186},
	{"VARYING", 7, 34187},
	{"REMEDIES", 8, 34188},
	{"ANTD", 4, 34189},
	{"OBEO", 4, 34190},
	{"TRUSTEE", 7, 34191},
	{"MAUI", 4, 34192},
	{"UTOU", 4, 34193},
	{"MERIT", 5, 34194},
	{"WHEELCHAIR", 10, 34195},
	{"YCZ", 3, 34196},
	{"CHEW", 4, 34197},
	{"OUSW", 4, 34198},
	{"WEIGHTED", 8, 34199},
	{"ANGOLA", 6, 34200},
	{"SQUIRT", 6, 34201},
	{"TSJU", 4, 34202},
	{"ITHV", 4, 34203},
	{"UGHN", 4, 34204},
	{"PERFORMS", 8, 34205},
	{"PLASTICS", 8, 34206},
	{"TIGHTEN", 7, 34207},
	{"NYPE", 4, 34208},
	{"NGFE", 4, 34209},
	{"ISMU", 4, 34210},
	{"TWOF", 4, 34211},
	{"DIP", 3, 34212},
	{"DHOU", 4, 34213},
	{"YTOF", 4, 34214},
	{"NINM", 4, 34215},
	{"CORRECTED", 9, 34216},
	{"SUPPORTIVE", 10, 34217},
	{"RIB", 3, 34218},
	{"FBEI", 4, 34219},
	{"OOMU", 4, 34220},
	{"TQB", 3, 34221},
	{"JENNY", 5, 34222},
	{"COMMODITY", 9, 34223},
	{"SALARIES", 8, 34224},
	{"POSTCARD", 8, 34225},
	{"STVI", 4, 34226},
	{"UNFAIR", 6, 34227},
	{"RDAT", 4, 34228},
	{"ELEP", 4, 34229},
	{"YEMEN", 5, 34230},
	{"INVADE", 6, 34231},
	{"LLSW", 4, 34232},
	{"OINV", 4, 34233},
	{"MANP", 4, 34234},
	{"ELYN", 4, 34235},
	{"FUW", 3, 34236},
	{"ENCOUNTERED", 11, 34237},
	{"TRYW", 4, 34238},
	{"MARKETPLACE", 11, 34239},
	{"ENPE", 4, 34240},
	{"TSUNAMI", 7, 34241},
	{"NHOL", 4, 34242},
	{"CEOR", 4, 34243},
	{"LEHO", 4, 34244},
	{"YBEG", 4, 34245},
	{"AUQ", 3, 34246},
	{"NICKEL", 6, 34247},
	{"RSEI", 4, 34248},
	{"SLEG", 4, 34249},
	{"HSPE", 4, 34250},
	{"LOGICAL", 7, 34251},
	{"INTERNATIONALLY", 15, 34252},
	{"LSYS", 4, 34253},
	{"SURROUNDED", 10, 34254},
	{"ATBU", 4, 34255},
	{"BUSES", 5, 34256},
	{"EXPEDIA", 7, 34257},
	{"GEOLOGY", 7, 34258},
	{"WEED", 4, 34259},
	{"RBET", 4, 34260},
	{"PCT", 3, 34261},
	{"CREATURES", 9, 34262},
	{"COATING", 7, 34263},
	{"EJV", 3, 34264},
	{"COMMENTED", 9, 34265},
	{"WALLET", 6, 34266},
	{"WEAKEN", 6, 34267},
	{"CLEARED", 7, 34268},
	{"IFEO", 4, 34269},
	{"RMEM", 4, 34270},
	{"OLVI", 4, 34271},
	{"NEDM", 4, 34272},
	{"DEEM", 4, 34273},
	{"EISD", 4, 34274},
	{"IDSO", 4, 34275},
	{"GETR", 4, 34276},
	{"SMILIES", 7, 34277},
	{"OYIN", 4, 34278},
	{"OGRO", 4, 34279},
	{"NFUS", 4, 34280},
	{"HEEF", 4, 34281},
	{"VIDS", 4, 34282},
	{"SKIP", 4, 34283},
	{"BOATING", 7, 34284},
	{"DRAINAGE", 8, 34285},
	{"EXCESSIVE", 9, 34286},
	{"RFAT", 4, 34287},
	{"RISKY", 5, 34288},
	{"RTUA", 4, 34289},
	{"EWTO", 4, 34290},
	{"SHAKIRA", 7, 34291},
	{"TYSE", 4, 34292},
	{"CORNERS", 7, 34293},
	{"CURIOSITY", 9, 34294},
	{"BROADER", 7, 34295},
	{"SCRATCH", 7, 34296},
	{"VEGETARIAN", 10, 34297},
	{"HGRA", 4, 34298},
	{"UXR", 3, 34299},
	{"KYY", 3, 34300},
	{"LVAN", 4, 34301},
	{"ROUGE", 5, 34302},
	{"CEWE", 4, 34303},
	{"YEAST", 5, 34304},
	{"EMBARRASSED", 11, 34305},
	{"CONVERSION", 10, 34306},
	{"TLYH", 4, 34307},
	{"YALE", 4, 34308},
	{"UGHC", 4, 34309},
	{"NEWFOUNDLAND", 12, 34310},
	{"DEDP", 4, 34311},
	{"OTUR", 4, 34312},
	{"QLD", 3, 34313},
	{"OEAR", 4, 34314},
	{"OGOO", 4, 34315},
	{"FIERCE", 6, 34316},
	{"SPECIALTY", 9, 34317},
	{"UVU", 3, 34318},
	{"GEWH", 4, 34319},
	{"CLEARING", 8, 34320},
	{"INVESTIGATED", 12, 34321},
	{"LISTENER", 8, 34322},
	{"AUCTION", 7, 34323},
	{"OSTB", 4, 34324},
	{"NVIL", 4, 34325},
	{"FHEA", 4, 34326},
	{"RCEM", 4, 34327},
	{"USPR", 4, 34328},
	{"WAYB", 4, 34329},
	{"LEDP", 4, 34330},
	{"ENVISION", 8, 34331},
	{"RALLY", 5, 34332},
	{"UGET", 4, 34333},
	{"OWSI", 4, 34334},
	{"OWEE", 4, 34335},
	{"SHRINK", 6, 34336},
	{"ADDED", 5, 34337},
	{"COATED", 6, 34338},
	{"FTAN", 4, 34339},
	{"STEPHANIE", 9, 34340},
	{"YOFW", 4, 34341},
	{"FULF", 4, 34342},
	{"BRIDE", 5, 34343},
	{"EDIB", 4, 34344},
	{"RYBU", 4, 34345},
	{"CONTACTING", 10, 34346},
	{"VEGETATION", 10, 34347},
	{"DOOM", 4, 34348},
	{"FINDARTICLES", 12, 34349},
	{"NFOL", 4, 34350},
	{"LOUISE", 6, 34351},
	{"KENNY", 5, 34352},
	{"UGAR", 4, 34353},
	{"SPECIALLY", 9, 34354},
	{"PEASANT", 7, 34355},
	{"OWEN", 4, 34356},
	{"TOPM", 4, 34357},
	{"ROUTINES", 8, 34358},
	{"HITTING", 7, 34359},
	{"DOFP", 4, 34360},
	{"YUKON", 5, 34361},
	{"ASSW", 4, 34362},
	{"NTEC", 4, 34363},
	{"NFIG", 4, 34364},
	{"BEINGS", 6, 34365},
	{"AYSF", 4, 34366},
	{"PEANUT", 6, 34367},
	{"HTHR", 4, 34368},
	{"AQUATIC", 7, 34369},
	{"CITIZENSHIP", 11, 34370},
	{"RELIANCE", 8, 34371},
	{"UMOF", 4, 34372},
	{"EKSA", 4, 34373},
	{"GUED", 4, 34374},
	{"SOWH", 4, 34375},
	{"ASGI", 4, 34376},
	{"COMPARABLE", 10, 34377},
	{"ONOV", 4, 34378},
	{"HABITS", 6, 34379},
	{"YOFL", 4, 34380},
	{"SAFR", 4, 34381},
	{"INFECTIOUS", 10, 34382},
	{"PODCASTS", 8, 34383},
	{"STEAK", 5, 34384},
	{"GEDB", 4, 34385},
	{"SINGH", 5, 34386},
	{"ANER", 4, 34387},
	{"GIG", 3, 34388},
	{"ITRA", 4, 34389},
	{"GILBERT", 7, 34390},
	{"FERRARI", 7, 34391},
	{"VEWO", 4, 34392},
	{"FWIT", 4, 34393},
	{"LEGISLATOR", 10, 34394},
	{"RTCO", 4, 34395},
	{"CONTINUITY", 10, 34396},
	{"LYFA", 4, 34397},
	{"BROOK", 5, 34398},
	{"DCLO", 4, 34399},
	{"OUTPUTS", 7, 34400},
	{"TWES", 4, 34401},
	{"MEUP", 4, 34402},
	{"SLAU", 4, 34403},
	{"TINB", 4, 34404},
	{"ENSEMBLE", 8, 34405},
	{"TOLL", 4, 34406},
	{"INSULIN", 7, 34407},
	{"NDET", 4, 34408},
	{"ASSURED", 7, 34409},
	{"BIBLICAL", 8, 34410},
	{"BLANK", 5, 34411},
	{"ECEP", 4, 34412},
	{"NOFR", 4, 34413},
	{"RTHD", 4, 34414},
	{"CEMETERY", 8, 34415},
	{"MYSIMON", 7, 34416},
	{"WIVES", 5, 34417},
	{"AMBIENT", 7, 34418},
	{"PSOF", 4, 34419},
	{"ATOP", 4, 34420},
	{"MILEAGE", 7, 34421},
	{"CALCULATION", 11, 34422},
	{"KKY", 3, 34423},
	{"OECD", 4, 34424},
	{"ITEF", 4, 34425},
	{"PROSTATE", 8, 34426},
	{"POKE", 4, 34427},
	{"ADAPTOR", 7, 34428},
	{"LDHI", 4, 34429},
	{"AUBURN", 6, 34430},
	{"UNLOCK", 6, 34431},
	{"HYUNDAI", 7, 34432},
	{"PLEDGE", 6, 34433},
	{"LEPL", 4, 34434},
	{"VAMPIRE", 7, 34435},
	{"ANGELA", 6, 34436},
	{"RELATES", 7, 34437},
	{"NHOM", 4, 34438},
	{"VENC", 4, 34439},
	{"GSWE", 4, 34440},
	{"EENU", 4, 34441},
	{"NITROGEN", 8, 34442},
	{"XEROX", 5, 34443},
	{"ELYM", 4, 34444},
	{"DPUB", 4, 34445},
	{"DICE", 4, 34446},
	{"MERGER", 6, 34447},
	{"SOFTBALL", 8, 34448},
	{"REFERRALS", 9, 34449},
	{"GLIMPSE", 7, 34450},
	{"QUAD", 4, 34451},
	{"FIREWIRE", 8, 34452},
	{"MODS", 4, 34453},
	{"NEXTEL", 6, 34454},
	{"YWOO", 4, 34455},
	{"FRAMING", 7, 34456},
	{"MESM", 4, 34457},
	{"KSTA", 4, 34458},
	{"INHERIT", 7, 34459},
	{"VESF", 4, 34460},
	{"RVET", 4, 34461},
	{"ORGANISED", 9, 34462},
	{"NDHU", 4, 34463},
	{"RNSA", 4, 34464},
	{"GELI", 4, 34465},
	{"OPENLY", 6, 34466},
	{"TWO-THIRDS", 10, 34467},
	{"BLOCKING", 8, 34468},
	{"PUBLICITY", 9, 34469},
	{"DTHU", 4, 34470},
	{"RWANDA", 6, 34471},
	{"TFEW", 4, 34472},
	{"SVIS", 4, 34473},
	{"THFR", 4, 34474},
	{"SORTS", 5, 34475},
	{"INTEGRATING", 11, 34476},
	{"VSNET", 5, 34477},
	{"LIMITING", 8, 34478},
	{"UPSE", 4, 34479},
	{"DISPATCH", 8, 34480},
	{"REVISIONS", 9, 34481},
	{"HSOF", 4, 34482},
	{"OFJA", 4, 34483},
	{"THTW", 4, 34484},
	{"DDAN", 4, 34485},
	{"PAPUA", 5, 34486},
	{"RESTORED", 8, 34487},
	{"ARMOR", 5, 34488},
	{"RIDERS", 6, 34489},
	{"CHARGERS", 8, 34490},
	{"FCOL", 4, 34491},
	{"DOZENS", 6, 34492},
	{"VARIES", 6, 34493},
	{"ULLT", 4, 34494},
	{"NXC", 3, 34495},
	{"OUPA", 4, 34496},
	{"OTAP", 4, 34497},
	{"ICHL", 4, 34498},
	{"REHABILITATION", 14, 34499},
	{"MSIE", 4, 34500},
	{"REASONING", 9, 34501},
	{"MEAG", 4, 34502},
	{"MEPL", 4, 34503},
	{"DSUR", 4, 34504},
	{"DEPRESSED", 9, 34505},
	{"VENDOR", 6, 34506},
	{"GETB", 4, 34507},
	{"EUSI", 4, 34508},
	{"LIZ", 3, 34509},
	{"ROMU", 4, 34510},
	{"RENDERED", 8, 34511},
	{"SOVEREIGNTY", 11, 34512},
	{"PICKING", 7, 34513},
	{"SDUE", 4, 34514},
	{"ONTG", 4, 34515},
	{"LHER", 4, 34516},
	{"CHARITABLE", 10, 34517},
	{"GUARDS", 6, 34518},
	{"YCLA", 4, 34519},
	{"ANNOTATED", 9, 34520},
	{"CCD", 3, 34521},
	{"OPENINGS", 8, 34522},
	{"YWW", 3, 34523},
	{"YFF", 3, 34524},
	{"FASTER", 6, 34525},
	{"BUYS", 4, 34526},
	{"MBLY", 4, 34527},
	{"MUNICIPAL", 9, 34528},
	{"BURLINGTON", 10, 34529},
	{"BUTP", 4, 34530},
	{"GLET", 4, 34531},
	{"RCEI", 4, 34532},
	{"SOLE", 4, 34533},
	{"REPLACING", 9, 34534},
	{"UTLO", 4, 34535},
	{"WATERSHED", 9, 34536},
	{"NEYF", 4, 34537},
	{"COUNCILS", 8, 34538},
	{"OCCUPATIONS", 11, 34539},
	{"YSOU", 4, 34540},
	{"STRICTLY", 8, 34541},
	{"DISTURB", 7, 34542},
	{"FVU", 3, 34543},
	{"ACKNOWLEDGED", 12, 34544},
	{"TONF", 4, 34545},
	{"NUDITY", 6, 34546},
	{"ELIGIBLE", 8, 34547},
	{"OUGE", 4, 34548},
	{"BEARD", 5, 34549},
	{"YMIL", 4, 34550},
	{"KRUGER", 6, 34551},
	{"POCKETS", 7, 34552},
	{"GRANNY", 6, 34553},
	{"LEEA", 4, 34554},
	{"EQUILIBRIUM", 11, 34555},
	{"EWMO", 4, 34556},
	{"GYK", 3, 34557},
	{"KSHA", 4, 34558},
	{"BRAKE", 5, 34559},
	{"VIRAL", 5, 34560},
	{"KOFA", 4, 34561},
	{"NEBU", 4, 34562},
	{"GETE", 4, 34563},
	{"INQUIRE", 7, 34564},
	{"SQUAD", 5, 34565},
	{"LVU", 3, 34566},
	{"INKW", 4, 34567},
	{"PIPES", 5, 34568},
	{"CHARACTERIZED", 13, 34569},
	{"LADEN", 5, 34570},
	{"OTWA", 4, 34571},
	{"ARUBA", 5, 34572},
	{"COTTAGES", 8, 34573},
	{"STRIKING", 8, 34574},
	{"NSOC", 4, 34575},
	{"REALTOR", 7, 34576},
	{"MERGE", 5, 34577},
	{"TOLERANCE", 9, 34578},
	{"JJO", 3, 34579},
	{"NGDR", 4, 34580},
	{"EYVE", 4, 34581},
	{"OWLI", 4, 34582},
	{"EDGAR", 5, 34583},
	{"DEVELOPS", 8, 34584},
	{"QUALIFYING", 10, 34585},
	{"VALID", 5, 34586},
	{"SPOW", 4, 34587},
	{"CHASSIS", 7, 34588},
	{"LDCH", 4, 34589},
	{"REAA", 4, 34590},
	{"PROGRAMMING", 11, 34591},
	{"IRMI", 4, 34592},
	{"ARFR", 4, 34593},
	{"CLOSEST", 7, 34594},
	{"XERC", 4, 34595},
	{"DUBAI", 5, 34596},
	{"ESTIMATION", 10, 34597},
	{"PUSHING", 7, 34598},
	{"LLP", 3, 34599},
	{"REFUGE", 6, 34600},
	{"DYING", 5, 34601},
	{"VOLUNTARY", 9, 34602},
	{"FLEECE", 6, 34603},
	{"DDEA", 4, 34604},
	{"PEDIATRIC", 9, 34605},
	{"BOC", 3, 34606},
	{"SFIE", 4, 34607},
	{"EDGA", 4, 34608},
	{"OMIL", 4, 34609},
	{"ASUS", 4, 34610},
	{"PIERCE", 6, 34611},
	{"RESF", 4, 34612},
	{"STYP", 4, 34613},
	{"OADW", 4, 34614},
	{"NROL", 4, 34615},
	{"ALLAN", 5, 34616},
	{"ELAU", 4, 34617},
	{"SOFA", 4, 34618},
	{"DRESSING", 8, 34619},
	{"TECHREPUBLIC", 12, 34620},
	{"SPERM", 5, 34621},
	{"BALD", 4, 34622},
	{"FILME", 5, 34623},
	{"CRAPS", 5, 34624},
	{"FUJI", 4, 34625},
	{"OUTLET", 6, 34626},
	{"DEPOSIT", 7, 34627},
	{"BNX", 3, 34628},
	{"NUIN", 4, 34629},
	{"FROST", 5, 34630},
	{"LEDD", 4, 34631},
	{"THBO", 4, 34632},
	{"LEON", 4, 34633},
	{"LGET", 4, 34634},
	{"INSTITUTES", 10, 34635},
	{"DKIN", 4, 34636},
	{"SPARE", 5, 34637},
	{"MOLD", 4, 34638},
	{"DEBRIS", 6, 34639},
	{"RTHU", 4, 34640},
	{"DAME", 4, 34641},
	{"PLUNGE", 6, 34642},
	{"BUTT", 4, 34643},
	{"THRESHOLD", 9, 34644},
	{"NLOC", 4, 34645},
	{"YERA", 4, 34646},
	{"ADSE", 4, 34647},
	{"RMUL", 4, 34648},
	{"OWYO", 4, 34649},
	{"REMOVAL", 7, 34650},
	{"SALLY", 5, 34651},
	{"YACHT", 5, 34652},
	{"LSEE", 4, 34653},
	{"TRACY", 5, 34654},
	{"PREFERS", 7, 34655},
	{"NMOV", 4, 34656},
	{"DRILLING", 8, 34657},
	{"BROCHURES", 9, 34658},
	{"DUMB", 4, 34659},
	{"BALANCED", 8, 34660},
	{"AUSI", 4, 34661},
	{"UDEA", 4, 34662},
	{"RSTG", 4, 34663},
	{"FAME", 4, 34664},
	{"LTIT", 4, 34665},
	{"TMP", 3, 34666},
	{"ALOT", 4, 34667},
	{"AIDF", 4, 34668},
	{"LEGALLY", 7, 34669},
	{"BREACH", 6, 34670},
	{"OZW", 3, 34671},
	{"FREA", 4, 34672},
	{"TRAVELLER", 9, 34673},
	{"SYLV", 4, 34674},
	{"VESC", 4, 34675},
	{"DNEY", 4, 34676},
	{"HCHA", 4, 34677},
	{"APPROPRIATIONS", 14, 34678},
	{"ISOLATED", 8, 34679},
	{"ISCE", 4, 34680},
	{"SUSPECTED", 9, 34681},
	{"CONSIDERABLY", 12, 34682},
	{"TOMATOES", 8, 34683},
	{"BENCHMARK", 9, 34684},
	{"BEGINNERS", 9, 34685},
	{"INSTRUCTORS", 11, 34686},
	{"HIGHLIGHTED", 11, 34687},
	{"BEDFORD", 7, 34688},
	{"RESM", 4, 34689},
	{"REGRET", 6, 34690},
	{"BLOND", 5, 34691},
	{"STATIONERY", 10, 34692},
	{"OTPR", 4, 34693},
	{"VEPA", 4, 34694},
	{"IDLE", 4, 34695},
	{"ORBR", 4, 34696},
	{"MEBO", 4, 34697},
	{"ICHB", 4, 34698},
	{"MUSTANG", 7, 34699},
	{"DASM", 4, 34700},
	{"RINV", 4, 34701},
	{"UNAUTHORIZED", 12, 34702},
	{"RRIO", 4, 34703},
	{"CLUSTERS", 8, 34704},
	{"ANTIBODY", 8, 34705},
	{"COMPETENT", 9, 34706},
	{"NLYR", 4, 34707},
	{"DAPO", 4, 34708},
	{"WIRING", 6, 34709},
	{"THRIVE", 6, 34710},
	{"NORG", 4, 34711},
	{"RLOO", 4, 34712},
	{"EASM", 4, 34713},
	{"CONSECUTIVE", 11, 34714},
	{"FKW", 3, 34715},
	{"RDIA", 4, 34716},
	{"CURE", 4, 34717},
	{"SLEY", 4, 34718},
	{"CALVIN", 6, 34719},
	{"TCRE", 4, 34720},
	{"EXPEDITION", 10, 34721},
	{"KNEEL", 5, 34722},
	{"FUR", 3, 34723},
	{"LSUP", 4, 34724},
	{"CEND", 4, 34725},
	{"RLAS", 4, 34726},
	{"NPOI", 4, 34727},
	{"DISAPPOINTMENT", 14, 34728},
	{"NEDR", 4, 34729},
	{"REGULATOR", 9, 34730},
	{"UFK", 3, 34731},
	{"EXPLICIT", 8, 34732},
	{"TSDO", 4, 34733},
	{"HUNGER", 6, 34734},
	{"OGYA", 4, 34735},
	{"ARSP", 4, 34736},
	{"DEMONSTRATES", 12, 34737},
	{"PHASES", 6, 34738},
	{"GOAT", 4, 34739},
	{"DRIVEWAY", 8, 34740},
	{"UTEV", 4, 34741},
	{"BANANA", 6, 34742},
	{"TWENTIETH", 9, 34743},
	{"EMERALD", 7, 34744},
	{"LAUGHING", 8, 34745},
	{"GROWS", 5, 34746},
	{"SOLELY", 6, 34747},
	{"DESIRABLE", 9, 34748},
	{"THSU", 4, 34749},
	{"INTEGRATED", 10, 34750},
	{"TRACT", 5, 34751},
	{"BALLET", 6, 34752},
	{"RCHR", 4, 34753},
	{"UMST", 4, 34754},
	{"ABRAHAM", 7, 34755},
	{"STEER", 5, 34756},
	{"COMPLY", 6, 34757},
	{"SUPPOSEDLY", 10, 34758},
	{"ALLEGEDLY", 9, 34759},
	{"SUNC", 4, 34760},
	{"YWC", 3, 34761},
	{"ONQU", 4, 34762},
	{"BUMPER", 6, 34763},
	{"AFTERWARDS", 10, 34764},
	{"WEBPAGE", 7, 34765},
	{"THFI", 4, 34766},
	{"SEEW", 4, 34767},
	{"UTHS", 4, 34768},
	{"MOLECULE", 8, 34769},
	{"RELIGIONS", 9, 34770},
	{"GEFR", 4, 34771},
	{"ANBO", 4, 34772},
	{"NYZ", 3, 34773},
	{"CHEER", 5, 34774},
	{"GSON", 4, 34775},
	{"RTSH", 4, 34776},
	{"HOSTELS", 7, 34777},
	{"ENACT", 5, 34778},
	{"ALAL", 4, 34779},
	{"SENEGAL", 7, 34780},
	{"RPOW", 4, 34781},
	{"HAPT", 4, 34782},
	{"MISSIONARY", 10, 34783},
	{"BVO", 3, 34784},
	{"CRUISE", 6, 34785},
	{"BANNED", 6, 34786},
	{"WENDY", 5, 34787},
	{"ALYE", 4, 34788},
	{"OOLE", 4, 34789},
	{"BRIEFS", 6, 34790},
	{"SIGNATURES", 10, 34791},
	{"ILEW", 4, 34792},
	{"RTYT", 4, 34793},
	{"DIFFS", 5, 34794},
	{"TOURISM", 7, 34795},
	{"COVE", 4, 34796},
	{"RPET", 4, 34797},
	{"RTWA", 4, 34798},
	{"HATJ", 4, 34799},
	{"OILE", 4, 34800},
	{"NEUP", 4, 34801},
	{"DFLO", 4, 34802},
	{"NUTRIENT", 8, 34803},
	{"MUMBAI", 6, 34804},
	{"VEPO", 4, 34805},
	{"OZONE", 5, 34806},
	{"ONDW", 4, 34807},
	{"HPOI", 4, 34808},
	{"DISCIPLINES", 11, 34809},
	{"NSMO", 4, 34810},
	{"CASA", 4, 34811},
	{"OSEV", 4, 34812},
	{"IGHA", 4, 34813},
	{"DAUGHTERS", 9, 34814},
	{"UNFOLD", 6, 34815},
	{"INEVITABLY", 10, 34816},
	{"CONVERSATIONS", 13, 34817},
	{"NFOO", 4, 34818},
	{"ETOK", 4, 34819},
	{"RADIOS", 6, 34820},
	{"FORUM", 5, 34821},
	{"TARIFF", 6, 34822},
	{"TONR", 4, 34823},
	{"NVIDIA", 6, 34824},
	{"OFFENDER", 8, 34825},
	{"NGOP", 4, 34826},
	{"EACR", 4, 34827},
	{"SIMPLIFIED", 10, 34828},
	{"MUSCLES", 7, 34829},
	{"SERUM", 5, 34830},
	{"LIVER", 5, 34831},
	{"RTYO", 4, 34832},
	{"WRAPPED", 7, 34833},
	{"IGNM", 4, 34834},
	{"SUSPICIOUS", 10, 34835},
	{"WWIT", 4, 34836},
	{"SWIFT", 5, 34837},
	{"HARMONY", 7, 34838},
	{"RWER", 4, 34839},
	{"MOTHERBOARD", 11, 34840},
	{"ACCOUNTABILITY", 14, 34841},
	{"LSAL", 4, 34842},
	{"RUNTIME", 7, 34843},
	{"SCREENING", 9, 34844},
	{"INBOX", 5, 34845},
	{"FOCAL", 5, 34846},
	{"BIBLIOGRAPHIC", 13, 34847},
	{"EMSO", 4, 34848},
	{"RLDA", 4, 34849},
	{"LIQU", 4, 34850},
	{"RYSA", 4, 34851},
	{"EDEN", 4, 34852},
	{"INCL", 4, 34853},
	{"NTTR", 4, 34854},
	{"MEPO", 4, 34855},
	{"CHAMPAGNE", 9, 34856},
	{"OUNE", 4, 34857},
	{"DECIMAL", 7, 34858},
	{"ESTG", 4, 34859},
	{"DISC", 4, 34860},
	{"DEVIATION", 9, 34861},
	{"SUPERINTENDENT", 14, 34862},
	{"PROPECIA", 8, 34863},
	{"ENLO", 4, 34864},
	{"NBC", 3, 34865},
	{"SAMBA", 5, 34866},
	{"PREDATOR", 8, 34867},
	{"HOSTEL", 6, 34868},
	{"HOUSEWIVES", 10, 34869},
	{"ITFR", 4, 34870},
	{"TDEA", 4, 34871},
	{"MONGOLIA", 8, 34872},
	{"PENGUIN", 7, 34873},
	{"YXM", 3, 34874},
	{"MAGICAL", 7, 34875},
	{"INFLUENCES", 10, 34876},
	{"ISHW", 4, 34877},
	{"UBMI", 4, 34878},
	{"INSPECTIONS", 11, 34879},
	{"EAMB", 4, 34880},
	{"CEFI", 4, 34881},
	{"IRRIGATION", 10, 34882},
	{"OREY", 4, 34883},
	{"EPOO", 4, 34884},
	{"HSID", 4, 34885},
	{"CHSE", 4, 34886},
	{"EAFF", 4, 34887},
	{"SWEATER", 7, 34888},
	{"DGOO", 4, 34889},
	{"MANUALLY", 8, 34890},
	{"LROA", 4, 34891},
	{"ABEA", 4, 34892},
	{"REPRINT", 7, 34893},
	{"REID", 4, 34894},
	{"PTIC", 4, 34895},
	{"SUPERMARKET", 11, 34896},
	{"HYDRAULIC", 9, 34897},
	{"DELIBERATELY", 12, 34898},
	{"RNIT", 4, 34899},
	{"TKW", 3, 34900},
	{"CENTERED", 8, 34901},
	{"ROBERTSON", 9, 34902},
	{"OJOI", 4, 34903},
	{"YEARLY", 6, 34904},
	{"GESH", 4, 34905},
	{"TTEL", 4, 34906},
	{"PENETRATION", 11, 34907},
	{"TIMU", 4, 34908},
	{"EYIS", 4, 34909},
	{"USTG", 4, 34910},
	{"BELLE", 5, 34911},
	{"WARMTH", 6, 34912},
	{"ROSA", 4, 34913},
	{"STHU", 4, 34914},
	{"NDDU", 4, 34915},
	{"ISHL", 4, 34916},
	{"ASDR", 4, 34917},
	{"OMISSIONS", 9, 34918},
	{"WRITINGS", 8, 34919},
	{"RSIA", 4, 34920},
	{"HAMBURG", 7, 34921},
	{"SPECIFY", 7, 34922},
	{"FQI", 3, 34923},
	{"LAZY", 4, 34924},
	{"MAGNETIC", 8, 34925},
	{"BIGB", 4, 34926},
	{"ENAV", 4, 34927},
	{"MPG", 3, 34928},
	{"RSEO", 4, 34929},
	{"SAWE", 4, 34930},
	{"RINH", 4, 34931},
	{"RETRIEVAL", 9, 34932},
	{"QUALITIES", 9, 34933},
	{"CINDY", 5, 34934},
	{"DISTINCTIVE", 11, 34935},
	{"SEFU", 4, 34936},
	{"TESU", 4, 34937},
	{"FATHERS", 7, 34938},
	{"CARB", 4, 34939},
	{"CHARGING", 8, 34940},
	{"NINW", 4, 34941},
	{"RSTY", 4, 34942},
	{"YWON", 4, 34943},
	{"RVAR", 4, 34944},
	{"MARVEL", 6, 34945},
	{"CEDH", 4, 34946},
	{"LINED", 5, 34947},
	{"GSYS", 4, 34948},
	{"RRAY", 4, 34949},
	{"EIMM", 4, 34950},
	{"LDNE", 4, 34951},
	{"DOW", 3, 34952},
	{"PROTOTYPE", 9, 34953},
	{"FARE", 4, 34954},
	{"JYO", 3, 34955},
	{"PETITE", 6, 34956},
	{"SCREW", 5, 34957},
	{"APPARATUS", 9, 34958},
	{"UPC", 3, 34959},
	{"DUI", 3, 34960},
	{"BEAP", 4, 34961},
	{"PENS", 4, 34962},
	{"EXPLAINING", 10, 34963},
	{"IEWA", 4, 34964},
	{"STRIPS", 6, 34965},
	{"RENTAL", 6, 34966},
	{"UOZ", 3, 34967},
	{"GOSSIP", 6, 34968},
	{"NGTW", 4, 34969},
	{"OUTG", 4, 34970},
	{"OSAV", 4, 34971},
	{"TFIV", 4, 34972},
	{"IRAL", 4, 34973},
	{"STRAIGHTEN", 10, 34974},
	{"DAPT", 4, 34975},
	{"ATAD", 4, 34976},
	{"RANGERS", 7, 34977},
	{"NGYE", 4, 34978},
	{"INTACT", 6, 34979},
	{"FORMERLY", 8, 34980},
	{"ARTICULATE", 10, 34981},
	{"EMPIRICAL", 9, 34982},
	{"NETR", 4, 34983},
	{"ELABORATE", 9, 34984},
	{"EEXI", 4, 34985},
	{"ROTARY", 6, 34986},
	{"WORM", 4, 34987},
	{"ANID", 4, 34988},
	{"RNSO", 4, 34989},
	{"DEPENDENCE", 10, 34990},
	{"PALACE", 6, 34991},
	{"DISCRETE", 8, 34992},
	{"BEGINNER", 8, 34993},
	{"LDDO", 4, 34994},
	{"BOXED", 5, 34995},
	{"SOAR", 4, 34996},
	{"SUBSTANTIALLY", 13, 34997},
	{"DNTB", 4, 34998},
	{"NEQU", 4, 34999},
	{"AFOO", 4, 35000},
	{"KLES", 4, 35001},
	{"POLYESTER", 9, 35002},
	{"DFIL", 4, 35003},
	{"WHYT", 4, 35004},
	{"LFTH", 4, 35005},
	{"CUBIC", 5, 35006},
	{"DEAF", 4, 35007},
	{"UNCL", 4, 35008},
	{"NINP", 4, 35009},
	{"COMMITMENTS", 11, 35010},
	{"SUGGESTING", 10, 35011},
	{"THREAD", 6, 35012},
	{"SAPPHIRE", 8, 35013},
	{"KINASE", 6, 35014},
	{"ENTV", 4, 35015},
	{"SUSTAINABLE", 11, 35016},
	{"INHERENT", 8, 35017},
	{"SKIRTS", 6, 35018},
	{"TOBL", 4, 35019},
	{"RDSF", 4, 35020},
	{"TRIUMPH", 7, 35021},
	{"EDKI", 4, 35022},
	{"MATS", 4, 35023},
	{"ZZG", 3, 35024},
	{"STSF", 4, 35025},
	{"TRANSPORT", 9, 35026},
	{"REMAINDER", 9, 35027},
	{"GRANDPARENT", 11, 35028},
	{"CRAWFORD", 8, 35029},
	{"LABELED", 7, 35030},
	{"QBJ", 3, 35031},
	{"PRIVILEGES", 10, 35032},
	{"DSLA", 4, 35033},
	{"LANDMARK", 8, 35034},
	{"PATRON", 6, 35035},
	{"HAPPILY", 7, 35036},
	{"TELEVISIONS", 11, 35037},
	{"SPECIALIZING", 12, 35038},
	{"MARKING", 7, 35039},
	{"HEMF", 4, 35040},
	{"NGAH", 4, 35041},
	{"PZO", 3, 35042},
	{"NREV", 4, 35043},
	{"ESIZ", 4, 35044},
	{"IFEL", 4, 35045},
	{"COMMODITIES", 11, 35046},
	{"PVC", 3, 35047},
	{"ERYG", 4, 35048},
	{"FSHO", 4, 35049},
	{"COTTAGE", 7, 35050},
	{"SERBIA", 6, 35051},
	{"SHERIFF", 7, 35052},
	{"GRIFFIN", 7, 35053},
	{"DECLINED", 8, 35054},
	{"PLEL", 4, 35055},
	{"GUYANA", 6, 35056},
	{"SPIES", 5, 35057},
	{"BULK", 4, 35058},
	{"FAVORABLE", 9, 35059},
	{"BLAH", 4, 35060},
	{"MIME", 4, 35061},
	{"SSRO", 4, 35062},
	{"OZC", 3, 35063},
	{"AMBL", 4, 35064},
	{"EMOTIONALLY", 11, 35065},
	{"SUITE", 5, 35066},
	{"RSUC", 4, 35067},
	{"OFYE", 4, 35068},
	{"IKEC", 4, 35069},
	{"UNDM", 4, 35070},
	{"SSWH", 4, 35071},
	{"MOTORCYCLES", 11, 35072},
	{"CONSCIENCE", 10, 35073},
	{"WNST", 4, 35074},
	{"DSOC", 4, 35075},
	{"STBO", 4, 35076},
	{"ONOP", 4, 35077},
	{"SELECTED", 8, 35078},
	{"INDR", 4, 35079},
	{"TESM", 4, 35080},
	{"HIGHWAYS", 8, 35081},
	{"THINKPAD", 8, 35082},
	{"YMBO", 4, 35083},
	{"RBEF", 4, 35084},
	{"RALW", 4, 35085},
	{"FRACTION", 8, 35086},
	{"LFAS", 4, 35087},
	{"REPRODUCTIVE", 12, 35088},
	{"PLAINTIFF", 9, 35089},
	{"HISJ", 4, 35090},
	{"PRESTON", 7, 35091},
	{"GHEA", 4, 35092},
	{"NXF", 3, 35093},
	{"NBEG", 4, 35094},
	{"WIDOW", 5, 35095},
	{"OADT", 4, 35096},
	{"TLIV", 4, 35097},
	{"FRAGMENT", 8, 35098},
	{"CUNT", 4, 35099},
	{"OWEA", 4, 35100},
	{"URPA", 4, 35101},
	{"FEOF", 4, 35102},
	{"IMPULSE", 7, 35103},
	{"SUMMARY", 7, 35104},
	{"INDH", 4, 35105},
	{"BUNNY", 5, 35106},
	{"CHEVY", 5, 35107},
	{"ISHF", 4, 35108},
	{"MOLECULES", 9, 35109},
	{"ROUNDS", 6, 35110},
	{"TEFR", 4, 35111},
	{"NSLE", 4, 35112},
	{"ORDR", 4, 35113},
	{"LONGEST", 7, 35114},
	{"EADB", 4, 35115},
	{"ASFR", 4, 35116},
	{"STRAW", 5, 35117},
	{"TIONS", 5, 35118},
	{"INTERVALS", 9, 35119},
	{"YOFI", 4, 35120},
	{"ADWI", 4, 35121},
	{"ENME", 4, 35122},
	{"RRAC", 4, 35123},
	{"RTYS", 4, 35124},
	{"SENTENCES", 9, 35125},
	{"SFEL", 4, 35126},
	{"YSEC", 4, 35127},
	{"DENTISTS", 8, 35128},
	{"USDA", 4, 35129},
	{"EXCLUSION", 9, 35130},
	{"INIR", 4, 35131},
	{"YDRO", 4, 35132},
	{"SUITABLE", 8, 35133},
	{"WORKSTATION", 11, 35134},
	{"HOLOCAUST", 9, 35135},
	{"KEEN", 4, 35136},
	{"FLYER", 5, 35137},
	{"PEAS", 4, 35138},
	{"DOSAGE", 6, 35139},
	{"RECEIVERS", 9, 35140},
	{"URLS", 4, 35141},
	{"CUSTOMISE", 9, 35142},
	{"RMET", 4, 35143},
	{"DISPOSITION", 11, 35144},
	{"BBER", 4, 35145},
	{"YEJ", 3, 35146},
	{"PROJECTION", 10, 35147},
	{"CLAY", 4, 35148},
	{"SPIT", 4, 35149},
	{"EDYO", 4, 35150},
	{"ADRO", 4, 35151},
	{"RHAR", 4, 35152},
	{"ICCH", 4, 35153},
	{"ICKN", 4, 35154},
	{"XKM", 3, 35155},
	{"VARIANCE", 8, 35156},
	{"TALR", 4, 35157},
	{"LSEN", 4, 35158},
	{"LBUS", 4, 35159},
	{"NAVIGATOR", 9, 35160},
	{"INVESTIGATORS", 13, 35161},
	{"NDVE", 4, 35162},
	{"CAMEROON", 8, 35163},
	{"FRAI", 4, 35164},
	{"BAKING", 6, 35165},
	{"MARIJUANA", 9, 35166},
	{"ADAPTIVE", 8, 35167},
	{"COMPUTED", 8, 35168},
	{"IPLI", 4, 35169},
	{"BATHS", 5, 35170},
	{"DRILL", 5, 35171},
	{"PREMIUM", 7, 35172},
	{"CATHEDRAL", 9, 35173},
	{"BRAKES", 6, 35174},
	{"POLICEMAN", 9, 35175},
	{"LTIC", 4, 35176},
	{"ISFE", 4, 35177},
	{"OBJECTION", 9, 35178},
	{"NIRVANA", 7, 35179},
	{"FAIRFIELD", 9, 35180},
	{"OWNS", 4, 35181},
	{"WHOB", 4, 35182},
	{"MANM", 4, 35183},
	{"ICOR", 4, 35184},
	{"WNSA", 4, 35185},
	{"NTLA", 4, 35186},
	{"EEXE", 4, 35187},
	{"NBRA", 4, 35188},
	{"INVISION", 8, 35189},
	{"STICKY", 6, 35190},
	{"DESTINY", 7, 35191},
	{"MADNESS", 7, 35192},
	{"EMACS", 5, 35193},
	{"ROUTINELY", 9, 35194},
	{"FANTASTIC", 9, 35195},
	{"TILL", 4, 35196},
	{"BLOWING", 7, 35197},
	{"LANDSCAPES", 10, 35198},
	{"ACEL", 4, 35199},
	{"HEATED", 6, 35200},
	{"YHES", 4, 35201},
	{"NCLO", 4, 35202},
	{"LAFAYETTE", 9, 35203},
	{"JACKIE", 6, 35204},
	{"FWAS", 4, 35205},
	{"COMPUTATION", 11, 35206},
	{"OKIL", 4, 35207},
	{"LFOU", 4, 35208},
	{"TCIT", 4, 35209},
	{"RPAT", 4, 35210},
	{"CARDIOVASCULAR", 14, 35211},
	{"ITEB", 4, 35212},
	{"PISTOL", 6, 35213},
	{"OBAT", 4, 35214},
	{"RKNO", 4, 35215},
	{"CKIS", 4, 35216},
	{"SPARC", 5, 35217},
	{"OMST", 4, 35218},
	{"ATUN", 4, 35219},
	{"CARDIAC", 7, 35220},
	{"SALVATION", 9, 35221},
	{"CALENDAR", 8, 35222},
	{"DOVER", 5, 35223},
	{"ADRIAN", 6, 35224},
	{"HEADACHE", 8, 35225},
	{"ENNY", 4, 35226},
	{"PREDICTIONS", 11, 35227},
	{"WSIN", 4, 35228},
	{"ACCOMPANYING", 12, 35229},
	{"AILT", 4, 35230},
	{"VATICAN", 7, 35231},
	{"LREL", 4, 35232},
	{"LYKN", 4, 35233},
	{"LEARNERS", 8, 35234},
	{"SELECTIVE", 9, 35235},
	{"ARBITRATION", 11, 35236},
	{"TBOO", 4, 35237},
	{"CONFIGURING", 11, 35238},
	{"TOKEN", 5, 35239},
	{"EDITORIALS", 10, 35240},
	{"ZINC", 4, 35241},
	{"LSOE", 4, 35242},
	{"TYON", 4, 35243},
	{"EAKA", 4, 35244},
	{"SEEKERS", 7, 35245},
	{"DANCING", 7, 35246},
	{"NOCO", 4, 35247},
	{"GURU", 4, 35248},
	{"EORE", 4, 35249},
	{"ENBO", 4, 35250},
	{"BLAST", 5, 35251},
	{"ARYH", 4, 35252},
	{"REMOVABLE", 9, 35253},
	{"CONVERGENCE", 11, 35254},
	{"RYHE", 4, 35255},
	{"YIELDS", 6, 35256},
	{"GIBRALTAR", 9, 35257},
	{"LEVY", 4, 35258},
	{"SUITED", 6, 35259},
	{"NUMERIC", 7, 35260},
	{"YSPO", 4, 35261},
	{"SRAI", 4, 35262},
	{"UWIL", 4, 35263},
	{"ANTHROPOLOGY", 12, 35264},
	{"SKATING", 7, 35265},
	{"KINDA", 5, 35266},
	{"DERD", 4, 35267},
	{"ABERDEEN", 8, 35268},
	{"EMPEROR", 7, 35269},
	{"DLIF", 4, 35270},
	{"GRAD", 4, 35271},
	{"MANSION", 7, 35272},
	{"BUCKET", 6, 35273},
	{"MALPRACTICE", 11, 35274},
	{"SBLO", 4, 35275},
	{"DYLAN", 5, 35276},
	{"BRAS", 4, 35277},
	{"VSY", 3, 35278},
	{"HREW", 4, 35279},
	{"NDAI", 4, 35280},
	{"RIDGE", 5, 35281},
	{"IEFO", 4, 35282},
	{"APHO", 4, 35283},
	{"BELTS", 5, 35284},
	{"ISGA", 4, 35285},
	{"UPDATE", 6, 35286},
	{"BLACKS", 6, 35287},
	{"NLOA", 4, 35288},
	{"ECIP", 4, 35289},
	{"TRANSIT", 7, 35290},
	{"EDUCATED", 8, 35291},
	{"REBATES", 7, 35292},
	{"DAYH", 4, 35293},
	{"REPORTERS", 9, 35294},
	{"OAVO", 4, 35295},
	{"AMSW", 4, 35296},
	{"BURKE", 5, 35297},
	{"OBRE", 4, 35298},
	{"NGJU", 4, 35299},
	{"LMEN", 4, 35300},
	{"PROUDLY", 7, 35301},
	{"BLESSING", 8, 35302},
	{"NEFR", 4, 35303},
	{"PIX", 3, 35304},
	{"LIFY", 4, 35305},
	{"RENDERING", 9, 35306},
	{"RADAR", 5, 35307},
	{"FWU", 3, 35308},
	{"BBED", 4, 35309},
	{"MIC", 3, 35310},
	{"INSERTED", 8, 35311},
	{"SAWH", 4, 35312},
	{"YONL", 4, 35313},
	{"GRADUATION", 10, 35314},
	{"EJUN", 4, 35315},
	{"PULLING", 7, 35316},
	{"RBRI", 4, 35317},
	{"BASENAME", 8, 35318},
	{"KYLE", 4, 35319},
	{"OBESITY", 7, 35320},
	{"HERJ", 4, 35321},
	{"CURVES", 6, 35322},
	{"FATIGUE", 7, 35323},
	{"TOURING", 7, 35324},
	{"NBUS", 4, 35325},
	{"EISF", 4, 35326},
	{"PRIVATELY", 9, 35327},
	{"CLARA", 5, 35328},
	{"INVENTION", 9, 35329},
	{"VERTEX", 6, 35330},
	{"ONE-THIRD", 9, 35331},
	{"MARBLE", 6, 35332},
	{"HEPATITIS", 9, 35333},
	{"AUTHORIZE", 9, 35334},
	{"NATIONALLY", 10, 35335},
	{"ARROW", 5, 35336},
	{"KEAS", 4, 35337},
	{"ANDORRA", 7, 35338},
	{"PREVAIL", 7, 35339},
	{"DENIAL", 6, 35340},
	{"OPOR", 4, 35341},
	{"WATERPROOF", 10, 35342},
	{"GESC", 4, 35343},
	{"ILYM", 4, 35344},
	{"VERU", 4, 35345},
	{"EXPIRED", 7, 35346},
	{"EXHAUST", 7, 35347},
	{"RYCL", 4, 35348},
	{"RITW", 4, 35349},
	{"TRAVELS", 7, 35350},
	{"FLUSH", 5, 35351},
	{"WAIVER", 6, 35352},
	{"RIOT", 4, 35353},
	{"ZGI", 3, 35354},
	{"SPECIALTIES", 11, 35355},
	{"UBSI", 4, 35356},
	{"OLD-FASHIONED", 13, 35357},
	{"TILE", 4, 35358},
	{"HAYES", 5, 35359},
	{"HUMANITARIAN", 12, 35360},
	{"GGAM", 4, 35361},
	{"INVITATIONS", 11, 35362},
	{"ONTL", 4, 35363},
	{"FUNCTIONING", 11, 35364},
	{"MYAN", 4, 35365},
	{"GARCIA", 6, 35366},
	{"CROWDED", 7, 35367},
	{"CINGULAR", 8, 35368},
	{"TGAG", 4, 35369},
	{"ECONOMIES", 9, 35370},
	{"REEH", 4, 35371},
	{"SDEL", 4, 35372},
	{"ZTU", 3, 35373},
	{"ALEXANDRIA", 10, 35374},
	{"BACTERIAL", 9, 35375},
	{"MOSES", 5, 35376},
	{"DBRE", 4, 35377},
	{"COUNTED", 7, 35378},
	{"LPTH", 4, 35379},
	{"BRUTAL", 6, 35380},
	{"YMUC", 4, 35381},
	{"ATYE", 4, 35382},
	{"CHEMISTRY", 9, 35383},
	{"RBIT", 4, 35384},
	{"EDEE", 4, 35385},
	{"RUBBER", 6, 35386},
	{"CONTINUOUSLY", 12, 35387},
	{"JOHNS", 5, 35388},
	{"YWIN", 4, 35389},
	{"RORA", 4, 35390},
	{"CYOF", 4, 35391},
	{"VALVES", 6, 35392},
	{"WHOF", 4, 35393},
	{"IQUI", 4, 35394},
	{"GAPS", 4, 35395},
	{"BALLOON", 7, 35396},
	{"IMPAIRED", 8, 35397},
	{"ACHIEVEMENTS", 12, 35398},
	{"DONORS", 6, 35399},
	{"OTIM", 4, 35400},
	{"SOAK", 4, 35401},
	{"CUE", 3, 35402},
	{"FOG", 3, 35403},
	{"DIPLOMAT", 8, 35404},
	{"RROL", 4, 35405},
	{"YOUNGSTER", 9, 35406},
	{"JEWEL", 5, 35407},
	{"TAYI", 4, 35408},
	{"LSCA", 4, 35409},
	{"APOI", 4, 35410},
	{"EJJ", 3, 35411},
	{"RDRI", 4, 35412},
	{"TEDDY", 5, 35413},
	{"CTHA", 4, 35414},
	{"CONVERTIBLE", 11, 35415},
	{"TEACHES", 7, 35416},
	{"RSLE", 4, 35417},
	{"VENTURES", 8, 35418},
	{"DOCK", 4, 35419},
	{"NGBI", 4, 35420},
	{"EORS", 4, 35421},
	{"EMOF", 4, 35422},
	{"OLOU", 4, 35423},
	{"OODR", 4, 35424},
	{"BUFING", 6, 35425},
	{"UAJ", 3, 35426},
	{"DASK", 4, 35427},
	{"JULIAN", 6, 35428},
	{"DMIR", 4, 35429},
	{"PAM", 3, 35430},
	{"DRYER", 5, 35431},
	{"VELVET", 6, 35432},
	{"LEGR", 4, 35433},
	{"YSWI", 4, 35434},
	{"NRUN", 4, 35435},
	{"TRIBUNAL", 8, 35436},
	{"RULED", 5, 35437},
	{"ANTG", 4, 35438},
	{"OVERNIGHT", 9, 35439},
	{"ECONOMICALLY", 12, 35440},
	{"PENSIONS", 8, 35441},
	{"RSDO", 4, 35442},
	{"ODTO", 4, 35443},
	{"PRAYERS", 7, 35444},
	{"SFOO", 4, 35445},
	{"FUNKY", 5, 35446},
	{"ECEO", 4, 35447},
	{"EUPO", 4, 35448},
	{"FORBID", 6, 35449},
	{"SECRETARIAT", 11, 35450},
	{"XJA", 3, 35451},
	{"NUSU", 4, 35452},
	{"GLOBE", 5, 35453},
	{"LLMO", 4, 35454},
	{"DSIT", 4, 35455},
	{"URYT", 4, 35456},
	{"UNHAPPY", 7, 35457},
	{"PARAGRAPHS", 10, 35458},
	{"GALE", 4, 35459},
	{"JOINS", 5, 35460},
	{"RIBBON", 6, 35461},
	{"HAZARD", 6, 35462},
	{"NGAV", 4, 35463},
	{"AVEU", 4, 35464},
	{"NOMINATIONS", 11, 35465},
	{"WESLEY", 6, 35466},
	{"PTIM", 4, 35467},
	{"DIM", 3, 35468},
	{"CHARM", 5, 35469},
	{"BULB", 4, 35470},
	{"MARKER", 6, 35471},
	{"ACCURATELY", 10, 35472},
	{"ROFB", 4, 35473},
	{"ARYD", 4, 35474},
	{"CANCELLED", 9, 35475},
	{"IRONICALLY", 10, 35476},
	{"MARINE", 6, 35477},
	{"SENSOR", 6, 35478},
	{"OUNS", 4, 35479},
	{"ERQU", 4, 35480},
	{"YLON", 4, 35481},
	{"EEDU", 4, 35482},
	{"MATTRESS", 8, 35483},
	{"RCOR", 4, 35484},
	{"COORDINATE", 10, 35485},
	{"MPEGS", 5, 35486},
	{"EOPT", 4, 35487},
	{"NWED", 4, 35488},
	{"BRUNEI", 6, 35489},
	{"INTRODUCTORY", 12, 35490},
	{"RQB", 3, 35491},
	{"TIMBER", 6, 35492},
	{"EGUI", 4, 35493},
	{"SLOVAK", 6, 35494},
	{"DSPR", 4, 35495},
	{"SHORTS", 6, 35496},
	{"BOLT", 4, 35497},
	{"CAKES", 5, 35498},
	{"GWHA", 4, 35499},
	{"RRIG", 4, 35500},
	{"FYEA", 4, 35501},
	{"NIFO", 4, 35502},
	{"IFEE", 4, 35503},
	{"RESERVOIR", 9, 35504},
	{"SEDR", 4, 35505},
	{"LLAD", 4, 35506},
	{"EWSC", 4, 35507},
	{"OCCURRENCE", 10, 35508},
	{"IDOL", 4, 35509},
	{"ACKU", 4, 35510},
	{"MIXER", 5, 35511},
	{"VKO", 3, 35512},
	{"CTSW", 4, 35513},
	{"WORCESTER", 9, 35514},
	{"SBJCT", 5, 35515},
	{"ELLF", 4, 35516},
	{"ANTU", 4, 35517},
	{"CHARMING", 8, 35518},
	{"EIRG", 4, 35519},
	{"DEFENDER", 8, 35520},
	{"YGOT", 4, 35521},
	{"NXU", 3, 35522},
	{"SEVI", 4, 35523},
	{"NINJ", 4, 35524},
	{"DISCIPLINARY", 12, 35525},
	{"RETREAT", 7, 35526},
	{"SURVEILLANCE", 12, 35527},
	{"ANNOYING", 8, 35528},
	{"RESPECTED", 9, 35529},
	{"STAYS", 5, 35530},
	{"LLEL", 4, 35531},
	{"SLOT", 4, 35532},
	{"IMPORTANTLY", 11, 35533},
	{"DROVE", 5, 35534},
	{"WASHER", 6, 35535},
	{"UTIE", 4, 35536},
	{"TAGR", 4, 35537},
	{"SPRINGER", 8, 35538},
	{"CRUEL", 5, 35539},
	{"YCRE", 4, 35540},
	{"MINES", 5, 35541},
	{"MANAGING", 8, 35542},
	{"ILEY", 4, 35543},
	{"PORTRAITS", 9, 35544},
	{"IACO", 4, 35545},
	{"HABO", 4, 35546},
	{"FRAGILE", 7, 35547},
	{"HARVEST", 7, 35548},
	{"SWELL", 5, 35549},
	{"REBOUND", 7, 35550},
	{"IDFO", 4, 35551},
	{"LOGAN", 5, 35552},
	{"CEDW", 4, 35553},
	{"IMOR", 4, 35554},
	{"INTERPRETED", 11, 35555},
	{"EVALUATIONS", 11, 35556},
	{"LCUL", 4, 35557},
	{"RCHS", 4, 35558},
	{"FOUGHT", 6, 35559},
	{"UTAR", 4, 35560},
	{"VETR", 4, 35561},
	{"UESO", 4, 35562},
	{"ENDW", 4, 35563},
	{"CHWH", 4, 35564},
	{"BAGHDAD", 7, 35565},
	{"ELIMINATION", 11, 35566},
	{"METRES", 6, 35567},
	{"USEB", 4, 35568},
	{"BRONZE", 6, 35569},
	{"SCOO", 4, 35570},
	{"HYPOTHETICAL", 12, 35571},
	{"TRANSMIT", 8, 35572},
	{"SUNNY", 5, 35573},
	{"ELECTRONICS", 11, 35574},
	{"IMMIGRANTS", 10, 35575},
	{"COMPLIMENTARY", 13, 35576},
	{"TEPO", 4, 35577},
	{"YHOU", 4, 35578},
	{"WCY", 3, 35579},
	{"RJUS", 4, 35580},
	{"GSAI", 4, 35581},
	{"TRIM", 4, 35582},
	{"ZEDB", 4, 35583},
	{"SOFTEN", 6, 35584},
	{"RJOB", 4, 35585},
	{"IRSE", 4, 35586},
	{"NLYM", 4, 35587},
	{"LHAD", 4, 35588},
	{"SPINE", 5, 35589},
	{"KEHE", 4, 35590},
	{"ABU", 3, 35591},
	{"TITLED", 6, 35592},
	{"ESIL", 4, 35593},
	{"STEREOTYPE", 10, 35594},
	{"COMMISSIONS", 11, 35595},
	{"YDOE", 4, 35596},
	{"LDCU", 4, 35597},
	{"HPRE", 4, 35598},
	{"NOFO", 4, 35599},
	{"ONDP", 4, 35600},
	{"POWERSELLER", 11, 35601},
	{"SEMINAR", 7, 35602},
	{"NATIONWIDE", 10, 35603},
	{"MOSS", 4, 35604},
	{"ICHD", 4, 35605},
	{"RATIOS", 6, 35606},
	{"ONSY", 4, 35607},
	{"TUPT", 4, 35608},
	{"CONCORD", 7, 35609},
	{"GRADUATED", 9, 35610},
	{"OFJO", 4, 35611},
	{"LEBI", 4, 35612},
	{"LHEL", 4, 35613},
	{"ENDORSED", 8, 35614},
	{"BYPR", 4, 35615},
	{"EGAI", 4, 35616},
	{"SGUI", 4, 35617},
	{"TDOO", 4, 35618},
	{"SSLI", 4, 35619},
	{"DROWN", 5, 35620},
	{"WALNUT", 6, 35621},
	{"LANCE", 5, 35622},
	{"LCEN", 4, 35623},
	{"TERRIBLY", 8, 35624},
	{"ITALIA", 6, 35625},
	{"UNNECESSARY", 11, 35626},
	{"LIBERIA", 7, 35627},
	{"EVEI", 4, 35628},
	{"HOMEWORK", 8, 35629},
	{"NEXA", 4, 35630},
	{"SHERMAN", 7, 35631},
	{"CORK", 4, 35632},
	{"ERJU", 4, 35633},
	{"DSOR", 4, 35634},
	{"BYHE", 4, 35635},
	{"NLYD", 4, 35636},
	{"MAXIMIZE", 8, 35637},
	{"HANSEN", 6, 35638},
	{"SENATORS", 8, 35639},
	{"DISL", 4, 35640},
	{"FREELY", 6, 35641},
	{"STEADILY", 8, 35642},
	{"MALI", 4, 35643},
	{"YUGOSLAVIA", 10, 35644},
	{"CONTRIBUTOR", 11, 35645},
	{"EEDF", 4, 35646},
	{"BLEEDING", 8, 35647},
	{"TORB", 4, 35648},
	{"SELLER", 6, 35649},
	{"CHARACTERIZATION", 16, 35650},
	{"WAQ", 3, 35651},
	{"VENP", 4, 35652},
	{"COLON", 5, 35653},
	{"NEIGHBORING", 11, 35654},
	{"ANBR", 4, 35655},
	{"YSUR", 4, 35656},
	{"LAHO", 4, 35657},
	{"LIGHTING", 8, 35658},
	{"NTMI", 4, 35659},
	{"GWIL", 4, 35660},
	{"RCEA", 4, 35661},
	{"ELLC", 4, 35662},
	{"RMAK", 4, 35663},
	{"TUNN", 4, 35664},
	{"MPEN", 4, 35665},
	{"LANES", 5, 35666},
	{"TGOO", 4, 35667},
	{"FUNDAMENTALS", 12, 35668},
	{"CONTAMINATION", 13, 35669},
	{"SPY", 3, 35670},
	{"FOREIGNER", 9, 35671},
	{"AHOU", 4, 35672},
	{"ERJA", 4, 35673},
	{"MTV", 3, 35674},
	{"ENDANGERED", 10, 35675},
	{"ONGD", 4, 35676},
	{"CONFESSION", 10, 35677},
	{"MASTURBATION", 12, 35678},
	{"NBOR", 4, 35679},
	{"OPTIMIZE", 8, 35680},
	{"YERI", 4, 35681},
	{"GMON", 4, 35682},
	{"STATING", 7, 35683},
	{"DOME", 4, 35684},
	{"CAROLINE", 8, 35685},
	{"SPARK", 5, 35686},
	{"RWAT", 4, 35687},
	{"RDIE", 4, 35688},
	{"LEU", 3, 35689},
	{"ORYB", 4, 35690},
	{"EXPIRATION", 10, 35691},
	{"NAMESPACE", 9, 35692},
	{"ALIGN", 5, 35693},
	{"TSAF", 4, 35694},
	{"PERIPHERAL", 10, 35695},
	{"GLIK", 4, 35696},
	{"ENGAGING", 8, 35697},
	{"CREST", 5, 35698},
	{"LOYAL", 5, 35699},
	{"NVAS", 4, 35700},
	{"NESF", 4, 35701},
	{"SMIG", 4, 35702},
	{"OPPONENTS", 9, 35703},
	{"HWAR", 4, 35704},
	{"PREACH", 6, 35705},
	{"PROVOKE", 7, 35706},
	{"LAUNDRY", 7, 35707},
	{"NOMINATED", 9, 35708},
	{"CONFIDENTIALITY", 15, 35709},
	{"RSAY", 4, 35710},
	{"UANT", 4, 35711},
	{"OKFO", 4, 35712},
	{"ELECTORAL", 9, 35713},
	{"LLSF", 4, 35714},
	{"CHANGELOG", 9, 35715},
	{"WELDING", 7, 35716},
	{"YDEP", 4, 35717},
	{"MWIL", 4, 35718},
	{"BRAVE", 5, 35719},
	{"DENSE", 5, 35720},
	{"DEFERRED", 8, 35721},
	{"ALTERNATIVELY", 13, 35722},
	{"ALLOY", 5, 35723},
	{"AMSH", 4, 35724},
	{"OVEW", 4, 35725},
	{"HLIG", 4, 35726},
	{"CONDOS", 6, 35727},
	{"LCOH", 4, 35728},
	{"PLOTS", 5, 35729},
	{"FLYING", 6, 35730},
	{"POLISHED", 8, 35731},
	{"YANG", 4, 35732},
	{"DEVASTATING", 11, 35733},
	{"TFAC", 4, 35734},
	{"GREENSBORO", 10, 35735},
	{"IFER", 4, 35736},
	{"TULSA", 5, 35737},
	{"RSSO", 4, 35738},
	{"LOCKING", 7, 35739},
	{"CASEY", 5, 35740},
	{"ORSF", 4, 35741},
	{"DEVIL", 5, 35742},
	{"REAV", 4, 35743},
	{"DRAWS", 5, 35744},
	{"NNOW", 4, 35745},
	{"FRIDGE", 6, 35746},
	{"TYMA", 4, 35747},
	{"TECHNICIAN", 10, 35748},
	{"NEYW", 4, 35749},
	{"BLOOM", 5, 35750},
	{"FEAS", 4, 35751},
	{"SKILLED", 7, 35752},
	{"GUET", 4, 35753},
	{"ERTU", 4, 35754},
	{"ALMU", 4, 35755},
	{"ACLO", 4, 35756},
	{"YKJ", 3, 35757},
	{"RETW", 4, 35758},
	{"SIMPSONS", 8, 35759},
	{"LLAH", 4, 35760},
	{"LOU", 3, 35761},
	{"HONESTLY", 8, 35762},
	{"EBUD", 4, 35763},
	{"REGAIN", 6, 35764},
	{"RKSO", 4, 35765},
	{"UALP", 4, 35766},
	{"ELLIOTT", 7, 35767},
	{"RECOVERED", 9, 35768},
	{"MANUAL", 6, 35769},
	{"FRASER", 6, 35770},
	{"UPGRADING", 9, 35771},
	{"TILH", 4, 35772},
	{"LERW", 4, 35773},
	{"DFUL", 4, 35774},
	{"BLADES", 6, 35775},
	{"DELIGHT", 7, 35776},
	{"EYSE", 4, 35777},
	{"ULTH", 4, 35778},
	{"TLEC", 4, 35779},
	{"DLIV", 4, 35780},
	{"CKCO", 4, 35781},
	{"UPST", 4, 35782},
	{"ALEO", 4, 35783},
	{"LMUS", 4, 35784},
	{"PGP", 3, 35785},
	{"DEPART", 6, 35786},
	{"SEVERELY", 8, 35787},
	{"UQI", 3, 35788},
	{"CHLI", 4, 35789},
	{"LOOPS", 5, 35790},
	{"YMH", 3, 35791},
	{"BUTTERFLY", 9, 35792},
	{"YANT", 4, 35793},
	{"FPOL", 4, 35794},
	{"TIWA", 4, 35795},
	{"SURGE", 5, 35796},
	{"VACUUM", 6, 35797},
	{"FRONTPAGE", 9, 35798},
	{"NBAN", 4, 35799},
	{"CONTEMPLATE", 11, 35800},
	{"HWOU", 4, 35801},
	{"LGAR", 4, 35802},
	{"TAHOE", 5, 35803},
	{"LLTR", 4, 35804},
	{"MIDDLE-CLASS", 12, 35805},
	{"ADVERT", 6, 35806},
	{"DEMANDING", 9, 35807},
	{"GASI", 4, 35808},
	{"NEYO", 4, 35809},
	{"OSPH", 4, 35810},
	{"MEANTIME", 8, 35811},
	{"DNTS", 4, 35812},
	{"VEPE", 4, 35813},
	{"WAREHOUSE", 9, 35814},
	{"FLASHERS", 8, 35815},
	{"SUBARU", 6, 35816},
	{"IKEB", 4, 35817},
	{"FORBIDDEN", 9, 35818},
	{"OSCH", 4, 35819},
	{"VANILLA", 7, 35820},
	{"PROGRAMMERS", 11, 35821},
	{"BIOGRAPHY", 9, 35822},
	{"WEAVE", 5, 35823},
	{"HEOC", 4, 35824},
	{"MONITORED", 9, 35825},
	{"ILYW", 4, 35826},
	{"SPECULATE", 9, 35827},
	{"OORA", 4, 35828},
	{"FFIL", 4, 35829},
	{"URKE", 4, 35830},
	{"ORGANIZED", 9, 35831},
	{"INSTALLATIONS", 13, 35832},
	{"DEUTSCHLAND", 11, 35833},
	{"PICNIC", 6, 35834},
	{"SOULS", 5, 35835},
	{"EPIDEMIC", 8, 35836},
	{"ARRIVALS", 8, 35837},
	{"SPANK", 5, 35838},
	{"TFIL", 4, 35839},
	{"SELDOM", 6, 35840},
	{"YRW", 3, 35841},
	{"VEIS", 4, 35842},
	{"IONV", 4, 35843},
	{"GAPO", 4, 35844},
	{"YLOS", 4, 35845},
	{"TFOO", 4, 35846},
	{"CHHI", 4, 35847},
	{"TASW", 4, 35848},
	{"ORDW", 4, 35849},
	{"VTW", 3, 35850},
	{"MOTIVATED", 9, 35851},
	{"SMITHSONIAN", 11, 35852},
	{"TGOT", 4, 35853},
	{"HOLLOW", 6, 35854},
	{"EHIL", 4, 35855},
	{"VAULT", 5, 35856},
	{"SECURELY", 8, 35857},
	{"EXAMINING", 9, 35858},
	{"FIORICET", 8, 35859},
	{"GROOVE", 6, 35860},
	{"GACO", 4, 35861},
	{"OWND", 4, 35862},
	{"PLEA", 4, 35863},
	{"NOFL", 4, 35864},
	{"BYSE", 4, 35865},
	{"GERC", 4, 35866},
	{"TBUS", 4, 35867},
	{"YINH", 4, 35868},
	{"DBYI", 4, 35869},
	{"TSFA", 4, 35870},
	{"RVEN", 4, 35871},
	{"ITYE", 4, 35872},
	{"DELEGATION", 10, 35873},
	{"NDSB", 4, 35874},
	{"WIRES", 5, 35875},
	{"COMPELLING", 10, 35876},
	{"DICTIONARIES", 12, 35877},
	{"FSHE", 4, 35878},
	{"AZIL", 4, 35879},
	{"NDPH", 4, 35880},
	{"CUPI", 4, 35881},
	{"XTQ", 3, 35882},
	{"MAILS", 5, 35883},
	{"BACKING", 7, 35884},
	{"VEAB", 4, 35885},
	{"GREENHOUSE", 10, 35886},
	{"SLEEPS", 6, 35887},
	{"TROUBLED", 8, 35888},
	{"CARGO", 5, 35889},
	{"WOWE", 4, 35890},
	{"OTHC", 4, 35891},
	{"DISTURBING", 10, 35892},
	{"NAVAL", 5, 35893},
	{"ELSH", 4, 35894},
	{"URHO", 4, 35895},
	{"BLAKE", 5, 35896},
	{"TRANSPARENCY", 12, 35897},
	{"TRAVIS", 6, 35898},
	{"LYPU", 4, 35899},
	{"OTWI", 4, 35900},
	{"APEA", 4, 35901},
	{"ACCUSATION", 10, 35902},
	{"DLEF", 4, 35903},
	{"RJOH", 4, 35904},
	{"NDGU", 4, 35905},
	{"FIGURED", 7, 35906},
	{"TOAG", 4, 35907},
	{"HWHO", 4, 35908},
	{"TLON", 4, 35909},
	{"CURRENCIES", 10, 35910},
	{"NIGER", 5, 35911},
	{"DDIR", 4, 35912},
	{"OFFU", 4, 35913},
	{"DBYL", 4, 35914},
	{"OROL", 4, 35915},
	{"BACON", 5, 35916},
	{"YHOW", 4, 35917},
	{"LELO", 4, 35918},
	{"SURVIVORS", 9, 35919},
	{"POSITIONING", 11, 35920},
	{"HEATER", 6, 35921},
	{"LTQ", 3, 35922},
	{"OVERWHELM", 9, 35923},
	{"ARKW", 4, 35924},
	{"DWRI", 4, 35925},
	{"APAT", 4, 35926},
	{"UTLA", 4, 35927},
	{"YDUR", 4, 35928},
	{"CANNON", 6, 35929},
	{"CIRCUS", 6, 35930},
	{"ITPR", 4, 35931},
	{"PROMOTED", 8, 35932},
	{"SBRA", 4, 35933},
	{"UARA", 4, 35934},
	{"FORBES", 6, 35935},
	{"IXIN", 4, 35936},
	{"DDRA", 4, 35937},
	{"CONVENIENCE", 11, 35938},
	{"APOLOGY", 7, 35939},
	{"ATFA", 4, 35940},
	{"MOLDOVA", 7, 35941},
	{"MEL", 3, 35942},
	{"NAFR", 4, 35943},
	{"DESCENDING", 10, 35944},
	{"PAXIL", 5, 35945},
	{"KSHE", 4, 35946},
	{"RYGO", 4, 35947},
	{"UXN", 3, 35948},
	{"DSIM", 4, 35949},
	{"DEDC", 4, 35950},
	{"EFIV", 4, 35951},
	{"TROUT", 5, 35952},
	{"ENCLOSED", 8, 35953},
	{"FEAT", 4, 35954},
	{"NTSC", 4, 35955},
	{"COOKED", 6, 35956},
	{"THRILLER", 8, 35957},
	{"UCKI", 4, 35958},
	{"APNIC", 5, 35959},
	{"FATTY", 5, 35960},
	{"GERALD", 6, 35961},
	{"ANOB", 4, 35962},
	{"PRESSED", 7, 35963},
	{"RLYC", 4, 35964},
	{"FREQUENCIES", 11, 35965},
	{"TYSH", 4, 35966},
	{"ICHF", 4, 35967},
	{"EISU", 4, 35968},
	{"OSUC", 4, 35969},
	{"ALAU", 4, 35970},
	{"DENL", 4, 35971},
	{"SCANNED", 7, 35972},
	{"KETC", 4, 35973},
	{"LAYW", 4, 35974},
	{"REFLECTIONS", 11, 35975},
	{"ERGU", 4, 35976},
	{"RTHQ", 4, 35977},
	{"DMOT", 4, 35978},
	{"EFIF", 4, 35979},
	{"MARIAH", 6, 35980},
	{"NFIE", 4, 35981},
	{"EGUA", 4, 35982},
	{"DYHA", 4, 35983},
	{"NFAM", 4, 35984},
	{"MUNICIPALITY", 12, 35985},
	{"USPS", 4, 35986},
	{"TFRI", 4, 35987},
	{"JOYCE", 5, 35988},
	{"TMET", 4, 35989},
	{"ILME", 4, 35990},
	{"YDEV", 4, 35991},
	{"ICFO", 4, 35992},
	{"CEMENT", 6, 35993},
	{"HGY", 3, 35994},
	{"EXPERIENCING", 12, 35995},
	{"APHE", 4, 35996},
	{"TEBU", 4, 35997},
	{"OWBE", 4, 35998},
	{"ZRU", 3, 35999},
	{"YGW", 3, 36000},
	{"IARE", 4, 36001},
	{"FIREPLACE", 9, 36002},
	{"DDER", 4, 36003},
	{"SCRU", 4, 36004},
	{"CHDE", 4, 36005},
	{"ODID", 4, 36006},
	{"IDEH", 4, 36007},
	{"PLANNERS", 8, 36008},
	{"DISPUTES", 8, 36009},
	{"TEXTILES", 8, 36010},
	{"DLAR", 4, 36011},
	{"IDWE", 4, 36012},
	{"IDAL", 4, 36013},
	{"SOMETIME", 8, 36014},
	{"HWHE", 4, 36015},
	{"CTCO", 4, 36016},
	{"RRUN", 4, 36017},
	{"ALPU", 4, 36018},
	{"SFAL", 4, 36019},
	{"IMSO", 4, 36020},
	{"YGG", 3, 36021},
	{"INTRANET", 8, 36022},
	{"DICTATE", 7, 36023},
	{"RBRE", 4, 36024},
	{"RAWH", 4, 36025},
	{"CLOSES", 6, 36026},
	{"ZARD", 4, 36027},
	{"DROO", 4, 36028},
	{"FRUSTRATE", 9, 36029},
	{"PSYCHIATRY", 10, 36030},
	{"KBUT", 4, 36031},
	{"ONGF", 4, 36032},
	{"OFED", 4, 36033},
	{"PERSISTENT", 10, 36034},
	{"DEBORAH", 7, 36035},
	{"CONF", 4, 36036},
	{"MARCO", 5, 36037},
	{"ASSISTS", 7, 36038},
	{"SUMMARIES", 9, 36039},
	{"RSMI", 4, 36040},
	{"GLOW", 4, 36041},
	{"NYTI", 4, 36042},
	{"GABRIEL", 7, 36043},
	{"YOFB", 4, 36044},
	{"IERE", 4, 36045},
	{"LOWO", 4, 36046},
	{"RTIL", 4, 36047},
	{"AUDITOR", 7, 36048},
	{"WMA", 3, 36049},
	{"AQUARIUM", 8, 36050},
	{"VIOLIN", 6, 36051},
	{"PROPHET", 7, 36052},
	{"OTTL", 4, 36053},
	{"ERNT", 4, 36054},
	{"EEDW", 4, 36055},
	{"CIR", 3, 36056},
	{"FSAN", 4, 36057},
	{"RHES", 4, 36058},
	{"ACCELERATE", 10, 36059},
	{"DACR", 4, 36060},
	{"BRACKET", 7, 36061},
	{"LOOKSMART", 9, 36062},
	{"ISAAC", 5, 36063},
	{"OXIDE", 5, 36064},
	{"BORING", 6, 36065},
	{"DFAM", 4, 36066},
	{"LLLO", 4, 36067},
	{"OAKS", 4, 36068},
	{"LYCR", 4, 36069},
	{"YSIM", 4, 36070},
	{"VEDS", 4, 36071},
	{"SBIL", 4, 36072},
	{"RDSS", 4, 36073},
	{"MAGNIFICENT", 11, 36074},
	{"RLDT", 4, 36075},
	{"ERIK", 4, 36076},
	{"IAMO", 4, 36077},
	{"UNGS", 4, 36078},
	{"YELE", 4, 36079},
	{"YCHE", 4, 36080},
	{"NAPLES", 6, 36081},
	{"AYBU", 4, 36082},
	{"PROMPTLY", 8, 36083},
	{"MODEMS", 6, 36084},
	{"TOTU", 4, 36085},
	{"NGSM", 4, 36086},
	{"ADAPTATION", 10, 36087},
	{"HARMFUL", 7, 36088},
	{"UROW", 4, 36089},
	{"LOSU", 4, 36090},
	{"ETWH", 4, 36091},
	{"PAINTBALL", 9, 36092},
	{"PROZAC", 6, 36093},
	{"DDEM", 4, 36094},
	{"ENCLOSURE", 9, 36095},
	{"NGIV", 4, 36096},
	{"ACM", 3, 36097},
	{"DATL", 4, 36098},
	{"UTRI", 4, 36099},
	{"BYDE", 4, 36100},
	{"DIVIDEND", 8, 36101},
	{"GSID", 4, 36102},
	{"NEWARK", 6, 36103},
	{"KEOU", 4, 36104},
	{"PASO", 4, 36105},
	{"GLUCOSE", 7, 36106},
	{"PHANTOM", 7, 36107},
	{"PLAYBACK", 8, 36108},
	{"SUPERVISORS", 11, 36109},
	{"WESTMINSTER", 11, 36110},
	{"NCUR", 4, 36111},
	{"TURTLE", 6, 36112},
	{"IQB", 3, 36113},
	{"OMPT", 4, 36114},
	{"DISTANCES", 9, 36115},
	{"LFIL", 4, 36116},
	{"NGOO", 4, 36117},
	{"ABSORPTION", 10, 36118},
	{"TREASURES", 9, 36119},
	{"OEND", 4, 36120},
	{"DSC", 3, 36121},
	{"WARNED", 6, 36122},
	{"NEURAL", 6, 36123},
	{"WARE", 4, 36124},
	{"FOSSIL", 6, 36125},
	{"RESB", 4, 36126},
	{"HOMETOWN", 8, 36127},
	{"RSTL", 4, 36128},
	{"RTYL", 4, 36129},
	{"RTLE", 4, 36130},
	{"OTEX", 4, 36131},
	{"TRANSCRIPTS", 11, 36132},
	{"USEP", 4, 36133},
	{"LFAC", 4, 36134},
	{"APOLLO", 6, 36135},
	{"TBEH", 4, 36136},
	{"YSLA", 4, 36137},
	{"ILHE", 4, 36138},
	{"ONYM", 4, 36139},
	{"NDTU", 4, 36140},
	{"LBAC", 4, 36141},
	{"SDOM", 4, 36142},
	{"LBEF", 4, 36143},
	{"NEPR", 4, 36144},
	{"HESF", 4, 36145},
	{"CONTINUALLY", 11, 36146},
	{"COMMUNIST", 9, 36147},
	{"DBUR", 4, 36148},
	{"COLLECTIBLE", 11, 36149},
	{"FLIF", 4, 36150},
	{"HANDMADE", 8, 36151},
	{"ARHA", 4, 36152},
	{"AMWI", 4, 36153},
	{"YTOU", 4, 36154},
	{"FOUG", 4, 36155},
	{"EFTO", 4, 36156},
	{"GREENE", 6, 36157},
	{"ENTREPRENEURS", 13, 36158},
	{"BEVE", 4, 36159},
	{"OBUT", 4, 36160},
	{"ROBOTS", 6, 36161},
	{"GRENADA", 7, 36162},
	{"EVIT", 4, 36163},
	{"TLEV", 4, 36164},
	{"CREATIONS", 9, 36165},
	{"ISYO", 4, 36166},
	{"JADE", 4, 36167},
	{"SCOOP", 5, 36168},
	{"ETCA", 4, 36169},
	{"FATAL", 5, 36170},
	{"ONDB", 4, 36171},
	{"ACQUISITIONS", 12, 36172},
	{"OOMI", 4, 36173},
	{"MSHE", 4, 36174},
	{"FOUL", 4, 36175},
	{"UTLI", 4, 36176},
	{"KENO", 4, 36177},
	{"ILOV", 4, 36178},
	{"GTK", 3, 36179},
	{"EARNING", 7, 36180},
	{"MAILMAN", 7, 36181},
	{"DQB", 3, 36182},
	{"SANYO", 5, 36183},
	{"NESTED", 6, 36184},
	{"SMOD", 4, 36185},
	{"BIODIVERSITY", 12, 36186},
	{"SSAD", 4, 36187},
	{"OFRU", 4, 36188},
	{"YPAS", 4, 36189},
	{"GOQ", 3, 36190},
	{"OUSN", 4, 36191},
	{"LLBO", 4, 36192},
	{"TLYP", 4, 36193},
	{"RSDI", 4, 36194},
	{"SOMALIA", 7, 36195},
	{"MOVERS", 6, 36196},
	{"WEDE", 4, 36197},
	{"WRIG", 4, 36198},
	{"NDVA", 4, 36199},
	{"DEWH", 4, 36200},
	{"TJOH", 4, 36201},
	{"ADNE", 4, 36202},
	{"PRESENTLY", 9, 36203},
	{"MTOS", 4, 36204},
	{"CARLO", 5, 36205},
	{"DLON", 4, 36206},
	{"WORKFLOW", 8, 36207},
	{"OROR", 4, 36208},
	{"AWOM", 4, 36209},
	{"NOVELTY", 7, 36210},
	{"BRYANT", 6, 36211},
	{"IBEL", 4, 36212},
	{"TILES", 5, 36213},
	{"YANY", 4, 36214},
	{"VOYUER", 6, 36215},
	{"TTOK", 4, 36216},
	{"LIBRARIAN", 9, 36217},
	{"SUBSIDIARIES", 12, 36218},
	{"OLOC", 4, 36219},
	{"ALSY", 4, 36220},
	{"EBEH", 4, 36221},
	{"UTSE", 4, 36222},
	{"ERNP", 4, 36223},
	{"EABA", 4, 36224},
	{"SWITCHED", 8, 36225},
	{"STOCKHOLM", 9, 36226},
	{"TAMIL", 5, 36227},
	{"OFDR", 4, 36228},
	{"YGIV", 4, 36229},
	{"CKSH", 4, 36230},
	{"GARMIN", 6, 36231},
	{"DBLA", 4, 36232},
	{"OUWO", 4, 36233},
	{"FUZZY", 5, 36234},
	{"INDONESIAN", 10, 36235},
	{"FFTO", 4, 36236},
	{"GRAMS", 5, 36237},
	{"YISN", 4, 36238},
	{"USEL", 4, 36239},
	{"RIPL", 4, 36240},
	{"NSFI", 4, 36241},
	{"RICHARDS", 8, 36242},
	{"MRNA", 4, 36243},
	{"BUDGETS", 7, 36244},
	{"EDYE", 4, 36245},
	{"DCIT", 4, 36246},
	{"LFTO", 4, 36247},
	{"TOOLKIT", 7, 36248},
	{"DJOH", 4, 36249},
	{"RELAXATION", 10, 36250},
	{"IVK", 3, 36251},
	{"CARMEN", 6, 36252},
	{"SNEX", 4, 36253},
	{"THEREAFTER", 10, 36254},
	{"HARDWOOD", 8, 36255},
	{"EROTICA", 7, 36256},
	{"TEMPORAL", 8, 36257},
	{"LLCH", 4, 36258},
	{"OLKS", 4, 36259},
	{"FORGE", 5, 36260},
	{"COMMISSIONERS", 13, 36261},
	{"ICDI", 4, 36262},
	{"ISIB", 4, 36263},
	{"CEMO", 4, 36264},
	{"SISP", 4, 36265},
	{"ODOI", 4, 36266},
	{"DKNO", 4, 36267},
	{"STGE", 4, 36268},
	{"FORWARDING", 10, 36269},
	{"PTST", 4, 36270},
	{"LUNC", 4, 36271},
	{"REDUCTIONS", 10, 36272},
	{"SOUTHAMPTON", 11, 36273},
	{"DISG", 4, 36274},
	{"GSWI", 4, 36275},
	{"ISTANBUL", 8, 36276},
	{"SHEG", 4, 36277},
	{"FEWY", 4, 36278},
	{"UABL", 4, 36279},
	{"IFEW", 4, 36280},
	{"LBOA", 4, 36281},
	{"URPL", 4, 36282},
	{"UGHB", 4, 36283},
	{"ONCI", 4, 36284},
	{"ORGANISMS", 9, 36285},
	{"SEGA", 4, 36286},
	{"LLDI", 4, 36287},
	{"VIEWERS", 7, 36288},
	{"YUF", 3, 36289},
	{"KRH", 3, 36290},
	{"ITHK", 4, 36291},
	{"ASBESTOS", 8, 36292},
	{"IDWA", 4, 36293},
	{"PORTSMOUTH", 10, 36294},
	{"CDNA", 4, 36295},
	{"MEYER", 5, 36296},
	{"ENTERS", 6, 36297},
	{"ATOW", 4, 36298},
	{"POD", 3, 36299},
	{"RCIN", 4, 36300},
	{"DAYC", 4, 36301},
	{"SAVAGE", 6, 36302},
	{"ADVANCEMENT", 11, 36303},
	{"DEMP", 4, 36304},
	{"DBRA", 4, 36305},
	{"WILLOW", 6, 36306},
	{"RESUMES", 7, 36307},
	{"GAGE", 4, 36308},
	{"ENCR", 4, 36309},
	{"ADEW", 4, 36310},
	{"THROWING", 8, 36311},
	{"EXISTED", 7, 36312},
	{"RCHW", 4, 36313},
	{"WHORE", 5, 36314},
	{"GENERATORS", 10, 36315},
	{"TNUM", 4, 36316},
	{"BARBIE", 6, 36317},
	{"LLFA", 4, 36318},
	{"MEAF", 4, 36319},
	{"FAVOUR", 6, 36320},
	{"MYFA", 4, 36321},
	{"FNOR", 4, 36322},
	{"OTEV", 4, 36323},
	{"SMTP", 4, 36324},
	{"PGRA", 4, 36325},
	{"GENERATES", 9, 36326},
	{"POTATOES", 8, 36327},
	{"THOROUGH", 8, 36328},
	{"REPLICATION", 11, 36329},
	{"WSON", 4, 36330},
	{"INEXPENSIVE", 11, 36331},
	{"CKSW", 4, 36332},
	{"KURT", 4, 36333},
	{"RSLO", 4, 36334},
	{"RECEPTORS", 9, 36335},
	{"EJOH", 4, 36336},
	{"PEERS", 5, 36337},
	{"ROLAND", 6, 36338},
	{"OPTIMUM", 7, 36339},
	{"LDTA", 4, 36340},
	{"TFEA", 4, 36341},
	{"INTERVENTIONS", 13, 36342},
	{"QUILT", 5, 36343},
	{"HUNTINGTON", 10, 36344},
	{"OCLO", 4, 36345},
	{"MOUNTS", 6, 36346},
	{"FMOR", 4, 36347},
	{"SYRACUSE", 8, 36348},
	{"INTERNSHIP", 10, 36349},
	{"LONE", 4, 36350},
	{"WLIN", 4, 36351},
	{"REFRESH", 7, 36352},
	{"SRED", 4, 36353},
	{"VEAM", 4, 36354},
	{"ALUMINIUM", 9, 36355},
	{"SNOWBOARD", 9, 36356},
	{"NSLO", 4, 36357},
	{"WEBCAST", 7, 36358},
	{"FRUI", 4, 36359},
	{"MICHEL", 6, 36360},
	{"EVANESCENCE", 11, 36361},
	{"CKWH", 4, 36362},
	{"EMUR", 4, 36363},
	{"NGPI", 4, 36364},
	{"COORDINATED", 11, 36365},
	{"NOTRE", 5, 36366},
	{"SHIPMENTS", 9, 36367},
	{"MALDIVES", 8, 36368},
	{"STRIPES", 7, 36369},
	{"FIRMWARE", 8, 36370},
	{"MBLI", 4, 36371},
	{"ANTARCTICA", 10, 36372},
	{"DMAI", 4, 36373},
	{"ORPU", 4, 36374},
	{"NGPU", 4, 36375},
	{"SHEPHERD", 8, 36376},
	{"REBY", 4, 36377},
	{"UTHC", 4, 36378},
	{"CANBERRA", 8, 36379},
	{"CRADLE", 6, 36380},
	{"NFUL", 4, 36381},
	{"IORC", 4, 36382},
	{"ORFU", 4, 36383},
	{"CHANCELLOR", 10, 36384},
	{"MAMBO", 5, 36385},
	{"LIME", 4, 36386},
	{"SPLE", 4, 36387},
	{"KIRK", 4, 36388},
	{"NKYO", 4, 36389},
	{"SVIC", 4, 36390},
	{"RKHA", 4, 36391},
	{"DFOO", 4, 36392},
	{"RCUR", 4, 36393},
	{"MLIN", 4, 36394},
	{"LSOK", 4, 36395},
	{"ALEG", 4, 36396},
	{"LEGENDARY", 9, 36397},
	{"BOOL", 4, 36398},
	{"FSOU", 4, 36399},
	{"FGRE", 4, 36400},
	{"LMAK", 4, 36401},
	{"CHOIR", 5, 36402},
	{"AVOIDING", 8, 36403},
	{"ARPR", 4, 36404},
	{"BEAUTIFULLY", 11, 36405},
	{"NGJO", 4, 36406},
	{"EXPECTS", 7, 36407},
	{"JUMPING", 7, 36408},
	{"UCOU", 4, 36409},
	{"ITUP", 4, 36410},
	{"FABRICS", 7, 36411},
	{"ANTIBODIES", 10, 36412},
	{"POLYMER", 7, 36413},
	{"HYGIENE", 7, 36414},
	{"IRLA", 4, 36415},
	{"ODYW", 4, 36416},
	{"HWOR", 4, 36417},
	{"LLPO", 4, 36418},
	{"RSCR", 4, 36419},
	{"POULTRY", 7, 36420},
	{"DEPI", 4, 36421},
	{"DBUI", 4, 36422},
	{"EXAMINATIONS", 12, 36423},
	{"BORR", 4, 36424},
	{"SURGEONS", 8, 36425},
	{"NBYA", 4, 36426},
	{"BOUQUET", 7, 36427},
	{"NERB", 4, 36428},
	{"EEPL", 4, 36429},
	{"RLYD", 4, 36430},
	{"IMMUNOLOGY", 10, 36431},
	{"PROMOTES", 8, 36432},
	{"WILEY", 5, 36433},
	{"DEPARTMENTAL", 12, 36434},
	{"CORPUS", 6, 36435},
	{"RWEA", 4, 36436},
	{"JOHNSTON", 8, 36437},
	{"FACO", 4, 36438},
	{"TERMINOLOGY", 11, 36439},
	{"FIBRE", 5, 36440},
	{"REPRODUCE", 9, 36441},
	{"REEG", 4, 36442},
	{"CONVICTED", 9, 36443},
	{"SHADES", 6, 36444},
	{"IRRO", 4, 36445},
	{"INDICES", 7, 36446},
	{"ROOMMATES", 9, 36447},
	{"LDRA", 4, 36448},
	{"ADWARE", 6, 36449},
	{"ELLK", 4, 36450},
	{"DFRA", 4, 36451},
	{"VEEV", 4, 36452},
	{"AKEF", 4, 36453},
	{"DIBL", 4, 36454},
	{"CTFO", 4, 36455},
	{"THREATENING", 11, 36456},
	{"ZOLOFT", 6, 36457},
	{"LEYO", 4, 36458},
	{"ACTIVISTS", 9, 36459},
	{"FRANKFURT", 9, 36460},
	{"DFAC", 4, 36461},
	{"DAISY", 5, 36462},
	{"DDID", 4, 36463},
	{"OWFO", 4, 36464},
	{"TMEM", 4, 36465},
	{"HALIFAX", 7, 36466},
	{"RTHY", 4, 36467},
	{"ENCOURAGES", 10, 36468},
	{"TOQU", 4, 36469},
	{"GHTU", 4, 36470},
	{"ULTRAM", 6, 36471},
	{"RCHF", 4, 36472},
	{"CURSOR", 6, 36473},
	{"ASSEMBLED", 9, 36474},
	{"EARLIEST", 8, 36475},
	{"DONATED", 7, 36476},
	{"STUFFED", 7, 36477},
	{"SIXM", 4, 36478},
	{"RESTRUCTURING", 13, 36479},
	{"INSECTS", 7, 36480},
	{"TERMINALS", 9, 36481},
	{"CRUDE", 5, 36482},
	{"RTYI", 4, 36483},
	{"MORRISON", 8, 36484},
	{"MAIDEN", 6, 36485},
	{"SIMULATIONS", 11, 36486},
	{"KECO", 4, 36487},
	{"EAFR", 4, 36488},
	{"SUFFICIENTLY", 12, 36489},
	{"ADQU", 4, 36490},
	{"EXAMINES", 8, 36491},
	{"VIKING", 6, 36492},
	{"MYRTLE", 6, 36493},
	{"FALO", 4, 36494},
	{"BORED", 5, 36495},
	{"CLEANUP", 7, 36496},
	{"YARN", 4, 36497},
	{"DSRE", 4, 36498},
	{"RFY", 3, 36499},
	{"RBEL", 4, 36500},
	{"CONDITIONAL", 11, 36501},
	{"MUG", 3, 36502},
	{"ENBR", 4, 36503},
	{"CROSSWORD", 9, 36504},
	{"AYSM", 4, 36505},
	{"BUDAPEST", 8, 36506},
	{"NGEC", 4, 36507},
	{"CONCEPTUAL", 10, 36508},
	{"FPRI", 4, 36509},
	{"OWWI", 4, 36510},
	{"DQUI", 4, 36511},
	{"KNITTING", 8, 36512},
	{"LHOU", 4, 36513},
	{"ATTACKED", 8, 36514},
	{"SOFV", 4, 36515},
	{"TSCR", 4, 36516},
	{"MAYT", 4, 36517},
	{"ROUR", 4, 36518},
	{"BHUTAN", 6, 36519},
	{"LIECHTENSTEIN", 13, 36520},
	{"MATING", 6, 36521},
	{"COMPUTE", 7, 36522},
	{"REDHEAD", 7, 36523},
	{"APUB", 4, 36524},
	{"DONF", 4, 36525},
	{"ARRIVES", 7, 36526},
	{"TRANSLATOR", 10, 36527},
	{"AUTOMOBILES", 11, 36528},
	{"TRACTOR", 7, 36529},
	{"ALLAH", 5, 36530},
	{"KDOW", 4, 36531},
	{"EUPA", 4, 36532},
	{"LYOR", 4, 36533},
	{"UNWRAP", 6, 36534},
	{"FARES", 5, 36535},
	{"RSEM", 4, 36536},
	{"LESD", 4, 36537},
	{"LONGITUDE", 9, 36538},
	{"ALKT", 4, 36539},
	{"UCET", 4, 36540},
	{"GERP", 4, 36541},
	{"UKV", 3, 36542},
	{"YBES", 4, 36543},
	{"OOUR", 4, 36544},
	{"NDMY", 4, 36545},
	{"CHALLENGED", 10, 36546},
	{"TELECHARGER", 11, 36547},
	{"HOPED", 5, 36548},
	{"UGHP", 4, 36549},
	{"PIKE", 4, 36550},
	{"SAFER", 5, 36551},
	{"INSERTION", 9, 36552},
	{"ABLO", 4, 36553},
	{"RSFI", 4, 36554},
	{"DCUP", 4, 36555},
	{"INSTRUMENTATION", 15, 36556},
	{"DBLO", 4, 36557},
	{"HUGO", 4, 36558},
	{"ICKU", 4, 36559},
	{"WAGNER", 6, 36560},
	{"GROUNDWATER", 11, 36561},
	{"TOUCHED", 7, 36562},
	{"STRENGTHENING", 13, 36563},
	{"DSIX", 4, 36564},
	{"COLOGNE", 7, 36565},
	{"DBYO", 4, 36566},
	{"GZIP", 4, 36567},
	{"RANGER", 6, 36568},
	{"LGRA", 4, 36569},
	{"SMALLEST", 8, 36570},
	{"TEDK", 4, 36571},
	{"INSULATION", 10, 36572},
	{"NEWMAN", 6, 36573},
	{"MARSH", 5, 36574},
	{"PUTY", 4, 36575},
	{"RBAL", 4, 36576},
	{"RICKY", 5, 36577},
	{"CTRL", 4, 36578},
	{"LOWC", 4, 36579},
	{"LRIG", 4, 36580},
	{"INFRINGEMENT", 12, 36581},
	{"OULO", 4, 36582},
	{"OLDP", 4, 36583},
	{"UGY", 3, 36584},
	{"WEWO", 4, 36585},
	{"SUBJECTIVE", 10, 36586},
	{"MONSTERS", 8, 36587},
	{"DFIV", 4, 36588},
	{"ASYLUM", 6, 36589},
	{"RKEY", 4, 36590},
	{"LIGHTBOX", 8, 36591},
	{"ROBBIE", 6, 36592},
	{"GPOI", 4, 36593},
	{"RPOI", 4, 36594},
	{"COCKTAIL", 8, 36595},
	{"LTOW", 4, 36596},
	{"OUTLETS", 7, 36597},
	{"UNDC", 4, 36598},
	{"IZAB", 4, 36599},
	{"ANYG", 4, 36600},
	{"TREQ", 4, 36601},
	{"LDEC", 4, 36602},
	{"RYMO", 4, 36603},
	{"SWAZILAND", 9, 36604},
	{"ERSK", 4, 36605},
	{"VARIETIES", 9, 36606},
	{"ARBOR", 5, 36607},
	{"MEDIAWIKI", 9, 36608},
	{"RVEA", 4, 36609},
	{"CONFIGURATIONS", 14, 36610},
	{"POISON", 6, 36611},
	{"ETHNICITY", 9, 36612},
	{"DOMINATED", 9, 36613},
	{"NLEY", 4, 36614},
	{"IRDO", 4, 36615},
	{"OBEB", 4, 36616},
	{"RBEA", 4, 36617},
	{"DERIVATIVES", 11, 36618},
	{"PREVENTS", 8, 36619},
	{"ITBU", 4, 36620},
	{"STITCH", 6, 36621},
	{"RISB", 4, 36622},
	{"LESOTHO", 7, 36623},
	{"SEVERITY", 8, 36624},
	{"EMYS", 4, 36625},
	{"RDSC", 4, 36626},
	{"ELYE", 4, 36627},
	{"FAPP", 4, 36628},
	{"RFID", 4, 36629},
	{"NOTABLE", 7, 36630},
	{"ALDR", 4, 36631},
	{"WARFARE", 7, 36632},
	{"TCLE", 4, 36633},
	{"RETAILING", 9, 36634},
	{"JUDICIARY", 9, 36635},
	{"EMBROIDERY", 10, 36636},
	{"MAMA", 4, 36637},
	{"INLAND", 6, 36638},
	{"OSCOMMERCE", 10, 36639},
	{"NONFICTION", 10, 36640},
	{"LSEW", 4, 36641},
	{"HOMEOWNERS", 10, 36642},
	{"LDAY", 4, 36643},
	{"KEAD", 4, 36644},
	{"OCCE", 4, 36645},
	{"WSOF", 4, 36646},
	{"ARKT", 4, 36647},
	{"GREENLAND", 9, 36648},
	{"RCOA", 4, 36649},
	{"YLOO", 4, 36650},
	{"EVEM", 4, 36651},
	{"ACCORD", 6, 36652},
	{"GAMERS", 6, 36653},
	{"NSUB", 4, 36654},
	{"LICENSEE", 8, 36655},
	{"COUNTRYSIDE", 11, 36656},
	{"SORTING", 7, 36657},
	{"LIAISON", 7, 36658},
	{"NFLO", 4, 36659},
	{"ELLU", 4, 36660},
	{"EOFU", 4, 36661},
	{"NCHU", 4, 36662},
	{"NTBY", 4, 36663},
	{"UNUSED", 6, 36664},
	{"BULBS", 5, 36665},
	{"LLFR", 4, 36666},
	{"YBOA", 4, 36667},
	{"UTAF", 4, 36668},
	{"EDFE", 4, 36669},
	{"RAUD", 4, 36670},
	{"CONSUMING", 9, 36671},
	{"INSTALLER", 9, 36672},
	{"VENF", 4, 36673},
	{"TOURISTS", 8, 36674},
	{"RDRO", 4, 36675},
	{"SANDALS", 7, 36676},
	{"YSPR", 4, 36677},
	{"GHCO", 4, 36678},
	{"POWERSHOT", 9, 36679},
	{"BESTSELLING", 11, 36680},
	{"KWHI", 4, 36681},
	{"VEMI", 4, 36682},
	{"INSURE", 6, 36683},
	{"PACKAGED", 8, 36684},
	{"BEHAVIORS", 9, 36685},
	{"CLARIFY", 7, 36686},
	{"OODM", 4, 36687},
	{"EYDE", 4, 36688},
	{"NOFD", 4, 36689},
	{"SECONDED", 8, 36690},
	{"ACTIVATE", 8, 36691},
	{"UNER", 4, 36692},
	{"ATTRIBUTED", 10, 36693},
	{"SEYCHELLES", 10, 36694},
	{"PATRIOT", 7, 36695},
	{"EDOL", 4, 36696},
	{"UREG", 4, 36697},
	{"LOFS", 4, 36698},
	{"GKY", 3, 36699},
	{"SEWER", 5, 36700},
	{"CRYSTALS", 8, 36701},
	{"KATHLEEN", 8, 36702},
	{"MSCO", 4, 36703},
	{"BOSCH", 5, 36704},
	{"YWEA", 4, 36705},
	{"FORTHCOMING", 11, 36706},
	{"SANDISK", 7, 36707},
	{"NSYL", 4, 36708},
	{"GEDF", 4, 36709},
	{"TREATS", 6, 36710},
	{"OMEV", 4, 36711},
	{"MARINO", 6, 36712},
	{"LFUN", 4, 36713},
	{"DETENTION", 9, 36714},
	{"RMAI", 4, 36715},
	{"CARSON", 6, 36716},
	{"TICF", 4, 36717},
	{"YALO", 4, 36718},
	{"VITRO", 5, 36719},
	{"PHOM", 4, 36720},
	{"EXCEEDS", 7, 36721},
	{"DWON", 4, 36722},
	{"COMPLEMENTARY", 13, 36723},
	{"COSPONSORS", 10, 36724},
	{"GALLON", 6, 36725},
	{"WOMO", 4, 36726},
	{"COIL", 4, 36727},
	{"BATTLES", 7, 36728},
	{"HYATT", 5, 36729},
	{"TRADERS", 7, 36730},
	{"CARLTON", 7, 36731},
	{"GTWO", 4, 36732},
	{"MEMORANDUM", 10, 36733},
	{"OUPI", 4, 36734},
	{"LMAT", 4, 36735},
	{"BURNED", 6, 36736},
	{"CARDINAL", 8, 36737},
	{"DRAGONS", 7, 36738},
	{"CONVERTING", 10, 36739},
	{"ROMEO", 5, 36740},
	{"RGIV", 4, 36741},
	{"BURUNDI", 7, 36742},
	{"DSFR", 4, 36743},
	{"LYTW", 4, 36744},
	{"RRIB", 4, 36745},
	{"SBLA", 4, 36746},
	{"DELEGATES", 9, 36747},
	{"MSFO", 4, 36748},
	{"TURKS", 5, 36749},
	{"NGQU", 4, 36750},
	{"ROMA", 4, 36751},
	{"DEMOS", 5, 36752},
	{"BALANCING", 9, 36753},
	{"SIDED", 5, 36754},
	{"CLAIMING", 8, 36755},
	{"ALBR", 4, 36756},
	{"PSYCHIATRIC", 11, 36757},
	{"NPOR", 4, 36758},
	{"TITTENS", 7, 36759},
	{"TEENAGERS", 9, 36760},
	{"COURTYARD", 9, 36761},
	{"PRESIDENTS", 10, 36762},
	{"TLOC", 4, 36763},
	{"RURA", 4, 36764},
	{"TPOP", 4, 36765},
	{"TCAU", 4, 36766},
	{"OFFENDERS", 9, 36767},
	{"VEAD", 4, 36768},
	{"RNOV", 4, 36769},
	{"EAMC", 4, 36770},
	{"GRADING", 7, 36771},
	{"TENANTS", 7, 36772},
	{"EXPRESSLY", 9, 36773},
	{"NLIF", 4, 36774},
	{"GHTG", 4, 36775},
	{"LILY", 4, 36776},
	{"RENW", 4, 36777},
	{"BRACKETS", 8, 36778},
	{"UNOFFICIAL", 10, 36779},
	{"RBEE", 4, 36780},
	{"ITUR", 4, 36781},
	{"OVERSIGHT", 9, 36782},
	{"BIGT", 4, 36783},
	{"VALENTINES", 10, 36784},
	{"VONAGE", 6, 36785},
	{"YTRI", 4, 36786},
	{"AILR", 4, 36787},
	{"WETLANDS", 8, 36788},
	{"MEDW", 4, 36789},
	{"MINDED", 6, 36790},
	{"AMFO", 4, 36791},
	{"STQU", 4, 36792},
	{"LINV", 4, 36793},
	{"RESIN", 5, 36794},
	{"ELLD", 4, 36795},
	{"NEDY", 4, 36796},
	{"ALLIES", 6, 36797},
	{"TWILIGHT", 8, 36798},
	{"LEYW", 4, 36799},
	{"PRESERVED", 9, 36800},
	{"CROSSED", 7, 36801},
	{"EYBO", 4, 36802},
	{"KENSINGTON", 10, 36803},
	{"MONTEREY", 8, 36804},
	{"YRF", 3, 36805},
	{"EGYP", 4, 36806},
	{"LINEN", 5, 36807},
	{"LECL", 4, 36808},
	{"QUICKTIME", 9, 36809},
	{"OMCA", 4, 36810},
	{"LYEV", 4, 36811},
	{"ASCENDING", 9, 36812},
	{"SEALS", 5, 36813},
	{"NOMINAL", 7, 36814},
	{"DEXC", 4, 36815},
	{"ALICIA", 6, 36816},
	{"LKER", 4, 36817},
	{"DECAY", 5, 36818},
	{"WEAKNESSES", 10, 36819},
	{"BERH", 4, 36820},
	{"UNDERWATER", 10, 36821},
	{"QUARTZ", 6, 36822},
	{"XWR", 3, 36823},
	{"DASW", 4, 36824},
	{"TDIR", 4, 36825},
	{"GEPR", 4, 36826},
	{"RLYP", 4, 36827},
	{"REGISTERS", 9, 36828},
	{"USHER", 5, 36829},
	{"URRA", 4, 36830},
	{"JUW", 3, 36831},
	{"DWOM", 4, 36832},
	{"HERBERT", 7, 36833},
	{"SBOD", 4, 36834},
	{"DOFI", 4, 36835},
	{"ICKW", 4, 36836},
	{"LKAB", 4, 36837},
	{"AUTHORISED", 10, 36838},
	{"YZU", 3, 36839},
	{"IMPROVES", 8, 36840},
	{"YBER", 4, 36841},
	{"BOXI", 4, 36842},
	{"ADVOCATES", 9, 36843},
	{"OBOD", 4, 36844},
	{"RYFR", 4, 36845},
	{"KWHE", 4, 36846},
	{"RMEA", 4, 36847},
	{"IREP", 4, 36848},
	{"PAYF", 4, 36849},
	{"PHENOMENA", 9, 36850},
	{"YVER", 4, 36851},
	{"AIDD", 4, 36852},
	{"BUFFET", 6, 36853},
	{"DECIDING", 8, 36854},
	{"ILDC", 4, 36855},
	{"SKATE", 5, 36856},
	{"DREV", 4, 36857},
	{"RDSE", 4, 36858},
	{"VANUATU", 7, 36859},
	{"GCAN", 4, 36860},
	{"RBRA", 4, 36861},
	{"LFRI", 4, 36862},
	{"DJAC", 4, 36863},
	{"LBEL", 4, 36864},
	{"RRAI", 4, 36865},
	{"JOEY", 4, 36866},
	{"RREV", 4, 36867},
	{"EROTIK", 6, 36868},
	{"NCYA", 4, 36869},
	{"HACKERS", 7, 36870},
	{"LCAM", 4, 36871},
	{"RTAR", 4, 36872},
	{"ZGU", 3, 36873},
	{"XYP", 3, 36874},
	{"GRANITE", 7, 36875},
	{"LYNCH", 5, 36876},
	{"TQUI", 4, 36877},
	{"MASSES", 6, 36878},
	{"HADW", 4, 36879},
	{"TRANSFORMED", 11, 36880},
	{"BSID", 4, 36881},
	{"TARGETING", 9, 36882},
	{"FRANC", 5, 36883},
	{"BEAD", 4, 36884},
	{"MESD", 4, 36885},
	{"DBYG", 4, 36886},
	{"PRESCHOOL", 9, 36887},
	{"AMOV", 4, 36888},
	{"LANDLORD", 8, 36889},
	{"RPEN", 4, 36890},
	{"TFUN", 4, 36891},
	{"LEAK", 4, 36892},
	{"TIMOR", 5, 36893},
	{"OFVA", 4, 36894},
	{"ASSORTED", 8, 36895},
	{"ORDF", 4, 36896},
	{"LYCL", 4, 36897},
	{"IMPLEMENTS", 10, 36898},
	{"FLATS", 5, 36899},
	{"VOUCHERS", 8, 36900},
	{"MEGAPIXEL", 9, 36901},
	{"BOOKLET", 7, 36902},
	{"NGRY", 4, 36903},
	{"EXPECTING", 9, 36904},
	{"XICA", 4, 36905},
	{"CANCUN", 6, 36906},
	{"SROU", 4, 36907},
	{"SROL", 4, 36908},
	{"MTOF", 4, 36909},
	{"HEELS", 5, 36910},
	{"RMOV", 4, 36911},
	{"LYGR", 4, 36912},
	{"TURNOVER", 8, 36913},
	{"URINE", 5, 36914},
	{"CHERYL", 6, 36915},
	{"RADEON", 6, 36916},
	{"CAPRI", 5, 36917},
	{"FKG", 3, 36918},
	{"ORYC", 4, 36919},
	{"GINGER", 6, 36920},
	{"ITALICIZED", 10, 36921},
	{"OLDR", 4, 36922},
	{"INGQ", 4, 36923},
	{"EREJ", 4, 36924},
	{"SUBURBS", 7, 36925},
	{"NDIG", 4, 36926},
	{"TCRI", 4, 36927},
	{"IMAGERY", 7, 36928},
	{"CHROMOSOME", 10, 36929},
	{"OPTIMIZED", 9, 36930},
	{"DROV", 4, 36931},
	{"FFAL", 4, 36932},
	{"SEARS", 5, 36933},
	{"VEAG", 4, 36934},
	{"KSLI", 4, 36935},
	{"FWHO", 4, 36936},
	{"HCOL", 4, 36937},
	{"ROFD", 4, 36938},
	{"FFL", 3, 36939},
	{"VEWH", 4, 36940},
	{"FLIES", 5, 36941},
	{"UPGRADED", 8, 36942},
	{"COMPETENCE", 10, 36943},
	{"THBR", 4, 36944},
	{"INADEQUATE", 10, 36945},
	{"NYCA", 4, 36946},
	{"CRYING", 6, 36947},
	{"OVIC", 4, 36948},
	{"MATTHEWS", 8, 36949},
	{"TACL", 4, 36950},
	{"LAYB", 4, 36951},
	{"MERM", 4, 36952},
	{"CRANE", 5, 36953},
	{"DEFENDANTS", 10, 36954},
	{"FFSE", 4, 36955},
	{"YOFE", 4, 36956},
	{"OFKI", 4, 36957},
	{"DEPLOYED", 8, 36958},
	{"GOVERNED", 8, 36959},
	{"ORTB", 4, 36960},
	{"PEDW", 4, 36961},
	{"GSPE", 4, 36962},
	{"INVESTIGATING", 13, 36963},
	{"GSCO", 4, 36964},
	{"ROTTEN", 6, 36965},
	{"GETM", 4, 36966},
	{"POPUP", 5, 36967},
	{"GARNET", 6, 36968},
	{"LBAS", 4, 36969},
	{"SCATTERED", 9, 36970},
	{"OMAM", 4, 36971},
	{"HONOUR", 6, 36972},
	{"USELESS", 7, 36973},
	{"PROTECTS", 8, 36974},
	{"ORKH", 4, 36975},
	{"NORTHWESTERN", 12, 36976},
	{"AUDIENCES", 9, 36977},
	{"YGRE", 4, 36978},
	{"COUPE", 5, 36979},
	{"BENIN", 5, 36980},
	{"UYJ", 3, 36981},
	{"USWI", 4, 36982},
	{"RYSH", 4, 36983},
	{"PPP", 3, 36984},
	{"BACH", 4, 36985},
	{"MANAGES", 7, 36986},
	{"ITYG", 4, 36987},
	{"EROSION", 7, 36988},
	{"OCEANIA", 7, 36989},
	{"ORFE", 4, 36990},
	{"ABUNDANCE", 9, 36991},
	{"BERB", 4, 36992},
	{"CARPENTER", 9, 36993},
	{"INSUFFICIENT", 12, 36994},
	{"ROMJ", 4, 36995},
	{"INMU", 4, 36996},
	{"HIGHLANDS", 9, 36997},
	{"PETERS", 6, 36998},
	{"FERTILITY", 9, 36999},
	{"RNOF", 4, 37000},
	{"FORMULATION", 11, 37001},
	{"DBOO", 4, 37002},
	{"CLEVER", 6, 37003},
	{"PRIMER", 6, 37004},
	{"DFOL", 4, 37005},
	{"LORDS", 5, 37006},
	{"TENDS", 5, 37007},
	{"ALFE", 4, 37008},
	{"FRESNO", 6, 37009},
	{"LYAG", 4, 37010},
	{"ALOP", 4, 37011},
	{"AIRB", 4, 37012},
	{"ENJOYABLE", 9, 37013},
	{"HANDBAG", 7, 37014},
	{"ILEF", 4, 37015},
	{"TYBE", 4, 37016},
	{"MESL", 4, 37017},
	{"BEEX", 4, 37018},
	{"SBRE", 4, 37019},
	{"CRESCENT", 8, 37020},
	{"WAYN", 4, 37021},
	{"BYPASS", 6, 37022},
	{"TOWR", 4, 37023},
	{"PLAYGROUND", 10, 37024},
	{"LOGOUT", 6, 37025},
	{"KEWI", 4, 37026},
	{"UCHB", 4, 37027},
	{"ORGIES", 6, 37028},
	{"PERMANENTLY", 11, 37029},
	{"YCAS", 4, 37030},
	{"LYBR", 4, 37031},
	{"CONCENTRATED", 12, 37032},
	{"CKAT", 4, 37033},
	{"PLYT", 4, 37034},
	{"KWW", 3, 37035},
	{"GUEA", 4, 37036},
	{"LDWE", 4, 37037},
	{"DOFD", 4, 37038},
	{"VALR", 4, 37039},
	{"HOGTIED", 7, 37040},
	{"LPHO", 4, 37041},
	{"ECIR", 4, 37042},
	{"ODOU", 4, 37043},
	{"PROJECTIONS", 11, 37044},
	{"YITW", 4, 37045},
	{"ORPL", 4, 37046},
	{"ILYB", 4, 37047},
	{"CLIPART", 7, 37048},
	{"SECURING", 8, 37049},
	{"RRYS", 4, 37050},
	{"PATHWAY", 7, 37051},
	{"LESR", 4, 37052},
	{"DETECTORS", 9, 37053},
	{"WNCO", 4, 37054},
	{"FULS", 4, 37055},
	{"DSUN", 4, 37056},
	{"GSCH", 4, 37057},
	{"NEWSGROUPS", 10, 37058},
	{"RCET", 4, 37059},
	{"ESBR", 4, 37060},
	{"DKIL", 4, 37061},
	{"SPIKE", 5, 37062},
	{"PLATED", 6, 37063},
	{"IOGR", 4, 37064},
	{"JACQUES", 7, 37065},
	{"GEXP", 4, 37066},
	{"REDG", 4, 37067},
	{"SPECTRA", 7, 37068},
	{"LZU", 3, 37069},
	{"LIFTING", 7, 37070},
	{"DOFB", 4, 37071},
	{"JUDITH", 6, 37072},
	{"DISCLOSED", 9, 37073},
	{"DAVIES", 6, 37074},
	{"EPAP", 4, 37075},
	{"OLIF", 4, 37076},
	{"TACTICAL", 8, 37077},
	{"IKEP", 4, 37078},
	{"AIDP", 4, 37079},
	{"PILOTS", 6, 37080},
	{"MAILBOX", 7, 37081},
	{"OOLC", 4, 37082},
	{"COPENHAGEN", 10, 37083},
	{"FSEV", 4, 37084},
	{"RNCO", 4, 37085},
	{"ROFR", 4, 37086},
	{"OPERATIVE", 9, 37087},
	{"EWME", 4, 37088},
	{"UVER", 4, 37089},
	{"HUMOUR", 6, 37090},
	{"KCIT", 4, 37091},
	{"ATHLON", 6, 37092},
	{"MATURITY", 8, 37093},
	{"CALLER", 6, 37094},
	{"DISTORTION", 10, 37095},
	{"DNUM", 4, 37096},
	{"PTOF", 4, 37097},
	{"ESMU", 4, 37098},
	{"RTEL", 4, 37099},
	{"TYBU", 4, 37100},
	{"LOFH", 4, 37101},
	{"ADEU", 4, 37102},
	{"THBU", 4, 37103},
	{"RIBL", 4, 37104},
	{"ONCU", 4, 37105},
	{"LANDSCAPING", 11, 37106},
	{"GSFO", 4, 37107},
	{"TONGA", 5, 37108},
	{"IMPRINT", 7, 37109},
	{"ICLI", 4, 37110},
	{"YLOC", 4, 37111},
	{"BYSO", 4, 37112},
	{"KORN", 4, 37113},
	{"NATALIE", 7, 37114},
	{"RECEIPTS", 8, 37115},
	{"ASSISTING", 9, 37116},
	{"SHIRLEY", 7, 37117},
	{"NOWC", 4, 37118},
	{"HADG", 4, 37119},
	{"RQUA", 4, 37120},
	{"WWAS", 4, 37121},
	{"EMFO", 4, 37122},
	{"SANCTIONS", 9, 37123},
	{"DIRECTV", 7, 37124},
	{"NGKO", 4, 37125},
	{"COTL", 4, 37126},
	{"USWH", 4, 37127},
	{"GOODBYE", 7, 37128},
	{"ISFU", 4, 37129},
	{"YWAR", 4, 37130},
	{"VIABLE", 6, 37131},
	{"RGOO", 4, 37132},
	{"EMERGED", 7, 37133},
	{"DEVIANTART", 10, 37134},
	{"DEFECT", 6, 37135},
	{"RDEL", 4, 37136},
	{"GECA", 4, 37137},
	{"DMUC", 4, 37138},
	{"DCRI", 4, 37139},
	{"WNLO", 4, 37140},
	{"ABAL", 4, 37141},
	{"POORLY", 6, 37142},
	{"YNOW", 4, 37143},
	{"MEDY", 4, 37144},
	{"GODDESS", 7, 37145},
	{"BACKS", 5, 37146},
	{"IDCO", 4, 37147},
	{"OBSERVERS", 9, 37148},
	{"AQUE", 4, 37149},
	{"MAGNETS", 7, 37150},
	{"FORMULAS", 8, 37151},
	{"MBRI", 4, 37152},
	{"SPACIOUS", 8, 37153},
	{"SHOULDERS", 9, 37154},
	{"ARGUES", 6, 37155},
	{"GERR", 4, 37156},
	{"WADE", 4, 37157},
	{"GAFT", 4, 37158},
	{"VEFR", 4, 37159},
	{"OFOP", 4, 37160},
	{"SOILS", 5, 37161},
	{"ELUC", 4, 37162},
	{"OLEM", 4, 37163},
	{"OVEF", 4, 37164},
	{"ALCI", 4, 37165},
	{"YHAL", 4, 37166},
	{"RXM", 3, 37167},
	{"CHAPMAN", 7, 37168},
	{"ORGANS", 6, 37169},
	{"DLEY", 4, 37170},
	{"TPUB", 4, 37171},
	{"URMA", 4, 37172},
	{"NBUI", 4, 37173},
	{"YSPA", 4, 37174},
	{"ELPO", 4, 37175},
	{"BELOVED", 7, 37176},
	{"ILEB", 4, 37177},
	{"WUW", 3, 37178},
	{"NGMY", 4, 37179},
	{"BALLARD", 7, 37180},
	{"BEATING", 7, 37181},
	{"FAITHFUL", 8, 37182},
	{"EWZE", 4, 37183},
	{"HUNKS", 5, 37184},
	{"APPELLANT", 9, 37185},
	{"LLOO", 4, 37186},
	{"LIBYA", 5, 37187},
	{"OFFENCE", 7, 37188},
	{"SOFU", 4, 37189},
	{"CHDI", 4, 37190},
	{"INVESTED", 8, 37191},
	{"WHATSOEVER", 10, 37192},
	{"NUMBERED", 8, 37193},
	{"RSIM", 4, 37194},
	{"UBZ", 3, 37195},
	{"DLIT", 4, 37196},
	{"TERMINATED", 10, 37197},
	{"DSBE", 4, 37198},
	{"LLIV", 4, 37199},
	{"EXPANDS", 7, 37200},
	{"ULYA", 4, 37201},
	{"LITHIUM", 7, 37202},
	{"SEDAN", 5, 37203},
	{"PONY", 4, 37204},
	{"COMPRISES", 9, 37205},
	{"BOLTON", 6, 37206},
	{"OFBL", 4, 37207},
	{"FOUNDING", 8, 37208},
	{"YSWE", 4, 37209},
	{"PLANTING", 8, 37210},
	{"ALPHABETICALLY", 14, 37211},
	{"FACIALS", 7, 37212},
	{"COVENANT", 8, 37213},
	{"NPOP", 4, 37214},
	{"DROPPING", 8, 37215},
	{"LDGE", 4, 37216},
	{"CALORIES", 8, 37217},
	{"EMSW", 4, 37218},
	{"AIRWAYS", 7, 37219},
	{"ARCHAEOLOGY", 11, 37220},
	{"OMRE", 4, 37221},
	{"YSAR", 4, 37222},
	{"REFILL", 6, 37223},
	{"REAGAN", 6, 37224},
	{"SAILOR", 6, 37225},
	{"FITTINGS", 8, 37226},
	{"LINING", 6, 37227},
	{"BANQUET", 7, 37228},
	{"CARES", 5, 37229},
	{"SANCTUARY", 9, 37230},
	{"FLORA", 5, 37231},
	{"TAXP", 4, 37232},
	{"ECYC", 4, 37233},
	{"KAZAA", 5, 37234},
	{"RLYM", 4, 37235},
	{"EINSTEIN", 8, 37236},
	{"EDDR", 4, 37237},
	{"WZEA", 4, 37238},
	{"HILARY", 6, 37239},
	{"ILRO", 4, 37240},
	{"QUOTATION", 9, 37241},
	{"EQUALS", 6, 37242},
	{"GXU", 3, 37243},
	{"HARDY", 5, 37244},
	{"ERYR", 4, 37245},
	{"VCD", 3, 37246},
	{"JUMPER", 6, 37247},
	{"CARAVAN", 7, 37248},
	{"DIAGRAMS", 8, 37249},
	{"DDEL", 4, 37250},
	{"HARNESS", 7, 37251},
	{"MAJORS", 6, 37252},
	{"HEADSETS", 8, 37253},
	{"TFAL", 4, 37254},
	{"YRIG", 4, 37255},
	{"MANIPULATION", 12, 37256},
	{"BELLS", 5, 37257},
	{"VASCULAR", 8, 37258},
	{"IMPRESSIONS", 11, 37259},
	{"YANKEES", 7, 37260},
	{"YBD", 3, 37261},
	{"TYOR", 4, 37262},
	{"TOXICITY", 8, 37263},
	{"FORWARDED", 9, 37264},
	{"FABO", 4, 37265},
	{"STCL", 4, 37266},
	{"RSIG", 4, 37267},
	{"TRANSMITTER", 11, 37268},
	{"BYPA", 4, 37269},
	{"DOROTHY", 7, 37270},
	{"LYGE", 4, 37271},
	{"FREEMAN", 7, 37272},
	{"DENIM", 5, 37273},
	{"GREENVILLE", 10, 37274},
	{"ANDRE", 5, 37275},
	{"NEIGHBORHOODS", 13, 37276},
	{"NLAR", 4, 37277},
	{"PUPPIES", 7, 37278},
	{"RELAXING", 8, 37279},
	{"TICR", 4, 37280},
	{"DELPHI", 6, 37281},
	{"TROPHY", 6, 37282},
	{"LDRI", 4, 37283},
	{"BUICK", 5, 37284},
	{"SLIPKNOT", 8, 37285},
	{"SDEB", 4, 37286},
	{"SIGHTS", 6, 37287},
	{"UNIFORMS", 8, 37288},
	{"SWID", 4, 37289},
	{"RESIDUAL", 8, 37290},
	{"DISASTERS", 9, 37291},
	{"YRP", 3, 37292},
	{"ASTERISK", 8, 37293},
	{"GONL", 4, 37294},
	{"DABI", 4, 37295},
	{"VERSATILE", 9, 37296},
	{"LIQUOR", 6, 37297},
	{"KINDERGARTEN", 12, 37298},
	{"MYOU", 4, 37299},
	{"ALAG", 4, 37300},
	{"OFCE", 4, 37301},
	{"PROFITABLE", 10, 37302},
	{"WOUNDED", 7, 37303},
	{"DGOT", 4, 37304},
	{"CLAYTON", 7, 37305},
	{"EFUR", 4, 37306},
	{"RTSF", 4, 37307},
	{"RMAD", 4, 37308},
	{"DERIVATIVE", 10, 37309},
	{"SUFFOLK", 7, 37310},
	{"GYPT", 4, 37311},
	{"YERO", 4, 37312},
	{"NECKLACES", 9, 37313},
	{"STORESSHOP", 10, 37314},
	{"RPUB", 4, 37315},
	{"OCCUPANCY", 9, 37316},
	{"POSTGRADUATE", 12, 37317},
	{"DOSES", 5, 37318},
	{"TDRI", 4, 37319},
	{"BAKED", 5, 37320},
	{"ACHB", 4, 37321},
	{"DAYTONA", 7, 37322},
	{"WASTEWATER", 10, 37323},
	{"DROB", 4, 37324},
	{"PREJUDICE", 9, 37325},
	{"HERZEGOVINA", 11, 37326},
	{"ODRE", 4, 37327},
	{"GYEA", 4, 37328},
	{"MSWE", 4, 37329},
	{"CONSTRUCTOR", 11, 37330},
	{"PYOU", 4, 37331},
	{"TECHNICIANS", 11, 37332},
	{"SUBU", 4, 37333},
	{"DEBBIE", 6, 37334},
	{"PROBABLE", 8, 37335},
	{"DFUN", 4, 37336},
	{"ISSUANCE", 8, 37337},
	{"BALDWIN", 7, 37338},
	{"DSMO", 4, 37339},
	{"YPB", 3, 37340},
	{"MBPS", 4, 37341},
	{"INCORPORATION", 13, 37342},
	{"VEOR", 4, 37343},
	{"ONGU", 4, 37344},
	{"EVOLUTIONARY", 12, 37345},
	{"EADQ", 4, 37346},
	{"TCLO", 4, 37347},
	{"BYAC", 4, 37348},
	{"ECTM", 4, 37349},
	{"DECORATION", 10, 37350},
	{"DYTH", 4, 37351},
	{"NATIONALS", 9, 37352},
	{"ILYF", 4, 37353},
	{"TROJAN", 6, 37354},
	{"ASSISTANTS", 10, 37355},
	{"SPINAL", 6, 37356},
	{"BYCA", 4, 37357},
	{"DORD", 4, 37358},
	{"ELIMINATED", 10, 37359},
	{"ALITO", 5, 37360},
	{"SOONER", 6, 37361},
	{"TFAM", 4, 37362},
	{"STRUGGLING", 10, 37363},
	{"ENACTED", 7, 37364},
	{"WATERFRONT", 10, 37365},
	{"TENURE", 6, 37366},
	{"NTGR", 4, 37367},
	{"PLUSH", 5, 37368},
	{"WEBER", 5, 37369},
	{"DIAGNOSED", 9, 37370},
	{"NMEM", 4, 37371},
	{"DCRO", 4, 37372},
	{"BIOTECH", 7, 37373},
	{"UNSTABLE", 8, 37374},
	{"TURKMENISTAN", 12, 37375},
	{"NFED", 4, 37376},
	{"RUNK", 4, 37377},
	{"OUTY", 4, 37378},
	{"WOODLAND", 8, 37379},
	{"IRANIAN", 7, 37380},
	{"DCEN", 4, 37381},
	{"NDCI", 4, 37382},
	{"NELLY", 5, 37383},
	{"FULFILL", 7, 37384},
	{"URGED", 5, 37385},
	{"REFLECTING", 10, 37386},
	{"UNSECURED", 9, 37387},
	{"ANPL", 4, 37388},
	{"ERKN", 4, 37389},
	{"EMUN", 4, 37390},
	{"BRENT", 5, 37391},
	{"NDIW", 4, 37392},
	{"GAINING", 7, 37393},
	{"KYOTO", 5, 37394},
	{"DEFINITIVE", 10, 37395},
	{"APPROPRIATELY", 13, 37396},
	{"ATFR", 4, 37397},
	{"LDFI", 4, 37398},
	{"SHIFTS", 6, 37399},
	{"INACTIVE", 8, 37400},
	{"LANSING", 7, 37401},
	{"TRAVELED", 8, 37402},
	{"BARCODE", 7, 37403},
	{"WINC", 4, 37404},
	{"TSBY", 4, 37405},
	{"PECU", 4, 37406},
	{"EXTRACTED", 9, 37407},
	{"URTR", 4, 37408},
	{"ACCESSION", 9, 37409},
	{"PATTERSON", 9, 37410},
	{"LLCL", 4, 37411},
	{"ADPR", 4, 37412},
	{"LYAM", 4, 37413},
	{"MONW", 4, 37414},
	{"CARRIAGE", 8, 37415},
	{"THEREIN", 7, 37416},
	{"RRYT", 4, 37417},
	{"RDHA", 4, 37418},
	{"TERMINATE", 9, 37419},
	{"ALFU", 4, 37420},
	{"NKLE", 4, 37421},
	{"LFAR", 4, 37422},
	{"IRTY", 4, 37423},
	{"LMER", 4, 37424},
	{"HIPB", 4, 37425},
	{"FUELS", 5, 37426},
	{"UTBY", 4, 37427},
	{"ELFW", 4, 37428},
	{"GERF", 4, 37429},
	{"ELYL", 4, 37430},
	{"POSTCODE", 8, 37431},
	{"DATR", 4, 37432},
	{"SFRA", 4, 37433},
	{"BRETT", 5, 37434},
	{"EJAP", 4, 37435},
	{"MAKEFILE", 8, 37436},
	{"ULOU", 4, 37437},
	{"ANCHORAGE", 9, 37438},
	{"KEAC", 4, 37439},
	{"PAULA", 5, 37440},
	{"NYAR", 4, 37441},
	{"RYSU", 4, 37442},
	{"DBAL", 4, 37443},
	{"EYGE", 4, 37444},
	{"RGOV", 4, 37445},
	{"UZD", 3, 37446},
	{"INRU", 4, 37447},
	{"DCHR", 4, 37448},
	{"EDBI", 4, 37449},
	{"VICODIN", 7, 37450},
	{"GREENS", 6, 37451},
	{"ACKR", 4, 37452},
	{"NAMING", 6, 37453},
	{"RDSP", 4, 37454},
	{"STERN", 5, 37455},
	{"SHAWN", 5, 37456},
	{"UCTA", 4, 37457},
	{"LACROSSE", 8, 37458},
	{"BENTLEY", 7, 37459},
	{"BUD", 3, 37460},
	{"SLAVES", 6, 37461},
	{"DENTIST", 7, 37462},
	{"ASCU", 4, 37463},
	{"UTILIZING", 9, 37464},
	{"CRAFTED", 7, 37465},
	{"EFEW", 4, 37466},
	{"BURKINA", 7, 37467},
	{"ERITREA", 7, 37468},
	{"BBQ", 3, 37469},
	{"TUTOR", 5, 37470},
	{"IDIOT", 5, 37471},
	{"XPOR", 4, 37472},
	{"FSTR", 4, 37473},
	{"COMPRISED", 9, 37474},
	{"ICSW", 4, 37475},
	{"WINNIPEG", 8, 37476},
	{"CHARITIES", 9, 37477},
	{"MICKEY", 6, 37478},
	{"DEBIT", 5, 37479},
	{"SEBASTIAN", 9, 37480},
	{"ALIENS", 6, 37481},
	{"RLYO", 4, 37482},
	{"KERW", 4, 37483},
	{"DOMINO", 6, 37484},
	{"DMX", 3, 37485},
	{"EDITS", 5, 37486},
	{"UNWANTED", 8, 37487},
	{"RAVEN", 5, 37488},
	{"DEFEATED", 8, 37489},
	{"STRAINS", 7, 37490},
	{"DWELLING", 8, 37491},
	{"CSOF", 4, 37492},
	{"SFIG", 4, 37493},
	{"TANNING", 7, 37494},
	{"GAMBIA", 6, 37495},
	{"ASPEN", 5, 37496},
	{"LACKING", 7, 37497},
	{"NMOD", 4, 37498},
	{"OBJECTIONABLE", 13, 37499},
	{"LOWP", 4, 37500},
	{"ANGLES", 6, 37501},
	{"LEMMA", 5, 37502},
	{"KYRGYZSTAN", 10, 37503},
	{"LLGA", 4, 37504},
	{"PRESSURES", 9, 37505},
	{"WEBB", 4, 37506},
	{"SENSING", 7, 37507},
	{"YSRE", 4, 37508},
	{"MEDIATION", 9, 37509},
	{"VENUS", 5, 37510},
	{"POSTGRESQL", 10, 37511},
	{"BUMP", 4, 37512},
	{"TLOU", 4, 37513},
	{"COWBOYS", 7, 37514},
	{"BLYA", 4, 37515},
	{"NOFG", 4, 37516},
	{"FLAMES", 6, 37517},
	{"TFIG", 4, 37518},
	{"DTRE", 4, 37519},
	{"PRIMITIVE", 9, 37520},
	{"KBPS", 4, 37521},
	{"LMET", 4, 37522},
	{"TRAC", 4, 37523},
	{"RTRO", 4, 37524},
	{"OLEC", 4, 37525},
	{"OMOU", 4, 37526},
	{"GRAI", 4, 37527},
	{"STOCKING", 8, 37528},
	{"YOUI", 4, 37529},
	{"YGAM", 4, 37530},
	{"ETPR", 4, 37531},
	{"DOLBY", 5, 37532},
	{"BALLOONS", 8, 37533},
	{"ILDH", 4, 37534},
	{"EABU", 4, 37535},
	{"CALW", 4, 37536},
	{"PKG", 3, 37537},
	{"DASHBOARD", 9, 37538},
	{"MALCOLM", 7, 37539},
	{"NIKKI", 5, 37540},
	{"REMU", 4, 37541},
	{"GEORGETOWN", 10, 37542},
	{"TECHNORATI", 10, 37543},
	{"LMOR", 4, 37544},
	{"NORWICH", 7, 37545},
	{"HALLS", 5, 37546},
	{"OPUR", 4, 37547},
	{"ALZHEIMER", 9, 37548},
	{"DECORATIONS", 11, 37549},
	{"SIMPLICITY", 10, 37550},
	{"POSTSCRIPT", 10, 37551},
	{"DIVIDENDS", 9, 37552},
	{"FINF", 4, 37553},
	{"EOGR", 4, 37554},
	{"RELAXED", 7, 37555},
	{"PERIODICALS", 11, 37556},
	{"PEARSON", 7, 37557},
	{"ILEG", 4, 37558},
	{"DEMON", 5, 37559},
	{"WELCOMED", 8, 37560},
	{"DHED", 4, 37561},
	{"INFINITY", 8, 37562},
	{"RACL", 4, 37563},
	{"NPOW", 4, 37564},
	{"HANDLER", 7, 37565},
	{"TEPP", 4, 37566},
	{"TICD", 4, 37567},
	{"GABON", 5, 37568},
	{"THLY", 4, 37569},
	{"NOTATION", 8, 37570},
	{"CHANDLER", 8, 37571},
	{"GNOF", 4, 37572},
	{"YBYT", 4, 37573},
	{"PEDF", 4, 37574},
	{"INTERVIEWED", 11, 37575},
	{"CROW", 4, 37576},
	{"SEMANTIC", 8, 37577},
	{"ELSW", 4, 37578},
	{"WHYI", 4, 37579},
	{"ONMY", 4, 37580},
	{"NROU", 4, 37581},
	{"DISCONTINUED", 12, 37582},
	{"CONCURRENT", 10, 37583},
	{"DECIDES", 7, 37584},
	{"OFVE", 4, 37585},
	{"RACA", 4, 37586},
	{"CAPTION", 7, 37587},
	{"BARGAINING", 10, 37588},
	{"RLEY", 4, 37589},
	{"GLOBALIZATION", 13, 37590},
	{"YRAN", 4, 37591},
	{"ATARI", 5, 37592},
	{"RIDO", 4, 37593},
	{"GGLI", 4, 37594},
	{"EMOL", 4, 37595},
	{"RTLA", 4, 37596},
	{"PULMONARY", 9, 37597},
	{"ADHESIVE", 8, 37598},
	{"FFIR", 4, 37599},
	{"TOLEDO", 6, 37600},
	{"ALTITUDE", 8, 37601},
	{"YERW", 4, 37602},
	{"VEBU", 4, 37603},
	{"COMPASS", 7, 37604},
	{"REEBOK", 6, 37605},
	{"EVOLVED", 7, 37606},
	{"ROFW", 4, 37607},
	{"GANW", 4, 37608},
	{"OUTU", 4, 37609},
	{"EDOP", 4, 37610},
	{"PROO", 4, 37611},
	{"DOWNS", 5, 37612},
	{"MFG", 3, 37613},
	{"EXCEEDING", 9, 37614},
	{"TWOL", 4, 37615},
	{"ROGUE", 5, 37616},
	{"QBM", 3, 37617},
	{"BLOGTHIS", 8, 37618},
	{"DMIC", 4, 37619},
	{"ELECTRONICALLY", 14, 37620},
	{"RFOO", 4, 37621},
	{"INSPIRATIONAL", 13, 37622},
	{"AUGUSTA", 7, 37623},
	{"OWAB", 4, 37624},
	{"DTAL", 4, 37625},
	{"WILMINGTON", 10, 37626},
	{"INFANTRY", 8, 37627},
	{"ZZD", 3, 37628},
	{"RENOWNED", 8, 37629},
	{"SCRIPTURE", 9, 37630},
	{"CELEBRATING", 11, 37631},
	{"SAHARA", 6, 37632},
	{"JUSTIFICATION", 13, 37633},
	{"LEBY", 4, 37634},
	{"SDRAM", 5, 37635},
	{"VACANT", 6, 37636},
	{"MANUSCRIPT", 10, 37637},
	{"FIXING", 6, 37638},
	{"RALY", 4, 37639},
	{"MOTHERBOARDS", 12, 37640},
	{"URIO", 4, 37641},
	{"GRAM", 4, 37642},
	{"BLK", 3, 37643},
	{"HIDING", 6, 37644},
	{"METHODIST", 9, 37645},
	{"DWEN", 4, 37646},
	{"URKI", 4, 37647},
	{"ALPHABET", 8, 37648},
	{"AWRE", 4, 37649},
	{"DPOW", 4, 37650},
	{"SHELVES", 7, 37651},
	{"CLEANED", 7, 37652},
	{"TEMW", 4, 37653},
	{"HONORED", 7, 37654},
	{"OPTIC", 5, 37655},
	{"HANNAH", 6, 37656},
	{"TELEPHONES", 10, 37657},
	{"TAILORED", 8, 37658},
	{"OOLF", 4, 37659},
	{"MMOR", 4, 37660},
	{"UTPR", 4, 37661},
	{"IDYO", 4, 37662},
	{"RSYS", 4, 37663},
	{"FRANCES", 7, 37664},
	{"DIARIES", 7, 37665},
	{"CHILI", 5, 37666},
	{"LEICESTER", 9, 37667},
	{"VODAFONE", 8, 37668},
	{"DOLPHIN", 7, 37669},
	{"PENDANTS", 8, 37670},
	{"YOFO", 4, 37671},
	{"LDWH", 4, 37672},
	{"WONDERS", 7, 37673},
	{"ROMANIAN", 8, 37674},
	{"VENTILATION", 11, 37675},
	{"RAMB", 4, 37676},
	{"UCLA", 4, 37677},
	{"MASKS", 5, 37678},
	{"CELEB", 5, 37679},
	{"BUST", 4, 37680},
	{"LATERAL", 7, 37681},
	{"UTFR", 4, 37682},
	{"OMUS", 4, 37683},
	{"RAGR", 4, 37684},
	{"DBIL", 4, 37685},
	{"ASSOC", 5, 37686},
	{"NOWM", 4, 37687},
	{"BLEL", 4, 37688},
	{"RDWH", 4, 37689},
	{"QUAKE", 5, 37690},
	{"LSFR", 4, 37691},
	{"PALO", 4, 37692},
	{"USABILITY", 9, 37693},
	{"GARDNER", 7, 37694},
	{"SANDERS", 7, 37695},
	{"PATHWAYS", 8, 37696},
	{"TELEGRAPH", 9, 37697},
	{"LAYF", 4, 37698},
	{"ERAV", 4, 37699},
	{"AMEU", 4, 37700},
	{"PERTAINING", 10, 37701},
	{"NOVELL", 6, 37702},
	{"MEMORABLE", 9, 37703},
	{"FULO", 4, 37704},
	{"YMAT", 4, 37705},
	{"ANYY", 4, 37706},
	{"REFUNDS", 7, 37707},
	{"NEWSROOM", 8, 37708},
	{"PROFESSORS", 10, 37709},
	{"DLYA", 4, 37710},
	{"GYY", 3, 37711},
	{"RBIL", 4, 37712},
	{"AYCA", 4, 37713},
	{"AYBA", 4, 37714},
	{"IDMA", 4, 37715},
	{"FORMALLY", 8, 37716},
	{"COLA", 4, 37717},
	{"TWAIN", 5, 37718},
	{"BOISE", 5, 37719},
	{"OFPH", 4, 37720},
	{"NEVIS", 5, 37721},
	{"LAVENDER", 8, 37722},
	{"OWSW", 4, 37723},
	{"TDEV", 4, 37724},
	{"REFINANCING", 11, 37725},
	{"JUSTIFIED", 9, 37726},
	{"PSWI", 4, 37727},
	{"WITHDRAWN", 9, 37728},
	{"ELYU", 4, 37729},
	{"LDYO", 4, 37730},
	{"DEBATES", 7, 37731},
	{"SOFJ", 4, 37732},
	{"RVAN", 4, 37733},
	{"DADV", 4, 37734},
	{"GEMS", 4, 37735},
	{"NRED", 4, 37736},
	{"CERT", 4, 37737},
	{"XCY", 3, 37738},
	{"BUFFY", 5, 37739},
	{"DESW", 4, 37740},
	{"SOUG", 4, 37741},
	{"LARB", 4, 37742},
	{"DOCTORAL", 8, 37743},
	{"FSUC", 4, 37744},
	{"GSER", 4, 37745},
	{"BEPA", 4, 37746},
	{"BACKPACK", 8, 37747},
	{"IDENTITIES", 10, 37748},
	{"OUTGOING", 8, 37749},
	{"TAJIKISTAN", 10, 37750},
	{"OWUP", 4, 37751},
	{"YANKEE", 6, 37752},
	{"ORCR", 4, 37753},
	{"YBOT", 4, 37754},
	{"OCKW", 4, 37755},
	{"SHERATON", 8, 37756},
	{"UREE", 4, 37757},
	{"OCAM", 4, 37758},
	{"RYOR", 4, 37759},
	{"OQUE", 4, 37760},
	{"ONDL", 4, 37761},
	{"SNACKS", 6, 37762},
	{"DEFICIENCY", 10, 37763},
	{"GHAL", 4, 37764},
	{"BOOSTER", 7, 37765},
	{"TAXABLE", 7, 37766},
	{"GUM", 3, 37767},
	{"PROGRESSION", 11, 37768},
	{"UEFO", 4, 37769},
	{"DIOC", 4, 37770},
	{"SADDLE", 6, 37771},
	{"MALARIA", 7, 37772},
	{"OWBO", 4, 37773},
	{"FITW", 4, 37774},
	{"TORRENT", 7, 37775},
	{"RKSI", 4, 37776},
	{"LINKSYS", 7, 37777},
	{"DENTISTRY", 9, 37778},
	{"MERW", 4, 37779},
	{"RDUR", 4, 37780},
	{"GTOU", 4, 37781},
	{"CHMI", 4, 37782},
	{"RENAL", 5, 37783},
	{"YIEL", 4, 37784},
	{"FEDORA", 6, 37785},
	{"ODYSSEY", 7, 37786},
	{"DBED", 4, 37787},
	{"CAPITA", 6, 37788},
	{"UTDI", 4, 37789},
	{"ZCU", 3, 37790},
	{"DAYP", 4, 37791},
	{"TSUB", 4, 37792},
	{"INACCURACIES", 12, 37793},
	{"YAGE", 4, 37794},
	{"CALEDONIA", 9, 37795},
	{"FREEZER", 7, 37796},
	{"WHOLLY", 6, 37797},
	{"UTILIZED", 8, 37798},
	{"YEDW", 4, 37799},
	{"EDIG", 4, 37800},
	{"RKCI", 4, 37801},
	{"PCR", 3, 37802},
	{"OBRO", 4, 37803},
	{"BINOCULARS", 10, 37804},
	{"LINER", 5, 37805},
	{"MANILA", 6, 37806},
	{"AUXILIARY", 9, 37807},
	{"UYK", 3, 37808},
	{"ELEVATED", 8, 37809},
	{"PURELY", 6, 37810},
	{"TAFR", 4, 37811},
	{"DBYW", 4, 37812},
	{"DEMOGRAPHICS", 12, 37813},
	{"FRY", 3, 37814},
	{"RBYT", 4, 37815},
	{"LDDE", 4, 37816},
	{"NBLA", 4, 37817},
	{"LIFTS", 5, 37818},
	{"VIVID", 5, 37819},
	{"ALLEGATIONS", 11, 37820},
	{"YOFD", 4, 37821},
	{"EAKF", 4, 37822},
	{"STATIONARY", 10, 37823},
	{"OREU", 4, 37824},
	{"CORRESPONDS", 11, 37825},
	{"KITC", 4, 37826},
	{"DAEMON", 6, 37827},
	{"FWAR", 4, 37828},
	{"FOIL", 4, 37829},
	{"WHITNEY", 7, 37830},
	{"GESF", 4, 37831},
	{"GLER", 4, 37832},
	{"CELEBRATED", 10, 37833},
	{"BUDDIES", 7, 37834},
	{"CKLA", 4, 37835},
	{"EXTM", 4, 37836},
	{"DOFL", 4, 37837},
	{"ALARMS", 6, 37838},
	{"YFAC", 4, 37839},
	{"OFFW", 4, 37840},
	{"HUNTERS", 7, 37841},
	{"ALLISON", 7, 37842},
	{"VBY", 3, 37843},
	{"CRASHES", 7, 37844},
	{"STAIRS", 6, 37845},
	{"OUTLINES", 8, 37846},
	{"STEROIDS", 8, 37847},
	{"RKWA", 4, 37848},
	{"POGO", 4, 37849},
	{"NYBO", 4, 37850},
	{"TRSQ", 4, 37851},
	{"ACTED", 5, 37852},
	{"RAPR", 4, 37853},
	{"KONICA", 6, 37854},
	{"HOTLINE", 7, 37855},
	{"AMPS", 4, 37856},
	{"BYRON", 5, 37857},
	{"PLYI", 4, 37858},
	{"LLSS", 4, 37859},
	{"CRITIQUE", 8, 37860},
	{"ACCOUNTANTS", 11, 37861},
	{"COEFFICIENT", 11, 37862},
	{"TRANSVESTITE", 12, 37863},
	{"NDWR", 4, 37864},
	{"UPSTREAM", 8, 37865},
	{"CONTINUATION", 12, 37866},
	{"CARNEGIE", 8, 37867},
	{"DIGG", 4, 37868},
	{"WHYD", 4, 37869},
	{"YFEE", 4, 37870},
	{"FALCON", 6, 37871},
	{"DUTC", 4, 37872},
	{"JOINTLY", 7, 37873},
	{"CANADIANS", 9, 37874},
	{"YFUN", 4, 37875},
	{"YCF", 3, 37876},
	{"OCED", 4, 37877},
	{"ELLR", 4, 37878},
	{"AVOIDED", 7, 37879},
	{"COMPRISING", 10, 37880},
	{"TICK", 4, 37881},
	{"LADYBOY", 7, 37882},
	{"TERRIER", 7, 37883},
	{"LISTENED", 8, 37884},
	{"OUPT", 4, 37885},
	{"EDMY", 4, 37886},
	{"EXPLANATIONS", 12, 37887},
	{"EVIR", 4, 37888},
	{"RENEWED", 7, 37889},
	{"RBOW", 4, 37890},
	{"OOKC", 4, 37891},
	{"HUSSEIN", 7, 37892},
	{"LDLE", 4, 37893},
	{"INCORPORATING", 13, 37894},
	{"VARIANT", 7, 37895},
	{"MEUN", 4, 37896},
	{"YOFR", 4, 37897},
	{"RILEY", 5, 37898},
	{"BIOCHEMISTRY", 12, 37899},
	{"DUPLICATION", 11, 37900},
	{"EQUATORIAL", 10, 37901},
	{"YSCA", 4, 37902},
	{"SEDIMENT", 8, 37903},
	{"TRANSLATORS", 11, 37904},
	{"FEXP", 4, 37905},
	{"SQUARES", 7, 37906},
	{"SCOTTSDALE", 10, 37907},
	{"NINJA", 5, 37908},
	{"AVALON", 6, 37909},
	{"RATL", 4, 37910},
	{"ENUP", 4, 37911},
	{"VOUCHER", 7, 37912},
	{"HONEYMOON", 9, 37913},
	{"PERCUSSION", 10, 37914},
	{"RDWO", 4, 37915},
	{"GLUE", 4, 37916},
	{"NFAV", 4, 37917},
	{"EADF", 4, 37918},
	{"TALF", 4, 37919},
	{"ECKI", 4, 37920},
	{"RCUI", 4, 37921},
	{"LMEM", 4, 37922},
	{"AKEW", 4, 37923},
	{"RNOW", 4, 37924},
	{"CKHO", 4, 37925},
	{"YAGR", 4, 37926},
	{"MYOF", 4, 37927},
	{"NFEC", 4, 37928},
	{"CKBE", 4, 37929},
	{"MARGINS", 7, 37930},
	{"YHEW", 4, 37931},
	{"SANDS", 5, 37932},
	{"SURVIVED", 8, 37933},
	{"NWEL", 4, 37934},
	{"SPINNING", 8, 37935},
	{"EPIDEMIOLOGY", 12, 37936},
	{"TWAL", 4, 37937},
	{"ORDC", 4, 37938},
	{"ADEQUATELY", 10, 37939},
	{"PENTAGON", 8, 37940},
	{"REOV", 4, 37941},
	{"SPECTRAL", 8, 37942},
	{"DIABETIC", 8, 37943},
	{"YEDO", 4, 37944},
	{"DYFO", 4, 37945},
	{"STRESSED", 8, 37946},
	{"LIBDEVEL", 8, 37947},
	{"UPSO", 4, 37948},
	{"PREVALENCE", 10, 37949},
	{"DOMINICA", 8, 37950},
	{"CONTAMINATED", 12, 37951},
	{"UBBE", 4, 37952},
	{"FINISHES", 8, 37953},
	{"YBUI", 4, 37954},
	{"LECTURER", 8, 37955},
	{"BIOMEDICAL", 10, 37956},
	{"EMBROIDERED", 11, 37957},
	{"UTPU", 4, 37958},
	{"VILS", 4, 37959},
	{"ESPU", 4, 37960},
	{"EPLI", 4, 37961},
	{"MEDU", 4, 37962},
	{"GAMEBOY", 7, 37963},
	{"MSUR", 4, 37964},
	{"COMMITS", 7, 37965},
	{"COBRA", 5, 37966},
	{"GQB", 3, 37967},
	{"SUBSET", 6, 37968},
	{"GUCCI", 5, 37969},
	{"ADAG", 4, 37970},
	{"THREW", 5, 37971},
	{"SUTTON", 6, 37972},
	{"DJIBOUTI", 8, 37973},
	{"HTTPS", 5, 37974},
	{"WEBSPHERE", 9, 37975},
	{"LDSH", 4, 37976},
	{"CHENEY", 6, 37977},
	{"TFLO", 4, 37978},
	{"OULE", 4, 37979},
	{"ZOMBIE", 6, 37980},
	{"FYTH", 4, 37981},
	{"AYDE", 4, 37982},
	{"NGBL", 4, 37983},
	{"OODD", 4, 37984},
	{"LKK", 3, 37985},
	{"DOFE", 4, 37986},
	{"NLIG", 4, 37987},
	{"RYCH", 4, 37988},
	{"DIEG", 4, 37989},
	{"KABL", 4, 37990},
	{"DECORATED", 9, 37991},
	{"RYAB", 4, 37992},
	{"CREDITED", 8, 37993},
	{"CHEROKEE", 8, 37994},
	{"ARDN", 4, 37995},
	{"RECYCLED", 8, 37996},
	{"YRED", 4, 37997},
	{"MEDH", 4, 37998},
	{"FOLLOWUP", 8, 37999},
	{"DBYJ", 4, 38000},
	{"SIMMONS", 7, 38001},
	{"GALS", 4, 38002},
	{"RART", 4, 38003},
	{"IDRE", 4, 38004},
	{"SUNL", 4, 38005},
	{"BIDDERS", 7, 38006},
	{"WHEREIN", 7, 38007},
	{"SIMULATOR", 9, 38008},
	{"APPEARANCES", 11, 38009},
	{"ICIZ", 4, 38010},
	{"PERFORMERS", 10, 38011},
	{"RTYP", 4, 38012},
	{"NLIV", 4, 38013},
	{"DISSERTATION", 12, 38014},
	{"EXPORTERS", 9, 38015},
	{"WALSH", 5, 38016},
	{"GCHI", 4, 38017},
	{"MUTANT", 6, 38018},
	{"ILOR", 4, 38019},
	{"HEMC", 4, 38020},
	{"CSCH", 4, 38021},
	{"DONR", 4, 38022},
	{"TWED", 4, 38023},
	{"GGRO", 4, 38024},
	{"BLANKETS", 8, 38025},
	{"LEYC", 4, 38026},
	{"CONFUSING", 9, 38027},
	{"ORJU", 4, 38028},
	{"CELEBRATIONS", 12, 38029},
	{"APPROACHING", 11, 38030},
	{"SPIRAL", 6, 38031},
	{"TBYA", 4, 38032},
	{"GOVERNORS", 9, 38033},
	{"AUTHORING", 9, 38034},
	{"SPECIALIZES", 11, 38035},
	{"WILLS", 5, 38036},
	{"NCEG", 4, 38037},
	{"KATHERINE", 9, 38038},
	{"ATOMS", 5, 38039},
	{"JACOBS", 6, 38040},
	{"MAURITANIA", 10, 38041},
	{"TISSUES", 7, 38042},
	{"REMINDED", 8, 38043},
	{"EWWE", 4, 38044},
	{"IRVINE", 6, 38045},
	{"ONGM", 4, 38046},
	{"DRAKE", 5, 38047},
	{"OLDS", 4, 38048},
	{"RAMP", 4, 38049},
	{"IALG", 4, 38050},
	{"JAKARTA", 7, 38051},
	{"CYNTHIA", 7, 38052},
	{"YCOR", 4, 38053},
	{"IPLO", 4, 38054},
	{"ILTY", 4, 38055},
	{"ROOSEVELT", 9, 38056},
	{"DDEP", 4, 38057},
	{"PRACTICING", 10, 38058},
	{"SCHMIDT", 7, 38059},
	{"NICELY", 6, 38060},
	{"YOFN", 4, 38061},
	{"EXPRESSING", 10, 38062},
	{"DELLA", 5, 38063},
	{"LAUREL", 6, 38064},
	{"UNOF", 4, 38065},
	{"CAROLYN", 7, 38066},
	{"RAILS", 5, 38067},
	{"PGSQL", 5, 38068},
	{"FRIED", 5, 38069},
	{"CAIRO", 5, 38070},
	{"AMBULANCE", 9, 38071},
	{"TRADED", 6, 38072},
	{"SIGNALING", 9, 38073},
	{"EBAD", 4, 38074},
	{"VIVO", 4, 38075},
	{"MALLS", 5, 38076},
	{"JENSEN", 6, 38077},
	{"NGGE", 4, 38078},
	{"ILDL", 4, 38079},
	{"CHORDS", 6, 38080},
	{"NLOV", 4, 38081},
	{"YFAM", 4, 38082},
	{"IMPAIRMENT", 10, 38083},
	{"YHOM", 4, 38084},
	{"SCOOTER", 7, 38085},
	{"GLEC", 4, 38086},
	{"DEDICATION", 10, 38087},
	{"DESIRES", 7, 38088},
	{"NDJE", 4, 38089},
	{"WOODY", 5, 38090},
	{"DISMISSED", 9, 38091},
	{"MCGRAW", 6, 38092},
	{"CHEERLEADER", 11, 38093},
	{"OLEF", 4, 38094},
	{"YKC", 3, 38095},
	{"ELDW", 4, 38096},
	{"LDSI", 4, 38097},
	{"IEFL", 4, 38098},
	{"CRIED", 5, 38099},
	{"PSYCHIC", 7, 38100},
	{"LLIP", 4, 38101},
	{"CRACKS", 6, 38102},
	{"CLET", 4, 38103},
	{"LOTION", 6, 38104},
	{"ANALYZING", 9, 38105},
	{"RINM", 4, 38106},
	{"SUBSTRATE", 9, 38107},
	{"KENB", 4, 38108},
	{"ESUG", 4, 38109},
	{"SINCERELY", 9, 38110},
	{"MMC", 3, 38111},
	{"RMOD", 4, 38112},
	{"NGVE", 4, 38113},
	{"RLDO", 4, 38114},
	{"TICM", 4, 38115},
	{"NSPL", 4, 38116},
	{"YPOI", 4, 38117},
	{"BEATEN", 6, 38118},
	{"PIERCING", 8, 38119},
	{"ERBL", 4, 38120},
	{"ASHANTI", 7, 38121},
	{"RSUE", 4, 38122},
	{"ANTILLES", 8, 38123},
	{"SJOB", 4, 38124},
	{"ELPA", 4, 38125},
	{"HOMEMADE", 8, 38126},
	{"UKRAINIAN", 9, 38127},
	{"ESTABLISHMENTS", 14, 38128},
	{"MARGINAL", 8, 38129},
	{"REMP", 4, 38130},
	{"VISIONS", 7, 38131},
	{"EFFICACY", 8, 38132},
	{"TCHW", 4, 38133},
	{"RGEP", 4, 38134},
	{"FRESHWATER", 10, 38135},
	{"WEKN", 4, 38136},
	{"TOPICAL", 7, 38137},
	{"PRESTIGE", 8, 38138},
	{"TEXC", 4, 38139},
	{"FWAT", 4, 38140},
	{"ACCELERATED", 11, 38141},
	{"YEDF", 4, 38142},
	{"PINNACLE", 8, 38143},
	{"TUCKER", 6, 38144},
	{"URFI", 4, 38145},
	{"TLYM", 4, 38146},
	{"RECOGNIZES", 10, 38147},
	{"PLUGS", 5, 38148},
	{"DOFO", 4, 38149},
	{"GUPA", 4, 38150},
	{"RESPONSIVE", 10, 38151},
	{"DFAI", 4, 38152},
	{"CODED", 5, 38153},
	{"SUPRA", 5, 38154},
	{"OMITTED", 7, 38155},
	{"NFIV", 4, 38156},
	{"MOLLY", 5, 38157},
	{"PROXIMITY", 9, 38158},
	{"WWHE", 4, 38159},
	{"OFCU", 4, 38160},
	{"BYPE", 4, 38161},
	{"ELME", 4, 38162},
	{"ALCATEL", 7, 38163},
	{"BELONGING", 9, 38164},
	{"UNBIASED", 8, 38165},
	{"PEAR", 4, 38166},
	{"SURINAME", 8, 38167},
	{"TBUI", 4, 38168},
	{"RSKI", 4, 38169},
	{"ECIV", 4, 38170},
	{"TLYL", 4, 38171},
	{"TSPL", 4, 38172},
	{"CHIEFS", 6, 38173},
	{"FRANZ", 5, 38174},
	{"LOFC", 4, 38175},
	{"GPRI", 4, 38176},
	{"LOGU", 4, 38177},
	{"COLLISION", 9, 38178},
	{"SUPPLEMENTARY", 13, 38179},
	{"GHOM", 4, 38180},
	{"FEAC", 4, 38181},
	{"EYOF", 4, 38182},
	{"RDME", 4, 38183},
	{"LUEO", 4, 38184},
	{"ZJU", 3, 38185},
	{"MVU", 3, 38186},
	{"BYMO", 4, 38187},
	{"REDN", 4, 38188},
	{"ARVI", 4, 38189},
	{"PARKWAY", 7, 38190},
	{"LSRE", 4, 38191},
	{"UTDE", 4, 38192},
	{"YFRE", 4, 38193},
	{"PALAU", 5, 38194},
	{"DUFF", 4, 38195},
	{"GEBU", 4, 38196},
	{"LODGES", 6, 38197},
	{"DANGERS", 7, 38198},
	{"ORJO", 4, 38199},
	{"OFEM", 4, 38200},
	{"BONUSES", 7, 38201},
	{"SCAM", 4, 38202},
	{"TRAVELLERS", 10, 38203},
	{"BIKING", 6, 38204},
	{"ERIZ", 4, 38205},
	{"DISCREPANCIES", 13, 38206},
	{"NOWF", 4, 38207},
	{"PIRATE", 6, 38208},
	{"FSER", 4, 38209},
	{"LBEG", 4, 38210},
	{"MICROSYSTEMS", 12, 38211},
	{"FHOW", 4, 38212},
	{"TIMEOUT", 7, 38213},
	{"SENSES", 6, 38214},
	{"AEROSMITH", 9, 38215},
	{"KSWE", 4, 38216},
	{"YTEL", 4, 38217},
	{"NBED", 4, 38218},
	{"NTYC", 4, 38219},
	{"REPEATS", 7, 38220},
	{"RESELLERS", 9, 38221},
	{"WILLIE", 6, 38222},
	{"PORTFOLIOS", 10, 38223},
	{"CEDF", 4, 38224},
	{"DONJ", 4, 38225},
	{"PPLA", 4, 38226},
	{"RGEC", 4, 38227},
	{"LFIS", 4, 38228},
	{"WAYH", 4, 38229},
	{"SLOWER", 6, 38230},
	{"SIMULATED", 9, 38231},
	{"CULINARY", 8, 38232},
	{"FAIRFAX", 7, 38233},
	{"BECK", 4, 38234},
	{"FFLE", 4, 38235},
	{"SEMANTICS", 9, 38236},
	{"DNTW", 4, 38237},
	{"RSUI", 4, 38238},
	{"ULIA", 4, 38239},
	{"SCARFACE", 8, 38240},
	{"ACCOUNTANT", 10, 38241},
	{"ORYF", 4, 38242},
	{"BEIGE", 5, 38243},
	{"AUDITING", 8, 38244},
	{"ROLEX", 5, 38245},
	{"PROPAGANDA", 10, 38246},
	{"AMPLIFIERS", 10, 38247},
	{"WATERLOO", 8, 38248},
	{"LDEA", 4, 38249},
	{"WARWICK", 7, 38250},
	{"COLI", 4, 38251},
	{"EXECUTABLE", 10, 38252},
	{"PENTAX", 6, 38253},
	{"FSPE", 4, 38254},
	{"RESTART", 7, 38255},
	{"ROUNDED", 7, 38256},
	{"BOARDING", 8, 38257},
	{"VANITY", 6, 38258},
	{"TALD", 4, 38259},
	{"RTYW", 4, 38260},
	{"LSOG", 4, 38261},
	{"MITIGATION", 10, 38262},
	{"PROF", 4, 38263},
	{"OVERSTOCK", 9, 38264},
	{"HOMER", 5, 38265},
	{"DAYLIGHT", 8, 38266},
	{"MACDONALD", 9, 38267},
	{"GASES", 5, 38268},
	{"YMIS", 4, 38269},
	{"DEPENDENCY", 10, 38270},
	{"DIOXIDE", 7, 38271},
	{"FIREWORKS", 9, 38272},
	{"EKLY", 4, 38273},
	{"GENUS", 5, 38274},
	{"APPROACHED", 10, 38275},
	{"CALH", 4, 38276},
	{"CATCHING", 8, 38277},
	{"YLIV", 4, 38278},
	{"EWSW", 4, 38279},
	{"CUTTER", 6, 38280},
	{"ORKB", 4, 38281},
	{"TPAY", 4, 38282},
	{"NCLI", 4, 38283},
	{"UTAC", 4, 38284},
	{"CONNECTS", 8, 38285},
	{"CKBU", 4, 38286},
	{"YINM", 4, 38287},
	{"LSMA", 4, 38288},
	{"TEDV", 4, 38289},
	{"CEAB", 4, 38290},
	{"UCHF", 4, 38291},
	{"EXPLORES", 8, 38292},
	{"DOFW", 4, 38293},
	{"ILIK", 4, 38294},
	{"LIBERALS", 8, 38295},
	{"XKL", 3, 38296},
	{"VESB", 4, 38297},
	{"EUPP", 4, 38298},
	{"APERTURE", 8, 38299},
	{"OBBE", 4, 38300},
	{"ROOFING", 7, 38301},
	{"DIXON", 5, 38302},
	{"DAFO", 4, 38303},
	{"ELASTIC", 7, 38304},
	{"MELODY", 6, 38305},
	{"PEFU", 4, 38306},
	{"IRBA", 4, 38307},
	{"THFU", 4, 38308},
	{"LEDL", 4, 38309},
	{"TORQUE", 6, 38310},
	{"RECALLS", 7, 38311},
	{"CONSULTATIONS", 13, 38312},
	{"OKOF", 4, 38313},
	{"MEMBERSHIPS", 11, 38314},
	{"DEBTS", 5, 38315},
	{"RENTING", 7, 38316},
	{"FREP", 4, 38317},
	{"ICANN", 5, 38318},
	{"TICKETMASTER", 12, 38319},
	{"CDC", 3, 38320},
	{"MERIDIA", 7, 38321},
	{"PHILLIP", 7, 38322},
	{"BURIAL", 6, 38323},
	{"BALCONY", 7, 38324},
	{"PRESCRIPTIONS", 13, 38325},
	{"DBEP", 4, 38326},
	{"EWJE", 4, 38327},
	{"PROP", 4, 38328},
	{"AVRIL", 5, 38329},
	{"RDEM", 4, 38330},
	{"WILLIS", 6, 38331},
	{"MYTHS", 5, 38332},
	{"CAMDEN", 6, 38333},
	{"WJER", 4, 38334},
	{"EAMP", 4, 38335},
	{"RDRA", 4, 38336},
	{"COUPLING", 8, 38337},
	{"YTUR", 4, 38338},
	{"KNEES", 5, 38339},
	{"ONCOLOGY", 8, 38340},
	{"NEGLECT", 7, 38341},
	{"NGDU", 4, 38342},
	{"FSTU", 4, 38343},
	{"WINCHESTER", 10, 38344},
	{"RYTI", 4, 38345},
	{"BYFO", 4, 38346},
	{"CLUTCH", 6, 38347},
	{"AYLI", 4, 38348},
	{"POETS", 5, 38349},
	{"WOVEN", 5, 38350},
	{"BLOGLINES", 9, 38351},
	{"AUDITORIUM", 10, 38352},
	{"EUPW", 4, 38353},
	{"PEDRO", 5, 38354},
	{"MAID", 4, 38355},
	{"HPRI", 4, 38356},
	{"CZU", 3, 38357},
	{"CARRIE", 6, 38358},
	{"UEBE", 4, 38359},
	{"HELU", 4, 38360},
	{"AUDIOSLAVE", 10, 38361},
	{"TOWELS", 6, 38362},
	{"UTAB", 4, 38363},
	{"WIKIMEDIA", 9, 38364},
	{"CANTERBURY", 10, 38365},
	{"LIPITOR", 7, 38366},
	{"REMODELING", 10, 38367},
	{"TRENT", 5, 38368},
	{"REDHAT", 6, 38369},
	{"BARBER", 6, 38370},
	{"INTUITIVE", 9, 38371},
	{"RYPA", 4, 38372},
	{"ILYH", 4, 38373},
	{"RIGID", 5, 38374},
	{"RADV", 4, 38375},
	{"DGEW", 4, 38376},
	{"SAPL", 4, 38377},
	{"MIFI", 4, 38378},
	{"OMUN", 4, 38379},
	{"OLDD", 4, 38380},
	{"RGEW", 4, 38381},
	{"ARWE", 4, 38382},
	{"DEGRADATION", 11, 38383},
	{"FFOU", 4, 38384},
	{"YWU", 3, 38385},
	{"YMK", 3, 38386},
	{"XYR", 3, 38387},
	{"ORTHODOX", 8, 38388},
	{"ASWR", 4, 38389},
	{"FERGUSON", 8, 38390},
	{"COORDINATING", 12, 38391},
	{"HOLISTIC", 8, 38392},
	{"SALSA", 5, 38393},
	{"SFLO", 4, 38394},
	{"FRAGMENTS", 9, 38395},
	{"ENCARTA", 7, 38396},
	{"MARIANA", 7, 38397},
	{"QUALITATIVE", 11, 38398},
	{"NJAM", 4, 38399},
	{"NYPR", 4, 38400},
	{"WNWI", 4, 38401},
	{"SDRO", 4, 38402},
	{"CLAUDE", 6, 38403},
	{"PBUT", 4, 38404},
	{"MINORITIES", 10, 38405},
	{"CHILDCARE", 9, 38406},
	{"DVR", 3, 38407},
	{"SMOU", 4, 38408},
	{"BLOWN", 5, 38409},
	{"DIFFUSION", 9, 38410},
	{"BATON", 5, 38411},
	{"YADD", 4, 38412},
	{"POLYNESIA", 9, 38413},
	{"BARTON", 6, 38414},
	{"UMBRELLA", 8, 38415},
	{"SOUNDTRACKS", 11, 38416},
	{"NAPSTER", 7, 38417},
	{"SSFR", 4, 38418},
	{"RODS", 4, 38419},
	{"WONG", 4, 38420},
	{"LBEP", 4, 38421},
	{"STIMULATION", 11, 38422},
	{"ABBEY", 5, 38423},
	{"PIGS", 4, 38424},
	{"DEBUGGING", 9, 38425},
	{"OLIVIA", 6, 38426},
	{"RECHARGEABLE", 12, 38427},
	{"ENGINEERED", 10, 38428},
	{"TSGR", 4, 38429},
	{"JERSEYS", 7, 38430},
	{"DPRA", 4, 38431},
	{"CEWO", 4, 38432},
	{"STRAPS", 6, 38433},
	{"MAYA", 4, 38434},
	{"LANCASHIRE", 10, 38435},
	{"RSAW", 4, 38436},
	{"SUPERSTORE", 10, 38437},
	{"IUMS", 4, 38438},
	{"STAINED", 7, 38439},
	{"MARITAL", 7, 38440},
	{"SOCIALIST", 9, 38441},
	{"ARPO", 4, 38442},
	{"KCON", 4, 38443},
	{"DEDD", 4, 38444},
	{"BRUNO", 5, 38445},
	{"ATTRACTED", 9, 38446},
	{"UNDERTAKING", 11, 38447},
	{"TBIL", 4, 38448},
	{"UUD", 3, 38449},
	{"NOTWITHSTANDING", 15, 38450},
	{"RBAT", 4, 38451},
	{"BLOGROLL", 8, 38452},
	{"EVITE", 5, 38453},
	{"EEPR", 4, 38454},
	{"FEASIBLE", 8, 38455},
	{"ROMANS", 6, 38456},
	{"NBRE", 4, 38457},
	{"MICRONESIA", 10, 38458},
	{"FMUS", 4, 38459},
	{"SHORES", 6, 38460},
	{"CKDO", 4, 38461},
	{"THAMES", 6, 38462},
	{"TBLA", 4, 38463},
	{"FLOWING", 7, 38464},
	{"DREAMWEAVER", 11, 38465},
	{"DIETS", 5, 38466},
	{"YERT", 4, 38467},
	{"DEED", 4, 38468},
	{"KMAR", 4, 38469},
	{"EWLY", 4, 38470},
	{"NMIC", 4, 38471},
	{"YPOP", 4, 38472},
	{"VEAF", 4, 38473},
	{"PTIV", 4, 38474},
	{"URGI", 4, 38475},
	{"WHOG", 4, 38476},
	{"RRID", 4, 38477},
	{"RAPO", 4, 38478},
	{"SAUNA", 5, 38479},
	{"FBOT", 4, 38480},
	{"WHIRLPOOL", 9, 38481},
	{"PERFUMES", 8, 38482},
	{"RDEP", 4, 38483},
	{"SWOM", 4, 38484},
	{"NKAB", 4, 38485},
	{"KEAB", 4, 38486},
	{"BAUER", 5, 38487},
	{"ELIMINATING", 11, 38488},
	{"REJECTION", 9, 38489},
	{"GHOW", 4, 38490},
	{"EWUP", 4, 38491},
	{"ROGA", 4, 38492},
	{"MULTIPLAYER", 11, 38493},
	{"CAICOS", 6, 38494},
	{"ODYA", 4, 38495},
	{"BOWLS", 5, 38496},
	{"QAEDA", 5, 38497},
	{"OLFO", 4, 38498},
	{"DISSEMINATION", 13, 38499},
	{"RYFI", 4, 38500},
	{"GCLA", 4, 38501},
	{"ATMU", 4, 38502},
	{"CARDINALS", 9, 38503},
	{"OTYP", 4, 38504},
	{"KITTS", 5, 38505},
	{"SUIC", 4, 38506},
	{"COSMIC", 6, 38507},
	{"LSPO", 4, 38508},
	{"DAWSON", 6, 38509},
	{"NGWR", 4, 38510},
	{"OFCI", 4, 38511},
	{"DEFECTIVE", 9, 38512},
	{"DELETION", 8, 38513},
	{"LENGTHS", 7, 38514},
	{"HBOU", 4, 38515},
	{"EALP", 4, 38516},
	{"HOOVER", 6, 38517},
	{"FFRA", 4, 38518},
	{"MACAU", 5, 38519},
	{"BYMI", 4, 38520},
	{"ZUY", 3, 38521},
	{"ELECTIVE", 8, 38522},
	{"EFTF", 4, 38523},
	{"FORENSIC", 8, 38524},
	{"BRAV", 4, 38525},
	{"YINP", 4, 38526},
	{"AGGI", 4, 38527},
	{"EROV", 4, 38528},
	{"ZFU", 3, 38529},
	{"BOTANICAL", 9, 38530},
	{"DIFT", 4, 38531},
	{"QUARTET", 7, 38532},
	{"LYTI", 4, 38533},
	{"MUDVAYNE", 8, 38534},
	{"UDIC", 4, 38535},
	{"RLYE", 4, 38536},
	{"CERAMICS", 8, 38537},
	{"SUSPENSE", 8, 38538},
	{"DRAFTING", 8, 38539},
	{"OCKB", 4, 38540},
	{"OBSERVING", 9, 38541},
	{"FREESTYLE", 9, 38542},
	{"ILYC", 4, 38543},
	{"ADVERTISED", 10, 38544},
	{"COMMENCEMENT", 12, 38545},
	{"SOUTHWESTERN", 12, 38546},
	{"CONFORM", 7, 38547},
	{"HELMETS", 7, 38548},
	{"FWHE", 4, 38549},
	{"DFAL", 4, 38550},
	{"RBIN", 4, 38551},
	{"ARTP", 4, 38552},
	{"ORGANIZERS", 10, 38553},
	{"FIRING", 6, 38554},
	{"SMARTPHONE", 10, 38555},
	{"RCRI", 4, 38556},
	{"CMD", 3, 38557},
	{"FHUM", 4, 38558},
	{"GHPR", 4, 38559},
	{"IFFS", 4, 38560},
	{"VEUS", 4, 38561},
	{"HIMP", 4, 38562},
	{"UCHW", 4, 38563},
	{"DENISE", 6, 38564},
	{"PSAR", 4, 38565},
	{"EFOC", 4, 38566},
	{"HYPERTENSION", 12, 38567},
	{"SEARCHABLE", 10, 38568},
	{"LINW", 4, 38569},
	{"GERH", 4, 38570},
	{"TOUCHING", 8, 38571},
	{"AGUILERA", 8, 38572},
	{"RLYW", 4, 38573},
	{"VACANCY", 7, 38574},
	{"SERVICING", 9, 38575},
	{"USCL", 4, 38576},
	{"GEDH", 4, 38577},
	{"PAPA", 4, 38578},
	{"RFAI", 4, 38579},
	{"SETTLEMENTS", 11, 38580},
	{"STRAWBERRY", 10, 38581},
	{"CHANG", 5, 38582},
	{"GLORIA", 6, 38583},
	{"COUNSELLING", 11, 38584},
	{"PUPIL", 5, 38585},
	{"KETW", 4, 38586},
	{"EFLI", 4, 38587},
	{"NBLO", 4, 38588},
	{"DTEC", 4, 38589},
	{"FEAST", 5, 38590},
	{"ECARDS", 6, 38591},
	{"GUNI", 4, 38592},
	{"AXPA", 4, 38593},
	{"MAGGIE", 6, 38594},
	{"YFOL", 4, 38595},
	{"REDEMPTION", 10, 38596},
	{"SBYA", 4, 38597},
	{"KTOP", 4, 38598},
	{"CANTON", 6, 38599},
	{"ACURA", 5, 38600},
	{"REGISTERING", 11, 38601},
	{"AWEL", 4, 38602},
	{"CEYO", 4, 38603},
	{"CONSERVATIVES", 13, 38604},
	{"CLIT", 4, 38605},
	{"ACHF", 4, 38606},
	{"YINW", 4, 38607},
	{"RUCE", 4, 38608},
	{"BONNIE", 6, 38609},
	{"LAYING", 6, 38610},
	{"COPS", 4, 38611},
	{"VEEX", 4, 38612},
	{"PROVISIONAL", 11, 38613},
	{"COMPILING", 9, 38614},
	{"WOCO", 4, 38615},
	{"FEDEX", 5, 38616},
	{"RYMU", 4, 38617},
	{"XIMU", 4, 38618},
	{"ODYO", 4, 38619},
	{"STRIVE", 6, 38620},
	{"RERU", 4, 38621},
	{"SNOWBOARDING", 12, 38622},
	{"RELEASING", 9, 38623},
	{"AREJ", 4, 38624},
	{"ORTM", 4, 38625},
	{"LASERJET", 8, 38626},
	{"MARTINIQUE", 10, 38627},
	{"SHELLS", 6, 38628},
	{"LDTR", 4, 38629},
	{"FHIG", 4, 38630},
	{"SCLU", 4, 38631},
	{"COOKER", 6, 38632},
	{"LEAGUES", 7, 38633},
	{"LOFM", 4, 38634},
	{"MONKEYS", 7, 38635},
	{"TGUA", 4, 38636},
	{"LEGO", 4, 38637},
	{"TRANSITIONS", 11, 38638},
	{"PREVENTED", 9, 38639},
	{"DIGITS", 6, 38640},
	{"FLOA", 4, 38641},
	{"ANCR", 4, 38642},
	{"FULI", 4, 38643},
	{"EYLE", 4, 38644},
	{"LREM", 4, 38645},
	{"EASIEST", 7, 38646},
	{"MICROBIOLOGY", 12, 38647},
	{"INTERNSHIPS", 11, 38648},
	{"BAMBOO", 6, 38649},
	{"AJOB", 4, 38650},
	{"DENOTES", 7, 38651},
	{"TACR", 4, 38652},
	{"LAFT", 4, 38653},
	{"COMMUNICATING", 13, 38654},
	{"YSOL", 4, 38655},
	{"VECTORS", 7, 38656},
	{"DOFR", 4, 38657},
	{"DECKS", 5, 38658},
	{"CRAIGSLIST", 10, 38659},
	{"VIBRATION", 9, 38660},
	{"STEPPED", 7, 38661},
	{"BLUNT", 5, 38662},
	{"MBED", 4, 38663},
	{"PROTECTOR", 9, 38664},
	{"HAMAS", 5, 38665},
	{"MEEX", 4, 38666},
	{"EADR", 4, 38667},
	{"CHBU", 4, 38668},
	{"ODDE", 4, 38669},
	{"GCAM", 4, 38670},
	{"IRTR", 4, 38671},
	{"UNDERSTANDS", 11, 38672},
	{"ACOB", 4, 38673},
	{"RREF", 4, 38674},
	{"RISES", 5, 38675},
	{"JORC", 4, 38676},
	{"ISSUING", 7, 38677},
	{"ESJU", 4, 38678},
	{"HEATERS", 7, 38679},
	{"URLE", 4, 38680},
	{"ACCENTS", 7, 38681},
	{"IMFO", 4, 38682},
	{"LREG", 4, 38683},
	{"INSANE", 6, 38684},
	{"BUDDHA", 6, 38685},
	{"VOYAGE", 6, 38686},
	{"RDF", 3, 38687},
	{"LERC", 4, 38688},
	{"DOND", 4, 38689},
	{"ILOF", 4, 38690},
	{"UADR", 4, 38691},
	{"DGUI", 4, 38692},
	{"EVIV", 4, 38693},
	{"COLONEL", 7, 38694},
	{"TRANSITIONAL", 12, 38695},
	{"MOZART", 6, 38696},
	{"ACCELERATION", 12, 38697},
	{"SKETCH", 6, 38698},
	{"HOFFMAN", 7, 38699},
	{"LFCO", 4, 38700},
	{"LIZI", 4, 38701},
	{"BERF", 4, 38702},
	{"BALANCES", 8, 38703},
	{"FIREARMS", 8, 38704},
	{"YREV", 4, 38705},
	{"NIGHTLY", 7, 38706},
	{"REUP", 4, 38707},
	{"VISUALIZATION", 13, 38708},
	{"NMID", 4, 38709},
	{"XTUR", 4, 38710},
	{"EEDG", 4, 38711},
	{"DEDUCTION", 9, 38712},
	{"UPIE", 4, 38713},
	{"RFER", 4, 38714},
	{"MESR", 4, 38715},
	{"LLEX", 4, 38716},
	{"COATS", 5, 38717},
	{"MKY", 3, 38718},
	{"AYSG", 4, 38719},
	{"ORTP", 4, 38720},
	{"UCIA", 4, 38721},
	{"ORSD", 4, 38722},
	{"IREB", 4, 38723},
	{"LYDU", 4, 38724},
	{"CAPSULES", 8, 38725},
	{"KLAH", 4, 38726},
	{"HYDE", 4, 38727},
	{"RFAR", 4, 38728},
	{"AWKS", 4, 38729},
	{"ARPL", 4, 38730},
	{"ARAF", 4, 38731},
	{"PURSUING", 8, 38732},
	{"NEWSWIRE", 8, 38733},
	{"VEFA", 4, 38734},
	{"SPERMSHACK", 10, 38735},
	{"NIMU", 4, 38736},
	{"MUGS", 4, 38737},
	{"BROKERAGE", 9, 38738},
	{"UELA", 4, 38739},
	{"IRLY", 4, 38740},
	{"AFUN", 4, 38741},
	{"WASHED", 6, 38742},
	{"PTOR", 4, 38743},
	{"OVERTIME", 8, 38744},
	{"STAIND", 6, 38745},
	{"YSFO", 4, 38746},
	{"RESONANCE", 9, 38747},
	{"MOSAIC", 6, 38748},
	{"RHODES", 6, 38749},
	{"FIESTA", 6, 38750},
	{"EEDB", 4, 38751},
	{"SOURCING", 8, 38752},
	{"ADYA", 4, 38753},
	{"YRUN", 4, 38754},
	{"FILINGS", 7, 38755},
	{"FORCING", 7, 38756},
	{"NGIM", 4, 38757},
	{"RFOL", 4, 38758},
	{"QUIV", 4, 38759},
	{"FAIRS", 5, 38760},
	{"FLUTE", 5, 38761},
	{"DLOV", 4, 38762},
	{"DURABILITY", 10, 38763},
	{"BOEING", 6, 38764},
	{"SIZING", 6, 38765},
	{"CEBY", 4, 38766},
	{"EXCEEDED", 8, 38767},
	{"LTRE", 4, 38768},
	{"MEADOWS", 7, 38769},
	{"KECA", 4, 38770},
	{"HINDI", 5, 38771},
	{"NJAP", 4, 38772},
	{"TLAW", 4, 38773},
	{"PRESLEY", 7, 38774},
	{"NBAL", 4, 38775},
	{"GODSMACK", 8, 38776},
	{"DLOW", 4, 38777},
	{"CWAS", 4, 38778},
	{"DAUT", 4, 38779},
	{"LABELING", 8, 38780},
	{"LDED", 4, 38781},
	{"SUBSTITUTION", 12, 38782},
	{"WHOIS", 5, 38783},
	{"BURMA", 5, 38784},
	{"DESERVES", 8, 38785},
	{"TGOV", 4, 38786},
	{"UNGP", 4, 38787},
	{"ABOARD", 6, 38788},
	{"PARADIGM", 8, 38789},
	{"IRVING", 6, 38790},
	{"PERFECTION", 10, 38791},
	{"DBYN", 4, 38792},
	{"LOWF", 4, 38793},
	{"EPLY", 4, 38794},
	{"JOINTS", 6, 38795},
	{"LINGUISTICS", 11, 38796},
	{"SNMP", 4, 38797},
	{"STANDARDIZED", 12, 38798},
	{"RBOO", 4, 38799},
	{"IFYT", 4, 38800},
	{"POLES", 5, 38801},
	{"RTSM", 4, 38802},
	{"BOUNDS", 6, 38803},
	{"ORSB", 4, 38804},
	{"LYON", 4, 38805},
	{"NUTRIENTS", 9, 38806},
	{"KOSOVO", 6, 38807},
	{"SANTIAGO", 8, 38808},
	{"VERA", 4, 38809},
	{"EPAG", 4, 38810},
	{"LYOP", 4, 38811},
	{"ADVISING", 8, 38812},
	{"NACR", 4, 38813},
	{"DEVILS", 6, 38814},
	{"RATC", 4, 38815},
	{"OOKW", 4, 38816},
	{"AMWH", 4, 38817},
	{"EUROPA", 6, 38818},
	{"OODY", 4, 38819},
	{"LDIT", 4, 38820},
	{"YBUS", 4, 38821},
	{"BARBUDA", 7, 38822},
	{"IRPL", 4, 38823},
	{"WONDERED", 8, 38824},
	{"CHESHIRE", 8, 38825},
	{"BOYD", 4, 38826},
	{"LSBE", 4, 38827},
	{"SLIDING", 7, 38828},
	{"DESCRIPTIVE", 11, 38829},
	{"FEASIBILITY", 11, 38830},
	{"NICKELBACK", 10, 38831},
	{"NEGOTIATING", 11, 38832},
	{"ELPF", 4, 38833},
	{"PIER", 4, 38834},
	{"ALSB", 4, 38835},
	{"RTWH", 4, 38836},
	{"SIOUX", 5, 38837},
	{"LLRO", 4, 38838},
	{"PREMIUMS", 8, 38839},
	{"JENNA", 5, 38840},
	{"FBRI", 4, 38841},
	{"BBIN", 4, 38842},
	{"ARRAYS", 6, 38843},
	{"LUTHERAN", 8, 38844},
	{"OFPI", 4, 38845},
	{"ZYU", 3, 38846},
	{"SYLLABUS", 8, 38847},
	{"RGB", 3, 38848},
	{"FELLOWS", 7, 38849},
	{"LHAR", 4, 38850},
	{"RIAB", 4, 38851},
	{"VALENCIA", 8, 38852},
	{"SUPERMAN", 8, 38853},
	{"KSWH", 4, 38854},
	{"RODRIGUEZ", 9, 38855},
	{"PERKINS", 7, 38856},
	{"RLEV", 4, 38857},
	{"ANIMATIONS", 10, 38858},
	{"OFFB", 4, 38859},
	{"IDEALLY", 7, 38860},
	{"ONMU", 4, 38861},
	{"EXTF", 4, 38862},
	{"ACTIVISM", 8, 38863},
	{"SPLASH", 6, 38864},
	{"RREM", 4, 38865},
	{"FARGO", 5, 38866},
	{"EXTW", 4, 38867},
	{"OWAY", 4, 38868},
	{"CHAIRPERSON", 11, 38869},
	{"YLAS", 4, 38870},
	{"RKAT", 4, 38871},
	{"YLIT", 4, 38872},
	{"SBOU", 4, 38873},
	{"REGED", 5, 38874},
	{"LEVERAGE", 8, 38875},
	{"PROBATION", 9, 38876},
	{"GRAN", 4, 38877},
	{"COMMISSIONED", 12, 38878},
	{"RPJ", 3, 38879},
	{"HEDGE", 5, 38880},
	{"FEWD", 4, 38881},
	{"ANGUILLA", 8, 38882},
	{"FENDER", 6, 38883},
	{"VIOLET", 6, 38884},
	{"DANCERS", 7, 38885},
	{"MUTATION", 8, 38886},
	{"OFOC", 4, 38887},
	{"RADISSON", 8, 38888},
	{"EWPR", 4, 38889},
	{"ALLE", 4, 38890},
	{"COMPULSORY", 10, 38891},
	{"WHOU", 4, 38892},
	{"HITLER", 6, 38893},
	{"LATU", 4, 38894},
	{"HANDSET", 7, 38895},
	{"HUMB", 4, 38896},
	{"DLEE", 4, 38897},
	{"PREPARATIONS", 12, 38898},
	{"MAXWELL", 7, 38899},
	{"ILLUSTRATES", 11, 38900},
	{"INHERITANCE", 11, 38901},
	{"UFFA", 4, 38902},
	{"CURRY", 5, 38903},
	{"VULNERABILITIES", 15, 38904},
	{"RFIV", 4, 38905},
	{"ERYY", 4, 38906},
	{"BYHA", 4, 38907},
	{"OBLIQUE", 7, 38908},
	{"PEARLS", 6, 38909},
	{"ZEDI", 4, 38910},
	{"WORMS", 5, 38911},
	{"YSEV", 4, 38912},
	{"PALESTINIANS", 12, 38913},
	{"GSUP", 4, 38914},
	{"SCEL", 4, 38915},
	{"AYSD", 4, 38916},
	{"RBUR", 4, 38917},
	{"SATISFYING", 10, 38918},
	{"LDAP", 4, 38919},
	{"SUCCEEDED", 9, 38920},
	{"PREREQUISITES", 13, 38921},
	{"TRAR", 4, 38922},
	{"MAINTAINER", 10, 38923},
	{"ADIV", 4, 38924},
	{"CUSI", 4, 38925},
	{"APPLES", 6, 38926},
	{"DEWEY", 5, 38927},
	{"SURVIVING", 9, 38928},
	{"POUCH", 5, 38929},
	{"ADVENT", 6, 38930},
	{"PROPOSES", 8, 38931},
	{"IPER", 4, 38932},
	{"HOOKS", 5, 38933},
	{"EXPLOITATION", 12, 38934},
	{"PEDH", 4, 38935},
	{"SINGERS", 7, 38936},
	{"NEBY", 4, 38937},
	{"ONGK", 4, 38938},
	{"MAYO", 4, 38939},
	{"RASW", 4, 38940},
	{"TASMANIA", 8, 38941},
	{"RDOW", 4, 38942},
	{"VYJ", 3, 38943},
	{"DKEE", 4, 38944},
	{"EDQU", 4, 38945},
	{"RYWO", 4, 38946},
	{"BENQ", 4, 38947},
	{"OCUT", 4, 38948},
	{"SURRENDER", 9, 38949},
	{"SCHNEIDER", 9, 38950},
	{"TEFU", 4, 38951},
	{"LWU", 3, 38952},
	{"DJV", 3, 38953},
	{"AIDL", 4, 38954},
	{"ARSENAL", 7, 38955},
	{"DUB", 3, 38956},
	{"SCREWS", 6, 38957},
	{"PYRAMID", 7, 38958},
	{"ENJOYS", 6, 38959},
	{"BUYE", 4, 38960},
	{"JORS", 4, 38961},
	{"YCRI", 4, 38962},
	{"EGAV", 4, 38963},
	{"HACKING", 7, 38964},
	{"OBEU", 4, 38965},
	{"STRIPE", 6, 38966},
	{"KNOXVILLE", 9, 38967},
	{"PLOM", 4, 38968},
	{"AVERAGES", 8, 38969},
	{"XPAY", 4, 38970},
	{"PEAKS", 5, 38971},
	{"NGCU", 4, 38972},
	{"VESM", 4, 38973},
	{"EYWH", 4, 38974},
	{"RAMT", 4, 38975},
	{"COMO", 4, 38976},
	{"YSLO", 4, 38977},
	{"OFIM", 4, 38978},
	{"LISP", 4, 38979},
	{"LIMOUSINE", 9, 38980},
	{"CHURCHILL", 9, 38981},
	{"SDAU", 4, 38982},
	{"IMWI", 4, 38983},
	{"DQV", 3, 38984},
	{"MENTORING", 9, 38985},
	{"NSBY", 4, 38986},
	{"DALM", 4, 38987},
	{"ZERS", 4, 38988},
	{"AFFIRMATIVE", 11, 38989},
	{"ARUS", 4, 38990},
	{"KEYNOTE", 7, 38991},
	{"IRWI", 4, 38992},
	{"AIDR", 4, 38993},
	{"USBU", 4, 38994},
	{"DIDNT", 5, 38995},
	{"CLASSROOMS", 10, 38996},
	{"CRIF", 4, 38997},
	{"PLANTED", 7, 38998},
	{"PETITIONER", 10, 38999},
	{"VEDU", 4, 39000},
	{"DDIC", 4, 39001},
	{"LCLA", 4, 39002},
	{"RESIDENCY", 9, 39003},
	{"BOMBS", 5, 39004},
	{"NICHE", 5, 39005},
	{"CYIN", 4, 39006},
	{"DEADLINES", 9, 39007},
	{"REWU", 4, 39008},
	{"LDSU", 4, 39009},
	{"TTRU", 4, 39010},
	{"TWEW", 4, 39011},
	{"EYPR", 4, 39012},
	{"CIGAR", 5, 39013},
	{"EOFV", 4, 39014},
	{"CKHE", 4, 39015},
	{"ARSU", 4, 39016},
	{"CALCULATING", 11, 39017},
	{"TCHF", 4, 39018},
	{"LCRI", 4, 39019},
	{"AYLE", 4, 39020},
	{"ELDB", 4, 39021},
	{"BERKSHIRE", 9, 39022},
	{"ELPR", 4, 39023},
	{"BOOKSHOP", 8, 39024},
	{"PROPORTIONAL", 12, 39025},
	{"GHFO", 4, 39026},
	{"CREDENTIALS", 11, 39027},
	{"RZL", 3, 39028},
	{"AYPA", 4, 39029},
	{"AMPT", 4, 39030},
	{"DEPRECATED", 10, 39031},
	{"MUNICIPALITIES", 14, 39032},
	{"UPFR", 4, 39033},
	{"EDOG", 4, 39034},
	{"PTFO", 4, 39035},
	{"UALF", 4, 39036},
	{"ESUF", 4, 39037},
	{"LOCKER", 6, 39038},
	{"JENKINS", 7, 39039},
	{"SQUASH", 6, 39040},
	{"MTHR", 4, 39041},
	{"GESP", 4, 39042},
	{"NYYE", 4, 39043},
	{"SPOTTED", 7, 39044},
	{"CURSE", 5, 39045},
	{"PMAN", 4, 39046},
	{"AJAX", 4, 39047},
	{"SCUT", 4, 39048},
	{"EDPU", 4, 39049},
	{"LCHI", 4, 39050},
	{"COCONUT", 7, 39051},
	{"CONDUCTOR", 9, 39052},
	{"DEDL", 4, 39053},
	{"LEEX", 4, 39054},
	{"LIBERATION", 10, 39055},
	{"FOREX", 5, 39056},
	{"LBEN", 4, 39057},
	{"DIAGNOSTICS", 11, 39058},
	{"REMOVES", 7, 39059},
	{"LLOS", 4, 39060},
	{"YVL", 3, 39061},
	{"EELL", 4, 39062},
	{"LUXURIOUS", 9, 39063},
	{"RYME", 4, 39064},
	{"RINL", 4, 39065},
	{"DREAMCAST", 9, 39066},
	{"TUMORS", 6, 39067},
	{"BOOKED", 6, 39068},
	{"INDIRECTLY", 10, 39069},
	{"ULNE", 4, 39070},
	{"UTIC", 4, 39071},
	{"MEOR", 4, 39072},
	{"LUMBER", 6, 39073},
	{"KYOCERA", 7, 39074},
	{"OCKH", 4, 39075},
	{"PILLOWS", 7, 39076},
	{"AYSR", 4, 39077},
	{"DCLE", 4, 39078},
	{"RDPA", 4, 39079},
	{"PORTALS", 7, 39080},
	{"DHOP", 4, 39081},
	{"YGD", 3, 39082},
	{"ILLUSTRATOR", 11, 39083},
	{"TIQU", 4, 39084},
	{"LYDR", 4, 39085},
	{"NFAL", 4, 39086},
	{"ULOF", 4, 39087},
	{"POTASSIUM", 9, 39088},
	{"PROMPTED", 8, 39089},
	{"VEFI", 4, 39090},
	{"EAMF", 4, 39091},
	{"EYGO", 4, 39092},
	{"NUDES", 5, 39093},
	{"RATIONALE", 9, 39094},
	{"NDVO", 4, 39095},
	{"HUBS", 4, 39096},
	{"PASADENA", 8, 39097},
	{"ABNORMAL", 8, 39098},
	{"BISSAU", 6, 39099},
	{"FHIM", 4, 39100},
	{"MYLI", 4, 39101},
	{"DUTI", 4, 39102},
	{"SUBWAY", 6, 39103},
	{"OULI", 4, 39104},
	{"EWBU", 4, 39105},
	{"MCAN", 4, 39106},
	{"LIFTED", 6, 39107},
	{"MANKIND", 7, 39108},
	{"RLYF", 4, 39109},
	{"DSKI", 4, 39110},
	{"EDEG", 4, 39111},
	{"NCRO", 4, 39112},
	{"FGETS", 5, 39113},
	{"CITRUS", 6, 39114},
	{"UCKA", 4, 39115},
	{"IKEF", 4, 39116},
	{"YTAL", 4, 39117},
	{"LCOR", 4, 39118},
	{"PARAMOUNT", 9, 39119},
	{"IDWH", 4, 39120},
	{"KESW", 4, 39121},
	{"TADV", 4, 39122},
	{"UPRIGHT", 7, 39123},
	{"RSBA", 4, 39124},
	{"USPI", 4, 39125},
	{"RDAR", 4, 39126},
	{"EIRV", 4, 39127},
	{"GBEC", 4, 39128},
	{"ELDG", 4, 39129},
	{"BREAKFASTS", 10, 39130},
	{"TPOW", 4, 39131},
	{"INSPECTORS", 10, 39132},
	{"EMERGENCIES", 11, 39133},
	{"REUSE", 5, 39134},
	{"ERNEST", 6, 39135},
	{"YOUO", 4, 39136},
	{"NDKA", 4, 39137},
	{"GUNT", 4, 39138},
	{"FWIN", 4, 39139},
	{"SIGHTSEEING", 11, 39140},
	{"DCLI", 4, 39141},
	{"SHOCKED", 7, 39142},
	{"THERAPIES", 9, 39143},
	{"RYHI", 4, 39144},
	{"ALCOHOLIC", 9, 39145},
	{"BAKERY", 6, 39146},
	{"LIEUTENANT", 10, 39147},
	{"ORCHID", 6, 39148},
	{"YAMO", 4, 39149},
	{"DOWH", 4, 39150},
	{"DGOV", 4, 39151},
	{"HISTORIES", 9, 39152},
	{"LOSES", 5, 39153},
	{"WIDGET", 6, 39154},
	{"RSIX", 4, 39155},
	{"RENAULT", 7, 39156},
	{"ATKINS", 6, 39157},
	{"VARIABILITY", 11, 39158},
	{"COMOROS", 7, 39159},
	{"OMYA", 4, 39160},
	{"UTBA", 4, 39161},
	{"SUEDE", 5, 39162},
	{"RHOL", 4, 39163},
	{"NTYP", 4, 39164},
	{"CIZE", 4, 39165},
	{"ZABE", 4, 39166},
	{"OBSERVATORY", 11, 39167},
	{"ECOD", 4, 39168},
	{"WAITED", 6, 39169},
	{"PREVENTIVE", 10, 39170},
	{"RCLO", 4, 39171},
	{"KEFO", 4, 39172},
	{"PEACH", 5, 39173},
	{"DMOD", 4, 39174},
	{"CALCULUS", 8, 39175},
	{"STEFAN", 6, 39176},
	{"USBE", 4, 39177},
	{"UCHH", 4, 39178},
	{"UALM", 4, 39179},
	{"GIBL", 4, 39180},
	{"SELECTOR", 8, 39181},
	{"DIAPER", 6, 39182},
	{"DUNN", 4, 39183},
	{"HOTWIRE", 7, 39184},
	{"SMILING", 7, 39185},
	{"YREN", 4, 39186},
	{"DISB", 4, 39187},
	{"ADYH", 4, 39188},
	{"OUNCES", 6, 39189},
	{"REJO", 4, 39190},
	{"RTRU", 4, 39191},
	{"QBB", 3, 39192},
	{"INDW", 4, 39193},
	{"UNCUT", 5, 39194},
	{"VENL", 4, 39195},
	{"GFIR", 4, 39196},
	{"NOTING", 6, 39197},
	{"SHIFTING", 8, 39198},
	{"SAMURAI", 7, 39199},
	{"EYLO", 4, 39200},
	{"FTWI", 4, 39201},
	{"RSEW", 4, 39202},
	{"RFIL", 4, 39203},
	{"MOINES", 6, 39204},
	{"SUBTOTAL", 8, 39205},
	{"COEFFICIENTS", 12, 39206},
	{"DUPLEX", 6, 39207},
	{"MVP", 3, 39208},
	{"DELEGATE", 8, 39209},
	{"NEGOTIATED", 10, 39210},
	{"LYIF", 4, 39211},
	{"ANALYZER", 8, 39212},
	{"IMOU", 4, 39213},
	{"BYNO", 4, 39214},
	{"HERMAN", 6, 39215},
	{"ORYL", 4, 39216},
	{"CONGESTION", 10, 39217},
	{"DGIN", 4, 39218},
	{"RUNNERS", 7, 39219},
	{"GACT", 4, 39220},
	{"TSUM", 4, 39221},
	{"CHARSET", 7, 39222},
	{"TOFV", 4, 39223},
	{"DAYL", 4, 39224},
	{"CLIN", 4, 39225},
	{"ACCIDENTAL", 10, 39226},
	{"BYAP", 4, 39227},
	{"TALENTS", 7, 39228},
	{"NIXON", 5, 39229},
	{"YACO", 4, 39230},
	{"TFRA", 4, 39231},
	{"DSFI", 4, 39232},
	{"OFQU", 4, 39233},
	{"BRADY", 5, 39234},
	{"GUADELOUPE", 10, 39235},
	{"WALTON", 6, 39236},
	{"ZHANG", 5, 39237},
	{"UNDERWAY", 8, 39238},
	{"CARVED", 6, 39239},
	{"CKRE", 4, 39240},
	{"FREAK", 5, 39241},
	{"OBSTACLES", 9, 39242},
	{"YASP", 4, 39243},
	{"APOW", 4, 39244},
	{"GOVT", 4, 39245},
	{"CBC", 3, 39246},
	{"PREFERABLY", 10, 39247},
	{"BLUFF", 5, 39248},
	{"RYLO", 4, 39249},
	{"EXCERPTS", 8, 39250},
	{"JASPER", 6, 39251},
	{"HREP", 4, 39252},
	{"FORMATTED", 9, 39253},
	{"WHEL", 4, 39254},
	{"OMWI", 4, 39255},
	{"NEWBORN", 7, 39256},
	{"SADLY", 5, 39257},
	{"LAUGHED", 7, 39258},
	{"UCHP", 4, 39259},
	{"UBAN", 4, 39260},
	{"FTOF", 4, 39261},
	{"GORILLAZ", 8, 39262},
	{"AVAIL", 5, 39263},
	{"UNGM", 4, 39264},
	{"EMERSON", 7, 39265},
	{"DONP", 4, 39266},
	{"ORCHARD", 7, 39267},
	{"INHIBITORS", 10, 39268},
	{"WNWA", 4, 39269},
	{"TBLO", 4, 39270},
	{"DASU", 4, 39271},
	{"MYTHOLOGY", 9, 39272},
	{"PRESTIGIOUS", 11, 39273},
	{"AKEB", 4, 39274},
	{"NCAU", 4, 39275},
	{"NKLI", 4, 39276},
	{"TROUSERS", 8, 39277},
	{"GAMEPLAY", 8, 39278},
	{"ULLD", 4, 39279},
	{"HATCH", 5, 39280},
	{"REPLACES", 8, 39281},
	{"RTHB", 4, 39282},
	{"TOMB", 4, 39283},
	{"DRID", 4, 39284},
	{"REGINA", 6, 39285},
	{"OBLA", 4, 39286},
	{"GINM", 4, 39287},
	{"LLSB", 4, 39288},
	{"ADYB", 4, 39289},
	{"HGRE", 4, 39290},
	{"RSFA", 4, 39291},
	{"PRIVILEGED", 10, 39292},
	{"GOODNESS", 8, 39293},
	{"EXTRACTS", 8, 39294},
	{"PROFESSIONS", 11, 39295},
	{"URYS", 4, 39296},
	{"LAWI", 4, 39297},
	{"ODYI", 4, 39298},
	{"EGOD", 4, 39299},
	{"EXPLORED", 8, 39300},
	{"NGGU", 4, 39301},
	{"OWDI", 4, 39302},
	{"KTOB", 4, 39303},
	{"AUTISM", 6, 39304},
	{"TIBL", 4, 39305},
	{"MYSTERIES", 9, 39306},
	{"RCLI", 4, 39307},
	{"FULLER", 6, 39308},
	{"TAXPAYERS", 9, 39309},
	{"MARTINEZ", 8, 39310},
	{"DECREASES", 9, 39311},
	{"LLIC", 4, 39312},
	{"FSUP", 4, 39313},
	{"YSWH", 4, 39314},
	{"MOSP", 4, 39315},
	{"OFJE", 4, 39316},
	{"METRICS", 7, 39317},
	{"OMLA", 4, 39318},
	{"RIGU", 4, 39319},
	{"WINXP", 5, 39320},
	{"ODWA", 4, 39321},
	{"TDEM", 4, 39322},
	{"NKWE", 4, 39323},
	{"CRISP", 5, 39324},
	{"INABILITY", 9, 39325},
	{"CORONARY", 8, 39326},
	{"BLDG", 4, 39327},
	{"MEDIATED", 8, 39328},
	{"EWFO", 4, 39329},
	{"PROM", 4, 39330},
	{"SCANS", 5, 39331},
	{"KEEPER", 6, 39332},
	{"REINFORCED", 10, 39333},
	{"FULC", 4, 39334},
	{"NEGR", 4, 39335},
	{"OQUI", 4, 39336},
	{"JOHANNESBURG", 12, 39337},
	{"SPELLS", 6, 39338},
	{"SPECIFYING", 10, 39339},
	{"BUDDHIST", 8, 39340},
	{"LTOR", 4, 39341},
	{"ETIQUETTE", 9, 39342},
	{"MYIN", 4, 39343},
	{"ILDT", 4, 39344},
	{"DCHO", 4, 39345},
	{"RDLY", 4, 39346},
	{"BZU", 3, 39347},
	{"ROOKIE", 6, 39348},
	{"ENVIRON", 7, 39349},
	{"ALFL", 4, 39350},
	{"PEDU", 4, 39351},
	{"EYLL", 4, 39352},
	{"RROO", 4, 39353},
	{"BYAR", 4, 39354},
	{"THEATRICAL", 10, 39355},
	{"COLOURED", 8, 39356},
	{"AFEL", 4, 39357},
	{"BIRTHS", 6, 39358},
	{"VEDR", 4, 39359},
	{"TPIC", 4, 39360},
	{"EWPO", 4, 39361},
	{"ODWI", 4, 39362},
	{"AMEG", 4, 39363},
	{"AWER", 4, 39364},
	{"TMOD", 4, 39365},
	{"LTOU", 4, 39366},
	{"ODCO", 4, 39367},
	{"CUBS", 4, 39368},
	{"EDIU", 4, 39369},
	{"INTERDISCIPLINARY", 17, 39370},
	{"WHEELER", 7, 39371},
	{"MIGUEL", 6, 39372},
	{"KERALA", 6, 39373},
	{"PULP", 4, 39374},
	{"IXMO", 4, 39375},
	{"MPIL", 4, 39376},
	{"DSAF", 4, 39377},
	{"NDOB", 4, 39378},
	{"NLYG", 4, 39379},
	{"INTERPRETER", 11, 39380},
	{"ENZYMES", 7, 39381},
	{"DBAT", 4, 39382},
	{"MPHI", 4, 39383},
	{"SPECIMENS", 9, 39384},
	{"AYEV", 4, 39385},
	{"VEDM", 4, 39386},
	{"MSLI", 4, 39387},
	{"OWLO", 4, 39388},
	{"INITIATION", 10, 39389},
	{"ANALYTICS", 9, 39390},
	{"ASSAY", 5, 39391},
	{"JACUZZI", 7, 39392},
	{"RECONCILIATION", 14, 39393},
	{"RWEE", 4, 39394},
	{"ATLY", 4, 39395},
	{"YPUT", 4, 39396},
	{"RECOGNIZING", 11, 39397},
	{"PARSER", 6, 39398},
	{"LEIGH", 5, 39399},
	{"RBED", 4, 39400},
	{"ROMV", 4, 39401},
	{"OMAY", 4, 39402},
	{"RAZR", 4, 39403},
	{"TSCL", 4, 39404},
	{"RESPECTS", 8, 39405},
	{"USAB", 4, 39406},
	{"PLAQUE", 6, 39407},
	{"ACCOUNTED", 9, 39408},
	{"DEPOSITED", 9, 39409},
	{"LOWE", 4, 39410},
	{"BEAVERS", 7, 39411},
	{"EDUE", 4, 39412},
	{"CRIB", 4, 39413},
	{"STYLING", 7, 39414},
	{"RYYE", 4, 39415},
	{"SNACK", 5, 39416},
	{"DEFENDING", 9, 39417},
	{"PULLS", 5, 39418},
	{"RKID", 4, 39419},
	{"LARW", 4, 39420},
	{"NGEW", 4, 39421},
	{"CEFU", 4, 39422},
	{"LEEV", 4, 39423},
	{"AUTONOMOUS", 10, 39424},
	{"WEEZER", 6, 39425},
	{"MPTY", 4, 39426},
	{"GRANTING", 8, 39427},
	{"MOTORING", 8, 39428},
	{"APPROPRIATION", 13, 39429},
	{"RDAU", 4, 39430},
	{"RANDOMLY", 8, 39431},
	{"CONDENSED", 9, 39432},
	{"PHILIPPINE", 10, 39433},
	{"ASRU", 4, 39434},
	{"SEMICONDUCTORS", 14, 39435},
	{"SCENERY", 7, 39436},
	{"YLAR", 4, 39437},
	{"YOFG", 4, 39438},
	{"TOCC", 4, 39439},
	{"COCA", 4, 39440},
	{"YSIG", 4, 39441},
	{"WWY", 3, 39442},
	{"RLDI", 4, 39443},
	{"SKEP", 4, 39444},
	{"PEUGEOT", 7, 39445},
	{"BOLLYWOOD", 9, 39446},
	{"HOROSCOPES", 10, 39447},
	{"ADMO", 4, 39448},
	{"EYFI", 4, 39449},
	{"DRYING", 6, 39450},
	{"ASSEMBLIES", 10, 39451},
	{"EDUT", 4, 39452},
	{"KTHR", 4, 39453},
	{"XMAS", 4, 39454},
	{"NFUN", 4, 39455},
	{"SILICONE", 8, 39456},
	{"COLLATERAL", 10, 39457},
	{"LEARNER", 7, 39458},
	{"ONPU", 4, 39459},
	{"WELCOMES", 8, 39460},
	{"IVEV", 4, 39461},
	{"TRANSPLANT", 10, 39462},
	{"WERW", 4, 39463},
	{"SCOREBOARD", 10, 39464},
	{"UTAM", 4, 39465},
	{"PROLIFERATION", 13, 39466},
	{"USENET", 6, 39467},
	{"SQUID", 5, 39468},
	{"MIDW", 4, 39469},
	{"MARINES", 7, 39470},
	{"DFEA", 4, 39471},
	{"UYER", 4, 39472},
	{"YSAL", 4, 39473},
	{"IPSW", 4, 39474},
	{"REEZ", 4, 39475},
	{"LIGHTHOUSE", 10, 39476},
	{"PROVES", 6, 39477},
	{"CUSTOMISED", 10, 39478},
	{"TRILOGY", 7, 39479},
	{"IZAR", 4, 39480},
	{"ELFR", 4, 39481},
	{"ERNU", 4, 39482},
	{"CRAB", 4, 39483},
	{"OUWE", 4, 39484},
	{"IMOF", 4, 39485},
	{"BRIGHTNESS", 10, 39486},
	{"MAURICE", 7, 39487},
	{"BROOKE", 6, 39488},
	{"CONSUMED", 8, 39489},
	{"MAXIM", 5, 39490},
	{"RDAB", 4, 39491},
	{"BORE", 4, 39492},
	{"IMDB", 4, 39493},
	{"DEPRECIATION", 12, 39494},
	{"CLIC", 4, 39495},
	{"NKRU", 4, 39496},
	{"TECHNICALLY", 11, 39497},
	{"LLGR", 4, 39498},
	{"GINW", 4, 39499},
	{"PHARMACIST", 10, 39500},
	{"MARLEY", 6, 39501},
	{"ENJOYMENT", 9, 39502},
	{"TYPEPAD", 7, 39503},
	{"COWS", 4, 39504},
	{"SMEL", 4, 39505},
	{"VEGR", 4, 39506},
	{"DELIVERIES", 10, 39507},
	{"RECRUITERS", 10, 39508},
	{"AUSTRIAN", 8, 39509},
	{"RSUB", 4, 39510},
	{"CORRESPOND", 10, 39511},
	{"SLATE", 5, 39512},
	{"SUZANNE", 7, 39513},
	{"CONFINED", 8, 39514},
	{"SCREAMING", 9, 39515},
	{"INHABITANTS", 11, 39516},
	{"STRAIGHTFORWARD", 15, 39517},
	{"ORSL", 4, 39518},
	{"CYGWIN", 6, 39519},
	{"GEPO", 4, 39520},
	{"DYWA", 4, 39521},
	{"MORTON", 6, 39522},
	{"EGME", 4, 39523},
	{"YDRI", 4, 39524},
	{"GPRS", 4, 39525},
	{"JUPITER", 7, 39526},
	{"SIMULTANEOUS", 12, 39527},
	{"MONOPOLY", 8, 39528},
	{"RWOM", 4, 39529},
	{"INTENTIONS", 10, 39530},
	{"RIBB", 4, 39531},
	{"ROBOTICS", 8, 39532},
	{"RNIG", 4, 39533},
	{"PAGAN", 5, 39534},
	{"EYPL", 4, 39535},
	{"CHOPPED", 7, 39536},
	{"CONTEXTS", 8, 39537},
	{"OFFH", 4, 39538},
	{"OMMY", 4, 39539},
	{"TUAR", 4, 39540},
	{"ILWH", 4, 39541},
	{"RFLO", 4, 39542},
	{"RANDALL", 7, 39543},
	{"ENPU", 4, 39544},
	{"DESM", 4, 39545},
	{"BENSON", 6, 39546},
	{"SLEEVES", 7, 39547},
	{"RSAB", 4, 39548},
	{"FOOTNOTE", 8, 39549},
	{"VIBRANT", 7, 39550},
	{"EVOLVING", 8, 39551},
	{"RTMA", 4, 39552},
	{"BEWI", 4, 39553},
	{"HEYK", 4, 39554},
	{"YYM", 3, 39555},
	{"APPROXIMATION", 13, 39556},
	{"YORA", 4, 39557},
	{"SKIES", 5, 39558},
	{"BEGU", 4, 39559},
	{"BARRETT", 7, 39560},
	{"WYB", 3, 39561},
	{"EOFJ", 4, 39562},
	{"BURNERS", 7, 39563},
	{"GSTU", 4, 39564},
	{"UGHD", 4, 39565},
	{"TCER", 4, 39566},
	{"ATYP", 4, 39567},
	{"ALISON", 6, 39568},
	{"FITZGERALD", 10, 39569},
	{"NCYT", 4, 39570},
	{"KICKS", 5, 39571},
	{"EBOM", 4, 39572},
	{"RINP", 4, 39573},
	{"DISAPPEARED", 11, 39574},
	{"CANOE", 5, 39575},
	{"SOVEREIGN", 9, 39576},
	{"REMINDS", 7, 39577},
	{"ILBE", 4, 39578},
	{"CORRUPT", 7, 39579},
	{"IGIB", 4, 39580},
	{"DYBE", 4, 39581},
	{"OUGO", 4, 39582},
	{"SDRE", 4, 39583},
	{"VIOLATED", 8, 39584},
	{"DROUGHT", 7, 39585},
	{"RAMW", 4, 39586},
	{"DSLE", 4, 39587},
	{"HURRICANES", 10, 39588},
	{"PDY", 3, 39589},
	{"BRYA", 4, 39590},
	{"RCRO", 4, 39591},
	{"DNTG", 4, 39592},
	{"FORECLOSURES", 12, 39593},
	{"REPI", 4, 39594},
	{"PROPAGATION", 11, 39595},
	{"AUDITS", 6, 39596},
	{"IGNORANCE", 9, 39597},
	{"PESTICIDES", 10, 39598},
	{"EXPLOSIVE", 9, 39599},
	{"TMAJ", 4, 39600},
	{"YPUB", 4, 39601},
	{"KUV", 3, 39602},
	{"INVENTOR", 8, 39603},
	{"SCALING", 7, 39604},
	{"JUICY", 5, 39605},
	{"ATCL", 4, 39606},
	{"FAVE", 4, 39607},
	{"MBEC", 4, 39608},
	{"UZL", 3, 39609},
	{"RESIDUES", 8, 39610},
	{"ASHLEE", 6, 39611},
	{"EJEW", 4, 39612},
	{"ADYF", 4, 39613},
	{"MOODY", 5, 39614},
	{"FASHIONED", 9, 39615},
	{"UNPR", 4, 39616},
	{"YEXC", 4, 39617},
	{"AMPB", 4, 39618},
	{"DCAU", 4, 39619},
	{"TROK", 4, 39620},
	{"GRAINS", 6, 39621},
	{"SWRO", 4, 39622},
	{"VICINITY", 8, 39623},
	{"THYROID", 7, 39624},
	{"TARM", 4, 39625},
	{"BLYW", 4, 39626},
	{"VEOU", 4, 39627},
	{"PURIFICATION", 12, 39628},
	{"ORBITZ", 6, 39629},
	{"SOUTHEASTERN", 12, 39630},
	{"WIZARDS", 7, 39631},
	{"HOROSCOPE", 9, 39632},
	{"INVASIVE", 8, 39633},
	{"PROSPERITY", 10, 39634},
	{"VUZ", 3, 39635},
	{"RAINFALL", 8, 39636},
	{"EMIX", 4, 39637},
	{"HELSINKI", 8, 39638},
	{"IAGR", 4, 39639},
	{"HARDBACK", 8, 39640},
	{"RELU", 4, 39641},
	{"RISW", 4, 39642},
	{"MUM", 3, 39643},
	{"LAUNCHING", 9, 39644},
	{"VUITTON", 7, 39645},
	{"NEXTAG", 6, 39646},
	{"PEDAL", 5, 39647},
	{"LLLA", 4, 39648},
	{"INCONSISTENT", 12, 39649},
	{"EDFL", 4, 39650},
	{"PLANTATION", 10, 39651},
	{"NGUL", 4, 39652},
	{"BUTG", 4, 39653},
	{"STORING", 7, 39654},
	{"JUMPED", 6, 39655},
	{"OMYO", 4, 39656},
	{"TUNED", 5, 39657},
	{"YJP", 3, 39658},
	{"ORKP", 4, 39659},
	{"NARNIA", 6, 39660},
	{"PASSIONATE", 10, 39661},
	{"ALFA", 4, 39662},
	{"RYAC", 4, 39663},
	{"STAPLES", 7, 39664},
	{"LEYB", 4, 39665},
	{"MAYER", 5, 39666},
	{"UCKL", 4, 39667},
	{"BACKWARD", 8, 39668},
	{"EFUG", 4, 39669},
	{"SOUR", 4, 39670},
	{"GEOFF", 5, 39671},
	{"RENAME", 6, 39672},
	{"MARKUP", 6, 39673},
	{"COMBUSTION", 10, 39674},
	{"BREAKTHROUGH", 12, 39675},
	{"SCRAP", 5, 39676},
	{"TICB", 4, 39677},
	{"RNEL", 4, 39678},
	{"KEWA", 4, 39679},
	{"NCYC", 4, 39680},
	{"DALR", 4, 39681},
	{"BILATERAL", 9, 39682},
	{"LVET", 4, 39683},
	{"BELLA", 5, 39684},
	{"YFY", 3, 39685},
	{"BLONDES", 7, 39686},
	{"CTWA", 4, 39687},
	{"BENEFICIARIES", 13, 39688},
	{"DISPOSABLE", 10, 39689},
	{"RDAV", 4, 39690},
	{"RHAL", 4, 39691},
	{"WILLIAMSON", 10, 39692},
	{"SEGM", 4, 39693},
	{"GENTLEMEN", 9, 39694},
	{"NYMA", 4, 39695},
	{"GETP", 4, 39696},
	{"COPIER", 6, 39697},
	{"UNCATEGORIZED", 13, 39698},
	{"TERRA", 5, 39699},
	{"LITERAL", 7, 39700},
	{"QUESTIONED", 10, 39701},
	{"GUIDING", 7, 39702},
	{"UTSU", 4, 39703},
	{"CHARCOAL", 8, 39704},
	{"VAPOR", 5, 39705},
	{"BEWARE", 6, 39706},
	{"ALOUD", 5, 39707},
	{"EUPS", 4, 39708},
	{"DENB", 4, 39709},
	{"GLORIOUS", 8, 39710},
	{"RISL", 4, 39711},
	{"GEFORCE", 7, 39712},
	{"OVERLAP", 7, 39713},
	{"EKIC", 4, 39714},
	{"RBLO", 4, 39715},
	{"DEFAULTS", 8, 39716},
	{"FORECLOSURE", 11, 39717},
	{"CLARIFICATION", 13, 39718},
	{"ULFI", 4, 39719},
	{"RGOA", 4, 39720},
	{"OBEW", 4, 39721},
	{"GROUNDED", 8, 39722},
	{"UGHR", 4, 39723},
	{"BAIL", 4, 39724},
	{"GOOSE", 5, 39725},
	{"ESPRESSO", 8, 39726},
	{"RUNF", 4, 39727},
	{"YWEN", 4, 39728},
	{"URHA", 4, 39729},
	{"MERB", 4, 39730},
	{"JUDGEMENT", 9, 39731},
	{"LARF", 4, 39732},
	{"ITBY", 4, 39733},
	{"UTPO", 4, 39734},
	{"CRUISER", 7, 39735},
	{"REWT", 4, 39736},
	{"HENDRIX", 7, 39737},
	{"YHOL", 4, 39738},
	{"ESTEEM", 6, 39739},
	{"RWEN", 4, 39740},
	{"CASCADE", 7, 39741},
	{"STROKES", 7, 39742},
	{"SHELBY", 6, 39743},
	{"HOMEOWNER", 9, 39744},
	{"CKLI", 4, 39745},
	{"ANCESTRY", 8, 39746},
	{"DGEI", 4, 39747},
	{"DOLPHINS", 8, 39748},
	{"ADOPTING", 8, 39749},
	{"LANDED", 6, 39750},
	{"NUCLEUS", 7, 39751},
	{"DETACHED", 8, 39752},
	{"KEPL", 4, 39753},
	{"REWR", 4, 39754},
	{"BSOR", 4, 39755},
	{"SCOUTS", 6, 39756},
	{"LPOW", 4, 39757},
	{"ENUR", 4, 39758},
	{"TTYP", 4, 39759},
	{"WARSAW", 6, 39760},
	{"RPHO", 4, 39761},
	{"GLU", 3, 39762},
	{"DWHY", 4, 39763},
	{"CTWH", 4, 39764},
	{"WINNT", 5, 39765},
	{"VERB", 4, 39766},
	{"ECOP", 4, 39767},
	{"LCAL", 4, 39768},
	{"CHIC", 4, 39769},
	{"IDWI", 4, 39770},
	{"HYDRO", 5, 39771},
	{"NONLINEAR", 9, 39772},
	{"SPOKANE", 7, 39773},
	{"YBAL", 4, 39774},
	{"PHOSPHATE", 9, 39775},
	{"EEKW", 4, 39776},
	{"PLAYA", 5, 39777},
	{"OMWA", 4, 39778},
	{"NOISY", 5, 39779},
	{"ABIDE", 5, 39780},
	{"IRBE", 4, 39781},
	{"CKSC", 4, 39782},
	{"RADIOACTIVE", 11, 39783},
	{"SENTINEL", 8, 39784},
	{"BIRTHDAYS", 9, 39785},
	{"OMAG", 4, 39786},
	{"DESSERTS", 8, 39787},
	{"SOCIO", 5, 39788},
	{"PCMCIA", 6, 39789},
	{"DORG", 4, 39790},
	{"OKOV", 4, 39791},
	{"STPU", 4, 39792},
	{"PRESERVING", 10, 39793},
	{"GROOMING", 8, 39794},
	{"OMLI", 4, 39795},
	{"MERIDIAN", 8, 39796},
	{"MARRIAGES", 9, 39797},
	{"VALIDATE", 8, 39798},
	{"STAKES", 6, 39799},
	{"ROTATING", 8, 39800},
	{"NEDERLANDS", 10, 39801},
	{"ORDH", 4, 39802},
	{"FEDU", 4, 39803},
	{"BRIGADE", 7, 39804},
	{"OMDE", 4, 39805},
	{"LEMW", 4, 39806},
	{"RYTE", 4, 39807},
	{"MOVABLE", 7, 39808},
	{"VERV", 4, 39809},
	{"LTOG", 4, 39810},
	{"NGHU", 4, 39811},
	{"DOUBLES", 7, 39812},
	{"RSPL", 4, 39813},
	{"EOLY", 4, 39814},
	{"BLISS", 5, 39815},
	{"FILMOGRAPHY", 11, 39816},
	{"EAML", 4, 39817},
	{"RYSP", 4, 39818},
	{"HUMILIATION", 11, 39819},
	{"VILW", 4, 39820},
	{"ERJE", 4, 39821},
	{"LITTER", 6, 39822},
	{"TRYC", 4, 39823},
	{"REFLECTIVE", 10, 39824},
	{"RFUN", 4, 39825},
	{"OUTERWEAR", 9, 39826},
	{"BLYB", 4, 39827},
	{"YBEN", 4, 39828},
	{"AMUC", 4, 39829},
	{"TLYE", 4, 39830},
	{"ABBREVIATIONS", 13, 39831},
	{"EXECUTING", 9, 39832},
	{"EERW", 4, 39833},
	{"DFIG", 4, 39834},
	{"EVEG", 4, 39835},
	{"YDOW", 4, 39836},
	{"NRUS", 4, 39837},
	{"OWRO", 4, 39838},
	{"HEDP", 4, 39839},
	{"XXC", 3, 39840},
	{"FECO", 4, 39841},
	{"LKTO", 4, 39842},
	{"GREENWICH", 9, 39843},
	{"FLOODING", 8, 39844},
	{"RTUG", 4, 39845},
	{"EDPI", 4, 39846},
	{"PARSE", 5, 39847},
	{"RUGGED", 6, 39848},
	{"JELLY", 5, 39849},
	{"PWHI", 4, 39850},
	{"IMPLEMENTATIONS", 15, 39851},
	{"RENOVATION", 10, 39852},
	{"PUMA", 4, 39853},
	{"ATTENDEES", 9, 39854},
	{"HFUL", 4, 39855},
	{"TJOB", 4, 39856},
	{"PANTHERS", 8, 39857},
	{"VEBO", 4, 39858},
	{"YRAT", 4, 39859},
	{"PERCEPTIONS", 11, 39860},
	{"GREENWOOD", 9, 39861},
	{"LJUS", 4, 39862},
	{"IGNITION", 8, 39863},
	{"ATCR", 4, 39864},
	{"HUMBLE", 6, 39865},
	{"UERE", 4, 39866},
	{"NYDI", 4, 39867},
	{"URAS", 4, 39868},
	{"KINC", 4, 39869},
	{"BYRO", 4, 39870},
	{"DOWNSTREAM", 10, 39871},
	{"PETROL", 6, 39872},
	{"MIDWAY", 6, 39873},
	{"LASM", 4, 39874},
	{"OCKM", 4, 39875},
	{"SBER", 4, 39876},
	{"OADB", 4, 39877},
	{"MANIA", 5, 39878},
	{"EDWIN", 5, 39879},
	{"WEBCASTS", 8, 39880},
	{"YFAR", 4, 39881},
	{"DLAW", 4, 39882},
	{"YADV", 4, 39883},
	{"ACCELERATOR", 11, 39884},
	{"MASTERBATING", 12, 39885},
	{"IMBU", 4, 39886},
	{"FFOF", 4, 39887},
	{"CLARE", 5, 39888},
	{"GETW", 4, 39889},
	{"ARDU", 4, 39890},
	{"ILOM", 4, 39891},
	{"OOKB", 4, 39892},
	{"DLYT", 4, 39893},
	{"NERU", 4, 39894},
	{"UIVA", 4, 39895},
	{"FLYERS", 6, 39896},
	{"RECOGNISE", 9, 39897},
	{"ROPT", 4, 39898},
	{"TACOMA", 6, 39899},
	{"APHRODITE", 9, 39900},
	{"LSPR", 4, 39901},
	{"RADIOLOGY", 9, 39902},
	{"NIMM", 4, 39903},
	{"RUNC", 4, 39904},
	{"ESTABLISHES", 11, 39905},
	{"YLET", 4, 39906},
	{"WHITES", 6, 39907},
	{"TRAPPED", 7, 39908},
	{"BOLTS", 5, 39909},
	{"LOCALS", 6, 39910},
	{"FRINGE", 6, 39911},
	{"LINGUISTIC", 10, 39912},
	{"INTERNALLY", 10, 39913},
	{"OFAW", 4, 39914},
	{"DSPI", 4, 39915},
	{"PLANETARY", 9, 39916},
	{"LSPA", 4, 39917},
	{"TUNGSTEN", 8, 39918},
	{"TYPED", 5, 39919},
	{"DESC", 4, 39920},
	{"DATASHEET", 9, 39921},
	{"GPY", 3, 39922},
	{"LAURENT", 7, 39923},
	{"FOLI", 4, 39924},
	{"LOWH", 4, 39925},
	{"RINW", 4, 39926},
	{"EDJO", 4, 39927},
	{"SHUTDOWN", 8, 39928},
	{"MANUEL", 6, 39929},
	{"YBOO", 4, 39930},
	{"XENICAL", 7, 39931},
	{"YWAL", 4, 39932},
	{"IRLE", 4, 39933},
	{"COMPUTERWORLD", 13, 39934},
	{"GAZA", 4, 39935},
	{"INFLUENZA", 9, 39936},
	{"UXG", 3, 39937},
	{"FGRA", 4, 39938},
	{"DABR", 4, 39939},
	{"GILL", 4, 39940},
	{"DWED", 4, 39941},
	{"TATTOOS", 7, 39942},
	{"RUDE", 4, 39943},
	{"OWSU", 4, 39944},
	{"ILEL", 4, 39945},
	{"OSQU", 4, 39946},
	{"RPHY", 4, 39947},
	{"AMAW", 4, 39948},
	{"HEYU", 4, 39949},
	{"ARKC", 4, 39950},
	{"STEELE", 6, 39951},
	{"LUAB", 4, 39952},
	{"CITING", 6, 39953},
	{"KCOM", 4, 39954},
	{"UESW", 4, 39955},
	{"VIEWPOINT", 9, 39956},
	{"PEPTIDE", 7, 39957},
	{"VORC", 4, 39958},
	{"UPHI", 4, 39959},
	{"URAB", 4, 39960},
	{"OFGU", 4, 39961},
	{"SWEATSHIRT", 10, 39962},
	{"HASSLE", 6, 39963},
	{"REGENTS", 7, 39964},
	{"SERVANTS", 8, 39965},
	{"GOFO", 4, 39966},
	{"INBL", 4, 39967},
	{"CCEN", 4, 39968},
	{"WNBY", 4, 39969},
	{"MEANINGS", 8, 39970},
	{"LLPH", 4, 39971},
	{"UEWI", 4, 39972},
	{"UNEMPLOYED", 10, 39973},
	{"HEAVENLY", 8, 39974},
	{"RYHO", 4, 39975},
	{"EXETER", 6, 39976},
	{"TYFI", 4, 39977},
	{"EPUL", 4, 39978},
	{"DOCKET", 6, 39979},
	{"DLL", 3, 39980},
	{"WFRO", 4, 39981},
	{"ELSEVIER", 8, 39982},
	{"RLYH", 4, 39983},
	{"OBLO", 4, 39984},
	{"NORDIC", 6, 39985},
	{"KRUP", 4, 39986},
	{"TLIF", 4, 39987},
	{"CURL", 4, 39988},
	{"PRIVAT", 6, 39989},
	{"ALBANIAN", 8, 39990},
	{"UPSI", 4, 39991},
	{"GLEF", 4, 39992},
	{"OVERFLOW", 8, 39993},
	{"GEOMETRIC", 9, 39994},
	{"HASTINGS", 8, 39995},
	{"ILFO", 4, 39996},
	{"LDLO", 4, 39997},
	{"CYTH", 4, 39998},
	{"SUBSIDIES", 9, 39999},
	{"TAXONOMY", 8, 40000},
	{"THIRDS", 6, 40001},
	{"DELI", 4, 40002},
	{"INTERN", 6, 40003},
	{"AYPR", 4, 40004},
	{"IMPLICIT", 8, 40005},
	{"PATRIOTIC", 9, 40006},
	{"SIMPLIFY", 8, 40007},
	{"MWER", 4, 40008},
	{"DARLING", 7, 40009},
	{"SCHWARTZ", 8, 40010},
	{"ORNAMENTS", 9, 40011},
	{"GZU", 3, 40012},
	{"MEGAN", 5, 40013},
	{"ALLERGIES", 9, 40014},
	{"DEFINITE", 8, 40015},
	{"MEAB", 4, 40016},
	{"BANGALORE", 9, 40017},
	{"YASW", 4, 40018},
	{"LREV", 4, 40019},
	{"YLIS", 4, 40020},
	{"CONGREGATION", 12, 40021},
	{"REGIMENT", 8, 40022},
	{"FJUS", 4, 40023},
	{"EVERETT", 7, 40024},
	{"REVIEWERS", 9, 40025},
	{"CLUTTER", 7, 40026},
	{"NCHM", 4, 40027},
	{"DCUR", 4, 40028},
	{"MISLEADING", 10, 40029},
	{"MARTY", 5, 40030},
	{"YWRI", 4, 40031},
	{"RKNE", 4, 40032},
	{"ARSM", 4, 40033},
	{"KVD", 3, 40034},
	{"VALE", 4, 40035},
	{"YRAC", 4, 40036},
	{"LCOA", 4, 40037},
	{"WHEREBY", 7, 40038},
	{"DECEASED", 8, 40039},
	{"LWOU", 4, 40040},
	{"SPARKS", 6, 40041},
	{"XLIBS", 5, 40042},
	{"BYON", 4, 40043},
	{"NDIL", 4, 40044},
	{"LTOP", 4, 40045},
	{"BELGIAN", 7, 40046},
	{"OKSL", 4, 40047},
	{"ADOLESCENTS", 11, 40048},
	{"SIMPLER", 7, 40049},
	{"CAPTURES", 8, 40050},
	{"COVENTRY", 8, 40051},
	{"YSLE", 4, 40052},
	{"SKFO", 4, 40053},
	{"CAPITALISM", 10, 40054},
	{"HANCOCK", 7, 40055},
	{"FALKLAND", 8, 40056},
	{"CLAMP", 5, 40057},
	{"CUR", 3, 40058},
	{"PRICEGRABBER", 12, 40059},
	{"MAMMALS", 7, 40060},
	{"YGP", 3, 40061},
	{"KIDN", 4, 40062},
	{"PLYA", 4, 40063},
	{"CLONING", 7, 40064},
	{"ARGS", 4, 40065},
	{"BIGP", 4, 40066},
	{"MADDEN", 6, 40067},
	{"CECR", 4, 40068},
	{"RUSS", 4, 40069},
	{"PEPPERS", 7, 40070},
	{"LYSC", 4, 40071},
	{"DEEDS", 5, 40072},
	{"LIVELY", 6, 40073},
	{"INEQUALITY", 10, 40074},
	{"EWDE", 4, 40075},
	{"SMUGMUG", 7, 40076},
	{"PREMATURE", 9, 40077},
	{"VISUALLY", 8, 40078},
	{"TRIPOD", 6, 40079},
	{"WREC", 4, 40080},
	{"UBSC", 4, 40081},
	{"ICGR", 4, 40082},
	{"UPID", 4, 40083},
	{"ORQU", 4, 40084},
	{"IPLA", 4, 40085},
	{"ALRIGHT", 7, 40086},
	{"LAGUNA", 6, 40087},
	{"DJUN", 4, 40088},
	{"DHUM", 4, 40089},
	{"LIMO", 4, 40090},
	{"TBRA", 4, 40091},
	{"DEMONSTRATIONS", 14, 40092},
	{"URMI", 4, 40093},
	{"OBSOLETE", 8, 40094},
	{"ALIGNED", 7, 40095},
	{"RUST", 4, 40096},
	{"NCYO", 4, 40097},
	{"SFAV", 4, 40098},
	{"VEWE", 4, 40099},
	{"PESTICIDE", 9, 40100},
	{"YLER", 4, 40101},
	{"TRAPS", 5, 40102},
	{"SHUFFLE", 7, 40103},
	{"WARDROBE", 8, 40104},
	{"TRANSFORMERS", 12, 40105},
	{"IMMY", 4, 40106},
	{"RGEI", 4, 40107},
	{"NTJU", 4, 40108},
	{"SUCCESSES", 9, 40109},
	{"METW", 4, 40110},
	{"DLIG", 4, 40111},
	{"UMTH", 4, 40112},
	{"RACER", 5, 40113},
	{"FABRICATION", 11, 40114},
	{"LBOU", 4, 40115},
	{"LOFP", 4, 40116},
	{"SEPL", 4, 40117},
	{"HKOR", 4, 40118},
	{"LYBO", 4, 40119},
	{"EXPLOITED", 9, 40120},
	{"AVID", 4, 40121},
	{"OUTPATIENT", 10, 40122},
	{"BLADDER", 7, 40123},
	{"INFLAMMATORY", 12, 40124},
	{"RLIK", 4, 40125},
	{"IMMUNITY", 8, 40126},
	{"ENCRYPTED", 9, 40127},
	{"SLYA", 4, 40128},
	{"CCAN", 4, 40129},
	{"WHOLESALERS", 11, 40130},
	{"MSWH", 4, 40131},
	{"MAYW", 4, 40132},
	{"DOYLE", 5, 40133},
	{"DUCKS", 5, 40134},
	{"ICVI", 4, 40135},
	{"COLDFUSION", 10, 40136},
	{"NTCL", 4, 40137},
	{"DCR", 3, 40138},
	{"SHOOTER", 7, 40139},
	{"RKAB", 4, 40140},
	{"SWITCHBOARD", 11, 40141},
	{"PAINTS", 6, 40142},
	{"KEOV", 4, 40143},
	{"VINCE", 5, 40144},
	{"DNIG", 4, 40145},
	{"NEIGHBOURHOOD", 13, 40146},
	{"CHEATING", 8, 40147},
	{"CARR", 4, 40148},
	{"LFOO", 4, 40149},
	{"OLEL", 4, 40150},
	{"LADV", 4, 40151},
	{"FLUORESCENT", 11, 40152},
	{"TASTES", 6, 40153},
	{"COOKWARE", 8, 40154},
	{"UROR", 4, 40155},
	{"STORMS", 6, 40156},
	{"YCIT", 4, 40157},
	{"LAVIGNE", 7, 40158},
	{"DUPW", 4, 40159},
	{"PABI", 4, 40160},
	{"IFLE", 4, 40161},
	{"PARAM", 5, 40162},
	{"SMILED", 6, 40163},
	{"JURISDICTIONS", 13, 40164},
	{"LMEA", 4, 40165},
	{"NWID", 4, 40166},
	{"NNUM", 4, 40167},
	{"SCRUTINY", 8, 40168},
	{"REGENERATION", 12, 40169},
	{"LUNAR", 5, 40170},
	{"DIFFERENTIATION", 15, 40171},
	{"SHIELDS", 7, 40172},
	{"ENVIRONMENTALLY", 15, 40173},
	{"VENR", 4, 40174},
	{"NONSENSE", 8, 40175},
	{"IGNW", 4, 40176},
	{"LLBR", 4, 40177},
	{"OUPW", 4, 40178},
	{"VJU", 3, 40179},
	{"INVENTED", 8, 40180},
	{"RANU", 4, 40181},
	{"GRADIENT", 8, 40182},
	{"YRAI", 4, 40183},
	{"NCBI", 4, 40184},
	{"INSERTS", 7, 40185},
	{"BYSA", 4, 40186},
	{"GREL", 4, 40187},
	{"KVM", 3, 40188},
	{"ELAINE", 6, 40189},
	{"YFAI", 4, 40190},
	{"YAPR", 4, 40191},
	{"RSEP", 4, 40192},
	{"PROGRAMMABLE", 12, 40193},
	{"UDYI", 4, 40194},
	{"EADU", 4, 40195},
	{"POSED", 5, 40196},
	{"CHSU", 4, 40197},
	{"LDLA", 4, 40198},
	{"SUBJECTED", 9, 40199},
	{"CRUC", 4, 40200},
	{"TASTING", 7, 40201},
	{"NCEY", 4, 40202},
	{"GSOU", 4, 40203},
	{"AYAB", 4, 40204},
	{"LLIM", 4, 40205},
	{"DDOE", 4, 40206},
	{"BIBTEX", 6, 40207},
	{"MTOC", 4, 40208},
	{"CHEMOTHERAPY", 12, 40209},
	{"RDSB", 4, 40210},
	{"KEDE", 4, 40211},
	{"YLEF", 4, 40212},
	{"DSID", 4, 40213},
	{"PICI", 4, 40214},
	{"GWEN", 4, 40215},
	{"OFKA", 4, 40216},
	{"DUPI", 4, 40217},
	{"BORROWING", 9, 40218},
	{"ARISES", 6, 40219},
	{"LTRI", 4, 40220},
	{"EPOV", 4, 40221},
	{"PRECAUTIONS", 11, 40222},
	{"FLOU", 4, 40223},
	{"ERWR", 4, 40224},
	{"SMAG", 4, 40225},
	{"OMAB", 4, 40226},
	{"UNKE", 4, 40227},
	{"BRANDED", 7, 40228},
	{"DOFG", 4, 40229},
	{"RSBY", 4, 40230},
	{"DYSFUNCTION", 11, 40231},
	{"MANNING", 7, 40232},
	{"LISBON", 6, 40233},
	{"GNME", 4, 40234},
	{"FORKS", 5, 40235},
	{"MONK", 4, 40236},
	{"BOXER", 5, 40237},
	{"SHINING", 7, 40238},
	{"IDFI", 4, 40239},
	{"LIVEJOURNAL", 11, 40240},
	{"LBED", 4, 40241},
	{"LDFA", 4, 40242},
	{"ABOL", 4, 40243},
	{"RDAM", 4, 40244},
	{"DIAZEPAM", 8, 40245},
	{"LDBU", 4, 40246},
	{"ELWH", 4, 40247},
	{"RODEO", 5, 40248},
	{"GPOL", 4, 40249},
	{"CLERICAL", 8, 40250},
	{"VOYAGER", 7, 40251},
	{"TWEC", 4, 40252},
	{"HOBART", 6, 40253},
	{"GANC", 4, 40254},
	{"RONW", 4, 40255},
	{"LEYT", 4, 40256},
	{"ANPU", 4, 40257},
	{"OWNU", 4, 40258},
	{"SAMPLER", 7, 40259},
	{"ARYG", 4, 40260},
	{"HOWB", 4, 40261},
	{"UTBU", 4, 40262},
	{"MOOSE", 5, 40263},
	{"DAPE", 4, 40264},
	{"ANCU", 4, 40265},
	{"JOVI", 4, 40266},
	{"EMWH", 4, 40267},
	{"EYMO", 4, 40268},
	{"TIMETABLE", 9, 40269},
	{"DORSET", 6, 40270},
	{"YLOW", 4, 40271},
	{"TBUR", 4, 40272},
	{"ULLB", 4, 40273},
	{"KEYT", 4, 40274},
	{"OUSG", 4, 40275},
	{"CORROSION", 9, 40276},
	{"ARDG", 4, 40277},
	{"UNWA", 4, 40278},
	{"POSITIONED", 10, 40279},
	{"CHECKER", 7, 40280},
	{"BUENOS", 6, 40281},
	{"WORKSTATIONS", 12, 40282},
	{"SDEG", 4, 40283},
	{"WARW", 4, 40284},
	{"MEDR", 4, 40285},
	{"CATHY", 5, 40286},
	{"LCIT", 4, 40287},
	{"MYSTIC", 6, 40288},
	{"SOLICITATION", 12, 40289},
	{"GCEN", 4, 40290},
	{"DARREN", 6, 40291},
	{"RUCI", 4, 40292},
	{"CMP", 3, 40293},
	{"GOFS", 4, 40294},
	{"RECTANGULAR", 11, 40295},
	{"FEWH", 4, 40296},
	{"CRAI", 4, 40297},
	{"FISCHER", 7, 40298},
	{"ENTHUSIAST", 10, 40299},
	{"UDP", 3, 40300},
	{"POSITIVELY", 10, 40301},
	{"OXFO", 4, 40302},
	{"LICP", 4, 40303},
	{"SHAPING", 7, 40304},
	{"EDBL", 4, 40305},
	{"NOWP", 4, 40306},
	{"AFGHAN", 6, 40307},
	{"OROB", 4, 40308},
	{"OWLA", 4, 40309},
	{"SKOF", 4, 40310},
	{"PAULO", 5, 40311},
	{"NKIL", 4, 40312},
	{"PUMPING", 7, 40313},
	{"PATENTED", 8, 40314},
	{"REVIVAL", 7, 40315},
	{"LLSM", 4, 40316},
	{"LEVER", 5, 40317},
	{"RBOA", 4, 40318},
	{"REDUNDANT", 9, 40319},
	{"REGENCY", 7, 40320},
	{"MILFSEEKER", 10, 40321},
	{"TASTY", 5, 40322},
	{"ALAF", 4, 40323},
	{"NCYI", 4, 40324},
	{"BRUC", 4, 40325},
	{"RWRI", 4, 40326},
	{"MIDLAND", 7, 40327},
	{"SSUG", 4, 40328},
	{"DNAM", 4, 40329},
	{"EJOU", 4, 40330},
	{"EDJA", 4, 40331},
	{"WSCO", 4, 40332},
	{"SYNCHRONIZATION", 15, 40333},
	{"MCCARTHY", 8, 40334},
	{"INFORMATICS", 11, 40335},
	{"OAKLEY", 6, 40336},
	{"LDWO", 4, 40337},
	{"HECK", 4, 40338},
	{"RANTS", 5, 40339},
	{"TAROT", 5, 40340},
	{"DIDREX", 6, 40341},
	{"BRENDA", 6, 40342},
	{"UNDU", 4, 40343},
	{"CIVILIANS", 9, 40344},
	{"BARK", 4, 40345},
	{"CARTS", 5, 40346},
	{"WASTED", 6, 40347},
	{"WEDH", 4, 40348},
	{"FPUB", 4, 40349},
	{"RPOO", 4, 40350},
	{"LDPO", 4, 40351},
	{"PURDUE", 6, 40352},
	{"YONC", 4, 40353},
	{"ADGE", 4, 40354},
	{"COCOA", 5, 40355},
	{"INVITES", 7, 40356},
	{"CUSHION", 7, 40357},
	{"REVERSED", 8, 40358},
	{"YNOR", 4, 40359},
	{"AVIG", 4, 40360},
	{"LYNX", 4, 40361},
	{"DTRU", 4, 40362},
	{"ORDB", 4, 40363},
	{"FIGURINES", 9, 40364},
	{"ZEOF", 4, 40365},
	{"KWIL", 4, 40366},
	{"FOOTER", 6, 40367},
	{"MATERNAL", 8, 40368},
	{"RNEX", 4, 40369},
	{"SPECIMEN", 8, 40370},
	{"JEDI", 4, 40371},
	{"SEAMLESS", 8, 40372},
	{"OLOM", 4, 40373},
	{"ANCESTORS", 9, 40374},
	{"ICKH", 4, 40375},
	{"PANTHER", 7, 40376},
	{"MIXES", 5, 40377},
	{"GRAVES", 6, 40378},
	{"KPRO", 4, 40379},
	{"BRANDING", 8, 40380},
	{"GHETTO", 6, 40381},
	{"PBEL", 4, 40382},
	{"EPUN", 4, 40383},
	{"EXAMINER", 8, 40384},
	{"VINEYARD", 8, 40385},
	{"MEADOW", 6, 40386},
	{"LECR", 4, 40387},
	{"RYOV", 4, 40388},
	{"WARO", 4, 40389},
	{"LAVO", 4, 40390},
	{"ELOU", 4, 40391},
	{"USMI", 4, 40392},
	{"DSLO", 4, 40393},
	{"AMSF", 4, 40394},
	{"LNEV", 4, 40395},
	{"FEEDER", 6, 40396},
	{"MERCER", 6, 40397},
	{"YBEH", 4, 40398},
	{"ROMS", 4, 40399},
	{"GOODMAN", 7, 40400},
	{"YSID", 4, 40401},
	{"SUBUNIT", 7, 40402},
	{"URGO", 4, 40403},
	{"CHLORIDE", 8, 40404},
	{"BYSI", 4, 40405},
	{"DPOR", 4, 40406},
	{"YSLI", 4, 40407},
	{"RTBE", 4, 40408},
	{"LLOP", 4, 40409},
	{"VUD", 3, 40410},
	{"AWAITING", 8, 40411},
	{"IMSU", 4, 40412},
	{"BECKER", 6, 40413},
	{"AIRES", 5, 40414},
	{"BULLS", 5, 40415},
	{"HBEC", 4, 40416},
	{"DAYD", 4, 40417},
	{"ORION", 5, 40418},
	{"RJJ", 3, 40419},
	{"COMMERCIALS", 11, 40420},
	{"FHOU", 4, 40421},
	{"COUNCILLOR", 10, 40422},
	{"OCKP", 4, 40423},
	{"REGULATORS", 10, 40424},
	{"EDGU", 4, 40425},
	{"RBLA", 4, 40426},
	{"NDYA", 4, 40427},
	{"CLARKSON", 8, 40428},
	{"CARLSON", 7, 40429},
	{"ILYR", 4, 40430},
	{"SRUS", 4, 40431},
	{"MIDT", 4, 40432},
	{"BENEFICIARY", 11, 40433},
	{"BENCHMARKS", 10, 40434},
	{"HANSON", 6, 40435},
	{"AROR", 4, 40436},
	{"OFFSPRING", 9, 40437},
	{"ELWI", 4, 40438},
	{"FEWW", 4, 40439},
	{"PANORAMA", 8, 40440},
	{"RETRIEVING", 10, 40441},
	{"ODOR", 4, 40442},
	{"DATW", 4, 40443},
	{"DEMANDED", 8, 40444},
	{"REACTOR", 7, 40445},
	{"KIRIBATI", 8, 40446},
	{"WASTES", 6, 40447},
	{"TELNET", 6, 40448},
	{"CLASH", 5, 40449},
	{"BIKER", 5, 40450},
	{"FIDELITY", 8, 40451},
	{"LDBY", 4, 40452},
	{"PARKED", 6, 40453},
	{"FINANCIALS", 10, 40454},
	{"CASTRO", 6, 40455},
	{"FLEW", 4, 40456},
	{"ROFG", 4, 40457},
	{"HOLDEN", 6, 40458},
	{"UAKE", 4, 40459},
	{"CONVERTERS", 10, 40460},
	{"NAURU", 5, 40461},
	{"ANKF", 4, 40462},
	{"YROL", 4, 40463},
	{"OAGR", 4, 40464},
	{"RHAPSODY", 8, 40465},
	{"DBEM", 4, 40466},
	{"TRUMPET", 7, 40467},
	{"OLPH", 4, 40468},
	{"LMEE", 4, 40469},
	{"SOLITAIRE", 9, 40470},
	{"EWWI", 4, 40471},
	{"ULFO", 4, 40472},
	{"ADRU", 4, 40473},
	{"DECREASING", 10, 40474},
	{"FREEZING", 8, 40475},
	{"KAISER", 6, 40476},
	{"REXT", 4, 40477},
	{"FGOV", 4, 40478},
	{"DISHWASHER", 10, 40479},
	{"WALLIS", 6, 40480},
	{"ONUM", 4, 40481},
	{"EGIC", 4, 40482},
	{"CRIMINALS", 9, 40483},
	{"NEURONS", 7, 40484},
	{"LHOL", 4, 40485},
	{"TTRY", 4, 40486},
	{"RUMORS", 6, 40487},
	{"RBOD", 4, 40488},
	{"ACCOMPLISHMENTS", 15, 40489},
	{"EMERGENCE", 9, 40490},
	{"RYTR", 4, 40491},
	{"GBEE", 4, 40492},
	{"JORL", 4, 40493},
	{"URDI", 4, 40494},
	{"THEATRES", 8, 40495},
	{"APEX", 4, 40496},
	{"CRIMSON", 7, 40497},
	{"BYPO", 4, 40498},
	{"COMPASSION", 10, 40499},
	{"ULYT", 4, 40500},
	{"BEUN", 4, 40501},
	{"YLAW", 4, 40502},
	{"KOFS", 4, 40503},
	{"DPAY", 4, 40504},
	{"NEEDING", 7, 40505},
	{"DSAV", 4, 40506},
	{"HEXP", 4, 40507},
	{"AGOV", 4, 40508},
	{"ADSU", 4, 40509},
	{"ECOSYSTEMS", 10, 40510},
	{"CHFR", 4, 40511},
	{"BEFI", 4, 40512},
	{"PRONOUNCED", 10, 40513},
	{"EXTENSIVELY", 11, 40514},
	{"DVAL", 4, 40515},
	{"CONRAD", 6, 40516},
	{"WISHED", 6, 40517},
	{"TRANSIENT", 9, 40518},
	{"RSAM", 4, 40519},
	{"UWER", 4, 40520},
	{"WSKI", 4, 40521},
	{"EYBA", 4, 40522},
	{"KICKED", 6, 40523},
	{"USEY", 4, 40524},
	{"COLORING", 8, 40525},
	{"CURB", 4, 40526},
	{"TLIG", 4, 40527},
	{"GADGET", 6, 40528},
	{"TPOR", 4, 40529},
	{"ELCH", 4, 40530},
	{"CCTV", 4, 40531},
	{"LEUKEMIA", 8, 40532},
	{"REIGN", 5, 40533},
	{"TRIVIAL", 7, 40534},
	{"DECO", 4, 40535},
	{"TICKER", 6, 40536},
	{"COKE", 4, 40537},
	{"HABITATS", 8, 40538},
	{"CLAUSES", 7, 40539},
	{"OFUR", 4, 40540},
	{"BARON", 5, 40541},
	{"YQUI", 4, 40542},
	{"MHAD", 4, 40543},
	{"GFAC", 4, 40544},
	{"NGKI", 4, 40545},
	{"REMOVER", 7, 40546},
	{"SENSIBLE", 8, 40547},
	{"UNLAWFUL", 8, 40548},
	{"BATES", 5, 40549},
	{"INCORPORATES", 12, 40550},
	{"RUNB", 4, 40551},
	{"BRASIL", 6, 40552},
	{"LEOP", 4, 40553},
	{"NALV", 4, 40554},
	{"WEBS", 4, 40555},
	{"SWINGING", 8, 40556},
	{"ACCOUNTABLE", 11, 40557},
	{"THRUST", 6, 40558},
	{"PROVING", 7, 40559},
	{"ZWR", 3, 40560},
	{"QUEA", 4, 40561},
	{"UNICODE", 7, 40562},
	{"OPPOSING", 8, 40563},
	{"PROD", 4, 40564},
	{"OCOV", 4, 40565},
	{"NOVICE", 6, 40566},
	{"NLYN", 4, 40567},
	{"LEQU", 4, 40568},
	{"LPEO", 4, 40569},
	{"SPREADSHEET", 11, 40570},
	{"HEWITT", 6, 40571},
	{"GEDL", 4, 40572},
	{"YMET", 4, 40573},
	{"KTOW", 4, 40574},
	{"IGHC", 4, 40575},
	{"CONQ", 4, 40576},
	{"LOWERING", 8, 40577},
	{"DELIGHTFUL", 10, 40578},
	{"NLEF", 4, 40579},
	{"KWAR", 4, 40580},
	{"CRUISING", 8, 40581},
	{"AFIL", 4, 40582},
	{"FURY", 4, 40583},
	{"PERSONALITIES", 13, 40584},
	{"DISCOGRAPHY", 11, 40585},
	{"ECAB", 4, 40586},
	{"ENCODED", 7, 40587},
	{"LSUR", 4, 40588},
	{"ABAM", 4, 40589},
	{"RESEARCHING", 11, 40590},
	{"WORE", 4, 40591},
	{"CHRISTCHURCH", 12, 40592},
	{"LZM", 3, 40593},
	{"RNCA", 4, 40594},
	{"MBEI", 4, 40595},
	{"OFAV", 4, 40596},
	{"PEDIATRICS", 10, 40597},
	{"UNDD", 4, 40598},
	{"FWIL", 4, 40599},
	{"KEAP", 4, 40600},
	{"OSUB", 4, 40601},
	{"TRACES", 6, 40602},
	{"LANW", 4, 40603},
	{"RABBI", 5, 40604},
	{"SUSHI", 5, 40605},
	{"PUFFY", 5, 40606},
	{"WESTON", 6, 40607},
	{"DAFI", 4, 40608},
	{"HEADINGS", 8, 40609},
	{"TKIL", 4, 40610},
	{"CKBA", 4, 40611},
	{"ENTHUSIASTS", 11, 40612},
	{"HOMP", 4, 40613},
	{"SCATTERING", 10, 40614},
	{"RGUA", 4, 40615},
	{"DIDY", 4, 40616},
	{"SECRETARIES", 11, 40617},
	{"ONSITE", 6, 40618},
	{"RUNW", 4, 40619},
	{"MAPQUEST", 8, 40620},
	{"CONTRACTED", 10, 40621},
	{"MGOI", 4, 40622},
	{"DEIG", 4, 40623},
	{"FIGHTS", 6, 40624},
	{"DELETING", 8, 40625},
	{"ECTB", 4, 40626},
	{"CKNE", 4, 40627},
	{"UMIS", 4, 40628},
	{"UNWI", 4, 40629},
	{"WRZ", 3, 40630},
	{"COMPILATIONS", 12, 40631},
	{"RGEB", 4, 40632},
	{"APPEALING", 9, 40633},
	{"LSLI", 4, 40634},
	{"CENC", 4, 40635},
	{"IDLA", 4, 40636},
	{"XCES", 4, 40637},
	{"RTHP", 4, 40638},
	{"SCHOLARLY", 9, 40639},
	{"DEDN", 4, 40640},
	{"FKB", 3, 40641},
	{"DETAILING", 9, 40642},
	{"RWOO", 4, 40643},
	{"STARK", 5, 40644},
	{"LIFESTYLES", 10, 40645},
	{"ROBERTO", 7, 40646},
	{"STRONGEST", 9, 40647},
	{"DCOO", 4, 40648},
	{"ILYD", 4, 40649},
	{"HAMMOND", 7, 40650},
	{"SWIMWEAR", 8, 40651},
	{"PADDED", 6, 40652},
	{"EORC", 4, 40653},
	{"APPLET", 6, 40654},
	{"BYIT", 4, 40655},
	{"PRICETOOL", 9, 40656},
	{"CIRCA", 5, 40657},
	{"ORIM", 4, 40658},
	{"REVISE", 6, 40659},
	{"GOPE", 4, 40660},
	{"CONTRIBUTES", 11, 40661},
	{"DPHO", 4, 40662},
	{"SURROUNDINGS", 12, 40663},
	{"PROFICIENCY", 11, 40664},
	{"DPOP", 4, 40665},
	{"TCUT", 4, 40666},
	{"QUINN", 5, 40667},
	{"URANIUM", 7, 40668},
	{"HONOURS", 7, 40669},
	{"CONSOLIDATE", 11, 40670},
	{"DANIELS", 7, 40671},
	{"BILLIONS", 8, 40672},
	{"YDEA", 4, 40673},
	{"DAEWOO", 6, 40674},
	{"ANTIGEN", 7, 40675},
	{"ORBY", 4, 40676},
	{"ULTRASOUND", 10, 40677},
	{"RROB", 4, 40678},
	{"STAFFORD", 8, 40679},
	{"MGMT", 4, 40680},
	{"RORT", 4, 40681},
	{"PROCEDURAL", 10, 40682},
	{"CKOB", 4, 40683},
	{"LABRADOR", 8, 40684},
	{"AILB", 4, 40685},
	{"NGSD", 4, 40686},
	{"CEMI", 4, 40687},
	{"REFUSAL", 7, 40688},
	{"LIMA", 4, 40689},
	{"SUPPRESSION", 11, 40690},
	{"DALW", 4, 40691},
	{"WEAVER", 6, 40692},
	{"CERN", 4, 40693},
	{"READINESS", 9, 40694},
	{"CTMA", 4, 40695},
	{"BLYS", 4, 40696},
	{"MACROS", 6, 40697},
	{"MAJESTY", 7, 40698},
	{"CKSE", 4, 40699},
	{"FISHERY", 7, 40700},
	{"TERESA", 6, 40701},
	{"DISTRIBUTING", 12, 40702},
	{"ESTIMATING", 10, 40703},
	{"DSBU", 4, 40704},
	{"OUTDATED", 8, 40705},
	{"EPLU", 4, 40706},
	{"AUSSIE", 6, 40707},
	{"ADVISORIES", 10, 40708},
	{"YDEM", 4, 40709},
	{"DUES", 4, 40710},
	{"PEWTER", 6, 40711},
	{"LENDINGTREE", 11, 40712},
	{"BELMONT", 7, 40713},
	{"DISTRESS", 8, 40714},
	{"PUMPKIN", 7, 40715},
	{"NOTABLY", 7, 40716},
	{"INTENDS", 7, 40717},
	{"UVL", 3, 40718},
	{"TREVOR", 6, 40719},
	{"DOLP", 4, 40720},
	{"RATR", 4, 40721},
	{"BYBO", 4, 40722},
	{"LLYK", 4, 40723},
	{"NMAL", 4, 40724},
	{"YLAT", 4, 40725},
	{"GARMENT", 7, 40726},
	{"ACAD", 4, 40727},
	{"BILINGUAL", 9, 40728},
	{"DSAM", 4, 40729},
	{"BARBECUE", 8, 40730},
	{"UDDH", 4, 40731},
	{"LRET", 4, 40732},
	{"LOCALIZATION", 12, 40733},
	{"SUPPLYING", 9, 40734},
	{"SECONDLY", 8, 40735},
	{"ZFL", 3, 40736},
	{"FRJ", 3, 40737},
	{"RAZOR", 5, 40738},
	{"COUGH", 5, 40739},
	{"CEREBRAL", 8, 40740},
	{"EFAU", 4, 40741},
	{"GRANDMA", 7, 40742},
	{"CUSTOMIZATION", 13, 40743},
	{"UWOU", 4, 40744},
	{"GIGS", 4, 40745},
	{"INDEXING", 8, 40746},
	{"LORI", 4, 40747},
	{"OCEANS", 6, 40748},
	{"HEMY", 4, 40749},
	{"DISPLACEMENT", 12, 40750},
	{"CKNA", 4, 40751},
	{"RKSW", 4, 40752},
	{"URWA", 4, 40753},
	{"SPACECRAFT", 10, 40754},
	{"ALRY", 4, 40755},
	{"IVOIRE", 6, 40756},
	{"BACKWARDS", 9, 40757},
	{"ARROWS", 6, 40758},
	{"VOLUNTEERING", 12, 40759},
	{"MONTSERRAT", 10, 40760},
	{"TELECOMMUNICATION", 17, 40761},
	{"TCHB", 4, 40762},
	{"RAQI", 4, 40763},
	{"COATINGS", 8, 40764},
	{"EUREKA", 6, 40765},
	{"CONSTRUCTIVE", 12, 40766},
	{"EWDA", 4, 40767},
	{"BUNDLES", 7, 40768},
	{"PCB", 3, 40769},
	{"RSAD", 4, 40770},
	{"TIBET", 5, 40771},
	{"PREPAREDNESS", 12, 40772},
	{"RLOW", 4, 40773},
	{"RBOU", 4, 40774},
	{"GBAN", 4, 40775},
	{"EELD", 4, 40776},
	{"PRES", 4, 40777},
	{"CETR", 4, 40778},
	{"ISLES", 5, 40779},
	{"STRETCHING", 10, 40780},
	{"OVENS", 5, 40781},
	{"OWNG", 4, 40782},
	{"SYSTEMIC", 8, 40783},
	{"GARRETT", 7, 40784},
	{"RYFE", 4, 40785},
	{"ESTHER", 6, 40786},
	{"PLAYOFFS", 8, 40787},
	{"ABUNDANT", 8, 40788},
	{"DEDUCTIBLE", 10, 40789},
	{"RLYB", 4, 40790},
	{"ADAPTORS", 8, 40791},
	{"PRIESTS", 7, 40792},
	{"COMPARES", 8, 40793},
	{"TYSC", 4, 40794},
	{"FORECASTING", 11, 40795},
	{"ESDR", 4, 40796},
	{"LIDI", 4, 40797},
	{"INSPIRING", 9, 40798},
	{"PREY", 4, 40799},
	{"DEPOSITION", 10, 40800},
	{"DRM", 3, 40801},
	{"LAURIE", 6, 40802},
	{"YWAT", 4, 40803},
	{"IBLI", 4, 40804},
	{"ICKB", 4, 40805},
	{"HEDG", 4, 40806},
	{"ZODIAC", 6, 40807},
	{"DTOJ", 4, 40808},
	{"PAVEMENT", 8, 40809},
	{"MASTERBATION", 12, 40810},
	{"LFIR", 4, 40811},
	{"TUBING", 6, 40812},
	{"KELLER", 6, 40813},
	{"YKIN", 4, 40814},
	{"PEDESTRIAN", 10, 40815},
	{"FENCING", 7, 40816},
	{"BLOOMINGTON", 11, 40817},
	{"ARTERY", 6, 40818},
	{"DZW", 3, 40819},
	{"CONDITIONER", 11, 40820},
	{"YCAP", 4, 40821},
	{"RWEL", 4, 40822},
	{"FEWA", 4, 40823},
	{"PLAINTIFFS", 10, 40824},
	{"INLET", 5, 40825},
	{"LYNA", 4, 40826},
	{"REALISE", 7, 40827},
	{"FLUIDS", 6, 40828},
	{"CONVENIENTLY", 12, 40829},
	{"SBAD", 4, 40830},
	{"LICK", 4, 40831},
	{"VANESSA", 7, 40832},
	{"CKPO", 4, 40833},
	{"STEALTH", 7, 40834},
	{"NUCLEOTIDE", 10, 40835},
	{"BRONX", 5, 40836},
	{"ETFR", 4, 40837},
	{"DEDG", 4, 40838},
	{"YSAF", 4, 40839},
	{"LISTMANIA", 9, 40840},
	{"REPAYMENT", 9, 40841},
	{"RISR", 4, 40842},
	{"MIDDOT", 6, 40843},
	{"ICLA", 4, 40844},
	{"NETGEAR", 7, 40845},
	{"UXV", 3, 40846},
	{"CANOPY", 6, 40847},
	{"GLOSS", 5, 40848},
	{"OUPE", 4, 40849},
	{"AYYO", 4, 40850},
	{"PANDA", 5, 40851},
	{"ERNB", 4, 40852},
	{"HFOU", 4, 40853},
	{"RORG", 4, 40854},
	{"CRC", 3, 40855},
	{"DTRY", 4, 40856},
	{"CHPO", 4, 40857},
	{"SYMBIAN", 7, 40858},
	{"USTU", 4, 40859},
	{"DJOI", 4, 40860},
	{"SFIV", 4, 40861},
	{"YMED", 4, 40862},
	{"RKEL", 4, 40863},
	{"PERTINENT", 9, 40864},
	{"NEYB", 4, 40865},
	{"LIFELONG", 8, 40866},
	{"EMAILED", 7, 40867},
	{"WSER", 4, 40868},
	{"UJR", 3, 40869},
	{"MICD", 4, 40870},
	{"PROMOTER", 8, 40871},
	{"COLLEGIATE", 10, 40872},
	{"CONSTANTS", 9, 40873},
	{"CONSTRUED", 9, 40874},
	{"INTERCHANGE", 11, 40875},
	{"REMOTELY", 8, 40876},
	{"MPOU", 4, 40877},
	{"FLETCHER", 8, 40878},
	{"CONCISE", 7, 40879},
	{"CKAS", 4, 40880},
	{"ICAW", 4, 40881},
	{"ISUZU", 5, 40882},
	{"FIBERS", 6, 40883},
	{"UBBL", 4, 40884},
	{"NEDL", 4, 40885},
	{"BRAINS", 6, 40886},
	{"CURTAINS", 8, 40887},
	{"INDIGO", 6, 40888},
	{"RETAINING", 9, 40889},
	{"GWAY", 4, 40890},
	{"KELLEY", 6, 40891},
	{"RLYR", 4, 40892},
	{"CHDA", 4, 40893},
	{"AUTOBIOGRAPHY", 13, 40894},
	{"IDIC", 4, 40895},
	{"LBRI", 4, 40896},
	{"CONDITIONED", 11, 40897},
	{"EEDL", 4, 40898},
	{"WEBRING", 7, 40899},
	{"MICI", 4, 40900},
	{"PROHIBITION", 11, 40901},
	{"MBRO", 4, 40902},
	{"IDOR", 4, 40903},
	{"ICHG", 4, 40904},
	{"MOTIONS", 7, 40905},
	{"RULI", 4, 40906},
	{"KEDL", 4, 40907},
	{"REDIRECT", 8, 40908},
	{"INTEROPERABILITY", 16, 40909},
	{"BADL", 4, 40910},
	{"URHE", 4, 40911},
	{"BEPL", 4, 40912},
	{"UTAG", 4, 40913},
	{"MPBE", 4, 40914},
	{"EGAC", 4, 40915},
	{"MSRP", 4, 40916},
	{"TUVALU", 6, 40917},
	{"SHAMPOO", 7, 40918},
	{"EXCITE", 6, 40919},
	{"YBAR", 4, 40920},
	{"REBELS", 6, 40921},
	{"RKCO", 4, 40922},
	{"NEOPLASMS", 9, 40923},
	{"LDSC", 4, 40924},
	{"RACU", 4, 40925},
	{"ARTIFACTS", 9, 40926},
	{"MECL", 4, 40927},
	{"BELIEVING", 9, 40928},
	{"HILARIOUS", 9, 40929},
	{"YDNE", 4, 40930},
	{"SALISBURY", 9, 40931},
	{"PSEUDO", 6, 40932},
	{"EEDM", 4, 40933},
	{"DDET", 4, 40934},
	{"DDIV", 4, 40935},
	{"QUOTING", 7, 40936},
	{"SINKS", 5, 40937},
	{"EOFK", 4, 40938},
	{"DINAR", 5, 40939},
	{"LBEO", 4, 40940},
	{"DYNASTY", 7, 40941},
	{"ICMO", 4, 40942},
	{"CREED", 5, 40943},
	{"CARAT", 5, 40944},
	{"MICROPHONES", 11, 40945},
	{"TCRO", 4, 40946},
	{"NEDG", 4, 40947},
	{"AFLO", 4, 40948},
	{"NOBEL", 5, 40949},
	{"RAIDERS", 7, 40950},
	{"GALAXIES", 8, 40951},
	{"SPREADS", 7, 40952},
	{"VERLAG", 6, 40953},
	{"FFZ", 3, 40954},
	{"ELEGANCE", 8, 40955},
	{"VOLATILE", 8, 40956},
	{"GCOL", 4, 40957},
	{"POINTERS", 8, 40958},
	{"FUNI", 4, 40959},
	{"SENSORY", 7, 40960},
	{"NKEY", 4, 40961},
	{"RDIR", 4, 40962},
	{"OREQ", 4, 40963},
	{"ADWH", 4, 40964},
	{"SCRAPBOOK", 9, 40965},
	{"WCAN", 4, 40966},
	{"DJOB", 4, 40967},
	{"DUMMIES", 7, 40968},
	{"THMY", 4, 40969},
	{"ZZLE", 4, 40970},
	{"LONL", 4, 40971},
	{"THRONE", 6, 40972},
	{"MEGR", 4, 40973},
	{"BUTU", 4, 40974},
	{"ISWR", 4, 40975},
	{"ERNF", 4, 40976},
	{"UELE", 4, 40977},
	{"MAGNESIUM", 9, 40978},
	{"PAGINA", 6, 40979},
	{"CHARTERED", 9, 40980},
	{"TLEP", 4, 40981},
	{"ELGI", 4, 40982},
	{"SLOPES", 6, 40983},
	{"RTLI", 4, 40984},
	{"ONDM", 4, 40985},
	{"IBAL", 4, 40986},
	{"ULLP", 4, 40987},
	{"OFDU", 4, 40988},
	{"UNFORTUNATE", 11, 40989},
	{"USMO", 4, 40990},
	{"SEIZED", 6, 40991},
	{"DITF", 4, 40992},
	{"YGOI", 4, 40993},
	{"RKAS", 4, 40994},
	{"NBIL", 4, 40995},
	{"UNFA", 4, 40996},
	{"UECO", 4, 40997},
	{"ROUNDUP", 7, 40998},
	{"TERRITORIAL", 11, 40999},
	{"LEASES", 6, 41000},
	{"IMAC", 4, 41001},
	{"CONSISTED", 9, 41002},
	{"RANDOLPH", 8, 41003},
	{"FAXES", 5, 41004},
	{"PLUMP", 5, 41005},
	{"IGNC", 4, 41006},
	{"MEMOIRS", 7, 41007},
	{"VENY", 4, 41008},
	{"UTHB", 4, 41009},
	{"UIRI", 4, 41010},
	{"ALKALINE", 8, 41011},
	{"NUOU", 4, 41012},
	{"EXPIRE", 6, 41013},
	{"WWII", 4, 41014},
	{"OMBU", 4, 41015},
	{"METHYL", 6, 41016},
	{"CAMPUSES", 8, 41017},
	{"WDOW", 4, 41018},
	{"FSCH", 4, 41019},
	{"RLET", 4, 41020},
	{"OPUB", 4, 41021},
	{"DIFY", 4, 41022},
	{"BORNE", 5, 41023},
	{"RAMADA", 6, 41024},
	{"MUQ", 3, 41025},
	{"LTOB", 4, 41026},
	{"MANSFIELD", 9, 41027},
	{"NEIGHBOURS", 10, 41028},
	{"BYWA", 4, 41029},
	{"TESCO", 5, 41030},
	{"MARVIN", 6, 41031},
	{"AGOW", 4, 41032},
	{"UPHE", 4, 41033},
	{"ULDY", 4, 41034},
	{"BEAF", 4, 41035},
	{"ERSV", 4, 41036},
	{"STCR", 4, 41037},
	{"ARCHITECTURES", 13, 41038},
	{"CONVERSIONS", 11, 41039},
	{"YBLA", 4, 41040},
	{"ACDBLINE", 8, 41041},
	{"ROWL", 4, 41042},
	{"HIDD", 4, 41043},
	{"USABLE", 6, 41044},
	{"TEMPO", 5, 41045},
	{"GETTY", 5, 41046},
	{"WMON", 4, 41047},
	{"TLEY", 4, 41048},
	{"MUTATIONS", 9, 41049},
	{"OLCO", 4, 41050},
	{"CDR", 3, 41051},
	{"READABLE", 8, 41052},
	{"KTIM", 4, 41053},
	{"ALMANAC", 7, 41054},
	{"CONWAY", 6, 41055},
	{"GAIL", 4, 41056},
	{"SEGR", 4, 41057},
	{"RESPONDS", 8, 41058},
	{"DENOTE", 6, 41059},
	{"GGRA", 4, 41060},
	{"SLAYER", 6, 41061},
	{"ALSM", 4, 41062},
	{"PAYNE", 5, 41063},
	{"HOWF", 4, 41064},
	{"PROG", 4, 41065},
	{"YBJ", 3, 41066},
	{"THCL", 4, 41067},
	{"FIREWALLS", 9, 41068},
	{"LDOU", 4, 41069},
	{"TESTER", 6, 41070},
	{"POLLING", 7, 41071},
	{"FIFA", 4, 41072},
	{"PURCHASER", 9, 41073},
	{"RTSB", 4, 41074},
	{"IMIZ", 4, 41075},
	{"RELIES", 6, 41076},
	{"INSERTING", 9, 41077},
	{"TIBETAN", 7, 41078},
	{"PREPARES", 8, 41079},
	{"CONCLUDES", 9, 41080},
	{"IRER", 4, 41081},
	{"ISDU", 4, 41082},
	{"CONSUMABLES", 11, 41083},
	{"WATERFORD", 9, 41084},
	{"YFOO", 4, 41085},
	{"TGER", 4, 41086},
	{"RODNEY", 6, 41087},
	{"CYLINDERS", 9, 41088},
	{"UPWA", 4, 41089},
	{"SELECTS", 7, 41090},
	{"BYME", 4, 41091},
	{"BLEG", 4, 41092},
	{"YINB", 4, 41093},
	{"FULTON", 6, 41094},
	{"DIRECTING", 9, 41095},
	{"NATIONALITY", 11, 41096},
	{"LSCI", 4, 41097},
	{"LYRO", 4, 41098},
	{"XYD", 3, 41099},
	{"HIGHBEAM", 8, 41100},
	{"MSDN", 4, 41101},
	{"STATISTICALLY", 13, 41102},
	{"TORCH", 5, 41103},
	{"ZURICH", 6, 41104},
	{"ODRO", 4, 41105},
	{"STRETCHED", 9, 41106},
	{"YJOH", 4, 41107},
	{"RDLI", 4, 41108},
	{"LEYE", 4, 41109},
	{"ENCOUNTERS", 10, 41110},
	{"KEDM", 4, 41111},
	{"HAUNTED", 7, 41112},
	{"SPARES", 6, 41113},
	{"ASFU", 4, 41114},
	{"EBYS", 4, 41115},
	{"SYMMETRY", 8, 41116},
	{"BOUT", 4, 41117},
	{"ADVERTS", 7, 41118},
	{"YSUB", 4, 41119},
	{"YKG", 3, 41120},
	{"UNBE", 4, 41121},
	{"LTWI", 4, 41122},
	{"AWSU", 4, 41123},
	{"IRSU", 4, 41124},
	{"ORTY", 4, 41125},
	{"PROGRAMMED", 10, 41126},
	{"RROG", 4, 41127},
	{"LOHAN", 5, 41128},
	{"SALONS", 6, 41129},
	{"ROFN", 4, 41130},
	{"LDSP", 4, 41131},
	{"OLYMPIA", 7, 41132},
	{"UGJ", 3, 41133},
	{"REBI", 4, 41134},
	{"NEGLIGENCE", 10, 41135},
	{"UNCLEAR", 7, 41136},
	{"SCREENED", 8, 41137},
	{"HELPER", 6, 41138},
	{"CARLISLE", 8, 41139},
	{"AROMATHERAPY", 12, 41140},
	{"RANCHO", 6, 41141},
	{"TRANSFERRING", 12, 41142},
	{"NEDERLAND", 9, 41143},
	{"STOCKTON", 8, 41144},
	{"CEPO", 4, 41145},
	{"STEPPING", 8, 41146},
	{"LYOV", 4, 41147},
	{"ICWO", 4, 41148},
	{"HACKS", 5, 41149},
	{"CLEARWATER", 10, 41150},
	{"SEBY", 4, 41151},
	{"ATTIC", 5, 41152},
	{"TRUSTPASS", 9, 41153},
	{"TOPOLOGY", 8, 41154},
	{"APPETITE", 8, 41155},
	{"LTAL", 4, 41156},
	{"PIPER", 5, 41157},
	{"AIRBORNE", 8, 41158},
	{"MORALITY", 8, 41159},
	{"HONORABLE", 9, 41160},
	{"NOWR", 4, 41161},
	{"HANDICAP", 8, 41162},
	{"SKINNY", 6, 41163},
	{"SEWAGE", 6, 41164},
	{"ENDOWMENT", 9, 41165},
	{"DEMONSTRATING", 13, 41166},
	{"IMGO", 4, 41167},
	{"ANTENNAS", 8, 41168},
	{"SALB", 4, 41169},
	{"SUNDANCE", 8, 41170},
	{"LIFECYCLE", 9, 41171},
	{"DHCP", 4, 41172},
	{"ERND", 4, 41173},
	{"AVEC", 4, 41174},
	{"TRUCKING", 8, 41175},
	{"AMSP", 4, 41176},
	{"YFIL", 4, 41177},
	{"SONOMA", 6, 41178},
	{"CALN", 4, 41179},
	{"CKSF", 4, 41180},
	{"YMOS", 4, 41181},
	{"MEYO", 4, 41182},
	{"DRAL", 4, 41183},
	{"IRAQIS", 6, 41184},
	{"LLFE", 4, 41185},
	{"SHORTCUT", 8, 41186},
	{"EFTW", 4, 41187},
	{"SLYT", 4, 41188},
	{"GSEV", 4, 41189},
	{"DYET", 4, 41190},
	{"DDAV", 4, 41191},
	{"WRETCH", 6, 41192},
	{"STEMS", 5, 41193},
	{"RACIST", 6, 41194},
	{"PROFITABILITY", 13, 41195},
	{"FAIRMONT", 8, 41196},
	{"VENTURA", 7, 41197},
	{"RDUN", 4, 41198},
	{"DEUP", 4, 41199},
	{"DSMI", 4, 41200},
	{"SEGU", 4, 41201},
	{"DZY", 3, 41202},
	{"DUU", 3, 41203},
	{"EVERGREEN", 9, 41204},
	{"CKIE", 4, 41205},
	{"GLOBALLY", 8, 41206},
	{"OPEW", 4, 41207},
	{"BEARINGS", 8, 41208},
	{"FOND", 4, 41209},
	{"EUTR", 4, 41210},
	{"DFY", 3, 41211},
	{"AALIYAH", 7, 41212},
	{"ODPR", 4, 41213},
	{"REBOOT", 6, 41214},
	{"HEDC", 4, 41215},
	{"NEWSGROUP", 9, 41216},
	{"DABU", 4, 41217},
	{"WSUI", 4, 41218},
	{"RRYO", 4, 41219},
	{"BLINDS", 6, 41220},
	{"SYDN", 4, 41221},
	{"AUDIOVOX", 8, 41222},
	{"TRAITS", 6, 41223},
	{"GRADED", 6, 41224},
	{"LCAP", 4, 41225},
	{"PHUKET", 6, 41226},
	{"SUCCESSOR", 9, 41227},
	{"LONY", 4, 41228},
	{"INTRUSION", 9, 41229},
	{"KSBE", 4, 41230},
	{"LECU", 4, 41231},
	{"SICKNESS", 8, 41232},
	{"WDV", 3, 41233},
	{"MSUN", 4, 41234},
	{"ALLK", 4, 41235},
	{"ENGU", 4, 41236},
	{"BEPU", 4, 41237},
	{"GUIANA", 6, 41238},
	{"UNDERNEATH", 10, 41239},
	{"UTAP", 4, 41240},
	{"IRDR", 4, 41241},
	{"METABOLIC", 9, 41242},
	{"ALGU", 4, 41243},
	{"ABUSED", 6, 41244},
	{"RYFA", 4, 41245},
	{"OADV", 4, 41246},
	{"SARASOTA", 8, 41247},
	{"BILLED", 6, 41248},
	{"AVERY", 5, 41249},
	{"MYMO", 4, 41250},
	{"TCLI", 4, 41251},
	{"FARF", 4, 41252},
	{"DANIELLE", 8, 41253},
	{"BRUSHES", 7, 41254},
	{"ANTHOLOGY", 9, 41255},
	{"BLJ", 3, 41256},
	{"SMILES", 6, 41257},
	{"MERGED", 6, 41258},
	{"AUDITORS", 8, 41259},
	{"GRANDCHILDREN", 13, 41260},
	{"DESKS", 5, 41261},
	{"CAPSULE", 7, 41262},
	{"AIDED", 5, 41263},
	{"RELIED", 6, 41264},
	{"RDBA", 4, 41265},
	{"ORVE", 4, 41266},
	{"KNAM", 4, 41267},
	{"YORS", 4, 41268},
	{"AMPO", 4, 41269},
	{"EFTB", 4, 41270},
	{"OKPL", 4, 41271},
	{"ETERNITY", 8, 41272},
	{"MESOTHELIOMA", 12, 41273},
	{"TRAFFICKING", 11, 41274},
	{"HMAD", 4, 41275},
	{"INTRODUCTIONS", 13, 41276},
	{"ASKF", 4, 41277},
	{"RDOE", 4, 41278},
	{"ANMU", 4, 41279},
	{"KEWH", 4, 41280},
	{"WEIGHING", 8, 41281},
	{"CURRENTS", 8, 41282},
	{"FMED", 4, 41283},
	{"BIZJOURNALS", 11, 41284},
	{"MICHELE", 7, 41285},
	{"AYBY", 4, 41286},
	{"TDIV", 4, 41287},
	{"GWHO", 4, 41288},
	{"MBAC", 4, 41289},
	{"KINDLY", 6, 41290},
	{"CUTIE", 5, 41291},
	{"FIXI", 4, 41292},
	{"LEPI", 4, 41293},
	{"FOFF", 4, 41294},
	{"BYTO", 4, 41295},
	{"RDET", 4, 41296},
	{"PROTESTS", 8, 41297},
	{"UTOB", 4, 41298},
	{"NCYS", 4, 41299},
	{"SLYI", 4, 41300},
	{"SHARKS", 6, 41301},
	{"NOTCH", 5, 41302},
	{"MINORS", 6, 41303},
	{"EDVA", 4, 41304},
	{"KUPT", 4, 41305},
	{"DANCES", 6, 41306},
	{"BYWH", 4, 41307},
	{"LUED", 4, 41308},
	{"REVEALING", 9, 41309},
	{"DATM", 4, 41310},
	{"FGAM", 4, 41311},
	{"REPRINTED", 9, 41312},
	{"FERNANDO", 8, 41313},
	{"MAPPED", 6, 41314},
	{"SORW", 4, 41315},
	{"IERW", 4, 41316},
	{"RESURRECTION", 12, 41317},
	{"LIEU", 4, 41318},
	{"DECREE", 6, 41319},
	{"YUNT", 4, 41320},
	{"TSQU", 4, 41321},
	{"UTUN", 4, 41322},
	{"ICKC", 4, 41323},
	{"ADTW", 4, 41324},
	{"SEOUL", 5, 41325},
	{"PRINTF", 6, 41326},
	{"DISCOVERING", 11, 41327},
	{"TUBERCULOSIS", 12, 41328},
	{"LACKS", 5, 41329},
	{"RLOT", 4, 41330},
	{"OWMO", 4, 41331},
	{"HORIZONS", 8, 41332},
	{"TRANSPLANTATION", 15, 41333},
	{"JEROME", 6, 41334},
	{"DAYTIME", 7, 41335},
	{"MAYC", 4, 41336},
	{"CONTOUR", 7, 41337},
	{"GAMBLE", 6, 41338},
	{"DESCENT", 7, 41339},
	{"FITF", 4, 41340},
	{"GRAVEL", 6, 41341},
	{"ANALYSE", 7, 41342},
	{"ALTW", 4, 41343},
	{"RBEN", 4, 41344},
	{"RAMMSTEIN", 9, 41345},
	{"RPHI", 4, 41346},
	{"JUDGED", 6, 41347},
	{"SHUTTER", 7, 41348},
	{"EDNU", 4, 41349},
	{"LYAV", 4, 41350},
	{"RIFY", 4, 41351},
	{"LWER", 4, 41352},
	{"EALF", 4, 41353},
	{"UMNI", 4, 41354},
	{"SCRAPBOOKING", 12, 41355},
	{"NOTORIOUS", 9, 41356},
	{"IBID", 4, 41357},
	{"RESIDUE", 7, 41358},
	{"REDS", 4, 41359},
	{"ENLARGED", 8, 41360},
	{"DFLA", 4, 41361},
	{"STEPHENS", 8, 41362},
	{"TRANSFORMING", 12, 41363},
	{"SEQUENTIAL", 10, 41364},
	{"RVIL", 4, 41365},
	{"ITJU", 4, 41366},
	{"STRIPPING", 9, 41367},
	{"YKP", 3, 41368},
	{"UNIQUELY", 8, 41369},
	{"DWOO", 4, 41370},
	{"BART", 4, 41371},
	{"GOODIES", 7, 41372},
	{"EOBJ", 4, 41373},
	{"FLUCTUATIONS", 12, 41374},
	{"BOWIE", 5, 41375},
	{"ARCHAEOLOGICAL", 14, 41376},
	{"EPUP", 4, 41377},
	{"OMCH", 4, 41378},
	{"SRUL", 4, 41379},
	{"ERNW", 4, 41380},
	{"NRIV", 4, 41381},
	{"INSPECT", 7, 41382},
	{"THRICE", 6, 41383},
	{"BABYLON", 7, 41384},
	{"SUGABABES", 9, 41385},
	{"EDISON", 6, 41386},
	{"UEDI", 4, 41387},
	{"SOPL", 4, 41388},
	{"OUMI", 4, 41389},
	{"HYOF", 4, 41390},
	{"RCW", 3, 41391},
	{"MUSINGS", 7, 41392},
	{"HEDM", 4, 41393},
	{"KOFC", 4, 41394},
	{"ALQU", 4, 41395},
	{"IDAB", 4, 41396},
	{"NLEG", 4, 41397},
	{"WHISTLER", 8, 41398},
	{"ERSJ", 4, 41399},
	{"ALNU", 4, 41400},
	{"POSES", 5, 41401},
	{"AIRFARES", 8, 41402},
	{"OMBS", 4, 41403},
	{"LDMO", 4, 41404},
	{"HUNTSVILLE", 10, 41405},
	{"RARM", 4, 41406},
	{"MERH", 4, 41407},
	{"WKF", 3, 41408},
	{"OLCA", 4, 41409},
	{"LAYOUTS", 7, 41410},
	{"SERVICEMAGIC", 12, 41411},
	{"DESIGNATE", 9, 41412},
	{"AGOL", 4, 41413},
	{"LDFR", 4, 41414},
	{"SEQUEL", 6, 41415},
	{"NEPL", 4, 41416},
	{"GYMNASTICS", 10, 41417},
	{"FSOC", 4, 41418},
	{"TITANIC", 7, 41419},
	{"KNOB", 4, 41420},
	{"GKON", 4, 41421},
	{"UALE", 4, 41422},
	{"TFAR", 4, 41423},
	{"WOLVES", 6, 41424},
	{"EXQUISITE", 9, 41425},
	{"GINP", 4, 41426},
	{"HERPES", 6, 41427},
	{"UPWARD", 6, 41428},
	{"SENTENCED", 9, 41429},
	{"DUNDEE", 6, 41430},
	{"NEWSGATOR", 9, 41431},
	{"PRINCIPE", 8, 41432},
	{"CONTRACTUAL", 11, 41433},
	{"ULSE", 4, 41434},
	{"ACQUIRING", 9, 41435},
	{"JUDGING", 7, 41436},
	{"UNCHANGED", 9, 41437},
	{"KICKING", 7, 41438},
	{"YCW", 3, 41439},
	{"LFQ", 3, 41440},
	{"YLEO", 4, 41441},
	{"CHFI", 4, 41442},
	{"AKRON", 5, 41443},
	{"FINES", 5, 41444},
	{"MEDM", 4, 41445},
	{"OLEW", 4, 41446},
	{"ODYT", 4, 41447},
	{"KCOU", 4, 41448},
	{"GHED", 4, 41449},
	{"MONC", 4, 41450},
	{"LBRO", 4, 41451},
	{"EMYO", 4, 41452},
	{"OUNCE", 5, 41453},
	{"OCER", 4, 41454},
	{"RYRO", 4, 41455},
	{"DSWO", 4, 41456},
	{"SSPL", 4, 41457},
	{"MCOU", 4, 41458},
	{"THEODORE", 8, 41459},
	{"TEDJ", 4, 41460},
	{"NGVA", 4, 41461},
	{"BUENA", 5, 41462},
	{"IRRELEVANT", 10, 41463},
	{"URON", 4, 41464},
	{"PROFESSIONALLY", 14, 41465},
	{"LIBERTIES", 9, 41466},
	{"SOUNDING", 8, 41467},
	{"LISB", 4, 41468},
	{"YDER", 4, 41469},
	{"REBOUNDS", 8, 41470},
	{"MILANO", 6, 41471},
	{"URLO", 4, 41472},
	{"COMPRESSOR", 10, 41473},
	{"LEAB", 4, 41474},
	{"HOOKED", 6, 41475},
	{"SAMANTHA", 8, 41476},
	{"NICL", 4, 41477},
	{"FFED", 4, 41478},
	{"KNOX", 4, 41479},
	{"WEBMAIL", 7, 41480},
	{"UPBY", 4, 41481},
	{"CARCINOMA", 9, 41482},
	{"TAIPEI", 6, 41483},
	{"UNESCO", 6, 41484},
	{"MUTUALLY", 8, 41485},
	{"RWAN", 4, 41486},
	{"MSOM", 4, 41487},
	{"NGGI", 4, 41488},
	{"OUTK", 4, 41489},
	{"NBEU", 4, 41490},
	{"OOKM", 4, 41491},
	{"KUMAR", 5, 41492},
	{"BEADED", 6, 41493},
	{"REMEMBERING", 11, 41494},
	{"BOCA", 4, 41495},
	{"CKCA", 4, 41496},
	{"PLEE", 4, 41497},
	{"ARIV", 4, 41498},
	{"EXODUS", 6, 41499},
	{"COMPARTMENT", 11, 41500},
	{"GEMINI", 6, 41501},
	{"OWPR", 4, 41502},
	{"BRITTANY", 8, 41503},
	{"DOVE", 4, 41504},
	{"TESTIFIED", 9, 41505},
	{"ORPI", 4, 41506},
	{"CUNNINGHAM", 10, 41507},
	{"RSME", 4, 41508},
	{"AFFINITY", 8, 41509},
	{"PRESBYTERIAN", 12, 41510},
	{"SUPERVISORY", 11, 41511},
	{"ALOV", 4, 41512},
	{"BYAT", 4, 41513},
	{"ORMW", 4, 41514},
	{"BYJO", 4, 41515},
	{"DLAB", 4, 41516},
	{"FOVE", 4, 41517},
	{"BYFA", 4, 41518},
	{"GAPR", 4, 41519},
	{"INDB", 4, 41520},
	{"HFLO", 4, 41521},
	{"BUDDHISM", 8, 41522},
	{"YDIV", 4, 41523},
	{"AMNESTY", 7, 41524},
	{"CHIROPRACTIC", 12, 41525},
	{"BORROWER", 8, 41526},
	{"RPLE", 4, 41527},
	{"MREA", 4, 41528},
	{"LFWA", 4, 41529},
	{"GLOUCESTER", 10, 41530},
	{"IFEB", 4, 41531},
	{"MBUR", 4, 41532},
	{"ICYC", 4, 41533},
	{"UPBE", 4, 41534},
	{"EAMU", 4, 41535},
	{"WARRANTS", 8, 41536},
	{"NWHY", 4, 41537},
	{"OWENS", 5, 41538},
	{"LYGA", 4, 41539},
	{"FAIRNESS", 8, 41540},
	{"NEEDLES", 7, 41541},
	{"COLL", 4, 41542},
	{"NHUM", 4, 41543},
	{"THROUGHPUT", 10, 41544},
	{"QUOTA", 5, 41545},
	{"UTAD", 4, 41546},
	{"NETBSD", 6, 41547},
	{"MERF", 4, 41548},
	{"ELDF", 4, 41549},
	{"DISCREET", 8, 41550},
	{"MISPLACE", 8, 41551},
	{"VERSA", 5, 41552},
	{"USTY", 4, 41553},
	{"GFRE", 4, 41554},
	{"ELRE", 4, 41555},
	{"SERVICED", 8, 41556},
	{"RCHC", 4, 41557},
	{"MACK", 4, 41558},
	{"LEYI", 4, 41559},
	{"LLAF", 4, 41560},
	{"SUNG", 4, 41561},
	{"MMET", 4, 41562},
	{"LVEM", 4, 41563},
	{"NDKN", 4, 41564},
	{"UMON", 4, 41565},
	{"LOWELL", 6, 41566},
	{"WHICHEVER", 9, 41567},
	{"STARR", 5, 41568},
	{"KETP", 4, 41569},
	{"ELLIOT", 6, 41570},
	{"LMOV", 4, 41571},
	{"OPENER", 6, 41572},
	{"BYAD", 4, 41573},
	{"ESYM", 4, 41574},
	{"VACCINES", 8, 41575},
	{"CHOOSES", 7, 41576},
	{"TUSCANY", 7, 41577},
	{"WHYW", 4, 41578},
	{"JIGSAW", 6, 41579},
	{"JUMBO", 5, 41580},
	{"TICKLING", 8, 41581},
	{"ULEA", 4, 41582},
	{"UNSPECIFIED", 11, 41583},
	{"TLYU", 4, 41584},
	{"URYI", 4, 41585},
	{"FWES", 4, 41586},
	{"GHEL", 4, 41587},
	{"TURBINE", 7, 41588},
	{"UNREAL", 6, 41589},
	{"WOUNDS", 6, 41590},
	{"UMAY", 4, 41591},
	{"PERCENTAGES", 11, 41592},
	{"ADVISERS", 8, 41593},
	{"MMEM", 4, 41594},
	{"MANUFACTURES", 12, 41595},
	{"OLLU", 4, 41596},
	{"AMRE", 4, 41597},
	{"PHYSIOLOGICAL", 13, 41598},
	{"SOFY", 4, 41599},
	{"LOWB", 4, 41600},
	{"UMBA", 4, 41601},
	{"MATHS", 5, 41602},
	{"ADDISON", 7, 41603},
	{"DPAI", 4, 41604},
	{"CHARTERS", 8, 41605},
	{"GENERALIZED", 11, 41606},
	{"PROBES", 6, 41607},
	{"RLIS", 4, 41608},
	{"FLINT", 5, 41609},
	{"DUMMY", 5, 41610},
	{"FINANCIALLY", 11, 41611},
	{"SANITATION", 10, 41612},
	{"TSCU", 4, 41613},
	{"FHAR", 4, 41614},
	{"OOMF", 4, 41615},
	{"AMERICANA", 9, 41616},
	{"SWIVEL", 6, 41617},
	{"RGUI", 4, 41618},
	{"CILO", 4, 41619},
	{"DISSOLVED", 9, 41620},
	{"TYAL", 4, 41621},
	{"OKLI", 4, 41622},
	{"CLEANLINESS", 11, 41623},
	{"COMPLEXES", 9, 41624},
	{"YVOT", 4, 41625},
	{"IRWO", 4, 41626},
	{"KUNG", 4, 41627},
	{"VARSITY", 7, 41628},
	{"YORG", 4, 41629},
	{"COLLECTIVELY", 12, 41630},
	{"INSURER", 7, 41631},
	{"FDEF", 4, 41632},
	{"CROATIAN", 8, 41633},
	{"GFOU", 4, 41634},
	{"CIND", 4, 41635},
	{"KPAR", 4, 41636},
	{"IDAD", 4, 41637},
	{"INHIBITION", 10, 41638},
	{"THMU", 4, 41639},
	{"IPUL", 4, 41640},
	{"MULTICAST", 9, 41641},
	{"CERTIFICATIONS", 14, 41642},
	{"TFEL", 4, 41643},
	{"BURNT", 5, 41644},
	{"SOLIDARITY", 10, 41645},
	{"FRUSTRATED", 10, 41646},
	{"MUHAMMAD", 8, 41647},
	{"ALMA", 4, 41648},
	{"ARQU", 4, 41649},
	{"YRIA", 4, 41650},
	{"PRADESH", 7, 41651},
	{"HANOVER", 7, 41652},
	{"INVERSE", 7, 41653},
	{"CLIFTON", 7, 41654},
	{"BYBE", 4, 41655},
	{"LDEP", 4, 41656},
	{"LCRE", 4, 41657},
	{"OFKE", 4, 41658},
	{"MEDALS", 6, 41659},
	{"PROTON", 6, 41660},
	{"DICKINSON", 9, 41661},
	{"CHRISTI", 7, 41662},
	{"YBRE", 4, 41663},
	{"LISTER", 6, 41664},
	{"TYMU", 4, 41665},
	{"RECURRING", 9, 41666},
	{"RDPR", 4, 41667},
	{"STUDS", 5, 41668},
	{"NYCH", 4, 41669},
	{"RYIT", 4, 41670},
	{"MODIFYING", 9, 41671},
	{"INCUBUS", 7, 41672},
	{"TDRA", 4, 41673},
	{"KAPLAN", 6, 41674},
	{"YMOD", 4, 41675},
	{"SURVEYED", 8, 41676},
	{"EBAB", 4, 41677},
	{"CREDITORS", 9, 41678},
	{"DULL", 4, 41679},
	{"OFVO", 4, 41680},
	{"BSCR", 4, 41681},
	{"AUND", 4, 41682},
	{"NYFO", 4, 41683},
	{"GBEF", 4, 41684},
	{"CABINS", 6, 41685},
	{"CHYO", 4, 41686},
	{"COMMENCED", 9, 41687},
	{"BALLROOM", 8, 41688},
	{"EMPLOYING", 9, 41689},
	{"SATELLITES", 10, 41690},
	{"DYZ", 3, 41691},
	{"IGNORING", 8, 41692},
	{"ERIL", 4, 41693},
	{"LINENS", 6, 41694},
	{"STEVENSON", 9, 41695},
	{"COHERENT", 8, 41696},
	{"BEETLE", 6, 41697},
	{"CONVERTS", 8, 41698},
	{"GHMA", 4, 41699},
	{"MAJESTIC", 8, 41700},
	{"YBAN", 4, 41701},
	{"TAPL", 4, 41702},
	{"BICYCLES", 8, 41703},
	{"ICTW", 4, 41704},
	{"ROAST", 5, 41705},
	{"TESTERS", 7, 41706},
	{"ADTR", 4, 41707},
	{"TRYH", 4, 41708},
	{"DQUE", 4, 41709},
	{"DEBUGINFO", 9, 41710},
	{"COMPLAINANT", 11, 41711},
	{"CTSF", 4, 41712},
	{"INHIBITOR", 9, 41713},
	{"CLIFFORD", 8, 41714},
	{"NDSR", 4, 41715},
	{"DTYP", 4, 41716},
	{"NPUR", 4, 41717},
	{"KNOWLEDGEABLE", 13, 41718},
	{"CRITICALLY", 10, 41719},
	{"IGHR", 4, 41720},
	{"EKEP", 4, 41721},
	{"COMPOSERS", 9, 41722},
	{"LOCALITIES", 10, 41723},
	{"PLEG", 4, 41724},
	{"RUMM", 4, 41725},
	{"YFIV", 4, 41726},
	{"JIMI", 4, 41727},
	{"NFAR", 4, 41728},
	{"HUMMER", 6, 41729},
	{"RECIPROCAL", 10, 41730},
	{"YTER", 4, 41731},
	{"ROMK", 4, 41732},
	{"DYIS", 4, 41733},
	{"RLEG", 4, 41734},
	{"EDYA", 4, 41735},
	{"HATRED", 6, 41736},
	{"CEDM", 4, 41737},
	{"QUESTIONING", 11, 41738},
	{"YAVA", 4, 41739},
	{"PUTATIVE", 8, 41740},
	{"YART", 4, 41741},
	{"MANIFEST", 8, 41742},
	{"INDICATIONS", 11, 41743},
	{"PETTY", 5, 41744},
	{"PERMITTING", 10, 41745},
	{"AROW", 4, 41746},
	{"HYPERLINK", 9, 41747},
	{"PRESARIO", 8, 41748},
	{"MOTORSPORTS", 11, 41749},
	{"GETAWAY", 7, 41750},
	{"RORE", 4, 41751},
	{"WAYP", 4, 41752},
	{"ROBBINS", 7, 41753},
	{"FDES", 4, 41754},
	{"ZEPPELIN", 8, 41755},
	{"FELIX", 5, 41756},
	{"SHINY", 5, 41757},
	{"CARMEL", 6, 41758},
	{"ENCORE", 6, 41759},
	{"SSBU", 4, 41760},
	{"UTEF", 4, 41761},
	{"SMASH", 5, 41762},
	{"TYWE", 4, 41763},
	{"ANGELINA", 8, 41764},
	{"KIMBERLY", 8, 41765},
	{"YJC", 3, 41766},
	{"UNSURE", 6, 41767},
	{"ELDH", 4, 41768},
	{"NGNU", 4, 41769},
	{"BRAUN", 5, 41770},
	{"DESTRUCTIVE", 11, 41771},
	{"GHLA", 4, 41772},
	{"SOCKETS", 7, 41773},
	{"RILT", 4, 41774},
	{"UTBR", 4, 41775},
	{"CLAIMANT", 8, 41776},
	{"DINOSAUR", 8, 41777},
	{"AMPLE", 5, 41778},
	{"COUNTLESS", 9, 41779},
	{"ASHLAND", 7, 41780},
	{"ENERGIES", 8, 41781},
	{"ICUT", 4, 41782},
	{"AFIG", 4, 41783},
	{"DLP", 3, 41784},
	{"REPEALED", 8, 41785},
	{"YINJ", 4, 41786},
	{"ROYCE", 5, 41787},
	{"DFEL", 4, 41788},
	{"LISTENERS", 9, 41789},
	{"ABUSIVE", 7, 41790},
	{"ANTIBIOTICS", 11, 41791},
	{"LANDFILL", 8, 41792},
	{"WAREHOUSING", 11, 41793},
	{"FILESIZE", 8, 41794},
	{"ULER", 4, 41795},
	{"MERITS", 6, 41796},
	{"SCARF", 5, 41797},
	{"STRANGERS", 9, 41798},
	{"IGAR", 4, 41799},
	{"GARLAND", 7, 41800},
	{"SICF", 4, 41801},
	{"VOOR", 4, 41802},
	{"CELEBREX", 8, 41803},
	{"VERISIGN", 8, 41804},
	{"RIVIERA", 7, 41805},
	{"GMIL", 4, 41806},
	{"APPRENTICE", 10, 41807},
	{"TMED", 4, 41808},
	{"OBSCURE", 7, 41809},
	{"NAPOLEON", 8, 41810},
	{"REGISTRATIONS", 13, 41811},
	{"RSPI", 4, 41812},
	{"WAVELENGTH", 10, 41813},
	{"RAPY", 4, 41814},
	{"UTME", 4, 41815},
	{"GLAMOUR", 7, 41816},
	{"LDPA", 4, 41817},
	{"SLASHDOT", 8, 41818},
	{"TRANSVESTITES", 13, 41819},
	{"NYWI", 4, 41820},
	{"HATED", 5, 41821},
	{"CHEERLEADERS", 12, 41822},
	{"SAYW", 4, 41823},
	{"GABR", 4, 41824},
	{"TROLLEY", 7, 41825},
	{"PRINCIPALS", 10, 41826},
	{"PPET", 4, 41827},
	{"HOPL", 4, 41828},
	{"DESB", 4, 41829},
	{"SIDNEY", 6, 41830},
	{"RINB", 4, 41831},
	{"FRIEDMAN", 8, 41832},
	{"RNFO", 4, 41833},
	{"COOLPIX", 7, 41834},
	{"SPICY", 5, 41835},
	{"MMAD", 4, 41836},
	{"HTUP", 4, 41837},
	{"BLOCKER", 7, 41838},
	{"OBBI", 4, 41839},
	{"KSTR", 4, 41840},
	{"TAWNEE", 6, 41841},
	{"CHRONOLOGICAL", 13, 41842},
	{"EDGI", 4, 41843},
	{"ENTREPRENEURSHIP", 16, 41844},
	{"CWOR", 4, 41845},
	{"NLYL", 4, 41846},
	{"CCIN", 4, 41847},
	{"ITINERARY", 9, 41848},
	{"FOOLS", 5, 41849},
	{"UTID", 4, 41850},
	{"RBIG", 4, 41851},
	{"EWMI", 4, 41852},
	{"BYWI", 4, 41853},
	{"DISCOVERIES", 11, 41854},
	{"PERCENTILE", 10, 41855},
	{"FDEC", 4, 41856},
	{"LINKAGE", 7, 41857},
	{"YGOV", 4, 41858},
	{"SFUR", 4, 41859},
	{"ECONOMICAL", 10, 41860},
	{"MINIATURES", 10, 41861},
	{"WNPA", 4, 41862},
	{"WEDGE", 5, 41863},
	{"ADJUSTING", 9, 41864},
	{"GJUS", 4, 41865},
	{"TRYB", 4, 41866},
	{"LLRI", 4, 41867},
	{"MOCK", 4, 41868},
	{"MTOG", 4, 41869},
	{"PEGGY", 5, 41870},
	{"LSAY", 4, 41871},
	{"PATRIOTS", 8, 41872},
	{"RASM", 4, 41873},
	{"RUINS", 5, 41874},
	{"ECAV", 4, 41875},
	{"OGYI", 4, 41876},
	{"SHEILA", 6, 41877},
	{"NGSR", 4, 41878},
	{"LAWM", 4, 41879},
	{"NGEB", 4, 41880},
	{"RIPPER", 6, 41881},
	{"DEPENDENCIES", 12, 41882},
	{"ACCOMODATION", 12, 41883},
	{"SPOU", 4, 41884},
	{"ENDB", 4, 41885},
	{"WEBE", 4, 41886},
	{"TRYF", 4, 41887},
	{"RICC", 4, 41888},
	{"BENTON", 6, 41889},
	{"MCAFEE", 6, 41890},
	{"GLAR", 4, 41891},
	{"CHATEAU", 7, 41892},
	{"DENIS", 5, 41893},
	{"YEFF", 4, 41894},
	{"YCAU", 4, 41895},
	{"COUNSELORS", 10, 41896},
	{"HOMESTEAD", 9, 41897},
	{"ERKA", 4, 41898},
	{"COMPETITIVENESS", 15, 41899},
	{"BURGER", 6, 41900},
	{"MICROSCOPY", 10, 41901},
	{"CHANGER", 7, 41902},
	{"SERGEANT", 8, 41903},
	{"DDRO", 4, 41904},
	{"YPTI", 4, 41905},
	{"RDSM", 4, 41906},
	{"GSUC", 4, 41907},
	{"SYRIAN", 6, 41908},
	{"HYPER", 5, 41909},
	{"YNCH", 4, 41910},
	{"MADTHUMBS", 9, 41911},
	{"LINKIN", 6, 41912},
	{"GMAIL", 5, 41913},
	{"ORYH", 4, 41914},
	{"BERP", 4, 41915},
	{"CYPRESS", 7, 41916},
	{"LTEL", 4, 41917},
	{"COURTNEY", 8, 41918},
	{"CITES", 5, 41919},
	{"EHUR", 4, 41920},
	{"DAFR", 4, 41921},
	{"SCOOTERS", 8, 41922},
	{"RESERVEAMERICA", 14, 41923},
	{"ORGANISATIONAL", 14, 41924},
	{"RPUR", 4, 41925},
	{"PROSPECTUS", 10, 41926},
	{"EZINE", 5, 41927},
	{"RINJ", 4, 41928},
	{"PROTECTORS", 10, 41929},
	{"REACTIVE", 8, 41930},
	{"NTCR", 4, 41931},
	{"LEUS", 4, 41932},
	{"INTERIORS", 9, 41933},
	{"DITB", 4, 41934},
	{"BUNC", 4, 41935},
	{"ENCOURAGEMENT", 13, 41936},
	{"BUYA", 4, 41937},
	{"YKB", 3, 41938},
	{"CLIPBOARD", 9, 41939},
	{"GSAL", 4, 41940},
	{"DISADVANTAGES", 13, 41941},
	{"RKOU", 4, 41942},
	{"LINP", 4, 41943},
	{"RGEM", 4, 41944},
	{"GABL", 4, 41945},
	{"GAMER", 5, 41946},
	{"ALEXA", 5, 41947},
	{"OURV", 4, 41948},
	{"RFUT", 4, 41949},
	{"ABBOTT", 6, 41950},
	{"TAILOR", 6, 41951},
	{"MZU", 3, 41952},
	{"POLLUTANTS", 10, 41953},
	{"NEYC", 4, 41954},
	{"USCR", 4, 41955},
	{"DIRECTORATE", 11, 41956},
	{"CHOCOLATES", 10, 41957},
	{"FAUX", 4, 41958},
	{"SBYS", 4, 41959},
	{"SUPERVISED", 10, 41960},
	{"INTERPRETING", 12, 41961},
	{"LHOM", 4, 41962},
	{"SAVVY", 5, 41963},
	{"PASCAL", 6, 41964},
	{"LASW", 4, 41965},
	{"SERENITY", 8, 41966},
	{"LFEA", 4, 41967},
	{"UPLOADS", 7, 41968},
	{"SHERIDAN", 8, 41969},
	{"OWBU", 4, 41970},
	{"RMSI", 4, 41971},
	{"GALLONS", 7, 41972},
	{"ATTAINMENT", 10, 41973},
	{"MCCO", 4, 41974},
	{"ADYO", 4, 41975},
	{"OOMW", 4, 41976},
	{"SANITARY", 8, 41977},
	{"TERRI", 5, 41978},
	{"EXCU", 4, 41979},
	{"DREAMING", 8, 41980},
	{"TCOV", 4, 41981},
	{"LHIG", 4, 41982},
	{"NORMS", 5, 41983},
	{"IMPLANTS", 8, 41984},
	{"FORTUNATE", 9, 41985},
	{"ALIBABA", 7, 41986},
	{"IRBO", 4, 41987},
	{"MUSHROOMS", 9, 41988},
	{"HORMONES", 8, 41989},
	{"IGNP", 4, 41990},
	{"HYPE", 4, 41991},
	{"INTERPRETATIONS", 15, 41992},
	{"GEOFFREY", 8, 41993},
	{"FAULTS", 6, 41994},
	{"ADDR", 4, 41995},
	{"ADBU", 4, 41996},
	{"SILVA", 5, 41997},
	{"CYQ", 3, 41998},
	{"GREASE", 6, 41999},
	{"IRLF", 4, 42000},
	{"DIABLO", 6, 42001},
	{"URINARY", 7, 42002},
	{"CAIRNS", 6, 42003},
	{"INSTITUT", 8, 42004},
	{"PRIMA", 5, 42005},
	{"NTBR", 4, 42006},
	{"CONDOMS", 7, 42007},
	{"DIRECTIVES", 10, 42008},
	{"CINNAMON", 8, 42009},
	{"IEWW", 4, 42010},
	{"OMBR", 4, 42011},
	{"ZELDA", 5, 42012},
	{"DISCHARGED", 10, 42013},
	{"UTWO", 4, 42014},
	{"ALBA", 4, 42015},
	{"AYSU", 4, 42016},
	{"ALJU", 4, 42017},
	{"UNDERWORLD", 10, 42018},
	{"ACUR", 4, 42019},
	{"VARIANTS", 8, 42020},
	{"FETAL", 5, 42021},
	{"EFEC", 4, 42022},
	{"MEDL", 4, 42023},
	{"PALMS", 5, 42024},
	{"LAWSUITS", 8, 42025},
	{"GWEL", 4, 42026},
	{"SEATED", 6, 42027},
	{"LATTICE", 7, 42028},
	{"NGIF", 4, 42029},
	{"EBUC", 4, 42030},
	{"DONG", 4, 42031},
	{"REALIZATION", 11, 42032},
	{"LYVI", 4, 42033},
	{"RQUI", 4, 42034},
	{"ABSORBED", 8, 42035},
	{"LPUB", 4, 42036},
	{"SIRIUS", 6, 42037},
	{"HYDO", 4, 42038},
	{"DGOL", 4, 42039},
	{"BYSH", 4, 42040},
	{"CHORD", 5, 42041},
	{"TICW", 4, 42042},
	{"POFA", 4, 42043},
	{"KUDOZ", 5, 42044},
	{"LHIM", 4, 42045},
	{"LDUS", 4, 42046},
	{"VOUS", 4, 42047},
	{"TURF", 4, 42048},
	{"LMIL", 4, 42049},
	{"ALEW", 4, 42050},
	{"ASPHALT", 7, 42051},
	{"ICKF", 4, 42052},
	{"REPLAY", 6, 42053},
	{"IMPROPER", 8, 42054},
	{"FLAVORS", 7, 42055},
	{"OUBE", 4, 42056},
	{"RNOU", 4, 42057},
	{"REBUILDING", 10, 42058},
	{"LIVINGSTON", 10, 42059},
	{"QUICKCHECK", 10, 42060},
	{"NELY", 4, 42061},
	{"POSU", 4, 42062},
	{"COMMENTING", 10, 42063},
	{"RMYS", 4, 42064},
	{"FOPE", 4, 42065},
	{"SHIFTED", 7, 42066},
	{"GDEA", 4, 42067},
	{"TANGIBLE", 8, 42068},
	{"SMOKED", 6, 42069},
	{"EUNC", 4, 42070},
	{"HAWKS", 5, 42071},
	{"ULDU", 4, 42072},
	{"ZIFF", 4, 42073},
	{"YSMO", 4, 42074},
	{"NGIR", 4, 42075},
	{"PLACEBO", 7, 42076},
	{"IRONS", 5, 42077},
	{"INDM", 4, 42078},
	{"COMET", 5, 42079},
	{"BERG", 4, 42080},
	{"RYEX", 4, 42081},
	{"BALTIC", 6, 42082},
	{"CORRECTIVE", 10, 42083},
	{"COMPETENCY", 10, 42084},
	{"IRVI", 4, 42085},
	{"CEUN", 4, 42086},
	{"MUSE", 4, 42087},
	{"EAPL", 4, 42088},
	{"PROBING", 7, 42089},
	{"EADP", 4, 42090},
	{"TEACHINGS", 9, 42091},
	{"PEDP", 4, 42092},
	{"LOTTO", 5, 42093},
	{"RDUE", 4, 42094},
	{"UTTW", 4, 42095},
	{"FOWLER", 6, 42096},
	{"TDEL", 4, 42097},
	{"XTWE", 4, 42098},
	{"GMEM", 4, 42099},
	{"YOUNGEST", 8, 42100},
	{"CIPI", 4, 42101},
	{"OGYT", 4, 42102},
	{"CONTINGENT", 10, 42103},
	{"RMYA", 4, 42104},
	{"REFRESHING", 10, 42105},
	{"SOFK", 4, 42106},
	{"LTYO", 4, 42107},
	{"HIMM", 4, 42108},
	{"TEXTURES", 8, 42109},
	{"EULT", 4, 42110},
	{"ZLU", 3, 42111},
	{"SYRUP", 5, 42112},
	{"AWOU", 4, 42113},
	{"HAWKINS", 7, 42114},
	{"LUST", 4, 42115},
	{"CORRELATED", 10, 42116},
	{"ASDU", 4, 42117},
	{"AUGUSTINE", 9, 42118},
	{"DOMINION", 8, 42119},
	{"HREG", 4, 42120},
	{"OCOR", 4, 42121},
	{"YDEN", 4, 42122},
	{"OOMB", 4, 42123},
	{"GSWH", 4, 42124},
	{"VUC", 3, 42125},
	{"NDEB", 4, 42126},
	{"VERSES", 6, 42127},
	{"UMBU", 4, 42128},
	{"TYFR", 4, 42129},
	{"OROP", 4, 42130},
	{"GFIE", 4, 42131},
	{"SEAGATE", 7, 42132},
	{"NANOTECHNOLOGY", 14, 42133},
	{"DCUL", 4, 42134},
	{"ASTRONOMICAL", 12, 42135},
	{"OUDI", 4, 42136},
	{"USAD", 4, 42137},
	{"FCHR", 4, 42138},
	{"SOLVENT", 7, 42139},
	{"TOGGLE", 6, 42140},
	{"LUNA", 4, 42141},
	{"LOWR", 4, 42142},
	{"LLMI", 4, 42143},
	{"CHIV", 4, 42144},
	{"UTIM", 4, 42145},
	{"AMPLITUDE", 9, 42146},
	{"COMMERCIALLY", 12, 42147},
	{"WOLFGANG", 8, 42148},
	{"SPACING", 7, 42149},
	{"FRAMEWORKS", 10, 42150},
	{"COMPLETENESS", 12, 42151},
	{"IRREGULAR", 9, 42152},
	{"RGEF", 4, 42153},
	{"NSQU", 4, 42154},
	{"BARKER", 6, 42155},
	{"OGGE", 4, 42156},
	{"SOLIDS", 6, 42157},
	{"MERGERS", 7, 42158},
	{"ANQU", 4, 42159},
	{"CAPTURING", 9, 42160},
	{"FILTRATION", 10, 42161},
	{"CERTIFY", 7, 42162},
	{"CONSULTED", 9, 42163},
	{"REALISED", 8, 42164},
	{"CPUS", 4, 42165},
	{"EDSF", 4, 42166},
	{"JUDE", 4, 42167},
	{"SINGULAR", 8, 42168},
	{"LBEM", 4, 42169},
	{"INCREMENTAL", 11, 42170},
	{"JENNINGS", 8, 42171},
	{"ICBU", 4, 42172},
	{"DEMONS", 6, 42173},
	{"URPE", 4, 42174},
	{"UNACCEPTABLE", 12, 42175},
	{"MICP", 4, 42176},
	{"REDISTRIBUTE", 12, 42177},
	{"COPING", 6, 42178},
	{"ONDF", 4, 42179},
	{"NGCI", 4, 42180},
	{"ELSC", 4, 42181},
	{"IFEC", 4, 42182},
	{"ARFI", 4, 42183},
	{"CORR", 4, 42184},
	{"ORVA", 4, 42185},
	{"BAXTER", 6, 42186},
	{"OUTBREAK", 8, 42187},
	{"ABDOMINAL", 9, 42188},
	{"OREJ", 4, 42189},
	{"TEQU", 4, 42190},
	{"TCRA", 4, 42191},
	{"ECTP", 4, 42192},
	{"LINM", 4, 42193},
	{"VORO", 4, 42194},
	{"OFTU", 4, 42195},
	{"DEFICIENCIES", 12, 42196},
	{"CURVED", 6, 42197},
	{"OLEP", 4, 42198},
	{"GINV", 4, 42199},
	{"MILESTONE", 9, 42200},
	{"ERASE", 5, 42201},
	{"TCUR", 4, 42202},
	{"MASW", 4, 42203},
	{"ADWO", 4, 42204},
	{"BITES", 5, 42205},
	{"PROSE", 5, 42206},
	{"MARX", 4, 42207},
	{"RLFR", 4, 42208},
	{"INCIDENTAL", 10, 42209},
	{"WSWH", 4, 42210},
	{"ARGUING", 7, 42211},
	{"SCALABLE", 8, 42212},
	{"YFRA", 4, 42213},
	{"INTRA", 5, 42214},
	{"GUEW", 4, 42215},
	{"CLOWN", 5, 42216},
	{"URPH", 4, 42217},
	{"SPONTANEOUS", 11, 42218},
	{"GYIN", 4, 42219},
	{"SUMMERS", 7, 42220},
	{"TABOO", 5, 42221},
	{"EQUESTRIAN", 10, 42222},
	{"URBU", 4, 42223},
	{"DEXE", 4, 42224},
	{"EMWA", 4, 42225},
	{"EABR", 4, 42226},
	{"WETLAND", 7, 42227},
	{"OLSON", 5, 42228},
	{"METHODOLOGIES", 13, 42229},
	{"URTT", 4, 42230},
	{"MALICIOUS", 9, 42231},
	{"AMAZED", 6, 42232},
	{"LEGISLATORS", 11, 42233},
	{"VOLCANO", 7, 42234},
	{"CAPACITIES", 10, 42235},
	{"FREMONT", 7, 42236},
	{"YLED", 4, 42237},
	{"OVEB", 4, 42238},
	{"DTWI", 4, 42239},
	{"SKELETON", 8, 42240},
	{"NGYA", 4, 42241},
	{"UMSA", 4, 42242},
	{"DLYS", 4, 42243},
	{"CTSC", 4, 42244},
	{"RDRU", 4, 42245},
	{"SUSPECTS", 8, 42246},
	{"SVOL", 4, 42247},
	{"DISPLACED", 9, 42248},
	{"SOUNDED", 7, 42249},
	{"EXPORTER", 8, 42250},
	{"HONESTY", 7, 42251},
	{"DWARF", 5, 42252},
	{"SDOC", 4, 42253},
	{"TLAR", 4, 42254},
	{"TWWW", 4, 42255},
	{"IDSW", 4, 42256},
	{"WNWH", 4, 42257},
	{"LTAR", 4, 42258},
	{"LLDA", 4, 42259},
	{"LKSA", 4, 42260},
	{"NORTHEASTERN", 12, 42261},
	{"IFDEF", 5, 42262},
	{"KENF", 4, 42263},
	{"IDCA", 4, 42264},
	{"SHOCKS", 6, 42265},
	{"RGOI", 4, 42266},
	{"REWARDING", 9, 42267},
	{"KILLERS", 7, 42268},
	{"BATTALION", 9, 42269},
	{"UELS", 4, 42270},
	{"MULTICULTURAL", 13, 42271},
	{"LASERS", 6, 42272},
	{"CANDID", 6, 42273},
	{"SCHOOLING", 9, 42274},
	{"DATASET", 7, 42275},
	{"LKAN", 4, 42276},
	{"THORNTON", 8, 42277},
	{"SCHOOLGIRL", 10, 42278},
	{"CAESAR", 6, 42279},
	{"SAVERS", 6, 42280},
	{"ZUW", 3, 42281},
	{"WUF", 3, 42282},
	{"POWERPC", 7, 42283},
	{"PINES", 5, 42284},
	{"STEELERS", 8, 42285},
	{"STELLAR", 7, 42286},
	{"RSAP", 4, 42287},
	{"DAVENPORT", 9, 42288},
	{"UGLA", 4, 42289},
	{"LOCATING", 8, 42290},
	{"MONOGRAM", 8, 42291},
	{"PHILIPPE", 8, 42292},
	{"NORL", 4, 42293},
	{"ENHANCES", 8, 42294},
	{"URFO", 4, 42295},
	{"XPED", 4, 42296},
	{"RELATIONAL", 10, 42297},
	{"ORNAMENT", 8, 42298},
	{"DALB", 4, 42299},
	{"ATPU", 4, 42300},
	{"YDAN", 4, 42301},
	{"UTHF", 4, 42302},
	{"GRAFFITI", 8, 42303},
	{"WHOK", 4, 42304},
	{"KWY", 3, 42305},
	{"URSH", 4, 42306},
	{"CASSETTES", 9, 42307},
	{"PUSSIES", 7, 42308},
	{"URGES", 5, 42309},
	{"SOPHIE", 6, 42310},
	{"ACYA", 4, 42311},
	{"DOESNT", 6, 42312},
	{"TIFF", 4, 42313},
	{"SBAL", 4, 42314},
	{"REFRIGERATION", 13, 42315},
	{"ULET", 4, 42316},
	{"TCLU", 4, 42317},
	{"TYWO", 4, 42318},
	{"IGNF", 4, 42319},
	{"ATTACKING", 9, 42320},
	{"MICROSCOPE", 10, 42321},
	{"ERNR", 4, 42322},
	{"ICHU", 4, 42323},
	{"GSLI", 4, 42324},
	{"TBED", 4, 42325},
	{"PSWE", 4, 42326},
	{"LNAM", 4, 42327},
	{"HOUGHTON", 8, 42328},
	{"COUNTDOWN", 9, 42329},
	{"FFOO", 4, 42330},
	{"DECKER", 6, 42331},
	{"EXTERN", 6, 42332},
	{"SORF", 4, 42333},
	{"BADGES", 6, 42334},
	{"ENRON", 5, 42335},
	{"KITTEN", 6, 42336},
	{"CODEC", 5, 42337},
	{"FBUT", 4, 42338},
	{"BROADCASTS", 10, 42339},
	{"BRIDES", 6, 42340},
	{"IXTU", 4, 42341},
	{"CHECKSUM", 8, 42342},
	{"STEALING", 8, 42343},
	{"BULLETS", 7, 42344},
	{"EMPHASIZED", 10, 42345},
	{"ICWI", 4, 42346},
	{"GLOSSY", 6, 42347},
	{"KEME", 4, 42348},
	{"YMIG", 4, 42349},
	{"HAPR", 4, 42350},
	{"INFORMATIONS", 12, 42351},
	{"HAIRED", 6, 42352},
	{"DIRECTIONAL", 11, 42353},
	{"BREEDERS", 8, 42354},
	{"FFSA", 4, 42355},
	{"ALTERATIONS", 11, 42356},
	{"PABLO", 5, 42357},
	{"IRPE", 4, 42358},
	{"LETHAL", 6, 42359},
	{"SGAR", 4, 42360},
	{"UIPP", 4, 42361},
	{"MMAK", 4, 42362},
	{"BIOGRAPHICAL", 12, 42363},
	{"HMIL", 4, 42364},
	{"CONFIRMS", 8, 42365},
	{"FFLI", 4, 42366},
	{"CAVITY", 6, 42367},
	{"RBIA", 4, 42368},
	{"ANRU", 4, 42369},
	{"MCDO", 4, 42370},
	{"YAFF", 4, 42371},
	{"EDHU", 4, 42372},
	{"SSUF", 4, 42373},
	{"MOLDED", 6, 42374},
	{"ONRU", 4, 42375},
	{"LOPP", 4, 42376},
	{"VLADIMIR", 8, 42377},
	{"DIDW", 4, 42378},
	{"FGEN", 4, 42379},
	{"FANC", 4, 42380},
	{"EORM", 4, 42381},
	{"PROBATE", 7, 42382},
	{"PLOI", 4, 42383},
	{"TYSP", 4, 42384},
	{"TERRESTRIAL", 11, 42385},
	{"DECALS", 6, 42386},
	{"COMPLETES", 9, 42387},
	{"BEAMS", 5, 42388},
	{"PROPS", 5, 42389},
	{"INCENSE", 7, 42390},
	{"FORMULATED", 10, 42391},
	{"RLYL", 4, 42392},
	{"UDEO", 4, 42393},
	{"MSOU", 4, 42394},
	{"STOOL", 5, 42395},
	{"RDQU", 4, 42396},
	{"WMAK", 4, 42397},
	{"MACS", 4, 42398},
	{"TOWING", 6, 42399},
	{"WELCH", 5, 42400},
	{"GITW", 4, 42401},
	{"ROSEMARY", 8, 42402},
	{"GBRO", 4, 42403},
	{"ULGA", 4, 42404},
	{"LISL", 4, 42405},
	{"MILLIONAIRE", 11, 42406},
	{"RDIV", 4, 42407},
	{"TURQUOISE", 9, 42408},
	{"OFFM", 4, 42409},
	{"MYWI", 4, 42410},
	{"MEBY", 4, 42411},
	{"LRUN", 4, 42412},
	{"OWIF", 4, 42413},
	{"ARCHIVAL", 8, 42414},
	{"UZF", 3, 42415},
	{"UKJ", 3, 42416},
	{"SEISMIC", 7, 42417},
	{"EXPOSURES", 9, 42418},
	{"NGVO", 4, 42419},
	{"BACCARAT", 8, 42420},
	{"BOONE", 5, 42421},
	{"SUBSTITUTED", 11, 42422},
	{"KWHO", 4, 42423},
	{"EFOF", 4, 42424},
	{"HORDE", 5, 42425},
	{"PAPERWORK", 9, 42426},
	{"MOMMY", 5, 42427},
	{"RSUA", 4, 42428},
	{"EYLI", 4, 42429},
	{"NANNY", 5, 42430},
	{"BYAB", 4, 42431},
	{"HUTCHINSON", 10, 42432},
	{"YREQ", 4, 42433},
	{"SMOKERS", 7, 42434},
	{"COHORT", 6, 42435},
	{"KAFT", 4, 42436},
	{"NABR", 4, 42437},
	{"SUCCESSION", 10, 42438},
	{"DECLINING", 9, 42439},
	{"ALLIANCES", 9, 42440},
	{"SUMS", 4, 42441},
	{"LINEUP", 6, 42442},
	{"LTFO", 4, 42443},
	{"YBLO", 4, 42444},
	{"AVERAGED", 8, 42445},
	{"HOTSPOT", 7, 42446},
	{"BELLEVUE", 8, 42447},
	{"GLACIER", 7, 42448},
	{"PUEBLO", 6, 42449},
	{"WNRE", 4, 42450},
	{"RIGOROUS", 8, 42451},
	{"YSWA", 4, 42452},
	{"GIGABIT", 7, 42453},
	{"MSRE", 4, 42454},
	{"LOTM", 4, 42455},
	{"WORKSHEET", 9, 42456},
	{"ALLOCATE", 8, 42457},
	{"AFTERMATH", 9, 42458},
	{"NEYM", 4, 42459},
	{"ROACH", 5, 42460},
	{"OOLP", 4, 42461},
	{"CLARION", 7, 42462},
	{"OVERRIDE", 8, 42463},
	{"ANGUS", 5, 42464},
	{"ENTHUSIASTIC", 12, 42465},
	{"LAME", 4, 42466},
	{"CONTINUUM", 9, 42467},
	{"ONDD", 4, 42468},
	{"ALLV", 4, 42469},
	{"FENG", 4, 42470},
	{"LCHE", 4, 42471},
	{"BURGUNDY", 8, 42472},
	{"NDRY", 4, 42473},
	{"STRUGGLES", 9, 42474},
	{"OLDG", 4, 42475},
	{"FAREWELL", 8, 42476},
	{"ORMC", 4, 42477},
	{"ALRU", 4, 42478},
	{"VANGUARD", 8, 42479},
	{"NYLONS", 6, 42480},
	{"CHIPSET", 7, 42481},
	{"ARIG", 4, 42482},
	{"NATAL", 5, 42483},
	{"URME", 4, 42484},
	{"PEDR", 4, 42485},
	{"OTRU", 4, 42486},
	{"GLEI", 4, 42487},
	{"OUGL", 4, 42488},
	{"LOWM", 4, 42489},
	{"LOCUS", 5, 42490},
	{"MSNBC", 5, 42491},
	{"HILLARY", 7, 42492},
	{"EVENINGS", 8, 42493},
	{"SKIR", 4, 42494},
	{"DLEC", 4, 42495},
	{"DITU", 4, 42496},
	{"MISSES", 6, 42497},
	{"TROUBLES", 8, 42498},
	{"FACTUAL", 7, 42499},
	{"CARISOPRODOL", 12, 42500},
	{"UMZ", 3, 42501},
	{"OFSM", 4, 42502},
	{"TUTORING", 8, 42503},
	{"SPECTROSCOPY", 12, 42504},
	{"ORYP", 4, 42505},
	{"WSFO", 4, 42506},
	{"GEMSTONE", 8, 42507},
	{"LYYE", 4, 42508},
	{"OMWE", 4, 42509},
	{"PHONEPHONE", 10, 42510},
	{"ELTON", 5, 42511},
	{"RVEI", 4, 42512},
	{"GEMO", 4, 42513},
	{"PURITY", 6, 42514},
	{"SSQU", 4, 42515},
	{"SHAKING", 7, 42516},
	{"RDFR", 4, 42517},
	{"LUCT", 4, 42518},
	{"TVIC", 4, 42519},
	{"RSTQ", 4, 42520},
	{"UNREGISTERED", 12, 42521},
	{"TBIG", 4, 42522},
	{"LBUI", 4, 42523},
	{"WITNESSED", 9, 42524},
	{"CELLAR", 6, 42525},
	{"RDLA", 4, 42526},
	{"DIDH", 4, 42527},
	{"GONZALEZ", 8, 42528},
	{"FRICTION", 8, 42529},
	{"PRONE", 5, 42530},
	{"FFAT", 4, 42531},
	{"VALERIE", 7, 42532},
	{"AFAL", 4, 42533},
	{"ENCLOSURES", 10, 42534},
	{"DIOR", 4, 42535},
	{"DAYJ", 4, 42536},
	{"EQUITABLE", 9, 42537},
	{"EDSW", 4, 42538},
	{"ORDP", 4, 42539},
	{"FUSE", 4, 42540},
	{"GAPA", 4, 42541},
	{"LOBSTER", 7, 42542},
	{"POPS", 4, 42543},
	{"JUDAISM", 7, 42544},
	{"NTMU", 4, 42545},
	{"LASV", 4, 42546},
	{"WAYC", 4, 42547},
	{"TYSU", 4, 42548},
	{"GOLDBERG", 8, 42549},
	{"ATLANTIS", 8, 42550},
	{"IUMI", 4, 42551},
	{"FFUN", 4, 42552},
	{"ELUN", 4, 42553},
	{"HEDD", 4, 42554},
	{"ONIONS", 6, 42555},
	{"IRAB", 4, 42556},
	{"ALSL", 4, 42557},
	{"PRETEEN", 7, 42558},
	{"TYDI", 4, 42559},
	{"BONDING", 7, 42560},
	{"REKN", 4, 42561},
	{"INSURERS", 8, 42562},
	{"PROTOTYPES", 10, 42563},
	{"UNGL", 4, 42564},
	{"CORINTHIANS", 11, 42565},
	{"CROSSES", 7, 42566},
	{"PROACTIVE", 9, 42567},
	{"EEFR", 4, 42568},
	{"GTOK", 4, 42569},
	{"ISSUER", 6, 42570},
	{"SYLVIA", 6, 42571},
	{"FURNACE", 7, 42572},
	{"SPONSORING", 10, 42573},
	{"IRAR", 4, 42574},
	{"WINF", 4, 42575},
	{"TALG", 4, 42576},
	{"POISONING", 9, 42577},
	{"BIGC", 4, 42578},
	{"DOUBLED", 7, 42579},
	{"OQUA", 4, 42580},
	{"MALAYSIAN", 9, 42581},
	{"EAUC", 4, 42582},
	{"CLUES", 5, 42583},
	{"INFLAMMATION", 12, 42584},
	{"QUEB", 4, 42585},
	{"RABBITS", 7, 42586},
	{"PSFO", 4, 42587},
	{"ORAV", 4, 42588},
	{"TRANSPORTED", 11, 42589},
	{"CREWS", 5, 42590},
	{"TOFY", 4, 42591},
	{"EASTON", 6, 42592},
	{"RLAR", 4, 42593},
	{"ICLY", 4, 42594},
	{"GOODWILL", 8, 42595},
	{"SENTENCING", 10, 42596},
	{"TQUE", 4, 42597},
	{"BULLDOGS", 8, 42598},
	{"YPAT", 4, 42599},
	{"WORTHWHILE", 10, 42600},
	{"DVOT", 4, 42601},
	{"TARIFFS", 7, 42602},
	{"NORRIS", 6, 42603},
	{"THFL", 4, 42604},
	{"ETBY", 4, 42605},
	{"DBEB", 4, 42606},
	{"CERVICAL", 8, 42607},
	{"BAPTISM", 7, 42608},
	{"CUTLERY", 7, 42609},
	{"OVERLOOKING", 11, 42610},
	{"RTAX", 4, 42611},
	{"TALLAHASSEE", 11, 42612},
	{"GWAT", 4, 42613},
	{"USERPIC", 7, 42614},
	{"ODFR", 4, 42615},
	{"CKSB", 4, 42616},
	{"ATTRIBUTION", 11, 42617},
	{"LDOW", 4, 42618},
	{"STAFFORDSHIRE", 13, 42619},
	{"FACTORIES", 9, 42620},
	{"SWORDS", 6, 42621},
	{"BYLE", 4, 42622},
	{"ILYP", 4, 42623},
	{"RDCA", 4, 42624},
	{"ADVANCING", 9, 42625},
	{"TIMED", 5, 42626},
	{"YUAN", 4, 42627},
	{"RDBE", 4, 42628},
	{"KETF", 4, 42629},
	{"DIFFERS", 7, 42630},
	{"LAPT", 4, 42631},
	{"NDUL", 4, 42632},
	{"LEASED", 6, 42633},
	{"HMAY", 4, 42634},
	{"SUBSCRIBED", 10, 42635},
	{"LINL", 4, 42636},
	{"RBID", 4, 42637},
	{"STARTERS", 8, 42638},
	{"DARTMOUTH", 9, 42639},
	{"BREWING", 7, 42640},
	{"ARKL", 4, 42641},
	{"COOP", 4, 42642},
	{"UML", 3, 42643},
	{"BUR", 3, 42644},
	{"RAFO", 4, 42645},
	{"BLOSSOM", 7, 42646},
	{"NCOV", 4, 42647},
	{"ILRE", 4, 42648},
	{"NTPU", 4, 42649},
	{"CONFESSIONS", 11, 42650},
	{"XCEE", 4, 42651},
	{"BERGEN", 6, 42652},
	{"LOWERED", 7, 42653},
	{"KRIS", 4, 42654},
	{"RMSW", 4, 42655},
	{"THIEF", 5, 42656},
	{"TPRA", 4, 42657},
	{"PRISONS", 7, 42658},
	{"PICTURED", 8, 42659},
	{"FEMININE", 8, 42660},
	{"SIZEOF", 6, 42661},
	{"GRABBED", 7, 42662},
	{"ROCKING", 7, 42663},
	{"OCKC", 4, 42664},
	{"ORAY", 4, 42665},
	{"OMSC", 4, 42666},
	{"DPUR", 4, 42667},
	{"NICHOLS", 7, 42668},
	{"REGS", 4, 42669},
	{"BLACKWELL", 9, 42670},
	{"SSLY", 4, 42671},
	{"YGB", 3, 42672},
	{"YFEL", 4, 42673},
	{"RIFL", 4, 42674},
	{"VABL", 4, 42675},
	{"BMAR", 4, 42676},
	{"KTOG", 4, 42677},
	{"FULFILLED", 9, 42678},
	{"DAYR", 4, 42679},
	{"SWEETS", 6, 42680},
	{"SAFU", 4, 42681},
	{"NAUTICAL", 8, 42682},
	{"IMPRISONMENT", 12, 42683},
	{"EMPLOYS", 7, 42684},
	{"GUTENBERG", 9, 42685},
	{"BUBBLES", 7, 42686},
	{"MTRA", 4, 42687},
	{"TOFJ", 4, 42688},
	{"ASHTON", 6, 42689},
	{"SHINEDOWN", 9, 42690},
	{"TILW", 4, 42691},
	{"CKSS", 4, 42692},
	{"JUDGMENTS", 9, 42693},
	{"FFWI", 4, 42694},
	{"YDET", 4, 42695},
	{"MUSCULAR", 8, 42696},
	{"GHIG", 4, 42697},
	{"MOTIF", 5, 42698},
	{"ORHU", 4, 42699},
	{"ILLNESSES", 9, 42700},
	{"PLUM", 4, 42701},
	{"ADPO", 4, 42702},
	{"SALOON", 6, 42703},
	{"PROPHECY", 8, 42704},
	{"OLIK", 4, 42705},
	{"ILPR", 4, 42706},
	{"NDSD", 4, 42707},
	{"ELOD", 4, 42708},
	{"LOFT", 4, 42709},
	{"TRAW", 4, 42710},
	{"NGPH", 4, 42711},
	{"DICU", 4, 42712},
	{"YFB", 3, 42713},
	{"YDK", 3, 42714},
	{"LERM", 4, 42715},
	{"RTEX", 4, 42716},
	{"EFLU", 4, 42717},
	{"WALLETS", 7, 42718},
	{"IDENTIFIABLE", 12, 42719},
	{"LDBA", 4, 42720},
	{"RDDE", 4, 42721},
	{"MWHO", 4, 42722},
	{"FACSIMILE", 9, 42723},
	{"HURTS", 5, 42724},
	{"ETHANOL", 7, 42725},
	{"DTRO", 4, 42726},
	{"TSMU", 4, 42727},
	{"HAGR", 4, 42728},
	{"CANNABIS", 8, 42729},
	{"FOLDED", 6, 42730},
	{"RSVP", 4, 42731},
	{"RFEA", 4, 42732},
	{"RFAN", 4, 42733},
	{"SOFIA", 5, 42734},
	{"DYNAMICALLY", 11, 42735},
	{"GRENADINES", 10, 42736},
	{"ECKA", 4, 42737},
	{"LUMP", 4, 42738},
	{"CONSTR", 6, 42739},
	{"DISPOSED", 8, 42740},
	{"RXF", 3, 42741},
	{"OBAR", 4, 42742},
	{"SUBTITLE", 8, 42743},
	{"CHESTNUT", 8, 42744},
	{"LIBRARIANS", 10, 42745},
	{"ENGRAVED", 8, 42746},
	{"WERH", 4, 42747},
	{"MANSON", 6, 42748},
	{"HRIV", 4, 42749},
	{"AVAG", 4, 42750},
	{"OWSK", 4, 42751},
	{"DNAP", 4, 42752},
	{"RDOU", 4, 42753},
	{"UALW", 4, 42754},
	{"RVEL", 4, 42755},
	{"LEYH", 4, 42756},
	{"MHAV", 4, 42757},
	{"YHIM", 4, 42758},
	{"AUTOCAD", 7, 42759},
	{"PTAB", 4, 42760},
	{"PASTORAL", 8, 42761},
	{"UNPAID", 6, 42762},
	{"GHOSTS", 6, 42763},
	{"NLYE", 4, 42764},
	{"POWERBOOK", 9, 42765},
	{"DOUBTS", 6, 42766},
	{"LOCALITY", 8, 42767},
	{"LCLI", 4, 42768},
	{"DAWI", 4, 42769},
	{"OLME", 4, 42770},
	{"NUPT", 4, 42771},
	{"COWB", 4, 42772},
	{"SUBSTANTIVE", 11, 42773},
	{"LWEA", 4, 42774},
	{"LDOR", 4, 42775},
	{"BULLETINS", 9, 42776},
	{"WORRIES", 7, 42777},
	{"OLBO", 4, 42778},
	{"EMIU", 4, 42779},
	{"GLEP", 4, 42780},
	{"KEVE", 4, 42781},
	{"REJECTS", 7, 42782},
	{"SPEAR", 5, 42783},
	{"YBIL", 4, 42784},
	{"EYFR", 4, 42785},
	{"IEDP", 4, 42786},
	{"NIGEL", 5, 42787},
	{"REFEREE", 7, 42788},
	{"OFUL", 4, 42789},
	{"IPRE", 4, 42790},
	{"TRANSPORTER", 11, 42791},
	{"JOLIE", 5, 42792},
	{"OOKU", 4, 42793},
	{"BROADLY", 7, 42794},
	{"ELFD", 4, 42795},
	{"ETHEREAL", 8, 42796},
	{"OLFC", 4, 42797},
	{"CROSSROADS", 10, 42798},
	{"CONSTRUCTING", 12, 42799},
	{"SMOOTHLY", 8, 42800},
	{"ICEV", 4, 42801},
	{"PARSONS", 7, 42802},
	{"YSAW", 4, 42803},
	{"ADYI", 4, 42804},
	{"HROM", 4, 42805},
	{"THJU", 4, 42806},
	{"INFINITI", 8, 42807},
	{"BLANC", 5, 42808},
	{"EYPA", 4, 42809},
	{"TAXC", 4, 42810},
	{"BOUNDED", 7, 42811},
	{"APAL", 4, 42812},
	{"PPL", 3, 42813},
	{"WILLIAMSBURG", 12, 42814},
	{"FONL", 4, 42815},
	{"EWEW", 4, 42816},
	{"BIRCH", 5, 42817},
	{"PPYT", 4, 42818},
	{"ALEB", 4, 42819},
	{"SUPP", 4, 42820},
	{"SLASH", 5, 42821},
	{"SNYDER", 6, 42822},
	{"BUDGETING", 9, 42823},
	{"EXERCISED", 9, 42824},
	{"IDMO", 4, 42825},
	{"BACKPACKS", 9, 42826},
	{"DETECTING", 9, 42827},
	{"RESALE", 6, 42828},
	{"AROC", 4, 42829},
	{"MIKES", 5, 42830},
	{"HOWELL", 6, 42831},
	{"DIGESTIVE", 9, 42832},
	{"SCALAR", 6, 42833},
	{"ENTERTAIN", 9, 42834},
	{"CINDERELLA", 10, 42835},
	{"UNRESOLVED", 10, 42836},
	{"SESAME", 6, 42837},
	{"DUCT", 4, 42838},
	{"TOUCHES", 7, 42839},
	{"VEUN", 4, 42840},
	{"NDSY", 4, 42841},
	{"DPEN", 4, 42842},
	{"SEIKO", 5, 42843},
	{"VEBR", 4, 42844},
	{"RGAI", 4, 42845},
	{"ELECTROMAGNETIC", 15, 42846},
	{"ARIAL", 5, 42847},
	{"JOANNE", 6, 42848},
	{"HOUSEWIFE", 9, 42849},
	{"ZOOFILIA", 8, 42850},
	{"ZJR", 3, 42851},
	{"EYTR", 4, 42852},
	{"RYSL", 4, 42853},
	{"PURSUED", 7, 42854},
	{"VALIDATED", 9, 42855},
	{"LUEA", 4, 42856},
	{"CORVETTE", 8, 42857},
	{"YASK", 4, 42858},
	{"ULTF", 4, 42859},
	{"YACHTS", 6, 42860},
	{"DDAR", 4, 42861},
	{"STACY", 5, 42862},
	{"YPHO", 4, 42863},
	{"CHRISTIE", 8, 42864},
	{"UNRELATED", 9, 42865},
	{"LEVI", 4, 42866},
	{"ANNOTATE", 8, 42867},
	{"STIMULATING", 11, 42868},
	{"JOOMLA", 6, 42869},
	{"MISUSE", 6, 42870},
	{"LFAM", 4, 42871},
	{"CKYA", 4, 42872},
	{"HELIX", 5, 42873},
	{"COSMOS", 6, 42874},
	{"DIXIE", 5, 42875},
	{"ENFORCED", 8, 42876},
	{"SVEG", 4, 42877},
	{"ATJU", 4, 42878},
	{"LEGION", 6, 42879},
	{"FULFILLMENT", 11, 42880},
	{"PWHE", 4, 42881},
	{"OMLO", 4, 42882},
	{"DDOC", 4, 42883},
	{"BIOMASS", 7, 42884},
	{"PBET", 4, 42885},
	{"UALO", 4, 42886},
	{"ASSERTION", 9, 42887},
	{"HIERARCHICAL", 12, 42888},
	{"LESIONS", 7, 42889},
	{"VQU", 3, 42890},
	{"SHOOK", 5, 42891},
	{"LINCOLNSHIRE", 12, 42892},
	{"RKEN", 4, 42893},
	{"FINANCED", 8, 42894},
	{"RVOI", 4, 42895},
	{"DISMISSAL", 9, 42896},
	{"SURNAMES", 8, 42897},
	{"WORU", 4, 42898},
	{"UIDA", 4, 42899},
	{"EYEL", 4, 42900},
	{"RECONDITIONED", 13, 42901},
	{"JRV", 3, 42902},
	{"SHOCKING", 8, 42903},
	{"OUAL", 4, 42904},
	{"ALLERGIC", 8, 42905},
	{"OVERLAND", 8, 42906},
	{"PROLONGED", 9, 42907},
	{"DEBR", 4, 42908},
	{"ISAIAH", 6, 42909},
	{"BACKBONE", 8, 42910},
	{"LAGR", 4, 42911},
	{"UNANIMOUSLY", 11, 42912},
	{"ELIMINATES", 10, 42913},
	{"SAUSAGE", 7, 42914},
	{"AMLE", 4, 42915},
	{"ADDICT", 6, 42916},
	{"AYCH", 4, 42917},
	{"BYDA", 4, 42918},
	{"CHBO", 4, 42919},
	{"MATTE", 5, 42920},
	{"FGOO", 4, 42921},
	{"UNCOMMON", 8, 42922},
	{"CENTRALIZED", 11, 42923},
	{"STRATFORD", 9, 42924},
	{"HEIDI", 5, 42925},
	{"DFUR", 4, 42926},
	{"RMAJ", 4, 42927},
	{"GEOU", 4, 42928},
	{"EYSP", 4, 42929},
	{"MELANIE", 7, 42930},
	{"KKW", 3, 42931},
	{"SLER", 4, 42932},
	{"OBJECTIONS", 10, 42933},
	{"ILOU", 4, 42934},
	{"FEXE", 4, 42935},
	{"CKPA", 4, 42936},
	{"UNPUBLISHED", 11, 42937},
	{"SLAUGHTER", 9, 42938},
	{"LAYM", 4, 42939},
	{"HBRO", 4, 42940},
	{"ENLIGHTENMENT", 13, 42941},
	{"JUNIORS", 7, 42942},
	{"DROA", 4, 42943},
	{"ROCKETS", 7, 42944},
	{"XUM", 3, 42945},
	{"FXC", 3, 42946},
	{"SECUNIA", 7, 42947},
	{"METERING", 8, 42948},
	{"SEYMOUR", 7, 42949},
	{"GENETICALLY", 11, 42950},
	{"ZEBRA", 5, 42951},
	{"UDER", 4, 42952},
	{"LERH", 4, 42953},
	{"RUNWAY", 6, 42954},
	{"ARITHMETIC", 10, 42955},
	{"LVIS", 4, 42956},
	{"NOWD", 4, 42957},
	{"ADMITS", 6, 42958},
	{"DEAG", 4, 42959},
	{"BOMBAY", 6, 42960},
	{"ORIGINALS", 9, 42961},
	{"ENRICHMENT", 10, 42962},
	{"CHENNAI", 7, 42963},
	{"MILFORD", 7, 42964},
	{"BUCKLE", 6, 42965},
	{"BARTLETT", 8, 42966},
	{"FETCH", 5, 42967},
	{"KITCHENS", 8, 42968},
	{"ASSHOLE", 7, 42969},
	{"HOFC", 4, 42970},
	{"DIVERS", 6, 42971},
	{"FAROE", 5, 42972},
	{"OROC", 4, 42973},
	{"TOWNSEND", 8, 42974},
	{"BLACKBURN", 9, 42975},
	{"GLENDALE", 8, 42976},
	{"SPEEDWAY", 8, 42977},
	{"HECY", 4, 42978},
	{"FOUNDERS", 8, 42979},
	{"SWEATSHIRTS", 11, 42980},
	{"SUNDAYS", 7, 42981},
	{"ORTD", 4, 42982},
	{"FIRI", 4, 42983},
	{"UPSIDE", 6, 42984},
	{"HIPM", 4, 42985},
	{"ADMIRAL", 7, 42986},
	{"SRIV", 4, 42987},
	{"SECL", 4, 42988},
	{"GASC", 4, 42989},
	{"EPOU", 4, 42990},
	{"DEOG", 4, 42991},
	{"LOFW", 4, 42992},
	{"SANDWICHES", 10, 42993},
	{"SINCLAIR", 8, 42994},
	{"BOILER", 6, 42995},
	{"YUSI", 4, 42996},
	{"YPOT", 4, 42997},
	{"OEXC", 4, 42998},
	{"AULS", 4, 42999},
	{"GEDU", 4, 43000},
	{"YBRA", 4, 43001},
	{"ACTIVEX", 7, 43002},
	{"LOGON", 5, 43003},
	{"INDUCE", 6, 43004},
	{"ANNAPOLIS", 9, 43005},
	{"PADDING", 7, 43006},
	{"EIRU", 4, 43007},
	{"YCRO", 4, 43008},
	{"NROB", 4, 43009},
	{"RECRUITER", 9, 43010},
	{"OODG", 4, 43011},
	{"POPCORN", 7, 43012},
	{"ESPANOL", 7, 43013},
	{"DISADVANTAGED", 13, 43014},
	{"TRONG", 5, 43015},
	{"DIAGONAL", 8, 43016},
	{"RPAN", 4, 43017},
	{"ARSR", 4, 43018},
	{"MOFS", 4, 43019},
	{"CRACKED", 7, 43020},
	{"MJUS", 4, 43021},
	{"DEBTOR", 6, 43022},
	{"POLK", 4, 43023},
	{"EMYA", 4, 43024},
	{"YAFE", 4, 43025},
	{"SHEAR", 5, 43026},
	{"NFEL", 4, 43027},
	{"MORTAL", 6, 43028},
	{"SPLU", 4, 43029},
	{"REBL", 4, 43030},
	{"YHAP", 4, 43031},
	{"TROB", 4, 43032},
	{"UTSP", 4, 43033},
	{"RSBO", 4, 43034},
	{"FRANCHISES", 10, 43035},
	{"IKEG", 4, 43036},
	{"RAMS", 4, 43037},
	{"CLEANSING", 9, 43038},
	{"MFR", 3, 43039},
	{"RCEC", 4, 43040},
	{"LFTI", 4, 43041},
	{"GGIE", 4, 43042},
	{"HMMM", 4, 43043},
	{"GENOMIC", 7, 43044},
	{"GOWN", 4, 43045},
	{"HELPDESK", 8, 43046},
	{"LBEE", 4, 43047},
	{"TEPL", 4, 43048},
	{"PONDS", 5, 43049},
	{"ARCHERY", 7, 43050},
	{"REFUSES", 7, 43051},
	{"YVAL", 4, 43052},
	{"FULW", 4, 43053},
	{"FULB", 4, 43054},
	{"UPWH", 4, 43055},
	{"ICKM", 4, 43056},
	{"DADM", 4, 43057},
	{"EXCLUDES", 8, 43058},
	{"OWSP", 4, 43059},
	{"SABBATH", 7, 43060},
	{"LLEI", 4, 43061},
	{"TRUMP", 5, 43062},
	{"ESCAPED", 7, 43063},
	{"PRECURSOR", 9, 43064},
	{"MATES", 5, 43065},
	{"SGOL", 4, 43066},
	{"ADHD", 4, 43067},
	{"AVIAN", 5, 43068},
	{"ORYM", 4, 43069},
	{"UDAN", 4, 43070},
	{"STELLA", 6, 43071},
	{"VISAS", 5, 43072},
	{"UCZ", 3, 43073},
	{"MATRICES", 8, 43074},
	{"UKEE", 4, 43075},
	{"WBUT", 4, 43076},
	{"UPPR", 4, 43077},
	{"ANYWAYS", 7, 43078},
	{"ATMY", 4, 43079},
	{"XTREME", 6, 43080},
	{"RAWE", 4, 43081},
	{"PASSAGES", 8, 43082},
	{"AILL", 4, 43083},
	{"TOPC", 4, 43084},
	{"EDVO", 4, 43085},
	{"ETIOLOGY", 8, 43086},
	{"OWFA", 4, 43087},
	{"LOVI", 4, 43088},
	{"RANF", 4, 43089},
	{"TLEL", 4, 43090},
	{"LPEN", 4, 43091},
	{"CEREAL", 6, 43092},
	{"HIPF", 4, 43093},
	{"XYEA", 4, 43094},
	{"KETR", 4, 43095},
	{"COMPREHENSION", 13, 43096},
	{"MYHE", 4, 43097},
	{"DTOV", 4, 43098},
	{"RESOLVING", 9, 43099},
	{"VEDP", 4, 43100},
	{"MELLON", 6, 43101},
	{"EVEB", 4, 43102},
	{"DRILLS", 6, 43103},
	{"WEBMD", 5, 43104},
	{"ALEXANDRA", 9, 43105},
	{"CHAMP", 5, 43106},
	{"PERSONALISED", 12, 43107},
	{"HOSPICE", 7, 43108},
	{"ZERODEGREES", 11, 43109},
	{"RUMB", 4, 43110},
	{"AGREEING", 8, 43111},
	{"RSCL", 4, 43112},
	{"EXHIBITOR", 9, 43113},
	{"REXC", 4, 43114},
	{"RENTED", 6, 43115},
	{"DEDUCTIONS", 10, 43116},
	{"HARRISBURG", 10, 43117},
	{"GOOU", 4, 43118},
	{"ULPT", 4, 43119},
	{"BRUSHED", 7, 43120},
	{"AUGMENTATION", 12, 43121},
	{"ELAG", 4, 43122},
	{"ARKN", 4, 43123},
	{"YISC", 4, 43124},
	{"AKLA", 4, 43125},
	{"ANNUITY", 7, 43126},
	{"ASSORTMENT", 10, 43127},
	{"CREDIBLE", 8, 43128},
	{"ELLL", 4, 43129},
	{"VEMU", 4, 43130},
	{"ARKB", 4, 43131},
	{"SPORTSWEAR", 10, 43132},
	{"CULTURED", 8, 43133},
	{"RLOV", 4, 43134},
	{"IMPORTING", 9, 43135},
	{"RECAP", 5, 43136},
	{"YTAX", 4, 43137},
	{"TODDLERS", 8, 43138},
	{"LLEM", 4, 43139},
	{"ERPH", 4, 43140},
	{"ASTRO", 5, 43141},
	{"OCUR", 4, 43142},
	{"RBUI", 4, 43143},
	{"KEWE", 4, 43144},
	{"CHANEL", 6, 43145},
	{"SPARKLING", 9, 43146},
	{"JABBER", 6, 43147},
	{"BINDINGS", 8, 43148},
	{"RALN", 4, 43149},
	{"CONVINCING", 10, 43150},
	{"ROTATE", 6, 43151},
	{"FLAWS", 5, 43152},
	{"RTYC", 4, 43153},
	{"TRACING", 7, 43154},
	{"DEVIATIONS", 10, 43155},
	{"RCEF", 4, 43156},
	{"INCOMES", 7, 43157},
	{"FEMA", 4, 43158},
	{"SUBWOOFER", 9, 43159},
	{"AMORTIZATION", 12, 43160},
	{"NEUROLOGY", 9, 43161},
	{"UPLI", 4, 43162},
	{"YKIL", 4, 43163},
	{"DCUT", 4, 43164},
	{"YCAT", 4, 43165},
	{"JEREMIAH", 8, 43166},
	{"SAPIENS", 7, 43167},
	{"CEVE", 4, 43168},
	{"OLSEN", 5, 43169},
	{"HEMD", 4, 43170},
	{"SERBIAN", 7, 43171},
	{"RADIATOR", 8, 43172},
	{"YEDU", 4, 43173},
	{"UPRI", 4, 43174},
	{"COMPETENCIES", 12, 43175},
	{"FAUS", 4, 43176},
	{"RESTORING", 9, 43177},
	{"FSCI", 4, 43178},
	{"VEAW", 4, 43179},
	{"SANCHEZ", 7, 43180},
	{"RUSHING", 7, 43181},
	{"LWEL", 4, 43182},
	{"HABL", 4, 43183},
	{"BEHOLD", 6, 43184},
	{"CHPL", 4, 43185},
	{"AMHERST", 7, 43186},
	{"ALTERATION", 10, 43187},
	{"HOTSPOTS", 8, 43188},
	{"WMOR", 4, 43189},
	{"LOWW", 4, 43190},
	{"NORP", 4, 43191},
	{"TRAINEE", 7, 43192},
	{"BYSU", 4, 43193},
	{"NIELSEN", 7, 43194},
	{"ATDR", 4, 43195},
	{"GFIN", 4, 43196},
	{"PODCASTING", 10, 43197},
	{"GSCA", 4, 43198},
	{"CHSP", 4, 43199},
	{"MURDERED", 8, 43200},
	{"FGOD", 4, 43201},
	{"FTRE", 4, 43202},
	{"CENTENNIAL", 10, 43203},
	{"ELDC", 4, 43204},
	{"BLUEGRASS", 9, 43205},
	{"MERD", 4, 43206},
	{"DENW", 4, 43207},
	{"OORL", 4, 43208},
	{"ILLK", 4, 43209},
	{"IGGI", 4, 43210},
	{"HAZEL", 5, 43211},
	{"GHOF", 4, 43212},
	{"LEDGER", 6, 43213},
	{"YLEV", 4, 43214},
	{"LDRU", 4, 43215},
	{"SCARLET", 7, 43216},
	{"CRUSHED", 7, 43217},
	{"ACRONYMS", 8, 43218},
	{"OFGL", 4, 43219},
	{"LAUGHS", 6, 43220},
	{"NWOM", 4, 43221},
	{"CONNIE", 6, 43222},
	{"AUTOGRAPHED", 11, 43223},
	{"AGUI", 4, 43224},
	{"REFERENDUM", 10, 43225},
	{"MODULATION", 10, 43226},
	{"STATUES", 7, 43227},
	{"RFAL", 4, 43228},
	{"DEPTHS", 6, 43229},
	{"SPICES", 6, 43230},
	{"COMMUNION", 9, 43231},
	{"LOADER", 6, 43232},
	{"LINB", 4, 43233},
	{"DNTC", 4, 43234},
	{"BLYI", 4, 43235},
	{"UNCERTAINTIES", 13, 43236},
	{"COLONIES", 8, 43237},
	{"YORT", 4, 43238},
	{"ORKM", 4, 43239},
	{"SFOC", 4, 43240},
	{"FOLLOWERS", 9, 43241},
	{"OCKF", 4, 43242},
	{"CALDWELL", 8, 43243},
	{"DREQ", 4, 43244},
	{"FTOU", 4, 43245},
	{"LATENCY", 7, 43246},
	{"DASB", 4, 43247},
	{"THEMED", 6, 43248},
	{"MESSY", 5, 43249},
	{"SQUADRON", 8, 43250},
	{"DPET", 4, 43251},
	{"YINL", 4, 43252},
	{"DMC", 3, 43253},
	{"LPAT", 4, 43254},
	{"RUPEE", 5, 43255},
	{"FHEW", 4, 43256},
	{"MENTS", 5, 43257},
	{"RLEF", 4, 43258},
	{"DEMOLITION", 10, 43259},
	{"WEMA", 4, 43260},
	{"IRENE", 5, 43261},
	{"YFEA", 4, 43262},
	{"EDCE", 4, 43263},
	{"DDUE", 4, 43264},
	{"EYMI", 4, 43265},
	{"EMPOWERMENT", 11, 43266},
	{"HROP", 4, 43267},
	{"DILY", 4, 43268},
	{"FELONY", 6, 43269},
	{"LYYO", 4, 43270},
	{"LUNGS", 5, 43271},
	{"MONUMENTS", 9, 43272},
	{"GINB", 4, 43273},
	{"VERONICA", 8, 43274},
	{"NCUL", 4, 43275},
	{"FILTERED", 8, 43276},
	{"DDAM", 4, 43277},
	{"REPLACEMENTS", 12, 43278},
	{"GROWERS", 7, 43279},
	{"SRIC", 4, 43280},
	{"VINCI", 5, 43281},
	{"SUBTITLES", 9, 43282},
	{"NGUE", 4, 43283},
	{"GCSE", 4, 43284},
	{"ACUPUNCTURE", 11, 43285},
	{"LTOM", 4, 43286},
	{"WORKLOAD", 8, 43287},
	{"ORSR", 4, 43288},
	{"FCRE", 4, 43289},
	{"DSYS", 4, 43290},
	{"YMOT", 4, 43291},
	{"CLED", 4, 43292},
	{"ACKNOWLEDGEMENT", 15, 43293},
	{"HIGHLIGHTING", 12, 43294},
	{"DULY", 4, 43295},
	{"ROASTED", 7, 43296},
	{"TENDERS", 7, 43297},
	{"INVITING", 8, 43298},
	{"YTRE", 4, 43299},
	{"GRASSROOTS", 10, 43300},
	{"MICK", 4, 43301},
	{"GENTOO", 6, 43302},
	{"REDEVELOPMENT", 13, 43303},
	{"MUSTARD", 7, 43304},
	{"STRAIT", 6, 43305},
	{"MASTERPIECE", 11, 43306},
	{"TUPO", 4, 43307},
	{"OBEY", 4, 43308},
	{"CELLPHONE", 9, 43309},
	{"DONKEY", 6, 43310},
	{"DYCO", 4, 43311},
	{"EWSF", 4, 43312},
	{"BEFR", 4, 43313},
	{"JACKS", 5, 43314},
	{"LYJU", 4, 43315},
	{"NGJA", 4, 43316},
	{"CONCEIVED", 9, 43317},
	{"TRIGGERED", 9, 43318},
	{"BOASTS", 6, 43319},
	{"PRAYING", 7, 43320},
	{"GEDP", 4, 43321},
	{"OPPR", 4, 43322},
	{"MULTIPLY", 8, 43323},
	{"YISL", 4, 43324},
	{"FRONTGATE", 9, 43325},
	{"RADIAL", 6, 43326},
	{"WERL", 4, 43327},
	{"NTYF", 4, 43328},
	{"DCER", 4, 43329},
	{"MARE", 4, 43330},
	{"INSTRUCTED", 10, 43331},
	{"STOLE", 5, 43332},
	{"KIRBY", 5, 43333},
	{"WOLV", 4, 43334},
	{"ARMOUR", 6, 43335},
	{"CHPE", 4, 43336},
	{"SUMMARIZED", 10, 43337},
	{"AVALANCHE", 9, 43338},
	{"TVAR", 4, 43339},
	{"RWES", 4, 43340},
	{"IRDB", 4, 43341},
	{"NORTHAMPTON", 11, 43342},
	{"UPLOADING", 9, 43343},
	{"HMUS", 4, 43344},
	{"MANUSCRIPTS", 11, 43345},
	{"IXOF", 4, 43346},
	{"LETM", 4, 43347},
	{"MANAGERIAL", 10, 43348},
	{"HRIL", 4, 43349},
	{"CARY", 4, 43350},
	{"YSYS", 4, 43351},
	{"VAGE", 4, 43352},
	{"TARB", 4, 43353},
	{"CELINE", 6, 43354},
	{"EXHIBITED", 9, 43355},
	{"DISCIPLES", 9, 43356},
	{"SHAVING", 7, 43357},
	{"LKEE", 4, 43358},
	{"QUOR", 4, 43359},
	{"FINEPIX", 7, 43360},
	{"BISHOPS", 7, 43361},
	{"XTDA", 4, 43362},
	{"USOR", 4, 43363},
	{"DESTROYING", 10, 43364},
	{"HUMOROUS", 8, 43365},
	{"TSPU", 4, 43366},
	{"TONNES", 6, 43367},
	{"HYPERMAIL", 9, 43368},
	{"NDSK", 4, 43369},
	{"RLAW", 4, 43370},
	{"NLIM", 4, 43371},
	{"GASW", 4, 43372},
	{"THUNDERBIRD", 11, 43373},
	{"LGEN", 4, 43374},
	{"OURK", 4, 43375},
	{"UALB", 4, 43376},
	{"CORONA", 6, 43377},
	{"YTRU", 4, 43378},
	{"GRIFFITH", 8, 43379},
	{"INVESTIGATIVE", 13, 43380},
	{"LETRAS", 6, 43381},
	{"BYLAWS", 6, 43382},
	{"SDOU", 4, 43383},
	{"ERECTION", 8, 43384},
	{"QUASI", 5, 43385},
	{"WMV", 3, 43386},
	{"ENERGETIC", 9, 43387},
	{"DISTURBANCE", 11, 43388},
	{"SAUNDERS", 8, 43389},
	{"RIBBONS", 7, 43390},
	{"UALD", 4, 43391},
	{"UMET", 4, 43392},
	{"FACESITTING", 11, 43393},
	{"RGLA", 4, 43394},
	{"EXILE", 5, 43395},
	{"MEDP", 4, 43396},
	{"LGOO", 4, 43397},
	{"WGY", 3, 43398},
	{"BREASTFEEDING", 13, 43399},
	{"UPAL", 4, 43400},
	{"BILDER", 6, 43401},
	{"RESIDE", 6, 43402},
	{"MCCARTNEY", 9, 43403},
	{"ANGLO", 5, 43404},
	{"LLEF", 4, 43405},
	{"CASHIER", 7, 43406},
	{"LENB", 4, 43407},
	{"KATHRYN", 7, 43408},
	{"DEOR", 4, 43409},
	{"FMAT", 4, 43410},
	{"BUTTERFLIES", 11, 43411},
	{"RANDOMIZED", 10, 43412},
	{"KNOTS", 5, 43413},
	{"FLEA", 4, 43414},
	{"FIMP", 4, 43415},
	{"AGEG", 4, 43416},
	{"MOTIVATIONAL", 12, 43417},
	{"OFFENCES", 8, 43418},
	{"HLAR", 4, 43419},
	{"PALS", 4, 43420},
	{"GRATUITE", 8, 43421},
	{"GERRY", 5, 43422},
	{"TAXR", 4, 43423},
	{"LLRA", 4, 43424},
	{"OLDL", 4, 43425},
	{"CELEBRATES", 10, 43426},
	{"LLCR", 4, 43427},
	{"ARMENIAN", 8, 43428},
	{"LONGITUDINAL", 12, 43429},
	{"OALB", 4, 43430},
	{"HISTORIANS", 10, 43431},
	{"REALITIES", 9, 43432},
	{"KAPPA", 5, 43433},
	{"MENTIONS", 8, 43434},
	{"SAMSON", 6, 43435},
	{"NEUROSCIENCE", 12, 43436},
	{"BLENDER", 7, 43437},
	{"JUMPS", 5, 43438},
	{"FLEMING", 7, 43439},
	{"FFLO", 4, 43440},
	{"BYBR", 4, 43441},
	{"BLASTER", 7, 43442},
	{"YORD", 4, 43443},
	{"DDAT", 4, 43444},
	{"TVIR", 4, 43445},
	{"REMEDIATION", 11, 43446},
	{"WASTING", 7, 43447},
	{"DECODER", 7, 43448},
	{"FELO", 4, 43449},
	{"GENOCIDE", 8, 43450},
	{"ACCLAIMED", 9, 43451},
	{"HEATHROW", 8, 43452},
	{"INDY", 4, 43453},
	{"URWI", 4, 43454},
	{"MORROW", 6, 43455},
	{"PANTERA", 7, 43456},
	{"GLITTER", 7, 43457},
	{"GIOVANNI", 8, 43458},
	{"OCKY", 4, 43459},
	{"SIDEBAR", 7, 43460},
	{"AUTHORED", 8, 43461},
	{"LASTED", 6, 43462},
	{"RAOR", 4, 43463},
	{"SNOOP", 5, 43464},
	{"AWHILE", 6, 43465},
	{"CKEL", 4, 43466},
	{"WINERY", 6, 43467},
	{"HYAR", 4, 43468},
	{"YSUN", 4, 43469},
	{"OWSF", 4, 43470},
	{"KEDD", 4, 43471},
	{"GOFH", 4, 43472},
	{"YVIS", 4, 43473},
	{"SCALED", 6, 43474},
	{"LLUP", 4, 43475},
	{"YABL", 4, 43476},
	{"CONTINGENCY", 11, 43477},
	{"PHOTON", 6, 43478},
	{"RKWH", 4, 43479},
	{"WILTSHIRE", 9, 43480},
	{"IXYE", 4, 43481},
	{"VAGUE", 5, 43482},
	{"DDIF", 4, 43483},
	{"OVERLAY", 7, 43484},
	{"ICBE", 4, 43485},
	{"FXF", 3, 43486},
	{"WRAPS", 5, 43487},
	{"DNTR", 4, 43488},
	{"SYAR", 4, 43489},
	{"CONSTITUENTS", 12, 43490},
	{"RUSTY", 5, 43491},
	{"PHARMA", 6, 43492},
	{"HERD", 4, 43493},
	{"MBEN", 4, 43494},
	{"HANDICAPPED", 11, 43495},
	{"GBEA", 4, 43496},
	{"OMFI", 4, 43497},
	{"BIDD", 4, 43498},
	{"RSGO", 4, 43499},
	{"ORJA", 4, 43500},
	{"OARR", 4, 43501},
	{"EXPORTED", 8, 43502},
	{"GMUS", 4, 43503},
	{"FAYETTEVILLE", 12, 43504},
	{"CHAMPAIGN", 9, 43505},
	{"RSRA", 4, 43506},
	{"WARNS", 5, 43507},
	{"EYKN", 4, 43508},
	{"EGEL", 4, 43509},
	{"DLAU", 4, 43510},
	{"PAKISTANI", 9, 43511},
	{"HARMLESS", 8, 43512},
	{"GHRE", 4, 43513},
	{"STING", 5, 43514},
	{"ELFF", 4, 43515},
	{"URBANA", 6, 43516},
	{"BRAVO", 5, 43517},
	{"BELIEVERS", 9, 43518},
	{"IMWH", 4, 43519},
	{"GUEC", 4, 43520},
	{"SECSG", 5, 43521},
	{"FRANCO", 6, 43522},
	{"ANNOUNCING", 10, 43523},
	{"NUEL", 4, 43524},
	{"RDSR", 4, 43525},
	{"DISPERSION", 10, 43526},
	{"TRIVIUM", 7, 43527},
	{"SHOWROOM", 8, 43528},
	{"SWAROVSKI", 9, 43529},
	{"FEWI", 4, 43530},
	{"RESTING", 7, 43531},
	{"MISSILES", 8, 43532},
	{"PERSISTENCE", 11, 43533},
	{"COARSE", 6, 43534},
	{"CONTINENTS", 10, 43535},
	{"FBRO", 4, 43536},
	{"LITER", 5, 43537},
	{"EYCH", 4, 43538},
	{"CARPETS", 7, 43539},
	{"GHDE", 4, 43540},
	{"ARCR", 4, 43541},
	{"CHGR", 4, 43542},
	{"UDYO", 4, 43543},
	{"LBAR", 4, 43544},
	{"ORDL", 4, 43545},
	{"SUBMARINE", 9, 43546},
	{"BEBU", 4, 43547},
	{"BLESSINGS", 9, 43548},
	{"LERB", 4, 43549},
	{"BRENDAN", 7, 43550},
	{"PREVAILING", 10, 43551},
	{"ORIGINATED", 10, 43552},
	{"UTGO", 4, 43553},
	{"EWOL", 4, 43554},
	{"RABR", 4, 43555},
	{"CONDOSAVER", 10, 43556},
	{"FAGR", 4, 43557},
	{"SCULPTURES", 10, 43558},
	{"RFIG", 4, 43559},
	{"AMEX", 4, 43560},
	{"INTRINSIC", 9, 43561},
	{"CLASSICVACATIONS", 16, 43562},
	{"DPIT", 4, 43563},
	{"BLACKPOOL", 9, 43564},
	{"THOUGHTFUL", 10, 43565},
	{"NICHT", 5, 43566},
	{"ARCHER", 6, 43567},
	{"AMWO", 4, 43568},
	{"UTUP", 4, 43569},
	{"RDIC", 4, 43570},
	{"HERTFORDSHIRE", 13, 43571},
	{"INUYASHA", 8, 43572},
	{"YDEL", 4, 43573},
	{"RVEH", 4, 43574},
	{"NOMINEES", 8, 43575},
	{"OFOV", 4, 43576},
	{"AHUM", 4, 43577},
	{"WARMER", 6, 43578},
	{"CUZ", 3, 43579},
	{"GHPO", 4, 43580},
	{"BEWO", 4, 43581},
	{"VIEWSONIC", 9, 43582},
	{"DRYERS", 6, 43583},
	{"YCHR", 4, 43584},
	{"CALF", 4, 43585},
	{"ODUL", 4, 43586},
	{"FUJIFILM", 8, 43587},
	{"BASIL", 5, 43588},
	{"ZEDF", 4, 43589},
	{"OLOW", 4, 43590},
	{"AYJU", 4, 43591},
	{"HALLMARK", 8, 43592},
	{"COUNTERPARTS", 12, 43593},
	{"PACED", 5, 43594},
	{"NYPO", 4, 43595},
	{"EUNL", 4, 43596},
	{"ENGL", 4, 43597},
	{"RTBY", 4, 43598},
	{"GROUPED", 7, 43599},
	{"RDOR", 4, 43600},
	{"RDPL", 4, 43601},
	{"EMFR", 4, 43602},
	{"RMAG", 4, 43603},
	{"ASIANS", 6, 43604},
	{"LROO", 4, 43605},
	{"ORIENT", 6, 43606},
	{"OFEU", 4, 43607},
	{"CONTRA", 6, 43608},
	{"DAMAGING", 8, 43609},
	{"POPULATED", 9, 43610},
	{"HLIK", 4, 43611},
	{"SEETHER", 7, 43612},
	{"RENEE", 5, 43613},
	{"BOILING", 7, 43614},
	{"JOURNEYS", 8, 43615},
	{"EADJ", 4, 43616},
	{"MILESTONES", 10, 43617},
	{"PARKINSON", 9, 43618},
	{"ALFW", 4, 43619},
	{"OLAU", 4, 43620},
	{"PARSING", 7, 43621},
	{"EARU", 4, 43622},
	{"SPLITTING", 9, 43623},
	{"ORBL", 4, 43624},
	{"MCLEAN", 6, 43625},
	{"DERBYSHIRE", 10, 43626},
	{"RYMI", 4, 43627},
	{"CHECKBOXES", 10, 43628},
	{"LYRU", 4, 43629},
	{"HEUL", 4, 43630},
	{"YDUE", 4, 43631},
	{"DWEW", 4, 43632},
	{"LOBBYING", 8, 43633},
	{"DRAD", 4, 43634},
	{"RAVE", 4, 43635},
	{"HFRE", 4, 43636},
	{"MANJ", 4, 43637},
	{"MGM", 3, 43638},
	{"CIGARS", 6, 43639},
	{"CINEMAS", 7, 43640},
	{"SROB", 4, 43641},
	{"ISLANDER", 8, 43642},
	{"CHBI", 4, 43643},
	{"ENCODER", 7, 43644},
	{"NICOLAS", 7, 43645},
	{"APUR", 4, 43646},
	{"USME", 4, 43647},
	{"INFERENCE", 9, 43648},
	{"RECALLED", 8, 43649},
	{"CYIS", 4, 43650},
	{"LFRA", 4, 43651},
	{"IMPORTERS", 9, 43652},
	{"IMPRESSUM", 9, 43653},
	{"TRANSFORMER", 11, 43654},
	{"LLPU", 4, 43655},
	{"WEISS", 5, 43656},
	{"DECLARATIONS", 12, 43657},
	{"YWEE", 4, 43658},
	{"CHATTANOOGA", 11, 43659},
	{"GILES", 5, 43660},
	{"OWBA", 4, 43661},
	{"MAROON", 6, 43662},
	{"DRAFTS", 6, 43663},
	{"LNOW", 4, 43664},
	{"EXCURSIONS", 10, 43665},
	{"JERK", 4, 43666},
	{"KONTAKT", 7, 43667},
	{"FDEA", 4, 43668},
	{"SHACK", 5, 43669},
	{"MARROW", 6, 43670},
	{"KAWASAKI", 8, 43671},
	{"OPOW", 4, 43672},
	{"LICENCES", 8, 43673},
	{"TAVERN", 6, 43674},
	{"BATHING", 7, 43675},
	{"LAMBERT", 7, 43676},
	{"USWE", 4, 43677},
	{"EPILEPSY", 8, 43678},
	{"ALLOWANCES", 10, 43679},
	{"OCLI", 4, 43680},
	{"FOUNTAINS", 9, 43681},
	{"UNGW", 4, 43682},
	{"FPOW", 4, 43683},
	{"GOGGLES", 7, 43684},
	{"UVEN", 4, 43685},
	{"LEIG", 4, 43686},
	{"CLONES", 6, 43687},
	{"FOREGOING", 9, 43688},
	{"CROSSOVER", 9, 43689},
	{"SPECIFICITY", 11, 43690},
	{"ERMC", 4, 43691},
	{"CERTAINTY", 9, 43692},
	{"SLEEK", 5, 43693},
	{"GERARD", 6, 43694},
	{"UPLA", 4, 43695},
	{"RUNOFF", 6, 43696},
	{"YIDE", 4, 43697},
	{"OSTEOPOROSIS", 12, 43698},
	{"DUPB", 4, 43699},
	{"APPROVALS", 9, 43700},
	{"ANTARCTIC", 9, 43701},
	{"SUCCESSIVE", 10, 43702},
	{"NEGLECTED", 9, 43703},
	{"UEDE", 4, 43704},
	{"RISF", 4, 43705},
	{"ARIEL", 5, 43706},
	{"MEEV", 4, 43707},
	{"MONTY", 5, 43708},
	{"TYMO", 4, 43709},
	{"CAFES", 5, 43710},
	{"JUKEBOX", 7, 43711},
	{"URYO", 4, 43712},
	{"CLASSMATES", 10, 43713},
	{"HITCH", 5, 43714},
	{"LDTE", 4, 43715},
	{"DMEE", 4, 43716},
	{"FRACTURE", 8, 43717},
	{"NEXUS", 5, 43718},
	{"WELV", 4, 43719},
	{"CANCERS", 7, 43720},
	{"VEDC", 4, 43721},
	{"DBEO", 4, 43722},
	{"FOREMOST", 8, 43723},
	{"TYYE", 4, 43724},
	{"NINETEENTH", 10, 43725},
	{"MAPR", 4, 43726},
	{"FCEN", 4, 43727},
	{"AIDJ", 4, 43728},
	{"CHESAPEAKE", 10, 43729},
	{"TANGO", 5, 43730},
	{"LICR", 4, 43731},
	{"MELTING", 7, 43732},
	{"MAHOGANY", 8, 43733},
	{"DSEP", 4, 43734},
	{"ACTRESSES", 9, 43735},
	{"CLARENCE", 8, 43736},
	{"ERNST", 5, 43737},
	{"NEGL", 4, 43738},
	{"GARNER", 6, 43739},
	{"BUSTER", 6, 43740},
	{"ELAX", 4, 43741},
	{"MODERATED", 9, 43742},
	{"NASSAU", 6, 43743},
	{"FLAP", 4, 43744},
	{"AKOF", 4, 43745},
	{"EYLA", 4, 43746},
	{"IGNORANT", 8, 43747},
	{"ALLOWABLE", 9, 43748},
	{"KARATE", 6, 43749},
	{"NMOU", 4, 43750},
	{"COMPOSITIONS", 12, 43751},
	{"CEPE", 4, 43752},
	{"SINGS", 5, 43753},
	{"AYAC", 4, 43754},
	{"MARCOS", 6, 43755},
	{"SORROW", 6, 43756},
	{"ETLY", 4, 43757},
	{"CWIT", 4, 43758},
	{"ORDM", 4, 43759},
	{"CARTE", 5, 43760},
	{"UPTC", 4, 43761},
	{"AYAP", 4, 43762},
	{"HCLA", 4, 43763},
	{"CANNED", 6, 43764},
	{"COLLECTS", 8, 43765},
	{"TREATIES", 8, 43766},
	{"ENDURANCE", 9, 43767},
	{"GETU", 4, 43768},
	{"OPTIMIZING", 10, 43769},
	{"LLGI", 4, 43770},
	{"SWITCHFOOT", 10, 43771},
	{"DMER", 4, 43772},
	{"COLDPLAY", 8, 43773},
	{"INSULATED", 9, 43774},
	{"CKFI", 4, 43775},
	{"UTTR", 4, 43776},
	{"DUPONT", 6, 43777},
	{"GSPO", 4, 43778},
	{"HARRIET", 7, 43779},
	{"PHILOSOPHER", 11, 43780},
	{"RECTANGLE", 9, 43781},
	{"PEDC", 4, 43782},
	{"QUEER", 5, 43783},
	{"PAINS", 5, 43784},
	{"VIOXX", 5, 43785},
	{"HSUC", 4, 43786},
	{"DECATUR", 7, 43787},
	{"WRAPPER", 7, 43788},
	{"BECL", 4, 43789},
	{"AHMED", 5, 43790},
	{"BUCHANAN", 8, 43791},
	{"DRUMMER", 7, 43792},
	{"BYTR", 4, 43793},
	{"SOBRE", 5, 43794},
	{"CELEXA", 6, 43795},
	{"GESB", 4, 43796},
	{"NOGR", 4, 43797},
	{"GUITARIST", 9, 43798},
	{"CKBO", 4, 43799},
	{"FHAV", 4, 43800},
	{"SYMMETRIC", 9, 43801},
	{"CEREMONIES", 10, 43802},
	{"TORL", 4, 43803},
	{"YQUE", 4, 43804},
	{"SATISFIES", 9, 43805},
	{"KUALA", 5, 43806},
	{"CILM", 4, 43807},
	{"APPELLATE", 9, 43808},
	{"COMMA", 5, 43809},
	{"LUXU", 4, 43810},
	{"NOFU", 4, 43811},
	{"BBB", 3, 43812},
	{"GEEKS", 5, 43813},
	{"CONFORMITY", 10, 43814},
	{"AVANT", 5, 43815},
	{"GBOT", 4, 43816},
	{"REPEC", 5, 43817},
	{"INSIGHTFUL", 10, 43818},
	{"SUPPER", 6, 43819},
	{"FULFILLING", 10, 43820},
	{"NBYS", 4, 43821},
	{"IRFR", 4, 43822},
	{"HOODED", 6, 43823},
	{"UTGE", 4, 43824},
	{"LBRE", 4, 43825},
	{"UNRATED", 7, 43826},
	{"RESR", 4, 43827},
	{"COUV", 4, 43828},
	{"DIVA", 4, 43829},
	{"ADSENSE", 7, 43830},
	{"YSFI", 4, 43831},
	{"BYUS", 4, 43832},
	{"INSTABILITY", 11, 43833},
	{"LEFE", 4, 43834},
	{"SEMINARY", 8, 43835},
	{"EXEMPTIONS", 10, 43836},
	{"INTEGRATES", 10, 43837},
	{"LSKI", 4, 43838},
	{"PRESENTER", 9, 43839},
	{"ADCH", 4, 43840},
	{"KSAG", 4, 43841},
	{"YDIR", 4, 43842},
	{"NDNU", 4, 43843},
	{"LGIV", 4, 43844},
	{"UMIG", 4, 43845},
	{"CEAF", 4, 43846},
	{"OFFENSES", 8, 43847},
	{"HGRO", 4, 43848},
	{"EMULATION", 9, 43849},
	{"LENGTHY", 7, 43850},
	{"SONATA", 6, 43851},
	{"WYV", 3, 43852},
	{"FORTRESS", 8, 43853},
	{"CONTIGUOUS", 10, 43854},
	{"DBLU", 4, 43855},
	{"BOOKSTORES", 10, 43856},
	{"LSEL", 4, 43857},
	{"NIPU", 4, 43858},
	{"PEREZ", 5, 43859},
	{"CIMEL", 5, 43860},
	{"LOPA", 4, 43861},
	{"INACCURATE", 10, 43862},
	{"MNOR", 4, 43863},
	{"YACH", 4, 43864},
	{"HORU", 4, 43865},
	{"HVAC", 4, 43866},
	{"EXPLANATORY", 11, 43867},
	{"LEICA", 5, 43868},
	{"ADDT", 4, 43869},
	{"DCOV", 4, 43870},
	{"SETTLERS", 8, 43871},
	{"OMEK", 4, 43872},
	{"STOOLS", 6, 43873},
	{"MINISTERIAL", 11, 43874},
	{"XAVIER", 6, 43875},
	{"AGENDAS", 7, 43876},
	{"YNIC", 4, 43877},
	{"TORAH", 5, 43878},
	{"HBRI", 4, 43879},
	{"AMAB", 4, 43880},
	{"PUBLISHES", 9, 43881},
	{"STACKS", 6, 43882},
	{"VECR", 4, 43883},
	{"RRYH", 4, 43884},
	{"OWNING", 6, 43885},
	{"HBAC", 4, 43886},
	{"ANDERSEN", 8, 43887},
	{"UWU", 3, 43888},
	{"OVAR", 4, 43889},
	{"BUSCH", 5, 43890},
	{"TGAR", 4, 43891},
	{"TOGU", 4, 43892},
	{"MYCA", 4, 43893},
	{"ARMANI", 6, 43894},
	{"BEIJ", 4, 43895},
	{"HOFW", 4, 43896},
	{"BIPOLAR", 7, 43897},
	{"SERMON", 6, 43898},
	{"HCAM", 4, 43899},
	{"LEXE", 4, 43900},
	{"DSDE", 4, 43901},
	{"JORP", 4, 43902},
	{"EEKB", 4, 43903},
	{"MWHA", 4, 43904},
	{"YMAI", 4, 43905},
	{"FACILITATING", 12, 43906},
	{"COMPLAINED", 10, 43907},
	{"URYW", 4, 43908},
	{"UNTF", 4, 43909},
	{"FERDINAND", 9, 43910},
	{"ORCU", 4, 43911},
	{"HEDL", 4, 43912},
	{"LUET", 4, 43913},
	{"WEDU", 4, 43914},
	{"ULIE", 4, 43915},
	{"BADG", 4, 43916},
	{"DNTK", 4, 43917},
	{"ALOB", 4, 43918},
	{"THRILL", 6, 43919},
	{"LTYA", 4, 43920},
	{"LAGOON", 6, 43921},
	{"UNDOUBTEDLY", 11, 43922},
	{"MENOPAUSE", 9, 43923},
	{"UKRA", 4, 43924},
	{"ONDG", 4, 43925},
	{"RCHH", 4, 43926},
	{"INBOUND", 7, 43927},
	{"WITHHELD", 8, 43928},
	{"INSISTED", 8, 43929},
	{"RESY", 4, 43930},
	{"SHORTLIST", 9, 43931},
	{"UTUA", 4, 43932},
	{"SJUN", 4, 43933},
	{"GAINESVILLE", 11, 43934},
	{"TIAVA", 5, 43935},
	{"RDHE", 4, 43936},
	{"ECLECTIC", 8, 43937},
	{"HEADPHONE", 9, 43938},
	{"GSFR", 4, 43939},
	{"REGIMES", 7, 43940},
	{"GRIE", 4, 43941},
	{"HEADACHES", 9, 43942},
	{"RUGB", 4, 43943},
	{"RAMSEY", 6, 43944},
	{"NKAR", 4, 43945},
	{"KERC", 4, 43946},
	{"RDEB", 4, 43947},
	{"README", 6, 43948},
	{"ALJO", 4, 43949},
	{"PIGEON", 6, 43950},
	{"RIVALS", 6, 43951},
	{"FREED", 5, 43952},
	{"BINDER", 6, 43953},
	{"TSDU", 4, 43954},
	{"XEMACS", 6, 43955},
	{"CONSTRAINED", 11, 43956},
	{"PARROT", 6, 43957},
	{"MAGNUM", 6, 43958},
	{"YWEI", 4, 43959},
	{"INVOKED", 7, 43960},
	{"YNEV", 4, 43961},
	{"INVALUABLE", 10, 43962},
	{"HELICOPTERS", 11, 43963},
	{"EBED", 4, 43964},
	{"YSCR", 4, 43965},
	{"NCEU", 4, 43966},
	{"KEYSTONE", 8, 43967},
	{"INCLINED", 8, 43968},
	{"UBMA", 4, 43969},
	{"GALA", 4, 43970},
	{"YCOO", 4, 43971},
	{"INTERCONTINENTAL", 16, 43972},
	{"MSCH", 4, 43973},
	{"TRACTION", 8, 43974},
	{"UTTERLY", 7, 43975},
	{"WORKSPACE", 9, 43976},
	{"NYBE", 4, 43977},
	{"CUSTOMIZABLE", 12, 43978},
	{"SOFTCOVER", 9, 43979},
	{"GAVIN", 5, 43980},
	{"ILLUMINATED", 11, 43981},
	{"REALTIME", 8, 43982},
	{"LASTS", 5, 43983},
	{"PTHR", 4, 43984},
	{"GLOUCESTERSHIRE", 15, 43985},
	{"ELECTRONS", 9, 43986},
	{"STFL", 4, 43987},
	{"OUSY", 4, 43988},
	{"NAFG", 4, 43989},
	{"CLAUDIA", 7, 43990},
	{"PERPETUAL", 9, 43991},
	{"YEDS", 4, 43992},
	{"SUBSYSTEM", 9, 43993},
	{"APPL", 4, 43994},
	{"YHOP", 4, 43995},
	{"EUSC", 4, 43996},
	{"KINETIC", 7, 43997},
	{"CAFFEINE", 8, 43998},
	{"LSWO", 4, 43999},
	{"DDOU", 4, 44000},
	{"SOLICITOR", 9, 44001},
	{"CLUSTERING", 10, 44002},
	{"LEBL", 4, 44003},
	{"GSUR", 4, 44004},
	{"RNFR", 4, 44005},
	{"GONC", 4, 44006},
	{"TBOR", 4, 44007},
	{"KFAS", 4, 44008},
	{"MWOU", 4, 44009},
	{"VUJ", 3, 44010},
	{"UMOU", 4, 44011},
	{"GONW", 4, 44012},
	{"WLER", 4, 44013},
	{"VERBATIM", 8, 44014},
	{"LDGI", 4, 44015},
	{"INNOCENCE", 9, 44016},
	{"ODCA", 4, 44017},
	{"CHBR", 4, 44018},
	{"HTTPD", 5, 44019},
	{"QUICKER", 7, 44020},
	{"RMEL", 4, 44021},
	{"GRANDPARENTS", 12, 44022},
	{"RTHM", 4, 44023},
	{"DEAW", 4, 44024},
	{"RADL", 4, 44025},
	{"RDHI", 4, 44026},
	{"AYRO", 4, 44027},
	{"CARDBOARD", 9, 44028},
	{"ATTRIBUTABLE", 12, 44029},
	{"EORB", 4, 44030},
	{"SKETCHES", 8, 44031},
	{"YERC", 4, 44032},
	{"RFAV", 4, 44033},
	{"UYTH", 4, 44034},
	{"KEDC", 4, 44035},
	{"ANGELO", 6, 44036},
	{"TERTIARY", 8, 44037},
	{"RDBU", 4, 44038},
	{"LICW", 4, 44039},
	{"EXHAUSTED", 9, 44040},
	{"SMARTER", 7, 44041},
	{"GNUM", 4, 44042},
	{"RPIE", 4, 44043},
	{"GBAS", 4, 44044},
	{"SLAC", 4, 44045},
	{"SHELTERS", 8, 44046},
	{"GYTH", 4, 44047},
	{"ATTAIN", 6, 44048},
	{"DORA", 4, 44049},
	{"CALORIE", 7, 44050},
	{"INCONVENIENCE", 13, 44051},
	{"IRBU", 4, 44052},
	{"EGUE", 4, 44053},
	{"GRAPHITE", 8, 44054},
	{"NTYW", 4, 44055},
	{"VACCINATION", 11, 44056},
	{"STROLLER", 8, 44057},
	{"FARTHER", 7, 44058},
	{"BOWEL", 5, 44059},
	{"SWEATERS", 8, 44060},
	{"CHATS", 5, 44061},
	{"MAFIA", 5, 44062},
	{"LSUC", 4, 44063},
	{"AYAG", 4, 44064},
	{"FUTUNA", 6, 44065},
	{"MANDARIN", 8, 44066},
	{"IMFR", 4, 44067},
	{"DUNGEON", 7, 44068},
	{"PREDICTABLE", 11, 44069},
	{"UTFA", 4, 44070},
	{"GERMANS", 7, 44071},
	{"LILLY", 5, 44072},
	{"SHIRE", 5, 44073},
	{"KEAM", 4, 44074},
	{"SUSCEPTIBLE", 11, 44075},
	{"MOSQUITO", 8, 44076},
	{"GLEG", 4, 44077},
	{"RRYW", 4, 44078},
	{"MSFR", 4, 44079},
	{"FEWP", 4, 44080},
	{"KASHMIR", 7, 44081},
	{"TOML", 4, 44082},
	{"INSEST", 6, 44083},
	{"LYONS", 5, 44084},
	{"SKYLINE", 7, 44085},
	{"SULFUR", 6, 44086},
	{"UMUL", 4, 44087},
	{"SCAMS", 5, 44088},
	{"LIPID", 5, 44089},
	{"PUTNAM", 6, 44090},
	{"CORPSE", 6, 44091},
	{"MING", 4, 44092},
	{"NROM", 4, 44093},
	{"EDCU", 4, 44094},
	{"QUOT", 4, 44095},
	{"YSDE", 4, 44096},
	{"BYIS", 4, 44097},
	{"RITZ", 4, 44098},
	{"NETWORKED", 9, 44099},
	{"NEYG", 4, 44100},
	{"LOCALHOST", 9, 44101},
	{"LUSH", 4, 44102},
	{"BARRELS", 7, 44103},
	{"TRANSFORMATIONS", 15, 44104},
	{"UNGC", 4, 44105},
	{"BEFA", 4, 44106},
	{"UELT", 4, 44107},
	{"CABLING", 7, 44108},
	{"ANALOGUE", 8, 44109},
	{"EDSL", 4, 44110},
	{"CROA", 4, 44111},
	{"WERNER", 6, 44112},
	{"CLYDE", 5, 44113},
	{"STILLS", 6, 44114},
	{"PERIMETER", 9, 44115},
	{"BIASED", 6, 44116},
	{"CARDIOLOGY", 10, 44117},
	{"HONORARY", 8, 44118},
	{"PEDD", 4, 44119},
	{"IRWIN", 5, 44120},
	{"BREWER", 6, 44121},
	{"CHIANG", 6, 44122},
	{"EXCHANGED", 9, 44123},
	{"SUPO", 4, 44124},
	{"FCHE", 4, 44125},
	{"PAYLOAD", 7, 44126},
	{"UGEE", 4, 44127},
	{"OUPR", 4, 44128},
	{"ADHERE", 6, 44129},
	{"RSMU", 4, 44130},
	{"RBEG", 4, 44131},
	{"DWEE", 4, 44132},
	{"FRAN", 4, 44133},
	{"LYSM", 4, 44134},
	{"MERRILL", 7, 44135},
	{"RCHP", 4, 44136},
	{"OLDSMOBILE", 10, 44137},
	{"GRILLED", 7, 44138},
	{"RORD", 4, 44139},
	{"OKYO", 4, 44140},
	{"OMOB", 4, 44141},
	{"LBUR", 4, 44142},
	{"RAFAEL", 6, 44143},
	{"UMMO", 4, 44144},
	{"CCC", 3, 44145},
	{"ENQUIRE", 7, 44146},
	{"HWAL", 4, 44147},
	{"TOILETS", 7, 44148},
	{"MAINS", 5, 44149},
	{"WHALES", 6, 44150},
	{"ENRU", 4, 44151},
	{"MISTY", 5, 44152},
	{"LINDSEY", 7, 44153},
	{"PARITY", 6, 44154},
	{"PARTITIONS", 10, 44155},
	{"ELRO", 4, 44156},
	{"KZU", 3, 44157},
	{"GRIM", 4, 44158},
	{"LEOU", 4, 44159},
	{"CONSERVED", 9, 44160},
	{"SEARCHSEARCH", 12, 44161},
	{"GDON", 4, 44162},
	{"HUBBARD", 7, 44163},
	{"REGG", 4, 44164},
	{"UEDB", 4, 44165},
	{"REWRITE", 7, 44166},
	{"UPAG", 4, 44167},
	{"HJUS", 4, 44168},
	{"VENDING", 7, 44169},
	{"PRISM", 5, 44170},
	{"DSME", 4, 44171},
	{"DGIR", 4, 44172},
	{"CHASING", 7, 44173},
	{"KEYGEN", 6, 44174},
	{"INDF", 4, 44175},
	{"JANEIRO", 7, 44176},
	{"FLOP", 4, 44177},
	{"OLWA", 4, 44178},
	{"UXUR", 4, 44179},
	{"AGGREGATION", 11, 44180},
	{"SHELLEY", 7, 44181},
	{"RKTI", 4, 44182},
	{"BATTING", 7, 44183},
	{"BORROWED", 8, 44184},
	{"EMSF", 4, 44185},
	{"URFR", 4, 44186},
	{"NERP", 4, 44187},
	{"RBOY", 4, 44188},
	{"RESTS", 5, 44189},
	{"RARC", 4, 44190},
	{"LDEX", 4, 44191},
	{"RBYA", 4, 44192},
	{"PRENTICE", 8, 44193},
	{"DEPICTED", 8, 44194},
	{"PROPOSING", 9, 44195},
	{"MSAL", 4, 44196},
	{"CKSP", 4, 44197},
	{"LDRO", 4, 44198},
	{"WINDING", 7, 44199},
	{"DIAZ", 4, 44200},
	{"RIPPED", 6, 44201},
	{"LFIG", 4, 44202},
	{"VEGAN", 5, 44203},
	{"CONGRESSMAN", 11, 44204},
	{"COBALT", 6, 44205},
	{"PITY", 4, 44206},
	{"LTOC", 4, 44207},
	{"RECOMBINANT", 11, 44208},
	{"UBUNTU", 6, 44209},
	{"DOWNWARD", 8, 44210},
	{"SUPERSTAR", 9, 44211},
	{"EYOR", 4, 44212},
	{"REHU", 4, 44213},
	{"TTYM", 4, 44214},
	{"CLOSEOUT", 8, 44215},
	{"COREL", 5, 44216},
	{"RIAR", 4, 44217},
	{"KAYAKING", 8, 44218},
	{"SYNERGY", 7, 44219},
	{"EIRJ", 4, 44220},
	{"CATALOGUES", 10, 44221},
	{"ASPIRE", 6, 44222},
	{"EELC", 4, 44223},
	{"NCEJ", 4, 44224},
	{"YOCC", 4, 44225},
	{"HARVESTING", 10, 44226},
	{"GARFIELD", 8, 44227},
	{"MPSH", 4, 44228},
	{"GROOM", 5, 44229},
	{"JEWELS", 6, 44230},
	{"SATURATED", 9, 44231},
	{"GEORGES", 7, 44232},
	{"DBOA", 4, 44233},
	{"BACKPACKING", 11, 44234},
	{"WASQ", 4, 44235},
	{"QUINCY", 6, 44236},
	{"WWHO", 4, 44237},
	{"ACCIDENTALLY", 12, 44238},
	{"DOUGHTY", 7, 44239},
	{"ARFU", 4, 44240},
	{"BONDED", 6, 44241},
	{"DDEB", 4, 44242},
	{"STICKING", 8, 44243},
	{"DUDLEY", 6, 44244},
	{"OSAMA", 5, 44245},
	{"ILDW", 4, 44246},
	{"WEEDS", 5, 44247},
	{"STRIPPED", 8, 44248},
	{"OPRAH", 5, 44249},
	{"PKIN", 4, 44250},
	{"INFLATABLE", 10, 44251},
	{"BEERS", 5, 44252},
	{"CLIVE", 5, 44253},
	{"FIXTURE", 7, 44254},
	{"YEDH", 4, 44255},
	{"GLASSWARE", 9, 44256},
	{"UUZ", 3, 44257},
	{"WFUL", 4, 44258},
	{"CANARY", 6, 44259},
	{"IMAGINED", 8, 44260},
	{"DEAV", 4, 44261},
	{"DARBY", 5, 44262},
	{"HOWR", 4, 44263},
	{"WOKE", 4, 44264},
	{"FILLS", 5, 44265},
	{"GWRI", 4, 44266},
	{"PROPORTIONS", 11, 44267},
	{"IDOU", 4, 44268},
	{"GRIPS", 5, 44269},
	{"CLERGY", 6, 44270},
	{"NGSK", 4, 44271},
	{"COURSEWORK", 10, 44272},
	{"SOLICITORS", 10, 44273},
	{"KAYAK", 5, 44274},
	{"MODERATELY", 10, 44275},
	{"ELAL", 4, 44276},
	{"NLYU", 4, 44277},
	{"DVOL", 4, 44278},
	{"CKSU", 4, 44279},
	{"YCLU", 4, 44280},
	{"MAYOTTE", 7, 44281},
	{"ALTAR", 5, 44282},
	{"WNPR", 4, 44283},
	{"SALVAGE", 7, 44284},
	{"RTDE", 4, 44285},
	{"REPETITIVE", 10, 44286},
	{"STANTON", 7, 44287},
	{"CREATORS", 8, 44288},
	{"GEARS", 5, 44289},
	{"ORBITAL", 7, 44290},
	{"MUSICALS", 8, 44291},
	{"GOFC", 4, 44292},
	{"RFEL", 4, 44293},
	{"TYBO", 4, 44294},
	{"KILOMETRES", 10, 44295},
	{"SLEV", 4, 44296},
	{"UDOF", 4, 44297},
	{"BYFI", 4, 44298},
	{"CUFF", 4, 44299},
	{"LTOD", 4, 44300},
	{"LITHUANIAN", 10, 44301},
	{"NCHW", 4, 44302},
	{"REPEATING", 9, 44303},
	{"EMPIRES", 7, 44304},
	{"NCUS", 4, 44305},
	{"FFSH", 4, 44306},
	{"GGOO", 4, 44307},
	{"DSSU", 4, 44308},
	{"AYDO", 4, 44309},
	{"PROFILING", 9, 44310},
	{"ELYG", 4, 44311},
	{"LFIE", 4, 44312},
	{"REPS", 4, 44313},
	{"NAUD", 4, 44314},
	{"LLUT", 4, 44315},
	{"EXIB", 4, 44316},
	{"YMPH", 4, 44317},
	{"EWWA", 4, 44318},
	{"DASF", 4, 44319},
	{"ALDW", 4, 44320},
	{"RTEM", 4, 44321},
	{"MABL", 4, 44322},
	{"LDBR", 4, 44323},
	{"NLOW", 4, 44324},
	{"OYSTER", 6, 44325},
	{"STURDY", 6, 44326},
	{"SEQUENCING", 10, 44327},
	{"ADAW", 4, 44328},
	{"DFAN", 4, 44329},
	{"TEMC", 4, 44330},
	{"MASSACRE", 8, 44331},
	{"NTDR", 4, 44332},
	{"BYDI", 4, 44333},
	{"PANORAMIC", 9, 44334},
	{"RISEN", 5, 44335},
	{"BLENDED", 7, 44336},
	{"DESKJET", 7, 44337},
	{"WPLA", 4, 44338},
	{"EWFR", 4, 44339},
	{"RHINO", 5, 44340},
	{"POLYNOMIAL", 10, 44341},
	{"OMLE", 4, 44342},
	{"NIFY", 4, 44343},
	{"IMPERATIVE", 10, 44344},
	{"STAKEHOLDER", 11, 44345},
	{"FWAY", 4, 44346},
	{"ILMO", 4, 44347},
	{"DIGGING", 7, 44348},
	{"RMTO", 4, 44349},
	{"LANTERN", 7, 44350},
	{"CATCHES", 7, 44351},
	{"OFLU", 4, 44352},
	{"EVANGELICAL", 11, 44353},
	{"RULER", 5, 44354},
	{"SIGNIFIES", 9, 44355},
	{"HENRI", 5, 44356},
	{"LYGI", 4, 44357},
	{"DJAN", 4, 44358},
	{"STOCHASTIC", 10, 44359},
	{"MIDF", 4, 44360},
	{"RTWE", 4, 44361},
	{"DITD", 4, 44362},
	{"EDTU", 4, 44363},
	{"TBOU", 4, 44364},
	{"TACU", 4, 44365},
	{"TOKENS", 6, 44366},
	{"SANTANA", 7, 44367},
	{"LDUN", 4, 44368},
	{"KIDDING", 7, 44369},
	{"NBOU", 4, 44370},
	{"FMEM", 4, 44371},
	{"ULTW", 4, 44372},
	{"PIPING", 6, 44373},
	{"GETD", 4, 44374},
	{"FFIT", 4, 44375},
	{"EJAM", 4, 44376},
	{"SWEPT", 5, 44377},
	{"OORW", 4, 44378},
	{"SWANSEA", 7, 44379},
	{"AIRMAIL", 7, 44380},
	{"STARING", 7, 44381},
	{"ICKR", 4, 44382},
	{"SEVENTY", 7, 44383},
	{"EDSK", 4, 44384},
	{"OAPR", 4, 44385},
	{"GDIR", 4, 44386},
	{"RYTA", 4, 44387},
	{"UNTL", 4, 44388},
	{"PROBLEMATIC", 11, 44389},
	{"YATP", 4, 44390},
	{"TUME", 4, 44391},
	{"GATR", 4, 44392},
	{"CTFR", 4, 44393},
	{"RKAR", 4, 44394},
	{"AROSE", 5, 44395},
	{"GHMO", 4, 44396},
	{"DECOMPOSITION", 13, 44397},
	{"NDLU", 4, 44398},
	{"GDJ", 3, 44399},
	{"RDFI", 4, 44400},
	{"CHATHAM", 7, 44401},
	{"IRJO", 4, 44402},
	{"ODYE", 4, 44403},
	{"ROADMAP", 7, 44404},
	{"RONZ", 4, 44405},
	{"TCHM", 4, 44406},
	{"RCUT", 4, 44407},
	{"BECKY", 5, 44408},
	{"LSIG", 4, 44409},
	{"FARRELL", 7, 44410},
	{"CSER", 4, 44411},
	{"ELDERS", 6, 44412},
	{"EFAV", 4, 44413},
	{"INTERPRETERS", 12, 44414},
	{"USDO", 4, 44415},
	{"YJM", 3, 44416},
	{"ACKNOWLEDGEMENTS", 16, 44417},
	{"GOWH", 4, 44418},
	{"KLAUS", 5, 44419},
	{"LDOG", 4, 44420},
	{"RSSP", 4, 44421},
	{"WOPE", 4, 44422},
	{"TYBA", 4, 44423},
	{"SKINCARE", 8, 44424},
	{"CONQUEST", 8, 44425},
	{"EIFY", 4, 44426},
	{"DLEV", 4, 44427},
	{"ZYJ", 3, 44428},
	{"YSMI", 4, 44429},
	{"HEROIN", 6, 44430},
	{"RMES", 4, 44431},
	{"RNIC", 4, 44432},
	{"RDTI", 4, 44433},
	{"REPAIRING", 9, 44434},
	{"MANDATED", 8, 44435},
	{"WORKBOOK", 8, 44436},
	{"XSLT", 4, 44437},
	{"THBY", 4, 44438},
	{"HOGAN", 5, 44439},
	{"NGIL", 4, 44440},
	{"GEAB", 4, 44441},
	{"XTMO", 4, 44442},
	{"WHISTLE", 7, 44443},
	{"SULFATE", 7, 44444},
	{"ALSD", 4, 44445},
	{"LPRA", 4, 44446},
	{"DRESDEN", 7, 44447},
	{"RRYB", 4, 44448},
	{"TIMESHARE", 9, 44449},
	{"DIVERSIFIED", 11, 44450},
	{"RZM", 3, 44451},
	{"RCHU", 4, 44452},
	{"DROI", 4, 44453},
	{"ALHU", 4, 44454},
	{"OLDIES", 6, 44455},
	{"DGEM", 4, 44456},
	{"LERP", 4, 44457},
	{"UCKT", 4, 44458},
	{"IRDW", 4, 44459},
	{"FERTILIZER", 10, 44460},
	{"HOFM", 4, 44461},
	{"GMIN", 4, 44462},
	{"COMPLAINING", 11, 44463},
	{"FTFO", 4, 44464},
	{"ANALYTIC", 8, 44465},
	{"MYHA", 4, 44466},
	{"RLIT", 4, 44467},
	{"GHWI", 4, 44468},
	{"PREDOMINANTLY", 13, 44469},
	{"AMETHYST", 8, 44470},
	{"DEBRA", 5, 44471},
	{"WOODWARD", 8, 44472},
	{"REWRITTEN", 9, 44473},
	{"CDROM", 5, 44474},
	{"URNF", 4, 44475},
	{"SAUC", 4, 44476},
	{"CONCERTO", 8, 44477},
	{"IRDQ", 4, 44478},
	{"HEFF", 4, 44479},
	{"AFFL", 4, 44480},
	{"GUEL", 4, 44481},
	{"ADORABLE", 8, 44482},
	{"TLOW", 4, 44483},
	{"TORRES", 6, 44484},
	{"TBEP", 4, 44485},
	{"KEBE", 4, 44486},
	{"DMID", 4, 44487},
	{"CILA", 4, 44488},
	{"URYB", 4, 44489},
	{"AILC", 4, 44490},
	{"RESTRAINT", 9, 44491},
	{"OLWH", 4, 44492},
	{"GYOF", 4, 44493},
	{"YPET", 4, 44494},
	{"PEFO", 4, 44495},
	{"THRILLERS", 9, 44496},
	{"OMYI", 4, 44497},
	{"GOWI", 4, 44498},
	{"FLIV", 4, 44499},
	{"EORP", 4, 44500},
	{"FORTRAN", 7, 44501},
	{"EDDY", 4, 44502},
	{"ILYL", 4, 44503},
	{"HOWY", 4, 44504},
	{"CONDEMNED", 9, 44505},
	{"BERGER", 6, 44506},
	{"TIMELESS", 8, 44507},
	{"PAROLE", 6, 44508},
	{"COREY", 5, 44509},
	{"KENDALL", 7, 44510},
	{"QUL", 3, 44511},
	{"SPOUSES", 7, 44512},
	{"SLIPS", 5, 44513},
	{"RYBR", 4, 44514},
	{"NINETY", 6, 44515},
	{"DDRU", 4, 44516},
	{"IDAC", 4, 44517},
	{"TRAYS", 5, 44518},
	{"STEWARDSHIP", 11, 44519},
	{"CUES", 4, 44520},
	{"BIOINFORMATICS", 14, 44521},
	{"HGAM", 4, 44522},
	{"RTHL", 4, 44523},
	{"KISSES", 6, 44524},
	{"LYFU", 4, 44525},
	{"CALY", 4, 44526},
	{"KERR", 4, 44527},
	{"REGULATING", 10, 44528},
	{"RSCI", 4, 44529},
	{"FLOCK", 5, 44530},
	{"EXPORTING", 9, 44531},
	{"PUTH", 4, 44532},
	{"ARABIAN", 7, 44533},
	{"CHUNG", 5, 44534},
	{"SUBPART", 7, 44535},
	{"EERR", 4, 44536},
	{"DEAB", 4, 44537},
	{"SCHEDULER", 9, 44538},
	{"BENDING", 7, 44539},
	{"LIMM", 4, 44540},
	{"RNWA", 4, 44541},
	{"MONF", 4, 44542},
	{"BORIS", 5, 44543},
	{"LMAS", 4, 44544},
	{"HYPNOSIS", 8, 44545},
	{"AMPR", 4, 44546},
	{"ALAV", 4, 44547},
	{"GMET", 4, 44548},
	{"AMMUNITION", 10, 44549},
	{"VEGA", 4, 44550},
	{"RVOT", 4, 44551},
	{"RCOO", 4, 44552},
	{"PLEASURES", 9, 44553},
	{"SHORTEST", 8, 44554},
	{"DENYING", 7, 44555},
	{"SYRI", 4, 44556},
	{"ONBL", 4, 44557},
	{"RBAG", 4, 44558},
	{"CKOR", 4, 44559},
	{"CORNERSTONE", 11, 44560},
	{"TSBR", 4, 44561},
	{"RSDU", 4, 44562},
	{"RECYCLE", 7, 44563},
	{"FFAC", 4, 44564},
	{"SHAVE", 5, 44565},
	{"ICPE", 4, 44566},
	{"HYBR", 4, 44567},
	{"UGAL", 4, 44568},
	{"HTBY", 4, 44569},
	{"XEMP", 4, 44570},
	{"SMUR", 4, 44571},
	{"NTQU", 4, 44572},
	{"DISRUPTION", 10, 44573},
	{"GALWAY", 6, 44574},
	{"KHAD", 4, 44575},
	{"COLT", 4, 44576},
	{"ARTILLERY", 9, 44577},
	{"MEKI", 4, 44578},
	{"PRECEDENCE", 10, 44579},
	{"ODWH", 4, 44580},
	{"WSOM", 4, 44581},
	{"OLSW", 4, 44582},
	{"APPLICABILITY", 13, 44583},
	{"RYBY", 4, 44584},
	{"VOLATILITY", 10, 44585},
	{"GRINDING", 8, 44586},
	{"RUBBISH", 7, 44587},
	{"ELFB", 4, 44588},
	{"OWME", 4, 44589},
	{"KNOCKED", 7, 44590},
	{"SWAMP", 5, 44591},
	{"PITCHING", 8, 44592},
	{"NROC", 4, 44593},
	{"HOTELES", 7, 44594},
	{"BEDB", 4, 44595},
	{"NJEC", 4, 44596},
	{"BORDEAUX", 8, 44597},
	{"MANIFOLD", 8, 44598},
	{"TORNADO", 7, 44599},
	{"DISNEYLAND", 10, 44600},
	{"UMD", 3, 44601},
	{"GDB", 3, 44602},
	{"POSSESSED", 9, 44603},
	{"EAMR", 4, 44604},
	{"CTAL", 4, 44605},
	{"GDES", 4, 44606},
	{"TURTLES", 7, 44607},
	{"OFFS", 4, 44608},
	{"LISTSERV", 8, 44609},
	{"YROO", 4, 44610},
	{"CTME", 4, 44611},
	{"VAUXHALL", 8, 44612},
	{"COND", 4, 44613},
	{"DMAL", 4, 44614},
	{"WELCOMING", 9, 44615},
	{"MDOW", 4, 44616},
	{"LEARNS", 6, 44617},
	{"HIMD", 4, 44618},
	{"DNTM", 4, 44619},
	{"WEJU", 4, 44620},
	{"RTPR", 4, 44621},
	{"DIVIDING", 8, 44622},
	{"HICKORY", 7, 44623},
	{"RENOVATED", 9, 44624},
	{"INMATES", 7, 44625},
	{"TOKELAU", 7, 44626},
	{"CONFORMANCE", 11, 44627},
	{"SLICES", 6, 44628},
	{"DIECAST", 7, 44629},
	{"MONP", 4, 44630},
	{"TSFU", 4, 44631},
	{"BITTORRENT", 10, 44632},
	{"LBEB", 4, 44633},
	{"CODY", 4, 44634},
	{"FRANKIE", 7, 44635},
	{"WHYH", 4, 44636},
	{"LAWSON", 6, 44637},
	{"YPAI", 4, 44638},
	{"OMDI", 4, 44639},
	{"RPAY", 4, 44640},
	{"FEWT", 4, 44641},
	{"ALPRAZOLAM", 10, 44642},
	{"DAMNED", 6, 44643},
	{"YOUJ", 4, 44644},
	{"LBAT", 4, 44645},
	{"UADE", 4, 44646},
	{"LDUP", 4, 44647},
	{"BEETHOVEN", 9, 44648},
	{"UTMY", 4, 44649},
	{"ARMT", 4, 44650},
	{"LEXC", 4, 44651},
	{"EERB", 4, 44652},
	{"FTAL", 4, 44653},
	{"ECOW", 4, 44654},
	{"REBUILT", 7, 44655},
	{"UTEW", 4, 44656},
	{"PROCEEDED", 9, 44657},
	{"TMER", 4, 44658},
	{"GHSP", 4, 44659},
	{"COLLABORATE", 11, 44660},
	{"LETU", 4, 44661},
	{"KSAB", 4, 44662},
	{"GCOR", 4, 44663},
	{"REDV", 4, 44664},
	{"OFEC", 4, 44665},
	{"TENTATIVE", 9, 44666},
	{"FDIF", 4, 44667},
	{"PETERBOROUGH", 12, 44668},
	{"EGOP", 4, 44669},
	{"JARS", 4, 44670},
	{"AUTHENTICITY", 12, 44671},
	{"RTYR", 4, 44672},
	{"LPUR", 4, 44673},
	{"ADGO", 4, 44674},
	{"LSOV", 4, 44675},
	{"RYDO", 4, 44676},
	{"GLAND", 5, 44677},
	{"CTBE", 4, 44678},
	{"POSITIVES", 9, 44679},
	{"WIGS", 4, 44680},
	{"FDOL", 4, 44681},
	{"RESIGNATION", 11, 44682},
	{"STRIPED", 7, 44683},
	{"DQW", 3, 44684},
	{"BLENDS", 6, 44685},
	{"GARMENTS", 8, 44686},
	{"FRATERNITY", 10, 44687},
	{"HUNK", 4, 44688},
	{"ALLOCATIONS", 11, 44689},
	{"LYMPHOMA", 8, 44690},
	{"TAPESTRY", 8, 44691},
	{"LDDI", 4, 44692},
	{"ORIGINATING", 11, 44693},
	{"GLEM", 4, 44694},
	{"LUBI", 4, 44695},
	{"AKFA", 4, 44696},
	{"CHAP", 4, 44697},
	{"UNGR", 4, 44698},
	{"VLU", 3, 44699},
	{"BLOWS", 5, 44700},
	{"RPC", 3, 44701},
	{"ROCL", 4, 44702},
	{"FREEBIES", 8, 44703},
	{"IGMA", 4, 44704},
	{"UNDN", 4, 44705},
	{"FBIL", 4, 44706},
	{"CONVERSE", 8, 44707},
	{"CUTA", 4, 44708},
	{"FRONTLINE", 9, 44709},
	{"YROA", 4, 44710},
	{"GARDENER", 8, 44711},
	{"EXPI", 4, 44712},
	{"IMAP", 4, 44713},
	{"WINAMP", 6, 44714},
	{"WINNIE", 6, 44715},
	{"NERM", 4, 44716},
	{"XCUS", 4, 44717},
	{"UDSO", 4, 44718},
	{"HIGGINS", 7, 44719},
	{"STOKE", 5, 44720},
	{"GDEV", 4, 44721},
	{"MBOT", 4, 44722},
	{"DITR", 4, 44723},
	{"ITMU", 4, 44724},
	{"IDBU", 4, 44725},
	{"HMAK", 4, 44726},
	{"ENQU", 4, 44727},
	{"RSEB", 4, 44728},
	{"WARWICKSHIRE", 12, 44729},
	{"POLYMERS", 8, 44730},
	{"PENGUINS", 8, 44731},
	{"LAYC", 4, 44732},
	{"ATTRACTING", 10, 44733},
	{"GRILLS", 6, 44734},
	{"JEEVES", 6, 44735},
	{"HARP", 4, 44736},
	{"USWO", 4, 44737},
	{"THCR", 4, 44738},
	{"ESCROW", 6, 44739},
	{"LAWO", 4, 44740},
	{"LUMPUR", 6, 44741},
	{"CREL", 4, 44742},
	{"DENTON", 6, 44743},
	{"ANTHEM", 6, 44744},
	{"TACK", 4, 44745},
	{"WHITMAN", 7, 44746},
	{"NOWADAYS", 8, 44747},
	{"WOODSTOCK", 9, 44748},
	{"USFI", 4, 44749},
	{"INFOSPACE", 9, 44750},
	{"FVIE", 4, 44751},
	{"AJUN", 4, 44752},
	{"LROU", 4, 44753},
	{"INFERIOR", 8, 44754},
	{"SURFERS", 7, 44755},
	{"EORF", 4, 44756},
	{"EHUG", 4, 44757},
	{"ABUSES", 6, 44758},
	{"INSPECTED", 9, 44759},
	{"RWEI", 4, 44760},
	{"NREQ", 4, 44761},
	{"ILYN", 4, 44762},
	{"LAWT", 4, 44763},
	{"YLOV", 4, 44764},
	{"WARH", 4, 44765},
	{"NKSW", 4, 44766},
	{"JOCKEY", 6, 44767},
	{"KAUAI", 5, 44768},
	{"LICENSORS", 9, 44769},
	{"YWES", 4, 44770},
	{"AWLE", 4, 44771},
	{"EORL", 4, 44772},
	{"INDICATIVE", 10, 44773},
	{"CPC", 3, 44774},
	{"STRESSES", 8, 44775},
	{"ITHACA", 6, 44776},
	{"WEBHOSTING", 10, 44777},
	{"LOWU", 4, 44778},
	{"EDMUND", 6, 44779},
	{"PEORIA", 6, 44780},
	{"UPHOLSTERY", 10, 44781},
	{"PEEK", 4, 44782},
	{"HRUS", 4, 44783},
	{"GSBE", 4, 44784},
	{"PRACTICED", 9, 44785},
	{"ELLA", 4, 44786},
	{"RROA", 4, 44787},
	{"CASUALTIES", 10, 44788},
	{"IPSEC", 5, 44789},
	{"GFOO", 4, 44790},
	{"GCRE", 4, 44791},
	{"BOURNEMOUTH", 11, 44792},
	{"SUDOKU", 6, 44793},
	{"MONARCH", 7, 44794},
	{"VEJU", 4, 44795},
	{"UNDEF", 5, 44796},
	{"HOUSED", 6, 44797},
	{"ADMINISTERING", 13, 44798},
	{"TLAU", 4, 44799},
	{"HUMI", 4, 44800},
	{"TEMPTATION", 10, 44801},
	{"HAVANA", 6, 44802},
	{"ROWO", 4, 44803},
	{"CAMPGROUND", 10, 44804},
	{"NASAL", 5, 44805},
	{"UPZ", 3, 44806},
	{"NVAD", 4, 44807},
	{"BYGE", 4, 44808},
	{"RESTRICTIVE", 11, 44809},
	{"BWAS", 4, 44810},
	{"COSTING", 7, 44811},
	{"RANGED", 6, 44812},
	{"PREDICTIVE", 10, 44813},
	{"DGME", 4, 44814},
	{"VLAN", 4, 44815},
	{"ODIR", 4, 44816},
	{"AQUACULTURE", 11, 44817},
	{"EXTB", 4, 44818},
	{"SPRUCE", 6, 44819},
	{"NSGR", 4, 44820},
	{"PARADOX", 7, 44821},
	{"ESFU", 4, 44822},
	{"SENDMAIL", 8, 44823},
	{"REDESIGN", 8, 44824},
	{"URSW", 4, 44825},
	{"BILLINGS", 8, 44826},
	{"JEANNE", 6, 44827},
	{"NITRO", 5, 44828},
	{"OXIDATION", 9, 44829},
	{"JACKPOT", 7, 44830},
	{"MARIN", 5, 44831},
	{"BYGO", 4, 44832},
	{"DWIC", 4, 44833},
	{"UGBY", 4, 44834},
	{"CORTEX", 6, 44835},
	{"ENTITLEMENT", 11, 44836},
	{"AMENDING", 8, 44837},
	{"CONFLICTING", 11, 44838},
	{"GEORGIAN", 8, 44839},
	{"IELL", 4, 44840},
	{"COMPENSATE", 10, 44841},
	{"RECHERCHE", 9, 44842},
	{"IPBE", 4, 44843},
	{"LOSER", 5, 44844},
	{"HTBU", 4, 44845},
	{"MIXERS", 6, 44846},
	{"EWEC", 4, 44847},
	{"ACCOUNTANCY", 11, 44848},
	{"CLAUS", 5, 44849},
	{"POLICING", 8, 44850},
	{"BRAVES", 6, 44851},
	{"CRACKING", 8, 44852},
	{"WENF", 4, 44853},
	{"SUED", 4, 44854},
	{"SHOOTS", 6, 44855},
	{"MICHAELS", 8, 44856},
	{"INTERRUPTED", 11, 44857},
	{"HEMISPHERE", 10, 44858},
	{"MIRANDA", 7, 44859},
	{"KEYP", 4, 44860},
	{"CLOVER", 6, 44861},
	{"MAYF", 4, 44862},
	{"KINDNESS", 8, 44863},
	{"SIMILARITIES", 12, 44864},
	{"BEOF", 4, 44865},
	{"YFIG", 4, 44866},
	{"LYQU", 4, 44867},
	{"HIPAA", 5, 44868},
	{"PORTO", 5, 44869},
	{"EWBO", 4, 44870},
	{"NEUTRON", 7, 44871},
	{"ATQU", 4, 44872},
	{"DULUTH", 6, 44873},
	{"DIRECTS", 7, 44874},
	{"RKIL", 4, 44875},
	{"JOLLY", 5, 44876},
	{"SNAKES", 6, 44877},
	{"SWELLING", 8, 44878},
	{"SPANNING", 8, 44879},
	{"FEMME", 5, 44880},
	{"UNANIMOUS", 9, 44881},
	{"LEXT", 4, 44882},
	{"RAILWAYS", 8, 44883},
	{"APPROVES", 8, 44884},
	{"SCRIPTURES", 10, 44885},
	{"MISCONDUCT", 10, 44886},
	{"LESTER", 6, 44887},
	{"DOGG", 4, 44888},
	{"WBUS", 4, 44889},
	{"FOLKLORE", 8, 44890},
	{"RESIDES", 7, 44891},
	{"WORDING", 7, 44892},
	{"OBLIGED", 7, 44893},
	{"EDPH", 4, 44894},
	{"DDHI", 4, 44895},
	{"HFIR", 4, 44896},
	{"EUPF", 4, 44897},
	{"ROCKIES", 7, 44898},
	{"SIEGE", 5, 44899},
	{"TEBR", 4, 44900},
	{"DIMM", 4, 44901},
	{"WWEE", 4, 44902},
	{"EXERCISING", 10, 44903},
	{"ACOUSTICS", 9, 44904},
	{"VOLUNTARILY", 11, 44905},
	{"GVER", 4, 44906},
	{"PENSACOLA", 9, 44907},
	{"UESF", 4, 44908},
	{"ATKINSON", 8, 44909},
	{"YINR", 4, 44910},
	{"OULS", 4, 44911},
	{"YMPA", 4, 44912},
	{"CONDOMINIUM", 11, 44913},
	{"WILDCATS", 8, 44914},
	{"RDNE", 4, 44915},
	{"NORD", 4, 44916},
	{"EXHIBITORS", 10, 44917},
	{"TRUTHS", 6, 44918},
	{"AYPE", 4, 44919},
	{"UNAW", 4, 44920},
	{"GPOW", 4, 44921},
	{"EDSM", 4, 44922},
	{"FCRI", 4, 44923},
	{"LEDN", 4, 44924},
	{"YSEP", 4, 44925},
	{"GFUL", 4, 44926},
	{"GROUPING", 8, 44927},
	{"YFAV", 4, 44928},
	{"EERU", 4, 44929},
	{"DBEU", 4, 44930},
	{"YISR", 4, 44931},
	{"ISMW", 4, 44932},
	{"WOLFE", 5, 44933},
	{"OTFR", 4, 44934},
	{"REDWOOD", 7, 44935},
	{"THERETO", 7, 44936},
	{"CKRO", 4, 44937},
	{"INVOICES", 8, 44938},
	{"LANF", 4, 44939},
	{"OCEL", 4, 44940},
	{"NYSU", 4, 44941},
	{"NYME", 4, 44942},
	{"PLIA", 4, 44943},
	{"TYRES", 5, 44944},
	{"FERF", 4, 44945},
	{"WESTWOOD", 8, 44946},
	{"AUTHORIZING", 11, 44947},
	{"YBUR", 4, 44948},
	{"WNBE", 4, 44949},
	{"ENAMEL", 6, 44950},
	{"KSFR", 4, 44951},
	{"DLYI", 4, 44952},
	{"WERR", 4, 44953},
	{"DIGN", 4, 44954},
	{"LFEE", 4, 44955},
	{"TOBY", 4, 44956},
	{"GLY", 3, 44957},
	{"GHOL", 4, 44958},
	{"VEPU", 4, 44959},
	{"LWAT", 4, 44960},
	{"UGUE", 4, 44961},
	{"RADIANT", 7, 44962},
	{"ESTONIAN", 8, 44963},
	{"VIRGINS", 7, 44964},
	{"FIRSTLY", 7, 44965},
	{"LPOI", 4, 44966},
	{"GLEO", 4, 44967},
	{"MARTINI", 7, 44968},
	{"UNGT", 4, 44969},
	{"BUTTE", 5, 44970},
	{"BOMBER", 6, 44971},
	{"REEVES", 6, 44972},
	{"SONGWRITER", 10, 44973},
	{"YMPT", 4, 44974},
	{"OLDU", 4, 44975},
	{"DISADVANTAGE", 12, 44976},
	{"BASTARD", 7, 44977},
	{"SHANIA", 6, 44978},
	{"TORJ", 4, 44979},
	{"GLOT", 4, 44980},
	{"BEAW", 4, 44981},
	{"COASTER", 7, 44982},
	{"SPENDS", 6, 44983},
	{"HICKS", 5, 44984},
	{"TYPEDEF", 7, 44985},
	{"YEXT", 4, 44986},
	{"PRATT", 5, 44987},
	{"PEDIGREE", 8, 44988},
	{"STRIPPERS", 9, 44989},
	{"MACMILLAN", 9, 44990},
	{"FRAUDULENT", 10, 44991},
	{"WOODWORKING", 11, 44992},
	{"SHERWOOD", 8, 44993},
	{"GEGR", 4, 44994},
	{"FORGIVENESS", 11, 44995},
	{"QBW", 3, 44996},
	{"OORG", 4, 44997},
	{"WNBU", 4, 44998},
	{"CBD", 3, 44999},
	{"ALMOND", 6, 45000},
	{"PRICERUNNER", 11, 45001},
	{"ADIM", 4, 45002},
	{"MBAN", 4, 45003},
	{"CATALYTIC", 9, 45004},
	{"DITM", 4, 45005},
	{"LLJU", 4, 45006},
	{"PETITIONS", 9, 45007},
	{"RTMO", 4, 45008},
	{"FRANCAIS", 8, 45009},
	{"UERT", 4, 45010},
	{"ECUB", 4, 45011},
	{"TRENTON", 7, 45012},
	{"CHALK", 5, 45013},
	{"OMAR", 4, 45014},
	{"IERF", 4, 45015},
	{"ALEXIS", 6, 45016},
	{"NTGU", 4, 45017},
	{"BETHESDA", 8, 45018},
	{"UNGB", 4, 45019},
	{"OBAD", 4, 45020},
	{"PRIVATIZATION", 13, 45021},
	{"SOURCEFORGE", 11, 45022},
	{"SANFORD", 7, 45023},
	{"WOGA", 4, 45024},
	{"RROS", 4, 45025},
	{"AXLE", 4, 45026},
	{"MEMBRANES", 9, 45027},
	{"EGAP", 4, 45028},
	{"ECKT", 4, 45029},
	{"PUPPET", 6, 45030},
	{"EYBU", 4, 45031},
	{"TESTOSTERONE", 12, 45032},
	{"WELO", 4, 45033},
	{"CULTIVATION", 11, 45034},
	{"NUNAVUT", 7, 45035},
	{"SURVEYING", 9, 45036},
	{"QBY", 3, 45037},
	{"UPIS", 4, 45038},
	{"ISBY", 4, 45039},
	{"LOFB", 4, 45040},
	{"GRAZING", 7, 45041},
	{"BIOCHEMICAL", 11, 45042},
	{"RSAV", 4, 45043},
	{"PILLAR", 6, 45044},
	{"MIRAGE", 6, 45045},
	{"GUYW", 4, 45046},
	{"LENNON", 6, 45047},
	{"FCAM", 4, 45048},
	{"QUESTIONABLE", 12, 45049},
	{"KSAL", 4, 45050},
	{"SEASIDE", 7, 45051},
	{"WWHI", 4, 45052},
	{"HOWP", 4, 45053},
	{"ACHL", 4, 45054},
	{"SUITABILITY", 11, 45055},
	{"PRECINCT", 8, 45056},
	{"RENAMED", 7, 45057},
	{"COBB", 4, 45058},
	{"LARA", 4, 45059},
	{"PEWI", 4, 45060},
	{"UNBELIEVABLE", 12, 45061},
	{"SOLUBLE", 7, 45062},
	{"PIRACY", 6, 45063},
	{"OLFE", 4, 45064},
	{"KLYA", 4, 45065},
	{"ROWING", 6, 45066},
	{"SIDING", 6, 45067},
	{"HARDEST", 7, 45068},
	{"FORREST", 7, 45069},
	{"INVITATIONAL", 12, 45070},
	{"REMINDERS", 9, 45071},
	{"GYAR", 4, 45072},
	{"BLYH", 4, 45073},
	{"BLANCA", 6, 45074},
	{"DYEL", 4, 45075},
	{"LYKI", 4, 45076},
	{"RSOV", 4, 45077},
	{"LSDE", 4, 45078},
	{"EQUIVALENTS", 11, 45079},
	{"FULM", 4, 45080},
	{"DHOR", 4, 45081},
	{"AORD", 4, 45082},
	{"ADFI", 4, 45083},
	{"JOHANN", 6, 45084},
	{"HANDCRAFTED", 11, 45085},
	{"AFTERMARKET", 11, 45086},
	{"PINEAPPLE", 9, 45087},
	{"FELLOWSHIPS", 11, 45088},
	{"OWWO", 4, 45089},
	{"YPW", 3, 45090},
	{"TPUR", 4, 45091},
	{"AGUN", 4, 45092},
	{"EURS", 4, 45093},
	{"EJUL", 4, 45094},
	{"FREEWAY", 7, 45095},
	{"OWSC", 4, 45096},
	{"WRATH", 5, 45097},
	{"RTSU", 4, 45098},
	{"OPAL", 4, 45099},
	{"NDUM", 4, 45100},
	{"SIMPLEST", 8, 45101},
	{"PATRONS", 7, 45102},
	{"PECULIAR", 8, 45103},
	{"RPRA", 4, 45104},
	{"EUROPEANS", 9, 45105},
	{"COMMENCE", 8, 45106},
	{"MYFR", 4, 45107},
	{"DESCENDANTS", 11, 45108},
	{"ICWH", 4, 45109},
	{"REDMOND", 7, 45110},
	{"RNPA", 4, 45111},
	{"SAFEGUARD", 9, 45112},
	{"DIGITALLY", 9, 45113},
	{"LARS", 4, 45114},
	{"HATCHBACK", 9, 45115},
	{"RASU", 4, 45116},
	{"RFP", 3, 45117},
	{"OBSESSION", 9, 45118},
	{"GRIND", 5, 45119},
	{"ALBEIT", 6, 45120},
	{"BILLIARDS", 9, 45121},
	{"TARW", 4, 45122},
	{"CLINT", 5, 45123},
	{"BANKERS", 7, 45124},
	{"RIGHTEOUS", 9, 45125},
	{"NLED", 4, 45126},
	{"VEVI", 4, 45127},
	{"RMYO", 4, 45128},
	{"REDISTRIBUTION", 14, 45129},
	{"RKSF", 4, 45130},
	{"WWIL", 4, 45131},
	{"FREAKS", 6, 45132},
	{"UTEM", 4, 45133},
	{"KECH", 4, 45134},
	{"ESRU", 4, 45135},
	{"LDBO", 4, 45136},
	{"SUBCLASS", 8, 45137},
	{"RDIT", 4, 45138},
	{"KSRE", 4, 45139},
	{"EEDY", 4, 45140},
	{"DMYS", 4, 45141},
	{"RUTGERS", 7, 45142},
	{"GEWO", 4, 45143},
	{"SAMPLED", 7, 45144},
	{"SINCERE", 7, 45145},
	{"AMEV", 4, 45146},
	{"DEPLOYING", 9, 45147},
	{"INTERACTING", 11, 45148},
	{"ROANOKE", 7, 45149},
	{"INTENTIONALLY", 13, 45150},
	{"BLITZ", 5, 45151},
	{"TENDED", 6, 45152},
	{"CENSORSHIP", 10, 45153},
	{"MOFC", 4, 45154},
	{"CACTUS", 6, 45155},
	{"VIVA", 4, 45156},
	{"TREADMILL", 9, 45157},
	{"ANYU", 4, 45158},
	{"LITW", 4, 45159},
	{"HSUP", 4, 45160},
	{"EBUN", 4, 45161},
	{"FIBERGLASS", 10, 45162},
	{"ATTAINED", 8, 45163},
	{"LDSW", 4, 45164},
	{"RFJ", 3, 45165},
	{"BLEW", 4, 45166},
	{"OSAKA", 5, 45167},
	{"SPLENDID", 8, 45168},
	{"MNOW", 4, 45169},
	{"JANICE", 6, 45170},
	{"IFEF", 4, 45171},
	{"PERSONALIZE", 11, 45172},
	{"LAVA", 4, 45173},
	{"LEONARDO", 8, 45174},
	{"SUCKED", 6, 45175},
	{"YSBU", 4, 45176},
	{"RTYF", 4, 45177},
	{"SCISSORS", 8, 45178},
	{"BRONCOS", 7, 45179},
	{"JORGE", 5, 45180},
	{"UTOP", 4, 45181},
	{"COOKS", 5, 45182},
	{"RNAB", 4, 45183},
	{"OUGA", 4, 45184},
	{"GRANADA", 7, 45185},
	{"LAURENCE", 8, 45186},
	{"WIFT", 4, 45187},
	{"RGON", 4, 45188},
	{"NPAL", 4, 45189},
	{"SAQU", 4, 45190},
	{"REBELLION", 9, 45191},
	{"RAINY", 5, 45192},
	{"REGENT", 6, 45193},
	{"ALYZ", 4, 45194},
	{"YPUR", 4, 45195},
	{"EVELYN", 6, 45196},
	{"VINEGAR", 7, 45197},
	{"CLASSIFICATIONS", 15, 45198},
	{"FFMA", 4, 45199},
	{"NECR", 4, 45200},
	{"CKAL", 4, 45201},
	{"DIGGS", 5, 45202},
	{"RAFTING", 7, 45203},
	{"PLUTO", 5, 45204},
	{"NOFJ", 4, 45205},
	{"VAIL", 4, 45206},
	{"SUNF", 4, 45207},
	{"GHLE", 4, 45208},
	{"MISERY", 6, 45209},
	{"UNDERGOING", 10, 45210},
	{"LIMERICK", 8, 45211},
	{"YSOR", 4, 45212},
	{"YLEG", 4, 45213},
	{"SAFARIS", 7, 45214},
	{"CONTAMINANTS", 12, 45215},
	{"ENVY", 4, 45216},
	{"GSPA", 4, 45217},
	{"MITCH", 5, 45218},
	{"OYLE", 4, 45219},
	{"SWEEPING", 8, 45220},
	{"ELFC", 4, 45221},
	{"HEALTHIER", 9, 45222},
	{"CKIT", 4, 45223},
	{"RTHF", 4, 45224},
	{"USSR", 4, 45225},
	{"MAILER", 6, 45226},
	{"PREFACE", 7, 45227},
	{"JAMESON", 7, 45228},
	{"GRIEVANCE", 9, 45229},
	{"ELLN", 4, 45230},
	{"LINERS", 6, 45231},
	{"ASHEVILLE", 9, 45232},
	{"SFIX", 4, 45233},
	{"UTBO", 4, 45234},
	{"UNREAD", 6, 45235},
	{"MVER", 4, 45236},
	{"TLYN", 4, 45237},
	{"LDPL", 4, 45238},
	{"PENCILS", 7, 45239},
	{"WUY", 3, 45240},
	{"RKX", 3, 45241},
	{"TDUE", 4, 45242},
	{"GALLOWAY", 8, 45243},
	{"QUINTA", 6, 45244},
	{"EJUM", 4, 45245},
	{"DATC", 4, 45246},
	{"KRISTIN", 7, 45247},
	{"FORGED", 6, 45248},
	{"BISTRO", 6, 45249},
	{"VIOLA", 5, 45250},
	{"DGEF", 4, 45251},
	{"RSGR", 4, 45252},
	{"TYMI", 4, 45253},
	{"VOODOO", 6, 45254},
	{"AIDG", 4, 45255},
	{"OWSM", 4, 45256},
	{"WHYA", 4, 45257},
	{"DISCLOSURES", 11, 45258},
	{"RRON", 4, 45259},
	{"LKOF", 4, 45260},
	{"PROVENCE", 8, 45261},
	{"ITRU", 4, 45262},
	{"UJJ", 3, 45263},
	{"CACHING", 7, 45264},
	{"COMPUTERIZED", 12, 45265},
	{"DBIG", 4, 45266},
	{"RUSTIC", 6, 45267},
	{"EEPW", 4, 45268},
	{"CYPR", 4, 45269},
	{"DJUL", 4, 45270},
	{"AMAK", 4, 45271},
	{"DILLON", 6, 45272},
	{"RJAC", 4, 45273},
	{"DPEA", 4, 45274},
	{"ELEANOR", 7, 45275},
	{"LAYH", 4, 45276},
	{"ERMY", 4, 45277},
	{"DECEPTION", 9, 45278},
	{"VOLTS", 5, 45279},
	{"CONDUCTS", 8, 45280},
	{"DIVORCED", 8, 45281},
	{"RUSHED", 6, 45282},
	{"EXCALIBUR", 9, 45283},
	{"YADM", 4, 45284},
	{"AUCE", 4, 45285},
	{"WEIGHS", 6, 45286},
	{"ARWO", 4, 45287},
	{"SINATRA", 7, 45288},
	{"AYBO", 4, 45289},
	{"DSOX", 4, 45290},
	{"MAGNOLIA", 8, 45291},
	{"DIVER", 5, 45292},
	{"CASTLES", 7, 45293},
	{"NBEP", 4, 45294},
	{"NOTIONS", 7, 45295},
	{"PLATEAU", 7, 45296},
	{"INTERPERSONAL", 13, 45297},
	{"DEXTER", 6, 45298},
	{"SFUT", 4, 45299},
	{"TRAUMATIC", 9, 45300},
	{"RINGER", 6, 45301},
	{"ORCY", 4, 45302},
	{"AMDE", 4, 45303},
	{"MONR", 4, 45304},
	{"ZIPPER", 6, 45305},
	{"MEDS", 4, 45306},
	{"RYIM", 4, 45307},
	{"YKD", 3, 45308},
	{"GANU", 4, 45309},
	{"CKHI", 4, 45310},
	{"ACTB", 4, 45311},
	{"PALETTE", 7, 45312},
	{"BLAZE", 5, 45313},
	{"ELSB", 4, 45314},
	{"WRECK", 5, 45315},
	{"NGOB", 4, 45316},
	{"THREATENS", 9, 45317},
	{"STRENGTHENED", 12, 45318},
	{"SAMMY", 5, 45319},
	{"ELSF", 4, 45320},
	{"BRIEFINGS", 9, 45321},
	{"SIBLINGS", 8, 45322},
	{"YOPP", 4, 45323},
	{"WAKEFIELD", 9, 45324},
	{"LTYT", 4, 45325},
	{"ADVERSELY", 9, 45326},
	{"PITCAIRN", 8, 45327},
	{"CENTRO", 6, 45328},
	{"YZW", 3, 45329},
	{"UGHG", 4, 45330},
	{"PDB", 3, 45331},
	{"BEPE", 4, 45332},
	{"ARABS", 5, 45333},
	{"RSBR", 4, 45334},
	{"YPOW", 4, 45335},
	{"MONM", 4, 45336},
	{"GEDM", 4, 45337},
	{"BILD", 4, 45338},
	{"WSRE", 4, 45339},
	{"OFLY", 4, 45340},
	{"ONBOARD", 7, 45341},
	{"ROBBERY", 7, 45342},
	{"EFEM", 4, 45343},
	{"NUCLEIC", 7, 45344},
	{"TELECOMS", 8, 45345},
	{"YPAY", 4, 45346},
	{"UZP", 3, 45347},
	{"PEDM", 4, 45348},
	{"JASMINE", 7, 45349},
	{"YCUT", 4, 45350},
	{"CROCHET", 7, 45351},
	{"BROCK", 5, 45352},
	{"FTOP", 4, 45353},
	{"LBLA", 4, 45354},
	{"GAGR", 4, 45355},
	{"MSOR", 4, 45356},
	{"RPIC", 4, 45357},
	{"DAPL", 4, 45358},
	{"CROWDS", 6, 45359},
	{"DXW", 3, 45360},
	{"DYST", 4, 45361},
	{"HOOPS", 5, 45362},
	{"LRAT", 4, 45363},
	{"WSWI", 4, 45364},
	{"MACON", 5, 45365},
	{"CELERON", 7, 45366},
	{"SGIR", 4, 45367},
	{"MEVI", 4, 45368},
	{"LYNNE", 5, 45369},
	{"LDAM", 4, 45370},
	{"INVARIANT", 9, 45371},
	{"TOFK", 4, 45372},
	{"YTHM", 4, 45373},
	{"STAMPED", 7, 45374},
	{"MLIK", 4, 45375},
	{"EKOR", 4, 45376},
	{"CHALLENGER", 10, 45377},
	{"INCREMENT", 9, 45378},
	{"REDISTRIBUTED", 13, 45379},
	{"NYWO", 4, 45380},
	{"UPTAKE", 6, 45381},
	{"NEWSWEEK", 8, 45382},
	{"GEARED", 6, 45383},
	{"IDEALS", 6, 45384},
	{"CHLOE", 5, 45385},
	{"NPAY", 4, 45386},
	{"OADR", 4, 45387},
	{"FMET", 4, 45388},
	{"UEWA", 4, 45389},
	{"APOLOGIES", 9, 45390},
	{"PRADA", 5, 45391},
	{"TYCOON", 6, 45392},
	{"NGTU", 4, 45393},
	{"URNH", 4, 45394},
	{"MALIGNANT", 9, 45395},
	{"ZGL", 3, 45396},
	{"RXX", 3, 45397},
	{"MYWA", 4, 45398},
	{"RKMA", 4, 45399},
	{"MAXTOR", 6, 45400},
	{"PLONE", 5, 45401},
	{"DCP", 3, 45402},
	{"ORGU", 4, 45403},
	{"LGRE", 4, 45404},
	{"RRYF", 4, 45405},
	{"YJUN", 4, 45406},
	{"MENF", 4, 45407},
	{"PRECEDED", 8, 45408},
	{"LAWFUL", 6, 45409},
	{"RMUC", 4, 45410},
	{"CROSBY", 6, 45411},
	{"BIOCHEM", 7, 45412},
	{"KTOM", 4, 45413},
	{"BYHO", 4, 45414},
	{"FEUR", 4, 45415},
	{"GATEWAYS", 8, 45416},
	{"COMPACTFLASH", 12, 45417},
	{"COLLAPSED", 9, 45418},
	{"ANTIBIOTIC", 10, 45419},
	{"RPHA", 4, 45420},
	{"HORNS", 5, 45421},
	{"VANDERBILT", 10, 45422},
	{"DIVERSION", 9, 45423},
	{"GDIF", 4, 45424},
	{"OVERWEIGHT", 10, 45425},
	{"RNAD", 4, 45426},
	{"FANTASIES", 9, 45427},
	{"METASEARCH", 10, 45428},
	{"OBOR", 4, 45429},
	{"TALIBAN", 7, 45430},
	{"MAUREEN", 7, 45431},
	{"AYWO", 4, 45432},
	{"TREKKING", 8, 45433},
	{"COORDINATORS", 12, 45434},
	{"LERF", 4, 45435},
	{"BEGINNINGS", 10, 45436},
	{"REVERSAL", 8, 45437},
	{"DIGI", 4, 45438},
	{"NMER", 4, 45439},
	{"AYFI", 4, 45440},
	{"OMOD", 4, 45441},
	{"RICP", 4, 45442},
	{"ASFL", 4, 45443},
	{"SHORELINE", 9, 45444},
	{"PRESSES", 7, 45445},
	{"RORN", 4, 45446},
	{"ORDINATION", 10, 45447},
	{"WESTIN", 6, 45448},
	{"OXFORDSHIRE", 11, 45449},
	{"YVES", 4, 45450},
	{"TANDEM", 6, 45451},
	{"DPLE", 4, 45452},
	{"MIDDLEWARE", 10, 45453},
	{"DCHU", 4, 45454},
	{"MIPS", 4, 45455},
	{"DELIBERATE", 10, 45456},
	{"FHOM", 4, 45457},
	{"GAGGED", 6, 45458},
	{"LMAY", 4, 45459},
	{"ROUNDTABLE", 10, 45460},
	{"PSED", 4, 45461},
	{"SURPRISES", 9, 45462},
	{"SOBV", 4, 45463},
	{"FREG", 4, 45464},
	{"AGAL", 4, 45465},
	{"YLJ", 3, 45466},
	{"QUD", 3, 45467},
	{"JJU", 3, 45468},
	{"USEG", 4, 45469},
	{"RYPT", 4, 45470},
	{"TBUY", 4, 45471},
	{"SBUD", 4, 45472},
	{"DEMENTIA", 8, 45473},
	{"BARLEY", 6, 45474},
	{"RSIF", 4, 45475},
	{"ODSW", 4, 45476},
	{"BYJA", 4, 45477},
	{"POTENT", 6, 45478},
	{"AMUSING", 7, 45479},
	{"BLYD", 4, 45480},
	{"MASTERING", 9, 45481},
	{"WAYM", 4, 45482},
	{"CKBY", 4, 45483},
	{"BYAF", 4, 45484},
	{"LEVINE", 6, 45485},
	{"DELH", 4, 45486},
	{"NERVES", 6, 45487},
	{"RIPENCC", 7, 45488},
	{"SHOPPY", 6, 45489},
	{"ONDQ", 4, 45490},
	{"FILESYSTEM", 10, 45491},
	{"RETAINS", 7, 45492},
	{"LSWA", 4, 45493},
	{"TDRO", 4, 45494},
	{"URDO", 4, 45495},
	{"DOCKING", 7, 45496},
	{"GUIDEBOOK", 9, 45497},
	{"ATREYU", 6, 45498},
	{"KYLIE", 5, 45499},
	{"MUEL", 4, 45500},
	{"LTRY", 4, 45501},
	{"PILATES", 7, 45502},
	{"CHIMNEY", 7, 45503},
	{"OOLY", 4, 45504},
	{"LDEL", 4, 45505},
	{"YFD", 3, 45506},
	{"BACKSTREET", 10, 45507},
	{"FSAL", 4, 45508},
	{"PACKERS", 7, 45509},
	{"LOCALIZED", 9, 45510},
	{"ORKR", 4, 45511},
	{"NAOMI", 5, 45512},
	{"PROVERBS", 8, 45513},
	{"ORYR", 4, 45514},
	{"IBUN", 4, 45515},
	{"DCEL", 4, 45516},
	{"MISTAKEN", 8, 45517},
	{"CARVING", 7, 45518},
	{"RCEW", 4, 45519},
	{"MIRACLES", 8, 45520},
	{"OCRO", 4, 45521},
	{"DOCC", 4, 45522},
	{"FKIN", 4, 45523},
	{"CLAIR", 5, 45524},
	{"SLIPPED", 7, 45525},
	{"FWEA", 4, 45526},
	{"REALISM", 7, 45527},
	{"MAFT", 4, 45528},
	{"DBOU", 4, 45529},
	{"PSWH", 4, 45530},
	{"TJUD", 4, 45531},
	{"CRETE", 5, 45532},
	{"RDSL", 4, 45533},
	{"FRACTIONS", 9, 45534},
	{"EYSU", 4, 45535},
	{"URTW", 4, 45536},
	{"DYWH", 4, 45537},
	{"ULLC", 4, 45538},
	{"TRIU", 4, 45539},
	{"ARCHIVING", 9, 45540},
	{"ERYU", 4, 45541},
	{"DISCONNECT", 10, 45542},
	{"GUEO", 4, 45543},
	{"BLOODHOUND", 10, 45544},
	{"MULTILINGUAL", 12, 45545},
	{"OPOU", 4, 45546},
	{"SHERRY", 6, 45547},
	{"BESP", 4, 45548},
	{"INDIES", 6, 45549},
	{"TULIP", 5, 45550},
	{"NDGL", 4, 45551},
	{"ARLS", 4, 45552},
	{"MADAME", 6, 45553},
	{"REMEDIAL", 8, 45554},
	{"GINL", 4, 45555},
	{"BERT", 4, 45556},
	{"IMMUNIZATION", 12, 45557},
	{"DALTON", 6, 45558},
	{"ELLG", 4, 45559},
	{"WINB", 4, 45560},
	{"BOLOGNA", 7, 45561},
	{"WERM", 4, 45562},
	{"OMSU", 4, 45563},
	{"DEPARTING", 9, 45564},
	{"LMOD", 4, 45565},
	{"CIARA", 5, 45566},
	{"MAZE", 4, 45567},
	{"ODAL", 4, 45568},
	{"WSWE", 4, 45569},
	{"RNEU", 4, 45570},
	{"ABUR", 4, 45571},
	{"ICSB", 4, 45572},
	{"LQUA", 4, 45573},
	{"OBUR", 4, 45574},
	{"BAREFOOT", 8, 45575},
	{"LERK", 4, 45576},
	{"REMUNERATION", 12, 45577},
	{"OWPA", 4, 45578},
	{"BOHEMIAN", 8, 45579},
	{"INTERVIEWING", 12, 45580},
	{"CATEGORIZED", 11, 45581},
	{"IFTY", 4, 45582},
	{"DWEH", 4, 45583},
	{"IMPOSING", 8, 45584},
	{"DAMON", 5, 45585},
	{"TECL", 4, 45586},
	{"TIVOLI", 6, 45587},
	{"CMOS", 4, 45588},
	{"TRANSMISSIONS", 13, 45589},
	{"YAUT", 4, 45590},
	{"LVAR", 4, 45591},
	{"AGOB", 4, 45592},
	{"RECEIVABLE", 10, 45593},
	{"RODE", 4, 45594},
	{"MARCHING", 8, 45595},
	{"FINV", 4, 45596},
	{"RONNIE", 6, 45597},
	{"ECUP", 4, 45598},
	{"OWING", 5, 45599},
	{"WARP", 4, 45600},
	{"ARKR", 4, 45601},
	{"IMPLANT", 7, 45602},
	{"LACR", 4, 45603},
	{"PLAYLISTS", 9, 45604},
	{"THEMATIC", 8, 45605},
	{"BRENTWOOD", 9, 45606},
	{"CATHOLICS", 9, 45607},
	{"UNLO", 4, 45608},
	{"NBOW", 4, 45609},
	{"RILI", 4, 45610},
	{"CORRECTIONAL", 12, 45611},
	{"LYBI", 4, 45612},
	{"BLYC", 4, 45613},
	{"FACULTIES", 9, 45614},
	{"KATZ", 4, 45615},
	{"DENIES", 6, 45616},
	{"JOJO", 4, 45617},
	{"BUFFERS", 7, 45618},
	{"RDMO", 4, 45619},
	{"TALKBACK", 8, 45620},
	{"NGSG", 4, 45621},
	{"ACTM", 4, 45622},
	{"SERVINGS", 8, 45623},
	{"OOLR", 4, 45624},
	{"LYBL", 4, 45625},
	{"LLRU", 4, 45626},
	{"RYGR", 4, 45627},
	{"KOBE", 4, 45628},
	{"INCEPTION", 9, 45629},
	{"BAYLOR", 6, 45630},
	{"BOWMAN", 6, 45631},
	{"FRUSTRATING", 11, 45632},
	{"SUBVERSION", 10, 45633},
	{"BENNY", 5, 45634},
	{"SPIRES", 6, 45635},
	{"UNBY", 4, 45636},
	{"BARNEY", 6, 45637},
	{"DINNERWARE", 10, 45638},
	{"FYK", 3, 45639},
	{"BYFR", 4, 45640},
	{"BYRA", 4, 45641},
	{"SCLEROSIS", 9, 45642},
	{"RLYN", 4, 45643},
	{"PTCY", 4, 45644},
	{"RUET", 4, 45645},
	{"DECLARES", 8, 45646},
	{"ACYO", 4, 45647},
	{"MASONRY", 7, 45648},
	{"RONB", 4, 45649},
	{"DEOU", 4, 45650},
	{"MEDICINAL", 9, 45651},
	{"ESTROGEN", 8, 45652},
	{"ODBC", 4, 45653},
	{"IPODS", 5, 45654},
	{"FMEN", 4, 45655},
	{"OPSW", 4, 45656},
	{"ACCRUED", 7, 45657},
	{"TEMPLES", 7, 45658},
	{"REALIZING", 9, 45659},
	{"ANNUM", 5, 45660},
	{"TOPB", 4, 45661},
	{"OPENBSD", 7, 45662},
	{"CEMETERIES", 10, 45663},
	{"INDOORS", 7, 45664},
	{"MBIG", 4, 45665},
	{"TELESCOPES", 10, 45666},
	{"AVOL", 4, 45667},
	{"DMOU", 4, 45668},
	{"RDOM", 4, 45669},
	{"LFWI", 4, 45670},
	{"OLDN", 4, 45671},
	{"MAGELLAN", 8, 45672},
	{"NCYR", 4, 45673},
	{"CHAMPS", 6, 45674},
	{"DVIE", 4, 45675},
	{"OGYO", 4, 45676},
	{"AWRI", 4, 45677},
	{"ISFL", 4, 45678},
	{"FEDERATED", 9, 45679},
	{"YILL", 4, 45680},
	{"AVERAGING", 9, 45681},
	{"RAGM", 4, 45682},
	{"SALADS", 6, 45683},
	{"IDOW", 4, 45684},
	{"CBOO", 4, 45685},
	{"ADDICTED", 8, 45686},
	{"FLASHLIGHT", 10, 45687},
	{"DISAPPOINTING", 13, 45688},
	{"ROCKFORD", 8, 45689},
	{"EIGHTY", 6, 45690},
	{"STAGING", 7, 45691},
	{"UNLOCKED", 8, 45692},
	{"SCARCE", 6, 45693},
	{"RDAI", 4, 45694},
	{"XHAU", 4, 45695},
	{"AMSB", 4, 45696},
	{"STATISTIC", 9, 45697},
	{"CKWO", 4, 45698},
	{"ROCHE", 5, 45699},
	{"ROPES", 5, 45700},
	{"TORINO", 6, 45701},
	{"SPIDERS", 7, 45702},
	{"OBEDIENCE", 9, 45703},
	{"YSKI", 4, 45704},
	{"YMEE", 4, 45705},
	{"GHAP", 4, 45706},
	{"PLAGUE", 6, 45707},
	{"DILUTED", 7, 45708},
	{"CANINE", 6, 45709},
	{"GLADLY", 6, 45710},
	{"SCHIZOPHRENIA", 13, 45711},
	{"BREWERY", 7, 45712},
	{"ULLF", 4, 45713},
	{"LINEAGE", 7, 45714},
	{"MEHR", 4, 45715},
	{"BREW", 4, 45716},
	{"VAUGHAN", 7, 45717},
	{"KERN", 4, 45718},
	{"CERW", 4, 45719},
	{"JULIUS", 6, 45720},
	{"CANNES", 6, 45721},
	{"AFED", 4, 45722},
	{"MORSE", 5, 45723},
	{"UTFE", 4, 45724},
	{"CTRU", 4, 45725},
	{"USGO", 4, 45726},
	{"DOMINANCE", 9, 45727},
	{"PREDATORS", 9, 45728},
	{"PISTON", 6, 45729},
	{"ULSO", 4, 45730},
	{"CORDS", 5, 45731},
	{"GWOM", 4, 45732},
	{"REVISITED", 9, 45733},
	{"UBSA", 4, 45734},
	{"AYTR", 4, 45735},
	{"EWPA", 4, 45736},
	{"SEALING", 7, 45737},
	{"TOPPED", 6, 45738},
	{"ADHESIVES", 9, 45739},
	{"DESPAIR", 7, 45740},
	{"ILLV", 4, 45741},
	{"OTBU", 4, 45742},
	{"BUYT", 4, 45743},
	{"INVENTORIES", 11, 45744},
	{"FORE", 4, 45745},
	{"FTBA", 4, 45746},
	{"BROKEBACK", 9, 45747},
	{"INJECTED", 8, 45748},
	{"NDEU", 4, 45749},
	{"IEDU", 4, 45750},
	{"USKI", 4, 45751},
	{"ALPS", 4, 45752},
	{"BYDO", 4, 45753},
	{"COMMODORE", 9, 45754},
	{"DUMPING", 7, 45755},
	{"ENLISTED", 8, 45756},
	{"PROPHETS", 8, 45757},
	{"RCLU", 4, 45758},
	{"LLDR", 4, 45759},
	{"AFIV", 4, 45760},
	{"WAREZ", 5, 45761},
	{"DBEW", 4, 45762},
	{"KSBU", 4, 45763},
	{"UNGI", 4, 45764},
	{"FFRI", 4, 45765},
	{"XPIR", 4, 45766},
	{"SUPERNATURAL", 12, 45767},
	{"OVERLOOKED", 10, 45768},
	{"MAGENTA", 7, 45769},
	{"TAGGING", 7, 45770},
	{"ANKW", 4, 45771},
	{"DITCH", 5, 45772},
	{"GEVI", 4, 45773},
	{"FEARED", 6, 45774},
	{"PRELUDE", 7, 45775},
	{"YCOA", 4, 45776},
	{"UZZL", 4, 45777},
	{"EEPU", 4, 45778},
	{"WYU", 3, 45779},
	{"VKL", 3, 45780},
	{"GCZ", 3, 45781},
	{"SMOF", 4, 45782},
	{"ROWE", 4, 45783},
	{"SLICK", 5, 45784},
	{"UEWH", 4, 45785},
	{"OVERLY", 6, 45786},
	{"LIMESTONE", 9, 45787},
	{"ODIV", 4, 45788},
	{"LKSW", 4, 45789},
	{"TRIGGERS", 8, 45790},
	{"COMMENTARIES", 12, 45791},
	{"CONSTRUCTS", 10, 45792},
	{"IMPEDANCE", 9, 45793},
	{"ULEO", 4, 45794},
	{"DRAGONFLY", 9, 45795},
	{"MANPOWER", 8, 45796},
	{"UNDEROATH", 9, 45797},
	{"EAKD", 4, 45798},
	{"WCOU", 4, 45799},
	{"ELSP", 4, 45800},
	{"REELS", 5, 45801},
	{"ALSR", 4, 45802},
	{"SLEPT", 5, 45803},
	{"RGAS", 4, 45804},
	{"UPRO", 4, 45805},
	{"GREGG", 5, 45806},
	{"REFUNDABLE", 10, 45807},
	{"RTSD", 4, 45808},
	{"EJUR", 4, 45809},
	{"BILLBOARD", 9, 45810},
	{"DLIM", 4, 45811},
	{"DRAFTED", 7, 45812},
	{"CHALET", 6, 45813},
	{"HUANG", 5, 45814},
	{"DSIL", 4, 45815},
	{"SPORTSBOOK", 10, 45816},
	{"LAYERED", 7, 45817},
	{"NTYR", 4, 45818},
	{"HOPPER", 6, 45819},
	{"LLVI", 4, 45820},
	{"NEUROLOGICAL", 12, 45821},
	{"DBYK", 4, 45822},
	{"SUBS", 4, 45823},
	{"SPECIALIZATION", 14, 45824},
	{"NTDU", 4, 45825},
	{"LETC", 4, 45826},
	{"ABSTRACTION", 11, 45827},
	{"YPRA", 4, 45828},
	{"RCHY", 4, 45829},
	{"LUDWIG", 6, 45830},
	{"WATCHDOG", 8, 45831},
	{"RPLU", 4, 45832},
	{"ENBL", 4, 45833},
	{"SCANDINAVIAN", 12, 45834},
	{"RRAD", 4, 45835},
	{"STARBUCKS", 9, 45836},
	{"IBOOK", 5, 45837},
	{"MYDA", 4, 45838},
	{"VIABILITY", 9, 45839},
	{"DETAINED", 8, 45840},
	{"LUNCHEON", 8, 45841},
	{"DUPF", 4, 45842},
	{"FILLER", 6, 45843},
	{"SMILEY", 6, 45844},
	{"ZENITH", 6, 45845},
	{"GENOMICS", 8, 45846},
	{"OUFO", 4, 45847},
	{"YUM", 3, 45848},
	{"BROWNS", 6, 45849},
	{"RDCH", 4, 45850},
	{"RESEARCHED", 10, 45851},
	{"WAITS", 5, 45852},
	{"WOMI", 4, 45853},
	{"TENOR", 5, 45854},
	{"HADV", 4, 45855},
	{"COPIERS", 7, 45856},
	{"OVARIAN", 7, 45857},
	{"PLENARY", 7, 45858},
	{"SCRUB", 5, 45859},
	{"IFOU", 4, 45860},
	{"BOYF", 4, 45861},
	{"BLAI", 4, 45862},
	{"RPAI", 4, 45863},
	{"AIRPLANES", 9, 45864},
	{"WILKINSON", 9, 45865},
	{"LYEL", 4, 45866},
	{"INTESTINAL", 10, 45867},
	{"WCZ", 3, 45868},
	{"CELLO", 5, 45869},
	{"WLAN", 4, 45870},
	{"GCLO", 4, 45871},
	{"MMUT", 4, 45872},
	{"REFUSING", 8, 45873},
	{"SUFFERS", 7, 45874},
	{"RMEE", 4, 45875},
	{"SWEEPSTAKES", 11, 45876},
	{"UPSH", 4, 45877},
	{"ANFL", 4, 45878},
	{"EAMD", 4, 45879},
	{"ANTIGENS", 8, 45880},
	{"MIDTOWN", 7, 45881},
	{"BETHLEHEM", 9, 45882},
	{"XXM", 3, 45883},
	{"STABILIZATION", 13, 45884},
	{"CAVES", 5, 45885},
	{"ACH