cmake_minimum_required(VERSION 3.2)

set(DEVKITPRO $ENV{DEVKITPRO})

set(CMAKE_SYSTEM_NAME Generic)
set(CMAKE_SYSTEM_VERSION 1)
set(CMAKE_SYSTEM_PROCESSOR "aarch64")
set(CMAKE_CROSSCOMPILING 1)

set(TOOL_PREFIX ${DEVKITPRO}/devkitA64/bin/aarch64-none-elf-)

if(WIN32)
    set(TOOL_EXTENSION .exe)
endif()

set(CMAKE_ASM_COMPILER ${TOOL_PREFIX}gcc${TOOL_EXTENSION}    CACHE PATH "")
set(CMAKE_C_COMPILER   ${TOOL_PREFIX}gcc${TOOL_EXTENSION}    CACHE PATH "")
set(CMAKE_CXX_COMPILER ${TOOL_PREFIX}g++${TOOL_EXTENSION}    CACHE PATH "")
set(CMAKE_LINKER       ${TOOL_PREFIX}g++${TOOL_EXTENSION}    CACHE PATH "")
set(CMAKE_AR           ${TOOL_PREFIX}ar${TOOL_EXTENSION}     CACHE PATH "")
set(CMAKE_STRIP        ${TOOL_PREFIX}strip${TOOL_EXTENSION}  CACHE PATH "")

set(CMAKE_FIND_ROOT_PATH_MODE_PROGRAM BOTH)
set(CMAKE_FIND_ROOT_PATH_MODE_LIBRARY ONLY)
set(CMAKE_FIND_ROOT_PATH_MODE_INCLUDE ONLY)
set(CMAKE_FIND_ROOT_PATH_MODE_PACKAGE ONLY)

SET(BUILD_SHARED_LIBS OFF CACHE INTERNAL "Shared libs not available" )

set (DKA_SWITCH_C_FLAGS "-D__SWITCH__ -march=armv8-a+crc+crypto -mtune=cortex-a57 -mtp=soft -ftls-model=local-exec -fPIE -ffunction-sections -fdata-sections  -L${DEVKITPRO}/portlibs/switch/lib -L${DEVKITPRO}/libnx/lib -specs=${DEVKITPRO}/libnx/switch.specs")
set(CMAKE_C_FLAGS   "${DKA_SWITCH_C_FLAGS}" CACHE STRING "")
set(CMAKE_CXX_FLAGS "${DKA_SWITCH_C_FLAGS}" CACHE STRING "")
set(CMAKE_ASM_FLAGS "${DKA_SWITCH_C_FLAGS}" CACHE STRING "")

set(CMAKE_EXE_LINKER_FLAGS "${CMAKE_EXE_LINKER_FLAGS}")

set(CMAKE_FIND_ROOT_PATH
  ${DEVKITPRO}/devkitA64
  ${DEVKITPRO}/tools
  ${DEVKITPRO}/portlibs/switch
  ${DEVKITPRO}/libnx
)

# Set pkg-config for the same
find_program(PKG_CONFIG_EXECUTABLE NAMES aarch64-none-elf-pkg-config HINTS "${DEVKITPRO}/portlibs/switch/bin")
if (NOT PKG_CONFIG_EXECUTABLE)
   message(WARNING "Could not find aarch64-none-elf-pkg-config: try installing switch-pkg-config")
endif()

set(NSWITCH TRUE)

set(NX_ROOT ${DEVKITPRO}/libnx)
set(CMAKE_PREFIX_PATH "${DEVKITPRO}/portlibs/switch")

set(NX_STANDARD_LIBRARIES "${NX_ROOT}/lib/libnx.a")
set(CMAKE_C_STANDARD_LIBRARIES "${NX_STANDARD_LIBRARIES}" CACHE STRING "")
set(CMAKE_CXX_STANDARD_LIBRARIES "${NX_STANDARD_LIBRARIES}" CACHE STRING "")
set(CMAKE_ASM_STANDARD_LIBRARIES "${NX_STANDARD_LIBRARIES}" CACHE STRING "")

#for some reason cmake (3.14.3) doesn't appreciate having \" here
set(NX_STANDARD_INCLUDE_DIRECTORIES "${NX_ROOT}/include")
set(CMAKE_C_STANDARD_INCLUDE_DIRECTORIES "${NX_STANDARD_INCLUDE_DIRECTORIES}" CACHE STRING "")
set(CMAKE_CXX_STANDARD_INCLUDE_DIRECTORIES "${NX_STANDARD_INCLUDE_DIRECTORIES}" CACHE STRING "")
set(CMAKE_ASM_STANDARD_INCLUDE_DIRECTORIES "${NX_STANDARD_INCLUDE_DIRECTORIES}" CACHE STRING "")
