# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.monitor.aio import MonitorManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestMonitorManagementActivityLogAlertsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(MonitorManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_activity_log_alerts_create_or_update(self, resource_group):
        response = await self.client.activity_log_alerts.create_or_update(
            resource_group_name=resource_group.name,
            activity_log_alert_name="str",
            activity_log_alert_rule={
                "actions": {"actionGroups": [{"actionGroupId": "str", "webhookProperties": {"str": "str"}}]},
                "condition": {
                    "allOf": [
                        {
                            "anyOf": [{"containsAny": ["str"], "equals": "str", "field": "str"}],
                            "containsAny": ["str"],
                            "equals": "str",
                            "field": "str",
                        }
                    ]
                },
                "description": "str",
                "enabled": True,
                "id": "str",
                "location": "global",
                "name": "str",
                "scopes": ["str"],
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2020-10-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_activity_log_alerts_get(self, resource_group):
        response = await self.client.activity_log_alerts.get(
            resource_group_name=resource_group.name,
            activity_log_alert_name="str",
            api_version="2020-10-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_activity_log_alerts_delete(self, resource_group):
        response = await self.client.activity_log_alerts.delete(
            resource_group_name=resource_group.name,
            activity_log_alert_name="str",
            api_version="2020-10-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_activity_log_alerts_update(self, resource_group):
        response = await self.client.activity_log_alerts.update(
            resource_group_name=resource_group.name,
            activity_log_alert_name="str",
            activity_log_alert_rule_patch={"enabled": True, "tags": {"str": "str"}},
            api_version="2020-10-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_activity_log_alerts_list_by_subscription_id(self, resource_group):
        response = self.client.activity_log_alerts.list_by_subscription_id(
            api_version="2020-10-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_activity_log_alerts_list_by_resource_group(self, resource_group):
        response = self.client.activity_log_alerts.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2020-10-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
