# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.resource.policy import PolicyClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-resource
# USAGE
    python create_or_update_policy_set_definition_version.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = PolicyClient(
        credential=DefaultAzureCredential(),
        subscription_id="ae640e6b-ba3e-4256-9d62-2993eecfa6f2",
    )

    response = client.policy_set_definition_versions.create_or_update(
        policy_set_definition_name="CostManagement",
        policy_definition_version="1.2.1",
        parameters={
            "properties": {
                "description": "Policies to enforce low cost storage SKUs",
                "displayName": "Cost Management",
                "metadata": {"category": "Cost Management"},
                "parameters": {
                    "namePrefix": {
                        "defaultValue": "myPrefix",
                        "metadata": {"displayName": "Prefix to enforce on resource names"},
                        "type": "String",
                    }
                },
                "policyDefinitions": [
                    {
                        "parameters": {"listOfAllowedSKUs": {"value": ["Standard_GRS", "Standard_LRS"]}},
                        "policyDefinitionId": "/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1",
                        "policyDefinitionReferenceId": "Limit_Skus",
                    },
                    {
                        "parameters": {"prefix": {"value": "[parameters('namePrefix')]"}, "suffix": {"value": "-LC"}},
                        "policyDefinitionId": "/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming",
                        "policyDefinitionReferenceId": "Resource_Naming",
                    },
                ],
                "version": "1.2.1",
            }
        },
    )
    print(response)


# x-ms-original-file: specification/resources/resource-manager/Microsoft.Authorization/stable/2023-04-01/examples/createOrUpdatePolicySetDefinitionVersion.json
if __name__ == "__main__":
    main()
